/**
 * math.js
 * https://github.com/josdejong/mathjs
 *
 * Math.js is an extensive math library for JavaScript and Node.js,
 * It features real and complex numbers, units, matrices, a large set of
 * mathematical functions, and a flexible expression parser.
 *
 * @version 3.16.3
 * @date    2017-08-28
 *
 * @license
 * Copyright (C) 2013-2017 Jos de Jong <wjosdejong@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define([],t):"object"==typeof exports?exports.math=t():e.math=t()}(this,function(){return function(e){function t(n){if(r[n])return r[n].exports;var i=r[n]={i:n,l:!1,exports:{}};return e[n].call(i.exports,i,i.exports,t),i.l=!0,i.exports}var r={};return t.m=e,t.c=r,t.d=function(e,r,n){t.o(e,r)||Object.defineProperty(e,r,{configurable:!1,enumerable:!0,get:n})},t.n=function(e){var r=e&&e.__esModule?function(){return e.default}:function(){return e};return t.d(r,"a",r),r},t.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},t.p="",t(t.s=148)}([function(e,t,r){"use strict";function n(e,t,r,n){function i(t,r,n){var i=e.Matrix.storage(r||"default");return new i(t,n)}var a=n("matrix",{"":function(){return i([])},string:function(e){return i([],e)},"string, string":function(e,t){return i([],e,t)},Array:function(e){return i(e)},Matrix:function(e){return i(e,e.storage())},"Array | Matrix, string":i,"Array | Matrix, string, string":i});return a.toTex={0:"\\begin{bmatrix}\\end{bmatrix}",1:"\\left(${args[0]}\\right)",2:"\\left(${args[0]}\\right)"},a}t.name="matrix",t.factory=n},function(e,t,r){"use strict";e.exports=function e(t,r,n){return t&&"function"==typeof t.map?t.map(function(t){return e(t,r,n)}):r(t)}},function(e,t,r){"use strict";function n(e,t,r){var i,a=e.length;if(a!=t[r])throw new f(a,t[r]);if(r<t.length-1){var o=r+1;for(i=0;i<a;i++){var s=e[i];if(!Array.isArray(s))throw new f(t.length-1,t.length,"<");n(e[i],t,o)}}else for(i=0;i<a;i++)if(Array.isArray(e[i]))throw new f(t.length+1,t.length,">")}function i(e,r,n,a){var o,s,u=e.length,c=r[n],f=Math.min(u,c);if(e.length=c,n<r.length-1){var l=n+1;for(o=0;o<f;o++)s=e[o],Array.isArray(s)||(s=[s],e[o]=s),i(s,r,l,a);for(o=f;o<c;o++)s=[],e[o]=s,i(s,r,l,a)}else{for(o=0;o<f;o++)for(;Array.isArray(e[o]);)e[o]=e[o][0];if(a!==t.UNINITIALIZED)for(o=f;o<c;o++)e[o]=a}}function a(e,t){var r,n=[];if(0===t.length){if(0===e.length)throw new f(null,null,"!=");return e.shift()}for(r=0;r<t[0];r+=1)n.push(a(e,t.slice(1)));return n}function o(e,t,r){var n,i;if(r<t){var a=r+1;for(n=0,i=e.length;n<i;n++)e[n]=o(e[n],t,a)}else for(;Array.isArray(e);)e=e[0];return e}function s(e,t,r){var n,i;if(Array.isArray(e)){var a=r+1;for(n=0,i=e.length;n<i;n++)e[n]=s(e[n],t,a)}else for(var o=r;o<t;o++)e=[e];return e}var u=r(3),c=r(9),f=(r(5),r(59),r(10)),l=r(51);t.size=function(e){for(var t=[];Array.isArray(e);)t.push(e.length),e=e[0];return t},t.validate=function(e,t){var r=0==t.length;if(r){if(Array.isArray(e))throw new f(e.length,0)}else n(e,t,0)},t.validateIndex=function(e,t){if(!u.isNumber(e)||!u.isInteger(e))throw new TypeError("Index must be an integer (value: "+e+")");if(e<0||"number"==typeof t&&e>=t)throw new l(e,t)},t.UNINITIALIZED={},t.resize=function(e,t,r){if(!Array.isArray(e)||!Array.isArray(t))throw new TypeError("Array expected");if(0===t.length)throw new Error("Resizing to scalar is not supported");t.forEach(function(e){if(!u.isNumber(e)||!u.isInteger(e)||e<0)throw new TypeError("Invalid size, must contain positive integers (size: "+c.format(t)+")")});var n=void 0!==r?r:0;return i(e,t,0,n),e},t.reshape=function(e,r){var n,i=t.flatten(e),o=function(e){return e.reduce(function(e,t){return e*t})};if(!Array.isArray(e)||!Array.isArray(r))throw new TypeError("Array expected");if(0===r.length)throw new f(0,o(t.size(e)),"!=");try{n=a(i,r)}catch(n){if(n instanceof f)throw new f(o(r),o(t.size(e)),"!=");throw n}if(i.length>0)throw new f(o(r),o(t.size(e)),"!=");return n},t.squeeze=function(e,r){for(var n=r||t.size(e);Array.isArray(e)&&1===e.length;)e=e[0],n.shift();for(var i=n.length;1===n[i-1];)i--;return i<n.length&&(e=o(e,i,0),n.length=i),e},t.unsqueeze=function(e,r,n,i){var a=i||t.size(e);if(n)for(var o=0;o<n;o++)e=[e],a.unshift(1);for(e=s(e,r,0);a.length<r;)a.push(1);return e},t.flatten=function(e){if(!Array.isArray(e))return e;var t=[];return e.forEach(function e(r){Array.isArray(r)?r.forEach(e):t.push(r)}),t},t.map=function(e,t){return Array.prototype.map.call(e,t)},t.forEach=function(e,t){Array.prototype.forEach.call(e,t)},t.filter=function(e,r){if(1!==t.size(e).length)throw new Error("Only one dimensional matrices supported");return Array.prototype.filter.call(e,r)},t.filterRegExp=function(e,r){if(1!==t.size(e).length)throw new Error("Only one dimensional matrices supported");return Array.prototype.filter.call(e,function(e){return r.test(e)})},t.join=function(e,t){return Array.prototype.join.call(e,t)},t.identify=function(e){if(!Array.isArray(e))throw new TypeError("Array input expected");if(0===e.length)return e;var t=[],r=0;t[0]={value:e[0],identifier:0};for(var n=1;n<e.length;n++)e[n]===e[n-1]?r++:r=0,t.push({value:e[n],identifier:r});return t},t.generalize=function(e){if(!Array.isArray(e))throw new TypeError("Array input expected");if(0===e.length)return e;for(var t=[],r=0;r<e.length;r++)t.push(e[r].value);return t},t.isArray=Array.isArray},function(e,t,r){"use strict";function n(e){for(var t=[],r=0;r<e;r++)t.push(0);return t}t.isNumber=function(e){return"number"==typeof e},t.isInteger=function(e){return!!isFinite(e)&&e==Math.round(e)},t.sign=Math.sign||function(e){return e>0?1:e<0?-1:0},t.format=function(e,r){if("function"==typeof r)return r(e);if(e===1/0)return"Infinity";if(e===-(1/0))return"-Infinity";if(isNaN(e))return"NaN";var n="auto",i=void 0;switch(r&&(r.notation&&(n=r.notation),t.isNumber(r)?i=r:r.precision&&(i=r.precision)),n){case"fixed":return t.toFixed(e,i);case"exponential":return t.toExponential(e,i);case"engineering":return t.toEngineering(e,i);case"auto":return t.toPrecision(e,i,r&&r.exponential).replace(/((\.\d*?)(0+))($|e)/,function(){var e=arguments[2],t=arguments[4];return"."!==e?e+t:t});default:throw new Error('Unknown notation "'+n+'". Choose "auto", "exponential", or "fixed".')}},t.splitNumber=function(e){var t=String(e).toLowerCase().match(/^0*?(-?)(\d+\.?\d*)(e([+-]?\d+))?$/);if(!t)throw new SyntaxError("Invalid number "+e);var r=t[1],n=t[2],i=parseFloat(t[4]||"0"),a=n.indexOf(".");i+=a!==-1?a-1:n.length-1;var o=n.replace(".","").replace(/^0*/,function(e){return i-=e.length,""}).replace(/0*$/,"").split("").map(function(e){return parseInt(e)});return 0===o.length&&(o.push(0),i++),{sign:r,coefficients:o,exponent:i}},t.toEngineering=function(e,r){if(isNaN(e)||!isFinite(e))return String(e);var i=t.roundDigits(t.splitNumber(e),r),a=i.exponent,o=i.coefficients,s=a%3===0?a:a<0?a-3-a%3:a-a%3,u=a>=0?a:Math.abs(s);o.length-1<u&&(o=o.concat(n(u-(o.length-1))));for(var c=Math.abs(a-s),f=1;--c>=0;)f++;var l=o.slice(f).join(""),p=l.match(/[1-9]/)?"."+l:"",h=o.slice(0,f).join("")+p+"e"+(a>=0?"+":"")+s.toString();return i.sign+h},t.toFixed=function(e,r){if(isNaN(e)||!isFinite(e))return String(e);var i=t.splitNumber(e),a=t.roundDigits(i,i.exponent+1+(r||0)),o=a.coefficients,s=a.exponent+1,u=s+(r||0);return o.length<u&&(o=o.concat(n(u-o.length))),s<0&&(o=n(-s+1).concat(o),s=1),r&&o.splice(s,0,0===s?"0.":"."),a.sign+o.join("")},t.toExponential=function(e,r){if(isNaN(e)||!isFinite(e))return String(e);var i=t.splitNumber(e),a=r?t.roundDigits(i,r):i,o=a.coefficients,s=a.exponent;o.length<r&&(o=o.concat(n(r-o.length)));var u=o.shift();return a.sign+u+(o.length>0?"."+o.join(""):"")+"e"+(s>=0?"+":"")+s},t.toPrecision=function(e,r,i){if(isNaN(e)||!isFinite(e))return String(e);var a=i&&void 0!==i.lower?i.lower:.001,o=i&&void 0!==i.upper?i.upper:1e5,s=t.splitNumber(e),u=Math.abs(Math.pow(10,s.exponent));if(u<a||u>=o)return t.toExponential(e,r);var c=r?t.roundDigits(s,r):s,f=c.coefficients,l=c.exponent;f.length<r&&(f=f.concat(n(r-f.length))),f=f.concat(n(l-f.length+1+(f.length<r?r-f.length:0))),f=n(-l).concat(f);var p=l>0?l:0;return p<f.length-1&&f.splice(p+1,0,"."),c.sign+f.join("")},t.roundDigits=function(e,t){for(var r={sign:e.sign,coefficients:e.coefficients,exponent:e.exponent},n=r.coefficients;t<=0;)n.unshift(0),r.exponent++,t++;if(n.length>t){var i=n.splice(t,n.length-t);if(i[0]>=5){var a=t-1;for(n[a]++;10===n[a];)n.pop(),0===a&&(n.unshift(0),r.exponent++,a++),a--,n[a]++}}return r},t.digits=function(e){return e.toExponential().replace(/e.*$/,"").replace(/^0\.?0*|\./,"").length},t.DBL_EPSILON=Number.EPSILON||2.220446049250313e-16,t.nearlyEqual=function(e,r,n){if(null==n)return e==r;if(e==r)return!0;if(isNaN(e)||isNaN(r))return!1;if(isFinite(e)&&isFinite(r)){var i=Math.abs(e-r);return i<t.DBL_EPSILON||i<=Math.max(Math.abs(e),Math.abs(r))*n}return!1}},function(e,t,r){"use strict";t.symbols={Alpha:"A",alpha:"\\alpha",Beta:"B",beta:"\\beta",Gamma:"\\Gamma",gamma:"\\gamma",Delta:"\\Delta",delta:"\\delta",Epsilon:"E",epsilon:"\\epsilon",varepsilon:"\\varepsilon",Zeta:"Z",zeta:"\\zeta",Eta:"H",eta:"\\eta",Theta:"\\Theta",theta:"\\theta",vartheta:"\\vartheta",Iota:"I",iota:"\\iota",Kappa:"K",kappa:"\\kappa",varkappa:"\\varkappa",Lambda:"\\Lambda",lambda:"\\lambda",Mu:"M",mu:"\\mu",Nu:"N",nu:"\\nu",Xi:"\\Xi",xi:"\\xi",Omicron:"O",omicron:"o",Pi:"\\Pi",pi:"\\pi",varpi:"\\varpi",Rho:"P",rho:"\\rho",varrho:"\\varrho",Sigma:"\\Sigma",sigma:"\\sigma",varsigma:"\\varsigma",Tau:"T",tau:"\\tau",Upsilon:"\\Upsilon",upsilon:"\\upsilon",Phi:"\\Phi",phi:"\\phi",varphi:"\\varphi",Chi:"X",chi:"\\chi",Psi:"\\Psi",psi:"\\psi",Omega:"\\Omega",omega:"\\omega",true:"\\mathrm{True}",false:"\\mathrm{False}",i:"i",inf:"\\infty",Inf:"\\infty",infinity:"\\infty",Infinity:"\\infty",oo:"\\infty",lim:"\\lim",undefined:"\\mathbf{?}"},t.operators={transpose:"^\\top",factorial:"!",pow:"^",dotPow:".^\\wedge",unaryPlus:"+",unaryMinus:"-",bitNot:"~",not:"\\neg",multiply:"\\cdot",divide:"\\frac",dotMultiply:".\\cdot",dotDivide:".:",mod:"\\mod",add:"+",subtract:"-",to:"\\rightarrow",leftShift:"<<",rightArithShift:">>",rightLogShift:">>>",equal:"=",unequal:"\\neq",smaller:"<",larger:">",smallerEq:"\\leq",largerEq:"\\geq",bitAnd:"\\&",bitXor:"\\underline{|}",bitOr:"|",and:"\\wedge",xor:"\\veebar",or:"\\vee"},t.defaultTemplate="\\mathrm{${name}}\\left(${args}\\right)";var n={deg:"^\\circ"};t.toSymbol=function(e,r){if(r="undefined"!=typeof r&&r)return n.hasOwnProperty(e)?n[e]:"\\mathrm{"+e+"}";if(t.symbols.hasOwnProperty(e))return t.symbols[e];if(e.indexOf("_")!==-1){var i=e.indexOf("_");return t.toSymbol(e.substring(0,i))+"_{"+t.toSymbol(e.substring(i+1))+"}"}return e}},function(e,t,r){"use strict";var n=r(71);t.clone=function e(r){var i=typeof r;if("number"===i||"string"===i||"boolean"===i||null===r||void 0===r)return r;if("function"==typeof r.clone)return r.clone();if(Array.isArray(r))return r.map(function(t){return e(t)});if(r instanceof Number)return new Number(r.valueOf());if(r instanceof String)return new String(r.valueOf());if(r instanceof Boolean)return new Boolean(r.valueOf());if(r instanceof Date)return new Date(r.valueOf());if(n(r))return r;if(r instanceof RegExp)throw new TypeError("Cannot clone "+r);return t.map(r,e)},t.map=function(e,r){var n={};for(var i in e)t.hasOwnProperty(e,i)&&(n[i]=r(e[i]));return n},t.extend=function(e,r){for(var n in r)t.hasOwnProperty(r,n)&&(e[n]=r[n]);return e},t.deepExtend=function e(r,n){if(Array.isArray(n))throw new TypeError("Arrays are not supported by deepExtend");for(var i in n)if(t.hasOwnProperty(n,i))if(n[i]&&n[i].constructor===Object)void 0===r[i]&&(r[i]={}),r[i].constructor===Object?e(r[i],n[i]):r[i]=n[i];else{if(Array.isArray(n[i]))throw new TypeError("Arrays are not supported by deepExtend");r[i]=n[i]}return r},t.deepEqual=function(e,r){var n,i,a;if(Array.isArray(e)){if(!Array.isArray(r))return!1;if(e.length!=r.length)return!1;for(i=0,a=e.length;i<a;i++)if(!t.deepEqual(e[i],r[i]))return!1;return!0}if(e instanceof Object){if(Array.isArray(r)||!(r instanceof Object))return!1;for(n in e)if(!t.deepEqual(e[n],r[n]))return!1;for(n in r)if(!t.deepEqual(e[n],r[n]))return!1;return!0}return typeof e==typeof r&&e==r},t.canDefineProperty=function(){try{if(Object.defineProperty)return Object.defineProperty({},"x",{get:function(){}}),!0}catch(e){}return!1},t.lazy=function(e,r,n){if(t.canDefineProperty()){var i,a=!0;Object.defineProperty(e,r,{get:function(){return a&&(i=n(),a=!1),i},set:function(e){i=e,a=!1},configurable:!0,enumerable:!0})}else e[r]=n()},t.traverse=function(e,t){var r=e;if(t)for(var n=t.split("."),i=0;i<n.length;i++){var a=n[i];a in r||(r[a]={}),r=r[a]}return r},t.hasOwnProperty=function(e,t){return e&&Object.hasOwnProperty.call(e,t)},t.isFactory=function(e){return e&&"function"==typeof e.factory}},function(e,t,r){"use strict";function n(e,t,r,n){var a=e.DenseMatrix,o=function(e,t,r,o){var u,c=e._data,f=e._size,l=e._datatype,p=r;"string"==typeof l&&(u=l,t=n.convert(t,u),p=n.find(r,[u,u]));var h=f.length>0?s(p,0,f,f[0],c,t,o):[];return new a({data:h,size:i(f),datatype:u})},s=function(e,t,r,n,i,a,o){var u=[];if(t===r.length-1)for(var c=0;c<n;c++)u[c]=o?e(a,i[c]):e(i[c],a);else for(var f=0;f<n;f++)u[f]=s(e,t+1,r,r[t+1],i[f],a,o);return u};return o}var i=r(5).clone;t.name="algorithm14",t.factory=n},function(e,t,r){function n(){function e(e,t){if(void 0!==r[e])throw new Error('Cannot register type "'+e+'": already exists');r[e]=t}function t(e,t,n){if(i(r,e.type)){var a=r[e.type];return a(e,t,n)}if("function"!=typeof e._compile||i(e,"_compile"))throw new Error('Cannot compile node: unknown type "'+e.type+'"');return e._compile(t,n)}var r={};return{register:e,compile:t}}var i=r(5).hasOwnProperty;t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var i=e.DenseMatrix,o=function(e,t,r){var o=e._data,u=e._size,c=e._datatype,f=t._data,l=t._size,p=t._datatype,h=[];if(u.length!==l.length)throw new a(u.length,l.length);for(var m=0;m<u.length;m++){if(u[m]!==l[m])throw new RangeError("Dimension mismatch. Matrix A ("+u+") must match Matrix B ("+l+")");h[m]=u[m]}var d,v=r;"string"==typeof c&&c===p&&(d=c,t=n.convert(t,d),v=n.find(r,[d,d]));var g=h.length>0?s(v,0,h,h[0],o,f):[];return new i({data:g,size:h,datatype:d})},s=function(e,t,r,n,i,a){var o=[];if(t===r.length-1)for(var u=0;u<n;u++)o[u]=e(i[u],a[u]);else for(var c=0;c<n;c++)o[c]=s(e,t+1,r,r[t+1],i[c],a[c]);return o};return o}var i=r(25),a=r(10),o=i.string;o.isString;t.name="algorithm13",t.factory=n},function(e,t,r){"use strict";function n(e,r){if(Array.isArray(e)){for(var i="[",a=e.length,o=0;o<a;o++)0!=o&&(i+=", "),i+=n(e[o],r);return i+="]"}return t.format(e,r)}function i(e){return e&&"object"==typeof e&&"number"==typeof e.s&&"number"==typeof e.n&&"number"==typeof e.d||!1}var a=r(3).format,o=r(165).format,s=r(71);t.isString=function(e){return"string"==typeof e},t.endsWith=function(e,t){var r=e.length-t.length,n=e.length;return e.substring(r,n)===t},t.format=function(e,r){if("number"==typeof e)return a(e,r);if(s(e))return o(e,r);if(i(e))return r&&"decimal"===r.fraction?e.toString():e.s*e.n+"/"+e.d;if(Array.isArray(e))return n(e,r);if(t.isString(e))return'"'+e+'"';if("function"==typeof e)return e.syntax?String(e.syntax):"function";if(e&&"object"==typeof e){if("function"==typeof e.format)return e.format(r);if(e&&e.toString()!=={}.toString())return e.toString();var u=[];for(var c in e)e.hasOwnProperty(c)&&u.push('"'+c+'": '+t.format(e[c],r));return"{"+u.join(", ")+"}"}return String(e)},t.stringify=function(e){for(var t=String(e),r="",n=0;n<t.length;){var i=t.charAt(n);"\\"===i?(r+=i,n++,i=t.charAt(n),""!==i&&'"\\/bfnrtu'.indexOf(i)!==-1||(r+="\\"),r+=i):r+='"'===i?'\\"':i,n++}return'"'+r+'"'},t.escape=function(e){var t=String(e);return t=t.replace(/&/g,"&amp;").replace(/"/g,"&quot;").replace(/'/g,"&#39;").replace(/</g,"&lt;").replace(/>/g,"&gt;")}},function(e,t,r){"use strict";function n(e,t,r){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");this.actual=e,this.expected=t,this.relation=r,this.message="Dimension mismatch ("+(Array.isArray(e)?"["+e.join(", ")+"]":e)+" "+(this.relation||"!=")+" "+(Array.isArray(t)?"["+t.join(", ")+"]":t)+")",this.stack=(new Error).stack}n.prototype=new RangeError,n.prototype.constructor=RangeError,n.prototype.name="DimensionError",n.prototype.isDimensionError=!0,e.exports=n},function(e,t,r){"use strict";function n(e,t,r,n){var o=n("equalScalar",{"boolean, boolean":function(e,t){return e===t},"number, number":function(e,r){return e===r||i(e,r,t.epsilon)},"BigNumber, BigNumber":function(e,r){return e.eq(r)||a(e,r,t.epsilon)},"Fraction, Fraction":function(e,t){return e.equals(t)},"Complex, Complex":function(e,t){return e.equals(t)},"Unit, Unit":function(e,t){if(!e.equalBase(t))throw new Error("Cannot compare units with different base");return o(e.value,t.value)},"string, string":function(e,t){return e===t}});return o}var i=r(3).nearlyEqual,a=r(35);t.factory=n},function(e,t,r){"use strict";function n(e,t,n,o){var s=r(4),u=n(r(0)),c=n(r(20)),f=n(r(23)),l=n(r(11)),p=n(r(17)),h=n(r(6)),m=e.DenseMatrix,d=e.SparseMatrix,v=o("multiply",i({"Array, Array":function(t,r){g(a.size(t),a.size(r));var n=v(u(t),u(r));return e.isMatrix(n)?n.valueOf():n},"Matrix, Matrix":function(e,t){var r=e.size(),n=t.size();return g(r,n),1===r.length?1===n.length?y(e,t,r[0]):x(e,t):1===n.length?b(e,t):N(e,t)},"Matrix, Array":function(e,t){return v(e,u(t))},"Array, Matrix":function(e,t){return v(u(e,t.storage()),t)},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=p(e,t,f,!1);break;case"dense":r=h(e,t,f,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=p(t,e,f,!0);break;case"dense":r=h(t,e,f,!0)}return r},"Array, any":function(e,t){return h(u(e),t,f,!1).valueOf()},"any, Array":function(e,t){return h(u(t),e,f,!0).valueOf()},"any, any":f,"any, any, ...any":function(e,t,r){for(var n=v(e,t),i=0;i<r.length;i++)n=v(n,r[i]);return n}},f.signatures)),g=function(e,t){switch(e.length){case 1:switch(t.length){case 1:if(e[0]!==t[0])throw new RangeError("Dimension mismatch in multiplication. Vectors must have the same length");break;case 2:if(e[0]!==t[0])throw new RangeError("Dimension mismatch in multiplication. Vector length ("+e[0]+") must match Matrix rows ("+t[0]+")");break;default:throw new Error("Can only multiply a 1 or 2 dimensional matrix (Matrix B has "+t.length+" dimensions)")}break;case 2:switch(t.length){case 1:if(e[1]!==t[0])throw new RangeError("Dimension mismatch in multiplication. Matrix columns ("+e[1]+") must match Vector length ("+t[0]+")");break;case 2:if(e[1]!==t[0])throw new RangeError("Dimension mismatch in multiplication. Matrix A columns ("+e[1]+") must match Matrix B rows ("+t[0]+")");break;default:throw new Error("Can only multiply a 1 or 2 dimensional matrix (Matrix B has "+t.length+" dimensions)")}break;default:throw new Error("Can only multiply a 1 or 2 dimensional matrix (Matrix A has "+e.length+" dimensions)")}},y=function(e,t,r){if(0===r)throw new Error("Cannot multiply two empty vectors");var n,i=e._data,a=e._datatype,s=t._data,u=t._datatype,l=c,p=f;a&&u&&a===u&&"string"==typeof a&&(n=a,l=o.find(c,[n,n]),p=o.find(f,[n,n]));for(var h=p(i[0],s[0]),m=1;m<r;m++)h=l(h,p(i[m],s[m]));return h},x=function(e,t){switch(t.storage()){case"dense":return w(e,t)}throw new Error("Not implemented")},w=function(e,t){var r,n=e._data,i=e._size,a=e._datatype,s=t._data,u=t._size,l=t._datatype,p=i[0],h=u[1],d=c,v=f;a&&l&&a===l&&"string"==typeof a&&(r=a,d=o.find(c,[r,r]),v=o.find(f,[r,r]));for(var g=[],y=0;y<h;y++){for(var x=v(n[0],s[0][y]),w=1;w<p;w++)x=d(x,v(n[w],s[w][y]));g[y]=x}return new m({data:g,size:[h],datatype:r})},b=function(e,t){switch(e.storage()){case"dense":return E(e,t);case"sparse":return O(e,t)}},N=function(e,t){switch(e.storage()){case"dense":switch(t.storage()){case"dense":return M(e,t);case"sparse":return A(e,t)}break;case"sparse":switch(t.storage()){case"dense":return T(e,t);case"sparse":return _(e,t)}}},E=function(e,t){var r,n=e._data,i=e._size,a=e._datatype,s=t._data,u=t._datatype,l=i[0],p=i[1],h=c,d=f;a&&u&&a===u&&"string"==typeof a&&(r=a,h=o.find(c,[r,r]),d=o.find(f,[r,r]));for(var v=[],g=0;g<l;g++){for(var y=n[g],x=d(y[0],s[0]),w=1;w<p;w++)x=h(x,d(y[w],s[w]));v[g]=x}return new m({data:v,size:[l],datatype:r})},M=function(e,t){var r,n=e._data,i=e._size,a=e._datatype,s=t._data,u=t._size,l=t._datatype,p=i[0],h=i[1],d=u[1],v=c,g=f;a&&l&&a===l&&"string"==typeof a&&(r=a,v=o.find(c,[r,r]),g=o.find(f,[r,r]));for(var y=[],x=0;x<p;x++){var w=n[x];y[x]=[];for(var b=0;b<d;b++){for(var N=g(w[0],s[0][b]),E=1;E<h;E++)N=v(N,g(w[E],s[E][b]));y[x][b]=N}}return new m({data:y,size:[p,d],datatype:r})},A=function(e,t){var r=e._data,n=e._size,i=e._datatype,a=t._values,s=t._index,u=t._ptr,p=t._size,h=t._datatype;if(!a)throw new Error("Cannot multiply Dense Matrix times Pattern only Matrix");var m,v=n[0],g=p[1],y=c,x=f,w=l,b=0;i&&h&&i===h&&"string"==typeof i&&(m=i,y=o.find(c,[m,m]),x=o.find(f,[m,m]),w=o.find(l,[m,m]),b=o.convert(0,m));for(var N=[],E=[],M=[],A=new d({values:N,index:E,ptr:M,size:[v,g],datatype:m}),O=0;O<g;O++){M[O]=E.length;var T=u[O],_=u[O+1];if(_>T)for(var S=0,C=0;C<v;C++){for(var z,k=C+1,I=T;I<_;I++){var B=s[I];S!==k?(z=x(r[C][B],a[I]),S=k):z=y(z,x(r[C][B],a[I]))}S!==k||w(z,b)||(E.push(C),N.push(z))}}return M[g]=E.length,A},O=function(e,t){var r=e._values,n=e._index,i=e._ptr,a=e._datatype;if(!r)throw new Error("Cannot multiply Pattern only Matrix times Dense Matrix");var s,u=t._data,p=t._datatype,h=e._size[0],m=t._size[0],v=[],g=[],y=[],x=c,w=f,b=l,N=0;a&&p&&a===p&&"string"==typeof a&&(s=a,x=o.find(c,[s,s]),w=o.find(f,[s,s]),b=o.find(l,[s,s]),N=o.convert(0,s));var E=[],M=[];y[0]=0;for(var A=0;A<m;A++){var O=u[A];if(!b(O,N))for(var T=i[A],_=i[A+1],S=T;S<_;S++){var C=n[S];M[C]?E[C]=x(E[C],w(O,r[S])):(M[C]=!0,g.push(C),E[C]=w(O,r[S]))}}for(var z=g.length,k=0;k<z;k++){var I=g[k];v[k]=E[I]}return y[1]=g.length,new d({values:v,index:g,ptr:y,size:[h,1],datatype:s})},T=function(e,t){var r=e._values,n=e._index,i=e._ptr,a=e._datatype;if(!r)throw new Error("Cannot multiply Pattern only Matrix times Dense Matrix");var s,u=t._data,p=t._datatype,h=e._size[0],m=t._size[0],v=t._size[1],g=c,y=f,x=l,w=0;a&&p&&a===p&&"string"==typeof a&&(s=a,g=o.find(c,[s,s]),y=o.find(f,[s,s]),x=o.find(l,[s,s]),w=o.convert(0,s));for(var b=[],N=[],E=[],M=new d({values:b,index:N,ptr:E,size:[h,v],datatype:s}),A=[],O=[],T=0;T<v;T++){E[T]=N.length;for(var _=T+1,S=0;S<m;S++){var C=u[S][T];if(!x(C,w))for(var z=i[S],k=i[S+1],I=z;I<k;I++){var B=n[I];O[B]!==_?(O[B]=_,N.push(B),A[B]=y(C,r[I])):A[B]=g(A[B],y(C,r[I]))}}for(var P=E[T],R=N.length,U=P;U<R;U++){var q=N[U];b[U]=A[q]}}return E[v]=N.length,M},_=function(e,t){var r,n=e._values,i=e._index,a=e._ptr,s=e._datatype,u=t._values,l=t._index,p=t._ptr,h=t._datatype,m=e._size[0],v=t._size[1],g=n&&u,y=c,x=f;s&&h&&s===h&&"string"==typeof s&&(r=s,y=o.find(c,[r,r]),x=o.find(f,[r,r]));for(var w,b,N,E,M,A,O,T,_=g?[]:void 0,S=[],C=[],z=new d({values:_,index:S,ptr:C,size:[m,v],datatype:r}),k=g?[]:void 0,I=[],B=0;B<v;B++){C[B]=S.length;var P=B+1;for(M=p[B],A=p[B+1],E=M;E<A;E++)if(T=l[E],g)for(b=a[T],N=a[T+1],w=b;w<N;w++)O=i[w],I[O]!==P?(I[O]=P,S.push(O),k[O]=x(u[E],n[w])):k[O]=y(k[O],x(u[E],n[w]));else for(b=a[T],N=a[T+1],w=b;w<N;w++)O=i[w],I[O]!==P&&(I[O]=P,S.push(O));if(g)for(var R=C[B],U=S.length,q=R;q<U;q++){var L=S[q];_[q]=k[L]}}return C[v]=S.length,z};return v.toTex={2:"\\left(${args[0]}"+s.operators.multiply+"${args[1]}\\right)"},v}var i=r(5).extend,a=r(2);t.name="multiply",t.factory=n},function(e,t,r){"use strict";function n(e,t){if(u(e)&&a(e,t))return e[t];if("function"==typeof e[t]&&s(e,t))throw new Error('Cannot access method "'+t+'" as a property');throw new Error('No access to property "'+t+'"')}function i(e,t,r){if(u(e)&&a(e,t))return e[t]=r;throw new Error('No access to property "'+t+'"')}function a(e,t){return!(!e||"object"!=typeof e)&&(!!c(f,t)||!(t in Object.prototype)&&!(t in Function.prototype))}function o(e,t){if(!s(e,t))throw new Error('No access to method "'+t+'"')}function s(e,t){return!(!e||"function"!=typeof e[t])&&(!(c(e,t)&&e.__proto__&&t in e.__proto__)&&(!!c(l,t)||!(t in Object.prototype)&&!(t in Function.prototype)))}function u(e){return"object"==typeof e&&e&&e.constructor===Object}var c=r(5).hasOwnProperty,f={length:!0,name:!0},l={toString:!0,valueOf:!0,toLocaleString:!0};t.getSafeProperty=n,t.setSafeProperty=i,t.isSafeProperty=a,t.validateSafeMethod=o,t.isSafeMethod=s,t.isPlainObject=u},function(e,t,r){"use strict";function n(e,t,n,s,u){function c(){if(!(this instanceof c))throw new SyntaxError("Constructor must be called with the new operator")}function f(e){for(var t in e)if(o(e,t)&&t in i)throw new Error('Scope contains an illegal symbol, "'+t+'" is a reserved keyword')}var l=n(r(7)).compile;return c.prototype.eval=function(e){return this.compile().eval(e)},c.prototype.type="Node",c.prototype.isNode=!0,c.prototype.comment="",c.prototype.compile=function(){if(arguments.length>0)throw new Error("Calling compile(math) is deprecated. Call the function as compile() instead.");var e={math:u.expression.mathWithTransform,args:{},_validateScope:f},t={},r=l(this,e,t),n=Object.keys(e).map(function(e){return"    var "+e+' = defs["'+e+'"];'}),i=n.join(" ")+'return {  "eval": function (scope) {    if (scope) _validateScope(scope);    scope = scope || {};    return '+r+";  }};",a=new Function("defs",i);return a(e)},c.prototype.forEach=function(e){throw new Error("Cannot run forEach on a Node interface")},c.prototype.map=function(e){throw new Error("Cannot run map on a Node interface")},c.prototype._ifNode=function(t){if(!e.isNode(t))throw new TypeError("Callback function must return a Node");return t},c.prototype.traverse=function(e){function t(e,r){e.forEach(function(e,n,i){r(e,n,i),t(e,r)})}e(this,null,null),t(this,e)},c.prototype.transform=function(e){function t(e,r){return e.map(function(e,n,i){var a=r(e,n,i);return t(a,r)})}var r=e(this,null,null);return t(r,e)},c.prototype.filter=function(e){var t=[];return this.traverse(function(r,n,i){e(r,n,i)&&t.push(r)}),t},c.prototype.find=function(){throw new Error("Function Node.find is deprecated. Use Node.filter instead.")},c.prototype.match=function(){throw new Error("Function Node.match is deprecated. See functions Node.filter, Node.transform, Node.traverse.")},c.prototype.clone=function(){throw new Error("Cannot clone a Node interface")},c.prototype.cloneDeep=function(){return this.map(function(e){return e.cloneDeep()})},c.prototype.equals=function(e){return!!e&&a(this,e)},c.prototype.toString=function(e){var t;if(e&&"object"==typeof e)switch(typeof e.handler){case"object":case"undefined":break;case"function":t=e.handler(this,e);break;default:throw new TypeError("Object or function expected as callback")}return"undefined"!=typeof t?t:this._toString(e)},c.prototype.toHTML=function(e){var t;if(e&&"object"==typeof e)switch(typeof e.handler){case"object":case"undefined":break;case"function":t=e.handler(this,e);break;default:throw new TypeError("Object or function expected as callback")}return"undefined"!=typeof t?t:this.toHTML(e)},c.prototype._toString=function(){throw new Error("_toString not implemented for "+this.type)},c.prototype.toTex=function(e){var t;if(e&&"object"==typeof e)switch(typeof e.handler){case"object":case"undefined":break;case"function":t=e.handler(this,e);break;default:throw new TypeError("Object or function expected as callback")}return"undefined"!=typeof t?t:this._toTex(e)},c.prototype._toTex=function(e){throw new Error("_toTex not implemented for "+this.type)},c.prototype.getIdentifier=function(){return this.type},c.prototype.getContent=function(){return this},c}var i=r(77),a=r(5).deepEqual,o=r(5).hasOwnProperty;t.name="Node",t.path="expression.node",t.math=!0,t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var a=e.DenseMatrix,o=function(e,t,r,o){var s=e._data,u=e._size,c=e._datatype,f=t._values,l=t._index,p=t._ptr,h=t._size,m=t._datatype;if(u.length!==h.length)throw new i(u.length,h.length);if(u[0]!==h[0]||u[1]!==h[1])throw new RangeError("Dimension mismatch. Matrix A ("+u+") must match Matrix B ("+h+")");if(!f)throw new Error("Cannot perform operation on Dense Matrix and Pattern Sparse Matrix");var d,v=u[0],g=u[1],y=0,x=r;"string"==typeof c&&c===m&&(d=c,y=n.convert(0,d),x=n.find(r,[d,d]));for(var w=[],b=0;b<v;b++)w[b]=[];for(var N=[],E=[],M=0;M<g;M++){for(var A=M+1,O=p[M],T=p[M+1],_=O;_<T;_++){var S=l[_];N[S]=o?x(f[_],s[S][M]):x(s[S][M],f[_]),E[S]=A}for(var C=0;C<v;C++)E[C]===A?w[C][M]=N[C]:w[C][M]=o?x(y,s[C][M]):x(s[C][M],y)}return new a({data:w,size:[v,g],datatype:d})};return o}var i=r(10);t.name="algorithm03",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var i=e.DenseMatrix,a=function(e,t,r,a){var o=e._values,s=e._index,u=e._ptr,c=e._size,f=e._datatype;if(!o)throw new Error("Cannot perform operation on Pattern Sparse Matrix and Scalar value");var l,p=c[0],h=c[1],m=r;"string"==typeof f&&(l=f,t=n.convert(t,l),m=n.find(r,[l,l]));for(var d=[],v=new i({data:d,size:[p,h],datatype:l}),g=[],y=[],x=0;x<h;x++){for(var w=x+1,b=u[x],N=u[x+1],E=b;E<N;E++){var M=s[E];g[M]=o[E],y[M]=w}for(var A=0;A<p;A++)0===x&&(d[A]=[]),y[A]===w?d[A][x]=a?m(t,g[A]):m(g[A],t):d[A][x]=a?m(t,0):m(0,t)}return v};return a}t.name="algorithm12",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,i){var a=n(r(11)),o=e.SparseMatrix,s=function(e,t,r,n){var s=e._values,u=e._index,c=e._ptr,f=e._size,l=e._datatype;if(!s)throw new Error("Cannot perform operation on Pattern Sparse Matrix and Scalar value");var p,h=f[0],m=f[1],d=a,v=0,g=r;"string"==typeof l&&(p=l,d=i.find(a,[p,p]),v=i.convert(0,p),t=i.convert(t,p),g=i.find(r,[p,p]));for(var y=[],x=[],w=[],b=new o({values:y,index:x,ptr:w,size:[h,m],datatype:p}),N=0;N<m;N++){w[N]=x.length;for(var E=c[N],M=c[N+1],A=E;A<M;A++){var O=u[A],T=n?g(t,s[A]):g(s[A],t);d(T,v)||(x.push(O),y.push(T))}}return w[m]=x.length,b};return s}t.name="algorithm11",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){var o=n(r(0)),s=n(r(20)),u=r(4),c=n(r(33)),f=n(r(73)),l=n(r(36)),p=n(r(8)),h=n(r(6)),m=a("add",i({"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=f(e,t,s);break;default:r=c(t,e,s,!0)}break;default:switch(t.storage()){case"sparse":r=c(e,t,s,!1);break;default:r=p(e,t,s)}}return r},"Array, Array":function(e,t){return m(o(e),o(t)).valueOf()},"Array, Matrix":function(e,t){return m(o(e),t)},"Matrix, Array":function(e,t){return m(e,o(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=l(e,t,s,!1);break;default:r=h(e,t,s,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=l(t,e,s,!0);break;default:r=h(t,e,s,!0)}return r},"Array, any":function(e,t){return h(o(e),t,s,!1).valueOf()},"any, Array":function(e,t){return h(o(t),e,s,!0).valueOf()},"any, any":s,"any, any, ...any":function(e,t,r){for(var n=m(e,t),i=0;i<r.length;i++)n=m(n,r[i]);return n}},s.signatures));return m.toTex={2:"\\left(${args[0]}"+u.operators.add+"${args[1]}\\right)"},m}var i=r(5).extend;t.name="add",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,i){var a=n(r(23)),o=i("divide",{"number, number":function(e,t){return e/t},"Complex, Complex":function(e,t){return e.div(t)},"BigNumber, BigNumber":function(e,t){return e.div(t)},"Fraction, Fraction":function(e,t){return e.div(t)},"Unit, number | Fraction | BigNumber":function(e,t){var r=e.clone();return r.value=o(null===r.value?r._normalize(1):r.value,t),r},"number | Fraction | BigNumber, Unit":function(e,t){var r=t.pow(-1);return r.value=a(null===r.value?r._normalize(1):r.value,e),r},"Unit, Unit":function(e,t){return e.divide(t)}});return o}t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var i=n("add",{"number, number":function(e,t){return e+t},"Complex, Complex":function(e,t){return e.add(t)},"BigNumber, BigNumber":function(e,t){return e.plus(t)},"Fraction, Fraction":function(e,t){return e.add(t)},"Unit, Unit":function(e,t){if(null==e.value)throw new Error("Parameter x contains a unit with undefined value");if(null==t.value)throw new Error("Parameter y contains a unit with undefined value");if(!e.equalBase(t))throw new Error("Units do not match");var r=e.clone();return r.value=i(r.value,t.value),r.fixPrefix=!1,r}});return i}t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){var o=r(4),s=n(r(0)),u=n(r(20)),c=n(r(37)),f=n(r(33)),l=n(r(15)),p=n(r(60)),h=n(r(36)),m=n(r(8)),d=n(r(6)),v=a("subtract",{
"number, number":function(e,t){return e-t},"Complex, Complex":function(e,t){return e.sub(t)},"BigNumber, BigNumber":function(e,t){return e.minus(t)},"Fraction, Fraction":function(e,t){return e.sub(t)},"Unit, Unit":function(e,t){if(null==e.value)throw new Error("Parameter x contains a unit with undefined value");if(null==t.value)throw new Error("Parameter y contains a unit with undefined value");if(!e.equalBase(t))throw new Error("Units do not match");var r=e.clone();return r.value=v(r.value,t.value),r.fixPrefix=!1,r},"Matrix, Matrix":function(e,t){var r=e.size(),n=t.size();if(r.length!==n.length)throw new i(r.length,n.length);var a;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":a=p(e,t,v);break;default:a=l(t,e,v,!0)}break;default:switch(t.storage()){case"sparse":a=f(e,t,v,!1);break;default:a=m(e,t,v)}}return a},"Array, Array":function(e,t){return v(s(e),s(t)).valueOf()},"Array, Matrix":function(e,t){return v(s(e),t)},"Matrix, Array":function(e,t){return v(e,s(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=h(e,c(t),u);break;default:r=d(e,t,v)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=h(t,e,v,!0);break;default:r=d(t,e,v,!0)}return r},"Array, any":function(e,t){return d(s(e),t,v,!1).valueOf()},"any, Array":function(e,t){return d(s(t),e,v,!0).valueOf()}});return v.toTex={2:"\\left(${args[0]}"+o.operators.subtract+"${args[1]}\\right)"},v}var i=r(10);t.name="subtract",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,u){function c(t,r){if(!e.isIndex(r))throw new TypeError("Index expected");if(1!=r.size().length)throw new f(r.size().length,1);var n=t.length;s(r.min()[0],n),s(r.max()[0],n);var i=r.dimension(0),a="";return i.forEach(function(e){a+=t.charAt(e)}),a}function l(e,t,r,n){if(!t||t.isIndex!==!0)throw new TypeError("Index expected");if(1!=t.size().length)throw new f(t.size().length,1);if(void 0!==n){if("string"!=typeof n||1!==n.length)throw new TypeError("Single character expected as defaultValue")}else n=" ";var i=t.dimension(0),a=i.size()[0];if(a!=r.length)throw new f(i.size()[0],r.length);var o=e.length;s(t.min()[0]),s(t.max()[0]);for(var u=[],c=0;c<o;c++)u[c]=e.charAt(c);if(i.forEach(function(e,t){u[e]=r.charAt(t[0])}),u.length>o)for(c=o-1,a=u.length;c<a;c++)u[c]||(u[c]=n);return u.join("")}var p=n(r(0)),h=u("subset",{"Array, Index":function(e,t){var r=p(e),n=r.subset(t);return t.isScalar()?n:n.valueOf()},"Matrix, Index":function(e,t){return e.subset(t)},"Object, Index":i,"string, Index":c,"Array, Index, any":function(e,t,r){return p(o(e)).subset(t,r,void 0).valueOf()},"Array, Index, any, any":function(e,t,r,n){return p(o(e)).subset(t,r,n).valueOf()},"Matrix, Index, any":function(e,t,r){return e.clone().subset(t,r)},"Matrix, Index, any, any":function(e,t,r,n){return e.clone().subset(t,r,n)},"string, Index, string":l,"string, Index, string, string":l,"Object, Index, any":a});return h.toTex=void 0,h}function i(e,t){if(1!==t.size().length)throw new f(t.size(),1);var r=t.dimension(0);if("string"!=typeof r)throw new TypeError("String expected as index to retrieve an object property");return u(e,r)}function a(e,t,r){if(1!==t.size().length)throw new f(t.size(),1);var n=t.dimension(0);if("string"!=typeof n)throw new TypeError("String expected as index to retrieve an object property");var i=o(e);return c(i,n,r),i}var o=r(5).clone,s=r(2).validateIndex,u=r(13).getSafeProperty,c=r(13).setSafeProperty,f=r(10);t.name="subset",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var i=n("multiplyScalar",{"number, number":function(e,t){return e*t},"Complex, Complex":function(e,t){return e.mul(t)},"BigNumber, BigNumber":function(e,t){return e.times(t)},"Fraction, Fraction":function(e,t){return e.mul(t)},"number | Fraction | BigNumber | Complex, Unit":function(e,t){var r=t.clone();return r.value=null===r.value?r._normalize(e):i(r.value,e),r},"Unit, number | Fraction | BigNumber | Complex":function(e,t){var r=e.clone();return r.value=null===r.value?r._normalize(t):i(r.value,t),r},"Unit, Unit":function(e,t){return e.multiply(t)}});return i}t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){var o=n(r(11)),s=e.SparseMatrix,u=function(e,t,r,n){var u=e._data,c=e._size,f=e._datatype,l=t._values,p=t._index,h=t._ptr,m=t._size,d=t._datatype;if(c.length!==m.length)throw new i(c.length,m.length);if(c[0]!==m[0]||c[1]!==m[1])throw new RangeError("Dimension mismatch. Matrix A ("+c+") must match Matrix B ("+m+")");if(!l)throw new Error("Cannot perform operation on Dense Matrix and Pattern Sparse Matrix");var v,g=c[0],y=c[1],x=o,w=0,b=r;"string"==typeof f&&f===d&&(v=f,x=a.find(o,[v,v]),w=a.convert(0,v),b=a.find(r,[v,v]));for(var N=[],E=[],M=[],A=0;A<y;A++){M[A]=E.length;for(var O=h[A],T=h[A+1],_=O;_<T;_++){var S=p[_],C=n?b(l[_],u[S][A]):b(u[S][A],l[_]);x(C,w)||(E.push(S),N.push(C))}}return M[y]=E.length,new s({values:N,index:E,ptr:M,size:[g,y],datatype:v})};return u}var i=r(10);t.name="algorithm02",t.factory=n},function(e,t,r){"use strict";t.array=r(2),t.boolean=r(174),t.function=r(32),t.number=r(3),t.object=r(5),t.string=r(9),t.types=r(59),t.emitter=r(90)},function(e,t,r){"use strict";function n(e,t,r,n){var a=e.DenseMatrix,o=function(e,t,r){var o=e._size,u=e._datatype,c=t._size,f=t._datatype;if(o.length!==c.length)throw new i(o.length,c.length);if(o[0]!==c[0]||o[1]!==c[1])throw new RangeError("Dimension mismatch. Matrix A ("+o+") must match Matrix B ("+c+")");var l,p=o[0],h=o[1],m=0,d=r;"string"==typeof u&&u===f&&(l=u,m=n.convert(0,l),d=n.find(r,[l,l]));var v,g,y=[];for(v=0;v<p;v++)y[v]=[];var x=new a({data:y,size:[p,h],datatype:l}),w=[],b=[],N=[],E=[];for(g=0;g<h;g++){var M=g+1;for(s(e,g,N,w,M),s(t,g,E,b,M),v=0;v<p;v++){var A=N[v]===M?w[v]:m,O=E[v]===M?b[v]:m;y[v][g]=d(A,O)}}return x},s=function(e,t,r,n,i){for(var a=e._values,o=e._index,s=e._ptr,u=s[t],c=s[t+1];u<c;u++){var f=o[u];r[f]=i,n[f]=a[u]}};return o}var i=r(10);t.name="algorithm07",t.factory=n},function(e,t,r){"use strict";function n(e){function t(n){if(!(this instanceof t))throw new SyntaxError("Constructor must be called with the new operator");this._dimensions=[],this._isScalar=!0;for(var i=0,a=arguments.length;i<a;i++){var o=arguments[i];if(e.isRange(o))this._dimensions.push(o),this._isScalar=!1;else if(Array.isArray(o)||e.isMatrix(o)){var s=r(o.valueOf());this._dimensions.push(s);var u=s.size();1===u.length&&1===u[0]||(this._isScalar=!1)}else if("number"==typeof o)this._dimensions.push(r([o]));else{if("string"!=typeof o)throw new TypeError("Dimension must be an Array, Matrix, number, string, or Range");this._dimensions.push(o)}}}function r(t){for(var r=0,n=t.length;r<n;r++)if("number"!=typeof t[r]||!a(t[r]))throw new TypeError("Index parameters must be positive integer numbers");return new e.ImmutableDenseMatrix(t)}return t.prototype.type="Index",t.prototype.isIndex=!0,t.prototype.clone=function(){var e=new t;return e._dimensions=i(this._dimensions),e._isScalar=this._isScalar,e},t.create=function(e){var r=new t;return t.apply(r,e),r},t.prototype.size=function(){for(var e=[],t=0,r=this._dimensions.length;t<r;t++){var n=this._dimensions[t];e[t]="string"==typeof n?1:n.size()[0]}return e},t.prototype.max=function(){for(var e=[],t=0,r=this._dimensions.length;t<r;t++){var n=this._dimensions[t];e[t]="string"==typeof n?n:n.max()}return e},t.prototype.min=function(){for(var e=[],t=0,r=this._dimensions.length;t<r;t++){var n=this._dimensions[t];e[t]="string"==typeof n?n:n.min()}return e},t.prototype.forEach=function(e){for(var t=0,r=this._dimensions.length;t<r;t++)e(this._dimensions[t],t,this)},t.prototype.dimension=function(e){return this._dimensions[e]||null},t.prototype.isObjectProperty=function(){return 1===this._dimensions.length&&"string"==typeof this._dimensions[0]},t.prototype.getObjectProperty=function(){return this.isObjectProperty()?this._dimensions[0]:null},t.prototype.isScalar=function(){return this._isScalar},t.prototype.toArray=function(){for(var e=[],t=0,r=this._dimensions.length;t<r;t++){var n=this._dimensions[t];e.push("string"==typeof n?n:n.toArray())}return e},t.prototype.valueOf=t.prototype.toArray,t.prototype.toString=function(){for(var e=[],t=0,r=this._dimensions.length;t<r;t++){var n=this._dimensions[t];"string"==typeof n?e.push(JSON.stringify(n)):e.push(n.toString())}return"["+e.join(", ")+"]"},t.prototype.toJSON=function(){return{mathjs:"Index",dimensions:this._dimensions}},t.fromJSON=function(e){return t.create(e.dimensions)},t}var i=r(5).clone,a=r(3).isInteger;t.name="Index",t.path="type",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){var o=n(r(0)),s=a("size",{Matrix:function(e){return o(e.size())},Array:i.size,string:function(e){return"Array"===t.matrix?[e.length]:o([e.length])},"number | Complex | BigNumber | Unit | boolean | null":function(e){return"Array"===t.matrix?[]:o([])}});return s.toTex=void 0,s}var i=r(2);t.name="size",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("abs",{number:Math.abs,Complex:function(e){return e.abs()},BigNumber:function(e){return e.abs()},Fraction:function(e){return e.abs()},"Array | Matrix":function(e){return i(e,a,!0)},Unit:function(e){return e.abs()}});return a.toTex={1:"\\left|${args[0]}\\right|"},a}var i=r(1);t.name="abs",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,i){var a=n(r(0)),o=n(r(11)),s=n(r(15)),u=n(r(26)),c=n(r(16)),f=n(r(8)),l=n(r(6)),p=r(4),h=i("equal",{"any, any":function(e,t){return null===e?null===t:null===t?null===e:void 0===e?void 0===t:void 0===t?void 0===e:o(e,t)},"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=u(e,t,o);break;default:r=s(t,e,o,!0)}break;default:switch(t.storage()){case"sparse":r=s(e,t,o,!1);break;default:r=f(e,t,o)}}return r},"Array, Array":function(e,t){return h(a(e),a(t)).valueOf()},"Array, Matrix":function(e,t){return h(a(e),t)},"Matrix, Array":function(e,t){return h(e,a(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=c(e,t,o,!1);break;default:r=l(e,t,o,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=c(t,e,o,!0);break;default:r=l(t,e,o,!0)}return r},"Array, any":function(e,t){return l(a(e),t,o,!1).valueOf()},"any, Array":function(e,t){return l(a(t),e,o,!0).valueOf()}});return h.toTex={2:"\\left(${args[0]}"+p.operators.equal+"${args[1]}\\right)"},h}t.name="equal",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,o){function s(t,r){return e.isSparseMatrix(t)&&e.isSparseMatrix(r)?u(t.toJSON().values,r.toJSON().values):e.isSparseMatrix(t)?s(t.toArray(),r):e.isSparseMatrix(r)?s(t,r.toArray()):e.isDenseMatrix(t)?s(t.toJSON().data,r):e.isDenseMatrix(r)?s(t,r.toJSON().data):Array.isArray(t)?Array.isArray(r)?u(t,r):s(t,[r]):s([t],r)}function u(e,t){for(var r=0,n=Math.min(e.length,t.length);r<n;r++){var i=h(e[r],t[r]);if(0!==i)return i}return e.length>t.length?1:e.length<t.length?-1:0}function c(e,t){var r=Object.keys(e),n=Object.keys(t);r.sort(a),n.sort(a);var i=u(r,n);if(0!==i)return i;for(var o=0;o<r.length;o++){var s=h(e[r[o]],t[n[o]]);if(0!==s)return s}return 0}var f=n(r(76)),l=(n(r(0)),n(r(49))),p=l.signatures["boolean,boolean"],h=o("compareNatural",{"any, any":function(e,t){var r,n=f(e),o=f(t);if(!("number"!==n&&"BigNumber"!==n&&"Fraction"!==n||"number"!==o&&"BigNumber"!==o&&"Fraction"!==o))return r=l(e,t),"0"!==r.toString()?r>0?1:-1:a(n,o);if("Array"===n||"Matrix"===n||"Array"===o||"Matrix"===o)return r=s(e,t),0!==r?r:a(n,o);if(n!==o)return a(n,o);if("Complex"===n)return i(e,t);if("Unit"===n)return e.equalBase(t)?h(e.value,t.value):u(e.formatUnits(),t.formatUnits());if("boolean"===n)return p(e,t);if("string"===n)return a(e,t);if("Object"===n)return c(e,t);if("null"===n)return 0;if("undefined"===n)return 0;throw new TypeError('Unsupported type of value "'+n+'"')}});return h.toTex=void 0,h}function i(e,t){return e.re>t.re?1:e.re<t.re?-1:e.im>t.im?1:e.im<t.im?-1:0}var a=r(483);t.name="compareNatural",t.factory=n},function(e,t){t.memoize=function(e,t){return function r(){"object"!=typeof r.cache&&(r.cache={});for(var n=[],i=0;i<arguments.length;i++)n[i]=arguments[i];var a=t?t(n):JSON.stringify(n);return a in r.cache?r.cache[a]:r.cache[a]=e.apply(e,n)}},t.maxArgumentCount=function(e){return Object.keys(e.signatures||{}).reduce(function(e,t){var r=(t.match(/,/g)||[]).length+1;return Math.max(e,r)},-1)},t.callWithRightArgumentCount=function(e,t,r){return Object.keys(e.signatures||{}).reduce(function(e,t){var r=(t.match(/,/g)||[]).length+1;return Math.max(e,r)},-1)}},function(e,t,r){"use strict";function n(e,t,r,n){var a=e.DenseMatrix,o=function(e,t,r,o){var s=e._data,u=e._size,c=e._datatype,f=t._values,l=t._index,p=t._ptr,h=t._size,m=t._datatype;if(u.length!==h.length)throw new i(u.length,h.length);if(u[0]!==h[0]||u[1]!==h[1])throw new RangeError("Dimension mismatch. Matrix A ("+u+") must match Matrix B ("+h+")");if(!f)throw new Error("Cannot perform operation on Dense Matrix and Pattern Sparse Matrix");var d,v,g=u[0],y=u[1],x="string"==typeof c&&c===m?c:void 0,w=x?n.find(r,[x,x]):r,b=[];for(d=0;d<g;d++)b[d]=[];var N=[],E=[];for(v=0;v<y;v++){for(var M=v+1,A=p[v],O=p[v+1],T=A;T<O;T++)d=l[T],N[d]=o?w(f[T],s[d][v]):w(s[d][v],f[T]),E[d]=M;for(d=0;d<g;d++)E[d]===M?b[d][v]=N[d]:b[d][v]=s[d][v]}return new a({data:b,size:[g,y],datatype:x})};return o}var i=r(10);t.name="algorithm01",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,o){var s=n(r(0)),u=n(r(15)),c=n(r(26)),f=n(r(16)),l=n(r(8)),p=n(r(6)),h=r(4),m=o("larger",{"boolean, boolean":function(e,t){return e>t},"number, number":function(e,r){return e>r&&!i(e,r,t.epsilon)},"BigNumber, BigNumber":function(e,r){return e.gt(r)&&!a(e,r,t.epsilon)},"Fraction, Fraction":function(e,t){return 1===e.compare(t)},"Complex, Complex":function(){throw new TypeError("No ordering relation is defined for complex numbers")},"Unit, Unit":function(e,t){if(!e.equalBase(t))throw new Error("Cannot compare units with different base");return m(e.value,t.value)},"string, string":function(e,t){return e>t},"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=c(e,t,m);break;default:r=u(t,e,m,!0)}break;default:switch(t.storage()){case"sparse":r=u(e,t,m,!1);break;default:r=l(e,t,m)}}return r},"Array, Array":function(e,t){return m(s(e),s(t)).valueOf()},"Array, Matrix":function(e,t){return m(s(e),t)},"Matrix, Array":function(e,t){return m(e,s(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=f(e,t,m,!1);break;default:r=p(e,t,m,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=f(t,e,m,!0);break;default:r=p(t,e,m,!0)}return r},"Array, any":function(e,t){return p(s(e),t,m,!1).valueOf()},"any, Array":function(e,t){return p(s(t),e,m,!0).valueOf()}});return m.toTex={2:"\\left(${args[0]}"+h.operators.larger+"${args[1]}\\right)"},m}var i=r(3).nearlyEqual,a=r(35);t.name="larger",t.factory=n},function(e,t,r){"use strict";e.exports=function(e,t,r){if(null==r)return e.eq(t);if(e.eq(t))return!0;if(e.isNaN()||t.isNaN())return!1;if(e.isFinite()&&t.isFinite()){var n=e.minus(t).abs();if(n.isZero())return!0;var i=e.constructor.max(e.abs(),t.abs());return n.lte(i.times(r))}return!1}},function(e,t,r){"use strict";function n(e,t,r,n){var i=e.DenseMatrix,a=function(e,t,r,a){var o=e._values,s=e._index,u=e._ptr,c=e._size,f=e._datatype;if(!o)throw new Error("Cannot perform operation on Pattern Sparse Matrix and Scalar value");var l,p=c[0],h=c[1],m=r;"string"==typeof f&&(l=f,t=n.convert(t,l),m=n.find(r,[l,l]));for(var d=[],v=new i({data:d,size:[p,h],datatype:l}),g=[],y=[],x=0;x<h;x++){for(var w=x+1,b=u[x],N=u[x+1],E=b;E<N;E++){var M=s[E];g[M]=o[E],y[M]=w}for(var A=0;A<p;A++)0===x&&(d[A]=[]),y[A]===w?d[A][x]=a?m(t,g[A]):m(g[A],t):d[A][x]=t}return v};return a}t.name="algorithm10",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){var o=r(4),s=a("unaryMinus",{number:function(e){return-e},Complex:function(e){return e.neg()},BigNumber:function(e){return e.neg()},Fraction:function(e){return e.neg()},Unit:function(e){var t=e.clone();return t.value=s(e.value),t},"Array | Matrix":function(e){return i(e,s,!0)}});return s.toTex={1:o.operators.unaryMinus+"\\left(${args[0]}\\right)"},s}var i=r(1);t.name="unaryMinus",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,o){function s(t,r){var n=u(t),i=n?new e.BigNumber(0):0;if(c(t),r){var o=f(r);return t.length>0?o.resize(t,i):o}var s=[];return t.length>0?a(s,t,i):s}function u(t){var r=!1;return t.forEach(function(t,n,i){e.isBigNumber(t)&&(r=!0,i[n]=t.toNumber())}),r}function c(e){e.forEach(function(e){if("number"!=typeof e||!i(e)||e<0)throw new Error("Parameters in function zeros must be positive integers")})}var f=n(r(0)),l=o("zeros",{"":function(){return"Array"===t.matrix?s([]):s([],"default")},"...number | BigNumber | string":function(e){var r=e[e.length-1];if("string"==typeof r){var n=e.pop();return s(e,n)}return"Array"===t.matrix?s(e):s(e,"default")},Array:s,Matrix:function(e){var t=e.storage();return s(e.valueOf(),t)},"Array | Matrix, string":function(e,t){return s(e.valueOf(),t)}});return l.toTex=void 0,l}var i=r(3).isInteger,a=r(2).resize;t.name="zeros",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,o){function s(t,r){if(1!=arguments.length&&2!=arguments.length)throw new i("parse",arguments.length,1,2);if(he=r&&r.nodes?r.nodes:{},"string"==typeof t)return me=t,g();if(Array.isArray(t)||t instanceof e.Matrix)return a(t,function(e){if("string"!=typeof e)throw new TypeError("String expected");return me=e,g()});throw new TypeError("String or matrix expected")}function u(){ve=0,ge=me.charAt(0),we=0,be=null}function c(){ve++,ge=me.charAt(ve)}function f(){return me.charAt(ve-1)}function l(){return me.charAt(ve+1)}function p(){return me.charAt(ve+2)}function h(){for(xe=fe.NULL,ye="",de="";s.isWhitespace(ge,we);)c();if("#"==ge)for(;"\n"!=ge&&""!=ge;)de+=ge,c();if(""==ge)return void(xe=fe.DELIMITER);if("\n"==ge&&!we)return xe=fe.DELIMITER,ye=ge,void c();var e=ge+l(),t=e+p();if(3==t.length&&le[t])return xe=fe.DELIMITER,ye=t,c(),c(),void c();if(2==e.length&&le[e])return xe=fe.DELIMITER,ye=e,c(),void c();if(le[ge])return xe=fe.DELIMITER,ye=ge,void c();if(!s.isDigitDot(ge)){if(s.isAlpha(ge,f(),l())){for(;s.isAlpha(ge,f(),l())||s.isDigit(ge);)ye+=ge,c();return void(xe=pe.hasOwnProperty(ye)?fe.DELIMITER:fe.SYMBOL)}for(xe=fe.UNKNOWN;""!=ge;)ye+=ge,c();throw W('Syntax error in part "'+ye+'"')}if(xe=fe.NUMBER,"."==ge)ye+=ge,c(),s.isDigit(ge)||(xe=fe.DELIMITER);else{for(;s.isDigit(ge);)ye+=ge,c();s.isDecimalMark(ge,l())&&(ye+=ge,c())}for(;s.isDigit(ge);)ye+=ge,c();if(e=l(),"E"==ge||"e"==ge)if(s.isDigit(e)||"-"==e||"+"==e){if(ye+=ge,c(),"+"!=ge&&"-"!=ge||(ye+=ge,c()),!s.isDigit(ge))throw W('Digit expected, got "'+ge+'"');for(;s.isDigit(ge);)ye+=ge,c();if(s.isDecimalMark(ge,l()))throw W('Digit expected, got "'+ge+'"')}else if("."==e)throw c(),W('Digit expected, got "'+ge+'"')}function m(){do h();while("\n"==ye)}function d(){we++}function v(){we--}function g(){u(),h();var e=y();if(""!=ye)throw xe==fe.DELIMITER?Y("Unexpected operator "+ye):W('Unexpected part "'+ye+'"');return e}function y(){var e,t,r=[];for(""!=ye&&"\n"!=ye&&";"!=ye&&(e=x(),e.comment=de);"\n"==ye||";"==ye;)0==r.length&&e&&(t=";"!=ye,r.push({node:e,visible:t})),h(),"\n"!=ye&&";"!=ye&&""!=ye&&(e=x(),e.comment=de,t=";"!=ye,r.push({node:e,visible:t}));return r.length>0?new K(r):(e||(e=new te("undefined","undefined"),e.comment=de),e)}function x(){var t,r,n,i,a=w();if("="==ye){if(e.isSymbolNode(a))return t=a.name,m(),n=x(),new Q(new ce(t),n);if(e.isAccessorNode(a))return m(),n=x(),new Q(a.object,a.index,n);if(e.isFunctionNode(a)&&(i=!0,r=[],t=a.name,a.args.forEach(function(t,n){e.isSymbolNode(t)?r[n]=t.name:i=!1}),i))return m(),n=x(),new re(t,r,n);throw W("Invalid left hand side of assignment operator =")}return a}function w(){for(var e=b();"?"==ye;){var t=be;be=we,m();var r=e,n=x();if(":"!=ye)throw W("False part of conditional expression expected");be=null,m();var i=x();e=new ee(r,n,i),be=t}return e}function b(){for(var e=N();"or"==ye;)m(),e=new ae("or","or",[e,N()]);return e}function N(){for(var e=E();"xor"==ye;)m(),e=new ae("xor","xor",[e,E()]);return e}function E(){for(var e=M();"and"==ye;)m(),e=new ae("and","and",[e,M()]);return e}function M(){for(var e=A();"|"==ye;)m(),e=new ae("|","bitOr",[e,A()]);return e}function A(){for(var e=O();"^|"==ye;)m(),e=new ae("^|","bitXor",[e,O()]);return e}function O(){for(var e=T();"&"==ye;)m(),e=new ae("&","bitAnd",[e,T()]);return e}function T(){var e,t,r,n,i;for(e=_(),t={"==":"equal","!=":"unequal","<":"smaller",">":"larger","<=":"smallerEq",">=":"largerEq"};t.hasOwnProperty(ye);)r=ye,n=t[r],m(),i=[e,_()],e=new ae(r,n,i);return e}function _(){var e,t,r,n,i;for(e=S(),t={"<<":"leftShift",">>":"rightArithShift",">>>":"rightLogShift"};t.hasOwnProperty(ye);)r=ye,n=t[r],m(),i=[e,S()],e=new ae(r,n,i);return e}function S(){var e,t,r,n,i;for(e=C(),t={to:"to",in:"to"};t.hasOwnProperty(ye);)r=ye,n=t[r],m(),"in"===r&&""===ye?e=new ae("*","multiply",[e,new ce("in")],!0):(i=[e,C()],e=new ae(r,n,i));return e}function C(){var e,t=[];if(e=":"==ye?new te("1","number"):z(),":"==ye&&be!==we){for(t.push(e);":"==ye&&t.length<3;)m(),")"==ye||"]"==ye||","==ye||""==ye?t.push(new ce("end")):t.push(z());e=3==t.length?new ue(t[0],t[2],t[1]):new ue(t[0],t[1])}return e}function z(){var e,t,r,n,i;for(e=k(),t={"+":"add","-":"subtract"};t.hasOwnProperty(ye);)r=ye,n=t[r],m(),i=[e,k()],e=new ae(r,n,i);return e}function k(){var t,r,n,i,a;for(t=I(),r=t,n={"*":"multiply",".*":"dotMultiply","/":"divide","./":"dotDivide","%":"mod",mod:"mod"};;)if(n.hasOwnProperty(ye))i=ye,a=n[i],m(),r=I(),t=new ae(i,a,[t,r]);else{if(!(xe===fe.SYMBOL||"in"===ye&&e.isConstantNode(t))&&(xe!==fe.NUMBER||e.isConstantNode(r)||e.isOperatorNode(r)&&"!"!==r.op)&&"("!==ye)break;r=I(),t=new ae("*","multiply",[t,r],!0)}return t}function I(){var e,t,r,n={"-":"unaryMinus","+":"unaryPlus","~":"bitNot",not:"not"};return n.hasOwnProperty(ye)?(r=n[ye],e=ye,m(),t=[I()],new ae(e,r,t)):B()}function B(){var e,t,r,n;return e=P(),"^"!=ye&&".^"!=ye||(t=ye,r="^"==t?"pow":"dotPow",m(),n=[e,I()],e=new ae(t,r,n)),e}function P(){var e,t,r,n,i;for(e=R(),t={"!":"factorial","'":"transpose"};t.hasOwnProperty(ye);)r=ye,n=t[r],h(),i=[e],e=new ae(r,n,i),e=q(e);return e}function R(){var e=[];if(xe==fe.SYMBOL&&he.hasOwnProperty(ye)){var t=he[ye];if(h(),"("==ye){if(e=[],d(),h(),")"!=ye)for(e.push(x());","==ye;)h(),e.push(x());if(")"!=ye)throw W("Parenthesis ) expected");v(),h()}return new t(e)}return U()}function U(){var e,t;return xe==fe.SYMBOL||xe==fe.DELIMITER&&ye in pe?(t=ye,h(),e=new ce(t),e=q(e)):L()}function q(t,r){for(var n;!("("!==ye&&"["!==ye&&"."!==ye||r&&r.indexOf(ye)===-1);)if(n=[],"("===ye){if(!(e.isSymbolNode(t)||e.isAccessorNode(t)||e.isFunctionNode(t)))return t;if(d(),h(),")"!==ye)for(n.push(x());","===ye;)h(),n.push(x());if(")"!==ye)throw W("Parenthesis ) expected");v(),h(),t=new se(t,n)}else if("["===ye){if(d(),h(),"]"!==ye)for(n.push(x());","===ye;)h(),n.push(x());if("]"!==ye)throw W("Parenthesis ] expected");v(),h(),t=new X(t,new ne(n))}else{if(h(),xe!==fe.SYMBOL)throw W("Property name expected after dot");n.push(new te(ye)),h();var i=!0;t=new X(t,new ne(n,i))}return t}function L(){var e,t;return'"'==ye?(t=j(),e=new te(t,"string"),e=q(e)):F()}function j(){for(var e="";""!=ge&&'"'!=ge;)"\\"==ge&&(e+=ge,c()),e+=ge,c();if(h(),'"'!=ye)throw W('End of string " expected');return h(),e}function F(){var e,t,r,n;if("["==ye){if(d(),h(),"]"!=ye){var i=D();if(";"==ye){for(r=1,t=[i];";"==ye;)h(),t[r]=D(),r++;if("]"!=ye)throw W("End of matrix ] expected");v(),h(),n=t[0].items.length;for(var a=1;a<r;a++)if(t[a].items.length!=n)throw Y("Column dimensions mismatch ("+t[a].items.length+" != "+n+")");e=new J(t)}else{if("]"!=ye)throw W("End of matrix ] expected");v(),h(),e=i}}else v(),h(),e=new J([]);return q(e)}return H()}function D(){for(var e=[x()],t=1;","==ye;)h(),e[t]=x(),t++;return new J(e)}function H(){if("{"==ye){var e,t={};do if(h(),"}"!=ye){if('"'==ye)e=j();else{if(xe!=fe.SYMBOL)throw W("Symbol or string expected as object key");e=ye,h()}if(":"!=ye)throw W("Colon : expected after object key");h(),t[e]=x()}while(","==ye);if("}"!=ye)throw W("Comma , or bracket } expected after object value");h();var r=new ie(t);return r=q(r)}return $()}function $(){var e;return xe==fe.NUMBER?(e=ye,h(),new te(e,"number")):G()}function G(){var e;if("("==ye){if(d(),h(),e=x(),")"!=ye)throw W("Parenthesis ) expected");return v(),h(),e=new oe(e),e=q(e)}return Z()}function Z(){throw W(""==ye?"Unexpected end of expression":"'"===ye?"Value expected. Note: strings must be enclosed by double quotes":"Value expected")}function V(){return ve-ye.length+1}function W(e){var t=V(),r=new SyntaxError(e+" (char "+t+")");return r.char=t,r}function Y(e){var t=V(),r=new SyntaxError(e+" (char "+t+")");return r.char=t,r}var X=n(r(102)),J=n(r(80)),Q=n(r(104)),K=n(r(105)),ee=n(r(106)),te=n(r(53)),re=n(r(107)),ne=n(r(78)),ie=n(r(109)),ae=n(r(62)),oe=n(r(63)),se=n(r(54)),ue=n(r(79)),ce=n(r(40)),fe={NULL:0,DELIMITER:1,NUMBER:2,SYMBOL:3,UNKNOWN:4},le={",":!0,"(":!0,")":!0,"[":!0,"]":!0,"{":!0,"}":!0,'"':!0,";":!0,"+":!0,"-":!0,"*":!0,".*":!0,"/":!0,"./":!0,"%":!0,"^":!0,".^":!0,"~":!0,"!":!0,"&":!0,"|":!0,"^|":!0,"'":!0,"=":!0,":":!0,"?":!0,"==":!0,"!=":!0,"<":!0,">":!0,"<=":!0,">=":!0,"<<":!0,">>":!0,">>>":!0},pe={mod:!0,to:!0,in:!0,and:!0,xor:!0,or:!0,not:!0},he={},me="",de="",ve=0,ge="",ye="",xe=fe.NULL,we=0,be=null;return s.isAlpha=function(e,t,r){return s.isValidLatinOrGreek(e)||s.isValidMathSymbol(e,r)||s.isValidMathSymbol(t,e)},s.isValidLatinOrGreek=function(e){return/^[a-zA-Z_$\u00C0-\u02AF\u0370-\u03FF\u2100-\u214F]$/.test(e)},s.isValidMathSymbol=function(e,t){return/^[\uD835]$/.test(e)&&/^[\uDC00-\uDFFF]$/.test(t)&&/^[^\uDC55\uDC9D\uDCA0\uDCA1\uDCA3\uDCA4\uDCA7\uDCA8\uDCAD\uDCBA\uDCBC\uDCC4\uDD06\uDD0B\uDD0C\uDD15\uDD1D\uDD3A\uDD3F\uDD45\uDD47-\uDD49\uDD51\uDEA6\uDEA7\uDFCC\uDFCD]$/.test(t)},s.isWhitespace=function(e,t){return" "==e||"\t"==e||"\n"==e&&t>0},s.isDecimalMark=function(e,t){return"."==e&&"/"!==t&&"*"!==t&&"^"!==t},s.isDigitDot=function(e){return e>="0"&&e<="9"||"."==e},s.isDigit=function(e){return e>="0"&&e<="9"},s}var i=r(50),a=r(1);t.name="parse",t.path="expression",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,c,f){function l(t){return!!e.Unit&&e.Unit.isValuelessUnit(t)}function p(e){if(!(this instanceof p))throw new SyntaxError("Constructor must be called with the new operator");if("string"!=typeof e)throw new TypeError('String expected for parameter "name"');this.name=e}function h(t,r,n){if(!(t instanceof p))throw new TypeError("No valid SymbolNode");r.undef=m,r.Unit=e.Unit,r.getSafeProperty=u,r.hasOwnProperty=s;var i=a(t.name);return s(n,t.name)?n[t.name]:t.name in r.math?"("+i+" in scope ? getSafeProperty(scope, "+i+") : getSafeProperty(math, "+i+"))":"("+i+" in scope ? getSafeProperty(scope, "+i+") : "+(l(t.name)?"new Unit(null, "+i+")":"undef("+i+")")+")"}function m(e){throw new Error("Undefined symbol "+e)}var d=n(r(7)).register,v=(n(r(7)).compile,n(r(14)));return p.prototype=new v,p.prototype.type="SymbolNode",p.prototype.isSymbolNode=!0,d(p.prototype.type,h),p.prototype.forEach=function(e){},p.prototype.map=function(e){return this.clone()},p.prototype.clone=function(){return new p(this.name)},p.prototype._toString=function(e){return this.name},p.prototype.toHTML=function(e){var t=o(this.name);return"true"==t||"false"==t?'<span class="math-symbol math-boolean">'+t+"</span>":"i"==t?'<span class="math-symbol math-imaginary-symbol">'+t+"</span>":"Infinity"==t?'<span class="math-symbol math-infinity-symbol">'+t+"</span>":"NaN"==t?'<span class="math-symbol math-nan-symbol">'+t+"</span>":"null"==t?'<span class="math-symbol math-null-symbol">'+t+"</span>":"uninitialized"==t?'<span class="math-symbol math-uninitialized-symbol">'+t+"</span>":'<span class="math-symbol">'+t+"</span>"},p.prototype._toTex=function(e){var t=!1;"undefined"==typeof f[this.name]&&l(this.name)&&(t=!0);var r=i.toSymbol(this.name,t);return"\\"===r[0]?r:" "+r},p}var i=r(4),a=r(9).stringify,o=r(9).escape,s=r(5).hasOwnProperty,u=r(13).getSafeProperty;t.name="SymbolNode",t.path="expression.node",t.math=!0,t.factory=n},function(e,t,r){var n=r(51);t.transform=function(e){return e&&e.isIndexError?new n(e.index+1,e.min+1,void 0!==e.max?e.max+1:void 0):e}},function(e,t,r){"use strict";var n=r(58);e.exports=function e(t,r){n(t)&&(t=t.valueOf());for(var i=0,a=t.length;i<a;i++){var o=t[i];Array.isArray(o)?e(o,r):r(o)}}},function(e,t,r){"use strict";function n(e,t,n,c){function d(t,r){if(!(this instanceof d))throw new SyntaxError("Constructor must be called with the new operator");if(r&&!h(r))throw new Error("Invalid datatype: "+r);if(e.isMatrix(t))"DenseMatrix"===t.type?(this._data=u.clone(t._data),this._size=u.clone(t._size),this._datatype=r||t._datatype):(this._data=t.toArray(),this._size=t.size(),this._datatype=r||t._datatype);else if(t&&f(t.data)&&f(t.size))this._data=t.data,this._size=t.size,this._datatype=r||t.datatype;else if(f(t))this._data=b(t),this._size=s.size(this._data),s.validate(this._data,this._size),this._datatype=r;else{if(t)throw new TypeError("Unsupported type of data ("+i.types.type(t)+")");this._data=[],this._size=[0],this._datatype=r}}function v(t,r){if(!e.isIndex(r))throw new TypeError("Invalid index");var n=r.isScalar();if(n)return t.get(r.min());var i=r.size();if(i.length!=t._size.length)throw new a(i.length,t._size.length);for(var o=r.min(),s=r.max(),u=0,c=t._size.length;u<c;u++)m(o[u],t._size[u]),m(s[u],t._size[u]);return new d(g(t._data,r,i.length,0),t._datatype)}function g(e,t,r,n){var i=n===r-1,a=t.dimension(n);return i?a.map(function(t){return m(t,e.length),e[t]}).valueOf():a.map(function(i){m(i,e.length);var a=e[i];return g(a,t,r,n+1)}).valueOf()}function y(t,r,n,i){if(!r||r.isIndex!==!0)throw new TypeError("Invalid index");var o,c=r.size(),f=r.isScalar();if(e.isMatrix(n)?(o=n.size(),n=n.valueOf()):o=s.size(n),f){if(0!==o.length)throw new TypeError("Scalar expected");t.set(r.min(),n,i)}else{if(c.length<t._size.length)throw new a(c.length,t._size.length,"<");if(o.length<c.length){for(var l=0,p=0;1===c[l]&&1===o[l];)l++;for(;1===c[l];)p++,l++;n=s.unsqueeze(n,c.length,p,o)}if(!u.deepEqual(c,o))throw new a(c,o,">");var h=r.max().map(function(e){return e+1});w(t,h,i);var m=c.length,d=0;x(t._data,r,n,m,d)}return t}function x(e,t,r,n,i){var a=i===n-1,o=t.dimension(i);a?o.forEach(function(t,n){m(t),e[t]=r[n[0]]}):o.forEach(function(a,o){m(a),x(e[a],t,r[o[0]],n,i+1)})}function w(e,t,r){for(var n=e._size.slice(0),i=!1;n.length<t.length;)n.push(0),i=!0;for(var a=0,o=t.length;a<o;a++)t[a]>n[a]&&(n[a]=t[a],i=!0);i&&E(e,n,r)}function b(e){for(var t=0,r=e.length;t<r;t++){var n=e[t];f(n)?e[t]=b(n):n&&n.isMatrix===!0&&(e[t]=b(n.valueOf()))}return e}var N=n(r(72));d.prototype=new N,d.prototype.type="DenseMatrix",d.prototype.isDenseMatrix=!0,d.prototype.storage=function(){return"dense"},d.prototype.datatype=function(){return this._datatype},d.prototype.create=function(e,t){return new d(e,t)},d.prototype.subset=function(e,t,r){switch(arguments.length){case 1:return v(this,e);case 2:case 3:return y(this,e,t,r);default:throw new SyntaxError("Wrong number of arguments")}},d.prototype.get=function(e){if(!f(e))throw new TypeError("Array expected");if(e.length!=this._size.length)throw new a(e.length,this._size.length);for(var t=0;t<e.length;t++)m(e[t],this._size[t]);for(var r=this._data,n=0,i=e.length;n<i;n++){var o=e[n];m(o,r.length),r=r[o]}return r},d.prototype.set=function(e,t,r){if(!f(e))throw new TypeError("Array expected");if(e.length<this._size.length)throw new a(e.length,this._size.length,"<");var n,i,o,s=e.map(function(e){return e+1});w(this,s,r);var u=this._data;for(n=0,i=e.length-1;n<i;n++)o=e[n],m(o,u.length),u=u[o];return o=e[e.length-1],m(o,u.length),u[o]=t,this},d.prototype.resize=function(e,t,r){if(!f(e))throw new TypeError("Array expected");var n=r?this.clone():this;return E(n,e,t)};var E=function(e,t,r){if(0===t.length){for(var n=e._data;f(n);)n=n[0];
return n}return e._size=t.slice(0),e._data=s.resize(e._data,e._size,r),e};return d.prototype.reshape=function(e,t){var r=t?this.clone():this;return r._data=s.reshape(r._data,e),r._size=e.slice(0),r},d.prototype.clone=function(){var e=new d({data:u.clone(this._data),size:u.clone(this._size),datatype:this._datatype});return e},d.prototype.size=function(){return this._size.slice(0)},d.prototype.map=function(e){var t=this,r=function(n,i){return f(n)?n.map(function(e,t){return r(e,i.concat(t))}):e(n,i,t)};return new d({data:r(this._data,[]),size:u.clone(this._size),datatype:this._datatype})},d.prototype.forEach=function(e){var t=this,r=function(n,i){f(n)?n.forEach(function(e,t){r(e,i.concat(t))}):e(n,i,t)};r(this._data,[])},d.prototype.toArray=function(){return u.clone(this._data)},d.prototype.valueOf=function(){return this._data},d.prototype.format=function(e){return o.format(this._data,e)},d.prototype.toString=function(){return o.format(this._data)},d.prototype.toJSON=function(){return{mathjs:"DenseMatrix",data:this._data,size:this._size,datatype:this._datatype}},d.prototype.diagonal=function(t){if(t){if(e.isBigNumber(t)&&(t=t.toNumber()),!l(t)||!p(t))throw new TypeError("The parameter k must be an integer number")}else t=0;for(var r=t>0?t:0,n=t<0?-t:0,i=this._size[0],a=this._size[1],o=Math.min(i-n,a-r),s=[],u=0;u<o;u++)s[u]=this._data[u+n][u+r];return new d({data:s,size:[o],datatype:this._datatype})},d.diagonal=function(t,r,n,i,a){if(!f(t))throw new TypeError("Array expected, size parameter");if(2!==t.length)throw new Error("Only two dimensions matrix are supported");if(t=t.map(function(t){if(e.isBigNumber(t)&&(t=t.toNumber()),!l(t)||!p(t)||t<1)throw new Error("Size values must be positive integers");return t}),n){if(e.isBigNumber(n)&&(n=n.toNumber()),!l(n)||!p(n))throw new TypeError("The parameter k must be an integer number")}else n=0;i&&h(a)&&(i=c.convert(i,a));var o,u=n>0?n:0,m=n<0?-n:0,v=t[0],g=t[1],y=Math.min(v-m,g-u);if(f(r)){if(r.length!==y)throw new Error("Invalid value array length");o=function(e){return r[e]}}else if(e.isMatrix(r)){var x=r.size();if(1!==x.length||x[0]!==y)throw new Error("Invalid matrix length");o=function(e){return r.get([e])}}else o=function(){return r};i||(i=e.isBigNumber(o(0))?new e.BigNumber(0):0);var w=[];if(t.length>0){w=s.resize(w,t,i);for(var b=0;b<y;b++)w[b+m][b+u]=o(b)}return new d({data:w,size:[v,g]})},d.fromJSON=function(e){return new d(e)},d.prototype.swapRows=function(e,t){if(!(l(e)&&p(e)&&l(t)&&p(t)))throw new Error("Row index must be positive integers");if(2!==this._size.length)throw new Error("Only two dimensional matrix is supported");return m(e,this._size[0]),m(t,this._size[0]),d._swapRows(e,t,this._data),this},d._swapRows=function(e,t,r){var n=r[e];r[e]=r[t],r[t]=n},e.Matrix._storage.dense=d,e.Matrix._storage.default=d,d}var i=r(25),a=r(10),o=(r(13).getSafeProperty,r(13).setSafeProperty,i.string),s=i.array,u=i.object,c=i.number,f=Array.isArray,l=c.isNumber,p=c.isInteger,h=o.isString,m=s.validateIndex;t.name="DenseMatrix",t.path="type",t.factory=n,t.lazy=!1},function(e,t,r){"use strict";function n(e,t,n,o){var s=n(r(0)),u=n(r(15)),c=n(r(26)),f=n(r(16)),l=n(r(8)),p=n(r(6)),h=r(4),m=o("smaller",{"boolean, boolean":function(e,t){return e<t},"number, number":function(e,r){return e<r&&!i(e,r,t.epsilon)},"BigNumber, BigNumber":function(e,r){return e.lt(r)&&!a(e,r,t.epsilon)},"Fraction, Fraction":function(e,t){return e.compare(t)===-1},"Complex, Complex":function(e,t){throw new TypeError("No ordering relation is defined for complex numbers")},"Unit, Unit":function(e,t){if(!e.equalBase(t))throw new Error("Cannot compare units with different base");return m(e.value,t.value)},"string, string":function(e,t){return e<t},"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=c(e,t,m);break;default:r=u(t,e,m,!0)}break;default:switch(t.storage()){case"sparse":r=u(e,t,m,!1);break;default:r=l(e,t,m)}}return r},"Array, Array":function(e,t){return m(s(e),s(t)).valueOf()},"Array, Matrix":function(e,t){return m(s(e),t)},"Matrix, Array":function(e,t){return m(e,s(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=f(e,t,m,!1);break;default:r=p(e,t,m,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=f(t,e,m,!0);break;default:r=p(t,e,m,!0)}return r},"Array, any":function(e,t){return p(s(e),t,m,!1).valueOf()},"any, Array":function(e,t){return p(s(t),e,m,!0).valueOf()}});return m.toTex={2:"\\left(${args[0]}"+h.operators.smaller+"${args[1]}\\right)"},m}var i=r(3).nearlyEqual,a=r(35);t.name="smaller",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,o){function s(r,n){if(t.predictable&&!i(n)&&r<0)try{var a=m(n),o=d(a);if((n===o||Math.abs((n-o)/n)<1e-14)&&a.d%2===1)return(a.n%2===0?1:-1)*Math.pow(-r,n)}catch(e){}return r*r<1&&n===1/0||r*r>1&&n===-(1/0)?0:t.predictable&&(r<-1&&n===1/0||r>-1&&r<0&&n===-(1/0))?NaN:i(n)||r>=0||t.predictable?Math.pow(r,n):new e.Complex(r,0).pow(n,0)}function u(e,t){if(!i(t)||t<0)throw new TypeError("For A^b, b must be a positive integer (value is "+t+")");var r=a(e);if(2!=r.length)throw new Error("For A^b, A must be 2 dimensional (A has "+r.length+" dimensions)");if(r[0]!=r[1])throw new Error("For A^b, A must be square (size is "+r[0]+"x"+r[1]+")");for(var n=l(r[0]).valueOf(),o=e;t>=1;)1==(1&t)&&(n=p(o,n)),t>>=1,o=p(o,o);return n}function c(e,t){return h(u(e.valueOf(),t))}var f=r(4),l=n(r(61)),p=n(r(12)),h=n(r(0)),m=n(r(92)),d=n(r(74)),v=o("pow",{"number, number":s,"Complex, Complex":function(e,t){return e.pow(t)},"BigNumber, BigNumber":function(r,n){return n.isInteger()||r>=0||t.predictable?r.pow(n):new e.Complex(r.toNumber(),0).pow(n.toNumber(),0)},"Fraction, Fraction":function(e,r){if(1!==r.d){if(t.predictable)throw new Error("Function pow does not support non-integer exponents for fractions.");return s(e.valueOf(),r.valueOf())}return e.pow(r)},"Array, number":u,"Array, BigNumber":function(e,t){return u(e,t.toNumber())},"Matrix, number":c,"Matrix, BigNumber":function(e,t){return c(e,t.toNumber())},"Unit, number":function(e,t){return e.pow(t)}});return v.toTex={2:"\\left(${args[0]}\\right)"+f.operators.pow+"{${args[1]}}"},v}var i=r(3).isInteger,a=r(2).size;t.name="pow",t.factory=n},function(e,t,r){"use strict";var n=r(58);e.exports=function(e){return Array.isArray(e)||n(e)}},function(e,t,r){"use strict";function n(e,t,n,a){var o=n(r(19)),s=n(r(12)),u=n(r(114)),c=n(r(0)),f=n(r(17)),l=n(r(6)),p=a("divide",i({"Array | Matrix, Array | Matrix":function(e,t){return s(e,u(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=f(e,t,o,!1);break;case"dense":r=l(e,t,o,!1)}return r},"Array, any":function(e,t){return l(c(e),t,o,!1).valueOf()},"any, Array | Matrix":function(e,t){return s(e,u(t))}},o.signatures));return p.toTex={2:"\\frac{${args[0]}}{${args[1]}}"},p}var i=r(5).extend;t.name="divide",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var o=n("isInteger",{number:a.isInteger,BigNumber:function(e){return e.isInt()},Fraction:function(e){return 1===e.d&&isFinite(e.n)},"Array | Matrix":function(e){return i(e,o)}});return o}var i=r(1),a=r(3);t.name="isInteger",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,o){var s=n(r(0)),u=n(r(15)),c=n(r(60)),f=n(r(16)),l=n(r(8)),p=n(r(6)),h=o("compare",{"boolean, boolean":function(e,t){return e===t?0:e>t?1:-1},"number, number":function(e,r){return e===r||i(e,r,t.epsilon)?0:e>r?1:-1},"BigNumber, BigNumber":function(r,n){return r.eq(n)||a(r,n,t.epsilon)?new e.BigNumber(0):new e.BigNumber(r.cmp(n))},"Fraction, Fraction":function(t,r){return new e.Fraction(t.compare(r))},"Complex, Complex":function(){throw new TypeError("No ordering relation is defined for complex numbers")},"Unit, Unit":function(e,t){if(!e.equalBase(t))throw new Error("Cannot compare units with different base");return h(e.value,t.value)},"string, string":function(e,t){return e===t?0:e>t?1:-1},"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=c(e,t,h);break;default:r=u(t,e,h,!0)}break;default:switch(t.storage()){case"sparse":r=u(e,t,h,!1);break;default:r=l(e,t,h)}}return r},"Array, Array":function(e,t){return h(s(e),s(t)).valueOf()},"Array, Matrix":function(e,t){return h(s(e),t)},"Matrix, Array":function(e,t){return h(e,s(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=f(e,t,h,!1);break;default:r=p(e,t,h,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=f(t,e,h,!0);break;default:r=p(t,e,h,!0)}return r},"Array, any":function(e,t){return p(s(e),t,h,!1).valueOf()},"any, Array":function(e,t){return p(s(t),e,h,!0).valueOf()}});return h.toTex=void 0,h}var i=r(3).nearlyEqual,a=r(35);t.name="compare",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,i){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");this.fn=e,this.count=t,this.min=r,this.max=i,this.message="Wrong number of arguments in function "+e+" ("+t+" provided, "+r+(void 0!=i?"-"+i:"")+" expected)",this.stack=(new Error).stack}n.prototype=new Error,n.prototype.constructor=Error,n.prototype.name="ArgumentsError",n.prototype.isArgumentsError=!0,e.exports=n},function(e,t,r){"use strict";function n(e,t,r){if(!(this instanceof n))throw new SyntaxError("Constructor must be called with the new operator");this.index=e,arguments.length<3?(this.min=0,this.max=t):(this.min=t,this.max=r),void 0!==this.min&&this.index<this.min?this.message="Index out of range ("+this.index+" < "+this.min+")":void 0!==this.max&&this.index>=this.max?this.message="Index out of range ("+this.index+" > "+(this.max-1)+")":this.message="Index out of range ("+this.index+")",this.stack=(new Error).stack}n.prototype=new RangeError,n.prototype.constructor=RangeError,n.prototype.name="IndexError",n.prototype.isIndexError=!0,e.exports=n},function(e,t,r){"use strict";function n(e,t){var r=e;"keep"!==t&&(r=e.getContent());for(var n=r.getIdentifier(),i=0;i<o.length;i++)if(n in o[i])return i;return null}function i(e,t){var r=e;"keep"!==t&&(r=e.getContent());var i=r.getIdentifier(),a=n(r,t);if(null===a)return null;var s=o[a][i];if(s.hasOwnProperty("associativity")){if("left"===s.associativity)return"left";if("right"===s.associativity)return"right";throw Error("'"+i+"' has the invalid associativity '"+s.associativity+"'.")}return null}function a(e,t,r){var i=e,a=t;if("keep"!==r)var i=e.getContent(),a=t.getContent();var s=i.getIdentifier(),u=a.getIdentifier(),c=n(i,r);if(null===c)return null;var f=o[c][s];if(f.hasOwnProperty("associativeWith")&&f.associativeWith instanceof Array){for(var l=0;l<f.associativeWith.length;l++)if(f.associativeWith[l]===u)return!0;return!1}return null}var o=[{AssignmentNode:{},FunctionAssignmentNode:{}},{ConditionalNode:{latexLeftParens:!1,latexRightParens:!1,latexParens:!1}},{"OperatorNode:or":{associativity:"left",associativeWith:[]}},{"OperatorNode:xor":{associativity:"left",associativeWith:[]}},{"OperatorNode:and":{associativity:"left",associativeWith:[]}},{"OperatorNode:bitOr":{associativity:"left",associativeWith:[]}},{"OperatorNode:bitXor":{associativity:"left",associativeWith:[]}},{"OperatorNode:bitAnd":{associativity:"left",associativeWith:[]}},{"OperatorNode:equal":{associativity:"left",associativeWith:[]},"OperatorNode:unequal":{associativity:"left",associativeWith:[]},"OperatorNode:smaller":{associativity:"left",associativeWith:[]},"OperatorNode:larger":{associativity:"left",associativeWith:[]},"OperatorNode:smallerEq":{associativity:"left",associativeWith:[]},"OperatorNode:largerEq":{associativity:"left",associativeWith:[]}},{"OperatorNode:leftShift":{associativity:"left",associativeWith:[]},"OperatorNode:rightArithShift":{associativity:"left",associativeWith:[]},"OperatorNode:rightLogShift":{associativity:"left",associativeWith:[]}},{"OperatorNode:to":{associativity:"left",associativeWith:[]}},{RangeNode:{}},{"OperatorNode:add":{associativity:"left",associativeWith:["OperatorNode:add","OperatorNode:subtract"]},"OperatorNode:subtract":{associativity:"left",associativeWith:[]}},{"OperatorNode:multiply":{associativity:"left",associativeWith:["OperatorNode:multiply","OperatorNode:divide","Operator:dotMultiply","Operator:dotDivide"]},"OperatorNode:divide":{associativity:"left",associativeWith:[],latexLeftParens:!1,latexRightParens:!1,latexParens:!1},"OperatorNode:dotMultiply":{associativity:"left",associativeWith:["OperatorNode:multiply","OperatorNode:divide","OperatorNode:dotMultiply","OperatorNode:doDivide"]},"OperatorNode:dotDivide":{associativity:"left",associativeWith:[]},"OperatorNode:mod":{associativity:"left",associativeWith:[]}},{"OperatorNode:unaryPlus":{associativity:"right"},"OperatorNode:unaryMinus":{associativity:"right"},"OperatorNode:bitNot":{associativity:"right"},"OperatorNode:not":{associativity:"right"}},{"OperatorNode:pow":{associativity:"right",associativeWith:[],latexRightParens:!1},"OperatorNode:dotPow":{associativity:"right",associativeWith:[]}},{"OperatorNode:factorial":{associativity:"left"}},{"OperatorNode:transpose":{associativity:"left"}}];e.exports.properties=o,e.exports.getPrecedence=n,e.exports.getAssociativity=i,e.exports.isAssociativeWith=a},function(e,t,r){"use strict";function n(e,t,n,s){function u(e,t){if(!(this instanceof u))throw new SyntaxError("Constructor must be called with the new operator");if(t){if("string"!=typeof t)throw new TypeError('String expected for parameter "valueType"');if("string"!=typeof e)throw new TypeError('String expected for parameter "value"');this.value=e,this.valueType=t}else this.value=e+"",this.valueType=i(e);if(!h[this.valueType])throw new TypeError('Unsupported type of value "'+this.valueType+'"')}function c(e,r,n){if(!(e instanceof u))throw new TypeError("No valid ConstantNode");switch(e.valueType){case"number":return"BigNumber"===t.number?"math.bignumber("+a(e.value)+")":"Fraction"===t.number?"math.fraction("+a(e.value)+")":(f(e.value),e.value.replace(/^(0*)[0-9]/,function(e,t){return e.substring(t.length)}));case"string":return a(e.value);case"boolean":return"true"===String(e.value)?"true":"false";case"undefined":return"undefined";case"null":return"null";default:throw new TypeError('Unsupported type of constant "'+e.valueType+'"')}}function f(e){if("string"!=typeof e||!/^[\-+]?((\d+\.?\d*)|(\d*\.?\d+))([eE][+\-]?\d+)?$/.test(e))throw new Error('Invalid numeric value "'+e+'"')}var l=n(r(7)).register,p=(n(r(7)).compile,n(r(14))),h={number:!0,string:!0,boolean:!0,undefined:!0,null:!0};return u.prototype=new p,u.prototype.type="ConstantNode",u.prototype.isConstantNode=!0,l(u.prototype.type,c),u.prototype.forEach=function(e){},u.prototype.map=function(e){return this.clone()},u.prototype.clone=function(){return new u(this.value,this.valueType)},u.prototype._toString=function(e){switch(this.valueType){case"string":return a(this.value);default:return this.value}},u.prototype.toHTML=function(e){var t=o(this.value);switch(this.valueType){case"number":return'<span class="math-number">'+t+"</span>";case"string":return'<span class="math-string">'+t+"</span>";case"boolean":return'<span class="math-boolean">'+t+"</span>";case"null":return'<span class="math-null-symbol">'+t+"</span>";case"undefined":return'<span class="math-undefined">'+t+"</span>";default:return'<span class="math-symbol">'+t+"</span>"}},u.prototype._toTex=function(e){var t,r=this.value;switch(this.valueType){case"string":return"\\mathtt{"+a(r)+"}";case"number":return t=r.toLowerCase().indexOf("e"),t!==-1?r.substring(0,t)+"\\cdot10^{"+r.substring(t+1)+"}":r;default:return r}},u}var i=r(59).type,a=r(9).stringify,o=r(9).escape;t.name="ConstantNode",t.path="expression.node",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,h,m){function d(t,r){if(!(this instanceof d))throw new SyntaxError("Constructor must be called with the new operator");if("string"==typeof t&&(t=new N(t)),!e.isNode(t))throw new TypeError('Node expected as parameter "fn"');if(!Array.isArray(r)||!r.every(e.isNode))throw new TypeError('Array containing Nodes expected for parameter "args"');this.fn=t,this.args=r||[],Object.defineProperty(this,"name",{get:function(){return this.fn.name||""}.bind(this),set:function(){throw new Error("Cannot assign a new name, name is read-only")}});var n=function(){throw new Error("Property `FunctionNode.object` is deprecated, use `FunctionNode.fn` instead")};Object.defineProperty(this,"object",{get:n,set:n})}function v(t,r,n){if(!(t instanceof d))throw new TypeError("No valid FunctionNode");var i,o=w(t.fn,r,n),s=c(t.args,function(e){return w(e,r,n)}),h=g(r,n);if(e.isSymbolNode(t.fn)){var m=t.fn.name,v=u(r.math,m)?r.math[m]:void 0,y="function"==typeof v&&1==v.rawArgs;return y?(i=p(r),r[i]=t.args,o+"("+i+", math, "+h+")"):o+"("+f(s,", ")+")"}if(e.isAccessorNode(t.fn)&&e.isIndexNode(t.fn.index)&&t.fn.index.isObjectProperty()){i=p(r),r[i]=t.args,r.validateSafeMethod=l;var x=w(t.fn.object,r,n),b=a(t.fn.index.getObjectProperty());return"(function () {var object = "+x+";validateSafeMethod(object, "+b+");return (object["+b+"] && object["+b+"].rawArgs)  ? object["+b+"]("+i+", math, "+h+") : object["+b+"]("+f(s,", ")+")})()"}return i=p(r),r[i]=t.args,"(function () {var fn = "+o+";return (fn && fn.rawArgs)  ? fn("+i+", math, "+h+") : fn("+f(s,", ")+")})()"}function g(e,t){var r=Object.keys(t);if(0===r.length)return"scope";e.extend=s;var n=c(r,function(e){return a(e)+": "+t[e]});return"extend(extend({}, scope), {"+f(n,", ")+"})"}function y(t,r,n){for(var i,a="",o=new RegExp("\\$(?:\\{([a-z_][a-z_0-9]*)(?:\\[([0-9]+)\\])?\\}|\\$)","ig"),s=0;null!==(i=o.exec(t));)if(a+=t.substring(s,i.index),s=i.index,"$$"===i[0])a+="$",s++;else{s+=i[0].length;var u=r[i[1]];if(!u)throw new ReferenceError("Template: Property "+i[1]+" does not exist.");if(void 0===i[2])switch(typeof u){case"string":a+=u;break;case"object":if(e.isNode(u))a+=u.toTex(n);else{if(!Array.isArray(u))throw new TypeError("Template: "+i[1]+" has to be a Node, String or array of Nodes");a+=u.map(function(t,r){if(e.isNode(t))return t.toTex(n);throw new TypeError("Template: "+i[1]+"["+r+"] is not a Node.")}).join(",")}break;default:throw new TypeError("Template: "+i[1]+" has to be a Node, String or array of Nodes")}else{if(!e.isNode(u[i[2]]&&u[i[2]]))throw new TypeError("Template: "+i[1]+"["+i[2]+"] is not a Node.");a+=u[i[2]].toTex(n)}}return a+=t.slice(s)}var x=n(r(7)).register,w=n(r(7)).compile,b=n(r(14)),N=n(r(40));d.prototype=new b,d.prototype.type="FunctionNode",d.prototype.isFunctionNode=!0,x(d.prototype.type,v),d.prototype.forEach=function(e){for(var t=0;t<this.args.length;t++)e(this.args[t],"args["+t+"]",this)},d.prototype.map=function(e){for(var t=this.fn.map(e),r=[],n=0;n<this.args.length;n++)r[n]=this._ifNode(e(this.args[n],"args["+n+"]",this));return new d(t,r)},d.prototype.clone=function(){return new d(this.fn,this.args.slice(0))};var E=d.prototype.toString;d.prototype.toString=function(e){var t,r=this.fn.toString(e);return e&&"object"==typeof e.handler&&u(e.handler,r)&&(t=e.handler[r](this,e)),"undefined"!=typeof t?t:E.call(this,e)},d.prototype._toString=function(t){var r=this.args.map(function(e){return e.toString(t)}),n=e.isFunctionAssignmentNode(this.fn)?"("+this.fn.toString(t)+")":this.fn.toString(t);return n+"("+r.join(", ")+")"},d.prototype.toHTML=function(e){var t=this.args.map(function(t){return t.toHTML(e)});return'<span class="math-function">'+o(this.fn)+'</span><span class="math-paranthesis math-round-parenthesis">(</span>'+t.join('<span class="math-separator">,</span>')+'<span class="math-paranthesis math-round-parenthesis">)</span>'};var M=d.prototype.toTex;return d.prototype.toTex=function(e){var t;return e&&"object"==typeof e.handler&&u(e.handler,this.name)&&(t=e.handler[this.name](this,e)),"undefined"!=typeof t?t:M.call(this,e)},d.prototype._toTex=function(e){var t,r=this.args.map(function(t){return t.toTex(e)});!m[this.name]||"function"!=typeof m[this.name].toTex&&"object"!=typeof m[this.name].toTex&&"string"!=typeof m[this.name].toTex||(t=m[this.name].toTex);var n;switch(typeof t){case"function":n=t(this,e);break;case"string":n=y(t,this,e);break;case"object":switch(typeof t[r.length]){case"function":n=t[r.length](this,e);break;case"string":n=y(t[r.length],this,e)}}return"undefined"!=typeof n?n:y(i.defaultTemplate,this,e)},d.prototype.getIdentifier=function(){return this.type+":"+this.name},d}var i=r(4),a=r(9).stringify,o=r(9).escape,s=r(5).extend,u=r(5).hasOwnProperty,c=r(2).map,f=r(2).join,l=r(13).validateSafeMethod,p=r(108);t.name="FunctionNode",t.path="expression.node",t.math=!0,t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("isPositive",{number:function(e){return e>0},BigNumber:function(e){return!e.isNeg()&&!e.isZero()&&!e.isNaN()},Fraction:function(e){return e.s>0&&e.n>0},Unit:function(e){return a(e.value)},"Array | Matrix":function(e){return i(e,a)}});return a}var i=r(1);r(3);t.name="isPositive",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){function a(r){return r>=0||t.predictable?Math.sqrt(r):new e.Complex(r,0).sqrt()}var o=n("sqrt",{number:a,Complex:function(e){return e.sqrt()},BigNumber:function(e){return!e.isNegative()||t.predictable?e.sqrt():a(e.toNumber())},"Array | Matrix":function(e){return i(e,o,!0)},Unit:function(e){return e.pow(.5)}});return o.toTex={1:"\\sqrt{${args[0]}}"},o}var i=r(1);t.name="sqrt",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("isNegative",{number:function(e){return e<0},BigNumber:function(e){return e.isNeg()&&!e.isZero()&&!e.isNaN()},Fraction:function(e){return e.s<0},Unit:function(e){return a(e.value)},"Array | Matrix":function(e){return i(e,a)}});return a}var i=r(1);r(3);t.name="isNegative",t.factory=n},function(e,t,r){"use strict";e.exports=function(e){return e&&e.constructor.prototype.isMatrix||!1}},function(e,t,r){"use strict";t.type=function(e){var t=typeof e;return"object"===t?null===e?"null":Array.isArray(e)?"Array":e instanceof Date?"Date":e instanceof RegExp?"RegExp":e instanceof Boolean?"boolean":e instanceof Number?"number":e instanceof String?"string":"Object":"function"===t?"Function":t}},function(e,t,r){"use strict";function n(e,t,n,a){var o=n(r(11)),s=e.SparseMatrix,u=function(e,t,r){var n=e._values,u=e._index,c=e._ptr,f=e._size,l=e._datatype,p=t._values,h=t._index,m=t._ptr,d=t._size,v=t._datatype;if(f.length!==d.length)throw new i(f.length,d.length);if(f[0]!==d[0]||f[1]!==d[1])throw new RangeError("Dimension mismatch. Matrix A ("+f+") must match Matrix B ("+d+")");var g,y=f[0],x=f[1],w=o,b=0,N=r;"string"==typeof l&&l===v&&(g=l,w=a.find(o,[g,g]),b=a.convert(0,g),N=a.find(r,[g,g]));var E,M,A,O,T=n&&p?[]:void 0,_=[],S=[],C=new s({values:T,index:_,ptr:S,size:[y,x],datatype:g}),z=T?[]:void 0,k=T?[]:void 0,I=[],B=[];for(M=0;M<x;M++){S[M]=_.length;var P=M+1;for(A=c[M],O=c[M+1];A<O;A++)E=u[A],_.push(E),I[E]=P,z&&(z[E]=n[A]);for(A=m[M],O=m[M+1];A<O;A++)E=h[A],I[E]!==P&&_.push(E),B[E]=P,k&&(k[E]=p[A]);if(T)for(A=S[M];A<_.length;){E=_[A];var R=I[E],U=B[E];if(R===P||U===P){var q=R===P?z[E]:b,L=U===P?k[E]:b,j=N(q,L);w(j,b)?_.splice(A,1):(T.push(j),A++)}}}return S[x]=_.length,C};return u}var i=r(10);t.name="algorithm05",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,o){function s(e,t){switch(e.length){case 0:return t?c(t):[];case 1:return u(e[0],e[0],t);case 2:return u(e[0],e[1],t);default:throw new Error("Vector containing two values expected")}}function u(t,r,n){var o=e.isBigNumber(t)||e.isBigNumber(r)?e.BigNumber:null;if(e.isBigNumber(t)&&(t=t.toNumber()),e.isBigNumber(r)&&(r=r.toNumber()),!a(t)||t<1)throw new Error("Parameters in function eye must be positive integers");if(!a(r)||r<1)throw new Error("Parameters in function eye must be positive integers");var s=o?new e.BigNumber(1):1,u=o?new o(0):0,c=[t,r];if(n){var f=e.Matrix.storage(n);return f.diagonal(c,s,0,u)}for(var l=i.resize([],c,u),p=t<r?t:r,h=0;h<p;h++)l[h][h]=s;return l}var c=n(r(0)),f=o("eye",{"":function(){return"Matrix"===t.matrix?c([]):[]},string:function(e){return c(e)},"number | BigNumber":function(e){return u(e,e,"Matrix"===t.matrix?"default":void 0)},"number | BigNumber, string":function(e,t){return u(e,e,t)},"number | BigNumber, number | BigNumber":function(e,r){return u(e,r,"Matrix"===t.matrix?"default":void 0)},"number | BigNumber, number | BigNumber, string":function(e,t,r){return u(e,t,r)},Array:function(e){return s(e)},"Array, string":function(e,t){return s(e,t)},Matrix:function(e){return s(e.valueOf(),e.storage())},"Matrix, string":function(e,t){return s(e.valueOf(),t)}});return f.toTex=void 0,f}var i=r(2),a=r(3).isInteger;t.name="eye",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,l){function p(t,r,n,i){if(!(this instanceof p))throw new SyntaxError("Constructor must be called with the new operator");if("string"!=typeof t)throw new TypeError('string expected for parameter "op"');if("string"!=typeof r)throw new TypeError('string expected for parameter "fn"');if(!Array.isArray(n)||!n.every(e.isNode))throw new TypeError('Array containing Nodes expected for parameter "args"');this.implicit=i===!0,this.op=t,this.fn=r,this.args=n||[]}function h(e,t,r){if(!(e instanceof p))throw new TypeError("No valid OperatorNode");if("string"!=typeof e.fn||!c(t.math,e.fn))throw t.math[e.fn]?new Error('No access to function "'+e.fn+'"'):new Error("Function "+e.fn+' missing in provided namespace "math"');var n=a(e.args,function(e){return v(e,t,r)});return"math["+s(e.fn)+"]("+o(n,", ")+")"}function m(e,t,r,n,i){var a=f.getPrecedence(e,t),o=f.getAssociativity(e,t);if("all"===t||n.length>2&&"OperatorNode:add"!==e.getIdentifier()&&"OperatorNode:multiply"!==e.getIdentifier()){var s=n.map(function(e){switch(e.getContent().type){case"ArrayNode":case"ConstantNode":case"SymbolNode":case"ParenthesisNode":return!1;default:return!0}});return s}var u=void 0;switch(n.length){case 0:u=[];break;case 1:var c=f.getPrecedence(n[0],t);if(i&&null!==c){var l,p;if("keep"===t?(l=n[0].getIdentifier(),p=e.getIdentifier()):(l=n[0].getContent().getIdentifier(),p=e.getContent().getIdentifier()),f.properties[a][p].latexLeftParens===!1){u=[!1];break}if(f.properties[c][l].latexParens===!1){u=[!1];break}}if(null===c){u=[!1];break}if(c<=a){u=[!0];break}u=[!1];break;case 2:var h,m=f.getPrecedence(n[0],t),d=f.isAssociativeWith(e,n[0],t);h=null!==m&&(m===a&&"right"===o&&!d||m<a);var v,g=f.getPrecedence(n[1],t),y=f.isAssociativeWith(e,n[1],t);if(v=null!==g&&(g===a&&"left"===o&&!y||g<a),i){var p,x,w;"keep"===t?(p=e.getIdentifier(),x=e.args[0].getIdentifier(),w=e.args[1].getIdentifier()):(p=e.getContent().getIdentifier(),x=e.args[0].getContent().getIdentifier(),w=e.args[1].getContent().getIdentifier()),null!==m&&(f.properties[a][p].latexLeftParens===!1&&(h=!1),f.properties[m][x].latexParens===!1&&(h=!1)),null!==g&&(f.properties[a][p].latexRightParens===!1&&(v=!1),f.properties[g][w].latexParens===!1&&(v=!1))}u=[h,v];break;default:if("OperatorNode:add"===e.getIdentifier()||"OperatorNode:multiply"===e.getIdentifier())var u=n.map(function(r){var n=f.getPrecedence(r,t),i=f.isAssociativeWith(e,r,t),s=f.getAssociativity(r,t);return null!==n&&(a===n&&o===s&&!i||n<a)})}return n.length>=2&&"OperatorNode:multiply"===e.getIdentifier()&&e.implicit&&"auto"===t&&"hide"===r&&(u=n.map(function(e,t){var r="ParenthesisNode"===e.getIdentifier();return!(!u[t]&&!r)})),u}var d=n(r(7)).register,v=n(r(7)).compile,g=n(r(14));n(r(53)),n(r(40)),n(r(54));return p.prototype=new g,p.prototype.type="OperatorNode",p.prototype.isOperatorNode=!0,d(p.prototype.type,h),p.prototype.forEach=function(e){for(var t=0;t<this.args.length;t++)e(this.args[t],"args["+t+"]",this)},p.prototype.map=function(e){for(var t=[],r=0;r<this.args.length;r++)t[r]=this._ifNode(e(this.args[r],"args["+r+"]",this));return new p(this.op,this.fn,t)},p.prototype.clone=function(){return new p(this.op,this.fn,this.args.slice(0),this.implicit)},p.prototype._toString=function(e){var t=e&&e.parenthesis?e.parenthesis:"keep",r=e&&e.implicit?e.implicit:"hide",n=this.args,i=m(this,t,r,n,!1);if(1===n.length){var a=f.getAssociativity(this,t),o=n[0].toString(e);return i[0]&&(o="("+o+")"),"right"===a?this.op+o:"left"===a?o+this.op:o+this.op}if(2==n.length){var s=n[0].toString(e),u=n[1].toString(e);return i[0]&&(s="("+s+")"),i[1]&&(u="("+u+")"),this.implicit&&"OperatorNode:multiply"===this.getIdentifier()&&"hide"==r?s+" "+u:s+" "+this.op+" "+u}if(n.length>2&&("OperatorNode:add"===this.getIdentifier()||"OperatorNode:multiply"===this.getIdentifier())){var c=n.map(function(t,r){return t=t.toString(e),i[r]&&(t="("+t+")"),t});return this.implicit&&"OperatorNode:multiply"===this.getIdentifier()&&"hide"===r?c.join(" "):c.join(" "+this.op+" ")}return this.fn+"("+this.args.join(", ")+")"},p.prototype.toHTML=function(e){var t=e&&e.parenthesis?e.parenthesis:"keep",r=e&&e.implicit?e.implicit:"hide",n=this.args,i=m(this,t,r,n,!1);if(1===n.length){var a=f.getAssociativity(this,t),o=n[0].toHTML(e);return i[0]&&(o='<span class="math-parenthesis math-round-parenthesis">(</span>'+o+'<span class="math-parenthesis math-round-parenthesis">)</span>'),"right"===a?'<span class="math-operator math-unary-operator math-lefthand-unary-operator">'+u(this.op)+"</span>"+o:"left"===a?'<span class="math-operator math-unary-operator math-righthand-unary-operator">'+u(this.op)+"</span>"+o:'<span class="math-operator math-unary-operator math-righthand-unary-operator">'+u(this.op)+"</span>"+o}if(2==n.length){var s=n[0].toHTML(e),c=n[1].toHTML(e);return i[0]&&(s='<span class="math-parenthesis math-round-parenthesis">(</span>'+s+'<span class="math-parenthesis math-round-parenthesis">)</span>'),i[1]&&(c='<span class="math-parenthesis math-round-parenthesis">(</span>'+c+'<span class="math-parenthesis math-round-parenthesis">)</span>'),this.implicit&&"OperatorNode:multiply"===this.getIdentifier()&&"hide"==r?s+'<span class="math-operator math-binary-operator math-implicit-binary-operator"></span>'+c:s+'<span class="math-operator math-binary-operator math-explicit-binary-operator">'+u(this.op)+"</span>"+c}if(n.length>2&&("OperatorNode:add"===this.getIdentifier()||"OperatorNode:multiply"===this.getIdentifier())){var l=n.map(function(t,r){return t=t.toHTML(e),i[r]&&(t='<span class="math-parenthesis math-round-parenthesis">(</span>'+t+'<span class="math-parenthesis math-round-parenthesis">)</span>'),t});return this.implicit&&"OperatorNode:multiply"===this.getIdentifier()&&"hide"===r?l.join('<span class="math-operator math-binary-operator math-implicit-binary-operator"></span>'):l.join('<span class="math-operator math-binary-operator math-explicit-binary-operator">'+u(this.op)+"</span>")}return'<span class="math-function">'+u(this.fn)+'</span><span class="math-paranthesis math-round-parenthesis">(</span>'+l.join('<span class="math-separator">,</span>')+'<span class="math-paranthesis math-round-parenthesis">)</span>'},p.prototype._toTex=function(e){var t=e&&e.parenthesis?e.parenthesis:"keep",r=e&&e.implicit?e.implicit:"hide",n=this.args,a=m(this,t,r,n,!0),o=i.operators[this.fn];if(o="undefined"==typeof o?this.op:o,1===n.length){var s=f.getAssociativity(this,t),u=n[0].toTex(e);return a[0]&&(u="\\left("+u+"\\right)"),"right"===s?o+u:"left"===s?u+o:u+o}if(2===n.length){var c=n[0],l=c.toTex(e);a[0]&&(l="\\left("+l+"\\right)");var p=n[1],h=p.toTex(e);a[1]&&(h="\\left("+h+"\\right)");var d;switch(d="keep"===t?c.getIdentifier():c.getContent().getIdentifier(),this.getIdentifier()){case"OperatorNode:divide":return o+"{"+l+"}{"+h+"}";case"OperatorNode:pow":switch(l="{"+l+"}",h="{"+h+"}",d){case"ConditionalNode":case"OperatorNode:divide":l="\\left("+l+"\\right)"}case"OperatorNode:multiply":if(this.implicit&&"hide"===r)return l+"~"+h}return l+o+h}if(n.length>2&&("OperatorNode:add"===this.getIdentifier()||"OperatorNode:multiply"===this.getIdentifier())){var v=n.map(function(t,r){return t=t.toTex(e),a[r]&&(t="\\left("+t+"\\right)"),t});return"OperatorNode:multiply"===this.getIdentifier()&&this.implicit?v.join("~"):v.join(o)}return"\\mathrm{"+this.fn+"}\\left("+n.map(function(t){return t.toTex(e);
}).join(",")+"\\right)"},p.prototype.getIdentifier=function(){return this.type+":"+this.fn},p}var i=r(4),a=r(2).map,o=r(2).join,s=r(9).stringify,u=r(9).escape,c=r(13).isSafeMethod,f=r(52);t.name="OperatorNode",t.path="expression.node",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,i){function a(t){if(!(this instanceof a))throw new SyntaxError("Constructor must be called with the new operator");if(!e.isNode(t))throw new TypeError('Node expected for parameter "content"');this.content=t}function o(e,t,r){if(!(e instanceof a))throw new TypeError("No valid ParenthesisNode");return u(e.content,t,r)}var s=n(r(7)).register,u=n(r(7)).compile,c=n(r(14));return a.prototype=new c,a.prototype.type="ParenthesisNode",a.prototype.isParenthesisNode=!0,s(a.prototype.type,o),a.prototype.getContent=function(){return this.content.getContent()},a.prototype.forEach=function(e){e(this.content,"content",this)},a.prototype.map=function(e){var t=e(this.content,"content",this);return new a(t)},a.prototype.clone=function(){return new a(this.content)},a.prototype._toString=function(e){return!e||e&&!e.parenthesis||e&&"keep"===e.parenthesis?"("+this.content.toString(e)+")":this.content.toString(e)},a.prototype.toHTML=function(e){return!e||e&&!e.parenthesis||e&&"keep"===e.parenthesis?'<span class="math-parenthesis math-round-parenthesis">(</span>'+this.content.toHTML(e)+'<span class="math-parenthesis math-round-parenthesis">)</span>':this.content.toHTML(e)},a.prototype._toTex=function(e){return!e||e&&!e.parenthesis||e&&"keep"===e.parenthesis?"\\left("+this.content.toTex(e)+"\\right)":this.content.toTex(e)},a}t.name="ParenthesisNode",t.path="expression.node",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,f){var l=n(r(0)),p=f("concat",{"...Array | Matrix | number | BigNumber":function(t){var r,n,f=t.length,p=-1,h=!1,m=[];for(r=0;r<f;r++){var d=t[r];if(e.isMatrix(d)&&(h=!0),e.isNumber(d)||e.isBigNumber(d)){if(r!==f-1)throw new Error("Dimension must be specified as last argument");if(n=p,p=d.valueOf(),!o(p))throw new TypeError("Integer number expected for dimension");if(p<0||r>0&&p>n)throw new u(p,n+1)}else{var v=a(d).valueOf(),g=s.size(v);if(m[r]=v,n=p,p=g.length-1,r>0&&p!=n)throw new c(n+1,p+1)}}if(0==m.length)throw new SyntaxError("At least one matrix expected");for(var y=m.shift();m.length;)y=i(y,m.shift(),p,0);return h?l(y):y},"...string":function(e){return e.join("")}});return p.toTex=void 0,p}function i(e,t,r,n){if(n<r){if(e.length!=t.length)throw new c(e.length,t.length);for(var a=[],o=0;o<e.length;o++)a[o]=i(e[o],t[o],r,n+1);return a}return e.concat(t)}var a=r(5).clone,o=r(3).isInteger,s=r(2),u=r(51),c=r(10);t.name="concat",t.factory=n},function(e,t,r){"use strict";function n(e,t,r){var a,o,s,u;if(t<=0){if(Array.isArray(e[0])){for(u=i(e),o=[],a=0;a<u.length;a++)o[a]=n(u[a],t-1,r);return o}for(s=e[0],a=1;a<e.length;a++)s=r(s,e[a]);return s}for(o=[],a=0;a<e.length;a++)o[a]=n(e[a],t-1,r);return o}function i(e){var t,r,n=e.length,i=e[0].length,a=[];for(r=0;r<i;r++){var o=[];for(t=0;t<n;t++)o.push(e[t][r]);a.push(o)}return a}var a=r(2).size,o=r(58),s=r(51);e.exports=function(e,t,r){var i=Array.isArray(e)?a(e):e.size();if(t<0||t>=i.length)throw new s(t,i.length);return o(e)?e.create(n(e.valueOf(),t,r)):n(e,t,r)}},function(e,t,r){"use strict";var n=r(46);e.exports=function(e){for(var t=0;t<e.length;t++)if(n(e[t]))return!0;return!1}},function(e,t,r){"use strict";function n(e,t,n,o){var s=r(4),u=n(r(0)),c=e.DenseMatrix,f=e.SparseMatrix,l=o("transpose",{Array:function(e){return l(u(e)).valueOf()},Matrix:function(e){var t,r=e.size();switch(r.length){case 1:t=e.clone();break;case 2:var n=r[0],i=r[1];if(0===i)throw new RangeError("Cannot transpose a 2D matrix with no columns (size: "+a(r)+")");switch(e.storage()){case"dense":t=p(e,n,i);break;case"sparse":t=h(e,n,i)}break;default:throw new RangeError("Matrix must be a vector or two dimensional (size: "+a(this._size)+")")}return t},any:function(e){return i(e)}}),p=function(e,t,r){for(var n,a=e._data,o=[],s=0;s<r;s++){n=o[s]=[];for(var u=0;u<t;u++)n[u]=i(a[u][s])}return new c({data:o,size:[r,t],datatype:e._datatype})},h=function(e,t,r){for(var n=e._values,a=e._index,o=e._ptr,s=n?[]:void 0,u=[],c=[],l=[],p=0;p<t;p++)l[p]=0;var h,m,d;for(h=0,m=a.length;h<m;h++)l[a[h]]++;for(var v=0,g=0;g<t;g++)c.push(v),v+=l[g],l[g]=c[g];for(c.push(v),d=0;d<r;d++)for(var y=o[d],x=o[d+1],w=y;w<x;w++){var b=l[a[w]]++;u[b]=d,n&&(s[b]=i(n[w]))}return new f({values:s,index:u,ptr:c,size:[r,t],datatype:e._datatype})};return l.toTex={1:"\\left(${args[0]}\\right)"+s.operators.transpose},l}var i=r(5).clone,a=r(9).format;t.name="transpose",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,o){var s=n(r(11)),u=e.SparseMatrix,c=function(e,t,r){var n=e._values,c=e._size,f=e._datatype,l=t._values,p=t._size,h=t._datatype;if(c.length!==p.length)throw new a(c.length,p.length);if(c[0]!==p[0]||c[1]!==p[1])throw new RangeError("Dimension mismatch. Matrix A ("+c+") must match Matrix B ("+p+")");var m,d=c[0],v=c[1],g=s,y=0,x=r;"string"==typeof f&&f===h&&(m=f,g=o.find(s,[m,m]),y=o.convert(0,m),x=o.find(r,[m,m]));for(var w=n&&l?[]:void 0,b=[],N=[],E=new u({values:w,index:b,ptr:N,size:[d,v],datatype:m}),M=w?[]:void 0,A=[],O=[],T=0;T<v;T++){N[T]=b.length;var _=T+1;if(i(e,T,A,M,O,_,E,x),i(t,T,A,M,O,_,E,x),M)for(var S=N[T];S<b.length;){var C=b[S];if(O[C]===_){var z=M[C];g(z,y)?b.splice(S,1):(w.push(z),S++)}else b.splice(S,1)}else for(var k=N[T];k<b.length;){var I=b[k];O[I]!==_?b.splice(k,1):k++}}return N[v]=b.length,E};return c}var i=r(436),a=r(10);t.name="algorithm06",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){var o=n(r(137)),s=r(4),u=a("factorial",{number:function(e){if(e<0)throw new Error("Value must be non-negative");return o(e+1)},BigNumber:function(e){if(e.isNegative())throw new Error("Value must be non-negative");return o(e.plus(1))},"Array | Matrix":function(e){return i(e,u)}});return u.toTex={1:"\\left(${args[0]}\\right)"+s.operators.factorial},u}var i=r(1);t.name="factorial",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var o=n("combinations",{"number, number":function(e,t){var r,n,i;if(!a(e)||e<0)throw new TypeError("Positive integer value expected in function combinations");if(!a(t)||t<0)throw new TypeError("Positive integer value expected in function combinations");if(t>e)throw new TypeError("k must be less than or equal to n");for(r=Math.max(t,e-t),n=1,i=1;i<=e-r;i++)n=n*(r+i)/i;return n},"BigNumber, BigNumber":function(t,r){var n,a,o,s,u=new e.BigNumber(1);if(!i(t)||!i(r))throw new TypeError("Positive integer value expected in function combinations");if(r.gt(t))throw new TypeError("k must be less than n in function combinations");for(n=t.minus(r),r.lt(n)&&(n=r),a=u,o=u,s=t.minus(n);o.lte(s);o=o.plus(1))a=a.times(n.plus(o)).dividedBy(o);return a}});return o.toTex={2:"\\binom{${args[0]}}{${args[1]}}"},o}function i(e){return e.isInteger()&&e.gte(0)}var a=r(3).isInteger;t.name="combinations",t.factory=n},function(e,t){e.exports=function(e){return e&&e.constructor.prototype.isBigNumber||!1}},function(e,t,r){"use strict";function n(e,t,r,n){function i(){if(!(this instanceof i))throw new SyntaxError("Constructor must be called with the new operator")}return i.prototype.type="Matrix",i.prototype.isMatrix=!0,i.storage=function(e){if(!o(e))throw new TypeError("format must be a string value");var t=i._storage[e];if(!t)throw new SyntaxError("Unsupported matrix storage format: "+e);return t},i._storage={},i.prototype.storage=function(){throw new Error("Cannot invoke storage on a Matrix interface")},i.prototype.datatype=function(){throw new Error("Cannot invoke datatype on a Matrix interface")},i.prototype.create=function(e,t){throw new Error("Cannot invoke create on a Matrix interface")},i.prototype.subset=function(e,t,r){throw new Error("Cannot invoke subset on a Matrix interface")},i.prototype.get=function(e){throw new Error("Cannot invoke get on a Matrix interface")},i.prototype.set=function(e,t,r){throw new Error("Cannot invoke set on a Matrix interface")},i.prototype.resize=function(e,t){throw new Error("Cannot invoke resize on a Matrix interface")},i.prototype.reshape=function(e,t){throw new Error("Cannot invoke reshape on a Matrix interface")},i.prototype.clone=function(){throw new Error("Cannot invoke clone on a Matrix interface")},i.prototype.size=function(){throw new Error("Cannot invoke size on a Matrix interface")},i.prototype.map=function(e,t){throw new Error("Cannot invoke map on a Matrix interface")},i.prototype.forEach=function(e){throw new Error("Cannot invoke forEach on a Matrix interface")},i.prototype.toArray=function(){throw new Error("Cannot invoke toArray on a Matrix interface")},i.prototype.valueOf=function(){throw new Error("Cannot invoke valueOf on a Matrix interface")},i.prototype.format=function(e){throw new Error("Cannot invoke format on a Matrix interface")},i.prototype.toString=function(){throw new Error("Cannot invoke toString on a Matrix interface")},i}var i=r(25),a=i.string,o=a.isString;t.name="Matrix",t.path="type",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){var o=n(r(11)),s=e.SparseMatrix,u=function(e,t,r){var n=e._values,u=e._index,c=e._ptr,f=e._size,l=e._datatype,p=t._values,h=t._index,m=t._ptr,d=t._size,v=t._datatype;if(f.length!==d.length)throw new i(f.length,d.length);if(f[0]!==d[0]||f[1]!==d[1])throw new RangeError("Dimension mismatch. Matrix A ("+f+") must match Matrix B ("+d+")");var g,y=f[0],x=f[1],w=o,b=0,N=r;"string"==typeof l&&l===v&&(g=l,w=a.find(o,[g,g]),b=a.convert(0,g),N=a.find(r,[g,g]));var E,M,A,O,T,_=n&&p?[]:void 0,S=[],C=[],z=new s({values:_,index:S,ptr:C,size:[y,x],datatype:g}),k=n&&p?[]:void 0,I=n&&p?[]:void 0,B=[],P=[];for(M=0;M<x;M++){C[M]=S.length;var R=M+1;for(O=c[M],T=c[M+1],A=O;A<T;A++)E=u[A],S.push(E),B[E]=R,k&&(k[E]=n[A]);for(O=m[M],T=m[M+1],A=O;A<T;A++)if(E=h[A],B[E]===R){if(k){var U=N(k[E],p[A]);w(U,b)?B[E]=null:k[E]=U}}else S.push(E),P[E]=R,I&&(I[E]=p[A]);if(k&&I)for(A=C[M];A<S.length;)E=S[A],B[E]===R?(_[A]=k[E],A++):P[E]===R?(_[A]=I[E],A++):S.splice(A,1)}return C[x]=S.length,z};return u}var i=r(10);t.name="algorithm04",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("number",{"":function(){return 0},number:function(e){return e},string:function(e){var t=Number(e);if(isNaN(t))throw new SyntaxError('String "'+e+'" is no valid number');return t},BigNumber:function(e){return e.toNumber()},Fraction:function(e){return e.valueOf()},Unit:function(e){throw new Error("Second argument with valueless unit expected")},"Unit, string | Unit":function(e,t){return e.toNumber(t)},"Array | Matrix":function(e){return i(e,a)}});return a.toTex={0:"0",1:"\\left(${args[0]}\\right)",2:"\\left(\\left(${args[0]}\\right)${args[1]}\\right)"},a}var i=r(1);t.name="number",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("isNumeric",{"number | BigNumber | Fraction | boolean":function(){return!0},"Complex | Unit | string":function(){return!1},"Array | Matrix":function(e){return i(e,a)}});return a}var i=r(1);r(3);t.name="isNumeric",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("_typeof",{any:function(t){var r=i.type(t);if("Object"===r){if(e.isBigNumber(t))return"BigNumber";if(e.isComplex(t))return"Complex";if(e.isFraction(t))return"Fraction";if(e.isMatrix(t))return"Matrix";if(e.isUnit(t))return"Unit";if(e.isIndex(t))return"Index";if(e.isRange(t))return"Range";if(e.isChain(t))return"Chain";if(e.isHelp(t))return"Help"}return r}});return a.toTex=void 0,a}var i=r(59);t.name="typeof",t.factory=n},function(e,t,r){"use strict";e.exports={end:!0}},function(e,t,r){"use strict";function n(e,t,n,s){function u(t,r){if(!(this instanceof u))throw new SyntaxError("Constructor must be called with the new operator");if(this.dimensions=t,this.dotNotation=r||!1,!m(t)||!t.every(e.isNode))throw new TypeError('Array containing Nodes expected for parameter "dimensions"');if(this.dotNotation&&!this.isObjectProperty())throw new Error("dotNotation only applicable for object properties");var n=function(){throw new Error("Property `IndexNode.object` is deprecated, use `IndexNode.fn` instead")};Object.defineProperty(this,"object",{get:n,set:n})}function c(t,r,n){if(!(t instanceof u))throw new TypeError("No valid IndexNode");var o=Object.create(n);r.range=function(t,r,n){return new h(e.isBigNumber(t)?t.toNumber():t,e.isBigNumber(r)?r.toNumber():r,e.isBigNumber(n)?n.toNumber():n)};var s=i(t.dimensions,function(t,n){return e.isRangeNode(t)?t.needsEnd()?(o.end="end","(function () {var end = size["+n+"]; return range("+l(t.start,r,o)+", "+l(t.end,r,o)+", "+(t.step?l(t.step,r,o):"1")+"); })()"):"range("+l(t.start,r,o)+", "+l(t.end,r,o)+", "+(t.step?l(t.step,r,o):"1")+")":e.isSymbolNode(t)&&"end"===t.name?(o.end="end","(function () {var end = size["+n+"]; return "+l(t,r,o)+"; })()"):l(t,r,o)});return"math.index("+a(s,", ")+")"}var f=n(r(7)).register,l=n(r(7)).compile,p=n(r(14)),h=(n(r(79)),n(r(40)),n(r(93))),m=Array.isArray;return u.prototype=new p,u.prototype.type="IndexNode",u.prototype.isIndexNode=!0,f(u.prototype.type,c),u.prototype.forEach=function(e){for(var t=0;t<this.dimensions.length;t++)e(this.dimensions[t],"dimensions["+t+"]",this)},u.prototype.map=function(e){for(var t=[],r=0;r<this.dimensions.length;r++)t[r]=this._ifNode(e(this.dimensions[r],"dimensions["+r+"]",this));return new u(t)},u.prototype.clone=function(){return new u(this.dimensions.slice(0))},u.prototype.isObjectProperty=function(){return 1===this.dimensions.length&&e.isConstantNode(this.dimensions[0])&&"string"===this.dimensions[0].valueType},u.prototype.getObjectProperty=function(){return this.isObjectProperty()?this.dimensions[0].value:null},u.prototype._toString=function(e){return this.dotNotation?"."+this.getObjectProperty():"["+this.dimensions.join(", ")+"]"},u.prototype.toHTML=function(e){for(var t=[],r=0;r<this.dimensions.length;r++)t[r]=this.dimensions[r].toHTML();return this.dotNotation?'<span class="math-operator math-accessor-operator">.</span><span class="math-symbol math-property">'+o(this.getObjectProperty())+"</span>":'<span class="math-parenthesis math-square-parenthesis">[</span>'+t.join('<span class="math-separator">,</span>')+'<span class="math-parenthesis math-square-parenthesis">]</span>'},u.prototype._toTex=function(e){var t=this.dimensions.map(function(t){return t.toTex(e)});return this.dotNotation?"."+this.getObjectProperty():"_{"+t.join(",")+"}"},u.prototype.needsSize=function(){return this.dimensions.some(function(t){return e.isRangeNode(t)&&t.needsEnd()||e.isSymbolNode(t)&&"end"===t.name})},u}var i=r(2).map,a=r(2).join,o=r(9).escape;t.name="IndexNode",t.path="expression.node",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){function o(t,r,n){if(!(this instanceof o))throw new SyntaxError("Constructor must be called with the new operator");if(!e.isNode(t))throw new TypeError("Node expected");if(!e.isNode(r))throw new TypeError("Node expected");if(n&&!e.isNode(n))throw new TypeError("Node expected");if(arguments.length>3)throw new Error("Too many arguments");this.start=t,this.end=r,this.step=n||null}function s(e,t,r){if(!(e instanceof o))throw new TypeError("No valid RangeNode");return"math.range("+f(e.start,t,r)+", "+f(e.end,t,r)+(e.step?", "+f(e.step,t,r):"")+")"}function u(e,t){var r=i.getPrecedence(e,t),n={},a=i.getPrecedence(e.start,t);if(n.start=null!==a&&a<=r||"all"===t,e.step){var o=i.getPrecedence(e.step,t);n.step=null!==o&&o<=r||"all"===t}var s=i.getPrecedence(e.end,t);return n.end=null!==s&&s<=r||"all"===t,n}var c=n(r(7)).register,f=n(r(7)).compile,l=n(r(14));return o.prototype=new l,o.prototype.type="RangeNode",o.prototype.isRangeNode=!0,o.prototype.needsEnd=function(){var t=this.filter(function(t){return e.isSymbolNode(t)&&"end"===t.name});return t.length>0},c(o.prototype.type,s),o.prototype.forEach=function(e){e(this.start,"start",this),e(this.end,"end",this),this.step&&e(this.step,"step",this)},o.prototype.map=function(e){return new o(this._ifNode(e(this.start,"start",this)),this._ifNode(e(this.end,"end",this)),this.step&&this._ifNode(e(this.step,"step",this)))},o.prototype.clone=function(){return new o(this.start,this.end,this.step&&this.step)},o.prototype._toString=function(e){var t,r=e&&e.parenthesis?e.parenthesis:"keep",n=u(this,r),i=this.start.toString(e);if(n.start&&(i="("+i+")"),t=i,this.step){var a=this.step.toString(e);n.step&&(a="("+a+")"),t+=":"+a}var o=this.end.toString(e);return n.end&&(o="("+o+")"),t+=":"+o},o.prototype.toHTML=function(e){var t,r=e&&e.parenthesis?e.parenthesis:"keep",n=u(this,r),i=this.start.toHTML(e);if(n.start&&(i='<span class="math-parenthesis math-round-parenthesis">(</span>'+i+'<span class="math-parenthesis math-round-parenthesis">)</span>'),t=i,this.step){var a=this.step.toHTML(e);n.step&&(a='<span class="math-parenthesis math-round-parenthesis">(</span>'+a+'<span class="math-parenthesis math-round-parenthesis">)</span>'),t+='<span class="math-operator math-range-operator">:</span>'+a}var o=this.end.toHTML(e);return n.end&&(o='<span class="math-parenthesis math-round-parenthesis">(</span>'+o+'<span class="math-parenthesis math-round-parenthesis">)</span>'),t+='<span class="math-operator math-range-operator">:</span>'+o},o.prototype._toTex=function(e){var t=e&&e.parenthesis?e.parenthesis:"keep",r=u(this,t),n=this.start.toTex(e);if(r.start&&(n="\\left("+n+"\\right)"),this.step){var i=this.step.toTex(e);r.step&&(i="\\left("+i+"\\right)"),n+=":"+i}var a=this.end.toTex(e);return r.end&&(a="\\left("+a+"\\right)"),n+=":"+a},o}var i=r(52);t.name="RangeNode",t.path="expression.node",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,o){function s(t){if(!(this instanceof s))throw new SyntaxError("Constructor must be called with the new operator");if(this.items=t||[],!Array.isArray(this.items)||!this.items.every(e.isNode))throw new TypeError("Array containing Nodes expected");var r=function(){throw new Error("Property `ArrayNode.nodes` is deprecated, use `ArrayNode.items` instead")};Object.defineProperty(this,"nodes",{get:r,set:r})}function u(e,t,r){if(!(e instanceof s))throw new TypeError("No valid ArrayNode");var n="Array"!==t.math.config().matrix,o=i(e.items,function(e){return f(e,t,r)});return(n?"math.matrix([":"[")+a(o,",")+(n?"])":"]")}var c=n(r(7)).register,f=n(r(7)).compile,l=n(r(14));return s.prototype=new l,s.prototype.type="ArrayNode",s.prototype.isArrayNode=!0,c(s.prototype.type,u),s.prototype.forEach=function(e){for(var t=0;t<this.items.length;t++){var r=this.items[t];e(r,"items["+t+"]",this)}},s.prototype.map=function(e){for(var t=[],r=0;r<this.items.length;r++)t[r]=this._ifNode(e(this.items[r],"items["+r+"]",this));return new s(t)},s.prototype.clone=function(){return new s(this.items.slice(0))},s.prototype._toString=function(e){var t=this.items.map(function(t){return t.toString(e)});return"["+t.join(", ")+"]"},s.prototype.toHTML=function(e){var t=this.items.map(function(t){return t.toHTML(e)});return'<span class="math-parenthesis math-square-parenthesis">[</span>'+t.join('<span class="math-separator">,</span>')+'<span class="math-parenthesis math-square-parenthesis">]</span>'},s.prototype._toTex=function(e){var t="\\begin{bmatrix}";return this.items.forEach(function(r){t+=r.items?r.items.map(function(t){return t.toTex(e)}).join("&"):r.toTex(e),t+="\\\\"}),t+="\\end{bmatrix}"},s}var i=r(2).map,a=r(2).join;t.name="ArrayNode",t.path="expression.node",t.factory=n},function(e,t){function r(e,t,r,n){return function(t,r,n){var i=t.filter(function(t){return e.isSymbolNode(t)&&!(t.name in r)&&!(t.name in n)})[0];if(!i)throw new Error('No undefined variable found in inline expression "'+t+'"');var a=i.name,o=Object.create(n),s=t.compile();return function(e){return o[a]=e,s.eval(o)}}}t.factory=r},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("isZero",{number:function(e){return 0===e},BigNumber:function(e){return e.isZero()},Complex:function(e){return 0===e.re&&0===e.im},Fraction:function(e){return 1===e.d&&0===e.n},Unit:function(e){return a(e.value)},"Array | Matrix":function(e){return i(e,a)}});return a}var i=r(1);r(3);t.name="isZero",t.factory=n},function(e,t,r){"use strict";function n(){var e=function(e){return-e-2};return e}t.name="cs_flip",t.path="sparse",t.factory=n},function(e,t,r){"use strict";function n(e){var t=e.DenseMatrix,r=function(r,n,i){var u=r.size();if(2!==u.length)throw new RangeError("Matrix must be two dimensional (size: "+a.format(u)+")");var c=u[0],f=u[1];if(c!==f)throw new RangeError("Matrix must be square (size: "+a.format(u)+")");var l,p,h;if(e.isMatrix(n)){var m=n.size();if(1===m.length){if(m[0]!==c)throw new RangeError("Dimension mismatch. Matrix columns must match vector length.");for(l=[],h=n._data,p=0;p<c;p++)l[p]=[h[p]];return new t({data:l,size:[c,1],datatype:n._datatype})}if(2===m.length){if(m[0]!==c||1!==m[1])throw new RangeError("Dimension mismatch. Matrix columns must match vector length.");if(e.isDenseMatrix(n)){if(i){for(l=[],h=n._data,p=0;p<c;p++)l[p]=[h[p][0]];return new t({data:l,size:[c,1],datatype:n._datatype})}return n}for(l=[],p=0;p<c;p++)l[p]=[0];for(var d=n._values,v=n._index,g=n._ptr,y=g[1],x=g[0];x<y;x++)p=v[x],l[p][0]=d[x];return new t({data:l,size:[c,1],datatype:n._datatype})}throw new RangeError("Dimension mismatch. Matrix columns must match vector length.")}if(s(n)){var w=o.size(n);if(1===w.length){if(w[0]!==c)throw new RangeError("Dimension mismatch. Matrix columns must match vector length.");for(l=[],p=0;p<c;p++)l[p]=[n[p]];return new t({data:l,size:[c,1]})}if(2===w.length){if(w[0]!==c||1!==w[1])throw new RangeError("Dimension mismatch. Matrix columns must match vector length.");for(l=[],p=0;p<c;p++)l[p]=[n[p][0]];return new t({data:l,size:[c,1]})}throw new RangeError("Dimension mismatch. Matrix columns must match vector length.")}};return r}var i=r(25),a=i.string,o=i.array,s=Array.isArray;t.factory=n},function(e,t,r){function n(e){for(var t=e.d,r=t[0]+"",n=1;n<t.length;++n){for(var i=t[n]+"",a=7-i.length;a--;)i="0"+i;r+=i}var o;for(o=r.length-1;"0"==r.charAt(o);--o);var s=e.e,u=r.slice(0,o+1||1),c=u.length;if(s>0)if(++s>c)for(s-=c;s--;u+="0");else s<c&&(u=u.slice(0,s)+"."+u.slice(s));for(var f=[0],n=0;n<u.length;){for(var l=f.length;l--;f[l]*=10);f[0]+=u.charAt(n++)<<0;for(var o=0;o<f.length;++o)f[o]>1&&(null==f[o+1]&&(f[o+1]=0),f[o+1]+=f[o]>>1,f[o]&=1)}return f.reverse()}var i=r(86);e.exports=function(e,t,r){var a,o,s=e.constructor,u=+(e.s<0),c=+(t.s<0);if(u){a=n(i(e));for(var f=0;f<a.length;++f)a[f]^=1}else a=n(e);if(c){o=n(i(t));for(var f=0;f<o.length;++f)o[f]^=1}else o=n(t);var l,p,h;a.length<=o.length?(l=a,p=o,h=u):(l=o,p=a,h=c);var m=l.length,d=p.length,v=1^r(u,c),g=new s(1^v),y=new s(1),x=new s(2),w=s.precision;for(s.config({precision:1e9});m>0;)r(l[--m],p[--d])==v&&(g=g.plus(y)),y=y.times(x);for(;d>0;)r(h,p[--d])==v&&(g=g.plus(y)),y=y.times(x);return s.config({precision:w}),0==v&&(g.s=-g.s),g}},function(e,t){e.exports=function(e){if(e.isFinite()&&!e.isInteger())throw new Error("Integer expected in function bitNot");var t=e.constructor,r=t.precision;t.config({precision:1e9});var e=e.plus(new t(1));return e.s=-e.s||null,t.config({precision:r}),e}},function(e,t,r){"use strict";function n(e,t,n,a){var o=n(r(11)),s=e.SparseMatrix,u=function(e,t,r){var n=e._values,u=e._index,c=e._ptr,f=e._size,l=e._datatype,p=t._values,h=t._index,m=t._ptr,d=t._size,v=t._datatype;if(f.length!==d.length)throw new i(f.length,d.length);if(f[0]!==d[0]||f[1]!==d[1])throw new RangeError("Dimension mismatch. Matrix A ("+f+") must match Matrix B ("+d+")");if(!n||!p)throw new Error("Cannot perform operation on Pattern Sparse Matrices");var g,y=f[0],x=f[1],w=o,b=0,N=r;"string"==typeof l&&l===v&&(g=l,w=a.find(o,[g,g]),b=a.convert(0,g),N=a.find(r,[g,g]));for(var E,M,A,O,T=[],_=[],S=[],C=new s({values:T,index:_,ptr:S,size:[y,x],datatype:g}),z=[],k=[],I=0;I<x;I++){S[I]=_.length;var B=I+1;for(M=c[I],A=c[I+1],E=M;E<A;E++)O=u[E],k[O]=B,z[O]=n[E],_.push(O);for(M=m[I],A=m[I+1],E=M;E<A;E++)O=h[E],k[O]===B&&(z[O]=N(z[O],p[E]));for(E=S[I];E<_.length;){O=_[E];var P=z[O];w(P,b)?_.splice(E,1):(T.push(P),E++)}}return S[x]=_.length,C};return u}var i=r(10);t.name="algorithm08",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){function o(e,t){return-c(e,t)}function s(t,r,n){if(!i(r)||r<0)throw new Error("k must be a non-negative integer");if(e.isMatrix(t)){var a=t.size();if(a.length>1)throw new Error("Only one dimensional matrices supported");return u(t.valueOf(),r,n)}if(Array.isArray(t))return u(t,r,n)}function u(e,t,r){if(t>=e.length)throw new Error("k out of bounds");for(var n=0,i=e.length-1;n<i;){for(var a=n,o=i,s=e[Math.floor(Math.random()*(i-n+1))+n];a<o;)if(r(e[a],s)>=0){var u=e[o];e[o]=e[a],e[a]=u,--o}else++a;r(e[a],s)>0&&--a,t<=a?i=a:n=a+1}return e[t]}var c=n(r(49));return a("partitionSelect",{"Array | Matrix, number":function(e,t){return s(e,t,c)},"Array | Matrix, number, string":function(e,t,r){if("asc"===r)return s(e,t,c);if("desc"===r)return s(e,t,o);throw new Error('Compare string must be "asc" or "desc"')},"Array | Matrix, number, function":s})}var i=r(3).isInteger;t.name="partitionSelect",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,s,u){function c(t){if(!h.hasOwnProperty(t))throw new Error("Unknown distribution "+t);var r=Array.prototype.slice.call(arguments,1),n=h[t].apply(this,r);return function(t){var r={random:function(t,r,n){var s,c,l;if(arguments.length>3)throw new i("random",arguments.length,0,3);if(1===arguments.length?a(t)?s=t:l=t:2===arguments.length?a(t)?(s=t,l=r):(c=t,l=r):(s=t,c=r,l=n),void 0!==c&&!o(c)||void 0!==l&&!o(l))throw new TypeError("Invalid argument in function random");if(void 0===l&&(l=1),void 0===c&&(c=0),void 0!==s){var p=h(s.valueOf(),c,l,u);return e.isMatrix(s)?f(p):p}return u(c,l)},randomInt:s({"number | Array":function(t){var r=0;if(a(t)){var n=t,i=1,o=h(n.valueOf(),r,i,c);return e.isMatrix(n)?f(o):o}var i=t;return c(r,i)},"number | Array, number":function(t,r){if(a(t)){var n=t,i=r,o=0,s=h(n.valueOf(),o,i,c);return e.isMatrix(n)?f(s):s}var o=t,i=r;return c(o,i)},"Array, number, number":function(e,t,r){var n=h(e.valueOf(),t,r,c);return e&&e.isMatrix===!0?f(n):n}}),pickRandom:s({Array:function(e){return n(e)},"Array, number | Array":function(e,t){var r,i;if(Array.isArray(t))i=t;else{if(!o(t))throw new TypeError("Invalid argument in function pickRandom");r=t}return n(e,r,i)},"Array, number | Array, Array | number":function(e,t,r){var i,a;if(Array.isArray(t)?(a=t,i=r):(a=r,i=t),!Array.isArray(a)||!o(i))throw new TypeError("Invalid argument in function pickRandom");return n(e,i,a)}})},n=function(t,r,n){var i="undefined"==typeof r;if(i&&(r=1),e.isMatrix(t))t=t.valueOf();else if(!Array.isArray(t))throw new TypeError("Unsupported type of value in function pickRandom");if(l.size(t).length>1)throw new Error("Only one dimensional vectors supported");if("undefined"!=typeof n){if(n.length!=t.length)throw new Error("Weights must have the same length as possibles");for(var a=0,s=0,u=n.length;s<u;s++){if(!o(n[s])||n[s]<0)throw new Error("Weights must be an array of positive numbers");a+=n[s]}}var c=t.length;if(0==c)return[];if(r>=c)return t;for(var f,h=[];h.length<r;){if("undefined"==typeof n)f=t[Math.floor(p()*c)];else for(var m=p()*a,s=0,u=t.length;s<u;s++)if(m-=n[s],m<0){f=t[s];break}h.indexOf(f)==-1&&h.push(f)}return i?h[0]:h},u=function(e,r){return e+t()*(r-e)},c=function(e,r){return Math.floor(e+t()*(r-e))},h=function(e,t,r,n){var i,a,o=[];if(e=e.slice(0),e.length>1)for(var a=0,i=e.shift();a<i;a++)o.push(h(e,t,r,n));else for(var a=0,i=e.shift();a<i;a++)o.push(n(t,r));return o};return r}(n)}var f=n(r(0)),l=r(2),p=n(r(490)),h={uniform:function(){return p},normal:function(){return function(){for(var e,t,r=-1;r<0||r>1;)e=p(),t=p(),r=1/6*Math.pow(-2*Math.log(e),.5)*Math.cos(2*Math.PI*t)+.5;return r}}};return c.toTex=void 0,c}var i=r(50),a=r(46),o=r(3).isNumber;t.name="distribution",t.factory=n},function(e,t,r){var n=r(153);t.mixin=function(e){var t=new n;return e.on=t.on.bind(t),e.off=t.off.bind(t),e.once=t.once.bind(t),e.emit=t.emit.bind(t),e}},function(e,t,r){function n(e,t,r,n,s){return i.prototype.type="Complex",i.prototype.isComplex=!0,i.prototype.toJSON=function(){return{mathjs:"Complex",re:this.re,im:this.im}},i.prototype.toPolar=function(){return{r:this.abs(),phi:this.arg()}},i.prototype.format=function(e){var t="",r=this.im,n=this.re,i=a(this.re,e),s=a(this.im,e),u=o(e)?e:e?e.precision:null;if(null!==u){var c=Math.pow(10,-u);Math.abs(n/r)<c&&(n=0),Math.abs(r/n)<c&&(r=0)}return t=0==r?i:0==n?1==r?"i":r==-1?"-i":s+"i":r<0?r==-1?i+" - i":i+" - "+s.substring(1)+"i":1==r?i+" + i":i+" + "+s+"i"},i.fromPolar=function(t){switch(arguments.length){case 1:var r=arguments[0];if("object"==typeof r)return i(r);throw new TypeError("Input has to be an object with r and phi keys.");case 2:var n=arguments[0],a=arguments[1];if(o(n)){if(e.isUnit(a)&&a.hasBase("ANGLE")&&(a=a.toNumber("rad")),o(a))return new i({r:n,phi:a});throw new TypeError("Phi is not a number nor an angle unit.")}throw new TypeError("Radius r is not a number.");default:throw new SyntaxError("Wrong number of arguments in function fromPolar")}},i.prototype.valueOf=i.prototype.toString,i.fromJSON=function(e){return new i(e)},i.EPSILON=t.epsilon,s.on("config",function(e,t){e.epsilon!==t.epsilon&&(i.EPSILON=e.epsilon)}),i.compare=function(e,t){return e.re>t.re?1:e.re<t.re?-1:e.im>t.im?1:e.im<t.im?-1:0},i}var i=r(168),a=r(3).format,o=r(3).isNumber;t.name="Complex",t.path="type",t.factory=n,t.math=!0},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("fraction",{number:function(t){if(!isFinite(t)||isNaN(t))throw new Error(t+" cannot be represented as a fraction");return new e.Fraction(t)},string:function(t){return new e.Fraction(t)},"number, number":function(t,r){return new e.Fraction(t,r)},BigNumber:function(t){return new e.Fraction(t.toString())},Fraction:function(e){return e},Object:function(t){return new e.Fraction(t)},"Array | Matrix":function(e){return i(e,a)}});return a}var i=r(1);t.name="fraction",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){function a(t,r,n){if(!(this instanceof a))throw new SyntaxError("Constructor must be called with the new operator");if(null!=t)if(e.isBigNumber(t))t=t.toNumber();else if("number"!=typeof t)throw new TypeError("Parameter start must be a number");if(null!=r)if(e.isBigNumber(r))r=r.toNumber();else if("number"!=typeof r)throw new TypeError("Parameter end must be a number");if(null!=n)if(e.isBigNumber(n))n=n.toNumber();else if("number"!=typeof n)throw new TypeError("Parameter step must be a number");this.start=null!=t?parseFloat(t):0,this.end=null!=r?parseFloat(r):0,this.step=null!=n?parseFloat(n):1}return a.prototype.type="Range",a.prototype.isRange=!0,a.parse=function(e){if("string"!=typeof e)return null;var t=e.split(":"),r=t.map(function(e){return parseFloat(e)}),n=r.some(function(e){return isNaN(e)});if(n)return null;switch(r.length){case 2:return new a(r[0],r[1]);case 3:return new a(r[0],r[2],r[1]);default:return null}},a.prototype.clone=function(){return new a(this.start,this.end,this.step)},a.prototype.size=function(){var e=0,t=this.start,r=this.step,n=this.end,a=n-t;return i.sign(r)==i.sign(a)?e=Math.ceil(a/r):0==a&&(e=0),isNaN(e)&&(e=0),[e]},a.prototype.min=function(){var e=this.size()[0];return e>0?this.step>0?this.start:this.start+(e-1)*this.step:void 0},a.prototype.max=function(){var e=this.size()[0];return e>0?this.step>0?this.start+(e-1)*this.step:this.start:void 0},a.prototype.forEach=function(e){var t=this.start,r=this.step,n=this.end,i=0;if(r>0)for(;t<n;)e(t,[i],this),t+=r,i++;else if(r<0)for(;t>n;)e(t,[i],this),t+=r,i++},a.prototype.map=function(e){var t=[];return this.forEach(function(r,n,i){t[n[0]]=e(r,n,i)}),t},a.prototype.toArray=function(){var e=[];return this.forEach(function(t,r){e[r[0]]=t}),e},a.prototype.valueOf=function(){return this.toArray()},a.prototype.format=function(e){var t=i.format(this.start,e);return 1!=this.step&&(t+=":"+i.format(this.step,e)),t+=":"+i.format(this.end,e)},
a.prototype.toString=function(){return this.format()},a.prototype.toJSON=function(){return{mathjs:"Range",start:this.start,end:this.end,step:this.step}},a.fromJSON=function(e){return new a(e.start,e.end,e.step)},a}var i=r(3);t.name="Range",t.path="type",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){function i(e){if(!(this instanceof i))throw new SyntaxError("Constructor must be called with the new operator");this.entries=e||[]}return i.prototype.type="ResultSet",i.prototype.isResultSet=!0,i.prototype.valueOf=function(){return this.entries},i.prototype.toString=function(){return"["+this.entries.join(", ")+"]"},i.prototype.toJSON=function(){return{mathjs:"ResultSet",entries:this.entries}},i.fromJSON=function(e){return new i(e.entries)},i}t.name="ResultSet",t.path="type",t.factory=n},function(e,t,r){function n(e){return e[0].precision}var i=r(32).memoize;t.e=i(function(e){return new e(1).exp()},n),t.phi=i(function(e){return new e(1).plus(new e(5).sqrt()).div(2)},n),t.pi=i(function(e){return e.acos(-1)},n),t.tau=i(function(e){return t.pi(e).times(2)},n)},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("fix",{number:function(e){return e>0?Math.floor(e):Math.ceil(e)},Complex:function(t){return new e.Complex(t.re>0?Math.floor(t.re):Math.ceil(t.re),t.im>0?Math.floor(t.im):Math.ceil(t.im))},BigNumber:function(e){return e.isNegative()?e.ceil():e.floor()},Fraction:function(e){return e.s<0?e.ceil():e.floor()},"Array | Matrix":function(e){return i(e,a,!0)}});return a.toTex={1:"\\mathrm{${name}}\\left(${args[0]}\\right)"},a}var i=r(1);t.name="fix",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,o){var c=n(r(0)),f=n(r(11)),l=n(r(38)),p=n(r(17)),h=n(r(16)),m=n(r(6)),d=o("round",{number:Math.round,"number, number":function(e,t){if(!a(t))throw new TypeError(u);if(t<0||t>15)throw new Error("Number of decimals in function round must be in te range of 0-15");return i(e,t)},Complex:function(e){return e.round()},"Complex, number":function(e,t){if(t%1)throw new TypeError(u);return e.round(t)},"Complex, BigNumber":function(e,t){if(!t.isInteger())throw new TypeError(u);var r=t.toNumber();return e.round(r)},"number, BigNumber":function(t,r){if(!r.isInteger())throw new TypeError(u);return new e.BigNumber(t).toDecimalPlaces(r.toNumber())},BigNumber:function(e){return e.toDecimalPlaces(0)},"BigNumber, BigNumber":function(e,t){if(!t.isInteger())throw new TypeError(u);return e.toDecimalPlaces(t.toNumber())},Fraction:function(e){return e.round()},"Fraction, number":function(e,t){if(t%1)throw new TypeError(u);return e.round(t)},"Array | Matrix":function(e){return s(e,d,!0)},"Matrix, number | BigNumber":function(e,t){var r;switch(e.storage()){case"sparse":r=p(e,t,d,!1);break;default:r=m(e,t,d,!1)}return r},"number | Complex | BigNumber, Matrix":function(e,t){if(!f(e,0)){var r;switch(t.storage()){case"sparse":r=h(t,e,d,!0);break;default:r=m(t,e,d,!0)}return r}return l(t.size(),t.storage())},"Array, number | BigNumber":function(e,t){return m(c(e),t,d,!1).valueOf()},"number | Complex | BigNumber, Array":function(e,t){return m(c(t),e,d,!0).valueOf()}});return d.toTex={1:"\\left\\lfloor${args[0]}\\right\\rceil",2:void 0},d}function i(e,t){return parseFloat(o(e,t))}var a=r(3).isInteger,o=r(3).toFixed,s=r(1),u="Number of decimals in function round must be an integer";t.name="round",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("format",{any:i.format,"any, Object | function | number":i.format});return a.toTex=void 0,a}var i=r(9);t.name="format",t.factory=n},function(e,t,r){function n(e,t,n,i){var a={};return a.bignumber=r(192),a.boolean=r(193),a.complex=r(194),a.createUnit=r(195),a.fraction=r(196),a.index=r(197),a.matrix=r(198),a.number=r(199),a.sparse=r(200),a.splitUnit=r(201),a.string=r(202),a.unit=r(203),a.e=r(100),a.E=r(100),a.false=r(204),a.i=r(205),a.Infinity=r(206),a.LN2=r(207),a.LN10=r(208),a.LOG2E=r(209),a.LOG10E=r(210),a.NaN=r(211),a.null=r(212),a.pi=r(101),a.PI=r(101),a.phi=r(213),a.SQRT1_2=r(214),a.SQRT2=r(215),a.tau=r(216),a.true=r(217),a.version=r(218),a.speedOfLight={description:"Speed of light in vacuum",examples:["speedOfLight"]},a.gravitationConstant={description:"Newtonian constant of gravitation",examples:["gravitationConstant"]},a.planckConstant={description:"Planck constant",examples:["planckConstant"]},a.reducedPlanckConstant={description:"Reduced Planck constant",examples:["reducedPlanckConstant"]},a.magneticConstant={description:"Magnetic constant (vacuum permeability)",examples:["magneticConstant"]},a.electricConstant={description:"Electric constant (vacuum permeability)",examples:["electricConstant"]},a.vacuumImpedance={description:"Characteristic impedance of vacuum",examples:["vacuumImpedance"]},a.coulomb={description:"Coulomb's constant",examples:["coulomb"]},a.elementaryCharge={description:"Elementary charge",examples:["elementaryCharge"]},a.bohrMagneton={description:"Borh magneton",examples:["bohrMagneton"]},a.conductanceQuantum={description:"Conductance quantum",examples:["conductanceQuantum"]},a.inverseConductanceQuantum={description:"Inverse conductance quantum",examples:["inverseConductanceQuantum"]},a.magneticFluxQuantum={description:"Magnetic flux quantum",examples:["magneticFluxQuantum"]},a.nuclearMagneton={description:"Nuclear magneton",examples:["nuclearMagneton"]},a.klitzing={description:"Von Klitzing constant",examples:["klitzing"]},a.bohrRadius={description:"Borh radius",examples:["bohrRadius"]},a.classicalElectronRadius={description:"Classical electron radius",examples:["classicalElectronRadius"]},a.electronMass={description:"Electron mass",examples:["electronMass"]},a.fermiCoupling={description:"Fermi coupling constant",examples:["fermiCoupling"]},a.fineStructure={description:"Fine-structure constant",examples:["fineStructure"]},a.hartreeEnergy={description:"Hartree energy",examples:["hartreeEnergy"]},a.protonMass={description:"Proton mass",examples:["protonMass"]},a.deuteronMass={description:"Deuteron Mass",examples:["deuteronMass"]},a.neutronMass={description:"Neutron mass",examples:["neutronMass"]},a.quantumOfCirculation={description:"Quantum of circulation",examples:["quantumOfCirculation"]},a.rydberg={description:"Rydberg constant",examples:["rydberg"]},a.thomsonCrossSection={description:"Thomson cross section",examples:["thomsonCrossSection"]},a.weakMixingAngle={description:"Weak mixing angle",examples:["weakMixingAngle"]},a.efimovFactor={description:"Efimov factor",examples:["efimovFactor"]},a.atomicMass={description:"Atomic mass constant",examples:["atomicMass"]},a.avogadro={description:"Avogadro's number",examples:["avogadro"]},a.boltzmann={description:"Boltzmann constant",examples:["boltzmann"]},a.faraday={description:"Faraday constant",examples:["faraday"]},a.firstRadiation={description:"First radiation constant",examples:["firstRadiation"]},a.loschmidt={description:"Loschmidt constant at T=273.15 K and p=101.325 kPa",examples:["loschmidt"]},a.gasConstant={description:"Gas constant",examples:["gasConstant"]},a.molarPlanckConstant={description:"Molar Planck constant",examples:["molarPlanckConstant"]},a.molarVolume={description:"Molar volume of an ideal gas at T=273.15 K and p=101.325 kPa",examples:["molarVolume"]},a.sackurTetrode={description:"Sackur-Tetrode constant at T=1 K and p=101.325 kPa",examples:["sackurTetrode"]},a.secondRadiation={description:"Second radiation constant",examples:["secondRadiation"]},a.stefanBoltzmann={description:"Stefan-Boltzmann constant",examples:["stefanBoltzmann"]},a.wienDisplacement={description:"Wien displacement law constant",examples:["wienDisplacement"]},a.molarMass={description:"Molar mass constant",examples:["molarMass"]},a.molarMassC12={description:"Molar mass constant of carbon-12",examples:["molarMassC12"]},a.gravity={description:"Standard acceleration of gravity (standard acceleration of free-fall on Earth)",examples:["gravity"]},a.planckLength={description:"Planck length",examples:["planckLength"]},a.planckMass={description:"Planck mass",examples:["planckMass"]},a.planckTime={description:"Planck time",examples:["planckTime"]},a.planckCharge={description:"Planck charge",examples:["planckCharge"]},a.planckTemperature={description:"Planck temperature",examples:["planckTemperature"]},a.derivative=r(219),a.lsolve=r(220),a.lup=r(221),a.lusolve=r(222),a.simplify=r(223),a.slu=r(224),a.usolve=r(225),a.qr=r(226),a.abs=r(227),a.add=r(228),a.cbrt=r(229),a.ceil=r(230),a.cube=r(231),a.divide=r(232),a.dotDivide=r(233),a.dotMultiply=r(234),a.dotPow=r(235),a.exp=r(236),a.fix=r(237),a.floor=r(238),a.gcd=r(239),a.hypot=r(240),a.lcm=r(241),a.log=r(242),a.log10=r(243),a.mod=r(244),a.multiply=r(245),a.norm=r(246),a.nthRoot=r(247),a.pow=r(248),a.round=r(249),a.sign=r(250),a.sqrt=r(251),a.square=r(252),a.subtract=r(253),a.unaryMinus=r(254),a.unaryPlus=r(255),a.xgcd=r(256),a.bitAnd=r(257),a.bitNot=r(258),a.bitOr=r(259),a.bitXor=r(260),a.leftShift=r(261),a.rightArithShift=r(262),a.rightLogShift=r(263),a.bellNumbers=r(264),a.catalan=r(265),a.composition=r(266),a.stirlingS2=r(267),a.config=r(268),a.import=r(269),a.typed=r(270),a.arg=r(271),a.conj=r(272),a.re=r(273),a.im=r(274),a.eval=r(275),a.help=r(276),a.distance=r(277),a.intersect=r(278),a.and=r(279),a.not=r(280),a.or=r(281),a.xor=r(282),a.concat=r(283),a.cross=r(284),a.det=r(285),a.diag=r(286),a.dot=r(287),a.eye=r(288),a.filter=r(289),a.flatten=r(290),a.forEach=r(291),a.inv=r(292),a.kron=r(293),a.map=r(294),a.ones=r(295),a.partitionSelect=r(296),a.range=r(297),a.resize=r(298),a.reshape=r(299),a.size=r(300),a.sort=r(301),a.squeeze=r(302),a.subset=r(303),a.trace=r(304),a.transpose=r(305),a.zeros=r(306),a.combinations=r(307),a.factorial=r(308),a.gamma=r(309),a.kldivergence=r(310),a.multinomial=r(311),a.permutations=r(312),a.pickRandom=r(313),a.random=r(314),a.randomInt=r(315),a.compare=r(316),a.compareNatural=r(317),a.deepEqual=r(318),a.equal=r(319),a.larger=r(320),a.largerEq=r(321),a.smaller=r(322),a.smallerEq=r(323),a.unequal=r(324),a.setCartesian=r(325),a.setDifference=r(326),a.setDistinct=r(327),a.setIntersect=r(328),a.setIsSubset=r(329),a.setMultiplicity=r(330),a.setPowerset=r(331),a.setSize=r(332),a.setSymDifference=r(333),a.setUnion=r(334),a.erf=r(335),a.mad=r(336),a.max=r(337),a.mean=r(338),a.median=r(339),a.min=r(340),a.mode=r(341),a.prod=r(342),a.quantileSeq=r(343),a.std=r(344),a.sum=r(345),a.var=r(346),a.acos=r(347),a.acosh=r(348),a.acot=r(349),a.acoth=r(350),a.acsc=r(351),a.acsch=r(352),a.asec=r(353),a.asech=r(354),a.asin=r(355),a.asinh=r(356),a.atan=r(357),a.atanh=r(358),a.atan2=r(359),a.cos=r(360),a.cosh=r(361),a.cot=r(362),a.coth=r(363),a.csc=r(364),a.csch=r(365),a.sec=r(366),a.sech=r(367),a.sin=r(368),a.sinh=r(369),a.tan=r(370),a.tanh=r(371),a.to=r(372),a.clone=r(373),a.format=r(374),a.isNaN=r(375),a.isInteger=r(376),a.isNegative=r(377),a.isNumeric=r(378),a.isPositive=r(379),a.isPrime=r(380),a.isZero=r(381),a.typeof=r(382),a}t.name="docs",t.path="expression",t.factory=n},function(e,t){e.exports={name:"e",category:"Constants",syntax:["e"],description:"Euler's number, the base of the natural logarithm. Approximately equal to 2.71828",examples:["e","e ^ 2","exp(2)","log(e)"],seealso:["exp"]}},function(e,t){e.exports={name:"pi",category:"Constants",syntax:["pi"],description:"The number pi is a mathematical constant that is the ratio of a circle's circumference to its diameter, and is approximately equal to 3.14159",examples:["pi","sin(pi/2)"],seealso:["tau"]}},function(e,t,r){"use strict";function n(e,t,n,o){function s(t,r){if(!(this instanceof s))throw new SyntaxError("Constructor must be called with the new operator");if(!e.isNode(t))throw new TypeError('Node expected for parameter "object"');if(!e.isIndexNode(r))throw new TypeError('IndexNode expected for parameter "index"');this.object=t||null,this.index=r,Object.defineProperty(this,"name",{get:function(){return this.index?this.index.isObjectProperty()?this.index.getObjectProperty():"":this.object.name||""}.bind(this),set:function(){throw new Error("Cannot assign a new name, name is read-only")}})}function u(e,t,r){if(!(e instanceof s))throw new TypeError("No valid AccessorNode");t.access=h,t.getSafeProperty=a;var n=l(e.object,t,r),o=l(e.index,t,r);if(e.index.isObjectProperty()){var u=i(e.index.getObjectProperty());return"getSafeProperty("+n+", "+u+")"}return e.index.needsSize()?"(function () {  var object = "+n+";  var size = math.size(object).valueOf();  return access(object, "+o+");})()":"access("+n+", "+o+")"}function c(t){return!(e.isAccessorNode(t)||e.isArrayNode(t)||e.isConstantNode(t)||e.isFunctionNode(t)||e.isObjectNode(t)||e.isParenthesisNode(t)||e.isSymbolNode(t))}var f=n(r(7)).register,l=n(r(7)).compile,p=n(r(14)),h=(n(r(78)),n(r(103)));return s.prototype=new p,s.prototype.type="AccessorNode",s.prototype.isAccessorNode=!0,f(s.prototype.type,u),s.prototype.forEach=function(e){e(this.object,"object",this),e(this.index,"index",this)},s.prototype.map=function(e){return new s(this._ifNode(e(this.object,"object",this)),this._ifNode(e(this.index,"index",this)))},s.prototype.clone=function(){return new s(this.object,this.index)},s.prototype._toString=function(e){var t=this.object.toString(e);return c(this.object)&&(t="("+t+")"),t+this.index.toString(e)},s.prototype.toHTML=function(e){var t=this.object.toHTML(e);return c(this.object)&&(t='<span class="math-parenthesis math-round-parenthesis">(</span>'+t+'<span class="math-parenthesis math-round-parenthesis">)</span>'),t+this.index.toHTML(e)},s.prototype._toTex=function(e){var t=this.object.toTex(e);return c(this.object)&&(t="\\left("+t+"\\right)"),t+this.index.toTex(e)},s}var i=r(9).stringify,a=r(13).getSafeProperty;t.name="AccessorNode",t.path="expression.node",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,o){var s=n(r(22));return function(e,t){try{if(Array.isArray(e))return s(e,t);if(e&&"function"==typeof e.subset)return e.subset(t);if("string"==typeof e)return s(e,t);if("object"==typeof e){if(!t.isObjectProperty())throw new TypeError("Cannot apply a numeric index as object property");return a(e,t.getObjectProperty())}throw new TypeError("Cannot apply index: unsupported type of object")}catch(e){throw i(e)}}}var i=r(41).transform,a=r(13).getSafeProperty;t.factory=n},function(e,t,r){"use strict";function n(e,t,n,s){function u(t,r,n){if(!(this instanceof u))throw new SyntaxError("Constructor must be called with the new operator");if(this.object=t,this.index=n?r:null,this.value=n?n:r,!e.isSymbolNode(t)&&!e.isAccessorNode(t))throw new TypeError('SymbolNode or AccessorNode expected as "object"');if(e.isSymbolNode(t)&&"end"===t.name)throw new Error('Cannot assign to symbol "end"');if(this.index&&!e.isIndexNode(this.index))throw new TypeError('IndexNode expected as "index"');if(!e.isNode(this.value))throw new TypeError('Node expected as "value"');Object.defineProperty(this,"name",{get:function(){return this.index?this.index.isObjectProperty()?this.index.getObjectProperty():"":this.object.name||""}.bind(this),set:function(){throw new Error("Cannot assign a new name, name is read-only")}})}function c(t,r,n){if(!(t instanceof u))throw new TypeError("No valid AssignmentNode");r.assign=m,r.access=d,r.getSafeProperty=a,r.setSafeProperty=o;var s,c=p(t.object,r,n),f=t.index?p(t.index,r,n):null,l=p(t.value,r,n),h=i(t.object.name);if(t.index){if(t.index.isObjectProperty()){var v=i(t.index.getObjectProperty());return"setSafeProperty("+c+", "+v+", "+l+")"}if(e.isSymbolNode(t.object))return s=t.index.needsSize()?"var size = math.size(object).valueOf();":"","(function () {  var object = "+c+";  var value = "+l+";  "+s+"  setSafeProperty(scope, "+h+", assign(object, "+f+", value));  return value;})()";s=t.index.needsSize()?"var size = math.size(object).valueOf();":"";var g=p(t.object.object,r,n);if(t.object.index.isObjectProperty()){var y=i(t.object.index.getObjectProperty());return"(function () {  var parent = "+g+";  var object = getSafeProperty(parent, "+y+");  var value = "+l+";"+s+"  setSafeProperty(parent, "+y+", assign(object, "+f+", value));  return value;})()"}var x=t.object.index.needsSize()?"var size = math.size(parent).valueOf();":"",w=p(t.object.index,r,n);return"(function () {  var parent = "+g+";  "+x+"  var parentIndex = "+w+";  var object = access(parent, parentIndex);  var value = "+l+";  "+s+"  assign(parent, parentIndex, assign(object, "+f+", value));  return value;})()"}if(!e.isSymbolNode(t.object))throw new TypeError("SymbolNode expected as object");return"setSafeProperty(scope, "+h+", "+l+")"}function f(e,t){t||(t="keep");var r=v.getPrecedence(e,t),n=v.getPrecedence(e.value,t);return"all"===t||null!==n&&n<=r}var l=n(r(7)).register,p=n(r(7)).compile,h=n(r(14)),m=(n(r(80)),n(r(0)),n(r(385))),d=n(r(103)),v=(r(77),r(52));return u.prototype=new h,u.prototype.type="AssignmentNode",u.prototype.isAssignmentNode=!0,l(u.prototype.type,c),u.prototype.forEach=function(e){e(this.object,"object",this),this.index&&e(this.index,"index",this),e(this.value,"value",this)},u.prototype.map=function(e){var t=this._ifNode(e(this.object,"object",this)),r=this.index?this._ifNode(e(this.index,"index",this)):null,n=this._ifNode(e(this.value,"value",this));return new u(t,r,n)},u.prototype.clone=function(){return new u(this.object,this.index,this.value)},u.prototype._toString=function(e){var t=this.object.toString(e),r=this.index?this.index.toString(e):"",n=this.value.toString(e);return f(this,e&&e.parenthesis)&&(n="("+n+")"),t+r+" = "+n},u.prototype.toHTML=function(e){var t=this.object.toHTML(e),r=this.index?this.index.toHTML(e):"",n=this.value.toHTML(e);return f(this,e&&e.parenthesis)&&(n='<span class="math-paranthesis math-round-parenthesis">(</span>'+n+'<span class="math-paranthesis math-round-parenthesis">)</span>'),t+r+'<span class="math-operator math-assignment-operator math-variable-assignment-operator math-binary-operator">=</span>'+n},u.prototype._toTex=function(e){var t=this.object.toTex(e),r=this.index?this.index.toTex(e):"",n=this.value.toTex(e);return f(this,e&&e.parenthesis)&&(n="\\left("+n+"\\right)"),t+r+":="+n},u}var i=(r(4),r(9).stringify),a=r(13).getSafeProperty,o=r(13).setSafeProperty;t.name="AssignmentNode",t.path="expression.node",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,o){function s(t){if(!(this instanceof s))throw new SyntaxError("Constructor must be called with the new operator");if(!Array.isArray(t))throw new Error("Array expected");this.blocks=t.map(function(t){var r=t&&t.node,n=!t||void 0===t.visible||t.visible;if(!e.isNode(r))throw new TypeError('Property "node" must be a Node');if("boolean"!=typeof n)throw new TypeError('Property "visible" must be a boolean');return{node:r,visible:n}})}function u(e,t,r){if(!(e instanceof s))throw new TypeError("No valid BlockNode");t.ResultSet=p;var n=i(e.blocks,function(e){var n=f(e.node,t,r);return e.visible?"results.push("+n+");":n+";"});return"(function () {var results = [];"+a(n,"")+"return new ResultSet(results);})()"}var c=n(r(7)).register,f=n(r(7)).compile,l=n(r(14)),p=n(r(94));return s.prototype=new l,s.prototype.type="BlockNode",s.prototype.isBlockNode=!0,c(s.prototype.type,u),s.prototype.forEach=function(e){for(var t=0;t<this.blocks.length;t++)e(this.blocks[t].node,"blocks["+t+"].node",this)},s.prototype.map=function(e){for(var t=[],r=0;r<this.blocks.length;r++){var n=this.blocks[r],i=this._ifNode(e(n.node,"blocks["+r+"].node",this));t[r]={node:i,visible:n.visible}}return new s(t)},s.prototype.clone=function(){var e=this.blocks.map(function(e){return{node:e.node,visible:e.visible}});return new s(e)},s.prototype._toString=function(e){return this.blocks.map(function(t){return t.node.toString(e)+(t.visible?"":";")}).join("\n")},s.prototype.toHTML=function(e){return this.blocks.map(function(t){return t.node.toHTML(e)+(t.visible?"":'<span class="math-separator">;</span>')}).join('<span class="math-separator"><br /></span>')},s.prototype._toTex=function(e){return this.blocks.map(function(t){return t.node.toTex(e)+(t.visible?"":";")}).join("\\;\\;\n")},s}var i=r(2).map,a=r(2).join;t.name="BlockNode",t.path="expression.node",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){function o(t,r,n){if(!(this instanceof o))throw new SyntaxError("Constructor must be called with the new operator");if(!e.isNode(t))throw new TypeError("Parameter condition must be a Node");if(!e.isNode(r))throw new TypeError("Parameter trueExpr must be a Node");if(!e.isNode(n))throw new TypeError("Parameter falseExpr must be a Node");this.condition=t,this.trueExpr=r,this.falseExpr=n}function s(t,r,n){if(!(t instanceof o))throw new TypeError("No valid ConditionalNode");return r.testCondition=function(t){if("number"==typeof t||"boolean"==typeof t||"string"==typeof t)return!!t;if(t){if(e.isBigNumber(t))return!t.isZero();if(e.isComplex(t))return!(!t.re&&!t.im);if(e.isUnit(t))return!!t.value}if(null===t||void 0===t)return!1;throw new TypeError('Unsupported type of condition "'+r.math.typeof(t)+'"')},"testCondition("+c(t.condition,r,n)+") ? ( "+c(t.trueExpr,r,n)+") : ( "+c(t.falseExpr,r,n)+")"}var u=n(r(7)).register,c=n(r(7)).compile,f=n(r(14));return o.prototype=new f,o.prototype.type="ConditionalNode",o.prototype.isConditionalNode=!0,u(o.prototype.type,s),o.prototype.forEach=function(e){e(this.condition,"condition",this),e(this.trueExpr,"trueExpr",this),e(this.falseExpr,"falseExpr",this)},o.prototype.map=function(e){return new o(this._ifNode(e(this.condition,"condition",this)),this._ifNode(e(this.trueExpr,"trueExpr",this)),this._ifNode(e(this.falseExpr,"falseExpr",this)))},o.prototype.clone=function(){return new o(this.condition,this.trueExpr,this.falseExpr)},o.prototype._toString=function(e){var t=e&&e.parenthesis?e.parenthesis:"keep",r=i.getPrecedence(this,t),n=this.condition.toString(e),a=i.getPrecedence(this.condition,t);("all"===t||"OperatorNode"===this.condition.type||null!==a&&a<=r)&&(n="("+n+")");var o=this.trueExpr.toString(e),s=i.getPrecedence(this.trueExpr,t);("all"===t||"OperatorNode"===this.trueExpr.type||null!==s&&s<=r)&&(o="("+o+")");var u=this.falseExpr.toString(e),c=i.getPrecedence(this.falseExpr,t);return("all"===t||"OperatorNode"===this.falseExpr.type||null!==c&&c<=r)&&(u="("+u+")"),n+" ? "+o+" : "+u},o.prototype.toHTML=function(e){var t=e&&e.parenthesis?e.parenthesis:"keep",r=i.getPrecedence(this,t),n=this.condition.toHTML(e),a=i.getPrecedence(this.condition,t);("all"===t||"OperatorNode"===this.condition.type||null!==a&&a<=r)&&(n='<span class="math-parenthesis math-round-parenthesis">(</span>'+n+'<span class="math-parenthesis math-round-parenthesis">)</span>');var o=this.trueExpr.toHTML(e),s=i.getPrecedence(this.trueExpr,t);("all"===t||"OperatorNode"===this.trueExpr.type||null!==s&&s<=r)&&(o='<span class="math-parenthesis math-round-parenthesis">(</span>'+o+'<span class="math-parenthesis math-round-parenthesis">)</span>');var u=this.falseExpr.toHTML(e),c=i.getPrecedence(this.falseExpr,t);return("all"===t||"OperatorNode"===this.falseExpr.type||null!==c&&c<=r)&&(u='<span class="math-parenthesis math-round-parenthesis">(</span>'+u+'<span class="math-parenthesis math-round-parenthesis">)</span>'),n+'<span class="math-operator math-conditional-operator">?</span>'+o+'<span class="math-operator math-conditional-operator">:</span>'+u},o.prototype._toTex=function(e){return"\\begin{cases} {"+this.trueExpr.toTex(e)+"}, &\\quad{\\text{if }\\;"+this.condition.toTex(e)+"}\\\\{"+this.falseExpr.toTex(e)+"}, &\\quad{\\text{otherwise}}\\end{cases}"},o}var i=(r(4),r(52));t.name="ConditionalNode",t.path="expression.node",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,h){function m(t,r,n){if(!(this instanceof m))throw new SyntaxError("Constructor must be called with the new operator");if("string"!=typeof t)throw new TypeError('String expected for parameter "name"');if(!Array.isArray(r))throw new TypeError('Array containing strings or objects expected for parameter "params"');if(!e.isNode(n))throw new TypeError('Node expected for parameter "expr"');if(t in i)throw new Error('Illegal function name, "'+t+'" is a reserved keyword');this.name=t,this.params=r.map(function(e){return e&&e.name||e}),this.types=r.map(function(e){return e&&e.type||"any"}),this.expr=n}function d(e,t,r){if(!(e instanceof m))throw new TypeError("No valid FunctionAssignmentNode");t.typed=h,t.setSafeProperty=l;var n=Object.create(r),i=s(e.params,function(e){return n[e]=p(n),n[e]}),o=y(e.expr,t,n),c=a(e.name);return"setSafeProperty(scope, "+c+",   (function () {    var fn = typed("+c+", {      "+a(u(e.types,","))+": function ("+u(i,",")+") {        return "+o+"      }    });    fn.syntax = "+a(e.name+"("+u(e.params,", ")+")")+";    return fn;  })())"}function v(e,t){var r=f.getPrecedence(e,t),n=f.getPrecedence(e.expr,t);return"all"===t||null!==n&&n<=r}var g=n(r(7)).register,y=n(r(7)).compile,x=n(r(14));return m.prototype=new x,m.prototype.type="FunctionAssignmentNode",m.prototype.isFunctionAssignmentNode=!0,g(m.prototype.type,d),m.prototype.forEach=function(e){e(this.expr,"expr",this)},m.prototype.map=function(e){var t=this._ifNode(e(this.expr,"expr",this));return new m(this.name,this.params.slice(0),t)},m.prototype.clone=function(){return new m(this.name,this.params.slice(0),this.expr)},m.prototype._toString=function(e){var t=e&&e.parenthesis?e.parenthesis:"keep",r=this.expr.toString(e);return v(this,t)&&(r="("+r+")"),this.name+"("+this.params.join(", ")+") = "+r},m.prototype.toHTML=function(e){for(var t=e&&e.parenthesis?e.parenthesis:"keep",r=[],n=0;n<this.params.length;n++)r.push('<span class="math-symbol math-parameter">'+o(this.params[n])+"</span>");var i=this.expr.toHTML(e);return v(this,t)&&(i='<span class="math-parenthesis math-round-parenthesis">(</span>'+i+'<span class="math-parenthesis math-round-parenthesis">)</span>'),'<span class="math-function">'+o(this.name)+'</span><span class="math-parenthesis math-round-parenthesis">(</span>'+r.join('<span class="math-separator">,</span>')+'<span class="math-parenthesis math-round-parenthesis">)</span><span class="math-operator math-assignment-operator math-variable-assignment-operator math-binary-operator">=</span>'+i},m.prototype._toTex=function(e){var t=e&&e.parenthesis?e.parenthesis:"keep",r=this.expr.toTex(e);return v(this,t)&&(r="\\left("+r+"\\right)"),"\\mathrm{"+this.name+"}\\left("+this.params.map(c.toSymbol).join(",")+"\\right):="+r},m}var i=r(77),a=r(9).stringify,o=r(9).escape,s=r(2).map,u=r(2).join,c=r(4),f=r(52),l=r(13).setSafeProperty,p=r(108);t.name="FunctionAssignmentNode",t.path="expression.node",t.factory=n},function(e,t){function r(e){return"arg"+Object.keys(e).length}e.exports=r},function(e,t,r){"use strict";function n(e,t,n,u){function c(t){if(!(this instanceof c))throw new SyntaxError("Constructor must be called with the new operator");if(this.properties=t||{},t&&("object"!=typeof t||!Object.keys(t).every(function(r){return e.isNode(t[r])})))throw new TypeError("Object containing Nodes expected")}function f(e,t,r){if(!(e instanceof c))throw new TypeError("No valid ObjectNode");var n=[];for(var a in e.properties)if(s(e.properties,a)){if(!o(e.properties,a))throw new Error('No access to property "'+a+'"');n.push(i(a)+": "+p(e.properties[a],t,r))}return"{"+n.join(", ")+"}"}var l=n(r(7)).register,p=n(r(7)).compile,h=n(r(14));return c.prototype=new h,c.prototype.type="ObjectNode",c.prototype.isObjectNode=!0,l(c.prototype.type,f),c.prototype.forEach=function(e){for(var t in this.properties)this.properties.hasOwnProperty(t)&&e(this.properties[t],"properties["+i(t)+"]",this)},c.prototype.map=function(e){var t={};for(var r in this.properties)this.properties.hasOwnProperty(r)&&(t[r]=this._ifNode(e(this.properties[r],"properties["+i(r)+"]",this)));return new c(t)},c.prototype.clone=function(){var e={};for(var t in this.properties)this.properties.hasOwnProperty(t)&&(e[t]=this.properties[t]);return new c(e)},c.prototype._toString=function(e){var t=[];for(var r in this.properties)this.properties.hasOwnProperty(r)&&t.push(i(r)+": "+this.properties[r].toString(e));return"{"+t.join(", ")+"}"},c.prototype.toHTML=function(e){var t=[];for(var r in this.properties)this.properties.hasOwnProperty(r)&&t.push('<span class="math-symbol math-property">'+a(r)+'</span><span class="math-operator math-assignment-operator math-property-assignment-operator math-binary-operator">:</span>'+this.properties[r].toHTML(e));return'<span class="math-parenthesis math-curly-parenthesis">{</span>'+t.join('<span class="math-separator">,</span>')+'<span class="math-parenthesis math-curly-parenthesis">}</span>'},c.prototype._toTex=function(e){var t=[];for(var r in this.properties)this.properties.hasOwnProperty(r)&&t.push("\\mathbf{"+r+":} & "+this.properties[r].toTex(e)+"\\\\");return"\\left\\{\\begin{array}{ll}"+t.join("\n")+"\\end{array}\\right\\}"},c}var i=r(9).stringify,a=r(9).escape,o=r(13).isSafeProperty,s=r(5).hasOwnProperty;t.name="ObjectNode",t.path="expression.node",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,i,a){var o=n(r(111));return i("parser",{"":function(){return new o(a)}})}t.name="parser",t.factory=n,t.math=!0},function(e,t,r){"use strict";function n(e,t,n,o,s){function u(){if(!(this instanceof u))throw new SyntaxError("Constructor must be called with the new operator");this.scope={}}var c=n(r(39));return u.prototype.type="Parser",u.prototype.isParser=!0,u.prototype.parse=function(e){throw new Error("Parser.parse is deprecated. Use math.parse instead.")},u.prototype.compile=function(e){throw new Error("Parser.compile is deprecated. Use math.compile instead.")},u.prototype.eval=function(e){return c(e).compile().eval(this.scope)},u.prototype.get=function(e){return e in this.scope?a.getSafeProperty(this.scope,e):void 0},u.prototype.getAll=function(){return i({},this.scope)},u.prototype.set=function(e,t){return a.setSafeProperty(this.scope,e,t)},u.prototype.remove=function(e){delete this.scope[e]},u.prototype.clear=function(){for(var e in this.scope)this.scope.hasOwnProperty(e)&&delete this.scope[e]},u}var i=r(5).extend,a=r(13);t.name="Parser",t.path="expression",t.factory=n,t.math=!0},function(e,t,r){"use strict";function n(e,t,n,s){function u(e,t){return f(e,t)?e:t}function c(e){var t=void 0;if(i(e,function(e){(void 0===t||f(e,t))&&(t=e)}),void 0===t)throw new Error("Cannot calculate max of an empty array");return t}var f=n(r(34)),l=s("max",{"Array | Matrix":c,"Array | Matrix, number | BigNumber":function(e,t){return a(e,t.valueOf(),u)},"...":function(e){if(o(e))throw new TypeError("Scalar values expected in function max");return c(e)}});return l.toTex="\\max\\left(${args}\\right)",l}var i=r(42),a=r(65),o=r(66);t.name="max",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,u){function c(e,t){var r=o(e,t,l),n=Array.isArray(e)?i(e):e.size();return p(r,n[t])}function f(e){var t=0,r=0;if(a(e,function(e){t=l(t,e),r++}),0===r)throw new Error("Cannot calculate mean of an empty array");return p(t,r)}var l=n(r(18)),p=n(r(47)),h=u("mean",{"Array | Matrix":f,"Array | Matrix, number | BigNumber":c,"...":function(e){if(s(e))throw new TypeError("Scalar values expected in function mean");return f(e)}});return h.toTex=void 0,h}var i=r(2).size,a=r(42),o=r(65),s=r(66);t.name="mean",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){function o(e,t,r){var n,i,a,o,s;if(1==t){if(o=e[0][0],0==o)throw Error("Cannot calculate inverse, determinant is zero");return[[u(1,o)]]}if(2==t){var m=p(e);if(0==m)throw Error("Cannot calculate inverse, determinant is zero");return[[u(e[1][1],m),u(l(e[0][1]),m)],[u(l(e[1][0]),m),u(e[0][0],m)]]}var d=e.concat();for(n=0;n<t;n++)d[n]=d[n].concat();for(var v=h(t).valueOf(),g=0;g<r;g++){for(n=g;n<t&&0==d[n][g];)n++;if(n==t||0==d[n][g])throw Error("Cannot calculate inverse, determinant is zero");n!=g&&(s=d[g],d[g]=d[n],d[n]=s,s=v[g],v[g]=v[n],v[n]=s);var y=d[g],x=v[g];for(n=0;n<t;n++){var w=d[n],b=v[n];if(n!=g){if(0!=w[g]){for(a=u(l(w[g]),y[g]),i=g;i<r;i++)w[i]=c(w[i],f(a,y[i]));for(i=0;i<r;i++)b[i]=c(b[i],f(a,x[i]))}}else{for(a=y[g],i=g;i<r;i++)w[i]=u(w[i],a);for(i=0;i<r;i++)b[i]=u(b[i],a)}}}return v}var s=n(r(0)),u=n(r(19)),c=n(r(20)),f=n(r(12)),l=n(r(37)),p=n(r(115)),h=n(r(61)),m=a("inv",{
"Array | Matrix":function(t){var r=e.isMatrix(t)?t.size():i.array.size(t);switch(r.length){case 1:if(1==r[0])return e.isMatrix(t)?s([u(1,t.valueOf()[0])]):[u(1,t[0])];throw new RangeError("Matrix must be square (size: "+i.string.format(r)+")");case 2:var n=r[0],a=r[1];if(n==a)return e.isMatrix(t)?s(o(t.valueOf(),n,a),t.storage()):o(t,n,a);throw new RangeError("Matrix must be square (size: "+i.string.format(r)+")");default:throw new RangeError("Matrix must be two dimensional (size: "+i.string.format(r)+")")}},any:function(e){return u(1,e)}});return m.toTex={1:"\\left(${args[0]}\\right)^{-1}"},m}var i=r(25);t.name="inv",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,i){function s(e,t,r){if(1==t)return a.clone(e[0][0]);if(2==t)return f(l(e[0][0],e[1][1]),l(e[1][0],e[0][1]));for(var n=function(e){var t,r,n=new Array(e.length),i=0;for(t=1;t<e.length;t++)i=c(i,e[t][t]);for(t=0;t<e.length;t++){for(n[t]=new Array(e.length),n[t][t]=p(i),r=0;r<t;r++)n[t][r]=0;for(r=t+1;r<e.length;r++)n[t][r]=e[t][r];t+1<e.length&&(i=f(i,e[t+1][t+1]))}return n},i=e,o=0;o<t-1;o++)i=l(n(i),e);return t%2==0?p(i[0][0]):i[0][0]}var u=n(r(0)),c=n(r(18)),f=n(r(21)),l=n(r(12)),p=n(r(37)),h=i("det",{any:function(e){return a.clone(e)},"Array | Matrix":function(t){var r;switch(e.isMatrix(t)?r=t.size():Array.isArray(t)?(t=u(t),r=t.size()):r=[],r.length){case 0:return a.clone(t);case 1:if(1==r[0])return a.clone(t.valueOf()[0]);throw new RangeError("Matrix must be square (size: "+o.format(r)+")");case 2:var n=r[0],i=r[1];if(n==i)return s(t.clone().valueOf(),n,i);throw new RangeError("Matrix must be square (size: "+o.format(r)+")");default:throw new RangeError("Matrix must be two dimensional (size: "+o.format(r)+")")}}});return h.toTex={1:"\\det\\left(${args[0]}\\right)"},h}var i=r(25),a=i.object,o=i.string;t.name="det",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,s){function u(e,t){return f(e,t)?e:t}function c(e){var t=void 0;if(i(e,function(e){(void 0===t||f(e,t))&&(t=e)}),void 0===t)throw new Error("Cannot calculate min of an empty array");return t}var f=n(r(44)),l=s("min",{"Array | Matrix":c,"Array | Matrix, number | BigNumber":function(e,t){return a(e,t.valueOf(),u)},"...":function(e){if(o(e))throw new TypeError("Scalar values expected in function min");return c(e)}});return l.toTex="\\min\\left(${args}\\right)",l}var i=r(42),a=r(65),o=r(66);t.name="min",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,i){function a(e){return"Array"===t.matrix?e:p(e)}function o(r,n){var i=l(r);if(!i)throw new SyntaxError('String "'+r+'" is no valid range');var o;return"BigNumber"===t.number?(o=n?f:c,a(o(new e.BigNumber(i.start),new e.BigNumber(i.end),new e.BigNumber(i.step)))):(o=n?u:s,a(o(i.start,i.end,i.step)))}function s(e,t,r){var n=[],i=e;if(r>0)for(;i<t;)n.push(i),i+=r;else if(r<0)for(;i>t;)n.push(i),i+=r;return n}function u(e,t,r){var n=[],i=e;if(r>0)for(;i<=t;)n.push(i),i+=r;else if(r<0)for(;i>=t;)n.push(i),i+=r;return n}function c(e,t,r){var n=[],i=e;if(r.gt(h))for(;i.lt(t);)n.push(i),i=i.plus(r);else if(r.lt(h))for(;i.gt(t);)n.push(i),i=i.plus(r);return n}function f(e,t,r){var n=[],i=e;if(r.gt(h))for(;i.lte(t);)n.push(i),i=i.plus(r);else if(r.lt(h))for(;i.gte(t);)n.push(i),i=i.plus(r);return n}function l(e){var t=e.split(":"),r=t.map(function(e){return Number(e)}),n=r.some(function(e){return isNaN(e)});if(n)return null;switch(r.length){case 2:return{start:r[0],end:r[1],step:1};case 3:return{start:r[0],end:r[2],step:r[1]};default:return null}}var p=n(r(0)),h=new e.BigNumber(0),m=new e.BigNumber(1),d=i("range",{string:o,"string, boolean":o,"number, number":function(e,t){return a(s(e,t,1))},"number, number, number":function(e,t,r){return a(s(e,t,r))},"number, number, boolean":function(e,t,r){return a(r?u(e,t,1):s(e,t,1))},"number, number, number, boolean":function(e,t,r,n){return a(n?u(e,t,r):s(e,t,r))},"BigNumber, BigNumber":function(e,t){return a(c(e,t,m))},"BigNumber, BigNumber, BigNumber":function(e,t,r){return a(c(e,t,r))},"BigNumber, BigNumber, boolean":function(e,t,r){return a(r?f(e,t,m):c(e,t,m))},"BigNumber, BigNumber, BigNumber, boolean":function(e,t,r,n){return a(n?f(e,t,r):c(e,t,r))}});return d.toTex=void 0,d}t.name="range",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,i,a){function o(t){return t.transform(function(t,r,n){return e.isParenthesisNode(t)?t.content:t})}function s(e){for(var t=[],r=0;r<e.length;r++){var n,i=e[r],a=typeof i;switch(a){case"string":var s=i.split("->");if(2!==s.length)throw SyntaxError("Could not parse rule: "+i);i={l:s[0],r:s[1]};case"object":if(n={l:o(d(i.l)),r:o(d(i.r))},i.context&&(n.evaluate=i.context),i.evaluate&&(n.evaluate=d(i.evaluate)),n.l.isOperatorNode&&O(n.l)){var c=C(n.l),f=u();n.expanded={},n.expanded.l=c([n.l.clone(),f]),T(n.expanded.l),_(n.expanded.l),n.expanded.r=c([n.r,f])}break;case"function":n=i;break;default:throw TypeError("Unsupported type of rule: "+a)}t.push(n)}return t}function u(){return new w("_p"+I++)}function c(e,t){var r,n,i=[],a=C(e);if(A(e,t))for(var o=0;o<e.args.length;o++)n=e.args.slice(0),n.splice(o,1),r=1===n.length?n[0]:a(n),i.push(a([e.args[o],r]));else n=e.args.slice(1),r=1===n.length?n[0]:a(n),i.push(a([e.args[0],r]));return i}function f(e,t){var r={placeholders:{}};if(!e.placeholders&&!t.placeholders)return r;if(!e.placeholders)return t;if(!t.placeholders)return e;for(var n in e.placeholders)if(r.placeholders[n]=e.placeholders[n],t.placeholders.hasOwnProperty(n)&&!m(e.placeholders[n],t.placeholders[n]))return null;for(var n in t.placeholders)r.placeholders[n]=t.placeholders[n];return r}function l(e,t){var r=[];if(0===e.length||0===t.length)return r;for(var n,i=0;i<e.length;i++)for(var a=0;a<t.length;a++)n=f(e[i],t[a]),n&&r.push(n);return r}function p(e){if(0===e.length)return e;for(var t=e.reduce(l),r=[],n={},i=0;i<t.length;i++){var a=JSON.stringify(t[i]);n[a]||(n[a]=!0,r.push(t[i]))}return r}function h(t,r,n){var i=[{placeholders:{}}];if(t instanceof y&&r instanceof y||t instanceof g&&r instanceof g){if(t instanceof y){if(t.op!==r.op||t.fn!==r.fn)return[]}else if(t instanceof g&&t.name!==r.name)return[];if((1!==r.args.length||1!==t.args.length)&&O(r)&&!n){if(r.args.length>=2&&2===t.args.length){for(var o=c(r,t.context),s=[],u=0;u<o.length;u++){var f=h(t,o[u],!0);s=s.concat(f)}return s}if(t.args.length>2)throw Error("Unexpected non-binary associative function: "+t.toString());return[]}for(var l=[],u=0;u<t.args.length;u++){var m=h(t.args[u],r.args[u]);if(0===m.length)return[];l.push(m)}i=p(l)}else if(t instanceof w){if(0===t.name.length)throw new Error("Symbol in rule has 0 length...!?");if(a.hasOwnProperty(t.name)){if(!k[t.name])throw new Error("Built in constant: "+t.name+" is not supported by simplify.");if(t.name!==r.name)return[]}else if("n"===t.name[0]||"_p"===t.name.substring(0,2))i[0].placeholders[t.name]=r;else if("v"===t.name[0]){if(e.isConstantNode(r))return[];i[0].placeholders[t.name]=r}else{if("c"!==t.name[0])throw new Error("Invalid symbol in rule: "+t.name);if(!(r instanceof v))return[];i[0].placeholders[t.name]=r}}else{if(!(t instanceof v))return[];if(t.value!==r.value)return[]}return i}function m(e,t){if(e instanceof v&&t instanceof v){if(e.value!==t.value)return!1}else if(e instanceof w&&t instanceof w){if(e.name!==t.name)return!1}else{if(!(e instanceof y&&t instanceof y||e instanceof g&&t instanceof g))return!1;if(e instanceof y){if(e.op!==t.op||e.fn!==t.fn)return!1}else if(e instanceof g&&e.name!==t.name)return!1;if(e.args.length!==t.args.length)return!1;for(var r=0;r<e.args.length;r++)if(!m(e.args[r],t.args[r]))return!1}return!0}var d=n(r(39)),v=n(r(53)),g=n(r(54)),y=n(r(62)),x=n(r(63)),w=n(r(40)),b=(n(r(14)),n(r(406))),N=n(r(407)),E=n(r(408)),M=n(r(119)),A=M.isCommutative,O=M.isAssociative,T=M.flatten,_=M.unflattenr,S=M.unflattenl,C=M.createMakeNodeFunction,z=i("simplify",{string:function(e){return z(d(e),z.rules,{})},"string, Object":function(e,t){return z(d(e),z.rules,t)},"string, Array":function(e,t){return z(d(e),t,{})},"string, Array, Object":function(e,t,r){return z(d(e),t,r)},"Node, Object":function(e,t){return z(e,z.rules,t)},Node:function(e){return z(e,z.rules,{})},"Node, Array":function(e,t){return z(e,t,{})},"Node, Array, Object":function(e,t,r){t=s(t);for(var n=E(e,r),n=o(n),i={},a=n.toString({parenthesis:"all"});!i[a];){i[a]=!0,I=0;for(var u=0;u<t.length;u++)"function"==typeof t[u]?n=t[u](n):(T(n),n=B(n,t[u])),S(n);a=n.toString({parenthesis:"all"})}return n}});z.simplifyCore=N,z.resolve=E;var k={true:!0,false:!0,e:!0,i:!0,Infinity:!0,LN2:!0,LN10:!0,LOG2E:!0,LOG10E:!0,NaN:!0,phi:!0,pi:!0,SQRT1_2:!0,SQRT2:!0,tau:!0};z.rules=[N,{l:"log(e)",r:"1"},{l:"n-n1",r:"n+-n1"},{l:"-(c*v)",r:"(-c) * v"},{l:"-v",r:"(-1) * v"},{l:"n/n1^n2",r:"n*n1^-n2"},{l:"n/n1",r:"n*n1^-1"},{l:"n*n",r:"n^2"},{l:"n * n^n1",r:"n^(n1+1)"},{l:"n^n1 * n^n2",r:"n^(n1+n2)"},{l:"n+n",r:"2*n"},{l:"n+-n",r:"0"},{l:"n1*n2 + n2",r:"(n1+1)*n2"},{l:"n1*n3 + n2*n3",r:"(n1+n2)*n3"},b,{l:"(-n)*n1",r:"-(n*n1)"},{l:"c+v",r:"v+c",context:{add:{commutative:!1}}},{l:"v*c",r:"c*v",context:{multiply:{commutative:!1}}},{l:"n+-n1",r:"n-n1"},{l:"n*(n1^-1)",r:"n/n1"},{l:"n*n1^-n2",r:"n/n1^n2"},{l:"n1^-1",r:"1/n1"},{l:"n*(n1/n2)",r:"(n*n1)/n2"},{l:"n-(n1+n2)",r:"n-n1-n2"},{l:"1*n",r:"n"}];var I=0,B=i("applyRule",{"Node, Object":function(t,r){var n=t;if(n instanceof y||n instanceof g){if(n.args)for(var i=0;i<n.args.length;i++)n.args[i]=B(n.args[i],r)}else n instanceof x&&n.content&&(n.content=B(n.content,r));var a=r.r,o=h(r.l,n)[0];return!o&&r.expanded&&(a=r.expanded.r,o=h(r.expanded.l,n)[0]),o&&(n=a.clone(),n=n.transform(function(t,r,n){if(e.isSymbolNode(t)&&o.placeholders.hasOwnProperty(t.name)){var i=o.placeholders[t.name].clone();return i}return t})),n}});return z}t.math=!0,t.name="simplify",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n,i){function a(e,t){if(!e.args||e.args.length<=1)return!0;var r=e.fn.toString();return t&&t.hasOwnProperty(r)&&t[r].hasOwnProperty("commutative")?t[r].commutative:d[r]||!1}function o(e,t){if(!e.args||e.args.length<=1)return!0;var r=e.fn.toString();return t&&t.hasOwnProperty(r)&&t[r].hasOwnProperty("associative")?t[r].associative:v[r]||!1}function s(e){if(!e.args||0===e.args.length)return e;e.args=u(e);for(var t=0;t<e.args.length;t++)s(e.args[t])}function u(t){var r,n=[],i=function(t){for(var a=0;a<t.args.length;a++){var o=t.args[a];e.isOperatorNode(o)&&r===o.op?i(o):n.push(o)}};return e.isOperatorNode(t)&&o(t)?(r=t.op,i(t),n):t.args}function c(e){if(e.args&&0!==e.args.length){for(var t=l(e),r=e.args.length,n=0;n<r;n++)c(e.args[n]);if(r>2&&o(e)){for(var i=e.args.pop();e.args.length>0;)i=t([e.args.pop(),i]);e.args=i.args}}}function f(e){if(e.args&&0!==e.args.length){for(var t=l(e),r=e.args.length,n=0;n<r;n++)f(e.args[n]);if(r>2&&o(e)){for(var i=e.args.shift();e.args.length>0;)i=t([i,e.args.shift()]);e.args=i.args}}}function l(t){return e.isOperatorNode(t)?function(e){try{return new h(t.op,t.fn,e)}catch(e){return console.error(e),[]}}:function(e){return new p(new m(t.name),e)}}var p=i.expression.node.FunctionNode,h=i.expression.node.OperatorNode,m=i.expression.node.SymbolNode,d={add:!0,multiply:!0},v={add:!0,multiply:!0};return{createMakeNodeFunction:l,isCommutative:a,isAssociative:o,flatten:s,allChildren:u,unflattenr:c,unflattenl:f}}t.factory=n,t.math=!0},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("clone",{any:i.clone});return a.toTex=void 0,a}var i=r(5);t.name="clone",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,o){var s=n(r(0)),u=n(r(15)),c=n(r(26)),f=n(r(16)),l=n(r(8)),p=n(r(6)),h=r(4),m=o("unequal",{"any, any":function(e,t){return null===e?null!==t:null===t?null!==e:void 0===e?void 0!==t:void 0===t?void 0!==e:d(e,t)},"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=c(e,t,d);break;default:r=u(t,e,d,!0)}break;default:switch(t.storage()){case"sparse":r=u(e,t,d,!1);break;default:r=l(e,t,d)}}return r},"Array, Array":function(e,t){return m(s(e),s(t)).valueOf()},"Array, Matrix":function(e,t){return m(s(e),t)},"Matrix, Array":function(e,t){return m(e,s(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=f(e,t,d,!1);break;default:r=p(e,t,d,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=f(t,e,d,!0);break;default:r=p(t,e,d,!0)}return r},"Array, any":function(e,t){return p(s(e),t,d,!1).valueOf()},"any, Array":function(e,t){return p(s(t),e,d,!0).valueOf()}}),d=o("_unequal",{"boolean, boolean":function(e,t){return e!==t},"number, number":function(e,r){return!i(e,r,t.epsilon)},"BigNumber, BigNumber":function(e,r){return!a(e,r,t.epsilon)},"Fraction, Fraction":function(e,t){return!e.equals(t)},"Complex, Complex":function(e,t){return!e.equals(t)},"Unit, Unit":function(e,t){if(!e.equalBase(t))throw new Error("Cannot compare units with different base");return m(e.value,t.value)},"string, string":function(e,t){return e!==t}});return m.toTex={2:"\\left(${args[0]}"+h.operators.unequal+"${args[1]}\\right)"},m}var i=r(3).nearlyEqual,a=r(35);t.name="unequal",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var o=n("sign",{number:i.sign,Complex:function(e){return e.sign()},BigNumber:function(t){return new e.BigNumber(t.cmp(0))},Fraction:function(t){return new e.Fraction(t.s,1)},"Array | Matrix":function(e){return a(e,o,!0)},Unit:function(e){return o(e.value)}});return o.toTex={1:"\\mathrm{${name}}\\left(${args[0]}\\right)"},o}var i=r(3),a=r(1);t.name="sign",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("conj",{number:function(e){return e},BigNumber:function(e){return e},Complex:function(e){return e.conjugate()},"Array | Matrix":function(e){return i(e,a)}});return a.toTex={1:"\\left(${args[0]}\\right)^*"},a}var i=r(1);t.name="conj",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,i){var o=n(r(0)),s=n(r(29)),u=n(r(20)),c=n(r(19)),f=n(r(23)),l=n(r(21)),p=n(r(34)),h=n(r(11)),m=n(r(37)),d=e.SparseMatrix,v=e.DenseMatrix,g=e.Spa,y=i("lup",{DenseMatrix:function(e){return x(e)},SparseMatrix:function(e){return w(e)},Array:function(e){var t=o(e),r=x(t);return{L:r.L.valueOf(),U:r.U.valueOf(),p:r.p}}}),x=function(e){var t,r,n,i=e._size[0],o=e._size[1],m=Math.min(i,o),d=a.clone(e._data),g=[],y=[i,m],x=[],w=[m,o],b=[];for(t=0;t<i;t++)b[t]=t;for(r=0;r<o;r++){if(r>0)for(t=0;t<i;t++){var N=Math.min(t,r),E=0;for(n=0;n<N;n++)E=u(E,f(d[t][n],d[n][r]));d[t][r]=l(d[t][r],E)}var M=r,A=0,O=0;for(t=r;t<i;t++){var T=d[t][r],_=s(T);p(_,A)&&(M=t,A=_,O=T)}if(r!==M&&(b[r]=[b[M],b[M]=b[r]][0],v._swapRows(r,M,d)),r<i)for(t=r+1;t<i;t++){var S=d[t][r];h(S,0)||(d[t][r]=c(d[t][r],O))}}for(r=0;r<o;r++)for(t=0;t<i;t++)0===r&&(t<o&&(x[t]=[]),g[t]=[]),t<r?(t<o&&(x[t][r]=d[t][r]),r<i&&(g[t][r]=0)):t!==r?(t<o&&(x[t][r]=0),r<i&&(g[t][r]=d[t][r])):(t<o&&(x[t][r]=d[t][r]),r<i&&(g[t][r]=1));var C=new v({data:g,size:y}),z=new v({data:x,size:w}),k=[];for(t=0,m=b.length;t<m;t++)k[b[t]]=t;return{L:C,U:z,p:k,toString:function(){return"L: "+this.L.toString()+"\nU: "+this.U.toString()+"\nP: "+this.p}}},w=function(e){var t,r,n,i=e._size[0],a=e._size[1],o=Math.min(i,a),u=e._values,l=e._index,v=e._ptr,y=[],x=[],w=[],b=[i,o],N=[],E=[],M=[],A=[o,a],O=[],T=[];for(t=0;t<i;t++)O[t]=t,T[t]=t;var _=function(e,t){var r=T[e],n=T[t];O[r]=t,O[n]=e,T[e]=n,T[t]=r};for(r=0;r<a;r++){var S=new g;r<i&&(w.push(y.length),y.push(1),x.push(r)),M.push(N.length);var C=v[r],z=v[r+1];for(n=C;n<z;n++)t=l[n],S.set(O[t],u[n]);r>0&&S.forEach(0,r-1,function(e,t){d._forEachRow(e,y,x,w,function(r,n){r>e&&S.accumulate(r,m(f(n,t)))})});var k=r,I=S.get(r),B=s(I);S.forEach(r+1,i-1,function(e,t){var r=s(t);p(r,B)&&(k=e,B=r,I=t)}),r!==k&&(d._swapRows(r,k,b[1],y,x,w),d._swapRows(r,k,A[1],N,E,M),S.swap(r,k),_(r,k)),S.forEach(0,i-1,function(e,t){e<=r?(N.push(t),E.push(e)):(t=c(t,I),h(t,0)||(y.push(t),x.push(e)))})}return M.push(N.length),w.push(y.length),{L:new d({values:y,index:x,ptr:w,size:b}),U:new d({values:N,index:E,ptr:M,size:A}),p:O,toString:function(){return"L: "+this.L.toString()+"\nU: "+this.U.toString()+"\nP: "+this.p}}};return y}var i=r(25),a=i.object;t.name="lup",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,i){var a=n(r(410)),s=n(r(418)),u=i("slu",{"SparseMatrix, number, number":function(e,t,r){if(!o(t)||t<0||t>3)throw new Error("Symbolic Ordering and Analysis order must be an integer number in the interval [0, 3]");if(r<0||r>1)throw new Error("Partial pivoting threshold must be a number from 0 to 1");var n=a(t,e,!1),i=s(e,n,r);return{L:i.L,U:i.U,p:i.pinv,q:n.q,toString:function(){return"L: "+this.L.toString()+"\nU: "+this.U.toString()+"\np: "+this.p.toString()+(this.q?"\nq: "+this.q.toString():"")+"\n"}}}});return u}var i=r(25),a=i.number,o=a.isInteger;t.name="slu",t.factory=n},function(e,t,r){"use strict";function n(){var e=function(e,t,r,n,i,a,o){var s=0;for(r[o]=e;s>=0;){var u=r[o+s],c=r[n+u];c==-1?(s--,a[t++]=u):(r[n+u]=r[i+c],++s,r[o+s]=c)}return t};return e}t.name="cs_tdfs",t.path="sparse",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,o){var s=n(r(0)),u=n(r(15)),c=n(r(26)),f=n(r(16)),l=n(r(8)),p=n(r(6)),h=r(4),m=o("largerEq",{"boolean, boolean":function(e,t){return e>=t},"number, number":function(e,r){return e>=r||i(e,r,t.epsilon)},"BigNumber, BigNumber":function(e,r){return e.gte(r)||a(e,r,t.epsilon)},"Fraction, Fraction":function(e,t){return e.compare(t)!==-1},"Complex, Complex":function(){throw new TypeError("No ordering relation is defined for complex numbers")},"Unit, Unit":function(e,t){if(!e.equalBase(t))throw new Error("Cannot compare units with different base");return m(e.value,t.value)},"string, string":function(e,t){return e>=t},"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=c(e,t,m);break;default:r=u(t,e,m,!0)}break;default:switch(t.storage()){case"sparse":r=u(e,t,m,!1);break;default:r=l(e,t,m)}}return r},"Array, Array":function(e,t){return m(s(e),s(t)).valueOf()},"Array, Matrix":function(e,t){return m(s(e),t)},"Matrix, Array":function(e,t){return m(e,s(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=f(e,t,m,!1);break;default:r=p(e,t,m,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=f(t,e,m,!0);break;default:r=p(t,e,m,!0)}return r},"Array, any":function(e,t){return p(s(e),t,m,!1).valueOf()},"any, Array":function(e,t){return p(s(t),e,m,!0).valueOf()}});return m.toTex={2:"\\left(${args[0]}"+h.operators.largerEq+"${args[1]}\\right)"},m}var i=r(3).nearlyEqual,a=r(35);t.name="largerEq",t.factory=n},function(e,t,r){"use strict";function n(){var e=function(e,t){return e[t]<0};return e}t.name="cs_marked",t.path="sparse",t.factory=n},function(e,t,r){"use strict";function n(e,t,n){var i=n(r(83)),a=function(e,t){e[t]=i(e[t])};return a}t.name="cs_mark",t.path="sparse",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,i){var a=n(r(0)),o=n(r(19)),s=n(r(23)),u=n(r(21)),c=n(r(11)),f=n(r(84)),l=e.DenseMatrix,p=i("lsolve",{"SparseMatrix, Array | Matrix":function(e,t){return m(e,t)},"DenseMatrix, Array | Matrix":function(e,t){return h(e,t)},"Array, Array | Matrix":function(e,t){var r=a(e),n=h(r,t);return n.valueOf()}}),h=function(e,t){t=f(e,t,!0);for(var r=t._data,n=e._size[0],i=e._size[1],a=[],p=e._data,h=0;h<i;h++){var m,d=r[h][0]||0;if(c(d,0))m=0;else{var v=p[h][h];if(c(v,0))throw new Error("Linear system cannot be solved since matrix is singular");m=o(d,v);for(var g=h+1;g<n;g++)r[g]=[u(r[g][0]||0,s(m,p[g][h]))]}a[h]=[m]}return new l({data:a,size:[n,1]})},m=function(e,t){t=f(e,t,!0);for(var r,n,i=t._data,a=e._size[0],p=e._size[1],h=e._values,m=e._index,d=e._ptr,v=[],g=0;g<p;g++){var y=i[g][0]||0;if(c(y,0))v[g]=[0];else{var x=0,w=[],b=[],N=d[g+1];for(n=d[g];n<N;n++)r=m[n],r===g?x=h[n]:r>g&&(w.push(h[n]),b.push(r));if(c(x,0))throw new Error("Linear system cannot be solved since matrix is singular");var E=o(y,x);for(n=0,N=b.length;n<N;n++)r=b[n],i[r]=[u(i[r][0]||0,s(E,w[n]))];v[g]=[E]}}return new l({data:v,size:[a,1]})};return p}t.name="lsolve",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,i){var a=n(r(0)),o=n(r(19)),s=n(r(23)),u=n(r(21)),c=n(r(11)),f=n(r(84)),l=e.DenseMatrix,p=i("usolve",{"SparseMatrix, Array | Matrix":function(e,t){return m(e,t)},"DenseMatrix, Array | Matrix":function(e,t){return h(e,t)},"Array, Array | Matrix":function(e,t){var r=a(e),n=h(r,t);return n.valueOf()}}),h=function(e,t){t=f(e,t,!0);for(var r=t._data,n=e._size[0],i=e._size[1],a=[],p=e._data,h=i-1;h>=0;h--){var m,d=r[h][0]||0;if(c(d,0))m=0;else{var v=p[h][h];if(c(v,0))throw new Error("Linear system cannot be solved since matrix is singular");m=o(d,v);for(var g=h-1;g>=0;g--)r[g]=[u(r[g][0]||0,s(m,p[g][h]))]}a[h]=[m]}return new l({data:a,size:[n,1]})},m=function(e,t){t=f(e,t,!0);for(var r,n,i=t._data,a=e._size[0],p=e._size[1],h=e._values,m=e._index,d=e._ptr,v=[],g=p-1;g>=0;g--){var y=i[g][0]||0;if(c(y,0))v[g]=[0];else{var x=0,w=[],b=[],N=d[g],E=d[g+1];for(n=E-1;n>=N;n--)r=m[n],r===g?x=h[n]:r<g&&(w.push(h[n]),b.push(r));if(c(x,0))throw new Error("Linear system cannot be solved since matrix is singular");var M=o(y,x);for(n=0,E=b.length;n<E;n++)r=b[n],i[r]=[u(i[r][0],s(M,w[n]))];v[g]=[M]}}return new l({data:v,size:[a,1]})};return p}t.name="usolve",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,i){var a=n(r(0)),o=n(r(19)),s=r(4),u=n(r(24)),c=n(r(15)),f=n(r(26)),l=n(r(17)),p=n(r(16)),h=n(r(8)),m=n(r(6)),d=i("dotDivide",{"any, any":o,"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=f(e,t,o,!1);break;default:r=u(t,e,o,!0)}break;default:switch(t.storage()){case"sparse":r=c(e,t,o,!1);break;default:r=h(e,t,o)}}return r},"Array, Array":function(e,t){return d(a(e),a(t)).valueOf()},"Array, Matrix":function(e,t){return d(a(e),t)},"Matrix, Array":function(e,t){return d(e,a(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=l(e,t,o,!1);break;default:r=m(e,t,o,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=p(t,e,o,!0);break;default:r=m(t,e,o,!0)}return r},"Array, any":function(e,t){return m(a(e),t,o,!1).valueOf()},"any, Array":function(e,t){return m(a(t),e,o,!0).valueOf()}});return d.toTex={2:"\\left(${args[0]}"+s.operators.dotDivide+"${args[1]}\\right)"},d}t.name="dotDivide",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){var o=n(r(11)),s=e.SparseMatrix,u=function(e,t,r){var n=e._values,u=e._index,c=e._ptr,f=e._size,l=e._datatype,p=t._values,h=t._index,m=t._ptr,d=t._size,v=t._datatype;if(f.length!==d.length)throw new i(f.length,d.length);if(f[0]!==d[0]||f[1]!==d[1])throw new RangeError("Dimension mismatch. Matrix A ("+f+") must match Matrix B ("+d+")");var g,y=f[0],x=f[1],w=o,b=0,N=r;"string"==typeof l&&l===v&&(g=l,w=a.find(o,[g,g]),b=a.convert(0,g),N=a.find(r,[g,g]));var E,M,A,O,T,_=n&&p?[]:void 0,S=[],C=[],z=new s({values:_,index:S,ptr:C,size:[y,x],datatype:g}),k=_?[]:void 0,I=[];for(M=0;M<x;M++){C[M]=S.length;var B=M+1;if(k)for(O=m[M],T=m[M+1],A=O;A<T;A++)E=h[A],I[E]=B,k[E]=p[A];for(O=c[M],T=c[M+1],A=O;A<T;A++)if(E=u[A],k){var P=I[E]===B?k[E]:b,R=N(n[A],P);w(R,b)||(S.push(E),_.push(R))}else S.push(E)}return C[x]=S.length,z};return u}var i=r(10);t.name="algorithm09",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){var o=n(r(19)),s=a("log",{number:function(r){return r>=0||t.predictable?Math.log(r):new e.Complex(r,0).log()},Complex:function(e){return e.log()},BigNumber:function(r){return!r.isNegative()||t.predictable?r.ln():new e.Complex(r.toNumber(),0).log()},"Array | Matrix":function(e){return i(e,s)},"any, any":function(e,t){return o(s(e),s(t))}});return s.toTex={1:"\\ln\\left(${args[0]}\\right)",2:"\\log_{${args[1]}}\\left(${args[0]}\\right)"},s}var i=r(1);t.name="log",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,o){var s=n(r(0)),u=n(r(18)),c=o("trace",{Array:function(e){return c(s(e))},Matrix:function(e){var t;switch(e.storage()){case"dense":t=f(e);break;case"sparse":t=l(e)}return t},any:i}),f=function(e){var t=e._size,r=e._data;switch(t.length){case 1:if(1==t[0])return i(r[0]);throw new RangeError("Matrix must be square (size: "+a(t)+")");case 2:var n=t[0],o=t[1];if(n===o){for(var s=0,c=0;c<n;c++)s=u(s,r[c][c]);return s}throw new RangeError("Matrix must be square (size: "+a(t)+")");default:throw new RangeError("Matrix must be two dimensional (size: "+a(t)+")")}},l=function(e){var t=e._values,r=e._index,n=e._ptr,i=e._size,o=i[0],s=i[1];if(o===s){var c=0;if(t.length>0)for(var f=0;f<s;f++)for(var l=n[f],p=n[f+1],h=l;h<p;h++){var m=r[h];if(m===f){c=u(c,t[h]);break}if(m>f)break}return c}throw new RangeError("Matrix must be square (size: "+a(i)+")")};return c.toTex={1:"\\mathrm{tr}\\left(${args[0]}\\right)"},c}var i=r(5).clone,a=r(9).format;t.name="trace",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,i){var a=n(r(18)),o=n(r(21)),s=n(r(12)),u=n(r(47)),c=n(r(45)),f=n(r(69)),l=n(r(70)),p=n(r(57)),h=n(r(48)),m=n(r(34)),d=i("stirlingS2",{"number | BigNumber, number | BigNumber":function(e,t){if(!h(e)||p(e)||!h(t)||p(t))throw new TypeError("Non-negative integer value expected in function stirlingS2");if(m(t,e))throw new TypeError("k must be less than or equal to n in function stirlingS2");for(var r=f(t),n=0,i=0;i<=t;i++){var d=c(-1,o(t,i)),v=l(t,i),g=c(i,e);n=a(n,s(s(v,g),d))}return u(n,r)}});return d.toTex={2:"\\mathrm{S}\\left(${args}\\right)"},d}t.name="stirlingS2",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,u){function c(r){if(r.isZero())return new e.BigNumber(1);for(var n=t.precision+(0|Math.log(r.toNumber())),i=e.BigNumber.clone({precision:n}),a=new i(r),o=r.toNumber()-1;o>1;)a=a.times(o),o--;return new e.BigNumber(a.toPrecision(e.BigNumber.precision))}var f=n(r(12)),l=n(r(45)),p=u("gamma",{number:function(e){var t,r;if(a(e)){if(e<=0)return isFinite(e)?1/0:NaN;if(e>171)return 1/0;for(var n=e-2,i=e-1;n>1;)i*=n,n--;return 0==i&&(i=1),i}if(e<.5)return Math.PI/(Math.sin(Math.PI*e)*p(1-e));if(e>=171.35)return 1/0;if(e>85){var u=e*e,c=u*e,f=c*e,l=f*e;return Math.sqrt(2*Math.PI/e)*Math.pow(e/Math.E,e)*(1+1/(12*e)+1/(288*u)-139/(51840*c)-571/(2488320*f)+163879/(209018880*l)+5246819/(75246796800*l*e))}--e,r=s[0];for(var h=1;h<s.length;++h)r+=s[h]/(e+h);return t=e+o+.5,Math.sqrt(2*Math.PI)*Math.pow(t,e+.5)*Math.exp(-t)*r},Complex:function(t){var r,n;if(0==t.im)return p(t.re);t=new e.Complex(t.re-1,t.im),n=new e.Complex(s[0],0);for(var i=1;i<s.length;++i){var a=t.re+i,u=a*a+t.im*t.im;0!=u?(n.re+=s[i]*a/u,n.im+=-(s[i]*t.im)/u):n.re=s[i]<0?-(1/0):1/0}r=new e.Complex(t.re+o+.5,t.im);var c=Math.sqrt(2*Math.PI);t.re+=.5;var h=l(r,t);0==h.im?h.re*=c:0==h.re?h.im*=c:(h.re*=c,h.im*=c);var m=Math.exp(-r.re);return r.re=m*Math.cos(-r.im),r.im=m*Math.sin(-r.im),f(f(h,r),n)},BigNumber:function(t){if(t.isInteger())return t.isNegative()||t.isZero()?new e.BigNumber(1/0):c(t.minus(1));if(!t.isFinite())return new e.BigNumber(t.isNegative()?NaN:1/0);throw new Error("Integer BigNumber expected")},"Array | Matrix":function(e){return i(e,p)}});return p.toTex={1:"\\Gamma\\left(${args[0]}\\right)"},p}var i=r(1),a=r(3).isInteger,o=4.7421875,s=[.9999999999999971,57.15623566586292,-59.59796035547549,14.136097974741746,-.4919138160976202,3399464998481189e-20,4652362892704858e-20,-9837447530487956e-20,.0001580887032249125,-.00021026444172410488,.00021743961811521265,-.0001643181065367639,8441822398385275e-20,-26190838401581408e-21,36899182659531625e-22];t.name="gamma",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){var o=r(4),s=a("not",{number:function(e){return!e},Complex:function(e){return 0===e.re&&0===e.im},BigNumber:function(e){return e.isZero()||e.isNaN()},Unit:function(e){return s(e.value)},"Array | Matrix":function(e){return i(e,s)}});return s.toTex={1:o.operators.not+"\\left(${args[0]}\\right)"},s}var i=r(1);t.name="not",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("map",{"Array, function":i,"Matrix, function":function(e,t){return e.map(t)}});return a.toTex=void 0,a}function i(e,t){var r=a(t),n=function(i,a){return Array.isArray(i)?i.map(function(e,t){return n(e,a.concat(t))}):1===r?t(i):2===r?t(i,a):t(i,a,e)};return n(e,[])}var a=r(32).maxArgumentCount;t.name="map",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){function o(e){if("asc"===e)return f;if("desc"===e)return l;if("natural"===e)return p;throw new Error('String "asc", "desc", or "natural" expected')}function s(e){if(1!==i(e).length)throw new Error("One dimensional array expected")}function u(e){if(1!==e.size().length)throw new Error("One dimensional matrix expected")}var c=n(r(0)),f=n(r(49)),l=function(e,t){return-f(e,t)},p=n(r(31)),h=a("sort",{Array:function(e){return s(e),e.sort(f)},Matrix:function(e){return u(e),c(e.toArray().sort(f),e.storage())},"Array, function":function(e,t){return s(e),e.sort(t)},"Matrix, function":function(e,t){return u(e),c(e.toArray().sort(t),e.storage())},"Array, string":function(e,t){return s(e),e.sort(o(t))},"Matrix, string":function(e,t){return u(e),c(e.toArray().sort(o(t)),e.storage())}});return h.toTex=void 0,h}var i=r(2).size;t.name="sort",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){function o(r){var n=void 0;if(i(r,function(e){n=void 0===n?e:s(n,e)}),void 0===n)switch(t.number){case"number":return 0;case"BigNumber":return new e.BigNumber(0);case"Fraction":return new e.Fraction(0);default:return 0}return n}var s=n(r(20)),u=a("sum",{"Array | Matrix":function(e){return o(e)},"Array | Matrix, number | BigNumber":function(){throw new Error("sum(A, dim) is not yet supported")},"...":function(e){return o(e)}});return u.toTex=void 0,u}var i=r(42);t.name="sum",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,s){var u=n(r(30)),c=n(r(27)),f=n(r(43)),l=n(r(28)),p=n(r(22)),h=n(r(31)),m=s("setDifference",{"Array | Matrix, Array | Matrix":function(e,t){if(0===p(l(e),new c(0)))var r=[];else{if(0===p(l(t),new c(0)))return i(e.toArray());for(var n,s=a(i(Array.isArray(e)?e:e.toArray()).sort(h)),m=a(i(Array.isArray(t)?t:t.toArray()).sort(h)),r=[],d=0;d<s.length;d++){n=!1;for(var v=0;v<m.length;v++)if(u(s[d].value,m[v].value)&&s[d].identifier===m[v].identifier){n=!0;break}n||r.push(s[d])}}return Array.isArray(e)&&Array.isArray(t)?o(r):new f(o(r))}});return m}var i=r(2).flatten,a=r(2).identify,o=r(2).generalize;t.name="setDifference",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,s){var u=n(r(30)),c=n(r(27)),f=n(r(43)),l=n(r(28)),p=n(r(22)),h=n(r(31)),m=s("setIntersect",{"Array | Matrix, Array | Matrix":function(e,t){if(0===p(l(e),new c(0))||0===p(l(t),new c(0)))var r=[];else for(var n=a(i(Array.isArray(e)?e:e.toArray()).sort(h)),s=a(i(Array.isArray(t)?t:t.toArray()).sort(h)),r=[],m=0;m<n.length;m++)for(var d=0;d<s.length;d++)if(u(n[m].value,s[d].value)&&n[m].identifier===s[d].identifier){r.push(n[m]);break}return Array.isArray(e)&&Array.isArray(t)?o(r):new f(o(r))}});return m}var i=r(2).flatten,a=r(2).identify,o=r(2).generalize;t.name="setIntersect",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){var o=n(r(27)),s=n(r(64)),u=n(r(28)),c=(n(r(140)),n(r(22))),f=n(r(142)),l=a("setSymDifference",{"Array | Matrix, Array | Matrix":function(e,t){if(0===c(u(e),new o(0)))return i(t);if(0===c(u(t),new o(0)))return i(e);var r=i(e),n=i(t);return s(f(r,n),f(n,r))}});return l}var i=r(2).flatten;t.name="setSymDifference",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,o){function s(e){e=i(e.valueOf());var t=e.length;if(0==t)throw new Error("Cannot calculate median of an empty array");if(t%2==0){for(var r=t/2-1,n=l(e,r+1),a=e[r],o=0;o<r;++o)f(e[o],a)>0&&(a=e[o]);return m(a,n)}var s=l(e,(t-1)/2);return h(s)}var u=n(r(20)),c=n(r(19)),f=n(r(49)),l=n(r(88)),p=o("median",{"Array | Matrix":s,"Array | Matrix, number | BigNumber":function(e,t){throw new Error("median(A, dim) is not yet supported")},"...":function(e){if(a(e))throw new TypeError("Scalar values expected in function median");return s(e)}}),h=o({"number | BigNumber | Complex | Unit":function(e){return e}}),m=o({"number | BigNumber | Complex | Unit, number | BigNumber | Complex | Unit":function(e,t){
return c(u(e,t),2)}});return p.toTex=void 0,p}var i=r(2).flatten,a=(r(65),r(66));t.name="median",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,o){function s(t,r){var n=0,i=0;if(0==t.length)throw new SyntaxError("Function var requires one or more parameters (0 provided)");if(a(t,function(e){n=u(n,e),i++}),0===i)throw new Error("Cannot calculate var of an empty array");var o=l(n,i);switch(n=0,a(t,function(e){var t=c(e,o);n=u(n,f(t,t))}),r){case"uncorrected":return l(n,i);case"biased":return l(n,i+1);case"unbiased":var s=e.isBigNumber(n)?new e.BigNumber(0):0;return 1==i?s:l(n,i-1);default:throw new Error('Unknown normalization "'+r+'". Choose "unbiased" (default), "uncorrected", or "biased".')}}var u=n(r(20)),c=n(r(21)),f=n(r(23)),l=n(r(19)),p=o("variance",{"Array | Matrix":function(e){return s(e,i)},"Array | Matrix, string":s,"...":function(e){return s(e,i)}});return p.toTex="\\mathrm{Var}\\left(${args}\\right)",p}var i="unbiased",a=r(42);t.name="var",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var o=n("acosh",{number:function(r){return r>=1||t.predictable?a(r):r<=-1?new e.Complex(Math.log(Math.sqrt(r*r-1)-r),Math.PI):new e.Complex(r,0).acosh()},Complex:function(e){return e.acosh()},BigNumber:function(e){return e.acosh()},"Array | Matrix":function(e){return i(e,o)}});return o.toTex={1:"\\cosh^{-1}\\left(${args[0]}\\right)"},o}var i=r(1),a=Math.acosh||function(e){return Math.log(Math.sqrt(e*e-1)+e)};t.name="acosh",t.factory=n},function(e,t,r){function n(e){var t=i.create(e);return t.create=n,t.import(r(156)),t}var i=r(149);e.exports=n()},function(e,t,r){e.exports=r(150)},function(e,t,r){var n=r(5).isFactory,i=r(151),a=r(90),o=r(154),s=r(155);t.create=function(e){function t(e){if(!n(e))throw new Error("Factory object with properties `type`, `name`, and `factory` expected");var i,a=r.indexOf(e);return a===-1?(i=e.math===!0?e.factory(c.type,f,t,c.typed,c):e.factory(c.type,f,t,c.typed),r.push(e),u.push(i)):i=u[a],i}if("function"!=typeof Object.create)throw new Error("ES5 not supported by this JavaScript engine. Please load the es5-shim and es5-sham library for compatibility.");var r=[],u=[],c=a.mixin({});c.type={},c.expression={transform:{},mathWithTransform:{}},c.typed=i.create(c.type);var f={epsilon:1e-12,matrix:"Matrix",number:"number",precision:64,predictable:!1,randomSeed:null};return c.import=t(o),c.config=t(s),c.expression.mathWithTransform.config=c.config,e&&c.config(e),c}},function(e,t,r){var n=r(152),i=r(3).digits,a=r(71),o=r(58),s=function(){return s=n.create,n};t.create=function(e){e.isNumber=function(e){return"number"==typeof e},e.isComplex=function(t){return e.Complex&&t instanceof e.Complex||!1},e.isBigNumber=a,e.isFraction=function(t){return e.Fraction&&t instanceof e.Fraction||!1},e.isUnit=function(e){return e&&e.constructor.prototype.isUnit||!1},e.isString=function(e){return"string"==typeof e},e.isArray=Array.isArray,e.isMatrix=o,e.isDenseMatrix=function(e){return e&&e.isDenseMatrix&&e.constructor.prototype.isMatrix||!1},e.isSparseMatrix=function(e){return e&&e.isSparseMatrix&&e.constructor.prototype.isMatrix||!1},e.isRange=function(e){return e&&e.constructor.prototype.isRange||!1},e.isIndex=function(e){return e&&e.constructor.prototype.isIndex||!1},e.isBoolean=function(e){return"boolean"==typeof e},e.isResultSet=function(e){return e&&e.constructor.prototype.isResultSet||!1},e.isHelp=function(e){return e&&e.constructor.prototype.isHelp||!1},e.isFunction=function(e){return"function"==typeof e},e.isDate=function(e){return e instanceof Date},e.isRegExp=function(e){return e instanceof RegExp},e.isObject=function(e){return"object"==typeof e},e.isNull=function(e){return null===e},e.isUndefined=function(e){return void 0===e},e.isAccessorNode=function(e){return e&&e.isAccessorNode&&e.constructor.prototype.isNode||!1},e.isArrayNode=function(e){return e&&e.isArrayNode&&e.constructor.prototype.isNode||!1},e.isAssignmentNode=function(e){return e&&e.isAssignmentNode&&e.constructor.prototype.isNode||!1},e.isBlockNode=function(e){return e&&e.isBlockNode&&e.constructor.prototype.isNode||!1},e.isConditionalNode=function(e){return e&&e.isConditionalNode&&e.constructor.prototype.isNode||!1},e.isConstantNode=function(e){return e&&e.isConstantNode&&e.constructor.prototype.isNode||!1},e.isFunctionAssignmentNode=function(e){return e&&e.isFunctionAssignmentNode&&e.constructor.prototype.isNode||!1},e.isFunctionNode=function(e){return e&&e.isFunctionNode&&e.constructor.prototype.isNode||!1},e.isIndexNode=function(e){return e&&e.isIndexNode&&e.constructor.prototype.isNode||!1},e.isNode=function(e){return e&&e.isNode&&e.constructor.prototype.isNode||!1},e.isObjectNode=function(e){return e&&e.isObjectNode&&e.constructor.prototype.isNode||!1},e.isOperatorNode=function(e){return e&&e.isOperatorNode&&e.constructor.prototype.isNode||!1},e.isParenthesisNode=function(e){return e&&e.isParenthesisNode&&e.constructor.prototype.isNode||!1},e.isRangeNode=function(e){return e&&e.isRangeNode&&e.constructor.prototype.isNode||!1},e.isSymbolNode=function(e){return e&&e.isSymbolNode&&e.constructor.prototype.isNode||!1},e.isChain=function(e){return e&&e.constructor.prototype.isChain||!1};var t=s();return t.types=[{name:"number",test:e.isNumber},{name:"Complex",test:e.isComplex},{name:"BigNumber",test:e.isBigNumber},{name:"Fraction",test:e.isFraction},{name:"Unit",test:e.isUnit},{name:"string",test:e.isString},{name:"Array",test:e.isArray},{name:"Matrix",test:e.isMatrix},{name:"DenseMatrix",test:e.isDenseMatrix},{name:"SparseMatrix",test:e.isSparseMatrix},{name:"Range",test:e.isRange},{name:"Index",test:e.isIndex},{name:"boolean",test:e.isBoolean},{name:"ResultSet",test:e.isResultSet},{name:"Help",test:e.isHelp},{name:"function",test:e.isFunction},{name:"Date",test:e.isDate},{name:"RegExp",test:e.isRegExp},{name:"Object",test:e.isObject},{name:"null",test:e.isNull},{name:"undefined",test:e.isUndefined},{name:"OperatorNode",test:e.isOperatorNode},{name:"ConstantNode",test:e.isConstantNode},{name:"SymbolNode",test:e.isSymbolNode},{name:"ParenthesisNode",test:e.isParenthesisNode},{name:"FunctionNode",test:e.isFunctionNode},{name:"FunctionAssignmentNode",test:e.isFunctionAssignmentNode},{name:"ArrayNode",test:e.isArrayNode},{name:"AssignmentNode",test:e.isAssignmentNode},{name:"BlockNode",test:e.isBlockNode},{name:"ConditionalNode",test:e.isConditionalNode},{name:"IndexNode",test:e.isIndexNode},{name:"RangeNode",test:e.isRangeNode},{name:"Node",test:e.isNode}],t.conversions=[{from:"number",to:"BigNumber",convert:function(t){if(i(t)>15)throw new TypeError("Cannot implicitly convert a number with >15 significant digits to BigNumber (value: "+t+"). Use function bignumber(x) to convert to BigNumber.");return new e.BigNumber(t)}},{from:"number",to:"Complex",convert:function(t){return new e.Complex(t,0)}},{from:"number",to:"string",convert:function(e){return e+""}},{from:"BigNumber",to:"Complex",convert:function(t){return new e.Complex(t.toNumber(),0)}},{from:"Fraction",to:"BigNumber",convert:function(e){throw new TypeError("Cannot implicitly convert a Fraction to BigNumber or vice versa. Use function bignumber(x) to convert to BigNumber or fraction(x) to convert to Fraction.")}},{from:"Fraction",to:"Complex",convert:function(t){return new e.Complex(t.valueOf(),0)}},{from:"number",to:"Fraction",convert:function(t){var r=new e.Fraction(t);if(r.valueOf()!==t)throw new TypeError("Cannot implicitly convert a number to a Fraction when there will be a loss of precision (value: "+t+"). Use function fraction(x) to convert to Fraction.");return new e.Fraction(t)}},{from:"string",to:"number",convert:function(e){var t=Number(e);if(isNaN(t))throw new Error('Cannot convert "'+e+'" to a number');return t}},{from:"string",to:"BigNumber",convert:function(t){try{return new e.BigNumber(t)}catch(e){throw new Error('Cannot convert "'+t+'" to BigNumber')}}},{from:"string",to:"Fraction",convert:function(t){try{return new e.Fraction(t)}catch(e){throw new Error('Cannot convert "'+t+'" to Fraction')}}},{from:"string",to:"Complex",convert:function(t){try{return new e.Complex(t)}catch(e){throw new Error('Cannot convert "'+t+'" to Complex')}}},{from:"boolean",to:"number",convert:function(e){return+e}},{from:"boolean",to:"BigNumber",convert:function(t){return new e.BigNumber(+t)}},{from:"boolean",to:"Fraction",convert:function(t){return new e.Fraction(+t)}},{from:"boolean",to:"string",convert:function(e){return+e}},{from:"null",to:"number",convert:function(){return 0}},{from:"null",to:"string",convert:function(){return"null"}},{from:"null",to:"BigNumber",convert:function(){return new e.BigNumber(0)}},{from:"null",to:"Fraction",convert:function(){return new e.Fraction(0)}},{from:"Array",to:"Matrix",convert:function(t){return new e.DenseMatrix(t)}},{from:"Matrix",to:"Array",convert:function(e){return e.valueOf()}}],t}},function(e,t,r){"use strict";var n,i,a;!function(r,o){i=[],n=o,a="function"==typeof n?n.apply(t,i):n,!(void 0!==a&&(e.exports=a))}(this,function(){function e(){function t(e){for(var t,r=0;r<M.types.length;r++){var n=M.types[r];if(n.name===e){t=n.test;break}}if(!t){var i;for(r=0;r<M.types.length;r++)if(n=M.types[r],n.name.toLowerCase()==e.toLowerCase()){i=n.name;break}throw new Error('Unknown type "'+e+'"'+(i?'. Did you mean "'+i+'"?':""))}return t}function r(e){for(var t="",r=0;r<e.length;r++){var n=e[r];if(n.signatures&&""!=n.name)if(""==t)t=n.name;else if(t!=n.name){var i=new Error("Function names do not match (expected: "+t+", actual: "+n.name+")");throw i.data={actual:n.name,expected:t},i}}return t}function n(e,t,r,n,i){var a,o=d(n),s=i?i.split(","):null,u=e||"unnamed",c=s&&v(s,"any"),f={fn:e,index:r,actual:n,expected:s};a=s?t>r&&!c?"Unexpected type of argument in function "+u+" (expected: "+s.join(" or ")+", actual: "+o+", index: "+r+")":"Too few arguments in function "+u+" (expected: "+s.join(" or ")+", index: "+r+")":"Too many arguments in function "+u+" (expected: "+r+", actual: "+t+")";var l=new TypeError(a);return l.data=f,l}function i(e){this.name=e||"refs",this.categories={}}function a(e,t){if("string"==typeof e){var r=e.trim(),n="..."===r.substr(0,3);if(n&&(r=r.substr(3)),""===r)this.types=["any"];else{this.types=r.split("|");for(var i=0;i<this.types.length;i++)this.types[i]=this.types[i].trim()}}else{if(!Array.isArray(e)){if(e instanceof a)return e.clone();throw new Error("String or Array expected")}this.types=e}this.conversions=[],this.varArgs=n||t||!1,this.anyType=this.types.indexOf("any")!==-1}function o(e,t){var r;if("string"==typeof e)r=""!==e?e.split(","):[];else{if(!Array.isArray(e))throw new Error("string or Array expected");r=e}this.params=new Array(r.length),this.anyType=!1,this.varArgs=!1;for(var n=0;n<r.length;n++){var i=new a(r[n]);if(this.params[n]=i,i.anyType&&(this.anyType=!0),n===r.length-1)this.varArgs=i.varArgs;else if(i.varArgs)throw new SyntaxError('Unexpected variable arguments operator "..."')}this.fn=t}function s(e,t,r,n){this.path=e||[],this.param=e[e.length-1]||null,this.signature=t||null,this.childs=r||[],this.fallThrough=n||!1}function u(e){var t,r,n={},i=[];for(var a in e)if(e.hasOwnProperty(a)){var s=e[a];if(t=new o(a,s),t.ignore())continue;var u=t.expand();for(r=0;r<u.length;r++){var c=u[r],f=c.toString(),l=n[f];if(l){var p=o.compare(c,l);if(p<0)n[f]=c;else if(0===p)throw new Error('Signature "'+f+'" is defined twice')}else n[f]=c}}for(f in n)n.hasOwnProperty(f)&&i.push(n[f]);for(i.sort(function(e,t){return o.compare(e,t)}),r=0;r<i.length;r++)if(t=i[r],t.varArgs)for(var h=t.params.length-1,m=t.params[h],d=0;d<m.types.length;){if(m.conversions[d])for(var g=m.types[d],y=0;y<i.length;y++){var x=i[y],w=x.params[h];if(x!==t&&w&&v(w.types,g)&&!w.conversions[h]){m.types.splice(d,1),m.conversions.splice(d,1),d--;break}}d++}return i}function c(e){for(var t=[],r=0;r<e.length;r++)e[r].anyType&&t.push(e[r]);return t}function f(e){for(var t={},r=0;r<e.length;r++){var n=e[r];if(n.fn&&!n.hasConversions()){var i=n.params.join(",");t[i]=n.fn}}return t}function l(e,t,r){var n,i,o,u=t.length,c=[];for(n=0;n<e.length;n++)i=e[n],i.params.length!==u||o||(o=i),void 0!=i.params[u]&&c.push(i);c.sort(function(e,t){return a.compare(e.params[u],t.params[u])});var f=[];for(n=0;n<c.length;n++){i=c[n];var p=i.params[u],h=f.filter(function(e){return e.param.overlapping(p)})[0];if(h){if(h.param.varArgs)throw new Error('Conflicting types "'+h.param+'" and "'+p+'"');h.signatures.push(i)}else f.push({param:p,signatures:[i]})}var m=[];for(n=0;n<r.length;n++)r[n].paramsStartWith(t)&&m.push(r[n]);var d=!1;for(n=0;n<m.length;n++)if(!v(e,m[n])){d=!0;break}var g=new Array(f.length);for(n=0;n<f.length;n++){var y=f[n];g[n]=l(y.signatures,t.concat(y.param),m)}return new s(t,o,g,d)}function p(e){for(var t=[],r=0;r<e;r++)t[r]="arg"+r;return t}function h(e,t){var r=new i,a=u(t);if(0==a.length)throw new Error("No signatures provided");var o=c(a),s=l(a,[],o),h=[],d=e||"",v=p(m(a));h.push("function "+d+"("+v.join(", ")+") {"),h.push('  "use strict";'),h.push("  var name = '"+d+"';"),h.push(s.toCode(r,"  ",!1)),h.push("}");var g=[r.toCode(),"return "+h.join("\n")].join("\n"),y=new Function(r.name,"createError",g),x=y(r,n);return x.signatures=f(a),x}function m(e){for(var t=0,r=0;r<e.length;r++){var n=e[r].params.length;n>t&&(t=n)}return t}function d(e){for(var t,r=0;r<M.types.length;r++){var n=M.types[r];if("Object"===n.name)t=n;else if(n.test(e))return n.name}return t&&t.test(e)?t.name:"unknown"}function v(e,t){return e.indexOf(t)!==-1}function g(e){return e[e.length-1]}function y(e,t){if(!e.signatures)throw new TypeError("Function is no typed-function");var r;if("string"==typeof t){r=t.split(",");for(var n=0;n<r.length;n++)r[n]=r[n].trim()}else{if(!Array.isArray(t))throw new TypeError("String array or a comma separated string expected");r=t}var i=r.join(","),a=e.signatures[i];if(a)return a;throw new TypeError("Signature not found (signature: "+(e.name||"unnamed")+"("+r.join(", ")+"))")}function x(e,t){var r=d(e);if(t===r)return e;for(var n=0;n<M.conversions.length;n++){var i=M.conversions[n];if(i.from===r&&i.to===t)return i.convert(e)}throw new Error("Cannot convert from "+r+" to "+t)}i.prototype.add=function(e,t){var r=t||"fn";this.categories[r]||(this.categories[r]=[]);var n=this.categories[r].indexOf(e);return n==-1&&(n=this.categories[r].length,this.categories[r].push(e)),r+n},i.prototype.toCode=function(){var e=[],t=this.name+".categories",r=this.categories;for(var n in r)if(r.hasOwnProperty(n))for(var i=r[n],a=0;a<i.length;a++)e.push("var "+n+a+" = "+t+"['"+n+"']["+a+"];");return e.join("\n")},a.compare=function(e,t){if(e.anyType)return 1;if(t.anyType)return-1;if(v(e.types,"Object"))return 1;if(v(t.types,"Object"))return-1;if(e.hasConversions()){if(t.hasConversions()){var r,n,i;for(r=0;r<e.conversions.length;r++)if(void 0!==e.conversions[r]){n=e.conversions[r];break}for(r=0;r<t.conversions.length;r++)if(void 0!==t.conversions[r]){i=t.conversions[r];break}return M.conversions.indexOf(n)-M.conversions.indexOf(i)}return 1}if(t.hasConversions())return-1;var a,o;for(r=0;r<M.types.length;r++)if(M.types[r].name===e.types[0]){a=r;break}for(r=0;r<M.types.length;r++)if(M.types[r].name===t.types[0]){o=r;break}return a-o},a.prototype.overlapping=function(e){for(var t=0;t<this.types.length;t++)if(v(e.types,this.types[t]))return!0;return!1},a.prototype.matches=function(e){return this.anyType||e.anyType||this.overlapping(e)},a.prototype.clone=function(){var e=new a(this.types.slice(),this.varArgs);return e.conversions=this.conversions.slice(),e},a.prototype.hasConversions=function(){return this.conversions.length>0},a.prototype.contains=function(e){for(var t=0;t<this.types.length;t++)if(e[this.types[t]])return!0;return!1},a.prototype.toString=function(e){for(var t=[],r={},n=0;n<this.types.length;n++){var i=this.conversions[n],a=e&&i?i.to:this.types[n];a in r||(r[a]=!0,t.push(a))}return(this.varArgs?"...":"")+t.join("|")},o.prototype.clone=function(){return new o(this.params.slice(),this.fn)},o.prototype.expand=function(){function e(r,n){if(n.length<r.params.length){var i,s,u,c=r.params[n.length];if(c.varArgs){for(s=c.clone(),i=0;i<M.conversions.length;i++)if(u=M.conversions[i],!v(c.types,u.from)&&v(c.types,u.to)){var f=s.types.length;s.types[f]=u.from,s.conversions[f]=u}e(r,n.concat(s))}else{for(i=0;i<c.types.length;i++)e(r,n.concat(new a(c.types[i])));for(i=0;i<M.conversions.length;i++)u=M.conversions[i],!v(c.types,u.from)&&v(c.types,u.to)&&(s=new a(u.from),s.conversions[0]=u,e(r,n.concat(s)))}}else t.push(new o(n,r.fn))}var t=[];return e(this,[]),t},o.compare=function(e,t){if(e.params.length>t.params.length)return 1;if(e.params.length<t.params.length)return-1;var r,n=e.params.length,i=0,o=0;for(r=0;r<n;r++)e.params[r].hasConversions()&&i++,t.params[r].hasConversions()&&o++;if(i>o)return 1;if(i<o)return-1;for(r=0;r<e.params.length;r++){var s=a.compare(e.params[r],t.params[r]);if(0!==s)return s}return 0},o.prototype.hasConversions=function(){for(var e=0;e<this.params.length;e++)if(this.params[e].hasConversions())return!0;return!1},o.prototype.ignore=function(){for(var e={},t=0;t<M.ignore.length;t++)e[M.ignore[t]]=!0;for(t=0;t<this.params.length;t++)if(this.params[t].contains(e))return!0;return!1},o.prototype.paramsStartWith=function(e){if(0===e.length)return!0;for(var t=g(this.params),r=g(e),n=0;n<e.length;n++){var i=this.params[n]||(t.varArgs?t:null),a=e[n]||(r.varArgs?r:null);if(!i||!a||!i.matches(a))return!1}return!0},o.prototype.toCode=function(e,t){for(var r=[],n=new Array(this.params.length),i=0;i<this.params.length;i++){var a=this.params[i],o=a.conversions[0];a.varArgs?n[i]="varArgs":o?n[i]=e.add(o.convert,"convert")+"(arg"+i+")":n[i]="arg"+i}var s=this.fn?e.add(this.fn,"signature"):void 0;return s?t+"return "+s+"("+n.join(", ")+"); // signature: "+this.params.join(", "):r.join("\n")},o.prototype.toString=function(){return this.params.join(", ")},s.prototype.toCode=function(e,r){var n=[];if(this.param){var i=this.path.length-1,a=this.param.conversions[0],o="// type: "+(a?a.from+" (convert to "+a.to+")":this.param);if(this.param.varArgs)if(this.param.anyType)n.push(r+"if (arguments.length > "+i+") {"),n.push(r+"  var varArgs = [];"),n.push(r+"  for (var i = "+i+"; i < arguments.length; i++) {"),n.push(r+"    varArgs.push(arguments[i]);"),n.push(r+"  }"),n.push(this.signature.toCode(e,r+"  ")),n.push(r+"}");else{for(var s=function(r,n){for(var i=[],a=0;a<r.length;a++)i[a]=e.add(t(r[a]),"test")+"("+n+")";return i.join(" || ")}.bind(this),u=this.param.types,c=[],f=0;f<u.length;f++)void 0===this.param.conversions[f]&&c.push(u[f]);n.push(r+"if ("+s(u,"arg"+i)+") { "+o),n.push(r+"  var varArgs = [arg"+i+"];"),n.push(r+"  for (var i = "+(i+1)+"; i < arguments.length; i++) {"),n.push(r+"    if ("+s(c,"arguments[i]")+") {"),n.push(r+"      varArgs.push(arguments[i]);");for(var f=0;f<u.length;f++){var l=this.param.conversions[f];if(l){var p=e.add(t(u[f]),"test"),h=e.add(l.convert,"convert");n.push(r+"    }"),n.push(r+"    else if ("+p+"(arguments[i])) {"),n.push(r+"      varArgs.push("+h+"(arguments[i]));")}}n.push(r+"    } else {"),n.push(r+"      throw createError(name, arguments.length, i, arguments[i], '"+c.join(",")+"');"),n.push(r+"    }"),n.push(r+"  }"),n.push(this.signature.toCode(e,r+"  ")),n.push(r+"}")}else if(this.param.anyType)n.push(r+"// type: any"),n.push(this._innerCode(e,r));else{var m=this.param.types[0],p="any"!==m?e.add(t(m),"test"):null;n.push(r+"if ("+p+"(arg"+i+")) { "+o),n.push(this._innerCode(e,r+"  ")),n.push(r+"}")}}else n.push(this._innerCode(e,r));return n.join("\n")},s.prototype._innerCode=function(e,t){var r,n=[];for(this.signature&&(n.push(t+"if (arguments.length === "+this.path.length+") {"),n.push(this.signature.toCode(e,t+"  ")),n.push(t+"}")),r=0;r<this.childs.length;r++)n.push(this.childs[r].toCode(e,t));if(!this.fallThrough||this.param&&this.param.anyType){var i=this._exceptions(e,t);i&&n.push(i)}return n.join("\n")},s.prototype._exceptions=function(e,t){var r=this.path.length;if(0===this.childs.length)return[t+"if (arguments.length > "+r+") {",t+"  throw createError(name, arguments.length, "+r+", arguments["+r+"]);",t+"}"].join("\n");for(var n={},i=[],a=0;a<this.childs.length;a++){var o=this.childs[a];if(o.param)for(var s=0;s<o.param.types.length;s++){var u=o.param.types[s];u in n||o.param.conversions[s]||(n[u]=!0,i.push(u))}}return t+"throw createError(name, arguments.length, "+r+", arguments["+r+"], '"+i.join(",")+"');"};var w=[{name:"number",test:function(e){return"number"==typeof e}},{name:"string",test:function(e){return"string"==typeof e}},{name:"boolean",test:function(e){return"boolean"==typeof e}},{name:"Function",test:function(e){return"function"==typeof e}},{name:"Array",test:Array.isArray},{name:"Date",test:function(e){return e instanceof Date}},{name:"RegExp",test:function(e){return e instanceof RegExp}},{name:"Object",test:function(e){return"object"==typeof e}},{name:"null",test:function(e){return null===e}},{name:"undefined",test:function(e){return void 0===e}}],b={},N=[],E=[],M={config:b,types:w,conversions:N,ignore:E};return M=h("typed",{Object:function(e){var t=[];for(var n in e)e.hasOwnProperty(n)&&t.push(e[n]);var i=r(t);return h(i,e)},"string, Object":h,"...Function":function(e){for(var t,n=r(e),i={},a=0;a<e.length;a++){var o=e[a];if("object"!=typeof o.signatures)throw t=new TypeError("Function is no typed-function (index: "+a+")"),t.data={index:a},t;for(var s in o.signatures)if(o.signatures.hasOwnProperty(s))if(i.hasOwnProperty(s)){if(o.signatures[s]!==i[s])throw t=new Error('Signature "'+s+'" is defined twice'),t.data={signature:s},t}else i[s]=o.signatures[s]}return h(n,i)}}),M.config=b,M.types=w,M.conversions=N,M.ignore=E,M.create=e,M.find=y,M.convert=x,M.addType=function(e){if(!e||"string"!=typeof e.name||"function"!=typeof e.test)throw new TypeError("Object with properties {name: string, test: function} expected");M.types.push(e)},M.addConversion=function(e){if(!e||"string"!=typeof e.from||"string"!=typeof e.to||"function"!=typeof e.convert)throw new TypeError("Object with properties {from: string, to: string, convert: function} expected");M.conversions.push(e)},M}return e()})},function(e,t){function r(){}r.prototype={on:function(e,t,r){var n=this.e||(this.e={});return(n[e]||(n[e]=[])).push({fn:t,ctx:r}),this},once:function(e,t,r){function n(){i.off(e,n),t.apply(r,arguments)}var i=this;return n._=t,this.on(e,n,r)},emit:function(e){var t=[].slice.call(arguments,1),r=((this.e||(this.e={}))[e]||[]).slice(),n=0,i=r.length;for(n;n<i;n++)r[n].fn.apply(r[n].ctx,t);return this},off:function(e,t){var r=this.e||(this.e={}),n=r[e],i=[];if(n&&t)for(var a=0,o=n.length;a<o;a++)n[a].fn!==t&&n[a].fn._!==t&&i.push(n[a]);return i.length?r[e]=i:delete r[e],this}},e.exports=r},function(e,t,r){"use strict";function n(e,t,r,n,u){function c(e,t){var r=arguments.length;if(1!==r&&2!==r)throw new s("import",r,1,2);if(t||(t={}),a(e))h(e,t);else if(Array.isArray(e))e.forEach(function(e){c(e,t)});else if("object"==typeof e){for(var n in e)if(e.hasOwnProperty(n)){var i=e[n];m(i)?f(n,i,t):a(e)?h(e,t):c(i,t)}}else if(!t.silent)throw new TypeError("Factory, Object, or Array expected")}function f(e,t,r){if(r.wrap&&"function"==typeof t&&(t=p(t)),d(u[e])&&d(t))return t=r.override?n(e,t.signatures):n(u[e],t),u[e]=t,l(e,t),void u.emit("import",e,function(){return t});if(void 0===u[e]||r.override)return u[e]=t,l(e,t),void u.emit("import",e,function(){return t});if(!r.silent)throw new Error('Cannot import "'+e+'": already exists')}function l(e,t){t&&"function"==typeof t.transform?(u.expression.transform[e]=t.transform,v(e)&&(u.expression.mathWithTransform[e]=t.transform)):(delete u.expression.transform[e],v(e)&&(u.expression.mathWithTransform[e]=t))}function p(e){var t=function(){for(var t=[],r=0,n=arguments.length;r<n;r++){var i=arguments[r];t[r]=i&&i.valueOf()}return e.apply(u,t)};return e.transform&&(t.transform=e.transform),t}function h(e,t){if("string"==typeof e.name){var a=e.name,s=a in u.expression.transform,c=e.path?o(u,e.path):u,f=c.hasOwnProperty(a)?c[a]:void 0,l=function(){var i=r(e);if(i&&"function"==typeof i.transform)throw new Error('Transforms cannot be attached to factory functions. Please create a separate function for it with exports.path="expression.transform"');if(d(f)&&d(i))return t.override||(i=n(f,i)),i;if(void 0===f||t.override)return i;if(!t.silent)throw new Error('Cannot import "'+a+'": already exists')};e.lazy!==!1?(i(c,a,l),s||("expression.transform"===e.path||g(e))&&i(u.expression.mathWithTransform,a,l)):(c[a]=l(),s||("expression.transform"===e.path||g(e))&&(u.expression.mathWithTransform[a]=l())),u.emit("import",a,l,e.path)}else r(e)}function m(t){return"function"==typeof t||"number"==typeof t||"string"==typeof t||"boolean"==typeof t||null===t||t&&e.isUnit(t)||t&&e.isComplex(t)||t&&e.isBigNumber(t)||t&&e.isFraction(t)||t&&e.isMatrix(t)||t&&Array.isArray(t)}function d(e){return"function"==typeof e&&"object"==typeof e.signatures}function v(e){return!y.hasOwnProperty(e)}function g(e){return void 0===e.path&&!y.hasOwnProperty(e.name)}var y={expression:!0,type:!0,docs:!0,error:!0,json:!0,chain:!0};return c}var i=r(5).lazy,a=r(5).isFactory,o=r(5).traverse,s=r(50);t.math=!0,t.name="import",t.factory=n,t.lazy=!0},function(e,t,r){"use strict";function n(e,t,r,n,i){function a(e){if(e){var r=s.map(t,s.clone);o(e,"matrix",u),o(e,"number",c),s.deepExtend(t,e);var n=s.map(t,s.clone),a=s.map(e,s.clone);return i.emit("config",n,r,a),n}return s.map(t,s.clone)}var u=["Matrix","Array"],c=["number","BigNumber","Fraction"];return a.MATRIX=u,a.NUMBER=c,a}function i(e,t){return e.indexOf(t)!==-1}function a(e,t){return e.map(function(e){return e.toLowerCase()}).indexOf(t.toLowerCase())}function o(e,t,r){if(void 0!==e[t]&&!i(r,e[t])){var n=a(r,e[t]);n!==-1?(console.warn('Warning: Wrong casing for configuration option "'+t+'", should be "'+r[n]+'" instead of "'+e[t]+'".'),e[t]=r[n]):console.warn('Warning: Unknown value "'+e[t]+'" for configuration option "'+t+'". Available options: '+r.map(JSON.stringify).join(", ")+".")}}var s=r(5);t.name="config",t.math=!0,t.factory=n},function(e,t,r){e.exports=[r(157),r(189),r(191),r(403),r(546),r(548)]},function(e,t,r){e.exports=[r(158),r(162),r(163),r(167),r(170),r(173),r(74),r(181),r(182),r(183)]},function(e,t,r){e.exports=[r(159),r(161)]},function(e,t,r){function n(e,t,r,n,a){var o=i.clone({precision:t.precision});return o.prototype.type="BigNumber",o.prototype.isBigNumber=!0,o.prototype.toJSON=function(){return{mathjs:"BigNumber",value:this.toString()}},o.fromJSON=function(e){return new o(e.value)},a.on("config",function(e,t){e.precision!==t.precision&&o.config({precision:e.precision})}),o}var i=r(160);t.name="BigNumber",t.path="type",t.factory=n,t.math=!0},function(e,t,r){var n;!function(i){"use strict";function a(e){var t,r,n,i=e.length-1,a="",o=e[0];if(i>0){for(a+=o,t=1;t<i;t++)n=e[t]+"",r=Be-n.length,r&&(a+=v(r)),a+=n;o=e[t],n=o+"",r=Be-n.length,r&&(a+=v(r))}else if(0===o)return"0";for(;o%10===0;)o/=10;return a+o}function o(e,t,r){if(e!==~~e||e<t||e>r)throw Error(Me+e)}function s(e,t,r,n){var i,a,o,s;for(a=e[0];a>=10;a/=10)--t;return--t<0?(t+=Be,i=0):(i=Math.ceil((t+1)/Be),t%=Be),a=_e(10,Be-t),s=e[i]%a|0,null==n?t<3?(0==t?s=s/100|0:1==t&&(s=s/10|0),o=r<4&&99999==s||r>3&&49999==s||5e4==s||0==s):o=(r<4&&s+1==a||r>3&&s+1==a/2)&&(e[i+1]/a/100|0)==_e(10,t-2)-1||(s==a/2||0==s)&&0==(e[i+1]/a/100|0):t<4?(0==t?s=s/1e3|0:1==t?s=s/100|0:2==t&&(s=s/10|0),o=(n||r<4)&&9999==s||!n&&r>3&&4999==s):o=((n||r<4)&&s+1==a||!n&&r>3&&s+1==a/2)&&(e[i+1]/a/1e3|0)==_e(10,t-3)-1,o}function u(e,t,r){for(var n,i,a=[0],o=0,s=e.length;o<s;){for(i=a.length;i--;)a[i]*=t;for(a[0]+=ye.indexOf(e.charAt(o++)),n=0;n<a.length;n++)a[n]>r-1&&(void 0===a[n+1]&&(a[n+1]=0),a[n+1]+=a[n]/r|0,a[n]%=r)}return a.reverse()}function c(e,t){var r,n,i=t.d.length;i<32?(r=Math.ceil(i/3),n=Math.pow(4,-r).toString()):(r=16,n="2.3283064365386962890625e-10"),e.precision+=r,t=O(e,1,t.times(n),new e(1));for(var a=r;a--;){var o=t.times(t);t=o.times(o).minus(o).times(8).plus(1)}return e.precision-=r,t}function f(e,t,r,n){var i,a,o,s,u,c,f,l,p,h=e.constructor;e:if(null!=t){if(l=e.d,!l)return e;for(i=1,s=l[0];s>=10;s/=10)i++;if(a=t-i,a<0)a+=Be,o=t,f=l[p=0],u=f/_e(10,i-o-1)%10|0;else if(p=Math.ceil((a+1)/Be),s=l.length,p>=s){if(!n)break e;for(;s++<=p;)l.push(0);f=u=0,i=1,a%=Be,o=a-Be+1}else{for(f=s=l[p],i=1;s>=10;s/=10)i++;a%=Be,o=a-Be+i,u=o<0?0:f/_e(10,i-o-1)%10|0}if(n=n||t<0||void 0!==l[p+1]||(o<0?f:f%_e(10,i-o-1)),c=r<4?(u||n)&&(0==r||r==(e.s<0?3:2)):u>5||5==u&&(4==r||n||6==r&&(a>0?o>0?f/_e(10,i-o):0:l[p-1])%10&1||r==(e.s<0?8:7)),t<1||!l[0])return l.length=0,c?(t-=e.e+1,l[0]=_e(10,(Be-t%Be)%Be),e.e=-t||0):l[0]=e.e=0,e;if(0==a?(l.length=p,s=1,p--):(l.length=p+1,s=_e(10,Be-a),l[p]=o>0?(f/_e(10,i-o)%_e(10,o)|0)*s:0),c)for(;;){if(0==p){for(a=1,o=l[0];o>=10;o/=10)a++;for(o=l[0]+=s,s=1;o>=10;o/=10)s++;a!=s&&(e.e++,l[0]==Ie&&(l[0]=1));break}if(l[p]+=s,l[p]!=Ie)break;l[p--]=0,s=1}for(a=l.length;0===l[--a];)l.pop()}return Ne&&(e.e>h.maxE?(e.d=null,e.e=NaN):e.e<h.minE&&(e.e=0,e.d=[0])),e}function l(e,t,r){if(!e.isFinite())return N(e);var n,i=e.e,o=a(e.d),s=o.length;return t?(r&&(n=r-s)>0?o=o.charAt(0)+"."+o.slice(1)+v(n):s>1&&(o=o.charAt(0)+"."+o.slice(1)),o=o+(e.e<0?"e":"e+")+e.e):i<0?(o="0."+v(-i-1)+o,r&&(n=r-s)>0&&(o+=v(n))):i>=s?(o+=v(i+1-s),r&&(n=r-i-1)>0&&(o=o+"."+v(n))):((n=i+1)<s&&(o=o.slice(0,n)+"."+o.slice(n)),r&&(n=r-s)>0&&(i+1===s&&(o+="."),o+=v(n))),o}function p(e,t){var r=e[0];for(t*=Be;r>=10;r/=10)t++;return t}function h(e,t,r){if(t>Re)throw Ne=!0,r&&(e.precision=r),Error(Ae);return f(new e(xe),t,1,!0)}function m(e,t,r){if(t>Ue)throw Error(Ae);return f(new e(we),t,r,!0)}function d(e){var t=e.length-1,r=t*Be+1;if(t=e[t]){for(;t%10==0;t/=10)r--;for(t=e[0];t>=10;t/=10)r++}return r}function v(e){for(var t="";e--;)t+="0";return t}function g(e,t,r,n){var i,a=new e(1),o=Math.ceil(n/Be+4);for(Ne=!1;;){if(r%2&&(a=a.times(t),S(a.d,o)&&(i=!0)),r=Te(r/2),0===r){r=a.d.length-1,i&&0===a.d[r]&&++a.d[r];break}t=t.times(t),S(t.d,o)}return Ne=!0,a}function y(e){return 1&e.d[e.d.length-1]}function x(e,t,r){for(var n,i=new e(t[0]),a=0;++a<t.length;){if(n=new e(t[a]),!n.s){i=n;break}i[r](n)&&(i=n)}return i}function w(e,t){var r,n,i,o,u,c,l,p=0,h=0,m=0,d=e.constructor,v=d.rounding,g=d.precision;if(!e.d||!e.d[0]||e.e>17)return new d(e.d?e.d[0]?e.s<0?0:1/0:1:e.s?e.s<0?0:e:NaN);for(null==t?(Ne=!1,l=g):l=t,c=new d(.03125);e.e>-2;)e=e.times(c),m+=5;for(n=Math.log(_e(2,m))/Math.LN10*2+5|0,l+=n,r=o=u=new d(1),d.precision=l;;){if(o=f(o.times(e),l,1),r=r.times(++h),c=u.plus(Le(o,r,l,1)),a(c.d).slice(0,l)===a(u.d).slice(0,l)){for(i=m;i--;)u=f(u.times(u),l,1);if(null!=t)return d.precision=g,u;if(!(p<3&&s(u.d,l-n,v,p)))return f(u,d.precision=g,v,Ne=!0);d.precision=l+=10,r=o=c=new d(1),h=0,p++}u=c}}function b(e,t){var r,n,i,o,u,c,l,p,m,d,v,g=1,y=10,x=e,w=x.d,N=x.constructor,E=N.rounding,M=N.precision;if(x.s<0||!w||!w[0]||!x.e&&1==w[0]&&1==w.length)return new N(w&&!w[0]?-1/0:1!=x.s?NaN:w?0:x);if(null==t?(Ne=!1,m=M):m=t,N.precision=m+=y,r=a(w),n=r.charAt(0),!(Math.abs(o=x.e)<15e14))return p=h(N,m+2,M).times(o+""),x=b(new N(n+"."+r.slice(1)),m-y).plus(p),N.precision=M,null==t?f(x,M,E,Ne=!0):x;for(;n<7&&1!=n||1==n&&r.charAt(1)>3;)x=x.times(e),r=a(x.d),n=r.charAt(0),g++;for(o=x.e,n>1?(x=new N("0."+r),o++):x=new N(n+"."+r.slice(1)),d=x,l=u=x=Le(x.minus(1),x.plus(1),m,1),v=f(x.times(x),m,1),i=3;;){if(u=f(u.times(v),m,1),p=l.plus(Le(u,new N(i),m,1)),a(p.d).slice(0,m)===a(l.d).slice(0,m)){if(l=l.times(2),0!==o&&(l=l.plus(h(N,m+2,M).times(o+""))),l=Le(l,new N(g),m,1),null!=t)return N.precision=M,l;if(!s(l.d,m-y,E,c))return f(l,N.precision=M,E,Ne=!0);N.precision=m+=y,p=u=x=Le(d.minus(1),d.plus(1),m,1),v=f(x.times(x),m,1),i=c=1}l=p,i+=2}}function N(e){return String(e.s*e.s/0)}function E(e,t){var r,n,i;for((r=t.indexOf("."))>-1&&(t=t.replace(".","")),(n=t.search(/e/i))>0?(r<0&&(r=n),r+=+t.slice(n+1),t=t.substring(0,n)):r<0&&(r=t.length),n=0;48===t.charCodeAt(n);n++);for(i=t.length;48===t.charCodeAt(i-1);--i);if(t=t.slice(n,i)){if(i-=n,e.e=r=r-n-1,e.d=[],n=(r+1)%Be,
r<0&&(n+=Be),n<i){for(n&&e.d.push(+t.slice(0,n)),i-=Be;n<i;)e.d.push(+t.slice(n,n+=Be));t=t.slice(n),n=Be-t.length}else n-=i;for(;n--;)t+="0";e.d.push(+t),Ne&&(e.e>e.constructor.maxE?(e.d=null,e.e=NaN):e.e<e.constructor.minE&&(e.e=0,e.d=[0]))}else e.e=0,e.d=[0];return e}function M(e,t){var r,n,i,a,o,s,c,f,l;if("Infinity"===t||"NaN"===t)return+t||(e.s=NaN),e.e=NaN,e.d=null,e;if(Ce.test(t))r=16,t=t.toLowerCase();else if(Se.test(t))r=2;else{if(!ze.test(t))throw Error(Me+t);r=8}for(a=t.search(/p/i),a>0?(c=+t.slice(a+1),t=t.substring(2,a)):t=t.slice(2),a=t.indexOf("."),o=a>=0,n=e.constructor,o&&(t=t.replace(".",""),s=t.length,a=s-a,i=g(n,new n(r),a,2*a)),f=u(t,r,Ie),l=f.length-1,a=l;0===f[a];--a)f.pop();return a<0?new n(0*e.s):(e.e=p(f,l),e.d=f,Ne=!1,o&&(e=Le(e,i,4*s)),c&&(e=e.times(Math.abs(c)<54?Math.pow(2,c):be.pow(2,c))),Ne=!0,e)}function A(e,t){var r,n=t.d.length;if(n<3)return O(e,2,t,t);r=1.4*Math.sqrt(n),r=r>16?16:0|r,t=t.times(Math.pow(5,-r)),t=O(e,2,t,t);for(var i,a=new e(5),o=new e(16),s=new e(20);r--;)i=t.times(t),t=t.times(a.plus(i.times(o.times(i).minus(s))));return t}function O(e,t,r,n,i){var a,o,s,u,c=1,f=e.precision,l=Math.ceil(f/Be);for(Ne=!1,u=r.times(r),s=new e(n);;){if(o=Le(s.times(u),new e(t++*t++),f,1),s=i?n.plus(o):n.minus(o),n=Le(o.times(u),new e(t++*t++),f,1),o=s.plus(n),void 0!==o.d[l]){for(a=l;o.d[a]===s.d[a]&&a--;);if(a==-1)break}a=s,s=n,n=o,o=a,c++}return Ne=!0,o.d.length=l+1,o}function T(e,t){var r,n=t.s<0,i=m(e,e.precision,1),a=i.times(.5);if(t=t.abs(),t.lte(a))return de=n?4:1,t;if(r=t.divToInt(i),r.isZero())de=n?3:2;else{if(t=t.minus(r.times(i)),t.lte(a))return de=y(r)?n?2:3:n?4:1,t;de=y(r)?n?1:4:n?3:2}return t.minus(i).abs()}function _(e,t,r,n){var i,a,s,c,f,p,h,m,d,v=e.constructor,g=void 0!==r;if(g?(o(r,1,ge),void 0===n?n=v.rounding:o(n,0,8)):(r=v.precision,n=v.rounding),e.isFinite()){for(h=l(e),s=h.indexOf("."),g?(i=2,16==t?r=4*r-3:8==t&&(r=3*r-2)):i=t,s>=0&&(h=h.replace(".",""),d=new v(1),d.e=h.length-s,d.d=u(l(d),10,i),d.e=d.d.length),m=u(h,10,i),a=f=m.length;0==m[--f];)m.pop();if(m[0]){if(s<0?a--:(e=new v(e),e.d=m,e.e=a,e=Le(e,d,r,n,0,i),m=e.d,a=e.e,p=me),s=m[r],c=i/2,p=p||void 0!==m[r+1],p=n<4?(void 0!==s||p)&&(0===n||n===(e.s<0?3:2)):s>c||s===c&&(4===n||p||6===n&&1&m[r-1]||n===(e.s<0?8:7)),m.length=r,p)for(;++m[--r]>i-1;)m[r]=0,r||(++a,m.unshift(1));for(f=m.length;!m[f-1];--f);for(s=0,h="";s<f;s++)h+=ye.charAt(m[s]);if(g){if(f>1)if(16==t||8==t){for(s=16==t?4:3,--f;f%s;f++)h+="0";for(m=u(h,i,t),f=m.length;!m[f-1];--f);for(s=1,h="1.";s<f;s++)h+=ye.charAt(m[s])}else h=h.charAt(0)+"."+h.slice(1);h=h+(a<0?"p":"p+")+a}else if(a<0){for(;++a;)h="0"+h;h="0."+h}else if(++a>f)for(a-=f;a--;)h+="0";else a<f&&(h=h.slice(0,a)+"."+h.slice(a))}else h=g?"0p+0":"0";h=(16==t?"0x":2==t?"0b":8==t?"0o":"")+h}else h=N(e);return e.s<0?"-"+h:h}function S(e,t){if(e.length>t)return e.length=t,!0}function C(e){return new this(e).abs()}function z(e){return new this(e).acos()}function k(e){return new this(e).acosh()}function I(e,t){return new this(e).plus(t)}function B(e){return new this(e).asin()}function P(e){return new this(e).asinh()}function R(e){return new this(e).atan()}function U(e){return new this(e).atanh()}function q(e,t){e=new this(e),t=new this(t);var r,n=this.precision,i=this.rounding,a=n+4;return e.s&&t.s?e.d||t.d?!t.d||e.isZero()?(r=t.s<0?m(this,n,i):new this(0),r.s=e.s):!e.d||t.isZero()?(r=m(this,a,1).times(.5),r.s=e.s):t.s<0?(this.precision=a,this.rounding=1,r=this.atan(Le(e,t,a,1)),t=m(this,a,1),this.precision=n,this.rounding=i,r=e.s<0?r.minus(t):r.plus(t)):r=this.atan(Le(e,t,a,1)):(r=m(this,a,1).times(t.s>0?.25:.75),r.s=e.s):r=new this(NaN),r}function L(e){return new this(e).cbrt()}function j(e){return f(e=new this(e),e.e+1,2)}function F(e){if(!e||"object"!=typeof e)throw Error(Ee+"Object expected");var t,r,n,i=["precision",1,ge,"rounding",0,8,"toExpNeg",-ve,0,"toExpPos",0,ve,"maxE",0,ve,"minE",-ve,0,"modulo",0,9];for(t=0;t<i.length;t+=3)if(void 0!==(n=e[r=i[t]])){if(!(Te(n)===n&&n>=i[t+1]&&n<=i[t+2]))throw Error(Me+r+": "+n);this[r]=n}if(void 0!==(n=e[r="crypto"])){if(n!==!0&&n!==!1&&0!==n&&1!==n)throw Error(Me+r+": "+n);if(n){if("undefined"==typeof crypto||!crypto||!crypto.getRandomValues&&!crypto.randomBytes)throw Error(Oe);this[r]=!0}else this[r]=!1}return this}function D(e){return new this(e).cos()}function H(e){return new this(e).cosh()}function $(e){function t(e){var r,n,i,a=this;if(!(a instanceof t))return new t(e);if(a.constructor=t,e instanceof t)return a.s=e.s,a.e=e.e,void(a.d=(e=e.d)?e.slice():e);if(i=typeof e,"number"===i){if(0===e)return a.s=1/e<0?-1:1,a.e=0,void(a.d=[0]);if(e<0?(e=-e,a.s=-1):a.s=1,e===~~e&&e<1e7){for(r=0,n=e;n>=10;n/=10)r++;return a.e=r,void(a.d=[e])}return 0*e!==0?(e||(a.s=NaN),a.e=NaN,void(a.d=null)):E(a,e.toString())}if("string"!==i)throw Error(Me+e);return 45===e.charCodeAt(0)?(e=e.slice(1),a.s=-1):a.s=1,ke.test(e)?E(a,e):M(a,e)}var r,n,i;if(t.prototype=qe,t.ROUND_UP=0,t.ROUND_DOWN=1,t.ROUND_CEIL=2,t.ROUND_FLOOR=3,t.ROUND_HALF_UP=4,t.ROUND_HALF_DOWN=5,t.ROUND_HALF_EVEN=6,t.ROUND_HALF_CEIL=7,t.ROUND_HALF_FLOOR=8,t.EUCLID=9,t.config=t.set=F,t.clone=$,t.abs=C,t.acos=z,t.acosh=k,t.add=I,t.asin=B,t.asinh=P,t.atan=R,t.atanh=U,t.atan2=q,t.cbrt=L,t.ceil=j,t.cos=D,t.cosh=H,t.div=G,t.exp=Z,t.floor=V,t.hypot=W,t.ln=Y,t.log=X,t.log10=Q,t.log2=J,t.max=K,t.min=ee,t.mod=te,t.mul=re,t.pow=ne,t.random=ie,t.round=ae,t.sign=oe,t.sin=se,t.sinh=ue,t.sqrt=ce,t.sub=fe,t.tan=le,t.tanh=pe,t.trunc=he,void 0===e&&(e={}),e)for(i=["precision","rounding","toExpNeg","toExpPos","maxE","minE","modulo","crypto"],r=0;r<i.length;)e.hasOwnProperty(n=i[r++])||(e[n]=this[n]);return t.config(e),t}function G(e,t){return new this(e).div(t)}function Z(e){return new this(e).exp()}function V(e){return f(e=new this(e),e.e+1,3)}function W(){var e,t,r=new this(0);for(Ne=!1,e=0;e<arguments.length;)if(t=new this(arguments[e++]),t.d)r.d&&(r=r.plus(t.times(t)));else{if(t.s)return Ne=!0,new this(1/0);r=t}return Ne=!0,r.sqrt()}function Y(e){return new this(e).ln()}function X(e,t){return new this(e).log(t)}function J(e){return new this(e).log(2)}function Q(e){return new this(e).log(10)}function K(){return x(this,arguments,"lt")}function ee(){return x(this,arguments,"gt")}function te(e,t){return new this(e).mod(t)}function re(e,t){return new this(e).mul(t)}function ne(e,t){return new this(e).pow(t)}function ie(e){var t,r,n,i,a=0,s=new this(1),u=[];if(void 0===e?e=this.precision:o(e,1,ge),n=Math.ceil(e/Be),this.crypto)if(crypto.getRandomValues)for(t=crypto.getRandomValues(new Uint32Array(n));a<n;)i=t[a],i>=429e7?t[a]=crypto.getRandomValues(new Uint32Array(1))[0]:u[a++]=i%1e7;else{if(!crypto.randomBytes)throw Error(Oe);for(t=crypto.randomBytes(n*=4);a<n;)i=t[a]+(t[a+1]<<8)+(t[a+2]<<16)+((127&t[a+3])<<24),i>=214e7?crypto.randomBytes(4).copy(t,a):(u.push(i%1e7),a+=4);a=n/4}else for(;a<n;)u[a++]=1e7*Math.random()|0;for(n=u[--a],e%=Be,n&&e&&(i=_e(10,Be-e),u[a]=(n/i|0)*i);0===u[a];a--)u.pop();if(a<0)r=0,u=[0];else{for(r=-1;0===u[0];r-=Be)u.shift();for(n=1,i=u[0];i>=10;i/=10)n++;n<Be&&(r-=Be-n)}return s.e=r,s.d=u,s}function ae(e){return f(e=new this(e),e.e+1,this.rounding)}function oe(e){return e=new this(e),e.d?e.d[0]?e.s:0*e.s:e.s||NaN}function se(e){return new this(e).sin()}function ue(e){return new this(e).sinh()}function ce(e){return new this(e).sqrt()}function fe(e,t){return new this(e).sub(t)}function le(e){return new this(e).tan()}function pe(e){return new this(e).tanh()}function he(e){return f(e=new this(e),e.e+1,1)}var me,de,ve=9e15,ge=1e9,ye="0123456789abcdef",xe="2.3025850929940456840179914546843642076011014886287729760333279009675726096773524802359972050895982983419677840422862486334095254650828067566662873690987816894829072083255546808437998948262331985283935053089653777326288461633662222876982198867465436674744042432743651550489343149393914796194044002221051017141748003688084012647080685567743216228355220114804663715659121373450747856947683463616792101806445070648000277502684916746550586856935673420670581136429224554405758925724208241314695689016758940256776311356919292033376587141660230105703089634572075440370847469940168269282808481184289314848524948644871927809676271275775397027668605952496716674183485704422507197965004714951050492214776567636938662976979522110718264549734772662425709429322582798502585509785265383207606726317164309505995087807523710333101197857547331541421808427543863591778117054309827482385045648019095610299291824318237525357709750539565187697510374970888692180205189339507238539205144634197265287286965110862571492198849978748873771345686209167058",we="3.1415926535897932384626433832795028841971693993751058209749445923078164062862089986280348253421170679821480865132823066470938446095505822317253594081284811174502841027019385211055596446229489549303819644288109756659334461284756482337867831652712019091456485669234603486104543266482133936072602491412737245870066063155881748815209209628292540917153643678925903600113305305488204665213841469519415116094330572703657595919530921861173819326117931051185480744623799627495673518857527248912279381830119491298336733624406566430860213949463952247371907021798609437027705392171762931767523846748184676694051320005681271452635608277857713427577896091736371787214684409012249534301465495853710507922796892589235420199561121290219608640344181598136297747713099605187072113499999983729780499510597317328160963185950244594553469083026425223082533446850352619311881710100031378387528865875332083814206171776691473035982534904287554687311595628638823537875937519577818577805321712268066130019278766111959092164201989380952572010654858632789",be={precision:20,rounding:4,modulo:1,toExpNeg:-7,toExpPos:21,minE:-ve,maxE:ve,crypto:!1},Ne=!0,Ee="[DecimalError] ",Me=Ee+"Invalid argument: ",Ae=Ee+"Precision limit exceeded",Oe=Ee+"crypto unavailable",Te=Math.floor,_e=Math.pow,Se=/^0b([01]+(\.[01]*)?|\.[01]+)(p[+-]?\d+)?$/i,Ce=/^0x([0-9a-f]+(\.[0-9a-f]*)?|\.[0-9a-f]+)(p[+-]?\d+)?$/i,ze=/^0o([0-7]+(\.[0-7]*)?|\.[0-7]+)(p[+-]?\d+)?$/i,ke=/^(\d+(\.\d*)?|\.\d+)(e[+-]?\d+)?$/i,Ie=1e7,Be=7,Pe=9007199254740991,Re=xe.length-1,Ue=we.length-1,qe={};qe.absoluteValue=qe.abs=function(){var e=new this.constructor(this);return e.s<0&&(e.s=1),f(e)},qe.ceil=function(){return f(new this.constructor(this),this.e+1,2)},qe.comparedTo=qe.cmp=function(e){var t,r,n,i,a=this,o=a.d,s=(e=new a.constructor(e)).d,u=a.s,c=e.s;if(!o||!s)return u&&c?u!==c?u:o===s?0:!o^u<0?1:-1:NaN;if(!o[0]||!s[0])return o[0]?u:s[0]?-c:0;if(u!==c)return u;if(a.e!==e.e)return a.e>e.e^u<0?1:-1;for(n=o.length,i=s.length,t=0,r=n<i?n:i;t<r;++t)if(o[t]!==s[t])return o[t]>s[t]^u<0?1:-1;return n===i?0:n>i^u<0?1:-1},qe.cosine=qe.cos=function(){var e,t,r=this,n=r.constructor;return r.d?r.d[0]?(e=n.precision,t=n.rounding,n.precision=e+Math.max(r.e,r.sd())+Be,n.rounding=1,r=c(n,T(n,r)),n.precision=e,n.rounding=t,f(2==de||3==de?r.neg():r,e,t,!0)):new n(1):new n(NaN)},qe.cubeRoot=qe.cbrt=function(){var e,t,r,n,i,o,s,u,c,l,p=this,h=p.constructor;if(!p.isFinite()||p.isZero())return new h(p);for(Ne=!1,o=p.s*Math.pow(p.s*p,1/3),o&&Math.abs(o)!=1/0?n=new h(o.toString()):(r=a(p.d),e=p.e,(o=(e-r.length+1)%3)&&(r+=1==o||o==-2?"0":"00"),o=Math.pow(r,1/3),e=Te((e+1)/3)-(e%3==(e<0?-1:2)),o==1/0?r="5e"+e:(r=o.toExponential(),r=r.slice(0,r.indexOf("e")+1)+e),n=new h(r),n.s=p.s),s=(e=h.precision)+3;;)if(u=n,c=u.times(u).times(u),l=c.plus(p),n=Le(l.plus(p).times(u),l.plus(c),s+2,1),a(u.d).slice(0,s)===(r=a(n.d)).slice(0,s)){if(r=r.slice(s-3,s+1),"9999"!=r&&(i||"4999"!=r)){+r&&(+r.slice(1)||"5"!=r.charAt(0))||(f(n,e+1,1),t=!n.times(n).times(n).eq(p));break}if(!i&&(f(u,e+1,0),u.times(u).times(u).eq(p))){n=u;break}s+=4,i=1}return Ne=!0,f(n,e,h.rounding,t)},qe.decimalPlaces=qe.dp=function(){var e,t=this.d,r=NaN;if(t){if(e=t.length-1,r=(e-Te(this.e/Be))*Be,e=t[e])for(;e%10==0;e/=10)r--;r<0&&(r=0)}return r},qe.dividedBy=qe.div=function(e){return Le(this,new this.constructor(e))},qe.dividedToIntegerBy=qe.divToInt=function(e){var t=this,r=t.constructor;return f(Le(t,new r(e),0,1,1),r.precision,r.rounding)},qe.equals=qe.eq=function(e){return 0===this.cmp(e)},qe.floor=function(){return f(new this.constructor(this),this.e+1,3)},qe.greaterThan=qe.gt=function(e){return this.cmp(e)>0},qe.greaterThanOrEqualTo=qe.gte=function(e){var t=this.cmp(e);return 1==t||0===t},qe.hyperbolicCosine=qe.cosh=function(){var e,t,r,n,i,a=this,o=a.constructor,s=new o(1);if(!a.isFinite())return new o(a.s?1/0:NaN);if(a.isZero())return s;r=o.precision,n=o.rounding,o.precision=r+Math.max(a.e,a.sd())+4,o.rounding=1,i=a.d.length,i<32?(e=Math.ceil(i/3),t=Math.pow(4,-e).toString()):(e=16,t="2.3283064365386962890625e-10"),a=O(o,1,a.times(t),new o(1),!0);for(var u,c=e,l=new o(8);c--;)u=a.times(a),a=s.minus(u.times(l.minus(u.times(l))));return f(a,o.precision=r,o.rounding=n,!0)},qe.hyperbolicSine=qe.sinh=function(){var e,t,r,n,i=this,a=i.constructor;if(!i.isFinite()||i.isZero())return new a(i);if(t=a.precision,r=a.rounding,a.precision=t+Math.max(i.e,i.sd())+4,a.rounding=1,n=i.d.length,n<3)i=O(a,2,i,i,!0);else{e=1.4*Math.sqrt(n),e=e>16?16:0|e,i=i.times(Math.pow(5,-e)),i=O(a,2,i,i,!0);for(var o,s=new a(5),u=new a(16),c=new a(20);e--;)o=i.times(i),i=i.times(s.plus(o.times(u.times(o).plus(c))))}return a.precision=t,a.rounding=r,f(i,t,r,!0)},qe.hyperbolicTangent=qe.tanh=function(){var e,t,r=this,n=r.constructor;return r.isFinite()?r.isZero()?new n(r):(e=n.precision,t=n.rounding,n.precision=e+7,n.rounding=1,Le(r.sinh(),r.cosh(),n.precision=e,n.rounding=t)):new n(r.s)},qe.inverseCosine=qe.acos=function(){var e,t=this,r=t.constructor,n=t.abs().cmp(1),i=r.precision,a=r.rounding;return n!==-1?0===n?t.isNeg()?m(r,i,a):new r(0):new r(NaN):t.isZero()?m(r,i+4,a).times(.5):(r.precision=i+6,r.rounding=1,t=t.asin(),e=m(r,i+4,a).times(.5),r.precision=i,r.rounding=a,e.minus(t))},qe.inverseHyperbolicCosine=qe.acosh=function(){var e,t,r=this,n=r.constructor;return r.lte(1)?new n(r.eq(1)?0:NaN):r.isFinite()?(e=n.precision,t=n.rounding,n.precision=e+Math.max(Math.abs(r.e),r.sd())+4,n.rounding=1,Ne=!1,r=r.times(r).minus(1).sqrt().plus(r),Ne=!0,n.precision=e,n.rounding=t,r.ln()):new n(r)},qe.inverseHyperbolicSine=qe.asinh=function(){var e,t,r=this,n=r.constructor;return!r.isFinite()||r.isZero()?new n(r):(e=n.precision,t=n.rounding,n.precision=e+2*Math.max(Math.abs(r.e),r.sd())+6,n.rounding=1,Ne=!1,r=r.times(r).plus(1).sqrt().plus(r),Ne=!0,n.precision=e,n.rounding=t,r.ln())},qe.inverseHyperbolicTangent=qe.atanh=function(){var e,t,r,n,i=this,a=i.constructor;return i.isFinite()?i.e>=0?new a(i.abs().eq(1)?i.s/0:i.isZero()?i:NaN):(e=a.precision,t=a.rounding,n=i.sd(),Math.max(n,e)<2*-i.e-1?f(new a(i),e,t,!0):(a.precision=r=n-i.e,i=Le(i.plus(1),new a(1).minus(i),r+e,1),a.precision=e+4,a.rounding=1,i=i.ln(),a.precision=e,a.rounding=t,i.times(.5))):new a(NaN)},qe.inverseSine=qe.asin=function(){var e,t,r,n,i=this,a=i.constructor;return i.isZero()?new a(i):(t=i.abs().cmp(1),r=a.precision,n=a.rounding,t!==-1?0===t?(e=m(a,r+4,n).times(.5),e.s=i.s,e):new a(NaN):(a.precision=r+6,a.rounding=1,i=i.div(new a(1).minus(i.times(i)).sqrt().plus(1)).atan(),a.precision=r,a.rounding=n,i.times(2)))},qe.inverseTangent=qe.atan=function(){var e,t,r,n,i,a,o,s,u,c=this,l=c.constructor,p=l.precision,h=l.rounding;if(c.isFinite()){if(c.isZero())return new l(c);if(c.abs().eq(1)&&p+4<=Ue)return o=m(l,p+4,h).times(.25),o.s=c.s,o}else{if(!c.s)return new l(NaN);if(p+4<=Ue)return o=m(l,p+4,h).times(.5),o.s=c.s,o}for(l.precision=s=p+10,l.rounding=1,r=Math.min(28,s/Be+2|0),e=r;e;--e)c=c.div(c.times(c).plus(1).sqrt().plus(1));for(Ne=!1,t=Math.ceil(s/Be),n=1,u=c.times(c),o=new l(c),i=c;e!==-1;)if(i=i.times(u),a=o.minus(i.div(n+=2)),i=i.times(u),o=a.plus(i.div(n+=2)),void 0!==o.d[t])for(e=t;o.d[e]===a.d[e]&&e--;);return r&&(o=o.times(2<<r-1)),Ne=!0,f(o,l.precision=p,l.rounding=h,!0)},qe.isFinite=function(){return!!this.d},qe.isInteger=qe.isInt=function(){return!!this.d&&Te(this.e/Be)>this.d.length-2},qe.isNaN=function(){return!this.s},qe.isNegative=qe.isNeg=function(){return this.s<0},qe.isPositive=qe.isPos=function(){return this.s>0},qe.isZero=function(){return!!this.d&&0===this.d[0]},qe.lessThan=qe.lt=function(e){return this.cmp(e)<0},qe.lessThanOrEqualTo=qe.lte=function(e){return this.cmp(e)<1},qe.logarithm=qe.log=function(e){var t,r,n,i,o,u,c,l,p=this,m=p.constructor,d=m.precision,v=m.rounding,g=5;if(null==e)e=new m(10),t=!0;else{if(e=new m(e),r=e.d,e.s<0||!r||!r[0]||e.eq(1))return new m(NaN);t=e.eq(10)}if(r=p.d,p.s<0||!r||!r[0]||p.eq(1))return new m(r&&!r[0]?-1/0:1!=p.s?NaN:r?0:1/0);if(t)if(r.length>1)o=!0;else{for(i=r[0];i%10===0;)i/=10;o=1!==i}if(Ne=!1,c=d+g,u=b(p,c),n=t?h(m,c+10):b(e,c),l=Le(u,n,c,1),s(l.d,i=d,v))do if(c+=10,u=b(p,c),n=t?h(m,c+10):b(e,c),l=Le(u,n,c,1),!o){+a(l.d).slice(i+1,i+15)+1==1e14&&(l=f(l,d+1,0));break}while(s(l.d,i+=10,v));return Ne=!0,f(l,d,v)},qe.minus=qe.sub=function(e){var t,r,n,i,a,o,s,u,c,l,h,m,d=this,v=d.constructor;if(e=new v(e),!d.d||!e.d)return d.s&&e.s?d.d?e.s=-e.s:e=new v(e.d||d.s!==e.s?d:NaN):e=new v(NaN),e;if(d.s!=e.s)return e.s=-e.s,d.plus(e);if(c=d.d,m=e.d,s=v.precision,u=v.rounding,!c[0]||!m[0]){if(m[0])e.s=-e.s;else{if(!c[0])return new v(3===u?-0:0);e=new v(d)}return Ne?f(e,s,u):e}if(r=Te(e.e/Be),l=Te(d.e/Be),c=c.slice(),a=l-r){for(h=a<0,h?(t=c,a=-a,o=m.length):(t=m,r=l,o=c.length),n=Math.max(Math.ceil(s/Be),o)+2,a>n&&(a=n,t.length=1),t.reverse(),n=a;n--;)t.push(0);t.reverse()}else{for(n=c.length,o=m.length,h=n<o,h&&(o=n),n=0;n<o;n++)if(c[n]!=m[n]){h=c[n]<m[n];break}a=0}for(h&&(t=c,c=m,m=t,e.s=-e.s),o=c.length,n=m.length-o;n>0;--n)c[o++]=0;for(n=m.length;n>a;){if(c[--n]<m[n]){for(i=n;i&&0===c[--i];)c[i]=Ie-1;--c[i],c[n]+=Ie}c[n]-=m[n]}for(;0===c[--o];)c.pop();for(;0===c[0];c.shift())--r;return c[0]?(e.d=c,e.e=p(c,r),Ne?f(e,s,u):e):new v(3===u?-0:0)},qe.modulo=qe.mod=function(e){var t,r=this,n=r.constructor;return e=new n(e),!r.d||!e.s||e.d&&!e.d[0]?new n(NaN):!e.d||r.d&&!r.d[0]?f(new n(r),n.precision,n.rounding):(Ne=!1,9==n.modulo?(t=Le(r,e.abs(),0,3,1),t.s*=e.s):t=Le(r,e,0,n.modulo,1),t=t.times(e),Ne=!0,r.minus(t))},qe.naturalExponential=qe.exp=function(){return w(this)},qe.naturalLogarithm=qe.ln=function(){return b(this)},qe.negated=qe.neg=function(){var e=new this.constructor(this);return e.s=-e.s,f(e)},qe.plus=qe.add=function(e){var t,r,n,i,a,o,s,u,c,l,h=this,m=h.constructor;if(e=new m(e),!h.d||!e.d)return h.s&&e.s?h.d||(e=new m(e.d||h.s===e.s?h:NaN)):e=new m(NaN),e;if(h.s!=e.s)return e.s=-e.s,h.minus(e);if(c=h.d,l=e.d,s=m.precision,u=m.rounding,!c[0]||!l[0])return l[0]||(e=new m(h)),Ne?f(e,s,u):e;if(a=Te(h.e/Be),n=Te(e.e/Be),c=c.slice(),i=a-n){for(i<0?(r=c,i=-i,o=l.length):(r=l,n=a,o=c.length),a=Math.ceil(s/Be),o=a>o?a+1:o+1,i>o&&(i=o,r.length=1),r.reverse();i--;)r.push(0);r.reverse()}for(o=c.length,i=l.length,o-i<0&&(i=o,r=l,l=c,c=r),t=0;i;)t=(c[--i]=c[i]+l[i]+t)/Ie|0,c[i]%=Ie;for(t&&(c.unshift(t),++n),o=c.length;0==c[--o];)c.pop();return e.d=c,e.e=p(c,n),Ne?f(e,s,u):e},qe.precision=qe.sd=function(e){var t,r=this;if(void 0!==e&&e!==!!e&&1!==e&&0!==e)throw Error(Me+e);return r.d?(t=d(r.d),e&&r.e+1>t&&(t=r.e+1)):t=NaN,t},qe.round=function(){var e=this,t=e.constructor;return f(new t(e),e.e+1,t.rounding)},qe.sine=qe.sin=function(){var e,t,r=this,n=r.constructor;return r.isFinite()?r.isZero()?new n(r):(e=n.precision,t=n.rounding,n.precision=e+Math.max(r.e,r.sd())+Be,n.rounding=1,r=A(n,T(n,r)),n.precision=e,n.rounding=t,f(de>2?r.neg():r,e,t,!0)):new n(NaN)},qe.squareRoot=qe.sqrt=function(){var e,t,r,n,i,o,s=this,u=s.d,c=s.e,l=s.s,p=s.constructor;if(1!==l||!u||!u[0])return new p(!l||l<0&&(!u||u[0])?NaN:u?s:1/0);for(Ne=!1,l=Math.sqrt(+s),0==l||l==1/0?(t=a(u),(t.length+c)%2==0&&(t+="0"),l=Math.sqrt(t),c=Te((c+1)/2)-(c<0||c%2),l==1/0?t="1e"+c:(t=l.toExponential(),t=t.slice(0,t.indexOf("e")+1)+c),n=new p(t)):n=new p(l.toString()),r=(c=p.precision)+3;;)if(o=n,n=o.plus(Le(s,o,r+2,1)).times(.5),a(o.d).slice(0,r)===(t=a(n.d)).slice(0,r)){if(t=t.slice(r-3,r+1),"9999"!=t&&(i||"4999"!=t)){+t&&(+t.slice(1)||"5"!=t.charAt(0))||(f(n,c+1,1),e=!n.times(n).eq(s));break}if(!i&&(f(o,c+1,0),o.times(o).eq(s))){n=o;break}r+=4,i=1}return Ne=!0,f(n,c,p.rounding,e)},qe.tangent=qe.tan=function(){var e,t,r=this,n=r.constructor;return r.isFinite()?r.isZero()?new n(r):(e=n.precision,t=n.rounding,n.precision=e+10,n.rounding=1,r=r.sin(),r.s=1,r=Le(r,new n(1).minus(r.times(r)).sqrt(),e+10,0),n.precision=e,n.rounding=t,f(2==de||4==de?r.neg():r,e,t,!0)):new n(NaN)},qe.times=qe.mul=function(e){var t,r,n,i,a,o,s,u,c,l=this,h=l.constructor,m=l.d,d=(e=new h(e)).d;if(e.s*=l.s,!(m&&m[0]&&d&&d[0]))return new h(!e.s||m&&!m[0]&&!d||d&&!d[0]&&!m?NaN:m&&d?0*e.s:e.s/0);for(r=Te(l.e/Be)+Te(e.e/Be),u=m.length,c=d.length,u<c&&(a=m,m=d,d=a,o=u,u=c,c=o),a=[],o=u+c,n=o;n--;)a.push(0);for(n=c;--n>=0;){for(t=0,i=u+n;i>n;)s=a[i]+d[n]*m[i-n-1]+t,a[i--]=s%Ie|0,t=s/Ie|0;a[i]=(a[i]+t)%Ie|0}for(;!a[--o];)a.pop();return t?++r:a.shift(),e.d=a,e.e=p(a,r),Ne?f(e,h.precision,h.rounding):e},qe.toBinary=function(e,t){return _(this,2,e,t)},qe.toDecimalPlaces=qe.toDP=function(e,t){var r=this,n=r.constructor;return r=new n(r),void 0===e?r:(o(e,0,ge),void 0===t?t=n.rounding:o(t,0,8),f(r,e+r.e+1,t))},qe.toExponential=function(e,t){var r,n=this,i=n.constructor;return void 0===e?r=l(n,!0):(o(e,0,ge),void 0===t?t=i.rounding:o(t,0,8),n=f(new i(n),e+1,t),r=l(n,!0,e+1)),n.isNeg()&&!n.isZero()?"-"+r:r},qe.toFixed=function(e,t){var r,n,i=this,a=i.constructor;return void 0===e?r=l(i):(o(e,0,ge),void 0===t?t=a.rounding:o(t,0,8),n=f(new a(i),e+i.e+1,t),r=l(n,!1,e+n.e+1)),i.isNeg()&&!i.isZero()?"-"+r:r},qe.toFraction=function(e){var t,r,n,i,o,s,u,c,f,l,p,h,m=this,v=m.d,g=m.constructor;if(!v)return new g(m);if(f=r=new g(1),n=c=new g(0),t=new g(n),o=t.e=d(v)-m.e-1,s=o%Be,t.d[0]=_e(10,s<0?Be+s:s),null==e)e=o>0?t:f;else{if(u=new g(e),!u.isInt()||u.lt(f))throw Error(Me+u);e=u.gt(t)?o>0?t:f:u}for(Ne=!1,u=new g(a(v)),l=g.precision,g.precision=o=v.length*Be*2;p=Le(u,t,0,1,1),i=r.plus(p.times(n)),1!=i.cmp(e);)r=n,n=i,i=f,f=c.plus(p.times(i)),c=i,i=t,t=u.minus(p.times(i)),u=i;return i=Le(e.minus(r),n,0,1,1),c=c.plus(i.times(f)),r=r.plus(i.times(n)),c.s=f.s=m.s,h=Le(f,n,o,1).minus(m).abs().cmp(Le(c,r,o,1).minus(m).abs())<1?[f,n]:[c,r],g.precision=l,Ne=!0,h},qe.toHexadecimal=qe.toHex=function(e,t){return _(this,16,e,t)},qe.toNearest=function(e,t){var r=this,n=r.constructor;if(r=new n(r),null==e){if(!r.d)return r;e=new n(1),t=n.rounding}else{if(e=new n(e),void 0!==t&&o(t,0,8),!r.d)return e.s?r:e;if(!e.d)return e.s&&(e.s=r.s),e}return e.d[0]?(Ne=!1,t<4&&(t=[4,5,7,8][t]),r=Le(r,e,0,t,1).times(e),Ne=!0,f(r)):(e.s=r.s,r=e),r},qe.toNumber=function(){return+this},qe.toOctal=function(e,t){return _(this,8,e,t)},qe.toPower=qe.pow=function(e){var t,r,n,i,o,u,c=this,l=c.constructor,p=+(e=new l(e));if(!(c.d&&e.d&&c.d[0]&&e.d[0]))return new l(_e(+c,p));if(c=new l(c),c.eq(1))return c;if(n=l.precision,o=l.rounding,e.eq(1))return f(c,n,o);if(t=Te(e.e/Be),t>=e.d.length-1&&(r=p<0?-p:p)<=Pe)return i=g(l,c,r,n),e.s<0?new l(1).div(i):f(i,n,o);if(u=c.s,u<0){if(t<e.d.length-1)return new l(NaN);if(0==(1&e.d[t])&&(u=1),0==c.e&&1==c.d[0]&&1==c.d.length)return c.s=u,c}return r=_e(+c,p),t=0!=r&&isFinite(r)?new l(r+"").e:Te(p*(Math.log("0."+a(c.d))/Math.LN10+c.e+1)),t>l.maxE+1||t<l.minE-1?new l(t>0?u/0:0):(Ne=!1,l.rounding=c.s=1,r=Math.min(12,(t+"").length),i=w(e.times(b(c,n+r)),n),i.d&&(i=f(i,n+5,1),s(i.d,n,o)&&(t=n+10,i=f(w(e.times(b(c,t+r)),t),t+5,1),+a(i.d).slice(n+1,n+15)+1==1e14&&(i=f(i,n+1,0)))),i.s=u,Ne=!0,l.rounding=o,f(i,n,o))},qe.toPrecision=function(e,t){var r,n=this,i=n.constructor;return void 0===e?r=l(n,n.e<=i.toExpNeg||n.e>=i.toExpPos):(o(e,1,ge),void 0===t?t=i.rounding:o(t,0,8),n=f(new i(n),e,t),r=l(n,e<=n.e||n.e<=i.toExpNeg,e)),n.isNeg()&&!n.isZero()?"-"+r:r},qe.toSignificantDigits=qe.toSD=function(e,t){var r=this,n=r.constructor;return void 0===e?(e=n.precision,t=n.rounding):(o(e,1,ge),void 0===t?t=n.rounding:o(t,0,8)),f(new n(r),e,t)},qe.toString=function(){var e=this,t=e.constructor,r=l(e,e.e<=t.toExpNeg||e.e>=t.toExpPos);return e.isNeg()&&!e.isZero()?"-"+r:r},qe.truncated=qe.trunc=function(){return f(new this.constructor(this),this.e+1,1)},qe.valueOf=qe.toJSON=function(){var e=this,t=e.constructor,r=l(e,e.e<=t.toExpNeg||e.e>=t.toExpPos);return e.isNeg()?"-"+r:r};var Le=function(){function e(e,t,r){var n,i=0,a=e.length;for(e=e.slice();a--;)n=e[a]*t+i,e[a]=n%r|0,i=n/r|0;return i&&e.unshift(i),e}function t(e,t,r,n){var i,a;if(r!=n)a=r>n?1:-1;else for(i=a=0;i<r;i++)if(e[i]!=t[i]){a=e[i]>t[i]?1:-1;break}return a}function r(e,t,r,n){for(var i=0;r--;)e[r]-=i,i=e[r]<t[r]?1:0,e[r]=i*n+e[r]-t[r];for(;!e[0]&&e.length>1;)e.shift()}return function(n,i,a,o,s,u){var c,l,p,h,m,d,v,g,y,x,w,b,N,E,M,A,O,T,_,S,C=n.constructor,z=n.s==i.s?1:-1,k=n.d,I=i.d;if(!(k&&k[0]&&I&&I[0]))return new C(n.s&&i.s&&(k?!I||k[0]!=I[0]:I)?k&&0==k[0]||!I?0*z:z/0:NaN);for(u?(m=1,l=n.e-i.e):(u=Ie,m=Be,l=Te(n.e/m)-Te(i.e/m)),_=I.length,O=k.length,y=new C(z),x=y.d=[],p=0;I[p]==(k[p]||0);p++);if(I[p]>(k[p]||0)&&l--,null==a?(E=a=C.precision,o=C.rounding):E=s?a+(n.e-i.e)+1:a,E<0)x.push(1),d=!0;else{if(E=E/m+2|0,p=0,1==_){for(h=0,I=I[0],E++;(p<O||h)&&E--;p++)M=h*u+(k[p]||0),x[p]=M/I|0,h=M%I|0;d=h||p<O}else{for(h=u/(I[0]+1)|0,h>1&&(I=e(I,h,u),k=e(k,h,u),_=I.length,O=k.length),A=_,w=k.slice(0,_),b=w.length;b<_;)w[b++]=0;S=I.slice(),S.unshift(0),T=I[0],I[1]>=u/2&&++T;do h=0,c=t(I,w,_,b),c<0?(N=w[0],_!=b&&(N=N*u+(w[1]||0)),h=N/T|0,h>1?(h>=u&&(h=u-1),v=e(I,h,u),g=v.length,b=w.length,c=t(v,w,g,b),1==c&&(h--,r(v,_<g?S:I,g,u))):(0==h&&(c=h=1),v=I.slice()),g=v.length,g<b&&v.unshift(0),r(w,v,b,u),c==-1&&(b=w.length,c=t(I,w,_,b),c<1&&(h++,r(w,_<b?S:I,b,u))),b=w.length):0===c&&(h++,w=[0]),x[p++]=h,c&&w[0]?w[b++]=k[A]||0:(w=[k[A]],b=1);while((A++<O||void 0!==w[0])&&E--);d=void 0!==w[0]}x[0]||x.shift()}if(1==m)y.e=l,me=d;else{for(p=1,h=x[0];h>=10;h/=10)p++;y.e=p+l*m-1,f(y,s?a+y.e+1:a,o,d)}return y}}();be=$(be),xe=new be(xe),we=new be(we),n=function(){return be}.call(t,r,t,e),!(void 0!==n&&(e.exports=n))}(this)},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("bignumber",{"":function(){return new e.BigNumber(0)},number:function(t){return new e.BigNumber(t+"")},string:function(t){return new e.BigNumber(t)},BigNumber:function(e){return e},Fraction:function(t){return new e.BigNumber(t.n).div(t.d)},"Array | Matrix":function(e){return i(e,a)}});return a.toTex={0:"0",1:"\\left(${args[0]}\\right)"},a}var i=r(1);t.name="bignumber",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("bool",{"":function(){return!1},boolean:function(e){return e},number:function(e){return!!e},BigNumber:function(e){return!e.isZero()},string:function(e){var t=e.toLowerCase();if("true"===t)return!0;if("false"===t)return!1;var r=Number(e);if(""!=e&&!isNaN(r))return!!r;throw new Error('Cannot convert "'+e+'" to a boolean')},"Array | Matrix":function(e){return i(e,a)}});return a}var i=r(1);t.name="boolean",t.factory=n},function(e,t,r){e.exports=[r(164),r(166)]},function(e,t,r){"use strict";function n(e,t,r,n,o){function s(t){if(!(this instanceof s))throw new SyntaxError("Constructor must be called with the new operator");e.isChain(t)?this.value=t.value:this.value=t}function u(e,t){"function"==typeof t&&(s.prototype[e]=f(t))}function c(e,t){a(s.prototype,e,function(){var e=t();if("function"==typeof e)return f(e)})}function f(e){return function(){for(var t=[this.value],r=0;r<arguments.length;r++)t[r+1]=arguments[r];return new s(e.apply(e,t))}}return s.prototype.type="Chain",s.prototype.isChain=!0,s.prototype.done=function(){return this.value},s.prototype.valueOf=function(){return this.value},s.prototype.toString=function(){return i(this.value)},s.createProxy=function(e,t){if("string"==typeof e)u(e,t);else for(var r in e)e.hasOwnProperty(r)&&u(r,e[r])},s.createProxy(o),o.on("import",function(e,t,r){void 0===r&&c(e,t)}),s}var i=r(9).format,a=r(5).lazy;t.name="Chain",t.path="type",t.factory=n,t.math=!0,t.lazy=!1},function(e,t){t.format=function(e,r){if("function"==typeof r)return r(e);if(!e.isFinite())return e.isNaN()?"NaN":e.gt(0)?"Infinity":"-Infinity";var n="auto",i=void 0;switch(void 0!==r&&(r.notation&&(n=r.notation),"number"==typeof r?i=r:r.precision&&(i=r.precision)),n){case"fixed":return t.toFixed(e,i);case"exponential":return t.toExponential(e,i);case"auto":var a=.001,o=1e5;r&&r.exponential&&(void 0!==r.exponential.lower&&(a=r.exponential.lower),void 0!==r.exponential.upper&&(o=r.exponential.upper));({toExpNeg:e.constructor.toExpNeg,toExpPos:e.constructor.toExpPos});if(e.constructor.config({toExpNeg:Math.round(Math.log(a)/Math.LN10),toExpPos:Math.round(Math.log(o)/Math.LN10)}),e.isZero())return"0";var s,u=e.abs();return s=u.gte(a)&&u.lt(o)?e.toSignificantDigits(i).toFixed():t.toExponential(e,i),s.replace(/((\.\d*?)(0+))($|e)/,function(){var e=arguments[2],t=arguments[4];return"."!==e?e+t:t});default:throw new Error('Unknown notation "'+n+'". Choose "auto", "exponential", or "fixed".')}},t.toExponential=function(e,t){return void 0!==t?e.toExponential(t-1):e.toExponential()},t.toFixed=function(e,t){return e.toFixed(t||0)}},function(e,t,r){"use strict";function n(e,t,r,n){return n("chain",{"":function(){return new e.Chain},any:function(t){return new e.Chain(t)}})}t.name="chain",t.factory=n},function(e,t,r){e.exports=[r(91),r(169)]},function(e,t,r){var n,i;/**
 * @license Complex.js v2.0.3 11/02/2016
 *
 * Copyright (c) 2016, Robert Eisele (robert@xarg.org)
 * Dual licensed under the MIT or GPL Version 2 licenses.
 **/
!function(r){"use strict";function a(e,t){var r=Math.abs(e),n=Math.abs(t);return 0===e?Math.log(n):0===t?Math.log(r):r<3e3&&n<3e3?.5*Math.log(e*e+t*t):Math.log(e/Math.cos(Math.atan2(t,e)))}function o(e,t){return this instanceof o?(p(e,t),this.re=s.re,void(this.im=s.im)):new o(e,t)}var s={re:0,im:0},u=function(e){return.5*(Math.exp(e)+Math.exp(-e))},c=function(e){return.5*(Math.exp(e)-Math.exp(-e))},f=function(e,t){var r=Math.abs(e),n=Math.abs(t);return r<3e3&&n<3e3?Math.sqrt(r*r+n*n):(r<n?(r=n,n=e/t):n=t/e,r*Math.sqrt(1+n*n))},l=function(){throw SyntaxError("Invalid Param")},p=function(e,t){if(void 0===e||null===e)s.re=s.im=0;else if(void 0!==t)s.re=e,s.im=t;else switch(typeof e){case"object":"im"in e&&"re"in e?(s.re=e.re,s.im=e.im):"abs"in e&&"arg"in e?(s.re=e.abs*Math.cos(e.arg),s.im=e.abs*Math.sin(e.arg)):"r"in e&&"phi"in e?(s.re=e.r*Math.cos(e.phi),s.im=e.r*Math.sin(e.phi)):2===e.length?(s.re=e[0],s.im=e[1]):l();break;case"string":s.im=s.re=0;var r=e.match(/\d+\.?\d*e[+-]?\d+|\d+\.?\d*|\.\d+|./g),n=1,i=0;null===r&&l();for(var a=0;a<r.length;a++){var o=r[a];" "===o||"\t"===o||"\n"===o||("+"===o?n++:"-"===o?i++:"i"===o||"I"===o?(n+i===0&&l()," "===r[a+1]||isNaN(r[a+1])?s.im+=parseFloat((i%2?"-":"")+"1"):(s.im+=parseFloat((i%2?"-":"")+r[a+1]),a++),n=i=0):((n+i===0||isNaN(o))&&l(),"i"===r[a+1]||"I"===r[a+1]?(s.im+=parseFloat((i%2?"-":"")+o),a++):s.re+=parseFloat((i%2?"-":"")+o),n=i=0))}n+i>0&&l();break;case"number":s.im=0,s.re=e;break;default:l()}isNaN(s.re)||isNaN(s.im)};o.prototype={re:0,im:0,sign:function(){var e=this.abs();return new o(this.re/e,this.im/e)},add:function(e,t){return p(e,t),new o(this.re+s.re,this.im+s.im)},sub:function(e,t){return p(e,t),new o(this.re-s.re,this.im-s.im)},mul:function(e,t){return p(e,t),0===s.im&&0===this.im?new o(this.re*s.re,0):new o(this.re*s.re-this.im*s.im,this.re*s.im+this.im*s.re)},div:function(e,t){p(e,t),e=this.re,t=this.im;var r,n,i=s.re,a=s.im;return 0===a?0===i?new o(0!==e?e/0:0,0!==t?t/0:0):new o(e/i,t/i):Math.abs(i)<Math.abs(a)?(n=i/a,r=i*n+a,new o((e*n+t)/r,(t*n-e)/r)):(n=a/i,r=a*n+i,new o((e+t*n)/r,(t-e*n)/r))},pow:function(e,t){if(p(e,t),e=this.re,t=this.im,0===e&&0===t)return o.ZERO;if(0===s.im){if(0===t&&e>=0)return new o(Math.pow(e,s.re),0);if(0===e)switch((s.re%4+4)%4){case 0:return new o(Math.pow(t,s.re),0);case 1:return new o(0,Math.pow(t,s.re));case 2:return new o(-Math.pow(t,s.re),0);case 3:return new o(0,-Math.pow(t,s.re))}}var r=Math.atan2(t,e),n=a(e,t);return e=Math.exp(s.re*n-s.im*r),t=s.im*n+s.re*r,new o(e*Math.cos(t),e*Math.sin(t))},sqrt:function(){var e,t,r=this.re,n=this.im,i=this.abs();if(r>=0){if(0===n)return new o(Math.sqrt(r),0);e=.5*Math.sqrt(2*(i+r))}else e=Math.abs(n)/Math.sqrt(2*(i-r));return t=r<=0?.5*Math.sqrt(2*(i-r)):Math.abs(n)/Math.sqrt(2*(i+r)),new o(e,n<0?-t:t)},exp:function(){var e=Math.exp(this.re);return 0===this.im,new o(e*Math.cos(this.im),e*Math.sin(this.im))},log:function(){var e=this.re,t=this.im;return new o(a(e,t),Math.atan2(t,e))},abs:function(){return f(this.re,this.im)},arg:function(){return Math.atan2(this.im,this.re)},sin:function(){var e=this.re,t=this.im;return new o(Math.sin(e)*u(t),Math.cos(e)*c(t))},cos:function(){var e=this.re,t=this.im;return new o(Math.cos(e)*u(t),-Math.sin(e)*c(t))},tan:function(){var e=2*this.re,t=2*this.im,r=Math.cos(e)+u(t);return new o(Math.sin(e)/r,c(t)/r)},cot:function(){var e=2*this.re,t=2*this.im,r=Math.cos(e)-u(t);return new o(-Math.sin(e)/r,c(t)/r)},sec:function(){var e=this.re,t=this.im,r=.5*u(2*t)+.5*Math.cos(2*e);return new o(Math.cos(e)*u(t)/r,Math.sin(e)*c(t)/r)},csc:function(){var e=this.re,t=this.im,r=.5*u(2*t)-.5*Math.cos(2*e);return new o(Math.sin(e)*u(t)/r,-Math.cos(e)*c(t)/r)},asin:function(){var e=this.re,t=this.im,r=new o(t*t-e*e+1,-2*e*t).sqrt(),n=new o(r.re-t,r.im+e).log();return new o(n.im,-n.re)},acos:function(){var e=this.re,t=this.im,r=new o(t*t-e*e+1,-2*e*t).sqrt(),n=new o(r.re-t,r.im+e).log();return new o(Math.PI/2-n.im,n.re)},atan:function(){var e=this.re,t=this.im;if(0===e){if(1===t)return new o(0,1/0);if(t===-1)return new o(0,-(1/0))}var r=e*e+(1-t)*(1-t),n=new o((1-t*t-e*e)/r,-2*e/r).log();return new o(-.5*n.im,.5*n.re)},acot:function(){var e=this.re,t=this.im;if(0===t)return new o(Math.atan2(1,e),0);var r=e*e+t*t;return 0!==r?new o(e/r,-t/r).atan():new o(0!==e?e/0:0,0!==t?-t/0:0).atan()},asec:function(){var e=this.re,t=this.im;if(0===e&&0===t)return new o(0,1/0);var r=e*e+t*t;return 0!==r?new o(e/r,-t/r).acos():new o(0!==e?e/0:0,0!==t?-t/0:0).acos()},acsc:function(){var e=this.re,t=this.im;if(0===e&&0===t)return new o(Math.PI/2,1/0);var r=e*e+t*t;return 0!==r?new o(e/r,-t/r).asin():new o(0!==e?e/0:0,0!==t?-t/0:0).asin()},sinh:function(){var e=this.re,t=this.im;return new o(c(e)*Math.cos(t),u(e)*Math.sin(t))},cosh:function(){var e=this.re,t=this.im;return new o(u(e)*Math.cos(t),c(e)*Math.sin(t))},tanh:function(){var e=2*this.re,t=2*this.im,r=u(e)+Math.cos(t);return new o(c(e)/r,Math.sin(t)/r)},coth:function(){var e=2*this.re,t=2*this.im,r=u(e)-Math.cos(t);return new o(c(e)/r,-Math.sin(t)/r)},csch:function(){var e=this.re,t=this.im,r=Math.cos(2*t)-u(2*e);return new o(-2*c(e)*Math.cos(t)/r,2*u(e)*Math.sin(t)/r)},sech:function(){var e=this.re,t=this.im,r=Math.cos(2*t)+u(2*e);return new o(2*u(e)*Math.cos(t)/r,-2*c(e)*Math.sin(t)/r)},asinh:function(){var e=this.im;this.im=-this.re,this.re=e;var t=this.asin();return this.re=-this.im,this.im=e,e=t.re,t.re=-t.im,t.im=e,t},acosh:function(){var e,t=this.acos();return t.im<=0?(e=t.re,t.re=-t.im,t.im=e):(e=t.im,t.im=-t.re,t.re=e),t},atanh:function(){var e=this.re,t=this.im,r=e>1&&0===t,n=1-e,i=1+e,s=n*n+t*t,u=0!==s?new o((i*n-t*t)/s,(t*n+i*t)/s):new o(e!==-1?e/0:0,0!==t?t/0:0),c=u.re;return u.re=a(u.re,u.im)/2,u.im=Math.atan2(u.im,c)/2,r&&(u.im=-u.im),u},acoth:function(){var e=this.re,t=this.im;if(0===e&&0===t)return new o(0,Math.PI/2);var r=e*e+t*t;return 0!==r?new o(e/r,-t/r).atanh():new o(0!==e?e/0:0,0!==t?-t/0:0).atanh()},acsch:function(){var e=this.re,t=this.im;if(0===t)return new o(0!==e?Math.log(e+Math.sqrt(e*e+1)):1/0,0);var r=e*e+t*t;return 0!==r?new o(e/r,-t/r).asinh():new o(0!==e?e/0:0,0!==t?-t/0:0).asinh()},asech:function(){var e=this.re,t=this.im;if(0===e&&0===t)return new o(1/0,0);var r=e*e+t*t;return 0!==r?new o(e/r,-t/r).acosh():new o(0!==e?e/0:0,0!==t?-t/0:0).acosh()},inverse:function(){var e=this.re,t=this.im,r=e*e+t*t;return new o(0!==e?e/r:0,0!==t?-t/r:0)},conjugate:function(){return new o(this.re,-this.im)},neg:function(){return new o(-this.re,-this.im)},ceil:function(e){return e=Math.pow(10,e||0),new o(Math.ceil(this.re*e)/e,Math.ceil(this.im*e)/e)},floor:function(e){return e=Math.pow(10,e||0),new o(Math.floor(this.re*e)/e,Math.floor(this.im*e)/e)},round:function(e){return e=Math.pow(10,e||0),new o(Math.round(this.re*e)/e,Math.round(this.im*e)/e)},equals:function(e,t){return p(e,t),Math.abs(s.re-this.re)<=o.EPSILON&&Math.abs(s.im-this.im)<=o.EPSILON},clone:function(){return new o(this.re,this.im)},toString:function(){var e=this.re,t=this.im,r="";return isNaN(e)||isNaN(t)?"NaN":(0!==e&&(r+=e),0!==t&&(0!==e?r+=t<0?" - ":" + ":t<0&&(r+="-"),t=Math.abs(t),1!==t&&(r+=t),r+="i"),r?r:"0")},toVector:function(){return[this.re,this.im]},valueOf:function(){return 0===this.im?this.re:null},isNaN:function(){return isNaN(this.re)||isNaN(this.im)},isFinite:function(){return isFinite(this.re)&&isFinite(this.im)}},o.ZERO=new o(0,0),o.ONE=new o(1,0),o.I=new o(0,1),o.PI=new o(Math.PI,0),o.E=new o(Math.E,0),o.EPSILON=1e-16,n=[],i=function(){return o}.apply(t,n),!(void 0!==i&&(e.exports=i))}(this)},function(e,t,r){"use strict";function n(e,t,n,a){var o=r(4),s=a("complex",{"":function(){return e.Complex.ZERO},number:function(t){return new e.Complex(t,0)},"number, number":function(t,r){return new e.Complex(t,r)},"BigNumber, BigNumber":function(t,r){return new e.Complex(t.toNumber(),r.toNumber())},Complex:function(e){return e.clone()},string:function(t){return e.Complex(t)},Object:function(t){if("re"in t&&"im"in t)return new e.Complex(t.re,t.im);if("r"in t&&"phi"in t)return new e.Complex(t);throw new Error("Expected object with either properties re and im, or properties r and phi.")},"Array | Matrix":function(e){return i(e,s)}});return s.toTex={0:"0",1:"\\left(${args[0]}\\right)",2:"\\left(\\left(${args[0]}\\right)+"+o.symbols.i+"\\cdot\\left(${args[1]}\\right)\\right)"},s}var i=r(1);t.name="complex",t.factory=n},function(e,t,r){e.exports=[r(171),r(92)]},function(e,t,r){function n(e,t,r,n){return i}var i=r(172);i.prototype.type="Fraction",i.prototype.isFraction=!0,i.prototype.toJSON=function(){return{mathjs:"Fraction",n:this.s*this.n,d:this.d}},i.fromJSON=function(e){return new i(e)},t.name="Fraction",t.path="type",t.factory=n},function(e,t,r){var n,i;/**
 * @license Fraction.js v4.0.2 09/09/2015
 * http://www.xarg.org/2014/03/rational-numbers-in-javascript/
 *
 * Copyright (c) 2015, Robert Eisele (robert@xarg.org)
 * Dual licensed under the MIT or GPL Version 2 licenses.
 **/
!function(r){"use strict";function a(e){var t=function(){var t=Error.apply(this,arguments);t.name=this.name=e,this.stack=t.stack,this.message=t.message},r=function(){};return r.prototype=Error.prototype,t.prototype=new r,t}function o(e,t){return isNaN(e=parseInt(e,10))&&s(),e*t}function s(){throw new p}function u(e,t){return this instanceof u?(h(e,t),e=u.REDUCE?g(f.d,f.n):1,this.s=f.s,this.n=f.n/e,void(this.d=f.d/e)):new u(e,t)}var c=2e3,f={s:1,n:0,d:1},l=u.DivisionByZero=a("DivisionByZero"),p=u.InvalidParameter=a("InvalidParameter"),h=function(e,t){var r,n=0,i=1,a=1,u=0,c=0,p=0,h=1,m=1,d=0,v=1,g=1,y=1,x=1e7;if(void 0===e||null===e);else if(void 0!==t)n=e,i=t,a=n*i;else switch(typeof e){case"object":"d"in e&&"n"in e?(n=e.n,i=e.d,"s"in e&&(n*=e.s)):0 in e?(n=e[0],1 in e&&(i=e[1])):s(),a=n*i;break;case"number":if(e<0&&(a=e,e=-e),e%1===0)n=e;else if(e>0){for(e>=1&&(m=Math.pow(10,Math.floor(1+Math.log(e)/Math.LN10)),e/=m);v<=x&&y<=x;){if(r=(d+g)/(v+y),e===r){v+y<=x?(n=d+g,i=v+y):y>v?(n=g,i=y):(n=d,i=v);break}e>r?(d+=g,v+=y):(g+=d,y+=v),v>x?(n=g,i=y):(n=d,i=v)}n*=m}else(isNaN(e)||isNaN(t))&&(i=n=NaN);break;case"string":if(v=e.match(/\d+|./g),"-"===v[d]?(a=-1,d++):"+"===v[d]&&d++,v.length===d+1?c=o(v[d++],a):"."===v[d+1]||"."===v[d]?("."!==v[d]&&(u=o(v[d++],a)),d++,(d+1===v.length||"("===v[d+1]&&")"===v[d+3]||"'"===v[d+1]&&"'"===v[d+3])&&(c=o(v[d],a),h=Math.pow(10,v[d].length),d++),("("===v[d]&&")"===v[d+2]||"'"===v[d]&&"'"===v[d+2])&&(p=o(v[d+1],a),m=Math.pow(10,v[d+1].length)-1,d+=3)):"/"===v[d+1]||":"===v[d+1]?(c=o(v[d],a),h=o(v[d+2],1),d+=3):"/"===v[d+3]&&" "===v[d+1]&&(u=o(v[d],a),c=o(v[d+2],a),h=o(v[d+4],1),d+=5),v.length<=d){i=h*m,a=n=p+i*u+m*c;break}default:s()}if(0===i)throw new l;f.s=a<0?-1:1,f.n=Math.abs(n),f.d=Math.abs(i)},m=function(e,t,r){for(var n=1;t>0;e=e*e%r,t>>=1)1&t&&(n=n*e%r);return n},d=function(e,t){for(;t%2===0;t/=2);for(;t%5===0;t/=5);if(1===t)return 0;for(var r=10%t,n=1;1!==r;n++)if(r=10*r%t,n>c)return 0;return n},v=function(e,t,r){for(var n=1,i=m(10,r,t),a=0;a<300;a++){if(n===i)return a;n=10*n%t,i=10*i%t}return 0},g=function(e,t){if(!e)return t;if(!t)return e;for(;;){if(e%=t,!e)return t;if(t%=e,!t)return e}};u.REDUCE=1,u.prototype={s:1,n:0,d:1,abs:function(){return new u(this.n,this.d)},neg:function(){return new u(-this.s*this.n,this.d)},add:function(e,t){return h(e,t),new u(this.s*this.n*f.d+f.s*this.d*f.n,this.d*f.d)},sub:function(e,t){return h(e,t),new u(this.s*this.n*f.d-f.s*this.d*f.n,this.d*f.d)},mul:function(e,t){return h(e,t),new u(this.s*f.s*this.n*f.n,this.d*f.d)},div:function(e,t){return h(e,t),new u(this.s*f.s*this.n*f.d,this.d*f.n)},clone:function(){return new u(this)},mod:function(e,t){return isNaN(this.n)||isNaN(this.d)?new u(NaN):void 0===e?new u(this.s*this.n%this.d,1):(h(e,t),0===f.n&&0===this.d&&u(0,0),new u(this.s*f.d*this.n%(f.n*this.d),f.d*this.d))},gcd:function(e,t){return h(e,t),new u(g(f.n,this.n),f.d*this.d/g(f.d,this.d))},lcm:function(e,t){return h(e,t),0===f.n&&0===this.n?new u:new u(f.n*this.n/g(f.n,this.n),g(f.d,this.d))},ceil:function(e){return e=Math.pow(10,e||0),isNaN(this.n)||isNaN(this.d)?new u(NaN):new u(Math.ceil(e*this.s*this.n/this.d),e)},floor:function(e){return e=Math.pow(10,e||0),isNaN(this.n)||isNaN(this.d)?new u(NaN):new u(Math.floor(e*this.s*this.n/this.d),e)},round:function(e){return e=Math.pow(10,e||0),isNaN(this.n)||isNaN(this.d)?new u(NaN):new u(Math.round(e*this.s*this.n/this.d),e)},inverse:function(){return new u(this.s*this.d,this.n)},pow:function(e){return e<0?new u(Math.pow(this.s*this.d,-e),Math.pow(this.n,-e)):new u(Math.pow(this.s*this.n,e),Math.pow(this.d,e))},equals:function(e,t){return h(e,t),this.s*this.n*f.d===f.s*f.n*this.d},compare:function(e,t){h(e,t);var r=this.s*this.n*f.d-f.s*f.n*this.d;return(0<r)-(r<0)},divisible:function(e,t){return h(e,t),!(!(f.n*this.d)||this.n*f.d%(f.n*this.d))},valueOf:function(){return this.s*this.n/this.d},toFraction:function(e){var t,r="",n=this.n,i=this.d;return this.s<0&&(r+="-"),1===i?r+=n:(e&&(t=Math.floor(n/i))>0&&(r+=t,r+=" ",n%=i),r+=n,r+="/",r+=i),r},toLatex:function(e){var t,r="",n=this.n,i=this.d;return this.s<0&&(r+="-"),1===i?r+=n:(e&&(t=Math.floor(n/i))>0&&(r+=t,n%=i),r+="\\frac{",r+=n,r+="}{",r+=i,r+="}"),r},toContinued:function(){var e,t=this.n,r=this.d,n=[];do n.push(Math.floor(t/r)),e=t%r,t=r,r=e;while(1!==t);return n},toString:function(){var e,t=this.n,r=this.d;if(isNaN(t)||isNaN(r))return"NaN";u.REDUCE||(e=g(t,r),t/=e,r/=e);var n=15,i=d(t,r),a=v(t,r,i),o=this.s===-1?"-":"";if(o+=t/r|0,t%=r,t*=10,t&&(o+="."),i){for(var s=a;s--;)o+=t/r|0,t%=r,t*=10;o+="(";for(var s=i;s--;)o+=t/r|0,t%=r,t*=10;o+=")"}else for(var s=n;t&&s--;)o+=t/r|0,t%=r,t*=10;return o}},n=[],i=function(){return u}.apply(t,n),!(void 0!==i&&(e.exports=i))}(this)},function(e,t,r){e.exports=[r(72),r(43),r(175),r(176),r(177),r(178),r(27),r(93),r(179),r(0),r(180)]},function(e,t,r){"use strict";t.isBoolean=function(e){return"boolean"==typeof e}},function(e,t,r){"use strict";function n(e,t,n,d){function v(t,r){if(!(this instanceof v))throw new SyntaxError("Constructor must be called with the new operator");if(r&&!h(r))throw new Error("Invalid datatype: "+r);if(e.isMatrix(t))x(this,t,r);else if(t&&f(t.index)&&f(t.ptr)&&f(t.size))this._values=t.values,this._index=t.index,this._ptr=t.ptr,this._size=t.size,this._datatype=r||t.datatype;else if(f(t))w(this,t,r);else{if(t)throw new TypeError("Unsupported type of data ("+i.types.type(t)+")");this._values=[],this._index=[],this._ptr=[0],this._size=[0,0],this._datatype=r}}var g=n(r(72)),y=n(r(11)),x=function(e,t,r){"SparseMatrix"===t.type?(e._values=t._values?s.clone(t._values):void 0,e._index=s.clone(t._index),e._ptr=s.clone(t._ptr),e._size=s.clone(t._size),e._datatype=r||t._datatype):w(e,t.valueOf(),r||t._datatype)},w=function(e,t,r){e._values=[],e._index=[],e._ptr=[],e._datatype=r;var n=t.length,i=0,a=y,o=0;if(h(r)&&(a=d.find(y,[r,r])||y,o=d.convert(0,r)),n>0){var s=0;do{e._ptr.push(e._index.length);for(var u=0;u<n;u++){var c=t[u];if(f(c)){if(0===s&&i<c.length&&(i=c.length),s<c.length){var l=c[s];a(l,o)||(e._values.push(l),e._index.push(u))}}else 0===s&&i<1&&(i=1),a(c,o)||(e._values.push(c),e._index.push(u))}s++}while(s<i)}e._ptr.push(e._index.length),e._size=[n,i]};v.prototype=new g,v.prototype.type="SparseMatrix",v.prototype.isSparseMatrix=!0,v.prototype.storage=function(){return"sparse"},v.prototype.datatype=function(){return this._datatype},v.prototype.create=function(e,t){return new v(e,t)},v.prototype.density=function(){var e=this._size[0],t=this._size[1];return 0!==e&&0!==t?this._index.length/(e*t):0},v.prototype.subset=function(e,t,r){if(!this._values)throw new Error("Cannot invoke subset on a Pattern only matrix");switch(arguments.length){case 1:return b(this,e);case 2:case 3:return N(this,e,t,r);default:throw new SyntaxError("Wrong number of arguments")}};var b=function(t,r){if(!e.isIndex(r))throw new TypeError("Invalid index");var n=r.isScalar();if(n)return t.get(r.min());var i=r.size();if(i.length!=t._size.length)throw new a(i.length,t._size.length);var o,s,u,c,f=r.min(),l=r.max();for(o=0,s=t._size.length;o<s;o++)m(f[o],t._size[o]),m(l[o],t._size[o]);var p=t._values,h=t._index,d=t._ptr,g=r.dimension(0),y=r.dimension(1),x=[],w=[];g.forEach(function(e,t){w[e]=t[0],x[e]=!0});var b=p?[]:void 0,N=[],E=[];return y.forEach(function(e){for(E.push(N.length),u=d[e],c=d[e+1];u<c;u++)o=h[u],x[o]===!0&&(N.push(w[o]),b&&b.push(p[u]))}),E.push(N.length),new v({values:b,index:N,ptr:E,size:i,datatype:t._datatype})},N=function(t,r,n,i){if(!r||r.isIndex!==!0)throw new TypeError("Invalid index");var u,c=r.size(),f=r.isScalar();if(e.isMatrix(n)?(u=n.size(),n=n.toArray()):u=o.size(n),f){if(0!==u.length)throw new TypeError("Scalar expected");t.set(r.min(),n,i)}else{if(1!==c.length&&2!==c.length)throw new a(c.length,t._size.length,"<");if(u.length<c.length){for(var l=0,p=0;1===c[l]&&1===u[l];)l++;for(;1===c[l];)p++,l++;n=o.unsqueeze(n,c.length,p,u)}if(!s.deepEqual(c,u))throw new a(c,u,">");for(var h=r.min()[0],m=r.min()[1],d=u[0],v=u[1],g=0;g<d;g++)for(var y=0;y<v;y++){var x=n[g][y];t.set([g+h,y+m],x,i)}}return t};v.prototype.get=function(e){if(!f(e))throw new TypeError("Array expected");if(e.length!=this._size.length)throw new a(e.length,this._size.length);if(!this._values)throw new Error("Cannot invoke get on a Pattern only matrix");var t=e[0],r=e[1];m(t,this._size[0]),m(r,this._size[1]);var n=E(t,this._ptr[r],this._ptr[r+1],this._index);return n<this._ptr[r+1]&&this._index[n]===t?this._values[n]:0},v.prototype.set=function(e,t,r){if(!f(e))throw new TypeError("Array expected");if(e.length!=this._size.length)throw new a(e.length,this._size.length);if(!this._values)throw new Error("Cannot invoke set on a Pattern only matrix");var n=e[0],i=e[1],o=this._size[0],s=this._size[1],u=y,c=0;h(this._datatype)&&(u=d.find(y,[this._datatype,this._datatype])||y,c=d.convert(0,this._datatype)),(n>o-1||i>s-1)&&(O(this,Math.max(n+1,o),Math.max(i+1,s),r),o=this._size[0],s=this._size[1]),m(n,o),m(i,s);var l=E(n,this._ptr[i],this._ptr[i+1],this._index);return l<this._ptr[i+1]&&this._index[l]===n?u(t,c)?M(l,i,this._values,this._index,this._ptr):this._values[l]=t:A(l,n,i,t,this._values,this._index,this._ptr),this};var E=function(e,t,r,n){if(r-t===0)return r;for(var i=t;i<r;i++)if(n[i]===e)return i;return t},M=function(e,t,r,n,i){r.splice(e,1),n.splice(e,1);for(var a=t+1;a<i.length;a++)i[a]--},A=function(e,t,r,n,i,a,o){i.splice(e,0,n),a.splice(e,0,t);for(var s=r+1;s<o.length;s++)o[s]++};v.prototype.resize=function(e,t,r){if(!f(e))throw new TypeError("Array expected");if(2!==e.length)throw new Error("Only two dimensions matrix are supported");e.forEach(function(t){if(!c.isNumber(t)||!c.isInteger(t)||t<0)throw new TypeError("Invalid size, must contain positive integers (size: "+u.format(e)+")")});var n=r?this.clone():this;return O(n,e[0],e[1],t)};var O=function(e,t,r,n){var i=n||0,a=y,o=0;h(e._datatype)&&(a=d.find(y,[e._datatype,e._datatype])||y,o=d.convert(0,e._datatype),i=d.convert(i,e._datatype));var s,u,c,f=!a(i,o),l=e._size[0],p=e._size[1];if(r>p){for(u=p;u<r;u++)if(e._ptr[u]=e._values.length,f)for(s=0;s<l;s++)e._values.push(i),e._index.push(s);e._ptr[r]=e._values.length}else r<p&&(e._ptr.splice(r+1,p-r),e._values.splice(e._ptr[r],e._values.length),e._index.splice(e._ptr[r],e._index.length));if(p=r,t>l){if(f){var m=0;for(u=0;u<p;u++){e._ptr[u]=e._ptr[u]+m,c=e._ptr[u+1]+m;var v=0;for(s=l;s<t;s++,v++)e._values.splice(c+v,0,i),e._index.splice(c+v,0,s),m++}e._ptr[p]=e._values.length}}else if(t<l){var g=0;for(u=0;u<p;u++){e._ptr[u]=e._ptr[u]-g;var x=e._ptr[u],w=e._ptr[u+1]-g;for(c=x;c<w;c++)s=e._index[c],s>t-1&&(e._values.splice(c,1),e._index.splice(c,1),g++)}e._ptr[u]=e._values.length}return e._size[0]=t,e._size[1]=r,e};v.prototype.reshape=function(e,t){if(!f(e))throw new TypeError("Array expected");if(2!==e.length)throw new Error("Sparse matrices can only be reshaped in two dimensions");if(e.forEach(function(t){if(!c.isNumber(t)||!c.isInteger(t)||t<0)throw new TypeError("Invalid size, must contain positive integers (size: "+u.format(e)+")")}),this._size[0]*this._size[1]!==e[0]*e[1])throw new Error("Reshaping sparse matrix will result in the wrong number of elements");var r=t?this.clone():this;if(this._size[0]===e[0]&&this._size[1]===e[1])return r;for(var n=[],i=0;i<r._ptr.length;i++)for(var a=0;a<r._ptr[i+1]-r._ptr[i];a++)n.push(i);for(var o=r._values.slice(),s=r._index.slice(),i=0;i<r._index.length;i++){var l=s[i],p=n[i],h=l*r._size[1]+p;n[i]=h%e[1],s[i]=Math.floor(h/e[1])}r._values.length=0,r._index.length=0,r._ptr.length=e[1]+1,r._size=e.slice();for(var i=0;i<r._ptr.length;i++)r._ptr[i]=0;for(var m=0;m<o.length;m++){var i=s[m],a=n[m],d=o[m],v=E(i,r._ptr[a],r._ptr[a+1],r._index);A(v,i,a,d,r._values,r._index,r._ptr)}return r},v.prototype.clone=function(){var e=new v({values:this._values?s.clone(this._values):void 0,index:s.clone(this._index),ptr:s.clone(this._ptr),size:s.clone(this._size),datatype:this._datatype});return e},v.prototype.size=function(){return this._size.slice(0)},v.prototype.map=function(e,t){if(!this._values)throw new Error("Cannot invoke map on a Pattern only matrix");var r=this,n=this._size[0],i=this._size[1],a=function(t,n,i){return e(t,[n,i],r)};return T(this,0,n-1,0,i-1,a,t)};var T=function(e,t,r,n,i,a,o){var s=[],u=[],c=[],f=y,l=0;h(e._datatype)&&(f=d.find(y,[e._datatype,e._datatype])||y,l=d.convert(0,e._datatype));for(var p=function(e,t,r){e=a(e,t,r),f(e,l)||(s.push(e),u.push(t))},m=n;m<=i;m++){c.push(s.length);for(var g=e._ptr[m],x=e._ptr[m+1],w=t,b=g;b<x;b++){var N=e._index[b];if(N>=t&&N<=r){if(!o)for(var E=w;E<N;E++)p(0,E-t,m-n);p(e._values[b],N-t,m-n)}w=N+1}if(!o)for(var M=w;M<=r;M++)p(0,M-t,m-n)}return c.push(s.length),new v({values:s,index:u,ptr:c,size:[r-t+1,i-n+1]})};v.prototype.forEach=function(e,t){if(!this._values)throw new Error("Cannot invoke forEach on a Pattern only matrix");for(var r=this,n=this._size[0],i=this._size[1],a=0;a<i;a++){for(var o=this._ptr[a],s=this._ptr[a+1],u=0,c=o;c<s;c++){var f=this._index[c];if(!t)for(var l=u;l<f;l++)e(0,[l,a],r);e(this._values[c],[f,a],r),u=f+1}if(!t)for(var p=u;p<n;p++)e(0,[p,a],r)}},v.prototype.toArray=function(){return _(this._values,this._index,this._ptr,this._size,!0)},v.prototype.valueOf=function(){return _(this._values,this._index,this._ptr,this._size,!1)};var _=function(e,t,r,n,i){var a,o,u=n[0],c=n[1],f=[];for(a=0;a<u;a++)for(f[a]=[],o=0;o<c;o++)f[a][o]=0;for(o=0;o<c;o++)for(var l=r[o],p=r[o+1],h=l;h<p;h++)a=t[h],f[a][o]=e?i?s.clone(e[h]):e[h]:1;return f};return v.prototype.format=function(e){for(var t=this._size[0],r=this._size[1],n=this.density(),i="Sparse Matrix ["+u.format(t,e)+" x "+u.format(r,e)+"] density: "+u.format(n,e)+"\n",a=0;a<r;a++)for(var o=this._ptr[a],s=this._ptr[a+1],c=o;c<s;c++){var f=this._index[c];i+="\n    ("+u.format(f,e)+", "+u.format(a,e)+") ==> "+(this._values?u.format(this._values[c],e):"X")}return i},v.prototype.toString=function(){return u.format(this.toArray())},v.prototype.toJSON=function(){return{mathjs:"SparseMatrix",values:this._values,index:this._index,ptr:this._ptr,size:this._size,datatype:this._datatype}},v.prototype.diagonal=function(t){if(t){if(e.isBigNumber(t)&&(t=t.toNumber()),!l(t)||!p(t))throw new TypeError("The parameter k must be an integer number")}else t=0;var r=t>0?t:0,n=t<0?-t:0,i=this._size[0],a=this._size[1],o=Math.min(i-n,a-r),s=[],u=[],c=[];c[0]=0;for(var f=r;f<a&&s.length<o;f++)for(var h=this._ptr[f],m=this._ptr[f+1],d=h;d<m;d++){var g=this._index[d];if(g===f-r+n){s.push(this._values[d]),u[s.length-1]=g-n;break}}return c.push(s.length),new v({values:s,index:u,ptr:c,size:[o,1]})},v.fromJSON=function(e){return new v(e)},v.diagonal=function(t,r,n,i,a){if(!f(t))throw new TypeError("Array expected, size parameter");if(2!==t.length)throw new Error("Only two dimensions matrix are supported");if(t=t.map(function(t){if(e.isBigNumber(t)&&(t=t.toNumber()),!l(t)||!p(t)||t<1)throw new Error("Size values must be positive integers");return t}),n){if(e.isBigNumber(n)&&(n=n.toNumber()),!l(n)||!p(n))throw new TypeError("The parameter k must be an integer number")}else n=0;var o=y,s=0;h(a)&&(o=d.find(y,[a,a])||y,s=d.convert(0,a));var u,c=n>0?n:0,m=n<0?-n:0,g=t[0],x=t[1],w=Math.min(g-m,x-c);if(f(r)){if(r.length!==w)throw new Error("Invalid value array length");u=function(e){return r[e]}}else if(e.isMatrix(r)){var b=r.size();if(1!==b.length||b[0]!==w)throw new Error("Invalid matrix length");u=function(e){return r.get([e])}}else u=function(){return r};for(var N=[],E=[],M=[],A=0;A<x;A++){M.push(N.length);var O=A-c;if(O>=0&&O<w){var T=u(O);o(T,s)||(E.push(O+m),N.push(T))}}return M.push(N.length),new v({values:N,index:E,ptr:M,size:[g,x]})},v.prototype.swapRows=function(e,t){if(!(l(e)&&p(e)&&l(t)&&p(t)))throw new Error("Row index must be positive integers");if(2!==this._size.length)throw new Error("Only two dimensional matrix is supported");return m(e,this._size[0]),m(t,this._size[0]),v._swapRows(e,t,this._size[1],this._values,this._index,this._ptr),this},v._forEachRow=function(e,t,r,n,i){for(var a=n[e],o=n[e+1],s=a;s<o;s++)i(r[s],t[s])},v._swapRows=function(e,t,r,n,i,a){for(var o=0;o<r;o++){var s=a[o],u=a[o+1],c=E(e,s,u,i),f=E(t,s,u,i);if(c<u&&f<u&&i[c]===e&&i[f]===t){if(n){var l=n[c];n[c]=n[f],n[f]=l}}else if(c<u&&i[c]===e&&(f>=u||i[f]!==t)){var p=n?n[c]:void 0;i.splice(f,0,t),n&&n.splice(f,0,p),i.splice(f<=c?c+1:c,1),n&&n.splice(f<=c?c+1:c,1)}else if(f<u&&i[f]===t&&(c>=u||i[c]!==e)){var h=n?n[f]:void 0;i.splice(c,0,e),n&&n.splice(c,0,h),i.splice(c<=f?f+1:f,1),n&&n.splice(c<=f?f+1:f,1)}}},e.Matrix._storage.sparse=v,v}var i=r(25),a=r(10),o=i.array,s=i.object,u=i.string,c=i.number,f=Array.isArray,l=c.isNumber,p=c.isInteger,h=u.isString,m=o.validateIndex;t.name="SparseMatrix",t.path="type",t.factory=n,t.lazy=!1},function(e,t,r){"use strict";function n(e,t,n){function i(){if(!(this instanceof i))throw new SyntaxError("Constructor must be called with the new operator");this._values=[],this._heap=new e.FibonacciHeap}var a=n(r(18)),o=n(r(11));return i.prototype.type="Spa",i.prototype.isSpa=!0,i.prototype.set=function(e,t){if(this._values[e])this._values[e].value=t;else{var r=this._heap.insert(e,t);this._values[e]=r}},i.prototype.get=function(e){var t=this._values[e];return t?t.value:0},i.prototype.accumulate=function(e,t){var r=this._values[e];r?r.value=a(r.value,t):(r=this._heap.insert(e,t),this._values[e]=r)},i.prototype.forEach=function(e,t,r){var n=this._heap,i=this._values,a=[],s=n.extractMinimum();for(s&&a.push(s);s&&s.key<=t;)s.key>=e&&(o(s.value,0)||r(s.key,s.value,this)),s=n.extractMinimum(),s&&a.push(s);for(var u=0;u<a.length;u++){var c=a[u];s=n.insert(c.key,c.value),i[s.key]=s}},i.prototype.swap=function(e,t){var r=this._values[e],n=this._values[t];if(!r&&n)r=this._heap.insert(e,n.value),this._heap.remove(n),this._values[e]=r,this._values[t]=void 0;else if(r&&!n)n=this._heap.insert(t,r.value),this._heap.remove(r),this._values[t]=n,this._values[e]=void 0;else if(r&&n){var i=r.value;r.value=n.value,n.value=i}},i}t.name="Spa",t.path="type",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,i){function a(){if(!(this instanceof a))throw new SyntaxError("Constructor must be called with the new operator");this._minimum=null,this._size=0}var o=n(r(44)),s=n(r(34)),u=1/Math.log((1+Math.sqrt(5))/2);a.prototype.type="FibonacciHeap",a.prototype.isFibonacciHeap=!0,a.prototype.insert=function(e,t){var r={key:e,value:t,degree:0};if(this._minimum){var n=this._minimum;r.left=n,r.right=n.right,n.right=r,r.right.left=r,o(e,n.key)&&(this._minimum=r)}else r.left=r,r.right=r,this._minimum=r;return this._size++,r},a.prototype.size=function(){return this._size},a.prototype.clear=function(){this._minimum=null,this._size=0},a.prototype.isEmpty=function(){return 0===this._size},a.prototype.extractMinimum=function(){var e=this._minimum;if(null===e)return e;for(var t=this._minimum,r=e.degree,n=e.child;r>0;){var i=n.right;n.left.right=n.right,n.right.left=n.left,n.left=t,n.right=t.right,t.right=n,n.right.left=n,n.parent=null,n=i,r--}return e.left.right=e.right,e.right.left=e.left,e==e.right?t=null:(t=e.right,t=h(t,this._size)),this._size--,this._minimum=t,e},a.prototype.remove=function(e){this._minimum=c(this._minimum,e,-1),this.extractMinimum()};var c=function(e,t,r){t.key=r;var n=t.parent;return n&&o(t.key,n.key)&&(f(e,t,n),l(e,n)),o(t.key,e.key)&&(e=t),e},f=function(e,t,r){t.left.right=t.right,t.right.left=t.left,r.degree--,r.child==t&&(r.child=t.right),0===r.degree&&(r.child=null),t.left=e,t.right=e.right,e.right=t,t.right.left=t,t.parent=null,t.mark=!1},l=function(e,t){var r=t.parent;r&&(t.mark?(f(e,t,r),l(r)):t.mark=!0)},p=function(e,t){e.left.right=e.right,e.right.left=e.left,e.parent=t,t.child?(e.left=t.child,e.right=t.child.right,t.child.right=e,e.right.left=e):(t.child=e,e.right=e,e.left=e),t.degree++,e.mark=!1},h=function(e,t){var r=Math.floor(Math.log(t)*u)+1,n=new Array(r),i=0,a=e;if(a)for(i++,a=a.right;a!==e;)i++,a=a.right;for(var c;i>0;){for(var f=a.degree,l=a.right;;){if(c=n[f],!c)break;if(s(a.key,c.key)){var h=c;c=a,a=h}p(c,a),n[f]=null,f++}n[f]=a,a=l,i--}e=null;for(var m=0;m<r;m++)c=n[m],c&&(e?(c.left.right=c.right,c.right.left=c.left,c.left=e,c.right=e.right,e.right=c,c.right.left=c,o(c.key,e.key)&&(e=c)):e=c);return e};return a}t.name="FibonacciHeap",t.path="type",t.factory=n},function(e,t,r){"use strict";function n(e,t,n){function a(t,r){if(!(this instanceof a))throw new SyntaxError("Constructor must be called with the new operator");if(r&&!u(r))throw new Error("Invalid datatype: "+r);if(e.isMatrix(t)||s(t)){var n=new c(t,r);this._data=n._data,this._size=n._size,this._datatype=n._datatype,this._min=null,this._max=null}else if(t&&s(t.data)&&s(t.size))this._data=t.data,this._size=t.size,this._datatype=t.datatype,this._min="undefined"!=typeof t.min?t.min:null,this._max="undefined"!=typeof t.max?t.max:null;else{if(t)throw new TypeError("Unsupported type of data ("+i.types.type(t)+")");this._data=[],this._size=[0],this._datatype=r,this._min=null,this._max=null}}var c=n(r(43)),f=n(r(44));return a.prototype=new c,a.prototype.type="ImmutableDenseMatrix",a.prototype.isImmutableDenseMatrix=!0,a.prototype.subset=function(t){switch(arguments.length){case 1:var r=c.prototype.subset.call(this,t);return e.isMatrix(r)?new a({data:r._data,size:r._size,datatype:r._datatype}):r;case 2:case 3:throw new Error("Cannot invoke set subset on an Immutable Matrix instance");default:throw new SyntaxError("Wrong number of arguments")}},a.prototype.set=function(){throw new Error("Cannot invoke set on an Immutable Matrix instance")},a.prototype.resize=function(){throw new Error("Cannot invoke resize on an Immutable Matrix instance")},a.prototype.reshape=function(){throw new Error("Cannot invoke reshape on an Immutable Matrix instance")},a.prototype.clone=function(){var e=new a({data:o.clone(this._data),size:o.clone(this._size),datatype:this._datatype});return e},a.prototype.toJSON=function(){return{mathjs:"ImmutableDenseMatrix",data:this._data,size:this._size,datatype:this._datatype}},a.fromJSON=function(e){return new a(e)},a.prototype.swapRows=function(){throw new Error("Cannot invoke swapRows on an Immutable Matrix instance")},a.prototype.min=function(){if(null===this._min){var e=null;this.forEach(function(t){(null===e||f(t,e))&&(e=t)}),this._min=null!==e?e:void 0}return this._min},a.prototype.max=function(){if(null===this._max){var e=null;this.forEach(function(t){(null===e||f(e,t))&&(e=t)}),this._max=null!==e?e:void 0}return this._max},a}var i=r(25),a=i.string,o=i.object,s=Array.isArray,u=a.isString;t.name="ImmutableDenseMatrix",t.path="type",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){return n("index",{"...number | string | BigNumber | Range | Array | Matrix":function(t){var r=t.map(function(t){return e.isBigNumber(t)?t.toNumber():Array.isArray(t)||e.isMatrix(t)?t.map(function(t){return e.isBigNumber(t)?t.toNumber():t}):t}),n=new e.Index;return e.Index.apply(n,r),n}})}t.name="index",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var i=e.SparseMatrix,a=n("sparse",{"":function(){return new i([])},string:function(e){return new i([],e)},"Array | Matrix":function(e){return new i(e)},"Array | Matrix, string":function(e,t){return new i(e,t)}});return a.toTex={0:"\\begin{bsparse}\\end{bsparse}",1:"\\left(${args[0]}\\right)"},a}t.name="sparse",t.factory=n},function(e,t,r){e.exports=[r(94)]},function(e,t,r){"use strict";function n(e,t,r,n){var o=n("string",{"":function(){return""},number:a.format,null:function(e){return"null"},boolean:function(e){return e+""},string:function(e){return e},"Array | Matrix":function(e){return i(e,o)},any:function(e){return String(e)}});return o.toTex={0:'\\mathtt{""}',1:"\\mathrm{string}\\left(${args[0]}\\right)"},o}var i=r(1),a=r(3);t.name="string",t.factory=n},function(e,t,r){e.exports=[r(184),r(185),r(186),r(187),r(188)]},function(e,t,r){"use strict";function n(e,t,n,s,u){function c(t,r){if(!(this instanceof c))throw new Error("Constructor must be called with the new operator");if(void 0!=t&&!C(t)&&!e.isComplex(t))throw new TypeError("First parameter in Unit constructor must be number, BigNumber, Fraction, Complex, or undefined");if(void 0!=r&&("string"!=typeof r||""===r))throw new TypeError("Second parameter in Unit constructor must be a string");if(void 0!=r){var n=c.parse(r);this.units=n.units,this.dimensions=n.dimensions}else{this.units=[{unit:$,prefix:L.NONE,power:0}],this.dimensions=[];for(var i=0;i<F.length;i++)this.dimensions[i]=0}this.value=void 0!=t?this._normalize(t):null,this.fixPrefix=!1,this.isUnitListSimplified=!0}function f(){for(;" "==U||"\t"==U;)h()}function l(e){return e>="0"&&e<="9"||"."==e}function p(e){return e>="0"&&e<="9"}function h(){R++,U=P.charAt(R)}function m(e){R=e,U=P.charAt(R)}function d(){var e,t="";if(e=R,"+"==U?h():"-"==U&&(t+=U,h()),!l(U))return m(e),null;if("."==U){if(t+=U,h(),!p(U))return m(e),null}else{for(;p(U);)t+=U,h();"."==U&&(t+=U,h())}for(;p(U);)t+=U,h();if("E"==U||"e"==U){var r="",n=R;if(r+=U,h(),"+"!=U&&"-"!=U||(r+=U,h()),!p(U))return m(n),t;for(t+=r;p(U);)t+=U,h()}return t}function v(){for(var e="",t=P.charCodeAt(R);t>=48&&t<=57||t>=65&&t<=90||t>=97&&t<=122;)e+=U,h(),t=P.charCodeAt(R);return t=e.charCodeAt(0),t>=65&&t<=90||t>=97&&t<=122?e||null:null}function g(e){return U===e?(h(),e):null}function y(e){if(G.hasOwnProperty(e)){var t=G[e],r=t.prefixes[""];return{unit:t,prefix:r}}for(var n in G)if(G.hasOwnProperty(n)&&i(e,n)){var t=G[n],a=e.length-n.length,o=e.substring(0,a),r=t.prefixes.hasOwnProperty(o)?t.prefixes[o]:void 0;if(void 0!==r)return{unit:t,prefix:r}}return null}function x(t){if("BigNumber"===t.number){var r=o.pi(e.BigNumber);G.rad.value=new e.BigNumber(1),G.deg.value=r.div(180),G.grad.value=r.div(200),G.cycle.value=r.times(2),G.arcsec.value=r.div(648e3),G.arcmin.value=r.div(10800)}else G.rad.value=1,G.deg.value=Math.PI/180,G.grad.value=Math.PI/200,G.cycle.value=2*Math.PI,G.arcsec.value=Math.PI/648e3,G.arcmin.value=Math.PI/10800}function w(e){for(var t=0;t<e.length;t++){var r=e.charAt(t),n=function(e){return/^[a-zA-Z]$/.test(e)},i=function(e){return e>="0"&&e<="9"};if(0===t&&!n(r))throw new Error('Invalid unit name (must begin with alpha character): "'+e+'"');if(t>0&&!n(r)&&!i(r))throw new Error('Invalid unit name (only alphanumeric characters are allowed): "'+e+'"')}}var b=n(r(20)),N=n(r(21)),E=n(r(23)),M=n(r(19)),A=n(r(45)),O=n(r(29)),T=n(r(96)),_=n(r(97)),S=n(r(30)),C=n(r(75)),z=n(r(98)),k=n(r(76)),I=n(r(74)),B=n(r(91));c.prototype.type="Unit",c.prototype.isUnit=!0;var P,R,U;c.parse=function(r,n){if(n=n||{},P=r,R=-1,U="","string"!=typeof P)throw new TypeError("Invalid argument in Unit.parse, string expected");var i=new c;i.units=[],h(),f();var a=d(),o=null;a&&(o="BigNumber"===t.number?new e.BigNumber(a):"Fraction"===t.number?new e.Fraction(a):parseFloat(a)),f();for(var s=1,u=!1,l=[],p=1;;){for(f();"("===U;)l.push(s),p*=s,s=1,h(),f();if(!U)break;var m=U,x=v();if(null==x)throw new SyntaxError('Unexpected "'+m+'" in "'+P+'" at index '+R.toString());var w=y(x);if(null==w)throw new SyntaxError('Unit "'+x+'" not found.');var b=s*p;if(f(),g("^")){f();var N=d();if(null==N)throw new SyntaxError('In "'+r+'", "^" must be followed by a floating-point number');b*=N}i.units.push({unit:w.unit,prefix:w.prefix,power:b});for(var E=0;E<F.length;E++)i.dimensions[E]+=(w.unit.dimensions[E]||0)*b;for(f();")"===U;){if(0===l.length)throw new SyntaxError('Unmatched ")" in "'+P+'" at index '+R.toString());p/=l.pop(),h(),f()}if(u=!1,g("*")?(s=1,u=!0):g("/")?(s=-1,u=!0):s=1,w.unit.base){var M=w.unit.base.key;V.auto[M]={unit:w.unit,prefix:w.prefix}}}if(f(),U)throw new SyntaxError('Could not parse: "'+r+'"');if(u)throw new SyntaxError('Trailing characters: "'+r+'"');if(0!==l.length)throw new SyntaxError('Unmatched "(" in "'+P+'"');if(0==i.units.length&&!n.allowNoUnits)throw new SyntaxError('"'+r+'" contains no units');return i.value=void 0!=o?i._normalize(o):null,i},c.prototype.clone=function(){var e=new c;e.fixPrefix=this.fixPrefix,e.isUnitListSimplified=this.isUnitListSimplified,e.value=a(this.value),e.dimensions=this.dimensions.slice(0),e.units=[];for(var t=0;t<this.units.length;t++){e.units[t]={};for(var r in this.units[t])this.units[t].hasOwnProperty(r)&&(e.units[t][r]=this.units[t][r])}return e},c.prototype._isDerived=function(){return 0!==this.units.length&&(this.units.length>1||Math.abs(this.units[0].power-1)>1e-15)},c.prototype._normalize=function(e){var t,r,n,i,a;if(null==e||0===this.units.length)return e;if(this._isDerived()){var o=e;a=c._getNumberConverter(k(e));for(var s=0;s<this.units.length;s++)t=a(this.units[s].unit.value),i=a(this.units[s].prefix.value),n=a(this.units[s].power),o=E(o,A(E(t,i),n));return o}return a=c._getNumberConverter(k(e)),t=a(this.units[0].unit.value),r=a(this.units[0].unit.offset),i=a(this.units[0].prefix.value),E(b(e,r),E(t,i))},c.prototype._denormalize=function(e,t){var r,n,i,a,o;if(null==e||0===this.units.length)return e;if(this._isDerived()){var s=e;o=c._getNumberConverter(k(e));for(var u=0;u<this.units.length;u++)r=o(this.units[u].unit.value),a=o(this.units[u].prefix.value),i=o(this.units[u].power),s=M(s,A(E(r,a),i));return s}return o=c._getNumberConverter(k(e)),r=o(this.units[0].unit.value),a=o(this.units[0].prefix.value),n=o(this.units[0].unit.offset),void 0==t?N(M(M(e,r),a),n):N(M(M(e,r),t),n)},c.isValuelessUnit=function(e){return null!=y(e)},c.prototype.hasBase=function(e){if("string"==typeof e&&(e=D[e]),!e)return!1;for(var t=0;t<F.length;t++)if(Math.abs((this.dimensions[t]||0)-(e.dimensions[t]||0))>1e-12)return!1;return!0},c.prototype.equalBase=function(e){for(var t=0;t<F.length;t++)if(Math.abs((this.dimensions[t]||0)-(e.dimensions[t]||0))>1e-12)return!1;return!0},c.prototype.equals=function(e){return this.equalBase(e)&&S(this.value,e.value)},c.prototype.multiply=function(e){for(var t=this.clone(),r=0;r<F.length;r++)t.dimensions[r]=(this.dimensions[r]||0)+(e.dimensions[r]||0);for(var r=0;r<e.units.length;r++){var n={};for(var i in e.units[r])n[i]=e.units[r][i];t.units.push(n)}if(null!=this.value||null!=e.value){var a=null==this.value?this._normalize(1):this.value,o=null==e.value?e._normalize(1):e.value;t.value=E(a,o)}else t.value=null;return t.isUnitListSimplified=!1,q(t)},c.prototype.divide=function(e){for(var t=this.clone(),r=0;r<F.length;r++)t.dimensions[r]=(this.dimensions[r]||0)-(e.dimensions[r]||0);for(var r=0;r<e.units.length;r++){var n={};for(var i in e.units[r])n[i]=e.units[r][i];n.power=-n.power,t.units.push(n)}if(null!=this.value||null!=e.value){var a=null==this.value?this._normalize(1):this.value,o=null==e.value?e._normalize(1):e.value;t.value=M(a,o)}else t.value=null;return t.isUnitListSimplified=!1,q(t)},c.prototype.pow=function(e){for(var t=this.clone(),r=0;r<F.length;r++)t.dimensions[r]=(this.dimensions[r]||0)*e;for(var r=0;r<t.units.length;r++)t.units[r].power*=e;return null!=t.value?t.value=A(t.value,e):t.value=null,t.isUnitListSimplified=!1,q(t)};var q=function(e){return e.equalBase(D.NONE)&&null!==e.value&&!t.predictable?e.value:e};c.prototype.abs=function(){var e=this.clone();e.value=O(e.value);for(var t in e.units)"VA"!==e.units[t].unit.name&&"VAR"!==e.units[t].unit.name||(e.units[t].unit=G.W);return e},c.prototype.to=function(t){var r,n=null==this.value?this._normalize(1):this.value;if("string"==typeof t){if(r=c.parse(t),!this.equalBase(r))throw new Error("Units do not match");if(null!==r.value)throw new Error("Cannot convert to a unit with a value");return r.value=a(n),r.fixPrefix=!0,r.isUnitListSimplified=!0,r}if(e.isUnit(t)){if(!this.equalBase(t))throw new Error("Units do not match");if(null!==t.value)throw new Error("Cannot convert to a unit with a value");return r=t.clone(),r.value=a(n),r.fixPrefix=!0,r.isUnitListSimplified=!0,r}throw new Error("String or Unit expected as parameter")},c.prototype.toNumber=function(e){return I(this.toNumeric(e))},c.prototype.toNumeric=function(e){var t=this;return e&&(t=this.to(e)),t.simplifyUnitListLazy(),t._isDerived()?t._denormalize(t.value):t._denormalize(t.value,t.units[0].prefix.value)},c.prototype.toString=function(){
return this.format()},c.prototype.toJSON=function(){return{mathjs:"Unit",value:this._denormalize(this.value),unit:this.formatUnits(),fixPrefix:this.fixPrefix}},c.fromJSON=function(e){var t=new c(e.value,e.unit);return t.fixPrefix=e.fixPrefix||!1,t},c.prototype.valueOf=c.prototype.toString,c.prototype.simplifyUnitListLazy=function(){if(!this.isUnitListSimplified&&null!=this.value){var e,t=[];for(var r in W)if(this.hasBase(D[r])){e=r;break}if("NONE"===e)this.units=[];else{var n;e&&W.hasOwnProperty(e)&&(n=W[e]);if(n)this.units=[{unit:n.unit,prefix:n.prefix,power:1}];else{for(var i=!1,a=0;a<F.length;a++){var o=F[a];Math.abs(this.dimensions[a]||0)>1e-12&&(W.hasOwnProperty(o)?t.push({unit:W[o].unit,prefix:W[o].prefix,power:this.dimensions[a]||0}):i=!0)}t.length<this.units.length&&!i&&(this.units=t)}}this.isUnitListSimplified=!0}},c.prototype.toSI=function(){for(var e=this.clone(),t=[],r=0;r<F.length;r++){var n=F[r];if(Math.abs(e.dimensions[r]||0)>1e-12){if(!V.si.hasOwnProperty(n))throw new Error("Cannot express custom unit "+n+" in SI units");t.push({unit:V.si[n].unit,prefix:V.si[n].prefix,power:e.dimensions[r]||0})}}return e.units=t,e.isUnitListSimplified=!0,e},c.prototype.formatUnits=function(){this.simplifyUnitListLazy();for(var e="",t="",r=0,n=0,i=0;i<this.units.length;i++)this.units[i].power>0?(r++,e+=" "+this.units[i].prefix.name+this.units[i].unit.name,Math.abs(this.units[i].power-1)>1e-15&&(e+="^"+this.units[i].power)):this.units[i].power<0&&n++;if(n>0)for(var i=0;i<this.units.length;i++)this.units[i].power<0&&(r>0?(t+=" "+this.units[i].prefix.name+this.units[i].unit.name,Math.abs(this.units[i].power+1)>1e-15&&(t+="^"+-this.units[i].power)):(t+=" "+this.units[i].prefix.name+this.units[i].unit.name,t+="^"+this.units[i].power));e=e.substr(1),t=t.substr(1),r>1&&n>0&&(e="("+e+")"),n>1&&r>0&&(t="("+t+")");var a=e;return r>0&&n>0&&(a+=" / "),a+=t},c.prototype.format=function(t){this.simplifyUnitListLazy();var r=!1,n=!0;"undefined"!=typeof this.value&&null!==this.value&&e.isComplex(this.value)&&(r=Math.abs(this.value.re)<1e-14,n=Math.abs(this.value.im)<1e-14);for(var i in this.units)this.units[i].unit&&("VA"===this.units[i].unit.name&&r?this.units[i].unit=G.VAR:"VAR"!==this.units[i].unit.name||r||(this.units[i].unit=G.VA));1!==this.units.length||this.fixPrefix||Math.abs(this.units[0].power-Math.round(this.units[0].power))<1e-14&&(this.units[0].prefix=this._bestPrefix());var a=this._denormalize(this.value),o=null!==this.value?z(a,t||{}):"",s=this.formatUnits();return this.value&&e.isComplex(this.value)&&(o="("+o+")"),s.length>0&&o.length>0&&(o+=" "),o+=s},c.prototype._bestPrefix=function(){if(1!==this.units.length)throw new Error("Can only compute the best prefix for single units with integer powers, like kg, s^2, N^-1, and so forth!");if(Math.abs(this.units[0].power-Math.round(this.units[0].power))>=1e-14)throw new Error("Can only compute the best prefix for single units with integer powers, like kg, s^2, N^-1, and so forth!");var e=O(this.value),t=O(this.units[0].unit.value),r=this.units[0].prefix;if(0===e)return r;var n=this.units[0].power,i=Math.log(e/Math.pow(r.value*t,n))/Math.LN10-1.2;if(i>-2.200001&&i<1.800001)return r;i=Math.abs(i);var a=this.units[0].unit.prefixes;for(var o in a)if(a.hasOwnProperty(o)){var s=a[o];if(s.scientific){var u=Math.abs(Math.log(e/Math.pow(s.value*t,n))/Math.LN10-1.2);(u<i||u===i&&s.name.length<r.name.length)&&(r=s,i=u)}}return r},c.prototype.splitUnit=function(e){for(var t=this.clone(),r=[],n=0;n<e.length&&(t=t.to(e[n]),n!=e.length-1);n++){var i,a=t.toNumeric(),o=_(a),s=S(o,a);i=s?o:T(t.toNumeric());var u=new c(i,e[n].toString());r.push(u),t=N(t,u)}for(var f=0,n=0;n<r.length;n++)f=b(f,r[n].value);return S(f,this.value)&&(t.value=0),r.push(t),r};var L={NONE:{"":{name:"",value:1,scientific:!0}},SHORT:{"":{name:"",value:1,scientific:!0},da:{name:"da",value:10,scientific:!1},h:{name:"h",value:100,scientific:!1},k:{name:"k",value:1e3,scientific:!0},M:{name:"M",value:1e6,scientific:!0},G:{name:"G",value:1e9,scientific:!0},T:{name:"T",value:1e12,scientific:!0},P:{name:"P",value:1e15,scientific:!0},E:{name:"E",value:1e18,scientific:!0},Z:{name:"Z",value:1e21,scientific:!0},Y:{name:"Y",value:1e24,scientific:!0},d:{name:"d",value:.1,scientific:!1},c:{name:"c",value:.01,scientific:!1},m:{name:"m",value:.001,scientific:!0},u:{name:"u",value:1e-6,scientific:!0},n:{name:"n",value:1e-9,scientific:!0},p:{name:"p",value:1e-12,scientific:!0},f:{name:"f",value:1e-15,scientific:!0},a:{name:"a",value:1e-18,scientific:!0},z:{name:"z",value:1e-21,scientific:!0},y:{name:"y",value:1e-24,scientific:!0}},LONG:{"":{name:"",value:1,scientific:!0},deca:{name:"deca",value:10,scientific:!1},hecto:{name:"hecto",value:100,scientific:!1},kilo:{name:"kilo",value:1e3,scientific:!0},mega:{name:"mega",value:1e6,scientific:!0},giga:{name:"giga",value:1e9,scientific:!0},tera:{name:"tera",value:1e12,scientific:!0},peta:{name:"peta",value:1e15,scientific:!0},exa:{name:"exa",value:1e18,scientific:!0},zetta:{name:"zetta",value:1e21,scientific:!0},yotta:{name:"yotta",value:1e24,scientific:!0},deci:{name:"deci",value:.1,scientific:!1},centi:{name:"centi",value:.01,scientific:!1},milli:{name:"milli",value:.001,scientific:!0},micro:{name:"micro",value:1e-6,scientific:!0},nano:{name:"nano",value:1e-9,scientific:!0},pico:{name:"pico",value:1e-12,scientific:!0},femto:{name:"femto",value:1e-15,scientific:!0},atto:{name:"atto",value:1e-18,scientific:!0},zepto:{name:"zepto",value:1e-21,scientific:!0},yocto:{name:"yocto",value:1e-24,scientific:!0}},SQUARED:{"":{name:"",value:1,scientific:!0},da:{name:"da",value:100,scientific:!1},h:{name:"h",value:1e4,scientific:!1},k:{name:"k",value:1e6,scientific:!0},M:{name:"M",value:1e12,scientific:!0},G:{name:"G",value:1e18,scientific:!0},T:{name:"T",value:1e24,scientific:!0},P:{name:"P",value:1e30,scientific:!0},E:{name:"E",value:1e36,scientific:!0},Z:{name:"Z",value:1e42,scientific:!0},Y:{name:"Y",value:1e48,scientific:!0},d:{name:"d",value:.01,scientific:!1},c:{name:"c",value:1e-4,scientific:!1},m:{name:"m",value:1e-6,scientific:!0},u:{name:"u",value:1e-12,scientific:!0},n:{name:"n",value:1e-18,scientific:!0},p:{name:"p",value:1e-24,scientific:!0},f:{name:"f",value:1e-30,scientific:!0},a:{name:"a",value:1e-36,scientific:!0},z:{name:"z",value:1e-42,scientific:!0},y:{name:"y",value:1e-48,scientific:!0}},CUBIC:{"":{name:"",value:1,scientific:!0},da:{name:"da",value:1e3,scientific:!1},h:{name:"h",value:1e6,scientific:!1},k:{name:"k",value:1e9,scientific:!0},M:{name:"M",value:1e18,scientific:!0},G:{name:"G",value:1e27,scientific:!0},T:{name:"T",value:1e36,scientific:!0},P:{name:"P",value:1e45,scientific:!0},E:{name:"E",value:1e54,scientific:!0},Z:{name:"Z",value:1e63,scientific:!0},Y:{name:"Y",value:1e72,scientific:!0},d:{name:"d",value:.001,scientific:!1},c:{name:"c",value:1e-6,scientific:!1},m:{name:"m",value:1e-9,scientific:!0},u:{name:"u",value:1e-18,scientific:!0},n:{name:"n",value:1e-27,scientific:!0},p:{name:"p",value:1e-36,scientific:!0},f:{name:"f",value:1e-45,scientific:!0},a:{name:"a",value:1e-54,scientific:!0},z:{name:"z",value:1e-63,scientific:!0},y:{name:"y",value:1e-72,scientific:!0}},BINARY_SHORT:{"":{name:"",value:1,scientific:!0},k:{name:"k",value:1e3,scientific:!0},M:{name:"M",value:1e6,scientific:!0},G:{name:"G",value:1e9,scientific:!0},T:{name:"T",value:1e12,scientific:!0},P:{name:"P",value:1e15,scientific:!0},E:{name:"E",value:1e18,scientific:!0},Z:{name:"Z",value:1e21,scientific:!0},Y:{name:"Y",value:1e24,scientific:!0},Ki:{name:"Ki",value:1024,scientific:!0},Mi:{name:"Mi",value:Math.pow(1024,2),scientific:!0},Gi:{name:"Gi",value:Math.pow(1024,3),scientific:!0},Ti:{name:"Ti",value:Math.pow(1024,4),scientific:!0},Pi:{name:"Pi",value:Math.pow(1024,5),scientific:!0},Ei:{name:"Ei",value:Math.pow(1024,6),scientific:!0},Zi:{name:"Zi",value:Math.pow(1024,7),scientific:!0},Yi:{name:"Yi",value:Math.pow(1024,8),scientific:!0}},BINARY_LONG:{"":{name:"",value:1,scientific:!0},kilo:{name:"kilo",value:1e3,scientific:!0},mega:{name:"mega",value:1e6,scientific:!0},giga:{name:"giga",value:1e9,scientific:!0},tera:{name:"tera",value:1e12,scientific:!0},peta:{name:"peta",value:1e15,scientific:!0},exa:{name:"exa",value:1e18,scientific:!0},zetta:{name:"zetta",value:1e21,scientific:!0},yotta:{name:"yotta",value:1e24,scientific:!0},kibi:{name:"kibi",value:1024,scientific:!0},mebi:{name:"mebi",value:Math.pow(1024,2),scientific:!0},gibi:{name:"gibi",value:Math.pow(1024,3),scientific:!0},tebi:{name:"tebi",value:Math.pow(1024,4),scientific:!0},pebi:{name:"pebi",value:Math.pow(1024,5),scientific:!0},exi:{name:"exi",value:Math.pow(1024,6),scientific:!0},zebi:{name:"zebi",value:Math.pow(1024,7),scientific:!0},yobi:{name:"yobi",value:Math.pow(1024,8),scientific:!0}},BTU:{"":{name:"",value:1,scientific:!0},MM:{name:"MM",value:1e6,scientific:!0}}};L.SHORTLONG={};for(var j in L.SHORT)L.SHORT.hasOwnProperty(j)&&(L.SHORTLONG[j]=L.SHORT[j]);for(var j in L.LONG)L.LONG.hasOwnProperty(j)&&(L.SHORTLONG[j]=L.LONG[j]);var F=["MASS","LENGTH","TIME","CURRENT","TEMPERATURE","LUMINOUS_INTENSITY","AMOUNT_OF_SUBSTANCE","ANGLE","BIT"],D={NONE:{dimensions:[0,0,0,0,0,0,0,0,0]},MASS:{dimensions:[1,0,0,0,0,0,0,0,0]},LENGTH:{dimensions:[0,1,0,0,0,0,0,0,0]},TIME:{dimensions:[0,0,1,0,0,0,0,0,0]},CURRENT:{dimensions:[0,0,0,1,0,0,0,0,0]},TEMPERATURE:{dimensions:[0,0,0,0,1,0,0,0,0]},LUMINOUS_INTENSITY:{dimensions:[0,0,0,0,0,1,0,0,0]},AMOUNT_OF_SUBSTANCE:{dimensions:[0,0,0,0,0,0,1,0,0]},FORCE:{dimensions:[1,1,-2,0,0,0,0,0,0]},SURFACE:{dimensions:[0,2,0,0,0,0,0,0,0]},VOLUME:{dimensions:[0,3,0,0,0,0,0,0,0]},ENERGY:{dimensions:[1,2,-2,0,0,0,0,0,0]},POWER:{dimensions:[1,2,-3,0,0,0,0,0,0]},PRESSURE:{dimensions:[1,-1,-2,0,0,0,0,0,0]},ELECTRIC_CHARGE:{dimensions:[0,0,1,1,0,0,0,0,0]},ELECTRIC_CAPACITANCE:{dimensions:[-1,-2,4,2,0,0,0,0,0]},ELECTRIC_POTENTIAL:{dimensions:[1,2,-3,-1,0,0,0,0,0]},ELECTRIC_RESISTANCE:{dimensions:[1,2,-3,-2,0,0,0,0,0]},ELECTRIC_INDUCTANCE:{dimensions:[1,2,-2,-2,0,0,0,0,0]},ELECTRIC_CONDUCTANCE:{dimensions:[-1,-2,3,2,0,0,0,0,0]},MAGNETIC_FLUX:{dimensions:[1,2,-2,-1,0,0,0,0,0]},MAGNETIC_FLUX_DENSITY:{dimensions:[1,0,-2,-1,0,0,0,0,0]},FREQUENCY:{dimensions:[0,0,-1,0,0,0,0,0,0]},ANGLE:{dimensions:[0,0,0,0,0,0,0,1,0]},BIT:{dimensions:[0,0,0,0,0,0,0,0,1]}};for(var j in D)D[j].key=j;var H={},$={name:"",base:H,value:1,offset:0,dimensions:[0,0,0,0,0,0,0,0,0]},G={meter:{name:"meter",base:D.LENGTH,prefixes:L.LONG,value:1,offset:0},inch:{name:"inch",base:D.LENGTH,prefixes:L.NONE,value:.0254,offset:0},foot:{name:"foot",base:D.LENGTH,prefixes:L.NONE,value:.3048,offset:0},yard:{name:"yard",base:D.LENGTH,prefixes:L.NONE,value:.9144,offset:0},mile:{name:"mile",base:D.LENGTH,prefixes:L.NONE,value:1609.344,offset:0},link:{name:"link",base:D.LENGTH,prefixes:L.NONE,value:.201168,offset:0},rod:{name:"rod",base:D.LENGTH,prefixes:L.NONE,value:5.02921,offset:0},chain:{name:"chain",base:D.LENGTH,prefixes:L.NONE,value:20.1168,offset:0},angstrom:{name:"angstrom",base:D.LENGTH,prefixes:L.NONE,value:1e-10,offset:0},m:{name:"m",base:D.LENGTH,prefixes:L.SHORT,value:1,offset:0},in:{name:"in",base:D.LENGTH,prefixes:L.NONE,value:.0254,offset:0},ft:{name:"ft",base:D.LENGTH,prefixes:L.NONE,value:.3048,offset:0},yd:{name:"yd",base:D.LENGTH,prefixes:L.NONE,value:.9144,offset:0},mi:{name:"mi",base:D.LENGTH,prefixes:L.NONE,value:1609.344,offset:0},li:{name:"li",base:D.LENGTH,prefixes:L.NONE,value:.201168,offset:0},rd:{name:"rd",base:D.LENGTH,prefixes:L.NONE,value:5.02921,offset:0},ch:{name:"ch",base:D.LENGTH,prefixes:L.NONE,value:20.1168,offset:0},mil:{name:"mil",base:D.LENGTH,prefixes:L.NONE,value:254e-7,offset:0},m2:{name:"m2",base:D.SURFACE,prefixes:L.SQUARED,value:1,offset:0},sqin:{name:"sqin",base:D.SURFACE,prefixes:L.NONE,value:64516e-8,offset:0},sqft:{name:"sqft",base:D.SURFACE,prefixes:L.NONE,value:.09290304,offset:0},sqyd:{name:"sqyd",base:D.SURFACE,prefixes:L.NONE,value:.83612736,offset:0},sqmi:{name:"sqmi",base:D.SURFACE,prefixes:L.NONE,value:2589988.110336,offset:0},sqrd:{name:"sqrd",base:D.SURFACE,prefixes:L.NONE,value:25.29295,offset:0},sqch:{name:"sqch",base:D.SURFACE,prefixes:L.NONE,value:404.6873,offset:0},sqmil:{name:"sqmil",base:D.SURFACE,prefixes:L.NONE,value:6.4516e-10,offset:0},acre:{name:"acre",base:D.SURFACE,prefixes:L.NONE,value:4046.86,offset:0},hectare:{name:"hectare",base:D.SURFACE,prefixes:L.NONE,value:1e4,offset:0},m3:{name:"m3",base:D.VOLUME,prefixes:L.CUBIC,value:1,offset:0},L:{name:"L",base:D.VOLUME,prefixes:L.SHORT,value:.001,offset:0},l:{name:"l",base:D.VOLUME,prefixes:L.SHORT,value:.001,offset:0},litre:{name:"litre",base:D.VOLUME,prefixes:L.LONG,value:.001,offset:0},cuin:{name:"cuin",base:D.VOLUME,prefixes:L.NONE,value:16387064e-12,offset:0},cuft:{name:"cuft",base:D.VOLUME,prefixes:L.NONE,value:.028316846592,offset:0},cuyd:{name:"cuyd",base:D.VOLUME,prefixes:L.NONE,value:.764554857984,offset:0},teaspoon:{name:"teaspoon",base:D.VOLUME,prefixes:L.NONE,value:5e-6,offset:0},tablespoon:{name:"tablespoon",base:D.VOLUME,prefixes:L.NONE,value:15e-6,offset:0},drop:{name:"drop",base:D.VOLUME,prefixes:L.NONE,value:5e-8,offset:0},gtt:{name:"gtt",base:D.VOLUME,prefixes:L.NONE,value:5e-8,offset:0},minim:{name:"minim",base:D.VOLUME,prefixes:L.NONE,value:6.161152e-8,offset:0},fluiddram:{name:"fluiddram",base:D.VOLUME,prefixes:L.NONE,value:36966911e-13,offset:0},fluidounce:{name:"fluidounce",base:D.VOLUME,prefixes:L.NONE,value:2957353e-11,offset:0},gill:{name:"gill",base:D.VOLUME,prefixes:L.NONE,value:.0001182941,offset:0},cc:{name:"cc",base:D.VOLUME,prefixes:L.NONE,value:1e-6,offset:0},cup:{name:"cup",base:D.VOLUME,prefixes:L.NONE,value:.0002365882,offset:0},pint:{name:"pint",base:D.VOLUME,prefixes:L.NONE,value:.0004731765,offset:0},quart:{name:"quart",base:D.VOLUME,prefixes:L.NONE,value:.0009463529,offset:0},gallon:{name:"gallon",base:D.VOLUME,prefixes:L.NONE,value:.003785412,offset:0},beerbarrel:{name:"beerbarrel",base:D.VOLUME,prefixes:L.NONE,value:.1173478,offset:0},oilbarrel:{name:"oilbarrel",base:D.VOLUME,prefixes:L.NONE,value:.1589873,offset:0},hogshead:{name:"hogshead",base:D.VOLUME,prefixes:L.NONE,value:.238481,offset:0},fldr:{name:"fldr",base:D.VOLUME,prefixes:L.NONE,value:36966911e-13,offset:0},floz:{name:"floz",base:D.VOLUME,prefixes:L.NONE,value:2957353e-11,offset:0},gi:{name:"gi",base:D.VOLUME,prefixes:L.NONE,value:.0001182941,offset:0},cp:{name:"cp",base:D.VOLUME,prefixes:L.NONE,value:.0002365882,offset:0},pt:{name:"pt",base:D.VOLUME,prefixes:L.NONE,value:.0004731765,offset:0},qt:{name:"qt",base:D.VOLUME,prefixes:L.NONE,value:.0009463529,offset:0},gal:{name:"gal",base:D.VOLUME,prefixes:L.NONE,value:.003785412,offset:0},bbl:{name:"bbl",base:D.VOLUME,prefixes:L.NONE,value:.1173478,offset:0},obl:{name:"obl",base:D.VOLUME,prefixes:L.NONE,value:.1589873,offset:0},g:{name:"g",base:D.MASS,prefixes:L.SHORT,value:.001,offset:0},gram:{name:"gram",base:D.MASS,prefixes:L.LONG,value:.001,offset:0},ton:{name:"ton",base:D.MASS,prefixes:L.SHORT,value:907.18474,offset:0},tonne:{name:"tonne",base:D.MASS,prefixes:L.SHORT,value:1e3,offset:0},grain:{name:"grain",base:D.MASS,prefixes:L.NONE,value:6479891e-11,offset:0},dram:{name:"dram",base:D.MASS,prefixes:L.NONE,value:.0017718451953125,offset:0},ounce:{name:"ounce",base:D.MASS,prefixes:L.NONE,value:.028349523125,offset:0},poundmass:{name:"poundmass",base:D.MASS,prefixes:L.NONE,value:.45359237,offset:0},hundredweight:{name:"hundredweight",base:D.MASS,prefixes:L.NONE,value:45.359237,offset:0},stick:{name:"stick",base:D.MASS,prefixes:L.NONE,value:.115,offset:0},stone:{name:"stone",base:D.MASS,prefixes:L.NONE,value:6.35029318,offset:0},gr:{name:"gr",base:D.MASS,prefixes:L.NONE,value:6479891e-11,offset:0},dr:{name:"dr",base:D.MASS,prefixes:L.NONE,value:.0017718451953125,offset:0},oz:{name:"oz",base:D.MASS,prefixes:L.NONE,value:.028349523125,offset:0},lbm:{name:"lbm",base:D.MASS,prefixes:L.NONE,value:.45359237,offset:0},cwt:{name:"cwt",base:D.MASS,prefixes:L.NONE,value:45.359237,offset:0},s:{name:"s",base:D.TIME,prefixes:L.SHORT,value:1,offset:0},min:{name:"min",base:D.TIME,prefixes:L.NONE,value:60,offset:0},h:{name:"h",base:D.TIME,prefixes:L.NONE,value:3600,offset:0},second:{name:"second",base:D.TIME,prefixes:L.LONG,value:1,offset:0},sec:{name:"sec",base:D.TIME,prefixes:L.LONG,value:1,offset:0},minute:{name:"minute",base:D.TIME,prefixes:L.NONE,value:60,offset:0},hour:{name:"hour",base:D.TIME,prefixes:L.NONE,value:3600,offset:0},day:{name:"day",base:D.TIME,prefixes:L.NONE,value:86400,offset:0},week:{name:"week",base:D.TIME,prefixes:L.NONE,value:604800,offset:0},month:{name:"month",base:D.TIME,prefixes:L.NONE,value:2629800,offset:0},year:{name:"year",base:D.TIME,prefixes:L.NONE,value:31557600,offset:0},decade:{name:"year",base:D.TIME,prefixes:L.NONE,value:315576e3,offset:0},century:{name:"century",base:D.TIME,prefixes:L.NONE,value:315576e4,offset:0},millennium:{name:"millennium",base:D.TIME,prefixes:L.NONE,value:315576e5,offset:0},hertz:{name:"Hertz",base:D.FREQUENCY,prefixes:L.LONG,value:1,offset:0,reciprocal:!0},Hz:{name:"Hz",base:D.FREQUENCY,prefixes:L.SHORT,value:1,offset:0,reciprocal:!0},rad:{name:"rad",base:D.ANGLE,prefixes:L.LONG,value:1,offset:0},deg:{name:"deg",base:D.ANGLE,prefixes:L.LONG,value:null,offset:0},grad:{name:"grad",base:D.ANGLE,prefixes:L.LONG,value:null,offset:0},cycle:{name:"cycle",base:D.ANGLE,prefixes:L.NONE,value:null,offset:0},arcsec:{name:"arcsec",base:D.ANGLE,prefixes:L.NONE,value:null,offset:0},arcmin:{name:"arcmin",base:D.ANGLE,prefixes:L.NONE,value:null,offset:0},A:{name:"A",base:D.CURRENT,prefixes:L.SHORT,value:1,offset:0},ampere:{name:"ampere",base:D.CURRENT,prefixes:L.LONG,value:1,offset:0},K:{name:"K",base:D.TEMPERATURE,prefixes:L.NONE,value:1,offset:0},degC:{name:"degC",base:D.TEMPERATURE,prefixes:L.NONE,value:1,offset:273.15},degF:{name:"degF",base:D.TEMPERATURE,prefixes:L.NONE,value:1/1.8,offset:459.67},degR:{name:"degR",base:D.TEMPERATURE,prefixes:L.NONE,value:1/1.8,offset:0},kelvin:{name:"kelvin",base:D.TEMPERATURE,prefixes:L.NONE,value:1,offset:0},celsius:{name:"celsius",base:D.TEMPERATURE,prefixes:L.NONE,value:1,offset:273.15},fahrenheit:{name:"fahrenheit",base:D.TEMPERATURE,prefixes:L.NONE,value:1/1.8,offset:459.67},rankine:{name:"rankine",base:D.TEMPERATURE,prefixes:L.NONE,value:1/1.8,offset:0},mol:{name:"mol",base:D.AMOUNT_OF_SUBSTANCE,prefixes:L.SHORT,value:1,offset:0},mole:{name:"mole",base:D.AMOUNT_OF_SUBSTANCE,prefixes:L.LONG,value:1,offset:0},cd:{name:"cd",base:D.LUMINOUS_INTENSITY,prefixes:L.NONE,value:1,offset:0},candela:{name:"candela",base:D.LUMINOUS_INTENSITY,prefixes:L.NONE,value:1,offset:0},N:{name:"N",base:D.FORCE,prefixes:L.SHORT,value:1,offset:0},newton:{name:"newton",base:D.FORCE,prefixes:L.LONG,value:1,offset:0},dyn:{name:"dyn",base:D.FORCE,prefixes:L.SHORT,value:1e-5,offset:0},dyne:{name:"dyne",base:D.FORCE,prefixes:L.LONG,value:1e-5,offset:0},lbf:{name:"lbf",base:D.FORCE,prefixes:L.NONE,value:4.4482216152605,offset:0},poundforce:{name:"poundforce",base:D.FORCE,prefixes:L.NONE,value:4.4482216152605,offset:0},kip:{name:"kip",base:D.FORCE,prefixes:L.LONG,value:4448.2216,offset:0},J:{name:"J",base:D.ENERGY,prefixes:L.SHORT,value:1,offset:0},joule:{name:"joule",base:D.ENERGY,prefixes:L.SHORT,value:1,offset:0},erg:{name:"erg",base:D.ENERGY,prefixes:L.NONE,value:1e-7,offset:0},Wh:{name:"Wh",base:D.ENERGY,prefixes:L.SHORT,value:3600,offset:0},BTU:{name:"BTU",base:D.ENERGY,prefixes:L.BTU,value:1055.05585262,offset:0},eV:{name:"eV",base:D.ENERGY,prefixes:L.SHORT,value:1.602176565e-19,offset:0},electronvolt:{name:"electronvolt",base:D.ENERGY,prefixes:L.LONG,value:1.602176565e-19,offset:0},W:{name:"W",base:D.POWER,prefixes:L.SHORT,value:1,offset:0},watt:{name:"W",base:D.POWER,prefixes:L.LONG,value:1,offset:0},hp:{name:"hp",base:D.POWER,prefixes:L.NONE,value:745.6998715386,offset:0},VAR:{name:"VAR",base:D.POWER,prefixes:L.SHORT,value:B.I,offset:0},VA:{name:"VA",base:D.POWER,prefixes:L.SHORT,value:1,offset:0},Pa:{name:"Pa",base:D.PRESSURE,prefixes:L.SHORT,value:1,offset:0},psi:{name:"psi",base:D.PRESSURE,prefixes:L.NONE,value:6894.75729276459,offset:0},atm:{name:"atm",base:D.PRESSURE,prefixes:L.NONE,value:101325,offset:0},bar:{name:"bar",base:D.PRESSURE,prefixes:L.NONE,value:1e5,offset:0},torr:{name:"torr",base:D.PRESSURE,prefixes:L.NONE,value:133.322,offset:0},mmHg:{name:"mmHg",base:D.PRESSURE,prefixes:L.NONE,value:133.322,offset:0},mmH2O:{name:"mmH2O",base:D.PRESSURE,prefixes:L.NONE,value:9.80665,offset:0},cmH2O:{name:"cmH2O",base:D.PRESSURE,prefixes:L.NONE,value:98.0665,offset:0},coulomb:{name:"coulomb",base:D.ELECTRIC_CHARGE,prefixes:L.LONG,value:1,offset:0},C:{name:"C",base:D.ELECTRIC_CHARGE,prefixes:L.SHORT,value:1,offset:0},farad:{name:"farad",base:D.ELECTRIC_CAPACITANCE,prefixes:L.LONG,value:1,offset:0},F:{name:"F",base:D.ELECTRIC_CAPACITANCE,prefixes:L.SHORT,value:1,offset:0},volt:{name:"volt",base:D.ELECTRIC_POTENTIAL,prefixes:L.LONG,value:1,offset:0},V:{name:"V",base:D.ELECTRIC_POTENTIAL,prefixes:L.SHORT,value:1,offset:0},ohm:{name:"ohm",base:D.ELECTRIC_RESISTANCE,prefixes:L.SHORTLONG,value:1,offset:0},henry:{name:"henry",base:D.ELECTRIC_INDUCTANCE,prefixes:L.LONG,value:1,offset:0},H:{name:"H",base:D.ELECTRIC_INDUCTANCE,prefixes:L.SHORT,value:1,offset:0},siemens:{name:"siemens",base:D.ELECTRIC_CONDUCTANCE,prefixes:L.LONG,value:1,offset:0},S:{name:"S",base:D.ELECTRIC_CONDUCTANCE,prefixes:L.SHORT,value:1,offset:0},weber:{name:"weber",base:D.MAGNETIC_FLUX,prefixes:L.LONG,value:1,offset:0},Wb:{name:"Wb",base:D.MAGNETIC_FLUX,prefixes:L.SHORT,value:1,offset:0},tesla:{name:"tesla",base:D.MAGNETIC_FLUX_DENSITY,prefixes:L.LONG,value:1,offset:0},T:{name:"T",base:D.MAGNETIC_FLUX_DENSITY,prefixes:L.SHORT,value:1,offset:0},b:{name:"b",base:D.BIT,prefixes:L.BINARY_SHORT,value:1,offset:0},bits:{name:"bits",base:D.BIT,prefixes:L.BINARY_LONG,value:1,offset:0},B:{name:"B",base:D.BIT,prefixes:L.BINARY_SHORT,value:8,offset:0},bytes:{name:"bytes",base:D.BIT,prefixes:L.BINARY_LONG,value:8,offset:0}},Z={meters:"meter",inches:"inch",feet:"foot",yards:"yard",miles:"mile",links:"link",rods:"rod",chains:"chain",angstroms:"angstrom",lt:"l",litres:"litre",liter:"litre",liters:"litre",teaspoons:"teaspoon",tablespoons:"tablespoon",minims:"minim",fluiddrams:"fluiddram",fluidounces:"fluidounce",gills:"gill",cups:"cup",pints:"pint",quarts:"quart",gallons:"gallon",beerbarrels:"beerbarrel",oilbarrels:"oilbarrel",hogsheads:"hogshead",gtts:"gtt",grams:"gram",tons:"ton",tonnes:"tonne",grains:"grain",drams:"dram",ounces:"ounce",poundmasses:"poundmass",hundredweights:"hundredweight",sticks:"stick",lb:"lbm",lbs:"lbm",kips:"kip",acres:"acre",hectares:"hectare",sqfeet:"sqft",sqyard:"sqyd",sqmile:"sqmi",sqmiles:"sqmi",mmhg:"mmHg",mmh2o:"mmH2O",cmh2o:"cmH2O",seconds:"second",secs:"second",minutes:"minute",mins:"minute",hours:"hour",hr:"hour",hrs:"hour",days:"day",weeks:"week",months:"month",years:"year",hertz:"hertz",radians:"rad",degree:"deg",degrees:"deg",gradian:"grad",gradians:"grad",cycles:"cycle",arcsecond:"arcsec",arcseconds:"arcsec",arcminute:"arcmin",arcminutes:"arcmin",BTUs:"BTU",watts:"watt",joules:"joule",amperes:"ampere",coulombs:"coulomb",volts:"volt",ohms:"ohm",farads:"farad",webers:"weber",teslas:"tesla",electronvolts:"electronvolt",moles:"mole"};x(t),u.on("config",function(e,t){e.number!==t.number&&x(e)});var V={si:{NONE:{unit:$,prefix:L.NONE[""]},LENGTH:{unit:G.m,prefix:L.SHORT[""]},MASS:{unit:G.g,prefix:L.SHORT.k},TIME:{unit:G.s,prefix:L.SHORT[""]},CURRENT:{unit:G.A,prefix:L.SHORT[""]},TEMPERATURE:{unit:G.K,prefix:L.SHORT[""]},LUMINOUS_INTENSITY:{unit:G.cd,prefix:L.SHORT[""]},AMOUNT_OF_SUBSTANCE:{unit:G.mol,prefix:L.SHORT[""]},ANGLE:{unit:G.rad,prefix:L.SHORT[""]},BIT:{unit:G.bit,prefix:L.SHORT[""]},FORCE:{unit:G.N,prefix:L.SHORT[""]},ENERGY:{unit:G.J,prefix:L.SHORT[""]},POWER:{unit:G.W,prefix:L.SHORT[""]},PRESSURE:{unit:G.Pa,prefix:L.SHORT[""]},ELECTRIC_CHARGE:{unit:G.C,prefix:L.SHORT[""]},ELECTRIC_CAPACITANCE:{unit:G.F,prefix:L.SHORT[""]},ELECTRIC_POTENTIAL:{unit:G.V,prefix:L.SHORT[""]},ELECTRIC_RESISTANCE:{unit:G.ohm,prefix:L.SHORT[""]},ELECTRIC_INDUCTANCE:{unit:G.H,prefix:L.SHORT[""]},ELECTRIC_CONDUCTANCE:{unit:G.S,prefix:L.SHORT[""]},MAGNETIC_FLUX:{unit:G.Wb,prefix:L.SHORT[""]},MAGNETIC_FLUX_DENSITY:{unit:G.T,prefix:L.SHORT[""]},FREQUENCY:{unit:G.Hz,prefix:L.SHORT[""]}}};V.cgs=JSON.parse(JSON.stringify(V.si)),V.cgs.LENGTH={unit:G.m,prefix:L.SHORT.c},V.cgs.MASS={unit:G.g,prefix:L.SHORT[""]},V.cgs.FORCE={unit:G.dyn,prefix:L.SHORT[""]},V.cgs.ENERGY={unit:G.erg,prefix:L.NONE[""]},V.us=JSON.parse(JSON.stringify(V.si)),V.us.LENGTH={unit:G.ft,prefix:L.NONE[""]},V.us.MASS={unit:G.lbm,prefix:L.NONE[""]},V.us.TEMPERATURE={unit:G.degF,prefix:L.NONE[""]},V.us.FORCE={unit:G.lbf,prefix:L.NONE[""]},V.us.ENERGY={unit:G.BTU,prefix:L.BTU[""]},V.us.POWER={unit:G.hp,prefix:L.NONE[""]},V.us.PRESSURE={unit:G.psi,prefix:L.NONE[""]},V.auto=JSON.parse(JSON.stringify(V.si));var W=V.auto;c.setUnitSystem=function(e){if(!V.hasOwnProperty(e))throw new Error("Unit system "+e+" does not exist. Choices are: "+Object.keys(V).join(", "));W=V[e]},c.getUnitSystem=function(){for(var e in V)if(V[e]===W)return e},c.typeConverters={BigNumber:function(t){return new e.BigNumber(t+"")},Fraction:function(t){return new e.Fraction(t)},Complex:function(e){return e},number:function(e){return e}},c._getNumberConverter=function(e){if(!c.typeConverters[e])throw new TypeError('Unsupported type "'+e+'"');return c.typeConverters[e]};for(var j in G){var Y=G[j];Y.dimensions=Y.base.dimensions}for(var X in Z)if(Z.hasOwnProperty(X)){var Y=G[Z[X]],J={};for(var j in Y)Y.hasOwnProperty(j)&&(J[j]=Y[j]);J.name=X,G[X]=J}return c.createUnit=function(e,t){if("object"!=typeof e)throw new TypeError("createUnit expects first parameter to be of type 'Object'");if(t&&t.override)for(var r in e)if(e.hasOwnProperty(r)&&c.deleteUnit(r),e[r].aliases)for(var n=0;n<e[r].aliases.length;n++)c.deleteUnit(e[r].aliases[n]);var i;for(var r in e)e.hasOwnProperty(r)&&(i=c.createUnitSingle(r,e[r]));return i},c.createUnitSingle=function(e,t,r){if("undefined"!=typeof t&&null!==t||(t={}),"string"!=typeof e)throw new TypeError("createUnitSingle expects first parameter to be of type 'string'");if(G.hasOwnProperty(e))throw new Error('Cannot create unit "'+e+'": a unit with that name already exists');w(e);var n,i,a=null,o=[],s=0;if(t&&"Unit"===t.type)a=t.clone();else if("string"==typeof t)""!==t&&(n=t);else{if("object"!=typeof t)throw new TypeError('Cannot create unit "'+e+'" from "'+t.toString()+'": expecting "string" or "Unit" or "Object"');n=t.definition,i=t.prefixes,s=t.offset,t.aliases&&(o=t.aliases.valueOf())}if(o)for(var u=0;u<o.length;u++)if(G.hasOwnProperty(o[u]))throw new Error('Cannot create alias "'+o[u]+'": a unit with that name already exists');if(n&&"string"==typeof n&&!a)try{a=c.parse(n,{allowNoUnits:!0})}catch(t){throw t.message='Could not create unit "'+e+'" from "'+n+'": '+t.message,t}else n&&"Unit"===n.type&&(a=n.clone());o=o||[],s=s||0,i=i&&i.toUpperCase?L[i.toUpperCase()]||L.NONE:L.NONE;var f={};if(a){f={name:e,value:a.value,dimensions:a.dimensions.slice(0),prefixes:i,offset:s};var l=!1;for(var u in D)if(D.hasOwnProperty(u)){for(var p=!0,h=0;h<F.length;h++)if(Math.abs((f.dimensions[h]||0)-(D[u].dimensions[h]||0))>1e-12){p=!1;break}if(p){l=!0;break}}if(!l){var m=e+"_STUFF",d={dimensions:a.dimensions.slice(0)};d.key=m,D[m]=d,W[m]={unit:f,prefix:L.NONE[""]},f.base=m}}else{var m=e+"_STUFF";if(F.indexOf(m)>=0)throw new Error('Cannot create new base unit "'+e+'": a base unit with that name already exists (and cannot be overridden)');F.push(m);for(var v in D)D.hasOwnProperty(v)&&(D[v].dimensions[F.length-1]=0);for(var d={dimensions:[]},u=0;u<F.length;u++)d.dimensions[u]=0;d.dimensions[F.length-1]=1,d.key=m,D[m]=d,f={name:e,value:1,dimensions:D[m].dimensions.slice(0),prefixes:i,offset:s,base:m},W[m]={unit:f,prefix:L.NONE[""]}}c.UNITS[e]=f;for(var u=0;u<o.length;u++){var g=o[u],y={};for(var x in f)f.hasOwnProperty(x)&&(y[x]=f[x]);y.name=g,c.UNITS[g]=y}return new c(null,e)},c.deleteUnit=function(e){delete c.UNITS[e]},c.PREFIXES=L,c.BASE_DIMENSIONS=F,c.BASE_UNITS=D,c.UNIT_SYSTEMS=V,c.UNITS=G,c}var i=r(9).endsWith,a=r(5).clone,o=r(95);t.name="Unit",t.path="type",t.factory=n,t.math=!0},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("unit",{Unit:function(e){return e.clone()},string:function(t){return e.Unit.isValuelessUnit(t)?new e.Unit(null,t):e.Unit.parse(t)},"number | BigNumber | Fraction | Complex, string":function(t,r){return new e.Unit(t,r)},"Array | Matrix":function(e){return i(e,a)}});return a.toTex={1:"\\left(${args[0]}\\right)",2:"\\left(\\left(${args[0]}\\right)${args[1]}\\right)"},a}var i=r(1);t.name="unit",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var i=n("createUnit",{"Object, Object":function(t,r){return e.Unit.createUnit(t,r)},Object:function(t){return e.Unit.createUnit(t,{})},"string, Unit | string | Object, Object":function(t,r,n){var i={};return i[t]=r,e.Unit.createUnit(i,n)},"string, Unit | string | Object":function(t,r){var n={};return n[t]=r,e.Unit.createUnit(n,{})},string:function(t){var r={};return r[t]={},e.Unit.createUnit(r,{})}});return i}r(1);t.name="createUnit",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var i=n("splitUnit",{"Unit, Array":function(e,t){return e.splitUnit(t)}});return i}r(1);t.name="splitUnit",t.factory=n},function(e,t,r){function n(e,t,r,n,a){function o(t){var r=e.Unit.parse(t);return r.fixPrefix=!0,r}i(a,"speedOfLight",function(){return o("299792458 m s^-1")}),i(a,"gravitationConstant",function(){return o("6.6738480e-11 m^3 kg^-1 s^-2")}),i(a,"planckConstant",function(){return o("6.626069311e-34 J s")}),i(a,"reducedPlanckConstant",function(){return o("1.05457172647e-34 J s")}),i(a,"magneticConstant",function(){return o("1.2566370614e-6 N A^-2")}),i(a,"electricConstant",function(){return o("8.854187817e-12 F m^-1")}),i(a,"vacuumImpedance",function(){return o("376.730313461 ohm")}),i(a,"coulomb",function(){return o("8.9875517873681764e9 N m^2 C^-2")}),i(a,"elementaryCharge",function(){return o("1.60217656535e-19 C")}),i(a,"bohrMagneton",function(){return o("9.2740096820e-24 J T^-1")}),i(a,"conductanceQuantum",function(){return o("7.748091734625e-5 S")}),i(a,"inverseConductanceQuantum",function(){return o("12906.403721742 ohm")}),i(a,"magneticFluxQuantum",function(){return o("2.06783375846e-15 Wb")}),i(a,"nuclearMagneton",function(){return o("5.0507835311e-27 J T^-1")}),i(a,"klitzing",function(){return o("25812.807443484 ohm")}),i(a,"bohrRadius",function(){return o("5.291772109217e-11 m")}),i(a,"classicalElectronRadius",function(){return o("2.817940326727e-15 m")}),i(a,"electronMass",function(){return o("9.1093829140e-31 kg")}),i(a,"fermiCoupling",function(){return o("1.1663645e-5 GeV^-2")}),i(a,"fineStructure",function(){return.007297352569824}),i(a,"hartreeEnergy",function(){return o("4.3597443419e-18 J")}),i(a,"protonMass",function(){return o("1.67262177774e-27 kg")}),i(a,"deuteronMass",function(){return o("3.3435830926e-27 kg")}),i(a,"neutronMass",function(){return o("1.6749271613e-27 kg")}),i(a,"quantumOfCirculation",function(){return o("3.636947552024e-4 m^2 s^-1")}),i(a,"rydberg",function(){return o("10973731.56853955 m^-1")}),i(a,"thomsonCrossSection",function(){return o("6.65245873413e-29 m^2")}),i(a,"weakMixingAngle",function(){return.222321}),i(a,"efimovFactor",function(){return 22.7}),i(a,"atomicMass",function(){return o("1.66053892173e-27 kg")}),i(a,"avogadro",function(){return o("6.0221412927e23 mol^-1")}),i(a,"boltzmann",function(){return o("1.380648813e-23 J K^-1")}),i(a,"faraday",function(){return o("96485.336521 C mol^-1")}),i(a,"firstRadiation",function(){return o("3.7417715317e-16 W m^2")}),i(a,"loschmidt",function(){return o("2.686780524e25 m^-3")}),i(a,"gasConstant",function(){return o("8.314462175 J K^-1 mol^-1")}),i(a,"molarPlanckConstant",function(){return o("3.990312717628e-10 J s mol^-1")}),i(a,"molarVolume",function(){return o("2.241396820e-10 m^3 mol^-1")}),i(a,"sackurTetrode",function(){return-1.164870823}),i(a,"secondRadiation",function(){return o("1.438777013e-2 m K")}),i(a,"stefanBoltzmann",function(){
return o("5.67037321e-8 W m^-2 K^-4")}),i(a,"wienDisplacement",function(){return o("2.897772126e-3 m K")}),i(a,"molarMass",function(){return o("1e-3 kg mol^-1")}),i(a,"molarMassC12",function(){return o("1.2e-2 kg mol^-1")}),i(a,"gravity",function(){return o("9.80665 m s^-2")}),i(a,"planckLength",function(){return o("1.61619997e-35 m")}),i(a,"planckMass",function(){return o("2.1765113e-8 kg")}),i(a,"planckTime",function(){return o("5.3910632e-44 s")}),i(a,"planckCharge",function(){return o("1.87554595641e-18 C")}),i(a,"planckTemperature",function(){return o("1.41683385e+32 K")})}function i(e,t,r){a(e,t,r),a(e.expression.mathWithTransform,t,r)}var a=r(5).lazy;t.factory=n,t.lazy=!1,t.math=!0},function(e,t,r){"use strict";function n(e,t,o,u,c){c.on("config",function(r,i){r.number!==i.number&&n(e,t,o,u,c)}),i(c,"true",!0),i(c,"false",!1),i(c,"null",null),i(c,"uninitialized",r(2).UNINITIALIZED),"BigNumber"===t.number?(i(c,"Infinity",new e.BigNumber(1/0)),i(c,"NaN",new e.BigNumber(NaN)),a(c,"pi",function(){return s.pi(e.BigNumber)}),a(c,"tau",function(){return s.tau(e.BigNumber)}),a(c,"e",function(){return s.e(e.BigNumber)}),a(c,"phi",function(){return s.phi(e.BigNumber)}),a(c,"E",function(){return c.e}),a(c,"LN2",function(){return new e.BigNumber(2).ln()}),a(c,"LN10",function(){return new e.BigNumber(10).ln()}),a(c,"LOG2E",function(){return new e.BigNumber(1).div(new e.BigNumber(2).ln())}),a(c,"LOG10E",function(){return new e.BigNumber(1).div(new e.BigNumber(10).ln())}),a(c,"PI",function(){return c.pi}),a(c,"SQRT1_2",function(){return new e.BigNumber("0.5").sqrt()}),a(c,"SQRT2",function(){return new e.BigNumber(2).sqrt()})):(i(c,"Infinity",1/0),i(c,"NaN",NaN),i(c,"pi",Math.PI),i(c,"tau",2*Math.PI),i(c,"e",Math.E),i(c,"phi",1.618033988749895),i(c,"E",c.e),i(c,"LN2",Math.LN2),i(c,"LN10",Math.LN10),i(c,"LOG2E",Math.LOG2E),i(c,"LOG10E",Math.LOG10E),i(c,"PI",c.pi),i(c,"SQRT1_2",Math.SQRT1_2),i(c,"SQRT2",Math.SQRT2)),i(c,"i",e.Complex.I),i(c,"version",r(190))}function i(e,t,r){e[t]=r,e.expression.mathWithTransform[t]=r}function a(e,t,r){o.lazy(e,t,r),o.lazy(e.expression.mathWithTransform,t,r)}var o=r(5),s=r(95);t.factory=n,t.lazy=!1,t.math=!0},function(e,t){e.exports="3.16.3"},function(e,t,r){e.exports=[r(99),r(383),r(389),r(391),r(402),r(39),r(111)]},function(e,t){e.exports={name:"bignumber",category:"Construction",syntax:["bignumber(x)"],description:"Create a big number from a number or string.",examples:["0.1 + 0.2","bignumber(0.1) + bignumber(0.2)",'bignumber("7.2")','bignumber("7.2e500")',"bignumber([0.1, 0.2, 0.3])"],seealso:["boolean","complex","fraction","index","matrix","string","unit"]}},function(e,t){e.exports={name:"boolean",category:"Construction",syntax:["x","boolean(x)"],description:"Convert a string or number into a boolean.",examples:["boolean(0)","boolean(1)","boolean(3)",'boolean("true")','boolean("false")',"boolean([1, 0, 1, 1])"],seealso:["bignumber","complex","index","matrix","number","string","unit"]}},function(e,t){e.exports={name:"complex",category:"Construction",syntax:["complex()","complex(re, im)","complex(string)"],description:"Create a complex number.",examples:["complex()","complex(2, 3)",'complex("7 - 2i")'],seealso:["bignumber","boolean","index","matrix","number","string","unit"]}},function(e,t){e.exports={name:"createUnit",category:"Construction",syntax:["createUnit(definitions)","createUnit(name, definition)"],description:"Create a user-defined unit and register it with the Unit type.",examples:['createUnit("foo")','createUnit("knot", {definition: "0.514444444 m/s", aliases: ["knots", "kt", "kts"]})','createUnit("mph", "1 mile/hour")'],seealso:["unit","splitUnit"]}},function(e,t){e.exports={name:"fraction",category:"Construction",syntax:["fraction(num)","fraction(num,den)"],description:"Create a fraction from a number or from a numerator and denominator.",examples:["fraction(0.125)","fraction(1, 3) + fraction(2, 5)"],seealso:["bignumber","boolean","complex","index","matrix","string","unit"]}},function(e,t){e.exports={name:"index",category:"Construction",syntax:["[start]","[start:end]","[start:step:end]","[start1, start 2, ...]","[start1:end1, start2:end2, ...]","[start1:step1:end1, start2:step2:end2, ...]"],description:"Create an index to get or replace a subset of a matrix",examples:["[]","[1, 2, 3]","A = [1, 2, 3; 4, 5, 6]","A[1, :]","A[1, 2] = 50","A[0:2, 0:2] = ones(2, 2)"],seealso:["bignumber","boolean","complex","matrix,","number","range","string","unit"]}},function(e,t){e.exports={name:"matrix",category:"Construction",syntax:["[]","[a1, b1, ...; a2, b2, ...]","matrix()",'matrix("dense")',"matrix([...])"],description:"Create a matrix.",examples:["[]","[1, 2, 3]","[1, 2, 3; 4, 5, 6]","matrix()","matrix([3, 4])",'matrix([3, 4; 5, 6], "sparse")','matrix([3, 4; 5, 6], "sparse", "number")'],seealso:["bignumber","boolean","complex","index","number","string","unit","sparse"]}},function(e,t){e.exports={name:"number",category:"Construction",syntax:["x","number(x)"],description:"Create a number or convert a string or boolean into a number.",examples:["2","2e3","4.05","number(2)",'number("7.2")',"number(true)","number([true, false, true, true])",'number("52cm", "m")'],seealso:["bignumber","boolean","complex","fraction","index","matrix","string","unit"]}},function(e,t){e.exports={name:"sparse",category:"Construction",syntax:["sparse()","sparse([a1, b1, ...; a1, b2, ...])",'sparse([a1, b1, ...; a1, b2, ...], "number")'],description:"Create a sparse matrix.",examples:["sparse()","sparse([3, 4; 5, 6])",'sparse([3, 0; 5, 0], "number")'],seealso:["bignumber","boolean","complex","index","number","string","unit","matrix"]}},function(e,t){e.exports={name:"splitUnit",category:"Construction",syntax:["splitUnit(unit: Unit, parts: Unit[])"],description:"Split a unit in an array of units whose sum is equal to the original unit.",examples:['splitUnit(1 m, ["feet", "inch"])'],seealso:["unit","createUnit"]}},function(e,t){e.exports={name:"string",category:"Construction",syntax:['"text"',"string(x)"],description:"Create a string or convert a value to a string",examples:['"Hello World!"',"string(4.2)","string(3 + 2i)"],seealso:["bignumber","boolean","complex","index","matrix","number","unit"]}},function(e,t){e.exports={name:"unit",category:"Construction",syntax:["value unit","unit(value, unit)","unit(string)"],description:"Create a unit.",examples:["5.5 mm","3 inch",'unit(7.1, "kilogram")','unit("23 deg")'],seealso:["bignumber","boolean","complex","index","matrix","number","string"]}},function(e,t){e.exports={name:"false",category:"Constants",syntax:["false"],description:"Boolean value false",examples:["false"],seealso:["true"]}},function(e,t){e.exports={name:"i",category:"Constants",syntax:["i"],description:"Imaginary unit, defined as i*i=-1. A complex number is described as a + b*i, where a is the real part, and b is the imaginary part.",examples:["i","i * i","sqrt(-1)"],seealso:[]}},function(e,t){e.exports={name:"Infinity",category:"Constants",syntax:["Infinity"],description:"Infinity, a number which is larger than the maximum number that can be handled by a floating point number.",examples:["Infinity","1 / 0"],seealso:[]}},function(e,t){e.exports={name:"LN2",category:"Constants",syntax:["LN2"],description:"Returns the natural logarithm of 2, approximately equal to 0.693",examples:["LN2","log(2)"],seealso:[]}},function(e,t){e.exports={name:"LN10",category:"Constants",syntax:["LN10"],description:"Returns the natural logarithm of 10, approximately equal to 2.302",examples:["LN10","log(10)"],seealso:[]}},function(e,t){e.exports={name:"LOG2E",category:"Constants",syntax:["LOG2E"],description:"Returns the base-2 logarithm of E, approximately equal to 1.442",examples:["LOG2E","log(e, 2)"],seealso:[]}},function(e,t){e.exports={name:"LOG10E",category:"Constants",syntax:["LOG10E"],description:"Returns the base-10 logarithm of E, approximately equal to 0.434",examples:["LOG10E","log(e, 10)"],seealso:[]}},function(e,t){e.exports={name:"NaN",category:"Constants",syntax:["NaN"],description:"Not a number",examples:["NaN","0 / 0"],seealso:[]}},function(e,t){e.exports={name:"null",category:"Constants",syntax:["null"],description:"Value null",examples:["null"],seealso:["true","false"]}},function(e,t){e.exports={name:"phi",category:"Constants",syntax:["phi"],description:"Phi is the golden ratio. Two quantities are in the golden ratio if their ratio is the same as the ratio of their sum to the larger of the two quantities. Phi is defined as `(1 + sqrt(5)) / 2` and is approximately 1.618034...",examples:["tau"],seealso:[]}},function(e,t){e.exports={name:"SQRT1_2",category:"Constants",syntax:["SQRT1_2"],description:"Returns the square root of 1/2, approximately equal to 0.707",examples:["SQRT1_2","sqrt(1/2)"],seealso:[]}},function(e,t){e.exports={name:"SQRT2",category:"Constants",syntax:["SQRT2"],description:"Returns the square root of 2, approximately equal to 1.414",examples:["SQRT2","sqrt(2)"],seealso:[]}},function(e,t){e.exports={name:"tau",category:"Constants",syntax:["tau"],description:"Tau is the ratio constant of a circle's circumference to radius, equal to 2 * pi, approximately 6.2832.",examples:["tau","2 * pi"],seealso:["pi"]}},function(e,t){e.exports={name:"true",category:"Constants",syntax:["true"],description:"Boolean value true",examples:["true"],seealso:["false"]}},function(e,t){e.exports={name:"version",category:"Constants",syntax:["version"],description:"A string with the version number of math.js",examples:["version"],seealso:[]}},function(e,t){e.exports={name:"derivative",category:"Algebra",syntax:["derivative(expr)","derivative(expr, {simplify: boolean})"],description:"Takes the derivative of an expression expressed in parser Nodes. The derivative will be taken over the supplied variable in the second parameter. If there are multiple variables in the expression, it will return a partial derivative.",examples:['derivative("2x^3", "x")','derivative("2x^3", "x", {simplify: false})','derivative("2x^2 + 3x + 4", "x")','derivative("sin(2x)", "x")','f = parse("x^2 + x")','x = parse("x")',"df = derivative(f, x)","df.eval({x: 3})"],seealso:["simplify","parse","eval"]}},function(e,t){e.exports={name:"lsolve",category:"Algebra",syntax:["x=lsolve(L, b)"],description:"Solves the linear system L * x = b where L is an [n x n] lower triangular matrix and b is a [n] column vector.",examples:["a = [-2, 3; 2, 1]","b = [11, 9]","x = lsolve(a, b)"],seealso:["lup","lusolve","usolve","matrix","sparse"]}},function(e,t){e.exports={name:"lup",category:"Algebra",syntax:["lup(m)"],description:"Calculate the Matrix LU decomposition with partial pivoting. Matrix A is decomposed in three matrices (L, U, P) where P * A = L * U",examples:["lup([[2, 1], [1, 4]])","lup(matrix([[2, 1], [1, 4]]))","lup(sparse([[2, 1], [1, 4]]))"],seealso:["lusolve","lsolve","usolve","matrix","sparse","slu","qr"]}},function(e,t){e.exports={name:"lusolve",category:"Algebra",syntax:["x=lusolve(A, b)","x=lusolve(lu, b)"],description:"Solves the linear system A * x = b where A is an [n x n] matrix and b is a [n] column vector.",examples:["a = [-2, 3; 2, 1]","b = [11, 9]","x = lusolve(a, b)"],seealso:["lup","slu","lsolve","usolve","matrix","sparse"]}},function(e,t){e.exports={name:"simplify",category:"Algebra",syntax:["simplify(expr)","simplify(expr, rules)"],description:"Simplify an expression tree.",examples:['simplify("3 + 2 / 4")','simplify("2x + x")','f = parse("x * (x + 2 + x)")',"simplified = simplify(f)","simplified.eval({x: 2})"],seealso:["derivative","parse","eval"]}},function(e,t){e.exports={name:"slu",category:"Algebra",syntax:["slu(A, order, threshold)"],description:"Calculate the Matrix LU decomposition with full pivoting. Matrix A is decomposed in two matrices (L, U) and two permutation vectors (pinv, q) where P * A * Q = L * U",examples:["slu(sparse([4.5, 0, 3.2, 0; 3.1, 2.9, 0, 0.9; 0, 1.7, 3, 0; 3.5, 0.4, 0, 1]), 1, 0.001)"],seealso:["lusolve","lsolve","usolve","matrix","sparse","lup","qr"]}},function(e,t){e.exports={name:"usolve",category:"Algebra",syntax:["x=usolve(U, b)"],description:"Solves the linear system U * x = b where U is an [n x n] upper triangular matrix and b is a [n] column vector.",examples:["x=usolve(sparse([1, 1, 1, 1; 0, 1, 1, 1; 0, 0, 1, 1; 0, 0, 0, 1]), [1; 2; 3; 4])"],seealso:["lup","lusolve","lsolve","matrix","sparse"]}},function(e,t){e.exports={name:"qr",category:"Algebra",syntax:["qr(A)"],description:"Calculates the Matrix QR decomposition. Matrix `A` is decomposed in two matrices (`Q`, `R`) where `Q` is an orthogonal matrix and `R` is an upper triangular matrix.",examples:["qr([[1, -1,  4], [1,  4, -2], [1,  4,  2], [1,  -1, 0]])"],seealso:["lup","slu","matrix"]}},function(e,t){e.exports={name:"abs",category:"Arithmetic",syntax:["abs(x)"],description:"Compute the absolute value.",examples:["abs(3.5)","abs(-4.2)"],seealso:["sign"]}},function(e,t){e.exports={name:"add",category:"Operators",syntax:["x + y","add(x, y)"],description:"Add two values.",examples:["a = 2.1 + 3.6","a - 3.6","3 + 2i","3 cm + 2 inch",'"2.3" + "4"'],seealso:["subtract"]}},function(e,t){e.exports={name:"cbrt",category:"Arithmetic",syntax:["cbrt(x)","cbrt(x, allRoots)"],description:"Compute the cubic root value. If x = y * y * y, then y is the cubic root of x. When `x` is a number or complex number, an optional second argument `allRoots` can be provided to return all three cubic roots. If not provided, the principal root is returned",examples:["cbrt(64)","cube(4)","cbrt(-8)","cbrt(2 + 3i)","cbrt(8i)","cbrt(8i, true)","cbrt(27 m^3)"],seealso:["square","sqrt","cube","multiply"]}},function(e,t){e.exports={name:"ceil",category:"Arithmetic",syntax:["ceil(x)"],description:"Round a value towards plus infinity. If x is complex, both real and imaginary part are rounded towards plus infinity.",examples:["ceil(3.2)","ceil(3.8)","ceil(-4.2)"],seealso:["floor","fix","round"]}},function(e,t){e.exports={name:"cube",category:"Arithmetic",syntax:["cube(x)"],description:"Compute the cube of a value. The cube of x is x * x * x.",examples:["cube(2)","2^3","2 * 2 * 2"],seealso:["multiply","square","pow"]}},function(e,t){e.exports={name:"divide",category:"Operators",syntax:["x / y","divide(x, y)"],description:"Divide two values.",examples:["a = 2 / 3","a * 3","4.5 / 2","3 + 4 / 2","(3 + 4) / 2","18 km / 4.5"],seealso:["multiply"]}},function(e,t){e.exports={name:"dotDivide",category:"Operators",syntax:["x ./ y","dotDivide(x, y)"],description:"Divide two values element wise.",examples:["a = [1, 2, 3; 4, 5, 6]","b = [2, 1, 1; 3, 2, 5]","a ./ b"],seealso:["multiply","dotMultiply","divide"]}},function(e,t){e.exports={name:"dotMultiply",category:"Operators",syntax:["x .* y","dotMultiply(x, y)"],description:"Multiply two values element wise.",examples:["a = [1, 2, 3; 4, 5, 6]","b = [2, 1, 1; 3, 2, 5]","a .* b"],seealso:["multiply","divide","dotDivide"]}},function(e,t){e.exports={name:"dotpow",category:"Operators",syntax:["x .^ y","dotpow(x, y)"],description:"Calculates the power of x to y element wise.",examples:["a = [1, 2, 3; 4, 5, 6]","a .^ 2"],seealso:["pow"]}},function(e,t){e.exports={name:"exp",category:"Arithmetic",syntax:["exp(x)"],description:"Calculate the exponent of a value.",examples:["exp(1.3)","e ^ 1.3","log(exp(1.3))","x = 2.4","(exp(i*x) == cos(x) + i*sin(x))   # Euler's formula"],seealso:["pow","log"]}},function(e,t){e.exports={name:"fix",category:"Arithmetic",syntax:["fix(x)"],description:"Round a value towards zero. If x is complex, both real and imaginary part are rounded towards zero.",examples:["fix(3.2)","fix(3.8)","fix(-4.2)","fix(-4.8)"],seealso:["ceil","floor","round"]}},function(e,t){e.exports={name:"floor",category:"Arithmetic",syntax:["floor(x)"],description:"Round a value towards minus infinity.If x is complex, both real and imaginary part are rounded towards minus infinity.",examples:["floor(3.2)","floor(3.8)","floor(-4.2)"],seealso:["ceil","fix","round"]}},function(e,t){e.exports={name:"gcd",category:"Arithmetic",syntax:["gcd(a, b)","gcd(a, b, c, ...)"],description:"Compute the greatest common divisor.",examples:["gcd(8, 12)","gcd(-4, 6)","gcd(25, 15, -10)"],seealso:["lcm","xgcd"]}},function(e,t){e.exports={name:"hypot",category:"Arithmetic",syntax:["hypot(a, b, c, ...)","hypot([a, b, c, ...])"],description:"Calculate the hypotenusa of a list with values. ",examples:["hypot(3, 4)","sqrt(3^2 + 4^2)","hypot(-2)","hypot([3, 4, 5])"],seealso:["abs","norm"]}},function(e,t){e.exports={name:"lcm",category:"Arithmetic",syntax:["lcm(x, y)"],description:"Compute the least common multiple.",examples:["lcm(4, 6)","lcm(6, 21)","lcm(6, 21, 5)"],seealso:["gcd"]}},function(e,t){e.exports={name:"log",category:"Arithmetic",syntax:["log(x)","log(x, base)"],description:"Compute the logarithm of a value. If no base is provided, the natural logarithm of x is calculated. If base if provided, the logarithm is calculated for the specified base. log(x, base) is defined as log(x) / log(base).",examples:["log(3.5)","a = log(2.4)","exp(a)","10 ^ 4","log(10000, 10)","log(10000) / log(10)","b = log(1024, 2)","2 ^ b"],seealso:["exp","log10"]}},function(e,t){e.exports={name:"log10",category:"Arithmetic",syntax:["log10(x)"],description:"Compute the 10-base logarithm of a value.",examples:["log10(0.00001)","log10(10000)","10 ^ 4","log(10000) / log(10)","log(10000, 10)"],seealso:["exp","log"]}},function(e,t){e.exports={name:"mod",category:"Operators",syntax:["x % y","x mod y","mod(x, y)"],description:"Calculates the modulus, the remainder of an integer division.",examples:["7 % 3","11 % 2","10 mod 4","function isOdd(x) = x % 2","isOdd(2)","isOdd(3)"],seealso:["divide"]}},function(e,t){e.exports={name:"multiply",category:"Operators",syntax:["x * y","multiply(x, y)"],description:"multiply two values.",examples:["a = 2.1 * 3.4","a / 3.4","2 * 3 + 4","2 * (3 + 4)","3 * 2.1 km"],seealso:["divide"]}},function(e,t){e.exports={name:"norm",category:"Arithmetic",syntax:["norm(x)","norm(x, p)"],description:"Calculate the norm of a number, vector or matrix.",examples:["abs(-3.5)","norm(-3.5)","norm(3 - 4i))","norm([1, 2, -3], Infinity)","norm([1, 2, -3], -Infinity)","norm([3, 4], 2)","norm([[1, 2], [3, 4]], 1)","norm([[1, 2], [3, 4]], 'inf')","norm([[1, 2], [3, 4]], 'fro')"]}},function(e,t){e.exports={name:"nthRoot",category:"Arithmetic",syntax:["nthRoot(a)","nthRoot(a, root)"],description:'Calculate the nth root of a value. The principal nth root of a positive real number A, is the positive real solution of the equation "x^root = A".',examples:["4 ^ 3","nthRoot(64, 3)","nthRoot(9, 2)","sqrt(9)"],seealso:["sqrt","pow"]}},function(e,t){e.exports={name:"pow",category:"Operators",syntax:["x ^ y","pow(x, y)"],description:"Calculates the power of x to y, x^y.",examples:["2^3 = 8","2*2*2","1 + e ^ (pi * i)"],seealso:["multiply"]}},function(e,t){e.exports={name:"round",category:"Arithmetic",syntax:["round(x)","round(x, n)"],description:"round a value towards the nearest integer.If x is complex, both real and imaginary part are rounded towards the nearest integer. When n is specified, the value is rounded to n decimals.",examples:["round(3.2)","round(3.8)","round(-4.2)","round(-4.8)","round(pi, 3)","round(123.45678, 2)"],seealso:["ceil","floor","fix"]}},function(e,t){e.exports={name:"sign",category:"Arithmetic",syntax:["sign(x)"],description:"Compute the sign of a value. The sign of a value x is 1 when x>1, -1 when x<0, and 0 when x=0.",examples:["sign(3.5)","sign(-4.2)","sign(0)"],seealso:["abs"]}},function(e,t){e.exports={name:"sqrt",category:"Arithmetic",syntax:["sqrt(x)"],description:"Compute the square root value. If x = y * y, then y is the square root of x.",examples:["sqrt(25)","5 * 5","sqrt(-1)"],seealso:["square","multiply"]}},function(e,t){e.exports={name:"square",category:"Arithmetic",syntax:["square(x)"],description:"Compute the square of a value. The square of x is x * x.",examples:["square(3)","sqrt(9)","3^2","3 * 3"],seealso:["multiply","pow","sqrt","cube"]}},function(e,t){e.exports={name:"subtract",category:"Operators",syntax:["x - y","subtract(x, y)"],description:"subtract two values.",examples:["a = 5.3 - 2","a + 2","2/3 - 1/6","2 * 3 - 3","2.1 km - 500m"],seealso:["add"]}},function(e,t){e.exports={name:"unaryMinus",category:"Operators",syntax:["-x","unaryMinus(x)"],description:"Inverse the sign of a value. Converts booleans and strings to numbers.",examples:["-4.5","-(-5.6)",'-"22"'],seealso:["add","subtract","unaryPlus"]}},function(e,t){e.exports={name:"unaryPlus",category:"Operators",syntax:["+x","unaryPlus(x)"],description:"Converts booleans and strings to numbers.",examples:["+true",'+"2"'],seealso:["add","subtract","unaryMinus"]}},function(e,t){e.exports={name:"xgcd",category:"Arithmetic",syntax:["xgcd(a, b)"],description:"Calculate the extended greatest common divisor for two values",examples:["xgcd(8, 12)","gcd(8, 12)","xgcd(36163, 21199)"],seealso:["gcd","lcm"]}},function(e,t){e.exports={name:"bitAnd",category:"Bitwise",syntax:["x & y","bitAnd(x, y)"],description:"Bitwise AND operation. Performs the logical AND operation on each pair of the corresponding bits of the two given values by multiplying them. If both bits in the compared position are 1, the bit in the resulting binary representation is 1, otherwise, the result is 0",examples:["5 & 3","bitAnd(53, 131)","[1, 12, 31] & 42"],seealso:["bitNot","bitOr","bitXor","leftShift","rightArithShift","rightLogShift"]}},function(e,t){e.exports={name:"bitNot",category:"Bitwise",syntax:["~x","bitNot(x)"],description:"Bitwise NOT operation. Performs a logical negation on each bit of the given value. Bits that are 0 become 1, and those that are 1 become 0.",examples:["~1","~2","bitNot([2, -3, 4])"],seealso:["bitAnd","bitOr","bitXor","leftShift","rightArithShift","rightLogShift"]}},function(e,t){e.exports={name:"bitOr",category:"Bitwise",syntax:["x | y","bitOr(x, y)"],description:"Bitwise OR operation. Performs the logical inclusive OR operation on each pair of corresponding bits of the two given values. The result in each position is 1 if the first bit is 1 or the second bit is 1 or both bits are 1, otherwise, the result is 0.",examples:["5 | 3","bitOr([1, 2, 3], 4)"],seealso:["bitAnd","bitNot","bitXor","leftShift","rightArithShift","rightLogShift"]}},function(e,t){e.exports={name:"bitXor",category:"Bitwise",syntax:["bitXor(x, y)"],description:"Bitwise XOR operation, exclusive OR. Performs the logical exclusive OR operation on each pair of corresponding bits of the two given values. The result in each position is 1 if only the first bit is 1 or only the second bit is 1, but will be 0 if both are 0 or both are 1.",examples:["bitOr(1, 2)","bitXor([2, 3, 4], 4)"],seealso:["bitAnd","bitNot","bitOr","leftShift","rightArithShift","rightLogShift"]}},function(e,t){e.exports={name:"leftShift",category:"Bitwise",syntax:["x << y","leftShift(x, y)"],description:"Bitwise left logical shift of a value x by y number of bits.",examples:["4 << 1","8 >> 1"],seealso:["bitAnd","bitNot","bitOr","bitXor","rightArithShift","rightLogShift"]}},function(e,t){e.exports={name:"rightArithShift",category:"Bitwise",syntax:["x >> y","leftShift(x, y)"],description:"Bitwise right arithmetic shift of a value x by y number of bits.",examples:["8 >> 1","4 << 1","-12 >> 2"],seealso:["bitAnd","bitNot","bitOr","bitXor","leftShift","rightLogShift"]}},function(e,t){e.exports={name:"rightLogShift",category:"Bitwise",syntax:["x >> y","leftShift(x, y)"],description:"Bitwise right logical shift of a value x by y number of bits.",examples:["8 >>> 1","4 << 1","-12 >>> 2"],seealso:["bitAnd","bitNot","bitOr","bitXor","leftShift","rightArithShift"]}},function(e,t){e.exports={name:"bellNumbers",category:"Combinatorics",syntax:["bellNumbers(n)"],description:"The Bell Numbers count the number of partitions of a set. A partition is a pairwise disjoint subset of S whose union is S. `bellNumbers` only takes integer arguments. The following condition must be enforced: n >= 0.",examples:["bellNumbers(3)","bellNumbers(8)"],seealso:["stirlingS2"]}},function(e,t){e.exports={name:"catalan",category:"Combinatorics",syntax:["catalan(n)"],description:"The Catalan Numbers enumerate combinatorial structures of many different types. catalan only takes integer arguments. The following condition must be enforced: n >= 0.",examples:["catalan(3)","catalan(8)"],seealso:["bellNumbers"]}},function(e,t){e.exports={name:"composition",category:"Combinatorics",syntax:["composition(n, k)"],description:"The composition counts of n into k parts. composition only takes integer arguments. The following condition must be enforced: k <= n.",examples:["composition(5, 3)"],seealso:["combinations"]}},function(e,t){e.exports={name:"stirlingS2",category:"Combinatorics",syntax:["stirlingS2(n, k)"],description:"he Stirling numbers of the second kind, counts the number of ways to partition a set of n labelled objects into k nonempty unlabelled subsets. `stirlingS2` only takes integer arguments. The following condition must be enforced: k <= n. If n = k or k = 1, then s(n,k) = 1.",examples:["stirlingS2(5, 3)"],seealso:["bellNumbers"]}},function(e,t){e.exports={name:"config",category:"Core",syntax:["config()","config(options)"],description:"Get configuration or change configuration.",examples:["config()","1/3 + 1/4",'config({number: "Fraction"})',"1/3 + 1/4"],seealso:[]}},function(e,t){e.exports={name:"import",category:"Core",syntax:["import(functions)","import(functions, options)"],description:"Import functions or constants from an object.",examples:["import({myFn: f(x)=x^2, myConstant: 32 })","myFn(2)","myConstant"],seealso:[]}},function(e,t){e.exports={name:"typed",category:"Core",syntax:["typed(signatures)","typed(name, signatures)"],description:"Create a typed function.",examples:['double = typed({ "number, number": f(x)=x+x })',"double(2)",'double("hello")'],seealso:[]}},function(e,t){e.exports={name:"arg",category:"Complex",syntax:["arg(x)"],description:"Compute the argument of a complex value. If x = a+bi, the argument is computed as atan2(b, a).",examples:["arg(2 + 2i)","atan2(3, 2)","arg(2 + 3i)"],seealso:["re","im","conj","abs"]}},function(e,t){e.exports={name:"conj",category:"Complex",syntax:["conj(x)"],description:"Compute the complex conjugate of a complex value. If x = a+bi, the complex conjugate is a-bi.",examples:["conj(2 + 3i)","conj(2 - 3i)","conj(-5.2i)"],seealso:["re","im","abs","arg"]}},function(e,t){e.exports={name:"re",category:"Complex",syntax:["re(x)"],description:"Get the real part of a complex number.",examples:["re(2 + 3i)","im(2 + 3i)","re(-5.2i)","re(2.4)"],seealso:["im","conj","abs","arg"]}},function(e,t){e.exports={name:"im",category:"Complex",syntax:["im(x)"],description:"Get the imaginary part of a complex number.",examples:["im(2 + 3i)","re(2 + 3i)","im(-5.2i)","im(2.4)"],seealso:["re","conj","abs","arg"]}},function(e,t){e.exports={name:"eval",category:"Expression",syntax:["eval(expression)","eval([expr1, expr2, expr3, ...])"],description:"Evaluate an expression or an array with expressions.",examples:['eval("2 + 3")','eval("sqrt(" + 4 + ")")'],seealso:[]}},function(e,t){e.exports={name:"help",category:"Expression",syntax:["help(object)","help(string)"],description:"Display documentation on a function or data type.",examples:["help(sqrt)",'help("complex")'],seealso:[]}},function(e,t){e.exports={name:"distance",category:"Geometry",syntax:["distance([x1, y1], [x2, y2])","distance([[x1, y1], [x2, y2])"],description:"Calculates the Euclidean distance between two points.",examples:["distance([0,0], [4,4])","distance([[0,0], [4,4]])"],seealso:[]}},function(e,t){e.exports={name:"intersect",category:"Geometry",syntax:["intersect(expr1, expr2, expr3, expr4)","intersect(expr1, expr2, expr3)"],description:"Computes the intersection point of lines and/or planes.",examples:["intersect([0, 0], [10, 10], [10, 0], [0, 10])","intersect([1, 0, 1],  [4, -2, 2], [1, 1, 1, 6])"],seealso:[]}},function(e,t){e.exports={name:"and",category:"Logical",syntax:["x and y","and(x, y)"],description:"Logical and. Test whether two values are both defined with a nonzero/nonempty value.",examples:["true and false","true and true","2 and 4"],seealso:["not","or","xor"]}},function(e,t){e.exports={name:"not",category:"Logical",syntax:["not x","not(x)"],description:"Logical not. Flips the boolean value of given argument.",examples:["not true","not false","not 2","not 0"],seealso:["and","or","xor"]}},function(e,t){e.exports={name:"or",category:"Logical",syntax:["x or y","or(x, y)"],description:"Logical or. Test if at least one value is defined with a nonzero/nonempty value.",examples:["true or false","false or false","0 or 4"],seealso:["not","and","xor"]}},function(e,t){e.exports={name:"xor",category:"Logical",syntax:["x or y","or(x, y)"],description:"Logical exclusive or, xor. Test whether one and only one value is defined with a nonzero/nonempty value.",examples:["true xor false","false xor false","true xor true","0 or 4"],seealso:["not","and","or"]}},function(e,t){e.exports={name:"concat",category:"Matrix",syntax:["concat(A, B, C, ...)","concat(A, B, C, ..., dim)"],description:"Concatenate matrices. By default, the matrices are concatenated by the last dimension. The dimension on which to concatenate can be provided as last argument.",examples:["A = [1, 2; 5, 6]","B = [3, 4; 7, 8]","concat(A, B)","concat(A, B, 1)","concat(A, B, 2)"],seealso:["det","diag","eye","inv","ones","range","size","squeeze","subset","trace","transpose","zeros"]}},function(e,t){e.exports={name:"cross",category:"Matrix",syntax:["cross(A, B)"],description:"Calculate the cross product for two vectors in three dimensional space.",examples:["cross([1, 1, 0],  [0, 1, 1])","cross([3, -3, 1], [4, 9, 2])","cross([2, 3, 4],  [5, 6, 7])"],seealso:["multiply","dot"]}},function(e,t){e.exports={name:"det",category:"Matrix",syntax:["det(x)"],description:"Calculate the determinant of a matrix",examples:["det([1, 2; 3, 4])","det([-2, 2, 3; -1, 1, 3; 2, 0, -1])"],seealso:["concat","diag","eye","inv","ones","range","size","squeeze","subset","trace","transpose","zeros"]}},function(e,t){e.exports={name:"diag",category:"Matrix",syntax:["diag(x)","diag(x, k)"],description:"Create a diagonal matrix or retrieve the diagonal of a matrix. When x is a vector, a matrix with the vector values on the diagonal will be returned. When x is a matrix, a vector with the diagonal values of the matrix is returned. When k is provided, the k-th diagonal will be filled in or retrieved, if k is positive, the values are placed on the super diagonal. When k is negative, the values are placed on the sub diagonal.",examples:["diag(1:3)","diag(1:3, 1)","a = [1, 2, 3; 4, 5, 6; 7, 8, 9]","diag(a)"],seealso:["concat","det","eye","inv","ones","range","size","squeeze","subset","trace","transpose","zeros"]}},function(e,t){e.exports={name:"dot",category:"Matrix",syntax:["dot(A, B)"],description:"Calculate the dot product of two vectors. The dot product of A = [a1, a2, a3, ..., an] and B = [b1, b2, b3, ..., bn] is defined as dot(A, B) = a1 * b1 + a2 * b2 + a3 * b3 + ... + an * bn",examples:["dot([2, 4, 1], [2, 2, 3])","[2, 4, 1] * [2, 2, 3]"],seealso:["multiply","cross"]}},function(e,t){e.exports={name:"eye",category:"Matrix",syntax:["eye(n)","eye(m, n)","eye([m, n])","eye"],description:"Returns the identity matrix with size m-by-n. The matrix has ones on the diagonal and zeros elsewhere.",examples:["eye(3)","eye(3, 5)","a = [1, 2, 3; 4, 5, 6]","eye(size(a))"],seealso:["concat","det","diag","inv","ones","range","size","squeeze","subset","trace","transpose","zeros"]}},function(e,t){e.exports={name:"filter",category:"Matrix",syntax:["filter(x, test)"],description:"Filter items in a matrix.",examples:["isPositive(x) = x > 0","filter([6, -2, -1, 4, 3], isPositive)","filter([6, -2, 0, 1, 0], x != 0)"],seealso:["sort","map","forEach"]}},function(e,t){e.exports={name:"flatten",category:"Matrix",syntax:["flatten(x)"],description:"Flatten a multi dimensional matrix into a single dimensional matrix.",
examples:["a = [1, 2, 3; 4, 5, 6]","size(a)","b = flatten(a)","size(b)"],seealso:["concat","resize","size","squeeze"]}},function(e,t){e.exports={name:"forEach",category:"Matrix",syntax:["forEach(x, callback)"],description:"Iterates over all elements of a matrix/array, and executes the given callback function.",examples:["forEach([1, 2, 3], function(val) { console.log(val) })"],seealso:["map","sort","filter"]}},function(e,t){e.exports={name:"inv",category:"Matrix",syntax:["inv(x)"],description:"Calculate the inverse of a matrix",examples:["inv([1, 2; 3, 4])","inv(4)","1 / 4"],seealso:["concat","det","diag","eye","ones","range","size","squeeze","subset","trace","transpose","zeros"]}},function(e,t){e.exports={name:"kron",category:"Matrix",syntax:["math.kron(x, y)"],description:"Calculates the kronecker product of 2 matrices or vectors.",examples:["kron([[1, 0], [0, 1]], [[1, 2], [3, 4]])","kron([1,1], [2,3,4])"],seealso:["multiply","dot","cross"]}},function(e,t){e.exports={name:"map",category:"Matrix",syntax:["map(x, callback)"],description:"Create a new matrix or array with the results of the callback function executed on each entry of the matrix/array.",examples:["map([1, 2, 3], function(val) { return value * value })"],seealso:["filter","forEach"]}},function(e,t){e.exports={name:"ones",category:"Matrix",syntax:["ones(m)","ones(m, n)","ones(m, n, p, ...)","ones([m])","ones([m, n])","ones([m, n, p, ...])","ones"],description:"Create a matrix containing ones.",examples:["ones(3)","ones(3, 5)","ones([2,3]) * 4.5","a = [1, 2, 3; 4, 5, 6]","ones(size(a))"],seealso:["concat","det","diag","eye","inv","range","size","squeeze","subset","trace","transpose","zeros"]}},function(e,t){e.exports={name:"partitionSelect",category:"Matrix",syntax:["partitionSelect(x, k)","partitionSelect(x, k, compare)"],description:"Partition-based selection of an array or 1D matrix. Will find the kth smallest value, and mutates the input array. Uses Quickselect.",examples:["partitionSelect([5, 10, 1], 2)",'partitionSelect(["C", "B", "A", "D"], 1)'],seealso:["sort"]}},function(e,t){e.exports={name:"range",category:"Type",syntax:["start:end","start:step:end","range(start, end)","range(start, end, step)","range(string)"],description:"Create a range. Lower bound of the range is included, upper bound is excluded.",examples:["1:5","3:-1:-3","range(3, 7)","range(0, 12, 2)",'range("4:10")',"a = [1, 2, 3, 4; 5, 6, 7, 8]","a[1:2, 1:2]"],seealso:["concat","det","diag","eye","inv","ones","size","squeeze","subset","trace","transpose","zeros"]}},function(e,t){e.exports={name:"resize",category:"Matrix",syntax:["resize(x, size)","resize(x, size, defaultValue)"],description:"Resize a matrix.",examples:["resize([1,2,3,4,5], [3])","resize([1,2,3], [5])","resize([1,2,3], [5], -1)","resize(2, [2, 3])",'resize("hello", [8], "!")'],seealso:["size","subset","squeeze","reshape"]}},function(e,t){e.exports={name:"reshape",category:"Matrix",syntax:["reshape(x, sizes)"],description:"Reshape a multi dimensional array to fit the specified dimensions.",examples:["reshape([1, 2, 3, 4, 5, 6], [2, 3])","reshape([[1, 2], [3, 4]], [1, 4])","reshape([[1, 2], [3, 4]], [4])"],seealso:["size","squeeze","resize"]}},function(e,t){e.exports={name:"size",category:"Matrix",syntax:["size(x)"],description:"Calculate the size of a matrix.",examples:["size(2.3)",'size("hello world")',"a = [1, 2; 3, 4; 5, 6]","size(a)","size(1:6)"],seealso:["concat","det","diag","eye","inv","ones","range","squeeze","subset","trace","transpose","zeros"]}},function(e,t){e.exports={name:"sort",category:"Matrix",syntax:["sort(x)","sort(x, compare)"],description:'Sort the items in a matrix. Compare can be a string "asc", "desc", "natural", or a custom sort function.',examples:["sort([5, 10, 1])",'sort(["C", "B", "A", "D"])',"sortByLength(a, b) = size(a)[1] - size(b)[1]",'sort(["Langdon", "Tom", "Sara"], sortByLength)','sort(["10", "1", "2"], "natural")'],seealso:["map","filter","forEach"]}},function(e,t){e.exports={name:"squeeze",category:"Matrix",syntax:["squeeze(x)"],description:"Remove inner and outer singleton dimensions from a matrix.",examples:["a = zeros(3,2,1)","size(squeeze(a))","b = zeros(1,1,3)","size(squeeze(b))"],seealso:["concat","det","diag","eye","inv","ones","range","size","subset","trace","transpose","zeros"]}},function(e,t){e.exports={name:"subset",category:"Matrix",syntax:["value(index)","value(index) = replacement","subset(value, [index])","subset(value, [index], replacement)"],description:"Get or set a subset of a matrix or string. Indexes are one-based. Both the ranges lower-bound and upper-bound are included.",examples:["d = [1, 2; 3, 4]","e = []","e[1, 1:2] = [5, 6]","e[2, :] = [7, 8]","f = d * e","f[2, 1]","f[:, 1]"],seealso:["concat","det","diag","eye","inv","ones","range","size","squeeze","trace","transpose","zeros"]}},function(e,t){e.exports={name:"trace",category:"Matrix",syntax:["trace(A)"],description:"Calculate the trace of a matrix: the sum of the elements on the main diagonal of a square matrix.",examples:["A = [1, 2, 3; -1, 2, 3; 2, 0, 3]","trace(A)"],seealso:["concat","det","diag","eye","inv","ones","range","size","squeeze","subset","transpose","zeros"]}},function(e,t){e.exports={name:"transpose",category:"Matrix",syntax:["x'","transpose(x)"],description:"Transpose a matrix",examples:["a = [1, 2, 3; 4, 5, 6]","a'","transpose(a)"],seealso:["concat","det","diag","eye","inv","ones","range","size","squeeze","subset","trace","zeros"]}},function(e,t){e.exports={name:"zeros",category:"Matrix",syntax:["zeros(m)","zeros(m, n)","zeros(m, n, p, ...)","zeros([m])","zeros([m, n])","zeros([m, n, p, ...])","zeros"],description:"Create a matrix containing zeros.",examples:["zeros(3)","zeros(3, 5)","a = [1, 2, 3; 4, 5, 6]","zeros(size(a))"],seealso:["concat","det","diag","eye","inv","ones","range","size","squeeze","subset","trace","transpose"]}},function(e,t){e.exports={name:"combinations",category:"Probability",syntax:["combinations(n, k)"],description:"Compute the number of combinations of n items taken k at a time",examples:["combinations(7, 5)"],seealso:["permutations","factorial"]}},function(e,t){e.exports={name:"factorial",category:"Probability",syntax:["kldivergence(x, y)"],description:"Compute the factorial of a value",examples:["5!","5 * 4 * 3 * 2 * 1","3!"],seealso:["combinations","permutations","gamma"]}},function(e,t){e.exports={name:"gamma",category:"Probability",syntax:["gamma(n)"],description:"Compute the gamma function. For small values, the Lanczos approximation is used, and for large values the extended Stirling approximation.",examples:["gamma(4)","3!","gamma(1/2)","sqrt(pi)"],seealso:["factorial"]}},function(e,t){e.exports={name:"kldivergence",category:"Probability",syntax:["n!","factorial(n)"],description:"Calculate the Kullback-Leibler (KL) divergence  between two distributions.",examples:["math.kldivergence([0.7,0.5,0.4], [0.2,0.9,0.5])"],seealso:[]}},function(e,t){e.exports={name:"multinomial",category:"Probability",syntax:["multinomial(A)"],description:"Multinomial Coefficients compute the number of ways of picking a1, a2, ..., ai unordered outcomes from `n` possibilities. multinomial takes one array of integers as an argument. The following condition must be enforced: every ai <= 0.",examples:["multinomial([1, 2, 1])"],seealso:["combinations","factorial"]}},function(e,t){e.exports={name:"permutations",category:"Probability",syntax:["permutations(n)","permutations(n, k)"],description:"Compute the number of permutations of n items taken k at a time",examples:["permutations(5)","permutations(5, 3)"],seealso:["combinations","factorial"]}},function(e,t){e.exports={name:"pickRandom",category:"Probability",syntax:["pickRandom(array)","pickRandom(array, number)","pickRandom(array, weights)","pickRandom(array, number, weights)","pickRandom(array, weights, number)"],description:"Pick a random entry from a given array.",examples:["pickRandom(0:10)","pickRandom([1, 3, 1, 6])","pickRandom([1, 3, 1, 6], 2)","pickRandom([1, 3, 1, 6], [2, 3, 2, 1])","pickRandom([1, 3, 1, 6], 2, [2, 3, 2, 1])","pickRandom([1, 3, 1, 6], [2, 3, 2, 1], 2)"],seealso:["random","randomInt"]}},function(e,t){e.exports={name:"random",category:"Probability",syntax:["random()","random(max)","random(min, max)","random(size)","random(size, max)","random(size, min, max)"],description:"Return a random number.",examples:["random()","random(10, 20)","random([2, 3])"],seealso:["pickRandom","randomInt"]}},function(e,t){e.exports={name:"randInt",category:"Probability",syntax:["randInt(max)","randInt(min, max)","randInt(size)","randInt(size, max)","randInt(size, min, max)"],description:"Return a random integer number",examples:["randInt(10, 20)","randInt([2, 3], 10)"],seealso:["pickRandom","random"]}},function(e,t){e.exports={name:"compare",category:"Relational",syntax:["compare(x, y)"],description:"Compare two values. Returns 1 if x is larger than y, -1 if x is smaller than y, and 0 if x and y are equal.",examples:["compare(2, 3)","compare(3, 2)","compare(2, 2)","compare(5cm, 40mm)","compare(2, [1, 2, 3])"],seealso:["equal","unequal","smaller","smallerEq","largerEq","compareNatural"]}},function(e,t){e.exports={name:"compareNatural",category:"Relational",syntax:["compareNatural(x, y)"],description:"Compare two values of any type in a deterministic, natural way.",examples:["compare(2, 3)","compare(3, 2)","compare(2, 2)","compare(5cm, 40mm)",'compare("2", "10")',"compare(2 + 3i, 2 + 4i)","compare([1, 2, 4], [1, 2, 3])","compare([1, 5], [1, 2, 3])","compare([1, 2], [1, 2])","compare({a: 2}, {a: 4})"],seealso:["equal","unequal","smaller","smallerEq","largerEq","compare"]}},function(e,t){e.exports={name:"deepEqual",category:"Relational",syntax:["deepEqual(x, y)"],description:"Check equality of two matrices element wise. Returns true if the size of both matrices is equal and when and each of the elements are equal.",examples:["[1,3,4] == [1,3,4]","[1,3,4] == [1,3]"],seealso:["equal","unequal","smaller","larger","smallerEq","largerEq","compare"]}},function(e,t){e.exports={name:"equal",category:"Relational",syntax:["x == y","equal(x, y)"],description:"Check equality of two values. Returns true if the values are equal, and false if not.",examples:["2+2 == 3","2+2 == 4","a = 3.2","b = 6-2.8","a == b","50cm == 0.5m"],seealso:["unequal","smaller","larger","smallerEq","largerEq","compare","deepEqual"]}},function(e,t){e.exports={name:"larger",category:"Relational",syntax:["x > y","larger(x, y)"],description:"Check if value x is larger than y. Returns true if x is larger than y, and false if not.",examples:["2 > 3","5 > 2*2","a = 3.3","b = 6-2.8","(a > b)","(b < a)","5 cm > 2 inch"],seealso:["equal","unequal","smaller","smallerEq","largerEq","compare"]}},function(e,t){e.exports={name:"largerEq",category:"Relational",syntax:["x >= y","largerEq(x, y)"],description:"Check if value x is larger or equal to y. Returns true if x is larger or equal to y, and false if not.",examples:["2 > 1+1","2 >= 1+1","a = 3.2","b = 6-2.8","(a > b)"],seealso:["equal","unequal","smallerEq","smaller","largerEq","compare"]}},function(e,t){e.exports={name:"smaller",category:"Relational",syntax:["x < y","smaller(x, y)"],description:"Check if value x is smaller than value y. Returns true if x is smaller than y, and false if not.",examples:["2 < 3","5 < 2*2","a = 3.3","b = 6-2.8","(a < b)","5 cm < 2 inch"],seealso:["equal","unequal","larger","smallerEq","largerEq","compare"]}},function(e,t){e.exports={name:"smallerEq",category:"Relational",syntax:["x <= y","smallerEq(x, y)"],description:"Check if value x is smaller or equal to value y. Returns true if x is smaller than y, and false if not.",examples:["2 < 1+1","2 <= 1+1","a = 3.2","b = 6-2.8","(a < b)"],seealso:["equal","unequal","larger","smaller","largerEq","compare"]}},function(e,t){e.exports={name:"unequal",category:"Relational",syntax:["x != y","unequal(x, y)"],description:"Check unequality of two values. Returns true if the values are unequal, and false if they are equal.",examples:["2+2 != 3","2+2 != 4","a = 3.2","b = 6-2.8","a != b","50cm != 0.5m","5 cm != 2 inch"],seealso:["equal","smaller","larger","smallerEq","largerEq","compare","deepEqual"]}},function(e,t){e.exports={name:"setCartesian",category:"Set",syntax:["setCartesian(set1, set2)"],description:"Create the cartesian product of two (multi)sets. Multi-dimension arrays will be converted to single-dimension arrays before the operation.",examples:["setCartesian([1, 2], [3, 4])"],seealso:["setUnion","setIntersect","setDifference","setPowerset"]}},function(e,t){e.exports={name:"setDifference",category:"Set",syntax:["setDifference(set1, set2)"],description:"Create the difference of two (multi)sets: every element of set1, that is not the element of set2. Multi-dimension arrays will be converted to single-dimension arrays before the operation.",examples:["setDifference([1, 2, 3, 4], [3, 4, 5, 6])","setDifference([[1, 2], [3, 4]], [[3, 4], [5, 6]])"],seealso:["setUnion","setIntersect","setSymDifference"]}},function(e,t){e.exports={name:"setDistinct",category:"Set",syntax:["setDistinct(set)"],description:"Collect the distinct elements of a multiset. A multi-dimension array will be converted to a single-dimension array before the operation.",examples:["setDistinct([1, 1, 1, 2, 2, 3])"],seealso:["setMultiplicity"]}},function(e,t){e.exports={name:"setIntersect",category:"Set",syntax:["setIntersect(set1, set2)"],description:"Create the intersection of two (multi)sets. Multi-dimension arrays will be converted to single-dimension arrays before the operation.",examples:["setIntersect([1, 2, 3, 4], [3, 4, 5, 6])","setIntersect([[1, 2], [3, 4]], [[3, 4], [5, 6]])"],seealso:["setUnion","setDifference"]}},function(e,t){e.exports={name:"setIsSubset",category:"Set",syntax:["setIsSubset(set1, set2)"],description:"Check whether a (multi)set is a subset of another (multi)set: every element of set1 is the element of set2. Multi-dimension arrays will be converted to single-dimension arrays before the operation.",examples:["setIsSubset([1, 2], [3, 4, 5, 6])","setIsSubset([3, 4], [3, 4, 5, 6])"],seealso:["setUnion","setIntersect","setDifference"]}},function(e,t){e.exports={name:"setMultiplicity",category:"Set",syntax:["setMultiplicity(element, set)"],description:"Count the multiplicity of an element in a multiset. A multi-dimension array will be converted to a single-dimension array before the operation.",examples:["setMultiplicity(1, [1, 2, 2, 4])","setMultiplicity(2, [1, 2, 2, 4])"],seealso:["setDistinct","setSize"]}},function(e,t){e.exports={name:"setPowerset",category:"Set",syntax:["setPowerset(set)"],description:"Create the powerset of a (multi)set: the powerset contains very possible subsets of a (multi)set. A multi-dimension array will be converted to a single-dimension array before the operation.",examples:["setPowerset([1, 2, 3])"],seealso:["setCartesian"]}},function(e,t){e.exports={name:"setSize",category:"Set",syntax:["setSize(set)","setSize(set, unique)"],description:'Count the number of elements of a (multi)set. When the second parameter "unique" is true, count only the unique values. A multi-dimension array will be converted to a single-dimension array before the operation.',examples:["setSize([1, 2, 2, 4])","setSize([1, 2, 2, 4], true)"],seealso:["setUnion","setIntersect","setDifference"]}},function(e,t){e.exports={name:"setSymDifference",category:"Set",syntax:["setSymDifference(set1, set2)"],description:"Create the symmetric difference of two (multi)sets. Multi-dimension arrays will be converted to single-dimension arrays before the operation.",examples:["setSymDifference([1, 2, 3, 4], [3, 4, 5, 6])","setSymDifference([[1, 2], [3, 4]], [[3, 4], [5, 6]])"],seealso:["setUnion","setIntersect","setDifference"]}},function(e,t){e.exports={name:"setUnion",category:"Set",syntax:["setUnion(set1, set2)"],description:"Create the union of two (multi)sets. Multi-dimension arrays will be converted to single-dimension arrays before the operation.",examples:["setUnion([1, 2, 3, 4], [3, 4, 5, 6])","setUnion([[1, 2], [3, 4]], [[3, 4], [5, 6]])"],seealso:["setIntersect","setDifference"]}},function(e,t){e.exports={name:"erf",category:"Special",syntax:["erf(x)"],description:"Compute the erf function of a value using a rational Chebyshev approximations for different intervals of x",examples:["erf(0.2)","erf(-0.5)","erf(4)"],seealso:[]}},function(e,t){e.exports={name:"mad",category:"Statistics",syntax:["mad(a, b, c, ...)","mad(A)"],description:"Compute the median absolute deviation of a matrix or a list with values. The median absolute deviation is defined as the median of the absolute deviations from the median.",examples:["mad(10, 20, 30)","mad([1, 2, 3])","mad(10, 20, 30)"],seealso:["mean","median","std","abs"]}},function(e,t){e.exports={name:"max",category:"Statistics",syntax:["max(a, b, c, ...)","max(A)","max(A, dim)"],description:"Compute the maximum value of a list of values.",examples:["max(2, 3, 4, 1)","max([2, 3, 4, 1])","max([2, 5; 4, 3])","max([2, 5; 4, 3], 1)","max([2, 5; 4, 3], 2)","max(2.7, 7.1, -4.5, 2.0, 4.1)","min(2.7, 7.1, -4.5, 2.0, 4.1)"],seealso:["mean","median","min","prod","std","sum","var"]}},function(e,t){e.exports={name:"mean",category:"Statistics",syntax:["mean(a, b, c, ...)","mean(A)","mean(A, dim)"],description:"Compute the arithmetic mean of a list of values.",examples:["mean(2, 3, 4, 1)","mean([2, 3, 4, 1])","mean([2, 5; 4, 3])","mean([2, 5; 4, 3], 1)","mean([2, 5; 4, 3], 2)","mean([1.0, 2.7, 3.2, 4.0])"],seealso:["max","median","min","prod","std","sum","var"]}},function(e,t){e.exports={name:"median",category:"Statistics",syntax:["median(a, b, c, ...)","median(A)"],description:"Compute the median of all values. The values are sorted and the middle value is returned. In case of an even number of values, the average of the two middle values is returned.",examples:["median(5, 2, 7)","median([3, -1, 5, 7])"],seealso:["max","mean","min","prod","std","sum","var","quantileSeq"]}},function(e,t){e.exports={name:"min",category:"Statistics",syntax:["min(a, b, c, ...)","min(A)","min(A, dim)"],description:"Compute the minimum value of a list of values.",examples:["min(2, 3, 4, 1)","min([2, 3, 4, 1])","min([2, 5; 4, 3])","min([2, 5; 4, 3], 1)","min([2, 5; 4, 3], 2)","min(2.7, 7.1, -4.5, 2.0, 4.1)","max(2.7, 7.1, -4.5, 2.0, 4.1)"],seealso:["max","mean","median","prod","std","sum","var"]}},function(e,t){e.exports={name:"mode",category:"Statistics",syntax:["mode(a, b, c, ...)","mode(A)","mode(A, a, b, B, c, ...)"],description:"Computes the mode of all values as an array. In case mode being more than one, multiple values are returned in an array.",examples:["mode(5, 2, 7)","mode([3, -1, 5, 7])"],seealso:["max","mean","min","median","prod","std","sum","var"]}},function(e,t){e.exports={name:"prod",category:"Statistics",syntax:["prod(a, b, c, ...)","prod(A)"],description:"Compute the product of all values.",examples:["prod(2, 3, 4)","prod([2, 3, 4])","prod([2, 5; 4, 3])"],seealso:["max","mean","min","median","min","std","sum","var"]}},function(e,t){e.exports={name:"quantileSeq",category:"Statistics",syntax:["quantileSeq(A, prob[, sorted])","quantileSeq(A, [prob1, prob2, ...][, sorted])","quantileSeq(A, N[, sorted])"],description:"Compute the prob order quantile of a matrix or a list with values. The sequence is sorted and the middle value is returned. Supported types of sequence values are: Number, BigNumber, Unit Supported types of probablity are: Number, BigNumber. \n\nIn case of a (multi dimensional) array or matrix, the prob order quantile of all elements will be calculated.",examples:["quantileSeq([3, -1, 5, 7], 0.5)","quantileSeq([3, -1, 5, 7], [1/3, 2/3])","quantileSeq([3, -1, 5, 7], 2)","quantileSeq([-1, 3, 5, 7], 0.5, true)"],seealso:["mean","median","min","max","prod","std","sum","var"]}},function(e,t){e.exports={name:"std",category:"Statistics",syntax:["std(a, b, c, ...)","std(A)","std(A, normalization)"],description:'Compute the standard deviation of all values, defined as std(A) = sqrt(var(A)). Optional parameter normalization can be "unbiased" (default), "uncorrected", or "biased".',examples:["std(2, 4, 6)","std([2, 4, 6, 8])",'std([2, 4, 6, 8], "uncorrected")','std([2, 4, 6, 8], "biased")',"std([1, 2, 3; 4, 5, 6])"],seealso:["max","mean","min","median","min","prod","sum","var"]}},function(e,t){e.exports={name:"sum",category:"Statistics",syntax:["sum(a, b, c, ...)","sum(A)"],description:"Compute the sum of all values.",examples:["sum(2, 3, 4, 1)","sum([2, 3, 4, 1])","sum([2, 5; 4, 3])"],seealso:["max","mean","median","min","prod","std","sum","var"]}},function(e,t){e.exports={name:"var",category:"Statistics",syntax:["var(a, b, c, ...)","var(A)","var(A, normalization)"],description:'Compute the variance of all values. Optional parameter normalization can be "unbiased" (default), "uncorrected", or "biased".',examples:["var(2, 4, 6)","var([2, 4, 6, 8])",'var([2, 4, 6, 8], "uncorrected")','var([2, 4, 6, 8], "biased")',"var([1, 2, 3; 4, 5, 6])"],seealso:["max","mean","min","median","min","prod","std","sum"]}},function(e,t){e.exports={name:"acos",category:"Trigonometry",syntax:["acos(x)"],description:"Compute the inverse cosine of a value in radians.",examples:["acos(0.5)","acos(cos(2.3))"],seealso:["cos","atan","asin"]}},function(e,t){e.exports={name:"acosh",category:"Trigonometry",syntax:["acosh(x)"],description:"Calculate the hyperbolic arccos of a value, defined as `acosh(x) = ln(sqrt(x^2 - 1) + x)`.",examples:["acosh(1.5)"],seealso:["cosh","asinh","atanh"]}},function(e,t){e.exports={name:"acot",category:"Trigonometry",syntax:["acot(x)"],description:"Calculate the inverse cotangent of a value.",examples:["acot(0.5)","acot(cot(0.5))","acot(2)"],seealso:["cot","atan"]}},function(e,t){e.exports={name:"acoth",category:"Trigonometry",syntax:["acoth(x)"],description:"Calculate the hyperbolic arccotangent of a value, defined as `acoth(x) = (ln((x+1)/x) + ln(x/(x-1))) / 2`.",examples:["acoth(0.5)"],seealso:["acsch","asech"]}},function(e,t){e.exports={name:"acsc",category:"Trigonometry",syntax:["acsc(x)"],description:"Calculate the inverse cotangent of a value.",examples:["acsc(0.5)","acsc(csc(0.5))","acsc(2)"],seealso:["csc","asin","asec"]}},function(e,t){e.exports={name:"acsch",category:"Trigonometry",syntax:["acsch(x)"],description:"Calculate the hyperbolic arccosecant of a value, defined as `acsch(x) = ln(1/x + sqrt(1/x^2 + 1))`.",examples:["acsch(0.5)"],seealso:["asech","acoth"]}},function(e,t){e.exports={name:"asec",category:"Trigonometry",syntax:["asec(x)"],description:"Calculate the inverse secant of a value.",examples:["asec(0.5)","asec(sec(0.5))","asec(2)"],seealso:["acos","acot","acsc"]}},function(e,t){e.exports={name:"asech",category:"Trigonometry",syntax:["asech(x)"],description:"Calculate the inverse secant of a value.",examples:["asech(0.5)"],seealso:["acsch","acoth"]}},function(e,t){e.exports={name:"asin",category:"Trigonometry",syntax:["asin(x)"],description:"Compute the inverse sine of a value in radians.",examples:["asin(0.5)","asin(sin(2.3))"],seealso:["sin","acos","atan"]}},function(e,t){e.exports={name:"asinh",category:"Trigonometry",syntax:["asinh(x)"],description:"Calculate the hyperbolic arcsine of a value, defined as `asinh(x) = ln(x + sqrt(x^2 + 1))`.",examples:["asinh(0.5)"],seealso:["acosh","atanh"]}},function(e,t){e.exports={name:"atan",category:"Trigonometry",syntax:["atan(x)"],description:"Compute the inverse tangent of a value in radians.",examples:["atan(0.5)","atan(tan(2.3))"],seealso:["tan","acos","asin"]}},function(e,t){e.exports={name:"atanh",category:"Trigonometry",syntax:["atanh(x)"],description:"Calculate the hyperbolic arctangent of a value, defined as `atanh(x) = ln((1 + x)/(1 - x)) / 2`.",examples:["atanh(0.5)"],seealso:["acosh","asinh"]}},function(e,t){e.exports={name:"atan2",category:"Trigonometry",syntax:["atan2(y, x)"],description:"Computes the principal value of the arc tangent of y/x in radians.",examples:["atan2(2, 2) / pi","angle = 60 deg in rad","x = cos(angle)","y = sin(angle)","atan2(y, x)"],seealso:["sin","cos","tan"]}},function(e,t){e.exports={name:"cos",category:"Trigonometry",syntax:["cos(x)"],description:"Compute the cosine of x in radians.",examples:["cos(2)","cos(pi / 4) ^ 2","cos(180 deg)","cos(60 deg)","sin(0.2)^2 + cos(0.2)^2"],seealso:["acos","sin","tan"]}},function(e,t){e.exports={name:"cosh",category:"Trigonometry",syntax:["cosh(x)"],description:"Compute the hyperbolic cosine of x in radians.",examples:["cosh(0.5)"],seealso:["sinh","tanh","coth"]}},function(e,t){e.exports={name:"cot",category:"Trigonometry",syntax:["cot(x)"],description:"Compute the cotangent of x in radians. Defined as 1/tan(x)",examples:["cot(2)","1 / tan(2)"],seealso:["sec","csc","tan"]}},function(e,t){e.exports={name:"coth",category:"Trigonometry",syntax:["coth(x)"],description:"Compute the hyperbolic cotangent of x in radians.",examples:["coth(2)","1 / tanh(2)"],seealso:["sech","csch","tanh"]}},function(e,t){e.exports={name:"csc",category:"Trigonometry",syntax:["csc(x)"],description:"Compute the cosecant of x in radians. Defined as 1/sin(x)",examples:["csc(2)","1 / sin(2)"],seealso:["sec","cot","sin"]}},function(e,t){e.exports={name:"csch",category:"Trigonometry",syntax:["csch(x)"],description:"Compute the hyperbolic cosecant of x in radians. Defined as 1/sinh(x)",examples:["csch(2)","1 / sinh(2)"],seealso:["sech","coth","sinh"]}},function(e,t){e.exports={name:"sec",category:"Trigonometry",syntax:["sec(x)"],description:"Compute the secant of x in radians. Defined as 1/cos(x)",examples:["sec(2)","1 / cos(2)"],seealso:["cot","csc","cos"]}},function(e,t){e.exports={name:"sech",category:"Trigonometry",syntax:["sech(x)"],description:"Compute the hyperbolic secant of x in radians. Defined as 1/cosh(x)",examples:["sech(2)","1 / cosh(2)"],seealso:["coth","csch","cosh"]}},function(e,t){e.exports={name:"sin",category:"Trigonometry",syntax:["sin(x)"],description:"Compute the sine of x in radians.",examples:["sin(2)","sin(pi / 4) ^ 2","sin(90 deg)","sin(30 deg)","sin(0.2)^2 + cos(0.2)^2"],seealso:["asin","cos","tan"]}},function(e,t){e.exports={name:"sinh",category:"Trigonometry",syntax:["sinh(x)"],description:"Compute the hyperbolic sine of x in radians.",examples:["sinh(0.5)"],seealso:["cosh","tanh"]}},function(e,t){e.exports={name:"tan",category:"Trigonometry",syntax:["tan(x)"],description:"Compute the tangent of x in radians.",examples:["tan(0.5)","sin(0.5) / cos(0.5)","tan(pi / 4)","tan(45 deg)"],seealso:["atan","sin","cos"]}},function(e,t){e.exports={name:"tanh",category:"Trigonometry",syntax:["tanh(x)"],description:"Compute the hyperbolic tangent of x in radians.",examples:["tanh(0.5)","sinh(0.5) / cosh(0.5)"],seealso:["sinh","cosh"]}},function(e,t){e.exports={name:"to",category:"Units",syntax:["x to unit","to(x, unit)"],description:"Change the unit of a value.",examples:["5 inch to cm","3.2kg to g","16 bytes in bits"],seealso:[]}},function(e,t){e.exports={name:"clone",category:"Utils",syntax:["clone(x)"],description:"Clone a variable. Creates a copy of primitive variables,and a deep copy of matrices",examples:["clone(3.5)","clone(2 - 4i)","clone(45 deg)","clone([1, 2; 3, 4])",'clone("hello world")'],seealso:[]}},function(e,t){e.exports={name:"format",category:"Utils",syntax:["format(value)","format(value, precision)"],description:"Format a value of any type as string.",examples:["format(2.3)","format(3 - 4i)","format([])","format(pi, 3)"],seealso:["print"]}},function(e,t){e.exports={name:"isNaN",category:"Utils",syntax:["isNaN(x)"],description:"Test whether a value is NaN (not a number)",examples:["isNaN(2)","isNaN(0 / 0)","isNaN(NaN)","isNaN(Infinity)"],seealso:["isNegative","isNumeric","isPositive","isZero"]}},function(e,t){e.exports={name:"isInteger",category:"Utils",syntax:["isInteger(x)"],description:"Test whether a value is an integer number.",examples:["isInteger(2)","isInteger(3.5)","isInteger([3, 0.5, -2])"],seealso:["isNegative","isNumeric","isPositive","isZero"]}},function(e,t){e.exports={name:"isNegative",category:"Utils",syntax:["isNegative(x)"],description:"Test whether a value is negative: smaller than zero.",examples:["isNegative(2)","isNegative(0)","isNegative(-4)","isNegative([3, 0.5, -2])"],seealso:["isInteger","isNumeric","isPositive","isZero"]}},function(e,t){e.exports={name:"isNumeric",category:"Utils",syntax:["isNumeric(x)"],description:"Test whether a value is a numeric value. Returns true when the input is a number, BigNumber, Fraction, or boolean.",examples:["isNumeric(2)","isNumeric(0)","isNumeric(bignumber(500))","isNumeric(fraction(0.125))",'isNumeric("3")',"isNumeric(2 + 3i)",'isNumeric([2.3, "foo", false])'],seealso:["isInteger","isZero","isNegative","isPositive","isNaN"]}},function(e,t){e.exports={name:"isPositive",category:"Utils",syntax:["isPositive(x)"],description:"Test whether a value is positive: larger than zero.",examples:["isPositive(2)","isPositive(0)","isPositive(-4)","isPositive([3, 0.5, -2])"],seealso:["isInteger","isNumeric","isNegative","isZero"]}},function(e,t){e.exports={name:"isPrime",category:"Utils",syntax:["isPrime(x)"],description:"Test whether a value is prime: has no divisors other than itself and one.",examples:["isPrime(3)","isPrime(-2)","isPrime([2, 17, 100])"],seealso:["isInteger","isNumeric","isNegative","isZero"]}},function(e,t){e.exports={name:"isZero",category:"Utils",syntax:["isZero(x)"],description:"Test whether a value is zero.",examples:["isZero(2)","isZero(0)","isZero(-4)","isZero([3, 0, -2, 0])"],seealso:["isInteger","isNumeric","isNegative","isPositive"]}},function(e,t){e.exports={name:"typeof",category:"Utils",syntax:["typeof(x)"],description:"Get the type of a variable.",examples:["typeof(3.5)","typeof(2 - 4i)","typeof(45 deg)",'typeof("hello world")'],seealso:[]}},function(e,t,r){e.exports=[r(384),r(386),r(387),r(388),r(110)]},function(e,t,r){"use strict";function n(e,t,n,a){var o=n(r(39));return a("compile",{string:function(e){return o(e).compile()},"Array | Matrix":function(e){return i(e,function(e){return o(e).compile()})}})}var i=r(1);t.name="compile",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,o){var s=n(r(22)),u=n(r(0));return function(e,t,r){try{if(Array.isArray(e))return u(e).subset(t,r).valueOf();if(e&&"function"==typeof e.subset)return e.subset(t,r);if("string"==typeof e)return s(e,t,r);if("object"==typeof e){if(!t.isObjectProperty())throw TypeError("Cannot apply a numeric index as object property");return a(e,t.getObjectProperty(),r),e}throw new TypeError("Cannot apply index: unsupported type of object")}catch(e){throw i(e)}}}var i=r(41).transform,a=r(13).setSafeProperty;t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){var o=n(r(39));return a("compile",{string:function(e){var t={};return o(e).compile().eval(t)},"string, Object":function(e,t){return o(e).compile().eval(t)},"Array | Matrix":function(e){var t={};return i(e,function(e){return o(e).compile().eval(t)})},"Array | Matrix, Object":function(e,t){return i(e,function(e){return o(e).compile().eval(t)})}})}var i=r(1);t.name="eval",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a,o){var s=n(r(99));return a("help",{any:function(t){var r,n=t;if("string"!=typeof t)for(r in o)if(o.hasOwnProperty(r)&&t===o[r]){n=r;break}var a=i(s,n);if(!a)throw new Error('No documentation found on "'+n+'"');return new e.Help(a)}})}var i=r(13).getSafeProperty;t.math=!0,t.name="help",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,i){var a=n(r(39));return i("parse",{"string | Array | Matrix":a,"string | Array | Matrix, Object":a})}t.name="parse",t.factory=n},function(e,t,r){e.exports=[r(102),r(80),r(104),r(105),r(106),r(53),r(78),r(107),r(54),r(14),r(109),r(62),r(63),r(79),r(40),r(390)]},function(e,t,r){"use strict";function n(e,t,r,n){function i(){throw new Error("UpdateNode is deprecated. Use AssignmentNode instead.")}return i}t.name="UpdateNode",t.path="expression.node",t.factory=n},function(e,t,r){e.exports=[r(392),r(393),r(394),r(395),r(396),r(397),r(398),r(399),r(400),r(401)];
},function(e,t,r){"use strict";function n(e,t,n,a){var o=n(r(64));return a("concat",{"...any":function(t){var r=t.length-1,n=t[r];e.isNumber(n)?t[r]=n-1:e.isBigNumber(n)&&(t[r]=n.minus(1));try{return o.apply(null,t)}catch(e){throw i(e)}}})}var i=r(41).transform;t.name="concat",t.path="expression.transform",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){function s(t,r,n){var i,a;return t[0]&&(i=t[0].compile().eval(n)),t[1]&&(a=e.isSymbolNode(t[1])||e.isFunctionAssignmentNode(t[1])?t[1].compile().eval(n):u(t[1],r,n)),f(i,a)}var u=n(r(81)),c=n(r(0));s.rawArgs=!0;var f=a("filter",{"Array, function":i,"Matrix, function":function(e,t){return c(i(e.toArray(),t))},"Array, RegExp":o,"Matrix, RegExp":function(e,t){return c(o(e.toArray(),t))}});return f.toTex=void 0,s}function i(e,t){var r=s(t);return a(e,function(e,n,i){return 1===r?t(e):2===r?t(e,[n+1]):t(e,[n+1],i)})}var a=r(2).filter,o=r(2).filterRegExp,s=r(32).maxArgumentCount;t.name="filter",t.path="expression.transform",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,o){function s(t,r,n){var i,a;return t[0]&&(i=t[0].compile().eval(n)),t[1]&&(a=e.isSymbolNode(t[1])||e.isFunctionAssignmentNode(t[1])?t[1].compile().eval(n):u(t[1],r,n)),c(i,a)}var u=n(r(81));s.rawArgs=!0;var c=o("forEach",{"Array | Matrix, function":function(e,t){var r=i(t),n=function(i,o){Array.isArray(i)?a(i,function(e,t){n(e,o.concat(t+1))}):1===r?t(i):2===r?t(i,o):t(i,o,e)};n(e.valueOf(),[])}});return s}var i=r(32).maxArgumentCount,a=r(2).forEach;t.name="forEach",t.path="expression.transform",t.factory=n},function(e,t,r){"use strict";function n(e,t,r){return function(){for(var t=[],r=0,n=arguments.length;r<n;r++){var i=arguments[r];if(e.isRange(i))i.start--,i.end-=i.step>0?0:2;else if(i&&i.isSet===!0)i=i.map(function(e){return e-1});else if(e.isArray(i)||e.isMatrix(i))i=i.map(function(e){return e-1});else if(e.isNumber(i))i--;else if(e.isBigNumber(i))i=i.toNumber()-1;else if("string"!=typeof i)throw new TypeError("Dimension must be an Array, Matrix, number, string, or Range");t[r]=i}var a=new e.Index;return e.Index.apply(a,t),a}}t.name="index",t.path="expression.transform",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){function o(t,r,n){var i,a;return t[0]&&(i=t[0].compile().eval(n)),t[1]&&(a=e.isSymbolNode(t[1])||e.isFunctionAssignmentNode(t[1])?t[1].compile().eval(n):s(t[1],r,n)),c(i,a)}var s=n(r(81)),u=n(r(0));o.rawArgs=!0;var c=a("map",{"Array, function":function(e,t){return i(e,t,e)},"Matrix, function":function(e,t){return u(i(e.valueOf(),t,e))}});return o}function i(e,t,r){function n(e,a){return Array.isArray(e)?o(e,function(e,t){return n(e,a.concat(t+1))}):1===i?t(e):2===i?t(e,a):t(e,a,r)}var i=a(t);return n(e,[])}var a=r(32).maxArgumentCount,o=r(2).map;t.name="map",t.path="expression.transform",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,o){var s=n(r(112));return o("max",{"...any":function(t){if(2==t.length&&a(t[0])){var r=t[1];e.isNumber(r)?t[1]=r-1:e.isBigNumber(r)&&(t[1]=r.minus(1))}try{return s.apply(null,t)}catch(e){throw i(e)}}})}var i=r(41).transform,a=r(46);t.name="max",t.path="expression.transform",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,o){var s=n(r(113));return o("mean",{"...any":function(t){if(2==t.length&&a(t[0])){var r=t[1];e.isNumber(r)?t[1]=r-1:e.isBigNumber(r)&&(t[1]=r.minus(1))}try{return s.apply(null,t)}catch(e){throw i(e)}}})}var i=r(41).transform,a=r(46);t.name="mean",t.path="expression.transform",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,o){var s=n(r(116));return o("min",{"...any":function(t){if(2==t.length&&a(t[0])){var r=t[1];e.isNumber(r)?t[1]=r-1:e.isBigNumber(r)&&(t[1]=r.minus(1))}try{return s.apply(null,t)}catch(e){throw i(e)}}})}var i=r(41).transform,a=r(46);t.name="min",t.path="expression.transform",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,i){var a=n(r(117));return i("range",{"...any":function(e){var t=e.length-1,r=e[t];return"boolean"!=typeof r&&e.push(!0),a.apply(null,e)}})}t.name="range",t.path="expression.transform",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){var o=n(r(22));return a("subset",{"...any":function(e){try{return o.apply(null,e)}catch(e){throw i(e)}}})}var i=r(41).transform;t.name="subset",t.path="expression.transform",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,o){function s(e){if(!(this instanceof s))throw new SyntaxError("Constructor must be called with the new operator");if(!e)throw new Error('Argument "doc" missing');this.doc=e}var u=n(r(110))();return s.prototype.type="Help",s.prototype.isHelp=!0,s.prototype.toString=function(){var t=this.doc||{},r="\n";if(t.name&&(r+="Name: "+t.name+"\n\n"),t.category&&(r+="Category: "+t.category+"\n\n"),t.description&&(r+="Description:\n    "+t.description+"\n\n"),t.syntax&&(r+="Syntax:\n    "+t.syntax.join("\n    ")+"\n\n"),t.examples){r+="Examples:\n";for(var n=0;n<t.examples.length;n++){var i=t.examples[n];r+="    "+i+"\n";var o;try{o=u.eval(i)}catch(e){o=e}o&&!e.isHelp(o)&&(r+="        "+a.format(o,{precision:14})+"\n")}r+="\n"}return t.seealso&&(r+="See also: "+t.seealso.join(", ")+"\n"),r},s.prototype.toJSON=function(){var e=i.clone(this.doc);return e.mathjs="Help",e},s.fromJSON=function(e){var t={};for(var r in e)"mathjs"!==r&&(t[r]=e[r]);return new s(t)},s.prototype.valueOf=s.prototype.toString,s}var i=r(5),a=r(9);t.name="Help",t.path="type",t.factory=n},function(e,t,r){e.exports=[r(404),r(425),r(444),r(457),r(461),r(465),r(468),r(472),r(485),r(495),r(498),r(506),r(508),r(514),r(516),r(541),r(543)]},function(e,t,r){e.exports=[r(405),r(118),r(409),r(124),r(125),r(130),r(423),r(131)]},function(e,t,r){"use strict";function n(e,t,n,i){function a(e){if("log"!=e.name&&"nthRoot"!=e.name||2!=e.args.length){for(var t=0;t<e.args.length;++t)e.args[t]=new u(0);throw e.compile().eval(),new Error("Expected TypeError, but none found")}}var o=n(r(39)),s=n(r(118)),u=n(r(53)),c=n(r(54)),f=n(r(62)),l=n(r(63)),p=n(r(40)),h=i("derivative",{"Node, SymbolNode, Object":function(e,t,r){var n={};d(n,e,t.name);var i=v(e,n);return r.simplify?s(i):i},"Node, SymbolNode":function(e,t){return h(e,t,{simplify:!0})},"string, SymbolNode":function(e,t){return h(o(e),t)},"string, SymbolNode, Object":function(e,t,r){return h(o(e),t,r)},"string, string":function(e,t){return h(o(e),o(t))},"string, string, Object":function(e,t,r){return h(o(e),o(t),r)},"Node, string":function(e,t){return h(e,o(t))},"Node, string, Object":function(e,t,r){return h(e,o(t),r)}});h._simplify=!0,h.toTex=function(e){return m.apply(null,e.args)};var m=i("_derivTex",{"Node, SymbolNode":function(e,t){return m(e.toString(),t.toString(),1)},"Node, SymbolNode, ConstantNode":function(e,t,r){return m(e.toString(),t.name,r.value)},"string, string, number":function(e,t,r){var n;return n=1===r?"{d\\over d"+t+"}":"{d^{"+r+"}\\over d"+t+"^{"+r+"}}",n+"\\left["+e+"\\right]"}}),d=i("constTag",{"Object, ConstantNode, string":function(e,t){return e[t]=!0},"Object, SymbolNode, string":function(e,t,r){return t.name!=r&&(e[t]=!0)},"Object, ParenthesisNode, string":function(e,t,r){return d(e,t.content,r)},"Object, FunctionAssignmentNode, string":function(e,t,r){return t.params.indexOf(r)==-1?e[t]=!0:d(e,t.expr,r)},"Object, FunctionNode | OperatorNode, string":function(e,t,r){if(0!=t.args.length){for(var n=d(e,t.args[0],r),i=1;i<t.args.length;++i)n=d(e,t.args[i],r)&&n;if(n)return e[t]=!0}return!1}}),v=i("_derivative",{"ConstantNode, Object":function(e){return new u("0",e.valueType)},"SymbolNode, Object":function(e,r){return void 0!==r[e]?new u("0",t.number):new u("1",t.number)},"ParenthesisNode, Object":function(e,t){return new l(v(e.content,t))},"FunctionAssignmentNode, Object":function(e,r){return void 0!==r[e]?new u("0",t.number):v(e.expr,r)},"FunctionNode, Object":function(e,r){if(1!=e.args.length&&a(e),void 0!==r[e])return new u("0",t.number);var n,i,o=e.args[0],s=!1,l=!1;switch(e.name){case"cbrt":s=!0,i=new f("*","multiply",[new u("3",t.number),new f("^","pow",[o,new f("/","divide",[new u("2",t.number),new u("3",t.number)])])]);break;case"sqrt":case"nthRoot":if(1==e.args.length){s=!0,i=new f("*","multiply",[new u("2",t.number),new c("sqrt",[o])]);break}return n=new f("/","divide",[new u("1",t.number),e.args[1]]),r[n]=r[e.args[1]],v(new f("^","pow",[o,n]),r);case"log10":n=new u("10",t.number);case"log":if(n||1!=e.args.length){if(!n&&void 0===r[e.args[1]])return v(new f("/","divide",[new c("log",[o]),new c("log",[e.args[1]])]),r);i=new f("*","multiply",[o.clone(),new c("log",[n||e.args[1]])])}else i=o.clone();s=!0;break;case"exp":i=new c("exp",[o.clone()]);break;case"sin":i=new c("cos",[o.clone()]);break;case"cos":i=new f("-","unaryMinus",[new c("sin",[o.clone()])]);break;case"tan":i=new f("^","pow",[new c("sec",[o.clone()]),new u("2",t.number)]);break;case"sec":i=new f("*","multiply",[e,new c("tan",[o.clone()])]);break;case"csc":l=!0,i=new f("*","multiply",[e,new c("cot",[o.clone()])]);break;case"cot":l=!0,i=new f("^","pow",[new c("csc",[o.clone()]),new u("2",t.number)]);break;case"asin":s=!0,i=new c("sqrt",[new f("-","subtract",[new u("1",t.number),new f("^","pow",[o.clone(),new u("2",t.number)])])]);break;case"acos":s=!0,l=!0,i=new c("sqrt",[new f("-","subtract",[new u("1",t.number),new f("^","pow",[o.clone(),new u("2",t.number)])])]);break;case"atan":s=!0,i=new f("+","add",[new f("^","pow",[o.clone(),new u("2",t.number)]),new u("1",t.number)]);break;case"asec":s=!0,i=new f("*","multiply",[new c("abs",[o.clone()]),new c("sqrt",[new f("-","subtract",[new f("^","pow",[o.clone(),new u("2",t.number)]),new u("1",t.number)])])]);break;case"acsc":s=!0,l=!0,i=new f("*","multiply",[new c("abs",[o.clone()]),new c("sqrt",[new f("-","subtract",[new f("^","pow",[o.clone(),new u("2",t.number)]),new u("1",t.number)])])]);break;case"acot":s=!0,l=!0,i=new f("+","add",[new f("^","pow",[o.clone(),new u("2",t.number)]),new u("1",t.number)]);break;case"sinh":i=new c("cosh",[o.clone()]);break;case"cosh":i=new c("sinh",[o.clone()]);break;case"tanh":i=new f("^","pow",[new c("sech",[o.clone()]),new u("2",t.number)]);break;case"sech":l=!0,i=new f("*","multiply",[e,new c("tanh",[o.clone()])]);break;case"csch":l=!0,i=new f("*","multiply",[e,new c("coth",[o.clone()])]);break;case"coth":l=!0,i=new f("^","pow",[new c("csch",[o.clone()]),new u("2",t.number)]);break;case"asinh":s=!0,i=new c("sqrt",[new f("+","add",[new f("^","pow",[o.clone(),new u("2",t.number)]),new u("1",t.number)])]);break;case"acosh":s=!0,i=new c("sqrt",[new f("-","subtract",[new f("^","pow",[o.clone(),new u("2",t.number)]),new u("1",t.number)])]);break;case"atanh":s=!0,i=new f("-","subtract",[new u("1",t.number),new f("^","pow",[o.clone(),new u("2",t.number)])]);break;case"asech":s=!0,l=!0,i=new f("*","multiply",[o.clone(),new c("sqrt",[new f("-","subtract",[new u("1",t.number),new f("^","pow",[o.clone(),new u("2",t.number)])])])]);break;case"acsch":s=!0,l=!0,i=new f("*","multiply",[new c("abs",[o.clone()]),new c("sqrt",[new f("+","add",[new f("^","pow",[o.clone(),new u("2",t.number)]),new u("1",t.number)])])]);break;case"acoth":s=!0,l=!0,i=new f("-","subtract",[new u("1",t.number),new f("^","pow",[o.clone(),new u("2",t.number)])]);break;case"abs":i=new f("/","divide",[new c(new p("abs"),[o.clone()]),o.clone()]);break;case"gamma":default:throw new Error('Function "'+e.name+'" not supported by derivative')}var h,m;s?(h="/",m="divide"):(h="*",m="multiply");var d=v(o,r);return l&&(d=new f("-","unaryMinus",[d])),new f(h,m,[d,i])},"OperatorNode, Object":function(r,n){if(void 0!==n[r])return new u("0",t.number);var i=r.args[0],a=r.args[1];switch(r.op){case"+":case"-":return 1==r.args.length?new f(r.op,r.fn,[v(i,n)]):new f(r.op,r.fn,[v(i,n),v(a,n)]);case"*":if(void 0!==n[i]||void 0!==n[a]){var o=void 0!==n[i]?[i.clone(),v(a,n)]:[a.clone(),v(i,n)];return new f("*","multiply",o)}return new f("+","add",[new f("*","multiply",[v(i,n),a.clone()]),new f("*","multiply",[i.clone(),v(a,n)])]);case"/":return void 0!==n[a]?new f("/","divide",[v(i,n),a]):void 0!==n[i]?new f("*","multiply",[new f("-","unaryMinus",[i]),new f("/","divide",[v(a,n),new f("^","pow",[a.clone(),new u("2",t.number)])])]):new f("/","divide",[new f("-","subtract",[new f("*","multiply",[v(i,n),a.clone()]),new f("*","multiply",[i.clone(),v(a,n)])]),new f("^","pow",[a.clone(),new u("2",t.number)])]);case"^":if(void 0!==n[i])return!e.isConstantNode(i)||"0"!==i.value&&"1"!==i.value?new f("*","multiply",[r,new f("*","multiply",[new c("log",[i.clone()]),v(a.clone(),n)])]):new u("0",t.number);if(void 0!==n[a]){if(e.isConstantNode(a)){var s=a.value;if("0"===s)return new u("0",t.number);if("1"===s)return v(i,n)}var l=new f("^","pow",[i.clone(),new f("-","subtract",[a,new u("1",t.number)])]);return new f("*","multiply",[a.clone(),new f("*","multiply",[v(i,n),l])])}return new f("*","multiply",[new f("^","pow",[i.clone(),a.clone()]),new f("+","add",[new f("*","multiply",[v(i,n),new f("/","divide",[a.clone(),i.clone()])]),new f("*","multiply",[v(a,n),new c("log",[i.clone()])])])]);case"%":case"mod":default:throw new Error('Operator "'+r.op+'" not supported by derivative')}}});return h}t.name="derivative",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,i,a){function o(t){var r=p(t);return e.isNode(r)?r:w(r)}function s(t,r){try{return b(a[t].apply(null,r))}catch(n){return r=r.map(function(t){return e.isFraction(t)?t.valueOf():t}),b(a[t].apply(null,r))}}function u(e){if(isFinite(e)){var t=a.fraction(e);if(t.valueOf()===e)return t}return e}function c(e){return new x("-","unaryMinus",[e])}function f(e){var t,r=e.s*e.n;return t=r<0?new x("-","unaryMinus",[new y(-r)]):new y(r),1===e.d?t:new x("/","divide",[t,new y(e.d)])}function l(t,r,n){return r.reduce(function(r,i){if(e.isNode(r)||e.isNode(i))e.isNode(r)?e.isNode(i)||(i=w(i)):r=w(r);else{try{return s(t,[r,i])}catch(e){}r=w(r),i=w(i)}return n([r,i])})}function p(t){switch(t.type){case"SymbolNode":return t;case"ConstantNode":return"number"===t.valueType?b(t.value):t;case"FunctionNode":if(a[t.name]&&a[t.name].rawArgs)return t;case"OperatorNode":var r,n,i=t.fn.toString(),o=g(t);if(1===t.args.length)r=[p(t.args[0])],n=e.isNode(r[0])?o(r):s(i,r);else if(d(t))if(r=v(t),r=r.map(p),m(i)){for(var u=[],c=[],f=0;f<r.length;f++)e.isNode(r[f])?c.push(r[f]):u.push(r[f]);u.length>1?(n=l(i,u,o),c.unshift(n),n=l(i,c,o)):n=l(i,r,o)}else n=l(i,r,o);else r=t.args.map(p),n=l(i,r,o);return n;case"ParenthesisNode":return p(t.content);case"AccessorNode":case"ArrayNode":case"AssignmentNode":case"BlockNode":case"FunctionAssignmentNode":case"IndexNode":case"ObjectNode":case"RangeNode":case"UpdateNode":case"ConditionalNode":default:throw"Unimplemented node type in simplifyConstant: "+t.type}}var h=n(r(119)),m=h.isCommutative,d=h.isAssociative,v=h.allChildren,g=h.createMakeNodeFunction,y=a.expression.node.ConstantNode,x=a.expression.node.OperatorNode,w=i({Fraction:f,number:function(e){return e<0?c(new y(-e)):new y(e)},BigNumber:function(e){return e<0?c(new y(e.negated().toString(),"number")):new y(e.toString(),"number")},Complex:function(e){throw"Cannot convert Complex number to Node"}}),b=i({string:function(e){return"BigNumber"===t.number?a.bignumber(e):"Fraction"===t.number?a.fraction(e):u(parseFloat(e))},Fraction:function(e){return e},BigNumber:function(e){return e},number:function(e){return u(e)},Complex:function(e){return 0!==e.im?e:u(e.re)}});return o}r(3).digits;t.math=!0,t.name="simplifyConstant",t.path="algebra.simplify",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n,i){function a(t){if(e.isOperatorNode(t)&&t.args.length<=2){var r=a(t.args[0]),n=t.args[1]&&a(t.args[1]);if("+"===t.op){if(1===t.args.length)return t.args[0];if(e.isConstantNode(r)){if("0"===r.value)return n;if(e.isConstantNode(n)&&r.value&&r.value.length<5&&n.value&&n.value.length<5)return new o(Number(r.value)+Number(n.value))}return e.isConstantNode(n)&&"0"===n.value?r:2===t.args.length&&e.isOperatorNode(n)&&"-"===n.op&&"unaryMinus"===n.fn?new s("-","subtract",[r,n.args[0]]):new s(t.op,t.fn,n?[r,n]:[r])}if("-"===t.op){if(e.isConstantNode(r)&&n){if(e.isConstantNode(n)&&r.value&&r.value.length<5&&n.value&&n.value.length<5)return new o(Number(r.value)-Number(n.value));if("0"===r.value)return new s("-","unaryMinus",[n])}if("subtract"===t.fn&&2===t.args.length)return e.isConstantNode(n)&&"0"===n.value?r:e.isOperatorNode(n)&&"unaryMinus"===n.fn?a(new s("+","add",[r,n.args[0]])):new s(t.op,t.fn,[r,n]);if("unaryMinus"===t.fn)return e.isOperatorNode(r)&&"unaryMinus"===r.fn?r.args[0]:new s(t.op,t.fn,[r]);throw new Error("never happens")}if("*"===t.op){if(e.isConstantNode(r)){if("0"===r.value)return c;if("1"===r.value)return n;if(e.isConstantNode(n)&&r.value&&r.value.length<5&&n.value&&n.value.length<5)return new o(Number(r.value)*Number(n.value))}if(e.isConstantNode(n)){if("0"===n.value)return c;if("1"===n.value)return r;if(e.isOperatorNode(r)&&r.op===t.op){var l=r.args[0];if(e.isConstantNode(l)&&n.value&&n.value.length<5&&l.value&&l.value.length<5){var p=new o(Number(r.args[0].value)*Number(n.value));return new s(t.op,t.fn,[p,r.args[1]])}}return new s(t.op,t.fn,[n,r])}return new s(t.op,t.fn,[r,n])}if("/"===t.op){if(e.isConstantNode(r)){if("0"===r.value)return c;if(e.isConstantNode(n)&&r.value&&r.value.length<5&&("1"===n.value||"2"===n.value||"4"===n.value))return new o(Number(r.value)/Number(n.value))}return new s(t.op,t.fn,[r,n])}if("^"===t.op){if(e.isConstantNode(n)){if("0"===n.value)return f;if("1"===n.value)return r;if(e.isConstantNode(n)&&r.value&&r.value.length<5&&n.value&&n.value.length<2)return new o(i.pow(Number(r.value),Number(n.value)))}return new s(t.op,t.fn,[r,n])}}else{if(e.isParenthesisNode(t)){var h=a(t.content);return e.isParenthesisNode(h)||e.isSymbolNode(h)||e.isConstantNode(h)?h:new ParenthesisNode(h)}if(e.isFunctionNode(t)){var m=t.args.map(a);return 1===m.length&&e.isParenthesisNode(m[0])&&(m[0]=m[0].content),new u(a(t.fn),m)}}return t}var o=i.expression.node.ConstantNode,s=i.expression.node.OperatorNode,u=i.expression.node.FunctionNode,c=new o(0),f=new o(1);return a}t.math=!0,t.name="simplifyCore",t.path="algebra.simplify",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n,i){function a(t,r){if(!r)return t;if(e.isSymbolNode(t)){var n=r[t.name];if(n instanceof o)return a(n,r);if("number"==typeof n)return i.parse(String(n))}else{if(e.isOperatorNode(t)){var f=t.args.map(function(e){return a(e,r)});return new s(t.op,t.fn,f)}if(e.isParenthesisNode(t))return new c(a(t.content,r));if(e.isFunctionNode(t)){var f=t.args.map(function(e){return a(e,r)});return new u(t.name,f)}}return t}var o=i.expression.node.Node,s=i.expression.node.OperatorNode,u=i.expression.node.FunctionNode,c=i.expression.node.ParenthesisNode;return a}t.math=!0,t.name="resolve",t.path="algebra.simplify",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,i){var a=n(r(0)),o=n(r(38)),s=n(r(61)),u=(n(r(120)),n(r(82))),c=(n(r(55)),n(r(121))),f=(n(r(29)),n(r(122))),l=n(r(56)),p=n(r(123)),h=n(r(37)),m=n(r(20)),d=n(r(19)),v=n(r(23)),g=n(r(21)),y=i("qr",{DenseMatrix:function(e){return x(e)},SparseMatrix:function(e){return w(e)},Array:function(e){var t=a(e),r=x(t);return{Q:r.Q.valueOf(),R:r.R.valueOf()}}}),x=function(e){var t,r,n,i=e._size[0],a=e._size[1],y=s([i],"dense"),x=y._data,w=e.clone(),b=w._data,N=o([i],"");for(n=0;n<Math.min(a,i);++n){var E=b[n][n],M=h(f(E)),A=p(M),O=0;for(t=n;t<i;t++)O=m(O,v(b[t][n],p(b[t][n])));var T=v(M,l(O));if(!u(T)){var _=g(E,T);for(N[n]=1,t=n+1;t<i;t++)N[t]=d(b[t][n],_);var S,C=h(p(d(_,T)));for(r=n;r<a;r++){for(S=0,t=n;t<i;t++)S=m(S,v(p(N[t]),b[t][r]));for(S=v(S,C),t=n;t<i;t++)b[t][r]=v(g(b[t][r],v(N[t],S)),A)}for(t=0;t<i;t++){for(S=0,r=n;r<i;r++)S=m(S,v(x[t][r],N[r]));for(S=v(S,C),r=n;r<i;++r)x[t][r]=d(g(x[t][r],v(S,p(N[r]))),A)}}}for(t=0;t<i;++t)for(r=0;r<t&&r<a;++r){if(c(0,d(b[t][r],1e5)))throw new Error("math.qr(): unknown error - R is not lower triangular (element ("+t+", "+r+")  = "+b[t][r]+")");b[t][r]=v(b[t][r],0)}return{Q:y,R:w,toString:function(){return"Q: "+this.Q.toString()+"\nR: "+this.R.toString()}}},w=function(e){throw new Error("qr not implemented for sparse matrices yet")};return y}t.name="qr",t.factory=n},function(e,t,r){"use strict";function n(e,t,n){var i=n(r(411)),a=n(r(413)),o=n(r(414)),s=n(r(415)),u=n(r(416)),c=function(e,t,r){var n,c=t._ptr,l=t._size,p=l[1],h={};if(h.q=i(e,t),e&&!h.q)return null;if(r){var m=e?a(t,null,h.q,0):t;h.parent=o(m,1);var d=s(h.parent,p);if(h.cp=u(m,h.parent,d,1),m&&h.parent&&h.cp&&f(m,h))for(h.unz=0,n=0;n<p;n++)h.unz+=h.cp[n]}else h.unz=4*c[p]+p,h.lnz=h.unz;return h},f=function(e,t){var r=e._ptr,n=e._index,i=e._size,a=i[0],o=i[1];t.pinv=[],t.leftmost=[];var s,u,c,f,l,p=t.parent,h=t.pinv,m=t.leftmost,d=[],v=0,g=a,y=a+o,x=a+2*o;for(u=0;u<o;u++)d[g+u]=-1,d[y+u]=-1,d[x+u]=0;for(s=0;s<a;s++)m[s]=-1;for(u=o-1;u>=0;u--)for(f=r[u],l=r[u+1],c=f;c<l;c++)m[n[c]]=u;for(s=a-1;s>=0;s--)h[s]=-1,u=m[s],u!=-1&&(0===d[x+u]++&&(d[y+u]=s),d[v+s]=d[g+u],d[g+u]=s);for(t.lnz=0,t.m2=a,u=0;u<o;u++)if(s=d[g+u],t.lnz++,s<0&&(s=t.m2++),h[s]=u,!(--x[u]<=0)){t.lnz+=d[x+u];var w=p[u];w!=-1&&(0===d[x+w]&&(d[y+w]=d[y+u]),d[v+d[y+u]]=d[g+w],d[g+w]=d[v+s],d[x+w]+=d[x+u])}for(s=0;s<a;s++)h[s]<0&&(h[s]=u++);return!0};return c}t.name="cs_sqr",t.path="sparse",t.factory=n},function(e,t,r){"use strict";function n(e,t,n){var i=n(r(83)),a=n(r(412)),o=n(r(126)),s=n(r(18)),u=n(r(12)),c=n(r(67)),f=function(e,t){if(!t||e<=0||e>3)return null;var r=t._size,n=r[0],s=r[1],u=0,c=Math.max(16,10*Math.sqrt(s));c=Math.min(s-2,c);var f=l(e,t,n,s,c);a(f,d,null);for(var v,g,y,x,w,b,N,E,M,A,O,T,_,S,C,z,k=f._index,I=f._ptr,B=I[s],P=[],R=[],U=0,q=s+1,L=2*(s+1),j=3*(s+1),F=4*(s+1),D=5*(s+1),H=6*(s+1),$=7*(s+1),G=P,Z=p(s,I,R,U,j,G,L,$,q,H,F,D),V=h(s,I,R,D,F,H,c,q,j,G,L),W=0;V<s;){for(y=-1;W<s&&(y=R[j+W])==-1;W++);R[L+y]!=-1&&(G[R[L+y]]=-1),R[j+W]=R[L+y];var Y=R[F+y],X=R[q+y];V+=X;var J=0;R[q+y]=-X;var Q=I[y],K=0===Y?Q:B,ee=K;for(x=1;x<=Y+1;x++){for(x>Y?(b=y,N=Q,E=R[U+y]-Y):(b=k[Q++],N=I[b],E=R[U+b]),w=1;w<=E;w++)v=k[N++],(M=R[q+v])<=0||(J+=M,R[q+v]=-M,k[ee++]=v,R[L+v]!=-1&&(G[R[L+v]]=G[v]),G[v]!=-1?R[L+G[v]]=R[L+v]:R[j+R[D+v]]=R[L+v]);b!=y&&(I[b]=i(y),R[H+b]=0)}for(0!==Y&&(B=ee),R[D+y]=J,I[y]=K,R[U+y]=ee-K,R[F+y]=-2,Z=m(Z,u,R,H,s),A=K;A<ee;A++)if(v=k[A],!((O=R[F+v])<=0)){M=-R[q+v];var te=Z-M;for(Q=I[v],T=I[v]+O-1;Q<=T;Q++)b=k[Q],R[H+b]>=Z?R[H+b]-=M:0!==R[H+b]&&(R[H+b]=R[D+b]+te)}for(A=K;A<ee;A++){for(v=k[A],T=I[v],_=T+R[F+v]-1,S=T,C=0,z=0,Q=T;Q<=_;Q++)if(b=k[Q],0!==R[H+b]){var re=R[H+b]-Z;re>0?(z+=re,k[S++]=b,C+=b):(I[b]=i(y),R[H+b]=0)}R[F+v]=S-T+1;var ne=S,ie=T+R[U+v];for(Q=_+1;Q<ie;Q++){g=k[Q];var ae=R[q+g];ae<=0||(z+=ae,k[S++]=g,C+=g)}0===z?(I[v]=i(y),M=-R[q+v],J-=M,X+=M,V+=M,R[q+v]=0,R[F+v]=-1):(R[D+v]=Math.min(R[D+v],z),k[S]=k[ne],k[ne]=k[T],k[T]=y,R[U+v]=S-T+1,C=(C<0?-C:C)%s,R[L+v]=R[$+C],R[$+C]=v,G[v]=C)}for(R[D+y]=J,u=Math.max(u,J),Z=m(Z+u,u,R,H,s),A=K;A<ee;A++)if(v=k[A],!(R[q+v]>=0))for(C=G[v],v=R[$+C],R[$+C]=-1;v!=-1&&R[L+v]!=-1;v=R[L+v],Z++){for(E=R[U+v],O=R[F+v],Q=I[v]+1;Q<=I[v]+E-1;Q++)R[H+k[Q]]=Z;var oe=v;for(g=R[L+v];g!=-1;){var se=R[U+g]===E&&R[F+g]===O;for(Q=I[g]+1;se&&Q<=I[g]+E-1;Q++)R[H+k[Q]]!=Z&&(se=0);se?(I[g]=i(v),R[q+v]+=R[q+g],R[q+g]=0,R[F+g]=-1,g=R[L+g],R[L+oe]=g):(oe=g,g=R[L+g])}}for(Q=K,A=K;A<ee;A++)v=k[A],(M=-R[q+v])<=0||(R[q+v]=M,z=R[D+v]+J-M,z=Math.min(z,s-V-M),R[j+z]!=-1&&(G[R[j+z]]=v),R[L+v]=R[j+z],G[v]=-1,R[j+z]=v,W=Math.min(W,z),R[D+v]=z,k[Q++]=v);R[q+y]=X,0===(R[U+y]=Q-K)&&(I[y]=-1,R[H+y]=0),0!==Y&&(B=Q)}for(v=0;v<s;v++)I[v]=i(I[v]);for(g=0;g<=s;g++)R[j+g]=-1;for(g=s;g>=0;g--)R[q+g]>0||(R[L+g]=R[j+I[g]],R[j+I[g]]=g);for(b=s;b>=0;b--)R[q+b]<=0||I[b]!=-1&&(R[L+b]=R[j+I[b]],R[j+I[b]]=b);for(y=0,v=0;v<=s;v++)I[v]==-1&&(y=o(v,y,R,j,L,P,H));return P.splice(P.length-1,1),P},l=function(e,t,r,n,i){var a=c(t);if(1===e&&n===r)return s(t,a);if(2==e){for(var o=a._index,f=a._ptr,l=0,p=0;p<r;p++){var h=f[p];if(f[p]=l,!(f[p+1]-h>i))for(var m=f[p+1];h<m;h++)o[l++]=o[h]}return f[r]=l,t=c(a),u(a,t)}return u(a,t)},p=function(e,t,r,n,i,a,o,s,u,c,f,l){for(var p=0;p<e;p++)r[n+p]=t[p+1]-t[p];r[n+e]=0;for(var h=0;h<=e;h++)r[i+h]=-1,a[h]=-1,r[o+h]=-1,r[s+h]=-1,r[u+h]=1,r[c+h]=1,r[f+h]=0,r[l+h]=r[n+h];var d=m(0,0,r,c,e);return r[f+e]=-2,t[e]=-1,r[c+e]=0,d},h=function(e,t,r,n,a,o,s,u,c,f,l){for(var p=0,h=0;h<e;h++){var m=r[n+h];if(0===m)r[a+h]=-2,p++,t[h]=-1,r[o+h]=0;else if(m>s)r[u+h]=0,r[a+h]=-1,p++,t[h]=i(e),r[u+e]++;else{var d=r[c+m];d!=-1&&(f[d]=h),r[l+h]=r[c+m],r[c+m]=h}}return p},m=function(e,t,r,n,i){if(e<2||e+t<0){for(var a=0;a<i;a++)0!==r[n+a]&&(r[n+a]=1);e=2}return e},d=function(e,t){return e!=t};return f}t.name="cs_amd",t.path="sparse",t.factory=n},function(e,t,r){"use strict";function n(){var e=function(e,t,r){for(var n=e._values,i=e._index,a=e._ptr,o=e._size,s=o[1],u=0,c=0;c<s;c++){var f=a[c];for(a[c]=u;f<a[c+1];f++)t(i[f],c,n?n[f]:1,r)&&(i[u]=i[f],n&&(n[u]=n[f]),u++)}return a[s]=u,i.splice(u,i.length-u),n&&n.splice(u,n.length-u),u};return e}t.name="cs_fkeep",t.path="sparse",t.factory=n},function(e,t,r){"use strict";function n(e){var t=e.SparseMatrix,r=function(e,r,n,i){for(var a=e._values,o=e._index,s=e._ptr,u=e._size,c=e._datatype,f=u[0],l=u[1],p=i&&e._values?[]:null,h=[],m=[],d=0,v=0;v<l;v++){m[v]=d;for(var g=n?n[v]:v,y=s[g],x=s[g+1],w=y;w<x;w++){var b=r?r[o[w]]:o[w];h[d]=b,p&&(p[d]=a[w]),d++}}return m[l]=d,new t({values:p,index:h,ptr:m,size:[f,l],datatype:c})};return r}t.name="cs_permute",t.path="sparse",t.factory=n},function(e,t,r){"use strict";function n(){var e=function(e,t){if(!e)return null;var r,n,i=e._index,a=e._ptr,o=e._size,s=o[0],u=o[1],c=[],f=[],l=0,p=u;if(t)for(r=0;r<s;r++)f[p+r]=-1;for(var h=0;h<u;h++){c[h]=-1,f[l+h]=-1;for(var m=a[h],d=a[h+1],v=m;v<d;v++){var g=i[v];for(r=t?f[p+g]:g;r!=-1&&r<h;r=n)n=f[l+r],f[l+r]=h,n==-1&&(c[r]=h);t&&(f[p+g]=h)}}return c};return e}t.name="cs_etree",t.path="sparse",t.factory=n},function(e,t,r){"use strict";function n(e,t,n){var i=n(r(126)),a=function(e,t){if(!e)return null;var r,n=0,a=[],o=[],s=0,u=t,c=2*t;for(r=0;r<t;r++)o[s+r]=-1;for(r=t-1;r>=0;r--)e[r]!=-1&&(o[u+r]=o[s+e[r]],o[s+e[r]]=r);for(r=0;r<t;r++)e[r]==-1&&(n=i(r,n,o,s,u,a,c));return a};return a}t.name="cs_post",t.path="sparse",t.factory=n},function(e,t,r){"use strict";function n(e,t,n){var i=n(r(67)),a=n(r(417)),o=function(e,t,r,n){if(!e||!t||!r)return null;var o,s,u,c,f,l,p,h=e._size,m=h[0],d=h[1],v=4*d+(n?d+m+1:0),g=[],y=0,x=d,w=2*d,b=3*d,N=4*d,E=5*d+1;for(u=0;u<v;u++)g[u]=-1;var M=[],A=i(e),O=A._index,T=A._ptr;for(u=0;u<d;u++)for(s=r[u],M[s]=g[b+s]==-1?1:0;s!=-1&&g[b+s]==-1;s=t[s])g[b+s]=u;if(n){for(u=0;u<d;u++)g[r[u]]=u;for(o=0;o<m;o++){for(u=d,l=T[o],p=T[o+1],f=l;f<p;f++)u=Math.min(u,g[O[f]]);g[E+o]=g[N+u],g[N+u]=o}}for(o=0;o<d;o++)g[y+o]=o;for(u=0;u<d;u++){for(s=r[u],t[s]!=-1&&M[t[s]]--,c=n?g[N+u]:s;c!=-1;c=n?g[E+c]:-1)for(f=T[c];f<T[c+1];f++){o=O[f];var _=a(o,s,g,b,x,w,y);_.jleaf>=1&&M[s]++,2==_.jleaf&&M[_.q]--}t[s]!=-1&&(g[y+s]=t[s])}for(s=0;s<d;s++)t[s]!=-1&&(M[t[s]]+=M[s]);return M};return o}t.name="cs_counts",t.path="sparse",t.factory=n},function(e,t,r){"use strict";function n(){var e=function(e,t,r,n,i,a,o){var s,u,c,f,l=0;if(e<=t||r[n+t]<=r[i+e])return-1;if(r[i+e]=r[n+t],c=r[a+e],r[a+e]=t,c===-1)l=1,f=e;else{for(l=2,f=c;f!=r[o+f];f=r[o+f]);for(s=c;s!=f;s=u)u=r[o+s],r[o+s]=f}return{jleaf:l,q:f}};return e}t.name="cs_leaf",t.path="sparse",t.factory=n},function(e,t,r){"use strict";function n(e,t,n){var i=n(r(29)),a=n(r(19)),o=n(r(12)),s=n(r(34)),u=n(r(127)),c=n(r(419)),f=e.SparseMatrix,l=function(e,t,r){if(!e)return null;var n,l=e._size,p=l[1],h=100,m=100;t&&(n=t.q,h=t.lnz||h,m=t.unz||m);var d,v,g=[],y=[],x=[],w=new f({values:g,index:y,ptr:x,size:[p,p]}),b=[],N=[],E=[],M=new f({values:b,index:N,ptr:E,size:[p,p]}),A=[],O=[],T=[];for(d=0;d<p;d++)O[d]=0,A[d]=-1,x[d+1]=0;h=0,m=0;for(var _=0;_<p;_++){x[_]=h,E[_]=m;var S=n?n[_]:_,C=c(w,e,S,T,O,A,1),z=-1,k=-1;for(v=C;v<p;v++)if(d=T[v],A[d]<0){var I=i(O[d]);s(I,k)&&(k=I,z=d)}else N[m]=A[d],b[m++]=O[d];if(z==-1||k<=0)return null;A[S]<0&&u(i(O[S]),o(k,r))&&(z=S);var B=O[z];for(N[m]=_,b[m++]=B,A[z]=_,y[h]=z,g[h++]=1,v=C;v<p;v++)d=T[v],A[d]<0&&(y[h]=d,g[h++]=a(O[d],B)),O[d]=0}for(x[p]=h,E[p]=m,v=0;v<h;v++)y[v]=A[y[v]];return g.splice(h,g.length-h),y.splice(h,y.length-h),b.splice(m,b.length-m),N.splice(m,N.length-m),{L:w,U:M,pinv:A}};return l}t.name="cs_lu",t.path="sparse",t.factory=n},function(e,t,r){"use strict";function n(e,t,n){var i=n(r(19)),a=n(r(12)),o=n(r(21)),s=n(r(420)),u=function(e,t,r,n,u,c,f){var l,p,h,m,d=e._values,v=e._index,g=e._ptr,y=e._size,x=y[1],w=t._values,b=t._index,N=t._ptr,E=s(e,t,r,n,c);for(l=E;l<x;l++)u[n[l]]=0;for(p=N[r],h=N[r+1],l=p;l<h;l++)u[b[l]]=w[l];for(var M=E;M<x;M++){var A=n[M],O=c?c[A]:A;if(!(O<0))for(p=g[O],h=g[O+1],u[A]=i(u[A],d[f?p:h-1]),l=f?p+1:p,m=f?h:h-1;l<m;l++){var T=v[l];u[T]=o(u[T],a(d[l],u[A]))}}return E};return u}t.name="cs_spsolve",t.path="sparse",t.factory=n},function(e,t,r){"use strict";function n(e,t,n){var i=n(r(421)),a=n(r(128)),o=n(r(129)),s=function(e,t,r,n,s){var u,c,f,l=e._ptr,p=e._size,h=t._index,m=t._ptr,d=p[1],v=d;for(c=m[r],f=m[r+1],u=c;u<f;u++){var g=h[u];a(l,g)||(v=i(g,e,v,n,s))}for(u=v;u<d;u++)o(l,n[u]);return v};return s}t.name="cs_reach",t.path="sparse",t.factory=n},function(e,t,r){"use strict";function n(e,t,n){var i=n(r(128)),a=n(r(129)),o=n(r(422)),s=function(e,t,r,n,s){var u,c,f,l=t._index,p=t._ptr,h=t._size,m=h[1],d=0;for(n[0]=e;d>=0;){e=n[d];var v=s?s[e]:e;i(p,e)||(a(p,e),n[m+d]=v<0?0:o(p[v]));var g=1;for(c=n[m+d],f=v<0?0:o(p[v+1]);c<f;c++)if(u=l[c],!i(p,u)){n[m+d]=c,n[++d]=u,g=0;break}g&&(d--,n[--r]=e)}return r};return s}t.name="cs_dfs",t.path="sparse",t.factory=n},function(e,t,r){"use strict";function n(e,t,n){var i=n(r(83)),a=function(e){return e<0?i(e):e};return a}t.name="cs_unflip",t.path="sparse",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){var o=n(r(0)),s=n(r(124)),u=n(r(125)),c=n(r(424)),f=n(r(84)),l=n(r(131)),p=n(r(130)),h=a("lusolve",{"Array, Array | Matrix":function(e,t){e=o(e);var r=s(e),n=d(r.L,r.U,r.p,null,t);return n.valueOf()},"DenseMatrix, Array | Matrix":function(e,t){var r=s(e);return d(r.L,r.U,r.p,null,t)},"SparseMatrix, Array | Matrix":function(e,t){var r=s(e);return d(r.L,r.U,r.p,null,t)},"SparseMatrix, Array | Matrix, number, number":function(e,t,r,n){var i=u(e,r,n);return d(i.L,i.U,i.p,i.q,t)},"Object, Array | Matrix":function(e,t){return d(e.L,e.U,e.p,e.q,t)}}),m=function(t){if(e.isMatrix(t))return t;if(i(t))return o(t);throw new TypeError("Invalid Matrix LU decomposition")},d=function(e,t,r,n,i){e=m(e),t=m(t),i=f(e,i,!1),r&&(i._data=c(r,i._data));var a=p(e,i),o=l(t,a);return n&&(o._data=c(n,o._data)),o};return h}var i=Array.isArray;t.name="lusolve",t.factory=n},function(e,t,r){"use strict";function n(){var e=function(e,t,r){var n,r=t.length,i=[];if(e)for(n=0;n<r;n++)i[e[n]]=t[n];else for(n=0;n<r;n++)i[n]=t[n];return i};return e}t.name="cs_ipvec",t.path="sparse",t.factory=n},function(e,t,r){e.exports=[r(29),r(18),r(20),r(426),r(427),r(428),r(47),r(132),r(429),r(430),r(431),r(96),r(432),r(433),r(434),r(435),r(134),r(437),r(438),r(12),r(439),r(440),r(45),r(97),r(122),r(56),r(441),r(21),r(37),r(442),r(443)]},function(e,t,r){"use strict";function n(e,t,n,o){function s(r,n){var i=r.arg()/3,o=r.abs(),s=new e.Complex(a(o),0).mul(new e.Complex(0,i).exp());if(n){var u=[s,new e.Complex(a(o),0).mul(new e.Complex(0,i+2*Math.PI/3).exp()),new e.Complex(a(o),0).mul(new e.Complex(0,i-2*Math.PI/3).exp())];return"Array"===t.matrix?u:l(u)}return s}function u(t){if(t.value&&e.isComplex(t.value)){var r=t.clone();return r.value=1,r=r.pow(1/3),r.value=s(t.value),r}var n=f(t.value);n&&(t.value=c(t.value));var i;i=e.isBigNumber(t.value)?new e.BigNumber(1).div(3):e.isFraction(t.value)?new e.Fraction(1,3):1/3;var r=t.pow(i);return n&&(r.value=c(r.value)),r}var c=n(r(37)),f=n(r(57)),l=n(r(0)),p=o("cbrt",{number:a,Complex:s,"Complex, boolean":s,BigNumber:function(e){return e.cbrt()},Unit:u,"Array | Matrix":function(e){return i(e,p,!0)}});return p.toTex={1:"\\sqrt[3]{${args[0]}}"},p}var i=r(1),a=Math.cbrt||function(e){if(0===e)return e;var t,r=e<0;return r&&(e=-e),isFinite(e)?(t=Math.exp(Math.log(e)/3),t=(e/(t*t)+2*t)/3):t=e,r?-t:t};t.name="cbrt",t.factory=n;
},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("ceil",{number:Math.ceil,Complex:function(e){return e.ceil()},BigNumber:function(e){return e.ceil()},Fraction:function(e){return e.ceil()},"Array | Matrix":function(e){return i(e,a,!0)}});return a.toTex={1:"\\left\\lceil${args[0]}\\right\\rceil"},a}var i=r(1);t.name="ceil",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("cube",{number:function(e){return e*e*e},Complex:function(e){return e.mul(e).mul(e)},BigNumber:function(e){return e.times(e).times(e)},Fraction:function(e){return e.pow(3)},"Array | Matrix":function(e){return i(e,a,!0)},Unit:function(e){return e.pow(3)}});return a.toTex={1:"\\left(${args[0]}\\right)^3"},a}var i=r(1);t.name="cube",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,i){var a=n(r(0)),o=n(r(23)),s=r(4),u=n(r(24)),c=n(r(133)),f=n(r(17)),l=n(r(8)),p=n(r(6)),h=i("dotMultiply",{"any, any":o,"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=c(e,t,o,!1);break;default:r=u(t,e,o,!0)}break;default:switch(t.storage()){case"sparse":r=u(e,t,o,!1);break;default:r=l(e,t,o)}}return r},"Array, Array":function(e,t){return h(a(e),a(t)).valueOf()},"Array, Matrix":function(e,t){return h(a(e),t)},"Matrix, Array":function(e,t){return h(e,a(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=f(e,t,o,!1);break;default:r=p(e,t,o,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=f(t,e,o,!0);break;default:r=p(t,e,o,!0)}return r},"Array, any":function(e,t){return p(a(e),t,o,!1).valueOf()},"any, Array":function(e,t){return p(a(t),e,o,!0).valueOf()}});return h.toTex={2:"\\left(${args[0]}"+s.operators.dotMultiply+"${args[1]}\\right)"},h}t.name="dotMultiply",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,i){var a=n(r(0)),o=n(r(45)),s=r(4),u=n(r(15)),c=n(r(26)),f=n(r(17)),l=n(r(16)),p=n(r(8)),h=n(r(6)),m=i("dotPow",{"any, any":o,"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=c(e,t,o,!1);break;default:r=u(t,e,o,!0)}break;default:switch(t.storage()){case"sparse":r=u(e,t,o,!1);break;default:r=p(e,t,o)}}return r},"Array, Array":function(e,t){return m(a(e),a(t)).valueOf()},"Array, Matrix":function(e,t){return m(a(e),t)},"Matrix, Array":function(e,t){return m(e,a(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=f(e,t,m,!1);break;default:r=h(e,t,m,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=l(t,e,m,!0);break;default:r=h(t,e,m,!0)}return r},"Array, any":function(e,t){return h(a(e),t,m,!1).valueOf()},"any, Array":function(e,t){return h(a(t),e,m,!0).valueOf()}});return m.toTex={2:"\\left(${args[0]}"+s.operators.dotPow+"${args[1]}\\right)"},m}t.name="dotPow",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("exp",{number:Math.exp,Complex:function(e){return e.exp()},BigNumber:function(e){return e.exp()},"Array | Matrix":function(e){return i(e,a)}});return a.toTex={1:"\\exp\\left(${args[0]}\\right)"},a}var i=r(1);t.name="exp",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("floor",{number:Math.floor,Complex:function(e){return e.floor()},BigNumber:function(e){return e.floor()},Fraction:function(e){return e.floor()},"Array | Matrix":function(e){return i(e,a,!0)}});return a.toTex={1:"\\left\\lfloor${args[0]}\\right\\rfloor"},a}var i=r(1);t.name="floor",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){function o(t,r){if(!t.isInt()||!r.isInt())throw new Error("Parameters in function gcd must be integer numbers");for(var n=new e.BigNumber(0);!r.isZero();){var i=t.mod(r);t=r,r=i}return t.lt(n)?t.neg():t}var s=n(r(0)),u=n(r(33)),c=n(r(73)),f=n(r(36)),l=n(r(8)),p=n(r(6)),h=a("gcd",{"number, number":i,"BigNumber, BigNumber":o,"Fraction, Fraction":function(e,t){return e.gcd(t)},"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=c(e,t,h);break;default:r=u(t,e,h,!0)}break;default:switch(t.storage()){case"sparse":r=u(e,t,h,!1);break;default:r=l(e,t,h)}}return r},"Array, Array":function(e,t){return h(s(e),s(t)).valueOf()},"Array, Matrix":function(e,t){return h(s(e),t)},"Matrix, Array":function(e,t){return h(e,s(t))},"Matrix, number | BigNumber":function(e,t){var r;switch(e.storage()){case"sparse":r=f(e,t,h,!1);break;default:r=p(e,t,h,!1)}return r},"number | BigNumber, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=f(t,e,h,!0);break;default:r=p(t,e,h,!0)}return r},"Array, number | BigNumber":function(e,t){return p(s(e),t,h,!1).valueOf()},"number | BigNumber, Array":function(e,t){return p(s(t),e,h,!0).valueOf()},"Array | Matrix | number | BigNumber, Array | Matrix | number | BigNumber, ...Array | Matrix | number | BigNumber":function(e,t,r){for(var n=h(e,t),i=0;i<r.length;i++)n=h(n,r[i]);return n}});return h.toTex="\\gcd\\left(${args}\\right)",h}function i(e,t){if(!a(e)||!a(t))throw new Error("Parameters in function gcd must be integer numbers");for(var r;0!=t;)r=e%t,e=t,t=r;return e<0?-e:e}var a=r(3).isInteger;t.name="gcd",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){function o(e){for(var t=0,r=0,n=0;n<e.length;n++){var i=s(e[n]);p(r,i)?(t=f(t,f(c(r,i),c(r,i))),t=u(t,1),r=i):t=u(t,h(i)?f(c(i,r),c(i,r)):i)}return f(r,l(t))}var s=n(r(29)),u=n(r(20)),c=n(r(19)),f=n(r(23)),l=n(r(56)),p=n(r(44)),h=n(r(55)),m=a("hypot",{"... number | BigNumber":o,Array:function(e){return m.apply(m,i(e))},Matrix:function(e){return m.apply(m,i(e.toArray()))}});return m.toTex="\\hypot\\left(${args}\\right)",m}var i=r(2).flatten;t.name="hypot",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){function o(t,r){if(!t.isInt()||!r.isInt())throw new Error("Parameters in function lcm must be integer numbers");if(t.isZero()||r.isZero())return new e.BigNumber(0);for(var n=t.times(r);!r.isZero();){var i=r;r=t.mod(i),t=i}return n.div(t).abs()}var s=n(r(0)),u=n(r(24)),c=n(r(68)),f=n(r(17)),l=n(r(8)),p=n(r(6)),h=a("lcm",{"number, number":i,"BigNumber, BigNumber":o,"Fraction, Fraction":function(e,t){return e.lcm(t)},"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=c(e,t,h);break;default:r=u(t,e,h,!0)}break;default:switch(t.storage()){case"sparse":r=u(e,t,h,!1);break;default:r=l(e,t,h)}}return r},"Array, Array":function(e,t){return h(s(e),s(t)).valueOf()},"Array, Matrix":function(e,t){return h(s(e),t)},"Matrix, Array":function(e,t){return h(e,s(t))},"Matrix, number | BigNumber":function(e,t){var r;switch(e.storage()){case"sparse":r=f(e,t,h,!1);break;default:r=p(e,t,h,!1)}return r},"number | BigNumber, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=f(t,e,h,!0);break;default:r=p(t,e,h,!0)}return r},"Array, number | BigNumber":function(e,t){return p(s(e),t,h,!1).valueOf()},"number | BigNumber, Array":function(e,t){return p(s(t),e,h,!0).valueOf()},"Array | Matrix | number | BigNumber, Array | Matrix | number | BigNumber, ...Array | Matrix | number | BigNumber":function(e,t,r){for(var n=h(e,t),i=0;i<r.length;i++)n=h(n,r[i]);return n}});return h.toTex=void 0,h}function i(e,t){if(!a(e)||!a(t))throw new Error("Parameters in function lcm must be integer numbers");if(0==e||0==t)return 0;for(var r,n=e*t;0!=t;)r=t,t=e%r,e=r;return Math.abs(n/e)}var a=r(3).isInteger;t.name="lcm",t.factory=n},function(e,t,r){"use strict";e.exports=function(e,t,r,n,i,a,o,s,u,c,f){var l,p,h,m,d=e._values,v=e._index,g=e._ptr,y=o._index;if(n)for(p=g[t],h=g[t+1],l=p;l<h;l++)m=v[l],r[m]!==a?(r[m]=a,y.push(m),c?(n[m]=u?s(d[l],f):s(f,d[l]),i[m]=a):n[m]=d[l]):(n[m]=u?s(d[l],n[m]):s(n[m],d[l]),i[m]=a);else for(p=g[t],h=g[t+1],l=p;l<h;l++)m=v[l],r[m]!==a?(r[m]=a,y.push(m)):i[m]=a}},function(e,t,r){"use strict";function n(e,t,r,n){var o=n("log10",{number:function(r){return r>=0||t.predictable?a(r):new e.Complex(r,0).log().div(Math.LN10)},Complex:function(t){return new e.Complex(t).log().div(Math.LN10)},BigNumber:function(r){return!r.isNegative()||t.predictable?r.log():new e.Complex(r.toNumber(),0).log().div(Math.LN10)},"Array | Matrix":function(e){return i(e,o)}});return o.toTex={1:"\\log_{10}\\left(${args[0]}\\right)"},o}var i=r(1),a=Math.log10||function(e){return Math.log(e)/Math.LN10};t.name="log10",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,i){function a(e,t){if(t>0)return e-t*Math.floor(e/t);if(0===t)return e;throw new Error("Cannot calculate mod for a negative divisor")}var o=n(r(0)),s=r(4),u=n(r(24)),c=n(r(15)),f=n(r(60)),l=n(r(17)),p=n(r(16)),h=n(r(8)),m=n(r(6)),d=i("mod",{"number, number":a,"BigNumber, BigNumber":function(e,t){return t.isZero()?e:e.mod(t)},"Fraction, Fraction":function(e,t){return e.mod(t)},"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=f(e,t,d,!1);break;default:r=u(t,e,d,!0)}break;default:switch(t.storage()){case"sparse":r=c(e,t,d,!1);break;default:r=h(e,t,d)}}return r},"Array, Array":function(e,t){return d(o(e),o(t)).valueOf()},"Array, Matrix":function(e,t){return d(o(e),t)},"Matrix, Array":function(e,t){return d(e,o(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=l(e,t,d,!1);break;default:r=m(e,t,d,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=p(t,e,d,!0);break;default:r=m(t,e,d,!0)}return r},"Array, any":function(e,t){return m(o(e),t,d,!1).valueOf()},"any, Array":function(e,t){return m(o(t),e,d,!0).valueOf()}});return d.toTex={2:"\\left(${args[0]}"+s.operators.mod+"${args[1]}\\right)"},d}t.name="mod",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,i){function a(e,t){var r=e.size();if(1==r.length){if(t===Number.POSITIVE_INFINITY||"inf"===t){var n=0;return e.forEach(function(e){var t=o(e);p(t,n)&&(n=t)},!0),n}if(t===Number.NEGATIVE_INFINITY||"-inf"===t){var i;return e.forEach(function(e){var t=o(e);i&&!h(t,i)||(i=t)},!0),i||0}if("fro"===t)return a(e,2);if("number"==typeof t&&!isNaN(t)){if(!l(t,0)){var m=0;return e.forEach(function(e){m=s(u(o(e),t),m)},!0),u(m,1/t)}return Number.POSITIVE_INFINITY}throw new Error("Unsupported parameter value")}if(2==r.length){if(1===t){var g=[],y=0;return e.forEach(function(e,t){var r=t[1],n=s(g[r]||0,o(e));p(n,y)&&(y=n),g[r]=n},!0),y}if(t===Number.POSITIVE_INFINITY||"inf"===t){var x=[],w=0;return e.forEach(function(e,t){var r=t[0],n=s(x[r]||0,o(e));p(n,w)&&(w=n),x[r]=n},!0),w}if("fro"===t)return c(d(f(v(e),e)));if(2===t)throw new Error("Unsupported parameter value, missing implementation of matrix singular value decomposition");throw new Error("Unsupported parameter value")}}var o=n(r(29)),s=n(r(18)),u=n(r(45)),c=n(r(56)),f=n(r(12)),l=n(r(11)),p=n(r(34)),h=n(r(44)),m=n(r(0)),d=n(r(135)),v=n(r(67)),g=i("norm",{number:Math.abs,Complex:function(e){return e.abs()},BigNumber:function(e){return e.abs()},"boolean | null":function(e){return Math.abs(e)},Array:function(e){return a(m(e),2)},Matrix:function(e){return a(e,2)},"number | Complex | BigNumber | boolean | null, number | BigNumber | string":function(e){return g(e)},"Array, number | BigNumber | string":function(e,t){return a(m(e),t)},"Matrix, number | BigNumber | string":function(e,t){return a(e,t)}});return g.toTex={1:"\\left\\|${args[0]}\\right\\|",2:void 0},g}t.name="norm",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,o){function s(t,r){var n=e.BigNumber.precision,i=e.BigNumber.clone({precision:n+2}),a=new e.BigNumber(0),o=new i(1),s=r.isNegative();if(s&&(r=r.neg()),r.isZero())throw new Error("Root must be non-zero");if(t.isNegative()&&!r.abs().mod(2).equals(1))throw new Error("Root must be odd when a is negative.");if(t.isZero())return s?new i(1/0):0;if(!t.isFinite())return s?a:t;var u=t.abs().pow(o.div(r));return u=t.isNeg()?u.neg():u,new e.BigNumber((s?o.div(u):u).toPrecision(n))}var u=n(r(0)),c=n(r(33)),f=n(r(24)),l=n(r(68)),p=n(r(17)),h=n(r(8)),m=n(r(6)),d=o("nthRoot",{number:function(e){return i(e,2)},"number, number":i,BigNumber:function(t){return s(t,new e.BigNumber(2))},Complex:function(e){return a(e,2)},"Complex, number":a,"BigNumber, BigNumber":s,"Array | Matrix":function(e){return d(e,2)},"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":if(1!==t.density())throw new Error("Root must be non-zero");r=l(e,t,d);break;default:r=f(t,e,d,!0)}break;default:switch(t.storage()){case"sparse":if(1!==t.density())throw new Error("Root must be non-zero");r=c(e,t,d,!1);break;default:r=h(e,t,d)}}return r},"Array, Array":function(e,t){return d(u(e),u(t)).valueOf()},"Array, Matrix":function(e,t){return d(u(e),t)},"Matrix, Array":function(e,t){return d(e,u(t))},"Matrix, number | BigNumber":function(e,t){var r;switch(e.storage()){case"sparse":r=p(e,t,d,!1);break;default:r=m(e,t,d,!1)}return r},"number | BigNumber, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":if(1!==t.density())throw new Error("Root must be non-zero");r=p(t,e,d,!0);break;default:r=m(t,e,d,!0)}return r},"Array, number | BigNumber":function(e,t){return d(u(e),t).valueOf()},"number | BigNumber, Array":function(e,t){return d(e,u(t)).valueOf()}});return d.toTex={2:"\\sqrt[${args[1]}]{${args[0]}}"},d}function i(e,t){var r=t<0;if(r&&(t=-t),0===t)throw new Error("Root must be non-zero");if(e<0&&Math.abs(t)%2!=1)throw new Error("Root must be odd when a is negative.");if(0==e)return r?1/0:0;if(!isFinite(e))return r?0:e;var n=Math.pow(Math.abs(e),1/t);return n=e<0?-n:n,r?1/n:n}function a(e,t){if(t<0)throw new Error("Root must be greater than zero");if(0===t)throw new Error("Root must be non-zero");if(t%1!==0)throw new Error("Root must be an integer");for(var r=e.arg(),n=e.abs(),i=[],a=Math.pow(n,1/t),o=0;o<t;o++)i.push({r:a,phi:(r+2*Math.PI*o)/t});return i}t.name="nthRoot",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("square",{number:function(e){return e*e},Complex:function(e){return e.mul(e)},BigNumber:function(e){return e.times(e)},Fraction:function(e){return e.mul(e)},"Array | Matrix":function(e){return i(e,a,!0)},Unit:function(e){return e.pow(2)}});return a.toTex={1:"\\left(${args[0]}\\right)^2"},a}var i=r(1);t.name="square",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){var o=r(4),s=a("unaryPlus",{number:function(e){return e},Complex:function(e){return e},BigNumber:function(e){return e},Fraction:function(e){return e},Unit:function(e){return e.clone()},"Array | Matrix":function(e){return i(e,s,!0)},"boolean | string | null":function(r){return"BigNumber"==t.number?new e.BigNumber(+r):+r}});return s.toTex={1:o.operators.unaryPlus+"\\left(${args[0]}\\right)"},s}var i=r(1);t.name="unaryPlus",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){function o(e,r){var n,a,o,s=0,c=1,f=1,l=0;if(!i(e)||!i(r))throw new Error("Parameters in function xgcd must be integer numbers");for(;r;)a=Math.floor(e/r),o=e-a*r,n=s,s=c-a*s,c=n,n=f,f=l-a*f,l=n,e=r,r=o;var p;return p=e<0?[-e,-c,-l]:[e,e?c:0,l],"Array"===t.matrix?p:u(p)}function s(r,n){var i,a,o,s=new e.BigNumber(0),c=new e.BigNumber(1),f=s,l=c,p=c,h=s;if(!r.isInt()||!n.isInt())throw new Error("Parameters in function xgcd must be integer numbers");for(;!n.isZero();)a=r.div(n).floor(),o=r.mod(n),i=f,f=l.minus(a.times(f)),l=i,i=p,p=h.minus(a.times(p)),h=i,r=n,n=o;var m;return m=r.lt(s)?[r.neg(),l.neg(),h.neg()]:[r,r.isZero()?0:l,h],"Array"===t.matrix?m:u(m)}var u=n(r(0)),c=a("xgcd",{"number, number":o,"BigNumber, BigNumber":s});return c.toTex=void 0,c}var i=r(3).isInteger;t.name="xgcd",t.factory=n},function(e,t,r){e.exports=[r(445),r(447),r(448),r(450),r(452),r(454),r(456)]},function(e,t,r){"use strict";function n(e,t,n,o){var s=r(4),u=n(r(0)),c=n(r(24)),f=n(r(68)),l=n(r(17)),p=n(r(8)),h=n(r(6)),m=o("bitAnd",{"number, number":function(e,t){if(!i(e)||!i(t))throw new Error("Integers expected in function bitAnd");return e&t},"BigNumber, BigNumber":a,"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=f(e,t,m,!1);break;default:r=c(t,e,m,!0)}break;default:switch(t.storage()){case"sparse":r=c(e,t,m,!1);break;default:r=p(e,t,m)}}return r},"Array, Array":function(e,t){return m(u(e),u(t)).valueOf()},"Array, Matrix":function(e,t){return m(u(e),t)},"Matrix, Array":function(e,t){return m(e,u(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=l(e,t,m,!1);break;default:r=h(e,t,m,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=l(t,e,m,!0);break;default:r=h(t,e,m,!0)}return r},"Array, any":function(e,t){return h(u(e),t,m,!1).valueOf()},"any, Array":function(e,t){return h(u(t),e,m,!0).valueOf()}});return m.toTex={2:"\\left(${args[0]}"+s.operators.bitAnd+"${args[1]}\\right)"},m}var i=r(3).isInteger,a=r(446);t.name="bitAnd",t.factory=n},function(e,t,r){var n=r(85);e.exports=function(e,t){if(e.isFinite()&&!e.isInteger()||t.isFinite()&&!t.isInteger())throw new Error("Integers expected in function bitAnd");var r=e.constructor;if(e.isNaN()||t.isNaN())return new r(NaN);if(e.isZero()||t.eq(-1)||e.eq(t))return e;if(t.isZero()||e.eq(-1))return t;if(!e.isFinite()||!t.isFinite()){if(!e.isFinite()&&!t.isFinite())return e.isNegative()==t.isNegative()?e:new r(0);if(!e.isFinite())return t.isNegative()?e:e.isNegative()?new r(0):t;if(!t.isFinite())return e.isNegative()?t:t.isNegative()?new r(0):e}return n(e,t,function(e,t){return e&t})}},function(e,t,r){"use strict";function n(e,t,n,s){var u=r(4),c=s("bitNot",{number:function(e){if(!o(e))throw new Error("Integer expected in function bitNot");return~e},BigNumber:a,"Array | Matrix":function(e){return i(e,c)}});return c.toTex={1:u.operators.bitNot+"\\left(${args[0]}\\right)"},c}var i=r(1),a=r(86),o=r(3).isInteger;t.name="bitNot",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,o){var s=r(4),u=n(r(0)),c=n(r(33)),f=n(r(73)),l=n(r(36)),p=n(r(8)),h=n(r(6)),m=o("bitOr",{"number, number":function(e,t){if(!i(e)||!i(t))throw new Error("Integers expected in function bitOr");return e|t},"BigNumber, BigNumber":a,"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=f(e,t,m);break;default:r=c(t,e,m,!0)}break;default:switch(t.storage()){case"sparse":r=c(e,t,m,!1);break;default:r=p(e,t,m)}}return r},"Array, Array":function(e,t){return m(u(e),u(t)).valueOf()},"Array, Matrix":function(e,t){return m(u(e),t)},"Matrix, Array":function(e,t){return m(e,u(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=l(e,t,m,!1);break;default:r=h(e,t,m,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=l(t,e,m,!0);break;default:r=h(t,e,m,!0)}return r},"Array, any":function(e,t){return h(u(e),t,m,!1).valueOf()},"any, Array":function(e,t){return h(u(t),e,m,!0).valueOf()}});return m.toTex={2:"\\left(${args[0]}"+s.operators.bitOr+"${args[1]}\\right)"},m}var i=r(3).isInteger,a=r(449);t.name="bitOr",t.factory=n},function(e,t,r){var n=r(85);e.exports=function(e,t){if(e.isFinite()&&!e.isInteger()||t.isFinite()&&!t.isInteger())throw new Error("Integers expected in function bitOr");var r=e.constructor;if(e.isNaN()||t.isNaN())return new r(NaN);var i=new r(-1);return e.isZero()||t.eq(i)||e.eq(t)?t:t.isZero()||e.eq(i)?e:e.isFinite()&&t.isFinite()?n(e,t,function(e,t){return e|t}):!e.isFinite()&&!e.isNegative()&&t.isNegative()||e.isNegative()&&!t.isNegative()&&!t.isFinite()?i:e.isNegative()&&t.isNegative()?e.isFinite()?e:t:e.isFinite()?t:e}},function(e,t,r){"use strict";function n(e,t,n,o){var s=r(4),u=n(r(0)),c=n(r(15)),f=n(r(26)),l=n(r(16)),p=n(r(8)),h=n(r(6)),m=o("bitXor",{"number, number":function(e,t){if(!i(e)||!i(t))throw new Error("Integers expected in function bitXor");return e^t},"BigNumber, BigNumber":a,"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=f(e,t,m);break;default:r=c(t,e,m,!0)}break;default:switch(t.storage()){case"sparse":r=c(e,t,m,!1);break;default:r=p(e,t,m)}}return r},"Array, Array":function(e,t){return m(u(e),u(t)).valueOf()},"Array, Matrix":function(e,t){return m(u(e),t)},"Matrix, Array":function(e,t){return m(e,u(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=l(e,t,m,!1);break;default:r=h(e,t,m,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=l(t,e,m,!0);break;default:r=h(t,e,m,!0)}return r},"Array, any":function(e,t){return h(u(e),t,m,!1).valueOf()},"any, Array":function(e,t){return h(u(t),e,m,!0).valueOf()}});return m.toTex={2:"\\left(${args[0]}"+s.operators.bitXor+"${args[1]}\\right)"},m}var i=r(3).isInteger,a=r(451);t.name="bitXor",t.factory=n},function(e,t,r){var n=r(85),i=r(86);e.exports=function(e,t){if(e.isFinite()&&!e.isInteger()||t.isFinite()&&!t.isInteger())throw new Error("Integers expected in function bitXor");var r=e.constructor;if(e.isNaN()||t.isNaN())return new r(NaN);if(e.isZero())return t;if(t.isZero())return e;if(e.eq(t))return new r(0);var a=new r(-1);return e.eq(a)?i(t):t.eq(a)?i(e):e.isFinite()&&t.isFinite()?n(e,t,function(e,t){return e^t}):e.isFinite()||t.isFinite()?new r(e.isNegative()==t.isNegative()?1/0:-(1/0)):a}},function(e,t,r){"use strict";function n(e,t,n,o){var s=r(4),u=n(r(0)),c=n(r(11)),f=n(r(38)),l=n(r(33)),p=n(r(24)),h=n(r(87)),m=n(r(36)),d=n(r(17)),v=n(r(8)),g=n(r(6)),y=o("leftShift",{"number, number":function(e,t){if(!i(e)||!i(t))throw new Error("Integers expected in function leftShift");return e<<t},"BigNumber, BigNumber":a,"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=h(e,t,y,!1);break;default:r=p(t,e,y,!0)}break;default:switch(t.storage()){case"sparse":r=l(e,t,y,!1);break;default:r=v(e,t,y)}}return r},"Array, Array":function(e,t){return y(u(e),u(t)).valueOf()},"Array, Matrix":function(e,t){return y(u(e),t)},"Matrix, Array":function(e,t){return y(e,u(t))},"Matrix, number | BigNumber":function(e,t){if(!c(t,0)){var r;switch(e.storage()){case"sparse":r=d(e,t,y,!1);break;default:r=g(e,t,y,!1)}return r}return e.clone()},"number | BigNumber, Matrix":function(e,t){if(!c(e,0)){var r;switch(t.storage()){case"sparse":r=m(t,e,y,!0);break;default:r=g(t,e,y,!0)}return r}return f(t.size(),t.storage())},"Array, number | BigNumber":function(e,t){return y(u(e),t).valueOf()},"number | BigNumber, Array":function(e,t){return y(e,u(t)).valueOf()}});return y.toTex={2:"\\left(${args[0]}"+s.operators.leftShift+"${args[1]}\\right)"},y}var i=r(3).isInteger,a=r(453);t.name="leftShift",t.factory=n},function(e,t){e.exports=function(e,t){if(e.isFinite()&&!e.isInteger()||t.isFinite()&&!t.isInteger())throw new Error("Integers expected in function leftShift");var r=e.constructor;return e.isNaN()||t.isNaN()||t.isNegative()&&!t.isZero()?new r(NaN):e.isZero()||t.isZero()?e:e.isFinite()||t.isFinite()?t.lt(55)?e.times(Math.pow(2,t.toNumber())+""):e.times(new r(2).pow(t)):new r(NaN)}},function(e,t,r){"use strict";function n(e,t,n,o){var s=r(4),u=n(r(0)),c=n(r(11)),f=n(r(38)),l=n(r(33)),p=n(r(24)),h=n(r(87)),m=n(r(36)),d=n(r(17)),v=n(r(8)),g=n(r(6)),y=o("rightArithShift",{"number, number":function(e,t){if(!i(e)||!i(t))throw new Error("Integers expected in function rightArithShift");return e>>t},"BigNumber, BigNumber":a,"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=h(e,t,y,!1);break;default:r=p(t,e,y,!0)}break;default:switch(t.storage()){case"sparse":r=l(e,t,y,!1);break;default:r=v(e,t,y)}}return r},"Array, Array":function(e,t){return y(u(e),u(t)).valueOf()},"Array, Matrix":function(e,t){return y(u(e),t)},"Matrix, Array":function(e,t){return y(e,u(t))},"Matrix, number | BigNumber":function(e,t){if(!c(t,0)){var r;switch(e.storage()){case"sparse":r=d(e,t,y,!1);break;default:r=g(e,t,y,!1)}return r}return e.clone()},"number | BigNumber, Matrix":function(e,t){if(!c(e,0)){var r;switch(t.storage()){case"sparse":r=m(t,e,y,!0);break;default:r=g(t,e,y,!0)}return r}return f(t.size(),t.storage())},"Array, number | BigNumber":function(e,t){return y(u(e),t).valueOf()},"number | BigNumber, Array":function(e,t){return y(e,u(t)).valueOf()}});return y.toTex={2:"\\left(${args[0]}"+s.operators.rightArithShift+"${args[1]}\\right)"},y}var i=r(3).isInteger,a=r(455);t.name="rightArithShift",t.factory=n},function(e,t){e.exports=function(e,t){if(e.isFinite()&&!e.isInteger()||t.isFinite()&&!t.isInteger())throw new Error("Integers expected in function rightArithShift");var r=e.constructor;return e.isNaN()||t.isNaN()||t.isNegative()&&!t.isZero()?new r(NaN):e.isZero()||t.isZero()?e:t.isFinite()?t.lt(55)?e.div(Math.pow(2,t.toNumber())+"").floor():e.div(new r(2).pow(t)).floor():new r(e.isNegative()?-1:e.isFinite()?0:NaN)}},function(e,t,r){"use strict";function n(e,t,n,a){var o=r(4),s=n(r(0)),u=n(r(11)),c=n(r(38)),f=n(r(33)),l=n(r(24)),p=n(r(87)),h=n(r(36)),m=n(r(17)),d=n(r(8)),v=n(r(6)),g=a("rightLogShift",{"number, number":function(e,t){if(!i(e)||!i(t))throw new Error("Integers expected in function rightLogShift");return e>>>t},"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=p(e,t,g,!1);break;default:r=l(t,e,g,!0)}break;default:switch(t.storage()){case"sparse":r=f(e,t,g,!1);break;default:r=d(e,t,g)}}return r},"Array, Array":function(e,t){return g(s(e),s(t)).valueOf()},"Array, Matrix":function(e,t){return g(s(e),t)},"Matrix, Array":function(e,t){return g(e,s(t))},"Matrix, number | BigNumber":function(e,t){if(!u(t,0)){var r;switch(e.storage()){case"sparse":r=m(e,t,g,!1);break;default:r=v(e,t,g,!1)}return r}return e.clone()},"number | BigNumber, Matrix":function(e,t){if(!u(e,0)){var r;switch(t.storage()){case"sparse":r=h(t,e,g,!0);break;default:r=v(t,e,g,!0)}return r}return c(t.size(),t.storage())},"Array, number | BigNumber":function(e,t){return g(s(e),t).valueOf()},"number | BigNumber, Array":function(e,t){return g(e,s(t)).valueOf()}});return g.toTex={2:"\\left(${args[0]}"+o.operators.rightLogShift+"${args[1]}\\right)"},g}var i=r(3).isInteger;t.name="rightLogShift",t.factory=n},function(e,t,r){e.exports=[r(458),r(459),r(136),r(460)]},function(e,t,r){"use strict";function n(e,t,n,i){var a=n(r(18)),o=n(r(136)),s=n(r(57)),u=n(r(48)),c=i("bellNumbers",{"number | BigNumber":function(e){if(!u(e)||s(e))throw new TypeError("Non-negative integer value expected in function bellNumbers");for(var t=0,r=0;r<=e;r++)t=a(t,o(e,r));return t}});return c.toTex={1:"\\mathrm{B}_{${args[0]}}"},c}t.name="bellNumbers",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,i){var a=n(r(70)),o=n(r(20)),s=n(r(55)),u=n(r(48)),c=n(r(34)),f=i("composition",{"number | BigNumber, number | BigNumber":function(e,t){if(!(u(e)&&s(e)&&u(t)&&s(t)))throw new TypeError("Positive integer value expected in function composition");if(c(t,e))throw new TypeError("k must be less than or equal to n in function composition");return a(o(e,-1),o(t,-1))}});return f.toTex=void 0,f}t.name="composition",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,i){var a=n(r(18)),o=n(r(47)),s=n(r(12)),u=n(r(70)),c=n(r(57)),f=n(r(48)),l=i("catalan",{"number | BigNumber":function(e){if(!f(e)||c(e))throw new TypeError("Non-negative integer value expected in function catalan");return o(u(s(e,2),e),a(e,1))}});return l.toTex={1:"\\mathrm{C}_{${args[0]}}"},l}t.name="catalan",t.factory=n},function(e,t,r){e.exports=[r(462),r(123),r(463),r(464)]},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("arg",{number:function(e){return Math.atan2(0,e)},BigNumber:function(t){return e.BigNumber.atan2(0,t)},Complex:function(e){return e.arg()},"Array | Matrix":function(e){return i(e,a)}});return a.toTex={1:"\\arg\\left(${args[0]}\\right)"},a}var i=r(1);t.name="arg",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("im",{number:function(e){return 0},BigNumber:function(t){return new e.BigNumber(0)},Complex:function(e){return e.im},"Array | Matrix":function(e){return i(e,a)}});return a.toTex={1:"\\Im\\left\\lbrace${args[0]}\\right\\rbrace"},a}var i=r(1);t.name="im",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("re",{number:function(e){return e},BigNumber:function(e){return e},Complex:function(e){return e.re},"Array | Matrix":function(e){return i(e,a)}});return a.toTex={1:"\\Re\\left\\lbrace${args[0]}\\right\\rbrace"},a}var i=r(1);t.name="re",t.factory=n},function(e,t,r){e.exports=[r(466),r(467)]},function(e,t,r){"use strict";function n(e,t,n,i){function a(e){return 2===e.length&&"number"==typeof e[0]&&"number"==typeof e[1]}function o(e){return 3===e.length&&"number"==typeof e[0]&&"number"==typeof e[1]&&"number"==typeof e[2]}function s(e){return 4===e.length&&"number"==typeof e[0]&&"number"==typeof e[1]&&"number"==typeof e[2]&&"number"==typeof e[3]}function u(e,r,n,i){var a=e,o=n,s=d(a,r),u=d(o,i),c=s[0]*u[1]-u[0]*s[1];if(l(c)<t.epsilon)return null;var f=(u[0]*a[1]-u[1]*a[0]-u[0]*o[1]+u[1]*o[0])/c;return p(m(s,f),a)}function c(e,t,r,n,i,a,o,s,u,c,f,l){var p=(e-o)*(c-o)+(t-s)*(f-s)+(r-u)*(l-u),h=(c-o)*(n-e)+(f-s)*(i-t)+(l-u)*(a-r),m=(e-o)*(n-e)+(t-s)*(i-t)+(r-u)*(a-r),d=(c-o)*(c-o)+(f-s)*(f-s)+(l-u)*(l-u),v=(n-e)*(n-e)+(i-t)*(i-t)+(a-r)*(a-r),g=(p*h-m*d)/(v*d-h*h),y=(p+g*h)/d,x=e+g*(n-e),w=t+g*(i-t),b=r+g*(a-r),N=o+y*(c-o),E=s+y*(f-s),M=u+y*(l-u);return x===N&&w===E&&b===M?[x,w,b]:null}function f(e,t,r,n,i,a,o,s,u,c){var f=(c-e*o-t*s-r*u)/(n*o+i*s+a*u-e*o-t*s-r*u),l=e+f*(n-e),p=t+f*(i-t),h=r+f*(a-r);return[l,p,h]}var l=n(r(29)),p=n(r(18)),h=n(r(0)),m=n(r(12)),d=n(r(21)),v=i("intersect",{"Array, Array, Array":function(e,t,r){if(!o(e))throw new TypeError("Array with 3 numbers expected for first argument");if(!o(t))throw new TypeError("Array with 3 numbers expected for second argument");if(!s(r))throw new TypeError("Array with 4 numbers expected as third argument");return f(e[0],e[1],e[2],t[0],t[1],t[2],r[0],r[1],r[2],r[3])},"Array, Array, Array, Array":function(e,t,r,n){if(2===e.length){if(!a(e))throw new TypeError("Array with 2 numbers expected for first argument");if(!a(t))throw new TypeError("Array with 2 numbers expected for second argument");if(!a(r))throw new TypeError("Array with 2 numbers expected for third argument");if(!a(n))throw new TypeError("Array with 2 numbers expected for fourth argument");return u(e,t,r,n)}if(3===e.length){if(!o(e))throw new TypeError("Array with 3 numbers expected for first argument");if(!o(t))throw new TypeError("Array with 3 numbers expected for second argument");if(!o(r))throw new TypeError("Array with 3 numbers expected for third argument");if(!o(n))throw new TypeError("Array with 3 numbers expected for fourth argument");return c(e[0],e[1],e[2],t[0],t[1],t[2],r[0],r[1],r[2],n[0],n[1],n[2])}throw new TypeError("Arrays with two or thee dimensional points expected")},"Matrix, Matrix, Matrix":function(e,t,r){return h(v(e.valueOf(),t.valueOf(),r.valueOf()))},"Matrix, Matrix, Matrix, Matrix":function(e,t,r,n){return h(v(e.valueOf(),t.valueOf(),r.valueOf(),n.valueOf()))}});return v}t.name="intersect",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,s){var m=(n(r(0)),s("distance",{"Array, Array, Array":function(e,t,r){if(2==e.length&&2==t.length&&2==r.length){if(!i(e))throw new TypeError("Array with 2 numbers expected for first argument");if(!i(t))throw new TypeError("Array with 2 numbers expected for second argument");if(!i(r))throw new TypeError("Array with 2 numbers expected for third argument");var n=(r[1]-r[0])/(t[1]-t[0]),a=n*n*t[0],o=-1*(n*t[0]),s=e[1];return c(e[0],e[1],a,o,s)}throw new TypeError("Invalid Arguments: Try again")},"Object, Object, Object":function(e,t,r){if(2==Object.keys(e).length&&2==Object.keys(t).length&&2==Object.keys(r).length){if(!i(e))throw new TypeError("Values of pointX and pointY should be numbers");if(!i(t))throw new TypeError("Values of lineOnePtX and lineOnePtY should be numbers");if(!i(r))throw new TypeError("Values of lineTwoPtX and lineTwoPtY should be numbers");if(e.hasOwnProperty("pointX")&&e.hasOwnProperty("pointY")&&t.hasOwnProperty("lineOnePtX")&&t.hasOwnProperty("lineOnePtY")&&r.hasOwnProperty("lineTwoPtX")&&r.hasOwnProperty("lineTwoPtY")){var n=(r.lineTwoPtY-r.lineTwoPtX)/(t.lineOnePtY-t.lineOnePtX),a=n*n*t.lineOnePtX,o=-1*(n*t.lineOnePtX),s=e.pointX;
return c(e.pointX,e.pointY,a,o,s)}throw new TypeError("Key names do not match")}throw new TypeError("Invalid Arguments: Try again")},"Array, Array":function(e,t){if(2==e.length&&3==t.length){if(!i(e))throw new TypeError("Array with 2 numbers expected for first argument");if(!a(t))throw new TypeError("Array with 3 numbers expected for second argument");return c(e[0],e[1],t[0],t[1],t[2])}if(3==e.length&&6==t.length){if(!a(e))throw new TypeError("Array with 3 numbers expected for first argument");if(!o(t))throw new TypeError("Array with 6 numbers expected for second argument");return f(e[0],e[1],e[2],t[0],t[1],t[2],t[3],t[4],t[5])}if(2==e.length&&2==t.length){if(!i(e))throw new TypeError("Array with 2 numbers expected for first argument");if(!i(t))throw new TypeError("Array with 2 numbers expected for second argument");return l(e[0],e[1],t[0],t[1])}if(3==e.length&&3==t.length){if(!a(e))throw new TypeError("Array with 3 numbers expected for first argument");if(!a(t))throw new TypeError("Array with 3 numbers expected for second argument");return p(e[0],e[1],e[2],t[0],t[1],t[2])}throw new TypeError("Invalid Arguments: Try again")},"Object, Object":function(e,t){if(2==Object.keys(e).length&&3==Object.keys(t).length){if(!i(e))throw new TypeError("Values of pointX and pointY should be numbers");if(!a(t))throw new TypeError("Values of xCoeffLine, yCoeffLine and constant should be numbers");if(e.hasOwnProperty("pointX")&&e.hasOwnProperty("pointY")&&t.hasOwnProperty("xCoeffLine")&&t.hasOwnProperty("yCoeffLine")&&t.hasOwnProperty("yCoeffLine"))return c(e.pointX,e.pointY,t.xCoeffLine,t.yCoeffLine,t.constant);throw new TypeError("Key names do not match")}if(3==Object.keys(e).length&&6==Object.keys(t).length){if(!a(e))throw new TypeError("Values of pointX, pointY and pointZ should be numbers");if(!o(t))throw new TypeError("Values of x0, y0, z0, a, b and c should be numbers");if(e.hasOwnProperty("pointX")&&e.hasOwnProperty("pointY")&&t.hasOwnProperty("x0")&&t.hasOwnProperty("y0")&&t.hasOwnProperty("z0")&&t.hasOwnProperty("a")&&t.hasOwnProperty("b")&&t.hasOwnProperty("c"))return f(e.pointX,e.pointY,e.pointZ,t.x0,t.y0,t.z0,t.a,t.b,t.c);throw new TypeError("Key names do not match")}if(2==Object.keys(e).length&&2==Object.keys(t).length){if(!i(e))throw new TypeError("Values of pointOneX and pointOneY should be numbers");if(!i(t))throw new TypeError("Values of pointTwoX and pointTwoY should be numbers");if(e.hasOwnProperty("pointOneX")&&e.hasOwnProperty("pointOneY")&&t.hasOwnProperty("pointTwoX")&&t.hasOwnProperty("pointTwoY"))return l(e.pointOneX,e.pointOneY,t.pointTwoX,t.pointTwoY);throw new TypeError("Key names do not match")}if(3==Object.keys(e).length&&3==Object.keys(t).length){if(!a(e))throw new TypeError("Values of pointOneX, pointOneY and pointOneZ should be numbers");if(!a(t))throw new TypeError("Values of pointTwoX, pointTwoY and pointTwoZ should be numbers");if(e.hasOwnProperty("pointOneX")&&e.hasOwnProperty("pointOneY")&&e.hasOwnProperty("pointOneZ")&&t.hasOwnProperty("pointTwoX")&&t.hasOwnProperty("pointTwoY")&&t.hasOwnProperty("pointTwoZ"))return p(e.pointOneX,e.pointOneY,e.pointOneZ,t.pointTwoX,t.pointTwoY,t.pointTwoZ);throw new TypeError("Key names do not match")}throw new TypeError("Invalid Arguments: Try again")},Array:function(e){if(!u(e))throw new TypeError("Incorrect array format entered for pairwise distance calculation");return h(e)}}));return m}function i(e){return e.constructor!==Array&&(e=s(e)),"number"==typeof e[0]&&"number"==typeof e[1]}function a(e){return e.constructor!==Array&&(e=s(e)),"number"==typeof e[0]&&"number"==typeof e[1]&&"number"==typeof e[2]}function o(e){return e.constructor!==Array&&(e=s(e)),"number"==typeof e[0]&&"number"==typeof e[1]&&"number"==typeof e[2]&&"number"==typeof e[3]&&"number"==typeof e[4]&&"number"==typeof e[5]}function s(e){for(var t=Object.keys(e),r=[],n=0;n<t.length;n++)r.push(e[t[n]]);return r}function u(e){if(2==e[0].length&&"number"==typeof e[0][0]&&"number"==typeof e[0][1]){for(var t in e)if(2!=e[t].length||"number"!=typeof e[t][0]||"number"!=typeof e[t][1])return!1}else{if(3!=e[0].length||"number"!=typeof e[0][0]||"number"!=typeof e[0][1]||"number"!=typeof e[0][2])return!1;for(var t in e)if(3!=e[t].length||"number"!=typeof e[t][0]||"number"!=typeof e[t][1]||"number"!=typeof e[t][2])return!1}return!0}function c(e,t,r,n,i){var a=Math.abs(r*e+n*t+i),o=Math.pow(r*r+n*n,.5),s=a/o;return s}function f(e,t,r,n,i,a,o,s,u){var c=[(i-t)*u-(a-r)*s,(a-r)*o-(n-e)*u,(n-e)*s-(i-t)*o];c=Math.pow(c[0]*c[0]+c[1]*c[1]+c[2]*c[2],.5);var f=Math.pow(o*o+s*s+u*u,.5),l=c/f;return l}function l(e,t,r,n){var i=n-t,a=r-e,o=i*i+a*a,s=Math.pow(o,.5);return s}function p(e,t,r,n,i,a){var o=a-r,s=i-t,u=n-e,c=o*o+s*s+u*u,f=Math.pow(c,.5);return f}function h(e){for(var t=[],r=0;r<e.length-1;r++)for(var n=r+1;n<e.length;n++)2==e[0].length?t.push(l(e[r][0],e[r][1],e[n][0],e[n][1])):3==e[0].length&&t.push(p(e[r][0],e[r][1],e[r][2],e[n][0],e[n][1],e[n][2]));return t}t.name="distance",t.factory=n},function(e,t,r){e.exports=[r(469),r(138),r(470),r(471)]},function(e,t,r){"use strict";function n(e,t,n,i){var a=r(4),o=n(r(0)),s=n(r(38)),u=n(r(138)),c=(n(r(82)),n(r(24))),f=n(r(68)),l=n(r(17)),p=n(r(8)),h=n(r(6)),m=i("and",{"number, number":function(e,t){return!(!e||!t)},"Complex, Complex":function(e,t){return!(0===e.re&&0===e.im||0===t.re&&0===t.im)},"BigNumber, BigNumber":function(e,t){return!(e.isZero()||t.isZero()||e.isNaN()||t.isNaN())},"Unit, Unit":function(e,t){return m(e.value,t.value)},"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=f(e,t,m,!1);break;default:r=c(t,e,m,!0)}break;default:switch(t.storage()){case"sparse":r=c(e,t,m,!1);break;default:r=p(e,t,m)}}return r},"Array, Array":function(e,t){return m(o(e),o(t)).valueOf()},"Array, Matrix":function(e,t){return m(o(e),t)},"Matrix, Array":function(e,t){return m(e,o(t))},"Matrix, any":function(e,t){if(u(t))return s(e.size(),e.storage());var r;switch(e.storage()){case"sparse":r=l(e,t,m,!1);break;default:r=h(e,t,m,!1)}return r},"any, Matrix":function(e,t){if(u(e))return s(e.size(),e.storage());var r;switch(t.storage()){case"sparse":r=l(t,e,m,!0);break;default:r=h(t,e,m,!0)}return r},"Array, any":function(e,t){return m(o(e),t).valueOf()},"any, Array":function(e,t){return m(e,o(t)).valueOf()}});return m.toTex={2:"\\left(${args[0]}"+a.operators.and+"${args[1]}\\right)"},m}t.name="and",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,i){var a=r(4),o=n(r(0)),s=n(r(15)),u=n(r(60)),c=n(r(16)),f=n(r(8)),l=n(r(6)),p=i("or",{"number, number":function(e,t){return!(!e&&!t)},"Complex, Complex":function(e,t){return 0!==e.re||0!==e.im||0!==t.re||0!==t.im},"BigNumber, BigNumber":function(e,t){return!e.isZero()&&!e.isNaN()||!t.isZero()&&!t.isNaN()},"Unit, Unit":function(e,t){return p(e.value,t.value)},"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=u(e,t,p);break;default:r=s(t,e,p,!0)}break;default:switch(t.storage()){case"sparse":r=s(e,t,p,!1);break;default:r=f(e,t,p)}}return r},"Array, Array":function(e,t){return p(o(e),o(t)).valueOf()},"Array, Matrix":function(e,t){return p(o(e),t)},"Matrix, Array":function(e,t){return p(e,o(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=c(e,t,p,!1);break;default:r=l(e,t,p,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=c(t,e,p,!0);break;default:r=l(t,e,p,!0)}return r},"Array, any":function(e,t){return l(o(e),t,p,!1).valueOf()},"any, Array":function(e,t){return l(o(t),e,p,!0).valueOf()}});return p.toTex={2:"\\left(${args[0]}"+a.operators.or+"${args[1]}\\right)"},p}t.name="or",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,i){var a=r(4),o=n(r(0)),s=n(r(15)),u=n(r(26)),c=n(r(16)),f=n(r(8)),l=n(r(6)),p=i("xor",{"number, number":function(e,t){return!!e!=!!t},"Complex, Complex":function(e,t){return(0!==e.re||0!==e.im)!=(0!==t.re||0!==t.im)},"BigNumber, BigNumber":function(e,t){return(!e.isZero()&&!e.isNaN())!=(!t.isZero()&&!t.isNaN())},"Unit, Unit":function(e,t){return p(e.value,t.value)},"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=u(e,t,p);break;default:r=s(t,e,p,!0)}break;default:switch(t.storage()){case"sparse":r=s(e,t,p,!1);break;default:r=f(e,t,p)}}return r},"Array, Array":function(e,t){return p(o(e),o(t)).valueOf()},"Array, Matrix":function(e,t){return p(o(e),t)},"Matrix, Array":function(e,t){return p(e,o(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=c(e,t,p,!1);break;default:r=l(e,t,p,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=c(t,e,p,!0);break;default:r=l(t,e,p,!0)}return r},"Array, any":function(e,t){return l(o(e),t,p,!1).valueOf()},"any, Array":function(e,t){return l(o(t),e,p,!0).valueOf()}});return p.toTex={2:"\\left(${args[0]}"+a.operators.xor+"${args[1]}\\right)"},p}t.name="xor",t.factory=n},function(e,t,r){e.exports=[r(64),r(473),r(115),r(474),r(475),r(61),r(476),r(477),r(478),r(114),r(479),r(139),r(480),r(88),r(117),r(481),r(482),r(28),r(140),r(484),r(22),r(135),r(67),r(38)]},function(e,t,r){"use strict";function n(e,t,n,a){function o(e,t){var r=Math.max(i.size(e).length,i.size(t).length);e=i.squeeze(e),t=i.squeeze(t);var n=i.size(e),a=i.size(t);if(1!=n.length||1!=a.length||3!=n[0]||3!=a[0])throw new RangeError("Vectors with length 3 expected (Size A = ["+n.join(", ")+"], B = ["+a.join(", ")+"])");var o=[u(c(e[1],t[2]),c(e[2],t[1])),u(c(e[2],t[0]),c(e[0],t[2])),u(c(e[0],t[1]),c(e[1],t[0]))];return r>1?[o]:o}var s=n(r(0)),u=n(r(21)),c=n(r(12)),f=a("cross",{"Matrix, Matrix":function(e,t){return s(o(e.toArray(),t.toArray()))},"Matrix, Array":function(e,t){return s(o(e.toArray(),t))},"Array, Matrix":function(e,t){return s(o(e,t.toArray()))},"Array, Array":o});return f.toTex={2:"\\left(${args[0]}\\right)\\times\\left(${args[1]}\\right)"},f}var i=r(2);t.name="cross",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,o){function s(e,t,r,n){if(!a(t))throw new TypeError("Second parameter in function diag must be an integer");var i=t>0?t:0,o=t<0?-t:0;switch(r.length){case 1:return u(e,t,n,r[0],o,i);case 2:return c(e,t,n,r,o,i)}throw new RangeError("Matrix for function diag must be 2 dimensional")}function u(t,r,n,i,a,o){var s=[i+a,i+o],u=e.Matrix.storage(n||"dense"),c=u.diagonal(s,t,r);return null!==n?c:c.valueOf()}function c(t,r,n,i,a,o){if(e.isMatrix(t)){var s=t.diagonal(r);return null!==n?n!==s.storage()?f(s,n):s:s.valueOf()}for(var u=Math.min(i[0]-a,i[1]-o),c=[],l=0;l<u;l++)c[l]=t[l+a][l+o];return null!==n?f(c):c}var f=n(r(0)),l=o("diag",{Array:function(e){return s(e,0,i.size(e),null)},"Array, number":function(e,t){return s(e,t,i.size(e),null)},"Array, BigNumber":function(e,t){return s(e,t.toNumber(),i.size(e),null)},"Array, string":function(e,t){return s(e,0,i.size(e),t)},"Array, number, string":function(e,t,r){return s(e,t,i.size(e),r)},"Array, BigNumber, string":function(e,t,r){return s(e,t.toNumber(),i.size(e),r)},Matrix:function(e){return s(e,0,e.size(),e.storage())},"Matrix, number":function(e,t){return s(e,t,e.size(),e.storage())},"Matrix, BigNumber":function(e,t){return s(e,t.toNumber(),e.size(),e.storage())},"Matrix, string":function(e,t){return s(e,0,e.size(),t)},"Matrix, number, string":function(e,t,r){return s(e,t,e.size(),r)},"Matrix, BigNumber, string":function(e,t,r){return s(e,t.toNumber(),e.size(),r)}});return l.toTex=void 0,l}var i=r(2),a=(r(5).clone,r(3).isInteger);t.name="diag",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){function o(e,t){var r=i(e),n=i(t),a=r[0];if(1!==r.length||1!==n.length)throw new RangeError("Vector expected");if(r[0]!=n[0])throw new RangeError("Vectors must have equal length ("+r[0]+" != "+n[0]+")");if(0==a)throw new RangeError("Cannot calculate the dot product of empty vectors");for(var o=0,c=0;c<a;c++)o=s(o,u(e[c],t[c]));return o}var s=n(r(18)),u=n(r(12)),c=a("dot",{"Matrix, Matrix":function(e,t){return o(e.toArray(),t.toArray())},"Matrix, Array":function(e,t){return o(e.toArray(),t)},"Array, Matrix":function(e,t){return o(e,t.toArray())},"Array, Array":o});return c.toTex={2:"\\left(${args[0]}\\cdot${args[1]}\\right)"},c}var i=r(2).size;t.name="dot",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){var s=n(r(0)),u=a("filter",{"Array, function":i,"Matrix, function":function(e,t){return s(i(e.toArray(),t))},"Array, RegExp":o,"Matrix, RegExp":function(e,t){return s(o(e.toArray(),t))}});return u.toTex=void 0,u}function i(e,t){var r=s(t);return a(e,function(e,n,i){return 1===r?t(e):2===r?t(e,[n]):t(e,[n],i)})}var a=r(2).filter,o=r(2).filterRegExp,s=r(32).maxArgumentCount;t.name="filter",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,o){var s=n(r(0)),u=o("flatten",{Array:function(e){return a(i(e))},Matrix:function(e){var t=a(i(e.toArray()));return s(t)}});return u.toTex=void 0,u}var i=r(5).clone,a=r(2).flatten;t.name="flatten",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("forEach",{"Array, function":i,"Matrix, function":function(e,t){return e.forEach(t)}});return a.toTex=void 0,a}function i(e,t){var r=a(t),n=function(i,a){Array.isArray(i)?o(i,function(e,t){n(e,a.concat(t))}):1===r?t(i):2===r?t(i,a):t(i,a,e)};n(e,[])}var a=r(32).maxArgumentCount,o=r(2).forEach;t.name="forEach",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){function o(e,t){if(1===i(e).length&&(e=[e]),1===i(t).length&&(t=[t]),i(e).length>2||i(t).length>2)throw new RangeError("Vectors with dimensions greater then 2 are not supported expected (Size x = "+JSON.stringify(e.length)+", y = "+JSON.stringify(t.length)+")");var r=[],n=[];return e.map(function(e){return t.map(function(t){return e.map(function(e){return t.map(function(t){return n.push(u(e,t))})},r.push(n=[]))})},r=[])&&r}var s=n(r(0)),u=n(r(23)),c=a("kron",{"Matrix, Matrix":function(e,t){return s(o(e.toArray(),t.toArray()))},"Matrix, Array":function(e,t){return s(o(e.toArray(),t))},"Array, Matrix":function(e,t){return s(o(e,t.toArray()))},"Array, Array":o});return c}var i=r(2).size;t.name="kron",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,o){function s(t,r){var n=u(t),i=n?new e.BigNumber(1):1;if(c(t),r){var o=f(r);return t.length>0?o.resize(t,i):o}var s=[];return t.length>0?a(s,t,i):s}function u(t){var r=!1;return t.forEach(function(t,n,i){e.isBigNumber(t)&&(r=!0,i[n]=t.toNumber())}),r}function c(e){e.forEach(function(e){if("number"!=typeof e||!i(e)||e<0)throw new Error("Parameters in function ones must be positive integers")})}var f=n(r(0)),l=o("ones",{"":function(){return"Array"===t.matrix?s([]):s([],"default")},"...number | BigNumber | string":function(e){var r=e[e.length-1];if("string"==typeof r){var n=e.pop();return s(e,n)}return"Array"===t.matrix?s(e):s(e,"default")},Array:s,Matrix:function(e){var t=e.storage();return s(e.valueOf(),t)},"Array | Matrix, string":function(e,t){return s(e.valueOf(),t)}});return l.toTex=void 0,l}var i=r(3).isInteger,a=r(2).resize;t.name="ones",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,o){var s=n(r(0)),u=o("reshape",{"Matrix, Array":function(e,t){return e.reshape?e.reshape(t):s(a.reshape(e.valueOf(),t))},"Array, Array":function(e,t){return t.forEach(function(e){if(!i(e))throw new TypeError("Invalid size for dimension: "+e)}),a.reshape(e,t)}});return u.toTex=void 0,u}var i=(r(10),r(3).isInteger),a=r(2);t.name="reshape",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,f){function l(e,t,r){if(void 0!==r){if("string"!=typeof r||1!==r.length)throw new TypeError("Single character expected as defaultValue")}else r=" ";if(1!==t.length)throw new i(t.length,1);var n=t[0];if("number"!=typeof n||!o(n))throw new TypeError("Invalid size, must contain positive integers (size: "+s(t)+")");if(e.length>n)return e.substring(0,n);if(e.length<n){for(var a=e,u=0,c=n-e.length;u<c;u++)a+=r;return a}return e}var p=n(r(0)),h=function(r,n,i){if(2!=arguments.length&&3!=arguments.length)throw new a("resize",arguments.length,2,3);if(e.isMatrix(n)&&(n=n.valueOf()),e.isBigNumber(n[0])&&(n=n.map(function(t){return e.isBigNumber(t)?t.toNumber():t})),e.isMatrix(r))return r.resize(n,i,!0);if("string"==typeof r)return l(r,n,i);var o=!Array.isArray(r)&&"Array"!==t.matrix;if(0==n.length){for(;Array.isArray(r);)r=r[0];return u(r)}Array.isArray(r)||(r=[r]),r=u(r);var s=c.resize(r,n,i);return o?p(s):s};return h.toTex=void 0,h}var i=r(10),a=r(50),o=r(3).isInteger,s=r(9).format,u=r(5).clone,c=r(2);t.name="resize",t.factory=n},function(e,t){e.exports=function e(t,r){"use strict";var n,i,a=/(^([+\-]?(?:0|[1-9]\d*)(?:\.\d*)?(?:[eE][+\-]?\d+)?)?$|^0x[0-9a-f]+$|\d+)/gi,o=/(^[ ]*|[ ]*$)/g,s=/(^([\w ]+,?[\w ]+)?[\w ]+,?[\w ]+\d+:\d+(:\d+)?[\w ]?|^\d{1,4}[\/\-]\d{1,4}[\/\-]\d{1,4}|^\w+, \w+ \d+, \d{4})/,u=/^0x[0-9a-f]+$/i,c=/^0/,f=function(t){return e.insensitive&&(""+t).toLowerCase()||""+t},l=f(t).replace(o,"")||"",p=f(r).replace(o,"")||"",h=l.replace(a,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),m=p.replace(a,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),d=parseInt(l.match(u),16)||1!==h.length&&l.match(s)&&Date.parse(l),v=parseInt(p.match(u),16)||d&&p.match(s)&&Date.parse(p)||null;if(v){if(d<v)return-1;if(d>v)return 1}for(var g=0,y=Math.max(h.length,m.length);g<y;g++){if(n=!(h[g]||"").match(c)&&parseFloat(h[g])||h[g]||0,i=!(m[g]||"").match(c)&&parseFloat(m[g])||m[g]||0,isNaN(n)!==isNaN(i))return isNaN(n)?1:-1;if(typeof n!=typeof i&&(n+="",i+=""),n<i)return-1;if(n>i)return 1}return 0}},function(e,t,r){"use strict";function n(e,t,n,o){var s=n(r(0)),u=o("squeeze",{Array:function(e){return a.squeeze(i.clone(e))},Matrix:function(e){var t=a.squeeze(e.toArray());return Array.isArray(t)?s(t):t},any:function(e){return i.clone(e)}});return u.toTex=void 0,u}var i=r(5),a=r(2);t.name="squeeze",t.factory=n},function(e,t,r){e.exports=[r(70),r(69),r(137),r(486),r(487),r(488),r(489),r(493),r(494)]},function(e,t,r){"use strict";function n(e,t,n,i){function a(e,t){var r=t.size().length,n=e.size().length;if(r>1)throw new Error("first object must be one dimensional");if(n>1)throw new Error("second object must be one dimensional");if(r!==n)throw new Error("Length of two vectors must be equal");var i=u(e);if(0===i)throw new Error("Sum of elements in first object must be non zero");var a=u(t);if(0===a)throw new Error("Sum of elements in second object must be non zero");var o=s(e,u(e)),h=s(t,u(t)),m=u(c(o,l(f(o,h))));return p(m)?m:Number.NaN}var o=n(r(0)),s=n(r(47)),u=n(r(141)),c=n(r(12)),f=n(r(132)),l=n(r(134)),p=n(r(75)),h=i("kldivergence",{"Array, Array":function(e,t){return a(o(e),o(t))},"Matrix, Array":function(e,t){return a(e,o(t))},"Array, Matrix":function(e,t){return a(o(e),t)},"Matrix, Matrix":function(e,t){return a(e,t)}});return h}t.name="kldivergence",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){var o=n(r(18)),s=n(r(12)),u=n(r(47)),c=n(r(69)),f=n(r(48)),l=n(r(55));return a("multinomial",{"Array | Matrix":function(e){var t=0,r=1;return i(e,function(e){if(!f(e)||!l(e))throw new TypeError("Positive integer value expected in function multinomial");t=o(t,e),r=s(r,c(e))}),u(c(t),r)}})}var i=r(42);t.name="multinomial",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,o){var s=n(r(69)),u=o("permutations",{"number | BigNumber":s,"number, number":function(e,t){var r,n;if(!a(e)||e<0)throw new TypeError("Positive integer value expected in function permutations");if(!a(t)||t<0)throw new TypeError("Positive integer value expected in function permutations");if(t>e)throw new TypeError("second argument k must be less than or equal to first argument n");for(r=1,n=e-t+1;n<=e;n++)r*=n;return r},"BigNumber, BigNumber":function(t,r){var n,a;if(!i(t)||!i(r))throw new TypeError("Positive integer value expected in function permutations");if(r.gt(t))throw new TypeError("second argument k must be less than or equal to first argument n");for(n=new e.BigNumber(1),a=t.minus(r).plus(1);a.lte(t);a=a.plus(1))n=n.times(a);return n}});return u.toTex=void 0,u}function i(e){return e.isInteger()&&e.gte(0)}var a=r(3).isInteger;t.name="permutations",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,i){var a=n(r(89)),o=a("uniform").pickRandom;return o.toTex=void 0,o}t.name="pickRandom",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n,o){function s(e){c=null===e?a:i(String(e))}function u(){return c()}var c;return s(t.randomSeed),o.on("config",function(e,t,r){void 0!==r.randomSeed&&s(e.randomSeed)}),u}var i=r(491),a=i();t.factory=n,t.math=!0},function(e,t,r){"use strict";(function(t){function r(e){var t,r=e.length,n=this,i=0,a=n.i=n.j=0,o=n.S=[];for(r||(e=[r++]);i<s;)o[i]=i++;for(i=0;i<s;i++)o[i]=o[a=d&a+e[i%r]+(t=o[i])],o[a]=t;(n.g=function(e){for(var t,r=0,i=n.i,a=n.j,o=n.S;e--;)t=o[i=d&i+1],r=r*s+o[d&(o[i]=o[a=d&a+t])+(o[a]=t)];return n.i=i,n.j=a,r})(s)}function n(e,t){var r,i=[],a=(typeof e)[0];if(t&&"o"==a)for(r in e)try{i.push(n(e[r],t-1))}catch(e){}return i.length?i:"s"==a?e:e+"\0"}function i(e,t){for(var r,n=e+"",i=0;i<n.length;)t[d&i]=d&(r^=19*t[d&i])+n.charCodeAt(i++);return o(t)}function a(e){try{return l.crypto.getRandomValues(e=new Uint8Array(s)),o(e)}catch(e){return[+new Date,l,l.navigator&&l.navigator.plugins,l.screen,o(f)]}}function o(e){return String.fromCharCode.apply(0,e)}var s=256,u=6,c=52,f=[],l="undefined"==typeof t?window:t,p=Math.pow(s,u),h=Math.pow(2,c),m=2*h,d=s-1,v=Math.random;e.exports=function(t,c){if(c&&c.global===!0)return c.global=!1,Math.random=e.exports(t,c),c.global=!0,Math.random;var l=c&&c.entropy||!1,d=[],v=(i(n(l?[t,o(f)]:0 in arguments?t:a(),3),d),new r(d));return i(o(v.S),f),function(){for(var e=v.g(u),t=p,r=0;e<h;)e=(e+r)*s,t*=s,r=v.g(1);for(;e>=m;)e/=2,t/=2,r>>>=1;return(e+r)/t}},e.exports.resetGlobal=function(){Math.random=v},i(Math.random(),f)}).call(t,r(492))},function(e,t){var r;r=function(){return this}();try{r=r||Function("return this")()||(0,eval)("this")}catch(e){"object"==typeof window&&(r=window)}e.exports=r},function(e,t,r){"use strict";function n(e,t,n,i){var a=n(r(89)),o=a("uniform").random;return o.toTex=void 0,o}t.name="random",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,i){var a=n(r(89)),o=a("uniform").randomInt;return o.toTex=void 0,o}t.name="randomInt",t.factory=n},function(e,t,r){e.exports=[r(49),r(31),r(496),r(30),r(34),r(127),r(44),r(497),r(121)]},function(e,t,r){"use strict";function n(e,t,n,i){function a(e,t){if(Array.isArray(e)){if(Array.isArray(t)){var r=e.length;if(r!==t.length)return!1;for(var n=0;n<r;n++)if(!a(e[n],t[n]))return!1;return!0}return!1}return!Array.isArray(t)&&o(e,t)}var o=n(r(30)),s=i("deepEqual",{"any, any":function(e,t){return a(e.valueOf(),t.valueOf())}});return s.toTex=void 0,s}t.name="deepEqual",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,o){var s=n(r(0)),u=n(r(15)),c=n(r(26)),f=n(r(16)),l=n(r(8)),p=n(r(6)),h=r(4),m=o("smallerEq",{"boolean, boolean":function(e,t){return e<=t},"number, number":function(e,r){return e<=r||i(e,r,t.epsilon)},"BigNumber, BigNumber":function(e,r){return e.lte(r)||a(e,r,t.epsilon)},"Fraction, Fraction":function(e,t){return 1!==e.compare(t)},"Complex, Complex":function(){throw new TypeError("No ordering relation is defined for complex numbers")},"Unit, Unit":function(e,t){if(!e.equalBase(t))throw new Error("Cannot compare units with different base");return m(e.value,t.value)},"string, string":function(e,t){return e<=t},"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=c(e,t,m);break;default:r=u(t,e,m,!0)}break;default:switch(t.storage()){case"sparse":r=u(e,t,m,!1);break;default:r=l(e,t,m)}}return r},"Array, Array":function(e,t){return m(s(e),s(t)).valueOf()},"Array, Matrix":function(e,t){return m(s(e),t)},"Matrix, Array":function(e,t){return m(e,s(t))},"Matrix, any":function(e,t){var r;switch(e.storage()){case"sparse":r=f(e,t,m,!1);break;default:r=p(e,t,m,!1)}return r},"any, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=f(t,e,m,!0);break;default:r=p(t,e,m,!0)}return r},"Array, any":function(e,t){return p(s(e),t,m,!1).valueOf()},"any, Array":function(e,t){return p(s(t),e,m,!0).valueOf()}});return m.toTex={2:"\\left(${args[0]}"+h.operators.smallerEq+"${args[1]}\\right)"},m}var i=r(3).nearlyEqual,a=r(35);t.name="smallerEq",t.factory=n},function(e,t,r){e.exports=[r(499),r(142),r(500),r(143),r(501),r(502),r(503),r(504),r(144),r(505)]},function(e,t,r){"use strict";function n(e,t,n,a){var o=n(r(27)),s=n(r(43)),u=n(r(28)),c=n(r(22)),f=n(r(31)),l=a("setCartesian",{"Array | Matrix, Array | Matrix":function(e,t){if(0===c(u(e),new o(0))||0===c(u(t),new o(0)))var r=[];else for(var n=i(Array.isArray(e)?e:e.toArray()).sort(f),a=i(Array.isArray(t)?t:t.toArray()).sort(f),r=[],l=0;l<n.length;l++)for(var p=0;p<a.length;p++)r.push([n[l],a[p]]);return Array.isArray(e)&&Array.isArray(t)?r:new s(r)}});return l}var i=r(2).flatten;t.name="setCartesian",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){var o=n(r(30)),s=n(r(27)),u=n(r(43)),c=n(r(28)),f=n(r(22)),l=n(r(31)),p=a("setDistinct",{"Array | Matrix":function(e){if(0===f(c(e),new s(0)))var t=[];else{var r=i(Array.isArray(e)?e:e.toArray()).sort(l),t=[];t.push(r[0]);for(var n=1;n<r.length;n++)o(r[n],r[n-1])||t.push(r[n])}return Array.isArray(e)?t:new u(t)}});return p}var i=r(2).flatten;t.name="setDistinct",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,o){var s=n(r(30)),u=n(r(27)),c=n(r(28)),f=n(r(22)),l=n(r(31)),p=o("setIsSubset",{"Array | Matrix, Array | Matrix":function(e,t){if(0===f(c(e),new u(0)))return!0;if(0===f(c(t),new u(0)))return!1;for(var r,n=a(i(Array.isArray(e)?e:e.toArray()).sort(l)),o=a(i(Array.isArray(t)?t:t.toArray()).sort(l)),p=0;p<n.length;p++){r=!1;for(var h=0;h<o.length;h++)if(s(n[p].value,o[h].value)&&n[p].identifier===o[h].identifier){r=!0;break}if(r===!1)return!1}return!0}});return p}var i=r(2).flatten,a=r(2).identify;t.name="setIsSubset",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){var o=n(r(30)),s=n(r(27)),u=n(r(28)),c=n(r(22)),f=a("setMultiplicity",{"number | BigNumber | Fraction | Complex, Array | Matrix":function(e,t){if(0===c(u(t),new s(0)))return 0;for(var r=i(Array.isArray(t)?t:t.toArray()),n=0,a=0;a<r.length;a++)o(r[a],e)&&n++;return n}});return f}var i=r(2).flatten;t.name="setMultiplicity",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){function o(e,t){for(var r=[],n=0;n<t.length;n++)"1"===t[n]&&r.push(e[n]);return r}function s(e){for(var t=[],r=e.length-1;r>0;r--)for(var n=0;n<r;n++)e[n].length>e[n+1].length&&(t=e[n],e[n]=e[n+1],e[n+1]=t);return e}var u=n(r(27)),c=n(r(28)),f=n(r(22)),l=n(r(31)),p=a("setPowerset",{"Array | Matrix":function(e){if(0===f(c(e),new u(0)))return[];for(var t=i(Array.isArray(e)?e:e.toArray()).sort(l),r=[],n=0;n.toString(2).length<=t.length;)r.push(o(t,n.toString(2).split("").reverse())),n++;return s(r)}});return p}var i=r(2).flatten;t.name="setPowerset",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){var o=n(r(30)),s=n(r(31)),u=a("setSize",{"Array | Matrix":function(e){return Array.isArray(e)?i(e).length:i(e.toArray()).length},"Array | Matrix, boolean":function(e,t){if(t===!1||0===e.length)return Array.isArray(e)?i(e).length:i(e.toArray()).length;for(var r=i(Array.isArray(e)?e:e.toArray()).sort(s),n=1,a=1;a<r.length;a++)o(r[a],r[a-1])||n++;return n}});return u}var i=r(2).flatten;t.name="setSize",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){var o=n(r(27)),s=n(r(64)),u=n(r(28)),c=n(r(22)),f=n(r(143)),l=n(r(144)),p=a("setUnion",{"Array | Matrix, Array | Matrix":function(e,t){if(0===c(u(e),new o(0)))return i(t);if(0===c(u(t),new o(0)))return i(e);var r=i(e),n=i(t);return s(l(r,n),f(r,n))}});return p}var i=r(2).flatten;t.name="setUnion",t.factory=n},function(e,t,r){e.exports=[r(507)]},function(e,t,r){"use strict";function n(e,t,r,n){function l(e){var t,r=e*e,n=u[0][4]*r,i=r;for(t=0;t<3;t+=1)n=(n+u[0][t])*r,i=(i+c[0][t])*r;return e*(n+u[0][3])/(i+c[0][3])}function p(e){var t,r=u[1][8]*e,n=e;for(t=0;t<7;t+=1)r=(r+u[1][t])*e,n=(n+c[1][t])*e;var i=(r+u[1][7])/(n+c[1][7]),a=parseInt(16*e)/16,o=(e-a)*(e+a);return Math.exp(-a*a)*Math.exp(-o)*i}function h(e){var t,r=1/(e*e),n=u[2][5]*r,i=r;for(t=0;t<4;t+=1)n=(n+u[2][t])*r,i=(i+c[2][t])*r;var a=r*(n+u[2][4])/(i+c[2][4]);a=(s-a)/e,r=parseInt(16*e)/16;var o=(e-r)*(e+r);return Math.exp(-r*r)*Math.exp(-o)*a}var m=n("erf",{number:function(e){var t=Math.abs(e);return t>=f?a(e):t<=o?a(e)*l(t):t<=4?a(e)*(1-p(t)):a(e)*(1-h(t))},BigNumber:function(t){return new e.BigNumber(m(t.toNumber()))},"Array | Matrix":function(e){return i(e,m)}});return m.toTex={1:"erf\\left(${args[0]}\\right)"},m}var i=r(1),a=r(3).sign,o=.46875,s=.5641895835477563,u=[[3.1611237438705655,113.86415415105016,377.485237685302,3209.3775891384694,.18577770618460315],[.5641884969886701,8.883149794388377,66.11919063714163,298.6351381974001,881.952221241769,1712.0476126340707,2051.0783778260716,1230.3393547979972,2.1531153547440383e-8],[.30532663496123236,.36034489994980445,.12578172611122926,.016083785148742275,.0006587491615298378,.016315387137302097]],c=[[23.601290952344122,244.02463793444417,1282.6165260773723,2844.236833439171],[15.744926110709835,117.6939508913125,537.1811018620099,1621.3895745666903,3290.7992357334597,4362.619090143247,3439.3676741437216,1230.3393548037495],[2.568520192289822,1.8729528499234604,.5279051029514285,.06051834131244132,.0023352049762686918]],f=Math.pow(2,53);t.name="erf",t.factory=n},function(e,t,r){e.exports=[r(509),r(112),r(113),r(145),r(116),r(510),r(511),r(512),r(513),r(141),r(146)]},function(e,t,r){"use strict";function n(e,t,n,a){function o(e){if(e=i(e.valueOf()),0===e.length)throw new Error("Cannot calculate median absolute deviation of an empty array");var t=c(e);return c(u(e,function(e){return s(f(e,t))}))}var s=n(r(29)),u=n(r(139)),c=n(r(145)),f=n(r(21)),l=a("mad",{"Array | Matrix":o,"...":function(e){return o(e)}});return l.toTex=void 0,l}var i=r(2).flatten;t.name="mad",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){function a(e){e=i(e.valueOf());var t=e.length;if(0==t)throw new Error("Cannot calculate mode of an empty array");var r={},n=[],a=0;for(var o in e)e[o]in r||(r[e[o]]=0),r[e[o]]++,r[e[o]]==a?n.push(e[o]):r[e[o]]>a&&(a=r[e[o]],n=[e[o]]);return n}var o=n("mode",{"Array | Matrix":a,"...":function(e){return a(e)}});return o}var i=r(2).flatten;t.name="mode",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){function o(e){var t=void 0;if(i(e,function(e){t=void 0===t?e:s(t,e)}),void 0===t)throw new Error("Cannot calculate prod of an empty array");return t}var s=n(r(23)),u=a("prod",{"Array | Matrix":o,"Array | Matrix, number | BigNumber":function(e,t){throw new Error("prod(A, dim) is not yet supported")},"...":function(e){return o(e)}});return u.toTex=void 0,u}var i=r(42);t.name="prod",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,u){function c(t,r,n){var o,u,c;if(arguments.length<2||arguments.length>3)throw new SyntaxError("Function quantileSeq requires two or three parameters");if(s(t)){if(n=n||!1,"boolean"==typeof n){if(u=t.valueOf(),a(r)){if(r<0)throw new Error("N/prob must be non-negative");if(r<=1)return f(u,r,n);if(r>1){if(!i(r))throw new Error("N must be a positive integer");var l=r+1;o=new Array(r);for(var p=0;p<r;)o[p]=f(u,++p/l,n);return o}}if(e.isBigNumber(r)){if(r.isNegative())throw new Error("N/prob must be non-negative");if(c=new r.constructor(1),r.lte(c))return f(u,r,n);if(r.gt(c)){if(!r.isInteger())throw new Error("N must be a positive integer");var h=r.toNumber();if(h>4294967295)throw new Error("N must be less than or equal to 2^32-1, as that is the maximum length of an Array");var l=new e.BigNumber(h+1);o=new Array(h);for(var p=0;p<h;)o[p]=f(u,new e.BigNumber(++p).div(l),n);return o}}if(Array.isArray(r)){o=new Array(r.length);for(var p=0;p<o.length;++p){var m=r[p];if(a(m)){if(m<0||m>1)throw new Error("Probability must be between 0 and 1, inclusive")}else{if(!e.isBigNumber(m))throw new TypeError("Unexpected type of argument in function quantileSeq");
if(c=new m.constructor(1),m.isNegative()||m.gt(c))throw new Error("Probability must be between 0 and 1, inclusive")}o[p]=f(u,m,n)}return o}throw new TypeError("Unexpected type of argument in function quantileSeq")}throw new TypeError("Unexpected type of argument in function quantileSeq")}throw new TypeError("Unexpected type of argument in function quantileSeq")}function f(e,t,r){var n=o(e),i=n.length;if(0===i)throw new Error("Cannot calculate quantile of an empty sequence");if(a(t)){var s=t*(i-1),u=s%1;if(0===u){var c=r?n[s]:h(n,s);return d(c),c}var f,v,g=Math.floor(s);if(r)f=n[g],v=n[g+1];else{v=h(n,g+1),f=n[g];for(var y=0;y<g;++y)m(n[y],f)>0&&(f=n[y])}return d(f),d(v),l(p(f,1-u),p(v,u))}var s=t.times(i-1);if(s.isInteger()){s=s.toNumber();var c=r?n[s]:h(n,s);return d(c),c}var f,v,g=s.floor(),u=s.minus(g),x=g.toNumber();if(r)f=n[x],v=n[x+1];else{v=h(n,x+1),f=n[x];for(var y=0;y<x;++y)m(n[y],f)>0&&(f=n[y])}d(f),d(v);var w=new u.constructor(1);return l(p(f,w.minus(u)),p(v,u))}var l=n(r(18)),p=n(r(12)),h=n(r(88)),m=n(r(49)),d=u({"number | BigNumber | Unit":function(e){return e}});return c}var i=r(3).isInteger,a=r(3).isNumber,o=r(2).flatten,s=r(46);t.name="quantileSeq",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,i){function a(e,t){if(0==e.length)throw new SyntaxError("Function std requires one or more parameters (0 provided)");return o(s.apply(null,arguments))}var o=n(r(56)),s=n(r(146)),u=i("std",{"Array | Matrix":a,"Array | Matrix, string":a,"...":function(e){return a(e)}});return u.toTex=void 0,u}t.name="std",t.factory=n},function(e,t,r){e.exports=[r(98),r(515)]},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("print",{"string, Object":i,"string, Object, number | Object":i});return a.toTex=void 0,a}function i(e,t,r){return e.replace(/\$([\w\.]+)/g,function(e,n){for(var i=n.split("."),s=t[i.shift()];i.length&&void 0!==s;){var u=i.shift();s=u?s[u]:s+"."}return void 0!==s?a(s)?s:o(s,r):e})}var a=r(9).isString,o=r(9).format;t.name="print",t.factory=n},function(e,t,r){e.exports=[r(517),r(147),r(518),r(519),r(520),r(521),r(522),r(523),r(524),r(525),r(526),r(527),r(528),r(529),r(530),r(531),r(532),r(533),r(534),r(535),r(536),r(537),r(538),r(539),r(540)]},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("acos",{number:function(r){return r>=-1&&r<=1||t.predictable?Math.acos(r):new e.Complex(r,0).acos()},Complex:function(e){return e.acos()},BigNumber:function(e){return e.acos()},"Array | Matrix":function(e){return i(e,a)}});return a.toTex={1:"\\cos^{-1}\\left(${args[0]}\\right)"},a}var i=r(1);t.name="acos",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("acot",{number:function(e){return Math.atan(1/e)},Complex:function(e){return e.acot()},BigNumber:function(t){return new e.BigNumber(1).div(t).atan()},"Array | Matrix":function(e){return i(e,a)}});return a.toTex={1:"\\cot^{-1}\\left(${args[0]}\\right)"},a}var i=r(1);t.name="acot",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("acoth",{number:function(r){return r>=1||r<=-1||t.predictable?isFinite(r)?(Math.log((r+1)/r)+Math.log(r/(r-1)))/2:0:new e.Complex(r,0).acoth()},Complex:function(e){return e.acoth()},BigNumber:function(t){return new e.BigNumber(1).div(t).atanh()},"Array | Matrix":function(e){return i(e,a)}});return a.toTex={1:"\\coth^{-1}\\left(${args[0]}\\right)"},a}var i=r(1);t.name="acoth",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("acsc",{number:function(r){return r<=-1||r>=1||t.predictable?Math.asin(1/r):new e.Complex(r,0).acsc()},Complex:function(e){return e.acsc()},BigNumber:function(t){return new e.BigNumber(1).div(t).asin()},"Array | Matrix":function(e){return i(e,a)}});return a.toTex={1:"\\csc^{-1}\\left(${args[0]}\\right)"},a}var i=r(1);t.name="acsc",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("acsch",{number:function(e){return e=1/e,Math.log(e+Math.sqrt(e*e+1))},Complex:function(e){return e.acsch()},BigNumber:function(t){return new e.BigNumber(1).div(t).asinh()},"Array | Matrix":function(e){return i(e,a)}});return a.toTex={1:"\\mathrm{csch}^{-1}\\left(${args[0]}\\right)"},a}var i=r(1);t.name="acsch",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("asec",{number:function(r){return r<=-1||r>=1||t.predictable?Math.acos(1/r):new e.Complex(r,0).asec()},Complex:function(e){return e.asec()},BigNumber:function(t){return new e.BigNumber(1).div(t).acos()},"Array | Matrix":function(e){return i(e,a)}});return a.toTex={1:"\\sec^{-1}\\left(${args[0]}\\right)"},a}var i=r(1);t.name="asec",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,a){var o=(a.find(n(r(147)),["Complex"]),a("asech",{number:function(r){if(r<=1&&r>=-1||t.predictable){r=1/r;var n=Math.sqrt(r*r-1);return r>0||t.predictable?Math.log(n+r):new e.Complex(Math.log(n-r),Math.PI)}return new e.Complex(r,0).asech()},Complex:function(e){return e.asech()},BigNumber:function(t){return new e.BigNumber(1).div(t).acosh()},"Array | Matrix":function(e){return i(e,o)}}));return o.toTex={1:"\\mathrm{sech}^{-1}\\left(${args[0]}\\right)"},o}var i=r(1);t.name="asech",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("asin",{number:function(r){return r>=-1&&r<=1||t.predictable?Math.asin(r):new e.Complex(r,0).asin()},Complex:function(e){return e.asin()},BigNumber:function(e){return e.asin()},"Array | Matrix":function(e){return i(e,a,!0)}});return a.toTex={1:"\\sin^{-1}\\left(${args[0]}\\right)"},a}var i=r(1);t.name="asin",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("asinh",{number:Math.asinh||function(e){return Math.log(Math.sqrt(e*e+1)+e)},Complex:function(e){return e.asinh()},BigNumber:function(e){return e.asinh()},"Array | Matrix":function(e){return i(e,a,!0)}});return a.toTex={1:"\\sinh^{-1}\\left(${args[0]}\\right)"},a}var i=r(1);t.name="asinh",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("atan",{number:function(e){return Math.atan(e)},Complex:function(e){return e.atan()},BigNumber:function(e){return e.atan()},"Array | Matrix":function(e){return i(e,a,!0)}});return a.toTex={1:"\\tan^{-1}\\left(${args[0]}\\right)"},a}var i=r(1);t.name="atan",t.factory=n},function(e,t,r){"use strict";function n(e,t,n,i){var a=n(r(0)),o=n(r(24)),s=n(r(15)),u=n(r(133)),c=n(r(17)),f=n(r(16)),l=n(r(8)),p=n(r(6)),h=i("atan2",{"number, number":Math.atan2,"BigNumber, BigNumber":function(t,r){return e.BigNumber.atan2(t,r)},"Matrix, Matrix":function(e,t){var r;switch(e.storage()){case"sparse":switch(t.storage()){case"sparse":r=u(e,t,h,!1);break;default:r=o(t,e,h,!0)}break;default:switch(t.storage()){case"sparse":r=s(e,t,h,!1);break;default:r=l(e,t,h)}}return r},"Array, Array":function(e,t){return h(a(e),a(t)).valueOf()},"Array, Matrix":function(e,t){return h(a(e),t)},"Matrix, Array":function(e,t){return h(e,a(t))},"Matrix, number | BigNumber":function(e,t){var r;switch(e.storage()){case"sparse":r=c(e,t,h,!1);break;default:r=p(e,t,h,!1)}return r},"number | BigNumber, Matrix":function(e,t){var r;switch(t.storage()){case"sparse":r=f(t,e,h,!0);break;default:r=p(t,e,h,!0)}return r},"Array, number | BigNumber":function(e,t){return p(a(e),t,h,!1).valueOf()},"number | BigNumber, Array":function(e,t){return p(a(t),e,h,!0).valueOf()}});return h.toTex={2:"\\mathrm{atan2}\\left(${args}\\right)"},h}t.name="atan2",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var o=n("atanh",{number:function(r){return r<=1&&r>=-1||t.predictable?a(r):new e.Complex(r,0).atanh()},Complex:function(e){return e.atanh()},BigNumber:function(e){return e.atanh()},"Array | Matrix":function(e){return i(e,o,!0)}});return o.toTex={1:"\\tanh^{-1}\\left(${args[0]}\\right)"},o}var i=r(1),a=Math.atanh||function(e){return Math.log((1+e)/(1-e))/2};t.name="atanh",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("cos",{number:Math.cos,Complex:function(e){return e.cos()},BigNumber:function(e){return e.cos()},Unit:function(t){if(!t.hasBase(e.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function cos is no angle");return a(t.value)},"Array | Matrix":function(e){return i(e,a)}});return a.toTex={1:"\\cos\\left(${args[0]}\\right)"},a}var i=r(1);t.name="cos",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var o=n("cosh",{number:a,Complex:function(e){return e.cosh()},BigNumber:function(e){return e.cosh()},Unit:function(t){if(!t.hasBase(e.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function cosh is no angle");return o(t.value)},"Array | Matrix":function(e){return i(e,o)}});return o.toTex={1:"\\cosh\\left(${args[0]}\\right)"},o}var i=r(1),a=Math.cosh||function(e){return(Math.exp(e)+Math.exp(-e))/2};t.name="cosh",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("cot",{number:function(e){return 1/Math.tan(e)},Complex:function(e){return e.cot()},BigNumber:function(t){return new e.BigNumber(1).div(t.tan())},Unit:function(t){if(!t.hasBase(e.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function cot is no angle");return a(t.value)},"Array | Matrix":function(e){return i(e,a)}});return a.toTex={1:"\\cot\\left(${args[0]}\\right)"},a}var i=r(1);t.name="cot",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var o=n("coth",{number:i,Complex:function(e){return e.coth()},BigNumber:function(t){return new e.BigNumber(1).div(t.tanh())},Unit:function(t){if(!t.hasBase(e.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function coth is no angle");return o(t.value)},"Array | Matrix":function(e){return a(e,o)}});return o.toTex={1:"\\coth\\left(${args[0]}\\right)"},o}function i(e){var t=Math.exp(2*e);return(t+1)/(t-1)}var a=r(1);t.name="coth",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("csc",{number:function(e){return 1/Math.sin(e)},Complex:function(e){return e.csc()},BigNumber:function(t){return new e.BigNumber(1).div(t.sin())},Unit:function(t){if(!t.hasBase(e.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function csc is no angle");return a(t.value)},"Array | Matrix":function(e){return i(e,a)}});return a.toTex={1:"\\csc\\left(${args[0]}\\right)"},a}var i=r(1);t.name="csc",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var o=n("csch",{number:i,Complex:function(e){return e.csch()},BigNumber:function(t){return new e.BigNumber(1).div(t.sinh())},Unit:function(t){if(!t.hasBase(e.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function csch is no angle");return o(t.value)},"Array | Matrix":function(e){return a(e,o)}});return o.toTex={1:"\\mathrm{csch}\\left(${args[0]}\\right)"},o}function i(e){return 0==e?Number.POSITIVE_INFINITY:Math.abs(2/(Math.exp(e)-Math.exp(-e)))*o(e)}var a=r(1),o=r(3).sign;t.name="csch",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("sec",{number:function(e){return 1/Math.cos(e)},Complex:function(e){return e.sec()},BigNumber:function(t){return new e.BigNumber(1).div(t.cos())},Unit:function(t){if(!t.hasBase(e.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function sec is no angle");return a(t.value)},"Array | Matrix":function(e){return i(e,a)}});return a.toTex={1:"\\sec\\left(${args[0]}\\right)"},a}var i=r(1);t.name="sec",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var o=n("sech",{number:i,Complex:function(e){return e.sech()},BigNumber:function(t){return new e.BigNumber(1).div(t.cosh())},Unit:function(t){if(!t.hasBase(e.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function sech is no angle");return o(t.value)},"Array | Matrix":function(e){return a(e,o)}});return o.toTex={1:"\\mathrm{sech}\\left(${args[0]}\\right)"},o}function i(e){return 2/(Math.exp(e)+Math.exp(-e))}var a=r(1);t.name="sech",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("sin",{number:Math.sin,Complex:function(e){return e.sin()},BigNumber:function(e){return e.sin()},Unit:function(t){if(!t.hasBase(e.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function sin is no angle");return a(t.value)},"Array | Matrix":function(e){return i(e,a,!0)}});return a.toTex={1:"\\sin\\left(${args[0]}\\right)"},a}var i=r(1);t.name="sin",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var o=n("sinh",{number:a,Complex:function(e){return e.sinh()},BigNumber:function(e){return e.sinh()},Unit:function(t){if(!t.hasBase(e.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function sinh is no angle");return o(t.value)},"Array | Matrix":function(e){return i(e,o,!0)}});return o.toTex={1:"\\sinh\\left(${args[0]}\\right)"},o}var i=r(1),a=Math.sinh||function(e){return(Math.exp(e)-Math.exp(-e))/2};t.name="sinh",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("tan",{number:Math.tan,Complex:function(e){return e.tan()},BigNumber:function(e){return e.tan()},Unit:function(t){if(!t.hasBase(e.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function tan is no angle");return a(t.value)},"Array | Matrix":function(e){return i(e,a,!0)}});return a.toTex={1:"\\tan\\left(${args[0]}\\right)"},a}var i=r(1);t.name="tan",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var o=n("tanh",{number:a,Complex:function(e){return e.tanh()},BigNumber:function(e){return e.tanh()},Unit:function(t){if(!t.hasBase(e.Unit.BASE_UNITS.ANGLE))throw new TypeError("Unit in function tanh is no angle");return o(t.value)},"Array | Matrix":function(e){return i(e,o,!0)}});return o.toTex={1:"\\tanh\\left(${args[0]}\\right)"},o}var i=r(1),a=Math.tanh||function(e){var t=Math.exp(2*e);return(t-1)/(t+1)};t.name="tanh",t.factory=n},function(e,t,r){e.exports=[r(542)]},function(e,t,r){"use strict";function n(e,t,n,i){var a=r(4),o=n(r(0)),s=n(r(8)),u=n(r(6)),c=i("to",{"Unit, Unit | string":function(e,t){return e.to(t)},"Matrix, Matrix":function(e,t){return s(e,t,c)},"Array, Array":function(e,t){return c(o(e),o(t)).valueOf()},"Array, Matrix":function(e,t){return c(o(e),t)},"Matrix, Array":function(e,t){return c(e,o(t))},"Matrix, any":function(e,t){return u(e,t,c,!1)},"any, Matrix":function(e,t){return u(t,e,c,!0)},"Array, any":function(e,t){return u(o(e),t,c,!1).valueOf()},"any, Array":function(e,t){return u(o(t),e,c,!0).valueOf()}});return c.toTex={2:"\\left(${args[0]}"+a.operators.to+"${args[1]}\\right)"},c}t.name="to",t.factory=n},function(e,t,r){e.exports=[r(120),r(48),r(57),r(75),r(55),r(544),r(82),r(545),r(76)]},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("isPrime",{number:function(e){if(e<2)return!1;if(2==e)return!0;if(e%2==0)return!1;for(var t=3;t*t<=e;t+=2)if(e%t==0)return!1;return!0},BigNumber:function(t){if(t.lt(2))return!1;if(t.equals(2))return!0;if(t.mod(2).isZero())return!1;for(var r=e.BigNumber(3);r.times(r).lte(t);r=r.plus(1))if(t.mod(r).isZero())return!1;return!0},"Array | Matrix":function(e){return i(e,a)}});return a}var i=r(1);t.name="isPrime",t.factory=n},function(e,t,r){"use strict";function n(e,t,r,n){var a=n("isNaN",{number:function(e){return Number.isNaN(e)},BigNumber:function(e){return e.isNaN()},Fraction:function(e){return!1},Complex:function(e){return e.isNaN()},Unit:function(e){return Number.isNaN(e.value)},"Array | Matrix":function(e){return i(e,Number.isNaN)}});return a}var i=r(1);r(3);t.name="isNaN",t.factory=n},function(e,t,r){e.exports=[r(547)]},function(e,t,r){"use strict";function n(e,t,r,n){return function(t,r){var n=e[r&&r.mathjs];return n&&"function"==typeof n.fromJSON?n.fromJSON(r):r}}t.name="reviver",t.path="json",t.factory=n},function(e,t,r){"use strict";var n=r(50),i=r(10),a=r(51);e.exports=[{name:"ArgumentsError",path:"error",factory:function(){return n}},{name:"DimensionError",path:"error",factory:function(){return i}},{name:"IndexError",path:"error",factory:function(){return a}}]}])});
//# sourceMappingURL=math.map