const cacheName = 'MathFloorsTry5';
const assets = [
'MathFloorsTry5_Contents.xhtml',
'MathFloorsTry5.xhtml',
'MathFloorsTry5_Simulation.xhtml',
'Settings/01authorFelix_J_Garcia_Clemente.png',
'Settings/01authorPacoEsquembre2011.png',
'Settings/triangleLight.png',
'Settings/hangedShirt.jpg',
'Settings/shirt.png',
'Settings/coco.png',
'Settings/profile4.png',
'Settings/profile5.png',
'Settings/profile2.png',
'Settings/profiles.jpg',
'Settings/1authorlookangphoto5050.png',
'Settings/Screenshot 2024-03-11 at 3.29.46 PM.png',
'Settings/Wrong-answer-sound-effect.mp3',
'Settings/profile3.png',
'Settings/Ding Sound Effect.m4a',
'Settings/profile1.png',
];
self.addEventListener('install', e => {								
	  e.waitUntil(														
	    caches.open(cacheName).then(cache => { 							
			// If 'TypeError: Request failed', review assets urls		
			console.log('Caching assets.');								
			return cache.addAll(assets); 								
		})																
	  );																
});																	

self.addEventListener('activate', e => {								
	  e.waitUntil(														
		caches.keys().then(keys => {									
			keys.forEach(key => {										
				if (key !== cacheName) 									
					return caches.delete(key);							
			});															
		})																
	  );																
});																	

self.addEventListener('fetch', e => {									
	  if (!e.request.url.match(location.origin)) return;				
	  e.respondWith( 													
		caches.open(cacheName).then(cache => {							
			return cache.match(e.request).then(res => {					
				if (res) {												
					console.log('Serving ' + res.url + ' from cache.');	
					return res;											
				}														
				// fetch missing resources and add to cache.			
				return fetch(e.request).then(fetchRes => {				
					cache.put(e.request, fetchRes.clone());				
					return fetchRes;									
				});														
			});															
		})																
	  );																
});																	