var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./circleplusquestion08/Capture.PNG"]="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAUAAAAC0CAIAAABqhmJGAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAADkbSURBVHhe7d13QBPn+wDwNwmQAGHvvfdybxQRrXVWq9/WDru1Q1vb2mFbO7TWtmqrtVatey8UAVEUmbL3JkDIIBAIK4GQvX5vklOxdTCiwq/v5w99n8vluNzdc/fe3Xvv4VQqFUAQZGTCY/8jCDIC6T6BW5uZ9Q1MLNCgUWvbu3hY8LQ1NzVS6ffM3kApZBIWi40FANBpVE57JxbcD6+rvZZKw4J7NTXS6cwmLLiNVl/LbuvAgseG09JYR6VjwUiiqq2u6OaLsOixUikqyssFEhkW3kZvqH/4Gn8glbK6qqJHKMZCXRhwAmcmX/11+67YmIt/7D18dNePBXXN2Ae3mZiYbP3hV225l98jkysFjbWn4m5qh/QfvTLnt4NnseB+BPxuqVyBBf1mYWby80/Y7A3O+XNnk28mwYKoly+WSAni9r2no7Uf3ReZTP5t61YsuBeZRPjpl9+x4DaloH3nsfNY8BAqFZfXjZUHzoRssnHjFpmg48PPvsYGDSdcLhcr9dHd3a1QgarCjJTcWmyQTsAl2X2/JYkj5CVdKGC0YeFtOGHrvoeu8QfC4auyr6VUNGChLgw4gUeF+DKa2hYved7BwuiV978Y6+OIfXCbsamllaWpthx94mhdE9/W0kobDoh74MS1ry3Dgvu5fPZANes+q/nhjEwsbIyNsGDgVApJTXXr62+8BssZ0afzSqutbGxw2s8eQM/A0NKEjAX3Mre0NTYiYcFtDk4O+gSs/DAKydYd+7DywMHlYGpiom9svX3Ld9igYUT507b77GQP7P+TK5RZWltjsY4oZcJf/9yPBfeysjLHSn3Y2DtgpYGztrHESjpC+P7777Fi/8iE3KTMEl87Eyf/Sft+/crMLWTbhvc4QrB//9H582bHnT9NoVJz8iuff36BUiE9dfRAr0Lf25Z8OSUr5cpFj6CJrdSy9Jz8/OKq0aFBop7OlW+vVon4iRmFk8cGnzh2IiMjzcHZ8cMP1uZmprR1dOVV0hrzky6m5V04eUyqxO36beesZ+flpiQWFRfWMdoLM25y5QbeDqYXLl/JvJVtYQw+3/Tr9RtJ8+c+A1Tyg3/vv379elDYmC8+XMMViv4+cnLuM1EXz56gwkmWVi55bgH8LdfiLhXmZTI6pD2M0m27D91MSbMy1svJL6iqZ3U316bl5JdTGsOCfOGYWSnXcorLyyoohkrRmUtXJkydBDf/86eONnf1Bvh5Rsdey0tJtPEMFrZSkzJycvOLx4wKhckeG3027foVQ++xuQnRzU2M/GqWn6vlsZPnE2+mhk+bcu7EoXo6s7yaviBq0qkz51JS08eMG3/0wH4alcoWgNlTx8slgrdee0OskF24fGP6pOB9+49eTbw+deqkNe++RaFUlVTVFhWVhI4aZWNloVkzYM+Wr7MLi3IqmE21xTXVlWyetPDaWXqPKvboLoKN95+b1zX1yPfuOzB/3ty46FO1VEZ2bunkUPdf/jjsYmPw5eYdlXlpYqKlsLUuNjF15+6/poRPNybi331zpVvIpLOH/7KwtLkYE1tYkOfq5rb2w48nTxj1wVffTg7zX/vxF6lJSdOj5hgQcCcO7od1E1v3gKO//VBObzmw7+/Z8+YlxJxNu3Glq0f04y/7po1yjkmtLMuIB0bmN65cgavb1tFh3ZoP01OSDQyNikpKiusZoX4+LEb9yRPn/UJGV+RnlFVRqurogf4+MiH/8OF9BmQbQyDKLamNPnNsYviskuy04tListqmYH8vYU/XG+++K+hsScwsnTIu+PTJE7du3XLz8jtz8ti1hKtjJk3+/O1X6hg0Fg9Xkp2adSvdycP3wvlzSWmZlmS96Li4kKDRNtYWB3/fVNkqoRSmWdq77fx9t5kxqGa2nTp8MGL23Fs34korqysoVF9Xm+wKuo8dOeF6akZ24fixo3Aq5TeffEDn8PcfODR96riP128cHejxzQ87wwKcPli/oamuIqeYkpJwQWpkh+ttzq+kJ0SfHTVhWm76zeKCnGae7NyeH4ura6tpHaND/LSrsv8Gcw7MoNacuXBJpgBBnm4SmdzVyWnKrPlG+l1iUVdaQfXixUucbNWbFJ5g4O/nFz5jlj4eePoFL18Sdau44uipM5aWVkV5qUoADE2t7Jytl7/8Wju1LO7i2WYRIMgEFY1cewuLT7/4JnLiaAGfH+TjY+/m/9ys0UpLl7AA22au4PT5aEtru6xbNwJ9fabPiDh7dJ+xuVULsxJv4mhuZfrtl5+pZ1Gl8gsKMyWpKMwuV0f7aVELrPWEHZ1t6YX1ixYtdDQzUY8Dq9M2DhHTpyZdT/f19LWwtF3/8doTZ85ZWVnfupVqbGY9LSIyOyNdM6Lq6KlLLzz/PKUww9rDz8vTz8NZXe8I9A+YPG26KYng6uX3xksLs7Krdu89bGVlWVSYL4cfK+WJVxPDJoXbEAkGRmZvf7COWlegAmDchEmdjOq2ZmohtXPJooVmJoZJCdE8kb60u+n8iZNCkuPihc9oj8B6RGNHB4eFS180V3EojZ2jxozDtTWye/EuLtbLX31nxfJlnt5+AT4e6lE1fH29wyZFLprkdauyddkLL8WePezr6SEQS309PMUypauz5eSIZxxIRJ6Afz27evGiRdaW5m7+AQSBwNs3wNyC/N57q7OyijJTbs6Yv9ze2sreyhxHMHhl2QIqjRUeGZWdFD1x+rMzx/kdjUm3MzG2dXDRJ+LtnDzMLay++maDkWaOPbwDnOwt8nKrPF1cg8dNm+BrVtshTEy8Gjx22thJ04xJsspaVnbaNVff0F5aoXZ1M9t64Or+4uuv2dSKtm7JJPWOD7i4e3q4e4b5Ol25mbF0yZK0xGtweeobmfj4ekRETMfhQPDoiVHjA2gs1tnoaHML65yURPgtI1NLG2uTl958v51OLU5PoLXJgEyQm18VFDLaACehsrrdnewWv/yeraKZ0tpjiFckpaWlpGZNmTTNy9/f08cn0M8TTmTp8uUsRiOLUpZZXP3s3FlEPfy4KRGjvOzprPaYxLSlS5ZmJyVKNPdtTh47amJpWZ1/SyhVwrqxu5vL+GlzPM2UwNDayJDk5O6LB3JHNz8rC+L7az9iNLW+t+q1WxlF8Ithk6e/vmTuyZj4cxcuWtvZ30pJ8nJ0njp3+fzZ09TTHaDBJLC7d8CX32x0sr1bEdUjEPB4nEImVinvX53U0yPg8OqPRGLJtOkztv+6ve94RgbEbr7Qyyfo/fVfRYR54/F4Wzs7gmZ8CH4XDycPpwBXHVDhCfoREZE/fPst/AguSaGgN3TspE1bttmbG8Av2tvbw+Hinq6U9EyymTkB7jwAQTN3OIVUosTdUzctzsvsESv19Q1gGY5gb28nURFmRMz86ftvy0oKOrr4xqZY/Vauzkj1nCjvd9NNPX08Ac6NUCyeGj5j+y9b8Sq4DwHrv/w8+thBSgMTfhGeAMHZ72xtyissNzczk0uEOLy+9usSkTAwJOyLb392hfNL+meNGjI0Jre3tmblFZrBSi8BD6dkbGJuboItf4Xi7oUAPEHP2soM6MMpw1lSr9y+8wsXBA6PV8olStU/6+h4PT0cTj3+vAXzU65efuu9D7TDJ0bMvhF9nGBoKRFL4FqGy0ouk/edJh6Ht7N3gD8NTvZ6cqo+yQSv+V1wpcG1plIpPln3ZcyZYxW1NBdTfTHe0IaklOsZiQTY6p4Y5AXn08HBYdGyFx2NxPsOntBOFv4JpVKh0PwpOK/YX7z9h/UIevDvwkUskeEiIiK2/rxZO1zzK+DiwQuFvR6+AR98/OWUEMfkjEyyiRnchuAIJCMTuK9x8fB7/f11C2dO2rD+vQN/boM7jjtTtnT272jImbn89dhTf5s6qFMabnjwl6jgzGiWM/xN2m1A2CucOHnazj//IOppN1ScejtTb6L30MwSDs6wdvFqGRMN5TIJIBhHRM7Z8NmHcAg8z7KzsZBIJNoR+m/ACVxSUlpeVspX4MlG+gwWk0pl0Jn0+poqJpXJ4gFbsvzQsdN0Zn1XtwCObG9vDas9FQ20hvp6Jp3JpDUsmj1j06YtN1KztFOTdLTGxl8xc/P737Ln0y8dOXzsOLuVU0mpYXO4TU3M6hoqrYlBraM20BtZVGojk1VNaQj199z2+x+FpdW2Tg5H/943//mX//j5hzPnY9lsdk1lTa9IvQgkAn5tTVUPj0+n1Tcy6mtr6xoaGtr4eDsD/uHjp+saqNxe9WVM+Gl5VW0vt7mhkV5dWydVqCLHBW76aVtmfgmLTqusqODzuoQSmLu4BXMmXbwca+bkL+9ura2v6haoLyQ6ujiePn2qsKiSWt9ApTGo9NqVy+d99/2mxORbAAcUst4TZ85PmDzdWE9WSaE0UGtra6gtreyaqmqBTMZVmhP5zBNnLjQ01I8Nfzbm9N9Hj530nTKHkhl36coNanWNXLOZyCT8+LhYvoLsaqVfU1PTi1NSKBR6Ha2KUo/TM2ikFGYXlb3+0ssSWJ8BgEZvKKuqNXP09SJLY6LPTp610MXf/1rM+TJKPa2+jsFoqaulMBgURpvY1UR66OgpFquBWkepqKuj0Rn1FCpcRBRqfU+PIPX61V07tsOzTThNA7K1g62lv6/H4mUrbibGJCTnvbJ8nrOz5V+HjrNpNAadRqmt7uzuhWPCMyYKpZrX2cFqbmA2MeAip9PhhlBz8uj58VOm2VlZPjN7mghHnjAm2MTCbmLUQs3qPtHMboWru7WNdz0x2sDEfuKYEPUvAYSuNmZqHmVCmG/8lfiAcRO1uzoHM4t9B48xGmj11Hoakw43jvCxAT/9+ltWfin8VCLqrauk1NY3wBXkNz4q//rZQ0eOwc2pllKj/ohaR2cxyyqrw6bNqkyPOXj4aH115Y3cqumRkaZkMquyPK+4XPNHcFY2rr7+ob5ujl5OlgwGq6G6mkaj0tltU8cExMbHeYVN5DDgSmtYsmzJz5s3XYhTH/zhroVBb6irp9DpDFhhsTNWHT55jk6rYzIZtVX1DBqtjgq3Q2ZdXbU+idxQlBt/K2/Fc4tDvGx+/2NPaVU93Mgry6tUCumajz7WTG0gVE/VR1+uw0rI/Xz16ae9Mqz8IKlJCTIlVh66X77/Ee6zitMux2WUwLCnpycvv0D7ETIMPc2WWCJ+52dffr36o89DfNV1lWEILhyxWJd37QZELhV++fnnz618f9qYQGwQAEQiUVs31oJVO1YLx9Xpn/cCBi39+tW2XomBPmH23PlG+qpN321e9dHH8HwY+3gkgGsN1kWf4ob9b/9Yazo0UptS8ng8oVCIBY9NV1eXvvp8chiB68vW1hYLhgcOh6O5PDFc9Pb2mphg1ymHCRKJ5ObmhgU6NVITGJ7xOjrq7LDzIAUFBT4+PlgwPLBYLGdnZywYBuRyOUwYCwvsVtZwUFdX5+urvvk3fMAzEVdXVyzQqcdyWP8HQW+vTCaT3241JRX2bPzi6y6BVBv2VZ6fsufQKSzoh4qSwrS0tOLSCoVCcxnnXoyGhzZ5UamEgsd+DEeQx+qxJ/Cpo/uvJaXs3r45MatQO8TAyNTMUF8ku0/KhU6Y2FRRgwVqqpjLD2uztuf3bVQq9Ur08W1/Ybcf+iorUt92e5DmhtJT0bewQEcEPK6wb9NZpbxCg9Pe2clpWv/dJmz4UyIXC4Xi++w3+xLyuVcSb2DB0EhFQoHoEX9u0ApyMipq7t/CfCjqatTrq7GpBYuHvcebwBxaRUFd57Ili95d9bapoQGLTi0oKrtTZ+fzOvPy8rs6O9IycttaWPlF2uv46gszZcWFVDqrpZl5JT6eymiCY+bm5cHcYDMbeH0aslvZOrz99tsbv9/EaShtZzWs+3Dt1h17lCrww9cf/PLHAV5XV2nGzY2bf35/7SfHjvy99pPPBBJ57Nmja9esScsrv3E1PibuLJfT9OnHH276+TeZQr5l/fpfdqkbJyqV6p2L9t8BYVcWzJm3uKKOgcU4XPyFQzUNzG2bvmrsxukTHtfW/HCMusqN36hbJnbVV9QwWptoNavXfnTx3Okjpy9pR+jLiGyenZyKBUPTWltRXNMKC19/tZ7WpC5oyaXiH7765NjpC4f27UpMz8WGDpCzjUnCzUF+9w6FRLBr6+YNW36DZbnmNm9hytWk/KqYE/uiE7E7nfcnExw7GY+Vn6rHm8AVVWUuXu6wYGTlOn2s/9HTl/KSLlQz2+CmDdP0t993q7jsCzcLLp4+b23rcPzEaexb2UnUTslff/5hbWdvaWjj5mi7d+8hO3PS9p1/FWenUfs8CdTe0rRz586vv/jCM3TKX3/uWvPZN05Efl4Ni93J/3zt20wajdfOcXL3e2ail8rcJyLMpbS0NCmvdsuWHy8ePzAz6pnFC188dmDfa++vH+VqlHCrhMnp/ezD1XCyJ0+eTE5OLi/HdigDUlWcM3d25IET0XJYq8cRHB3tnVzcxgS71dM1Tx2pVGWw2p+RxevknDx9rlfAj7kcf9/GITohk4gO7Po1cvbcpFtY9Qdy9gwQyKXPv7DiWuwFuIuSSSVisfrmuUqlgmezcKdD0tOHA7t7+Lqar5sJ0ZERM/4+fl6mOY3SMyA52ZKCx0xc+dqb1mQDhUIuEKp3ykJBr1QqFQh6u3t64MzAky6xSADnTSqRiCUSOH89PXypVKJQquQyGY6gg4uLBKKxo4uDpbUZLF+5eI7TLXJ1crG1d5o8LqyWxlCpFEUFebkFJUqFPD83Oz2nAA4pzM0pKCln0uqzs7LYnHbtdJ6ix5vAZENjblePtixVEObMnNzF7+7uEcOtRS7u5orAuJnPvDhvOolExBP0NM2V1HxHTzbDi7k8IQ4O09MDCkF5bU1TW3fk9MkLVrw1LtBLOxpkbGoWHh6+8t11a95czqxr2LXtx7xqJk4sM3Owv3Nd1MXRw5hs7OzhTjIy6ua2FpcUfr1xI94Ea1PeyGjct2vb9axykp7K2cFG25Lmf//7H5fLHTVqlHacgRL2cD//cNVba7/QNsYoLsijt4NnI8bBsojLKatvKc/LEOuZVRTmEomGtrbWt5uc6VhtecGiZ6O++OFnHv+fp/riHu6l82cWLV8p6+n8Y/eeX376qatXeu7k0bSEixevq488Lcyav49dUOpu19Ld2fbFR6vnL32RQmNphzTU1545fXlMaMDev/7KuHklITk74eyh33buhPWpNWvX8Tqat+8+mHL1Unl1xc7df/+0eZNIrtjw2Qd/7v7t0o3UP//ck5t3d5c0FJ098pcXqRvGTwj2KCyrhIXKkvzE3OpVLy0uTr/KkRArsq7fvHqFwpEQVLi0K+f5+lYp0SeIVg4Ojq6OdjaaaTxNjzeBx0yZWZuf3NLBY1KrMq/FxaYXuTs66JPUf5RgYNzd3iwHeHYLW6WSCgV8iVTTglilOr33dyNbd3NLIzzA9UoEKhzRAIcfN36SpZlxaW46o+Xus7JGxiZjx4719/GEKRAyNvSFlav83e1MrR54C8HM2iksKGD9Jx/ry2UEHK6zsy0oJHDxCysnhniRydgTVBCJRFq27GEPQj1S8JhJ69a8q6dJzZBRY776eoMJUb170jc2szMzaG5tl8pVMyYGxV5NdvMN0nxD98wtrV2cnf/duA8impg9O39RQXKcCEeaPWumQiZuaWaXVjfOnD3X1dFaKZdevpmzfu2bd1qz6gTcR7u6ulqYY8uZSCTCY2lNaR6B7PjswiXpN+K9PL1Cx03+ecuPAZ7OdTQWr73J2jVofFjonKhwA0F3uwB4eru/smqdA2iz9x03c8ZU7XSGCIfHOTrYwYJYJIH7U1jw9vNnMehEA4OKsgohnzd6auT4KVOp2fFXk9Oqq6p7ursiFy8z0tN8eRh4vAlsYGT+x46fz584SuMIZsyb52JC8Ambyuc0mVqZNbdwPl3zJqxGOjm7PL9kzrWUHH8vx5qKOlN7q1lLXqjMz4oKn8rm8KZOCimpom349IOjx45b2TnLZfK+h4Up4TOwEgDvrvuyMC3B0nNcgJvNtEnqduETp01z9vb3cLFx9Qp0tTH18Al2cXZZ89aKw0eOv7NmjYNnkFLS/OqqNdTidKWZ+5Qwn4nTJmsnNSQ4PDz2XrsSM1pTU1ApVQR1O1h1JqiUSmplPq1DbGNKhrkRPmtuYmKSs/XdHYdu2Tl77D925sTBPc62/3ycE4fDGxqTcRJuWXnZjexyBzsHPT0DkZBvbGnn4wjrJnhTJT+jsBobWxcc3X1Ono898OcOO0t1fRVydnV/eeWLJCJRKpeqlHJ9TfLAWTMwMBgd5JVTTvd3MGO1c5tpNZlFFCc7WwPN8xJwYRoZGsOqtWZkHXB3sMwqqpYI+bGpRVPGBCqUSiKJ/PZLi7btPhA6OrSJ3W5rZZqdX/jmJxtdrUz8gwM72rssyUSJAtfb2ykUPbVGPneg+8APM9D7wM3VpZUd0memT8BilTwhLp5kYT9r+mS4iVxNTJoeEZGbleXj6y3HGwZ4OeXnFU2cPAkbuX8GcR+Yz20/ez7xndWvtlXksfQd7EmiTzZsWrZ0cWtH74rFM3/fe9zXxdpj1Aweo6S5RxYVGfH37t1rP/1031/7Nnyz0cSIiE3lAR5yH7ixNI+pdAgf47pv356XXn3T1FibouqLWD9+96VrWNSbL8K6q/L8qZP6JAPfsClN5Rn0XoN3V/6vu7Uhv77b3w7HFJL9bQk795/xcjL1mzAnJebQ7OffGh/o/tv27e4ebqX17T989THhX8egAd4HVpUW5NDYnbNmRZmRDVOux4lx5LlREVfjY0dNmMamVamMrLwc7ekshrmVrY+Ha3ZasqG16+hg39Skax6BY9yd1EfvR3p894FHagLT6fQnMOdNTU2hoeoH3HSuhVp5OuHW62++YWVyn8ePHmIoDTm0CTzWX5dbUn8SGIuflP9UQ46RmsBPBkxgMvn+nWkMEaw0dveKzE0H3OJvKAnc28Lk4k1d7HTZauohCcxtZnJVpp7OT7qRFkpgBPP4EnjQmpubtc88DxNKpbK9vR2euGLxMNDR0eHn5zesmmd3d3c/9rbQJSUl6ns2Q4PH4wfR/uHfdDgd+AMHvZOSyWRw69SW4QYx6On0NcTpWFtba7MFuzA2DGbpDh1OB/476EnBSkFbG9YT3TD5aZaWliRNVw1wOtAQt22FQgH3UIaG6msKd2crPz9/woTbV18GC27xOnl8R4fT0fTHoYOL7bqaJalUqpPjlXYj0MlP09UswcwZ+jEAgj8N0smkhttag+kGl9IQZ6mzsxOud+1py+O9jYQgyGOFEhhBRjCUwAgygqEERpARDCUwgoxgKIERZARDCYwgIxhKYAQZwVACI8gIhhIYQUYwlMAIMoKhBEaQEQwlMIKMYCiBEWQEQwmMICMYSmAEGcFQAiPICIYSGEFGMJTACDKCoQRGkBEMJTCCjGAogRFkBEMJjCAj2N1+oWNjY0eNGmVn16+XNT2IrnoG1uF0CAQCThed9O/du9fa2hoLhkAn/W9DfD7/mWeecXJywuIh0FXnyQqFAi5tLBgCuE0qlUqdTEpXG5KuFhH8aXApDXGWeDweiUQyNzeHZdSxe38lJyfPmjULC4Zg69atGzZswIIhaGpqEovF3t7eWDwEqGP3R0IduyOY7u5urIQgQ4YS+Enjcrl3aj0IMkQogZ80WDkUCHT2gnnkPw4l8JNGJpNbW1uxAEGGBiXwE6V90TOVSsViBBkalMBPFI1G8/LyYrPZWIwgQ4MS+IliMpkuLi46uS+NIBBK4CcKJrC+vn5XVxe6EI3oBErgJwcmrTZv3d3dGxoatAMRZChQAj85paWlMHVhwdvbOyMjQzsQQYYCJfCTU1VVpU1gAoGAbgUjOoES+AmBlWcOh3Ongb6ZmRmNRtOWEWTQUAI/IVlZWYGBgVgAQFhYWHp6OhYgyGChBH5CSkpKXFxcsEBTi+ZyuUKhEIsRZFBQAj8JDQ0NZDIZC26bPHlyXFwcFiDIoKAEfhLi4+PHjx+PBbeZmJg0NzdLJBIsRpCBQwn82JWVlVlaWmLBvaZOnXrq1CksQJCBQwn8eCmVysTExDFjxmDxvWC9WiAQwOMwFiPIAKEEfrxOnjz58I6KZs6cefjwYSxAkAFCCfwYVVVVicViGxsbLH4AWJE+fvw4FiDIQKAEflw6OztjYmKmTJmCxQ9ma2urUCiys7OxGEH6DSXwYwHPbHfv3r1gwQIsfpTx48fDBEZPOCADhRJY94RC4Y4dO2D2Dqhj1Llz5545cwa1r0QGBCWwjnG53G3bts2ZM4dEImGD+m3RokVnz56tqKjAYgR5FJTAulRXV/fbb78tXLjw3+2u+gOPx8McTkpKSkhIwAYhyEOhBNYNmUx2/Pjxa9euLV++fIhd+MOjd29vLzyMw4M5NghBHgAlsA4UFRVt2rTJyspq1qxZOnmNS1BQUHh4+O7du6Ojo7FBCHI/KIEHDx51YV33+++/r66ufuGFF9zc3LAPdAFWwpcuXWpsbAynf+zYMXQ0Ru4Lvdysv5KTkyMjI9va2trb2ykUCpvNhoVx48Z5eno+7l4mOzo6MjMz4QJxdnb28vJycXGxsbGBc4JebvZIutqQhu3Lze4mcFxcXFhYGHq96IOsXbsWZg6JRLK0tIRZ9Mj2VXfQaLTi4mKFQgG3ALjm4O+Cy1z7JDDcLOCkxo8f38855PP5dDqdw+HAAvx31apVfn5+2GdDoKutHL1e9JHgT0OvFx0AOB1dHYH/+uuv6dOnY0E/wEN0YWEhzMxRo0bBE9r7XpeG67KkpCQ1NRVmsru7O9yBYh/0Q11dXYAGFg8BOgI/0rA9AqNzYN1rbW09c+YMrOKuW7duw4YNzz777IPuKsGdC6yEf/bZZ1988YWjoyP8VllZGfYZgvQDSmBdgkfU6Ojopqam77777pVXXjEyMsI+eBR4tJk5c+aWLVscHBxOnDjR1dWFfYAgD4USWGdgxeb06dPvvvvu66+/PujqVmRk5KZNm/Ly8lB7LKQ/UALrBoVCgSn3448/2tvbY4MGi0gkwko1PMO5efMmNghBHgAlsA4UFxfLZLI1a9bo5HqJ1ty5c8PDw69cuYLFCHI/KIGHqry83MzMbMWKFVisO2PHjl26dClqF408BErgIWGxWHK5fPHixVisa76+vlFRUehFSsiDoAQePIlEUllZuXLlSix+POBxGL3UH3kQlMCDByu38LwXCx6nBQsW0Ol01IM08m8ogQepsLAQnqAaGhpi8WO2atWqGzduYAGC3IYSeDDEYjE8HgYHB2Px42dsbBweHl5bW4vFCKKBEngw0tPTX375ZSx4UqZNmwYr0liAIBoogQeMx+M5OTkNrtOcIVqyZAnqfRbpCyXwgOXn5z/33HNY8GR5eXnB2vudB8gQBCXwwMBTX1tb20H0OKkrERERFAoFC5D/PJTAA1NYWDhnzhwseBpCQ0NZLBYWIP95KIEHBtZg4REYC54SR0dHkUiEBch/G0rgAeju7vb19cWCpwdWAYqKirAA+W9DCTwAxcXFA+pV5zGxtLRUKBRYgPy3oQQeAH19fWNjYyx4qszNzVEOIxBK4P5SqVREIhELnrbAwEAGg4EFyH8YSuD+4nA4Li4uWPC0eXt7s9lsLED+w1AC9xeLxRozZgwWPG0mJiaPuzd5ZERACdxfEonE0tISC4YBpVKJlZD/MJTA/TXcGjBq+/VG/uNQAj8CPPB2apDJZPjv8OmxeejdXyL/D6AEfoT6+nqhhq2tLfx3+LRD1slrzZCRDiXwIxAIBBcNKysr7b/YB0+bTl4dhIx0KIH764n1ntNPcM+C2nIg//9fL4rXwOKBg3Vmf39/WDhx4oS+vn5ra+sQTz5h1unkxZnw5Hz+/PnW1tZYPAS6eoWfrn6aUqmEm6VOJqWrDUlXiwj+LriUhjhL6PWiA1BTU6N9had2lmpra4f4Sl5dvahSextpKD/tDvR60UdCrxdFEET3UAI/Ajz1LdUoKyuD/8KdH/YBggwDKIEfwd3dfZRGWFgY/HfoZxlDx2Aw0AuEES2UwP3FYrE2b97c1NSExU+PlZXV7t27CwsLsRj5D0MXsfqFx+OFh4e7urpqL/0NhVKpHPr8yOXyzMzMnJwcOEvYoCFAF7EeadhexEIJ3F8cDufIkSPLli0bYhOooW8KcP39/vvvL730kr+/v05+GkrgR0IJPDDDMIG1swQX1xCf4xv6ptDW1mZqaqqdCErgh/t/n8A6WP3/KUPJXqmQW1ymfrlRI7V6x47fWju7tcMH6ul2TI0MKyiBnxClXPrN5x9n5NfAvfAfu/cumDf7l+27sM8QZLBQAj8hLcy6qNnzYc1JIe4xsHH2CwjRE7dinyHIYKEEfkKcvIJHBaqvfinkYiN99dmdSk+GnkVAhggl8JOmZ2AsEstgQSU11EFrfeS/DSXwk4Y3IAN+05FDB0ycn/5LHpCRDiXwk2Pm4Dlv9kRY2PjDT26ePl99/J52OIIMGkrgJ4dINvNwd4AFkrFp5MwIAz1Ug0aGCiUwgoxgKIERZARDCYwgIxhKYAQZwVACI8gIhhIYQUYwHSdwb28vVhoaHo+HlYYGTufO85JDpKtZ4nK5WGlo4O/q6enBgqHR1Vrr7h7k81X/AH+aQCDAgqHR1SzpahEplUpdzZLW3eeBMzMzQ0JCtOVBG3q3yVpMJtPNzQ0LhgBOx9nZWSc9DOtqlmg0mqenJxYMgVwub29vd3BQ31geIjab7ejoiAVDwGKxXHTxCmX40zo7O4fYRbmWrmZJV4sI/rSWlpYhzlJXV5eZmZn2XZl3E7ihoYHP52vLg4bD3Z0g8lihRf0kDaulDWcmMDBQ2ysA2ggQZARDF7EQZARDCdxfKqU8Kz21oCCvo0sHl47KCrKKKylX4y/FxsVfvX5T8e+37avkmzdvxcoDUVVamJlXigV3qJTgSiyIjQMJiUCuBPGnQEE19tFdKlCUB26mAAoVXDgEyuqxwXcwqsGbg38AIz8bRF8EcXGA968TNTYTLHwJAAX45msgF4Otg/nd/1Eogfsr/uwpA2sPRll2ZWPL1p9/wIbea/eOTZ1CKRY8mFImjE/KHhPsj+Oz23qJ7Ors45dvYp/dgdN7/fVXsfL9dLfW79x7CQv6CBo1rjjzhlB6b2cBODyQtQCeBLTVgovXwNTZIMgL++iOi6dAiwCE+YF9R8DM+cDPHRt+h7svMCVj5X+RSdUPOfcFT874fPW/Wq72IKMUeNuDNZ9hQ+5wdANebgAQwOp3gR4RvPqw343cg/D9999jReShclKu1DT1vvLS0l4e7+L58zbOnskxZyqrKurYveyGipvJad6e3scO78UbWrtYG19NTKQ2ttqZGlyIiT175gJOLDx8Pi7Ey+noubgJY8MYZZnteOsxgd5NDeU9wMbNCrQK9fSl3IyMDIKRxak922lNjaWV9ZnZ+d6OFn/sPVhWmN3ZK7984ZSZnacRQRyfcL2B0dTFpiamFk2YNDo3MzUzM8fF1WXzT1sbq4tNnfwlHTQR0S7p8mknnxBj4u2+HRsrgcQYSLggcBxIjgVkO/URNSEBpOWDiePUe/Ift4AvPwfGpsDZDiRcApbO4NAuwGCAbjmoLwc5ucDDG6Smg7lR4HIMKCwDwcGgTw9/F8/FBYWo3wJ3x97dQKkEew6DOZHqUC5SJ/D8cHA1BSxdCK7Fqg/2YWNBVTHILgC3CsHMceDwSeBkA2ITwCT1Y5fIo6EjcH+tePtDLjX72SUrre1cvNzcZ0web2VsaOXs5e1i09UtMyXKypmd3l5Os6JmHt6/l2RmG33qxMXos2GT58lV8lkL5vPbWEQDQtTs2XBS9KYmWwsn7WSrygqqmT2vLY06dPC4g4353/sPmBPxHgFjRo8e39HW5uDmwWE2fvDB2xfOxaxcOjvm2lU4caKJxYWzpzx8/QKCxoAuZnJuFRBwYm4Wyto7wqOeMTE2tDMybWlrDwgMNibd231pcQGQEYBMBmxtQDsPnDkDnpsDxAJAwMNaAeiSYAkJM9PWCnR1A6IBCBwDpB2gkApMiaBJ04lXUixg80FtPihV97AJqeTi0yePp2ekHj16tBV+6zZzKzA9AjRTwJ3zAyYVbNgMdvwKZGIgVAKSDJTXgYNHwJLFwMka2DqDTg7w8gVtLGx85JFQAvdXQX75lh1/bvrwlZiULGwQAGQz61GB3p1dHE4X/8522szmhISG7ty187lFi24mRkfNmQ+rsO625KvZFC9YjwTAgKAvV0i0IweFjf/wo7VkgkSgJIaOnbJ5o7p+aWnnEuyP1WCNjY3xBkRzMtnAgKBUqTgtbcEhIbt27TQkqLON3dzq4O61+OVVLy+aoU8i+fiH2JobKlQqAh4/cWq4kcG9N8DHjAf/mwd27MXCyEhwIw+seFldxusDMxwQaarBrc3qf7XsnIClIdA3AQuXAz/NWyAa2SAgEHz6LQj20IwBcAT9GTMjg4NDo6KiLEyMtQOhF14A8RfBe5/d3cjcvIGXPaisVx+ZORzAEwGVAvRqlgRBB51A/xehBO6vtCsxl6+ltvGEM8ePkkgE11NzhGIRr6dXzONkF1cAqYjX3W1CNI6NuxIZMeXU6fPpaentnGZKNaWOUiWQyJc/v5BSR9XDq7PON8CvsYkOD12tLRxOS7P6JNHAwspAmJ2bV1xW2SsS8ng9SqWc29UpFkvauVyJUMDt6RWJJD09vZGRU8+cvZCWcQtPNK4szzBydC1Nu56bm9PAZHO5nb0i9Rk4s6vDy935+y/WszqF6llXU4FmDqDRwMU48MxMIBICXjdoYYCGBlCmveKFA++vBp99CRKuAAoTCAWgpxeIBKCbD3xDQVkauJEI6I2gqwvMjgQXzoDMNNB5+2IUjuDk5Ozl5ens7EzU9NenteETUEIBeRlAqElRTgvo7ADvfQK2f6+uChRVA4kI8CXAlgyuXQfNLCASg85OIJGATi5Qopub/YPuA/cXv4ff29OlZ2RmY2new+0UyFQCbpscT/T38WIxGda2dh2dXfbW5s3tPHcXJxaTZmHjGH/xdODYyc0l2S16bstn+rYKDHw9NM3UVMqff9r66Rdf1tdWS2X4sFFBMK2VchmVwfLx8qirqcQbmjlbm9U20O3tbVtbO2xtbdraOqytzbp4vaHBgU1MupmNg4kRid5AdXbzlIn4Hd1CZ3vz8spaW3sXBxvTHTt+//izz7u7OswtrTV7DPWfBFVVQCZX12vdXQAN1n6JIPY8mL8Y7NsLtmwDhprKdmcbEMqAixOopwA9MhBxgYEp8HYD/G7AFwFjA0BngYAg0NsFFAR1NfuhKNVArLmiFxwC9AiAQQO8HvW329hAqQdUUmDvADq7gIMtYLUApUR9+QomsI0daOeoj/Gw/o48Ekrgxygu+oRAaYiTS1UKYYvQcN2ql2+nE+Bz21ntPYG+/7oUPGS11ZXWTh5WZnersg+gAr9uBQGhoEcAXnqh7+UoZARBCYwgIxg6B0aQEQwl8LBTkJ22e8/eY8eO0JvasEF9/Pnzxsb2hzUFE4tEWKk/ivPVt4I1Hc0/RC8PJFwDZf9uu4U8bSiBh52QALcKSt38yEmff/4lNqiPN9Z+6WxtggX38+t332Gl/sjIBOMDwMHjWKghFwl7hffsBXJTgLMfiD4JFOh8a5hBLbGGHYWk+1pa3rzIqUlZhWMD3K8nZ5TX1Hc2lJ2Kv5mWnHwz/kJA6PhvN3wuFPWcv3S9lVGdmk+ZOCYo+tzpW1lZhsbk6AvnPfyDmPU1uTlZnG7Z9Qv7s0oqiqoZjlamXVwuj8cjGRrp3emSetJkQK0C9WwwZTw2BID2quIKNs/d+e5z3Z4BwMoYnD0LFiwGd67DIcMBOgIPR81M2qWEtB9/+GHvnt3W1laJVxMCXNwNzOxffXmFt7O9Uo9kSSTNmr+8vZ267JW3yivzaguTixu6VGIuld3j6e4+blTgydOnrW2tYmMuuzpb+IROnh8xsSA/J1Ojm9+nsws6Bfx5Drz9OhYCkJ2etPf4qXOnjl9KTMUGaWz7ATy/Euih7B1mUAIPR05unq+98YaLvVV3j2h6RMTfe3fDgfr6eh63u/IgEPT0CXh9I0M9PA6Hx3G5nT4Bwe9+9NW86aPVHysVeAOTmZFzf/3pWxgZkIzcXZ2bWSyGhljS53ELE3Ow5UdgZoSFAEyYEvHGC8uWLH9hwaxp2CCNJS+CZyOwMjJ8oAQeduprqfX1NG6PuhHVkgVRP27dHnstmd3BodXT4Bkou6W5sbGJxWY1t7Q2NdBZbDabzvQZE1Fw49zpM+eaOZ3dvPbkrBJ3W/LeA4dzikpbWjpoNDrA661Zt/4bDTenPl3VFGeAKylYWUNPX9/M1t7BztZA0+EDRgk2oUf8hiV0H3jYEQkFEqnMmGyirzlTFQp6iYZGUolIIlGYmZvyu3l6+kSZTEIkksRiMZFIlEgkxiYmOKVCKlcaGZIkYjEOHp/18AKB0JhMFvD5KoAzMXnAY4AKOVDh1O2kHkUiAUQiVkaGD5TACDKCoSo0goxgKIFHGJlUiupMyB0ogYedrNRr33z7w197/iin0LFBfezeurGx42E9g7ey2VipPzKSQXQ06L7z1OH9dbSACzEgpwALkeEDJfCwM250QBuP99qLz3238RtsUB+ffPeLm40ZFtzP3zt3YqX+oDeC2VPAwcNYqCHp5nZw79lH1JWDkHEg4SKQoYP/MINaYg07CjHvWmretNGBBRSmpy05r6QqNSNbyqHuOxuffON6cvx5n5DxG9d/LJJL/z50srez+dL1rPCJYSdPnMzPuaVvZHYlLsY/bHRJXlZ9bXVZHTsr4VhKXnFOSR1e1kttoDEYDHNLa9KdZ21DQ0FGEugBYMIobAgAnZTymjZ+35ZYLt6AIAPnL4HnnkMtsYYXdAQejpqZtIyiuq2bvj106KCxEbGmusrLwdnK2XP9px97ONmr9IjWJmaz5y1RgN7nV6xkNtVVZCfWtQr19VStXJGTo2OAj9ulmFiSMbmitMTJ0SJsUtRbLywi6BH0NHC4PilIp4B0CnhL06uORkby1d8PHDlx5MDZ+BvYII2/d4MP1wNNNz7IMIISeDhycvNcvvx5CxMjqVQxedqMHzZugFVXPA6nfR0OhIdwOLy+OqFgPsrkMicXj9ff+XBymLf2viCBRI6YOfvjj1arRyboWZib5mVnpWnwevq8p8vUAqx5H/Tp+276rHkfv/PGq2+88+LCOdggjWcXg7HBWBkZPlACDzuUqlpWY1MHV51mL694/tdft2fkFTe1sRn1DUqgauW00ml0dnsLs5HV1thMpdM7mtiuYTOohYlnzp7rEckUclFabvkYf5e9B45U1za0tHCp9dQHtsQqzwHJt7DybYZWNvY293aXowTb/8SKyLCCGnIgyAiGjsAIMoKhBEaQEQwl8OPS2dWFlR6bHvWDCjrWzmFfTfrni5rkEmF09AWB9N+vYHs0bkdr3PVkLPiXnm4dvCnuvwwl8ODt/uW7TVt3/Lh5U2MrFxt0h0q+fes2rHw/Cpm4vq4BCx5FpZQeOXjw9KkzQtndFKJVF15NycaCgWM3MXi9Yizow9rW/saNeCy4TY9oVF+R1S58RNdZ92VuZZv4rwne0UyruRB7DQuQgUMJPHjBfq4u3qEzwtyPn7+IDboDp7d128OeoJUJOmOiH7hZ/4NKLrVw9nKxwl/JKMIGAXD0dOyyhXMGfV82Jz2J2tKJBX2ob04Z3KdLdZIRCSsNEJygwT/e8NJHwOiJtRVFgzmyIxqoJdbgMSglPKVpB6PCI2RqeW5KbU1lcV3rmV2bS2qqU3Or9vy+d2b46Fdfe7ujuf5CQkZBSnwjX48oab+RnhcbG2tpon81NWf0mJBzJ08V5WVK9cjr3n2LUpKpMLTLSLlRWlpaUVUdEBRC0OxgcQQDRyuTwwcPT4x41hlrR6mKT7rx7OzZKbGHfzkSm3j+sKXn6IaSW+WU+oTEZCWv+WZ2YcL1dD8n89ff+eja1as2lsaFJVWx8YnS3s6qWmpBaVF9eUG31CA4wFcu4i1cuGT+onnfb9rqaCBIreLUV+W2s5gxyXnj/J127TtaXZqvMrJprCsKGBeRcPZEA6WsurEn0MetnU1b8ebqNnplPrVT3FR67lp1de7lRj4p8/LumEzK4T2/KVT4zT9uXbx0SULsha7WljOxNycEex4+ceHm1Vg7J4d33nw38Upc1KKljPwkU/8pVkbo5UiDgY7AQ1JWlBc0ffGiiNDrSSmW1jbdbS1+Pj4LV7z7xYdvuzrZWju4+ri5ffDJOjxftO6j1TUNlHNnT5tbmuvjFU5unh4e3rielhI6x9HWnt3Z7e/r9/WWXeHjg6M0IiNm6PVZOXl5uc8sf3NSoOb1YmpSvEB93PLz9/TyD337jZdqahjnLp43JZMlIpFv2ISxo0JY1AY7Vw9vN/f9f++9HBNjYW4ikYpFneybGbkTJoT7+HuPnTiRpE8gkS1nTxuXl1/Gaetok5ksnRtuZGL++uq1PS3sG1djx4fPXbZg9vlz5+DfkvS0pWQXWNg5cjmNMLRx9PT0cvho3Sc0CjUoKBCogG9ACBweGOwfNn7KzKljXLynBLi79MqBAdns1TdXi1i1F86cBmRzB2uLXkDydffYf/gwWQ8Ymel18wfSFS7SB0rgIQkbO2nSuFE4HIFobB4ROWfpomfgQBwer3/7HV/adov4260X9QAObt3vr36HgAMKpQpWVk3NrBb8b0X4aH/1p/r6wp7OoxonTp3p+45uB2e3qZPvdhwJgIHSCJum5k+oy0oVYdqMiDdWrrh89iTeyMrCzFz9KRwVVolV+HFTwle/+VpIeNSqlxYeOnxUPf7tTmKjZky8fivv5WfHp1cx9fHYPMOvGpJIIolEKpWRjNQd2eL19AxIJhEz5zy3IEozwp0x1fVklUp5p02BdpZw976vBW9ANDEm2Tt7rnxntbO5MTZjAAi75aZkQ+04yEChBB684vLassJCdZbhDWZNDNrxx19t3fzWzvaSklJ+V1sLh1VTR2G2tNRU1rPa2mobmO2spldXrTrw+883skpNLe1YtIoupamdHvfAocNCQW8rp7Wylm5u46RtL/Xl5+tJfSqVtxKj6xkcLFDDkQn6cqWKTuc00RsamcwmNn31669s2vwThdZkaWWSmZFmYCCvqalpbIVH9963Xn/p582by2obcjIyqKy2ubNn+vuGnDtxmKt5t2fQxBmj/H0mzYgKdLbp6eK0sNjV1ZUtrU2TZj/HKMtMSMl5542XmpvaWlq7p4a5/LFnP4erPmC2sZnsxrbK6pq29iYjW/dWWnY1/JEMGovV0cygdbW1M5pruztbaqqp7uamMZdjps1d8tyLr+QnnDp54bJU3MNsZbe0qZ95YkuIXtaDPMFGUEuskYpBKU4vb175v4X3HOZGmvL8TGqbcOmCe9pdI/2HEngEE4lEhoYju/IpEgoNje52aosMFEpgBBnB0DkwgoxgKIERZMQC4P8Ab/VXLTW+TjoAAAAASUVORK5CYII=";
