var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./circleplusquestion07/Capture.PNG"]="data:image/png;base64,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";
