var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./circleplusquestion06/Capture.PNG"]="data:image/png;base64,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";
