var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./Midterm Project/tropical-fish_1f420.png"]="data:image/png;base64,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";
