var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./Lissajous/LissajousWCthumb.png"]="data:image/png;base64,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";
