var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./CalculoPI/CalculatePI_WCthumb.png"]="data:image/png;base64,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";
