var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./e_Mandelbrot/Mandelbrot_kWCthumb.png"]="data:image/png;base64,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";
