var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./e_Julia_Set/JuliaSetWCthumb.png"]="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAUAAAAC0CAIAAABqhmJGAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAHD5SURBVHhe7Z0FYBRHG4bfk9zl4kbcCAkJCe7u7sWhWCmltAVaaAu0WFukWIEWaKFY8eLu7sEhBAlxd7fL6f/N3uFJICRE+t/TI93d21uZmXe+b5ynVquhQ4eOCohCoeBrN3Xo0FEB0QlYh44KjE7AOnRUYHQC1qGjAqMTsA4dFRidgHXoqMDoBKxDRwVG1w5c1qyug5h7EAq1uxUUpQJWnhj3RLuro1RQKBQ6ATOkUimPx9PufBjEYnFeXp525zl09C8fRD1CBdcvFEAlF3wTpt0tdfz9/fn8D+VOkkYEAoGXl5d2v9ygEzAjOjpaj0Mmk/EFApYKeDwKGs23z+HxWApRKlW0racnglolf3YOxa5KpSwkIIVCYUBAgJOTk1Kp1B7iUBvZGq50sVYlFLkoIyCjp90sF1BIWFfF+ADt7gdgYeCyW8lXRXyRdv8Zap5aL1NvWPYwYxsTmUzKxQJPJNKTy+W0oScUyNjGq/B4Ij06QcZO1m7LaUMo4CsUSj6fp4nl56hUKgsLixo1amj3yw0VSsDyrBMX73dq10y7WwAnjh7u1LW7ducloqKiHB0dtTuvEhsba2dnd//+o1q1vJU5aYm5PGl2hquzk/brF8gSUuTWFoa0FXz/mszCo5qTleaL5MR4y0o2mu2CuHnzZq1atV7LF3gGBinTzR2EaTAAyDw/TzaF61OJ4xHo7M6dQ+mZIpB+WLZ6pgfQN0adTyHP1h4pKdRy5CZBLfjeIv2cXp4YrztKKp5Kkm3wt8PqizfPtGrfOS8ny8DY6OyxIy07dYc07eLNJ22b1c3OZb6PQChUsvDnGRjqnzl5pnWHDrKcbImhwdmTJ1t17KLMSvT1j2pZzz0wNNHZ2eZlDZOAjYyMKleurN0vN5RrAWdEP1y59ezTgPt/r1urxx2Z8s2UBcsWcJsvOHvkQEJKfJLUetxnvWl35ZwvP57+p5nmO45jxw526dJz5/ZdAwb31x56FY2APawsApNSjq2aeU1Q79NOtV2cXTTfUoIQGxjRhiLx3qrTOeMGN717avu9XMe0azu6TVlR1Yx0I9i8ZtnAz77h5WbrSZi8pTKFmK/kCcW0TSaXQpgs8I0bN3x8fJQqtYGBRJqTTRv0Lc/ENHOmhYN+aoMl+GckfCgToGSTg+OR6FyVUyZdnrxr2tCkW7IlFBZ8TDmIBT3Y7i9nYK4HF3v09ObMIJ2miU/KAjSGhzbomnQRTYIkU0/HNRkEXYpOlnEb9C19Rbuai2huxx1U0xEBeJrLqkkwIE+EZMWja9JpCqj4nANBJ79h6oqLGhECq9RRD81lsu8CJ8aYxonJ9+FBlaeivzwBj05QqBSmCvPOp3wkNWoEPo394tP+p3evl1fyjAmP5+fGWJuKJV4dmnhY8vjC4KCgKlWqgC84u3ujwME1LDL38+E9T/+7XmbjmhifJ00OtDbgObXobyDNdHG1e1PAbm5u2v1yAwm4qK5b6TF7xu8/TB7/17JlaWEPfvv99zshka4OztLkkGW///EgMPzbbyf+uvgPOu3m1bOWPm2/GtH97OEdG3YcdXSpQrrZuOavM77+547tWbZ229l9u09fvvggPDY1zH/Z0qWhMfFfTfx+7rTJFD8L5i/S3IvoPqDzxccpMLawtTA6cOLk/Dmz5/86J+rJzd9WbV69affWv39fs263oSHT5/4T/p/0bDHx1xWVRamTJk6d9tOvppUcYp7cmLVw5ZLVmxfOmHDt6qnJ0xeu2ryTTibDS845bZCMVSq1Ojd51rQpyTKBSE9IyUJJ2iAl8zGgOnxM8fU+zDqO+EysvIHYBKy8guAkfHsYy69gygn8dBayHHbC0yTYmTBNHvVF69oY3x7NrbDiAnY/wfYLWHcHR55i2A4kpOJRPFZdw51YfHcQq65jyw18ugvJmVh+GaFJmHQIM44z9S45h1MR2HsLOx6x3bRMXAvHzRhO51LMvIyfT3MiF2LKGXx7gGl11hVMP8dO+PE8Zp+His6kpFTiqYnCRq3wdrN29nSkTIMv4iecigndGi2QCORJeWn30zICskjGQj7PPzb7oy4d8pKi9ITC+5EZH3Vqp8yIVygNBvT/6MaN62Kxflx0+KZNmxJSM0VCwYOEnI+69ZYmPtYT6t2OyezXrUdeWoCAZ9a/f68rF09dueRHHrj2Aco95VfAyamUuskvM5q9cvu3X399+Pd/zCxM563Z8s3XE7Zt3lLDxfuH7ybQCVPm/h51YdMfW7ZsPnwx6PETPUMj34PbQjNETwIu3ruZMKB7q2qNm7Zv3tJFX7R4695vJk5c9fe/DT1rjO7U7ExQ1pSp33O3YjhUbxbvd1wgsaXCLfiir/o1jBJ6Xj9ywthMFJsSmyM3/mLqd3KZxhOj1Mq4dXzboImLenq7hKdLd286NW/WZKOMNMuq9dq07qKXG63isdJa48aNr169qjlfoZCLzRx5OWGP0+RnjhxR8wUqMoOcrZPThiG8rNDQEkbGGF4H62/BTIgoKewsMb413CRwEkJkgbYOuBYFEfcIyTkw54qEiXGo64H4RFia46OaiExBbydEKfEgGHwx/JLgaIWxTRGbiU5VsfUazPURkI0a1mhqi22XMagxDDJxPA6PE1mKEOvB1gjWEqbPc0/Rqg5qW+JmGrvRgp5wpu1H6F4LLQ2x+zpa+6CjCa7EM5OeXm9ccvslKW0XltQnrcOCzPpTEuPis2KT+XwBVIrsIGWlJqYqhYqvLxBZiPRMhMxrIMggE3y+kGKHp+axXW3a5tMWj5+WnJiekZGemcNOo9O5f+QZkQvKHdH8R86FUE9UkWoUy6+Ax33ZavGGQ0/97tR1tn4YHmFW3S04KLi2o21AWISjs2tIyFPNaVOnjh4xfoqRyMDDpfJPU8YFBwSYu3g4ubp9OuiT6PQAUyOT9OSkhDyEhEdUs7YMfurnVcM7MDgwLjFRpZDt3bFLcxEiV6H35Nyh6k2bZWRmKxW5q/ffd1UGVq7jbeNS3ZAnUshS9m/4i8kM6Nul1h+bD/42bay4Woej25afehJkJea16uizfu/pOIVMrZBBGWfq2Sb00W3uwmjSpAn9JQtMbnNedoRHtX7tnAwE4uSQpFyW+Lj0F5HObF1oOhKy6EngnwB7E3SpidomCEpl54RlITUXB65CKkKOHBF0UIEhjbHoAuITkKWPhzEgv1Kai9gsdp2+1bEjAA3tYWuBgR54nMBKyzkKmBjAxQqN3dHMGk9SEJMBN1scD0Y1WzibYFwdpsOkNBwPwpkI7uGdcecpHqXARY1bMZi2D1bmcHHAxVD4ZqBfLVwNwZUM1LZiZlmlZ6QSm5bkR2QKkVFWekpmegoTmVAgz80VSgRq8OTxuSk3UlIfZPKEPLlSXd/VYsO2XaaOVXyv3Wzqaf/Pv3tElvYSkXTthi1NmzbLzc3xqdu4b9++Xm72UrminqPZP5s3WjjXu37tWvOqtus2bzasVJ2HtHWbdrVu0TArK4e9eQWhXFdiBfvfEdm4O1UyuXrpQtMWrS6eP9+ydeurFy82bdny6sXTVeq2sDESK/IyLl31a9OmeW5KTHSOWBEfXKl6g5Snt+286oukieEpKg8H44CQ6JiY+Datm1++fK158yYXLpy1trM3NLQQCdS2tjaaMnBqeoZAwDMxMk7LyuUrpXKe0FIfSpHx09u+XvUaU958/+EjD3dPAzGzfREB99XmVVysjRIjAvWsquirs/UNjR/dvu5drxHl8iYmppFP75u51jJ+qcb0+vXrrq6u5Jtt2Lh+3LivVy9e3G/0WIjNVAssHIRpl8LhYoLwHFgLYWGB+BRUd8aFIDS3x+UYNLCBfypEKrhXQlQGjIUITUHDyswOZ2fiSRbqOSEkCnZWiEuEVI1EJVo6Q54HPQPcDkIdJ1wJRT1r7AwHPwU9WuJxGJra40IcrAWws0F0PHwcEZ0IvgR2ZHgpV6e3pHTBlX6jEiA0hK0eMhXwi0OuEm2qIjaOlAVrI3ZHhRiORlwZmIrTL0qOJYEasUJz6dgnZrK8MQ8nhJvE8NKVslyegS0rCfOFfEq9CplCkm2wyv6vewG36jduFhwY6OHpcf3ypXqNm6tlmXcfhdevWTU3j5XOqSzDVU1DIhHfuH6zYZOmIYFP3at6XL96tV7jpsrsVP+QxDrVHGMTMi0sjKm8wz0BozyXgXXNSKwZiWJIIGDKpA3yuDgHi2wm/VMJhHpKhZyyfPLNlEqFJl6FVKxVqxQKpUBILhwVbemPinwvOhM8PpVt6QS1UqlUaZOzphnJ09OTzpRmJh04dLpNt562ZhK5vjVvcSVHvbQXNVXsptwG/ZSERH/puegvHdEcZI/G/eXcgRfHNSc/96hoW8PziwAH7sPcAi2duFtoDmo2nv/2+a9eho4/fyrN9enWLx8kNNv0KVnUiOA7Gc6IMJJi2vXJmebpAh57EwpyzfeEmqfmZ/A/ln9sbm/OGgL5fAp3PT0hV+HPWoaet/Y9h1xmihFWA0Qnq1RUbGYn83gC9tt8mpFIIyYmJu7u7tr9coNOwFo+dCBQigkPD9ds8wUCTSMkSyVGtoL5xo4Ckr3myw+MJpvQKP9DoMkRSpQ8HsLhiJzEqhMuw7W+9uhr5CFdmi4SveTwlDQkbDLC2p1yg07ApUdqaipXe/IKapGR3pW5Rpaid033pD1pUbTOp+tSSftVw8oeg7sI/SFTJuBDpM998Q4UdHOVEiaO8Byp3dVRKhRNwEeOnpWTo6HdY+lAoFaFRgd7ulY5dv5qpzZtklKypDkHKlfmCwW8PCoOvQSfy5ufeZRk8egyatacSF/xKHvTHmcVjUr2V60kV/TF+e8HOcX0ci9fhI7QvTRd7jTHhXrMGZSxfjiQ6NM78rKyeCXeJ4+km5ubGxgYqHHUn0MR4FO3sVBP/11igR7Y0EjdrZtaLmOBRnHxHM17UYi9HJjk3aem5iqUH0sMXo5lnlqhzsrLFPDI6+cbUZk/Nena1dMSAwPt9wVDjisVMbQ7b6JWIC9Tu62DQypFhw4qc3O2TfEioECnJMkFob4EChkUr6Z8ggepmXm3Bg0+4g6/haIJeN/BO9416j5PH4SeEDdvHq3rWX3HifBBg1tAjrQEnoUBQrLQidW8vkCaDr4+RKxrwwty5DDQQ3oyTC21R7ISYGQNVSb4xsjKgdHbE1VhJKfC1Jy5jc+JS4atJfKkIA0YmbAjsYGIUaNeVe5rwNaGVeqWWyytkJSI6ARkZsPrpX5BSamscliZizQVLFlbNUOmQPBTPAhIqVPH/LnaKW/KSAi+F8+zF6UnJvLbtK+VEJfbqF7xAlpHwdy8ifr1kZACawtkZEIihh7n6e/ZjFpd4f4s5SvSITRlG2lSBD4Y16DBcu7wWyiagPcfuuVZrf7LAiarJc3NVEEQ8TTEp251KtNlJfOis1DXEicewdsWOWrcO4dhc3FiIdJyUKsp7gbg2/E4uA/mHji7Ba064+4VuLrDoxH00rDnFDyNERmF/j9i72YYyNByCCL8UMkIxy+jXgNkZ6FnJ6xYC1fSYS6SY+HgyapJHRxJ/XiUhoZOSEvFjSfo1REnb6GaAaJE8DZGhgn6tcX2XfDywokn6OuEA5cx4TtsXASvFkiPgH8cBn6Jzl54Gqx9u3KIswvCw/DbRiQlYWBbhN3HjSj0boczd+BsDGtLXPRHM29WC50YCYEYnVvB71FijZpWz+txyEqnxoaFJyZ7OrvGpsm83O2SUzKa1OfSjo4PwPUbaNgAC2aiSU9k5cE6E+ei8P1o/LEQg/rgfCCSw1C/Gk4dQLMBiA+BsTfs8W2tOou1vy8UEnCxnEXSvr7E2EBi4F23+ouqPh6Tlq01lOnwPwmPNkjKQp0a6NAPlzcgI4OdkhiFgEfo2J8NpKvfCI+uIzUBcfFoUw/mrsiMhIMB6tWAjTse3oKdLaL8EJmES8eQlYWEW2jfh/V2CL4HTzcohMwoWVgj0h+e1sgyRHQkCzL/eDSqhZAgePpA4MT6EcXFQixB8CMk5SAmGAGhiJajc1/EBOLuY5Yvugrxau1jOUWdBYUBEkNw7zYaNsSTJNT1RMADRCaiRk3EP4GNFRzdYe/FisCvZc/kv5nbudarXU9iZule2e65C6fjA0FeanQcK14EBECghxs3EMg1sJPxy82AmwkC/RErQqsmkOcizB+CIvYiKZYFfg3W9UXGszZBhBT1PJh5tLTD8GHYtBmZrJMiO+fOXdTlegtoGjZUUmTkITsVDq5s92k8RElw9WGdanOyEBsOLx9kRcPQAX53UasO4tJha4o7t+FqD2Mr6FFRWoiHD2FviMBs6ElQwwq5AhgZgqdEeDxsjKBvgs1/wLkHWrkgOReZ4TCrBjMe7vuiVmNkxyOZSr8yWNiysPMiJWh7iJRHKrshJBjpaTAxQ1Q4CwFTelMFYtOQk44qVRAWBjtXUEnFzx/VqrL+mNdvvmKBX4MKz+npOgv8AQkJYf3ezOxw7SaaNIAyAwHh8H5pXNOjQNiZgidCagoMTGFjiQd+39ao+a4WuCQFbGaOPt151tasoktORXbSs5qZyox08ARcVSgPQgHy8li6YaaBa3DVfFgKo2/pJ2zIHvuWz2Mle1ZhQ3mSitU2UUGOvqcri0Ws9pQuSNegor+I29XcTsF6uWvvReU9zWn6EqjkyFNAQPfiasjoe8oaZXns4nQjQkWniXH8BHJzuZcpl0gk6NABCjnzfVhVH/d27E3pvfgsDClg6UXowxqq1YiMwG9/JDo66QRcZjRpwmouKMooRtiYRT5LqBoJUOKklE/pUFMzSNuUgLOy0bPn95MmLeR+/RZKWMA2trA2I2lyj6OjfHDJN9HKSifgisSkSZN/++31UXf5Utwy8JvwtKPOdOjQ8Z4UaXqlEhZwxcbHGm0ro7Xri0+bymhgr/1Wh47yRwm70DbmrH+5dr8842wKdwtMaMQaowdWZwVK5vnra+vWXoGOU7GYCig8/OsHIxEbrRuehsdJ2u/LNzoXusIxefLkBQvKyIUu7/T1xqaPoJ6P8Gk48yV61cDgulzPLMp0SKJSIPuNj0a9hBqD6qC7D46NwaPJUC/G5j4YXgv6Raz416Gj5Pg/ELCFBF82wI3PoJ6H3Z9gWANu+qkcTpxy7kPq1XwK4vkJmvPpt/TJwtB62PgxcmfD/0t82xR25a6zu47/PMUVMJsuhgcx1xleY6fKEc2ccW4kkmdhZT80cOG0R6KVFarVIqERcx587LC4F2Jm4OYYdPXQflmOEQpZewabN4bH/aejwlIsAZN6L184JELy5vU7RfpcW245SQ2tXJAyBZcnoDXJiRxjcoPp4UpKt2+i5G6Ri/rOOPI58mag+7Pe1eUQedbN21elKSFHz18lDSvYxFw6KirFErBaCYG+XGRo6e1WVa1CaEiqdqhFGdLNA4/H4fwEmJNDm8UZyRKBMiYBIOEqut78cPNHsXNIDFnMtB36HNGTMKjczSRM8IRGenrpoSERstQsynMjwgO1X+iogBRLwCTWKpUbRD55cCsqkM+DZzXzkh+J9+74VILvaBz+HF62QCZnFUsEIUB5gQCBCfj0X7T6C/yp0H/2oe2Wy9nxkCQuMA24vxQwmbA3x/YR8PuCuQPlCZ4ADjbuFtaO5g42ekK4u/tov9BRASluMxITLA8iIaR5ZdqMtKEXRrbgaqdKyuQSVEbUZyObvj2By1wP9GfUw/f2qK1ERhL8buAv7VHi8/r4tT3MrbiyscYZIf1LcPwuumzhdkubfJuRNLEm4LHefLpmpPJGqTYjsZ63SqbeMsPGEOrZGNmkRB1mTnWnA2A9A43WvKxeV7T71OR2k4+3SBtMqyXsOwR/zobaB8+mjF99CxbzUXcxsqngTX41QdLJRGcfqH9Fzbes3lBqaGLt5SkBdFRQiivgMmZeO8T9xNVOkWBKBCrHGiE6Bc5z0WETEsmQvsCHDRk+LfikXpak+hcjZY7fWN9CKMl0LHY2w2TtScTdOBjNw5KznEetqdWjHE6G+99j4zvNtKBDxztSkQV89VP80JlrGSqpmjMBIMY3u+G4BJHcwOWXMIbdZ/g3AWlrN2HSF6cmfNVy2BxsgdtxLE0DhmFBK8zUnqqBHO9WK7gqLk3vLsplsjC8CR6Ng14Fzzd1lBsqZkoy04dqFpq4c+otKfSRnQvhD/jdV3vgVb5FDJnRQOxTpaKKizCnZebqYb0WLcNpTJoB3gJM6IWfxXi1MHkxAiYzoCJX9XlvrRxUs4NsNuvIqUNHsamAAq5rh9SfuaW1SrDkbYSdt5nfq8y/Bm40rou5em0Fa+/Fk2CFLNL4+xyL4V2waDG+mYSjEcsDxzT+Coma81+QKYPgZy6cn2uYCupKBP7IWrx06CgeFU3ALV1w+1tOuiXVSkRlVFNMO4CBL5ZZeQ1HNPJEQ7olnark6skcndFOfyBu3236+S/jx2Ppb/yoC/Uzql8PFi1pg7maX70C70co6YfPR0qQz5+Nw2MxuLr2gA4d70WFEnAvT1yYUNKFXgN0WYl5l7QH8uNL+GrqssiG3sFm2rC2hcz5oxEmbsH+F33EcxvzqnRYldE1pcllx6mt8aMBns01+DK2i7jysKZOiyBTn4ltn+KLBtoDOnQUnYoj4ObO2D+WaysqqXZmAZtop8o8tpJXwXTBHxRGmluS+BJwe/u/bHvwUFwT8A3c79Z1vX+9qblRPIbMupaVhgCcm4D8JrZMykH/Dawu7BXS8efHGKDrSlF0bI3wXVPMb4/ISQic8Mon5GucGY5xDdG+3K1mVOIUV8CaCaXYdHYflFYuuDSRJfcSUy89sQhuvyMkVXsgP/Rg0AbjNS1UIuAajjtXw6CB3K4ZjB53qOvpGGGs1zrto6H1YuggT4m7+McJpvUwhp30Grsf4W9N29LLpGHHaDYssdRhkzBVOKpaYu9ARE1C7Cws6oUp7eBozhZ9e/lT2QptPbG8D06NhWIm61rb11v78/8cxVKeQIDk1FQ9EdJTkvl8NmHdB0kUYiHOjwdeb9cpBvTWYkimIZxyhMKYgpTnFWXkP+/ByMN7tLuPl32sbLH3cqUOVnk52UFxPGtyDTB7FgJxJ5fsM1Y3AeU4b/D5YUTEvlQY1pCOjSPgZqbd+8BwUaRSy/PSMrIoBgVFnci0rOjhidBvEDCdrYDsQGFFJSnKWpVcYNLneb90PW6XXpKiLpelUS8bNoxU/TOWddFe6j/E+wuYrG5OYsyZyydkKU/2HL7G18f9e7FqzQR7JUvcd9xYn5LznEm9gqmQvqUj0nCcNoRYU1dmCBzD6jot42tUw7nzvL51a/2ccz34krzR4cCjGacr8S+7yNlSFAP7QwF/SlZUZu6PJa5ozf36VfrvfMMIE1kI/ka7+UHhQZmTfPLsDpUi/e616wolHvnf0n5VbmnrykaGHPyMTefPvDCKE/KHDCGVs3VTV1/B9puo/xtqL0S1XzH7GDb4Ys01bnJTSt4STsxcc+PXraD+BSu6chf9j1AMC6yGnkgvLSVJKTC4cn4fmclate1KfjCDYhbMqNxYUnXO9Hg8rm32LdlBC0ytiXYa80tqe4jL5zD2zgXsntt/VJtugXcHtnZRilqY3Eo/MMKl5tGWrQ7t6vPPSn5SPOq2xGNcp9uQw/A1znlQIfo1bkRj/QXOVrwMZXwC1t3yQ6OGyMTS2dbg1o0r8TkKAwm8qxew5F854cQwnBnPRoaw6g+SohFSc5hKq/wEyRw0X4exRzBkH27H4X4iW7N85gWMOogxhyD8BZIZGLgeF4O4HJg0T/GpxletIJvB1j7/T1CswQzkjOmLkSdjE6lnZH6AwQzfN8PCXpw9KxEo+g3hMQ9BKdoDBWCP+t/jJmX19ANS7z0c3Ypue/Zgz7Ux25b+a1fl0+rdl55dol+nz/hbexdVdbav8tF3YZEzH+8147cfdmv5r62rdZmJo8ylBiyo5IvpF99sWyKPjvsf9/c5+lh1GV8c1u6VBPkOZtAM6BdwK6SV38EMbuYInsrl3TKuBCNhA0u+2Is7yfRlJbYmefeG+FIKnjkccvTP8gVKHk8ozTK3QN1Y3MtC6FP8+wTk73D59rz2mNKW87/Im6N9M/x6AD+eYd+WM0pvMANJNVfKesaTekueOnZY2KdE1WsAx1/eql4LuI/DTXohMafezRhK6qW8qXF9HN2SUM/6F5PhVqdWt+7QxTA3iTUpqVy97yPL9VjdSr9PEN0X1amMDPGxKCRoSpZ0s16YMwBvNDKPO5KfIy3F2Dbo5aXd+2CQnuWyMh2C8lYmNkHwDK6UK2dW1y8aXrPRaI3pHYPm+G0kwtvpzeg58IbeoM79LzlnTRB0Odph+PJVQ9b34E2v1+4qr8acRp79fq9vV2U0HvbEMQ9Vb0w9DdGP+OkoNziUkn0K64d7b6z2dhWWcjwrpXoeN5SnpArVZuj/N6sHLhRb1JqEe3RXcnCvYscBfCrnik95eWz9h86ST+M+Wme3a8hT9alYy0q5CdqrNTH1fGLvrp8bHuvgtWPabWlS6IjhBgtZz0ythaVyWAQer8SrdaG506FPft1rL0gZjQTWP702juK9qZCzUv7TGyNacIO6KRsU4uPN2PaQDg/AaSO4ewyaklt/R44Syicwiv369nlLj7wh2ep0FfOQ9Qx5kkh1qEvjkyqnk8ZuAUbuUAY4hf/5myin4yH0jsR5mPNw52u2Ng+zDWLkZsFsPmQlVUYrAf4Ts1I+Hc8l/pJSrynaLHureh3QeArukY+ViMiZsNuNQRr1XrvG1EvYNH7ocLfrRTdVolLwXL3EtfSA1JAUR6/cXsHm5vzQ4cMoA8hZihZUdtfYYVKyA6rNgEz4ctH3s4NvlIQJeus8BH+t3fs/5PbnGNGMU68+UjLBm0rq7YIN45DM6/iFz1VXc/tDYaumZkxJk2/IuH28QZD07iH1Z2tRbz2arkeDdeqWT7Hxqq9+6q4tggXqc5+tV8Q6ttw1IPNrsz5O40cj1izVBZWX4a/zXMFYxlaFzlsIYy6CKyDlUsA9veDhXHKDe40w/wjOh2n3CqA1fvoO16iwtRvfLoVzFuI0x2fOROPGmk2EJKTcSH1Yt0mWubH22xcYhN690+lywlZ7bvqNHRsRi8szYZ+AIJKxHvcyYuhNQ5YBFd80bPHjqlXI5L6GEsbm+PrZXf+vODEMdd24SmND7LkDywWGsP4EUWY+Z5scsLRpknS16b/3lyQ8CpL/DbMVMDmKoU+xL6RnMHpUZfOQda+a08fikfXum1i0BQ1mg+eH3x9t/fVqtyz1jU7um/vajW3VC8drYxy+PIoOK7iYoRwzB+k/wqlCzmpQLl1o9VzOeS72dRjG+HEffr2s3SuAUbhUF82DkbwUNi/XeG/diiFDtNuExLxLTdsQExvL0xeuag89w8tH1NrJ4uzxXsfCV7tR5gOMGIFNm9iGB7rWx9ga6KGxthnAHEgUmgHMXzTAn/04C/0mJuBN0m4Wg4rkQv/RBePbcbXNxthwEaMOVEH3DljncchGLxrnJ/xlL/t4P7pE4Qo7uWNlfNkIvahUQj4T2c/nqYUyRHpbHu6FYf1trLxJbhwfvN44ZIa6koHNG80Nud5xeUJInV1ojgY2uPGN9nyKd94s7TXKlAruQm/pw0VJiajXAKfuFa5ea1RfAnUNND+Lc2udrDp1Vfbsjc8+w/59rIruuXrTyZUzQJ+0uVYtnp6WWr1Z/xT8UG+nY8061VotnUsPz9i4Ee7ubCMQR7ej549MjrylGJqEiPnPFfvXTe1GPuSyAc//P/T2wviOnHoNsewUqbcxZjbH93W32kTucL87NiNEdpdMbpTkCqa3gHoOTnzF5uVnUDmLPCdycTQf2qYjeajtiD/6QbkMp4apvM32ovtmuCt3XN9ZfW7j1eMtmq78DPG4GY+q87jERj/Rw4MvuQtWJMqZgCV6+JhcR03nxWJigF030ZFVFBdEf+ycjAdkcA9jn8vktuF+OH4EAzu76hvW6dVbew7x1Si+mQkG5J7JQKTUSu1RefabdeN2tWybppr5Zu6+9/fKqvVw+Die+PEDA9G9u/YEonp1zD+/1WSky3H+gkF0Tw17bnMG5E3kaFINVf4/hg3bGGLfKM47McDai5h4vC1W1HIx7/lv533fjZBuubERJvfwN8bWR85czKYwpUhjVVbsE5WKIw9x8on2c+Ixzj7lKheEnDLT0d4LD6fj2FA5clahkkxqfqzDbec+2+2HD/oSSQjMhOtCLkeWoXplLKZMpCJRzgS86SPOnyk++rgXggEFjhDsgIWLoK6D/nSzW7iQ3LpPtsXqmsN8zOxrzRgrOOYn6Fu73cET6NwbLrxfHifMbltr7sNm66592mvpSgQ+3Q8zB+2FOOz4JhGutoo9MvH2vWIXX6M7P/zaZVebJpZbF3odOoTISOZLP32KBw8wpBXmBdm6fDw1E0oqsbEff3+Sa7HKFym299Vu/reJ0gwRFSI0Bp8dqo7PJOB1Xfb97jGL9WJ7rIKFyoSHoAn4ayAnXbKW5jj6EF3+Bu8HOC1B923otFn76bwF7TaCNwWV5+OXE5xvTPljNjp7s3aNkbVO4ssrmPTwuwirehcVnbsPRQTCszB0A6vppNO+7Yx2FWkIRHkSsIUE/RpyLlAx0UdAFOqs0u69Sj2MmYq0Dvg+m0sIGcjagdabV6G78Hu92MYO1VfF+9STuFneSTUc2bmb6MAxpy5nY5+cexD+h0vMRYXgp2kjBnlW3gvPb3zQS8zVRpmZwrBWTVxRHu/kmbVwxRmbqIzxe9QtBqS6dVu0vsed63B0xLBh8OBG74/v6SSJsB851eqK8JP+2M8OhaYhMa6AiFCggRfq2Gr3/qus6AqhIWctlXBbVh8TOxuPnZv01YqPFmVmmB1EP/TxQvoSVLHmRK6Pxeeg9w26bSt8GBnC0jDrHHgz0Wstssino6KNAhuG4/TwcFw4g863vk6p2se3xfQBX1JGufUhNp/n2vsycXq09goVgeIKWMx5f5q/xWUP5a8UQ8VEgnuh8Fqh3XuJaugzDgGDsNoApuQBU85MPtYisC511T0RmWGXlRUdmvCZoIlL1NroqoKcrAEXDo/rkqYIynW4KDQcfLT21JwdP9/dfhp+Ubj+/UMcUHDDK3JyEXT3MtL8cHqR4Po8y1uXY9Y4+6auNde7ndQ0t03jZn2G4tOBlRYN79RU3OOu5BNxRFvjm1W//yNFDoEPBrBLTDvDuXz5koPd3OinkoPHZ0tq8DVLq5Q5tWzxVVuu0GQAr4XWqFYdgy2m19vQcDUfpofxMcbUw56xnHctwuNY2P7MfBYF5b3vzMEAGM/DotNcIGejnQ9ufx6PR3vgmThGHSnyzas7tif2YvgBRFBOSjrncUmxYlAsAQtV0p37thnpq/YcPCQWF3s0UutaXCVEcTDAtaeos1q794zaGPkdYkdhjw2qagwvYQIqVHWQI9OQcn/AsbKBbUBwrknjLtK/zZt+59cnynXPoJHiAQ/5o8L9ZPzoM4Kj4+Tp6uikpIBA1pWPUHK5jUzjMShyoFRFJsQkq6S5UmOf1NFxd+Nb7/3Lu3Yjt63qIN9uk8U93NxFcsdfjN1ON9/jmSFAKE72xHr22zV3uEvkCxklF7iW2EAlUm9WXPDpq5eykkNPXr5DsVbGo5G2URmB1CvB9P0IyOqHR14/tz+zsgtCBp7AKExoiNXDuAEMJlh0Ct4rEc9a5t+HyafgMZ/LtOWoWxkB47IQdwgDk2YmmQ78p6ZhQzN4wmWptnG4T/2KslTd+wuYkkJKfLy9i0/E/XvRsekqQfFGIx39+M2aoSJigFMP0HSddo/DHZ1nQj4EG0xhSzH/vIGIYukIFoSAcmUMGsSOBIfFo6OFo1ndU0GdQq6OTPzziepj3s6YVOcT+5GFaDzQyPXd2OcfrW7RzOvgyC8f6Z8IHMMztFF2Ojxua4/P7p2eY/TjTFOjuK6OIkt9gS0o9+Ac8V03uSqZfMnBwZfasooHGd6k+DwLG9v07ORMWXaetExHIzVzhjcVOFVIT8Hcy62wyvPrdnGPKrtGrPodZpjUEL/Ti5N6jdF4MVNgMQlKYXMbpWSyO1Z1QPLkR9h5Bd+H/7Ch0Q7HITjJzvl5H2eoZfj32Vzf5Zv3F7BaBUt7h9T4cGPXKo52Jjxl8UYjdalRvOorMyw/93Kdcw0MmYiIL3BMCCFlDC/adrk6jUDcOo2pmt2PuKmaswxi9E46dah6LduXdX9X5sL1aYx+eGQE/N7vuS5duZj5+1GLoDY39n5/N/vmiTgY3P7SLGp5wsJF6iTbJGOra9ILVOzzRE929nb/AuqiCQVquEGibZ0qJpTB2jiaZKck8KQia4kRWeCyHI20m0RCkWOIYTv0YeYEN6ueZw133NuDZqhhit/Ij+Vsr8+vuB6t/UnxsVyAsAS2YWGJfQMeYIO1qnfoDU9pl486Ygt+usg1yyvRshY8KkATQLFcaLla2L1LT5HEtE/PnrI8KEgl79eL4/N63JO8129ZocUcg9diwjHNvj3qT0PWcGy1gBOX2b4CnU1u+t94MRNVt27s74EDSDYVXNpqbDSYa70FbvreS7n6RLP9vgTHqQ7GmcbEPWLXyTkdUlNQ1db72qDwagkBMSkIpWerCXIRyWY/5mrvCiqAKDAjv6HFRYeyXYmlY4v6zRy8ajZvUidPBmVZrU7YvSps7dkrPw7BodBe8G2xvuO/vWYfxVdpiILfFE7bRmj1Ox69MddnMam8DKFU3FWgd2OMrvkXzH1/OenZ+051KxtD2KLHP5yLllUhjHCxBExQCZDSBKWDYvGLphrjPdBHVi4cpuNfsmAwhdM3CJuIm2IYvuwwP0djxRbBjvs/Y80a9vdBKHB1mcwqs7fB6eSQPvr9DGFpmIHo98tRXkaaEmGaeR2mWvc4w+JpsOWI77esuHAZaXhIAvZEK81XuE4PUZCZzcMPJSNgguJLrgDJVl7MCodi8k9vTqISdPq7Mno41tvk5we7rE/v4k82oxXLyyTotw4X39IH9j1x+53LybOxZgTt3cEPYYt+NRzfoQsO4nAYYmOYOanrCU8rzenlluIKuATwsYa1zRuW8q3Qk5tg121WwRhDhhZd8Pt0RFjB5Xk11WuQOKhw8wsMn/dzbtQIo0dj9W/Wv7t9ZD/ypEOnYwfSG7ol7JE9skby+1aWvEF6QhDSNVrRj/UxEf5b1bZBRFQoMuFPzylk6ZSbxXL5jYKLwZSTSNCxinbvP0BVS1haM5UGhCJS3hjzTX+al7384Cb4oKsr2tZk5+y7iT1vGX9SLDz+4CytFNc/e4JtGUG9k81h7eFbiYpf3xzgGuelmPUsey2vlAMBD6XYKpItoGc2Qk4eGv6m6arhgk7zoe6JCSRR0sObVozLzJlBngYT+bOqMgsL+Ppi3ga9H5c33tdGHBtlnRb+VaBtojy0ueoRGcMSxti5DqoMNZdLHLKv0+7Hg+mPPJEbNmwKrvM0S6yFVAjLMKwMJr77UExrwRUZJBizywp1qjc5nXHcOFUpkiIVu4Zw7pgKw/ZpT/5ABKWwnraUOhpWQyOrk+ifNmN5429mNSAXbWcQ1JwPN7h8T1dSLgT8JRVH31HAlL4Nmb/e7W8YzsVNVrExDLe7Ve40FQZfw+Q7iPZiQjyeijjFkr2ljwH3khfw50/gydggNcawYUjmGoP+nO7TTmxrI29TRSQ2jDnt8JAfiY3cKSVNxF2ruiIDkygDMB2O5UaS38cOylxsqCBMSBVITSg4RuQYWlu7+R9geHNWBJWn4mJ8J2w3mvO1bM3p8/gUY2rAwJzF26e7kV38Lj1vo+MmLqXkYOewRPibpo+MdUl1t5Aawx6/ntWagzH1tCeXS8pawCZimFCEFe4/UyInf8YI10LRfDn05+DoUzpqAfefoBYO+arjnkk79+SSOKlwdwPLV8DzR0h+R+uDmLkfMxeg4wzwjuIrzbXatYO/v3acEJEWY2DX9mBk7YQdR1fLA2Kjoa0JK3Eo58jYtS75wdAM88fBnIG/5Ycz2E3+gjWerc9w4EnBRpjzost9keyd6ODGvY4eFl0whb1MdCn9IkJlqemIxqq+zDIHhmP9Xe3JH5pBa1l+4eyE5tZ70Dpk/Ny83kNa4XdMv8Tl/7IymfH33SlrAY9rWKh6KXlTKUWAdddgNo218V7RLtXrgwFzELgX877+yXfmePODq9zWrUaPnjA2hqUlzC2lWZYXHlSaHe0++6vZp6ZNx7ffIiSE1ZGfPg2fZ/OoPwkl97X5eUFc1oowUsejnA9bHytDXrTfKm/L6IkNJvy8AH5X9Bq1u0jOovp5ddvux4V60Qp8858YJPxdU85/FmHBpdr4wWnYtLBtU29jNhpbgWfEZFPwMjclz46HSElk1YQ/dU7A7azQHpXr5UhgxXKYBwHshGZVISgHjmoBlPWT9fdm6TIfSLpGiE3H0E3gTcfog0h/0ZGiIxZ+ih3kAvth2t5/cXhG+8dR9UeNwcEDyMhAUhJSkpCehIwEtGpS++fpmDMbixejcmXtz59zeB/6ojPvRn3UaeNua8KNI/+w5PQ0gf21SP2IHbNHfzG7Rp8m7mHI4D+vu7pBhYI3i/DPkWOwZgBdBYeNFlAjJR4ZcEJjry8SsgMHxeAK9gxnwk6OZwsslyYzyFsWoF1teAiDsT/9YeNqfU5bkI3YdFPrRXcov9WHZS3g2u5vCJgeyRDBiaizGPaLsfWB9vAz+mBLJ3yfCzzCQdrNysSMFZfjFNKhrapnvjowvmnryicvN98wnc3YnC8//uy5qeGq+yn3xQ5nwkPfbHX6ABxMunprRrKx0q2Zn2Elw/bdgh/iKP+5aBOzIU0tOFJUMLVk09xXaFxMITBmqthwwxLVXOqfi1vZNA33WSZm78iO/3xBe2ap8admVDZ5y038sDRt8zTHRpsa4xesu80JWI6PPvg0g+9NcQWs6fv8nj2gmzlz5duXkbAGyg5/wf0P3MsnGx6MA03wMZUnKVwDcICO5CUZ3rtVn9/8qvzSShMD/aauQ374ofnyVahsY6LvN9rH7ty3c12dK2P1Om6OuWcEBUNigo9zuxuJzSupquXduqSZ/qoUyMpZEvnk0BnP6nqVf9h5iJz6NCu8lD5YzVwhkaIqkcT0ftFVMvSk5+eaz/bf9cRQWZM5cadH3CT/eQqVDuTs+HJWS1/aHOCK3N+1ykFqTqZPnGmkMWxBeWleOnvaPtW4k8ojxRIwXwCpNE9Af3PzSMNFHszAJtd+bn7ph4ZYdZHNx306RHvsVT7F1TroqdEZ5dcBOEQbv67MnvFdZNQtRYDj5Mr1fUz0fbaEtlryxZA6CVuvTVp+x82uvuRhXkyvNd/NdzcYU8/DysUdLq7wcEeLzFWPGquqGp+qFJqNuEIHppUoan32BlV891lfX+xQjxV/7VFX8xXjcCCXOxWEEvVfGYr8HvB5yJMp+Hy2QX9LezADW8mNIl2Fy+k2aG7pmCGNbJuCILZgCrEz/9XVPzjTTjPjr28OYyTgavaVulYu9yUwwwFyAPmwsi63js/7C5jHR15y3K6DW8VC1caN6yWSog9m6K+JS4IeQ4I2K/HFEW43H9rgp2poomnDJa2TCLKR6OQMYwn6fnvPO3QNv+6jUEn1wBrHU8Ku40vhvhE9dp6ISz//cXzd8S27nVGo1xo2S3YO2poY7BYRjoYY3w+f63seC7vZP76/PnfVUsJRYmNVdUwaap+9ePvSYeY9q15uRTtHmVchxWAF+hbLApNaI/1vn7xxhq/O2bNju0pd6oMZ6nLd4MLZWnAWRslxGeS5ZrGmnLpVWcTufcy+LX0eJnKNzwp83/gh1mbc6iFuutYRHXD8ERcdatS01p5ZziiWBebx+XJZXnJylCCPpcEiD2aoQ3FJgic96sHul0ImjqyDUV0xS7PWAUEhGgQ2p/7cOWxXpkZY1rqIzEpVk3jJ18Uqc31Fer16vpt7hvzYOXu+35N1+/YPv9+op0VYFfTp1Nhq2Ehc7YzffkKHxoIqdvaPkk+wOYdLjbD0+DoiKG6aWbmnkwOtZPWxL5FKjn4hXowKrsVNSeQkKRW5TwMepWRkGBiU7mAGEzEMLNkLngkUwdy9VrxL5Cd+WAtvKhVzHOEqfssE33D2t45LBM6rI5o1bip3QEececo5RAoMLKdLsb+/gNUq6JlZjx7+hYGx85hJX8hzijiYQaIHfYpLErAJ6v6BuOfyfJ2q6P4J1r1cQiX/+R728PRZfwwiNJCs8Wm96k6VHm9vY5YqPX5Ycf6v230CzfO2RaXWRPID+25rDU7uDVGq9of8ZNPg0D/Vmv4CUeyT0/7njsQbJyGjoA6MHwTyUQyaPrLxbLF9HZs91gNdFS9rOIgKXoVomIJXHx7m2r2io1TAsUa9Pm17e1Sr/+VXn+fklO5gBjdNm78A14Ld0S3N5GrMfe9YXMTH9djxhARkFalPXomyw58Fezfm4GRnu0RKH1mgClirJUWHutxOTlYsC0waViqZZt8nDbiYcr0bjTB1N+7Gag/mxxgcem0NX7LA97F7AzcOgdi0G24YlmPiEejiuv/BbTqSFS22+mtpanKYP1vTJDvysCwHYeZxixumBd4979itX8uJl7BiPU7H+MRfefLO/cBKBgrxwzvNjHx27ZvT7cwFmMP6RTuwhviMQo2wEi7vL2BCpYSSi7i8PC5DKE1q23KRzsfdaAlcrBqdDXxgnogH8OaWGrsXz51URtwkr57HNUQjHGdkChIulyzTyLSo0eDFAJhyRbEEXCwaOjAlnvbDAm6a3wIYjP1knl5OZmI2Fn93/08SRwzVHolYPk8J3o9RaxPUv7rXYv0Ns3A/KU3ba/I5QcCNsK0WufFH/jL2aVHj4EJbM5sxfLPCFvj+EJABUqYd5j+o3HBiUkY0nGDyShmYeKCZ2KUgVGjkqN2scLBcm4vMyCw7NJLwoi1UTdlua24euYNl5z8TrI8Ql282M1Uh1yLSxc46XUAREcb1ubV4cyGrckHZCZjFpR46POvTmB+NMbE+er1cRiT1pgNx1fvv5OaiIdbPcg8eGmne58Bvm0ba9biuvv9qW/AbXMN1k6Sbo106nxSszDTfkpVaiK37UDh79r1uYta62XWTlAavGl8Otux4ocVgJxPtZoWjqRNngdVIoH/ZEfqIBDedkNiQvXIEvXjZQsaWBxOjBFzeck7UsF0sGQb4RrGDknLaibXsBNzJHRvZjDYFYY3qA7CEQpQekQqplAGSeu/gwnw+bxFXd0UMG435vwy9H+wrtliSOPJh7MoFwXh7Lp5rka7HP4bj6bjFL3350us4iGR906+6ekMhfzGvwAuYKSjUArP284qJXNNIwVKdK7o6iMkBacaWYGUVRXxOKmWKfyLLXNq4qqDu4z706WOeD/rDUPPMmr/ljrITsL4Q8wtbM2EiN+W6hPVSzfHD3m349AeYnXVprVai+8CBY9p/KeJJtqxDVVSpEn83Ye3fWP+uY0flKXny3ER0uyTs1IeK8NqjpYXKVhSS+sD4E8t/1sEdjfKxwBQyhaFm45YqKHJ6XQECWXNDpvm2OLlNKI7CinIrLiMVFZJtlQpCkoMK9hZRuCqTqkOrnOJRznI6uND8tIwpOwHbGeNJknb7DWaCLfqyBSN+gHguDHeg7z2sH/d1ehLX0uSat//Bw4d9cLCJ2bBj00cY8cWhA0YZMQv9zsTFWzfOksT9od0tRSRJNao0c1w6CJNnwAet8hEwm5+gEM9AifrPRmNUOJq7sAwojjUpGBnxPLN80hEF1bNEWAb+0KsIuAdQ8qRIAl9dR1VNQXqO5fxq2tC0YJczyk7AG+9pN95gBM5dxW9TwLuPTc+bSc+dw/JlbOP+U9TElpj6wpumYyVNQsZuG5Ly6NdWopQsj6JNyuOVfUcRU3JTpb0zLXwMbK4ZyW3PqNNgCpt8HIAL4W/L8supO/d2rKisq9YIVcDnnww8K2ZD9ggeVJmILOsy8C5/TTc4HvgREbwg5WkBRM+yFTVsy+NEs0UXMK9o3SULxJeN6e2H7UNw+BNc+BRXqqCPJyZ2xraNGH0aUzRnabh5E62fzQnV5yMq5p7IDk6wnuQR8qTJrh7WoQ1CUg5vQIh2qo135OLtrBReadcG8eB8za7mD2sSt7LKO74h9PMRsF7JO2wlE2UlwCuv+1K3PXq+0i7L5IPyxQNxz/ZqqKnKwRO+QREFzINSKc/JkRY/QYgOpvwGdUMMqoVuoTj/DwalWe3dF7B0eswQtTo4OBgDBkBfny0Ilp6B+lxnITnQwalb0qO2MZ+d+yY07vE5s5zQY9IdS1pe4z0wiH+tMfWt8JFolEBF7FLFqIWFTXBkg4631/xNe6bk9JdCohAIkZ2VoVSWh/THpTdOCUqVqoN7szztWhxkliWQlHV/4ybOGu9GDZWrq7oyWigp0T3XbbkcFVykZ+KRovau+zMgKFj4LKg1S9e/x9IqI3CXyhZpwFQIzmOWwDAyKRFpAd7T7VtDZubmhh07sHqtQfc+dURCZKSiXQc04s2XGnpYNLjldVIxo+7XtvJHCXiYGYfTmcvdjYtcLFRBlYVS7jnQyDNqyJplbBTko0fkJZdGli7UE4dcOX/22qX0zDxNP1e2tIqQ+1uqPdA4jjxhSc6aHGlkZitCrEJNYAc+aYZCQg+W7HhZ4mLG0oVALYYlVGQVAimcYEOeMz2eAEeYz1jeKLIFFoiRnZOjscBCtWzvwV1G+ti696B+EZdWyWzTr84PE82+buh7TzWoh9X+DTa/jW01cn2bqyZXBroutfrIYOlXPUd+5nDml7SBjqs/qr3yxhP3nG+WqpJi0gynhzQb2dXwYMD9Z32n1QgPuKjdLgkmTpw4b9487U5JYdWtXyPj4NDAJl3Znjyv1Go21XqGRjnZaWTxaId0m50Qdvb6NWlq+KkrdynnLd3RSKQEJTxdaYuX0t5SFuOOnkgh34nLymRlXbueR0/CR1yqE5qJ9cSmD334lOLZZKBF9O5KkaIJmOQpMTamUjDb5iMlLtbavmpM0J3KttVy1UUbjWTkEKbvGCDVi8vOhIGeQXKMcfSjKokZGTK5PE+YnCzkxSbAyESkDyUvRyJXiY3FokyxNEtlm5uplyM25gkUkHGLi3GUbGdIW1tbe3uuc18JYlSFZ5iggkyTVksNtUptZGHBGXsWa2SEE2NzzCpZJaSnO+tLckp5aRVt8Z4lkkTcN/FEKC6BtUVQBKrQoLgjJYuLjxULpVMhFFi3saZJdWc/bINU88zl0X8mivBYfIEg/mmYjCfIy2P1vWoVLGztkuKC9C1cwxMCJLyijUYSbvG//NXRnMUhPXtj/d6ImSuCllxc/+/nAd1zO204v1K9K3vhroPfTQxxGW23wn/UppPjxapHjgtmV3INtTX5tsHJP47kdPes/WKWxqo+JTmkZsqUKSNHjtTulBRhf+w561zZsM79ZyNe3zWrKx4CAf/xowf6PIWCq6GhDLaSnWFGYoxQJYyUSQ30S3c00tVI5otyWYk+9H0P8N1Rh/uCko2K65xXpvCMmS8gUTuiqZWe87Uz1sw5sTJgD5xbYJNn2VIEAauUClNn1wGDRnRq31yzJJ+CJ+rdva/YyGJw7+7SIi6tshOtLNmaKMJvktXV0Cc0SOhdB9U73Bh274S5W6hcjlmzsHltbmbidccqCtdquaEh2B45IfeBm/xcr7t9Tb/zXRNpXNsI9gIDNLMaEhxNKaNo8MFnsy6UIiocju6wdfzwHrRdoxYUXDr+0Mhkec279uo/aKSDjSGpl7JdQ2uX1o1bOVbxbt+kdmkvraLtJcpDQ4NUxDWubS7lsYHBuMgNA+7pyf6WFax/G5d6j8fyYNGw152UBBcFxVJ7dxZ1KUVr4yg1iuYYqJUg66tdUJPjvZdWSemcPR02wbidjsDuWDUejxX3hve1+Olo8w36eiKRCL/8gqAgtmSRvj6iufZaN0dckf+eZb3P8o8qm51tGrYPsnYZ7DRq0MMqFpVF3OIGRUEF60zr0o6VxP3pDz2cn9z2HszWG5RSjlcKIpbLWKw9L9xQfFH+qFSWxdIqfvFcklOipkM6nqYF+FhWu28FH9wMYyHBxiqVHY3IgVdDmQkpHNEqUz/VFC7suLERe7bbpTvP3jtTNAGXJPW9MpHwN+ovR9VFsF4Oj0Bs8sVPG7NGjVDcrqFZ8osjL48tck9i1rB/P6phuHEto9BfFFUd/eufcpPEVXNr3Q/eRWtnb+STZ8J7UYouLZ7Wjn2wZKTTqM9oW5qBnHwEXKTVqysWQSmcC62Ch10Qdqc8bSPusMcJ7bUCtinTMbf17ZmAA5mrbCyOSjSmsvlT1gWf/eMhSLsodHmj7ARc4HzZ6r9RYxg2/YB0R7yYBtnDAyv/ZBttmiAS4w1uCKorhqTGmp0ZNc/beu5JZSXDR0UzZrHmPU30n00EUYoEBanuO6Vay+tAD7nIzueh65AhKlzDpVWBXeJk5CGHlKBCd+9M8qevtjA1CrahWN7PzYZBIcJmWSojBnNVKjvuUblMz+Wueke3eFxBd/KrqYghZNNHl0vKTsBSBewL1M90GFWCyTe49gvU4/CkPeY7osW4r9CkHfvWX1Tby6DRSflf10N2NJ6yMVYRY7Nnf/ZbEv2r2JpEPDBKr/uzdrcUiTe+FRCe8d1Op5k/4y6O5qNFL6tCBSyAfzEXPS1TbnOj5L3ZJN2x2eI08wRTOLHeHKlk+pToW0bzP1avxKrVSKi779TAWGWT+dGXOj3COvSrywkYeFCmkw0UTNkJmDLjaS21228gQ/YKdKCHU7OlgzzbYco3uPgz1Hpn15jYY9PvF3Y8WZie97h5e4QhPMbH3Xvkp+j/rlUgfBOxQOiJ+ZbyfQdL35bxYqW1lY5Ry0I+HYMI+OcTAW8ZbMQrwrxF5ZAbUVyq48OFF4eL8vs+Vo6hbPKaxefZtwMLnMT7wzKxKcs+8lLhL/XCsEoeCSnhtXORhjpOXGaah9yybqMugLIT8JVIfNlWu50fITh9Esuo/KFk4ceGWhM9MHpQbPyGg2xPIsKlUxgyfK+zQcfEtB+Mzns7DBlhjzfWX3gDs0wjpdgTKxur66SUvhTojmEihxMGdaVplLffyMeFrlX4Yqt83C+n1uCd2KdZ/0mJHjUDsVPo39+h9c/uGIb9d7lx3yo0KYv5RoZwS14cZMWwTNz2NkAG6yUIuDuwHPNE+XV5yk7A/pQKhdjQW7ubH8cxMQh3nnf4o6SfQ4VhWGccWznlF+3B6Rvv1TnpnXzA56f6W6L9PrKs+5aZE+rAJ0VYf2Jwoqf/zxbpg8SslqK0CX+wzQcGR483yLa9mE83KB/rtwi4xFesL03YdAWUJyswrX0i7kfcbZVXLciNcuZHMsSQcZbjEKugL1U+rw99bn6YaQcbYaZtryVnN026j18x2psTiJDLdMopZSfgR1TmkWFkSwzhZvQugNWo99qAA9LwIHy5cJbkFJtYlmE2ZJylusbsZl1sspY+uMOWyRDD20jv9VdzA2o69ks3tm/7DaqvO7Gw1/XYmIMCZWmPZ+CDLxTXEpr6XVvhIDBBNHJerI2kwc3iLQJ+nKDdrKAcf8DMmq01xVMq4vKy4OYeYo3amH2K6xFtjVql2540hzxBbk2mQEV9TLZqe1XwtHcMrmFEQ66LmBp/l+7U2UWh7AT8kFIhmZ8MbB1eSG0W8S/GmWk3tZAp9sbgj/prd0f0hz8WS1L07cKudq/qTkfMzZTyid+YmTq6oj1g7NhNaACb1EoD/ax9WleW+9478eli9NqCzi6+NvWqlnIgqKBqO8I+1rBd22H7e/YgRy2V99oDVNbMtlsQAi7oKjKHNJMtqzGj+WV8Jzz2Z277Ma3wB1b5c/lzHnb0055ZCgyqzhZegD5G7bBCDcPKx+QJCMnhCinNa7OIiElkCa68Uqy0y+NBwHWM0/SHL9rSKlJufWf6McVZ9Hfag/lxAyuPYOHLjbyUK9ZCz+xU1s2DqFGbXqOewu+p0rXn2dxaRp07qLqOtj/aPs10QH2reAgcoo4MzOnysauwTo8qPz9Q1eh76uL4xwEGZh41m3WwS3SHoBC1lDw8ARQXjbJPRHz+IzJT8AR7hS/PJeJswlWHFpJkpAgsxkya3HIq9BFz9+RiMB8v/sPCFhOjtCLDt62zEB12r7XQIlUChYCi8ct9bNlRz8poXlrzfm3ty7KMqGgcDG+PDeqeowKX/O2Lb/FzUxbUFDW/lPpia0Xh/QUsMcS5I38+Dsu+eXat/910Pb2iL63CLAlFJP2ED/V8VClwuuNTmHIJ658XVxVANfSijVmz2C7lAbXxg6vNwwe2VpXdr2XFmtlaxSS07rpPvGq38nPvdj8OG3C1yuk9uT6X+Lv2R/v7bUbLIJxYoHx6Vx0Zr2hgPaJU54iz4TmEGLuJvUOUmXoUWq/7z8YkrEIyQTZWRrv5XhjoYdO6xXIelq1eIZFAKpWX9tIqGjZfZUZY3xytKt3Ez8Lbk72+/b4rDuKve5CmsbnUL43WnvlBWdIJfEpWEgzYbI4qlkapPi0VyK2XighMJ9+NLIUSq8uv/0y8p4Ap177v66sWGeVkxKn55ipTkm7Rl1bZ9ZBzpQgly4+DphSygPUBfBqNUM38K2SeyCAbotL9++yXl7d53qv3TfaxTo6C+w7yyZU9jTP/SGixYt3Q0UpR73P2F1acOFLZ3m5cxumqDwx+jDe4INLHMUy4hGPxcc0tbH83Xv+ah/5hyTOJDrs5R2wc1KJuy9Y92fOzmdOe05Vc+kJaLITY9/6rBwn1cOXiSSNj06z0nISIh2l5MJDolepghufMvcjNMirFzK4B2BF3Yqh9o9uOPHsxjNF/G/eVCH920578gaCC28R2LLRvPsa1xE44WHfe0Ms/TLyIL9HQkvWUJ+uyg60TUJ55TwErFfCu27hFy0G1q7vVbtLVx9VLoSzi0irErRjOAmsgO5yHpX0QPpEbV50Pv8MtFHc1lU6UN1YGa4WaMdFgxrd1bd0Sa6u/jLry8OHlkObGmT0nbr2Iea1Wz2n/yN8vzzpFerbZoO9PPV4anP1IkY28XBw9jp3o3uyUXaJB/yxbNfRKr+kiNYX9DfesE+Q6Ieg6e/9kvDRSvF1lLjsrCAEXaO+JQo6GLTt26znC1Egyb95f+mrNEg1l0cIZkIT4WBbpbWvCgXcTK679NrzBwkFdcRSHQxEazQLhi7boXQJrqRZI9LdcA6UEPdZao56j6325SXzO04/jcJ1bapz8ZxFmca3T5Zj3d6EpNQjFIqh5IrGksDqXQjj52oSdJP4cOFsgbAZODOMmnHmd1aj7BBcNuTReDVR6QRZyxG4nRMm9Eg0X3fPPjFL/sWntrmVLkK0ODhD/5ZvXesJgpVyBXxfA+6XE0KUTcnNVq032R+aEJNiE8Hs3pMKg5qsPjZPBz1betRvHmorViwZ1oxcRx+ClbJ71yC1EwEL866/dfC/kMojY/Cm8PGlZ9wdZcJmztLk4OdYff8uvzzIykan0b9TBGLgt41JmDvaNgXk+yaAEuD+W6ZPcuC82I17dE4cthk6IX7z9NEaguxPrfE+pMS2RZTTlm/cXMEOTAoqTDh6/OekuJd9MdPRC2hxc/ARNnLSHn7EBrW5hL8WqF1cMNjDC5jnt9EOzT0VervVqR9qgR6H1DQKmbTum3X8VfX388Ln/V9c+d8vx4UV87G5TKo50B9Mqngsqp3mnRuTG+8l8z3nUxEdkBbXfGopgWUhHaD4rH+YUdwxReenHtdSXs3IqeHugpvFJDN818bu+W79tjFXs23pLmW1ENlKmoXKx1oLKh0ujUNOVhefhW1h1tyt2Wnb+OjUz746/TTxuYetQbvlaQ/TfrT2/HFM8ARcfthzOq7U4WiiZZqOFO65OQOpUTG2uPcyxA30PYLojRK74atDHGPDzaXteyPlTmDgJtWqhQQPUb4C6DVCviTrL4Py2HfhnI1ZxqeI1Bo9SH4C/Yfsbyuu7AxXJhdYelRCn0q0EbpI4lzqN90/77MmZgEBHmKmeF3rZiLZCze/ed528vmIwfA/TCUX0uS+jcCUtxzjqbt+w9uYfk4ruJGDKXu5bHkK+K8mRho/GobknC+e0NPTY5obOYqQbfr5T/nvgASqUTWkCE8oveIiN5aZ0L++UtYB/u/qGBX4ZTsZmBvi1B9SLsa7n82WBLmLuQnT+BCvWrbUZPFW+ZL9/m45YthR+frh1C7dv4fGtyhm+gxNOD/p4kOcnI/HFF6zJxNAQ48YhhSuFEj7uSMTJlhJb0bDGVBJ14X/YRZzF0K/R4Pu7D7z+vP/r+n/wybiMA9vrG7PE8izjGEguRCEGVg8LC1sIruKx+T6ehrMAsLDCCJ8zGOE359deba2zHda1xR9YeBV/n+XssBJ3f8CIFxOwvCcSIWQzUI0rpGRkodJ8MYxbYnnn+fNuj5h+CXPZOfO7cn6BBPVXc78p75S1gBNzkJf+tscglzKXlXZHNUHEdDwZhxpMacE4MRem8t9uRy4ZXPtZby53dB2CQz9B/RNCxmDbGGxfgCdTkdoYX9O3OTlYuRKWlpjLRRYhMo6MP9CrRpKid8fPbGoZVkIj7RcljT59evTVt19rnOflwy0W7WKP1uhHBjcNz2bn60XF9IKqlEjkMtwvp8PK35+BO7mScA7++UTlIb6IgWd/XNpu0joTGHel0tLnh7H4BGeH0/DPMGxghab3pEdV5MyEHt2LrGsyTH81UliNQ4bpFx5X9lXnZzS9jeUIncAlRSH23+LWx6gAlLWAiVW3CvCi3ySPxbSnLfy+ZzI2l8iQsRqOx05JFkP9G9TzoB6DIz7oTomdctEc7kPSN4BZXyybyK3WrGH6dNThJmMaPiPV1zTytjwkMk4SV6ltope5DdiUNyWOoWudjFBbnrJyBtjI0o0b2cHaGEQF0gg8s6s2hRSAhdjjp938L3EvDqfovUQsrp7+GIO7Ebh2bt7osXs/MdPXa4gf8f0pzNgPkKeSjZFNIJ2On9tof/uOeFdCwHgcZFMosBtFJcL+NwnMeuOe0SyRbZ6F+vqyfeiKdd3h6shloPr46F/u5ApAORDwTkrQ7yhgDRTE2UzGKXPxC4vLe/jjO/Du4gTlrqRb8kFfq6YhTWQDVnCa+9I39+6hXz8s/T55SN2gb05HW3U/5upzwCbJ0cIxEJaVtCeVHMlhd9X+K6ON0zJ5zFvYvoMdtIULWeBccD59P/KfC6nNF2Fnseqfyy8dN0NF8Ua5rh4ef+WLuYrkzvtnTnOdObSpaceu2II5l1BjtjZWxSLM7Mzy6rnt4FNoNOkLMawmQr7Gwx9Q1YZLGoZYcQ5OS+zR6FPEW35aV5qpF7E+aRuqoL8HRrXlMnxjdOYmjqgglAMBX41EFqXgoj4JyTgDM7oiaAK3qBzFc+c/0FIGKTcDSj5ohD0VaULmzzL27MHx45i/5mnni/ul8xb4H64y0uDM40o9jAbzYF5iw5SMzB1gpsmhpNZ+uWkjEtMe2wj1qZjlKeTqrDLAzcg3pm7BBWB6ITmX0/1HcV7CFTLk8HLFyq4H0TPcv1bGjqnVV7c2Nk0YicfwTwVvFjZd1xaJ6cwf28P/W6hnY/8gnB6OblXZBM6tXfF3DxwYjOhJyP0Fm4aishWXe4uQkAHv2Rh/rA6+7I2jwi8qeXqp05fE/wW+0kGMnWNY2wf5astP4cSz2ZsqAuVAwMSvmn4570E2qlhDvkAzfiUcl+ZAsglDKJLp8+a7kehNYPotXvSF6NKF/e3UAnE1+pgnV9mT18+m/pmsFQlIzTEAZdvFRWzlJDVpjzStMi2jqjgl/fnb8JFduoLK2/SEIZoVrokOhfTBEuHva9rN/yTRmRjwD4scitAv22F0nWMYEHjf58KEJZ+fmZTYYMBkqFmz/4h9kHyPvfe5MynwKLjU6FUD7TxxeDROfI5zX+KzJuhZHfbmnM7pY4jEDHRcCZtFeJw2DqnugibNT1ry0lz9vo9aRfaW0l34FM4+6+FpJCbk3+hYbimWgIV6bOk2zV+CrR3z7oMZXmZeYQsFvw2KxRzc+wGTm2n2/bF9MnjH8LMMeW9aYxmby9Z8MNj6JhrOnWN/h3wMSUpOi+7BaWu0iqrbwMe6VjF7aNnYyFqo5bZG7mwtAnEDm6e8R7LwhpuEqTbuVSQwF7Aly9exEzu7cyboNd//OSJMPaXdLDaa1XBEXIZJ0cXnl1IPlrew6yFWn+FmkMvEmhGY0vQEhj1NSF5V/1ydfg9clxk2xIxPEWQhdUffHeBNxOjtuB7OQoal4ZeLYOTW0K6Amdyl5+H9E6wX8U6Ft8CcH6EW9OjffMOwXV/3yt1+bhVp15QP6a8Q0PkU8nJ4Ltdeo+Lw/gLWl+DG2UPJCvhdOxufnUfqDQvLU6sLKcUVyqUnRSwJvwyFfioW9MKq7toDwHn8NAf6ezGR4pOU8bKMKbOtjx4N8ZVmd+9e9lc/20zRMOMsWhvVZx286AcZ7h7S+t42eM+hDk3rNTD5tFeWa/jQngtamTZvYY68Dqsi7Ucbffmdqnq6oyK4lYjVqQZoshI2mVtB/rMAoRFIpacuAQwMcHj/bj0jHN27hy+CXK6Kiiw3rZ1jDyMwiouuNMzvR6Xc65h7CwvSpqSlXe3fcUdtaY9WHbB3OO5XRW+su4fGa8CbimpzMPAf9N2g/fTbgF5/gfcjM7mTTlR6bNsef36KOBvHROGvvEadQiI+e5jz+KNVsISTIessxAwAJVpDrvtXxeM9BSwQ4t61K8Yu1pkBiYHBgXFxT/l8WFiKXzRpFhVW71e0eWHfIAeft8Hmj7R7HL5YNg2801hAVuZlp5qKOwOxwhLktbJV1Ahv96qW/k/Dg4OaOR52bPWn+STnjO16PZKd47uPp7i2A9fy865093LEtdsx3Q9sd7bwslylludJLw36pfvFPxp1Wpj997y4LMXu+7xMmSyVFYApyQKjNGPH88UQA0umSxD5SuePH3R2skuNl2cHhGSpIRTwzczfModJqVL1D/iRXaW4ysCPnfHgyxAcXwGzqzt7HR5409Izut+FmuqBzWrzB1LxdxAueaCv65MG2PkIex9rP3semx1UOqF1V2z+GrltccSm+faqf9u2WfL7rd++ujLuwdq8HicwEl/VRwSpV1MxYgTrmQgt1jCvsuI9BaxUoHbTZmkhUTJrhYuds6mxnUoFIybA9xVwci78HnP+T3HIxNBmOPL6nCynMXU6eAcxORdZlDQ0j5gNfEP2D0jkJqgJC06+b+KuF3nW12pS7oVNTbfVCftsxbY2a2vHrLB1h9qmrmjwQno6Q4GxtZW2MwmPCzxtoUHAXFIrE0Mr8AyEqU8MNprVMz7baWjY+cgLDXlKPb+JD8MTL9cTpHyXdrfbIe/UKi7qSuh4FOPZb1n/DXIF8/WfBUiJx82SWYhcIUebzj0DQ8IhkKndTcRK9gqGhoXNplAG1PoLvoGcL52N6g5Q/4p+nofR5zRGSBfHHmpzvL5tw7p/DrZYzzMa9nEbb7eWWDQKN4fjbn/cHYi7tP0xLtQxaufV4YBigaTxFo9mnWPD/5hxb0BcbpLTShimm4SwNsgVA4F0FrwUqTUWIJGSQ4WEp37nrrH7D93yrFZfqdTuEnp6bJp/ngAqBRvXYmMLG3P+u1/wdVzNEDqDs47FxADnHqIt19L6Bp3wWxNMIrXlcS57AkJ/h1tQGB7vtP16fx8jm54P4lfXsk3MCNNT3XGti4+DBn6rum8aFZnmbp4X3KNfR7vA8Md+voE9PW/5RzoczYlGJSsY2dYOjRALWtZw1GsaHvlv1VoJ1k8ePgjp51LFdfaE+T37vwiQwS08Tz7Vv+yb3LxG4tfZ0lmazCRwAtwrcTUub2KEtitw7llPj6JzyTfRyspK8VLtGJV+SckUd3l5bD6G9PSMJvXLelGiN1nRFV+1Y713GIa48xSt/qY9S3g3xM/kEKVZ7q/d/1Cy7VXv2micZflvcrKPJyKiUEOMxFzoOeDCNrPcwK5Gt8Zlq8xv4Ken4BytGS3wS08u8ilE9JGdAdNfUS5WTn7B5MmTFyxYoN0pFIVCUSwBv0ZxBUxcGoXmVQp2Jt8dA/x7A4ML9DwH42AT9MjgDN9JbBANGmVdff6J87tiz1SqoY6XfSyx3G/Xbfaef9ZB+vAP917pegkpMZZXE6yv71uv36zRDwg9iIQXQ4icJY4RbWybHK2VdXKdwfhOioCGEnj72U+d3sni+/V36QRfX9ZvhE2CIQWvXZWv6wTfX7kmi3X6XM0GXaX9yjzGfBAgLBmVi1U2e1PAL1N+BUx8UR9/9ueURumBMlsRDtzG4H9Z1xw2Fm2AK3pboaYJPFMNdhrwDCllUjlOwc8TZdXJg74C0eE4fg3zVJrkNLQ6Ng/mXDz6PeWbpjh7F+3yz+XLloosYEsDJP3yLN8tJsZYehKTTmj33kAMk5E454G6tL0Ri4YumPxRf3hUxuzv3K74Wx0/fkNzWnoGBnc2O3ZN8QX8H+Ok/owxT29dDjn2yuAKwr6Zd2OLWhcehjUImXLGvPeiWajtKm7VK2/iRCx7JsDu3fDDClz4GYd2jqqa8+lGcNXm63vhk0Zc7fibGKHOYtZXqRhUYAFruD8WNd25LhYqLr/Vw/Wn+NMX+x88z/QE7PiLshuPLTT8LBHWt8ZnjTCGgpoKPCRdOs7V9jf7k1sqsTxSkQVMHP0YXahMWPTl0vLBEGsuYcyLFqM38UKvsdhPT3wQa+KbjmnfkNlJ20ro2hVeLy0S8PgpvD3xCZ7Ef1HzROQo5eF/uMrsF+jDXDzCs8O1SQY1R2zcxdkIoEULXH61gUyC+oNFC2vK2kyGsUyTT1EZj73sm4EmxONYeK/U7r0vFV7ARNvKOPMJJzwKc5IxWVFSrBxyKbY9oFTM+qiFp0PIaThHju+aMaPbzxu2RhDQq5HDrKmsIjNugNVnMfYQd91ySgUXMKGmp6eoKvZ1GCYYuK7wPkwmcBwN38pwuI7rW15ajYm4ehVNni0VkJgMd8chHu5X9dXmVx4yx/hl3KugY12P67v6bnw834ebOWD2bMycyTYsUbU+xtbAYCPYmIJHYl2IqskIZN/19MSB0VyF2puYgf9N8cPgvyBgDWPr46/uXFOFpgRLkGI1tZ709+XqWI1cKaWS2mlDwAmej5P30WM7ZAWn4PJBkQT8nrXQH5Zxe7hKyBIhAzs+wRcNtHv5kYGoJXC8gB0N0WgO1FXRVfsF0LQp1q7VbleyhLuzb2KGgN/WxuaNBq+QdLt1pxo+Fs7XSO7CRY16eSNwdjoCWmOiKWyF4FG2tAjVtOol9g3i/Lo3kWDx0ZLJwf4zrLoF3k/ovAq773O2lAwyyZIkSoKkMCR35vmH5E0HSdV0jhEiU/HVbggmo9OW8q/eolIuBbzyBhK4dRtKhmz8OQSeb2nt3I1BazHUEPgCRz7Bhecz7Hz2GUJDNZuo7WzjrXR8dMBSkfVGD610c9d6gZ30J2dwrYk9+pD77rEQKk+0SedMBhkLCut5cEzCs2n+O1bhZk6jJPgafKhz8P1J7Z6OlzkRhP47oTcdTVfg2wPwj0FIEnLJrSEnggKTPgZ4moDYNCw8i892wHQa62j9502o/pvZYbkUMFGNyn6Ufb6omSgGFHMZeDIZDRy0BwrAD1vXoB/pqSpazoOiNX7SHHdz0/wf0bc9g5ve8knSM0Muz+TZUVYjamvoU1MRnLiv9l3/KKeTJ5GZjKl4SrrVFOXFLBfJnAXjTLzUorutL1c38yaGqJPfBCI6nqNQ4VokllxDjT9R5XcYzIXNdFjNQKUZMJvJekTa/4Ypp7D2DltD7z9NeRVwSi66ruYKPCUCaViKG9pxS4XwCHuWow0ZXypFdcGseVA7oSkd96mOjDQ8yktwefhD4lS3YFPXPu2ybaqxeQVcmjcVTPis3r3InC++0ov0+qxrVKeB+BwBdBGNu0aFgTDc+xUmck2tlYYBPmwNkXzMrxHG/Vuxly8rExKykZyDpBykl0yf04pCeRUwcSwQy09zdrhEIKnkQT4bFm+5YBjOr0MvyjmoXEVlqQm40gm/PXqIG9dhN8z7dMCfKRufdOz6YM++FJ/6rNumMDjGmGebNvBG7B9LYeUelqEWpDXyQFWN7SXH7ho2rwY3e8DLbKTfvml+RTh4CyvZ8k46dLwLxRKwSMyWU9H8JYq2tMq7wMZ20QW1xdFiQxpWI+pb7V7BBODgOayh8jD9IJvKqpjUHes6dMb1VYsXDmtoGqwfenBUl48c/WLTUQnNHR1uRYTqnV04s2fmztkTP5+AjzBX47eZsfn3Ju7DcG7vJWa3hb7JG+aX4kKCfju1ex8MfW4ckr4+C1mKrjJYWkVHyfH+AjYwxLGdvwdE5Z7YtdkvMEhPWPSlVd4FvamcK1pSnoICEgnUc7R7BXMIY8LwSMRtZwJtMao+5n40FN9vOPjj2q3W6shjOer002GtTFptT3vSYv+lPt0O/fxnRqvGqpN7UBPtyHQbA/9glC/e6EflYobpXd8wv6QmPVj+CHlJB+CrGBti+fZ/LEyxfvXMDBVkeWW0tIqOEuI9hcFGI/n6ii1spRlJsSGPFWrWLlfkpVXeBYWam66hpArDBNeEKJvBbRfGSvg8zzlIwx/hx/1bRTHxqhGf5l3OPjIxvl31lhYXmjdqnFEt26JmhNFZOm07M5/uVOilzxmsvIcN3K9f5cjHr3UC4TBmfYOo5P8hEQpx6cJlr2p1sjJUuSqBmT7E+mW0tIqOEuI99aZUwKdu47q1OntVtftozJTanl5yRdGXVnlHIjMwYiMbh19iKNjshMpZbKmvQlmCKpr2aHorCqmu2NyNGyxM1PhhnejigJaVroid3E0MfIQ5zM+f9QuqoDYVsk9gwVGM05z5CpObwcdVm4m8wBSzDpRCzz6FAg2aNG/qWUMql3ftOFIhZ9FVNkur6Cgh3t9gyuUwNDUV8IQGhqaqD50GNt3HsPVclVBJoQBfhKhJhWs4FSHXsZMrM7K23FYYcO8KTnMLi5uJkOi69+bNALNg3inX7TtP+9DB9BzUxfBkbgAjO+k1GjtiQb83+l2Z4Ic9pbaGJcWagM/nC8UOzi48dblZpUHH+1Isj1cT/aWUCLbcx/fkoZagLy2HuTGyf2LTjhbMLgykMNJUzZGRNYN3V27a2Y2b0UBslHvf447aocGltHiPuMPLGxqZwQc9lsObO/1VBHxc++qNUUfGWHYS84szo9B7ovqvdUn6P6VYAi5tFl/DqK3chGYlVddNnoMSD6ei70sDF95gEwZqHGk6ux4+luciNRX6t/89Igt08P5o75k5ByKiNjSpsT3nbr3kz25hQxLyWwE0ehJXG/dybmeCnw5i4nHtng4dRadCCZjYcBd9/ubscEk9uYpVUe3+DHPYYqX58hA7oxFKrjadqs8VxYMCcEi5I6tKnVOLJ8ck4uCx7JGzz5gk2zbM/PswRml+9QqKWbChHz4vaVAGZIIJ/+Lncr36u47yT0UTMLHvCZsDhfWULsEGzAxM64zH+VU7cfwOd9Ic50sz41/dTWTUSPyjMPF+NLp0xtjPYcHrUnlRxJ+orDn/FaikzSbc4YaVM8gTl6DDCizXDjnWoeO9qYACJvwTYDQLcWkl10+LyIGXPaua7uKhPfASaqiWoz450lXRl8IsNl3G36P+Ye++wYNQB19MQfJcHL2GjS9WOdLgagb1z3CwfGl4sxg5UjjPwekQ7QEdOopBxRQwkS2H3WLsu8f1mCipIrEMfAGOfoFrn2oPvEQsbu/AFBtU+uJrzFvWbsKIu/8uRQ/lhWH40x4Wx7F2P0ZqT9XwaR2ETuFCWGN76SGNcDMEhnNZw5gOHSVBhRWwhj7/ouFvnB3WdJoqPlTOzUDjKmz1neUvBgZruIKF/+Iz6fbLRvJrQYKQwF/vtmGLuWAPZh6EZu0sDisDPB2PtUM4w6up7SVv3wC91qDhGm5Xh46SoYILmLgZA8k0XA7iTHFJ9Zom4ckxriXU87G5Dxy188gSd7H237iPbq/5JWv9qdis9JNY9jPMLmK29ut2brjzORJ/gocN196r6QBihMAEmM/gVjPXoaMkKZaA+XzmFz5fWoXrRllS3mxRkCrQYj16rkZ8OhtMWzK5EmlPyj5D6yNyJrKn4eBgtHShYm0uEi/ju51osxmtj2NiroucHT80BFk/4vSXqOPE9XNWcI9hgLQcfLaNzVeeVl6GuWlGnmgWWGFLq2imt9ZRMXn/yKMUEBkZKOfD99zBuKxsAR9xsZTqS6dXR34cegrbxfhmD1JJPyTjkisYIwsGYvSojgvjEDoV6l/Yonjazy8Im8mOd/eBIXnymvlc6NYGyJPhpyMwn8+GlZcbxGI8CHpiYIDjxw8JRKxzZULCi6XedFQ43lPAAgEC/O6ERIdn5KGaT42szFTKy4XlYVza776wmI8x/2qnICzJoYhyzismQ0qZFO1qPhpDTcfpW9ql8OSWRvxuH/TnlLdmXoEQfnduPYoIlyikDx7cTMpl3cOE5EHpqLC8p4CVSlT2rOPl7qOUJh87vMNIbKpSw8qKTE9ZuNBvsuY2W97qk20IT+assbg4vsYbkGhf/hB0cXJJDZGYycb/8ibjt/K4GqhSAS/vetXdveIyFa6V7Iyp7MOHhUXJr2auo9QoRrLm8Wys7GxMLT/+bKqtpbFKpZk2TJOgywf/3IPrMtRYhGUXEEPFY7KN5OWWoJ9Al6ILSpCSxdbvbbAU1nQvX+2X5RI1j+ft5CLSNxow6gs9LspU772gpI5yQLHsEhOtCnlS9rf84p/A+hs7/AaHOZh2BHciud7UZJY1Yi6Sj00na0RLzrkF7kZi7kl4LIDlQnx+CLcqRmFSqWLjTyjWylNeq+M9KUHHstwTk4l5l1BvNXiT0Hw5Pt+FhzG4RXomB5sEyZVdC/sY4nYknsRh/F50+Ru8Cai7GtPPIihFe30dOkqdcrkyQykjErB2sDwFOnvA2eSVteroeGoudj2CvpA1ueQ+789cYfjvrMzwf0PFX5mhlJEpWUsyyfZYIFbfZq0+zz9/32bqJeiECqheHf95dALWoaMCoxOwDh0VGJ2AdeiowOgErENHBUYnYB06KjDFErCIG4ckMXy2tIoQFa8N6f8PsT5rEdOXsF6vfD5KfjENHcVDLn8+f8vbef92YIkBDh3+t2nHQetn9Ojwxe7q9uLQsJBfZo41MTXn8wvr3sTj8bIy042MTQu/NSWvPFken8fT0xMV/ojvesF3O41QKZUyWZ5EYlj44Kp3v29Odpa+RMJ7h4F7OdmZhkYmJfIidFpMdNiiJdsdnZyftwMbGGDbX0u7fzJx++9z+n49XSyT37x5ce3qXy3YUomFQZrPzirBZ4MsL49O1hOJCj2RUaJhAopZ2hCJxIXf990DuWTfNzdX2qN720kTC5ye7WUUCsV7ClggxMNbl9RmVuaVKmeHPMkV5NWu2Yiy89jYhKqe1oXP9S8QIPBpokfVSoX0CSHoaknJaj0Bz8SMrIT2YL684wXf8TQKa6kUaWlSOzv9wo3Tu76IABERGXa2JmwVsUICm3IsNcLDUtyqWJTIi5BD9NA/Kj092dunlkbAQj3cvnY+JCi+z9BeJ7duqd57tLMhBXJKJWsLQ4O3zO9NmU9YyLs9W1Cih/vbApmP1GQ1T8Aze1vkEu8YJkFBie7vct8U9vet92UXfJro/i6J6p3fVyDkmZi+5b4snIMeN2tS2DzHz3l/AROUPmQypVwhzUhJtLR35avYsne5eTA1RUa69px8EeixeWb4lJqVkBf82pTu9QTsBJEQ0kJXadbXR14ejIyQlVmYQPRELOzoBAFlhwV3ytDT45IyHzwV5AXnRBTQ+npsaXh6axJ8IZDLqqDTDCDNfqWX12uweRGejUgs5PEIdsc85gNLC11KSSJBaGhEelqKT/Xazy2wWAR/fz8nV+/U1HhneweFmo3rVshZbFIYFoJYzE4wNn5LIFO08lkQvyX0KHIpWuk16XlyCw09ilyZjEUKGc5C7kuhIZNCRClBWlhORNchFCqIuK53BUGRSw+WJ4NY7y1pTySmB1OL9Xnk9haS3dP7UnrnsTIme52CIONBqSUtMaR+vRfLxxdCsXpiUZogV1lfZGjDqdfYEH/t2GpbCX07djMquGceBXHQpaMhCdm3Tx+/8jCAJJovlA5SQx5tO3IwJTFg6479lHoKwsgAa/9eRPnA6E+HqMUFjmakcPE9c+ym34PIB1dPXr5Bpfd8oQi+eH7HXb+I+2ePXPS7o0ehnh8UwTkxIX9t36yvTP973WZKZAVB9921bl5iHmZ8MyI2T015R76Qev2uXjrve+2p74VjNy4X9HiEvgirdm43EsnWLV3Jl2gPvgnJ8si+PVkKgWaylOdQovSqVlMiFjrYMfWqsiO3rN+dmPR4+45DhQSyoRG2bt5qbo5PRg7mcYXnfBGKEet3yT84zv/SuQt3/QoMPQFyooLX79kpzYlbuWl7IaFHmfLmDb+mZmHfnq3pqgLvS+rdsHRGDg9r/1yYKWcyyBeKXN/zOy/fCZFFBO68eU9ccORmxUWu2bxZnRa2ZsdmzWqs+UKBfHDnIn1j3sF/FsYmK7gZafKB1JsYePVUSOrRf+eduHCnoMhlbnZ27MZVm/SonPPOvL+ANVBmRxkP5d+XLlxx96qRGp3Qe9Dnqbn5hzX5G4/v+ho5VVPLsjP5yQ7WztwIxHzgyXMvXL1hbWOVlpoSERxNP8wXSveXz592cHJLioto37BxRJL6tfSqgUI2MvBuUq6hUJUjEAl4udxUQPlBGaTExJqXlyA0tOGrC7SDFNY5mdJKdrY5slwjtbgQn4gCx87FISE0rlHDDmkJkZQ48odK23qGxvoIj4nISM0oKAkSdEEXNw8qVBuZWQsLNjVKFdzdvGS55Au9fi3yoeg1mbmQZV+97Wdu7ZCRnlXJwqwgw0WRe/niJS+vGulp6e0bNAxP1M6g9BqUTMOf3FSZuespszOQYmvtUpBFEkF56ux5W0eHnPQEWQoJTnv8Nbj7XqXIzUxNCHnsm56tLEghKrXa2doxIiHHztZOmqUoKPDoBfVNKolk6Q+D7mYmJxUUFxT42XkyWxvrlKhsuSK7kLigQK5S1TMnG7lyK6tKwoJ8Y5USDs5V1bIsQ7e6JjK5uuALqhUws7BR5hVh0tISG8xA2Vt2rpwul5QQ4+jsWtBpVA5UyVU5cnlydKhRJSdzY8P8789jQwwiYxMsjY0ypUpLCzbeOF/IbkSGhVvaOsTFx7k4OLIVEvOD7pudniyDAXIzeAZmJob512FQbGWlxauFEvJ6eRJzI5GgoNCh9w2PiLEyN0tJTbd3sCvo8SjNxUREWjvZJsbHW9s6kmOZPzzIczOzZSqVWmlgYCYR8QuKFor9PIVSJU0OjSLf2KuwZeXUCAvzp2LO8zLwa9DLqmRZQVHxVRxsEtOldjZWBb0FvWxujlwNRXxysqujY75XI0jDJKbcvLzE2EgDMxsrM5OCMmgya2ER8ZXMjJIy0u1s7AuUuhhRYeHm1rb6+mLy8wtK+SyDjo5ysLGPj422d3EqqAqGKTMtQckXmVqYyfJUenzm7OcLOYbhMXFWliZJydlOdpVIqAWhVOQpVbyIkAfOVeuJCraGFNK5uVK5LJOvb26kX0A9Fg8KaVpIVJqDVWajhjW0BwulWGXgN6HwpWtRaBYUH8+hoNScVvjN6Rw6gaWzQi+ouZSAz3LEQqDrcP/jzF3B99WeRrxtgq8iPZ7mb2FQmHB/6ZqFBwt7QLayPivFFAKdEB0dmZ6W/HIZ+HXoOly4kVF9y+NxvDWQCU3kkjkqSL0aWICo335fzaUKjwjiHQNZE7ks1ri0WgjsvtzjvfV9CTIPb12k9Xm6KixyeaxFNis9tH7d/Jb4eINilYHfRPNg75IO6B00jlzh0KXonLdeUHPCWwOaLsU+b8s19MSs4kSTCgunSI/31tMo+Nj8GG97PIK+p3MKVy/BXvYdrsVy5Hd4Cw3vkprpnnTNwtVLsDu+W+i97UoMMunki1GsPc9+84ULE26D2y0ETUS8y/sS77LEsubWmrsXiCZa33LSK5SkgP8DiPRxfPvGdWuXkB8Yk5hKBkdH+cdAgqV/TDhw5GJSdISywPqN/ya6FPoKlIXn5ebk5YpOHVr1z7bfC6kg1VF+YI0CuWlCoWrtHz8cOelLJef/H3QCfgWVEma2Xh2b1RCbOTeq176Qlkwd5Qe5DHVbDzIR5NSo3by6T7W3Fi7+S5RkJdZ/A9bfQ81qa+hvIW3u5R8qw0dHR2Skv9KR478Ka1ylArCA9Zmp6ElUmlUqHTn+q1B2rpCzXkcVWr3/b8jkLL7yciu8eouKTsA6dFRgiuRC3/GuUfddasx1lAcEAkRGxqSnJdeoVYN8Ch0VAx6yi9IOXAQB79x1DDx9krx2X0f5hs/jZ2dnKhQyU1NL3fILFQWlUuXiZNm0SR3tfqEUTcA6dOgoV+gqsXToqNjoBKxDRwVGJ2AdOiowOgHr0FGB0QlYh44KjE7AOnRUYHQC1qGjAqMTsA4dFRbgf3LV04gjj1saAAAAAElFTkSuQmCC";
