var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./Fibonacci2D/FibonacciSpiralWCthumb.png"]="data:image/png;base64,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";
