var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./e_Taylor_expansion/TaylorWCthumb.png"]="data:image/png;base64,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";
