var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./e_Geometric_series/xnGeoSeriesWCthumb.png"]="data:image/png;base64,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";
