var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./e_Fourier_1/Fourier1WCthumb.png"]="data:image/png;base64,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";
