var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./e_Archimedes_PI/ArchimedesWCthumb.png"]="data:image/png;base64,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";
__base64Images["./e_Archimedes_PI/Screen Shot 2018-05-03 at 4.47.24 PM (2).png"]="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAUAAAAC0CAYAAADl5PURAAABfGlDQ1BJQ0MgUHJvZmlsZQAAKJFjYGAqSSwoyGFhYGDIzSspCnJ3UoiIjFJgv8PAzcDDIMRgxSCemFxc4BgQ4MOAE3y7xsAIoi/rgsxK8/x506a1fP4WNq+ZclYlOrj1gQF3SmpxMgMDIweQnZxSnJwLZOcA2TrJBUUlQPYMIFu3vKQAxD4BZIsUAR0IZN8BsdMh7A8gdhKYzcQCVhMS5AxkSwDZAkkQtgaInQ5hW4DYyRmJKUC2B8guiBvAgNPDRcHcwFLXkYC7SQa5OaUwO0ChxZOaFxoMcgcQyzB4MLgwKDCYMxgwWDLoMjiWpFaUgBQ65xdUFmWmZ5QoOAJDNlXBOT+3oLQktUhHwTMvWU9HwcjA0ACkDhRnEKM/B4FNZxQ7jxDLX8jAYKnMwMDcgxBLmsbAsH0PA4PEKYSYyjwGBn5rBoZt5woSixLhDmf8xkKIX5xmbARh8zgxMLDe+///sxoDA/skBoa/E////73o//+/i4H2A+PsQA4AJHdp4IxrEg8AAAAJcEhZcwAACxMAAAsTAQCanBgAAAIGaVRYdFhNTDpjb20uYWRvYmUueG1wAAAAAAA8eDp4bXBtZXRhIHhtbG5zOng9ImFkb2JlOm5zOm1ldGEvIiB4OnhtcHRrPSJYTVAgQ29yZSA1LjQuMCI+CiAgIDxyZGY6UkRGIHhtbG5zOnJkZj0iaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zIyI+CiAgICAgIDxyZGY6RGVzY3JpcHRpb24gcmRmOmFib3V0PSIiCiAgICAgICAgICAgIHhtbG5zOmV4aWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20vZXhpZi8xLjAvIgogICAgICAgICAgICB4bWxuczp0aWZmPSJodHRwOi8vbnMuYWRvYmUuY29tL3RpZmYvMS4wLyI+CiAgICAgICAgIDxleGlmOlBpeGVsWURpbWVuc2lvbj4xMDgwPC9leGlmOlBpeGVsWURpbWVuc2lvbj4KICAgICAgICAgPGV4aWY6UGl4ZWxYRGltZW5zaW9uPjE5MjA8L2V4aWY6UGl4ZWxYRGltZW5zaW9uPgogICAgICAgICA8dGlmZjpPcmllbnRhdGlvbj4xPC90aWZmOk9yaWVudGF0aW9uPgogICAgICA8L3JkZjpEZXNjcmlwdGlvbj4KICAgPC9yZGY6UkRGPgo8L3g6eG1wbWV0YT4KKmPX+gAAQABJREFUeAHsfQdgXcWZ9XlPXZZcZclVltw7rvQWQhIgQOjdFBMgLMlu2JTNv9kkm91NICHZFBKSDQQwYHogJCGBUEII3R03bNwkN8mWJdlWf+0/Z+6bp/uenrpktTf21b3v3rlzZ76ZOXPmm29mPCE6JFxCAgkJ9G0JsBaH+K8554EH+j+gncRDGTQ0NKC8vBwpKSlIHtACcSU+FAq2UHxcHpu59Hq8zTxJ3E5I4BhIwODbQEe4luWsBsI0BPS2Y8cODB8+PAGAEplIsIcA1tniE0umPZ7OhthyhiaeJiRgJRAMsgHnwYJsbzWe1cnj/aSkpMZ7A/mK4pAsvF5vAgBNq8DCUVFbgSpfFZI8SQYQTfmIU5bMfdvT4HOBXrI3GSMzRyLJG13AHGBtLpCBXAITae8KCdjy5fP5cOTIEaSlpZnyKDBU5bZODbG6fZmZmUhPTw83+AO4XLqSnugCh/UCz21/Dp/f8XmclXEWavhPVDkUDCOdBbxwifIkUYIsX8mBZBz0H8SCjAW4/9T7kenNREVlBYKBIIYMGYLk5GSoMCaYoK2KiXOXSSDM6hSeylhqaiqysrKaDb6mpsaUy2Y9DMAHhrwMwHTHTbJVIPsDfjTUNxgA9KYT5Qh+BvD4lgXEwBE/AnVBZI7IRD3/qe8sYRbt3AV/KID0tHSUlpZi0qRJplWO+8HEzYQEOiOBeF1dhhdi+d2wcRMKJ09FVqbYnqtX7GI+nfl0f3o3wQDDuekJsXSwB5vk86JmdbXRCWbNzkbK4GTU7qxBoD6EtFFp/J0EX2kDGg42ILUmDakFbHmTs3DgwAGSQi/Gjx9vwDMjIwMrV65MAGB/qi29KC1+vx9Tp041inyhnBpguaOHK7B5y1bMmD0XB0v2IuBNw6jcHPM80RNpmoEJAGwqE3gzqCBlC+s/HEDq0GT4yfj81UGkDEuBJ1mHB8H6IJKykw0rVMGqrqnGiEEjUFdbB+lkpI/RUHtFRQX1LhksgFRQJ1xCAl0gAen3VLYGDx5sANCtoamrr8f8BQuplyYYHjmKUErA+aI8JRhgE+l3CgDDjU6TQPvODXV8naFxYwRDjGoIEeyyA+Ry1AKm+/jbg9SZZHpKlCeEen89qquq4csIwOdpQFWgCr6gD0OHDsW+on0YM34MUlNSsXPnTkyePBkTJkyAWutE69t3SkVfiWlmRqaJqrts5eSOQsn69Vi7Zi2CLLuzZk92khMDfn2/7rq69p3IsA4DoDMC1Ykv94pXBX5O+5mcxDMLyaBM/pk+lAwwjdplwiMPT0q49NCLADNzPgsebyX5k9DgH2EAcGTOSKQGU1G8t9iMBmu0bcaMGb0ilYlI9FcJOGXXy4Y5WZSPzpuUjLnz5qO2thoZGYMiCU9J8UYGQTz037ed4s8KKLVVuGp2ND0eAlm7peGAH6GDbwbIsN36WF23FqLibJLg8qt33OHES5B9T8/sd9zv2XvmOf+4E9acP/n1MuBDtTU4Wl+NZNkHefzEPg5uNOdswCbCIWM6kzsol+8mo55dkACFIpMDuabsL0QTBY4OU242GHfczEt8oGcK3p0m8yz8p7n7ehz3mQnQHULL1+4wItc2DHu2QcT8Nv7dPf5wPuu+DYsD5EYtELQj7TasZs5SScgFJax+5Bz2RnByyyucPqXYiNYlP5N8KwLel2lfXR1oBnMU2dnZLFdOhUxKUphBHiyf9FRdXW1MYLKykprUWStOmzf2d2tnt38b13jvuP1FPY8pN/aZyWo+s8m0991npdu4ZsJw+7XXFrdkErRmzRrTa2s3A7SBVNLcY9euxzFsWIhClrDJjYjINiNNIvhlnRVZqsWMs8KQmZL8Wn8cxYeffmhBYu7pvupGCmPIgS0jDDdQ6FrhqiIpbIXHnmYkPMlFYSpj9B09JzaZ5+5wFCmlKTU5DZlpqfRTi6raiSxMc+k34BTAZpoZK3uxwj3le/gd6gUZKR3qAqtwDxo0yNzXd5y0J6Oycj3vb2X8HLstKwMrD6VLH2Y+GRkojfqtBk9n+VMalCb5VfqdsJ17Nhz5kdMklWT6030d1umxglQ4ej9KfnzInrx5buWreKh+6Zumnuk9GxjPNk6Kt/zqmb5t46Gz3+/h9/woKcmkqdAp1GNlMCyaCoXDsXGyweq3dF6qwHJWnvIf69d46CN/bLrqiF4NDW8iK7ueDS9tUFnofSzHcpKXzdfImfJMTXHyrKFBdc9D+QVYpjjgwbPKnBhekjcEf0DGXE4fR+EOHzGGuul0Pg+yTum+U2cVtv2eMkI/lccqFyoTNi8VL5UfUz7px5YX+XOXOXd49tp8wPVH5ULp0HsqX/qGwpOz6XZ+Nf7lzDWTvoaGWtbTiexhXWTiYjGp0Wfbr1S12umcYldDpf/YsV9EkJH2MBQ2OMgk485Ijw6uga3ToQqgsDD6vq1INrGbNgB544ARQykACoVjB8wwgANZGDYGzLjG9yU0Cb3qMHCgHBg9GhyEAHJHNvrR1Y6PgUrWm4LxwMEyYNo03gzXGhuG/b6PlXZXMeM5Edi39y7k5H0KSck+Zka4dEQHHfVLPjSTRE6ZIQCU03k0I9dYMFnwaDsYDP4J+fl3YusWghzlN5LpLGf8ZJY+dDDjsYNpzwNmTVe4lAXTyHIOllvGCQQOEzwU59KD0bK16XF8OH8lz0OHGDdGMYffik0Rya+JxxB+W87mzR7Ko6wSmD2LhZPf2rQZGJ9Pme9nnjAcHxuUesaf1hY4fJT5wDgT9zF7DvPmCMMkWJaVskxks7Dz20f4nWlTCawsyLt3C8xKKYdcFny/ATnn69F/rTz37+dH6dzyjPbZt35pUCyJmVleXsE8vpUZ7Mh3LOU7pbAxLU3yk+VXdaWUZeL44ynDjEa/7ivVn2HD3Hec63rWxwrm6SDmSXZjD9k8dH+rkuVlP8tkIeOzYT3zjx2a6aw/Aq1KflsWE0PD5TBSl5iGcDWIfFhh6lB9dTuRmjWrWZZZjqZMYflkOR46XHUm7IvvxBbUXdtZT6qAuXNZt7ctJQhexJ6WO9T2X3cAAJ2PqMJnZEzAx5uq8M7aoVgw12cK9uSJrMA7WUkOMNEMPYtCVmGfyspM4DYVTV3OITnA5AnAihUENzKNjRuByymI9WtYmehv2GBgOxMsMMinvzq2EkOYaQcoqBNPBgZneVBfF8Izzzi/BYIjKcC/vc53c4H5x5F9ZYdQzEr8JuPDBpCtJAXIzDv1dH6TGfLmP/jOGOC42R6sXx3Ehx8Pw5TJH5INDjMtkrqqTXKhNRnzO3Iygo4AoXLfNIViPwLzLNNwfLR1FtJSjmLfbg9qq0OYPs+D0n3AKKblEAtf0R4HvMuYZg9BhknGh5RTCq9zCTbllPEBpmkv5SuADBCkRvLdQjYkb73FAj7UASmB5r69IYwt8DC/WAEOhzBkmAd5bDBormi6UA0svCRjpmKM5ftqTDasC6GSFWbeXA82870VqxzGsXlTiA0Fw9oSQj7P1ZUhlBPwxo/xYG9JCKN5fuXlEOYs9mAU82TN2hCOsLHKZmGfMYORh9jvWSwvkq/TULgV+eZmzB/J0zoz44bp7dvOSYCXs4fS0s7Gzm2v4qPNU1FRVYe6aqf+sPOAWuZpHuvKli3AaWfyN+V4kHk+nyCwe5fTsAk4SvYFMGQ4Z3zUUmfNMqbyk806pOI4m+X7QGmIekEvKg55UFUPTCwEathoCQgFdmp8TzvFQ2AJ4QDfLWGZGjuZDVwN62CxU3wPsqxw+iyq+P0aAtjc2UBxkVN+jLqRZUjjMuwcgp0bA+qhJNbP4z34aGMIu/awzk8C9jDskaNIdlgeNmxmeZ0AvPc2G2eWXfUejpvPdxn+39+kf4KuiE6ACckfC2x+dxDxYDOxhy93gWOyO+5kMJw9rB4TJwTw9j98mDLVYzJvLyuxKpcq6j4KTQkt3gZ8sJ6VnAJQZbualWMfBVvNCiZQGkuWlkmh7d8LbOP9HHatObECY0Z78M4/QhjMQpDFCrpvPwFirAdzZzmgduJJwKr3Qzj9U6L+DntR6yJ3iABRwRbjrLMZNkH2nXdZKJjhZczwcQQQ+TPv8Lz14wAO09ylhoXD65XuRGd1EehHTRH/t8WpW2G6HXxR7EXO/FU47JqIUYZoLK2ufmbmUQR8xUjNoMkNMz49jWBCpHbAwPGrD2tmSQXlWMs0qAWclc8C826IjQojxYbh3fdCpjXOHuHhKLQHr/01iM1kv2NYYOpYgBX3MQSlkhIWTP4cRLkqTitWhnCIss+ljANsTD4m0OYXejBlGuNIRC2cHMT2HWxtd7Fi+QhsLLQKY9Fi4O03QxhEEPWxsao8EkIOK596ArNnAn/6QwjVvF9z1INtDHMoy8I0xnXT5iB2FudicoFYQb3p7jEaRk4mzYpUjJxt98bK0vgPy1jXfdW50yU2KNY9bHgADdU+rF7lQXkFy/wwZi/luIZ56OPzKTM9GMI6JTFJpUF7Z4xmHq9apXyjvNmIbtlMdU4K8zSX4MU8zKL/Dax3m3h/4WIO4PG3j2VvFRuz6cznTR+ya8z8V+MqFr+X9U/hV/D7p7Ms0OjB/D6Z9WzzBpZBxufjHSx7fPevL4XYyHpMD+v1v4Vw6hkMj98azrKWxm9sIOipKs4jGanhe9lZDrArixV/9YDGjBNZYNlPIUCy3uexHO3dw8aY4D+EDbh6P4qACIyHA5WDs1RPRWD4gS5w7R4EUWaJ/ZWU7GOFHWu6ZDSNQxnBxs9MUldr9BhWMoIVbUk4q4KIz4QNZyXQDDJakGAEwcx0V5mGdescGiw6LqDcx9bhAMMQC6pmhsg/7ThRzlZnBFsfgaVwJYeVMYcCqqJgG1hAqO6gwWe0RFavMPiAxYsYFT4XC5HY1AUTCLiduokC7nHMkNKSnyJn5L+QwfGm+o3KsTY6W7D3799vGGAuS6JTeQXQAlYv9uxZhrzcG1FxZAJyR+zBpo1MA4EshQ1ABo99LISS1+xZbCR2h0xX8ghb1XrKt6DAYwqMuq37yeoys1mAGD91pYfneEw3VGoJFfpBgykXhqtnqhTEMIwgaDFFhp2X7AuZgim5qzstZboKXRZrw0h+f8fHZIBVbJxYoCWf/ftDGJnnYV4TcPlOgHmrLnAGUbWK8aElEPZRhjNYUSXoskMh7GRlGc8407oIfpbiUCCHwHqA3bhTKIMX2JqPoEyi5666RW3lKUNzOSvP1hijO4zeeG3rUWXlYebnyWzkNuGjj5i+POYX86GO+SHAkGpHXU01VFOmOeoGAdHhaofFleznc+bFMMpeOvRSNlCaki6VVBrr1HCWgQ9Zx9S1llpCzExgm8VyU8F6JsY2kvVG+S92V36QPQ+WP6kzpIJSPooUKA7yv2MX68h45ju/v43XMxmnZ54GFpzEcBgHdZry+K4G+cQYxWDnkCke5bfV6EuvrLpHVTveehssC0xHAcsWQe8IyxrNaGm6w/dZXmr5XTnb1S7ayfixDh93HNlv8RdZRu81XWBbRhzfzf+1/tyDIB0GwFICYOmB28gsUqjETCKo0JKOFUxOZyG2kNv2/vRTOGL9uBXruqfD6p6SiJSqFHKObk1syPEjHYFAVQpZoxfkfdNTpXfd0/esX+p7TcUVraY30+qYQPUt+rd+zXf4XgoHQurqtvH4F05ju5bf1lvtQD/6tkJuDgBDBMCiomXIL7iRoDyBbzDnDSTpW02dxKD0RHQjTb1E32l/lKPf79ZfVPD7clhWSvHOO6dw1swLPAY2AB49ShXIvq+Q/RF1QoNY5jSQ4eS58l3XOpzBDqceqAGXU8k0zIgXqjvWr85ytuyIYdk6YZ4xXBUTOf3Wu3Lyr3Jm64W9Lz9qoKWq0rXCk9pFjH8Q69hHWx0Vl/TXesdUXfoT6ZB/O1jifMV5rm9okFJ1M0D2kpxM21vdZKoCfqZTV3xXzoTHs77r8aTQfymZ6lns2n/LYICtc8ZzC3+sPzcAMsj2OidW3qQUjuD9mn3xPBZoSicGKGzkJXi309u6RTM54+xzE6p9yJcVSbXyWrTQRNzxbt4V8Cl8tTL6rA0j3QQS9siTve8eQGl8GnPFSCleKaTiOTnJjvA1ABITZsxb7f6pb+hQ4djKFn9nUZBgy5aeLWQV9Tcj2I1V90MFO2+kB7vJ8vJy2YVgiztmPNNM8M+jCmBvEbusO0LUl3gwnN0QFTylV3I9Sp3cux+EMG+hFyNYKN96K4hhZIdiYer+ZLEFLi0LYcE8L/WsZGgMd9OGEMbke3C4jAWTzEEFo4zhHDfbi4+3hjCb3ZhU3rQVrq0JV1rdIrSV1+ZNW8Ppb/4cHi62ncXBxJ+b/FOZbkkuei4nP7q0sjVneyN8X/7c/s1v1zP3b+tP9xSowpNz3x+kuLHs6MMCpIlTeEmPKg9SXzlAZkHKvB5JS3P1T+nQIIa+U0u6l8yupNGbp9kYOOHYv1Y2XlaerCwisObhg2DQCdcBAHS+JnAaMiSDI3kKosPBNBv1YFAgpG6jWoUecMoDFaoudspEdQPUpS1mF3TBAurJ2IIePOiAXlVNCFVH2d2hPlWFSjpPjV4X7QphFbsy0wvZNSEg5o0iOLJ7vGa1upXSG1JhzHcmTeSABcFsG5XZk6eF2MX2YEKBBjE4EFFJoCVQnnO2B1v5zT38vpTjGWw5PqKO6Ai7JT4CrfStc2d4sIFdrdycEFv7EGYRACUP/jffMmJxl1M9kLP3wr8NiXaemL+qPGroFd8B7ax8KIgsKer6uBOb64zL4PRTAWBbXaYGDGxZa+tLcfx1HLlYk2W+IKfuaucLtEqEkyIBnzUgtgzQfKjb/9g4CHi7p4YqVIGAsVEkGBUXk8ltd3SPYlga7TbdXYrC6u6keB5B3dvgLDI7Dnic8UmOlnPUeh/Z2lmnE0A/dronw6hAlkvnbBbpYUoJniOHccDkHY7akmWKfaVRpyTTGekE09n6ShGukfUx46h24LcLJ3s48k67xr30y3qZRQY5dYrH6HCC9M81HiIte6O0+FHGV7knsQnkzTOdXb8tgCqOCReWgJGbJKdjoLrG+q5R8XBJCp+tTGxpU5nSrBZWHt3qpOs4APLDlp05TK0LYqMURcqBwnMOwlGXJLZtstI3u88JEDT6nM5u5sKFBJsiDz71Ka+xoZQd3h6yLSmClb9DRkphzK4rZTJuLAd5RnrZ9ZApCrsO2R5Mn0qw5DS9GbMc8fioO/HRwHU6B0+oziRLJNPkCO0UjsBK0a1RXAZrurJpfG8cWaTsizUoxXn1GEqw1MDTfI7Qa2BFQJrLrrNG5KqrQtjHbvqkQic+Vk+k9FinSwN+vIg9y4/uJVyMBCgrU75NWY95NoB+SiUgPHGIhy1U9mwF4frtLnj2cQfOnQBAV2Q68OGB/IryTiAm+615hrVJlo6CexzNWNwuRCZn81qgOJomC3KTyMqaOgecpJyeSRC0TnZ9sY54apxGbuVk1mAcgdK6MeELjRhmcmSYJNQAsxiq4qKz9EJWSyF9kHSb9pk9K62225sAQSvdxDlKAo3FNep2kx9qRNvqt8nLTW90AgCbBtZddzQm5LSS3fWFbgiXGWWUxjFBK/8EBjJPeelVak9TaVpCPVsOgS6HpgZFxTI74aAEdXa0kDBmLsef4EUDGdg771ISzPyFi8joyMw0FUoj4lxtywySZA9R191hfeqqSkMh0wfp+kZz4EQjdhrNk+JZcVM89L0cgp5UKup9KH6aV//KS0EMJeKddLwXa1cGUcZwJhA1t+0g+E7yOOYtE6i7LGE3WeYPBETNuhlFNikD7sn0s41mNBMKHBOHoUzfgrkMnx+wgB4jmsTPgSwBFbwecH0CAHtALh3+pK3gXIfSdCNjAzLPCTCyuzrM7mlWJo2WOQBxSh6XU2UhOMxZGgUcjd3D0eHULBq4ciQ4LTmI1euDmLXAC67PikeeCOCkkxwbwUMc2FAXViZACzmgUkrwWc/wRrG7W1Xl2FyJEVYe9qCSAy2y29Mosofd5T3UEQoMAxxckaHqHM74EHOUjdZujjI3MEIy0K6jAeEYfuPVv4Vw4YUePPt0EBde7MGbr3KUmN3lMnbbfWkejKXd2Ls0rj6bBrG/fzGISy/yGKPok/i7mmAum7AMAn7CJSTQWySQAMAuzAktCKEherldfwggazrNWk5y2JZH6BZ2YrNiX6mp2TREzTdGr1s+IjOaKPZGK/21BDXq/2QIWkcw0rpuY8eFsGMrByY4eHHaaWSIGx2Dc1nFC0ynzCS4EITKaN6iGWY6ZEyqZ5pWeJTsbOJkh+Ud5UDItp18RhaoKYQyQlV8dCRT+aeBmFFjueQ/R4cPlmmWSgildXy/kIaw29ldpu6xeBffHUfDVA7EeMksifdmzvdYAu+uIg6uTHH85hfQnIZAm0pGKoNpx+cBnhnBRpHoQcIlJHDMJcBSmHBdIYFG8Avij48EUbg0DdsLAqh/IcCun7MEUVKSY65SzwmWSQSDk07cyNkR7IKSOe3f5wyMLJhPtsaBCA16HCglSLFrqVVs8gk+spcmFmJCPlDI37Ko1wQJjebK1iqTIHPu+c5sjMHsTosBqius9zUDQCO/YqDSoUycwBPD02h0gF1TdZf1vuwNNbNg0fF8RmBL53saZNHMBC3aoNkyYxk3xZdrb5p5pOlkqpqZpGmNw/ndkoNON15TmkaNITDydyb9yOk7MmgNBotNPJy7ib8JCfSMBBIA2AVybwS/EB5+sBY5X8/A4Ls5YnuQ83IXcIbMah8Wzk3n4ID2ZiWopJ/MRQiWE5wykEZlHCcDcCYAgYjgwOmbGEYQ0WoemmBObAO3eQBtozEoDCKabiYQ0QiuTKfE8rTKRzmnKkmPJ/MVTZWTH9kSitlZPwzeAI8WSJDTjBzp5BQvjT7LVXEOrze5gQwyGdV+jcxxPxQCJRcuMaPF+o4GRg6z+63pez69xzAEsJVkpJrCVVbGM5mnJsYrPvq+4i2nxTmPHClivJjghEtIoAclkADATgrfDX6/fagWRz704jOPerG3mMBHm7rPLkjBT+6th+e2eixYlEYQ5KosY0m5MNeMBOvzAiCrO9Rve23YWvi5/Gg0Vc49iGD92vv6be/Zs3kp5o+eydlv22t7lu2h7AYdtqa7jX7tO+6zntvvNXd2+8/JWUf/RN+ES0igByWQAMBOCN8Nfo+Q+R3c78H5t6ZjLxlXyhYyJOr9Uk8AlhRm4MH768wE9eMWCAS1FlyjvlBREDhYZ6/t2d4Xk4t1sX70296z59h39Nv9zH1t/Xq9XKDTTLLmCtlGf+lE0PqNPbvDjH1mfzthC3lJNxGmm87NxN+EBHpEAnGqVI/Eo8991A1+D91fyylrHlx4aYZZUcX07DgYksSa72NXNIPLkC+5OQP3/9qP1SvrCX5egiBX/9VKM0axx7Oue8ERiRPjFdJibq5zl8RP6TXOhfjhOxoU0bzv2MM8tpSVP2Kf63diQMUKsa+ew10SRd912d2pSTDADkjYDX5ifqUHPLjgkgxjSmIyL1y3lY/SydVznbaMTC+uIwg++JtaFxMkFxIexMGCDkSrS16JjopTEiMMLvphx77nKtx2o3kLaGZGUYww7JREu7isPuqsGhLzeYZrgVB2o7HOhmPPsc8Tv3tYApFCxni0VM5aetaBJCQAsJ1Cc4OfmJ/AT8xPdnSsgU0zj7cEcnXcWD1zkBdLPi8mWIult9Iw2OgEex8ItlMkHfIuIMoML8roBjcFpi0EJEofF8Y7crTK7H1bzcUKgxypyeIDwZuXfry89vKeAURWDJkXOf+bryWat26AMhxrxSMBimFh9NBJ8reNoKLgzp94UerK/EoAYDwJN3PPDX5NmZ+zknOTzGNdVIVNYpdYS/gbJrg0A7/9v97NBJsRQadvSz4qwAK5v/zlL9y3YhjNdapoqsMVogVuPGpqaCZEYPPRIrt4935MO24uUtatQS6Xxtk0YQKX8iqDn1uO+mjF7WE4mVo7ns5Lu5402u2k0rZHy0zp0Obh2i1N19qpT8/cDDJAuxwfw3ADo+LXlZWs00Lr5wGoudLyd8oDbXcQj8G7RWDLj/teR68TANhGybnBzzC/UjK/yxqZX0sVxvIRLxd6rSMIZmZ5cf0tGfjNr2px820Dkwmawk6Q0yZHaTRi1D7K6Tyn8SzwS6HhYoD2klt3l2Bh4QQcfO0VJD/+OEZ85zuov/56BLjev39UHpfyr+PitkHKtc6AqM4CVO0iV8oNT7ZzY5laDmn7aO+jcGV6NJxLH+fk5JjVpXU9mPY6nrABe6Q4sNUKmAUnHWCNYpbKULVqCddhCQjkxNjNWQyQIWnlJ+WRaSTtMwmezg2Kqmvy1xUuAYBtkKIb/MT8SgR+rm5vS+Cn4JW5FgS12nWECVqdIPPyuPkaHe7/3WErKxX2T3/601wAltbVzTl2kedkDYH3rbeQfMqpCK5YCfzxj0g75RRnWore01y+NjgxTAHj4cOHuW3DIa6/eJBrIm41QClGOIRb7QmMx4wZw2mEowxjjK1kAm05VVybjjZ8OuEljgQkQ7nI2cW6rWztM7c/81IX/kkAYCvCdIOfmJ/A73MR5scMZMa15mJ9WCY4iEzQ6ATFBKkTnD+AdIJq5cXSBIDNbYvpITCli4VNmoigpqlccAFw3XUIfvABPI8+itCSJWxd2LwImJrJB+WPDrFMHfrexIkTI1mmrrhAUYC4lzsCvf/+++a3AFqAWFBQwBWzxxuAdHedI2AYDj8SYOKiYxJQPlrnZgz2nj239Mz6acc5AYAtCMsNfo/SyLm9zK+FoEnhne6wdILXSifI0eFbBhATlGwsoOhsr6NkxkoRlM6Oej+PtqcTAM6aBY+Oxx6Dh11iXHMNaTMFJxBkOPGcwNY6Xdsulrq9YnnqBuuYpqW36dRdLqOesZh7qm7kfq1///vfTRd9AuMxefJkbpw1jgbijVUnAYZWup05u2iC67IzIbbl3cZcbIvvAeTHDX4PP1CL/SXtZ36ticuC4EBmgi3KSOwqAl4EMf42TmBHJgiCIMgEISYo8GsGBN0s3X2tsCwgOgE7jN6yPzHAE044wQzYlHA/UOkT33jjDdOVzuOS2zNnzjRsUnpF6xJgaCXRN84JAIyTT27wE/MT+LVH5xcnyGZvWRAcyEywWeG4Hwj8LBhaoLMguHw5cO21LYKgOyj3te0iu+9ZUDRMkd8VSxzLFSB0nH766ZzHfAQ7duzglq7r8Nprrxmd4Wzu5Thl6hSjyLdhaT9nqbrislvrKXHuUQnE7zP0aJR69uNu8BPz27PXYX5moQBDQrqen1sQbGSCfqwxM0Y0Ekl5NPbgekY4Pf392FRbtqf7AkEBo5ignPuZc6fdfwWKAi0Bn84CQjE7HbqWac28efPY+74Gt9xyC2bQJGfturW477778Pzzz3Pb0yLzTS8NQPW+fbfdEUm80O0SSDBAl4jd4NfdzM/1WXNpQbBXMsGux/zY5Lf/twU6nbuACbYUgSiWSKy1gKj76v7OmTPHHNrjd9OmTXj5pZfg5+DKcdzBW4dsEOX0no6o8Fr6cOJZt0ug4wxQlaIbmIHb3qfbU+/6gBv8mjI/p9C6vMe9tAXcyIUFXQLSyVyZ33Ffi9y0IOhmgs7cYcsEu0Hgka+3cNFDn20hRs4jC4L61Q1MMO73We4FYLHsUNP6ZHAtneGtt92Giy++mEuaVeD+++/HM888wy1Md5v3xAj1vjPbpbcKNm7K++XNjjNAVWhmZFc7FQ45dytp73X1t2x4zv4YDqI7o71e6vzSaUBLHyaZjekUyMnZs3Q84RhzWha7TvylNQ08yeo+hXtkShP/O+84oKgwzHt85k6fQFALmNoZI2bucGR0WBVPbx4bF4mXk8Bj89H2fsWCoM7dzATjRc1dTpW/6u4K5DSAcv755xvj7A+pK/zDH/5gzHBOOukkDmTPMgCq8ASEFhTjhZ+4170S6AQDdObvKXrK+K483GG6r7vyGzYsrc/nLFfPxUyp89u9RwsbpBH8VJgFdk6hVkENyiaNgJXEZeNT02ijls6D51Qu8JnCbSZ9nIVQUV5pFjYNHKmBjwjq55J3ZuNyhpTC99JSnffS+G4KrwWaiovCd76hPZZDZsZIBu0Er7s5Hb/5pQ9rVmkVGa2o3LWytnJo7qwGoLlnHb2vPO1SZ0FQgR4rJhgnAQJDMUM5q/eT7eHi44/HHXfcgTPPPBMrV67Ez3/+c6ygLaP8yL/eU95Lngl3bCXQcQbIeMpeSkasfruscBfFXQVCYYsjqZB0R8EQqTHbOBKAPJ4gwc/PJa28+OxFSTSE9fGbGn1gDGgrph3rk8no5Brq/TjMrdYOVx5CeXkpKioP4kjVIVQ3HMXu4s04WFOBXM5NDcw5GzX/2ILsF4uRmp2LdE869+bIRVbGEAzJzsHwYbm0PcvF4CHDyPayCKBJTKsAzs/K4Of3ndWcBbJXXJ+M++/z4aZbfVh8QgrnymotQROdbvkj+UfmZrKCdqX8FVaaprmxwus7XeYsCOrcA0zQnQ6ly6ZN6bVAJxtCHfu4NLZsC//BGS4nn3yy6TZb4JRcEozQLc3uve44ADJjU2ktL4NQ24oZZVdHy7QaP76rAmMLkM6yybL3OhW+5Bj+hi5jdX6lpcm4+Ip0Ay5ic6mpTndTDK6yopJ7YBRhx66N2LZnPTYfXIX3a19h/5YBcUn4yMFl4nGIx+hzMe+iBTi4iYuj/uZ/uMM577Fbi308uDS8WQuU5zzvOMzNPhnTRs3H5Pw5KJgwHbl5Y7ncfDplQDAk4WyoD2LIMA+uvzUFyx6oo7w5Y2Shltd3utfy504Xf3XMuclHOA9t3naJ/MPhk7+a/FWZUbhd6uKB4LJlwA03NI4Od6blUHwlcHe8zTXvSWa6jglfZdim1ciRHjXd7uqrrzazT2RX+BaB8DTudCX9ofUr0BQQJlz3SoB2pu7cbP1jJhOZqWWcOqTCoEnl9l7rb7fdh0+bWTB8AWCXVHDXp8W0nLIVwqMP1VFBHcIF1Pn5fOrK8nN8Xl5WgW3b1mPd5nfw7q6XsKrh79zkgoFwnwto8ZFUbmbkHYVUMrsgN/LIYoXeVk/0WzUUX739RziZK5nUEaUeqTiMl177Z4xbOA1JVO41ME0hTwC1oWoc9tO/gJGbF4HbRoI6x88MvQrHTzkbs6Yfzz11pyJrcBpZIUXBulB9xI/lD9XjtjtSMHdeqgFBfrZbnObOivlq8daudLasfMAuoIBAsypaquwhZpamxJX97W9saNKQQ8Zk70XipSKsg7I1R2MGA08/LUUbiDiOdz2TP+vstQ1DBcNem2cG2Zx79pl9x4bhPtt4uO/FXCu9chbgDnBnq1dffdUs3vCpT30Ks2fPNs9j/Zmb/fRPfV09VUIpEZk0m0xmsxobmRppzrZUDLZMNftO+IH1p97NmjVrMHToUBnaK8fa7mwgZQe56w1dzsiuBUAbviLZhAG2PZrN+nQzv4fur+H8T+CyawYZkKmpCnDD7014b9Vf8fKWJ7E5xMn3IxnUMO6UlpaDdG5RpEIZ4H6T9aF6gtgRBEIBjGOd2eMZjMmvHcH9WWfjuGkFWDF1GsZtWI9h7N7+5VfLcfPlh5E3kbuukVFyzyGkKDTPIKR4U7kEEGkdwygN7qYHfk+iLQfOHnI5zpx7ERbMPwN5o8aandUOVwTx0K+qcdsXU8kEnQUUtGS9ZNWVzgFAh913ZQNk87fLANAUX6bdJt8CkAwoBd71bEgfo6F0OlssGUvHc/YdPYsNz+1flFyqEO1Gf5g7WY1gwaDZC/cQdfYeLWOm5eU2grH73TjXsQCnrvGf//xno37QAEp+fr55ayB0i/smALLQdTkDDCO8mwHaShOnDLXrlhv8lv22mnN7U3DpVWk4WFqPDR++j5fffQK/K/k1CzSD5UbgeWnjkBRKRo2/CkeDHNxAeBezcH1TXRnPOrZbe1VyQ/B1b2RzqyNWDLo//upXmPr665hGEwiMGo1lJftxI0nI2AkkfARB7lPe6MJNUCq4m1zSUG6Eno4qguth6hZRQvA9OhLXz/wKTj3hIsyYPc3Uv9/eV4Vbbk/GvAVOd9gQNXeYjaF36CoKADsUQvyXbF52CQC6gUvbzw0iRdeGyGJ8osa7dwDf/TFw3y+AF8gEteHxEhpOS78sFia6r4ZDh0CthvuUDJW+gk4bNGeS6gvwBKZ13ILv93/kfOSLgK0f8h1Of9u9jc/4rrb1O+uTwNpVwClnEhgZhlEwty1DYoFwy5YtePHFF83Mk89+9rMRO0L5s6zRxLEf/ekpAGRp6Z0ujINdFrlG8AtwwKMeh49k4dwLfHj15dfx1Cv34Y3633HDXarrFowgDA1Cvb8OpfV7nO+bOtJYmHXVCH788QHB700P5g45Cr93GJJp/+VhYfWE+6fq8t6gkJ4AbrySe/4W8joMgiYsEzQHHqgcLAvsZ6VSDzsDORmjkTIlFfv9Rfh56Tfw8we+gSX5/w+Xf+4G3PSFaXhsmY91vRYLF4e33CQYR5iQvjdQ3Ksvk4KzpRiZB3yKQKT9ObUr/HsfgCscUJlKYV9OwT9FEPzXrwJnnO4AFHVuGMPW7gBl/sc/O/uQnngSG51iYONHBESyx/M+A7ysZ1lUbxDgJk3mrvC7gXPOZcPGVpLT4/B/v+Q3mIlTCuhnDfDpM1lACJpm86fWM8GCmgCOwydmUQYtzCDd4E9/9lOcecaZOPXUUw34DQQ22LrEus6Hqky/d2rsvWbBywCeejzElT5SUVC4Dt+6+3bc/sIn8ca43yFv3njkDR6HqobDKGko5j68BxwwCXctpbyXk8CiwI+95HVvcpNLNvoB7acr9mGdPNJpP2ANlAgEH3qKdbWI++qyjg7mY/kw+Geu+Es/+M0GTy3Kgvuxv74ImcEh1JcVIn3hYDyKu3DhPdPxu+d/jDM/WYZnn0zD+nV+Eh51zfmuAhwozqZVSlJ1dbUhsb337JMEuWTS+KEErD2ORK68gvSb3VSqJszO844i2MibmyEzQ5iJVRXA+i3gHDdgcgF3gt9LRkeQvH4JdRIE1+Hs9ipfB/NbAr9XCI7DxgATea2NnA+VOd8y5a19GSEglNWBQE5OoHfnl+80+q6f/OQnZvTYDjhaP+37QsJ3rAT6PQA64KdaEST4efHW6/tQWfNDXPSLefjD4N9i9KJ8Mq0xZHu7Uerfw43JWfgcRArLytYo57Z6Nk63l49JMNa9YcGP4MhnUa+GQ1BdCNbzB3tNN/L00BOsVztZXwmCQ/gO/8e8pzthRzCs4QjJvoadCPkCGDVyAoacmoW7t30V31l2KrKHPodf/LiWXXjNXR1AICgQsiCTk8tMmEWm9hfgIAFOTrqGYdnAm2ydOIpvnJjgt79LEOMu9D/8IVshgpicWo5Fx3MQiiNRb77jMMiDh9gtJqgKJAcNdrrL6mZzUdWIe2oZsGITgfETzi3Hoj58HfHV7gs7EiyQG0STqmupu/zchZ/DI488YgyqFaD86LlUCgnXcQn0awBsBD8OBpL5ff3al7Gl5kJ8b+c3kXz8SIwaOh7764rZ7dznIBCByjK9WJFKUCprEfBb6WJ+VBd5WYf4eoSAxHs/WMu7FgTJBPcWxWOCsW+GCzgDr/dQb+krYs8sgPGTJmJ1/g58c/PlKKr4Kj5/0Uf4aNMAAkExc1v5acuJPczDs86m7pYMTe6U09gVZff19tuBeQRHOW3RN268c+/aa4AXqdOT054iB0uJKqTpF1wInMZu8EsvUqe3ga0UGWTBOMff5EkESbZkAt7Sg/w+w5tA5kd9HY7WAPv3O+HLdydxKWI+wxZXXeOJzO9/+7d/M4Ndd999t2GFlg1aHaITycTf9kiAfYT+6dzg98QjAVxzw2MYdtVNeGU0VUVphezq7uf4wkFToJoDPSsZFnej046An5gfiYXp9gr8WNjDPeUYJmdDcM4CUYGgVyAoMCQTvOlKkpVCvk9yooERfavFusMP+Wgvs7tuB0ak5ODQhGy8XHM/R47vx4mzVuKd9QsxczaZYIBgqA8qwP7qDAgycfMXcU+BBRSsEkwnYDTgyMQvXNh4T8/VvZRu9iIOZjz6GEir2L29nr8vZuawFbNhTJ4KvP4qWSTZYgFBTs9OP9MJaz2BcmcxcNV1zm/99ZMtHiSD/DTBU86yU+dXh/+qS6x/YnsCvAu4KKwWWHici8HOnTsX5513HqOsfaad5x3+0AB9MVxi+lfq3eD3zPIQwe9R5N1+EzyFozEoaTQOsjtZ6+GIH+tHa+AnAbXI/AR+7RCfwusYE7QfceBRFeNQqAzJvp1ITZ+E8WcRQC88CYvnrMKWAcUEJdAwcFngEzAKyARC7nsSocBP/uU0IqzfWlhVzgKkAU/+PvV0Mjrq/+RkiGnvz5kHzJmhwtN4T6XgM58hw0917tkW0bzc+T/ubrHMY77xjW+YzZ5+9KMfcUZSuQFHMcFEl7h9slZ97FfODX5PLAvgiuuWIe+rS+EbOhrlNE6u5sBChK61knIBW7M6P8v8Wgkj3mMJPQoEyQRb1gk2DcUCt58VsyGwHbvr85E/14ea6xdhzjmrsGkg6QQFXAIngU4s8MS7J/8WBK1toF1PUIBoQZPL8RszGBM280BhGRDk2expLAQM36PROCeGN8ajaZZ1+o7tFovtyV166aWGEf7sZz/DihUrDBOUn0SXuO2i7lcA6Aa/p5cHcc23H8WobyxFA1mfwM/jpTLcVBCHRbUkJglGZT3S7Y3V+am+tRRAK88UfhQIPtVWnWBswGQzTJPHU4zimvE0nqWFzbknY/a1q/DRxgGmE4wVTUu/3SCoucMqF1pZWs4CqgVCU2acR8af+74KgZ6774W9dtfJzQZlLvP1r3/dbOb05JMc+aazXeLu+n5/CrffAKAb/B5b5seV31+GUdctRX1wNCr8NQb8OF+Cedc6+MlXdzC/2ILTBAQ7wASdMMUHtfrwbgcERzYgdMYizLhhFTasG0AgGCvg1n7HgqBAzDJBC4Ju8LPh6V7s/Xj3rP9uOLvZoEaKv/jFL9KGewjuuvsuVFZWmi5xYpS4dcH3CwB0g9+TywNY8pNHMfqim1HvI/jRUNjjOUyAaBv4SSCqB93F/GKzpAkIdoIJyozWgGAtmSBN2nDi2Zhzyyps3pAAwVi5R37HgqCAzM0EbVc58kLvuhAbtLq/c849FxdzMEd6Qc0msUwxoRdsPs/6PAC6wW85md/VP3gEo8+/mbOeRqEiSObnqWwz+B0r5hebHU1AsBNMkJOlHBCsEwiyy3/CIsy8cRU2JphgrNgbf8eCYCwT7OUgaGeSiPFNnz4dX/3qV/Hss8/ib1xAwhhXE9QTesHG7HZf9WkAdIPf0xztve77ZH4XEPwayPyCdb2a+bkzQddNQLArmKBAkDa8OOGTmH09R4cHkk4wVsCt/Y4FwT7GBN1dYq1y8u///u/YunUrnniCrSldQi8YvwD0WQB0g98Ty4K48ibq/C4T8xP49Q3mF5slTUCwq5jgMNqnnbQIc89fPbBGh2MF3NrvWBDsY0xQyVO3V0xQgHgb9yaRflArUOuefdaaGAbS8z4JgG7wM3Z+N3K0904OePgFfr1b59da4WoCgl3BBKUT5Lz9hjPOwLzjVg8sO8HWBB77PBYE+xgTVHLcesELL7wQ8+fPx1133cXFfmsSIBiT330OAJ1VXZxUPM4ZHldc9wjyvnwT6r0EP4329gGdX0weNPnZBATDTHBws3OHmwQRvsFpVFYnKBAcXwXfJQtx3KzV2Lg+MTDSnNTYX2y0E+zBPUaajV8bHli9oHR/Wm1agyMCwbKysgQIuuTXpwCwcUmrIJ55MoRrb3gGw2+6CT4uZlDRIDu/3jva65J5my6bgCCZ4J5dzgIK0avItBYcN/R2jw7P4Jzik8/GFQs2YnNCJ9i88GJBsA8yQXWDdaj7O2v2LNy8dKkZIdbCq4nusJP1fQIAVfYawS+AJ2mv+tiv12LapdegPDeN4MfVo2nk3FZTl54a7W2+tsV/0gQEaee6ZydXYuogE/RgN/Y0TITnhApkn/Et/PC7FVi3RjuTcVc6zQ5r3UQyfkT7691YEOyDOsHI4AiXDCsoLMSXv/xl3Hvvvdi5c6cBwaBWuR7Ark8AoKPzM7CFxx/xc4ZDFYbPuBdbuArScOSx3pa1GfyU4GNp59fZstUEBDvBBENiBMEd3NJzEt4f/TzGTX4Ry5d5sXa1s+WmQDDaZkwyH+AuFgTVGvchO0Gbe0ncTStAENQ+GnfeeSeeYBqKyAS9XPHagKAqxQB0vRoAVdaUL85ipiE8+JsaHCxLQ964v+LhfQ9z5aMC6v2KaZVvYK3V7DMQyvAiRs7u9fw6Mbe31Q930kMTEOwEE9TarJnajCmPS4R9tAQnnLITyx9JwaoVtWQEYtqSUsJFSSAWBPsgE1R6BILaayc3NxdXLFmC1ZddBuwqckBQHgYgCPZaAHS6vXbGUQiPcA+PisoMrlt5EN/7/f/jar2srL5q7rCmnFP/rWVnININfl08t7flr3f+aRMQ7CATJAfkateVGJdagK1cBu/v7y3D5VcnsXEJsjvsMEExbscNTFZgUx91jgXBPsgEpQtM5QIPR7mHybO//z1OZgIPTJuK2nff5cI51BUmADAqy3vkh13lpLHbC+7hwfXv9nhxwSVJ+MOLT2Pv8G0Ylz4R5QEuSskK3ZqTj2Mxt7e1eHT2eRMQ7AATNPKlQPY17EVu/ijcu+K/UVS8Bp+/YxDu+xm3C1xZbwZBWVcaXQIHHVnEgmAfYoLWDrCGK1r/kHaB5yxYgLyvfQ0edoef/ad/woF33uH6kVxXUNsLDCDX6xiglLYqV+r2JieHqKOqxR7u23v5dZnYurkIP/zgi0ABt15oKHOmT7SiuY/H/Na+GbOYaR/K8CYg2EEmGOSyqp4gR1NmAU++8CC1CCHcdHsWfvMrHz5c24DMTHWHw4JpvY3pQxLsZFRjQbAPMMEI+NEOUKYwV1x+OebRNtDPPU1Gnn02PvE//4OfvP02yrg/sdEVRrV+nZRXL3+91wGgRntVplJSQrj/V7UoLvbg4qsyUcsVx19943fcxQsY7S0we/K2xv5Ub2OZ39o3uHgwFwoI9GKdX2tlpgkIdoAJqqE54NuDnOGj8dyhX2DNig8wbIQHSz6fht/80o93325gHmgOaezASGuxGwDPY0GwFzNBN/h9//vfxxVXXYU5U6ciQH1g8vHHI8CR4XFkhf9EneDPODp89MjRAWUi06sAsNHUhTq/B/04cDCF3d5U+Km5379nP5Zt+h7RT5uLE70MK2m+b6aEqVxGBjyo8xPz6+vgZ+GlCQi2kwmqK6x/Sdo5bTzwt/efxVHOmMuijc01S9Ow7AEPdYK+sE0whd28qG2UBtY5FgR7IRN0g5+Y35VXXok5c+Y40+LS001+JU2ahAD3MhmfkYGrbrwRP/nxjyLT5gbCAgq9BgDd4Lfst3W0UwriwktTUVcvtT33HV/1GioHl2NsSiEOh8I7fzVT5for84tNbhMQbC8TpKAO+yqQNiITjxb9CLt3bTXb2Q7K8uLam1Pwy5/5sGZVgxkdTtgJxkqfv2NBsBcxQTf4GeZ3xRWN4KfhfrlwVzfppJMQeOklzCIYfobL+mvusJxmk0SbRZnb/epPrwBAN/g9+lAt9u334KLL01BdTSPdZA+OVFbh5bWs3ez+1vrYF27BKUH9mfnFJr0JCLaTCdahCjke2sSM5C6fq18zjU19vba49eKGW9KphvBHRocTIBgrff6OBcFewATd4Hc3F0iNYn4W/JQUxV2Omyt5uf9xkF3hE04+GZMnTuK6sI86z8j8+zMI9jgAusHPjPbu9uBzl6Ub5qdnqdTTb92yDm/VvYiRmWNQHiw103uc3In+O1CYX3SqWY55I2p5/fYwQQqt2s9Nwbn3z182PMZ9vckI0z2oqw1yO9wkA4K/vteP1RwdVt1JgGCs9Pk7FgTbwATlRYfb6bejc3XdDd+z9+O95/Id6b5q4YO77vo+LrvMYX5+zvjwcltQ8w2O8Jtw2NwFlaHs/nomT4Zn3Tqj6bjgcxfC5/PhlVde4eBY/15LsEcB0A1+hvntc8Cvlhu26VkS93XUXtYrPvybMdw1+irmtjHlcOc6r5UQZWp/1fnFJLfJzyYg2EYmKAVDZbCMW4WOxbrQO9j28XqzD5DXE0J9XQgZ7A5fH2GCie5wE8HbG7Eg2AITFJjpsQ6VWTmd9VvBuO+LkuuevW/fM+8wHIVlnd+vaY1JZtWX73//LoLflSR3cyDwS+aMD/uutkd2X5soLF4Mz9q1EVXvUs4bXrlyJTZu3GjCFKvsj071pkecG/yWyc6PzO+iyzO477RKhaIUQnJKMsrLyvHqjqe5Pysn8XN5e9NHi4kx3+iXo70xyWz1ZxMQbAMTtI2JN8i3ObVw1YY32PpTzKxxXprG1LMxGpRNJnhrBn79C1+CCbaUC0Ipi0jNrCIjoJM3ybWq2gEiC4i1/E28Ye/Hua9qECLA7d7N+5uASo79iRBwoNY4TYBSWApTAxbJyV6CX5Uxdbn66iu4f/AczvxwwK+BYZZxAlCAZn7rPwTKuVi4wjpwUE0gS8Foji6mpcG7bVtkWoH2GdGCqof4Yn9dPIHiO/bODX5ifnvF/Ah+NSwUyk21TgJAdbmKirZiG9aToYwhU2EOxjglQAVgoDK/GHE07Q63hQlS3r4AawjNg94u/jMOlx9mZUqhXJ08qCMTzKRO8PrPW51gggnGyj3yOxYEVZjDc4dDRCyPJ4hDpcA3v8m91fc6bwnoggSm558nOK3n+QWCk1gi75fQz3O0/irhO+zV4g/PAv/8NeAorwVmlRy5V5gasKioCOBHP74Xl9POb9asOTjC388+m4QjBNYN6/i9IuAFfuPjHQyH3yg5AJo7eXD4iNYLYhwWHw9uL2fKUICtYHZ2Nm688Ub8+v9+TSBWWWAXWnZl/cgdcwB0g5/V+Yn51UXAzzGElp2aCsXmbbRfGU67wFAaIVF8X1nlOJNpbvDj3N61b/QfUxebzvaelaluneCDbWCCh4MVGJ6Whw3+97Fnz3YWdicf1LjoWiCYYIJtzIlYEJQQNahgiq4XhyuDKChoLMnU9KCshMyPwdNMD/VkevsIeHI7CVaHyNZotofhrAfj8rn/+ifJ4Phc+7n/6cUQ9pV48beX63Fc7mrsKV2KETlz8b8/DOKFPyXhrbeATZuA7cXA1ClcGPxU4JKLOJhI4ATDLKQJ1BquDWncTFrFH+TsqooKJKWkQCA4mbrBkzhKvOyRZcaLegz9aVAknHIn/d391w1+sTo/CVWgZ503KZmjwNVYX/weMJSrGQdUPOScFkgRV7lKMD8jlCZ/JB8Lgjfx+sGnWl5PMMCZIRkeTv/gHiLbd20wsrXZ4TBBBwQTTLCJqOPfiAVBCtPz+HJIkzZxmhfHzwuaklzJCU1//gsbbnZLR4xwgnLPwhk3AVzHjwSAbf+TzwDHnwJcfTnHLdIIjIeCGDY8hL17Qvj1AzvxxuZ0XHtZHneEC2BMIU2ZrgU+eRaBk/UnyA8PyaYZLXu6L/6eKvVCgikH/zMHKRzVO7LAFDK8WQTB1atNRKwZzFlnnWUWUXhXc4aZrv5kH6h6ckycG/wM8+MMD8P8qPOLBb8QFR/SZxw6WILXDrPmZlBfEqDiI4yPJrvc4JdgfnHzsAkItsIE/epTsbJ8VLwK9bWaE0wdBJ1tmBJMMK6Ym78ZC4LsPnqWkQnSHa7ywlcfpLkRrbto3lVAQDqw3yFg1EAYgKunyrvsIOXPbOAqVkYfaD8WoM7vlFOYw34vvnTrh5i5YBRGj51DAhdECgc8sqjO0OcrKxxdoxQeIWEAADokSURBVOnX8uXHHmCvqhj4xOlOSIbhq6CEnWfRIqcfzjnBHnV55YHupptuwssvv4ySkhLTFTajx+F3+vLJlfTuS4Yb/CLM7/J0aLQ3FvwUC8mco+8UdjEakv0YkTQa9aDSgwioCCeYn6TUNid5tYkJUt51AcqYJHDjoRWcEsVukOkGOxXAfs2CYIIJWom0co4BQZmV4LnlyJ9BZjbMi7SMIPdpYfeUvxfO5hJlzwCnnsWBJ5p/bdxMlsYu6ut/Bd5ZBVxwvpMXXL4Ww/juR5tr8Kc/f4Tlz0zGtZcMxZNPhLBpiwdD2VXOJ6jKTZnMfGU9ozkt9rObnZROFsj9YV78E3WKvL+fOsax4+STRs9SPA4b5lDRzfy4uSt76QCnRaZgCafLPfzww8599tstOJobffQPtQDd69zgJ+a3by+Z3xUc7W0B/MQ4BHK7933MksDMCyUb/Z+pzLwf6faK+b2Z0Pm1loMWBL1k0jeRVYBMcOmVrFyFbFJ8ZCOsHBoLrA4dRXpqNj70vcu9I0owetwomlBEqyb0LQuCjTrBWtxyewgLFqWZyQXSaTG4hLMSsCDIs2fJdQhReTftPTLBq5awnBNIaIvnodAWHA9z2Ne4YItxN95k73gaTVpSqjl4eA++cNvFmDSJlYQ1ZPI04LW/ejB8JEEtlw0f8ez0TzjvblgLFO9j9/k6GxZ1jWzvKnmcSOCVsyoPKv2AN94Ap46Ym2aVGILgJM4UmUuj6eeeew6XXHKJGRDxsJHsy05FtducG/zawvyciIRI3ZnRviCKD2wzABhiTipzNAAVAT+OjSTAr+1ZZ0FQ6gTVp3g6QekBB3uoBCT7OHhwb2OFiPMZC4IJJhhHOPFuWRDkMw9NZEJ+NvIcHVa59lLd46HaJ9zbNF1d97UNztrzycj5v//rBzj/gkto6nIcGx3u+0KwU6tz2hnsLod1iSKbNpzZZJlzpju/7T0v6Q9nviGVZ90z7FTBcODD0MbSUgOACly6P7nzzjsP27dvx8cffwwvQbuv2wd2GwC6wa81nZ+RrOuP7JvqyduLy7cCpOzBcOGIgF9C5+eSVtsvm4AgmWDjHiNmfA/eEBVOBMnSsj2mIlo2Hu8rFgQbmWDCTjCenCL3YkDQoI6dciZ2GC7nKv+GjRlQct4W0MiYWeCnub1XXnm5YWO6rwkDIg0CsVQOjlB15wAfAVDhGMDjWYMr1uleSqox/TPPzff0h+EZJ/pJkxjrVA7s4Mf111+PJ598kmzUz2816gmt37507hYAdINf25mfIzbpFdRy1dfRPrB+h2EjNbSHGceYcllAroqQYH6dKWBNQPCpxtFhDhKysaGQ2eiUHykxdUEFn1Wo2U9aEIwwwfs0dzhhJ9iswGJBUPIN2wlq1EIgGHESPZ0Dcg74NVnVRWgXdgpK2afDZFsz9/WsOb+RF8ksQaNowwQVZ9VLnhWXvLw8Yxrz/PMcTqbry7rALgdAN/i1l/mF88vkQQO3udxOA2jpknI9AXCkn7P1CX5vJHR+Vk4dPTcBwTATHMKub4r0DGQGR+rLjemEuyI19z0Lgg4TTMevf979TFCVzjKS5uLVa++7QBDNzBixcXeDX7OruljPPFtwc90yl/Hux7snEDYTvgdRrzhhAsD5wcY5fWwDgvp9NhdSLS4uIkZuiwCj47Fv/e1SAHSDX3uZn1tsyhhN6ZHRVH5yOnaFqKkn81vzZl8FP6F373JNQDDMBDOSKXTqhMqrSzklrj5CCFqLvUBQc4czs5Jw/a2cMdKNTNAwDhYSq5cS4+lzLhYEVehdTFCMyw1+LTG/Lk87o2IcF0zFKg4/y4X71aYrbFbEAK7gElu/+93vwo/7Zle44wBIIbmprxv8xPy0kvPnZOrisvOT/9YLK0szw67XZEkykmKwY/Y+96p4A5g3hJh4hEpjx4sRfG/6o3poOzC61tQnOS4pwGNkrzqCjI+HR6CWQ4YZIzkwMhIPPJmDbTvZ/+X/Kq4Q4/f5nfiH801519IhJXpdLUGQc4cFgvdxPcFVKxpXkXGXFxNwe/5IoGHnZWVUHS3mjmYaABB2tF6u7Nu96BwLgkpEWCcoVUTjwgZcyTneen7dlRSVW8VlPG1wNAVl1y7nS2Eh28GP8Xw+ffp0/PWvtNOh64uMnKnroKMwHP2Q3ldr7ITz6EN12L/fS1MXLWnFJ5SjGV3SWSW1Feeh8OUrGCDrk1uXhLX/CJiVnIMEP+7h3Wud4p0ULiQpNL1P9TPC5l6ROfemPzYnjAZJpjEEvZvZ5mQ9UYarruDcYO9u5intv9gdVr61Ieuc5GkZfZLIIcOSuNFSBpY/XEcbsgbMnceAmLNh8bSpLETJixGOZD27Y79/9nG8+cHHuOee74a96alNVdSbvfuHBUGd1R1+ZDmCjzwK7/VLUKUNjO6+u/n1/LorZRKjWJ5YnwyjP6DuqaAg6muWfWtU+J577qG3RZyqN9yAoH0W9UIv/dFxAGSNEEWXC3AGgWT25OP13L0NOP/idHZhAxQGi6SA0SES8tqq0yyQYCAFVQ3VGPICzZHSk3BcSgDCEjE/y7BaDegYelDVE5AU8zjqb9A+QygLhJBVMxY5uJwm3Jk0M5Uw+KA3OsYrRPBLyqBZhM+L/3q6Ad9ekMKVQvycgkgwpElSWxovmzSBpYpGeoYHnzw3Ffd8vwF3fDmExSeomyRSkcw8dsqOfac95wYubVIwZRpt2LhcGpd6SuIUrj7tXCAYuv5aeJ9/Ar7Hn8AvuOLBpVzYILKMvWvAo9vTaxmNbAH//ncai3J6yhB2wZSBzGCVB9V/GUifc845XMjhedx8883dHq2u/kCHAVAov5eryB4xm6hwhYuyIH5+tx93fjsZe/amoLpK09kYXaFDWx0rjrrSGWkZKCrZg0v53qisIHYdpT6E4aiYtye4tn62s/4YbZaLENYS4bTxtLhryZubUbQrC/sxhdPKMtkQqOB09kvd976HecVxJwzjLIGhZYzr6iNYsXIvsrKquScLd5ATqrXDyTdFgVGjud5gtR8/+4kf3/4ud/ojQ0ziPO/9nFI1Pj+/HSE2ii81PYO7mi3A5s07jDFuuwLpjZ5VqAU4pWxouLABUq5G4JJVuOkH65DH0VgRiaR2yr/TydT31EgR4DCNFtZr1gBnnqkKysg4DY4wQOV+AU1mNE9YtoFTpkwxwKjue19wHQZAzQUcw0mMI0eOZCscxMSJHvz2yXrc93M/rrs5HWPHJrHic+jcyEHVQbncXCWyz5yRvfT0ZEwtKcDdU2mlXu3BLWUUNKcMaUpXcyH0tLBZbFHBNB5mmZnL3t6o57iEEO+Npl0WOI25Tzg28DVlwL9MJEubNA7nfPpWDM3JgY80UHZm7XGqO9nZHqznFpuL5jXgK99IR1Z2sikrsmc7yFVH2qUzkjBdrp7bBFYd5TpP/cTJCtPDWSGBCj/q7q1H5o8WIm9CEYKPLoN3yQ1MJUuYwEdAeaycBV0NhmiA5owzHPBzsUDloRrHC88/H88+/TTu5F7D1jawvY3msUqW+zsdBkCTYWEBaeECyWT23HTcdkcDHvhVA0EwgyOCXmNGpMYgFGqpAjnPNB1LRoDyn5ZKq82ZwK1DAshYloTruES7umihXgyCsylZkh54+efI8CwMrqJirZ7T+GjGI11ob3XqjCZxEYSjlcBXOK3qgU/twilHpvNuullzLhhQ/raUf9Epc8AP+HC1Hx+8HcC3/nsQwY9hsP4K/OTarSdyf56yTE5JwymnnsTwLCC4PUTHp7f/0hp7mlIWYFmvW1uPlDsooyEkA2dcAu+jjzngo6VdBH7HEgT1PVVsNoIYygKyZQs46uEwQz3joXwUGRpPk5mRfPYPjhqftnChadz6AgvsMAAK3e2onj2r4B83PxU3f0F7+tZgCZlgBs0iZB7hgGDLRVEYobB8vrCyvIjzVT/rx5KrkuB70mfmsXoIgmKCKva9DVOk5tehoY/V5dUo5IZDoxTP3hZRxklOkOEGvzsKOAh5XhKkUgvuTTVTnUyeiJ3oBTqlRde6b8+6L2fCI8hlkflt/LABK99tIPilI3uwDGjDZUCVnZXGlhnnzfb9DXGUJSk5FTNnzTAvmjjZCLYvqB73HaJcDPhVEfy+wQGjL6QgdSxL0YGwzDl3GMsJghod5mIExxwErXBPPJGrp77rAKDRbVF09hnBm0PyOJ/rB/794YcRZJe4r7BA4UjHnCpCmAEqAF2rmyQQnLcgjZPjk/EYt7es5c5u6dxkR/flp6VD4WhaT+n+PVypog6Dhg/BnrpDmFCQjqVXcSkfeRD4CQR5qTLfmw7FSc6JG4Hc+dmr4uiWlwW/KjG/fNaxc4EZZGosx0gdlMOKSf1PJJ+dN02eh/ORmRmVn4Ggx3R7N33oI/Pz4ZvfFfglh8Ev/GW+02kXDsN2obsiyE7HqQMBRIHftwh+3Io0dTbBj6oITKOcxPbkriUIKpFuO0H7zPHRfX+tcKUHPMym/dAhHtST7C9x4sQve7mWf+DJpzC0YBLGc2+Rt7UKK53m8Pd213EAjJMyyYr4FQHBzwsEaRNYEwFB8YbmnSqX7LpGc32e/PGFSNYsbYZZ60/C2AI2gATBh/S6CwSbD+3YP7HCZGcBk3gUhKPQcqrDno7xyQ1+d0wE7j+fc+C5DsIBri8nWjgqeyR35NOy+G2LmBq4LJpsbiT4Geb3X2kx4Ne2cNrjq93d6PYE3s1+o8DvPwh+1xP82HsylJxl3lBsdTMtiLQyY6TboqtKrcyVO5mrxPzH14CXXuHI8JuaMO7cJyB6DhIY9+5B4cSpeHv1GtqD1rIH0fuNoynhLnaUl/LNMsH2gqBio0qXypHgcalTDJ1q4IqQVWQlAsF4TLCLU9Cp4CxeMOZaU8A4lefe5NzgdyeZ3yPnEPwIXtso4xQNdtB+cyQZoAYAzdzgViKvvOb2EXCYXz2++Z/dD36tRKlXP44CPzG/G1zgpxqpAmMLTSwICpCONRNUHORkEnOA5jBapTWLU+XswFjWYHj/9SsInHI8hm3agNm5Y/DWB++bVyxLNz964Z+uB0AmsjNMUCxQjV4aTR3GZ042lTGFNhoUewQEezsTVD4TQ3qlzaIb/L44EXggzPy2yVaTdcuMdZBhjxg2xrHhZGtkur1KVBzXlPnFdnvjvDSAb0WBXyzzo+41AnxuGcWCoBiCaxWZCEt0v9OV16rQqpTp6cA1V1JPwu7wzo+50xIHReTKyQTXrINX29XR8PfMcz6N1RwMqeOin1YX6HjsfX+7BQBNMikz5VtHmKABQG7Rlz+CPKpOMnWiqYU7+woTVIwZ3V7l3OAn5rfMMj+OWgvkqMVFwEMkpMzzcsaZBLTUBU4wv/ZlbxT4xWN+LQUXC4ICpWPNBBW/40/kitbPU9G/GDhhvhPj8QVkhCnwvL8KwXPPRdawwZgxaTLee/8987w3s8DuA0AmXXnUXp2gKqJmg9BWFvmjCYBcE8EiiaqoGwT7AhM0JaAX/HGDXyzzM1M/qXRKZae9LLDf6KFyR44NrwcYP/IJ5hdfLs3djQK/tjK/2MBiQfBYMkFVZrnxbDnnE/imsW5mUsmjgqD5klp6mmsUYtxo4+30M8/kOgqrOKDm69UssFsB0EiCcmsvE7SsY+zoibTMlW1dHbmJlsV3sNANgr1dJ2hk0MN/3OAXxfyo81PjYvWWg7zU65ANnprxWe4rwYUS9KJtfVxpSDA/lzDacBkFfu1lfrHhx4LgsWKC+o5TIMj+5nGO6htOzHRfFVbdNh5emjmJ8Q3htLnxBMvV4R3meisL7H4ApJgko/YwQbFAyXrUqPGY6j0Olf4yDPJQy86qGg8EE0zQKYvx/rrBrwnzY75EHAWbJktzqnFmjVrMEd0hzAPHyt9ts6d8iR7tTej8IjKMcxEFfh1lfrHhxoLgsWKC+q7ccQRAToPlvrUOu9H39cwcjYXqtNNO5aLSzmBIb9UFHhMANEKjXCQfVSDZCTY3OmwAjgDop8ehnJi6IOd00w3OTCI70UM644fnBBM04mj2jxv8WmJ+NgCzag9tAqdOmMdeTZLZikDP7CCI8i4x2mul1fo5Cvw6y/xiP6fKJNYlJxMZsYzu1gnqG/pmepqzb8jatc73bZfN+cV67hi6j+YmxNksMFs0g4TO3ZCGvfb46dgBIJMq+bXGBOnFOK0Wkp6RijkTT+IoE6c+ySjX5eKBYIIJNgrIDX4tMr/wKxncDKkkuJutOjCxcKbT1oQbHDU5Ar8E82uUb2tXUeDXVcwv9qOxIHismKDiofnB4e4tlXxCt6jYaXqf3Mknn2wWStC1bUh13Ruc4nNMAdAkmgjXGhMUUBqex/OUSceZuWWHQxVI06a1LhcPBBM6QTOGYeb2aoZHW5ifRCr9X5BLmH0i+2Lkjco3y0zZAptgfq5C14bLKPDrauYX+/1YEFTl6U4maEbMWPO4L4jZZYkrwBgXA4B2h7lpnEFy5MgRs/iFylOv0AUy+lrKS3E59gBIaSmPWmaCTmuhPWnHjZ+I07MuRFVNJbKTNEco2sUDwYHMBNvL/Iw0KUTDsA8BJ039DLIGc39f7vjlFFgxP83ttTM8Ejq/6BIY/SsK/LqL+UV/0mEU7u5wdzJBkZMwu8MJJzjzg2Pjw98qO3a9UG3dueKDFcZXT3aDZUViHE9ZWVk0a0zrGQC0kYjLBDkpXPaWQc4r1UKrWYPTceq0z3KjWo62J3G4XYgX4+KB4EBkgm7wayvzU6FI4gh7rfq+VDXMnXmSaaBUUDkGYrq9zgyPhsQMj5hyF/szCvy6m/nFfvxYMkE7A2TGDK4BV+Ec7u+H42anKs7jqPHWj7eyV9HD22iG8U9le+rUqcjNzetBAKSQ4jLB39ahhoupagEFMUAx7gXHcSCElbOCf5LZEY4guasQxANBMcGH5YczG+wCCq5X+tWlG/w0t9c9w0Nybs6pMAxPysXho4dw3rAlmFA43SyGoOWvsrM82LROzK8e3zoGc3ubi2NfuB8FfseK+cUKxg1C3Tl3WAVKraN0f5oet8Jhd7HRsV1emcTk5ubio48+Ml56kgXaOAqc1U3vkS6wjYQ5U5bKN+mZIqPDD9ZxRWmuA5jhrCeYXzAFl+XdjrrKoxiRzM2FRPHjuHggeBNB8DH57ccg6Aa/f82Pntsr1h9fWo0CTEnmqN4+4BPzL8ag7FSu5Bw0S1hpSasP3hHzS3R7G6XV9CoK/I4184uNTiwICqy6QyfIYI3TBuqbNnHbC84g0rebqZvzaTy9NjxqLGDsaWcwhBWj5wGQkpA8onSCX0jG8t/S/JmglZLMGQrcF+TsE2llzkFKjzy24OKBYH9mgm7w+1Jh46oumtvblnI21JuDfQ07Mb52Cu1bTzXlWDq/jzYEsOpdH5lfAvxaKG6IAr+eYn6xEYwFQYFSV88dtt/QQqlkd9i40YmF1UWG42TBbiqXyi8/VM6tRQ6zXDauJRob9WP128arZTQ5VrHRdwiCkqmYoBZVvfWOFDx6P7vDXEpLTHvGzMU4MeVTKKkpxoikUS3GLB4I9kcm6AY/ref38LnhVV04m6N15keBU1AZyVlc2w24au6XkMPtDdLSQ9i83o/3/+HDfxD8srjFpbOYKf0nXJQEosCvp5lfVMz4wwKU7ne3naBMYrRznJy+qwoYdgIaDYYkcRHVCQUTSBbJFul6xWgw49F7AJCREWPxcvMgNSILFiVh6W0ePPFwPY5U+pA3OgsXHf8FoIhLZXGzdAk5ni5QwpWLB4L9iQm6wU/M7zeuVV2kN23dcfMp2v7tD+7iEkfAKSdewAEnLvDBJdlXv+/Dv/+n13SDtcWlNj1PuGgJRIFfb2F+0VFsCoJdzQRtF2MyV21q4LzKfdSj6J72PnA5y7Y0GrwxzBStsbTLW49ctqmqHMuYCdTUiNRxGf3FJ3DGyG3Jhgke4XpYp59xNmbXnIn9tbsw3JvXrC7QxjceCPYHJugGv/YzP0lHhRQYnsq9HvYA/zzrJ5g5pwBrVnAZ+3f8+PfvpJENpnAzJGdTq2bUOlbMA+4cBX69jfnF5kZ3MkGBnbpscvPntTgYIi/53AWwvr4e5eXlvaIbrDj1OgBUpOSUb/X1Icxld/i2L6biwfuOcmbIYHzp4m+QptAGM5XzVoVwqswtuHgg2JeZoBv8Osb8JKwQhniGY69vBxl1Ci675Epspgpnxdsc7f3vDNPtranhHh5ckUfONvTOr4H9Nwr8eivzi82iWBDsSiZouxtaIWb7di5eotFGVl5XqykGaIyOeb+wsDAyNc6pv7GRPba/ey0ASgw23zQ6fBt1gg//pg4zZpyBy8Zdgz0Hd2F06rgoQTcnungg2BeZoBv8Osb81FywwWAPJTuNRuWbgZ9e9gAOV47Gm68cNeCXPVg6P8fCIVKGTUPTnHQHzv0o8ItlftRT92pnK5Mi2ZU6QdkEqsBkkJAUFHArwHWOGGIGQ5yb2lNpOrZu2Wp+mtkiPVy2ejUASkrKNynh5y1Mxw1LQ/jzH1Jx3sl3Io2G0fuDdcjy0Di6DS4eCPYlJugGv44zP7UXIeSmjMGe8p24csznMDT7Arz/dh2+/T33aK8j0IiOtWWS3Qbp9wIvUktJiO4Kp2vds/f12/2cP62LAr9Y5if56D33N1oIy4bZ6XPsN22ANh46Wz86x4Jgc0xQfuXc77ckI9tFOOFEcBFA592Y+cFWD6hu8NGqo2Z6nO456zs5r/TE314PgBKKA4IaGMnAldf4uNn2XNyU+wOzFHcwKT+8527rSVG+qqy6V5HpC0xQZU/79trd29o32suXXS6dpuQHQkmYwg2+xqd9BUU7h+Br/8+LwYNTTEPjHvDo6cLpinbnLk3lZxBiaRasbGHQPXtfz+xzVX4dcswAs3XlUW5dKea3JLyHh57Jv4qePccLS/662tn469v2m/qGO63ueNl0KbIyYpYzxtJ88Nhy57ed5yu/8uJ+335DzyJhOa+Z2QoC07FjOEJJQrJzp/Mg0oXgK+FucDJHg/M4j3hn2E9PjwYrib3eSd6NdoKpWHprMg7tWoJRG05AZnAb97EoIAjaHGs5OSofCs8Ngr2ZCbrBrzPMz0iFifclT0Te0d1oePl7GDToBNz5tSAGD0ltAn4tS7EPPbUZrl7XuzxoH2kKgCkEvJb1hlZu50xATbdEGQ89U83gIeYngPHX+lH3P+ENjBaGex1cO9H4oxmRZiqBS+Thrzy0MTTnVaOEh8JSHLrS2TQpzA95hEmX+Y6+pzQorSt51PPg4Cwqedh0mcoUBsHrr2P6GODyR53nCqSah9JfzENp2cHjNR51PJQmpdWdLl3b+cEyiXlPAm3q7AQGTUPbujXcDbbssan3Y3JHyez1TvktgctEJhDwYPZc4D9/NBr1792HstXAhPRd7NqNZ551HAR7IxN0g19HdX6RzJUQPZNQ4NmK0l99HuddeCu+9h+pNHWxOj+V4n7mVByUrO083uEhUBJAWSeAEIBojQ0BxX/w+D8ecgKNEmfT8uCRIHy3+5DyWTK/eQQ/AkBoNQX6JP008HifRymPv/AgUw89z7PA4h88jNzDZ566xJkKwZDW8JBZ3U4eb/GwWfh3Xgu0GBfOHwWW8lCc5ARqAjCBYDkFJNC+miBYw9/PMMKbeP4j73MQzABrEZ8rPKr48AIPmy5eRjk7P3jWLMqNKEmDZ9N1c7FAOzd4woQJOHDgAOtygF6ctQMjcY8KtPt/MLW939l8FY12mKAXM2cH8faGBRj92moUcUWeCZm7OdI0nnJUqW89WbZcRjHBK3vP3GE3+HWa+ZksnoTJ6dux/fGl+Odb7saP780hA3QaFKlr+qWzQKEVmxbyOJ+HKrSEKyfgUIUWeGmlNeIALuUhMPkdj5UsTTspo58FkDozFan7CX5kjKGfE2s2sFQKUAWgaTym8LiZx0w+o2kRxvKQXPUNORsX51fX/N3CYE7n8RkeDqFywt3FEwdjDaMVCH6Vx5k8BNB/5iHGyHThD6wnf2J9UVrnXgv8ciJwGQcxahjxD5m+4fQzg89u4jGBh+RUwIPYFmHKqm5yYnIaDGEXFzMphJVqXejiDIYM5eyRdK54UiKgpLPM0Pw4xn9aR4pjHKF4n2M73HiblxYEZ8wK4vUN84GnPkARW+z8jN20wewEEyxkXhMEH9PXWIB6agEFN/h1mvkpLUGC36Dt2Pb6UnzhrLtx909HICMzaNh0vwU/pds6gY8b5O31J3j/dh5iRO/wOI3HdFbIwXxhEMWWRuZ3Czf1WeiF9+usKiqGlSyNF/Osg0WPO0lxviYP1nttJ4AHedzIQ06gqrDlFIeudoqPPdxhX8QfS3lodtpHPM7mUchjOA/FM5vHKr64iJG6TekiignMf5sHfJf3U9mn170MXnMqqmYKGZC8gWe5DB5ilrFOICi3kK3NBtqqif25BkOsHlBexo0bh6KiIl32qOsTABgWa6OgeMOC4HSC4Ob1izHqvVUoZmHLT+8kEywElhAEH9bXegAE3eDXJcxP4JdF8HufzG/uPfjfX44Mg5/XlM1GofbjK7Ex1kfTVc3lWUBVxkPgsJuHWMwQHnRiI54UMr8JXDDzq0GknpcMb0MSPOs5Yim2qFkxrNfmnR08V/EQAKorfAuPiTwswCozxQ7lmhRi53aH/ur7cqN5rOVBVopxPI7wEEtTWglaHOviemY8rFM6Z/D4Bw8fj2JGSmwwQBiQDk9gde5cVgBSy38mVRR7LOf9G3nM47XSKOdOl3PH+WtHmXNyCLZE2/C0NwOEbn+8LiwsxK5du8xdAWM8PzGvdMvPPgGAcUcjKbMICLI7/PpTC4C3P0DxYQcE+yITdINflzE/gd+apbg1n8zvR8MHFvjZ0s06bbqke3hWN1jspZ4Hi4xhfgJIkpaQll9jZQzwn+8rfnjv4ZJJ/0od1USWwHXEMAHMJB6jeAgwqe4yICH2JEBlL9JoXzbzrPB1bwIPua4EQJuukxmuwLeGh1ieepQCvTk83uAnxVAn8xDwySneiutZPC7nocZgDQ+9P4cRHMyzAPuN04FLxgB/q+ToDz/2T3xWyUB28pkAn8TAgC9PzaZLgyF2mSzLDOU/7LRfSGVlpdk2UzInxPaIEyHuu04gyAwPsAWbQRDc+NhinHDrShQvWoT8wbtRXEedoJfdYlMqbSmIn1xlgMqodIJqHccWOkww8BRwg2WCOsd/vdN33eAn5mdMXVggtzEuxjqhvV+w3d4Pl+Kf8n+Ae36Qg4xB6vYOIOanvLQZe4pLgPmu62uca2Pnl0zwk6nL8jokP0rmN4e5zfc9cxmQQPRVHnpXhUDhns5DToCqb12oH2FXzLPYlkBFRa8rC45Nl2qvgM+6qeELEjDDRO19G99C3tBh3SJeCCzf5jFBN8MBn8EXzmDr8CDp5Osvc6WMz/CZAmFCNvO8mIknS46bLgt2XAofL/PdUoah5fOlCyRDNGyPIWmzpNTUVLNU/pgxYwzz5u1j7pSqPu8sE5w5J4j3f8Om/N33u4wJ3nglLQQkIQuC3SAtN/h1KfMj+H0+7y7cc3cOMgca+Nl8CtdpU1kFRAIue4R/h3xkfuzaBrgGZd13aOpycQrS5pAK+cOByJ+OT/Kw4emse3IC15E8rD+dSaBAEmSc/Ha1s/Gw37Rp0tne01m/5Wx87TPrTwzyEzysXy6EC5n+6MWlBK4GovsjpgbwFuFiMj3OVmB08dBDAKjBEDntH2xZoPSBdALAYNgOUYuk7tMCCnQ9NRASLwkmQn3qD2XuBsGNDx2PYe9TJ8i808BIR0eHq8m+xhRycJAguEwC6QYQdINfp3V+plCHdX6rluKOcT/Az36ci8ysAcb8Ygsvy4eprCrturYHf2v3Mun8DPhphoeMnGXnp4wRw2ruXT4yYTr12vGr8O1h+1Z6rjC6wzUXNxsHnd3fjr1vf9twdNYhPacAUe76q5w0aT1BPUvhS3FGdo1f+0e6QDktlip7Py6A4B4MsSqt8ePHY/fu3Y7fHvobjmkPfb0rP8vMcYPg2w9S+K9SJ0gGLhMZ6QTbayJTyTBrCILqDncHE3SDX6eZn6loYfB7i6O9o+/GD9ntHbDMrw1lK2p6W+zc3ng1w4KdO2yBgu7HPrP39Ly3u9i4K76y67PGzdddS/Dj7+VhJmgHO5pLl/wKJLnxEAhyZkRYfsPAabvBo0aNwqFDUkoKH5N6hAXGy2YToT75h3K3IDiD3eHNz3F0+KVVKNoeBkEqOpwZI/TYilOZkC+BYHcwQTf4Geb3WfYupPNjt0s6v7Y5Jx20D2fCJ2NyGgc8fs/R3ikc7f3pyAT4tSDEKPCLndtLvbLJ/Nj3mys2uh/7LN692PB6y+/YuNt4GRAMU8GO7jFy4omN3WAvBcuyagFwOEeKGxoaUFNTYwCwaStiI9J95zZXte6LQheHzMy0IDidAyN/e4lM8AnaCa7gIFhyEdKSJyNDgKGMaFJqo+MibyobXc0E3eD3FTaQD58TBj+yTX1Q323NmbhTrzKMy1oFUyZjQmAbtn3vZnxhAUd7/5ejvQNV59ea4Pg8CvzawvzaEGa/9eJme+1ZRUYsUHo/MUCdi4udyqQpq+YZB5zTuNN3ZqZZH1BzhMNqwmMqyv4HgBKfGwRlJ7hhMca/vAYlr83gxkrbUJs8Bnk87O71LUncDYJdwQTd4BfR+Q0JMz+hbVscI6XCMja1ABWBcowu3YaiH38JX7rlBwPTzq8tMgv7iQK/tjK/doTfL73GgqAKn3SCcu5nzh3nr+0G69fixVHzg1XMg+FVo0eMGGFGgp2Xjv3f/gmAkmMMCL60YR7O8f4ZS/5/e1ce3NZRxj8dtiTLdpzEOZw0Zzs5Si/TAhMoRzrMlKtAGY42aXrQQEOhwJQb0hPowHB0uCk0HKEz5fijM23/AMpw9A6kaQgNSVsXJ+TCceokPmTJlmR+v31a6elZsmW9J1uyd8fWu/b8dve33+5+37exrSIvHpGuvqOyJLJCWnyQGSDKqSCFEYif+cUtJ2gHvzzOb8hKIJMNPIx2FseH9/A0P7hYFoTb5MihA/JarHGu67pPbr7xK/K1u7WGxwwSdRlNqqJv8sDPcH5F6VTwgx3oSuUEGYaOR2ceOQIZQggR2uPBp3k4h6a7u1t5m4qf6QuApKYNBM8GJ/jNny6T1sat8qP1j8o7et8lh3Z3QrPphCwOrYSF5LngquwQlA+GdhAshxO0g98ozm+8WkDizNu8wCJpC0ORvB8A/uhR+cySrfLec1+U9ouulDu+3og1P+r2GvAr1JHywM9wfoVINP47O3iVsiaouUBMdXESuciuXaPSIAByI0Rp4NA/nb0bWm8q9jte16tYwpMWMWjKeiMwvOLcEbl6s8iBztfJzddul29ecr80P7NKjnT8R06PvCxtIQCkvw3WgSDDkAFD+zqhHQQL7g6Hc3Vnr0M7+JXC+dm5vQaoHCyoWyLzQ4ulO3ZUjj17UNYf2SC/u+lJeU37bXLq9HL5+M0pbLj5UUYYi+ACvnF5FMgDP8P55dFmwg9OECRolbI7zGnwP6FOQ8c4Mo6GEQYGBtRZIf7Sd/90cNfXXE5cR1W9EbCO9MYIzet/4MqEPPhASC655Ap56PYnZeuqn8mafe1y7PmDciJ+TGaH5skirK81Q3tc4aANzSwQ9BXeHY6jbiMWHTJjmXoItoD7h1ZRSZwfEvBDiZNHfy4OrZBY8LR09RyS47uPyFtPbJTvveVP8p07fwEL5Otk59MJ+dTnaM9PGzOtUB3Yyl+hFCoWbR74Gc7PGzo7QZCdpNiaoPbLs4MpFrN/v8qDL8NgUCMkmUyqnWBlIp9f7Z3HmxwXjUWLaxb1MOkfbIXXt3YurOz8IDJtT7AdlqXFF5effLdPrv/oXNmw6Tp5w+svk127/yK/33m//LX/AUtvci7WKMB5BdIBSaaHJZaOwUzaaXDoFiIA0zJqcz4lJxj8zYhsHERCsAKShj015avFJ33w+Omltt1enLZGgdlMG8BtQJp8LRIKhJHHAOStB+TlGBQ7/4v4Icy9ccnNsv7yy2XN2ldJ2+KQ7N6Vkif+3Cu339UAe35BcH44wIjCqx67LN29j9rjnBaOLg/8DOdXmEjlvtXAxiunw/fdZ3GCGyEzaP/G+K3uAs0YqMbw/GCcC6J2gvGJ6nB1dXXS39cP+wlkOCx97HKzNdFw5QMgOkXempku5ERzoP2zkyEOwoaWE9JRqndU0XHpGK8FgrBkhDNGbviYT+75fp9s+lBEFi9rlQWL3qeA8MUX9sg//vkX+ePzv4aZtd0iAEKl/I4p7oLAEkyRLUAcSuPMYpxL4htKyOLlKbnq/SMy/NsRuTaG+gVlQ1AoiMN80k1LoEnyNoq6BKDbG5QGf1jCvpA639jvC8DIRlxOJI9ZiuY9SAuA+abGd8ubznm3nH/u62TpsrMkiLjqsZSyc0dcnnlqGOAXzRgzzYCfJpZLGuXT34o02yg9SsNlFksKngd+5PyuyZixV+sRJUVhPI1HATvQaRAkJ7hpUz4IUp6Qbu1aKCf8CQYZXhYfdn/TNIiKNZtoNIqlnFNQs15aQwBoQ2oNWFYpXfyCTprrYJw6Xn11EXM2KOPiOhmF0jkd3nKTT+798ZBsuA6MWzQgoUhYXomR6rz2V8vl3ZtxdsE+ee75p+XZQ4/J3/oflK7QIcueGrh5ASAKdClPgoerxybKitUBue7qemmEDvhboUt1HED4/fMD8sv1sBHZlJajw8PSGIpLf+q00jBR5ouwMUYLG7PTrfLGOQC8Na+VtasukiVLz5KmWeRUAaKYWoeCaRxanpRdT6dweluDOroy79By+PPCafozLk13ffVkapIBUY+yW7DIeeBnOL+CNPLsZSEQ5JqgkxOk/i/XobgjTGOpl15KWRi8swwjnKYF6SlwLjhAKJZlVFs4h892Eg8KwbhoLpvXrMlsD+J1RjEM8ZPz24Ny7eakbPtxXHGCYWBOH0ygB4J+md06V1oXXozDmC6W9/Rtke7jR+XI0U45eHi/dHbtl47D/5I9iSdQg2npSmErn4LMLbA0tBB2JbHeC9lreZhK8fj0705c2fnhp8XXJmdH2uXM1nNk+VmrZdkZq6WtbZnMaV0Ac1VAVKBDEv5iOIciBc2Q5mY/bB4m5enHErL1jhDAzwcJ+pQCcq13jpg9c5r+yoQ58pyZzHsSP7lJCr2m9fzfk1hzkeSBn+H8coSp5F0hEHRygujLysFSk2zbJliAlxFaj4abNWuWMo2lHib5p3wAREYJUimAXyUAUMfJzpg31faYQIPg0i58FYYhuJ/+MCYbPlgn0cYAuK6UKheFpQkEIUisLztzFQBrlaxLXipDiTgWbgckNnBaXup4TmFbV9dhmd92hqTOi0vHm4/KWXVB+dY8ICDmw6F6HDvZNFsi4Sik35vA9jdLuCEqdfVBpfrGsYS0HBhIqPL6MW1Ip30I45M9zw7Krh1p+eJtQWmZDWDEFjS5WHiviCMXqAegEejZeQ2ApCcHT9atly4P/Azn5yVpx4+rEAg6OUFyfM3Q96R5rL17LWsxiLkRGyFTZRShfADECM7FywBQnP9eO3YO/pNbqLQj+FyIXfrgTQm59x6s5X2QhwX5BRingIbMCkGYYEgmjrv14WhYok3ctACXuACiM9i86Dl5Qs5YskjqAE5d/zsJfwGZN78ZYJIrAcNTCJ5pqn/Gq8wPsawBVV7iAsNw0+zf/xqW5yA+ddtXseHRFFBhgMWVd8gDaa+4wAqkFgxQ9YnU8MblgZ/h/Lwh6kRjKQSCdk5Qd4R160QeeUR8NJcF14g1QOoD06lBUXUy9VjxH3Tl8p1uwAoc2JFd/BNZdHjmqNC9fuflFSmB6BQgxnQYa4LX3xCQ7fcOSgyGMSm/mYSVYOUygMwKYr9NA7SGh9PgFNM44CWCQaBOWlsXymAsJYMAzkGgZzwxqNbvYnw3aP3HcU0k0ireNEdE/PmAqKri1SLbiPpG8Nu7Z0h2YNr7hdtCCvy428tNHC/LXyiuQvS310+hMCW/Y5nhrKFE3br+yQM/w/m5pqerCDQIMhJujHA0JydIx2kLO8+KFdb05fBh9boBByRxxken+hcb2yQ5FwBocWg6n8y4m3/2fRVegYCONXd1E/dYYZGqSteSE7Q2Rj70kaDctw1T3AGCG6eDAMlcVmzlxGE5ajqnUEzd85l1nkuTG2L0F7D9W4Cn/diiRlrWtHfvnmHZid3eW74ccYi6uKOzTnOsqz0/vKffbP14UM/O+N0854HfNJLzG8H0gINKTTonCLIcWk5QlwkHJ/l27FDF4wlxXHKZivK6AMAarZxiLQp9nPVGTpC7w5sBgr8iJ2gDwaJBCQrFPk7gPdPGcgg4v2H5+xMJ+dLt4PzUub2VkfObQNam3muB5pYHftOI8yMQ+NRAWtn174pWqhMEOYiSE+R7Ou4GHzgAi9NDUsc1HZSZIDjZzgUAetHlJ7u4Y6fHOhrNCZYGgmPHPP5X1n1jBvx2PjUkt9yJTZMKCjmPn6Mq8+FobnngN404P7051PH8Xtmx8xnFfU8FZ+RJ7TtB0M4JEvRWrMChTM9KPe5DWG/W02BP0i4xEhcAWGIKteYNHY31luUEt3A6XFkQ1JwfNzz+/vgQOD8DfqOajZ0DxGCRPcNjGnF+BD8ul/Qc/5/84Nt3y4H/HlVkqFkAZO6dIMhnPR2msVSAfADAOISy0zgq3WSW1wCgInn+j5MT3FxBEMxyfgC/nU+C8/sywS8AADbT3vxawVOGC8w7w+Nqh4aHg1McFUcVv1BrrQD6ltb5cuPHPynNkDSgU++rON/jZs0OghSQZgfbvh0H7kBELNogfp4bAvGYVAYAx43PQw8GAIsRcxI4wdGcn1nzK1YdFJweoaA5XLI3KfFbp596G4EuDfUecoGRhlCWI+Keec07gmDGCKraHUZ9+h5+SOTi14t/924JQ6SuJOF4jwc4A4BjtKxKcoKjOL87CX6VM2wwRjGr5xP7efY/J+7DDIYgXBlowSHlkJaIfTYugY11EmyvF9ioEMiL5+QqtXxlrV4zOu/U9BnhMZRwSl60VstjzzfKwyMxVXmuuUZSJ6ED+o/HKNkv/pc6cbQDtKDsLtsW8DJz7/X0uPJSxvYC1eL9KE5QoDs8KFddH4HusB9yfhOfqmrOb29mze+WGQp+emqnr3qKazUTa2fdR9kxuAOHTkjkYKPMeRyzpU+go6yFdQg6R5+xXtbuLzWA6FauXi5nrMQUEa4Sln5UxFPyQ1AHKkJ//vhlV8pLH3lQ1vXeIc2BOZL82I0qR4Xbg5VZb+QtrLj4awAwR4uid6M5wfJB0HB+OTJrsQfu/nHapx1HeWqhdHZ0SO9Aj3Qea5OHr0rJh4GQj9/dIwthNim9D74DZAs8nhPpTEzZleWhwDu1jCggPB3LCDlYgGASRoo7rnqn9H84Ju3135DgsCUGQ5VQigEVcwRIrzhBA4DFqOx87+AEr7/BAsFNm0vnBA3nlyMqG7EWfuVVG9awfKCBw8xYV1e3+OsT8ujfXpRtcrY8BMNhG3pOy/qn5kgsQZCYbuCn6YNycc0Tj1luSH+aBlfWWirtl8YG7Hr3++WuC6+Qt8Ms3DWJGN43AxhhCIXz5CLOj7aT316KeCzhtQHAEoikvdg5wfYLISy9BYYt7slNhxOYDhez6m04P01F68oRnMYw2cF5PGKhjt46twXWsE/K5z91nsxp6pQkiPv5Ty4SWuyZ/m66gnuu5k6e9MM84Ihs/4FP/vDYEOoXpurA+fmLtIdcSC4LUK3O/qa8ewOAE6Ub2iW5cwIaQZCcoB0EuSbonJXRL41gaDm/mbrm5yS1nsbwqgAwM9vTz2euXi1LMS2qr6+TG7fMEZ4ZEY6ElIhQIcB0xm+eq5cC7EMBLGG87e0+SsJIFG2ABkXodP0XAjjyxdm692CMMABYRhtxcoJ2EIw08HCiXKTk5GnSSoHfE9TwMLu9Oerk7jQY6kZvPcPQbL3VyoeHM5seCELjFawD42qXAuwXZArIxtHsWwIDnQY21n22PVS4iAYAyyVwUU7QEmTWSxhUb9uzC1ZdoOFxqxJynuGiLjZ6q2kMnu0bILbPmVsL6exr4mP7Hx2DeVN9FLAPYKzbYVgn5pIInW4XY+VatQEApVtnANAFBQtxghSRuW5Lo+JcQiGf7HtuBIYNDPg5yczRvq+vT2bPnq2ORNSjv9MfOQF2jJ6eHvWpEXbCqDJVzL8zvHmubgoQyIZxVERvb69qD6zr8eqXdc+jNIUnzbl0BgBdEpDrfRzBcmuCI/Krnw/JpZel5KUXknKgYwhm7I1ur5PMbMSDsUHV8Mdq8ARAGt4lWDIMOwo7jAFAJ0Vr8Bl1y0OREomE2tXllWeDaGvwY5UojoNyvGgDBgDHonKJ39Avs1ZkXnlRGDJsKdn6uSFZe45PttKYKdY6jG5vPjEpxjB/wXwM4qWN4uQMeIrY3NbW/IjMU81TgAMgj8RcuXJlyaCm1gn1OpMLChgAdEG8vKAZTpBWns+7ICBfuDUoCxcFFfhRmDUYtNay8sLM8Adt/ohygAXX9cAhcJWH3w52dkrznFYAIAeTIv5nOD1rrfgEMdbtQH8/jsXsVfJ/dRCA5+BYlLujkAXkP1XbIefh0hkAdElAe3B7faxaE8BOFubGcBltLrtXcw8K6EbOq763E0aBH77FY32yb/9+WElZJCuXL1WdppB/e1hzXwMUAADSJYfi0n3ylIxkhGiLtQflOYN5XtW/1UNVzObHSwrwQCWuCxrnngLWmSkYSHBolHHThwIW/OHc66EkjoAtcWNLB/KIDIYD9IiQzmg4mNk5Qud38zw+BTjKc5oUikTlggvacQrfLBWI77ziAMbPhfFRaQr0YQp87pozpQ5TW9Ytek6lk8zGbwAwSwpzU80UmI+zZGkrj86AXzXXVOl5s8BO1A7/vMzmFt9Npo63AcDS68v4nEIKGNGXKSR+hZOmaFMTTwObAmfWAKeA6CbJiVPAcH0Tp1m1h9B1SgCcNcta3pjsPBsAnGyK12J6Hi881yIJTJ69pYB9Hbcfa4AtLS0qAQ2K3qZWPDYDgMVpY75oCkzemrRO0VxnAAUIdpT5o1ZHc6lTYI/bogHAGdDQTBENBaqNAnoDhNwfXRQ63naucLLyW/4mCJBYF0Jfvcp0Ibv/XqfhVV6d8ehK5FXnWV+dfqv5OZtnTH8tfQxvcst4s9OczNSa77LpOZLR/tU1Ix5RzK8jqHmsYgroOqTubzgcVkZxyQ0W1AhylCPbfhzvy3ksHwCRGs9toCsl08rjBH4Yty6ovk4g+JR51Xll/rVZn0rQp9IFtOe/0IBUbvqaPqSNFmzWdCoUp/av2xr91CI9C5VtJr/TdX7q1ClphQiMvX5LoYtqAxg43bqyAZBoTQsdNGeudTrdZkaHZ6NXYg94EYQlED1a6O/VfGVe6+vqhRXLSm5oaBjXvE+1lYf0p2UODYJe0p9xsc1w5I9GoyWZw6I1GNKTLhKJGGsw1dZgysjPCHTmWf8v4FB0XmM4GlO3ufHaG9unV+awfEhsQjBK77qDdHfj0BragqKbWDRWmCK/zBDToFPpqbva+NF5p8I+HUGwVsugCuBRvdobGeuWAxzbznj0mQ70VHQ0P1kK6LbA+qcIDC39cBqsjCBkfY2+0W2B/jg4L4BwvMIJ9WG0/2JvCLQMxz46YQBkpBoEiyVg3hsKGAoYClQrBewAWNYUmOhJEDTOUMBQwFDADQXcMFOK+3OTOMKWBYBM04vEXebdBDcUMBSocQpMNY4YOcAab0Am+4YChgLlU8AAYPm0MyENBQwFapwCBgBrvAJN9g0FDAXKp8D/AZIQ5TJNPoZBAAAAAElFTkSuQmCC";
