/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.jibble.epsgraphics.EpsGraphics2D;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.Renderable;
import org.opensourcephysics.media.gif.GIFEncoder;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.Tool;
import org.opensourcephysics.tools.Toolbox;

public class SnapshotTool
implements Tool {
    private static final String BUNDLE_NAME = "org.opensourcephysics.resources.tools.tools";
    private static ResourceBundle res = ResourceBundle.getBundle("org.opensourcephysics.resources.tools.tools");
    private static SnapshotTool TOOL = new SnapshotTool();
    private static JFileChooser chooser;

    public static void setLocale(Locale locale) {
        res = ResourceBundle.getBundle(BUNDLE_NAME, locale);
    }

    public static String getString(String string) {
        try {
            return res.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return String.valueOf('!') + string + '!';
        }
    }

    public static SnapshotTool getTool() {
        if (TOOL == null) {
            TOOL = new SnapshotTool();
        }
        return TOOL;
    }

    protected static void createChooser() {
        String[] stringArray = ImageIO.getWriterFormatNames();
        String[] stringArray2 = new String[stringArray.length + 2];
        stringArray2[0] = "gif";
        stringArray2[1] = "eps";
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n + 2] = stringArray[n];
            ++n;
        }
        chooser = OSPRuntime.createChooser(res.getString("SnapshotTool.ImageFiles"), stringArray2);
    }

    private SnapshotTool() {
        String string = "SnapshotTool";
        SnapshotTool.createChooser();
        Toolbox.addTool(string, this);
    }

    @Override
    public void send(Job job, Tool tool) throws RemoteException {
    }

    public boolean saveImage(String string, Component component) {
        return this.saveImage(string, component, null);
    }

    public boolean saveImage(String string, Component component, OutputStream outputStream) {
        return this.saveImage(string, component, outputStream, 1.0);
    }

    public boolean saveImage(String string, Component component, OutputStream outputStream, double d) {
        Component component2;
        String[] stringArray;
        Object object;
        if (component == null) {
            return false;
        }
        Component component3 = component;
        if (component instanceof JFrame) {
            component = ((JFrame)component).getContentPane();
        } else if (component instanceof JDialog) {
            component = ((JDialog)component).getContentPane();
        }
        BufferedImage bufferedImage = new BufferedImage(component.getWidth(), component.getHeight(), 5);
        if (component instanceof Renderable) {
            bufferedImage = ((Renderable)((Object)component)).render(bufferedImage);
        } else {
            object = bufferedImage.getGraphics();
            component.paint((Graphics)object);
            ((Graphics)object).dispose();
        }
        if (outputStream == null && string == null) {
            object = new JLabel();
            ((JLabel)object).setIcon(new ImageIcon(bufferedImage));
            JLabel jLabel = new JLabel(res.getString("SnapshotTool.Scale"));
            jLabel.setBorder(new EmptyBorder(0, 5, 0, 5));
            JTextField jTextField = new JTextField(Double.toString(d));
            stringArray = new JPanel(new BorderLayout());
            stringArray.add((Component)jLabel, "West");
            stringArray.add((Component)jTextField, "Center");
            component2 = new JPanel(new BorderLayout());
            ((Container)component2).add((Component)object, "Center");
            ((Container)component2).add((Component)stringArray, "South");
            chooser.setAccessory((JComponent)component2);
            chooser.setSelectedFile(new File("default.jpg"));
            string = OSPRuntime.chooseFilename(chooser);
            d = Double.parseDouble(jTextField.getText());
        }
        if (string == null) {
            return false;
        }
        object = "jpg";
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            object = string.substring(n + 1).toLowerCase();
        } else {
            string = String.valueOf(string) + "." + (String)object;
        }
        boolean bl = SnapshotTool.isImageFormatSupported((String)object);
        if (!(bl || "gif".equalsIgnoreCase((String)object) || "eps".equalsIgnoreCase((String)object))) {
            stringArray = new String[]{res.getString("SnapshotTool.FormatNotSupported"), res.getString("SnapshotTool.PreferredFormats")};
            JOptionPane.showMessageDialog(null, stringArray, res.getString("SnapshotTool.Error"), 2);
            return false;
        }
        stringArray = null;
        component2 = null;
        int n2 = component.getWidth();
        int n3 = component.getHeight();
        if (d <= 0.0) {
            d = 1.0;
        }
        if (d != 1.0) {
            stringArray = component3.getSize();
            n2 = (int)((double)stringArray.width * d);
            n3 = (int)((double)stringArray.height * d);
            if (component instanceof Renderable) {
                bufferedImage = new BufferedImage(n2, n3, 5);
                bufferedImage = ((Renderable)((Object)component)).render(bufferedImage);
                component.invalidate();
            } else {
                component2 = component3;
                component2.setSize(n2, n3);
                component2.validate();
                bufferedImage = new BufferedImage(component.getWidth(), component.getHeight(), 5);
                Graphics graphics = bufferedImage.getGraphics();
                component.paint(graphics);
                graphics.dispose();
                n2 = component.getWidth();
                n3 = component.getHeight();
            }
        }
        boolean bl2 = true;
        try {
            if (outputStream == null) {
                outputStream = new FileOutputStream(string);
            }
            if (bl) {
                bl2 = ImageIO.write((RenderedImage)bufferedImage, (String)object, outputStream);
            } else if ("eps".equalsIgnoreCase((String)object)) {
                EpsGraphics2D epsGraphics2D = new EpsGraphics2D("", outputStream, 0, 0, n2, n3);
                epsGraphics2D.drawImage(bufferedImage, new AffineTransform(), null);
                epsGraphics2D.scale(0.24, 0.24);
                epsGraphics2D.close();
            } else {
                try {
                    GIFEncoder gIFEncoder = new GIFEncoder(bufferedImage);
                    gIFEncoder.Write(outputStream);
                }
                catch (Exception exception) {
                    bl2 = false;
                    exception.printStackTrace();
                }
            }
            outputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl2 = false;
        }
        if (component2 != null) {
            component2.setSize(stringArray.width, stringArray.height);
            component2.validate();
        }
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isImageFormatSupported(String string) {
        try {
            String[] stringArray = ImageIO.getWriterFormatNames();
            int n = 0;
            while (true) {
                if (n >= stringArray.length) {
                    return false;
                }
                if (stringArray[n].equalsIgnoreCase(string)) {
                    return true;
                }
                ++n;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public void copyImage(Image image) {
        TransferImage transferImage = new TransferImage(image);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferImage, null);
    }

    public Image getClipboardImage() {
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        try {
            if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                Image image = (Image)transferable.getTransferData(DataFlavor.imageFlavor);
                return image;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public void copyImage(Component component) {
        new ComponentImage(component).copyToClipboard();
    }

    public void printImage(Component component) {
        new ComponentImage(component).print();
    }

    class ComponentImage
    implements Printable {
        private BufferedImage image;
        Component c;

        public ComponentImage(Component component) {
            this.c = component;
            if (component instanceof JFrame) {
                component = ((JFrame)component).getContentPane();
            } else if (component instanceof JDialog) {
                component = ((JDialog)component).getContentPane();
            }
            this.image = new BufferedImage(component.getWidth(), component.getHeight(), 5);
            if (component instanceof Renderable) {
                this.image = ((Renderable)((Object)component)).render(this.image);
            } else {
                Graphics graphics = this.image.getGraphics();
                component.paint(graphics);
                graphics.dispose();
            }
        }

        public Image getImage() {
            return this.image;
        }

        public void copyToClipboard() {
            SnapshotTool.this.copyImage(this.image);
        }

        public void print() {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            PageFormat pageFormat = new PageFormat();
            Book book = new Book();
            book.append(this, pageFormat);
            printerJob.setPageable(book);
            if (printerJob.printDialog()) {
                try {
                    printerJob.print();
                }
                catch (PrinterException printerException) {}
            }
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int n) {
            if (n >= 1) {
                return 1;
            }
            if (graphics == null) {
                return 1;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            double d = pageFormat.getImageableWidth() / (double)this.image.getWidth();
            double d2 = pageFormat.getImageableHeight() / (double)this.image.getHeight();
            double d3 = Math.min(d, d2);
            d3 = Math.min(d3, 1.0);
            graphics2D.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
            graphics2D.scale(d3, d3);
            graphics2D.drawImage((Image)this.image, 0, 0, null);
            return 0;
        }
    }

    class TransferImage
    implements Transferable {
        private Image image;

        public TransferImage(Image image) {
            this.image = image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return DataFlavor.imageFlavor.equals(dataFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.image;
        }
    }
}

