/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing2d;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.drawing2d.ElementSegment;
import org.opensourcephysics.drawing2d.utils.VectorAlgebra;

public class ElementSpring
extends ElementSegment {
    public static final double DEF_RADIUS = 0.05;
    public static final int DEF_LOOPS = 8;
    public static final int DEF_PPL = 15;
    private double radius = 0.05;
    private double solenoid = 0.0;
    private boolean thinExtremes = true;
    private int loops;
    private int pointsPerLoop;
    private boolean needsToComputePath = true;
    private double[] pixelRadius = new double[2];
    private GeneralPath path;

    public ElementSpring() {
        this.setSize(new double[]{0.1, 0.1});
        this.setResolution(8, 15);
    }

    public void setRadius(double radius) {
        this.radius = radius;
        this.setNeedToProject(true);
    }

    public double getRadius() {
        return this.radius;
    }

    public void setSolenoid(double _sol) {
        this.solenoid = _sol;
        this.needsToComputePath = true;
    }

    public double getSolenoid() {
        return this.solenoid;
    }

    public void setThinExtremes(boolean _thin) {
        this.thinExtremes = _thin;
        this.needsToComputePath = true;
    }

    public boolean isThinExtremes() {
        return this.thinExtremes;
    }

    public void setResolution(int _loops, int _ppl) {
        if (_loops == this.loops && _ppl == this.pointsPerLoop) {
            return;
        }
        this.loops = _loops;
        this.pointsPerLoop = _ppl;
        this.needsToComputePath = true;
    }

    public int getLoops() {
        return this.loops;
    }

    public int getPointsPerLoop() {
        return this.pointsPerLoop;
    }

    @Override
    public void draw(DrawingPanel _panel, Graphics _g) {
        if (!this.isReallyVisible()) {
            return;
        }
        if (this.hasChanged() || this.needsToProject()) {
            this.projectPoints();
        }
        if (this.needsToComputePath) {
            this.computePath();
        }
        Graphics2D g2 = (Graphics2D)_g;
        g2.setStroke(this.getStyle().getLineStroke());
        g2.setColor(this.getStyle().getLineColor());
        g2.draw(this.path);
    }

    @Override
    protected void projectPoints() {
        super.projectPoints();
        this.getPanel().projectSize(this.getPosition(), new double[]{this.radius, 0.0}, this.pixelRadius);
        this.needsToComputePath = true;
    }

    private void computePath() {
        int segments = this.loops * this.pointsPerLoop;
        double delta = Math.PI * 2 / (double)this.pointsPerLoop;
        double rad = this.pixelRadius[0];
        if (this.radius < 0.0) {
            delta *= -1.0;
        }
        int pre = this.pointsPerLoop / 2;
        GeneralPath newPath = new GeneralPath();
        double sx = this.pixelEnd[0] - this.pixelOrigin[0];
        double sy = this.pixelEnd[1] - this.pixelOrigin[1];
        double[] size = new double[]{sx, sy, 0.0};
        double[] u1 = VectorAlgebra.normalTo(size);
        double[] u2 = VectorAlgebra.normalize(VectorAlgebra.crossProduct(size, u1));
        int i = 0;
        while (i <= segments) {
            int k = this.thinExtremes ? (i < pre ? 0 : (i < this.pointsPerLoop ? i - pre : (i > segments - pre ? 0 : (i > segments - this.pointsPerLoop ? segments - i - pre : pre)))) : pre;
            double angle = 1.5707963267948966 + (double)i * delta;
            double cos = Math.cos(angle);
            double sin = Math.sin(angle);
            double x = this.pixelOrigin[0] + (double)i * sx / (double)segments + (double)k * rad * (cos * u1[0] + sin * u2[0]) / (double)pre;
            double y = this.pixelOrigin[1] + (double)i * sy / (double)segments + (double)k * rad * (cos * u1[1] + sin * u2[1]) / (double)pre;
            if (this.solenoid != 0.0) {
                double cte = (double)k * Math.cos((double)(i * 2) * Math.PI / (double)this.pointsPerLoop) / (double)pre;
                x += this.solenoid * cte * sx;
                y += this.solenoid * cte * sy;
            }
            if (i == 0) {
                newPath.moveTo((float)x, (float)y);
            } else {
                newPath.lineTo((float)x, (float)y);
            }
            ++i;
        }
        this.path = newPath;
        this.needsToComputePath = false;
    }
}

