/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing2d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.drawing2d.ElementSegment;

public class ElementArrow
extends ElementSegment {
    public static final int ARROW = 0;
    public static final int SEGMENT = 1;
    public static final int BOX = 2;
    public static final int TRIANGLE = 3;
    public static final int RHOMBUS = 4;
    private static final double ARROW_CST = 0.35;
    private static final double ARROW_MAX = 25.0;
    private int headPoints;
    private int[] headA;
    private int[] headB;
    private int[] secondHeadA;
    private int[] secondHeadB;

    public ElementArrow() {
        this.setSize(new double[]{0.1, 0.1});
        this.setArrowType(0);
        this.getStyle().setRelativePosition(5);
        this.headPoints = 0;
        this.headA = new int[7];
        this.headB = new int[7];
        this.secondHeadA = new int[4];
        this.secondHeadB = new int[4];
    }

    public void setArrowType(int _type) {
        this.arrowType = _type;
        this.setNeedToProject(true);
    }

    public int getArrowType() {
        return this.arrowType;
    }

    @Override
    public void draw(DrawingPanel _panel, Graphics _g) {
        if (!this.isReallyVisible()) {
            return;
        }
        if (this.hasChanged() || this.needsToProject()) {
            this.projectPoints();
        }
        this.drawHead((Graphics2D)_g);
    }

    @Override
    protected void projectPoints() {
        super.projectPoints();
        if (this.arrowType == 1) {
            this.headPoints = 2;
            this.headA[0] = (int)this.pixelOrigin[0];
            this.headB[0] = (int)this.pixelOrigin[1];
            this.headA[1] = (int)this.pixelEnd[0];
            this.headB[1] = (int)this.pixelEnd[1];
            return;
        }
        double a = this.pixelEnd[0] - this.pixelOrigin[0];
        double b = this.pixelEnd[1] - this.pixelOrigin[1];
        double h = Math.sqrt(a * a + b * b);
        if (h == 0.0) {
            this.headPoints = 2;
            this.headA[0] = (int)this.pixelOrigin[0];
            this.headB[0] = (int)this.pixelOrigin[1];
            this.headA[1] = (int)this.pixelEnd[0];
            this.headB[1] = (int)this.pixelEnd[1];
            return;
        }
        a = 0.35 * a / h;
        b = 0.35 * b / h;
        if (this.arrowType == 4) {
            a *= 0.9;
            b *= 0.9;
        } else if (this.arrowType == 3) {
            a *= 2.0;
            b *= 2.0;
        } else if (h > 25.0) {
            a *= 25.0 / h;
            b *= 25.0 / h;
        }
        double p0 = this.pixelEnd[0] - a * h;
        double q0 = this.pixelEnd[1] - b * h;
        a *= h / 2.0;
        b *= h / 2.0;
        switch (this.arrowType) {
            default: {
                this.headPoints = 6;
                this.headA[0] = (int)p0;
                this.headB[0] = (int)q0;
                this.headA[1] = (int)(p0 - b);
                this.headB[1] = (int)(q0 + a);
                this.headA[2] = (int)this.pixelEnd[0];
                this.headB[2] = (int)this.pixelEnd[1];
                this.headA[3] = (int)(p0 + b);
                this.headB[3] = (int)(q0 - a);
                this.headA[4] = (int)p0;
                this.headB[4] = (int)q0;
                this.headA[5] = (int)this.pixelOrigin[0];
                this.headB[5] = (int)this.pixelOrigin[1];
                break;
            }
            case 2: {
                this.headPoints = 7;
                this.headA[0] = (int)p0;
                this.headB[0] = (int)q0;
                this.headA[1] = (int)(p0 - b);
                this.headB[1] = (int)(q0 + a);
                this.headA[2] = (int)(this.pixelEnd[0] - b);
                this.headB[2] = (int)(this.pixelEnd[1] + a);
                this.headA[3] = (int)(this.pixelEnd[0] + b);
                this.headB[3] = (int)(this.pixelEnd[1] - a);
                this.headA[4] = (int)(p0 + b);
                this.headB[4] = (int)(q0 - a);
                this.headA[5] = (int)p0;
                this.headB[5] = (int)q0;
                this.headA[6] = (int)this.pixelOrigin[0];
                this.headB[6] = (int)this.pixelOrigin[1];
                break;
            }
            case 3: {
                this.headPoints = 4;
                this.headA[0] = (int)(this.pixelOrigin[0] - b);
                this.headB[0] = (int)(this.pixelOrigin[1] + a);
                this.headA[1] = (int)(this.pixelOrigin[0] + b);
                this.headB[1] = (int)(this.pixelOrigin[1] - a);
                this.headA[2] = (int)this.pixelEnd[0];
                this.headB[2] = (int)this.pixelEnd[1];
                this.headA[3] = this.headA[0];
                this.headB[3] = this.headB[0];
                break;
            }
            case 4: {
                double centerA = (this.pixelOrigin[0] + this.pixelEnd[0]) / 2.0;
                double centerB = (this.pixelOrigin[1] + this.pixelEnd[1]) / 2.0;
                this.headPoints = 4;
                this.headA[0] = (int)this.pixelEnd[0];
                this.headB[0] = (int)this.pixelEnd[1];
                this.headA[1] = (int)(centerA - b);
                this.headB[1] = (int)(centerB + a);
                this.headA[2] = (int)(centerA + b);
                this.headB[2] = (int)(centerB - a);
                this.headA[3] = this.headA[0];
                this.headB[3] = this.headB[0];
                this.secondHeadA[0] = (int)this.pixelOrigin[0];
                this.secondHeadB[0] = (int)this.pixelOrigin[1];
                this.secondHeadA[1] = this.headA[1];
                this.secondHeadB[1] = this.headB[1];
                this.secondHeadA[2] = this.headA[2];
                this.secondHeadB[2] = this.headB[2];
                this.secondHeadA[3] = this.secondHeadA[0];
                this.secondHeadB[3] = this.secondHeadB[0];
            }
        }
    }

    private void drawHead(Graphics2D _g2) {
        Paint fill = this.getStyle().getFillColor();
        _g2.setStroke(this.getStyle().getLineStroke());
        if (this.arrowType == 4) {
            Color extra;
            if (fill != null) {
                _g2.setPaint(fill);
                _g2.fillPolygon(this.headA, this.headB, 4);
            }
            if ((extra = this.getStyle().getExtraColor()) != null) {
                _g2.setPaint(extra);
                _g2.fillPolygon(this.secondHeadA, this.secondHeadB, 4);
            }
            return;
        }
        if (this.headPoints > 2 && fill != null && this.getStyle().isDrawingFill()) {
            _g2.setPaint(fill);
            _g2.fillPolygon(this.headA, this.headB, this.headPoints - 1);
        }
        _g2.setColor(this.getStyle().getLineColor());
        _g2.drawPolyline(this.headA, this.headB, this.headPoints);
    }
}

