function sustainability(_topFrame,_libraryPath,_codebasePath, _inputParameters) {
  var _model = EJSS_CORE.createAnimationLMS();
  var _view;
  var _isPlaying = false;
  var _isPaused = true;
  var _isMobile = (navigator===undefined) ? false : navigator.userAgent.match(/iPhone|iPad|iPod|Android|BlackBerry|Opera Mini|IEMobile/i);

var _stringProperties = {};
  var _tools = EJSS_CORE.Tools;
  function _play()  { _isPaused = false; _isPlaying = true;  _model.play();  }
  function _pause() { _isPaused = true;  _isPlaying = false; _model.pause(); }
  function _step()  { _pause();  _model.step(); }
  function _reset() { _model.reset();  _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); }
  _model._play  = _play;
  _model._pause = _pause;
  _model._step  = _step;
  _model._reset = _reset;
  function _update() { _model.update(); }
  function _initialize() { _model.initialize(); }
  function _setFPS(_fps) { _model.setFPS(_fps); }
  function _setDelay(_delay) { _model.setDelay(_delay); }
  function _setStepsPerDisplay(_spd) { _model.setStepsPerDisplay(_spd); }
  function _setUpdateView(_updateView) { _model.setUpdateView(_updateView); }
  function _setAutoplay(_auto) { _model.setAutoplay(_auto); }
  function _println(_message) { console.log(_message); }

  function _breakAfterThisPage() { _model.setShouldBreak(true); }

  function _resetSolvers() { if (_model.resetSolvers) _model.resetSolvers(); }

  function _saveText(name,type,content) { if (_model.saveText) _model.saveText(name,type,content); }

  function _saveState(name) { if (_model.saveState) _model.saveState(name); }

  function _saveImage(name,panelname) { if (_model.saveImage) _model.saveImage(name,panelname); }

  function _readState(url,type) { if (_model.readState) _model.readState(url,type); }

  function _readText(url,type,varname) { if (_model.readText) _model.readText(url,type,varname); }

  function _getStringProperty(propertyName) {
    var _value = _stringProperties[propertyName];
    if (_value===undefined) return propertyName;
    else return _value;
  }
  var __pagesEnabled = [];
  function _setPageEnabled(pageName,enabled) { __pagesEnabled[pageName] = enabled; }

  var gameLevel; // EjsS Model.Variables.Var Table.gameLevel
  var offsetYCtoBasketOpening; // EjsS Model.Variables.Var Table.offsetYCtoBasketOpening
  var isEncouragePageClicked; // EjsS Model.Variables.Var Table.isEncouragePageClicked
  var isScorePageClicked; // EjsS Model.Variables.Var Table.isScorePageClicked
  var currentPage; // EjsS Model.Variables.Var Table.currentPage
  var t; // EjsS Model.Variables.Var Table.t
  var dt; // EjsS Model.Variables.Var Table.dt
  var vocabaudio; // EjsS Model.Variables.Var Table.vocabaudio
  var shouldShowBins; // EjsS Model.Variables.Var Table.shouldShowBins

  var binWidth; // EjsS Model.Variables.bins.binWidth
  var binHeight; // EjsS Model.Variables.bins.binHeight
  var draggerPosX; // EjsS Model.Variables.bins.draggerPosX
  var spacingBetweenBins; // EjsS Model.Variables.bins.spacingBetweenBins
  var isItemInBin; // EjsS Model.Variables.bins.isItemInBin
  var symbolHeight; // EjsS Model.Variables.bins.symbolHeight
  var symbolWidth; // EjsS Model.Variables.bins.symbolWidth

  var x; // EjsS Model.Variables.recyclables.x
  var y; // EjsS Model.Variables.recyclables.y
  var gapSizeBetweenRecyclableAndName; // EjsS Model.Variables.recyclables.gapSizeBetweenRecyclableAndName
  var recyclableName; // EjsS Model.Variables.recyclables.recyclableName
  var recyclableNameContainerHeight; // EjsS Model.Variables.recyclables.recyclableNameContainerHeight
  var recyclableNameContainerWidth; // EjsS Model.Variables.recyclables.recyclableNameContainerWidth
  var recyclableNameContainerPosX; // EjsS Model.Variables.recyclables.recyclableNameContainerPosX
  var recyclableNameContainerPosY; // EjsS Model.Variables.recyclables.recyclableNameContainerPosY
  var recyclableImageUrl; // EjsS Model.Variables.recyclables.recyclableImageUrl
  var recyclables; // EjsS Model.Variables.recyclables.recyclables
  var vx; // EjsS Model.Variables.recyclables.vx
  var vy; // EjsS Model.Variables.recyclables.vy
  var ay; // EjsS Model.Variables.recyclables.ay
  var v; // EjsS Model.Variables.recyclables.v
  var theta; // EjsS Model.Variables.recyclables.theta
  var thetadeg; // EjsS Model.Variables.recyclables.thetadeg
  var recyclableTitleFontSize; // EjsS Model.Variables.recyclables.recyclableTitleFontSize
  var itemIsNotFlying; // EjsS Model.Variables.recyclables.itemIsNotFlying
  var recyclableItemWidth; // EjsS Model.Variables.recyclables.recyclableItemWidth
  var recyclableItemHeight; // EjsS Model.Variables.recyclables.recyclableItemHeight
  var currentRecycalable; // EjsS Model.Variables.recyclables.currentRecycalable

  var round; // EjsS Model.Variables.game.round
  var playerMissed; // EjsS Model.Variables.game.playerMissed
  var hasClickedTryAgain; // EjsS Model.Variables.game.hasClickedTryAgain
  var separation; // EjsS Model.Variables.game.separation
  var progressPercentage; // EjsS Model.Variables.game.progressPercentage
  var gameStarted; // EjsS Model.Variables.game.gameStarted
  var isMuted; // EjsS Model.Variables.game.isMuted
  var hitDaFloor; // EjsS Model.Variables.game.hitDaFloor
  var isCorrect; // EjsS Model.Variables.game.isCorrect
  var showAnswerModal; // EjsS Model.Variables.game.showAnswerModal
  var questions; // EjsS Model.Variables.game.questions
  var summary; // EjsS Model.Variables.game.summary

  var kheight; // EjsS Model.Variables.height.kheight

  var _privateOdesList;
  var _ODEi_evolution1;
  var userEvents1=[];

  _model.getOdes = function() { return [_ODEi_evolution1]; };

  _model.removeEvents = function(){
    userEvents1=[];
  };

  function _serialize() { return _model.serialize(); }

  _model._userSerialize = function() {
    return {
      gameLevel : gameLevel,
      offsetYCtoBasketOpening : offsetYCtoBasketOpening,
      isEncouragePageClicked : isEncouragePageClicked,
      isScorePageClicked : isScorePageClicked,
      currentPage : currentPage,
      t : t,
      dt : dt,
      vocabaudio : vocabaudio,
      shouldShowBins : shouldShowBins,
      binWidth : binWidth,
      binHeight : binHeight,
      draggerPosX : draggerPosX,
      spacingBetweenBins : spacingBetweenBins,
      isItemInBin : isItemInBin,
      symbolHeight : symbolHeight,
      symbolWidth : symbolWidth,
      x : x,
      y : y,
      gapSizeBetweenRecyclableAndName : gapSizeBetweenRecyclableAndName,
      recyclableName : recyclableName,
      recyclableNameContainerHeight : recyclableNameContainerHeight,
      recyclableNameContainerWidth : recyclableNameContainerWidth,
      recyclableNameContainerPosX : recyclableNameContainerPosX,
      recyclableNameContainerPosY : recyclableNameContainerPosY,
      recyclableImageUrl : recyclableImageUrl,
      recyclables : recyclables,
      vx : vx,
      vy : vy,
      ay : ay,
      v : v,
      theta : theta,
      thetadeg : thetadeg,
      recyclableTitleFontSize : recyclableTitleFontSize,
      itemIsNotFlying : itemIsNotFlying,
      recyclableItemWidth : recyclableItemWidth,
      recyclableItemHeight : recyclableItemHeight,
      currentRecycalable : currentRecycalable,
      round : round,
      playerMissed : playerMissed,
      hasClickedTryAgain : hasClickedTryAgain,
      separation : separation,
      progressPercentage : progressPercentage,
      gameStarted : gameStarted,
      isMuted : isMuted,
      hitDaFloor : hitDaFloor,
      isCorrect : isCorrect,
      showAnswerModal : showAnswerModal,
      questions : questions,
      summary : summary,
      kheight : kheight
    };
  };

  _model._readParameters = function(json) {
    if(typeof json.gameLevel != "undefined") gameLevel = json.gameLevel;
    if(typeof json.offsetYCtoBasketOpening != "undefined") offsetYCtoBasketOpening = json.offsetYCtoBasketOpening;
    if(typeof json.isEncouragePageClicked != "undefined") isEncouragePageClicked = json.isEncouragePageClicked;
    if(typeof json.isScorePageClicked != "undefined") isScorePageClicked = json.isScorePageClicked;
    if(typeof json.currentPage != "undefined") currentPage = json.currentPage;
    if(typeof json.t != "undefined") t = json.t;
    if(typeof json.dt != "undefined") dt = json.dt;
    if(typeof json.vocabaudio != "undefined") vocabaudio = json.vocabaudio;
    if(typeof json.shouldShowBins != "undefined") shouldShowBins = json.shouldShowBins;
    if(typeof json.binWidth != "undefined") binWidth = json.binWidth;
    if(typeof json.binHeight != "undefined") binHeight = json.binHeight;
    if(typeof json.draggerPosX != "undefined") draggerPosX = json.draggerPosX;
    if(typeof json.spacingBetweenBins != "undefined") spacingBetweenBins = json.spacingBetweenBins;
    if(typeof json.isItemInBin != "undefined") isItemInBin = json.isItemInBin;
    if(typeof json.symbolHeight != "undefined") symbolHeight = json.symbolHeight;
    if(typeof json.symbolWidth != "undefined") symbolWidth = json.symbolWidth;
    if(typeof json.x != "undefined") x = json.x;
    if(typeof json.y != "undefined") y = json.y;
    if(typeof json.gapSizeBetweenRecyclableAndName != "undefined") gapSizeBetweenRecyclableAndName = json.gapSizeBetweenRecyclableAndName;
    if(typeof json.recyclableName != "undefined") recyclableName = json.recyclableName;
    if(typeof json.recyclableNameContainerHeight != "undefined") recyclableNameContainerHeight = json.recyclableNameContainerHeight;
    if(typeof json.recyclableNameContainerWidth != "undefined") recyclableNameContainerWidth = json.recyclableNameContainerWidth;
    if(typeof json.recyclableNameContainerPosX != "undefined") recyclableNameContainerPosX = json.recyclableNameContainerPosX;
    if(typeof json.recyclableNameContainerPosY != "undefined") recyclableNameContainerPosY = json.recyclableNameContainerPosY;
    if(typeof json.recyclableImageUrl != "undefined") recyclableImageUrl = json.recyclableImageUrl;
    if(typeof json.recyclables != "undefined") recyclables = json.recyclables;
    if(typeof json.vx != "undefined") vx = json.vx;
    if(typeof json.vy != "undefined") vy = json.vy;
    if(typeof json.ay != "undefined") ay = json.ay;
    if(typeof json.v != "undefined") v = json.v;
    if(typeof json.theta != "undefined") theta = json.theta;
    if(typeof json.thetadeg != "undefined") thetadeg = json.thetadeg;
    if(typeof json.recyclableTitleFontSize != "undefined") recyclableTitleFontSize = json.recyclableTitleFontSize;
    if(typeof json.itemIsNotFlying != "undefined") itemIsNotFlying = json.itemIsNotFlying;
    if(typeof json.recyclableItemWidth != "undefined") recyclableItemWidth = json.recyclableItemWidth;
    if(typeof json.recyclableItemHeight != "undefined") recyclableItemHeight = json.recyclableItemHeight;
    if(typeof json.currentRecycalable != "undefined") currentRecycalable = json.currentRecycalable;
    if(typeof json.round != "undefined") round = json.round;
    if(typeof json.playerMissed != "undefined") playerMissed = json.playerMissed;
    if(typeof json.hasClickedTryAgain != "undefined") hasClickedTryAgain = json.hasClickedTryAgain;
    if(typeof json.separation != "undefined") separation = json.separation;
    if(typeof json.progressPercentage != "undefined") progressPercentage = json.progressPercentage;
    if(typeof json.gameStarted != "undefined") gameStarted = json.gameStarted;
    if(typeof json.isMuted != "undefined") isMuted = json.isMuted;
    if(typeof json.hitDaFloor != "undefined") hitDaFloor = json.hitDaFloor;
    if(typeof json.isCorrect != "undefined") isCorrect = json.isCorrect;
    if(typeof json.showAnswerModal != "undefined") showAnswerModal = json.showAnswerModal;
    if(typeof json.questions != "undefined") questions = json.questions;
    if(typeof json.summary != "undefined") summary = json.summary;
    if(typeof json.kheight != "undefined") kheight = json.kheight;
  };

  function _unserialize(json) { return _model.unserialize(json); }

  _model.addToReset(function() {
    __pagesEnabled["resizeGameObjectsOnGraph"] = true;
    __pagesEnabled["pageNavigation"] = true;
    __pagesEnabled["modals"] = true;
    __pagesEnabled["alert"] = true;
    __pagesEnabled["Evol Page"] = true;
    __pagesEnabled["hitTheFloor"] = true;
    __pagesEnabled["recycleBin"] = true;
    __pagesEnabled["wasteBin"] = true;
  });

  _model.addToReset(function() {
    gameLevel = 1; // EjsS Model.Variables.Var Table.gameLevel
    offsetYCtoBasketOpening = 0.7; // EjsS Model.Variables.Var Table.offsetYCtoBasketOpening
    isEncouragePageClicked = false; // EjsS Model.Variables.Var Table.isEncouragePageClicked
    isScorePageClicked = false; // EjsS Model.Variables.Var Table.isScorePageClicked
    currentPage = "introduction"; // EjsS Model.Variables.Var Table.currentPage
    t = 0; // EjsS Model.Variables.Var Table.t
    dt = 0.015; // EjsS Model.Variables.Var Table.dt
    vocabaudio = 0; // EjsS Model.Variables.Var Table.vocabaudio
    shouldShowBins = true; // EjsS Model.Variables.Var Table.shouldShowBins
  });

  _model.addToReset(function() {
    binWidth = 150; // EjsS Model.Variables.bins.binWidth
    binHeight = 250; // EjsS Model.Variables.bins.binHeight
    draggerPosX = 8.4; // EjsS Model.Variables.bins.draggerPosX
    spacingBetweenBins = 1.3; // EjsS Model.Variables.bins.spacingBetweenBins
    isItemInBin = false; // EjsS Model.Variables.bins.isItemInBin
    symbolHeight = 0; // EjsS Model.Variables.bins.symbolHeight
    symbolWidth = 0; // EjsS Model.Variables.bins.symbolWidth
  });

  _model.addToReset(function() {
    x = 1.4; // EjsS Model.Variables.recyclables.x
    y = 1; // EjsS Model.Variables.recyclables.y
    gapSizeBetweenRecyclableAndName = .6; // EjsS Model.Variables.recyclables.gapSizeBetweenRecyclableAndName
    recyclableName = "Cereal Box"; // EjsS Model.Variables.recyclables.recyclableName
    recyclableNameContainerHeight = 0; // EjsS Model.Variables.recyclables.recyclableNameContainerHeight
    recyclableNameContainerWidth = 0; // EjsS Model.Variables.recyclables.recyclableNameContainerWidth
    recyclableNameContainerPosX = 1.4; // EjsS Model.Variables.recyclables.recyclableNameContainerPosX
    recyclableNameContainerPosY = y - gapSizeBetweenRecyclableAndName; // EjsS Model.Variables.recyclables.recyclableNameContainerPosY
    recyclableImageUrl = ""; // EjsS Model.Variables.recyclables.recyclableImageUrl
    recyclables = [ {     imageFileName: "cereal-box.svg",     name: "Cereal Box",     correct: "Cereal boxes are made from paperboard and can be recycled.",     incorrect: "Cereal boxes are made from paperboard and can be recycled."   } , {     imageFileName: "rinsed-used-jar.svg",     name: "Glass Jar",     correct: "You can recycle glass jars only after you have rinsed them and are free from contamination.",     incorrect: "You can recycle glass jars only after you have rinsed it and  are free from contamination."   } , {     imageFileName: "food-cans.svg",     name: "Food Cans",     correct: "They can be recycled as they are made out of metal. Dispose them if they are completely rusty!",     incorrect: "They can be recycled as they are made out of metal. Dispose them if they are completely rusty!"   } , {     imageFileName: "egg-tray.svg",     name: "Plastic Egg Tray",     correct: "They can be melted for recycling as they are made out of plastic. Discard them if they’re too dirty or greasy!",     incorrect: "They can be melted for recycling as they are made out of plastic. Discard them if they’re too dirty or greasy!"   } , {     imageFileName: "plastic-food-packaging.svg",     name: "Plastic Food Packaging",     correct: "These have to be rinsed before recycling. Discard them if they’re too dirty or greasy!",     incorrect: "These have to be rinsed before recycling. Discard them if they’re too dirty or greasy!"   } , {     imageFileName: "toys-1.png",     name: "Toys",     correct: "These have to be discarded if they are no longer in good condition.  Donate them if they can be reused!",     incorrect: "These have to be discarded if they are no longer in good condition.  Donate them if they can be reused!"   } ]; // EjsS Model.Variables.recyclables.recyclables
    vx = 2*2; // EjsS Model.Variables.recyclables.vx
    vy = 4*2; // EjsS Model.Variables.recyclables.vy
    ay = -7.5; // EjsS Model.Variables.recyclables.ay
    v = Math.sqrt(vx*vx+vy*vy); // EjsS Model.Variables.recyclables.v
    theta = Math.atan2(vy,vx); // EjsS Model.Variables.recyclables.theta
    thetadeg = theta*180/Math.PI; // EjsS Model.Variables.recyclables.thetadeg
    recyclableTitleFontSize = ""; // EjsS Model.Variables.recyclables.recyclableTitleFontSize
    itemIsNotFlying = true; // EjsS Model.Variables.recyclables.itemIsNotFlying
    recyclableItemWidth = 0; // EjsS Model.Variables.recyclables.recyclableItemWidth
    recyclableItemHeight = 0; // EjsS Model.Variables.recyclables.recyclableItemHeight
    currentRecycalable = ""; // EjsS Model.Variables.recyclables.currentRecycalable
  });

  _model.addToReset(function() {
    round = 1; // EjsS Model.Variables.game.round
    playerMissed = false; // EjsS Model.Variables.game.playerMissed
    hasClickedTryAgain = false; // EjsS Model.Variables.game.hasClickedTryAgain
    separation = 10; // EjsS Model.Variables.game.separation
    progressPercentage = 0; // EjsS Model.Variables.game.progressPercentage
    gameStarted = false; // EjsS Model.Variables.game.gameStarted
    isMuted = false; // EjsS Model.Variables.game.isMuted
    hitDaFloor = false; // EjsS Model.Variables.game.hitDaFloor
    isCorrect = false; // EjsS Model.Variables.game.isCorrect
    showAnswerModal = false; // EjsS Model.Variables.game.showAnswerModal
    questions = {      "Q1": {      recyclable: "Cereal Box", choice: "",      answer: "Recycle Bin "+"✅",      description: "Cereal boxes are made from paperboard and can be recycled."  }, "Q2": {      recyclable: "Rinsed Used Glass Jar",      choice: "",      answer: "Recycle Bin "+"✅",      description: "You can recycle glass jars only after you have rinsed them and are free of contamination."  }, "Q3": {      recyclable: "Food Cans",      choice: "",      answer: "Recycle Bin "+"✅",      description: "They can be recycled as they are made out of metal. Dispose them if they are completely rusty!"  }, "Q4": {          recyclable: "Plastic Egg Trays",          choice: "",          answer: "Recycle Bin "+"✅",          description: "They can be melted for recycling as they are made out of plastic. Discard them if they’re too dirty/greasy!"  }, "Q5": {      recyclable: "Plastic Food Packaging",      choice: "",      answer: "Waste Bin "+"✅",      description: "These have to be rinsed before recycling. Discard them if they’re too dirty/greasy!"  }, "Q6": {          recyclable: "Toys",           choice: "",           answer: "Waste Bin "+"✅",           description: "These have to be discarded if they are no longer in good condition. Donate if they can be reused!" }      }; // EjsS Model.Variables.game.questions
    summary = ""; // EjsS Model.Variables.game.summary
  });

  _model.addToReset(function() {
    kheight = 0.96; // EjsS Model.Variables.height.kheight
  });

  if (_inputParameters) {
    _inputParameters = _model.parseInputParameters(_inputParameters);
    if (_inputParameters) _model.addToReset(function() { _model._readParameters(_inputParameters); });
  }

  _model.addToReset(function() {
    _privateOdesList=[];
    _ODEi_evolution1 = _ODE_evolution1();
    _privateOdesList.push(_ODEi_evolution1);
  });

  _model.addToReset(function() {
    _model.setAutoplay(false);
    _model.setPauseOnPageExit(true);
    _model.setFPS(100);
    _model.setStepsPerDisplay(1);
  });

  // Why this class was created as an upgrade to the previous version of the library.  // > CustomCode.MoodleDataAnalyticsIibrary:1
  // Benefits:  // > CustomCode.MoodleDataAnalyticsIibrary:2
  // 1. Reduce global namespace pollution  // > CustomCode.MoodleDataAnalyticsIibrary:3
  // 2. Code is more understandable,   // > CustomCode.MoodleDataAnalyticsIibrary:4
  //    e.g.   // > CustomCode.MoodleDataAnalyticsIibrary:5
  //    moodle.startQuestion('...') provides context to the developer that startQuestion function/method  // > CustomCode.MoodleDataAnalyticsIibrary:6
  //    belongs to the moodle library that is meant for analytics as opposed to being a custom function  // > CustomCode.MoodleDataAnalyticsIibrary:7
  // How to use this Moodle Analytics library.  // > CustomCode.MoodleDataAnalyticsIibrary:8
  // At the bottom of this script, an instance of the MoodleDataAnalyticsLibrary class is created.  // > CustomCode.MoodleDataAnalyticsIibrary:9
  // use ONLY that instance everywhere in EJSS where you wish to interact with moodle analytics.  // > CustomCode.MoodleDataAnalyticsIibrary:10
  // DO NOT create your own instance and use it.  // > CustomCode.MoodleDataAnalyticsIibrary:11
  // E.g. in another Custom tab, if you wish to record a score to a question, just write code like so..  // > CustomCode.MoodleDataAnalyticsIibrary:12
  // moodle.startQuestion('Q'+index);  // > CustomCode.MoodleDataAnalyticsIibrary:13
  // moodle.addQuestionHistory(userSelection);  // > CustomCode.MoodleDataAnalyticsIibrary:14
  // moodle.awardQuestionMarks(questionPointsScored);  // > CustomCode.MoodleDataAnalyticsIibrary:15
  // moodle.endQuestion();  // > CustomCode.MoodleDataAnalyticsIibrary:16
  class MoodleDataAnalyticsLibrary {  // > CustomCode.MoodleDataAnalyticsIibrary:17
    constructor() {  // > CustomCode.MoodleDataAnalyticsIibrary:18
      this.debugMode = true;  // > CustomCode.MoodleDataAnalyticsIibrary:19
      this._nullFunction = this.debugMode ? console.log : function(){};  // > CustomCode.MoodleDataAnalyticsIibrary:20
      this._questionLib = {  // > CustomCode.MoodleDataAnalyticsIibrary:21
        stack: [],  // > CustomCode.MoodleDataAnalyticsIibrary:22
        history: Object.create(null),  // > CustomCode.MoodleDataAnalyticsIibrary:23
        questionMarksAwarded: Object.create(null)  // > CustomCode.MoodleDataAnalyticsIibrary:24
      };  // > CustomCode.MoodleDataAnalyticsIibrary:25
    }  // > CustomCode.MoodleDataAnalyticsIibrary:26
      // > CustomCode.MoodleDataAnalyticsIibrary:27
    _debugPrint(msg) {  // > CustomCode.MoodleDataAnalyticsIibrary:28
      if (this.debugMode) {  // > CustomCode.MoodleDataAnalyticsIibrary:29
        console.log(msg);  // > CustomCode.MoodleDataAnalyticsIibrary:30
      }  // > CustomCode.MoodleDataAnalyticsIibrary:31
    }  // > CustomCode.MoodleDataAnalyticsIibrary:32
      // > CustomCode.MoodleDataAnalyticsIibrary:33
    _getCurrentQuestion() {  // > CustomCode.MoodleDataAnalyticsIibrary:34
      if (!this.isQuestionStarted()) {  // > CustomCode.MoodleDataAnalyticsIibrary:35
        return null;  // > CustomCode.MoodleDataAnalyticsIibrary:36
      }  // > CustomCode.MoodleDataAnalyticsIibrary:37
      return this._questionLib.stack[this._questionLib.stack.length - 1];  // > CustomCode.MoodleDataAnalyticsIibrary:38
    }  // > CustomCode.MoodleDataAnalyticsIibrary:39
      // > CustomCode.MoodleDataAnalyticsIibrary:40
    isQuestionStarted() {  // > CustomCode.MoodleDataAnalyticsIibrary:41
      /*  // > CustomCode.MoodleDataAnalyticsIibrary:42
       * Use this function to determine whether a question is pending (has started but has not ended).  // > CustomCode.MoodleDataAnalyticsIibrary:43
       *   // > CustomCode.MoodleDataAnalyticsIibrary:44
       * No Parameters  // > CustomCode.MoodleDataAnalyticsIibrary:45
       *  // > CustomCode.MoodleDataAnalyticsIibrary:46
       * return value:  // > CustomCode.MoodleDataAnalyticsIibrary:47
       * Boolean  // > CustomCode.MoodleDataAnalyticsIibrary:48
       */  // > CustomCode.MoodleDataAnalyticsIibrary:49
      return this._questionLib.stack.length > 0;  // > CustomCode.MoodleDataAnalyticsIibrary:50
    }  // > CustomCode.MoodleDataAnalyticsIibrary:51
      // > CustomCode.MoodleDataAnalyticsIibrary:52
    startQuestion(questionName) {  // > CustomCode.MoodleDataAnalyticsIibrary:53
      /*  // > CustomCode.MoodleDataAnalyticsIibrary:54
       * This function should be called whenever the student first sees the question,   // > CustomCode.MoodleDataAnalyticsIibrary:55
       * and the student cannot start answering any other question. The question may be subsequently   // > CustomCode.MoodleDataAnalyticsIibrary:56
       * ended by calling endQuestion function.  // > CustomCode.MoodleDataAnalyticsIibrary:57
       *   // > CustomCode.MoodleDataAnalyticsIibrary:58
       * Parameters:  // > CustomCode.MoodleDataAnalyticsIibrary:59
       * questionName: string  // > CustomCode.MoodleDataAnalyticsIibrary:60
       *  // > CustomCode.MoodleDataAnalyticsIibrary:61
       * return value:  // > CustomCode.MoodleDataAnalyticsIibrary:62
       * undefined  // > CustomCode.MoodleDataAnalyticsIibrary:63
       */  // > CustomCode.MoodleDataAnalyticsIibrary:64
      _view._addInteraction(this._nullFunction,   // > CustomCode.MoodleDataAnalyticsIibrary:65
                            {  // > CustomCode.MoodleDataAnalyticsIibrary:66
                              action:"questionStart",   // > CustomCode.MoodleDataAnalyticsIibrary:67
                              name:questionName  // > CustomCode.MoodleDataAnalyticsIibrary:68
                            },  // > CustomCode.MoodleDataAnalyticsIibrary:69
                            {  // > CustomCode.MoodleDataAnalyticsIibrary:70
                              element:"questionLib",   // > CustomCode.MoodleDataAnalyticsIibrary:71
                              property:"value"  // > CustomCode.MoodleDataAnalyticsIibrary:72
                            }  // > CustomCode.MoodleDataAnalyticsIibrary:73
                         );  // > CustomCode.MoodleDataAnalyticsIibrary:74
      this._debugPrint("Start question: " + questionName);  // > CustomCode.MoodleDataAnalyticsIibrary:75
      this._questionLib.stack.push(questionName);  // > CustomCode.MoodleDataAnalyticsIibrary:76
    }  // > CustomCode.MoodleDataAnalyticsIibrary:77
      // > CustomCode.MoodleDataAnalyticsIibrary:78
    endQuestion() {  // > CustomCode.MoodleDataAnalyticsIibrary:79
      /*  // > CustomCode.MoodleDataAnalyticsIibrary:80
       * This function should be called whenever the student submits/finalises their answer for the question.  // > CustomCode.MoodleDataAnalyticsIibrary:81
       *   // > CustomCode.MoodleDataAnalyticsIibrary:82
       * No Parameters  // > CustomCode.MoodleDataAnalyticsIibrary:83
       *  // > CustomCode.MoodleDataAnalyticsIibrary:84
       * return value:  // > CustomCode.MoodleDataAnalyticsIibrary:85
       * undefined  // > CustomCode.MoodleDataAnalyticsIibrary:86
       */  // > CustomCode.MoodleDataAnalyticsIibrary:87
      if (this._questionLib.stack.length > 0) {  // > CustomCode.MoodleDataAnalyticsIibrary:88
        const questionName = this._questionLib.stack.pop();  // > CustomCode.MoodleDataAnalyticsIibrary:89
        this._debugPrint("End question: " + questionName);  // > CustomCode.MoodleDataAnalyticsIibrary:90
        _view._addInteraction(this._nullFunction,   // > CustomCode.MoodleDataAnalyticsIibrary:91
                              {  // > CustomCode.MoodleDataAnalyticsIibrary:92
                                action:"questionEnd",   // > CustomCode.MoodleDataAnalyticsIibrary:93
                                name:questionName  // > CustomCode.MoodleDataAnalyticsIibrary:94
                              },   // > CustomCode.MoodleDataAnalyticsIibrary:95
                              {  // > CustomCode.MoodleDataAnalyticsIibrary:96
                                element: "questionLib",   // > CustomCode.MoodleDataAnalyticsIibrary:97
                                property: "value"  // > CustomCode.MoodleDataAnalyticsIibrary:98
                              }  // > CustomCode.MoodleDataAnalyticsIibrary:99
                            );  // > CustomCode.MoodleDataAnalyticsIibrary:100
      }  // > CustomCode.MoodleDataAnalyticsIibrary:101
    }  // > CustomCode.MoodleDataAnalyticsIibrary:102
      // > CustomCode.MoodleDataAnalyticsIibrary:103
    // for assessment.json history  // > CustomCode.MoodleDataAnalyticsIibrary:104
    addQuestionHistory(history, questionName=null) {  // > CustomCode.MoodleDataAnalyticsIibrary:105
    /*  // > CustomCode.MoodleDataAnalyticsIibrary:106
     * Adds an entry to the question history to the specified question, or to the pending question by default.   // > CustomCode.MoodleDataAnalyticsIibrary:107
     * If adding to the question history of the pending question, it also flushes the history. (which makes Moodle able to read the history)  // > CustomCode.MoodleDataAnalyticsIibrary:108
     *  // > CustomCode.MoodleDataAnalyticsIibrary:109
     * Parameters:  // > CustomCode.MoodleDataAnalyticsIibrary:110
     * history: string, questionName?: string  // > CustomCode.MoodleDataAnalyticsIibrary:111
     *  // > CustomCode.MoodleDataAnalyticsIibrary:112
     * return value:  // > CustomCode.MoodleDataAnalyticsIibrary:113
     * undefined  // > CustomCode.MoodleDataAnalyticsIibrary:114
     *  // > CustomCode.MoodleDataAnalyticsIibrary:115
     * questioName:  // > CustomCode.MoodleDataAnalyticsIibrary:116
     * This is the name of the question that the history will be added to. If this parameter is not set, by default, the history entry  // > CustomCode.MoodleDataAnalyticsIibrary:117
     * will be added to the pending question.  // > CustomCode.MoodleDataAnalyticsIibrary:118
     */  // > CustomCode.MoodleDataAnalyticsIibrary:119
      // > CustomCode.MoodleDataAnalyticsIibrary:120
      if (questionName === null && this.isQuestionStarted()) {  // > CustomCode.MoodleDataAnalyticsIibrary:121
        questionName = this._getCurrentQuestion();  // > CustomCode.MoodleDataAnalyticsIibrary:122
      }  // > CustomCode.MoodleDataAnalyticsIibrary:123
      // > CustomCode.MoodleDataAnalyticsIibrary:124
      if (!(questionName in this._questionLib.history)) {  // > CustomCode.MoodleDataAnalyticsIibrary:125
        this._debugPrint("Create question history for " + questionName);  // > CustomCode.MoodleDataAnalyticsIibrary:126
        this._questionLib.history[questionName] = [];  // > CustomCode.MoodleDataAnalyticsIibrary:127
      }  // > CustomCode.MoodleDataAnalyticsIibrary:128
      if (this.debugMode) {  // > CustomCode.MoodleDataAnalyticsIibrary:129
        console.log("Push \"" + history + "\" to question history for " + questionName);  // > CustomCode.MoodleDataAnalyticsIibrary:130
      }  // > CustomCode.MoodleDataAnalyticsIibrary:131
      this._questionLib.history[questionName].push(history);  // > CustomCode.MoodleDataAnalyticsIibrary:132
      this._flushQuestionHistory(questionName);  // > CustomCode.MoodleDataAnalyticsIibrary:133
      }  // > CustomCode.MoodleDataAnalyticsIibrary:134
        // > CustomCode.MoodleDataAnalyticsIibrary:135
    _flushQuestionHistory(questionName) {  // > CustomCode.MoodleDataAnalyticsIibrary:136
      if (questionName === this._getCurrentQuestion()) {  // > CustomCode.MoodleDataAnalyticsIibrary:137
        const outputHistory = this._getQuestionHistory(questionName);  // > CustomCode.MoodleDataAnalyticsIibrary:138
        _view._addInteraction(this._nullFunction,   // > CustomCode.MoodleDataAnalyticsIibrary:139
                              outputHistory,   // > CustomCode.MoodleDataAnalyticsIibrary:140
                              {  // > CustomCode.MoodleDataAnalyticsIibrary:141
                                property: "historyFor" + questionName,   // > CustomCode.MoodleDataAnalyticsIibrary:142
                                element: "questionLib"  // > CustomCode.MoodleDataAnalyticsIibrary:143
                              }  // > CustomCode.MoodleDataAnalyticsIibrary:144
                             );  // > CustomCode.MoodleDataAnalyticsIibrary:145
      }  // > CustomCode.MoodleDataAnalyticsIibrary:146
    }  // > CustomCode.MoodleDataAnalyticsIibrary:147
      // > CustomCode.MoodleDataAnalyticsIibrary:148
    _getQuestionHistory(questionName) {  // > CustomCode.MoodleDataAnalyticsIibrary:149
      if (questionName in this._questionLib.history) {  // > CustomCode.MoodleDataAnalyticsIibrary:150
        return this._questionLib.history[questionName].join("\n");  // > CustomCode.MoodleDataAnalyticsIibrary:151
      } else {  // > CustomCode.MoodleDataAnalyticsIibrary:152
        _debugPrint("No question \"" + questionName + "\" exists");  // > CustomCode.MoodleDataAnalyticsIibrary:153
        return "";  // > CustomCode.MoodleDataAnalyticsIibrary:154
      }  // > CustomCode.MoodleDataAnalyticsIibrary:155
    }  // > CustomCode.MoodleDataAnalyticsIibrary:156
      // > CustomCode.MoodleDataAnalyticsIibrary:157
    onAnswer(answer, isCorrect=false, history=answer, questionName=null) {  // > CustomCode.MoodleDataAnalyticsIibrary:158
    /*  // > CustomCode.MoodleDataAnalyticsIibrary:159
     * Indicates that the student made an attempt to answer the question,   // > CustomCode.MoodleDataAnalyticsIibrary:160
     * writes the history, and adds a log for the submitted answer.   // > CustomCode.MoodleDataAnalyticsIibrary:161
     * However, it does not give marks in itself (that is done by awardQuestionMarks)  // > CustomCode.MoodleDataAnalyticsIibrary:162
     *   // > CustomCode.MoodleDataAnalyticsIibrary:163
     * Parameters:  // > CustomCode.MoodleDataAnalyticsIibrary:164
     * answer: String  // > CustomCode.MoodleDataAnalyticsIibrary:165
     * A string representing what the student chose as the answer to the question.   // > CustomCode.MoodleDataAnalyticsIibrary:166
     * This can be used in an advanced assessment.json generator to check the answers on the server side.  // > CustomCode.MoodleDataAnalyticsIibrary:167
     *  // > CustomCode.MoodleDataAnalyticsIibrary:168
     * isCorrect?: Boolean   // > CustomCode.MoodleDataAnalyticsIibrary:169
     * Whether the student's answer is correct (defaults to false)  // > CustomCode.MoodleDataAnalyticsIibrary:170
     *  // > CustomCode.MoodleDataAnalyticsIibrary:171
     * history: String   // > CustomCode.MoodleDataAnalyticsIibrary:172
     * A textual representation of what the student chose as the answer to the question.   // > CustomCode.MoodleDataAnalyticsIibrary:173
     * By default, this is the same as the value given in the parameter answer.   // > CustomCode.MoodleDataAnalyticsIibrary:174
     * This parameter controls what the teacher will see when they hover their cursor over the student's marks for this question.  // > CustomCode.MoodleDataAnalyticsIibrary:175
     *  // > CustomCode.MoodleDataAnalyticsIibrary:176
     * questionName?: String   // > CustomCode.MoodleDataAnalyticsIibrary:177
     * The name of the question the student is giving an answer to.   // > CustomCode.MoodleDataAnalyticsIibrary:178
     * By default, this is the pending question.   // > CustomCode.MoodleDataAnalyticsIibrary:179
     * However, this can be overridden using this parameter to write the answer history to some other question.  // > CustomCode.MoodleDataAnalyticsIibrary:180
     */  // > CustomCode.MoodleDataAnalyticsIibrary:181
      if (questionName === null && this.isQuestionStarted()) {  // > CustomCode.MoodleDataAnalyticsIibrary:182
        questionName = this._questionLib.stack[this._questionLib.stack.length - 1];  // > CustomCode.MoodleDataAnalyticsIibrary:183
      }  // > CustomCode.MoodleDataAnalyticsIibrary:184
      // > CustomCode.MoodleDataAnalyticsIibrary:185
      if (questionName !== null) {  // > CustomCode.MoodleDataAnalyticsIibrary:186
        const explainer = Object.create(null);  // > CustomCode.MoodleDataAnalyticsIibrary:187
        explainer[true] = " ✅";  // > CustomCode.MoodleDataAnalyticsIibrary:188
        explainer[false] = " ❌";  // > CustomCode.MoodleDataAnalyticsIibrary:189
        this.addQuestionHistory(history + explainer[isCorrect], questionName);  // > CustomCode.MoodleDataAnalyticsIibrary:190
        if (questionName === this._getCurrentQuestion()) {  // > CustomCode.MoodleDataAnalyticsIibrary:191
          _view._addInteraction(this._nullFunction, {name:questionName, answer:answer, isCorrect:isCorrect, action:"questionAnswer"}, {property: "answer", element:"questionLib"});  // > CustomCode.MoodleDataAnalyticsIibrary:192
        }  // > CustomCode.MoodleDataAnalyticsIibrary:193
      }  // > CustomCode.MoodleDataAnalyticsIibrary:194
    }  // > CustomCode.MoodleDataAnalyticsIibrary:195
      // > CustomCode.MoodleDataAnalyticsIibrary:196
      // > CustomCode.MoodleDataAnalyticsIibrary:197
    awardQuestionMarks(marks=1) {  // > CustomCode.MoodleDataAnalyticsIibrary:198
    /*  // > CustomCode.MoodleDataAnalyticsIibrary:199
     * Awards a number of marks to the student for the pending question.  // > CustomCode.MoodleDataAnalyticsIibrary:200
     *   // > CustomCode.MoodleDataAnalyticsIibrary:201
     * Parameters:  // > CustomCode.MoodleDataAnalyticsIibrary:202
     * marks?: int   // > CustomCode.MoodleDataAnalyticsIibrary:203
     *  // > CustomCode.MoodleDataAnalyticsIibrary:204
     * The number of marks to award to the student. By default, this value is 1.  // > CustomCode.MoodleDataAnalyticsIibrary:205
     */  // > CustomCode.MoodleDataAnalyticsIibrary:206
    if (this.isQuestionStarted()) {  // > CustomCode.MoodleDataAnalyticsIibrary:207
      const questionName = this._getCurrentQuestion();  // > CustomCode.MoodleDataAnalyticsIibrary:208
      this._questionLib.questionMarksAwarded[questionName] = marks;  // > CustomCode.MoodleDataAnalyticsIibrary:209
      _view._addInteraction(  // > CustomCode.MoodleDataAnalyticsIibrary:210
        this._nullFunction,   // > CustomCode.MoodleDataAnalyticsIibrary:211
        this._questionLib.questionMarksAwarded[questionName],   // > CustomCode.MoodleDataAnalyticsIibrary:212
        {  // > CustomCode.MoodleDataAnalyticsIibrary:213
          element: "questionLib",   // > CustomCode.MoodleDataAnalyticsIibrary:214
          property: "awardMarkFor"+questionName  // > CustomCode.MoodleDataAnalyticsIibrary:215
        }  // > CustomCode.MoodleDataAnalyticsIibrary:216
      );  // > CustomCode.MoodleDataAnalyticsIibrary:217
    }  // > CustomCode.MoodleDataAnalyticsIibrary:218
  }  // > CustomCode.MoodleDataAnalyticsIibrary:219
      // > CustomCode.MoodleDataAnalyticsIibrary:220
    resetQuestionMarks(questionName) {  // > CustomCode.MoodleDataAnalyticsIibrary:221
    /*  // > CustomCode.MoodleDataAnalyticsIibrary:222
     * Reset the awarded marks for the indicated question to 0 the next time the question is started.  // > CustomCode.MoodleDataAnalyticsIibrary:223
     *   // > CustomCode.MoodleDataAnalyticsIibrary:224
     * Parameters:   // > CustomCode.MoodleDataAnalyticsIibrary:225
     * questionName: string  // > CustomCode.MoodleDataAnalyticsIibrary:226
     *  // > CustomCode.MoodleDataAnalyticsIibrary:227
     * return value:   // > CustomCode.MoodleDataAnalyticsIibrary:228
     * undefined  // > CustomCode.MoodleDataAnalyticsIibrary:229
     *  // > CustomCode.MoodleDataAnalyticsIibrary:230
     * questionName:  // > CustomCode.MoodleDataAnalyticsIibrary:231
     * The name of the question to reset.  // > CustomCode.MoodleDataAnalyticsIibrary:232
     */  // > CustomCode.MoodleDataAnalyticsIibrary:233
      this._questionLib.questionMarksAwarded[questionName] = 0;  // > CustomCode.MoodleDataAnalyticsIibrary:234
    }  // > CustomCode.MoodleDataAnalyticsIibrary:235
    questionInstantMark(questionName, message) {  // > CustomCode.MoodleDataAnalyticsIibrary:236
    /*  // > CustomCode.MoodleDataAnalyticsIibrary:237
     * A convenience function to start a question, award a mark, (optionally) add a history entry, and end the question.  // > CustomCode.MoodleDataAnalyticsIibrary:238
     * This function should be called whenever a student answers a question correctly.  // > CustomCode.MoodleDataAnalyticsIibrary:239
     * It instantly submits the correct answer to the Moodle server, and gives the student a mark.   // > CustomCode.MoodleDataAnalyticsIibrary:240
     * For most cases, this function would suffice.  // > CustomCode.MoodleDataAnalyticsIibrary:241
     *   // > CustomCode.MoodleDataAnalyticsIibrary:242
     * Parameters:   // > CustomCode.MoodleDataAnalyticsIibrary:243
     * questionName: string, message?: string  // > CustomCode.MoodleDataAnalyticsIibrary:244
     *  // > CustomCode.MoodleDataAnalyticsIibrary:245
     * return value:   // > CustomCode.MoodleDataAnalyticsIibrary:246
     * undefined  // > CustomCode.MoodleDataAnalyticsIibrary:247
     *  // > CustomCode.MoodleDataAnalyticsIibrary:248
     * questionName:  // > CustomCode.MoodleDataAnalyticsIibrary:249
     * These values are the names of the questions that will be displayed on the analytics page on Moodle,   // > CustomCode.MoodleDataAnalyticsIibrary:250
     * and they'll be needed when you make the assessment.json file so please remember to note down what   // > CustomCode.MoodleDataAnalyticsIibrary:251
     * values you use for the name of each question.  // > CustomCode.MoodleDataAnalyticsIibrary:252
     *   // > CustomCode.MoodleDataAnalyticsIibrary:253
     * message:   // > CustomCode.MoodleDataAnalyticsIibrary:254
     * What Moodle will display when the teacher hovers their mouse over the student's mark for a particular question.  // > CustomCode.MoodleDataAnalyticsIibrary:255
     */  // > CustomCode.MoodleDataAnalyticsIibrary:256
    this.startQuestion(questionName);  // > CustomCode.MoodleDataAnalyticsIibrary:257
    this._debugPrint("" + message);  // > CustomCode.MoodleDataAnalyticsIibrary:258
    if (message) {  // > CustomCode.MoodleDataAnalyticsIibrary:259
      this.addQuestionHistory(message);  // > CustomCode.MoodleDataAnalyticsIibrary:260
    } else {  // > CustomCode.MoodleDataAnalyticsIibrary:261
      this._flushQuestionHistory(questionName);  // > CustomCode.MoodleDataAnalyticsIibrary:262
    }  // > CustomCode.MoodleDataAnalyticsIibrary:263
    this.awardQuestionMarks();  // > CustomCode.MoodleDataAnalyticsIibrary:264
    this.endQuestion();  // > CustomCode.MoodleDataAnalyticsIibrary:265
  }  // > CustomCode.MoodleDataAnalyticsIibrary:266
    questionAppendHistory(questionName, message) {  // > CustomCode.MoodleDataAnalyticsIibrary:267
    /*  // > CustomCode.MoodleDataAnalyticsIibrary:268
     * Adds a history entry to the given question.  // > CustomCode.MoodleDataAnalyticsIibrary:269
     *   // > CustomCode.MoodleDataAnalyticsIibrary:270
     * Parameters:   // > CustomCode.MoodleDataAnalyticsIibrary:271
     * questionName: string, message?: string  // > CustomCode.MoodleDataAnalyticsIibrary:272
     *  // > CustomCode.MoodleDataAnalyticsIibrary:273
     * return value:   // > CustomCode.MoodleDataAnalyticsIibrary:274
     * undefined  // > CustomCode.MoodleDataAnalyticsIibrary:275
     *  // > CustomCode.MoodleDataAnalyticsIibrary:276
     * questionName:  // > CustomCode.MoodleDataAnalyticsIibrary:277
     * The name of the question to append the history entry to.  // > CustomCode.MoodleDataAnalyticsIibrary:278
     *   // > CustomCode.MoodleDataAnalyticsIibrary:279
     * message:  // > CustomCode.MoodleDataAnalyticsIibrary:280
     * The history entry to add to the question.  // > CustomCode.MoodleDataAnalyticsIibrary:281
     */  // > CustomCode.MoodleDataAnalyticsIibrary:282
    if (!(questionName in this._questionLib.questionMarksAwarded)) {  // > CustomCode.MoodleDataAnalyticsIibrary:283
      this._questionLib.questionMarksAwarded[questionName] = 0;  // > CustomCode.MoodleDataAnalyticsIibrary:284
    }  // > CustomCode.MoodleDataAnalyticsIibrary:285
    let shouldPushQuestion = this._getCurrentQuestion() !== questionName;  // > CustomCode.MoodleDataAnalyticsIibrary:286
    if (shouldPushQuestion) {  // > CustomCode.MoodleDataAnalyticsIibrary:287
      this.startQuestion(questionName);  // > CustomCode.MoodleDataAnalyticsIibrary:288
    }  // > CustomCode.MoodleDataAnalyticsIibrary:289
    this.awardQuestionMarks(this._questionLib.questionMarksAwarded[questionName])  // > CustomCode.MoodleDataAnalyticsIibrary:290
    this.addQuestionHistory(message);  // > CustomCode.MoodleDataAnalyticsIibrary:291
    if (shouldPushQuestion) {  // > CustomCode.MoodleDataAnalyticsIibrary:292
      this.endQuestion();  // > CustomCode.MoodleDataAnalyticsIibrary:293
    }  // > CustomCode.MoodleDataAnalyticsIibrary:294
  }  // > CustomCode.MoodleDataAnalyticsIibrary:295
    resetQuestionHistory(questionName) {  // > CustomCode.MoodleDataAnalyticsIibrary:296
    /*  // > CustomCode.MoodleDataAnalyticsIibrary:297
     * Clear/reset the history of the indicated question.  // > CustomCode.MoodleDataAnalyticsIibrary:298
     *   // > CustomCode.MoodleDataAnalyticsIibrary:299
     * Parameters:   // > CustomCode.MoodleDataAnalyticsIibrary:300
     * questionName: string  // > CustomCode.MoodleDataAnalyticsIibrary:301
     *  // > CustomCode.MoodleDataAnalyticsIibrary:302
     * return value:   // > CustomCode.MoodleDataAnalyticsIibrary:303
     * undefined  // > CustomCode.MoodleDataAnalyticsIibrary:304
     *  // > CustomCode.MoodleDataAnalyticsIibrary:305
     * questionName:  // > CustomCode.MoodleDataAnalyticsIibrary:306
     * The name of the question to reset.  // > CustomCode.MoodleDataAnalyticsIibrary:307
     */    // > CustomCode.MoodleDataAnalyticsIibrary:308
      this._questionLib.history[questionName] = [];  // > CustomCode.MoodleDataAnalyticsIibrary:309
    }  // > CustomCode.MoodleDataAnalyticsIibrary:310
    resetQuestion(questionName) {  // > CustomCode.MoodleDataAnalyticsIibrary:311
    /*  // > CustomCode.MoodleDataAnalyticsIibrary:312
     * A convenience function to reset the marks and history of an indicated question.  // > CustomCode.MoodleDataAnalyticsIibrary:313
     */    // > CustomCode.MoodleDataAnalyticsIibrary:314
      this.resetQuestionHistory(questionName);  // > CustomCode.MoodleDataAnalyticsIibrary:315
      this.resetQuestionMarks(questionName);  // > CustomCode.MoodleDataAnalyticsIibrary:316
    }  // > CustomCode.MoodleDataAnalyticsIibrary:317
  }  // > CustomCode.MoodleDataAnalyticsIibrary:318
  let moodle = new MoodleDataAnalyticsLibrary();  // > CustomCode.MoodleDataAnalyticsIibrary:319

  async function callFuncAfterSomeSeconds(seconds, callback) {  // > CustomCode.utils:1
    await sleep(seconds);   // > CustomCode.utils:2
    callback();  // > CustomCode.utils:3
  }  // > CustomCode.utils:4

  function sleep(seconds) {  // > CustomCode.sleep:1
    return new Promise(resolve => setTimeout(resolve, seconds * 1000));  // > CustomCode.sleep:2
  }  // > CustomCode.sleep:3

  function showModal() {  // > CustomCode.modals:1
    console.log('show modal');  // > CustomCode.modals:2
    document.getElementById('modal').style.display = "flex";  // > CustomCode.modals:3
    document.getElementById('overlay').style.display = "block";  // > CustomCode.modals:4
  }  // > CustomCode.modals:5
  function hideModal() {  // > CustomCode.modals:6
    document.getElementById('modal').style.display = "none";  // > CustomCode.modals:7
    document.getElementById('overlay').style.display = "none";  // > CustomCode.modals:8
  }  // > CustomCode.modals:9

  function resetRecyclableItemAttributes () {  // > CustomCode.recyclables:1
    x=1.4;  // > CustomCode.recyclables:2
    y=1;  // > CustomCode.recyclables:3
    vx=v*Math.cos(theta);  // > CustomCode.recyclables:4
    vy=v*Math.sin(theta);  // > CustomCode.recyclables:5
  }  // > CustomCode.recyclables:6
  function getRecyclableAttribute(attributeName, recyclableName) {  // > CustomCode.recyclables:7
    let filtered = [];  // > CustomCode.recyclables:8
    for (let i= 0; i<recyclables.length; i++) {  // > CustomCode.recyclables:9
      if (recyclables[i].name === recyclableName) {  // > CustomCode.recyclables:10
        filtered = [...filtered, recyclables[i]];  // > CustomCode.recyclables:11
      }  // > CustomCode.recyclables:12
    }  // > CustomCode.recyclables:13
    return filtered[0][attributeName];  // > CustomCode.recyclables:14
  }  // > CustomCode.recyclables:15
  function getIndexOfRecyclable(recyclableName) {  // > CustomCode.recyclables:16
    function checkName(recyclable) {  // > CustomCode.recyclables:17
      return recyclable.name === recyclableName;  // > CustomCode.recyclables:18
    }  // > CustomCode.recyclables:19
    return recyclables.findIndex(checkName);  // > CustomCode.recyclables:20
  }  // > CustomCode.recyclables:21
  function showRightOrWrongSymbol(result, binType) {  // > CustomCode.recyclables:22
    if (result == "correct" && binType == "recycle") {  // > CustomCode.recyclables:23
      _view.r_correct.setVisible(true);  // > CustomCode.recyclables:24
    }  // > CustomCode.recyclables:25
    if (result == "incorrect" && binType == "recycle") {  // > CustomCode.recyclables:26
      _view.r_incorrect.setVisible(true);  // > CustomCode.recyclables:27
    }  // > CustomCode.recyclables:28
    if (result == "correct" && binType == "waste") {  // > CustomCode.recyclables:29
      _view.w_correct.setVisible(true);  // > CustomCode.recyclables:30
    }  // > CustomCode.recyclables:31
    if (result == "incorrect" && binType == "waste") {  // > CustomCode.recyclables:32
      _view.w_incorrect.setVisible(true);  // > CustomCode.recyclables:33
    }  // > CustomCode.recyclables:34
    return;  // > CustomCode.recyclables:35
  }  // > CustomCode.recyclables:36
  function hideAllRightOrWrongSymbols () {  // > CustomCode.recyclables:37
    _view.r_correct.setVisible(false);  // > CustomCode.recyclables:38
    _view.r_incorrect.setVisible(false);  // > CustomCode.recyclables:39
    _view.w_correct.setVisible(false);  // > CustomCode.recyclables:40
    _view.w_incorrect.setVisible(false);  // > CustomCode.recyclables:41
  }  // > CustomCode.recyclables:42

  function showBins() {  // > CustomCode.bins:1
    document.getElementById('bins').style.display = "block";  // > CustomCode.bins:2
  }  // > CustomCode.bins:3
  function hideBins() {  // > CustomCode.bins:4
      console.log('hide bins');  // > CustomCode.bins:5
    document.getElementById('bins').style.display = "none";  // > CustomCode.bins:6
  }  // > CustomCode.bins:7

  function generateRandomRecyclable () {  // > CustomCode.random:1
    let randomIndex = getRandomInteger(0, recyclables.length - 1);  // > CustomCode.random:2
    document.getElementById('recyclableItem').setAttribute('xlink:href', './sustainability/images/'+recyclables[randomIndex].imageFileName)  // > CustomCode.random:3
    recyclableName = recyclables[randomIndex].name;  // > CustomCode.random:4
  }  // > CustomCode.random:5
  function getRandomInteger(lowerBound, upperBound) {  // > CustomCode.random:6
    // Ensure the lower bound is less than or equal to the upper bound  // > CustomCode.random:7
    if (lowerBound > upperBound) {  // > CustomCode.random:8
      [lowerBound, upperBound] = [upperBound, lowerBound];  // > CustomCode.random:9
    }  // > CustomCode.random:10
    // Generate a random number within the range  // > CustomCode.random:11
    const range = upperBound - lowerBound + 1;  // > CustomCode.random:12
    const randomInteger = Math.floor(Math.random() * range) + lowerBound;  // > CustomCode.random:13
    return randomInteger;  // > CustomCode.random:14
  }  // > CustomCode.random:15

  function updateModal (title, body) {  // > CustomCode.updateModal:1
    document.querySelector('#modal > #title').innerHTML = title;  // > CustomCode.updateModal:2
    document.querySelector('#modal > #body').innerHTML = body;  // > CustomCode.updateModal:3
  }  // > CustomCode.updateModal:4

  function updateProgressBar(level) {  // > CustomCode.updateProgressBar:1
    var progressLevel = document.getElementById("progressLevel");  // > CustomCode.updateProgressBar:2
    progressLevel.style.width = level + "%";  // > CustomCode.updateProgressBar:3
    if (level == 0) {  // > CustomCode.updateProgressBar:4
      progressLevel.classList.add("emptybar");  // > CustomCode.updateProgressBar:5
      progressLevel.classList.remove("fullbar");  // > CustomCode.updateProgressBar:6
    } else if (level >= 1 && level < 100) {  // > CustomCode.updateProgressBar:7
      progressLevel.classList.remove("emptybar");  // > CustomCode.updateProgressBar:8
      progressLevel.classList.remove("fullbar");  // > CustomCode.updateProgressBar:9
    } else {  // > CustomCode.updateProgressBar:10
      progressLevel.classList.remove("emptybar");  // > CustomCode.updateProgressBar:11
      progressLevel.classList.add("fullbar");  // > CustomCode.updateProgressBar:12
    }  // > CustomCode.updateProgressBar:13
  }  // > CustomCode.updateProgressBar:14
  function showProgressBar() {  // > CustomCode.updateProgressBar:15
    console.log('show progress bar');  // > CustomCode.updateProgressBar:16
    document.getElementById('progressBarContainer').style.display = "block";  // > CustomCode.updateProgressBar:17
  }  // > CustomCode.updateProgressBar:18
  function hideProgressBar() {  // > CustomCode.updateProgressBar:19
    document.getElementById('progressBarContainer').style.display = "none";  // > CustomCode.updateProgressBar:20
  }  // > CustomCode.updateProgressBar:21
  function incrementProgressBarLevel() {  // > CustomCode.updateProgressBar:22
    if (progressPercentage < 60) {  // > CustomCode.updateProgressBar:23
      progressPercentage += 17;  // > CustomCode.updateProgressBar:24
    } else if (progressPercentage == 60) {  // > CustomCode.updateProgressBar:25
      progressPercentage += 22;  // > CustomCode.updateProgressBar:26
    } else {  // > CustomCode.updateProgressBar:27
      progressPercentage += 17;  // > CustomCode.updateProgressBar:28
    }  // > CustomCode.updateProgressBar:29
      // > CustomCode.updateProgressBar:30
    updateProgressBar(progressPercentage);  // > CustomCode.updateProgressBar:31
  }  // > CustomCode.updateProgressBar:32

  function convertToRadian (thetadeg) {  // > CustomCode.convertToRadian:1
    theta=thetadeg*Math.PI/180;  // > CustomCode.convertToRadian:2
    vx=v*Math.cos(theta);  // > CustomCode.convertToRadian:3
    vy=v*Math.sin(theta);  // > CustomCode.convertToRadian:4
  }  // > CustomCode.convertToRadian:5
  function randomiseThrowTrajectory() {  // > CustomCode.convertToRadian:6
    // 50% change for low/high throws  // > CustomCode.convertToRadian:7
    // low -> ay = -12.5  // > CustomCode.convertToRadian:8
    // high -> ay = -7.5  // > CustomCode.convertToRadian:9
    ay = Math.random >= 0.5 ? -12.5 : -7.5;    // > CustomCode.convertToRadian:10
    // distance of throw based on height is determined by angle  // > CustomCode.convertToRadian:11
    // lower angle should throw further, opposite is throw for higher angle  // > CustomCode.convertToRadian:12
    thetadeg = getRandomInteger(62, 84);   // > CustomCode.convertToRadian:13
    convertToRadian(thetadeg);  // > CustomCode.convertToRadian:14
  }  // > CustomCode.convertToRadian:15

  // copy this custom function  // > CustomCode.sound:1
  // in iOS need to add speech to the play button as On iOS the API works but must be triggered by a user action callback, like a response to a tap event, to provide a better experience to users and avoid unexpected sounds out of your phone  // > CustomCode.sound:2
  function speech (option) {  // > CustomCode.sound:3
  try { // allow code to run in Student Learning Space   // > CustomCode.sound:4
  var isCordova = (!!this.parent.cordova || !!window.cordova);  // > CustomCode.sound:5
  if(isCordova) { // check it is running in Android or iOS  // > CustomCode.sound:6
         // parent.TTS.speak({text:option,locale:'zh-CN'});  // > CustomCode.sound:7
  	parent.TTS.speak({text:option,locale:'us-EN'});  // > CustomCode.sound:8
  	// parent.TTS.speak({text:option,locale:'en-US'});  // > CustomCode.sound:9
  }   // > CustomCode.sound:10
  }   // > CustomCode.sound:11
  catch(e) {  // > CustomCode.sound:12
    var isCordova = false;  // > CustomCode.sound:13
    }  // > CustomCode.sound:14
      // > CustomCode.sound:15
     var msg = new SpeechSynthesisUtterance(option);  // > CustomCode.sound:16
    //https://stackoverflow.com/questions/43983845/speechsynthesis-api-for-chinese-firefox  // > CustomCode.sound:17
    // Set the text.  // > CustomCode.sound:18
  	//msg.text = option;   // > CustomCode.sound:19
  	//https://forums.developer.apple.com/message/323564#323564  // > CustomCode.sound:20
  	// comment out the next 2 lines for english  // > CustomCode.sound:21
  //msg.voice = speechSynthesis.getVoices().filter(function(voice) { return voice.name == 'Ting-Ting'; })[0];  // > CustomCode.sound:22
  //msg.lang = 'zh-CH'; // need for android?  // > CustomCode.sound:23
  msg.lang = 'us-EN'; // need for android?  // > CustomCode.sound:24
  //https://flaviocopes.com/speech-synthesis-api/  // > CustomCode.sound:25
  //debug  // > CustomCode.sound:26
  //console.log(`Voices #: ${speechSynthesis.getVoices().length}`)  // > CustomCode.sound:27
  //speechSynthesis.getVoices().forEach(voice => {  // > CustomCode.sound:28
  // console.log(voice.name, voice.lang)  // > CustomCode.sound:29
  //})  // > CustomCode.sound:30
  //debug  // > CustomCode.sound:31
  // Queue this utterance.  // > CustomCode.sound:32
  window.speechSynthesis.speak(msg);  // > CustomCode.sound:33
     // > CustomCode.sound:34
  }  // > CustomCode.sound:35

  // code to be copied to EJSS source code under Custom and used in drawingPanel3D and plottingPanel2D  // > CustomCode.changeOrientation:1
  // address the problem is height difference is iOS app , epub, and Firefox  // > CustomCode.changeOrientation:2
  // user need to change only k and kepub  // > CustomCode.changeOrientation:3
  // copy %changeOrientation()% into the Height Field of drawingPanel3D and plottingPanel2D  // > CustomCode.changeOrientation:4
  // _view.plottingPanel.getGraphics().setHeight(changeOrientation(0.85));  // > CustomCode.changeOrientation:5
  function changeOrientation(kheight) {  // > CustomCode.changeOrientation:6
     // > CustomCode.changeOrientation:7
  var k =0.90 ; // k control height 1 is for full screen, 0.9 shorten etc  // > CustomCode.changeOrientation:8
  var kapple =0.90 // control apple app height  // > CustomCode.changeOrientation:9
  var kepub =0.90 ;  // > CustomCode.changeOrientation:10
  // check platform for Apps  // > CustomCode.changeOrientation:11
  try { // allow code to run in Student Learning Space   // > CustomCode.changeOrientation:12
    var iOSapp =  (typeof parent.device != 'undefined' && parent.device.platform == "iOS");  // > CustomCode.changeOrientation:13
    var Androidapp = (typeof parent.device != 'undefined' && parent.device.platform == "Android");  // > CustomCode.changeOrientation:14
  } catch(e) {  // > CustomCode.changeOrientation:15
    var iOSapp = false;  // > CustomCode.changeOrientation:16
    var Androidapp = false;  // > CustomCode.changeOrientation:17
  }  // > CustomCode.changeOrientation:18
  // check platform for web browsers  // > CustomCode.changeOrientation:19
  var iOS =/iPad|iPhone|iPod/.test(navigator.userAgent) && !window.MSStream;  // > CustomCode.changeOrientation:20
  var iPad =/iPad/.test(navigator.userAgent) && !window.MSStream;  // > CustomCode.changeOrientation:21
  var iPhone = /iPhone|iPod/.test(navigator.userAgent) && !window.MSStream;  // > CustomCode.changeOrientation:22
  var Android= /Android|android/i.test(navigator.userAgent);  // > CustomCode.changeOrientation:23
  //navigator  // > CustomCode.changeOrientation:24
  var Firefox = navigator.userAgent.indexOf("Firefox") != -1;  // > CustomCode.changeOrientation:25
     // > CustomCode.changeOrientation:26
  switch (window.orientation) { // using window.orientation as deciding factor  // > CustomCode.changeOrientation:27
    case 0:  // > CustomCode.changeOrientation:28
    case 180:  // > CustomCode.changeOrientation:29
      this.screenOrientation = 'portrait';  // > CustomCode.changeOrientation:30
      if (iOSapp){ // does not seems to work  // > CustomCode.changeOrientation:31
          // > CustomCode.changeOrientation:32
        return window.screen.height*kapple;  //0.1 for app and 0.1 for nonfullscreenapp    // > CustomCode.changeOrientation:33
        // > CustomCode.changeOrientation:34
      }  // > CustomCode.changeOrientation:35
      else if (_isEPub){ // does not seems to work  // > CustomCode.changeOrientation:36
        //   return Math.max(window.screen.width,window.screen.height)*0.9;  // > CustomCode.changeOrientation:37
        return window.innerHeight*kepub;  //0.1 for app and 0.1 for nonfullscreenapp    // > CustomCode.changeOrientation:38
        // return window.screen.height;  // > CustomCode.changeOrientation:39
        //  return window.innerHeight;  // > CustomCode.changeOrientation:40
        // return document.documentElement.clientHeight;  // > CustomCode.changeOrientation:41
      }  // > CustomCode.changeOrientation:42
       // > CustomCode.changeOrientation:43
      else {  // > CustomCode.changeOrientation:44
       return window.innerHeight*kheight;  // > CustomCode.changeOrientation:45
        //return 100*k+"vh";  // > CustomCode.changeOrientation:46
      }  // > CustomCode.changeOrientation:47
      break;  // > CustomCode.changeOrientation:48
    case 90:  // > CustomCode.changeOrientation:49
    case -90:  // > CustomCode.changeOrientation:50
      this.screenOrientation = 'landscape';  // > CustomCode.changeOrientation:51
     // > CustomCode.changeOrientation:52
      if (iOSapp){ // App  // > CustomCode.changeOrientation:53
        return window.screen.width*kapple;    // > CustomCode.changeOrientation:54
        // return window.screen.height;  // > CustomCode.changeOrientation:55
        //  return window.innerHeight;  // > CustomCode.changeOrientation:56
        //  return document.documentElement.clientHeight;  // > CustomCode.changeOrientation:57
      }  // > CustomCode.changeOrientation:58
      else if (_isEPub){ // does not seems to work  // > CustomCode.changeOrientation:59
        //   return Math.max(window.screen.width,window.screen.height)*0.9;  // > CustomCode.changeOrientation:60
        return window.innerHeight*kepub;  //0.1 for app and 0.1 for nonfullscreenapp    // > CustomCode.changeOrientation:61
        // return window.screen.height;  // > CustomCode.changeOrientation:62
        //  return window.innerHeight;  // > CustomCode.changeOrientation:63
        // return document.documentElement.clientHeight;  // > CustomCode.changeOrientation:64
      }  // > CustomCode.changeOrientation:65
       // > CustomCode.changeOrientation:66
      else {  // > CustomCode.changeOrientation:67
        return window.innerHeight*kheight;  // > CustomCode.changeOrientation:68
        //return 100*k+"vh"; // safari produce error  // > CustomCode.changeOrientation:69
        }  // > CustomCode.changeOrientation:70
      break;  // > CustomCode.changeOrientation:71
    default:  // > CustomCode.changeOrientation:72
      this.screenOrientation = 'unknown';  // > CustomCode.changeOrientation:73
      //       return (iPad)?""+(window.screen.width+window.screen.height)*0.4:((iPhone)?""+window.screen.width:_view._format(window.innerHeight*0.9,"0"));  // > CustomCode.changeOrientation:74
       if (Firefox){  // > CustomCode.changeOrientation:75
        return window.innerHeight*k;// number as of 20180831 Firefox does not support vh yet so need a separate line to handle  // > CustomCode.changeOrientation:76
        }  // > CustomCode.changeOrientation:77
     //   else if (iOS&&(window.orientation==0)||(window.orientation==180)){  // > CustomCode.changeOrientation:78
     //   return  window.screen.height*k;// number as of 20180831 Firefox does not support vh yet so need a separate line to handle  // > CustomCode.changeOrientation:79
     //   }  // > CustomCode.changeOrientation:80
      //  else if (iOS&&(window.orientation==90)||(window.orientation==-90)){  // > CustomCode.changeOrientation:81
     //   return  window.screen.width*k;// number as of 20180831 Firefox does not support vh yet so need a separate line to handle  // > CustomCode.changeOrientation:82
     //   }  // > CustomCode.changeOrientation:83
        else {  // > CustomCode.changeOrientation:84
        //alert();  // > CustomCode.changeOrientation:85
        // return 100*k+"%"; // work on fullscreen works in EJSS6.0beta  // > CustomCode.changeOrientation:86
          //  works in EjsS_5.3_180131  // > CustomCode.changeOrientation:87
        return  window.innerHeight*kheight; // work on panel   // > CustomCode.changeOrientation:88
           // > CustomCode.changeOrientation:89
  }  // > CustomCode.changeOrientation:90
  }  // > CustomCode.changeOrientation:91
     // > CustomCode.changeOrientation:92
  }  // > CustomCode.changeOrientation:93

  //https://developer.mozilla.org/en-US/docs/Web/Guide/API/DOM/Using_full_screen_mode  // > CustomCode.togglefullscreen:1
  // does not work for iOS   // > CustomCode.togglefullscreen:2
  /*jslint browser:true */  // > CustomCode.togglefullscreen:3
  function toggleFullScreen() {  // > CustomCode.togglefullscreen:4
    if (!document.fullscreenElement &&    // alternative standard method  // > CustomCode.togglefullscreen:5
        !document.mozFullScreenElement && !document.webkitFullscreenElement && !document.msFullscreenElement ) {  // current working methods  // > CustomCode.togglefullscreen:6
      if (document.documentElement.requestFullscreen) {  // > CustomCode.togglefullscreen:7
        document.documentElement.requestFullscreen();  // > CustomCode.togglefullscreen:8
      } else if (document.documentElement.msRequestFullscreen) {  // > CustomCode.togglefullscreen:9
        document.documentElement.msRequestFullscreen();  // > CustomCode.togglefullscreen:10
      } else if (document.documentElement.mozRequestFullScreen) {  // > CustomCode.togglefullscreen:11
        document.documentElement.mozRequestFullScreen();  // > CustomCode.togglefullscreen:12
      } else if (document.documentElement.webkitRequestFullscreen) {  // > CustomCode.togglefullscreen:13
        document.documentElement.webkitRequestFullscreen();  // > CustomCode.togglefullscreen:14
      }  // > CustomCode.togglefullscreen:15
    } else {  // > CustomCode.togglefullscreen:16
      if (document.exitFullscreen) {  // > CustomCode.togglefullscreen:17
        document.exitFullscreen();  // > CustomCode.togglefullscreen:18
      } else if (document.msExitFullscreen) {  // > CustomCode.togglefullscreen:19
        document.msExitFullscreen();  // > CustomCode.togglefullscreen:20
      } else if (document.mozCancelFullScreen) {  // > CustomCode.togglefullscreen:21
        document.mozCancelFullScreen();  // > CustomCode.togglefullscreen:22
      } else if (document.webkitExitFullscreen) {  // > CustomCode.togglefullscreen:23
        document.webkitExitFullscreen();  // > CustomCode.togglefullscreen:24
      }  // > CustomCode.togglefullscreen:25
    }  // > CustomCode.togglefullscreen:26
  }  // > CustomCode.togglefullscreen:27

  _model.addToInitialization(function() {
    if (!__pagesEnabled["resizeGameObjectsOnGraph"]) return;
    // resizing element sizes and distances between elements based on simulation container size  // > Initialization.resizeGameObjectsOnGraph:1
    let gameScreenWidth = document.getElementById('_topFrame').clientWidth;  // > Initialization.resizeGameObjectsOnGraph:2
    let gameScreenHeight = document.getElementById('_topFrame').clientHeight;  // > Initialization.resizeGameObjectsOnGraph:3
    // if a particular height or width works for both SLS small preview window and larger viewports, add declaration here  // > Initialization.resizeGameObjectsOnGraph:4
    recyclableItemWidth= 0.1 * gameScreenWidth;  // > Initialization.resizeGameObjectsOnGraph:5
    recyclableItemHeight= 0.13 * gameScreenHeight;  // > Initialization.resizeGameObjectsOnGraph:6
    recyclableTitleFontSize = `${0.014 * gameScreenWidth}`;  // > Initialization.resizeGameObjectsOnGraph:7
    recyclableNameContainerHeight = 0.045 * gameScreenHeight;  // > Initialization.resizeGameObjectsOnGraph:8
    binWidth = 0.125 * gameScreenWidth;  // > Initialization.resizeGameObjectsOnGraph:9
      // Only for SLS platform small preview window!  // > Initialization.resizeGameObjectsOnGraph:10
    if (_view._topFrame.clientWidth < 350) {  // > Initialization.resizeGameObjectsOnGraph:11
      _println('SLS platform window on mobile detected');  // > Initialization.resizeGameObjectsOnGraph:12
        // > Initialization.resizeGameObjectsOnGraph:13
      recyclableNameContainerWidth = 0.15 * gameScreenWidth;  // > Initialization.resizeGameObjectsOnGraph:14
      symbolHeight = 0.001 * gameScreenHeight;  // > Initialization.resizeGameObjectsOnGraph:15
      symbolWidth = 0.002 * gameScreenWidth;  // > Initialization.resizeGameObjectsOnGraph:16
      binHeight = 0.225 * gameScreenHeight;  // > Initialization.resizeGameObjectsOnGraph:17
      recyclableItemHeight= 0.13 * gameScreenHeight;  // > Initialization.resizeGameObjectsOnGraph:18
    } else if (_view._topFrame.clientWidth < 650) {  // > Initialization.resizeGameObjectsOnGraph:19
        // > Initialization.resizeGameObjectsOnGraph:20
      recyclableNameContainerWidth = 0.15 * gameScreenWidth;  // > Initialization.resizeGameObjectsOnGraph:21
      symbolHeight = 0.0015 * gameScreenHeight;  // > Initialization.resizeGameObjectsOnGraph:22
      symbolWidth = 0.0015 * gameScreenWidth;    // > Initialization.resizeGameObjectsOnGraph:23
      binHeight = 0.275 * gameScreenHeight;  // > Initialization.resizeGameObjectsOnGraph:24
      recyclableItemHeight= 0.13 * gameScreenHeight;  // > Initialization.resizeGameObjectsOnGraph:25
        // > Initialization.resizeGameObjectsOnGraph:26
    } else { // Only for expanded game screen on larger viewports  // > Initialization.resizeGameObjectsOnGraph:27
      recyclableNameContainerPosY = y - gapSizeBetweenRecyclableAndName;  // > Initialization.resizeGameObjectsOnGraph:28
      recyclableNameContainerWidth = 0.15 * gameScreenWidth;  // > Initialization.resizeGameObjectsOnGraph:29
         // > Initialization.resizeGameObjectsOnGraph:30
      symbolHeight = 0.0005 * gameScreenHeight;  // > Initialization.resizeGameObjectsOnGraph:31
      symbolWidth = 0.0005 * gameScreenWidth;  // > Initialization.resizeGameObjectsOnGraph:32
      binHeight = 0.275 * gameScreenHeight;  // > Initialization.resizeGameObjectsOnGraph:33
      recyclableItemHeight= 0.13 * gameScreenHeight;  // > Initialization.resizeGameObjectsOnGraph:34
    }  // > Initialization.resizeGameObjectsOnGraph:35
    window.addEventListener('resize', () => {  // > Initialization.resizeGameObjectsOnGraph:36
      // Your code to handle the window resize event  // > Initialization.resizeGameObjectsOnGraph:37
      console.log('Window resized!');  // > Initialization.resizeGameObjectsOnGraph:38
        // > Initialization.resizeGameObjectsOnGraph:39
        // > Initialization.resizeGameObjectsOnGraph:40
      if (_view._topFrame.clientWidth < 350) {  // > Initialization.resizeGameObjectsOnGraph:41
      _println('SLS platform window on mobile detected');  // > Initialization.resizeGameObjectsOnGraph:42
        // > Initialization.resizeGameObjectsOnGraph:43
      recyclableNameContainerWidth = 0.15 * gameScreenWidth;  // > Initialization.resizeGameObjectsOnGraph:44
      symbolHeight = 0.001 * gameScreenHeight;  // > Initialization.resizeGameObjectsOnGraph:45
      symbolWidth = 0.002 * gameScreenWidth;  // > Initialization.resizeGameObjectsOnGraph:46
      binHeight = 0.225 * gameScreenHeight;  // > Initialization.resizeGameObjectsOnGraph:47
      recyclableItemHeight= 0.13 * gameScreenHeight;  // > Initialization.resizeGameObjectsOnGraph:48
    } else if (_view._topFrame.clientWidth < 650) {  // > Initialization.resizeGameObjectsOnGraph:49
        // > Initialization.resizeGameObjectsOnGraph:50
      recyclableNameContainerWidth = 0.15 * gameScreenWidth;  // > Initialization.resizeGameObjectsOnGraph:51
      symbolHeight = 0.0015 * gameScreenHeight;  // > Initialization.resizeGameObjectsOnGraph:52
      symbolWidth = 0.0015 * gameScreenWidth;    // > Initialization.resizeGameObjectsOnGraph:53
      binHeight = 0.275 * gameScreenHeight;  // > Initialization.resizeGameObjectsOnGraph:54
      recyclableItemHeight= 0.13 * gameScreenHeight;  // > Initialization.resizeGameObjectsOnGraph:55
        // > Initialization.resizeGameObjectsOnGraph:56
    } else { // Only for expanded game screen on larger viewports  // > Initialization.resizeGameObjectsOnGraph:57
      recyclableNameContainerPosY = y - gapSizeBetweenRecyclableAndName;  // > Initialization.resizeGameObjectsOnGraph:58
      recyclableNameContainerWidth = 0.15 * gameScreenWidth;  // > Initialization.resizeGameObjectsOnGraph:59
         // > Initialization.resizeGameObjectsOnGraph:60
      symbolHeight = 0.0005 * gameScreenHeight;  // > Initialization.resizeGameObjectsOnGraph:61
      symbolWidth = 0.0005 * gameScreenWidth;  // > Initialization.resizeGameObjectsOnGraph:62
      binHeight = 0.275 * gameScreenHeight;  // > Initialization.resizeGameObjectsOnGraph:63
      recyclableItemHeight= 0.13 * gameScreenHeight;  // > Initialization.resizeGameObjectsOnGraph:64
    }  // > Initialization.resizeGameObjectsOnGraph:65
    _view._update();  // > Initialization.resizeGameObjectsOnGraph:66
    });  // > Initialization.resizeGameObjectsOnGraph:67
  });

  _model.addToInitialization(function() {
    if (!__pagesEnabled["pageNavigation"]) return;
    let startBtn = document.getElementById('gameStartBtn');  // > Initialization.pageNavigation:1
    let startPage = document.getElementById('gameStart');  // > Initialization.pageNavigation:2
    let introBtn = document.getElementById('gameIntroBtn');  // > Initialization.pageNavigation:3
    let introPage = document.getElementById('gameIntroduction');  // > Initialization.pageNavigation:4
    let gameplayInstructionsBtn = document.getElementById('gameplayInstructionsBtn');  // > Initialization.pageNavigation:5
    let gameplayInstructionsPage = document.getElementById('gameplayInstructions');  // > Initialization.pageNavigation:6
    let gameScreen = document.getElementById('gameScreen');  // > Initialization.pageNavigation:7
    startBtn.addEventListener('click', () => {  // > Initialization.pageNavigation:8
        // hide game start page  // > Initialization.pageNavigation:9
        startPage.style.display = 'none';  // > Initialization.pageNavigation:10
        // display game intro page  // > Initialization.pageNavigation:11
        introPage.style.display = 'block';  // > Initialization.pageNavigation:12
    })  // > Initialization.pageNavigation:13
    introBtn.addEventListener('click', () => {  // > Initialization.pageNavigation:14
        // hide game intro page  // > Initialization.pageNavigation:15
        introPage.style.display = 'none';  // > Initialization.pageNavigation:16
        // display gameplay instructions page  // > Initialization.pageNavigation:17
        gameplayInstructionsPage.style.display = 'block';  // > Initialization.pageNavigation:18
    })  // > Initialization.pageNavigation:19
    gameplayInstructionsBtn.addEventListener('click', () => {  // > Initialization.pageNavigation:20
        // hide game intro page  // > Initialization.pageNavigation:21
        gameplayInstructionsPage.style.display = 'none';  // > Initialization.pageNavigation:22
          // > Initialization.pageNavigation:23
        // display game screen      // > Initialization.pageNavigation:24
        currentPage = "gameScreen";  // > Initialization.pageNavigation:25
        document.getElementById('gameScreen').style.opacity = '1';  // > Initialization.pageNavigation:26
        document.getElementById('gameScreen').style.zIndex = '0';  // > Initialization.pageNavigation:27
        _view.backgroundMusic.play();  // > Initialization.pageNavigation:28
        generateRandomRecyclable();  // > Initialization.pageNavigation:29
        randomiseThrowTrajectory();  // > Initialization.pageNavigation:30
        _update();  // > Initialization.pageNavigation:31
    })  // > Initialization.pageNavigation:32
  });

  _model.addToInitialization(function() {
    if (!__pagesEnabled["modals"]) return;
    let answers = document.getElementsByClassName('answer');  // > Initialization.modals:1
    for (let index = 0; index < answers.length; index++) {  // > Initialization.modals:2
        let temp = answers[index];  // > Initialization.modals:3
          // > Initialization.modals:4
        temp.addEventListener('click', (e) => {  // > Initialization.modals:5
           if (gameStarted) {  // > Initialization.modals:6
               if (round <= 6) {  // > Initialization.modals:7
                 // reset objects to initial values to throw again  // > Initialization.modals:8
                 resetRecyclableItemAttributes();  // > Initialization.modals:9
                 randomiseThrowTrajectory();  // > Initialization.modals:10
                 t=0;  // > Initialization.modals:11
                 itemIsNotFlying = true;  // > Initialization.modals:12
                 isItemInBin = false;  // > Initialization.modals:13
                 hideAllRightOrWrongSymbols();  // > Initialization.modals:14
        // > Initialization.modals:15
                 if (!playerMissed) {  // > Initialization.modals:16
                   generateRandomRecyclable();  // > Initialization.modals:17
                   _model.setStepsPerDisplay(1 + 0.1*round); // increase speed of throw after each successful round  // > Initialization.modals:18
                   hideProgressBar();  // > Initialization.modals:19
                   showAnswerModal = false;  // > Initialization.modals:20
                   document.querySelector('#overlay').style.display = 'none';  // > Initialization.modals:21
                 }    // > Initialization.modals:22
                 playerMissed = false; // reset it  // > Initialization.modals:23
                 showBins();  // > Initialization.modals:24
                   // > Initialization.modals:25
               } else {  // > Initialization.modals:26
                  // game ended  // > Initialization.modals:27
                  _view.backgroundMusic.pause();  // > Initialization.modals:28
                  document.getElementById('gameScreen').style.opacity = '0';  // > Initialization.modals:29
                  currentPage="gameEnd";  // > Initialization.modals:30
                // > Initialization.modals:31
                  // send the summary of student's answers to moodle     // > Initialization.modals:32
                  for (const question in questions) {  // > Initialization.modals:33
                    summary += `${questions[question]['recyclable']}: \n`;  // > Initialization.modals:34
                    summary += `Attempt: ${questions[question]['choice']} \n`;  // > Initialization.modals:35
                    summary += `Answer: ${questions[question]['answer']} \n`;  // > Initialization.modals:36
                    summary += `Description: ${questions[question]['description']} \n`;  // > Initialization.modals:37
                  }  // > Initialization.modals:38
                  moodle.resetQuestionHistory("Summary");  // > Initialization.modals:39
                  moodle.questionInstantMark("Summary", summary);  // > Initialization.modals:40
               }   // > Initialization.modals:41
           }   // > Initialization.modals:42
           // update simulation so that everything shows up on screen correctly after clicking next button on answer modal  // > Initialization.modals:43
           _view._update();  // > Initialization.modals:44
           _update();  // > Initialization.modals:45
             // > Initialization.modals:46
        })  // > Initialization.modals:47
    }  // > Initialization.modals:48
    let oopsNextButton = document.querySelector('#oopsNextBtn');  // > Initialization.modals:49
    oopsNextButton.addEventListener('click', (e) => {  // > Initialization.modals:50
      if (gameStarted) {  // > Initialization.modals:51
        if (round <= 6) {  // > Initialization.modals:52
                 // reset objects to initial values to throw again  // > Initialization.modals:53
                 resetRecyclableItemAttributes();  // > Initialization.modals:54
                 randomiseThrowTrajectory();  // > Initialization.modals:55
                 t=0;  // > Initialization.modals:56
                 itemIsNotFlying = true;  // > Initialization.modals:57
                 isItemInBin = false;  // > Initialization.modals:58
                 hitDaFloor = false;  // > Initialization.modals:59
                 hideAllRightOrWrongSymbols();  // > Initialization.modals:60
        // > Initialization.modals:61
                 if (!playerMissed) {  // > Initialization.modals:62
                   generateRandomRecyclable();  // > Initialization.modals:63
                   _model.setStepsPerDisplay(1 + 0.1*round); // increase speed of throw after each successful round  // > Initialization.modals:64
                   hideProgressBar();  // > Initialization.modals:65
                   showAnswerModal = false;  // > Initialization.modals:66
                 }    // > Initialization.modals:67
                 document.querySelector('#overlay').style.display = 'none';  // > Initialization.modals:68
                 playerMissed = false; // reset it  // > Initialization.modals:69
                 showBins();  // > Initialization.modals:70
                   // > Initialization.modals:71
               } else {  // > Initialization.modals:72
               // game ended  // > Initialization.modals:73
              _view.backgroundMusic.pause();  // > Initialization.modals:74
              document.getElementById('gameScreen').style.opacity = '0';  // > Initialization.modals:75
              currentPage="gameEnd";  // > Initialization.modals:76
               }   // > Initialization.modals:77
           }   // > Initialization.modals:78
           // update simulation so that everything shows up on screen correctly after clicking next button on answer modal  // > Initialization.modals:79
           _view._update();  // > Initialization.modals:80
           _update();  // > Initialization.modals:81
             // > Initialization.modals:82
        })  // > Initialization.modals:83
  });

  _model.addToInitialization(function() {
    if (!__pagesEnabled["alert"]) return;
    const closeSlideBtn = document.getElementById('closeSlideBtn');  // > Initialization.alert:1
    const slideContainer = document.getElementById('slideContainer');  // > Initialization.alert:2
    closeSlideBtn.addEventListener('click', () => {  // > Initialization.alert:3
        slideContainer.style.bottom = '-100%';  // > Initialization.alert:4
    });  // > Initialization.alert:5
    const userAgent = navigator.userAgent;  // > Initialization.alert:6
    console.log('User-Agent String:', userAgent);  // > Initialization.alert:7
    // Check if the User-Agent string contains specific keywords  // > Initialization.alert:8
    if (userAgent.match(/Android/i)) {  // > Initialization.alert:9
      console.log('This user is using an Android device.');  // > Initialization.alert:10
      slideContainer.style.display = 'block';  // > Initialization.alert:11
      slideContainer.style.bottom = '0';  // > Initialization.alert:12
        // > Initialization.alert:13
    } else if (userAgent.match(/iPhone|iPad|iPod/i)) {  // > Initialization.alert:14
      console.log('This user is using an iOS device (iPhone, iPad, or iPod).');  // > Initialization.alert:15
      slideContainer.style.display = 'block';  // > Initialization.alert:16
      slideContainer.style.bottom = '0';  // > Initialization.alert:17
        // > Initialization.alert:18
    } else if (userAgent.match(/Windows/i)) {  // > Initialization.alert:19
      console.log('This user is using a Windows device.');  // > Initialization.alert:20
    } else if (userAgent.match(/Macintosh/i)) {  // > Initialization.alert:21
      console.log('This user is using a Macintosh (Mac) device.');  // > Initialization.alert:22
    } else {  // > Initialization.alert:23
      console.log('The user agent does not match any known device/OS.');  // > Initialization.alert:24
    }  // > Initialization.alert:25
  });

  _model.addToInitialization(function() {
    _initializeSolvers();
  });

  _model.addToEvolution(function() {
    if (!__pagesEnabled["Evol Page"]) return;
    _ODEi_evolution1.step();
  });

  _model.addToFixedRelations(function() { _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); });

  _model.addToFixedRelations(function() { _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); });

  function _initializeSolvers() {
    for (var i=0,n=_privateOdesList.length; i<n; i++) _privateOdesList[i].initializeSolver();
  }

  function _automaticResetSolvers() {
    for (var i=0,n=_privateOdesList.length; i<n; i++) _privateOdesList[i].automaticResetSolver();
  }

  _model.resetSolvers = function() {
    for (var i=0,n=_privateOdesList.length; i<n; i++) _privateOdesList[i].resetSolver();
  };

  _getODE = function (_odeName) {
    if (_odeName=="Evol Page") return _ODEi_evolution1;
    return null;
  }

  function _getEventSolver(_odeName) {
    var ode = _getODE(_odeName);
    if (ode===null) return null;
    return ode.getEventSolver();
  }

  function _setSolverClass(_odeName, _engine) {
    var ode = _getODE(_odeName);
    if (ode===null) return;
    if (!_engine.setODE) {
      var classname = _engine.toLowerCase();
      if      (classname.indexOf("boga")>=0)   _engine = EJSS_ODE_SOLVERS.bogackiShampine23;
      else if (classname.indexOf("cash")>=0)   _engine = EJSS_ODE_SOLVERS.cashKarp45;
      else if (classname.indexOf("dopri5")>=0) _engine = EJSS_ODE_SOLVERS.dopri5;
      else if (classname.indexOf("dopri8")>=0) _engine = EJSS_ODE_SOLVERS.dopri853;
      else if (classname.indexOf("richa")>=0)  _engine = EJSS_ODE_SOLVERS.eulerRichardson;
      else if (classname.indexOf("euler")>=0)  _engine = EJSS_ODE_SOLVERS.euler;
      else if (classname.indexOf("fehlberg87")>=0) _engine = EJSS_ODE_SOLVERS.fehlberg87;
      else if (classname.indexOf("fehlberg8")>=0)  _engine = EJSS_ODE_SOLVERS.fehlberg8;
      else if (classname.indexOf("radau")>=0)   _engine = EJSS_ODE_SOLVERS.radau5;
      else if (classname.indexOf("runge")>=0)  _engine = EJSS_ODE_SOLVERS.rungeKutta4;
      else if (classname.indexOf("rk4")>=0)    _engine = EJSS_ODE_SOLVERS.rungeKutta4;
      else if (classname.indexOf("verlet")>=0) _engine = EJSS_ODE_SOLVERS.velocityVerlet;
    }
    if (_engine) ode.setSolverClass(_engine);
  }

  function _ODE_evolution1() {
    var __odeSelf = {};
    var __eventSolver;
    var __solverClass = EJSS_ODE_SOLVERS.rungeKutta4;
    var __state=[];
    var _ODE_evolution1_Event1;
    var _ODE_evolution1_Event2;
    var _ODE_evolution1_Event3;
    var __ignoreErrors=false;
    var __mustInitialize=true;
    var __isEnabled=true;
    var __mustUserReinitialize=false;
    var __mustReinitialize=true;


    __odeSelf._getOdeVars = function (){ return["x","y","vy","t"]};

    __odeSelf.setSolverClass = function(__aSolverClass) {
      __solverClass = __aSolverClass;
      __instantiateSolver();
    };

    function __instantiateSolver() {
      __state=[];
      __pushState();
      __eventSolver = EJSS_ODE_SOLVERS.interpolatorEventSolver(__solverClass(),__odeSelf);
      __mustInitialize = true;
    }

    __odeSelf.setEnabled = function(_enabled) { __isEnabled = _enabled; };

    __odeSelf.getIndependentVariableValue = function() { return __eventSolver.getIndependentVariableValue(); };

    __odeSelf.getInternalStepSize = function() { return __eventSolver.getInternalStepSize(); };

    __odeSelf.isAccelerationIndependentOfVelocity = function() { return false; };

    __odeSelf.initializeSolver = function() {
      if (__arraysChanged()) { __instantiateSolver(); __odeSelf.initializeSolver(); return; }
      __pushState();
      __eventSolver.initialize(dt);
      __eventSolver.setBestInterpolation(false);
      __eventSolver.setMaximumInternalSteps(10000);
      __eventSolver.removeAllEvents();
      if (__pagesEnabled["hitTheFloor"]) __eventSolver.addEvent(_ODE_evolution1_Event1());
      if (__pagesEnabled["recycleBin"]) __eventSolver.addEvent(_ODE_evolution1_Event2());
      if (__pagesEnabled["wasteBin"]) __eventSolver.addEvent(_ODE_evolution1_Event3());
      for(k in userEvents1){__eventSolver.addEvent(userEvents1[k]);}
      __eventSolver.setEstimateFirstStep(false);
      __eventSolver.setEnableExceptions(false);
      __eventSolver.setTolerances(0.00001,0.00001);
      __mustReinitialize = true;
      __mustInitialize = false;
    };

    function __pushState() {
      // Copy our variables to __state[] 
        var __j=0;
        var __n=0;
        var __cIn=0;
        if (__state[__cIn]!=x) __mustReinitialize = true;
        __state[__cIn++] = x;
        if (__state[__cIn]!=y) __mustReinitialize = true;
        __state[__cIn++] = y;
        if (__state[__cIn]!=vy) __mustReinitialize = true;
        __state[__cIn++] = vy;
        if (__state[__cIn]!=t) __mustReinitialize = true;
        __state[__cIn++] = t;
    }

    function __arraysChanged () {
      return false;
    }

    __odeSelf.getEventSolver = function() {
      return __eventSolver;
    };

    __odeSelf.resetSolver = function() {
      __mustUserReinitialize = true;
    };

    __odeSelf.automaticResetSolver = function() {
      __mustReinitialize = true;
    };

    function __errorAction () {
      if (__ignoreErrors) return;
      console.log (__eventSolver.getErrorMessage());
      _pause();
      // Make sure the solver is reinitialized;
      __mustReinitialize = true;
    }

    __odeSelf.step = function() { return __privateStep(false); };

    __odeSelf.solverStep = function() { return __privateStep(true); };

    function __privateStep(__takeMaximumStep) {
      if (!__isEnabled) return 0;
      if (dt===0) return 0;
      if (__mustInitialize) __odeSelf.initializeSolver();
      if (__arraysChanged()) { __instantiateSolver(); __odeSelf.initializeSolver(); }
      __eventSolver.setStepSize(dt);
      __eventSolver.setInternalStepSize(dt);
      __eventSolver.setMaximumInternalSteps(10000);
      __eventSolver.setTolerances(0.00001,0.00001);
      __pushState();
      if (__mustUserReinitialize) { 
        __eventSolver.userReinitialize();
        __mustUserReinitialize = false;
        __mustReinitialize = false;
        if (__eventSolver.getErrorCode()!=EJSS_ODE_SOLVERS.ERROR.NO_ERROR) __errorAction();
      }
      else if (__mustReinitialize) { 
        __eventSolver.reinitialize();
        __mustReinitialize = false;
        if (__eventSolver.getErrorCode()!=EJSS_ODE_SOLVERS.ERROR.NO_ERROR) __errorAction();
      }
      var __stepTaken = __takeMaximumStep ? __eventSolver.maxStep() : __eventSolver.step();
      // Extract our variables from __state
        var __i=0;
        var __cOut=0;
        x = __state[__cOut++];
        y = __state[__cOut++];
        vy = __state[__cOut++];
        t = __state[__cOut++];
      // Check for error
      if (__eventSolver.getErrorCode()!=EJSS_ODE_SOLVERS.ERROR.NO_ERROR) __errorAction();
      return __stepTaken;
    }

    __odeSelf.getState = function() { return __state; };

    __odeSelf.getRate = function(_aState,_aRate) {
      // Extract our variables from _aState
        var __i=0;
        var __cOut=0;
        var x = _aState[__cOut++];
        var y = _aState[__cOut++];
        var vy = _aState[__cOut++];
        var t = _aState[__cOut++];
      // Compute the rate
        var __cRate=0;
        _aRate[__cRate++] = vx; // Rate for ODE: Evol Page:x
        _aRate[__cRate++] = vy; // Rate for ODE: Evol Page:y
        _aRate[__cRate++] = ay; // Rate for ODE: Evol Page:vy
        _aRate[__cRate++] = 1; // independent variable
        return _aRate;
    }; //end of getRate

    __odeSelf._addEvent = function(userCondition,userAction,eventType,eventMethod,maxIter,eventTolerance,endAtEvent){
    var User_Event = function (userCondition,userAction,eventType,eventMethod,maxIter,eventTolerance,endAtEvent) {
      var _eventSelf = {};

      _eventSelf.getTypeOfEvent = function() { return eventType; };

      _eventSelf.getRootFindingMethod = function() { return eventMethod; };

      _eventSelf.getMaxIterations = function() { return maxIter; };

      _eventSelf.getTolerance = function() { return eventTolerance; };

      _eventSelf.evaluate = function(_aState) { 
      // Extract our variables from _aState
        var __i=0;
        var __cOut=0;
        var x = _aState[__cOut++];
        var y = _aState[__cOut++];
        var vy = _aState[__cOut++];
        var t = _aState[__cOut++];
      return eval(userCondition);
      };

      _eventSelf.action = function() { 
      // Extract our variables from __state
        var __i=0;
        var __cOut=0;
        x = __state[__cOut++];
        y = __state[__cOut++];
        vy = __state[__cOut++];
        t = __state[__cOut++];
        var _returnValue = __userDefinedAction();
      // Copy our variables to __state[] 
        var __j=0;
        var __n=0;
        var __cIn=0;
        __state[__cIn++] = x;
        __state[__cIn++] = y;
        __state[__cIn++] = vy;
        __state[__cIn++] = t;
        return _returnValue;
      };

      function __userDefinedAction() {
        if (undefined != functions) eval(functions.toString());
        eval(userAction);
        return endAtEvent;
      }

      return _eventSelf;
    }; // End of event

   userEvents1.push(User_Event(userCondition,userAction,eventType,eventMethod,maxIter,eventTolerance,endAtEvent));
   }

    _ODE_evolution1_Event1 = function() {
      var _eventSelf = {};

      _eventSelf.getTypeOfEvent = function() { return EJSS_ODE_SOLVERS.EVENT_TYPE.CROSSING_EVENT; };

      _eventSelf.getRootFindingMethod = function() { return EJSS_ODE_SOLVERS.EVENT_METHOD.BISECTION; };

      _eventSelf.getMaxIterations = function() { return 100; };

      _eventSelf.getTolerance = function() { return 1.0e-5; };

      _eventSelf.evaluate = function(_aState) { 
      // Extract our variables from _aState
        var __i=0;
        var __cOut=0;
        var x = _aState[__cOut++];
        var y = _aState[__cOut++];
        var vy = _aState[__cOut++];
        var t = _aState[__cOut++];
        return y-0;  // > Event zero-condition for page Evol Page:1
      };

      _eventSelf.action = function() { 
      // Extract our variables from __state
        var __i=0;
        var __cOut=0;
        x = __state[__cOut++];
        y = __state[__cOut++];
        vy = __state[__cOut++];
        t = __state[__cOut++];
        var _returnValue = __userDefinedAction();
      // Copy our variables to __state[] 
        var __j=0;
        var __n=0;
        var __cIn=0;
        __state[__cIn++] = x;
        __state[__cIn++] = y;
        __state[__cIn++] = vy;
        __state[__cIn++] = t;
        return _returnValue;
      };

      function __userDefinedAction() {
        _pause();  // > Event action for page Evol Page:1
        if (!isMuted) _view.landOnFloor.play();  // > Event action for page Evol Page:2
        document.querySelector('#overlay').style.display = 'block';  // > Event action for page Evol Page:3
        playerMissed = true;  // > Event action for page Evol Page:4
        hitDaFloor = true;  // > Event action for page Evol Page:5
        t=0;  // > Event action for page Evol Page:6
        return true;
      }

      return _eventSelf;
    }; // End of event

    _ODE_evolution1_Event2 = function() {
      var _eventSelf = {};

      _eventSelf.getTypeOfEvent = function() { return EJSS_ODE_SOLVERS.EVENT_TYPE.CROSSING_EVENT; };

      _eventSelf.getRootFindingMethod = function() { return EJSS_ODE_SOLVERS.EVENT_METHOD.BISECTION; };

      _eventSelf.getMaxIterations = function() { return 100; };

      _eventSelf.getTolerance = function() { return 1.0e-5; };

      _eventSelf.evaluate = function(_aState) { 
      // Extract our variables from _aState
        var __i=0;
        var __cOut=0;
        var x = _aState[__cOut++];
        var y = _aState[__cOut++];
        var vy = _aState[__cOut++];
        var t = _aState[__cOut++];
        var recycleBinPosX = draggerPosX - (spacingBetweenBins / 2);  // > Event zero-condition for page Evol Page:1
        var dx = x - recycleBinPosX;  // > Event zero-condition for page Evol Page:2
        var dy = y - 1.4;  // > Event zero-condition for page Evol Page:3
        var distance = Math.sqrt(dx * dx + dy * dy);  // > Event zero-condition for page Evol Page:4
        var spacing = 0.35; // tolerance for collision  // > Event zero-condition for page Evol Page:5
        return distance - spacing;  // > Event zero-condition for page Evol Page:6
      };

      _eventSelf.action = function() { 
      // Extract our variables from __state
        var __i=0;
        var __cOut=0;
        x = __state[__cOut++];
        y = __state[__cOut++];
        vy = __state[__cOut++];
        t = __state[__cOut++];
        var _returnValue = __userDefinedAction();
      // Copy our variables to __state[] 
        var __j=0;
        var __n=0;
        var __cIn=0;
        __state[__cIn++] = x;
        __state[__cIn++] = y;
        __state[__cIn++] = vy;
        __state[__cIn++] = t;
        return _returnValue;
      };

      function __userDefinedAction() {
        isItemInBin = true;  // > Event action for page Evol Page:1
        let resultText;  // > Event action for page Evol Page:2
        // each case in the switch statement below decides what to do   // > Event action for page Evol Page:3
        // when the recycle bin "catches" the recyclable item  // > Event action for page Evol Page:4
        switch(recyclableName) {  // > Event action for page Evol Page:5
          case "Cereal Box":  // > Event action for page Evol Page:6
          // in this case, a cereal box is indeed a recyclable and   // > Event action for page Evol Page:7
          // hence, we perform the following steps for a correct answer.  // > Event action for page Evol Page:8
            // > Event action for page Evol Page:9
          // 1. show the green tick on the bin to indicate correctness  // > Event action for page Evol Page:10
          showRightOrWrongSymbol("correct", "recycle");  // > Event action for page Evol Page:11
          // 2. set currentRecycalable to Cereal Box   // > Event action for page Evol Page:12
          currentRecycalable = "Cereal Box";  // > Event action for page Evol Page:13
          // 3. set the attempt to be a correct attempt  // > Event action for page Evol Page:14
          isCorrect = true;  // > Event action for page Evol Page:15
          // 4. play a correct sound if the game is not muted  // > Event action for page Evol Page:16
          if (!isMuted) _view.correctSound.play();  // > Event action for page Evol Page:17
            // > Event action for page Evol Page:18
          // record question attempt on moodle  // > Event action for page Evol Page:19
          moodle.startQuestion('Q1');  // > Event action for page Evol Page:20
          moodle.addQuestionHistory("Recycle Bin "+"✅");  // > Event action for page Evol Page:21
          moodle.awardQuestionMarks(2);  // > Event action for page Evol Page:22
          moodle.endQuestion();  // > Event action for page Evol Page:23
            // > Event action for page Evol Page:24
          questions["Q1"]["choice"] = "Recycle Bin "+"✅";  // > Event action for page Evol Page:25
          break;  // > Event action for page Evol Page:26
          case "Glass Jar":  // > Event action for page Evol Page:27
          showRightOrWrongSymbol("correct", "recycle");    // > Event action for page Evol Page:28
          currentRecycalable = "Rinsed Used Glass Jar";  // > Event action for page Evol Page:29
          isCorrect = true;  // > Event action for page Evol Page:30
          if (!isMuted) _view.correctSound.play();  // > Event action for page Evol Page:31
            // > Event action for page Evol Page:32
          moodle.startQuestion('Q2');  // > Event action for page Evol Page:33
          moodle.addQuestionHistory("Recycle Bin "+"✅");  // > Event action for page Evol Page:34
          moodle.awardQuestionMarks(2);  // > Event action for page Evol Page:35
          moodle.endQuestion();  // > Event action for page Evol Page:36
            // > Event action for page Evol Page:37
          questions["Q2"]["choice"] = "Recycle Bin "+"✅";  // > Event action for page Evol Page:38
            // > Event action for page Evol Page:39
          break;  // > Event action for page Evol Page:40
          case "Food Cans":  // > Event action for page Evol Page:41
          showRightOrWrongSymbol("correct", "recycle");  // > Event action for page Evol Page:42
          currentRecycalable = "Food Cans";  // > Event action for page Evol Page:43
          isCorrect = true;  // > Event action for page Evol Page:44
          if (!isMuted) _view.correctSound.play();  // > Event action for page Evol Page:45
            // > Event action for page Evol Page:46
          moodle.startQuestion('Q3');  // > Event action for page Evol Page:47
          moodle.addQuestionHistory("Recycle Bin "+"✅");  // > Event action for page Evol Page:48
          moodle.awardQuestionMarks(2);  // > Event action for page Evol Page:49
          moodle.endQuestion();  // > Event action for page Evol Page:50
            // > Event action for page Evol Page:51
          questions["Q3"]["choice"] = "Recycle Bin "+"✅";  // > Event action for page Evol Page:52
            // > Event action for page Evol Page:53
          break;  // > Event action for page Evol Page:54
            // > Event action for page Evol Page:55
          case "Plastic Egg Tray":  // > Event action for page Evol Page:56
          showRightOrWrongSymbol("correct", "recycle");  // > Event action for page Evol Page:57
          currentRecycalable = "Plastic Egg Tray";  // > Event action for page Evol Page:58
          isCorrect = true;  // > Event action for page Evol Page:59
          if (!isMuted) _view.correctSound.play();  // > Event action for page Evol Page:60
            // > Event action for page Evol Page:61
          moodle.startQuestion('Q4');  // > Event action for page Evol Page:62
          moodle.addQuestionHistory("Recycle Bin "+"✅");  // > Event action for page Evol Page:63
          moodle.awardQuestionMarks(2);  // > Event action for page Evol Page:64
          moodle.endQuestion();  // > Event action for page Evol Page:65
            // > Event action for page Evol Page:66
          questions["Q4"]["choice"] = "Recycle Bin "+"✅";  // > Event action for page Evol Page:67
            // > Event action for page Evol Page:68
          break;  // > Event action for page Evol Page:69
            // > Event action for page Evol Page:70
          case "Plastic Food Packaging":  // > Event action for page Evol Page:71
          showRightOrWrongSymbol("incorrect", "recycle");  // > Event action for page Evol Page:72
          currentRecycalable = "Plastic Food Packaging";  // > Event action for page Evol Page:73
          isCorrect = false;  // > Event action for page Evol Page:74
          if (!isMuted) _view.wrongSound.play();  // > Event action for page Evol Page:75
            // > Event action for page Evol Page:76
          moodle.startQuestion('Q5');  // > Event action for page Evol Page:77
          moodle.addQuestionHistory("Recycle Bin "+"❌");  // > Event action for page Evol Page:78
          moodle.awardQuestionMarks(1);  // > Event action for page Evol Page:79
          moodle.endQuestion();  // > Event action for page Evol Page:80
            // > Event action for page Evol Page:81
          questions["Q5"]["choice"] = "Recycle Bin "+"❌";  // > Event action for page Evol Page:82
            // > Event action for page Evol Page:83
          break;  // > Event action for page Evol Page:84
            // > Event action for page Evol Page:85
          case "Toys":  // > Event action for page Evol Page:86
          showRightOrWrongSymbol("incorrect", "recycle");  // > Event action for page Evol Page:87
          currentRecycalable = "Toys";  // > Event action for page Evol Page:88
          isCorrect = false;  // > Event action for page Evol Page:89
          if (!isMuted) _view.wrongSound.play();  // > Event action for page Evol Page:90
            // > Event action for page Evol Page:91
          moodle.startQuestion('Q6');  // > Event action for page Evol Page:92
          moodle.addQuestionHistory("Recycle Bin "+"❌");  // > Event action for page Evol Page:93
          moodle.awardQuestionMarks(1);  // > Event action for page Evol Page:94
          moodle.endQuestion();  // > Event action for page Evol Page:95
            // > Event action for page Evol Page:96
          questions["Q6"]["choice"] = "Recycle Bin "+"❌";  // > Event action for page Evol Page:97
            // > Event action for page Evol Page:98
          break;  // > Event action for page Evol Page:99
            // > Event action for page Evol Page:100
          default:  // > Event action for page Evol Page:101
          // code block for game over?  // > Event action for page Evol Page:102
        }  // > Event action for page Evol Page:103
        _pause();  // > Event action for page Evol Page:104
        callFuncAfterSomeSeconds(2, showProgressBar);  // > Event action for page Evol Page:105
        callFuncAfterSomeSeconds(2, () => {  // > Event action for page Evol Page:106
          document.querySelector('#overlay').style.display = 'block';  // > Event action for page Evol Page:107
          showAnswerModal = true;  // > Event action for page Evol Page:108
          _update();  // > Event action for page Evol Page:109
          _view._update();  // > Event action for page Evol Page:110
        });  // > Event action for page Evol Page:111
        callFuncAfterSomeSeconds(2, hideBins);  // > Event action for page Evol Page:112
        callFuncAfterSomeSeconds(2.5, incrementProgressBarLevel);  // > Event action for page Evol Page:113
        recyclables.splice(getIndexOfRecyclable(recyclableName), 1); // remove recyclable from list of recyclables  // > Event action for page Evol Page:114
        round += 1;  // > Event action for page Evol Page:115
        return true;
      }

      return _eventSelf;
    }; // End of event

    _ODE_evolution1_Event3 = function() {
      var _eventSelf = {};

      _eventSelf.getTypeOfEvent = function() { return EJSS_ODE_SOLVERS.EVENT_TYPE.CROSSING_EVENT; };

      _eventSelf.getRootFindingMethod = function() { return EJSS_ODE_SOLVERS.EVENT_METHOD.BISECTION; };

      _eventSelf.getMaxIterations = function() { return 100; };

      _eventSelf.getTolerance = function() { return 1.0e-5; };

      _eventSelf.evaluate = function(_aState) { 
      // Extract our variables from _aState
        var __i=0;
        var __cOut=0;
        var x = _aState[__cOut++];
        var y = _aState[__cOut++];
        var vy = _aState[__cOut++];
        var t = _aState[__cOut++];
        var wasteBinPosX = draggerPosX + (spacingBetweenBins / 2);  // > Event zero-condition for page Evol Page:1
        var dx = x - wasteBinPosX;  // > Event zero-condition for page Evol Page:2
        var dy = y - 1.4;  // > Event zero-condition for page Evol Page:3
        var distance = Math.sqrt(dx * dx + dy * dy);  // > Event zero-condition for page Evol Page:4
        var spacing = 0.35; // tolerance for collision  // > Event zero-condition for page Evol Page:5
        return distance - spacing;  // > Event zero-condition for page Evol Page:6
      };

      _eventSelf.action = function() { 
      // Extract our variables from __state
        var __i=0;
        var __cOut=0;
        x = __state[__cOut++];
        y = __state[__cOut++];
        vy = __state[__cOut++];
        t = __state[__cOut++];
        var _returnValue = __userDefinedAction();
      // Copy our variables to __state[] 
        var __j=0;
        var __n=0;
        var __cIn=0;
        __state[__cIn++] = x;
        __state[__cIn++] = y;
        __state[__cIn++] = vy;
        __state[__cIn++] = t;
        return _returnValue;
      };

      function __userDefinedAction() {
        isItemInBin = true;  // > Event action for page Evol Page:1
        let resultText;  // > Event action for page Evol Page:2
        switch(recyclableName) {  // > Event action for page Evol Page:3
          case "Cereal Box":  // > Event action for page Evol Page:4
          showRightOrWrongSymbol("incorrect", "waste");  // > Event action for page Evol Page:5
          currentRecycalable = "Cereal Box";  // > Event action for page Evol Page:6
          isCorrect = false;  // > Event action for page Evol Page:7
          if (!isMuted) _view.wrongSound.play();  // > Event action for page Evol Page:8
            // > Event action for page Evol Page:9
          // send score to moodle  // > Event action for page Evol Page:10
          moodle.startQuestion('Q1');  // > Event action for page Evol Page:11
          moodle.addQuestionHistory("Waste Bin "+"❌");  // > Event action for page Evol Page:12
          moodle.awardQuestionMarks(1);  // > Event action for page Evol Page:13
          moodle.endQuestion();    // > Event action for page Evol Page:14
            // > Event action for page Evol Page:15
          // save choice in memory so as to populate summary at the end  // > Event action for page Evol Page:16
          questions["Q1"]["choice"] = "Waste Bin "+"❌";  // > Event action for page Evol Page:17
            // > Event action for page Evol Page:18
          break;  // > Event action for page Evol Page:19
            // > Event action for page Evol Page:20
          case "Glass Jar":  // > Event action for page Evol Page:21
          showRightOrWrongSymbol("incorrect", "waste");  // > Event action for page Evol Page:22
          currentRecycalable = "Rinsed Used Glass Jar";  // > Event action for page Evol Page:23
          isCorrect = false;  // > Event action for page Evol Page:24
          if (!isMuted) _view.wrongSound.play();  // > Event action for page Evol Page:25
            // > Event action for page Evol Page:26
          moodle.startQuestion('Q2');  // > Event action for page Evol Page:27
          moodle.addQuestionHistory("Waste Bin "+"❌");  // > Event action for page Evol Page:28
          moodle.awardQuestionMarks(1);  // > Event action for page Evol Page:29
          moodle.endQuestion();  // > Event action for page Evol Page:30
            // > Event action for page Evol Page:31
          questions["Q2"]["choice"] = "Waste Bin "+"❌";  // > Event action for page Evol Page:32
            // > Event action for page Evol Page:33
          break;  // > Event action for page Evol Page:34
          case "Food Cans":  // > Event action for page Evol Page:35
          showRightOrWrongSymbol("incorrect", "waste");  // > Event action for page Evol Page:36
          currentRecycalable = "Food Cans";  // > Event action for page Evol Page:37
          isCorrect = false;  // > Event action for page Evol Page:38
          if (!isMuted) _view.wrongSound.play();  // > Event action for page Evol Page:39
            // > Event action for page Evol Page:40
          moodle.startQuestion('Q3');  // > Event action for page Evol Page:41
          moodle.addQuestionHistory("Waste Bin "+"❌");  // > Event action for page Evol Page:42
          moodle.awardQuestionMarks(1);  // > Event action for page Evol Page:43
          moodle.endQuestion();  // > Event action for page Evol Page:44
            // > Event action for page Evol Page:45
          questions["Q3"]["choice"] = "Waste Bin "+"❌";  // > Event action for page Evol Page:46
            // > Event action for page Evol Page:47
          break;  // > Event action for page Evol Page:48
            // > Event action for page Evol Page:49
          case "Plastic Egg Tray":  // > Event action for page Evol Page:50
          showRightOrWrongSymbol("incorrect", "waste");  // > Event action for page Evol Page:51
          currentRecycalable = "Plastic Egg Tray";  // > Event action for page Evol Page:52
          isCorrect = false;  // > Event action for page Evol Page:53
          if (!isMuted) _view.wrongSound.play();  // > Event action for page Evol Page:54
            // > Event action for page Evol Page:55
          moodle.startQuestion('Q4');  // > Event action for page Evol Page:56
          moodle.addQuestionHistory("Waste Bin "+"❌");  // > Event action for page Evol Page:57
          moodle.awardQuestionMarks(1);  // > Event action for page Evol Page:58
          moodle.endQuestion();  // > Event action for page Evol Page:59
            // > Event action for page Evol Page:60
          questions["Q4"]["choice"] = "Waste Bin "+"❌";  // > Event action for page Evol Page:61
            // > Event action for page Evol Page:62
          break;  // > Event action for page Evol Page:63
            // > Event action for page Evol Page:64
          case "Plastic Food Packaging":  // > Event action for page Evol Page:65
          showRightOrWrongSymbol("correct", "waste");  // > Event action for page Evol Page:66
          currentRecycalable = "Plastic Food Packaging";  // > Event action for page Evol Page:67
          isCorrect = true;  // > Event action for page Evol Page:68
          if (!isMuted) _view.correctSound.play();  // > Event action for page Evol Page:69
            // > Event action for page Evol Page:70
          moodle.startQuestion('Q5');  // > Event action for page Evol Page:71
          moodle.addQuestionHistory("Waste Bin "+"✅");  // > Event action for page Evol Page:72
          moodle.awardQuestionMarks(2);  // > Event action for page Evol Page:73
          moodle.endQuestion();  // > Event action for page Evol Page:74
            // > Event action for page Evol Page:75
          questions["Q5"]["choice"] = "Waste Bin "+"✅";  // > Event action for page Evol Page:76
            // > Event action for page Evol Page:77
          break;  // > Event action for page Evol Page:78
            // > Event action for page Evol Page:79
          case "Toys":  // > Event action for page Evol Page:80
          showRightOrWrongSymbol("correct", "waste");  // > Event action for page Evol Page:81
          currentRecycalable = "Toys";  // > Event action for page Evol Page:82
          isCorrect = true;  // > Event action for page Evol Page:83
          if (!isMuted) _view.correctSound.play();  // > Event action for page Evol Page:84
            // > Event action for page Evol Page:85
          moodle.startQuestion('Q6');  // > Event action for page Evol Page:86
          moodle.addQuestionHistory("Waste Bin "+"✅");  // > Event action for page Evol Page:87
          moodle.awardQuestionMarks(2);  // > Event action for page Evol Page:88
          moodle.endQuestion();  // > Event action for page Evol Page:89
            // > Event action for page Evol Page:90
          questions["Q6"]["choice"] = "Waste Bin "+"✅";  // > Event action for page Evol Page:91
            // > Event action for page Evol Page:92
          break;  // > Event action for page Evol Page:93
            // > Event action for page Evol Page:94
          default:  // > Event action for page Evol Page:95
          // code block for game over?  // > Event action for page Evol Page:96
        }  // > Event action for page Evol Page:97
        _pause();  // > Event action for page Evol Page:98
        callFuncAfterSomeSeconds(2, showProgressBar);  // > Event action for page Evol Page:99
        callFuncAfterSomeSeconds(2, () => {  // > Event action for page Evol Page:100
          document.querySelector('#overlay').style.display = 'block';  // > Event action for page Evol Page:101
          showAnswerModal = true;  // > Event action for page Evol Page:102
          _update();  // > Event action for page Evol Page:103
          _view._update();  // > Event action for page Evol Page:104
        });  // > Event action for page Evol Page:105
        callFuncAfterSomeSeconds(2, hideBins);  // > Event action for page Evol Page:106
        callFuncAfterSomeSeconds(2.5, incrementProgressBarLevel);  // > Event action for page Evol Page:107
        recyclables.splice(getIndexOfRecyclable(recyclableName), 1); // remove recyclable from list of recyclables  // > Event action for page Evol Page:108
        round += 1;  // > Event action for page Evol Page:109
        return true;
      }

      return _eventSelf;
    }; // End of event

    __instantiateSolver();

    return __odeSelf;
  }

  function _historic_x(__time) {
    var __index = 0;
    return _ODEi_evolution1.getEventSolver().getStateHistory().interpolate(__time,__index);
  }

  function _historic_y(__time) {
    var __index = 0 + 1;
    return _ODEi_evolution1.getEventSolver().getStateHistory().interpolate(__time,__index);
  }

  function _historic_vy(__time) {
    var __index = 0 + 1 + 1;
    return _ODEi_evolution1.getEventSolver().getStateHistory().interpolate(__time,__index);
  }

    _model._fontResized = function(iBase,iSize,iDelta) {
      _view._fontResized(iBase,iSize,iDelta);
  }; // end of _fontResized

  function _getViews() {
    var _viewsInfo = [];
    var _counter = 0;
    _viewsInfo[_counter++] = { name : "HtmlView Page", width : null, height : null };
    return _viewsInfo;
  } // end of _getViews

  function _selectView(_viewNumber) {
    _view = null;
    _view = new sustainability_View(_topFrame,_viewNumber,_libraryPath,_codebasePath);
    var _view_super_reset = _view._reset;
    _view._reset = function() {
      _view_super_reset();
      switch(_viewNumber) {
        case -10 : break; // make Lint happy
        default :
        case 0:
          _view.plottingPanel.linkProperty("Height",  function() { return changeOrientation(kheight); }, function(_v) { changeOrientation(kheight) = _v; } ); // HtmlView Page linking property 'Height' for element 'plottingPanel'
          _view.plottingPanel.setAction("OnDoubleClick", function(_data,_info) {
  currentPage = "congratulatePlayer";
  document.getElementById('gameScreen').style.opacity = '0';

}); // HtmlView Page setting action 'OnDoubleClick' for element 'plottingPanel'
          _view.plottingPanel.linkProperty("MaximumY",  function() { return Math.max(6, y); } ); // HtmlView Page linking property 'MaximumY' for element 'plottingPanel'
          _view.plottingPanel.linkProperty("MaximumX",  function() { return Math.max(11, x); } ); // HtmlView Page linking property 'MaximumX' for element 'plottingPanel'
          _view.plottingPanel.linkProperty("MinimumX",  function() { return Math.min(0, x); } ); // HtmlView Page linking property 'MinimumX' for element 'plottingPanel'
          _view.bins.linkProperty("Visibility",  function() { return currentPage=="gameScreen"?true:false; } ); // HtmlView Page linking property 'Visibility' for element 'bins'
          _view.recycle.linkProperty("SizeX",  function() { return binWidth; }, function(_v) { binWidth = _v; } ); // HtmlView Page linking property 'SizeX' for element 'recycle'
          _view.recycle.linkProperty("X",  function() { return draggerPosX - (spacingBetweenBins / 2); } ); // HtmlView Page linking property 'X' for element 'recycle'
          _view.recycle.linkProperty("SizeY",  function() { return binHeight; }, function(_v) { binHeight = _v; } ); // HtmlView Page linking property 'SizeY' for element 'recycle'
          _view.r_correct.linkProperty("SizeX",  function() { return symbolWidth; }, function(_v) { symbolWidth = _v; } ); // HtmlView Page linking property 'SizeX' for element 'r_correct'
          _view.r_correct.linkProperty("X",  function() { return draggerPosX - (spacingBetweenBins / 2); } ); // HtmlView Page linking property 'X' for element 'r_correct'
          _view.r_correct.linkProperty("SizeY",  function() { return symbolHeight; }, function(_v) { symbolHeight = _v; } ); // HtmlView Page linking property 'SizeY' for element 'r_correct'
          _view.r_incorrect.linkProperty("SizeX",  function() { return symbolWidth; }, function(_v) { symbolWidth = _v; } ); // HtmlView Page linking property 'SizeX' for element 'r_incorrect'
          _view.r_incorrect.linkProperty("X",  function() { return draggerPosX - (spacingBetweenBins / 2); } ); // HtmlView Page linking property 'X' for element 'r_incorrect'
          _view.r_incorrect.linkProperty("SizeY",  function() { return symbolHeight; }, function(_v) { symbolHeight = _v; } ); // HtmlView Page linking property 'SizeY' for element 'r_incorrect'
          _view.waste.linkProperty("SizeX",  function() { return binWidth; }, function(_v) { binWidth = _v; } ); // HtmlView Page linking property 'SizeX' for element 'waste'
          _view.waste.linkProperty("X",  function() { return draggerPosX + (spacingBetweenBins / 2); } ); // HtmlView Page linking property 'X' for element 'waste'
          _view.waste.linkProperty("SizeY",  function() { return binHeight; }, function(_v) { binHeight = _v; } ); // HtmlView Page linking property 'SizeY' for element 'waste'
          _view.w_correct.linkProperty("SizeX",  function() { return symbolWidth; }, function(_v) { symbolWidth = _v; } ); // HtmlView Page linking property 'SizeX' for element 'w_correct'
          _view.w_correct.linkProperty("X",  function() { return draggerPosX + (spacingBetweenBins / 2); } ); // HtmlView Page linking property 'X' for element 'w_correct'
          _view.w_correct.linkProperty("SizeY",  function() { return symbolHeight; }, function(_v) { symbolHeight = _v; } ); // HtmlView Page linking property 'SizeY' for element 'w_correct'
          _view.w_incorrect.linkProperty("SizeX",  function() { return symbolWidth; }, function(_v) { symbolWidth = _v; } ); // HtmlView Page linking property 'SizeX' for element 'w_incorrect'
          _view.w_incorrect.linkProperty("X",  function() { return draggerPosX + (spacingBetweenBins / 2); } ); // HtmlView Page linking property 'X' for element 'w_incorrect'
          _view.w_incorrect.linkProperty("SizeY",  function() { return symbolHeight; }, function(_v) { symbolHeight = _v; } ); // HtmlView Page linking property 'SizeY' for element 'w_incorrect'
          _view.instructions.linkProperty("X",  function() { return draggerPosX; }, function(_v) { draggerPosX = _v; } ); // HtmlView Page linking property 'X' for element 'instructions'
          _view.instructions.linkProperty("Visibility",  function() { return !gameStarted; } ); // HtmlView Page linking property 'Visibility' for element 'instructions'
          _view.invisibleDragger.linkProperty("SizeX",  function() { return binWidth * 2; } ); // HtmlView Page linking property 'SizeX' for element 'invisibleDragger'
          _view.invisibleDragger.linkProperty("X",  function() { return draggerPosX; }, function(_v) { draggerPosX = _v; } ); // HtmlView Page linking property 'X' for element 'invisibleDragger'
          _view.invisibleDragger.setAction("OnPress", function(_data,_info) {
  if (!gameStarted) {
    gameStarted = true;
  }
  _play();
  if (!isMuted) _view.itemThrownSound.play();
  itemIsNotFlying = false;

}); // HtmlView Page setting action 'OnPress' for element 'invisibleDragger'
          _view.invisibleDragger.linkProperty("SizeY",  function() { return binHeight; }, function(_v) { binHeight = _v; } ); // HtmlView Page linking property 'SizeY' for element 'invisibleDragger'
          _view.recyclableName.linkProperty("Y",  function() { return recyclableNameContainerPosY; }, function(_v) { recyclableNameContainerPosY = _v; } ); // HtmlView Page linking property 'Y' for element 'recyclableName'
          _view.recyclableName.linkProperty("Visibility",  function() { return currentPage=="gameScreen"&&itemIsNotFlying?true:false; } ); // HtmlView Page linking property 'Visibility' for element 'recyclableName'
          _view.image.linkProperty("SizeX",  function() { return recyclableNameContainerWidth; }, function(_v) { recyclableNameContainerWidth = _v; } ); // HtmlView Page linking property 'SizeX' for element 'image'
          _view.image.linkProperty("SizeY",  function() { return recyclableNameContainerHeight; }, function(_v) { recyclableNameContainerHeight = _v; } ); // HtmlView Page linking property 'SizeY' for element 'image'
          _view.text.linkProperty("FontSize",  function() { return recyclableTitleFontSize; }, function(_v) { recyclableTitleFontSize = _v; } ); // HtmlView Page linking property 'FontSize' for element 'text'
          _view.text.linkProperty("Text",  function() { return recyclableName; }, function(_v) { recyclableName = _v; } ); // HtmlView Page linking property 'Text' for element 'text'
          _view.recyclableItem.linkProperty("SizeX",  function() { return recyclableItemWidth; }, function(_v) { recyclableItemWidth = _v; } ); // HtmlView Page linking property 'SizeX' for element 'recyclableItem'
          _view.recyclableItem.linkProperty("X",  function() { return x; }, function(_v) { x = _v; } ); // HtmlView Page linking property 'X' for element 'recyclableItem'
          _view.recyclableItem.linkProperty("Y",  function() { return y; }, function(_v) { y = _v; } ); // HtmlView Page linking property 'Y' for element 'recyclableItem'
          _view.recyclableItem.linkProperty("Visibility",  function() { return !isItemInBin; } ); // HtmlView Page linking property 'Visibility' for element 'recyclableItem'
          _view.recyclableItem.linkProperty("SizeY",  function() { return recyclableItemHeight; }, function(_v) { recyclableItemHeight = _v; } ); // HtmlView Page linking property 'SizeY' for element 'recyclableItem'
          _view.soundControl_Mute.linkProperty("Visibility",  function() { return !isMuted; } ); // HtmlView Page linking property 'Visibility' for element 'soundControl_Mute'
          _view.soundControl_Mute.setAction("OnClick", function(_data,_info) {
  isMuted = true;
  _view.backgroundMusic.pause();
  _view.correctSound.pause();
  _view.wrongSound.pause();
  _view.landOnFloor.pause();
  _view.itemThrownSound.pause();

}); // HtmlView Page setting action 'OnClick' for element 'soundControl_Mute'
          _view.soundControl_Play.linkProperty("Visibility",  function() { return isMuted; }, function(_v) { isMuted = _v; } ); // HtmlView Page linking property 'Visibility' for element 'soundControl_Play'
          _view.soundControl_Play.setAction("OnClick", function(_data,_info) {
  isMuted = false;
  _view.backgroundMusic.play();

}); // HtmlView Page setting action 'OnClick' for element 'soundControl_Play'
          _view.cereal_right.linkProperty("Display",  function() { return showAnswerModal&&isCorrect&&currentRecycalable=="Cereal Box"?"block":"none"; } ); // HtmlView Page linking property 'Display' for element 'cereal_right'
          _view.cereal_wrong.linkProperty("Display",  function() { return showAnswerModal&&!isCorrect&&currentRecycalable=="Cereal Box"?"block":"none"; } ); // HtmlView Page linking property 'Display' for element 'cereal_wrong'
          _view.toys_right.linkProperty("Display",  function() { return showAnswerModal&&isCorrect&&currentRecycalable=="Toys"?"block":"none"; } ); // HtmlView Page linking property 'Display' for element 'toys_right'
          _view.toys_wrong.linkProperty("Display",  function() { return showAnswerModal&&!isCorrect&&currentRecycalable=="Toys"?"block":"none"; } ); // HtmlView Page linking property 'Display' for element 'toys_wrong'
          _view.glassjar_right.linkProperty("Display",  function() { return showAnswerModal&&isCorrect&&currentRecycalable=="Rinsed Used Glass Jar"?"block":"none"; } ); // HtmlView Page linking property 'Display' for element 'glassjar_right'
          _view.glassjar_wrong.linkProperty("Display",  function() { return showAnswerModal&&!isCorrect&&currentRecycalable=="Rinsed Used Glass Jar"?"block":"none"; } ); // HtmlView Page linking property 'Display' for element 'glassjar_wrong'
          _view.foodcans_right.linkProperty("Display",  function() { return showAnswerModal&&isCorrect&&currentRecycalable=="Food Cans"?"block":"none"; } ); // HtmlView Page linking property 'Display' for element 'foodcans_right'
          _view.foodcans_wrong.linkProperty("Display",  function() { return showAnswerModal&&!isCorrect&&currentRecycalable=="Food Cans"?"block":"none"; } ); // HtmlView Page linking property 'Display' for element 'foodcans_wrong'
          _view.eggtray_right.linkProperty("Display",  function() { return showAnswerModal&&isCorrect&&currentRecycalable=="Plastic Egg Tray"?"block":"none"; } ); // HtmlView Page linking property 'Display' for element 'eggtray_right'
          _view.eggtray_wrong.linkProperty("Display",  function() { return showAnswerModal&&!isCorrect&&currentRecycalable=="Plastic Egg Tray"?"block":"none"; } ); // HtmlView Page linking property 'Display' for element 'eggtray_wrong'
          _view.foodpackaging_right.linkProperty("Display",  function() { return showAnswerModal&&isCorrect&&currentRecycalable=="Plastic Food Packaging"?"block":"none"; } ); // HtmlView Page linking property 'Display' for element 'foodpackaging_right'
          _view.foodpackaging_wrong.linkProperty("Display",  function() { return showAnswerModal&&!isCorrect&&currentRecycalable=="Plastic Food Packaging"?"block":"none"; } ); // HtmlView Page linking property 'Display' for element 'foodpackaging_wrong'
          _view.oops.linkProperty("Display",  function() { return hitDaFloor?"block":"none"; } ); // HtmlView Page linking property 'Display' for element 'oops'
          _view.gameEnd.linkProperty("Display",  function() { return currentPage=="gameEnd"?"flex":"none"; } ); // HtmlView Page linking property 'Display' for element 'gameEnd'
          _view.btn.setAction("OnClick", function(_data,_info) {
  if (gameStarted) {
      
      
   if (round <= 5) {
    // reset objects to initial values to throw again
    resetRecyclableItemAttributes();
    randomiseThrowTrajectory();
    t=0;
    
    itemIsNotFlying = true;
    isItemInBin = false;
    
    hideAllRightOrWrongSymbols();
    
    if (!playerMissed) {
      generateRandomRecyclable();
      // increase speed of throw after each successful round
      _model.setStepsPerDisplay(1 + 0.1*round); 
      
      // progress bar
      hideProgressBar();
    }  
    playerMissed = false; // reset it
    showBins();
   
    
  } else {
    // game ended
    _view.backgroundMusic.pause();
    document.getElementById('gameScreen').style.opacity = '0';
    currentPage="gameEnd";
  } 
  }
  hideModal();

}); // HtmlView Page setting action 'OnClick' for element 'btn'
          break;
      } // end of switch
    }; // end of new reset

    _model.setView(_view);
    _model.reset();
    _view._enableEPub();
  } // end of _selectView

  _model.setAutoplay(false);
  _model.setFPS(100);
  _model.setStepsPerDisplay(1);
  _selectView(_model._autoSelectView(_getViews())); // this includes _model.reset()
  return _model;
}
function sustainability_View (_topFrame,_viewNumber,_libraryPath,_codebasePath) {
  var _view;
  switch(_viewNumber) {
    case -10 : break; // make Lint happy
    default :
    case 0: _view = sustainability_View_0 (_topFrame); break;
  } // end of switch

  if (_codebasePath) _view._setResourcePath(_codebasePath);

  if (_libraryPath) _view._setLibraryPath(_libraryPath);


  return _view;
} // end of main function

function sustainability_View_0 (_topFrame) {
  var _view = EJSS_CORE.createView(_topFrame);

  _view._reset = function() {
    _view._clearAll();
    _view._addElement(EJSS_INTERFACE.panel,"gameStart", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'gameStart'
      .setProperty("Html","<svg width=\"206\" height=\"333\" viewBox=\"0 0 206 333\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\"> <path d=\"M23.3973 36C22.7253 36 22.1013 35.84 21.5253 35.52C20.9493 35.168 20.6613 34.656 20.6613 33.984V2.928C20.6613 2.256 20.9493 1.76 21.5253 1.44C22.1013 1.088 22.7253 0.912 23.3973 0.912H40.4853C41.1893 0.912 41.6853 1.2 41.9733 1.776C42.2933 2.352 42.4532 2.96 42.4532 3.6C42.4532 4.368 42.2773 5.024 41.9253 5.568C41.6053 6.112 41.1253 6.384 40.4853 6.384H26.9013V15.984H34.1973C34.8373 15.984 35.3173 16.24 35.6373 16.752C35.9893 17.232 36.1653 17.808 36.1653 18.48C36.1653 19.024 36.0053 19.568 35.6853 20.112C35.3973 20.624 34.9013 20.88 34.1973 20.88H26.9013V30.528H40.4853C41.1253 30.528 41.6053 30.8 41.9253 31.344C42.2773 31.888 42.4532 32.544 42.4532 33.312C42.4532 33.952 42.2933 34.56 41.9733 35.136C41.6853 35.712 41.1893 36 40.4853 36H23.3973ZM54.5324 36.432C52.1004 36.432 50.1164 36 48.5804 35.136C47.0444 34.272 45.9084 33.104 45.1724 31.632C44.4364 30.128 44.0684 28.448 44.0684 26.592V22.752C44.0684 20.896 44.4204 19.232 45.1244 17.76C45.8604 16.256 46.9964 15.072 48.5324 14.208C50.1004 13.344 52.0684 12.912 54.4364 12.912C55.9404 12.912 57.2684 13.088 58.4204 13.44C59.5724 13.792 60.4844 14.256 61.1564 14.832C61.8284 15.408 62.1644 16.016 62.1644 16.656C62.1644 17.04 62.0524 17.472 61.8284 17.952C61.6364 18.4 61.3484 18.8 60.9644 19.152C60.6124 19.504 60.1964 19.68 59.7164 19.68C59.3644 19.68 58.9964 19.568 58.6124 19.344C58.2604 19.12 57.7964 18.896 57.2204 18.672C56.6444 18.448 55.8764 18.336 54.9164 18.336C53.2844 18.336 52.1004 18.736 51.3644 19.536C50.6284 20.304 50.2604 21.376 50.2604 22.752V26.592C50.2604 27.968 50.6284 29.056 51.3644 29.856C52.1004 30.624 53.3004 31.008 54.9644 31.008C55.9564 31.008 56.7244 30.88 57.2684 30.624C57.8124 30.368 58.2604 30.128 58.6124 29.904C58.9964 29.68 59.3804 29.568 59.7644 29.568C60.3404 29.568 60.8204 29.728 61.2044 30.048C61.6204 30.368 61.9244 30.768 62.1164 31.248C62.3404 31.696 62.4524 32.112 62.4524 32.496C62.4524 33.136 62.1004 33.76 61.3964 34.368C60.7244 34.976 59.7804 35.472 58.5644 35.856C57.3804 36.24 56.0364 36.432 54.5324 36.432ZM74.9196 36.432C73.0636 36.432 71.3516 35.984 69.7836 35.088C68.2156 34.16 66.9516 32.944 65.9916 31.44C65.0316 29.936 64.5516 28.32 64.5516 26.592V22.656C64.5516 20.928 65.0156 19.328 65.9436 17.856C66.8716 16.352 68.1196 15.152 69.6876 14.256C71.2876 13.36 73.0316 12.912 74.9196 12.912C76.8076 12.912 78.5356 13.36 80.1036 14.256C81.7036 15.12 82.9676 16.288 83.8956 17.76C84.8556 19.232 85.3356 20.864 85.3356 22.656V26.592C85.3356 28.288 84.8556 29.888 83.8956 31.392C82.9356 32.896 81.6556 34.112 80.0556 35.04C78.4876 35.968 76.7756 36.432 74.9196 36.432ZM74.9196 31.008C75.6876 31.008 76.3916 30.8 77.0316 30.384C77.6716 29.968 78.1836 29.424 78.5676 28.752C78.9516 28.048 79.1436 27.328 79.1436 26.592V22.656C79.1436 21.92 78.9516 21.232 78.5676 20.592C78.1836 19.952 77.6716 19.424 77.0316 19.008C76.4236 18.56 75.7196 18.336 74.9196 18.336C74.1516 18.336 73.4476 18.544 72.8076 18.96C72.1676 19.376 71.6556 19.92 71.2716 20.592C70.9196 21.232 70.7436 21.92 70.7436 22.656V26.592C70.7436 27.328 70.9196 28.048 71.2716 28.752C71.6556 29.424 72.1676 29.968 72.8076 30.384C73.4476 30.8 74.1516 31.008 74.9196 31.008ZM99.0213 36.432C96.9413 36.432 95.0533 36.128 93.3573 35.52C91.6933 34.912 90.3653 34.16 89.3733 33.264C88.4133 32.336 87.9333 31.408 87.9333 30.48C87.9333 30.032 88.0453 29.552 88.2693 29.04C88.5253 28.496 88.8613 28.048 89.2773 27.696C89.6933 27.312 90.1573 27.12 90.6693 27.12C91.1813 27.12 91.6613 27.312 92.1093 27.696C92.5573 28.048 93.0693 28.48 93.6453 28.992C94.2213 29.472 94.9253 29.904 95.7573 30.288C96.5893 30.64 97.6133 30.816 98.8293 30.816C99.7893 30.816 100.669 30.672 101.469 30.384C102.301 30.064 102.957 29.6 103.437 28.992C103.949 28.384 104.205 27.6 104.205 26.64C104.205 25.616 103.933 24.752 103.389 24.048C102.845 23.344 102.109 22.736 101.181 22.224C100.253 21.712 99.2453 21.216 98.1573 20.736C97.0693 20.256 95.9653 19.744 94.8453 19.2C93.7573 18.656 92.7493 18 91.8213 17.232C90.9253 16.464 90.1893 15.52 89.6133 14.4C89.0693 13.28 88.7973 11.904 88.7973 10.272C88.7973 8.48 89.1333 6.976 89.8053 5.76C90.5093 4.544 91.4213 3.568 92.5413 2.832C93.6933 2.064 94.9573 1.52 96.3333 1.2C97.7093 0.847998 99.0853 0.671997 100.461 0.671997C101.197 0.671997 102.061 0.735997 103.053 0.863997C104.077 0.959998 105.085 1.152 106.077 1.44C107.101 1.728 107.933 2.128 108.573 2.64C109.245 3.12 109.581 3.76 109.581 4.56C109.581 4.912 109.485 5.344 109.293 5.856C109.133 6.368 108.861 6.832 108.477 7.248C108.125 7.664 107.661 7.872 107.085 7.872C106.573 7.872 106.061 7.728 105.549 7.44C105.069 7.12 104.429 6.816 103.629 6.528C102.861 6.208 101.805 6.048 100.461 6.048C99.3413 6.048 98.3653 6.192 97.5333 6.48C96.7013 6.768 96.0773 7.184 95.6613 7.728C95.2453 8.24 95.0373 8.896 95.0373 9.696C95.0373 10.528 95.3093 11.232 95.8533 11.808C96.4293 12.384 97.1653 12.896 98.0613 13.344C98.9893 13.792 99.9973 14.24 101.085 14.688C102.173 15.136 103.261 15.664 104.349 16.272C105.469 16.848 106.493 17.552 107.421 18.384C108.349 19.216 109.085 20.256 109.629 21.504C110.173 22.72 110.445 24.224 110.445 26.016C110.445 28.288 109.949 30.208 108.957 31.776C107.965 33.312 106.605 34.48 104.877 35.28C103.181 36.048 101.229 36.432 99.0213 36.432ZM123.763 36.432C121.907 36.432 120.195 35.984 118.627 35.088C117.059 34.16 115.795 32.944 114.835 31.44C113.875 29.936 113.395 28.32 113.395 26.592V22.656C113.395 20.928 113.859 19.328 114.787 17.856C115.715 16.352 116.963 15.152 118.531 14.256C120.131 13.36 121.875 12.912 123.763 12.912C125.651 12.912 127.379 13.36 128.947 14.256C130.547 15.12 131.811 16.288 132.739 17.76C133.699 19.232 134.179 20.864 134.179 22.656V26.592C134.179 28.288 133.699 29.888 132.739 31.392C131.779 32.896 130.499 34.112 128.899 35.04C127.331 35.968 125.619 36.432 123.763 36.432ZM123.763 31.008C124.531 31.008 125.235 30.8 125.875 30.384C126.515 29.968 127.027 29.424 127.411 28.752C127.795 28.048 127.987 27.328 127.987 26.592V22.656C127.987 21.92 127.795 21.232 127.411 20.592C127.027 19.952 126.515 19.424 125.875 19.008C125.267 18.56 124.563 18.336 123.763 18.336C122.995 18.336 122.291 18.544 121.651 18.96C121.011 19.376 120.499 19.92 120.115 20.592C119.763 21.232 119.587 21.92 119.587 22.656V26.592C119.587 27.328 119.763 28.048 120.115 28.752C120.499 29.424 121.011 29.968 121.651 30.384C122.291 30.8 122.995 31.008 123.763 31.008ZM141.143 36C140.279 36 139.559 35.792 138.983 35.376C138.407 34.96 138.119 34.496 138.119 33.984V15.12C138.119 14.544 138.407 14.08 138.983 13.728C139.559 13.376 140.279 13.2 141.143 13.2C141.943 13.2 142.599 13.376 143.111 13.728C143.655 14.08 143.927 14.544 143.927 15.12V17.088C144.279 16.384 144.743 15.728 145.319 15.12C145.927 14.48 146.615 13.952 147.383 13.536C148.151 13.12 148.967 12.912 149.831 12.912H151.319C151.927 12.912 152.455 13.184 152.903 13.728C153.351 14.24 153.575 14.864 153.575 15.6C153.575 16.368 153.351 17.024 152.903 17.568C152.455 18.08 151.927 18.336 151.319 18.336H149.831C148.935 18.336 148.055 18.64 147.191 19.248C146.359 19.824 145.671 20.64 145.127 21.696C144.583 22.72 144.311 23.968 144.311 25.44V33.984C144.311 34.496 144.007 34.96 143.399 35.376C142.791 35.792 142.039 36 141.143 36ZM164.903 36C162.023 36 159.815 35.376 158.279 34.128C156.775 32.88 156.023 30.896 156.023 28.176V4.944C156.023 4.368 156.359 3.904 157.031 3.552C157.703 3.2 158.391 3.024 159.095 3.024C159.863 3.024 160.567 3.2 161.207 3.552C161.879 3.904 162.215 4.368 162.215 4.944V13.2H167.879C168.391 13.2 168.775 13.44 169.031 13.92C169.319 14.368 169.463 14.88 169.463 15.456C169.463 16.032 169.319 16.56 169.031 17.04C168.775 17.488 168.391 17.712 167.879 17.712H162.215V28.176C162.215 29.136 162.407 29.808 162.791 30.192C163.207 30.576 163.911 30.768 164.903 30.768H166.775C167.671 30.768 168.327 31.04 168.743 31.584C169.191 32.128 169.415 32.72 169.415 33.36C169.415 34.032 169.191 34.64 168.743 35.184C168.327 35.728 167.671 36 166.775 36H164.903Z\" fill=\"#FF0082\"/> <path d=\"M2.27539 65C1.95539 65 1.65539 64.9333 1.37539 64.8C1.10872 64.6533 0.975391 64.44 0.975391 64.16V51.2C0.975391 50.9067 1.10872 50.7 1.37539 50.58C1.65539 50.4467 1.95539 50.38 2.27539 50.38C2.60872 50.38 2.90872 50.4467 3.17539 50.58C3.44206 50.7 3.57539 50.9067 3.57539 51.2V56.64L7.91539 50.76C8.08872 50.5067 8.32206 50.38 8.61539 50.38C8.84206 50.38 9.06872 50.4467 9.29539 50.58C9.53539 50.7133 9.73539 50.88 9.89539 51.08C10.0554 51.28 10.1354 51.4933 10.1354 51.72C10.1354 51.7867 10.1221 51.8667 10.0954 51.96C10.0687 52.0533 10.0221 52.14 9.95539 52.22L6.39539 56.7L10.7554 63.34C10.8487 63.4867 10.8954 63.64 10.8954 63.8C10.8954 64.0133 10.8154 64.22 10.6554 64.42C10.5087 64.62 10.3154 64.7867 10.0754 64.92C9.83539 65.04 9.58872 65.1 9.33539 65.1C9.14872 65.1 8.97539 65.06 8.81539 64.98C8.66872 64.9 8.53539 64.7733 8.41539 64.6L4.65539 58.9L3.57539 60.26V64.16C3.57539 64.44 3.44206 64.6533 3.17539 64.8C2.90872 64.9333 2.60872 65 2.27539 65ZM13.1101 65C12.7367 65 12.4301 64.9133 12.1901 64.74C11.9501 64.5667 11.8301 64.3733 11.8301 64.16V56.3C11.8301 56.06 11.9501 55.8667 12.1901 55.72C12.4301 55.5733 12.7367 55.5 13.1101 55.5C13.4301 55.5 13.6967 55.5733 13.9101 55.72C14.1367 55.8667 14.2501 56.06 14.2501 56.3V56.9C14.4501 56.5133 14.7767 56.1667 15.2301 55.86C15.6967 55.54 16.2634 55.38 16.9301 55.38C17.5567 55.38 18.1301 55.5667 18.6501 55.94C19.1701 56.3 19.5834 56.7867 19.8901 57.4C20.2101 58.0133 20.3701 58.6933 20.3701 59.44V64.16C20.3701 64.44 20.2367 64.6533 19.9701 64.8C19.7034 64.9333 19.4034 65 19.0701 65C18.7767 65 18.4901 64.9333 18.2101 64.8C17.9301 64.6533 17.7901 64.44 17.7901 64.16V59.44C17.7901 59.1333 17.7101 58.8467 17.5501 58.58C17.4034 58.3133 17.1967 58.0933 16.9301 57.92C16.6634 57.7333 16.3701 57.64 16.0501 57.64C15.7834 57.64 15.5234 57.7133 15.2701 57.86C15.0167 58.0067 14.8101 58.2133 14.6501 58.48C14.4901 58.7467 14.4101 59.0667 14.4101 59.44V64.16C14.4101 64.3733 14.2834 64.5667 14.0301 64.74C13.7767 64.9133 13.4701 65 13.1101 65ZM26.2588 65.18C25.4855 65.18 24.7722 64.9933 24.1188 64.62C23.4655 64.2333 22.9388 63.7267 22.5388 63.1C22.1388 62.4733 21.9388 61.8 21.9388 61.08V59.44C21.9388 58.72 22.1322 58.0533 22.5188 57.44C22.9055 56.8133 23.4255 56.3133 24.0788 55.94C24.7455 55.5667 25.4722 55.38 26.2588 55.38C27.0455 55.38 27.7655 55.5667 28.4188 55.94C29.0855 56.3 29.6122 56.7867 29.9988 57.4C30.3988 58.0133 30.5988 58.6933 30.5988 59.44V61.08C30.5988 61.7867 30.3988 62.4533 29.9988 63.08C29.5988 63.7067 29.0655 64.2133 28.3988 64.6C27.7455 64.9867 27.0322 65.18 26.2588 65.18ZM26.2588 62.92C26.5788 62.92 26.8722 62.8333 27.1388 62.66C27.4055 62.4867 27.6188 62.26 27.7788 61.98C27.9388 61.6867 28.0188 61.3867 28.0188 61.08V59.44C28.0188 59.1333 27.9388 58.8467 27.7788 58.58C27.6188 58.3133 27.4055 58.0933 27.1388 57.92C26.8855 57.7333 26.5922 57.64 26.2588 57.64C25.9388 57.64 25.6455 57.7267 25.3788 57.9C25.1122 58.0733 24.8988 58.3 24.7388 58.58C24.5922 58.8467 24.5188 59.1333 24.5188 59.44V61.08C24.5188 61.3867 24.5922 61.6867 24.7388 61.98C24.8988 62.26 25.1122 62.4867 25.3788 62.66C25.6455 62.8333 25.9388 62.92 26.2588 62.92ZM35.5402 65.22C35.3136 65.22 35.1069 65.1867 34.9202 65.12C34.7336 65.0533 34.6069 64.9267 34.5402 64.74L31.4402 56.84C31.4136 56.7467 31.3936 56.6733 31.3802 56.62C31.3669 56.5533 31.3602 56.5 31.3602 56.46C31.3602 56.2467 31.4469 56.0667 31.6202 55.92C31.8069 55.76 32.0336 55.6333 32.3002 55.54C32.5669 55.4467 32.8069 55.4 33.0202 55.4C33.1936 55.4 33.3469 55.4333 33.4802 55.5C33.6269 55.5667 33.7269 55.6733 33.7802 55.82L35.7802 61.5L37.2802 56.56C37.3469 56.3333 37.4602 56.1933 37.6202 56.14C37.7802 56.0733 37.9602 56.04 38.1602 56.04C38.3602 56.04 38.5402 56.0733 38.7002 56.14C38.8602 56.1933 38.9736 56.3333 39.0402 56.56L40.5202 61.52L42.5402 55.82C42.6336 55.54 42.8736 55.4 43.2602 55.4C43.4736 55.4 43.7136 55.4467 43.9802 55.54C44.2469 55.6333 44.4736 55.76 44.6602 55.92C44.8469 56.08 44.9402 56.2667 44.9402 56.48C44.9402 56.5333 44.9336 56.5933 44.9202 56.66C44.9069 56.7267 44.8869 56.7867 44.8602 56.84L41.7602 64.76C41.6936 64.9333 41.5669 65.0533 41.3802 65.12C41.1936 65.1867 40.9869 65.22 40.7602 65.22C40.5202 65.22 40.3002 65.18 40.1002 65.1C39.9002 65.02 39.7669 64.9067 39.7002 64.76L38.1602 60.4L36.6202 64.74C36.5802 64.9 36.4536 65.02 36.2402 65.1C36.0269 65.18 35.7936 65.22 35.5402 65.22ZM54.8118 65C54.4918 65 54.1918 64.9333 53.9118 64.8C53.6451 64.6533 53.5118 64.44 53.5118 64.16V59.14C53.5118 59.0333 53.4918 58.9467 53.4518 58.88L49.3118 51.72C49.2851 51.6667 49.2651 51.62 49.2518 51.58C49.2518 51.5267 49.2518 51.4867 49.2518 51.46C49.2518 51.2467 49.3451 51.06 49.5318 50.9C49.7185 50.74 49.9451 50.6133 50.2118 50.52C50.4785 50.4267 50.7318 50.38 50.9718 50.38C51.1851 50.38 51.3451 50.4267 51.4518 50.52C51.5585 50.6 51.6585 50.7267 51.7518 50.9L54.8118 56.68L57.8518 50.9C57.9585 50.7267 58.0651 50.6 58.1718 50.52C58.2785 50.4267 58.4385 50.38 58.6518 50.38C58.8918 50.38 59.1385 50.4267 59.3918 50.52C59.6585 50.6133 59.8851 50.74 60.0718 50.9C60.2718 51.06 60.3718 51.2467 60.3718 51.46C60.3718 51.4867 60.3651 51.5267 60.3518 51.58C60.3518 51.62 60.3385 51.6667 60.3118 51.72L56.1718 58.88C56.1318 58.9467 56.1118 59.0333 56.1118 59.14V64.16C56.1118 64.44 55.9718 64.6533 55.6918 64.8C55.4251 64.9333 55.1318 65 54.8118 65ZM63.4659 65.18C62.6925 65.18 61.9792 64.9933 61.3259 64.62C60.6725 64.2333 60.1459 63.7267 59.7459 63.1C59.3459 62.4733 59.1459 61.8 59.1459 61.08V59.44C59.1459 58.72 59.3392 58.0533 59.7259 57.44C60.1125 56.8133 60.6325 56.3133 61.2859 55.94C61.9525 55.5667 62.6792 55.38 63.4659 55.38C64.2525 55.38 64.9725 55.5667 65.6259 55.94C66.2925 56.3 66.8192 56.7867 67.2059 57.4C67.6059 58.0133 67.8059 58.6933 67.8059 59.44V61.08C67.8059 61.7867 67.6059 62.4533 67.2059 63.08C66.8059 63.7067 66.2725 64.2133 65.6059 64.6C64.9525 64.9867 64.2392 65.18 63.4659 65.18ZM63.4659 62.92C63.7859 62.92 64.0792 62.8333 64.3459 62.66C64.6125 62.4867 64.8259 62.26 64.9859 61.98C65.1459 61.6867 65.2259 61.3867 65.2259 61.08V59.44C65.2259 59.1333 65.1459 58.8467 64.9859 58.58C64.8259 58.3133 64.6125 58.0933 64.3459 57.92C64.0925 57.7333 63.7992 57.64 63.4659 57.64C63.1459 57.64 62.8525 57.7267 62.5859 57.9C62.3192 58.0733 62.1059 58.3 61.9459 58.58C61.7992 58.8467 61.7259 59.1333 61.7259 59.44V61.08C61.7259 61.3867 61.7992 61.6867 61.9459 61.98C62.1059 62.26 62.3192 62.4867 62.5859 62.66C62.8525 62.8333 63.1459 62.92 63.4659 62.92ZM73.7073 65.18C72.9073 65.18 72.1739 64.9933 71.5073 64.62C70.8539 64.2333 70.3273 63.7333 69.9273 63.12C69.5406 62.4933 69.3473 61.8267 69.3473 61.12V56.32C69.3473 56.12 69.4739 55.9333 69.7273 55.76C69.9939 55.5867 70.3006 55.5 70.6473 55.5C70.9939 55.5 71.2939 55.5867 71.5473 55.76C71.8006 55.9333 71.9273 56.12 71.9273 56.32V61.12C71.9273 61.4267 72.0073 61.7133 72.1673 61.98C72.3273 62.2467 72.5406 62.4733 72.8073 62.66C73.0739 62.8333 73.3673 62.92 73.6873 62.92C74.0206 62.92 74.3139 62.8333 74.5673 62.66C74.8339 62.4867 75.0473 62.26 75.2073 61.98C75.3673 61.7 75.4473 61.4133 75.4473 61.12V56.3C75.4473 56.0867 75.5739 55.9 75.8273 55.74C76.0939 55.58 76.3939 55.5 76.7273 55.5C77.1139 55.5 77.4273 55.58 77.6673 55.74C77.9073 55.9 78.0273 56.0867 78.0273 56.3V61.12C78.0273 61.84 77.8273 62.5133 77.4273 63.14C77.0406 63.7533 76.5139 64.2467 75.8473 64.62C75.1939 64.9933 74.4806 65.18 73.7073 65.18ZM81.1955 65C80.8355 65 80.5355 64.9133 80.2955 64.74C80.0555 64.5667 79.9355 64.3733 79.9355 64.16V56.3C79.9355 56.06 80.0555 55.8667 80.2955 55.72C80.5355 55.5733 80.8355 55.5 81.1955 55.5C81.5289 55.5 81.8022 55.5733 82.0155 55.72C82.2422 55.8667 82.3555 56.06 82.3555 56.3V57.12C82.5022 56.8267 82.6955 56.5533 82.9355 56.3C83.1889 56.0333 83.4755 55.8133 83.7955 55.64C84.1155 55.4667 84.4555 55.38 84.8155 55.38H85.4355C85.6889 55.38 85.9089 55.4933 86.0955 55.72C86.2822 55.9333 86.3755 56.1933 86.3755 56.5C86.3755 56.82 86.2822 57.0933 86.0955 57.32C85.9089 57.5333 85.6889 57.64 85.4355 57.64H84.8155C84.4422 57.64 84.0755 57.7667 83.7155 58.02C83.3689 58.26 83.0822 58.6 82.8555 59.04C82.6289 59.4667 82.5155 59.9867 82.5155 60.6V64.16C82.5155 64.3733 82.3889 64.5667 82.1355 64.74C81.8822 64.9133 81.5689 65 81.1955 65ZM99.6595 65.1C99.4861 65.1 99.3128 65.0467 99.1395 64.94C98.9795 64.8333 98.8528 64.68 98.7595 64.48L95.9195 58.96H94.2395V64.16C94.2395 64.44 94.1061 64.6533 93.8395 64.8C93.5728 64.9333 93.2728 65 92.9395 65C92.6195 65 92.3195 64.9333 92.0395 64.8C91.7728 64.6533 91.6395 64.44 91.6395 64.16V51.2C91.6395 50.9733 91.7128 50.78 91.8595 50.62C92.0195 50.46 92.2261 50.38 92.4795 50.38H96.4395C97.3195 50.38 98.1128 50.5067 98.8195 50.76C99.5395 51.0133 100.113 51.4467 100.539 52.06C100.966 52.66 101.179 53.4933 101.179 54.56C101.179 55.3333 101.066 55.9933 100.839 56.54C100.613 57.0733 100.299 57.5067 99.8995 57.84C99.5128 58.16 99.0661 58.4 98.5595 58.56L101.199 63.42C101.226 63.4733 101.246 63.5333 101.259 63.6C101.273 63.6533 101.279 63.7 101.279 63.74C101.279 63.9533 101.199 64.1667 101.039 64.38C100.879 64.5933 100.673 64.7667 100.419 64.9C100.179 65.0333 99.9261 65.1 99.6595 65.1ZM94.2395 56.92H96.4395C97.0928 56.92 97.6128 56.76 97.9995 56.44C98.3861 56.12 98.5795 55.5733 98.5795 54.8C98.5795 54 98.3861 53.4467 97.9995 53.14C97.6128 52.82 97.0928 52.66 96.4395 52.66H94.2395V56.92ZM107.091 65.18C106.145 65.18 105.305 65.0133 104.571 64.68C103.851 64.3333 103.285 63.8533 102.871 63.24C102.458 62.6133 102.251 61.8933 102.251 61.08V59.38C102.251 58.66 102.445 58 102.831 57.4C103.231 56.7867 103.758 56.3 104.411 55.94C105.078 55.5667 105.818 55.38 106.631 55.38C107.378 55.38 108.058 55.54 108.671 55.86C109.298 56.18 109.805 56.62 110.191 57.18C110.578 57.74 110.771 58.3933 110.771 59.14C110.771 59.7133 110.678 60.1267 110.491 60.38C110.305 60.62 110.065 60.7733 109.771 60.84C109.491 60.8933 109.198 60.92 108.891 60.92H104.831V61.22C104.831 61.7933 105.045 62.26 105.471 62.62C105.911 62.9667 106.478 63.14 107.171 63.14C107.611 63.14 107.978 63.0733 108.271 62.94C108.565 62.8067 108.818 62.68 109.031 62.56C109.245 62.44 109.445 62.38 109.631 62.38C109.831 62.38 110.005 62.4467 110.151 62.58C110.298 62.7133 110.411 62.8733 110.491 63.06C110.571 63.2333 110.611 63.3867 110.611 63.52C110.611 63.7467 110.465 63.9933 110.171 64.26C109.891 64.5133 109.485 64.7333 108.951 64.92C108.431 65.0933 107.811 65.18 107.091 65.18ZM104.831 59.4H107.751C107.978 59.4 108.131 59.3667 108.211 59.3C108.305 59.22 108.351 59.0733 108.351 58.86C108.351 58.5533 108.265 58.28 108.091 58.04C107.931 57.8 107.718 57.6133 107.451 57.48C107.198 57.3467 106.911 57.28 106.591 57.28C106.285 57.28 105.998 57.3467 105.731 57.48C105.465 57.6 105.245 57.78 105.071 58.02C104.911 58.2467 104.831 58.52 104.831 58.84V59.4ZM116.338 65.18C115.325 65.18 114.498 65 113.858 64.64C113.218 64.28 112.745 63.7933 112.438 63.18C112.132 62.5533 111.978 61.8533 111.978 61.08V59.48C111.978 58.7067 112.125 58.0133 112.418 57.4C112.725 56.7733 113.198 56.28 113.838 55.92C114.492 55.56 115.312 55.38 116.298 55.38C116.925 55.38 117.478 55.4533 117.958 55.6C118.438 55.7467 118.818 55.94 119.098 56.18C119.378 56.42 119.518 56.6733 119.518 56.94C119.518 57.1 119.472 57.28 119.378 57.48C119.298 57.6667 119.178 57.8333 119.018 57.98C118.872 58.1267 118.698 58.2 118.498 58.2C118.352 58.2 118.198 58.1533 118.038 58.06C117.892 57.9667 117.698 57.8733 117.458 57.78C117.218 57.6867 116.898 57.64 116.498 57.64C115.818 57.64 115.325 57.8067 115.018 58.14C114.712 58.46 114.558 58.9067 114.558 59.48V61.08C114.558 61.6533 114.712 62.1067 115.018 62.44C115.325 62.76 115.825 62.92 116.518 62.92C116.932 62.92 117.252 62.8667 117.478 62.76C117.705 62.6533 117.892 62.5533 118.038 62.46C118.198 62.3667 118.358 62.32 118.518 62.32C118.758 62.32 118.958 62.3867 119.118 62.52C119.292 62.6533 119.418 62.82 119.498 63.02C119.592 63.2067 119.638 63.38 119.638 63.54C119.638 63.8067 119.492 64.0667 119.198 64.32C118.918 64.5733 118.525 64.78 118.018 64.94C117.525 65.1 116.965 65.18 116.338 65.18ZM121.251 69.42C120.917 69.42 120.637 69.3533 120.411 69.22C120.184 69.1 120.071 68.8 120.071 68.32C120.071 68.0267 120.117 67.7733 120.211 67.56C120.317 67.3467 120.491 67.24 120.731 67.24C120.957 67.24 121.217 67.2 121.511 67.12C121.817 67.04 122.124 66.8867 122.431 66.66C122.737 66.4467 122.997 66.1467 123.211 65.76C123.424 65.3867 123.551 64.9 123.591 64.3L120.151 56.94C120.097 56.82 120.071 56.7067 120.071 56.6C120.071 56.3733 120.164 56.1667 120.351 55.98C120.551 55.7933 120.784 55.6467 121.051 55.54C121.317 55.42 121.564 55.36 121.791 55.36C121.951 55.36 122.097 55.3933 122.231 55.46C122.377 55.5267 122.477 55.64 122.531 55.8L124.931 61.78L126.851 55.8C126.917 55.64 127.017 55.5267 127.151 55.46C127.284 55.3933 127.417 55.36 127.551 55.36C127.751 55.36 127.991 55.42 128.271 55.54C128.551 55.6467 128.791 55.8 128.991 56C129.204 56.1867 129.311 56.4 129.311 56.64C129.311 56.76 129.291 56.86 129.251 56.94L126.331 64.4C126.091 65 125.857 65.5933 125.631 66.18C125.404 66.78 125.117 67.32 124.771 67.8C124.437 68.2933 123.991 68.6867 123.431 68.98C122.871 69.2733 122.144 69.42 121.251 69.42ZM134.463 65.18C133.45 65.18 132.623 65 131.983 64.64C131.343 64.28 130.87 63.7933 130.563 63.18C130.257 62.5533 130.103 61.8533 130.103 61.08V59.48C130.103 58.7067 130.25 58.0133 130.543 57.4C130.85 56.7733 131.323 56.28 131.963 55.92C132.617 55.56 133.437 55.38 134.423 55.38C135.05 55.38 135.603 55.4533 136.083 55.6C136.563 55.7467 136.943 55.94 137.223 56.18C137.503 56.42 137.643 56.6733 137.643 56.94C137.643 57.1 137.597 57.28 137.503 57.48C137.423 57.6667 137.303 57.8333 137.143 57.98C136.997 58.1267 136.823 58.2 136.623 58.2C136.477 58.2 136.323 58.1533 136.163 58.06C136.017 57.9667 135.823 57.8733 135.583 57.78C135.343 57.6867 135.023 57.64 134.623 57.64C133.943 57.64 133.45 57.8067 133.143 58.14C132.837 58.46 132.683 58.9067 132.683 59.48V61.08C132.683 61.6533 132.837 62.1067 133.143 62.44C133.45 62.76 133.95 62.92 134.643 62.92C135.057 62.92 135.377 62.8667 135.603 62.76C135.83 62.6533 136.017 62.5533 136.163 62.46C136.323 62.3667 136.483 62.32 136.643 62.32C136.883 62.32 137.083 62.3867 137.243 62.52C137.417 62.6533 137.543 62.82 137.623 63.02C137.717 63.2067 137.763 63.38 137.763 63.54C137.763 63.8067 137.617 64.0667 137.323 64.32C137.043 64.5733 136.65 64.78 136.143 64.94C135.65 65.1 135.09 65.18 134.463 65.18ZM140.556 65C140.182 65 139.876 64.9133 139.636 64.74C139.396 64.5667 139.276 64.3733 139.276 64.16V50.76C139.276 50.52 139.396 50.3267 139.636 50.18C139.876 50.0333 140.182 49.96 140.556 49.96C140.916 49.96 141.222 50.0333 141.476 50.18C141.729 50.3267 141.856 50.52 141.856 50.76V64.16C141.856 64.3733 141.729 64.5667 141.476 64.74C141.222 64.9133 140.916 65 140.556 65ZM146.077 65.18C145.37 65.18 144.757 64.9667 144.237 64.54C143.73 64.1 143.477 63.4267 143.477 62.52C143.477 61.76 143.67 61.1667 144.057 60.74C144.457 60.3133 145.004 60.0133 145.697 59.84C146.404 59.6667 147.217 59.58 148.137 59.58H148.957V59.32C148.957 59.0267 148.897 58.74 148.777 58.46C148.67 58.18 148.49 57.9467 148.237 57.76C147.997 57.5733 147.65 57.48 147.197 57.48C146.69 57.48 146.297 57.5333 146.017 57.64C145.75 57.7333 145.544 57.8333 145.397 57.94C145.25 58.0467 145.09 58.1 144.917 58.1C144.637 58.1 144.417 57.96 144.257 57.68C144.11 57.4 144.037 57.1133 144.037 56.82C144.037 56.54 144.204 56.2933 144.537 56.08C144.884 55.8533 145.304 55.68 145.797 55.56C146.29 55.44 146.77 55.38 147.237 55.38C148.277 55.38 149.11 55.5667 149.737 55.94C150.364 56.3133 150.817 56.7933 151.097 57.38C151.39 57.9667 151.537 58.6 151.537 59.28V64.16C151.537 64.4 151.417 64.6 151.177 64.76C150.937 64.92 150.637 65 150.277 65C149.944 65 149.664 64.92 149.437 64.76C149.224 64.6 149.117 64.4 149.117 64.16V63.6C148.757 64.0133 148.33 64.38 147.837 64.7C147.357 65.02 146.77 65.18 146.077 65.18ZM147.117 63.26C147.397 63.26 147.677 63.1667 147.957 62.98C148.237 62.7933 148.47 62.5533 148.657 62.26C148.857 61.9667 148.957 61.66 148.957 61.34V60.92H148.657C148.217 60.92 147.797 60.9467 147.397 61C146.997 61.0533 146.67 61.1733 146.417 61.36C146.177 61.5333 146.057 61.8067 146.057 62.18C146.057 62.5533 146.157 62.8267 146.357 63C146.57 63.1733 146.824 63.26 147.117 63.26ZM158.671 65.18C158.045 65.18 157.478 65.02 156.971 64.7C156.465 64.38 156.105 64.0133 155.891 63.6V64.16C155.891 64.3733 155.778 64.5667 155.551 64.74C155.338 64.9133 155.065 65 154.731 65C154.371 65 154.071 64.9133 153.831 64.74C153.591 64.5667 153.471 64.3733 153.471 64.16V50.76C153.471 50.52 153.591 50.3267 153.831 50.18C154.071 50.0333 154.371 49.96 154.731 49.96C155.105 49.96 155.418 50.0333 155.671 50.18C155.925 50.3267 156.051 50.52 156.051 50.76V56.9C156.265 56.5133 156.591 56.1667 157.031 55.86C157.471 55.54 158.005 55.38 158.631 55.38C159.285 55.38 159.878 55.5667 160.411 55.94C160.945 56.3 161.371 56.7867 161.691 57.4C162.011 58.0133 162.171 58.6933 162.171 59.44V61.08C162.171 61.7867 162.011 62.4533 161.691 63.08C161.371 63.7067 160.945 64.2133 160.411 64.6C159.891 64.9867 159.311 65.18 158.671 65.18ZM157.851 62.92C158.171 62.92 158.465 62.8333 158.731 62.66C158.998 62.4733 159.205 62.24 159.351 61.96C159.511 61.68 159.591 61.3867 159.591 61.08V59.44C159.591 59.1333 159.511 58.8467 159.351 58.58C159.205 58.3133 158.998 58.0933 158.731 57.92C158.465 57.7333 158.165 57.64 157.831 57.64C157.551 57.64 157.271 57.7133 156.991 57.86C156.725 58.0067 156.498 58.2133 156.311 58.48C156.138 58.7467 156.051 59.0667 156.051 59.44V61.44C156.051 61.5733 156.131 61.76 156.291 62C156.451 62.2267 156.665 62.44 156.931 62.64C157.211 62.8267 157.518 62.92 157.851 62.92ZM165.282 65C164.909 65 164.602 64.9133 164.362 64.74C164.122 64.5667 164.002 64.3733 164.002 64.16V50.76C164.002 50.52 164.122 50.3267 164.362 50.18C164.602 50.0333 164.909 49.96 165.282 49.96C165.642 49.96 165.949 50.0333 166.202 50.18C166.456 50.3267 166.582 50.52 166.582 50.76V64.16C166.582 64.3733 166.456 64.5667 166.202 64.74C165.949 64.9133 165.642 65 165.282 65ZM173.244 65.18C172.297 65.18 171.457 65.0133 170.724 64.68C170.004 64.3333 169.437 63.8533 169.024 63.24C168.61 62.6133 168.404 61.8933 168.404 61.08V59.38C168.404 58.66 168.597 58 168.984 57.4C169.384 56.7867 169.91 56.3 170.564 55.94C171.23 55.5667 171.97 55.38 172.784 55.38C173.53 55.38 174.21 55.54 174.824 55.86C175.45 56.18 175.957 56.62 176.344 57.18C176.73 57.74 176.924 58.3933 176.924 59.14C176.924 59.7133 176.83 60.1267 176.644 60.38C176.457 60.62 176.217 60.7733 175.924 60.84C175.644 60.8933 175.35 60.92 175.044 60.92H170.984V61.22C170.984 61.7933 171.197 62.26 171.624 62.62C172.064 62.9667 172.63 63.14 173.324 63.14C173.764 63.14 174.13 63.0733 174.424 62.94C174.717 62.8067 174.97 62.68 175.184 62.56C175.397 62.44 175.597 62.38 175.784 62.38C175.984 62.38 176.157 62.4467 176.304 62.58C176.45 62.7133 176.564 62.8733 176.644 63.06C176.724 63.2333 176.764 63.3867 176.764 63.52C176.764 63.7467 176.617 63.9933 176.324 64.26C176.044 64.5133 175.637 64.7333 175.104 64.92C174.584 65.0933 173.964 65.18 173.244 65.18ZM170.984 59.4H173.904C174.13 59.4 174.284 59.3667 174.364 59.3C174.457 59.22 174.504 59.0733 174.504 58.86C174.504 58.5533 174.417 58.28 174.244 58.04C174.084 57.8 173.87 57.6133 173.604 57.48C173.35 57.3467 173.064 57.28 172.744 57.28C172.437 57.28 172.15 57.3467 171.884 57.48C171.617 57.6 171.397 57.78 171.224 58.02C171.064 58.2467 170.984 58.52 170.984 58.84V59.4ZM181.571 65.18C180.904 65.18 180.291 65.1 179.731 64.94C179.184 64.7667 178.751 64.5467 178.431 64.28C178.124 64.0133 177.971 63.74 177.971 63.46C177.971 63.3133 178.004 63.1533 178.071 62.98C178.151 62.8067 178.251 62.6533 178.371 62.52C178.504 62.3867 178.657 62.32 178.831 62.32C179.017 62.32 179.211 62.4 179.411 62.56C179.624 62.7067 179.884 62.8533 180.191 63C180.511 63.1467 180.951 63.22 181.511 63.22C182.111 63.22 182.504 63.1267 182.691 62.94C182.891 62.7533 182.991 62.56 182.991 62.36C182.991 62.0667 182.871 61.84 182.631 61.68C182.404 61.52 182.111 61.3933 181.751 61.3C181.391 61.1933 181.004 61.08 180.591 60.96C180.191 60.84 179.811 60.6867 179.451 60.5C179.091 60.3 178.797 60.0333 178.571 59.7C178.344 59.3533 178.231 58.9067 178.231 58.36C178.231 57.88 178.344 57.4133 178.571 56.96C178.797 56.5067 179.171 56.1333 179.691 55.84C180.211 55.5333 180.917 55.38 181.811 55.38C182.357 55.38 182.871 55.44 183.351 55.56C183.844 55.6667 184.244 55.82 184.551 56.02C184.857 56.22 185.011 56.44 185.011 56.68C185.011 56.8 184.971 56.96 184.891 57.16C184.811 57.3467 184.697 57.52 184.551 57.68C184.417 57.84 184.251 57.92 184.051 57.92C183.904 57.92 183.724 57.8733 183.511 57.78C183.311 57.6733 183.077 57.5733 182.811 57.48C182.544 57.3867 182.224 57.34 181.851 57.34C181.517 57.34 181.251 57.3867 181.051 57.48C180.851 57.5733 180.704 57.6867 180.611 57.82C180.517 57.9533 180.471 58.0933 180.471 58.24C180.471 58.48 180.584 58.6667 180.811 58.8C181.037 58.9333 181.331 59.0467 181.691 59.14C182.064 59.2333 182.451 59.34 182.851 59.46C183.264 59.5667 183.651 59.7267 184.011 59.94C184.384 60.1533 184.684 60.4467 184.911 60.82C185.137 61.18 185.251 61.6533 185.251 62.24C185.251 63.1333 184.931 63.8467 184.291 64.38C183.664 64.9133 182.757 65.18 181.571 65.18ZM188.031 60.96C187.764 60.96 187.531 60.9 187.331 60.78C187.131 60.66 187.031 60.4667 187.031 60.2C187.031 59.32 187.011 58.3667 186.971 57.34C186.931 56.3133 186.884 55.2867 186.831 54.26C186.791 53.2333 186.771 52.28 186.771 51.4C186.771 51.0533 186.891 50.7867 187.131 50.6C187.371 50.4 187.671 50.3 188.031 50.3C188.364 50.3 188.651 50.4 188.891 50.6C189.144 50.7867 189.271 51.0533 189.271 51.4C189.271 52.28 189.251 53.2333 189.211 54.26C189.171 55.2867 189.124 56.3133 189.071 57.34C189.031 58.3667 189.011 59.32 189.011 60.2C189.011 60.4667 188.897 60.66 188.671 60.78C188.444 60.9 188.231 60.96 188.031 60.96ZM188.051 65.12C187.664 65.12 187.337 64.9867 187.071 64.72C186.817 64.44 186.691 64.12 186.691 63.76C186.691 63.3867 186.817 63.0667 187.071 62.8C187.337 62.5333 187.664 62.4 188.051 62.4C188.411 62.4 188.724 62.5333 188.991 62.8C189.257 63.0667 189.391 63.3867 189.391 63.76C189.391 64.12 189.257 64.44 188.991 64.72C188.724 64.9867 188.411 65.12 188.051 65.12Z\" fill=\"#FF0082\"/> <g id=\"gameStartBtn\" filter=\"url(#filter0_d_863_9058)\"> <path d=\"M58 302H121C126.523 302 131 306.477 131 312V331H68C62.4772 331 58 326.523 58 321V302Z\" fill=\"#FDFAF1\"/> <path d=\"M58.5 302.5H121C126.247 302.5 130.5 306.753 130.5 312V330.5H68C62.7533 330.5 58.5 326.247 58.5 321V302.5Z\" stroke=\"#F7CFE5\"/> <path d=\"M70.5788 322.126C69.9721 322.126 69.4215 322.037 68.9268 321.86C68.4415 321.683 68.0541 321.463 67.7648 321.202C67.4848 320.931 67.3448 320.661 67.3448 320.39C67.3448 320.259 67.3775 320.119 67.4428 319.97C67.5175 319.811 67.6155 319.681 67.7368 319.578C67.8581 319.466 67.9935 319.41 68.1428 319.41C68.2921 319.41 68.4321 319.466 68.5628 319.578C68.6935 319.681 68.8428 319.807 69.0108 319.956C69.1788 320.096 69.3841 320.222 69.6268 320.334C69.8695 320.437 70.1681 320.488 70.5228 320.488C70.8028 320.488 71.0595 320.446 71.2928 320.362C71.5355 320.269 71.7268 320.133 71.8668 319.956C72.0161 319.779 72.0908 319.55 72.0908 319.27C72.0908 318.971 72.0115 318.719 71.8528 318.514C71.6941 318.309 71.4795 318.131 71.2088 317.982C70.9381 317.833 70.6441 317.688 70.3268 317.548C70.0095 317.408 69.6875 317.259 69.3608 317.1C69.0435 316.941 68.7495 316.75 68.4788 316.526C68.2175 316.302 68.0028 316.027 67.8348 315.7C67.6761 315.373 67.5968 314.972 67.5968 314.496C67.5968 313.973 67.6948 313.535 67.8908 313.18C68.0961 312.825 68.3621 312.541 68.6888 312.326C69.0248 312.102 69.3935 311.943 69.7948 311.85C70.1961 311.747 70.5975 311.696 70.9988 311.696C71.2135 311.696 71.4655 311.715 71.7548 311.752C72.0535 311.78 72.3475 311.836 72.6368 311.92C72.9355 312.004 73.1781 312.121 73.3648 312.27C73.5608 312.41 73.6588 312.597 73.6588 312.83C73.6588 312.933 73.6308 313.059 73.5748 313.208C73.5281 313.357 73.4488 313.493 73.3368 313.614C73.2341 313.735 73.0988 313.796 72.9308 313.796C72.7815 313.796 72.6321 313.754 72.4828 313.67C72.3428 313.577 72.1561 313.488 71.9228 313.404C71.6988 313.311 71.3908 313.264 70.9988 313.264C70.6721 313.264 70.3875 313.306 70.1448 313.39C69.9021 313.474 69.7201 313.595 69.5988 313.754C69.4775 313.903 69.4168 314.095 69.4168 314.328C69.4168 314.571 69.4961 314.776 69.6548 314.944C69.8228 315.112 70.0375 315.261 70.2988 315.392C70.5695 315.523 70.8635 315.653 71.1808 315.784C71.4981 315.915 71.8155 316.069 72.1328 316.246C72.4595 316.414 72.7581 316.619 73.0288 316.862C73.2995 317.105 73.5141 317.408 73.6728 317.772C73.8315 318.127 73.9108 318.565 73.9108 319.088C73.9108 319.751 73.7661 320.311 73.4768 320.768C73.1875 321.216 72.7908 321.557 72.2868 321.79C71.7921 322.014 71.2228 322.126 70.5788 322.126ZM77.9776 322C77.7442 322 77.5342 321.953 77.3476 321.86C77.1609 321.757 77.0676 321.608 77.0676 321.412V313.404H75.0096C74.8322 313.404 74.6922 313.32 74.5896 313.152C74.4869 312.984 74.4356 312.793 74.4356 312.578C74.4356 312.382 74.4822 312.2 74.5756 312.032C74.6689 311.855 74.8136 311.766 75.0096 311.766H80.9316C81.1369 311.766 81.2816 311.855 81.3656 312.032C81.4589 312.2 81.5056 312.382 81.5056 312.578C81.5056 312.793 81.4542 312.984 81.3516 313.152C81.2582 313.32 81.1182 313.404 80.9316 313.404H78.8876V321.412C78.8876 321.608 78.7896 321.757 78.5936 321.86C78.4069 321.953 78.2016 322 77.9776 322ZM82.064 322C81.896 322 81.7234 321.967 81.546 321.902C81.3687 321.837 81.2194 321.748 81.098 321.636C80.9767 321.524 80.916 321.393 80.916 321.244C80.916 321.216 80.9207 321.169 80.93 321.104L83.632 312.298C83.6974 312.093 83.842 311.939 84.066 311.836C84.2994 311.733 84.5467 311.682 84.808 311.682C85.0787 311.682 85.326 311.733 85.55 311.836C85.774 311.939 85.9187 312.093 85.984 312.298L88.686 321.104C88.7047 321.169 88.714 321.216 88.714 321.244C88.714 321.384 88.6487 321.515 88.518 321.636C88.3967 321.748 88.2474 321.837 88.07 321.902C87.8927 321.967 87.72 322 87.552 322C87.4027 322 87.272 321.977 87.16 321.93C87.0574 321.874 86.9874 321.776 86.95 321.636L86.418 319.774H83.198L82.68 321.636C82.6427 321.776 82.568 321.874 82.456 321.93C82.344 321.977 82.2134 322 82.064 322ZM83.59 318.346H86.026L84.808 314.048L83.59 318.346ZM95.2831 322.07C95.1618 322.07 95.0404 322.033 94.9191 321.958C94.8071 321.883 94.7184 321.776 94.6531 321.636L92.6651 317.772H91.4891V321.412C91.4891 321.608 91.3958 321.757 91.2091 321.86C91.0224 321.953 90.8124 322 90.5791 322C90.3551 322 90.1451 321.953 89.9491 321.86C89.7624 321.757 89.6691 321.608 89.6691 321.412V312.34C89.6691 312.181 89.7204 312.046 89.8231 311.934C89.9351 311.822 90.0798 311.766 90.2571 311.766H93.0291C93.6451 311.766 94.2004 311.855 94.6951 312.032C95.1991 312.209 95.6004 312.513 95.8991 312.942C96.1978 313.362 96.3471 313.945 96.3471 314.692C96.3471 315.233 96.2678 315.695 96.1091 316.078C95.9504 316.451 95.7311 316.755 95.4511 316.988C95.1804 317.212 94.8678 317.38 94.5131 317.492L96.3611 320.894C96.3798 320.931 96.3938 320.973 96.4031 321.02C96.4124 321.057 96.4171 321.09 96.4171 321.118C96.4171 321.267 96.3611 321.417 96.2491 321.566C96.1371 321.715 95.9924 321.837 95.8151 321.93C95.6471 322.023 95.4698 322.07 95.2831 322.07ZM91.4891 316.344H93.0291C93.4864 316.344 93.8504 316.232 94.1211 316.008C94.3918 315.784 94.5271 315.401 94.5271 314.86C94.5271 314.3 94.3918 313.913 94.1211 313.698C93.8504 313.474 93.4864 313.362 93.0291 313.362H91.4891V316.344ZM100.331 322C100.098 322 99.8878 321.953 99.7011 321.86C99.5144 321.757 99.4211 321.608 99.4211 321.412V313.404H97.3631C97.1858 313.404 97.0458 313.32 96.9431 313.152C96.8404 312.984 96.7891 312.793 96.7891 312.578C96.7891 312.382 96.8358 312.2 96.9291 312.032C97.0224 311.855 97.1671 311.766 97.3631 311.766H103.285C103.49 311.766 103.635 311.855 103.719 312.032C103.812 312.2 103.859 312.382 103.859 312.578C103.859 312.793 103.808 312.984 103.705 313.152C103.612 313.32 103.472 313.404 103.285 313.404H101.241V321.412C101.241 321.608 101.143 321.757 100.947 321.86C100.76 321.953 100.555 322 100.331 322Z\" fill=\"#FF0082\"/> <path d=\"M110 316C110 314.143 110.737 312.363 112.05 311.05C113.363 309.737 115.143 309 117 309C117.919 309 118.83 309.181 119.679 309.533C120.528 309.885 121.3 310.4 121.95 311.05C122.6 311.7 123.115 312.472 123.467 313.321C123.819 314.17 124 315.081 124 316C124 317.857 123.263 319.637 121.95 320.95C120.637 322.263 118.857 323 117 323C116.081 323 115.17 322.819 114.321 322.467C113.472 322.115 112.7 321.6 112.05 320.95C110.737 319.637 110 317.857 110 316ZM115.6 319.5L119.1 316L115.6 312.5V319.5Z\" fill=\"#FF0082\"/> </g> <rect x=\"15\" y=\"79\" width=\"191\" height=\"213\" fill=\"url(#pattern0_863_9058)\"/> <defs> <filter id=\"filter0_d_863_9058\" x=\"58\" y=\"302\" width=\"75\" height=\"31\" filterUnits=\"userSpaceOnUse\" color-interpolation-filters=\"sRGB\"> <feFlood flood-opacity=\"0\" result=\"BackgroundImageFix\"/> <feColorMatrix in=\"SourceAlpha\" type=\"matrix\" values=\"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0\" result=\"hardAlpha\"/> <feOffset dx=\"2\" dy=\"2\"/> <feComposite in2=\"hardAlpha\" operator=\"out\"/> <feColorMatrix type=\"matrix\" values=\"0 0 0 0 1 0 0 0 0 0 0 0 0 0 0.509804 0 0 0 1 0\"/> <feBlend mode=\"normal\" in2=\"BackgroundImageFix\" result=\"effect1_dropShadow_863_9058\"/> <feBlend mode=\"normal\" in=\"SourceGraphic\" in2=\"effect1_dropShadow_863_9058\" result=\"shape\"/> </filter> <pattern id=\"pattern0_863_9058\" patternContentUnits=\"objectBoundingBox\" width=\"1\" height=\"1\"> <use xlink:href=\"#image0_863_9058\" transform=\"scale(0.0052356 0.00469484)\"/> </pattern> <image id=\"image0_863_9058\" width=\"191\" height=\"213\" xlink:href=\"data:image/png;base64,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\"/> </defs> </svg>") // EJsS HtmlView.HtmlView Page: setting property 'Html' for element 'gameStart'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'gameStart'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"gameIntroduction", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'gameIntroduction'
      .setProperty("Html","<svg width=\"275\" height=\"275\" viewBox=\"0 0 275 275\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">     <g filter=\"url(#filter0_d_1192_50364)\">         <rect width=\"270\" height=\"270\" rx=\"50\" fill=\"#FDFAF1\" />         <path             d=\"M40.5332 76C40.2132 76 39.9132 75.9333 39.6332 75.8C39.3665 75.6533 39.2332 75.44 39.2332 75.16V62.2C39.2332 61.9067 39.3665 61.7 39.6332 61.58C39.9132 61.4467 40.2132 61.38 40.5332 61.38C40.8665 61.38 41.1665 61.4467 41.4332 61.58C41.6999 61.7 41.8332 61.9067 41.8332 62.2V67.4H46.3332V62.2C46.3332 61.9067 46.4665 61.7 46.7332 61.58C47.0132 61.4467 47.3132 61.38 47.6332 61.38C47.9665 61.38 48.2665 61.4467 48.5332 61.58C48.7999 61.7 48.9332 61.9067 48.9332 62.2V75.16C48.9332 75.44 48.7999 75.6533 48.5332 75.8C48.2665 75.9333 47.9665 76 47.6332 76C47.3132 76 47.0132 75.9333 46.7332 75.8C46.4665 75.6533 46.3332 75.44 46.3332 75.16V69.44H41.8332V75.16C41.8332 75.44 41.6999 75.6533 41.4332 75.8C41.1665 75.9333 40.8665 76 40.5332 76ZM55.1026 76.18C54.3292 76.18 53.6159 75.9933 52.9626 75.62C52.3092 75.2333 51.7826 74.7267 51.3826 74.1C50.9826 73.4733 50.7826 72.8 50.7826 72.08V70.44C50.7826 69.72 50.9759 69.0533 51.3626 68.44C51.7492 67.8133 52.2692 67.3133 52.9226 66.94C53.5892 66.5667 54.3159 66.38 55.1026 66.38C55.8892 66.38 56.6092 66.5667 57.2626 66.94C57.9292 67.3 58.4559 67.7867 58.8426 68.4C59.2426 69.0133 59.4426 69.6933 59.4426 70.44V72.08C59.4426 72.7867 59.2426 73.4533 58.8426 74.08C58.4426 74.7067 57.9092 75.2133 57.2426 75.6C56.5892 75.9867 55.8759 76.18 55.1026 76.18ZM55.1026 73.92C55.4226 73.92 55.7159 73.8333 55.9826 73.66C56.2492 73.4867 56.4626 73.26 56.6226 72.98C56.7826 72.6867 56.8626 72.3867 56.8626 72.08V70.44C56.8626 70.1333 56.7826 69.8467 56.6226 69.58C56.4626 69.3133 56.2492 69.0933 55.9826 68.92C55.7292 68.7333 55.4359 68.64 55.1026 68.64C54.7826 68.64 54.4892 68.7267 54.2226 68.9C53.9559 69.0733 53.7426 69.3 53.5826 69.58C53.4359 69.8467 53.3626 70.1333 53.3626 70.44V72.08C53.3626 72.3867 53.4359 72.6867 53.5826 72.98C53.7426 73.26 53.9559 73.4867 54.2226 73.66C54.4892 73.8333 54.7826 73.92 55.1026 73.92ZM64.384 76.22C64.1573 76.22 63.9507 76.1867 63.764 76.12C63.5773 76.0533 63.4507 75.9267 63.384 75.74L60.284 67.84C60.2573 67.7467 60.2373 67.6733 60.224 67.62C60.2107 67.5533 60.204 67.5 60.204 67.46C60.204 67.2467 60.2907 67.0667 60.464 66.92C60.6507 66.76 60.8773 66.6333 61.144 66.54C61.4107 66.4467 61.6507 66.4 61.864 66.4C62.0373 66.4 62.1907 66.4333 62.324 66.5C62.4707 66.5667 62.5707 66.6733 62.624 66.82L64.624 72.5L66.124 67.56C66.1907 67.3333 66.304 67.1933 66.464 67.14C66.624 67.0733 66.804 67.04 67.004 67.04C67.204 67.04 67.384 67.0733 67.544 67.14C67.704 67.1933 67.8173 67.3333 67.884 67.56L69.364 72.52L71.384 66.82C71.4773 66.54 71.7173 66.4 72.104 66.4C72.3173 66.4 72.5573 66.4467 72.824 66.54C73.0907 66.6333 73.3173 66.76 73.504 66.92C73.6907 67.08 73.784 67.2667 73.784 67.48C73.784 67.5333 73.7773 67.5933 73.764 67.66C73.7507 67.7267 73.7307 67.7867 73.704 67.84L70.604 75.76C70.5373 75.9333 70.4107 76.0533 70.224 76.12C70.0373 76.1867 69.8307 76.22 69.604 76.22C69.364 76.22 69.144 76.18 68.944 76.1C68.744 76.02 68.6107 75.9067 68.544 75.76L67.004 71.4L65.464 75.74C65.424 75.9 65.2973 76.02 65.084 76.1C64.8707 76.18 64.6373 76.22 64.384 76.22ZM80.2155 76C79.8422 76 79.5355 75.9133 79.2955 75.74C79.0555 75.5667 78.9355 75.3733 78.9355 75.16V67.3C78.9355 67.06 79.0555 66.8667 79.2955 66.72C79.5355 66.5733 79.8422 66.5 80.2155 66.5C80.5355 66.5 80.8022 66.5733 81.0155 66.72C81.2422 66.8667 81.3555 67.06 81.3555 67.3V67.9C81.5822 67.5133 81.9155 67.1667 82.3555 66.86C82.7955 66.54 83.3489 66.38 84.0155 66.38C84.5889 66.38 85.0955 66.5667 85.5355 66.94C85.9755 67.3133 86.3022 67.7933 86.5155 68.38C86.8622 67.7 87.3022 67.2 87.8355 66.88C88.3822 66.5467 88.9422 66.38 89.5155 66.38C90.1289 66.38 90.7022 66.54 91.2355 66.86C91.7822 67.1667 92.2222 67.6267 92.5555 68.24C92.9022 68.84 93.0755 69.5733 93.0755 70.44V75.16C93.0755 75.3733 92.9489 75.5667 92.6955 75.74C92.4422 75.9133 92.1355 76 91.7755 76C91.4289 76 91.1289 75.9133 90.8755 75.74C90.6222 75.5667 90.4955 75.3733 90.4955 75.16V70.44C90.4955 70.04 90.4155 69.7067 90.2555 69.44C90.1089 69.1733 89.9089 68.9733 89.6555 68.84C89.4022 68.6933 89.1422 68.62 88.8755 68.62C88.6222 68.62 88.3755 68.6933 88.1355 68.84C87.8955 68.9733 87.6955 69.1733 87.5355 69.44C87.3755 69.7067 87.2955 70.0333 87.2955 70.42V75.18C87.2955 75.4733 87.1555 75.6867 86.8755 75.82C86.6089 75.94 86.3155 76 85.9955 76C85.7022 76 85.4155 75.94 85.1355 75.82C84.8555 75.6867 84.7155 75.4733 84.7155 75.18V70.44C84.7155 70.0667 84.6355 69.7467 84.4755 69.48C84.3289 69.2133 84.1289 69.0067 83.8755 68.86C83.6355 68.7133 83.3755 68.64 83.0955 68.64C82.8289 68.64 82.5755 68.7067 82.3355 68.84C82.0955 68.9733 81.8955 69.1733 81.7355 69.44C81.5889 69.7067 81.5155 70.04 81.5155 70.44V75.16C81.5155 75.3733 81.3889 75.5667 81.1355 75.74C80.8822 75.9133 80.5755 76 80.2155 76ZM99.2502 76.18C98.4502 76.18 97.7169 75.9933 97.0502 75.62C96.3969 75.2333 95.8702 74.7333 95.4702 74.12C95.0836 73.4933 94.8902 72.8267 94.8902 72.12V67.32C94.8902 67.12 95.0169 66.9333 95.2702 66.76C95.5369 66.5867 95.8436 66.5 96.1902 66.5C96.5369 66.5 96.8369 66.5867 97.0902 66.76C97.3436 66.9333 97.4702 67.12 97.4702 67.32V72.12C97.4702 72.4267 97.5502 72.7133 97.7102 72.98C97.8702 73.2467 98.0836 73.4733 98.3502 73.66C98.6169 73.8333 98.9102 73.92 99.2302 73.92C99.5636 73.92 99.8569 73.8333 100.11 73.66C100.377 73.4867 100.59 73.26 100.75 72.98C100.91 72.7 100.99 72.4133 100.99 72.12V67.3C100.99 67.0867 101.117 66.9 101.37 66.74C101.637 66.58 101.937 66.5 102.27 66.5C102.657 66.5 102.97 66.58 103.21 66.74C103.45 66.9 103.57 67.0867 103.57 67.3V72.12C103.57 72.84 103.37 73.5133 102.97 74.14C102.584 74.7533 102.057 75.2467 101.39 75.62C100.737 75.9933 100.024 76.18 99.2502 76.18ZM109.499 76.18C108.485 76.18 107.659 76 107.019 75.64C106.379 75.28 105.905 74.7933 105.599 74.18C105.292 73.5533 105.139 72.8533 105.139 72.08V70.48C105.139 69.7067 105.285 69.0133 105.579 68.4C105.885 67.7733 106.359 67.28 106.999 66.92C107.652 66.56 108.472 66.38 109.459 66.38C110.085 66.38 110.639 66.4533 111.119 66.6C111.599 66.7467 111.979 66.94 112.259 67.18C112.539 67.42 112.679 67.6733 112.679 67.94C112.679 68.1 112.632 68.28 112.539 68.48C112.459 68.6667 112.339 68.8333 112.179 68.98C112.032 69.1267 111.859 69.2 111.659 69.2C111.512 69.2 111.359 69.1533 111.199 69.06C111.052 68.9667 110.859 68.8733 110.619 68.78C110.379 68.6867 110.059 68.64 109.659 68.64C108.979 68.64 108.485 68.8067 108.179 69.14C107.872 69.46 107.719 69.9067 107.719 70.48V72.08C107.719 72.6533 107.872 73.1067 108.179 73.44C108.485 73.76 108.985 73.92 109.679 73.92C110.092 73.92 110.412 73.8667 110.639 73.76C110.865 73.6533 111.052 73.5533 111.199 73.46C111.359 73.3667 111.519 73.32 111.679 73.32C111.919 73.32 112.119 73.3867 112.279 73.52C112.452 73.6533 112.579 73.82 112.659 74.02C112.752 74.2067 112.799 74.38 112.799 74.54C112.799 74.8067 112.652 75.0667 112.359 75.32C112.079 75.5733 111.685 75.78 111.179 75.94C110.685 76.1 110.125 76.18 109.499 76.18ZM115.431 76C115.058 76 114.751 75.9133 114.511 75.74C114.271 75.5667 114.151 75.3733 114.151 75.16V61.76C114.151 61.52 114.271 61.3267 114.511 61.18C114.751 61.0333 115.058 60.96 115.431 60.96C115.791 60.96 116.098 61.0333 116.351 61.18C116.604 61.3267 116.731 61.52 116.731 61.76V67.9C116.931 67.5133 117.244 67.1667 117.671 66.86C118.098 66.54 118.624 66.38 119.251 66.38C119.878 66.38 120.451 66.5667 120.971 66.94C121.491 67.3 121.904 67.7867 122.211 68.4C122.531 69.0133 122.691 69.6933 122.691 70.44V75.16C122.691 75.44 122.558 75.6533 122.291 75.8C122.024 75.9333 121.724 76 121.391 76C121.098 76 120.811 75.9333 120.531 75.8C120.251 75.6533 120.111 75.44 120.111 75.16V70.44C120.111 70.1333 120.031 69.8467 119.871 69.58C119.711 69.3133 119.498 69.0933 119.231 68.92C118.978 68.7333 118.691 68.64 118.371 68.64C118.104 68.64 117.844 68.7133 117.591 68.86C117.338 69.0067 117.131 69.2133 116.971 69.48C116.811 69.7467 116.731 70.0667 116.731 70.44V75.16C116.731 75.3733 116.604 75.5667 116.351 75.74C116.098 75.9133 115.791 76 115.431 76ZM131.783 76.18C131.156 76.18 130.576 75.9867 130.043 75.6C129.51 75.2133 129.083 74.7067 128.763 74.08C128.443 73.4533 128.283 72.7867 128.283 72.08V70.44C128.283 69.6933 128.443 69.0133 128.763 68.4C129.083 67.7867 129.51 67.3 130.043 66.94C130.576 66.5667 131.17 66.38 131.823 66.38C132.45 66.38 132.983 66.54 133.423 66.86C133.863 67.1667 134.19 67.5133 134.403 67.9V61.76C134.403 61.52 134.53 61.3267 134.783 61.18C135.036 61.0333 135.35 60.96 135.723 60.96C136.083 60.96 136.383 61.0333 136.623 61.18C136.863 61.3267 136.983 61.52 136.983 61.76V75.16C136.983 75.3733 136.863 75.5667 136.623 75.74C136.383 75.9133 136.083 76 135.723 76C135.403 76 135.13 75.9133 134.903 75.74C134.676 75.5667 134.563 75.3733 134.563 75.16V74.6C134.363 75.0133 134.003 75.38 133.483 75.7C132.976 76.02 132.41 76.18 131.783 76.18ZM132.603 73.92C132.95 73.92 133.256 73.8267 133.523 73.64C133.79 73.44 134.003 73.2267 134.163 73C134.323 72.76 134.403 72.5733 134.403 72.44V70.44C134.403 70.0667 134.31 69.7467 134.123 69.48C133.95 69.2133 133.723 69.0067 133.443 68.86C133.176 68.7133 132.903 68.64 132.623 68.64C132.303 68.64 132.003 68.7333 131.723 68.92C131.456 69.0933 131.243 69.3133 131.083 69.58C130.936 69.8467 130.863 70.1333 130.863 70.44V72.08C130.863 72.3867 130.936 72.68 131.083 72.96C131.243 73.24 131.456 73.4733 131.723 73.66C131.99 73.8333 132.283 73.92 132.603 73.92ZM142.954 76.18C142.181 76.18 141.467 75.9933 140.814 75.62C140.161 75.2333 139.634 74.7267 139.234 74.1C138.834 73.4733 138.634 72.8 138.634 72.08V70.44C138.634 69.72 138.827 69.0533 139.214 68.44C139.601 67.8133 140.121 67.3133 140.774 66.94C141.441 66.5667 142.167 66.38 142.954 66.38C143.741 66.38 144.461 66.5667 145.114 66.94C145.781 67.3 146.307 67.7867 146.694 68.4C147.094 69.0133 147.294 69.6933 147.294 70.44V72.08C147.294 72.7867 147.094 73.4533 146.694 74.08C146.294 74.7067 145.761 75.2133 145.094 75.6C144.441 75.9867 143.727 76.18 142.954 76.18ZM142.954 73.92C143.274 73.92 143.567 73.8333 143.834 73.66C144.101 73.4867 144.314 73.26 144.474 72.98C144.634 72.6867 144.714 72.3867 144.714 72.08V70.44C144.714 70.1333 144.634 69.8467 144.474 69.58C144.314 69.3133 144.101 69.0933 143.834 68.92C143.581 68.7333 143.287 68.64 142.954 68.64C142.634 68.64 142.341 68.7267 142.074 68.9C141.807 69.0733 141.594 69.3 141.434 69.58C141.287 69.8467 141.214 70.1333 141.214 70.44V72.08C141.214 72.3867 141.287 72.6867 141.434 72.98C141.594 73.26 141.807 73.4867 142.074 73.66C142.341 73.8333 142.634 73.92 142.954 73.92ZM153.219 80.42C152.886 80.42 152.606 80.3533 152.379 80.22C152.153 80.1 152.039 79.8 152.039 79.32C152.039 79.0267 152.086 78.7733 152.179 78.56C152.286 78.3467 152.459 78.24 152.699 78.24C152.926 78.24 153.186 78.2 153.479 78.12C153.786 78.04 154.093 77.8867 154.399 77.66C154.706 77.4467 154.966 77.1467 155.179 76.76C155.393 76.3867 155.519 75.9 155.559 75.3L152.119 67.94C152.066 67.82 152.039 67.7067 152.039 67.6C152.039 67.3733 152.133 67.1667 152.319 66.98C152.519 66.7933 152.753 66.6467 153.019 66.54C153.286 66.42 153.533 66.36 153.759 66.36C153.919 66.36 154.066 66.3933 154.199 66.46C154.346 66.5267 154.446 66.64 154.499 66.8L156.899 72.78L158.819 66.8C158.886 66.64 158.986 66.5267 159.119 66.46C159.253 66.3933 159.386 66.36 159.519 66.36C159.719 66.36 159.959 66.42 160.239 66.54C160.519 66.6467 160.759 66.8 160.959 67C161.173 67.1867 161.279 67.4 161.279 67.64C161.279 67.76 161.259 67.86 161.219 67.94L158.299 75.4C158.059 76 157.826 76.5933 157.599 77.18C157.373 77.78 157.086 78.32 156.739 78.8C156.406 79.2933 155.959 79.6867 155.399 79.98C154.839 80.2733 154.113 80.42 153.219 80.42ZM166.372 76.18C165.599 76.18 164.885 75.9933 164.232 75.62C163.579 75.2333 163.052 74.7267 162.652 74.1C162.252 73.4733 162.052 72.8 162.052 72.08V70.44C162.052 69.72 162.245 69.0533 162.632 68.44C163.019 67.8133 163.539 67.3133 164.192 66.94C164.859 66.5667 165.585 66.38 166.372 66.38C167.159 66.38 167.879 66.5667 168.532 66.94C169.199 67.3 169.725 67.7867 170.112 68.4C170.512 69.0133 170.712 69.6933 170.712 70.44V72.08C170.712 72.7867 170.512 73.4533 170.112 74.08C169.712 74.7067 169.179 75.2133 168.512 75.6C167.859 75.9867 167.145 76.18 166.372 76.18ZM166.372 73.92C166.692 73.92 166.985 73.8333 167.252 73.66C167.519 73.4867 167.732 73.26 167.892 72.98C168.052 72.6867 168.132 72.3867 168.132 72.08V70.44C168.132 70.1333 168.052 69.8467 167.892 69.58C167.732 69.3133 167.519 69.0933 167.252 68.92C166.999 68.7333 166.705 68.64 166.372 68.64C166.052 68.64 165.759 68.7267 165.492 68.9C165.225 69.0733 165.012 69.3 164.852 69.58C164.705 69.8467 164.632 70.1333 164.632 70.44V72.08C164.632 72.3867 164.705 72.6867 164.852 72.98C165.012 73.26 165.225 73.4867 165.492 73.66C165.759 73.8333 166.052 73.92 166.372 73.92ZM176.614 76.18C175.814 76.18 175.08 75.9933 174.414 75.62C173.76 75.2333 173.234 74.7333 172.834 74.12C172.447 73.4933 172.254 72.8267 172.254 72.12V67.32C172.254 67.12 172.38 66.9333 172.634 66.76C172.9 66.5867 173.207 66.5 173.554 66.5C173.9 66.5 174.2 66.5867 174.454 66.76C174.707 66.9333 174.834 67.12 174.834 67.32V72.12C174.834 72.4267 174.914 72.7133 175.074 72.98C175.234 73.2467 175.447 73.4733 175.714 73.66C175.98 73.8333 176.274 73.92 176.594 73.92C176.927 73.92 177.22 73.8333 177.474 73.66C177.74 73.4867 177.954 73.26 178.114 72.98C178.274 72.7 178.354 72.4133 178.354 72.12V67.3C178.354 67.0867 178.48 66.9 178.734 66.74C179 66.58 179.3 66.5 179.634 66.5C180.02 66.5 180.334 66.58 180.574 66.74C180.814 66.9 180.934 67.0867 180.934 67.3V72.12C180.934 72.84 180.734 73.5133 180.334 74.14C179.947 74.7533 179.42 75.2467 178.754 75.62C178.1 75.9933 177.387 76.18 176.614 76.18ZM188.126 76C187.766 76 187.466 75.9133 187.226 75.74C186.986 75.5667 186.866 75.3733 186.866 75.16V61.76C186.866 61.52 186.986 61.3267 187.226 61.18C187.466 61.0333 187.766 60.96 188.126 60.96C188.499 60.96 188.812 61.0333 189.066 61.18C189.319 61.3267 189.446 61.52 189.446 61.76V70.14L193.226 66.6C193.359 66.4667 193.526 66.4 193.726 66.4C193.926 66.4 194.119 66.4667 194.306 66.6C194.506 66.72 194.666 66.8733 194.786 67.06C194.919 67.2467 194.986 67.44 194.986 67.64C194.986 67.72 194.966 67.8067 194.926 67.9C194.899 67.98 194.846 68.0533 194.766 68.12L192.406 70.26L195.366 74.46C195.459 74.6067 195.506 74.7467 195.506 74.88C195.506 75.08 195.426 75.28 195.266 75.48C195.106 75.68 194.912 75.8467 194.686 75.98C194.459 76.1 194.239 76.16 194.026 76.16C193.759 76.16 193.546 76.0467 193.386 75.82L190.706 71.86L189.446 72.98V75.16C189.446 75.3733 189.319 75.5667 189.066 75.74C188.812 75.9133 188.499 76 188.126 76ZM197.989 76C197.616 76 197.309 75.9133 197.069 75.74C196.829 75.5667 196.709 75.3733 196.709 75.16V67.3C196.709 67.06 196.829 66.8667 197.069 66.72C197.309 66.5733 197.616 66.5 197.989 66.5C198.309 66.5 198.576 66.5733 198.789 66.72C199.016 66.8667 199.129 67.06 199.129 67.3V67.9C199.329 67.5133 199.656 67.1667 200.109 66.86C200.576 66.54 201.142 66.38 201.809 66.38C202.436 66.38 203.009 66.5667 203.529 66.94C204.049 67.3 204.462 67.7867 204.769 68.4C205.089 69.0133 205.249 69.6933 205.249 70.44V75.16C205.249 75.44 205.116 75.6533 204.849 75.8C204.582 75.9333 204.282 76 203.949 76C203.656 76 203.369 75.9333 203.089 75.8C202.809 75.6533 202.669 75.44 202.669 75.16V70.44C202.669 70.1333 202.589 69.8467 202.429 69.58C202.282 69.3133 202.076 69.0933 201.809 68.92C201.542 68.7333 201.249 68.64 200.929 68.64C200.662 68.64 200.402 68.7133 200.149 68.86C199.896 69.0067 199.689 69.2133 199.529 69.48C199.369 69.7467 199.289 70.0667 199.289 70.44V75.16C199.289 75.3733 199.162 75.5667 198.909 75.74C198.656 75.9133 198.349 76 197.989 76ZM211.138 76.18C210.364 76.18 209.651 75.9933 208.998 75.62C208.344 75.2333 207.818 74.7267 207.418 74.1C207.018 73.4733 206.818 72.8 206.818 72.08V70.44C206.818 69.72 207.011 69.0533 207.398 68.44C207.784 67.8133 208.304 67.3133 208.958 66.94C209.624 66.5667 210.351 66.38 211.138 66.38C211.924 66.38 212.644 66.5667 213.298 66.94C213.964 67.3 214.491 67.7867 214.878 68.4C215.278 69.0133 215.478 69.6933 215.478 70.44V72.08C215.478 72.7867 215.278 73.4533 214.878 74.08C214.478 74.7067 213.944 75.2133 213.278 75.6C212.624 75.9867 211.911 76.18 211.138 76.18ZM211.138 73.92C211.458 73.92 211.751 73.8333 212.018 73.66C212.284 73.4867 212.498 73.26 212.658 72.98C212.818 72.6867 212.898 72.3867 212.898 72.08V70.44C212.898 70.1333 212.818 69.8467 212.658 69.58C212.498 69.3133 212.284 69.0933 212.018 68.92C211.764 68.7333 211.471 68.64 211.138 68.64C210.818 68.64 210.524 68.7267 210.258 68.9C209.991 69.0733 209.778 69.3 209.618 69.58C209.471 69.8467 209.398 70.1333 209.398 70.44V72.08C209.398 72.3867 209.471 72.6867 209.618 72.98C209.778 73.26 209.991 73.4867 210.258 73.66C210.524 73.8333 210.818 73.92 211.138 73.92ZM220.419 76.22C220.192 76.22 219.986 76.1867 219.799 76.12C219.612 76.0533 219.486 75.9267 219.419 75.74L216.319 67.84C216.292 67.7467 216.272 67.6733 216.259 67.62C216.246 67.5533 216.239 67.5 216.239 67.46C216.239 67.2467 216.326 67.0667 216.499 66.92C216.686 66.76 216.912 66.6333 217.179 66.54C217.446 66.4467 217.686 66.4 217.899 66.4C218.072 66.4 218.226 66.4333 218.359 66.5C218.506 66.5667 218.606 66.6733 218.659 66.82L220.659 72.5L222.159 67.56C222.226 67.3333 222.339 67.1933 222.499 67.14C222.659 67.0733 222.839 67.04 223.039 67.04C223.239 67.04 223.419 67.0733 223.579 67.14C223.739 67.1933 223.852 67.3333 223.919 67.56L225.399 72.52L227.419 66.82C227.512 66.54 227.752 66.4 228.139 66.4C228.352 66.4 228.592 66.4467 228.859 66.54C229.126 66.6333 229.352 66.76 229.539 66.92C229.726 67.08 229.819 67.2667 229.819 67.48C229.819 67.5333 229.812 67.5933 229.799 67.66C229.786 67.7267 229.766 67.7867 229.739 67.84L226.639 75.76C226.572 75.9333 226.446 76.0533 226.259 76.12C226.072 76.1867 225.866 76.22 225.639 76.22C225.399 76.22 225.179 76.18 224.979 76.1C224.779 76.02 224.646 75.9067 224.579 75.76L223.039 71.4L221.499 75.74C221.459 75.9 221.332 76.02 221.119 76.1C220.906 76.18 220.672 76.22 220.419 76.22ZM70.6142 103.18C69.9076 103.18 69.2942 102.967 68.7742 102.54C68.2676 102.1 68.0142 101.427 68.0142 100.52C68.0142 99.76 68.2076 99.1667 68.5942 98.74C68.9942 98.3133 69.5409 98.0133 70.2342 97.84C70.9409 97.6667 71.7542 97.58 72.6742 97.58H73.4942V97.32C73.4942 97.0267 73.4342 96.74 73.3142 96.46C73.2076 96.18 73.0276 95.9467 72.7742 95.76C72.5342 95.5733 72.1876 95.48 71.7342 95.48C71.2276 95.48 70.8342 95.5333 70.5542 95.64C70.2876 95.7333 70.0809 95.8333 69.9342 95.94C69.7876 96.0467 69.6276 96.1 69.4542 96.1C69.1742 96.1 68.9542 95.96 68.7942 95.68C68.6476 95.4 68.5742 95.1133 68.5742 94.82C68.5742 94.54 68.7409 94.2933 69.0742 94.08C69.4209 93.8533 69.8409 93.68 70.3342 93.56C70.8276 93.44 71.3076 93.38 71.7742 93.38C72.8142 93.38 73.6476 93.5667 74.2742 93.94C74.9009 94.3133 75.3542 94.7933 75.6342 95.38C75.9276 95.9667 76.0742 96.6 76.0742 97.28V102.16C76.0742 102.4 75.9542 102.6 75.7142 102.76C75.4742 102.92 75.1742 103 74.8142 103C74.4809 103 74.2009 102.92 73.9742 102.76C73.7609 102.6 73.6542 102.4 73.6542 102.16V101.6C73.2942 102.013 72.8676 102.38 72.3742 102.7C71.8942 103.02 71.3076 103.18 70.6142 103.18ZM71.6542 101.26C71.9342 101.26 72.2142 101.167 72.4942 100.98C72.7742 100.793 73.0076 100.553 73.1942 100.26C73.3942 99.9667 73.4942 99.66 73.4942 99.34V98.92H73.1942C72.7542 98.92 72.3342 98.9467 71.9342 99C71.5342 99.0533 71.2076 99.1733 70.9542 99.36C70.7142 99.5333 70.5942 99.8067 70.5942 100.18C70.5942 100.553 70.6942 100.827 70.8942 101C71.1076 101.173 71.3609 101.26 71.6542 101.26ZM83.2083 103.18C82.5816 103.18 82.0149 103.02 81.5083 102.7C81.0016 102.38 80.6416 102.013 80.4283 101.6V102.16C80.4283 102.373 80.3149 102.567 80.0883 102.74C79.8749 102.913 79.6016 103 79.2683 103C78.9083 103 78.6083 102.913 78.3683 102.74C78.1283 102.567 78.0083 102.373 78.0083 102.16V88.76C78.0083 88.52 78.1283 88.3267 78.3683 88.18C78.6083 88.0333 78.9083 87.96 79.2683 87.96C79.6416 87.96 79.9549 88.0333 80.2083 88.18C80.4616 88.3267 80.5883 88.52 80.5883 88.76V94.9C80.8016 94.5133 81.1283 94.1667 81.5683 93.86C82.0083 93.54 82.5416 93.38 83.1683 93.38C83.8216 93.38 84.4149 93.5667 84.9483 93.94C85.4816 94.3 85.9083 94.7867 86.2283 95.4C86.5483 96.0133 86.7083 96.6933 86.7083 97.44V99.08C86.7083 99.7867 86.5483 100.453 86.2283 101.08C85.9083 101.707 85.4816 102.213 84.9483 102.6C84.4283 102.987 83.8483 103.18 83.2083 103.18ZM82.3883 100.92C82.7083 100.92 83.0016 100.833 83.2683 100.66C83.5349 100.473 83.7416 100.24 83.8883 99.96C84.0483 99.68 84.1283 99.3867 84.1283 99.08V97.44C84.1283 97.1333 84.0483 96.8467 83.8883 96.58C83.7416 96.3133 83.5349 96.0933 83.2683 95.92C83.0016 95.7333 82.7016 95.64 82.3683 95.64C82.0883 95.64 81.8083 95.7133 81.5283 95.86C81.2616 96.0067 81.0349 96.2133 80.8483 96.48C80.6749 96.7467 80.5883 97.0667 80.5883 97.44V99.44C80.5883 99.5733 80.6683 99.76 80.8283 100C80.9883 100.227 81.2016 100.44 81.4683 100.64C81.7483 100.827 82.0549 100.92 82.3883 100.92ZM92.3194 103.18C91.546 103.18 90.8327 102.993 90.1794 102.62C89.526 102.233 88.9994 101.727 88.5994 101.1C88.1994 100.473 87.9994 99.8 87.9994 99.08V97.44C87.9994 96.72 88.1927 96.0533 88.5794 95.44C88.966 94.8133 89.486 94.3133 90.1394 93.94C90.806 93.5667 91.5327 93.38 92.3194 93.38C93.106 93.38 93.826 93.5667 94.4794 93.94C95.146 94.3 95.6727 94.7867 96.0594 95.4C96.4594 96.0133 96.6594 96.6933 96.6594 97.44V99.08C96.6594 99.7867 96.4594 100.453 96.0594 101.08C95.6594 101.707 95.126 102.213 94.4594 102.6C93.806 102.987 93.0927 103.18 92.3194 103.18ZM92.3194 100.92C92.6394 100.92 92.9327 100.833 93.1994 100.66C93.466 100.487 93.6794 100.26 93.8394 99.98C93.9994 99.6867 94.0794 99.3867 94.0794 99.08V97.44C94.0794 97.1333 93.9994 96.8467 93.8394 96.58C93.6794 96.3133 93.466 96.0933 93.1994 95.92C92.946 95.7333 92.6527 95.64 92.3194 95.64C91.9994 95.64 91.706 95.7267 91.4394 95.9C91.1727 96.0733 90.9594 96.3 90.7994 96.58C90.6527 96.8467 90.5794 97.1333 90.5794 97.44V99.08C90.5794 99.3867 90.6527 99.6867 90.7994 99.98C90.9594 100.26 91.1727 100.487 91.4394 100.66C91.706 100.833 91.9994 100.92 92.3194 100.92ZM102.561 103.18C101.761 103.18 101.027 102.993 100.361 102.62C99.7074 102.233 99.1808 101.733 98.7808 101.12C98.3941 100.493 98.2008 99.8267 98.2008 99.12V94.32C98.2008 94.12 98.3274 93.9333 98.5808 93.76C98.8474 93.5867 99.1541 93.5 99.5008 93.5C99.8474 93.5 100.147 93.5867 100.401 93.76C100.654 93.9333 100.781 94.12 100.781 94.32V99.12C100.781 99.4267 100.861 99.7133 101.021 99.98C101.181 100.247 101.394 100.473 101.661 100.66C101.927 100.833 102.221 100.92 102.541 100.92C102.874 100.92 103.167 100.833 103.421 100.66C103.687 100.487 103.901 100.26 104.061 99.98C104.221 99.7 104.301 99.4133 104.301 99.12V94.3C104.301 94.0867 104.427 93.9 104.681 93.74C104.947 93.58 105.247 93.5 105.581 93.5C105.967 93.5 106.281 93.58 106.521 93.74C106.761 93.9 106.881 94.0867 106.881 94.3V99.12C106.881 99.84 106.681 100.513 106.281 101.14C105.894 101.753 105.367 102.247 104.701 102.62C104.047 102.993 103.334 103.18 102.561 103.18ZM112.449 103C111.249 103 110.329 102.74 109.689 102.22C109.062 101.7 108.749 100.873 108.749 99.74V90.06C108.749 89.82 108.889 89.6267 109.169 89.48C109.449 89.3333 109.736 89.26 110.029 89.26C110.349 89.26 110.642 89.3333 110.909 89.48C111.189 89.6267 111.329 89.82 111.329 90.06V93.5H113.689C113.902 93.5 114.062 93.6 114.169 93.8C114.289 93.9867 114.349 94.2 114.349 94.44C114.349 94.68 114.289 94.9 114.169 95.1C114.062 95.2867 113.902 95.38 113.689 95.38H111.329V99.74C111.329 100.14 111.409 100.42 111.569 100.58C111.742 100.74 112.036 100.82 112.449 100.82H113.229C113.602 100.82 113.876 100.933 114.049 101.16C114.236 101.387 114.329 101.633 114.329 101.9C114.329 102.18 114.236 102.433 114.049 102.66C113.876 102.887 113.602 103 113.229 103H112.449ZM120.928 103C120.568 103 120.268 102.913 120.028 102.74C119.788 102.567 119.668 102.373 119.668 102.16V94.3C119.668 94.06 119.788 93.8667 120.028 93.72C120.268 93.5733 120.568 93.5 120.928 93.5C121.261 93.5 121.535 93.5733 121.748 93.72C121.975 93.8667 122.088 94.06 122.088 94.3V95.12C122.235 94.8267 122.428 94.5533 122.668 94.3C122.921 94.0333 123.208 93.8133 123.528 93.64C123.848 93.4667 124.188 93.38 124.548 93.38H125.168C125.421 93.38 125.641 93.4933 125.828 93.72C126.015 93.9333 126.108 94.1933 126.108 94.5C126.108 94.82 126.015 95.0933 125.828 95.32C125.641 95.5333 125.421 95.64 125.168 95.64H124.548C124.175 95.64 123.808 95.7667 123.448 96.02C123.101 96.26 122.815 96.6 122.588 97.04C122.361 97.4667 122.248 97.9867 122.248 98.6V102.16C122.248 102.373 122.121 102.567 121.868 102.74C121.615 102.913 121.301 103 120.928 103ZM131.414 103.18C130.467 103.18 129.627 103.013 128.894 102.68C128.174 102.333 127.607 101.853 127.194 101.24C126.78 100.613 126.574 99.8933 126.574 99.08V97.38C126.574 96.66 126.767 96 127.154 95.4C127.554 94.7867 128.08 94.3 128.734 93.94C129.4 93.5667 130.14 93.38 130.954 93.38C131.7 93.38 132.38 93.54 132.994 93.86C133.62 94.18 134.127 94.62 134.514 95.18C134.9 95.74 135.094 96.3933 135.094 97.14C135.094 97.7133 135 98.1267 134.814 98.38C134.627 98.62 134.387 98.7733 134.094 98.84C133.814 98.8933 133.52 98.92 133.214 98.92H129.154V99.22C129.154 99.7933 129.367 100.26 129.794 100.62C130.234 100.967 130.8 101.14 131.494 101.14C131.934 101.14 132.3 101.073 132.594 100.94C132.887 100.807 133.14 100.68 133.354 100.56C133.567 100.44 133.767 100.38 133.954 100.38C134.154 100.38 134.327 100.447 134.474 100.58C134.62 100.713 134.734 100.873 134.814 101.06C134.894 101.233 134.934 101.387 134.934 101.52C134.934 101.747 134.787 101.993 134.494 102.26C134.214 102.513 133.807 102.733 133.274 102.92C132.754 103.093 132.134 103.18 131.414 103.18ZM129.154 97.4H132.074C132.3 97.4 132.454 97.3667 132.534 97.3C132.627 97.22 132.674 97.0733 132.674 96.86C132.674 96.5533 132.587 96.28 132.414 96.04C132.254 95.8 132.04 95.6133 131.774 95.48C131.52 95.3467 131.234 95.28 130.914 95.28C130.607 95.28 130.32 95.3467 130.054 95.48C129.787 95.6 129.567 95.78 129.394 96.02C129.234 96.2467 129.154 96.52 129.154 96.84V97.4ZM140.661 103.18C139.647 103.18 138.821 103 138.181 102.64C137.541 102.28 137.067 101.793 136.761 101.18C136.454 100.553 136.301 99.8533 136.301 99.08V97.48C136.301 96.7067 136.447 96.0133 136.741 95.4C137.047 94.7733 137.521 94.28 138.161 93.92C138.814 93.56 139.634 93.38 140.621 93.38C141.247 93.38 141.801 93.4533 142.281 93.6C142.761 93.7467 143.141 93.94 143.421 94.18C143.701 94.42 143.841 94.6733 143.841 94.94C143.841 95.1 143.794 95.28 143.701 95.48C143.621 95.6667 143.501 95.8333 143.341 95.98C143.194 96.1267 143.021 96.2 142.821 96.2C142.674 96.2 142.521 96.1533 142.361 96.06C142.214 95.9667 142.021 95.8733 141.781 95.78C141.541 95.6867 141.221 95.64 140.821 95.64C140.141 95.64 139.647 95.8067 139.341 96.14C139.034 96.46 138.881 96.9067 138.881 97.48V99.08C138.881 99.6533 139.034 100.107 139.341 100.44C139.647 100.76 140.147 100.92 140.841 100.92C141.254 100.92 141.574 100.867 141.801 100.76C142.027 100.653 142.214 100.553 142.361 100.46C142.521 100.367 142.681 100.32 142.841 100.32C143.081 100.32 143.281 100.387 143.441 100.52C143.614 100.653 143.741 100.82 143.821 101.02C143.914 101.207 143.961 101.38 143.961 101.54C143.961 101.807 143.814 102.067 143.521 102.32C143.241 102.573 142.847 102.78 142.341 102.94C141.847 103.1 141.287 103.18 140.661 103.18ZM145.573 107.42C145.24 107.42 144.96 107.353 144.733 107.22C144.506 107.1 144.393 106.8 144.393 106.32C144.393 106.027 144.44 105.773 144.533 105.56C144.64 105.347 144.813 105.24 145.053 105.24C145.28 105.24 145.54 105.2 145.833 105.12C146.14 105.04 146.446 104.887 146.753 104.66C147.06 104.447 147.32 104.147 147.533 103.76C147.746 103.387 147.873 102.9 147.913 102.3L144.473 94.94C144.42 94.82 144.393 94.7067 144.393 94.6C144.393 94.3733 144.486 94.1667 144.673 93.98C144.873 93.7933 145.106 93.6467 145.373 93.54C145.64 93.42 145.886 93.36 146.113 93.36C146.273 93.36 146.42 93.3933 146.553 93.46C146.7 93.5267 146.8 93.64 146.853 93.8L149.253 99.78L151.173 93.8C151.24 93.64 151.34 93.5267 151.473 93.46C151.606 93.3933 151.74 93.36 151.873 93.36C152.073 93.36 152.313 93.42 152.593 93.54C152.873 93.6467 153.113 93.8 153.313 94C153.526 94.1867 153.633 94.4 153.633 94.64C153.633 94.76 153.613 94.86 153.573 94.94L150.653 102.4C150.413 103 150.18 103.593 149.953 104.18C149.726 104.78 149.44 105.32 149.093 105.8C148.76 106.293 148.313 106.687 147.753 106.98C147.193 107.273 146.466 107.42 145.573 107.42ZM158.786 103.18C157.772 103.18 156.946 103 156.306 102.64C155.666 102.28 155.192 101.793 154.886 101.18C154.579 100.553 154.426 99.8533 154.426 99.08V97.48C154.426 96.7067 154.572 96.0133 154.866 95.4C155.172 94.7733 155.646 94.28 156.286 93.92C156.939 93.56 157.759 93.38 158.746 93.38C159.372 93.38 159.926 93.4533 160.406 93.6C160.886 93.7467 161.266 93.94 161.546 94.18C161.826 94.42 161.966 94.6733 161.966 94.94C161.966 95.1 161.919 95.28 161.826 95.48C161.746 95.6667 161.626 95.8333 161.466 95.98C161.319 96.1267 161.146 96.2 160.946 96.2C160.799 96.2 160.646 96.1533 160.486 96.06C160.339 95.9667 160.146 95.8733 159.906 95.78C159.666 95.6867 159.346 95.64 158.946 95.64C158.266 95.64 157.772 95.8067 157.466 96.14C157.159 96.46 157.006 96.9067 157.006 97.48V99.08C157.006 99.6533 157.159 100.107 157.466 100.44C157.772 100.76 158.272 100.92 158.966 100.92C159.379 100.92 159.699 100.867 159.926 100.76C160.152 100.653 160.339 100.553 160.486 100.46C160.646 100.367 160.806 100.32 160.966 100.32C161.206 100.32 161.406 100.387 161.566 100.52C161.739 100.653 161.866 100.82 161.946 101.02C162.039 101.207 162.086 101.38 162.086 101.54C162.086 101.807 161.939 102.067 161.646 102.32C161.366 102.573 160.972 102.78 160.466 102.94C159.972 103.1 159.412 103.18 158.786 103.18ZM164.878 103C164.505 103 164.198 102.913 163.958 102.74C163.718 102.567 163.598 102.373 163.598 102.16V88.76C163.598 88.52 163.718 88.3267 163.958 88.18C164.198 88.0333 164.505 87.96 164.878 87.96C165.238 87.96 165.545 88.0333 165.798 88.18C166.051 88.3267 166.178 88.52 166.178 88.76V102.16C166.178 102.373 166.051 102.567 165.798 102.74C165.545 102.913 165.238 103 164.878 103ZM169.639 91.38C169.253 91.38 168.919 91.2533 168.639 91C168.359 90.7333 168.219 90.44 168.219 90.12C168.219 89.7733 168.359 89.48 168.639 89.24C168.919 88.9867 169.253 88.86 169.639 88.86C170.039 88.86 170.373 88.9867 170.639 89.24C170.906 89.48 171.039 89.7733 171.039 90.12C171.039 90.44 170.906 90.7333 170.639 91C170.373 91.2533 170.039 91.38 169.639 91.38ZM169.639 103C169.266 103 168.959 102.913 168.719 102.74C168.479 102.567 168.359 102.373 168.359 102.16V94.3C168.359 94.06 168.479 93.8667 168.719 93.72C168.959 93.5733 169.266 93.5 169.639 93.5C169.999 93.5 170.306 93.5733 170.559 93.72C170.813 93.8667 170.939 94.06 170.939 94.3V102.16C170.939 102.373 170.813 102.567 170.559 102.74C170.306 102.913 169.999 103 169.639 103ZM174.19 103C173.817 103 173.51 102.913 173.27 102.74C173.03 102.567 172.91 102.373 172.91 102.16V94.3C172.91 94.06 173.03 93.8667 173.27 93.72C173.51 93.5733 173.817 93.5 174.19 93.5C174.51 93.5 174.777 93.5733 174.99 93.72C175.217 93.8667 175.33 94.06 175.33 94.3V94.9C175.53 94.5133 175.857 94.1667 176.31 93.86C176.777 93.54 177.343 93.38 178.01 93.38C178.637 93.38 179.21 93.5667 179.73 93.94C180.25 94.3 180.663 94.7867 180.97 95.4C181.29 96.0133 181.45 96.6933 181.45 97.44V102.16C181.45 102.44 181.317 102.653 181.05 102.8C180.783 102.933 180.483 103 180.15 103C179.857 103 179.57 102.933 179.29 102.8C179.01 102.653 178.87 102.44 178.87 102.16V97.44C178.87 97.1333 178.79 96.8467 178.63 96.58C178.483 96.3133 178.277 96.0933 178.01 95.92C177.743 95.7333 177.45 95.64 177.13 95.64C176.863 95.64 176.603 95.7133 176.35 95.86C176.097 96.0067 175.89 96.2133 175.73 96.48C175.57 96.7467 175.49 97.0667 175.49 97.44V102.16C175.49 102.373 175.363 102.567 175.11 102.74C174.857 102.913 174.55 103 174.19 103ZM187.119 107.42C186.332 107.42 185.599 107.307 184.919 107.08C184.252 106.867 183.712 106.547 183.299 106.12C182.899 105.693 182.699 105.187 182.699 104.6C182.699 104.093 182.839 103.66 183.119 103.3C183.399 102.953 183.746 102.68 184.159 102.48C183.906 102.36 183.699 102.2 183.539 102C183.392 101.787 183.319 101.52 183.319 101.2C183.319 100.827 183.412 100.527 183.599 100.3C183.799 100.06 184.046 99.84 184.339 99.64C183.939 99.3333 183.626 98.9667 183.399 98.54C183.186 98.1 183.079 97.62 183.079 97.1V96.68C183.079 96.0267 183.239 95.4533 183.559 94.96C183.892 94.4667 184.352 94.08 184.939 93.8C185.539 93.52 186.226 93.38 186.999 93.38C187.439 93.38 187.852 93.4333 188.239 93.54C188.626 93.6333 188.972 93.7733 189.279 93.96C189.506 93.4267 189.719 93.0667 189.919 92.88C190.119 92.6933 190.312 92.6 190.499 92.6C190.819 92.6 191.066 92.6933 191.239 92.88C191.426 93.0667 191.519 93.24 191.519 93.4C191.519 93.52 191.486 93.6267 191.419 93.72C191.366 93.8133 191.292 93.8933 191.199 93.96C191.066 94.04 190.912 94.14 190.739 94.26C190.566 94.3667 190.406 94.52 190.259 94.72C190.499 94.9867 190.672 95.2867 190.779 95.62C190.899 95.94 190.959 96.2933 190.959 96.68V97.1C190.959 97.74 190.792 98.3133 190.459 98.82C190.126 99.3133 189.659 99.7067 189.059 100C188.459 100.293 187.772 100.44 186.999 100.44C186.519 100.44 186.086 100.38 185.699 100.26C185.632 100.313 185.572 100.373 185.519 100.44C185.479 100.507 185.459 100.58 185.459 100.66C185.459 100.887 185.606 101.047 185.899 101.14C186.192 101.233 186.566 101.307 187.019 101.36C187.472 101.413 187.952 101.487 188.459 101.58C188.979 101.66 189.466 101.793 189.919 101.98C190.372 102.167 190.746 102.447 191.039 102.82C191.332 103.18 191.479 103.667 191.479 104.28C191.479 105.027 191.266 105.627 190.839 106.08C190.426 106.547 189.886 106.887 189.219 107.1C188.566 107.313 187.866 107.42 187.119 107.42ZM187.079 105.76C187.599 105.76 188.039 105.633 188.399 105.38C188.772 105.127 188.959 104.787 188.959 104.36C188.959 104.08 188.879 103.853 188.719 103.68C188.559 103.507 188.339 103.373 188.059 103.28C187.792 103.2 187.499 103.133 187.179 103.08C186.859 103.04 186.539 103 186.219 102.96C185.899 103.107 185.639 103.293 185.439 103.52C185.239 103.747 185.139 104.02 185.139 104.34C185.139 104.78 185.326 105.127 185.699 105.38C186.086 105.633 186.546 105.76 187.079 105.76ZM187.039 98.88C187.479 98.88 187.826 98.7133 188.079 98.38C188.332 98.0467 188.459 97.62 188.459 97.1V96.68C188.459 96.1867 188.332 95.7733 188.079 95.44C187.839 95.1067 187.486 94.94 187.019 94.94C186.566 94.94 186.212 95.1067 185.959 95.44C185.719 95.7733 185.599 96.1867 185.599 96.68V97.08C185.599 97.5867 185.719 98.0133 185.959 98.36C186.212 98.7067 186.572 98.88 187.039 98.88ZM195.536 98.96C195.19 98.96 194.943 98.88 194.796 98.72C194.663 98.56 194.596 98.2667 194.596 97.84C194.596 97.2133 194.656 96.7 194.776 96.3C194.896 95.9 195.05 95.5733 195.236 95.32C195.436 95.0533 195.623 94.84 195.796 94.68C195.97 94.5067 196.17 94.3333 196.396 94.16C196.623 93.9867 196.836 93.7933 197.036 93.58C197.25 93.3667 197.423 93.1267 197.556 92.86C197.69 92.5933 197.756 92.2933 197.756 91.96C197.756 91.3867 197.563 90.96 197.176 90.68C196.803 90.3867 196.31 90.24 195.696 90.24C195.216 90.24 194.843 90.3133 194.576 90.46C194.323 90.5933 194.13 90.7533 193.996 90.94C193.863 91.1267 193.73 91.2867 193.596 91.42C193.476 91.5533 193.303 91.62 193.076 91.62C192.863 91.62 192.643 91.54 192.416 91.38C192.19 91.22 192.076 90.98 192.076 90.66C192.076 90.34 192.216 90 192.496 89.64C192.776 89.2667 193.19 88.9533 193.736 88.7C194.283 88.4333 194.963 88.3 195.776 88.3C196.616 88.3 197.343 88.4533 197.956 88.76C198.583 89.0533 199.063 89.4533 199.396 89.96C199.73 90.4667 199.896 91.04 199.896 91.68C199.896 92.1867 199.803 92.6533 199.616 93.08C199.43 93.4933 199.203 93.8667 198.936 94.2C198.67 94.5333 198.403 94.8133 198.136 95.04C197.87 95.2667 197.663 95.4533 197.516 95.6C197.196 95.8533 196.963 96.1133 196.816 96.38C196.683 96.6467 196.603 96.9267 196.576 97.22C196.55 97.5133 196.536 97.8533 196.536 98.24C196.536 98.4133 196.47 98.58 196.336 98.74C196.203 98.8867 195.936 98.96 195.536 98.96ZM195.536 103.12C195.163 103.12 194.843 102.987 194.576 102.72C194.323 102.44 194.196 102.12 194.196 101.76C194.196 101.387 194.33 101.067 194.596 100.8C194.863 100.533 195.176 100.4 195.536 100.4C195.923 100.4 196.243 100.533 196.496 100.8C196.763 101.067 196.896 101.387 196.896 101.76C196.896 102.12 196.763 102.44 196.496 102.72C196.243 102.987 195.923 103.12 195.536 103.12ZM25.9689 157C25.6889 157 25.4289 156.933 25.1889 156.8C24.9489 156.653 24.8289 156.44 24.8289 156.16V143.2C24.8289 142.907 24.9622 142.7 25.2289 142.58C25.5089 142.447 25.8089 142.38 26.1289 142.38C26.4622 142.38 26.7622 142.447 27.0289 142.58C27.2956 142.7 27.4289 142.907 27.4289 143.2V154.72H32.3289C32.5956 154.72 32.7889 154.84 32.9089 155.08C33.0289 155.307 33.0889 155.567 33.0889 155.86C33.0889 156.14 33.0289 156.4 32.9089 156.64C32.7889 156.88 32.5956 157 32.3289 157H25.9689ZM38.5425 157.18C37.5958 157.18 36.7558 157.013 36.0225 156.68C35.3025 156.333 34.7358 155.853 34.3225 155.24C33.9092 154.613 33.7025 153.893 33.7025 153.08V151.38C33.7025 150.66 33.8958 150 34.2825 149.4C34.6825 148.787 35.2092 148.3 35.8625 147.94C36.5292 147.567 37.2692 147.38 38.0825 147.38C38.8292 147.38 39.5092 147.54 40.1225 147.86C40.7492 148.18 41.2558 148.62 41.6425 149.18C42.0292 149.74 42.2225 150.393 42.2225 151.14C42.2225 151.713 42.1292 152.127 41.9425 152.38C41.7558 152.62 41.5158 152.773 41.2225 152.84C40.9425 152.893 40.6492 152.92 40.3425 152.92H36.2825V153.22C36.2825 153.793 36.4958 154.26 36.9225 154.62C37.3625 154.967 37.9292 155.14 38.6225 155.14C39.0625 155.14 39.4292 155.073 39.7225 154.94C40.0158 154.807 40.2692 154.68 40.4825 154.56C40.6958 154.44 40.8958 154.38 41.0825 154.38C41.2825 154.38 41.4558 154.447 41.6025 154.58C41.7492 154.713 41.8625 154.873 41.9425 155.06C42.0225 155.233 42.0625 155.387 42.0625 155.52C42.0625 155.747 41.9158 155.993 41.6225 156.26C41.3425 156.513 40.9358 156.733 40.4025 156.92C39.8825 157.093 39.2625 157.18 38.5425 157.18ZM36.2825 151.4H39.2025C39.4292 151.4 39.5825 151.367 39.6625 151.3C39.7558 151.22 39.8025 151.073 39.8025 150.86C39.8025 150.553 39.7158 150.28 39.5425 150.04C39.3825 149.8 39.1692 149.613 38.9025 149.48C38.6492 149.347 38.3625 149.28 38.0425 149.28C37.7358 149.28 37.4492 149.347 37.1825 149.48C36.9158 149.6 36.6958 149.78 36.5225 150.02C36.3625 150.247 36.2825 150.52 36.2825 150.84V151.4ZM47.4295 157C46.2295 157 45.3095 156.74 44.6695 156.22C44.0429 155.7 43.7295 154.873 43.7295 153.74V144.06C43.7295 143.82 43.8695 143.627 44.1495 143.48C44.4295 143.333 44.7162 143.26 45.0095 143.26C45.3295 143.26 45.6229 143.333 45.8895 143.48C46.1695 143.627 46.3095 143.82 46.3095 144.06V147.5H48.6695C48.8829 147.5 49.0429 147.6 49.1495 147.8C49.2695 147.987 49.3295 148.2 49.3295 148.44C49.3295 148.68 49.2695 148.9 49.1495 149.1C49.0429 149.287 48.8829 149.38 48.6695 149.38H46.3095V153.74C46.3095 154.14 46.3895 154.42 46.5495 154.58C46.7229 154.74 47.0162 154.82 47.4295 154.82H48.2095C48.5829 154.82 48.8562 154.933 49.0295 155.16C49.2162 155.387 49.3095 155.633 49.3095 155.9C49.3095 156.18 49.2162 156.433 49.0295 156.66C48.8562 156.887 48.5829 157 48.2095 157H47.4295ZM51.2445 146.78C51.0579 146.78 50.8645 146.727 50.6645 146.62C50.4779 146.5 50.3845 146.327 50.3845 146.1C50.3845 146.007 50.4112 145.913 50.4645 145.82L50.9245 144.76C50.6979 144.64 50.5179 144.473 50.3845 144.26C50.2512 144.047 50.1845 143.807 50.1845 143.54C50.1845 143.167 50.3112 142.847 50.5645 142.58C50.8312 142.313 51.1512 142.18 51.5245 142.18C51.8979 142.18 52.2179 142.313 52.4845 142.58C52.7512 142.847 52.8845 143.16 52.8845 143.52C52.8845 143.587 52.8712 143.673 52.8445 143.78C52.8179 143.887 52.7645 144.04 52.6845 144.24C52.6179 144.427 52.5112 144.7 52.3645 145.06C52.2179 145.42 52.0179 145.887 51.7645 146.46C51.7245 146.567 51.6512 146.647 51.5445 146.7C51.4379 146.753 51.3379 146.78 51.2445 146.78ZM57.2992 157.18C56.6326 157.18 56.0192 157.1 55.4592 156.94C54.9126 156.767 54.4792 156.547 54.1592 156.28C53.8526 156.013 53.6992 155.74 53.6992 155.46C53.6992 155.313 53.7326 155.153 53.7992 154.98C53.8792 154.807 53.9792 154.653 54.0992 154.52C54.2326 154.387 54.3859 154.32 54.5592 154.32C54.7459 154.32 54.9392 154.4 55.1392 154.56C55.3526 154.707 55.6126 154.853 55.9192 155C56.2392 155.147 56.6792 155.22 57.2392 155.22C57.8392 155.22 58.2326 155.127 58.4192 154.94C58.6192 154.753 58.7192 154.56 58.7192 154.36C58.7192 154.067 58.5992 153.84 58.3592 153.68C58.1326 153.52 57.8392 153.393 57.4792 153.3C57.1192 153.193 56.7326 153.08 56.3192 152.96C55.9192 152.84 55.5392 152.687 55.1792 152.5C54.8192 152.3 54.5259 152.033 54.2992 151.7C54.0726 151.353 53.9592 150.907 53.9592 150.36C53.9592 149.88 54.0726 149.413 54.2992 148.96C54.5259 148.507 54.8992 148.133 55.4192 147.84C55.9392 147.533 56.6459 147.38 57.5392 147.38C58.0859 147.38 58.5992 147.44 59.0792 147.56C59.5726 147.667 59.9726 147.82 60.2792 148.02C60.5859 148.22 60.7392 148.44 60.7392 148.68C60.7392 148.8 60.6992 148.96 60.6192 149.16C60.5392 149.347 60.4259 149.52 60.2792 149.68C60.1459 149.84 59.9792 149.92 59.7792 149.92C59.6326 149.92 59.4526 149.873 59.2392 149.78C59.0392 149.673 58.8059 149.573 58.5392 149.48C58.2726 149.387 57.9526 149.34 57.5792 149.34C57.2459 149.34 56.9792 149.387 56.7792 149.48C56.5792 149.573 56.4326 149.687 56.3392 149.82C56.2459 149.953 56.1992 150.093 56.1992 150.24C56.1992 150.48 56.3126 150.667 56.5392 150.8C56.7659 150.933 57.0592 151.047 57.4192 151.14C57.7926 151.233 58.1792 151.34 58.5792 151.46C58.9926 151.567 59.3792 151.727 59.7392 151.94C60.1126 152.153 60.4126 152.447 60.6392 152.82C60.8659 153.18 60.9792 153.653 60.9792 154.24C60.9792 155.133 60.6592 155.847 60.0192 156.38C59.3926 156.913 58.4859 157.18 57.2992 157.18ZM67.823 161.42C67.463 161.42 67.163 161.333 66.923 161.16C66.683 160.987 66.563 160.8 66.563 160.6V148.3C66.563 148.06 66.683 147.867 66.923 147.72C67.163 147.573 67.4563 147.5 67.803 147.5C68.1496 147.5 68.4296 147.573 68.643 147.72C68.8696 147.867 68.983 148.06 68.983 148.3V148.9C69.2096 148.513 69.5563 148.167 70.023 147.86C70.4896 147.54 71.043 147.38 71.683 147.38C72.363 147.38 72.9696 147.567 73.503 147.94C74.0496 148.3 74.4763 148.787 74.783 149.4C75.103 150.013 75.263 150.693 75.263 151.44V153.08C75.263 153.787 75.103 154.453 74.783 155.08C74.463 155.707 74.0363 156.213 73.503 156.6C72.983 156.987 72.403 157.18 71.763 157.18C71.1763 157.18 70.643 157.02 70.163 156.7C69.683 156.38 69.343 156.013 69.143 155.6V160.6C69.143 160.8 69.0163 160.987 68.763 161.16C68.5096 161.333 68.1963 161.42 67.823 161.42ZM70.923 154.92C71.243 154.92 71.5296 154.833 71.783 154.66C72.0496 154.473 72.263 154.24 72.423 153.96C72.5963 153.68 72.683 153.387 72.683 153.08V151.44C72.683 151.133 72.603 150.847 72.443 150.58C72.283 150.313 72.063 150.093 71.783 149.92C71.5163 149.733 71.2163 149.64 70.883 149.64C70.5896 149.64 70.3096 149.713 70.043 149.86C69.7896 150.007 69.5763 150.213 69.403 150.48C69.2296 150.747 69.143 151.067 69.143 151.44V153.44C69.143 153.573 69.2163 153.76 69.363 154C69.523 154.227 69.7363 154.44 70.003 154.64C70.2696 154.827 70.5763 154.92 70.923 154.92ZM78.3741 157C78.0007 157 77.6941 156.913 77.4541 156.74C77.2141 156.567 77.0941 156.373 77.0941 156.16V142.76C77.0941 142.52 77.2141 142.327 77.4541 142.18C77.6941 142.033 78.0007 141.96 78.3741 141.96C78.7341 141.96 79.0407 142.033 79.2941 142.18C79.5474 142.327 79.6741 142.52 79.6741 142.76V156.16C79.6741 156.373 79.5474 156.567 79.2941 156.74C79.0407 156.913 78.7341 157 78.3741 157ZM83.8955 157.18C83.1888 157.18 82.5755 156.967 82.0555 156.54C81.5488 156.1 81.2955 155.427 81.2955 154.52C81.2955 153.76 81.4888 153.167 81.8755 152.74C82.2755 152.313 82.8221 152.013 83.5155 151.84C84.2221 151.667 85.0355 151.58 85.9555 151.58H86.7755V151.32C86.7755 151.027 86.7155 150.74 86.5955 150.46C86.4888 150.18 86.3088 149.947 86.0555 149.76C85.8155 149.573 85.4688 149.48 85.0155 149.48C84.5088 149.48 84.1155 149.533 83.8355 149.64C83.5688 149.733 83.3621 149.833 83.2155 149.94C83.0688 150.047 82.9088 150.1 82.7355 150.1C82.4555 150.1 82.2355 149.96 82.0755 149.68C81.9288 149.4 81.8555 149.113 81.8555 148.82C81.8555 148.54 82.0221 148.293 82.3555 148.08C82.7021 147.853 83.1221 147.68 83.6155 147.56C84.1088 147.44 84.5888 147.38 85.0555 147.38C86.0955 147.38 86.9288 147.567 87.5555 147.94C88.1821 148.313 88.6355 148.793 88.9155 149.38C89.2088 149.967 89.3555 150.6 89.3555 151.28V156.16C89.3555 156.4 89.2355 156.6 88.9955 156.76C88.7555 156.92 88.4555 157 88.0955 157C87.7621 157 87.4821 156.92 87.2555 156.76C87.0421 156.6 86.9355 156.4 86.9355 156.16V155.6C86.5755 156.013 86.1488 156.38 85.6555 156.7C85.1755 157.02 84.5888 157.18 83.8955 157.18ZM84.9355 155.26C85.2155 155.26 85.4955 155.167 85.7755 154.98C86.0555 154.793 86.2888 154.553 86.4755 154.26C86.6755 153.967 86.7755 153.66 86.7755 153.34V152.92H86.4755C86.0355 152.92 85.6155 152.947 85.2155 153C84.8155 153.053 84.4888 153.173 84.2355 153.36C83.9955 153.533 83.8755 153.807 83.8755 154.18C83.8755 154.553 83.9755 154.827 84.1755 155C84.3888 155.173 84.6421 155.26 84.9355 155.26ZM91.4323 161.42C91.099 161.42 90.819 161.353 90.5923 161.22C90.3657 161.1 90.2523 160.8 90.2523 160.32C90.2523 160.027 90.299 159.773 90.3923 159.56C90.499 159.347 90.6723 159.24 90.9123 159.24C91.139 159.24 91.399 159.2 91.6923 159.12C91.999 159.04 92.3057 158.887 92.6123 158.66C92.919 158.447 93.179 158.147 93.3923 157.76C93.6057 157.387 93.7323 156.9 93.7723 156.3L90.3323 148.94C90.279 148.82 90.2523 148.707 90.2523 148.6C90.2523 148.373 90.3457 148.167 90.5323 147.98C90.7323 147.793 90.9657 147.647 91.2323 147.54C91.499 147.42 91.7457 147.36 91.9723 147.36C92.1323 147.36 92.279 147.393 92.4123 147.46C92.559 147.527 92.659 147.64 92.7123 147.8L95.1123 153.78L97.0323 147.8C97.099 147.64 97.199 147.527 97.3323 147.46C97.4657 147.393 97.599 147.36 97.7323 147.36C97.9323 147.36 98.1723 147.42 98.4523 147.54C98.7323 147.647 98.9723 147.8 99.1723 148C99.3857 148.187 99.4923 148.4 99.4923 148.64C99.4923 148.76 99.4723 148.86 99.4323 148.94L96.5123 156.4C96.2723 157 96.039 157.593 95.8123 158.18C95.5857 158.78 95.299 159.32 94.9523 159.8C94.619 160.293 94.1723 160.687 93.6123 160.98C93.0523 161.273 92.3257 161.42 91.4323 161.42ZM108.289 157C107.089 157 106.169 156.74 105.529 156.22C104.902 155.7 104.589 154.873 104.589 153.74V144.06C104.589 143.82 104.729 143.627 105.009 143.48C105.289 143.333 105.576 143.26 105.869 143.26C106.189 143.26 106.482 143.333 106.749 143.48C107.029 143.627 107.169 143.82 107.169 144.06V147.5H109.529C109.742 147.5 109.902 147.6 110.009 147.8C110.129 147.987 110.189 148.2 110.189 148.44C110.189 148.68 110.129 148.9 110.009 149.1C109.902 149.287 109.742 149.38 109.529 149.38H107.169V153.74C107.169 154.14 107.249 154.42 107.409 154.58C107.582 154.74 107.876 154.82 108.289 154.82H109.069C109.442 154.82 109.716 154.933 109.889 155.16C110.076 155.387 110.169 155.633 110.169 155.9C110.169 156.18 110.076 156.433 109.889 156.66C109.716 156.887 109.442 157 109.069 157H108.289ZM112.804 157C112.431 157 112.124 156.913 111.884 156.74C111.644 156.567 111.524 156.373 111.524 156.16V142.76C111.524 142.52 111.644 142.327 111.884 142.18C112.124 142.033 112.431 141.96 112.804 141.96C113.164 141.96 113.471 142.033 113.724 142.18C113.977 142.327 114.104 142.52 114.104 142.76V148.9C114.304 148.513 114.617 148.167 115.044 147.86C115.471 147.54 115.997 147.38 116.624 147.38C117.251 147.38 117.824 147.567 118.344 147.94C118.864 148.3 119.277 148.787 119.584 149.4C119.904 150.013 120.064 150.693 120.064 151.44V156.16C120.064 156.44 119.931 156.653 119.664 156.8C119.397 156.933 119.097 157 118.764 157C118.471 157 118.184 156.933 117.904 156.8C117.624 156.653 117.484 156.44 117.484 156.16V151.44C117.484 151.133 117.404 150.847 117.244 150.58C117.084 150.313 116.871 150.093 116.604 149.92C116.351 149.733 116.064 149.64 115.744 149.64C115.477 149.64 115.217 149.713 114.964 149.86C114.711 150.007 114.504 150.213 114.344 150.48C114.184 150.747 114.104 151.067 114.104 151.44V156.16C114.104 156.373 113.977 156.567 113.724 156.74C113.471 156.913 113.164 157 112.804 157ZM126.472 157.18C125.526 157.18 124.686 157.013 123.952 156.68C123.232 156.333 122.666 155.853 122.252 155.24C121.839 154.613 121.632 153.893 121.632 153.08V151.38C121.632 150.66 121.826 150 122.212 149.4C122.612 148.787 123.139 148.3 123.792 147.94C124.459 147.567 125.199 147.38 126.012 147.38C126.759 147.38 127.439 147.54 128.052 147.86C128.679 148.18 129.186 148.62 129.572 149.18C129.959 149.74 130.152 150.393 130.152 151.14C130.152 151.713 130.059 152.127 129.872 152.38C129.686 152.62 129.446 152.773 129.152 152.84C128.872 152.893 128.579 152.92 128.272 152.92H124.212V153.22C124.212 153.793 124.426 154.26 124.852 154.62C125.292 154.967 125.859 155.14 126.552 155.14C126.992 155.14 127.359 155.073 127.652 154.94C127.946 154.807 128.199 154.68 128.412 154.56C128.626 154.44 128.826 154.38 129.012 154.38C129.212 154.38 129.386 154.447 129.532 154.58C129.679 154.713 129.792 154.873 129.872 155.06C129.952 155.233 129.992 155.387 129.992 155.52C129.992 155.747 129.846 155.993 129.552 156.26C129.272 156.513 128.866 156.733 128.332 156.92C127.812 157.093 127.192 157.18 126.472 157.18ZM124.212 151.4H127.132C127.359 151.4 127.512 151.367 127.592 151.3C127.686 151.22 127.732 151.073 127.732 150.86C127.732 150.553 127.646 150.28 127.472 150.04C127.312 149.8 127.099 149.613 126.832 149.48C126.579 149.347 126.292 149.28 125.972 149.28C125.666 149.28 125.379 149.347 125.112 149.48C124.846 149.6 124.626 149.78 124.452 150.02C124.292 150.247 124.212 150.52 124.212 150.84V151.4ZM139.803 157.18C138.936 157.18 138.15 157.053 137.443 156.8C136.75 156.547 136.196 156.233 135.783 155.86C135.383 155.473 135.183 155.087 135.183 154.7C135.183 154.513 135.23 154.313 135.323 154.1C135.43 153.873 135.57 153.687 135.743 153.54C135.916 153.38 136.11 153.3 136.323 153.3C136.536 153.3 136.736 153.38 136.923 153.54C137.11 153.687 137.323 153.867 137.563 154.08C137.803 154.28 138.096 154.46 138.443 154.62C138.79 154.767 139.216 154.84 139.723 154.84C140.123 154.84 140.49 154.78 140.823 154.66C141.17 154.527 141.443 154.333 141.643 154.08C141.856 153.827 141.963 153.5 141.963 153.1C141.963 152.673 141.85 152.313 141.623 152.02C141.396 151.727 141.09 151.473 140.703 151.26C140.316 151.047 139.896 150.84 139.443 150.64C138.99 150.44 138.53 150.227 138.063 150C137.61 149.773 137.19 149.5 136.803 149.18C136.43 148.86 136.123 148.467 135.883 148C135.656 147.533 135.543 146.96 135.543 146.28C135.543 145.533 135.683 144.907 135.963 144.4C136.256 143.893 136.636 143.487 137.103 143.18C137.583 142.86 138.11 142.633 138.683 142.5C139.256 142.353 139.83 142.28 140.403 142.28C140.71 142.28 141.07 142.307 141.483 142.36C141.91 142.4 142.33 142.48 142.743 142.6C143.17 142.72 143.516 142.887 143.783 143.1C144.063 143.3 144.203 143.567 144.203 143.9C144.203 144.047 144.163 144.227 144.083 144.44C144.016 144.653 143.903 144.847 143.743 145.02C143.596 145.193 143.403 145.28 143.163 145.28C142.95 145.28 142.736 145.22 142.523 145.1C142.323 144.967 142.056 144.84 141.723 144.72C141.403 144.587 140.963 144.52 140.403 144.52C139.936 144.52 139.53 144.58 139.183 144.7C138.836 144.82 138.576 144.993 138.403 145.22C138.23 145.433 138.143 145.707 138.143 146.04C138.143 146.387 138.256 146.68 138.483 146.92C138.723 147.16 139.03 147.373 139.403 147.56C139.79 147.747 140.21 147.933 140.663 148.12C141.116 148.307 141.57 148.527 142.023 148.78C142.49 149.02 142.916 149.313 143.303 149.66C143.69 150.007 143.996 150.44 144.223 150.96C144.45 151.467 144.563 152.093 144.563 152.84C144.563 153.787 144.356 154.587 143.943 155.24C143.53 155.88 142.963 156.367 142.243 156.7C141.536 157.02 140.723 157.18 139.803 157.18ZM150.112 157.18C149.339 157.18 148.626 156.993 147.972 156.62C147.319 156.233 146.792 155.727 146.392 155.1C145.992 154.473 145.792 153.8 145.792 153.08V151.44C145.792 150.72 145.986 150.053 146.372 149.44C146.759 148.813 147.279 148.313 147.932 147.94C148.599 147.567 149.326 147.38 150.112 147.38C150.899 147.38 151.619 147.567 152.272 147.94C152.939 148.3 153.466 148.787 153.852 149.4C154.252 150.013 154.452 150.693 154.452 151.44V153.08C154.452 153.787 154.252 154.453 153.852 155.08C153.452 155.707 152.919 156.213 152.252 156.6C151.599 156.987 150.886 157.18 150.112 157.18ZM150.112 154.92C150.432 154.92 150.726 154.833 150.992 154.66C151.259 154.487 151.472 154.26 151.632 153.98C151.792 153.687 151.872 153.387 151.872 153.08V151.44C151.872 151.133 151.792 150.847 151.632 150.58C151.472 150.313 151.259 150.093 150.992 149.92C150.739 149.733 150.446 149.64 150.112 149.64C149.792 149.64 149.499 149.727 149.232 149.9C148.966 150.073 148.752 150.3 148.592 150.58C148.446 150.847 148.372 151.133 148.372 151.44V153.08C148.372 153.387 148.446 153.687 148.592 153.98C148.752 154.26 148.966 154.487 149.232 154.66C149.499 154.833 149.792 154.92 150.112 154.92ZM157.354 157C156.994 157 156.694 156.913 156.454 156.74C156.214 156.567 156.094 156.373 156.094 156.16V148.3C156.094 148.06 156.214 147.867 156.454 147.72C156.694 147.573 156.994 147.5 157.354 147.5C157.687 147.5 157.96 147.573 158.174 147.72C158.4 147.867 158.514 148.06 158.514 148.3V149.12C158.66 148.827 158.854 148.553 159.094 148.3C159.347 148.033 159.634 147.813 159.954 147.64C160.274 147.467 160.614 147.38 160.974 147.38H161.594C161.847 147.38 162.067 147.493 162.254 147.72C162.44 147.933 162.534 148.193 162.534 148.5C162.534 148.82 162.44 149.093 162.254 149.32C162.067 149.533 161.847 149.64 161.594 149.64H160.974C160.6 149.64 160.234 149.767 159.874 150.02C159.527 150.26 159.24 150.6 159.014 151.04C158.787 151.467 158.674 151.987 158.674 152.6V156.16C158.674 156.373 158.547 156.567 158.294 156.74C158.04 156.913 157.727 157 157.354 157ZM167.254 157C166.054 157 165.134 156.74 164.494 156.22C163.867 155.7 163.554 154.873 163.554 153.74V144.06C163.554 143.82 163.694 143.627 163.974 143.48C164.254 143.333 164.54 143.26 164.834 143.26C165.154 143.26 165.447 143.333 165.714 143.48C165.994 143.627 166.134 143.82 166.134 144.06V147.5H168.494C168.707 147.5 168.867 147.6 168.974 147.8C169.094 147.987 169.154 148.2 169.154 148.44C169.154 148.68 169.094 148.9 168.974 149.1C168.867 149.287 168.707 149.38 168.494 149.38H166.134V153.74C166.134 154.14 166.214 154.42 166.374 154.58C166.547 154.74 166.84 154.82 167.254 154.82H168.034C168.407 154.82 168.68 154.933 168.854 155.16C169.04 155.387 169.134 155.633 169.134 155.9C169.134 156.18 169.04 156.433 168.854 156.66C168.68 156.887 168.407 157 168.034 157H167.254ZM171.749 145.38C171.362 145.38 171.029 145.253 170.749 145C170.469 144.733 170.329 144.44 170.329 144.12C170.329 143.773 170.469 143.48 170.749 143.24C171.029 142.987 171.362 142.86 171.749 142.86C172.149 142.86 172.482 142.987 172.749 143.24C173.015 143.48 173.149 143.773 173.149 144.12C173.149 144.44 173.015 144.733 172.749 145C172.482 145.253 172.149 145.38 171.749 145.38ZM171.749 157C171.375 157 171.069 156.913 170.829 156.74C170.589 156.567 170.469 156.373 170.469 156.16V148.3C170.469 148.06 170.589 147.867 170.829 147.72C171.069 147.573 171.375 147.5 171.749 147.5C172.109 147.5 172.415 147.573 172.669 147.72C172.922 147.867 173.049 148.06 173.049 148.3V156.16C173.049 156.373 172.922 156.567 172.669 156.74C172.415 156.913 172.109 157 171.749 157ZM176.3 157C175.926 157 175.62 156.913 175.38 156.74C175.14 156.567 175.02 156.373 175.02 156.16V148.3C175.02 148.06 175.14 147.867 175.38 147.72C175.62 147.573 175.926 147.5 176.3 147.5C176.62 147.5 176.886 147.573 177.1 147.72C177.326 147.867 177.44 148.06 177.44 148.3V148.9C177.64 148.513 177.966 148.167 178.42 147.86C178.886 147.54 179.453 147.38 180.12 147.38C180.746 147.38 181.32 147.567 181.84 147.94C182.36 148.3 182.773 148.787 183.08 149.4C183.4 150.013 183.56 150.693 183.56 151.44V156.16C183.56 156.44 183.426 156.653 183.16 156.8C182.893 156.933 182.593 157 182.26 157C181.966 157 181.68 156.933 181.4 156.8C181.12 156.653 180.98 156.44 180.98 156.16V151.44C180.98 151.133 180.9 150.847 180.74 150.58C180.593 150.313 180.386 150.093 180.12 149.92C179.853 149.733 179.56 149.64 179.24 149.64C178.973 149.64 178.713 149.713 178.46 149.86C178.206 150.007 178 150.213 177.84 150.48C177.68 150.747 177.6 151.067 177.6 151.44V156.16C177.6 156.373 177.473 156.567 177.22 156.74C176.966 156.913 176.66 157 176.3 157ZM189.228 161.42C188.442 161.42 187.708 161.307 187.028 161.08C186.362 160.867 185.822 160.547 185.408 160.12C185.008 159.693 184.808 159.187 184.808 158.6C184.808 158.093 184.948 157.66 185.228 157.3C185.508 156.953 185.855 156.68 186.268 156.48C186.015 156.36 185.808 156.2 185.648 156C185.502 155.787 185.428 155.52 185.428 155.2C185.428 154.827 185.522 154.527 185.708 154.3C185.908 154.06 186.155 153.84 186.448 153.64C186.048 153.333 185.735 152.967 185.508 152.54C185.295 152.1 185.188 151.62 185.188 151.1V150.68C185.188 150.027 185.348 149.453 185.668 148.96C186.002 148.467 186.462 148.08 187.048 147.8C187.648 147.52 188.335 147.38 189.108 147.38C189.548 147.38 189.962 147.433 190.348 147.54C190.735 147.633 191.082 147.773 191.388 147.96C191.615 147.427 191.828 147.067 192.028 146.88C192.228 146.693 192.422 146.6 192.608 146.6C192.928 146.6 193.175 146.693 193.348 146.88C193.535 147.067 193.628 147.24 193.628 147.4C193.628 147.52 193.595 147.627 193.528 147.72C193.475 147.813 193.402 147.893 193.308 147.96C193.175 148.04 193.022 148.14 192.848 148.26C192.675 148.367 192.515 148.52 192.368 148.72C192.608 148.987 192.782 149.287 192.888 149.62C193.008 149.94 193.068 150.293 193.068 150.68V151.1C193.068 151.74 192.902 152.313 192.568 152.82C192.235 153.313 191.768 153.707 191.168 154C190.568 154.293 189.882 154.44 189.108 154.44C188.628 154.44 188.195 154.38 187.808 154.26C187.742 154.313 187.682 154.373 187.628 154.44C187.588 154.507 187.568 154.58 187.568 154.66C187.568 154.887 187.715 155.047 188.008 155.14C188.302 155.233 188.675 155.307 189.128 155.36C189.582 155.413 190.062 155.487 190.568 155.58C191.088 155.66 191.575 155.793 192.028 155.98C192.482 156.167 192.855 156.447 193.148 156.82C193.442 157.18 193.588 157.667 193.588 158.28C193.588 159.027 193.375 159.627 192.948 160.08C192.535 160.547 191.995 160.887 191.328 161.1C190.675 161.313 189.975 161.42 189.228 161.42ZM189.188 159.76C189.708 159.76 190.148 159.633 190.508 159.38C190.882 159.127 191.068 158.787 191.068 158.36C191.068 158.08 190.988 157.853 190.828 157.68C190.668 157.507 190.448 157.373 190.168 157.28C189.902 157.2 189.608 157.133 189.288 157.08C188.968 157.04 188.648 157 188.328 156.96C188.008 157.107 187.748 157.293 187.548 157.52C187.348 157.747 187.248 158.02 187.248 158.34C187.248 158.78 187.435 159.127 187.808 159.38C188.195 159.633 188.655 159.76 189.188 159.76ZM189.148 152.88C189.588 152.88 189.935 152.713 190.188 152.38C190.442 152.047 190.568 151.62 190.568 151.1V150.68C190.568 150.187 190.442 149.773 190.188 149.44C189.948 149.107 189.595 148.94 189.128 148.94C188.675 148.94 188.322 149.107 188.068 149.44C187.828 149.773 187.708 150.187 187.708 150.68V151.08C187.708 151.587 187.828 152.013 188.068 152.36C188.322 152.707 188.682 152.88 189.148 152.88ZM203.646 157.12C202.766 157.12 201.973 156.973 201.266 156.68C200.56 156.373 199.993 155.887 199.566 155.22C199.153 154.54 198.946 153.64 198.946 152.52V146.98C198.946 145.86 199.153 144.967 199.566 144.3C199.993 143.62 200.553 143.133 201.246 142.84C201.953 142.533 202.726 142.38 203.566 142.38C204.5 142.38 205.32 142.533 206.026 142.84C206.746 143.147 207.313 143.587 207.726 144.16C208.14 144.733 208.346 145.42 208.346 146.22C208.346 146.713 208.24 147.047 208.026 147.22C207.813 147.38 207.486 147.46 207.046 147.46C206.7 147.46 206.4 147.4 206.146 147.28C205.893 147.16 205.76 146.947 205.746 146.64C205.733 146.32 205.666 146.013 205.546 145.72C205.44 145.413 205.24 145.16 204.946 144.96C204.666 144.76 204.233 144.66 203.646 144.66C202.993 144.66 202.48 144.853 202.106 145.24C201.746 145.613 201.566 146.193 201.566 146.98V152.52C201.566 153.307 201.746 153.893 202.106 154.28C202.48 154.653 202.993 154.84 203.646 154.84C204.3 154.84 204.813 154.653 205.186 154.28C205.56 153.893 205.746 153.307 205.746 152.52V151.36H204.126C203.873 151.36 203.673 151.253 203.526 151.04C203.393 150.827 203.326 150.593 203.326 150.34C203.326 150.087 203.393 149.853 203.526 149.64C203.673 149.427 203.873 149.32 204.126 149.32H207.526C207.793 149.32 207.993 149.407 208.126 149.58C208.273 149.74 208.346 149.94 208.346 150.18V152.52C208.346 153.64 208.14 154.54 207.726 155.22C207.313 155.887 206.746 156.373 206.026 156.68C205.32 156.973 204.526 157.12 203.646 157.12ZM212.235 157.18C211.529 157.18 210.915 156.967 210.395 156.54C209.889 156.1 209.635 155.427 209.635 154.52C209.635 153.76 209.829 153.167 210.215 152.74C210.615 152.313 211.162 152.013 211.855 151.84C212.562 151.667 213.375 151.58 214.295 151.58H215.115V151.32C215.115 151.027 215.055 150.74 214.935 150.46C214.829 150.18 214.649 149.947 214.395 149.76C214.155 149.573 213.809 149.48 213.355 149.48C212.849 149.48 212.455 149.533 212.175 149.64C211.909 149.733 211.702 149.833 211.555 149.94C211.409 150.047 211.249 150.1 211.075 150.1C210.795 150.1 210.575 149.96 210.415 149.68C210.269 149.4 210.195 149.113 210.195 148.82C210.195 148.54 210.362 148.293 210.695 148.08C211.042 147.853 211.462 147.68 211.955 147.56C212.449 147.44 212.929 147.38 213.395 147.38C214.435 147.38 215.269 147.567 215.895 147.94C216.522 148.313 216.975 148.793 217.255 149.38C217.549 149.967 217.695 150.6 217.695 151.28V156.16C217.695 156.4 217.575 156.6 217.335 156.76C217.095 156.92 216.795 157 216.435 157C216.102 157 215.822 156.92 215.595 156.76C215.382 156.6 215.275 156.4 215.275 156.16V155.6C214.915 156.013 214.489 156.38 213.995 156.7C213.515 157.02 212.929 157.18 212.235 157.18ZM213.275 155.26C213.555 155.26 213.835 155.167 214.115 154.98C214.395 154.793 214.629 154.553 214.815 154.26C215.015 153.967 215.115 153.66 215.115 153.34V152.92H214.815C214.375 152.92 213.955 152.947 213.555 153C213.155 153.053 212.829 153.173 212.575 153.36C212.335 153.533 212.215 153.807 212.215 154.18C212.215 154.553 212.315 154.827 212.515 155C212.729 155.173 212.982 155.26 213.275 155.26ZM220.889 157C220.516 157 220.209 156.913 219.969 156.74C219.729 156.567 219.609 156.373 219.609 156.16V148.3C219.609 148.06 219.729 147.867 219.969 147.72C220.209 147.573 220.516 147.5 220.889 147.5C221.209 147.5 221.476 147.573 221.689 147.72C221.916 147.867 222.029 148.06 222.029 148.3V148.9C222.256 148.513 222.589 148.167 223.029 147.86C223.469 147.54 224.023 147.38 224.689 147.38C225.263 147.38 225.769 147.567 226.209 147.94C226.649 148.313 226.976 148.793 227.189 149.38C227.536 148.7 227.976 148.2 228.509 147.88C229.056 147.547 229.616 147.38 230.189 147.38C230.803 147.38 231.376 147.54 231.909 147.86C232.456 148.167 232.896 148.627 233.229 149.24C233.576 149.84 233.749 150.573 233.749 151.44V156.16C233.749 156.373 233.623 156.567 233.369 156.74C233.116 156.913 232.809 157 232.449 157C232.103 157 231.803 156.913 231.549 156.74C231.296 156.567 231.169 156.373 231.169 156.16V151.44C231.169 151.04 231.089 150.707 230.929 150.44C230.783 150.173 230.583 149.973 230.329 149.84C230.076 149.693 229.816 149.62 229.549 149.62C229.296 149.62 229.049 149.693 228.809 149.84C228.569 149.973 228.369 150.173 228.209 150.44C228.049 150.707 227.969 151.033 227.969 151.42V156.18C227.969 156.473 227.829 156.687 227.549 156.82C227.283 156.94 226.989 157 226.669 157C226.376 157 226.089 156.94 225.809 156.82C225.529 156.687 225.389 156.473 225.389 156.18V151.44C225.389 151.067 225.309 150.747 225.149 150.48C225.003 150.213 224.803 150.007 224.549 149.86C224.309 149.713 224.049 149.64 223.769 149.64C223.503 149.64 223.249 149.707 223.009 149.84C222.769 149.973 222.569 150.173 222.409 150.44C222.263 150.707 222.189 151.04 222.189 151.44V156.16C222.189 156.373 222.063 156.567 221.809 156.74C221.556 156.913 221.249 157 220.889 157ZM240.144 157.18C239.197 157.18 238.357 157.013 237.624 156.68C236.904 156.333 236.337 155.853 235.924 155.24C235.511 154.613 235.304 153.893 235.304 153.08V151.38C235.304 150.66 235.497 150 235.884 149.4C236.284 148.787 236.811 148.3 237.464 147.94C238.131 147.567 238.871 147.38 239.684 147.38C240.431 147.38 241.111 147.54 241.724 147.86C242.351 148.18 242.857 148.62 243.244 149.18C243.631 149.74 243.824 150.393 243.824 151.14C243.824 151.713 243.731 152.127 243.544 152.38C243.357 152.62 243.117 152.773 242.824 152.84C242.544 152.893 242.251 152.92 241.944 152.92H237.884V153.22C237.884 153.793 238.097 154.26 238.524 154.62C238.964 154.967 239.531 155.14 240.224 155.14C240.664 155.14 241.031 155.073 241.324 154.94C241.617 154.807 241.871 154.68 242.084 154.56C242.297 154.44 242.497 154.38 242.684 154.38C242.884 154.38 243.057 154.447 243.204 154.58C243.351 154.713 243.464 154.873 243.544 155.06C243.624 155.233 243.664 155.387 243.664 155.52C243.664 155.747 243.517 155.993 243.224 156.26C242.944 156.513 242.537 156.733 242.004 156.92C241.484 157.093 240.864 157.18 240.144 157.18ZM237.884 151.4H240.804C241.031 151.4 241.184 151.367 241.264 151.3C241.357 151.22 241.404 151.073 241.404 150.86C241.404 150.553 241.317 150.28 241.144 150.04C240.984 149.8 240.771 149.613 240.504 149.48C240.251 149.347 239.964 149.28 239.644 149.28C239.337 149.28 239.051 149.347 238.784 149.48C238.517 149.6 238.297 149.78 238.124 150.02C237.964 150.247 237.884 150.52 237.884 150.84V151.4ZM94.3631 184C93.1631 184 92.2431 183.74 91.6031 183.22C90.9765 182.7 90.6631 181.873 90.6631 180.74V171.06C90.6631 170.82 90.8031 170.627 91.0831 170.48C91.3631 170.333 91.6498 170.26 91.9431 170.26C92.2631 170.26 92.5565 170.333 92.8231 170.48C93.1031 170.627 93.2431 170.82 93.2431 171.06V174.5H95.6031C95.8165 174.5 95.9765 174.6 96.0831 174.8C96.2031 174.987 96.2631 175.2 96.2631 175.44C96.2631 175.68 96.2031 175.9 96.0831 176.1C95.9765 176.287 95.8165 176.38 95.6031 176.38H93.2431V180.74C93.2431 181.14 93.3231 181.42 93.4831 181.58C93.6565 181.74 93.9498 181.82 94.3631 181.82H95.1431C95.5165 181.82 95.7898 181.933 95.9631 182.16C96.1498 182.387 96.2431 182.633 96.2431 182.9C96.2431 183.18 96.1498 183.433 95.9631 183.66C95.7898 183.887 95.5165 184 95.1431 184H94.3631ZM101.421 184.18C100.648 184.18 99.9343 183.993 99.2809 183.62C98.6276 183.233 98.1009 182.727 97.7009 182.1C97.3009 181.473 97.1009 180.8 97.1009 180.08V178.44C97.1009 177.72 97.2943 177.053 97.6809 176.44C98.0676 175.813 98.5876 175.313 99.2409 174.94C99.9076 174.567 100.634 174.38 101.421 174.38C102.208 174.38 102.928 174.567 103.581 174.94C104.248 175.3 104.774 175.787 105.161 176.4C105.561 177.013 105.761 177.693 105.761 178.44V180.08C105.761 180.787 105.561 181.453 105.161 182.08C104.761 182.707 104.228 183.213 103.561 183.6C102.908 183.987 102.194 184.18 101.421 184.18ZM101.421 181.92C101.741 181.92 102.034 181.833 102.301 181.66C102.568 181.487 102.781 181.26 102.941 180.98C103.101 180.687 103.181 180.387 103.181 180.08V178.44C103.181 178.133 103.101 177.847 102.941 177.58C102.781 177.313 102.568 177.093 102.301 176.92C102.048 176.733 101.754 176.64 101.421 176.64C101.101 176.64 100.808 176.727 100.541 176.9C100.274 177.073 100.061 177.3 99.9009 177.58C99.7543 177.847 99.6809 178.133 99.6809 178.44V180.08C99.6809 180.387 99.7543 180.687 99.9009 180.98C100.061 181.26 100.274 181.487 100.541 181.66C100.808 181.833 101.101 181.92 101.421 181.92ZM112.686 184C112.326 184 112.026 183.927 111.786 183.78C111.546 183.62 111.426 183.42 111.426 183.18V173.34C111.426 172.553 111.62 171.827 112.006 171.16C112.406 170.493 112.973 169.96 113.706 169.56C114.453 169.16 115.34 168.96 116.366 168.96C116.926 168.96 117.466 169.02 117.986 169.14C118.52 169.26 118.953 169.427 119.286 169.64C119.62 169.853 119.786 170.1 119.786 170.38C119.786 170.487 119.753 170.667 119.686 170.92C119.62 171.16 119.52 171.38 119.386 171.58C119.253 171.78 119.08 171.88 118.866 171.88C118.706 171.88 118.533 171.82 118.346 171.7C118.173 171.58 117.933 171.46 117.626 171.34C117.333 171.207 116.92 171.14 116.386 171.14C116.013 171.14 115.68 171.187 115.386 171.28C115.093 171.373 114.84 171.507 114.626 171.68C114.426 171.853 114.273 172.073 114.166 172.34C114.06 172.593 114.006 172.893 114.006 173.24V174.5H116.046C116.273 174.5 116.44 174.6 116.546 174.8C116.666 174.987 116.726 175.2 116.726 175.44C116.726 175.68 116.666 175.9 116.546 176.1C116.44 176.287 116.273 176.38 116.046 176.38H114.006V183.18C114.006 183.42 113.873 183.62 113.606 183.78C113.353 183.927 113.046 184 112.686 184ZM119.426 184C119.053 184 118.746 183.913 118.506 183.74C118.28 183.567 118.166 183.373 118.166 183.16V175.3C118.166 175.06 118.28 174.867 118.506 174.72C118.746 174.573 119.053 174.5 119.426 174.5C119.786 174.5 120.093 174.573 120.346 174.72C120.613 174.867 120.746 175.06 120.746 175.3V183.16C120.746 183.373 120.613 183.567 120.346 183.74C120.093 183.913 119.786 184 119.426 184ZM124.014 184C123.641 184 123.334 183.913 123.094 183.74C122.854 183.567 122.734 183.373 122.734 183.16V175.3C122.734 175.06 122.854 174.867 123.094 174.72C123.334 174.573 123.641 174.5 124.014 174.5C124.334 174.5 124.601 174.573 124.814 174.72C125.041 174.867 125.154 175.06 125.154 175.3V175.9C125.354 175.513 125.681 175.167 126.134 174.86C126.601 174.54 127.168 174.38 127.834 174.38C128.461 174.38 129.034 174.567 129.554 174.94C130.074 175.3 130.488 175.787 130.794 176.4C131.114 177.013 131.274 177.693 131.274 178.44V183.16C131.274 183.44 131.141 183.653 130.874 183.8C130.608 183.933 130.308 184 129.974 184C129.681 184 129.394 183.933 129.114 183.8C128.834 183.653 128.694 183.44 128.694 183.16V178.44C128.694 178.133 128.614 177.847 128.454 177.58C128.308 177.313 128.101 177.093 127.834 176.92C127.568 176.733 127.274 176.64 126.954 176.64C126.688 176.64 126.428 176.713 126.174 176.86C125.921 177.007 125.714 177.213 125.554 177.48C125.394 177.747 125.314 178.067 125.314 178.44V183.16C125.314 183.373 125.188 183.567 124.934 183.74C124.681 183.913 124.374 184 124.014 184ZM136.363 184.18C135.736 184.18 135.156 183.987 134.623 183.6C134.09 183.213 133.663 182.707 133.343 182.08C133.023 181.453 132.863 180.787 132.863 180.08V178.44C132.863 177.693 133.023 177.013 133.343 176.4C133.663 175.787 134.09 175.3 134.623 174.94C135.156 174.567 135.75 174.38 136.403 174.38C137.03 174.38 137.563 174.54 138.003 174.86C138.443 175.167 138.77 175.513 138.983 175.9V169.76C138.983 169.52 139.11 169.327 139.363 169.18C139.616 169.033 139.93 168.96 140.303 168.96C140.663 168.96 140.963 169.033 141.203 169.18C141.443 169.327 141.563 169.52 141.563 169.76V183.16C141.563 183.373 141.443 183.567 141.203 183.74C140.963 183.913 140.663 184 140.303 184C139.983 184 139.71 183.913 139.483 183.74C139.256 183.567 139.143 183.373 139.143 183.16V182.6C138.943 183.013 138.583 183.38 138.063 183.7C137.556 184.02 136.99 184.18 136.363 184.18ZM137.183 181.92C137.53 181.92 137.836 181.827 138.103 181.64C138.37 181.44 138.583 181.227 138.743 181C138.903 180.76 138.983 180.573 138.983 180.44V178.44C138.983 178.067 138.89 177.747 138.703 177.48C138.53 177.213 138.303 177.007 138.023 176.86C137.756 176.713 137.483 176.64 137.203 176.64C136.883 176.64 136.583 176.733 136.303 176.92C136.036 177.093 135.823 177.313 135.663 177.58C135.516 177.847 135.443 178.133 135.443 178.44V180.08C135.443 180.387 135.516 180.68 135.663 180.96C135.823 181.24 136.036 181.473 136.303 181.66C136.57 181.833 136.863 181.92 137.183 181.92ZM151.538 184.18C150.765 184.18 150.051 183.993 149.398 183.62C148.745 183.233 148.218 182.727 147.818 182.1C147.418 181.473 147.218 180.8 147.218 180.08V178.44C147.218 177.72 147.411 177.053 147.798 176.44C148.185 175.813 148.705 175.313 149.358 174.94C150.025 174.567 150.751 174.38 151.538 174.38C152.325 174.38 153.045 174.567 153.698 174.94C154.365 175.3 154.891 175.787 155.278 176.4C155.678 177.013 155.878 177.693 155.878 178.44V180.08C155.878 180.787 155.678 181.453 155.278 182.08C154.878 182.707 154.345 183.213 153.678 183.6C153.025 183.987 152.311 184.18 151.538 184.18ZM151.538 181.92C151.858 181.92 152.151 181.833 152.418 181.66C152.685 181.487 152.898 181.26 153.058 180.98C153.218 180.687 153.298 180.387 153.298 180.08V178.44C153.298 178.133 153.218 177.847 153.058 177.58C152.898 177.313 152.685 177.093 152.418 176.92C152.165 176.733 151.871 176.64 151.538 176.64C151.218 176.64 150.925 176.727 150.658 176.9C150.391 177.073 150.178 177.3 150.018 177.58C149.871 177.847 149.798 178.133 149.798 178.44V180.08C149.798 180.387 149.871 180.687 150.018 180.98C150.178 181.26 150.391 181.487 150.658 181.66C150.925 181.833 151.218 181.92 151.538 181.92ZM161.78 184.18C160.98 184.18 160.246 183.993 159.58 183.62C158.926 183.233 158.4 182.733 158 182.12C157.613 181.493 157.42 180.827 157.42 180.12V175.32C157.42 175.12 157.546 174.933 157.8 174.76C158.066 174.587 158.373 174.5 158.72 174.5C159.066 174.5 159.366 174.587 159.62 174.76C159.873 174.933 160 175.12 160 175.32V180.12C160 180.427 160.08 180.713 160.24 180.98C160.4 181.247 160.613 181.473 160.88 181.66C161.146 181.833 161.44 181.92 161.76 181.92C162.093 181.92 162.386 181.833 162.64 181.66C162.906 181.487 163.12 181.26 163.28 180.98C163.44 180.7 163.52 180.413 163.52 180.12V175.3C163.52 175.087 163.646 174.9 163.9 174.74C164.166 174.58 164.466 174.5 164.8 174.5C165.186 174.5 165.5 174.58 165.74 174.74C165.98 174.9 166.1 175.087 166.1 175.3V180.12C166.1 180.84 165.9 181.513 165.5 182.14C165.113 182.753 164.586 183.247 163.92 183.62C163.266 183.993 162.553 184.18 161.78 184.18ZM171.668 184C170.468 184 169.548 183.74 168.908 183.22C168.281 182.7 167.968 181.873 167.968 180.74V171.06C167.968 170.82 168.108 170.627 168.388 170.48C168.668 170.333 168.954 170.26 169.248 170.26C169.568 170.26 169.861 170.333 170.128 170.48C170.408 170.627 170.548 170.82 170.548 171.06V174.5H172.908C173.121 174.5 173.281 174.6 173.388 174.8C173.508 174.987 173.568 175.2 173.568 175.44C173.568 175.68 173.508 175.9 173.388 176.1C173.281 176.287 173.121 176.38 172.908 176.38H170.548V180.74C170.548 181.14 170.628 181.42 170.788 181.58C170.961 181.74 171.254 181.82 171.668 181.82H172.448C172.821 181.82 173.094 181.933 173.268 182.16C173.454 182.387 173.548 182.633 173.548 182.9C173.548 183.18 173.454 183.433 173.268 183.66C173.094 183.887 172.821 184 172.448 184H171.668ZM176.103 179.96C175.836 179.96 175.603 179.9 175.403 179.78C175.203 179.66 175.103 179.467 175.103 179.2C175.103 178.32 175.083 177.367 175.043 176.34C175.003 175.313 174.956 174.287 174.903 173.26C174.863 172.233 174.843 171.28 174.843 170.4C174.843 170.053 174.963 169.787 175.203 169.6C175.443 169.4 175.743 169.3 176.103 169.3C176.436 169.3 176.723 169.4 176.963 169.6C177.216 169.787 177.343 170.053 177.343 170.4C177.343 171.28 177.323 172.233 177.283 173.26C177.243 174.287 177.196 175.313 177.143 176.34C177.103 177.367 177.083 178.32 177.083 179.2C177.083 179.467 176.969 179.66 176.743 179.78C176.516 179.9 176.303 179.96 176.103 179.96ZM176.123 184.12C175.736 184.12 175.409 183.987 175.143 183.72C174.889 183.44 174.763 183.12 174.763 182.76C174.763 182.387 174.889 182.067 175.143 181.8C175.409 181.533 175.736 181.4 176.123 181.4C176.483 181.4 176.796 181.533 177.063 181.8C177.329 182.067 177.463 182.387 177.463 182.76C177.463 183.12 177.329 183.44 177.063 183.72C176.796 183.987 176.483 184.12 176.123 184.12Z\"             fill=\"#578FFE\" />         <g filter=\"url(#filter1_d_1192_50364)\" id=\"gameIntroBtn\">             <path d=\"M98 217H161C166.523 217 171 221.477 171 227V246H108C102.477 246 98 241.523 98 236V217Z\"                 fill=\"white\" />             <path                 d=\"M120.219 237C119.995 237 119.785 236.953 119.589 236.86C119.402 236.757 119.309 236.608 119.309 236.412V227.34C119.309 227.144 119.402 226.999 119.589 226.906C119.785 226.813 119.995 226.766 120.219 226.766C120.443 226.766 120.625 226.789 120.765 226.836C120.914 226.883 121.049 226.976 121.171 227.116C121.301 227.247 121.437 227.452 121.577 227.732L124.279 232.954V227.34C124.279 227.135 124.372 226.99 124.559 226.906C124.755 226.813 124.965 226.766 125.189 226.766C125.422 226.766 125.632 226.813 125.819 226.906C126.005 226.99 126.099 227.135 126.099 227.34V236.412C126.099 236.608 126.005 236.757 125.819 236.86C125.632 236.953 125.422 237 125.189 237C124.974 237 124.773 236.958 124.587 236.874C124.409 236.79 124.265 236.641 124.153 236.426L121.129 230.798V236.412C121.129 236.608 121.035 236.757 120.849 236.86C120.662 236.953 120.452 237 120.219 237ZM128.597 237C128.401 237 128.219 236.953 128.051 236.86C127.883 236.757 127.799 236.608 127.799 236.412V227.354C127.799 227.158 127.883 227.013 128.051 226.92C128.219 226.817 128.401 226.766 128.597 226.766H133.581C133.786 226.766 133.931 226.85 134.015 227.018C134.108 227.186 134.155 227.363 134.155 227.55C134.155 227.774 134.104 227.965 134.001 228.124C133.908 228.283 133.768 228.362 133.581 228.362H129.619V231.162H131.747C131.934 231.162 132.074 231.237 132.167 231.386C132.27 231.526 132.321 231.694 132.321 231.89C132.321 232.049 132.274 232.207 132.181 232.366C132.097 232.515 131.952 232.59 131.747 232.59H129.619V235.404H133.581C133.768 235.404 133.908 235.483 134.001 235.642C134.104 235.801 134.155 235.992 134.155 236.216C134.155 236.403 134.108 236.58 134.015 236.748C133.931 236.916 133.786 237 133.581 237H128.597ZM135.755 237.07C135.587 237.07 135.409 237.028 135.223 236.944C135.036 236.86 134.877 236.753 134.747 236.622C134.616 236.482 134.551 236.328 134.551 236.16C134.551 236.057 134.588 235.945 134.663 235.824L137.085 231.876L134.747 227.942C134.663 227.811 134.621 227.681 134.621 227.55C134.621 227.391 134.681 227.247 134.803 227.116C134.924 226.985 135.073 226.883 135.251 226.808C135.437 226.733 135.615 226.696 135.783 226.696C135.932 226.696 136.053 226.733 136.147 226.808C136.249 226.873 136.329 226.967 136.385 227.088L138.289 230.518L140.207 227.088C140.272 226.967 140.351 226.873 140.445 226.808C140.547 226.733 140.669 226.696 140.809 226.696C140.986 226.696 141.163 226.733 141.341 226.808C141.518 226.883 141.667 226.985 141.789 227.116C141.91 227.247 141.971 227.391 141.971 227.55C141.971 227.681 141.929 227.811 141.845 227.942L139.507 231.876L141.929 235.824C142.003 235.945 142.041 236.057 142.041 236.16C142.041 236.328 141.975 236.482 141.845 236.622C141.714 236.753 141.555 236.86 141.369 236.944C141.191 237.028 141.014 237.07 140.837 237.07C140.734 237.07 140.636 237.042 140.543 236.986C140.459 236.93 140.393 236.86 140.347 236.776L138.289 233.178L136.245 236.776C136.198 236.86 136.128 236.93 136.035 236.986C135.951 237.042 135.857 237.07 135.755 237.07ZM145.871 237C145.638 237 145.428 236.953 145.241 236.86C145.054 236.757 144.961 236.608 144.961 236.412V228.404H142.903C142.726 228.404 142.586 228.32 142.483 228.152C142.38 227.984 142.329 227.793 142.329 227.578C142.329 227.382 142.376 227.2 142.469 227.032C142.562 226.855 142.707 226.766 142.903 226.766H148.825C149.03 226.766 149.175 226.855 149.259 227.032C149.352 227.2 149.399 227.382 149.399 227.578C149.399 227.793 149.348 227.984 149.245 228.152C149.152 228.32 149.012 228.404 148.825 228.404H146.781V236.412C146.781 236.608 146.683 236.757 146.487 236.86C146.3 236.953 146.095 237 145.871 237Z\"                 fill=\"#FF0082\" />             <path                 d=\"M98.5 217.5H161C166.247 217.5 170.5 221.753 170.5 227V245.5H108C102.753 245.5 98.5 241.247 98.5 236V217.5Z\"                 stroke=\"#F7CFE5\" />         </g>     </g>     <defs>         <filter id=\"filter0_d_1192_50364\" x=\"0\" y=\"0\" width=\"275\" height=\"275\" filterUnits=\"userSpaceOnUse\"             color-interpolation-filters=\"sRGB\">             <feFlood flood-opacity=\"0\" result=\"BackgroundImageFix\" />             <feColorMatrix in=\"SourceAlpha\" type=\"matrix\" values=\"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0\"                 result=\"hardAlpha\" />             <feOffset dx=\"5\" dy=\"5\" />             <feComposite in2=\"hardAlpha\" operator=\"out\" />             <feColorMatrix type=\"matrix\" values=\"0 0 0 0 1 0 0 0 0 0 0 0 0 0 0.509804 0 0 0 1 0\" />             <feBlend mode=\"normal\" in2=\"BackgroundImageFix\" result=\"effect1_dropShadow_1192_50364\" />             <feBlend mode=\"normal\" in=\"SourceGraphic\" in2=\"effect1_dropShadow_1192_50364\" result=\"shape\" />         </filter>         <filter id=\"filter1_d_1192_50364\" x=\"98\" y=\"217\" width=\"75\" height=\"31\" filterUnits=\"userSpaceOnUse\"             color-interpolation-filters=\"sRGB\">             <feFlood flood-opacity=\"0\" result=\"BackgroundImageFix\" />             <feColorMatrix in=\"SourceAlpha\" type=\"matrix\" values=\"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0\"                 result=\"hardAlpha\" />             <feOffset dx=\"2\" dy=\"2\" />             <feComposite in2=\"hardAlpha\" operator=\"out\" />             <feColorMatrix type=\"matrix\" values=\"0 0 0 0 1 0 0 0 0 0 0 0 0 0 0.509804 0 0 0 1 0\" />             <feBlend mode=\"normal\" in2=\"BackgroundImageFix\" result=\"effect1_dropShadow_1192_50364\" />             <feBlend mode=\"normal\" in=\"SourceGraphic\" in2=\"effect1_dropShadow_1192_50364\" result=\"shape\" />         </filter>     </defs> </svg>") // EJsS HtmlView.HtmlView Page: setting property 'Html' for element 'gameIntroduction'
      .setProperty("Display","none") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'gameIntroduction'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"gameplayInstructions", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'gameplayInstructions'
      .setProperty("Html","<svg width=\"275\" height=\"275\" viewBox=\"0 0 275 275\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"> <g filter=\"url(#filter0_d_1192_50369)\"> <rect width=\"270\" height=\"270\" rx=\"50\" fill=\"#F9E6E0\"/> <rect x=\"0.5\" y=\"0.5\" width=\"269\" height=\"269\" rx=\"49.5\" stroke=\"#FFD208\"/> <path d=\"M47.5369 60.12C46.6569 60.12 45.8635 59.9733 45.1569 59.68C44.4502 59.3733 43.8835 58.8867 43.4569 58.22C43.0435 57.54 42.8369 56.64 42.8369 55.52V49.98C42.8369 48.86 43.0435 47.9667 43.4569 47.3C43.8835 46.62 44.4435 46.1333 45.1369 45.84C45.8435 45.5333 46.6169 45.38 47.4569 45.38C48.3902 45.38 49.2102 45.5333 49.9169 45.84C50.6369 46.1467 51.2035 46.5867 51.6169 47.16C52.0302 47.7333 52.2369 48.42 52.2369 49.22C52.2369 49.7133 52.1302 50.0467 51.9169 50.22C51.7035 50.38 51.3769 50.46 50.9369 50.46C50.5902 50.46 50.2902 50.4 50.0369 50.28C49.7835 50.16 49.6502 49.9467 49.6369 49.64C49.6235 49.32 49.5569 49.0133 49.4369 48.72C49.3302 48.4133 49.1302 48.16 48.8369 47.96C48.5569 47.76 48.1235 47.66 47.5369 47.66C46.8835 47.66 46.3702 47.8533 45.9969 48.24C45.6369 48.6133 45.4569 49.1933 45.4569 49.98V55.52C45.4569 56.3067 45.6369 56.8933 45.9969 57.28C46.3702 57.6533 46.8835 57.84 47.5369 57.84C48.1902 57.84 48.7035 57.6533 49.0769 57.28C49.4502 56.8933 49.6369 56.3067 49.6369 55.52V54.36H48.0169C47.7635 54.36 47.5635 54.2533 47.4169 54.04C47.2835 53.8267 47.2169 53.5933 47.2169 53.34C47.2169 53.0867 47.2835 52.8533 47.4169 52.64C47.5635 52.4267 47.7635 52.32 48.0169 52.32H51.4169C51.6835 52.32 51.8835 52.4067 52.0169 52.58C52.1635 52.74 52.2369 52.94 52.2369 53.18V55.52C52.2369 56.64 52.0302 57.54 51.6169 58.22C51.2035 58.8867 50.6369 59.3733 49.9169 59.68C49.2102 59.9733 48.4169 60.12 47.5369 60.12ZM56.1259 60.18C55.4193 60.18 54.8059 59.9667 54.2859 59.54C53.7793 59.1 53.5259 58.4267 53.5259 57.52C53.5259 56.76 53.7193 56.1667 54.1059 55.74C54.5059 55.3133 55.0526 55.0133 55.7459 54.84C56.4526 54.6667 57.2659 54.58 58.1859 54.58H59.0059V54.32C59.0059 54.0267 58.9459 53.74 58.8259 53.46C58.7193 53.18 58.5393 52.9467 58.2859 52.76C58.0459 52.5733 57.6993 52.48 57.2459 52.48C56.7393 52.48 56.3459 52.5333 56.0659 52.64C55.7993 52.7333 55.5926 52.8333 55.4459 52.94C55.2993 53.0467 55.1393 53.1 54.9659 53.1C54.6859 53.1 54.4659 52.96 54.3059 52.68C54.1593 52.4 54.0859 52.1133 54.0859 51.82C54.0859 51.54 54.2526 51.2933 54.5859 51.08C54.9326 50.8533 55.3526 50.68 55.8459 50.56C56.3393 50.44 56.8193 50.38 57.2859 50.38C58.3259 50.38 59.1593 50.5667 59.7859 50.94C60.4126 51.3133 60.8659 51.7933 61.1459 52.38C61.4393 52.9667 61.5859 53.6 61.5859 54.28V59.16C61.5859 59.4 61.4659 59.6 61.2259 59.76C60.9859 59.92 60.6859 60 60.3259 60C59.9926 60 59.7126 59.92 59.4859 59.76C59.2726 59.6 59.1659 59.4 59.1659 59.16V58.6C58.8059 59.0133 58.3793 59.38 57.8859 59.7C57.4059 60.02 56.8193 60.18 56.1259 60.18ZM57.1659 58.26C57.4459 58.26 57.7259 58.1667 58.0059 57.98C58.2859 57.7933 58.5193 57.5533 58.7059 57.26C58.9059 56.9667 59.0059 56.66 59.0059 56.34V55.92H58.7059C58.2659 55.92 57.8459 55.9467 57.4459 56C57.0459 56.0533 56.7193 56.1733 56.4659 56.36C56.2259 56.5333 56.1059 56.8067 56.1059 57.18C56.1059 57.5533 56.2059 57.8267 56.4059 58C56.6193 58.1733 56.8726 58.26 57.1659 58.26ZM64.78 60C64.4067 60 64.1 59.9133 63.86 59.74C63.62 59.5667 63.5 59.3733 63.5 59.16V51.3C63.5 51.06 63.62 50.8667 63.86 50.72C64.1 50.5733 64.4067 50.5 64.78 50.5C65.1 50.5 65.3667 50.5733 65.58 50.72C65.8067 50.8667 65.92 51.06 65.92 51.3V51.9C66.1467 51.5133 66.48 51.1667 66.92 50.86C67.36 50.54 67.9133 50.38 68.58 50.38C69.1533 50.38 69.66 50.5667 70.1 50.94C70.54 51.3133 70.8667 51.7933 71.08 52.38C71.4267 51.7 71.8667 51.2 72.4 50.88C72.9467 50.5467 73.5067 50.38 74.08 50.38C74.6933 50.38 75.2667 50.54 75.8 50.86C76.3467 51.1667 76.7867 51.6267 77.12 52.24C77.4667 52.84 77.64 53.5733 77.64 54.44V59.16C77.64 59.3733 77.5133 59.5667 77.26 59.74C77.0067 59.9133 76.7 60 76.34 60C75.9933 60 75.6933 59.9133 75.44 59.74C75.1867 59.5667 75.06 59.3733 75.06 59.16V54.44C75.06 54.04 74.98 53.7067 74.82 53.44C74.6733 53.1733 74.4733 52.9733 74.22 52.84C73.9667 52.6933 73.7067 52.62 73.44 52.62C73.1867 52.62 72.94 52.6933 72.7 52.84C72.46 52.9733 72.26 53.1733 72.1 53.44C71.94 53.7067 71.86 54.0333 71.86 54.42V59.18C71.86 59.4733 71.72 59.6867 71.44 59.82C71.1733 59.94 70.88 60 70.56 60C70.2667 60 69.98 59.94 69.7 59.82C69.42 59.6867 69.28 59.4733 69.28 59.18V54.44C69.28 54.0667 69.2 53.7467 69.04 53.48C68.8933 53.2133 68.6933 53.0067 68.44 52.86C68.2 52.7133 67.94 52.64 67.66 52.64C67.3933 52.64 67.14 52.7067 66.9 52.84C66.66 52.9733 66.46 53.1733 66.3 53.44C66.1533 53.7067 66.08 54.04 66.08 54.44V59.16C66.08 59.3733 65.9533 59.5667 65.7 59.74C65.4467 59.9133 65.14 60 64.78 60ZM84.0347 60.18C83.088 60.18 82.248 60.0133 81.5147 59.68C80.7947 59.3333 80.228 58.8533 79.8147 58.24C79.4014 57.6133 79.1947 56.8933 79.1947 56.08V54.38C79.1947 53.66 79.388 53 79.7747 52.4C80.1747 51.7867 80.7014 51.3 81.3547 50.94C82.0214 50.5667 82.7614 50.38 83.5747 50.38C84.3214 50.38 85.0014 50.54 85.6147 50.86C86.2414 51.18 86.748 51.62 87.1347 52.18C87.5214 52.74 87.7147 53.3933 87.7147 54.14C87.7147 54.7133 87.6214 55.1267 87.4347 55.38C87.248 55.62 87.008 55.7733 86.7147 55.84C86.4347 55.8933 86.1414 55.92 85.8347 55.92H81.7747V56.22C81.7747 56.7933 81.988 57.26 82.4147 57.62C82.8547 57.9667 83.4214 58.14 84.1147 58.14C84.5547 58.14 84.9214 58.0733 85.2147 57.94C85.508 57.8067 85.7614 57.68 85.9747 57.56C86.188 57.44 86.388 57.38 86.5747 57.38C86.7747 57.38 86.948 57.4467 87.0947 57.58C87.2414 57.7133 87.3547 57.8733 87.4347 58.06C87.5147 58.2333 87.5547 58.3867 87.5547 58.52C87.5547 58.7467 87.408 58.9933 87.1147 59.26C86.8347 59.5133 86.428 59.7333 85.8947 59.92C85.3747 60.0933 84.7547 60.18 84.0347 60.18ZM81.7747 54.4H84.6947C84.9214 54.4 85.0747 54.3667 85.1547 54.3C85.248 54.22 85.2947 54.0733 85.2947 53.86C85.2947 53.5533 85.208 53.28 85.0347 53.04C84.8747 52.8 84.6614 52.6133 84.3947 52.48C84.1414 52.3467 83.8547 52.28 83.5347 52.28C83.228 52.28 82.9414 52.3467 82.6747 52.48C82.408 52.6 82.188 52.78 82.0147 53.02C81.8547 53.2467 81.7747 53.52 81.7747 53.84V54.4ZM90.5417 64.42C90.1817 64.42 89.8817 64.3333 89.6417 64.16C89.4017 63.9867 89.2817 63.8 89.2817 63.6V51.3C89.2817 51.06 89.4017 50.8667 89.6417 50.72C89.8817 50.5733 90.1751 50.5 90.5217 50.5C90.8684 50.5 91.1484 50.5733 91.3617 50.72C91.5884 50.8667 91.7017 51.06 91.7017 51.3V51.9C91.9284 51.5133 92.2751 51.1667 92.7417 50.86C93.2084 50.54 93.7617 50.38 94.4017 50.38C95.0817 50.38 95.6884 50.5667 96.2217 50.94C96.7684 51.3 97.1951 51.7867 97.5017 52.4C97.8217 53.0133 97.9817 53.6933 97.9817 54.44V56.08C97.9817 56.7867 97.8217 57.4533 97.5017 58.08C97.1817 58.7067 96.7551 59.2133 96.2217 59.6C95.7017 59.9867 95.1217 60.18 94.4817 60.18C93.8951 60.18 93.3617 60.02 92.8817 59.7C92.4017 59.38 92.0617 59.0133 91.8617 58.6V63.6C91.8617 63.8 91.7351 63.9867 91.4817 64.16C91.2284 64.3333 90.9151 64.42 90.5417 64.42ZM93.6417 57.92C93.9617 57.92 94.2484 57.8333 94.5017 57.66C94.7684 57.4733 94.9817 57.24 95.1417 56.96C95.3151 56.68 95.4017 56.3867 95.4017 56.08V54.44C95.4017 54.1333 95.3217 53.8467 95.1617 53.58C95.0017 53.3133 94.7817 53.0933 94.5017 52.92C94.2351 52.7333 93.9351 52.64 93.6017 52.64C93.3084 52.64 93.0284 52.7133 92.7617 52.86C92.5084 53.0067 92.2951 53.2133 92.1217 53.48C91.9484 53.7467 91.8617 54.0667 91.8617 54.44V56.44C91.8617 56.5733 91.9351 56.76 92.0817 57C92.2417 57.2267 92.4551 57.44 92.7217 57.64C92.9884 57.8267 93.2951 57.92 93.6417 57.92ZM101.093 60C100.719 60 100.413 59.9133 100.173 59.74C99.9328 59.5667 99.8128 59.3733 99.8128 59.16V45.76C99.8128 45.52 99.9328 45.3267 100.173 45.18C100.413 45.0333 100.719 44.96 101.093 44.96C101.453 44.96 101.759 45.0333 102.013 45.18C102.266 45.3267 102.393 45.52 102.393 45.76V59.16C102.393 59.3733 102.266 59.5667 102.013 59.74C101.759 59.9133 101.453 60 101.093 60ZM106.614 60.18C105.908 60.18 105.294 59.9667 104.774 59.54C104.268 59.1 104.014 58.4267 104.014 57.52C104.014 56.76 104.208 56.1667 104.594 55.74C104.994 55.3133 105.541 55.0133 106.234 54.84C106.941 54.6667 107.754 54.58 108.674 54.58H109.494V54.32C109.494 54.0267 109.434 53.74 109.314 53.46C109.208 53.18 109.028 52.9467 108.774 52.76C108.534 52.5733 108.188 52.48 107.734 52.48C107.228 52.48 106.834 52.5333 106.554 52.64C106.288 52.7333 106.081 52.8333 105.934 52.94C105.788 53.0467 105.628 53.1 105.454 53.1C105.174 53.1 104.954 52.96 104.794 52.68C104.648 52.4 104.574 52.1133 104.574 51.82C104.574 51.54 104.741 51.2933 105.074 51.08C105.421 50.8533 105.841 50.68 106.334 50.56C106.828 50.44 107.308 50.38 107.774 50.38C108.814 50.38 109.648 50.5667 110.274 50.94C110.901 51.3133 111.354 51.7933 111.634 52.38C111.928 52.9667 112.074 53.6 112.074 54.28V59.16C112.074 59.4 111.954 59.6 111.714 59.76C111.474 59.92 111.174 60 110.814 60C110.481 60 110.201 59.92 109.974 59.76C109.761 59.6 109.654 59.4 109.654 59.16V58.6C109.294 59.0133 108.868 59.38 108.374 59.7C107.894 60.02 107.308 60.18 106.614 60.18ZM107.654 58.26C107.934 58.26 108.214 58.1667 108.494 57.98C108.774 57.7933 109.008 57.5533 109.194 57.26C109.394 56.9667 109.494 56.66 109.494 56.34V55.92H109.194C108.754 55.92 108.334 55.9467 107.934 56C107.534 56.0533 107.208 56.1733 106.954 56.36C106.714 56.5333 106.594 56.8067 106.594 57.18C106.594 57.5533 106.694 57.8267 106.894 58C107.108 58.1733 107.361 58.26 107.654 58.26ZM114.151 64.42C113.818 64.42 113.538 64.3533 113.311 64.22C113.084 64.1 112.971 63.8 112.971 63.32C112.971 63.0267 113.018 62.7733 113.111 62.56C113.218 62.3467 113.391 62.24 113.631 62.24C113.858 62.24 114.118 62.2 114.411 62.12C114.718 62.04 115.024 61.8867 115.331 61.66C115.638 61.4467 115.898 61.1467 116.111 60.76C116.324 60.3867 116.451 59.9 116.491 59.3L113.051 51.94C112.998 51.82 112.971 51.7067 112.971 51.6C112.971 51.3733 113.064 51.1667 113.251 50.98C113.451 50.7933 113.684 50.6467 113.951 50.54C114.218 50.42 114.464 50.36 114.691 50.36C114.851 50.36 114.998 50.3933 115.131 50.46C115.278 50.5267 115.378 50.64 115.431 50.8L117.831 56.78L119.751 50.8C119.818 50.64 119.918 50.5267 120.051 50.46C120.184 50.3933 120.318 50.36 120.451 50.36C120.651 50.36 120.891 50.42 121.171 50.54C121.451 50.6467 121.691 50.8 121.891 51C122.104 51.1867 122.211 51.4 122.211 51.64C122.211 51.76 122.191 51.86 122.151 51.94L119.231 59.4C118.991 60 118.758 60.5933 118.531 61.18C118.304 61.78 118.018 62.32 117.671 62.8C117.338 63.2933 116.891 63.6867 116.331 63.98C115.771 64.2733 115.044 64.42 114.151 64.42ZM128.848 60C128.528 60 128.228 59.9333 127.948 59.8C127.681 59.6533 127.548 59.44 127.548 59.16V46.2C127.548 45.9067 127.681 45.7 127.948 45.58C128.228 45.4467 128.528 45.38 128.848 45.38C129.181 45.38 129.481 45.4467 129.748 45.58C130.014 45.7 130.148 45.9067 130.148 46.2V59.16C130.148 59.44 130.014 59.6533 129.748 59.8C129.481 59.9333 129.181 60 128.848 60ZM133.628 60C133.254 60 132.948 59.9133 132.708 59.74C132.468 59.5667 132.348 59.3733 132.348 59.16V51.3C132.348 51.06 132.468 50.8667 132.708 50.72C132.948 50.5733 133.254 50.5 133.628 50.5C133.948 50.5 134.214 50.5733 134.428 50.72C134.654 50.8667 134.768 51.06 134.768 51.3V51.9C134.968 51.5133 135.294 51.1667 135.748 50.86C136.214 50.54 136.781 50.38 137.448 50.38C138.074 50.38 138.648 50.5667 139.168 50.94C139.688 51.3 140.101 51.7867 140.408 52.4C140.728 53.0133 140.888 53.6933 140.888 54.44V59.16C140.888 59.44 140.754 59.6533 140.488 59.8C140.221 59.9333 139.921 60 139.588 60C139.294 60 139.008 59.9333 138.728 59.8C138.448 59.6533 138.308 59.44 138.308 59.16V54.44C138.308 54.1333 138.228 53.8467 138.068 53.58C137.921 53.3133 137.714 53.0933 137.448 52.92C137.181 52.7333 136.888 52.64 136.568 52.64C136.301 52.64 136.041 52.7133 135.788 52.86C135.534 53.0067 135.328 53.2133 135.168 53.48C135.008 53.7467 134.928 54.0667 134.928 54.44V59.16C134.928 59.3733 134.801 59.5667 134.548 59.74C134.294 59.9133 133.988 60 133.628 60ZM145.916 60.18C145.25 60.18 144.636 60.1 144.076 59.94C143.53 59.7667 143.096 59.5467 142.776 59.28C142.47 59.0133 142.316 58.74 142.316 58.46C142.316 58.3133 142.35 58.1533 142.416 57.98C142.496 57.8067 142.596 57.6533 142.716 57.52C142.85 57.3867 143.003 57.32 143.176 57.32C143.363 57.32 143.556 57.4 143.756 57.56C143.97 57.7067 144.23 57.8533 144.536 58C144.856 58.1467 145.296 58.22 145.856 58.22C146.456 58.22 146.85 58.1267 147.036 57.94C147.236 57.7533 147.336 57.56 147.336 57.36C147.336 57.0667 147.216 56.84 146.976 56.68C146.75 56.52 146.456 56.3933 146.096 56.3C145.736 56.1933 145.35 56.08 144.936 55.96C144.536 55.84 144.156 55.6867 143.796 55.5C143.436 55.3 143.143 55.0333 142.916 54.7C142.69 54.3533 142.576 53.9067 142.576 53.36C142.576 52.88 142.69 52.4133 142.916 51.96C143.143 51.5067 143.516 51.1333 144.036 50.84C144.556 50.5333 145.263 50.38 146.156 50.38C146.703 50.38 147.216 50.44 147.696 50.56C148.19 50.6667 148.59 50.82 148.896 51.02C149.203 51.22 149.356 51.44 149.356 51.68C149.356 51.8 149.316 51.96 149.236 52.16C149.156 52.3467 149.043 52.52 148.896 52.68C148.763 52.84 148.596 52.92 148.396 52.92C148.25 52.92 148.07 52.8733 147.856 52.78C147.656 52.6733 147.423 52.5733 147.156 52.48C146.89 52.3867 146.57 52.34 146.196 52.34C145.863 52.34 145.596 52.3867 145.396 52.48C145.196 52.5733 145.05 52.6867 144.956 52.82C144.863 52.9533 144.816 53.0933 144.816 53.24C144.816 53.48 144.93 53.6667 145.156 53.8C145.383 53.9333 145.676 54.0467 146.036 54.14C146.41 54.2333 146.796 54.34 147.196 54.46C147.61 54.5667 147.996 54.7267 148.356 54.94C148.73 55.1533 149.03 55.4467 149.256 55.82C149.483 56.18 149.596 56.6533 149.596 57.24C149.596 58.1333 149.276 58.8467 148.636 59.38C148.01 59.9133 147.103 60.18 145.916 60.18ZM154.816 60C153.616 60 152.696 59.74 152.056 59.22C151.43 58.7 151.116 57.8733 151.116 56.74V47.06C151.116 46.82 151.256 46.6267 151.536 46.48C151.816 46.3333 152.103 46.26 152.396 46.26C152.716 46.26 153.01 46.3333 153.276 46.48C153.556 46.6267 153.696 46.82 153.696 47.06V50.5H156.056C156.27 50.5 156.43 50.6 156.536 50.8C156.656 50.9867 156.716 51.2 156.716 51.44C156.716 51.68 156.656 51.9 156.536 52.1C156.43 52.2867 156.27 52.38 156.056 52.38H153.696V56.74C153.696 57.14 153.776 57.42 153.936 57.58C154.11 57.74 154.403 57.82 154.816 57.82H155.596C155.97 57.82 156.243 57.9333 156.416 58.16C156.603 58.3867 156.696 58.6333 156.696 58.9C156.696 59.18 156.603 59.4333 156.416 59.66C156.243 59.8867 155.97 60 155.596 60H154.816ZM159.291 60C158.931 60 158.631 59.9133 158.391 59.74C158.151 59.5667 158.031 59.3733 158.031 59.16V51.3C158.031 51.06 158.151 50.8667 158.391 50.72C158.631 50.5733 158.931 50.5 159.291 50.5C159.625 50.5 159.898 50.5733 160.111 50.72C160.338 50.8667 160.451 51.06 160.451 51.3V52.12C160.598 51.8267 160.791 51.5533 161.031 51.3C161.285 51.0333 161.571 50.8133 161.891 50.64C162.211 50.4667 162.551 50.38 162.911 50.38H163.531C163.785 50.38 164.005 50.4933 164.191 50.72C164.378 50.9333 164.471 51.1933 164.471 51.5C164.471 51.82 164.378 52.0933 164.191 52.32C164.005 52.5333 163.785 52.64 163.531 52.64H162.911C162.538 52.64 162.171 52.7667 161.811 53.02C161.465 53.26 161.178 53.6 160.951 54.04C160.725 54.4667 160.611 54.9867 160.611 55.6V59.16C160.611 59.3733 160.485 59.5667 160.231 59.74C159.978 59.9133 159.665 60 159.291 60ZM169.791 60.18C168.991 60.18 168.258 59.9933 167.591 59.62C166.938 59.2333 166.411 58.7333 166.011 58.12C165.625 57.4933 165.431 56.8267 165.431 56.12V51.32C165.431 51.12 165.558 50.9333 165.811 50.76C166.078 50.5867 166.385 50.5 166.731 50.5C167.078 50.5 167.378 50.5867 167.631 50.76C167.885 50.9333 168.011 51.12 168.011 51.32V56.12C168.011 56.4267 168.091 56.7133 168.251 56.98C168.411 57.2467 168.625 57.4733 168.891 57.66C169.158 57.8333 169.451 57.92 169.771 57.92C170.105 57.92 170.398 57.8333 170.651 57.66C170.918 57.4867 171.131 57.26 171.291 56.98C171.451 56.7 171.531 56.4133 171.531 56.12V51.3C171.531 51.0867 171.658 50.9 171.911 50.74C172.178 50.58 172.478 50.5 172.811 50.5C173.198 50.5 173.511 50.58 173.751 50.74C173.991 50.9 174.111 51.0867 174.111 51.3V56.12C174.111 56.84 173.911 57.5133 173.511 58.14C173.125 58.7533 172.598 59.2467 171.931 59.62C171.278 59.9933 170.565 60.18 169.791 60.18ZM180.04 60.18C179.026 60.18 178.2 60 177.56 59.64C176.92 59.28 176.446 58.7933 176.14 58.18C175.833 57.5533 175.68 56.8533 175.68 56.08V54.48C175.68 53.7067 175.826 53.0133 176.12 52.4C176.426 51.7733 176.9 51.28 177.54 50.92C178.193 50.56 179.013 50.38 180 50.38C180.626 50.38 181.18 50.4533 181.66 50.6C182.14 50.7467 182.52 50.94 182.8 51.18C183.08 51.42 183.22 51.6733 183.22 51.94C183.22 52.1 183.173 52.28 183.08 52.48C183 52.6667 182.88 52.8333 182.72 52.98C182.573 53.1267 182.4 53.2 182.2 53.2C182.053 53.2 181.9 53.1533 181.74 53.06C181.593 52.9667 181.4 52.8733 181.16 52.78C180.92 52.6867 180.6 52.64 180.2 52.64C179.52 52.64 179.026 52.8067 178.72 53.14C178.413 53.46 178.26 53.9067 178.26 54.48V56.08C178.26 56.6533 178.413 57.1067 178.72 57.44C179.026 57.76 179.526 57.92 180.22 57.92C180.633 57.92 180.953 57.8667 181.18 57.76C181.406 57.6533 181.593 57.5533 181.74 57.46C181.9 57.3667 182.06 57.32 182.22 57.32C182.46 57.32 182.66 57.3867 182.82 57.52C182.993 57.6533 183.12 57.82 183.2 58.02C183.293 58.2067 183.34 58.38 183.34 58.54C183.34 58.8067 183.193 59.0667 182.9 59.32C182.62 59.5733 182.226 59.78 181.72 59.94C181.226 60.1 180.666 60.18 180.04 60.18ZM188.332 60C187.132 60 186.212 59.74 185.572 59.22C184.945 58.7 184.632 57.8733 184.632 56.74V47.06C184.632 46.82 184.772 46.6267 185.052 46.48C185.332 46.3333 185.619 46.26 185.912 46.26C186.232 46.26 186.525 46.3333 186.792 46.48C187.072 46.6267 187.212 46.82 187.212 47.06V50.5H189.572C189.785 50.5 189.945 50.6 190.052 50.8C190.172 50.9867 190.232 51.2 190.232 51.44C190.232 51.68 190.172 51.9 190.052 52.1C189.945 52.2867 189.785 52.38 189.572 52.38H187.212V56.74C187.212 57.14 187.292 57.42 187.452 57.58C187.625 57.74 187.919 57.82 188.332 57.82H189.112C189.485 57.82 189.759 57.9333 189.932 58.16C190.119 58.3867 190.212 58.6333 190.212 58.9C190.212 59.18 190.119 59.4333 189.932 59.66C189.759 59.8867 189.485 60 189.112 60H188.332ZM192.827 48.38C192.44 48.38 192.107 48.2533 191.827 48C191.547 47.7333 191.407 47.44 191.407 47.12C191.407 46.7733 191.547 46.48 191.827 46.24C192.107 45.9867 192.44 45.86 192.827 45.86C193.227 45.86 193.56 45.9867 193.827 46.24C194.094 46.48 194.227 46.7733 194.227 47.12C194.227 47.44 194.094 47.7333 193.827 48C193.56 48.2533 193.227 48.38 192.827 48.38ZM192.827 60C192.454 60 192.147 59.9133 191.907 59.74C191.667 59.5667 191.547 59.3733 191.547 59.16V51.3C191.547 51.06 191.667 50.8667 191.907 50.72C192.147 50.5733 192.454 50.5 192.827 50.5C193.187 50.5 193.494 50.5733 193.747 50.72C194 50.8667 194.127 51.06 194.127 51.3V59.16C194.127 59.3733 194 59.5667 193.747 59.74C193.494 59.9133 193.187 60 192.827 60ZM200.058 60.18C199.284 60.18 198.571 59.9933 197.918 59.62C197.264 59.2333 196.738 58.7267 196.338 58.1C195.938 57.4733 195.738 56.8 195.738 56.08V54.44C195.738 53.72 195.931 53.0533 196.318 52.44C196.704 51.8133 197.224 51.3133 197.878 50.94C198.544 50.5667 199.271 50.38 200.058 50.38C200.844 50.38 201.564 50.5667 202.218 50.94C202.884 51.3 203.411 51.7867 203.798 52.4C204.198 53.0133 204.398 53.6933 204.398 54.44V56.08C204.398 56.7867 204.198 57.4533 203.798 58.08C203.398 58.7067 202.864 59.2133 202.198 59.6C201.544 59.9867 200.831 60.18 200.058 60.18ZM200.058 57.92C200.378 57.92 200.671 57.8333 200.938 57.66C201.204 57.4867 201.418 57.26 201.578 56.98C201.738 56.6867 201.818 56.3867 201.818 56.08V54.44C201.818 54.1333 201.738 53.8467 201.578 53.58C201.418 53.3133 201.204 53.0933 200.938 52.92C200.684 52.7333 200.391 52.64 200.058 52.64C199.738 52.64 199.444 52.7267 199.178 52.9C198.911 53.0733 198.698 53.3 198.538 53.58C198.391 53.8467 198.318 54.1333 198.318 54.44V56.08C198.318 56.3867 198.391 56.6867 198.538 56.98C198.698 57.26 198.911 57.4867 199.178 57.66C199.444 57.8333 199.738 57.92 200.058 57.92ZM207.319 60C206.946 60 206.639 59.9133 206.399 59.74C206.159 59.5667 206.039 59.3733 206.039 59.16V51.3C206.039 51.06 206.159 50.8667 206.399 50.72C206.639 50.5733 206.946 50.5 207.319 50.5C207.639 50.5 207.906 50.5733 208.119 50.72C208.346 50.8667 208.459 51.06 208.459 51.3V51.9C208.659 51.5133 208.986 51.1667 209.439 50.86C209.906 50.54 210.472 50.38 211.139 50.38C211.766 50.38 212.339 50.5667 212.859 50.94C213.379 51.3 213.792 51.7867 214.099 52.4C214.419 53.0133 214.579 53.6933 214.579 54.44V59.16C214.579 59.44 214.446 59.6533 214.179 59.8C213.912 59.9333 213.612 60 213.279 60C212.986 60 212.699 59.9333 212.419 59.8C212.139 59.6533 211.999 59.44 211.999 59.16V54.44C211.999 54.1333 211.919 53.8467 211.759 53.58C211.612 53.3133 211.406 53.0933 211.139 52.92C210.872 52.7333 210.579 52.64 210.259 52.64C209.992 52.64 209.732 52.7133 209.479 52.86C209.226 53.0067 209.019 53.2133 208.859 53.48C208.699 53.7467 208.619 54.0667 208.619 54.44V59.16C208.619 59.3733 208.492 59.5667 208.239 59.74C207.986 59.9133 207.679 60 207.319 60ZM219.608 60.18C218.941 60.18 218.328 60.1 217.768 59.94C217.221 59.7667 216.788 59.5467 216.468 59.28C216.161 59.0133 216.008 58.74 216.008 58.46C216.008 58.3133 216.041 58.1533 216.108 57.98C216.188 57.8067 216.288 57.6533 216.408 57.52C216.541 57.3867 216.694 57.32 216.868 57.32C217.054 57.32 217.248 57.4 217.448 57.56C217.661 57.7067 217.921 57.8533 218.228 58C218.548 58.1467 218.988 58.22 219.548 58.22C220.148 58.22 220.541 58.1267 220.728 57.94C220.928 57.7533 221.028 57.56 221.028 57.36C221.028 57.0667 220.908 56.84 220.668 56.68C220.441 56.52 220.148 56.3933 219.788 56.3C219.428 56.1933 219.041 56.08 218.628 55.96C218.228 55.84 217.848 55.6867 217.488 55.5C217.128 55.3 216.834 55.0333 216.608 54.7C216.381 54.3533 216.268 53.9067 216.268 53.36C216.268 52.88 216.381 52.4133 216.608 51.96C216.834 51.5067 217.208 51.1333 217.728 50.84C218.248 50.5333 218.954 50.38 219.848 50.38C220.394 50.38 220.908 50.44 221.388 50.56C221.881 50.6667 222.281 50.82 222.588 51.02C222.894 51.22 223.048 51.44 223.048 51.68C223.048 51.8 223.008 51.96 222.928 52.16C222.848 52.3467 222.734 52.52 222.588 52.68C222.454 52.84 222.288 52.92 222.088 52.92C221.941 52.92 221.761 52.8733 221.548 52.78C221.348 52.6733 221.114 52.5733 220.848 52.48C220.581 52.3867 220.261 52.34 219.888 52.34C219.554 52.34 219.288 52.3867 219.088 52.48C218.888 52.5733 218.741 52.6867 218.648 52.82C218.554 52.9533 218.508 53.0933 218.508 53.24C218.508 53.48 218.621 53.6667 218.848 53.8C219.074 53.9333 219.368 54.0467 219.728 54.14C220.101 54.2333 220.488 54.34 220.888 54.46C221.301 54.5667 221.688 54.7267 222.048 54.94C222.421 55.1533 222.721 55.4467 222.948 55.82C223.174 56.18 223.288 56.6533 223.288 57.24C223.288 58.1333 222.968 58.8467 222.328 59.38C221.701 59.9133 220.794 60.18 219.608 60.18ZM226.048 54.28C225.648 54.28 225.314 54.1467 225.048 53.88C224.794 53.6 224.668 53.28 224.668 52.92C224.668 52.5467 224.794 52.2267 225.048 51.96C225.314 51.6933 225.648 51.56 226.048 51.56C226.408 51.56 226.721 51.6933 226.988 51.96C227.254 52.2267 227.388 52.5467 227.388 52.92C227.388 53.28 227.254 53.6 226.988 53.88C226.721 54.1467 226.408 54.28 226.048 54.28ZM226.048 60.12C225.648 60.12 225.314 59.9867 225.048 59.72C224.794 59.44 224.668 59.12 224.668 58.76C224.668 58.3867 224.794 58.0667 225.048 57.8C225.314 57.5333 225.648 57.4 226.048 57.4C226.408 57.4 226.721 57.5333 226.988 57.8C227.254 58.0667 227.388 58.3867 227.388 58.76C227.388 59.12 227.254 59.44 226.988 59.72C226.721 59.9867 226.408 60.12 226.048 60.12Z\" fill=\"#FF0082\"/> <path d=\"M41.5503 101.096C40.9103 101.096 40.3183 100.979 39.7743 100.744C39.241 100.509 38.8143 100.131 38.4943 99.608C38.1743 99.0853 38.0143 98.392 38.0143 97.528V92.872C38.0143 92.008 38.1743 91.3147 38.4943 90.792C38.8143 90.2693 39.2463 89.8907 39.7903 89.656C40.3343 89.4213 40.9263 89.304 41.5663 89.304C42.3023 89.304 42.937 89.432 43.4703 89.688C44.0143 89.9333 44.4356 90.2747 44.7343 90.712C45.0436 91.1387 45.1983 91.6347 45.1983 92.2C45.1983 92.5627 45.129 92.8027 44.9903 92.92C44.8516 93.0267 44.6383 93.08 44.3503 93.08C44.0943 93.08 43.8916 93.0373 43.7423 92.952C43.593 92.856 43.513 92.712 43.5023 92.52C43.4916 92.3813 43.465 92.216 43.4223 92.024C43.3796 91.832 43.2943 91.6453 43.1663 91.464C43.049 91.272 42.8676 91.1173 42.6223 91C42.377 90.872 42.041 90.808 41.6143 90.808C40.9956 90.808 40.521 90.9787 40.1903 91.32C39.8596 91.6507 39.6943 92.168 39.6943 92.872V97.528C39.6943 98.232 39.8596 98.7547 40.1903 99.096C40.5316 99.4267 41.0223 99.592 41.6623 99.592C42.0676 99.592 42.3876 99.5333 42.6223 99.416C42.8676 99.288 43.049 99.1333 43.1663 98.952C43.2836 98.76 43.3636 98.5627 43.4063 98.36C43.449 98.1467 43.481 97.9547 43.5023 97.784C43.513 97.5813 43.593 97.4373 43.7423 97.352C43.9023 97.2667 44.0996 97.224 44.3343 97.224C44.633 97.224 44.8516 97.2827 44.9903 97.4C45.129 97.5173 45.1983 97.752 45.1983 98.104C45.1983 98.68 45.0436 99.1973 44.7343 99.656C44.4356 100.104 44.0143 100.456 43.4703 100.712C42.9263 100.968 42.2863 101.096 41.5503 101.096ZM47.5826 101C47.3372 101 47.1346 100.941 46.9746 100.824C46.8252 100.707 46.7506 100.579 46.7506 100.44V89.448C46.7506 89.288 46.8252 89.16 46.9746 89.064C47.1346 88.9573 47.3372 88.904 47.5826 88.904C47.8172 88.904 48.0146 88.9573 48.1746 89.064C48.3452 89.16 48.4306 89.288 48.4306 89.448V100.44C48.4306 100.579 48.3452 100.707 48.1746 100.824C48.0146 100.941 47.8172 101 47.5826 101ZM51.1573 91.512C50.8906 91.512 50.6613 91.4213 50.4693 91.24C50.2773 91.0587 50.1813 90.856 50.1813 90.632C50.1813 90.3867 50.2773 90.1787 50.4693 90.008C50.6613 89.8373 50.8906 89.752 51.1573 89.752C51.424 89.752 51.648 89.8373 51.8293 90.008C52.0213 90.1787 52.1173 90.3867 52.1173 90.632C52.1173 90.856 52.0213 91.0587 51.8293 91.24C51.648 91.4213 51.424 91.512 51.1573 91.512ZM51.1573 101C50.912 101 50.7093 100.941 50.5493 100.824C50.4 100.707 50.3253 100.579 50.3253 100.44V93.96C50.3253 93.8 50.4 93.672 50.5493 93.576C50.7093 93.4693 50.912 93.416 51.1573 93.416C51.392 93.416 51.5893 93.4693 51.7493 93.576C51.92 93.672 52.0053 93.8 52.0053 93.96V100.44C52.0053 100.579 51.92 100.707 51.7493 100.824C51.5893 100.941 51.392 101 51.1573 101ZM56.8192 101.128C56.0512 101.128 55.4165 100.989 54.9152 100.712C54.4245 100.435 54.0619 100.056 53.8272 99.576C53.5925 99.096 53.4752 98.552 53.4752 97.944V96.504C53.4752 95.9067 53.5925 95.368 53.8272 94.888C54.0619 94.3973 54.4245 94.0133 54.9152 93.736C55.4059 93.4587 56.0299 93.32 56.7872 93.32C57.2779 93.32 57.7045 93.3787 58.0672 93.496C58.4405 93.6133 58.7285 93.7627 58.9312 93.944C59.1445 94.1147 59.2512 94.296 59.2512 94.488C59.2512 94.584 59.2192 94.7013 59.1552 94.84C59.1019 94.968 59.0219 95.08 58.9152 95.176C58.8192 95.2613 58.7019 95.304 58.5632 95.304C58.4565 95.304 58.3392 95.2613 58.2112 95.176C58.0939 95.0907 57.9339 95.0107 57.7312 94.936C57.5285 94.8507 57.2565 94.808 56.9152 94.808C56.3179 94.808 55.8752 94.9573 55.5872 95.256C55.2992 95.5547 55.1552 95.9707 55.1552 96.504V97.944C55.1552 98.4773 55.2992 98.8933 55.5872 99.192C55.8752 99.4907 56.3232 99.64 56.9312 99.64C57.2832 99.64 57.5605 99.5973 57.7632 99.512C57.9659 99.416 58.1259 99.3253 58.2432 99.24C58.3712 99.1547 58.4939 99.112 58.6112 99.112C58.7605 99.112 58.8885 99.1547 58.9952 99.24C59.1125 99.3253 59.1979 99.432 59.2512 99.56C59.3152 99.688 59.3472 99.8053 59.3472 99.912C59.3472 100.093 59.2352 100.28 59.0112 100.472C58.7979 100.664 58.4992 100.824 58.1152 100.952C57.7419 101.069 57.3099 101.128 56.8192 101.128ZM61.3761 101C61.1414 101 60.9441 100.941 60.7841 100.824C60.6347 100.707 60.5601 100.579 60.5601 100.44V89.448C60.5601 89.288 60.6347 89.16 60.7841 89.064C60.9441 88.9573 61.1414 88.904 61.3761 88.904C61.6214 88.904 61.8241 88.9573 61.9841 89.064C62.1547 89.16 62.2401 89.288 62.2401 89.448V96.568L65.5841 93.496C65.6801 93.4 65.7974 93.352 65.9361 93.352C66.0641 93.352 66.1867 93.3947 66.3041 93.48C66.4321 93.5547 66.5387 93.656 66.6241 93.784C66.7094 93.9013 66.7521 94.024 66.7521 94.152C66.7521 94.216 66.7414 94.28 66.7201 94.344C66.6987 94.3973 66.6614 94.4507 66.6081 94.504L64.5441 96.344L67.0561 99.96C67.1201 100.067 67.1521 100.163 67.1521 100.248C67.1521 100.387 67.0987 100.52 66.9921 100.648C66.8961 100.776 66.7734 100.883 66.6241 100.968C66.4854 101.053 66.3467 101.096 66.2081 101.096C66.0161 101.096 65.8667 101.016 65.7601 100.856L63.4081 97.384L62.2401 98.44V100.44C62.2401 100.579 62.1547 100.707 61.9841 100.824C61.8241 100.941 61.6214 101 61.3761 101ZM73.0514 101.128C72.4648 101.128 71.9634 100.957 71.5474 100.616C71.1314 100.264 70.9234 99.7307 70.9234 99.016C70.9234 98.408 71.0834 97.9387 71.4034 97.608C71.7234 97.2773 72.1608 97.048 72.7154 96.92C73.2808 96.792 73.9314 96.728 74.6674 96.728H75.3714V96.44C75.3714 96.1627 75.3181 95.896 75.2114 95.64C75.1154 95.3733 74.9501 95.1547 74.7154 94.984C74.4914 94.8027 74.1821 94.712 73.7874 94.712C73.3928 94.712 73.0888 94.7493 72.8754 94.824C72.6621 94.8987 72.4914 94.9787 72.3634 95.064C72.2354 95.1493 72.1181 95.192 72.0114 95.192C71.8194 95.192 71.6701 95.1013 71.5634 94.92C71.4568 94.728 71.4034 94.536 71.4034 94.344C71.4034 94.152 71.5261 93.9813 71.7714 93.832C72.0274 93.672 72.3421 93.5493 72.7154 93.464C73.0888 93.368 73.4568 93.32 73.8194 93.32C74.6088 93.32 75.2381 93.4693 75.7074 93.768C76.1768 94.056 76.5181 94.4347 76.7314 94.904C76.9448 95.3733 77.0514 95.88 77.0514 96.424V100.44C77.0514 100.589 76.9714 100.723 76.8114 100.84C76.6621 100.947 76.4701 101 76.2354 101C76.0221 101 75.8408 100.947 75.6914 100.84C75.5421 100.723 75.4674 100.589 75.4674 100.44V99.88C75.1901 100.2 74.8541 100.488 74.4594 100.744C74.0648 101 73.5954 101.128 73.0514 101.128ZM73.6594 99.848C73.9261 99.848 74.1874 99.768 74.4434 99.608C74.7101 99.448 74.9288 99.2453 75.0994 99C75.2808 98.7547 75.3714 98.504 75.3714 98.248V97.656H74.9714C74.5661 97.656 74.1821 97.6827 73.8194 97.736C73.4568 97.7787 73.1634 97.8853 72.9394 98.056C72.7261 98.216 72.6194 98.4667 72.6194 98.808C72.6194 99.1707 72.7154 99.4373 72.9074 99.608C73.1101 99.768 73.3608 99.848 73.6594 99.848ZM79.5792 101C79.3339 101 79.1312 100.941 78.9712 100.824C78.8219 100.707 78.7472 100.579 78.7472 100.44V93.96C78.7472 93.8 78.8219 93.672 78.9712 93.576C79.1312 93.4693 79.3339 93.416 79.5792 93.416C79.7819 93.416 79.9579 93.4693 80.1072 93.576C80.2565 93.672 80.3312 93.8 80.3312 93.96V94.536C80.4912 94.2267 80.7525 93.9493 81.1152 93.704C81.4885 93.448 81.9419 93.32 82.4752 93.32C82.9765 93.32 83.4352 93.464 83.8512 93.752C84.2779 94.0293 84.6192 94.408 84.8752 94.888C85.1312 95.3573 85.2592 95.8853 85.2592 96.472V100.44C85.2592 100.621 85.1685 100.76 84.9872 100.856C84.8165 100.952 84.6245 101 84.4112 101C84.2192 101 84.0325 100.952 83.8512 100.856C83.6699 100.76 83.5792 100.621 83.5792 100.44V96.472C83.5792 96.1947 83.5045 95.928 83.3552 95.672C83.2165 95.416 83.0245 95.208 82.7792 95.048C82.5339 94.888 82.2619 94.808 81.9632 94.808C81.7072 94.808 81.4619 94.8773 81.2272 95.016C80.9925 95.144 80.8005 95.3307 80.6512 95.576C80.5019 95.8213 80.4272 96.12 80.4272 96.472V100.44C80.4272 100.579 80.3419 100.707 80.1712 100.824C80.0112 100.941 79.8139 101 79.5792 101ZM89.4627 101.128C88.9614 101.128 88.4974 100.979 88.0707 100.68C87.644 100.381 87.2974 99.992 87.0307 99.512C86.7747 99.0213 86.6467 98.4987 86.6467 97.944V96.472C86.6467 95.8853 86.7747 95.3573 87.0307 94.888C87.2974 94.408 87.644 94.0293 88.0707 93.752C88.4974 93.464 88.972 93.32 89.4947 93.32C90.0067 93.32 90.4387 93.448 90.7907 93.704C91.1427 93.9493 91.404 94.2267 91.5747 94.536V89.448C91.5747 89.288 91.66 89.16 91.8307 89.064C92.0014 88.9573 92.204 88.904 92.4387 88.904C92.6734 88.904 92.8654 88.9573 93.0147 89.064C93.1747 89.16 93.2547 89.288 93.2547 89.448V100.44C93.2547 100.579 93.1747 100.707 93.0147 100.824C92.8654 100.941 92.6734 101 92.4387 101C92.236 101 92.0547 100.941 91.8947 100.824C91.7454 100.707 91.6707 100.579 91.6707 100.44V99.88C91.5107 100.211 91.228 100.504 90.8227 100.76C90.4174 101.005 89.964 101.128 89.4627 101.128ZM89.9427 99.64C90.252 99.64 90.5294 99.5547 90.7747 99.384C91.02 99.2133 91.212 99.0267 91.3507 98.824C91.5 98.6107 91.5747 98.44 91.5747 98.312V96.472C91.5747 96.12 91.4947 95.8213 91.3347 95.576C91.1747 95.3307 90.972 95.144 90.7267 95.016C90.4814 94.8773 90.2254 94.808 89.9587 94.808C89.66 94.808 89.3827 94.888 89.1267 95.048C88.8814 95.208 88.684 95.416 88.5347 95.672C88.396 95.928 88.3267 96.1947 88.3267 96.472V97.944C88.3267 98.2213 88.396 98.4933 88.5347 98.76C88.684 99.0267 88.8814 99.24 89.1267 99.4C89.372 99.56 89.644 99.64 89.9427 99.64ZM100.76 101.128C100.258 101.128 99.7942 100.979 99.3676 100.68C98.9409 100.381 98.5942 99.992 98.3276 99.512C98.0716 99.0213 97.9436 98.4987 97.9436 97.944V96.472C97.9436 95.8853 98.0716 95.3573 98.3276 94.888C98.5942 94.408 98.9409 94.0293 99.3676 93.752C99.7942 93.464 100.269 93.32 100.792 93.32C101.304 93.32 101.736 93.448 102.088 93.704C102.44 93.9493 102.701 94.2267 102.872 94.536V89.448C102.872 89.288 102.957 89.16 103.128 89.064C103.298 88.9573 103.501 88.904 103.736 88.904C103.97 88.904 104.162 88.9573 104.312 89.064C104.472 89.16 104.552 89.288 104.552 89.448V100.44C104.552 100.579 104.472 100.707 104.312 100.824C104.162 100.941 103.97 101 103.736 101C103.533 101 103.352 100.941 103.192 100.824C103.042 100.707 102.968 100.579 102.968 100.44V99.88C102.808 100.211 102.525 100.504 102.12 100.76C101.714 101.005 101.261 101.128 100.76 101.128ZM101.24 99.64C101.549 99.64 101.826 99.5547 102.072 99.384C102.317 99.2133 102.509 99.0267 102.648 98.824C102.797 98.6107 102.872 98.44 102.872 98.312V96.472C102.872 96.12 102.792 95.8213 102.632 95.576C102.472 95.3307 102.269 95.144 102.024 95.016C101.778 94.8773 101.522 94.808 101.256 94.808C100.957 94.808 100.68 94.888 100.424 95.048C100.178 95.208 99.9809 95.416 99.8316 95.672C99.6929 95.928 99.6236 96.1947 99.6236 96.472V97.944C99.6236 98.2213 99.6929 98.4933 99.8316 98.76C99.9809 99.0267 100.178 99.24 100.424 99.4C100.669 99.56 100.941 99.64 101.24 99.64ZM107.141 101C106.907 101 106.709 100.941 106.549 100.824C106.4 100.707 106.325 100.579 106.325 100.44V93.96C106.325 93.8 106.4 93.672 106.549 93.576C106.709 93.4693 106.907 93.416 107.141 93.416C107.355 93.416 107.536 93.4693 107.685 93.576C107.835 93.672 107.909 93.8 107.909 93.96V94.664C108.027 94.44 108.181 94.2267 108.373 94.024C108.576 93.8213 108.811 93.656 109.077 93.528C109.344 93.3893 109.632 93.32 109.941 93.32H110.453C110.624 93.32 110.773 93.3947 110.901 93.544C111.029 93.6827 111.093 93.8533 111.093 94.056C111.093 94.2587 111.029 94.4347 110.901 94.584C110.773 94.7333 110.624 94.808 110.453 94.808H109.941C109.621 94.808 109.312 94.904 109.013 95.096C108.715 95.288 108.469 95.56 108.277 95.912C108.096 96.2533 108.005 96.6693 108.005 97.16V100.44C108.005 100.579 107.92 100.707 107.749 100.824C107.589 100.941 107.387 101 107.141 101ZM113.505 101.128C112.918 101.128 112.417 100.957 112.001 100.616C111.585 100.264 111.377 99.7307 111.377 99.016C111.377 98.408 111.537 97.9387 111.857 97.608C112.177 97.2773 112.614 97.048 113.169 96.92C113.734 96.792 114.385 96.728 115.121 96.728H115.825V96.44C115.825 96.1627 115.771 95.896 115.665 95.64C115.569 95.3733 115.403 95.1547 115.169 94.984C114.945 94.8027 114.635 94.712 114.241 94.712C113.846 94.712 113.542 94.7493 113.329 94.824C113.115 94.8987 112.945 94.9787 112.817 95.064C112.689 95.1493 112.571 95.192 112.465 95.192C112.273 95.192 112.123 95.1013 112.017 94.92C111.91 94.728 111.857 94.536 111.857 94.344C111.857 94.152 111.979 93.9813 112.225 93.832C112.481 93.672 112.795 93.5493 113.169 93.464C113.542 93.368 113.91 93.32 114.273 93.32C115.062 93.32 115.691 93.4693 116.161 93.768C116.63 94.056 116.971 94.4347 117.185 94.904C117.398 95.3733 117.505 95.88 117.505 96.424V100.44C117.505 100.589 117.425 100.723 117.265 100.84C117.115 100.947 116.923 101 116.689 101C116.475 101 116.294 100.947 116.145 100.84C115.995 100.723 115.921 100.589 115.921 100.44V99.88C115.643 100.2 115.307 100.488 114.913 100.744C114.518 101 114.049 101.128 113.505 101.128ZM114.113 99.848C114.379 99.848 114.641 99.768 114.897 99.608C115.163 99.448 115.382 99.2453 115.553 99C115.734 98.7547 115.825 98.504 115.825 98.248V97.656H115.425C115.019 97.656 114.635 97.6827 114.273 97.736C113.91 97.7787 113.617 97.8853 113.393 98.056C113.179 98.216 113.073 98.4667 113.073 98.808C113.073 99.1707 113.169 99.4373 113.361 99.608C113.563 99.768 113.814 99.848 114.113 99.848ZM122.064 104.6C121.446 104.6 120.875 104.509 120.352 104.328C119.83 104.157 119.414 103.907 119.104 103.576C118.795 103.245 118.64 102.851 118.64 102.392C118.64 101.965 118.763 101.608 119.008 101.32C119.254 101.043 119.542 100.829 119.872 100.68C119.659 100.584 119.483 100.456 119.344 100.296C119.206 100.136 119.136 99.912 119.136 99.624C119.136 99.3253 119.211 99.0853 119.36 98.904C119.51 98.7227 119.702 98.5573 119.936 98.408C119.638 98.1733 119.403 97.8853 119.232 97.544C119.072 97.192 118.992 96.808 118.992 96.392V95.944C118.992 95.432 119.115 94.9787 119.36 94.584C119.606 94.1893 119.952 93.88 120.4 93.656C120.859 93.432 121.382 93.32 121.968 93.32C122.331 93.32 122.667 93.368 122.976 93.464C123.296 93.56 123.579 93.6933 123.824 93.864C123.995 93.4693 124.166 93.192 124.336 93.032C124.518 92.872 124.688 92.792 124.848 92.792C125.072 92.792 125.243 92.856 125.36 92.984C125.478 93.112 125.536 93.24 125.536 93.368C125.536 93.4533 125.51 93.5333 125.456 93.608C125.414 93.672 125.35 93.7253 125.264 93.768C125.158 93.8213 125.03 93.896 124.88 93.992C124.742 94.0773 124.603 94.216 124.464 94.408C124.646 94.6107 124.779 94.8453 124.864 95.112C124.95 95.3787 124.992 95.656 124.992 95.944V96.392C124.992 96.8933 124.864 97.3467 124.608 97.752C124.352 98.1573 123.995 98.4773 123.536 98.712C123.078 98.936 122.555 99.048 121.968 99.048C121.552 99.048 121.184 98.984 120.864 98.856C120.779 98.9093 120.704 98.9733 120.64 99.048C120.587 99.112 120.56 99.1973 120.56 99.304C120.56 99.496 120.678 99.6347 120.912 99.72C121.147 99.8053 121.446 99.8693 121.808 99.912C122.182 99.9547 122.576 100.008 122.992 100.072C123.408 100.136 123.798 100.243 124.16 100.392C124.534 100.531 124.838 100.739 125.072 101.016C125.307 101.304 125.424 101.693 125.424 102.184C125.424 102.739 125.27 103.192 124.96 103.544C124.651 103.907 124.24 104.173 123.728 104.344C123.227 104.515 122.672 104.6 122.064 104.6ZM122.032 103.48C122.555 103.48 122.976 103.363 123.296 103.128C123.627 102.904 123.792 102.605 123.792 102.232C123.792 101.965 123.712 101.757 123.552 101.608C123.392 101.459 123.184 101.347 122.928 101.272C122.672 101.197 122.4 101.144 122.112 101.112C121.835 101.08 121.568 101.048 121.312 101.016C121.014 101.123 120.758 101.272 120.544 101.464C120.342 101.667 120.24 101.917 120.24 102.216C120.24 102.611 120.406 102.92 120.736 103.144C121.078 103.368 121.51 103.48 122.032 103.48ZM122 97.976C122.427 97.976 122.758 97.8267 122.992 97.528C123.238 97.2293 123.36 96.8507 123.36 96.392V95.944C123.36 95.5067 123.238 95.1387 122.992 94.84C122.758 94.5413 122.422 94.392 121.984 94.392C121.547 94.392 121.211 94.5413 120.976 94.84C120.742 95.1387 120.624 95.5067 120.624 95.944V96.376C120.624 96.824 120.742 97.2027 120.976 97.512C121.211 97.8213 121.552 97.976 122 97.976ZM132.609 101C131.702 101 131.009 100.803 130.529 100.408C130.049 100.003 129.809 99.368 129.809 98.504V90.488C129.809 90.328 129.894 90.2 130.065 90.104C130.246 89.9973 130.438 89.944 130.641 89.944C130.844 89.944 131.036 89.9973 131.217 90.104C131.398 90.2 131.489 90.328 131.489 90.488V93.416H133.441C133.59 93.416 133.702 93.48 133.777 93.608C133.862 93.736 133.905 93.88 133.905 94.04C133.905 94.2 133.862 94.344 133.777 94.472C133.702 94.6 133.59 94.664 133.441 94.664H131.489V98.504C131.489 98.888 131.569 99.16 131.729 99.32C131.9 99.48 132.193 99.56 132.609 99.56H133.153C133.398 99.56 133.58 99.6347 133.697 99.784C133.825 99.9227 133.889 100.088 133.889 100.28C133.889 100.461 133.825 100.627 133.697 100.776C133.58 100.925 133.398 101 133.153 101H132.609ZM135.908 101C135.662 101 135.46 100.941 135.3 100.824C135.15 100.707 135.076 100.579 135.076 100.44V89.448C135.076 89.288 135.15 89.16 135.3 89.064C135.46 88.9573 135.662 88.904 135.908 88.904C136.142 88.904 136.34 88.9573 136.5 89.064C136.67 89.16 136.756 89.288 136.756 89.448V94.536C136.916 94.2267 137.166 93.9493 137.508 93.704C137.86 93.448 138.292 93.32 138.804 93.32C139.305 93.32 139.764 93.464 140.18 93.752C140.606 94.0293 140.948 94.408 141.204 94.888C141.46 95.3573 141.588 95.8853 141.588 96.472V100.44C141.588 100.621 141.497 100.76 141.316 100.856C141.145 100.952 140.953 101 140.74 101C140.548 101 140.361 100.952 140.18 100.856C139.998 100.76 139.908 100.621 139.908 100.44V96.472C139.908 96.1947 139.833 95.928 139.684 95.672C139.534 95.416 139.337 95.208 139.092 95.048C138.857 94.888 138.59 94.808 138.292 94.808C138.036 94.808 137.79 94.8773 137.556 95.016C137.321 95.144 137.129 95.3307 136.98 95.576C136.83 95.8213 136.756 96.12 136.756 96.472V100.44C136.756 100.579 136.67 100.707 136.5 100.824C136.34 100.941 136.142 101 135.908 101ZM146.687 101.128C145.961 101.128 145.321 100.995 144.767 100.728C144.212 100.461 143.775 100.093 143.455 99.624C143.135 99.144 142.975 98.584 142.975 97.944V96.424C142.975 95.8587 143.124 95.3413 143.423 94.872C143.732 94.4027 144.137 94.0293 144.639 93.752C145.14 93.464 145.695 93.32 146.303 93.32C146.879 93.32 147.407 93.448 147.887 93.704C148.367 93.9493 148.751 94.296 149.039 94.744C149.337 95.192 149.487 95.704 149.487 96.28C149.487 96.728 149.417 97.048 149.279 97.24C149.14 97.432 148.959 97.5493 148.735 97.592C148.511 97.6347 148.276 97.656 148.031 97.656H144.655V98.024C144.655 98.5573 144.847 98.984 145.231 99.304C145.625 99.6133 146.127 99.768 146.735 99.768C147.108 99.768 147.412 99.7147 147.647 99.608C147.881 99.5013 148.079 99.4 148.239 99.304C148.399 99.208 148.548 99.16 148.687 99.16C148.825 99.16 148.943 99.2027 149.039 99.288C149.135 99.3733 149.209 99.4747 149.263 99.592C149.316 99.7093 149.343 99.816 149.343 99.912C149.343 100.072 149.231 100.248 149.007 100.44C148.793 100.632 148.489 100.797 148.095 100.936C147.7 101.064 147.231 101.128 146.687 101.128ZM144.655 96.616H147.311C147.545 96.616 147.7 96.584 147.775 96.52C147.86 96.456 147.903 96.328 147.903 96.136C147.903 95.8587 147.833 95.6027 147.695 95.368C147.556 95.1227 147.364 94.936 147.119 94.808C146.873 94.6693 146.596 94.6 146.287 94.6C145.988 94.6 145.716 94.664 145.471 94.792C145.225 94.92 145.028 95.096 144.879 95.32C144.729 95.544 144.655 95.8053 144.655 96.104V96.616ZM157.868 101.128C157.366 101.128 156.913 101.005 156.508 100.76C156.113 100.504 155.83 100.211 155.66 99.88V100.44C155.66 100.579 155.585 100.707 155.436 100.824C155.286 100.941 155.105 101 154.892 101C154.657 101 154.46 100.941 154.3 100.824C154.15 100.707 154.076 100.579 154.076 100.44V89.448C154.076 89.288 154.15 89.16 154.3 89.064C154.46 88.9573 154.657 88.904 154.892 88.904C155.137 88.904 155.34 88.9573 155.5 89.064C155.67 89.16 155.756 89.288 155.756 89.448V94.536C155.926 94.2267 156.188 93.9493 156.54 93.704C156.892 93.448 157.318 93.32 157.82 93.32C158.342 93.32 158.817 93.464 159.244 93.752C159.681 94.0293 160.028 94.408 160.284 94.888C160.55 95.3573 160.684 95.8853 160.684 96.472V97.944C160.684 98.4987 160.55 99.0213 160.284 99.512C160.028 99.992 159.686 100.381 159.26 100.68C158.833 100.979 158.369 101.128 157.868 101.128ZM157.388 99.64C157.676 99.64 157.942 99.56 158.188 99.4C158.433 99.24 158.63 99.0267 158.78 98.76C158.929 98.4933 159.004 98.2213 159.004 97.944V96.472C159.004 96.1947 158.929 95.928 158.78 95.672C158.63 95.416 158.433 95.208 158.188 95.048C157.942 94.888 157.67 94.808 157.372 94.808C157.105 94.808 156.849 94.8773 156.604 95.016C156.358 95.144 156.156 95.3307 155.996 95.576C155.836 95.8213 155.756 96.12 155.756 96.472V98.312C155.756 98.44 155.825 98.6107 155.964 98.824C156.113 99.0267 156.31 99.2133 156.556 99.384C156.801 99.5547 157.078 99.64 157.388 99.64ZM162.985 91.512C162.719 91.512 162.489 91.4213 162.297 91.24C162.105 91.0587 162.009 90.856 162.009 90.632C162.009 90.3867 162.105 90.1787 162.297 90.008C162.489 89.8373 162.719 89.752 162.985 89.752C163.252 89.752 163.476 89.8373 163.657 90.008C163.849 90.1787 163.945 90.3867 163.945 90.632C163.945 90.856 163.849 91.0587 163.657 91.24C163.476 91.4213 163.252 91.512 162.985 91.512ZM162.985 101C162.74 101 162.537 100.941 162.377 100.824C162.228 100.707 162.153 100.579 162.153 100.44V93.96C162.153 93.8 162.228 93.672 162.377 93.576C162.537 93.4693 162.74 93.416 162.985 93.416C163.22 93.416 163.417 93.4693 163.577 93.576C163.748 93.672 163.833 93.8 163.833 93.96V100.44C163.833 100.579 163.748 100.707 163.577 100.824C163.417 100.941 163.22 101 162.985 101ZM166.407 101C166.162 101 165.959 100.941 165.799 100.824C165.65 100.707 165.575 100.579 165.575 100.44V93.96C165.575 93.8 165.65 93.672 165.799 93.576C165.959 93.4693 166.162 93.416 166.407 93.416C166.61 93.416 166.786 93.4693 166.935 93.576C167.085 93.672 167.159 93.8 167.159 93.96V94.536C167.319 94.2267 167.581 93.9493 167.943 93.704C168.317 93.448 168.77 93.32 169.303 93.32C169.805 93.32 170.263 93.464 170.679 93.752C171.106 94.0293 171.447 94.408 171.703 94.888C171.959 95.3573 172.087 95.8853 172.087 96.472V100.44C172.087 100.621 171.997 100.76 171.815 100.856C171.645 100.952 171.453 101 171.239 101C171.047 101 170.861 100.952 170.679 100.856C170.498 100.76 170.407 100.621 170.407 100.44V96.472C170.407 96.1947 170.333 95.928 170.183 95.672C170.045 95.416 169.853 95.208 169.607 95.048C169.362 94.888 169.09 94.808 168.791 94.808C168.535 94.808 168.29 94.8773 168.055 95.016C167.821 95.144 167.629 95.3307 167.479 95.576C167.33 95.8213 167.255 96.12 167.255 96.472V100.44C167.255 100.579 167.17 100.707 166.999 100.824C166.839 100.941 166.642 101 166.407 101ZM176.083 101.128C175.56 101.128 175.091 101.064 174.675 100.936C174.259 100.808 173.928 100.648 173.683 100.456C173.448 100.253 173.331 100.051 173.331 99.848C173.331 99.752 173.352 99.6453 173.395 99.528C173.448 99.4107 173.517 99.3093 173.603 99.224C173.699 99.1387 173.8 99.096 173.907 99.096C174.045 99.096 174.189 99.16 174.339 99.288C174.499 99.4053 174.707 99.528 174.963 99.656C175.219 99.7733 175.576 99.832 176.035 99.832C176.568 99.832 176.925 99.7413 177.107 99.56C177.299 99.3787 177.395 99.1813 177.395 98.968C177.395 98.6907 177.299 98.4773 177.107 98.328C176.925 98.168 176.685 98.04 176.387 97.944C176.099 97.848 175.789 97.7573 175.459 97.672C175.128 97.576 174.813 97.4533 174.515 97.304C174.227 97.1547 173.987 96.9467 173.795 96.68C173.613 96.4133 173.523 96.0613 173.523 95.624C173.523 95.2613 173.613 94.904 173.795 94.552C173.976 94.1893 174.264 93.896 174.659 93.672C175.064 93.4373 175.603 93.32 176.275 93.32C176.68 93.32 177.064 93.3627 177.427 93.448C177.789 93.5333 178.088 93.6507 178.323 93.8C178.557 93.9387 178.675 94.0933 178.675 94.264C178.675 94.3387 178.648 94.4453 178.595 94.584C178.541 94.712 178.467 94.8293 178.371 94.936C178.285 95.032 178.173 95.08 178.035 95.08C177.928 95.08 177.795 95.0427 177.635 94.968C177.475 94.8827 177.288 94.8027 177.075 94.728C176.861 94.6533 176.6 94.616 176.291 94.616C175.981 94.616 175.731 94.6693 175.539 94.776C175.357 94.872 175.224 94.9893 175.139 95.128C175.053 95.2667 175.011 95.4053 175.011 95.544C175.011 95.7787 175.101 95.96 175.283 96.088C175.464 96.216 175.704 96.3227 176.003 96.408C176.301 96.4933 176.616 96.584 176.947 96.68C177.277 96.7653 177.587 96.8933 177.875 97.064C178.173 97.2347 178.413 97.464 178.595 97.752C178.787 98.04 178.883 98.424 178.883 98.904C178.883 99.576 178.637 100.115 178.147 100.52C177.667 100.925 176.979 101.128 176.083 101.128ZM186.234 101C185.327 101 184.634 100.803 184.154 100.408C183.674 100.003 183.434 99.368 183.434 98.504V90.488C183.434 90.328 183.519 90.2 183.69 90.104C183.871 89.9973 184.063 89.944 184.266 89.944C184.469 89.944 184.661 89.9973 184.842 90.104C185.023 90.2 185.114 90.328 185.114 90.488V93.416H187.066C187.215 93.416 187.327 93.48 187.402 93.608C187.487 93.736 187.53 93.88 187.53 94.04C187.53 94.2 187.487 94.344 187.402 94.472C187.327 94.6 187.215 94.664 187.066 94.664H185.114V98.504C185.114 98.888 185.194 99.16 185.354 99.32C185.525 99.48 185.818 99.56 186.234 99.56H186.778C187.023 99.56 187.205 99.6347 187.322 99.784C187.45 99.9227 187.514 100.088 187.514 100.28C187.514 100.461 187.45 100.627 187.322 100.776C187.205 100.925 187.023 101 186.778 101H186.234ZM191.567 101.128C190.991 101.128 190.453 100.979 189.951 100.68C189.45 100.381 189.045 99.992 188.735 99.512C188.437 99.0213 188.287 98.4987 188.287 97.944V96.472C188.287 95.9067 188.431 95.384 188.719 94.904C189.018 94.424 189.418 94.04 189.919 93.752C190.431 93.464 190.986 93.32 191.583 93.32C192.181 93.32 192.73 93.464 193.231 93.752C193.733 94.0293 194.133 94.408 194.431 94.888C194.741 95.3573 194.895 95.8853 194.895 96.472V97.944C194.895 98.488 194.741 99.0053 194.431 99.496C194.133 99.9867 193.727 100.381 193.215 100.68C192.714 100.979 192.165 101.128 191.567 101.128ZM191.583 99.64C191.882 99.64 192.154 99.56 192.399 99.4C192.645 99.24 192.842 99.032 192.991 98.776C193.141 98.5093 193.215 98.232 193.215 97.944V96.472C193.215 96.1947 193.141 95.928 192.991 95.672C192.842 95.416 192.645 95.208 192.399 95.048C192.154 94.888 191.882 94.808 191.583 94.808C191.274 94.808 190.997 94.888 190.751 95.048C190.517 95.208 190.325 95.416 190.175 95.672C190.037 95.928 189.967 96.1947 189.967 96.472V97.944C189.967 98.232 190.037 98.5093 190.175 98.776C190.325 99.032 190.522 99.24 190.767 99.4C191.013 99.56 191.285 99.64 191.583 99.64ZM202.632 101.128C201.864 101.128 201.229 100.989 200.728 100.712C200.237 100.435 199.874 100.056 199.64 99.576C199.405 99.096 199.288 98.552 199.288 97.944V96.504C199.288 95.9067 199.405 95.368 199.64 94.888C199.874 94.3973 200.237 94.0133 200.728 93.736C201.218 93.4587 201.842 93.32 202.6 93.32C203.09 93.32 203.517 93.3787 203.88 93.496C204.253 93.6133 204.541 93.7627 204.744 93.944C204.957 94.1147 205.064 94.296 205.064 94.488C205.064 94.584 205.032 94.7013 204.968 94.84C204.914 94.968 204.834 95.08 204.728 95.176C204.632 95.2613 204.514 95.304 204.376 95.304C204.269 95.304 204.152 95.2613 204.024 95.176C203.906 95.0907 203.746 95.0107 203.544 94.936C203.341 94.8507 203.069 94.808 202.728 94.808C202.13 94.808 201.688 94.9573 201.4 95.256C201.112 95.5547 200.968 95.9707 200.968 96.504V97.944C200.968 98.4773 201.112 98.8933 201.4 99.192C201.688 99.4907 202.136 99.64 202.744 99.64C203.096 99.64 203.373 99.5973 203.576 99.512C203.778 99.416 203.938 99.3253 204.056 99.24C204.184 99.1547 204.306 99.112 204.424 99.112C204.573 99.112 204.701 99.1547 204.808 99.24C204.925 99.3253 205.01 99.432 205.064 99.56C205.128 99.688 205.16 99.8053 205.16 99.912C205.16 100.093 205.048 100.28 204.824 100.472C204.61 100.664 204.312 100.824 203.928 100.952C203.554 101.069 203.122 101.128 202.632 101.128ZM208.005 101.128C207.418 101.128 206.917 100.957 206.501 100.616C206.085 100.264 205.877 99.7307 205.877 99.016C205.877 98.408 206.037 97.9387 206.357 97.608C206.677 97.2773 207.114 97.048 207.669 96.92C208.234 96.792 208.885 96.728 209.621 96.728H210.325V96.44C210.325 96.1627 210.271 95.896 210.165 95.64C210.069 95.3733 209.903 95.1547 209.669 94.984C209.445 94.8027 209.135 94.712 208.741 94.712C208.346 94.712 208.042 94.7493 207.829 94.824C207.615 94.8987 207.445 94.9787 207.317 95.064C207.189 95.1493 207.071 95.192 206.965 95.192C206.773 95.192 206.623 95.1013 206.517 94.92C206.41 94.728 206.357 94.536 206.357 94.344C206.357 94.152 206.479 93.9813 206.725 93.832C206.981 93.672 207.295 93.5493 207.669 93.464C208.042 93.368 208.41 93.32 208.773 93.32C209.562 93.32 210.191 93.4693 210.661 93.768C211.13 94.056 211.471 94.4347 211.685 94.904C211.898 95.3733 212.005 95.88 212.005 96.424V100.44C212.005 100.589 211.925 100.723 211.765 100.84C211.615 100.947 211.423 101 211.189 101C210.975 101 210.794 100.947 210.645 100.84C210.495 100.723 210.421 100.589 210.421 100.44V99.88C210.143 100.2 209.807 100.488 209.413 100.744C209.018 101 208.549 101.128 208.005 101.128ZM208.613 99.848C208.879 99.848 209.141 99.768 209.397 99.608C209.663 99.448 209.882 99.2453 210.053 99C210.234 98.7547 210.325 98.504 210.325 98.248V97.656H209.925C209.519 97.656 209.135 97.6827 208.773 97.736C208.41 97.7787 208.117 97.8853 207.893 98.056C207.679 98.216 207.573 98.4667 207.573 98.808C207.573 99.1707 207.669 99.4373 207.861 99.608C208.063 99.768 208.314 99.848 208.613 99.848ZM216.468 101C215.562 101 214.868 100.803 214.388 100.408C213.908 100.003 213.668 99.368 213.668 98.504V90.488C213.668 90.328 213.754 90.2 213.924 90.104C214.106 89.9973 214.298 89.944 214.5 89.944C214.703 89.944 214.895 89.9973 215.076 90.104C215.258 90.2 215.348 90.328 215.348 90.488V93.416H217.3C217.45 93.416 217.562 93.48 217.636 93.608C217.722 93.736 217.764 93.88 217.764 94.04C217.764 94.2 217.722 94.344 217.636 94.472C217.562 94.6 217.45 94.664 217.3 94.664H215.348V98.504C215.348 98.888 215.428 99.16 215.588 99.32C215.759 99.48 216.052 99.56 216.468 99.56H217.012C217.258 99.56 217.439 99.6347 217.556 99.784C217.684 99.9227 217.748 100.088 217.748 100.28C217.748 100.461 217.684 100.627 217.556 100.776C217.439 100.925 217.258 101 217.012 101H216.468ZM221.882 101.128C221.114 101.128 220.479 100.989 219.978 100.712C219.487 100.435 219.124 100.056 218.89 99.576C218.655 99.096 218.538 98.552 218.538 97.944V96.504C218.538 95.9067 218.655 95.368 218.89 94.888C219.124 94.3973 219.487 94.0133 219.978 93.736C220.468 93.4587 221.092 93.32 221.85 93.32C222.34 93.32 222.767 93.3787 223.13 93.496C223.503 93.6133 223.791 93.7627 223.994 93.944C224.207 94.1147 224.314 94.296 224.314 94.488C224.314 94.584 224.282 94.7013 224.218 94.84C224.164 94.968 224.084 95.08 223.978 95.176C223.882 95.2613 223.764 95.304 223.626 95.304C223.519 95.304 223.402 95.2613 223.274 95.176C223.156 95.0907 222.996 95.0107 222.794 94.936C222.591 94.8507 222.319 94.808 221.978 94.808C221.38 94.808 220.938 94.9573 220.65 95.256C220.362 95.5547 220.218 95.9707 220.218 96.504V97.944C220.218 98.4773 220.362 98.8933 220.65 99.192C220.938 99.4907 221.386 99.64 221.994 99.64C222.346 99.64 222.623 99.5973 222.826 99.512C223.028 99.416 223.188 99.3253 223.306 99.24C223.434 99.1547 223.556 99.112 223.674 99.112C223.823 99.112 223.951 99.1547 224.058 99.24C224.175 99.3253 224.26 99.432 224.314 99.56C224.378 99.688 224.41 99.8053 224.41 99.912C224.41 100.093 224.298 100.28 224.074 100.472C223.86 100.664 223.562 100.824 223.178 100.952C222.804 101.069 222.372 101.128 221.882 101.128ZM226.455 101C226.209 101 226.007 100.941 225.847 100.824C225.697 100.707 225.623 100.579 225.623 100.44V89.448C225.623 89.288 225.697 89.16 225.847 89.064C226.007 88.9573 226.209 88.904 226.455 88.904C226.689 88.904 226.887 88.9573 227.047 89.064C227.217 89.16 227.303 89.288 227.303 89.448V94.536C227.463 94.2267 227.713 93.9493 228.055 93.704C228.407 93.448 228.839 93.32 229.351 93.32C229.852 93.32 230.311 93.464 230.727 93.752C231.153 94.0293 231.495 94.408 231.751 94.888C232.007 95.3573 232.135 95.8853 232.135 96.472V100.44C232.135 100.621 232.044 100.76 231.863 100.856C231.692 100.952 231.5 101 231.287 101C231.095 101 230.908 100.952 230.727 100.856C230.545 100.76 230.455 100.621 230.455 100.44V96.472C230.455 96.1947 230.38 95.928 230.231 95.672C230.081 95.416 229.884 95.208 229.639 95.048C229.404 94.888 229.137 94.808 228.839 94.808C228.583 94.808 228.337 94.8773 228.103 95.016C227.868 95.144 227.676 95.3307 227.527 95.576C227.377 95.8213 227.303 96.12 227.303 96.472V100.44C227.303 100.579 227.217 100.707 227.047 100.824C226.887 100.941 226.689 101 226.455 101ZM86.398 121C85.4913 121 84.798 120.803 84.318 120.408C83.838 120.003 83.598 119.368 83.598 118.504V110.488C83.598 110.328 83.6833 110.2 83.854 110.104C84.0353 109.997 84.2273 109.944 84.43 109.944C84.6327 109.944 84.8247 109.997 85.006 110.104C85.1873 110.2 85.278 110.328 85.278 110.488V113.416H87.23C87.3793 113.416 87.4913 113.48 87.566 113.608C87.6513 113.736 87.694 113.88 87.694 114.04C87.694 114.2 87.6513 114.344 87.566 114.472C87.4913 114.6 87.3793 114.664 87.23 114.664H85.278V118.504C85.278 118.888 85.358 119.16 85.518 119.32C85.6887 119.48 85.982 119.56 86.398 119.56H86.942C87.1873 119.56 87.3687 119.635 87.486 119.784C87.614 119.923 87.678 120.088 87.678 120.28C87.678 120.461 87.614 120.627 87.486 120.776C87.3687 120.925 87.1873 121 86.942 121H86.398ZM89.6968 121C89.4514 121 89.2488 120.941 89.0888 120.824C88.9394 120.707 88.8648 120.579 88.8648 120.44V109.448C88.8648 109.288 88.9394 109.16 89.0888 109.064C89.2488 108.957 89.4514 108.904 89.6968 108.904C89.9314 108.904 90.1288 108.957 90.2888 109.064C90.4594 109.16 90.5448 109.288 90.5448 109.448V114.536C90.7048 114.227 90.9554 113.949 91.2968 113.704C91.6488 113.448 92.0808 113.32 92.5928 113.32C93.0941 113.32 93.5528 113.464 93.9688 113.752C94.3954 114.029 94.7368 114.408 94.9928 114.888C95.2488 115.357 95.3768 115.885 95.3768 116.472V120.44C95.3768 120.621 95.2861 120.76 95.1048 120.856C94.9341 120.952 94.7421 121 94.5288 121C94.3368 121 94.1501 120.952 93.9688 120.856C93.7874 120.76 93.6968 120.621 93.6968 120.44V116.472C93.6968 116.195 93.6221 115.928 93.4728 115.672C93.3234 115.416 93.1261 115.208 92.8808 115.048C92.6461 114.888 92.3794 114.808 92.0807 114.808C91.8248 114.808 91.5794 114.877 91.3448 115.016C91.1101 115.144 90.9181 115.331 90.7688 115.576C90.6194 115.821 90.5448 116.12 90.5448 116.472V120.44C90.5448 120.579 90.4594 120.707 90.2888 120.824C90.1288 120.941 89.9314 121 89.6968 121ZM100.476 121.128C99.7505 121.128 99.1105 120.995 98.5559 120.728C98.0012 120.461 97.5639 120.093 97.2439 119.624C96.9239 119.144 96.7639 118.584 96.7639 117.944V116.424C96.7639 115.859 96.9132 115.341 97.2119 114.872C97.5212 114.403 97.9265 114.029 98.4279 113.752C98.9292 113.464 99.4839 113.32 100.092 113.32C100.668 113.32 101.196 113.448 101.676 113.704C102.156 113.949 102.54 114.296 102.828 114.744C103.127 115.192 103.276 115.704 103.276 116.28C103.276 116.728 103.207 117.048 103.068 117.24C102.929 117.432 102.748 117.549 102.524 117.592C102.3 117.635 102.065 117.656 101.82 117.656H98.4439V118.024C98.4439 118.557 98.6359 118.984 99.0199 119.304C99.4145 119.613 99.9159 119.768 100.524 119.768C100.897 119.768 101.201 119.715 101.436 119.608C101.671 119.501 101.868 119.4 102.028 119.304C102.188 119.208 102.337 119.16 102.476 119.16C102.615 119.16 102.732 119.203 102.828 119.288C102.924 119.373 102.999 119.475 103.052 119.592C103.105 119.709 103.132 119.816 103.132 119.912C103.132 120.072 103.02 120.248 102.796 120.44C102.583 120.632 102.279 120.797 101.884 120.936C101.489 121.064 101.02 121.128 100.476 121.128ZM98.4439 116.616H101.1C101.335 116.616 101.489 116.584 101.564 116.52C101.649 116.456 101.692 116.328 101.692 116.136C101.692 115.859 101.623 115.603 101.484 115.368C101.345 115.123 101.153 114.936 100.908 114.808C100.663 114.669 100.385 114.6 100.076 114.6C99.7772 114.6 99.5052 114.664 99.2599 114.792C99.0145 114.92 98.8172 115.096 98.6679 115.32C98.5185 115.544 98.4439 115.805 98.4439 116.104V116.616ZM110.921 121.128C110.153 121.128 109.518 120.989 109.017 120.712C108.526 120.435 108.163 120.056 107.929 119.576C107.694 119.096 107.577 118.552 107.577 117.944V116.504C107.577 115.907 107.694 115.368 107.929 114.888C108.163 114.397 108.526 114.013 109.017 113.736C109.507 113.459 110.131 113.32 110.889 113.32C111.379 113.32 111.806 113.379 112.169 113.496C112.542 113.613 112.83 113.763 113.033 113.944C113.246 114.115 113.353 114.296 113.353 114.488C113.353 114.584 113.321 114.701 113.257 114.84C113.203 114.968 113.123 115.08 113.017 115.176C112.921 115.261 112.803 115.304 112.665 115.304C112.558 115.304 112.441 115.261 112.313 115.176C112.195 115.091 112.035 115.011 111.833 114.936C111.63 114.851 111.358 114.808 111.017 114.808C110.419 114.808 109.977 114.957 109.689 115.256C109.401 115.555 109.257 115.971 109.257 116.504V117.944C109.257 118.477 109.401 118.893 109.689 119.192C109.977 119.491 110.425 119.64 111.033 119.64C111.385 119.64 111.662 119.597 111.865 119.512C112.067 119.416 112.227 119.325 112.345 119.24C112.473 119.155 112.595 119.112 112.713 119.112C112.862 119.112 112.99 119.155 113.097 119.24C113.214 119.325 113.299 119.432 113.353 119.56C113.417 119.688 113.449 119.805 113.449 119.912C113.449 120.093 113.337 120.28 113.113 120.472C112.899 120.664 112.601 120.824 112.217 120.952C111.843 121.069 111.411 121.128 110.921 121.128ZM117.56 121.128C116.984 121.128 116.445 120.979 115.944 120.68C115.442 120.381 115.037 119.992 114.728 119.512C114.429 119.021 114.28 118.499 114.28 117.944V116.472C114.28 115.907 114.424 115.384 114.712 114.904C115.01 114.424 115.41 114.04 115.912 113.752C116.424 113.464 116.978 113.32 117.576 113.32C118.173 113.32 118.722 113.464 119.224 113.752C119.725 114.029 120.125 114.408 120.424 114.888C120.733 115.357 120.888 115.885 120.888 116.472V117.944C120.888 118.488 120.733 119.005 120.424 119.496C120.125 119.987 119.72 120.381 119.208 120.68C118.706 120.979 118.157 121.128 117.56 121.128ZM117.576 119.64C117.874 119.64 118.146 119.56 118.391 119.4C118.637 119.24 118.834 119.032 118.984 118.776C119.133 118.509 119.208 118.232 119.208 117.944V116.472C119.208 116.195 119.133 115.928 118.984 115.672C118.834 115.416 118.637 115.208 118.391 115.048C118.146 114.888 117.874 114.808 117.576 114.808C117.266 114.808 116.989 114.888 116.744 115.048C116.509 115.208 116.317 115.416 116.168 115.672C116.029 115.928 115.96 116.195 115.96 116.472V117.944C115.96 118.232 116.029 118.509 116.168 118.776C116.317 119.032 116.514 119.24 116.76 119.4C117.005 119.56 117.277 119.64 117.576 119.64ZM123.165 121C122.93 121 122.733 120.941 122.573 120.824C122.423 120.707 122.349 120.579 122.349 120.44V113.96C122.349 113.8 122.423 113.672 122.573 113.576C122.733 113.469 122.93 113.416 123.165 113.416C123.378 113.416 123.559 113.469 123.709 113.576C123.858 113.672 123.933 113.8 123.933 113.96V114.664C124.05 114.44 124.205 114.227 124.397 114.024C124.599 113.821 124.834 113.656 125.101 113.528C125.367 113.389 125.655 113.32 125.965 113.32H126.477C126.647 113.32 126.797 113.395 126.925 113.544C127.053 113.683 127.117 113.853 127.117 114.056C127.117 114.259 127.053 114.435 126.925 114.584C126.797 114.733 126.647 114.808 126.477 114.808H125.965C125.645 114.808 125.335 114.904 125.037 115.096C124.738 115.288 124.493 115.56 124.301 115.912C124.119 116.253 124.029 116.669 124.029 117.16V120.44C124.029 120.579 123.943 120.707 123.773 120.824C123.613 120.941 123.41 121 123.165 121ZM128.899 121C128.664 121 128.467 120.941 128.307 120.824C128.158 120.707 128.083 120.579 128.083 120.44V113.96C128.083 113.8 128.158 113.672 128.307 113.576C128.467 113.469 128.664 113.416 128.899 113.416C129.112 113.416 129.294 113.469 129.443 113.576C129.592 113.672 129.667 113.8 129.667 113.96V114.664C129.784 114.44 129.939 114.227 130.131 114.024C130.334 113.821 130.568 113.656 130.835 113.528C131.102 113.389 131.39 113.32 131.699 113.32H132.211C132.382 113.32 132.531 113.395 132.659 113.544C132.787 113.683 132.851 113.853 132.851 114.056C132.851 114.259 132.787 114.435 132.659 114.584C132.531 114.733 132.382 114.808 132.211 114.808H131.699C131.379 114.808 131.07 114.904 130.771 115.096C130.472 115.288 130.227 115.56 130.035 115.912C129.854 116.253 129.763 116.669 129.763 117.16V120.44C129.763 120.579 129.678 120.707 129.507 120.824C129.347 120.941 129.144 121 128.899 121ZM136.992 121.128C136.266 121.128 135.626 120.995 135.072 120.728C134.517 120.461 134.08 120.093 133.76 119.624C133.44 119.144 133.28 118.584 133.28 117.944V116.424C133.28 115.859 133.429 115.341 133.728 114.872C134.037 114.403 134.442 114.029 134.944 113.752C135.445 113.464 136 113.32 136.608 113.32C137.184 113.32 137.712 113.448 138.192 113.704C138.672 113.949 139.056 114.296 139.344 114.744C139.642 115.192 139.792 115.704 139.792 116.28C139.792 116.728 139.722 117.048 139.584 117.24C139.445 117.432 139.264 117.549 139.04 117.592C138.816 117.635 138.581 117.656 138.336 117.656H134.96V118.024C134.96 118.557 135.152 118.984 135.536 119.304C135.93 119.613 136.432 119.768 137.04 119.768C137.413 119.768 137.717 119.715 137.952 119.608C138.186 119.501 138.384 119.4 138.544 119.304C138.704 119.208 138.853 119.16 138.992 119.16C139.13 119.16 139.248 119.203 139.344 119.288C139.44 119.373 139.514 119.475 139.568 119.592C139.621 119.709 139.648 119.816 139.648 119.912C139.648 120.072 139.536 120.248 139.312 120.44C139.098 120.632 138.794 120.797 138.4 120.936C138.005 121.064 137.536 121.128 136.992 121.128ZM134.96 116.616H137.616C137.85 116.616 138.005 116.584 138.08 116.52C138.165 116.456 138.208 116.328 138.208 116.136C138.208 115.859 138.138 115.603 138 115.368C137.861 115.123 137.669 114.936 137.424 114.808C137.178 114.669 136.901 114.6 136.592 114.6C136.293 114.6 136.021 114.664 135.776 114.792C135.53 114.92 135.333 115.096 135.184 115.32C135.034 115.544 134.96 115.805 134.96 116.104V116.616ZM144.233 121.128C143.465 121.128 142.831 120.989 142.329 120.712C141.839 120.435 141.476 120.056 141.241 119.576C141.007 119.096 140.889 118.552 140.889 117.944V116.504C140.889 115.907 141.007 115.368 141.241 114.888C141.476 114.397 141.839 114.013 142.329 113.736C142.82 113.459 143.444 113.32 144.201 113.32C144.692 113.32 145.119 113.379 145.481 113.496C145.855 113.613 146.143 113.763 146.345 113.944C146.559 114.115 146.665 114.296 146.665 114.488C146.665 114.584 146.633 114.701 146.569 114.84C146.516 114.968 146.436 115.08 146.329 115.176C146.233 115.261 146.116 115.304 145.977 115.304C145.871 115.304 145.753 115.261 145.625 115.176C145.508 115.091 145.348 115.011 145.145 114.936C144.943 114.851 144.671 114.808 144.329 114.808C143.732 114.808 143.289 114.957 143.001 115.256C142.713 115.555 142.569 115.971 142.569 116.504V117.944C142.569 118.477 142.713 118.893 143.001 119.192C143.289 119.491 143.737 119.64 144.345 119.64C144.697 119.64 144.975 119.597 145.177 119.512C145.38 119.416 145.54 119.325 145.657 119.24C145.785 119.155 145.908 119.112 146.025 119.112C146.175 119.112 146.303 119.155 146.409 119.24C146.527 119.325 146.612 119.432 146.665 119.56C146.729 119.688 146.761 119.805 146.761 119.912C146.761 120.093 146.649 120.28 146.425 120.472C146.212 120.664 145.913 120.824 145.529 120.952C145.156 121.069 144.724 121.128 144.233 121.128ZM150.726 121C149.819 121 149.126 120.803 148.646 120.408C148.166 120.003 147.926 119.368 147.926 118.504V110.488C147.926 110.328 148.011 110.2 148.182 110.104C148.363 109.997 148.555 109.944 148.758 109.944C148.961 109.944 149.153 109.997 149.334 110.104C149.515 110.2 149.606 110.328 149.606 110.488V113.416H151.558C151.707 113.416 151.819 113.48 151.894 113.608C151.979 113.736 152.022 113.88 152.022 114.04C152.022 114.2 151.979 114.344 151.894 114.472C151.819 114.6 151.707 114.664 151.558 114.664H149.606V118.504C149.606 118.888 149.686 119.16 149.846 119.32C150.017 119.48 150.31 119.56 150.726 119.56H151.27C151.515 119.56 151.697 119.635 151.814 119.784C151.942 119.923 152.006 120.088 152.006 120.28C152.006 120.461 151.942 120.627 151.814 120.776C151.697 120.925 151.515 121 151.27 121H150.726ZM157.212 111.512C156.945 111.512 156.716 111.421 156.524 111.24C156.332 111.059 156.236 110.856 156.236 110.632C156.236 110.387 156.332 110.179 156.524 110.008C156.716 109.837 156.945 109.752 157.212 109.752C157.479 109.752 157.703 109.837 157.884 110.008C158.076 110.179 158.172 110.387 158.172 110.632C158.172 110.856 158.076 111.059 157.884 111.24C157.703 111.421 157.479 111.512 157.212 111.512ZM157.212 121C156.967 121 156.764 120.941 156.604 120.824C156.455 120.707 156.38 120.579 156.38 120.44V113.96C156.38 113.8 156.455 113.672 156.604 113.576C156.764 113.469 156.967 113.416 157.212 113.416C157.447 113.416 157.644 113.469 157.804 113.576C157.975 113.672 158.06 113.8 158.06 113.96V120.44C158.06 120.579 157.975 120.707 157.804 120.824C157.644 120.941 157.447 121 157.212 121ZM162.57 121C161.663 121 160.97 120.803 160.49 120.408C160.01 120.003 159.77 119.368 159.77 118.504V110.488C159.77 110.328 159.855 110.2 160.026 110.104C160.207 109.997 160.399 109.944 160.602 109.944C160.805 109.944 160.997 109.997 161.178 110.104C161.359 110.2 161.45 110.328 161.45 110.488V113.416H163.402C163.551 113.416 163.663 113.48 163.738 113.608C163.823 113.736 163.866 113.88 163.866 114.04C163.866 114.2 163.823 114.344 163.738 114.472C163.663 114.6 163.551 114.664 163.402 114.664H161.45V118.504C161.45 118.888 161.53 119.16 161.69 119.32C161.861 119.48 162.154 119.56 162.57 119.56H163.114C163.359 119.56 163.541 119.635 163.658 119.784C163.786 119.923 163.85 120.088 163.85 120.28C163.85 120.461 163.786 120.627 163.658 120.776C163.541 120.925 163.359 121 163.114 121H162.57ZM168.335 121.128C167.61 121.128 166.97 120.995 166.415 120.728C165.861 120.461 165.423 120.093 165.103 119.624C164.783 119.144 164.623 118.584 164.623 117.944V116.424C164.623 115.859 164.773 115.341 165.071 114.872C165.381 114.403 165.786 114.029 166.287 113.752C166.789 113.464 167.343 113.32 167.951 113.32C168.527 113.32 169.055 113.448 169.535 113.704C170.015 113.949 170.399 114.296 170.687 114.744C170.986 115.192 171.135 115.704 171.135 116.28C171.135 116.728 171.066 117.048 170.927 117.24C170.789 117.432 170.607 117.549 170.383 117.592C170.159 117.635 169.925 117.656 169.679 117.656H166.303V118.024C166.303 118.557 166.495 118.984 166.879 119.304C167.274 119.613 167.775 119.768 168.383 119.768C168.757 119.768 169.061 119.715 169.295 119.608C169.53 119.501 169.727 119.4 169.887 119.304C170.047 119.208 170.197 119.16 170.335 119.16C170.474 119.16 170.591 119.203 170.687 119.288C170.783 119.373 170.858 119.475 170.911 119.592C170.965 119.709 170.991 119.816 170.991 119.912C170.991 120.072 170.879 120.248 170.655 120.44C170.442 120.632 170.138 120.797 169.743 120.936C169.349 121.064 168.879 121.128 168.335 121.128ZM166.303 116.616H168.959C169.194 116.616 169.349 116.584 169.423 116.52C169.509 116.456 169.551 116.328 169.551 116.136C169.551 115.859 169.482 115.603 169.343 115.368C169.205 115.123 169.013 114.936 168.767 114.808C168.522 114.669 168.245 114.6 167.935 114.6C167.637 114.6 167.365 114.664 167.119 114.792C166.874 114.92 166.677 115.096 166.527 115.32C166.378 115.544 166.303 115.805 166.303 116.104V116.616ZM173.337 121C173.092 121 172.889 120.941 172.729 120.824C172.58 120.707 172.505 120.579 172.505 120.44V113.96C172.505 113.8 172.58 113.672 172.729 113.576C172.889 113.469 173.092 113.416 173.337 113.416C173.54 113.416 173.716 113.469 173.865 113.576C174.014 113.672 174.089 113.8 174.089 113.96V114.536C174.27 114.227 174.537 113.949 174.889 113.704C175.241 113.448 175.684 113.32 176.217 113.32C176.697 113.32 177.118 113.469 177.481 113.768C177.854 114.067 178.132 114.451 178.313 114.92C178.59 114.376 178.948 113.976 179.385 113.72C179.822 113.453 180.27 113.32 180.729 113.32C181.209 113.32 181.657 113.443 182.073 113.688C182.5 113.933 182.846 114.291 183.113 114.76C183.38 115.229 183.513 115.8 183.513 116.472V120.44C183.513 120.579 183.428 120.707 183.257 120.824C183.097 120.941 182.9 121 182.665 121C182.441 121 182.244 120.941 182.073 120.824C181.913 120.707 181.833 120.579 181.833 120.44V116.472C181.833 116.109 181.758 115.805 181.609 115.56C181.47 115.304 181.284 115.112 181.049 114.984C180.825 114.856 180.59 114.792 180.345 114.792C180.089 114.792 179.849 114.861 179.625 115C179.401 115.128 179.214 115.315 179.065 115.56C178.916 115.795 178.841 116.088 178.841 116.44V120.456C178.841 120.648 178.75 120.787 178.569 120.872C178.398 120.957 178.206 121 177.993 121C177.801 121 177.614 120.957 177.433 120.872C177.252 120.787 177.161 120.648 177.161 120.456V116.456C177.161 116.115 177.092 115.821 176.953 115.576C176.814 115.331 176.633 115.144 176.409 115.016C176.185 114.877 175.94 114.808 175.673 114.808C175.428 114.808 175.188 114.872 174.953 115C174.729 115.128 174.542 115.315 174.393 115.56C174.254 115.805 174.185 116.109 174.185 116.472V120.44C174.185 120.579 174.1 120.707 173.929 120.824C173.769 120.941 173.572 121 173.337 121ZM185.8 121.096C185.523 121.096 185.293 121 185.112 120.808C184.931 120.616 184.84 120.392 184.84 120.136C184.84 119.869 184.931 119.645 185.112 119.464C185.293 119.272 185.523 119.176 185.8 119.176C186.056 119.176 186.275 119.272 186.456 119.464C186.648 119.645 186.744 119.869 186.744 120.136C186.744 120.392 186.648 120.616 186.456 120.808C186.275 121 186.056 121.096 185.8 121.096ZM50.6462 161C50.4329 161 50.2355 160.952 50.0542 160.856C49.8835 160.76 49.7982 160.621 49.7982 160.44V150.152C49.7982 149.832 49.8835 149.613 50.0542 149.496C50.2355 149.368 50.4329 149.304 50.6462 149.304C50.8489 149.304 51.0249 149.336 51.1742 149.4C51.3235 149.453 51.4622 149.549 51.5902 149.688C51.7182 149.827 51.8515 150.019 51.9902 150.264L54.2302 154.504L56.5022 150.264C56.6409 150.019 56.7689 149.827 56.8862 149.688C57.0142 149.549 57.1529 149.453 57.3022 149.4C57.4515 149.336 57.6275 149.304 57.8302 149.304C58.0542 149.304 58.2515 149.368 58.4222 149.496C58.5929 149.613 58.6782 149.832 58.6782 150.152V160.44C58.6782 160.621 58.5875 160.76 58.4062 160.856C58.2355 160.952 58.0435 161 57.8302 161C57.6169 161 57.4195 160.952 57.2382 160.856C57.0675 160.76 56.9822 160.621 56.9822 160.44V152.76L54.8382 156.728C54.7529 156.867 54.6569 156.968 54.5502 157.032C54.4435 157.085 54.3315 157.112 54.2142 157.112C54.1182 157.112 54.0169 157.085 53.9102 157.032C53.8035 156.979 53.7129 156.877 53.6382 156.728L51.4942 152.664V160.44C51.4942 160.621 51.4035 160.76 51.2222 160.856C51.0515 160.952 50.8595 161 50.6462 161ZM62.2546 161.128C61.6679 161.128 61.1666 160.957 60.7506 160.616C60.3346 160.264 60.1266 159.731 60.1266 159.016C60.1266 158.408 60.2866 157.939 60.6066 157.608C60.9266 157.277 61.3639 157.048 61.9186 156.92C62.4839 156.792 63.1346 156.728 63.8706 156.728H64.5746V156.44C64.5746 156.163 64.5212 155.896 64.4146 155.64C64.3186 155.373 64.1532 155.155 63.9186 154.984C63.6946 154.803 63.3852 154.712 62.9906 154.712C62.5959 154.712 62.2919 154.749 62.0786 154.824C61.8652 154.899 61.6946 154.979 61.5666 155.064C61.4386 155.149 61.3212 155.192 61.2146 155.192C61.0226 155.192 60.8732 155.101 60.7666 154.92C60.6599 154.728 60.6066 154.536 60.6066 154.344C60.6066 154.152 60.7292 153.981 60.9746 153.832C61.2306 153.672 61.5452 153.549 61.9186 153.464C62.2919 153.368 62.6599 153.32 63.0226 153.32C63.8119 153.32 64.4412 153.469 64.9106 153.768C65.3799 154.056 65.7212 154.435 65.9346 154.904C66.1479 155.373 66.2546 155.88 66.2546 156.424V160.44C66.2546 160.589 66.1746 160.723 66.0146 160.84C65.8652 160.947 65.6732 161 65.4386 161C65.2252 161 65.0439 160.947 64.8946 160.84C64.7452 160.723 64.6706 160.589 64.6706 160.44V159.88C64.3932 160.2 64.0572 160.488 63.6626 160.744C63.2679 161 62.7986 161.128 62.2546 161.128ZM62.8626 159.848C63.1292 159.848 63.3906 159.768 63.6466 159.608C63.9132 159.448 64.1319 159.245 64.3026 159C64.4839 158.755 64.5746 158.504 64.5746 158.248V157.656H64.1746C63.7692 157.656 63.3852 157.683 63.0226 157.736C62.6599 157.779 62.3666 157.885 62.1426 158.056C61.9292 158.216 61.8226 158.467 61.8226 158.808C61.8226 159.171 61.9186 159.437 62.1106 159.608C62.3132 159.768 62.5639 159.848 62.8626 159.848ZM68.7823 161C68.5476 161 68.3503 160.941 68.1903 160.824C68.041 160.707 67.9663 160.579 67.9663 160.44V149.448C67.9663 149.288 68.041 149.16 68.1903 149.064C68.3503 148.957 68.5476 148.904 68.7823 148.904C69.0276 148.904 69.2303 148.957 69.3903 149.064C69.561 149.16 69.6463 149.288 69.6463 149.448V156.568L72.9903 153.496C73.0863 153.4 73.2036 153.352 73.3423 153.352C73.4703 153.352 73.593 153.395 73.7103 153.48C73.8383 153.555 73.945 153.656 74.0303 153.784C74.1156 153.901 74.1583 154.024 74.1583 154.152C74.1583 154.216 74.1476 154.28 74.1263 154.344C74.105 154.397 74.0676 154.451 74.0143 154.504L71.9503 156.344L74.4623 159.96C74.5263 160.067 74.5583 160.163 74.5583 160.248C74.5583 160.387 74.505 160.52 74.3983 160.648C74.3023 160.776 74.1796 160.883 74.0303 160.968C73.8916 161.053 73.753 161.096 73.6143 161.096C73.4223 161.096 73.273 161.016 73.1663 160.856L70.8143 157.384L69.6463 158.44V160.44C69.6463 160.579 69.561 160.707 69.3903 160.824C69.2303 160.941 69.0276 161 68.7823 161ZM78.8743 161.128C78.149 161.128 77.509 160.995 76.9543 160.728C76.3996 160.461 75.9623 160.093 75.6423 159.624C75.3223 159.144 75.1623 158.584 75.1623 157.944V156.424C75.1623 155.859 75.3116 155.341 75.6103 154.872C75.9196 154.403 76.325 154.029 76.8263 153.752C77.3276 153.464 77.8823 153.32 78.4903 153.32C79.0663 153.32 79.5943 153.448 80.0743 153.704C80.5543 153.949 80.9383 154.296 81.2263 154.744C81.525 155.192 81.6743 155.704 81.6743 156.28C81.6743 156.728 81.605 157.048 81.4663 157.24C81.3276 157.432 81.1463 157.549 80.9223 157.592C80.6983 157.635 80.4636 157.656 80.2183 157.656H76.8423V158.024C76.8423 158.557 77.0343 158.984 77.4183 159.304C77.813 159.613 78.3143 159.768 78.9223 159.768C79.2956 159.768 79.5996 159.715 79.8343 159.608C80.069 159.501 80.2663 159.4 80.4263 159.304C80.5863 159.208 80.7356 159.16 80.8743 159.16C81.013 159.16 81.1303 159.203 81.2263 159.288C81.3223 159.373 81.397 159.475 81.4503 159.592C81.5036 159.709 81.5303 159.816 81.5303 159.912C81.5303 160.072 81.4183 160.248 81.1943 160.44C80.981 160.632 80.677 160.797 80.2823 160.936C79.8876 161.064 79.4183 161.128 78.8743 161.128ZM76.8423 156.616H79.4983C79.733 156.616 79.8876 156.584 79.9623 156.52C80.0476 156.456 80.0903 156.328 80.0903 156.136C80.0903 155.859 80.021 155.603 79.8823 155.368C79.7436 155.123 79.5516 154.936 79.3063 154.808C79.061 154.669 78.7836 154.6 78.4743 154.6C78.1756 154.6 77.9036 154.664 77.6583 154.792C77.413 154.92 77.2156 155.096 77.0663 155.32C76.917 155.544 76.8423 155.805 76.8423 156.104V156.616ZM88.5672 161.128C88.0445 161.128 87.5752 161.064 87.1592 160.936C86.7432 160.808 86.4125 160.648 86.1672 160.456C85.9325 160.253 85.8152 160.051 85.8152 159.848C85.8152 159.752 85.8365 159.645 85.8792 159.528C85.9325 159.411 86.0019 159.309 86.0872 159.224C86.1832 159.139 86.2845 159.096 86.3912 159.096C86.5299 159.096 86.6739 159.16 86.8232 159.288C86.9832 159.405 87.1912 159.528 87.4472 159.656C87.7032 159.773 88.0605 159.832 88.5192 159.832C89.0525 159.832 89.4099 159.741 89.5912 159.56C89.7832 159.379 89.8792 159.181 89.8792 158.968C89.8792 158.691 89.7832 158.477 89.5912 158.328C89.4099 158.168 89.1699 158.04 88.8712 157.944C88.5832 157.848 88.2739 157.757 87.9432 157.672C87.6125 157.576 87.2979 157.453 86.9992 157.304C86.7112 157.155 86.4712 156.947 86.2792 156.68C86.0979 156.413 86.0072 156.061 86.0072 155.624C86.0072 155.261 86.0979 154.904 86.2792 154.552C86.4605 154.189 86.7485 153.896 87.1432 153.672C87.5485 153.437 88.0872 153.32 88.7592 153.32C89.1645 153.32 89.5485 153.363 89.9112 153.448C90.2739 153.533 90.5725 153.651 90.8072 153.8C91.0419 153.939 91.1592 154.093 91.1592 154.264C91.1592 154.339 91.1325 154.445 91.0792 154.584C91.0259 154.712 90.9512 154.829 90.8552 154.936C90.7699 155.032 90.6579 155.08 90.5192 155.08C90.4125 155.08 90.2792 155.043 90.1192 154.968C89.9592 154.883 89.7725 154.803 89.5592 154.728C89.3459 154.653 89.0845 154.616 88.7752 154.616C88.4659 154.616 88.2152 154.669 88.0232 154.776C87.8419 154.872 87.7085 154.989 87.6232 155.128C87.5379 155.267 87.4952 155.405 87.4952 155.544C87.4952 155.779 87.5859 155.96 87.7672 156.088C87.9485 156.216 88.1885 156.323 88.4872 156.408C88.7859 156.493 89.1005 156.584 89.4312 156.68C89.7619 156.765 90.0712 156.893 90.3592 157.064C90.6579 157.235 90.8979 157.464 91.0792 157.752C91.2712 158.04 91.3672 158.424 91.3672 158.904C91.3672 159.576 91.1219 160.115 90.6312 160.52C90.1512 160.925 89.4632 161.128 88.5672 161.128ZM95.9792 161.128C95.3819 161.128 94.8272 160.984 94.3152 160.696C93.8139 160.397 93.4139 160.008 93.1152 159.528C92.8165 159.037 92.6672 158.52 92.6672 157.976V153.976C92.6672 153.837 92.7472 153.709 92.9072 153.592C93.0779 153.475 93.2805 153.416 93.5152 153.416C93.7392 153.416 93.9312 153.475 94.0912 153.592C94.2619 153.709 94.3472 153.837 94.3472 153.976V157.976C94.3472 158.253 94.4165 158.52 94.5552 158.776C94.7045 159.032 94.9019 159.24 95.1472 159.4C95.4032 159.56 95.6805 159.64 95.9792 159.64C96.2779 159.64 96.5499 159.56 96.7952 159.4C97.0405 159.24 97.2325 159.032 97.3712 158.776C97.5205 158.52 97.5952 158.253 97.5952 157.976V153.96C97.5952 153.811 97.6805 153.683 97.8512 153.576C98.0325 153.469 98.2299 153.416 98.4432 153.416C98.6885 153.416 98.8859 153.469 99.0352 153.576C99.1952 153.683 99.2752 153.811 99.2752 153.96V157.976C99.2752 158.541 99.1259 159.064 98.8272 159.544C98.5285 160.024 98.1285 160.408 97.6272 160.696C97.1259 160.984 96.5765 161.128 95.9792 161.128ZM101.766 161C101.532 161 101.334 160.941 101.174 160.824C101.025 160.707 100.95 160.579 100.95 160.44V153.96C100.95 153.8 101.025 153.672 101.174 153.576C101.334 153.469 101.532 153.416 101.766 153.416C101.98 153.416 102.161 153.469 102.31 153.576C102.46 153.672 102.534 153.8 102.534 153.96V154.664C102.652 154.44 102.806 154.227 102.998 154.024C103.201 153.821 103.436 153.656 103.702 153.528C103.969 153.389 104.257 153.32 104.566 153.32H105.078C105.249 153.32 105.398 153.395 105.526 153.544C105.654 153.683 105.718 153.853 105.718 154.056C105.718 154.259 105.654 154.435 105.526 154.584C105.398 154.733 105.249 154.808 105.078 154.808H104.566C104.246 154.808 103.937 154.904 103.638 155.096C103.34 155.288 103.094 155.56 102.902 155.912C102.721 156.253 102.63 156.669 102.63 157.16V160.44C102.63 160.579 102.545 160.707 102.374 160.824C102.214 160.941 102.012 161 101.766 161ZM109.859 161.128C109.133 161.128 108.493 160.995 107.939 160.728C107.384 160.461 106.947 160.093 106.627 159.624C106.307 159.144 106.147 158.584 106.147 157.944V156.424C106.147 155.859 106.296 155.341 106.595 154.872C106.904 154.403 107.309 154.029 107.811 153.752C108.312 153.464 108.867 153.32 109.475 153.32C110.051 153.32 110.579 153.448 111.059 153.704C111.539 153.949 111.923 154.296 112.211 154.744C112.509 155.192 112.659 155.704 112.659 156.28C112.659 156.728 112.589 157.048 112.451 157.24C112.312 157.432 112.131 157.549 111.907 157.592C111.683 157.635 111.448 157.656 111.203 157.656H107.827V158.024C107.827 158.557 108.019 158.984 108.403 159.304C108.797 159.613 109.299 159.768 109.907 159.768C110.28 159.768 110.584 159.715 110.819 159.608C111.053 159.501 111.251 159.4 111.411 159.304C111.571 159.208 111.72 159.16 111.859 159.16C111.997 159.16 112.115 159.203 112.211 159.288C112.307 159.373 112.381 159.475 112.435 159.592C112.488 159.709 112.515 159.816 112.515 159.912C112.515 160.072 112.403 160.248 112.179 160.44C111.965 160.632 111.661 160.797 111.267 160.936C110.872 161.064 110.403 161.128 109.859 161.128ZM107.827 156.616H110.483C110.717 156.616 110.872 156.584 110.947 156.52C111.032 156.456 111.075 156.328 111.075 156.136C111.075 155.859 111.005 155.603 110.867 155.368C110.728 155.123 110.536 154.936 110.291 154.808C110.045 154.669 109.768 154.6 109.459 154.6C109.16 154.6 108.888 154.664 108.643 154.792C108.397 154.92 108.2 155.096 108.051 155.32C107.901 155.544 107.827 155.805 107.827 156.104V156.616ZM120 161C119.093 161 118.4 160.803 117.92 160.408C117.44 160.003 117.2 159.368 117.2 158.504V150.488C117.2 150.328 117.285 150.2 117.456 150.104C117.637 149.997 117.829 149.944 118.032 149.944C118.234 149.944 118.426 149.997 118.608 150.104C118.789 150.2 118.88 150.328 118.88 150.488V153.416H120.832C120.981 153.416 121.093 153.48 121.168 153.608C121.253 153.736 121.296 153.88 121.296 154.04C121.296 154.2 121.253 154.344 121.168 154.472C121.093 154.6 120.981 154.664 120.832 154.664H118.88V158.504C118.88 158.888 118.96 159.16 119.12 159.32C119.29 159.48 119.584 159.56 120 159.56H120.544C120.789 159.56 120.97 159.635 121.088 159.784C121.216 159.923 121.28 160.088 121.28 160.28C121.28 160.461 121.216 160.627 121.088 160.776C120.97 160.925 120.789 161 120.544 161H120ZM123.298 161C123.053 161 122.85 160.941 122.69 160.824C122.541 160.707 122.466 160.579 122.466 160.44V149.448C122.466 149.288 122.541 149.16 122.69 149.064C122.85 148.957 123.053 148.904 123.298 148.904C123.533 148.904 123.73 148.957 123.89 149.064C124.061 149.16 124.146 149.288 124.146 149.448V154.536C124.306 154.227 124.557 153.949 124.898 153.704C125.25 153.448 125.682 153.32 126.194 153.32C126.696 153.32 127.154 153.464 127.57 153.752C127.997 154.029 128.338 154.408 128.594 154.888C128.85 155.357 128.978 155.885 128.978 156.472V160.44C128.978 160.621 128.888 160.76 128.706 160.856C128.536 160.952 128.344 161 128.13 161C127.938 161 127.752 160.952 127.57 160.856C127.389 160.76 127.298 160.621 127.298 160.44V156.472C127.298 156.195 127.224 155.928 127.074 155.672C126.925 155.416 126.728 155.208 126.482 155.048C126.248 154.888 125.981 154.808 125.682 154.808C125.426 154.808 125.181 154.877 124.946 155.016C124.712 155.144 124.52 155.331 124.37 155.576C124.221 155.821 124.146 156.12 124.146 156.472V160.44C124.146 160.579 124.061 160.707 123.89 160.824C123.73 160.941 123.533 161 123.298 161ZM134.077 161.128C133.352 161.128 132.712 160.995 132.157 160.728C131.603 160.461 131.165 160.093 130.845 159.624C130.525 159.144 130.365 158.584 130.365 157.944V156.424C130.365 155.859 130.515 155.341 130.813 154.872C131.123 154.403 131.528 154.029 132.029 153.752C132.531 153.464 133.085 153.32 133.693 153.32C134.269 153.32 134.797 153.448 135.277 153.704C135.757 153.949 136.141 154.296 136.429 154.744C136.728 155.192 136.877 155.704 136.877 156.28C136.877 156.728 136.808 157.048 136.669 157.24C136.531 157.432 136.349 157.549 136.125 157.592C135.901 157.635 135.667 157.656 135.421 157.656H132.045V158.024C132.045 158.557 132.237 158.984 132.621 159.304C133.016 159.613 133.517 159.768 134.125 159.768C134.499 159.768 134.803 159.715 135.037 159.608C135.272 159.501 135.469 159.4 135.629 159.304C135.789 159.208 135.939 159.16 136.077 159.16C136.216 159.16 136.333 159.203 136.429 159.288C136.525 159.373 136.6 159.475 136.653 159.592C136.707 159.709 136.733 159.816 136.733 159.912C136.733 160.072 136.621 160.248 136.397 160.44C136.184 160.632 135.88 160.797 135.485 160.936C135.091 161.064 134.621 161.128 134.077 161.128ZM132.045 156.616H134.701C134.936 156.616 135.091 156.584 135.165 156.52C135.251 156.456 135.293 156.328 135.293 156.136C135.293 155.859 135.224 155.603 135.085 155.368C134.947 155.123 134.755 154.936 134.509 154.808C134.264 154.669 133.987 154.6 133.677 154.6C133.379 154.6 133.107 154.664 132.861 154.792C132.616 154.92 132.419 155.096 132.269 155.32C132.12 155.544 132.045 155.805 132.045 156.104V156.616ZM142.282 151.512C142.016 151.512 141.786 151.421 141.594 151.24C141.402 151.059 141.306 150.856 141.306 150.632C141.306 150.387 141.402 150.179 141.594 150.008C141.786 149.837 142.016 149.752 142.282 149.752C142.549 149.752 142.773 149.837 142.954 150.008C143.146 150.179 143.242 150.387 143.242 150.632C143.242 150.856 143.146 151.059 142.954 151.24C142.773 151.421 142.549 151.512 142.282 151.512ZM142.282 161C142.037 161 141.834 160.941 141.674 160.824C141.525 160.707 141.45 160.579 141.45 160.44V153.96C141.45 153.8 141.525 153.672 141.674 153.576C141.834 153.469 142.037 153.416 142.282 153.416C142.517 153.416 142.714 153.469 142.874 153.576C143.045 153.672 143.13 153.8 143.13 153.96V160.44C143.13 160.579 143.045 160.707 142.874 160.824C142.714 160.941 142.517 161 142.282 161ZM147.64 161C146.734 161 146.04 160.803 145.56 160.408C145.08 160.003 144.84 159.368 144.84 158.504V150.488C144.84 150.328 144.926 150.2 145.096 150.104C145.278 149.997 145.47 149.944 145.672 149.944C145.875 149.944 146.067 149.997 146.248 150.104C146.43 150.2 146.52 150.328 146.52 150.488V153.416H148.472C148.622 153.416 148.734 153.48 148.808 153.608C148.894 153.736 148.936 153.88 148.936 154.04C148.936 154.2 148.894 154.344 148.808 154.472C148.734 154.6 148.622 154.664 148.472 154.664H146.52V158.504C146.52 158.888 146.6 159.16 146.76 159.32C146.931 159.48 147.224 159.56 147.64 159.56H148.184C148.43 159.56 148.611 159.635 148.728 159.784C148.856 159.923 148.92 160.088 148.92 160.28C148.92 160.461 148.856 160.627 148.728 160.776C148.611 160.925 148.43 161 148.184 161H147.64ZM153.406 161.128C152.68 161.128 152.04 160.995 151.486 160.728C150.931 160.461 150.494 160.093 150.174 159.624C149.854 159.144 149.694 158.584 149.694 157.944V156.424C149.694 155.859 149.843 155.341 150.142 154.872C150.451 154.403 150.856 154.029 151.358 153.752C151.859 153.464 152.414 153.32 153.022 153.32C153.598 153.32 154.126 153.448 154.606 153.704C155.086 153.949 155.47 154.296 155.758 154.744C156.056 155.192 156.206 155.704 156.206 156.28C156.206 156.728 156.136 157.048 155.998 157.24C155.859 157.432 155.678 157.549 155.454 157.592C155.23 157.635 154.995 157.656 154.75 157.656H151.374V158.024C151.374 158.557 151.566 158.984 151.95 159.304C152.344 159.613 152.846 159.768 153.454 159.768C153.827 159.768 154.131 159.715 154.366 159.608C154.6 159.501 154.798 159.4 154.958 159.304C155.118 159.208 155.267 159.16 155.406 159.16C155.544 159.16 155.662 159.203 155.758 159.288C155.854 159.373 155.928 159.475 155.982 159.592C156.035 159.709 156.062 159.816 156.062 159.912C156.062 160.072 155.95 160.248 155.726 160.44C155.512 160.632 155.208 160.797 154.814 160.936C154.419 161.064 153.95 161.128 153.406 161.128ZM151.374 156.616H154.03C154.264 156.616 154.419 156.584 154.494 156.52C154.579 156.456 154.622 156.328 154.622 156.136C154.622 155.859 154.552 155.603 154.414 155.368C154.275 155.123 154.083 154.936 153.838 154.808C153.592 154.669 153.315 154.6 153.006 154.6C152.707 154.6 152.435 154.664 152.19 154.792C151.944 154.92 151.747 155.096 151.598 155.32C151.448 155.544 151.374 155.805 151.374 156.104V156.616ZM158.407 161C158.162 161 157.959 160.941 157.799 160.824C157.65 160.707 157.575 160.579 157.575 160.44V153.96C157.575 153.8 157.65 153.672 157.799 153.576C157.959 153.469 158.162 153.416 158.407 153.416C158.61 153.416 158.786 153.469 158.935 153.576C159.085 153.672 159.159 153.8 159.159 153.96V154.536C159.341 154.227 159.607 153.949 159.959 153.704C160.311 153.448 160.754 153.32 161.287 153.32C161.767 153.32 162.189 153.469 162.551 153.768C162.925 154.067 163.202 154.451 163.383 154.92C163.661 154.376 164.018 153.976 164.455 153.72C164.893 153.453 165.341 153.32 165.799 153.32C166.279 153.32 166.727 153.443 167.143 153.688C167.57 153.933 167.917 154.291 168.183 154.76C168.45 155.229 168.583 155.8 168.583 156.472V160.44C168.583 160.579 168.498 160.707 168.327 160.824C168.167 160.941 167.97 161 167.735 161C167.511 161 167.314 160.941 167.143 160.824C166.983 160.707 166.903 160.579 166.903 160.44V156.472C166.903 156.109 166.829 155.805 166.679 155.56C166.541 155.304 166.354 155.112 166.119 154.984C165.895 154.856 165.661 154.792 165.415 154.792C165.159 154.792 164.919 154.861 164.695 155C164.471 155.128 164.285 155.315 164.135 155.56C163.986 155.795 163.911 156.088 163.911 156.44V160.456C163.911 160.648 163.821 160.787 163.639 160.872C163.469 160.957 163.277 161 163.063 161C162.871 161 162.685 160.957 162.503 160.872C162.322 160.787 162.231 160.648 162.231 160.456V156.456C162.231 156.115 162.162 155.821 162.023 155.576C161.885 155.331 161.703 155.144 161.479 155.016C161.255 154.877 161.01 154.808 160.743 154.808C160.498 154.808 160.258 154.872 160.023 155C159.799 155.128 159.613 155.315 159.463 155.56C159.325 155.805 159.255 156.109 159.255 156.472V160.44C159.255 160.579 159.17 160.707 158.999 160.824C158.839 160.941 158.642 161 158.407 161ZM172.598 161.128C172.076 161.128 171.606 161.064 171.19 160.936C170.774 160.808 170.444 160.648 170.198 160.456C169.964 160.253 169.846 160.051 169.846 159.848C169.846 159.752 169.868 159.645 169.91 159.528C169.964 159.411 170.033 159.309 170.118 159.224C170.214 159.139 170.316 159.096 170.422 159.096C170.561 159.096 170.705 159.16 170.854 159.288C171.014 159.405 171.222 159.528 171.478 159.656C171.734 159.773 172.092 159.832 172.55 159.832C173.084 159.832 173.441 159.741 173.622 159.56C173.814 159.379 173.91 159.181 173.91 158.968C173.91 158.691 173.814 158.477 173.622 158.328C173.441 158.168 173.201 158.04 172.902 157.944C172.614 157.848 172.305 157.757 171.974 157.672C171.644 157.576 171.329 157.453 171.03 157.304C170.742 157.155 170.502 156.947 170.31 156.68C170.129 156.413 170.038 156.061 170.038 155.624C170.038 155.261 170.129 154.904 170.31 154.552C170.492 154.189 170.78 153.896 171.174 153.672C171.58 153.437 172.118 153.32 172.79 153.32C173.196 153.32 173.58 153.363 173.942 153.448C174.305 153.533 174.604 153.651 174.838 153.8C175.073 153.939 175.19 154.093 175.19 154.264C175.19 154.339 175.164 154.445 175.11 154.584C175.057 154.712 174.982 154.829 174.886 154.936C174.801 155.032 174.689 155.08 174.55 155.08C174.444 155.08 174.31 155.043 174.15 154.968C173.99 154.883 173.804 154.803 173.59 154.728C173.377 154.653 173.116 154.616 172.806 154.616C172.497 154.616 172.246 154.669 172.054 154.776C171.873 154.872 171.74 154.989 171.654 155.128C171.569 155.267 171.526 155.405 171.526 155.544C171.526 155.779 171.617 155.96 171.798 156.088C171.98 156.216 172.22 156.323 172.518 156.408C172.817 156.493 173.132 156.584 173.462 156.68C173.793 156.765 174.102 156.893 174.39 157.064C174.689 157.235 174.929 157.464 175.11 157.752C175.302 158.04 175.398 158.424 175.398 158.904C175.398 159.576 175.153 160.115 174.662 160.52C174.182 160.925 173.494 161.128 172.598 161.128ZM180.958 161C180.712 161 180.51 160.941 180.35 160.824C180.2 160.707 180.126 160.579 180.126 160.44V149.448C180.126 149.288 180.2 149.16 180.35 149.064C180.51 148.957 180.712 148.904 180.958 148.904C181.192 148.904 181.39 148.957 181.55 149.064C181.72 149.16 181.806 149.288 181.806 149.448V160.44C181.806 160.579 181.72 160.707 181.55 160.824C181.39 160.941 181.192 161 180.958 161ZM185.348 161.128C184.762 161.128 184.26 160.957 183.844 160.616C183.428 160.264 183.22 159.731 183.22 159.016C183.22 158.408 183.38 157.939 183.7 157.608C184.02 157.277 184.458 157.048 185.012 156.92C185.578 156.792 186.228 156.728 186.964 156.728H187.668V156.44C187.668 156.163 187.615 155.896 187.508 155.64C187.412 155.373 187.247 155.155 187.012 154.984C186.788 154.803 186.479 154.712 186.084 154.712C185.69 154.712 185.386 154.749 185.172 154.824C184.959 154.899 184.788 154.979 184.66 155.064C184.532 155.149 184.415 155.192 184.308 155.192C184.116 155.192 183.967 155.101 183.86 154.92C183.754 154.728 183.7 154.536 183.7 154.344C183.7 154.152 183.823 153.981 184.068 153.832C184.324 153.672 184.639 153.549 185.012 153.464C185.386 153.368 185.754 153.32 186.116 153.32C186.906 153.32 187.535 153.469 188.004 153.768C188.474 154.056 188.815 154.435 189.028 154.904C189.242 155.373 189.348 155.88 189.348 156.424V160.44C189.348 160.589 189.268 160.723 189.108 160.84C188.959 160.947 188.767 161 188.532 161C188.319 161 188.138 160.947 187.988 160.84C187.839 160.723 187.764 160.589 187.764 160.44V159.88C187.487 160.2 187.151 160.488 186.756 160.744C186.362 161 185.892 161.128 185.348 161.128ZM185.956 159.848C186.223 159.848 186.484 159.768 186.74 159.608C187.007 159.448 187.226 159.245 187.396 159C187.578 158.755 187.668 158.504 187.668 158.248V157.656H187.268C186.863 157.656 186.479 157.683 186.116 157.736C185.754 157.779 185.46 157.885 185.236 158.056C185.023 158.216 184.916 158.467 184.916 158.808C184.916 159.171 185.012 159.437 185.204 159.608C185.407 159.768 185.658 159.848 185.956 159.848ZM191.876 161C191.631 161 191.428 160.941 191.268 160.824C191.119 160.707 191.044 160.579 191.044 160.44V153.96C191.044 153.8 191.119 153.672 191.268 153.576C191.428 153.469 191.631 153.416 191.876 153.416C192.079 153.416 192.255 153.469 192.404 153.576C192.553 153.672 192.628 153.8 192.628 153.96V154.536C192.788 154.227 193.049 153.949 193.412 153.704C193.785 153.448 194.239 153.32 194.772 153.32C195.273 153.32 195.732 153.464 196.148 153.752C196.575 154.029 196.916 154.408 197.172 154.888C197.428 155.357 197.556 155.885 197.556 156.472V160.44C197.556 160.621 197.465 160.76 197.284 160.856C197.113 160.952 196.921 161 196.708 161C196.516 161 196.329 160.952 196.148 160.856C195.967 160.76 195.876 160.621 195.876 160.44V156.472C195.876 156.195 195.801 155.928 195.652 155.672C195.513 155.416 195.321 155.208 195.076 155.048C194.831 154.888 194.559 154.808 194.26 154.808C194.004 154.808 193.759 154.877 193.524 155.016C193.289 155.144 193.097 155.331 192.948 155.576C192.799 155.821 192.724 156.12 192.724 156.472V160.44C192.724 160.579 192.639 160.707 192.468 160.824C192.308 160.941 192.111 161 191.876 161ZM201.76 161.128C201.258 161.128 200.794 160.979 200.368 160.68C199.941 160.381 199.594 159.992 199.328 159.512C199.072 159.021 198.944 158.499 198.944 157.944V156.472C198.944 155.885 199.072 155.357 199.328 154.888C199.594 154.408 199.941 154.029 200.368 153.752C200.794 153.464 201.269 153.32 201.792 153.32C202.304 153.32 202.736 153.448 203.088 153.704C203.44 153.949 203.701 154.227 203.872 154.536V149.448C203.872 149.288 203.957 149.16 204.128 149.064C204.298 148.957 204.501 148.904 204.736 148.904C204.97 148.904 205.162 148.957 205.312 149.064C205.472 149.16 205.552 149.288 205.552 149.448V160.44C205.552 160.579 205.472 160.707 205.312 160.824C205.162 160.941 204.97 161 204.736 161C204.533 161 204.352 160.941 204.192 160.824C204.042 160.707 203.968 160.579 203.968 160.44V159.88C203.808 160.211 203.525 160.504 203.12 160.76C202.714 161.005 202.261 161.128 201.76 161.128ZM202.24 159.64C202.549 159.64 202.826 159.555 203.072 159.384C203.317 159.213 203.509 159.027 203.648 158.824C203.797 158.611 203.872 158.44 203.872 158.312V156.472C203.872 156.12 203.792 155.821 203.632 155.576C203.472 155.331 203.269 155.144 203.024 155.016C202.778 154.877 202.522 154.808 202.256 154.808C201.957 154.808 201.68 154.888 201.424 155.048C201.178 155.208 200.981 155.416 200.832 155.672C200.693 155.928 200.624 156.195 200.624 156.472V157.944C200.624 158.221 200.693 158.493 200.832 158.76C200.981 159.027 201.178 159.24 201.424 159.4C201.669 159.56 201.941 159.64 202.24 159.64ZM211.36 151.512C211.094 151.512 210.864 151.421 210.672 151.24C210.48 151.059 210.384 150.856 210.384 150.632C210.384 150.387 210.48 150.179 210.672 150.008C210.864 149.837 211.094 149.752 211.36 149.752C211.627 149.752 211.851 149.837 212.032 150.008C212.224 150.179 212.32 150.387 212.32 150.632C212.32 150.856 212.224 151.059 212.032 151.24C211.851 151.421 211.627 151.512 211.36 151.512ZM211.36 161C211.115 161 210.912 160.941 210.752 160.824C210.603 160.707 210.528 160.579 210.528 160.44V153.96C210.528 153.8 210.603 153.672 210.752 153.576C210.912 153.469 211.115 153.416 211.36 153.416C211.595 153.416 211.792 153.469 211.952 153.576C212.123 153.672 212.208 153.8 212.208 153.96V160.44C212.208 160.579 212.123 160.707 211.952 160.824C211.792 160.941 211.595 161 211.36 161ZM214.782 161C214.537 161 214.334 160.941 214.174 160.824C214.025 160.707 213.95 160.579 213.95 160.44V153.96C213.95 153.8 214.025 153.672 214.174 153.576C214.334 153.469 214.537 153.416 214.782 153.416C214.985 153.416 215.161 153.469 215.31 153.576C215.46 153.672 215.534 153.8 215.534 153.96V154.536C215.694 154.227 215.956 153.949 216.318 153.704C216.692 153.448 217.145 153.32 217.678 153.32C218.18 153.32 218.638 153.464 219.054 153.752C219.481 154.029 219.822 154.408 220.078 154.888C220.334 155.357 220.462 155.885 220.462 156.472V160.44C220.462 160.621 220.372 160.76 220.19 160.856C220.02 160.952 219.828 161 219.614 161C219.422 161 219.236 160.952 219.054 160.856C218.873 160.76 218.782 160.621 218.782 160.44V156.472C218.782 156.195 218.708 155.928 218.558 155.672C218.42 155.416 218.228 155.208 217.982 155.048C217.737 154.888 217.465 154.808 217.166 154.808C216.91 154.808 216.665 154.877 216.43 155.016C216.196 155.144 216.004 155.331 215.854 155.576C215.705 155.821 215.63 156.12 215.63 156.472V160.44C215.63 160.579 215.545 160.707 215.374 160.824C215.214 160.941 215.017 161 214.782 161ZM95.1168 181C94.2101 181 93.5168 180.803 93.0368 180.408C92.5568 180.003 92.3168 179.368 92.3168 178.504V170.488C92.3168 170.328 92.4021 170.2 92.5728 170.104C92.7541 169.997 92.9461 169.944 93.1488 169.944C93.3514 169.944 93.5434 169.997 93.7248 170.104C93.9061 170.2 93.9968 170.328 93.9968 170.488V173.416H95.9488C96.0981 173.416 96.2101 173.48 96.2848 173.608C96.3701 173.736 96.4128 173.88 96.4128 174.04C96.4128 174.2 96.3701 174.344 96.2848 174.472C96.2101 174.6 96.0981 174.664 95.9488 174.664H93.9968V178.504C93.9968 178.888 94.0768 179.16 94.2368 179.32C94.4074 179.48 94.7008 179.56 95.1168 179.56H95.6608C95.9061 179.56 96.0874 179.635 96.2048 179.784C96.3328 179.923 96.3968 180.088 96.3968 180.28C96.3968 180.461 96.3328 180.627 96.2048 180.776C96.0874 180.925 95.9061 181 95.6608 181H95.1168ZM98.4155 181C98.1702 181 97.9675 180.941 97.8075 180.824C97.6582 180.707 97.5835 180.579 97.5835 180.44V169.448C97.5835 169.288 97.6582 169.16 97.8075 169.064C97.9675 168.957 98.1702 168.904 98.4155 168.904C98.6502 168.904 98.8475 168.957 99.0075 169.064C99.1782 169.16 99.2635 169.288 99.2635 169.448V174.536C99.4235 174.227 99.6742 173.949 100.016 173.704C100.368 173.448 100.8 173.32 101.312 173.32C101.813 173.32 102.272 173.464 102.688 173.752C103.114 174.029 103.456 174.408 103.712 174.888C103.968 175.357 104.096 175.885 104.096 176.472V180.44C104.096 180.621 104.005 180.76 103.824 180.856C103.653 180.952 103.461 181 103.248 181C103.056 181 102.869 180.952 102.688 180.856C102.506 180.76 102.416 180.621 102.416 180.44V176.472C102.416 176.195 102.341 175.928 102.192 175.672C102.042 175.416 101.845 175.208 101.6 175.048C101.365 174.888 101.098 174.808 100.799 174.808C100.544 174.808 100.298 174.877 100.064 175.016C99.8288 175.144 99.6368 175.331 99.4875 175.576C99.3382 175.821 99.2635 176.12 99.2635 176.472V180.44C99.2635 180.579 99.1782 180.707 99.0075 180.824C98.8475 180.941 98.6502 181 98.4155 181ZM109.195 181.128C108.469 181.128 107.829 180.995 107.275 180.728C106.72 180.461 106.283 180.093 105.963 179.624C105.643 179.144 105.483 178.584 105.483 177.944V176.424C105.483 175.859 105.632 175.341 105.931 174.872C106.24 174.403 106.645 174.029 107.147 173.752C107.648 173.464 108.203 173.32 108.811 173.32C109.387 173.32 109.915 173.448 110.395 173.704C110.875 173.949 111.259 174.296 111.547 174.744C111.845 175.192 111.995 175.704 111.995 176.28C111.995 176.728 111.925 177.048 111.787 177.24C111.648 177.432 111.467 177.549 111.243 177.592C111.019 177.635 110.784 177.656 110.539 177.656H107.163V178.024C107.163 178.557 107.355 178.984 107.739 179.304C108.133 179.613 108.635 179.768 109.243 179.768C109.616 179.768 109.92 179.715 110.155 179.608C110.389 179.501 110.587 179.4 110.747 179.304C110.907 179.208 111.056 179.16 111.195 179.16C111.333 179.16 111.451 179.203 111.547 179.288C111.643 179.373 111.717 179.475 111.771 179.592C111.824 179.709 111.851 179.816 111.851 179.912C111.851 180.072 111.739 180.248 111.515 180.44C111.301 180.632 110.997 180.797 110.603 180.936C110.208 181.064 109.739 181.128 109.195 181.128ZM107.163 176.616H109.819C110.053 176.616 110.208 176.584 110.283 176.52C110.368 176.456 110.411 176.328 110.411 176.136C110.411 175.859 110.341 175.603 110.203 175.368C110.064 175.123 109.872 174.936 109.627 174.808C109.381 174.669 109.104 174.6 108.795 174.6C108.496 174.6 108.224 174.664 107.979 174.792C107.733 174.92 107.536 175.096 107.387 175.32C107.237 175.544 107.163 175.805 107.163 176.104V176.616ZM117.384 181C117.149 181 116.952 180.941 116.792 180.824C116.642 180.707 116.568 180.579 116.568 180.44V173.96C116.568 173.8 116.642 173.672 116.792 173.576C116.952 173.469 117.149 173.416 117.384 173.416C117.597 173.416 117.778 173.469 117.928 173.576C118.077 173.672 118.152 173.8 118.152 173.96V174.664C118.269 174.44 118.424 174.227 118.616 174.024C118.818 173.821 119.053 173.656 119.32 173.528C119.586 173.389 119.874 173.32 120.184 173.32H120.696C120.866 173.32 121.016 173.395 121.144 173.544C121.272 173.683 121.336 173.853 121.336 174.056C121.336 174.259 121.272 174.435 121.144 174.584C121.016 174.733 120.866 174.808 120.696 174.808H120.184C119.864 174.808 119.554 174.904 119.256 175.096C118.957 175.288 118.712 175.56 118.52 175.912C118.338 176.253 118.248 176.669 118.248 177.16V180.44C118.248 180.579 118.162 180.707 117.992 180.824C117.832 180.941 117.629 181 117.384 181ZM123.134 171.512C122.867 171.512 122.638 171.421 122.446 171.24C122.254 171.059 122.158 170.856 122.158 170.632C122.158 170.387 122.254 170.179 122.446 170.008C122.638 169.837 122.867 169.752 123.134 169.752C123.401 169.752 123.625 169.837 123.806 170.008C123.998 170.179 124.094 170.387 124.094 170.632C124.094 170.856 123.998 171.059 123.806 171.24C123.625 171.421 123.401 171.512 123.134 171.512ZM123.134 181C122.889 181 122.686 180.941 122.526 180.824C122.377 180.707 122.302 180.579 122.302 180.44V173.96C122.302 173.8 122.377 173.672 122.526 173.576C122.686 173.469 122.889 173.416 123.134 173.416C123.369 173.416 123.566 173.469 123.726 173.576C123.897 173.672 123.982 173.8 123.982 173.96V180.44C123.982 180.579 123.897 180.707 123.726 180.824C123.566 180.941 123.369 181 123.134 181ZM128.588 184.6C127.969 184.6 127.398 184.509 126.876 184.328C126.353 184.157 125.937 183.907 125.628 183.576C125.318 183.245 125.164 182.851 125.164 182.392C125.164 181.965 125.286 181.608 125.532 181.32C125.777 181.043 126.065 180.829 126.396 180.68C126.182 180.584 126.006 180.456 125.868 180.296C125.729 180.136 125.66 179.912 125.66 179.624C125.66 179.325 125.734 179.085 125.884 178.904C126.033 178.723 126.225 178.557 126.46 178.408C126.161 178.173 125.926 177.885 125.756 177.544C125.596 177.192 125.516 176.808 125.516 176.392V175.944C125.516 175.432 125.638 174.979 125.884 174.584C126.129 174.189 126.476 173.88 126.924 173.656C127.382 173.432 127.905 173.32 128.492 173.32C128.854 173.32 129.19 173.368 129.5 173.464C129.82 173.56 130.102 173.693 130.348 173.864C130.518 173.469 130.689 173.192 130.86 173.032C131.041 172.872 131.212 172.792 131.372 172.792C131.596 172.792 131.766 172.856 131.884 172.984C132.001 173.112 132.06 173.24 132.06 173.368C132.06 173.453 132.033 173.533 131.98 173.608C131.937 173.672 131.873 173.725 131.788 173.768C131.681 173.821 131.553 173.896 131.404 173.992C131.265 174.077 131.126 174.216 130.988 174.408C131.169 174.611 131.302 174.845 131.388 175.112C131.473 175.379 131.516 175.656 131.516 175.944V176.392C131.516 176.893 131.388 177.347 131.132 177.752C130.876 178.157 130.518 178.477 130.06 178.712C129.601 178.936 129.078 179.048 128.492 179.048C128.076 179.048 127.708 178.984 127.388 178.856C127.302 178.909 127.228 178.973 127.164 179.048C127.11 179.112 127.084 179.197 127.084 179.304C127.084 179.496 127.201 179.635 127.436 179.72C127.67 179.805 127.969 179.869 128.332 179.912C128.705 179.955 129.1 180.008 129.516 180.072C129.932 180.136 130.321 180.243 130.684 180.392C131.057 180.531 131.361 180.739 131.596 181.016C131.83 181.304 131.948 181.693 131.948 182.184C131.948 182.739 131.793 183.192 131.484 183.544C131.174 183.907 130.764 184.173 130.252 184.344C129.75 184.515 129.196 184.6 128.588 184.6ZM128.556 183.48C129.078 183.48 129.5 183.363 129.82 183.128C130.15 182.904 130.316 182.605 130.316 182.232C130.316 181.965 130.236 181.757 130.076 181.608C129.916 181.459 129.708 181.347 129.452 181.272C129.196 181.197 128.924 181.144 128.636 181.112C128.358 181.08 128.092 181.048 127.836 181.016C127.537 181.123 127.281 181.272 127.068 181.464C126.865 181.667 126.764 181.917 126.764 182.216C126.764 182.611 126.929 182.92 127.26 183.144C127.601 183.368 128.033 183.48 128.556 183.48ZM128.524 177.976C128.95 177.976 129.281 177.827 129.516 177.528C129.761 177.229 129.884 176.851 129.884 176.392V175.944C129.884 175.507 129.761 175.139 129.516 174.84C129.281 174.541 128.945 174.392 128.508 174.392C128.07 174.392 127.734 174.541 127.5 174.84C127.265 175.139 127.148 175.507 127.148 175.944V176.376C127.148 176.824 127.265 177.203 127.5 177.512C127.734 177.821 128.076 177.976 128.524 177.976ZM134.009 181C133.764 181 133.561 180.941 133.401 180.824C133.252 180.707 133.177 180.579 133.177 180.44V169.448C133.177 169.288 133.252 169.16 133.401 169.064C133.561 168.957 133.764 168.904 134.009 168.904C134.244 168.904 134.441 168.957 134.601 169.064C134.772 169.16 134.857 169.288 134.857 169.448V174.536C135.017 174.227 135.268 173.949 135.609 173.704C135.961 173.448 136.393 173.32 136.905 173.32C137.407 173.32 137.865 173.464 138.281 173.752C138.708 174.029 139.049 174.408 139.305 174.888C139.561 175.357 139.689 175.885 139.689 176.472V180.44C139.689 180.621 139.599 180.76 139.417 180.856C139.247 180.952 139.055 181 138.841 181C138.649 181 138.463 180.952 138.281 180.856C138.1 180.76 138.009 180.621 138.009 180.44V176.472C138.009 176.195 137.935 175.928 137.785 175.672C137.636 175.416 137.439 175.208 137.193 175.048C136.959 174.888 136.692 174.808 136.393 174.808C136.137 174.808 135.892 174.877 135.657 175.016C135.423 175.144 135.231 175.331 135.081 175.576C134.932 175.821 134.857 176.12 134.857 176.472V180.44C134.857 180.579 134.772 180.707 134.601 180.824C134.441 180.941 134.244 181 134.009 181ZM144.132 181C143.226 181 142.532 180.803 142.052 180.408C141.572 180.003 141.332 179.368 141.332 178.504V170.488C141.332 170.328 141.418 170.2 141.588 170.104C141.77 169.997 141.962 169.944 142.164 169.944C142.367 169.944 142.559 169.997 142.74 170.104C142.922 170.2 143.012 170.328 143.012 170.488V173.416H144.964C145.114 173.416 145.226 173.48 145.3 173.608C145.386 173.736 145.428 173.88 145.428 174.04C145.428 174.2 145.386 174.344 145.3 174.472C145.226 174.6 145.114 174.664 144.964 174.664H143.012V178.504C143.012 178.888 143.092 179.16 143.252 179.32C143.423 179.48 143.716 179.56 144.132 179.56H144.676C144.922 179.56 145.103 179.635 145.22 179.784C145.348 179.923 145.412 180.088 145.412 180.28C145.412 180.461 145.348 180.627 145.22 180.776C145.103 180.925 144.922 181 144.676 181H144.132ZM153.594 181.128C153.093 181.128 152.64 181.005 152.234 180.76C151.84 180.504 151.557 180.211 151.386 179.88V180.44C151.386 180.579 151.312 180.707 151.162 180.824C151.013 180.941 150.832 181 150.618 181C150.384 181 150.186 180.941 150.026 180.824C149.877 180.707 149.802 180.579 149.802 180.44V169.448C149.802 169.288 149.877 169.16 150.026 169.064C150.186 168.957 150.384 168.904 150.618 168.904C150.864 168.904 151.066 168.957 151.226 169.064C151.397 169.16 151.482 169.288 151.482 169.448V174.536C151.653 174.227 151.914 173.949 152.266 173.704C152.618 173.448 153.045 173.32 153.546 173.32C154.069 173.32 154.544 173.464 154.97 173.752C155.408 174.029 155.754 174.408 156.01 174.888C156.277 175.357 156.41 175.885 156.41 176.472V177.944C156.41 178.499 156.277 179.021 156.01 179.512C155.754 179.992 155.413 180.381 154.986 180.68C154.56 180.979 154.096 181.128 153.594 181.128ZM153.114 179.64C153.402 179.64 153.669 179.56 153.914 179.4C154.16 179.24 154.357 179.027 154.506 178.76C154.656 178.493 154.73 178.221 154.73 177.944V176.472C154.73 176.195 154.656 175.928 154.506 175.672C154.357 175.416 154.16 175.208 153.914 175.048C153.669 174.888 153.397 174.808 153.098 174.808C152.832 174.808 152.576 174.877 152.33 175.016C152.085 175.144 151.882 175.331 151.722 175.576C151.562 175.821 151.482 176.12 151.482 176.472V178.312C151.482 178.44 151.552 178.611 151.69 178.824C151.84 179.027 152.037 179.213 152.282 179.384C152.528 179.555 152.805 179.64 153.114 179.64ZM158.712 171.512C158.445 171.512 158.216 171.421 158.024 171.24C157.832 171.059 157.736 170.856 157.736 170.632C157.736 170.387 157.832 170.179 158.024 170.008C158.216 169.837 158.445 169.752 158.712 169.752C158.979 169.752 159.203 169.837 159.384 170.008C159.576 170.179 159.672 170.387 159.672 170.632C159.672 170.856 159.576 171.059 159.384 171.24C159.203 171.421 158.979 171.512 158.712 171.512ZM158.712 181C158.467 181 158.264 180.941 158.104 180.824C157.955 180.707 157.88 180.579 157.88 180.44V173.96C157.88 173.8 157.955 173.672 158.104 173.576C158.264 173.469 158.467 173.416 158.712 173.416C158.947 173.416 159.144 173.469 159.304 173.576C159.475 173.672 159.56 173.8 159.56 173.96V180.44C159.56 180.579 159.475 180.707 159.304 180.824C159.144 180.941 158.947 181 158.712 181ZM162.134 181C161.889 181 161.686 180.941 161.526 180.824C161.377 180.707 161.302 180.579 161.302 180.44V173.96C161.302 173.8 161.377 173.672 161.526 173.576C161.686 173.469 161.889 173.416 162.134 173.416C162.337 173.416 162.513 173.469 162.662 173.576C162.811 173.672 162.886 173.8 162.886 173.96V174.536C163.046 174.227 163.307 173.949 163.67 173.704C164.043 173.448 164.497 173.32 165.03 173.32C165.531 173.32 165.99 173.464 166.406 173.752C166.833 174.029 167.174 174.408 167.43 174.888C167.686 175.357 167.814 175.885 167.814 176.472V180.44C167.814 180.621 167.723 180.76 167.542 180.856C167.371 180.952 167.179 181 166.966 181C166.774 181 166.587 180.952 166.406 180.856C166.225 180.76 166.134 180.621 166.134 180.44V176.472C166.134 176.195 166.059 175.928 165.91 175.672C165.771 175.416 165.579 175.208 165.334 175.048C165.089 174.888 164.817 174.808 164.518 174.808C164.262 174.808 164.017 174.877 163.782 175.016C163.547 175.144 163.355 175.331 163.206 175.576C163.057 175.821 162.982 176.12 162.982 176.472V180.44C162.982 180.579 162.897 180.707 162.726 180.824C162.566 180.941 162.369 181 162.134 181ZM171.809 181.128C171.287 181.128 170.817 181.064 170.401 180.936C169.985 180.808 169.655 180.648 169.409 180.456C169.175 180.253 169.057 180.051 169.057 179.848C169.057 179.752 169.079 179.645 169.121 179.528C169.175 179.411 169.244 179.309 169.329 179.224C169.425 179.139 169.527 179.096 169.633 179.096C169.772 179.096 169.916 179.16 170.065 179.288C170.225 179.405 170.433 179.528 170.689 179.656C170.945 179.773 171.303 179.832 171.761 179.832C172.295 179.832 172.652 179.741 172.833 179.56C173.025 179.379 173.121 179.181 173.121 178.968C173.121 178.691 173.025 178.477 172.833 178.328C172.652 178.168 172.412 178.04 172.113 177.944C171.825 177.848 171.516 177.757 171.185 177.672C170.855 177.576 170.54 177.453 170.241 177.304C169.953 177.155 169.713 176.947 169.521 176.68C169.34 176.413 169.249 176.061 169.249 175.624C169.249 175.261 169.34 174.904 169.521 174.552C169.703 174.189 169.991 173.896 170.385 173.672C170.791 173.437 171.329 173.32 172.001 173.32C172.407 173.32 172.791 173.363 173.153 173.448C173.516 173.533 173.815 173.651 174.049 173.8C174.284 173.939 174.401 174.093 174.401 174.264C174.401 174.339 174.375 174.445 174.321 174.584C174.268 174.712 174.193 174.829 174.097 174.936C174.012 175.032 173.9 175.08 173.761 175.08C173.655 175.08 173.521 175.043 173.361 174.968C173.201 174.883 173.015 174.803 172.801 174.728C172.588 174.653 172.327 174.616 172.017 174.616C171.708 174.616 171.457 174.669 171.265 174.776C171.084 174.872 170.951 174.989 170.865 175.128C170.78 175.267 170.737 175.405 170.737 175.544C170.737 175.779 170.828 175.96 171.009 176.088C171.191 176.216 171.431 176.323 171.729 176.408C172.028 176.493 172.343 176.584 172.673 176.68C173.004 176.765 173.313 176.893 173.601 177.064C173.9 177.235 174.14 177.464 174.321 177.752C174.513 178.04 174.609 178.424 174.609 178.904C174.609 179.576 174.364 180.115 173.873 180.52C173.393 180.925 172.705 181.128 171.809 181.128ZM176.821 177.992C176.651 177.992 176.496 177.949 176.357 177.864C176.229 177.779 176.165 177.651 176.165 177.48C176.165 176.701 176.149 175.88 176.117 175.016C176.085 174.152 176.053 173.288 176.021 172.424C175.989 171.549 175.973 170.728 175.973 169.96C175.973 169.715 176.053 169.528 176.213 169.4C176.373 169.261 176.576 169.192 176.821 169.192C177.056 169.192 177.253 169.261 177.413 169.4C177.584 169.528 177.669 169.715 177.669 169.96C177.669 170.728 177.653 171.549 177.621 172.424C177.589 173.288 177.557 174.152 177.525 175.016C177.493 175.88 177.477 176.701 177.477 177.48C177.477 177.651 177.403 177.779 177.253 177.864C177.104 177.949 176.96 177.992 176.821 177.992ZM176.837 181.096C176.56 181.096 176.331 181 176.149 180.808C175.968 180.616 175.877 180.392 175.877 180.136C175.877 179.869 175.968 179.645 176.149 179.464C176.331 179.272 176.56 179.176 176.837 179.176C177.093 179.176 177.312 179.272 177.493 179.464C177.685 179.645 177.781 179.869 177.781 180.136C177.781 180.392 177.685 180.616 177.493 180.808C177.312 181 177.093 181.096 176.837 181.096Z\" fill=\"#FF0082\"/> <g id=\"gameplayInstructionsBtn\" filter=\"url(#filter1_d_1192_50369)\"> <path d=\"M98 217H161C166.523 217 171 221.477 171 227V246H108C102.477 246 98 241.523 98 236V217Z\" fill=\"white\"/> <path d=\"M98.5 217.5H161C166.247 217.5 170.5 221.753 170.5 227V245.5H108C102.753 245.5 98.5 241.247 98.5 236V217.5Z\" stroke=\"#F7CFE5\"/> <path d=\"M120.219 237C119.995 237 119.785 236.953 119.589 236.86C119.402 236.757 119.309 236.608 119.309 236.412V227.34C119.309 227.144 119.402 226.999 119.589 226.906C119.785 226.813 119.995 226.766 120.219 226.766C120.443 226.766 120.625 226.789 120.765 226.836C120.914 226.883 121.049 226.976 121.171 227.116C121.301 227.247 121.437 227.452 121.577 227.732L124.279 232.954V227.34C124.279 227.135 124.372 226.99 124.559 226.906C124.755 226.813 124.965 226.766 125.189 226.766C125.422 226.766 125.632 226.813 125.819 226.906C126.005 226.99 126.099 227.135 126.099 227.34V236.412C126.099 236.608 126.005 236.757 125.819 236.86C125.632 236.953 125.422 237 125.189 237C124.974 237 124.773 236.958 124.587 236.874C124.409 236.79 124.265 236.641 124.153 236.426L121.129 230.798V236.412C121.129 236.608 121.035 236.757 120.849 236.86C120.662 236.953 120.452 237 120.219 237ZM128.597 237C128.401 237 128.219 236.953 128.051 236.86C127.883 236.757 127.799 236.608 127.799 236.412V227.354C127.799 227.158 127.883 227.013 128.051 226.92C128.219 226.817 128.401 226.766 128.597 226.766H133.581C133.786 226.766 133.931 226.85 134.015 227.018C134.108 227.186 134.155 227.363 134.155 227.55C134.155 227.774 134.104 227.965 134.001 228.124C133.908 228.283 133.768 228.362 133.581 228.362H129.619V231.162H131.747C131.934 231.162 132.074 231.237 132.167 231.386C132.27 231.526 132.321 231.694 132.321 231.89C132.321 232.049 132.274 232.207 132.181 232.366C132.097 232.515 131.952 232.59 131.747 232.59H129.619V235.404H133.581C133.768 235.404 133.908 235.483 134.001 235.642C134.104 235.801 134.155 235.992 134.155 236.216C134.155 236.403 134.108 236.58 134.015 236.748C133.931 236.916 133.786 237 133.581 237H128.597ZM135.755 237.07C135.587 237.07 135.409 237.028 135.223 236.944C135.036 236.86 134.877 236.753 134.747 236.622C134.616 236.482 134.551 236.328 134.551 236.16C134.551 236.057 134.588 235.945 134.663 235.824L137.085 231.876L134.747 227.942C134.663 227.811 134.621 227.681 134.621 227.55C134.621 227.391 134.681 227.247 134.803 227.116C134.924 226.985 135.073 226.883 135.251 226.808C135.437 226.733 135.615 226.696 135.783 226.696C135.932 226.696 136.053 226.733 136.147 226.808C136.249 226.873 136.329 226.967 136.385 227.088L138.289 230.518L140.207 227.088C140.272 226.967 140.351 226.873 140.445 226.808C140.547 226.733 140.669 226.696 140.809 226.696C140.986 226.696 141.163 226.733 141.341 226.808C141.518 226.883 141.667 226.985 141.789 227.116C141.91 227.247 141.971 227.391 141.971 227.55C141.971 227.681 141.929 227.811 141.845 227.942L139.507 231.876L141.929 235.824C142.003 235.945 142.041 236.057 142.041 236.16C142.041 236.328 141.975 236.482 141.845 236.622C141.714 236.753 141.555 236.86 141.369 236.944C141.191 237.028 141.014 237.07 140.837 237.07C140.734 237.07 140.636 237.042 140.543 236.986C140.459 236.93 140.393 236.86 140.347 236.776L138.289 233.178L136.245 236.776C136.198 236.86 136.128 236.93 136.035 236.986C135.951 237.042 135.857 237.07 135.755 237.07ZM145.871 237C145.638 237 145.428 236.953 145.241 236.86C145.054 236.757 144.961 236.608 144.961 236.412V228.404H142.903C142.726 228.404 142.586 228.32 142.483 228.152C142.38 227.984 142.329 227.793 142.329 227.578C142.329 227.382 142.376 227.2 142.469 227.032C142.562 226.855 142.707 226.766 142.903 226.766H148.825C149.03 226.766 149.175 226.855 149.259 227.032C149.352 227.2 149.399 227.382 149.399 227.578C149.399 227.793 149.348 227.984 149.245 228.152C149.152 228.32 149.012 228.404 148.825 228.404H146.781V236.412C146.781 236.608 146.683 236.757 146.487 236.86C146.3 236.953 146.095 237 145.871 237Z\" fill=\"#FF0082\"/> </g> </g> <defs> <filter id=\"filter0_d_1192_50369\" x=\"0\" y=\"0\" width=\"275\" height=\"275\" filterUnits=\"userSpaceOnUse\" color-interpolation-filters=\"sRGB\"> <feFlood flood-opacity=\"0\" result=\"BackgroundImageFix\"/> <feColorMatrix in=\"SourceAlpha\" type=\"matrix\" values=\"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0\" result=\"hardAlpha\"/> <feOffset dx=\"5\" dy=\"5\"/> <feComposite in2=\"hardAlpha\" operator=\"out\"/> <feColorMatrix type=\"matrix\" values=\"0 0 0 0 0.956863 0 0 0 0 0.490196 0 0 0 0 0.380392 0 0 0 1 0\"/> <feBlend mode=\"normal\" in2=\"BackgroundImageFix\" result=\"effect1_dropShadow_1192_50369\"/> <feBlend mode=\"normal\" in=\"SourceGraphic\" in2=\"effect1_dropShadow_1192_50369\" result=\"shape\"/> </filter> <filter id=\"filter1_d_1192_50369\" x=\"98\" y=\"217\" width=\"75\" height=\"31\" filterUnits=\"userSpaceOnUse\" color-interpolation-filters=\"sRGB\"> <feFlood flood-opacity=\"0\" result=\"BackgroundImageFix\"/> <feColorMatrix in=\"SourceAlpha\" type=\"matrix\" values=\"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0\" result=\"hardAlpha\"/> <feOffset dx=\"2\" dy=\"2\"/> <feComposite in2=\"hardAlpha\" operator=\"out\"/> <feColorMatrix type=\"matrix\" values=\"0 0 0 0 1 0 0 0 0 0 0 0 0 0 0.509804 0 0 0 1 0\"/> <feBlend mode=\"normal\" in2=\"BackgroundImageFix\" result=\"effect1_dropShadow_1192_50369\"/> <feBlend mode=\"normal\" in=\"SourceGraphic\" in2=\"effect1_dropShadow_1192_50369\" result=\"shape\"/> </filter> </defs> </svg>") // EJsS HtmlView.HtmlView Page: setting property 'Html' for element 'gameplayInstructions'
      .setProperty("Display","none") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'gameplayInstructions'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"gameScreen", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'gameScreen'
      .setProperty("CSS",{"opacity": "0","position": "absolute", "height": "100%", "width": "100%", "top": "0", "left": "0", "z-index": "-1"}) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'gameScreen'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'gameScreen'
      ;

    _view._addElement(EJSS_INTERFACE.wrappedPanel,"wrappedPanel", _view.gameScreen) // EJsS HtmlView.HtmlView Page: declaration of element 'wrappedPanel'
      .setProperty("CSS",{ "display":"block"}) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'wrappedPanel'
      ;

    _view._addElement(EJSS_DRAWING2D.plottingPanel,"plottingPanel", _view.wrappedPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'plottingPanel'
      .setProperty("Width","100%") // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'plottingPanel'
      .setProperty("Gutters",[0,0,0,0]) // EJsS HtmlView.HtmlView Page: setting property 'Gutters' for element 'plottingPanel'
      .setProperty("AxisYLineColor","White") // EJsS HtmlView.HtmlView Page: setting property 'AxisYLineColor' for element 'plottingPanel'
      .setProperty("XFixedTick",0) // EJsS HtmlView.HtmlView Page: setting property 'XFixedTick' for element 'plottingPanel'
      .setProperty("GuttersLineColor","White") // EJsS HtmlView.HtmlView Page: setting property 'GuttersLineColor' for element 'plottingPanel'
      .setProperty("AxisXShow",false) // EJsS HtmlView.HtmlView Page: setting property 'AxisXShow' for element 'plottingPanel'
      .setProperty("YFixedTick",0) // EJsS HtmlView.HtmlView Page: setting property 'YFixedTick' for element 'plottingPanel'
      .setProperty("XTickStep",1) // EJsS HtmlView.HtmlView Page: setting property 'XTickStep' for element 'plottingPanel'
      .setProperty("YTickStep",10) // EJsS HtmlView.HtmlView Page: setting property 'YTickStep' for element 'plottingPanel'
      .setProperty("XAutoTicks",false) // EJsS HtmlView.HtmlView Page: setting property 'XAutoTicks' for element 'plottingPanel'
      .setProperty("GridXLineColor","White") // EJsS HtmlView.HtmlView Page: setting property 'GridXLineColor' for element 'plottingPanel'
      .setProperty("Enabled",true) // EJsS HtmlView.HtmlView Page: setting property 'Enabled' for element 'plottingPanel'
      .setProperty("Title","") // EJsS HtmlView.HtmlView Page: setting property 'Title' for element 'plottingPanel'
      .setProperty("YAutoTicks",false) // EJsS HtmlView.HtmlView Page: setting property 'YAutoTicks' for element 'plottingPanel'
      .setProperty("GridYLineColor","White") // EJsS HtmlView.HtmlView Page: setting property 'GridYLineColor' for element 'plottingPanel'
      .setProperty("AxisXLineColor","White") // EJsS HtmlView.HtmlView Page: setting property 'AxisXLineColor' for element 'plottingPanel'
      .setProperty("MinimumY",0) // EJsS HtmlView.HtmlView Page: setting property 'MinimumY' for element 'plottingPanel'
      .setProperty("AxisYShow",false) // EJsS HtmlView.HtmlView Page: setting property 'AxisYShow' for element 'plottingPanel'
      .setProperty("TitleY","") // EJsS HtmlView.HtmlView Page: setting property 'TitleY' for element 'plottingPanel'
      .setProperty("TitleX","") // EJsS HtmlView.HtmlView Page: setting property 'TitleX' for element 'plottingPanel'
      .setProperty("GuttersColor","White") // EJsS HtmlView.HtmlView Page: setting property 'GuttersColor' for element 'plottingPanel'
      ;

    _view._addElement(EJSS_DRAWING2D.image,"background", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'background'
      .setProperty("SizeX",11.075) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'background'
      .setProperty("X",5.45) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'background'
      .setProperty("Y",3.25) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'background'
      .setProperty("ImageUrl","./sustainability/images/background.svg") // EJsS HtmlView.HtmlView Page: setting property 'ImageUrl' for element 'background'
      .setProperty("SizeY",6.55) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'background'
      ;

    _view._addElement(EJSS_DRAWING2D.group,"bins", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'bins'
      .setProperty("Y",.75) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'bins'
      ;

    _view._addElement(EJSS_DRAWING2D.image,"recycle", _view.bins) // EJsS HtmlView.HtmlView Page: declaration of element 'recycle'
      .setProperty("Sensitivity",0) // EJsS HtmlView.HtmlView Page: setting property 'Sensitivity' for element 'recycle'
      .setProperty("ImageUrl","./sustainability/images/recycle-bin-opentop.svg") // EJsS HtmlView.HtmlView Page: setting property 'ImageUrl' for element 'recycle'
      .setProperty("PixelSize",true) // EJsS HtmlView.HtmlView Page: setting property 'PixelSize' for element 'recycle'
      .setProperty("EnabledPosition","ENABLED_X") // EJsS HtmlView.HtmlView Page: setting property 'EnabledPosition' for element 'recycle'
      ;

    _view._addElement(EJSS_DRAWING2D.image,"r_correct", _view.bins) // EJsS HtmlView.HtmlView Page: declaration of element 'r_correct'
      .setProperty("ImageUrl","./sustainability/images/green-tick.svg") // EJsS HtmlView.HtmlView Page: setting property 'ImageUrl' for element 'r_correct'
      .setProperty("Y",0.25) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'r_correct'
      .setProperty("Visibility",false) // EJsS HtmlView.HtmlView Page: setting property 'Visibility' for element 'r_correct'
      ;

    _view._addElement(EJSS_DRAWING2D.image,"r_incorrect", _view.bins) // EJsS HtmlView.HtmlView Page: declaration of element 'r_incorrect'
      .setProperty("ImageUrl","./sustainability/images/red-cross.svg") // EJsS HtmlView.HtmlView Page: setting property 'ImageUrl' for element 'r_incorrect'
      .setProperty("Y",0.25) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'r_incorrect'
      .setProperty("Visibility",false) // EJsS HtmlView.HtmlView Page: setting property 'Visibility' for element 'r_incorrect'
      ;

    _view._addElement(EJSS_DRAWING2D.image,"waste", _view.bins) // EJsS HtmlView.HtmlView Page: declaration of element 'waste'
      .setProperty("Sensitivity",0) // EJsS HtmlView.HtmlView Page: setting property 'Sensitivity' for element 'waste'
      .setProperty("ImageUrl","./sustainability/images/waste-bin-opentop.svg") // EJsS HtmlView.HtmlView Page: setting property 'ImageUrl' for element 'waste'
      .setProperty("PixelSize",true) // EJsS HtmlView.HtmlView Page: setting property 'PixelSize' for element 'waste'
      .setProperty("EnabledPosition","ENABLED_X") // EJsS HtmlView.HtmlView Page: setting property 'EnabledPosition' for element 'waste'
      ;

    _view._addElement(EJSS_DRAWING2D.image,"w_correct", _view.bins) // EJsS HtmlView.HtmlView Page: declaration of element 'w_correct'
      .setProperty("ImageUrl","./sustainability/images/green-tick.svg") // EJsS HtmlView.HtmlView Page: setting property 'ImageUrl' for element 'w_correct'
      .setProperty("Y",0.25) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'w_correct'
      .setProperty("Visibility",false) // EJsS HtmlView.HtmlView Page: setting property 'Visibility' for element 'w_correct'
      ;

    _view._addElement(EJSS_DRAWING2D.image,"w_incorrect", _view.bins) // EJsS HtmlView.HtmlView Page: declaration of element 'w_incorrect'
      .setProperty("ImageUrl","./sustainability/images/red-cross.svg") // EJsS HtmlView.HtmlView Page: setting property 'ImageUrl' for element 'w_incorrect'
      .setProperty("Y",0.25) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'w_incorrect'
      .setProperty("Visibility",false) // EJsS HtmlView.HtmlView Page: setting property 'Visibility' for element 'w_incorrect'
      ;

    _view._addElement(EJSS_DRAWING2D.image,"instructions", _view.bins) // EJsS HtmlView.HtmlView Page: declaration of element 'instructions'
      .setProperty("SizeX",2.5) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'instructions'
      .setProperty("ImageUrl","./sustainability/images/clickanddrag.svg") // EJsS HtmlView.HtmlView Page: setting property 'ImageUrl' for element 'instructions'
      .setProperty("Y",-.5) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'instructions'
      .setProperty("SizeY",.3) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'instructions'
      ;

    _view._addElement(EJSS_DRAWING2D.image,"invisibleDragger", _view.bins) // EJsS HtmlView.HtmlView Page: declaration of element 'invisibleDragger'
      .setProperty("Sensitivity",0) // EJsS HtmlView.HtmlView Page: setting property 'Sensitivity' for element 'invisibleDragger'
      .setProperty("ImageUrl","./sustainability/images/recycle-bin.svg") // EJsS HtmlView.HtmlView Page: setting property 'ImageUrl' for element 'invisibleDragger'
      .setProperty("PixelSize",true) // EJsS HtmlView.HtmlView Page: setting property 'PixelSize' for element 'invisibleDragger'
      .setProperty("EnabledPosition","ENABLED_X") // EJsS HtmlView.HtmlView Page: setting property 'EnabledPosition' for element 'invisibleDragger'
      ;

    _view._addElement(EJSS_DRAWING2D.group,"recyclableName", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'recyclableName'
      .setProperty("X",1.4) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'recyclableName'
      ;

    _view._addElement(EJSS_DRAWING2D.image,"image", _view.recyclableName) // EJsS HtmlView.HtmlView Page: declaration of element 'image'
      .setProperty("ImageUrl","./sustainability/images/recyclable-label.svg") // EJsS HtmlView.HtmlView Page: setting property 'ImageUrl' for element 'image'
      .setProperty("PixelSize",true) // EJsS HtmlView.HtmlView Page: setting property 'PixelSize' for element 'image'
      ;

    _view._addElement(EJSS_DRAWING2D.text,"text", _view.recyclableName) // EJsS HtmlView.HtmlView Page: declaration of element 'text'
      .setProperty("FontFamily","Dosis-Bold") // EJsS HtmlView.HtmlView Page: setting property 'FontFamily' for element 'text'
      .setProperty("FillColor","#FF0082") // EJsS HtmlView.HtmlView Page: setting property 'FillColor' for element 'text'
      ;

    _view._addElement(EJSS_DRAWING2D.image,"recyclableItem", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'recyclableItem'
      .setProperty("PixelSize",true) // EJsS HtmlView.HtmlView Page: setting property 'PixelSize' for element 'recyclableItem'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"progressBarContainer", _view.gameScreen) // EJsS HtmlView.HtmlView Page: declaration of element 'progressBarContainer'
      .setProperty("ClassName","pbar-boxshadow-primarypink border-yellow") // EJsS HtmlView.HtmlView Page: setting property 'ClassName' for element 'progressBarContainer'
      .setProperty("Html","<div id=\"progressBar\" class=\"bg-apricot\">     <div id=\"progressLevel\" class=\"emptybar bg-blush border-yellow\" style=\"width: 0; transition: .1s linear; margin-bottom: 40px\"></div>     <div class=\"divider\"></div>     <img src=\"./sustainability/images/progress-checkmark.svg\" alt=\"progress checkmark\" />     <div class=\"divider\"></div>     <img src=\"./sustainability/images/progress-checkmark.svg\" alt=\"progress checkmark\" />     <div class=\"divider\"></div>     <img src=\"./sustainability/images/progress-checkmark.svg\" alt=\"progress checkmark\" />     <div class=\"divider\"></div>     <img src=\"./sustainability/images/progress-checkmark.svg\" alt=\"progress checkmark\" />     <div class=\"divider\"></div>     <img src=\"./sustainability/images/progress-checkmark.svg\" alt=\"progress checkmark\" />     <div class=\"divider\"></div>   </div>") // EJsS HtmlView.HtmlView Page: setting property 'Html' for element 'progressBarContainer'
      .setProperty("Display","none") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'progressBarContainer'
      ;

    _view._addElement(EJSS_INTERFACE.audio,"backgroundMusic", _view.gameScreen) // EJsS HtmlView.HtmlView Page: declaration of element 'backgroundMusic'
      .setProperty("Loop",true) // EJsS HtmlView.HtmlView Page: setting property 'Loop' for element 'backgroundMusic'
      .setProperty("Volume",0.3) // EJsS HtmlView.HtmlView Page: setting property 'Volume' for element 'backgroundMusic'
      .setProperty("AudioUrl","./sustainability/audio/Komiku_-_13_-_Good_Fellow.mp3") // EJsS HtmlView.HtmlView Page: setting property 'AudioUrl' for element 'backgroundMusic'
      ;

    _view._addElement(EJSS_INTERFACE.audio,"correctSound", _view.gameScreen) // EJsS HtmlView.HtmlView Page: declaration of element 'correctSound'
      .setProperty("AudioUrl","./sustainability/audio/correct.mp3") // EJsS HtmlView.HtmlView Page: setting property 'AudioUrl' for element 'correctSound'
      ;

    _view._addElement(EJSS_INTERFACE.audio,"wrongSound", _view.gameScreen) // EJsS HtmlView.HtmlView Page: declaration of element 'wrongSound'
      .setProperty("AudioUrl","./sustainability/audio/incorrect.mp3") // EJsS HtmlView.HtmlView Page: setting property 'AudioUrl' for element 'wrongSound'
      ;

    _view._addElement(EJSS_INTERFACE.audio,"landOnFloor", _view.gameScreen) // EJsS HtmlView.HtmlView Page: declaration of element 'landOnFloor'
      .setProperty("Volume",1) // EJsS HtmlView.HtmlView Page: setting property 'Volume' for element 'landOnFloor'
      .setProperty("AudioUrl","./sustainability/audio/hit_ground.mp3") // EJsS HtmlView.HtmlView Page: setting property 'AudioUrl' for element 'landOnFloor'
      ;

    _view._addElement(EJSS_INTERFACE.audio,"itemThrownSound", _view.gameScreen) // EJsS HtmlView.HtmlView Page: declaration of element 'itemThrownSound'
      .setProperty("AudioUrl","./sustainability/audio/throw.mp3") // EJsS HtmlView.HtmlView Page: setting property 'AudioUrl' for element 'itemThrownSound'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"soundControl_Mute", _view.gameScreen) // EJsS HtmlView.HtmlView Page: declaration of element 'soundControl_Mute'
      .setProperty("Html","<svg width=\"26\" height=\"26\" viewBox=\"0 0 26 26\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"> <g filter=\"url(#filter0_d_1416_53)\"> <circle cx=\"12.5\" cy=\"12.5\" r=\"12.5\" fill=\"#F9E6E0\"/> <circle cx=\"12.5\" cy=\"12.5\" r=\"12\" stroke=\"#FFD208\"/> </g> <path d=\"M13.7113 7.12681C13.8046 7.05767 13.9137 7.0151 14.0278 7.00333C14.142 6.99157 14.2571 7.01104 14.3617 7.05979C14.4663 7.10855 14.5567 7.18488 14.6239 7.28116C14.6912 7.37745 14.7328 7.49033 14.7448 7.60852L14.7484 7.67892V17.3204C14.7484 17.4393 14.7183 17.5561 14.6612 17.6591C14.6041 17.7622 14.5218 17.8479 14.4227 17.9077C14.3236 17.9675 14.2111 17.9993 14.0964 18C13.9817 18.0007 13.8688 17.9701 13.7691 17.9115L13.7119 17.8732L9.78941 14.97H8.19206C7.89131 14.9701 7.60165 14.8524 7.38113 14.6405C7.16061 14.4286 7.02554 14.1382 7.00298 13.8275L7 13.7348V11.2645C7.00006 10.953 7.11371 10.6531 7.31818 10.4247C7.52266 10.1963 7.80286 10.0565 8.10265 10.0331L8.19206 10.0294H9.78941L13.7113 7.12681ZM16.2897 10.7532L17.1325 11.6264L17.9753 10.7532C18.0302 10.6942 18.096 10.6472 18.1687 10.6148C18.2414 10.5824 18.3197 10.5654 18.3988 10.5647C18.4779 10.564 18.5564 10.5796 18.6297 10.6106C18.7029 10.6417 18.7695 10.6876 18.8254 10.7455C18.8814 10.8035 18.9256 10.8725 18.9556 10.9484C18.9856 11.0243 19.0007 11.1056 19 11.1876C18.9993 11.2696 18.9828 11.3506 18.9516 11.426C18.9204 11.5013 18.875 11.5695 18.818 11.6264L17.9753 12.4997L18.818 13.3729C18.9299 13.4887 18.9927 13.6458 18.9928 13.8096C18.9929 13.9735 18.9301 14.1306 18.8183 14.2465C18.7066 14.3624 18.555 14.4275 18.3969 14.4276C18.2387 14.4276 18.0871 14.3626 17.9753 14.2468L17.1325 13.3723L16.2897 14.2462C16.1779 14.362 16.0262 14.427 15.8681 14.4269C15.71 14.4269 15.5584 14.3617 15.4466 14.2459C15.3348 14.13 15.2721 13.9728 15.2721 13.809C15.2722 13.6452 15.3351 13.4881 15.4469 13.3723L16.2897 12.4997L15.4469 11.6264C15.39 11.5695 15.3446 11.5013 15.3133 11.426C15.2821 11.3506 15.2657 11.2696 15.265 11.1876C15.2643 11.1056 15.2794 11.0243 15.3093 10.9484C15.3393 10.8725 15.3836 10.8035 15.4395 10.7455C15.4955 10.6876 15.562 10.6417 15.6353 10.6106C15.7085 10.5796 15.787 10.564 15.8662 10.5647C15.9453 10.5654 16.0235 10.5824 16.0962 10.6148C16.1689 10.6472 16.2347 10.6942 16.2897 10.7532Z\" fill=\"#F47D61\"/> <defs> <filter id=\"filter0_d_1416_53\" x=\"0\" y=\"0\" width=\"26\" height=\"26\" filterUnits=\"userSpaceOnUse\" color-interpolation-filters=\"sRGB\"> <feFlood flood-opacity=\"0\" result=\"BackgroundImageFix\"/> <feColorMatrix in=\"SourceAlpha\" type=\"matrix\" values=\"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0\" result=\"hardAlpha\"/> <feOffset dx=\"1\" dy=\"1\"/> <feComposite in2=\"hardAlpha\" operator=\"out\"/> <feColorMatrix type=\"matrix\" values=\"0 0 0 0 0.980392 0 0 0 0 0.501961 0 0 0 0 0.341176 0 0 0 1 0\"/> <feBlend mode=\"normal\" in2=\"BackgroundImageFix\" result=\"effect1_dropShadow_1416_53\"/> <feBlend mode=\"normal\" in=\"SourceGraphic\" in2=\"effect1_dropShadow_1416_53\" result=\"shape\"/> </filter> </defs> </svg>") // EJsS HtmlView.HtmlView Page: setting property 'Html' for element 'soundControl_Mute'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"soundControl_Play", _view.gameScreen) // EJsS HtmlView.HtmlView Page: declaration of element 'soundControl_Play'
      .setProperty("Html","<svg width=\"26\" height=\"26\" viewBox=\"0 0 26 26\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"> <g filter=\"url(#filter0_d_1416_56)\"> <circle cx=\"12.5\" cy=\"12.5\" r=\"12.5\" fill=\"#F9E6E0\"/> <circle cx=\"12.5\" cy=\"12.5\" r=\"12\" stroke=\"#FFD208\"/> </g> <path d=\"M12.6179 7.05734C12.732 7.10722 12.8286 7.18719 12.8964 7.28778C12.9641 7.38837 13.0002 7.50536 13.0003 7.62488V16.3755C13 16.4949 12.9639 16.6118 12.8961 16.7123C12.8284 16.8128 12.7319 16.8927 12.618 16.9426C12.5041 16.9926 12.3776 17.0104 12.2534 16.9941C12.1292 16.9778 12.0125 16.928 11.917 16.8506L9.03813 14.5004H7.53132C7.12519 14.5004 6.73569 14.3467 6.44851 14.0732C6.16133 13.7997 6 13.4288 6 13.0419V10.9585C6 10.1534 6.68603 9.50002 7.53132 9.50002H9.03901L11.917 7.14984C12.0124 7.07226 12.129 7.02231 12.2533 7.00592C12.3775 6.98952 12.504 7.00737 12.6179 7.05734ZM11.6878 8.98331L9.70841 10.5993C9.58962 10.6966 9.43811 10.7501 9.2814 10.7501H7.53132C7.4733 10.7501 7.41766 10.7721 7.37663 10.8111C7.33561 10.8502 7.31256 10.9032 7.31256 10.9585V13.0419C7.31256 13.157 7.41056 13.2503 7.53132 13.2503H9.2814C9.43803 13.2503 9.58941 13.3036 9.70841 13.4003L11.6878 15.0171V8.98331ZM17.022 7.28485C17.145 7.1678 17.3118 7.10206 17.4858 7.10206C17.6597 7.10206 17.8265 7.1678 17.9495 7.28485C18.5996 7.90396 19.1153 8.63896 19.4671 9.44788C19.8189 10.2568 20 11.1238 20 11.9994C20 12.8749 19.8189 13.7419 19.4671 14.5509C19.1153 15.3598 18.5996 16.0948 17.9495 16.7139C17.825 16.8242 17.6605 16.8843 17.4905 16.8815C17.3204 16.8787 17.1581 16.8133 17.0377 16.6989C16.9176 16.5842 16.8489 16.4297 16.846 16.2677C16.843 16.1058 16.9061 15.949 17.022 15.8305C17.5502 15.3275 17.9692 14.7303 18.2551 14.073C18.541 13.4157 18.6882 12.7112 18.6882 11.9998C18.6882 11.2883 18.541 10.5839 18.2551 9.9266C17.9692 9.26932 17.5502 8.67212 17.022 8.16909C16.8991 8.05189 16.8301 7.89302 16.8301 7.72739C16.8301 7.56175 16.8991 7.40205 17.022 7.28485ZM16.0944 9.05249L16.0936 9.05332C16.9138 9.83474 17.3746 10.8944 17.3746 11.9994C17.3746 13.1043 16.9138 14.164 16.0936 14.9454C16.0134 15.0277 15.9113 15.0878 15.7982 15.1195C15.6851 15.1512 15.5652 15.1532 15.4509 15.1254C15.3367 15.0976 15.2325 15.041 15.1493 14.9615C15.066 14.882 15.0068 14.7826 14.9779 14.6737C14.9487 14.5651 14.9507 14.4509 14.9838 14.3433C15.0169 14.2356 15.0799 14.1385 15.166 14.062C15.4505 13.7912 15.6761 13.4696 15.83 13.1157C15.9839 12.7618 16.0632 12.3824 16.0632 11.9994C16.0632 11.6163 15.9839 11.237 15.83 10.8831C15.6761 10.5291 15.4505 10.2076 15.166 9.93672C15.0429 9.81946 14.9738 9.66043 14.9738 9.4946C14.9738 9.32878 15.0429 9.16974 15.166 9.05249C15.2891 8.93523 15.4561 8.86936 15.6302 8.86936C15.8044 8.86936 15.9713 8.93523 16.0944 9.05249Z\" fill=\"#FFD208\"/> <path d=\"M12.1805 7.92947C12.2542 7.87709 12.3405 7.84483 12.4307 7.83592C12.5209 7.82701 12.6119 7.84176 12.6946 7.8787C12.7773 7.91563 12.8488 7.97346 12.9019 8.04641C12.9551 8.11936 12.988 8.20488 12.9975 8.29443L13.0003 8.34777V15.6525C13.0003 15.7425 12.9766 15.831 12.9314 15.9091C12.8862 15.9871 12.8212 16.0521 12.7429 16.0974C12.6645 16.1427 12.5756 16.1668 12.4849 16.1673C12.3942 16.1678 12.305 16.1447 12.2262 16.1003L12.1809 16.0713L9.08014 13.8717H7.81739C7.57964 13.8718 7.35066 13.7826 7.17633 13.6221C7.00201 13.4616 6.89523 13.2415 6.87739 13.0061L6.87504 12.9359V11.0643C6.87508 10.8283 6.96493 10.6011 7.12657 10.4281C7.28821 10.255 7.50972 10.1491 7.74671 10.1314L7.81739 10.1286H9.08014L12.1805 7.92947Z\" fill=\"#FFD208\"/> <defs> <filter id=\"filter0_d_1416_56\" x=\"0\" y=\"0\" width=\"26\" height=\"26\" filterUnits=\"userSpaceOnUse\" color-interpolation-filters=\"sRGB\"> <feFlood flood-opacity=\"0\" result=\"BackgroundImageFix\"/> <feColorMatrix in=\"SourceAlpha\" type=\"matrix\" values=\"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0\" result=\"hardAlpha\"/> <feOffset dx=\"1\" dy=\"1\"/> <feComposite in2=\"hardAlpha\" operator=\"out\"/> <feColorMatrix type=\"matrix\" values=\"0 0 0 0 0.980392 0 0 0 0 0.501961 0 0 0 0 0.341176 0 0 0 1 0\"/> <feBlend mode=\"normal\" in2=\"BackgroundImageFix\" result=\"effect1_dropShadow_1416_56\"/> <feBlend mode=\"normal\" in=\"SourceGraphic\" in2=\"effect1_dropShadow_1416_56\" result=\"shape\"/> </filter> </defs> </svg>") // EJsS HtmlView.HtmlView Page: setting property 'Html' for element 'soundControl_Play'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"cereal_right", _view.gameScreen) // EJsS HtmlView.HtmlView Page: declaration of element 'cereal_right'
      .setProperty("Html","<svg width=\"275\" height=\"222\" viewBox=\"0 0 275 222\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"> <g filter=\"url(#filter0_d_1192_50796)\"> <rect width=\"270\" height=\"217\" rx=\"50\" fill=\"#F9E6E0\"/> <rect x=\"0.5\" y=\"0.5\" width=\"269\" height=\"216\" rx=\"49.5\" stroke=\"#FFD208\"/> <path d=\"M90.113 50C89.7797 50 89.4797 49.9333 89.213 49.8C88.9464 49.6533 88.813 49.44 88.813 49.16V37.72H85.873C85.6197 37.72 85.4197 37.6 85.273 37.36C85.1264 37.12 85.053 36.8467 85.053 36.54C85.053 36.26 85.1197 36 85.253 35.76C85.3864 35.5067 85.593 35.38 85.873 35.38H94.333C94.6264 35.38 94.833 35.5067 94.953 35.76C95.0864 36 95.153 36.26 95.153 36.54C95.153 36.8467 95.0797 37.12 94.933 37.36C94.7997 37.6 94.5997 37.72 94.333 37.72H91.413V49.16C91.413 49.44 91.273 49.6533 90.993 49.8C90.7264 49.9333 90.433 50 90.113 50ZM97.6418 50C97.2685 50 96.9618 49.9133 96.7218 49.74C96.4818 49.5667 96.3618 49.3733 96.3618 49.16V35.76C96.3618 35.52 96.4818 35.3267 96.7218 35.18C96.9618 35.0333 97.2685 34.96 97.6418 34.96C98.0018 34.96 98.3085 35.0333 98.5618 35.18C98.8151 35.3267 98.9418 35.52 98.9418 35.76V41.9C99.1418 41.5133 99.4551 41.1667 99.8818 40.86C100.308 40.54 100.835 40.38 101.462 40.38C102.088 40.38 102.662 40.5667 103.182 40.94C103.702 41.3 104.115 41.7867 104.422 42.4C104.742 43.0133 104.902 43.6933 104.902 44.44V49.16C104.902 49.44 104.768 49.6533 104.502 49.8C104.235 49.9333 103.935 50 103.602 50C103.308 50 103.022 49.9333 102.742 49.8C102.462 49.6533 102.322 49.44 102.322 49.16V44.44C102.322 44.1333 102.242 43.8467 102.082 43.58C101.922 43.3133 101.708 43.0933 101.442 42.92C101.188 42.7333 100.902 42.64 100.582 42.64C100.315 42.64 100.055 42.7133 99.8018 42.86C99.5485 43.0067 99.3418 43.2133 99.1818 43.48C99.0218 43.7467 98.9418 44.0667 98.9418 44.44V49.16C98.9418 49.3733 98.8151 49.5667 98.5618 49.74C98.3085 49.9133 98.0018 50 97.6418 50ZM108.87 50.18C108.163 50.18 107.55 49.9667 107.03 49.54C106.523 49.1 106.27 48.4267 106.27 47.52C106.27 46.76 106.463 46.1667 106.85 45.74C107.25 45.3133 107.797 45.0133 108.49 44.84C109.197 44.6667 110.01 44.58 110.93 44.58H111.75V44.32C111.75 44.0267 111.69 43.74 111.57 43.46C111.463 43.18 111.283 42.9467 111.03 42.76C110.79 42.5733 110.443 42.48 109.99 42.48C109.483 42.48 109.09 42.5333 108.81 42.64C108.543 42.7333 108.337 42.8333 108.19 42.94C108.043 43.0467 107.883 43.1 107.71 43.1C107.43 43.1 107.21 42.96 107.05 42.68C106.903 42.4 106.83 42.1133 106.83 41.82C106.83 41.54 106.997 41.2933 107.33 41.08C107.677 40.8533 108.097 40.68 108.59 40.56C109.083 40.44 109.563 40.38 110.03 40.38C111.07 40.38 111.903 40.5667 112.53 40.94C113.157 41.3133 113.61 41.7933 113.89 42.38C114.183 42.9667 114.33 43.6 114.33 44.28V49.16C114.33 49.4 114.21 49.6 113.97 49.76C113.73 49.92 113.43 50 113.07 50C112.737 50 112.457 49.92 112.23 49.76C112.017 49.6 111.91 49.4 111.91 49.16V48.6C111.55 49.0133 111.123 49.38 110.63 49.7C110.15 50.02 109.563 50.18 108.87 50.18ZM109.91 48.26C110.19 48.26 110.47 48.1667 110.75 47.98C111.03 47.7933 111.263 47.5533 111.45 47.26C111.65 46.9667 111.75 46.66 111.75 46.34V45.92H111.45C111.01 45.92 110.59 45.9467 110.19 46C109.79 46.0533 109.463 46.1733 109.21 46.36C108.97 46.5333 108.85 46.8067 108.85 47.18C108.85 47.5533 108.95 47.8267 109.15 48C109.363 48.1733 109.617 48.26 109.91 48.26ZM119.904 50C118.704 50 117.784 49.74 117.144 49.22C116.517 48.7 116.204 47.8733 116.204 46.74V37.06C116.204 36.82 116.344 36.6267 116.624 36.48C116.904 36.3333 117.191 36.26 117.484 36.26C117.804 36.26 118.097 36.3333 118.364 36.48C118.644 36.6267 118.784 36.82 118.784 37.06V40.5H121.144C121.357 40.5 121.517 40.6 121.624 40.8C121.744 40.9867 121.804 41.2 121.804 41.44C121.804 41.68 121.744 41.9 121.624 42.1C121.517 42.2867 121.357 42.38 121.144 42.38H118.784V46.74C118.784 47.14 118.864 47.42 119.024 47.58C119.197 47.74 119.491 47.82 119.904 47.82H120.684C121.057 47.82 121.331 47.9333 121.504 48.16C121.691 48.3867 121.784 48.6333 121.784 48.9C121.784 49.18 121.691 49.4333 121.504 49.66C121.331 49.8867 121.057 50 120.684 50H119.904ZM123.719 39.78C123.532 39.78 123.339 39.7267 123.139 39.62C122.952 39.5 122.859 39.3267 122.859 39.1C122.859 39.0067 122.886 38.9133 122.939 38.82L123.399 37.76C123.172 37.64 122.992 37.4733 122.859 37.26C122.726 37.0467 122.659 36.8067 122.659 36.54C122.659 36.1667 122.786 35.8467 123.039 35.58C123.306 35.3133 123.626 35.18 123.999 35.18C124.372 35.18 124.692 35.3133 124.959 35.58C125.226 35.8467 125.359 36.16 125.359 36.52C125.359 36.5867 125.346 36.6733 125.319 36.78C125.292 36.8867 125.239 37.04 125.159 37.24C125.092 37.4267 124.986 37.7 124.839 38.06C124.692 38.42 124.492 38.8867 124.239 39.46C124.199 39.5667 124.126 39.6467 124.019 39.7C123.912 39.7533 123.812 39.78 123.719 39.78ZM129.774 50.18C129.107 50.18 128.494 50.1 127.934 49.94C127.387 49.7667 126.954 49.5467 126.634 49.28C126.327 49.0133 126.174 48.74 126.174 48.46C126.174 48.3133 126.207 48.1533 126.274 47.98C126.354 47.8067 126.454 47.6533 126.574 47.52C126.707 47.3867 126.86 47.32 127.034 47.32C127.22 47.32 127.414 47.4 127.614 47.56C127.827 47.7067 128.087 47.8533 128.394 48C128.714 48.1467 129.154 48.22 129.714 48.22C130.314 48.22 130.707 48.1267 130.894 47.94C131.094 47.7533 131.194 47.56 131.194 47.36C131.194 47.0667 131.074 46.84 130.834 46.68C130.607 46.52 130.314 46.3933 129.954 46.3C129.594 46.1933 129.207 46.08 128.794 45.96C128.394 45.84 128.014 45.6867 127.654 45.5C127.294 45.3 127 45.0333 126.774 44.7C126.547 44.3533 126.434 43.9067 126.434 43.36C126.434 42.88 126.547 42.4133 126.774 41.96C127 41.5067 127.374 41.1333 127.894 40.84C128.414 40.5333 129.12 40.38 130.014 40.38C130.56 40.38 131.074 40.44 131.554 40.56C132.047 40.6667 132.447 40.82 132.754 41.02C133.06 41.22 133.214 41.44 133.214 41.68C133.214 41.8 133.174 41.96 133.094 42.16C133.014 42.3467 132.9 42.52 132.754 42.68C132.62 42.84 132.454 42.92 132.254 42.92C132.107 42.92 131.927 42.8733 131.714 42.78C131.514 42.6733 131.28 42.5733 131.014 42.48C130.747 42.3867 130.427 42.34 130.054 42.34C129.72 42.34 129.454 42.3867 129.254 42.48C129.054 42.5733 128.907 42.6867 128.814 42.82C128.72 42.9533 128.674 43.0933 128.674 43.24C128.674 43.48 128.787 43.6667 129.014 43.8C129.24 43.9333 129.534 44.0467 129.894 44.14C130.267 44.2333 130.654 44.34 131.054 44.46C131.467 44.5667 131.854 44.7267 132.214 44.94C132.587 45.1533 132.887 45.4467 133.114 45.82C133.34 46.18 133.454 46.6533 133.454 47.24C133.454 48.1333 133.134 48.8467 132.494 49.38C131.867 49.9133 130.96 50.18 129.774 50.18ZM147.238 50.1C147.064 50.1 146.891 50.0467 146.718 49.94C146.558 49.8333 146.431 49.68 146.338 49.48L143.498 43.96H141.818V49.16C141.818 49.44 141.684 49.6533 141.418 49.8C141.151 49.9333 140.851 50 140.518 50C140.198 50 139.898 49.9333 139.618 49.8C139.351 49.6533 139.218 49.44 139.218 49.16V36.2C139.218 35.9733 139.291 35.78 139.438 35.62C139.598 35.46 139.804 35.38 140.058 35.38H144.018C144.898 35.38 145.691 35.5067 146.398 35.76C147.118 36.0133 147.691 36.4467 148.118 37.06C148.544 37.66 148.758 38.4933 148.758 39.56C148.758 40.3333 148.644 40.9933 148.418 41.54C148.191 42.0733 147.878 42.5067 147.478 42.84C147.091 43.16 146.644 43.4 146.138 43.56L148.778 48.42C148.804 48.4733 148.824 48.5333 148.838 48.6C148.851 48.6533 148.858 48.7 148.858 48.74C148.858 48.9533 148.778 49.1667 148.618 49.38C148.458 49.5933 148.251 49.7667 147.998 49.9C147.758 50.0333 147.504 50.1 147.238 50.1ZM141.818 41.92H144.018C144.671 41.92 145.191 41.76 145.578 41.44C145.964 41.12 146.158 40.5733 146.158 39.8C146.158 39 145.964 38.4467 145.578 38.14C145.191 37.82 144.671 37.66 144.018 37.66H141.818V41.92ZM151.665 38.38C151.278 38.38 150.945 38.2533 150.665 38C150.385 37.7333 150.245 37.44 150.245 37.12C150.245 36.7733 150.385 36.48 150.665 36.24C150.945 35.9867 151.278 35.86 151.665 35.86C152.065 35.86 152.398 35.9867 152.665 36.24C152.931 36.48 153.065 36.7733 153.065 37.12C153.065 37.44 152.931 37.7333 152.665 38C152.398 38.2533 152.065 38.38 151.665 38.38ZM151.665 50C151.291 50 150.985 49.9133 150.745 49.74C150.505 49.5667 150.385 49.3733 150.385 49.16V41.3C150.385 41.06 150.505 40.8667 150.745 40.72C150.985 40.5733 151.291 40.5 151.665 40.5C152.025 40.5 152.331 40.5733 152.585 40.72C152.838 40.8667 152.965 41.06 152.965 41.3V49.16C152.965 49.3733 152.838 49.5667 152.585 49.74C152.331 49.9133 152.025 50 151.665 50ZM158.676 54.42C157.889 54.42 157.156 54.3067 156.476 54.08C155.809 53.8667 155.269 53.5467 154.856 53.12C154.456 52.6933 154.256 52.1867 154.256 51.6C154.256 51.0933 154.396 50.66 154.676 50.3C154.956 49.9533 155.302 49.68 155.716 49.48C155.462 49.36 155.256 49.2 155.096 49C154.949 48.7867 154.876 48.52 154.876 48.2C154.876 47.8267 154.969 47.5267 155.156 47.3C155.356 47.06 155.602 46.84 155.896 46.64C155.496 46.3333 155.182 45.9667 154.956 45.54C154.742 45.1 154.636 44.62 154.636 44.1V43.68C154.636 43.0267 154.796 42.4533 155.116 41.96C155.449 41.4667 155.909 41.08 156.496 40.8C157.096 40.52 157.782 40.38 158.556 40.38C158.996 40.38 159.409 40.4333 159.796 40.54C160.182 40.6333 160.529 40.7733 160.836 40.96C161.062 40.4267 161.276 40.0667 161.476 39.88C161.676 39.6933 161.869 39.6 162.056 39.6C162.376 39.6 162.622 39.6933 162.796 39.88C162.982 40.0667 163.076 40.24 163.076 40.4C163.076 40.52 163.042 40.6267 162.976 40.72C162.922 40.8133 162.849 40.8933 162.756 40.96C162.622 41.04 162.469 41.14 162.296 41.26C162.122 41.3667 161.962 41.52 161.816 41.72C162.056 41.9867 162.229 42.2867 162.336 42.62C162.456 42.94 162.516 43.2933 162.516 43.68V44.1C162.516 44.74 162.349 45.3133 162.016 45.82C161.682 46.3133 161.216 46.7067 160.616 47C160.016 47.2933 159.329 47.44 158.556 47.44C158.076 47.44 157.642 47.38 157.256 47.26C157.189 47.3133 157.129 47.3733 157.076 47.44C157.036 47.5067 157.016 47.58 157.016 47.66C157.016 47.8867 157.162 48.0467 157.456 48.14C157.749 48.2333 158.122 48.3067 158.576 48.36C159.029 48.4133 159.509 48.4867 160.016 48.58C160.536 48.66 161.022 48.7933 161.476 48.98C161.929 49.1667 162.302 49.4467 162.596 49.82C162.889 50.18 163.036 50.6667 163.036 51.28C163.036 52.0267 162.822 52.6267 162.396 53.08C161.982 53.5467 161.442 53.8867 160.776 54.1C160.122 54.3133 159.422 54.42 158.676 54.42ZM158.636 52.76C159.156 52.76 159.596 52.6333 159.956 52.38C160.329 52.1267 160.516 51.7867 160.516 51.36C160.516 51.08 160.436 50.8533 160.276 50.68C160.116 50.5067 159.896 50.3733 159.616 50.28C159.349 50.2 159.056 50.1333 158.736 50.08C158.416 50.04 158.096 50 157.776 49.96C157.456 50.1067 157.196 50.2933 156.996 50.52C156.796 50.7467 156.696 51.02 156.696 51.34C156.696 51.78 156.882 52.1267 157.256 52.38C157.642 52.6333 158.102 52.76 158.636 52.76ZM158.596 45.88C159.036 45.88 159.382 45.7133 159.636 45.38C159.889 45.0467 160.016 44.62 160.016 44.1V43.68C160.016 43.1867 159.889 42.7733 159.636 42.44C159.396 42.1067 159.042 41.94 158.576 41.94C158.122 41.94 157.769 42.1067 157.516 42.44C157.276 42.7733 157.156 43.1867 157.156 43.68V44.08C157.156 44.5867 157.276 45.0133 157.516 45.36C157.769 45.7067 158.129 45.88 158.596 45.88ZM165.65 50C165.276 50 164.97 49.9133 164.73 49.74C164.49 49.5667 164.37 49.3733 164.37 49.16V35.76C164.37 35.52 164.49 35.3267 164.73 35.18C164.97 35.0333 165.276 34.96 165.65 34.96C166.01 34.96 166.316 35.0333 166.57 35.18C166.823 35.3267 166.95 35.52 166.95 35.76V41.9C167.15 41.5133 167.463 41.1667 167.89 40.86C168.316 40.54 168.843 40.38 169.47 40.38C170.096 40.38 170.67 40.5667 171.19 40.94C171.71 41.3 172.123 41.7867 172.43 42.4C172.75 43.0133 172.91 43.6933 172.91 44.44V49.16C172.91 49.44 172.776 49.6533 172.51 49.8C172.243 49.9333 171.943 50 171.61 50C171.316 50 171.03 49.9333 170.75 49.8C170.47 49.6533 170.33 49.44 170.33 49.16V44.44C170.33 44.1333 170.25 43.8467 170.09 43.58C169.93 43.3133 169.716 43.0933 169.45 42.92C169.196 42.7333 168.91 42.64 168.59 42.64C168.323 42.64 168.063 42.7133 167.81 42.86C167.556 43.0067 167.35 43.2133 167.19 43.48C167.03 43.7467 166.95 44.0667 166.95 44.44V49.16C166.95 49.3733 166.823 49.5667 166.57 49.74C166.316 49.9133 166.01 50 165.65 50ZM178.498 50C177.298 50 176.378 49.74 175.738 49.22C175.111 48.7 174.798 47.8733 174.798 46.74V37.06C174.798 36.82 174.938 36.6267 175.218 36.48C175.498 36.3333 175.785 36.26 176.078 36.26C176.398 36.26 176.691 36.3333 176.958 36.48C177.238 36.6267 177.378 36.82 177.378 37.06V40.5H179.738C179.951 40.5 180.111 40.6 180.218 40.8C180.338 40.9867 180.398 41.2 180.398 41.44C180.398 41.68 180.338 41.9 180.218 42.1C180.111 42.2867 179.951 42.38 179.738 42.38H177.378V46.74C177.378 47.14 177.458 47.42 177.618 47.58C177.791 47.74 178.085 47.82 178.498 47.82H179.278C179.651 47.82 179.925 47.9333 180.098 48.16C180.285 48.3867 180.378 48.6333 180.378 48.9C180.378 49.18 180.285 49.4333 180.098 49.66C179.925 49.8867 179.651 50 179.278 50H178.498ZM182.933 45.96C182.666 45.96 182.433 45.9 182.233 45.78C182.033 45.66 181.933 45.4667 181.933 45.2C181.933 44.32 181.913 43.3667 181.873 42.34C181.833 41.3133 181.786 40.2867 181.733 39.26C181.693 38.2333 181.673 37.28 181.673 36.4C181.673 36.0533 181.793 35.7867 182.033 35.6C182.273 35.4 182.573 35.3 182.933 35.3C183.266 35.3 183.553 35.4 183.793 35.6C184.046 35.7867 184.173 36.0533 184.173 36.4C184.173 37.28 184.153 38.2333 184.113 39.26C184.073 40.2867 184.026 41.3133 183.973 42.34C183.933 43.3667 183.913 44.32 183.913 45.2C183.913 45.4667 183.8 45.66 183.573 45.78C183.346 45.9 183.133 45.96 182.933 45.96ZM182.953 50.12C182.566 50.12 182.24 49.9867 181.973 49.72C181.72 49.44 181.593 49.12 181.593 48.76C181.593 48.3867 181.72 48.0667 181.973 47.8C182.24 47.5333 182.566 47.4 182.953 47.4C183.313 47.4 183.626 47.5333 183.893 47.8C184.16 48.0667 184.293 48.3867 184.293 48.76C184.293 49.12 184.16 49.44 183.893 49.72C183.626 49.9867 183.313 50.12 182.953 50.12Z\" fill=\"#FF0082\"/> <path d=\"M50.7847 99.096C50.1447 99.096 49.5527 98.9787 49.0087 98.744C48.4754 98.5093 48.0487 98.1307 47.7287 97.608C47.4087 97.0853 47.2487 96.392 47.2487 95.528V90.872C47.2487 90.008 47.4087 89.3147 47.7287 88.792C48.0487 88.2693 48.4807 87.8907 49.0247 87.656C49.5687 87.4213 50.1607 87.304 50.8007 87.304C51.5367 87.304 52.1714 87.432 52.7047 87.688C53.2487 87.9333 53.67 88.2747 53.9687 88.712C54.278 89.1387 54.4327 89.6347 54.4327 90.2C54.4327 90.5627 54.3634 90.8027 54.2247 90.92C54.086 91.0267 53.8727 91.08 53.5847 91.08C53.3287 91.08 53.126 91.0373 52.9767 90.952C52.8274 90.856 52.7474 90.712 52.7367 90.52C52.726 90.3813 52.6994 90.216 52.6567 90.024C52.614 89.832 52.5287 89.6453 52.4007 89.464C52.2834 89.272 52.102 89.1173 51.8567 89C51.6114 88.872 51.2754 88.808 50.8487 88.808C50.23 88.808 49.7554 88.9787 49.4247 89.32C49.094 89.6507 48.9287 90.168 48.9287 90.872V95.528C48.9287 96.232 49.094 96.7547 49.4247 97.096C49.766 97.4267 50.2567 97.592 50.8967 97.592C51.302 97.592 51.622 97.5333 51.8567 97.416C52.102 97.288 52.2834 97.1333 52.4007 96.952C52.518 96.76 52.598 96.5627 52.6407 96.36C52.6834 96.1467 52.7154 95.9547 52.7367 95.784C52.7474 95.5813 52.8274 95.4373 52.9767 95.352C53.1367 95.2667 53.334 95.224 53.5687 95.224C53.8674 95.224 54.086 95.2827 54.2247 95.4C54.3634 95.5173 54.4327 95.752 54.4327 96.104C54.4327 96.68 54.278 97.1973 53.9687 97.656C53.67 98.104 53.2487 98.456 52.7047 98.712C52.1607 98.968 51.5207 99.096 50.7847 99.096ZM59.2649 99.128C58.5396 99.128 57.8996 98.9947 57.3449 98.728C56.7903 98.4613 56.3529 98.0933 56.0329 97.624C55.7129 97.144 55.5529 96.584 55.5529 95.944V94.424C55.5529 93.8587 55.7023 93.3413 56.0009 92.872C56.3103 92.4027 56.7156 92.0293 57.2169 91.752C57.7183 91.464 58.2729 91.32 58.8809 91.32C59.4569 91.32 59.9849 91.448 60.4649 91.704C60.9449 91.9493 61.3289 92.296 61.6169 92.744C61.9156 93.192 62.0649 93.704 62.0649 94.28C62.0649 94.728 61.9956 95.048 61.8569 95.24C61.7183 95.432 61.5369 95.5493 61.3129 95.592C61.0889 95.6347 60.8543 95.656 60.6089 95.656H57.2329V96.024C57.2329 96.5573 57.4249 96.984 57.8089 97.304C58.2036 97.6133 58.7049 97.768 59.3129 97.768C59.6863 97.768 59.9903 97.7147 60.2249 97.608C60.4596 97.5013 60.6569 97.4 60.8169 97.304C60.9769 97.208 61.1263 97.16 61.2649 97.16C61.4036 97.16 61.5209 97.2027 61.6169 97.288C61.7129 97.3733 61.7876 97.4747 61.8409 97.592C61.8943 97.7093 61.9209 97.816 61.9209 97.912C61.9209 98.072 61.8089 98.248 61.5849 98.44C61.3716 98.632 61.0676 98.7973 60.6729 98.936C60.2783 99.064 59.8089 99.128 59.2649 99.128ZM57.2329 94.616H59.8889C60.1236 94.616 60.2783 94.584 60.3529 94.52C60.4383 94.456 60.4809 94.328 60.4809 94.136C60.4809 93.8587 60.4116 93.6027 60.2729 93.368C60.1343 93.1227 59.9423 92.936 59.6969 92.808C59.4516 92.6693 59.1743 92.6 58.8649 92.6C58.5663 92.6 58.2943 92.664 58.0489 92.792C57.8036 92.92 57.6063 93.096 57.4569 93.32C57.3076 93.544 57.2329 93.8053 57.2329 94.104V94.616ZM64.2507 99C64.016 99 63.8187 98.9413 63.6587 98.824C63.5094 98.7067 63.4347 98.5787 63.4347 98.44V91.96C63.4347 91.8 63.5094 91.672 63.6587 91.576C63.8187 91.4693 64.016 91.416 64.2507 91.416C64.464 91.416 64.6454 91.4693 64.7947 91.576C64.944 91.672 65.0187 91.8 65.0187 91.96V92.664C65.136 92.44 65.2907 92.2267 65.4827 92.024C65.6854 91.8213 65.92 91.656 66.1867 91.528C66.4534 91.3893 66.7414 91.32 67.0507 91.32H67.5627C67.7334 91.32 67.8827 91.3947 68.0107 91.544C68.1387 91.6827 68.2027 91.8533 68.2027 92.056C68.2027 92.2587 68.1387 92.4347 68.0107 92.584C67.8827 92.7333 67.7334 92.808 67.5627 92.808H67.0507C66.7307 92.808 66.4214 92.904 66.1227 93.096C65.824 93.288 65.5787 93.56 65.3867 93.912C65.2054 94.2533 65.1147 94.6693 65.1147 95.16V98.44C65.1147 98.5787 65.0294 98.7067 64.8587 98.824C64.6987 98.9413 64.496 99 64.2507 99ZM72.3431 99.128C71.6177 99.128 70.9777 98.9947 70.4231 98.728C69.8684 98.4613 69.4311 98.0933 69.1111 97.624C68.7911 97.144 68.6311 96.584 68.6311 95.944V94.424C68.6311 93.8587 68.7804 93.3413 69.0791 92.872C69.3884 92.4027 69.7937 92.0293 70.2951 91.752C70.7964 91.464 71.3511 91.32 71.9591 91.32C72.5351 91.32 73.0631 91.448 73.5431 91.704C74.0231 91.9493 74.4071 92.296 74.6951 92.744C74.9937 93.192 75.1431 93.704 75.1431 94.28C75.1431 94.728 75.0737 95.048 74.9351 95.24C74.7964 95.432 74.6151 95.5493 74.3911 95.592C74.1671 95.6347 73.9324 95.656 73.6871 95.656H70.3111V96.024C70.3111 96.5573 70.5031 96.984 70.8871 97.304C71.2817 97.6133 71.7831 97.768 72.3911 97.768C72.7644 97.768 73.0684 97.7147 73.3031 97.608C73.5377 97.5013 73.7351 97.4 73.8951 97.304C74.0551 97.208 74.2044 97.16 74.3431 97.16C74.4817 97.16 74.5991 97.2027 74.6951 97.288C74.7911 97.3733 74.8657 97.4747 74.9191 97.592C74.9724 97.7093 74.9991 97.816 74.9991 97.912C74.9991 98.072 74.8871 98.248 74.6631 98.44C74.4497 98.632 74.1457 98.7973 73.7511 98.936C73.3564 99.064 72.8871 99.128 72.3431 99.128ZM70.3111 94.616H72.9671C73.2017 94.616 73.3564 94.584 73.4311 94.52C73.5164 94.456 73.5591 94.328 73.5591 94.136C73.5591 93.8587 73.4897 93.6027 73.3511 93.368C73.2124 93.1227 73.0204 92.936 72.7751 92.808C72.5297 92.6693 72.2524 92.6 71.9431 92.6C71.6444 92.6 71.3724 92.664 71.1271 92.792C70.8817 92.92 70.6844 93.096 70.5351 93.32C70.3857 93.544 70.3111 93.8053 70.3111 94.104V94.616ZM78.1608 99.128C77.5741 99.128 77.0728 98.9573 76.6568 98.616C76.2408 98.264 76.0328 97.7307 76.0328 97.016C76.0328 96.408 76.1928 95.9387 76.5128 95.608C76.8328 95.2773 77.2701 95.048 77.8248 94.92C78.3901 94.792 79.0408 94.728 79.7768 94.728H80.4808V94.44C80.4808 94.1627 80.4275 93.896 80.3208 93.64C80.2248 93.3733 80.0595 93.1547 79.8248 92.984C79.6008 92.8027 79.2915 92.712 78.8968 92.712C78.5021 92.712 78.1981 92.7493 77.9848 92.824C77.7715 92.8987 77.6008 92.9787 77.4728 93.064C77.3448 93.1493 77.2275 93.192 77.1208 93.192C76.9288 93.192 76.7795 93.1013 76.6728 92.92C76.5661 92.728 76.5128 92.536 76.5128 92.344C76.5128 92.152 76.6355 91.9813 76.8808 91.832C77.1368 91.672 77.4515 91.5493 77.8248 91.464C78.1981 91.368 78.5661 91.32 78.9288 91.32C79.7181 91.32 80.3475 91.4693 80.8168 91.768C81.2861 92.056 81.6275 92.4347 81.8408 92.904C82.0541 93.3733 82.1608 93.88 82.1608 94.424V98.44C82.1608 98.5893 82.0808 98.7227 81.9208 98.84C81.7715 98.9467 81.5795 99 81.3448 99C81.1315 99 80.9501 98.9467 80.8008 98.84C80.6515 98.7227 80.5768 98.5893 80.5768 98.44V97.88C80.2995 98.2 79.9635 98.488 79.5688 98.744C79.1741 99 78.7048 99.128 78.1608 99.128ZM78.7688 97.848C79.0355 97.848 79.2968 97.768 79.5528 97.608C79.8195 97.448 80.0381 97.2453 80.2088 97C80.3901 96.7547 80.4808 96.504 80.4808 96.248V95.656H80.0808C79.6755 95.656 79.2915 95.6827 78.9288 95.736C78.5661 95.7787 78.2728 95.8853 78.0488 96.056C77.8355 96.216 77.7288 96.4667 77.7288 96.808C77.7288 97.1707 77.8248 97.4373 78.0168 97.608C78.2195 97.768 78.4701 97.848 78.7688 97.848ZM84.8326 99C84.5872 99 84.3846 98.9413 84.2246 98.824C84.0752 98.7067 84.0006 98.5787 84.0006 98.44V87.448C84.0006 87.288 84.0752 87.16 84.2246 87.064C84.3846 86.9573 84.5872 86.904 84.8326 86.904C85.0672 86.904 85.2646 86.9573 85.4246 87.064C85.5952 87.16 85.6806 87.288 85.6806 87.448V98.44C85.6806 98.5787 85.5952 98.7067 85.4246 98.824C85.2646 98.9413 85.0672 99 84.8326 99ZM94.5864 99.128C94.0851 99.128 93.6318 99.0053 93.2264 98.76C92.8318 98.504 92.5491 98.2107 92.3784 97.88V98.44C92.3784 98.5787 92.3038 98.7067 92.1544 98.824C92.0051 98.9413 91.8238 99 91.6104 99C91.3758 99 91.1784 98.9413 91.0184 98.824C90.8691 98.7067 90.7944 98.5787 90.7944 98.44V87.448C90.7944 87.288 90.8691 87.16 91.0184 87.064C91.1784 86.9573 91.3758 86.904 91.6104 86.904C91.8558 86.904 92.0584 86.9573 92.2184 87.064C92.3891 87.16 92.4744 87.288 92.4744 87.448V92.536C92.6451 92.2267 92.9064 91.9493 93.2584 91.704C93.6104 91.448 94.0371 91.32 94.5384 91.32C95.0611 91.32 95.5358 91.464 95.9624 91.752C96.3998 92.0293 96.7464 92.408 97.0024 92.888C97.2691 93.3573 97.4024 93.8853 97.4024 94.472V95.944C97.4024 96.4987 97.2691 97.0213 97.0024 97.512C96.7464 97.992 96.4051 98.3813 95.9784 98.68C95.5518 98.9787 95.0878 99.128 94.5864 99.128ZM94.1064 97.64C94.3944 97.64 94.6611 97.56 94.9064 97.4C95.1518 97.24 95.3491 97.0267 95.4984 96.76C95.6478 96.4933 95.7224 96.2213 95.7224 95.944V94.472C95.7224 94.1947 95.6478 93.928 95.4984 93.672C95.3491 93.416 95.1518 93.208 94.9064 93.048C94.6611 92.888 94.3891 92.808 94.0904 92.808C93.8238 92.808 93.5678 92.8773 93.3224 93.016C93.0771 93.144 92.8744 93.3307 92.7144 93.576C92.5544 93.8213 92.4744 94.12 92.4744 94.472V96.312C92.4744 96.44 92.5438 96.6107 92.6824 96.824C92.8318 97.0267 93.0291 97.2133 93.2744 97.384C93.5198 97.5547 93.7971 97.64 94.1064 97.64ZM101.864 99.128C101.288 99.128 100.75 98.9787 100.248 98.68C99.7469 98.3813 99.3415 97.992 99.0322 97.512C98.7335 97.0213 98.5842 96.4987 98.5842 95.944V94.472C98.5842 93.9067 98.7282 93.384 99.0162 92.904C99.3149 92.424 99.7149 92.04 100.216 91.752C100.728 91.464 101.283 91.32 101.88 91.32C102.478 91.32 103.027 91.464 103.528 91.752C104.03 92.0293 104.43 92.408 104.728 92.888C105.038 93.3573 105.192 93.8853 105.192 94.472V95.944C105.192 96.488 105.038 97.0053 104.728 97.496C104.43 97.9867 104.024 98.3813 103.512 98.68C103.011 98.9787 102.462 99.128 101.864 99.128ZM101.88 97.64C102.179 97.64 102.451 97.56 102.696 97.4C102.942 97.24 103.139 97.032 103.288 96.776C103.438 96.5093 103.512 96.232 103.512 95.944V94.472C103.512 94.1947 103.438 93.928 103.288 93.672C103.139 93.416 102.942 93.208 102.696 93.048C102.451 92.888 102.179 92.808 101.88 92.808C101.571 92.808 101.294 92.888 101.048 93.048C100.814 93.208 100.622 93.416 100.472 93.672C100.334 93.928 100.264 94.1947 100.264 94.472V95.944C100.264 96.232 100.334 96.5093 100.472 96.776C100.622 97.032 100.819 97.24 101.064 97.4C101.31 97.56 101.582 97.64 101.88 97.64ZM107.041 99.128C106.913 99.128 106.763 99.0853 106.593 99C106.433 98.9253 106.289 98.824 106.161 98.696C106.043 98.568 105.985 98.4347 105.985 98.296C105.985 98.1893 106.017 98.088 106.081 97.992L108.065 95.144L106.193 92.456C106.161 92.424 106.134 92.3813 106.113 92.328C106.091 92.2747 106.081 92.2213 106.081 92.168C106.081 92.0293 106.139 91.896 106.257 91.768C106.385 91.64 106.534 91.5333 106.705 91.448C106.875 91.3627 107.03 91.32 107.169 91.32C107.222 91.32 107.291 91.3307 107.377 91.352C107.462 91.3733 107.531 91.4267 107.585 91.512L109.201 94.072L110.833 91.528C110.886 91.4427 110.95 91.3893 111.025 91.368C111.11 91.336 111.19 91.32 111.265 91.32C111.393 91.32 111.542 91.3627 111.713 91.448C111.883 91.5227 112.027 91.6293 112.145 91.768C112.273 91.896 112.337 92.0293 112.337 92.168C112.337 92.2533 112.299 92.3493 112.225 92.456L110.337 95.16L112.321 97.992C112.353 98.024 112.379 98.0667 112.401 98.12C112.422 98.1733 112.433 98.232 112.433 98.296C112.433 98.4133 112.374 98.5413 112.257 98.68C112.139 98.808 111.995 98.9147 111.825 99C111.665 99.0853 111.51 99.128 111.361 99.128C111.286 99.128 111.206 99.112 111.121 99.08C111.046 99.0587 110.987 99.0107 110.945 98.936L109.201 96.296L107.473 98.936C107.43 99 107.361 99.048 107.265 99.08C107.179 99.112 107.105 99.128 107.041 99.128ZM116.937 99.128C116.211 99.128 115.571 98.9947 115.017 98.728C114.462 98.4613 114.025 98.0933 113.705 97.624C113.385 97.144 113.225 96.584 113.225 95.944V94.424C113.225 93.8587 113.374 93.3413 113.673 92.872C113.982 92.4027 114.387 92.0293 114.889 91.752C115.39 91.464 115.945 91.32 116.553 91.32C117.129 91.32 117.657 91.448 118.137 91.704C118.617 91.9493 119.001 92.296 119.289 92.744C119.587 93.192 119.737 93.704 119.737 94.28C119.737 94.728 119.667 95.048 119.529 95.24C119.39 95.432 119.209 95.5493 118.985 95.592C118.761 95.6347 118.526 95.656 118.281 95.656H114.905V96.024C114.905 96.5573 115.097 96.984 115.481 97.304C115.875 97.6133 116.377 97.768 116.985 97.768C117.358 97.768 117.662 97.7147 117.897 97.608C118.131 97.5013 118.329 97.4 118.489 97.304C118.649 97.208 118.798 97.16 118.937 97.16C119.075 97.16 119.193 97.2027 119.289 97.288C119.385 97.3733 119.459 97.4747 119.513 97.592C119.566 97.7093 119.593 97.816 119.593 97.912C119.593 98.072 119.481 98.248 119.257 98.44C119.043 98.632 118.739 98.7973 118.345 98.936C117.95 99.064 117.481 99.128 116.937 99.128ZM114.905 94.616H117.561C117.795 94.616 117.95 94.584 118.025 94.52C118.11 94.456 118.153 94.328 118.153 94.136C118.153 93.8587 118.083 93.6027 117.945 93.368C117.806 93.1227 117.614 92.936 117.369 92.808C117.123 92.6693 116.846 92.6 116.537 92.6C116.238 92.6 115.966 92.664 115.721 92.792C115.475 92.92 115.278 93.096 115.129 93.32C114.979 93.544 114.905 93.8053 114.905 94.104V94.616ZM123.427 99.128C122.904 99.128 122.435 99.064 122.019 98.936C121.603 98.808 121.272 98.648 121.027 98.456C120.792 98.2533 120.675 98.0507 120.675 97.848C120.675 97.752 120.696 97.6453 120.739 97.528C120.792 97.4107 120.861 97.3093 120.947 97.224C121.043 97.1387 121.144 97.096 121.251 97.096C121.389 97.096 121.533 97.16 121.683 97.288C121.843 97.4053 122.051 97.528 122.307 97.656C122.563 97.7733 122.92 97.832 123.379 97.832C123.912 97.832 124.269 97.7413 124.451 97.56C124.643 97.3787 124.739 97.1813 124.739 96.968C124.739 96.6907 124.643 96.4773 124.451 96.328C124.269 96.168 124.029 96.04 123.731 95.944C123.443 95.848 123.133 95.7573 122.803 95.672C122.472 95.576 122.157 95.4533 121.859 95.304C121.571 95.1547 121.331 94.9467 121.139 94.68C120.957 94.4133 120.867 94.0613 120.867 93.624C120.867 93.2613 120.957 92.904 121.139 92.552C121.32 92.1893 121.608 91.896 122.003 91.672C122.408 91.4373 122.947 91.32 123.619 91.32C124.024 91.32 124.408 91.3627 124.771 91.448C125.133 91.5333 125.432 91.6507 125.667 91.8C125.901 91.9387 126.019 92.0933 126.019 92.264C126.019 92.3387 125.992 92.4453 125.939 92.584C125.885 92.712 125.811 92.8293 125.715 92.936C125.629 93.032 125.517 93.08 125.379 93.08C125.272 93.08 125.139 93.0427 124.979 92.968C124.819 92.8827 124.632 92.8027 124.419 92.728C124.205 92.6533 123.944 92.616 123.635 92.616C123.325 92.616 123.075 92.6693 122.883 92.776C122.701 92.872 122.568 92.9893 122.483 93.128C122.397 93.2667 122.355 93.4053 122.355 93.544C122.355 93.7787 122.445 93.96 122.627 94.088C122.808 94.216 123.048 94.3227 123.347 94.408C123.645 94.4933 123.96 94.584 124.291 94.68C124.621 94.7653 124.931 94.8933 125.219 95.064C125.517 95.2347 125.757 95.464 125.939 95.752C126.131 96.04 126.227 96.424 126.227 96.904C126.227 97.576 125.981 98.1147 125.491 98.52C125.011 98.9253 124.323 99.128 123.427 99.128ZM132.458 99.128C131.871 99.128 131.37 98.9573 130.954 98.616C130.538 98.264 130.33 97.7307 130.33 97.016C130.33 96.408 130.49 95.9387 130.81 95.608C131.13 95.2773 131.567 95.048 132.122 94.92C132.687 94.792 133.338 94.728 134.074 94.728H134.778V94.44C134.778 94.1627 134.724 93.896 134.618 93.64C134.522 93.3733 134.356 93.1547 134.122 92.984C133.898 92.8027 133.588 92.712 133.194 92.712C132.799 92.712 132.495 92.7493 132.282 92.824C132.068 92.8987 131.898 92.9787 131.77 93.064C131.642 93.1493 131.524 93.192 131.418 93.192C131.226 93.192 131.076 93.1013 130.97 92.92C130.863 92.728 130.81 92.536 130.81 92.344C130.81 92.152 130.932 91.9813 131.178 91.832C131.434 91.672 131.748 91.5493 132.122 91.464C132.495 91.368 132.863 91.32 133.226 91.32C134.015 91.32 134.644 91.4693 135.114 91.768C135.583 92.056 135.924 92.4347 136.138 92.904C136.351 93.3733 136.458 93.88 136.458 94.424V98.44C136.458 98.5893 136.378 98.7227 136.218 98.84C136.068 98.9467 135.876 99 135.642 99C135.428 99 135.247 98.9467 135.098 98.84C134.948 98.7227 134.874 98.5893 134.874 98.44V97.88C134.596 98.2 134.26 98.488 133.866 98.744C133.471 99 133.002 99.128 132.458 99.128ZM133.066 97.848C133.332 97.848 133.594 97.768 133.85 97.608C134.116 97.448 134.335 97.2453 134.506 97C134.687 96.7547 134.778 96.504 134.778 96.248V95.656H134.378C133.972 95.656 133.588 95.6827 133.226 95.736C132.863 95.7787 132.57 95.8853 132.346 96.056C132.132 96.216 132.026 96.4667 132.026 96.808C132.026 97.1707 132.122 97.4373 132.314 97.608C132.516 97.768 132.767 97.848 133.066 97.848ZM138.969 99C138.735 99 138.537 98.9413 138.377 98.824C138.228 98.7067 138.153 98.5787 138.153 98.44V91.96C138.153 91.8 138.228 91.672 138.377 91.576C138.537 91.4693 138.735 91.416 138.969 91.416C139.183 91.416 139.364 91.4693 139.513 91.576C139.663 91.672 139.737 91.8 139.737 91.96V92.664C139.855 92.44 140.009 92.2267 140.201 92.024C140.404 91.8213 140.639 91.656 140.905 91.528C141.172 91.3893 141.46 91.32 141.769 91.32H142.281C142.452 91.32 142.601 91.3947 142.729 91.544C142.857 91.6827 142.921 91.8533 142.921 92.056C142.921 92.2587 142.857 92.4347 142.729 92.584C142.601 92.7333 142.452 92.808 142.281 92.808H141.769C141.449 92.808 141.14 92.904 140.841 93.096C140.543 93.288 140.297 93.56 140.105 93.912C139.924 94.2533 139.833 94.6693 139.833 95.16V98.44C139.833 98.5787 139.748 98.7067 139.577 98.824C139.417 98.9413 139.215 99 138.969 99ZM147.062 99.128C146.336 99.128 145.696 98.9947 145.142 98.728C144.587 98.4613 144.15 98.0933 143.83 97.624C143.51 97.144 143.35 96.584 143.35 95.944V94.424C143.35 93.8587 143.499 93.3413 143.798 92.872C144.107 92.4027 144.512 92.0293 145.014 91.752C145.515 91.464 146.07 91.32 146.678 91.32C147.254 91.32 147.782 91.448 148.262 91.704C148.742 91.9493 149.126 92.296 149.414 92.744C149.712 93.192 149.862 93.704 149.862 94.28C149.862 94.728 149.792 95.048 149.654 95.24C149.515 95.432 149.334 95.5493 149.11 95.592C148.886 95.6347 148.651 95.656 148.406 95.656H145.03V96.024C145.03 96.5573 145.222 96.984 145.606 97.304C146 97.6133 146.502 97.768 147.11 97.768C147.483 97.768 147.787 97.7147 148.022 97.608C148.256 97.5013 148.454 97.4 148.614 97.304C148.774 97.208 148.923 97.16 149.062 97.16C149.2 97.16 149.318 97.2027 149.414 97.288C149.51 97.3733 149.584 97.4747 149.638 97.592C149.691 97.7093 149.718 97.816 149.718 97.912C149.718 98.072 149.606 98.248 149.382 98.44C149.168 98.632 148.864 98.7973 148.47 98.936C148.075 99.064 147.606 99.128 147.062 99.128ZM145.03 94.616H147.686C147.92 94.616 148.075 94.584 148.15 94.52C148.235 94.456 148.278 94.328 148.278 94.136C148.278 93.8587 148.208 93.6027 148.07 93.368C147.931 93.1227 147.739 92.936 147.494 92.808C147.248 92.6693 146.971 92.6 146.662 92.6C146.363 92.6 146.091 92.664 145.846 92.792C145.6 92.92 145.403 93.096 145.254 93.32C145.104 93.544 145.03 93.8053 145.03 94.104V94.616ZM155.267 99C155.021 99 154.819 98.9413 154.659 98.824C154.509 98.7067 154.435 98.5787 154.435 98.44V91.96C154.435 91.8 154.509 91.672 154.659 91.576C154.819 91.4693 155.021 91.416 155.267 91.416C155.469 91.416 155.645 91.4693 155.795 91.576C155.944 91.672 156.019 91.8 156.019 91.96V92.536C156.2 92.2267 156.467 91.9493 156.819 91.704C157.171 91.448 157.613 91.32 158.147 91.32C158.627 91.32 159.048 91.4693 159.411 91.768C159.784 92.0667 160.061 92.4507 160.243 92.92C160.52 92.376 160.877 91.976 161.315 91.72C161.752 91.4533 162.2 91.32 162.659 91.32C163.139 91.32 163.587 91.4427 164.003 91.688C164.429 91.9333 164.776 92.2907 165.043 92.76C165.309 93.2293 165.443 93.8 165.443 94.472V98.44C165.443 98.5787 165.357 98.7067 165.187 98.824C165.027 98.9413 164.829 99 164.595 99C164.371 99 164.173 98.9413 164.003 98.824C163.843 98.7067 163.763 98.5787 163.763 98.44V94.472C163.763 94.1093 163.688 93.8053 163.539 93.56C163.4 93.304 163.213 93.112 162.979 92.984C162.755 92.856 162.52 92.792 162.275 92.792C162.019 92.792 161.779 92.8613 161.555 93C161.331 93.128 161.144 93.3147 160.995 93.56C160.845 93.7947 160.771 94.088 160.771 94.44V98.456C160.771 98.648 160.68 98.7867 160.499 98.872C160.328 98.9573 160.136 99 159.923 99C159.731 99 159.544 98.9573 159.363 98.872C159.181 98.7867 159.091 98.648 159.091 98.456V94.456C159.091 94.1147 159.021 93.8213 158.883 93.576C158.744 93.3307 158.563 93.144 158.339 93.016C158.115 92.8773 157.869 92.808 157.603 92.808C157.357 92.808 157.117 92.872 156.883 93C156.659 93.128 156.472 93.3147 156.323 93.56C156.184 93.8053 156.115 94.1093 156.115 94.472V98.44C156.115 98.5787 156.029 98.7067 155.859 98.824C155.699 98.9413 155.501 99 155.267 99ZM168.786 99.128C168.199 99.128 167.698 98.9573 167.282 98.616C166.866 98.264 166.658 97.7307 166.658 97.016C166.658 96.408 166.818 95.9387 167.138 95.608C167.458 95.2773 167.895 95.048 168.45 94.92C169.015 94.792 169.666 94.728 170.402 94.728H171.106V94.44C171.106 94.1627 171.052 93.896 170.946 93.64C170.85 93.3733 170.684 93.1547 170.45 92.984C170.226 92.8027 169.916 92.712 169.522 92.712C169.127 92.712 168.823 92.7493 168.61 92.824C168.396 92.8987 168.226 92.9787 168.098 93.064C167.97 93.1493 167.852 93.192 167.746 93.192C167.554 93.192 167.404 93.1013 167.298 92.92C167.191 92.728 167.138 92.536 167.138 92.344C167.138 92.152 167.26 91.9813 167.506 91.832C167.762 91.672 168.076 91.5493 168.45 91.464C168.823 91.368 169.191 91.32 169.554 91.32C170.343 91.32 170.972 91.4693 171.442 91.768C171.911 92.056 172.252 92.4347 172.466 92.904C172.679 93.3733 172.786 93.88 172.786 94.424V98.44C172.786 98.5893 172.706 98.7227 172.546 98.84C172.396 98.9467 172.204 99 171.97 99C171.756 99 171.575 98.9467 171.426 98.84C171.276 98.7227 171.202 98.5893 171.202 98.44V97.88C170.924 98.2 170.588 98.488 170.194 98.744C169.799 99 169.33 99.128 168.786 99.128ZM169.394 97.848C169.66 97.848 169.922 97.768 170.178 97.608C170.444 97.448 170.663 97.2453 170.834 97C171.015 96.7547 171.106 96.504 171.106 96.248V95.656H170.706C170.3 95.656 169.916 95.6827 169.554 95.736C169.191 95.7787 168.898 95.8853 168.674 96.056C168.46 96.216 168.354 96.4667 168.354 96.808C168.354 97.1707 168.45 97.4373 168.642 97.608C168.844 97.768 169.095 97.848 169.394 97.848ZM177.01 99.128C176.508 99.128 176.044 98.9787 175.618 98.68C175.191 98.3813 174.844 97.992 174.578 97.512C174.322 97.0213 174.194 96.4987 174.194 95.944V94.472C174.194 93.8853 174.322 93.3573 174.578 92.888C174.844 92.408 175.191 92.0293 175.618 91.752C176.044 91.464 176.519 91.32 177.042 91.32C177.554 91.32 177.986 91.448 178.338 91.704C178.69 91.9493 178.951 92.2267 179.122 92.536V87.448C179.122 87.288 179.207 87.16 179.378 87.064C179.548 86.9573 179.751 86.904 179.986 86.904C180.22 86.904 180.412 86.9573 180.562 87.064C180.722 87.16 180.802 87.288 180.802 87.448V98.44C180.802 98.5787 180.722 98.7067 180.562 98.824C180.412 98.9413 180.22 99 179.986 99C179.783 99 179.602 98.9413 179.442 98.824C179.292 98.7067 179.218 98.5787 179.218 98.44V97.88C179.058 98.2107 178.775 98.504 178.37 98.76C177.964 99.0053 177.511 99.128 177.01 99.128ZM177.49 97.64C177.799 97.64 178.076 97.5547 178.322 97.384C178.567 97.2133 178.759 97.0267 178.898 96.824C179.047 96.6107 179.122 96.44 179.122 96.312V94.472C179.122 94.12 179.042 93.8213 178.882 93.576C178.722 93.3307 178.519 93.144 178.274 93.016C178.028 92.8773 177.772 92.808 177.506 92.808C177.207 92.808 176.93 92.888 176.674 93.048C176.428 93.208 176.231 93.416 176.082 93.672C175.943 93.928 175.874 94.1947 175.874 94.472V95.944C175.874 96.2213 175.943 96.4933 176.082 96.76C176.231 97.0267 176.428 97.24 176.674 97.4C176.919 97.56 177.191 97.64 177.49 97.64ZM185.999 99.128C185.274 99.128 184.634 98.9947 184.079 98.728C183.525 98.4613 183.087 98.0933 182.767 97.624C182.447 97.144 182.287 96.584 182.287 95.944V94.424C182.287 93.8587 182.437 93.3413 182.735 92.872C183.045 92.4027 183.45 92.0293 183.951 91.752C184.453 91.464 185.007 91.32 185.615 91.32C186.191 91.32 186.719 91.448 187.199 91.704C187.679 91.9493 188.063 92.296 188.351 92.744C188.65 93.192 188.799 93.704 188.799 94.28C188.799 94.728 188.73 95.048 188.591 95.24C188.453 95.432 188.271 95.5493 188.047 95.592C187.823 95.6347 187.589 95.656 187.343 95.656H183.967V96.024C183.967 96.5573 184.159 96.984 184.543 97.304C184.938 97.6133 185.439 97.768 186.047 97.768C186.421 97.768 186.725 97.7147 186.959 97.608C187.194 97.5013 187.391 97.4 187.551 97.304C187.711 97.208 187.861 97.16 187.999 97.16C188.138 97.16 188.255 97.2027 188.351 97.288C188.447 97.3733 188.522 97.4747 188.575 97.592C188.629 97.7093 188.655 97.816 188.655 97.912C188.655 98.072 188.543 98.248 188.319 98.44C188.106 98.632 187.802 98.7973 187.407 98.936C187.013 99.064 186.543 99.128 185.999 99.128ZM183.967 94.616H186.623C186.858 94.616 187.013 94.584 187.087 94.52C187.173 94.456 187.215 94.328 187.215 94.136C187.215 93.8587 187.146 93.6027 187.007 93.368C186.869 93.1227 186.677 92.936 186.431 92.808C186.186 92.6693 185.909 92.6 185.599 92.6C185.301 92.6 185.029 92.664 184.783 92.792C184.538 92.92 184.341 93.096 184.191 93.32C184.042 93.544 183.967 93.8053 183.967 94.104V94.616ZM194.204 99C193.97 99 193.772 98.952 193.612 98.856C193.463 98.7493 193.388 98.616 193.388 98.456V89.96C193.388 89.384 193.516 88.8667 193.772 88.408C194.028 87.9387 194.37 87.5707 194.796 87.304C195.223 87.0373 195.692 86.904 196.204 86.904H196.956C197.17 86.904 197.33 86.9787 197.436 87.128C197.554 87.2773 197.612 87.4427 197.612 87.624C197.612 87.816 197.554 87.9867 197.436 88.136C197.33 88.2747 197.17 88.344 196.956 88.344H196.524C196.247 88.344 195.996 88.408 195.772 88.536C195.559 88.664 195.388 88.84 195.26 89.064C195.132 89.2773 195.068 89.5227 195.068 89.8V91.416H197.132C197.292 91.416 197.41 91.48 197.484 91.608C197.57 91.736 197.612 91.88 197.612 92.04C197.612 92.2 197.57 92.344 197.484 92.472C197.41 92.6 197.292 92.664 197.132 92.664H195.068V98.456C195.068 98.616 194.983 98.7493 194.812 98.856C194.642 98.952 194.439 99 194.204 99ZM199.423 99C199.188 99 198.991 98.9413 198.831 98.824C198.681 98.7067 198.607 98.5787 198.607 98.44V91.96C198.607 91.8 198.681 91.672 198.831 91.576C198.991 91.4693 199.188 91.416 199.423 91.416C199.636 91.416 199.817 91.4693 199.967 91.576C200.116 91.672 200.191 91.8 200.191 91.96V92.664C200.308 92.44 200.463 92.2267 200.655 92.024C200.857 91.8213 201.092 91.656 201.359 91.528C201.625 91.3893 201.913 91.32 202.223 91.32H202.735C202.905 91.32 203.055 91.3947 203.183 91.544C203.311 91.6827 203.375 91.8533 203.375 92.056C203.375 92.2587 203.311 92.4347 203.183 92.584C203.055 92.7333 202.905 92.808 202.735 92.808H202.223C201.903 92.808 201.593 92.904 201.295 93.096C200.996 93.288 200.751 93.56 200.559 93.912C200.377 94.2533 200.287 94.6693 200.287 95.16V98.44C200.287 98.5787 200.201 98.7067 200.031 98.824C199.871 98.9413 199.668 99 199.423 99ZM207.083 99.128C206.507 99.128 205.968 98.9787 205.467 98.68C204.966 98.3813 204.56 97.992 204.251 97.512C203.952 97.0213 203.803 96.4987 203.803 95.944V94.472C203.803 93.9067 203.947 93.384 204.235 92.904C204.534 92.424 204.934 92.04 205.435 91.752C205.947 91.464 206.502 91.32 207.099 91.32C207.696 91.32 208.246 91.464 208.747 91.752C209.248 92.0293 209.648 92.408 209.947 92.888C210.256 93.3573 210.411 93.8853 210.411 94.472V95.944C210.411 96.488 210.256 97.0053 209.947 97.496C209.648 97.9867 209.243 98.3813 208.731 98.68C208.23 98.9787 207.68 99.128 207.083 99.128ZM207.099 97.64C207.398 97.64 207.67 97.56 207.915 97.4C208.16 97.24 208.358 97.032 208.507 96.776C208.656 96.5093 208.731 96.232 208.731 95.944V94.472C208.731 94.1947 208.656 93.928 208.507 93.672C208.358 93.416 208.16 93.208 207.915 93.048C207.67 92.888 207.398 92.808 207.099 92.808C206.79 92.808 206.512 92.888 206.267 93.048C206.032 93.208 205.84 93.416 205.691 93.672C205.552 93.928 205.483 94.1947 205.483 94.472V95.944C205.483 96.232 205.552 96.5093 205.691 96.776C205.84 97.032 206.038 97.24 206.283 97.4C206.528 97.56 206.8 97.64 207.099 97.64ZM212.704 99C212.459 99 212.256 98.9413 212.096 98.824C211.947 98.7067 211.872 98.5787 211.872 98.44V91.96C211.872 91.8 211.947 91.672 212.096 91.576C212.256 91.4693 212.459 91.416 212.704 91.416C212.907 91.416 213.083 91.4693 213.232 91.576C213.382 91.672 213.456 91.8 213.456 91.96V92.536C213.638 92.2267 213.904 91.9493 214.256 91.704C214.608 91.448 215.051 91.32 215.584 91.32C216.064 91.32 216.486 91.4693 216.848 91.768C217.222 92.0667 217.499 92.4507 217.68 92.92C217.958 92.376 218.315 91.976 218.752 91.72C219.19 91.4533 219.638 91.32 220.096 91.32C220.576 91.32 221.024 91.4427 221.44 91.688C221.867 91.9333 222.214 92.2907 222.48 92.76C222.747 93.2293 222.88 93.8 222.88 94.472V98.44C222.88 98.5787 222.795 98.7067 222.624 98.824C222.464 98.9413 222.267 99 222.032 99C221.808 99 221.611 98.9413 221.44 98.824C221.28 98.7067 221.2 98.5787 221.2 98.44V94.472C221.2 94.1093 221.126 93.8053 220.976 93.56C220.838 93.304 220.651 93.112 220.416 92.984C220.192 92.856 219.958 92.792 219.712 92.792C219.456 92.792 219.216 92.8613 218.992 93C218.768 93.128 218.582 93.3147 218.432 93.56C218.283 93.7947 218.208 94.088 218.208 94.44V98.456C218.208 98.648 218.118 98.7867 217.936 98.872C217.766 98.9573 217.574 99 217.36 99C217.168 99 216.982 98.9573 216.8 98.872C216.619 98.7867 216.528 98.648 216.528 98.456V94.456C216.528 94.1147 216.459 93.8213 216.32 93.576C216.182 93.3307 216 93.144 215.776 93.016C215.552 92.8773 215.307 92.808 215.04 92.808C214.795 92.808 214.555 92.872 214.32 93C214.096 93.128 213.91 93.3147 213.76 93.56C213.622 93.8053 213.552 94.1093 213.552 94.472V98.44C213.552 98.5787 213.467 98.7067 213.296 98.824C213.136 98.9413 212.939 99 212.704 99ZM41.3348 119.128C40.5668 119.128 39.9321 118.989 39.4308 118.712C38.9401 118.435 38.5775 118.056 38.3428 117.576C38.1081 117.096 37.9908 116.552 37.9908 115.944V114.504C37.9908 113.907 38.1081 113.368 38.3428 112.888C38.5775 112.397 38.9401 112.013 39.4308 111.736C39.9215 111.459 40.5455 111.32 41.3028 111.32C41.7935 111.32 42.2201 111.379 42.5828 111.496C42.9561 111.613 43.2441 111.763 43.4468 111.944C43.6601 112.115 43.7668 112.296 43.7668 112.488C43.7668 112.584 43.7348 112.701 43.6708 112.84C43.6175 112.968 43.5375 113.08 43.4308 113.176C43.3348 113.261 43.2175 113.304 43.0788 113.304C42.9721 113.304 42.8548 113.261 42.7268 113.176C42.6095 113.091 42.4495 113.011 42.2468 112.936C42.0441 112.851 41.7721 112.808 41.4308 112.808C40.8335 112.808 40.3908 112.957 40.1028 113.256C39.8148 113.555 39.6708 113.971 39.6708 114.504V115.944C39.6708 116.477 39.8148 116.893 40.1028 117.192C40.3908 117.491 40.8388 117.64 41.4468 117.64C41.7988 117.64 42.0761 117.597 42.2788 117.512C42.4815 117.416 42.6415 117.325 42.7588 117.24C42.8868 117.155 43.0095 117.112 43.1268 117.112C43.2761 117.112 43.4041 117.155 43.5108 117.24C43.6281 117.325 43.7135 117.432 43.7668 117.56C43.8308 117.688 43.8628 117.805 43.8628 117.912C43.8628 118.093 43.7508 118.28 43.5268 118.472C43.3135 118.664 43.0148 118.824 42.6308 118.952C42.2575 119.069 41.8255 119.128 41.3348 119.128ZM46.7077 119.128C46.121 119.128 45.6197 118.957 45.2037 118.616C44.7877 118.264 44.5797 117.731 44.5797 117.016C44.5797 116.408 44.7397 115.939 45.0597 115.608C45.3797 115.277 45.817 115.048 46.3717 114.92C46.937 114.792 47.5877 114.728 48.3237 114.728H49.0277V114.44C49.0277 114.163 48.9744 113.896 48.8677 113.64C48.7717 113.373 48.6064 113.155 48.3717 112.984C48.1477 112.803 47.8384 112.712 47.4437 112.712C47.049 112.712 46.745 112.749 46.5317 112.824C46.3184 112.899 46.1477 112.979 46.0197 113.064C45.8917 113.149 45.7744 113.192 45.6677 113.192C45.4757 113.192 45.3264 113.101 45.2197 112.92C45.113 112.728 45.0597 112.536 45.0597 112.344C45.0597 112.152 45.1824 111.981 45.4277 111.832C45.6837 111.672 45.9984 111.549 46.3717 111.464C46.745 111.368 47.113 111.32 47.4757 111.32C48.265 111.32 48.8944 111.469 49.3637 111.768C49.833 112.056 50.1744 112.435 50.3877 112.904C50.601 113.373 50.7077 113.88 50.7077 114.424V118.44C50.7077 118.589 50.6277 118.723 50.4677 118.84C50.3184 118.947 50.1264 119 49.8917 119C49.6784 119 49.497 118.947 49.3477 118.84C49.1984 118.723 49.1237 118.589 49.1237 118.44V117.88C48.8464 118.2 48.5104 118.488 48.1157 118.744C47.721 119 47.2517 119.128 46.7077 119.128ZM47.3157 117.848C47.5824 117.848 47.8437 117.768 48.0997 117.608C48.3664 117.448 48.585 117.245 48.7557 117C48.937 116.755 49.0277 116.504 49.0277 116.248V115.656H48.6277C48.2224 115.656 47.8384 115.683 47.4757 115.736C47.113 115.779 46.8197 115.885 46.5957 116.056C46.3824 116.216 46.2757 116.467 46.2757 116.808C46.2757 117.171 46.3717 117.437 46.5637 117.608C46.7664 117.768 47.017 117.848 47.3157 117.848ZM53.2194 119C52.9848 119 52.7874 118.941 52.6274 118.824C52.4781 118.707 52.4034 118.579 52.4034 118.44V111.96C52.4034 111.8 52.4781 111.672 52.6274 111.576C52.7874 111.469 52.9848 111.416 53.2194 111.416C53.4328 111.416 53.6141 111.469 53.7634 111.576C53.9128 111.672 53.9874 111.8 53.9874 111.96V112.664C54.1048 112.44 54.2594 112.227 54.4514 112.024C54.6541 111.821 54.8888 111.656 55.1554 111.528C55.4221 111.389 55.7101 111.32 56.0194 111.32H56.5314C56.7021 111.32 56.8514 111.395 56.9794 111.544C57.1074 111.683 57.1714 111.853 57.1714 112.056C57.1714 112.259 57.1074 112.435 56.9794 112.584C56.8514 112.733 56.7021 112.808 56.5314 112.808H56.0194C55.6994 112.808 55.3901 112.904 55.0914 113.096C54.7928 113.288 54.5474 113.56 54.3554 113.912C54.1741 114.253 54.0834 114.669 54.0834 115.16V118.44C54.0834 118.579 53.9981 118.707 53.8274 118.824C53.6674 118.941 53.4648 119 53.2194 119ZM60.4158 119.128C59.9145 119.128 59.4505 118.979 59.0238 118.68C58.5971 118.381 58.2505 117.992 57.9838 117.512C57.7278 117.021 57.5998 116.499 57.5998 115.944V114.472C57.5998 113.885 57.7278 113.357 57.9838 112.888C58.2505 112.408 58.5971 112.029 59.0238 111.752C59.4505 111.464 59.9251 111.32 60.4478 111.32C60.9598 111.32 61.3918 111.448 61.7438 111.704C62.0958 111.949 62.3571 112.227 62.5278 112.536V107.448C62.5278 107.288 62.6131 107.16 62.7838 107.064C62.9545 106.957 63.1571 106.904 63.3918 106.904C63.6265 106.904 63.8185 106.957 63.9678 107.064C64.1278 107.16 64.2078 107.288 64.2078 107.448V118.44C64.2078 118.579 64.1278 118.707 63.9678 118.824C63.8185 118.941 63.6265 119 63.3918 119C63.1891 119 63.0078 118.941 62.8478 118.824C62.6985 118.707 62.6238 118.579 62.6238 118.44V117.88C62.4638 118.211 62.1811 118.504 61.7758 118.76C61.3705 119.005 60.9171 119.128 60.4158 119.128ZM60.8958 117.64C61.2051 117.64 61.4825 117.555 61.7278 117.384C61.9731 117.213 62.1651 117.027 62.3038 116.824C62.4531 116.611 62.5278 116.44 62.5278 116.312V114.472C62.5278 114.12 62.4478 113.821 62.2878 113.576C62.1278 113.331 61.9251 113.144 61.6798 113.016C61.4345 112.877 61.1785 112.808 60.9118 112.808C60.6131 112.808 60.3358 112.888 60.0798 113.048C59.8345 113.208 59.6371 113.416 59.4878 113.672C59.3491 113.928 59.2798 114.195 59.2798 114.472V115.944C59.2798 116.221 59.3491 116.493 59.4878 116.76C59.6371 117.027 59.8345 117.24 60.0798 117.4C60.3251 117.56 60.5971 117.64 60.8958 117.64ZM69.7896 119.128C69.2882 119.128 68.8349 119.005 68.4296 118.76C68.0349 118.504 67.7522 118.211 67.5816 117.88V118.44C67.5816 118.579 67.5069 118.707 67.3576 118.824C67.2082 118.941 67.0269 119 66.8136 119C66.5789 119 66.3816 118.941 66.2216 118.824C66.0722 118.707 65.9976 118.579 65.9976 118.44V107.448C65.9976 107.288 66.0722 107.16 66.2216 107.064C66.3816 106.957 66.5789 106.904 66.8136 106.904C67.0589 106.904 67.2616 106.957 67.4216 107.064C67.5922 107.16 67.6776 107.288 67.6776 107.448V112.536C67.8482 112.227 68.1096 111.949 68.4616 111.704C68.8136 111.448 69.2402 111.32 69.7416 111.32C70.2642 111.32 70.7389 111.464 71.1656 111.752C71.6029 112.029 71.9496 112.408 72.2056 112.888C72.4722 113.357 72.6056 113.885 72.6056 114.472V115.944C72.6056 116.499 72.4722 117.021 72.2056 117.512C71.9496 117.992 71.6082 118.381 71.1816 118.68C70.7549 118.979 70.2909 119.128 69.7896 119.128ZM69.3096 117.64C69.5976 117.64 69.8642 117.56 70.1096 117.4C70.3549 117.24 70.5522 117.027 70.7016 116.76C70.8509 116.493 70.9256 116.221 70.9256 115.944V114.472C70.9256 114.195 70.8509 113.928 70.7016 113.672C70.5522 113.416 70.3549 113.208 70.1096 113.048C69.8642 112.888 69.5922 112.808 69.2936 112.808C69.0269 112.808 68.7709 112.877 68.5256 113.016C68.2802 113.144 68.0776 113.331 67.9176 113.576C67.7576 113.821 67.6776 114.12 67.6776 114.472V116.312C67.6776 116.44 67.7469 116.611 67.8856 116.824C68.0349 117.027 68.2322 117.213 68.4776 117.384C68.7229 117.555 69.0002 117.64 69.3096 117.64ZM77.0673 119.128C76.4913 119.128 75.9526 118.979 75.4513 118.68C74.95 118.381 74.5446 117.992 74.2353 117.512C73.9366 117.021 73.7873 116.499 73.7873 115.944V114.472C73.7873 113.907 73.9313 113.384 74.2193 112.904C74.518 112.424 74.918 112.04 75.4193 111.752C75.9313 111.464 76.486 111.32 77.0833 111.32C77.6806 111.32 78.23 111.464 78.7313 111.752C79.2326 112.029 79.6326 112.408 79.9313 112.888C80.2406 113.357 80.3953 113.885 80.3953 114.472V115.944C80.3953 116.488 80.2406 117.005 79.9313 117.496C79.6326 117.987 79.2273 118.381 78.7153 118.68C78.214 118.979 77.6646 119.128 77.0673 119.128ZM77.0833 117.64C77.382 117.64 77.654 117.56 77.8993 117.4C78.1446 117.24 78.342 117.032 78.4913 116.776C78.6406 116.509 78.7153 116.232 78.7153 115.944V114.472C78.7153 114.195 78.6406 113.928 78.4913 113.672C78.342 113.416 78.1446 113.208 77.8993 113.048C77.654 112.888 77.382 112.808 77.0833 112.808C76.774 112.808 76.4966 112.888 76.2513 113.048C76.0166 113.208 75.8246 113.416 75.6753 113.672C75.5366 113.928 75.4673 114.195 75.4673 114.472V115.944C75.4673 116.232 75.5366 116.509 75.6753 116.776C75.8246 117.032 76.022 117.24 76.2673 117.4C76.5126 117.56 76.7846 117.64 77.0833 117.64ZM83.5046 119.128C82.9179 119.128 82.4166 118.957 82.0006 118.616C81.5846 118.264 81.3766 117.731 81.3766 117.016C81.3766 116.408 81.5366 115.939 81.8566 115.608C82.1766 115.277 82.6139 115.048 83.1686 114.92C83.7339 114.792 84.3846 114.728 85.1206 114.728H85.8246V114.44C85.8246 114.163 85.7712 113.896 85.6646 113.64C85.5686 113.373 85.4032 113.155 85.1686 112.984C84.9446 112.803 84.6352 112.712 84.2406 112.712C83.8459 112.712 83.5419 112.749 83.3286 112.824C83.1152 112.899 82.9446 112.979 82.8166 113.064C82.6886 113.149 82.5712 113.192 82.4646 113.192C82.2726 113.192 82.1232 113.101 82.0166 112.92C81.9099 112.728 81.8566 112.536 81.8566 112.344C81.8566 112.152 81.9792 111.981 82.2246 111.832C82.4806 111.672 82.7952 111.549 83.1686 111.464C83.5419 111.368 83.9099 111.32 84.2726 111.32C85.0619 111.32 85.6912 111.469 86.1606 111.768C86.6299 112.056 86.9712 112.435 87.1846 112.904C87.3979 113.373 87.5046 113.88 87.5046 114.424V118.44C87.5046 118.589 87.4246 118.723 87.2646 118.84C87.1152 118.947 86.9232 119 86.6886 119C86.4752 119 86.2939 118.947 86.1446 118.84C85.9952 118.723 85.9206 118.589 85.9206 118.44V117.88C85.6432 118.2 85.3072 118.488 84.9126 118.744C84.5179 119 84.0486 119.128 83.5046 119.128ZM84.1126 117.848C84.3792 117.848 84.6406 117.768 84.8966 117.608C85.1632 117.448 85.3819 117.245 85.5526 117C85.7339 116.755 85.8246 116.504 85.8246 116.248V115.656H85.4246C85.0192 115.656 84.6352 115.683 84.2726 115.736C83.9099 115.779 83.6166 115.885 83.3926 116.056C83.1792 116.216 83.0726 116.467 83.0726 116.808C83.0726 117.171 83.1686 117.437 83.3606 117.608C83.5632 117.768 83.8139 117.848 84.1126 117.848ZM90.0163 119C89.7816 119 89.5843 118.941 89.4243 118.824C89.275 118.707 89.2003 118.579 89.2003 118.44V111.96C89.2003 111.8 89.275 111.672 89.4243 111.576C89.5843 111.469 89.7816 111.416 90.0163 111.416C90.2296 111.416 90.411 111.469 90.5603 111.576C90.7096 111.672 90.7843 111.8 90.7843 111.96V112.664C90.9016 112.44 91.0563 112.227 91.2483 112.024C91.451 111.821 91.6856 111.656 91.9523 111.528C92.219 111.389 92.507 111.32 92.8163 111.32H93.3283C93.499 111.32 93.6483 111.395 93.7763 111.544C93.9043 111.683 93.9683 111.853 93.9683 112.056C93.9683 112.259 93.9043 112.435 93.7763 112.584C93.6483 112.733 93.499 112.808 93.3283 112.808H92.8163C92.4963 112.808 92.187 112.904 91.8883 113.096C91.5896 113.288 91.3443 113.56 91.1523 113.912C90.971 114.253 90.8803 114.669 90.8803 115.16V118.44C90.8803 118.579 90.795 118.707 90.6243 118.824C90.4643 118.941 90.2616 119 90.0163 119ZM97.2127 119.128C96.7114 119.128 96.2474 118.979 95.8207 118.68C95.394 118.381 95.0474 117.992 94.7807 117.512C94.5247 117.021 94.3967 116.499 94.3967 115.944V114.472C94.3967 113.885 94.5247 113.357 94.7807 112.888C95.0474 112.408 95.394 112.029 95.8207 111.752C96.2474 111.464 96.722 111.32 97.2447 111.32C97.7567 111.32 98.1887 111.448 98.5407 111.704C98.8927 111.949 99.154 112.227 99.3247 112.536V107.448C99.3247 107.288 99.41 107.16 99.5807 107.064C99.7514 106.957 99.954 106.904 100.189 106.904C100.423 106.904 100.615 106.957 100.765 107.064C100.925 107.16 101.005 107.288 101.005 107.448V118.44C101.005 118.579 100.925 118.707 100.765 118.824C100.615 118.941 100.423 119 100.189 119C99.986 119 99.8047 118.941 99.6447 118.824C99.4954 118.707 99.4207 118.579 99.4207 118.44V117.88C99.2607 118.211 98.978 118.504 98.5727 118.76C98.1674 119.005 97.714 119.128 97.2127 119.128ZM97.6927 117.64C98.002 117.64 98.2794 117.555 98.5247 117.384C98.77 117.213 98.962 117.027 99.1007 116.824C99.25 116.611 99.3247 116.44 99.3247 116.312V114.472C99.3247 114.12 99.2447 113.821 99.0847 113.576C98.9247 113.331 98.722 113.144 98.4767 113.016C98.2314 112.877 97.9754 112.808 97.7087 112.808C97.41 112.808 97.1327 112.888 96.8767 113.048C96.6314 113.208 96.434 113.416 96.2847 113.672C96.146 113.928 96.0767 114.195 96.0767 114.472V115.944C96.0767 116.221 96.146 116.493 96.2847 116.76C96.434 117.027 96.6314 117.24 96.8767 117.4C97.122 117.56 97.394 117.64 97.6927 117.64ZM107.63 119.128C107.043 119.128 106.542 118.957 106.126 118.616C105.71 118.264 105.502 117.731 105.502 117.016C105.502 116.408 105.662 115.939 105.982 115.608C106.302 115.277 106.739 115.048 107.294 114.92C107.859 114.792 108.51 114.728 109.246 114.728H109.95V114.44C109.95 114.163 109.896 113.896 109.79 113.64C109.694 113.373 109.528 113.155 109.294 112.984C109.07 112.803 108.76 112.712 108.366 112.712C107.971 112.712 107.667 112.749 107.454 112.824C107.24 112.899 107.07 112.979 106.942 113.064C106.814 113.149 106.696 113.192 106.59 113.192C106.398 113.192 106.248 113.101 106.142 112.92C106.035 112.728 105.982 112.536 105.982 112.344C105.982 112.152 106.104 111.981 106.35 111.832C106.606 111.672 106.92 111.549 107.294 111.464C107.667 111.368 108.035 111.32 108.398 111.32C109.187 111.32 109.816 111.469 110.286 111.768C110.755 112.056 111.096 112.435 111.31 112.904C111.523 113.373 111.63 113.88 111.63 114.424V118.44C111.63 118.589 111.55 118.723 111.39 118.84C111.24 118.947 111.048 119 110.814 119C110.6 119 110.419 118.947 110.27 118.84C110.12 118.723 110.046 118.589 110.046 118.44V117.88C109.768 118.2 109.432 118.488 109.038 118.744C108.643 119 108.174 119.128 107.63 119.128ZM108.238 117.848C108.504 117.848 108.766 117.768 109.022 117.608C109.288 117.448 109.507 117.245 109.678 117C109.859 116.755 109.95 116.504 109.95 116.248V115.656H109.55C109.144 115.656 108.76 115.683 108.398 115.736C108.035 115.779 107.742 115.885 107.518 116.056C107.304 116.216 107.198 116.467 107.198 116.808C107.198 117.171 107.294 117.437 107.486 117.608C107.688 117.768 107.939 117.848 108.238 117.848ZM114.157 119C113.912 119 113.709 118.941 113.549 118.824C113.4 118.707 113.325 118.579 113.325 118.44V111.96C113.325 111.8 113.4 111.672 113.549 111.576C113.709 111.469 113.912 111.416 114.157 111.416C114.36 111.416 114.536 111.469 114.685 111.576C114.835 111.672 114.909 111.8 114.909 111.96V112.536C115.069 112.227 115.331 111.949 115.693 111.704C116.067 111.448 116.52 111.32 117.053 111.32C117.555 111.32 118.013 111.464 118.429 111.752C118.856 112.029 119.197 112.408 119.453 112.888C119.709 113.357 119.837 113.885 119.837 114.472V118.44C119.837 118.621 119.747 118.76 119.565 118.856C119.395 118.952 119.203 119 118.989 119C118.797 119 118.611 118.952 118.429 118.856C118.248 118.76 118.157 118.621 118.157 118.44V114.472C118.157 114.195 118.083 113.928 117.933 113.672C117.795 113.416 117.603 113.208 117.357 113.048C117.112 112.888 116.84 112.808 116.541 112.808C116.285 112.808 116.04 112.877 115.805 113.016C115.571 113.144 115.379 113.331 115.229 113.576C115.08 113.821 115.005 114.12 115.005 114.472V118.44C115.005 118.579 114.92 118.707 114.749 118.824C114.589 118.941 114.392 119 114.157 119ZM124.041 119.128C123.539 119.128 123.075 118.979 122.649 118.68C122.222 118.381 121.875 117.992 121.609 117.512C121.353 117.021 121.225 116.499 121.225 115.944V114.472C121.225 113.885 121.353 113.357 121.609 112.888C121.875 112.408 122.222 112.029 122.649 111.752C123.075 111.464 123.55 111.32 124.073 111.32C124.585 111.32 125.017 111.448 125.369 111.704C125.721 111.949 125.982 112.227 126.153 112.536V107.448C126.153 107.288 126.238 107.16 126.409 107.064C126.579 106.957 126.782 106.904 127.017 106.904C127.251 106.904 127.443 106.957 127.593 107.064C127.753 107.16 127.833 107.288 127.833 107.448V118.44C127.833 118.579 127.753 118.707 127.593 118.824C127.443 118.941 127.251 119 127.017 119C126.814 119 126.633 118.941 126.473 118.824C126.323 118.707 126.249 118.579 126.249 118.44V117.88C126.089 118.211 125.806 118.504 125.401 118.76C124.995 119.005 124.542 119.128 124.041 119.128ZM124.521 117.64C124.83 117.64 125.107 117.555 125.353 117.384C125.598 117.213 125.79 117.027 125.929 116.824C126.078 116.611 126.153 116.44 126.153 116.312V114.472C126.153 114.12 126.073 113.821 125.913 113.576C125.753 113.331 125.55 113.144 125.305 113.016C125.059 112.877 124.803 112.808 124.537 112.808C124.238 112.808 123.961 112.888 123.705 113.048C123.459 113.208 123.262 113.416 123.113 113.672C122.974 113.928 122.905 114.195 122.905 114.472V115.944C122.905 116.221 122.974 116.493 123.113 116.76C123.262 117.027 123.459 117.24 123.705 117.4C123.95 117.56 124.222 117.64 124.521 117.64ZM135.882 119.128C135.114 119.128 134.479 118.989 133.978 118.712C133.487 118.435 133.124 118.056 132.89 117.576C132.655 117.096 132.538 116.552 132.538 115.944V114.504C132.538 113.907 132.655 113.368 132.89 112.888C133.124 112.397 133.487 112.013 133.978 111.736C134.468 111.459 135.092 111.32 135.85 111.32C136.34 111.32 136.767 111.379 137.13 111.496C137.503 111.613 137.791 111.763 137.994 111.944C138.207 112.115 138.314 112.296 138.314 112.488C138.314 112.584 138.282 112.701 138.218 112.84C138.164 112.968 138.084 113.08 137.978 113.176C137.882 113.261 137.764 113.304 137.626 113.304C137.519 113.304 137.402 113.261 137.274 113.176C137.156 113.091 136.996 113.011 136.794 112.936C136.591 112.851 136.319 112.808 135.978 112.808C135.38 112.808 134.938 112.957 134.65 113.256C134.362 113.555 134.218 113.971 134.218 114.504V115.944C134.218 116.477 134.362 116.893 134.65 117.192C134.938 117.491 135.386 117.64 135.994 117.64C136.346 117.64 136.623 117.597 136.826 117.512C137.028 117.416 137.188 117.325 137.306 117.24C137.434 117.155 137.556 117.112 137.674 117.112C137.823 117.112 137.951 117.155 138.058 117.24C138.175 117.325 138.26 117.432 138.314 117.56C138.378 117.688 138.41 117.805 138.41 117.912C138.41 118.093 138.298 118.28 138.074 118.472C137.86 118.664 137.562 118.824 137.178 118.952C136.804 119.069 136.372 119.128 135.882 119.128ZM141.255 119.128C140.668 119.128 140.167 118.957 139.751 118.616C139.335 118.264 139.127 117.731 139.127 117.016C139.127 116.408 139.287 115.939 139.607 115.608C139.927 115.277 140.364 115.048 140.919 114.92C141.484 114.792 142.135 114.728 142.871 114.728H143.575V114.44C143.575 114.163 143.521 113.896 143.415 113.64C143.319 113.373 143.153 113.155 142.919 112.984C142.695 112.803 142.385 112.712 141.991 112.712C141.596 112.712 141.292 112.749 141.079 112.824C140.865 112.899 140.695 112.979 140.567 113.064C140.439 113.149 140.321 113.192 140.215 113.192C140.023 113.192 139.873 113.101 139.767 112.92C139.66 112.728 139.607 112.536 139.607 112.344C139.607 112.152 139.729 111.981 139.975 111.832C140.231 111.672 140.545 111.549 140.919 111.464C141.292 111.368 141.66 111.32 142.023 111.32C142.812 111.32 143.441 111.469 143.911 111.768C144.38 112.056 144.721 112.435 144.935 112.904C145.148 113.373 145.255 113.88 145.255 114.424V118.44C145.255 118.589 145.175 118.723 145.015 118.84C144.865 118.947 144.673 119 144.439 119C144.225 119 144.044 118.947 143.895 118.84C143.745 118.723 143.671 118.589 143.671 118.44V117.88C143.393 118.2 143.057 118.488 142.663 118.744C142.268 119 141.799 119.128 141.255 119.128ZM141.863 117.848C142.129 117.848 142.391 117.768 142.647 117.608C142.913 117.448 143.132 117.245 143.303 117C143.484 116.755 143.575 116.504 143.575 116.248V115.656H143.175C142.769 115.656 142.385 115.683 142.023 115.736C141.66 115.779 141.367 115.885 141.143 116.056C140.929 116.216 140.823 116.467 140.823 116.808C140.823 117.171 140.919 117.437 141.111 117.608C141.313 117.768 141.564 117.848 141.863 117.848ZM147.782 119C147.537 119 147.334 118.941 147.174 118.824C147.025 118.707 146.95 118.579 146.95 118.44V111.96C146.95 111.8 147.025 111.672 147.174 111.576C147.334 111.469 147.537 111.416 147.782 111.416C147.985 111.416 148.161 111.469 148.31 111.576C148.46 111.672 148.534 111.8 148.534 111.96V112.536C148.694 112.227 148.956 111.949 149.318 111.704C149.692 111.448 150.145 111.32 150.678 111.32C151.18 111.32 151.638 111.464 152.054 111.752C152.481 112.029 152.822 112.408 153.078 112.888C153.334 113.357 153.462 113.885 153.462 114.472V118.44C153.462 118.621 153.372 118.76 153.19 118.856C153.02 118.952 152.828 119 152.614 119C152.422 119 152.236 118.952 152.054 118.856C151.873 118.76 151.782 118.621 151.782 118.44V114.472C151.782 114.195 151.708 113.928 151.558 113.672C151.42 113.416 151.228 113.208 150.982 113.048C150.737 112.888 150.465 112.808 150.166 112.808C149.91 112.808 149.665 112.877 149.43 113.016C149.196 113.144 149.004 113.331 148.854 113.576C148.705 113.821 148.63 114.12 148.63 114.472V118.44C148.63 118.579 148.545 118.707 148.374 118.824C148.214 118.941 148.017 119 147.782 119ZM162.149 119.128C161.648 119.128 161.194 119.005 160.789 118.76C160.394 118.504 160.112 118.211 159.941 117.88V118.44C159.941 118.579 159.866 118.707 159.717 118.824C159.568 118.941 159.386 119 159.173 119C158.938 119 158.741 118.941 158.581 118.824C158.432 118.707 158.357 118.579 158.357 118.44V107.448C158.357 107.288 158.432 107.16 158.581 107.064C158.741 106.957 158.938 106.904 159.173 106.904C159.418 106.904 159.621 106.957 159.781 107.064C159.952 107.16 160.037 107.288 160.037 107.448V112.536C160.208 112.227 160.469 111.949 160.821 111.704C161.173 111.448 161.6 111.32 162.101 111.32C162.624 111.32 163.098 111.464 163.525 111.752C163.962 112.029 164.309 112.408 164.565 112.888C164.832 113.357 164.965 113.885 164.965 114.472V115.944C164.965 116.499 164.832 117.021 164.565 117.512C164.309 117.992 163.968 118.381 163.541 118.68C163.114 118.979 162.65 119.128 162.149 119.128ZM161.669 117.64C161.957 117.64 162.224 117.56 162.469 117.4C162.714 117.24 162.912 117.027 163.061 116.76C163.21 116.493 163.285 116.221 163.285 115.944V114.472C163.285 114.195 163.21 113.928 163.061 113.672C162.912 113.416 162.714 113.208 162.469 113.048C162.224 112.888 161.952 112.808 161.653 112.808C161.386 112.808 161.13 112.877 160.885 113.016C160.64 113.144 160.437 113.331 160.277 113.576C160.117 113.821 160.037 114.12 160.037 114.472V116.312C160.037 116.44 160.106 116.611 160.245 116.824C160.394 117.027 160.592 117.213 160.837 117.384C161.082 117.555 161.36 117.64 161.669 117.64ZM169.859 119.128C169.133 119.128 168.493 118.995 167.939 118.728C167.384 118.461 166.947 118.093 166.627 117.624C166.307 117.144 166.147 116.584 166.147 115.944V114.424C166.147 113.859 166.296 113.341 166.595 112.872C166.904 112.403 167.309 112.029 167.811 111.752C168.312 111.464 168.867 111.32 169.475 111.32C170.051 111.32 170.579 111.448 171.059 111.704C171.539 111.949 171.923 112.296 172.211 112.744C172.509 113.192 172.659 113.704 172.659 114.28C172.659 114.728 172.589 115.048 172.451 115.24C172.312 115.432 172.131 115.549 171.907 115.592C171.683 115.635 171.448 115.656 171.203 115.656H167.827V116.024C167.827 116.557 168.019 116.984 168.403 117.304C168.797 117.613 169.299 117.768 169.907 117.768C170.28 117.768 170.584 117.715 170.819 117.608C171.053 117.501 171.251 117.4 171.411 117.304C171.571 117.208 171.72 117.16 171.859 117.16C171.997 117.16 172.115 117.203 172.211 117.288C172.307 117.373 172.381 117.475 172.435 117.592C172.488 117.709 172.515 117.816 172.515 117.912C172.515 118.072 172.403 118.248 172.179 118.44C171.965 118.632 171.661 118.797 171.267 118.936C170.872 119.064 170.403 119.128 169.859 119.128ZM167.827 114.616H170.483C170.717 114.616 170.872 114.584 170.947 114.52C171.032 114.456 171.075 114.328 171.075 114.136C171.075 113.859 171.005 113.603 170.867 113.368C170.728 113.123 170.536 112.936 170.291 112.808C170.045 112.669 169.768 112.6 169.459 112.6C169.16 112.6 168.888 112.664 168.643 112.792C168.397 112.92 168.2 113.096 168.051 113.32C167.901 113.544 167.827 113.805 167.827 114.104V114.616ZM178.048 119C177.813 119 177.616 118.941 177.456 118.824C177.306 118.707 177.232 118.579 177.232 118.44V111.96C177.232 111.8 177.306 111.672 177.456 111.576C177.616 111.469 177.813 111.416 178.048 111.416C178.261 111.416 178.442 111.469 178.592 111.576C178.741 111.672 178.816 111.8 178.816 111.96V112.664C178.933 112.44 179.088 112.227 179.28 112.024C179.482 111.821 179.717 111.656 179.984 111.528C180.25 111.389 180.538 111.32 180.848 111.32H181.36C181.53 111.32 181.68 111.395 181.808 111.544C181.936 111.683 182 111.853 182 112.056C182 112.259 181.936 112.435 181.808 112.584C181.68 112.733 181.53 112.808 181.36 112.808H180.848C180.528 112.808 180.218 112.904 179.92 113.096C179.621 113.288 179.376 113.56 179.184 113.912C179.002 114.253 178.912 114.669 178.912 115.16V118.44C178.912 118.579 178.826 118.707 178.656 118.824C178.496 118.941 178.293 119 178.048 119ZM186.14 119.128C185.415 119.128 184.775 118.995 184.22 118.728C183.665 118.461 183.228 118.093 182.908 117.624C182.588 117.144 182.428 116.584 182.428 115.944V114.424C182.428 113.859 182.577 113.341 182.876 112.872C183.185 112.403 183.591 112.029 184.092 111.752C184.593 111.464 185.148 111.32 185.756 111.32C186.332 111.32 186.86 111.448 187.34 111.704C187.82 111.949 188.204 112.296 188.492 112.744C188.791 113.192 188.94 113.704 188.94 114.28C188.94 114.728 188.871 115.048 188.732 115.24C188.593 115.432 188.412 115.549 188.188 115.592C187.964 115.635 187.729 115.656 187.484 115.656H184.108V116.024C184.108 116.557 184.3 116.984 184.684 117.304C185.079 117.613 185.58 117.768 186.188 117.768C186.561 117.768 186.865 117.715 187.1 117.608C187.335 117.501 187.532 117.4 187.692 117.304C187.852 117.208 188.001 117.16 188.14 117.16C188.279 117.16 188.396 117.203 188.492 117.288C188.588 117.373 188.663 117.475 188.716 117.592C188.769 117.709 188.796 117.816 188.796 117.912C188.796 118.072 188.684 118.248 188.46 118.44C188.247 118.632 187.943 118.797 187.548 118.936C187.153 119.064 186.684 119.128 186.14 119.128ZM184.108 114.616H186.764C186.999 114.616 187.153 114.584 187.228 114.52C187.313 114.456 187.356 114.328 187.356 114.136C187.356 113.859 187.287 113.603 187.148 113.368C187.009 113.123 186.817 112.936 186.572 112.808C186.327 112.669 186.049 112.6 185.74 112.6C185.441 112.6 185.169 112.664 184.924 112.792C184.679 112.92 184.481 113.096 184.332 113.32C184.183 113.544 184.108 113.805 184.108 114.104V114.616ZM193.382 119.128C192.614 119.128 191.979 118.989 191.478 118.712C190.987 118.435 190.624 118.056 190.39 117.576C190.155 117.096 190.038 116.552 190.038 115.944V114.504C190.038 113.907 190.155 113.368 190.39 112.888C190.624 112.397 190.987 112.013 191.478 111.736C191.968 111.459 192.592 111.32 193.35 111.32C193.84 111.32 194.267 111.379 194.63 111.496C195.003 111.613 195.291 111.763 195.494 111.944C195.707 112.115 195.814 112.296 195.814 112.488C195.814 112.584 195.782 112.701 195.718 112.84C195.664 112.968 195.584 113.08 195.478 113.176C195.382 113.261 195.264 113.304 195.126 113.304C195.019 113.304 194.902 113.261 194.774 113.176C194.656 113.091 194.496 113.011 194.294 112.936C194.091 112.851 193.819 112.808 193.478 112.808C192.88 112.808 192.438 112.957 192.15 113.256C191.862 113.555 191.718 113.971 191.718 114.504V115.944C191.718 116.477 191.862 116.893 192.15 117.192C192.438 117.491 192.886 117.64 193.494 117.64C193.846 117.64 194.123 117.597 194.326 117.512C194.528 117.416 194.688 117.325 194.806 117.24C194.934 117.155 195.056 117.112 195.174 117.112C195.323 117.112 195.451 117.155 195.558 117.24C195.675 117.325 195.76 117.432 195.814 117.56C195.878 117.688 195.91 117.805 195.91 117.912C195.91 118.093 195.798 118.28 195.574 118.472C195.36 118.664 195.062 118.824 194.678 118.952C194.304 119.069 193.872 119.128 193.382 119.128ZM197.139 122.6C196.925 122.6 196.744 122.552 196.595 122.456C196.445 122.371 196.371 122.179 196.371 121.88C196.371 121.688 196.403 121.517 196.467 121.368C196.531 121.229 196.648 121.16 196.819 121.16C197.021 121.16 197.24 121.107 197.475 121C197.72 120.904 197.955 120.744 198.179 120.52C198.413 120.307 198.611 120.035 198.771 119.704C198.941 119.373 199.059 118.984 199.123 118.536L196.419 112.328C196.376 112.253 196.355 112.179 196.355 112.104C196.355 111.965 196.413 111.837 196.531 111.72C196.659 111.592 196.808 111.491 196.979 111.416C197.149 111.341 197.309 111.304 197.459 111.304C197.565 111.304 197.667 111.331 197.763 111.384C197.869 111.427 197.939 111.501 197.971 111.608L199.987 116.808L201.731 111.608C201.763 111.501 201.827 111.427 201.923 111.384C202.019 111.331 202.115 111.304 202.211 111.304C202.339 111.304 202.488 111.341 202.659 111.416C202.84 111.491 202.995 111.592 203.123 111.72C203.261 111.837 203.331 111.976 203.331 112.136C203.331 112.221 203.315 112.285 203.283 112.328L200.883 118.584C200.712 119.043 200.536 119.507 200.355 119.976C200.173 120.456 199.949 120.893 199.683 121.288C199.427 121.683 199.091 121.997 198.675 122.232C198.269 122.477 197.757 122.6 197.139 122.6ZM207.444 119.128C206.676 119.128 206.042 118.989 205.54 118.712C205.05 118.435 204.687 118.056 204.452 117.576C204.218 117.096 204.1 116.552 204.1 115.944V114.504C204.1 113.907 204.218 113.368 204.452 112.888C204.687 112.397 205.05 112.013 205.54 111.736C206.031 111.459 206.655 111.32 207.412 111.32C207.903 111.32 208.33 111.379 208.692 111.496C209.066 111.613 209.354 111.763 209.556 111.944C209.77 112.115 209.876 112.296 209.876 112.488C209.876 112.584 209.844 112.701 209.78 112.84C209.727 112.968 209.647 113.08 209.54 113.176C209.444 113.261 209.327 113.304 209.188 113.304C209.082 113.304 208.964 113.261 208.836 113.176C208.719 113.091 208.559 113.011 208.356 112.936C208.154 112.851 207.882 112.808 207.54 112.808C206.943 112.808 206.5 112.957 206.212 113.256C205.924 113.555 205.78 113.971 205.78 114.504V115.944C205.78 116.477 205.924 116.893 206.212 117.192C206.5 117.491 206.948 117.64 207.556 117.64C207.908 117.64 208.186 117.597 208.388 117.512C208.591 117.416 208.751 117.325 208.868 117.24C208.996 117.155 209.119 117.112 209.236 117.112C209.386 117.112 209.514 117.155 209.62 117.24C209.738 117.325 209.823 117.432 209.876 117.56C209.94 117.688 209.972 117.805 209.972 117.912C209.972 118.093 209.86 118.28 209.636 118.472C209.423 118.664 209.124 118.824 208.74 118.952C208.367 119.069 207.935 119.128 207.444 119.128ZM212.145 119C211.9 119 211.697 118.941 211.537 118.824C211.388 118.707 211.313 118.579 211.313 118.44V107.448C211.313 107.288 211.388 107.16 211.537 107.064C211.697 106.957 211.9 106.904 212.145 106.904C212.38 106.904 212.577 106.957 212.737 107.064C212.908 107.16 212.993 107.288 212.993 107.448V118.44C212.993 118.579 212.908 118.707 212.737 118.824C212.577 118.941 212.38 119 212.145 119ZM218.312 119.128C217.586 119.128 216.946 118.995 216.392 118.728C215.837 118.461 215.4 118.093 215.08 117.624C214.76 117.144 214.6 116.584 214.6 115.944V114.424C214.6 113.859 214.749 113.341 215.048 112.872C215.357 112.403 215.762 112.029 216.264 111.752C216.765 111.464 217.32 111.32 217.928 111.32C218.504 111.32 219.032 111.448 219.512 111.704C219.992 111.949 220.376 112.296 220.664 112.744C220.962 113.192 221.112 113.704 221.112 114.28C221.112 114.728 221.042 115.048 220.904 115.24C220.765 115.432 220.584 115.549 220.36 115.592C220.136 115.635 219.901 115.656 219.656 115.656H216.28V116.024C216.28 116.557 216.472 116.984 216.856 117.304C217.25 117.613 217.752 117.768 218.36 117.768C218.733 117.768 219.037 117.715 219.272 117.608C219.506 117.501 219.704 117.4 219.864 117.304C220.024 117.208 220.173 117.16 220.312 117.16C220.45 117.16 220.568 117.203 220.664 117.288C220.76 117.373 220.834 117.475 220.888 117.592C220.941 117.709 220.968 117.816 220.968 117.912C220.968 118.072 220.856 118.248 220.632 118.44C220.418 118.632 220.114 118.797 219.72 118.936C219.325 119.064 218.856 119.128 218.312 119.128ZM216.28 114.616H218.936C219.17 114.616 219.325 114.584 219.4 114.52C219.485 114.456 219.528 114.328 219.528 114.136C219.528 113.859 219.458 113.603 219.32 113.368C219.181 113.123 218.989 112.936 218.744 112.808C218.498 112.669 218.221 112.6 217.912 112.6C217.613 112.6 217.341 112.664 217.096 112.792C216.85 112.92 216.653 113.096 216.504 113.32C216.354 113.544 216.28 113.805 216.28 114.104V114.616ZM225.01 119.128C224.508 119.128 224.044 118.979 223.618 118.68C223.191 118.381 222.844 117.992 222.578 117.512C222.322 117.021 222.194 116.499 222.194 115.944V114.472C222.194 113.885 222.322 113.357 222.578 112.888C222.844 112.408 223.191 112.029 223.618 111.752C224.044 111.464 224.519 111.32 225.042 111.32C225.554 111.32 225.986 111.448 226.338 111.704C226.69 111.949 226.951 112.227 227.122 112.536V107.448C227.122 107.288 227.207 107.16 227.378 107.064C227.548 106.957 227.751 106.904 227.986 106.904C228.22 106.904 228.412 106.957 228.562 107.064C228.722 107.16 228.802 107.288 228.802 107.448V118.44C228.802 118.579 228.722 118.707 228.562 118.824C228.412 118.941 228.22 119 227.986 119C227.783 119 227.602 118.941 227.442 118.824C227.292 118.707 227.218 118.579 227.218 118.44V117.88C227.058 118.211 226.775 118.504 226.37 118.76C225.964 119.005 225.511 119.128 225.01 119.128ZM225.49 117.64C225.799 117.64 226.076 117.555 226.322 117.384C226.567 117.213 226.759 117.027 226.898 116.824C227.047 116.611 227.122 116.44 227.122 116.312V114.472C227.122 114.12 227.042 113.821 226.882 113.576C226.722 113.331 226.519 113.144 226.274 113.016C226.028 112.877 225.772 112.808 225.506 112.808C225.207 112.808 224.93 112.888 224.674 113.048C224.428 113.208 224.231 113.416 224.082 113.672C223.943 113.928 223.874 114.195 223.874 114.472V115.944C223.874 116.221 223.943 116.493 224.082 116.76C224.231 117.027 224.428 117.24 224.674 117.4C224.919 117.56 225.191 117.64 225.49 117.64ZM231.167 119.096C230.89 119.096 230.661 119 230.479 118.808C230.298 118.616 230.207 118.392 230.207 118.136C230.207 117.869 230.298 117.645 230.479 117.464C230.661 117.272 230.89 117.176 231.167 117.176C231.423 117.176 231.642 117.272 231.823 117.464C232.015 117.645 232.111 117.869 232.111 118.136C232.111 118.392 232.015 118.616 231.823 118.808C231.642 119 231.423 119.096 231.167 119.096Z\" fill=\"#FF0082\"/> <g class=\"answer\" filter=\"url(#filter1_d_1192_50796)\"> <path d=\"M99 159H162C167.523 159 172 163.477 172 169V188H109C103.477 188 99 183.523 99 178V159Z\" fill=\"white\"/> <path d=\"M99.5 159.5H162C167.247 159.5 171.5 163.753 171.5 169V187.5H109C103.753 187.5 99.5 183.247 99.5 178V159.5Z\" stroke=\"#F7CFE5\"/> <path d=\"M121.219 179C120.995 179 120.785 178.953 120.589 178.86C120.402 178.757 120.309 178.608 120.309 178.412V169.34C120.309 169.144 120.402 168.999 120.589 168.906C120.785 168.813 120.995 168.766 121.219 168.766C121.443 168.766 121.625 168.789 121.765 168.836C121.914 168.883 122.049 168.976 122.171 169.116C122.301 169.247 122.437 169.452 122.577 169.732L125.279 174.954V169.34C125.279 169.135 125.372 168.99 125.559 168.906C125.755 168.813 125.965 168.766 126.189 168.766C126.422 168.766 126.632 168.813 126.819 168.906C127.005 168.99 127.099 169.135 127.099 169.34V178.412C127.099 178.608 127.005 178.757 126.819 178.86C126.632 178.953 126.422 179 126.189 179C125.974 179 125.773 178.958 125.587 178.874C125.409 178.79 125.265 178.641 125.153 178.426L122.129 172.798V178.412C122.129 178.608 122.035 178.757 121.849 178.86C121.662 178.953 121.452 179 121.219 179ZM129.597 179C129.401 179 129.219 178.953 129.051 178.86C128.883 178.757 128.799 178.608 128.799 178.412V169.354C128.799 169.158 128.883 169.013 129.051 168.92C129.219 168.817 129.401 168.766 129.597 168.766H134.581C134.786 168.766 134.931 168.85 135.015 169.018C135.108 169.186 135.155 169.363 135.155 169.55C135.155 169.774 135.104 169.965 135.001 170.124C134.908 170.283 134.768 170.362 134.581 170.362H130.619V173.162H132.747C132.934 173.162 133.074 173.237 133.167 173.386C133.27 173.526 133.321 173.694 133.321 173.89C133.321 174.049 133.274 174.207 133.181 174.366C133.097 174.515 132.952 174.59 132.747 174.59H130.619V177.404H134.581C134.768 177.404 134.908 177.483 135.001 177.642C135.104 177.801 135.155 177.992 135.155 178.216C135.155 178.403 135.108 178.58 135.015 178.748C134.931 178.916 134.786 179 134.581 179H129.597ZM136.755 179.07C136.587 179.07 136.409 179.028 136.223 178.944C136.036 178.86 135.877 178.753 135.747 178.622C135.616 178.482 135.551 178.328 135.551 178.16C135.551 178.057 135.588 177.945 135.663 177.824L138.085 173.876L135.747 169.942C135.663 169.811 135.621 169.681 135.621 169.55C135.621 169.391 135.681 169.247 135.803 169.116C135.924 168.985 136.073 168.883 136.251 168.808C136.437 168.733 136.615 168.696 136.783 168.696C136.932 168.696 137.053 168.733 137.147 168.808C137.249 168.873 137.329 168.967 137.385 169.088L139.289 172.518L141.207 169.088C141.272 168.967 141.351 168.873 141.445 168.808C141.547 168.733 141.669 168.696 141.809 168.696C141.986 168.696 142.163 168.733 142.341 168.808C142.518 168.883 142.667 168.985 142.789 169.116C142.91 169.247 142.971 169.391 142.971 169.55C142.971 169.681 142.929 169.811 142.845 169.942L140.507 173.876L142.929 177.824C143.003 177.945 143.041 178.057 143.041 178.16C143.041 178.328 142.975 178.482 142.845 178.622C142.714 178.753 142.555 178.86 142.369 178.944C142.191 179.028 142.014 179.07 141.837 179.07C141.734 179.07 141.636 179.042 141.543 178.986C141.459 178.93 141.393 178.86 141.347 178.776L139.289 175.178L137.245 178.776C137.198 178.86 137.128 178.93 137.035 178.986C136.951 179.042 136.857 179.07 136.755 179.07ZM146.871 179C146.638 179 146.428 178.953 146.241 178.86C146.054 178.757 145.961 178.608 145.961 178.412V170.404H143.903C143.726 170.404 143.586 170.32 143.483 170.152C143.38 169.984 143.329 169.793 143.329 169.578C143.329 169.382 143.376 169.2 143.469 169.032C143.562 168.855 143.707 168.766 143.903 168.766H149.825C150.03 168.766 150.175 168.855 150.259 169.032C150.352 169.2 150.399 169.382 150.399 169.578C150.399 169.793 150.348 169.984 150.245 170.152C150.152 170.32 150.012 170.404 149.825 170.404H147.781V178.412C147.781 178.608 147.683 178.757 147.487 178.86C147.3 178.953 147.095 179 146.871 179Z\" fill=\"#FF0082\"/> </g> </g> <defs> <filter id=\"filter0_d_1192_50796\" x=\"0\" y=\"0\" width=\"275\" height=\"222\" filterUnits=\"userSpaceOnUse\" color-interpolation-filters=\"sRGB\"> <feFlood flood-opacity=\"0\" result=\"BackgroundImageFix\"/> <feColorMatrix in=\"SourceAlpha\" type=\"matrix\" values=\"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0\" result=\"hardAlpha\"/> <feOffset dx=\"5\" dy=\"5\"/> <feComposite in2=\"hardAlpha\" operator=\"out\"/> <feColorMatrix type=\"matrix\" values=\"0 0 0 0 0.956863 0 0 0 0 0.490196 0 0 0 0 0.380392 0 0 0 1 0\"/> <feBlend mode=\"normal\" in2=\"BackgroundImageFix\" result=\"effect1_dropShadow_1192_50796\"/> <feBlend mode=\"normal\" in=\"SourceGraphic\" in2=\"effect1_dropShadow_1192_50796\" result=\"shape\"/> </filter> <filter id=\"filter1_d_1192_50796\" x=\"99\" y=\"159\" width=\"75\" height=\"31\" filterUnits=\"userSpaceOnUse\" color-interpolation-filters=\"sRGB\"> <feFlood flood-opacity=\"0\" result=\"BackgroundImageFix\"/> <feColorMatrix in=\"SourceAlpha\" type=\"matrix\" values=\"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0\" result=\"hardAlpha\"/> <feOffset dx=\"2\" dy=\"2\"/> <feComposite in2=\"hardAlpha\" operator=\"out\"/> <feColorMatrix type=\"matrix\" values=\"0 0 0 0 1 0 0 0 0 0 0 0 0 0 0.509804 0 0 0 1 0\"/> <feBlend mode=\"normal\" in2=\"BackgroundImageFix\" result=\"effect1_dropShadow_1192_50796\"/> <feBlend mode=\"normal\" in=\"SourceGraphic\" in2=\"effect1_dropShadow_1192_50796\" result=\"shape\"/> </filter> </defs> </svg>") // EJsS HtmlView.HtmlView Page: setting property 'Html' for element 'cereal_right'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"cereal_wrong", _view.gameScreen) // EJsS HtmlView.HtmlView Page: declaration of element 'cereal_wrong'
      .setProperty("Html","<svg width=\"275\" height=\"222\" viewBox=\"0 0 275 222\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"> <g filter=\"url(#filter0_d_1192_51091)\"> <rect width=\"270\" height=\"217\" rx=\"50\" fill=\"#F9E6E0\"/> <rect x=\"0.5\" y=\"0.5\" width=\"269\" height=\"216\" rx=\"49.5\" stroke=\"#FFD208\"/> <path d=\"M50.7009 50.12C49.8209 50.12 49.0276 49.9733 48.3209 49.68C47.6143 49.3733 47.0476 48.8867 46.6209 48.22C46.2076 47.54 46.0009 46.64 46.0009 45.52V39.98C46.0009 38.86 46.2076 37.9667 46.6209 37.3C47.0476 36.62 47.6076 36.1333 48.3009 35.84C49.0076 35.5333 49.8076 35.38 50.7009 35.38C51.5809 35.38 52.3743 35.5333 53.0809 35.84C53.8009 36.1333 54.3676 36.62 54.7809 37.3C55.1943 37.9667 55.4009 38.86 55.4009 39.98V45.52C55.4009 46.64 55.1943 47.54 54.7809 48.22C54.3676 48.8867 53.8009 49.3733 53.0809 49.68C52.3743 49.9733 51.5809 50.12 50.7009 50.12ZM50.7009 47.84C51.3543 47.84 51.8676 47.6533 52.2409 47.28C52.6143 46.9067 52.8009 46.32 52.8009 45.52V39.98C52.8009 39.18 52.6143 38.5933 52.2409 38.22C51.8676 37.8467 51.3543 37.66 50.7009 37.66C50.0476 37.66 49.5343 37.8467 49.1609 38.22C48.8009 38.5933 48.6209 39.18 48.6209 39.98V45.52C48.6209 46.32 48.8009 46.9067 49.1609 47.28C49.5343 47.6533 50.0476 47.84 50.7009 47.84ZM61.4053 50.18C60.632 50.18 59.9186 49.9933 59.2653 49.62C58.612 49.2333 58.0853 48.7267 57.6853 48.1C57.2853 47.4733 57.0853 46.8 57.0853 46.08V44.44C57.0853 43.72 57.2786 43.0533 57.6653 42.44C58.052 41.8133 58.572 41.3133 59.2253 40.94C59.892 40.5667 60.6186 40.38 61.4053 40.38C62.192 40.38 62.912 40.5667 63.5653 40.94C64.232 41.3 64.7586 41.7867 65.1453 42.4C65.5453 43.0133 65.7453 43.6933 65.7453 44.44V46.08C65.7453 46.7867 65.5453 47.4533 65.1453 48.08C64.7453 48.7067 64.212 49.2133 63.5453 49.6C62.892 49.9867 62.1786 50.18 61.4053 50.18ZM61.4053 47.92C61.7253 47.92 62.0186 47.8333 62.2853 47.66C62.552 47.4867 62.7653 47.26 62.9253 46.98C63.0853 46.6867 63.1653 46.3867 63.1653 46.08V44.44C63.1653 44.1333 63.0853 43.8467 62.9253 43.58C62.7653 43.3133 62.552 43.0933 62.2853 42.92C62.032 42.7333 61.7386 42.64 61.4053 42.64C61.0853 42.64 60.792 42.7267 60.5253 42.9C60.2586 43.0733 60.0453 43.3 59.8853 43.58C59.7386 43.8467 59.6653 44.1333 59.6653 44.44V46.08C59.6653 46.3867 59.7386 46.6867 59.8853 46.98C60.0453 47.26 60.2586 47.4867 60.5253 47.66C60.792 47.8333 61.0853 47.92 61.4053 47.92ZM68.6667 54.42C68.3067 54.42 68.0067 54.3333 67.7667 54.16C67.5267 53.9867 67.4067 53.8 67.4067 53.6V41.3C67.4067 41.06 67.5267 40.8667 67.7667 40.72C68.0067 40.5733 68.3001 40.5 68.6467 40.5C68.9934 40.5 69.2734 40.5733 69.4867 40.72C69.7134 40.8667 69.8267 41.06 69.8267 41.3V41.9C70.0534 41.5133 70.4001 41.1667 70.8667 40.86C71.3334 40.54 71.8867 40.38 72.5267 40.38C73.2067 40.38 73.8134 40.5667 74.3467 40.94C74.8934 41.3 75.3201 41.7867 75.6267 42.4C75.9467 43.0133 76.1067 43.6933 76.1067 44.44V46.08C76.1067 46.7867 75.9467 47.4533 75.6267 48.08C75.3067 48.7067 74.8801 49.2133 74.3467 49.6C73.8267 49.9867 73.2467 50.18 72.6067 50.18C72.0201 50.18 71.4867 50.02 71.0067 49.7C70.5267 49.38 70.1867 49.0133 69.9867 48.6V53.6C69.9867 53.8 69.8601 53.9867 69.6067 54.16C69.3534 54.3333 69.0401 54.42 68.6667 54.42ZM71.7667 47.92C72.0867 47.92 72.3734 47.8333 72.6267 47.66C72.8934 47.4733 73.1067 47.24 73.2667 46.96C73.4401 46.68 73.5267 46.3867 73.5267 46.08V44.44C73.5267 44.1333 73.4467 43.8467 73.2867 43.58C73.1267 43.3133 72.9067 43.0933 72.6267 42.92C72.3601 42.7333 72.0601 42.64 71.7267 42.64C71.4334 42.64 71.1534 42.7133 70.8867 42.86C70.6334 43.0067 70.4201 43.2133 70.2467 43.48C70.0734 43.7467 69.9867 44.0667 69.9867 44.44V46.44C69.9867 46.5733 70.0601 46.76 70.2067 47C70.3667 47.2267 70.5801 47.44 70.8467 47.64C71.1134 47.8267 71.4201 47.92 71.7667 47.92ZM80.8578 50.18C80.1911 50.18 79.5778 50.1 79.0178 49.94C78.4711 49.7667 78.0378 49.5467 77.7178 49.28C77.4111 49.0133 77.2578 48.74 77.2578 48.46C77.2578 48.3133 77.2911 48.1533 77.3578 47.98C77.4378 47.8067 77.5378 47.6533 77.6578 47.52C77.7911 47.3867 77.9445 47.32 78.1178 47.32C78.3045 47.32 78.4978 47.4 78.6978 47.56C78.9111 47.7067 79.1711 47.8533 79.4778 48C79.7978 48.1467 80.2378 48.22 80.7978 48.22C81.3978 48.22 81.7911 48.1267 81.9778 47.94C82.1778 47.7533 82.2778 47.56 82.2778 47.36C82.2778 47.0667 82.1578 46.84 81.9178 46.68C81.6911 46.52 81.3978 46.3933 81.0378 46.3C80.6778 46.1933 80.2911 46.08 79.8778 45.96C79.4778 45.84 79.0978 45.6867 78.7378 45.5C78.3778 45.3 78.0845 45.0333 77.8578 44.7C77.6311 44.3533 77.5178 43.9067 77.5178 43.36C77.5178 42.88 77.6311 42.4133 77.8578 41.96C78.0845 41.5067 78.4578 41.1333 78.9778 40.84C79.4978 40.5333 80.2045 40.38 81.0978 40.38C81.6445 40.38 82.1578 40.44 82.6378 40.56C83.1311 40.6667 83.5311 40.82 83.8378 41.02C84.1445 41.22 84.2978 41.44 84.2978 41.68C84.2978 41.8 84.2578 41.96 84.1778 42.16C84.0978 42.3467 83.9845 42.52 83.8378 42.68C83.7045 42.84 83.5378 42.92 83.3378 42.92C83.1911 42.92 83.0111 42.8733 82.7978 42.78C82.5978 42.6733 82.3645 42.5733 82.0978 42.48C81.8311 42.3867 81.5111 42.34 81.1378 42.34C80.8045 42.34 80.5378 42.3867 80.3378 42.48C80.1378 42.5733 79.9911 42.6867 79.8978 42.82C79.8045 42.9533 79.7578 43.0933 79.7578 43.24C79.7578 43.48 79.8711 43.6667 80.0978 43.8C80.3245 43.9333 80.6178 44.0467 80.9778 44.14C81.3511 44.2333 81.7378 44.34 82.1378 44.46C82.5511 44.5667 82.9378 44.7267 83.2978 44.94C83.6711 45.1533 83.9711 45.4467 84.1978 45.82C84.4245 46.18 84.5378 46.6533 84.5378 47.24C84.5378 48.1333 84.2178 48.8467 83.5778 49.38C82.9511 49.9133 82.0445 50.18 80.8578 50.18ZM87.3177 45.96C87.051 45.96 86.8177 45.9 86.6177 45.78C86.4177 45.66 86.3177 45.4667 86.3177 45.2C86.3177 44.32 86.2977 43.3667 86.2577 42.34C86.2177 41.3133 86.171 40.2867 86.1177 39.26C86.0777 38.2333 86.0577 37.28 86.0577 36.4C86.0577 36.0533 86.1777 35.7867 86.4177 35.6C86.6577 35.4 86.9577 35.3 87.3177 35.3C87.651 35.3 87.9377 35.4 88.1777 35.6C88.431 35.7867 88.5577 36.0533 88.5577 36.4C88.5577 37.28 88.5377 38.2333 88.4977 39.26C88.4577 40.2867 88.411 41.3133 88.3577 42.34C88.3177 43.3667 88.2977 44.32 88.2977 45.2C88.2977 45.4667 88.1843 45.66 87.9577 45.78C87.731 45.9 87.5177 45.96 87.3177 45.96ZM87.3377 50.12C86.951 50.12 86.6243 49.9867 86.3577 49.72C86.1043 49.44 85.9777 49.12 85.9777 48.76C85.9777 48.3867 86.1043 48.0667 86.3577 47.8C86.6243 47.5333 86.951 47.4 87.3377 47.4C87.6977 47.4 88.011 47.5333 88.2777 47.8C88.5443 48.0667 88.6777 48.3867 88.6777 48.76C88.6777 49.12 88.5443 49.44 88.2777 49.72C88.011 49.9867 87.6977 50.12 87.3377 50.12ZM98.7556 50C98.4223 50 98.1223 49.9333 97.8556 49.8C97.589 49.6533 97.4556 49.44 97.4556 49.16V37.72H94.5156C94.2623 37.72 94.0623 37.6 93.9156 37.36C93.769 37.12 93.6956 36.8467 93.6956 36.54C93.6956 36.26 93.7623 36 93.8956 35.76C94.029 35.5067 94.2356 35.38 94.5156 35.38H102.976C103.269 35.38 103.476 35.5067 103.596 35.76C103.729 36 103.796 36.26 103.796 36.54C103.796 36.8467 103.722 37.12 103.576 37.36C103.442 37.6 103.242 37.72 102.976 37.72H100.056V49.16C100.056 49.44 99.9156 49.6533 99.6356 49.8C99.369 49.9333 99.0756 50 98.7556 50ZM106.284 50C105.911 50 105.604 49.9133 105.364 49.74C105.124 49.5667 105.004 49.3733 105.004 49.16V35.76C105.004 35.52 105.124 35.3267 105.364 35.18C105.604 35.0333 105.911 34.96 106.284 34.96C106.644 34.96 106.951 35.0333 107.204 35.18C107.458 35.3267 107.584 35.52 107.584 35.76V41.9C107.784 41.5133 108.098 41.1667 108.524 40.86C108.951 40.54 109.478 40.38 110.104 40.38C110.731 40.38 111.304 40.5667 111.824 40.94C112.344 41.3 112.758 41.7867 113.064 42.4C113.384 43.0133 113.544 43.6933 113.544 44.44V49.16C113.544 49.44 113.411 49.6533 113.144 49.8C112.878 49.9333 112.578 50 112.244 50C111.951 50 111.664 49.9333 111.384 49.8C111.104 49.6533 110.964 49.44 110.964 49.16V44.44C110.964 44.1333 110.884 43.8467 110.724 43.58C110.564 43.3133 110.351 43.0933 110.084 42.92C109.831 42.7333 109.544 42.64 109.224 42.64C108.958 42.64 108.698 42.7133 108.444 42.86C108.191 43.0067 107.984 43.2133 107.824 43.48C107.664 43.7467 107.584 44.0667 107.584 44.44V49.16C107.584 49.3733 107.458 49.5667 107.204 49.74C106.951 49.9133 106.644 50 106.284 50ZM117.513 50.18C116.806 50.18 116.193 49.9667 115.673 49.54C115.166 49.1 114.913 48.4267 114.913 47.52C114.913 46.76 115.106 46.1667 115.493 45.74C115.893 45.3133 116.439 45.0133 117.133 44.84C117.839 44.6667 118.653 44.58 119.573 44.58H120.393V44.32C120.393 44.0267 120.333 43.74 120.213 43.46C120.106 43.18 119.926 42.9467 119.673 42.76C119.433 42.5733 119.086 42.48 118.633 42.48C118.126 42.48 117.733 42.5333 117.453 42.64C117.186 42.7333 116.979 42.8333 116.833 42.94C116.686 43.0467 116.526 43.1 116.353 43.1C116.073 43.1 115.853 42.96 115.693 42.68C115.546 42.4 115.473 42.1133 115.473 41.82C115.473 41.54 115.639 41.2933 115.973 41.08C116.319 40.8533 116.739 40.68 117.233 40.56C117.726 40.44 118.206 40.38 118.673 40.38C119.713 40.38 120.546 40.5667 121.173 40.94C121.799 41.3133 122.253 41.7933 122.533 42.38C122.826 42.9667 122.973 43.6 122.973 44.28V49.16C122.973 49.4 122.853 49.6 122.613 49.76C122.373 49.92 122.073 50 121.713 50C121.379 50 121.099 49.92 120.873 49.76C120.659 49.6 120.553 49.4 120.553 49.16V48.6C120.193 49.0133 119.766 49.38 119.273 49.7C118.793 50.02 118.206 50.18 117.513 50.18ZM118.553 48.26C118.833 48.26 119.113 48.1667 119.393 47.98C119.673 47.7933 119.906 47.5533 120.093 47.26C120.293 46.9667 120.393 46.66 120.393 46.34V45.92H120.093C119.653 45.92 119.233 45.9467 118.833 46C118.433 46.0533 118.106 46.1733 117.853 46.36C117.613 46.5333 117.493 46.8067 117.493 47.18C117.493 47.5533 117.593 47.8267 117.793 48C118.006 48.1733 118.259 48.26 118.553 48.26ZM128.547 50C127.347 50 126.427 49.74 125.787 49.22C125.16 48.7 124.847 47.8733 124.847 46.74V37.06C124.847 36.82 124.987 36.6267 125.267 36.48C125.547 36.3333 125.833 36.26 126.127 36.26C126.447 36.26 126.74 36.3333 127.007 36.48C127.287 36.6267 127.427 36.82 127.427 37.06V40.5H129.787C130 40.5 130.16 40.6 130.267 40.8C130.387 40.9867 130.447 41.2 130.447 41.44C130.447 41.68 130.387 41.9 130.267 42.1C130.16 42.2867 130 42.38 129.787 42.38H127.427V46.74C127.427 47.14 127.507 47.42 127.667 47.58C127.84 47.74 128.133 47.82 128.547 47.82H129.327C129.7 47.82 129.973 47.9333 130.147 48.16C130.333 48.3867 130.427 48.6333 130.427 48.9C130.427 49.18 130.333 49.4333 130.147 49.66C129.973 49.8867 129.7 50 129.327 50H128.547ZM132.362 39.78C132.175 39.78 131.982 39.7267 131.782 39.62C131.595 39.5 131.502 39.3267 131.502 39.1C131.502 39.0067 131.528 38.9133 131.582 38.82L132.042 37.76C131.815 37.64 131.635 37.4733 131.502 37.26C131.368 37.0467 131.302 36.8067 131.302 36.54C131.302 36.1667 131.428 35.8467 131.682 35.58C131.948 35.3133 132.268 35.18 132.642 35.18C133.015 35.18 133.335 35.3133 133.602 35.58C133.868 35.8467 134.002 36.16 134.002 36.52C134.002 36.5867 133.988 36.6733 133.962 36.78C133.935 36.8867 133.882 37.04 133.802 37.24C133.735 37.4267 133.628 37.7 133.482 38.06C133.335 38.42 133.135 38.8867 132.882 39.46C132.842 39.5667 132.768 39.6467 132.662 39.7C132.555 39.7533 132.455 39.78 132.362 39.78ZM138.416 50.18C137.75 50.18 137.136 50.1 136.576 49.94C136.03 49.7667 135.596 49.5467 135.276 49.28C134.97 49.0133 134.816 48.74 134.816 48.46C134.816 48.3133 134.85 48.1533 134.916 47.98C134.996 47.8067 135.096 47.6533 135.216 47.52C135.35 47.3867 135.503 47.32 135.676 47.32C135.863 47.32 136.056 47.4 136.256 47.56C136.47 47.7067 136.73 47.8533 137.036 48C137.356 48.1467 137.796 48.22 138.356 48.22C138.956 48.22 139.35 48.1267 139.536 47.94C139.736 47.7533 139.836 47.56 139.836 47.36C139.836 47.0667 139.716 46.84 139.476 46.68C139.25 46.52 138.956 46.3933 138.596 46.3C138.236 46.1933 137.85 46.08 137.436 45.96C137.036 45.84 136.656 45.6867 136.296 45.5C135.936 45.3 135.643 45.0333 135.416 44.7C135.19 44.3533 135.076 43.9067 135.076 43.36C135.076 42.88 135.19 42.4133 135.416 41.96C135.643 41.5067 136.016 41.1333 136.536 40.84C137.056 40.5333 137.763 40.38 138.656 40.38C139.203 40.38 139.716 40.44 140.196 40.56C140.69 40.6667 141.09 40.82 141.396 41.02C141.703 41.22 141.856 41.44 141.856 41.68C141.856 41.8 141.816 41.96 141.736 42.16C141.656 42.3467 141.543 42.52 141.396 42.68C141.263 42.84 141.096 42.92 140.896 42.92C140.75 42.92 140.57 42.8733 140.356 42.78C140.156 42.6733 139.923 42.5733 139.656 42.48C139.39 42.3867 139.07 42.34 138.696 42.34C138.363 42.34 138.096 42.3867 137.896 42.48C137.696 42.5733 137.55 42.6867 137.456 42.82C137.363 42.9533 137.316 43.0933 137.316 43.24C137.316 43.48 137.43 43.6667 137.656 43.8C137.883 43.9333 138.176 44.0467 138.536 44.14C138.91 44.2333 139.296 44.34 139.696 44.46C140.11 44.5667 140.496 44.7267 140.856 44.94C141.23 45.1533 141.53 45.4467 141.756 45.82C141.983 46.18 142.096 46.6533 142.096 47.24C142.096 48.1333 141.776 48.8467 141.136 49.38C140.51 49.9133 139.603 50.18 138.416 50.18ZM149.16 50C148.84 50 148.54 49.9333 148.26 49.8C147.993 49.6533 147.86 49.44 147.86 49.16V36.2C147.86 35.9067 147.993 35.7 148.26 35.58C148.54 35.4467 148.84 35.38 149.16 35.38C149.493 35.38 149.793 35.4467 150.06 35.58C150.327 35.7 150.46 35.9067 150.46 36.2V49.16C150.46 49.44 150.327 49.6533 150.06 49.8C149.793 49.9333 149.493 50 149.16 50ZM153.94 50C153.567 50 153.26 49.9133 153.02 49.74C152.78 49.5667 152.66 49.3733 152.66 49.16V41.3C152.66 41.06 152.78 40.8667 153.02 40.72C153.26 40.5733 153.567 40.5 153.94 40.5C154.26 40.5 154.527 40.5733 154.74 40.72C154.967 40.8667 155.08 41.06 155.08 41.3V41.9C155.28 41.5133 155.607 41.1667 156.06 40.86C156.527 40.54 157.093 40.38 157.76 40.38C158.387 40.38 158.96 40.5667 159.48 40.94C160 41.3 160.413 41.7867 160.72 42.4C161.04 43.0133 161.2 43.6933 161.2 44.44V49.16C161.2 49.44 161.067 49.6533 160.8 49.8C160.533 49.9333 160.233 50 159.9 50C159.607 50 159.32 49.9333 159.04 49.8C158.76 49.6533 158.62 49.44 158.62 49.16V44.44C158.62 44.1333 158.54 43.8467 158.38 43.58C158.233 43.3133 158.027 43.0933 157.76 42.92C157.493 42.7333 157.2 42.64 156.88 42.64C156.613 42.64 156.353 42.7133 156.1 42.86C155.847 43.0067 155.64 43.2133 155.48 43.48C155.32 43.7467 155.24 44.0667 155.24 44.44V49.16C155.24 49.3733 155.113 49.5667 154.86 49.74C154.607 49.9133 154.3 50 153.94 50ZM167.149 50.18C166.136 50.18 165.309 50 164.669 49.64C164.029 49.28 163.556 48.7933 163.249 48.18C162.942 47.5533 162.789 46.8533 162.789 46.08V44.48C162.789 43.7067 162.936 43.0133 163.229 42.4C163.536 41.7733 164.009 41.28 164.649 40.92C165.302 40.56 166.122 40.38 167.109 40.38C167.736 40.38 168.289 40.4533 168.769 40.6C169.249 40.7467 169.629 40.94 169.909 41.18C170.189 41.42 170.329 41.6733 170.329 41.94C170.329 42.1 170.282 42.28 170.189 42.48C170.109 42.6667 169.989 42.8333 169.829 42.98C169.682 43.1267 169.509 43.2 169.309 43.2C169.162 43.2 169.009 43.1533 168.849 43.06C168.702 42.9667 168.509 42.8733 168.269 42.78C168.029 42.6867 167.709 42.64 167.309 42.64C166.629 42.64 166.136 42.8067 165.829 43.14C165.522 43.46 165.369 43.9067 165.369 44.48V46.08C165.369 46.6533 165.522 47.1067 165.829 47.44C166.136 47.76 166.636 47.92 167.329 47.92C167.742 47.92 168.062 47.8667 168.289 47.76C168.516 47.6533 168.702 47.5533 168.849 47.46C169.009 47.3667 169.169 47.32 169.329 47.32C169.569 47.32 169.769 47.3867 169.929 47.52C170.102 47.6533 170.229 47.82 170.309 48.02C170.402 48.2067 170.449 48.38 170.449 48.54C170.449 48.8067 170.302 49.0667 170.009 49.32C169.729 49.5733 169.336 49.78 168.829 49.94C168.336 50.1 167.776 50.18 167.149 50.18ZM175.644 50.18C174.87 50.18 174.157 49.9933 173.504 49.62C172.85 49.2333 172.324 48.7267 171.924 48.1C171.524 47.4733 171.324 46.8 171.324 46.08V44.44C171.324 43.72 171.517 43.0533 171.904 42.44C172.29 41.8133 172.81 41.3133 173.464 40.94C174.13 40.5667 174.857 40.38 175.644 40.38C176.43 40.38 177.15 40.5667 177.804 40.94C178.47 41.3 178.997 41.7867 179.384 42.4C179.784 43.0133 179.984 43.6933 179.984 44.44V46.08C179.984 46.7867 179.784 47.4533 179.384 48.08C178.984 48.7067 178.45 49.2133 177.784 49.6C177.13 49.9867 176.417 50.18 175.644 50.18ZM175.644 47.92C175.964 47.92 176.257 47.8333 176.524 47.66C176.79 47.4867 177.004 47.26 177.164 46.98C177.324 46.6867 177.404 46.3867 177.404 46.08V44.44C177.404 44.1333 177.324 43.8467 177.164 43.58C177.004 43.3133 176.79 43.0933 176.524 42.92C176.27 42.7333 175.977 42.64 175.644 42.64C175.324 42.64 175.03 42.7267 174.764 42.9C174.497 43.0733 174.284 43.3 174.124 43.58C173.977 43.8467 173.904 44.1333 173.904 44.44V46.08C173.904 46.3867 173.977 46.6867 174.124 46.98C174.284 47.26 174.497 47.4867 174.764 47.66C175.03 47.8333 175.324 47.92 175.644 47.92ZM182.885 50C182.525 50 182.225 49.9133 181.985 49.74C181.745 49.5667 181.625 49.3733 181.625 49.16V41.3C181.625 41.06 181.745 40.8667 181.985 40.72C182.225 40.5733 182.525 40.5 182.885 40.5C183.218 40.5 183.492 40.5733 183.705 40.72C183.932 40.8667 184.045 41.06 184.045 41.3V42.12C184.192 41.8267 184.385 41.5533 184.625 41.3C184.878 41.0333 185.165 40.8133 185.485 40.64C185.805 40.4667 186.145 40.38 186.505 40.38H187.125C187.378 40.38 187.598 40.4933 187.785 40.72C187.972 40.9333 188.065 41.1933 188.065 41.5C188.065 41.82 187.972 42.0933 187.785 42.32C187.598 42.5333 187.378 42.64 187.125 42.64H186.505C186.132 42.64 185.765 42.7667 185.405 43.02C185.058 43.26 184.772 43.6 184.545 44.04C184.318 44.4667 184.205 44.9867 184.205 45.6V49.16C184.205 49.3733 184.078 49.5667 183.825 49.74C183.572 49.9133 183.258 50 182.885 50ZM190.385 50C190.025 50 189.725 49.9133 189.485 49.74C189.245 49.5667 189.125 49.3733 189.125 49.16V41.3C189.125 41.06 189.245 40.8667 189.485 40.72C189.725 40.5733 190.025 40.5 190.385 40.5C190.718 40.5 190.992 40.5733 191.205 40.72C191.432 40.8667 191.545 41.06 191.545 41.3V42.12C191.692 41.8267 191.885 41.5533 192.125 41.3C192.378 41.0333 192.665 40.8133 192.985 40.64C193.305 40.4667 193.645 40.38 194.005 40.38H194.625C194.878 40.38 195.098 40.4933 195.285 40.72C195.472 40.9333 195.565 41.1933 195.565 41.5C195.565 41.82 195.472 42.0933 195.285 42.32C195.098 42.5333 194.878 42.64 194.625 42.64H194.005C193.632 42.64 193.265 42.7667 192.905 43.02C192.558 43.26 192.272 43.6 192.045 44.04C191.818 44.4667 191.705 44.9867 191.705 45.6V49.16C191.705 49.3733 191.578 49.5667 191.325 49.74C191.072 49.9133 190.758 50 190.385 50ZM200.871 50.18C199.924 50.18 199.084 50.0133 198.351 49.68C197.631 49.3333 197.064 48.8533 196.651 48.24C196.237 47.6133 196.031 46.8933 196.031 46.08V44.38C196.031 43.66 196.224 43 196.611 42.4C197.011 41.7867 197.537 41.3 198.191 40.94C198.857 40.5667 199.597 40.38 200.411 40.38C201.157 40.38 201.837 40.54 202.451 40.86C203.077 41.18 203.584 41.62 203.971 42.18C204.357 42.74 204.551 43.3933 204.551 44.14C204.551 44.7133 204.457 45.1267 204.271 45.38C204.084 45.62 203.844 45.7733 203.551 45.84C203.271 45.8933 202.977 45.92 202.671 45.92H198.611V46.22C198.611 46.7933 198.824 47.26 199.251 47.62C199.691 47.9667 200.257 48.14 200.951 48.14C201.391 48.14 201.757 48.0733 202.051 47.94C202.344 47.8067 202.597 47.68 202.811 47.56C203.024 47.44 203.224 47.38 203.411 47.38C203.611 47.38 203.784 47.4467 203.931 47.58C204.077 47.7133 204.191 47.8733 204.271 48.06C204.351 48.2333 204.391 48.3867 204.391 48.52C204.391 48.7467 204.244 48.9933 203.951 49.26C203.671 49.5133 203.264 49.7333 202.731 49.92C202.211 50.0933 201.591 50.18 200.871 50.18ZM198.611 44.4H201.531C201.757 44.4 201.911 44.3667 201.991 44.3C202.084 44.22 202.131 44.0733 202.131 43.86C202.131 43.5533 202.044 43.28 201.871 43.04C201.711 42.8 201.497 42.6133 201.231 42.48C200.977 42.3467 200.691 42.28 200.371 42.28C200.064 42.28 199.777 42.3467 199.511 42.48C199.244 42.6 199.024 42.78 198.851 43.02C198.691 43.2467 198.611 43.52 198.611 43.84V44.4ZM210.118 50.18C209.104 50.18 208.278 50 207.638 49.64C206.998 49.28 206.524 48.7933 206.218 48.18C205.911 47.5533 205.758 46.8533 205.758 46.08V44.48C205.758 43.7067 205.904 43.0133 206.198 42.4C206.504 41.7733 206.978 41.28 207.618 40.92C208.271 40.56 209.091 40.38 210.078 40.38C210.704 40.38 211.258 40.4533 211.738 40.6C212.218 40.7467 212.598 40.94 212.878 41.18C213.158 41.42 213.298 41.6733 213.298 41.94C213.298 42.1 213.251 42.28 213.158 42.48C213.078 42.6667 212.958 42.8333 212.798 42.98C212.651 43.1267 212.478 43.2 212.278 43.2C212.131 43.2 211.978 43.1533 211.818 43.06C211.671 42.9667 211.478 42.8733 211.238 42.78C210.998 42.6867 210.678 42.64 210.278 42.64C209.598 42.64 209.104 42.8067 208.798 43.14C208.491 43.46 208.338 43.9067 208.338 44.48V46.08C208.338 46.6533 208.491 47.1067 208.798 47.44C209.104 47.76 209.604 47.92 210.298 47.92C210.711 47.92 211.031 47.8667 211.258 47.76C211.484 47.6533 211.671 47.5533 211.818 47.46C211.978 47.3667 212.138 47.32 212.298 47.32C212.538 47.32 212.738 47.3867 212.898 47.52C213.071 47.6533 213.198 47.82 213.278 48.02C213.371 48.2067 213.418 48.38 213.418 48.54C213.418 48.8067 213.271 49.0667 212.978 49.32C212.698 49.5733 212.304 49.78 211.798 49.94C211.304 50.1 210.744 50.18 210.118 50.18ZM218.41 50C217.21 50 216.29 49.74 215.65 49.22C215.023 48.7 214.71 47.8733 214.71 46.74V37.06C214.71 36.82 214.85 36.6267 215.13 36.48C215.41 36.3333 215.697 36.26 215.99 36.26C216.31 36.26 216.603 36.3333 216.87 36.48C217.15 36.6267 217.29 36.82 217.29 37.06V40.5H219.65C219.863 40.5 220.023 40.6 220.13 40.8C220.25 40.9867 220.31 41.2 220.31 41.44C220.31 41.68 220.25 41.9 220.13 42.1C220.023 42.2867 219.863 42.38 219.65 42.38H217.29V46.74C217.29 47.14 217.37 47.42 217.53 47.58C217.703 47.74 217.997 47.82 218.41 47.82H219.19C219.563 47.82 219.837 47.9333 220.01 48.16C220.197 48.3867 220.29 48.6333 220.29 48.9C220.29 49.18 220.197 49.4333 220.01 49.66C219.837 49.8867 219.563 50 219.19 50H218.41ZM222.845 45.96C222.578 45.96 222.345 45.9 222.145 45.78C221.945 45.66 221.845 45.4667 221.845 45.2C221.845 44.32 221.825 43.3667 221.785 42.34C221.745 41.3133 221.698 40.2867 221.645 39.26C221.605 38.2333 221.585 37.28 221.585 36.4C221.585 36.0533 221.705 35.7867 221.945 35.6C222.185 35.4 222.485 35.3 222.845 35.3C223.178 35.3 223.465 35.4 223.705 35.6C223.958 35.7867 224.085 36.0533 224.085 36.4C224.085 37.28 224.065 38.2333 224.025 39.26C223.985 40.2867 223.938 41.3133 223.885 42.34C223.845 43.3667 223.825 44.32 223.825 45.2C223.825 45.4667 223.712 45.66 223.485 45.78C223.258 45.9 223.045 45.96 222.845 45.96ZM222.865 50.12C222.478 50.12 222.152 49.9867 221.885 49.72C221.632 49.44 221.505 49.12 221.505 48.76C221.505 48.3867 221.632 48.0667 221.885 47.8C222.152 47.5333 222.478 47.4 222.865 47.4C223.225 47.4 223.538 47.5333 223.805 47.8C224.072 48.0667 224.205 48.3867 224.205 48.76C224.205 49.12 224.072 49.44 223.805 49.72C223.538 49.9867 223.225 50.12 222.865 50.12Z\" fill=\"#FF0082\"/> <path d=\"M50.7847 99.096C50.1447 99.096 49.5527 98.9787 49.0087 98.744C48.4754 98.5093 48.0487 98.1307 47.7287 97.608C47.4087 97.0853 47.2487 96.392 47.2487 95.528V90.872C47.2487 90.008 47.4087 89.3147 47.7287 88.792C48.0487 88.2693 48.4807 87.8907 49.0247 87.656C49.5687 87.4213 50.1607 87.304 50.8007 87.304C51.5367 87.304 52.1714 87.432 52.7047 87.688C53.2487 87.9333 53.67 88.2747 53.9687 88.712C54.278 89.1387 54.4327 89.6347 54.4327 90.2C54.4327 90.5627 54.3634 90.8027 54.2247 90.92C54.086 91.0267 53.8727 91.08 53.5847 91.08C53.3287 91.08 53.126 91.0373 52.9767 90.952C52.8274 90.856 52.7474 90.712 52.7367 90.52C52.726 90.3813 52.6994 90.216 52.6567 90.024C52.614 89.832 52.5287 89.6453 52.4007 89.464C52.2834 89.272 52.102 89.1173 51.8567 89C51.6114 88.872 51.2754 88.808 50.8487 88.808C50.23 88.808 49.7554 88.9787 49.4247 89.32C49.094 89.6507 48.9287 90.168 48.9287 90.872V95.528C48.9287 96.232 49.094 96.7547 49.4247 97.096C49.766 97.4267 50.2567 97.592 50.8967 97.592C51.302 97.592 51.622 97.5333 51.8567 97.416C52.102 97.288 52.2834 97.1333 52.4007 96.952C52.518 96.76 52.598 96.5627 52.6407 96.36C52.6834 96.1467 52.7154 95.9547 52.7367 95.784C52.7474 95.5813 52.8274 95.4373 52.9767 95.352C53.1367 95.2667 53.334 95.224 53.5687 95.224C53.8674 95.224 54.086 95.2827 54.2247 95.4C54.3634 95.5173 54.4327 95.752 54.4327 96.104C54.4327 96.68 54.278 97.1973 53.9687 97.656C53.67 98.104 53.2487 98.456 52.7047 98.712C52.1607 98.968 51.5207 99.096 50.7847 99.096ZM59.2649 99.128C58.5396 99.128 57.8996 98.9947 57.3449 98.728C56.7903 98.4613 56.3529 98.0933 56.0329 97.624C55.7129 97.144 55.5529 96.584 55.5529 95.944V94.424C55.5529 93.8587 55.7023 93.3413 56.0009 92.872C56.3103 92.4027 56.7156 92.0293 57.2169 91.752C57.7183 91.464 58.2729 91.32 58.8809 91.32C59.4569 91.32 59.9849 91.448 60.4649 91.704C60.9449 91.9493 61.3289 92.296 61.6169 92.744C61.9156 93.192 62.0649 93.704 62.0649 94.28C62.0649 94.728 61.9956 95.048 61.8569 95.24C61.7183 95.432 61.5369 95.5493 61.3129 95.592C61.0889 95.6347 60.8543 95.656 60.6089 95.656H57.2329V96.024C57.2329 96.5573 57.4249 96.984 57.8089 97.304C58.2036 97.6133 58.7049 97.768 59.3129 97.768C59.6863 97.768 59.9903 97.7147 60.2249 97.608C60.4596 97.5013 60.6569 97.4 60.8169 97.304C60.9769 97.208 61.1263 97.16 61.2649 97.16C61.4036 97.16 61.5209 97.2027 61.6169 97.288C61.7129 97.3733 61.7876 97.4747 61.8409 97.592C61.8943 97.7093 61.9209 97.816 61.9209 97.912C61.9209 98.072 61.8089 98.248 61.5849 98.44C61.3716 98.632 61.0676 98.7973 60.6729 98.936C60.2783 99.064 59.8089 99.128 59.2649 99.128ZM57.2329 94.616H59.8889C60.1236 94.616 60.2783 94.584 60.3529 94.52C60.4383 94.456 60.4809 94.328 60.4809 94.136C60.4809 93.8587 60.4116 93.6027 60.2729 93.368C60.1343 93.1227 59.9423 92.936 59.6969 92.808C59.4516 92.6693 59.1743 92.6 58.8649 92.6C58.5663 92.6 58.2943 92.664 58.0489 92.792C57.8036 92.92 57.6063 93.096 57.4569 93.32C57.3076 93.544 57.2329 93.8053 57.2329 94.104V94.616ZM64.2507 99C64.016 99 63.8187 98.9413 63.6587 98.824C63.5094 98.7067 63.4347 98.5787 63.4347 98.44V91.96C63.4347 91.8 63.5094 91.672 63.6587 91.576C63.8187 91.4693 64.016 91.416 64.2507 91.416C64.464 91.416 64.6454 91.4693 64.7947 91.576C64.944 91.672 65.0187 91.8 65.0187 91.96V92.664C65.136 92.44 65.2907 92.2267 65.4827 92.024C65.6854 91.8213 65.92 91.656 66.1867 91.528C66.4534 91.3893 66.7414 91.32 67.0507 91.32H67.5627C67.7334 91.32 67.8827 91.3947 68.0107 91.544C68.1387 91.6827 68.2027 91.8533 68.2027 92.056C68.2027 92.2587 68.1387 92.4347 68.0107 92.584C67.8827 92.7333 67.7334 92.808 67.5627 92.808H67.0507C66.7307 92.808 66.4214 92.904 66.1227 93.096C65.824 93.288 65.5787 93.56 65.3867 93.912C65.2054 94.2533 65.1147 94.6693 65.1147 95.16V98.44C65.1147 98.5787 65.0294 98.7067 64.8587 98.824C64.6987 98.9413 64.496 99 64.2507 99ZM72.3431 99.128C71.6177 99.128 70.9777 98.9947 70.4231 98.728C69.8684 98.4613 69.4311 98.0933 69.1111 97.624C68.7911 97.144 68.6311 96.584 68.6311 95.944V94.424C68.6311 93.8587 68.7804 93.3413 69.0791 92.872C69.3884 92.4027 69.7937 92.0293 70.2951 91.752C70.7964 91.464 71.3511 91.32 71.9591 91.32C72.5351 91.32 73.0631 91.448 73.5431 91.704C74.0231 91.9493 74.4071 92.296 74.6951 92.744C74.9937 93.192 75.1431 93.704 75.1431 94.28C75.1431 94.728 75.0737 95.048 74.9351 95.24C74.7964 95.432 74.6151 95.5493 74.3911 95.592C74.1671 95.6347 73.9324 95.656 73.6871 95.656H70.3111V96.024C70.3111 96.5573 70.5031 96.984 70.8871 97.304C71.2817 97.6133 71.7831 97.768 72.3911 97.768C72.7644 97.768 73.0684 97.7147 73.3031 97.608C73.5377 97.5013 73.7351 97.4 73.8951 97.304C74.0551 97.208 74.2044 97.16 74.3431 97.16C74.4817 97.16 74.5991 97.2027 74.6951 97.288C74.7911 97.3733 74.8657 97.4747 74.9191 97.592C74.9724 97.7093 74.9991 97.816 74.9991 97.912C74.9991 98.072 74.8871 98.248 74.6631 98.44C74.4497 98.632 74.1457 98.7973 73.7511 98.936C73.3564 99.064 72.8871 99.128 72.3431 99.128ZM70.3111 94.616H72.9671C73.2017 94.616 73.3564 94.584 73.4311 94.52C73.5164 94.456 73.5591 94.328 73.5591 94.136C73.5591 93.8587 73.4897 93.6027 73.3511 93.368C73.2124 93.1227 73.0204 92.936 72.7751 92.808C72.5297 92.6693 72.2524 92.6 71.9431 92.6C71.6444 92.6 71.3724 92.664 71.1271 92.792C70.8817 92.92 70.6844 93.096 70.5351 93.32C70.3857 93.544 70.3111 93.8053 70.3111 94.104V94.616ZM78.1608 99.128C77.5741 99.128 77.0728 98.9573 76.6568 98.616C76.2408 98.264 76.0328 97.7307 76.0328 97.016C76.0328 96.408 76.1928 95.9387 76.5128 95.608C76.8328 95.2773 77.2701 95.048 77.8248 94.92C78.3901 94.792 79.0408 94.728 79.7768 94.728H80.4808V94.44C80.4808 94.1627 80.4275 93.896 80.3208 93.64C80.2248 93.3733 80.0595 93.1547 79.8248 92.984C79.6008 92.8027 79.2915 92.712 78.8968 92.712C78.5021 92.712 78.1981 92.7493 77.9848 92.824C77.7715 92.8987 77.6008 92.9787 77.4728 93.064C77.3448 93.1493 77.2275 93.192 77.1208 93.192C76.9288 93.192 76.7795 93.1013 76.6728 92.92C76.5661 92.728 76.5128 92.536 76.5128 92.344C76.5128 92.152 76.6355 91.9813 76.8808 91.832C77.1368 91.672 77.4515 91.5493 77.8248 91.464C78.1981 91.368 78.5661 91.32 78.9288 91.32C79.7181 91.32 80.3475 91.4693 80.8168 91.768C81.2861 92.056 81.6275 92.4347 81.8408 92.904C82.0541 93.3733 82.1608 93.88 82.1608 94.424V98.44C82.1608 98.5893 82.0808 98.7227 81.9208 98.84C81.7715 98.9467 81.5795 99 81.3448 99C81.1315 99 80.9501 98.9467 80.8008 98.84C80.6515 98.7227 80.5768 98.5893 80.5768 98.44V97.88C80.2995 98.2 79.9635 98.488 79.5688 98.744C79.1741 99 78.7048 99.128 78.1608 99.128ZM78.7688 97.848C79.0355 97.848 79.2968 97.768 79.5528 97.608C79.8195 97.448 80.0381 97.2453 80.2088 97C80.3901 96.7547 80.4808 96.504 80.4808 96.248V95.656H80.0808C79.6755 95.656 79.2915 95.6827 78.9288 95.736C78.5661 95.7787 78.2728 95.8853 78.0488 96.056C77.8355 96.216 77.7288 96.4667 77.7288 96.808C77.7288 97.1707 77.8248 97.4373 78.0168 97.608C78.2195 97.768 78.4701 97.848 78.7688 97.848ZM84.8326 99C84.5872 99 84.3846 98.9413 84.2246 98.824C84.0752 98.7067 84.0006 98.5787 84.0006 98.44V87.448C84.0006 87.288 84.0752 87.16 84.2246 87.064C84.3846 86.9573 84.5872 86.904 84.8326 86.904C85.0672 86.904 85.2646 86.9573 85.4246 87.064C85.5952 87.16 85.6806 87.288 85.6806 87.448V98.44C85.6806 98.5787 85.5952 98.7067 85.4246 98.824C85.2646 98.9413 85.0672 99 84.8326 99ZM94.5864 99.128C94.0851 99.128 93.6318 99.0053 93.2264 98.76C92.8318 98.504 92.5491 98.2107 92.3784 97.88V98.44C92.3784 98.5787 92.3038 98.7067 92.1544 98.824C92.0051 98.9413 91.8238 99 91.6104 99C91.3758 99 91.1784 98.9413 91.0184 98.824C90.8691 98.7067 90.7944 98.5787 90.7944 98.44V87.448C90.7944 87.288 90.8691 87.16 91.0184 87.064C91.1784 86.9573 91.3758 86.904 91.6104 86.904C91.8558 86.904 92.0584 86.9573 92.2184 87.064C92.3891 87.16 92.4744 87.288 92.4744 87.448V92.536C92.6451 92.2267 92.9064 91.9493 93.2584 91.704C93.6104 91.448 94.0371 91.32 94.5384 91.32C95.0611 91.32 95.5358 91.464 95.9624 91.752C96.3998 92.0293 96.7464 92.408 97.0024 92.888C97.2691 93.3573 97.4024 93.8853 97.4024 94.472V95.944C97.4024 96.4987 97.2691 97.0213 97.0024 97.512C96.7464 97.992 96.4051 98.3813 95.9784 98.68C95.5518 98.9787 95.0878 99.128 94.5864 99.128ZM94.1064 97.64C94.3944 97.64 94.6611 97.56 94.9064 97.4C95.1518 97.24 95.3491 97.0267 95.4984 96.76C95.6478 96.4933 95.7224 96.2213 95.7224 95.944V94.472C95.7224 94.1947 95.6478 93.928 95.4984 93.672C95.3491 93.416 95.1518 93.208 94.9064 93.048C94.6611 92.888 94.3891 92.808 94.0904 92.808C93.8238 92.808 93.5678 92.8773 93.3224 93.016C93.0771 93.144 92.8744 93.3307 92.7144 93.576C92.5544 93.8213 92.4744 94.12 92.4744 94.472V96.312C92.4744 96.44 92.5438 96.6107 92.6824 96.824C92.8318 97.0267 93.0291 97.2133 93.2744 97.384C93.5198 97.5547 93.7971 97.64 94.1064 97.64ZM101.864 99.128C101.288 99.128 100.75 98.9787 100.248 98.68C99.7469 98.3813 99.3415 97.992 99.0322 97.512C98.7335 97.0213 98.5842 96.4987 98.5842 95.944V94.472C98.5842 93.9067 98.7282 93.384 99.0162 92.904C99.3149 92.424 99.7149 92.04 100.216 91.752C100.728 91.464 101.283 91.32 101.88 91.32C102.478 91.32 103.027 91.464 103.528 91.752C104.03 92.0293 104.43 92.408 104.728 92.888C105.038 93.3573 105.192 93.8853 105.192 94.472V95.944C105.192 96.488 105.038 97.0053 104.728 97.496C104.43 97.9867 104.024 98.3813 103.512 98.68C103.011 98.9787 102.462 99.128 101.864 99.128ZM101.88 97.64C102.179 97.64 102.451 97.56 102.696 97.4C102.942 97.24 103.139 97.032 103.288 96.776C103.438 96.5093 103.512 96.232 103.512 95.944V94.472C103.512 94.1947 103.438 93.928 103.288 93.672C103.139 93.416 102.942 93.208 102.696 93.048C102.451 92.888 102.179 92.808 101.88 92.808C101.571 92.808 101.294 92.888 101.048 93.048C100.814 93.208 100.622 93.416 100.472 93.672C100.334 93.928 100.264 94.1947 100.264 94.472V95.944C100.264 96.232 100.334 96.5093 100.472 96.776C100.622 97.032 100.819 97.24 101.064 97.4C101.31 97.56 101.582 97.64 101.88 97.64ZM107.041 99.128C106.913 99.128 106.763 99.0853 106.593 99C106.433 98.9253 106.289 98.824 106.161 98.696C106.043 98.568 105.985 98.4347 105.985 98.296C105.985 98.1893 106.017 98.088 106.081 97.992L108.065 95.144L106.193 92.456C106.161 92.424 106.134 92.3813 106.113 92.328C106.091 92.2747 106.081 92.2213 106.081 92.168C106.081 92.0293 106.139 91.896 106.257 91.768C106.385 91.64 106.534 91.5333 106.705 91.448C106.875 91.3627 107.03 91.32 107.169 91.32C107.222 91.32 107.291 91.3307 107.377 91.352C107.462 91.3733 107.531 91.4267 107.585 91.512L109.201 94.072L110.833 91.528C110.886 91.4427 110.95 91.3893 111.025 91.368C111.11 91.336 111.19 91.32 111.265 91.32C111.393 91.32 111.542 91.3627 111.713 91.448C111.883 91.5227 112.027 91.6293 112.145 91.768C112.273 91.896 112.337 92.0293 112.337 92.168C112.337 92.2533 112.299 92.3493 112.225 92.456L110.337 95.16L112.321 97.992C112.353 98.024 112.379 98.0667 112.401 98.12C112.422 98.1733 112.433 98.232 112.433 98.296C112.433 98.4133 112.374 98.5413 112.257 98.68C112.139 98.808 111.995 98.9147 111.825 99C111.665 99.0853 111.51 99.128 111.361 99.128C111.286 99.128 111.206 99.112 111.121 99.08C111.046 99.0587 110.987 99.0107 110.945 98.936L109.201 96.296L107.473 98.936C107.43 99 107.361 99.048 107.265 99.08C107.179 99.112 107.105 99.128 107.041 99.128ZM116.937 99.128C116.211 99.128 115.571 98.9947 115.017 98.728C114.462 98.4613 114.025 98.0933 113.705 97.624C113.385 97.144 113.225 96.584 113.225 95.944V94.424C113.225 93.8587 113.374 93.3413 113.673 92.872C113.982 92.4027 114.387 92.0293 114.889 91.752C115.39 91.464 115.945 91.32 116.553 91.32C117.129 91.32 117.657 91.448 118.137 91.704C118.617 91.9493 119.001 92.296 119.289 92.744C119.587 93.192 119.737 93.704 119.737 94.28C119.737 94.728 119.667 95.048 119.529 95.24C119.39 95.432 119.209 95.5493 118.985 95.592C118.761 95.6347 118.526 95.656 118.281 95.656H114.905V96.024C114.905 96.5573 115.097 96.984 115.481 97.304C115.875 97.6133 116.377 97.768 116.985 97.768C117.358 97.768 117.662 97.7147 117.897 97.608C118.131 97.5013 118.329 97.4 118.489 97.304C118.649 97.208 118.798 97.16 118.937 97.16C119.075 97.16 119.193 97.2027 119.289 97.288C119.385 97.3733 119.459 97.4747 119.513 97.592C119.566 97.7093 119.593 97.816 119.593 97.912C119.593 98.072 119.481 98.248 119.257 98.44C119.043 98.632 118.739 98.7973 118.345 98.936C117.95 99.064 117.481 99.128 116.937 99.128ZM114.905 94.616H117.561C117.795 94.616 117.95 94.584 118.025 94.52C118.11 94.456 118.153 94.328 118.153 94.136C118.153 93.8587 118.083 93.6027 117.945 93.368C117.806 93.1227 117.614 92.936 117.369 92.808C117.123 92.6693 116.846 92.6 116.537 92.6C116.238 92.6 115.966 92.664 115.721 92.792C115.475 92.92 115.278 93.096 115.129 93.32C114.979 93.544 114.905 93.8053 114.905 94.104V94.616ZM123.427 99.128C122.904 99.128 122.435 99.064 122.019 98.936C121.603 98.808 121.272 98.648 121.027 98.456C120.792 98.2533 120.675 98.0507 120.675 97.848C120.675 97.752 120.696 97.6453 120.739 97.528C120.792 97.4107 120.861 97.3093 120.947 97.224C121.043 97.1387 121.144 97.096 121.251 97.096C121.389 97.096 121.533 97.16 121.683 97.288C121.843 97.4053 122.051 97.528 122.307 97.656C122.563 97.7733 122.92 97.832 123.379 97.832C123.912 97.832 124.269 97.7413 124.451 97.56C124.643 97.3787 124.739 97.1813 124.739 96.968C124.739 96.6907 124.643 96.4773 124.451 96.328C124.269 96.168 124.029 96.04 123.731 95.944C123.443 95.848 123.133 95.7573 122.803 95.672C122.472 95.576 122.157 95.4533 121.859 95.304C121.571 95.1547 121.331 94.9467 121.139 94.68C120.957 94.4133 120.867 94.0613 120.867 93.624C120.867 93.2613 120.957 92.904 121.139 92.552C121.32 92.1893 121.608 91.896 122.003 91.672C122.408 91.4373 122.947 91.32 123.619 91.32C124.024 91.32 124.408 91.3627 124.771 91.448C125.133 91.5333 125.432 91.6507 125.667 91.8C125.901 91.9387 126.019 92.0933 126.019 92.264C126.019 92.3387 125.992 92.4453 125.939 92.584C125.885 92.712 125.811 92.8293 125.715 92.936C125.629 93.032 125.517 93.08 125.379 93.08C125.272 93.08 125.139 93.0427 124.979 92.968C124.819 92.8827 124.632 92.8027 124.419 92.728C124.205 92.6533 123.944 92.616 123.635 92.616C123.325 92.616 123.075 92.6693 122.883 92.776C122.701 92.872 122.568 92.9893 122.483 93.128C122.397 93.2667 122.355 93.4053 122.355 93.544C122.355 93.7787 122.445 93.96 122.627 94.088C122.808 94.216 123.048 94.3227 123.347 94.408C123.645 94.4933 123.96 94.584 124.291 94.68C124.621 94.7653 124.931 94.8933 125.219 95.064C125.517 95.2347 125.757 95.464 125.939 95.752C126.131 96.04 126.227 96.424 126.227 96.904C126.227 97.576 125.981 98.1147 125.491 98.52C125.011 98.9253 124.323 99.128 123.427 99.128ZM132.458 99.128C131.871 99.128 131.37 98.9573 130.954 98.616C130.538 98.264 130.33 97.7307 130.33 97.016C130.33 96.408 130.49 95.9387 130.81 95.608C131.13 95.2773 131.567 95.048 132.122 94.92C132.687 94.792 133.338 94.728 134.074 94.728H134.778V94.44C134.778 94.1627 134.724 93.896 134.618 93.64C134.522 93.3733 134.356 93.1547 134.122 92.984C133.898 92.8027 133.588 92.712 133.194 92.712C132.799 92.712 132.495 92.7493 132.282 92.824C132.068 92.8987 131.898 92.9787 131.77 93.064C131.642 93.1493 131.524 93.192 131.418 93.192C131.226 93.192 131.076 93.1013 130.97 92.92C130.863 92.728 130.81 92.536 130.81 92.344C130.81 92.152 130.932 91.9813 131.178 91.832C131.434 91.672 131.748 91.5493 132.122 91.464C132.495 91.368 132.863 91.32 133.226 91.32C134.015 91.32 134.644 91.4693 135.114 91.768C135.583 92.056 135.924 92.4347 136.138 92.904C136.351 93.3733 136.458 93.88 136.458 94.424V98.44C136.458 98.5893 136.378 98.7227 136.218 98.84C136.068 98.9467 135.876 99 135.642 99C135.428 99 135.247 98.9467 135.098 98.84C134.948 98.7227 134.874 98.5893 134.874 98.44V97.88C134.596 98.2 134.26 98.488 133.866 98.744C133.471 99 133.002 99.128 132.458 99.128ZM133.066 97.848C133.332 97.848 133.594 97.768 133.85 97.608C134.116 97.448 134.335 97.2453 134.506 97C134.687 96.7547 134.778 96.504 134.778 96.248V95.656H134.378C133.972 95.656 133.588 95.6827 133.226 95.736C132.863 95.7787 132.57 95.8853 132.346 96.056C132.132 96.216 132.026 96.4667 132.026 96.808C132.026 97.1707 132.122 97.4373 132.314 97.608C132.516 97.768 132.767 97.848 133.066 97.848ZM138.969 99C138.735 99 138.537 98.9413 138.377 98.824C138.228 98.7067 138.153 98.5787 138.153 98.44V91.96C138.153 91.8 138.228 91.672 138.377 91.576C138.537 91.4693 138.735 91.416 138.969 91.416C139.183 91.416 139.364 91.4693 139.513 91.576C139.663 91.672 139.737 91.8 139.737 91.96V92.664C139.855 92.44 140.009 92.2267 140.201 92.024C140.404 91.8213 140.639 91.656 140.905 91.528C141.172 91.3893 141.46 91.32 141.769 91.32H142.281C142.452 91.32 142.601 91.3947 142.729 91.544C142.857 91.6827 142.921 91.8533 142.921 92.056C142.921 92.2587 142.857 92.4347 142.729 92.584C142.601 92.7333 142.452 92.808 142.281 92.808H141.769C141.449 92.808 141.14 92.904 140.841 93.096C140.543 93.288 140.297 93.56 140.105 93.912C139.924 94.2533 139.833 94.6693 139.833 95.16V98.44C139.833 98.5787 139.748 98.7067 139.577 98.824C139.417 98.9413 139.215 99 138.969 99ZM147.062 99.128C146.336 99.128 145.696 98.9947 145.142 98.728C144.587 98.4613 144.15 98.0933 143.83 97.624C143.51 97.144 143.35 96.584 143.35 95.944V94.424C143.35 93.8587 143.499 93.3413 143.798 92.872C144.107 92.4027 144.512 92.0293 145.014 91.752C145.515 91.464 146.07 91.32 146.678 91.32C147.254 91.32 147.782 91.448 148.262 91.704C148.742 91.9493 149.126 92.296 149.414 92.744C149.712 93.192 149.862 93.704 149.862 94.28C149.862 94.728 149.792 95.048 149.654 95.24C149.515 95.432 149.334 95.5493 149.11 95.592C148.886 95.6347 148.651 95.656 148.406 95.656H145.03V96.024C145.03 96.5573 145.222 96.984 145.606 97.304C146 97.6133 146.502 97.768 147.11 97.768C147.483 97.768 147.787 97.7147 148.022 97.608C148.256 97.5013 148.454 97.4 148.614 97.304C148.774 97.208 148.923 97.16 149.062 97.16C149.2 97.16 149.318 97.2027 149.414 97.288C149.51 97.3733 149.584 97.4747 149.638 97.592C149.691 97.7093 149.718 97.816 149.718 97.912C149.718 98.072 149.606 98.248 149.382 98.44C149.168 98.632 148.864 98.7973 148.47 98.936C148.075 99.064 147.606 99.128 147.062 99.128ZM145.03 94.616H147.686C147.92 94.616 148.075 94.584 148.15 94.52C148.235 94.456 148.278 94.328 148.278 94.136C148.278 93.8587 148.208 93.6027 148.07 93.368C147.931 93.1227 147.739 92.936 147.494 92.808C147.248 92.6693 146.971 92.6 146.662 92.6C146.363 92.6 146.091 92.664 145.846 92.792C145.6 92.92 145.403 93.096 145.254 93.32C145.104 93.544 145.03 93.8053 145.03 94.104V94.616ZM155.267 99C155.021 99 154.819 98.9413 154.659 98.824C154.509 98.7067 154.435 98.5787 154.435 98.44V91.96C154.435 91.8 154.509 91.672 154.659 91.576C154.819 91.4693 155.021 91.416 155.267 91.416C155.469 91.416 155.645 91.4693 155.795 91.576C155.944 91.672 156.019 91.8 156.019 91.96V92.536C156.2 92.2267 156.467 91.9493 156.819 91.704C157.171 91.448 157.613 91.32 158.147 91.32C158.627 91.32 159.048 91.4693 159.411 91.768C159.784 92.0667 160.061 92.4507 160.243 92.92C160.52 92.376 160.877 91.976 161.315 91.72C161.752 91.4533 162.2 91.32 162.659 91.32C163.139 91.32 163.587 91.4427 164.003 91.688C164.429 91.9333 164.776 92.2907 165.043 92.76C165.309 93.2293 165.443 93.8 165.443 94.472V98.44C165.443 98.5787 165.357 98.7067 165.187 98.824C165.027 98.9413 164.829 99 164.595 99C164.371 99 164.173 98.9413 164.003 98.824C163.843 98.7067 163.763 98.5787 163.763 98.44V94.472C163.763 94.1093 163.688 93.8053 163.539 93.56C163.4 93.304 163.213 93.112 162.979 92.984C162.755 92.856 162.52 92.792 162.275 92.792C162.019 92.792 161.779 92.8613 161.555 93C161.331 93.128 161.144 93.3147 160.995 93.56C160.845 93.7947 160.771 94.088 160.771 94.44V98.456C160.771 98.648 160.68 98.7867 160.499 98.872C160.328 98.9573 160.136 99 159.923 99C159.731 99 159.544 98.9573 159.363 98.872C159.181 98.7867 159.091 98.648 159.091 98.456V94.456C159.091 94.1147 159.021 93.8213 158.883 93.576C158.744 93.3307 158.563 93.144 158.339 93.016C158.115 92.8773 157.869 92.808 157.603 92.808C157.357 92.808 157.117 92.872 156.883 93C156.659 93.128 156.472 93.3147 156.323 93.56C156.184 93.8053 156.115 94.1093 156.115 94.472V98.44C156.115 98.5787 156.029 98.7067 155.859 98.824C155.699 98.9413 155.501 99 155.267 99ZM168.786 99.128C168.199 99.128 167.698 98.9573 167.282 98.616C166.866 98.264 166.658 97.7307 166.658 97.016C166.658 96.408 166.818 95.9387 167.138 95.608C167.458 95.2773 167.895 95.048 168.45 94.92C169.015 94.792 169.666 94.728 170.402 94.728H171.106V94.44C171.106 94.1627 171.052 93.896 170.946 93.64C170.85 93.3733 170.684 93.1547 170.45 92.984C170.226 92.8027 169.916 92.712 169.522 92.712C169.127 92.712 168.823 92.7493 168.61 92.824C168.396 92.8987 168.226 92.9787 168.098 93.064C167.97 93.1493 167.852 93.192 167.746 93.192C167.554 93.192 167.404 93.1013 167.298 92.92C167.191 92.728 167.138 92.536 167.138 92.344C167.138 92.152 167.26 91.9813 167.506 91.832C167.762 91.672 168.076 91.5493 168.45 91.464C168.823 91.368 169.191 91.32 169.554 91.32C170.343 91.32 170.972 91.4693 171.442 91.768C171.911 92.056 172.252 92.4347 172.466 92.904C172.679 93.3733 172.786 93.88 172.786 94.424V98.44C172.786 98.5893 172.706 98.7227 172.546 98.84C172.396 98.9467 172.204 99 171.97 99C171.756 99 171.575 98.9467 171.426 98.84C171.276 98.7227 171.202 98.5893 171.202 98.44V97.88C170.924 98.2 170.588 98.488 170.194 98.744C169.799 99 169.33 99.128 168.786 99.128ZM169.394 97.848C169.66 97.848 169.922 97.768 170.178 97.608C170.444 97.448 170.663 97.2453 170.834 97C171.015 96.7547 171.106 96.504 171.106 96.248V95.656H170.706C170.3 95.656 169.916 95.6827 169.554 95.736C169.191 95.7787 168.898 95.8853 168.674 96.056C168.46 96.216 168.354 96.4667 168.354 96.808C168.354 97.1707 168.45 97.4373 168.642 97.608C168.844 97.768 169.095 97.848 169.394 97.848ZM177.01 99.128C176.508 99.128 176.044 98.9787 175.618 98.68C175.191 98.3813 174.844 97.992 174.578 97.512C174.322 97.0213 174.194 96.4987 174.194 95.944V94.472C174.194 93.8853 174.322 93.3573 174.578 92.888C174.844 92.408 175.191 92.0293 175.618 91.752C176.044 91.464 176.519 91.32 177.042 91.32C177.554 91.32 177.986 91.448 178.338 91.704C178.69 91.9493 178.951 92.2267 179.122 92.536V87.448C179.122 87.288 179.207 87.16 179.378 87.064C179.548 86.9573 179.751 86.904 179.986 86.904C180.22 86.904 180.412 86.9573 180.562 87.064C180.722 87.16 180.802 87.288 180.802 87.448V98.44C180.802 98.5787 180.722 98.7067 180.562 98.824C180.412 98.9413 180.22 99 179.986 99C179.783 99 179.602 98.9413 179.442 98.824C179.292 98.7067 179.218 98.5787 179.218 98.44V97.88C179.058 98.2107 178.775 98.504 178.37 98.76C177.964 99.0053 177.511 99.128 177.01 99.128ZM177.49 97.64C177.799 97.64 178.076 97.5547 178.322 97.384C178.567 97.2133 178.759 97.0267 178.898 96.824C179.047 96.6107 179.122 96.44 179.122 96.312V94.472C179.122 94.12 179.042 93.8213 178.882 93.576C178.722 93.3307 178.519 93.144 178.274 93.016C178.028 92.8773 177.772 92.808 177.506 92.808C177.207 92.808 176.93 92.888 176.674 93.048C176.428 93.208 176.231 93.416 176.082 93.672C175.943 93.928 175.874 94.1947 175.874 94.472V95.944C175.874 96.2213 175.943 96.4933 176.082 96.76C176.231 97.0267 176.428 97.24 176.674 97.4C176.919 97.56 177.191 97.64 177.49 97.64ZM185.999 99.128C185.274 99.128 184.634 98.9947 184.079 98.728C183.525 98.4613 183.087 98.0933 182.767 97.624C182.447 97.144 182.287 96.584 182.287 95.944V94.424C182.287 93.8587 182.437 93.3413 182.735 92.872C183.045 92.4027 183.45 92.0293 183.951 91.752C184.453 91.464 185.007 91.32 185.615 91.32C186.191 91.32 186.719 91.448 187.199 91.704C187.679 91.9493 188.063 92.296 188.351 92.744C188.65 93.192 188.799 93.704 188.799 94.28C188.799 94.728 188.73 95.048 188.591 95.24C188.453 95.432 188.271 95.5493 188.047 95.592C187.823 95.6347 187.589 95.656 187.343 95.656H183.967V96.024C183.967 96.5573 184.159 96.984 184.543 97.304C184.938 97.6133 185.439 97.768 186.047 97.768C186.421 97.768 186.725 97.7147 186.959 97.608C187.194 97.5013 187.391 97.4 187.551 97.304C187.711 97.208 187.861 97.16 187.999 97.16C188.138 97.16 188.255 97.2027 188.351 97.288C188.447 97.3733 188.522 97.4747 188.575 97.592C188.629 97.7093 188.655 97.816 188.655 97.912C188.655 98.072 188.543 98.248 188.319 98.44C188.106 98.632 187.802 98.7973 187.407 98.936C187.013 99.064 186.543 99.128 185.999 99.128ZM183.967 94.616H186.623C186.858 94.616 187.013 94.584 187.087 94.52C187.173 94.456 187.215 94.328 187.215 94.136C187.215 93.8587 187.146 93.6027 187.007 93.368C186.869 93.1227 186.677 92.936 186.431 92.808C186.186 92.6693 185.909 92.6 185.599 92.6C185.301 92.6 185.029 92.664 184.783 92.792C184.538 92.92 184.341 93.096 184.191 93.32C184.042 93.544 183.967 93.8053 183.967 94.104V94.616ZM194.204 99C193.97 99 193.772 98.952 193.612 98.856C193.463 98.7493 193.388 98.616 193.388 98.456V89.96C193.388 89.384 193.516 88.8667 193.772 88.408C194.028 87.9387 194.37 87.5707 194.796 87.304C195.223 87.0373 195.692 86.904 196.204 86.904H196.956C197.17 86.904 197.33 86.9787 197.436 87.128C197.554 87.2773 197.612 87.4427 197.612 87.624C197.612 87.816 197.554 87.9867 197.436 88.136C197.33 88.2747 197.17 88.344 196.956 88.344H196.524C196.247 88.344 195.996 88.408 195.772 88.536C195.559 88.664 195.388 88.84 195.26 89.064C195.132 89.2773 195.068 89.5227 195.068 89.8V91.416H197.132C197.292 91.416 197.41 91.48 197.484 91.608C197.57 91.736 197.612 91.88 197.612 92.04C197.612 92.2 197.57 92.344 197.484 92.472C197.41 92.6 197.292 92.664 197.132 92.664H195.068V98.456C195.068 98.616 194.983 98.7493 194.812 98.856C194.642 98.952 194.439 99 194.204 99ZM199.423 99C199.188 99 198.991 98.9413 198.831 98.824C198.681 98.7067 198.607 98.5787 198.607 98.44V91.96C198.607 91.8 198.681 91.672 198.831 91.576C198.991 91.4693 199.188 91.416 199.423 91.416C199.636 91.416 199.817 91.4693 199.967 91.576C200.116 91.672 200.191 91.8 200.191 91.96V92.664C200.308 92.44 200.463 92.2267 200.655 92.024C200.857 91.8213 201.092 91.656 201.359 91.528C201.625 91.3893 201.913 91.32 202.223 91.32H202.735C202.905 91.32 203.055 91.3947 203.183 91.544C203.311 91.6827 203.375 91.8533 203.375 92.056C203.375 92.2587 203.311 92.4347 203.183 92.584C203.055 92.7333 202.905 92.808 202.735 92.808H202.223C201.903 92.808 201.593 92.904 201.295 93.096C200.996 93.288 200.751 93.56 200.559 93.912C200.377 94.2533 200.287 94.6693 200.287 95.16V98.44C200.287 98.5787 200.201 98.7067 200.031 98.824C199.871 98.9413 199.668 99 199.423 99ZM207.083 99.128C206.507 99.128 205.968 98.9787 205.467 98.68C204.966 98.3813 204.56 97.992 204.251 97.512C203.952 97.0213 203.803 96.4987 203.803 95.944V94.472C203.803 93.9067 203.947 93.384 204.235 92.904C204.534 92.424 204.934 92.04 205.435 91.752C205.947 91.464 206.502 91.32 207.099 91.32C207.696 91.32 208.246 91.464 208.747 91.752C209.248 92.0293 209.648 92.408 209.947 92.888C210.256 93.3573 210.411 93.8853 210.411 94.472V95.944C210.411 96.488 210.256 97.0053 209.947 97.496C209.648 97.9867 209.243 98.3813 208.731 98.68C208.23 98.9787 207.68 99.128 207.083 99.128ZM207.099 97.64C207.398 97.64 207.67 97.56 207.915 97.4C208.16 97.24 208.358 97.032 208.507 96.776C208.656 96.5093 208.731 96.232 208.731 95.944V94.472C208.731 94.1947 208.656 93.928 208.507 93.672C208.358 93.416 208.16 93.208 207.915 93.048C207.67 92.888 207.398 92.808 207.099 92.808C206.79 92.808 206.512 92.888 206.267 93.048C206.032 93.208 205.84 93.416 205.691 93.672C205.552 93.928 205.483 94.1947 205.483 94.472V95.944C205.483 96.232 205.552 96.5093 205.691 96.776C205.84 97.032 206.038 97.24 206.283 97.4C206.528 97.56 206.8 97.64 207.099 97.64ZM212.704 99C212.459 99 212.256 98.9413 212.096 98.824C211.947 98.7067 211.872 98.5787 211.872 98.44V91.96C211.872 91.8 211.947 91.672 212.096 91.576C212.256 91.4693 212.459 91.416 212.704 91.416C212.907 91.416 213.083 91.4693 213.232 91.576C213.382 91.672 213.456 91.8 213.456 91.96V92.536C213.638 92.2267 213.904 91.9493 214.256 91.704C214.608 91.448 215.051 91.32 215.584 91.32C216.064 91.32 216.486 91.4693 216.848 91.768C217.222 92.0667 217.499 92.4507 217.68 92.92C217.958 92.376 218.315 91.976 218.752 91.72C219.19 91.4533 219.638 91.32 220.096 91.32C220.576 91.32 221.024 91.4427 221.44 91.688C221.867 91.9333 222.214 92.2907 222.48 92.76C222.747 93.2293 222.88 93.8 222.88 94.472V98.44C222.88 98.5787 222.795 98.7067 222.624 98.824C222.464 98.9413 222.267 99 222.032 99C221.808 99 221.611 98.9413 221.44 98.824C221.28 98.7067 221.2 98.5787 221.2 98.44V94.472C221.2 94.1093 221.126 93.8053 220.976 93.56C220.838 93.304 220.651 93.112 220.416 92.984C220.192 92.856 219.958 92.792 219.712 92.792C219.456 92.792 219.216 92.8613 218.992 93C218.768 93.128 218.582 93.3147 218.432 93.56C218.283 93.7947 218.208 94.088 218.208 94.44V98.456C218.208 98.648 218.118 98.7867 217.936 98.872C217.766 98.9573 217.574 99 217.36 99C217.168 99 216.982 98.9573 216.8 98.872C216.619 98.7867 216.528 98.648 216.528 98.456V94.456C216.528 94.1147 216.459 93.8213 216.32 93.576C216.182 93.3307 216 93.144 215.776 93.016C215.552 92.8773 215.307 92.808 215.04 92.808C214.795 92.808 214.555 92.872 214.32 93C214.096 93.128 213.91 93.3147 213.76 93.56C213.622 93.8053 213.552 94.1093 213.552 94.472V98.44C213.552 98.5787 213.467 98.7067 213.296 98.824C213.136 98.9413 212.939 99 212.704 99ZM41.3348 119.128C40.5668 119.128 39.9321 118.989 39.4308 118.712C38.9401 118.435 38.5775 118.056 38.3428 117.576C38.1081 117.096 37.9908 116.552 37.9908 115.944V114.504C37.9908 113.907 38.1081 113.368 38.3428 112.888C38.5775 112.397 38.9401 112.013 39.4308 111.736C39.9215 111.459 40.5455 111.32 41.3028 111.32C41.7935 111.32 42.2201 111.379 42.5828 111.496C42.9561 111.613 43.2441 111.763 43.4468 111.944C43.6601 112.115 43.7668 112.296 43.7668 112.488C43.7668 112.584 43.7348 112.701 43.6708 112.84C43.6175 112.968 43.5375 113.08 43.4308 113.176C43.3348 113.261 43.2175 113.304 43.0788 113.304C42.9721 113.304 42.8548 113.261 42.7268 113.176C42.6095 113.091 42.4495 113.011 42.2468 112.936C42.0441 112.851 41.7721 112.808 41.4308 112.808C40.8335 112.808 40.3908 112.957 40.1028 113.256C39.8148 113.555 39.6708 113.971 39.6708 114.504V115.944C39.6708 116.477 39.8148 116.893 40.1028 117.192C40.3908 117.491 40.8388 117.64 41.4468 117.64C41.7988 117.64 42.0761 117.597 42.2788 117.512C42.4815 117.416 42.6415 117.325 42.7588 117.24C42.8868 117.155 43.0095 117.112 43.1268 117.112C43.2761 117.112 43.4041 117.155 43.5108 117.24C43.6281 117.325 43.7135 117.432 43.7668 117.56C43.8308 117.688 43.8628 117.805 43.8628 117.912C43.8628 118.093 43.7508 118.28 43.5268 118.472C43.3135 118.664 43.0148 118.824 42.6308 118.952C42.2575 119.069 41.8255 119.128 41.3348 119.128ZM46.7077 119.128C46.121 119.128 45.6197 118.957 45.2037 118.616C44.7877 118.264 44.5797 117.731 44.5797 117.016C44.5797 116.408 44.7397 115.939 45.0597 115.608C45.3797 115.277 45.817 115.048 46.3717 114.92C46.937 114.792 47.5877 114.728 48.3237 114.728H49.0277V114.44C49.0277 114.163 48.9744 113.896 48.8677 113.64C48.7717 113.373 48.6064 113.155 48.3717 112.984C48.1477 112.803 47.8384 112.712 47.4437 112.712C47.049 112.712 46.745 112.749 46.5317 112.824C46.3184 112.899 46.1477 112.979 46.0197 113.064C45.8917 113.149 45.7744 113.192 45.6677 113.192C45.4757 113.192 45.3264 113.101 45.2197 112.92C45.113 112.728 45.0597 112.536 45.0597 112.344C45.0597 112.152 45.1824 111.981 45.4277 111.832C45.6837 111.672 45.9984 111.549 46.3717 111.464C46.745 111.368 47.113 111.32 47.4757 111.32C48.265 111.32 48.8944 111.469 49.3637 111.768C49.833 112.056 50.1744 112.435 50.3877 112.904C50.601 113.373 50.7077 113.88 50.7077 114.424V118.44C50.7077 118.589 50.6277 118.723 50.4677 118.84C50.3184 118.947 50.1264 119 49.8917 119C49.6784 119 49.497 118.947 49.3477 118.84C49.1984 118.723 49.1237 118.589 49.1237 118.44V117.88C48.8464 118.2 48.5104 118.488 48.1157 118.744C47.721 119 47.2517 119.128 46.7077 119.128ZM47.3157 117.848C47.5824 117.848 47.8437 117.768 48.0997 117.608C48.3664 117.448 48.585 117.245 48.7557 117C48.937 116.755 49.0277 116.504 49.0277 116.248V115.656H48.6277C48.2224 115.656 47.8384 115.683 47.4757 115.736C47.113 115.779 46.8197 115.885 46.5957 116.056C46.3824 116.216 46.2757 116.467 46.2757 116.808C46.2757 117.171 46.3717 117.437 46.5637 117.608C46.7664 117.768 47.017 117.848 47.3157 117.848ZM53.2194 119C52.9848 119 52.7874 118.941 52.6274 118.824C52.4781 118.707 52.4034 118.579 52.4034 118.44V111.96C52.4034 111.8 52.4781 111.672 52.6274 111.576C52.7874 111.469 52.9848 111.416 53.2194 111.416C53.4328 111.416 53.6141 111.469 53.7634 111.576C53.9128 111.672 53.9874 111.8 53.9874 111.96V112.664C54.1048 112.44 54.2594 112.227 54.4514 112.024C54.6541 111.821 54.8888 111.656 55.1554 111.528C55.4221 111.389 55.7101 111.32 56.0194 111.32H56.5314C56.7021 111.32 56.8514 111.395 56.9794 111.544C57.1074 111.683 57.1714 111.853 57.1714 112.056C57.1714 112.259 57.1074 112.435 56.9794 112.584C56.8514 112.733 56.7021 112.808 56.5314 112.808H56.0194C55.6994 112.808 55.3901 112.904 55.0914 113.096C54.7928 113.288 54.5474 113.56 54.3554 113.912C54.1741 114.253 54.0834 114.669 54.0834 115.16V118.44C54.0834 118.579 53.9981 118.707 53.8274 118.824C53.6674 118.941 53.4648 119 53.2194 119ZM60.4158 119.128C59.9145 119.128 59.4505 118.979 59.0238 118.68C58.5971 118.381 58.2505 117.992 57.9838 117.512C57.7278 117.021 57.5998 116.499 57.5998 115.944V114.472C57.5998 113.885 57.7278 113.357 57.9838 112.888C58.2505 112.408 58.5971 112.029 59.0238 111.752C59.4505 111.464 59.9251 111.32 60.4478 111.32C60.9598 111.32 61.3918 111.448 61.7438 111.704C62.0958 111.949 62.3571 112.227 62.5278 112.536V107.448C62.5278 107.288 62.6131 107.16 62.7838 107.064C62.9545 106.957 63.1571 106.904 63.3918 106.904C63.6265 106.904 63.8185 106.957 63.9678 107.064C64.1278 107.16 64.2078 107.288 64.2078 107.448V118.44C64.2078 118.579 64.1278 118.707 63.9678 118.824C63.8185 118.941 63.6265 119 63.3918 119C63.1891 119 63.0078 118.941 62.8478 118.824C62.6985 118.707 62.6238 118.579 62.6238 118.44V117.88C62.4638 118.211 62.1811 118.504 61.7758 118.76C61.3705 119.005 60.9171 119.128 60.4158 119.128ZM60.8958 117.64C61.2051 117.64 61.4825 117.555 61.7278 117.384C61.9731 117.213 62.1651 117.027 62.3038 116.824C62.4531 116.611 62.5278 116.44 62.5278 116.312V114.472C62.5278 114.12 62.4478 113.821 62.2878 113.576C62.1278 113.331 61.9251 113.144 61.6798 113.016C61.4345 112.877 61.1785 112.808 60.9118 112.808C60.6131 112.808 60.3358 112.888 60.0798 113.048C59.8345 113.208 59.6371 113.416 59.4878 113.672C59.3491 113.928 59.2798 114.195 59.2798 114.472V115.944C59.2798 116.221 59.3491 116.493 59.4878 116.76C59.6371 117.027 59.8345 117.24 60.0798 117.4C60.3251 117.56 60.5971 117.64 60.8958 117.64ZM69.7896 119.128C69.2882 119.128 68.8349 119.005 68.4296 118.76C68.0349 118.504 67.7522 118.211 67.5816 117.88V118.44C67.5816 118.579 67.5069 118.707 67.3576 118.824C67.2082 118.941 67.0269 119 66.8136 119C66.5789 119 66.3816 118.941 66.2216 118.824C66.0722 118.707 65.9976 118.579 65.9976 118.44V107.448C65.9976 107.288 66.0722 107.16 66.2216 107.064C66.3816 106.957 66.5789 106.904 66.8136 106.904C67.0589 106.904 67.2616 106.957 67.4216 107.064C67.5922 107.16 67.6776 107.288 67.6776 107.448V112.536C67.8482 112.227 68.1096 111.949 68.4616 111.704C68.8136 111.448 69.2402 111.32 69.7416 111.32C70.2642 111.32 70.7389 111.464 71.1656 111.752C71.6029 112.029 71.9496 112.408 72.2056 112.888C72.4722 113.357 72.6056 113.885 72.6056 114.472V115.944C72.6056 116.499 72.4722 117.021 72.2056 117.512C71.9496 117.992 71.6082 118.381 71.1816 118.68C70.7549 118.979 70.2909 119.128 69.7896 119.128ZM69.3096 117.64C69.5976 117.64 69.8642 117.56 70.1096 117.4C70.3549 117.24 70.5522 117.027 70.7016 116.76C70.8509 116.493 70.9256 116.221 70.9256 115.944V114.472C70.9256 114.195 70.8509 113.928 70.7016 113.672C70.5522 113.416 70.3549 113.208 70.1096 113.048C69.8642 112.888 69.5922 112.808 69.2936 112.808C69.0269 112.808 68.7709 112.877 68.5256 113.016C68.2802 113.144 68.0776 113.331 67.9176 113.576C67.7576 113.821 67.6776 114.12 67.6776 114.472V116.312C67.6776 116.44 67.7469 116.611 67.8856 116.824C68.0349 117.027 68.2322 117.213 68.4776 117.384C68.7229 117.555 69.0002 117.64 69.3096 117.64ZM77.0673 119.128C76.4913 119.128 75.9526 118.979 75.4513 118.68C74.95 118.381 74.5446 117.992 74.2353 117.512C73.9366 117.021 73.7873 116.499 73.7873 115.944V114.472C73.7873 113.907 73.9313 113.384 74.2193 112.904C74.518 112.424 74.918 112.04 75.4193 111.752C75.9313 111.464 76.486 111.32 77.0833 111.32C77.6806 111.32 78.23 111.464 78.7313 111.752C79.2326 112.029 79.6326 112.408 79.9313 112.888C80.2406 113.357 80.3953 113.885 80.3953 114.472V115.944C80.3953 116.488 80.2406 117.005 79.9313 117.496C79.6326 117.987 79.2273 118.381 78.7153 118.68C78.214 118.979 77.6646 119.128 77.0673 119.128ZM77.0833 117.64C77.382 117.64 77.654 117.56 77.8993 117.4C78.1446 117.24 78.342 117.032 78.4913 116.776C78.6406 116.509 78.7153 116.232 78.7153 115.944V114.472C78.7153 114.195 78.6406 113.928 78.4913 113.672C78.342 113.416 78.1446 113.208 77.8993 113.048C77.654 112.888 77.382 112.808 77.0833 112.808C76.774 112.808 76.4966 112.888 76.2513 113.048C76.0166 113.208 75.8246 113.416 75.6753 113.672C75.5366 113.928 75.4673 114.195 75.4673 114.472V115.944C75.4673 116.232 75.5366 116.509 75.6753 116.776C75.8246 117.032 76.022 117.24 76.2673 117.4C76.5126 117.56 76.7846 117.64 77.0833 117.64ZM83.5046 119.128C82.9179 119.128 82.4166 118.957 82.0006 118.616C81.5846 118.264 81.3766 117.731 81.3766 117.016C81.3766 116.408 81.5366 115.939 81.8566 115.608C82.1766 115.277 82.6139 115.048 83.1686 114.92C83.7339 114.792 84.3846 114.728 85.1206 114.728H85.8246V114.44C85.8246 114.163 85.7712 113.896 85.6646 113.64C85.5686 113.373 85.4032 113.155 85.1686 112.984C84.9446 112.803 84.6352 112.712 84.2406 112.712C83.8459 112.712 83.5419 112.749 83.3286 112.824C83.1152 112.899 82.9446 112.979 82.8166 113.064C82.6886 113.149 82.5712 113.192 82.4646 113.192C82.2726 113.192 82.1232 113.101 82.0166 112.92C81.9099 112.728 81.8566 112.536 81.8566 112.344C81.8566 112.152 81.9792 111.981 82.2246 111.832C82.4806 111.672 82.7952 111.549 83.1686 111.464C83.5419 111.368 83.9099 111.32 84.2726 111.32C85.0619 111.32 85.6912 111.469 86.1606 111.768C86.6299 112.056 86.9712 112.435 87.1846 112.904C87.3979 113.373 87.5046 113.88 87.5046 114.424V118.44C87.5046 118.589 87.4246 118.723 87.2646 118.84C87.1152 118.947 86.9232 119 86.6886 119C86.4752 119 86.2939 118.947 86.1446 118.84C85.9952 118.723 85.9206 118.589 85.9206 118.44V117.88C85.6432 118.2 85.3072 118.488 84.9126 118.744C84.5179 119 84.0486 119.128 83.5046 119.128ZM84.1126 117.848C84.3792 117.848 84.6406 117.768 84.8966 117.608C85.1632 117.448 85.3819 117.245 85.5526 117C85.7339 116.755 85.8246 116.504 85.8246 116.248V115.656H85.4246C85.0192 115.656 84.6352 115.683 84.2726 115.736C83.9099 115.779 83.6166 115.885 83.3926 116.056C83.1792 116.216 83.0726 116.467 83.0726 116.808C83.0726 117.171 83.1686 117.437 83.3606 117.608C83.5632 117.768 83.8139 117.848 84.1126 117.848ZM90.0163 119C89.7816 119 89.5843 118.941 89.4243 118.824C89.275 118.707 89.2003 118.579 89.2003 118.44V111.96C89.2003 111.8 89.275 111.672 89.4243 111.576C89.5843 111.469 89.7816 111.416 90.0163 111.416C90.2296 111.416 90.411 111.469 90.5603 111.576C90.7096 111.672 90.7843 111.8 90.7843 111.96V112.664C90.9016 112.44 91.0563 112.227 91.2483 112.024C91.451 111.821 91.6856 111.656 91.9523 111.528C92.219 111.389 92.507 111.32 92.8163 111.32H93.3283C93.499 111.32 93.6483 111.395 93.7763 111.544C93.9043 111.683 93.9683 111.853 93.9683 112.056C93.9683 112.259 93.9043 112.435 93.7763 112.584C93.6483 112.733 93.499 112.808 93.3283 112.808H92.8163C92.4963 112.808 92.187 112.904 91.8883 113.096C91.5896 113.288 91.3443 113.56 91.1523 113.912C90.971 114.253 90.8803 114.669 90.8803 115.16V118.44C90.8803 118.579 90.795 118.707 90.6243 118.824C90.4643 118.941 90.2616 119 90.0163 119ZM97.2127 119.128C96.7114 119.128 96.2474 118.979 95.8207 118.68C95.394 118.381 95.0474 117.992 94.7807 117.512C94.5247 117.021 94.3967 116.499 94.3967 115.944V114.472C94.3967 113.885 94.5247 113.357 94.7807 112.888C95.0474 112.408 95.394 112.029 95.8207 111.752C96.2474 111.464 96.722 111.32 97.2447 111.32C97.7567 111.32 98.1887 111.448 98.5407 111.704C98.8927 111.949 99.154 112.227 99.3247 112.536V107.448C99.3247 107.288 99.41 107.16 99.5807 107.064C99.7514 106.957 99.954 106.904 100.189 106.904C100.423 106.904 100.615 106.957 100.765 107.064C100.925 107.16 101.005 107.288 101.005 107.448V118.44C101.005 118.579 100.925 118.707 100.765 118.824C100.615 118.941 100.423 119 100.189 119C99.986 119 99.8047 118.941 99.6447 118.824C99.4954 118.707 99.4207 118.579 99.4207 118.44V117.88C99.2607 118.211 98.978 118.504 98.5727 118.76C98.1674 119.005 97.714 119.128 97.2127 119.128ZM97.6927 117.64C98.002 117.64 98.2794 117.555 98.5247 117.384C98.77 117.213 98.962 117.027 99.1007 116.824C99.25 116.611 99.3247 116.44 99.3247 116.312V114.472C99.3247 114.12 99.2447 113.821 99.0847 113.576C98.9247 113.331 98.722 113.144 98.4767 113.016C98.2314 112.877 97.9754 112.808 97.7087 112.808C97.41 112.808 97.1327 112.888 96.8767 113.048C96.6314 113.208 96.434 113.416 96.2847 113.672C96.146 113.928 96.0767 114.195 96.0767 114.472V115.944C96.0767 116.221 96.146 116.493 96.2847 116.76C96.434 117.027 96.6314 117.24 96.8767 117.4C97.122 117.56 97.394 117.64 97.6927 117.64ZM107.63 119.128C107.043 119.128 106.542 118.957 106.126 118.616C105.71 118.264 105.502 117.731 105.502 117.016C105.502 116.408 105.662 115.939 105.982 115.608C106.302 115.277 106.739 115.048 107.294 114.92C107.859 114.792 108.51 114.728 109.246 114.728H109.95V114.44C109.95 114.163 109.896 113.896 109.79 113.64C109.694 113.373 109.528 113.155 109.294 112.984C109.07 112.803 108.76 112.712 108.366 112.712C107.971 112.712 107.667 112.749 107.454 112.824C107.24 112.899 107.07 112.979 106.942 113.064C106.814 113.149 106.696 113.192 106.59 113.192C106.398 113.192 106.248 113.101 106.142 112.92C106.035 112.728 105.982 112.536 105.982 112.344C105.982 112.152 106.104 111.981 106.35 111.832C106.606 111.672 106.92 111.549 107.294 111.464C107.667 111.368 108.035 111.32 108.398 111.32C109.187 111.32 109.816 111.469 110.286 111.768C110.755 112.056 111.096 112.435 111.31 112.904C111.523 113.373 111.63 113.88 111.63 114.424V118.44C111.63 118.589 111.55 118.723 111.39 118.84C111.24 118.947 111.048 119 110.814 119C110.6 119 110.419 118.947 110.27 118.84C110.12 118.723 110.046 118.589 110.046 118.44V117.88C109.768 118.2 109.432 118.488 109.038 118.744C108.643 119 108.174 119.128 107.63 119.128ZM108.238 117.848C108.504 117.848 108.766 117.768 109.022 117.608C109.288 117.448 109.507 117.245 109.678 117C109.859 116.755 109.95 116.504 109.95 116.248V115.656H109.55C109.144 115.656 108.76 115.683 108.398 115.736C108.035 115.779 107.742 115.885 107.518 116.056C107.304 116.216 107.198 116.467 107.198 116.808C107.198 117.171 107.294 117.437 107.486 117.608C107.688 117.768 107.939 117.848 108.238 117.848ZM114.157 119C113.912 119 113.709 118.941 113.549 118.824C113.4 118.707 113.325 118.579 113.325 118.44V111.96C113.325 111.8 113.4 111.672 113.549 111.576C113.709 111.469 113.912 111.416 114.157 111.416C114.36 111.416 114.536 111.469 114.685 111.576C114.835 111.672 114.909 111.8 114.909 111.96V112.536C115.069 112.227 115.331 111.949 115.693 111.704C116.067 111.448 116.52 111.32 117.053 111.32C117.555 111.32 118.013 111.464 118.429 111.752C118.856 112.029 119.197 112.408 119.453 112.888C119.709 113.357 119.837 113.885 119.837 114.472V118.44C119.837 118.621 119.747 118.76 119.565 118.856C119.395 118.952 119.203 119 118.989 119C118.797 119 118.611 118.952 118.429 118.856C118.248 118.76 118.157 118.621 118.157 118.44V114.472C118.157 114.195 118.083 113.928 117.933 113.672C117.795 113.416 117.603 113.208 117.357 113.048C117.112 112.888 116.84 112.808 116.541 112.808C116.285 112.808 116.04 112.877 115.805 113.016C115.571 113.144 115.379 113.331 115.229 113.576C115.08 113.821 115.005 114.12 115.005 114.472V118.44C115.005 118.579 114.92 118.707 114.749 118.824C114.589 118.941 114.392 119 114.157 119ZM124.041 119.128C123.539 119.128 123.075 118.979 122.649 118.68C122.222 118.381 121.875 117.992 121.609 117.512C121.353 117.021 121.225 116.499 121.225 115.944V114.472C121.225 113.885 121.353 113.357 121.609 112.888C121.875 112.408 122.222 112.029 122.649 111.752C123.075 111.464 123.55 111.32 124.073 111.32C124.585 111.32 125.017 111.448 125.369 111.704C125.721 111.949 125.982 112.227 126.153 112.536V107.448C126.153 107.288 126.238 107.16 126.409 107.064C126.579 106.957 126.782 106.904 127.017 106.904C127.251 106.904 127.443 106.957 127.593 107.064C127.753 107.16 127.833 107.288 127.833 107.448V118.44C127.833 118.579 127.753 118.707 127.593 118.824C127.443 118.941 127.251 119 127.017 119C126.814 119 126.633 118.941 126.473 118.824C126.323 118.707 126.249 118.579 126.249 118.44V117.88C126.089 118.211 125.806 118.504 125.401 118.76C124.995 119.005 124.542 119.128 124.041 119.128ZM124.521 117.64C124.83 117.64 125.107 117.555 125.353 117.384C125.598 117.213 125.79 117.027 125.929 116.824C126.078 116.611 126.153 116.44 126.153 116.312V114.472C126.153 114.12 126.073 113.821 125.913 113.576C125.753 113.331 125.55 113.144 125.305 113.016C125.059 112.877 124.803 112.808 124.537 112.808C124.238 112.808 123.961 112.888 123.705 113.048C123.459 113.208 123.262 113.416 123.113 113.672C122.974 113.928 122.905 114.195 122.905 114.472V115.944C122.905 116.221 122.974 116.493 123.113 116.76C123.262 117.027 123.459 117.24 123.705 117.4C123.95 117.56 124.222 117.64 124.521 117.64ZM135.882 119.128C135.114 119.128 134.479 118.989 133.978 118.712C133.487 118.435 133.124 118.056 132.89 117.576C132.655 117.096 132.538 116.552 132.538 115.944V114.504C132.538 113.907 132.655 113.368 132.89 112.888C133.124 112.397 133.487 112.013 133.978 111.736C134.468 111.459 135.092 111.32 135.85 111.32C136.34 111.32 136.767 111.379 137.13 111.496C137.503 111.613 137.791 111.763 137.994 111.944C138.207 112.115 138.314 112.296 138.314 112.488C138.314 112.584 138.282 112.701 138.218 112.84C138.164 112.968 138.084 113.08 137.978 113.176C137.882 113.261 137.764 113.304 137.626 113.304C137.519 113.304 137.402 113.261 137.274 113.176C137.156 113.091 136.996 113.011 136.794 112.936C136.591 112.851 136.319 112.808 135.978 112.808C135.38 112.808 134.938 112.957 134.65 113.256C134.362 113.555 134.218 113.971 134.218 114.504V115.944C134.218 116.477 134.362 116.893 134.65 117.192C134.938 117.491 135.386 117.64 135.994 117.64C136.346 117.64 136.623 117.597 136.826 117.512C137.028 117.416 137.188 117.325 137.306 117.24C137.434 117.155 137.556 117.112 137.674 117.112C137.823 117.112 137.951 117.155 138.058 117.24C138.175 117.325 138.26 117.432 138.314 117.56C138.378 117.688 138.41 117.805 138.41 117.912C138.41 118.093 138.298 118.28 138.074 118.472C137.86 118.664 137.562 118.824 137.178 118.952C136.804 119.069 136.372 119.128 135.882 119.128ZM141.255 119.128C140.668 119.128 140.167 118.957 139.751 118.616C139.335 118.264 139.127 117.731 139.127 117.016C139.127 116.408 139.287 115.939 139.607 115.608C139.927 115.277 140.364 115.048 140.919 114.92C141.484 114.792 142.135 114.728 142.871 114.728H143.575V114.44C143.575 114.163 143.521 113.896 143.415 113.64C143.319 113.373 143.153 113.155 142.919 112.984C142.695 112.803 142.385 112.712 141.991 112.712C141.596 112.712 141.292 112.749 141.079 112.824C140.865 112.899 140.695 112.979 140.567 113.064C140.439 113.149 140.321 113.192 140.215 113.192C140.023 113.192 139.873 113.101 139.767 112.92C139.66 112.728 139.607 112.536 139.607 112.344C139.607 112.152 139.729 111.981 139.975 111.832C140.231 111.672 140.545 111.549 140.919 111.464C141.292 111.368 141.66 111.32 142.023 111.32C142.812 111.32 143.441 111.469 143.911 111.768C144.38 112.056 144.721 112.435 144.935 112.904C145.148 113.373 145.255 113.88 145.255 114.424V118.44C145.255 118.589 145.175 118.723 145.015 118.84C144.865 118.947 144.673 119 144.439 119C144.225 119 144.044 118.947 143.895 118.84C143.745 118.723 143.671 118.589 143.671 118.44V117.88C143.393 118.2 143.057 118.488 142.663 118.744C142.268 119 141.799 119.128 141.255 119.128ZM141.863 117.848C142.129 117.848 142.391 117.768 142.647 117.608C142.913 117.448 143.132 117.245 143.303 117C143.484 116.755 143.575 116.504 143.575 116.248V115.656H143.175C142.769 115.656 142.385 115.683 142.023 115.736C141.66 115.779 141.367 115.885 141.143 116.056C140.929 116.216 140.823 116.467 140.823 116.808C140.823 117.171 140.919 117.437 141.111 117.608C141.313 117.768 141.564 117.848 141.863 117.848ZM147.782 119C147.537 119 147.334 118.941 147.174 118.824C147.025 118.707 146.95 118.579 146.95 118.44V111.96C146.95 111.8 147.025 111.672 147.174 111.576C147.334 111.469 147.537 111.416 147.782 111.416C147.985 111.416 148.161 111.469 148.31 111.576C148.46 111.672 148.534 111.8 148.534 111.96V112.536C148.694 112.227 148.956 111.949 149.318 111.704C149.692 111.448 150.145 111.32 150.678 111.32C151.18 111.32 151.638 111.464 152.054 111.752C152.481 112.029 152.822 112.408 153.078 112.888C153.334 113.357 153.462 113.885 153.462 114.472V118.44C153.462 118.621 153.372 118.76 153.19 118.856C153.02 118.952 152.828 119 152.614 119C152.422 119 152.236 118.952 152.054 118.856C151.873 118.76 151.782 118.621 151.782 118.44V114.472C151.782 114.195 151.708 113.928 151.558 113.672C151.42 113.416 151.228 113.208 150.982 113.048C150.737 112.888 150.465 112.808 150.166 112.808C149.91 112.808 149.665 112.877 149.43 113.016C149.196 113.144 149.004 113.331 148.854 113.576C148.705 113.821 148.63 114.12 148.63 114.472V118.44C148.63 118.579 148.545 118.707 148.374 118.824C148.214 118.941 148.017 119 147.782 119ZM162.149 119.128C161.648 119.128 161.194 119.005 160.789 118.76C160.394 118.504 160.112 118.211 159.941 117.88V118.44C159.941 118.579 159.866 118.707 159.717 118.824C159.568 118.941 159.386 119 159.173 119C158.938 119 158.741 118.941 158.581 118.824C158.432 118.707 158.357 118.579 158.357 118.44V107.448C158.357 107.288 158.432 107.16 158.581 107.064C158.741 106.957 158.938 106.904 159.173 106.904C159.418 106.904 159.621 106.957 159.781 107.064C159.952 107.16 160.037 107.288 160.037 107.448V112.536C160.208 112.227 160.469 111.949 160.821 111.704C161.173 111.448 161.6 111.32 162.101 111.32C162.624 111.32 163.098 111.464 163.525 111.752C163.962 112.029 164.309 112.408 164.565 112.888C164.832 113.357 164.965 113.885 164.965 114.472V115.944C164.965 116.499 164.832 117.021 164.565 117.512C164.309 117.992 163.968 118.381 163.541 118.68C163.114 118.979 162.65 119.128 162.149 119.128ZM161.669 117.64C161.957 117.64 162.224 117.56 162.469 117.4C162.714 117.24 162.912 117.027 163.061 116.76C163.21 116.493 163.285 116.221 163.285 115.944V114.472C163.285 114.195 163.21 113.928 163.061 113.672C162.912 113.416 162.714 113.208 162.469 113.048C162.224 112.888 161.952 112.808 161.653 112.808C161.386 112.808 161.13 112.877 160.885 113.016C160.64 113.144 160.437 113.331 160.277 113.576C160.117 113.821 160.037 114.12 160.037 114.472V116.312C160.037 116.44 160.106 116.611 160.245 116.824C160.394 117.027 160.592 117.213 160.837 117.384C161.082 117.555 161.36 117.64 161.669 117.64ZM169.859 119.128C169.133 119.128 168.493 118.995 167.939 118.728C167.384 118.461 166.947 118.093 166.627 117.624C166.307 117.144 166.147 116.584 166.147 115.944V114.424C166.147 113.859 166.296 113.341 166.595 112.872C166.904 112.403 167.309 112.029 167.811 111.752C168.312 111.464 168.867 111.32 169.475 111.32C170.051 111.32 170.579 111.448 171.059 111.704C171.539 111.949 171.923 112.296 172.211 112.744C172.509 113.192 172.659 113.704 172.659 114.28C172.659 114.728 172.589 115.048 172.451 115.24C172.312 115.432 172.131 115.549 171.907 115.592C171.683 115.635 171.448 115.656 171.203 115.656H167.827V116.024C167.827 116.557 168.019 116.984 168.403 117.304C168.797 117.613 169.299 117.768 169.907 117.768C170.28 117.768 170.584 117.715 170.819 117.608C171.053 117.501 171.251 117.4 171.411 117.304C171.571 117.208 171.72 117.16 171.859 117.16C171.997 117.16 172.115 117.203 172.211 117.288C172.307 117.373 172.381 117.475 172.435 117.592C172.488 117.709 172.515 117.816 172.515 117.912C172.515 118.072 172.403 118.248 172.179 118.44C171.965 118.632 171.661 118.797 171.267 118.936C170.872 119.064 170.403 119.128 169.859 119.128ZM167.827 114.616H170.483C170.717 114.616 170.872 114.584 170.947 114.52C171.032 114.456 171.075 114.328 171.075 114.136C171.075 113.859 171.005 113.603 170.867 113.368C170.728 113.123 170.536 112.936 170.291 112.808C170.045 112.669 169.768 112.6 169.459 112.6C169.16 112.6 168.888 112.664 168.643 112.792C168.397 112.92 168.2 113.096 168.051 113.32C167.901 113.544 167.827 113.805 167.827 114.104V114.616ZM178.048 119C177.813 119 177.616 118.941 177.456 118.824C177.306 118.707 177.232 118.579 177.232 118.44V111.96C177.232 111.8 177.306 111.672 177.456 111.576C177.616 111.469 177.813 111.416 178.048 111.416C178.261 111.416 178.442 111.469 178.592 111.576C178.741 111.672 178.816 111.8 178.816 111.96V112.664C178.933 112.44 179.088 112.227 179.28 112.024C179.482 111.821 179.717 111.656 179.984 111.528C180.25 111.389 180.538 111.32 180.848 111.32H181.36C181.53 111.32 181.68 111.395 181.808 111.544C181.936 111.683 182 111.853 182 112.056C182 112.259 181.936 112.435 181.808 112.584C181.68 112.733 181.53 112.808 181.36 112.808H180.848C180.528 112.808 180.218 112.904 179.92 113.096C179.621 113.288 179.376 113.56 179.184 113.912C179.002 114.253 178.912 114.669 178.912 115.16V118.44C178.912 118.579 178.826 118.707 178.656 118.824C178.496 118.941 178.293 119 178.048 119ZM186.14 119.128C185.415 119.128 184.775 118.995 184.22 118.728C183.665 118.461 183.228 118.093 182.908 117.624C182.588 117.144 182.428 116.584 182.428 115.944V114.424C182.428 113.859 182.577 113.341 182.876 112.872C183.185 112.403 183.591 112.029 184.092 111.752C184.593 111.464 185.148 111.32 185.756 111.32C186.332 111.32 186.86 111.448 187.34 111.704C187.82 111.949 188.204 112.296 188.492 112.744C188.791 113.192 188.94 113.704 188.94 114.28C188.94 114.728 188.871 115.048 188.732 115.24C188.593 115.432 188.412 115.549 188.188 115.592C187.964 115.635 187.729 115.656 187.484 115.656H184.108V116.024C184.108 116.557 184.3 116.984 184.684 117.304C185.079 117.613 185.58 117.768 186.188 117.768C186.561 117.768 186.865 117.715 187.1 117.608C187.335 117.501 187.532 117.4 187.692 117.304C187.852 117.208 188.001 117.16 188.14 117.16C188.279 117.16 188.396 117.203 188.492 117.288C188.588 117.373 188.663 117.475 188.716 117.592C188.769 117.709 188.796 117.816 188.796 117.912C188.796 118.072 188.684 118.248 188.46 118.44C188.247 118.632 187.943 118.797 187.548 118.936C187.153 119.064 186.684 119.128 186.14 119.128ZM184.108 114.616H186.764C186.999 114.616 187.153 114.584 187.228 114.52C187.313 114.456 187.356 114.328 187.356 114.136C187.356 113.859 187.287 113.603 187.148 113.368C187.009 113.123 186.817 112.936 186.572 112.808C186.327 112.669 186.049 112.6 185.74 112.6C185.441 112.6 185.169 112.664 184.924 112.792C184.679 112.92 184.481 113.096 184.332 113.32C184.183 113.544 184.108 113.805 184.108 114.104V114.616ZM193.382 119.128C192.614 119.128 191.979 118.989 191.478 118.712C190.987 118.435 190.624 118.056 190.39 117.576C190.155 117.096 190.038 116.552 190.038 115.944V114.504C190.038 113.907 190.155 113.368 190.39 112.888C190.624 112.397 190.987 112.013 191.478 111.736C191.968 111.459 192.592 111.32 193.35 111.32C193.84 111.32 194.267 111.379 194.63 111.496C195.003 111.613 195.291 111.763 195.494 111.944C195.707 112.115 195.814 112.296 195.814 112.488C195.814 112.584 195.782 112.701 195.718 112.84C195.664 112.968 195.584 113.08 195.478 113.176C195.382 113.261 195.264 113.304 195.126 113.304C195.019 113.304 194.902 113.261 194.774 113.176C194.656 113.091 194.496 113.011 194.294 112.936C194.091 112.851 193.819 112.808 193.478 112.808C192.88 112.808 192.438 112.957 192.15 113.256C191.862 113.555 191.718 113.971 191.718 114.504V115.944C191.718 116.477 191.862 116.893 192.15 117.192C192.438 117.491 192.886 117.64 193.494 117.64C193.846 117.64 194.123 117.597 194.326 117.512C194.528 117.416 194.688 117.325 194.806 117.24C194.934 117.155 195.056 117.112 195.174 117.112C195.323 117.112 195.451 117.155 195.558 117.24C195.675 117.325 195.76 117.432 195.814 117.56C195.878 117.688 195.91 117.805 195.91 117.912C195.91 118.093 195.798 118.28 195.574 118.472C195.36 118.664 195.062 118.824 194.678 118.952C194.304 119.069 193.872 119.128 193.382 119.128ZM197.139 122.6C196.925 122.6 196.744 122.552 196.595 122.456C196.445 122.371 196.371 122.179 196.371 121.88C196.371 121.688 196.403 121.517 196.467 121.368C196.531 121.229 196.648 121.16 196.819 121.16C197.021 121.16 197.24 121.107 197.475 121C197.72 120.904 197.955 120.744 198.179 120.52C198.413 120.307 198.611 120.035 198.771 119.704C198.941 119.373 199.059 118.984 199.123 118.536L196.419 112.328C196.376 112.253 196.355 112.179 196.355 112.104C196.355 111.965 196.413 111.837 196.531 111.72C196.659 111.592 196.808 111.491 196.979 111.416C197.149 111.341 197.309 111.304 197.459 111.304C197.565 111.304 197.667 111.331 197.763 111.384C197.869 111.427 197.939 111.501 197.971 111.608L199.987 116.808L201.731 111.608C201.763 111.501 201.827 111.427 201.923 111.384C202.019 111.331 202.115 111.304 202.211 111.304C202.339 111.304 202.488 111.341 202.659 111.416C202.84 111.491 202.995 111.592 203.123 111.72C203.261 111.837 203.331 111.976 203.331 112.136C203.331 112.221 203.315 112.285 203.283 112.328L200.883 118.584C200.712 119.043 200.536 119.507 200.355 119.976C200.173 120.456 199.949 120.893 199.683 121.288C199.427 121.683 199.091 121.997 198.675 122.232C198.269 122.477 197.757 122.6 197.139 122.6ZM207.444 119.128C206.676 119.128 206.042 118.989 205.54 118.712C205.05 118.435 204.687 118.056 204.452 117.576C204.218 117.096 204.1 116.552 204.1 115.944V114.504C204.1 113.907 204.218 113.368 204.452 112.888C204.687 112.397 205.05 112.013 205.54 111.736C206.031 111.459 206.655 111.32 207.412 111.32C207.903 111.32 208.33 111.379 208.692 111.496C209.066 111.613 209.354 111.763 209.556 111.944C209.77 112.115 209.876 112.296 209.876 112.488C209.876 112.584 209.844 112.701 209.78 112.84C209.727 112.968 209.647 113.08 209.54 113.176C209.444 113.261 209.327 113.304 209.188 113.304C209.082 113.304 208.964 113.261 208.836 113.176C208.719 113.091 208.559 113.011 208.356 112.936C208.154 112.851 207.882 112.808 207.54 112.808C206.943 112.808 206.5 112.957 206.212 113.256C205.924 113.555 205.78 113.971 205.78 114.504V115.944C205.78 116.477 205.924 116.893 206.212 117.192C206.5 117.491 206.948 117.64 207.556 117.64C207.908 117.64 208.186 117.597 208.388 117.512C208.591 117.416 208.751 117.325 208.868 117.24C208.996 117.155 209.119 117.112 209.236 117.112C209.386 117.112 209.514 117.155 209.62 117.24C209.738 117.325 209.823 117.432 209.876 117.56C209.94 117.688 209.972 117.805 209.972 117.912C209.972 118.093 209.86 118.28 209.636 118.472C209.423 118.664 209.124 118.824 208.74 118.952C208.367 119.069 207.935 119.128 207.444 119.128ZM212.145 119C211.9 119 211.697 118.941 211.537 118.824C211.388 118.707 211.313 118.579 211.313 118.44V107.448C211.313 107.288 211.388 107.16 211.537 107.064C211.697 106.957 211.9 106.904 212.145 106.904C212.38 106.904 212.577 106.957 212.737 107.064C212.908 107.16 212.993 107.288 212.993 107.448V118.44C212.993 118.579 212.908 118.707 212.737 118.824C212.577 118.941 212.38 119 212.145 119ZM218.312 119.128C217.586 119.128 216.946 118.995 216.392 118.728C215.837 118.461 215.4 118.093 215.08 117.624C214.76 117.144 214.6 116.584 214.6 115.944V114.424C214.6 113.859 214.749 113.341 215.048 112.872C215.357 112.403 215.762 112.029 216.264 111.752C216.765 111.464 217.32 111.32 217.928 111.32C218.504 111.32 219.032 111.448 219.512 111.704C219.992 111.949 220.376 112.296 220.664 112.744C220.962 113.192 221.112 113.704 221.112 114.28C221.112 114.728 221.042 115.048 220.904 115.24C220.765 115.432 220.584 115.549 220.36 115.592C220.136 115.635 219.901 115.656 219.656 115.656H216.28V116.024C216.28 116.557 216.472 116.984 216.856 117.304C217.25 117.613 217.752 117.768 218.36 117.768C218.733 117.768 219.037 117.715 219.272 117.608C219.506 117.501 219.704 117.4 219.864 117.304C220.024 117.208 220.173 117.16 220.312 117.16C220.45 117.16 220.568 117.203 220.664 117.288C220.76 117.373 220.834 117.475 220.888 117.592C220.941 117.709 220.968 117.816 220.968 117.912C220.968 118.072 220.856 118.248 220.632 118.44C220.418 118.632 220.114 118.797 219.72 118.936C219.325 119.064 218.856 119.128 218.312 119.128ZM216.28 114.616H218.936C219.17 114.616 219.325 114.584 219.4 114.52C219.485 114.456 219.528 114.328 219.528 114.136C219.528 113.859 219.458 113.603 219.32 113.368C219.181 113.123 218.989 112.936 218.744 112.808C218.498 112.669 218.221 112.6 217.912 112.6C217.613 112.6 217.341 112.664 217.096 112.792C216.85 112.92 216.653 113.096 216.504 113.32C216.354 113.544 216.28 113.805 216.28 114.104V114.616ZM225.01 119.128C224.508 119.128 224.044 118.979 223.618 118.68C223.191 118.381 222.844 117.992 222.578 117.512C222.322 117.021 222.194 116.499 222.194 115.944V114.472C222.194 113.885 222.322 113.357 222.578 112.888C222.844 112.408 223.191 112.029 223.618 111.752C224.044 111.464 224.519 111.32 225.042 111.32C225.554 111.32 225.986 111.448 226.338 111.704C226.69 111.949 226.951 112.227 227.122 112.536V107.448C227.122 107.288 227.207 107.16 227.378 107.064C227.548 106.957 227.751 106.904 227.986 106.904C228.22 106.904 228.412 106.957 228.562 107.064C228.722 107.16 228.802 107.288 228.802 107.448V118.44C228.802 118.579 228.722 118.707 228.562 118.824C228.412 118.941 228.22 119 227.986 119C227.783 119 227.602 118.941 227.442 118.824C227.292 118.707 227.218 118.579 227.218 118.44V117.88C227.058 118.211 226.775 118.504 226.37 118.76C225.964 119.005 225.511 119.128 225.01 119.128ZM225.49 117.64C225.799 117.64 226.076 117.555 226.322 117.384C226.567 117.213 226.759 117.027 226.898 116.824C227.047 116.611 227.122 116.44 227.122 116.312V114.472C227.122 114.12 227.042 113.821 226.882 113.576C226.722 113.331 226.519 113.144 226.274 113.016C226.028 112.877 225.772 112.808 225.506 112.808C225.207 112.808 224.93 112.888 224.674 113.048C224.428 113.208 224.231 113.416 224.082 113.672C223.943 113.928 223.874 114.195 223.874 114.472V115.944C223.874 116.221 223.943 116.493 224.082 116.76C224.231 117.027 224.428 117.24 224.674 117.4C224.919 117.56 225.191 117.64 225.49 117.64ZM231.167 119.096C230.89 119.096 230.661 119 230.479 118.808C230.298 118.616 230.207 118.392 230.207 118.136C230.207 117.869 230.298 117.645 230.479 117.464C230.661 117.272 230.89 117.176 231.167 117.176C231.423 117.176 231.642 117.272 231.823 117.464C232.015 117.645 232.111 117.869 232.111 118.136C232.111 118.392 232.015 118.616 231.823 118.808C231.642 119 231.423 119.096 231.167 119.096Z\" fill=\"#FF0082\"/> <g class=\"answer\" filter=\"url(#filter1_d_1192_51091)\"> <path d=\"M99 159H162C167.523 159 172 163.477 172 169V188H109C103.477 188 99 183.523 99 178V159Z\" fill=\"white\"/> <path d=\"M99.5 159.5H162C167.247 159.5 171.5 163.753 171.5 169V187.5H109C103.753 187.5 99.5 183.247 99.5 178V159.5Z\" stroke=\"#F7CFE5\"/> <path d=\"M121.219 179C120.995 179 120.785 178.953 120.589 178.86C120.402 178.757 120.309 178.608 120.309 178.412V169.34C120.309 169.144 120.402 168.999 120.589 168.906C120.785 168.813 120.995 168.766 121.219 168.766C121.443 168.766 121.625 168.789 121.765 168.836C121.914 168.883 122.049 168.976 122.171 169.116C122.301 169.247 122.437 169.452 122.577 169.732L125.279 174.954V169.34C125.279 169.135 125.372 168.99 125.559 168.906C125.755 168.813 125.965 168.766 126.189 168.766C126.422 168.766 126.632 168.813 126.819 168.906C127.005 168.99 127.099 169.135 127.099 169.34V178.412C127.099 178.608 127.005 178.757 126.819 178.86C126.632 178.953 126.422 179 126.189 179C125.974 179 125.773 178.958 125.587 178.874C125.409 178.79 125.265 178.641 125.153 178.426L122.129 172.798V178.412C122.129 178.608 122.035 178.757 121.849 178.86C121.662 178.953 121.452 179 121.219 179ZM129.597 179C129.401 179 129.219 178.953 129.051 178.86C128.883 178.757 128.799 178.608 128.799 178.412V169.354C128.799 169.158 128.883 169.013 129.051 168.92C129.219 168.817 129.401 168.766 129.597 168.766H134.581C134.786 168.766 134.931 168.85 135.015 169.018C135.108 169.186 135.155 169.363 135.155 169.55C135.155 169.774 135.104 169.965 135.001 170.124C134.908 170.283 134.768 170.362 134.581 170.362H130.619V173.162H132.747C132.934 173.162 133.074 173.237 133.167 173.386C133.27 173.526 133.321 173.694 133.321 173.89C133.321 174.049 133.274 174.207 133.181 174.366C133.097 174.515 132.952 174.59 132.747 174.59H130.619V177.404H134.581C134.768 177.404 134.908 177.483 135.001 177.642C135.104 177.801 135.155 177.992 135.155 178.216C135.155 178.403 135.108 178.58 135.015 178.748C134.931 178.916 134.786 179 134.581 179H129.597ZM136.755 179.07C136.587 179.07 136.409 179.028 136.223 178.944C136.036 178.86 135.877 178.753 135.747 178.622C135.616 178.482 135.551 178.328 135.551 178.16C135.551 178.057 135.588 177.945 135.663 177.824L138.085 173.876L135.747 169.942C135.663 169.811 135.621 169.681 135.621 169.55C135.621 169.391 135.681 169.247 135.803 169.116C135.924 168.985 136.073 168.883 136.251 168.808C136.437 168.733 136.615 168.696 136.783 168.696C136.932 168.696 137.053 168.733 137.147 168.808C137.249 168.873 137.329 168.967 137.385 169.088L139.289 172.518L141.207 169.088C141.272 168.967 141.351 168.873 141.445 168.808C141.547 168.733 141.669 168.696 141.809 168.696C141.986 168.696 142.163 168.733 142.341 168.808C142.518 168.883 142.667 168.985 142.789 169.116C142.91 169.247 142.971 169.391 142.971 169.55C142.971 169.681 142.929 169.811 142.845 169.942L140.507 173.876L142.929 177.824C143.003 177.945 143.041 178.057 143.041 178.16C143.041 178.328 142.975 178.482 142.845 178.622C142.714 178.753 142.555 178.86 142.369 178.944C142.191 179.028 142.014 179.07 141.837 179.07C141.734 179.07 141.636 179.042 141.543 178.986C141.459 178.93 141.393 178.86 141.347 178.776L139.289 175.178L137.245 178.776C137.198 178.86 137.128 178.93 137.035 178.986C136.951 179.042 136.857 179.07 136.755 179.07ZM146.871 179C146.638 179 146.428 178.953 146.241 178.86C146.054 178.757 145.961 178.608 145.961 178.412V170.404H143.903C143.726 170.404 143.586 170.32 143.483 170.152C143.38 169.984 143.329 169.793 143.329 169.578C143.329 169.382 143.376 169.2 143.469 169.032C143.562 168.855 143.707 168.766 143.903 168.766H149.825C150.03 168.766 150.175 168.855 150.259 169.032C150.352 169.2 150.399 169.382 150.399 169.578C150.399 169.793 150.348 169.984 150.245 170.152C150.152 170.32 150.012 170.404 149.825 170.404H147.781V178.412C147.781 178.608 147.683 178.757 147.487 178.86C147.3 178.953 147.095 179 146.871 179Z\" fill=\"#FF0082\"/> </g> </g> <defs> <filter id=\"filter0_d_1192_51091\" x=\"0\" y=\"0\" width=\"275\" height=\"222\" filterUnits=\"userSpaceOnUse\" color-interpolation-filters=\"sRGB\"> <feFlood flood-opacity=\"0\" result=\"BackgroundImageFix\"/> <feColorMatrix in=\"SourceAlpha\" type=\"matrix\" values=\"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0\" result=\"hardAlpha\"/> <feOffset dx=\"5\" dy=\"5\"/> <feComposite in2=\"hardAlpha\" operator=\"out\"/> <feColorMatrix type=\"matrix\" values=\"0 0 0 0 0.956863 0 0 0 0 0.490196 0 0 0 0 0.380392 0 0 0 1 0\"/> <feBlend mode=\"normal\" in2=\"BackgroundImageFix\" result=\"effect1_dropShadow_1192_51091\"/> <feBlend mode=\"normal\" in=\"SourceGraphic\" in2=\"effect1_dropShadow_1192_51091\" result=\"shape\"/> </filter> <filter id=\"filter1_d_1192_51091\" x=\"99\" y=\"159\" width=\"75\" height=\"31\" filterUnits=\"userSpaceOnUse\" color-interpolation-filters=\"sRGB\"> <feFlood flood-opacity=\"0\" result=\"BackgroundImageFix\"/> <feColorMatrix in=\"SourceAlpha\" type=\"matrix\" values=\"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0\" result=\"hardAlpha\"/> <feOffset dx=\"2\" dy=\"2\"/> <feComposite in2=\"hardAlpha\" operator=\"out\"/> <feColorMatrix type=\"matrix\" values=\"0 0 0 0 1 0 0 0 0 0 0 0 0 0 0.509804 0 0 0 1 0\"/> <feBlend mode=\"normal\" in2=\"BackgroundImageFix\" result=\"effect1_dropShadow_1192_51091\"/> <feBlend mode=\"normal\" in=\"SourceGraphic\" in2=\"effect1_dropShadow_1192_51091\" result=\"shape\"/> </filter> </defs> </svg>") // EJsS HtmlView.HtmlView Page: setting property 'Html' for element 'cereal_wrong'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"toys_right", _view.gameScreen) // EJsS HtmlView.HtmlView Page: declaration of element 'toys_right'
      .setProperty("Html","<svg width=\"275\" height=\"222\" viewBox=\"0 0 275 222\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"> <g filter=\"url(#filter0_d_1192_52170)\"> <rect width=\"270\" height=\"217\" rx=\"50\" fill=\"#F9E6E0\"/> <rect x=\"0.5\" y=\"0.5\" width=\"269\" height=\"216\" rx=\"49.5\" stroke=\"#FFD208\"/> <path d=\"M90.113 50C89.7797 50 89.4797 49.9333 89.213 49.8C88.9464 49.6533 88.813 49.44 88.813 49.16V37.72H85.873C85.6197 37.72 85.4197 37.6 85.273 37.36C85.1264 37.12 85.053 36.8467 85.053 36.54C85.053 36.26 85.1197 36 85.253 35.76C85.3864 35.5067 85.593 35.38 85.873 35.38H94.333C94.6264 35.38 94.833 35.5067 94.953 35.76C95.0864 36 95.153 36.26 95.153 36.54C95.153 36.8467 95.0797 37.12 94.933 37.36C94.7997 37.6 94.5997 37.72 94.333 37.72H91.413V49.16C91.413 49.44 91.273 49.6533 90.993 49.8C90.7264 49.9333 90.433 50 90.113 50ZM97.6418 50C97.2685 50 96.9618 49.9133 96.7218 49.74C96.4818 49.5667 96.3618 49.3733 96.3618 49.16V35.76C96.3618 35.52 96.4818 35.3267 96.7218 35.18C96.9618 35.0333 97.2685 34.96 97.6418 34.96C98.0018 34.96 98.3085 35.0333 98.5618 35.18C98.8151 35.3267 98.9418 35.52 98.9418 35.76V41.9C99.1418 41.5133 99.4551 41.1667 99.8818 40.86C100.308 40.54 100.835 40.38 101.462 40.38C102.088 40.38 102.662 40.5667 103.182 40.94C103.702 41.3 104.115 41.7867 104.422 42.4C104.742 43.0133 104.902 43.6933 104.902 44.44V49.16C104.902 49.44 104.768 49.6533 104.502 49.8C104.235 49.9333 103.935 50 103.602 50C103.308 50 103.022 49.9333 102.742 49.8C102.462 49.6533 102.322 49.44 102.322 49.16V44.44C102.322 44.1333 102.242 43.8467 102.082 43.58C101.922 43.3133 101.708 43.0933 101.442 42.92C101.188 42.7333 100.902 42.64 100.582 42.64C100.315 42.64 100.055 42.7133 99.8018 42.86C99.5485 43.0067 99.3418 43.2133 99.1818 43.48C99.0218 43.7467 98.9418 44.0667 98.9418 44.44V49.16C98.9418 49.3733 98.8151 49.5667 98.5618 49.74C98.3085 49.9133 98.0018 50 97.6418 50ZM108.87 50.18C108.163 50.18 107.55 49.9667 107.03 49.54C106.523 49.1 106.27 48.4267 106.27 47.52C106.27 46.76 106.463 46.1667 106.85 45.74C107.25 45.3133 107.797 45.0133 108.49 44.84C109.197 44.6667 110.01 44.58 110.93 44.58H111.75V44.32C111.75 44.0267 111.69 43.74 111.57 43.46C111.463 43.18 111.283 42.9467 111.03 42.76C110.79 42.5733 110.443 42.48 109.99 42.48C109.483 42.48 109.09 42.5333 108.81 42.64C108.543 42.7333 108.337 42.8333 108.19 42.94C108.043 43.0467 107.883 43.1 107.71 43.1C107.43 43.1 107.21 42.96 107.05 42.68C106.903 42.4 106.83 42.1133 106.83 41.82C106.83 41.54 106.997 41.2933 107.33 41.08C107.677 40.8533 108.097 40.68 108.59 40.56C109.083 40.44 109.563 40.38 110.03 40.38C111.07 40.38 111.903 40.5667 112.53 40.94C113.157 41.3133 113.61 41.7933 113.89 42.38C114.183 42.9667 114.33 43.6 114.33 44.28V49.16C114.33 49.4 114.21 49.6 113.97 49.76C113.73 49.92 113.43 50 113.07 50C112.737 50 112.457 49.92 112.23 49.76C112.017 49.6 111.91 49.4 111.91 49.16V48.6C111.55 49.0133 111.123 49.38 110.63 49.7C110.15 50.02 109.563 50.18 108.87 50.18ZM109.91 48.26C110.19 48.26 110.47 48.1667 110.75 47.98C111.03 47.7933 111.263 47.5533 111.45 47.26C111.65 46.9667 111.75 46.66 111.75 46.34V45.92H111.45C111.01 45.92 110.59 45.9467 110.19 46C109.79 46.0533 109.463 46.1733 109.21 46.36C108.97 46.5333 108.85 46.8067 108.85 47.18C108.85 47.5533 108.95 47.8267 109.15 48C109.363 48.1733 109.617 48.26 109.91 48.26ZM119.904 50C118.704 50 117.784 49.74 117.144 49.22C116.517 48.7 116.204 47.8733 116.204 46.74V37.06C116.204 36.82 116.344 36.6267 116.624 36.48C116.904 36.3333 117.191 36.26 117.484 36.26C117.804 36.26 118.097 36.3333 118.364 36.48C118.644 36.6267 118.784 36.82 118.784 37.06V40.5H121.144C121.357 40.5 121.517 40.6 121.624 40.8C121.744 40.9867 121.804 41.2 121.804 41.44C121.804 41.68 121.744 41.9 121.624 42.1C121.517 42.2867 121.357 42.38 121.144 42.38H118.784V46.74C118.784 47.14 118.864 47.42 119.024 47.58C119.197 47.74 119.491 47.82 119.904 47.82H120.684C121.057 47.82 121.331 47.9333 121.504 48.16C121.691 48.3867 121.784 48.6333 121.784 48.9C121.784 49.18 121.691 49.4333 121.504 49.66C121.331 49.8867 121.057 50 120.684 50H119.904ZM123.719 39.78C123.532 39.78 123.339 39.7267 123.139 39.62C122.952 39.5 122.859 39.3267 122.859 39.1C122.859 39.0067 122.886 38.9133 122.939 38.82L123.399 37.76C123.172 37.64 122.992 37.4733 122.859 37.26C122.726 37.0467 122.659 36.8067 122.659 36.54C122.659 36.1667 122.786 35.8467 123.039 35.58C123.306 35.3133 123.626 35.18 123.999 35.18C124.372 35.18 124.692 35.3133 124.959 35.58C125.226 35.8467 125.359 36.16 125.359 36.52C125.359 36.5867 125.346 36.6733 125.319 36.78C125.292 36.8867 125.239 37.04 125.159 37.24C125.092 37.4267 124.986 37.7 124.839 38.06C124.692 38.42 124.492 38.8867 124.239 39.46C124.199 39.5667 124.126 39.6467 124.019 39.7C123.912 39.7533 123.812 39.78 123.719 39.78ZM129.774 50.18C129.107 50.18 128.494 50.1 127.934 49.94C127.387 49.7667 126.954 49.5467 126.634 49.28C126.327 49.0133 126.174 48.74 126.174 48.46C126.174 48.3133 126.207 48.1533 126.274 47.98C126.354 47.8067 126.454 47.6533 126.574 47.52C126.707 47.3867 126.86 47.32 127.034 47.32C127.22 47.32 127.414 47.4 127.614 47.56C127.827 47.7067 128.087 47.8533 128.394 48C128.714 48.1467 129.154 48.22 129.714 48.22C130.314 48.22 130.707 48.1267 130.894 47.94C131.094 47.7533 131.194 47.56 131.194 47.36C131.194 47.0667 131.074 46.84 130.834 46.68C130.607 46.52 130.314 46.3933 129.954 46.3C129.594 46.1933 129.207 46.08 128.794 45.96C128.394 45.84 128.014 45.6867 127.654 45.5C127.294 45.3 127 45.0333 126.774 44.7C126.547 44.3533 126.434 43.9067 126.434 43.36C126.434 42.88 126.547 42.4133 126.774 41.96C127 41.5067 127.374 41.1333 127.894 40.84C128.414 40.5333 129.12 40.38 130.014 40.38C130.56 40.38 131.074 40.44 131.554 40.56C132.047 40.6667 132.447 40.82 132.754 41.02C133.06 41.22 133.214 41.44 133.214 41.68C133.214 41.8 133.174 41.96 133.094 42.16C133.014 42.3467 132.9 42.52 132.754 42.68C132.62 42.84 132.454 42.92 132.254 42.92C132.107 42.92 131.927 42.8733 131.714 42.78C131.514 42.6733 131.28 42.5733 131.014 42.48C130.747 42.3867 130.427 42.34 130.054 42.34C129.72 42.34 129.454 42.3867 129.254 42.48C129.054 42.5733 128.907 42.6867 128.814 42.82C128.72 42.9533 128.674 43.0933 128.674 43.24C128.674 43.48 128.787 43.6667 129.014 43.8C129.24 43.9333 129.534 44.0467 129.894 44.14C130.267 44.2333 130.654 44.34 131.054 44.46C131.467 44.5667 131.854 44.7267 132.214 44.94C132.587 45.1533 132.887 45.4467 133.114 45.82C133.34 46.18 133.454 46.6533 133.454 47.24C133.454 48.1333 133.134 48.8467 132.494 49.38C131.867 49.9133 130.96 50.18 129.774 50.18ZM147.238 50.1C147.064 50.1 146.891 50.0467 146.718 49.94C146.558 49.8333 146.431 49.68 146.338 49.48L143.498 43.96H141.818V49.16C141.818 49.44 141.684 49.6533 141.418 49.8C141.151 49.9333 140.851 50 140.518 50C140.198 50 139.898 49.9333 139.618 49.8C139.351 49.6533 139.218 49.44 139.218 49.16V36.2C139.218 35.9733 139.291 35.78 139.438 35.62C139.598 35.46 139.804 35.38 140.058 35.38H144.018C144.898 35.38 145.691 35.5067 146.398 35.76C147.118 36.0133 147.691 36.4467 148.118 37.06C148.544 37.66 148.758 38.4933 148.758 39.56C148.758 40.3333 148.644 40.9933 148.418 41.54C148.191 42.0733 147.878 42.5067 147.478 42.84C147.091 43.16 146.644 43.4 146.138 43.56L148.778 48.42C148.804 48.4733 148.824 48.5333 148.838 48.6C148.851 48.6533 148.858 48.7 148.858 48.74C148.858 48.9533 148.778 49.1667 148.618 49.38C148.458 49.5933 148.251 49.7667 147.998 49.9C147.758 50.0333 147.504 50.1 147.238 50.1ZM141.818 41.92H144.018C144.671 41.92 145.191 41.76 145.578 41.44C145.964 41.12 146.158 40.5733 146.158 39.8C146.158 39 145.964 38.4467 145.578 38.14C145.191 37.82 144.671 37.66 144.018 37.66H141.818V41.92ZM151.665 38.38C151.278 38.38 150.945 38.2533 150.665 38C150.385 37.7333 150.245 37.44 150.245 37.12C150.245 36.7733 150.385 36.48 150.665 36.24C150.945 35.9867 151.278 35.86 151.665 35.86C152.065 35.86 152.398 35.9867 152.665 36.24C152.931 36.48 153.065 36.7733 153.065 37.12C153.065 37.44 152.931 37.7333 152.665 38C152.398 38.2533 152.065 38.38 151.665 38.38ZM151.665 50C151.291 50 150.985 49.9133 150.745 49.74C150.505 49.5667 150.385 49.3733 150.385 49.16V41.3C150.385 41.06 150.505 40.8667 150.745 40.72C150.985 40.5733 151.291 40.5 151.665 40.5C152.025 40.5 152.331 40.5733 152.585 40.72C152.838 40.8667 152.965 41.06 152.965 41.3V49.16C152.965 49.3733 152.838 49.5667 152.585 49.74C152.331 49.9133 152.025 50 151.665 50ZM158.676 54.42C157.889 54.42 157.156 54.3067 156.476 54.08C155.809 53.8667 155.269 53.5467 154.856 53.12C154.456 52.6933 154.256 52.1867 154.256 51.6C154.256 51.0933 154.396 50.66 154.676 50.3C154.956 49.9533 155.302 49.68 155.716 49.48C155.462 49.36 155.256 49.2 155.096 49C154.949 48.7867 154.876 48.52 154.876 48.2C154.876 47.8267 154.969 47.5267 155.156 47.3C155.356 47.06 155.602 46.84 155.896 46.64C155.496 46.3333 155.182 45.9667 154.956 45.54C154.742 45.1 154.636 44.62 154.636 44.1V43.68C154.636 43.0267 154.796 42.4533 155.116 41.96C155.449 41.4667 155.909 41.08 156.496 40.8C157.096 40.52 157.782 40.38 158.556 40.38C158.996 40.38 159.409 40.4333 159.796 40.54C160.182 40.6333 160.529 40.7733 160.836 40.96C161.062 40.4267 161.276 40.0667 161.476 39.88C161.676 39.6933 161.869 39.6 162.056 39.6C162.376 39.6 162.622 39.6933 162.796 39.88C162.982 40.0667 163.076 40.24 163.076 40.4C163.076 40.52 163.042 40.6267 162.976 40.72C162.922 40.8133 162.849 40.8933 162.756 40.96C162.622 41.04 162.469 41.14 162.296 41.26C162.122 41.3667 161.962 41.52 161.816 41.72C162.056 41.9867 162.229 42.2867 162.336 42.62C162.456 42.94 162.516 43.2933 162.516 43.68V44.1C162.516 44.74 162.349 45.3133 162.016 45.82C161.682 46.3133 161.216 46.7067 160.616 47C160.016 47.2933 159.329 47.44 158.556 47.44C158.076 47.44 157.642 47.38 157.256 47.26C157.189 47.3133 157.129 47.3733 157.076 47.44C157.036 47.5067 157.016 47.58 157.016 47.66C157.016 47.8867 157.162 48.0467 157.456 48.14C157.749 48.2333 158.122 48.3067 158.576 48.36C159.029 48.4133 159.509 48.4867 160.016 48.58C160.536 48.66 161.022 48.7933 161.476 48.98C161.929 49.1667 162.302 49.4467 162.596 49.82C162.889 50.18 163.036 50.6667 163.036 51.28C163.036 52.0267 162.822 52.6267 162.396 53.08C161.982 53.5467 161.442 53.8867 160.776 54.1C160.122 54.3133 159.422 54.42 158.676 54.42ZM158.636 52.76C159.156 52.76 159.596 52.6333 159.956 52.38C160.329 52.1267 160.516 51.7867 160.516 51.36C160.516 51.08 160.436 50.8533 160.276 50.68C160.116 50.5067 159.896 50.3733 159.616 50.28C159.349 50.2 159.056 50.1333 158.736 50.08C158.416 50.04 158.096 50 157.776 49.96C157.456 50.1067 157.196 50.2933 156.996 50.52C156.796 50.7467 156.696 51.02 156.696 51.34C156.696 51.78 156.882 52.1267 157.256 52.38C157.642 52.6333 158.102 52.76 158.636 52.76ZM158.596 45.88C159.036 45.88 159.382 45.7133 159.636 45.38C159.889 45.0467 160.016 44.62 160.016 44.1V43.68C160.016 43.1867 159.889 42.7733 159.636 42.44C159.396 42.1067 159.042 41.94 158.576 41.94C158.122 41.94 157.769 42.1067 157.516 42.44C157.276 42.7733 157.156 43.1867 157.156 43.68V44.08C157.156 44.5867 157.276 45.0133 157.516 45.36C157.769 45.7067 158.129 45.88 158.596 45.88ZM165.65 50C165.276 50 164.97 49.9133 164.73 49.74C164.49 49.5667 164.37 49.3733 164.37 49.16V35.76C164.37 35.52 164.49 35.3267 164.73 35.18C164.97 35.0333 165.276 34.96 165.65 34.96C166.01 34.96 166.316 35.0333 166.57 35.18C166.823 35.3267 166.95 35.52 166.95 35.76V41.9C167.15 41.5133 167.463 41.1667 167.89 40.86C168.316 40.54 168.843 40.38 169.47 40.38C170.096 40.38 170.67 40.5667 171.19 40.94C171.71 41.3 172.123 41.7867 172.43 42.4C172.75 43.0133 172.91 43.6933 172.91 44.44V49.16C172.91 49.44 172.776 49.6533 172.51 49.8C172.243 49.9333 171.943 50 171.61 50C171.316 50 171.03 49.9333 170.75 49.8C170.47 49.6533 170.33 49.44 170.33 49.16V44.44C170.33 44.1333 170.25 43.8467 170.09 43.58C169.93 43.3133 169.716 43.0933 169.45 42.92C169.196 42.7333 168.91 42.64 168.59 42.64C168.323 42.64 168.063 42.7133 167.81 42.86C167.556 43.0067 167.35 43.2133 167.19 43.48C167.03 43.7467 166.95 44.0667 166.95 44.44V49.16C166.95 49.3733 166.823 49.5667 166.57 49.74C166.316 49.9133 166.01 50 165.65 50ZM178.498 50C177.298 50 176.378 49.74 175.738 49.22C175.111 48.7 174.798 47.8733 174.798 46.74V37.06C174.798 36.82 174.938 36.6267 175.218 36.48C175.498 36.3333 175.785 36.26 176.078 36.26C176.398 36.26 176.691 36.3333 176.958 36.48C177.238 36.6267 177.378 36.82 177.378 37.06V40.5H179.738C179.951 40.5 180.111 40.6 180.218 40.8C180.338 40.9867 180.398 41.2 180.398 41.44C180.398 41.68 180.338 41.9 180.218 42.1C180.111 42.2867 179.951 42.38 179.738 42.38H177.378V46.74C177.378 47.14 177.458 47.42 177.618 47.58C177.791 47.74 178.085 47.82 178.498 47.82H179.278C179.651 47.82 179.925 47.9333 180.098 48.16C180.285 48.3867 180.378 48.6333 180.378 48.9C180.378 49.18 180.285 49.4333 180.098 49.66C179.925 49.8867 179.651 50 179.278 50H178.498ZM182.933 45.96C182.666 45.96 182.433 45.9 182.233 45.78C182.033 45.66 181.933 45.4667 181.933 45.2C181.933 44.32 181.913 43.3667 181.873 42.34C181.833 41.3133 181.786 40.2867 181.733 39.26C181.693 38.2333 181.673 37.28 181.673 36.4C181.673 36.0533 181.793 35.7867 182.033 35.6C182.273 35.4 182.573 35.3 182.933 35.3C183.266 35.3 183.553 35.4 183.793 35.6C184.046 35.7867 184.173 36.0533 184.173 36.4C184.173 37.28 184.153 38.2333 184.113 39.26C184.073 40.2867 184.026 41.3133 183.973 42.34C183.933 43.3667 183.913 44.32 183.913 45.2C183.913 45.4667 183.8 45.66 183.573 45.78C183.346 45.9 183.133 45.96 182.933 45.96ZM182.953 50.12C182.566 50.12 182.24 49.9867 181.973 49.72C181.72 49.44 181.593 49.12 181.593 48.76C181.593 48.3867 181.72 48.0667 181.973 47.8C182.24 47.5333 182.566 47.4 182.953 47.4C183.313 47.4 183.626 47.5333 183.893 47.8C184.16 48.0667 184.293 48.3867 184.293 48.76C184.293 49.12 184.16 49.44 183.893 49.72C183.626 49.9867 183.313 50.12 182.953 50.12Z\" fill=\"#FF0082\"/> <path d=\"M48.0558 84C47.8425 84 47.6451 83.952 47.4638 83.856C47.2931 83.76 47.2078 83.6213 47.2078 83.44V73.856H44.7278C44.5571 73.856 44.4238 73.776 44.3278 73.616C44.2318 73.456 44.1838 73.2747 44.1838 73.072C44.1838 72.88 44.2265 72.704 44.3118 72.544C44.3971 72.384 44.5358 72.304 44.7278 72.304H51.3678C51.5705 72.304 51.7145 72.384 51.7998 72.544C51.8851 72.704 51.9278 72.8747 51.9278 73.056C51.9278 73.2693 51.8798 73.456 51.7838 73.616C51.6985 73.776 51.5598 73.856 51.3678 73.856H48.9038V83.44C48.9038 83.6213 48.8131 83.76 48.6318 83.856C48.4611 83.952 48.2691 84 48.0558 84ZM54.5048 84.128C53.9288 84.128 53.3901 83.9787 52.8888 83.68C52.3875 83.3813 51.9821 82.992 51.6728 82.512C51.3741 82.0213 51.2248 81.4987 51.2248 80.944V79.472C51.2248 78.9067 51.3688 78.384 51.6568 77.904C51.9555 77.424 52.3555 77.04 52.8568 76.752C53.3688 76.464 53.9235 76.32 54.5208 76.32C55.1181 76.32 55.6675 76.464 56.1688 76.752C56.6701 77.0293 57.0701 77.408 57.3688 77.888C57.6781 78.3573 57.8328 78.8853 57.8328 79.472V80.944C57.8328 81.488 57.6781 82.0053 57.3688 82.496C57.0701 82.9867 56.6648 83.3813 56.1528 83.68C55.6515 83.9787 55.1021 84.128 54.5048 84.128ZM54.5208 82.64C54.8195 82.64 55.0915 82.56 55.3368 82.4C55.5821 82.24 55.7795 82.032 55.9288 81.776C56.0781 81.5093 56.1528 81.232 56.1528 80.944V79.472C56.1528 79.1947 56.0781 78.928 55.9288 78.672C55.7795 78.416 55.5821 78.208 55.3368 78.048C55.0915 77.888 54.8195 77.808 54.5208 77.808C54.2115 77.808 53.9341 77.888 53.6888 78.048C53.4541 78.208 53.2621 78.416 53.1128 78.672C52.9741 78.928 52.9048 79.1947 52.9048 79.472V80.944C52.9048 81.232 52.9741 81.5093 53.1128 81.776C53.2621 82.032 53.4595 82.24 53.7048 82.4C53.9501 82.56 54.2221 82.64 54.5208 82.64ZM59.2948 87.6C59.0815 87.6 58.9001 87.552 58.7508 87.456C58.6015 87.3707 58.5268 87.1787 58.5268 86.88C58.5268 86.688 58.5588 86.5173 58.6228 86.368C58.6868 86.2293 58.8041 86.16 58.9748 86.16C59.1775 86.16 59.3961 86.1067 59.6308 86C59.8761 85.904 60.1108 85.744 60.3348 85.52C60.5695 85.3067 60.7668 85.0347 60.9268 84.704C61.0975 84.3733 61.2148 83.984 61.2788 83.536L58.5748 77.328C58.5321 77.2533 58.5108 77.1787 58.5108 77.104C58.5108 76.9653 58.5695 76.8373 58.6868 76.72C58.8148 76.592 58.9641 76.4907 59.1348 76.416C59.3055 76.3413 59.4655 76.304 59.6148 76.304C59.7215 76.304 59.8228 76.3307 59.9188 76.384C60.0255 76.4267 60.0948 76.5013 60.1268 76.608L62.1428 81.808L63.8868 76.608C63.9188 76.5013 63.9828 76.4267 64.0788 76.384C64.1748 76.3307 64.2708 76.304 64.3668 76.304C64.4948 76.304 64.6441 76.3413 64.8148 76.416C64.9961 76.4907 65.1508 76.592 65.2788 76.72C65.4175 76.8373 65.4868 76.976 65.4868 77.136C65.4868 77.2213 65.4708 77.2853 65.4388 77.328L63.0388 83.584C62.8681 84.0427 62.6921 84.5067 62.5108 84.976C62.3295 85.456 62.1055 85.8933 61.8388 86.288C61.5828 86.6827 61.2468 86.9973 60.8308 87.232C60.4255 87.4773 59.9135 87.6 59.2948 87.6ZM68.8484 84.128C68.3258 84.128 67.8564 84.064 67.4404 83.936C67.0244 83.808 66.6938 83.648 66.4484 83.456C66.2138 83.2533 66.0964 83.0507 66.0964 82.848C66.0964 82.752 66.1178 82.6453 66.1604 82.528C66.2138 82.4107 66.2831 82.3093 66.3684 82.224C66.4644 82.1387 66.5658 82.096 66.6724 82.096C66.8111 82.096 66.9551 82.16 67.1044 82.288C67.2644 82.4053 67.4724 82.528 67.7284 82.656C67.9844 82.7733 68.3418 82.832 68.8004 82.832C69.3338 82.832 69.6911 82.7413 69.8724 82.56C70.0644 82.3787 70.1604 82.1813 70.1604 81.968C70.1604 81.6907 70.0644 81.4773 69.8724 81.328C69.6911 81.168 69.4511 81.04 69.1524 80.944C68.8644 80.848 68.5551 80.7573 68.2244 80.672C67.8938 80.576 67.5791 80.4533 67.2804 80.304C66.9924 80.1547 66.7524 79.9467 66.5604 79.68C66.3791 79.4133 66.2884 79.0613 66.2884 78.624C66.2884 78.2613 66.3791 77.904 66.5604 77.552C66.7418 77.1893 67.0298 76.896 67.4244 76.672C67.8298 76.4373 68.3684 76.32 69.0404 76.32C69.4458 76.32 69.8298 76.3627 70.1924 76.448C70.5551 76.5333 70.8538 76.6507 71.0884 76.8C71.3231 76.9387 71.4404 77.0933 71.4404 77.264C71.4404 77.3387 71.4138 77.4453 71.3604 77.584C71.3071 77.712 71.2324 77.8293 71.1364 77.936C71.0511 78.032 70.9391 78.08 70.8004 78.08C70.6938 78.08 70.5604 78.0427 70.4004 77.968C70.2404 77.8827 70.0538 77.8027 69.8404 77.728C69.6271 77.6533 69.3658 77.616 69.0564 77.616C68.7471 77.616 68.4964 77.6693 68.3044 77.776C68.1231 77.872 67.9898 77.9893 67.9044 78.128C67.8191 78.2667 67.7764 78.4053 67.7764 78.544C67.7764 78.7787 67.8671 78.96 68.0484 79.088C68.2298 79.216 68.4698 79.3227 68.7684 79.408C69.0671 79.4933 69.3818 79.584 69.7124 79.68C70.0431 79.7653 70.3524 79.8933 70.6404 80.064C70.9391 80.2347 71.1791 80.464 71.3604 80.752C71.5524 81.04 71.6484 81.424 71.6484 81.904C71.6484 82.576 71.4031 83.1147 70.9124 83.52C70.4324 83.9253 69.7444 84.128 68.8484 84.128ZM77.0636 74.512C76.7969 74.512 76.5676 74.4213 76.3756 74.24C76.1836 74.0587 76.0876 73.856 76.0876 73.632C76.0876 73.3867 76.1836 73.1787 76.3756 73.008C76.5676 72.8373 76.7969 72.752 77.0636 72.752C77.3302 72.752 77.5542 72.8373 77.7356 73.008C77.9276 73.1787 78.0236 73.3867 78.0236 73.632C78.0236 73.856 77.9276 74.0587 77.7356 74.24C77.5542 74.4213 77.3302 74.512 77.0636 74.512ZM77.0636 84C76.8182 84 76.6156 83.9413 76.4556 83.824C76.3062 83.7067 76.2316 83.5787 76.2316 83.44V76.96C76.2316 76.8 76.3062 76.672 76.4556 76.576C76.6156 76.4693 76.8182 76.416 77.0636 76.416C77.2982 76.416 77.4956 76.4693 77.6556 76.576C77.8262 76.672 77.9116 76.8 77.9116 76.96V83.44C77.9116 83.5787 77.8262 83.7067 77.6556 83.824C77.4956 83.9413 77.2982 84 77.0636 84ZM80.4854 84C80.2401 84 80.0374 83.9413 79.8774 83.824C79.7281 83.7067 79.6534 83.5787 79.6534 83.44V76.96C79.6534 76.8 79.7281 76.672 79.8774 76.576C80.0374 76.4693 80.2401 76.416 80.4854 76.416C80.6881 76.416 80.8641 76.4693 81.0134 76.576C81.1628 76.672 81.2374 76.8 81.2374 76.96V77.536C81.3974 77.2267 81.6588 76.9493 82.0214 76.704C82.3948 76.448 82.8481 76.32 83.3814 76.32C83.8828 76.32 84.3414 76.464 84.7574 76.752C85.1841 77.0293 85.5254 77.408 85.7814 77.888C86.0374 78.3573 86.1654 78.8853 86.1654 79.472V83.44C86.1654 83.6213 86.0748 83.76 85.8934 83.856C85.7228 83.952 85.5308 84 85.3174 84C85.1254 84 84.9388 83.952 84.7574 83.856C84.5761 83.76 84.4854 83.6213 84.4854 83.44V79.472C84.4854 79.1947 84.4108 78.928 84.2614 78.672C84.1228 78.416 83.9308 78.208 83.6854 78.048C83.4401 77.888 83.1681 77.808 82.8694 77.808C82.6134 77.808 82.3681 77.8773 82.1334 78.016C81.8988 78.144 81.7068 78.3307 81.5574 78.576C81.4081 78.8213 81.3334 79.12 81.3334 79.472V83.44C81.3334 83.5787 81.2481 83.7067 81.0774 83.824C80.9174 83.9413 80.7201 84 80.4854 84ZM91.8761 87.6C91.6414 87.6 91.4441 87.5413 91.2841 87.424C91.1347 87.3067 91.0601 87.1787 91.0601 87.04V76.96C91.0601 76.8 91.1347 76.672 91.2841 76.576C91.4441 76.4693 91.6361 76.416 91.8601 76.416C92.0841 76.416 92.2707 76.4693 92.4201 76.576C92.5694 76.672 92.6441 76.8 92.6441 76.96V77.536C92.8254 77.2267 93.0974 76.9493 93.4601 76.704C93.8334 76.448 94.2761 76.32 94.7881 76.32C95.3214 76.32 95.8067 76.464 96.2441 76.752C96.6814 77.0293 97.0281 77.408 97.2841 77.888C97.5401 78.3573 97.6681 78.8853 97.6681 79.472V80.944C97.6681 81.4987 97.5347 82.0213 97.2681 82.512C97.0121 82.992 96.6707 83.3813 96.2441 83.68C95.8174 83.9787 95.3534 84.128 94.8521 84.128C94.3721 84.128 93.9401 84.0053 93.5561 83.76C93.1721 83.504 92.9001 83.2107 92.7401 82.88V87.04C92.7401 87.1787 92.6547 87.3067 92.4841 87.424C92.3241 87.5413 92.1214 87.6 91.8761 87.6ZM94.3561 82.64C94.6441 82.64 94.9107 82.56 95.1561 82.4C95.4014 82.24 95.5987 82.0267 95.7481 81.76C95.9081 81.4933 95.9881 81.2213 95.9881 80.944V79.472C95.9881 79.1947 95.9134 78.928 95.7641 78.672C95.6147 78.416 95.4121 78.208 95.1561 78.048C94.9107 77.888 94.6334 77.808 94.3241 77.808C94.0681 77.808 93.8174 77.8773 93.5721 78.016C93.3267 78.144 93.1241 78.3307 92.9641 78.576C92.8147 78.8213 92.7401 79.12 92.7401 79.472V81.312C92.7401 81.44 92.8094 81.6107 92.9481 81.824C93.0867 82.0267 93.2787 82.2133 93.5241 82.384C93.7694 82.5547 94.0467 82.64 94.3561 82.64ZM102.13 84.128C101.554 84.128 101.015 83.9787 100.514 83.68C100.012 83.3813 99.6071 82.992 99.2978 82.512C98.9991 82.0213 98.8498 81.4987 98.8498 80.944V79.472C98.8498 78.9067 98.9938 78.384 99.2818 77.904C99.5805 77.424 99.9805 77.04 100.482 76.752C100.994 76.464 101.548 76.32 102.146 76.32C102.743 76.32 103.292 76.464 103.794 76.752C104.295 77.0293 104.695 77.408 104.994 77.888C105.303 78.3573 105.458 78.8853 105.458 79.472V80.944C105.458 81.488 105.303 82.0053 104.994 82.496C104.695 82.9867 104.29 83.3813 103.778 83.68C103.276 83.9787 102.727 84.128 102.13 84.128ZM102.146 82.64C102.444 82.64 102.716 82.56 102.962 82.4C103.207 82.24 103.404 82.032 103.554 81.776C103.703 81.5093 103.778 81.232 103.778 80.944V79.472C103.778 79.1947 103.703 78.928 103.554 78.672C103.404 78.416 103.207 78.208 102.962 78.048C102.716 77.888 102.444 77.808 102.146 77.808C101.836 77.808 101.559 77.888 101.314 78.048C101.079 78.208 100.887 78.416 100.738 78.672C100.599 78.928 100.53 79.1947 100.53 79.472V80.944C100.53 81.232 100.599 81.5093 100.738 81.776C100.887 82.032 101.084 82.24 101.33 82.4C101.575 82.56 101.847 82.64 102.146 82.64ZM109.911 84.128C109.335 84.128 108.796 83.9787 108.295 83.68C107.794 83.3813 107.388 82.992 107.079 82.512C106.78 82.0213 106.631 81.4987 106.631 80.944V79.472C106.631 78.9067 106.775 78.384 107.063 77.904C107.362 77.424 107.762 77.04 108.263 76.752C108.775 76.464 109.33 76.32 109.927 76.32C110.524 76.32 111.074 76.464 111.575 76.752C112.076 77.0293 112.476 77.408 112.775 77.888C113.084 78.3573 113.239 78.8853 113.239 79.472V80.944C113.239 81.488 113.084 82.0053 112.775 82.496C112.476 82.9867 112.071 83.3813 111.559 83.68C111.058 83.9787 110.508 84.128 109.911 84.128ZM109.927 82.64C110.226 82.64 110.498 82.56 110.743 82.4C110.988 82.24 111.186 82.032 111.335 81.776C111.484 81.5093 111.559 81.232 111.559 80.944V79.472C111.559 79.1947 111.484 78.928 111.335 78.672C111.186 78.416 110.988 78.208 110.743 78.048C110.498 77.888 110.226 77.808 109.927 77.808C109.618 77.808 109.34 77.888 109.095 78.048C108.86 78.208 108.668 78.416 108.519 78.672C108.38 78.928 108.311 79.1947 108.311 79.472V80.944C108.311 81.232 108.38 81.5093 108.519 81.776C108.668 82.032 108.866 82.24 109.111 82.4C109.356 82.56 109.628 82.64 109.927 82.64ZM115.516 84C115.282 84 115.084 83.9413 114.924 83.824C114.775 83.7067 114.7 83.5787 114.7 83.44V76.96C114.7 76.8 114.775 76.672 114.924 76.576C115.084 76.4693 115.282 76.416 115.516 76.416C115.73 76.416 115.911 76.4693 116.06 76.576C116.21 76.672 116.284 76.8 116.284 76.96V77.664C116.402 77.44 116.556 77.2267 116.748 77.024C116.951 76.8213 117.186 76.656 117.452 76.528C117.719 76.3893 118.007 76.32 118.316 76.32H118.828C118.999 76.32 119.148 76.3947 119.276 76.544C119.404 76.6827 119.468 76.8533 119.468 77.056C119.468 77.2587 119.404 77.4347 119.276 77.584C119.148 77.7333 118.999 77.808 118.828 77.808H118.316C117.996 77.808 117.687 77.904 117.388 78.096C117.09 78.288 116.844 78.56 116.652 78.912C116.471 79.2533 116.38 79.6693 116.38 80.16V83.44C116.38 83.5787 116.295 83.7067 116.124 83.824C115.964 83.9413 115.762 84 115.516 84ZM126.71 84.128C125.942 84.128 125.307 83.9893 124.806 83.712C124.315 83.4347 123.952 83.056 123.718 82.576C123.483 82.096 123.366 81.552 123.366 80.944V79.504C123.366 78.9067 123.483 78.368 123.718 77.888C123.952 77.3973 124.315 77.0133 124.806 76.736C125.296 76.4587 125.92 76.32 126.678 76.32C127.168 76.32 127.595 76.3787 127.958 76.496C128.331 76.6133 128.619 76.7627 128.822 76.944C129.035 77.1147 129.142 77.296 129.142 77.488C129.142 77.584 129.11 77.7013 129.046 77.84C128.992 77.968 128.912 78.08 128.806 78.176C128.71 78.2613 128.592 78.304 128.454 78.304C128.347 78.304 128.23 78.2613 128.102 78.176C127.984 78.0907 127.824 78.0107 127.622 77.936C127.419 77.8507 127.147 77.808 126.806 77.808C126.208 77.808 125.766 77.9573 125.478 78.256C125.19 78.5547 125.046 78.9707 125.046 79.504V80.944C125.046 81.4773 125.19 81.8933 125.478 82.192C125.766 82.4907 126.214 82.64 126.822 82.64C127.174 82.64 127.451 82.5973 127.654 82.512C127.856 82.416 128.016 82.3253 128.134 82.24C128.262 82.1547 128.384 82.112 128.502 82.112C128.651 82.112 128.779 82.1547 128.886 82.24C129.003 82.3253 129.088 82.432 129.142 82.56C129.206 82.688 129.238 82.8053 129.238 82.912C129.238 83.0933 129.126 83.28 128.902 83.472C128.688 83.664 128.39 83.824 128.006 83.952C127.632 84.0693 127.2 84.128 126.71 84.128ZM133.349 84.128C132.773 84.128 132.234 83.9787 131.733 83.68C131.231 83.3813 130.826 82.992 130.517 82.512C130.218 82.0213 130.069 81.4987 130.069 80.944V79.472C130.069 78.9067 130.213 78.384 130.501 77.904C130.799 77.424 131.199 77.04 131.701 76.752C132.213 76.464 132.767 76.32 133.365 76.32C133.962 76.32 134.511 76.464 135.013 76.752C135.514 77.0293 135.914 77.408 136.213 77.888C136.522 78.3573 136.677 78.8853 136.677 79.472V80.944C136.677 81.488 136.522 82.0053 136.213 82.496C135.914 82.9867 135.509 83.3813 134.997 83.68C134.495 83.9787 133.946 84.128 133.349 84.128ZM133.365 82.64C133.663 82.64 133.935 82.56 134.181 82.4C134.426 82.24 134.623 82.032 134.773 81.776C134.922 81.5093 134.997 81.232 134.997 80.944V79.472C134.997 79.1947 134.922 78.928 134.773 78.672C134.623 78.416 134.426 78.208 134.181 78.048C133.935 77.888 133.663 77.808 133.365 77.808C133.055 77.808 132.778 77.888 132.533 78.048C132.298 78.208 132.106 78.416 131.957 78.672C131.818 78.928 131.749 79.1947 131.749 79.472V80.944C131.749 81.232 131.818 81.5093 131.957 81.776C132.106 82.032 132.303 82.24 132.549 82.4C132.794 82.56 133.066 82.64 133.365 82.64ZM138.97 84C138.724 84 138.522 83.9413 138.362 83.824C138.212 83.7067 138.138 83.5787 138.138 83.44V76.96C138.138 76.8 138.212 76.672 138.362 76.576C138.522 76.4693 138.724 76.416 138.97 76.416C139.172 76.416 139.348 76.4693 139.498 76.576C139.647 76.672 139.722 76.8 139.722 76.96V77.536C139.882 77.2267 140.143 76.9493 140.506 76.704C140.879 76.448 141.332 76.32 141.866 76.32C142.367 76.32 142.826 76.464 143.242 76.752C143.668 77.0293 144.01 77.408 144.266 77.888C144.522 78.3573 144.65 78.8853 144.65 79.472V83.44C144.65 83.6213 144.559 83.76 144.378 83.856C144.207 83.952 144.015 84 143.802 84C143.61 84 143.423 83.952 143.242 83.856C143.06 83.76 142.97 83.6213 142.97 83.44V79.472C142.97 79.1947 142.895 78.928 142.746 78.672C142.607 78.416 142.415 78.208 142.17 78.048C141.924 77.888 141.652 77.808 141.354 77.808C141.098 77.808 140.852 77.8773 140.618 78.016C140.383 78.144 140.191 78.3307 140.042 78.576C139.892 78.8213 139.818 79.12 139.818 79.472V83.44C139.818 83.5787 139.732 83.7067 139.562 83.824C139.402 83.9413 139.204 84 138.97 84ZM148.853 84.128C148.352 84.128 147.888 83.9787 147.461 83.68C147.035 83.3813 146.688 82.992 146.421 82.512C146.165 82.0213 146.037 81.4987 146.037 80.944V79.472C146.037 78.8853 146.165 78.3573 146.421 77.888C146.688 77.408 147.035 77.0293 147.461 76.752C147.888 76.464 148.363 76.32 148.885 76.32C149.397 76.32 149.829 76.448 150.181 76.704C150.533 76.9493 150.795 77.2267 150.965 77.536V72.448C150.965 72.288 151.051 72.16 151.221 72.064C151.392 71.9573 151.595 71.904 151.829 71.904C152.064 71.904 152.256 71.9573 152.405 72.064C152.565 72.16 152.645 72.288 152.645 72.448V83.44C152.645 83.5787 152.565 83.7067 152.405 83.824C152.256 83.9413 152.064 84 151.829 84C151.627 84 151.445 83.9413 151.285 83.824C151.136 83.7067 151.061 83.5787 151.061 83.44V82.88C150.901 83.2107 150.619 83.504 150.213 83.76C149.808 84.0053 149.355 84.128 148.853 84.128ZM149.333 82.64C149.643 82.64 149.92 82.5547 150.165 82.384C150.411 82.2133 150.603 82.0267 150.741 81.824C150.891 81.6107 150.965 81.44 150.965 81.312V79.472C150.965 79.12 150.885 78.8213 150.725 78.576C150.565 78.3307 150.363 78.144 150.117 78.016C149.872 77.8773 149.616 77.808 149.349 77.808C149.051 77.808 148.773 77.888 148.517 78.048C148.272 78.208 148.075 78.416 147.925 78.672C147.787 78.928 147.717 79.1947 147.717 79.472V80.944C147.717 81.2213 147.787 81.4933 147.925 81.76C148.075 82.0267 148.272 82.24 148.517 82.4C148.763 82.56 149.035 82.64 149.333 82.64ZM155.251 74.512C154.984 74.512 154.755 74.4213 154.563 74.24C154.371 74.0587 154.275 73.856 154.275 73.632C154.275 73.3867 154.371 73.1787 154.563 73.008C154.755 72.8373 154.984 72.752 155.251 72.752C155.518 72.752 155.742 72.8373 155.923 73.008C156.115 73.1787 156.211 73.3867 156.211 73.632C156.211 73.856 156.115 74.0587 155.923 74.24C155.742 74.4213 155.518 74.512 155.251 74.512ZM155.251 84C155.006 84 154.803 83.9413 154.643 83.824C154.494 83.7067 154.419 83.5787 154.419 83.44V76.96C154.419 76.8 154.494 76.672 154.643 76.576C154.803 76.4693 155.006 76.416 155.251 76.416C155.486 76.416 155.683 76.4693 155.843 76.576C156.014 76.672 156.099 76.8 156.099 76.96V83.44C156.099 83.5787 156.014 83.7067 155.843 83.824C155.683 83.9413 155.486 84 155.251 84ZM160.609 84C159.702 84 159.009 83.8027 158.529 83.408C158.049 83.0027 157.809 82.368 157.809 81.504V73.488C157.809 73.328 157.894 73.2 158.065 73.104C158.246 72.9973 158.438 72.944 158.641 72.944C158.844 72.944 159.036 72.9973 159.217 73.104C159.398 73.2 159.489 73.328 159.489 73.488V76.416H161.441C161.59 76.416 161.702 76.48 161.777 76.608C161.862 76.736 161.905 76.88 161.905 77.04C161.905 77.2 161.862 77.344 161.777 77.472C161.702 77.6 161.59 77.664 161.441 77.664H159.489V81.504C159.489 81.888 159.569 82.16 159.729 82.32C159.9 82.48 160.193 82.56 160.609 82.56H161.153C161.398 82.56 161.58 82.6347 161.697 82.784C161.825 82.9227 161.889 83.088 161.889 83.28C161.889 83.4613 161.825 83.6267 161.697 83.776C161.58 83.9253 161.398 84 161.153 84H160.609ZM163.892 74.512C163.625 74.512 163.396 74.4213 163.204 74.24C163.012 74.0587 162.916 73.856 162.916 73.632C162.916 73.3867 163.012 73.1787 163.204 73.008C163.396 72.8373 163.625 72.752 163.892 72.752C164.158 72.752 164.382 72.8373 164.564 73.008C164.756 73.1787 164.852 73.3867 164.852 73.632C164.852 73.856 164.756 74.0587 164.564 74.24C164.382 74.4213 164.158 74.512 163.892 74.512ZM163.892 84C163.646 84 163.444 83.9413 163.284 83.824C163.134 83.7067 163.06 83.5787 163.06 83.44V76.96C163.06 76.8 163.134 76.672 163.284 76.576C163.444 76.4693 163.646 76.416 163.892 76.416C164.126 76.416 164.324 76.4693 164.484 76.576C164.654 76.672 164.74 76.8 164.74 76.96V83.44C164.74 83.5787 164.654 83.7067 164.484 83.824C164.324 83.9413 164.126 84 163.892 84ZM169.474 84.128C168.898 84.128 168.359 83.9787 167.858 83.68C167.356 83.3813 166.951 82.992 166.642 82.512C166.343 82.0213 166.194 81.4987 166.194 80.944V79.472C166.194 78.9067 166.338 78.384 166.626 77.904C166.924 77.424 167.324 77.04 167.826 76.752C168.338 76.464 168.892 76.32 169.49 76.32C170.087 76.32 170.636 76.464 171.138 76.752C171.639 77.0293 172.039 77.408 172.338 77.888C172.647 78.3573 172.802 78.8853 172.802 79.472V80.944C172.802 81.488 172.647 82.0053 172.338 82.496C172.039 82.9867 171.634 83.3813 171.122 83.68C170.62 83.9787 170.071 84.128 169.474 84.128ZM169.49 82.64C169.788 82.64 170.06 82.56 170.306 82.4C170.551 82.24 170.748 82.032 170.898 81.776C171.047 81.5093 171.122 81.232 171.122 80.944V79.472C171.122 79.1947 171.047 78.928 170.898 78.672C170.748 78.416 170.551 78.208 170.306 78.048C170.06 77.888 169.788 77.808 169.49 77.808C169.18 77.808 168.903 77.888 168.658 78.048C168.423 78.208 168.231 78.416 168.082 78.672C167.943 78.928 167.874 79.1947 167.874 79.472V80.944C167.874 81.232 167.943 81.5093 168.082 81.776C168.231 82.032 168.428 82.24 168.674 82.4C168.919 82.56 169.191 82.64 169.49 82.64ZM175.095 84C174.849 84 174.647 83.9413 174.487 83.824C174.337 83.7067 174.263 83.5787 174.263 83.44V76.96C174.263 76.8 174.337 76.672 174.487 76.576C174.647 76.4693 174.849 76.416 175.095 76.416C175.297 76.416 175.473 76.4693 175.623 76.576C175.772 76.672 175.847 76.8 175.847 76.96V77.536C176.007 77.2267 176.268 76.9493 176.631 76.704C177.004 76.448 177.457 76.32 177.991 76.32C178.492 76.32 178.951 76.464 179.367 76.752C179.793 77.0293 180.135 77.408 180.391 77.888C180.647 78.3573 180.775 78.8853 180.775 79.472V83.44C180.775 83.6213 180.684 83.76 180.503 83.856C180.332 83.952 180.14 84 179.927 84C179.735 84 179.548 83.952 179.367 83.856C179.185 83.76 179.095 83.6213 179.095 83.44V79.472C179.095 79.1947 179.02 78.928 178.871 78.672C178.732 78.416 178.54 78.208 178.295 78.048C178.049 77.888 177.777 77.808 177.479 77.808C177.223 77.808 176.977 77.8773 176.743 78.016C176.508 78.144 176.316 78.3307 176.167 78.576C176.017 78.8213 175.943 79.12 175.943 79.472V83.44C175.943 83.5787 175.857 83.7067 175.687 83.824C175.527 83.9413 175.329 84 175.095 84ZM188.725 84.128C187.957 84.128 187.323 83.9893 186.821 83.712C186.331 83.4347 185.968 83.056 185.733 82.576C185.499 82.096 185.381 81.552 185.381 80.944V79.504C185.381 78.9067 185.499 78.368 185.733 77.888C185.968 77.3973 186.331 77.0133 186.821 76.736C187.312 76.4587 187.936 76.32 188.693 76.32C189.184 76.32 189.611 76.3787 189.973 76.496C190.347 76.6133 190.635 76.7627 190.837 76.944C191.051 77.1147 191.157 77.296 191.157 77.488C191.157 77.584 191.125 77.7013 191.061 77.84C191.008 77.968 190.928 78.08 190.821 78.176C190.725 78.2613 190.608 78.304 190.469 78.304C190.363 78.304 190.245 78.2613 190.117 78.176C190 78.0907 189.84 78.0107 189.637 77.936C189.435 77.8507 189.163 77.808 188.821 77.808C188.224 77.808 187.781 77.9573 187.493 78.256C187.205 78.5547 187.061 78.9707 187.061 79.504V80.944C187.061 81.4773 187.205 81.8933 187.493 82.192C187.781 82.4907 188.229 82.64 188.837 82.64C189.189 82.64 189.467 82.5973 189.669 82.512C189.872 82.416 190.032 82.3253 190.149 82.24C190.277 82.1547 190.4 82.112 190.517 82.112C190.667 82.112 190.795 82.1547 190.901 82.24C191.019 82.3253 191.104 82.432 191.157 82.56C191.221 82.688 191.253 82.8053 191.253 82.912C191.253 83.0933 191.141 83.28 190.917 83.472C190.704 83.664 190.405 83.824 190.021 83.952C189.648 84.0693 189.216 84.128 188.725 84.128ZM194.098 84.128C193.512 84.128 193.01 83.9573 192.594 83.616C192.178 83.264 191.97 82.7307 191.97 82.016C191.97 81.408 192.13 80.9387 192.45 80.608C192.77 80.2773 193.208 80.048 193.762 79.92C194.328 79.792 194.978 79.728 195.714 79.728H196.418V79.44C196.418 79.1627 196.365 78.896 196.258 78.64C196.162 78.3733 195.997 78.1547 195.762 77.984C195.538 77.8027 195.229 77.712 194.834 77.712C194.44 77.712 194.136 77.7493 193.922 77.824C193.709 77.8987 193.538 77.9787 193.41 78.064C193.282 78.1493 193.165 78.192 193.058 78.192C192.866 78.192 192.717 78.1013 192.61 77.92C192.504 77.728 192.45 77.536 192.45 77.344C192.45 77.152 192.573 76.9813 192.818 76.832C193.074 76.672 193.389 76.5493 193.762 76.464C194.136 76.368 194.504 76.32 194.866 76.32C195.656 76.32 196.285 76.4693 196.754 76.768C197.224 77.056 197.565 77.4347 197.778 77.904C197.992 78.3733 198.098 78.88 198.098 79.424V83.44C198.098 83.5893 198.018 83.7227 197.858 83.84C197.709 83.9467 197.517 84 197.282 84C197.069 84 196.888 83.9467 196.738 83.84C196.589 83.7227 196.514 83.5893 196.514 83.44V82.88C196.237 83.2 195.901 83.488 195.506 83.744C195.112 84 194.642 84.128 194.098 84.128ZM194.706 82.848C194.973 82.848 195.234 82.768 195.49 82.608C195.757 82.448 195.976 82.2453 196.146 82C196.328 81.7547 196.418 81.504 196.418 81.248V80.656H196.018C195.613 80.656 195.229 80.6827 194.866 80.736C194.504 80.7787 194.21 80.8853 193.986 81.056C193.773 81.216 193.666 81.4667 193.666 81.808C193.666 82.1707 193.762 82.4373 193.954 82.608C194.157 82.768 194.408 82.848 194.706 82.848ZM200.626 84C200.381 84 200.178 83.9413 200.018 83.824C199.869 83.7067 199.794 83.5787 199.794 83.44V76.96C199.794 76.8 199.869 76.672 200.018 76.576C200.178 76.4693 200.381 76.416 200.626 76.416C200.829 76.416 201.005 76.4693 201.154 76.576C201.303 76.672 201.378 76.8 201.378 76.96V77.536C201.538 77.2267 201.799 76.9493 202.162 76.704C202.535 76.448 202.989 76.32 203.522 76.32C204.023 76.32 204.482 76.464 204.898 76.752C205.325 77.0293 205.666 77.408 205.922 77.888C206.178 78.3573 206.306 78.8853 206.306 79.472V83.44C206.306 83.6213 206.215 83.76 206.034 83.856C205.863 83.952 205.671 84 205.458 84C205.266 84 205.079 83.952 204.898 83.856C204.717 83.76 204.626 83.6213 204.626 83.44V79.472C204.626 79.1947 204.551 78.928 204.402 78.672C204.263 78.416 204.071 78.208 203.826 78.048C203.581 77.888 203.309 77.808 203.01 77.808C202.754 77.808 202.509 77.8773 202.274 78.016C202.039 78.144 201.847 78.3307 201.698 78.576C201.549 78.8213 201.474 79.12 201.474 79.472V83.44C201.474 83.5787 201.389 83.7067 201.218 83.824C201.058 83.9413 200.861 84 200.626 84ZM214.993 84.128C214.491 84.128 214.038 84.0053 213.633 83.76C213.238 83.504 212.955 83.2107 212.785 82.88V83.44C212.785 83.5787 212.71 83.7067 212.561 83.824C212.411 83.9413 212.23 84 212.017 84C211.782 84 211.585 83.9413 211.425 83.824C211.275 83.7067 211.201 83.5787 211.201 83.44V72.448C211.201 72.288 211.275 72.16 211.425 72.064C211.585 71.9573 211.782 71.904 212.017 71.904C212.262 71.904 212.465 71.9573 212.625 72.064C212.795 72.16 212.881 72.288 212.881 72.448V77.536C213.051 77.2267 213.313 76.9493 213.665 76.704C214.017 76.448 214.443 76.32 214.945 76.32C215.467 76.32 215.942 76.464 216.369 76.752C216.806 77.0293 217.153 77.408 217.409 77.888C217.675 78.3573 217.809 78.8853 217.809 79.472V80.944C217.809 81.4987 217.675 82.0213 217.409 82.512C217.153 82.992 216.811 83.3813 216.385 83.68C215.958 83.9787 215.494 84.128 214.993 84.128ZM214.513 82.64C214.801 82.64 215.067 82.56 215.313 82.4C215.558 82.24 215.755 82.0267 215.905 81.76C216.054 81.4933 216.129 81.2213 216.129 80.944V79.472C216.129 79.1947 216.054 78.928 215.905 78.672C215.755 78.416 215.558 78.208 215.313 78.048C215.067 77.888 214.795 77.808 214.497 77.808C214.23 77.808 213.974 77.8773 213.729 78.016C213.483 78.144 213.281 78.3307 213.121 78.576C212.961 78.8213 212.881 79.12 212.881 79.472V81.312C212.881 81.44 212.95 81.6107 213.089 81.824C213.238 82.0267 213.435 82.2133 213.681 82.384C213.926 82.5547 214.203 82.64 214.513 82.64ZM222.702 84.128C221.977 84.128 221.337 83.9947 220.782 83.728C220.228 83.4613 219.79 83.0933 219.47 82.624C219.15 82.144 218.99 81.584 218.99 80.944V79.424C218.99 78.8587 219.14 78.3413 219.438 77.872C219.748 77.4027 220.153 77.0293 220.654 76.752C221.156 76.464 221.71 76.32 222.318 76.32C222.894 76.32 223.422 76.448 223.902 76.704C224.382 76.9493 224.766 77.296 225.054 77.744C225.353 78.192 225.502 78.704 225.502 79.28C225.502 79.728 225.433 80.048 225.294 80.24C225.156 80.432 224.974 80.5493 224.75 80.592C224.526 80.6347 224.292 80.656 224.046 80.656H220.67V81.024C220.67 81.5573 220.862 81.984 221.246 82.304C221.641 82.6133 222.142 82.768 222.75 82.768C223.124 82.768 223.428 82.7147 223.662 82.608C223.897 82.5013 224.094 82.4 224.254 82.304C224.414 82.208 224.564 82.16 224.702 82.16C224.841 82.16 224.958 82.2027 225.054 82.288C225.15 82.3733 225.225 82.4747 225.278 82.592C225.332 82.7093 225.358 82.816 225.358 82.912C225.358 83.072 225.246 83.248 225.022 83.44C224.809 83.632 224.505 83.7973 224.11 83.936C223.716 84.064 223.246 84.128 222.702 84.128ZM220.67 79.616H223.326C223.561 79.616 223.716 79.584 223.79 79.52C223.876 79.456 223.918 79.328 223.918 79.136C223.918 78.8587 223.849 78.6027 223.71 78.368C223.572 78.1227 223.38 77.936 223.134 77.808C222.889 77.6693 222.612 77.6 222.302 77.6C222.004 77.6 221.732 77.664 221.486 77.792C221.241 77.92 221.044 78.096 220.894 78.32C220.745 78.544 220.67 78.8053 220.67 79.104V79.616ZM52.0955 104.128C51.5942 104.128 51.1302 103.979 50.7035 103.68C50.2768 103.381 49.9302 102.992 49.6635 102.512C49.4075 102.021 49.2795 101.499 49.2795 100.944V99.472C49.2795 98.8853 49.4075 98.3573 49.6635 97.888C49.9302 97.408 50.2768 97.0293 50.7035 96.752C51.1302 96.464 51.6048 96.32 52.1275 96.32C52.6395 96.32 53.0715 96.448 53.4235 96.704C53.7755 96.9493 54.0368 97.2267 54.2075 97.536V92.448C54.2075 92.288 54.2928 92.16 54.4635 92.064C54.6342 91.9573 54.8368 91.904 55.0715 91.904C55.3062 91.904 55.4982 91.9573 55.6475 92.064C55.8075 92.16 55.8875 92.288 55.8875 92.448V103.44C55.8875 103.579 55.8075 103.707 55.6475 103.824C55.4982 103.941 55.3062 104 55.0715 104C54.8688 104 54.6875 103.941 54.5275 103.824C54.3782 103.707 54.3035 103.579 54.3035 103.44V102.88C54.1435 103.211 53.8608 103.504 53.4555 103.76C53.0502 104.005 52.5968 104.128 52.0955 104.128ZM52.5755 102.64C52.8848 102.64 53.1622 102.555 53.4075 102.384C53.6528 102.213 53.8448 102.027 53.9835 101.824C54.1328 101.611 54.2075 101.44 54.2075 101.312V99.472C54.2075 99.12 54.1275 98.8213 53.9675 98.576C53.8075 98.3307 53.6048 98.144 53.3595 98.016C53.1142 97.8773 52.8582 97.808 52.5915 97.808C52.2928 97.808 52.0155 97.888 51.7595 98.048C51.5142 98.208 51.3168 98.416 51.1675 98.672C51.0288 98.928 50.9595 99.1947 50.9595 99.472V100.944C50.9595 101.221 51.0288 101.493 51.1675 101.76C51.3168 102.027 51.5142 102.24 51.7595 102.4C52.0048 102.56 52.2768 102.64 52.5755 102.64ZM58.4933 94.512C58.2266 94.512 57.9973 94.4213 57.8053 94.24C57.6133 94.0587 57.5173 93.856 57.5173 93.632C57.5173 93.3867 57.6133 93.1787 57.8053 93.008C57.9973 92.8373 58.2266 92.752 58.4933 92.752C58.7599 92.752 58.9839 92.8373 59.1653 93.008C59.3573 93.1787 59.4533 93.3867 59.4533 93.632C59.4533 93.856 59.3573 94.0587 59.1653 94.24C58.9839 94.4213 58.7599 94.512 58.4933 94.512ZM58.4933 104C58.2479 104 58.0453 103.941 57.8853 103.824C57.7359 103.707 57.6613 103.579 57.6613 103.44V96.96C57.6613 96.8 57.7359 96.672 57.8853 96.576C58.0453 96.4693 58.2479 96.416 58.4933 96.416C58.7279 96.416 58.9253 96.4693 59.0853 96.576C59.2559 96.672 59.3413 96.8 59.3413 96.96V103.44C59.3413 103.579 59.2559 103.707 59.0853 103.824C58.9253 103.941 58.7279 104 58.4933 104ZM63.4031 104.128C62.8805 104.128 62.4111 104.064 61.9951 103.936C61.5791 103.808 61.2485 103.648 61.0031 103.456C60.7685 103.253 60.6511 103.051 60.6511 102.848C60.6511 102.752 60.6725 102.645 60.7151 102.528C60.7685 102.411 60.8378 102.309 60.9231 102.224C61.0191 102.139 61.1205 102.096 61.2271 102.096C61.3658 102.096 61.5098 102.16 61.6591 102.288C61.8191 102.405 62.0271 102.528 62.2831 102.656C62.5391 102.773 62.8965 102.832 63.3551 102.832C63.8885 102.832 64.2458 102.741 64.4271 102.56C64.6191 102.379 64.7151 102.181 64.7151 101.968C64.7151 101.691 64.6191 101.477 64.4271 101.328C64.2458 101.168 64.0058 101.04 63.7071 100.944C63.4191 100.848 63.1098 100.757 62.7791 100.672C62.4485 100.576 62.1338 100.453 61.8351 100.304C61.5471 100.155 61.3071 99.9467 61.1151 99.68C60.9338 99.4133 60.8431 99.0613 60.8431 98.624C60.8431 98.2613 60.9338 97.904 61.1151 97.552C61.2965 97.1893 61.5845 96.896 61.9791 96.672C62.3845 96.4373 62.9231 96.32 63.5951 96.32C64.0005 96.32 64.3845 96.3627 64.7471 96.448C65.1098 96.5333 65.4085 96.6507 65.6431 96.8C65.8778 96.9387 65.9951 97.0933 65.9951 97.264C65.9951 97.3387 65.9685 97.4453 65.9151 97.584C65.8618 97.712 65.7871 97.8293 65.6911 97.936C65.6058 98.032 65.4938 98.08 65.3551 98.08C65.2485 98.08 65.1151 98.0427 64.9551 97.968C64.7951 97.8827 64.6085 97.8027 64.3951 97.728C64.1818 97.6533 63.9205 97.616 63.6111 97.616C63.3018 97.616 63.0511 97.6693 62.8591 97.776C62.6778 97.872 62.5445 97.9893 62.4591 98.128C62.3738 98.2667 62.3311 98.4053 62.3311 98.544C62.3311 98.7787 62.4218 98.96 62.6031 99.088C62.7845 99.216 63.0245 99.3227 63.3231 99.408C63.6218 99.4933 63.9365 99.584 64.2671 99.68C64.5978 99.7653 64.9071 99.8933 65.1951 100.064C65.4938 100.235 65.7338 100.464 65.9151 100.752C66.1071 101.04 66.2031 101.424 66.2031 101.904C66.2031 102.576 65.9578 103.115 65.4671 103.52C64.9871 103.925 64.2991 104.128 63.4031 104.128ZM70.6551 104.128C69.8871 104.128 69.2525 103.989 68.7511 103.712C68.2605 103.435 67.8978 103.056 67.6631 102.576C67.4285 102.096 67.3111 101.552 67.3111 100.944V99.504C67.3111 98.9067 67.4285 98.368 67.6631 97.888C67.8978 97.3973 68.2605 97.0133 68.7511 96.736C69.2418 96.4587 69.8658 96.32 70.6231 96.32C71.1138 96.32 71.5405 96.3787 71.9031 96.496C72.2765 96.6133 72.5645 96.7627 72.7671 96.944C72.9805 97.1147 73.0871 97.296 73.0871 97.488C73.0871 97.584 73.0551 97.7013 72.9911 97.84C72.9378 97.968 72.8578 98.08 72.7511 98.176C72.6551 98.2613 72.5378 98.304 72.3991 98.304C72.2925 98.304 72.1751 98.2613 72.0471 98.176C71.9298 98.0907 71.7698 98.0107 71.5671 97.936C71.3645 97.8507 71.0925 97.808 70.7511 97.808C70.1538 97.808 69.7111 97.9573 69.4231 98.256C69.1351 98.5547 68.9911 98.9707 68.9911 99.504V100.944C68.9911 101.477 69.1351 101.893 69.4231 102.192C69.7111 102.491 70.1591 102.64 70.7671 102.64C71.1191 102.64 71.3965 102.597 71.5991 102.512C71.8018 102.416 71.9618 102.325 72.0791 102.24C72.2071 102.155 72.3298 102.112 72.4471 102.112C72.5965 102.112 72.7245 102.155 72.8311 102.24C72.9485 102.325 73.0338 102.432 73.0871 102.56C73.1511 102.688 73.1831 102.805 73.1831 102.912C73.1831 103.093 73.0711 103.28 72.8471 103.472C72.6338 103.664 72.3351 103.824 71.9511 103.952C71.5778 104.069 71.1458 104.128 70.6551 104.128ZM76.028 104.128C75.4413 104.128 74.94 103.957 74.524 103.616C74.108 103.264 73.9 102.731 73.9 102.016C73.9 101.408 74.06 100.939 74.38 100.608C74.7 100.277 75.1373 100.048 75.692 99.92C76.2573 99.792 76.908 99.728 77.644 99.728H78.348V99.44C78.348 99.1627 78.2947 98.896 78.188 98.64C78.092 98.3733 77.9267 98.1547 77.692 97.984C77.468 97.8027 77.1587 97.712 76.764 97.712C76.3693 97.712 76.0653 97.7493 75.852 97.824C75.6387 97.8987 75.468 97.9787 75.34 98.064C75.212 98.1493 75.0947 98.192 74.988 98.192C74.796 98.192 74.6467 98.1013 74.54 97.92C74.4333 97.728 74.38 97.536 74.38 97.344C74.38 97.152 74.5027 96.9813 74.748 96.832C75.004 96.672 75.3187 96.5493 75.692 96.464C76.0653 96.368 76.4333 96.32 76.796 96.32C77.5853 96.32 78.2147 96.4693 78.684 96.768C79.1533 97.056 79.4947 97.4347 79.708 97.904C79.9213 98.3733 80.028 98.88 80.028 99.424V103.44C80.028 103.589 79.948 103.723 79.788 103.84C79.6387 103.947 79.4467 104 79.212 104C78.9987 104 78.8173 103.947 78.668 103.84C78.5187 103.723 78.444 103.589 78.444 103.44V102.88C78.1667 103.2 77.8307 103.488 77.436 103.744C77.0413 104 76.572 104.128 76.028 104.128ZM76.636 102.848C76.9027 102.848 77.164 102.768 77.42 102.608C77.6867 102.448 77.9053 102.245 78.076 102C78.2573 101.755 78.348 101.504 78.348 101.248V100.656H77.948C77.5427 100.656 77.1587 100.683 76.796 100.736C76.4333 100.779 76.14 100.885 75.916 101.056C75.7027 101.216 75.596 101.467 75.596 101.808C75.596 102.171 75.692 102.437 75.884 102.608C76.0867 102.768 76.3373 102.848 76.636 102.848ZM82.5398 104C82.3051 104 82.1078 103.941 81.9478 103.824C81.7984 103.707 81.7238 103.579 81.7238 103.44V96.96C81.7238 96.8 81.7984 96.672 81.9478 96.576C82.1078 96.4693 82.3051 96.416 82.5398 96.416C82.7531 96.416 82.9344 96.4693 83.0838 96.576C83.2331 96.672 83.3078 96.8 83.3078 96.96V97.664C83.4251 97.44 83.5798 97.2267 83.7718 97.024C83.9744 96.8213 84.2091 96.656 84.4758 96.528C84.7424 96.3893 85.0304 96.32 85.3398 96.32H85.8518C86.0224 96.32 86.1718 96.3947 86.2998 96.544C86.4278 96.6827 86.4918 96.8533 86.4918 97.056C86.4918 97.2587 86.4278 97.4347 86.2998 97.584C86.1718 97.7333 86.0224 97.808 85.8518 97.808H85.3398C85.0198 97.808 84.7104 97.904 84.4118 98.096C84.1131 98.288 83.8678 98.56 83.6758 98.912C83.4944 99.2533 83.4038 99.6693 83.4038 100.16V103.44C83.4038 103.579 83.3184 103.707 83.1478 103.824C82.9878 103.941 82.7851 104 82.5398 104ZM89.7361 104.128C89.2348 104.128 88.7708 103.979 88.3441 103.68C87.9175 103.381 87.5708 102.992 87.3041 102.512C87.0481 102.021 86.9201 101.499 86.9201 100.944V99.472C86.9201 98.8853 87.0481 98.3573 87.3041 97.888C87.5708 97.408 87.9175 97.0293 88.3441 96.752C88.7708 96.464 89.2455 96.32 89.7681 96.32C90.2801 96.32 90.7121 96.448 91.0641 96.704C91.4161 96.9493 91.6775 97.2267 91.8481 97.536V92.448C91.8481 92.288 91.9335 92.16 92.1041 92.064C92.2748 91.9573 92.4775 91.904 92.7121 91.904C92.9468 91.904 93.1388 91.9573 93.2881 92.064C93.4481 92.16 93.5281 92.288 93.5281 92.448V103.44C93.5281 103.579 93.4481 103.707 93.2881 103.824C93.1388 103.941 92.9468 104 92.7121 104C92.5095 104 92.3281 103.941 92.1681 103.824C92.0188 103.707 91.9441 103.579 91.9441 103.44V102.88C91.7841 103.211 91.5015 103.504 91.0961 103.76C90.6908 104.005 90.2375 104.128 89.7361 104.128ZM90.2161 102.64C90.5255 102.64 90.8028 102.555 91.0481 102.384C91.2935 102.213 91.4855 102.027 91.6241 101.824C91.7735 101.611 91.8481 101.44 91.8481 101.312V99.472C91.8481 99.12 91.7681 98.8213 91.6081 98.576C91.4481 98.3307 91.2455 98.144 91.0001 98.016C90.7548 97.8773 90.4988 97.808 90.2321 97.808C89.9335 97.808 89.6561 97.888 89.4001 98.048C89.1548 98.208 88.9575 98.416 88.8081 98.672C88.6695 98.928 88.6001 99.1947 88.6001 99.472V100.944C88.6001 101.221 88.6695 101.493 88.8081 101.76C88.9575 102.027 89.1548 102.24 89.4001 102.4C89.6455 102.56 89.9175 102.64 90.2161 102.64ZM98.7259 104.128C98.0005 104.128 97.3605 103.995 96.8059 103.728C96.2512 103.461 95.8139 103.093 95.4939 102.624C95.1739 102.144 95.0139 101.584 95.0139 100.944V99.424C95.0139 98.8587 95.1632 98.3413 95.4619 97.872C95.7712 97.4027 96.1765 97.0293 96.6779 96.752C97.1792 96.464 97.7339 96.32 98.3419 96.32C98.9179 96.32 99.4459 96.448 99.9259 96.704C100.406 96.9493 100.79 97.296 101.078 97.744C101.377 98.192 101.526 98.704 101.526 99.28C101.526 99.728 101.457 100.048 101.318 100.24C101.179 100.432 100.998 100.549 100.774 100.592C100.55 100.635 100.315 100.656 100.07 100.656H96.6939V101.024C96.6939 101.557 96.8859 101.984 97.2699 102.304C97.6645 102.613 98.1659 102.768 98.7739 102.768C99.1472 102.768 99.4512 102.715 99.6859 102.608C99.9205 102.501 100.118 102.4 100.278 102.304C100.438 102.208 100.587 102.16 100.726 102.16C100.865 102.16 100.982 102.203 101.078 102.288C101.174 102.373 101.249 102.475 101.302 102.592C101.355 102.709 101.382 102.816 101.382 102.912C101.382 103.072 101.27 103.248 101.046 103.44C100.833 103.632 100.529 103.797 100.134 103.936C99.7392 104.064 99.2699 104.128 98.7259 104.128ZM96.6939 99.616H99.3499C99.5845 99.616 99.7392 99.584 99.8139 99.52C99.8992 99.456 99.9419 99.328 99.9419 99.136C99.9419 98.8587 99.8725 98.6027 99.7339 98.368C99.5952 98.1227 99.4032 97.936 99.1579 97.808C98.9125 97.6693 98.6352 97.6 98.3259 97.6C98.0272 97.6 97.7552 97.664 97.5099 97.792C97.2645 97.92 97.0672 98.096 96.9179 98.32C96.7685 98.544 96.6939 98.8053 96.6939 99.104V99.616ZM105.424 104.128C104.922 104.128 104.458 103.979 104.032 103.68C103.605 103.381 103.258 102.992 102.992 102.512C102.736 102.021 102.608 101.499 102.608 100.944V99.472C102.608 98.8853 102.736 98.3573 102.992 97.888C103.258 97.408 103.605 97.0293 104.032 96.752C104.458 96.464 104.933 96.32 105.456 96.32C105.968 96.32 106.4 96.448 106.752 96.704C107.104 96.9493 107.365 97.2267 107.536 97.536V92.448C107.536 92.288 107.621 92.16 107.792 92.064C107.962 91.9573 108.165 91.904 108.4 91.904C108.634 91.904 108.826 91.9573 108.976 92.064C109.136 92.16 109.216 92.288 109.216 92.448V103.44C109.216 103.579 109.136 103.707 108.976 103.824C108.826 103.941 108.634 104 108.4 104C108.197 104 108.016 103.941 107.856 103.824C107.706 103.707 107.632 103.579 107.632 103.44V102.88C107.472 103.211 107.189 103.504 106.784 103.76C106.378 104.005 105.925 104.128 105.424 104.128ZM105.904 102.64C106.213 102.64 106.49 102.555 106.736 102.384C106.981 102.213 107.173 102.027 107.312 101.824C107.461 101.611 107.536 101.44 107.536 101.312V99.472C107.536 99.12 107.456 98.8213 107.296 98.576C107.136 98.3307 106.933 98.144 106.688 98.016C106.442 97.8773 106.186 97.808 105.92 97.808C105.621 97.808 105.344 97.888 105.088 98.048C104.842 98.208 104.645 98.416 104.496 98.672C104.357 98.928 104.288 99.1947 104.288 99.472V100.944C104.288 101.221 104.357 101.493 104.496 101.76C104.645 102.027 104.842 102.24 105.088 102.4C105.333 102.56 105.605 102.64 105.904 102.64ZM115.841 104.128C115.254 104.128 114.753 103.957 114.337 103.616C113.921 103.264 113.713 102.731 113.713 102.016C113.713 101.408 113.873 100.939 114.193 100.608C114.513 100.277 114.95 100.048 115.505 99.92C116.07 99.792 116.721 99.728 117.457 99.728H118.161V99.44C118.161 99.1627 118.107 98.896 118.001 98.64C117.905 98.3733 117.739 98.1547 117.505 97.984C117.281 97.8027 116.971 97.712 116.577 97.712C116.182 97.712 115.878 97.7493 115.664 97.824C115.451 97.8987 115.281 97.9787 115.153 98.064C115.025 98.1493 114.907 98.192 114.801 98.192C114.609 98.192 114.459 98.1013 114.353 97.92C114.246 97.728 114.193 97.536 114.193 97.344C114.193 97.152 114.315 96.9813 114.561 96.832C114.817 96.672 115.131 96.5493 115.505 96.464C115.878 96.368 116.246 96.32 116.609 96.32C117.398 96.32 118.027 96.4693 118.497 96.768C118.966 97.056 119.307 97.4347 119.521 97.904C119.734 98.3733 119.841 98.88 119.841 99.424V103.44C119.841 103.589 119.761 103.723 119.601 103.84C119.451 103.947 119.259 104 119.025 104C118.811 104 118.63 103.947 118.481 103.84C118.331 103.723 118.257 103.589 118.257 103.44V102.88C117.979 103.2 117.643 103.488 117.249 103.744C116.854 104 116.385 104.128 115.841 104.128ZM116.449 102.848C116.715 102.848 116.977 102.768 117.233 102.608C117.499 102.448 117.718 102.245 117.889 102C118.07 101.755 118.161 101.504 118.161 101.248V100.656H117.761C117.355 100.656 116.971 100.683 116.609 100.736C116.246 100.779 115.953 100.885 115.729 101.056C115.515 101.216 115.409 101.467 115.409 101.808C115.409 102.171 115.505 102.437 115.697 102.608C115.899 102.768 116.15 102.848 116.449 102.848ZM123.856 104.128C123.334 104.128 122.864 104.064 122.448 103.936C122.032 103.808 121.702 103.648 121.456 103.456C121.222 103.253 121.104 103.051 121.104 102.848C121.104 102.752 121.126 102.645 121.168 102.528C121.222 102.411 121.291 102.309 121.376 102.224C121.472 102.139 121.574 102.096 121.68 102.096C121.819 102.096 121.963 102.16 122.112 102.288C122.272 102.405 122.48 102.528 122.736 102.656C122.992 102.773 123.35 102.832 123.808 102.832C124.342 102.832 124.699 102.741 124.88 102.56C125.072 102.379 125.168 102.181 125.168 101.968C125.168 101.691 125.072 101.477 124.88 101.328C124.699 101.168 124.459 101.04 124.16 100.944C123.872 100.848 123.563 100.757 123.232 100.672C122.902 100.576 122.587 100.453 122.288 100.304C122 100.155 121.76 99.9467 121.568 99.68C121.387 99.4133 121.296 99.0613 121.296 98.624C121.296 98.2613 121.387 97.904 121.568 97.552C121.75 97.1893 122.038 96.896 122.432 96.672C122.838 96.4373 123.376 96.32 124.048 96.32C124.454 96.32 124.838 96.3627 125.2 96.448C125.563 96.5333 125.862 96.6507 126.096 96.8C126.331 96.9387 126.448 97.0933 126.448 97.264C126.448 97.3387 126.422 97.4453 126.368 97.584C126.315 97.712 126.24 97.8293 126.144 97.936C126.059 98.032 125.947 98.08 125.808 98.08C125.702 98.08 125.568 98.0427 125.408 97.968C125.248 97.8827 125.062 97.8027 124.848 97.728C124.635 97.6533 124.374 97.616 124.064 97.616C123.755 97.616 123.504 97.6693 123.312 97.776C123.131 97.872 122.998 97.9893 122.912 98.128C122.827 98.2667 122.784 98.4053 122.784 98.544C122.784 98.7787 122.875 98.96 123.056 99.088C123.238 99.216 123.478 99.3227 123.776 99.408C124.075 99.4933 124.39 99.584 124.72 99.68C125.051 99.7653 125.36 99.8933 125.648 100.064C125.947 100.235 126.187 100.464 126.368 100.752C126.56 101.04 126.656 101.424 126.656 101.904C126.656 102.576 126.411 103.115 125.92 103.52C125.44 103.925 124.752 104.128 123.856 104.128ZM134.103 107.6C133.485 107.6 132.914 107.509 132.391 107.328C131.869 107.157 131.453 106.907 131.143 106.576C130.834 106.245 130.679 105.851 130.679 105.392C130.679 104.965 130.802 104.608 131.047 104.32C131.293 104.043 131.581 103.829 131.911 103.68C131.698 103.584 131.522 103.456 131.383 103.296C131.245 103.136 131.175 102.912 131.175 102.624C131.175 102.325 131.25 102.085 131.399 101.904C131.549 101.723 131.741 101.557 131.975 101.408C131.677 101.173 131.442 100.885 131.271 100.544C131.111 100.192 131.031 99.808 131.031 99.392V98.944C131.031 98.432 131.154 97.9787 131.399 97.584C131.645 97.1893 131.991 96.88 132.439 96.656C132.898 96.432 133.421 96.32 134.007 96.32C134.37 96.32 134.706 96.368 135.015 96.464C135.335 96.56 135.618 96.6933 135.863 96.864C136.034 96.4693 136.205 96.192 136.375 96.032C136.557 95.872 136.727 95.792 136.887 95.792C137.111 95.792 137.282 95.856 137.399 95.984C137.517 96.112 137.575 96.24 137.575 96.368C137.575 96.4533 137.549 96.5333 137.495 96.608C137.453 96.672 137.389 96.7253 137.303 96.768C137.197 96.8213 137.069 96.896 136.919 96.992C136.781 97.0773 136.642 97.216 136.503 97.408C136.685 97.6107 136.818 97.8453 136.903 98.112C136.989 98.3787 137.031 98.656 137.031 98.944V99.392C137.031 99.8933 136.903 100.347 136.647 100.752C136.391 101.157 136.034 101.477 135.575 101.712C135.117 101.936 134.594 102.048 134.007 102.048C133.591 102.048 133.223 101.984 132.903 101.856C132.818 101.909 132.743 101.973 132.679 102.048C132.626 102.112 132.599 102.197 132.599 102.304C132.599 102.496 132.717 102.635 132.951 102.72C133.186 102.805 133.485 102.869 133.847 102.912C134.221 102.955 134.615 103.008 135.031 103.072C135.447 103.136 135.837 103.243 136.199 103.392C136.573 103.531 136.877 103.739 137.111 104.016C137.346 104.304 137.463 104.693 137.463 105.184C137.463 105.739 137.309 106.192 136.999 106.544C136.69 106.907 136.279 107.173 135.767 107.344C135.266 107.515 134.711 107.6 134.103 107.6ZM134.071 106.48C134.594 106.48 135.015 106.363 135.335 106.128C135.666 105.904 135.831 105.605 135.831 105.232C135.831 104.965 135.751 104.757 135.591 104.608C135.431 104.459 135.223 104.347 134.967 104.272C134.711 104.197 134.439 104.144 134.151 104.112C133.874 104.08 133.607 104.048 133.351 104.016C133.053 104.123 132.797 104.272 132.583 104.464C132.381 104.667 132.279 104.917 132.279 105.216C132.279 105.611 132.445 105.92 132.775 106.144C133.117 106.368 133.549 106.48 134.071 106.48ZM134.039 100.976C134.466 100.976 134.797 100.827 135.031 100.528C135.277 100.229 135.399 99.8507 135.399 99.392V98.944C135.399 98.5067 135.277 98.1387 135.031 97.84C134.797 97.5413 134.461 97.392 134.023 97.392C133.586 97.392 133.25 97.5413 133.015 97.84C132.781 98.1387 132.663 98.5067 132.663 98.944V99.376C132.663 99.824 132.781 100.203 133.015 100.512C133.25 100.821 133.591 100.976 134.039 100.976ZM142.07 104.128C141.344 104.128 140.704 103.995 140.15 103.728C139.595 103.461 139.158 103.093 138.838 102.624C138.518 102.144 138.358 101.584 138.358 100.944V99.424C138.358 98.8587 138.507 98.3413 138.806 97.872C139.115 97.4027 139.52 97.0293 140.022 96.752C140.523 96.464 141.078 96.32 141.686 96.32C142.262 96.32 142.79 96.448 143.27 96.704C143.75 96.9493 144.134 97.296 144.422 97.744C144.72 98.192 144.87 98.704 144.87 99.28C144.87 99.728 144.8 100.048 144.662 100.24C144.523 100.432 144.342 100.549 144.118 100.592C143.894 100.635 143.659 100.656 143.414 100.656H140.038V101.024C140.038 101.557 140.23 101.984 140.614 102.304C141.008 102.613 141.51 102.768 142.118 102.768C142.491 102.768 142.795 102.715 143.03 102.608C143.264 102.501 143.462 102.4 143.622 102.304C143.782 102.208 143.931 102.16 144.07 102.16C144.208 102.16 144.326 102.203 144.422 102.288C144.518 102.373 144.592 102.475 144.646 102.592C144.699 102.709 144.726 102.816 144.726 102.912C144.726 103.072 144.614 103.248 144.39 103.44C144.176 103.632 143.872 103.797 143.478 103.936C143.083 104.064 142.614 104.128 142.07 104.128ZM140.038 99.616H142.694C142.928 99.616 143.083 99.584 143.158 99.52C143.243 99.456 143.286 99.328 143.286 99.136C143.286 98.8587 143.216 98.6027 143.078 98.368C142.939 98.1227 142.747 97.936 142.502 97.808C142.256 97.6693 141.979 97.6 141.67 97.6C141.371 97.6 141.099 97.664 140.854 97.792C140.608 97.92 140.411 98.096 140.262 98.32C140.112 98.544 140.038 98.8053 140.038 99.104V99.616ZM147.071 104C146.826 104 146.623 103.941 146.463 103.824C146.314 103.707 146.239 103.579 146.239 103.44V96.96C146.239 96.8 146.314 96.672 146.463 96.576C146.623 96.4693 146.826 96.416 147.071 96.416C147.274 96.416 147.45 96.4693 147.599 96.576C147.749 96.672 147.823 96.8 147.823 96.96V97.536C147.983 97.2267 148.245 96.9493 148.607 96.704C148.981 96.448 149.434 96.32 149.967 96.32C150.469 96.32 150.927 96.464 151.343 96.752C151.77 97.0293 152.111 97.408 152.367 97.888C152.623 98.3573 152.751 98.8853 152.751 99.472V103.44C152.751 103.621 152.661 103.76 152.479 103.856C152.309 103.952 152.117 104 151.903 104C151.711 104 151.525 103.952 151.343 103.856C151.162 103.76 151.071 103.621 151.071 103.44V99.472C151.071 99.1947 150.997 98.928 150.847 98.672C150.709 98.416 150.517 98.208 150.271 98.048C150.026 97.888 149.754 97.808 149.455 97.808C149.199 97.808 148.954 97.8773 148.719 98.016C148.485 98.144 148.293 98.3307 148.143 98.576C147.994 98.8213 147.919 99.12 147.919 99.472V103.44C147.919 103.579 147.834 103.707 147.663 103.824C147.503 103.941 147.306 104 147.071 104ZM157.851 104.128C157.126 104.128 156.486 103.995 155.931 103.728C155.376 103.461 154.939 103.093 154.619 102.624C154.299 102.144 154.139 101.584 154.139 100.944V99.424C154.139 98.8587 154.288 98.3413 154.587 97.872C154.896 97.4027 155.302 97.0293 155.803 96.752C156.304 96.464 156.859 96.32 157.467 96.32C158.043 96.32 158.571 96.448 159.051 96.704C159.531 96.9493 159.915 97.296 160.203 97.744C160.502 98.192 160.651 98.704 160.651 99.28C160.651 99.728 160.582 100.048 160.443 100.24C160.304 100.432 160.123 100.549 159.899 100.592C159.675 100.635 159.44 100.656 159.195 100.656H155.819V101.024C155.819 101.557 156.011 101.984 156.395 102.304C156.79 102.613 157.291 102.768 157.899 102.768C158.272 102.768 158.576 102.715 158.811 102.608C159.046 102.501 159.243 102.4 159.403 102.304C159.563 102.208 159.712 102.16 159.851 102.16C159.99 102.16 160.107 102.203 160.203 102.288C160.299 102.373 160.374 102.475 160.427 102.592C160.48 102.709 160.507 102.816 160.507 102.912C160.507 103.072 160.395 103.248 160.171 103.44C159.958 103.632 159.654 103.797 159.259 103.936C158.864 104.064 158.395 104.128 157.851 104.128ZM155.819 99.616H158.475C158.71 99.616 158.864 99.584 158.939 99.52C159.024 99.456 159.067 99.328 159.067 99.136C159.067 98.8587 158.998 98.6027 158.859 98.368C158.72 98.1227 158.528 97.936 158.283 97.808C158.038 97.6693 157.76 97.6 157.451 97.6C157.152 97.6 156.88 97.664 156.635 97.792C156.39 97.92 156.192 98.096 156.043 98.32C155.894 98.544 155.819 98.8053 155.819 99.104V99.616ZM162.837 104C162.602 104 162.405 103.941 162.245 103.824C162.095 103.707 162.021 103.579 162.021 103.44V96.96C162.021 96.8 162.095 96.672 162.245 96.576C162.405 96.4693 162.602 96.416 162.837 96.416C163.05 96.416 163.231 96.4693 163.381 96.576C163.53 96.672 163.605 96.8 163.605 96.96V97.664C163.722 97.44 163.877 97.2267 164.069 97.024C164.271 96.8213 164.506 96.656 164.773 96.528C165.039 96.3893 165.327 96.32 165.637 96.32H166.149C166.319 96.32 166.469 96.3947 166.597 96.544C166.725 96.6827 166.789 96.8533 166.789 97.056C166.789 97.2587 166.725 97.4347 166.597 97.584C166.469 97.7333 166.319 97.808 166.149 97.808H165.637C165.317 97.808 165.007 97.904 164.709 98.096C164.41 98.288 164.165 98.56 163.973 98.912C163.791 99.2533 163.701 99.6693 163.701 100.16V103.44C163.701 103.579 163.615 103.707 163.445 103.824C163.285 103.941 163.082 104 162.837 104ZM169.2 104.128C168.613 104.128 168.112 103.957 167.696 103.616C167.28 103.264 167.072 102.731 167.072 102.016C167.072 101.408 167.232 100.939 167.552 100.608C167.872 100.277 168.309 100.048 168.864 99.92C169.429 99.792 170.08 99.728 170.816 99.728H171.52V99.44C171.52 99.1627 171.467 98.896 171.36 98.64C171.264 98.3733 171.099 98.1547 170.864 97.984C170.64 97.8027 170.331 97.712 169.936 97.712C169.541 97.712 169.237 97.7493 169.024 97.824C168.811 97.8987 168.64 97.9787 168.512 98.064C168.384 98.1493 168.267 98.192 168.16 98.192C167.968 98.192 167.819 98.1013 167.712 97.92C167.605 97.728 167.552 97.536 167.552 97.344C167.552 97.152 167.675 96.9813 167.92 96.832C168.176 96.672 168.491 96.5493 168.864 96.464C169.237 96.368 169.605 96.32 169.968 96.32C170.757 96.32 171.387 96.4693 171.856 96.768C172.325 97.056 172.667 97.4347 172.88 97.904C173.093 98.3733 173.2 98.88 173.2 99.424V103.44C173.2 103.589 173.12 103.723 172.96 103.84C172.811 103.947 172.619 104 172.384 104C172.171 104 171.989 103.947 171.84 103.84C171.691 103.723 171.616 103.589 171.616 103.44V102.88C171.339 103.2 171.003 103.488 170.608 103.744C170.213 104 169.744 104.128 169.2 104.128ZM169.808 102.848C170.075 102.848 170.336 102.768 170.592 102.608C170.859 102.448 171.077 102.245 171.248 102C171.429 101.755 171.52 101.504 171.52 101.248V100.656H171.12C170.715 100.656 170.331 100.683 169.968 100.736C169.605 100.779 169.312 100.885 169.088 101.056C168.875 101.216 168.768 101.467 168.768 101.808C168.768 102.171 168.864 102.437 169.056 102.608C169.259 102.768 169.509 102.848 169.808 102.848ZM175.872 104C175.626 104 175.424 103.941 175.264 103.824C175.114 103.707 175.04 103.579 175.04 103.44V92.448C175.04 92.288 175.114 92.16 175.264 92.064C175.424 91.9573 175.626 91.904 175.872 91.904C176.106 91.904 176.304 91.9573 176.464 92.064C176.634 92.16 176.72 92.288 176.72 92.448V103.44C176.72 103.579 176.634 103.707 176.464 103.824C176.304 103.941 176.106 104 175.872 104ZM184.298 104.16C184.148 104.16 184.015 104.133 183.898 104.08C183.78 104.027 183.695 103.931 183.642 103.792L181.162 97.328C181.14 97.2747 181.119 97.2267 181.098 97.184C181.087 97.1307 181.082 97.088 181.082 97.056C181.082 96.9173 181.14 96.8 181.258 96.704C181.375 96.5973 181.514 96.512 181.674 96.448C181.844 96.384 182.004 96.352 182.154 96.352C182.271 96.352 182.378 96.3787 182.474 96.432C182.57 96.4747 182.634 96.5493 182.666 96.656L184.442 101.632L185.802 97.216C185.855 97.056 185.935 96.9547 186.042 96.912C186.148 96.8693 186.266 96.848 186.394 96.848C186.532 96.848 186.655 96.8693 186.762 96.912C186.868 96.9547 186.948 97.056 187.002 97.216L188.33 101.664L190.122 96.656C190.186 96.4533 190.351 96.352 190.618 96.352C190.767 96.352 190.922 96.384 191.082 96.448C191.252 96.5013 191.396 96.5813 191.514 96.688C191.631 96.7947 191.69 96.9227 191.69 97.072C191.69 97.104 191.684 97.1467 191.674 97.2C191.663 97.2533 191.647 97.296 191.626 97.328L189.146 103.824C189.103 103.952 189.018 104.037 188.89 104.08C188.772 104.133 188.639 104.16 188.49 104.16C188.319 104.16 188.17 104.133 188.042 104.08C187.924 104.027 187.844 103.947 187.802 103.84L186.394 99.712L185.018 103.792C184.975 103.92 184.884 104.011 184.746 104.064C184.618 104.128 184.468 104.16 184.298 104.16ZM194.372 104.128C193.785 104.128 193.284 103.957 192.868 103.616C192.452 103.264 192.244 102.731 192.244 102.016C192.244 101.408 192.404 100.939 192.724 100.608C193.044 100.277 193.481 100.048 194.036 99.92C194.601 99.792 195.252 99.728 195.988 99.728H196.692V99.44C196.692 99.1627 196.638 98.896 196.532 98.64C196.436 98.3733 196.27 98.1547 196.036 97.984C195.812 97.8027 195.502 97.712 195.108 97.712C194.713 97.712 194.409 97.7493 194.196 97.824C193.982 97.8987 193.812 97.9787 193.684 98.064C193.556 98.1493 193.438 98.192 193.332 98.192C193.14 98.192 192.99 98.1013 192.884 97.92C192.777 97.728 192.724 97.536 192.724 97.344C192.724 97.152 192.846 96.9813 193.092 96.832C193.348 96.672 193.662 96.5493 194.036 96.464C194.409 96.368 194.777 96.32 195.14 96.32C195.929 96.32 196.558 96.4693 197.028 96.768C197.497 97.056 197.838 97.4347 198.052 97.904C198.265 98.3733 198.372 98.88 198.372 99.424V103.44C198.372 103.589 198.292 103.723 198.132 103.84C197.982 103.947 197.79 104 197.556 104C197.342 104 197.161 103.947 197.012 103.84C196.862 103.723 196.788 103.589 196.788 103.44V102.88C196.51 103.2 196.174 103.488 195.78 103.744C195.385 104 194.916 104.128 194.372 104.128ZM194.98 102.848C195.246 102.848 195.508 102.768 195.764 102.608C196.03 102.448 196.249 102.245 196.42 102C196.601 101.755 196.692 101.504 196.692 101.248V100.656H196.292C195.886 100.656 195.502 100.683 195.14 100.736C194.777 100.779 194.484 100.885 194.26 101.056C194.046 101.216 193.94 101.467 193.94 101.808C193.94 102.171 194.036 102.437 194.228 102.608C194.43 102.768 194.681 102.848 194.98 102.848ZM202.388 104.128C201.865 104.128 201.396 104.064 200.98 103.936C200.564 103.808 200.233 103.648 199.988 103.456C199.753 103.253 199.636 103.051 199.636 102.848C199.636 102.752 199.657 102.645 199.7 102.528C199.753 102.411 199.822 102.309 199.908 102.224C200.004 102.139 200.105 102.096 200.212 102.096C200.35 102.096 200.494 102.16 200.644 102.288C200.804 102.405 201.012 102.528 201.268 102.656C201.524 102.773 201.881 102.832 202.34 102.832C202.873 102.832 203.23 102.741 203.411 102.56C203.604 102.379 203.7 102.181 203.7 101.968C203.7 101.691 203.604 101.477 203.411 101.328C203.23 101.168 202.99 101.04 202.692 100.944C202.404 100.848 202.094 100.757 201.764 100.672C201.433 100.576 201.118 100.453 200.82 100.304C200.532 100.155 200.292 99.9467 200.1 99.68C199.918 99.4133 199.828 99.0613 199.828 98.624C199.828 98.2613 199.918 97.904 200.1 97.552C200.281 97.1893 200.569 96.896 200.964 96.672C201.369 96.4373 201.908 96.32 202.58 96.32C202.985 96.32 203.369 96.3627 203.732 96.448C204.094 96.5333 204.393 96.6507 204.628 96.8C204.862 96.9387 204.98 97.0933 204.98 97.264C204.98 97.3387 204.953 97.4453 204.9 97.584C204.846 97.712 204.772 97.8293 204.676 97.936C204.59 98.032 204.478 98.08 204.34 98.08C204.233 98.08 204.1 98.0427 203.94 97.968C203.78 97.8827 203.593 97.8027 203.38 97.728C203.166 97.6533 202.905 97.616 202.596 97.616C202.286 97.616 202.036 97.6693 201.844 97.776C201.662 97.872 201.529 97.9893 201.444 98.128C201.358 98.2667 201.316 98.4053 201.316 98.544C201.316 98.7787 201.406 98.96 201.588 99.088C201.769 99.216 202.009 99.3227 202.308 99.408C202.606 99.4933 202.921 99.584 203.252 99.68C203.582 99.7653 203.892 99.8933 204.18 100.064C204.478 100.235 204.718 100.464 204.9 100.752C205.092 101.04 205.188 101.424 205.188 101.904C205.188 102.576 204.942 103.115 204.452 103.52C203.972 103.925 203.284 104.128 202.388 104.128ZM209.336 104C208.429 104 207.736 103.803 207.256 103.408C206.776 103.003 206.536 102.368 206.536 101.504V93.488C206.536 93.328 206.621 93.2 206.792 93.104C206.973 92.9973 207.165 92.944 207.368 92.944C207.57 92.944 207.762 92.9973 207.944 93.104C208.125 93.2 208.216 93.328 208.216 93.488V96.416H210.168C210.317 96.416 210.429 96.48 210.504 96.608C210.589 96.736 210.632 96.88 210.632 97.04C210.632 97.2 210.589 97.344 210.504 97.472C210.429 97.6 210.317 97.664 210.168 97.664H208.216V101.504C208.216 101.888 208.296 102.16 208.456 102.32C208.626 102.48 208.92 102.56 209.336 102.56H209.88C210.125 102.56 210.306 102.635 210.424 102.784C210.552 102.923 210.616 103.088 210.616 103.28C210.616 103.461 210.552 103.627 210.424 103.776C210.306 103.925 210.125 104 209.88 104H209.336ZM215.101 104.128C214.376 104.128 213.736 103.995 213.181 103.728C212.626 103.461 212.189 103.093 211.869 102.624C211.549 102.144 211.389 101.584 211.389 100.944V99.424C211.389 98.8587 211.538 98.3413 211.837 97.872C212.146 97.4027 212.552 97.0293 213.053 96.752C213.554 96.464 214.109 96.32 214.717 96.32C215.293 96.32 215.821 96.448 216.301 96.704C216.781 96.9493 217.165 97.296 217.453 97.744C217.752 98.192 217.901 98.704 217.901 99.28C217.901 99.728 217.832 100.048 217.693 100.24C217.554 100.432 217.373 100.549 217.149 100.592C216.925 100.635 216.69 100.656 216.445 100.656H213.069V101.024C213.069 101.557 213.261 101.984 213.645 102.304C214.04 102.613 214.541 102.768 215.149 102.768C215.522 102.768 215.826 102.715 216.061 102.608C216.296 102.501 216.493 102.4 216.653 102.304C216.813 102.208 216.962 102.16 217.101 102.16C217.24 102.16 217.357 102.203 217.453 102.288C217.549 102.373 217.624 102.475 217.677 102.592C217.73 102.709 217.757 102.816 217.757 102.912C217.757 103.072 217.645 103.248 217.421 103.44C217.208 103.632 216.904 103.797 216.509 103.936C216.114 104.064 215.645 104.128 215.101 104.128ZM213.069 99.616H215.725C215.96 99.616 216.114 99.584 216.189 99.52C216.274 99.456 216.317 99.328 216.317 99.136C216.317 98.8587 216.248 98.6027 216.109 98.368C215.97 98.1227 215.778 97.936 215.533 97.808C215.288 97.6693 215.01 97.6 214.701 97.6C214.402 97.6 214.13 97.664 213.885 97.792C213.64 97.92 213.442 98.096 213.293 98.32C213.144 98.544 213.069 98.8053 213.069 99.104V99.616ZM219.863 104.096C219.585 104.096 219.356 104 219.175 103.808C218.993 103.616 218.903 103.392 218.903 103.136C218.903 102.869 218.993 102.645 219.175 102.464C219.356 102.272 219.585 102.176 219.863 102.176C220.119 102.176 220.337 102.272 220.519 102.464C220.711 102.645 220.807 102.869 220.807 103.136C220.807 103.392 220.711 103.616 220.519 103.808C220.337 104 220.119 104.096 219.863 104.096ZM43.7533 124C43.5293 124 43.348 123.947 43.2093 123.84C43.0706 123.733 43.0013 123.605 43.0013 123.456V112.848C43.0013 112.699 43.0706 112.571 43.2093 112.464C43.348 112.357 43.5293 112.304 43.7533 112.304H46.5853C47.2573 112.304 47.8653 112.421 48.4093 112.656C48.964 112.891 49.396 113.269 49.7053 113.792C50.0253 114.315 50.1853 115.008 50.1853 115.872V120.432C50.1853 121.296 50.0253 121.989 49.7053 122.512C49.396 123.035 48.964 123.413 48.4093 123.648C47.8653 123.883 47.2573 124 46.5853 124H43.7533ZM44.6973 122.496H46.5853C47.1826 122.496 47.6466 122.331 47.9773 122C48.3186 121.659 48.4893 121.136 48.4893 120.432V115.872C48.4893 115.168 48.3186 114.651 47.9773 114.32C47.6466 113.979 47.1826 113.808 46.5853 113.808H44.6973V122.496ZM54.9892 124.128C54.4132 124.128 53.8745 123.979 53.3732 123.68C52.8719 123.381 52.4665 122.992 52.1572 122.512C51.8585 122.021 51.7092 121.499 51.7092 120.944V119.472C51.7092 118.907 51.8532 118.384 52.1412 117.904C52.4399 117.424 52.8399 117.04 53.3412 116.752C53.8532 116.464 54.4079 116.32 55.0052 116.32C55.6025 116.32 56.1519 116.464 56.6532 116.752C57.1545 117.029 57.5545 117.408 57.8532 117.888C58.1625 118.357 58.3172 118.885 58.3172 119.472V120.944C58.3172 121.488 58.1625 122.005 57.8532 122.496C57.5545 122.987 57.1492 123.381 56.6372 123.68C56.1359 123.979 55.5865 124.128 54.9892 124.128ZM55.0052 122.64C55.3039 122.64 55.5759 122.56 55.8212 122.4C56.0665 122.24 56.2639 122.032 56.4132 121.776C56.5625 121.509 56.6372 121.232 56.6372 120.944V119.472C56.6372 119.195 56.5625 118.928 56.4132 118.672C56.2639 118.416 56.0665 118.208 55.8212 118.048C55.5759 117.888 55.3039 117.808 55.0052 117.808C54.6959 117.808 54.4185 117.888 54.1732 118.048C53.9385 118.208 53.7465 118.416 53.5972 118.672C53.4585 118.928 53.3892 119.195 53.3892 119.472V120.944C53.3892 121.232 53.4585 121.509 53.5972 121.776C53.7465 122.032 53.9439 122.24 54.1892 122.4C54.4345 122.56 54.7065 122.64 55.0052 122.64ZM60.6104 124C60.3651 124 60.1624 123.941 60.0024 123.824C59.8531 123.707 59.7784 123.579 59.7784 123.44V116.96C59.7784 116.8 59.8531 116.672 60.0024 116.576C60.1624 116.469 60.3651 116.416 60.6104 116.416C60.8131 116.416 60.9891 116.469 61.1384 116.576C61.2878 116.672 61.3624 116.8 61.3624 116.96V117.536C61.5224 117.227 61.7838 116.949 62.1464 116.704C62.5198 116.448 62.9731 116.32 63.5064 116.32C64.0078 116.32 64.4664 116.464 64.8824 116.752C65.3091 117.029 65.6504 117.408 65.9064 117.888C66.1624 118.357 66.2904 118.885 66.2904 119.472V123.44C66.2904 123.621 66.1998 123.76 66.0184 123.856C65.8478 123.952 65.6558 124 65.4424 124C65.2504 124 65.0638 123.952 64.8824 123.856C64.7011 123.76 64.6104 123.621 64.6104 123.44V119.472C64.6104 119.195 64.5358 118.928 64.3864 118.672C64.2478 118.416 64.0558 118.208 63.8104 118.048C63.5651 117.888 63.2931 117.808 62.9944 117.808C62.7384 117.808 62.4931 117.877 62.2584 118.016C62.0238 118.144 61.8318 118.331 61.6824 118.576C61.5331 118.821 61.4584 119.12 61.4584 119.472V123.44C61.4584 123.579 61.3731 123.707 61.2024 123.824C61.0424 123.941 60.8451 124 60.6104 124ZM69.6139 124.128C69.0273 124.128 68.5259 123.957 68.1099 123.616C67.6939 123.264 67.4859 122.731 67.4859 122.016C67.4859 121.408 67.6459 120.939 67.9659 120.608C68.2859 120.277 68.7233 120.048 69.2779 119.92C69.8433 119.792 70.4939 119.728 71.2299 119.728H71.9339V119.44C71.9339 119.163 71.8806 118.896 71.7739 118.64C71.6779 118.373 71.5126 118.155 71.2779 117.984C71.0539 117.803 70.7446 117.712 70.3499 117.712C69.9553 117.712 69.6513 117.749 69.4379 117.824C69.2246 117.899 69.0539 117.979 68.9259 118.064C68.7979 118.149 68.6806 118.192 68.5739 118.192C68.3819 118.192 68.2326 118.101 68.1259 117.92C68.0193 117.728 67.9659 117.536 67.9659 117.344C67.9659 117.152 68.0886 116.981 68.3339 116.832C68.5899 116.672 68.9046 116.549 69.2779 116.464C69.6513 116.368 70.0193 116.32 70.3819 116.32C71.1713 116.32 71.8006 116.469 72.2699 116.768C72.7393 117.056 73.0806 117.435 73.2939 117.904C73.5073 118.373 73.6139 118.88 73.6139 119.424V123.44C73.6139 123.589 73.5339 123.723 73.3739 123.84C73.2246 123.947 73.0326 124 72.7979 124C72.5846 124 72.4033 123.947 72.2539 123.84C72.1046 123.723 72.0299 123.589 72.0299 123.44V122.88C71.7526 123.2 71.4166 123.488 71.0219 123.744C70.6273 124 70.1579 124.128 69.6139 124.128ZM70.2219 122.848C70.4886 122.848 70.7499 122.768 71.0059 122.608C71.2726 122.448 71.4913 122.245 71.6619 122C71.8433 121.755 71.9339 121.504 71.9339 121.248V120.656H71.5339C71.1286 120.656 70.7446 120.683 70.3819 120.736C70.0193 120.779 69.7259 120.885 69.5019 121.056C69.2886 121.216 69.1819 121.467 69.1819 121.808C69.1819 122.171 69.2779 122.437 69.4699 122.608C69.6726 122.768 69.9233 122.848 70.2219 122.848ZM78.0777 124C77.171 124 76.4777 123.803 75.9977 123.408C75.5177 123.003 75.2777 122.368 75.2777 121.504V113.488C75.2777 113.328 75.363 113.2 75.5337 113.104C75.715 112.997 75.907 112.944 76.1097 112.944C76.3124 112.944 76.5044 112.997 76.6857 113.104C76.867 113.2 76.9577 113.328 76.9577 113.488V116.416H78.9097C79.059 116.416 79.171 116.48 79.2457 116.608C79.331 116.736 79.3737 116.88 79.3737 117.04C79.3737 117.2 79.331 117.344 79.2457 117.472C79.171 117.6 79.059 117.664 78.9097 117.664H76.9577V121.504C76.9577 121.888 77.0377 122.16 77.1977 122.32C77.3684 122.48 77.6617 122.56 78.0777 122.56H78.6217C78.867 122.56 79.0484 122.635 79.1657 122.784C79.2937 122.923 79.3577 123.088 79.3577 123.28C79.3577 123.461 79.2937 123.627 79.1657 123.776C79.0484 123.925 78.867 124 78.6217 124H78.0777ZM83.8431 124.128C83.1177 124.128 82.4777 123.995 81.9231 123.728C81.3684 123.461 80.9311 123.093 80.6111 122.624C80.2911 122.144 80.1311 121.584 80.1311 120.944V119.424C80.1311 118.859 80.2804 118.341 80.5791 117.872C80.8884 117.403 81.2937 117.029 81.7951 116.752C82.2964 116.464 82.8511 116.32 83.4591 116.32C84.0351 116.32 84.5631 116.448 85.0431 116.704C85.5231 116.949 85.9071 117.296 86.1951 117.744C86.4937 118.192 86.6431 118.704 86.6431 119.28C86.6431 119.728 86.5737 120.048 86.4351 120.24C86.2964 120.432 86.1151 120.549 85.8911 120.592C85.6671 120.635 85.4324 120.656 85.1871 120.656H81.8111V121.024C81.8111 121.557 82.0031 121.984 82.3871 122.304C82.7817 122.613 83.2831 122.768 83.8911 122.768C84.2644 122.768 84.5684 122.715 84.8031 122.608C85.0377 122.501 85.2351 122.4 85.3951 122.304C85.5551 122.208 85.7044 122.16 85.8431 122.16C85.9817 122.16 86.0991 122.203 86.1951 122.288C86.2911 122.373 86.3657 122.475 86.4191 122.592C86.4724 122.709 86.4991 122.816 86.4991 122.912C86.4991 123.072 86.3871 123.248 86.1631 123.44C85.9497 123.632 85.6457 123.797 85.2511 123.936C84.8564 124.064 84.3871 124.128 83.8431 124.128ZM81.8111 119.616H84.4671C84.7017 119.616 84.8564 119.584 84.9311 119.52C85.0164 119.456 85.0591 119.328 85.0591 119.136C85.0591 118.859 84.9897 118.603 84.8511 118.368C84.7124 118.123 84.5204 117.936 84.2751 117.808C84.0297 117.669 83.7524 117.6 83.4431 117.6C83.1444 117.6 82.8724 117.664 82.6271 117.792C82.3817 117.92 82.1844 118.096 82.0351 118.32C81.8857 118.544 81.8111 118.805 81.8111 119.104V119.616ZM93.9839 124C93.0773 124 92.3839 123.803 91.9039 123.408C91.4239 123.003 91.1839 122.368 91.1839 121.504V113.488C91.1839 113.328 91.2693 113.2 91.4399 113.104C91.6213 112.997 91.8133 112.944 92.0159 112.944C92.2186 112.944 92.4106 112.997 92.5919 113.104C92.7733 113.2 92.8639 113.328 92.8639 113.488V116.416H94.8159C94.9653 116.416 95.0773 116.48 95.1519 116.608C95.2373 116.736 95.2799 116.88 95.2799 117.04C95.2799 117.2 95.2373 117.344 95.1519 117.472C95.0773 117.6 94.9653 117.664 94.8159 117.664H92.8639V121.504C92.8639 121.888 92.9439 122.16 93.1039 122.32C93.2746 122.48 93.5679 122.56 93.9839 122.56H94.5279C94.7733 122.56 94.9546 122.635 95.0719 122.784C95.1999 122.923 95.2639 123.088 95.2639 123.28C95.2639 123.461 95.1999 123.627 95.0719 123.776C94.9546 123.925 94.7733 124 94.5279 124H93.9839ZM99.3173 124.128C98.7413 124.128 98.2026 123.979 97.7013 123.68C97.2 123.381 96.7946 122.992 96.4853 122.512C96.1866 122.021 96.0373 121.499 96.0373 120.944V119.472C96.0373 118.907 96.1813 118.384 96.4693 117.904C96.768 117.424 97.168 117.04 97.6693 116.752C98.1813 116.464 98.736 116.32 99.3333 116.32C99.9306 116.32 100.48 116.464 100.981 116.752C101.483 117.029 101.883 117.408 102.181 117.888C102.491 118.357 102.645 118.885 102.645 119.472V120.944C102.645 121.488 102.491 122.005 102.181 122.496C101.883 122.987 101.477 123.381 100.965 123.68C100.464 123.979 99.9146 124.128 99.3173 124.128ZM99.3333 122.64C99.632 122.64 99.904 122.56 100.149 122.4C100.395 122.24 100.592 122.032 100.741 121.776C100.891 121.509 100.965 121.232 100.965 120.944V119.472C100.965 119.195 100.891 118.928 100.741 118.672C100.592 118.416 100.395 118.208 100.149 118.048C99.904 117.888 99.632 117.808 99.3333 117.808C99.024 117.808 98.7466 117.888 98.5013 118.048C98.2666 118.208 98.0746 118.416 97.9253 118.672C97.7866 118.928 97.7173 119.195 97.7173 119.472V120.944C97.7173 121.232 97.7866 121.509 97.9253 121.776C98.0746 122.032 98.272 122.24 98.5173 122.4C98.7626 122.56 99.0346 122.64 99.3333 122.64ZM104.107 127.6C103.894 127.6 103.713 127.552 103.563 127.456C103.414 127.371 103.339 127.179 103.339 126.88C103.339 126.688 103.371 126.517 103.435 126.368C103.499 126.229 103.617 126.16 103.787 126.16C103.99 126.16 104.209 126.107 104.443 126C104.689 125.904 104.923 125.744 105.147 125.52C105.382 125.307 105.579 125.035 105.739 124.704C105.91 124.373 106.027 123.984 106.091 123.536L103.387 117.328C103.345 117.253 103.323 117.179 103.323 117.104C103.323 116.965 103.382 116.837 103.499 116.72C103.627 116.592 103.777 116.491 103.947 116.416C104.118 116.341 104.278 116.304 104.427 116.304C104.534 116.304 104.635 116.331 104.731 116.384C104.838 116.427 104.907 116.501 104.939 116.608L106.955 121.808L108.699 116.608C108.731 116.501 108.795 116.427 108.891 116.384C108.987 116.331 109.083 116.304 109.179 116.304C109.307 116.304 109.457 116.341 109.627 116.416C109.809 116.491 109.963 116.592 110.091 116.72C110.23 116.837 110.299 116.976 110.299 117.136C110.299 117.221 110.283 117.285 110.251 117.328L107.851 123.584C107.681 124.043 107.505 124.507 107.323 124.976C107.142 125.456 106.918 125.893 106.651 126.288C106.395 126.683 106.059 126.997 105.643 127.232C105.238 127.477 104.726 127.6 104.107 127.6ZM113.661 124.128C113.138 124.128 112.669 124.064 112.253 123.936C111.837 123.808 111.506 123.648 111.261 123.456C111.026 123.253 110.909 123.051 110.909 122.848C110.909 122.752 110.93 122.645 110.973 122.528C111.026 122.411 111.096 122.309 111.181 122.224C111.277 122.139 111.378 122.096 111.485 122.096C111.624 122.096 111.768 122.16 111.917 122.288C112.077 122.405 112.285 122.528 112.541 122.656C112.797 122.773 113.154 122.832 113.613 122.832C114.146 122.832 114.504 122.741 114.685 122.56C114.877 122.379 114.973 122.181 114.973 121.968C114.973 121.691 114.877 121.477 114.685 121.328C114.504 121.168 114.264 121.04 113.965 120.944C113.677 120.848 113.368 120.757 113.037 120.672C112.706 120.576 112.392 120.453 112.093 120.304C111.805 120.155 111.565 119.947 111.373 119.68C111.192 119.413 111.101 119.061 111.101 118.624C111.101 118.261 111.192 117.904 111.373 117.552C111.554 117.189 111.842 116.896 112.237 116.672C112.642 116.437 113.181 116.32 113.853 116.32C114.258 116.32 114.642 116.363 115.005 116.448C115.368 116.533 115.666 116.651 115.901 116.8C116.136 116.939 116.253 117.093 116.253 117.264C116.253 117.339 116.226 117.445 116.173 117.584C116.12 117.712 116.045 117.829 115.949 117.936C115.864 118.032 115.752 118.08 115.613 118.08C115.506 118.08 115.373 118.043 115.213 117.968C115.053 117.883 114.866 117.803 114.653 117.728C114.44 117.653 114.178 117.616 113.869 117.616C113.56 117.616 113.309 117.669 113.117 117.776C112.936 117.872 112.802 117.989 112.717 118.128C112.632 118.267 112.589 118.405 112.589 118.544C112.589 118.779 112.68 118.96 112.861 119.088C113.042 119.216 113.282 119.323 113.581 119.408C113.88 119.493 114.194 119.584 114.525 119.68C114.856 119.765 115.165 119.893 115.453 120.064C115.752 120.235 115.992 120.464 116.173 120.752C116.365 121.04 116.461 121.424 116.461 121.904C116.461 122.576 116.216 123.115 115.725 123.52C115.245 123.925 114.557 124.128 113.661 124.128ZM121.876 114.512C121.609 114.512 121.38 114.421 121.188 114.24C120.996 114.059 120.9 113.856 120.9 113.632C120.9 113.387 120.996 113.179 121.188 113.008C121.38 112.837 121.609 112.752 121.876 112.752C122.143 112.752 122.367 112.837 122.548 113.008C122.74 113.179 122.836 113.387 122.836 113.632C122.836 113.856 122.74 114.059 122.548 114.24C122.367 114.421 122.143 114.512 121.876 114.512ZM121.876 124C121.631 124 121.428 123.941 121.268 123.824C121.119 123.707 121.044 123.579 121.044 123.44V116.96C121.044 116.8 121.119 116.672 121.268 116.576C121.428 116.469 121.631 116.416 121.876 116.416C122.111 116.416 122.308 116.469 122.468 116.576C122.639 116.672 122.724 116.8 122.724 116.96V123.44C122.724 123.579 122.639 123.707 122.468 123.824C122.308 123.941 122.111 124 121.876 124ZM125.298 124C125.053 124 124.85 123.941 124.69 123.824C124.541 123.707 124.466 123.579 124.466 123.44V116.96C124.466 116.8 124.541 116.672 124.69 116.576C124.85 116.469 125.053 116.416 125.298 116.416C125.501 116.416 125.677 116.469 125.826 116.576C125.975 116.672 126.05 116.8 126.05 116.96V117.536C126.21 117.227 126.471 116.949 126.834 116.704C127.207 116.448 127.661 116.32 128.194 116.32C128.695 116.32 129.154 116.464 129.57 116.752C129.997 117.029 130.338 117.408 130.594 117.888C130.85 118.357 130.978 118.885 130.978 119.472V123.44C130.978 123.621 130.887 123.76 130.706 123.856C130.535 123.952 130.343 124 130.13 124C129.938 124 129.751 123.952 129.57 123.856C129.389 123.76 129.298 123.621 129.298 123.44V119.472C129.298 119.195 129.223 118.928 129.074 118.672C128.935 118.416 128.743 118.208 128.498 118.048C128.253 117.888 127.981 117.808 127.682 117.808C127.426 117.808 127.181 117.877 126.946 118.016C126.711 118.144 126.519 118.331 126.37 118.576C126.221 118.821 126.146 119.12 126.146 119.472V123.44C126.146 123.579 126.061 123.707 125.89 123.824C125.73 123.941 125.533 124 125.298 124ZM138.721 127.6C138.102 127.6 137.531 127.509 137.009 127.328C136.486 127.157 136.07 126.907 135.761 126.576C135.451 126.245 135.297 125.851 135.297 125.392C135.297 124.965 135.419 124.608 135.665 124.32C135.91 124.043 136.198 123.829 136.529 123.68C136.315 123.584 136.139 123.456 136.001 123.296C135.862 123.136 135.793 122.912 135.793 122.624C135.793 122.325 135.867 122.085 136.017 121.904C136.166 121.723 136.358 121.557 136.593 121.408C136.294 121.173 136.059 120.885 135.889 120.544C135.729 120.192 135.649 119.808 135.649 119.392V118.944C135.649 118.432 135.771 117.979 136.017 117.584C136.262 117.189 136.609 116.88 137.057 116.656C137.515 116.432 138.038 116.32 138.625 116.32C138.987 116.32 139.323 116.368 139.633 116.464C139.953 116.56 140.235 116.693 140.481 116.864C140.651 116.469 140.822 116.192 140.993 116.032C141.174 115.872 141.345 115.792 141.505 115.792C141.729 115.792 141.899 115.856 142.017 115.984C142.134 116.112 142.193 116.24 142.193 116.368C142.193 116.453 142.166 116.533 142.113 116.608C142.07 116.672 142.006 116.725 141.921 116.768C141.814 116.821 141.686 116.896 141.537 116.992C141.398 117.077 141.259 117.216 141.121 117.408C141.302 117.611 141.435 117.845 141.521 118.112C141.606 118.379 141.649 118.656 141.649 118.944V119.392C141.649 119.893 141.521 120.347 141.265 120.752C141.009 121.157 140.651 121.477 140.193 121.712C139.734 121.936 139.211 122.048 138.625 122.048C138.209 122.048 137.841 121.984 137.521 121.856C137.435 121.909 137.361 121.973 137.297 122.048C137.243 122.112 137.217 122.197 137.217 122.304C137.217 122.496 137.334 122.635 137.569 122.72C137.803 122.805 138.102 122.869 138.465 122.912C138.838 122.955 139.233 123.008 139.649 123.072C140.065 123.136 140.454 123.243 140.817 123.392C141.19 123.531 141.494 123.739 141.729 124.016C141.963 124.304 142.081 124.693 142.081 125.184C142.081 125.739 141.926 126.192 141.617 126.544C141.307 126.907 140.897 127.173 140.385 127.344C139.883 127.515 139.329 127.6 138.721 127.6ZM138.689 126.48C139.211 126.48 139.633 126.363 139.953 126.128C140.283 125.904 140.449 125.605 140.449 125.232C140.449 124.965 140.369 124.757 140.209 124.608C140.049 124.459 139.841 124.347 139.585 124.272C139.329 124.197 139.057 124.144 138.769 124.112C138.491 124.08 138.225 124.048 137.969 124.016C137.67 124.123 137.414 124.272 137.201 124.464C136.998 124.667 136.897 124.917 136.897 125.216C136.897 125.611 137.062 125.92 137.393 126.144C137.734 126.368 138.166 126.48 138.689 126.48ZM138.657 120.976C139.083 120.976 139.414 120.827 139.649 120.528C139.894 120.229 140.017 119.851 140.017 119.392V118.944C140.017 118.507 139.894 118.139 139.649 117.84C139.414 117.541 139.078 117.392 138.641 117.392C138.203 117.392 137.867 117.541 137.633 117.84C137.398 118.139 137.281 118.507 137.281 118.944V119.376C137.281 119.824 137.398 120.203 137.633 120.512C137.867 120.821 138.209 120.976 138.657 120.976ZM146.255 124.128C145.679 124.128 145.14 123.979 144.639 123.68C144.137 123.381 143.732 122.992 143.423 122.512C143.124 122.021 142.975 121.499 142.975 120.944V119.472C142.975 118.907 143.119 118.384 143.407 117.904C143.705 117.424 144.105 117.04 144.607 116.752C145.119 116.464 145.673 116.32 146.271 116.32C146.868 116.32 147.417 116.464 147.919 116.752C148.42 117.029 148.82 117.408 149.119 117.888C149.428 118.357 149.583 118.885 149.583 119.472V120.944C149.583 121.488 149.428 122.005 149.119 122.496C148.82 122.987 148.415 123.381 147.903 123.68C147.401 123.979 146.852 124.128 146.255 124.128ZM146.271 122.64C146.569 122.64 146.841 122.56 147.087 122.4C147.332 122.24 147.529 122.032 147.679 121.776C147.828 121.509 147.903 121.232 147.903 120.944V119.472C147.903 119.195 147.828 118.928 147.679 118.672C147.529 118.416 147.332 118.208 147.087 118.048C146.841 117.888 146.569 117.808 146.271 117.808C145.961 117.808 145.684 117.888 145.439 118.048C145.204 118.208 145.012 118.416 144.863 118.672C144.724 118.928 144.655 119.195 144.655 119.472V120.944C144.655 121.232 144.724 121.509 144.863 121.776C145.012 122.032 145.209 122.24 145.455 122.4C145.7 122.56 145.972 122.64 146.271 122.64ZM154.036 124.128C153.46 124.128 152.921 123.979 152.42 123.68C151.919 123.381 151.513 122.992 151.204 122.512C150.905 122.021 150.756 121.499 150.756 120.944V119.472C150.756 118.907 150.9 118.384 151.188 117.904C151.487 117.424 151.887 117.04 152.388 116.752C152.9 116.464 153.455 116.32 154.052 116.32C154.649 116.32 155.199 116.464 155.7 116.752C156.201 117.029 156.601 117.408 156.9 117.888C157.209 118.357 157.364 118.885 157.364 119.472V120.944C157.364 121.488 157.209 122.005 156.9 122.496C156.601 122.987 156.196 123.381 155.684 123.68C155.183 123.979 154.633 124.128 154.036 124.128ZM154.052 122.64C154.351 122.64 154.623 122.56 154.868 122.4C155.113 122.24 155.311 122.032 155.46 121.776C155.609 121.509 155.684 121.232 155.684 120.944V119.472C155.684 119.195 155.609 118.928 155.46 118.672C155.311 118.416 155.113 118.208 154.868 118.048C154.623 117.888 154.351 117.808 154.052 117.808C153.743 117.808 153.465 117.888 153.22 118.048C152.985 118.208 152.793 118.416 152.644 118.672C152.505 118.928 152.436 119.195 152.436 119.472V120.944C152.436 121.232 152.505 121.509 152.644 121.776C152.793 122.032 152.991 122.24 153.236 122.4C153.481 122.56 153.753 122.64 154.052 122.64ZM161.353 124.128C160.852 124.128 160.388 123.979 159.961 123.68C159.535 123.381 159.188 122.992 158.921 122.512C158.665 122.021 158.537 121.499 158.537 120.944V119.472C158.537 118.885 158.665 118.357 158.921 117.888C159.188 117.408 159.535 117.029 159.961 116.752C160.388 116.464 160.863 116.32 161.385 116.32C161.897 116.32 162.329 116.448 162.681 116.704C163.033 116.949 163.295 117.227 163.465 117.536V112.448C163.465 112.288 163.551 112.16 163.721 112.064C163.892 111.957 164.095 111.904 164.329 111.904C164.564 111.904 164.756 111.957 164.905 112.064C165.065 112.16 165.145 112.288 165.145 112.448V123.44C165.145 123.579 165.065 123.707 164.905 123.824C164.756 123.941 164.564 124 164.329 124C164.127 124 163.945 123.941 163.785 123.824C163.636 123.707 163.561 123.579 163.561 123.44V122.88C163.401 123.211 163.119 123.504 162.713 123.76C162.308 124.005 161.855 124.128 161.353 124.128ZM161.833 122.64C162.143 122.64 162.42 122.555 162.665 122.384C162.911 122.213 163.103 122.027 163.241 121.824C163.391 121.611 163.465 121.44 163.465 121.312V119.472C163.465 119.12 163.385 118.821 163.225 118.576C163.065 118.331 162.863 118.144 162.617 118.016C162.372 117.877 162.116 117.808 161.849 117.808C161.551 117.808 161.273 117.888 161.017 118.048C160.772 118.208 160.575 118.416 160.425 118.672C160.287 118.928 160.217 119.195 160.217 119.472V120.944C160.217 121.221 160.287 121.493 160.425 121.76C160.575 122.027 160.772 122.24 161.017 122.4C161.263 122.56 161.535 122.64 161.833 122.64ZM173.194 124.128C172.426 124.128 171.792 123.989 171.29 123.712C170.8 123.435 170.437 123.056 170.202 122.576C169.968 122.096 169.85 121.552 169.85 120.944V119.504C169.85 118.907 169.968 118.368 170.202 117.888C170.437 117.397 170.8 117.013 171.29 116.736C171.781 116.459 172.405 116.32 173.162 116.32C173.653 116.32 174.08 116.379 174.442 116.496C174.816 116.613 175.104 116.763 175.306 116.944C175.52 117.115 175.626 117.296 175.626 117.488C175.626 117.584 175.594 117.701 175.53 117.84C175.477 117.968 175.397 118.08 175.29 118.176C175.194 118.261 175.077 118.304 174.938 118.304C174.832 118.304 174.714 118.261 174.586 118.176C174.469 118.091 174.309 118.011 174.106 117.936C173.904 117.851 173.632 117.808 173.29 117.808C172.693 117.808 172.25 117.957 171.962 118.256C171.674 118.555 171.53 118.971 171.53 119.504V120.944C171.53 121.477 171.674 121.893 171.962 122.192C172.25 122.491 172.698 122.64 173.306 122.64C173.658 122.64 173.936 122.597 174.138 122.512C174.341 122.416 174.501 122.325 174.618 122.24C174.746 122.155 174.869 122.112 174.986 122.112C175.136 122.112 175.264 122.155 175.37 122.24C175.488 122.325 175.573 122.432 175.626 122.56C175.69 122.688 175.722 122.805 175.722 122.912C175.722 123.093 175.61 123.28 175.386 123.472C175.173 123.664 174.874 123.824 174.49 123.952C174.117 124.069 173.685 124.128 173.194 124.128ZM179.833 124.128C179.257 124.128 178.718 123.979 178.217 123.68C177.716 123.381 177.31 122.992 177.001 122.512C176.702 122.021 176.553 121.499 176.553 120.944V119.472C176.553 118.907 176.697 118.384 176.985 117.904C177.284 117.424 177.684 117.04 178.185 116.752C178.697 116.464 179.252 116.32 179.849 116.32C180.446 116.32 180.996 116.464 181.497 116.752C181.998 117.029 182.398 117.408 182.697 117.888C183.006 118.357 183.161 118.885 183.161 119.472V120.944C183.161 121.488 183.006 122.005 182.697 122.496C182.398 122.987 181.993 123.381 181.481 123.68C180.98 123.979 180.43 124.128 179.833 124.128ZM179.849 122.64C180.148 122.64 180.42 122.56 180.665 122.4C180.91 122.24 181.108 122.032 181.257 121.776C181.406 121.509 181.481 121.232 181.481 120.944V119.472C181.481 119.195 181.406 118.928 181.257 118.672C181.108 118.416 180.91 118.208 180.665 118.048C180.42 117.888 180.148 117.808 179.849 117.808C179.54 117.808 179.262 117.888 179.017 118.048C178.782 118.208 178.59 118.416 178.441 118.672C178.302 118.928 178.233 119.195 178.233 119.472V120.944C178.233 121.232 178.302 121.509 178.441 121.776C178.59 122.032 178.788 122.24 179.033 122.4C179.278 122.56 179.55 122.64 179.849 122.64ZM185.454 124C185.209 124 185.006 123.941 184.846 123.824C184.697 123.707 184.622 123.579 184.622 123.44V116.96C184.622 116.8 184.697 116.672 184.846 116.576C185.006 116.469 185.209 116.416 185.454 116.416C185.657 116.416 185.833 116.469 185.982 116.576C186.132 116.672 186.206 116.8 186.206 116.96V117.536C186.366 117.227 186.628 116.949 186.99 116.704C187.364 116.448 187.817 116.32 188.35 116.32C188.852 116.32 189.31 116.464 189.726 116.752C190.153 117.029 190.494 117.408 190.75 117.888C191.006 118.357 191.134 118.885 191.134 119.472V123.44C191.134 123.621 191.044 123.76 190.862 123.856C190.692 123.952 190.5 124 190.286 124C190.094 124 189.908 123.952 189.726 123.856C189.545 123.76 189.454 123.621 189.454 123.44V119.472C189.454 119.195 189.38 118.928 189.23 118.672C189.092 118.416 188.9 118.208 188.654 118.048C188.409 117.888 188.137 117.808 187.838 117.808C187.582 117.808 187.337 117.877 187.102 118.016C186.868 118.144 186.676 118.331 186.526 118.576C186.377 118.821 186.302 119.12 186.302 119.472V123.44C186.302 123.579 186.217 123.707 186.046 123.824C185.886 123.941 185.689 124 185.454 124ZM195.338 124.128C194.836 124.128 194.372 123.979 193.946 123.68C193.519 123.381 193.172 122.992 192.906 122.512C192.65 122.021 192.522 121.499 192.522 120.944V119.472C192.522 118.885 192.65 118.357 192.906 117.888C193.172 117.408 193.519 117.029 193.946 116.752C194.372 116.464 194.847 116.32 195.37 116.32C195.882 116.32 196.314 116.448 196.666 116.704C197.018 116.949 197.279 117.227 197.45 117.536V112.448C197.45 112.288 197.535 112.16 197.706 112.064C197.876 111.957 198.079 111.904 198.314 111.904C198.548 111.904 198.74 111.957 198.89 112.064C199.05 112.16 199.13 112.288 199.13 112.448V123.44C199.13 123.579 199.05 123.707 198.89 123.824C198.74 123.941 198.548 124 198.314 124C198.111 124 197.93 123.941 197.77 123.824C197.62 123.707 197.546 123.579 197.546 123.44V122.88C197.386 123.211 197.103 123.504 196.698 123.76C196.292 124.005 195.839 124.128 195.338 124.128ZM195.818 122.64C196.127 122.64 196.404 122.555 196.65 122.384C196.895 122.213 197.087 122.027 197.226 121.824C197.375 121.611 197.45 121.44 197.45 121.312V119.472C197.45 119.12 197.37 118.821 197.21 118.576C197.05 118.331 196.847 118.144 196.602 118.016C196.356 117.877 196.1 117.808 195.834 117.808C195.535 117.808 195.258 117.888 195.002 118.048C194.756 118.208 194.559 118.416 194.41 118.672C194.271 118.928 194.202 119.195 194.202 119.472V120.944C194.202 121.221 194.271 121.493 194.41 121.76C194.559 122.027 194.756 122.24 195.002 122.4C195.247 122.56 195.519 122.64 195.818 122.64ZM201.735 114.512C201.469 114.512 201.239 114.421 201.047 114.24C200.855 114.059 200.759 113.856 200.759 113.632C200.759 113.387 200.855 113.179 201.047 113.008C201.239 112.837 201.469 112.752 201.735 112.752C202.002 112.752 202.226 112.837 202.407 113.008C202.599 113.179 202.695 113.387 202.695 113.632C202.695 113.856 202.599 114.059 202.407 114.24C202.226 114.421 202.002 114.512 201.735 114.512ZM201.735 124C201.49 124 201.287 123.941 201.127 123.824C200.978 123.707 200.903 123.579 200.903 123.44V116.96C200.903 116.8 200.978 116.672 201.127 116.576C201.287 116.469 201.49 116.416 201.735 116.416C201.97 116.416 202.167 116.469 202.327 116.576C202.498 116.672 202.583 116.8 202.583 116.96V123.44C202.583 123.579 202.498 123.707 202.327 123.824C202.167 123.941 201.97 124 201.735 124ZM207.093 124C206.187 124 205.493 123.803 205.013 123.408C204.533 123.003 204.293 122.368 204.293 121.504V113.488C204.293 113.328 204.379 113.2 204.549 113.104C204.731 112.997 204.923 112.944 205.125 112.944C205.328 112.944 205.52 112.997 205.701 113.104C205.883 113.2 205.973 113.328 205.973 113.488V116.416H207.925C208.075 116.416 208.187 116.48 208.261 116.608C208.347 116.736 208.389 116.88 208.389 117.04C208.389 117.2 208.347 117.344 208.261 117.472C208.187 117.6 208.075 117.664 207.925 117.664H205.973V121.504C205.973 121.888 206.053 122.16 206.213 122.32C206.384 122.48 206.677 122.56 207.093 122.56H207.637C207.883 122.56 208.064 122.635 208.181 122.784C208.309 122.923 208.373 123.088 208.373 123.28C208.373 123.461 208.309 123.627 208.181 123.776C208.064 123.925 207.883 124 207.637 124H207.093ZM210.376 114.512C210.109 114.512 209.88 114.421 209.688 114.24C209.496 114.059 209.4 113.856 209.4 113.632C209.4 113.387 209.496 113.179 209.688 113.008C209.88 112.837 210.109 112.752 210.376 112.752C210.643 112.752 210.867 112.837 211.048 113.008C211.24 113.179 211.336 113.387 211.336 113.632C211.336 113.856 211.24 114.059 211.048 114.24C210.867 114.421 210.643 114.512 210.376 114.512ZM210.376 124C210.131 124 209.928 123.941 209.768 123.824C209.619 123.707 209.544 123.579 209.544 123.44V116.96C209.544 116.8 209.619 116.672 209.768 116.576C209.928 116.469 210.131 116.416 210.376 116.416C210.611 116.416 210.808 116.469 210.968 116.576C211.139 116.672 211.224 116.8 211.224 116.96V123.44C211.224 123.579 211.139 123.707 210.968 123.824C210.808 123.941 210.611 124 210.376 124ZM215.958 124.128C215.382 124.128 214.843 123.979 214.342 123.68C213.841 123.381 213.435 122.992 213.126 122.512C212.827 122.021 212.678 121.499 212.678 120.944V119.472C212.678 118.907 212.822 118.384 213.11 117.904C213.409 117.424 213.809 117.04 214.31 116.752C214.822 116.464 215.377 116.32 215.974 116.32C216.571 116.32 217.121 116.464 217.622 116.752C218.123 117.029 218.523 117.408 218.822 117.888C219.131 118.357 219.286 118.885 219.286 119.472V120.944C219.286 121.488 219.131 122.005 218.822 122.496C218.523 122.987 218.118 123.381 217.606 123.68C217.105 123.979 216.555 124.128 215.958 124.128ZM215.974 122.64C216.273 122.64 216.545 122.56 216.79 122.4C217.035 122.24 217.233 122.032 217.382 121.776C217.531 121.509 217.606 121.232 217.606 120.944V119.472C217.606 119.195 217.531 118.928 217.382 118.672C217.233 118.416 217.035 118.208 216.79 118.048C216.545 117.888 216.273 117.808 215.974 117.808C215.665 117.808 215.387 117.888 215.142 118.048C214.907 118.208 214.715 118.416 214.566 118.672C214.427 118.928 214.358 119.195 214.358 119.472V120.944C214.358 121.232 214.427 121.509 214.566 121.776C214.715 122.032 214.913 122.24 215.158 122.4C215.403 122.56 215.675 122.64 215.974 122.64ZM221.579 124C221.334 124 221.131 123.941 220.971 123.824C220.822 123.707 220.747 123.579 220.747 123.44V116.96C220.747 116.8 220.822 116.672 220.971 116.576C221.131 116.469 221.334 116.416 221.579 116.416C221.782 116.416 221.958 116.469 222.107 116.576C222.257 116.672 222.331 116.8 222.331 116.96V117.536C222.491 117.227 222.753 116.949 223.115 116.704C223.489 116.448 223.942 116.32 224.475 116.32C224.977 116.32 225.435 116.464 225.851 116.752C226.278 117.029 226.619 117.408 226.875 117.888C227.131 118.357 227.259 118.885 227.259 119.472V123.44C227.259 123.621 227.169 123.76 226.987 123.856C226.817 123.952 226.625 124 226.411 124C226.219 124 226.033 123.952 225.851 123.856C225.67 123.76 225.579 123.621 225.579 123.44V119.472C225.579 119.195 225.505 118.928 225.355 118.672C225.217 118.416 225.025 118.208 224.779 118.048C224.534 117.888 224.262 117.808 223.963 117.808C223.707 117.808 223.462 117.877 223.227 118.016C222.993 118.144 222.801 118.331 222.651 118.576C222.502 118.821 222.427 119.12 222.427 119.472V123.44C222.427 123.579 222.342 123.707 222.171 123.824C222.011 123.941 221.814 124 221.579 124ZM72.3366 144.16C72.1872 144.16 72.0539 144.133 71.9366 144.08C71.8192 144.027 71.7339 143.931 71.6806 143.792L69.2006 137.328C69.1792 137.275 69.1579 137.227 69.1366 137.184C69.1259 137.131 69.1206 137.088 69.1206 137.056C69.1206 136.917 69.1792 136.8 69.2966 136.704C69.4139 136.597 69.5526 136.512 69.7126 136.448C69.8832 136.384 70.0432 136.352 70.1926 136.352C70.3099 136.352 70.4166 136.379 70.5126 136.432C70.6086 136.475 70.6726 136.549 70.7046 136.656L72.4806 141.632L73.8406 137.216C73.8939 137.056 73.9739 136.955 74.0806 136.912C74.1872 136.869 74.3046 136.848 74.4326 136.848C74.5712 136.848 74.6939 136.869 74.8006 136.912C74.9072 136.955 74.9872 137.056 75.0406 137.216L76.3686 141.664L78.1606 136.656C78.2246 136.453 78.3899 136.352 78.6566 136.352C78.8059 136.352 78.9606 136.384 79.1206 136.448C79.2912 136.501 79.4352 136.581 79.5526 136.688C79.6699 136.795 79.7286 136.923 79.7286 137.072C79.7286 137.104 79.7232 137.147 79.7126 137.2C79.7019 137.253 79.6859 137.296 79.6646 137.328L77.1846 143.824C77.1419 143.952 77.0566 144.037 76.9286 144.08C76.8112 144.133 76.6779 144.16 76.5286 144.16C76.3579 144.16 76.2086 144.133 76.0806 144.08C75.9632 144.027 75.8832 143.947 75.8406 143.84L74.4326 139.712L73.0566 143.792C73.0139 143.92 72.9232 144.011 72.7846 144.064C72.6566 144.128 72.5072 144.16 72.3366 144.16ZM81.6108 144C81.3655 144 81.1628 143.941 81.0028 143.824C80.8535 143.707 80.7788 143.579 80.7788 143.44V132.448C80.7788 132.288 80.8535 132.16 81.0028 132.064C81.1628 131.957 81.3655 131.904 81.6108 131.904C81.8455 131.904 82.0428 131.957 82.2028 132.064C82.3735 132.16 82.4588 132.288 82.4588 132.448V137.536C82.6188 137.227 82.8695 136.949 83.2108 136.704C83.5628 136.448 83.9948 136.32 84.5068 136.32C85.0081 136.32 85.4668 136.464 85.8828 136.752C86.3095 137.029 86.6508 137.408 86.9068 137.888C87.1628 138.357 87.2908 138.885 87.2908 139.472V143.44C87.2908 143.621 87.2001 143.76 87.0188 143.856C86.8481 143.952 86.6561 144 86.4428 144C86.2508 144 86.0641 143.952 85.8828 143.856C85.7015 143.76 85.6108 143.621 85.6108 143.44V139.472C85.6108 139.195 85.5361 138.928 85.3868 138.672C85.2375 138.416 85.0401 138.208 84.7948 138.048C84.5601 137.888 84.2935 137.808 83.9948 137.808C83.7388 137.808 83.4935 137.877 83.2588 138.016C83.0241 138.144 82.8321 138.331 82.6828 138.576C82.5335 138.821 82.4588 139.12 82.4588 139.472V143.44C82.4588 143.579 82.3735 143.707 82.2028 143.824C82.0428 143.941 81.8455 144 81.6108 144ZM89.7979 134.512C89.5313 134.512 89.3019 134.421 89.1099 134.24C88.9179 134.059 88.8219 133.856 88.8219 133.632C88.8219 133.387 88.9179 133.179 89.1099 133.008C89.3019 132.837 89.5313 132.752 89.7979 132.752C90.0646 132.752 90.2886 132.837 90.4699 133.008C90.6619 133.179 90.7579 133.387 90.7579 133.632C90.7579 133.856 90.6619 134.059 90.4699 134.24C90.2886 134.421 90.0646 134.512 89.7979 134.512ZM89.7979 144C89.5526 144 89.3499 143.941 89.1899 143.824C89.0406 143.707 88.9659 143.579 88.9659 143.44V136.96C88.9659 136.8 89.0406 136.672 89.1899 136.576C89.3499 136.469 89.5526 136.416 89.7979 136.416C90.0326 136.416 90.2299 136.469 90.3899 136.576C90.5606 136.672 90.6459 136.8 90.6459 136.96V143.44C90.6459 143.579 90.5606 143.707 90.3899 143.824C90.2299 143.941 90.0326 144 89.7979 144ZM95.4598 144.128C94.6918 144.128 94.0571 143.989 93.5558 143.712C93.0651 143.435 92.7025 143.056 92.4678 142.576C92.2331 142.096 92.1158 141.552 92.1158 140.944V139.504C92.1158 138.907 92.2331 138.368 92.4678 137.888C92.7025 137.397 93.0651 137.013 93.5558 136.736C94.0465 136.459 94.6705 136.32 95.4278 136.32C95.9185 136.32 96.3451 136.379 96.7078 136.496C97.0811 136.613 97.3691 136.763 97.5718 136.944C97.7851 137.115 97.8918 137.296 97.8918 137.488C97.8918 137.584 97.8598 137.701 97.7958 137.84C97.7425 137.968 97.6625 138.08 97.5558 138.176C97.4598 138.261 97.3425 138.304 97.2038 138.304C97.0971 138.304 96.9798 138.261 96.8518 138.176C96.7345 138.091 96.5745 138.011 96.3718 137.936C96.1691 137.851 95.8971 137.808 95.5558 137.808C94.9585 137.808 94.5158 137.957 94.2278 138.256C93.9398 138.555 93.7958 138.971 93.7958 139.504V140.944C93.7958 141.477 93.9398 141.893 94.2278 142.192C94.5158 142.491 94.9638 142.64 95.5718 142.64C95.9238 142.64 96.2011 142.597 96.4038 142.512C96.6065 142.416 96.7665 142.325 96.8838 142.24C97.0118 142.155 97.1345 142.112 97.2518 142.112C97.4011 142.112 97.5291 142.155 97.6358 142.24C97.7531 142.325 97.8385 142.432 97.8918 142.56C97.9558 142.688 97.9878 142.805 97.9878 142.912C97.9878 143.093 97.8758 143.28 97.6518 143.472C97.4385 143.664 97.1398 143.824 96.7558 143.952C96.3825 144.069 95.9505 144.128 95.4598 144.128ZM100.033 144C99.7874 144 99.5847 143.941 99.4247 143.824C99.2754 143.707 99.2007 143.579 99.2007 143.44V132.448C99.2007 132.288 99.2754 132.16 99.4247 132.064C99.5847 131.957 99.7874 131.904 100.033 131.904C100.267 131.904 100.465 131.957 100.625 132.064C100.795 132.16 100.881 132.288 100.881 132.448V137.536C101.041 137.227 101.291 136.949 101.633 136.704C101.985 136.448 102.417 136.32 102.929 136.32C103.43 136.32 103.889 136.464 104.305 136.752C104.731 137.029 105.073 137.408 105.329 137.888C105.585 138.357 105.713 138.885 105.713 139.472V143.44C105.713 143.621 105.622 143.76 105.441 143.856C105.27 143.952 105.078 144 104.865 144C104.673 144 104.486 143.952 104.305 143.856C104.123 143.76 104.033 143.621 104.033 143.44V139.472C104.033 139.195 103.958 138.928 103.809 138.672C103.659 138.416 103.462 138.208 103.217 138.048C102.982 137.888 102.715 137.808 102.417 137.808C102.161 137.808 101.915 137.877 101.681 138.016C101.446 138.144 101.254 138.331 101.105 138.576C100.955 138.821 100.881 139.12 100.881 139.472V143.44C100.881 143.579 100.795 143.707 100.625 143.824C100.465 143.941 100.267 144 100.033 144ZM113.663 144.128C112.895 144.128 112.26 143.989 111.759 143.712C111.268 143.435 110.906 143.056 110.671 142.576C110.436 142.096 110.319 141.552 110.319 140.944V139.504C110.319 138.907 110.436 138.368 110.671 137.888C110.906 137.397 111.268 137.013 111.759 136.736C112.25 136.459 112.874 136.32 113.631 136.32C114.122 136.32 114.548 136.379 114.911 136.496C115.284 136.613 115.572 136.763 115.775 136.944C115.988 137.115 116.095 137.296 116.095 137.488C116.095 137.584 116.063 137.701 115.999 137.84C115.946 137.968 115.866 138.08 115.759 138.176C115.663 138.261 115.546 138.304 115.407 138.304C115.3 138.304 115.183 138.261 115.055 138.176C114.938 138.091 114.778 138.011 114.575 137.936C114.372 137.851 114.1 137.808 113.759 137.808C113.162 137.808 112.719 137.957 112.431 138.256C112.143 138.555 111.999 138.971 111.999 139.504V140.944C111.999 141.477 112.143 141.893 112.431 142.192C112.719 142.491 113.167 142.64 113.775 142.64C114.127 142.64 114.404 142.597 114.607 142.512C114.81 142.416 114.97 142.325 115.087 142.24C115.215 142.155 115.338 142.112 115.455 142.112C115.604 142.112 115.732 142.155 115.839 142.24C115.956 142.325 116.042 142.432 116.095 142.56C116.159 142.688 116.191 142.805 116.191 142.912C116.191 143.093 116.079 143.28 115.855 143.472C115.642 143.664 115.343 143.824 114.959 143.952C114.586 144.069 114.154 144.128 113.663 144.128ZM119.036 144.128C118.449 144.128 117.948 143.957 117.532 143.616C117.116 143.264 116.908 142.731 116.908 142.016C116.908 141.408 117.068 140.939 117.388 140.608C117.708 140.277 118.145 140.048 118.7 139.92C119.265 139.792 119.916 139.728 120.652 139.728H121.356V139.44C121.356 139.163 121.302 138.896 121.196 138.64C121.1 138.373 120.934 138.155 120.7 137.984C120.476 137.803 120.166 137.712 119.772 137.712C119.377 137.712 119.073 137.749 118.86 137.824C118.646 137.899 118.476 137.979 118.348 138.064C118.22 138.149 118.102 138.192 117.996 138.192C117.804 138.192 117.654 138.101 117.548 137.92C117.441 137.728 117.388 137.536 117.388 137.344C117.388 137.152 117.51 136.981 117.756 136.832C118.012 136.672 118.326 136.549 118.7 136.464C119.073 136.368 119.441 136.32 119.804 136.32C120.593 136.32 121.222 136.469 121.692 136.768C122.161 137.056 122.502 137.435 122.716 137.904C122.929 138.373 123.036 138.88 123.036 139.424V143.44C123.036 143.589 122.956 143.723 122.796 143.84C122.646 143.947 122.454 144 122.22 144C122.006 144 121.825 143.947 121.676 143.84C121.526 143.723 121.452 143.589 121.452 143.44V142.88C121.174 143.2 120.838 143.488 120.444 143.744C120.049 144 119.58 144.128 119.036 144.128ZM119.644 142.848C119.91 142.848 120.172 142.768 120.428 142.608C120.694 142.448 120.913 142.245 121.084 142C121.265 141.755 121.356 141.504 121.356 141.248V140.656H120.956C120.55 140.656 120.166 140.683 119.804 140.736C119.441 140.779 119.148 140.885 118.924 141.056C118.71 141.216 118.604 141.467 118.604 141.808C118.604 142.171 118.7 142.437 118.892 142.608C119.094 142.768 119.345 142.848 119.644 142.848ZM125.564 144C125.318 144 125.116 143.941 124.956 143.824C124.806 143.707 124.732 143.579 124.732 143.44V136.96C124.732 136.8 124.806 136.672 124.956 136.576C125.116 136.469 125.318 136.416 125.564 136.416C125.766 136.416 125.942 136.469 126.092 136.576C126.241 136.672 126.316 136.8 126.316 136.96V137.536C126.476 137.227 126.737 136.949 127.1 136.704C127.473 136.448 127.926 136.32 128.46 136.32C128.961 136.32 129.42 136.464 129.836 136.752C130.262 137.029 130.604 137.408 130.86 137.888C131.116 138.357 131.244 138.885 131.244 139.472V143.44C131.244 143.621 131.153 143.76 130.972 143.856C130.801 143.952 130.609 144 130.396 144C130.204 144 130.017 143.952 129.836 143.856C129.654 143.76 129.564 143.621 129.564 143.44V139.472C129.564 139.195 129.489 138.928 129.34 138.672C129.201 138.416 129.009 138.208 128.764 138.048C128.518 137.888 128.246 137.808 127.948 137.808C127.692 137.808 127.446 137.877 127.212 138.016C126.977 138.144 126.785 138.331 126.636 138.576C126.486 138.821 126.412 139.12 126.412 139.472V143.44C126.412 143.579 126.326 143.707 126.156 143.824C125.996 143.941 125.798 144 125.564 144ZM139.93 144.128C139.429 144.128 138.976 144.005 138.57 143.76C138.176 143.504 137.893 143.211 137.722 142.88V143.44C137.722 143.579 137.648 143.707 137.498 143.824C137.349 143.941 137.168 144 136.954 144C136.72 144 136.522 143.941 136.362 143.824C136.213 143.707 136.138 143.579 136.138 143.44V132.448C136.138 132.288 136.213 132.16 136.362 132.064C136.522 131.957 136.72 131.904 136.954 131.904C137.2 131.904 137.402 131.957 137.562 132.064C137.733 132.16 137.818 132.288 137.818 132.448V137.536C137.989 137.227 138.25 136.949 138.602 136.704C138.954 136.448 139.381 136.32 139.882 136.32C140.405 136.32 140.88 136.464 141.306 136.752C141.744 137.029 142.09 137.408 142.346 137.888C142.613 138.357 142.746 138.885 142.746 139.472V140.944C142.746 141.499 142.613 142.021 142.346 142.512C142.09 142.992 141.749 143.381 141.322 143.68C140.896 143.979 140.432 144.128 139.93 144.128ZM139.45 142.64C139.738 142.64 140.005 142.56 140.25 142.4C140.496 142.24 140.693 142.027 140.842 141.76C140.992 141.493 141.066 141.221 141.066 140.944V139.472C141.066 139.195 140.992 138.928 140.842 138.672C140.693 138.416 140.496 138.208 140.25 138.048C140.005 137.888 139.733 137.808 139.434 137.808C139.168 137.808 138.912 137.877 138.666 138.016C138.421 138.144 138.218 138.331 138.058 138.576C137.898 138.821 137.818 139.12 137.818 139.472V141.312C137.818 141.44 137.888 141.611 138.026 141.824C138.176 142.027 138.373 142.213 138.618 142.384C138.864 142.555 139.141 142.64 139.45 142.64ZM147.64 144.128C146.915 144.128 146.275 143.995 145.72 143.728C145.165 143.461 144.728 143.093 144.408 142.624C144.088 142.144 143.928 141.584 143.928 140.944V139.424C143.928 138.859 144.077 138.341 144.376 137.872C144.685 137.403 145.091 137.029 145.592 136.752C146.093 136.464 146.648 136.32 147.256 136.32C147.832 136.32 148.36 136.448 148.84 136.704C149.32 136.949 149.704 137.296 149.992 137.744C150.291 138.192 150.44 138.704 150.44 139.28C150.44 139.728 150.371 140.048 150.232 140.24C150.093 140.432 149.912 140.549 149.688 140.592C149.464 140.635 149.229 140.656 148.984 140.656H145.608V141.024C145.608 141.557 145.8 141.984 146.184 142.304C146.579 142.613 147.08 142.768 147.688 142.768C148.061 142.768 148.365 142.715 148.6 142.608C148.835 142.501 149.032 142.4 149.192 142.304C149.352 142.208 149.501 142.16 149.64 142.16C149.779 142.16 149.896 142.203 149.992 142.288C150.088 142.373 150.163 142.475 150.216 142.592C150.269 142.709 150.296 142.816 150.296 142.912C150.296 143.072 150.184 143.248 149.96 143.44C149.747 143.632 149.443 143.797 149.048 143.936C148.653 144.064 148.184 144.128 147.64 144.128ZM145.608 139.616H148.264C148.499 139.616 148.653 139.584 148.728 139.52C148.813 139.456 148.856 139.328 148.856 139.136C148.856 138.859 148.787 138.603 148.648 138.368C148.509 138.123 148.317 137.936 148.072 137.808C147.827 137.669 147.549 137.6 147.24 137.6C146.941 137.6 146.669 137.664 146.424 137.792C146.179 137.92 145.981 138.096 145.832 138.32C145.683 138.544 145.608 138.805 145.608 139.104V139.616ZM155.829 144C155.594 144 155.397 143.941 155.237 143.824C155.087 143.707 155.013 143.579 155.013 143.44V136.96C155.013 136.8 155.087 136.672 155.237 136.576C155.397 136.469 155.594 136.416 155.829 136.416C156.042 136.416 156.223 136.469 156.373 136.576C156.522 136.672 156.597 136.8 156.597 136.96V137.664C156.714 137.44 156.869 137.227 157.061 137.024C157.263 136.821 157.498 136.656 157.765 136.528C158.031 136.389 158.319 136.32 158.629 136.32H159.141C159.311 136.32 159.461 136.395 159.589 136.544C159.717 136.683 159.781 136.853 159.781 137.056C159.781 137.259 159.717 137.435 159.589 137.584C159.461 137.733 159.311 137.808 159.141 137.808H158.629C158.309 137.808 157.999 137.904 157.701 138.096C157.402 138.288 157.157 138.56 156.965 138.912C156.783 139.253 156.693 139.669 156.693 140.16V143.44C156.693 143.579 156.607 143.707 156.437 143.824C156.277 143.941 156.074 144 155.829 144ZM163.921 144.128C163.196 144.128 162.556 143.995 162.001 143.728C161.447 143.461 161.009 143.093 160.689 142.624C160.369 142.144 160.209 141.584 160.209 140.944V139.424C160.209 138.859 160.359 138.341 160.657 137.872C160.967 137.403 161.372 137.029 161.873 136.752C162.375 136.464 162.929 136.32 163.537 136.32C164.113 136.32 164.641 136.448 165.121 136.704C165.601 136.949 165.985 137.296 166.273 137.744C166.572 138.192 166.721 138.704 166.721 139.28C166.721 139.728 166.652 140.048 166.513 140.24C166.375 140.432 166.193 140.549 165.969 140.592C165.745 140.635 165.511 140.656 165.265 140.656H161.889V141.024C161.889 141.557 162.081 141.984 162.465 142.304C162.86 142.613 163.361 142.768 163.969 142.768C164.343 142.768 164.647 142.715 164.881 142.608C165.116 142.501 165.313 142.4 165.473 142.304C165.633 142.208 165.783 142.16 165.921 142.16C166.06 142.16 166.177 142.203 166.273 142.288C166.369 142.373 166.444 142.475 166.497 142.592C166.551 142.709 166.577 142.816 166.577 142.912C166.577 143.072 166.465 143.248 166.241 143.44C166.028 143.632 165.724 143.797 165.329 143.936C164.935 144.064 164.465 144.128 163.921 144.128ZM161.889 139.616H164.545C164.78 139.616 164.935 139.584 165.009 139.52C165.095 139.456 165.137 139.328 165.137 139.136C165.137 138.859 165.068 138.603 164.929 138.368C164.791 138.123 164.599 137.936 164.353 137.808C164.108 137.669 163.831 137.6 163.521 137.6C163.223 137.6 162.951 137.664 162.705 137.792C162.46 137.92 162.263 138.096 162.113 138.32C161.964 138.544 161.889 138.805 161.889 139.104V139.616ZM171.323 144.128C170.726 144.128 170.171 143.984 169.659 143.696C169.158 143.397 168.758 143.008 168.459 142.528C168.16 142.037 168.011 141.52 168.011 140.976V136.976C168.011 136.837 168.091 136.709 168.251 136.592C168.422 136.475 168.624 136.416 168.859 136.416C169.083 136.416 169.275 136.475 169.435 136.592C169.606 136.709 169.691 136.837 169.691 136.976V140.976C169.691 141.253 169.76 141.52 169.899 141.776C170.048 142.032 170.246 142.24 170.491 142.4C170.747 142.56 171.024 142.64 171.323 142.64C171.622 142.64 171.894 142.56 172.139 142.4C172.384 142.24 172.576 142.032 172.715 141.776C172.864 141.52 172.939 141.253 172.939 140.976V136.96C172.939 136.811 173.024 136.683 173.195 136.576C173.376 136.469 173.574 136.416 173.787 136.416C174.032 136.416 174.23 136.469 174.379 136.576C174.539 136.683 174.619 136.811 174.619 136.96V140.976C174.619 141.541 174.47 142.064 174.171 142.544C173.872 143.024 173.472 143.408 172.971 143.696C172.47 143.984 171.92 144.128 171.323 144.128ZM178.614 144.128C178.091 144.128 177.622 144.064 177.206 143.936C176.79 143.808 176.459 143.648 176.214 143.456C175.979 143.253 175.862 143.051 175.862 142.848C175.862 142.752 175.883 142.645 175.926 142.528C175.979 142.411 176.049 142.309 176.134 142.224C176.23 142.139 176.331 142.096 176.438 142.096C176.577 142.096 176.721 142.16 176.87 142.288C177.03 142.405 177.238 142.528 177.494 142.656C177.75 142.773 178.107 142.832 178.566 142.832C179.099 142.832 179.457 142.741 179.638 142.56C179.83 142.379 179.926 142.181 179.926 141.968C179.926 141.691 179.83 141.477 179.638 141.328C179.457 141.168 179.217 141.04 178.918 140.944C178.63 140.848 178.321 140.757 177.99 140.672C177.659 140.576 177.345 140.453 177.046 140.304C176.758 140.155 176.518 139.947 176.326 139.68C176.145 139.413 176.054 139.061 176.054 138.624C176.054 138.261 176.145 137.904 176.326 137.552C176.507 137.189 176.795 136.896 177.19 136.672C177.595 136.437 178.134 136.32 178.806 136.32C179.211 136.32 179.595 136.363 179.958 136.448C180.321 136.533 180.619 136.651 180.854 136.8C181.089 136.939 181.206 137.093 181.206 137.264C181.206 137.339 181.179 137.445 181.126 137.584C181.073 137.712 180.998 137.829 180.902 137.936C180.817 138.032 180.705 138.08 180.566 138.08C180.459 138.08 180.326 138.043 180.166 137.968C180.006 137.883 179.819 137.803 179.606 137.728C179.393 137.653 179.131 137.616 178.822 137.616C178.513 137.616 178.262 137.669 178.07 137.776C177.889 137.872 177.755 137.989 177.67 138.128C177.585 138.267 177.542 138.405 177.542 138.544C177.542 138.779 177.633 138.96 177.814 139.088C177.995 139.216 178.235 139.323 178.534 139.408C178.833 139.493 179.147 139.584 179.478 139.68C179.809 139.765 180.118 139.893 180.406 140.064C180.705 140.235 180.945 140.464 181.126 140.752C181.318 141.04 181.414 141.424 181.414 141.904C181.414 142.576 181.169 143.115 180.678 143.52C180.198 143.925 179.51 144.128 178.614 144.128ZM186.218 144.128C185.493 144.128 184.853 143.995 184.298 143.728C183.743 143.461 183.306 143.093 182.986 142.624C182.666 142.144 182.506 141.584 182.506 140.944V139.424C182.506 138.859 182.655 138.341 182.954 137.872C183.263 137.403 183.669 137.029 184.17 136.752C184.671 136.464 185.226 136.32 185.834 136.32C186.41 136.32 186.938 136.448 187.418 136.704C187.898 136.949 188.282 137.296 188.57 137.744C188.869 138.192 189.018 138.704 189.018 139.28C189.018 139.728 188.949 140.048 188.81 140.24C188.671 140.432 188.49 140.549 188.266 140.592C188.042 140.635 187.807 140.656 187.562 140.656H184.186V141.024C184.186 141.557 184.378 141.984 184.762 142.304C185.157 142.613 185.658 142.768 186.266 142.768C186.639 142.768 186.943 142.715 187.178 142.608C187.413 142.501 187.61 142.4 187.77 142.304C187.93 142.208 188.079 142.16 188.218 142.16C188.357 142.16 188.474 142.203 188.57 142.288C188.666 142.373 188.741 142.475 188.794 142.592C188.847 142.709 188.874 142.816 188.874 142.912C188.874 143.072 188.762 143.248 188.538 143.44C188.325 143.632 188.021 143.797 187.626 143.936C187.231 144.064 186.762 144.128 186.218 144.128ZM184.186 139.616H186.842C187.077 139.616 187.231 139.584 187.306 139.52C187.391 139.456 187.434 139.328 187.434 139.136C187.434 138.859 187.365 138.603 187.226 138.368C187.087 138.123 186.895 137.936 186.65 137.808C186.405 137.669 186.127 137.6 185.818 137.6C185.519 137.6 185.247 137.664 185.002 137.792C184.757 137.92 184.559 138.096 184.41 138.32C184.261 138.544 184.186 138.805 184.186 139.104V139.616ZM192.916 144.128C192.414 144.128 191.95 143.979 191.524 143.68C191.097 143.381 190.75 142.992 190.484 142.512C190.228 142.021 190.1 141.499 190.1 140.944V139.472C190.1 138.885 190.228 138.357 190.484 137.888C190.75 137.408 191.097 137.029 191.524 136.752C191.95 136.464 192.425 136.32 192.948 136.32C193.46 136.32 193.892 136.448 194.244 136.704C194.596 136.949 194.857 137.227 195.028 137.536V132.448C195.028 132.288 195.113 132.16 195.284 132.064C195.454 131.957 195.657 131.904 195.892 131.904C196.126 131.904 196.318 131.957 196.468 132.064C196.628 132.16 196.708 132.288 196.708 132.448V143.44C196.708 143.579 196.628 143.707 196.468 143.824C196.318 143.941 196.126 144 195.892 144C195.689 144 195.508 143.941 195.348 143.824C195.198 143.707 195.124 143.579 195.124 143.44V142.88C194.964 143.211 194.681 143.504 194.276 143.76C193.87 144.005 193.417 144.128 192.916 144.128ZM193.396 142.64C193.705 142.64 193.982 142.555 194.228 142.384C194.473 142.213 194.665 142.027 194.804 141.824C194.953 141.611 195.028 141.44 195.028 141.312V139.472C195.028 139.12 194.948 138.821 194.788 138.576C194.628 138.331 194.425 138.144 194.18 138.016C193.934 137.877 193.678 137.808 193.412 137.808C193.113 137.808 192.836 137.888 192.58 138.048C192.334 138.208 192.137 138.416 191.988 138.672C191.849 138.928 191.78 139.195 191.78 139.472V140.944C191.78 141.221 191.849 141.493 191.988 141.76C192.137 142.027 192.334 142.24 192.58 142.4C192.825 142.56 193.097 142.64 193.396 142.64ZM199.314 140.992C199.143 140.992 198.988 140.949 198.85 140.864C198.722 140.779 198.658 140.651 198.658 140.48C198.658 139.701 198.642 138.88 198.61 138.016C198.578 137.152 198.546 136.288 198.514 135.424C198.482 134.549 198.466 133.728 198.466 132.96C198.466 132.715 198.546 132.528 198.706 132.4C198.866 132.261 199.068 132.192 199.314 132.192C199.548 132.192 199.746 132.261 199.906 132.4C200.076 132.528 200.162 132.715 200.162 132.96C200.162 133.728 200.146 134.549 200.114 135.424C200.082 136.288 200.05 137.152 200.018 138.016C199.986 138.88 199.97 139.701 199.97 140.48C199.97 140.651 199.895 140.779 199.746 140.864C199.596 140.949 199.452 140.992 199.314 140.992ZM199.33 144.096C199.052 144.096 198.823 144 198.642 143.808C198.46 143.616 198.37 143.392 198.37 143.136C198.37 142.869 198.46 142.645 198.642 142.464C198.823 142.272 199.052 142.176 199.33 142.176C199.586 142.176 199.804 142.272 199.986 142.464C200.178 142.645 200.274 142.869 200.274 143.136C200.274 143.392 200.178 143.616 199.986 143.808C199.804 144 199.586 144.096 199.33 144.096Z\" fill=\"#FF0082\"/> <g class=\"answer\" filter=\"url(#filter1_d_1192_52170)\"> <path d=\"M99 159H162C167.523 159 172 163.477 172 169V188H109C103.477 188 99 183.523 99 178V159Z\" fill=\"white\"/> <path d=\"M99.5 159.5H162C167.247 159.5 171.5 163.753 171.5 169V187.5H109C103.753 187.5 99.5 183.247 99.5 178V159.5Z\" stroke=\"#F7CFE5\"/> <path d=\"M121.219 179C120.995 179 120.785 178.953 120.589 178.86C120.402 178.757 120.309 178.608 120.309 178.412V169.34C120.309 169.144 120.402 168.999 120.589 168.906C120.785 168.813 120.995 168.766 121.219 168.766C121.443 168.766 121.625 168.789 121.765 168.836C121.914 168.883 122.049 168.976 122.171 169.116C122.301 169.247 122.437 169.452 122.577 169.732L125.279 174.954V169.34C125.279 169.135 125.372 168.99 125.559 168.906C125.755 168.813 125.965 168.766 126.189 168.766C126.422 168.766 126.632 168.813 126.819 168.906C127.005 168.99 127.099 169.135 127.099 169.34V178.412C127.099 178.608 127.005 178.757 126.819 178.86C126.632 178.953 126.422 179 126.189 179C125.974 179 125.773 178.958 125.587 178.874C125.409 178.79 125.265 178.641 125.153 178.426L122.129 172.798V178.412C122.129 178.608 122.035 178.757 121.849 178.86C121.662 178.953 121.452 179 121.219 179ZM129.597 179C129.401 179 129.219 178.953 129.051 178.86C128.883 178.757 128.799 178.608 128.799 178.412V169.354C128.799 169.158 128.883 169.013 129.051 168.92C129.219 168.817 129.401 168.766 129.597 168.766H134.581C134.786 168.766 134.931 168.85 135.015 169.018C135.108 169.186 135.155 169.363 135.155 169.55C135.155 169.774 135.104 169.965 135.001 170.124C134.908 170.283 134.768 170.362 134.581 170.362H130.619V173.162H132.747C132.934 173.162 133.074 173.237 133.167 173.386C133.27 173.526 133.321 173.694 133.321 173.89C133.321 174.049 133.274 174.207 133.181 174.366C133.097 174.515 132.952 174.59 132.747 174.59H130.619V177.404H134.581C134.768 177.404 134.908 177.483 135.001 177.642C135.104 177.801 135.155 177.992 135.155 178.216C135.155 178.403 135.108 178.58 135.015 178.748C134.931 178.916 134.786 179 134.581 179H129.597ZM136.755 179.07C136.587 179.07 136.409 179.028 136.223 178.944C136.036 178.86 135.877 178.753 135.747 178.622C135.616 178.482 135.551 178.328 135.551 178.16C135.551 178.057 135.588 177.945 135.663 177.824L138.085 173.876L135.747 169.942C135.663 169.811 135.621 169.681 135.621 169.55C135.621 169.391 135.681 169.247 135.803 169.116C135.924 168.985 136.073 168.883 136.251 168.808C136.437 168.733 136.615 168.696 136.783 168.696C136.932 168.696 137.053 168.733 137.147 168.808C137.249 168.873 137.329 168.967 137.385 169.088L139.289 172.518L141.207 169.088C141.272 168.967 141.351 168.873 141.445 168.808C141.547 168.733 141.669 168.696 141.809 168.696C141.986 168.696 142.163 168.733 142.341 168.808C142.518 168.883 142.667 168.985 142.789 169.116C142.91 169.247 142.971 169.391 142.971 169.55C142.971 169.681 142.929 169.811 142.845 169.942L140.507 173.876L142.929 177.824C143.003 177.945 143.041 178.057 143.041 178.16C143.041 178.328 142.975 178.482 142.845 178.622C142.714 178.753 142.555 178.86 142.369 178.944C142.191 179.028 142.014 179.07 141.837 179.07C141.734 179.07 141.636 179.042 141.543 178.986C141.459 178.93 141.393 178.86 141.347 178.776L139.289 175.178L137.245 178.776C137.198 178.86 137.128 178.93 137.035 178.986C136.951 179.042 136.857 179.07 136.755 179.07ZM146.871 179C146.638 179 146.428 178.953 146.241 178.86C146.054 178.757 145.961 178.608 145.961 178.412V170.404H143.903C143.726 170.404 143.586 170.32 143.483 170.152C143.38 169.984 143.329 169.793 143.329 169.578C143.329 169.382 143.376 169.2 143.469 169.032C143.562 168.855 143.707 168.766 143.903 168.766H149.825C150.03 168.766 150.175 168.855 150.259 169.032C150.352 169.2 150.399 169.382 150.399 169.578C150.399 169.793 150.348 169.984 150.245 170.152C150.152 170.32 150.012 170.404 149.825 170.404H147.781V178.412C147.781 178.608 147.683 178.757 147.487 178.86C147.3 178.953 147.095 179 146.871 179Z\" fill=\"#FF0082\"/> </g> </g> <defs> <filter id=\"filter0_d_1192_52170\" x=\"0\" y=\"0\" width=\"275\" height=\"222\" filterUnits=\"userSpaceOnUse\" color-interpolation-filters=\"sRGB\"> <feFlood flood-opacity=\"0\" result=\"BackgroundImageFix\"/> <feColorMatrix in=\"SourceAlpha\" type=\"matrix\" values=\"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0\" result=\"hardAlpha\"/> <feOffset dx=\"5\" dy=\"5\"/> <feComposite in2=\"hardAlpha\" operator=\"out\"/> <feColorMatrix type=\"matrix\" values=\"0 0 0 0 0.956863 0 0 0 0 0.490196 0 0 0 0 0.380392 0 0 0 1 0\"/> <feBlend mode=\"normal\" in2=\"BackgroundImageFix\" result=\"effect1_dropShadow_1192_52170\"/> <feBlend mode=\"normal\" in=\"SourceGraphic\" in2=\"effect1_dropShadow_1192_52170\" result=\"shape\"/> </filter> <filter id=\"filter1_d_1192_52170\" x=\"99\" y=\"159\" width=\"75\" height=\"31\" filterUnits=\"userSpaceOnUse\" color-interpolation-filters=\"sRGB\"> <feFlood flood-opacity=\"0\" result=\"BackgroundImageFix\"/> <feColorMatrix in=\"SourceAlpha\" type=\"matrix\" values=\"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0\" result=\"hardAlpha\"/> <feOffset dx=\"2\" dy=\"2\"/> <feComposite in2=\"hardAlpha\" operator=\"out\"/> <feColorMatrix type=\"matrix\" values=\"0 0 0 0 1 0 0 0 0 0 0 0 0 0 0.509804 0 0 0 1 0\"/> <feBlend mode=\"normal\" in2=\"BackgroundImageFix\" result=\"effect1_dropShadow_1192_52170\"/> <feBlend mode=\"normal\" in=\"SourceGraphic\" in2=\"effect1_dropShadow_1192_52170\" result=\"shape\"/> </filter> </defs> </svg>") // EJsS HtmlView.HtmlView Page: setting property 'Html' for element 'toys_right'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"toys_wrong", _view.gameScreen) // EJsS HtmlView.HtmlView Page: declaration of element 'toys_wrong'
      .setProperty("Html","<svg width=\"275\" height=\"222\" viewBox=\"0 0 275 222\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"> <g filter=\"url(#filter0_d_1192_52236)\"> <rect width=\"270\" height=\"217\" rx=\"50\" fill=\"#F9E6E0\"/> <rect x=\"0.5\" y=\"0.5\" width=\"269\" height=\"216\" rx=\"49.5\" stroke=\"#FFD208\"/> <path d=\"M50.7009 50.12C49.8209 50.12 49.0276 49.9733 48.3209 49.68C47.6143 49.3733 47.0476 48.8867 46.6209 48.22C46.2076 47.54 46.0009 46.64 46.0009 45.52V39.98C46.0009 38.86 46.2076 37.9667 46.6209 37.3C47.0476 36.62 47.6076 36.1333 48.3009 35.84C49.0076 35.5333 49.8076 35.38 50.7009 35.38C51.5809 35.38 52.3743 35.5333 53.0809 35.84C53.8009 36.1333 54.3676 36.62 54.7809 37.3C55.1943 37.9667 55.4009 38.86 55.4009 39.98V45.52C55.4009 46.64 55.1943 47.54 54.7809 48.22C54.3676 48.8867 53.8009 49.3733 53.0809 49.68C52.3743 49.9733 51.5809 50.12 50.7009 50.12ZM50.7009 47.84C51.3543 47.84 51.8676 47.6533 52.2409 47.28C52.6143 46.9067 52.8009 46.32 52.8009 45.52V39.98C52.8009 39.18 52.6143 38.5933 52.2409 38.22C51.8676 37.8467 51.3543 37.66 50.7009 37.66C50.0476 37.66 49.5343 37.8467 49.1609 38.22C48.8009 38.5933 48.6209 39.18 48.6209 39.98V45.52C48.6209 46.32 48.8009 46.9067 49.1609 47.28C49.5343 47.6533 50.0476 47.84 50.7009 47.84ZM61.4053 50.18C60.632 50.18 59.9186 49.9933 59.2653 49.62C58.612 49.2333 58.0853 48.7267 57.6853 48.1C57.2853 47.4733 57.0853 46.8 57.0853 46.08V44.44C57.0853 43.72 57.2786 43.0533 57.6653 42.44C58.052 41.8133 58.572 41.3133 59.2253 40.94C59.892 40.5667 60.6186 40.38 61.4053 40.38C62.192 40.38 62.912 40.5667 63.5653 40.94C64.232 41.3 64.7586 41.7867 65.1453 42.4C65.5453 43.0133 65.7453 43.6933 65.7453 44.44V46.08C65.7453 46.7867 65.5453 47.4533 65.1453 48.08C64.7453 48.7067 64.212 49.2133 63.5453 49.6C62.892 49.9867 62.1786 50.18 61.4053 50.18ZM61.4053 47.92C61.7253 47.92 62.0186 47.8333 62.2853 47.66C62.552 47.4867 62.7653 47.26 62.9253 46.98C63.0853 46.6867 63.1653 46.3867 63.1653 46.08V44.44C63.1653 44.1333 63.0853 43.8467 62.9253 43.58C62.7653 43.3133 62.552 43.0933 62.2853 42.92C62.032 42.7333 61.7386 42.64 61.4053 42.64C61.0853 42.64 60.792 42.7267 60.5253 42.9C60.2586 43.0733 60.0453 43.3 59.8853 43.58C59.7386 43.8467 59.6653 44.1333 59.6653 44.44V46.08C59.6653 46.3867 59.7386 46.6867 59.8853 46.98C60.0453 47.26 60.2586 47.4867 60.5253 47.66C60.792 47.8333 61.0853 47.92 61.4053 47.92ZM68.6667 54.42C68.3067 54.42 68.0067 54.3333 67.7667 54.16C67.5267 53.9867 67.4067 53.8 67.4067 53.6V41.3C67.4067 41.06 67.5267 40.8667 67.7667 40.72C68.0067 40.5733 68.3001 40.5 68.6467 40.5C68.9934 40.5 69.2734 40.5733 69.4867 40.72C69.7134 40.8667 69.8267 41.06 69.8267 41.3V41.9C70.0534 41.5133 70.4001 41.1667 70.8667 40.86C71.3334 40.54 71.8867 40.38 72.5267 40.38C73.2067 40.38 73.8134 40.5667 74.3467 40.94C74.8934 41.3 75.3201 41.7867 75.6267 42.4C75.9467 43.0133 76.1067 43.6933 76.1067 44.44V46.08C76.1067 46.7867 75.9467 47.4533 75.6267 48.08C75.3067 48.7067 74.8801 49.2133 74.3467 49.6C73.8267 49.9867 73.2467 50.18 72.6067 50.18C72.0201 50.18 71.4867 50.02 71.0067 49.7C70.5267 49.38 70.1867 49.0133 69.9867 48.6V53.6C69.9867 53.8 69.8601 53.9867 69.6067 54.16C69.3534 54.3333 69.0401 54.42 68.6667 54.42ZM71.7667 47.92C72.0867 47.92 72.3734 47.8333 72.6267 47.66C72.8934 47.4733 73.1067 47.24 73.2667 46.96C73.4401 46.68 73.5267 46.3867 73.5267 46.08V44.44C73.5267 44.1333 73.4467 43.8467 73.2867 43.58C73.1267 43.3133 72.9067 43.0933 72.6267 42.92C72.3601 42.7333 72.0601 42.64 71.7267 42.64C71.4334 42.64 71.1534 42.7133 70.8867 42.86C70.6334 43.0067 70.4201 43.2133 70.2467 43.48C70.0734 43.7467 69.9867 44.0667 69.9867 44.44V46.44C69.9867 46.5733 70.0601 46.76 70.2067 47C70.3667 47.2267 70.5801 47.44 70.8467 47.64C71.1134 47.8267 71.4201 47.92 71.7667 47.92ZM80.8578 50.18C80.1911 50.18 79.5778 50.1 79.0178 49.94C78.4711 49.7667 78.0378 49.5467 77.7178 49.28C77.4111 49.0133 77.2578 48.74 77.2578 48.46C77.2578 48.3133 77.2911 48.1533 77.3578 47.98C77.4378 47.8067 77.5378 47.6533 77.6578 47.52C77.7911 47.3867 77.9445 47.32 78.1178 47.32C78.3045 47.32 78.4978 47.4 78.6978 47.56C78.9111 47.7067 79.1711 47.8533 79.4778 48C79.7978 48.1467 80.2378 48.22 80.7978 48.22C81.3978 48.22 81.7911 48.1267 81.9778 47.94C82.1778 47.7533 82.2778 47.56 82.2778 47.36C82.2778 47.0667 82.1578 46.84 81.9178 46.68C81.6911 46.52 81.3978 46.3933 81.0378 46.3C80.6778 46.1933 80.2911 46.08 79.8778 45.96C79.4778 45.84 79.0978 45.6867 78.7378 45.5C78.3778 45.3 78.0845 45.0333 77.8578 44.7C77.6311 44.3533 77.5178 43.9067 77.5178 43.36C77.5178 42.88 77.6311 42.4133 77.8578 41.96C78.0845 41.5067 78.4578 41.1333 78.9778 40.84C79.4978 40.5333 80.2045 40.38 81.0978 40.38C81.6445 40.38 82.1578 40.44 82.6378 40.56C83.1311 40.6667 83.5311 40.82 83.8378 41.02C84.1445 41.22 84.2978 41.44 84.2978 41.68C84.2978 41.8 84.2578 41.96 84.1778 42.16C84.0978 42.3467 83.9845 42.52 83.8378 42.68C83.7045 42.84 83.5378 42.92 83.3378 42.92C83.1911 42.92 83.0111 42.8733 82.7978 42.78C82.5978 42.6733 82.3645 42.5733 82.0978 42.48C81.8311 42.3867 81.5111 42.34 81.1378 42.34C80.8045 42.34 80.5378 42.3867 80.3378 42.48C80.1378 42.5733 79.9911 42.6867 79.8978 42.82C79.8045 42.9533 79.7578 43.0933 79.7578 43.24C79.7578 43.48 79.8711 43.6667 80.0978 43.8C80.3245 43.9333 80.6178 44.0467 80.9778 44.14C81.3511 44.2333 81.7378 44.34 82.1378 44.46C82.5511 44.5667 82.9378 44.7267 83.2978 44.94C83.6711 45.1533 83.9711 45.4467 84.1978 45.82C84.4245 46.18 84.5378 46.6533 84.5378 47.24C84.5378 48.1333 84.2178 48.8467 83.5778 49.38C82.9511 49.9133 82.0445 50.18 80.8578 50.18ZM87.3177 45.96C87.051 45.96 86.8177 45.9 86.6177 45.78C86.4177 45.66 86.3177 45.4667 86.3177 45.2C86.3177 44.32 86.2977 43.3667 86.2577 42.34C86.2177 41.3133 86.171 40.2867 86.1177 39.26C86.0777 38.2333 86.0577 37.28 86.0577 36.4C86.0577 36.0533 86.1777 35.7867 86.4177 35.6C86.6577 35.4 86.9577 35.3 87.3177 35.3C87.651 35.3 87.9377 35.4 88.1777 35.6C88.431 35.7867 88.5577 36.0533 88.5577 36.4C88.5577 37.28 88.5377 38.2333 88.4977 39.26C88.4577 40.2867 88.411 41.3133 88.3577 42.34C88.3177 43.3667 88.2977 44.32 88.2977 45.2C88.2977 45.4667 88.1843 45.66 87.9577 45.78C87.731 45.9 87.5177 45.96 87.3177 45.96ZM87.3377 50.12C86.951 50.12 86.6243 49.9867 86.3577 49.72C86.1043 49.44 85.9777 49.12 85.9777 48.76C85.9777 48.3867 86.1043 48.0667 86.3577 47.8C86.6243 47.5333 86.951 47.4 87.3377 47.4C87.6977 47.4 88.011 47.5333 88.2777 47.8C88.5443 48.0667 88.6777 48.3867 88.6777 48.76C88.6777 49.12 88.5443 49.44 88.2777 49.72C88.011 49.9867 87.6977 50.12 87.3377 50.12ZM98.7556 50C98.4223 50 98.1223 49.9333 97.8556 49.8C97.589 49.6533 97.4556 49.44 97.4556 49.16V37.72H94.5156C94.2623 37.72 94.0623 37.6 93.9156 37.36C93.769 37.12 93.6956 36.8467 93.6956 36.54C93.6956 36.26 93.7623 36 93.8956 35.76C94.029 35.5067 94.2356 35.38 94.5156 35.38H102.976C103.269 35.38 103.476 35.5067 103.596 35.76C103.729 36 103.796 36.26 103.796 36.54C103.796 36.8467 103.722 37.12 103.576 37.36C103.442 37.6 103.242 37.72 102.976 37.72H100.056V49.16C100.056 49.44 99.9156 49.6533 99.6356 49.8C99.369 49.9333 99.0756 50 98.7556 50ZM106.284 50C105.911 50 105.604 49.9133 105.364 49.74C105.124 49.5667 105.004 49.3733 105.004 49.16V35.76C105.004 35.52 105.124 35.3267 105.364 35.18C105.604 35.0333 105.911 34.96 106.284 34.96C106.644 34.96 106.951 35.0333 107.204 35.18C107.458 35.3267 107.584 35.52 107.584 35.76V41.9C107.784 41.5133 108.098 41.1667 108.524 40.86C108.951 40.54 109.478 40.38 110.104 40.38C110.731 40.38 111.304 40.5667 111.824 40.94C112.344 41.3 112.758 41.7867 113.064 42.4C113.384 43.0133 113.544 43.6933 113.544 44.44V49.16C113.544 49.44 113.411 49.6533 113.144 49.8C112.878 49.9333 112.578 50 112.244 50C111.951 50 111.664 49.9333 111.384 49.8C111.104 49.6533 110.964 49.44 110.964 49.16V44.44C110.964 44.1333 110.884 43.8467 110.724 43.58C110.564 43.3133 110.351 43.0933 110.084 42.92C109.831 42.7333 109.544 42.64 109.224 42.64C108.958 42.64 108.698 42.7133 108.444 42.86C108.191 43.0067 107.984 43.2133 107.824 43.48C107.664 43.7467 107.584 44.0667 107.584 44.44V49.16C107.584 49.3733 107.458 49.5667 107.204 49.74C106.951 49.9133 106.644 50 106.284 50ZM117.513 50.18C116.806 50.18 116.193 49.9667 115.673 49.54C115.166 49.1 114.913 48.4267 114.913 47.52C114.913 46.76 115.106 46.1667 115.493 45.74C115.893 45.3133 116.439 45.0133 117.133 44.84C117.839 44.6667 118.653 44.58 119.573 44.58H120.393V44.32C120.393 44.0267 120.333 43.74 120.213 43.46C120.106 43.18 119.926 42.9467 119.673 42.76C119.433 42.5733 119.086 42.48 118.633 42.48C118.126 42.48 117.733 42.5333 117.453 42.64C117.186 42.7333 116.979 42.8333 116.833 42.94C116.686 43.0467 116.526 43.1 116.353 43.1C116.073 43.1 115.853 42.96 115.693 42.68C115.546 42.4 115.473 42.1133 115.473 41.82C115.473 41.54 115.639 41.2933 115.973 41.08C116.319 40.8533 116.739 40.68 117.233 40.56C117.726 40.44 118.206 40.38 118.673 40.38C119.713 40.38 120.546 40.5667 121.173 40.94C121.799 41.3133 122.253 41.7933 122.533 42.38C122.826 42.9667 122.973 43.6 122.973 44.28V49.16C122.973 49.4 122.853 49.6 122.613 49.76C122.373 49.92 122.073 50 121.713 50C121.379 50 121.099 49.92 120.873 49.76C120.659 49.6 120.553 49.4 120.553 49.16V48.6C120.193 49.0133 119.766 49.38 119.273 49.7C118.793 50.02 118.206 50.18 117.513 50.18ZM118.553 48.26C118.833 48.26 119.113 48.1667 119.393 47.98C119.673 47.7933 119.906 47.5533 120.093 47.26C120.293 46.9667 120.393 46.66 120.393 46.34V45.92H120.093C119.653 45.92 119.233 45.9467 118.833 46C118.433 46.0533 118.106 46.1733 117.853 46.36C117.613 46.5333 117.493 46.8067 117.493 47.18C117.493 47.5533 117.593 47.8267 117.793 48C118.006 48.1733 118.259 48.26 118.553 48.26ZM128.547 50C127.347 50 126.427 49.74 125.787 49.22C125.16 48.7 124.847 47.8733 124.847 46.74V37.06C124.847 36.82 124.987 36.6267 125.267 36.48C125.547 36.3333 125.833 36.26 126.127 36.26C126.447 36.26 126.74 36.3333 127.007 36.48C127.287 36.6267 127.427 36.82 127.427 37.06V40.5H129.787C130 40.5 130.16 40.6 130.267 40.8C130.387 40.9867 130.447 41.2 130.447 41.44C130.447 41.68 130.387 41.9 130.267 42.1C130.16 42.2867 130 42.38 129.787 42.38H127.427V46.74C127.427 47.14 127.507 47.42 127.667 47.58C127.84 47.74 128.133 47.82 128.547 47.82H129.327C129.7 47.82 129.973 47.9333 130.147 48.16C130.333 48.3867 130.427 48.6333 130.427 48.9C130.427 49.18 130.333 49.4333 130.147 49.66C129.973 49.8867 129.7 50 129.327 50H128.547ZM132.362 39.78C132.175 39.78 131.982 39.7267 131.782 39.62C131.595 39.5 131.502 39.3267 131.502 39.1C131.502 39.0067 131.528 38.9133 131.582 38.82L132.042 37.76C131.815 37.64 131.635 37.4733 131.502 37.26C131.368 37.0467 131.302 36.8067 131.302 36.54C131.302 36.1667 131.428 35.8467 131.682 35.58C131.948 35.3133 132.268 35.18 132.642 35.18C133.015 35.18 133.335 35.3133 133.602 35.58C133.868 35.8467 134.002 36.16 134.002 36.52C134.002 36.5867 133.988 36.6733 133.962 36.78C133.935 36.8867 133.882 37.04 133.802 37.24C133.735 37.4267 133.628 37.7 133.482 38.06C133.335 38.42 133.135 38.8867 132.882 39.46C132.842 39.5667 132.768 39.6467 132.662 39.7C132.555 39.7533 132.455 39.78 132.362 39.78ZM138.416 50.18C137.75 50.18 137.136 50.1 136.576 49.94C136.03 49.7667 135.596 49.5467 135.276 49.28C134.97 49.0133 134.816 48.74 134.816 48.46C134.816 48.3133 134.85 48.1533 134.916 47.98C134.996 47.8067 135.096 47.6533 135.216 47.52C135.35 47.3867 135.503 47.32 135.676 47.32C135.863 47.32 136.056 47.4 136.256 47.56C136.47 47.7067 136.73 47.8533 137.036 48C137.356 48.1467 137.796 48.22 138.356 48.22C138.956 48.22 139.35 48.1267 139.536 47.94C139.736 47.7533 139.836 47.56 139.836 47.36C139.836 47.0667 139.716 46.84 139.476 46.68C139.25 46.52 138.956 46.3933 138.596 46.3C138.236 46.1933 137.85 46.08 137.436 45.96C137.036 45.84 136.656 45.6867 136.296 45.5C135.936 45.3 135.643 45.0333 135.416 44.7C135.19 44.3533 135.076 43.9067 135.076 43.36C135.076 42.88 135.19 42.4133 135.416 41.96C135.643 41.5067 136.016 41.1333 136.536 40.84C137.056 40.5333 137.763 40.38 138.656 40.38C139.203 40.38 139.716 40.44 140.196 40.56C140.69 40.6667 141.09 40.82 141.396 41.02C141.703 41.22 141.856 41.44 141.856 41.68C141.856 41.8 141.816 41.96 141.736 42.16C141.656 42.3467 141.543 42.52 141.396 42.68C141.263 42.84 141.096 42.92 140.896 42.92C140.75 42.92 140.57 42.8733 140.356 42.78C140.156 42.6733 139.923 42.5733 139.656 42.48C139.39 42.3867 139.07 42.34 138.696 42.34C138.363 42.34 138.096 42.3867 137.896 42.48C137.696 42.5733 137.55 42.6867 137.456 42.82C137.363 42.9533 137.316 43.0933 137.316 43.24C137.316 43.48 137.43 43.6667 137.656 43.8C137.883 43.9333 138.176 44.0467 138.536 44.14C138.91 44.2333 139.296 44.34 139.696 44.46C140.11 44.5667 140.496 44.7267 140.856 44.94C141.23 45.1533 141.53 45.4467 141.756 45.82C141.983 46.18 142.096 46.6533 142.096 47.24C142.096 48.1333 141.776 48.8467 141.136 49.38C140.51 49.9133 139.603 50.18 138.416 50.18ZM149.16 50C148.84 50 148.54 49.9333 148.26 49.8C147.993 49.6533 147.86 49.44 147.86 49.16V36.2C147.86 35.9067 147.993 35.7 148.26 35.58C148.54 35.4467 148.84 35.38 149.16 35.38C149.493 35.38 149.793 35.4467 150.06 35.58C150.327 35.7 150.46 35.9067 150.46 36.2V49.16C150.46 49.44 150.327 49.6533 150.06 49.8C149.793 49.9333 149.493 50 149.16 50ZM153.94 50C153.567 50 153.26 49.9133 153.02 49.74C152.78 49.5667 152.66 49.3733 152.66 49.16V41.3C152.66 41.06 152.78 40.8667 153.02 40.72C153.26 40.5733 153.567 40.5 153.94 40.5C154.26 40.5 154.527 40.5733 154.74 40.72C154.967 40.8667 155.08 41.06 155.08 41.3V41.9C155.28 41.5133 155.607 41.1667 156.06 40.86C156.527 40.54 157.093 40.38 157.76 40.38C158.387 40.38 158.96 40.5667 159.48 40.94C160 41.3 160.413 41.7867 160.72 42.4C161.04 43.0133 161.2 43.6933 161.2 44.44V49.16C161.2 49.44 161.067 49.6533 160.8 49.8C160.533 49.9333 160.233 50 159.9 50C159.607 50 159.32 49.9333 159.04 49.8C158.76 49.6533 158.62 49.44 158.62 49.16V44.44C158.62 44.1333 158.54 43.8467 158.38 43.58C158.233 43.3133 158.027 43.0933 157.76 42.92C157.493 42.7333 157.2 42.64 156.88 42.64C156.613 42.64 156.353 42.7133 156.1 42.86C155.847 43.0067 155.64 43.2133 155.48 43.48C155.32 43.7467 155.24 44.0667 155.24 44.44V49.16C155.24 49.3733 155.113 49.5667 154.86 49.74C154.607 49.9133 154.3 50 153.94 50ZM167.149 50.18C166.136 50.18 165.309 50 164.669 49.64C164.029 49.28 163.556 48.7933 163.249 48.18C162.942 47.5533 162.789 46.8533 162.789 46.08V44.48C162.789 43.7067 162.936 43.0133 163.229 42.4C163.536 41.7733 164.009 41.28 164.649 40.92C165.302 40.56 166.122 40.38 167.109 40.38C167.736 40.38 168.289 40.4533 168.769 40.6C169.249 40.7467 169.629 40.94 169.909 41.18C170.189 41.42 170.329 41.6733 170.329 41.94C170.329 42.1 170.282 42.28 170.189 42.48C170.109 42.6667 169.989 42.8333 169.829 42.98C169.682 43.1267 169.509 43.2 169.309 43.2C169.162 43.2 169.009 43.1533 168.849 43.06C168.702 42.9667 168.509 42.8733 168.269 42.78C168.029 42.6867 167.709 42.64 167.309 42.64C166.629 42.64 166.136 42.8067 165.829 43.14C165.522 43.46 165.369 43.9067 165.369 44.48V46.08C165.369 46.6533 165.522 47.1067 165.829 47.44C166.136 47.76 166.636 47.92 167.329 47.92C167.742 47.92 168.062 47.8667 168.289 47.76C168.516 47.6533 168.702 47.5533 168.849 47.46C169.009 47.3667 169.169 47.32 169.329 47.32C169.569 47.32 169.769 47.3867 169.929 47.52C170.102 47.6533 170.229 47.82 170.309 48.02C170.402 48.2067 170.449 48.38 170.449 48.54C170.449 48.8067 170.302 49.0667 170.009 49.32C169.729 49.5733 169.336 49.78 168.829 49.94C168.336 50.1 167.776 50.18 167.149 50.18ZM175.644 50.18C174.87 50.18 174.157 49.9933 173.504 49.62C172.85 49.2333 172.324 48.7267 171.924 48.1C171.524 47.4733 171.324 46.8 171.324 46.08V44.44C171.324 43.72 171.517 43.0533 171.904 42.44C172.29 41.8133 172.81 41.3133 173.464 40.94C174.13 40.5667 174.857 40.38 175.644 40.38C176.43 40.38 177.15 40.5667 177.804 40.94C178.47 41.3 178.997 41.7867 179.384 42.4C179.784 43.0133 179.984 43.6933 179.984 44.44V46.08C179.984 46.7867 179.784 47.4533 179.384 48.08C178.984 48.7067 178.45 49.2133 177.784 49.6C177.13 49.9867 176.417 50.18 175.644 50.18ZM175.644 47.92C175.964 47.92 176.257 47.8333 176.524 47.66C176.79 47.4867 177.004 47.26 177.164 46.98C177.324 46.6867 177.404 46.3867 177.404 46.08V44.44C177.404 44.1333 177.324 43.8467 177.164 43.58C177.004 43.3133 176.79 43.0933 176.524 42.92C176.27 42.7333 175.977 42.64 175.644 42.64C175.324 42.64 175.03 42.7267 174.764 42.9C174.497 43.0733 174.284 43.3 174.124 43.58C173.977 43.8467 173.904 44.1333 173.904 44.44V46.08C173.904 46.3867 173.977 46.6867 174.124 46.98C174.284 47.26 174.497 47.4867 174.764 47.66C175.03 47.8333 175.324 47.92 175.644 47.92ZM182.885 50C182.525 50 182.225 49.9133 181.985 49.74C181.745 49.5667 181.625 49.3733 181.625 49.16V41.3C181.625 41.06 181.745 40.8667 181.985 40.72C182.225 40.5733 182.525 40.5 182.885 40.5C183.218 40.5 183.492 40.5733 183.705 40.72C183.932 40.8667 184.045 41.06 184.045 41.3V42.12C184.192 41.8267 184.385 41.5533 184.625 41.3C184.878 41.0333 185.165 40.8133 185.485 40.64C185.805 40.4667 186.145 40.38 186.505 40.38H187.125C187.378 40.38 187.598 40.4933 187.785 40.72C187.972 40.9333 188.065 41.1933 188.065 41.5C188.065 41.82 187.972 42.0933 187.785 42.32C187.598 42.5333 187.378 42.64 187.125 42.64H186.505C186.132 42.64 185.765 42.7667 185.405 43.02C185.058 43.26 184.772 43.6 184.545 44.04C184.318 44.4667 184.205 44.9867 184.205 45.6V49.16C184.205 49.3733 184.078 49.5667 183.825 49.74C183.572 49.9133 183.258 50 182.885 50ZM190.385 50C190.025 50 189.725 49.9133 189.485 49.74C189.245 49.5667 189.125 49.3733 189.125 49.16V41.3C189.125 41.06 189.245 40.8667 189.485 40.72C189.725 40.5733 190.025 40.5 190.385 40.5C190.718 40.5 190.992 40.5733 191.205 40.72C191.432 40.8667 191.545 41.06 191.545 41.3V42.12C191.692 41.8267 191.885 41.5533 192.125 41.3C192.378 41.0333 192.665 40.8133 192.985 40.64C193.305 40.4667 193.645 40.38 194.005 40.38H194.625C194.878 40.38 195.098 40.4933 195.285 40.72C195.472 40.9333 195.565 41.1933 195.565 41.5C195.565 41.82 195.472 42.0933 195.285 42.32C195.098 42.5333 194.878 42.64 194.625 42.64H194.005C193.632 42.64 193.265 42.7667 192.905 43.02C192.558 43.26 192.272 43.6 192.045 44.04C191.818 44.4667 191.705 44.9867 191.705 45.6V49.16C191.705 49.3733 191.578 49.5667 191.325 49.74C191.072 49.9133 190.758 50 190.385 50ZM200.871 50.18C199.924 50.18 199.084 50.0133 198.351 49.68C197.631 49.3333 197.064 48.8533 196.651 48.24C196.237 47.6133 196.031 46.8933 196.031 46.08V44.38C196.031 43.66 196.224 43 196.611 42.4C197.011 41.7867 197.537 41.3 198.191 40.94C198.857 40.5667 199.597 40.38 200.411 40.38C201.157 40.38 201.837 40.54 202.451 40.86C203.077 41.18 203.584 41.62 203.971 42.18C204.357 42.74 204.551 43.3933 204.551 44.14C204.551 44.7133 204.457 45.1267 204.271 45.38C204.084 45.62 203.844 45.7733 203.551 45.84C203.271 45.8933 202.977 45.92 202.671 45.92H198.611V46.22C198.611 46.7933 198.824 47.26 199.251 47.62C199.691 47.9667 200.257 48.14 200.951 48.14C201.391 48.14 201.757 48.0733 202.051 47.94C202.344 47.8067 202.597 47.68 202.811 47.56C203.024 47.44 203.224 47.38 203.411 47.38C203.611 47.38 203.784 47.4467 203.931 47.58C204.077 47.7133 204.191 47.8733 204.271 48.06C204.351 48.2333 204.391 48.3867 204.391 48.52C204.391 48.7467 204.244 48.9933 203.951 49.26C203.671 49.5133 203.264 49.7333 202.731 49.92C202.211 50.0933 201.591 50.18 200.871 50.18ZM198.611 44.4H201.531C201.757 44.4 201.911 44.3667 201.991 44.3C202.084 44.22 202.131 44.0733 202.131 43.86C202.131 43.5533 202.044 43.28 201.871 43.04C201.711 42.8 201.497 42.6133 201.231 42.48C200.977 42.3467 200.691 42.28 200.371 42.28C200.064 42.28 199.777 42.3467 199.511 42.48C199.244 42.6 199.024 42.78 198.851 43.02C198.691 43.2467 198.611 43.52 198.611 43.84V44.4ZM210.118 50.18C209.104 50.18 208.278 50 207.638 49.64C206.998 49.28 206.524 48.7933 206.218 48.18C205.911 47.5533 205.758 46.8533 205.758 46.08V44.48C205.758 43.7067 205.904 43.0133 206.198 42.4C206.504 41.7733 206.978 41.28 207.618 40.92C208.271 40.56 209.091 40.38 210.078 40.38C210.704 40.38 211.258 40.4533 211.738 40.6C212.218 40.7467 212.598 40.94 212.878 41.18C213.158 41.42 213.298 41.6733 213.298 41.94C213.298 42.1 213.251 42.28 213.158 42.48C213.078 42.6667 212.958 42.8333 212.798 42.98C212.651 43.1267 212.478 43.2 212.278 43.2C212.131 43.2 211.978 43.1533 211.818 43.06C211.671 42.9667 211.478 42.8733 211.238 42.78C210.998 42.6867 210.678 42.64 210.278 42.64C209.598 42.64 209.104 42.8067 208.798 43.14C208.491 43.46 208.338 43.9067 208.338 44.48V46.08C208.338 46.6533 208.491 47.1067 208.798 47.44C209.104 47.76 209.604 47.92 210.298 47.92C210.711 47.92 211.031 47.8667 211.258 47.76C211.484 47.6533 211.671 47.5533 211.818 47.46C211.978 47.3667 212.138 47.32 212.298 47.32C212.538 47.32 212.738 47.3867 212.898 47.52C213.071 47.6533 213.198 47.82 213.278 48.02C213.371 48.2067 213.418 48.38 213.418 48.54C213.418 48.8067 213.271 49.0667 212.978 49.32C212.698 49.5733 212.304 49.78 211.798 49.94C211.304 50.1 210.744 50.18 210.118 50.18ZM218.41 50C217.21 50 216.29 49.74 215.65 49.22C215.023 48.7 214.71 47.8733 214.71 46.74V37.06C214.71 36.82 214.85 36.6267 215.13 36.48C215.41 36.3333 215.697 36.26 215.99 36.26C216.31 36.26 216.603 36.3333 216.87 36.48C217.15 36.6267 217.29 36.82 217.29 37.06V40.5H219.65C219.863 40.5 220.023 40.6 220.13 40.8C220.25 40.9867 220.31 41.2 220.31 41.44C220.31 41.68 220.25 41.9 220.13 42.1C220.023 42.2867 219.863 42.38 219.65 42.38H217.29V46.74C217.29 47.14 217.37 47.42 217.53 47.58C217.703 47.74 217.997 47.82 218.41 47.82H219.19C219.563 47.82 219.837 47.9333 220.01 48.16C220.197 48.3867 220.29 48.6333 220.29 48.9C220.29 49.18 220.197 49.4333 220.01 49.66C219.837 49.8867 219.563 50 219.19 50H218.41ZM222.845 45.96C222.578 45.96 222.345 45.9 222.145 45.78C221.945 45.66 221.845 45.4667 221.845 45.2C221.845 44.32 221.825 43.3667 221.785 42.34C221.745 41.3133 221.698 40.2867 221.645 39.26C221.605 38.2333 221.585 37.28 221.585 36.4C221.585 36.0533 221.705 35.7867 221.945 35.6C222.185 35.4 222.485 35.3 222.845 35.3C223.178 35.3 223.465 35.4 223.705 35.6C223.958 35.7867 224.085 36.0533 224.085 36.4C224.085 37.28 224.065 38.2333 224.025 39.26C223.985 40.2867 223.938 41.3133 223.885 42.34C223.845 43.3667 223.825 44.32 223.825 45.2C223.825 45.4667 223.712 45.66 223.485 45.78C223.258 45.9 223.045 45.96 222.845 45.96ZM222.865 50.12C222.478 50.12 222.152 49.9867 221.885 49.72C221.632 49.44 221.505 49.12 221.505 48.76C221.505 48.3867 221.632 48.0667 221.885 47.8C222.152 47.5333 222.478 47.4 222.865 47.4C223.225 47.4 223.538 47.5333 223.805 47.8C224.072 48.0667 224.205 48.3867 224.205 48.76C224.205 49.12 224.072 49.44 223.805 49.72C223.538 49.9867 223.225 50.12 222.865 50.12Z\" fill=\"#FF0082\"/> <path d=\"M48.0558 84C47.8425 84 47.6451 83.952 47.4638 83.856C47.2931 83.76 47.2078 83.6213 47.2078 83.44V73.856H44.7278C44.5571 73.856 44.4238 73.776 44.3278 73.616C44.2318 73.456 44.1838 73.2747 44.1838 73.072C44.1838 72.88 44.2265 72.704 44.3118 72.544C44.3971 72.384 44.5358 72.304 44.7278 72.304H51.3678C51.5705 72.304 51.7145 72.384 51.7998 72.544C51.8851 72.704 51.9278 72.8747 51.9278 73.056C51.9278 73.2693 51.8798 73.456 51.7838 73.616C51.6985 73.776 51.5598 73.856 51.3678 73.856H48.9038V83.44C48.9038 83.6213 48.8131 83.76 48.6318 83.856C48.4611 83.952 48.2691 84 48.0558 84ZM54.5048 84.128C53.9288 84.128 53.3901 83.9787 52.8888 83.68C52.3875 83.3813 51.9821 82.992 51.6728 82.512C51.3741 82.0213 51.2248 81.4987 51.2248 80.944V79.472C51.2248 78.9067 51.3688 78.384 51.6568 77.904C51.9555 77.424 52.3555 77.04 52.8568 76.752C53.3688 76.464 53.9235 76.32 54.5208 76.32C55.1181 76.32 55.6675 76.464 56.1688 76.752C56.6701 77.0293 57.0701 77.408 57.3688 77.888C57.6781 78.3573 57.8328 78.8853 57.8328 79.472V80.944C57.8328 81.488 57.6781 82.0053 57.3688 82.496C57.0701 82.9867 56.6648 83.3813 56.1528 83.68C55.6515 83.9787 55.1021 84.128 54.5048 84.128ZM54.5208 82.64C54.8195 82.64 55.0915 82.56 55.3368 82.4C55.5821 82.24 55.7795 82.032 55.9288 81.776C56.0781 81.5093 56.1528 81.232 56.1528 80.944V79.472C56.1528 79.1947 56.0781 78.928 55.9288 78.672C55.7795 78.416 55.5821 78.208 55.3368 78.048C55.0915 77.888 54.8195 77.808 54.5208 77.808C54.2115 77.808 53.9341 77.888 53.6888 78.048C53.4541 78.208 53.2621 78.416 53.1128 78.672C52.9741 78.928 52.9048 79.1947 52.9048 79.472V80.944C52.9048 81.232 52.9741 81.5093 53.1128 81.776C53.2621 82.032 53.4595 82.24 53.7048 82.4C53.9501 82.56 54.2221 82.64 54.5208 82.64ZM59.2948 87.6C59.0815 87.6 58.9001 87.552 58.7508 87.456C58.6015 87.3707 58.5268 87.1787 58.5268 86.88C58.5268 86.688 58.5588 86.5173 58.6228 86.368C58.6868 86.2293 58.8041 86.16 58.9748 86.16C59.1775 86.16 59.3961 86.1067 59.6308 86C59.8761 85.904 60.1108 85.744 60.3348 85.52C60.5695 85.3067 60.7668 85.0347 60.9268 84.704C61.0975 84.3733 61.2148 83.984 61.2788 83.536L58.5748 77.328C58.5321 77.2533 58.5108 77.1787 58.5108 77.104C58.5108 76.9653 58.5695 76.8373 58.6868 76.72C58.8148 76.592 58.9641 76.4907 59.1348 76.416C59.3055 76.3413 59.4655 76.304 59.6148 76.304C59.7215 76.304 59.8228 76.3307 59.9188 76.384C60.0255 76.4267 60.0948 76.5013 60.1268 76.608L62.1428 81.808L63.8868 76.608C63.9188 76.5013 63.9828 76.4267 64.0788 76.384C64.1748 76.3307 64.2708 76.304 64.3668 76.304C64.4948 76.304 64.6441 76.3413 64.8148 76.416C64.9961 76.4907 65.1508 76.592 65.2788 76.72C65.4175 76.8373 65.4868 76.976 65.4868 77.136C65.4868 77.2213 65.4708 77.2853 65.4388 77.328L63.0388 83.584C62.8681 84.0427 62.6921 84.5067 62.5108 84.976C62.3295 85.456 62.1055 85.8933 61.8388 86.288C61.5828 86.6827 61.2468 86.9973 60.8308 87.232C60.4255 87.4773 59.9135 87.6 59.2948 87.6ZM68.8484 84.128C68.3258 84.128 67.8564 84.064 67.4404 83.936C67.0244 83.808 66.6938 83.648 66.4484 83.456C66.2138 83.2533 66.0964 83.0507 66.0964 82.848C66.0964 82.752 66.1178 82.6453 66.1604 82.528C66.2138 82.4107 66.2831 82.3093 66.3684 82.224C66.4644 82.1387 66.5658 82.096 66.6724 82.096C66.8111 82.096 66.9551 82.16 67.1044 82.288C67.2644 82.4053 67.4724 82.528 67.7284 82.656C67.9844 82.7733 68.3418 82.832 68.8004 82.832C69.3338 82.832 69.6911 82.7413 69.8724 82.56C70.0644 82.3787 70.1604 82.1813 70.1604 81.968C70.1604 81.6907 70.0644 81.4773 69.8724 81.328C69.6911 81.168 69.4511 81.04 69.1524 80.944C68.8644 80.848 68.5551 80.7573 68.2244 80.672C67.8938 80.576 67.5791 80.4533 67.2804 80.304C66.9924 80.1547 66.7524 79.9467 66.5604 79.68C66.3791 79.4133 66.2884 79.0613 66.2884 78.624C66.2884 78.2613 66.3791 77.904 66.5604 77.552C66.7418 77.1893 67.0298 76.896 67.4244 76.672C67.8298 76.4373 68.3684 76.32 69.0404 76.32C69.4458 76.32 69.8298 76.3627 70.1924 76.448C70.5551 76.5333 70.8538 76.6507 71.0884 76.8C71.3231 76.9387 71.4404 77.0933 71.4404 77.264C71.4404 77.3387 71.4138 77.4453 71.3604 77.584C71.3071 77.712 71.2324 77.8293 71.1364 77.936C71.0511 78.032 70.9391 78.08 70.8004 78.08C70.6938 78.08 70.5604 78.0427 70.4004 77.968C70.2404 77.8827 70.0538 77.8027 69.8404 77.728C69.6271 77.6533 69.3658 77.616 69.0564 77.616C68.7471 77.616 68.4964 77.6693 68.3044 77.776C68.1231 77.872 67.9898 77.9893 67.9044 78.128C67.8191 78.2667 67.7764 78.4053 67.7764 78.544C67.7764 78.7787 67.8671 78.96 68.0484 79.088C68.2298 79.216 68.4698 79.3227 68.7684 79.408C69.0671 79.4933 69.3818 79.584 69.7124 79.68C70.0431 79.7653 70.3524 79.8933 70.6404 80.064C70.9391 80.2347 71.1791 80.464 71.3604 80.752C71.5524 81.04 71.6484 81.424 71.6484 81.904C71.6484 82.576 71.4031 83.1147 70.9124 83.52C70.4324 83.9253 69.7444 84.128 68.8484 84.128ZM77.0636 74.512C76.7969 74.512 76.5676 74.4213 76.3756 74.24C76.1836 74.0587 76.0876 73.856 76.0876 73.632C76.0876 73.3867 76.1836 73.1787 76.3756 73.008C76.5676 72.8373 76.7969 72.752 77.0636 72.752C77.3302 72.752 77.5542 72.8373 77.7356 73.008C77.9276 73.1787 78.0236 73.3867 78.0236 73.632C78.0236 73.856 77.9276 74.0587 77.7356 74.24C77.5542 74.4213 77.3302 74.512 77.0636 74.512ZM77.0636 84C76.8182 84 76.6156 83.9413 76.4556 83.824C76.3062 83.7067 76.2316 83.5787 76.2316 83.44V76.96C76.2316 76.8 76.3062 76.672 76.4556 76.576C76.6156 76.4693 76.8182 76.416 77.0636 76.416C77.2982 76.416 77.4956 76.4693 77.6556 76.576C77.8262 76.672 77.9116 76.8 77.9116 76.96V83.44C77.9116 83.5787 77.8262 83.7067 77.6556 83.824C77.4956 83.9413 77.2982 84 77.0636 84ZM80.4854 84C80.2401 84 80.0374 83.9413 79.8774 83.824C79.7281 83.7067 79.6534 83.5787 79.6534 83.44V76.96C79.6534 76.8 79.7281 76.672 79.8774 76.576C80.0374 76.4693 80.2401 76.416 80.4854 76.416C80.6881 76.416 80.8641 76.4693 81.0134 76.576C81.1628 76.672 81.2374 76.8 81.2374 76.96V77.536C81.3974 77.2267 81.6588 76.9493 82.0214 76.704C82.3948 76.448 82.8481 76.32 83.3814 76.32C83.8828 76.32 84.3414 76.464 84.7574 76.752C85.1841 77.0293 85.5254 77.408 85.7814 77.888C86.0374 78.3573 86.1654 78.8853 86.1654 79.472V83.44C86.1654 83.6213 86.0748 83.76 85.8934 83.856C85.7228 83.952 85.5308 84 85.3174 84C85.1254 84 84.9388 83.952 84.7574 83.856C84.5761 83.76 84.4854 83.6213 84.4854 83.44V79.472C84.4854 79.1947 84.4108 78.928 84.2614 78.672C84.1228 78.416 83.9308 78.208 83.6854 78.048C83.4401 77.888 83.1681 77.808 82.8694 77.808C82.6134 77.808 82.3681 77.8773 82.1334 78.016C81.8988 78.144 81.7068 78.3307 81.5574 78.576C81.4081 78.8213 81.3334 79.12 81.3334 79.472V83.44C81.3334 83.5787 81.2481 83.7067 81.0774 83.824C80.9174 83.9413 80.7201 84 80.4854 84ZM91.8761 87.6C91.6414 87.6 91.4441 87.5413 91.2841 87.424C91.1347 87.3067 91.0601 87.1787 91.0601 87.04V76.96C91.0601 76.8 91.1347 76.672 91.2841 76.576C91.4441 76.4693 91.6361 76.416 91.8601 76.416C92.0841 76.416 92.2707 76.4693 92.4201 76.576C92.5694 76.672 92.6441 76.8 92.6441 76.96V77.536C92.8254 77.2267 93.0974 76.9493 93.4601 76.704C93.8334 76.448 94.2761 76.32 94.7881 76.32C95.3214 76.32 95.8067 76.464 96.2441 76.752C96.6814 77.0293 97.0281 77.408 97.2841 77.888C97.5401 78.3573 97.6681 78.8853 97.6681 79.472V80.944C97.6681 81.4987 97.5347 82.0213 97.2681 82.512C97.0121 82.992 96.6707 83.3813 96.2441 83.68C95.8174 83.9787 95.3534 84.128 94.8521 84.128C94.3721 84.128 93.9401 84.0053 93.5561 83.76C93.1721 83.504 92.9001 83.2107 92.7401 82.88V87.04C92.7401 87.1787 92.6547 87.3067 92.4841 87.424C92.3241 87.5413 92.1214 87.6 91.8761 87.6ZM94.3561 82.64C94.6441 82.64 94.9107 82.56 95.1561 82.4C95.4014 82.24 95.5987 82.0267 95.7481 81.76C95.9081 81.4933 95.9881 81.2213 95.9881 80.944V79.472C95.9881 79.1947 95.9134 78.928 95.7641 78.672C95.6147 78.416 95.4121 78.208 95.1561 78.048C94.9107 77.888 94.6334 77.808 94.3241 77.808C94.0681 77.808 93.8174 77.8773 93.5721 78.016C93.3267 78.144 93.1241 78.3307 92.9641 78.576C92.8147 78.8213 92.7401 79.12 92.7401 79.472V81.312C92.7401 81.44 92.8094 81.6107 92.9481 81.824C93.0867 82.0267 93.2787 82.2133 93.5241 82.384C93.7694 82.5547 94.0467 82.64 94.3561 82.64ZM102.13 84.128C101.554 84.128 101.015 83.9787 100.514 83.68C100.012 83.3813 99.6071 82.992 99.2978 82.512C98.9991 82.0213 98.8498 81.4987 98.8498 80.944V79.472C98.8498 78.9067 98.9938 78.384 99.2818 77.904C99.5805 77.424 99.9805 77.04 100.482 76.752C100.994 76.464 101.548 76.32 102.146 76.32C102.743 76.32 103.292 76.464 103.794 76.752C104.295 77.0293 104.695 77.408 104.994 77.888C105.303 78.3573 105.458 78.8853 105.458 79.472V80.944C105.458 81.488 105.303 82.0053 104.994 82.496C104.695 82.9867 104.29 83.3813 103.778 83.68C103.276 83.9787 102.727 84.128 102.13 84.128ZM102.146 82.64C102.444 82.64 102.716 82.56 102.962 82.4C103.207 82.24 103.404 82.032 103.554 81.776C103.703 81.5093 103.778 81.232 103.778 80.944V79.472C103.778 79.1947 103.703 78.928 103.554 78.672C103.404 78.416 103.207 78.208 102.962 78.048C102.716 77.888 102.444 77.808 102.146 77.808C101.836 77.808 101.559 77.888 101.314 78.048C101.079 78.208 100.887 78.416 100.738 78.672C100.599 78.928 100.53 79.1947 100.53 79.472V80.944C100.53 81.232 100.599 81.5093 100.738 81.776C100.887 82.032 101.084 82.24 101.33 82.4C101.575 82.56 101.847 82.64 102.146 82.64ZM109.911 84.128C109.335 84.128 108.796 83.9787 108.295 83.68C107.794 83.3813 107.388 82.992 107.079 82.512C106.78 82.0213 106.631 81.4987 106.631 80.944V79.472C106.631 78.9067 106.775 78.384 107.063 77.904C107.362 77.424 107.762 77.04 108.263 76.752C108.775 76.464 109.33 76.32 109.927 76.32C110.524 76.32 111.074 76.464 111.575 76.752C112.076 77.0293 112.476 77.408 112.775 77.888C113.084 78.3573 113.239 78.8853 113.239 79.472V80.944C113.239 81.488 113.084 82.0053 112.775 82.496C112.476 82.9867 112.071 83.3813 111.559 83.68C111.058 83.9787 110.508 84.128 109.911 84.128ZM109.927 82.64C110.226 82.64 110.498 82.56 110.743 82.4C110.988 82.24 111.186 82.032 111.335 81.776C111.484 81.5093 111.559 81.232 111.559 80.944V79.472C111.559 79.1947 111.484 78.928 111.335 78.672C111.186 78.416 110.988 78.208 110.743 78.048C110.498 77.888 110.226 77.808 109.927 77.808C109.618 77.808 109.34 77.888 109.095 78.048C108.86 78.208 108.668 78.416 108.519 78.672C108.38 78.928 108.311 79.1947 108.311 79.472V80.944C108.311 81.232 108.38 81.5093 108.519 81.776C108.668 82.032 108.866 82.24 109.111 82.4C109.356 82.56 109.628 82.64 109.927 82.64ZM115.516 84C115.282 84 115.084 83.9413 114.924 83.824C114.775 83.7067 114.7 83.5787 114.7 83.44V76.96C114.7 76.8 114.775 76.672 114.924 76.576C115.084 76.4693 115.282 76.416 115.516 76.416C115.73 76.416 115.911 76.4693 116.06 76.576C116.21 76.672 116.284 76.8 116.284 76.96V77.664C116.402 77.44 116.556 77.2267 116.748 77.024C116.951 76.8213 117.186 76.656 117.452 76.528C117.719 76.3893 118.007 76.32 118.316 76.32H118.828C118.999 76.32 119.148 76.3947 119.276 76.544C119.404 76.6827 119.468 76.8533 119.468 77.056C119.468 77.2587 119.404 77.4347 119.276 77.584C119.148 77.7333 118.999 77.808 118.828 77.808H118.316C117.996 77.808 117.687 77.904 117.388 78.096C117.09 78.288 116.844 78.56 116.652 78.912C116.471 79.2533 116.38 79.6693 116.38 80.16V83.44C116.38 83.5787 116.295 83.7067 116.124 83.824C115.964 83.9413 115.762 84 115.516 84ZM126.71 84.128C125.942 84.128 125.307 83.9893 124.806 83.712C124.315 83.4347 123.952 83.056 123.718 82.576C123.483 82.096 123.366 81.552 123.366 80.944V79.504C123.366 78.9067 123.483 78.368 123.718 77.888C123.952 77.3973 124.315 77.0133 124.806 76.736C125.296 76.4587 125.92 76.32 126.678 76.32C127.168 76.32 127.595 76.3787 127.958 76.496C128.331 76.6133 128.619 76.7627 128.822 76.944C129.035 77.1147 129.142 77.296 129.142 77.488C129.142 77.584 129.11 77.7013 129.046 77.84C128.992 77.968 128.912 78.08 128.806 78.176C128.71 78.2613 128.592 78.304 128.454 78.304C128.347 78.304 128.23 78.2613 128.102 78.176C127.984 78.0907 127.824 78.0107 127.622 77.936C127.419 77.8507 127.147 77.808 126.806 77.808C126.208 77.808 125.766 77.9573 125.478 78.256C125.19 78.5547 125.046 78.9707 125.046 79.504V80.944C125.046 81.4773 125.19 81.8933 125.478 82.192C125.766 82.4907 126.214 82.64 126.822 82.64C127.174 82.64 127.451 82.5973 127.654 82.512C127.856 82.416 128.016 82.3253 128.134 82.24C128.262 82.1547 128.384 82.112 128.502 82.112C128.651 82.112 128.779 82.1547 128.886 82.24C129.003 82.3253 129.088 82.432 129.142 82.56C129.206 82.688 129.238 82.8053 129.238 82.912C129.238 83.0933 129.126 83.28 128.902 83.472C128.688 83.664 128.39 83.824 128.006 83.952C127.632 84.0693 127.2 84.128 126.71 84.128ZM133.349 84.128C132.773 84.128 132.234 83.9787 131.733 83.68C131.231 83.3813 130.826 82.992 130.517 82.512C130.218 82.0213 130.069 81.4987 130.069 80.944V79.472C130.069 78.9067 130.213 78.384 130.501 77.904C130.799 77.424 131.199 77.04 131.701 76.752C132.213 76.464 132.767 76.32 133.365 76.32C133.962 76.32 134.511 76.464 135.013 76.752C135.514 77.0293 135.914 77.408 136.213 77.888C136.522 78.3573 136.677 78.8853 136.677 79.472V80.944C136.677 81.488 136.522 82.0053 136.213 82.496C135.914 82.9867 135.509 83.3813 134.997 83.68C134.495 83.9787 133.946 84.128 133.349 84.128ZM133.365 82.64C133.663 82.64 133.935 82.56 134.181 82.4C134.426 82.24 134.623 82.032 134.773 81.776C134.922 81.5093 134.997 81.232 134.997 80.944V79.472C134.997 79.1947 134.922 78.928 134.773 78.672C134.623 78.416 134.426 78.208 134.181 78.048C133.935 77.888 133.663 77.808 133.365 77.808C133.055 77.808 132.778 77.888 132.533 78.048C132.298 78.208 132.106 78.416 131.957 78.672C131.818 78.928 131.749 79.1947 131.749 79.472V80.944C131.749 81.232 131.818 81.5093 131.957 81.776C132.106 82.032 132.303 82.24 132.549 82.4C132.794 82.56 133.066 82.64 133.365 82.64ZM138.97 84C138.724 84 138.522 83.9413 138.362 83.824C138.212 83.7067 138.138 83.5787 138.138 83.44V76.96C138.138 76.8 138.212 76.672 138.362 76.576C138.522 76.4693 138.724 76.416 138.97 76.416C139.172 76.416 139.348 76.4693 139.498 76.576C139.647 76.672 139.722 76.8 139.722 76.96V77.536C139.882 77.2267 140.143 76.9493 140.506 76.704C140.879 76.448 141.332 76.32 141.866 76.32C142.367 76.32 142.826 76.464 143.242 76.752C143.668 77.0293 144.01 77.408 144.266 77.888C144.522 78.3573 144.65 78.8853 144.65 79.472V83.44C144.65 83.6213 144.559 83.76 144.378 83.856C144.207 83.952 144.015 84 143.802 84C143.61 84 143.423 83.952 143.242 83.856C143.06 83.76 142.97 83.6213 142.97 83.44V79.472C142.97 79.1947 142.895 78.928 142.746 78.672C142.607 78.416 142.415 78.208 142.17 78.048C141.924 77.888 141.652 77.808 141.354 77.808C141.098 77.808 140.852 77.8773 140.618 78.016C140.383 78.144 140.191 78.3307 140.042 78.576C139.892 78.8213 139.818 79.12 139.818 79.472V83.44C139.818 83.5787 139.732 83.7067 139.562 83.824C139.402 83.9413 139.204 84 138.97 84ZM148.853 84.128C148.352 84.128 147.888 83.9787 147.461 83.68C147.035 83.3813 146.688 82.992 146.421 82.512C146.165 82.0213 146.037 81.4987 146.037 80.944V79.472C146.037 78.8853 146.165 78.3573 146.421 77.888C146.688 77.408 147.035 77.0293 147.461 76.752C147.888 76.464 148.363 76.32 148.885 76.32C149.397 76.32 149.829 76.448 150.181 76.704C150.533 76.9493 150.795 77.2267 150.965 77.536V72.448C150.965 72.288 151.051 72.16 151.221 72.064C151.392 71.9573 151.595 71.904 151.829 71.904C152.064 71.904 152.256 71.9573 152.405 72.064C152.565 72.16 152.645 72.288 152.645 72.448V83.44C152.645 83.5787 152.565 83.7067 152.405 83.824C152.256 83.9413 152.064 84 151.829 84C151.627 84 151.445 83.9413 151.285 83.824C151.136 83.7067 151.061 83.5787 151.061 83.44V82.88C150.901 83.2107 150.619 83.504 150.213 83.76C149.808 84.0053 149.355 84.128 148.853 84.128ZM149.333 82.64C149.643 82.64 149.92 82.5547 150.165 82.384C150.411 82.2133 150.603 82.0267 150.741 81.824C150.891 81.6107 150.965 81.44 150.965 81.312V79.472C150.965 79.12 150.885 78.8213 150.725 78.576C150.565 78.3307 150.363 78.144 150.117 78.016C149.872 77.8773 149.616 77.808 149.349 77.808C149.051 77.808 148.773 77.888 148.517 78.048C148.272 78.208 148.075 78.416 147.925 78.672C147.787 78.928 147.717 79.1947 147.717 79.472V80.944C147.717 81.2213 147.787 81.4933 147.925 81.76C148.075 82.0267 148.272 82.24 148.517 82.4C148.763 82.56 149.035 82.64 149.333 82.64ZM155.251 74.512C154.984 74.512 154.755 74.4213 154.563 74.24C154.371 74.0587 154.275 73.856 154.275 73.632C154.275 73.3867 154.371 73.1787 154.563 73.008C154.755 72.8373 154.984 72.752 155.251 72.752C155.518 72.752 155.742 72.8373 155.923 73.008C156.115 73.1787 156.211 73.3867 156.211 73.632C156.211 73.856 156.115 74.0587 155.923 74.24C155.742 74.4213 155.518 74.512 155.251 74.512ZM155.251 84C155.006 84 154.803 83.9413 154.643 83.824C154.494 83.7067 154.419 83.5787 154.419 83.44V76.96C154.419 76.8 154.494 76.672 154.643 76.576C154.803 76.4693 155.006 76.416 155.251 76.416C155.486 76.416 155.683 76.4693 155.843 76.576C156.014 76.672 156.099 76.8 156.099 76.96V83.44C156.099 83.5787 156.014 83.7067 155.843 83.824C155.683 83.9413 155.486 84 155.251 84ZM160.609 84C159.702 84 159.009 83.8027 158.529 83.408C158.049 83.0027 157.809 82.368 157.809 81.504V73.488C157.809 73.328 157.894 73.2 158.065 73.104C158.246 72.9973 158.438 72.944 158.641 72.944C158.844 72.944 159.036 72.9973 159.217 73.104C159.398 73.2 159.489 73.328 159.489 73.488V76.416H161.441C161.59 76.416 161.702 76.48 161.777 76.608C161.862 76.736 161.905 76.88 161.905 77.04C161.905 77.2 161.862 77.344 161.777 77.472C161.702 77.6 161.59 77.664 161.441 77.664H159.489V81.504C159.489 81.888 159.569 82.16 159.729 82.32C159.9 82.48 160.193 82.56 160.609 82.56H161.153C161.398 82.56 161.58 82.6347 161.697 82.784C161.825 82.9227 161.889 83.088 161.889 83.28C161.889 83.4613 161.825 83.6267 161.697 83.776C161.58 83.9253 161.398 84 161.153 84H160.609ZM163.892 74.512C163.625 74.512 163.396 74.4213 163.204 74.24C163.012 74.0587 162.916 73.856 162.916 73.632C162.916 73.3867 163.012 73.1787 163.204 73.008C163.396 72.8373 163.625 72.752 163.892 72.752C164.158 72.752 164.382 72.8373 164.564 73.008C164.756 73.1787 164.852 73.3867 164.852 73.632C164.852 73.856 164.756 74.0587 164.564 74.24C164.382 74.4213 164.158 74.512 163.892 74.512ZM163.892 84C163.646 84 163.444 83.9413 163.284 83.824C163.134 83.7067 163.06 83.5787 163.06 83.44V76.96C163.06 76.8 163.134 76.672 163.284 76.576C163.444 76.4693 163.646 76.416 163.892 76.416C164.126 76.416 164.324 76.4693 164.484 76.576C164.654 76.672 164.74 76.8 164.74 76.96V83.44C164.74 83.5787 164.654 83.7067 164.484 83.824C164.324 83.9413 164.126 84 163.892 84ZM169.474 84.128C168.898 84.128 168.359 83.9787 167.858 83.68C167.356 83.3813 166.951 82.992 166.642 82.512C166.343 82.0213 166.194 81.4987 166.194 80.944V79.472C166.194 78.9067 166.338 78.384 166.626 77.904C166.924 77.424 167.324 77.04 167.826 76.752C168.338 76.464 168.892 76.32 169.49 76.32C170.087 76.32 170.636 76.464 171.138 76.752C171.639 77.0293 172.039 77.408 172.338 77.888C172.647 78.3573 172.802 78.8853 172.802 79.472V80.944C172.802 81.488 172.647 82.0053 172.338 82.496C172.039 82.9867 171.634 83.3813 171.122 83.68C170.62 83.9787 170.071 84.128 169.474 84.128ZM169.49 82.64C169.788 82.64 170.06 82.56 170.306 82.4C170.551 82.24 170.748 82.032 170.898 81.776C171.047 81.5093 171.122 81.232 171.122 80.944V79.472C171.122 79.1947 171.047 78.928 170.898 78.672C170.748 78.416 170.551 78.208 170.306 78.048C170.06 77.888 169.788 77.808 169.49 77.808C169.18 77.808 168.903 77.888 168.658 78.048C168.423 78.208 168.231 78.416 168.082 78.672C167.943 78.928 167.874 79.1947 167.874 79.472V80.944C167.874 81.232 167.943 81.5093 168.082 81.776C168.231 82.032 168.428 82.24 168.674 82.4C168.919 82.56 169.191 82.64 169.49 82.64ZM175.095 84C174.849 84 174.647 83.9413 174.487 83.824C174.337 83.7067 174.263 83.5787 174.263 83.44V76.96C174.263 76.8 174.337 76.672 174.487 76.576C174.647 76.4693 174.849 76.416 175.095 76.416C175.297 76.416 175.473 76.4693 175.623 76.576C175.772 76.672 175.847 76.8 175.847 76.96V77.536C176.007 77.2267 176.268 76.9493 176.631 76.704C177.004 76.448 177.457 76.32 177.991 76.32C178.492 76.32 178.951 76.464 179.367 76.752C179.793 77.0293 180.135 77.408 180.391 77.888C180.647 78.3573 180.775 78.8853 180.775 79.472V83.44C180.775 83.6213 180.684 83.76 180.503 83.856C180.332 83.952 180.14 84 179.927 84C179.735 84 179.548 83.952 179.367 83.856C179.185 83.76 179.095 83.6213 179.095 83.44V79.472C179.095 79.1947 179.02 78.928 178.871 78.672C178.732 78.416 178.54 78.208 178.295 78.048C178.049 77.888 177.777 77.808 177.479 77.808C177.223 77.808 176.977 77.8773 176.743 78.016C176.508 78.144 176.316 78.3307 176.167 78.576C176.017 78.8213 175.943 79.12 175.943 79.472V83.44C175.943 83.5787 175.857 83.7067 175.687 83.824C175.527 83.9413 175.329 84 175.095 84ZM188.725 84.128C187.957 84.128 187.323 83.9893 186.821 83.712C186.331 83.4347 185.968 83.056 185.733 82.576C185.499 82.096 185.381 81.552 185.381 80.944V79.504C185.381 78.9067 185.499 78.368 185.733 77.888C185.968 77.3973 186.331 77.0133 186.821 76.736C187.312 76.4587 187.936 76.32 188.693 76.32C189.184 76.32 189.611 76.3787 189.973 76.496C190.347 76.6133 190.635 76.7627 190.837 76.944C191.051 77.1147 191.157 77.296 191.157 77.488C191.157 77.584 191.125 77.7013 191.061 77.84C191.008 77.968 190.928 78.08 190.821 78.176C190.725 78.2613 190.608 78.304 190.469 78.304C190.363 78.304 190.245 78.2613 190.117 78.176C190 78.0907 189.84 78.0107 189.637 77.936C189.435 77.8507 189.163 77.808 188.821 77.808C188.224 77.808 187.781 77.9573 187.493 78.256C187.205 78.5547 187.061 78.9707 187.061 79.504V80.944C187.061 81.4773 187.205 81.8933 187.493 82.192C187.781 82.4907 188.229 82.64 188.837 82.64C189.189 82.64 189.467 82.5973 189.669 82.512C189.872 82.416 190.032 82.3253 190.149 82.24C190.277 82.1547 190.4 82.112 190.517 82.112C190.667 82.112 190.795 82.1547 190.901 82.24C191.019 82.3253 191.104 82.432 191.157 82.56C191.221 82.688 191.253 82.8053 191.253 82.912C191.253 83.0933 191.141 83.28 190.917 83.472C190.704 83.664 190.405 83.824 190.021 83.952C189.648 84.0693 189.216 84.128 188.725 84.128ZM194.098 84.128C193.512 84.128 193.01 83.9573 192.594 83.616C192.178 83.264 191.97 82.7307 191.97 82.016C191.97 81.408 192.13 80.9387 192.45 80.608C192.77 80.2773 193.208 80.048 193.762 79.92C194.328 79.792 194.978 79.728 195.714 79.728H196.418V79.44C196.418 79.1627 196.365 78.896 196.258 78.64C196.162 78.3733 195.997 78.1547 195.762 77.984C195.538 77.8027 195.229 77.712 194.834 77.712C194.44 77.712 194.136 77.7493 193.922 77.824C193.709 77.8987 193.538 77.9787 193.41 78.064C193.282 78.1493 193.165 78.192 193.058 78.192C192.866 78.192 192.717 78.1013 192.61 77.92C192.504 77.728 192.45 77.536 192.45 77.344C192.45 77.152 192.573 76.9813 192.818 76.832C193.074 76.672 193.389 76.5493 193.762 76.464C194.136 76.368 194.504 76.32 194.866 76.32C195.656 76.32 196.285 76.4693 196.754 76.768C197.224 77.056 197.565 77.4347 197.778 77.904C197.992 78.3733 198.098 78.88 198.098 79.424V83.44C198.098 83.5893 198.018 83.7227 197.858 83.84C197.709 83.9467 197.517 84 197.282 84C197.069 84 196.888 83.9467 196.738 83.84C196.589 83.7227 196.514 83.5893 196.514 83.44V82.88C196.237 83.2 195.901 83.488 195.506 83.744C195.112 84 194.642 84.128 194.098 84.128ZM194.706 82.848C194.973 82.848 195.234 82.768 195.49 82.608C195.757 82.448 195.976 82.2453 196.146 82C196.328 81.7547 196.418 81.504 196.418 81.248V80.656H196.018C195.613 80.656 195.229 80.6827 194.866 80.736C194.504 80.7787 194.21 80.8853 193.986 81.056C193.773 81.216 193.666 81.4667 193.666 81.808C193.666 82.1707 193.762 82.4373 193.954 82.608C194.157 82.768 194.408 82.848 194.706 82.848ZM200.626 84C200.381 84 200.178 83.9413 200.018 83.824C199.869 83.7067 199.794 83.5787 199.794 83.44V76.96C199.794 76.8 199.869 76.672 200.018 76.576C200.178 76.4693 200.381 76.416 200.626 76.416C200.829 76.416 201.005 76.4693 201.154 76.576C201.303 76.672 201.378 76.8 201.378 76.96V77.536C201.538 77.2267 201.799 76.9493 202.162 76.704C202.535 76.448 202.989 76.32 203.522 76.32C204.023 76.32 204.482 76.464 204.898 76.752C205.325 77.0293 205.666 77.408 205.922 77.888C206.178 78.3573 206.306 78.8853 206.306 79.472V83.44C206.306 83.6213 206.215 83.76 206.034 83.856C205.863 83.952 205.671 84 205.458 84C205.266 84 205.079 83.952 204.898 83.856C204.717 83.76 204.626 83.6213 204.626 83.44V79.472C204.626 79.1947 204.551 78.928 204.402 78.672C204.263 78.416 204.071 78.208 203.826 78.048C203.581 77.888 203.309 77.808 203.01 77.808C202.754 77.808 202.509 77.8773 202.274 78.016C202.039 78.144 201.847 78.3307 201.698 78.576C201.549 78.8213 201.474 79.12 201.474 79.472V83.44C201.474 83.5787 201.389 83.7067 201.218 83.824C201.058 83.9413 200.861 84 200.626 84ZM214.993 84.128C214.491 84.128 214.038 84.0053 213.633 83.76C213.238 83.504 212.955 83.2107 212.785 82.88V83.44C212.785 83.5787 212.71 83.7067 212.561 83.824C212.411 83.9413 212.23 84 212.017 84C211.782 84 211.585 83.9413 211.425 83.824C211.275 83.7067 211.201 83.5787 211.201 83.44V72.448C211.201 72.288 211.275 72.16 211.425 72.064C211.585 71.9573 211.782 71.904 212.017 71.904C212.262 71.904 212.465 71.9573 212.625 72.064C212.795 72.16 212.881 72.288 212.881 72.448V77.536C213.051 77.2267 213.313 76.9493 213.665 76.704C214.017 76.448 214.443 76.32 214.945 76.32C215.467 76.32 215.942 76.464 216.369 76.752C216.806 77.0293 217.153 77.408 217.409 77.888C217.675 78.3573 217.809 78.8853 217.809 79.472V80.944C217.809 81.4987 217.675 82.0213 217.409 82.512C217.153 82.992 216.811 83.3813 216.385 83.68C215.958 83.9787 215.494 84.128 214.993 84.128ZM214.513 82.64C214.801 82.64 215.067 82.56 215.313 82.4C215.558 82.24 215.755 82.0267 215.905 81.76C216.054 81.4933 216.129 81.2213 216.129 80.944V79.472C216.129 79.1947 216.054 78.928 215.905 78.672C215.755 78.416 215.558 78.208 215.313 78.048C215.067 77.888 214.795 77.808 214.497 77.808C214.23 77.808 213.974 77.8773 213.729 78.016C213.483 78.144 213.281 78.3307 213.121 78.576C212.961 78.8213 212.881 79.12 212.881 79.472V81.312C212.881 81.44 212.95 81.6107 213.089 81.824C213.238 82.0267 213.435 82.2133 213.681 82.384C213.926 82.5547 214.203 82.64 214.513 82.64ZM222.702 84.128C221.977 84.128 221.337 83.9947 220.782 83.728C220.228 83.4613 219.79 83.0933 219.47 82.624C219.15 82.144 218.99 81.584 218.99 80.944V79.424C218.99 78.8587 219.14 78.3413 219.438 77.872C219.748 77.4027 220.153 77.0293 220.654 76.752C221.156 76.464 221.71 76.32 222.318 76.32C222.894 76.32 223.422 76.448 223.902 76.704C224.382 76.9493 224.766 77.296 225.054 77.744C225.353 78.192 225.502 78.704 225.502 79.28C225.502 79.728 225.433 80.048 225.294 80.24C225.156 80.432 224.974 80.5493 224.75 80.592C224.526 80.6347 224.292 80.656 224.046 80.656H220.67V81.024C220.67 81.5573 220.862 81.984 221.246 82.304C221.641 82.6133 222.142 82.768 222.75 82.768C223.124 82.768 223.428 82.7147 223.662 82.608C223.897 82.5013 224.094 82.4 224.254 82.304C224.414 82.208 224.564 82.16 224.702 82.16C224.841 82.16 224.958 82.2027 225.054 82.288C225.15 82.3733 225.225 82.4747 225.278 82.592C225.332 82.7093 225.358 82.816 225.358 82.912C225.358 83.072 225.246 83.248 225.022 83.44C224.809 83.632 224.505 83.7973 224.11 83.936C223.716 84.064 223.246 84.128 222.702 84.128ZM220.67 79.616H223.326C223.561 79.616 223.716 79.584 223.79 79.52C223.876 79.456 223.918 79.328 223.918 79.136C223.918 78.8587 223.849 78.6027 223.71 78.368C223.572 78.1227 223.38 77.936 223.134 77.808C222.889 77.6693 222.612 77.6 222.302 77.6C222.004 77.6 221.732 77.664 221.486 77.792C221.241 77.92 221.044 78.096 220.894 78.32C220.745 78.544 220.67 78.8053 220.67 79.104V79.616ZM52.0955 104.128C51.5942 104.128 51.1302 103.979 50.7035 103.68C50.2768 103.381 49.9302 102.992 49.6635 102.512C49.4075 102.021 49.2795 101.499 49.2795 100.944V99.472C49.2795 98.8853 49.4075 98.3573 49.6635 97.888C49.9302 97.408 50.2768 97.0293 50.7035 96.752C51.1302 96.464 51.6048 96.32 52.1275 96.32C52.6395 96.32 53.0715 96.448 53.4235 96.704C53.7755 96.9493 54.0368 97.2267 54.2075 97.536V92.448C54.2075 92.288 54.2928 92.16 54.4635 92.064C54.6342 91.9573 54.8368 91.904 55.0715 91.904C55.3062 91.904 55.4982 91.9573 55.6475 92.064C55.8075 92.16 55.8875 92.288 55.8875 92.448V103.44C55.8875 103.579 55.8075 103.707 55.6475 103.824C55.4982 103.941 55.3062 104 55.0715 104C54.8688 104 54.6875 103.941 54.5275 103.824C54.3782 103.707 54.3035 103.579 54.3035 103.44V102.88C54.1435 103.211 53.8608 103.504 53.4555 103.76C53.0502 104.005 52.5968 104.128 52.0955 104.128ZM52.5755 102.64C52.8848 102.64 53.1622 102.555 53.4075 102.384C53.6528 102.213 53.8448 102.027 53.9835 101.824C54.1328 101.611 54.2075 101.44 54.2075 101.312V99.472C54.2075 99.12 54.1275 98.8213 53.9675 98.576C53.8075 98.3307 53.6048 98.144 53.3595 98.016C53.1142 97.8773 52.8582 97.808 52.5915 97.808C52.2928 97.808 52.0155 97.888 51.7595 98.048C51.5142 98.208 51.3168 98.416 51.1675 98.672C51.0288 98.928 50.9595 99.1947 50.9595 99.472V100.944C50.9595 101.221 51.0288 101.493 51.1675 101.76C51.3168 102.027 51.5142 102.24 51.7595 102.4C52.0048 102.56 52.2768 102.64 52.5755 102.64ZM58.4933 94.512C58.2266 94.512 57.9973 94.4213 57.8053 94.24C57.6133 94.0587 57.5173 93.856 57.5173 93.632C57.5173 93.3867 57.6133 93.1787 57.8053 93.008C57.9973 92.8373 58.2266 92.752 58.4933 92.752C58.7599 92.752 58.9839 92.8373 59.1653 93.008C59.3573 93.1787 59.4533 93.3867 59.4533 93.632C59.4533 93.856 59.3573 94.0587 59.1653 94.24C58.9839 94.4213 58.7599 94.512 58.4933 94.512ZM58.4933 104C58.2479 104 58.0453 103.941 57.8853 103.824C57.7359 103.707 57.6613 103.579 57.6613 103.44V96.96C57.6613 96.8 57.7359 96.672 57.8853 96.576C58.0453 96.4693 58.2479 96.416 58.4933 96.416C58.7279 96.416 58.9253 96.4693 59.0853 96.576C59.2559 96.672 59.3413 96.8 59.3413 96.96V103.44C59.3413 103.579 59.2559 103.707 59.0853 103.824C58.9253 103.941 58.7279 104 58.4933 104ZM63.4031 104.128C62.8805 104.128 62.4111 104.064 61.9951 103.936C61.5791 103.808 61.2485 103.648 61.0031 103.456C60.7685 103.253 60.6511 103.051 60.6511 102.848C60.6511 102.752 60.6725 102.645 60.7151 102.528C60.7685 102.411 60.8378 102.309 60.9231 102.224C61.0191 102.139 61.1205 102.096 61.2271 102.096C61.3658 102.096 61.5098 102.16 61.6591 102.288C61.8191 102.405 62.0271 102.528 62.2831 102.656C62.5391 102.773 62.8965 102.832 63.3551 102.832C63.8885 102.832 64.2458 102.741 64.4271 102.56C64.6191 102.379 64.7151 102.181 64.7151 101.968C64.7151 101.691 64.6191 101.477 64.4271 101.328C64.2458 101.168 64.0058 101.04 63.7071 100.944C63.4191 100.848 63.1098 100.757 62.7791 100.672C62.4485 100.576 62.1338 100.453 61.8351 100.304C61.5471 100.155 61.3071 99.9467 61.1151 99.68C60.9338 99.4133 60.8431 99.0613 60.8431 98.624C60.8431 98.2613 60.9338 97.904 61.1151 97.552C61.2965 97.1893 61.5845 96.896 61.9791 96.672C62.3845 96.4373 62.9231 96.32 63.5951 96.32C64.0005 96.32 64.3845 96.3627 64.7471 96.448C65.1098 96.5333 65.4085 96.6507 65.6431 96.8C65.8778 96.9387 65.9951 97.0933 65.9951 97.264C65.9951 97.3387 65.9685 97.4453 65.9151 97.584C65.8618 97.712 65.7871 97.8293 65.6911 97.936C65.6058 98.032 65.4938 98.08 65.3551 98.08C65.2485 98.08 65.1151 98.0427 64.9551 97.968C64.7951 97.8827 64.6085 97.8027 64.3951 97.728C64.1818 97.6533 63.9205 97.616 63.6111 97.616C63.3018 97.616 63.0511 97.6693 62.8591 97.776C62.6778 97.872 62.5445 97.9893 62.4591 98.128C62.3738 98.2667 62.3311 98.4053 62.3311 98.544C62.3311 98.7787 62.4218 98.96 62.6031 99.088C62.7845 99.216 63.0245 99.3227 63.3231 99.408C63.6218 99.4933 63.9365 99.584 64.2671 99.68C64.5978 99.7653 64.9071 99.8933 65.1951 100.064C65.4938 100.235 65.7338 100.464 65.9151 100.752C66.1071 101.04 66.2031 101.424 66.2031 101.904C66.2031 102.576 65.9578 103.115 65.4671 103.52C64.9871 103.925 64.2991 104.128 63.4031 104.128ZM70.6551 104.128C69.8871 104.128 69.2525 103.989 68.7511 103.712C68.2605 103.435 67.8978 103.056 67.6631 102.576C67.4285 102.096 67.3111 101.552 67.3111 100.944V99.504C67.3111 98.9067 67.4285 98.368 67.6631 97.888C67.8978 97.3973 68.2605 97.0133 68.7511 96.736C69.2418 96.4587 69.8658 96.32 70.6231 96.32C71.1138 96.32 71.5405 96.3787 71.9031 96.496C72.2765 96.6133 72.5645 96.7627 72.7671 96.944C72.9805 97.1147 73.0871 97.296 73.0871 97.488C73.0871 97.584 73.0551 97.7013 72.9911 97.84C72.9378 97.968 72.8578 98.08 72.7511 98.176C72.6551 98.2613 72.5378 98.304 72.3991 98.304C72.2925 98.304 72.1751 98.2613 72.0471 98.176C71.9298 98.0907 71.7698 98.0107 71.5671 97.936C71.3645 97.8507 71.0925 97.808 70.7511 97.808C70.1538 97.808 69.7111 97.9573 69.4231 98.256C69.1351 98.5547 68.9911 98.9707 68.9911 99.504V100.944C68.9911 101.477 69.1351 101.893 69.4231 102.192C69.7111 102.491 70.1591 102.64 70.7671 102.64C71.1191 102.64 71.3965 102.597 71.5991 102.512C71.8018 102.416 71.9618 102.325 72.0791 102.24C72.2071 102.155 72.3298 102.112 72.4471 102.112C72.5965 102.112 72.7245 102.155 72.8311 102.24C72.9485 102.325 73.0338 102.432 73.0871 102.56C73.1511 102.688 73.1831 102.805 73.1831 102.912C73.1831 103.093 73.0711 103.28 72.8471 103.472C72.6338 103.664 72.3351 103.824 71.9511 103.952C71.5778 104.069 71.1458 104.128 70.6551 104.128ZM76.028 104.128C75.4413 104.128 74.94 103.957 74.524 103.616C74.108 103.264 73.9 102.731 73.9 102.016C73.9 101.408 74.06 100.939 74.38 100.608C74.7 100.277 75.1373 100.048 75.692 99.92C76.2573 99.792 76.908 99.728 77.644 99.728H78.348V99.44C78.348 99.1627 78.2947 98.896 78.188 98.64C78.092 98.3733 77.9267 98.1547 77.692 97.984C77.468 97.8027 77.1587 97.712 76.764 97.712C76.3693 97.712 76.0653 97.7493 75.852 97.824C75.6387 97.8987 75.468 97.9787 75.34 98.064C75.212 98.1493 75.0947 98.192 74.988 98.192C74.796 98.192 74.6467 98.1013 74.54 97.92C74.4333 97.728 74.38 97.536 74.38 97.344C74.38 97.152 74.5027 96.9813 74.748 96.832C75.004 96.672 75.3187 96.5493 75.692 96.464C76.0653 96.368 76.4333 96.32 76.796 96.32C77.5853 96.32 78.2147 96.4693 78.684 96.768C79.1533 97.056 79.4947 97.4347 79.708 97.904C79.9213 98.3733 80.028 98.88 80.028 99.424V103.44C80.028 103.589 79.948 103.723 79.788 103.84C79.6387 103.947 79.4467 104 79.212 104C78.9987 104 78.8173 103.947 78.668 103.84C78.5187 103.723 78.444 103.589 78.444 103.44V102.88C78.1667 103.2 77.8307 103.488 77.436 103.744C77.0413 104 76.572 104.128 76.028 104.128ZM76.636 102.848C76.9027 102.848 77.164 102.768 77.42 102.608C77.6867 102.448 77.9053 102.245 78.076 102C78.2573 101.755 78.348 101.504 78.348 101.248V100.656H77.948C77.5427 100.656 77.1587 100.683 76.796 100.736C76.4333 100.779 76.14 100.885 75.916 101.056C75.7027 101.216 75.596 101.467 75.596 101.808C75.596 102.171 75.692 102.437 75.884 102.608C76.0867 102.768 76.3373 102.848 76.636 102.848ZM82.5398 104C82.3051 104 82.1078 103.941 81.9478 103.824C81.7984 103.707 81.7238 103.579 81.7238 103.44V96.96C81.7238 96.8 81.7984 96.672 81.9478 96.576C82.1078 96.4693 82.3051 96.416 82.5398 96.416C82.7531 96.416 82.9344 96.4693 83.0838 96.576C83.2331 96.672 83.3078 96.8 83.3078 96.96V97.664C83.4251 97.44 83.5798 97.2267 83.7718 97.024C83.9744 96.8213 84.2091 96.656 84.4758 96.528C84.7424 96.3893 85.0304 96.32 85.3398 96.32H85.8518C86.0224 96.32 86.1718 96.3947 86.2998 96.544C86.4278 96.6827 86.4918 96.8533 86.4918 97.056C86.4918 97.2587 86.4278 97.4347 86.2998 97.584C86.1718 97.7333 86.0224 97.808 85.8518 97.808H85.3398C85.0198 97.808 84.7104 97.904 84.4118 98.096C84.1131 98.288 83.8678 98.56 83.6758 98.912C83.4944 99.2533 83.4038 99.6693 83.4038 100.16V103.44C83.4038 103.579 83.3184 103.707 83.1478 103.824C82.9878 103.941 82.7851 104 82.5398 104ZM89.7361 104.128C89.2348 104.128 88.7708 103.979 88.3441 103.68C87.9175 103.381 87.5708 102.992 87.3041 102.512C87.0481 102.021 86.9201 101.499 86.9201 100.944V99.472C86.9201 98.8853 87.0481 98.3573 87.3041 97.888C87.5708 97.408 87.9175 97.0293 88.3441 96.752C88.7708 96.464 89.2455 96.32 89.7681 96.32C90.2801 96.32 90.7121 96.448 91.0641 96.704C91.4161 96.9493 91.6775 97.2267 91.8481 97.536V92.448C91.8481 92.288 91.9335 92.16 92.1041 92.064C92.2748 91.9573 92.4775 91.904 92.7121 91.904C92.9468 91.904 93.1388 91.9573 93.2881 92.064C93.4481 92.16 93.5281 92.288 93.5281 92.448V103.44C93.5281 103.579 93.4481 103.707 93.2881 103.824C93.1388 103.941 92.9468 104 92.7121 104C92.5095 104 92.3281 103.941 92.1681 103.824C92.0188 103.707 91.9441 103.579 91.9441 103.44V102.88C91.7841 103.211 91.5015 103.504 91.0961 103.76C90.6908 104.005 90.2375 104.128 89.7361 104.128ZM90.2161 102.64C90.5255 102.64 90.8028 102.555 91.0481 102.384C91.2935 102.213 91.4855 102.027 91.6241 101.824C91.7735 101.611 91.8481 101.44 91.8481 101.312V99.472C91.8481 99.12 91.7681 98.8213 91.6081 98.576C91.4481 98.3307 91.2455 98.144 91.0001 98.016C90.7548 97.8773 90.4988 97.808 90.2321 97.808C89.9335 97.808 89.6561 97.888 89.4001 98.048C89.1548 98.208 88.9575 98.416 88.8081 98.672C88.6695 98.928 88.6001 99.1947 88.6001 99.472V100.944C88.6001 101.221 88.6695 101.493 88.8081 101.76C88.9575 102.027 89.1548 102.24 89.4001 102.4C89.6455 102.56 89.9175 102.64 90.2161 102.64ZM98.7259 104.128C98.0005 104.128 97.3605 103.995 96.8059 103.728C96.2512 103.461 95.8139 103.093 95.4939 102.624C95.1739 102.144 95.0139 101.584 95.0139 100.944V99.424C95.0139 98.8587 95.1632 98.3413 95.4619 97.872C95.7712 97.4027 96.1765 97.0293 96.6779 96.752C97.1792 96.464 97.7339 96.32 98.3419 96.32C98.9179 96.32 99.4459 96.448 99.9259 96.704C100.406 96.9493 100.79 97.296 101.078 97.744C101.377 98.192 101.526 98.704 101.526 99.28C101.526 99.728 101.457 100.048 101.318 100.24C101.179 100.432 100.998 100.549 100.774 100.592C100.55 100.635 100.315 100.656 100.07 100.656H96.6939V101.024C96.6939 101.557 96.8859 101.984 97.2699 102.304C97.6645 102.613 98.1659 102.768 98.7739 102.768C99.1472 102.768 99.4512 102.715 99.6859 102.608C99.9205 102.501 100.118 102.4 100.278 102.304C100.438 102.208 100.587 102.16 100.726 102.16C100.865 102.16 100.982 102.203 101.078 102.288C101.174 102.373 101.249 102.475 101.302 102.592C101.355 102.709 101.382 102.816 101.382 102.912C101.382 103.072 101.27 103.248 101.046 103.44C100.833 103.632 100.529 103.797 100.134 103.936C99.7392 104.064 99.2699 104.128 98.7259 104.128ZM96.6939 99.616H99.3499C99.5845 99.616 99.7392 99.584 99.8139 99.52C99.8992 99.456 99.9419 99.328 99.9419 99.136C99.9419 98.8587 99.8725 98.6027 99.7339 98.368C99.5952 98.1227 99.4032 97.936 99.1579 97.808C98.9125 97.6693 98.6352 97.6 98.3259 97.6C98.0272 97.6 97.7552 97.664 97.5099 97.792C97.2645 97.92 97.0672 98.096 96.9179 98.32C96.7685 98.544 96.6939 98.8053 96.6939 99.104V99.616ZM105.424 104.128C104.922 104.128 104.458 103.979 104.032 103.68C103.605 103.381 103.258 102.992 102.992 102.512C102.736 102.021 102.608 101.499 102.608 100.944V99.472C102.608 98.8853 102.736 98.3573 102.992 97.888C103.258 97.408 103.605 97.0293 104.032 96.752C104.458 96.464 104.933 96.32 105.456 96.32C105.968 96.32 106.4 96.448 106.752 96.704C107.104 96.9493 107.365 97.2267 107.536 97.536V92.448C107.536 92.288 107.621 92.16 107.792 92.064C107.962 91.9573 108.165 91.904 108.4 91.904C108.634 91.904 108.826 91.9573 108.976 92.064C109.136 92.16 109.216 92.288 109.216 92.448V103.44C109.216 103.579 109.136 103.707 108.976 103.824C108.826 103.941 108.634 104 108.4 104C108.197 104 108.016 103.941 107.856 103.824C107.706 103.707 107.632 103.579 107.632 103.44V102.88C107.472 103.211 107.189 103.504 106.784 103.76C106.378 104.005 105.925 104.128 105.424 104.128ZM105.904 102.64C106.213 102.64 106.49 102.555 106.736 102.384C106.981 102.213 107.173 102.027 107.312 101.824C107.461 101.611 107.536 101.44 107.536 101.312V99.472C107.536 99.12 107.456 98.8213 107.296 98.576C107.136 98.3307 106.933 98.144 106.688 98.016C106.442 97.8773 106.186 97.808 105.92 97.808C105.621 97.808 105.344 97.888 105.088 98.048C104.842 98.208 104.645 98.416 104.496 98.672C104.357 98.928 104.288 99.1947 104.288 99.472V100.944C104.288 101.221 104.357 101.493 104.496 101.76C104.645 102.027 104.842 102.24 105.088 102.4C105.333 102.56 105.605 102.64 105.904 102.64ZM115.841 104.128C115.254 104.128 114.753 103.957 114.337 103.616C113.921 103.264 113.713 102.731 113.713 102.016C113.713 101.408 113.873 100.939 114.193 100.608C114.513 100.277 114.95 100.048 115.505 99.92C116.07 99.792 116.721 99.728 117.457 99.728H118.161V99.44C118.161 99.1627 118.107 98.896 118.001 98.64C117.905 98.3733 117.739 98.1547 117.505 97.984C117.281 97.8027 116.971 97.712 116.577 97.712C116.182 97.712 115.878 97.7493 115.664 97.824C115.451 97.8987 115.281 97.9787 115.153 98.064C115.025 98.1493 114.907 98.192 114.801 98.192C114.609 98.192 114.459 98.1013 114.353 97.92C114.246 97.728 114.193 97.536 114.193 97.344C114.193 97.152 114.315 96.9813 114.561 96.832C114.817 96.672 115.131 96.5493 115.505 96.464C115.878 96.368 116.246 96.32 116.609 96.32C117.398 96.32 118.027 96.4693 118.497 96.768C118.966 97.056 119.307 97.4347 119.521 97.904C119.734 98.3733 119.841 98.88 119.841 99.424V103.44C119.841 103.589 119.761 103.723 119.601 103.84C119.451 103.947 119.259 104 119.025 104C118.811 104 118.63 103.947 118.481 103.84C118.331 103.723 118.257 103.589 118.257 103.44V102.88C117.979 103.2 117.643 103.488 117.249 103.744C116.854 104 116.385 104.128 115.841 104.128ZM116.449 102.848C116.715 102.848 116.977 102.768 117.233 102.608C117.499 102.448 117.718 102.245 117.889 102C118.07 101.755 118.161 101.504 118.161 101.248V100.656H117.761C117.355 100.656 116.971 100.683 116.609 100.736C116.246 100.779 115.953 100.885 115.729 101.056C115.515 101.216 115.409 101.467 115.409 101.808C115.409 102.171 115.505 102.437 115.697 102.608C115.899 102.768 116.15 102.848 116.449 102.848ZM123.856 104.128C123.334 104.128 122.864 104.064 122.448 103.936C122.032 103.808 121.702 103.648 121.456 103.456C121.222 103.253 121.104 103.051 121.104 102.848C121.104 102.752 121.126 102.645 121.168 102.528C121.222 102.411 121.291 102.309 121.376 102.224C121.472 102.139 121.574 102.096 121.68 102.096C121.819 102.096 121.963 102.16 122.112 102.288C122.272 102.405 122.48 102.528 122.736 102.656C122.992 102.773 123.35 102.832 123.808 102.832C124.342 102.832 124.699 102.741 124.88 102.56C125.072 102.379 125.168 102.181 125.168 101.968C125.168 101.691 125.072 101.477 124.88 101.328C124.699 101.168 124.459 101.04 124.16 100.944C123.872 100.848 123.563 100.757 123.232 100.672C122.902 100.576 122.587 100.453 122.288 100.304C122 100.155 121.76 99.9467 121.568 99.68C121.387 99.4133 121.296 99.0613 121.296 98.624C121.296 98.2613 121.387 97.904 121.568 97.552C121.75 97.1893 122.038 96.896 122.432 96.672C122.838 96.4373 123.376 96.32 124.048 96.32C124.454 96.32 124.838 96.3627 125.2 96.448C125.563 96.5333 125.862 96.6507 126.096 96.8C126.331 96.9387 126.448 97.0933 126.448 97.264C126.448 97.3387 126.422 97.4453 126.368 97.584C126.315 97.712 126.24 97.8293 126.144 97.936C126.059 98.032 125.947 98.08 125.808 98.08C125.702 98.08 125.568 98.0427 125.408 97.968C125.248 97.8827 125.062 97.8027 124.848 97.728C124.635 97.6533 124.374 97.616 124.064 97.616C123.755 97.616 123.504 97.6693 123.312 97.776C123.131 97.872 122.998 97.9893 122.912 98.128C122.827 98.2667 122.784 98.4053 122.784 98.544C122.784 98.7787 122.875 98.96 123.056 99.088C123.238 99.216 123.478 99.3227 123.776 99.408C124.075 99.4933 124.39 99.584 124.72 99.68C125.051 99.7653 125.36 99.8933 125.648 100.064C125.947 100.235 126.187 100.464 126.368 100.752C126.56 101.04 126.656 101.424 126.656 101.904C126.656 102.576 126.411 103.115 125.92 103.52C125.44 103.925 124.752 104.128 123.856 104.128ZM134.103 107.6C133.485 107.6 132.914 107.509 132.391 107.328C131.869 107.157 131.453 106.907 131.143 106.576C130.834 106.245 130.679 105.851 130.679 105.392C130.679 104.965 130.802 104.608 131.047 104.32C131.293 104.043 131.581 103.829 131.911 103.68C131.698 103.584 131.522 103.456 131.383 103.296C131.245 103.136 131.175 102.912 131.175 102.624C131.175 102.325 131.25 102.085 131.399 101.904C131.549 101.723 131.741 101.557 131.975 101.408C131.677 101.173 131.442 100.885 131.271 100.544C131.111 100.192 131.031 99.808 131.031 99.392V98.944C131.031 98.432 131.154 97.9787 131.399 97.584C131.645 97.1893 131.991 96.88 132.439 96.656C132.898 96.432 133.421 96.32 134.007 96.32C134.37 96.32 134.706 96.368 135.015 96.464C135.335 96.56 135.618 96.6933 135.863 96.864C136.034 96.4693 136.205 96.192 136.375 96.032C136.557 95.872 136.727 95.792 136.887 95.792C137.111 95.792 137.282 95.856 137.399 95.984C137.517 96.112 137.575 96.24 137.575 96.368C137.575 96.4533 137.549 96.5333 137.495 96.608C137.453 96.672 137.389 96.7253 137.303 96.768C137.197 96.8213 137.069 96.896 136.919 96.992C136.781 97.0773 136.642 97.216 136.503 97.408C136.685 97.6107 136.818 97.8453 136.903 98.112C136.989 98.3787 137.031 98.656 137.031 98.944V99.392C137.031 99.8933 136.903 100.347 136.647 100.752C136.391 101.157 136.034 101.477 135.575 101.712C135.117 101.936 134.594 102.048 134.007 102.048C133.591 102.048 133.223 101.984 132.903 101.856C132.818 101.909 132.743 101.973 132.679 102.048C132.626 102.112 132.599 102.197 132.599 102.304C132.599 102.496 132.717 102.635 132.951 102.72C133.186 102.805 133.485 102.869 133.847 102.912C134.221 102.955 134.615 103.008 135.031 103.072C135.447 103.136 135.837 103.243 136.199 103.392C136.573 103.531 136.877 103.739 137.111 104.016C137.346 104.304 137.463 104.693 137.463 105.184C137.463 105.739 137.309 106.192 136.999 106.544C136.69 106.907 136.279 107.173 135.767 107.344C135.266 107.515 134.711 107.6 134.103 107.6ZM134.071 106.48C134.594 106.48 135.015 106.363 135.335 106.128C135.666 105.904 135.831 105.605 135.831 105.232C135.831 104.965 135.751 104.757 135.591 104.608C135.431 104.459 135.223 104.347 134.967 104.272C134.711 104.197 134.439 104.144 134.151 104.112C133.874 104.08 133.607 104.048 133.351 104.016C133.053 104.123 132.797 104.272 132.583 104.464C132.381 104.667 132.279 104.917 132.279 105.216C132.279 105.611 132.445 105.92 132.775 106.144C133.117 106.368 133.549 106.48 134.071 106.48ZM134.039 100.976C134.466 100.976 134.797 100.827 135.031 100.528C135.277 100.229 135.399 99.8507 135.399 99.392V98.944C135.399 98.5067 135.277 98.1387 135.031 97.84C134.797 97.5413 134.461 97.392 134.023 97.392C133.586 97.392 133.25 97.5413 133.015 97.84C132.781 98.1387 132.663 98.5067 132.663 98.944V99.376C132.663 99.824 132.781 100.203 133.015 100.512C133.25 100.821 133.591 100.976 134.039 100.976ZM142.07 104.128C141.344 104.128 140.704 103.995 140.15 103.728C139.595 103.461 139.158 103.093 138.838 102.624C138.518 102.144 138.358 101.584 138.358 100.944V99.424C138.358 98.8587 138.507 98.3413 138.806 97.872C139.115 97.4027 139.52 97.0293 140.022 96.752C140.523 96.464 141.078 96.32 141.686 96.32C142.262 96.32 142.79 96.448 143.27 96.704C143.75 96.9493 144.134 97.296 144.422 97.744C144.72 98.192 144.87 98.704 144.87 99.28C144.87 99.728 144.8 100.048 144.662 100.24C144.523 100.432 144.342 100.549 144.118 100.592C143.894 100.635 143.659 100.656 143.414 100.656H140.038V101.024C140.038 101.557 140.23 101.984 140.614 102.304C141.008 102.613 141.51 102.768 142.118 102.768C142.491 102.768 142.795 102.715 143.03 102.608C143.264 102.501 143.462 102.4 143.622 102.304C143.782 102.208 143.931 102.16 144.07 102.16C144.208 102.16 144.326 102.203 144.422 102.288C144.518 102.373 144.592 102.475 144.646 102.592C144.699 102.709 144.726 102.816 144.726 102.912C144.726 103.072 144.614 103.248 144.39 103.44C144.176 103.632 143.872 103.797 143.478 103.936C143.083 104.064 142.614 104.128 142.07 104.128ZM140.038 99.616H142.694C142.928 99.616 143.083 99.584 143.158 99.52C143.243 99.456 143.286 99.328 143.286 99.136C143.286 98.8587 143.216 98.6027 143.078 98.368C142.939 98.1227 142.747 97.936 142.502 97.808C142.256 97.6693 141.979 97.6 141.67 97.6C141.371 97.6 141.099 97.664 140.854 97.792C140.608 97.92 140.411 98.096 140.262 98.32C140.112 98.544 140.038 98.8053 140.038 99.104V99.616ZM147.071 104C146.826 104 146.623 103.941 146.463 103.824C146.314 103.707 146.239 103.579 146.239 103.44V96.96C146.239 96.8 146.314 96.672 146.463 96.576C146.623 96.4693 146.826 96.416 147.071 96.416C147.274 96.416 147.45 96.4693 147.599 96.576C147.749 96.672 147.823 96.8 147.823 96.96V97.536C147.983 97.2267 148.245 96.9493 148.607 96.704C148.981 96.448 149.434 96.32 149.967 96.32C150.469 96.32 150.927 96.464 151.343 96.752C151.77 97.0293 152.111 97.408 152.367 97.888C152.623 98.3573 152.751 98.8853 152.751 99.472V103.44C152.751 103.621 152.661 103.76 152.479 103.856C152.309 103.952 152.117 104 151.903 104C151.711 104 151.525 103.952 151.343 103.856C151.162 103.76 151.071 103.621 151.071 103.44V99.472C151.071 99.1947 150.997 98.928 150.847 98.672C150.709 98.416 150.517 98.208 150.271 98.048C150.026 97.888 149.754 97.808 149.455 97.808C149.199 97.808 148.954 97.8773 148.719 98.016C148.485 98.144 148.293 98.3307 148.143 98.576C147.994 98.8213 147.919 99.12 147.919 99.472V103.44C147.919 103.579 147.834 103.707 147.663 103.824C147.503 103.941 147.306 104 147.071 104ZM157.851 104.128C157.126 104.128 156.486 103.995 155.931 103.728C155.376 103.461 154.939 103.093 154.619 102.624C154.299 102.144 154.139 101.584 154.139 100.944V99.424C154.139 98.8587 154.288 98.3413 154.587 97.872C154.896 97.4027 155.302 97.0293 155.803 96.752C156.304 96.464 156.859 96.32 157.467 96.32C158.043 96.32 158.571 96.448 159.051 96.704C159.531 96.9493 159.915 97.296 160.203 97.744C160.502 98.192 160.651 98.704 160.651 99.28C160.651 99.728 160.582 100.048 160.443 100.24C160.304 100.432 160.123 100.549 159.899 100.592C159.675 100.635 159.44 100.656 159.195 100.656H155.819V101.024C155.819 101.557 156.011 101.984 156.395 102.304C156.79 102.613 157.291 102.768 157.899 102.768C158.272 102.768 158.576 102.715 158.811 102.608C159.046 102.501 159.243 102.4 159.403 102.304C159.563 102.208 159.712 102.16 159.851 102.16C159.99 102.16 160.107 102.203 160.203 102.288C160.299 102.373 160.374 102.475 160.427 102.592C160.48 102.709 160.507 102.816 160.507 102.912C160.507 103.072 160.395 103.248 160.171 103.44C159.958 103.632 159.654 103.797 159.259 103.936C158.864 104.064 158.395 104.128 157.851 104.128ZM155.819 99.616H158.475C158.71 99.616 158.864 99.584 158.939 99.52C159.024 99.456 159.067 99.328 159.067 99.136C159.067 98.8587 158.998 98.6027 158.859 98.368C158.72 98.1227 158.528 97.936 158.283 97.808C158.038 97.6693 157.76 97.6 157.451 97.6C157.152 97.6 156.88 97.664 156.635 97.792C156.39 97.92 156.192 98.096 156.043 98.32C155.894 98.544 155.819 98.8053 155.819 99.104V99.616ZM162.837 104C162.602 104 162.405 103.941 162.245 103.824C162.095 103.707 162.021 103.579 162.021 103.44V96.96C162.021 96.8 162.095 96.672 162.245 96.576C162.405 96.4693 162.602 96.416 162.837 96.416C163.05 96.416 163.231 96.4693 163.381 96.576C163.53 96.672 163.605 96.8 163.605 96.96V97.664C163.722 97.44 163.877 97.2267 164.069 97.024C164.271 96.8213 164.506 96.656 164.773 96.528C165.039 96.3893 165.327 96.32 165.637 96.32H166.149C166.319 96.32 166.469 96.3947 166.597 96.544C166.725 96.6827 166.789 96.8533 166.789 97.056C166.789 97.2587 166.725 97.4347 166.597 97.584C166.469 97.7333 166.319 97.808 166.149 97.808H165.637C165.317 97.808 165.007 97.904 164.709 98.096C164.41 98.288 164.165 98.56 163.973 98.912C163.791 99.2533 163.701 99.6693 163.701 100.16V103.44C163.701 103.579 163.615 103.707 163.445 103.824C163.285 103.941 163.082 104 162.837 104ZM169.2 104.128C168.613 104.128 168.112 103.957 167.696 103.616C167.28 103.264 167.072 102.731 167.072 102.016C167.072 101.408 167.232 100.939 167.552 100.608C167.872 100.277 168.309 100.048 168.864 99.92C169.429 99.792 170.08 99.728 170.816 99.728H171.52V99.44C171.52 99.1627 171.467 98.896 171.36 98.64C171.264 98.3733 171.099 98.1547 170.864 97.984C170.64 97.8027 170.331 97.712 169.936 97.712C169.541 97.712 169.237 97.7493 169.024 97.824C168.811 97.8987 168.64 97.9787 168.512 98.064C168.384 98.1493 168.267 98.192 168.16 98.192C167.968 98.192 167.819 98.1013 167.712 97.92C167.605 97.728 167.552 97.536 167.552 97.344C167.552 97.152 167.675 96.9813 167.92 96.832C168.176 96.672 168.491 96.5493 168.864 96.464C169.237 96.368 169.605 96.32 169.968 96.32C170.757 96.32 171.387 96.4693 171.856 96.768C172.325 97.056 172.667 97.4347 172.88 97.904C173.093 98.3733 173.2 98.88 173.2 99.424V103.44C173.2 103.589 173.12 103.723 172.96 103.84C172.811 103.947 172.619 104 172.384 104C172.171 104 171.989 103.947 171.84 103.84C171.691 103.723 171.616 103.589 171.616 103.44V102.88C171.339 103.2 171.003 103.488 170.608 103.744C170.213 104 169.744 104.128 169.2 104.128ZM169.808 102.848C170.075 102.848 170.336 102.768 170.592 102.608C170.859 102.448 171.077 102.245 171.248 102C171.429 101.755 171.52 101.504 171.52 101.248V100.656H171.12C170.715 100.656 170.331 100.683 169.968 100.736C169.605 100.779 169.312 100.885 169.088 101.056C168.875 101.216 168.768 101.467 168.768 101.808C168.768 102.171 168.864 102.437 169.056 102.608C169.259 102.768 169.509 102.848 169.808 102.848ZM175.872 104C175.626 104 175.424 103.941 175.264 103.824C175.114 103.707 175.04 103.579 175.04 103.44V92.448C175.04 92.288 175.114 92.16 175.264 92.064C175.424 91.9573 175.626 91.904 175.872 91.904C176.106 91.904 176.304 91.9573 176.464 92.064C176.634 92.16 176.72 92.288 176.72 92.448V103.44C176.72 103.579 176.634 103.707 176.464 103.824C176.304 103.941 176.106 104 175.872 104ZM184.298 104.16C184.148 104.16 184.015 104.133 183.898 104.08C183.78 104.027 183.695 103.931 183.642 103.792L181.162 97.328C181.14 97.2747 181.119 97.2267 181.098 97.184C181.087 97.1307 181.082 97.088 181.082 97.056C181.082 96.9173 181.14 96.8 181.258 96.704C181.375 96.5973 181.514 96.512 181.674 96.448C181.844 96.384 182.004 96.352 182.154 96.352C182.271 96.352 182.378 96.3787 182.474 96.432C182.57 96.4747 182.634 96.5493 182.666 96.656L184.442 101.632L185.802 97.216C185.855 97.056 185.935 96.9547 186.042 96.912C186.148 96.8693 186.266 96.848 186.394 96.848C186.532 96.848 186.655 96.8693 186.762 96.912C186.868 96.9547 186.948 97.056 187.002 97.216L188.33 101.664L190.122 96.656C190.186 96.4533 190.351 96.352 190.618 96.352C190.767 96.352 190.922 96.384 191.082 96.448C191.252 96.5013 191.396 96.5813 191.514 96.688C191.631 96.7947 191.69 96.9227 191.69 97.072C191.69 97.104 191.684 97.1467 191.674 97.2C191.663 97.2533 191.647 97.296 191.626 97.328L189.146 103.824C189.103 103.952 189.018 104.037 188.89 104.08C188.772 104.133 188.639 104.16 188.49 104.16C188.319 104.16 188.17 104.133 188.042 104.08C187.924 104.027 187.844 103.947 187.802 103.84L186.394 99.712L185.018 103.792C184.975 103.92 184.884 104.011 184.746 104.064C184.618 104.128 184.468 104.16 184.298 104.16ZM194.372 104.128C193.785 104.128 193.284 103.957 192.868 103.616C192.452 103.264 192.244 102.731 192.244 102.016C192.244 101.408 192.404 100.939 192.724 100.608C193.044 100.277 193.481 100.048 194.036 99.92C194.601 99.792 195.252 99.728 195.988 99.728H196.692V99.44C196.692 99.1627 196.638 98.896 196.532 98.64C196.436 98.3733 196.27 98.1547 196.036 97.984C195.812 97.8027 195.502 97.712 195.108 97.712C194.713 97.712 194.409 97.7493 194.196 97.824C193.982 97.8987 193.812 97.9787 193.684 98.064C193.556 98.1493 193.438 98.192 193.332 98.192C193.14 98.192 192.99 98.1013 192.884 97.92C192.777 97.728 192.724 97.536 192.724 97.344C192.724 97.152 192.846 96.9813 193.092 96.832C193.348 96.672 193.662 96.5493 194.036 96.464C194.409 96.368 194.777 96.32 195.14 96.32C195.929 96.32 196.558 96.4693 197.028 96.768C197.497 97.056 197.838 97.4347 198.052 97.904C198.265 98.3733 198.372 98.88 198.372 99.424V103.44C198.372 103.589 198.292 103.723 198.132 103.84C197.982 103.947 197.79 104 197.556 104C197.342 104 197.161 103.947 197.012 103.84C196.862 103.723 196.788 103.589 196.788 103.44V102.88C196.51 103.2 196.174 103.488 195.78 103.744C195.385 104 194.916 104.128 194.372 104.128ZM194.98 102.848C195.246 102.848 195.508 102.768 195.764 102.608C196.03 102.448 196.249 102.245 196.42 102C196.601 101.755 196.692 101.504 196.692 101.248V100.656H196.292C195.886 100.656 195.502 100.683 195.14 100.736C194.777 100.779 194.484 100.885 194.26 101.056C194.046 101.216 193.94 101.467 193.94 101.808C193.94 102.171 194.036 102.437 194.228 102.608C194.43 102.768 194.681 102.848 194.98 102.848ZM202.388 104.128C201.865 104.128 201.396 104.064 200.98 103.936C200.564 103.808 200.233 103.648 199.988 103.456C199.753 103.253 199.636 103.051 199.636 102.848C199.636 102.752 199.657 102.645 199.7 102.528C199.753 102.411 199.822 102.309 199.908 102.224C200.004 102.139 200.105 102.096 200.212 102.096C200.35 102.096 200.494 102.16 200.644 102.288C200.804 102.405 201.012 102.528 201.268 102.656C201.524 102.773 201.881 102.832 202.34 102.832C202.873 102.832 203.23 102.741 203.411 102.56C203.604 102.379 203.7 102.181 203.7 101.968C203.7 101.691 203.604 101.477 203.411 101.328C203.23 101.168 202.99 101.04 202.692 100.944C202.404 100.848 202.094 100.757 201.764 100.672C201.433 100.576 201.118 100.453 200.82 100.304C200.532 100.155 200.292 99.9467 200.1 99.68C199.918 99.4133 199.828 99.0613 199.828 98.624C199.828 98.2613 199.918 97.904 200.1 97.552C200.281 97.1893 200.569 96.896 200.964 96.672C201.369 96.4373 201.908 96.32 202.58 96.32C202.985 96.32 203.369 96.3627 203.732 96.448C204.094 96.5333 204.393 96.6507 204.628 96.8C204.862 96.9387 204.98 97.0933 204.98 97.264C204.98 97.3387 204.953 97.4453 204.9 97.584C204.846 97.712 204.772 97.8293 204.676 97.936C204.59 98.032 204.478 98.08 204.34 98.08C204.233 98.08 204.1 98.0427 203.94 97.968C203.78 97.8827 203.593 97.8027 203.38 97.728C203.166 97.6533 202.905 97.616 202.596 97.616C202.286 97.616 202.036 97.6693 201.844 97.776C201.662 97.872 201.529 97.9893 201.444 98.128C201.358 98.2667 201.316 98.4053 201.316 98.544C201.316 98.7787 201.406 98.96 201.588 99.088C201.769 99.216 202.009 99.3227 202.308 99.408C202.606 99.4933 202.921 99.584 203.252 99.68C203.582 99.7653 203.892 99.8933 204.18 100.064C204.478 100.235 204.718 100.464 204.9 100.752C205.092 101.04 205.188 101.424 205.188 101.904C205.188 102.576 204.942 103.115 204.452 103.52C203.972 103.925 203.284 104.128 202.388 104.128ZM209.336 104C208.429 104 207.736 103.803 207.256 103.408C206.776 103.003 206.536 102.368 206.536 101.504V93.488C206.536 93.328 206.621 93.2 206.792 93.104C206.973 92.9973 207.165 92.944 207.368 92.944C207.57 92.944 207.762 92.9973 207.944 93.104C208.125 93.2 208.216 93.328 208.216 93.488V96.416H210.168C210.317 96.416 210.429 96.48 210.504 96.608C210.589 96.736 210.632 96.88 210.632 97.04C210.632 97.2 210.589 97.344 210.504 97.472C210.429 97.6 210.317 97.664 210.168 97.664H208.216V101.504C208.216 101.888 208.296 102.16 208.456 102.32C208.626 102.48 208.92 102.56 209.336 102.56H209.88C210.125 102.56 210.306 102.635 210.424 102.784C210.552 102.923 210.616 103.088 210.616 103.28C210.616 103.461 210.552 103.627 210.424 103.776C210.306 103.925 210.125 104 209.88 104H209.336ZM215.101 104.128C214.376 104.128 213.736 103.995 213.181 103.728C212.626 103.461 212.189 103.093 211.869 102.624C211.549 102.144 211.389 101.584 211.389 100.944V99.424C211.389 98.8587 211.538 98.3413 211.837 97.872C212.146 97.4027 212.552 97.0293 213.053 96.752C213.554 96.464 214.109 96.32 214.717 96.32C215.293 96.32 215.821 96.448 216.301 96.704C216.781 96.9493 217.165 97.296 217.453 97.744C217.752 98.192 217.901 98.704 217.901 99.28C217.901 99.728 217.832 100.048 217.693 100.24C217.554 100.432 217.373 100.549 217.149 100.592C216.925 100.635 216.69 100.656 216.445 100.656H213.069V101.024C213.069 101.557 213.261 101.984 213.645 102.304C214.04 102.613 214.541 102.768 215.149 102.768C215.522 102.768 215.826 102.715 216.061 102.608C216.296 102.501 216.493 102.4 216.653 102.304C216.813 102.208 216.962 102.16 217.101 102.16C217.24 102.16 217.357 102.203 217.453 102.288C217.549 102.373 217.624 102.475 217.677 102.592C217.73 102.709 217.757 102.816 217.757 102.912C217.757 103.072 217.645 103.248 217.421 103.44C217.208 103.632 216.904 103.797 216.509 103.936C216.114 104.064 215.645 104.128 215.101 104.128ZM213.069 99.616H215.725C215.96 99.616 216.114 99.584 216.189 99.52C216.274 99.456 216.317 99.328 216.317 99.136C216.317 98.8587 216.248 98.6027 216.109 98.368C215.97 98.1227 215.778 97.936 215.533 97.808C215.288 97.6693 215.01 97.6 214.701 97.6C214.402 97.6 214.13 97.664 213.885 97.792C213.64 97.92 213.442 98.096 213.293 98.32C213.144 98.544 213.069 98.8053 213.069 99.104V99.616ZM219.863 104.096C219.585 104.096 219.356 104 219.175 103.808C218.993 103.616 218.903 103.392 218.903 103.136C218.903 102.869 218.993 102.645 219.175 102.464C219.356 102.272 219.585 102.176 219.863 102.176C220.119 102.176 220.337 102.272 220.519 102.464C220.711 102.645 220.807 102.869 220.807 103.136C220.807 103.392 220.711 103.616 220.519 103.808C220.337 104 220.119 104.096 219.863 104.096ZM43.7533 124C43.5293 124 43.348 123.947 43.2093 123.84C43.0706 123.733 43.0013 123.605 43.0013 123.456V112.848C43.0013 112.699 43.0706 112.571 43.2093 112.464C43.348 112.357 43.5293 112.304 43.7533 112.304H46.5853C47.2573 112.304 47.8653 112.421 48.4093 112.656C48.964 112.891 49.396 113.269 49.7053 113.792C50.0253 114.315 50.1853 115.008 50.1853 115.872V120.432C50.1853 121.296 50.0253 121.989 49.7053 122.512C49.396 123.035 48.964 123.413 48.4093 123.648C47.8653 123.883 47.2573 124 46.5853 124H43.7533ZM44.6973 122.496H46.5853C47.1826 122.496 47.6466 122.331 47.9773 122C48.3186 121.659 48.4893 121.136 48.4893 120.432V115.872C48.4893 115.168 48.3186 114.651 47.9773 114.32C47.6466 113.979 47.1826 113.808 46.5853 113.808H44.6973V122.496ZM54.9892 124.128C54.4132 124.128 53.8745 123.979 53.3732 123.68C52.8719 123.381 52.4665 122.992 52.1572 122.512C51.8585 122.021 51.7092 121.499 51.7092 120.944V119.472C51.7092 118.907 51.8532 118.384 52.1412 117.904C52.4399 117.424 52.8399 117.04 53.3412 116.752C53.8532 116.464 54.4079 116.32 55.0052 116.32C55.6025 116.32 56.1519 116.464 56.6532 116.752C57.1545 117.029 57.5545 117.408 57.8532 117.888C58.1625 118.357 58.3172 118.885 58.3172 119.472V120.944C58.3172 121.488 58.1625 122.005 57.8532 122.496C57.5545 122.987 57.1492 123.381 56.6372 123.68C56.1359 123.979 55.5865 124.128 54.9892 124.128ZM55.0052 122.64C55.3039 122.64 55.5759 122.56 55.8212 122.4C56.0665 122.24 56.2639 122.032 56.4132 121.776C56.5625 121.509 56.6372 121.232 56.6372 120.944V119.472C56.6372 119.195 56.5625 118.928 56.4132 118.672C56.2639 118.416 56.0665 118.208 55.8212 118.048C55.5759 117.888 55.3039 117.808 55.0052 117.808C54.6959 117.808 54.4185 117.888 54.1732 118.048C53.9385 118.208 53.7465 118.416 53.5972 118.672C53.4585 118.928 53.3892 119.195 53.3892 119.472V120.944C53.3892 121.232 53.4585 121.509 53.5972 121.776C53.7465 122.032 53.9439 122.24 54.1892 122.4C54.4345 122.56 54.7065 122.64 55.0052 122.64ZM60.6104 124C60.3651 124 60.1624 123.941 60.0024 123.824C59.8531 123.707 59.7784 123.579 59.7784 123.44V116.96C59.7784 116.8 59.8531 116.672 60.0024 116.576C60.1624 116.469 60.3651 116.416 60.6104 116.416C60.8131 116.416 60.9891 116.469 61.1384 116.576C61.2878 116.672 61.3624 116.8 61.3624 116.96V117.536C61.5224 117.227 61.7838 116.949 62.1464 116.704C62.5198 116.448 62.9731 116.32 63.5064 116.32C64.0078 116.32 64.4664 116.464 64.8824 116.752C65.3091 117.029 65.6504 117.408 65.9064 117.888C66.1624 118.357 66.2904 118.885 66.2904 119.472V123.44C66.2904 123.621 66.1998 123.76 66.0184 123.856C65.8478 123.952 65.6558 124 65.4424 124C65.2504 124 65.0638 123.952 64.8824 123.856C64.7011 123.76 64.6104 123.621 64.6104 123.44V119.472C64.6104 119.195 64.5358 118.928 64.3864 118.672C64.2478 118.416 64.0558 118.208 63.8104 118.048C63.5651 117.888 63.2931 117.808 62.9944 117.808C62.7384 117.808 62.4931 117.877 62.2584 118.016C62.0238 118.144 61.8318 118.331 61.6824 118.576C61.5331 118.821 61.4584 119.12 61.4584 119.472V123.44C61.4584 123.579 61.3731 123.707 61.2024 123.824C61.0424 123.941 60.8451 124 60.6104 124ZM69.6139 124.128C69.0273 124.128 68.5259 123.957 68.1099 123.616C67.6939 123.264 67.4859 122.731 67.4859 122.016C67.4859 121.408 67.6459 120.939 67.9659 120.608C68.2859 120.277 68.7233 120.048 69.2779 119.92C69.8433 119.792 70.4939 119.728 71.2299 119.728H71.9339V119.44C71.9339 119.163 71.8806 118.896 71.7739 118.64C71.6779 118.373 71.5126 118.155 71.2779 117.984C71.0539 117.803 70.7446 117.712 70.3499 117.712C69.9553 117.712 69.6513 117.749 69.4379 117.824C69.2246 117.899 69.0539 117.979 68.9259 118.064C68.7979 118.149 68.6806 118.192 68.5739 118.192C68.3819 118.192 68.2326 118.101 68.1259 117.92C68.0193 117.728 67.9659 117.536 67.9659 117.344C67.9659 117.152 68.0886 116.981 68.3339 116.832C68.5899 116.672 68.9046 116.549 69.2779 116.464C69.6513 116.368 70.0193 116.32 70.3819 116.32C71.1713 116.32 71.8006 116.469 72.2699 116.768C72.7393 117.056 73.0806 117.435 73.2939 117.904C73.5073 118.373 73.6139 118.88 73.6139 119.424V123.44C73.6139 123.589 73.5339 123.723 73.3739 123.84C73.2246 123.947 73.0326 124 72.7979 124C72.5846 124 72.4033 123.947 72.2539 123.84C72.1046 123.723 72.0299 123.589 72.0299 123.44V122.88C71.7526 123.2 71.4166 123.488 71.0219 123.744C70.6273 124 70.1579 124.128 69.6139 124.128ZM70.2219 122.848C70.4886 122.848 70.7499 122.768 71.0059 122.608C71.2726 122.448 71.4913 122.245 71.6619 122C71.8433 121.755 71.9339 121.504 71.9339 121.248V120.656H71.5339C71.1286 120.656 70.7446 120.683 70.3819 120.736C70.0193 120.779 69.7259 120.885 69.5019 121.056C69.2886 121.216 69.1819 121.467 69.1819 121.808C69.1819 122.171 69.2779 122.437 69.4699 122.608C69.6726 122.768 69.9233 122.848 70.2219 122.848ZM78.0777 124C77.171 124 76.4777 123.803 75.9977 123.408C75.5177 123.003 75.2777 122.368 75.2777 121.504V113.488C75.2777 113.328 75.363 113.2 75.5337 113.104C75.715 112.997 75.907 112.944 76.1097 112.944C76.3124 112.944 76.5044 112.997 76.6857 113.104C76.867 113.2 76.9577 113.328 76.9577 113.488V116.416H78.9097C79.059 116.416 79.171 116.48 79.2457 116.608C79.331 116.736 79.3737 116.88 79.3737 117.04C79.3737 117.2 79.331 117.344 79.2457 117.472C79.171 117.6 79.059 117.664 78.9097 117.664H76.9577V121.504C76.9577 121.888 77.0377 122.16 77.1977 122.32C77.3684 122.48 77.6617 122.56 78.0777 122.56H78.6217C78.867 122.56 79.0484 122.635 79.1657 122.784C79.2937 122.923 79.3577 123.088 79.3577 123.28C79.3577 123.461 79.2937 123.627 79.1657 123.776C79.0484 123.925 78.867 124 78.6217 124H78.0777ZM83.8431 124.128C83.1177 124.128 82.4777 123.995 81.9231 123.728C81.3684 123.461 80.9311 123.093 80.6111 122.624C80.2911 122.144 80.1311 121.584 80.1311 120.944V119.424C80.1311 118.859 80.2804 118.341 80.5791 117.872C80.8884 117.403 81.2937 117.029 81.7951 116.752C82.2964 116.464 82.8511 116.32 83.4591 116.32C84.0351 116.32 84.5631 116.448 85.0431 116.704C85.5231 116.949 85.9071 117.296 86.1951 117.744C86.4937 118.192 86.6431 118.704 86.6431 119.28C86.6431 119.728 86.5737 120.048 86.4351 120.24C86.2964 120.432 86.1151 120.549 85.8911 120.592C85.6671 120.635 85.4324 120.656 85.1871 120.656H81.8111V121.024C81.8111 121.557 82.0031 121.984 82.3871 122.304C82.7817 122.613 83.2831 122.768 83.8911 122.768C84.2644 122.768 84.5684 122.715 84.8031 122.608C85.0377 122.501 85.2351 122.4 85.3951 122.304C85.5551 122.208 85.7044 122.16 85.8431 122.16C85.9817 122.16 86.0991 122.203 86.1951 122.288C86.2911 122.373 86.3657 122.475 86.4191 122.592C86.4724 122.709 86.4991 122.816 86.4991 122.912C86.4991 123.072 86.3871 123.248 86.1631 123.44C85.9497 123.632 85.6457 123.797 85.2511 123.936C84.8564 124.064 84.3871 124.128 83.8431 124.128ZM81.8111 119.616H84.4671C84.7017 119.616 84.8564 119.584 84.9311 119.52C85.0164 119.456 85.0591 119.328 85.0591 119.136C85.0591 118.859 84.9897 118.603 84.8511 118.368C84.7124 118.123 84.5204 117.936 84.2751 117.808C84.0297 117.669 83.7524 117.6 83.4431 117.6C83.1444 117.6 82.8724 117.664 82.6271 117.792C82.3817 117.92 82.1844 118.096 82.0351 118.32C81.8857 118.544 81.8111 118.805 81.8111 119.104V119.616ZM93.9839 124C93.0773 124 92.3839 123.803 91.9039 123.408C91.4239 123.003 91.1839 122.368 91.1839 121.504V113.488C91.1839 113.328 91.2693 113.2 91.4399 113.104C91.6213 112.997 91.8133 112.944 92.0159 112.944C92.2186 112.944 92.4106 112.997 92.5919 113.104C92.7733 113.2 92.8639 113.328 92.8639 113.488V116.416H94.8159C94.9653 116.416 95.0773 116.48 95.1519 116.608C95.2373 116.736 95.2799 116.88 95.2799 117.04C95.2799 117.2 95.2373 117.344 95.1519 117.472C95.0773 117.6 94.9653 117.664 94.8159 117.664H92.8639V121.504C92.8639 121.888 92.9439 122.16 93.1039 122.32C93.2746 122.48 93.5679 122.56 93.9839 122.56H94.5279C94.7733 122.56 94.9546 122.635 95.0719 122.784C95.1999 122.923 95.2639 123.088 95.2639 123.28C95.2639 123.461 95.1999 123.627 95.0719 123.776C94.9546 123.925 94.7733 124 94.5279 124H93.9839ZM99.3173 124.128C98.7413 124.128 98.2026 123.979 97.7013 123.68C97.2 123.381 96.7946 122.992 96.4853 122.512C96.1866 122.021 96.0373 121.499 96.0373 120.944V119.472C96.0373 118.907 96.1813 118.384 96.4693 117.904C96.768 117.424 97.168 117.04 97.6693 116.752C98.1813 116.464 98.736 116.32 99.3333 116.32C99.9306 116.32 100.48 116.464 100.981 116.752C101.483 117.029 101.883 117.408 102.181 117.888C102.491 118.357 102.645 118.885 102.645 119.472V120.944C102.645 121.488 102.491 122.005 102.181 122.496C101.883 122.987 101.477 123.381 100.965 123.68C100.464 123.979 99.9146 124.128 99.3173 124.128ZM99.3333 122.64C99.632 122.64 99.904 122.56 100.149 122.4C100.395 122.24 100.592 122.032 100.741 121.776C100.891 121.509 100.965 121.232 100.965 120.944V119.472C100.965 119.195 100.891 118.928 100.741 118.672C100.592 118.416 100.395 118.208 100.149 118.048C99.904 117.888 99.632 117.808 99.3333 117.808C99.024 117.808 98.7466 117.888 98.5013 118.048C98.2666 118.208 98.0746 118.416 97.9253 118.672C97.7866 118.928 97.7173 119.195 97.7173 119.472V120.944C97.7173 121.232 97.7866 121.509 97.9253 121.776C98.0746 122.032 98.272 122.24 98.5173 122.4C98.7626 122.56 99.0346 122.64 99.3333 122.64ZM104.107 127.6C103.894 127.6 103.713 127.552 103.563 127.456C103.414 127.371 103.339 127.179 103.339 126.88C103.339 126.688 103.371 126.517 103.435 126.368C103.499 126.229 103.617 126.16 103.787 126.16C103.99 126.16 104.209 126.107 104.443 126C104.689 125.904 104.923 125.744 105.147 125.52C105.382 125.307 105.579 125.035 105.739 124.704C105.91 124.373 106.027 123.984 106.091 123.536L103.387 117.328C103.345 117.253 103.323 117.179 103.323 117.104C103.323 116.965 103.382 116.837 103.499 116.72C103.627 116.592 103.777 116.491 103.947 116.416C104.118 116.341 104.278 116.304 104.427 116.304C104.534 116.304 104.635 116.331 104.731 116.384C104.838 116.427 104.907 116.501 104.939 116.608L106.955 121.808L108.699 116.608C108.731 116.501 108.795 116.427 108.891 116.384C108.987 116.331 109.083 116.304 109.179 116.304C109.307 116.304 109.457 116.341 109.627 116.416C109.809 116.491 109.963 116.592 110.091 116.72C110.23 116.837 110.299 116.976 110.299 117.136C110.299 117.221 110.283 117.285 110.251 117.328L107.851 123.584C107.681 124.043 107.505 124.507 107.323 124.976C107.142 125.456 106.918 125.893 106.651 126.288C106.395 126.683 106.059 126.997 105.643 127.232C105.238 127.477 104.726 127.6 104.107 127.6ZM113.661 124.128C113.138 124.128 112.669 124.064 112.253 123.936C111.837 123.808 111.506 123.648 111.261 123.456C111.026 123.253 110.909 123.051 110.909 122.848C110.909 122.752 110.93 122.645 110.973 122.528C111.026 122.411 111.096 122.309 111.181 122.224C111.277 122.139 111.378 122.096 111.485 122.096C111.624 122.096 111.768 122.16 111.917 122.288C112.077 122.405 112.285 122.528 112.541 122.656C112.797 122.773 113.154 122.832 113.613 122.832C114.146 122.832 114.504 122.741 114.685 122.56C114.877 122.379 114.973 122.181 114.973 121.968C114.973 121.691 114.877 121.477 114.685 121.328C114.504 121.168 114.264 121.04 113.965 120.944C113.677 120.848 113.368 120.757 113.037 120.672C112.706 120.576 112.392 120.453 112.093 120.304C111.805 120.155 111.565 119.947 111.373 119.68C111.192 119.413 111.101 119.061 111.101 118.624C111.101 118.261 111.192 117.904 111.373 117.552C111.554 117.189 111.842 116.896 112.237 116.672C112.642 116.437 113.181 116.32 113.853 116.32C114.258 116.32 114.642 116.363 115.005 116.448C115.368 116.533 115.666 116.651 115.901 116.8C116.136 116.939 116.253 117.093 116.253 117.264C116.253 117.339 116.226 117.445 116.173 117.584C116.12 117.712 116.045 117.829 115.949 117.936C115.864 118.032 115.752 118.08 115.613 118.08C115.506 118.08 115.373 118.043 115.213 117.968C115.053 117.883 114.866 117.803 114.653 117.728C114.44 117.653 114.178 117.616 113.869 117.616C113.56 117.616 113.309 117.669 113.117 117.776C112.936 117.872 112.802 117.989 112.717 118.128C112.632 118.267 112.589 118.405 112.589 118.544C112.589 118.779 112.68 118.96 112.861 119.088C113.042 119.216 113.282 119.323 113.581 119.408C113.88 119.493 114.194 119.584 114.525 119.68C114.856 119.765 115.165 119.893 115.453 120.064C115.752 120.235 115.992 120.464 116.173 120.752C116.365 121.04 116.461 121.424 116.461 121.904C116.461 122.576 116.216 123.115 115.725 123.52C115.245 123.925 114.557 124.128 113.661 124.128ZM121.876 114.512C121.609 114.512 121.38 114.421 121.188 114.24C120.996 114.059 120.9 113.856 120.9 113.632C120.9 113.387 120.996 113.179 121.188 113.008C121.38 112.837 121.609 112.752 121.876 112.752C122.143 112.752 122.367 112.837 122.548 113.008C122.74 113.179 122.836 113.387 122.836 113.632C122.836 113.856 122.74 114.059 122.548 114.24C122.367 114.421 122.143 114.512 121.876 114.512ZM121.876 124C121.631 124 121.428 123.941 121.268 123.824C121.119 123.707 121.044 123.579 121.044 123.44V116.96C121.044 116.8 121.119 116.672 121.268 116.576C121.428 116.469 121.631 116.416 121.876 116.416C122.111 116.416 122.308 116.469 122.468 116.576C122.639 116.672 122.724 116.8 122.724 116.96V123.44C122.724 123.579 122.639 123.707 122.468 123.824C122.308 123.941 122.111 124 121.876 124ZM125.298 124C125.053 124 124.85 123.941 124.69 123.824C124.541 123.707 124.466 123.579 124.466 123.44V116.96C124.466 116.8 124.541 116.672 124.69 116.576C124.85 116.469 125.053 116.416 125.298 116.416C125.501 116.416 125.677 116.469 125.826 116.576C125.975 116.672 126.05 116.8 126.05 116.96V117.536C126.21 117.227 126.471 116.949 126.834 116.704C127.207 116.448 127.661 116.32 128.194 116.32C128.695 116.32 129.154 116.464 129.57 116.752C129.997 117.029 130.338 117.408 130.594 117.888C130.85 118.357 130.978 118.885 130.978 119.472V123.44C130.978 123.621 130.887 123.76 130.706 123.856C130.535 123.952 130.343 124 130.13 124C129.938 124 129.751 123.952 129.57 123.856C129.389 123.76 129.298 123.621 129.298 123.44V119.472C129.298 119.195 129.223 118.928 129.074 118.672C128.935 118.416 128.743 118.208 128.498 118.048C128.253 117.888 127.981 117.808 127.682 117.808C127.426 117.808 127.181 117.877 126.946 118.016C126.711 118.144 126.519 118.331 126.37 118.576C126.221 118.821 126.146 119.12 126.146 119.472V123.44C126.146 123.579 126.061 123.707 125.89 123.824C125.73 123.941 125.533 124 125.298 124ZM138.721 127.6C138.102 127.6 137.531 127.509 137.009 127.328C136.486 127.157 136.07 126.907 135.761 126.576C135.451 126.245 135.297 125.851 135.297 125.392C135.297 124.965 135.419 124.608 135.665 124.32C135.91 124.043 136.198 123.829 136.529 123.68C136.315 123.584 136.139 123.456 136.001 123.296C135.862 123.136 135.793 122.912 135.793 122.624C135.793 122.325 135.867 122.085 136.017 121.904C136.166 121.723 136.358 121.557 136.593 121.408C136.294 121.173 136.059 120.885 135.889 120.544C135.729 120.192 135.649 119.808 135.649 119.392V118.944C135.649 118.432 135.771 117.979 136.017 117.584C136.262 117.189 136.609 116.88 137.057 116.656C137.515 116.432 138.038 116.32 138.625 116.32C138.987 116.32 139.323 116.368 139.633 116.464C139.953 116.56 140.235 116.693 140.481 116.864C140.651 116.469 140.822 116.192 140.993 116.032C141.174 115.872 141.345 115.792 141.505 115.792C141.729 115.792 141.899 115.856 142.017 115.984C142.134 116.112 142.193 116.24 142.193 116.368C142.193 116.453 142.166 116.533 142.113 116.608C142.07 116.672 142.006 116.725 141.921 116.768C141.814 116.821 141.686 116.896 141.537 116.992C141.398 117.077 141.259 117.216 141.121 117.408C141.302 117.611 141.435 117.845 141.521 118.112C141.606 118.379 141.649 118.656 141.649 118.944V119.392C141.649 119.893 141.521 120.347 141.265 120.752C141.009 121.157 140.651 121.477 140.193 121.712C139.734 121.936 139.211 122.048 138.625 122.048C138.209 122.048 137.841 121.984 137.521 121.856C137.435 121.909 137.361 121.973 137.297 122.048C137.243 122.112 137.217 122.197 137.217 122.304C137.217 122.496 137.334 122.635 137.569 122.72C137.803 122.805 138.102 122.869 138.465 122.912C138.838 122.955 139.233 123.008 139.649 123.072C140.065 123.136 140.454 123.243 140.817 123.392C141.19 123.531 141.494 123.739 141.729 124.016C141.963 124.304 142.081 124.693 142.081 125.184C142.081 125.739 141.926 126.192 141.617 126.544C141.307 126.907 140.897 127.173 140.385 127.344C139.883 127.515 139.329 127.6 138.721 127.6ZM138.689 126.48C139.211 126.48 139.633 126.363 139.953 126.128C140.283 125.904 140.449 125.605 140.449 125.232C140.449 124.965 140.369 124.757 140.209 124.608C140.049 124.459 139.841 124.347 139.585 124.272C139.329 124.197 139.057 124.144 138.769 124.112C138.491 124.08 138.225 124.048 137.969 124.016C137.67 124.123 137.414 124.272 137.201 124.464C136.998 124.667 136.897 124.917 136.897 125.216C136.897 125.611 137.062 125.92 137.393 126.144C137.734 126.368 138.166 126.48 138.689 126.48ZM138.657 120.976C139.083 120.976 139.414 120.827 139.649 120.528C139.894 120.229 140.017 119.851 140.017 119.392V118.944C140.017 118.507 139.894 118.139 139.649 117.84C139.414 117.541 139.078 117.392 138.641 117.392C138.203 117.392 137.867 117.541 137.633 117.84C137.398 118.139 137.281 118.507 137.281 118.944V119.376C137.281 119.824 137.398 120.203 137.633 120.512C137.867 120.821 138.209 120.976 138.657 120.976ZM146.255 124.128C145.679 124.128 145.14 123.979 144.639 123.68C144.137 123.381 143.732 122.992 143.423 122.512C143.124 122.021 142.975 121.499 142.975 120.944V119.472C142.975 118.907 143.119 118.384 143.407 117.904C143.705 117.424 144.105 117.04 144.607 116.752C145.119 116.464 145.673 116.32 146.271 116.32C146.868 116.32 147.417 116.464 147.919 116.752C148.42 117.029 148.82 117.408 149.119 117.888C149.428 118.357 149.583 118.885 149.583 119.472V120.944C149.583 121.488 149.428 122.005 149.119 122.496C148.82 122.987 148.415 123.381 147.903 123.68C147.401 123.979 146.852 124.128 146.255 124.128ZM146.271 122.64C146.569 122.64 146.841 122.56 147.087 122.4C147.332 122.24 147.529 122.032 147.679 121.776C147.828 121.509 147.903 121.232 147.903 120.944V119.472C147.903 119.195 147.828 118.928 147.679 118.672C147.529 118.416 147.332 118.208 147.087 118.048C146.841 117.888 146.569 117.808 146.271 117.808C145.961 117.808 145.684 117.888 145.439 118.048C145.204 118.208 145.012 118.416 144.863 118.672C144.724 118.928 144.655 119.195 144.655 119.472V120.944C144.655 121.232 144.724 121.509 144.863 121.776C145.012 122.032 145.209 122.24 145.455 122.4C145.7 122.56 145.972 122.64 146.271 122.64ZM154.036 124.128C153.46 124.128 152.921 123.979 152.42 123.68C151.919 123.381 151.513 122.992 151.204 122.512C150.905 122.021 150.756 121.499 150.756 120.944V119.472C150.756 118.907 150.9 118.384 151.188 117.904C151.487 117.424 151.887 117.04 152.388 116.752C152.9 116.464 153.455 116.32 154.052 116.32C154.649 116.32 155.199 116.464 155.7 116.752C156.201 117.029 156.601 117.408 156.9 117.888C157.209 118.357 157.364 118.885 157.364 119.472V120.944C157.364 121.488 157.209 122.005 156.9 122.496C156.601 122.987 156.196 123.381 155.684 123.68C155.183 123.979 154.633 124.128 154.036 124.128ZM154.052 122.64C154.351 122.64 154.623 122.56 154.868 122.4C155.113 122.24 155.311 122.032 155.46 121.776C155.609 121.509 155.684 121.232 155.684 120.944V119.472C155.684 119.195 155.609 118.928 155.46 118.672C155.311 118.416 155.113 118.208 154.868 118.048C154.623 117.888 154.351 117.808 154.052 117.808C153.743 117.808 153.465 117.888 153.22 118.048C152.985 118.208 152.793 118.416 152.644 118.672C152.505 118.928 152.436 119.195 152.436 119.472V120.944C152.436 121.232 152.505 121.509 152.644 121.776C152.793 122.032 152.991 122.24 153.236 122.4C153.481 122.56 153.753 122.64 154.052 122.64ZM161.353 124.128C160.852 124.128 160.388 123.979 159.961 123.68C159.535 123.381 159.188 122.992 158.921 122.512C158.665 122.021 158.537 121.499 158.537 120.944V119.472C158.537 118.885 158.665 118.357 158.921 117.888C159.188 117.408 159.535 117.029 159.961 116.752C160.388 116.464 160.863 116.32 161.385 116.32C161.897 116.32 162.329 116.448 162.681 116.704C163.033 116.949 163.295 117.227 163.465 117.536V112.448C163.465 112.288 163.551 112.16 163.721 112.064C163.892 111.957 164.095 111.904 164.329 111.904C164.564 111.904 164.756 111.957 164.905 112.064C165.065 112.16 165.145 112.288 165.145 112.448V123.44C165.145 123.579 165.065 123.707 164.905 123.824C164.756 123.941 164.564 124 164.329 124C164.127 124 163.945 123.941 163.785 123.824C163.636 123.707 163.561 123.579 163.561 123.44V122.88C163.401 123.211 163.119 123.504 162.713 123.76C162.308 124.005 161.855 124.128 161.353 124.128ZM161.833 122.64C162.143 122.64 162.42 122.555 162.665 122.384C162.911 122.213 163.103 122.027 163.241 121.824C163.391 121.611 163.465 121.44 163.465 121.312V119.472C163.465 119.12 163.385 118.821 163.225 118.576C163.065 118.331 162.863 118.144 162.617 118.016C162.372 117.877 162.116 117.808 161.849 117.808C161.551 117.808 161.273 117.888 161.017 118.048C160.772 118.208 160.575 118.416 160.425 118.672C160.287 118.928 160.217 119.195 160.217 119.472V120.944C160.217 121.221 160.287 121.493 160.425 121.76C160.575 122.027 160.772 122.24 161.017 122.4C161.263 122.56 161.535 122.64 161.833 122.64ZM173.194 124.128C172.426 124.128 171.792 123.989 171.29 123.712C170.8 123.435 170.437 123.056 170.202 122.576C169.968 122.096 169.85 121.552 169.85 120.944V119.504C169.85 118.907 169.968 118.368 170.202 117.888C170.437 117.397 170.8 117.013 171.29 116.736C171.781 116.459 172.405 116.32 173.162 116.32C173.653 116.32 174.08 116.379 174.442 116.496C174.816 116.613 175.104 116.763 175.306 116.944C175.52 117.115 175.626 117.296 175.626 117.488C175.626 117.584 175.594 117.701 175.53 117.84C175.477 117.968 175.397 118.08 175.29 118.176C175.194 118.261 175.077 118.304 174.938 118.304C174.832 118.304 174.714 118.261 174.586 118.176C174.469 118.091 174.309 118.011 174.106 117.936C173.904 117.851 173.632 117.808 173.29 117.808C172.693 117.808 172.25 117.957 171.962 118.256C171.674 118.555 171.53 118.971 171.53 119.504V120.944C171.53 121.477 171.674 121.893 171.962 122.192C172.25 122.491 172.698 122.64 173.306 122.64C173.658 122.64 173.936 122.597 174.138 122.512C174.341 122.416 174.501 122.325 174.618 122.24C174.746 122.155 174.869 122.112 174.986 122.112C175.136 122.112 175.264 122.155 175.37 122.24C175.488 122.325 175.573 122.432 175.626 122.56C175.69 122.688 175.722 122.805 175.722 122.912C175.722 123.093 175.61 123.28 175.386 123.472C175.173 123.664 174.874 123.824 174.49 123.952C174.117 124.069 173.685 124.128 173.194 124.128ZM179.833 124.128C179.257 124.128 178.718 123.979 178.217 123.68C177.716 123.381 177.31 122.992 177.001 122.512C176.702 122.021 176.553 121.499 176.553 120.944V119.472C176.553 118.907 176.697 118.384 176.985 117.904C177.284 117.424 177.684 117.04 178.185 116.752C178.697 116.464 179.252 116.32 179.849 116.32C180.446 116.32 180.996 116.464 181.497 116.752C181.998 117.029 182.398 117.408 182.697 117.888C183.006 118.357 183.161 118.885 183.161 119.472V120.944C183.161 121.488 183.006 122.005 182.697 122.496C182.398 122.987 181.993 123.381 181.481 123.68C180.98 123.979 180.43 124.128 179.833 124.128ZM179.849 122.64C180.148 122.64 180.42 122.56 180.665 122.4C180.91 122.24 181.108 122.032 181.257 121.776C181.406 121.509 181.481 121.232 181.481 120.944V119.472C181.481 119.195 181.406 118.928 181.257 118.672C181.108 118.416 180.91 118.208 180.665 118.048C180.42 117.888 180.148 117.808 179.849 117.808C179.54 117.808 179.262 117.888 179.017 118.048C178.782 118.208 178.59 118.416 178.441 118.672C178.302 118.928 178.233 119.195 178.233 119.472V120.944C178.233 121.232 178.302 121.509 178.441 121.776C178.59 122.032 178.788 122.24 179.033 122.4C179.278 122.56 179.55 122.64 179.849 122.64ZM185.454 124C185.209 124 185.006 123.941 184.846 123.824C184.697 123.707 184.622 123.579 184.622 123.44V116.96C184.622 116.8 184.697 116.672 184.846 116.576C185.006 116.469 185.209 116.416 185.454 116.416C185.657 116.416 185.833 116.469 185.982 116.576C186.132 116.672 186.206 116.8 186.206 116.96V117.536C186.366 117.227 186.628 116.949 186.99 116.704C187.364 116.448 187.817 116.32 188.35 116.32C188.852 116.32 189.31 116.464 189.726 116.752C190.153 117.029 190.494 117.408 190.75 117.888C191.006 118.357 191.134 118.885 191.134 119.472V123.44C191.134 123.621 191.044 123.76 190.862 123.856C190.692 123.952 190.5 124 190.286 124C190.094 124 189.908 123.952 189.726 123.856C189.545 123.76 189.454 123.621 189.454 123.44V119.472C189.454 119.195 189.38 118.928 189.23 118.672C189.092 118.416 188.9 118.208 188.654 118.048C188.409 117.888 188.137 117.808 187.838 117.808C187.582 117.808 187.337 117.877 187.102 118.016C186.868 118.144 186.676 118.331 186.526 118.576C186.377 118.821 186.302 119.12 186.302 119.472V123.44C186.302 123.579 186.217 123.707 186.046 123.824C185.886 123.941 185.689 124 185.454 124ZM195.338 124.128C194.836 124.128 194.372 123.979 193.946 123.68C193.519 123.381 193.172 122.992 192.906 122.512C192.65 122.021 192.522 121.499 192.522 120.944V119.472C192.522 118.885 192.65 118.357 192.906 117.888C193.172 117.408 193.519 117.029 193.946 116.752C194.372 116.464 194.847 116.32 195.37 116.32C195.882 116.32 196.314 116.448 196.666 116.704C197.018 116.949 197.279 117.227 197.45 117.536V112.448C197.45 112.288 197.535 112.16 197.706 112.064C197.876 111.957 198.079 111.904 198.314 111.904C198.548 111.904 198.74 111.957 198.89 112.064C199.05 112.16 199.13 112.288 199.13 112.448V123.44C199.13 123.579 199.05 123.707 198.89 123.824C198.74 123.941 198.548 124 198.314 124C198.111 124 197.93 123.941 197.77 123.824C197.62 123.707 197.546 123.579 197.546 123.44V122.88C197.386 123.211 197.103 123.504 196.698 123.76C196.292 124.005 195.839 124.128 195.338 124.128ZM195.818 122.64C196.127 122.64 196.404 122.555 196.65 122.384C196.895 122.213 197.087 122.027 197.226 121.824C197.375 121.611 197.45 121.44 197.45 121.312V119.472C197.45 119.12 197.37 118.821 197.21 118.576C197.05 118.331 196.847 118.144 196.602 118.016C196.356 117.877 196.1 117.808 195.834 117.808C195.535 117.808 195.258 117.888 195.002 118.048C194.756 118.208 194.559 118.416 194.41 118.672C194.271 118.928 194.202 119.195 194.202 119.472V120.944C194.202 121.221 194.271 121.493 194.41 121.76C194.559 122.027 194.756 122.24 195.002 122.4C195.247 122.56 195.519 122.64 195.818 122.64ZM201.735 114.512C201.469 114.512 201.239 114.421 201.047 114.24C200.855 114.059 200.759 113.856 200.759 113.632C200.759 113.387 200.855 113.179 201.047 113.008C201.239 112.837 201.469 112.752 201.735 112.752C202.002 112.752 202.226 112.837 202.407 113.008C202.599 113.179 202.695 113.387 202.695 113.632C202.695 113.856 202.599 114.059 202.407 114.24C202.226 114.421 202.002 114.512 201.735 114.512ZM201.735 124C201.49 124 201.287 123.941 201.127 123.824C200.978 123.707 200.903 123.579 200.903 123.44V116.96C200.903 116.8 200.978 116.672 201.127 116.576C201.287 116.469 201.49 116.416 201.735 116.416C201.97 116.416 202.167 116.469 202.327 116.576C202.498 116.672 202.583 116.8 202.583 116.96V123.44C202.583 123.579 202.498 123.707 202.327 123.824C202.167 123.941 201.97 124 201.735 124ZM207.093 124C206.187 124 205.493 123.803 205.013 123.408C204.533 123.003 204.293 122.368 204.293 121.504V113.488C204.293 113.328 204.379 113.2 204.549 113.104C204.731 112.997 204.923 112.944 205.125 112.944C205.328 112.944 205.52 112.997 205.701 113.104C205.883 113.2 205.973 113.328 205.973 113.488V116.416H207.925C208.075 116.416 208.187 116.48 208.261 116.608C208.347 116.736 208.389 116.88 208.389 117.04C208.389 117.2 208.347 117.344 208.261 117.472C208.187 117.6 208.075 117.664 207.925 117.664H205.973V121.504C205.973 121.888 206.053 122.16 206.213 122.32C206.384 122.48 206.677 122.56 207.093 122.56H207.637C207.883 122.56 208.064 122.635 208.181 122.784C208.309 122.923 208.373 123.088 208.373 123.28C208.373 123.461 208.309 123.627 208.181 123.776C208.064 123.925 207.883 124 207.637 124H207.093ZM210.376 114.512C210.109 114.512 209.88 114.421 209.688 114.24C209.496 114.059 209.4 113.856 209.4 113.632C209.4 113.387 209.496 113.179 209.688 113.008C209.88 112.837 210.109 112.752 210.376 112.752C210.643 112.752 210.867 112.837 211.048 113.008C211.24 113.179 211.336 113.387 211.336 113.632C211.336 113.856 211.24 114.059 211.048 114.24C210.867 114.421 210.643 114.512 210.376 114.512ZM210.376 124C210.131 124 209.928 123.941 209.768 123.824C209.619 123.707 209.544 123.579 209.544 123.44V116.96C209.544 116.8 209.619 116.672 209.768 116.576C209.928 116.469 210.131 116.416 210.376 116.416C210.611 116.416 210.808 116.469 210.968 116.576C211.139 116.672 211.224 116.8 211.224 116.96V123.44C211.224 123.579 211.139 123.707 210.968 123.824C210.808 123.941 210.611 124 210.376 124ZM215.958 124.128C215.382 124.128 214.843 123.979 214.342 123.68C213.841 123.381 213.435 122.992 213.126 122.512C212.827 122.021 212.678 121.499 212.678 120.944V119.472C212.678 118.907 212.822 118.384 213.11 117.904C213.409 117.424 213.809 117.04 214.31 116.752C214.822 116.464 215.377 116.32 215.974 116.32C216.571 116.32 217.121 116.464 217.622 116.752C218.123 117.029 218.523 117.408 218.822 117.888C219.131 118.357 219.286 118.885 219.286 119.472V120.944C219.286 121.488 219.131 122.005 218.822 122.496C218.523 122.987 218.118 123.381 217.606 123.68C217.105 123.979 216.555 124.128 215.958 124.128ZM215.974 122.64C216.273 122.64 216.545 122.56 216.79 122.4C217.035 122.24 217.233 122.032 217.382 121.776C217.531 121.509 217.606 121.232 217.606 120.944V119.472C217.606 119.195 217.531 118.928 217.382 118.672C217.233 118.416 217.035 118.208 216.79 118.048C216.545 117.888 216.273 117.808 215.974 117.808C215.665 117.808 215.387 117.888 215.142 118.048C214.907 118.208 214.715 118.416 214.566 118.672C214.427 118.928 214.358 119.195 214.358 119.472V120.944C214.358 121.232 214.427 121.509 214.566 121.776C214.715 122.032 214.913 122.24 215.158 122.4C215.403 122.56 215.675 122.64 215.974 122.64ZM221.579 124C221.334 124 221.131 123.941 220.971 123.824C220.822 123.707 220.747 123.579 220.747 123.44V116.96C220.747 116.8 220.822 116.672 220.971 116.576C221.131 116.469 221.334 116.416 221.579 116.416C221.782 116.416 221.958 116.469 222.107 116.576C222.257 116.672 222.331 116.8 222.331 116.96V117.536C222.491 117.227 222.753 116.949 223.115 116.704C223.489 116.448 223.942 116.32 224.475 116.32C224.977 116.32 225.435 116.464 225.851 116.752C226.278 117.029 226.619 117.408 226.875 117.888C227.131 118.357 227.259 118.885 227.259 119.472V123.44C227.259 123.621 227.169 123.76 226.987 123.856C226.817 123.952 226.625 124 226.411 124C226.219 124 226.033 123.952 225.851 123.856C225.67 123.76 225.579 123.621 225.579 123.44V119.472C225.579 119.195 225.505 118.928 225.355 118.672C225.217 118.416 225.025 118.208 224.779 118.048C224.534 117.888 224.262 117.808 223.963 117.808C223.707 117.808 223.462 117.877 223.227 118.016C222.993 118.144 222.801 118.331 222.651 118.576C222.502 118.821 222.427 119.12 222.427 119.472V123.44C222.427 123.579 222.342 123.707 222.171 123.824C222.011 123.941 221.814 124 221.579 124ZM72.3366 144.16C72.1872 144.16 72.0539 144.133 71.9366 144.08C71.8192 144.027 71.7339 143.931 71.6806 143.792L69.2006 137.328C69.1792 137.275 69.1579 137.227 69.1366 137.184C69.1259 137.131 69.1206 137.088 69.1206 137.056C69.1206 136.917 69.1792 136.8 69.2966 136.704C69.4139 136.597 69.5526 136.512 69.7126 136.448C69.8832 136.384 70.0432 136.352 70.1926 136.352C70.3099 136.352 70.4166 136.379 70.5126 136.432C70.6086 136.475 70.6726 136.549 70.7046 136.656L72.4806 141.632L73.8406 137.216C73.8939 137.056 73.9739 136.955 74.0806 136.912C74.1872 136.869 74.3046 136.848 74.4326 136.848C74.5712 136.848 74.6939 136.869 74.8006 136.912C74.9072 136.955 74.9872 137.056 75.0406 137.216L76.3686 141.664L78.1606 136.656C78.2246 136.453 78.3899 136.352 78.6566 136.352C78.8059 136.352 78.9606 136.384 79.1206 136.448C79.2912 136.501 79.4352 136.581 79.5526 136.688C79.6699 136.795 79.7286 136.923 79.7286 137.072C79.7286 137.104 79.7232 137.147 79.7126 137.2C79.7019 137.253 79.6859 137.296 79.6646 137.328L77.1846 143.824C77.1419 143.952 77.0566 144.037 76.9286 144.08C76.8112 144.133 76.6779 144.16 76.5286 144.16C76.3579 144.16 76.2086 144.133 76.0806 144.08C75.9632 144.027 75.8832 143.947 75.8406 143.84L74.4326 139.712L73.0566 143.792C73.0139 143.92 72.9232 144.011 72.7846 144.064C72.6566 144.128 72.5072 144.16 72.3366 144.16ZM81.6108 144C81.3655 144 81.1628 143.941 81.0028 143.824C80.8535 143.707 80.7788 143.579 80.7788 143.44V132.448C80.7788 132.288 80.8535 132.16 81.0028 132.064C81.1628 131.957 81.3655 131.904 81.6108 131.904C81.8455 131.904 82.0428 131.957 82.2028 132.064C82.3735 132.16 82.4588 132.288 82.4588 132.448V137.536C82.6188 137.227 82.8695 136.949 83.2108 136.704C83.5628 136.448 83.9948 136.32 84.5068 136.32C85.0081 136.32 85.4668 136.464 85.8828 136.752C86.3095 137.029 86.6508 137.408 86.9068 137.888C87.1628 138.357 87.2908 138.885 87.2908 139.472V143.44C87.2908 143.621 87.2001 143.76 87.0188 143.856C86.8481 143.952 86.6561 144 86.4428 144C86.2508 144 86.0641 143.952 85.8828 143.856C85.7015 143.76 85.6108 143.621 85.6108 143.44V139.472C85.6108 139.195 85.5361 138.928 85.3868 138.672C85.2375 138.416 85.0401 138.208 84.7948 138.048C84.5601 137.888 84.2935 137.808 83.9948 137.808C83.7388 137.808 83.4935 137.877 83.2588 138.016C83.0241 138.144 82.8321 138.331 82.6828 138.576C82.5335 138.821 82.4588 139.12 82.4588 139.472V143.44C82.4588 143.579 82.3735 143.707 82.2028 143.824C82.0428 143.941 81.8455 144 81.6108 144ZM89.7979 134.512C89.5313 134.512 89.3019 134.421 89.1099 134.24C88.9179 134.059 88.8219 133.856 88.8219 133.632C88.8219 133.387 88.9179 133.179 89.1099 133.008C89.3019 132.837 89.5313 132.752 89.7979 132.752C90.0646 132.752 90.2886 132.837 90.4699 133.008C90.6619 133.179 90.7579 133.387 90.7579 133.632C90.7579 133.856 90.6619 134.059 90.4699 134.24C90.2886 134.421 90.0646 134.512 89.7979 134.512ZM89.7979 144C89.5526 144 89.3499 143.941 89.1899 143.824C89.0406 143.707 88.9659 143.579 88.9659 143.44V136.96C88.9659 136.8 89.0406 136.672 89.1899 136.576C89.3499 136.469 89.5526 136.416 89.7979 136.416C90.0326 136.416 90.2299 136.469 90.3899 136.576C90.5606 136.672 90.6459 136.8 90.6459 136.96V143.44C90.6459 143.579 90.5606 143.707 90.3899 143.824C90.2299 143.941 90.0326 144 89.7979 144ZM95.4598 144.128C94.6918 144.128 94.0571 143.989 93.5558 143.712C93.0651 143.435 92.7025 143.056 92.4678 142.576C92.2331 142.096 92.1158 141.552 92.1158 140.944V139.504C92.1158 138.907 92.2331 138.368 92.4678 137.888C92.7025 137.397 93.0651 137.013 93.5558 136.736C94.0465 136.459 94.6705 136.32 95.4278 136.32C95.9185 136.32 96.3451 136.379 96.7078 136.496C97.0811 136.613 97.3691 136.763 97.5718 136.944C97.7851 137.115 97.8918 137.296 97.8918 137.488C97.8918 137.584 97.8598 137.701 97.7958 137.84C97.7425 137.968 97.6625 138.08 97.5558 138.176C97.4598 138.261 97.3425 138.304 97.2038 138.304C97.0971 138.304 96.9798 138.261 96.8518 138.176C96.7345 138.091 96.5745 138.011 96.3718 137.936C96.1691 137.851 95.8971 137.808 95.5558 137.808C94.9585 137.808 94.5158 137.957 94.2278 138.256C93.9398 138.555 93.7958 138.971 93.7958 139.504V140.944C93.7958 141.477 93.9398 141.893 94.2278 142.192C94.5158 142.491 94.9638 142.64 95.5718 142.64C95.9238 142.64 96.2011 142.597 96.4038 142.512C96.6065 142.416 96.7665 142.325 96.8838 142.24C97.0118 142.155 97.1345 142.112 97.2518 142.112C97.4011 142.112 97.5291 142.155 97.6358 142.24C97.7531 142.325 97.8385 142.432 97.8918 142.56C97.9558 142.688 97.9878 142.805 97.9878 142.912C97.9878 143.093 97.8758 143.28 97.6518 143.472C97.4385 143.664 97.1398 143.824 96.7558 143.952C96.3825 144.069 95.9505 144.128 95.4598 144.128ZM100.033 144C99.7874 144 99.5847 143.941 99.4247 143.824C99.2754 143.707 99.2007 143.579 99.2007 143.44V132.448C99.2007 132.288 99.2754 132.16 99.4247 132.064C99.5847 131.957 99.7874 131.904 100.033 131.904C100.267 131.904 100.465 131.957 100.625 132.064C100.795 132.16 100.881 132.288 100.881 132.448V137.536C101.041 137.227 101.291 136.949 101.633 136.704C101.985 136.448 102.417 136.32 102.929 136.32C103.43 136.32 103.889 136.464 104.305 136.752C104.731 137.029 105.073 137.408 105.329 137.888C105.585 138.357 105.713 138.885 105.713 139.472V143.44C105.713 143.621 105.622 143.76 105.441 143.856C105.27 143.952 105.078 144 104.865 144C104.673 144 104.486 143.952 104.305 143.856C104.123 143.76 104.033 143.621 104.033 143.44V139.472C104.033 139.195 103.958 138.928 103.809 138.672C103.659 138.416 103.462 138.208 103.217 138.048C102.982 137.888 102.715 137.808 102.417 137.808C102.161 137.808 101.915 137.877 101.681 138.016C101.446 138.144 101.254 138.331 101.105 138.576C100.955 138.821 100.881 139.12 100.881 139.472V143.44C100.881 143.579 100.795 143.707 100.625 143.824C100.465 143.941 100.267 144 100.033 144ZM113.663 144.128C112.895 144.128 112.26 143.989 111.759 143.712C111.268 143.435 110.906 143.056 110.671 142.576C110.436 142.096 110.319 141.552 110.319 140.944V139.504C110.319 138.907 110.436 138.368 110.671 137.888C110.906 137.397 111.268 137.013 111.759 136.736C112.25 136.459 112.874 136.32 113.631 136.32C114.122 136.32 114.548 136.379 114.911 136.496C115.284 136.613 115.572 136.763 115.775 136.944C115.988 137.115 116.095 137.296 116.095 137.488C116.095 137.584 116.063 137.701 115.999 137.84C115.946 137.968 115.866 138.08 115.759 138.176C115.663 138.261 115.546 138.304 115.407 138.304C115.3 138.304 115.183 138.261 115.055 138.176C114.938 138.091 114.778 138.011 114.575 137.936C114.372 137.851 114.1 137.808 113.759 137.808C113.162 137.808 112.719 137.957 112.431 138.256C112.143 138.555 111.999 138.971 111.999 139.504V140.944C111.999 141.477 112.143 141.893 112.431 142.192C112.719 142.491 113.167 142.64 113.775 142.64C114.127 142.64 114.404 142.597 114.607 142.512C114.81 142.416 114.97 142.325 115.087 142.24C115.215 142.155 115.338 142.112 115.455 142.112C115.604 142.112 115.732 142.155 115.839 142.24C115.956 142.325 116.042 142.432 116.095 142.56C116.159 142.688 116.191 142.805 116.191 142.912C116.191 143.093 116.079 143.28 115.855 143.472C115.642 143.664 115.343 143.824 114.959 143.952C114.586 144.069 114.154 144.128 113.663 144.128ZM119.036 144.128C118.449 144.128 117.948 143.957 117.532 143.616C117.116 143.264 116.908 142.731 116.908 142.016C116.908 141.408 117.068 140.939 117.388 140.608C117.708 140.277 118.145 140.048 118.7 139.92C119.265 139.792 119.916 139.728 120.652 139.728H121.356V139.44C121.356 139.163 121.302 138.896 121.196 138.64C121.1 138.373 120.934 138.155 120.7 137.984C120.476 137.803 120.166 137.712 119.772 137.712C119.377 137.712 119.073 137.749 118.86 137.824C118.646 137.899 118.476 137.979 118.348 138.064C118.22 138.149 118.102 138.192 117.996 138.192C117.804 138.192 117.654 138.101 117.548 137.92C117.441 137.728 117.388 137.536 117.388 137.344C117.388 137.152 117.51 136.981 117.756 136.832C118.012 136.672 118.326 136.549 118.7 136.464C119.073 136.368 119.441 136.32 119.804 136.32C120.593 136.32 121.222 136.469 121.692 136.768C122.161 137.056 122.502 137.435 122.716 137.904C122.929 138.373 123.036 138.88 123.036 139.424V143.44C123.036 143.589 122.956 143.723 122.796 143.84C122.646 143.947 122.454 144 122.22 144C122.006 144 121.825 143.947 121.676 143.84C121.526 143.723 121.452 143.589 121.452 143.44V142.88C121.174 143.2 120.838 143.488 120.444 143.744C120.049 144 119.58 144.128 119.036 144.128ZM119.644 142.848C119.91 142.848 120.172 142.768 120.428 142.608C120.694 142.448 120.913 142.245 121.084 142C121.265 141.755 121.356 141.504 121.356 141.248V140.656H120.956C120.55 140.656 120.166 140.683 119.804 140.736C119.441 140.779 119.148 140.885 118.924 141.056C118.71 141.216 118.604 141.467 118.604 141.808C118.604 142.171 118.7 142.437 118.892 142.608C119.094 142.768 119.345 142.848 119.644 142.848ZM125.564 144C125.318 144 125.116 143.941 124.956 143.824C124.806 143.707 124.732 143.579 124.732 143.44V136.96C124.732 136.8 124.806 136.672 124.956 136.576C125.116 136.469 125.318 136.416 125.564 136.416C125.766 136.416 125.942 136.469 126.092 136.576C126.241 136.672 126.316 136.8 126.316 136.96V137.536C126.476 137.227 126.737 136.949 127.1 136.704C127.473 136.448 127.926 136.32 128.46 136.32C128.961 136.32 129.42 136.464 129.836 136.752C130.262 137.029 130.604 137.408 130.86 137.888C131.116 138.357 131.244 138.885 131.244 139.472V143.44C131.244 143.621 131.153 143.76 130.972 143.856C130.801 143.952 130.609 144 130.396 144C130.204 144 130.017 143.952 129.836 143.856C129.654 143.76 129.564 143.621 129.564 143.44V139.472C129.564 139.195 129.489 138.928 129.34 138.672C129.201 138.416 129.009 138.208 128.764 138.048C128.518 137.888 128.246 137.808 127.948 137.808C127.692 137.808 127.446 137.877 127.212 138.016C126.977 138.144 126.785 138.331 126.636 138.576C126.486 138.821 126.412 139.12 126.412 139.472V143.44C126.412 143.579 126.326 143.707 126.156 143.824C125.996 143.941 125.798 144 125.564 144ZM139.93 144.128C139.429 144.128 138.976 144.005 138.57 143.76C138.176 143.504 137.893 143.211 137.722 142.88V143.44C137.722 143.579 137.648 143.707 137.498 143.824C137.349 143.941 137.168 144 136.954 144C136.72 144 136.522 143.941 136.362 143.824C136.213 143.707 136.138 143.579 136.138 143.44V132.448C136.138 132.288 136.213 132.16 136.362 132.064C136.522 131.957 136.72 131.904 136.954 131.904C137.2 131.904 137.402 131.957 137.562 132.064C137.733 132.16 137.818 132.288 137.818 132.448V137.536C137.989 137.227 138.25 136.949 138.602 136.704C138.954 136.448 139.381 136.32 139.882 136.32C140.405 136.32 140.88 136.464 141.306 136.752C141.744 137.029 142.09 137.408 142.346 137.888C142.613 138.357 142.746 138.885 142.746 139.472V140.944C142.746 141.499 142.613 142.021 142.346 142.512C142.09 142.992 141.749 143.381 141.322 143.68C140.896 143.979 140.432 144.128 139.93 144.128ZM139.45 142.64C139.738 142.64 140.005 142.56 140.25 142.4C140.496 142.24 140.693 142.027 140.842 141.76C140.992 141.493 141.066 141.221 141.066 140.944V139.472C141.066 139.195 140.992 138.928 140.842 138.672C140.693 138.416 140.496 138.208 140.25 138.048C140.005 137.888 139.733 137.808 139.434 137.808C139.168 137.808 138.912 137.877 138.666 138.016C138.421 138.144 138.218 138.331 138.058 138.576C137.898 138.821 137.818 139.12 137.818 139.472V141.312C137.818 141.44 137.888 141.611 138.026 141.824C138.176 142.027 138.373 142.213 138.618 142.384C138.864 142.555 139.141 142.64 139.45 142.64ZM147.64 144.128C146.915 144.128 146.275 143.995 145.72 143.728C145.165 143.461 144.728 143.093 144.408 142.624C144.088 142.144 143.928 141.584 143.928 140.944V139.424C143.928 138.859 144.077 138.341 144.376 137.872C144.685 137.403 145.091 137.029 145.592 136.752C146.093 136.464 146.648 136.32 147.256 136.32C147.832 136.32 148.36 136.448 148.84 136.704C149.32 136.949 149.704 137.296 149.992 137.744C150.291 138.192 150.44 138.704 150.44 139.28C150.44 139.728 150.371 140.048 150.232 140.24C150.093 140.432 149.912 140.549 149.688 140.592C149.464 140.635 149.229 140.656 148.984 140.656H145.608V141.024C145.608 141.557 145.8 141.984 146.184 142.304C146.579 142.613 147.08 142.768 147.688 142.768C148.061 142.768 148.365 142.715 148.6 142.608C148.835 142.501 149.032 142.4 149.192 142.304C149.352 142.208 149.501 142.16 149.64 142.16C149.779 142.16 149.896 142.203 149.992 142.288C150.088 142.373 150.163 142.475 150.216 142.592C150.269 142.709 150.296 142.816 150.296 142.912C150.296 143.072 150.184 143.248 149.96 143.44C149.747 143.632 149.443 143.797 149.048 143.936C148.653 144.064 148.184 144.128 147.64 144.128ZM145.608 139.616H148.264C148.499 139.616 148.653 139.584 148.728 139.52C148.813 139.456 148.856 139.328 148.856 139.136C148.856 138.859 148.787 138.603 148.648 138.368C148.509 138.123 148.317 137.936 148.072 137.808C147.827 137.669 147.549 137.6 147.24 137.6C146.941 137.6 146.669 137.664 146.424 137.792C146.179 137.92 145.981 138.096 145.832 138.32C145.683 138.544 145.608 138.805 145.608 139.104V139.616ZM155.829 144C155.594 144 155.397 143.941 155.237 143.824C155.087 143.707 155.013 143.579 155.013 143.44V136.96C155.013 136.8 155.087 136.672 155.237 136.576C155.397 136.469 155.594 136.416 155.829 136.416C156.042 136.416 156.223 136.469 156.373 136.576C156.522 136.672 156.597 136.8 156.597 136.96V137.664C156.714 137.44 156.869 137.227 157.061 137.024C157.263 136.821 157.498 136.656 157.765 136.528C158.031 136.389 158.319 136.32 158.629 136.32H159.141C159.311 136.32 159.461 136.395 159.589 136.544C159.717 136.683 159.781 136.853 159.781 137.056C159.781 137.259 159.717 137.435 159.589 137.584C159.461 137.733 159.311 137.808 159.141 137.808H158.629C158.309 137.808 157.999 137.904 157.701 138.096C157.402 138.288 157.157 138.56 156.965 138.912C156.783 139.253 156.693 139.669 156.693 140.16V143.44C156.693 143.579 156.607 143.707 156.437 143.824C156.277 143.941 156.074 144 155.829 144ZM163.921 144.128C163.196 144.128 162.556 143.995 162.001 143.728C161.447 143.461 161.009 143.093 160.689 142.624C160.369 142.144 160.209 141.584 160.209 140.944V139.424C160.209 138.859 160.359 138.341 160.657 137.872C160.967 137.403 161.372 137.029 161.873 136.752C162.375 136.464 162.929 136.32 163.537 136.32C164.113 136.32 164.641 136.448 165.121 136.704C165.601 136.949 165.985 137.296 166.273 137.744C166.572 138.192 166.721 138.704 166.721 139.28C166.721 139.728 166.652 140.048 166.513 140.24C166.375 140.432 166.193 140.549 165.969 140.592C165.745 140.635 165.511 140.656 165.265 140.656H161.889V141.024C161.889 141.557 162.081 141.984 162.465 142.304C162.86 142.613 163.361 142.768 163.969 142.768C164.343 142.768 164.647 142.715 164.881 142.608C165.116 142.501 165.313 142.4 165.473 142.304C165.633 142.208 165.783 142.16 165.921 142.16C166.06 142.16 166.177 142.203 166.273 142.288C166.369 142.373 166.444 142.475 166.497 142.592C166.551 142.709 166.577 142.816 166.577 142.912C166.577 143.072 166.465 143.248 166.241 143.44C166.028 143.632 165.724 143.797 165.329 143.936C164.935 144.064 164.465 144.128 163.921 144.128ZM161.889 139.616H164.545C164.78 139.616 164.935 139.584 165.009 139.52C165.095 139.456 165.137 139.328 165.137 139.136C165.137 138.859 165.068 138.603 164.929 138.368C164.791 138.123 164.599 137.936 164.353 137.808C164.108 137.669 163.831 137.6 163.521 137.6C163.223 137.6 162.951 137.664 162.705 137.792C162.46 137.92 162.263 138.096 162.113 138.32C161.964 138.544 161.889 138.805 161.889 139.104V139.616ZM171.323 144.128C170.726 144.128 170.171 143.984 169.659 143.696C169.158 143.397 168.758 143.008 168.459 142.528C168.16 142.037 168.011 141.52 168.011 140.976V136.976C168.011 136.837 168.091 136.709 168.251 136.592C168.422 136.475 168.624 136.416 168.859 136.416C169.083 136.416 169.275 136.475 169.435 136.592C169.606 136.709 169.691 136.837 169.691 136.976V140.976C169.691 141.253 169.76 141.52 169.899 141.776C170.048 142.032 170.246 142.24 170.491 142.4C170.747 142.56 171.024 142.64 171.323 142.64C171.622 142.64 171.894 142.56 172.139 142.4C172.384 142.24 172.576 142.032 172.715 141.776C172.864 141.52 172.939 141.253 172.939 140.976V136.96C172.939 136.811 173.024 136.683 173.195 136.576C173.376 136.469 173.574 136.416 173.787 136.416C174.032 136.416 174.23 136.469 174.379 136.576C174.539 136.683 174.619 136.811 174.619 136.96V140.976C174.619 141.541 174.47 142.064 174.171 142.544C173.872 143.024 173.472 143.408 172.971 143.696C172.47 143.984 171.92 144.128 171.323 144.128ZM178.614 144.128C178.091 144.128 177.622 144.064 177.206 143.936C176.79 143.808 176.459 143.648 176.214 143.456C175.979 143.253 175.862 143.051 175.862 142.848C175.862 142.752 175.883 142.645 175.926 142.528C175.979 142.411 176.049 142.309 176.134 142.224C176.23 142.139 176.331 142.096 176.438 142.096C176.577 142.096 176.721 142.16 176.87 142.288C177.03 142.405 177.238 142.528 177.494 142.656C177.75 142.773 178.107 142.832 178.566 142.832C179.099 142.832 179.457 142.741 179.638 142.56C179.83 142.379 179.926 142.181 179.926 141.968C179.926 141.691 179.83 141.477 179.638 141.328C179.457 141.168 179.217 141.04 178.918 140.944C178.63 140.848 178.321 140.757 177.99 140.672C177.659 140.576 177.345 140.453 177.046 140.304C176.758 140.155 176.518 139.947 176.326 139.68C176.145 139.413 176.054 139.061 176.054 138.624C176.054 138.261 176.145 137.904 176.326 137.552C176.507 137.189 176.795 136.896 177.19 136.672C177.595 136.437 178.134 136.32 178.806 136.32C179.211 136.32 179.595 136.363 179.958 136.448C180.321 136.533 180.619 136.651 180.854 136.8C181.089 136.939 181.206 137.093 181.206 137.264C181.206 137.339 181.179 137.445 181.126 137.584C181.073 137.712 180.998 137.829 180.902 137.936C180.817 138.032 180.705 138.08 180.566 138.08C180.459 138.08 180.326 138.043 180.166 137.968C180.006 137.883 179.819 137.803 179.606 137.728C179.393 137.653 179.131 137.616 178.822 137.616C178.513 137.616 178.262 137.669 178.07 137.776C177.889 137.872 177.755 137.989 177.67 138.128C177.585 138.267 177.542 138.405 177.542 138.544C177.542 138.779 177.633 138.96 177.814 139.088C177.995 139.216 178.235 139.323 178.534 139.408C178.833 139.493 179.147 139.584 179.478 139.68C179.809 139.765 180.118 139.893 180.406 140.064C180.705 140.235 180.945 140.464 181.126 140.752C181.318 141.04 181.414 141.424 181.414 141.904C181.414 142.576 181.169 143.115 180.678 143.52C180.198 143.925 179.51 144.128 178.614 144.128ZM186.218 144.128C185.493 144.128 184.853 143.995 184.298 143.728C183.743 143.461 183.306 143.093 182.986 142.624C182.666 142.144 182.506 141.584 182.506 140.944V139.424C182.506 138.859 182.655 138.341 182.954 137.872C183.263 137.403 183.669 137.029 184.17 136.752C184.671 136.464 185.226 136.32 185.834 136.32C186.41 136.32 186.938 136.448 187.418 136.704C187.898 136.949 188.282 137.296 188.57 137.744C188.869 138.192 189.018 138.704 189.018 139.28C189.018 139.728 188.949 140.048 188.81 140.24C188.671 140.432 188.49 140.549 188.266 140.592C188.042 140.635 187.807 140.656 187.562 140.656H184.186V141.024C184.186 141.557 184.378 141.984 184.762 142.304C185.157 142.613 185.658 142.768 186.266 142.768C186.639 142.768 186.943 142.715 187.178 142.608C187.413 142.501 187.61 142.4 187.77 142.304C187.93 142.208 188.079 142.16 188.218 142.16C188.357 142.16 188.474 142.203 188.57 142.288C188.666 142.373 188.741 142.475 188.794 142.592C188.847 142.709 188.874 142.816 188.874 142.912C188.874 143.072 188.762 143.248 188.538 143.44C188.325 143.632 188.021 143.797 187.626 143.936C187.231 144.064 186.762 144.128 186.218 144.128ZM184.186 139.616H186.842C187.077 139.616 187.231 139.584 187.306 139.52C187.391 139.456 187.434 139.328 187.434 139.136C187.434 138.859 187.365 138.603 187.226 138.368C187.087 138.123 186.895 137.936 186.65 137.808C186.405 137.669 186.127 137.6 185.818 137.6C185.519 137.6 185.247 137.664 185.002 137.792C184.757 137.92 184.559 138.096 184.41 138.32C184.261 138.544 184.186 138.805 184.186 139.104V139.616ZM192.916 144.128C192.414 144.128 191.95 143.979 191.524 143.68C191.097 143.381 190.75 142.992 190.484 142.512C190.228 142.021 190.1 141.499 190.1 140.944V139.472C190.1 138.885 190.228 138.357 190.484 137.888C190.75 137.408 191.097 137.029 191.524 136.752C191.95 136.464 192.425 136.32 192.948 136.32C193.46 136.32 193.892 136.448 194.244 136.704C194.596 136.949 194.857 137.227 195.028 137.536V132.448C195.028 132.288 195.113 132.16 195.284 132.064C195.454 131.957 195.657 131.904 195.892 131.904C196.126 131.904 196.318 131.957 196.468 132.064C196.628 132.16 196.708 132.288 196.708 132.448V143.44C196.708 143.579 196.628 143.707 196.468 143.824C196.318 143.941 196.126 144 195.892 144C195.689 144 195.508 143.941 195.348 143.824C195.198 143.707 195.124 143.579 195.124 143.44V142.88C194.964 143.211 194.681 143.504 194.276 143.76C193.87 144.005 193.417 144.128 192.916 144.128ZM193.396 142.64C193.705 142.64 193.982 142.555 194.228 142.384C194.473 142.213 194.665 142.027 194.804 141.824C194.953 141.611 195.028 141.44 195.028 141.312V139.472C195.028 139.12 194.948 138.821 194.788 138.576C194.628 138.331 194.425 138.144 194.18 138.016C193.934 137.877 193.678 137.808 193.412 137.808C193.113 137.808 192.836 137.888 192.58 138.048C192.334 138.208 192.137 138.416 191.988 138.672C191.849 138.928 191.78 139.195 191.78 139.472V140.944C191.78 141.221 191.849 141.493 191.988 141.76C192.137 142.027 192.334 142.24 192.58 142.4C192.825 142.56 193.097 142.64 193.396 142.64ZM199.314 140.992C199.143 140.992 198.988 140.949 198.85 140.864C198.722 140.779 198.658 140.651 198.658 140.48C198.658 139.701 198.642 138.88 198.61 138.016C198.578 137.152 198.546 136.288 198.514 135.424C198.482 134.549 198.466 133.728 198.466 132.96C198.466 132.715 198.546 132.528 198.706 132.4C198.866 132.261 199.068 132.192 199.314 132.192C199.548 132.192 199.746 132.261 199.906 132.4C200.076 132.528 200.162 132.715 200.162 132.96C200.162 133.728 200.146 134.549 200.114 135.424C200.082 136.288 200.05 137.152 200.018 138.016C199.986 138.88 199.97 139.701 199.97 140.48C199.97 140.651 199.895 140.779 199.746 140.864C199.596 140.949 199.452 140.992 199.314 140.992ZM199.33 144.096C199.052 144.096 198.823 144 198.642 143.808C198.46 143.616 198.37 143.392 198.37 143.136C198.37 142.869 198.46 142.645 198.642 142.464C198.823 142.272 199.052 142.176 199.33 142.176C199.586 142.176 199.804 142.272 199.986 142.464C200.178 142.645 200.274 142.869 200.274 143.136C200.274 143.392 200.178 143.616 199.986 143.808C199.804 144 199.586 144.096 199.33 144.096Z\" fill=\"#FF0082\"/> <g class=\"answer\" filter=\"url(#filter1_d_1192_52236)\"> <path d=\"M99 159H162C167.523 159 172 163.477 172 169V188H109C103.477 188 99 183.523 99 178V159Z\" fill=\"white\"/> <path d=\"M99.5 159.5H162C167.247 159.5 171.5 163.753 171.5 169V187.5H109C103.753 187.5 99.5 183.247 99.5 178V159.5Z\" stroke=\"#F7CFE5\"/> <path d=\"M121.219 179C120.995 179 120.785 178.953 120.589 178.86C120.402 178.757 120.309 178.608 120.309 178.412V169.34C120.309 169.144 120.402 168.999 120.589 168.906C120.785 168.813 120.995 168.766 121.219 168.766C121.443 168.766 121.625 168.789 121.765 168.836C121.914 168.883 122.049 168.976 122.171 169.116C122.301 169.247 122.437 169.452 122.577 169.732L125.279 174.954V169.34C125.279 169.135 125.372 168.99 125.559 168.906C125.755 168.813 125.965 168.766 126.189 168.766C126.422 168.766 126.632 168.813 126.819 168.906C127.005 168.99 127.099 169.135 127.099 169.34V178.412C127.099 178.608 127.005 178.757 126.819 178.86C126.632 178.953 126.422 179 126.189 179C125.974 179 125.773 178.958 125.587 178.874C125.409 178.79 125.265 178.641 125.153 178.426L122.129 172.798V178.412C122.129 178.608 122.035 178.757 121.849 178.86C121.662 178.953 121.452 179 121.219 179ZM129.597 179C129.401 179 129.219 178.953 129.051 178.86C128.883 178.757 128.799 178.608 128.799 178.412V169.354C128.799 169.158 128.883 169.013 129.051 168.92C129.219 168.817 129.401 168.766 129.597 168.766H134.581C134.786 168.766 134.931 168.85 135.015 169.018C135.108 169.186 135.155 169.363 135.155 169.55C135.155 169.774 135.104 169.965 135.001 170.124C134.908 170.283 134.768 170.362 134.581 170.362H130.619V173.162H132.747C132.934 173.162 133.074 173.237 133.167 173.386C133.27 173.526 133.321 173.694 133.321 173.89C133.321 174.049 133.274 174.207 133.181 174.366C133.097 174.515 132.952 174.59 132.747 174.59H130.619V177.404H134.581C134.768 177.404 134.908 177.483 135.001 177.642C135.104 177.801 135.155 177.992 135.155 178.216C135.155 178.403 135.108 178.58 135.015 178.748C134.931 178.916 134.786 179 134.581 179H129.597ZM136.755 179.07C136.587 179.07 136.409 179.028 136.223 178.944C136.036 178.86 135.877 178.753 135.747 178.622C135.616 178.482 135.551 178.328 135.551 178.16C135.551 178.057 135.588 177.945 135.663 177.824L138.085 173.876L135.747 169.942C135.663 169.811 135.621 169.681 135.621 169.55C135.621 169.391 135.681 169.247 135.803 169.116C135.924 168.985 136.073 168.883 136.251 168.808C136.437 168.733 136.615 168.696 136.783 168.696C136.932 168.696 137.053 168.733 137.147 168.808C137.249 168.873 137.329 168.967 137.385 169.088L139.289 172.518L141.207 169.088C141.272 168.967 141.351 168.873 141.445 168.808C141.547 168.733 141.669 168.696 141.809 168.696C141.986 168.696 142.163 168.733 142.341 168.808C142.518 168.883 142.667 168.985 142.789 169.116C142.91 169.247 142.971 169.391 142.971 169.55C142.971 169.681 142.929 169.811 142.845 169.942L140.507 173.876L142.929 177.824C143.003 177.945 143.041 178.057 143.041 178.16C143.041 178.328 142.975 178.482 142.845 178.622C142.714 178.753 142.555 178.86 142.369 178.944C142.191 179.028 142.014 179.07 141.837 179.07C141.734 179.07 141.636 179.042 141.543 178.986C141.459 178.93 141.393 178.86 141.347 178.776L139.289 175.178L137.245 178.776C137.198 178.86 137.128 178.93 137.035 178.986C136.951 179.042 136.857 179.07 136.755 179.07ZM146.871 179C146.638 179 146.428 178.953 146.241 178.86C146.054 178.757 145.961 178.608 145.961 178.412V170.404H143.903C143.726 170.404 143.586 170.32 143.483 170.152C143.38 169.984 143.329 169.793 143.329 169.578C143.329 169.382 143.376 169.2 143.469 169.032C143.562 168.855 143.707 168.766 143.903 168.766H149.825C150.03 168.766 150.175 168.855 150.259 169.032C150.352 169.2 150.399 169.382 150.399 169.578C150.399 169.793 150.348 169.984 150.245 170.152C150.152 170.32 150.012 170.404 149.825 170.404H147.781V178.412C147.781 178.608 147.683 178.757 147.487 178.86C147.3 178.953 147.095 179 146.871 179Z\" fill=\"#FF0082\"/> </g> </g> <defs> <filter id=\"filter0_d_1192_52236\" x=\"0\" y=\"0\" width=\"275\" height=\"222\" filterUnits=\"userSpaceOnUse\" color-interpolation-filters=\"sRGB\"> <feFlood flood-opacity=\"0\" result=\"BackgroundImageFix\"/> <feColorMatrix in=\"SourceAlpha\" type=\"matrix\" values=\"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0\" result=\"hardAlpha\"/> <feOffset dx=\"5\" dy=\"5\"/> <feComposite in2=\"hardAlpha\" operator=\"out\"/> <feColorMatrix type=\"matrix\" values=\"0 0 0 0 0.956863 0 0 0 0 0.490196 0 0 0 0 0.380392 0 0 0 1 0\"/> <feBlend mode=\"normal\" in2=\"BackgroundImageFix\" result=\"effect1_dropShadow_1192_52236\"/> <feBlend mode=\"normal\" in=\"SourceGraphic\" in2=\"effect1_dropShadow_1192_52236\" result=\"shape\"/> </filter> <filter id=\"filter1_d_1192_52236\" x=\"99\" y=\"159\" width=\"75\" height=\"31\" filterUnits=\"userSpaceOnUse\" color-interpolation-filters=\"sRGB\"> <feFlood flood-opacity=\"0\" result=\"BackgroundImageFix\"/> <feColorMatrix in=\"SourceAlpha\" type=\"matrix\" values=\"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0\" result=\"hardAlpha\"/> <feOffset dx=\"2\" dy=\"2\"/> <feComposite in2=\"hardAlpha\" operator=\"out\"/> <feColorMatrix type=\"matrix\" values=\"0 0 0 0 1 0 0 0 0 0 0 0 0 0 0.509804 0 0 0 1 0\"/> <feBlend mode=\"normal\" in2=\"BackgroundImageFix\" result=\"effect1_dropShadow_1192_52236\"/> <feBlend mode=\"normal\" in=\"SourceGraphic\" in2=\"effect1_dropShadow_1192_52236\" result=\"shape\"/> </filter> </defs> </svg>") // EJsS HtmlView.HtmlView Page: setting property 'Html' for element 'toys_wrong'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"glassjar_right", _view.gameScreen) // EJsS HtmlView.HtmlView Page: declaration of element 'glassjar_right'
      .setProperty("Html","<svg width=\"275\" height=\"222\" viewBox=\"0 0 275 222\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"> <g filter=\"url(#filter0_d_1192_51387)\"> <rect width=\"270\" height=\"217\" rx=\"50\" fill=\"#F9E6E0\"/> <rect x=\"0.5\" y=\"0.5\" width=\"269\" height=\"216\" rx=\"49.5\" stroke=\"#FFD208\"/> <path d=\"M90.113 45C89.7797 45 89.4797 44.9333 89.213 44.8C88.9464 44.6533 88.813 44.44 88.813 44.16V32.72H85.873C85.6197 32.72 85.4197 32.6 85.273 32.36C85.1264 32.12 85.053 31.8467 85.053 31.54C85.053 31.26 85.1197 31 85.253 30.76C85.3864 30.5067 85.593 30.38 85.873 30.38H94.333C94.6264 30.38 94.833 30.5067 94.953 30.76C95.0864 31 95.153 31.26 95.153 31.54C95.153 31.8467 95.0797 32.12 94.933 32.36C94.7997 32.6 94.5997 32.72 94.333 32.72H91.413V44.16C91.413 44.44 91.273 44.6533 90.993 44.8C90.7264 44.9333 90.433 45 90.113 45ZM97.6418 45C97.2685 45 96.9618 44.9133 96.7218 44.74C96.4818 44.5667 96.3618 44.3733 96.3618 44.16V30.76C96.3618 30.52 96.4818 30.3267 96.7218 30.18C96.9618 30.0333 97.2685 29.96 97.6418 29.96C98.0018 29.96 98.3085 30.0333 98.5618 30.18C98.8151 30.3267 98.9418 30.52 98.9418 30.76V36.9C99.1418 36.5133 99.4551 36.1667 99.8818 35.86C100.308 35.54 100.835 35.38 101.462 35.38C102.088 35.38 102.662 35.5667 103.182 35.94C103.702 36.3 104.115 36.7867 104.422 37.4C104.742 38.0133 104.902 38.6933 104.902 39.44V44.16C104.902 44.44 104.768 44.6533 104.502 44.8C104.235 44.9333 103.935 45 103.602 45C103.308 45 103.022 44.9333 102.742 44.8C102.462 44.6533 102.322 44.44 102.322 44.16V39.44C102.322 39.1333 102.242 38.8467 102.082 38.58C101.922 38.3133 101.708 38.0933 101.442 37.92C101.188 37.7333 100.902 37.64 100.582 37.64C100.315 37.64 100.055 37.7133 99.8018 37.86C99.5485 38.0067 99.3418 38.2133 99.1818 38.48C99.0218 38.7467 98.9418 39.0667 98.9418 39.44V44.16C98.9418 44.3733 98.8151 44.5667 98.5618 44.74C98.3085 44.9133 98.0018 45 97.6418 45ZM108.87 45.18C108.163 45.18 107.55 44.9667 107.03 44.54C106.523 44.1 106.27 43.4267 106.27 42.52C106.27 41.76 106.463 41.1667 106.85 40.74C107.25 40.3133 107.797 40.0133 108.49 39.84C109.197 39.6667 110.01 39.58 110.93 39.58H111.75V39.32C111.75 39.0267 111.69 38.74 111.57 38.46C111.463 38.18 111.283 37.9467 111.03 37.76C110.79 37.5733 110.443 37.48 109.99 37.48C109.483 37.48 109.09 37.5333 108.81 37.64C108.543 37.7333 108.337 37.8333 108.19 37.94C108.043 38.0467 107.883 38.1 107.71 38.1C107.43 38.1 107.21 37.96 107.05 37.68C106.903 37.4 106.83 37.1133 106.83 36.82C106.83 36.54 106.997 36.2933 107.33 36.08C107.677 35.8533 108.097 35.68 108.59 35.56C109.083 35.44 109.563 35.38 110.03 35.38C111.07 35.38 111.903 35.5667 112.53 35.94C113.157 36.3133 113.61 36.7933 113.89 37.38C114.183 37.9667 114.33 38.6 114.33 39.28V44.16C114.33 44.4 114.21 44.6 113.97 44.76C113.73 44.92 113.43 45 113.07 45C112.737 45 112.457 44.92 112.23 44.76C112.017 44.6 111.91 44.4 111.91 44.16V43.6C111.55 44.0133 111.123 44.38 110.63 44.7C110.15 45.02 109.563 45.18 108.87 45.18ZM109.91 43.26C110.19 43.26 110.47 43.1667 110.75 42.98C111.03 42.7933 111.263 42.5533 111.45 42.26C111.65 41.9667 111.75 41.66 111.75 41.34V40.92H111.45C111.01 40.92 110.59 40.9467 110.19 41C109.79 41.0533 109.463 41.1733 109.21 41.36C108.97 41.5333 108.85 41.8067 108.85 42.18C108.85 42.5533 108.95 42.8267 109.15 43C109.363 43.1733 109.617 43.26 109.91 43.26ZM119.904 45C118.704 45 117.784 44.74 117.144 44.22C116.517 43.7 116.204 42.8733 116.204 41.74V32.06C116.204 31.82 116.344 31.6267 116.624 31.48C116.904 31.3333 117.191 31.26 117.484 31.26C117.804 31.26 118.097 31.3333 118.364 31.48C118.644 31.6267 118.784 31.82 118.784 32.06V35.5H121.144C121.357 35.5 121.517 35.6 121.624 35.8C121.744 35.9867 121.804 36.2 121.804 36.44C121.804 36.68 121.744 36.9 121.624 37.1C121.517 37.2867 121.357 37.38 121.144 37.38H118.784V41.74C118.784 42.14 118.864 42.42 119.024 42.58C119.197 42.74 119.491 42.82 119.904 42.82H120.684C121.057 42.82 121.331 42.9333 121.504 43.16C121.691 43.3867 121.784 43.6333 121.784 43.9C121.784 44.18 121.691 44.4333 121.504 44.66C121.331 44.8867 121.057 45 120.684 45H119.904ZM123.719 34.78C123.532 34.78 123.339 34.7267 123.139 34.62C122.952 34.5 122.859 34.3267 122.859 34.1C122.859 34.0067 122.886 33.9133 122.939 33.82L123.399 32.76C123.172 32.64 122.992 32.4733 122.859 32.26C122.726 32.0467 122.659 31.8067 122.659 31.54C122.659 31.1667 122.786 30.8467 123.039 30.58C123.306 30.3133 123.626 30.18 123.999 30.18C124.372 30.18 124.692 30.3133 124.959 30.58C125.226 30.8467 125.359 31.16 125.359 31.52C125.359 31.5867 125.346 31.6733 125.319 31.78C125.292 31.8867 125.239 32.04 125.159 32.24C125.092 32.4267 124.986 32.7 124.839 33.06C124.692 33.42 124.492 33.8867 124.239 34.46C124.199 34.5667 124.126 34.6467 124.019 34.7C123.912 34.7533 123.812 34.78 123.719 34.78ZM129.774 45.18C129.107 45.18 128.494 45.1 127.934 44.94C127.387 44.7667 126.954 44.5467 126.634 44.28C126.327 44.0133 126.174 43.74 126.174 43.46C126.174 43.3133 126.207 43.1533 126.274 42.98C126.354 42.8067 126.454 42.6533 126.574 42.52C126.707 42.3867 126.86 42.32 127.034 42.32C127.22 42.32 127.414 42.4 127.614 42.56C127.827 42.7067 128.087 42.8533 128.394 43C128.714 43.1467 129.154 43.22 129.714 43.22C130.314 43.22 130.707 43.1267 130.894 42.94C131.094 42.7533 131.194 42.56 131.194 42.36C131.194 42.0667 131.074 41.84 130.834 41.68C130.607 41.52 130.314 41.3933 129.954 41.3C129.594 41.1933 129.207 41.08 128.794 40.96C128.394 40.84 128.014 40.6867 127.654 40.5C127.294 40.3 127 40.0333 126.774 39.7C126.547 39.3533 126.434 38.9067 126.434 38.36C126.434 37.88 126.547 37.4133 126.774 36.96C127 36.5067 127.374 36.1333 127.894 35.84C128.414 35.5333 129.12 35.38 130.014 35.38C130.56 35.38 131.074 35.44 131.554 35.56C132.047 35.6667 132.447 35.82 132.754 36.02C133.06 36.22 133.214 36.44 133.214 36.68C133.214 36.8 133.174 36.96 133.094 37.16C133.014 37.3467 132.9 37.52 132.754 37.68C132.62 37.84 132.454 37.92 132.254 37.92C132.107 37.92 131.927 37.8733 131.714 37.78C131.514 37.6733 131.28 37.5733 131.014 37.48C130.747 37.3867 130.427 37.34 130.054 37.34C129.72 37.34 129.454 37.3867 129.254 37.48C129.054 37.5733 128.907 37.6867 128.814 37.82C128.72 37.9533 128.674 38.0933 128.674 38.24C128.674 38.48 128.787 38.6667 129.014 38.8C129.24 38.9333 129.534 39.0467 129.894 39.14C130.267 39.2333 130.654 39.34 131.054 39.46C131.467 39.5667 131.854 39.7267 132.214 39.94C132.587 40.1533 132.887 40.4467 133.114 40.82C133.34 41.18 133.454 41.6533 133.454 42.24C133.454 43.1333 133.134 43.8467 132.494 44.38C131.867 44.9133 130.96 45.18 129.774 45.18ZM147.238 45.1C147.064 45.1 146.891 45.0467 146.718 44.94C146.558 44.8333 146.431 44.68 146.338 44.48L143.498 38.96H141.818V44.16C141.818 44.44 141.684 44.6533 141.418 44.8C141.151 44.9333 140.851 45 140.518 45C140.198 45 139.898 44.9333 139.618 44.8C139.351 44.6533 139.218 44.44 139.218 44.16V31.2C139.218 30.9733 139.291 30.78 139.438 30.62C139.598 30.46 139.804 30.38 140.058 30.38H144.018C144.898 30.38 145.691 30.5067 146.398 30.76C147.118 31.0133 147.691 31.4467 148.118 32.06C148.544 32.66 148.758 33.4933 148.758 34.56C148.758 35.3333 148.644 35.9933 148.418 36.54C148.191 37.0733 147.878 37.5067 147.478 37.84C147.091 38.16 146.644 38.4 146.138 38.56L148.778 43.42C148.804 43.4733 148.824 43.5333 148.838 43.6C148.851 43.6533 148.858 43.7 148.858 43.74C148.858 43.9533 148.778 44.1667 148.618 44.38C148.458 44.5933 148.251 44.7667 147.998 44.9C147.758 45.0333 147.504 45.1 147.238 45.1ZM141.818 36.92H144.018C144.671 36.92 145.191 36.76 145.578 36.44C145.964 36.12 146.158 35.5733 146.158 34.8C146.158 34 145.964 33.4467 145.578 33.14C145.191 32.82 144.671 32.66 144.018 32.66H141.818V36.92ZM151.665 33.38C151.278 33.38 150.945 33.2533 150.665 33C150.385 32.7333 150.245 32.44 150.245 32.12C150.245 31.7733 150.385 31.48 150.665 31.24C150.945 30.9867 151.278 30.86 151.665 30.86C152.065 30.86 152.398 30.9867 152.665 31.24C152.931 31.48 153.065 31.7733 153.065 32.12C153.065 32.44 152.931 32.7333 152.665 33C152.398 33.2533 152.065 33.38 151.665 33.38ZM151.665 45C151.291 45 150.985 44.9133 150.745 44.74C150.505 44.5667 150.385 44.3733 150.385 44.16V36.3C150.385 36.06 150.505 35.8667 150.745 35.72C150.985 35.5733 151.291 35.5 151.665 35.5C152.025 35.5 152.331 35.5733 152.585 35.72C152.838 35.8667 152.965 36.06 152.965 36.3V44.16C152.965 44.3733 152.838 44.5667 152.585 44.74C152.331 44.9133 152.025 45 151.665 45ZM158.676 49.42C157.889 49.42 157.156 49.3067 156.476 49.08C155.809 48.8667 155.269 48.5467 154.856 48.12C154.456 47.6933 154.256 47.1867 154.256 46.6C154.256 46.0933 154.396 45.66 154.676 45.3C154.956 44.9533 155.302 44.68 155.716 44.48C155.462 44.36 155.256 44.2 155.096 44C154.949 43.7867 154.876 43.52 154.876 43.2C154.876 42.8267 154.969 42.5267 155.156 42.3C155.356 42.06 155.602 41.84 155.896 41.64C155.496 41.3333 155.182 40.9667 154.956 40.54C154.742 40.1 154.636 39.62 154.636 39.1V38.68C154.636 38.0267 154.796 37.4533 155.116 36.96C155.449 36.4667 155.909 36.08 156.496 35.8C157.096 35.52 157.782 35.38 158.556 35.38C158.996 35.38 159.409 35.4333 159.796 35.54C160.182 35.6333 160.529 35.7733 160.836 35.96C161.062 35.4267 161.276 35.0667 161.476 34.88C161.676 34.6933 161.869 34.6 162.056 34.6C162.376 34.6 162.622 34.6933 162.796 34.88C162.982 35.0667 163.076 35.24 163.076 35.4C163.076 35.52 163.042 35.6267 162.976 35.72C162.922 35.8133 162.849 35.8933 162.756 35.96C162.622 36.04 162.469 36.14 162.296 36.26C162.122 36.3667 161.962 36.52 161.816 36.72C162.056 36.9867 162.229 37.2867 162.336 37.62C162.456 37.94 162.516 38.2933 162.516 38.68V39.1C162.516 39.74 162.349 40.3133 162.016 40.82C161.682 41.3133 161.216 41.7067 160.616 42C160.016 42.2933 159.329 42.44 158.556 42.44C158.076 42.44 157.642 42.38 157.256 42.26C157.189 42.3133 157.129 42.3733 157.076 42.44C157.036 42.5067 157.016 42.58 157.016 42.66C157.016 42.8867 157.162 43.0467 157.456 43.14C157.749 43.2333 158.122 43.3067 158.576 43.36C159.029 43.4133 159.509 43.4867 160.016 43.58C160.536 43.66 161.022 43.7933 161.476 43.98C161.929 44.1667 162.302 44.4467 162.596 44.82C162.889 45.18 163.036 45.6667 163.036 46.28C163.036 47.0267 162.822 47.6267 162.396 48.08C161.982 48.5467 161.442 48.8867 160.776 49.1C160.122 49.3133 159.422 49.42 158.676 49.42ZM158.636 47.76C159.156 47.76 159.596 47.6333 159.956 47.38C160.329 47.1267 160.516 46.7867 160.516 46.36C160.516 46.08 160.436 45.8533 160.276 45.68C160.116 45.5067 159.896 45.3733 159.616 45.28C159.349 45.2 159.056 45.1333 158.736 45.08C158.416 45.04 158.096 45 157.776 44.96C157.456 45.1067 157.196 45.2933 156.996 45.52C156.796 45.7467 156.696 46.02 156.696 46.34C156.696 46.78 156.882 47.1267 157.256 47.38C157.642 47.6333 158.102 47.76 158.636 47.76ZM158.596 40.88C159.036 40.88 159.382 40.7133 159.636 40.38C159.889 40.0467 160.016 39.62 160.016 39.1V38.68C160.016 38.1867 159.889 37.7733 159.636 37.44C159.396 37.1067 159.042 36.94 158.576 36.94C158.122 36.94 157.769 37.1067 157.516 37.44C157.276 37.7733 157.156 38.1867 157.156 38.68V39.08C157.156 39.5867 157.276 40.0133 157.516 40.36C157.769 40.7067 158.129 40.88 158.596 40.88ZM165.65 45C165.276 45 164.97 44.9133 164.73 44.74C164.49 44.5667 164.37 44.3733 164.37 44.16V30.76C164.37 30.52 164.49 30.3267 164.73 30.18C164.97 30.0333 165.276 29.96 165.65 29.96C166.01 29.96 166.316 30.0333 166.57 30.18C166.823 30.3267 166.95 30.52 166.95 30.76V36.9C167.15 36.5133 167.463 36.1667 167.89 35.86C168.316 35.54 168.843 35.38 169.47 35.38C170.096 35.38 170.67 35.5667 171.19 35.94C171.71 36.3 172.123 36.7867 172.43 37.4C172.75 38.0133 172.91 38.6933 172.91 39.44V44.16C172.91 44.44 172.776 44.6533 172.51 44.8C172.243 44.9333 171.943 45 171.61 45C171.316 45 171.03 44.9333 170.75 44.8C170.47 44.6533 170.33 44.44 170.33 44.16V39.44C170.33 39.1333 170.25 38.8467 170.09 38.58C169.93 38.3133 169.716 38.0933 169.45 37.92C169.196 37.7333 168.91 37.64 168.59 37.64C168.323 37.64 168.063 37.7133 167.81 37.86C167.556 38.0067 167.35 38.2133 167.19 38.48C167.03 38.7467 166.95 39.0667 166.95 39.44V44.16C166.95 44.3733 166.823 44.5667 166.57 44.74C166.316 44.9133 166.01 45 165.65 45ZM178.498 45C177.298 45 176.378 44.74 175.738 44.22C175.111 43.7 174.798 42.8733 174.798 41.74V32.06C174.798 31.82 174.938 31.6267 175.218 31.48C175.498 31.3333 175.785 31.26 176.078 31.26C176.398 31.26 176.691 31.3333 176.958 31.48C177.238 31.6267 177.378 31.82 177.378 32.06V35.5H179.738C179.951 35.5 180.111 35.6 180.218 35.8C180.338 35.9867 180.398 36.2 180.398 36.44C180.398 36.68 180.338 36.9 180.218 37.1C180.111 37.2867 179.951 37.38 179.738 37.38H177.378V41.74C177.378 42.14 177.458 42.42 177.618 42.58C177.791 42.74 178.085 42.82 178.498 42.82H179.278C179.651 42.82 179.925 42.9333 180.098 43.16C180.285 43.3867 180.378 43.6333 180.378 43.9C180.378 44.18 180.285 44.4333 180.098 44.66C179.925 44.8867 179.651 45 179.278 45H178.498ZM182.933 40.96C182.666 40.96 182.433 40.9 182.233 40.78C182.033 40.66 181.933 40.4667 181.933 40.2C181.933 39.32 181.913 38.3667 181.873 37.34C181.833 36.3133 181.786 35.2867 181.733 34.26C181.693 33.2333 181.673 32.28 181.673 31.4C181.673 31.0533 181.793 30.7867 182.033 30.6C182.273 30.4 182.573 30.3 182.933 30.3C183.266 30.3 183.553 30.4 183.793 30.6C184.046 30.7867 184.173 31.0533 184.173 31.4C184.173 32.28 184.153 33.2333 184.113 34.26C184.073 35.2867 184.026 36.3133 183.973 37.34C183.933 38.3667 183.913 39.32 183.913 40.2C183.913 40.4667 183.8 40.66 183.573 40.78C183.346 40.9 183.133 40.96 182.933 40.96ZM182.953 45.12C182.566 45.12 182.24 44.9867 181.973 44.72C181.72 44.44 181.593 44.12 181.593 43.76C181.593 43.3867 181.72 43.0667 181.973 42.8C182.24 42.5333 182.566 42.4 182.953 42.4C183.313 42.4 183.626 42.5333 183.893 42.8C184.16 43.0667 184.293 43.3867 184.293 43.76C184.293 44.12 184.16 44.44 183.893 44.72C183.626 44.9867 183.313 45.12 182.953 45.12Z\" fill=\"#FF0082\"/> <path d=\"M43.5517 71.096C42.8477 71.096 42.2184 70.9733 41.6637 70.728C41.109 70.472 40.677 70.1147 40.3677 69.656C40.0584 69.1973 39.9037 68.6587 39.9037 68.04C39.9037 67.72 39.973 67.5067 40.1117 67.4C40.261 67.2827 40.4744 67.224 40.7517 67.224C40.9757 67.224 41.1677 67.2667 41.3277 67.352C41.4984 67.4267 41.589 67.5707 41.5997 67.784C41.6104 68.0933 41.6797 68.3867 41.8077 68.664C41.9357 68.9413 42.1384 69.1653 42.4157 69.336C42.693 69.5067 43.0504 69.592 43.4877 69.592C44.0957 69.592 44.565 69.4267 44.8957 69.096C45.237 68.7547 45.4077 68.232 45.4077 67.528V60.808H43.5357C43.3544 60.808 43.2157 60.7333 43.1197 60.584C43.0237 60.424 42.9757 60.2427 42.9757 60.04C42.9757 59.8693 43.0184 59.704 43.1037 59.544C43.189 59.384 43.333 59.304 43.5357 59.304H46.3357C46.5384 59.304 46.7144 59.352 46.8637 59.448C47.0237 59.544 47.1037 59.6827 47.1037 59.864V67.528C47.1037 68.392 46.9437 69.0853 46.6237 69.608C46.3037 70.1307 45.877 70.5093 45.3437 70.744C44.8104 70.9787 44.213 71.096 43.5517 71.096ZM50.5358 71.128C49.9491 71.128 49.4478 70.9573 49.0318 70.616C48.6158 70.264 48.4078 69.7307 48.4078 69.016C48.4078 68.408 48.5678 67.9387 48.8878 67.608C49.2078 67.2773 49.6451 67.048 50.1998 66.92C50.7651 66.792 51.4158 66.728 52.1518 66.728H52.8558V66.44C52.8558 66.1627 52.8025 65.896 52.6958 65.64C52.5998 65.3733 52.4345 65.1547 52.1998 64.984C51.9758 64.8027 51.6665 64.712 51.2718 64.712C50.8771 64.712 50.5731 64.7493 50.3598 64.824C50.1465 64.8987 49.9758 64.9787 49.8478 65.064C49.7198 65.1493 49.6025 65.192 49.4958 65.192C49.3038 65.192 49.1545 65.1013 49.0478 64.92C48.9411 64.728 48.8878 64.536 48.8878 64.344C48.8878 64.152 49.0105 63.9813 49.2558 63.832C49.5118 63.672 49.8265 63.5493 50.1998 63.464C50.5731 63.368 50.9411 63.32 51.3038 63.32C52.0931 63.32 52.7225 63.4693 53.1918 63.768C53.6611 64.056 54.0025 64.4347 54.2158 64.904C54.4291 65.3733 54.5358 65.88 54.5358 66.424V70.44C54.5358 70.5893 54.4558 70.7227 54.2958 70.84C54.1465 70.9467 53.9545 71 53.7198 71C53.5065 71 53.3251 70.9467 53.1758 70.84C53.0265 70.7227 52.9518 70.5893 52.9518 70.44V69.88C52.6745 70.2 52.3385 70.488 51.9438 70.744C51.5491 71 51.0798 71.128 50.5358 71.128ZM51.1438 69.848C51.4105 69.848 51.6718 69.768 51.9278 69.608C52.1945 69.448 52.4131 69.2453 52.5838 69C52.7651 68.7547 52.8558 68.504 52.8558 68.248V67.656H52.4558C52.0505 67.656 51.6665 67.6827 51.3038 67.736C50.9411 67.7787 50.6478 67.8853 50.4238 68.056C50.2105 68.216 50.1038 68.4667 50.1038 68.808C50.1038 69.1707 50.1998 69.4373 50.3918 69.608C50.5945 69.768 50.8451 69.848 51.1438 69.848ZM57.0476 71C56.8129 71 56.6156 70.9413 56.4556 70.824C56.3062 70.7067 56.2316 70.5787 56.2316 70.44V63.96C56.2316 63.8 56.3062 63.672 56.4556 63.576C56.6156 63.4693 56.8129 63.416 57.0476 63.416C57.2609 63.416 57.4422 63.4693 57.5916 63.576C57.7409 63.672 57.8156 63.8 57.8156 63.96V64.664C57.9329 64.44 58.0876 64.2267 58.2796 64.024C58.4822 63.8213 58.7169 63.656 58.9836 63.528C59.2502 63.3893 59.5382 63.32 59.8476 63.32H60.3596C60.5302 63.32 60.6796 63.3947 60.8076 63.544C60.9356 63.6827 60.9996 63.8533 60.9996 64.056C60.9996 64.2587 60.9356 64.4347 60.8076 64.584C60.6796 64.7333 60.5302 64.808 60.3596 64.808H59.8476C59.5276 64.808 59.2182 64.904 58.9196 65.096C58.6209 65.288 58.3756 65.56 58.1836 65.912C58.0022 66.2533 57.9116 66.6693 57.9116 67.16V70.44C57.9116 70.5787 57.8262 70.7067 57.6556 70.824C57.4956 70.9413 57.2929 71 57.0476 71ZM64.2547 71.128C63.732 71.128 63.2627 71.064 62.8467 70.936C62.4307 70.808 62.1 70.648 61.8547 70.456C61.62 70.2533 61.5027 70.0507 61.5027 69.848C61.5027 69.752 61.524 69.6453 61.5667 69.528C61.62 69.4107 61.6894 69.3093 61.7747 69.224C61.8707 69.1387 61.972 69.096 62.0787 69.096C62.2174 69.096 62.3614 69.16 62.5107 69.288C62.6707 69.4053 62.8787 69.528 63.1347 69.656C63.3907 69.7733 63.748 69.832 64.2067 69.832C64.74 69.832 65.0974 69.7413 65.2787 69.56C65.4707 69.3787 65.5667 69.1813 65.5667 68.968C65.5667 68.6907 65.4707 68.4773 65.2787 68.328C65.0974 68.168 64.8574 68.04 64.5587 67.944C64.2707 67.848 63.9614 67.7573 63.6307 67.672C63.3 67.576 62.9854 67.4533 62.6867 67.304C62.3987 67.1547 62.1587 66.9467 61.9667 66.68C61.7854 66.4133 61.6947 66.0613 61.6947 65.624C61.6947 65.2613 61.7854 64.904 61.9667 64.552C62.148 64.1893 62.436 63.896 62.8307 63.672C63.236 63.4373 63.7747 63.32 64.4467 63.32C64.852 63.32 65.236 63.3627 65.5987 63.448C65.9614 63.5333 66.26 63.6507 66.4947 63.8C66.7294 63.9387 66.8467 64.0933 66.8467 64.264C66.8467 64.3387 66.82 64.4453 66.7667 64.584C66.7134 64.712 66.6387 64.8293 66.5427 64.936C66.4574 65.032 66.3454 65.08 66.2067 65.08C66.1 65.08 65.9667 65.0427 65.8067 64.968C65.6467 64.8827 65.46 64.8027 65.2467 64.728C65.0334 64.6533 64.772 64.616 64.4627 64.616C64.1534 64.616 63.9027 64.6693 63.7107 64.776C63.5294 64.872 63.396 64.9893 63.3107 65.128C63.2254 65.2667 63.1827 65.4053 63.1827 65.544C63.1827 65.7787 63.2734 65.96 63.4547 66.088C63.636 66.216 63.876 66.3227 64.1747 66.408C64.4734 66.4933 64.788 66.584 65.1187 66.68C65.4494 66.7653 65.7587 66.8933 66.0467 67.064C66.3454 67.2347 66.5854 67.464 66.7667 67.752C66.9587 68.04 67.0547 68.424 67.0547 68.904C67.0547 69.576 66.8094 70.1147 66.3187 70.52C65.8387 70.9253 65.1507 71.128 64.2547 71.128ZM72.4698 71C72.2245 71 72.0218 70.9413 71.8618 70.824C71.7125 70.7067 71.6378 70.5787 71.6378 70.44V63.96C71.6378 63.8 71.7125 63.672 71.8618 63.576C72.0218 63.4693 72.2245 63.416 72.4698 63.416C72.6725 63.416 72.8485 63.4693 72.9978 63.576C73.1471 63.672 73.2218 63.8 73.2218 63.96V64.536C73.4031 64.2267 73.6698 63.9493 74.0218 63.704C74.3738 63.448 74.8165 63.32 75.3498 63.32C75.8298 63.32 76.2511 63.4693 76.6138 63.768C76.9871 64.0667 77.2645 64.4507 77.4458 64.92C77.7231 64.376 78.0805 63.976 78.5178 63.72C78.9551 63.4533 79.4031 63.32 79.8618 63.32C80.3418 63.32 80.7898 63.4427 81.2058 63.688C81.6325 63.9333 81.9791 64.2907 82.2458 64.76C82.5125 65.2293 82.6458 65.8 82.6458 66.472V70.44C82.6458 70.5787 82.5605 70.7067 82.3898 70.824C82.2298 70.9413 82.0325 71 81.7978 71C81.5738 71 81.3765 70.9413 81.2058 70.824C81.0458 70.7067 80.9658 70.5787 80.9658 70.44V66.472C80.9658 66.1093 80.8911 65.8053 80.7418 65.56C80.6031 65.304 80.4165 65.112 80.1818 64.984C79.9578 64.856 79.7231 64.792 79.4778 64.792C79.2218 64.792 78.9818 64.8613 78.7578 65C78.5338 65.128 78.3471 65.3147 78.1978 65.56C78.0485 65.7947 77.9738 66.088 77.9738 66.44V70.456C77.9738 70.648 77.8831 70.7867 77.7018 70.872C77.5311 70.9573 77.3391 71 77.1258 71C76.9338 71 76.7471 70.9573 76.5658 70.872C76.3845 70.7867 76.2938 70.648 76.2938 70.456V66.456C76.2938 66.1147 76.2245 65.8213 76.0858 65.576C75.9471 65.3307 75.7658 65.144 75.5418 65.016C75.3178 64.8773 75.0725 64.808 74.8058 64.808C74.5605 64.808 74.3205 64.872 74.0858 65C73.8618 65.128 73.6751 65.3147 73.5258 65.56C73.3871 65.8053 73.3178 66.1093 73.3178 66.472V70.44C73.3178 70.5787 73.2325 70.7067 73.0618 70.824C72.9018 70.9413 72.7045 71 72.4698 71ZM85.9889 71.128C85.4023 71.128 84.9009 70.9573 84.4849 70.616C84.0689 70.264 83.8609 69.7307 83.8609 69.016C83.8609 68.408 84.0209 67.9387 84.3409 67.608C84.6609 67.2773 85.0983 67.048 85.6529 66.92C86.2183 66.792 86.8689 66.728 87.6049 66.728H88.3089V66.44C88.3089 66.1627 88.2556 65.896 88.1489 65.64C88.0529 65.3733 87.8876 65.1547 87.6529 64.984C87.4289 64.8027 87.1196 64.712 86.7249 64.712C86.3303 64.712 86.0263 64.7493 85.8129 64.824C85.5996 64.8987 85.4289 64.9787 85.3009 65.064C85.1729 65.1493 85.0556 65.192 84.9489 65.192C84.7569 65.192 84.6076 65.1013 84.5009 64.92C84.3943 64.728 84.3409 64.536 84.3409 64.344C84.3409 64.152 84.4636 63.9813 84.7089 63.832C84.9649 63.672 85.2796 63.5493 85.6529 63.464C86.0263 63.368 86.3943 63.32 86.7569 63.32C87.5463 63.32 88.1756 63.4693 88.6449 63.768C89.1143 64.056 89.4556 64.4347 89.6689 64.904C89.8823 65.3733 89.9889 65.88 89.9889 66.424V70.44C89.9889 70.5893 89.9089 70.7227 89.7489 70.84C89.5996 70.9467 89.4076 71 89.1729 71C88.9596 71 88.7783 70.9467 88.6289 70.84C88.4796 70.7227 88.4049 70.5893 88.4049 70.44V69.88C88.1276 70.2 87.7916 70.488 87.3969 70.744C87.0023 71 86.5329 71.128 85.9889 71.128ZM86.5969 69.848C86.8636 69.848 87.1249 69.768 87.3809 69.608C87.6476 69.448 87.8663 69.2453 88.0369 69C88.2183 68.7547 88.3089 68.504 88.3089 68.248V67.656H87.9089C87.5036 67.656 87.1196 67.6827 86.7569 67.736C86.3943 67.7787 86.1009 67.8853 85.8769 68.056C85.6636 68.216 85.5569 68.4667 85.5569 68.808C85.5569 69.1707 85.6529 69.4373 85.8449 69.608C86.0476 69.768 86.2983 69.848 86.5969 69.848ZM94.2127 71.128C93.7114 71.128 93.2474 70.9787 92.8207 70.68C92.394 70.3813 92.0474 69.992 91.7807 69.512C91.5247 69.0213 91.3967 68.4987 91.3967 67.944V66.472C91.3967 65.8853 91.5247 65.3573 91.7807 64.888C92.0474 64.408 92.394 64.0293 92.8207 63.752C93.2474 63.464 93.722 63.32 94.2447 63.32C94.7567 63.32 95.1887 63.448 95.5407 63.704C95.8927 63.9493 96.154 64.2267 96.3247 64.536V59.448C96.3247 59.288 96.41 59.16 96.5807 59.064C96.7514 58.9573 96.954 58.904 97.1887 58.904C97.4234 58.904 97.6154 58.9573 97.7647 59.064C97.9247 59.16 98.0047 59.288 98.0047 59.448V70.44C98.0047 70.5787 97.9247 70.7067 97.7647 70.824C97.6154 70.9413 97.4234 71 97.1887 71C96.986 71 96.8047 70.9413 96.6447 70.824C96.4954 70.7067 96.4207 70.5787 96.4207 70.44V69.88C96.2607 70.2107 95.978 70.504 95.5727 70.76C95.1674 71.0053 94.714 71.128 94.2127 71.128ZM94.6927 69.64C95.002 69.64 95.2794 69.5547 95.5247 69.384C95.77 69.2133 95.962 69.0267 96.1007 68.824C96.25 68.6107 96.3247 68.44 96.3247 68.312V66.472C96.3247 66.12 96.2447 65.8213 96.0847 65.576C95.9247 65.3307 95.722 65.144 95.4767 65.016C95.2314 64.8773 94.9754 64.808 94.7087 64.808C94.41 64.808 94.1327 64.888 93.8767 65.048C93.6314 65.208 93.434 65.416 93.2847 65.672C93.146 65.928 93.0767 66.1947 93.0767 66.472V67.944C93.0767 68.2213 93.146 68.4933 93.2847 68.76C93.434 69.0267 93.6314 69.24 93.8767 69.4C94.122 69.56 94.394 69.64 94.6927 69.64ZM103.202 71.128C102.477 71.128 101.837 70.9947 101.282 70.728C100.728 70.4613 100.29 70.0933 99.9704 69.624C99.6504 69.144 99.4904 68.584 99.4904 67.944V66.424C99.4904 65.8587 99.6398 65.3413 99.9384 64.872C100.248 64.4027 100.653 64.0293 101.154 63.752C101.656 63.464 102.21 63.32 102.818 63.32C103.394 63.32 103.922 63.448 104.402 63.704C104.882 63.9493 105.266 64.296 105.554 64.744C105.853 65.192 106.002 65.704 106.002 66.28C106.002 66.728 105.933 67.048 105.794 67.24C105.656 67.432 105.474 67.5493 105.25 67.592C105.026 67.6347 104.792 67.656 104.546 67.656H101.17V68.024C101.17 68.5573 101.362 68.984 101.746 69.304C102.141 69.6133 102.642 69.768 103.25 69.768C103.624 69.768 103.928 69.7147 104.162 69.608C104.397 69.5013 104.594 69.4 104.754 69.304C104.914 69.208 105.064 69.16 105.202 69.16C105.341 69.16 105.458 69.2027 105.554 69.288C105.65 69.3733 105.725 69.4747 105.778 69.592C105.832 69.7093 105.858 69.816 105.858 69.912C105.858 70.072 105.746 70.248 105.522 70.44C105.309 70.632 105.005 70.7973 104.61 70.936C104.216 71.064 103.746 71.128 103.202 71.128ZM101.17 66.616H103.826C104.061 66.616 104.216 66.584 104.29 66.52C104.376 66.456 104.418 66.328 104.418 66.136C104.418 65.8587 104.349 65.6027 104.21 65.368C104.072 65.1227 103.88 64.936 103.634 64.808C103.389 64.6693 103.112 64.6 102.802 64.6C102.504 64.6 102.232 64.664 101.986 64.792C101.741 64.92 101.544 65.096 101.394 65.32C101.245 65.544 101.17 65.8053 101.17 66.104V66.616ZM111.407 71C111.173 71 110.975 70.952 110.815 70.856C110.666 70.7493 110.591 70.616 110.591 70.456V61.96C110.591 61.384 110.719 60.8667 110.975 60.408C111.231 59.9387 111.573 59.5707 111.999 59.304C112.426 59.0373 112.895 58.904 113.407 58.904H114.159C114.373 58.904 114.533 58.9787 114.639 59.128C114.757 59.2773 114.815 59.4427 114.815 59.624C114.815 59.816 114.757 59.9867 114.639 60.136C114.533 60.2747 114.373 60.344 114.159 60.344H113.727C113.45 60.344 113.199 60.408 112.975 60.536C112.762 60.664 112.591 60.84 112.463 61.064C112.335 61.2773 112.271 61.5227 112.271 61.8V63.416H114.335C114.495 63.416 114.613 63.48 114.687 63.608C114.773 63.736 114.815 63.88 114.815 64.04C114.815 64.2 114.773 64.344 114.687 64.472C114.613 64.6 114.495 64.664 114.335 64.664H112.271V70.456C112.271 70.616 112.186 70.7493 112.015 70.856C111.845 70.952 111.642 71 111.407 71ZM116.626 71C116.391 71 116.194 70.9413 116.034 70.824C115.884 70.7067 115.81 70.5787 115.81 70.44V63.96C115.81 63.8 115.884 63.672 116.034 63.576C116.194 63.4693 116.391 63.416 116.626 63.416C116.839 63.416 117.02 63.4693 117.17 63.576C117.319 63.672 117.394 63.8 117.394 63.96V64.664C117.511 64.44 117.666 64.2267 117.858 64.024C118.06 63.8213 118.295 63.656 118.562 63.528C118.828 63.3893 119.116 63.32 119.426 63.32H119.938C120.108 63.32 120.258 63.3947 120.386 63.544C120.514 63.6827 120.578 63.8533 120.578 64.056C120.578 64.2587 120.514 64.4347 120.386 64.584C120.258 64.7333 120.108 64.808 119.938 64.808H119.426C119.106 64.808 118.796 64.904 118.498 65.096C118.199 65.288 117.954 65.56 117.762 65.912C117.58 66.2533 117.49 66.6693 117.49 67.16V70.44C117.49 70.5787 117.404 70.7067 117.234 70.824C117.074 70.9413 116.871 71 116.626 71ZM124.286 71.128C123.71 71.128 123.171 70.9787 122.67 70.68C122.169 70.3813 121.763 69.992 121.454 69.512C121.155 69.0213 121.006 68.4987 121.006 67.944V66.472C121.006 65.9067 121.15 65.384 121.438 64.904C121.737 64.424 122.137 64.04 122.638 63.752C123.15 63.464 123.705 63.32 124.302 63.32C124.899 63.32 125.449 63.464 125.95 63.752C126.451 64.0293 126.851 64.408 127.15 64.888C127.459 65.3573 127.614 65.8853 127.614 66.472V67.944C127.614 68.488 127.459 69.0053 127.15 69.496C126.851 69.9867 126.446 70.3813 125.934 70.68C125.433 70.9787 124.883 71.128 124.286 71.128ZM124.302 69.64C124.601 69.64 124.873 69.56 125.118 69.4C125.363 69.24 125.561 69.032 125.71 68.776C125.859 68.5093 125.934 68.232 125.934 67.944V66.472C125.934 66.1947 125.859 65.928 125.71 65.672C125.561 65.416 125.363 65.208 125.118 65.048C124.873 64.888 124.601 64.808 124.302 64.808C123.993 64.808 123.715 64.888 123.47 65.048C123.235 65.208 123.043 65.416 122.894 65.672C122.755 65.928 122.686 66.1947 122.686 66.472V67.944C122.686 68.232 122.755 68.5093 122.894 68.776C123.043 69.032 123.241 69.24 123.486 69.4C123.731 69.56 124.003 69.64 124.302 69.64ZM129.907 71C129.662 71 129.459 70.9413 129.299 70.824C129.15 70.7067 129.075 70.5787 129.075 70.44V63.96C129.075 63.8 129.15 63.672 129.299 63.576C129.459 63.4693 129.662 63.416 129.907 63.416C130.11 63.416 130.286 63.4693 130.435 63.576C130.585 63.672 130.659 63.8 130.659 63.96V64.536C130.841 64.2267 131.107 63.9493 131.459 63.704C131.811 63.448 132.254 63.32 132.787 63.32C133.267 63.32 133.689 63.4693 134.051 63.768C134.425 64.0667 134.702 64.4507 134.883 64.92C135.161 64.376 135.518 63.976 135.955 63.72C136.393 63.4533 136.841 63.32 137.299 63.32C137.779 63.32 138.227 63.4427 138.643 63.688C139.07 63.9333 139.417 64.2907 139.683 64.76C139.95 65.2293 140.083 65.8 140.083 66.472V70.44C140.083 70.5787 139.998 70.7067 139.827 70.824C139.667 70.9413 139.47 71 139.235 71C139.011 71 138.814 70.9413 138.643 70.824C138.483 70.7067 138.403 70.5787 138.403 70.44V66.472C138.403 66.1093 138.329 65.8053 138.179 65.56C138.041 65.304 137.854 65.112 137.619 64.984C137.395 64.856 137.161 64.792 136.915 64.792C136.659 64.792 136.419 64.8613 136.195 65C135.971 65.128 135.785 65.3147 135.635 65.56C135.486 65.7947 135.411 66.088 135.411 66.44V70.456C135.411 70.648 135.321 70.7867 135.139 70.872C134.969 70.9573 134.777 71 134.563 71C134.371 71 134.185 70.9573 134.003 70.872C133.822 70.7867 133.731 70.648 133.731 70.456V66.456C133.731 66.1147 133.662 65.8213 133.523 65.576C133.385 65.3307 133.203 65.144 132.979 65.016C132.755 64.8773 132.51 64.808 132.243 64.808C131.998 64.808 131.758 64.872 131.523 65C131.299 65.128 131.113 65.3147 130.963 65.56C130.825 65.8053 130.755 66.1093 130.755 66.472V70.44C130.755 70.5787 130.67 70.7067 130.499 70.824C130.339 70.9413 130.142 71 129.907 71ZM147.846 74.6C147.227 74.6 146.656 74.5093 146.134 74.328C145.611 74.1573 145.195 73.9067 144.886 73.576C144.576 73.2453 144.422 72.8507 144.422 72.392C144.422 71.9653 144.544 71.608 144.79 71.32C145.035 71.0427 145.323 70.8293 145.654 70.68C145.44 70.584 145.264 70.456 145.126 70.296C144.987 70.136 144.918 69.912 144.918 69.624C144.918 69.3253 144.992 69.0853 145.142 68.904C145.291 68.7227 145.483 68.5573 145.718 68.408C145.419 68.1733 145.184 67.8853 145.014 67.544C144.854 67.192 144.774 66.808 144.774 66.392V65.944C144.774 65.432 144.896 64.9787 145.142 64.584C145.387 64.1893 145.734 63.88 146.182 63.656C146.64 63.432 147.163 63.32 147.75 63.32C148.112 63.32 148.448 63.368 148.758 63.464C149.078 63.56 149.36 63.6933 149.606 63.864C149.776 63.4693 149.947 63.192 150.118 63.032C150.299 62.872 150.47 62.792 150.63 62.792C150.854 62.792 151.024 62.856 151.142 62.984C151.259 63.112 151.318 63.24 151.318 63.368C151.318 63.4533 151.291 63.5333 151.238 63.608C151.195 63.672 151.131 63.7253 151.046 63.768C150.939 63.8213 150.811 63.896 150.662 63.992C150.523 64.0773 150.384 64.216 150.246 64.408C150.427 64.6107 150.56 64.8453 150.646 65.112C150.731 65.3787 150.774 65.656 150.774 65.944V66.392C150.774 66.8933 150.646 67.3467 150.39 67.752C150.134 68.1573 149.776 68.4773 149.318 68.712C148.859 68.936 148.336 69.048 147.75 69.048C147.334 69.048 146.966 68.984 146.646 68.856C146.56 68.9093 146.486 68.9733 146.422 69.048C146.368 69.112 146.342 69.1973 146.342 69.304C146.342 69.496 146.459 69.6347 146.694 69.72C146.928 69.8053 147.227 69.8693 147.59 69.912C147.963 69.9547 148.358 70.008 148.774 70.072C149.19 70.136 149.579 70.2427 149.942 70.392C150.315 70.5307 150.619 70.7387 150.854 71.016C151.088 71.304 151.206 71.6933 151.206 72.184C151.206 72.7387 151.051 73.192 150.742 73.544C150.432 73.9067 150.022 74.1733 149.51 74.344C149.008 74.5147 148.454 74.6 147.846 74.6ZM147.814 73.48C148.336 73.48 148.758 73.3627 149.078 73.128C149.408 72.904 149.574 72.6053 149.574 72.232C149.574 71.9653 149.494 71.7573 149.334 71.608C149.174 71.4587 148.966 71.3467 148.71 71.272C148.454 71.1973 148.182 71.144 147.894 71.112C147.616 71.08 147.35 71.048 147.094 71.016C146.795 71.1227 146.539 71.272 146.326 71.464C146.123 71.6667 146.022 71.9173 146.022 72.216C146.022 72.6107 146.187 72.92 146.518 73.144C146.859 73.368 147.291 73.48 147.814 73.48ZM147.782 67.976C148.208 67.976 148.539 67.8267 148.774 67.528C149.019 67.2293 149.142 66.8507 149.142 66.392V65.944C149.142 65.5067 149.019 65.1387 148.774 64.84C148.539 64.5413 148.203 64.392 147.766 64.392C147.328 64.392 146.992 64.5413 146.758 64.84C146.523 65.1387 146.406 65.5067 146.406 65.944V66.376C146.406 66.824 146.523 67.2027 146.758 67.512C146.992 67.8213 147.334 67.976 147.782 67.976ZM153.395 71C153.15 71 152.947 70.9413 152.787 70.824C152.638 70.7067 152.563 70.5787 152.563 70.44V59.448C152.563 59.288 152.638 59.16 152.787 59.064C152.947 58.9573 153.15 58.904 153.395 58.904C153.63 58.904 153.827 58.9573 153.987 59.064C154.158 59.16 154.243 59.288 154.243 59.448V70.44C154.243 70.5787 154.158 70.7067 153.987 70.824C153.827 70.9413 153.63 71 153.395 71ZM157.786 71.128C157.199 71.128 156.698 70.9573 156.282 70.616C155.866 70.264 155.658 69.7307 155.658 69.016C155.658 68.408 155.818 67.9387 156.138 67.608C156.458 67.2773 156.895 67.048 157.45 66.92C158.015 66.792 158.666 66.728 159.402 66.728H160.106V66.44C160.106 66.1627 160.052 65.896 159.946 65.64C159.85 65.3733 159.684 65.1547 159.45 64.984C159.226 64.8027 158.916 64.712 158.522 64.712C158.127 64.712 157.823 64.7493 157.61 64.824C157.396 64.8987 157.226 64.9787 157.098 65.064C156.97 65.1493 156.852 65.192 156.746 65.192C156.554 65.192 156.404 65.1013 156.298 64.92C156.191 64.728 156.138 64.536 156.138 64.344C156.138 64.152 156.26 63.9813 156.506 63.832C156.762 63.672 157.076 63.5493 157.45 63.464C157.823 63.368 158.191 63.32 158.554 63.32C159.343 63.32 159.972 63.4693 160.442 63.768C160.911 64.056 161.252 64.4347 161.466 64.904C161.679 65.3733 161.786 65.88 161.786 66.424V70.44C161.786 70.5893 161.706 70.7227 161.546 70.84C161.396 70.9467 161.204 71 160.97 71C160.756 71 160.575 70.9467 160.426 70.84C160.276 70.7227 160.202 70.5893 160.202 70.44V69.88C159.924 70.2 159.588 70.488 159.194 70.744C158.799 71 158.33 71.128 157.786 71.128ZM158.394 69.848C158.66 69.848 158.922 69.768 159.178 69.608C159.444 69.448 159.663 69.2453 159.834 69C160.015 68.7547 160.106 68.504 160.106 68.248V67.656H159.706C159.3 67.656 158.916 67.6827 158.554 67.736C158.191 67.7787 157.898 67.8853 157.674 68.056C157.46 68.216 157.354 68.4667 157.354 68.808C157.354 69.1707 157.45 69.4373 157.642 69.608C157.844 69.768 158.095 69.848 158.394 69.848ZM165.802 71.128C165.279 71.128 164.81 71.064 164.394 70.936C163.978 70.808 163.647 70.648 163.402 70.456C163.167 70.2533 163.05 70.0507 163.05 69.848C163.05 69.752 163.071 69.6453 163.114 69.528C163.167 69.4107 163.236 69.3093 163.322 69.224C163.418 69.1387 163.519 69.096 163.626 69.096C163.764 69.096 163.908 69.16 164.058 69.288C164.218 69.4053 164.426 69.528 164.682 69.656C164.938 69.7733 165.295 69.832 165.754 69.832C166.287 69.832 166.644 69.7413 166.826 69.56C167.018 69.3787 167.114 69.1813 167.114 68.968C167.114 68.6907 167.018 68.4773 166.826 68.328C166.644 68.168 166.404 68.04 166.106 67.944C165.818 67.848 165.508 67.7573 165.178 67.672C164.847 67.576 164.532 67.4533 164.234 67.304C163.946 67.1547 163.706 66.9467 163.514 66.68C163.332 66.4133 163.242 66.0613 163.242 65.624C163.242 65.2613 163.332 64.904 163.514 64.552C163.695 64.1893 163.983 63.896 164.378 63.672C164.783 63.4373 165.322 63.32 165.994 63.32C166.399 63.32 166.783 63.3627 167.146 63.448C167.508 63.5333 167.807 63.6507 168.042 63.8C168.276 63.9387 168.394 64.0933 168.394 64.264C168.394 64.3387 168.367 64.4453 168.314 64.584C168.26 64.712 168.186 64.8293 168.09 64.936C168.004 65.032 167.892 65.08 167.754 65.08C167.647 65.08 167.514 65.0427 167.354 64.968C167.194 64.8827 167.007 64.8027 166.794 64.728C166.58 64.6533 166.319 64.616 166.01 64.616C165.7 64.616 165.45 64.6693 165.258 64.776C165.076 64.872 164.943 64.9893 164.858 65.128C164.772 65.2667 164.73 65.4053 164.73 65.544C164.73 65.7787 164.82 65.96 165.002 66.088C165.183 66.216 165.423 66.3227 165.722 66.408C166.02 66.4933 166.335 66.584 166.666 66.68C166.996 66.7653 167.306 66.8933 167.594 67.064C167.892 67.2347 168.132 67.464 168.314 67.752C168.506 68.04 168.602 68.424 168.602 68.904C168.602 69.576 168.356 70.1147 167.866 70.52C167.386 70.9253 166.698 71.128 165.802 71.128ZM172.302 71.128C171.779 71.128 171.31 71.064 170.894 70.936C170.478 70.808 170.147 70.648 169.902 70.456C169.667 70.2533 169.55 70.0507 169.55 69.848C169.55 69.752 169.571 69.6453 169.614 69.528C169.667 69.4107 169.736 69.3093 169.822 69.224C169.918 69.1387 170.019 69.096 170.126 69.096C170.264 69.096 170.408 69.16 170.558 69.288C170.718 69.4053 170.926 69.528 171.182 69.656C171.438 69.7733 171.795 69.832 172.254 69.832C172.787 69.832 173.144 69.7413 173.326 69.56C173.518 69.3787 173.614 69.1813 173.614 68.968C173.614 68.6907 173.518 68.4773 173.326 68.328C173.144 68.168 172.904 68.04 172.606 67.944C172.318 67.848 172.008 67.7573 171.678 67.672C171.347 67.576 171.032 67.4533 170.734 67.304C170.446 67.1547 170.206 66.9467 170.014 66.68C169.832 66.4133 169.742 66.0613 169.742 65.624C169.742 65.2613 169.832 64.904 170.014 64.552C170.195 64.1893 170.483 63.896 170.878 63.672C171.283 63.4373 171.822 63.32 172.494 63.32C172.899 63.32 173.283 63.3627 173.646 63.448C174.008 63.5333 174.307 63.6507 174.542 63.8C174.776 63.9387 174.894 64.0933 174.894 64.264C174.894 64.3387 174.867 64.4453 174.814 64.584C174.76 64.712 174.686 64.8293 174.59 64.936C174.504 65.032 174.392 65.08 174.254 65.08C174.147 65.08 174.014 65.0427 173.854 64.968C173.694 64.8827 173.507 64.8027 173.294 64.728C173.08 64.6533 172.819 64.616 172.51 64.616C172.2 64.616 171.95 64.6693 171.758 64.776C171.576 64.872 171.443 64.9893 171.358 65.128C171.272 65.2667 171.23 65.4053 171.23 65.544C171.23 65.7787 171.32 65.96 171.502 66.088C171.683 66.216 171.923 66.3227 172.222 66.408C172.52 66.4933 172.835 66.584 173.166 66.68C173.496 66.7653 173.806 66.8933 174.094 67.064C174.392 67.2347 174.632 67.464 174.814 67.752C175.006 68.04 175.102 68.424 175.102 68.904C175.102 69.576 174.856 70.1147 174.366 70.52C173.886 70.9253 173.198 71.128 172.302 71.128ZM180.517 71C180.271 71 180.069 70.9413 179.909 70.824C179.759 70.7067 179.685 70.5787 179.685 70.44V63.96C179.685 63.8 179.759 63.672 179.909 63.576C180.069 63.4693 180.271 63.416 180.517 63.416C180.719 63.416 180.895 63.4693 181.045 63.576C181.194 63.672 181.269 63.8 181.269 63.96V64.536C181.45 64.2267 181.717 63.9493 182.069 63.704C182.421 63.448 182.863 63.32 183.397 63.32C183.877 63.32 184.298 63.4693 184.661 63.768C185.034 64.0667 185.311 64.4507 185.493 64.92C185.77 64.376 186.127 63.976 186.565 63.72C187.002 63.4533 187.45 63.32 187.909 63.32C188.389 63.32 188.837 63.4427 189.253 63.688C189.679 63.9333 190.026 64.2907 190.293 64.76C190.559 65.2293 190.693 65.8 190.693 66.472V70.44C190.693 70.5787 190.607 70.7067 190.437 70.824C190.277 70.9413 190.079 71 189.845 71C189.621 71 189.423 70.9413 189.253 70.824C189.093 70.7067 189.013 70.5787 189.013 70.44V66.472C189.013 66.1093 188.938 65.8053 188.789 65.56C188.65 65.304 188.463 65.112 188.229 64.984C188.005 64.856 187.77 64.792 187.525 64.792C187.269 64.792 187.029 64.8613 186.805 65C186.581 65.128 186.394 65.3147 186.245 65.56C186.095 65.7947 186.021 66.088 186.021 66.44V70.456C186.021 70.648 185.93 70.7867 185.749 70.872C185.578 70.9573 185.386 71 185.173 71C184.981 71 184.794 70.9573 184.613 70.872C184.431 70.7867 184.341 70.648 184.341 70.456V66.456C184.341 66.1147 184.271 65.8213 184.133 65.576C183.994 65.3307 183.813 65.144 183.589 65.016C183.365 64.8773 183.119 64.808 182.853 64.808C182.607 64.808 182.367 64.872 182.133 65C181.909 65.128 181.722 65.3147 181.573 65.56C181.434 65.8053 181.365 66.1093 181.365 66.472V70.44C181.365 70.5787 181.279 70.7067 181.109 70.824C180.949 70.9413 180.751 71 180.517 71ZM195.62 71.128C195.022 71.128 194.468 70.984 193.956 70.696C193.454 70.3973 193.054 70.008 192.756 69.528C192.457 69.0373 192.308 68.52 192.308 67.976V63.976C192.308 63.8373 192.388 63.7093 192.548 63.592C192.718 63.4747 192.921 63.416 193.156 63.416C193.38 63.416 193.572 63.4747 193.732 63.592C193.902 63.7093 193.988 63.8373 193.988 63.976V67.976C193.988 68.2533 194.057 68.52 194.196 68.776C194.345 69.032 194.542 69.24 194.788 69.4C195.044 69.56 195.321 69.64 195.62 69.64C195.918 69.64 196.19 69.56 196.436 69.4C196.681 69.24 196.873 69.032 197.012 68.776C197.161 68.52 197.236 68.2533 197.236 67.976V63.96C197.236 63.8107 197.321 63.6827 197.492 63.576C197.673 63.4693 197.87 63.416 198.084 63.416C198.329 63.416 198.526 63.4693 198.676 63.576C198.836 63.6827 198.916 63.8107 198.916 63.96V67.976C198.916 68.5413 198.766 69.064 198.468 69.544C198.169 70.024 197.769 70.408 197.268 70.696C196.766 70.984 196.217 71.128 195.62 71.128ZM202.911 71.128C202.388 71.128 201.919 71.064 201.503 70.936C201.087 70.808 200.756 70.648 200.511 70.456C200.276 70.2533 200.159 70.0507 200.159 69.848C200.159 69.752 200.18 69.6453 200.223 69.528C200.276 69.4107 200.346 69.3093 200.431 69.224C200.527 69.1387 200.628 69.096 200.735 69.096C200.874 69.096 201.018 69.16 201.167 69.288C201.327 69.4053 201.535 69.528 201.791 69.656C202.047 69.7733 202.404 69.832 202.863 69.832C203.396 69.832 203.754 69.7413 203.935 69.56C204.127 69.3787 204.223 69.1813 204.223 68.968C204.223 68.6907 204.127 68.4773 203.935 68.328C203.754 68.168 203.514 68.04 203.215 67.944C202.927 67.848 202.618 67.7573 202.287 67.672C201.956 67.576 201.642 67.4533 201.343 67.304C201.055 67.1547 200.815 66.9467 200.623 66.68C200.442 66.4133 200.351 66.0613 200.351 65.624C200.351 65.2613 200.442 64.904 200.623 64.552C200.804 64.1893 201.092 63.896 201.487 63.672C201.892 63.4373 202.431 63.32 203.103 63.32C203.508 63.32 203.892 63.3627 204.255 63.448C204.618 63.5333 204.916 63.6507 205.151 63.8C205.386 63.9387 205.503 64.0933 205.503 64.264C205.503 64.3387 205.476 64.4453 205.423 64.584C205.37 64.712 205.295 64.8293 205.199 64.936C205.114 65.032 205.002 65.08 204.863 65.08C204.756 65.08 204.623 65.0427 204.463 64.968C204.303 64.8827 204.116 64.8027 203.903 64.728C203.69 64.6533 203.428 64.616 203.119 64.616C202.81 64.616 202.559 64.6693 202.367 64.776C202.186 64.872 202.052 64.9893 201.967 65.128C201.882 65.2667 201.839 65.4053 201.839 65.544C201.839 65.7787 201.93 65.96 202.111 66.088C202.292 66.216 202.532 66.3227 202.831 66.408C203.13 66.4933 203.444 66.584 203.775 66.68C204.106 66.7653 204.415 66.8933 204.703 67.064C205.002 67.2347 205.242 67.464 205.423 67.752C205.615 68.04 205.711 68.424 205.711 68.904C205.711 69.576 205.466 70.1147 204.975 70.52C204.495 70.9253 203.807 71.128 202.911 71.128ZM209.859 71C208.952 71 208.259 70.8027 207.779 70.408C207.299 70.0027 207.059 69.368 207.059 68.504V60.488C207.059 60.328 207.144 60.2 207.315 60.104C207.496 59.9973 207.688 59.944 207.891 59.944C208.094 59.944 208.286 59.9973 208.467 60.104C208.648 60.2 208.739 60.328 208.739 60.488V63.416H210.691C210.84 63.416 210.952 63.48 211.027 63.608C211.112 63.736 211.155 63.88 211.155 64.04C211.155 64.2 211.112 64.344 211.027 64.472C210.952 64.6 210.84 64.664 210.691 64.664H208.739V68.504C208.739 68.888 208.819 69.16 208.979 69.32C209.15 69.48 209.443 69.56 209.859 69.56H210.403C210.648 69.56 210.83 69.6347 210.947 69.784C211.075 69.9227 211.139 70.088 211.139 70.28C211.139 70.4613 211.075 70.6267 210.947 70.776C210.83 70.9253 210.648 71 210.403 71H209.859ZM219.321 71.128C218.819 71.128 218.366 71.0053 217.961 70.76C217.566 70.504 217.283 70.2107 217.113 69.88V70.44C217.113 70.5787 217.038 70.7067 216.889 70.824C216.739 70.9413 216.558 71 216.345 71C216.11 71 215.913 70.9413 215.753 70.824C215.603 70.7067 215.529 70.5787 215.529 70.44V59.448C215.529 59.288 215.603 59.16 215.753 59.064C215.913 58.9573 216.11 58.904 216.345 58.904C216.59 58.904 216.793 58.9573 216.953 59.064C217.123 59.16 217.209 59.288 217.209 59.448V64.536C217.379 64.2267 217.641 63.9493 217.993 63.704C218.345 63.448 218.771 63.32 219.273 63.32C219.795 63.32 220.27 63.464 220.697 63.752C221.134 64.0293 221.481 64.408 221.737 64.888C222.003 65.3573 222.137 65.8853 222.137 66.472V67.944C222.137 68.4987 222.003 69.0213 221.737 69.512C221.481 69.992 221.139 70.3813 220.713 70.68C220.286 70.9787 219.822 71.128 219.321 71.128ZM218.841 69.64C219.129 69.64 219.395 69.56 219.641 69.4C219.886 69.24 220.083 69.0267 220.233 68.76C220.382 68.4933 220.457 68.2213 220.457 67.944V66.472C220.457 66.1947 220.382 65.928 220.233 65.672C220.083 65.416 219.886 65.208 219.641 65.048C219.395 64.888 219.123 64.808 218.825 64.808C218.558 64.808 218.302 64.8773 218.057 65.016C217.811 65.144 217.609 65.3307 217.449 65.576C217.289 65.8213 217.209 66.12 217.209 66.472V68.312C217.209 68.44 217.278 68.6107 217.417 68.824C217.566 69.0267 217.763 69.2133 218.009 69.384C218.254 69.5547 218.531 69.64 218.841 69.64ZM227.031 71.128C226.305 71.128 225.665 70.9947 225.111 70.728C224.556 70.4613 224.119 70.0933 223.799 69.624C223.479 69.144 223.319 68.584 223.319 67.944V66.424C223.319 65.8587 223.468 65.3413 223.767 64.872C224.076 64.4027 224.481 64.0293 224.983 63.752C225.484 63.464 226.039 63.32 226.647 63.32C227.223 63.32 227.751 63.448 228.231 63.704C228.711 63.9493 229.095 64.296 229.383 64.744C229.681 65.192 229.831 65.704 229.831 66.28C229.831 66.728 229.761 67.048 229.623 67.24C229.484 67.432 229.303 67.5493 229.079 67.592C228.855 67.6347 228.62 67.656 228.375 67.656H224.999V68.024C224.999 68.5573 225.191 68.984 225.575 69.304C225.969 69.6133 226.471 69.768 227.079 69.768C227.452 69.768 227.756 69.7147 227.991 69.608C228.225 69.5013 228.423 69.4 228.583 69.304C228.743 69.208 228.892 69.16 229.031 69.16C229.169 69.16 229.287 69.2027 229.383 69.288C229.479 69.3733 229.553 69.4747 229.607 69.592C229.66 69.7093 229.687 69.816 229.687 69.912C229.687 70.072 229.575 70.248 229.351 70.44C229.137 70.632 228.833 70.7973 228.439 70.936C228.044 71.064 227.575 71.128 227.031 71.128ZM224.999 66.616H227.655C227.889 66.616 228.044 66.584 228.119 66.52C228.204 66.456 228.247 66.328 228.247 66.136C228.247 65.8587 228.177 65.6027 228.039 65.368C227.9 65.1227 227.708 64.936 227.463 64.808C227.217 64.6693 226.94 64.6 226.631 64.6C226.332 64.6 226.06 64.664 225.815 64.792C225.569 64.92 225.372 65.096 225.223 65.32C225.073 65.544 224.999 65.8053 224.999 66.104V66.616ZM63.1882 91C62.9535 91 62.7562 90.9413 62.5962 90.824C62.4469 90.7067 62.3722 90.5787 62.3722 90.44V83.96C62.3722 83.8 62.4469 83.672 62.5962 83.576C62.7562 83.4693 62.9535 83.416 63.1882 83.416C63.4015 83.416 63.5829 83.4693 63.7322 83.576C63.8815 83.672 63.9562 83.8 63.9562 83.96V84.664C64.0735 84.44 64.2282 84.2267 64.4202 84.024C64.6229 83.8213 64.8575 83.656 65.1242 83.528C65.3909 83.3893 65.6789 83.32 65.9882 83.32H66.5002C66.6709 83.32 66.8202 83.3947 66.9482 83.544C67.0762 83.6827 67.1402 83.8533 67.1402 84.056C67.1402 84.2587 67.0762 84.4347 66.9482 84.584C66.8202 84.7333 66.6709 84.808 66.5002 84.808H65.9882C65.6682 84.808 65.3589 84.904 65.0602 85.096C64.7615 85.288 64.5162 85.56 64.3242 85.912C64.1429 86.2533 64.0522 86.6693 64.0522 87.16V90.44C64.0522 90.5787 63.9669 90.7067 63.7962 90.824C63.6362 90.9413 63.4335 91 63.1882 91ZM68.9386 81.512C68.6719 81.512 68.4426 81.4213 68.2506 81.24C68.0586 81.0587 67.9626 80.856 67.9626 80.632C67.9626 80.3867 68.0586 80.1787 68.2506 80.008C68.4426 79.8373 68.6719 79.752 68.9386 79.752C69.2052 79.752 69.4292 79.8373 69.6106 80.008C69.8026 80.1787 69.8986 80.3867 69.8986 80.632C69.8986 80.856 69.8026 81.0587 69.6106 81.24C69.4292 81.4213 69.2052 81.512 68.9386 81.512ZM68.9386 91C68.6932 91 68.4906 90.9413 68.3306 90.824C68.1812 90.7067 68.1066 90.5787 68.1066 90.44V83.96C68.1066 83.8 68.1812 83.672 68.3306 83.576C68.4906 83.4693 68.6932 83.416 68.9386 83.416C69.1732 83.416 69.3706 83.4693 69.5306 83.576C69.7012 83.672 69.7866 83.8 69.7866 83.96V90.44C69.7866 90.5787 69.7012 90.7067 69.5306 90.824C69.3706 90.9413 69.1732 91 68.9386 91ZM72.3604 91C72.1151 91 71.9124 90.9413 71.7524 90.824C71.6031 90.7067 71.5284 90.5787 71.5284 90.44V83.96C71.5284 83.8 71.6031 83.672 71.7524 83.576C71.9124 83.4693 72.1151 83.416 72.3604 83.416C72.5631 83.416 72.7391 83.4693 72.8884 83.576C73.0378 83.672 73.1124 83.8 73.1124 83.96V84.536C73.2724 84.2267 73.5338 83.9493 73.8964 83.704C74.2698 83.448 74.7231 83.32 75.2564 83.32C75.7578 83.32 76.2164 83.464 76.6324 83.752C77.0591 84.0293 77.4004 84.408 77.6564 84.888C77.9124 85.3573 78.0404 85.8853 78.0404 86.472V90.44C78.0404 90.6213 77.9498 90.76 77.7684 90.856C77.5978 90.952 77.4058 91 77.1924 91C77.0004 91 76.8138 90.952 76.6324 90.856C76.4511 90.76 76.3604 90.6213 76.3604 90.44V86.472C76.3604 86.1947 76.2858 85.928 76.1364 85.672C75.9978 85.416 75.8058 85.208 75.5604 85.048C75.3151 84.888 75.0431 84.808 74.7444 84.808C74.4884 84.808 74.2431 84.8773 74.0084 85.016C73.7738 85.144 73.5818 85.3307 73.4324 85.576C73.2831 85.8213 73.2084 86.12 73.2084 86.472V90.44C73.2084 90.5787 73.1231 90.7067 72.9524 90.824C72.7924 90.9413 72.5951 91 72.3604 91ZM82.0359 91.128C81.5133 91.128 81.0439 91.064 80.6279 90.936C80.2119 90.808 79.8813 90.648 79.6359 90.456C79.4013 90.2533 79.2839 90.0507 79.2839 89.848C79.2839 89.752 79.3053 89.6453 79.3479 89.528C79.4013 89.4107 79.4706 89.3093 79.5559 89.224C79.6519 89.1387 79.7533 89.096 79.8599 89.096C79.9986 89.096 80.1426 89.16 80.2919 89.288C80.4519 89.4053 80.6599 89.528 80.9159 89.656C81.1719 89.7733 81.5293 89.832 81.9879 89.832C82.5213 89.832 82.8786 89.7413 83.0599 89.56C83.2519 89.3787 83.3479 89.1813 83.3479 88.968C83.3479 88.6907 83.2519 88.4773 83.0599 88.328C82.8786 88.168 82.6386 88.04 82.3399 87.944C82.0519 87.848 81.7426 87.7573 81.4119 87.672C81.0813 87.576 80.7666 87.4533 80.4679 87.304C80.1799 87.1547 79.9399 86.9467 79.7479 86.68C79.5666 86.4133 79.4759 86.0613 79.4759 85.624C79.4759 85.2613 79.5666 84.904 79.7479 84.552C79.9293 84.1893 80.2173 83.896 80.6119 83.672C81.0173 83.4373 81.5559 83.32 82.2279 83.32C82.6333 83.32 83.0173 83.3627 83.3799 83.448C83.7426 83.5333 84.0413 83.6507 84.2759 83.8C84.5106 83.9387 84.6279 84.0933 84.6279 84.264C84.6279 84.3387 84.6013 84.4453 84.5479 84.584C84.4946 84.712 84.4199 84.8293 84.3239 84.936C84.2386 85.032 84.1266 85.08 83.9879 85.08C83.8813 85.08 83.7479 85.0427 83.5879 84.968C83.4279 84.8827 83.2413 84.8027 83.0279 84.728C82.8146 84.6533 82.5533 84.616 82.2439 84.616C81.9346 84.616 81.6839 84.6693 81.4919 84.776C81.3106 84.872 81.1773 84.9893 81.0919 85.128C81.0066 85.2667 80.9639 85.4053 80.9639 85.544C80.9639 85.7787 81.0546 85.96 81.2359 86.088C81.4173 86.216 81.6573 86.3227 81.9559 86.408C82.2546 86.4933 82.5693 86.584 82.8999 86.68C83.2306 86.7653 83.5399 86.8933 83.8279 87.064C84.1266 87.2347 84.3666 87.464 84.5479 87.752C84.7399 88.04 84.8359 88.424 84.8359 88.904C84.8359 89.576 84.5906 90.1147 84.0999 90.52C83.6199 90.9253 82.9319 91.128 82.0359 91.128ZM89.6399 91.128C88.9146 91.128 88.2746 90.9947 87.7199 90.728C87.1653 90.4613 86.7279 90.0933 86.4079 89.624C86.0879 89.144 85.9279 88.584 85.9279 87.944V86.424C85.9279 85.8587 86.0773 85.3413 86.3759 84.872C86.6853 84.4027 87.0906 84.0293 87.5919 83.752C88.0933 83.464 88.6479 83.32 89.2559 83.32C89.8319 83.32 90.3599 83.448 90.8399 83.704C91.3199 83.9493 91.7039 84.296 91.9919 84.744C92.2906 85.192 92.4399 85.704 92.4399 86.28C92.4399 86.728 92.3706 87.048 92.2319 87.24C92.0933 87.432 91.9119 87.5493 91.6879 87.592C91.4639 87.6347 91.2293 87.656 90.9839 87.656H87.6079V88.024C87.6079 88.5573 87.7999 88.984 88.1839 89.304C88.5786 89.6133 89.0799 89.768 89.6879 89.768C90.0613 89.768 90.3653 89.7147 90.5999 89.608C90.8346 89.5013 91.0319 89.4 91.1919 89.304C91.3519 89.208 91.5013 89.16 91.6399 89.16C91.7786 89.16 91.8959 89.2027 91.9919 89.288C92.0879 89.3733 92.1626 89.4747 92.2159 89.592C92.2693 89.7093 92.2959 89.816 92.2959 89.912C92.2959 90.072 92.1839 90.248 91.9599 90.44C91.7466 90.632 91.4426 90.7973 91.0479 90.936C90.6533 91.064 90.1839 91.128 89.6399 91.128ZM87.6079 86.616H90.2639C90.4986 86.616 90.6533 86.584 90.7279 86.52C90.8133 86.456 90.8559 86.328 90.8559 86.136C90.8559 85.8587 90.7866 85.6027 90.6479 85.368C90.5093 85.1227 90.3173 84.936 90.0719 84.808C89.8266 84.6693 89.5493 84.6 89.2399 84.6C88.9413 84.6 88.6693 84.664 88.4239 84.792C88.1786 84.92 87.9813 85.096 87.8319 85.32C87.6826 85.544 87.6079 85.8053 87.6079 86.104V86.616ZM96.3377 91.128C95.8364 91.128 95.3724 90.9787 94.9457 90.68C94.519 90.3813 94.1724 89.992 93.9057 89.512C93.6497 89.0213 93.5217 88.4987 93.5217 87.944V86.472C93.5217 85.8853 93.6497 85.3573 93.9057 84.888C94.1724 84.408 94.519 84.0293 94.9457 83.752C95.3724 83.464 95.847 83.32 96.3697 83.32C96.8817 83.32 97.3137 83.448 97.6657 83.704C98.0177 83.9493 98.279 84.2267 98.4497 84.536V79.448C98.4497 79.288 98.535 79.16 98.7057 79.064C98.8764 78.9573 99.079 78.904 99.3137 78.904C99.5484 78.904 99.7404 78.9573 99.8897 79.064C100.05 79.16 100.13 79.288 100.13 79.448V90.44C100.13 90.5787 100.05 90.7067 99.8897 90.824C99.7404 90.9413 99.5484 91 99.3137 91C99.111 91 98.9297 90.9413 98.7697 90.824C98.6204 90.7067 98.5457 90.5787 98.5457 90.44V89.88C98.3857 90.2107 98.103 90.504 97.6977 90.76C97.2924 91.0053 96.839 91.128 96.3377 91.128ZM96.8177 89.64C97.127 89.64 97.4044 89.5547 97.6497 89.384C97.895 89.2133 98.087 89.0267 98.2257 88.824C98.375 88.6107 98.4497 88.44 98.4497 88.312V86.472C98.4497 86.12 98.3697 85.8213 98.2097 85.576C98.0497 85.3307 97.847 85.144 97.6017 85.016C97.3564 84.8773 97.1004 84.808 96.8337 84.808C96.535 84.808 96.2577 84.888 96.0017 85.048C95.7564 85.208 95.559 85.416 95.4097 85.672C95.271 85.928 95.2017 86.1947 95.2017 86.472V87.944C95.2017 88.2213 95.271 88.4933 95.4097 88.76C95.559 89.0267 95.7564 89.24 96.0017 89.4C96.247 89.56 96.519 89.64 96.8177 89.64ZM108.915 91.128C108.413 91.128 107.96 91.0053 107.555 90.76C107.16 90.504 106.877 90.2107 106.707 89.88V90.44C106.707 90.5787 106.632 90.7067 106.483 90.824C106.333 90.9413 106.152 91 105.939 91C105.704 91 105.507 90.9413 105.347 90.824C105.197 90.7067 105.123 90.5787 105.123 90.44V79.448C105.123 79.288 105.197 79.16 105.347 79.064C105.507 78.9573 105.704 78.904 105.939 78.904C106.184 78.904 106.387 78.9573 106.547 79.064C106.717 79.16 106.803 79.288 106.803 79.448V84.536C106.973 84.2267 107.235 83.9493 107.587 83.704C107.939 83.448 108.365 83.32 108.867 83.32C109.389 83.32 109.864 83.464 110.291 83.752C110.728 84.0293 111.075 84.408 111.331 84.888C111.597 85.3573 111.731 85.8853 111.731 86.472V87.944C111.731 88.4987 111.597 89.0213 111.331 89.512C111.075 89.992 110.733 90.3813 110.307 90.68C109.88 90.9787 109.416 91.128 108.915 91.128ZM108.435 89.64C108.723 89.64 108.989 89.56 109.235 89.4C109.48 89.24 109.677 89.0267 109.827 88.76C109.976 88.4933 110.051 88.2213 110.051 87.944V86.472C110.051 86.1947 109.976 85.928 109.827 85.672C109.677 85.416 109.48 85.208 109.235 85.048C108.989 84.888 108.717 84.808 108.419 84.808C108.152 84.808 107.896 84.8773 107.651 85.016C107.405 85.144 107.203 85.3307 107.043 85.576C106.883 85.8213 106.803 86.12 106.803 86.472V88.312C106.803 88.44 106.872 88.6107 107.011 88.824C107.16 89.0267 107.357 89.2133 107.603 89.384C107.848 89.5547 108.125 89.64 108.435 89.64ZM116.624 91.128C115.899 91.128 115.259 90.9947 114.704 90.728C114.15 90.4613 113.712 90.0933 113.392 89.624C113.072 89.144 112.912 88.584 112.912 87.944V86.424C112.912 85.8587 113.062 85.3413 113.36 84.872C113.67 84.4027 114.075 84.0293 114.576 83.752C115.078 83.464 115.632 83.32 116.24 83.32C116.816 83.32 117.344 83.448 117.824 83.704C118.304 83.9493 118.688 84.296 118.976 84.744C119.275 85.192 119.424 85.704 119.424 86.28C119.424 86.728 119.355 87.048 119.216 87.24C119.078 87.432 118.896 87.5493 118.672 87.592C118.448 87.6347 118.214 87.656 117.968 87.656H114.592V88.024C114.592 88.5573 114.784 88.984 115.168 89.304C115.563 89.6133 116.064 89.768 116.672 89.768C117.046 89.768 117.35 89.7147 117.584 89.608C117.819 89.5013 118.016 89.4 118.176 89.304C118.336 89.208 118.486 89.16 118.624 89.16C118.763 89.16 118.88 89.2027 118.976 89.288C119.072 89.3733 119.147 89.4747 119.2 89.592C119.254 89.7093 119.28 89.816 119.28 89.912C119.28 90.072 119.168 90.248 118.944 90.44C118.731 90.632 118.427 90.7973 118.032 90.936C117.638 91.064 117.168 91.128 116.624 91.128ZM114.592 86.616H117.248C117.483 86.616 117.638 86.584 117.712 86.52C117.798 86.456 117.84 86.328 117.84 86.136C117.84 85.8587 117.771 85.6027 117.632 85.368C117.494 85.1227 117.302 84.936 117.056 84.808C116.811 84.6693 116.534 84.6 116.224 84.6C115.926 84.6 115.654 84.664 115.408 84.792C115.163 84.92 114.966 85.096 114.816 85.32C114.667 85.544 114.592 85.8053 114.592 86.104V86.616ZM121.626 91C121.391 91 121.194 90.952 121.034 90.856C120.885 90.7493 120.81 90.616 120.81 90.456V81.96C120.81 81.384 120.938 80.8667 121.194 80.408C121.45 79.9387 121.791 79.5707 122.218 79.304C122.645 79.0373 123.114 78.904 123.626 78.904H124.378C124.591 78.904 124.751 78.9787 124.858 79.128C124.975 79.2773 125.034 79.4427 125.034 79.624C125.034 79.816 124.975 79.9867 124.858 80.136C124.751 80.2747 124.591 80.344 124.378 80.344H123.946C123.669 80.344 123.418 80.408 123.194 80.536C122.981 80.664 122.81 80.84 122.682 81.064C122.554 81.2773 122.49 81.5227 122.49 81.8V83.416H124.554C124.714 83.416 124.831 83.48 124.906 83.608C124.991 83.736 125.034 83.88 125.034 84.04C125.034 84.2 124.991 84.344 124.906 84.472C124.831 84.6 124.714 84.664 124.554 84.664H122.49V90.456C122.49 90.616 122.405 90.7493 122.234 90.856C122.063 90.952 121.861 91 121.626 91ZM128.786 91.128C128.21 91.128 127.671 90.9787 127.17 90.68C126.669 90.3813 126.263 89.992 125.954 89.512C125.655 89.0213 125.506 88.4987 125.506 87.944V86.472C125.506 85.9067 125.65 85.384 125.938 84.904C126.237 84.424 126.637 84.04 127.138 83.752C127.65 83.464 128.205 83.32 128.802 83.32C129.399 83.32 129.949 83.464 130.45 83.752C130.951 84.0293 131.351 84.408 131.65 84.888C131.959 85.3573 132.114 85.8853 132.114 86.472V87.944C132.114 88.488 131.959 89.0053 131.65 89.496C131.351 89.9867 130.946 90.3813 130.434 90.68C129.933 90.9787 129.383 91.128 128.786 91.128ZM128.802 89.64C129.101 89.64 129.373 89.56 129.618 89.4C129.863 89.24 130.061 89.032 130.21 88.776C130.359 88.5093 130.434 88.232 130.434 87.944V86.472C130.434 86.1947 130.359 85.928 130.21 85.672C130.061 85.416 129.863 85.208 129.618 85.048C129.373 84.888 129.101 84.808 128.802 84.808C128.493 84.808 128.215 84.888 127.97 85.048C127.735 85.208 127.543 85.416 127.394 85.672C127.255 85.928 127.186 86.1947 127.186 86.472V87.944C127.186 88.232 127.255 88.5093 127.394 88.776C127.543 89.032 127.741 89.24 127.986 89.4C128.231 89.56 128.503 89.64 128.802 89.64ZM134.391 91C134.157 91 133.959 90.9413 133.799 90.824C133.65 90.7067 133.575 90.5787 133.575 90.44V83.96C133.575 83.8 133.65 83.672 133.799 83.576C133.959 83.4693 134.157 83.416 134.391 83.416C134.605 83.416 134.786 83.4693 134.935 83.576C135.085 83.672 135.159 83.8 135.159 83.96V84.664C135.277 84.44 135.431 84.2267 135.623 84.024C135.826 83.8213 136.061 83.656 136.327 83.528C136.594 83.3893 136.882 83.32 137.191 83.32H137.703C137.874 83.32 138.023 83.3947 138.151 83.544C138.279 83.6827 138.343 83.8533 138.343 84.056C138.343 84.2587 138.279 84.4347 138.151 84.584C138.023 84.7333 137.874 84.808 137.703 84.808H137.191C136.871 84.808 136.562 84.904 136.263 85.096C135.965 85.288 135.719 85.56 135.527 85.912C135.346 86.2533 135.255 86.6693 135.255 87.16V90.44C135.255 90.5787 135.17 90.7067 134.999 90.824C134.839 90.9413 134.637 91 134.391 91ZM142.484 91.128C141.758 91.128 141.118 90.9947 140.564 90.728C140.009 90.4613 139.572 90.0933 139.252 89.624C138.932 89.144 138.772 88.584 138.772 87.944V86.424C138.772 85.8587 138.921 85.3413 139.22 84.872C139.529 84.4027 139.934 84.0293 140.436 83.752C140.937 83.464 141.492 83.32 142.1 83.32C142.676 83.32 143.204 83.448 143.684 83.704C144.164 83.9493 144.548 84.296 144.836 84.744C145.134 85.192 145.284 85.704 145.284 86.28C145.284 86.728 145.214 87.048 145.076 87.24C144.937 87.432 144.756 87.5493 144.532 87.592C144.308 87.6347 144.073 87.656 143.828 87.656H140.452V88.024C140.452 88.5573 140.644 88.984 141.028 89.304C141.422 89.6133 141.924 89.768 142.532 89.768C142.905 89.768 143.209 89.7147 143.444 89.608C143.678 89.5013 143.876 89.4 144.036 89.304C144.196 89.208 144.345 89.16 144.484 89.16C144.622 89.16 144.74 89.2027 144.836 89.288C144.932 89.3733 145.006 89.4747 145.06 89.592C145.113 89.7093 145.14 89.816 145.14 89.912C145.14 90.072 145.028 90.248 144.804 90.44C144.59 90.632 144.286 90.7973 143.892 90.936C143.497 91.064 143.028 91.128 142.484 91.128ZM140.452 86.616H143.108C143.342 86.616 143.497 86.584 143.572 86.52C143.657 86.456 143.7 86.328 143.7 86.136C143.7 85.8587 143.63 85.6027 143.492 85.368C143.353 85.1227 143.161 84.936 142.916 84.808C142.67 84.6693 142.393 84.6 142.084 84.6C141.785 84.6 141.513 84.664 141.268 84.792C141.022 84.92 140.825 85.096 140.676 85.32C140.526 85.544 140.452 85.8053 140.452 86.104V86.616ZM150.673 91C150.438 91 150.241 90.9413 150.081 90.824C149.931 90.7067 149.857 90.5787 149.857 90.44V83.96C149.857 83.8 149.931 83.672 150.081 83.576C150.241 83.4693 150.438 83.416 150.673 83.416C150.886 83.416 151.067 83.4693 151.217 83.576C151.366 83.672 151.441 83.8 151.441 83.96V84.664C151.558 84.44 151.713 84.2267 151.905 84.024C152.107 83.8213 152.342 83.656 152.609 83.528C152.875 83.3893 153.163 83.32 153.473 83.32H153.985C154.155 83.32 154.305 83.3947 154.433 83.544C154.561 83.6827 154.625 83.8533 154.625 84.056C154.625 84.2587 154.561 84.4347 154.433 84.584C154.305 84.7333 154.155 84.808 153.985 84.808H153.473C153.153 84.808 152.843 84.904 152.545 85.096C152.246 85.288 152.001 85.56 151.809 85.912C151.627 86.2533 151.537 86.6693 151.537 87.16V90.44C151.537 90.5787 151.451 90.7067 151.281 90.824C151.121 90.9413 150.918 91 150.673 91ZM158.765 91.128C158.04 91.128 157.4 90.9947 156.845 90.728C156.29 90.4613 155.853 90.0933 155.533 89.624C155.213 89.144 155.053 88.584 155.053 87.944V86.424C155.053 85.8587 155.202 85.3413 155.501 84.872C155.81 84.4027 156.216 84.0293 156.717 83.752C157.218 83.464 157.773 83.32 158.381 83.32C158.957 83.32 159.485 83.448 159.965 83.704C160.445 83.9493 160.829 84.296 161.117 84.744C161.416 85.192 161.565 85.704 161.565 86.28C161.565 86.728 161.496 87.048 161.357 87.24C161.218 87.432 161.037 87.5493 160.813 87.592C160.589 87.6347 160.354 87.656 160.109 87.656H156.733V88.024C156.733 88.5573 156.925 88.984 157.309 89.304C157.704 89.6133 158.205 89.768 158.813 89.768C159.186 89.768 159.49 89.7147 159.725 89.608C159.96 89.5013 160.157 89.4 160.317 89.304C160.477 89.208 160.626 89.16 160.765 89.16C160.904 89.16 161.021 89.2027 161.117 89.288C161.213 89.3733 161.288 89.4747 161.341 89.592C161.394 89.7093 161.421 89.816 161.421 89.912C161.421 90.072 161.309 90.248 161.085 90.44C160.872 90.632 160.568 90.7973 160.173 90.936C159.778 91.064 159.309 91.128 158.765 91.128ZM156.733 86.616H159.389C159.624 86.616 159.778 86.584 159.853 86.52C159.938 86.456 159.981 86.328 159.981 86.136C159.981 85.8587 159.912 85.6027 159.773 85.368C159.634 85.1227 159.442 84.936 159.197 84.808C158.952 84.6693 158.674 84.6 158.365 84.6C158.066 84.6 157.794 84.664 157.549 84.792C157.304 84.92 157.106 85.096 156.957 85.32C156.808 85.544 156.733 85.8053 156.733 86.104V86.616ZM166.007 91.128C165.239 91.128 164.604 90.9893 164.103 90.712C163.612 90.4347 163.249 90.056 163.015 89.576C162.78 89.096 162.663 88.552 162.663 87.944V86.504C162.663 85.9067 162.78 85.368 163.015 84.888C163.249 84.3973 163.612 84.0133 164.103 83.736C164.593 83.4587 165.217 83.32 165.975 83.32C166.465 83.32 166.892 83.3787 167.255 83.496C167.628 83.6133 167.916 83.7627 168.119 83.944C168.332 84.1147 168.439 84.296 168.439 84.488C168.439 84.584 168.407 84.7013 168.343 84.84C168.289 84.968 168.209 85.08 168.103 85.176C168.007 85.2613 167.889 85.304 167.751 85.304C167.644 85.304 167.527 85.2613 167.399 85.176C167.281 85.0907 167.121 85.0107 166.919 84.936C166.716 84.8507 166.444 84.808 166.103 84.808C165.505 84.808 165.063 84.9573 164.775 85.256C164.487 85.5547 164.343 85.9707 164.343 86.504V87.944C164.343 88.4773 164.487 88.8933 164.775 89.192C165.063 89.4907 165.511 89.64 166.119 89.64C166.471 89.64 166.748 89.5973 166.951 89.512C167.153 89.416 167.313 89.3253 167.431 89.24C167.559 89.1547 167.681 89.112 167.799 89.112C167.948 89.112 168.076 89.1547 168.183 89.24C168.3 89.3253 168.385 89.432 168.439 89.56C168.503 89.688 168.535 89.8053 168.535 89.912C168.535 90.0933 168.423 90.28 168.199 90.472C167.985 90.664 167.687 90.824 167.303 90.952C166.929 91.0693 166.497 91.128 166.007 91.128ZM169.764 94.6C169.55 94.6 169.369 94.552 169.22 94.456C169.07 94.3707 168.996 94.1787 168.996 93.88C168.996 93.688 169.028 93.5173 169.092 93.368C169.156 93.2293 169.273 93.16 169.444 93.16C169.646 93.16 169.865 93.1067 170.1 93C170.345 92.904 170.58 92.744 170.804 92.52C171.038 92.3067 171.236 92.0347 171.396 91.704C171.566 91.3733 171.684 90.984 171.748 90.536L169.044 84.328C169.001 84.2533 168.98 84.1787 168.98 84.104C168.98 83.9653 169.038 83.8373 169.156 83.72C169.284 83.592 169.433 83.4907 169.604 83.416C169.774 83.3413 169.934 83.304 170.084 83.304C170.19 83.304 170.292 83.3307 170.388 83.384C170.494 83.4267 170.564 83.5013 170.596 83.608L172.612 88.808L174.356 83.608C174.388 83.5013 174.452 83.4267 174.548 83.384C174.644 83.3307 174.74 83.304 174.836 83.304C174.964 83.304 175.113 83.3413 175.284 83.416C175.465 83.4907 175.62 83.592 175.748 83.72C175.886 83.8373 175.956 83.976 175.956 84.136C175.956 84.2213 175.94 84.2853 175.908 84.328L173.508 90.584C173.337 91.0427 173.161 91.5067 172.98 91.976C172.798 92.456 172.574 92.8933 172.308 93.288C172.052 93.6827 171.716 93.9973 171.3 94.232C170.894 94.4773 170.382 94.6 169.764 94.6ZM180.069 91.128C179.301 91.128 178.667 90.9893 178.165 90.712C177.675 90.4347 177.312 90.056 177.077 89.576C176.843 89.096 176.725 88.552 176.725 87.944V86.504C176.725 85.9067 176.843 85.368 177.077 84.888C177.312 84.3973 177.675 84.0133 178.165 83.736C178.656 83.4587 179.28 83.32 180.037 83.32C180.528 83.32 180.955 83.3787 181.317 83.496C181.691 83.6133 181.979 83.7627 182.181 83.944C182.395 84.1147 182.501 84.296 182.501 84.488C182.501 84.584 182.469 84.7013 182.405 84.84C182.352 84.968 182.272 85.08 182.165 85.176C182.069 85.2613 181.952 85.304 181.813 85.304C181.707 85.304 181.589 85.2613 181.461 85.176C181.344 85.0907 181.184 85.0107 180.981 84.936C180.779 84.8507 180.507 84.808 180.165 84.808C179.568 84.808 179.125 84.9573 178.837 85.256C178.549 85.5547 178.405 85.9707 178.405 86.504V87.944C178.405 88.4773 178.549 88.8933 178.837 89.192C179.125 89.4907 179.573 89.64 180.181 89.64C180.533 89.64 180.811 89.5973 181.013 89.512C181.216 89.416 181.376 89.3253 181.493 89.24C181.621 89.1547 181.744 89.112 181.861 89.112C182.011 89.112 182.139 89.1547 182.245 89.24C182.363 89.3253 182.448 89.432 182.501 89.56C182.565 89.688 182.597 89.8053 182.597 89.912C182.597 90.0933 182.485 90.28 182.261 90.472C182.048 90.664 181.749 90.824 181.365 90.952C180.992 91.0693 180.56 91.128 180.069 91.128ZM184.77 91C184.525 91 184.322 90.9413 184.162 90.824C184.013 90.7067 183.938 90.5787 183.938 90.44V79.448C183.938 79.288 184.013 79.16 184.162 79.064C184.322 78.9573 184.525 78.904 184.77 78.904C185.005 78.904 185.202 78.9573 185.362 79.064C185.533 79.16 185.618 79.288 185.618 79.448V90.44C185.618 90.5787 185.533 90.7067 185.362 90.824C185.202 90.9413 185.005 91 184.77 91ZM188.345 81.512C188.078 81.512 187.849 81.4213 187.657 81.24C187.465 81.0587 187.369 80.856 187.369 80.632C187.369 80.3867 187.465 80.1787 187.657 80.008C187.849 79.8373 188.078 79.752 188.345 79.752C188.611 79.752 188.835 79.8373 189.017 80.008C189.209 80.1787 189.305 80.3867 189.305 80.632C189.305 80.856 189.209 81.0587 189.017 81.24C188.835 81.4213 188.611 81.512 188.345 81.512ZM188.345 91C188.099 91 187.897 90.9413 187.737 90.824C187.587 90.7067 187.513 90.5787 187.513 90.44V83.96C187.513 83.8 187.587 83.672 187.737 83.576C187.897 83.4693 188.099 83.416 188.345 83.416C188.579 83.416 188.777 83.4693 188.937 83.576C189.107 83.672 189.193 83.8 189.193 83.96V90.44C189.193 90.5787 189.107 90.7067 188.937 90.824C188.777 90.9413 188.579 91 188.345 91ZM191.767 91C191.521 91 191.319 90.9413 191.159 90.824C191.009 90.7067 190.935 90.5787 190.935 90.44V83.96C190.935 83.8 191.009 83.672 191.159 83.576C191.319 83.4693 191.521 83.416 191.767 83.416C191.969 83.416 192.145 83.4693 192.295 83.576C192.444 83.672 192.519 83.8 192.519 83.96V84.536C192.679 84.2267 192.94 83.9493 193.303 83.704C193.676 83.448 194.129 83.32 194.663 83.32C195.164 83.32 195.623 83.464 196.039 83.752C196.465 84.0293 196.807 84.408 197.063 84.888C197.319 85.3573 197.447 85.8853 197.447 86.472V90.44C197.447 90.6213 197.356 90.76 197.175 90.856C197.004 90.952 196.812 91 196.599 91C196.407 91 196.22 90.952 196.039 90.856C195.857 90.76 195.767 90.6213 195.767 90.44V86.472C195.767 86.1947 195.692 85.928 195.543 85.672C195.404 85.416 195.212 85.208 194.967 85.048C194.721 84.888 194.449 84.808 194.151 84.808C193.895 84.808 193.649 84.8773 193.415 85.016C193.18 85.144 192.988 85.3307 192.839 85.576C192.689 85.8213 192.615 86.12 192.615 86.472V90.44C192.615 90.5787 192.529 90.7067 192.359 90.824C192.199 90.9413 192.001 91 191.767 91ZM201.986 94.6C201.368 94.6 200.797 94.5093 200.274 94.328C199.752 94.1573 199.336 93.9067 199.026 93.576C198.717 93.2453 198.562 92.8507 198.562 92.392C198.562 91.9653 198.685 91.608 198.93 91.32C199.176 91.0427 199.464 90.8293 199.794 90.68C199.581 90.584 199.405 90.456 199.266 90.296C199.128 90.136 199.058 89.912 199.058 89.624C199.058 89.3253 199.133 89.0853 199.282 88.904C199.432 88.7227 199.624 88.5573 199.858 88.408C199.56 88.1733 199.325 87.8853 199.154 87.544C198.994 87.192 198.914 86.808 198.914 86.392V85.944C198.914 85.432 199.037 84.9787 199.282 84.584C199.528 84.1893 199.874 83.88 200.322 83.656C200.781 83.432 201.304 83.32 201.89 83.32C202.253 83.32 202.589 83.368 202.898 83.464C203.218 83.56 203.501 83.6933 203.746 83.864C203.917 83.4693 204.088 83.192 204.258 83.032C204.44 82.872 204.61 82.792 204.77 82.792C204.994 82.792 205.165 82.856 205.282 82.984C205.4 83.112 205.458 83.24 205.458 83.368C205.458 83.4533 205.432 83.5333 205.378 83.608C205.336 83.672 205.272 83.7253 205.186 83.768C205.08 83.8213 204.952 83.896 204.802 83.992C204.664 84.0773 204.525 84.216 204.386 84.408C204.568 84.6107 204.701 84.8453 204.786 85.112C204.872 85.3787 204.914 85.656 204.914 85.944V86.392C204.914 86.8933 204.786 87.3467 204.53 87.752C204.274 88.1573 203.917 88.4773 203.458 88.712C203 88.936 202.477 89.048 201.89 89.048C201.474 89.048 201.106 88.984 200.786 88.856C200.701 88.9093 200.626 88.9733 200.562 89.048C200.509 89.112 200.482 89.1973 200.482 89.304C200.482 89.496 200.6 89.6347 200.834 89.72C201.069 89.8053 201.368 89.8693 201.73 89.912C202.104 89.9547 202.498 90.008 202.914 90.072C203.33 90.136 203.72 90.2427 204.082 90.392C204.456 90.5307 204.76 90.7387 204.994 91.016C205.229 91.304 205.346 91.6933 205.346 92.184C205.346 92.7387 205.192 93.192 204.882 93.544C204.573 93.9067 204.162 94.1733 203.65 94.344C203.149 94.5147 202.594 94.6 201.986 94.6ZM201.954 93.48C202.477 93.48 202.898 93.3627 203.218 93.128C203.549 92.904 203.714 92.6053 203.714 92.232C203.714 91.9653 203.634 91.7573 203.474 91.608C203.314 91.4587 203.106 91.3467 202.85 91.272C202.594 91.1973 202.322 91.144 202.034 91.112C201.757 91.08 201.49 91.048 201.234 91.016C200.936 91.1227 200.68 91.272 200.466 91.464C200.264 91.6667 200.162 91.9173 200.162 92.216C200.162 92.6107 200.328 92.92 200.658 93.144C201 93.368 201.432 93.48 201.954 93.48ZM201.922 87.976C202.349 87.976 202.68 87.8267 202.914 87.528C203.16 87.2293 203.282 86.8507 203.282 86.392V85.944C203.282 85.5067 203.16 85.1387 202.914 84.84C202.68 84.5413 202.344 84.392 201.906 84.392C201.469 84.392 201.133 84.5413 200.898 84.84C200.664 85.1387 200.546 85.5067 200.546 85.944V86.376C200.546 86.824 200.664 87.2027 200.898 87.512C201.133 87.8213 201.474 87.976 201.922 87.976ZM207.058 91.096C206.781 91.096 206.551 91 206.37 90.808C206.189 90.616 206.098 90.392 206.098 90.136C206.098 89.8693 206.189 89.6453 206.37 89.464C206.551 89.272 206.781 89.176 207.058 89.176C207.314 89.176 207.533 89.272 207.714 89.464C207.906 89.6453 208.002 89.8693 208.002 90.136C208.002 90.392 207.906 90.616 207.714 90.808C207.533 91 207.314 91.096 207.058 91.096ZM65.4486 111C65.2246 111 65.0433 110.947 64.9046 110.84C64.766 110.733 64.6966 110.605 64.6966 110.456V99.848C64.6966 99.6987 64.766 99.5707 64.9046 99.464C65.0433 99.3573 65.2246 99.304 65.4486 99.304H68.2806C68.9526 99.304 69.5606 99.4213 70.1046 99.656C70.6593 99.8907 71.0913 100.269 71.4006 100.792C71.7206 101.315 71.8806 102.008 71.8806 102.872V107.432C71.8806 108.296 71.7206 108.989 71.4006 109.512C71.0913 110.035 70.6593 110.413 70.1046 110.648C69.5606 110.883 68.9526 111 68.2806 111H65.4486ZM66.3926 109.496H68.2806C68.878 109.496 69.342 109.331 69.6726 109C70.014 108.659 70.1846 108.136 70.1846 107.432V102.872C70.1846 102.168 70.014 101.651 69.6726 101.32C69.342 100.979 68.878 100.808 68.2806 100.808H66.3926V109.496ZM74.4933 101.512C74.2266 101.512 73.9973 101.421 73.8053 101.24C73.6133 101.059 73.5173 100.856 73.5173 100.632C73.5173 100.387 73.6133 100.179 73.8053 100.008C73.9973 99.8373 74.2266 99.752 74.4933 99.752C74.7599 99.752 74.9839 99.8373 75.1653 100.008C75.3573 100.179 75.4533 100.387 75.4533 100.632C75.4533 100.856 75.3573 101.059 75.1653 101.24C74.9839 101.421 74.7599 101.512 74.4933 101.512ZM74.4933 111C74.2479 111 74.0453 110.941 73.8853 110.824C73.7359 110.707 73.6613 110.579 73.6613 110.44V103.96C73.6613 103.8 73.7359 103.672 73.8853 103.576C74.0453 103.469 74.2479 103.416 74.4933 103.416C74.7279 103.416 74.9253 103.469 75.0853 103.576C75.2559 103.672 75.3413 103.8 75.3413 103.96V110.44C75.3413 110.579 75.2559 110.707 75.0853 110.824C74.9253 110.941 74.7279 111 74.4933 111ZM79.4031 111.128C78.8805 111.128 78.4111 111.064 77.9951 110.936C77.5791 110.808 77.2485 110.648 77.0031 110.456C76.7685 110.253 76.6511 110.051 76.6511 109.848C76.6511 109.752 76.6725 109.645 76.7151 109.528C76.7685 109.411 76.8378 109.309 76.9231 109.224C77.0191 109.139 77.1205 109.096 77.2271 109.096C77.3658 109.096 77.5098 109.16 77.6591 109.288C77.8191 109.405 78.0271 109.528 78.2831 109.656C78.5391 109.773 78.8965 109.832 79.3551 109.832C79.8885 109.832 80.2458 109.741 80.4271 109.56C80.6191 109.379 80.7151 109.181 80.7151 108.968C80.7151 108.691 80.6191 108.477 80.4271 108.328C80.2458 108.168 80.0058 108.04 79.7071 107.944C79.4191 107.848 79.1098 107.757 78.7791 107.672C78.4485 107.576 78.1338 107.453 77.8351 107.304C77.5471 107.155 77.3071 106.947 77.1151 106.68C76.9338 106.413 76.8431 106.061 76.8431 105.624C76.8431 105.261 76.9338 104.904 77.1151 104.552C77.2965 104.189 77.5845 103.896 77.9791 103.672C78.3845 103.437 78.9231 103.32 79.5951 103.32C80.0005 103.32 80.3845 103.363 80.7471 103.448C81.1098 103.533 81.4085 103.651 81.6431 103.8C81.8778 103.939 81.9951 104.093 81.9951 104.264C81.9951 104.339 81.9685 104.445 81.9151 104.584C81.8618 104.712 81.7871 104.829 81.6911 104.936C81.6058 105.032 81.4938 105.08 81.3551 105.08C81.2485 105.08 81.1151 105.043 80.9551 104.968C80.7951 104.883 80.6085 104.803 80.3951 104.728C80.1818 104.653 79.9205 104.616 79.6111 104.616C79.3018 104.616 79.0511 104.669 78.8591 104.776C78.6778 104.872 78.5445 104.989 78.4591 105.128C78.3738 105.267 78.3311 105.405 78.3311 105.544C78.3311 105.779 78.4218 105.96 78.6031 106.088C78.7845 106.216 79.0245 106.323 79.3231 106.408C79.6218 106.493 79.9365 106.584 80.2671 106.68C80.5978 106.765 80.9071 106.893 81.1951 107.064C81.4938 107.235 81.7338 107.464 81.9151 107.752C82.1071 108.04 82.2031 108.424 82.2031 108.904C82.2031 109.576 81.9578 110.115 81.4671 110.52C80.9871 110.925 80.2991 111.128 79.4031 111.128ZM86.6551 111.128C85.8871 111.128 85.2525 110.989 84.7511 110.712C84.2605 110.435 83.8978 110.056 83.6631 109.576C83.4285 109.096 83.3111 108.552 83.3111 107.944V106.504C83.3111 105.907 83.4285 105.368 83.6631 104.888C83.8978 104.397 84.2605 104.013 84.7511 103.736C85.2418 103.459 85.8658 103.32 86.6231 103.32C87.1138 103.32 87.5405 103.379 87.9031 103.496C88.2765 103.613 88.5645 103.763 88.7671 103.944C88.9805 104.115 89.0871 104.296 89.0871 104.488C89.0871 104.584 89.0551 104.701 88.9911 104.84C88.9378 104.968 88.8578 105.08 88.7511 105.176C88.6551 105.261 88.5378 105.304 88.3991 105.304C88.2925 105.304 88.1751 105.261 88.0471 105.176C87.9298 105.091 87.7698 105.011 87.5671 104.936C87.3645 104.851 87.0925 104.808 86.7511 104.808C86.1538 104.808 85.7111 104.957 85.4231 105.256C85.1351 105.555 84.9911 105.971 84.9911 106.504V107.944C84.9911 108.477 85.1351 108.893 85.4231 109.192C85.7111 109.491 86.1591 109.64 86.7671 109.64C87.1191 109.64 87.3965 109.597 87.5991 109.512C87.8018 109.416 87.9618 109.325 88.0791 109.24C88.2071 109.155 88.3298 109.112 88.4471 109.112C88.5965 109.112 88.7245 109.155 88.8311 109.24C88.9485 109.325 89.0338 109.432 89.0871 109.56C89.1511 109.688 89.1831 109.805 89.1831 109.912C89.1831 110.093 89.0711 110.28 88.8471 110.472C88.6338 110.664 88.3351 110.824 87.9511 110.952C87.5778 111.069 87.1458 111.128 86.6551 111.128ZM92.028 111.128C91.4413 111.128 90.94 110.957 90.524 110.616C90.108 110.264 89.9 109.731 89.9 109.016C89.9 108.408 90.06 107.939 90.38 107.608C90.7 107.277 91.1373 107.048 91.692 106.92C92.2573 106.792 92.908 106.728 93.644 106.728H94.348V106.44C94.348 106.163 94.2947 105.896 94.188 105.64C94.092 105.373 93.9267 105.155 93.692 104.984C93.468 104.803 93.1587 104.712 92.764 104.712C92.3693 104.712 92.0653 104.749 91.852 104.824C91.6387 104.899 91.468 104.979 91.34 105.064C91.212 105.149 91.0947 105.192 90.988 105.192C90.796 105.192 90.6467 105.101 90.54 104.92C90.4333 104.728 90.38 104.536 90.38 104.344C90.38 104.152 90.5027 103.981 90.748 103.832C91.004 103.672 91.3187 103.549 91.692 103.464C92.0653 103.368 92.4333 103.32 92.796 103.32C93.5853 103.32 94.2147 103.469 94.684 103.768C95.1533 104.056 95.4947 104.435 95.708 104.904C95.9213 105.373 96.028 105.88 96.028 106.424V110.44C96.028 110.589 95.948 110.723 95.788 110.84C95.6387 110.947 95.4467 111 95.212 111C94.9987 111 94.8173 110.947 94.668 110.84C94.5187 110.723 94.444 110.589 94.444 110.44V109.88C94.1667 110.2 93.8307 110.488 93.436 110.744C93.0413 111 92.572 111.128 92.028 111.128ZM92.636 109.848C92.9027 109.848 93.164 109.768 93.42 109.608C93.6867 109.448 93.9053 109.245 94.076 109C94.2573 108.755 94.348 108.504 94.348 108.248V107.656H93.948C93.5427 107.656 93.1587 107.683 92.796 107.736C92.4333 107.779 92.14 107.885 91.916 108.056C91.7027 108.216 91.596 108.467 91.596 108.808C91.596 109.171 91.692 109.437 91.884 109.608C92.0867 109.768 92.3373 109.848 92.636 109.848ZM98.5398 111C98.3051 111 98.1078 110.941 97.9478 110.824C97.7984 110.707 97.7238 110.579 97.7238 110.44V103.96C97.7238 103.8 97.7984 103.672 97.9478 103.576C98.1078 103.469 98.3051 103.416 98.5398 103.416C98.7531 103.416 98.9344 103.469 99.0838 103.576C99.2331 103.672 99.3078 103.8 99.3078 103.96V104.664C99.4251 104.44 99.5798 104.227 99.7718 104.024C99.9744 103.821 100.209 103.656 100.476 103.528C100.742 103.389 101.03 103.32 101.34 103.32H101.852C102.022 103.32 102.172 103.395 102.3 103.544C102.428 103.683 102.492 103.853 102.492 104.056C102.492 104.259 102.428 104.435 102.3 104.584C102.172 104.733 102.022 104.808 101.852 104.808H101.34C101.02 104.808 100.71 104.904 100.412 105.096C100.113 105.288 99.8678 105.56 99.6758 105.912C99.4944 106.253 99.4038 106.669 99.4038 107.16V110.44C99.4038 110.579 99.3184 110.707 99.1478 110.824C98.9878 110.941 98.7851 111 98.5398 111ZM105.736 111.128C105.235 111.128 104.771 110.979 104.344 110.68C103.917 110.381 103.571 109.992 103.304 109.512C103.048 109.021 102.92 108.499 102.92 107.944V106.472C102.92 105.885 103.048 105.357 103.304 104.888C103.571 104.408 103.917 104.029 104.344 103.752C104.771 103.464 105.245 103.32 105.768 103.32C106.28 103.32 106.712 103.448 107.064 103.704C107.416 103.949 107.677 104.227 107.848 104.536V99.448C107.848 99.288 107.933 99.16 108.104 99.064C108.275 98.9573 108.477 98.904 108.712 98.904C108.947 98.904 109.139 98.9573 109.288 99.064C109.448 99.16 109.528 99.288 109.528 99.448V110.44C109.528 110.579 109.448 110.707 109.288 110.824C109.139 110.941 108.947 111 108.712 111C108.509 111 108.328 110.941 108.168 110.824C108.019 110.707 107.944 110.579 107.944 110.44V109.88C107.784 110.211 107.501 110.504 107.096 110.76C106.691 111.005 106.237 111.128 105.736 111.128ZM106.216 109.64C106.525 109.64 106.803 109.555 107.048 109.384C107.293 109.213 107.485 109.027 107.624 108.824C107.773 108.611 107.848 108.44 107.848 108.312V106.472C107.848 106.12 107.768 105.821 107.608 105.576C107.448 105.331 107.245 105.144 107 105.016C106.755 104.877 106.499 104.808 106.232 104.808C105.933 104.808 105.656 104.888 105.4 105.048C105.155 105.208 104.957 105.416 104.808 105.672C104.669 105.928 104.6 106.195 104.6 106.472V107.944C104.6 108.221 104.669 108.493 104.808 108.76C104.957 109.027 105.155 109.24 105.4 109.4C105.645 109.56 105.917 109.64 106.216 109.64ZM117.273 111C116.366 111 115.673 110.803 115.193 110.408C114.713 110.003 114.473 109.368 114.473 108.504V100.488C114.473 100.328 114.558 100.2 114.729 100.104C114.91 99.9973 115.102 99.944 115.305 99.944C115.508 99.944 115.7 99.9973 115.881 100.104C116.062 100.2 116.153 100.328 116.153 100.488V103.416H118.105C118.254 103.416 118.366 103.48 118.441 103.608C118.526 103.736 118.569 103.88 118.569 104.04C118.569 104.2 118.526 104.344 118.441 104.472C118.366 104.6 118.254 104.664 118.105 104.664H116.153V108.504C116.153 108.888 116.233 109.16 116.393 109.32C116.564 109.48 116.857 109.56 117.273 109.56H117.817C118.062 109.56 118.244 109.635 118.361 109.784C118.489 109.923 118.553 110.088 118.553 110.28C118.553 110.461 118.489 110.627 118.361 110.776C118.244 110.925 118.062 111 117.817 111H117.273ZM120.572 111C120.326 111 120.124 110.941 119.964 110.824C119.814 110.707 119.74 110.579 119.74 110.44V99.448C119.74 99.288 119.814 99.16 119.964 99.064C120.124 98.9573 120.326 98.904 120.572 98.904C120.806 98.904 121.004 98.9573 121.164 99.064C121.334 99.16 121.42 99.288 121.42 99.448V104.536C121.58 104.227 121.83 103.949 122.172 103.704C122.524 103.448 122.956 103.32 123.468 103.32C123.969 103.32 124.428 103.464 124.844 103.752C125.27 104.029 125.612 104.408 125.868 104.888C126.124 105.357 126.252 105.885 126.252 106.472V110.44C126.252 110.621 126.161 110.76 125.98 110.856C125.809 110.952 125.617 111 125.404 111C125.212 111 125.025 110.952 124.844 110.856C124.662 110.76 124.572 110.621 124.572 110.44V106.472C124.572 106.195 124.497 105.928 124.348 105.672C124.198 105.416 124.001 105.208 123.756 105.048C123.521 104.888 123.254 104.808 122.956 104.808C122.7 104.808 122.454 104.877 122.22 105.016C121.985 105.144 121.793 105.331 121.644 105.576C121.494 105.821 121.42 106.12 121.42 106.472V110.44C121.42 110.579 121.334 110.707 121.164 110.824C121.004 110.941 120.806 111 120.572 111ZM131.351 111.128C130.626 111.128 129.986 110.995 129.431 110.728C128.876 110.461 128.439 110.093 128.119 109.624C127.799 109.144 127.639 108.584 127.639 107.944V106.424C127.639 105.859 127.788 105.341 128.087 104.872C128.396 104.403 128.802 104.029 129.303 103.752C129.804 103.464 130.359 103.32 130.967 103.32C131.543 103.32 132.071 103.448 132.551 103.704C133.031 103.949 133.415 104.296 133.703 104.744C134.002 105.192 134.151 105.704 134.151 106.28C134.151 106.728 134.082 107.048 133.943 107.24C133.804 107.432 133.623 107.549 133.399 107.592C133.175 107.635 132.94 107.656 132.695 107.656H129.319V108.024C129.319 108.557 129.511 108.984 129.895 109.304C130.29 109.613 130.791 109.768 131.399 109.768C131.772 109.768 132.076 109.715 132.311 109.608C132.546 109.501 132.743 109.4 132.903 109.304C133.063 109.208 133.212 109.16 133.351 109.16C133.49 109.16 133.607 109.203 133.703 109.288C133.799 109.373 133.874 109.475 133.927 109.592C133.98 109.709 134.007 109.816 134.007 109.912C134.007 110.072 133.895 110.248 133.671 110.44C133.458 110.632 133.154 110.797 132.759 110.936C132.364 111.064 131.895 111.128 131.351 111.128ZM129.319 106.616H131.975C132.21 106.616 132.364 106.584 132.439 106.52C132.524 106.456 132.567 106.328 132.567 106.136C132.567 105.859 132.498 105.603 132.359 105.368C132.22 105.123 132.028 104.936 131.783 104.808C131.538 104.669 131.26 104.6 130.951 104.6C130.652 104.6 130.38 104.664 130.135 104.792C129.89 104.92 129.692 105.096 129.543 105.32C129.394 105.544 129.319 105.805 129.319 106.104V106.616ZM136.353 111C136.107 111 135.905 110.941 135.745 110.824C135.595 110.707 135.521 110.579 135.521 110.44V103.96C135.521 103.8 135.595 103.672 135.745 103.576C135.905 103.469 136.107 103.416 136.353 103.416C136.555 103.416 136.731 103.469 136.881 103.576C137.03 103.672 137.105 103.8 137.105 103.96V104.536C137.286 104.227 137.553 103.949 137.905 103.704C138.257 103.448 138.699 103.32 139.233 103.32C139.713 103.32 140.134 103.469 140.497 103.768C140.87 104.067 141.147 104.451 141.329 104.92C141.606 104.376 141.963 103.976 142.401 103.72C142.838 103.453 143.286 103.32 143.745 103.32C144.225 103.32 144.673 103.443 145.089 103.688C145.515 103.933 145.862 104.291 146.129 104.76C146.395 105.229 146.529 105.8 146.529 106.472V110.44C146.529 110.579 146.443 110.707 146.273 110.824C146.113 110.941 145.915 111 145.681 111C145.457 111 145.259 110.941 145.089 110.824C144.929 110.707 144.849 110.579 144.849 110.44V106.472C144.849 106.109 144.774 105.805 144.625 105.56C144.486 105.304 144.299 105.112 144.065 104.984C143.841 104.856 143.606 104.792 143.361 104.792C143.105 104.792 142.865 104.861 142.641 105C142.417 105.128 142.23 105.315 142.081 105.56C141.931 105.795 141.857 106.088 141.857 106.44V110.456C141.857 110.648 141.766 110.787 141.585 110.872C141.414 110.957 141.222 111 141.009 111C140.817 111 140.63 110.957 140.449 110.872C140.267 110.787 140.177 110.648 140.177 110.456V106.456C140.177 106.115 140.107 105.821 139.969 105.576C139.83 105.331 139.649 105.144 139.425 105.016C139.201 104.877 138.955 104.808 138.689 104.808C138.443 104.808 138.203 104.872 137.969 105C137.745 105.128 137.558 105.315 137.409 105.56C137.27 105.805 137.201 106.109 137.201 106.472V110.44C137.201 110.579 137.115 110.707 136.945 110.824C136.785 110.941 136.587 111 136.353 111ZM152.259 101.512C151.992 101.512 151.763 101.421 151.571 101.24C151.379 101.059 151.283 100.856 151.283 100.632C151.283 100.387 151.379 100.179 151.571 100.008C151.763 99.8373 151.992 99.752 152.259 99.752C152.526 99.752 152.75 99.8373 152.931 100.008C153.123 100.179 153.219 100.387 153.219 100.632C153.219 100.856 153.123 101.059 152.931 101.24C152.75 101.421 152.526 101.512 152.259 101.512ZM152.259 111C152.014 111 151.811 110.941 151.651 110.824C151.502 110.707 151.427 110.579 151.427 110.44V103.96C151.427 103.8 151.502 103.672 151.651 103.576C151.811 103.469 152.014 103.416 152.259 103.416C152.494 103.416 152.691 103.469 152.851 103.576C153.022 103.672 153.107 103.8 153.107 103.96V110.44C153.107 110.579 153.022 110.707 152.851 110.824C152.691 110.941 152.494 111 152.259 111ZM155.681 111C155.446 111 155.249 110.952 155.089 110.856C154.939 110.749 154.865 110.616 154.865 110.456V101.96C154.865 101.384 154.993 100.867 155.249 100.408C155.505 99.9387 155.846 99.5707 156.273 99.304C156.699 99.0373 157.169 98.904 157.681 98.904H158.433C158.646 98.904 158.806 98.9787 158.913 99.128C159.03 99.2773 159.089 99.4427 159.089 99.624C159.089 99.816 159.03 99.9867 158.913 100.136C158.806 100.275 158.646 100.344 158.433 100.344H158.001C157.723 100.344 157.473 100.408 157.249 100.536C157.035 100.664 156.865 100.84 156.737 101.064C156.609 101.277 156.545 101.523 156.545 101.8V103.416H158.609C158.769 103.416 158.886 103.48 158.961 103.608C159.046 103.736 159.089 103.88 159.089 104.04C159.089 104.2 159.046 104.344 158.961 104.472C158.886 104.6 158.769 104.664 158.609 104.664H156.545V110.456C156.545 110.616 156.459 110.749 156.289 110.856C156.118 110.952 155.915 111 155.681 111ZM166.054 111C165.148 111 164.454 110.803 163.974 110.408C163.494 110.003 163.254 109.368 163.254 108.504V100.488C163.254 100.328 163.34 100.2 163.51 100.104C163.692 99.9973 163.884 99.944 164.086 99.944C164.289 99.944 164.481 99.9973 164.662 100.104C164.844 100.2 164.934 100.328 164.934 100.488V103.416H166.886C167.036 103.416 167.148 103.48 167.222 103.608C167.308 103.736 167.35 103.88 167.35 104.04C167.35 104.2 167.308 104.344 167.222 104.472C167.148 104.6 167.036 104.664 166.886 104.664H164.934V108.504C164.934 108.888 165.014 109.16 165.174 109.32C165.345 109.48 165.638 109.56 166.054 109.56H166.598C166.844 109.56 167.025 109.635 167.142 109.784C167.27 109.923 167.334 110.088 167.334 110.28C167.334 110.461 167.27 110.627 167.142 110.776C167.025 110.925 166.844 111 166.598 111H166.054ZM169.353 111C169.108 111 168.905 110.941 168.745 110.824C168.596 110.707 168.521 110.579 168.521 110.44V99.448C168.521 99.288 168.596 99.16 168.745 99.064C168.905 98.9573 169.108 98.904 169.353 98.904C169.588 98.904 169.785 98.9573 169.945 99.064C170.116 99.16 170.201 99.288 170.201 99.448V104.536C170.361 104.227 170.612 103.949 170.953 103.704C171.305 103.448 171.737 103.32 172.249 103.32C172.75 103.32 173.209 103.464 173.625 103.752C174.052 104.029 174.393 104.408 174.649 104.888C174.905 105.357 175.033 105.885 175.033 106.472V110.44C175.033 110.621 174.942 110.76 174.761 110.856C174.59 110.952 174.398 111 174.185 111C173.993 111 173.806 110.952 173.625 110.856C173.444 110.76 173.353 110.621 173.353 110.44V106.472C173.353 106.195 173.278 105.928 173.129 105.672C172.98 105.416 172.782 105.208 172.537 105.048C172.302 104.888 172.036 104.808 171.737 104.808C171.481 104.808 171.236 104.877 171.001 105.016C170.766 105.144 170.574 105.331 170.425 105.576C170.276 105.821 170.201 106.12 170.201 106.472V110.44C170.201 110.579 170.116 110.707 169.945 110.824C169.785 110.941 169.588 111 169.353 111ZM180.132 111.128C179.407 111.128 178.767 110.995 178.212 110.728C177.657 110.461 177.22 110.093 176.9 109.624C176.58 109.144 176.42 108.584 176.42 107.944V106.424C176.42 105.859 176.569 105.341 176.868 104.872C177.177 104.403 177.583 104.029 178.084 103.752C178.585 103.464 179.14 103.32 179.748 103.32C180.324 103.32 180.852 103.448 181.332 103.704C181.812 103.949 182.196 104.296 182.484 104.744C182.783 105.192 182.932 105.704 182.932 106.28C182.932 106.728 182.863 107.048 182.724 107.24C182.585 107.432 182.404 107.549 182.18 107.592C181.956 107.635 181.721 107.656 181.476 107.656H178.1V108.024C178.1 108.557 178.292 108.984 178.676 109.304C179.071 109.613 179.572 109.768 180.18 109.768C180.553 109.768 180.857 109.715 181.092 109.608C181.327 109.501 181.524 109.4 181.684 109.304C181.844 109.208 181.993 109.16 182.132 109.16C182.271 109.16 182.388 109.203 182.484 109.288C182.58 109.373 182.655 109.475 182.708 109.592C182.761 109.709 182.788 109.816 182.788 109.912C182.788 110.072 182.676 110.248 182.452 110.44C182.239 110.632 181.935 110.797 181.54 110.936C181.145 111.064 180.676 111.128 180.132 111.128ZM178.1 106.616H180.756C180.991 106.616 181.145 106.584 181.22 106.52C181.305 106.456 181.348 106.328 181.348 106.136C181.348 105.859 181.279 105.603 181.14 105.368C181.001 105.123 180.809 104.936 180.564 104.808C180.319 104.669 180.041 104.6 179.732 104.6C179.433 104.6 179.161 104.664 178.916 104.792C178.671 104.92 178.473 105.096 178.324 105.32C178.175 105.544 178.1 105.805 178.1 106.104V106.616ZM184.334 114.6C184.121 114.6 183.939 114.552 183.79 114.456C183.641 114.371 183.566 114.179 183.566 113.88C183.566 113.688 183.598 113.517 183.662 113.368C183.726 113.229 183.843 113.16 184.014 113.16C184.217 113.16 184.435 113.107 184.67 113C184.915 112.904 185.15 112.744 185.374 112.52C185.609 112.307 185.806 112.035 185.966 111.704C186.137 111.373 186.254 110.984 186.318 110.536L183.614 104.328C183.571 104.253 183.55 104.179 183.55 104.104C183.55 103.965 183.609 103.837 183.726 103.72C183.854 103.592 184.003 103.491 184.174 103.416C184.345 103.341 184.505 103.304 184.654 103.304C184.761 103.304 184.862 103.331 184.958 103.384C185.065 103.427 185.134 103.501 185.166 103.608L187.182 108.808L188.926 103.608C188.958 103.501 189.022 103.427 189.118 103.384C189.214 103.331 189.31 103.304 189.406 103.304C189.534 103.304 189.683 103.341 189.854 103.416C190.035 103.491 190.19 103.592 190.318 103.72C190.457 103.837 190.526 103.976 190.526 104.136C190.526 104.221 190.51 104.285 190.478 104.328L188.078 110.584C187.907 111.043 187.731 111.507 187.55 111.976C187.369 112.456 187.145 112.893 186.878 113.288C186.622 113.683 186.286 113.997 185.87 114.232C185.465 114.477 184.953 114.6 184.334 114.6ZM191.841 102.472C191.713 102.472 191.585 102.435 191.457 102.36C191.329 102.275 191.265 102.157 191.265 102.008C191.265 101.933 191.281 101.869 191.313 101.816L191.665 100.968C191.505 100.883 191.372 100.765 191.265 100.616C191.169 100.467 191.121 100.296 191.121 100.104C191.121 99.8373 191.212 99.6133 191.393 99.432C191.574 99.24 191.798 99.144 192.065 99.144C192.321 99.144 192.54 99.24 192.721 99.432C192.913 99.6133 193.009 99.832 193.009 100.088C193.009 100.141 192.998 100.216 192.977 100.312C192.956 100.408 192.913 100.536 192.849 100.696C192.796 100.845 192.716 101.048 192.609 101.304C192.513 101.549 192.38 101.859 192.209 102.232C192.177 102.317 192.124 102.381 192.049 102.424C191.974 102.456 191.905 102.472 191.841 102.472ZM194.977 111C194.743 111 194.545 110.941 194.385 110.824C194.236 110.707 194.161 110.579 194.161 110.44V103.96C194.161 103.8 194.236 103.672 194.385 103.576C194.545 103.469 194.743 103.416 194.977 103.416C195.191 103.416 195.372 103.469 195.521 103.576C195.671 103.672 195.745 103.8 195.745 103.96V104.664C195.863 104.44 196.017 104.227 196.209 104.024C196.412 103.821 196.647 103.656 196.913 103.528C197.18 103.389 197.468 103.32 197.777 103.32H198.289C198.46 103.32 198.609 103.395 198.737 103.544C198.865 103.683 198.929 103.853 198.929 104.056C198.929 104.259 198.865 104.435 198.737 104.584C198.609 104.733 198.46 104.808 198.289 104.808H197.777C197.457 104.808 197.148 104.904 196.849 105.096C196.551 105.288 196.305 105.56 196.113 105.912C195.932 106.253 195.841 106.669 195.841 107.16V110.44C195.841 110.579 195.756 110.707 195.585 110.824C195.425 110.941 195.223 111 194.977 111ZM203.07 111.128C202.344 111.128 201.704 110.995 201.15 110.728C200.595 110.461 200.158 110.093 199.838 109.624C199.518 109.144 199.358 108.584 199.358 107.944V106.424C199.358 105.859 199.507 105.341 199.806 104.872C200.115 104.403 200.52 104.029 201.022 103.752C201.523 103.464 202.078 103.32 202.686 103.32C203.262 103.32 203.79 103.448 204.27 103.704C204.75 103.949 205.134 104.296 205.422 104.744C205.72 105.192 205.87 105.704 205.87 106.28C205.87 106.728 205.8 107.048 205.662 107.24C205.523 107.432 205.342 107.549 205.118 107.592C204.894 107.635 204.659 107.656 204.414 107.656H201.038V108.024C201.038 108.557 201.23 108.984 201.614 109.304C202.008 109.613 202.51 109.768 203.118 109.768C203.491 109.768 203.795 109.715 204.03 109.608C204.264 109.501 204.462 109.4 204.622 109.304C204.782 109.208 204.931 109.16 205.07 109.16C205.208 109.16 205.326 109.203 205.422 109.288C205.518 109.373 205.592 109.475 205.646 109.592C205.699 109.709 205.726 109.816 205.726 109.912C205.726 110.072 205.614 110.248 205.39 110.44C205.176 110.632 204.872 110.797 204.478 110.936C204.083 111.064 203.614 111.128 203.07 111.128ZM201.038 106.616H203.694C203.928 106.616 204.083 106.584 204.158 106.52C204.243 106.456 204.286 106.328 204.286 106.136C204.286 105.859 204.216 105.603 204.078 105.368C203.939 105.123 203.747 104.936 203.502 104.808C203.256 104.669 202.979 104.6 202.67 104.6C202.371 104.6 202.099 104.664 201.854 104.792C201.608 104.92 201.411 105.096 201.262 105.32C201.112 105.544 201.038 105.805 201.038 106.104V106.616ZM55.5458 131.128C54.7778 131.128 54.1431 130.989 53.6418 130.712C53.1511 130.435 52.7884 130.056 52.5538 129.576C52.3191 129.096 52.2018 128.552 52.2018 127.944V126.504C52.2018 125.907 52.3191 125.368 52.5538 124.888C52.7884 124.397 53.1511 124.013 53.6418 123.736C54.1324 123.459 54.7564 123.32 55.5138 123.32C56.0044 123.32 56.4311 123.379 56.7938 123.496C57.1671 123.613 57.4551 123.763 57.6578 123.944C57.8711 124.115 57.9778 124.296 57.9778 124.488C57.9778 124.584 57.9458 124.701 57.8818 124.84C57.8284 124.968 57.7484 125.08 57.6418 125.176C57.5458 125.261 57.4284 125.304 57.2898 125.304C57.1831 125.304 57.0658 125.261 56.9378 125.176C56.8204 125.091 56.6604 125.011 56.4578 124.936C56.2551 124.851 55.9831 124.808 55.6418 124.808C55.0444 124.808 54.6018 124.957 54.3138 125.256C54.0258 125.555 53.8818 125.971 53.8818 126.504V127.944C53.8818 128.477 54.0258 128.893 54.3138 129.192C54.6018 129.491 55.0498 129.64 55.6578 129.64C56.0098 129.64 56.2871 129.597 56.4898 129.512C56.6924 129.416 56.8524 129.325 56.9698 129.24C57.0978 129.155 57.2204 129.112 57.3378 129.112C57.4871 129.112 57.6151 129.155 57.7218 129.24C57.8391 129.325 57.9244 129.432 57.9778 129.56C58.0418 129.688 58.0738 129.805 58.0738 129.912C58.0738 130.093 57.9618 130.28 57.7378 130.472C57.5244 130.664 57.2258 130.824 56.8418 130.952C56.4684 131.069 56.0364 131.128 55.5458 131.128ZM62.1845 131.128C61.6085 131.128 61.0698 130.979 60.5685 130.68C60.0672 130.381 59.6618 129.992 59.3525 129.512C59.0538 129.021 58.9045 128.499 58.9045 127.944V126.472C58.9045 125.907 59.0485 125.384 59.3365 124.904C59.6352 124.424 60.0352 124.04 60.5365 123.752C61.0485 123.464 61.6032 123.32 62.2005 123.32C62.7978 123.32 63.3472 123.464 63.8485 123.752C64.3498 124.029 64.7498 124.408 65.0485 124.888C65.3578 125.357 65.5125 125.885 65.5125 126.472V127.944C65.5125 128.488 65.3578 129.005 65.0485 129.496C64.7498 129.987 64.3445 130.381 63.8325 130.68C63.3312 130.979 62.7818 131.128 62.1845 131.128ZM62.2005 129.64C62.4992 129.64 62.7712 129.56 63.0165 129.4C63.2618 129.24 63.4592 129.032 63.6085 128.776C63.7578 128.509 63.8325 128.232 63.8325 127.944V126.472C63.8325 126.195 63.7578 125.928 63.6085 125.672C63.4592 125.416 63.2618 125.208 63.0165 125.048C62.7712 124.888 62.4992 124.808 62.2005 124.808C61.8912 124.808 61.6138 124.888 61.3685 125.048C61.1338 125.208 60.9418 125.416 60.7925 125.672C60.6538 125.928 60.5845 126.195 60.5845 126.472V127.944C60.5845 128.232 60.6538 128.509 60.7925 128.776C60.9418 129.032 61.1392 129.24 61.3845 129.4C61.6298 129.56 61.9018 129.64 62.2005 129.64ZM67.8058 131C67.5604 131 67.3578 130.941 67.1978 130.824C67.0484 130.707 66.9738 130.579 66.9738 130.44V123.96C66.9738 123.8 67.0484 123.672 67.1978 123.576C67.3578 123.469 67.5604 123.416 67.8058 123.416C68.0084 123.416 68.1844 123.469 68.3338 123.576C68.4831 123.672 68.5578 123.8 68.5578 123.96V124.536C68.7178 124.227 68.9791 123.949 69.3418 123.704C69.7151 123.448 70.1684 123.32 70.7018 123.32C71.2031 123.32 71.6618 123.464 72.0778 123.752C72.5044 124.029 72.8458 124.408 73.1018 124.888C73.3578 125.357 73.4858 125.885 73.4858 126.472V130.44C73.4858 130.621 73.3951 130.76 73.2138 130.856C73.0431 130.952 72.8511 131 72.6378 131C72.4458 131 72.2591 130.952 72.0778 130.856C71.8964 130.76 71.8058 130.621 71.8058 130.44V126.472C71.8058 126.195 71.7311 125.928 71.5818 125.672C71.4431 125.416 71.2511 125.208 71.0058 125.048C70.7604 124.888 70.4884 124.808 70.1898 124.808C69.9338 124.808 69.6884 124.877 69.4538 125.016C69.2191 125.144 69.0271 125.331 68.8778 125.576C68.7284 125.821 68.6538 126.12 68.6538 126.472V130.44C68.6538 130.579 68.5684 130.707 68.3978 130.824C68.2378 130.941 68.0404 131 67.8058 131ZM77.9293 131C77.0226 131 76.3293 130.803 75.8493 130.408C75.3693 130.003 75.1293 129.368 75.1293 128.504V120.488C75.1293 120.328 75.2146 120.2 75.3853 120.104C75.5666 119.997 75.7586 119.944 75.9613 119.944C76.1639 119.944 76.3559 119.997 76.5373 120.104C76.7186 120.2 76.8093 120.328 76.8093 120.488V123.416H78.7613C78.9106 123.416 79.0226 123.48 79.0973 123.608C79.1826 123.736 79.2253 123.88 79.2253 124.04C79.2253 124.2 79.1826 124.344 79.0973 124.472C79.0226 124.6 78.9106 124.664 78.7613 124.664H76.8093V128.504C76.8093 128.888 76.8893 129.16 77.0493 129.32C77.2199 129.48 77.5133 129.56 77.9293 129.56H78.4733C78.7186 129.56 78.8999 129.635 79.0173 129.784C79.1453 129.923 79.2093 130.088 79.2093 130.28C79.2093 130.461 79.1453 130.627 79.0173 130.776C78.8999 130.925 78.7186 131 78.4733 131H77.9293ZM82.028 131.128C81.4413 131.128 80.94 130.957 80.524 130.616C80.108 130.264 79.9 129.731 79.9 129.016C79.9 128.408 80.06 127.939 80.38 127.608C80.7 127.277 81.1373 127.048 81.692 126.92C82.2573 126.792 82.908 126.728 83.644 126.728H84.348V126.44C84.348 126.163 84.2947 125.896 84.188 125.64C84.092 125.373 83.9267 125.155 83.692 124.984C83.468 124.803 83.1587 124.712 82.764 124.712C82.3693 124.712 82.0653 124.749 81.852 124.824C81.6387 124.899 81.468 124.979 81.34 125.064C81.212 125.149 81.0947 125.192 80.988 125.192C80.796 125.192 80.6467 125.101 80.54 124.92C80.4333 124.728 80.38 124.536 80.38 124.344C80.38 124.152 80.5027 123.981 80.748 123.832C81.004 123.672 81.3187 123.549 81.692 123.464C82.0653 123.368 82.4333 123.32 82.796 123.32C83.5853 123.32 84.2147 123.469 84.684 123.768C85.1533 124.056 85.4947 124.435 85.708 124.904C85.9213 125.373 86.028 125.88 86.028 126.424V130.44C86.028 130.589 85.948 130.723 85.788 130.84C85.6387 130.947 85.4467 131 85.212 131C84.9987 131 84.8173 130.947 84.668 130.84C84.5187 130.723 84.444 130.589 84.444 130.44V129.88C84.1667 130.2 83.8307 130.488 83.436 130.744C83.0413 131 82.572 131.128 82.028 131.128ZM82.636 129.848C82.9027 129.848 83.164 129.768 83.42 129.608C83.6867 129.448 83.9053 129.245 84.076 129C84.2573 128.755 84.348 128.504 84.348 128.248V127.656H83.948C83.5427 127.656 83.1587 127.683 82.796 127.736C82.4333 127.779 82.14 127.885 81.916 128.056C81.7027 128.216 81.596 128.467 81.596 128.808C81.596 129.171 81.692 129.437 81.884 129.608C82.0867 129.768 82.3373 129.848 82.636 129.848ZM88.5558 131C88.3104 131 88.1078 130.941 87.9478 130.824C87.7984 130.707 87.7238 130.579 87.7238 130.44V123.96C87.7238 123.8 87.7984 123.672 87.9478 123.576C88.1078 123.469 88.3104 123.416 88.5558 123.416C88.7584 123.416 88.9344 123.469 89.0838 123.576C89.2331 123.672 89.3078 123.8 89.3078 123.96V124.536C89.4891 124.227 89.7558 123.949 90.1078 123.704C90.4598 123.448 90.9024 123.32 91.4358 123.32C91.9158 123.32 92.3371 123.469 92.6998 123.768C93.0731 124.067 93.3504 124.451 93.5318 124.92C93.8091 124.376 94.1664 123.976 94.6038 123.72C95.0411 123.453 95.4891 123.32 95.9478 123.32C96.4278 123.32 96.8758 123.443 97.2918 123.688C97.7184 123.933 98.0651 124.291 98.3318 124.76C98.5984 125.229 98.7318 125.8 98.7318 126.472V130.44C98.7318 130.579 98.6464 130.707 98.4758 130.824C98.3158 130.941 98.1184 131 97.8838 131C97.6598 131 97.4624 130.941 97.2918 130.824C97.1318 130.707 97.0518 130.579 97.0518 130.44V126.472C97.0518 126.109 96.9771 125.805 96.8278 125.56C96.6891 125.304 96.5024 125.112 96.2678 124.984C96.0438 124.856 95.8091 124.792 95.5638 124.792C95.3078 124.792 95.0678 124.861 94.8438 125C94.6198 125.128 94.4331 125.315 94.2838 125.56C94.1344 125.795 94.0598 126.088 94.0598 126.44V130.456C94.0598 130.648 93.9691 130.787 93.7878 130.872C93.6171 130.957 93.4251 131 93.2118 131C93.0198 131 92.8331 130.957 92.6518 130.872C92.4704 130.787 92.3798 130.648 92.3798 130.456V126.456C92.3798 126.115 92.3104 125.821 92.1718 125.576C92.0331 125.331 91.8518 125.144 91.6278 125.016C91.4038 124.877 91.1584 124.808 90.8918 124.808C90.6464 124.808 90.4064 124.872 90.1718 125C89.9478 125.128 89.7611 125.315 89.6118 125.56C89.4731 125.805 89.4038 126.109 89.4038 126.472V130.44C89.4038 130.579 89.3184 130.707 89.1478 130.824C88.9878 130.941 88.7904 131 88.5558 131ZM101.259 121.512C100.992 121.512 100.763 121.421 100.571 121.24C100.379 121.059 100.283 120.856 100.283 120.632C100.283 120.387 100.379 120.179 100.571 120.008C100.763 119.837 100.992 119.752 101.259 119.752C101.526 119.752 101.75 119.837 101.931 120.008C102.123 120.179 102.219 120.387 102.219 120.632C102.219 120.856 102.123 121.059 101.931 121.24C101.75 121.421 101.526 121.512 101.259 121.512ZM101.259 131C101.014 131 100.811 130.941 100.651 130.824C100.502 130.707 100.427 130.579 100.427 130.44V123.96C100.427 123.8 100.502 123.672 100.651 123.576C100.811 123.469 101.014 123.416 101.259 123.416C101.494 123.416 101.691 123.469 101.851 123.576C102.022 123.672 102.107 123.8 102.107 123.96V130.44C102.107 130.579 102.022 130.707 101.851 130.824C101.691 130.941 101.494 131 101.259 131ZM104.681 131C104.435 131 104.233 130.941 104.073 130.824C103.923 130.707 103.849 130.579 103.849 130.44V123.96C103.849 123.8 103.923 123.672 104.073 123.576C104.233 123.469 104.435 123.416 104.681 123.416C104.883 123.416 105.059 123.469 105.209 123.576C105.358 123.672 105.433 123.8 105.433 123.96V124.536C105.593 124.227 105.854 123.949 106.217 123.704C106.59 123.448 107.043 123.32 107.577 123.32C108.078 123.32 108.537 123.464 108.953 123.752C109.379 124.029 109.721 124.408 109.977 124.888C110.233 125.357 110.361 125.885 110.361 126.472V130.44C110.361 130.621 110.27 130.76 110.089 130.856C109.918 130.952 109.726 131 109.513 131C109.321 131 109.134 130.952 108.953 130.856C108.771 130.76 108.681 130.621 108.681 130.44V126.472C108.681 126.195 108.606 125.928 108.457 125.672C108.318 125.416 108.126 125.208 107.881 125.048C107.635 124.888 107.363 124.808 107.065 124.808C106.809 124.808 106.563 124.877 106.329 125.016C106.094 125.144 105.902 125.331 105.753 125.576C105.603 125.821 105.529 126.12 105.529 126.472V130.44C105.529 130.579 105.443 130.707 105.273 130.824C105.113 130.941 104.915 131 104.681 131ZM113.684 131.128C113.098 131.128 112.596 130.957 112.18 130.616C111.764 130.264 111.556 129.731 111.556 129.016C111.556 128.408 111.716 127.939 112.036 127.608C112.356 127.277 112.794 127.048 113.348 126.92C113.914 126.792 114.564 126.728 115.3 126.728H116.004V126.44C116.004 126.163 115.951 125.896 115.844 125.64C115.748 125.373 115.583 125.155 115.348 124.984C115.124 124.803 114.815 124.712 114.42 124.712C114.026 124.712 113.722 124.749 113.508 124.824C113.295 124.899 113.124 124.979 112.996 125.064C112.868 125.149 112.751 125.192 112.644 125.192C112.452 125.192 112.303 125.101 112.196 124.92C112.09 124.728 112.036 124.536 112.036 124.344C112.036 124.152 112.159 123.981 112.404 123.832C112.66 123.672 112.975 123.549 113.348 123.464C113.722 123.368 114.09 123.32 114.452 123.32C115.242 123.32 115.871 123.469 116.34 123.768C116.81 124.056 117.151 124.435 117.364 124.904C117.578 125.373 117.684 125.88 117.684 126.424V130.44C117.684 130.589 117.604 130.723 117.444 130.84C117.295 130.947 117.103 131 116.868 131C116.655 131 116.474 130.947 116.324 130.84C116.175 130.723 116.1 130.589 116.1 130.44V129.88C115.823 130.2 115.487 130.488 115.092 130.744C114.698 131 114.228 131.128 113.684 131.128ZM114.292 129.848C114.559 129.848 114.82 129.768 115.076 129.608C115.343 129.448 115.562 129.245 115.732 129C115.914 128.755 116.004 128.504 116.004 128.248V127.656H115.604C115.199 127.656 114.815 127.683 114.452 127.736C114.09 127.779 113.796 127.885 113.572 128.056C113.359 128.216 113.252 128.467 113.252 128.808C113.252 129.171 113.348 129.437 113.54 129.608C113.743 129.768 113.994 129.848 114.292 129.848ZM122.148 131C121.241 131 120.548 130.803 120.068 130.408C119.588 130.003 119.348 129.368 119.348 128.504V120.488C119.348 120.328 119.433 120.2 119.604 120.104C119.785 119.997 119.977 119.944 120.18 119.944C120.383 119.944 120.575 119.997 120.756 120.104C120.937 120.2 121.028 120.328 121.028 120.488V123.416H122.98C123.129 123.416 123.241 123.48 123.316 123.608C123.401 123.736 123.444 123.88 123.444 124.04C123.444 124.2 123.401 124.344 123.316 124.472C123.241 124.6 123.129 124.664 122.98 124.664H121.028V128.504C121.028 128.888 121.108 129.16 121.268 129.32C121.439 129.48 121.732 129.56 122.148 129.56H122.692C122.937 129.56 123.119 129.635 123.236 129.784C123.364 129.923 123.428 130.088 123.428 130.28C123.428 130.461 123.364 130.627 123.236 130.776C123.119 130.925 122.937 131 122.692 131H122.148ZM127.913 131.128C127.188 131.128 126.548 130.995 125.993 130.728C125.439 130.461 125.001 130.093 124.681 129.624C124.361 129.144 124.201 128.584 124.201 127.944V126.424C124.201 125.859 124.351 125.341 124.649 124.872C124.959 124.403 125.364 124.029 125.865 123.752C126.367 123.464 126.921 123.32 127.529 123.32C128.105 123.32 128.633 123.448 129.113 123.704C129.593 123.949 129.977 124.296 130.265 124.744C130.564 125.192 130.713 125.704 130.713 126.28C130.713 126.728 130.644 127.048 130.505 127.24C130.367 127.432 130.185 127.549 129.961 127.592C129.737 127.635 129.503 127.656 129.257 127.656H125.881V128.024C125.881 128.557 126.073 128.984 126.457 129.304C126.852 129.613 127.353 129.768 127.961 129.768C128.335 129.768 128.639 129.715 128.873 129.608C129.108 129.501 129.305 129.4 129.465 129.304C129.625 129.208 129.775 129.16 129.913 129.16C130.052 129.16 130.169 129.203 130.265 129.288C130.361 129.373 130.436 129.475 130.489 129.592C130.543 129.709 130.569 129.816 130.569 129.912C130.569 130.072 130.457 130.248 130.233 130.44C130.02 130.632 129.716 130.797 129.321 130.936C128.927 131.064 128.457 131.128 127.913 131.128ZM125.881 126.616H128.537C128.772 126.616 128.927 126.584 129.001 126.52C129.087 126.456 129.129 126.328 129.129 126.136C129.129 125.859 129.06 125.603 128.921 125.368C128.783 125.123 128.591 124.936 128.345 124.808C128.1 124.669 127.823 124.6 127.513 124.6C127.215 124.6 126.943 124.664 126.697 124.792C126.452 124.92 126.255 125.096 126.105 125.32C125.956 125.544 125.881 125.805 125.881 126.104V126.616ZM134.611 131.128C134.11 131.128 133.646 130.979 133.219 130.68C132.792 130.381 132.446 129.992 132.179 129.512C131.923 129.021 131.795 128.499 131.795 127.944V126.472C131.795 125.885 131.923 125.357 132.179 124.888C132.446 124.408 132.792 124.029 133.219 123.752C133.646 123.464 134.12 123.32 134.643 123.32C135.155 123.32 135.587 123.448 135.939 123.704C136.291 123.949 136.552 124.227 136.723 124.536V119.448C136.723 119.288 136.808 119.16 136.979 119.064C137.15 118.957 137.352 118.904 137.587 118.904C137.822 118.904 138.014 118.957 138.163 119.064C138.323 119.16 138.403 119.288 138.403 119.448V130.44C138.403 130.579 138.323 130.707 138.163 130.824C138.014 130.941 137.822 131 137.587 131C137.384 131 137.203 130.941 137.043 130.824C136.894 130.707 136.819 130.579 136.819 130.44V129.88C136.659 130.211 136.376 130.504 135.971 130.76C135.566 131.005 135.112 131.128 134.611 131.128ZM135.091 129.64C135.4 129.64 135.678 129.555 135.923 129.384C136.168 129.213 136.36 129.027 136.499 128.824C136.648 128.611 136.723 128.44 136.723 128.312V126.472C136.723 126.12 136.643 125.821 136.483 125.576C136.323 125.331 136.12 125.144 135.875 125.016C135.63 124.877 135.374 124.808 135.107 124.808C134.808 124.808 134.531 124.888 134.275 125.048C134.03 125.208 133.832 125.416 133.683 125.672C133.544 125.928 133.475 126.195 133.475 126.472V127.944C133.475 128.221 133.544 128.493 133.683 128.76C133.832 129.027 134.03 129.24 134.275 129.4C134.52 129.56 134.792 129.64 135.091 129.64ZM145.028 131.128C144.441 131.128 143.94 130.957 143.524 130.616C143.108 130.264 142.9 129.731 142.9 129.016C142.9 128.408 143.06 127.939 143.38 127.608C143.7 127.277 144.137 127.048 144.692 126.92C145.257 126.792 145.908 126.728 146.644 126.728H147.348V126.44C147.348 126.163 147.295 125.896 147.188 125.64C147.092 125.373 146.927 125.155 146.692 124.984C146.468 124.803 146.159 124.712 145.764 124.712C145.369 124.712 145.065 124.749 144.852 124.824C144.639 124.899 144.468 124.979 144.34 125.064C144.212 125.149 144.095 125.192 143.988 125.192C143.796 125.192 143.647 125.101 143.54 124.92C143.433 124.728 143.38 124.536 143.38 124.344C143.38 124.152 143.503 123.981 143.748 123.832C144.004 123.672 144.319 123.549 144.692 123.464C145.065 123.368 145.433 123.32 145.796 123.32C146.585 123.32 147.215 123.469 147.684 123.768C148.153 124.056 148.495 124.435 148.708 124.904C148.921 125.373 149.028 125.88 149.028 126.424V130.44C149.028 130.589 148.948 130.723 148.788 130.84C148.639 130.947 148.447 131 148.212 131C147.999 131 147.817 130.947 147.668 130.84C147.519 130.723 147.444 130.589 147.444 130.44V129.88C147.167 130.2 146.831 130.488 146.436 130.744C146.041 131 145.572 131.128 145.028 131.128ZM145.636 129.848C145.903 129.848 146.164 129.768 146.42 129.608C146.687 129.448 146.905 129.245 147.076 129C147.257 128.755 147.348 128.504 147.348 128.248V127.656H146.948C146.543 127.656 146.159 127.683 145.796 127.736C145.433 127.779 145.14 127.885 144.916 128.056C144.703 128.216 144.596 128.467 144.596 128.808C144.596 129.171 144.692 129.437 144.884 129.608C145.087 129.768 145.337 129.848 145.636 129.848ZM151.556 131C151.31 131 151.108 130.941 150.948 130.824C150.798 130.707 150.724 130.579 150.724 130.44V123.96C150.724 123.8 150.798 123.672 150.948 123.576C151.108 123.469 151.31 123.416 151.556 123.416C151.758 123.416 151.934 123.469 152.084 123.576C152.233 123.672 152.308 123.8 152.308 123.96V124.536C152.468 124.227 152.729 123.949 153.092 123.704C153.465 123.448 153.918 123.32 154.452 123.32C154.953 123.32 155.412 123.464 155.828 123.752C156.254 124.029 156.596 124.408 156.852 124.888C157.108 125.357 157.236 125.885 157.236 126.472V130.44C157.236 130.621 157.145 130.76 156.964 130.856C156.793 130.952 156.601 131 156.388 131C156.196 131 156.009 130.952 155.828 130.856C155.646 130.76 155.556 130.621 155.556 130.44V126.472C155.556 126.195 155.481 125.928 155.332 125.672C155.193 125.416 155.001 125.208 154.756 125.048C154.51 124.888 154.238 124.808 153.94 124.808C153.684 124.808 153.438 124.877 153.204 125.016C152.969 125.144 152.777 125.331 152.628 125.576C152.478 125.821 152.404 126.12 152.404 126.472V130.44C152.404 130.579 152.318 130.707 152.148 130.824C151.988 130.941 151.79 131 151.556 131ZM161.439 131.128C160.938 131.128 160.474 130.979 160.047 130.68C159.621 130.381 159.274 129.992 159.007 129.512C158.751 129.021 158.623 128.499 158.623 127.944V126.472C158.623 125.885 158.751 125.357 159.007 124.888C159.274 124.408 159.621 124.029 160.047 123.752C160.474 123.464 160.949 123.32 161.471 123.32C161.983 123.32 162.415 123.448 162.767 123.704C163.119 123.949 163.381 124.227 163.551 124.536V119.448C163.551 119.288 163.637 119.16 163.807 119.064C163.978 118.957 164.181 118.904 164.415 118.904C164.65 118.904 164.842 118.957 164.991 119.064C165.151 119.16 165.231 119.288 165.231 119.448V130.44C165.231 130.579 165.151 130.707 164.991 130.824C164.842 130.941 164.65 131 164.415 131C164.213 131 164.031 130.941 163.871 130.824C163.722 130.707 163.647 130.579 163.647 130.44V129.88C163.487 130.211 163.205 130.504 162.799 130.76C162.394 131.005 161.941 131.128 161.439 131.128ZM161.919 129.64C162.229 129.64 162.506 129.555 162.751 129.384C162.997 129.213 163.189 129.027 163.327 128.824C163.477 128.611 163.551 128.44 163.551 128.312V126.472C163.551 126.12 163.471 125.821 163.311 125.576C163.151 125.331 162.949 125.144 162.703 125.016C162.458 124.877 162.202 124.808 161.935 124.808C161.637 124.808 161.359 124.888 161.103 125.048C160.858 125.208 160.661 125.416 160.511 125.672C160.373 125.928 160.303 126.195 160.303 126.472V127.944C160.303 128.221 160.373 128.493 160.511 128.76C160.661 129.027 160.858 129.24 161.103 129.4C161.349 129.56 161.621 129.64 161.919 129.64ZM173.28 131.128C172.512 131.128 171.877 130.989 171.376 130.712C170.885 130.435 170.523 130.056 170.288 129.576C170.053 129.096 169.936 128.552 169.936 127.944V126.504C169.936 125.907 170.053 125.368 170.288 124.888C170.523 124.397 170.885 124.013 171.376 123.736C171.867 123.459 172.491 123.32 173.248 123.32C173.739 123.32 174.165 123.379 174.528 123.496C174.901 123.613 175.189 123.763 175.392 123.944C175.605 124.115 175.712 124.296 175.712 124.488C175.712 124.584 175.68 124.701 175.616 124.84C175.563 124.968 175.483 125.08 175.376 125.176C175.28 125.261 175.163 125.304 175.024 125.304C174.917 125.304 174.8 125.261 174.672 125.176C174.555 125.091 174.395 125.011 174.192 124.936C173.989 124.851 173.717 124.808 173.376 124.808C172.779 124.808 172.336 124.957 172.048 125.256C171.76 125.555 171.616 125.971 171.616 126.504V127.944C171.616 128.477 171.76 128.893 172.048 129.192C172.336 129.491 172.784 129.64 173.392 129.64C173.744 129.64 174.021 129.597 174.224 129.512C174.427 129.416 174.587 129.325 174.704 129.24C174.832 129.155 174.955 129.112 175.072 129.112C175.221 129.112 175.349 129.155 175.456 129.24C175.573 129.325 175.659 129.432 175.712 129.56C175.776 129.688 175.808 129.805 175.808 129.912C175.808 130.093 175.696 130.28 175.472 130.472C175.259 130.664 174.96 130.824 174.576 130.952C174.203 131.069 173.771 131.128 173.28 131.128ZM178.653 131.128C178.066 131.128 177.565 130.957 177.149 130.616C176.733 130.264 176.525 129.731 176.525 129.016C176.525 128.408 176.685 127.939 177.005 127.608C177.325 127.277 177.762 127.048 178.317 126.92C178.882 126.792 179.533 126.728 180.269 126.728H180.973V126.44C180.973 126.163 180.92 125.896 180.813 125.64C180.717 125.373 180.552 125.155 180.317 124.984C180.093 124.803 179.784 124.712 179.389 124.712C178.994 124.712 178.69 124.749 178.477 124.824C178.264 124.899 178.093 124.979 177.965 125.064C177.837 125.149 177.72 125.192 177.613 125.192C177.421 125.192 177.272 125.101 177.165 124.92C177.058 124.728 177.005 124.536 177.005 124.344C177.005 124.152 177.128 123.981 177.373 123.832C177.629 123.672 177.944 123.549 178.317 123.464C178.69 123.368 179.058 123.32 179.421 123.32C180.21 123.32 180.84 123.469 181.309 123.768C181.778 124.056 182.12 124.435 182.333 124.904C182.546 125.373 182.653 125.88 182.653 126.424V130.44C182.653 130.589 182.573 130.723 182.413 130.84C182.264 130.947 182.072 131 181.837 131C181.624 131 181.442 130.947 181.293 130.84C181.144 130.723 181.069 130.589 181.069 130.44V129.88C180.792 130.2 180.456 130.488 180.061 130.744C179.666 131 179.197 131.128 178.653 131.128ZM179.261 129.848C179.528 129.848 179.789 129.768 180.045 129.608C180.312 129.448 180.53 129.245 180.701 129C180.882 128.755 180.973 128.504 180.973 128.248V127.656H180.573C180.168 127.656 179.784 127.683 179.421 127.736C179.058 127.779 178.765 127.885 178.541 128.056C178.328 128.216 178.221 128.467 178.221 128.808C178.221 129.171 178.317 129.437 178.509 129.608C178.712 129.768 178.962 129.848 179.261 129.848ZM185.181 131C184.935 131 184.733 130.941 184.573 130.824C184.423 130.707 184.349 130.579 184.349 130.44V123.96C184.349 123.8 184.423 123.672 184.573 123.576C184.733 123.469 184.935 123.416 185.181 123.416C185.383 123.416 185.559 123.469 185.709 123.576C185.858 123.672 185.933 123.8 185.933 123.96V124.536C186.093 124.227 186.354 123.949 186.717 123.704C187.09 123.448 187.543 123.32 188.077 123.32C188.578 123.32 189.037 123.464 189.453 123.752C189.879 124.029 190.221 124.408 190.477 124.888C190.733 125.357 190.861 125.885 190.861 126.472V130.44C190.861 130.621 190.77 130.76 190.589 130.856C190.418 130.952 190.226 131 190.013 131C189.821 131 189.634 130.952 189.453 130.856C189.271 130.76 189.181 130.621 189.181 130.44V126.472C189.181 126.195 189.106 125.928 188.957 125.672C188.818 125.416 188.626 125.208 188.381 125.048C188.135 124.888 187.863 124.808 187.565 124.808C187.309 124.808 187.063 124.877 186.829 125.016C186.594 125.144 186.402 125.331 186.253 125.576C186.103 125.821 186.029 126.12 186.029 126.472V130.44C186.029 130.579 185.943 130.707 185.773 130.824C185.613 130.941 185.415 131 185.181 131ZM192.763 122.472C192.635 122.472 192.507 122.435 192.379 122.36C192.251 122.275 192.187 122.157 192.187 122.008C192.187 121.933 192.203 121.869 192.235 121.816L192.587 120.968C192.427 120.883 192.294 120.765 192.187 120.616C192.091 120.467 192.043 120.296 192.043 120.104C192.043 119.837 192.134 119.613 192.315 119.432C192.496 119.24 192.72 119.144 192.987 119.144C193.243 119.144 193.462 119.24 193.643 119.432C193.835 119.613 193.931 119.832 193.931 120.088C193.931 120.141 193.92 120.216 193.899 120.312C193.878 120.408 193.835 120.536 193.771 120.696C193.718 120.845 193.638 121.048 193.531 121.304C193.435 121.549 193.302 121.859 193.131 122.232C193.099 122.317 193.046 122.381 192.971 122.424C192.896 122.456 192.827 122.472 192.763 122.472ZM197.945 131C197.038 131 196.345 130.803 195.865 130.408C195.385 130.003 195.145 129.368 195.145 128.504V120.488C195.145 120.328 195.23 120.2 195.401 120.104C195.582 119.997 195.774 119.944 195.977 119.944C196.18 119.944 196.372 119.997 196.553 120.104C196.734 120.2 196.825 120.328 196.825 120.488V123.416H198.777C198.926 123.416 199.038 123.48 199.113 123.608C199.198 123.736 199.241 123.88 199.241 124.04C199.241 124.2 199.198 124.344 199.113 124.472C199.038 124.6 198.926 124.664 198.777 124.664H196.825V128.504C196.825 128.888 196.905 129.16 197.065 129.32C197.236 129.48 197.529 129.56 197.945 129.56H198.489C198.734 129.56 198.916 129.635 199.033 129.784C199.161 129.923 199.225 130.088 199.225 130.28C199.225 130.461 199.161 130.627 199.033 130.776C198.916 130.925 198.734 131 198.489 131H197.945ZM207.407 131.128C206.905 131.128 206.452 131.005 206.047 130.76C205.652 130.504 205.369 130.211 205.199 129.88V130.44C205.199 130.579 205.124 130.707 204.975 130.824C204.825 130.941 204.644 131 204.431 131C204.196 131 203.999 130.941 203.839 130.824C203.689 130.707 203.615 130.579 203.615 130.44V119.448C203.615 119.288 203.689 119.16 203.839 119.064C203.999 118.957 204.196 118.904 204.431 118.904C204.676 118.904 204.879 118.957 205.039 119.064C205.209 119.16 205.295 119.288 205.295 119.448V124.536C205.465 124.227 205.727 123.949 206.079 123.704C206.431 123.448 206.857 123.32 207.359 123.32C207.881 123.32 208.356 123.464 208.783 123.752C209.22 124.029 209.567 124.408 209.823 124.888C210.089 125.357 210.223 125.885 210.223 126.472V127.944C210.223 128.499 210.089 129.021 209.823 129.512C209.567 129.992 209.225 130.381 208.799 130.68C208.372 130.979 207.908 131.128 207.407 131.128ZM206.927 129.64C207.215 129.64 207.481 129.56 207.727 129.4C207.972 129.24 208.169 129.027 208.319 128.76C208.468 128.493 208.543 128.221 208.543 127.944V126.472C208.543 126.195 208.468 125.928 208.319 125.672C208.169 125.416 207.972 125.208 207.727 125.048C207.481 124.888 207.209 124.808 206.911 124.808C206.644 124.808 206.388 124.877 206.143 125.016C205.897 125.144 205.695 125.331 205.535 125.576C205.375 125.821 205.295 126.12 205.295 126.472V128.312C205.295 128.44 205.364 128.611 205.503 128.824C205.652 129.027 205.849 129.213 206.095 129.384C206.34 129.555 206.617 129.64 206.927 129.64ZM215.117 131.128C214.391 131.128 213.751 130.995 213.197 130.728C212.642 130.461 212.205 130.093 211.885 129.624C211.565 129.144 211.405 128.584 211.405 127.944V126.424C211.405 125.859 211.554 125.341 211.853 124.872C212.162 124.403 212.567 124.029 213.069 123.752C213.57 123.464 214.125 123.32 214.733 123.32C215.309 123.32 215.837 123.448 216.317 123.704C216.797 123.949 217.181 124.296 217.469 124.744C217.767 125.192 217.917 125.704 217.917 126.28C217.917 126.728 217.847 127.048 217.709 127.24C217.57 127.432 217.389 127.549 217.165 127.592C216.941 127.635 216.706 127.656 216.461 127.656H213.085V128.024C213.085 128.557 213.277 128.984 213.661 129.304C214.055 129.613 214.557 129.768 215.165 129.768C215.538 129.768 215.842 129.715 216.077 129.608C216.311 129.501 216.509 129.4 216.669 129.304C216.829 129.208 216.978 129.16 217.117 129.16C217.255 129.16 217.373 129.203 217.469 129.288C217.565 129.373 217.639 129.475 217.693 129.592C217.746 129.709 217.773 129.816 217.773 129.912C217.773 130.072 217.661 130.248 217.437 130.44C217.223 130.632 216.919 130.797 216.525 130.936C216.13 131.064 215.661 131.128 215.117 131.128ZM213.085 126.616H215.741C215.975 126.616 216.13 126.584 216.205 126.52C216.29 126.456 216.333 126.328 216.333 126.136C216.333 125.859 216.263 125.603 216.125 125.368C215.986 125.123 215.794 124.936 215.549 124.808C215.303 124.669 215.026 124.6 214.717 124.6C214.418 124.6 214.146 124.664 213.901 124.792C213.655 124.92 213.458 125.096 213.309 125.32C213.159 125.544 213.085 125.805 213.085 126.104V126.616ZM110.975 151.128C110.207 151.128 109.573 150.989 109.071 150.712C108.581 150.435 108.218 150.056 107.983 149.576C107.749 149.096 107.631 148.552 107.631 147.944V146.504C107.631 145.907 107.749 145.368 107.983 144.888C108.218 144.397 108.581 144.013 109.071 143.736C109.562 143.459 110.186 143.32 110.943 143.32C111.434 143.32 111.861 143.379 112.223 143.496C112.597 143.613 112.885 143.763 113.087 143.944C113.301 144.115 113.407 144.296 113.407 144.488C113.407 144.584 113.375 144.701 113.311 144.84C113.258 144.968 113.178 145.08 113.071 145.176C112.975 145.261 112.858 145.304 112.719 145.304C112.613 145.304 112.495 145.261 112.367 145.176C112.25 145.091 112.09 145.011 111.887 144.936C111.685 144.851 111.413 144.808 111.071 144.808C110.474 144.808 110.031 144.957 109.743 145.256C109.455 145.555 109.311 145.971 109.311 146.504V147.944C109.311 148.477 109.455 148.893 109.743 149.192C110.031 149.491 110.479 149.64 111.087 149.64C111.439 149.64 111.717 149.597 111.919 149.512C112.122 149.416 112.282 149.325 112.399 149.24C112.527 149.155 112.65 149.112 112.767 149.112C112.917 149.112 113.045 149.155 113.151 149.24C113.269 149.325 113.354 149.432 113.407 149.56C113.471 149.688 113.503 149.805 113.503 149.912C113.503 150.093 113.391 150.28 113.167 150.472C112.954 150.664 112.655 150.824 112.271 150.952C111.898 151.069 111.466 151.128 110.975 151.128ZM115.676 151C115.431 151 115.228 150.941 115.068 150.824C114.919 150.707 114.844 150.579 114.844 150.44V139.448C114.844 139.288 114.919 139.16 115.068 139.064C115.228 138.957 115.431 138.904 115.676 138.904C115.911 138.904 116.108 138.957 116.268 139.064C116.439 139.16 116.524 139.288 116.524 139.448V150.44C116.524 150.579 116.439 150.707 116.268 150.824C116.108 150.941 115.911 151 115.676 151ZM121.843 151.128C121.118 151.128 120.478 150.995 119.923 150.728C119.368 150.461 118.931 150.093 118.611 149.624C118.291 149.144 118.131 148.584 118.131 147.944V146.424C118.131 145.859 118.28 145.341 118.579 144.872C118.888 144.403 119.294 144.029 119.795 143.752C120.296 143.464 120.851 143.32 121.459 143.32C122.035 143.32 122.563 143.448 123.043 143.704C123.523 143.949 123.907 144.296 124.195 144.744C124.494 145.192 124.643 145.704 124.643 146.28C124.643 146.728 124.574 147.048 124.435 147.24C124.296