function cross_cultural(_topFrame,_libraryPath,_codebasePath, _inputParameters) {
  var _model = EJSS_CORE.createAnimationLMS();
  var _view;
  var _isPlaying = false;
  var _isPaused = true;
  var _isMobile = (navigator===undefined) ? false : navigator.userAgent.match(/iPhone|iPad|iPod|Android|BlackBerry|Opera Mini|IEMobile/i);

var _stringProperties = {};
  var _tools = EJSS_CORE.Tools;
  function _play()  { _isPaused = false; _isPlaying = true;  _model.play();  }
  function _pause() { _isPaused = true;  _isPlaying = false; _model.pause(); }
  function _step()  { _pause();  _model.step(); }
  function _reset() { _model.reset();  _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); }
  _model._play  = _play;
  _model._pause = _pause;
  _model._step  = _step;
  _model._reset = _reset;
  function _update() { _model.update(); }
  function _initialize() { _model.initialize(); }
  function _setFPS(_fps) { _model.setFPS(_fps); }
  function _setDelay(_delay) { _model.setDelay(_delay); }
  function _setStepsPerDisplay(_spd) { _model.setStepsPerDisplay(_spd); }
  function _setUpdateView(_updateView) { _model.setUpdateView(_updateView); }
  function _setAutoplay(_auto) { _model.setAutoplay(_auto); }
  function _println(_message) { console.log(_message); }

  function _breakAfterThisPage() { _model.setShouldBreak(true); }

  function _resetSolvers() { if (_model.resetSolvers) _model.resetSolvers(); }

  function _saveText(name,type,content) { if (_model.saveText) _model.saveText(name,type,content); }

  function _saveState(name) { if (_model.saveState) _model.saveState(name); }

  function _saveImage(name,panelname) { if (_model.saveImage) _model.saveImage(name,panelname); }

  function _readState(url,type) { if (_model.readState) _model.readState(url,type); }

  function _readText(url,type,varname) { if (_model.readText) _model.readText(url,type,varname); }

  function _getStringProperty(propertyName) {
    var _value = _stringProperties[propertyName];
    if (_value===undefined) return propertyName;
    else return _value;
  }
  var __pagesEnabled = [];
  function _setPageEnabled(pageName,enabled) { __pagesEnabled[pageName] = enabled; }

  var currentStage; // EjsS Model.Variables.game.currentStage
  var currentPage; // EjsS Model.Variables.game.currentPage
  var progressPercentage; // EjsS Model.Variables.game.progressPercentage
  var isGameInProgress; // EjsS Model.Variables.game.isGameInProgress
  var hasGameEnded; // EjsS Model.Variables.game.hasGameEnded

  var religionImageSelected; // EjsS Model.Variables.religion.religionImageSelected
  var religionNameSelected; // EjsS Model.Variables.religion.religionNameSelected
  var areCardsMatched; // EjsS Model.Variables.religion.areCardsMatched
  var questionNumbers; // EjsS Model.Variables.religion.questionNumbers
  var questionAttempts; // EjsS Model.Variables.religion.questionAttempts

  _model.getOdes = function() { return []; };

  _model.removeEvents = function(){
  };

  function _serialize() { return _model.serialize(); }

  _model._userSerialize = function() {
    return {
      currentStage : currentStage,
      currentPage : currentPage,
      progressPercentage : progressPercentage,
      isGameInProgress : isGameInProgress,
      hasGameEnded : hasGameEnded,
      religionImageSelected : religionImageSelected,
      religionNameSelected : religionNameSelected,
      areCardsMatched : areCardsMatched,
      questionNumbers : questionNumbers,
      questionAttempts : questionAttempts
    };
  };

  _model._readParameters = function(json) {
    if(typeof json.currentStage != "undefined") currentStage = json.currentStage;
    if(typeof json.currentPage != "undefined") currentPage = json.currentPage;
    if(typeof json.progressPercentage != "undefined") progressPercentage = json.progressPercentage;
    if(typeof json.isGameInProgress != "undefined") isGameInProgress = json.isGameInProgress;
    if(typeof json.hasGameEnded != "undefined") hasGameEnded = json.hasGameEnded;
    if(typeof json.religionImageSelected != "undefined") religionImageSelected = json.religionImageSelected;
    if(typeof json.religionNameSelected != "undefined") religionNameSelected = json.religionNameSelected;
    if(typeof json.areCardsMatched != "undefined") areCardsMatched = json.areCardsMatched;
    if(typeof json.questionNumbers != "undefined") questionNumbers = json.questionNumbers;
    if(typeof json.questionAttempts != "undefined") questionAttempts = json.questionAttempts;
  };

  function _unserialize(json) { return _model.unserialize(json); }

  _model.addToReset(function() {
    __pagesEnabled["init"] = true;
    __pagesEnabled["pageNavigation"] = true;
    __pagesEnabled["copyRight"] = true;
  });

  _model.addToReset(function() {
    currentStage = 1; // EjsS Model.Variables.game.currentStage
    currentPage = "introduction"; // EjsS Model.Variables.game.currentPage
    progressPercentage = 0; // EjsS Model.Variables.game.progressPercentage
    isGameInProgress = false; // EjsS Model.Variables.game.isGameInProgress
    hasGameEnded = false; // EjsS Model.Variables.game.hasGameEnded
  });

  _model.addToReset(function() {
    religionImageSelected = ""; // EjsS Model.Variables.religion.religionImageSelected
    religionNameSelected = ""; // EjsS Model.Variables.religion.religionNameSelected
    areCardsMatched = { 		hinduism: false, 		judaism: false, 		zoroastrian: false, 		buddhism: false, 		taoism: false, 		jainism: false, 		christianity: false, 		islam: false, 		sikhism: false, 		bahai: false, 	}; // EjsS Model.Variables.religion.areCardsMatched
    questionNumbers = { 		hinduism: 3, 		judaism: 1, 		zoroastrian: 2, 		buddhism: 6, 		taoism: 5, 		jainism: 4, 		christianity: 10, 		islam: 9, 		sikhism: 7, 		bahai: 8, 	}; // EjsS Model.Variables.religion.questionNumbers
    questionAttempts = { 		hinduism: 1, 		judaism: 1, 		zoroastrian: 1, 		buddhism: 1, 		taoism: 1, 		jainism: 1, 		christianity: 1, 		islam: 1, 		sikhism: 1, 		bahai: 1 	}; // EjsS Model.Variables.religion.questionAttempts
  });

  if (_inputParameters) {
    _inputParameters = _model.parseInputParameters(_inputParameters);
    if (_inputParameters) _model.addToReset(function() { _model._readParameters(_inputParameters); });
  }

  _model.addToReset(function() {
    _model.setAutoplay(false);
    _model.setFPS(1);
    _model.setStepsPerDisplay(1);
  });

  // Assume ECMAScript 6; Chrome >=49, Edge >=14, Firefox >=41, Opera >=36, Safari >=8  // > CustomCode.MoodleDataAnalyticsLibrary:1
  // code repository: https://github.com/lookang/codesforejss/blob/master/assessment/questionLib.js  // > CustomCode.MoodleDataAnalyticsLibrary:2
  // documentation: https://weelookang.blogspot.com/2022/11/questionlibjsmakeassessmentjsonpy.html  // > CustomCode.MoodleDataAnalyticsLibrary:3
  const debugMode = true;  // > CustomCode.MoodleDataAnalyticsLibrary:4
  const _questionLib = {};  // > CustomCode.MoodleDataAnalyticsLibrary:5
  _questionLib.stack = [];  // > CustomCode.MoodleDataAnalyticsLibrary:6
  _questionLib.history = Object.create(null);  // > CustomCode.MoodleDataAnalyticsLibrary:7
  _questionLib.questionMarksAwarded = Object.create(null);  // > CustomCode.MoodleDataAnalyticsLibrary:8
  const _nullFunction = debugMode ?  // > CustomCode.MoodleDataAnalyticsLibrary:9
    console.log  // > CustomCode.MoodleDataAnalyticsLibrary:10
    :  // > CustomCode.MoodleDataAnalyticsLibrary:11
    function(){};  // > CustomCode.MoodleDataAnalyticsLibrary:12
  function _debugPrint(msg) {  // > CustomCode.MoodleDataAnalyticsLibrary:13
    if (debugMode) {  // > CustomCode.MoodleDataAnalyticsLibrary:14
      console.log(msg);  // > CustomCode.MoodleDataAnalyticsLibrary:15
    }  // > CustomCode.MoodleDataAnalyticsLibrary:16
  }  // > CustomCode.MoodleDataAnalyticsLibrary:17
  function _getCurrentQuestion() {  // > CustomCode.MoodleDataAnalyticsLibrary:18
    if (!isQuestionStarted()) {  // > CustomCode.MoodleDataAnalyticsLibrary:19
      return null;  // > CustomCode.MoodleDataAnalyticsLibrary:20
    }  // > CustomCode.MoodleDataAnalyticsLibrary:21
    return _questionLib.stack[_questionLib.stack.length - 1];  // > CustomCode.MoodleDataAnalyticsLibrary:22
  }  // > CustomCode.MoodleDataAnalyticsLibrary:23
  function isQuestionStarted() {  // > CustomCode.MoodleDataAnalyticsLibrary:24
    /*  // > CustomCode.MoodleDataAnalyticsLibrary:25
     * Use this function to determine whether a question is pending (has started but has not ended).  // > CustomCode.MoodleDataAnalyticsLibrary:26
     *   // > CustomCode.MoodleDataAnalyticsLibrary:27
     * No Parameters  // > CustomCode.MoodleDataAnalyticsLibrary:28
     *  // > CustomCode.MoodleDataAnalyticsLibrary:29
     * return value:  // > CustomCode.MoodleDataAnalyticsLibrary:30
     * Boolean  // > CustomCode.MoodleDataAnalyticsLibrary:31
     */  // > CustomCode.MoodleDataAnalyticsLibrary:32
    return _questionLib.stack.length > 0;  // > CustomCode.MoodleDataAnalyticsLibrary:33
  }  // > CustomCode.MoodleDataAnalyticsLibrary:34
  // for assessment.json event - start  // > CustomCode.MoodleDataAnalyticsLibrary:35
  function startQuestion(questionName) {  // > CustomCode.MoodleDataAnalyticsLibrary:36
    /*  // > CustomCode.MoodleDataAnalyticsLibrary:37
     * This function should be called whenever the student first sees the question,   // > CustomCode.MoodleDataAnalyticsLibrary:38
     * and the student cannot start answering any other question. The question may be subsequently   // > CustomCode.MoodleDataAnalyticsLibrary:39
     * ended by calling endQuestion function.  // > CustomCode.MoodleDataAnalyticsLibrary:40
     *   // > CustomCode.MoodleDataAnalyticsLibrary:41
     * Parameters:  // > CustomCode.MoodleDataAnalyticsLibrary:42
     * questionName: string  // > CustomCode.MoodleDataAnalyticsLibrary:43
     *  // > CustomCode.MoodleDataAnalyticsLibrary:44
     * return value:  // > CustomCode.MoodleDataAnalyticsLibrary:45
     * undefined  // > CustomCode.MoodleDataAnalyticsLibrary:46
     */  // > CustomCode.MoodleDataAnalyticsLibrary:47
    _view._addInteraction(_nullFunction, {action:"questionStart", name:questionName}, {element:"questionLib", property:"value"});  // > CustomCode.MoodleDataAnalyticsLibrary:48
    _debugPrint("Start question: " + questionName);  // > CustomCode.MoodleDataAnalyticsLibrary:49
      // > CustomCode.MoodleDataAnalyticsLibrary:50
    _questionLib.stack.push(questionName);  // > CustomCode.MoodleDataAnalyticsLibrary:51
  }  // > CustomCode.MoodleDataAnalyticsLibrary:52
  // for assessment.json event - end  // > CustomCode.MoodleDataAnalyticsLibrary:53
  function endQuestion() {  // > CustomCode.MoodleDataAnalyticsLibrary:54
    /*  // > CustomCode.MoodleDataAnalyticsLibrary:55
     * This function should be called whenever the student submits/finalises their answer for the question.  // > CustomCode.MoodleDataAnalyticsLibrary:56
     *   // > CustomCode.MoodleDataAnalyticsLibrary:57
     * No Parameters  // > CustomCode.MoodleDataAnalyticsLibrary:58
     *  // > CustomCode.MoodleDataAnalyticsLibrary:59
     * return value:  // > CustomCode.MoodleDataAnalyticsLibrary:60
     * undefined  // > CustomCode.MoodleDataAnalyticsLibrary:61
     */  // > CustomCode.MoodleDataAnalyticsLibrary:62
    if (_questionLib.stack.length > 0) {  // > CustomCode.MoodleDataAnalyticsLibrary:63
      const questionName = _questionLib.stack.pop();  // > CustomCode.MoodleDataAnalyticsLibrary:64
      _debugPrint("End question: " + questionName);  // > CustomCode.MoodleDataAnalyticsLibrary:65
      _view._addInteraction(_nullFunction, {action:"questionEnd", name:questionName}, {element: "questionLib", property: "value"});  // > CustomCode.MoodleDataAnalyticsLibrary:66
    }  // > CustomCode.MoodleDataAnalyticsLibrary:67
  }  // > CustomCode.MoodleDataAnalyticsLibrary:68
  // for assessment.json history  // > CustomCode.MoodleDataAnalyticsLibrary:69
  function addQuestionHistory(history, questionName=null) {  // > CustomCode.MoodleDataAnalyticsLibrary:70
    /*  // > CustomCode.MoodleDataAnalyticsLibrary:71
     * Adds an entry to the question history to the specified question, or to the pending question by default.   // > CustomCode.MoodleDataAnalyticsLibrary:72
     * If adding to the question history of the pending question, it also flushes the history. (which makes Moodle able to read the history)  // > CustomCode.MoodleDataAnalyticsLibrary:73
     *  // > CustomCode.MoodleDataAnalyticsLibrary:74
     * Parameters:  // > CustomCode.MoodleDataAnalyticsLibrary:75
     * history: string, questionName?: string  // > CustomCode.MoodleDataAnalyticsLibrary:76
     *  // > CustomCode.MoodleDataAnalyticsLibrary:77
     * return value:  // > CustomCode.MoodleDataAnalyticsLibrary:78
     * undefined  // > CustomCode.MoodleDataAnalyticsLibrary:79
     *  // > CustomCode.MoodleDataAnalyticsLibrary:80
     * questioName:  // > CustomCode.MoodleDataAnalyticsLibrary:81
     * This is the name of the question that the history will be added to. If this parameter is not set, by default, the history entry  // > CustomCode.MoodleDataAnalyticsLibrary:82
     * will be added to the pending question.  // > CustomCode.MoodleDataAnalyticsLibrary:83
     */  // > CustomCode.MoodleDataAnalyticsLibrary:84
      // > CustomCode.MoodleDataAnalyticsLibrary:85
    if (questionName === null && isQuestionStarted()) {  // > CustomCode.MoodleDataAnalyticsLibrary:86
      questionName = _getCurrentQuestion();  // > CustomCode.MoodleDataAnalyticsLibrary:87
    }  // > CustomCode.MoodleDataAnalyticsLibrary:88
      // > CustomCode.MoodleDataAnalyticsLibrary:89
    if (!(questionName in _questionLib.history)) {  // > CustomCode.MoodleDataAnalyticsLibrary:90
      _debugPrint("Create question history for " + questionName);  // > CustomCode.MoodleDataAnalyticsLibrary:91
        // > CustomCode.MoodleDataAnalyticsLibrary:92
      _questionLib.history[questionName] = [];  // > CustomCode.MoodleDataAnalyticsLibrary:93
    }  // > CustomCode.MoodleDataAnalyticsLibrary:94
    if (debugMode) {  // > CustomCode.MoodleDataAnalyticsLibrary:95
      console.log("Push \"" + history + "\" to question history for " + questionName);  // > CustomCode.MoodleDataAnalyticsLibrary:96
    }  // > CustomCode.MoodleDataAnalyticsLibrary:97
    _questionLib.history[questionName].push(history);  // > CustomCode.MoodleDataAnalyticsLibrary:98
    _flushQuestionHistory(questionName);  // > CustomCode.MoodleDataAnalyticsLibrary:99
  }  // > CustomCode.MoodleDataAnalyticsLibrary:100
  function _flushQuestionHistory(questionName) {  // > CustomCode.MoodleDataAnalyticsLibrary:101
    // TODO: check if need to flush  // > CustomCode.MoodleDataAnalyticsLibrary:102
    if (questionName === _getCurrentQuestion()) {  // > CustomCode.MoodleDataAnalyticsLibrary:103
      const outputHistory = _getQuestionHistory(questionName);  // > CustomCode.MoodleDataAnalyticsLibrary:104
      _view._addInteraction(_nullFunction, outputHistory, {property: "historyFor" + questionName, element: "questionLib"});  // > CustomCode.MoodleDataAnalyticsLibrary:105
    }  // > CustomCode.MoodleDataAnalyticsLibrary:106
  }  // > CustomCode.MoodleDataAnalyticsLibrary:107
  function _getQuestionHistory(questionName) {  // > CustomCode.MoodleDataAnalyticsLibrary:108
    if (questionName in _questionLib.history) {  // > CustomCode.MoodleDataAnalyticsLibrary:109
      return _questionLib.history[questionName].join("\n");  // > CustomCode.MoodleDataAnalyticsLibrary:110
    } else {  // > CustomCode.MoodleDataAnalyticsLibrary:111
      _debugPrint("No question \"" + questionName + "\" exists");  // > CustomCode.MoodleDataAnalyticsLibrary:112
      return "";  // > CustomCode.MoodleDataAnalyticsLibrary:113
    }  // > CustomCode.MoodleDataAnalyticsLibrary:114
  }  // > CustomCode.MoodleDataAnalyticsLibrary:115
  // for assessment.json event - states  // > CustomCode.MoodleDataAnalyticsLibrary:116
  function onAnswer(answer, isCorrect=false, history=answer, questionName=null) {  // > CustomCode.MoodleDataAnalyticsLibrary:117
    /*  // > CustomCode.MoodleDataAnalyticsLibrary:118
     * Indicates that the student made an attempt to answer the question,   // > CustomCode.MoodleDataAnalyticsLibrary:119
     * writes the history, and adds a log for the submitted answer.   // > CustomCode.MoodleDataAnalyticsLibrary:120
     * However, it does not give marks in itself (that is done by awardQuestionMarks)  // > CustomCode.MoodleDataAnalyticsLibrary:121
     *   // > CustomCode.MoodleDataAnalyticsLibrary:122
     * Parameters:  // > CustomCode.MoodleDataAnalyticsLibrary:123
     * answer: String  // > CustomCode.MoodleDataAnalyticsLibrary:124
     * A string representing what the student chose as the answer to the question.   // > CustomCode.MoodleDataAnalyticsLibrary:125
     * This can be used in an advanced assessment.json generator to check the answers on the server side.  // > CustomCode.MoodleDataAnalyticsLibrary:126
     *  // > CustomCode.MoodleDataAnalyticsLibrary:127
     * isCorrect?: Boolean   // > CustomCode.MoodleDataAnalyticsLibrary:128
     * Whether the student's answer is correct (defaults to false)  // > CustomCode.MoodleDataAnalyticsLibrary:129
     *  // > CustomCode.MoodleDataAnalyticsLibrary:130
     * history: String   // > CustomCode.MoodleDataAnalyticsLibrary:131
     * A textual representation of what the student chose as the answer to the question.   // > CustomCode.MoodleDataAnalyticsLibrary:132
     * By default, this is the same as the value given in the parameter answer.   // > CustomCode.MoodleDataAnalyticsLibrary:133
     * This parameter controls what the teacher will see when they hover their cursor over the student's marks for this question.  // > CustomCode.MoodleDataAnalyticsLibrary:134
     *  // > CustomCode.MoodleDataAnalyticsLibrary:135
     * questionName?: String   // > CustomCode.MoodleDataAnalyticsLibrary:136
     * The name of the question the student is giving an answer to.   // > CustomCode.MoodleDataAnalyticsLibrary:137
     * By default, this is the pending question.   // > CustomCode.MoodleDataAnalyticsLibrary:138
     * However, this can be overridden using this parameter to write the answer history to some other question.  // > CustomCode.MoodleDataAnalyticsLibrary:139
     */  // > CustomCode.MoodleDataAnalyticsLibrary:140
    if (questionName === null && isQuestionStarted()) {  // > CustomCode.MoodleDataAnalyticsLibrary:141
      questionName = _questionLib.stack[_questionLib.stack.length - 1];  // > CustomCode.MoodleDataAnalyticsLibrary:142
    }  // > CustomCode.MoodleDataAnalyticsLibrary:143
    if (questionName !== null) {  // > CustomCode.MoodleDataAnalyticsLibrary:144
      const explainer = Object.create(null);  // > CustomCode.MoodleDataAnalyticsLibrary:145
      explainer[true] = " ✅";  // > CustomCode.MoodleDataAnalyticsLibrary:146
      explainer[false] = " ❌";  // > CustomCode.MoodleDataAnalyticsLibrary:147
      addQuestionHistory(history + explainer[isCorrect], questionName);  // > CustomCode.MoodleDataAnalyticsLibrary:148
      if (questionName === _getCurrentQuestion()) {  // > CustomCode.MoodleDataAnalyticsLibrary:149
        _view._addInteraction(_nullFunction, {name:questionName, answer:answer, isCorrect:isCorrect, action:"questionAnswer"}, {property: "answer", element:"questionLib"});  // > CustomCode.MoodleDataAnalyticsLibrary:150
      }  // > CustomCode.MoodleDataAnalyticsLibrary:151
    }  // > CustomCode.MoodleDataAnalyticsLibrary:152
  }  // > CustomCode.MoodleDataAnalyticsLibrary:153
  // for assessment.json marks  // > CustomCode.MoodleDataAnalyticsLibrary:154
  function awardQuestionMarks(marks=1) {  // > CustomCode.MoodleDataAnalyticsLibrary:155
    /*  // > CustomCode.MoodleDataAnalyticsLibrary:156
     * Awards a number of marks to the student for the pending question.  // > CustomCode.MoodleDataAnalyticsLibrary:157
     *   // > CustomCode.MoodleDataAnalyticsLibrary:158
     * Parameters:  // > CustomCode.MoodleDataAnalyticsLibrary:159
     * marks?: int   // > CustomCode.MoodleDataAnalyticsLibrary:160
     *  // > CustomCode.MoodleDataAnalyticsLibrary:161
     * The number of marks to award to the student. By default, this value is 1.  // > CustomCode.MoodleDataAnalyticsLibrary:162
     */  // > CustomCode.MoodleDataAnalyticsLibrary:163
    if (isQuestionStarted()) {  // > CustomCode.MoodleDataAnalyticsLibrary:164
      const questionName = _getCurrentQuestion();  // > CustomCode.MoodleDataAnalyticsLibrary:165
      _questionLib.questionMarksAwarded[questionName] = 1;  // > CustomCode.MoodleDataAnalyticsLibrary:166
        // > CustomCode.MoodleDataAnalyticsLibrary:167
      for (; _questionLib.questionMarksAwarded[questionName] < marks + 1; _questionLib.questionMarksAwarded[questionName]++) {  // > CustomCode.MoodleDataAnalyticsLibrary:168
        _view._addInteraction(_nullFunction, _questionLib.questionMarksAwarded[questionName], {element:"questionLib", property:"awardMarkFor"+questionName});  // > CustomCode.MoodleDataAnalyticsLibrary:169
      }  // > CustomCode.MoodleDataAnalyticsLibrary:170
    }  // > CustomCode.MoodleDataAnalyticsLibrary:171
  }  // > CustomCode.MoodleDataAnalyticsLibrary:172
  function resetQuestionMarks(questionName) {  // > CustomCode.MoodleDataAnalyticsLibrary:173
    /*  // > CustomCode.MoodleDataAnalyticsLibrary:174
     * Reset the awarded marks for the indicated question to 0 the next time the question is started.  // > CustomCode.MoodleDataAnalyticsLibrary:175
     *   // > CustomCode.MoodleDataAnalyticsLibrary:176
     * Parameters:   // > CustomCode.MoodleDataAnalyticsLibrary:177
     * questionName: string  // > CustomCode.MoodleDataAnalyticsLibrary:178
     *  // > CustomCode.MoodleDataAnalyticsLibrary:179
     * return value:   // > CustomCode.MoodleDataAnalyticsLibrary:180
     * undefined  // > CustomCode.MoodleDataAnalyticsLibrary:181
     *  // > CustomCode.MoodleDataAnalyticsLibrary:182
     * questionName:  // > CustomCode.MoodleDataAnalyticsLibrary:183
     * The name of the question to reset.  // > CustomCode.MoodleDataAnalyticsLibrary:184
     */  // > CustomCode.MoodleDataAnalyticsLibrary:185
    _questionLib.questionMarksAwarded[questionName] = 0;  // > CustomCode.MoodleDataAnalyticsLibrary:186
  }  // > CustomCode.MoodleDataAnalyticsLibrary:187
  function questionInstantMark(questionName, message) {  // > CustomCode.MoodleDataAnalyticsLibrary:188
    /*  // > CustomCode.MoodleDataAnalyticsLibrary:189
     * A convenience function to start a question, award a mark, (optionally) add a history entry, and end the question.  // > CustomCode.MoodleDataAnalyticsLibrary:190
     * This function should be called whenever a student answers a question correctly.  // > CustomCode.MoodleDataAnalyticsLibrary:191
     * It instantly submits the correct answer to the Moodle server, and gives the student a mark.   // > CustomCode.MoodleDataAnalyticsLibrary:192
     * For most cases, this function would suffice.  // > CustomCode.MoodleDataAnalyticsLibrary:193
     *   // > CustomCode.MoodleDataAnalyticsLibrary:194
     * Parameters:   // > CustomCode.MoodleDataAnalyticsLibrary:195
     * questionName: string, message?: string  // > CustomCode.MoodleDataAnalyticsLibrary:196
     *  // > CustomCode.MoodleDataAnalyticsLibrary:197
     * return value:   // > CustomCode.MoodleDataAnalyticsLibrary:198
     * undefined  // > CustomCode.MoodleDataAnalyticsLibrary:199
     *  // > CustomCode.MoodleDataAnalyticsLibrary:200
     * questionName:  // > CustomCode.MoodleDataAnalyticsLibrary:201
     * These values are the names of the questions that will be displayed on the analytics page on Moodle,   // > CustomCode.MoodleDataAnalyticsLibrary:202
     * and they'll be needed when you make the assessment.json file so please remember to note down what   // > CustomCode.MoodleDataAnalyticsLibrary:203
     * values you use for the name of each question.  // > CustomCode.MoodleDataAnalyticsLibrary:204
     *   // > CustomCode.MoodleDataAnalyticsLibrary:205
     * message:   // > CustomCode.MoodleDataAnalyticsLibrary:206
     * What Moodle will display when the teacher hovers their mouse over the student's mark for a particular question.  // > CustomCode.MoodleDataAnalyticsLibrary:207
     */  // > CustomCode.MoodleDataAnalyticsLibrary:208
    startQuestion(questionName);  // > CustomCode.MoodleDataAnalyticsLibrary:209
    _debugPrint("" + message);  // > CustomCode.MoodleDataAnalyticsLibrary:210
    if (message) {  // > CustomCode.MoodleDataAnalyticsLibrary:211
      addQuestionHistory(message);  // > CustomCode.MoodleDataAnalyticsLibrary:212
    } else {  // > CustomCode.MoodleDataAnalyticsLibrary:213
      _flushQuestionHistory(questionName);  // > CustomCode.MoodleDataAnalyticsLibrary:214
    }  // > CustomCode.MoodleDataAnalyticsLibrary:215
    awardQuestionMarks();  // > CustomCode.MoodleDataAnalyticsLibrary:216
    endQuestion();  // > CustomCode.MoodleDataAnalyticsLibrary:217
  }  // > CustomCode.MoodleDataAnalyticsLibrary:218
  function questionAppendHistory(questionName, message) {  // > CustomCode.MoodleDataAnalyticsLibrary:219
    /*  // > CustomCode.MoodleDataAnalyticsLibrary:220
     * Adds a history entry to the given question.  // > CustomCode.MoodleDataAnalyticsLibrary:221
     *   // > CustomCode.MoodleDataAnalyticsLibrary:222
     * Parameters:   // > CustomCode.MoodleDataAnalyticsLibrary:223
     * questionName: string, message?: string  // > CustomCode.MoodleDataAnalyticsLibrary:224
     *  // > CustomCode.MoodleDataAnalyticsLibrary:225
     * return value:   // > CustomCode.MoodleDataAnalyticsLibrary:226
     * undefined  // > CustomCode.MoodleDataAnalyticsLibrary:227
     *  // > CustomCode.MoodleDataAnalyticsLibrary:228
     * questionName:  // > CustomCode.MoodleDataAnalyticsLibrary:229
     * The name of the question to append the history entry to.  // > CustomCode.MoodleDataAnalyticsLibrary:230
     *   // > CustomCode.MoodleDataAnalyticsLibrary:231
     * message:  // > CustomCode.MoodleDataAnalyticsLibrary:232
     * The history entry to add to the question.  // > CustomCode.MoodleDataAnalyticsLibrary:233
     */  // > CustomCode.MoodleDataAnalyticsLibrary:234
    if (!(questionName in _questionLib.questionMarksAwarded)) {  // > CustomCode.MoodleDataAnalyticsLibrary:235
      _questionLib.questionMarksAwarded[questionName] = 0;  // > CustomCode.MoodleDataAnalyticsLibrary:236
    }  // > CustomCode.MoodleDataAnalyticsLibrary:237
    let shouldPushQuestion = _getCurrentQuestion() !== questionName;  // > CustomCode.MoodleDataAnalyticsLibrary:238
    if (shouldPushQuestion) {  // > CustomCode.MoodleDataAnalyticsLibrary:239
      startQuestion(questionName);  // > CustomCode.MoodleDataAnalyticsLibrary:240
    }  // > CustomCode.MoodleDataAnalyticsLibrary:241
    awardQuestionMarks(_questionLib.questionMarksAwarded[questionName])  // > CustomCode.MoodleDataAnalyticsLibrary:242
    addQuestionHistory(message);  // > CustomCode.MoodleDataAnalyticsLibrary:243
    if (shouldPushQuestion) {  // > CustomCode.MoodleDataAnalyticsLibrary:244
      endQuestion();  // > CustomCode.MoodleDataAnalyticsLibrary:245
    }  // > CustomCode.MoodleDataAnalyticsLibrary:246
  }  // > CustomCode.MoodleDataAnalyticsLibrary:247
  function resetQuestionHistory(questionName) {  // > CustomCode.MoodleDataAnalyticsLibrary:248
    /*  // > CustomCode.MoodleDataAnalyticsLibrary:249
     * Clear/reset the history of the indicated question.  // > CustomCode.MoodleDataAnalyticsLibrary:250
     *   // > CustomCode.MoodleDataAnalyticsLibrary:251
     * Parameters:   // > CustomCode.MoodleDataAnalyticsLibrary:252
     * questionName: string  // > CustomCode.MoodleDataAnalyticsLibrary:253
     *  // > CustomCode.MoodleDataAnalyticsLibrary:254
     * return value:   // > CustomCode.MoodleDataAnalyticsLibrary:255
     * undefined  // > CustomCode.MoodleDataAnalyticsLibrary:256
     *  // > CustomCode.MoodleDataAnalyticsLibrary:257
     * questionName:  // > CustomCode.MoodleDataAnalyticsLibrary:258
     * The name of the question to reset.  // > CustomCode.MoodleDataAnalyticsLibrary:259
     */    // > CustomCode.MoodleDataAnalyticsLibrary:260
    _questionLib.history[questionName] = [];  // > CustomCode.MoodleDataAnalyticsLibrary:261
  }  // > CustomCode.MoodleDataAnalyticsLibrary:262
  function resetQuestion(questionName) {  // > CustomCode.MoodleDataAnalyticsLibrary:263
    /*  // > CustomCode.MoodleDataAnalyticsLibrary:264
     * A convenience function to reset the marks and history of an indicated question.  // > CustomCode.MoodleDataAnalyticsLibrary:265
     */    // > CustomCode.MoodleDataAnalyticsLibrary:266
    resetQuestionHistory(questionName);  // > CustomCode.MoodleDataAnalyticsLibrary:267
    resetQuestionMarks(questionName);  // > CustomCode.MoodleDataAnalyticsLibrary:268
  }  // > CustomCode.MoodleDataAnalyticsLibrary:269

  function createMatchingFunctionality () {  // > CustomCode.cardMatchingFunctionality:1
    disableRadioButtons(".religion-names input");    // > CustomCode.cardMatchingFunctionality:2
    createReligionImagesFunctionality();  // > CustomCode.cardMatchingFunctionality:3
    createReligionNamesFunctionality();  // > CustomCode.cardMatchingFunctionality:4
  };  // > CustomCode.cardMatchingFunctionality:5
  function createReligionImagesFunctionality () {  // > CustomCode.cardMatchingFunctionality:6
    var cards = document.getElementsByName("card");  // > CustomCode.cardMatchingFunctionality:7
      // > CustomCode.cardMatchingFunctionality:8
    cards.forEach(function (card) {   // > CustomCode.cardMatchingFunctionality:9
      card.addEventListener("change", function () {  // > CustomCode.cardMatchingFunctionality:10
        // isGameInProgress toggled to true to remove finger instruction  // > CustomCode.cardMatchingFunctionality:11
        if (!isGameInProgress) {  // > CustomCode.cardMatchingFunctionality:12
          isGameInProgress = true;   // > CustomCode.cardMatchingFunctionality:13
          _view._update();  // > CustomCode.cardMatchingFunctionality:14
        }  // > CustomCode.cardMatchingFunctionality:15
        religionImageSelected = this.value;  // > CustomCode.cardMatchingFunctionality:16
          // > CustomCode.cardMatchingFunctionality:17
        // allow students to select name radio after selecting a religion picture  // > CustomCode.cardMatchingFunctionality:18
        enableRadioButtons(".religion-labels input");    // > CustomCode.cardMatchingFunctionality:19
      });  // > CustomCode.cardMatchingFunctionality:20
    });   // > CustomCode.cardMatchingFunctionality:21
  }  // > CustomCode.cardMatchingFunctionality:22
  function createReligionNamesFunctionality () {  // > CustomCode.cardMatchingFunctionality:23
      // > CustomCode.cardMatchingFunctionality:24
    var matches = document.getElementsByName("match");  // > CustomCode.cardMatchingFunctionality:25
      // > CustomCode.cardMatchingFunctionality:26
    matches.forEach(function (match) {  // > CustomCode.cardMatchingFunctionality:27
      match.addEventListener("change", function () {  // > CustomCode.cardMatchingFunctionality:28
        religionNameSelected = this.value;  // > CustomCode.cardMatchingFunctionality:29
          // > CustomCode.cardMatchingFunctionality:30
        // prevent students to retry questions that have been answered correctly  // > CustomCode.cardMatchingFunctionality:31
        if (areCardsMatched[religionImageSelected]) {  // > CustomCode.cardMatchingFunctionality:32
          disableRadioButtons(".religion-labels input");  // > CustomCode.cardMatchingFunctionality:33
          unCheckRadioButtons(".religion-pictures input");  // > CustomCode.cardMatchingFunctionality:34
          unCheckRadioButtons(".religion-labels input");   // > CustomCode.cardMatchingFunctionality:35
            // > CustomCode.cardMatchingFunctionality:36
          return;  // > CustomCode.cardMatchingFunctionality:37
        }  // > CustomCode.cardMatchingFunctionality:38
          // > CustomCode.cardMatchingFunctionality:39
        // fires when student answers correctly  // > CustomCode.cardMatchingFunctionality:40
        if (religionImageSelected === religionNameSelected) {  // > CustomCode.cardMatchingFunctionality:41
            areCardsMatched[religionImageSelected] = true;  // > CustomCode.cardMatchingFunctionality:42
            drawConnectorLines(religionNameSelected);  // > CustomCode.cardMatchingFunctionality:43
      // > CustomCode.cardMatchingFunctionality:44
                      // > CustomCode.cardMatchingFunctionality:45
            // ============= Moodle submission for marks awarded: Begin =============    // > CustomCode.cardMatchingFunctionality:46
            // submit answer to moodle using library for correct matches here.  // > CustomCode.cardMatchingFunctionality:47
              // > CustomCode.cardMatchingFunctionality:48
            let questionName = `Q${questionNumbers[religionImageSelected]}`; // Q1, Q2, etc..  // > CustomCode.cardMatchingFunctionality:49
            startQuestion(questionName);  // > CustomCode.cardMatchingFunctionality:50
            addQuestionHistory("Selected Image: " + religionImageSelected + ", Selected Name: " + religionNameSelected);  // > CustomCode.cardMatchingFunctionality:51
              // > CustomCode.cardMatchingFunctionality:52
            // if it is student's first attempt,  // > CustomCode.cardMatchingFunctionality:53
            if (questionAttempts[religionNameSelected] == 1) {  // > CustomCode.cardMatchingFunctionality:54
              // award 2 mark  // > CustomCode.cardMatchingFunctionality:55
              _println('2 marks awarded for: ' + questionName);  // > CustomCode.cardMatchingFunctionality:56
              awardQuestionMarks(2);              // > CustomCode.cardMatchingFunctionality:57
            } else {  // > CustomCode.cardMatchingFunctionality:58
              // award 1 mark  // > CustomCode.cardMatchingFunctionality:59
              _println('1 marks awarded for: ' + questionName);  // > CustomCode.cardMatchingFunctionality:60
              awardQuestionMarks(1);              // > CustomCode.cardMatchingFunctionality:61
            }       // > CustomCode.cardMatchingFunctionality:62
            endQuestion();  // > CustomCode.cardMatchingFunctionality:63
             // > CustomCode.cardMatchingFunctionality:64
            // ============= Moodle submission for marks awarded: End =============         // > CustomCode.cardMatchingFunctionality:65
              // > CustomCode.cardMatchingFunctionality:66
                      // > CustomCode.cardMatchingFunctionality:67
          // code below runs on correct image - name religion matching  // > CustomCode.cardMatchingFunctionality:68
          _view.correctSound.play();  // > CustomCode.cardMatchingFunctionality:69
            // > CustomCode.cardMatchingFunctionality:70
          let openAprosImage = '<img src="cross_cultural/assets/images/open_apros.svg" alt="open aprostrophy" />';  // > CustomCode.cardMatchingFunctionality:71
          let closeAprosImage = '<img src="cross_cultural/assets/images/close_apros.svg" alt="close aprostrophy" />';  // > CustomCode.cardMatchingFunctionality:72
          // > CustomCode.cardMatchingFunctionality:73
          switch (religionImageSelected) {  // > CustomCode.cardMatchingFunctionality:74
            case "hinduism":  // > CustomCode.cardMatchingFunctionality:75
            updateReligionDescriptionModal('HINDUISM', openAprosImage +  // > CustomCode.cardMatchingFunctionality:76
                                           'The majority of Hindus are vegetarians. Some are non-vegetarians but ' +  // > CustomCode.cardMatchingFunctionality:77
                                           'avoid beef and pork.'+  // > CustomCode.cardMatchingFunctionality:78
                                           closeAprosImage);  // > CustomCode.cardMatchingFunctionality:79
                                                    // > CustomCode.cardMatchingFunctionality:80
            // religion image and name radios remains highlighted pink after a match  // > CustomCode.cardMatchingFunctionality:81
            document.getElementById('hinduismIcon').classList.add('correctly-matched');  // > CustomCode.cardMatchingFunctionality:82
            document.getElementById('hinduismText').classList.add('correctly-matched');           // > CustomCode.cardMatchingFunctionality:83
            break;  // > CustomCode.cardMatchingFunctionality:84
            case "judaism":  // > CustomCode.cardMatchingFunctionality:85
            updateReligionDescriptionModal('JUDAISM', openAprosImage +  // > CustomCode.cardMatchingFunctionality:86
                                           'Food that conforms to the Jewish dietary law is called Kosher. Only meals,' +  // > CustomCode.cardMatchingFunctionality:87
                                           'which have been prepared in accordance with the kosher dietary laws,' +  // > CustomCode.cardMatchingFunctionality:88
                                           'should be served. All processed foods such as wine, bread and cheese as '+  // > CustomCode.cardMatchingFunctionality:89
                                           'well as meats must be strictly kosher. Such food is marked with a hechsher '+  // > CustomCode.cardMatchingFunctionality:90
                                           '(Kosher supervision seal), which certifies it as kosher.'+  // > CustomCode.cardMatchingFunctionality:91
                                           closeAprosImage);  // > CustomCode.cardMatchingFunctionality:92
            document.getElementById('judaismIcon').classList.add('correctly-matched');  // > CustomCode.cardMatchingFunctionality:93
            document.getElementById('judaismText').classList.add('correctly-matched');    // > CustomCode.cardMatchingFunctionality:94
            break;  // > CustomCode.cardMatchingFunctionality:95
            case "zoroastrian":  // > CustomCode.cardMatchingFunctionality:96
            updateReligionDescriptionModal('ZOROASTRIANISM', openAprosImage +  // > CustomCode.cardMatchingFunctionality:97
                                           'Zoroastrians have no dietary restrictions. They also do not fast, as the ' +  // > CustomCode.cardMatchingFunctionality:98
                                           'religion teaches them, that the body must be well nourished to be able to ' +  // > CustomCode.cardMatchingFunctionality:99
                                           'work and live a healthy life.' +  // > CustomCode.cardMatchingFunctionality:100
                                           closeAprosImage);  // > CustomCode.cardMatchingFunctionality:101
            document.getElementById('zoroastrianIcon').classList.add('correctly-matched');  // > CustomCode.cardMatchingFunctionality:102
            document.getElementById('zoroastrianText').classList.add('correctly-matched');              // > CustomCode.cardMatchingFunctionality:103
            break;  // > CustomCode.cardMatchingFunctionality:104
            case "buddhism":  // > CustomCode.cardMatchingFunctionality:105
            updateReligionDescriptionModal('BUDDHISM', openAprosImage +   // > CustomCode.cardMatchingFunctionality:106
                                           'A vegetarian diet is promoted especially on the 1st and 15th days of the ' +  // > CustomCode.cardMatchingFunctionality:107
                                           'lunar month for Buddhists. Monks and nuns as well as lay people who have ' +  // > CustomCode.cardMatchingFunctionality:108
                                           'taken the Five Precepts abstain from intoxicants. Monks and nuns in the ' +  // > CustomCode.cardMatchingFunctionality:109
                                           'Chinese Mahayana traditions are vegetarians and the diet is free from ' +  // > CustomCode.cardMatchingFunctionality:110
                                           'garlic, onion, spring onions, leeks, shallots and eggs.' +  // > CustomCode.cardMatchingFunctionality:111
                                           closeAprosImage);  // > CustomCode.cardMatchingFunctionality:112
            document.getElementById('buddhismIcon').classList.add('correctly-matched');  // > CustomCode.cardMatchingFunctionality:113
            document.getElementById('buddhismText').classList.add('correctly-matched');     // > CustomCode.cardMatchingFunctionality:114
            break;  // > CustomCode.cardMatchingFunctionality:115
            case "taoism":  // > CustomCode.cardMatchingFunctionality:116
            updateReligionDescriptionModal('TAOISM', openAprosImage +   // > CustomCode.cardMatchingFunctionality:117
                                           'Taoists are encouraged to observe a vegetarian diet on festive occasions ' +  // > CustomCode.cardMatchingFunctionality:118
                                           'and feast days. Some priests are strict vegetarians and avoid even salt, ' +  // > CustomCode.cardMatchingFunctionality:119
                                           'vinegar, leeks, shallots, garlic and onions during special prayers to ' +  // > CustomCode.cardMatchingFunctionality:120
                                           'celebrate the occasion.' +   // > CustomCode.cardMatchingFunctionality:121
                                           closeAprosImage);  // > CustomCode.cardMatchingFunctionality:122
            document.getElementById('taoismIcon').classList.add('correctly-matched');  // > CustomCode.cardMatchingFunctionality:123
            document.getElementById('taoismText').classList.add('correctly-matched');                // > CustomCode.cardMatchingFunctionality:124
            break;  // > CustomCode.cardMatchingFunctionality:125
            case "jainism":  // > CustomCode.cardMatchingFunctionality:126
            updateReligionDescriptionModal('JAINISM', openAprosImage +   // > CustomCode.cardMatchingFunctionality:127
                                           'Jains are strict vegetarians. Any type of non-vegetarian food is not ' +  // > CustomCode.cardMatchingFunctionality:128
                                           'permitted. On auspicious religious days, Jains also abstain from the ' +  // > CustomCode.cardMatchingFunctionality:129
                                           'consumption of roots of plants. The consumption of alcohol, drugs, and ' +  // > CustomCode.cardMatchingFunctionality:130
                                           'cigarettes are also forbidden. The basis of such a diet is the strong belief of ' +  // > CustomCode.cardMatchingFunctionality:131
                                           'Jains in Ahimsa or non-violence.' +  // > CustomCode.cardMatchingFunctionality:132
                                           closeAprosImage);  // > CustomCode.cardMatchingFunctionality:133
            document.getElementById('jainismIcon').classList.add('correctly-matched');  // > CustomCode.cardMatchingFunctionality:134
            document.getElementById('jainismText').classList.add('correctly-matched');     // > CustomCode.cardMatchingFunctionality:135
            break;  // > CustomCode.cardMatchingFunctionality:136
            case "christianity":  // > CustomCode.cardMatchingFunctionality:137
            updateReligionDescriptionModal('CHRISTIANITY', openAprosImage +   // > CustomCode.cardMatchingFunctionality:138
                                           'On Fridays, Catholics usually abstain from eating meat (this does not ' +  // > CustomCode.cardMatchingFunctionality:139
                                           'include fish and seafood), as an act of penance to remember Christ’s ' +  // > CustomCode.cardMatchingFunctionality:140
                                           'sacrificial death on the cross for their sins. Most members of other ' +  // > CustomCode.cardMatchingFunctionality:141
                                           'alcoholic beverages. Non-Christians should not take personal offence ' +  // > CustomCode.cardMatchingFunctionality:142
                                           'when some Christians refrain from eating food that has been prayed over ' +  // > CustomCode.cardMatchingFunctionality:143
                                           'or offered to deities.' +  // > CustomCode.cardMatchingFunctionality:144
                                           closeAprosImage);  // > CustomCode.cardMatchingFunctionality:145
            document.getElementById('christianityIcon').classList.add('correctly-matched');  // > CustomCode.cardMatchingFunctionality:146
            document.getElementById('christianityText').classList.add('correctly-matched');  // > CustomCode.cardMatchingFunctionality:147
            break;  // > CustomCode.cardMatchingFunctionality:148
            case "islam":  // > CustomCode.cardMatchingFunctionality:149
            updateReligionDescriptionModal('ISLAM', openAprosImage +   // > CustomCode.cardMatchingFunctionality:150
                                           'Ideally halal food has to be tayyib (wholesome and healthy), and prepared ' +  // > CustomCode.cardMatchingFunctionality:151
                                           'with utensils that have not been in contact with haram (forbidden foods), ' +  // > CustomCode.cardMatchingFunctionality:152
                                           'which could include pork and blood, and with drinks containing alcohol. ' +  // > CustomCode.cardMatchingFunctionality:153
                                           'Muslims are forbidden to eat meats that have been ritually dedicated to ' +  // > CustomCode.cardMatchingFunctionality:154
                                           'things, or beings. Most Muslims are concerned that any meat served must ' +  // > CustomCode.cardMatchingFunctionality:155
                                           'be prepared in accordance with Islamic slaughter rites. Generally, Muslims ' +  // > CustomCode.cardMatchingFunctionality:156
                                           'are happy to have vegetarian food that has no alcohol, meat or by-' +  // > CustomCode.cardMatchingFunctionality:157
                                           'products such as animal gelatin. Such purely vegetarian food can be ' +  // > CustomCode.cardMatchingFunctionality:158
                                           'considered as halal.' +  // > CustomCode.cardMatchingFunctionality:159
                                           closeAprosImage);  // > CustomCode.cardMatchingFunctionality:160
            document.getElementById('islamIcon').classList.add('correctly-matched');  // > CustomCode.cardMatchingFunctionality:161
            document.getElementById('islamText').classList.add('correctly-matched');  // > CustomCode.cardMatchingFunctionality:162
            break;  // > CustomCode.cardMatchingFunctionality:163
            case "sikhism":  // > CustomCode.cardMatchingFunctionality:164
            updateReligionDescriptionModal('SIKHISM', openAprosImage +   // > CustomCode.cardMatchingFunctionality:165
                                           'Only vegetarian meals are prepared and served for consumption in the ' +  // > CustomCode.cardMatchingFunctionality:166
                                           'gurdwara. Meat consumed is of an animal that has been killed instantly with ' +  // > CustomCode.cardMatchingFunctionality:167
                                           'one stroke. Consumption of intoxicants, smoking tobacco and the use of ' +  // > CustomCode.cardMatchingFunctionality:168
                                           'drugs, alcohol and meat are forbidden in the temple precincts. Sikhs are not ' +  // > CustomCode.cardMatchingFunctionality:169
                                           'vegetarians, but Sikh teachings exhort that a Sikh must “<i>Avoid food and ' +  // > CustomCode.cardMatchingFunctionality:170
                                           'clothing which harm the body or provoke evil thoughts.</i>” (Sri Rag Ml, 16)' +  // > CustomCode.cardMatchingFunctionality:171
                                           closeAprosImage);  // > CustomCode.cardMatchingFunctionality:172
            document.getElementById('sikhismIcon').classList.add('correctly-matched');  // > CustomCode.cardMatchingFunctionality:173
            document.getElementById('sikhismText').classList.add('correctly-matched');  // > CustomCode.cardMatchingFunctionality:174
            break;  // > CustomCode.cardMatchingFunctionality:175
            case "bahai":  // > CustomCode.cardMatchingFunctionality:176
            updateReligionDescriptionModal("BAHA'I FAITH", openAprosImage +   // > CustomCode.cardMatchingFunctionality:177
                                           'Bahá’ís are forbidden to consume alcohol and hallucinogenic drugs. The ' +  // > CustomCode.cardMatchingFunctionality:178
                                           'only exception is when the physician prescribes it as a form of medical ' +  // > CustomCode.cardMatchingFunctionality:179
                                           'treatment.' +  // > CustomCode.cardMatchingFunctionality:180
                                           closeAprosImage);  // > CustomCode.cardMatchingFunctionality:181
            document.getElementById('bahaiIcon').classList.add('correctly-matched');  // > CustomCode.cardMatchingFunctionality:182
            document.getElementById('bahaiText').classList.add('correctly-matched');            // > CustomCode.cardMatchingFunctionality:183
            break;  // > CustomCode.cardMatchingFunctionality:184
          }  // > CustomCode.cardMatchingFunctionality:185
            // > CustomCode.cardMatchingFunctionality:186
           // > CustomCode.cardMatchingFunctionality:187
          callFuncAfterSomeSeconds(1.5, showReligionDescriptionModal);     // > CustomCode.cardMatchingFunctionality:188
            // > CustomCode.cardMatchingFunctionality:189
            // > CustomCode.cardMatchingFunctionality:190
        } else {  // > CustomCode.cardMatchingFunctionality:191
          // code below runs on WRONG image - name religion matching  // > CustomCode.cardMatchingFunctionality:192
            // > CustomCode.cardMatchingFunctionality:193
          // adds 1 to total number of attempts  // > CustomCode.cardMatchingFunctionality:194
          questionAttempts[religionImageSelected] += 1;  // > CustomCode.cardMatchingFunctionality:195
          _println(questionAttempts);  // > CustomCode.cardMatchingFunctionality:196
            // > CustomCode.cardMatchingFunctionality:197
          // ============= Moodle submission for question: Begin =============    // > CustomCode.cardMatchingFunctionality:198
            // submit history to moodle using library for incorrect matches here.  // > CustomCode.cardMatchingFunctionality:199
              // > CustomCode.cardMatchingFunctionality:200
            let questionName = `Q${questionNumbers[religionImageSelected]}`; // Q1, Q2, etc..  // > CustomCode.cardMatchingFunctionality:201
            startQuestion(questionName);  // > CustomCode.cardMatchingFunctionality:202
            onAnswer(religionNameSelected, false, "Selected Image: " + religionImageSelected + ", Selected Name: " + religionNameSelected);     // > CustomCode.cardMatchingFunctionality:203
            endQuestion();  // > CustomCode.cardMatchingFunctionality:204
             // > CustomCode.cardMatchingFunctionality:205
            // ============= Moodle submission for marks awarded: End =============    // > CustomCode.cardMatchingFunctionality:206
            // > CustomCode.cardMatchingFunctionality:207
          _view.wrongSound.play();  // > CustomCode.cardMatchingFunctionality:208
            // > CustomCode.cardMatchingFunctionality:209
          disableRadioButtons(".religion-labels input");  // > CustomCode.cardMatchingFunctionality:210
          unCheckRadioButtons(".religion-pictures input");  // > CustomCode.cardMatchingFunctionality:211
          unCheckRadioButtons(".religion-labels input");  // > CustomCode.cardMatchingFunctionality:212
          switch (religionNameSelected) {  // > CustomCode.cardMatchingFunctionality:213
            // display speech bubbles for respective religion names  // > CustomCode.cardMatchingFunctionality:214
              // > CustomCode.cardMatchingFunctionality:215
            case "hinduism":  // > CustomCode.cardMatchingFunctionality:216
            //insert code for speech bubble here  // > CustomCode.cardMatchingFunctionality:217
            document.querySelector('#hinduism-sb').classList.remove('opacity-0');  // > CustomCode.cardMatchingFunctionality:218
            document.querySelector('#hinduism-sb').classList.add('opacity-1');  // > CustomCode.cardMatchingFunctionality:219
            setTimeout(() => {  // > CustomCode.cardMatchingFunctionality:220
              document.querySelector('#hinduism-sb').classList.remove('opacity-1');  // > CustomCode.cardMatchingFunctionality:221
              document.querySelector('#hinduism-sb').classList.add('opacity-0');  // > CustomCode.cardMatchingFunctionality:222
            }, 2500)  // > CustomCode.cardMatchingFunctionality:223
            break;  // > CustomCode.cardMatchingFunctionality:224
            case "judaism":  // > CustomCode.cardMatchingFunctionality:225
            //insert code for speech bubble here  // > CustomCode.cardMatchingFunctionality:226
            document.querySelector('#judaism-sb').classList.remove('opacity-0');  // > CustomCode.cardMatchingFunctionality:227
            document.querySelector('#judaism-sb').classList.add('opacity-1');  // > CustomCode.cardMatchingFunctionality:228
            setTimeout(() => {  // > CustomCode.cardMatchingFunctionality:229
              document.querySelector('#judaism-sb').classList.remove('opacity-1');  // > CustomCode.cardMatchingFunctionality:230
              document.querySelector('#judaism-sb').classList.add('opacity-0');  // > CustomCode.cardMatchingFunctionality:231
            }, 2500)  // > CustomCode.cardMatchingFunctionality:232
            break;  // > CustomCode.cardMatchingFunctionality:233
            case "zoroastrian":  // > CustomCode.cardMatchingFunctionality:234
            //insert code for speech bubble here  // > CustomCode.cardMatchingFunctionality:235
            document.querySelector('#zoroastrian-sb').classList.remove('opacity-0');  // > CustomCode.cardMatchingFunctionality:236
            document.querySelector('#zoroastrian-sb').classList.add('opacity-1');  // > CustomCode.cardMatchingFunctionality:237
            setTimeout(() => {  // > CustomCode.cardMatchingFunctionality:238
              document.querySelector('#zoroastrian-sb').classList.remove('opacity-1');  // > CustomCode.cardMatchingFunctionality:239
              document.querySelector('#zoroastrian-sb').classList.add('opacity-0');  // > CustomCode.cardMatchingFunctionality:240
            }, 2500)  // > CustomCode.cardMatchingFunctionality:241
            break;  // > CustomCode.cardMatchingFunctionality:242
            case "buddhism":  // > CustomCode.cardMatchingFunctionality:243
            //insert code for speech bubble here  // > CustomCode.cardMatchingFunctionality:244
            document.querySelector('#buddhism-sb').classList.remove('opacity-0');  // > CustomCode.cardMatchingFunctionality:245
            document.querySelector('#buddhism-sb').classList.add('opacity-1');  // > CustomCode.cardMatchingFunctionality:246
            setTimeout(() => {  // > CustomCode.cardMatchingFunctionality:247
              document.querySelector('#buddhism-sb').classList.remove('opacity-1');  // > CustomCode.cardMatchingFunctionality:248
              document.querySelector('#buddhism-sb').classList.add('opacity-0');  // > CustomCode.cardMatchingFunctionality:249
            }, 2500)  // > CustomCode.cardMatchingFunctionality:250
            break;  // > CustomCode.cardMatchingFunctionality:251
            case "taoism":  // > CustomCode.cardMatchingFunctionality:252
            //insert code for speech bubble here  // > CustomCode.cardMatchingFunctionality:253
            document.querySelector('#taoism-sb').classList.remove('opacity-0');  // > CustomCode.cardMatchingFunctionality:254
            document.querySelector('#taoism-sb').classList.add('opacity-1');  // > CustomCode.cardMatchingFunctionality:255
            setTimeout(() => {  // > CustomCode.cardMatchingFunctionality:256
              document.querySelector('#taoism-sb').classList.remove('opacity-1');  // > CustomCode.cardMatchingFunctionality:257
              document.querySelector('#taoism-sb').classList.add('opacity-0');  // > CustomCode.cardMatchingFunctionality:258
            }, 2500)  // > CustomCode.cardMatchingFunctionality:259
            break;  // > CustomCode.cardMatchingFunctionality:260
            case "jainism":  // > CustomCode.cardMatchingFunctionality:261
            //insert code for speech bubble here  // > CustomCode.cardMatchingFunctionality:262
            document.querySelector('#jainism-sb').classList.remove('opacity-0');  // > CustomCode.cardMatchingFunctionality:263
            document.querySelector('#jainism-sb').classList.add('opacity-1');  // > CustomCode.cardMatchingFunctionality:264
            setTimeout(() => {  // > CustomCode.cardMatchingFunctionality:265
              document.querySelector('#jainism-sb').classList.remove('opacity-1');  // > CustomCode.cardMatchingFunctionality:266
              document.querySelector('#jainism-sb').classList.add('opacity-0');  // > CustomCode.cardMatchingFunctionality:267
            }, 2500)  // > CustomCode.cardMatchingFunctionality:268
            break;  // > CustomCode.cardMatchingFunctionality:269
            case "christianity":  // > CustomCode.cardMatchingFunctionality:270
            //insert code for speech bubble here  // > CustomCode.cardMatchingFunctionality:271
            document.querySelector('#christianity-sb').classList.remove('opacity-0');  // > CustomCode.cardMatchingFunctionality:272
            document.querySelector('#christianity-sb').classList.add('opacity-1');  // > CustomCode.cardMatchingFunctionality:273
            setTimeout(() => {  // > CustomCode.cardMatchingFunctionality:274
              document.querySelector('#christianity-sb').classList.remove('opacity-1');  // > CustomCode.cardMatchingFunctionality:275
              document.querySelector('#christianity-sb').classList.add('opacity-0');  // > CustomCode.cardMatchingFunctionality:276
            }, 2500)  // > CustomCode.cardMatchingFunctionality:277
            break;  // > CustomCode.cardMatchingFunctionality:278
            case "islam":  // > CustomCode.cardMatchingFunctionality:279
            //insert code for speech bubble here  // > CustomCode.cardMatchingFunctionality:280
            document.querySelector('#islam-sb').classList.remove('opacity-0');  // > CustomCode.cardMatchingFunctionality:281
            document.querySelector('#islam-sb').classList.add('opacity-1');  // > CustomCode.cardMatchingFunctionality:282
            setTimeout(() => {  // > CustomCode.cardMatchingFunctionality:283
              document.querySelector('#islam-sb').classList.remove('opacity-1');  // > CustomCode.cardMatchingFunctionality:284
              document.querySelector('#islam-sb').classList.add('opacity-0');  // > CustomCode.cardMatchingFunctionality:285
            }, 2500)  // > CustomCode.cardMatchingFunctionality:286
            break;  // > CustomCode.cardMatchingFunctionality:287
            case "sikhism":  // > CustomCode.cardMatchingFunctionality:288
            //insert code for speech bubble here  // > CustomCode.cardMatchingFunctionality:289
            document.querySelector('#sikhism-sb').classList.remove('opacity-0');  // > CustomCode.cardMatchingFunctionality:290
            document.querySelector('#sikhism-sb').classList.add('opacity-1');  // > CustomCode.cardMatchingFunctionality:291
            setTimeout(() => {  // > CustomCode.cardMatchingFunctionality:292
              document.querySelector('#sikhism-sb').classList.remove('opacity-1');  // > CustomCode.cardMatchingFunctionality:293
              document.querySelector('#sikhism-sb').classList.add('opacity-0');  // > CustomCode.cardMatchingFunctionality:294
            }, 2500)  // > CustomCode.cardMatchingFunctionality:295
            break;  // > CustomCode.cardMatchingFunctionality:296
            case "bahai":  // > CustomCode.cardMatchingFunctionality:297
            //insert code for speech bubble here  // > CustomCode.cardMatchingFunctionality:298
            document.querySelector('#bahai-sb').classList.remove('opacity-0');  // > CustomCode.cardMatchingFunctionality:299
            document.querySelector('#bahai-sb').classList.add('opacity-1');  // > CustomCode.cardMatchingFunctionality:300
            setTimeout(() => {  // > CustomCode.cardMatchingFunctionality:301
              document.querySelector('#bahai-sb').classList.remove('opacity-1');  // > CustomCode.cardMatchingFunctionality:302
              document.querySelector('#bahai-sb').classList.add('opacity-0');  // > CustomCode.cardMatchingFunctionality:303
            }, 2500)  // > CustomCode.cardMatchingFunctionality:304
            break;  // > CustomCode.cardMatchingFunctionality:305
          }  // > CustomCode.cardMatchingFunctionality:306
          religionImageSelected = "";  // > CustomCode.cardMatchingFunctionality:307
          religionNameSelected = "";  // > CustomCode.cardMatchingFunctionality:308
        }  // > CustomCode.cardMatchingFunctionality:309
      });  // > CustomCode.cardMatchingFunctionality:310
    });  // > CustomCode.cardMatchingFunctionality:311
  }  // > CustomCode.cardMatchingFunctionality:312
  function checkMatch(name) {  // > CustomCode.cardMatchingFunctionality:313
    // this block dynamically resizes the height of the canvas so both ends of the connecting lines   // > CustomCode.cardMatchingFunctionality:314
    // are always touching the corresponding radio buttons for a match  // > CustomCode.cardMatchingFunctionality:315
    if (!isGameInProgress) {  // > CustomCode.cardMatchingFunctionality:316
      isGameInProgress = true;   // > CustomCode.cardMatchingFunctionality:317
      let canvas = document.getElementById("my-canvas");  // > CustomCode.cardMatchingFunctionality:318
      let a = document.getElementById('canvas_container');     // > CustomCode.cardMatchingFunctionality:319
      canvas.height = getContainerHeight(a);  // > CustomCode.cardMatchingFunctionality:320
    }  // > CustomCode.cardMatchingFunctionality:321
      // > CustomCode.cardMatchingFunctionality:322
  }  // > CustomCode.cardMatchingFunctionality:323

  function drawConnectorLines(name) {  // > CustomCode.drawMatchingLines:1
    const canvas = document.getElementById('my-canvas-'+currentStage);  // > CustomCode.drawMatchingLines:2
    const yPos1 = 0; // -6: ensure start point of line drawn to go through center of radio  // > CustomCode.drawMatchingLines:3
    const yPos2 = canvas.height; // +6 ensure end point of line drawn to go through center of radio  // > CustomCode.drawMatchingLines:4
    if (name === "hinduism") {      // > CustomCode.drawMatchingLines:5
      drawOneConnectorLine(getXCordOfLineStart("hinduism"), yPos1, getXCordOfLineEnd("hinduism"), yPos2, name);  // > CustomCode.drawMatchingLines:6
    }  // > CustomCode.drawMatchingLines:7
    if (name === "judaism") {  // > CustomCode.drawMatchingLines:8
      drawOneConnectorLine(getXCordOfLineStart("judaism"), yPos1, getXCordOfLineEnd("judaism"), yPos2, name);  // > CustomCode.drawMatchingLines:9
    }  // > CustomCode.drawMatchingLines:10
    if (name === "zoroastrian") {  // > CustomCode.drawMatchingLines:11
      drawOneConnectorLine(getXCordOfLineStart("zoroastrian"), yPos1, getXCordOfLineEnd("zoroastrian"), yPos2, name);  // > CustomCode.drawMatchingLines:12
    }  // > CustomCode.drawMatchingLines:13
    if (name === "buddhism") {  // > CustomCode.drawMatchingLines:14
      drawOneConnectorLine(getXCordOfLineStart("buddhism"), yPos1, getXCordOfLineEnd("buddhism"), yPos2, name);  // > CustomCode.drawMatchingLines:15
    }  // > CustomCode.drawMatchingLines:16
    if (name === "taoism") {  // > CustomCode.drawMatchingLines:17
      drawOneConnectorLine(getXCordOfLineStart("taoism"), yPos1, getXCordOfLineEnd("taoism"), yPos2, name);  // > CustomCode.drawMatchingLines:18
    }  // > CustomCode.drawMatchingLines:19
    if (name === "jainism") {  // > CustomCode.drawMatchingLines:20
      drawOneConnectorLine(getXCordOfLineStart("jainism"), yPos1, getXCordOfLineEnd("jainism"), yPos2, name);  // > CustomCode.drawMatchingLines:21
    }  // > CustomCode.drawMatchingLines:22
    if (name === "christianity") {  // > CustomCode.drawMatchingLines:23
      drawOneConnectorLine(getXCordOfLineStart("christianity"), yPos1, getXCordOfLineEnd("christianity"), yPos2, name);  // > CustomCode.drawMatchingLines:24
    }  // > CustomCode.drawMatchingLines:25
    if (name === "islam") {  // > CustomCode.drawMatchingLines:26
      drawOneConnectorLine(getXCordOfLineStart("islam"), yPos1, getXCordOfLineEnd("islam"), yPos2, name);  // > CustomCode.drawMatchingLines:27
    }  // > CustomCode.drawMatchingLines:28
    if (name === "sikhism") {  // > CustomCode.drawMatchingLines:29
      drawOneConnectorLine(getXCordOfLineStart("sikhism"), yPos1, getXCordOfLineEnd("sikhism"), yPos2, name);  // > CustomCode.drawMatchingLines:30
    }  // > CustomCode.drawMatchingLines:31
    if (name === "bahai") {  // > CustomCode.drawMatchingLines:32
      drawOneConnectorLine(getXCordOfLineStart("bahai"), yPos1, getXCordOfLineEnd("bahai"), yPos2, name);  // > CustomCode.drawMatchingLines:33
    }  // > CustomCode.drawMatchingLines:34
  }  // > CustomCode.drawMatchingLines:35
  function drawOneConnectorLine(xPos1, yPos1, xPos2, yPos2, name) {  // > CustomCode.drawMatchingLines:36
    const canvas = document.getElementById('my-canvas-'+currentStage);  // > CustomCode.drawMatchingLines:37
    const ctx = canvas.getContext("2d");  // > CustomCode.drawMatchingLines:38
    ctx.beginPath(); // Start a new path for the dot  // > CustomCode.drawMatchingLines:39
    ctx.strokeStyle = "#FF0082"; // Set the fill color for the dot  // > CustomCode.drawMatchingLines:40
      // > CustomCode.drawMatchingLines:41
    if (name == "taoism") {  // > CustomCode.drawMatchingLines:42
      ctx.moveTo(xPos1 - 12, yPos1);  // > CustomCode.drawMatchingLines:43
      ctx.lineTo(xPos2 - 12, yPos2);    // > CustomCode.drawMatchingLines:44
    } else {  // > CustomCode.drawMatchingLines:45
      ctx.moveTo(xPos1 - 10, yPos1);  // > CustomCode.drawMatchingLines:46
      ctx.lineTo(xPos2 - 2.5, yPos2 + 2.5);       // > CustomCode.drawMatchingLines:47
    }  // > CustomCode.drawMatchingLines:48
      // > CustomCode.drawMatchingLines:49
      // > CustomCode.drawMatchingLines:50
      // > CustomCode.drawMatchingLines:51
    // Properties only for SLS platform small preview window!  // > CustomCode.drawMatchingLines:52
    // height should be 3/4 for SLS screen and something else for expanded viewports  // > CustomCode.drawMatchingLines:53
    if (_view._topFrame.clientWidth < 650) {  // > CustomCode.drawMatchingLines:54
      ctx.lineWidth = 3;  // > CustomCode.drawMatchingLines:55
      ctx.setLineDash([5, 5]);  // > CustomCode.drawMatchingLines:56
    } else {  // > CustomCode.drawMatchingLines:57
      ctx.lineWidth = 4.5;  // > CustomCode.drawMatchingLines:58
      ctx.setLineDash([10, 12]);  // > CustomCode.drawMatchingLines:59
    }  // > CustomCode.drawMatchingLines:60
    ctx.stroke();  // > CustomCode.drawMatchingLines:61
  }  // > CustomCode.drawMatchingLines:62
  function getXCordOfLineStart(religion) {  // > CustomCode.drawMatchingLines:63
    // purpose of function: to find the exact coordinates of religion image radio for the starting point of line  // > CustomCode.drawMatchingLines:64
    // 1. remove excess left margin of parent and grandparent container  // > CustomCode.drawMatchingLines:65
    const gameScreen = document.getElementById('gameScreen');  // > CustomCode.drawMatchingLines:66
    const stage = document.getElementById('stage'+currentStage);  // > CustomCode.drawMatchingLines:67
    const excessLeftMargin = getLeftMargin(stage) + getLeftMargin(gameScreen);  // > CustomCode.drawMatchingLines:68
      // > CustomCode.drawMatchingLines:69
    // 2. find distance from left of religion image container to left of stage# container  // > CustomCode.drawMatchingLines:70
    const parentElem = document.getElementById(religion+'Pic').parentElement;  // > CustomCode.drawMatchingLines:71
    const distanceToLeftOfStageContainer = parentElem.offsetLeft;  // > CustomCode.drawMatchingLines:72
      // > CustomCode.drawMatchingLines:73
    // 3. get difference of 2 and 1  // > CustomCode.drawMatchingLines:74
    const difference = distanceToLeftOfStageContainer - excessLeftMargin;  // > CustomCode.drawMatchingLines:75
      // > CustomCode.drawMatchingLines:76
    // 4. get length of religion radio  // > CustomCode.drawMatchingLines:77
    const lengthOfRadio = document.querySelector(`#${religion}Pic + div > label`).offsetWidth;  // > CustomCode.drawMatchingLines:78
      // > CustomCode.drawMatchingLines:79
    // 5. take the difference and add it to 1/2 the length of image container  // > CustomCode.drawMatchingLines:80
    const xCordStart = difference + (parentElem.clientWidth / 2); // add half the length of radio to ensure line goes through the center of it  // > CustomCode.drawMatchingLines:81
    return xCordStart;  // > CustomCode.drawMatchingLines:82
  }  // > CustomCode.drawMatchingLines:83
  function getXCordOfLineEnd(religion) {  // > CustomCode.drawMatchingLines:84
    // purpose of function: to find the exact coordinates of religion image radio for the ending point of line  // > CustomCode.drawMatchingLines:85
      // > CustomCode.drawMatchingLines:86
    // 1. remove excess left margin of parent and grandparent container  // > CustomCode.drawMatchingLines:87
    const gameScreen = document.getElementById('gameScreen');  // > CustomCode.drawMatchingLines:88
    const stage = document.getElementById('stage'+currentStage);  // > CustomCode.drawMatchingLines:89
    const excessLeftMargin = getLeftMargin(stage) + getLeftMargin(gameScreen);  // > CustomCode.drawMatchingLines:90
      // > CustomCode.drawMatchingLines:91
    // 2. find distance from left of religion image container to left of stage# container  // > CustomCode.drawMatchingLines:92
    const parentElem = document.getElementById(religion+'Name').parentElement;  // > CustomCode.drawMatchingLines:93
    const distanceToLeftOfStageContainer = parentElem.offsetLeft;  // > CustomCode.drawMatchingLines:94
      // > CustomCode.drawMatchingLines:95
    // 3. get difference of 2 and 1  // > CustomCode.drawMatchingLines:96
    const difference = distanceToLeftOfStageContainer - excessLeftMargin;  // > CustomCode.drawMatchingLines:97
      // > CustomCode.drawMatchingLines:98
    // 4. take the difference and add it to 1/2 the length of image container  // > CustomCode.drawMatchingLines:99
    const xCordEnd = difference + (parentElem.clientWidth / 2); // -12 to align line ends at the center of radio  // > CustomCode.drawMatchingLines:100
      // > CustomCode.drawMatchingLines:101
    return xCordEnd;  // > CustomCode.drawMatchingLines:102
  }  // > CustomCode.drawMatchingLines:103
  function resizeCanvas() {   // > CustomCode.drawMatchingLines:104
    const canvas = document.getElementById('my-canvas-'+currentStage);  // > CustomCode.drawMatchingLines:105
    let canvasContainer = document.getElementById('canvas_container');    // > CustomCode.drawMatchingLines:106
    canvas.width = canvas.parentElement.clientWidth * 1;  // > CustomCode.drawMatchingLines:107
    // canvas.height = getContainerHeight(canvasContainer);  // > CustomCode.drawMatchingLines:108
    canvas.height = window.innerHeight / 4;  // > CustomCode.drawMatchingLines:109
        // > CustomCode.drawMatchingLines:110
    const nodeList = document.querySelectorAll(`#stage${currentStage} .religion-pictures img`); // Select all current religions shown  // > CustomCode.drawMatchingLines:111
    const religions = Array.from(nodeList).map(element => element.id.slice(0, -3)); // get all religion names  // > CustomCode.drawMatchingLines:112
      // > CustomCode.drawMatchingLines:113
    // check if line(s) in current stage is already drawn  // > CustomCode.drawMatchingLines:114
    religions.forEach((religion) => {  // > CustomCode.drawMatchingLines:115
      let isMatched = areCardsMatched[religion];  // > CustomCode.drawMatchingLines:116
      if (isMatched) {  // > CustomCode.drawMatchingLines:117
          // reraw the line  // > CustomCode.drawMatchingLines:118
          console.log('redrawing line');  // > CustomCode.drawMatchingLines:119
          drawConnectorLines(religion);  // > CustomCode.drawMatchingLines:120
      }      // > CustomCode.drawMatchingLines:121
    })    // > CustomCode.drawMatchingLines:122
      // > CustomCode.drawMatchingLines:123
  }  // > CustomCode.drawMatchingLines:124
  function getLeftMargin(element) {  // > CustomCode.drawMatchingLines:125
    const computedStyle = window.getComputedStyle(element);  // > CustomCode.drawMatchingLines:126
    return parseFloat(computedStyle.marginLeft);  // > CustomCode.drawMatchingLines:127
  }  // > CustomCode.drawMatchingLines:128
  function getContainerHeight(element) {  // > CustomCode.drawMatchingLines:129
    return element.offsetHeight;  // > CustomCode.drawMatchingLines:130
  }  // > CustomCode.drawMatchingLines:131
  function clearCanvas() {  // > CustomCode.drawMatchingLines:132
    const canvas = document.getElementById('my-canvas-'+currentStage);  // > CustomCode.drawMatchingLines:133
    const context = canvas.getContext('2d');  // > CustomCode.drawMatchingLines:134
    context.clearRect(0, 0, canvas.width, canvas.height);   // > CustomCode.drawMatchingLines:135
  }  // > CustomCode.drawMatchingLines:136

  function disableRadioButtons(selector) {  // > CustomCode.radioButtons:1
    var x = document.querySelectorAll(selector);  // > CustomCode.radioButtons:2
    for (i = 0; i < x.length; i++) {  // > CustomCode.radioButtons:3
      x[i].disabled = true;  // > CustomCode.radioButtons:4
    }  // > CustomCode.radioButtons:5
  }  // > CustomCode.radioButtons:6
  function enableRadioButtons(selector) {  // > CustomCode.radioButtons:7
    var x = document.querySelectorAll(selector);  // > CustomCode.radioButtons:8
    for (i = 0; i < x.length; i++) {  // > CustomCode.radioButtons:9
      x[i].disabled = false;  // > CustomCode.radioButtons:10
    }  // > CustomCode.radioButtons:11
  }  // > CustomCode.radioButtons:12
  function unCheckRadioButtons(selector) {  // > CustomCode.radioButtons:13
    var radioButtons = document.querySelectorAll(selector);  // > CustomCode.radioButtons:14
    radioButtons.forEach(function (radioButton) {  // > CustomCode.radioButtons:15
      radioButton.checked = false;  // > CustomCode.radioButtons:16
    });  // > CustomCode.radioButtons:17
  }  // > CustomCode.radioButtons:18
  function checkIfAnyRadioSelected(selector) {  // > CustomCode.radioButtons:19
    var radios = document.querySelectorAll(selector);  // > CustomCode.radioButtons:20
    for (const radio of radios) {  // > CustomCode.radioButtons:21
      if (radio.checked) {  // > CustomCode.radioButtons:22
        return true;  // > CustomCode.radioButtons:23
      }  // > CustomCode.radioButtons:24
    }  // > CustomCode.radioButtons:25
    return false;  // > CustomCode.radioButtons:26
  }  // > CustomCode.radioButtons:27

  function allCardsCorrectedMatched() {	  // > CustomCode.stage:1
    // checks matches based on the currentStage  // > CustomCode.stage:2
    if (currentStage == 1) {  // > CustomCode.stage:3
      return (  // > CustomCode.stage:4
        areCardsMatched.hinduism &&  // > CustomCode.stage:5
        areCardsMatched.judaism &&  // > CustomCode.stage:6
        areCardsMatched.zoroastrian  // > CustomCode.stage:7
      );  // > CustomCode.stage:8
    } else if (currentStage == 2) {  // > CustomCode.stage:9
      return (  // > CustomCode.stage:10
        areCardsMatched.buddhism &&  // > CustomCode.stage:11
        areCardsMatched.taoism &&  // > CustomCode.stage:12
        areCardsMatched.jainism  // > CustomCode.stage:13
      );  // > CustomCode.stage:14
    } else if (currentStage == 3) {  // > CustomCode.stage:15
      return (  // > CustomCode.stage:16
        areCardsMatched.christianity &&  // > CustomCode.stage:17
        areCardsMatched.islam &&  // > CustomCode.stage:18
        areCardsMatched.sikhism &&  // > CustomCode.stage:19
        areCardsMatched.bahai  // > CustomCode.stage:20
      );  // > CustomCode.stage:21
    }  // > CustomCode.stage:22
    return false;  // > CustomCode.stage:23
  }  // > CustomCode.stage:24

  async function callFuncAfterSomeSeconds(seconds, callback) {  // > CustomCode.utils:1
    await sleep(seconds);  // > CustomCode.utils:2
    callback();  // > CustomCode.utils:3
  }  // > CustomCode.utils:4
  function sleep(seconds) {  // > CustomCode.utils:5
    return new Promise(resolve => setTimeout(resolve, seconds * 1000));  // > CustomCode.utils:6
  }  // > CustomCode.utils:7

  function showReligionDescriptionModal() {  // > CustomCode.modals:1
    document.getElementById('religionDescriptionModal').classList.add('d-block');  // > CustomCode.modals:2
    document.getElementById('religionDescriptionModal').classList.remove('d-none');  // > CustomCode.modals:3
    document.getElementById('overlay').style.display = "block";  // > CustomCode.modals:4
    // for some reason, we need cannot transition the opacity of the overlay synchronously to achieve the fade in effect  // > CustomCode.modals:5
    // hence, using the setTimeout  // > CustomCode.modals:6
    setTimeout(() => document.getElementById('overlay').style.opacity = 1, 0);   // > CustomCode.modals:7
  }  // > CustomCode.modals:8
  function hideReligionDescriptionModal() {    // > CustomCode.modals:9
    document.getElementById('religionDescriptionModal').classList.remove('d-block');  // > CustomCode.modals:10
    document.getElementById('religionDescriptionModal').classList.add('d-none');  // > CustomCode.modals:11
      // > CustomCode.modals:12
    document.getElementById('overlay').style.opacity = 0;  // > CustomCode.modals:13
    document.getElementById('overlay').style.display = "none";  // > CustomCode.modals:14
  }  // > CustomCode.modals:15
  function updateReligionDescriptionModal (title, body) {  // > CustomCode.modals:16
    document.querySelector('#religionDescriptionModal > #rdTitle').innerHTML = title;  // > CustomCode.modals:17
    document.querySelector('#religionDescriptionModal #rdBody').innerHTML = body;  // > CustomCode.modals:18
  }  // > CustomCode.modals:19
  function hideStageClearedModal() {  // > CustomCode.modals:20
    document.querySelector('#stageClearedModal').classList.remove('d-flex');  // > CustomCode.modals:21
    document.querySelector('#stageClearedModal').classList.add('d-none');  // > CustomCode.modals:22
    document.getElementById('overlay').style.opacity = 0;  // > CustomCode.modals:23
    document.getElementById('overlay').style.display = "none";  // > CustomCode.modals:24
  }  // > CustomCode.modals:25
  function updateStageClearedModal (title, body) {  // > CustomCode.modals:26
    document.querySelector('#stageClearedModal > #scTitle').innerHTML = title;  // > CustomCode.modals:27
    document.querySelector('#stageClearedModal > #scBody').innerHTML = body;  // > CustomCode.modals:28
  }  // > CustomCode.modals:29
  class StageClearedModal {  // > CustomCode.modals:30
    constructor(title="", body="", btnText="") {  // > CustomCode.modals:31
      this.title = title;  // > CustomCode.modals:32
      this.body = body;  // > CustomCode.modals:33
      this.btnText = btnText;  // > CustomCode.modals:34
    }  // > CustomCode.modals:35
      // > CustomCode.modals:36
    setAttributes() {  // > CustomCode.modals:37
      document.querySelector('#stageClearedModal > #scTitle').innerHTML = this.title;  // > CustomCode.modals:38
      document.querySelector('#stageClearedModal > #scBody').innerHTML = this.body;  // > CustomCode.modals:39
      document.querySelector('#stageClearedModal > #scBtn').innerHTML = this.btnText;  // > CustomCode.modals:40
    }  // > CustomCode.modals:41
    show() {  // > CustomCode.modals:42
      document.querySelector('#stageClearedModal').classList.remove('d-none');  // > CustomCode.modals:43
      document.querySelector('#stageClearedModal').classList.add('d-flex');  // > CustomCode.modals:44
      document.getElementById('overlay').style.display = "block";  // > CustomCode.modals:45
      setTimeout(() => document.getElementById('overlay').style.opacity = 1, 0);   // > CustomCode.modals:46
    }  // > CustomCode.modals:47
  }  // > CustomCode.modals:48

  function updateProgressBar(level) {  // > CustomCode.progressBar:1
    var progressLevel = document.getElementById("progressLevel");  // > CustomCode.progressBar:2
    progressLevel.style.width = level + "%";  // > CustomCode.progressBar:3
      // > CustomCode.progressBar:4
    if (level == 0) {  // > CustomCode.progressBar:5
      progressLevel.classList.add("emptybar");  // > CustomCode.progressBar:6
      progressLevel.classList.remove("fullbar");  // > CustomCode.progressBar:7
    } else if (level >= 1 && level < 100) {  // > CustomCode.progressBar:8
      progressLevel.classList.remove("emptybar");  // > CustomCode.progressBar:9
      progressLevel.classList.remove("fullbar");  // > CustomCode.progressBar:10
    } else {  // > CustomCode.progressBar:11
      progressLevel.classList.remove("emptybar");  // > CustomCode.progressBar:12
      progressLevel.classList.add("fullbar");  // > CustomCode.progressBar:13
    }  // > CustomCode.progressBar:14
  }  // > CustomCode.progressBar:15
  function showProgressBar() {  // > CustomCode.progressBar:16
    document.getElementById('progressBarContainer').style.display = "block";  // > CustomCode.progressBar:17
  }  // > CustomCode.progressBar:18
  function hideProgressBar() {  // > CustomCode.progressBar:19
    document.getElementById('progressBarContainer').style.display = "none";  // > CustomCode.progressBar:20
  }  // > CustomCode.progressBar:21
  function incrementProgressBarLevel() {  // > CustomCode.progressBar:22
    if (progressPercentage == 0) {  // > CustomCode.progressBar:23
      progressPercentage += 33;    // > CustomCode.progressBar:24
    } else if (progressPercentage == 33) {  // > CustomCode.progressBar:25
      progressPercentage += 34;    // > CustomCode.progressBar:26
    } else if (progressPercentage == 67) {  // > CustomCode.progressBar:27
      progressPercentage += 33;        // > CustomCode.progressBar:28
    }  // > CustomCode.progressBar:29
    updateProgressBar(progressPercentage);  // > CustomCode.progressBar:30
  }  // > CustomCode.progressBar:31

  // copy this custom function  // > CustomCode.sound:1
  // in iOS need to add speech to the play button as On iOS the API works but must be triggered by a user action callback, like a response to a tap event, to provide a better experience to users and avoid unexpected sounds out of your phone  // > CustomCode.sound:2
  function speech (option) {  // > CustomCode.sound:3
  try { // allow code to run in Student Learning Space   // > CustomCode.sound:4
  var isCordova = (!!this.parent.cordova || !!window.cordova);  // > CustomCode.sound:5
  if(isCordova) { // check it is running in Android or iOS  // > CustomCode.sound:6
         // parent.TTS.speak({text:option,locale:'zh-CN'});  // > CustomCode.sound:7
  	parent.TTS.speak({text:option,locale:'us-EN'});  // > CustomCode.sound:8
  	// parent.TTS.speak({text:option,locale:'en-US'});  // > CustomCode.sound:9
  }   // > CustomCode.sound:10
  }   // > CustomCode.sound:11
  catch(e) {  // > CustomCode.sound:12
    var isCordova = false;  // > CustomCode.sound:13
    }  // > CustomCode.sound:14
      // > CustomCode.sound:15
     var msg = new SpeechSynthesisUtterance(option);  // > CustomCode.sound:16
    //https://stackoverflow.com/questions/43983845/speechsynthesis-api-for-chinese-firefox  // > CustomCode.sound:17
    // Set the text.  // > CustomCode.sound:18
  	//msg.text = option;   // > CustomCode.sound:19
  	//https://forums.developer.apple.com/message/323564#323564  // > CustomCode.sound:20
  	// comment out the next 2 lines for english  // > CustomCode.sound:21
  //msg.voice = speechSynthesis.getVoices().filter(function(voice) { return voice.name == 'Ting-Ting'; })[0];  // > CustomCode.sound:22
  //msg.lang = 'zh-CH'; // need for android?  // > CustomCode.sound:23
  msg.lang = 'us-EN'; // need for android?  // > CustomCode.sound:24
  //https://flaviocopes.com/speech-synthesis-api/  // > CustomCode.sound:25
  //debug  // > CustomCode.sound:26
  //console.log(`Voices #: ${speechSynthesis.getVoices().length}`)  // > CustomCode.sound:27
  //speechSynthesis.getVoices().forEach(voice => {  // > CustomCode.sound:28
  // console.log(voice.name, voice.lang)  // > CustomCode.sound:29
  //})  // > CustomCode.sound:30
  //debug  // > CustomCode.sound:31
  // Queue this utterance.  // > CustomCode.sound:32
  window.speechSynthesis.speak(msg);  // > CustomCode.sound:33
     // > CustomCode.sound:34
  }  // > CustomCode.sound:35

  // code to be copied to EJSS source code under Custom and used in drawingPanel3D and plottingPanel2D  // > CustomCode.changeOrientation:1
  // address the problem is height difference is iOS app , epub, and Firefox  // > CustomCode.changeOrientation:2
  // user need to change only k and kepub  // > CustomCode.changeOrientation:3
  // copy %changeOrientation()% into the Height Field of drawingPanel3D and plottingPanel2D  // > CustomCode.changeOrientation:4
  // _view.plottingPanel.getGraphics().setHeight(changeOrientation(0.85));  // > CustomCode.changeOrientation:5
  function changeOrientation(kheight) {  // > CustomCode.changeOrientation:6
     // > CustomCode.changeOrientation:7
  var k =0.90 ; // k control height 1 is for full screen, 0.9 shorten etc  // > CustomCode.changeOrientation:8
  var kapple =0.90 // control apple app height  // > CustomCode.changeOrientation:9
  var kepub =0.90 ;  // > CustomCode.changeOrientation:10
  // check platform for Apps  // > CustomCode.changeOrientation:11
  try { // allow code to run in Student Learning Space   // > CustomCode.changeOrientation:12
    var iOSapp =  (typeof parent.device != 'undefined' && parent.device.platform == "iOS");  // > CustomCode.changeOrientation:13
    var Androidapp = (typeof parent.device != 'undefined' && parent.device.platform == "Android");  // > CustomCode.changeOrientation:14
  } catch(e) {  // > CustomCode.changeOrientation:15
    var iOSapp = false;  // > CustomCode.changeOrientation:16
    var Androidapp = false;  // > CustomCode.changeOrientation:17
  }  // > CustomCode.changeOrientation:18
  // check platform for web browsers  // > CustomCode.changeOrientation:19
  var iOS =/iPad|iPhone|iPod/.test(navigator.userAgent) && !window.MSStream;  // > CustomCode.changeOrientation:20
  var iPad =/iPad/.test(navigator.userAgent) && !window.MSStream;  // > CustomCode.changeOrientation:21
  var iPhone = /iPhone|iPod/.test(navigator.userAgent) && !window.MSStream;  // > CustomCode.changeOrientation:22
  var Android= /Android|android/i.test(navigator.userAgent);  // > CustomCode.changeOrientation:23
  //navigator  // > CustomCode.changeOrientation:24
  var Firefox = navigator.userAgent.indexOf("Firefox") != -1;  // > CustomCode.changeOrientation:25
     // > CustomCode.changeOrientation:26
  switch (window.orientation) { // using window.orientation as deciding factor  // > CustomCode.changeOrientation:27
    case 0:  // > CustomCode.changeOrientation:28
    case 180:  // > CustomCode.changeOrientation:29
      this.screenOrientation = 'portrait';  // > CustomCode.changeOrientation:30
      if (iOSapp){ // does not seems to work  // > CustomCode.changeOrientation:31
          // > CustomCode.changeOrientation:32
        return window.screen.height*kapple;  //0.1 for app and 0.1 for nonfullscreenapp    // > CustomCode.changeOrientation:33
        // > CustomCode.changeOrientation:34
      }  // > CustomCode.changeOrientation:35
      else if (_isEPub){ // does not seems to work  // > CustomCode.changeOrientation:36
        //   return Math.max(window.screen.width,window.screen.height)*0.9;  // > CustomCode.changeOrientation:37
        return window.innerHeight*kepub;  //0.1 for app and 0.1 for nonfullscreenapp    // > CustomCode.changeOrientation:38
        // return window.screen.height;  // > CustomCode.changeOrientation:39
        //  return window.innerHeight;  // > CustomCode.changeOrientation:40
        // return document.documentElement.clientHeight;  // > CustomCode.changeOrientation:41
      }  // > CustomCode.changeOrientation:42
       // > CustomCode.changeOrientation:43
      else {  // > CustomCode.changeOrientation:44
       return window.innerHeight*kheight;  // > CustomCode.changeOrientation:45
        //return 100*k+"vh";  // > CustomCode.changeOrientation:46
      }  // > CustomCode.changeOrientation:47
      break;  // > CustomCode.changeOrientation:48
    case 90:  // > CustomCode.changeOrientation:49
    case -90:  // > CustomCode.changeOrientation:50
      this.screenOrientation = 'landscape';  // > CustomCode.changeOrientation:51
     // > CustomCode.changeOrientation:52
      if (iOSapp){ // App  // > CustomCode.changeOrientation:53
        return window.screen.width*kapple;    // > CustomCode.changeOrientation:54
        // return window.screen.height;  // > CustomCode.changeOrientation:55
        //  return window.innerHeight;  // > CustomCode.changeOrientation:56
        //  return document.documentElement.clientHeight;  // > CustomCode.changeOrientation:57
      }  // > CustomCode.changeOrientation:58
      else if (_isEPub){ // does not seems to work  // > CustomCode.changeOrientation:59
        //   return Math.max(window.screen.width,window.screen.height)*0.9;  // > CustomCode.changeOrientation:60
        return window.innerHeight*kepub;  //0.1 for app and 0.1 for nonfullscreenapp    // > CustomCode.changeOrientation:61
        // return window.screen.height;  // > CustomCode.changeOrientation:62
        //  return window.innerHeight;  // > CustomCode.changeOrientation:63
        // return document.documentElement.clientHeight;  // > CustomCode.changeOrientation:64
      }  // > CustomCode.changeOrientation:65
       // > CustomCode.changeOrientation:66
      else {  // > CustomCode.changeOrientation:67
        return window.innerHeight*kheight;  // > CustomCode.changeOrientation:68
        //return 100*k+"vh"; // safari produce error  // > CustomCode.changeOrientation:69
        }  // > CustomCode.changeOrientation:70
      break;  // > CustomCode.changeOrientation:71
    default:  // > CustomCode.changeOrientation:72
      this.screenOrientation = 'unknown';  // > CustomCode.changeOrientation:73
      //       return (iPad)?""+(window.screen.width+window.screen.height)*0.4:((iPhone)?""+window.screen.width:_view._format(window.innerHeight*0.9,"0"));  // > CustomCode.changeOrientation:74
       if (Firefox){  // > CustomCode.changeOrientation:75
        return window.innerHeight*k;// number as of 20180831 Firefox does not support vh yet so need a separate line to handle  // > CustomCode.changeOrientation:76
        }  // > CustomCode.changeOrientation:77
     //   else if (iOS&&(window.orientation==0)||(window.orientation==180)){  // > CustomCode.changeOrientation:78
     //   return  window.screen.height*k;// number as of 20180831 Firefox does not support vh yet so need a separate line to handle  // > CustomCode.changeOrientation:79
     //   }  // > CustomCode.changeOrientation:80
      //  else if (iOS&&(window.orientation==90)||(window.orientation==-90)){  // > CustomCode.changeOrientation:81
     //   return  window.screen.width*k;// number as of 20180831 Firefox does not support vh yet so need a separate line to handle  // > CustomCode.changeOrientation:82
     //   }  // > CustomCode.changeOrientation:83
        else {  // > CustomCode.changeOrientation:84
        //alert();  // > CustomCode.changeOrientation:85
        // return 100*k+"%"; // work on fullscreen works in EJSS6.0beta  // > CustomCode.changeOrientation:86
          //  works in EjsS_5.3_180131  // > CustomCode.changeOrientation:87
        return  window.innerHeight*kheight; // work on panel   // > CustomCode.changeOrientation:88
           // > CustomCode.changeOrientation:89
  }  // > CustomCode.changeOrientation:90
  }  // > CustomCode.changeOrientation:91
     // > CustomCode.changeOrientation:92
  }  // > CustomCode.changeOrientation:93

  //https://developer.mozilla.org/en-US/docs/Web/Guide/API/DOM/Using_full_screen_mode  // > CustomCode.togglefullscreen:1
  // does not work for iOS   // > CustomCode.togglefullscreen:2
  /*jslint browser:true */  // > CustomCode.togglefullscreen:3
  function toggleFullScreen() {  // > CustomCode.togglefullscreen:4
    if (!document.fullscreenElement &&    // alternative standard method  // > CustomCode.togglefullscreen:5
        !document.mozFullScreenElement && !document.webkitFullscreenElement && !document.msFullscreenElement ) {  // current working methods  // > CustomCode.togglefullscreen:6
      if (document.documentElement.requestFullscreen) {  // > CustomCode.togglefullscreen:7
        document.documentElement.requestFullscreen();  // > CustomCode.togglefullscreen:8
      } else if (document.documentElement.msRequestFullscreen) {  // > CustomCode.togglefullscreen:9
        document.documentElement.msRequestFullscreen();  // > CustomCode.togglefullscreen:10
      } else if (document.documentElement.mozRequestFullScreen) {  // > CustomCode.togglefullscreen:11
        document.documentElement.mozRequestFullScreen();  // > CustomCode.togglefullscreen:12
      } else if (document.documentElement.webkitRequestFullscreen) {  // > CustomCode.togglefullscreen:13
        document.documentElement.webkitRequestFullscreen();  // > CustomCode.togglefullscreen:14
      }  // > CustomCode.togglefullscreen:15
    } else {  // > CustomCode.togglefullscreen:16
      if (document.exitFullscreen) {  // > CustomCode.togglefullscreen:17
        document.exitFullscreen();  // > CustomCode.togglefullscreen:18
      } else if (document.msExitFullscreen) {  // > CustomCode.togglefullscreen:19
        document.msExitFullscreen();  // > CustomCode.togglefullscreen:20
      } else if (document.mozCancelFullScreen) {  // > CustomCode.togglefullscreen:21
        document.mozCancelFullScreen();  // > CustomCode.togglefullscreen:22
      } else if (document.webkitExitFullscreen) {  // > CustomCode.togglefullscreen:23
        document.webkitExitFullscreen();  // > CustomCode.togglefullscreen:24
      }  // > CustomCode.togglefullscreen:25
    }  // > CustomCode.togglefullscreen:26
  }  // > CustomCode.togglefullscreen:27

  _model.addToInitialization(function() {
    if (!__pagesEnabled["init"]) return;
    createMatchingFunctionality();  // > Initialization.init:1
    resizeCanvas();  // > Initialization.init:2
    window.addEventListener("resize", resizeCanvas);  // > Initialization.init:3
  });

  _model.addToInitialization(function() {
    if (!__pagesEnabled["pageNavigation"]) return;
    // let endPageBtn = document.querySelector('#gameEndBtn');  // > Initialization.pageNavigation:1
    let gameIntroBtn = document.querySelector('#gameIntroductionBtn');  // > Initialization.pageNavigation:2
    gameIntroBtn.addEventListener('click', () => {  // > Initialization.pageNavigation:3
      // hide game introduction page  // > Initialization.pageNavigation:4
      const gameIntroductionPage = document.getElementById('gameIntroduction');  // > Initialization.pageNavigation:5
      gameIntroductionPage.classList.remove('d-flex');  // > Initialization.pageNavigation:6
      gameIntroductionPage.classList.add('d-none');  // > Initialization.pageNavigation:7
      // display game page  // > Initialization.pageNavigation:8
      const gamePage = document.getElementById('gameScreen');  // > Initialization.pageNavigation:9
      gamePage.classList.remove('d-none');  // > Initialization.pageNavigation:10
      gamePage.classList.add('d-flex');  // > Initialization.pageNavigation:11
      // prevent student being able to select names radios before selecting religion images at game start  // > Initialization.pageNavigation:12
      disableRadioButtons(".religion-names input");   // > Initialization.pageNavigation:13
      // resize canvas at the very beginning of stage 1,   // > Initialization.pageNavigation:14
      // so the lines will be touching the both name and picture radios.  // > Initialization.pageNavigation:15
      setTimeout(resizeCanvas, 500);  // > Initialization.pageNavigation:16
    // reset all settings if game was restarted  // > Initialization.pageNavigation:17
      document.querySelector('#stage1').classList.remove('d-none');  // > Initialization.pageNavigation:18
      document.querySelector('#stage1').classList.add('d-block');  // > Initialization.pageNavigation:19
      currentStage = 1;  // > Initialization.pageNavigation:20
      clearCanvas();  // > Initialization.pageNavigation:21
      areCardsMatched = {   // > Initialization.pageNavigation:22
        hinduism: false, 		  // > Initialization.pageNavigation:23
        judaism: false, 		  // > Initialization.pageNavigation:24
        zoroastrian: false, 		  // > Initialization.pageNavigation:25
        buddhism: false, 		  // > Initialization.pageNavigation:26
        taoism: false, 		  // > Initialization.pageNavigation:27
        jainism: false, 		  // > Initialization.pageNavigation:28
        christianity: false, 		  // > Initialization.pageNavigation:29
        islam: false, 		  // > Initialization.pageNavigation:30
        sikhism: false, 		  // > Initialization.pageNavigation:31
        bahai: false, 	  // > Initialization.pageNavigation:32
      }  // > Initialization.pageNavigation:33
        // > Initialization.pageNavigation:34
      document.querySelectorAll('.correctly-matched').forEach(opt => opt.classList.remove('correctly-matched'));  // > Initialization.pageNavigation:35
      progressPercentage = 0;  // > Initialization.pageNavigation:36
      updateProgressBar(0);  // > Initialization.pageNavigation:37
    });  // > Initialization.pageNavigation:38
  });

  _model.addToInitialization(function() {
    if (!__pagesEnabled["copyRight"]) return;
    var currentYear = new Date().getFullYear();  // > Initialization.copyRight:1
    document.getElementById("currentYear").textContent = currentYear;  // > Initialization.copyRight:2
  });

  _model.addToFixedRelations(function() { _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); });

  _model.addToFixedRelations(function() { _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); });

    _model._fontResized = function(iBase,iSize,iDelta) {
      _view._fontResized(iBase,iSize,iDelta);
  }; // end of _fontResized

  function _getViews() {
    var _viewsInfo = [];
    var _counter = 0;
    _viewsInfo[_counter++] = { name : "HtmlView Page", width : null, height : null };
    return _viewsInfo;
  } // end of _getViews

  function _selectView(_viewNumber) {
    _view = null;
    _view = new cross_cultural_View(_topFrame,_viewNumber,_libraryPath,_codebasePath);
    var _view_super_reset = _view._reset;
    _view._reset = function() {
      _view_super_reset();
      switch(_viewNumber) {
        case -10 : break; // make Lint happy
        default :
        case 0:
          _view.startBtn.setAction("OnClick", function(_data,_info) {
  const startPage = document.getElementById('gameStart');
  startPage.classList.remove('d-flex');
  startPage.classList.add('d-none');
  const introductionPage = document.getElementById('gameIntroduction');
  introductionPage.classList.remove('d-none');
  introductionPage.classList.add('d-flex');

}); // HtmlView Page setting action 'OnClick' for element 'startBtn'
          _view.rdBtn.setAction("OnClick", function(_data,_info) {
  // show stage cleared modal when all cards are matched during stage
  if (allCardsCorrectedMatched()) {
    
    if (currentStage == 1) {
      hideReligionDescriptionModal();
      
      const modal = new StageClearedModal("YOU'RE OFF TO A GREAT START!", 'Can you keep your streak while matching the next 3 religions?', 'CONTINUE');
      modal.setAttributes();
      callFuncAfterSomeSeconds(.25, modal.show);
      callFuncAfterSomeSeconds(.25, _view.clapSound.play);
      callFuncAfterSomeSeconds(.25, incrementProgressBarLevel);
    } else if (currentStage == 2) {
      hideReligionDescriptionModal();
      
      const modal = new StageClearedModal("YOU'RE ON A ROLL!", 'You’ve learned more about dietary practices of different religions! <br /><br /> '+
                                          'Challenge yourself to match the next 4 religions in your final stage.', 'CONTINUE');
      modal.setAttributes();
      callFuncAfterSomeSeconds(.25, modal.show);
      callFuncAfterSomeSeconds(.25, _view.clapSound.play);
      callFuncAfterSomeSeconds(.25, incrementProgressBarLevel);
    } else if (currentStage == 3) {
      
      // game ended
      _view.fanfareSound.play();
      
      const confetti = document.getElementById("confetti");
      confetti.classList.remove("d-none");
      
      callFuncAfterSomeSeconds(.25, incrementProgressBarLevel);
      hideReligionDescriptionModal();
      hasGameEnded = true;
      document.getElementById('gameEnd').classList.remove('d-none');
      document.getElementById('gameEnd').classList.add('d-block');
      
    }
  } else {
    hideReligionDescriptionModal();
    
    //one match is correct but not all
    disableRadioButtons(".religion-names input");
    unCheckRadioButtons(".religion-pictures input");
    unCheckRadioButtons(".religion-names input");
    cardSelected = "";
    matchSelected = "";
  }

}); // HtmlView Page setting action 'OnClick' for element 'rdBtn'
          _view.scBtn.setAction("OnClick", function(_data,_info) {
  // every time you click modal 'NEXT' btn (religion description) .. code below runs
  _println(allCardsCorrectedMatched());
  if (allCardsCorrectedMatched()) {
    if (currentStage == 1) {    
      hideStageClearedModal();
      
      document.querySelector('#stage1').classList.remove('d-block');
      document.querySelector('#stage1').classList.add('d-none');
      document.querySelector('#stage2').classList.remove('d-none');
      document.querySelector('#stage2').classList.add('d-block');
      
      currentStage = 2;
      clearCanvas();
      resizeCanvas();
      
    } else if (currentStage == 2) {
      hideStageClearedModal();
      
      document.querySelector('#stage2').classList.remove('d-block');
      document.querySelector('#stage2').classList.add('d-none');
      document.querySelector('#stage3').classList.remove('d-none');
      document.querySelector('#stage3').classList.add('d-block');
      
      currentStage = 3;
      clearCanvas();
      resizeCanvas();
    } else {
      
      
    }
    
  } else {
    //one match is correct but not all
    disableRadioButtons(".religion-names input");
    unCheckRadioButtons(".religion-pictures input");
    unCheckRadioButtons(".religion-names input");
    cardSelected = "";
    matchSelected = "";
  }
  hideReligionDescriptionModal();

}); // HtmlView Page setting action 'OnClick' for element 'scBtn'
          _view.copyright.linkProperty("Visibility",  function() { return currentPage!="gameIntroduction"?true:false; } ); // HtmlView Page linking property 'Visibility' for element 'copyright'
          break;
      } // end of switch
    }; // end of new reset

    _model.setView(_view);
    _model.reset();
    _view._enableEPub();
  } // end of _selectView

  _model.setAutoplay(false);
  _model.setFPS(1);
  _model.setStepsPerDisplay(1);
  _selectView(_model._autoSelectView(_getViews())); // this includes _model.reset()
  return _model;
}
function cross_cultural_View (_topFrame,_viewNumber,_libraryPath,_codebasePath) {
  var _view;
  switch(_viewNumber) {
    case -10 : break; // make Lint happy
    default :
    case 0: _view = cross_cultural_View_0 (_topFrame); break;
  } // end of switch

  if (_codebasePath) _view._setResourcePath(_codebasePath);

  if (_libraryPath) _view._setLibraryPath(_libraryPath);


  return _view;
} // end of main function

function cross_cultural_View_0 (_topFrame) {
  var _view = EJSS_CORE.createView(_topFrame);

  _view._reset = function() {
    _view._clearAll();
    _view._addElement(EJSS_INTERFACE.panel,"gameStart", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'gameStart'
      .setProperty("ClassName","d-flex justify-content-center") // EJsS HtmlView.HtmlView Page: setting property 'ClassName' for element 'gameStart'
      .setProperty("Html","<svg width=\"701\" height=\"701\" viewBox=\"0 0 701 701\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"> <g filter=\"url(#filter0_d_838_971)\"> <rect y=\"0.5\" width=\"691\" height=\"690\" rx=\"50\" fill=\"#FDFAF1\"/> <path d=\"M79 139.5C78.232 139.5 77.512 139.34 76.84 139.02C76.2 138.668 75.88 138.156 75.88 137.484V106.38C75.88 105.676 76.2 105.18 76.84 104.892C77.512 104.572 78.232 104.412 79 104.412C79.8 104.412 80.52 104.572 81.16 104.892C81.8 105.18 82.12 105.676 82.12 106.38V137.484C82.12 138.156 81.8 138.668 81.16 139.02C80.52 139.34 79.8 139.5 79 139.5ZM90.472 139.5C89.576 139.5 88.84 139.292 88.264 138.876C87.688 138.46 87.4 137.996 87.4 137.484V118.62C87.4 118.044 87.688 117.58 88.264 117.228C88.84 116.876 89.576 116.7 90.472 116.7C91.24 116.7 91.88 116.876 92.392 117.228C92.936 117.58 93.208 118.044 93.208 118.62V120.06C93.688 119.132 94.472 118.3 95.56 117.564C96.68 116.796 98.04 116.412 99.64 116.412C101.144 116.412 102.52 116.86 103.768 117.756C105.016 118.62 106.008 119.788 106.744 121.26C107.512 122.732 107.896 124.364 107.896 126.156V137.484C107.896 138.156 107.576 138.668 106.936 139.02C106.296 139.34 105.576 139.5 104.776 139.5C104.072 139.5 103.384 139.34 102.712 139.02C102.04 138.668 101.704 138.156 101.704 137.484V126.156C101.704 125.42 101.512 124.732 101.128 124.092C100.776 123.452 100.28 122.924 99.64 122.508C99 122.06 98.296 121.836 97.528 121.836C96.888 121.836 96.264 122.012 95.656 122.364C95.048 122.716 94.552 123.212 94.168 123.852C93.784 124.492 93.592 125.26 93.592 126.156V137.484C93.592 137.996 93.288 138.46 92.68 138.876C92.072 139.292 91.336 139.5 90.472 139.5ZM139.5 139.932C137.42 139.932 135.532 139.628 133.836 139.02C132.172 138.412 130.844 137.66 129.852 136.764C128.892 135.836 128.412 134.908 128.412 133.98C128.412 133.532 128.524 133.052 128.748 132.54C129.004 131.996 129.34 131.548 129.756 131.196C130.172 130.812 130.636 130.62 131.148 130.62C131.66 130.62 132.14 130.812 132.588 131.196C133.036 131.548 133.548 131.98 134.124 132.492C134.7 132.972 135.404 133.404 136.236 133.788C137.068 134.14 138.092 134.316 139.308 134.316C140.268 134.316 141.148 134.172 141.948 133.884C142.78 133.564 143.436 133.1 143.916 132.492C144.428 131.884 144.684 131.1 144.684 130.14C144.684 129.116 144.412 128.252 143.868 127.548C143.324 126.844 142.588 126.236 141.66 125.724C140.732 125.212 139.724 124.716 138.636 124.236C137.548 123.756 136.444 123.244 135.324 122.7C134.236 122.156 133.228 121.5 132.3 120.732C131.404 119.964 130.668 119.02 130.092 117.9C129.548 116.78 129.276 115.404 129.276 113.772C129.276 111.98 129.612 110.476 130.284 109.26C130.988 108.044 131.9 107.068 133.02 106.332C134.172 105.564 135.436 105.02 136.812 104.7C138.188 104.348 139.564 104.172 140.94 104.172C141.676 104.172 142.54 104.236 143.532 104.364C144.556 104.46 145.564 104.652 146.556 104.94C147.58 105.228 148.412 105.628 149.052 106.14C149.724 106.62 150.06 107.26 150.06 108.06C150.06 108.412 149.964 108.844 149.772 109.356C149.612 109.868 149.34 110.332 148.956 110.748C148.604 111.164 148.14 111.372 147.564 111.372C147.052 111.372 146.54 111.228 146.028 110.94C145.548 110.62 144.908 110.316 144.108 110.028C143.34 109.708 142.284 109.548 140.94 109.548C139.82 109.548 138.844 109.692 138.012 109.98C137.18 110.268 136.556 110.684 136.14 111.228C135.724 111.74 135.516 112.396 135.516 113.196C135.516 114.028 135.788 114.732 136.332 115.308C136.908 115.884 137.644 116.396 138.54 116.844C139.468 117.292 140.476 117.74 141.564 118.188C142.652 118.636 143.74 119.164 144.828 119.772C145.948 120.348 146.972 121.052 147.9 121.884C148.828 122.716 149.564 123.756 150.108 125.004C150.652 126.22 150.924 127.724 150.924 129.516C150.924 131.788 150.428 133.708 149.436 135.276C148.444 136.812 147.084 137.98 145.356 138.78C143.66 139.548 141.708 139.932 139.5 139.932ZM157.811 111.612C156.883 111.612 156.083 111.308 155.411 110.7C154.739 110.06 154.403 109.356 154.403 108.588C154.403 107.756 154.739 107.052 155.411 106.476C156.083 105.868 156.883 105.564 157.811 105.564C158.771 105.564 159.571 105.868 160.211 106.476C160.851 107.052 161.171 107.756 161.171 108.588C161.171 109.356 160.851 110.06 160.211 110.7C159.571 111.308 158.771 111.612 157.811 111.612ZM157.811 139.5C156.915 139.5 156.179 139.292 155.603 138.876C155.027 138.46 154.739 137.996 154.739 137.484V118.62C154.739 118.044 155.027 117.58 155.603 117.228C156.179 116.876 156.915 116.7 157.811 116.7C158.675 116.7 159.411 116.876 160.019 117.228C160.627 117.58 160.931 118.044 160.931 118.62V137.484C160.931 137.996 160.627 138.46 160.019 138.876C159.411 139.292 158.675 139.5 157.811 139.5ZM168.732 139.5C167.836 139.5 167.1 139.292 166.524 138.876C165.948 138.46 165.66 137.996 165.66 137.484V118.62C165.66 118.044 165.948 117.58 166.524 117.228C167.1 116.876 167.836 116.7 168.732 116.7C169.5 116.7 170.14 116.876 170.652 117.228C171.196 117.58 171.468 118.044 171.468 118.62V120.06C171.948 119.132 172.732 118.3 173.82 117.564C174.94 116.796 176.3 116.412 177.9 116.412C179.404 116.412 180.78 116.86 182.028 117.756C183.276 118.62 184.268 119.788 185.004 121.26C185.772 122.732 186.156 124.364 186.156 126.156V137.484C186.156 138.156 185.836 138.668 185.196 139.02C184.556 139.34 183.836 139.5 183.036 139.5C182.332 139.5 181.644 139.34 180.972 139.02C180.3 138.668 179.964 138.156 179.964 137.484V126.156C179.964 125.42 179.772 124.732 179.388 124.092C179.036 123.452 178.54 122.924 177.9 122.508C177.26 122.06 176.556 121.836 175.788 121.836C175.148 121.836 174.524 122.012 173.916 122.364C173.308 122.716 172.812 123.212 172.428 123.852C172.044 124.492 171.852 125.26 171.852 126.156V137.484C171.852 137.996 171.548 138.46 170.94 138.876C170.332 139.292 169.596 139.5 168.732 139.5ZM199.761 150.108C197.873 150.108 196.113 149.836 194.481 149.292C192.881 148.78 191.585 148.012 190.593 146.988C189.633 145.964 189.153 144.748 189.153 143.34C189.153 142.124 189.489 141.084 190.161 140.22C190.833 139.388 191.665 138.732 192.657 138.252C192.049 137.964 191.553 137.58 191.169 137.1C190.817 136.588 190.641 135.948 190.641 135.18C190.641 134.284 190.865 133.564 191.313 133.02C191.793 132.444 192.385 131.916 193.089 131.436C192.129 130.7 191.377 129.82 190.833 128.796C190.321 127.74 190.065 126.588 190.065 125.34V124.332C190.065 122.764 190.449 121.388 191.217 120.204C192.017 119.02 193.121 118.092 194.529 117.42C195.969 116.748 197.617 116.412 199.473 116.412C200.529 116.412 201.521 116.54 202.449 116.796C203.377 117.02 204.209 117.356 204.945 117.804C205.489 116.524 206.001 115.66 206.481 115.212C206.961 114.764 207.425 114.54 207.873 114.54C208.641 114.54 209.233 114.764 209.649 115.212C210.097 115.66 210.321 116.076 210.321 116.46C210.321 116.748 210.241 117.004 210.081 117.228C209.953 117.452 209.777 117.644 209.553 117.804C209.233 117.996 208.865 118.236 208.449 118.524C208.033 118.78 207.649 119.148 207.297 119.628C207.873 120.268 208.289 120.988 208.545 121.788C208.833 122.556 208.977 123.404 208.977 124.332V125.34C208.977 126.876 208.577 128.252 207.777 129.468C206.977 130.652 205.857 131.596 204.417 132.3C202.977 133.004 201.329 133.356 199.473 133.356C198.321 133.356 197.281 133.212 196.353 132.924C196.193 133.052 196.049 133.196 195.921 133.356C195.825 133.516 195.777 133.692 195.777 133.884C195.777 134.428 196.129 134.812 196.833 135.036C197.537 135.26 198.433 135.436 199.521 135.564C200.609 135.692 201.761 135.868 202.977 136.092C204.225 136.284 205.393 136.604 206.481 137.052C207.569 137.5 208.465 138.172 209.169 139.068C209.873 139.932 210.225 141.1 210.225 142.572C210.225 144.364 209.713 145.804 208.689 146.892C207.697 148.012 206.401 148.828 204.801 149.34C203.233 149.852 201.553 150.108 199.761 150.108ZM199.665 146.124C200.913 146.124 201.969 145.82 202.833 145.212C203.729 144.604 204.177 143.788 204.177 142.764C204.177 142.092 203.985 141.548 203.601 141.132C203.217 140.716 202.689 140.396 202.017 140.172C201.377 139.98 200.673 139.82 199.905 139.692C199.137 139.596 198.369 139.5 197.601 139.404C196.833 139.756 196.209 140.204 195.729 140.748C195.249 141.292 195.009 141.948 195.009 142.716C195.009 143.772 195.457 144.604 196.353 145.212C197.281 145.82 198.385 146.124 199.665 146.124ZM199.569 129.612C200.625 129.612 201.457 129.212 202.065 128.412C202.673 127.612 202.977 126.588 202.977 125.34V124.332C202.977 123.148 202.673 122.156 202.065 121.356C201.489 120.556 200.641 120.156 199.521 120.156C198.433 120.156 197.585 120.556 196.977 121.356C196.401 122.156 196.113 123.148 196.113 124.332V125.292C196.113 126.508 196.401 127.532 196.977 128.364C197.585 129.196 198.449 129.612 199.569 129.612ZM218.275 139.932C216.579 139.932 215.107 139.42 213.859 138.396C212.643 137.34 212.035 135.724 212.035 133.548C212.035 131.724 212.499 130.3 213.427 129.276C214.387 128.252 215.699 127.532 217.363 127.116C219.059 126.7 221.011 126.492 223.219 126.492H225.187V125.868C225.187 125.164 225.043 124.476 224.755 123.804C224.499 123.132 224.067 122.572 223.459 122.124C222.883 121.676 222.051 121.452 220.963 121.452C219.747 121.452 218.803 121.58 218.131 121.836C217.491 122.06 216.995 122.3 216.643 122.556C216.291 122.812 215.907 122.94 215.491 122.94C214.819 122.94 214.291 122.604 213.907 121.932C213.555 121.26 213.379 120.572 213.379 119.868C213.379 119.196 213.779 118.604 214.579 118.092C215.411 117.548 216.419 117.132 217.603 116.844C218.787 116.556 219.939 116.412 221.059 116.412C223.555 116.412 225.555 116.86 227.059 117.756C228.563 118.652 229.651 119.804 230.323 121.212C231.027 122.62 231.379 124.14 231.379 125.772V137.484C231.379 138.06 231.091 138.54 230.515 138.924C229.939 139.308 229.219 139.5 228.355 139.5C227.555 139.5 226.883 139.308 226.339 138.924C225.827 138.54 225.571 138.06 225.571 137.484V136.14C224.707 137.132 223.683 138.012 222.499 138.78C221.347 139.548 219.939 139.932 218.275 139.932ZM220.771 135.324C221.443 135.324 222.115 135.1 222.787 134.652C223.459 134.204 224.019 133.628 224.467 132.924C224.947 132.22 225.187 131.484 225.187 130.716V129.708H224.467C223.411 129.708 222.403 129.772 221.443 129.9C220.483 130.028 219.699 130.316 219.091 130.764C218.515 131.18 218.227 131.836 218.227 132.732C218.227 133.628 218.467 134.284 218.947 134.7C219.459 135.116 220.067 135.324 220.771 135.324ZM239.045 150.108C238.181 150.108 237.461 149.9 236.885 149.484C236.309 149.068 236.021 148.62 236.021 148.14V118.62C236.021 118.044 236.309 117.58 236.885 117.228C237.461 116.876 238.165 116.7 238.997 116.7C239.829 116.7 240.501 116.876 241.013 117.228C241.557 117.58 241.829 118.044 241.829 118.62V120.06C242.373 119.132 243.205 118.3 244.325 117.564C245.445 116.796 246.773 116.412 248.309 116.412C249.941 116.412 251.397 116.86 252.677 117.756C253.989 118.62 255.013 119.788 255.749 121.26C256.517 122.732 256.901 124.364 256.901 126.156V130.092C256.901 131.788 256.517 133.388 255.749 134.892C254.981 136.396 253.957 137.612 252.677 138.54C251.429 139.468 250.037 139.932 248.501 139.932C247.093 139.932 245.813 139.548 244.661 138.78C243.509 138.012 242.693 137.132 242.213 136.14V148.14C242.213 148.62 241.909 149.068 241.301 149.484C240.693 149.9 239.941 150.108 239.045 150.108ZM246.485 134.508C247.253 134.508 247.941 134.3 248.549 133.884C249.189 133.436 249.701 132.876 250.085 132.204C250.501 131.532 250.709 130.828 250.709 130.092V126.156C250.709 125.42 250.517 124.732 250.133 124.092C249.749 123.452 249.221 122.924 248.549 122.508C247.909 122.06 247.189 121.836 246.389 121.836C245.685 121.836 245.013 122.012 244.373 122.364C243.765 122.716 243.253 123.212 242.837 123.852C242.421 124.492 242.213 125.26 242.213 126.156V130.956C242.213 131.276 242.389 131.724 242.741 132.3C243.125 132.844 243.637 133.356 244.277 133.836C244.917 134.284 245.653 134.508 246.485 134.508ZM270.368 139.932C268.512 139.932 266.8 139.484 265.232 138.588C263.664 137.66 262.4 136.444 261.44 134.94C260.48 133.436 260 131.82 260 130.092V126.156C260 124.428 260.464 122.828 261.392 121.356C262.32 119.852 263.568 118.652 265.136 117.756C266.736 116.86 268.48 116.412 270.368 116.412C272.256 116.412 273.984 116.86 275.552 117.756C277.152 118.62 278.416 119.788 279.344 121.26C280.304 122.732 280.784 124.364 280.784 126.156V130.092C280.784 131.788 280.304 133.388 279.344 134.892C278.384 136.396 277.104 137.612 275.504 138.54C273.936 139.468 272.224 139.932 270.368 139.932ZM270.368 134.508C271.136 134.508 271.84 134.3 272.48 133.884C273.12 133.468 273.632 132.924 274.016 132.252C274.4 131.548 274.592 130.828 274.592 130.092V126.156C274.592 125.42 274.4 124.732 274.016 124.092C273.632 123.452 273.12 122.924 272.48 122.508C271.872 122.06 271.168 121.836 270.368 121.836C269.6 121.836 268.896 122.044 268.256 122.46C267.616 122.876 267.104 123.42 266.72 124.092C266.368 124.732 266.192 125.42 266.192 126.156V130.092C266.192 130.828 266.368 131.548 266.72 132.252C267.104 132.924 267.616 133.468 268.256 133.884C268.896 134.3 269.6 134.508 270.368 134.508ZM287.747 139.5C286.883 139.5 286.163 139.292 285.587 138.876C285.011 138.46 284.723 137.996 284.723 137.484V118.62C284.723 118.044 285.011 117.58 285.587 117.228C286.163 116.876 286.883 116.7 287.747 116.7C288.547 116.7 289.203 116.876 289.715 117.228C290.259 117.58 290.531 118.044 290.531 118.62V120.588C290.883 119.884 291.347 119.228 291.923 118.62C292.531 117.98 293.219 117.452 293.987 117.036C294.755 116.62 295.571 116.412 296.435 116.412H297.923C298.531 116.412 299.059 116.684 299.507 117.228C299.955 117.74 300.179 118.364 300.179 119.1C300.179 119.868 299.955 120.524 299.507 121.068C299.059 121.58 298.531 121.836 297.923 121.836H296.435C295.539 121.836 294.659 122.14 293.795 122.748C292.963 123.324 292.275 124.14 291.731 125.196C291.187 126.22 290.915 127.468 290.915 128.94V137.484C290.915 137.996 290.611 138.46 290.003 138.876C289.395 139.292 288.643 139.5 287.747 139.5ZM312.912 139.932C310.64 139.932 308.624 139.532 306.864 138.732C305.136 137.9 303.776 136.748 302.784 135.276C301.792 133.772 301.296 132.044 301.296 130.092V126.012C301.296 124.284 301.76 122.7 302.688 121.26C303.648 119.788 304.912 118.62 306.48 117.756C308.08 116.86 309.856 116.412 311.808 116.412C313.6 116.412 315.232 116.796 316.704 117.564C318.208 118.332 319.424 119.388 320.352 120.732C321.28 122.076 321.744 123.644 321.744 125.436C321.744 126.812 321.52 127.804 321.072 128.412C320.624 128.988 320.048 129.356 319.344 129.516C318.672 129.644 317.968 129.708 317.232 129.708H307.488V130.428C307.488 131.804 308 132.924 309.024 133.788C310.08 134.62 311.44 135.036 313.104 135.036C314.16 135.036 315.04 134.876 315.744 134.556C316.448 134.236 317.056 133.932 317.568 133.644C318.08 133.356 318.56 133.212 319.008 133.212C319.488 133.212 319.904 133.372 320.256 133.692C320.608 134.012 320.88 134.396 321.072 134.844C321.264 135.26 321.36 135.628 321.36 135.948C321.36 136.492 321.008 137.084 320.304 137.724C319.632 138.332 318.656 138.86 317.376 139.308C316.128 139.724 314.64 139.932 312.912 139.932ZM307.488 126.06H314.496C315.04 126.06 315.408 125.98 315.6 125.82C315.824 125.628 315.936 125.276 315.936 124.764C315.936 124.028 315.728 123.372 315.312 122.796C314.928 122.22 314.416 121.772 313.776 121.452C313.168 121.132 312.48 120.972 311.712 120.972C310.976 120.972 310.288 121.132 309.648 121.452C309.008 121.74 308.48 122.172 308.064 122.748C307.68 123.292 307.488 123.948 307.488 124.716V126.06ZM326.945 144.3C326.497 144.3 326.033 144.156 325.553 143.868C325.105 143.612 324.881 143.212 324.881 142.668C324.881 142.444 324.929 142.22 325.025 141.996L326.177 139.452C325.633 139.132 325.201 138.732 324.881 138.252C324.561 137.74 324.401 137.164 324.401 136.524C324.401 135.628 324.705 134.86 325.313 134.22C325.953 133.58 326.721 133.26 327.617 133.26C328.513 133.26 329.281 133.58 329.921 134.22C330.561 134.828 330.881 135.58 330.881 136.476C330.881 136.604 330.849 136.78 330.785 137.004C330.753 137.196 330.657 137.516 330.497 137.964C330.337 138.412 330.065 139.068 329.681 139.932C329.329 140.828 328.849 142.012 328.241 143.484C328.113 143.772 327.921 143.98 327.665 144.108C327.409 144.236 327.169 144.3 326.945 144.3ZM360.564 139.5C357.684 139.5 355.476 138.876 353.94 137.628C352.436 136.38 351.684 134.396 351.684 131.676V108.444C351.684 107.868 352.02 107.404 352.692 107.052C353.364 106.7 354.052 106.524 354.756 106.524C355.524 106.524 356.228 106.7 356.868 107.052C357.54 107.404 357.876 107.868 357.876 108.444V116.7H363.54C364.052 116.7 364.436 116.94 364.692 117.42C364.98 117.868 365.124 118.38 365.124 118.956C365.124 119.532 364.98 120.06 364.692 120.54C364.436 120.988 364.052 121.212 363.54 121.212H357.876V131.676C357.876 132.636 358.068 133.308 358.452 133.692C358.868 134.076 359.572 134.268 360.564 134.268H362.436C363.332 134.268 363.988 134.54 364.404 135.084C364.852 135.628 365.076 136.22 365.076 136.86C365.076 137.532 364.852 138.14 364.404 138.684C363.988 139.228 363.332 139.5 362.436 139.5H360.564ZM371.4 139.5C370.504 139.5 369.768 139.292 369.192 138.876C368.616 138.46 368.328 137.996 368.328 137.484V105.324C368.328 104.748 368.616 104.284 369.192 103.932C369.768 103.58 370.504 103.404 371.4 103.404C372.264 103.404 373 103.58 373.608 103.932C374.216 104.284 374.52 104.748 374.52 105.324V120.06C375 119.132 375.752 118.3 376.776 117.564C377.8 116.796 379.064 116.412 380.568 116.412C382.072 116.412 383.448 116.86 384.696 117.756C385.944 118.62 386.936 119.788 387.672 121.26C388.44 122.732 388.824 124.364 388.824 126.156V137.484C388.824 138.156 388.504 138.668 387.864 139.02C387.224 139.34 386.504 139.5 385.704 139.5C385 139.5 384.312 139.34 383.64 139.02C382.968 138.668 382.632 138.156 382.632 137.484V126.156C382.632 125.42 382.44 124.732 382.056 124.092C381.672 123.452 381.16 122.924 380.52 122.508C379.912 122.06 379.224 121.836 378.456 121.836C377.816 121.836 377.192 122.012 376.584 122.364C375.976 122.716 375.48 123.212 375.096 123.852C374.712 124.492 374.52 125.26 374.52 126.156V137.484C374.52 137.996 374.216 138.46 373.608 138.876C373 139.292 372.264 139.5 371.4 139.5ZM404.204 139.932C401.932 139.932 399.916 139.532 398.156 138.732C396.428 137.9 395.068 136.748 394.076 135.276C393.084 133.772 392.588 132.044 392.588 130.092V126.012C392.588 124.284 393.052 122.7 393.98 121.26C394.94 119.788 396.204 118.62 397.772 117.756C399.372 116.86 401.148 116.412 403.1 116.412C404.892 116.412 406.524 116.796 407.996 117.564C409.5 118.332 410.716 119.388 411.644 120.732C412.572 122.076 413.036 123.644 413.036 125.436C413.036 126.812 412.812 127.804 412.364 128.412C411.916 128.988 411.34 129.356 410.636 129.516C409.964 129.644 409.26 129.708 408.524 129.708H398.78V130.428C398.78 131.804 399.292 132.924 400.316 133.788C401.372 134.62 402.732 135.036 404.396 135.036C405.452 135.036 406.332 134.876 407.036 134.556C407.74 134.236 408.348 133.932 408.86 133.644C409.372 133.356 409.852 133.212 410.3 133.212C410.78 133.212 411.196 133.372 411.548 133.692C411.9 134.012 412.172 134.396 412.364 134.844C412.556 135.26 412.652 135.628 412.652 135.948C412.652 136.492 412.3 137.084 411.596 137.724C410.924 138.332 409.948 138.86 408.668 139.308C407.42 139.724 405.932 139.932 404.204 139.932ZM398.78 126.06H405.788C406.332 126.06 406.7 125.98 406.892 125.82C407.116 125.628 407.228 125.276 407.228 124.764C407.228 124.028 407.02 123.372 406.604 122.796C406.22 122.22 405.708 121.772 405.068 121.452C404.46 121.132 403.772 120.972 403.004 120.972C402.268 120.972 401.58 121.132 400.94 121.452C400.3 121.74 399.772 122.172 399.356 122.748C398.972 123.292 398.78 123.948 398.78 124.716V126.06ZM436.956 139.5C436.06 139.5 435.324 139.292 434.748 138.876C434.172 138.46 433.884 137.996 433.884 137.484V118.62C433.884 118.044 434.172 117.58 434.748 117.228C435.324 116.876 436.06 116.7 436.956 116.7C437.724 116.7 438.364 116.876 438.876 117.228C439.42 117.58 439.692 118.044 439.692 118.62V120.06C440.236 119.132 441.036 118.3 442.092 117.564C443.148 116.796 444.476 116.412 446.076 116.412C447.452 116.412 448.668 116.86 449.724 117.756C450.78 118.652 451.564 119.804 452.076 121.212C452.908 119.58 453.964 118.38 455.244 117.612C456.556 116.812 457.9 116.412 459.276 116.412C460.748 116.412 462.124 116.796 463.404 117.564C464.716 118.3 465.772 119.404 466.572 120.876C467.404 122.316 467.82 124.076 467.82 126.156V137.484C467.82 137.996 467.516 138.46 466.908 138.876C466.3 139.292 465.564 139.5 464.7 139.5C463.868 139.5 463.148 139.292 462.54 138.876C461.932 138.46 461.628 137.996 461.628 137.484V126.156C461.628 125.196 461.436 124.396 461.052 123.756C460.7 123.116 460.22 122.636 459.612 122.316C459.004 121.964 458.38 121.788 457.74 121.788C457.132 121.788 456.54 121.964 455.964 122.316C455.388 122.636 454.908 123.116 454.524 123.756C454.14 124.396 453.948 125.18 453.948 126.108V137.532C453.948 138.236 453.612 138.748 452.94 139.068C452.3 139.356 451.596 139.5 450.828 139.5C450.124 139.5 449.436 139.356 448.764 139.068C448.092 138.748 447.756 138.236 447.756 137.532V126.156C447.756 125.26 447.564 124.492 447.18 123.852C446.828 123.212 446.348 122.716 445.74 122.364C445.164 122.012 444.54 121.836 443.868 121.836C443.228 121.836 442.62 121.996 442.044 122.316C441.468 122.636 440.988 123.116 440.604 123.756C440.252 124.396 440.076 125.196 440.076 126.156V137.484C440.076 137.996 439.772 138.46 439.164 138.876C438.556 139.292 437.82 139.5 436.956 139.5ZM483.168 139.932C480.896 139.932 478.88 139.532 477.12 138.732C475.392 137.9 474.032 136.748 473.04 135.276C472.048 133.772 471.552 132.044 471.552 130.092V126.012C471.552 124.284 472.016 122.7 472.944 121.26C473.904 119.788 475.168 118.62 476.736 117.756C478.336 116.86 480.112 116.412 482.064 116.412C483.856 116.412 485.488 116.796 486.96 117.564C488.464 118.332 489.68 119.388 490.608 120.732C491.536 122.076 492 123.644 492 125.436C492 126.812 491.776 127.804 491.328 128.412C490.88 128.988 490.304 129.356 489.6 129.516C488.928 129.644 488.224 129.708 487.488 129.708H477.744V130.428C477.744 131.804 478.256 132.924 479.28 133.788C480.336 134.62 481.696 135.036 483.36 135.036C484.416 135.036 485.296 134.876 486 134.556C486.704 134.236 487.312 133.932 487.824 133.644C488.336 133.356 488.816 133.212 489.264 133.212C489.744 133.212 490.16 133.372 490.512 133.692C490.864 134.012 491.136 134.396 491.328 134.844C491.52 135.26 491.616 135.628 491.616 135.948C491.616 136.492 491.264 137.084 490.56 137.724C489.888 138.332 488.912 138.86 487.632 139.308C486.384 139.724 484.896 139.932 483.168 139.932ZM477.744 126.06H484.752C485.296 126.06 485.664 125.98 485.856 125.82C486.08 125.628 486.192 125.276 486.192 124.764C486.192 124.028 485.984 123.372 485.568 122.796C485.184 122.22 484.672 121.772 484.032 121.452C483.424 121.132 482.736 120.972 481.968 120.972C481.232 120.972 480.544 121.132 479.904 121.452C479.264 121.74 478.736 122.172 478.32 122.748C477.936 123.292 477.744 123.948 477.744 124.716V126.06ZM498.785 139.5C497.889 139.5 497.153 139.292 496.577 138.876C496.001 138.46 495.713 137.996 495.713 137.484V118.62C495.713 118.044 496.001 117.58 496.577 117.228C497.153 116.876 497.889 116.7 498.785 116.7C499.553 116.7 500.193 116.876 500.705 117.228C501.249 117.58 501.521 118.044 501.521 118.62V120.06C502.065 119.132 502.865 118.3 503.921 117.564C504.977 116.796 506.305 116.412 507.905 116.412C509.281 116.412 510.497 116.86 511.553 117.756C512.609 118.652 513.393 119.804 513.905 121.212C514.737 119.58 515.793 118.38 517.073 117.612C518.385 116.812 519.729 116.412 521.105 116.412C522.577 116.412 523.953 116.796 525.233 117.564C526.545 118.3 527.601 119.404 528.401 120.876C529.233 122.316 529.649 124.076 529.649 126.156V137.484C529.649 137.996 529.345 138.46 528.737 138.876C528.129 139.292 527.393 139.5 526.529 139.5C525.697 139.5 524.977 139.292 524.369 138.876C523.761 138.46 523.457 137.996 523.457 137.484V126.156C523.457 125.196 523.265 124.396 522.881 123.756C522.529 123.116 522.049 122.636 521.441 122.316C520.833 121.964 520.209 121.788 519.569 121.788C518.961 121.788 518.369 121.964 517.793 122.316C517.217 122.636 516.737 123.116 516.353 123.756C515.969 124.396 515.777 125.18 515.777 126.108V137.532C515.777 138.236 515.441 138.748 514.769 139.068C514.129 139.356 513.425 139.5 512.657 139.5C511.953 139.5 511.265 139.356 510.593 139.068C509.921 138.748 509.585 138.236 509.585 137.532V126.156C509.585 125.26 509.393 124.492 509.009 123.852C508.657 123.212 508.177 122.716 507.569 122.364C506.993 122.012 506.369 121.836 505.697 121.836C505.057 121.836 504.449 121.996 503.873 122.316C503.297 122.636 502.817 123.116 502.433 123.756C502.081 124.396 501.905 125.196 501.905 126.156V137.484C501.905 137.996 501.601 138.46 500.993 138.876C500.385 139.292 499.649 139.5 498.785 139.5ZM546.772 139.932C545.268 139.932 543.908 139.548 542.692 138.78C541.476 138.012 540.612 137.132 540.1 136.14V137.484C540.1 137.996 539.828 138.46 539.284 138.876C538.772 139.292 538.116 139.5 537.316 139.5C536.452 139.5 535.732 139.292 535.156 138.876C534.58 138.46 534.292 137.996 534.292 137.484V105.324C534.292 104.748 534.58 104.284 535.156 103.932C535.732 103.58 536.452 103.404 537.316 103.404C538.212 103.404 538.964 103.58 539.572 103.932C540.18 104.284 540.484 104.748 540.484 105.324V120.06C540.996 119.132 541.78 118.3 542.836 117.564C543.892 116.796 545.172 116.412 546.676 116.412C548.244 116.412 549.668 116.86 550.948 117.756C552.228 118.62 553.252 119.788 554.02 121.26C554.788 122.732 555.172 124.364 555.172 126.156V130.092C555.172 131.788 554.788 133.388 554.02 134.892C553.252 136.396 552.228 137.612 550.948 138.54C549.7 139.468 548.308 139.932 546.772 139.932ZM544.804 134.508C545.572 134.508 546.276 134.3 546.916 133.884C547.556 133.436 548.052 132.876 548.404 132.204C548.788 131.532 548.98 130.828 548.98 130.092V126.156C548.98 125.42 548.788 124.732 548.404 124.092C548.052 123.452 547.556 122.924 546.916 122.508C546.276 122.06 545.556 121.836 544.756 121.836C544.084 121.836 543.412 122.012 542.74 122.364C542.1 122.716 541.556 123.212 541.108 123.852C540.692 124.492 540.484 125.26 540.484 126.156V130.956C540.484 131.276 540.676 131.724 541.06 132.3C541.444 132.844 541.956 133.356 542.596 133.836C543.268 134.284 544.004 134.508 544.804 134.508ZM569.886 139.932C567.614 139.932 565.598 139.532 563.838 138.732C562.11 137.9 560.75 136.748 559.758 135.276C558.766 133.772 558.27 132.044 558.27 130.092V126.012C558.27 124.284 558.734 122.7 559.662 121.26C560.622 119.788 561.886 118.62 563.454 117.756C565.054 116.86 566.83 116.412 568.782 116.412C570.574 116.412 572.206 116.796 573.678 117.564C575.182 118.332 576.398 119.388 577.326 120.732C578.254 122.076 578.718 123.644 578.718 125.436C578.718 126.812 578.494 127.804 578.046 128.412C577.598 128.988 577.022 129.356 576.318 129.516C575.646 129.644 574.942 129.708 574.206 129.708H564.462V130.428C564.462 131.804 564.974 132.924 565.998 133.788C567.054 134.62 568.414 135.036 570.078 135.036C571.134 135.036 572.014 134.876 572.718 134.556C573.422 134.236 574.03 133.932 574.542 133.644C575.054 133.356 575.534 133.212 575.982 133.212C576.462 133.212 576.878 133.372 577.23 133.692C577.582 134.012 577.854 134.396 578.046 134.844C578.238 135.26 578.334 135.628 578.334 135.948C578.334 136.492 577.982 137.084 577.278 137.724C576.606 138.332 575.63 138.86 574.35 139.308C573.102 139.724 571.614 139.932 569.886 139.932ZM564.462 126.06H571.47C572.014 126.06 572.382 125.98 572.574 125.82C572.798 125.628 572.91 125.276 572.91 124.764C572.91 124.028 572.702 123.372 572.286 122.796C571.902 122.22 571.39 121.772 570.75 121.452C570.142 121.132 569.454 120.972 568.686 120.972C567.95 120.972 567.262 121.132 566.622 121.452C565.982 121.74 565.454 122.172 565.038 122.748C564.654 123.292 564.462 123.948 564.462 124.716V126.06ZM585.455 139.5C584.591 139.5 583.871 139.292 583.295 138.876C582.719 138.46 582.431 137.996 582.431 137.484V118.62C582.431 118.044 582.719 117.58 583.295 117.228C583.871 116.876 584.591 116.7 585.455 116.7C586.255 116.7 586.911 116.876 587.423 117.228C587.967 117.58 588.239 118.044 588.239 118.62V120.588C588.591 119.884 589.055 119.228 589.631 118.62C590.239 117.98 590.927 117.452 591.695 117.036C592.463 116.62 593.279 116.412 594.143 116.412H595.631C596.239 116.412 596.767 116.684 597.215 117.228C597.663 117.74 597.887 118.364 597.887 119.1C597.887 119.868 597.663 120.524 597.215 121.068C596.767 121.58 596.239 121.836 595.631 121.836H594.143C593.247 121.836 592.367 122.14 591.503 122.748C590.671 123.324 589.983 124.14 589.439 125.196C588.895 126.22 588.623 127.468 588.623 128.94V137.484C588.623 137.996 588.319 138.46 587.711 138.876C587.103 139.292 586.351 139.5 585.455 139.5ZM607.824 139.932C606.224 139.932 604.752 139.74 603.408 139.356C602.096 138.94 601.056 138.412 600.288 137.772C599.552 137.132 599.184 136.476 599.184 135.804C599.184 135.452 599.264 135.068 599.424 134.652C599.616 134.236 599.856 133.868 600.144 133.548C600.464 133.228 600.832 133.068 601.248 133.068C601.696 133.068 602.16 133.26 602.64 133.644C603.152 133.996 603.776 134.348 604.512 134.7C605.28 135.052 606.336 135.228 607.68 135.228C609.12 135.228 610.064 135.004 610.512 134.556C610.992 134.108 611.232 133.644 611.232 133.164C611.232 132.46 610.944 131.916 610.368 131.532C609.824 131.148 609.12 130.844 608.256 130.62C607.392 130.364 606.464 130.092 605.472 129.804C604.512 129.516 603.6 129.148 602.736 128.7C601.872 128.22 601.168 127.58 600.624 126.78C600.08 125.948 599.808 124.876 599.808 123.564C599.808 122.412 600.08 121.292 600.624 120.204C601.168 119.116 602.064 118.22 603.312 117.516C604.56 116.78 606.256 116.412 608.4 116.412C609.712 116.412 610.944 116.556 612.096 116.844C613.28 117.1 614.24 117.468 614.976 117.948C615.712 118.428 616.08 118.956 616.08 119.532C616.08 119.82 615.984 120.204 615.792 120.684C615.6 121.132 615.328 121.548 614.976 121.932C614.656 122.316 614.256 122.508 613.776 122.508C613.424 122.508 612.992 122.396 612.48 122.172C612 121.916 611.44 121.676 610.8 121.452C610.16 121.228 609.392 121.116 608.496 121.116C607.696 121.116 607.056 121.228 606.576 121.452C606.096 121.676 605.744 121.948 605.52 122.268C605.296 122.588 605.184 122.924 605.184 123.276C605.184 123.852 605.456 124.3 606 124.62C606.544 124.94 607.248 125.212 608.112 125.436C609.008 125.66 609.936 125.916 610.896 126.204C611.888 126.46 612.816 126.844 613.68 127.356C614.576 127.868 615.296 128.572 615.84 129.468C616.384 130.332 616.656 131.468 616.656 132.876C616.656 135.02 615.888 136.732 614.352 138.012C612.848 139.292 610.672 139.932 607.824 139.932ZM84.904 209.932C83.048 209.932 81.336 209.484 79.768 208.588C78.2 207.66 76.936 206.444 75.976 204.94C75.016 203.436 74.536 201.82 74.536 200.092V196.156C74.536 194.428 75 192.828 75.928 191.356C76.856 189.852 78.104 188.652 79.672 187.756C81.272 186.86 83.016 186.412 84.904 186.412C86.792 186.412 88.52 186.86 90.088 187.756C91.688 188.62 92.952 189.788 93.88 191.26C94.84 192.732 95.32 194.364 95.32 196.156V200.092C95.32 201.788 94.84 203.388 93.88 204.892C92.92 206.396 91.64 207.612 90.04 208.54C88.472 209.468 86.76 209.932 84.904 209.932ZM84.904 204.508C85.672 204.508 86.376 204.3 87.016 203.884C87.656 203.468 88.168 202.924 88.552 202.252C88.936 201.548 89.128 200.828 89.128 200.092V196.156C89.128 195.42 88.936 194.732 88.552 194.092C88.168 193.452 87.656 192.924 87.016 192.508C86.408 192.06 85.704 191.836 84.904 191.836C84.136 191.836 83.432 192.044 82.792 192.46C82.152 192.876 81.64 193.42 81.256 194.092C80.904 194.732 80.728 195.42 80.728 196.156V200.092C80.728 200.828 80.904 201.548 81.256 202.252C81.64 202.924 82.152 203.468 82.792 203.884C83.432 204.3 84.136 204.508 84.904 204.508ZM102.331 209.5C101.467 209.5 100.747 209.324 100.171 208.972C99.5954 208.588 99.3074 208.108 99.3074 207.532V182.812C99.3074 181.02 99.6914 179.42 100.459 178.012C101.227 176.572 102.251 175.452 103.531 174.652C104.811 173.82 106.219 173.404 107.755 173.404H110.587C111.355 173.404 111.931 173.676 112.315 174.22C112.731 174.764 112.939 175.356 112.939 175.996C112.939 176.7 112.731 177.324 112.315 177.868C111.931 178.38 111.355 178.636 110.587 178.636H109.051C108.379 178.636 107.771 178.78 107.227 179.068C106.683 179.356 106.251 179.756 105.931 180.268C105.643 180.78 105.499 181.404 105.499 182.14V186.7H111.355C111.867 186.7 112.251 186.94 112.507 187.42C112.795 187.868 112.939 188.38 112.939 188.956C112.939 189.532 112.795 190.06 112.507 190.54C112.251 190.988 111.867 191.212 111.355 191.212H105.499V207.532C105.499 208.108 105.179 208.588 104.539 208.972C103.931 209.324 103.195 209.5 102.331 209.5ZM139.198 209.932C137.694 209.932 136.302 209.468 135.022 208.54C133.742 207.612 132.718 206.396 131.95 204.892C131.182 203.388 130.798 201.788 130.798 200.092V196.156C130.798 194.364 131.182 192.732 131.95 191.26C132.718 189.788 133.742 188.62 135.022 187.756C136.302 186.86 137.726 186.412 139.294 186.412C140.798 186.412 142.078 186.796 143.134 187.564C144.19 188.3 144.974 189.132 145.486 190.06V175.324C145.486 174.748 145.79 174.284 146.398 173.932C147.006 173.58 147.758 173.404 148.654 173.404C149.518 173.404 150.238 173.58 150.814 173.932C151.39 174.284 151.678 174.748 151.678 175.324V207.484C151.678 207.996 151.39 208.46 150.814 208.876C150.238 209.292 149.518 209.5 148.654 209.5C147.886 209.5 147.23 209.292 146.686 208.876C146.142 208.46 145.87 207.996 145.87 207.484V206.14C145.39 207.132 144.526 208.012 143.278 208.78C142.062 209.548 140.702 209.932 139.198 209.932ZM141.166 204.508C141.998 204.508 142.734 204.284 143.374 203.836C144.014 203.356 144.526 202.844 144.91 202.3C145.294 201.724 145.486 201.276 145.486 200.956V196.156C145.486 195.26 145.262 194.492 144.814 193.852C144.398 193.212 143.854 192.716 143.182 192.364C142.542 192.012 141.886 191.836 141.214 191.836C140.446 191.836 139.726 192.06 139.054 192.508C138.414 192.924 137.902 193.452 137.518 194.092C137.166 194.732 136.99 195.42 136.99 196.156V200.092C136.99 200.828 137.166 201.532 137.518 202.204C137.902 202.876 138.414 203.436 139.054 203.884C139.694 204.3 140.398 204.508 141.166 204.508ZM159.576 181.612C158.648 181.612 157.848 181.308 157.176 180.7C156.504 180.06 156.168 179.356 156.168 178.588C156.168 177.756 156.504 177.052 157.176 176.476C157.848 175.868 158.648 175.564 159.576 175.564C160.536 175.564 161.336 175.868 161.976 176.476C162.616 177.052 162.936 177.756 162.936 178.588C162.936 179.356 162.616 180.06 161.976 180.7C161.336 181.308 160.536 181.612 159.576 181.612ZM159.576 209.5C158.68 209.5 157.944 209.292 157.368 208.876C156.792 208.46 156.504 207.996 156.504 207.484V188.62C156.504 188.044 156.792 187.58 157.368 187.228C157.944 186.876 158.68 186.7 159.576 186.7C160.44 186.7 161.176 186.876 161.784 187.228C162.392 187.58 162.696 188.044 162.696 188.62V207.484C162.696 207.996 162.392 208.46 161.784 208.876C161.176 209.292 160.44 209.5 159.576 209.5ZM170.498 209.5C169.634 209.5 168.914 209.324 168.338 208.972C167.762 208.588 167.474 208.108 167.474 207.532V182.812C167.474 181.02 167.858 179.42 168.626 178.012C169.394 176.572 170.418 175.452 171.698 174.652C172.978 173.82 174.386 173.404 175.922 173.404H178.754C179.522 173.404 180.098 173.676 180.482 174.22C180.898 174.764 181.106 175.356 181.106 175.996C181.106 176.7 180.898 177.324 180.482 177.868C180.098 178.38 179.522 178.636 178.754 178.636H177.218C176.546 178.636 175.938 178.78 175.394 179.068C174.85 179.356 174.418 179.756 174.098 180.268C173.81 180.78 173.666 181.404 173.666 182.14V186.7H179.522C180.034 186.7 180.418 186.94 180.674 187.42C180.962 187.868 181.106 188.38 181.106 188.956C181.106 189.532 180.962 190.06 180.674 190.54C180.418 190.988 180.034 191.212 179.522 191.212H173.666V207.532C173.666 208.108 173.346 208.588 172.706 208.972C172.098 209.324 171.362 209.5 170.498 209.5ZM186.811 209.5C185.947 209.5 185.227 209.324 184.651 208.972C184.075 208.588 183.787 208.108 183.787 207.532V182.812C183.787 181.02 184.171 179.42 184.939 178.012C185.707 176.572 186.731 175.452 188.011 174.652C189.291 173.82 190.699 173.404 192.235 173.404H195.067C195.835 173.404 196.411 173.676 196.795 174.22C197.211 174.764 197.419 175.356 197.419 175.996C197.419 176.7 197.211 177.324 196.795 177.868C196.411 178.38 195.835 178.636 195.067 178.636H193.531C192.859 178.636 192.251 178.78 191.707 179.068C191.163 179.356 190.731 179.756 190.411 180.268C190.123 180.78 189.979 181.404 189.979 182.14V186.7H195.835C196.347 186.7 196.731 186.94 196.987 187.42C197.275 187.868 197.419 188.38 197.419 188.956C197.419 189.532 197.275 190.06 196.987 190.54C196.731 190.988 196.347 191.212 195.835 191.212H189.979V207.532C189.979 208.108 189.659 208.588 189.019 208.972C188.411 209.324 187.675 209.5 186.811 209.5ZM210.241 209.932C207.969 209.932 205.953 209.532 204.193 208.732C202.465 207.9 201.105 206.748 200.113 205.276C199.121 203.772 198.625 202.044 198.625 200.092V196.012C198.625 194.284 199.089 192.7 200.017 191.26C200.977 189.788 202.241 188.62 203.809 187.756C205.409 186.86 207.185 186.412 209.137 186.412C210.929 186.412 212.561 186.796 214.033 187.564C215.537 188.332 216.753 189.388 217.681 190.732C218.609 192.076 219.073 193.644 219.073 195.436C219.073 196.812 218.849 197.804 218.401 198.412C217.953 198.988 217.377 199.356 216.673 199.516C216.001 199.644 215.297 199.708 214.561 199.708H204.817V200.428C204.817 201.804 205.329 202.924 206.353 203.788C207.409 204.62 208.769 205.036 210.433 205.036C211.489 205.036 212.369 204.876 213.073 204.556C213.777 204.236 214.385 203.932 214.897 203.644C215.409 203.356 215.889 203.212 216.337 203.212C216.817 203.212 217.233 203.372 217.585 203.692C217.937 204.012 218.209 204.396 218.401 204.844C218.593 205.26 218.689 205.628 218.689 205.948C218.689 206.492 218.337 207.084 217.633 207.724C216.961 208.332 215.985 208.86 214.705 209.308C213.457 209.724 211.969 209.932 210.241 209.932ZM204.817 196.06H211.825C212.369 196.06 212.737 195.98 212.929 195.82C213.153 195.628 213.265 195.276 213.265 194.764C213.265 194.028 213.057 193.372 212.641 192.796C212.257 192.22 211.745 191.772 211.105 191.452C210.497 191.132 209.809 190.972 209.041 190.972C208.305 190.972 207.617 191.132 206.977 191.452C206.337 191.74 205.809 192.172 205.393 192.748C205.009 193.292 204.817 193.948 204.817 194.716V196.06ZM225.809 209.5C224.945 209.5 224.225 209.292 223.649 208.876C223.073 208.46 222.785 207.996 222.785 207.484V188.62C222.785 188.044 223.073 187.58 223.649 187.228C224.225 186.876 224.945 186.7 225.809 186.7C226.609 186.7 227.265 186.876 227.777 187.228C228.321 187.58 228.593 188.044 228.593 188.62V190.588C228.945 189.884 229.409 189.228 229.985 188.62C230.593 187.98 231.281 187.452 232.049 187.036C232.817 186.62 233.633 186.412 234.497 186.412H235.985C236.593 186.412 237.121 186.684 237.569 187.228C238.017 187.74 238.241 188.364 238.241 189.1C238.241 189.868 238.017 190.524 237.569 191.068C237.121 191.58 236.593 191.836 235.985 191.836H234.497C233.601 191.836 232.721 192.14 231.857 192.748C231.025 193.324 230.337 194.14 229.793 195.196C229.249 196.22 228.977 197.468 228.977 198.94V207.484C228.977 207.996 228.673 208.46 228.065 208.876C227.457 209.292 226.705 209.5 225.809 209.5ZM250.975 209.932C248.703 209.932 246.687 209.532 244.927 208.732C243.199 207.9 241.839 206.748 240.847 205.276C239.855 203.772 239.359 202.044 239.359 200.092V196.012C239.359 194.284 239.823 192.7 240.751 191.26C241.711 189.788 242.975 188.62 244.543 187.756C246.143 186.86 247.919 186.412 249.871 186.412C251.663 186.412 253.295 186.796 254.767 187.564C256.271 188.332 257.487 189.388 258.415 190.732C259.343 192.076 259.807 193.644 259.807 195.436C259.807 196.812 259.583 197.804 259.135 198.412C258.687 198.988 258.111 199.356 257.407 199.516C256.735 199.644 256.031 199.708 255.295 199.708H245.551V200.428C245.551 201.804 246.063 202.924 247.087 203.788C248.143 204.62 249.503 205.036 251.167 205.036C252.223 205.036 253.103 204.876 253.807 204.556C254.511 204.236 255.119 203.932 255.631 203.644C256.143 203.356 256.623 203.212 257.071 203.212C257.551 203.212 257.967 203.372 258.319 203.692C258.671 204.012 258.943 204.396 259.135 204.844C259.327 205.26 259.423 205.628 259.423 205.948C259.423 206.492 259.071 207.084 258.367 207.724C257.695 208.332 256.719 208.86 255.439 209.308C254.191 209.724 252.703 209.932 250.975 209.932ZM245.551 196.06H252.559C253.103 196.06 253.471 195.98 253.663 195.82C253.887 195.628 253.999 195.276 253.999 194.764C253.999 194.028 253.791 193.372 253.375 192.796C252.991 192.22 252.479 191.772 251.839 191.452C251.231 191.132 250.543 190.972 249.775 190.972C249.039 190.972 248.351 191.132 247.711 191.452C247.071 191.74 246.543 192.172 246.127 192.748C245.743 193.292 245.551 193.948 245.551 194.716V196.06ZM266.592 209.5C265.696 209.5 264.96 209.292 264.384 208.876C263.808 208.46 263.52 207.996 263.52 207.484V188.62C263.52 188.044 263.808 187.58 264.384 187.228C264.96 186.876 265.696 186.7 266.592 186.7C267.36 186.7 268 186.876 268.512 187.228C269.056 187.58 269.328 188.044 269.328 188.62V190.06C269.808 189.132 270.592 188.3 271.68 187.564C272.8 186.796 274.16 186.412 275.76 186.412C277.264 186.412 278.64 186.86 279.888 187.756C281.136 188.62 282.128 189.788 282.864 191.26C283.632 192.732 284.016 194.364 284.016 196.156V207.484C284.016 208.156 283.696 208.668 283.056 209.02C282.416 209.34 281.696 209.5 280.896 209.5C280.192 209.5 279.504 209.34 278.832 209.02C278.16 208.668 277.824 208.156 277.824 207.484V196.156C277.824 195.42 277.632 194.732 277.248 194.092C276.896 193.452 276.4 192.924 275.76 192.508C275.12 192.06 274.416 191.836 273.648 191.836C273.008 191.836 272.384 192.012 271.776 192.364C271.168 192.716 270.672 193.212 270.288 193.852C269.904 194.492 269.712 195.26 269.712 196.156V207.484C269.712 207.996 269.408 208.46 268.8 208.876C268.192 209.292 267.456 209.5 266.592 209.5ZM297.429 209.5C294.549 209.5 292.341 208.876 290.805 207.628C289.301 206.38 288.549 204.396 288.549 201.676V178.444C288.549 177.868 288.885 177.404 289.557 177.052C290.229 176.7 290.917 176.524 291.621 176.524C292.389 176.524 293.093 176.7 293.733 177.052C294.405 177.404 294.741 177.868 294.741 178.444V186.7H300.405C300.917 186.7 301.301 186.94 301.557 187.42C301.845 187.868 301.989 188.38 301.989 188.956C301.989 189.532 301.845 190.06 301.557 190.54C301.301 190.988 300.917 191.212 300.405 191.212H294.741V201.676C294.741 202.636 294.933 203.308 295.317 203.692C295.733 204.076 296.437 204.268 297.429 204.268H299.301C300.197 204.268 300.853 204.54 301.269 205.084C301.717 205.628 301.941 206.22 301.941 206.86C301.941 207.532 301.717 208.14 301.269 208.684C300.853 209.228 300.197 209.5 299.301 209.5H297.429ZM324.21 209.5C323.346 209.5 322.626 209.292 322.05 208.876C321.474 208.46 321.186 207.996 321.186 207.484V188.62C321.186 188.044 321.474 187.58 322.05 187.228C322.626 186.876 323.346 186.7 324.21 186.7C325.01 186.7 325.666 186.876 326.178 187.228C326.722 187.58 326.994 188.044 326.994 188.62V190.588C327.346 189.884 327.81 189.228 328.386 188.62C328.994 187.98 329.682 187.452 330.45 187.036C331.218 186.62 332.034 186.412 332.898 186.412H334.386C334.994 186.412 335.522 186.684 335.97 187.228C336.418 187.74 336.642 188.364 336.642 189.1C336.642 189.868 336.418 190.524 335.97 191.068C335.522 191.58 334.994 191.836 334.386 191.836H332.898C332.002 191.836 331.122 192.14 330.258 192.748C329.426 193.324 328.738 194.14 328.194 195.196C327.65 196.22 327.378 197.468 327.378 198.94V207.484C327.378 207.996 327.074 208.46 326.466 208.876C325.858 209.292 325.106 209.5 324.21 209.5ZM349.376 209.932C347.104 209.932 345.088 209.532 343.328 208.732C341.6 207.9 340.24 206.748 339.248 205.276C338.256 203.772 337.76 202.044 337.76 200.092V196.012C337.76 194.284 338.224 192.7 339.152 191.26C340.112 189.788 341.376 188.62 342.944 187.756C344.544 186.86 346.32 186.412 348.272 186.412C350.064 186.412 351.696 186.796 353.168 187.564C354.672 188.332 355.888 189.388 356.816 190.732C357.744 192.076 358.208 193.644 358.208 195.436C358.208 196.812 357.984 197.804 357.536 198.412C357.088 198.988 356.512 199.356 355.808 199.516C355.136 199.644 354.432 199.708 353.696 199.708H343.952V200.428C343.952 201.804 344.464 202.924 345.488 203.788C346.544 204.62 347.904 205.036 349.568 205.036C350.624 205.036 351.504 204.876 352.208 204.556C352.912 204.236 353.52 203.932 354.032 203.644C354.544 203.356 355.024 203.212 355.472 203.212C355.952 203.212 356.368 203.372 356.72 203.692C357.072 204.012 357.344 204.396 357.536 204.844C357.728 205.26 357.824 205.628 357.824 205.948C357.824 206.492 357.472 207.084 356.768 207.724C356.096 208.332 355.12 208.86 353.84 209.308C352.592 209.724 351.104 209.932 349.376 209.932ZM343.952 196.06H350.96C351.504 196.06 351.872 195.98 352.064 195.82C352.288 195.628 352.4 195.276 352.4 194.764C352.4 194.028 352.192 193.372 351.776 192.796C351.392 192.22 350.88 191.772 350.24 191.452C349.632 191.132 348.944 190.972 348.176 190.972C347.44 190.972 346.752 191.132 346.112 191.452C345.472 191.74 344.944 192.172 344.528 192.748C344.144 193.292 343.952 193.948 343.952 194.716V196.06ZM365.425 209.5C364.529 209.5 363.793 209.292 363.217 208.876C362.641 208.46 362.353 207.996 362.353 207.484V175.324C362.353 174.748 362.641 174.284 363.217 173.932C363.793 173.58 364.529 173.404 365.425 173.404C366.289 173.404 367.025 173.58 367.633 173.932C368.241 174.284 368.545 174.748 368.545 175.324V207.484C368.545 207.996 368.241 208.46 367.633 208.876C367.025 209.292 366.289 209.5 365.425 209.5ZM376.852 181.612C375.924 181.612 375.124 181.308 374.452 180.7C373.78 180.06 373.444 179.356 373.444 178.588C373.444 177.756 373.78 177.052 374.452 176.476C375.124 175.868 375.924 175.564 376.852 175.564C377.812 175.564 378.612 175.868 379.252 176.476C379.892 177.052 380.212 177.756 380.212 178.588C380.212 179.356 379.892 180.06 379.252 180.7C378.612 181.308 377.812 181.612 376.852 181.612ZM376.852 209.5C375.956 209.5 375.22 209.292 374.644 208.876C374.068 208.46 373.78 207.996 373.78 207.484V188.62C373.78 188.044 374.068 187.58 374.644 187.228C375.22 186.876 375.956 186.7 376.852 186.7C377.716 186.7 378.452 186.876 379.06 187.228C379.668 187.58 379.972 188.044 379.972 188.62V207.484C379.972 207.996 379.668 208.46 379.06 208.876C378.452 209.292 377.716 209.5 376.852 209.5ZM393.678 220.108C391.79 220.108 390.03 219.836 388.398 219.292C386.798 218.78 385.502 218.012 384.51 216.988C383.55 215.964 383.07 214.748 383.07 213.34C383.07 212.124 383.406 211.084 384.078 210.22C384.75 209.388 385.582 208.732 386.574 208.252C385.966 207.964 385.47 207.58 385.086 207.1C384.734 206.588 384.558 205.948 384.558 205.18C384.558 204.284 384.782 203.564 385.23 203.02C385.71 202.444 386.302 201.916 387.006 201.436C386.046 200.7 385.294 199.82 384.75 198.796C384.238 197.74 383.982 196.588 383.982 195.34V194.332C383.982 192.764 384.366 191.388 385.134 190.204C385.934 189.02 387.038 188.092 388.446 187.42C389.886 186.748 391.534 186.412 393.39 186.412C394.446 186.412 395.438 186.54 396.366 186.796C397.294 187.02 398.126 187.356 398.862 187.804C399.406 186.524 399.918 185.66 400.398 185.212C400.878 184.764 401.342 184.54 401.79 184.54C402.558 184.54 403.15 184.764 403.566 185.212C404.014 185.66 404.238 186.076 404.238 186.46C404.238 186.748 404.158 187.004 403.998 187.228C403.87 187.452 403.694 187.644 403.47 187.804C403.15 187.996 402.782 188.236 402.366 188.524C401.95 188.78 401.566 189.148 401.214 189.628C401.79 190.268 402.206 190.988 402.462 191.788C402.75 192.556 402.894 193.404 402.894 194.332V195.34C402.894 196.876 402.494 198.252 401.694 199.468C400.894 200.652 399.774 201.596 398.334 202.3C396.894 203.004 395.246 203.356 393.39 203.356C392.238 203.356 391.198 203.212 390.27 202.924C390.11 203.052 389.966 203.196 389.838 203.356C389.742 203.516 389.694 203.692 389.694 203.884C389.694 204.428 390.046 204.812 390.75 205.036C391.454 205.26 392.35 205.436 393.438 205.564C394.526 205.692 395.678 205.868 396.894 206.092C398.142 206.284 399.31 206.604 400.398 207.052C401.486 207.5 402.382 208.172 403.086 209.068C403.79 209.932 404.142 211.1 404.142 212.572C404.142 214.364 403.63 215.804 402.606 216.892C401.614 218.012 400.318 218.828 398.718 219.34C397.15 219.852 395.47 220.108 393.678 220.108ZM393.582 216.124C394.83 216.124 395.886 215.82 396.75 215.212C397.646 214.604 398.094 213.788 398.094 212.764C398.094 212.092 397.902 211.548 397.518 211.132C397.134 210.716 396.606 210.396 395.934 210.172C395.294 209.98 394.59 209.82 393.822 209.692C393.054 209.596 392.286 209.5 391.518 209.404C390.75 209.756 390.126 210.204 389.646 210.748C389.166 211.292 388.926 211.948 388.926 212.716C388.926 213.772 389.374 214.604 390.27 215.212C391.198 215.82 392.302 216.124 393.582 216.124ZM393.486 199.612C394.542 199.612 395.374 199.212 395.982 198.412C396.59 197.612 396.894 196.588 396.894 195.34V194.332C396.894 193.148 396.59 192.156 395.982 191.356C395.406 190.556 394.558 190.156 393.438 190.156C392.35 190.156 391.502 190.556 390.894 191.356C390.318 192.156 390.03 193.148 390.03 194.332V195.292C390.03 196.508 390.318 197.532 390.894 198.364C391.502 199.196 392.366 199.612 393.486 199.612ZM410.368 181.612C409.44 181.612 408.64 181.308 407.968 180.7C407.296 180.06 406.96 179.356 406.96 178.588C406.96 177.756 407.296 177.052 407.968 176.476C408.64 175.868 409.44 175.564 410.368 175.564C411.328 175.564 412.128 175.868 412.768 176.476C413.408 177.052 413.728 177.756 413.728 178.588C413.728 179.356 413.408 180.06 412.768 180.7C412.128 181.308 411.328 181.612 410.368 181.612ZM410.368 209.5C409.472 209.5 408.736 209.292 408.16 208.876C407.584 208.46 407.296 207.996 407.296 207.484V188.62C407.296 188.044 407.584 187.58 408.16 187.228C408.736 186.876 409.472 186.7 410.368 186.7C411.232 186.7 411.968 186.876 412.576 187.228C413.184 187.58 413.488 188.044 413.488 188.62V207.484C413.488 207.996 413.184 208.46 412.576 208.876C411.968 209.292 411.232 209.5 410.368 209.5ZM427.722 209.932C425.866 209.932 424.154 209.484 422.586 208.588C421.018 207.66 419.754 206.444 418.794 204.94C417.834 203.436 417.354 201.82 417.354 200.092V196.156C417.354 194.428 417.818 192.828 418.746 191.356C419.674 189.852 420.922 188.652 422.49 187.756C424.09 186.86 425.834 186.412 427.722 186.412C429.61 186.412 431.338 186.86 432.906 187.756C434.506 188.62 435.77 189.788 436.698 191.26C437.658 192.732 438.138 194.364 438.138 196.156V200.092C438.138 201.788 437.658 203.388 436.698 204.892C435.738 206.396 434.458 207.612 432.858 208.54C431.29 209.468 429.578 209.932 427.722 209.932ZM427.722 204.508C428.49 204.508 429.194 204.3 429.834 203.884C430.474 203.468 430.986 202.924 431.37 202.252C431.754 201.548 431.946 200.828 431.946 200.092V196.156C431.946 195.42 431.754 194.732 431.37 194.092C430.986 193.452 430.474 192.924 429.834 192.508C429.226 192.06 428.522 191.836 427.722 191.836C426.954 191.836 426.25 192.044 425.61 192.46C424.97 192.876 424.458 193.42 424.074 194.092C423.722 194.732 423.546 195.42 423.546 196.156V200.092C423.546 200.828 423.722 201.548 424.074 202.252C424.458 202.924 424.97 203.468 425.61 203.884C426.25 204.3 426.954 204.508 427.722 204.508ZM445.149 209.5C444.253 209.5 443.517 209.292 442.941 208.876C442.365 208.46 442.077 207.996 442.077 207.484V188.62C442.077 188.044 442.365 187.58 442.941 187.228C443.517 186.876 444.253 186.7 445.149 186.7C445.917 186.7 446.557 186.876 447.069 187.228C447.613 187.58 447.885 188.044 447.885 188.62V190.06C448.365 189.132 449.149 188.3 450.237 187.564C451.357 186.796 452.717 186.412 454.317 186.412C455.821 186.412 457.197 186.86 458.445 187.756C459.693 188.62 460.685 189.788 461.421 191.26C462.189 192.732 462.573 194.364 462.573 196.156V207.484C462.573 208.156 462.253 208.668 461.613 209.02C460.973 209.34 460.253 209.5 459.453 209.5C458.749 209.5 458.061 209.34 457.389 209.02C456.717 208.668 456.381 208.156 456.381 207.484V196.156C456.381 195.42 456.189 194.732 455.805 194.092C455.453 193.452 454.957 192.924 454.317 192.508C453.677 192.06 452.973 191.836 452.205 191.836C451.565 191.836 450.941 192.012 450.333 192.364C449.725 192.716 449.229 193.212 448.845 193.852C448.461 194.492 448.269 195.26 448.269 196.156V207.484C448.269 207.996 447.965 208.46 447.357 208.876C446.749 209.292 446.013 209.5 445.149 209.5ZM474.642 209.932C473.042 209.932 471.57 209.74 470.226 209.356C468.914 208.94 467.874 208.412 467.106 207.772C466.37 207.132 466.002 206.476 466.002 205.804C466.002 205.452 466.082 205.068 466.242 204.652C466.434 204.236 466.674 203.868 466.962 203.548C467.282 203.228 467.65 203.068 468.066 203.068C468.514 203.068 468.978 203.26 469.458 203.644C469.97 203.996 470.594 204.348 471.33 204.7C472.098 205.052 473.154 205.228 474.498 205.228C475.938 205.228 476.882 205.004 477.33 204.556C477.81 204.108 478.05 203.644 478.05 203.164C478.05 202.46 477.762 201.916 477.186 201.532C476.642 201.148 475.938 200.844 475.074 200.62C474.21 200.364 473.282 200.092 472.29 199.804C471.33 199.516 470.418 199.148 469.554 198.7C468.69 198.22 467.986 197.58 467.442 196.78C466.898 195.948 466.626 194.876 466.626 193.564C466.626 192.412 466.898 191.292 467.442 190.204C467.986 189.116 468.882 188.22 470.13 187.516C471.378 186.78 473.074 186.412 475.218 186.412C476.53 186.412 477.762 186.556 478.914 186.844C480.098 187.1 481.058 187.468 481.794 187.948C482.53 188.428 482.898 188.956 482.898 189.532C482.898 189.82 482.802 190.204 482.61 190.684C482.418 191.132 482.146 191.548 481.794 191.932C481.474 192.316 481.074 192.508 480.594 192.508C480.242 192.508 479.81 192.396 479.298 192.172C478.818 191.916 478.258 191.676 477.618 191.452C476.978 191.228 476.21 191.116 475.314 191.116C474.514 191.116 473.874 191.228 473.394 191.452C472.914 191.676 472.562 191.948 472.338 192.268C472.114 192.588 472.002 192.924 472.002 193.276C472.002 193.852 472.274 194.3 472.818 194.62C473.362 194.94 474.066 195.212 474.93 195.436C475.826 195.66 476.754 195.916 477.714 196.204C478.706 196.46 479.634 196.844 480.498 197.356C481.394 197.868 482.114 198.572 482.658 199.468C483.202 200.332 483.474 201.468 483.474 202.876C483.474 205.02 482.706 206.732 481.17 208.012C479.666 209.292 477.49 209.932 474.642 209.932ZM506.331 209.5C505.467 209.5 504.747 209.324 504.171 208.972C503.595 208.588 503.307 208.108 503.307 207.532V182.812C503.307 181.02 503.691 179.42 504.459 178.012C505.227 176.572 506.251 175.452 507.531 174.652C508.811 173.82 510.219 173.404 511.755 173.404H514.587C515.355 173.404 515.931 173.676 516.315 174.22C516.731 174.764 516.939 175.356 516.939 175.996C516.939 176.7 516.731 177.324 516.315 177.868C515.931 178.38 515.355 178.636 514.587 178.636H513.051C512.379 178.636 511.771 178.78 511.227 179.068C510.683 179.356 510.251 179.756 509.931 180.268C509.643 180.78 509.499 181.404 509.499 182.14V186.7H515.355C515.867 186.7 516.251 186.94 516.507 187.42C516.795 187.868 516.939 188.38 516.939 188.956C516.939 189.532 516.795 190.06 516.507 190.54C516.251 190.988 515.867 191.212 515.355 191.212H509.499V207.532C509.499 208.108 509.179 208.588 508.539 208.972C507.931 209.324 507.195 209.5 506.331 209.5ZM528.513 209.932C526.657 209.932 524.945 209.484 523.377 208.588C521.809 207.66 520.545 206.444 519.585 204.94C518.625 203.436 518.145 201.82 518.145 200.092V196.156C518.145 194.428 518.609 192.828 519.537 191.356C520.465 189.852 521.713 188.652 523.281 187.756C524.881 186.86 526.625 186.412 528.513 186.412C530.401 186.412 532.129 186.86 533.697 187.756C535.297 188.62 536.561 189.788 537.489 191.26C538.449 192.732 538.929 194.364 538.929 196.156V200.092C538.929 201.788 538.449 203.388 537.489 204.892C536.529 206.396 535.249 207.612 533.649 208.54C532.081 209.468 530.369 209.932 528.513 209.932ZM528.513 204.508C529.281 204.508 529.985 204.3 530.625 203.884C531.265 203.468 531.777 202.924 532.161 202.252C532.545 201.548 532.737 200.828 532.737 200.092V196.156C532.737 195.42 532.545 194.732 532.161 194.092C531.777 193.452 531.265 192.924 530.625 192.508C530.017 192.06 529.313 191.836 528.513 191.836C527.745 191.836 527.041 192.044 526.401 192.46C525.761 192.876 525.249 193.42 524.865 194.092C524.513 194.732 524.337 195.42 524.337 196.156V200.092C524.337 200.828 524.513 201.548 524.865 202.252C525.249 202.924 525.761 203.468 526.401 203.884C527.041 204.3 527.745 204.508 528.513 204.508ZM550.309 209.932C548.709 209.932 547.237 209.74 545.893 209.356C544.581 208.94 543.541 208.412 542.773 207.772C542.037 207.132 541.669 206.476 541.669 205.804C541.669 205.452 541.749 205.068 541.909 204.652C542.101 204.236 542.341 203.868 542.629 203.548C542.949 203.228 543.317 203.068 543.733 203.068C544.181 203.068 544.645 203.26 545.125 203.644C545.637 203.996 546.261 204.348 546.997 204.7C547.765 205.052 548.821 205.228 550.165 205.228C551.605 205.228 552.549 205.004 552.997 204.556C553.477 204.108 553.717 203.644 553.717 203.164C553.717 202.46 553.429 201.916 552.853 201.532C552.309 201.148 551.605 200.844 550.741 200.62C549.877 200.364 548.949 200.092 547.957 199.804C546.997 199.516 546.085 199.148 545.221 198.7C544.357 198.22 543.653 197.58 543.109 196.78C542.565 195.948 542.293 194.876 542.293 193.564C542.293 192.412 542.565 191.292 543.109 190.204C543.653 189.116 544.549 188.22 545.797 187.516C547.045 186.78 548.741 186.412 550.885 186.412C552.197 186.412 553.429 186.556 554.581 186.844C555.765 187.1 556.725 187.468 557.461 187.948C558.197 188.428 558.565 188.956 558.565 189.532C558.565 189.82 558.469 190.204 558.277 190.684C558.085 191.132 557.813 191.548 557.461 191.932C557.141 192.316 556.741 192.508 556.261 192.508C555.909 192.508 555.477 192.396 554.965 192.172C554.485 191.916 553.925 191.676 553.285 191.452C552.645 191.228 551.877 191.116 550.981 191.116C550.181 191.116 549.541 191.228 549.061 191.452C548.581 191.676 548.229 191.948 548.005 192.268C547.781 192.588 547.669 192.924 547.669 193.276C547.669 193.852 547.941 194.3 548.485 194.62C549.029 194.94 549.733 195.212 550.597 195.436C551.493 195.66 552.421 195.916 553.381 196.204C554.373 196.46 555.301 196.844 556.165 197.356C557.061 197.868 557.781 198.572 558.325 199.468C558.869 200.332 559.141 201.468 559.141 202.876C559.141 205.02 558.373 206.732 556.837 208.012C555.333 209.292 553.157 209.932 550.309 209.932ZM571.668 209.5C568.788 209.5 566.58 208.876 565.044 207.628C563.54 206.38 562.788 204.396 562.788 201.676V178.444C562.788 177.868 563.124 177.404 563.796 177.052C564.468 176.7 565.156 176.524 565.86 176.524C566.628 176.524 567.332 176.7 567.972 177.052C568.644 177.404 568.98 177.868 568.98 178.444V186.7H574.644C575.156 186.7 575.54 186.94 575.796 187.42C576.084 187.868 576.228 188.38 576.228 188.956C576.228 189.532 576.084 190.06 575.796 190.54C575.54 190.988 575.156 191.212 574.644 191.212H568.98V201.676C568.98 202.636 569.172 203.308 569.556 203.692C569.972 204.076 570.676 204.268 571.668 204.268H573.54C574.436 204.268 575.092 204.54 575.508 205.084C575.956 205.628 576.18 206.22 576.18 206.86C576.18 207.532 575.956 208.14 575.508 208.684C575.092 209.228 574.436 209.5 573.54 209.5H571.668ZM589.855 209.932C587.583 209.932 585.567 209.532 583.807 208.732C582.079 207.9 580.719 206.748 579.727 205.276C578.735 203.772 578.239 202.044 578.239 200.092V196.012C578.239 194.284 578.703 192.7 579.631 191.26C580.591 189.788 581.855 188.62 583.423 187.756C585.023 186.86 586.799 186.412 588.751 186.412C590.543 186.412 592.175 186.796 593.647 187.564C595.151 188.332 596.367 189.388 597.295 190.732C598.223 192.076 598.687 193.644 598.687 195.436C598.687 196.812 598.463 197.804 598.015 198.412C597.567 198.988 596.991 199.356 596.287 199.516C595.615 199.644 594.911 199.708 594.175 199.708H584.431V200.428C584.431 201.804 584.943 202.924 585.967 203.788C587.023 204.62 588.383 205.036 590.047 205.036C591.103 205.036 591.983 204.876 592.687 204.556C593.391 204.236 593.999 203.932 594.511 203.644C595.023 203.356 595.503 203.212 595.951 203.212C596.431 203.212 596.847 203.372 597.199 203.692C597.551 204.012 597.823 204.396 598.015 204.844C598.207 205.26 598.303 205.628 598.303 205.948C598.303 206.492 597.951 207.084 597.247 207.724C596.575 208.332 595.599 208.86 594.319 209.308C593.071 209.724 591.583 209.932 589.855 209.932ZM584.431 196.06H591.439C591.983 196.06 592.351 195.98 592.543 195.82C592.767 195.628 592.879 195.276 592.879 194.764C592.879 194.028 592.671 193.372 592.255 192.796C591.871 192.22 591.359 191.772 590.719 191.452C590.111 191.132 589.423 190.972 588.655 190.972C587.919 190.972 587.231 191.132 586.591 191.452C585.951 191.74 585.423 192.172 585.007 192.748C584.623 193.292 584.431 193.948 584.431 194.716V196.06ZM605.424 209.5C604.56 209.5 603.84 209.292 603.264 208.876C602.688 208.46 602.4 207.996 602.4 207.484V188.62C602.4 188.044 602.688 187.58 603.264 187.228C603.84 186.876 604.56 186.7 605.424 186.7C606.224 186.7 606.88 186.876 607.392 187.228C607.936 187.58 608.208 188.044 608.208 188.62V190.588C608.56 189.884 609.024 189.228 609.6 188.62C610.208 187.98 610.896 187.452 611.664 187.036C612.432 186.62 613.248 186.412 614.112 186.412H615.6C616.208 186.412 616.736 186.684 617.184 187.228C617.632 187.74 617.856 188.364 617.856 189.1C617.856 189.868 617.632 190.524 617.184 191.068C616.736 191.58 616.208 191.836 615.6 191.836H614.112C613.216 191.836 612.336 192.14 611.472 192.748C610.64 193.324 609.952 194.14 609.408 195.196C608.864 196.22 608.592 197.468 608.592 198.94V207.484C608.592 207.996 608.288 208.46 607.68 208.876C607.072 209.292 606.32 209.5 605.424 209.5ZM78.472 251.612C77.544 251.612 76.744 251.308 76.072 250.7C75.4 250.06 75.064 249.356 75.064 248.588C75.064 247.756 75.4 247.052 76.072 246.476C76.744 245.868 77.544 245.564 78.472 245.564C79.432 245.564 80.232 245.868 80.872 246.476C81.512 247.052 81.832 247.756 81.832 248.588C81.832 249.356 81.512 250.06 80.872 250.7C80.232 251.308 79.432 251.612 78.472 251.612ZM78.472 279.5C77.576 279.5 76.84 279.292 76.264 278.876C75.688 278.46 75.4 277.996 75.4 277.484V258.62C75.4 258.044 75.688 257.58 76.264 257.228C76.84 256.876 77.576 256.7 78.472 256.7C79.336 256.7 80.072 256.876 80.68 257.228C81.288 257.58 81.592 258.044 81.592 258.62V277.484C81.592 277.996 81.288 278.46 80.68 278.876C80.072 279.292 79.336 279.5 78.472 279.5ZM89.3939 279.5C88.4979 279.5 87.7619 279.292 87.1859 278.876C86.6099 278.46 86.3219 277.996 86.3219 277.484V258.62C86.3219 258.044 86.6099 257.58 87.1859 257.228C87.7619 256.876 88.4979 256.7 89.3939 256.7C90.1619 256.7 90.8019 256.876 91.3139 257.228C91.8579 257.58 92.1299 258.044 92.1299 258.62V260.06C92.6099 259.132 93.3939 258.3 94.4819 257.564C95.6019 256.796 96.9619 256.412 98.5619 256.412C100.066 256.412 101.442 256.86 102.69 257.756C103.938 258.62 104.93 259.788 105.666 261.26C106.434 262.732 106.818 264.364 106.818 266.156V277.484C106.818 278.156 106.498 278.668 105.858 279.02C105.218 279.34 104.498 279.5 103.698 279.5C102.994 279.5 102.306 279.34 101.634 279.02C100.962 278.668 100.626 278.156 100.626 277.484V266.156C100.626 265.42 100.434 264.732 100.05 264.092C99.6979 263.452 99.2019 262.924 98.5619 262.508C97.9219 262.06 97.2179 261.836 96.4499 261.836C95.8099 261.836 95.1859 262.012 94.5779 262.364C93.9699 262.716 93.4739 263.212 93.0899 263.852C92.7059 264.492 92.5139 265.26 92.5139 266.156V277.484C92.5139 277.996 92.2099 278.46 91.6019 278.876C90.9939 279.292 90.2579 279.5 89.3939 279.5ZM120.231 279.5C117.351 279.5 115.143 278.876 113.607 277.628C112.103 276.38 111.351 274.396 111.351 271.676V248.444C111.351 247.868 111.687 247.404 112.359 247.052C113.031 246.7 113.719 246.524 114.423 246.524C115.191 246.524 115.895 246.7 116.535 247.052C117.207 247.404 117.543 247.868 117.543 248.444V256.7H123.207C123.719 256.7 124.103 256.94 124.359 257.42C124.647 257.868 124.791 258.38 124.791 258.956C124.791 259.532 124.647 260.06 124.359 260.54C124.103 260.988 123.719 261.212 123.207 261.212H117.543V271.676C117.543 272.636 117.735 273.308 118.119 273.692C118.535 274.076 119.239 274.268 120.231 274.268H122.103C122.999 274.268 123.655 274.54 124.071 275.084C124.519 275.628 124.743 276.22 124.743 276.86C124.743 277.532 124.519 278.14 124.071 278.684C123.655 279.228 122.999 279.5 122.103 279.5H120.231ZM138.418 279.932C136.146 279.932 134.13 279.532 132.37 278.732C130.642 277.9 129.282 276.748 128.29 275.276C127.298 273.772 126.802 272.044 126.802 270.092V266.012C126.802 264.284 127.266 262.7 128.194 261.26C129.154 259.788 130.418 258.62 131.986 257.756C133.586 256.86 135.362 256.412 137.314 256.412C139.106 256.412 140.738 256.796 142.21 257.564C143.714 258.332 144.93 259.388 145.858 260.732C146.786 262.076 147.25 263.644 147.25 265.436C147.25 266.812 147.026 267.804 146.578 268.412C146.13 268.988 145.554 269.356 144.85 269.516C144.178 269.644 143.474 269.708 142.738 269.708H132.994V270.428C132.994 271.804 133.506 272.924 134.53 273.788C135.586 274.62 136.946 275.036 138.61 275.036C139.666 275.036 140.546 274.876 141.25 274.556C141.954 274.236 142.562 273.932 143.074 273.644C143.586 273.356 144.066 273.212 144.514 273.212C144.994 273.212 145.41 273.372 145.762 273.692C146.114 274.012 146.386 274.396 146.578 274.844C146.77 275.26 146.866 275.628 146.866 275.948C146.866 276.492 146.514 277.084 145.81 277.724C145.138 278.332 144.162 278.86 142.882 279.308C141.634 279.724 140.146 279.932 138.418 279.932ZM132.994 266.06H140.002C140.546 266.06 140.914 265.98 141.106 265.82C141.33 265.628 141.442 265.276 141.442 264.764C141.442 264.028 141.234 263.372 140.818 262.796C140.434 262.22 139.922 261.772 139.282 261.452C138.674 261.132 137.986 260.972 137.218 260.972C136.482 260.972 135.794 261.132 135.154 261.452C134.514 261.74 133.986 262.172 133.57 262.748C133.186 263.292 132.994 263.948 132.994 264.716V266.06ZM153.987 279.5C153.123 279.5 152.403 279.292 151.827 278.876C151.251 278.46 150.963 277.996 150.963 277.484V258.62C150.963 258.044 151.251 257.58 151.827 257.228C152.403 256.876 153.123 256.7 153.987 256.7C154.787 256.7 155.443 256.876 155.955 257.228C156.499 257.58 156.771 258.044 156.771 258.62V260.588C157.123 259.884 157.587 259.228 158.163 258.62C158.771 257.98 159.459 257.452 160.227 257.036C160.995 256.62 161.811 256.412 162.674 256.412H164.163C164.771 256.412 165.299 256.684 165.747 257.228C166.195 257.74 166.419 258.364 166.419 259.1C166.419 259.868 166.195 260.524 165.747 261.068C165.299 261.58 164.771 261.836 164.163 261.836H162.674C161.779 261.836 160.899 262.14 160.035 262.748C159.203 263.324 158.515 264.14 157.971 265.196C157.427 266.22 157.155 267.468 157.155 268.94V277.484C157.155 277.996 156.851 278.46 156.243 278.876C155.635 279.292 154.883 279.5 153.987 279.5ZM168.195 270.524C167.619 270.524 167.139 270.284 166.755 269.804C166.403 269.324 166.227 268.716 166.227 267.98C166.227 267.244 166.403 266.636 166.755 266.156C167.139 265.644 167.619 265.388 168.195 265.388H180.675C181.155 265.388 181.603 265.644 182.019 266.156C182.435 266.636 182.643 267.244 182.643 267.98C182.643 268.716 182.435 269.324 182.019 269.804C181.603 270.284 181.155 270.524 180.675 270.524H168.195ZM189.705 279.5C188.841 279.5 188.121 279.292 187.545 278.876C186.969 278.46 186.681 277.996 186.681 277.484V258.62C186.681 258.044 186.969 257.58 187.545 257.228C188.121 256.876 188.841 256.7 189.705 256.7C190.505 256.7 191.161 256.876 191.673 257.228C192.217 257.58 192.489 258.044 192.489 258.62V260.588C192.841 259.884 193.305 259.228 193.881 258.62C194.489 257.98 195.177 257.452 195.945 257.036C196.713 256.62 197.529 256.412 198.393 256.412H199.881C200.489 256.412 201.017 256.684 201.465 257.228C201.913 257.74 202.137 258.364 202.137 259.1C202.137 259.868 201.913 260.524 201.465 261.068C201.017 261.58 200.489 261.836 199.881 261.836H198.393C197.497 261.836 196.617 262.14 195.753 262.748C194.921 263.324 194.233 264.14 193.689 265.196C193.145 266.22 192.873 267.468 192.873 268.94V277.484C192.873 277.996 192.569 278.46 191.961 278.876C191.353 279.292 190.601 279.5 189.705 279.5ZM214.871 279.932C212.599 279.932 210.583 279.532 208.823 278.732C207.095 277.9 205.735 276.748 204.743 275.276C203.751 273.772 203.255 272.044 203.255 270.092V266.012C203.255 264.284 203.719 262.7 204.647 261.26C205.607 259.788 206.871 258.62 208.439 257.756C210.039 256.86 211.815 256.412 213.767 256.412C215.559 256.412 217.191 256.796 218.663 257.564C220.167 258.332 221.383 259.388 222.311 260.732C223.239 262.076 223.703 263.644 223.703 265.436C223.703 266.812 223.479 267.804 223.031 268.412C222.583 268.988 222.007 269.356 221.303 269.516C220.631 269.644 219.927 269.708 219.191 269.708H209.447V270.428C209.447 271.804 209.959 272.924 210.983 273.788C212.039 274.62 213.399 275.036 215.063 275.036C216.119 275.036 216.999 274.876 217.703 274.556C218.407 274.236 219.015 273.932 219.527 273.644C220.039 273.356 220.519 273.212 220.967 273.212C221.447 273.212 221.863 273.372 222.215 273.692C222.567 274.012 222.839 274.396 223.031 274.844C223.223 275.26 223.319 275.628 223.319 275.948C223.319 276.492 222.967 277.084 222.263 277.724C221.591 278.332 220.615 278.86 219.335 279.308C218.087 279.724 216.599 279.932 214.871 279.932ZM209.447 266.06H216.455C216.999 266.06 217.367 265.98 217.559 265.82C217.783 265.628 217.895 265.276 217.895 264.764C217.895 264.028 217.687 263.372 217.271 262.796C216.887 262.22 216.375 261.772 215.735 261.452C215.127 261.132 214.439 260.972 213.671 260.972C212.935 260.972 212.247 261.132 211.607 261.452C210.967 261.74 210.439 262.172 210.023 262.748C209.639 263.292 209.447 263.948 209.447 264.716V266.06ZM230.92 279.5C230.024 279.5 229.288 279.292 228.712 278.876C228.136 278.46 227.848 277.996 227.848 277.484V245.324C227.848 244.748 228.136 244.284 228.712 243.932C229.288 243.58 230.024 243.404 230.92 243.404C231.784 243.404 232.52 243.58 233.128 243.932C233.736 244.284 234.04 244.748 234.04 245.324V277.484C234.04 277.996 233.736 278.46 233.128 278.876C232.52 279.292 231.784 279.5 230.92 279.5ZM242.347 251.612C241.419 251.612 240.619 251.308 239.947 250.7C239.275 250.06 238.939 249.356 238.939 248.588C238.939 247.756 239.275 247.052 239.947 246.476C240.619 245.868 241.419 245.564 242.347 245.564C243.307 245.564 244.107 245.868 244.747 246.476C245.387 247.052 245.707 247.756 245.707 248.588C245.707 249.356 245.387 250.06 244.747 250.7C244.107 251.308 243.307 251.612 242.347 251.612ZM242.347 279.5C241.451 279.5 240.715 279.292 240.139 278.876C239.563 278.46 239.275 277.996 239.275 277.484V258.62C239.275 258.044 239.563 257.58 240.139 257.228C240.715 256.876 241.451 256.7 242.347 256.7C243.211 256.7 243.947 256.876 244.555 257.228C245.163 257.58 245.467 258.044 245.467 258.62V277.484C245.467 277.996 245.163 278.46 244.555 278.876C243.947 279.292 243.211 279.5 242.347 279.5ZM259.173 290.108C257.285 290.108 255.525 289.836 253.893 289.292C252.293 288.78 250.997 288.012 250.005 286.988C249.045 285.964 248.565 284.748 248.565 283.34C248.565 282.124 248.901 281.084 249.573 280.22C250.245 279.388 251.077 278.732 252.069 278.252C251.461 277.964 250.965 277.58 250.581 277.1C250.229 276.588 250.053 275.948 250.053 275.18C250.053 274.284 250.277 273.564 250.725 273.02C251.205 272.444 251.797 271.916 252.501 271.436C251.541 270.7 250.789 269.82 250.245 268.796C249.733 267.74 249.477 266.588 249.477 265.34V264.332C249.477 262.764 249.861 261.388 250.629 260.204C251.429 259.02 252.533 258.092 253.941 257.42C255.381 256.748 257.029 256.412 258.885 256.412C259.941 256.412 260.933 256.54 261.861 256.796C262.789 257.02 263.621 257.356 264.357 257.804C264.901 256.524 265.413 255.66 265.893 255.212C266.373 254.764 266.837 254.54 267.285 254.54C268.053 254.54 268.645 254.764 269.061 255.212C269.509 255.66 269.733 256.076 269.733 256.46C269.733 256.748 269.653 257.004 269.493 257.228C269.365 257.452 269.189 257.644 268.965 257.804C268.645 257.996 268.277 258.236 267.861 258.524C267.445 258.78 267.061 259.148 266.709 259.628C267.285 260.268 267.701 260.988 267.957 261.788C268.245 262.556 268.389 263.404 268.389 264.332V265.34C268.389 266.876 267.989 268.252 267.189 269.468C266.389 270.652 265.269 271.596 263.829 272.3C262.389 273.004 260.741 273.356 258.885 273.356C257.733 273.356 256.693 273.212 255.765 272.924C255.605 273.052 255.461 273.196 255.333 273.356C255.237 273.516 255.189 273.692 255.189 273.884C255.189 274.428 255.541 274.812 256.245 275.036C256.949 275.26 257.845 275.436 258.933 275.564C260.021 275.692 261.173 275.868 262.389 276.092C263.637 276.284 264.805 276.604 265.893 277.052C266.981 277.5 267.877 278.172 268.581 279.068C269.285 279.932 269.637 281.1 269.637 282.572C269.637 284.364 269.125 285.804 268.101 286.892C267.109 288.012 265.813 288.828 264.213 289.34C262.645 289.852 260.965 290.108 259.173 290.108ZM259.077 286.124C260.325 286.124 261.381 285.82 262.245 285.212C263.141 284.604 263.589 283.788 263.589 282.764C263.589 282.092 263.397 281.548 263.013 281.132C262.629 280.716 262.101 280.396 261.429 280.172C260.789 279.98 260.085 279.82 259.317 279.692C258.549 279.596 257.781 279.5 257.013 279.404C256.245 279.756 255.621 280.204 255.141 280.748C254.661 281.292 254.421 281.948 254.421 282.716C254.421 283.772 254.869 284.604 255.765 285.212C256.693 285.82 257.797 286.124 259.077 286.124ZM258.981 269.612C260.037 269.612 260.869 269.212 261.477 268.412C262.085 267.612 262.389 266.588 262.389 265.34V264.332C262.389 263.148 262.085 262.156 261.477 261.356C260.901 260.556 260.053 260.156 258.933 260.156C257.845 260.156 256.997 260.556 256.389 261.356C255.813 262.156 255.525 263.148 255.525 264.332V265.292C255.525 266.508 255.813 267.532 256.389 268.364C256.997 269.196 257.861 269.612 258.981 269.612ZM275.863 251.612C274.935 251.612 274.135 251.308 273.463 250.7C272.791 250.06 272.455 249.356 272.455 248.588C272.455 247.756 272.791 247.052 273.463 246.476C274.135 245.868 274.935 245.564 275.863 245.564C276.823 245.564 277.623 245.868 278.263 246.476C278.903 247.052 279.223 247.756 279.223 248.588C279.223 249.356 278.903 250.06 278.263 250.7C277.623 251.308 276.823 251.612 275.863 251.612ZM275.863 279.5C274.967 279.5 274.231 279.292 273.655 278.876C273.079 278.46 272.791 277.996 272.791 277.484V258.62C272.791 258.044 273.079 257.58 273.655 257.228C274.231 256.876 274.967 256.7 275.863 256.7C276.727 256.7 277.463 256.876 278.071 257.228C278.679 257.58 278.983 258.044 278.983 258.62V277.484C278.983 277.996 278.679 278.46 278.071 278.876C277.463 279.292 276.727 279.5 275.863 279.5ZM293.217 279.932C291.361 279.932 289.649 279.484 288.081 278.588C286.513 277.66 285.249 276.444 284.289 274.94C283.329 273.436 282.849 271.82 282.849 270.092V266.156C282.849 264.428 283.313 262.828 284.241 261.356C285.169 259.852 286.417 258.652 287.985 257.756C289.585 256.86 291.329 256.412 293.217 256.412C295.105 256.412 296.833 256.86 298.401 257.756C300.001 258.62 301.265 259.788 302.193 261.26C303.153 262.732 303.633 264.364 303.633 266.156V270.092C303.633 271.788 303.153 273.388 302.193 274.892C301.233 276.396 299.953 277.612 298.353 278.54C296.785 279.468 295.073 279.932 293.217 279.932ZM293.217 274.508C293.985 274.508 294.689 274.3 295.329 273.884C295.969 273.468 296.481 272.924 296.865 272.252C297.249 271.548 297.441 270.828 297.441 270.092V266.156C297.441 265.42 297.249 264.732 296.865 264.092C296.481 263.452 295.969 262.924 295.329 262.508C294.721 262.06 294.017 261.836 293.217 261.836C292.449 261.836 291.745 262.044 291.105 262.46C290.465 262.876 289.953 263.42 289.569 264.092C289.217 264.732 289.041 265.42 289.041 266.156V270.092C289.041 270.828 289.217 271.548 289.569 272.252C289.953 272.924 290.465 273.468 291.105 273.884C291.745 274.3 292.449 274.508 293.217 274.508ZM317.796 279.932C315.876 279.932 314.116 279.484 312.516 278.588C310.948 277.66 309.684 276.46 308.724 274.988C307.796 273.484 307.332 271.884 307.332 270.188V258.668C307.332 258.188 307.636 257.74 308.244 257.324C308.884 256.908 309.62 256.7 310.452 256.7C311.284 256.7 312.004 256.908 312.612 257.324C313.22 257.74 313.524 258.188 313.524 258.668V270.188C313.524 270.924 313.716 271.612 314.1 272.252C314.484 272.892 314.996 273.436 315.636 273.884C316.276 274.3 316.98 274.508 317.748 274.508C318.548 274.508 319.252 274.3 319.86 273.884C320.5 273.468 321.012 272.924 321.396 272.252C321.78 271.58 321.972 270.892 321.972 270.188V258.62C321.972 258.108 322.276 257.66 322.884 257.276C323.524 256.892 324.244 256.7 325.044 256.7C325.972 256.7 326.724 256.892 327.3 257.276C327.876 257.66 328.164 258.108 328.164 258.62V270.188C328.164 271.916 327.684 273.532 326.724 275.036C325.796 276.508 324.532 277.692 322.932 278.588C321.364 279.484 319.652 279.932 317.796 279.932ZM340.184 279.932C338.584 279.932 337.112 279.74 335.768 279.356C334.456 278.94 333.416 278.412 332.648 277.772C331.912 277.132 331.544 276.476 331.544 275.804C331.544 275.452 331.624 275.068 331.784 274.652C331.976 274.236 332.216 273.868 332.504 273.548C332.824 273.228 333.192 273.068 333.608 273.068C334.056 273.068 334.52 273.26 335 273.644C335.512 273.996 336.136 274.348 336.872 274.7C337.64 275.052 338.696 275.228 340.04 275.228C341.48 275.228 342.424 275.004 342.872 274.556C343.352 274.108 343.592 273.644 343.592 273.164C343.592 272.46 343.304 271.916 342.728 271.532C342.184 271.148 341.48 270.844 340.616 270.62C339.752 270.364 338.824 270.092 337.832 269.804C336.872 269.516 335.96 269.148 335.096 268.7C334.232 268.22 333.528 267.58 332.984 266.78C332.44 265.948 332.168 264.876 332.168 263.564C332.168 262.412 332.44 261.292 332.984 260.204C333.528 259.116 334.424 258.22 335.672 257.516C336.92 256.78 338.616 256.412 340.76 256.412C342.072 256.412 343.304 256.556 344.456 256.844C345.64 257.1 346.6 257.468 347.336 257.948C348.072 258.428 348.44 258.956 348.44 259.532C348.44 259.82 348.344 260.204 348.152 260.684C347.96 261.132 347.688 261.548 347.336 261.932C347.016 262.316 346.616 262.508 346.136 262.508C345.784 262.508 345.352 262.396 344.84 262.172C344.36 261.916 343.8 261.676 343.16 261.452C342.52 261.228 341.752 261.116 340.856 261.116C340.056 261.116 339.416 261.228 338.936 261.452C338.456 261.676 338.104 261.948 337.88 262.268C337.656 262.588 337.544 262.924 337.544 263.276C337.544 263.852 337.816 264.3 338.36 264.62C338.904 264.94 339.608 265.212 340.472 265.436C341.368 265.66 342.296 265.916 343.256 266.204C344.248 266.46 345.176 266.844 346.04 267.356C346.936 267.868 347.656 268.572 348.2 269.468C348.744 270.332 349.016 271.468 349.016 272.876C349.016 275.02 348.248 276.732 346.712 278.012C345.208 279.292 343.032 279.932 340.184 279.932ZM378.09 279.5C377.194 279.5 376.458 279.292 375.882 278.876C375.306 278.46 375.018 277.996 375.018 277.484V245.324C375.018 244.748 375.306 244.284 375.882 243.932C376.458 243.58 377.194 243.404 378.09 243.404C378.954 243.404 379.69 243.58 380.298 243.932C380.906 244.284 381.21 244.748 381.21 245.324V260.06C381.69 259.132 382.442 258.3 383.466 257.564C384.49 256.796 385.754 256.412 387.258 256.412C388.762 256.412 390.138 256.86 391.386 257.756C392.634 258.62 393.626 259.788 394.362 261.26C395.13 262.732 395.514 264.364 395.514 266.156V277.484C395.514 278.156 395.194 278.668 394.554 279.02C393.914 279.34 393.194 279.5 392.394 279.5C391.69 279.5 391.002 279.34 390.33 279.02C389.658 278.668 389.322 278.156 389.322 277.484V266.156C389.322 265.42 389.13 264.732 388.746 264.092C388.362 263.452 387.85 262.924 387.21 262.508C386.602 262.06 385.914 261.836 385.146 261.836C384.506 261.836 383.882 262.012 383.274 262.364C382.666 262.716 382.17 263.212 381.786 263.852C381.402 264.492 381.21 265.26 381.21 266.156V277.484C381.21 277.996 380.906 278.46 380.298 278.876C379.69 279.292 378.954 279.5 378.09 279.5ZM405.038 279.932C403.342 279.932 401.87 279.42 400.622 278.396C399.406 277.34 398.798 275.724 398.798 273.548C398.798 271.724 399.262 270.3 400.19 269.276C401.15 268.252 402.462 267.532 404.126 267.116C405.822 266.7 407.774 266.492 409.982 266.492H411.95V265.868C411.95 265.164 411.806 264.476 411.518 263.804C411.262 263.132 410.83 262.572 410.222 262.124C409.646 261.676 408.814 261.452 407.726 261.452C406.51 261.452 405.566 261.58 404.894 261.836C404.254 262.06 403.758 262.3 403.406 262.556C403.054 262.812 402.67 262.94 402.254 262.94C401.582 262.94 401.054 262.604 400.67 261.932C400.318 261.26 400.142 260.572 400.142 259.868C400.142 259.196 400.542 258.604 401.342 258.092C402.174 257.548 403.182 257.132 404.366 256.844C405.55 256.556 406.702 256.412 407.822 256.412C410.318 256.412 412.318 256.86 413.822 257.756C415.326 258.652 416.414 259.804 417.086 261.212C417.79 262.62 418.142 264.14 418.142 265.772V277.484C418.142 278.06 417.854 278.54 417.278 278.924C416.702 279.308 415.982 279.5 415.118 279.5C414.318 279.5 413.646 279.308 413.102 278.924C412.59 278.54 412.334 278.06 412.334 277.484V276.14C411.47 277.132 410.446 278.012 409.262 278.78C408.11 279.548 406.702 279.932 405.038 279.932ZM407.534 275.324C408.206 275.324 408.878 275.1 409.55 274.652C410.222 274.204 410.782 273.628 411.23 272.924C411.71 272.22 411.95 271.484 411.95 270.716V269.708H411.23C410.174 269.708 409.166 269.772 408.206 269.9C407.246 270.028 406.462 270.316 405.854 270.764C405.278 271.18 404.99 271.836 404.99 272.732C404.99 273.628 405.23 274.284 405.71 274.7C406.222 275.116 406.83 275.324 407.534 275.324ZM425.76 279.5C424.896 279.5 424.176 279.292 423.6 278.876C423.024 278.46 422.736 277.996 422.736 277.484V258.62C422.736 258.044 423.024 257.58 423.6 257.228C424.176 256.876 424.896 256.7 425.76 256.7C426.56 256.7 427.216 256.876 427.728 257.228C428.272 257.58 428.544 258.044 428.544 258.62V260.588C428.896 259.884 429.36 259.228 429.936 258.62C430.544 257.98 431.232 257.452 432 257.036C432.768 256.62 433.584 256.412 434.448 256.412H435.936C436.544 256.412 437.072 256.684 437.52 257.228C437.968 257.74 438.192 258.364 438.192 259.1C438.192 259.868 437.968 260.524 437.52 261.068C437.072 261.58 436.544 261.836 435.936 261.836H434.448C433.552 261.836 432.672 262.14 431.808 262.748C430.976 263.324 430.288 264.14 429.744 265.196C429.2 266.22 428.928 267.468 428.928 268.94V277.484C428.928 277.996 428.624 278.46 428.016 278.876C427.408 279.292 426.656 279.5 425.76 279.5ZM443.808 279.5C442.912 279.5 442.176 279.292 441.6 278.876C441.024 278.46 440.736 277.996 440.736 277.484V258.62C440.736 258.044 441.024 257.58 441.6 257.228C442.176 256.876 442.912 256.7 443.808 256.7C444.576 256.7 445.216 256.876 445.728 257.228C446.272 257.58 446.544 258.044 446.544 258.62V260.06C447.088 259.132 447.888 258.3 448.944 257.564C450 256.796 451.328 256.412 452.928 256.412C454.304 256.412 455.52 256.86 456.576 257.756C457.632 258.652 458.416 259.804 458.928 261.212C459.76 259.58 460.816 258.38 462.096 257.612C463.408 256.812 464.752 256.412 466.128 256.412C467.6 256.412 468.976 256.796 470.256 257.564C471.568 258.3 472.624 259.404 473.424 260.876C474.256 262.316 474.672 264.076 474.672 266.156V277.484C474.672 277.996 474.368 278.46 473.76 278.876C473.152 279.292 472.416 279.5 471.552 279.5C470.72 279.5 470 279.292 469.392 278.876C468.784 278.46 468.48 277.996 468.48 277.484V266.156C468.48 265.196 468.288 264.396 467.904 263.756C467.552 263.116 467.072 262.636 466.464 262.316C465.856 261.964 465.232 261.788 464.592 261.788C463.984 261.788 463.392 261.964 462.816 262.316C462.24 262.636 461.76 263.116 461.376 263.756C460.992 264.396 460.8 265.18 460.8 266.108V277.532C460.8 278.236 460.464 278.748 459.792 279.068C459.152 279.356 458.448 279.5 457.68 279.5C456.976 279.5 456.288 279.356 455.616 279.068C454.944 278.748 454.608 278.236 454.608 277.532V266.156C454.608 265.26 454.416 264.492 454.032 263.852C453.68 263.212 453.2 262.716 452.592 262.364C452.016 262.012 451.392 261.836 450.72 261.836C450.08 261.836 449.472 261.996 448.896 262.316C448.32 262.636 447.84 263.116 447.456 263.756C447.104 264.396 446.928 265.196 446.928 266.156V277.484C446.928 277.996 446.624 278.46 446.016 278.876C445.408 279.292 444.672 279.5 443.808 279.5ZM488.771 279.932C486.915 279.932 485.203 279.484 483.635 278.588C482.067 277.66 480.803 276.444 479.843 274.94C478.883 273.436 478.403 271.82 478.403 270.092V266.156C478.403 264.428 478.867 262.828 479.795 261.356C480.723 259.852 481.971 258.652 483.539 257.756C485.139 256.86 486.883 256.412 488.771 256.412C490.659 256.412 492.387 256.86 493.955 257.756C495.555 258.62 496.819 259.788 497.747 261.26C498.707 262.732 499.187 264.364 499.187 266.156V270.092C499.187 271.788 498.707 273.388 497.747 274.892C496.787 276.396 495.507 277.612 493.907 278.54C492.339 279.468 490.627 279.932 488.771 279.932ZM488.771 274.508C489.539 274.508 490.243 274.3 490.883 273.884C491.523 273.468 492.035 272.924 492.419 272.252C492.803 271.548 492.995 270.828 492.995 270.092V266.156C492.995 265.42 492.803 264.732 492.419 264.092C492.035 263.452 491.523 262.924 490.883 262.508C490.275 262.06 489.571 261.836 488.771 261.836C488.003 261.836 487.299 262.044 486.659 262.46C486.019 262.876 485.507 263.42 485.123 264.092C484.771 264.732 484.595 265.42 484.595 266.156V270.092C484.595 270.828 484.771 271.548 485.123 272.252C485.507 272.924 486.019 273.468 486.659 273.884C487.299 274.3 488.003 274.508 488.771 274.508ZM506.199 279.5C505.303 279.5 504.567 279.292 503.991 278.876C503.415 278.46 503.127 277.996 503.127 277.484V258.62C503.127 258.044 503.415 257.58 503.991 257.228C504.567 256.876 505.303 256.7 506.199 256.7C506.967 256.7 507.607 256.876 508.119 257.228C508.663 257.58 508.935 258.044 508.935 258.62V260.06C509.415 259.132 510.199 258.3 511.287 257.564C512.407 256.796 513.767 256.412 515.367 256.412C516.871 256.412 518.247 256.86 519.495 257.756C520.743 258.62 521.735 259.788 522.471 261.26C523.239 262.732 523.623 264.364 523.623 266.156V277.484C523.623 278.156 523.303 278.668 522.663 279.02C522.023 279.34 521.303 279.5 520.503 279.5C519.799 279.5 519.111 279.34 518.439 279.02C517.767 278.668 517.431 278.156 517.431 277.484V266.156C517.431 265.42 517.239 264.732 516.855 264.092C516.503 263.452 516.007 262.924 515.367 262.508C514.727 262.06 514.023 261.836 513.255 261.836C512.615 261.836 511.991 262.012 511.383 262.364C510.775 262.716 510.279 263.212 509.895 263.852C509.511 264.492 509.319 265.26 509.319 266.156V277.484C509.319 277.996 509.015 278.46 508.407 278.876C507.799 279.292 507.063 279.5 506.199 279.5ZM528.642 290.108C527.842 290.108 527.17 289.948 526.626 289.628C526.082 289.34 525.81 288.62 525.81 287.468C525.81 286.764 525.922 286.156 526.146 285.644C526.402 285.132 526.818 284.876 527.394 284.876C527.938 284.876 528.562 284.78 529.266 284.588C530.002 284.396 530.738 284.028 531.474 283.484C532.21 282.972 532.834 282.252 533.346 281.324C533.858 280.428 534.162 279.26 534.258 277.82L526.002 260.156C525.874 259.868 525.81 259.596 525.81 259.34C525.81 258.796 526.034 258.3 526.482 257.852C526.962 257.404 527.522 257.052 528.162 256.796C528.802 256.508 529.394 256.364 529.938 256.364C530.322 256.364 530.674 256.444 530.994 256.604C531.346 256.764 531.586 257.036 531.714 257.42L537.474 271.772L542.082 257.42C542.242 257.036 542.482 256.764 542.802 256.604C543.122 256.444 543.442 256.364 543.762 256.364C544.242 256.364 544.818 256.508 545.49 256.796C546.162 257.052 546.738 257.42 547.218 257.9C547.73 258.348 547.986 258.86 547.986 259.436C547.986 259.724 547.938 259.964 547.842 260.156L540.834 278.06C540.258 279.5 539.698 280.924 539.154 282.332C538.61 283.772 537.922 285.068 537.09 286.22C536.29 287.404 535.218 288.348 533.874 289.052C532.53 289.756 530.786 290.108 528.642 290.108ZM585.444 279.932C583.94 279.932 582.58 279.548 581.364 278.78C580.148 278.012 579.284 277.132 578.772 276.14V277.484C578.772 277.996 578.5 278.46 577.956 278.876C577.444 279.292 576.788 279.5 575.988 279.5C575.124 279.5 574.404 279.292 573.828 278.876C573.252 278.46 572.964 277.996 572.964 277.484V245.324C572.964 244.748 573.252 244.284 573.828 243.932C574.404 243.58 575.124 243.404 575.988 243.404C576.884 243.404 577.636 243.58 578.244 243.932C578.852 244.284 579.156 244.748 579.156 245.324V260.06C579.668 259.132 580.452 258.3 581.508 257.564C582.564 256.796 583.844 256.412 585.348 256.412C586.916 256.412 588.34 256.86 589.62 257.756C590.9 258.62 591.924 259.788 592.692 261.26C593.46 262.732 593.844 264.364 593.844 266.156V270.092C593.844 271.788 593.46 273.388 592.692 274.892C591.924 276.396 590.9 277.612 589.62 278.54C588.372 279.468 586.98 279.932 585.444 279.932ZM583.476 274.508C584.244 274.508 584.948 274.3 585.588 273.884C586.228 273.436 586.724 272.876 587.076 272.204C587.46 271.532 587.652 270.828 587.652 270.092V266.156C587.652 265.42 587.46 264.732 587.076 264.092C586.724 263.452 586.228 262.924 585.588 262.508C584.948 262.06 584.228 261.836 583.428 261.836C582.756 261.836 582.084 262.012 581.412 262.364C580.772 262.716 580.228 263.212 579.78 263.852C579.364 264.492 579.156 265.26 579.156 266.156V270.956C579.156 271.276 579.348 271.724 579.732 272.3C580.116 272.844 580.628 273.356 581.268 273.836C581.94 274.284 582.676 274.508 583.476 274.508ZM598.338 290.108C597.538 290.108 596.866 289.948 596.322 289.628C595.778 289.34 595.506 288.62 595.506 287.468C595.506 286.764 595.618 286.156 595.842 285.644C596.098 285.132 596.514 284.876 597.09 284.876C597.634 284.876 598.258 284.78 598.962 284.588C599.698 284.396 600.434 284.028 601.17 283.484C601.906 282.972 602.53 282.252 603.042 281.324C603.554 280.428 603.858 279.26 603.954 277.82L595.698 260.156C595.57 259.868 595.506 259.596 595.506 259.34C595.506 258.796 595.73 258.3 596.178 257.852C596.658 257.404 597.218 257.052 597.858 256.796C598.498 256.508 599.09 256.364 599.634 256.364C600.018 256.364 600.37 256.444 600.69 256.604C601.042 256.764 601.282 257.036 601.41 257.42L607.17 271.772L611.778 257.42C611.938 257.036 612.178 256.764 612.498 256.604C612.818 256.444 613.138 256.364 613.458 256.364C613.938 256.364 614.514 256.508 615.186 256.796C615.858 257.052 616.434 257.42 616.914 257.9C617.426 258.348 617.682 258.86 617.682 259.436C617.682 259.724 617.634 259.964 617.538 260.156L610.53 278.06C609.954 279.5 609.394 280.924 608.85 282.332C608.306 283.772 607.618 285.068 606.786 286.22C605.986 287.404 604.914 288.348 603.57 289.052C602.226 289.756 600.482 290.108 598.338 290.108ZM85.048 349.932C82.616 349.932 80.632 349.5 79.096 348.636C77.56 347.772 76.424 346.604 75.688 345.132C74.952 343.628 74.584 341.948 74.584 340.092V336.252C74.584 334.396 74.936 332.732 75.64 331.26C76.376 329.756 77.512 328.572 79.048 327.708C80.616 326.844 82.584 326.412 84.952 326.412C86.456 326.412 87.784 326.588 88.936 326.94C90.088 327.292 91 327.756 91.672 328.332C92.344 328.908 92.68 329.516 92.68 330.156C92.68 330.54 92.568 330.972 92.344 331.452C92.152 331.9 91.864 332.3 91.48 332.652C91.128 333.004 90.712 333.18 90.232 333.18C89.88 333.18 89.512 333.068 89.128 332.844C88.776 332.62 88.312 332.396 87.736 332.172C87.16 331.948 86.392 331.836 85.432 331.836C83.8 331.836 82.616 332.236 81.88 333.036C81.144 333.804 80.776 334.876 80.776 336.252V340.092C80.776 341.468 81.144 342.556 81.88 343.356C82.616 344.124 83.816 344.508 85.48 344.508C86.472 344.508 87.24 344.38 87.784 344.124C88.328 343.868 88.776 343.628 89.128 343.404C89.512 343.18 89.896 343.068 90.28 343.068C90.856 343.068 91.336 343.228 91.72 343.548C92.136 343.868 92.44 344.268 92.632 344.748C92.856 345.196 92.968 345.612 92.968 345.996C92.968 346.636 92.616 347.26 91.912 347.868C91.24 348.476 90.296 348.972 89.08 349.356C87.896 349.74 86.552 349.932 85.048 349.932ZM105.435 349.932C103.579 349.932 101.867 349.484 100.299 348.588C98.7313 347.66 97.4673 346.444 96.5073 344.94C95.5473 343.436 95.0673 341.82 95.0673 340.092V336.156C95.0673 334.428 95.5313 332.828 96.4593 331.356C97.3873 329.852 98.6353 328.652 100.203 327.756C101.803 326.86 103.547 326.412 105.435 326.412C107.323 326.412 109.051 326.86 110.619 327.756C112.219 328.62 113.483 329.788 114.411 331.26C115.371 332.732 115.851 334.364 115.851 336.156V340.092C115.851 341.788 115.371 343.388 114.411 344.892C113.451 346.396 112.171 347.612 110.571 348.54C109.003 349.468 107.291 349.932 105.435 349.932ZM105.435 344.508C106.203 344.508 106.907 344.3 107.547 343.884C108.187 343.468 108.699 342.924 109.083 342.252C109.467 341.548 109.659 340.828 109.659 340.092V336.156C109.659 335.42 109.467 334.732 109.083 334.092C108.699 333.452 108.187 332.924 107.547 332.508C106.939 332.06 106.235 331.836 105.435 331.836C104.667 331.836 103.963 332.044 103.323 332.46C102.683 332.876 102.171 333.42 101.787 334.092C101.435 334.732 101.259 335.42 101.259 336.156V340.092C101.259 340.828 101.435 341.548 101.787 342.252C102.171 342.924 102.683 343.468 103.323 343.884C103.963 344.3 104.667 344.508 105.435 344.508ZM122.863 349.5C121.967 349.5 121.231 349.292 120.655 348.876C120.079 348.46 119.791 347.996 119.791 347.484V328.62C119.791 328.044 120.079 327.58 120.655 327.228C121.231 326.876 121.967 326.7 122.863 326.7C123.631 326.7 124.271 326.876 124.783 327.228C125.327 327.58 125.599 328.044 125.599 328.62V330.06C126.079 329.132 126.863 328.3 127.951 327.564C129.071 326.796 130.431 326.412 132.031 326.412C133.535 326.412 134.911 326.86 136.159 327.756C137.407 328.62 138.399 329.788 139.135 331.26C139.903 332.732 140.287 334.364 140.287 336.156V347.484C140.287 348.156 139.967 348.668 139.327 349.02C138.687 349.34 137.967 349.5 137.167 349.5C136.463 349.5 135.775 349.34 135.103 349.02C134.431 348.668 134.095 348.156 134.095 347.484V336.156C134.095 335.42 133.903 334.732 133.519 334.092C133.167 333.452 132.671 332.924 132.031 332.508C131.391 332.06 130.687 331.836 129.919 331.836C129.279 331.836 128.655 332.012 128.047 332.364C127.439 332.716 126.943 333.212 126.559 333.852C126.175 334.492 125.983 335.26 125.983 336.156V347.484C125.983 347.996 125.679 348.46 125.071 348.876C124.463 349.292 123.727 349.5 122.863 349.5ZM152.356 349.932C150.756 349.932 149.284 349.74 147.94 349.356C146.628 348.94 145.588 348.412 144.82 347.772C144.084 347.132 143.716 346.476 143.716 345.804C143.716 345.452 143.796 345.068 143.956 344.652C144.148 344.236 144.388 343.868 144.676 343.548C144.996 343.228 145.364 343.068 145.78 343.068C146.228 343.068 146.692 343.26 147.172 343.644C147.684 343.996 148.308 344.348 149.044 344.7C149.812 345.052 150.868 345.228 152.212 345.228C153.652 345.228 154.596 345.004 155.044 344.556C155.524 344.108 155.764 343.644 155.764 343.164C155.764 342.46 155.476 341.916 154.9 341.532C154.356 341.148 153.652 340.844 152.788 340.62C151.924 340.364 150.996 340.092 150.004 339.804C149.044 339.516 148.132 339.148 147.268 338.7C146.404 338.22 145.7 337.58 145.156 336.78C144.612 335.948 144.34 334.876 144.34 333.564C144.34 332.412 144.612 331.292 145.156 330.204C145.7 329.116 146.596 328.22 147.844 327.516C149.092 326.78 150.788 326.412 152.932 326.412C154.244 326.412 155.476 326.556 156.628 326.844C157.812 327.1 158.772 327.468 159.508 327.948C160.244 328.428 160.612 328.956 160.612 329.532C160.612 329.82 160.516 330.204 160.324 330.684C160.132 331.132 159.86 331.548 159.508 331.932C159.188 332.316 158.788 332.508 158.308 332.508C157.956 332.508 157.524 332.396 157.012 332.172C156.532 331.916 155.972 331.676 155.332 331.452C154.692 331.228 153.924 331.116 153.028 331.116C152.228 331.116 151.588 331.228 151.108 331.452C150.628 331.676 150.276 331.948 150.052 332.268C149.828 332.588 149.716 332.924 149.716 333.276C149.716 333.852 149.988 334.3 150.532 334.62C151.076 334.94 151.78 335.212 152.644 335.436C153.54 335.66 154.468 335.916 155.428 336.204C156.42 336.46 157.348 336.844 158.212 337.356C159.108 337.868 159.828 338.572 160.372 339.468C160.916 340.332 161.188 341.468 161.188 342.876C161.188 345.02 160.42 346.732 158.884 348.012C157.38 349.292 155.204 349.932 152.356 349.932ZM173.715 349.5C170.835 349.5 168.627 348.876 167.091 347.628C165.587 346.38 164.835 344.396 164.835 341.676V318.444C164.835 317.868 165.171 317.404 165.843 317.052C166.515 316.7 167.203 316.524 167.907 316.524C168.675 316.524 169.379 316.7 170.019 317.052C170.691 317.404 171.027 317.868 171.027 318.444V326.7H176.691C177.203 326.7 177.587 326.94 177.843 327.42C178.131 327.868 178.275 328.38 178.275 328.956C178.275 329.532 178.131 330.06 177.843 330.54C177.587 330.988 177.203 331.212 176.691 331.212H171.027V341.676C171.027 342.636 171.219 343.308 171.603 343.692C172.019 344.076 172.723 344.268 173.715 344.268H175.587C176.483 344.268 177.139 344.54 177.555 345.084C178.003 345.628 178.227 346.22 178.227 346.86C178.227 347.532 178.003 348.14 177.555 348.684C177.139 349.228 176.483 349.5 175.587 349.5H173.715ZM186.327 349.932C184.631 349.932 183.159 349.42 181.911 348.396C180.695 347.34 180.087 345.724 180.087 343.548C180.087 341.724 180.551 340.3 181.479 339.276C182.439 338.252 183.751 337.532 185.415 337.116C187.111 336.7 189.063 336.492 191.271 336.492H193.239V335.868C193.239 335.164 193.095 334.476 192.807 333.804C192.551 333.132 192.119 332.572 191.511 332.124C190.935 331.676 190.103 331.452 189.015 331.452C187.799 331.452 186.855 331.58 186.183 331.836C185.543 332.06 185.047 332.3 184.695 332.556C184.343 332.812 183.959 332.94 183.543 332.94C182.871 332.94 182.343 332.604 181.959 331.932C181.607 331.26 181.431 330.572 181.431 329.868C181.431 329.196 181.831 328.604 182.631 328.092C183.463 327.548 184.471 327.132 185.655 326.844C186.839 326.556 187.991 326.412 189.111 326.412C191.607 326.412 193.607 326.86 195.111 327.756C196.615 328.652 197.703 329.804 198.375 331.212C199.079 332.62 199.431 334.14 199.431 335.772V347.484C199.431 348.06 199.143 348.54 198.567 348.924C197.991 349.308 197.271 349.5 196.407 349.5C195.607 349.5 194.935 349.308 194.391 348.924C193.879 348.54 193.623 348.06 193.623 347.484V346.14C192.759 347.132 191.735 348.012 190.551 348.78C189.399 349.548 187.991 349.932 186.327 349.932ZM188.823 345.324C189.495 345.324 190.167 345.1 190.839 344.652C191.511 344.204 192.071 343.628 192.519 342.924C192.999 342.22 193.239 341.484 193.239 340.716V339.708H192.519C191.463 339.708 190.455 339.772 189.495 339.9C188.535 340.028 187.751 340.316 187.143 340.764C186.567 341.18 186.279 341.836 186.279 342.732C186.279 343.628 186.519 344.284 186.999 344.7C187.511 345.116 188.119 345.324 188.823 345.324ZM207.097 349.5C206.201 349.5 205.465 349.292 204.889 348.876C204.313 348.46 204.025 347.996 204.025 347.484V328.62C204.025 328.044 204.313 327.58 204.889 327.228C205.465 326.876 206.201 326.7 207.097 326.7C207.865 326.7 208.505 326.876 209.017 327.228C209.561 327.58 209.833 328.044 209.833 328.62V330.06C210.313 329.132 211.097 328.3 212.185 327.564C213.305 326.796 214.665 326.412 216.265 326.412C217.769 326.412 219.145 326.86 220.393 327.756C221.641 328.62 222.633 329.788 223.369 331.26C224.137 332.732 224.521 334.364 224.521 336.156V347.484C224.521 348.156 224.201 348.668 223.561 349.02C222.921 349.34 222.201 349.5 221.401 349.5C220.697 349.5 220.009 349.34 219.337 349.02C218.665 348.668 218.329 348.156 218.329 347.484V336.156C218.329 335.42 218.137 334.732 217.753 334.092C217.401 333.452 216.905 332.924 216.265 332.508C215.625 332.06 214.921 331.836 214.153 331.836C213.513 331.836 212.889 332.012 212.281 332.364C211.673 332.716 211.177 333.212 210.793 333.852C210.409 334.492 210.217 335.26 210.217 336.156V347.484C210.217 347.996 209.913 348.46 209.305 348.876C208.697 349.292 207.961 349.5 207.097 349.5ZM237.934 349.5C235.054 349.5 232.846 348.876 231.31 347.628C229.806 346.38 229.054 344.396 229.054 341.676V318.444C229.054 317.868 229.39 317.404 230.062 317.052C230.734 316.7 231.422 316.524 232.126 316.524C232.894 316.524 233.598 316.7 234.238 317.052C234.91 317.404 235.246 317.868 235.246 318.444V326.7H240.91C241.422 326.7 241.806 326.94 242.062 327.42C242.35 327.868 242.494 328.38 242.494 328.956C242.494 329.532 242.35 330.06 242.062 330.54C241.806 330.988 241.422 331.212 240.91 331.212H235.246V341.676C235.246 342.636 235.438 343.308 235.822 343.692C236.238 344.076 236.942 344.268 237.934 344.268H239.806C240.702 344.268 241.358 344.54 241.774 345.084C242.222 345.628 242.446 346.22 242.446 346.86C242.446 347.532 242.222 348.14 241.774 348.684C241.358 349.228 240.702 349.5 239.806 349.5H237.934ZM249.154 349.5C248.258 349.5 247.522 349.292 246.946 348.876C246.37 348.46 246.082 347.996 246.082 347.484V315.324C246.082 314.748 246.37 314.284 246.946 313.932C247.522 313.58 248.258 313.404 249.154 313.404C250.018 313.404 250.754 313.58 251.362 313.932C251.97 314.284 252.274 314.748 252.274 315.324V347.484C252.274 347.996 251.97 348.46 251.362 348.876C250.754 349.292 250.018 349.5 249.154 349.5ZM258.181 360.108C257.381 360.108 256.709 359.948 256.165 359.628C255.621 359.34 255.349 358.62 255.349 357.468C255.349 356.764 255.461 356.156 255.685 355.644C255.941 355.132 256.357 354.876 256.933 354.876C257.477 354.876 258.101 354.78 258.805 354.588C259.541 354.396 260.277 354.028 261.013 353.484C261.749 352.972 262.373 352.252 262.885 351.324C263.397 350.428 263.701 349.26 263.797 347.82L255.541 330.156C255.413 329.868 255.349 329.596 255.349 329.34C255.349 328.796 255.573 328.3 256.021 327.852C256.501 327.404 257.061 327.052 257.701 326.796C258.341 326.508 258.933 326.364 259.477 326.364C259.861 326.364 260.213 326.444 260.533 326.604C260.885 326.764 261.125 327.036 261.253 327.42L267.013 341.772L271.621 327.42C271.781 327.036 272.021 326.764 272.341 326.604C272.661 326.444 272.981 326.364 273.301 326.364C273.781 326.364 274.357 326.508 275.029 326.796C275.701 327.052 276.277 327.42 276.757 327.9C277.269 328.348 277.525 328.86 277.525 329.436C277.525 329.724 277.477 329.964 277.381 330.156L270.373 348.06C269.797 349.5 269.237 350.924 268.693 352.332C268.149 353.772 267.461 355.068 266.629 356.22C265.829 357.404 264.757 358.348 263.413 359.052C262.069 359.756 260.325 360.108 258.181 360.108ZM325.998 349.5C325.102 349.5 324.366 349.292 323.79 348.876C323.214 348.46 322.926 347.996 322.926 347.484V315.324C322.926 314.748 323.214 314.284 323.79 313.932C324.366 313.58 325.102 313.404 325.998 313.404C326.862 313.404 327.598 313.58 328.206 313.932C328.814 314.284 329.118 314.748 329.118 315.324V347.484C329.118 347.996 328.814 348.46 328.206 348.876C327.598 349.292 326.862 349.5 325.998 349.5ZM345.105 349.932C342.833 349.932 340.817 349.532 339.057 348.732C337.329 347.9 335.969 346.748 334.977 345.276C333.985 343.772 333.489 342.044 333.489 340.092V336.012C333.489 334.284 333.953 332.7 334.881 331.26C335.841 329.788 337.105 328.62 338.673 327.756C340.273 326.86 342.049 326.412 344.001 326.412C345.793 326.412 347.425 326.796 348.897 327.564C350.401 328.332 351.617 329.388 352.545 330.732C353.473 332.076 353.937 333.644 353.937 335.436C353.937 336.812 353.713 337.804 353.265 338.412C352.817 338.988 352.241 339.356 351.537 339.516C350.865 339.644 350.161 339.708 349.425 339.708H339.681V340.428C339.681 341.804 340.193 342.924 341.217 343.788C342.273 344.62 343.633 345.036 345.297 345.036C346.353 345.036 347.233 344.876 347.937 344.556C348.641 344.236 349.249 343.932 349.761 343.644C350.273 343.356 350.753 343.212 351.201 343.212C351.681 343.212 352.097 343.372 352.449 343.692C352.801 344.012 353.073 344.396 353.265 344.844C353.457 345.26 353.553 345.628 353.553 345.948C353.553 346.492 353.201 347.084 352.497 347.724C351.825 348.332 350.849 348.86 349.569 349.308C348.321 349.724 346.833 349.932 345.105 349.932ZM339.681 336.06H346.689C347.233 336.06 347.601 335.98 347.793 335.82C348.017 335.628 348.129 335.276 348.129 334.764C348.129 334.028 347.921 333.372 347.505 332.796C347.121 332.22 346.609 331.772 345.969 331.452C345.361 331.132 344.673 330.972 343.905 330.972C343.169 330.972 342.481 331.132 341.841 331.452C341.201 331.74 340.673 332.172 340.257 332.748C339.873 333.292 339.681 333.948 339.681 334.716V336.06ZM362.546 349.932C360.85 349.932 359.378 349.42 358.13 348.396C356.914 347.34 356.306 345.724 356.306 343.548C356.306 341.724 356.77 340.3 357.698 339.276C358.658 338.252 359.97 337.532 361.634 337.116C363.33 336.7 365.282 336.492 367.49 336.492H369.458V335.868C369.458 335.164 369.314 334.476 369.026 333.804C368.77 333.132 368.338 332.572 367.73 332.124C367.154 331.676 366.322 331.452 365.234 331.452C364.018 331.452 363.074 331.58 362.402 331.836C361.762 332.06 361.266 332.3 360.914 332.556C360.562 332.812 360.178 332.94 359.762 332.94C359.09 332.94 358.562 332.604 358.178 331.932C357.826 331.26 357.65 330.572 357.65 329.868C357.65 329.196 358.05 328.604 358.85 328.092C359.682 327.548 360.69 327.132 361.874 326.844C363.058 326.556 364.21 326.412 365.33 326.412C367.826 326.412 369.826 326.86 371.33 327.756C372.834 328.652 373.922 329.804 374.594 331.212C375.298 332.62 375.65 334.14 375.65 335.772V347.484C375.65 348.06 375.362 348.54 374.786 348.924C374.21 349.308 373.49 349.5 372.626 349.5C371.826 349.5 371.154 349.308 370.61 348.924C370.098 348.54 369.842 348.06 369.842 347.484V346.14C368.978 347.132 367.954 348.012 366.77 348.78C365.618 349.548 364.21 349.932 362.546 349.932ZM365.042 345.324C365.714 345.324 366.386 345.1 367.058 344.652C367.73 344.204 368.29 343.628 368.738 342.924C369.218 342.22 369.458 341.484 369.458 340.716V339.708H368.738C367.682 339.708 366.674 339.772 365.714 339.9C364.754 340.028 363.97 340.316 363.362 340.764C362.786 341.18 362.498 341.836 362.498 342.732C362.498 343.628 362.738 344.284 363.218 344.7C363.73 345.116 364.338 345.324 365.042 345.324ZM383.268 349.5C382.404 349.5 381.684 349.292 381.108 348.876C380.532 348.46 380.244 347.996 380.244 347.484V328.62C380.244 328.044 380.532 327.58 381.108 327.228C381.684 326.876 382.404 326.7 383.268 326.7C384.068 326.7 384.724 326.876 385.236 327.228C385.78 327.58 386.052 328.044 386.052 328.62V330.588C386.404 329.884 386.868 329.228 387.444 328.62C388.052 327.98 388.74 327.452 389.508 327.036C390.276 326.62 391.092 326.412 391.956 326.412H393.444C394.052 326.412 394.58 326.684 395.028 327.228C395.476 327.74 395.7 328.364 395.7 329.1C395.7 329.868 395.476 330.524 395.028 331.068C394.58 331.58 394.052 331.836 393.444 331.836H391.956C391.06 331.836 390.18 332.14 389.316 332.748C388.484 333.324 387.796 334.14 387.252 335.196C386.708 336.22 386.436 337.468 386.436 338.94V347.484C386.436 347.996 386.132 348.46 385.524 348.876C384.916 349.292 384.164 349.5 383.268 349.5ZM401.316 349.5C400.42 349.5 399.684 349.292 399.108 348.876C398.532 348.46 398.244 347.996 398.244 347.484V328.62C398.244 328.044 398.532 327.58 399.108 327.228C399.684 326.876 400.42 326.7 401.316 326.7C402.084 326.7 402.724 326.876 403.236 327.228C403.78 327.58 404.052 328.044 404.052 328.62V330.06C404.532 329.132 405.316 328.3 406.404 327.564C407.524 326.796 408.884 326.412 410.484 326.412C411.988 326.412 413.364 326.86 414.612 327.756C415.86 328.62 416.852 329.788 417.588 331.26C418.356 332.732 418.74 334.364 418.74 336.156V347.484C418.74 348.156 418.42 348.668 417.78 349.02C417.14 349.34 416.42 349.5 415.62 349.5C414.916 349.5 414.228 349.34 413.556 349.02C412.884 348.668 412.548 348.156 412.548 347.484V336.156C412.548 335.42 412.356 334.732 411.972 334.092C411.62 333.452 411.124 332.924 410.484 332.508C409.844 332.06 409.14 331.836 408.372 331.836C407.732 331.836 407.108 332.012 406.5 332.364C405.892 332.716 405.396 333.212 405.012 333.852C404.628 334.492 404.436 335.26 404.436 336.156V347.484C404.436 347.996 404.132 348.46 403.524 348.876C402.916 349.292 402.18 349.5 401.316 349.5ZM426.441 321.612C425.513 321.612 424.713 321.308 424.041 320.7C423.369 320.06 423.033 319.356 423.033 318.588C423.033 317.756 423.369 317.052 424.041 316.476C424.713 315.868 425.513 315.564 426.441 315.564C427.401 315.564 428.201 315.868 428.841 316.476C429.481 317.052 429.801 317.756 429.801 318.588C429.801 319.356 429.481 320.06 428.841 320.7C428.201 321.308 427.401 321.612 426.441 321.612ZM426.441 349.5C425.545 349.5 424.809 349.292 424.233 348.876C423.657 348.46 423.369 347.996 423.369 347.484V328.62C423.369 328.044 423.657 327.58 424.233 327.228C424.809 326.876 425.545 326.7 426.441 326.7C427.305 326.7 428.041 326.876 428.649 327.228C429.257 327.58 429.561 328.044 429.561 328.62V347.484C429.561 347.996 429.257 348.46 428.649 348.876C428.041 349.292 427.305 349.5 426.441 349.5ZM437.363 349.5C436.467 349.5 435.731 349.292 435.155 348.876C434.579 348.46 434.291 347.996 434.291 347.484V328.62C434.291 328.044 434.579 327.58 435.155 327.228C435.731 326.876 436.467 326.7 437.363 326.7C438.131 326.7 438.771 326.876 439.283 327.228C439.827 327.58 440.099 328.044 440.099 328.62V330.06C440.579 329.132 441.363 328.3 442.451 327.564C443.571 326.796 444.931 326.412 446.531 326.412C448.035 326.412 449.411 326.86 450.659 327.756C451.907 328.62 452.899 329.788 453.635 331.26C454.403 332.732 454.787 334.364 454.787 336.156V347.484C454.787 348.156 454.467 348.668 453.827 349.02C453.187 349.34 452.467 349.5 451.667 349.5C450.963 349.5 450.275 349.34 449.603 349.02C448.931 348.668 448.595 348.156 448.595 347.484V336.156C448.595 335.42 448.403 334.732 448.019 334.092C447.667 333.452 447.171 332.924 446.531 332.508C445.891 332.06 445.187 331.836 444.419 331.836C443.779 331.836 443.155 332.012 442.547 332.364C441.939 332.716 441.443 333.212 441.059 333.852C440.675 334.492 440.483 335.26 440.483 336.156V347.484C440.483 347.996 440.179 348.46 439.571 348.876C438.963 349.292 438.227 349.5 437.363 349.5ZM468.392 360.108C466.504 360.108 464.744 359.836 463.112 359.292C461.512 358.78 460.216 358.012 459.224 356.988C458.264 355.964 457.784 354.748 457.784 353.34C457.784 352.124 458.12 351.084 458.792 350.22C459.464 349.388 460.296 348.732 461.288 348.252C460.68 347.964 460.184 347.58 459.8 347.1C459.448 346.588 459.272 345.948 459.272 345.18C459.272 344.284 459.496 343.564 459.944 343.02C460.424 342.444 461.016 341.916 461.72 341.436C460.76 340.7 460.008 339.82 459.464 338.796C458.952 337.74 458.696 336.588 458.696 335.34V334.332C458.696 332.764 459.08 331.388 459.848 330.204C460.648 329.02 461.752 328.092 463.16 327.42C464.6 326.748 466.248 326.412 468.104 326.412C469.16 326.412 470.152 326.54 471.08 326.796C472.008 327.02 472.84 327.356 473.576 327.804C474.12 326.524 474.632 325.66 475.112 325.212C475.592 324.764 476.056 324.54 476.504 324.54C477.272 324.54 477.864 324.764 478.28 325.212C478.728 325.66 478.952 326.076 478.952 326.46C478.952 326.748 478.872 327.004 478.712 327.228C478.584 327.452 478.408 327.644 478.184 327.804C477.864 327.996 477.496 328.236 477.08 328.524C476.664 328.78 476.28 329.148 475.928 329.628C476.504 330.268 476.92 330.988 477.176 331.788C477.464 332.556 477.608 333.404 477.608 334.332V335.34C477.608 336.876 477.208 338.252 476.408 339.468C475.608 340.652 474.488 341.596 473.048 342.3C471.608 343.004 469.96 343.356 468.104 343.356C466.952 343.356 465.912 343.212 464.984 342.924C464.824 343.052 464.68 343.196 464.552 343.356C464.456 343.516 464.408 343.692 464.408 343.884C464.408 344.428 464.76 344.812 465.464 345.036C466.168 345.26 467.064 345.436 468.152 345.564C469.24 345.692 470.392 345.868 471.608 346.092C472.856 346.284 474.024 346.604 475.112 347.052C476.2 347.5 477.096 348.172 477.8 349.068C478.504 349.932 478.856 351.1 478.856 352.572C478.856 354.364 478.344 355.804 477.32 356.892C476.328 358.012 475.032 358.828 473.432 359.34C471.864 359.852 470.184 360.108 468.392 360.108ZM468.296 356.124C469.544 356.124 470.6 355.82 471.464 355.212C472.36 354.604 472.808 353.788 472.808 352.764C472.808 352.092 472.616 351.548 472.232 351.132C471.848 350.716 471.32 350.396 470.648 350.172C470.008 349.98 469.304 349.82 468.536 349.692C467.768 349.596 467 349.5 466.232 349.404C465.464 349.756 464.84 350.204 464.36 350.748C463.88 351.292 463.64 351.948 463.64 352.716C463.64 353.772 464.088 354.604 464.984 355.212C465.912 355.82 467.016 356.124 468.296 356.124ZM468.2 339.612C469.256 339.612 470.088 339.212 470.696 338.412C471.304 337.612 471.608 336.588 471.608 335.34V334.332C471.608 333.148 471.304 332.156 470.696 331.356C470.12 330.556 469.272 330.156 468.152 330.156C467.064 330.156 466.216 330.556 465.608 331.356C465.032 332.156 464.744 333.148 464.744 334.332V335.292C464.744 336.508 465.032 337.532 465.608 338.364C466.216 339.196 467.08 339.612 468.2 339.612ZM527.331 349.5C526.467 349.5 525.747 349.324 525.171 348.972C524.595 348.588 524.307 348.108 524.307 347.532V322.812C524.307 321.02 524.691 319.42 525.459 318.012C526.227 316.572 527.251 315.452 528.531 314.652C529.811 313.82 531.219 313.404 532.755 313.404H535.587C536.355 313.404 536.931 313.676 537.315 314.22C537.731 314.764 537.939 315.356 537.939 315.996C537.939 316.7 537.731 317.324 537.315 317.868C536.931 318.38 536.355 318.636 535.587 318.636H534.051C533.379 318.636 532.771 318.78 532.227 319.068C531.683 319.356 531.251 319.756 530.931 320.268C530.643 320.78 530.499 321.404 530.499 322.14V326.7H536.355C536.867 326.7 537.251 326.94 537.507 327.42C537.795 327.868 537.939 328.38 537.939 328.956C537.939 329.532 537.795 330.06 537.507 330.54C537.251 330.988 536.867 331.212 536.355 331.212H530.499V347.532C530.499 348.108 530.179 348.588 529.539 348.972C528.931 349.324 528.195 349.5 527.331 349.5ZM543.596 349.5C542.732 349.5 542.012 349.292 541.436 348.876C540.86 348.46 540.572 347.996 540.572 347.484V328.62C540.572 328.044 540.86 327.58 541.436 327.228C542.012 326.876 542.732 326.7 543.596 326.7C544.396 326.7 545.052 326.876 545.564 327.228C546.108 327.58 546.38 328.044 546.38 328.62V330.588C546.732 329.884 547.196 329.228 547.772 328.62C548.38 327.98 549.068 327.452 549.836 327.036C550.604 326.62 551.42 326.412 552.284 326.412H553.772C554.38 326.412 554.908 326.684 555.356 327.228C555.804 327.74 556.028 328.364 556.028 329.1C556.028 329.868 555.804 330.524 555.356 331.068C554.908 331.58 554.38 331.836 553.772 331.836H552.284C551.388 331.836 550.508 332.14 549.644 332.748C548.812 333.324 548.124 334.14 547.58 335.196C547.036 336.22 546.764 337.468 546.764 338.94V347.484C546.764 347.996 546.46 348.46 545.852 348.876C545.244 349.292 544.492 349.5 543.596 349.5ZM567.513 349.932C565.657 349.932 563.945 349.484 562.377 348.588C560.809 347.66 559.545 346.444 558.585 344.94C557.625 343.436 557.145 341.82 557.145 340.092V336.156C557.145 334.428 557.609 332.828 558.537 331.356C559.465 329.852 560.713 328.652 562.281 327.756C563.881 326.86 565.625 326.412 567.513 326.412C569.401 326.412 571.129 326.86 572.697 327.756C574.297 328.62 575.561 329.788 576.489 331.26C577.449 332.732 577.929 334.364 577.929 336.156V340.092C577.929 341.788 577.449 343.388 576.489 344.892C575.529 346.396 574.249 347.612 572.649 348.54C571.081 349.468 569.369 349.932 567.513 349.932ZM567.513 344.508C568.281 344.508 568.985 344.3 569.625 343.884C570.265 343.468 570.777 342.924 571.161 342.252C571.545 341.548 571.737 340.828 571.737 340.092V336.156C571.737 335.42 571.545 334.732 571.161 334.092C570.777 333.452 570.265 332.924 569.625 332.508C569.017 332.06 568.313 331.836 567.513 331.836C566.745 331.836 566.041 332.044 565.401 332.46C564.761 332.876 564.249 333.42 563.865 334.092C563.513 334.732 563.337 335.42 563.337 336.156V340.092C563.337 340.828 563.513 341.548 563.865 342.252C564.249 342.924 564.761 343.468 565.401 343.884C566.041 344.3 566.745 344.508 567.513 344.508ZM584.941 349.5C584.045 349.5 583.309 349.292 582.733 348.876C582.157 348.46 581.869 347.996 581.869 347.484V328.62C581.869 328.044 582.157 327.58 582.733 327.228C583.309 326.876 584.045 326.7 584.941 326.7C585.709 326.7 586.349 326.876 586.861 327.228C587.405 327.58 587.677 328.044 587.677 328.62V330.06C588.221 329.132 589.021 328.3 590.077 327.564C591.133 326.796 592.461 326.412 594.061 326.412C595.437 326.412 596.653 326.86 597.709 327.756C598.765 328.652 599.549 329.804 600.061 331.212C600.893 329.58 601.949 328.38 603.229 327.612C604.541 326.812 605.885 326.412 607.261 326.412C608.733 326.412 610.109 326.796 611.389 327.564C612.701 328.3 613.757 329.404 614.557 330.876C615.389 332.316 615.805 334.076 615.805 336.156V347.484C615.805 347.996 615.501 348.46 614.893 348.876C614.285 349.292 613.549 349.5 612.685 349.5C611.853 349.5 611.133 349.292 610.525 348.876C609.917 348.46 609.613 347.996 609.613 347.484V336.156C609.613 335.196 609.421 334.396 609.037 333.756C608.685 333.116 608.205 332.636 607.597 332.316C606.989 331.964 606.365 331.788 605.725 331.788C605.117 331.788 604.525 331.964 603.949 332.316C603.373 332.636 602.893 333.116 602.509 333.756C602.125 334.396 601.933 335.18 601.933 336.108V347.532C601.933 348.236 601.597 348.748 600.925 349.068C600.285 349.356 599.581 349.5 598.813 349.5C598.109 349.5 597.421 349.356 596.749 349.068C596.077 348.748 595.741 348.236 595.741 347.532V336.156C595.741 335.26 595.549 334.492 595.165 333.852C594.813 333.212 594.333 332.716 593.725 332.364C593.149 332.012 592.525 331.836 591.853 331.836C591.213 331.836 590.605 331.996 590.029 332.316C589.453 332.636 588.973 333.116 588.589 333.756C588.237 334.396 588.061 335.196 588.061 336.156V347.484C588.061 347.996 587.757 348.46 587.149 348.876C586.541 349.292 585.805 349.5 584.941 349.5ZM86.152 419.932C83.88 419.932 81.864 419.532 80.104 418.732C78.376 417.9 77.016 416.748 76.024 415.276C75.032 413.772 74.536 412.044 74.536 410.092V406.012C74.536 404.284 75 402.7 75.928 401.26C76.888 399.788 78.152 398.62 79.72 397.756C81.32 396.86 83.096 396.412 85.048 396.412C86.84 396.412 88.472 396.796 89.944 397.564C91.448 398.332 92.664 399.388 93.592 400.732C94.52 402.076 94.984 403.644 94.984 405.436C94.984 406.812 94.76 407.804 94.312 408.412C93.864 408.988 93.288 409.356 92.584 409.516C91.912 409.644 91.208 409.708 90.472 409.708H80.728V410.428C80.728 411.804 81.24 412.924 82.264 413.788C83.32 414.62 84.68 415.036 86.344 415.036C87.4 415.036 88.28 414.876 88.984 414.556C89.688 414.236 90.296 413.932 90.808 413.644C91.32 413.356 91.8 413.212 92.248 413.212C92.728 413.212 93.144 413.372 93.496 413.692C93.848 414.012 94.12 414.396 94.312 414.844C94.504 415.26 94.6 415.628 94.6 415.948C94.6 416.492 94.248 417.084 93.544 417.724C92.872 418.332 91.896 418.86 90.616 419.308C89.368 419.724 87.88 419.932 86.152 419.932ZM80.728 406.06H87.736C88.28 406.06 88.648 405.98 88.84 405.82C89.064 405.628 89.176 405.276 89.176 404.764C89.176 404.028 88.968 403.372 88.552 402.796C88.168 402.22 87.656 401.772 87.016 401.452C86.408 401.132 85.72 400.972 84.952 400.972C84.216 400.972 83.528 401.132 82.888 401.452C82.248 401.74 81.72 402.172 81.304 402.748C80.92 403.292 80.728 403.948 80.728 404.716V406.06ZM103.593 419.932C101.897 419.932 100.425 419.42 99.1769 418.396C97.9609 417.34 97.3529 415.724 97.3529 413.548C97.3529 411.724 97.8169 410.3 98.7449 409.276C99.7049 408.252 101.017 407.532 102.681 407.116C104.377 406.7 106.329 406.492 108.537 406.492H110.505V405.868C110.505 405.164 110.361 404.476 110.073 403.804C109.817 403.132 109.385 402.572 108.777 402.124C108.201 401.676 107.369 401.452 106.281 401.452C105.065 401.452 104.121 401.58 103.449 401.836C102.809 402.06 102.313 402.3 101.961 402.556C101.609 402.812 101.225 402.94 100.809 402.94C100.137 402.94 99.6089 402.604 99.2249 401.932C98.8729 401.26 98.6969 400.572 98.6969 399.868C98.6969 399.196 99.0969 398.604 99.8969 398.092C100.729 397.548 101.737 397.132 102.921 396.844C104.105 396.556 105.257 396.412 106.377 396.412C108.873 396.412 110.873 396.86 112.377 397.756C113.881 398.652 114.969 399.804 115.641 401.212C116.345 402.62 116.697 404.14 116.697 405.772V417.484C116.697 418.06 116.409 418.54 115.833 418.924C115.257 419.308 114.537 419.5 113.673 419.5C112.873 419.5 112.201 419.308 111.657 418.924C111.145 418.54 110.889 418.06 110.889 417.484V416.14C110.025 417.132 109.001 418.012 107.817 418.78C106.665 419.548 105.257 419.932 103.593 419.932ZM106.089 415.324C106.761 415.324 107.433 415.1 108.105 414.652C108.777 414.204 109.337 413.628 109.785 412.924C110.265 412.22 110.505 411.484 110.505 410.716V409.708H109.785C108.729 409.708 107.721 409.772 106.761 409.9C105.801 410.028 105.017 410.316 104.409 410.764C103.833 411.18 103.545 411.836 103.545 412.732C103.545 413.628 103.785 414.284 104.265 414.7C104.777 415.116 105.385 415.324 106.089 415.324ZM130.939 419.932C128.507 419.932 126.523 419.5 124.987 418.636C123.451 417.772 122.315 416.604 121.579 415.132C120.843 413.628 120.475 411.948 120.475 410.092V406.252C120.475 404.396 120.827 402.732 121.531 401.26C122.267 399.756 123.403 398.572 124.939 397.708C126.507 396.844 128.475 396.412 130.843 396.412C132.347 396.412 133.675 396.588 134.827 396.94C135.979 397.292 136.891 397.756 137.563 398.332C138.235 398.908 138.571 399.516 138.571 400.156C138.571 400.54 138.459 400.972 138.235 401.452C138.043 401.9 137.755 402.3 137.371 402.652C137.019 403.004 136.603 403.18 136.123 403.18C135.771 403.18 135.403 403.068 135.019 402.844C134.667 402.62 134.203 402.396 133.627 402.172C133.051 401.948 132.283 401.836 131.323 401.836C129.691 401.836 128.507 402.236 127.771 403.036C127.035 403.804 126.667 404.876 126.667 406.252V410.092C126.667 411.468 127.035 412.556 127.771 413.356C128.507 414.124 129.707 414.508 131.371 414.508C132.363 414.508 133.131 414.38 133.675 414.124C134.219 413.868 134.667 413.628 135.019 413.404C135.403 413.18 135.787 413.068 136.171 413.068C136.747 413.068 137.227 413.228 137.611 413.548C138.027 413.868 138.331 414.268 138.523 414.748C138.747 415.196 138.859 415.612 138.859 415.996C138.859 416.636 138.507 417.26 137.803 417.868C137.131 418.476 136.187 418.972 134.971 419.356C133.787 419.74 132.443 419.932 130.939 419.932ZM145.176 419.5C144.28 419.5 143.544 419.292 142.968 418.876C142.392 418.46 142.104 417.996 142.104 417.484V385.324C142.104 384.748 142.392 384.284 142.968 383.932C143.544 383.58 144.28 383.404 145.176 383.404C146.04 383.404 146.776 383.58 147.384 383.932C147.992 384.284 148.296 384.748 148.296 385.324V400.06C148.776 399.132 149.528 398.3 150.552 397.564C151.576 396.796 152.84 396.412 154.344 396.412C155.848 396.412 157.224 396.86 158.472 397.756C159.72 398.62 160.712 399.788 161.448 401.26C162.216 402.732 162.6 404.364 162.6 406.156V417.484C162.6 418.156 162.28 418.668 161.64 419.02C161 419.34 160.28 419.5 159.48 419.5C158.776 419.5 158.088 419.34 157.416 419.02C156.744 418.668 156.408 418.156 156.408 417.484V406.156C156.408 405.42 156.216 404.732 155.832 404.092C155.448 403.452 154.936 402.924 154.296 402.508C153.688 402.06 153 401.836 152.232 401.836C151.592 401.836 150.968 402.012 150.36 402.364C149.752 402.716 149.256 403.212 148.872 403.852C148.488 404.492 148.296 405.26 148.296 406.156V417.484C148.296 417.996 147.992 418.46 147.384 418.876C146.776 419.292 146.04 419.5 145.176 419.5ZM186.342 419.932C184.486 419.932 182.774 419.484 181.206 418.588C179.638 417.66 178.374 416.444 177.414 414.94C176.454 413.436 175.974 411.82 175.974 410.092V406.156C175.974 404.428 176.438 402.828 177.366 401.356C178.294 399.852 179.542 398.652 181.11 397.756C182.71 396.86 184.454 396.412 186.342 396.412C188.23 396.412 189.958 396.86 191.526 397.756C193.126 398.62 194.39 399.788 195.318 401.26C196.278 402.732 196.758 404.364 196.758 406.156V410.092C196.758 411.788 196.278 413.388 195.318 414.892C194.358 416.396 193.078 417.612 191.478 418.54C189.91 419.468 188.198 419.932 186.342 419.932ZM186.342 414.508C187.11 414.508 187.814 414.3 188.454 413.884C189.094 413.468 189.606 412.924 189.99 412.252C190.374 411.548 190.566 410.828 190.566 410.092V406.156C190.566 405.42 190.374 404.732 189.99 404.092C189.606 403.452 189.094 402.924 188.454 402.508C187.846 402.06 187.142 401.836 186.342 401.836C185.574 401.836 184.87 402.044 184.23 402.46C183.59 402.876 183.078 403.42 182.694 404.092C182.342 404.732 182.166 405.42 182.166 406.156V410.092C182.166 410.828 182.342 411.548 182.694 412.252C183.078 412.924 183.59 413.468 184.23 413.884C184.87 414.3 185.574 414.508 186.342 414.508ZM209.481 419.5C206.601 419.5 204.393 418.876 202.857 417.628C201.353 416.38 200.601 414.396 200.601 411.676V388.444C200.601 387.868 200.937 387.404 201.609 387.052C202.281 386.7 202.969 386.524 203.673 386.524C204.441 386.524 205.145 386.7 205.785 387.052C206.457 387.404 206.793 387.868 206.793 388.444V396.7H212.457C212.969 396.7 213.353 396.94 213.609 397.42C213.897 397.868 214.041 398.38 214.041 398.956C214.041 399.532 213.897 400.06 213.609 400.54C213.353 400.988 212.969 401.212 212.457 401.212H206.793V411.676C206.793 412.636 206.985 413.308 207.369 413.692C207.785 414.076 208.489 414.268 209.481 414.268H211.353C212.249 414.268 212.905 414.54 213.321 415.084C213.769 415.628 213.993 416.22 213.993 416.86C213.993 417.532 213.769 418.14 213.321 418.684C212.905 419.228 212.249 419.5 211.353 419.5H209.481ZM220.317 419.5C219.421 419.5 218.685 419.292 218.109 418.876C217.533 418.46 217.245 417.996 217.245 417.484V385.324C217.245 384.748 217.533 384.284 218.109 383.932C218.685 383.58 219.421 383.404 220.317 383.404C221.181 383.404 221.917 383.58 222.525 383.932C223.133 384.284 223.437 384.748 223.437 385.324V400.06C223.917 399.132 224.669 398.3 225.693 397.564C226.717 396.796 227.981 396.412 229.485 396.412C230.989 396.412 232.365 396.86 233.613 397.756C234.861 398.62 235.853 399.788 236.589 401.26C237.357 402.732 237.741 404.364 237.741 406.156V417.484C237.741 418.156 237.421 418.668 236.781 419.02C236.141 419.34 235.421 419.5 234.621 419.5C233.917 419.5 233.229 419.34 232.557 419.02C231.885 418.668 231.549 418.156 231.549 417.484V406.156C231.549 405.42 231.357 404.732 230.973 404.092C230.589 403.452 230.077 402.924 229.437 402.508C228.829 402.06 228.141 401.836 227.373 401.836C226.733 401.836 226.109 402.012 225.501 402.364C224.893 402.716 224.397 403.212 224.013 403.852C223.629 404.492 223.437 405.26 223.437 406.156V417.484C223.437 417.996 223.133 418.46 222.525 418.876C221.917 419.292 221.181 419.5 220.317 419.5ZM253.121 419.932C250.849 419.932 248.833 419.532 247.073 418.732C245.345 417.9 243.985 416.748 242.993 415.276C242.001 413.772 241.505 412.044 241.505 410.092V406.012C241.505 404.284 241.969 402.7 242.897 401.26C243.857 399.788 245.121 398.62 246.689 397.756C248.289 396.86 250.065 396.412 252.017 396.412C253.809 396.412 255.441 396.796 256.913 397.564C258.417 398.332 259.633 399.388 260.561 400.732C261.489 402.076 261.953 403.644 261.953 405.436C261.953 406.812 261.729 407.804 261.281 408.412C260.833 408.988 260.257 409.356 259.553 409.516C258.881 409.644 258.177 409.708 257.441 409.708H247.697V410.428C247.697 411.804 248.209 412.924 249.233 413.788C250.289 414.62 251.649 415.036 253.313 415.036C254.369 415.036 255.249 414.876 255.953 414.556C256.657 414.236 257.265 413.932 257.777 413.644C258.289 413.356 258.769 413.212 259.217 413.212C259.697 413.212 260.113 413.372 260.465 413.692C260.817 414.012 261.089 414.396 261.281 414.844C261.473 415.26 261.569 415.628 261.569 415.948C261.569 416.492 261.217 417.084 260.513 417.724C259.841 418.332 258.865 418.86 257.585 419.308C256.337 419.724 254.849 419.932 253.121 419.932ZM247.697 406.06H254.705C255.249 406.06 255.617 405.98 255.809 405.82C256.033 405.628 256.145 405.276 256.145 404.764C256.145 404.028 255.937 403.372 255.521 402.796C255.137 402.22 254.625 401.772 253.985 401.452C253.377 401.132 252.689 400.972 251.921 400.972C251.185 400.972 250.497 401.132 249.857 401.452C249.217 401.74 248.689 402.172 248.273 402.748C247.889 403.292 247.697 403.948 247.697 404.716V406.06ZM268.69 419.5C267.826 419.5 267.106 419.292 266.53 418.876C265.954 418.46 265.666 417.996 265.666 417.484V398.62C265.666 398.044 265.954 397.58 266.53 397.228C267.106 396.876 267.826 396.7 268.69 396.7C269.49 396.7 270.146 396.876 270.658 397.228C271.202 397.58 271.474 398.044 271.474 398.62V400.588C271.826 399.884 272.29 399.228 272.866 398.62C273.474 397.98 274.162 397.452 274.93 397.036C275.698 396.62 276.514 396.412 277.378 396.412H278.866C279.474 396.412 280.002 396.684 280.45 397.228C280.898 397.74 281.122 398.364 281.122 399.1C281.122 399.868 280.898 400.524 280.45 401.068C280.002 401.58 279.474 401.836 278.866 401.836H277.378C276.482 401.836 275.602 402.14 274.738 402.748C273.906 403.324 273.218 404.14 272.674 405.196C272.13 406.22 271.858 407.468 271.858 408.94V417.484C271.858 417.996 271.554 418.46 270.946 418.876C270.338 419.292 269.586 419.5 268.69 419.5ZM283.624 419.788C282.696 419.788 281.912 419.468 281.272 418.828C280.664 418.156 280.36 417.388 280.36 416.524C280.36 415.628 280.664 414.86 281.272 414.22C281.912 413.58 282.696 413.26 283.624 413.26C284.488 413.26 285.24 413.58 285.88 414.22C286.52 414.86 286.84 415.628 286.84 416.524C286.84 417.388 286.52 418.156 285.88 418.828C285.24 419.468 284.488 419.788 283.624 419.788Z\" fill=\"#578FFE\"/> <path d=\"M142.868 532.5C142.292 532.5 141.7 532.388 141.092 532.164C140.484 531.94 139.972 531.636 139.556 531.252C139.14 530.868 138.932 530.42 138.932 529.908C138.932 529.812 138.948 529.652 138.98 529.428L148.244 499.236C148.468 498.532 148.964 498.004 149.732 497.652C150.532 497.3 151.38 497.124 152.276 497.124C153.204 497.124 154.052 497.3 154.82 497.652C155.588 498.004 156.084 498.532 156.308 499.236L165.572 529.428C165.636 529.652 165.668 529.812 165.668 529.908C165.668 530.388 165.444 530.836 164.996 531.252C164.58 531.636 164.068 531.94 163.46 532.164C162.852 532.388 162.26 532.5 161.684 532.5C161.172 532.5 160.724 532.42 160.34 532.26C159.988 532.068 159.748 531.732 159.62 531.252L157.796 524.868H146.756L144.98 531.252C144.852 531.732 144.596 532.068 144.212 532.26C143.828 532.42 143.38 532.5 142.868 532.5ZM148.1 519.972H156.452L152.276 505.236L148.1 519.972ZM188.191 532.74C187.775 532.74 187.359 532.612 186.943 532.356C186.559 532.1 186.255 531.732 186.031 531.252L179.215 518.004H175.183V530.484C175.183 531.156 174.863 531.668 174.223 532.02C173.583 532.34 172.863 532.5 172.062 532.5C171.295 532.5 170.575 532.34 169.903 532.02C169.263 531.668 168.943 531.156 168.943 530.484V499.38C168.943 498.836 169.119 498.372 169.471 497.988C169.855 497.604 170.351 497.412 170.959 497.412H180.463C182.575 497.412 184.479 497.716 186.175 498.324C187.903 498.932 189.279 499.972 190.302 501.444C191.326 502.884 191.839 504.884 191.839 507.444C191.839 509.3 191.567 510.884 191.023 512.196C190.479 513.476 189.727 514.516 188.767 515.316C187.839 516.084 186.767 516.66 185.551 517.044L191.887 528.708C191.951 528.836 191.999 528.98 192.031 529.14C192.063 529.268 192.079 529.38 192.079 529.476C192.079 529.988 191.887 530.5 191.503 531.012C191.119 531.524 190.623 531.94 190.015 532.26C189.439 532.58 188.831 532.74 188.191 532.74ZM175.183 513.108H180.463C182.031 513.108 183.279 512.724 184.207 511.956C185.135 511.188 185.599 509.876 185.599 508.02C185.599 506.1 185.135 504.772 184.207 504.036C183.279 503.268 182.031 502.884 180.463 502.884H175.183V513.108ZM198.96 532.5C198.288 532.5 197.664 532.34 197.088 532.02C196.512 531.668 196.224 531.156 196.224 530.484V499.428C196.224 498.756 196.512 498.26 197.088 497.94C197.664 497.588 198.288 497.412 198.96 497.412H216.048C216.752 497.412 217.248 497.7 217.536 498.276C217.856 498.852 218.016 499.46 218.016 500.1C218.016 500.868 217.84 501.524 217.488 502.068C217.168 502.612 216.688 502.884 216.048 502.884H202.464V512.484H209.76C210.4 512.484 210.88 512.74 211.2 513.252C211.552 513.732 211.728 514.308 211.728 514.98C211.728 515.524 211.568 516.068 211.248 516.612C210.96 517.124 210.464 517.38 209.76 517.38H202.464V527.028H216.048C216.688 527.028 217.168 527.3 217.488 527.844C217.84 528.388 218.016 529.044 218.016 529.812C218.016 530.452 217.856 531.06 217.536 531.636C217.248 532.212 216.752 532.5 216.048 532.5H198.96ZM253.759 532.5C252.991 532.5 252.271 532.34 251.599 532.02C250.959 531.668 250.639 531.156 250.639 530.484V518.436C250.639 518.18 250.591 517.972 250.495 517.812L240.559 500.628C240.495 500.5 240.447 500.388 240.415 500.292C240.415 500.164 240.415 500.068 240.415 500.004C240.415 499.492 240.639 499.044 241.087 498.66C241.535 498.276 242.079 497.972 242.719 497.748C243.359 497.524 243.967 497.412 244.543 497.412C245.055 497.412 245.439 497.524 245.695 497.748C245.951 497.94 246.191 498.244 246.415 498.66L253.759 512.532L261.055 498.66C261.311 498.244 261.567 497.94 261.823 497.748C262.079 497.524 262.463 497.412 262.975 497.412C263.551 497.412 264.143 497.524 264.751 497.748C265.391 497.972 265.935 498.276 266.383 498.66C266.863 499.044 267.103 499.492 267.103 500.004C267.103 500.068 267.087 500.164 267.055 500.292C267.055 500.388 267.023 500.5 266.959 500.628L257.023 517.812C256.927 517.972 256.879 518.18 256.879 518.436V530.484C256.879 531.156 256.543 531.668 255.871 532.02C255.231 532.34 254.527 532.5 253.759 532.5ZM280.667 532.788C278.555 532.788 276.651 532.436 274.955 531.732C273.259 530.996 271.899 529.828 270.875 528.228C269.883 526.596 269.387 524.436 269.387 521.748V508.452C269.387 505.764 269.883 503.62 270.875 502.02C271.899 500.388 273.243 499.22 274.907 498.516C276.603 497.78 278.523 497.412 280.667 497.412C282.779 497.412 284.683 497.78 286.379 498.516C288.107 499.22 289.467 500.388 290.459 502.02C291.451 503.62 291.947 505.764 291.947 508.452V521.748C291.947 524.436 291.451 526.596 290.459 528.228C289.467 529.828 288.107 530.996 286.379 531.732C284.683 532.436 282.779 532.788 280.667 532.788ZM280.667 527.316C282.235 527.316 283.467 526.868 284.363 525.972C285.259 525.076 285.707 523.668 285.707 521.748V508.452C285.707 506.532 285.259 505.124 284.363 504.228C283.467 503.332 282.235 502.884 280.667 502.884C279.099 502.884 277.867 503.332 276.971 504.228C276.107 505.124 275.675 506.532 275.675 508.452V521.748C275.675 523.668 276.107 525.076 276.971 525.972C277.867 526.868 279.099 527.316 280.667 527.316ZM308.709 532.788C306.533 532.788 304.581 532.436 302.853 531.732C301.125 530.996 299.749 529.828 298.725 528.228C297.701 526.596 297.189 524.436 297.189 521.748V499.38C297.189 498.676 297.509 498.18 298.149 497.892C298.789 497.572 299.509 497.412 300.309 497.412C301.077 497.412 301.781 497.572 302.421 497.892C303.093 498.18 303.429 498.676 303.429 499.38V521.748C303.429 523.636 303.893 525.044 304.821 525.972C305.749 526.868 307.045 527.316 308.709 527.316C310.341 527.316 311.621 526.868 312.549 525.972C313.509 525.044 313.989 523.636 313.989 521.748V499.38C313.989 498.676 314.293 498.18 314.901 497.892C315.541 497.572 316.277 497.412 317.109 497.412C317.877 497.412 318.581 497.572 319.221 497.892C319.893 498.18 320.229 498.676 320.229 499.38V521.748C320.229 524.436 319.717 526.596 318.693 528.228C317.669 529.828 316.277 530.996 314.517 531.732C312.789 532.436 310.853 532.788 308.709 532.788ZM366.316 532.74C365.9 532.74 365.484 532.612 365.068 532.356C364.684 532.1 364.38 531.732 364.156 531.252L357.34 518.004H353.308V530.484C353.308 531.156 352.988 531.668 352.348 532.02C351.708 532.34 350.988 532.5 350.188 532.5C349.42 532.5 348.7 532.34 348.028 532.02C347.388 531.668 347.068 531.156 347.068 530.484V499.38C347.068 498.836 347.244 498.372 347.596 497.988C347.98 497.604 348.476 497.412 349.084 497.412H358.588C360.7 497.412 362.604 497.716 364.3 498.324C366.028 498.932 367.404 499.972 368.427 501.444C369.451 502.884 369.964 504.884 369.964 507.444C369.964 509.3 369.692 510.884 369.148 512.196C368.604 513.476 367.852 514.516 366.892 515.316C365.964 516.084 364.892 516.66 363.676 517.044L370.012 528.708C370.076 528.836 370.124 528.98 370.156 529.14C370.188 529.268 370.204 529.38 370.204 529.476C370.204 529.988 370.012 530.5 369.628 531.012C369.244 531.524 368.748 531.94 368.14 532.26C367.564 532.58 366.956 532.74 366.316 532.74ZM353.308 513.108H358.588C360.156 513.108 361.404 512.724 362.332 511.956C363.26 511.188 363.724 509.876 363.724 508.02C363.724 506.1 363.26 504.772 362.332 504.036C361.404 503.268 360.156 502.884 358.588 502.884H353.308V513.108ZM377.085 532.5C376.413 532.5 375.789 532.34 375.213 532.02C374.637 531.668 374.349 531.156 374.349 530.484V499.428C374.349 498.756 374.637 498.26 375.213 497.94C375.789 497.588 376.413 497.412 377.085 497.412H394.173C394.877 497.412 395.373 497.7 395.661 498.276C395.981 498.852 396.141 499.46 396.141 500.1C396.141 500.868 395.965 501.524 395.613 502.068C395.293 502.612 394.813 502.884 394.173 502.884H380.589V512.484H387.885C388.525 512.484 389.005 512.74 389.325 513.252C389.677 513.732 389.853 514.308 389.853 514.98C389.853 515.524 389.693 516.068 389.373 516.612C389.085 517.124 388.589 517.38 387.885 517.38H380.589V527.028H394.173C394.813 527.028 395.293 527.3 395.613 527.844C395.965 528.388 396.141 529.044 396.141 529.812C396.141 530.452 395.981 531.06 395.661 531.636C395.373 532.212 394.877 532.5 394.173 532.5H377.085ZM401.29 532.5C400.714 532.5 400.122 532.388 399.514 532.164C398.906 531.94 398.394 531.636 397.978 531.252C397.562 530.868 397.354 530.42 397.354 529.908C397.354 529.812 397.37 529.652 397.402 529.428L406.666 499.236C406.89 498.532 407.386 498.004 408.154 497.652C408.954 497.3 409.802 497.124 410.698 497.124C411.626 497.124 412.474 497.3 413.242 497.652C414.01 498.004 414.506 498.532 414.73 499.236L423.994 529.428C424.058 529.652 424.09 529.812 424.09 529.908C424.09 530.388 423.866 530.836 423.418 531.252C423.002 531.636 422.49 531.94 421.882 532.164C421.274 532.388 420.682 532.5 420.106 532.5C419.594 532.5 419.146 532.42 418.762 532.26C418.41 532.068 418.17 531.732 418.042 531.252L416.218 524.868H405.178L403.402 531.252C403.274 531.732 403.018 532.068 402.634 532.26C402.25 532.42 401.802 532.5 401.29 532.5ZM406.522 519.972H414.874L410.698 505.236L406.522 519.972ZM430.1 532.5C429.268 532.5 428.596 532.308 428.084 531.924C427.604 531.54 427.364 531.076 427.364 530.532V499.38C427.364 498.836 427.604 498.372 428.084 497.988C428.596 497.604 429.268 497.412 430.1 497.412H438.596C440.74 497.412 442.66 497.78 444.356 498.516C446.052 499.22 447.396 500.388 448.388 502.02C449.412 503.62 449.924 505.764 449.924 508.452V521.46C449.924 524.148 449.412 526.308 448.388 527.94C447.396 529.54 446.052 530.708 444.356 531.444C442.66 532.148 440.74 532.5 438.596 532.5H430.1ZM433.604 527.028H438.596C440.196 527.028 441.444 526.58 442.34 525.684C443.236 524.756 443.684 523.348 443.684 521.46V508.452C443.684 506.564 443.236 505.172 442.34 504.276C441.444 503.348 440.212 502.884 438.644 502.884H433.604V527.028ZM465.494 532.5C464.726 532.5 464.006 532.34 463.334 532.02C462.694 531.668 462.374 531.156 462.374 530.484V518.436C462.374 518.18 462.326 517.972 462.23 517.812L452.294 500.628C452.23 500.5 452.182 500.388 452.15 500.292C452.15 500.164 452.15 500.068 452.15 500.004C452.15 499.492 452.374 499.044 452.822 498.66C453.27 498.276 453.814 497.972 454.454 497.748C455.094 497.524 455.702 497.412 456.278 497.412C456.79 497.412 457.174 497.524 457.43 497.748C457.686 497.94 457.926 498.244 458.15 498.66L465.494 512.532L472.79 498.66C473.046 498.244 473.302 497.94 473.558 497.748C473.814 497.524 474.198 497.412 474.71 497.412C475.286 497.412 475.878 497.524 476.486 497.748C477.126 497.972 477.67 498.276 478.118 498.66C478.598 499.044 478.838 499.492 478.838 500.004C478.838 500.068 478.822 500.164 478.79 500.292C478.79 500.388 478.758 500.5 478.694 500.628L468.758 517.812C468.662 517.972 468.614 518.18 468.614 518.436V530.484C468.614 531.156 468.278 531.668 467.606 532.02C466.966 532.34 466.262 532.5 465.494 532.5ZM513.045 532.5C512.245 532.5 511.525 532.34 510.885 532.02C510.245 531.668 509.925 531.156 509.925 530.484V503.028H502.869C502.261 503.028 501.781 502.74 501.429 502.164C501.077 501.588 500.901 500.932 500.901 500.196C500.901 499.524 501.061 498.9 501.381 498.324C501.701 497.716 502.197 497.412 502.869 497.412H523.173C523.877 497.412 524.373 497.716 524.661 498.324C524.981 498.9 525.141 499.524 525.141 500.196C525.141 500.932 524.965 501.588 524.613 502.164C524.293 502.74 523.813 503.028 523.173 503.028H516.165V530.484C516.165 531.156 515.829 531.668 515.157 532.02C514.517 532.34 513.813 532.5 513.045 532.5ZM538.714 532.788C536.602 532.788 534.698 532.436 533.002 531.732C531.306 530.996 529.946 529.828 528.922 528.228C527.93 526.596 527.434 524.436 527.434 521.748V508.452C527.434 505.764 527.93 503.62 528.922 502.02C529.946 500.388 531.29 499.22 532.954 498.516C534.65 497.78 536.57 497.412 538.714 497.412C540.826 497.412 542.73 497.78 544.426 498.516C546.154 499.22 547.514 500.388 548.506 502.02C549.498 503.62 549.994 505.764 549.994 508.452V521.748C549.994 524.436 549.498 526.596 548.506 528.228C547.514 529.828 546.154 530.996 544.426 531.732C542.73 532.436 540.826 532.788 538.714 532.788ZM538.714 527.316C540.282 527.316 541.514 526.868 542.41 525.972C543.306 525.076 543.754 523.668 543.754 521.748V508.452C543.754 506.532 543.306 505.124 542.41 504.228C541.514 503.332 540.282 502.884 538.714 502.884C537.146 502.884 535.914 503.332 535.018 504.228C534.154 505.124 533.722 506.532 533.722 508.452V521.748C533.722 523.668 534.154 525.076 535.018 525.972C535.914 526.868 537.146 527.316 538.714 527.316ZM144.5 593.5C143.732 593.5 143.012 593.34 142.34 593.02C141.7 592.668 141.38 592.156 141.38 591.484V560.38C141.38 559.836 141.604 559.372 142.052 558.988C142.5 558.604 143.076 558.412 143.78 558.412H153.38C155.428 558.412 157.268 558.764 158.9 559.468C160.564 560.172 161.876 561.324 162.836 562.924C163.796 564.492 164.276 566.588 164.276 569.212V569.5C164.276 572.124 163.78 574.236 162.788 575.836C161.796 577.436 160.436 578.604 158.708 579.34C157.012 580.044 155.108 580.396 152.996 580.396H147.62V591.484C147.62 592.156 147.3 592.668 146.66 593.02C146.02 593.34 145.3 593.5 144.5 593.5ZM147.62 575.5H152.996C154.596 575.5 155.828 575.052 156.692 574.156C157.588 573.228 158.036 571.836 158.036 569.98V569.452C158.036 567.564 157.588 566.172 156.692 565.276C155.828 564.348 154.596 563.884 152.996 563.884H147.62V575.5ZM170.835 593.5C170.163 593.5 169.539 593.34 168.963 593.02C168.387 592.668 168.099 592.156 168.099 591.484V560.38C168.099 559.676 168.419 559.18 169.059 558.892C169.731 558.572 170.451 558.412 171.219 558.412C172.019 558.412 172.739 558.572 173.379 558.892C174.019 559.18 174.339 559.676 174.339 560.38V588.028H186.099C186.739 588.028 187.203 588.316 187.491 588.892C187.779 589.436 187.923 590.06 187.923 590.764C187.923 591.436 187.779 592.06 187.491 592.636C187.203 593.212 186.739 593.5 186.099 593.5H170.835ZM192.79 593.5C192.214 593.5 191.622 593.388 191.014 593.164C190.406 592.94 189.894 592.636 189.478 592.252C189.062 591.868 188.854 591.42 188.854 590.908C188.854 590.812 188.87 590.652 188.902 590.428L198.166 560.236C198.39 559.532 198.886 559.004 199.654 558.652C200.454 558.3 201.302 558.124 202.198 558.124C203.126 558.124 203.974 558.3 204.742 558.652C205.51 559.004 206.006 559.532 206.23 560.236L215.494 590.428C215.558 590.652 215.59 590.812 215.59 590.908C215.59 591.388 215.366 591.836 214.918 592.252C214.502 592.636 213.99 592.94 213.382 593.164C212.774 593.388 212.182 593.5 211.606 593.5C211.094 593.5 210.646 593.42 210.262 593.26C209.91 593.068 209.67 592.732 209.542 592.252L207.718 585.868H196.678L194.902 592.252C194.774 592.732 194.518 593.068 194.134 593.26C193.75 593.42 193.302 593.5 192.79 593.5ZM198.022 580.972H206.374L202.198 566.236L198.022 580.972ZM226.666 593.5C225.898 593.5 225.178 593.34 224.506 593.02C223.866 592.668 223.546 592.156 223.546 591.484V579.436C223.546 579.18 223.498 578.972 223.402 578.812L213.466 561.628C213.402 561.5 213.354 561.388 213.322 561.292C213.322 561.164 213.322 561.068 213.322 561.004C213.322 560.492 213.546 560.044 213.994 559.66C214.442 559.276 214.986 558.972 215.626 558.748C216.266 558.524 216.874 558.412 217.45 558.412C217.962 558.412 218.346 558.524 218.602 558.748C218.858 558.94 219.098 559.244 219.322 559.66L226.666 573.532L233.962 559.66C234.218 559.244 234.474 558.94 234.73 558.748C234.986 558.524 235.37 558.412 235.882 558.412C236.458 558.412 237.05 558.524 237.658 558.748C238.298 558.972 238.842 559.276 239.29 559.66C239.77 560.044 240.01 560.492 240.01 561.004C240.01 561.068 239.994 561.164 239.962 561.292C239.962 561.388 239.93 561.5 239.866 561.628L229.93 578.812C229.834 578.972 229.786 579.18 229.786 579.436V591.484C229.786 592.156 229.45 592.668 228.778 593.02C228.138 593.34 227.434 593.5 226.666 593.5ZM263.744 593.5C262.976 593.5 262.256 593.34 261.584 593.02C260.944 592.668 260.624 592.156 260.624 591.484V579.436C260.624 579.18 260.576 578.972 260.48 578.812L250.544 561.628C250.48 561.5 250.432 561.388 250.4 561.292C250.4 561.164 250.4 561.068 250.4 561.004C250.4 560.492 250.624 560.044 251.072 559.66C251.52 559.276 252.064 558.972 252.704 558.748C253.344 558.524 253.952 558.412 254.528 558.412C255.04 558.412 255.424 558.524 255.68 558.748C255.936 558.94 256.176 559.244 256.4 559.66L263.744 573.532L271.04 559.66C271.296 559.244 271.552 558.94 271.808 558.748C272.064 558.524 272.448 558.412 272.96 558.412C273.536 558.412 274.128 558.524 274.736 558.748C275.376 558.972 275.92 559.276 276.368 559.66C276.848 560.044 277.088 560.492 277.088 561.004C277.088 561.068 277.072 561.164 277.04 561.292C277.04 561.388 277.008 561.5 276.944 561.628L267.008 578.812C266.912 578.972 266.864 579.18 266.864 579.436V591.484C266.864 592.156 266.528 592.668 265.856 593.02C265.216 593.34 264.512 593.5 263.744 593.5ZM290.651 593.788C288.539 593.788 286.635 593.436 284.939 592.732C283.243 591.996 281.883 590.828 280.859 589.228C279.867 587.596 279.371 585.436 279.371 582.748V569.452C279.371 566.764 279.867 564.62 280.859 563.02C281.883 561.388 283.227 560.22 284.891 559.516C286.587 558.78 288.507 558.412 290.651 558.412C292.763 558.412 294.667 558.78 296.363 559.516C298.091 560.22 299.451 561.388 300.443 563.02C301.435 564.62 301.931 566.764 301.931 569.452V582.748C301.931 585.436 301.435 587.596 300.443 589.228C299.451 590.828 298.091 591.996 296.363 592.732C294.667 593.436 292.763 593.788 290.651 593.788ZM290.651 588.316C292.219 588.316 293.451 587.868 294.347 586.972C295.243 586.076 295.691 584.668 295.691 582.748V569.452C295.691 567.532 295.243 566.124 294.347 565.228C293.451 564.332 292.219 563.884 290.651 563.884C289.083 563.884 287.851 564.332 286.955 565.228C286.091 566.124 285.659 567.532 285.659 569.452V582.748C285.659 584.668 286.091 586.076 286.955 586.972C287.851 587.868 289.083 588.316 290.651 588.316ZM318.694 593.788C316.518 593.788 314.566 593.436 312.838 592.732C311.11 591.996 309.734 590.828 308.71 589.228C307.686 587.596 307.174 585.436 307.174 582.748V560.38C307.174 559.676 307.494 559.18 308.134 558.892C308.774 558.572 309.494 558.412 310.294 558.412C311.062 558.412 311.766 558.572 312.406 558.892C313.078 559.18 313.414 559.676 313.414 560.38V582.748C313.414 584.636 313.878 586.044 314.806 586.972C315.734 587.868 317.03 588.316 318.694 588.316C320.326 588.316 321.606 587.868 322.534 586.972C323.494 586.044 323.974 584.636 323.974 582.748V560.38C323.974 559.676 324.278 559.18 324.886 558.892C325.526 558.572 326.262 558.412 327.094 558.412C327.862 558.412 328.566 558.572 329.206 558.892C329.878 559.18 330.214 559.676 330.214 560.38V582.748C330.214 585.436 329.701 587.596 328.677 589.228C327.654 590.828 326.262 591.996 324.502 592.732C322.774 593.436 320.838 593.788 318.694 593.788ZM355.066 593.74C354.65 593.74 354.234 593.612 353.818 593.356C353.434 593.1 353.13 592.732 352.906 592.252L346.09 579.004H342.058V591.484C342.058 592.156 341.738 592.668 341.098 593.02C340.458 593.34 339.738 593.5 338.938 593.5C338.17 593.5 337.45 593.34 336.778 593.02C336.138 592.668 335.818 592.156 335.818 591.484V560.38C335.818 559.836 335.994 559.372 336.346 558.988C336.73 558.604 337.226 558.412 337.834 558.412H347.338C349.45 558.412 351.354 558.716 353.05 559.324C354.778 559.932 356.154 560.972 357.177 562.444C358.201 563.884 358.714 565.884 358.714 568.444C358.714 570.3 358.442 571.884 357.898 573.196C357.354 574.476 356.602 575.516 355.642 576.316C354.714 577.084 353.642 577.66 352.426 578.044L358.762 589.708C358.826 589.836 358.874 589.98 358.906 590.14C358.938 590.268 358.954 590.38 358.954 590.476C358.954 590.988 358.762 591.5 358.378 592.012C357.994 592.524 357.498 592.94 356.89 593.26C356.314 593.58 355.706 593.74 355.066 593.74ZM342.058 574.108H347.338C348.906 574.108 350.154 573.724 351.082 572.956C352.01 572.188 352.474 570.876 352.474 569.02C352.474 567.1 352.01 565.772 351.082 565.036C350.154 564.268 348.906 563.884 347.338 563.884H342.058V574.108ZM375.828 593.5C375.06 593.5 374.34 593.34 373.668 593.02C373.028 592.668 372.708 592.156 372.708 591.484V560.38C372.708 559.836 372.932 559.372 373.38 558.988C373.828 558.604 374.404 558.412 375.108 558.412H384.708C386.756 558.412 388.596 558.764 390.228 559.468C391.892 560.172 393.204 561.324 394.164 562.924C395.124 564.492 395.604 566.588 395.604 569.212V569.5C395.604 572.124 395.108 574.236 394.116 575.836C393.124 577.436 391.764 578.604 390.036 579.34C388.34 580.044 386.436 580.396 384.324 580.396H378.948V591.484C378.948 592.156 378.628 592.668 377.988 593.02C377.348 593.34 376.628 593.5 375.828 593.5ZM378.948 575.5H384.324C385.924 575.5 387.156 575.052 388.02 574.156C388.916 573.228 389.364 571.836 389.364 569.98V569.452C389.364 567.564 388.916 566.172 388.02 565.276C387.156 564.348 385.924 563.884 384.324 563.884H378.948V575.5ZM399.087 593.5C398.511 593.5 397.919 593.388 397.311 593.164C396.703 592.94 396.191 592.636 395.775 592.252C395.359 591.868 395.151 591.42 395.151 590.908C395.151 590.812 395.167 590.652 395.199 590.428L404.463 560.236C404.687 559.532 405.183 559.004 405.951 558.652C406.751 558.3 407.599 558.124 408.495 558.124C409.423 558.124 410.271 558.3 411.039 558.652C411.807 559.004 412.303 559.532 412.527 560.236L421.791 590.428C421.855 590.652 421.887 590.812 421.887 590.908C421.887 591.388 421.663 591.836 421.215 592.252C420.799 592.636 420.287 592.94 419.679 593.164C419.071 593.388 418.479 593.5 417.903 593.5C417.391 593.5 416.943 593.42 416.559 593.26C416.207 593.068 415.967 592.732 415.839 592.252L414.015 585.868H402.975L401.199 592.252C401.071 592.732 400.815 593.068 400.431 593.26C400.047 593.42 399.599 593.5 399.087 593.5ZM404.319 580.972H412.671L408.495 566.236L404.319 580.972ZM444.409 593.74C443.993 593.74 443.577 593.612 443.161 593.356C442.777 593.1 442.473 592.732 442.249 592.252L435.433 579.004H431.401V591.484C431.401 592.156 431.081 592.668 430.441 593.02C429.801 593.34 429.081 593.5 428.281 593.5C427.513 593.5 426.793 593.34 426.121 593.02C425.481 592.668 425.161 592.156 425.161 591.484V560.38C425.161 559.836 425.337 559.372 425.689 558.988C426.073 558.604 426.569 558.412 427.177 558.412H436.681C438.793 558.412 440.697 558.716 442.393 559.324C444.121 559.932 445.497 560.972 446.521 562.444C447.545 563.884 448.057 565.884 448.057 568.444C448.057 570.3 447.785 571.884 447.241 573.196C446.697 574.476 445.945 575.516 444.985 576.316C444.057 577.084 442.985 577.66 441.769 578.044L448.105 589.708C448.169 589.836 448.217 589.98 448.249 590.14C448.281 590.268 448.297 590.38 448.297 590.476C448.297 590.988 448.105 591.5 447.721 592.012C447.337 592.524 446.841 592.94 446.233 593.26C445.657 593.58 445.049 593.74 444.409 593.74ZM431.401 574.108H436.681C438.249 574.108 439.497 573.724 440.425 572.956C441.353 572.188 441.817 570.876 441.817 569.02C441.817 567.1 441.353 565.772 440.425 565.036C439.497 564.268 438.249 563.884 436.681 563.884H431.401V574.108ZM461.717 593.5C460.917 593.5 460.197 593.34 459.557 593.02C458.917 592.668 458.597 592.156 458.597 591.484V564.028H451.541C450.933 564.028 450.453 563.74 450.101 563.164C449.749 562.588 449.573 561.932 449.573 561.196C449.573 560.524 449.733 559.9 450.053 559.324C450.373 558.716 450.869 558.412 451.541 558.412H471.845C472.549 558.412 473.045 558.716 473.333 559.324C473.653 559.9 473.813 560.524 473.813 561.196C473.813 561.932 473.637 562.588 473.285 563.164C472.965 563.74 472.485 564.028 471.845 564.028H464.837V591.484C464.837 592.156 464.501 592.668 463.829 593.02C463.189 593.34 462.485 593.5 461.717 593.5ZM483.578 583.804C482.746 583.804 482.154 583.612 481.802 583.228C481.482 582.844 481.322 582.14 481.322 581.116C481.322 579.612 481.466 578.38 481.754 577.42C482.042 576.46 482.41 575.676 482.858 575.068C483.338 574.428 483.786 573.916 484.202 573.532C484.618 573.116 485.098 572.7 485.642 572.284C486.186 571.868 486.698 571.404 487.178 570.892C487.69 570.38 488.106 569.804 488.426 569.164C488.746 568.524 488.906 567.804 488.906 567.004C488.906 565.628 488.442 564.604 487.514 563.932C486.618 563.228 485.434 562.876 483.962 562.876C482.81 562.876 481.914 563.052 481.274 563.404C480.666 563.724 480.202 564.108 479.882 564.556C479.562 565.004 479.242 565.388 478.922 565.708C478.634 566.028 478.218 566.188 477.674 566.188C477.162 566.188 476.634 565.996 476.09 565.612C475.546 565.228 475.274 564.652 475.274 563.884C475.274 563.116 475.61 562.3 476.282 561.436C476.954 560.54 477.946 559.788 479.258 559.18C480.57 558.54 482.202 558.22 484.154 558.22C486.17 558.22 487.914 558.588 489.386 559.324C490.89 560.028 492.042 560.988 492.842 562.204C493.642 563.42 494.042 564.796 494.042 566.332C494.042 567.548 493.818 568.668 493.37 569.692C492.922 570.684 492.378 571.58 491.738 572.38C491.098 573.18 490.458 573.852 489.818 574.396C489.178 574.94 488.682 575.388 488.33 575.74C487.562 576.348 487.002 576.972 486.65 577.612C486.33 578.252 486.138 578.924 486.074 579.628C486.01 580.332 485.978 581.148 485.978 582.076C485.978 582.492 485.818 582.892 485.498 583.276C485.178 583.628 484.538 583.804 483.578 583.804ZM483.578 593.788C482.682 593.788 481.914 593.468 481.274 592.828C480.666 592.156 480.362 591.388 480.362 590.524C480.362 589.628 480.682 588.86 481.322 588.22C481.962 587.58 482.714 587.26 483.578 587.26C484.506 587.26 485.274 587.58 485.882 588.22C486.522 588.86 486.842 589.628 486.842 590.524C486.842 591.388 486.522 592.156 485.882 592.828C485.274 593.468 484.506 593.788 483.578 593.788Z\" fill=\"#578FFE\"/> <rect x=\"0.5\" y=\"1\" width=\"690\" height=\"689\" rx=\"49.5\" stroke=\"black\"/> </g> <defs> <filter id=\"filter0_d_838_971\" x=\"0\" y=\"0.5\" width=\"701\" height=\"700\" filterUnits=\"userSpaceOnUse\" color-interpolation-filters=\"sRGB\"> <feFlood flood-opacity=\"0\" result=\"BackgroundImageFix\"/> <feColorMatrix in=\"SourceAlpha\" type=\"matrix\" values=\"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0\" result=\"hardAlpha\"/> <feOffset dx=\"10\" dy=\"10\"/> <feComposite in2=\"hardAlpha\" operator=\"out\"/> <feColorMatrix type=\"matrix\" values=\"0 0 0 0 1 0 0 0 0 0 0 0 0 0 0.509804 0 0 0 1 0\"/> <feBlend mode=\"normal\" in2=\"BackgroundImageFix\" result=\"effect1_dropShadow_838_971\"/> <feBlend mode=\"normal\" in=\"SourceGraphic\" in2=\"effect1_dropShadow_838_971\" result=\"shape\"/> </filter> </defs> </svg>") // EJsS HtmlView.HtmlView Page: setting property 'Html' for element 'gameStart'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"startBtn", _view.gameStart) // EJsS HtmlView.HtmlView Page: declaration of element 'startBtn'
      .setProperty("ClassName","position-absolute") // EJsS HtmlView.HtmlView Page: setting property 'ClassName' for element 'startBtn'
      .setProperty("Html","<svg width=\"75\" height=\"31\" viewBox=\"0 0 75 31\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"> <g filter=\"url(#filter0_d_863_9985)\"> <path d=\"M0 0H63C68.5229 0 73 4.47715 73 10V29H10C4.47715 29 0 24.5228 0 19V0Z\" fill=\"#FDFAF1\"/> <path d=\"M12.5788 20.126C11.9721 20.126 11.4215 20.0373 10.9268 19.86C10.4415 19.6827 10.0541 19.4633 9.76479 19.202C9.48479 18.9313 9.34479 18.6607 9.34479 18.39C9.34479 18.2593 9.37746 18.1193 9.44279 17.97C9.51746 17.8113 9.61546 17.6807 9.73679 17.578C9.85812 17.466 9.99346 17.41 10.1428 17.41C10.2921 17.41 10.4321 17.466 10.5628 17.578C10.6935 17.6807 10.8428 17.8067 11.0108 17.956C11.1788 18.096 11.3841 18.222 11.6268 18.334C11.8695 18.4367 12.1681 18.488 12.5228 18.488C12.8028 18.488 13.0595 18.446 13.2928 18.362C13.5355 18.2687 13.7268 18.1333 13.8668 17.956C14.0161 17.7787 14.0908 17.55 14.0908 17.27C14.0908 16.9713 14.0115 16.7193 13.8528 16.514C13.6941 16.3087 13.4795 16.1313 13.2088 15.982C12.9381 15.8327 12.6441 15.688 12.3268 15.548C12.0095 15.408 11.6875 15.2587 11.3608 15.1C11.0435 14.9413 10.7495 14.75 10.4788 14.526C10.2175 14.302 10.0028 14.0267 9.83479 13.7C9.67612 13.3733 9.59679 12.972 9.59679 12.496C9.59679 11.9733 9.69479 11.5347 9.89079 11.18C10.0961 10.8253 10.3621 10.5407 10.6888 10.326C11.0248 10.102 11.3935 9.94333 11.7948 9.85C12.1961 9.74733 12.5975 9.696 12.9988 9.696C13.2135 9.696 13.4655 9.71467 13.7548 9.752C14.0535 9.78 14.3475 9.836 14.6368 9.92C14.9355 10.004 15.1781 10.1207 15.3648 10.27C15.5608 10.41 15.6588 10.5967 15.6588 10.83C15.6588 10.9327 15.6308 11.0587 15.5748 11.208C15.5281 11.3573 15.4488 11.4927 15.3368 11.614C15.2341 11.7353 15.0988 11.796 14.9308 11.796C14.7815 11.796 14.6321 11.754 14.4828 11.67C14.3428 11.5767 14.1561 11.488 13.9228 11.404C13.6988 11.3107 13.3908 11.264 12.9988 11.264C12.6721 11.264 12.3875 11.306 12.1448 11.39C11.9021 11.474 11.7201 11.5953 11.5988 11.754C11.4775 11.9033 11.4168 12.0947 11.4168 12.328C11.4168 12.5707 11.4961 12.776 11.6548 12.944C11.8228 13.112 12.0375 13.2613 12.2988 13.392C12.5695 13.5227 12.8635 13.6533 13.1808 13.784C13.4981 13.9147 13.8155 14.0687 14.1328 14.246C14.4595 14.414 14.7581 14.6193 15.0288 14.862C15.2995 15.1047 15.5141 15.408 15.6728 15.772C15.8315 16.1267 15.9108 16.5653 15.9108 17.088C15.9108 17.7507 15.7661 18.3107 15.4768 18.768C15.1875 19.216 14.7908 19.5567 14.2868 19.79C13.7921 20.014 13.2228 20.126 12.5788 20.126ZM19.9776 20C19.7442 20 19.5342 19.9533 19.3476 19.86C19.1609 19.7573 19.0676 19.608 19.0676 19.412V11.404H17.0096C16.8322 11.404 16.6922 11.32 16.5896 11.152C16.4869 10.984 16.4356 10.7927 16.4356 10.578C16.4356 10.382 16.4822 10.2 16.5756 10.032C16.6689 9.85467 16.8136 9.766 17.0096 9.766H22.9316C23.1369 9.766 23.2816 9.85467 23.3656 10.032C23.4589 10.2 23.5056 10.382 23.5056 10.578C23.5056 10.7927 23.4542 10.984 23.3516 11.152C23.2582 11.32 23.1182 11.404 22.9316 11.404H20.8876V19.412C20.8876 19.608 20.7896 19.7573 20.5936 19.86C20.4069 19.9533 20.2016 20 19.9776 20ZM24.064 20C23.896 20 23.7234 19.9673 23.546 19.902C23.3687 19.8367 23.2194 19.748 23.098 19.636C22.9767 19.524 22.916 19.3933 22.916 19.244C22.916 19.216 22.9207 19.1693 22.93 19.104L25.632 10.298C25.6974 10.0927 25.842 9.93867 26.066 9.836C26.2994 9.73333 26.5467 9.682 26.808 9.682C27.0787 9.682 27.326 9.73333 27.55 9.836C27.774 9.93867 27.9187 10.0927 27.984 10.298L30.686 19.104C30.7047 19.1693 30.714 19.216 30.714 19.244C30.714 19.384 30.6487 19.5147 30.518 19.636C30.3967 19.748 30.2474 19.8367 30.07 19.902C29.8927 19.9673 29.72 20 29.552 20C29.4027 20 29.272 19.9767 29.16 19.93C29.0574 19.874 28.9874 19.776 28.95 19.636L28.418 17.774H25.198L24.68 19.636C24.6427 19.776 24.568 19.874 24.456 19.93C24.344 19.9767 24.2134 20 24.064 20ZM25.59 16.346H28.026L26.808 12.048L25.59 16.346ZM37.2831 20.07C37.1618 20.07 37.0404 20.0327 36.9191 19.958C36.8071 19.8833 36.7184 19.776 36.6531 19.636L34.6651 15.772H33.4891V19.412C33.4891 19.608 33.3958 19.7573 33.2091 19.86C33.0224 19.9533 32.8124 20 32.5791 20C32.3551 20 32.1451 19.9533 31.9491 19.86C31.7624 19.7573 31.6691 19.608 31.6691 19.412V10.34C31.6691 10.1813 31.7204 10.046 31.8231 9.934C31.9351 9.822 32.0798 9.766 32.2571 9.766H35.0291C35.6451 9.766 36.2004 9.85467 36.6951 10.032C37.1991 10.2093 37.6004 10.5127 37.8991 10.942C38.1978 11.362 38.3471 11.9453 38.3471 12.692C38.3471 13.2333 38.2678 13.6953 38.1091 14.078C37.9504 14.4513 37.7311 14.7547 37.4511 14.988C37.1804 15.212 36.8678 15.38 36.5131 15.492L38.3611 18.894C38.3798 18.9313 38.3938 18.9733 38.4031 19.02C38.4124 19.0573 38.4171 19.09 38.4171 19.118C38.4171 19.2673 38.3611 19.4167 38.2491 19.566C38.1371 19.7153 37.9924 19.8367 37.8151 19.93C37.6471 20.0233 37.4698 20.07 37.2831 20.07ZM33.4891 14.344H35.0291C35.4864 14.344 35.8504 14.232 36.1211 14.008C36.3918 13.784 36.5271 13.4013 36.5271 12.86C36.5271 12.3 36.3918 11.9127 36.1211 11.698C35.8504 11.474 35.4864 11.362 35.0291 11.362H33.4891V14.344ZM42.3311 20C42.0978 20 41.8878 19.9533 41.7011 19.86C41.5144 19.7573 41.4211 19.608 41.4211 19.412V11.404H39.3631C39.1858 11.404 39.0458 11.32 38.9431 11.152C38.8404 10.984 38.7891 10.7927 38.7891 10.578C38.7891 10.382 38.8358 10.2 38.9291 10.032C39.0224 9.85467 39.1671 9.766 39.3631 9.766H45.2851C45.4904 9.766 45.6351 9.85467 45.7191 10.032C45.8124 10.2 45.8591 10.382 45.8591 10.578C45.8591 10.7927 45.8078 10.984 45.7051 11.152C45.6118 11.32 45.4718 11.404 45.2851 11.404H43.2411V19.412C43.2411 19.608 43.1431 19.7573 42.9471 19.86C42.7604 19.9533 42.5551 20 42.3311 20Z\" fill=\"#FF0082\"/> <path d=\"M52 14C52 12.1435 52.7375 10.363 54.0503 9.05025C55.363 7.7375 57.1435 7 59 7C59.9193 7 60.8295 7.18106 61.6788 7.53284C62.5281 7.88463 63.2997 8.40024 63.9497 9.05025C64.5998 9.70026 65.1154 10.4719 65.4672 11.3212C65.8189 12.1705 66 13.0807 66 14C66 15.8565 65.2625 17.637 63.9497 18.9497C62.637 20.2625 60.8565 21 59 21C58.0807 21 57.1705 20.8189 56.3212 20.4672C55.4719 20.1154 54.7003 19.5998 54.0503 18.9497C52.7375 17.637 52 15.8565 52 14ZM57.6 17.5L61.1 14L57.6 10.5V17.5Z\" fill=\"#FF0082\"/> <path d=\"M0.5 0.5H63C68.2467 0.5 72.5 4.75329 72.5 10V28.5H10C4.7533 28.5 0.5 24.2467 0.5 19V0.5Z\" stroke=\"#F7CFE5\"/> </g> <defs> <filter id=\"filter0_d_863_9985\" x=\"0\" y=\"0\" width=\"75\" height=\"31\" filterUnits=\"userSpaceOnUse\" color-interpolation-filters=\"sRGB\"> <feFlood flood-opacity=\"0\" result=\"BackgroundImageFix\"/> <feColorMatrix in=\"SourceAlpha\" type=\"matrix\" values=\"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0\" result=\"hardAlpha\"/> <feOffset dx=\"2\" dy=\"2\"/> <feComposite in2=\"hardAlpha\" operator=\"out\"/> <feColorMatrix type=\"matrix\" values=\"0 0 0 0 1 0 0 0 0 0 0 0 0 0 0.509804 0 0 0 1 0\"/> <feBlend mode=\"normal\" in2=\"BackgroundImageFix\" result=\"effect1_dropShadow_863_9985\"/> <feBlend mode=\"normal\" in=\"SourceGraphic\" in2=\"effect1_dropShadow_863_9985\" result=\"shape\"/> </filter> </defs> </svg>") // EJsS HtmlView.HtmlView Page: setting property 'Html' for element 'startBtn'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"gameIntroduction", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'gameIntroduction'
      .setProperty("ClassName","d-none") // EJsS HtmlView.HtmlView Page: setting property 'ClassName' for element 'gameIntroduction'
      .setProperty("Html","<svg width=\"701\" height=\"701\" viewBox=\"0 0 701 701\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"> <g id=\"gameIntroductionBtn\" filter=\"url(#filter0_d_838_977)\"> <rect width=\"691\" height=\"691\" rx=\"50\" fill=\"#F9E6E0\"/> <path d=\"M141.988 115C140.879 115 139.983 114.744 139.3 114.232C138.66 113.72 138.34 113.101 138.34 112.376V70.84C138.34 70.1147 138.66 69.496 139.3 68.984C139.983 68.472 140.879 68.216 141.988 68.216H153.316C156.175 68.216 158.735 68.7067 160.996 69.688C163.257 70.6267 165.049 72.184 166.372 74.36C167.737 76.4933 168.42 79.352 168.42 82.936V100.28C168.42 103.864 167.737 106.744 166.372 108.92C165.049 111.053 163.257 112.611 160.996 113.592C158.735 114.531 156.175 115 153.316 115H141.988ZM146.66 107.704H153.316C155.449 107.704 157.113 107.107 158.308 105.912C159.503 104.675 160.1 102.797 160.1 100.28V82.936C160.1 80.4187 159.503 78.5627 158.308 77.368C157.113 76.1307 155.471 75.512 153.38 75.512H146.66V107.704ZM179.688 115C178.664 115 177.704 114.787 176.808 114.36C175.954 113.891 175.528 113.208 175.528 112.312V70.84C175.528 69.9013 175.954 69.24 176.808 68.856C177.704 68.4293 178.664 68.216 179.688 68.216C180.754 68.216 181.714 68.4293 182.568 68.856C183.421 69.24 183.848 69.9013 183.848 70.84V112.312C183.848 113.208 183.421 113.891 182.568 114.36C181.714 114.787 180.754 115 179.688 115ZM195.238 115C194.129 115 193.233 114.744 192.55 114.232C191.91 113.72 191.59 113.101 191.59 112.376V70.84C191.59 70.1147 191.91 69.496 192.55 68.984C193.233 68.472 194.129 68.216 195.238 68.216H206.566C209.425 68.216 211.985 68.7067 214.246 69.688C216.507 70.6267 218.299 72.184 219.622 74.36C220.987 76.4933 221.67 79.352 221.67 82.936V100.28C221.67 103.864 220.987 106.744 219.622 108.92C218.299 111.053 216.507 112.611 214.246 113.592C211.985 114.531 209.425 115 206.566 115H195.238ZM199.91 107.704H206.566C208.699 107.704 210.363 107.107 211.558 105.912C212.753 104.675 213.35 102.797 213.35 100.28V82.936C213.35 80.4187 212.753 78.5627 211.558 77.368C210.363 76.1307 208.721 75.512 206.63 75.512H199.91V107.704ZM256.054 115C255.03 115 254.07 114.787 253.174 114.36C252.321 113.891 251.894 113.208 251.894 112.312V96.248C251.894 95.9067 251.83 95.6293 251.702 95.416L238.454 72.504C238.369 72.3333 238.305 72.184 238.262 72.056C238.262 71.8853 238.262 71.7573 238.262 71.672C238.262 70.9893 238.561 70.392 239.158 69.88C239.755 69.368 240.481 68.9627 241.334 68.664C242.187 68.3653 242.998 68.216 243.766 68.216C244.449 68.216 244.961 68.3653 245.302 68.664C245.643 68.92 245.963 69.3253 246.262 69.88L256.054 88.376L265.782 69.88C266.123 69.3253 266.465 68.92 266.806 68.664C267.147 68.3653 267.659 68.216 268.342 68.216C269.11 68.216 269.899 68.3653 270.71 68.664C271.563 68.9627 272.289 69.368 272.886 69.88C273.526 70.392 273.846 70.9893 273.846 71.672C273.846 71.7573 273.825 71.8853 273.782 72.056C273.782 72.184 273.739 72.3333 273.654 72.504L260.406 95.416C260.278 95.6293 260.214 95.9067 260.214 96.248V112.312C260.214 113.208 259.766 113.891 258.87 114.36C258.017 114.787 257.078 115 256.054 115ZM291.931 115.384C289.115 115.384 286.576 114.915 284.315 113.976C282.053 112.995 280.24 111.437 278.875 109.304C277.552 107.128 276.891 104.248 276.891 100.664V82.936C276.891 79.352 277.552 76.4933 278.875 74.36C280.24 72.184 282.032 70.6267 284.251 69.688C286.512 68.7067 289.072 68.216 291.931 68.216C294.747 68.216 297.285 68.7067 299.547 69.688C301.851 70.6267 303.664 72.184 304.987 74.36C306.309 76.4933 306.971 79.352 306.971 82.936V100.664C306.971 104.248 306.309 107.128 304.987 109.304C303.664 111.437 301.851 112.995 299.547 113.976C297.285 114.915 294.747 115.384 291.931 115.384ZM291.931 108.088C294.021 108.088 295.664 107.491 296.859 106.296C298.053 105.101 298.651 103.224 298.651 100.664V82.936C298.651 80.376 298.053 78.4987 296.859 77.304C295.664 76.1093 294.021 75.512 291.931 75.512C289.84 75.512 288.197 76.1093 287.003 77.304C285.851 78.4987 285.275 80.376 285.275 82.936V100.664C285.275 103.224 285.851 105.101 287.003 106.296C288.197 107.491 289.84 108.088 291.931 108.088ZM329.321 115.384C326.419 115.384 323.817 114.915 321.513 113.976C319.209 112.995 317.374 111.437 316.009 109.304C314.643 107.128 313.961 104.248 313.961 100.664V70.84C313.961 69.9013 314.387 69.24 315.241 68.856C316.094 68.4293 317.054 68.216 318.121 68.216C319.145 68.216 320.083 68.4293 320.937 68.856C321.833 69.24 322.281 69.9013 322.281 70.84V100.664C322.281 103.181 322.899 105.059 324.137 106.296C325.374 107.491 327.102 108.088 329.321 108.088C331.497 108.088 333.203 107.491 334.441 106.296C335.721 105.059 336.361 103.181 336.361 100.664V70.84C336.361 69.9013 336.766 69.24 337.577 68.856C338.43 68.4293 339.411 68.216 340.521 68.216C341.545 68.216 342.483 68.4293 343.337 68.856C344.233 69.24 344.681 69.9013 344.681 70.84V100.664C344.681 104.248 343.998 107.128 342.632 109.304C341.267 111.437 339.411 112.995 337.065 113.976C334.761 114.915 332.179 115.384 329.321 115.384ZM369.125 115C368.101 115 367.141 114.787 366.245 114.36C365.392 113.891 364.965 113.208 364.965 112.312V70.84C364.965 69.9013 365.392 69.24 366.245 68.856C367.141 68.4293 368.101 68.216 369.125 68.216C370.192 68.216 371.152 68.4293 372.005 68.856C372.858 69.24 373.285 69.9013 373.285 70.84V88.248L387.173 69.432C387.728 68.6213 388.474 68.216 389.413 68.216C390.138 68.216 390.864 68.4293 391.589 68.856C392.357 69.2827 392.997 69.816 393.509 70.456C394.021 71.096 394.277 71.7787 394.277 72.504C394.277 72.7173 394.234 72.9733 394.149 73.272C394.064 73.5707 393.914 73.848 393.701 74.104L382.309 88.44L396.261 109.688C396.56 110.157 396.709 110.648 396.709 111.16C396.709 111.843 396.453 112.504 395.941 113.144C395.472 113.784 394.853 114.317 394.085 114.744C393.317 115.128 392.528 115.32 391.717 115.32C391.12 115.32 390.565 115.192 390.053 114.936C389.584 114.68 389.157 114.275 388.773 113.72L376.741 95.48L373.285 99.832V112.312C373.285 113.208 372.858 113.891 372.005 114.36C371.152 114.787 370.192 115 369.125 115ZM404.5 115C403.476 115 402.516 114.787 401.62 114.36C400.767 113.891 400.34 113.208 400.34 112.312V70.84C400.34 69.944 400.767 69.2827 401.62 68.856C402.516 68.4293 403.476 68.216 404.5 68.216C405.524 68.216 406.356 68.3227 406.996 68.536C407.679 68.7493 408.297 69.176 408.852 69.816C409.449 70.4133 410.068 71.352 410.708 72.632L423.06 96.504V70.84C423.06 69.9013 423.487 69.24 424.34 68.856C425.236 68.4293 426.196 68.216 427.22 68.216C428.287 68.216 429.247 68.4293 430.1 68.856C430.953 69.24 431.38 69.9013 431.38 70.84V112.312C431.38 113.208 430.953 113.891 430.1 114.36C429.247 114.787 428.287 115 427.22 115C426.239 115 425.321 114.808 424.468 114.424C423.657 114.04 422.996 113.357 422.484 112.376L408.66 86.648V112.312C408.66 113.208 408.233 113.891 407.38 114.36C406.527 114.787 405.567 115 404.5 115ZM453.681 115.384C450.865 115.384 448.326 114.915 446.065 113.976C443.803 112.995 441.99 111.437 440.625 109.304C439.302 107.128 438.641 104.248 438.641 100.664V82.936C438.641 79.352 439.302 76.4933 440.625 74.36C441.99 72.184 443.782 70.6267 446.001 69.688C448.262 68.7067 450.822 68.216 453.681 68.216C456.497 68.216 459.035 68.7067 461.297 69.688C463.601 70.6267 465.414 72.184 466.737 74.36C468.059 76.4933 468.721 79.352 468.721 82.936V100.664C468.721 104.248 468.059 107.128 466.737 109.304C465.414 111.437 463.601 112.995 461.297 113.976C459.035 114.915 456.497 115.384 453.681 115.384ZM453.681 108.088C455.771 108.088 457.414 107.491 458.609 106.296C459.803 105.101 460.401 103.224 460.401 100.664V82.936C460.401 80.376 459.803 78.4987 458.609 77.304C457.414 76.1093 455.771 75.512 453.681 75.512C451.59 75.512 449.947 76.1093 448.753 77.304C447.601 78.4987 447.025 80.376 447.025 82.936V100.664C447.025 103.224 447.601 105.101 448.753 106.296C449.947 107.491 451.59 108.088 453.681 108.088ZM490.815 115.384C489.62 115.384 488.489 115.149 487.423 114.68C486.356 114.211 485.673 113.507 485.375 112.568L472.703 72.312C472.617 72.056 472.575 71.8 472.575 71.544C472.575 70.904 472.852 70.3493 473.407 69.88C473.961 69.368 474.644 68.9627 475.455 68.664C476.308 68.3653 477.119 68.216 477.887 68.216C478.527 68.216 479.103 68.344 479.615 68.6C480.169 68.856 480.511 69.2827 480.639 69.88L490.751 104.568L496.191 82.296C496.404 81.528 496.895 80.952 497.663 80.568C498.473 80.184 499.348 79.992 500.287 79.992C501.225 79.992 502.079 80.184 502.847 80.568C503.657 80.952 504.148 81.528 504.319 82.296L509.759 104.568L519.871 69.88C520.041 69.2827 520.383 68.856 520.895 68.6C521.407 68.344 521.983 68.216 522.623 68.216C523.433 68.216 524.244 68.3653 525.055 68.664C525.865 68.9627 526.548 69.368 527.103 69.88C527.657 70.3493 527.935 70.904 527.935 71.544C527.935 71.8 527.892 72.056 527.807 72.312L515.135 112.568C514.793 113.507 514.111 114.211 513.087 114.68C512.063 115.149 510.932 115.384 509.694 115.384C508.5 115.384 507.369 115.149 506.303 114.68C505.236 114.211 504.596 113.507 504.382 112.568L500.287 95.288L496.127 112.568C495.913 113.507 495.273 114.211 494.207 114.68C493.14 115.149 492.009 115.384 490.815 115.384ZM540.854 102.072C539.744 102.072 538.955 101.816 538.486 101.304C538.059 100.792 537.845 99.8533 537.845 98.488C537.845 96.4827 538.038 94.84 538.422 93.56C538.806 92.28 539.296 91.2347 539.894 90.424C540.534 89.5707 541.131 88.888 541.686 88.376C542.24 87.8213 542.88 87.2667 543.606 86.712C544.331 86.1573 545.014 85.5387 545.654 84.856C546.336 84.1733 546.891 83.4053 547.318 82.552C547.744 81.6987 547.958 80.7387 547.958 79.672C547.958 77.8373 547.339 76.472 546.102 75.576C544.907 74.6373 543.328 74.168 541.366 74.168C539.83 74.168 538.635 74.4027 537.782 74.872C536.971 75.2987 536.352 75.8107 535.926 76.408C535.499 77.0053 535.072 77.5173 534.646 77.944C534.262 78.3707 533.707 78.584 532.982 78.584C532.299 78.584 531.595 78.328 530.87 77.816C530.144 77.304 529.782 76.536 529.782 75.512C529.782 74.488 530.23 73.4 531.126 72.248C532.022 71.0533 533.344 70.0507 535.094 69.24C536.843 68.3867 539.019 67.96 541.622 67.96C544.31 67.96 546.635 68.4507 548.598 69.432C550.603 70.3707 552.139 71.6507 553.206 73.272C554.272 74.8933 554.806 76.728 554.806 78.776C554.806 80.3973 554.507 81.8907 553.91 83.256C553.312 84.5787 552.587 85.7733 551.734 86.84C550.88 87.9067 550.027 88.8027 549.174 89.528C548.32 90.2533 547.659 90.8507 547.19 91.32C546.166 92.1307 545.419 92.9627 544.95 93.816C544.523 94.6693 544.267 95.5653 544.182 96.504C544.096 97.4427 544.054 98.5307 544.054 99.768C544.054 100.323 543.84 100.856 543.414 101.368C542.987 101.837 542.134 102.072 540.854 102.072ZM540.854 115.384C539.659 115.384 538.635 114.957 537.782 114.104C536.971 113.208 536.566 112.184 536.566 111.032C536.566 109.837 536.992 108.813 537.845 107.96C538.699 107.107 539.702 106.68 540.854 106.68C542.091 106.68 543.115 107.107 543.926 107.96C544.779 108.813 545.206 109.837 545.206 111.032C545.206 112.184 544.779 113.208 543.926 114.104C543.115 114.957 542.091 115.384 540.854 115.384Z\" fill=\"#FF0082\"/> <path d=\"M135.539 210C135.029 210 134.549 209.865 134.099 209.595C133.649 209.325 133.424 208.935 133.424 208.425V178.68C133.424 178.17 133.649 177.78 134.099 177.51C134.549 177.24 135.029 177.105 135.539 177.105H151.559C152.129 177.105 152.534 177.33 152.774 177.78C153.014 178.23 153.134 178.695 153.134 179.175C153.134 179.745 152.999 180.255 152.729 180.705C152.459 181.125 152.069 181.335 151.559 181.335H138.194V191.64H145.124C145.634 191.64 146.024 191.835 146.294 192.225C146.564 192.615 146.699 193.065 146.699 193.575C146.699 193.995 146.579 194.415 146.339 194.835C146.099 195.225 145.694 195.42 145.124 195.42H138.194V205.77H151.559C152.069 205.77 152.459 205.98 152.729 206.4C152.999 206.82 153.134 207.33 153.134 207.93C153.134 208.41 153.014 208.875 152.774 209.325C152.534 209.775 152.129 210 151.559 210H135.539ZM161.074 210.36C159.424 210.36 158.014 209.88 156.844 208.92C155.674 207.93 155.089 206.43 155.089 204.42C155.089 202.71 155.539 201.39 156.439 200.46C157.339 199.53 158.569 198.885 160.129 198.525C161.719 198.165 163.549 197.985 165.619 197.985H167.599V197.175C167.599 196.395 167.449 195.645 167.149 194.925C166.879 194.175 166.414 193.56 165.754 193.08C165.124 192.57 164.254 192.315 163.144 192.315C162.034 192.315 161.179 192.42 160.579 192.63C159.979 192.84 159.499 193.065 159.139 193.305C158.779 193.545 158.449 193.665 158.149 193.665C157.609 193.665 157.189 193.41 156.889 192.9C156.589 192.36 156.439 191.82 156.439 191.28C156.439 190.74 156.784 190.26 157.474 189.84C158.194 189.39 159.079 189.045 160.129 188.805C161.179 188.535 162.214 188.4 163.234 188.4C165.454 188.4 167.224 188.82 168.544 189.66C169.864 190.47 170.824 191.535 171.424 192.855C172.024 194.175 172.324 195.6 172.324 197.13V208.425C172.324 208.845 172.099 209.22 171.649 209.55C171.229 209.85 170.689 210 170.029 210C169.429 210 168.919 209.85 168.499 209.55C168.079 209.22 167.869 208.845 167.869 208.425V206.85C167.089 207.75 166.144 208.56 165.034 209.28C163.924 210 162.604 210.36 161.074 210.36ZM162.784 206.76C163.534 206.76 164.269 206.535 164.989 206.085C165.739 205.635 166.354 205.065 166.834 204.375C167.344 203.685 167.599 202.98 167.599 202.26V200.595H166.474C165.334 200.595 164.254 200.67 163.234 200.82C162.214 200.94 161.389 201.24 160.759 201.72C160.159 202.17 159.859 202.875 159.859 203.835C159.859 204.855 160.129 205.605 160.669 206.085C161.239 206.535 161.944 206.76 162.784 206.76ZM185.734 210.36C183.574 210.36 181.789 209.97 180.379 209.19C178.999 208.41 177.979 207.345 177.319 205.995C176.659 204.645 176.329 203.115 176.329 201.405V197.355C176.329 195.675 176.659 194.16 177.319 192.81C177.979 191.43 178.999 190.35 180.379 189.57C181.759 188.79 183.514 188.4 185.644 188.4C187.024 188.4 188.224 188.565 189.244 188.895C190.294 189.225 191.104 189.645 191.674 190.155C192.274 190.635 192.574 191.145 192.574 191.685C192.574 191.955 192.484 192.285 192.304 192.675C192.154 193.035 191.929 193.35 191.629 193.62C191.359 193.86 191.029 193.98 190.639 193.98C190.339 193.98 190.009 193.86 189.649 193.62C189.319 193.38 188.869 193.155 188.299 192.945C187.729 192.705 186.964 192.585 186.004 192.585C184.324 192.585 183.079 193.005 182.269 193.845C181.459 194.685 181.054 195.855 181.054 197.355V201.405C181.054 202.905 181.459 204.075 182.269 204.915C183.079 205.755 184.339 206.175 186.049 206.175C187.039 206.175 187.819 206.055 188.389 205.815C188.959 205.545 189.409 205.29 189.739 205.05C190.099 204.81 190.444 204.69 190.774 204.69C191.194 204.69 191.554 204.81 191.854 205.05C192.184 205.29 192.424 205.59 192.574 205.95C192.754 206.31 192.844 206.64 192.844 206.94C192.844 207.45 192.529 207.975 191.899 208.515C191.299 209.055 190.459 209.505 189.379 209.865C188.329 210.195 187.114 210.36 185.734 210.36ZM198.595 210C197.905 210 197.335 209.835 196.885 209.505C196.465 209.175 196.255 208.815 196.255 208.425V177.51C196.255 177.06 196.465 176.7 196.885 176.43C197.335 176.13 197.905 175.98 198.595 175.98C199.255 175.98 199.81 176.13 200.26 176.43C200.74 176.7 200.98 177.06 200.98 177.51V191.82C201.43 190.95 202.135 190.17 203.095 189.48C204.085 188.76 205.3 188.4 206.74 188.4C208.15 188.4 209.44 188.805 210.61 189.615C211.81 190.395 212.77 191.46 213.49 192.81C214.21 194.13 214.57 195.615 214.57 197.265V208.425C214.57 208.935 214.315 209.325 213.805 209.595C213.325 209.865 212.785 210 212.185 210C211.645 210 211.12 209.865 210.61 209.595C210.1 209.325 209.845 208.935 209.845 208.425V197.265C209.845 196.485 209.635 195.735 209.215 195.015C208.795 194.295 208.24 193.71 207.55 193.26C206.89 192.81 206.14 192.585 205.3 192.585C204.58 192.585 203.89 192.78 203.23 193.17C202.57 193.53 202.03 194.055 201.61 194.745C201.19 195.435 200.98 196.275 200.98 197.265V208.425C200.98 208.815 200.74 209.175 200.26 209.505C199.81 209.835 199.255 210 198.595 210ZM230.585 210C229.925 210 229.37 209.835 228.92 209.505C228.5 209.175 228.29 208.815 228.29 208.425V190.2C228.29 189.75 228.5 189.39 228.92 189.12C229.37 188.82 229.925 188.67 230.585 188.67C231.185 188.67 231.695 188.82 232.115 189.12C232.535 189.39 232.745 189.75 232.745 190.2V192.18C233.075 191.55 233.51 190.95 234.05 190.38C234.62 189.81 235.28 189.345 236.03 188.985C236.78 188.595 237.59 188.4 238.46 188.4H239.9C240.38 188.4 240.8 188.61 241.16 189.03C241.52 189.42 241.7 189.9 241.7 190.47C241.7 191.04 241.52 191.535 241.16 191.955C240.8 192.375 240.38 192.585 239.9 192.585H238.46C237.56 192.585 236.69 192.855 235.85 193.395C235.01 193.935 234.32 194.7 233.78 195.69C233.27 196.65 233.015 197.82 233.015 199.2V208.425C233.015 208.815 232.775 209.175 232.295 209.505C231.845 209.835 231.275 210 230.585 210ZM253.345 210.36C251.305 210.36 249.505 209.985 247.945 209.235C246.385 208.485 245.155 207.45 244.255 206.13C243.355 204.78 242.905 203.205 242.905 201.405V197.13C242.905 195.54 243.325 194.085 244.165 192.765C245.035 191.445 246.175 190.395 247.585 189.615C248.995 188.805 250.555 188.4 252.265 188.4C253.885 188.4 255.37 188.76 256.72 189.48C258.07 190.17 259.15 191.145 259.96 192.405C260.8 193.665 261.22 195.105 261.22 196.725C261.22 197.985 261.025 198.885 260.635 199.425C260.245 199.965 259.735 200.295 259.105 200.415C258.475 200.535 257.815 200.595 257.125 200.595H247.63V201.63C247.63 203.13 248.17 204.33 249.25 205.23C250.36 206.1 251.77 206.535 253.48 206.535C254.53 206.535 255.385 206.385 256.045 206.085C256.705 205.785 257.26 205.5 257.71 205.23C258.16 204.96 258.58 204.825 258.97 204.825C259.36 204.825 259.69 204.945 259.96 205.185C260.23 205.425 260.44 205.71 260.59 206.04C260.74 206.37 260.815 206.67 260.815 206.94C260.815 207.39 260.5 207.885 259.87 208.425C259.27 208.965 258.415 209.43 257.305 209.82C256.195 210.18 254.875 210.36 253.345 210.36ZM247.63 197.67H255.1C255.76 197.67 256.195 197.58 256.405 197.4C256.645 197.22 256.765 196.86 256.765 196.32C256.765 195.54 256.57 194.82 256.18 194.16C255.79 193.47 255.25 192.945 254.56 192.585C253.87 192.195 253.09 192 252.22 192C251.38 192 250.615 192.18 249.925 192.54C249.235 192.9 248.68 193.395 248.26 194.025C247.84 194.655 247.63 195.39 247.63 196.23V197.67ZM267.817 210C267.127 210 266.557 209.835 266.107 209.505C265.687 209.175 265.477 208.815 265.477 208.425V177.51C265.477 177.06 265.687 176.7 266.107 176.43C266.557 176.13 267.127 175.98 267.817 175.98C268.477 175.98 269.032 176.13 269.482 176.43C269.962 176.7 270.202 177.06 270.202 177.51V208.425C270.202 208.815 269.962 209.175 269.482 209.505C269.032 209.835 268.477 210 267.817 210ZM277.871 183.315C277.121 183.315 276.476 183.06 275.936 182.55C275.396 182.04 275.126 181.47 275.126 180.84C275.126 180.15 275.396 179.565 275.936 179.085C276.476 178.605 277.121 178.365 277.871 178.365C278.621 178.365 279.251 178.605 279.761 179.085C280.301 179.565 280.571 180.15 280.571 180.84C280.571 181.47 280.301 182.04 279.761 182.55C279.251 183.06 278.621 183.315 277.871 183.315ZM277.871 210C277.181 210 276.611 209.835 276.161 209.505C275.741 209.175 275.531 208.815 275.531 208.425V190.2C275.531 189.75 275.741 189.39 276.161 189.12C276.611 188.82 277.181 188.67 277.871 188.67C278.531 188.67 279.086 188.82 279.536 189.12C280.016 189.39 280.256 189.75 280.256 190.2V208.425C280.256 208.815 280.016 209.175 279.536 209.505C279.086 209.835 278.531 210 277.871 210ZM293.21 220.125C291.47 220.125 289.865 219.87 288.395 219.36C286.925 218.88 285.755 218.175 284.885 217.245C284.015 216.315 283.58 215.205 283.58 213.915C283.58 212.715 283.925 211.71 284.615 210.9C285.305 210.12 286.115 209.52 287.045 209.1C286.445 208.83 285.95 208.47 285.56 208.02C285.17 207.57 284.975 206.94 284.975 206.13C284.975 205.29 285.185 204.615 285.605 204.105C286.025 203.595 286.565 203.13 287.225 202.71C286.385 202.05 285.725 201.24 285.245 200.28C284.795 199.29 284.57 198.21 284.57 197.04V195.78C284.57 194.34 284.915 193.065 285.605 191.955C286.295 190.845 287.27 189.975 288.53 189.345C289.82 188.715 291.29 188.4 292.94 188.4C293.96 188.4 294.905 188.535 295.775 188.805C296.675 189.075 297.47 189.45 298.16 189.93C298.64 188.82 299.12 188.04 299.6 187.59C300.11 187.14 300.59 186.915 301.04 186.915C301.67 186.915 302.15 187.095 302.48 187.455C302.81 187.815 302.975 188.175 302.975 188.535C302.975 188.775 302.9 189 302.75 189.21C302.63 189.39 302.45 189.54 302.21 189.66C301.91 189.81 301.55 190.02 301.13 190.29C300.74 190.53 300.35 190.92 299.96 191.46C300.47 192.03 300.845 192.69 301.085 193.44C301.325 194.19 301.445 194.97 301.445 195.78V197.04C301.445 198.45 301.085 199.725 300.365 200.865C299.645 202.005 298.64 202.905 297.35 203.565C296.06 204.195 294.59 204.51 292.94 204.51C291.77 204.51 290.735 204.33 289.835 203.97C289.595 204.12 289.385 204.3 289.205 204.51C289.055 204.69 288.98 204.93 288.98 205.23C288.98 205.77 289.31 206.16 289.97 206.4C290.63 206.64 291.47 206.82 292.49 206.94C293.54 207.06 294.65 207.21 295.82 207.39C296.99 207.57 298.085 207.87 299.105 208.29C300.155 208.68 301.01 209.265 301.67 210.045C302.33 210.855 302.66 211.95 302.66 213.33C302.66 214.89 302.225 216.165 301.355 217.155C300.485 218.175 299.33 218.925 297.89 219.405C296.48 219.885 294.92 220.125 293.21 220.125ZM293.12 216.975C294.59 216.975 295.775 216.645 296.675 215.985C297.605 215.355 298.07 214.515 298.07 213.465C298.07 212.715 297.845 212.13 297.395 211.71C296.945 211.29 296.36 210.975 295.64 210.765C294.92 210.555 294.155 210.405 293.345 210.315C292.565 210.225 291.815 210.135 291.095 210.045C290.255 210.345 289.535 210.765 288.935 211.305C288.365 211.875 288.08 212.58 288.08 213.42C288.08 214.53 288.545 215.4 289.475 216.03C290.435 216.66 291.65 216.975 293.12 216.975ZM293.03 201.495C294.23 201.495 295.16 201.075 295.82 200.235C296.51 199.395 296.855 198.33 296.855 197.04V195.78C296.855 194.55 296.51 193.515 295.82 192.675C295.16 191.835 294.215 191.415 292.985 191.415C291.755 191.415 290.81 191.835 290.15 192.675C289.49 193.515 289.16 194.55 289.16 195.78V196.995C289.16 198.255 289.49 199.32 290.15 200.19C290.81 201.06 291.77 201.495 293.03 201.495ZM308.413 183.315C307.663 183.315 307.018 183.06 306.478 182.55C305.938 182.04 305.668 181.47 305.668 180.84C305.668 180.15 305.938 179.565 306.478 179.085C307.018 178.605 307.663 178.365 308.413 178.365C309.163 178.365 309.793 178.605 310.303 179.085C310.843 179.565 311.113 180.15 311.113 180.84C311.113 181.47 310.843 182.04 310.303 182.55C309.793 183.06 309.163 183.315 308.413 183.315ZM308.413 210C307.723 210 307.153 209.835 306.703 209.505C306.283 209.175 306.073 208.815 306.073 208.425V190.2C306.073 189.75 306.283 189.39 306.703 189.12C307.153 188.82 307.723 188.67 308.413 188.67C309.073 188.67 309.628 188.82 310.078 189.12C310.558 189.39 310.798 189.75 310.798 190.2V208.425C310.798 208.815 310.558 209.175 310.078 209.505C309.628 209.835 309.073 210 308.413 210ZM324.112 210.36C322.492 210.36 320.977 209.94 319.567 209.1C318.157 208.26 317.017 207.165 316.147 205.815C315.307 204.435 314.887 202.965 314.887 201.405V197.265C314.887 195.675 315.292 194.205 316.102 192.855C316.942 191.505 318.067 190.425 319.477 189.615C320.917 188.805 322.477 188.4 324.157 188.4C325.837 188.4 327.382 188.805 328.792 189.615C330.202 190.395 331.327 191.46 332.167 192.81C333.037 194.13 333.472 195.615 333.472 197.265V201.405C333.472 202.935 333.037 204.39 332.167 205.77C331.327 207.15 330.187 208.26 328.747 209.1C327.337 209.94 325.792 210.36 324.112 210.36ZM324.157 206.175C324.997 206.175 325.762 205.95 326.452 205.5C327.142 205.05 327.697 204.465 328.117 203.745C328.537 202.995 328.747 202.215 328.747 201.405V197.265C328.747 196.485 328.537 195.735 328.117 195.015C327.697 194.295 327.142 193.71 326.452 193.26C325.762 192.81 324.997 192.585 324.157 192.585C323.287 192.585 322.507 192.81 321.817 193.26C321.157 193.71 320.617 194.295 320.197 195.015C319.807 195.735 319.612 196.485 319.612 197.265V201.405C319.612 202.215 319.807 202.995 320.197 203.745C320.617 204.465 321.172 205.05 321.862 205.5C322.552 205.95 323.317 206.175 324.157 206.175ZM346.672 210.36C344.992 210.36 343.432 209.955 341.992 209.145C340.582 208.305 339.457 207.21 338.617 205.86C337.777 204.48 337.357 203.025 337.357 201.495V190.245C337.357 189.855 337.582 189.495 338.032 189.165C338.512 188.835 339.082 188.67 339.742 188.67C340.372 188.67 340.912 188.835 341.362 189.165C341.842 189.495 342.082 189.855 342.082 190.245V201.495C342.082 202.275 342.277 203.025 342.667 203.745C343.087 204.465 343.642 205.05 344.332 205.5C345.052 205.95 345.832 206.175 346.672 206.175C347.512 206.175 348.277 205.95 348.967 205.5C349.657 205.05 350.197 204.465 350.587 203.745C351.007 203.025 351.217 202.275 351.217 201.495V190.2C351.217 189.78 351.457 189.42 351.937 189.12C352.447 188.82 353.002 188.67 353.602 188.67C354.292 188.67 354.847 188.82 355.267 189.12C355.717 189.42 355.942 189.78 355.942 190.2V201.495C355.942 203.085 355.522 204.555 354.682 205.905C353.842 207.255 352.717 208.335 351.307 209.145C349.897 209.955 348.352 210.36 346.672 210.36ZM367.178 210.36C365.708 210.36 364.388 210.18 363.218 209.82C362.048 209.46 361.118 209.01 360.428 208.47C359.768 207.9 359.438 207.33 359.438 206.76C359.438 206.49 359.498 206.19 359.618 205.86C359.768 205.53 359.963 205.245 360.203 205.005C360.473 204.765 360.758 204.645 361.058 204.645C361.448 204.645 361.853 204.825 362.273 205.185C362.723 205.515 363.308 205.86 364.028 206.22C364.748 206.55 365.753 206.715 367.043 206.715C368.543 206.715 369.548 206.46 370.058 205.95C370.598 205.44 370.868 204.885 370.868 204.285C370.868 203.505 370.598 202.905 370.058 202.485C369.548 202.035 368.873 201.675 368.033 201.405C367.223 201.135 366.353 200.88 365.423 200.64C364.493 200.37 363.608 200.025 362.768 199.605C361.958 199.185 361.283 198.6 360.743 197.85C360.233 197.1 359.978 196.11 359.978 194.88C359.978 193.86 360.233 192.855 360.743 191.865C361.253 190.845 362.063 190.02 363.173 189.39C364.313 188.73 365.828 188.4 367.718 188.4C368.858 188.4 369.938 188.52 370.958 188.76C371.978 189 372.818 189.33 373.478 189.75C374.138 190.14 374.468 190.575 374.468 191.055C374.468 191.265 374.393 191.565 374.243 191.955C374.093 192.315 373.883 192.645 373.613 192.945C373.373 193.215 373.058 193.35 372.668 193.35C372.368 193.35 371.993 193.245 371.543 193.035C371.093 192.795 370.568 192.57 369.968 192.36C369.368 192.15 368.633 192.045 367.763 192.045C366.893 192.045 366.188 192.195 365.648 192.495C365.138 192.765 364.763 193.095 364.523 193.485C364.283 193.875 364.163 194.265 364.163 194.655C364.163 195.315 364.418 195.825 364.928 196.185C365.438 196.545 366.113 196.845 366.953 197.085C367.793 197.325 368.678 197.58 369.608 197.85C370.538 198.09 371.408 198.45 372.218 198.93C373.058 199.41 373.733 200.055 374.243 200.865C374.783 201.675 375.053 202.755 375.053 204.105C375.053 205.995 374.363 207.51 372.983 208.65C371.633 209.79 369.698 210.36 367.178 210.36ZM395.998 220.125C394.258 220.125 392.653 219.87 391.183 219.36C389.713 218.88 388.543 218.175 387.673 217.245C386.803 216.315 386.368 215.205 386.368 213.915C386.368 212.715 386.713 211.71 387.403 210.9C388.093 210.12 388.903 209.52 389.833 209.1C389.233 208.83 388.738 208.47 388.348 208.02C387.958 207.57 387.763 206.94 387.763 206.13C387.763 205.29 387.973 204.615 388.393 204.105C388.813 203.595 389.353 203.13 390.013 202.71C389.173 202.05 388.513 201.24 388.033 200.28C387.583 199.29 387.358 198.21 387.358 197.04V195.78C387.358 194.34 387.703 193.065 388.393 191.955C389.083 190.845 390.058 189.975 391.318 189.345C392.608 188.715 394.078 188.4 395.728 188.4C396.748 188.4 397.693 188.535 398.563 188.805C399.463 189.075 400.258 189.45 400.948 189.93C401.428 188.82 401.908 188.04 402.388 187.59C402.898 187.14 403.378 186.915 403.828 186.915C404.458 186.915 404.938 187.095 405.268 187.455C405.598 187.815 405.763 188.175 405.763 188.535C405.763 188.775 405.688 189 405.538 189.21C405.418 189.39 405.238 189.54 404.998 189.66C404.698 189.81 404.338 190.02 403.918 190.29C403.528 190.53 403.138 190.92 402.748 191.46C403.258 192.03 403.633 192.69 403.873 193.44C404.113 194.19 404.233 194.97 404.233 195.78V197.04C404.233 198.45 403.873 199.725 403.153 200.865C402.433 202.005 401.428 202.905 400.138 203.565C398.848 204.195 397.378 204.51 395.728 204.51C394.558 204.51 393.523 204.33 392.623 203.97C392.383 204.12 392.173 204.3 391.993 204.51C391.843 204.69 391.768 204.93 391.768 205.23C391.768 205.77 392.098 206.16 392.758 206.4C393.418 206.64 394.258 206.82 395.278 206.94C396.328 207.06 397.438 207.21 398.608 207.39C399.778 207.57 400.873 207.87 401.893 208.29C402.943 208.68 403.798 209.265 404.458 210.045C405.118 210.855 405.448 211.95 405.448 213.33C405.448 214.89 405.013 216.165 404.143 217.155C403.273 218.175 402.118 218.925 400.678 219.405C399.268 219.885 397.708 220.125 395.998 220.125ZM395.908 216.975C397.378 216.975 398.563 216.645 399.463 215.985C400.393 215.355 400.858 214.515 400.858 213.465C400.858 212.715 400.633 212.13 400.183 211.71C399.733 211.29 399.148 210.975 398.428 210.765C397.708 210.555 396.943 210.405 396.133 210.315C395.353 210.225 394.603 210.135 393.883 210.045C393.043 210.345 392.323 210.765 391.723 211.305C391.153 211.875 390.868 212.58 390.868 213.42C390.868 214.53 391.333 215.4 392.263 216.03C393.223 216.66 394.438 216.975 395.908 216.975ZM395.818 201.495C397.018 201.495 397.948 201.075 398.608 200.235C399.298 199.395 399.643 198.33 399.643 197.04V195.78C399.643 194.55 399.298 193.515 398.608 192.675C397.948 191.835 397.003 191.415 395.773 191.415C394.543 191.415 393.598 191.835 392.938 192.675C392.278 193.515 391.948 194.55 391.948 195.78V196.995C391.948 198.255 392.278 199.32 392.938 200.19C393.598 201.06 394.558 201.495 395.818 201.495ZM411.156 210C410.496 210 409.941 209.835 409.491 209.505C409.071 209.175 408.861 208.815 408.861 208.425V190.2C408.861 189.75 409.071 189.39 409.491 189.12C409.941 188.82 410.496 188.67 411.156 188.67C411.756 188.67 412.266 188.82 412.686 189.12C413.106 189.39 413.316 189.75 413.316 190.2V192.18C413.646 191.55 414.081 190.95 414.621 190.38C415.191 189.81 415.851 189.345 416.601 188.985C417.351 188.595 418.161 188.4 419.031 188.4H420.471C420.951 188.4 421.371 188.61 421.731 189.03C422.091 189.42 422.271 189.9 422.271 190.47C422.271 191.04 422.091 191.535 421.731 191.955C421.371 192.375 420.951 192.585 420.471 192.585H419.031C418.131 192.585 417.261 192.855 416.421 193.395C415.581 193.935 414.891 194.7 414.351 195.69C413.841 196.65 413.586 197.82 413.586 199.2V208.425C413.586 208.815 413.346 209.175 412.866 209.505C412.416 209.835 411.846 210 411.156 210ZM432.701 210.36C431.081 210.36 429.566 209.94 428.156 209.1C426.746 208.26 425.606 207.165 424.736 205.815C423.896 204.435 423.476 202.965 423.476 201.405V197.265C423.476 195.675 423.881 194.205 424.691 192.855C425.531 191.505 426.656 190.425 428.066 189.615C429.506 188.805 431.066 188.4 432.746 188.4C434.426 188.4 435.971 188.805 437.381 189.615C438.791 190.395 439.916 191.46 440.756 192.81C441.626 194.13 442.061 195.615 442.061 197.265V201.405C442.061 202.935 441.626 204.39 440.756 205.77C439.916 207.15 438.776 208.26 437.336 209.1C435.926 209.94 434.381 210.36 432.701 210.36ZM432.746 206.175C433.586 206.175 434.351 205.95 435.041 205.5C435.731 205.05 436.286 204.465 436.706 203.745C437.126 202.995 437.336 202.215 437.336 201.405V197.265C437.336 196.485 437.126 195.735 436.706 195.015C436.286 194.295 435.731 193.71 435.041 193.26C434.351 192.81 433.586 192.585 432.746 192.585C431.876 192.585 431.096 192.81 430.406 193.26C429.746 193.71 429.206 194.295 428.786 195.015C428.396 195.735 428.201 196.485 428.201 197.265V201.405C428.201 202.215 428.396 202.995 428.786 203.745C429.206 204.465 429.761 205.05 430.451 205.5C431.141 205.95 431.906 206.175 432.746 206.175ZM455.261 210.36C453.581 210.36 452.021 209.955 450.581 209.145C449.171 208.305 448.046 207.21 447.206 205.86C446.366 204.48 445.946 203.025 445.946 201.495V190.245C445.946 189.855 446.171 189.495 446.621 189.165C447.101 188.835 447.671 188.67 448.331 188.67C448.961 188.67 449.501 188.835 449.951 189.165C450.431 189.495 450.671 189.855 450.671 190.245V201.495C450.671 202.275 450.866 203.025 451.256 203.745C451.676 204.465 452.231 205.05 452.921 205.5C453.641 205.95 454.421 206.175 455.261 206.175C456.101 206.175 456.866 205.95 457.556 205.5C458.246 205.05 458.786 204.465 459.176 203.745C459.596 203.025 459.806 202.275 459.806 201.495V190.2C459.806 189.78 460.046 189.42 460.526 189.12C461.036 188.82 461.591 188.67 462.191 188.67C462.881 188.67 463.436 188.82 463.856 189.12C464.306 189.42 464.531 189.78 464.531 190.2V201.495C464.531 203.085 464.111 204.555 463.271 205.905C462.431 207.255 461.306 208.335 459.896 209.145C458.486 209.955 456.941 210.36 455.261 210.36ZM471.582 220.125C470.922 220.125 470.367 219.96 469.917 219.63C469.497 219.3 469.287 218.94 469.287 218.55V190.2C469.287 189.75 469.497 189.39 469.917 189.12C470.367 188.82 470.907 188.67 471.537 188.67C472.167 188.67 472.692 188.82 473.112 189.12C473.532 189.39 473.742 189.75 473.742 190.2V191.82C474.252 190.95 475.017 190.17 476.037 189.48C477.087 188.76 478.332 188.4 479.772 188.4C481.272 188.4 482.637 188.805 483.867 189.615C485.097 190.395 486.072 191.46 486.792 192.81C487.512 194.13 487.872 195.615 487.872 197.265V201.405C487.872 202.965 487.497 204.435 486.747 205.815C486.027 207.165 485.067 208.26 483.867 209.1C482.667 209.94 481.362 210.36 479.952 210.36C478.602 210.36 477.387 210.015 476.307 209.325C475.227 208.605 474.462 207.78 474.012 206.85V218.55C474.012 218.94 473.772 219.3 473.292 219.63C472.842 219.96 472.272 220.125 471.582 220.125ZM478.557 206.175C479.367 206.175 480.117 205.95 480.807 205.5C481.497 205.05 482.052 204.45 482.472 203.7C482.922 202.95 483.147 202.185 483.147 201.405V197.265C483.147 196.485 482.937 195.735 482.517 195.015C482.097 194.295 481.527 193.71 480.807 193.26C480.117 192.81 479.337 192.585 478.467 192.585C477.747 192.585 477.042 192.78 476.352 193.17C475.662 193.53 475.092 194.055 474.642 194.745C474.222 195.435 474.012 196.275 474.012 197.265V202.44C474.012 202.8 474.207 203.28 474.597 203.88C474.987 204.45 475.527 204.975 476.217 205.455C476.907 205.935 477.687 206.175 478.557 206.175ZM503.4 210C502.71 210 502.14 209.835 501.69 209.505C501.27 209.175 501.06 208.815 501.06 208.425V177.51C501.06 177.06 501.27 176.7 501.69 176.43C502.14 176.13 502.71 175.98 503.4 175.98C504.06 175.98 504.615 176.13 505.065 176.43C505.545 176.7 505.785 177.06 505.785 177.51V191.82C506.235 190.95 506.94 190.17 507.9 189.48C508.89 188.76 510.105 188.4 511.545 188.4C512.955 188.4 514.245 188.805 515.415 189.615C516.615 190.395 517.575 191.46 518.295 192.81C519.015 194.13 519.375 195.615 519.375 197.265V208.425C519.375 208.935 519.12 209.325 518.61 209.595C518.13 209.865 517.59 210 516.99 210C516.45 210 515.925 209.865 515.415 209.595C514.905 209.325 514.65 208.935 514.65 208.425V197.265C514.65 196.485 514.44 195.735 514.02 195.015C513.6 194.295 513.045 193.71 512.355 193.26C511.695 192.81 510.945 192.585 510.105 192.585C509.385 192.585 508.695 192.78 508.035 193.17C507.375 193.53 506.835 194.055 506.415 194.745C505.995 195.435 505.785 196.275 505.785 197.265V208.425C505.785 208.815 505.545 209.175 505.065 209.505C504.615 209.835 504.06 210 503.4 210ZM528.721 210.36C527.071 210.36 525.661 209.88 524.491 208.92C523.321 207.93 522.736 206.43 522.736 204.42C522.736 202.71 523.186 201.39 524.086 200.46C524.986 199.53 526.216 198.885 527.776 198.525C529.366 198.165 531.196 197.985 533.266 197.985H535.246V197.175C535.246 196.395 535.096 195.645 534.796 194.925C534.526 194.175 534.061 193.56 533.401 193.08C532.771 192.57 531.901 192.315 530.791 192.315C529.681 192.315 528.826 192.42 528.226 192.63C527.626 192.84 527.146 193.065 526.786 193.305C526.426 193.545 526.096 193.665 525.796 193.665C525.256 193.665 524.836 193.41 524.536 192.9C524.236 192.36 524.086 191.82 524.086 191.28C524.086 190.74 524.431 190.26 525.121 189.84C525.841 189.39 526.726 189.045 527.776 188.805C528.826 188.535 529.861 188.4 530.881 188.4C533.101 188.4 534.871 188.82 536.191 189.66C537.511 190.47 538.471 191.535 539.071 192.855C539.671 194.175 539.971 195.6 539.971 197.13V208.425C539.971 208.845 539.746 209.22 539.296 209.55C538.876 209.85 538.336 210 537.676 210C537.076 210 536.566 209.85 536.146 209.55C535.726 209.22 535.516 208.845 535.516 208.425V206.85C534.736 207.75 533.791 208.56 532.681 209.28C531.571 210 530.251 210.36 528.721 210.36ZM530.431 206.76C531.181 206.76 531.916 206.535 532.636 206.085C533.386 205.635 534.001 205.065 534.481 204.375C534.991 203.685 535.246 202.98 535.246 202.26V200.595H534.121C532.981 200.595 531.901 200.67 530.881 200.82C529.861 200.94 529.036 201.24 528.406 201.72C527.806 202.17 527.506 202.875 527.506 203.835C527.506 204.855 527.776 205.605 528.316 206.085C528.886 206.535 529.591 206.76 530.431 206.76ZM551.265 210.36C549.795 210.36 548.475 210.18 547.305 209.82C546.135 209.46 545.205 209.01 544.515 208.47C543.855 207.9 543.525 207.33 543.525 206.76C543.525 206.49 543.585 206.19 543.705 205.86C543.855 205.53 544.05 205.245 544.29 205.005C544.56 204.765 544.845 204.645 545.145 204.645C545.535 204.645 545.94 204.825 546.36 205.185C546.81 205.515 547.395 205.86 548.115 206.22C548.835 206.55 549.84 206.715 551.13 206.715C552.63 206.715 553.635 206.46 554.145 205.95C554.685 205.44 554.955 204.885 554.955 204.285C554.955 203.505 554.685 202.905 554.145 202.485C553.635 202.035 552.96 201.675 552.12 201.405C551.31 201.135 550.44 200.88 549.51 200.64C548.58 200.37 547.695 200.025 546.855 199.605C546.045 199.185 545.37 198.6 544.83 197.85C544.32 197.1 544.065 196.11 544.065 194.88C544.065 193.86 544.32 192.855 544.83 191.865C545.34 190.845 546.15 190.02 547.26 189.39C548.4 188.73 549.915 188.4 551.805 188.4C552.945 188.4 554.025 188.52 555.045 188.76C556.065 189 556.905 189.33 557.565 189.75C558.225 190.14 558.555 190.575 558.555 191.055C558.555 191.265 558.48 191.565 558.33 191.955C558.18 192.315 557.97 192.645 557.7 192.945C557.46 193.215 557.145 193.35 556.755 193.35C556.455 193.35 556.08 193.245 555.63 193.035C555.18 192.795 554.655 192.57 554.055 192.36C553.455 192.15 552.72 192.045 551.85 192.045C550.98 192.045 550.275 192.195 549.735 192.495C549.225 192.765 548.85 193.095 548.61 193.485C548.37 193.875 548.25 194.265 548.25 194.655C548.25 195.315 548.505 195.825 549.015 196.185C549.525 196.545 550.2 196.845 551.04 197.085C551.88 197.325 552.765 197.58 553.695 197.85C554.625 198.09 555.495 198.45 556.305 198.93C557.145 199.41 557.82 200.055 558.33 200.865C558.87 201.675 559.14 202.755 559.14 204.105C559.14 205.995 558.45 207.51 557.07 208.65C555.72 209.79 553.785 210.36 551.265 210.36ZM106.414 267C103.864 267 101.914 266.445 100.564 265.335C99.2143 264.195 98.5393 262.41 98.5393 259.98V237.435C98.5393 236.985 98.7793 236.625 99.2593 236.355C99.7693 236.055 100.309 235.905 100.879 235.905C101.449 235.905 101.989 236.055 102.499 236.355C103.009 236.625 103.264 236.985 103.264 237.435V245.67H108.754C109.174 245.67 109.489 245.85 109.699 246.21C109.939 246.57 110.059 246.975 110.059 247.425C110.059 247.875 109.939 248.28 109.699 248.64C109.489 249 109.174 249.18 108.754 249.18H103.264V259.98C103.264 261.06 103.489 261.825 103.939 262.275C104.419 262.725 105.244 262.95 106.414 262.95H107.944C108.634 262.95 109.144 263.16 109.474 263.58C109.834 263.97 110.014 264.435 110.014 264.975C110.014 265.485 109.834 265.95 109.474 266.37C109.144 266.79 108.634 267 107.944 267H106.414ZM115.692 267C115.002 267 114.432 266.835 113.982 266.505C113.562 266.175 113.352 265.815 113.352 265.425V234.51C113.352 234.06 113.562 233.7 113.982 233.43C114.432 233.13 115.002 232.98 115.692 232.98C116.352 232.98 116.907 233.13 117.357 233.43C117.837 233.7 118.077 234.06 118.077 234.51V248.82C118.527 247.95 119.232 247.17 120.192 246.48C121.182 245.76 122.397 245.4 123.837 245.4C125.247 245.4 126.537 245.805 127.707 246.615C128.907 247.395 129.867 248.46 130.587 249.81C131.307 251.13 131.667 252.615 131.667 254.265V265.425C131.667 265.935 131.412 266.325 130.902 266.595C130.422 266.865 129.882 267 129.282 267C128.742 267 128.217 266.865 127.707 266.595C127.197 266.325 126.942 265.935 126.942 265.425V254.265C126.942 253.485 126.732 252.735 126.312 252.015C125.892 251.295 125.337 250.71 124.647 250.26C123.987 249.81 123.237 249.585 122.397 249.585C121.677 249.585 120.987 249.78 120.327 250.17C119.667 250.53 119.127 251.055 118.707 251.745C118.287 252.435 118.077 253.275 118.077 254.265V265.425C118.077 265.815 117.837 266.175 117.357 266.505C116.907 266.835 116.352 267 115.692 267ZM146.008 267.36C143.968 267.36 142.168 266.985 140.608 266.235C139.048 265.485 137.818 264.45 136.918 263.13C136.018 261.78 135.568 260.205 135.568 258.405V254.13C135.568 252.54 135.988 251.085 136.828 249.765C137.698 248.445 138.838 247.395 140.248 246.615C141.658 245.805 143.218 245.4 144.928 245.4C146.548 245.4 148.033 245.76 149.383 246.48C150.733 247.17 151.813 248.145 152.623 249.405C153.463 250.665 153.883 252.105 153.883 253.725C153.883 254.985 153.688 255.885 153.298 256.425C152.908 256.965 152.398 257.295 151.768 257.415C151.138 257.535 150.478 257.595 149.788 257.595H140.293V258.63C140.293 260.13 140.833 261.33 141.913 262.23C143.023 263.1 144.433 263.535 146.143 263.535C147.193 263.535 148.048 263.385 148.708 263.085C149.368 262.785 149.923 262.5 150.373 262.23C150.823 261.96 151.243 261.825 151.633 261.825C152.023 261.825 152.353 261.945 152.623 262.185C152.893 262.425 153.103 262.71 153.253 263.04C153.403 263.37 153.478 263.67 153.478 263.94C153.478 264.39 153.163 264.885 152.533 265.425C151.933 265.965 151.078 266.43 149.968 266.82C148.858 267.18 147.538 267.36 146.008 267.36ZM140.293 254.67H147.763C148.423 254.67 148.858 254.58 149.068 254.4C149.308 254.22 149.428 253.86 149.428 253.32C149.428 252.54 149.233 251.82 148.843 251.16C148.453 250.47 147.913 249.945 147.223 249.585C146.533 249.195 145.753 249 144.883 249C144.043 249 143.278 249.18 142.588 249.54C141.898 249.9 141.343 250.395 140.923 251.025C140.503 251.655 140.293 252.39 140.293 253.23V254.67ZM160.076 240.315C159.326 240.315 158.681 240.06 158.141 239.55C157.601 239.04 157.331 238.47 157.331 237.84C157.331 237.15 157.601 236.565 158.141 236.085C158.681 235.605 159.326 235.365 160.076 235.365C160.826 235.365 161.456 235.605 161.966 236.085C162.506 236.565 162.776 237.15 162.776 237.84C162.776 238.47 162.506 239.04 161.966 239.55C161.456 240.06 160.826 240.315 160.076 240.315ZM160.076 267C159.386 267 158.816 266.835 158.366 266.505C157.946 266.175 157.736 265.815 157.736 265.425V247.2C157.736 246.75 157.946 246.39 158.366 246.12C158.816 245.82 159.386 245.67 160.076 245.67C160.736 245.67 161.291 245.82 161.741 246.12C162.221 246.39 162.461 246.75 162.461 247.2V265.425C162.461 265.815 162.221 266.175 161.741 266.505C161.291 266.835 160.736 267 160.076 267ZM169.655 267C168.995 267 168.44 266.835 167.99 266.505C167.57 266.175 167.36 265.815 167.36 265.425V247.2C167.36 246.75 167.57 246.39 167.99 246.12C168.44 245.82 168.995 245.67 169.655 245.67C170.255 245.67 170.765 245.82 171.185 246.12C171.605 246.39 171.815 246.75 171.815 247.2V249.18C172.145 248.55 172.58 247.95 173.12 247.38C173.69 246.81 174.35 246.345 175.1 245.985C175.85 245.595 176.66 245.4 177.53 245.4H178.97C179.45 245.4 179.87 245.61 180.23 246.03C180.59 246.42 180.77 246.9 180.77 247.47C180.77 248.04 180.59 248.535 180.23 248.955C179.87 249.375 179.45 249.585 178.97 249.585H177.53C176.63 249.585 175.76 249.855 174.92 250.395C174.08 250.935 173.39 251.7 172.85 252.69C172.34 253.65 172.085 254.82 172.085 256.2V265.425C172.085 265.815 171.845 266.175 171.365 266.505C170.915 266.835 170.345 267 169.655 267ZM200.911 267.36C199.291 267.36 197.776 266.94 196.366 266.1C194.956 265.26 193.816 264.165 192.946 262.815C192.106 261.435 191.686 259.965 191.686 258.405V254.265C191.686 252.675 192.091 251.205 192.901 249.855C193.741 248.505 194.866 247.425 196.276 246.615C197.716 245.805 199.276 245.4 200.956 245.4C202.636 245.4 204.181 245.805 205.591 246.615C207.001 247.395 208.126 248.46 208.966 249.81C209.836 251.13 210.271 252.615 210.271 254.265V258.405C210.271 259.935 209.836 261.39 208.966 262.77C208.126 264.15 206.986 265.26 205.546 266.1C204.136 266.94 202.591 267.36 200.911 267.36ZM200.956 263.175C201.796 263.175 202.561 262.95 203.251 262.5C203.941 262.05 204.496 261.465 204.916 260.745C205.336 259.995 205.546 259.215 205.546 258.405V254.265C205.546 253.485 205.336 252.735 204.916 252.015C204.496 251.295 203.941 250.71 203.251 250.26C202.561 249.81 201.796 249.585 200.956 249.585C200.086 249.585 199.306 249.81 198.616 250.26C197.956 250.71 197.416 251.295 196.996 252.015C196.606 252.735 196.411 253.485 196.411 254.265V258.405C196.411 259.215 196.606 259.995 196.996 260.745C197.416 261.465 197.971 262.05 198.661 262.5C199.351 262.95 200.116 263.175 200.956 263.175ZM221.356 267.45C220.936 267.45 220.561 267.375 220.231 267.225C219.901 267.075 219.661 266.805 219.511 266.415L212.536 248.235C212.476 248.085 212.416 247.95 212.356 247.83C212.326 247.68 212.311 247.56 212.311 247.47C212.311 247.08 212.476 246.75 212.806 246.48C213.136 246.18 213.526 245.94 213.976 245.76C214.456 245.58 214.906 245.49 215.326 245.49C215.656 245.49 215.956 245.565 216.226 245.715C216.496 245.835 216.676 246.045 216.766 246.345L221.761 260.34L225.586 247.92C225.736 247.47 225.961 247.185 226.261 247.065C226.561 246.945 226.891 246.885 227.251 246.885C227.641 246.885 227.986 246.945 228.286 247.065C228.586 247.185 228.811 247.47 228.961 247.92L232.696 260.43L237.736 246.345C237.916 245.775 238.381 245.49 239.131 245.49C239.551 245.49 239.986 245.58 240.436 245.76C240.916 245.91 241.321 246.135 241.651 246.435C241.981 246.735 242.146 247.095 242.146 247.515C242.146 247.605 242.131 247.725 242.101 247.875C242.071 248.025 242.026 248.145 241.966 248.235L234.991 266.505C234.871 266.865 234.631 267.105 234.271 267.225C233.941 267.375 233.566 267.45 233.146 267.45C232.666 267.45 232.246 267.375 231.886 267.225C231.556 267.075 231.331 266.85 231.211 266.55L227.251 254.94L223.381 266.415C223.261 266.775 223.006 267.03 222.616 267.18C222.256 267.36 221.836 267.45 221.356 267.45ZM247.395 267C246.705 267 246.135 266.835 245.685 266.505C245.265 266.175 245.055 265.815 245.055 265.425V247.2C245.055 246.75 245.265 246.39 245.685 246.12C246.135 245.82 246.705 245.67 247.395 245.67C247.965 245.67 248.46 245.82 248.88 246.12C249.3 246.39 249.51 246.75 249.51 247.2V248.82C249.96 247.95 250.695 247.17 251.715 246.48C252.765 245.76 254.04 245.4 255.54 245.4C256.95 245.4 258.24 245.805 259.41 246.615C260.61 247.395 261.57 248.46 262.29 249.81C263.01 251.13 263.37 252.615 263.37 254.265V265.425C263.37 265.935 263.115 266.325 262.605 266.595C262.125 266.865 261.585 267 260.985 267C260.445 267 259.92 266.865 259.41 266.595C258.9 266.325 258.645 265.935 258.645 265.425V254.265C258.645 253.485 258.435 252.735 258.015 252.015C257.625 251.295 257.085 250.71 256.395 250.26C255.705 249.81 254.94 249.585 254.1 249.585C253.38 249.585 252.69 249.78 252.03 250.17C251.37 250.53 250.83 251.055 250.41 251.745C249.99 252.435 249.78 253.275 249.78 254.265V265.425C249.78 265.815 249.54 266.175 249.06 266.505C248.61 266.835 248.055 267 247.395 267ZM284.201 267.36C282.791 267.36 281.486 266.94 280.286 266.1C279.086 265.26 278.111 264.165 277.361 262.815C276.641 261.435 276.281 259.965 276.281 258.405V254.265C276.281 252.615 276.641 251.13 277.361 249.81C278.111 248.46 279.086 247.395 280.286 246.615C281.486 245.805 282.821 245.4 284.291 245.4C285.731 245.4 286.946 245.76 287.936 246.48C288.926 247.17 289.661 247.95 290.141 248.82V234.51C290.141 234.06 290.381 233.7 290.861 233.43C291.341 233.13 291.911 232.98 292.571 232.98C293.231 232.98 293.771 233.13 294.191 233.43C294.641 233.7 294.866 234.06 294.866 234.51V265.425C294.866 265.815 294.641 266.175 294.191 266.505C293.771 266.835 293.231 267 292.571 267C292.001 267 291.491 266.835 291.041 266.505C290.621 266.175 290.411 265.815 290.411 265.425V263.85C289.961 264.78 289.166 265.605 288.026 266.325C286.886 267.015 285.611 267.36 284.201 267.36ZM285.551 263.175C286.421 263.175 287.201 262.935 287.891 262.455C288.581 261.975 289.121 261.45 289.511 260.88C289.931 260.28 290.141 259.8 290.141 259.44V254.265C290.141 253.275 289.916 252.435 289.466 251.745C289.016 251.055 288.446 250.53 287.756 250.17C287.066 249.78 286.346 249.585 285.596 249.585C284.756 249.585 283.976 249.81 283.256 250.26C282.566 250.71 282.011 251.295 281.591 252.015C281.201 252.735 281.006 253.485 281.006 254.265V258.405C281.006 259.185 281.201 259.95 281.591 260.7C282.011 261.45 282.566 262.05 283.256 262.5C283.946 262.95 284.711 263.175 285.551 263.175ZM302.195 240.315C301.445 240.315 300.8 240.06 300.26 239.55C299.72 239.04 299.45 238.47 299.45 237.84C299.45 237.15 299.72 236.565 300.26 236.085C300.8 235.605 301.445 235.365 302.195 235.365C302.945 235.365 303.575 235.605 304.085 236.085C304.625 236.565 304.895 237.15 304.895 237.84C304.895 238.47 304.625 239.04 304.085 239.55C303.575 240.06 302.945 240.315 302.195 240.315ZM302.195 267C301.505 267 300.935 266.835 300.485 266.505C300.065 266.175 299.855 265.815 299.855 265.425V247.2C299.855 246.75 300.065 246.39 300.485 246.12C300.935 245.82 301.505 245.67 302.195 245.67C302.855 245.67 303.41 245.82 303.86 246.12C304.34 246.39 304.58 246.75 304.58 247.2V265.425C304.58 265.815 304.34 266.175 303.86 266.505C303.41 266.835 302.855 267 302.195 267ZM319.109 267.36C317.069 267.36 315.269 266.985 313.709 266.235C312.149 265.485 310.919 264.45 310.019 263.13C309.119 261.78 308.669 260.205 308.669 258.405V254.13C308.669 252.54 309.089 251.085 309.929 249.765C310.799 248.445 311.939 247.395 313.349 246.615C314.759 245.805 316.319 245.4 318.029 245.4C319.649 245.4 321.134 245.76 322.484 246.48C323.834 247.17 324.914 248.145 325.724 249.405C326.564 250.665 326.984 252.105 326.984 253.725C326.984 254.985 326.789 255.885 326.399 256.425C326.009 256.965 325.499 257.295 324.869 257.415C324.239 257.535 323.579 257.595 322.889 257.595H313.394V258.63C313.394 260.13 313.934 261.33 315.014 262.23C316.124 263.1 317.534 263.535 319.244 263.535C320.294 263.535 321.149 263.385 321.809 263.085C322.469 262.785 323.024 262.5 323.474 262.23C323.924 261.96 324.344 261.825 324.734 261.825C325.124 261.825 325.454 261.945 325.724 262.185C325.994 262.425 326.204 262.71 326.354 263.04C326.504 263.37 326.579 263.67 326.579 263.94C326.579 264.39 326.264 264.885 325.634 265.425C325.034 265.965 324.179 266.43 323.069 266.82C321.959 267.18 320.639 267.36 319.109 267.36ZM313.394 254.67H320.864C321.524 254.67 321.959 254.58 322.169 254.4C322.409 254.22 322.529 253.86 322.529 253.32C322.529 252.54 322.334 251.82 321.944 251.16C321.554 250.47 321.014 249.945 320.324 249.585C319.634 249.195 318.854 249 317.984 249C317.144 249 316.379 249.18 315.689 249.54C314.999 249.9 314.444 250.395 314.024 251.025C313.604 251.655 313.394 252.39 313.394 253.23V254.67ZM338.621 267C336.071 267 334.121 266.445 332.771 265.335C331.421 264.195 330.746 262.41 330.746 259.98V237.435C330.746 236.985 330.986 236.625 331.466 236.355C331.976 236.055 332.516 235.905 333.086 235.905C333.656 235.905 334.196 236.055 334.706 236.355C335.216 236.625 335.471 236.985 335.471 237.435V245.67H340.961C341.381 245.67 341.696 245.85 341.906 246.21C342.146 246.57 342.266 246.975 342.266 247.425C342.266 247.875 342.146 248.28 341.906 248.64C341.696 249 341.381 249.18 340.961 249.18H335.471V259.98C335.471 261.06 335.696 261.825 336.146 262.275C336.626 262.725 337.451 262.95 338.621 262.95H340.151C340.841 262.95 341.351 263.16 341.681 263.58C342.041 263.97 342.221 264.435 342.221 264.975C342.221 265.485 342.041 265.95 341.681 266.37C341.351 266.79 340.841 267 340.151 267H338.621ZM350.149 267.36C348.499 267.36 347.089 266.88 345.919 265.92C344.749 264.93 344.164 263.43 344.164 261.42C344.164 259.71 344.614 258.39 345.514 257.46C346.414 256.53 347.644 255.885 349.204 255.525C350.794 255.165 352.624 254.985 354.694 254.985H356.674V254.175C356.674 253.395 356.524 252.645 356.224 251.925C355.954 251.175 355.489 250.56 354.829 250.08C354.199 249.57 353.329 249.315 352.219 249.315C351.109 249.315 350.254 249.42 349.654 249.63C349.054 249.84 348.574 250.065 348.214 250.305C347.854 250.545 347.524 250.665 347.224 250.665C346.684 250.665 346.264 250.41 345.964 249.9C345.664 249.36 345.514 248.82 345.514 248.28C345.514 247.74 345.859 247.26 346.549 246.84C347.269 246.39 348.154 246.045 349.204 245.805C350.254 245.535 351.289 245.4 352.309 245.4C354.529 245.4 356.299 245.82 357.619 246.66C358.939 247.47 359.899 248.535 360.499 249.855C361.099 251.175 361.399 252.6 361.399 254.13V265.425C361.399 265.845 361.174 266.22 360.724 266.55C360.304 266.85 359.764 267 359.104 267C358.504 267 357.994 266.85 357.574 266.55C357.154 266.22 356.944 265.845 356.944 265.425V263.85C356.164 264.75 355.219 265.56 354.109 266.28C352.999 267 351.679 267.36 350.149 267.36ZM351.859 263.76C352.609 263.76 353.344 263.535 354.064 263.085C354.814 262.635 355.429 262.065 355.909 261.375C356.419 260.685 356.674 259.98 356.674 259.26V257.595H355.549C354.409 257.595 353.329 257.67 352.309 257.82C351.289 257.94 350.464 258.24 349.834 258.72C349.234 259.17 348.934 259.875 348.934 260.835C348.934 261.855 349.204 262.605 349.744 263.085C350.314 263.535 351.019 263.76 351.859 263.76ZM368.463 267C367.803 267 367.248 266.835 366.798 266.505C366.378 266.175 366.168 265.815 366.168 265.425V247.2C366.168 246.75 366.378 246.39 366.798 246.12C367.248 245.82 367.803 245.67 368.463 245.67C369.063 245.67 369.573 245.82 369.993 246.12C370.413 246.39 370.623 246.75 370.623 247.2V249.18C370.953 248.55 371.388 247.95 371.928 247.38C372.498 246.81 373.158 246.345 373.908 245.985C374.658 245.595 375.468 245.4 376.338 245.4H377.778C378.258 245.4 378.678 245.61 379.038 246.03C379.398 246.42 379.578 246.9 379.578 247.47C379.578 248.04 379.398 248.535 379.038 248.955C378.678 249.375 378.258 249.585 377.778 249.585H376.338C375.438 249.585 374.568 249.855 373.728 250.395C372.888 250.935 372.198 251.7 371.658 252.69C371.148 253.65 370.893 254.82 370.893 256.2V265.425C370.893 265.815 370.653 266.175 370.173 266.505C369.723 266.835 369.153 267 368.463 267ZM382.386 277.125C381.786 277.125 381.276 276.99 380.856 276.72C380.436 276.48 380.226 275.94 380.226 275.1C380.226 274.56 380.316 274.08 380.496 273.66C380.676 273.27 381.006 273.075 381.486 273.075C382.056 273.075 382.671 272.925 383.331 272.625C384.021 272.355 384.681 271.905 385.311 271.275C385.971 270.675 386.526 269.91 386.976 268.98C387.456 268.05 387.786 266.955 387.966 265.695L380.361 248.235C380.241 248.025 380.181 247.815 380.181 247.605C380.181 247.215 380.346 246.855 380.676 246.525C381.036 246.165 381.456 245.88 381.936 245.67C382.416 245.46 382.866 245.355 383.286 245.355C383.586 245.355 383.871 245.43 384.141 245.58C384.441 245.7 384.636 245.91 384.726 246.21L390.396 260.835L395.301 246.21C395.391 245.91 395.571 245.7 395.841 245.58C396.111 245.43 396.381 245.355 396.651 245.355C397.011 245.355 397.431 245.46 397.911 245.67C398.421 245.88 398.856 246.165 399.216 246.525C399.606 246.855 399.801 247.245 399.801 247.695C399.801 247.935 399.756 248.115 399.666 248.235L392.916 265.83C392.436 267.12 391.941 268.425 391.431 269.745C390.921 271.095 390.291 272.325 389.541 273.435C388.821 274.545 387.876 275.43 386.706 276.09C385.566 276.78 384.126 277.125 382.386 277.125ZM414.08 277.125C413.42 277.125 412.865 276.96 412.415 276.63C411.995 276.3 411.785 275.94 411.785 275.55V247.2C411.785 246.75 411.995 246.39 412.415 246.12C412.865 245.82 413.405 245.67 414.035 245.67C414.665 245.67 415.19 245.82 415.61 246.12C416.03 246.39 416.24 246.75 416.24 247.2V248.82C416.75 247.95 417.515 247.17 418.535 246.48C419.585 245.76 420.83 245.4 422.27 245.4C423.77 245.4 425.135 245.805 426.365 246.615C427.595 247.395 428.57 248.46 429.29 249.81C430.01 251.13 430.37 252.615 430.37 254.265V258.405C430.37 259.965 429.995 261.435 429.245 262.815C428.525 264.165 427.565 265.26 426.365 266.1C425.165 266.94 423.86 267.36 422.45 267.36C421.1 267.36 419.885 267.015 418.805 266.325C417.725 265.605 416.96 264.78 416.51 263.85V275.55C416.51 275.94 416.27 276.3 415.79 276.63C415.34 276.96 414.77 277.125 414.08 277.125ZM421.055 263.175C421.865 263.175 422.615 262.95 423.305 262.5C423.995 262.05 424.55 261.45 424.97 260.7C425.42 259.95 425.645 259.185 425.645 258.405V254.265C425.645 253.485 425.435 252.735 425.015 252.015C424.595 251.295 424.025 250.71 423.305 250.26C422.615 249.81 421.835 249.585 420.965 249.585C420.245 249.585 419.54 249.78 418.85 250.17C418.16 250.53 417.59 251.055 417.14 251.745C416.72 252.435 416.51 253.275 416.51 254.265V259.44C416.51 259.8 416.705 260.28 417.095 260.88C417.485 261.45 418.025 261.975 418.715 262.455C419.405 262.935 420.185 263.175 421.055 263.175ZM436.798 267C436.138 267 435.583 266.835 435.133 266.505C434.713 266.175 434.503 265.815 434.503 265.425V247.2C434.503 246.75 434.713 246.39 435.133 246.12C435.583 245.82 436.138 245.67 436.798 245.67C437.398 245.67 437.908 245.82 438.328 246.12C438.748 246.39 438.958 246.75 438.958 247.2V249.18C439.288 248.55 439.723 247.95 440.263 247.38C440.833 246.81 441.493 246.345 442.243 245.985C442.993 245.595 443.803 245.4 444.673 245.4H446.113C446.593 245.4 447.013 245.61 447.373 246.03C447.733 246.42 447.913 246.9 447.913 247.47C447.913 248.04 447.733 248.535 447.373 248.955C447.013 249.375 446.593 249.585 446.113 249.585H444.673C443.773 249.585 442.903 249.855 442.063 250.395C441.223 250.935 440.533 251.7 439.993 252.69C439.483 253.65 439.228 254.82 439.228 256.2V265.425C439.228 265.815 438.988 266.175 438.508 266.505C438.058 266.835 437.488 267 436.798 267ZM454.695 267.36C453.045 267.36 451.635 266.88 450.465 265.92C449.295 264.93 448.71 263.43 448.71 261.42C448.71 259.71 449.16 258.39 450.06 257.46C450.96 256.53 452.19 255.885 453.75 255.525C455.34 255.165 457.17 254.985 459.24 254.985H461.22V254.175C461.22 253.395 461.07 252.645 460.77 251.925C460.5 251.175 460.035 250.56 459.375 250.08C458.745 249.57 457.875 249.315 456.765 249.315C455.655 249.315 454.8 249.42 454.2 249.63C453.6 249.84 453.12 250.065 452.76 250.305C452.4 250.545 452.07 250.665 451.77 250.665C451.23 250.665 450.81 250.41 450.51 249.9C450.21 249.36 450.06 248.82 450.06 248.28C450.06 247.74 450.405 247.26 451.095 246.84C451.815 246.39 452.7 246.045 453.75 245.805C454.8 245.535 455.835 245.4 456.855 245.4C459.075 245.4 460.845 245.82 462.165 246.66C463.485 247.47 464.445 248.535 465.045 249.855C465.645 251.175 465.945 252.6 465.945 254.13V265.425C465.945 265.845 465.72 266.22 465.27 266.55C464.85 266.85 464.31 267 463.65 267C463.05 267 462.54 266.85 462.12 266.55C461.7 266.22 461.49 265.845 461.49 265.425V263.85C460.71 264.75 459.765 265.56 458.655 266.28C457.545 267 456.225 267.36 454.695 267.36ZM456.405 263.76C457.155 263.76 457.89 263.535 458.61 263.085C459.36 262.635 459.975 262.065 460.455 261.375C460.965 260.685 461.22 259.98 461.22 259.26V257.595H460.095C458.955 257.595 457.875 257.67 456.855 257.82C455.835 257.94 455.01 258.24 454.38 258.72C453.78 259.17 453.48 259.875 453.48 260.835C453.48 261.855 453.75 262.605 454.29 263.085C454.86 263.535 455.565 263.76 456.405 263.76ZM479.354 267.36C477.194 267.36 475.409 266.97 473.999 266.19C472.619 265.41 471.599 264.345 470.939 262.995C470.279 261.645 469.949 260.115 469.949 258.405V254.355C469.949 252.675 470.279 251.16 470.939 249.81C471.599 248.43 472.619 247.35 473.999 246.57C475.379 245.79 477.134 245.4 479.264 245.4C480.644 245.4 481.844 245.565 482.864 245.895C483.914 246.225 484.724 246.645 485.294 247.155C485.894 247.635 486.194 248.145 486.194 248.685C486.194 248.955 486.104 249.285 485.924 249.675C485.774 250.035 485.549 250.35 485.249 250.62C484.979 250.86 484.649 250.98 484.259 250.98C483.959 250.98 483.629 250.86 483.269 250.62C482.939 250.38 482.489 250.155 481.919 249.945C481.349 249.705 480.584 249.585 479.624 249.585C477.944 249.585 476.699 250.005 475.889 250.845C475.079 251.685 474.674 252.855 474.674 254.355V258.405C474.674 259.905 475.079 261.075 475.889 261.915C476.699 262.755 477.959 263.175 479.669 263.175C480.659 263.175 481.439 263.055 482.009 262.815C482.579 262.545 483.029 262.29 483.359 262.05C483.719 261.81 484.064 261.69 484.394 261.69C484.814 261.69 485.174 261.81 485.474 262.05C485.804 262.29 486.044 262.59 486.194 262.95C486.374 263.31 486.464 263.64 486.464 263.94C486.464 264.45 486.149 264.975 485.519 265.515C484.919 266.055 484.079 266.505 482.999 266.865C481.949 267.195 480.734 267.36 479.354 267.36ZM497.615 267C495.065 267 493.115 266.445 491.765 265.335C490.415 264.195 489.74 262.41 489.74 259.98V237.435C489.74 236.985 489.98 236.625 490.46 236.355C490.97 236.055 491.51 235.905 492.08 235.905C492.65 235.905 493.19 236.055 493.7 236.355C494.21 236.625 494.465 236.985 494.465 237.435V245.67H499.955C500.375 245.67 500.69 245.85 500.9 246.21C501.14 246.57 501.26 246.975 501.26 247.425C501.26 247.875 501.14 248.28 500.9 248.64C500.69 249 500.375 249.18 499.955 249.18H494.465V259.98C494.465 261.06 494.69 261.825 495.14 262.275C495.62 262.725 496.445 262.95 497.615 262.95H499.145C499.835 262.95 500.345 263.16 500.675 263.58C501.035 263.97 501.215 264.435 501.215 264.975C501.215 265.485 501.035 265.95 500.675 266.37C500.345 266.79 499.835 267 499.145 267H497.615ZM506.848 240.315C506.098 240.315 505.453 240.06 504.913 239.55C504.373 239.04 504.103 238.47 504.103 237.84C504.103 237.15 504.373 236.565 504.913 236.085C505.453 235.605 506.098 235.365 506.848 235.365C507.598 235.365 508.228 235.605 508.738 236.085C509.278 236.565 509.548 237.15 509.548 237.84C509.548 238.47 509.278 239.04 508.738 239.55C508.228 240.06 507.598 240.315 506.848 240.315ZM506.848 267C506.158 267 505.588 266.835 505.138 266.505C504.718 266.175 504.508 265.815 504.508 265.425V247.2C504.508 246.75 504.718 246.39 505.138 246.12C505.588 245.82 506.158 245.67 506.848 245.67C507.508 245.67 508.063 245.82 508.513 246.12C508.993 246.39 509.233 246.75 509.233 247.2V265.425C509.233 265.815 508.993 266.175 508.513 266.505C508.063 266.835 507.508 267 506.848 267ZM522.772 267.36C520.612 267.36 518.827 266.97 517.417 266.19C516.037 265.41 515.017 264.345 514.357 262.995C513.697 261.645 513.367 260.115 513.367 258.405V254.355C513.367 252.675 513.697 251.16 514.357 249.81C515.017 248.43 516.037 247.35 517.417 246.57C518.797 245.79 520.552 245.4 522.682 245.4C524.062 245.4 525.262 245.565 526.282 245.895C527.332 246.225 528.142 246.645 528.712 247.155C529.312 247.635 529.612 248.145 529.612 248.685C529.612 248.955 529.522 249.285 529.342 249.675C529.192 250.035 528.967 250.35 528.667 250.62C528.397 250.86 528.067 250.98 527.677 250.98C527.377 250.98 527.047 250.86 526.687 250.62C526.357 250.38 525.907 250.155 525.337 249.945C524.767 249.705 524.002 249.585 523.042 249.585C521.362 249.585 520.117 250.005 519.307 250.845C518.497 251.685 518.092 252.855 518.092 254.355V258.405C518.092 259.905 518.497 261.075 519.307 261.915C520.117 262.755 521.377 263.175 523.087 263.175C524.077 263.175 524.857 263.055 525.427 262.815C525.997 262.545 526.447 262.29 526.777 262.05C527.137 261.81 527.482 261.69 527.812 261.69C528.232 261.69 528.592 261.81 528.892 262.05C529.222 262.29 529.462 262.59 529.612 262.95C529.792 263.31 529.882 263.64 529.882 263.94C529.882 264.45 529.567 264.975 528.937 265.515C528.337 266.055 527.497 266.505 526.417 266.865C525.367 267.195 524.152 267.36 522.772 267.36ZM542.659 267.36C540.619 267.36 538.819 266.985 537.259 266.235C535.699 265.485 534.469 264.45 533.569 263.13C532.669 261.78 532.219 260.205 532.219 258.405V254.13C532.219 252.54 532.639 251.085 533.479 249.765C534.349 248.445 535.489 247.395 536.899 246.615C538.309 245.805 539.869 245.4 541.579 245.4C543.199 245.4 544.684 245.76 546.034 246.48C547.384 247.17 548.464 248.145 549.274 249.405C550.114 250.665 550.534 252.105 550.534 253.725C550.534 254.985 550.339 255.885 549.949 256.425C549.559 256.965 549.049 257.295 548.419 257.415C547.789 257.535 547.129 257.595 546.439 257.595H536.944V258.63C536.944 260.13 537.484 261.33 538.564 262.23C539.674 263.1 541.084 263.535 542.794 263.535C543.844 263.535 544.699 263.385 545.359 263.085C546.019 262.785 546.574 262.5 547.024 262.23C547.474 261.96 547.894 261.825 548.284 261.825C548.674 261.825 549.004 261.945 549.274 262.185C549.544 262.425 549.754 262.71 549.904 263.04C550.054 263.37 550.129 263.67 550.129 263.94C550.129 264.39 549.814 264.885 549.184 265.425C548.584 265.965 547.729 266.43 546.619 266.82C545.509 267.18 544.189 267.36 542.659 267.36ZM536.944 254.67H544.414C545.074 254.67 545.509 254.58 545.719 254.4C545.959 254.22 546.079 253.86 546.079 253.32C546.079 252.54 545.884 251.82 545.494 251.16C545.104 250.47 544.564 249.945 543.874 249.585C543.184 249.195 542.404 249 541.534 249C540.694 249 539.929 249.18 539.239 249.54C538.549 249.9 537.994 250.395 537.574 251.025C537.154 251.655 536.944 252.39 536.944 253.23V254.67ZM560.911 267.36C559.441 267.36 558.121 267.18 556.951 266.82C555.781 266.46 554.851 266.01 554.161 265.47C553.501 264.9 553.171 264.33 553.171 263.76C553.171 263.49 553.231 263.19 553.351 262.86C553.501 262.53 553.696 262.245 553.936 262.005C554.206 261.765 554.491 261.645 554.791 261.645C555.181 261.645 555.586 261.825 556.006 262.185C556.456 262.515 557.041 262.86 557.761 263.22C558.481 263.55 559.486 263.715 560.776 263.715C562.276 263.715 563.281 263.46 563.791 262.95C564.331 262.44 564.601 261.885 564.601 261.285C564.601 260.505 564.331 259.905 563.791 259.485C563.281 259.035 562.606 258.675 561.766 258.405C560.956 258.135 560.086 257.88 559.156 257.64C558.226 257.37 557.341 257.025 556.501 256.605C555.691 256.185 555.016 255.6 554.476 254.85C553.966 254.1 553.711 253.11 553.711 251.88C553.711 250.86 553.966 249.855 554.476 248.865C554.986 247.845 555.796 247.02 556.906 246.39C558.046 245.73 559.561 245.4 561.451 245.4C562.591 245.4 563.671 245.52 564.691 245.76C565.711 246 566.551 246.33 567.211 246.75C567.871 247.14 568.201 247.575 568.201 248.055C568.201 248.265 568.126 248.565 567.976 248.955C567.826 249.315 567.616 249.645 567.346 249.945C567.106 250.215 566.791 250.35 566.401 250.35C566.101 250.35 565.726 250.245 565.276 250.035C564.826 249.795 564.301 249.57 563.701 249.36C563.101 249.15 562.366 249.045 561.496 249.045C560.626 249.045 559.921 249.195 559.381 249.495C558.871 249.765 558.496 250.095 558.256 250.485C558.016 250.875 557.896 251.265 557.896 251.655C557.896 252.315 558.151 252.825 558.661 253.185C559.171 253.545 559.846 253.845 560.686 254.085C561.526 254.325 562.411 254.58 563.341 254.85C564.271 255.09 565.141 255.45 565.951 255.93C566.791 256.41 567.466 257.055 567.976 257.865C568.516 258.675 568.786 259.755 568.786 261.105C568.786 262.995 568.096 264.51 566.716 265.65C565.366 266.79 563.431 267.36 560.911 267.36ZM574.332 267.27C573.552 267.27 572.907 267 572.397 266.46C571.887 265.92 571.632 265.29 571.632 264.57C571.632 263.82 571.887 263.19 572.397 262.68C572.907 262.14 573.552 261.87 574.332 261.87C575.052 261.87 575.667 262.14 576.177 262.68C576.717 263.19 576.987 263.82 576.987 264.57C576.987 265.29 576.717 265.92 576.177 266.46C575.667 267 575.052 267.27 574.332 267.27ZM582.55 267.27C581.77 267.27 581.125 267 580.615 266.46C580.105 265.92 579.85 265.29 579.85 264.57C579.85 263.82 580.105 263.19 580.615 262.68C581.125 262.14 581.77 261.87 582.55 261.87C583.27 261.87 583.885 262.14 584.395 262.68C584.935 263.19 585.205 263.82 585.205 264.57C585.205 265.29 584.935 265.92 584.395 266.46C583.885 267 583.27 267.27 582.55 267.27ZM590.768 267.27C589.988 267.27 589.343 267 588.833 266.46C588.323 265.92 588.068 265.29 588.068 264.57C588.068 263.82 588.323 263.19 588.833 262.68C589.343 262.14 589.988 261.87 590.768 261.87C591.488 261.87 592.103 262.14 592.613 262.68C593.153 263.19 593.423 263.82 593.423 264.57C593.423 265.29 593.153 265.92 592.613 266.46C592.103 267 591.488 267.27 590.768 267.27Z\" fill=\"#FF0082\"/> <path d=\"M138.829 363C138.319 363 137.839 362.865 137.389 362.595C136.939 362.325 136.714 361.935 136.714 361.425V331.635C136.714 331.095 136.954 330.705 137.434 330.465C137.944 330.225 138.499 330.105 139.099 330.105C139.699 330.105 140.239 330.225 140.719 330.465C141.229 330.705 141.484 331.095 141.484 331.635V358.77H153.184C153.664 358.77 154.024 358.995 154.264 359.445C154.504 359.865 154.624 360.345 154.624 360.885C154.624 361.395 154.504 361.875 154.264 362.325C154.024 362.775 153.664 363 153.184 363H138.829ZM166.547 363.36C164.507 363.36 162.707 362.985 161.147 362.235C159.587 361.485 158.357 360.45 157.457 359.13C156.557 357.78 156.107 356.205 156.107 354.405V350.13C156.107 348.54 156.527 347.085 157.367 345.765C158.237 344.445 159.377 343.395 160.787 342.615C162.197 341.805 163.757 341.4 165.467 341.4C167.087 341.4 168.572 341.76 169.922 342.48C171.272 343.17 172.352 344.145 173.162 345.405C174.002 346.665 174.422 348.105 174.422 349.725C174.422 350.985 174.227 351.885 173.837 352.425C173.447 352.965 172.937 353.295 172.307 353.415C171.677 353.535 171.017 353.595 170.327 353.595H160.832V354.63C160.832 356.13 161.372 357.33 162.452 358.23C163.562 359.1 164.972 359.535 166.682 359.535C167.732 359.535 168.587 359.385 169.247 359.085C169.907 358.785 170.462 358.5 170.912 358.23C171.362 357.96 171.782 357.825 172.172 357.825C172.562 357.825 172.892 357.945 173.162 358.185C173.432 358.425 173.642 358.71 173.792 359.04C173.942 359.37 174.017 359.67 174.017 359.94C174.017 360.39 173.702 360.885 173.072 361.425C172.472 361.965 171.617 362.43 170.507 362.82C169.397 363.18 168.077 363.36 166.547 363.36ZM160.832 350.67H168.302C168.962 350.67 169.397 350.58 169.607 350.4C169.847 350.22 169.967 349.86 169.967 349.32C169.967 348.54 169.772 347.82 169.382 347.16C168.992 346.47 168.452 345.945 167.762 345.585C167.072 345.195 166.292 345 165.422 345C164.582 345 163.817 345.18 163.127 345.54C162.437 345.9 161.882 346.395 161.462 347.025C161.042 347.655 160.832 348.39 160.832 349.23V350.67ZM182.91 363.36C181.26 363.36 179.85 362.88 178.68 361.92C177.51 360.93 176.925 359.43 176.925 357.42C176.925 355.71 177.375 354.39 178.275 353.46C179.175 352.53 180.405 351.885 181.965 351.525C183.555 351.165 185.385 350.985 187.455 350.985H189.435V350.175C189.435 349.395 189.285 348.645 188.985 347.925C188.715 347.175 188.25 346.56 187.59 346.08C186.96 345.57 186.09 345.315 184.98 345.315C183.87 345.315 183.015 345.42 182.415 345.63C181.815 345.84 181.335 346.065 180.975 346.305C180.615 346.545 180.285 346.665 179.985 346.665C179.445 346.665 179.025 346.41 178.725 345.9C178.425 345.36 178.275 344.82 178.275 344.28C178.275 343.74 178.62 343.26 179.31 342.84C180.03 342.39 180.915 342.045 181.965 341.805C183.015 341.535 184.05 341.4 185.07 341.4C187.29 341.4 189.06 341.82 190.38 342.66C191.7 343.47 192.66 344.535 193.26 345.855C193.86 347.175 194.16 348.6 194.16 350.13V361.425C194.16 361.845 193.935 362.22 193.485 362.55C193.065 362.85 192.525 363 191.865 363C191.265 363 190.755 362.85 190.335 362.55C189.915 362.22 189.705 361.845 189.705 361.425V359.85C188.925 360.75 187.98 361.56 186.87 362.28C185.76 363 184.44 363.36 182.91 363.36ZM184.62 359.76C185.37 359.76 186.105 359.535 186.825 359.085C187.575 358.635 188.19 358.065 188.67 357.375C189.18 356.685 189.435 355.98 189.435 355.26V353.595H188.31C187.17 353.595 186.09 353.67 185.07 353.82C184.05 353.94 183.225 354.24 182.595 354.72C181.995 355.17 181.695 355.875 181.695 356.835C181.695 357.855 181.965 358.605 182.505 359.085C183.075 359.535 183.78 359.76 184.62 359.76ZM201.224 363C200.564 363 200.009 362.835 199.559 362.505C199.139 362.175 198.929 361.815 198.929 361.425V343.2C198.929 342.75 199.139 342.39 199.559 342.12C200.009 341.82 200.564 341.67 201.224 341.67C201.824 341.67 202.334 341.82 202.754 342.12C203.174 342.39 203.384 342.75 203.384 343.2V345.18C203.714 344.55 204.149 343.95 204.689 343.38C205.259 342.81 205.919 342.345 206.669 341.985C207.419 341.595 208.229 341.4 209.099 341.4H210.539C211.019 341.4 211.439 341.61 211.799 342.03C212.159 342.42 212.339 342.9 212.339 343.47C212.339 344.04 212.159 344.535 211.799 344.955C211.439 345.375 211.019 345.585 210.539 345.585H209.099C208.199 345.585 207.329 345.855 206.489 346.395C205.649 346.935 204.959 347.7 204.419 348.69C203.909 349.65 203.654 350.82 203.654 352.2V361.425C203.654 361.815 203.414 362.175 202.934 362.505C202.484 362.835 201.914 363 201.224 363ZM217.397 363C216.707 363 216.137 362.835 215.687 362.505C215.267 362.175 215.057 361.815 215.057 361.425V343.2C215.057 342.75 215.267 342.39 215.687 342.12C216.137 341.82 216.707 341.67 217.397 341.67C217.967 341.67 218.462 341.82 218.882 342.12C219.302 342.39 219.512 342.75 219.512 343.2V344.82C219.962 343.95 220.697 343.17 221.717 342.48C222.767 341.76 224.042 341.4 225.542 341.4C226.952 341.4 228.242 341.805 229.412 342.615C230.612 343.395 231.572 344.46 232.292 345.81C233.012 347.13 233.372 348.615 233.372 350.265V361.425C233.372 361.935 233.117 362.325 232.607 362.595C232.127 362.865 231.587 363 230.987 363C230.447 363 229.922 362.865 229.412 362.595C228.902 362.325 228.647 361.935 228.647 361.425V350.265C228.647 349.485 228.437 348.735 228.017 348.015C227.627 347.295 227.087 346.71 226.397 346.26C225.707 345.81 224.942 345.585 224.102 345.585C223.382 345.585 222.692 345.78 222.032 346.17C221.372 346.53 220.832 347.055 220.412 347.745C219.992 348.435 219.782 349.275 219.782 350.265V361.425C219.782 361.815 219.542 362.175 219.062 362.505C218.612 362.835 218.057 363 217.397 363ZM249.433 363C248.743 363 248.173 362.835 247.723 362.505C247.303 362.175 247.093 361.815 247.093 361.425V343.2C247.093 342.75 247.303 342.39 247.723 342.12C248.173 341.82 248.743 341.67 249.433 341.67C250.003 341.67 250.498 341.82 250.918 342.12C251.338 342.39 251.548 342.75 251.548 343.2V344.82C252.058 343.95 252.808 343.17 253.798 342.48C254.788 341.76 256.033 341.4 257.533 341.4C258.883 341.4 260.068 341.82 261.088 342.66C262.138 343.5 262.918 344.58 263.428 345.9C264.208 344.37 265.213 343.245 266.443 342.525C267.673 341.775 268.933 341.4 270.223 341.4C271.573 341.4 272.833 341.745 274.003 342.435C275.203 343.125 276.178 344.13 276.928 345.45C277.678 346.77 278.053 348.375 278.053 350.265V361.425C278.053 361.815 277.813 362.175 277.333 362.505C276.883 362.835 276.328 363 275.668 363C275.038 363 274.483 362.835 274.003 362.505C273.553 362.175 273.328 361.815 273.328 361.425V350.265C273.328 349.245 273.118 348.39 272.698 347.7C272.308 346.98 271.783 346.44 271.123 346.08C270.493 345.72 269.833 345.54 269.143 345.54C268.423 345.54 267.748 345.735 267.118 346.125C266.488 346.485 265.963 347.01 265.543 347.7C265.123 348.36 264.913 349.185 264.913 350.175V361.47C264.913 362.01 264.658 362.4 264.148 362.64C263.668 362.88 263.128 363 262.528 363C261.988 363 261.463 362.88 260.953 362.64C260.443 362.4 260.188 362.01 260.188 361.47V350.22C260.188 349.26 259.993 348.435 259.603 347.745C259.213 347.055 258.703 346.53 258.073 346.17C257.443 345.78 256.753 345.585 256.003 345.585C255.313 345.585 254.638 345.765 253.978 346.125C253.348 346.485 252.823 347.01 252.403 347.7C252.013 348.39 251.818 349.245 251.818 350.265V361.425C251.818 361.815 251.578 362.175 251.098 362.505C250.648 362.835 250.093 363 249.433 363ZM291.236 363.36C289.616 363.36 288.101 362.94 286.691 362.1C285.281 361.26 284.141 360.165 283.271 358.815C282.431 357.435 282.011 355.965 282.011 354.405V350.265C282.011 348.675 282.416 347.205 283.226 345.855C284.066 344.505 285.191 343.425 286.601 342.615C288.041 341.805 289.601 341.4 291.281 341.4C292.961 341.4 294.506 341.805 295.916 342.615C297.326 343.395 298.451 344.46 299.291 345.81C300.161 347.13 300.596 348.615 300.596 350.265V354.405C300.596 355.935 300.161 357.39 299.291 358.77C298.451 360.15 297.311 361.26 295.871 362.1C294.461 362.94 292.916 363.36 291.236 363.36ZM291.281 359.175C292.121 359.175 292.886 358.95 293.576 358.5C294.266 358.05 294.821 357.465 295.241 356.745C295.661 355.995 295.871 355.215 295.871 354.405V350.265C295.871 349.485 295.661 348.735 295.241 348.015C294.821 347.295 294.266 346.71 293.576 346.26C292.886 345.81 292.121 345.585 291.281 345.585C290.411 345.585 289.631 345.81 288.941 346.26C288.281 346.71 287.741 347.295 287.321 348.015C286.931 348.735 286.736 349.485 286.736 350.265V354.405C286.736 355.215 286.931 355.995 287.321 356.745C287.741 357.465 288.296 358.05 288.986 358.5C289.676 358.95 290.441 359.175 291.281 359.175ZM307 363C306.34 363 305.785 362.835 305.335 362.505C304.915 362.175 304.705 361.815 304.705 361.425V343.2C304.705 342.75 304.915 342.39 305.335 342.12C305.785 341.82 306.34 341.67 307 341.67C307.6 341.67 308.11 341.82 308.53 342.12C308.95 342.39 309.16 342.75 309.16 343.2V345.18C309.49 344.55 309.925 343.95 310.465 343.38C311.035 342.81 311.695 342.345 312.445 341.985C313.195 341.595 314.005 341.4 314.875 341.4H316.315C316.795 341.4 317.215 341.61 317.575 342.03C317.935 342.42 318.115 342.9 318.115 343.47C318.115 344.04 317.935 344.535 317.575 344.955C317.215 345.375 316.795 345.585 316.315 345.585H314.875C313.975 345.585 313.105 345.855 312.265 346.395C311.425 346.935 310.735 347.7 310.195 348.69C309.685 349.65 309.43 350.82 309.43 352.2V361.425C309.43 361.815 309.19 362.175 308.71 362.505C308.26 362.835 307.69 363 307 363ZM329.76 363.36C327.72 363.36 325.92 362.985 324.36 362.235C322.8 361.485 321.57 360.45 320.67 359.13C319.77 357.78 319.32 356.205 319.32 354.405V350.13C319.32 348.54 319.74 347.085 320.58 345.765C321.45 344.445 322.59 343.395 324 342.615C325.41 341.805 326.97 341.4 328.68 341.4C330.3 341.4 331.785 341.76 333.135 342.48C334.485 343.17 335.565 344.145 336.375 345.405C337.215 346.665 337.635 348.105 337.635 349.725C337.635 350.985 337.44 351.885 337.05 352.425C336.66 352.965 336.15 353.295 335.52 353.415C334.89 353.535 334.23 353.595 333.54 353.595H324.045V354.63C324.045 356.13 324.585 357.33 325.665 358.23C326.775 359.1 328.185 359.535 329.895 359.535C330.945 359.535 331.8 359.385 332.46 359.085C333.12 358.785 333.675 358.5 334.125 358.23C334.575 357.96 334.995 357.825 335.385 357.825C335.775 357.825 336.105 357.945 336.375 358.185C336.645 358.425 336.855 358.71 337.005 359.04C337.155 359.37 337.23 359.67 337.23 359.94C337.23 360.39 336.915 360.885 336.285 361.425C335.685 361.965 334.83 362.43 333.72 362.82C332.61 363.18 331.29 363.36 329.76 363.36ZM324.045 350.67H331.515C332.175 350.67 332.61 350.58 332.82 350.4C333.06 350.22 333.18 349.86 333.18 349.32C333.18 348.54 332.985 347.82 332.595 347.16C332.205 346.47 331.665 345.945 330.975 345.585C330.285 345.195 329.505 345 328.635 345C327.795 345 327.03 345.18 326.34 345.54C325.65 345.9 325.095 346.395 324.675 347.025C324.255 347.655 324.045 348.39 324.045 349.23V350.67ZM358.281 363C355.731 363 353.781 362.445 352.431 361.335C351.081 360.195 350.406 358.41 350.406 355.98V333.435C350.406 332.985 350.646 332.625 351.126 332.355C351.636 332.055 352.176 331.905 352.746 331.905C353.316 331.905 353.856 332.055 354.366 332.355C354.876 332.625 355.131 332.985 355.131 333.435V341.67H360.621C361.041 341.67 361.356 341.85 361.566 342.21C361.806 342.57 361.926 342.975 361.926 343.425C361.926 343.875 361.806 344.28 361.566 344.64C361.356 345 361.041 345.18 360.621 345.18H355.131V355.98C355.131 357.06 355.356 357.825 355.806 358.275C356.286 358.725 357.111 358.95 358.281 358.95H359.811C360.501 358.95 361.011 359.16 361.341 359.58C361.701 359.97 361.881 360.435 361.881 360.975C361.881 361.485 361.701 361.95 361.341 362.37C361.011 362.79 360.501 363 359.811 363H358.281ZM367.559 363C366.869 363 366.299 362.835 365.849 362.505C365.429 362.175 365.219 361.815 365.219 361.425V330.51C365.219 330.06 365.429 329.7 365.849 329.43C366.299 329.13 366.869 328.98 367.559 328.98C368.219 328.98 368.774 329.13 369.224 329.43C369.704 329.7 369.944 330.06 369.944 330.51V344.82C370.394 343.95 371.099 343.17 372.059 342.48C373.049 341.76 374.264 341.4 375.704 341.4C377.114 341.4 378.404 341.805 379.574 342.615C380.774 343.395 381.734 344.46 382.454 345.81C383.174 347.13 383.534 348.615 383.534 350.265V361.425C383.534 361.935 383.279 362.325 382.769 362.595C382.289 362.865 381.749 363 381.149 363C380.609 363 380.084 362.865 379.574 362.595C379.064 362.325 378.809 361.935 378.809 361.425V350.265C378.809 349.485 378.599 348.735 378.179 348.015C377.759 347.295 377.204 346.71 376.514 346.26C375.854 345.81 375.104 345.585 374.264 345.585C373.544 345.585 372.854 345.78 372.194 346.17C371.534 346.53 370.994 347.055 370.574 347.745C370.154 348.435 369.944 349.275 369.944 350.265V361.425C369.944 361.815 369.704 362.175 369.224 362.505C368.774 362.835 368.219 363 367.559 363ZM390.541 363C389.881 363 389.326 362.835 388.876 362.505C388.456 362.175 388.246 361.815 388.246 361.425V343.2C388.246 342.75 388.456 342.39 388.876 342.12C389.326 341.82 389.881 341.67 390.541 341.67C391.141 341.67 391.651 341.82 392.071 342.12C392.491 342.39 392.701 342.75 392.701 343.2V345.18C393.031 344.55 393.466 343.95 394.006 343.38C394.576 342.81 395.236 342.345 395.986 341.985C396.736 341.595 397.546 341.4 398.416 341.4H399.856C400.336 341.4 400.756 341.61 401.116 342.03C401.476 342.42 401.656 342.9 401.656 343.47C401.656 344.04 401.476 344.535 401.116 344.955C400.756 345.375 400.336 345.585 399.856 345.585H398.416C397.516 345.585 396.646 345.855 395.806 346.395C394.966 346.935 394.276 347.7 393.736 348.69C393.226 349.65 392.971 350.82 392.971 352.2V361.425C392.971 361.815 392.731 362.175 392.251 362.505C391.801 362.835 391.231 363 390.541 363ZM412.085 363.36C410.465 363.36 408.95 362.94 407.54 362.1C406.13 361.26 404.99 360.165 404.12 358.815C403.28 357.435 402.86 355.965 402.86 354.405V350.265C402.86 348.675 403.265 347.205 404.075 345.855C404.915 344.505 406.04 343.425 407.45 342.615C408.89 341.805 410.45 341.4 412.13 341.4C413.81 341.4 415.355 341.805 416.765 342.615C418.175 343.395 419.3 344.46 420.14 345.81C421.01 347.13 421.445 348.615 421.445 350.265V354.405C421.445 355.935 421.01 357.39 420.14 358.77C419.3 360.15 418.16 361.26 416.72 362.1C415.31 362.94 413.765 363.36 412.085 363.36ZM412.13 359.175C412.97 359.175 413.735 358.95 414.425 358.5C415.115 358.05 415.67 357.465 416.09 356.745C416.51 355.995 416.72 355.215 416.72 354.405V350.265C416.72 349.485 416.51 348.735 416.09 348.015C415.67 347.295 415.115 346.71 414.425 346.26C413.735 345.81 412.97 345.585 412.13 345.585C411.26 345.585 410.48 345.81 409.79 346.26C409.13 346.71 408.59 347.295 408.17 348.015C407.78 348.735 407.585 349.485 407.585 350.265V354.405C407.585 355.215 407.78 355.995 408.17 356.745C408.59 357.465 409.145 358.05 409.835 358.5C410.525 358.95 411.29 359.175 412.13 359.175ZM434.645 363.36C432.965 363.36 431.405 362.955 429.965 362.145C428.555 361.305 427.43 360.21 426.59 358.86C425.75 357.48 425.33 356.025 425.33 354.495V343.245C425.33 342.855 425.555 342.495 426.005 342.165C426.485 341.835 427.055 341.67 427.715 341.67C428.345 341.67 428.885 341.835 429.335 342.165C429.815 342.495 430.055 342.855 430.055 343.245V354.495C430.055 355.275 430.25 356.025 430.64 356.745C431.06 357.465 431.615 358.05 432.305 358.5C433.025 358.95 433.805 359.175 434.645 359.175C435.485 359.175 436.25 358.95 436.94 358.5C437.63 358.05 438.17 357.465 438.56 356.745C438.98 356.025 439.19 355.275 439.19 354.495V343.2C439.19 342.78 439.43 342.42 439.91 342.12C440.42 341.82 440.975 341.67 441.575 341.67C442.265 341.67 442.82 341.82 443.24 342.12C443.69 342.42 443.915 342.78 443.915 343.2V354.495C443.915 356.085 443.495 357.555 442.655 358.905C441.815 360.255 440.69 361.335 439.28 362.145C437.87 362.955 436.325 363.36 434.645 363.36ZM456.681 373.125C454.941 373.125 453.336 372.87 451.866 372.36C450.396 371.88 449.226 371.175 448.356 370.245C447.486 369.315 447.051 368.205 447.051 366.915C447.051 365.715 447.396 364.71 448.086 363.9C448.776 363.12 449.586 362.52 450.516 362.1C449.916 361.83 449.421 361.47 449.031 361.02C448.641 360.57 448.446 359.94 448.446 359.13C448.446 358.29 448.656 357.615 449.076 357.105C449.496 356.595 450.036 356.13 450.696 355.71C449.856 355.05 449.196 354.24 448.716 353.28C448.266 352.29 448.041 351.21 448.041 350.04V348.78C448.041 347.34 448.386 346.065 449.076 344.955C449.766 343.845 450.741 342.975 452.001 342.345C453.291 341.715 454.761 341.4 456.411 341.4C457.431 341.4 458.376 341.535 459.246 341.805C460.146 342.075 460.941 342.45 461.631 342.93C462.111 341.82 462.591 341.04 463.071 340.59C463.581 340.14 464.061 339.915 464.511 339.915C465.141 339.915 465.621 340.095 465.951 340.455C466.281 340.815 466.446 341.175 466.446 341.535C466.446 341.775 466.371 342 466.221 342.21C466.101 342.39 465.921 342.54 465.681 342.66C465.381 342.81 465.021 343.02 464.601 343.29C464.211 343.53 463.821 343.92 463.431 344.46C463.941 345.03 464.316 345.69 464.556 346.44C464.796 347.19 464.916 347.97 464.916 348.78V350.04C464.916 351.45 464.556 352.725 463.836 353.865C463.116 355.005 462.111 355.905 460.821 356.565C459.531 357.195 458.061 357.51 456.411 357.51C455.241 357.51 454.206 357.33 453.306 356.97C453.066 357.12 452.856 357.3 452.676 357.51C452.526 357.69 452.451 357.93 452.451 358.23C452.451 358.77 452.781 359.16 453.441 359.4C454.101 359.64 454.941 359.82 455.961 359.94C457.011 360.06 458.121 360.21 459.291 360.39C460.461 360.57 461.556 360.87 462.576 361.29C463.626 361.68 464.481 362.265 465.141 363.045C465.801 363.855 466.131 364.95 466.131 366.33C466.131 367.89 465.696 369.165 464.826 370.155C463.956 371.175 462.801 371.925 461.361 372.405C459.951 372.885 458.391 373.125 456.681 373.125ZM456.591 369.975C458.061 369.975 459.246 369.645 460.146 368.985C461.076 368.355 461.541 367.515 461.541 366.465C461.541 365.715 461.316 365.13 460.866 364.71C460.416 364.29 459.831 363.975 459.111 363.765C458.391 363.555 457.626 363.405 456.816 363.315C456.036 363.225 455.286 363.135 454.566 363.045C453.726 363.345 453.006 363.765 452.406 364.305C451.836 364.875 451.551 365.58 451.551 366.42C451.551 367.53 452.016 368.4 452.946 369.03C453.906 369.66 455.121 369.975 456.591 369.975ZM456.501 354.495C457.701 354.495 458.631 354.075 459.291 353.235C459.981 352.395 460.326 351.33 460.326 350.04V348.78C460.326 347.55 459.981 346.515 459.291 345.675C458.631 344.835 457.686 344.415 456.456 344.415C455.226 344.415 454.281 344.835 453.621 345.675C452.961 346.515 452.631 347.55 452.631 348.78V349.995C452.631 351.255 452.961 352.32 453.621 353.19C454.281 354.06 455.241 354.495 456.501 354.495ZM471.929 363C471.239 363 470.669 362.835 470.219 362.505C469.799 362.175 469.589 361.815 469.589 361.425V330.51C469.589 330.06 469.799 329.7 470.219 329.43C470.669 329.13 471.239 328.98 471.929 328.98C472.589 328.98 473.144 329.13 473.594 329.43C474.074 329.7 474.314 330.06 474.314 330.51V344.82C474.764 343.95 475.469 343.17 476.429 342.48C477.419 341.76 478.634 341.4 480.074 341.4C481.484 341.4 482.774 341.805 483.944 342.615C485.144 343.395 486.104 344.46 486.824 345.81C487.544 347.13 487.904 348.615 487.904 350.265V361.425C487.904 361.935 487.649 362.325 487.139 362.595C486.659 362.865 486.119 363 485.519 363C484.979 363 484.454 362.865 483.944 362.595C483.434 362.325 483.179 361.935 483.179 361.425V350.265C483.179 349.485 482.969 348.735 482.549 348.015C482.129 347.295 481.574 346.71 480.884 346.26C480.224 345.81 479.474 345.585 478.634 345.585C477.914 345.585 477.224 345.78 476.564 346.17C475.904 346.53 475.364 347.055 474.944 347.745C474.524 348.435 474.314 349.275 474.314 350.265V361.425C474.314 361.815 474.074 362.175 473.594 362.505C473.144 362.835 472.589 363 471.929 363ZM509.409 363C506.859 363 504.909 362.445 503.559 361.335C502.209 360.195 501.534 358.41 501.534 355.98V333.435C501.534 332.985 501.774 332.625 502.254 332.355C502.764 332.055 503.304 331.905 503.874 331.905C504.444 331.905 504.984 332.055 505.494 332.355C506.004 332.625 506.259 332.985 506.259 333.435V341.67H511.749C512.169 341.67 512.484 341.85 512.694 342.21C512.934 342.57 513.054 342.975 513.054 343.425C513.054 343.875 512.934 344.28 512.694 344.64C512.484 345 512.169 345.18 511.749 345.18H506.259V355.98C506.259 357.06 506.484 357.825 506.934 358.275C507.414 358.725 508.239 358.95 509.409 358.95H510.939C511.629 358.95 512.139 359.16 512.469 359.58C512.829 359.97 513.009 360.435 513.009 360.975C513.009 361.485 512.829 361.95 512.469 362.37C512.139 362.79 511.629 363 510.939 363H509.409ZM518.687 363C517.997 363 517.427 362.835 516.977 362.505C516.557 362.175 516.347 361.815 516.347 361.425V330.51C516.347 330.06 516.557 329.7 516.977 329.43C517.427 329.13 517.997 328.98 518.687 328.98C519.347 328.98 519.902 329.13 520.352 329.43C520.832 329.7 521.072 330.06 521.072 330.51V344.82C521.522 343.95 522.227 343.17 523.187 342.48C524.177 341.76 525.392 341.4 526.832 341.4C528.242 341.4 529.532 341.805 530.702 342.615C531.902 343.395 532.862 344.46 533.582 345.81C534.302 347.13 534.662 348.615 534.662 350.265V361.425C534.662 361.935 534.407 362.325 533.897 362.595C533.417 362.865 532.877 363 532.277 363C531.737 363 531.212 362.865 530.702 362.595C530.192 362.325 529.937 361.935 529.937 361.425V350.265C529.937 349.485 529.727 348.735 529.307 348.015C528.887 347.295 528.332 346.71 527.642 346.26C526.982 345.81 526.232 345.585 525.392 345.585C524.672 345.585 523.982 345.78 523.322 346.17C522.662 346.53 522.122 347.055 521.702 347.745C521.282 348.435 521.072 349.275 521.072 350.265V361.425C521.072 361.815 520.832 362.175 520.352 362.505C519.902 362.835 519.347 363 518.687 363ZM549.003 363.36C546.963 363.36 545.163 362.985 543.603 362.235C542.043 361.485 540.813 360.45 539.913 359.13C539.013 357.78 538.563 356.205 538.563 354.405V350.13C538.563 348.54 538.983 347.085 539.823 345.765C540.693 344.445 541.833 343.395 543.243 342.615C544.653 341.805 546.213 341.4 547.923 341.4C549.543 341.4 551.028 341.76 552.378 342.48C553.728 343.17 554.808 344.145 555.618 345.405C556.458 346.665 556.878 348.105 556.878 349.725C556.878 350.985 556.683 351.885 556.293 352.425C555.903 352.965 555.393 353.295 554.763 353.415C554.133 353.535 553.473 353.595 552.783 353.595H543.288V354.63C543.288 356.13 543.828 357.33 544.908 358.23C546.018 359.1 547.428 359.535 549.138 359.535C550.188 359.535 551.043 359.385 551.703 359.085C552.363 358.785 552.918 358.5 553.368 358.23C553.818 357.96 554.238 357.825 554.628 357.825C555.018 357.825 555.348 357.945 555.618 358.185C555.888 358.425 556.098 358.71 556.248 359.04C556.398 359.37 556.473 359.67 556.473 359.94C556.473 360.39 556.158 360.885 555.528 361.425C554.928 361.965 554.073 362.43 552.963 362.82C551.853 363.18 550.533 363.36 549.003 363.36ZM543.288 350.67H550.758C551.418 350.67 551.853 350.58 552.063 350.4C552.303 350.22 552.423 349.86 552.423 349.32C552.423 348.54 552.228 347.82 551.838 347.16C551.448 346.47 550.908 345.945 550.218 345.585C549.528 345.195 548.748 345 547.878 345C547.038 345 546.273 345.18 545.583 345.54C544.893 345.9 544.338 346.395 543.918 347.025C543.498 347.655 543.288 348.39 543.288 349.23V350.67ZM108.632 420C107.942 420 107.372 419.835 106.922 419.505C106.502 419.175 106.292 418.815 106.292 418.425V400.2C106.292 399.75 106.502 399.39 106.922 399.12C107.372 398.82 107.942 398.67 108.632 398.67C109.202 398.67 109.697 398.82 110.117 399.12C110.537 399.39 110.747 399.75 110.747 400.2V401.82C111.257 400.95 112.007 400.17 112.997 399.48C113.987 398.76 115.232 398.4 116.732 398.4C118.082 398.4 119.267 398.82 120.287 399.66C121.337 400.5 122.117 401.58 122.627 402.9C123.407 401.37 124.412 400.245 125.642 399.525C126.872 398.775 128.132 398.4 129.422 398.4C130.772 398.4 132.032 398.745 133.202 399.435C134.402 400.125 135.377 401.13 136.127 402.45C136.877 403.77 137.252 405.375 137.252 407.265V418.425C137.252 418.815 137.012 419.175 136.532 419.505C136.082 419.835 135.527 420 134.867 420C134.237 420 133.682 419.835 133.202 419.505C132.752 419.175 132.527 418.815 132.527 418.425V407.265C132.527 406.245 132.317 405.39 131.897 404.7C131.507 403.98 130.982 403.44 130.322 403.08C129.692 402.72 129.032 402.54 128.342 402.54C127.622 402.54 126.947 402.735 126.317 403.125C125.687 403.485 125.162 404.01 124.742 404.7C124.322 405.36 124.112 406.185 124.112 407.175V418.47C124.112 419.01 123.857 419.4 123.347 419.64C122.867 419.88 122.327 420 121.727 420C121.187 420 120.662 419.88 120.152 419.64C119.642 419.4 119.387 419.01 119.387 418.47V407.22C119.387 406.26 119.192 405.435 118.802 404.745C118.412 404.055 117.902 403.53 117.272 403.17C116.642 402.78 115.952 402.585 115.202 402.585C114.512 402.585 113.837 402.765 113.177 403.125C112.547 403.485 112.022 404.01 111.602 404.7C111.212 405.39 111.017 406.245 111.017 407.265V418.425C111.017 418.815 110.777 419.175 110.297 419.505C109.847 419.835 109.292 420 108.632 420ZM146.655 420.36C145.005 420.36 143.595 419.88 142.425 418.92C141.255 417.93 140.67 416.43 140.67 414.42C140.67 412.71 141.12 411.39 142.02 410.46C142.92 409.53 144.15 408.885 145.71 408.525C147.3 408.165 149.13 407.985 151.2 407.985H153.18V407.175C153.18 406.395 153.03 405.645 152.73 404.925C152.46 404.175 151.995 403.56 151.335 403.08C150.705 402.57 149.835 402.315 148.725 402.315C147.615 402.315 146.76 402.42 146.16 402.63C145.56 402.84 145.08 403.065 144.72 403.305C144.36 403.545 144.03 403.665 143.73 403.665C143.19 403.665 142.77 403.41 142.47 402.9C142.17 402.36 142.02 401.82 142.02 401.28C142.02 400.74 142.365 400.26 143.055 399.84C143.775 399.39 144.66 399.045 145.71 398.805C146.76 398.535 147.795 398.4 148.815 398.4C151.035 398.4 152.805 398.82 154.125 399.66C155.445 400.47 156.405 401.535 157.005 402.855C157.605 404.175 157.905 405.6 157.905 407.13V418.425C157.905 418.845 157.68 419.22 157.23 419.55C156.81 419.85 156.27 420 155.61 420C155.01 420 154.5 419.85 154.08 419.55C153.66 419.22 153.45 418.845 153.45 418.425V416.85C152.67 417.75 151.725 418.56 150.615 419.28C149.505 420 148.185 420.36 146.655 420.36ZM148.365 416.76C149.115 416.76 149.85 416.535 150.57 416.085C151.32 415.635 151.935 415.065 152.415 414.375C152.925 413.685 153.18 412.98 153.18 412.26V410.595H152.055C150.915 410.595 149.835 410.67 148.815 410.82C147.795 410.94 146.97 411.24 146.34 411.72C145.74 412.17 145.44 412.875 145.44 413.835C145.44 414.855 145.71 415.605 146.25 416.085C146.82 416.535 147.525 416.76 148.365 416.76ZM170.459 420C167.909 420 165.959 419.445 164.609 418.335C163.259 417.195 162.584 415.41 162.584 412.98V390.435C162.584 389.985 162.824 389.625 163.304 389.355C163.814 389.055 164.354 388.905 164.924 388.905C165.494 388.905 166.034 389.055 166.544 389.355C167.054 389.625 167.309 389.985 167.309 390.435V398.67H172.799C173.219 398.67 173.534 398.85 173.744 399.21C173.984 399.57 174.104 399.975 174.104 400.425C174.104 400.875 173.984 401.28 173.744 401.64C173.534 402 173.219 402.18 172.799 402.18H167.309V412.98C167.309 414.06 167.534 414.825 167.984 415.275C168.464 415.725 169.289 415.95 170.459 415.95H171.989C172.679 415.95 173.189 416.16 173.519 416.58C173.879 416.97 174.059 417.435 174.059 417.975C174.059 418.485 173.879 418.95 173.519 419.37C173.189 419.79 172.679 420 171.989 420H170.459ZM185.684 420.36C183.524 420.36 181.739 419.97 180.329 419.19C178.949 418.41 177.929 417.345 177.269 415.995C176.609 414.645 176.279 413.115 176.279 411.405V407.355C176.279 405.675 176.609 404.16 177.269 402.81C177.929 401.43 178.949 400.35 180.329 399.57C181.709 398.79 183.464 398.4 185.594 398.4C186.974 398.4 188.174 398.565 189.194 398.895C190.244 399.225 191.054 399.645 191.624 400.155C192.224 400.635 192.524 401.145 192.524 401.685C192.524 401.955 192.434 402.285 192.254 402.675C192.104 403.035 191.879 403.35 191.579 403.62C191.309 403.86 190.979 403.98 190.589 403.98C190.289 403.98 189.959 403.86 189.599 403.62C189.269 403.38 188.819 403.155 188.249 402.945C187.679 402.705 186.914 402.585 185.954 402.585C184.274 402.585 183.029 403.005 182.219 403.845C181.409 404.685 181.004 405.855 181.004 407.355V411.405C181.004 412.905 181.409 414.075 182.219 414.915C183.029 415.755 184.289 416.175 185.999 416.175C186.989 416.175 187.769 416.055 188.339 415.815C188.909 415.545 189.359 415.29 189.689 415.05C190.049 414.81 190.394 414.69 190.724 414.69C191.144 414.69 191.504 414.81 191.804 415.05C192.134 415.29 192.374 415.59 192.524 415.95C192.704 416.31 192.794 416.64 192.794 416.94C192.794 417.45 192.479 417.975 191.849 418.515C191.249 419.055 190.409 419.505 189.329 419.865C188.279 420.195 187.064 420.36 185.684 420.36ZM198.546 420C197.856 420 197.286 419.835 196.836 419.505C196.416 419.175 196.206 418.815 196.206 418.425V387.51C196.206 387.06 196.416 386.7 196.836 386.43C197.286 386.13 197.856 385.98 198.546 385.98C199.206 385.98 199.761 386.13 200.211 386.43C200.691 386.7 200.931 387.06 200.931 387.51V401.82C201.381 400.95 202.086 400.17 203.046 399.48C204.036 398.76 205.251 398.4 206.691 398.4C208.101 398.4 209.391 398.805 210.561 399.615C211.761 400.395 212.721 401.46 213.441 402.81C214.161 404.13 214.521 405.615 214.521 407.265V418.425C214.521 418.935 214.266 419.325 213.756 419.595C213.276 419.865 212.736 420 212.136 420C211.596 420 211.071 419.865 210.561 419.595C210.051 419.325 209.796 418.935 209.796 418.425V407.265C209.796 406.485 209.586 405.735 209.166 405.015C208.746 404.295 208.191 403.71 207.501 403.26C206.841 402.81 206.091 402.585 205.251 402.585C204.531 402.585 203.841 402.78 203.181 403.17C202.521 403.53 201.981 404.055 201.561 404.745C201.141 405.435 200.931 406.275 200.931 407.265V418.425C200.931 418.815 200.691 419.175 200.211 419.505C199.761 419.835 199.206 420 198.546 420ZM221.572 393.315C220.822 393.315 220.177 393.06 219.637 392.55C219.097 392.04 218.827 391.47 218.827 390.84C218.827 390.15 219.097 389.565 219.637 389.085C220.177 388.605 220.822 388.365 221.572 388.365C222.322 388.365 222.952 388.605 223.462 389.085C224.002 389.565 224.272 390.15 224.272 390.84C224.272 391.47 224.002 392.04 223.462 392.55C222.952 393.06 222.322 393.315 221.572 393.315ZM221.572 420C220.882 420 220.312 419.835 219.862 419.505C219.442 419.175 219.232 418.815 219.232 418.425V400.2C219.232 399.75 219.442 399.39 219.862 399.12C220.312 398.82 220.882 398.67 221.572 398.67C222.232 398.67 222.787 398.82 223.237 399.12C223.717 399.39 223.957 399.75 223.957 400.2V418.425C223.957 418.815 223.717 419.175 223.237 419.505C222.787 419.835 222.232 420 221.572 420ZM231.196 420C230.506 420 229.936 419.835 229.486 419.505C229.066 419.175 228.856 418.815 228.856 418.425V400.2C228.856 399.75 229.066 399.39 229.486 399.12C229.936 398.82 230.506 398.67 231.196 398.67C231.766 398.67 232.261 398.82 232.681 399.12C233.101 399.39 233.311 399.75 233.311 400.2V401.82C233.761 400.95 234.496 400.17 235.516 399.48C236.566 398.76 237.841 398.4 239.341 398.4C240.751 398.4 242.041 398.805 243.211 399.615C244.411 400.395 245.371 401.46 246.091 402.81C246.811 404.13 247.171 405.615 247.171 407.265V418.425C247.171 418.935 246.916 419.325 246.406 419.595C245.926 419.865 245.386 420 244.786 420C244.246 420 243.721 419.865 243.211 419.595C242.701 419.325 242.446 418.935 242.446 418.425V407.265C242.446 406.485 242.236 405.735 241.816 405.015C241.426 404.295 240.886 403.71 240.196 403.26C239.506 402.81 238.741 402.585 237.901 402.585C237.181 402.585 236.491 402.78 235.831 403.17C235.171 403.53 234.631 404.055 234.211 404.745C233.791 405.435 233.581 406.275 233.581 407.265V418.425C233.581 418.815 233.341 419.175 232.861 419.505C232.411 419.835 231.856 420 231.196 420ZM259.938 430.125C258.198 430.125 256.593 429.87 255.123 429.36C253.653 428.88 252.483 428.175 251.613 427.245C250.743 426.315 250.308 425.205 250.308 423.915C250.308 422.715 250.653 421.71 251.343 420.9C252.033 420.12 252.843 419.52 253.773 419.1C253.173 418.83 252.678 418.47 252.288 418.02C251.898 417.57 251.703 416.94 251.703 416.13C251.703 415.29 251.913 414.615 252.333 414.105C252.753 413.595 253.293 413.13 253.953 412.71C253.113 412.05 252.453 411.24 251.973 410.28C251.523 409.29 251.298 408.21 251.298 407.04V405.78C251.298 404.34 251.643 403.065 252.333 401.955C253.023 400.845 253.998 399.975 255.258 399.345C256.548 398.715 258.018 398.4 259.668 398.4C260.688 398.4 261.633 398.535 262.503 398.805C263.403 399.075 264.198 399.45 264.888 399.93C265.368 398.82 265.848 398.04 266.328 397.59C266.838 397.14 267.318 396.915 267.768 396.915C268.398 396.915 268.878 397.095 269.208 397.455C269.538 397.815 269.703 398.175 269.703 398.535C269.703 398.775 269.628 399 269.478 399.21C269.358 399.39 269.178 399.54 268.938 399.66C268.638 399.81 268.278 400.02 267.858 400.29C267.468 400.53 267.078 400.92 266.688 401.46C267.198 402.03 267.573 402.69 267.813 403.44C268.053 404.19 268.173 404.97 268.173 405.78V407.04C268.173 408.45 267.813 409.725 267.093 410.865C266.373 412.005 265.368 412.905 264.078 413.565C262.788 414.195 261.318 414.51 259.668 414.51C258.498 414.51 257.463 414.33 256.563 413.97C256.323 414.12 256.113 414.3 255.933 414.51C255.783 414.69 255.708 414.93 255.708 415.23C255.708 415.77 256.038 416.16 256.698 416.4C257.358 416.64 258.198 416.82 259.218 416.94C260.268 417.06 261.378 417.21 262.548 417.39C263.718 417.57 264.813 417.87 265.833 418.29C266.883 418.68 267.738 419.265 268.398 420.045C269.058 420.855 269.388 421.95 269.388 423.33C269.388 424.89 268.953 426.165 268.083 427.155C267.213 428.175 266.058 428.925 264.618 429.405C263.208 429.885 261.648 430.125 259.938 430.125ZM259.848 426.975C261.318 426.975 262.503 426.645 263.403 425.985C264.333 425.355 264.798 424.515 264.798 423.465C264.798 422.715 264.573 422.13 264.123 421.71C263.673 421.29 263.088 420.975 262.368 420.765C261.648 420.555 260.883 420.405 260.073 420.315C259.293 420.225 258.543 420.135 257.823 420.045C256.983 420.345 256.263 420.765 255.663 421.305C255.093 421.875 254.808 422.58 254.808 423.42C254.808 424.53 255.273 425.4 256.203 426.03C257.163 426.66 258.378 426.975 259.848 426.975ZM259.758 411.495C260.958 411.495 261.888 411.075 262.548 410.235C263.238 409.395 263.583 408.33 263.583 407.04V405.78C263.583 404.55 263.238 403.515 262.548 402.675C261.888 401.835 260.943 401.415 259.713 401.415C258.483 401.415 257.538 401.835 256.878 402.675C256.218 403.515 255.888 404.55 255.888 405.78V406.995C255.888 408.255 256.218 409.32 256.878 410.19C257.538 411.06 258.498 411.495 259.758 411.495ZM289.865 430.125C288.125 430.125 286.52 429.87 285.05 429.36C283.58 428.88 282.41 428.175 281.54 427.245C280.67 426.315 280.235 425.205 280.235 423.915C280.235 422.715 280.58 421.71 281.27 420.9C281.96 420.12 282.77 419.52 283.7 419.1C283.1 418.83 282.605 418.47 282.215 418.02C281.825 417.57 281.63 416.94 281.63 416.13C281.63 415.29 281.84 414.615 282.26 414.105C282.68 413.595 283.22 413.13 283.88 412.71C283.04 412.05 282.38 411.24 281.9 410.28C281.45 409.29 281.225 408.21 281.225 407.04V405.78C281.225 404.34 281.57 403.065 282.26 401.955C282.95 400.845 283.925 399.975 285.185 399.345C286.475 398.715 287.945 398.4 289.595 398.4C290.615 398.4 291.56 398.535 292.43 398.805C293.33 399.075 294.125 399.45 294.815 399.93C295.295 398.82 295.775 398.04 296.255 397.59C296.765 397.14 297.245 396.915 297.695 396.915C298.325 396.915 298.805 397.095 299.135 397.455C299.465 397.815 299.63 398.175 299.63 398.535C299.63 398.775 299.555 399 299.405 399.21C299.285 399.39 299.105 399.54 298.865 399.66C298.565 399.81 298.205 400.02 297.785 400.29C297.395 400.53 297.005 400.92 296.615 401.46C297.125 402.03 297.5 402.69 297.74 403.44C297.98 404.19 298.1 404.97 298.1 405.78V407.04C298.1 408.45 297.74 409.725 297.02 410.865C296.3 412.005 295.295 412.905 294.005 413.565C292.715 414.195 291.245 414.51 289.595 414.51C288.425 414.51 287.39 414.33 286.49 413.97C286.25 414.12 286.04 414.3 285.86 414.51C285.71 414.69 285.635 414.93 285.635 415.23C285.635 415.77 285.965 416.16 286.625 416.4C287.285 416.64 288.125 416.82 289.145 416.94C290.195 417.06 291.305 417.21 292.475 417.39C293.645 417.57 294.74 417.87 295.76 418.29C296.81 418.68 297.665 419.265 298.325 420.045C298.985 420.855 299.315 421.95 299.315 423.33C299.315 424.89 298.88 426.165 298.01 427.155C297.14 428.175 295.985 428.925 294.545 429.405C293.135 429.885 291.575 430.125 289.865 430.125ZM289.775 426.975C291.245 426.975 292.43 426.645 293.33 425.985C294.26 425.355 294.725 424.515 294.725 423.465C294.725 422.715 294.5 422.13 294.05 421.71C293.6 421.29 293.015 420.975 292.295 420.765C291.575 420.555 290.81 420.405 290 420.315C289.22 420.225 288.47 420.135 287.75 420.045C286.91 420.345 286.19 420.765 285.59 421.305C285.02 421.875 284.735 422.58 284.735 423.42C284.735 424.53 285.2 425.4 286.13 426.03C287.09 426.66 288.305 426.975 289.775 426.975ZM289.685 411.495C290.885 411.495 291.815 411.075 292.475 410.235C293.165 409.395 293.51 408.33 293.51 407.04V405.78C293.51 404.55 293.165 403.515 292.475 402.675C291.815 401.835 290.87 401.415 289.64 401.415C288.41 401.415 287.465 401.835 286.805 402.675C286.145 403.515 285.815 404.55 285.815 405.78V406.995C285.815 408.255 286.145 409.32 286.805 410.19C287.465 411.06 288.425 411.495 289.685 411.495ZM307.363 420.36C305.713 420.36 304.303 419.88 303.133 418.92C301.963 417.93 301.378 416.43 301.378 414.42C301.378 412.71 301.828 411.39 302.728 410.46C303.628 409.53 304.858 408.885 306.418 408.525C308.008 408.165 309.838 407.985 311.908 407.985H313.888V407.175C313.888 406.395 313.738 405.645 313.438 404.925C313.168 404.175 312.703 403.56 312.043 403.08C311.413 402.57 310.543 402.315 309.433 402.315C308.323 402.315 307.468 402.42 306.868 402.63C306.268 402.84 305.788 403.065 305.428 403.305C305.068 403.545 304.738 403.665 304.438 403.665C303.898 403.665 303.478 403.41 303.178 402.9C302.878 402.36 302.728 401.82 302.728 401.28C302.728 400.74 303.073 400.26 303.763 399.84C304.483 399.39 305.368 399.045 306.418 398.805C307.468 398.535 308.503 398.4 309.523 398.4C311.743 398.4 313.513 398.82 314.833 399.66C316.153 400.47 317.113 401.535 317.713 402.855C318.313 404.175 318.613 405.6 318.613 407.13V418.425C318.613 418.845 318.388 419.22 317.938 419.55C317.518 419.85 316.978 420 316.318 420C315.718 420 315.208 419.85 314.788 419.55C314.368 419.22 314.158 418.845 314.158 418.425V416.85C313.378 417.75 312.433 418.56 311.323 419.28C310.213 420 308.893 420.36 307.363 420.36ZM309.073 416.76C309.823 416.76 310.558 416.535 311.278 416.085C312.028 415.635 312.643 415.065 313.123 414.375C313.633 413.685 313.888 412.98 313.888 412.26V410.595H312.763C311.623 410.595 310.543 410.67 309.523 410.82C308.503 410.94 307.678 411.24 307.048 411.72C306.448 412.17 306.148 412.875 306.148 413.835C306.148 414.855 306.418 415.605 306.958 416.085C307.528 416.535 308.233 416.76 309.073 416.76ZM325.722 420C325.032 420 324.462 419.835 324.012 419.505C323.592 419.175 323.382 418.815 323.382 418.425V400.2C323.382 399.75 323.592 399.39 324.012 399.12C324.462 398.82 325.032 398.67 325.722 398.67C326.292 398.67 326.787 398.82 327.207 399.12C327.627 399.39 327.837 399.75 327.837 400.2V401.82C328.347 400.95 329.097 400.17 330.087 399.48C331.077 398.76 332.322 398.4 333.822 398.4C335.172 398.4 336.357 398.82 337.377 399.66C338.427 400.5 339.207 401.58 339.717 402.9C340.497 401.37 341.502 400.245 342.732 399.525C343.962 398.775 345.222 398.4 346.512 398.4C347.862 398.4 349.122 398.745 350.292 399.435C351.492 400.125 352.467 401.13 353.217 402.45C353.967 403.77 354.342 405.375 354.342 407.265V418.425C354.342 418.815 354.102 419.175 353.622 419.505C353.172 419.835 352.617 420 351.957 420C351.327 420 350.772 419.835 350.292 419.505C349.842 419.175 349.617 418.815 349.617 418.425V407.265C349.617 406.245 349.407 405.39 348.987 404.7C348.597 403.98 348.072 403.44 347.412 403.08C346.782 402.72 346.122 402.54 345.432 402.54C344.712 402.54 344.037 402.735 343.407 403.125C342.777 403.485 342.252 404.01 341.832 404.7C341.412 405.36 341.202 406.185 341.202 407.175V418.47C341.202 419.01 340.947 419.4 340.437 419.64C339.957 419.88 339.417 420 338.817 420C338.277 420 337.752 419.88 337.242 419.64C336.732 419.4 336.477 419.01 336.477 418.47V407.22C336.477 406.26 336.282 405.435 335.892 404.745C335.502 404.055 334.992 403.53 334.362 403.17C333.732 402.78 333.042 402.585 332.292 402.585C331.602 402.585 330.927 402.765 330.267 403.125C329.637 403.485 329.112 404.01 328.692 404.7C328.302 405.39 328.107 406.245 328.107 407.265V418.425C328.107 418.815 327.867 419.175 327.387 419.505C326.937 419.835 326.382 420 325.722 420ZM368.74 420.36C366.7 420.36 364.9 419.985 363.34 419.235C361.78 418.485 360.55 417.45 359.65 416.13C358.75 414.78 358.3 413.205 358.3 411.405V407.13C358.3 405.54 358.72 404.085 359.56 402.765C360.43 401.445 361.57 400.395 362.98 399.615C364.39 398.805 365.95 398.4 367.66 398.4C369.28 398.4 370.765 398.76 372.115 399.48C373.465 400.17 374.545 401.145 375.355 402.405C376.195 403.665 376.615 405.105 376.615 406.725C376.615 407.985 376.42 408.885 376.03 409.425C375.64 409.965 375.13 410.295 374.5 410.415C373.87 410.535 373.21 410.595 372.52 410.595H363.025V411.63C363.025 413.13 363.565 414.33 364.645 415.23C365.755 416.1 367.165 416.535 368.875 416.535C369.925 416.535 370.78 416.385 371.44 416.085C372.1 415.785 372.655 415.5 373.105 415.23C373.555 414.96 373.975 414.825 374.365 414.825C374.755 414.825 375.085 414.945 375.355 415.185C375.625 415.425 375.835 415.71 375.985 416.04C376.135 416.37 376.21 416.67 376.21 416.94C376.21 417.39 375.895 417.885 375.265 418.425C374.665 418.965 373.81 419.43 372.7 419.82C371.59 420.18 370.27 420.36 368.74 420.36ZM363.025 407.67H370.495C371.155 407.67 371.59 407.58 371.8 407.4C372.04 407.22 372.16 406.86 372.16 406.32C372.16 405.54 371.965 404.82 371.575 404.16C371.185 403.47 370.645 402.945 369.955 402.585C369.265 402.195 368.485 402 367.615 402C366.775 402 366.01 402.18 365.32 402.54C364.63 402.9 364.075 403.395 363.655 404.025C363.235 404.655 363.025 405.39 363.025 406.23V407.67ZM397.891 420.36C396.271 420.36 394.756 419.94 393.346 419.1C391.936 418.26 390.796 417.165 389.926 415.815C389.086 414.435 388.666 412.965 388.666 411.405V407.265C388.666 405.675 389.071 404.205 389.881 402.855C390.721 401.505 391.846 400.425 393.256 399.615C394.696 398.805 396.256 398.4 397.936 398.4C399.616 398.4 401.161 398.805 402.571 399.615C403.981 400.395 405.106 401.46 405.946 402.81C406.816 404.13 407.251 405.615 407.251 407.265V411.405C407.251 412.935 406.816 414.39 405.946 415.77C405.106 417.15 403.966 418.26 402.526 419.1C401.116 419.94 399.571 420.36 397.891 420.36ZM397.936 416.175C398.776 416.175 399.541 415.95 400.231 415.5C400.921 415.05 401.476 414.465 401.896 413.745C402.316 412.995 402.526 412.215 402.526 411.405V407.265C402.526 406.485 402.316 405.735 401.896 405.015C401.476 404.295 400.921 403.71 400.231 403.26C399.541 402.81 398.776 402.585 397.936 402.585C397.066 402.585 396.286 402.81 395.596 403.26C394.936 403.71 394.396 404.295 393.976 405.015C393.586 405.735 393.391 406.485 393.391 407.265V411.405C393.391 412.215 393.586 412.995 393.976 413.745C394.396 414.465 394.951 415.05 395.641 415.5C396.331 415.95 397.096 416.175 397.936 416.175ZM413.701 420C413.011 420 412.441 419.835 411.991 419.505C411.571 419.175 411.361 418.815 411.361 418.425V400.2C411.361 399.75 411.571 399.39 411.991 399.12C412.441 398.82 413.011 398.67 413.701 398.67C414.271 398.67 414.766 398.82 415.186 399.12C415.606 399.39 415.816 399.75 415.816 400.2V401.82C416.266 400.95 417.001 400.17 418.021 399.48C419.071 398.76 420.346 398.4 421.846 398.4C423.256 398.4 424.546 398.805 425.716 399.615C426.916 400.395 427.876 401.46 428.596 402.81C429.316 404.13 429.676 405.615 429.676 407.265V418.425C429.676 418.935 429.421 419.325 428.911 419.595C428.431 419.865 427.891 420 427.291 420C426.751 420 426.226 419.865 425.716 419.595C425.206 419.325 424.951 418.935 424.951 418.425V407.265C424.951 406.485 424.741 405.735 424.321 405.015C423.931 404.295 423.391 403.71 422.701 403.26C422.011 402.81 421.246 402.585 420.406 402.585C419.686 402.585 418.996 402.78 418.336 403.17C417.676 403.53 417.136 404.055 416.716 404.745C416.296 405.435 416.086 406.275 416.086 407.265V418.425C416.086 418.815 415.846 419.175 415.366 419.505C414.916 419.835 414.361 420 413.701 420ZM451.182 420C448.632 420 446.682 419.445 445.332 418.335C443.982 417.195 443.307 415.41 443.307 412.98V390.435C443.307 389.985 443.547 389.625 444.027 389.355C444.537 389.055 445.077 388.905 445.647 388.905C446.217 388.905 446.757 389.055 447.267 389.355C447.777 389.625 448.032 389.985 448.032 390.435V398.67H453.522C453.942 398.67 454.257 398.85 454.467 399.21C454.707 399.57 454.827 399.975 454.827 400.425C454.827 400.875 454.707 401.28 454.467 401.64C454.257 402 453.942 402.18 453.522 402.18H448.032V412.98C448.032 414.06 448.257 414.825 448.707 415.275C449.187 415.725 450.012 415.95 451.182 415.95H452.712C453.402 415.95 453.912 416.16 454.242 416.58C454.602 416.97 454.782 417.435 454.782 417.975C454.782 418.485 454.602 418.95 454.242 419.37C453.912 419.79 453.402 420 452.712 420H451.182ZM460.46 420C459.77 420 459.2 419.835 458.75 419.505C458.33 419.175 458.12 418.815 458.12 418.425V387.51C458.12 387.06 458.33 386.7 458.75 386.43C459.2 386.13 459.77 385.98 460.46 385.98C461.12 385.98 461.675 386.13 462.125 386.43C462.605 386.7 462.845 387.06 462.845 387.51V401.82C463.295 400.95 464 400.17 464.96 399.48C465.95 398.76 467.165 398.4 468.605 398.4C470.015 398.4 471.305 398.805 472.475 399.615C473.675 400.395 474.635 401.46 475.355 402.81C476.075 404.13 476.435 405.615 476.435 407.265V418.425C476.435 418.935 476.18 419.325 475.67 419.595C475.19 419.865 474.65 420 474.05 420C473.51 420 472.985 419.865 472.475 419.595C471.965 419.325 471.71 418.935 471.71 418.425V407.265C471.71 406.485 471.5 405.735 471.08 405.015C470.66 404.295 470.105 403.71 469.415 403.26C468.755 402.81 468.005 402.585 467.165 402.585C466.445 402.585 465.755 402.78 465.095 403.17C464.435 403.53 463.895 404.055 463.475 404.745C463.055 405.435 462.845 406.275 462.845 407.265V418.425C462.845 418.815 462.605 419.175 462.125 419.505C461.675 419.835 461.12 420 460.46 420ZM490.776 420.36C488.736 420.36 486.936 419.985 485.376 419.235C483.816 418.485 482.586 417.45 481.686 416.13C480.786 414.78 480.336 413.205 480.336 411.405V407.13C480.336 405.54 480.756 404.085 481.596 402.765C482.466 401.445 483.606 400.395 485.016 399.615C486.426 398.805 487.986 398.4 489.696 398.4C491.316 398.4 492.801 398.76 494.151 399.48C495.501 400.17 496.581 401.145 497.391 402.405C498.231 403.665 498.651 405.105 498.651 406.725C498.651 407.985 498.456 408.885 498.066 409.425C497.676 409.965 497.166 410.295 496.536 410.415C495.906 410.535 495.246 410.595 494.556 410.595H485.061V411.63C485.061 413.13 485.601 414.33 486.681 415.23C487.791 416.1 489.201 416.535 490.911 416.535C491.961 416.535 492.816 416.385 493.476 416.085C494.136 415.785 494.691 415.5 495.141 415.23C495.591 414.96 496.011 414.825 496.401 414.825C496.791 414.825 497.121 414.945 497.391 415.185C497.661 415.425 497.871 415.71 498.021 416.04C498.171 416.37 498.246 416.67 498.246 416.94C498.246 417.39 497.931 417.885 497.301 418.425C496.701 418.965 495.846 419.43 494.736 419.82C493.626 420.18 492.306 420.36 490.776 420.36ZM485.061 407.67H492.531C493.191 407.67 493.626 407.58 493.836 407.4C494.076 407.22 494.196 406.86 494.196 406.32C494.196 405.54 494.001 404.82 493.611 404.16C493.221 403.47 492.681 402.945 491.991 402.585C491.301 402.195 490.521 402 489.651 402C488.811 402 488.046 402.18 487.356 402.54C486.666 402.9 486.111 403.395 485.691 404.025C485.271 404.655 485.061 405.39 485.061 406.23V407.67ZM513.852 420C513.162 420 512.592 419.835 512.142 419.505C511.722 419.175 511.512 418.815 511.512 418.425V400.2C511.512 399.75 511.722 399.39 512.142 399.12C512.592 398.82 513.162 398.67 513.852 398.67C514.422 398.67 514.917 398.82 515.337 399.12C515.757 399.39 515.967 399.75 515.967 400.2V401.82C516.417 400.95 517.152 400.17 518.172 399.48C519.222 398.76 520.497 398.4 521.997 398.4C523.407 398.4 524.697 398.805 525.867 399.615C527.067 400.395 528.027 401.46 528.747 402.81C529.467 404.13 529.827 405.615 529.827 407.265V418.425C529.827 418.935 529.572 419.325 529.062 419.595C528.582 419.865 528.042 420 527.442 420C526.902 420 526.377 419.865 525.867 419.595C525.357 419.325 525.102 418.935 525.102 418.425V407.265C525.102 406.485 524.892 405.735 524.472 405.015C524.082 404.295 523.542 403.71 522.852 403.26C522.162 402.81 521.397 402.585 520.557 402.585C519.837 402.585 519.147 402.78 518.487 403.17C517.827 403.53 517.287 404.055 516.867 404.745C516.447 405.435 516.237 406.275 516.237 407.265V418.425C516.237 418.815 515.997 419.175 515.517 419.505C515.067 419.835 514.512 420 513.852 420ZM544.169 420.36C542.129 420.36 540.329 419.985 538.769 419.235C537.209 418.485 535.979 417.45 535.079 416.13C534.179 414.78 533.729 413.205 533.729 411.405V407.13C533.729 405.54 534.149 404.085 534.989 402.765C535.859 401.445 536.999 400.395 538.409 399.615C539.819 398.805 541.379 398.4 543.089 398.4C544.709 398.4 546.194 398.76 547.544 399.48C548.894 400.17 549.974 401.145 550.784 402.405C551.624 403.665 552.044 405.105 552.044 406.725C552.044 407.985 551.849 408.885 551.459 409.425C551.069 409.965 550.559 410.295 549.929 410.415C549.299 410.535 548.639 410.595 547.949 410.595H538.454V411.63C538.454 413.13 538.994 414.33 540.074 415.23C541.184 416.1 542.594 416.535 544.304 416.535C545.354 416.535 546.209 416.385 546.869 416.085C547.529 415.785 548.084 415.5 548.534 415.23C548.984 414.96 549.404 414.825 549.794 414.825C550.184 414.825 550.514 414.945 550.784 415.185C551.054 415.425 551.264 415.71 551.414 416.04C551.564 416.37 551.639 416.67 551.639 416.94C551.639 417.39 551.324 417.885 550.694 418.425C550.094 418.965 549.239 419.43 548.129 419.82C547.019 420.18 545.699 420.36 544.169 420.36ZM538.454 407.67H545.924C546.584 407.67 547.019 407.58 547.229 407.4C547.469 407.22 547.589 406.86 547.589 406.32C547.589 405.54 547.394 404.82 547.004 404.16C546.614 403.47 546.074 402.945 545.384 402.585C544.694 402.195 543.914 402 543.044 402C542.204 402 541.439 402.18 540.749 402.54C540.059 402.9 539.504 403.395 539.084 404.025C538.664 404.655 538.454 405.39 538.454 406.23V407.67ZM557.382 420.36C557.022 420.36 556.602 420.24 556.122 420C555.672 419.79 555.267 419.505 554.907 419.145C554.577 418.785 554.412 418.41 554.412 418.02C554.412 417.72 554.502 417.435 554.682 417.165L560.262 409.155L554.997 401.595C554.907 401.505 554.832 401.385 554.772 401.235C554.712 401.085 554.682 400.935 554.682 400.785C554.682 400.395 554.847 400.02 555.177 399.66C555.537 399.3 555.957 399 556.437 398.76C556.917 398.52 557.352 398.4 557.742 398.4C557.892 398.4 558.087 398.43 558.327 398.49C558.567 398.55 558.762 398.7 558.912 398.94L563.457 406.14L568.047 398.985C568.197 398.745 568.377 398.595 568.587 398.535C568.827 398.445 569.052 398.4 569.262 398.4C569.622 398.4 570.042 398.52 570.522 398.76C571.002 398.97 571.407 399.27 571.737 399.66C572.097 400.02 572.277 400.395 572.277 400.785C572.277 401.025 572.172 401.295 571.962 401.595L566.652 409.2L572.232 417.165C572.322 417.255 572.397 417.375 572.457 417.525C572.517 417.675 572.547 417.84 572.547 418.02C572.547 418.35 572.382 418.71 572.052 419.1C571.722 419.46 571.317 419.76 570.837 420C570.387 420.24 569.952 420.36 569.532 420.36C569.322 420.36 569.097 420.315 568.857 420.225C568.647 420.165 568.482 420.03 568.362 419.82L563.457 412.395L558.597 419.82C558.477 420 558.282 420.135 558.012 420.225C557.772 420.315 557.562 420.36 557.382 420.36ZM583.765 420C581.215 420 579.265 419.445 577.915 418.335C576.565 417.195 575.89 415.41 575.89 412.98V390.435C575.89 389.985 576.13 389.625 576.61 389.355C577.12 389.055 577.66 388.905 578.23 388.905C578.8 388.905 579.34 389.055 579.85 389.355C580.36 389.625 580.615 389.985 580.615 390.435V398.67H586.105C586.525 398.67 586.84 398.85 587.05 399.21C587.29 399.57 587.41 399.975 587.41 400.425C587.41 400.875 587.29 401.28 587.05 401.64C586.84 402 586.525 402.18 586.105 402.18H580.615V412.98C580.615 414.06 580.84 414.825 581.29 415.275C581.77 415.725 582.595 415.95 583.765 415.95H585.295C585.985 415.95 586.495 416.16 586.825 416.58C587.185 416.97 587.365 417.435 587.365 417.975C587.365 418.485 587.185 418.95 586.825 419.37C586.495 419.79 585.985 420 585.295 420H583.765ZM303.2 487.125C302.54 487.125 301.985 486.96 301.535 486.63C301.115 486.3 300.905 485.94 300.905 485.55V457.2C300.905 456.75 301.115 456.39 301.535 456.12C301.985 455.82 302.525 455.67 303.155 455.67C303.785 455.67 304.31 455.82 304.73 456.12C305.15 456.39 305.36 456.75 305.36 457.2V458.82C305.87 457.95 306.635 457.17 307.655 456.48C308.705 455.76 309.95 455.4 311.39 455.4C312.89 455.4 314.255 455.805 315.485 456.615C316.715 457.395 317.69 458.46 318.41 459.81C319.13 461.13 319.49 462.615 319.49 464.265V468.405C319.49 469.965 319.115 471.435 318.365 472.815C317.645 474.165 316.685 475.26 315.485 476.1C314.285 476.94 312.98 477.36 311.57 477.36C310.22 477.36 309.005 477.015 307.925 476.325C306.845 475.605 306.08 474.78 305.63 473.85V485.55C305.63 485.94 305.39 486.3 304.91 486.63C304.46 486.96 303.89 487.125 303.2 487.125ZM310.175 473.175C310.985 473.175 311.735 472.95 312.425 472.5C313.115 472.05 313.67 471.45 314.09 470.7C314.54 469.95 314.765 469.185 314.765 468.405V464.265C314.765 463.485 314.555 462.735 314.135 462.015C313.715 461.295 313.145 460.71 312.425 460.26C311.735 459.81 310.955 459.585 310.085 459.585C309.365 459.585 308.66 459.78 307.97 460.17C307.28 460.53 306.71 461.055 306.26 461.745C305.84 462.435 305.63 463.275 305.63 464.265V469.44C305.63 469.8 305.825 470.28 306.215 470.88C306.605 471.45 307.145 471.975 307.835 472.455C308.525 472.935 309.305 473.175 310.175 473.175ZM328.259 477.36C326.609 477.36 325.199 476.88 324.029 475.92C322.859 474.93 322.274 473.43 322.274 471.42C322.274 469.71 322.724 468.39 323.624 467.46C324.524 466.53 325.754 465.885 327.314 465.525C328.904 465.165 330.734 464.985 332.804 464.985H334.784V464.175C334.784 463.395 334.634 462.645 334.334 461.925C334.064 461.175 333.599 460.56 332.939 460.08C332.309 459.57 331.439 459.315 330.329 459.315C329.219 459.315 328.364 459.42 327.764 459.63C327.164 459.84 326.684 460.065 326.324 460.305C325.964 460.545 325.634 460.665 325.334 460.665C324.794 460.665 324.374 460.41 324.074 459.9C323.774 459.36 323.624 458.82 323.624 458.28C323.624 457.74 323.969 457.26 324.659 456.84C325.379 456.39 326.264 456.045 327.314 455.805C328.364 455.535 329.399 455.4 330.419 455.4C332.639 455.4 334.409 455.82 335.729 456.66C337.049 457.47 338.009 458.535 338.609 459.855C339.209 461.175 339.509 462.6 339.509 464.13V475.425C339.509 475.845 339.284 476.22 338.834 476.55C338.414 476.85 337.874 477 337.214 477C336.614 477 336.104 476.85 335.684 476.55C335.264 476.22 335.054 475.845 335.054 475.425V473.85C334.274 474.75 333.329 475.56 332.219 476.28C331.109 477 329.789 477.36 328.259 477.36ZM329.969 473.76C330.719 473.76 331.454 473.535 332.174 473.085C332.924 472.635 333.539 472.065 334.019 471.375C334.529 470.685 334.784 469.98 334.784 469.26V467.595H333.659C332.519 467.595 331.439 467.67 330.419 467.82C329.399 467.94 328.574 468.24 327.944 468.72C327.344 469.17 327.044 469.875 327.044 470.835C327.044 471.855 327.314 472.605 327.854 473.085C328.424 473.535 329.129 473.76 329.969 473.76ZM352.333 487.125C350.593 487.125 348.988 486.87 347.518 486.36C346.048 485.88 344.878 485.175 344.008 484.245C343.138 483.315 342.703 482.205 342.703 480.915C342.703 479.715 343.048 478.71 343.738 477.9C344.428 477.12 345.238 476.52 346.168 476.1C345.568 475.83 345.073 475.47 344.683 475.02C344.293 474.57 344.098 473.94 344.098 473.13C344.098 472.29 344.308 471.615 344.728 471.105C345.148 470.595 345.688 470.13 346.348 469.71C345.508 469.05 344.848 468.24 344.368 467.28C343.918 466.29 343.693 465.21 343.693 464.04V462.78C343.693 461.34 344.038 460.065 344.728 458.955C345.418 457.845 346.393 456.975 347.653 456.345C348.943 455.715 350.413 455.4 352.063 455.4C353.083 455.4 354.028 455.535 354.898 455.805C355.798 456.075 356.593 456.45 357.283 456.93C357.763 455.82 358.243 455.04 358.723 454.59C359.233 454.14 359.713 453.915 360.163 453.915C360.793 453.915 361.273 454.095 361.603 454.455C361.933 454.815 362.098 455.175 362.098 455.535C362.098 455.775 362.023 456 361.873 456.21C361.753 456.39 361.573 456.54 361.333 456.66C361.033 456.81 360.673 457.02 360.253 457.29C359.863 457.53 359.473 457.92 359.083 458.46C359.593 459.03 359.968 459.69 360.208 460.44C360.448 461.19 360.568 461.97 360.568 462.78V464.04C360.568 465.45 360.208 466.725 359.488 467.865C358.768 469.005 357.763 469.905 356.473 470.565C355.183 471.195 353.713 471.51 352.063 471.51C350.893 471.51 349.858 471.33 348.958 470.97C348.718 471.12 348.508 471.3 348.328 471.51C348.178 471.69 348.103 471.93 348.103 472.23C348.103 472.77 348.433 473.16 349.093 473.4C349.753 473.64 350.593 473.82 351.613 473.94C352.663 474.06 353.773 474.21 354.943 474.39C356.113 474.57 357.208 474.87 358.228 475.29C359.278 475.68 360.133 476.265 360.793 477.045C361.453 477.855 361.783 478.95 361.783 480.33C361.783 481.89 361.348 483.165 360.478 484.155C359.608 485.175 358.453 485.925 357.013 486.405C355.603 486.885 354.043 487.125 352.333 487.125ZM352.243 483.975C353.713 483.975 354.898 483.645 355.798 482.985C356.728 482.355 357.193 481.515 357.193 480.465C357.193 479.715 356.968 479.13 356.518 478.71C356.068 478.29 355.483 477.975 354.763 477.765C354.043 477.555 353.278 477.405 352.468 477.315C351.688 477.225 350.938 477.135 350.218 477.045C349.378 477.345 348.658 477.765 348.058 478.305C347.488 478.875 347.203 479.58 347.203 480.42C347.203 481.53 347.668 482.4 348.598 483.03C349.558 483.66 350.773 483.975 352.243 483.975ZM352.153 468.495C353.353 468.495 354.283 468.075 354.943 467.235C355.633 466.395 355.978 465.33 355.978 464.04V462.78C355.978 461.55 355.633 460.515 354.943 459.675C354.283 458.835 353.338 458.415 352.108 458.415C350.878 458.415 349.933 458.835 349.273 459.675C348.613 460.515 348.283 461.55 348.283 462.78V463.995C348.283 465.255 348.613 466.32 349.273 467.19C349.933 468.06 350.893 468.495 352.153 468.495ZM374.738 477.36C372.698 477.36 370.898 476.985 369.338 476.235C367.778 475.485 366.548 474.45 365.648 473.13C364.748 471.78 364.298 470.205 364.298 468.405V464.13C364.298 462.54 364.718 461.085 365.558 459.765C366.428 458.445 367.568 457.395 368.978 456.615C370.388 455.805 371.948 455.4 373.658 455.4C375.278 455.4 376.763 455.76 378.113 456.48C379.463 457.17 380.543 458.145 381.353 459.405C382.193 460.665 382.613 462.105 382.613 463.725C382.613 464.985 382.418 465.885 382.028 466.425C381.638 466.965 381.128 467.295 380.498 467.415C379.868 467.535 379.208 467.595 378.518 467.595H369.023V468.63C369.023 470.13 369.563 471.33 370.643 472.23C371.753 473.1 373.163 473.535 374.873 473.535C375.923 473.535 376.778 473.385 377.438 473.085C378.098 472.785 378.653 472.5 379.103 472.23C379.553 471.96 379.973 471.825 380.363 471.825C380.753 471.825 381.083 471.945 381.353 472.185C381.623 472.425 381.833 472.71 381.983 473.04C382.133 473.37 382.208 473.67 382.208 473.94C382.208 474.39 381.893 474.885 381.263 475.425C380.663 475.965 379.808 476.43 378.698 476.82C377.588 477.18 376.268 477.36 374.738 477.36ZM369.023 464.67H376.493C377.153 464.67 377.588 464.58 377.798 464.4C378.038 464.22 378.158 463.86 378.158 463.32C378.158 462.54 377.963 461.82 377.573 461.16C377.183 460.47 376.643 459.945 375.953 459.585C375.263 459.195 374.483 459 373.613 459C372.773 459 372.008 459.18 371.318 459.54C370.628 459.9 370.073 460.395 369.653 461.025C369.233 461.655 369.023 462.39 369.023 463.23V464.67ZM388.806 468.54C388.326 468.54 387.891 468.42 387.501 468.18C387.141 467.94 386.961 467.58 386.961 467.1C386.961 464.91 386.916 462.6 386.826 460.17C386.736 457.74 386.646 455.31 386.556 452.88C386.466 450.42 386.421 448.11 386.421 445.95C386.421 445.26 386.646 444.735 387.096 444.375C387.546 443.985 388.116 443.79 388.806 443.79C389.466 443.79 390.021 443.985 390.471 444.375C390.951 444.735 391.191 445.26 391.191 445.95C391.191 448.11 391.146 450.42 391.056 452.88C390.966 455.31 390.876 457.74 390.786 460.17C390.696 462.6 390.651 464.91 390.651 467.1C390.651 467.58 390.441 467.94 390.021 468.18C389.601 468.42 389.196 468.54 388.806 468.54ZM388.851 477.27C388.071 477.27 387.426 477 386.916 476.46C386.406 475.92 386.151 475.29 386.151 474.57C386.151 473.82 386.406 473.19 386.916 472.68C387.426 472.14 388.071 471.87 388.851 471.87C389.571 471.87 390.186 472.14 390.696 472.68C391.236 473.19 391.506 473.82 391.506 474.57C391.506 475.29 391.236 475.92 390.696 476.46C390.186 477 389.571 477.27 388.851 477.27Z\" fill=\"#FF0082\"/> <g filter=\"url(#filter1_d_838_977)\"> <path d=\"M256 555H415C426.046 555 435 563.954 435 575V617H276C264.954 617 256 608.046 256 597V555Z\" fill=\"#FDFAF1\"/> <path d=\"M315 599C314.488 599 314.008 598.893 313.56 598.68C313.133 598.445 312.92 598.104 312.92 597.656V576.92C312.92 576.472 313.133 576.141 313.56 575.928C314.008 575.715 314.488 575.608 315 575.608C315.512 575.608 315.928 575.661 316.248 575.768C316.589 575.875 316.899 576.088 317.176 576.408C317.475 576.707 317.784 577.176 318.104 577.816L324.28 589.752V576.92C324.28 576.451 324.493 576.12 324.92 575.928C325.368 575.715 325.848 575.608 326.36 575.608C326.893 575.608 327.373 575.715 327.8 575.928C328.227 576.12 328.44 576.451 328.44 576.92V597.656C328.44 598.104 328.227 598.445 327.8 598.68C327.373 598.893 326.893 599 326.36 599C325.869 599 325.411 598.904 324.984 598.712C324.579 598.52 324.248 598.179 323.992 597.688L317.08 584.824V597.656C317.08 598.104 316.867 598.445 316.44 598.68C316.013 598.893 315.533 599 315 599ZM334.15 599C333.702 599 333.286 598.893 332.902 598.68C332.518 598.445 332.326 598.104 332.326 597.656V576.952C332.326 576.504 332.518 576.173 332.902 575.96C333.286 575.725 333.702 575.608 334.15 575.608H345.542C346.012 575.608 346.342 575.8 346.534 576.184C346.748 576.568 346.854 576.973 346.854 577.4C346.854 577.912 346.737 578.349 346.502 578.712C346.289 579.075 345.969 579.256 345.542 579.256H336.486V585.656H341.35C341.777 585.656 342.097 585.827 342.31 586.168C342.545 586.488 342.662 586.872 342.662 587.32C342.662 587.683 342.556 588.045 342.342 588.408C342.15 588.749 341.82 588.92 341.35 588.92H336.486V595.352H345.542C345.969 595.352 346.289 595.533 346.502 595.896C346.737 596.259 346.854 596.696 346.854 597.208C346.854 597.635 346.748 598.04 346.534 598.424C346.342 598.808 346.012 599 345.542 599H334.15ZM350.511 599.16C350.127 599.16 349.722 599.064 349.295 598.872C348.868 598.68 348.506 598.435 348.207 598.136C347.908 597.816 347.759 597.464 347.759 597.08C347.759 596.845 347.844 596.589 348.015 596.312L353.551 587.288L348.207 578.296C348.015 577.997 347.919 577.699 347.919 577.4C347.919 577.037 348.058 576.707 348.335 576.408C348.612 576.109 348.954 575.875 349.359 575.704C349.786 575.533 350.191 575.448 350.575 575.448C350.916 575.448 351.194 575.533 351.407 575.704C351.642 575.853 351.823 576.067 351.951 576.344L356.303 584.184L360.687 576.344C360.836 576.067 361.018 575.853 361.231 575.704C361.466 575.533 361.743 575.448 362.063 575.448C362.468 575.448 362.874 575.533 363.279 575.704C363.684 575.875 364.026 576.109 364.303 576.408C364.58 576.707 364.719 577.037 364.719 577.4C364.719 577.699 364.623 577.997 364.431 578.296L359.087 587.288L364.623 596.312C364.794 596.589 364.879 596.845 364.879 597.08C364.879 597.464 364.73 597.816 364.431 598.136C364.132 598.435 363.77 598.68 363.343 598.872C362.938 599.064 362.532 599.16 362.127 599.16C361.892 599.16 361.668 599.096 361.455 598.968C361.263 598.84 361.114 598.68 361.007 598.488L356.303 590.264L351.631 598.488C351.524 598.68 351.364 598.84 351.151 598.968C350.959 599.096 350.746 599.16 350.511 599.16ZM373.634 599C373.101 599 372.621 598.893 372.194 598.68C371.767 598.445 371.554 598.104 371.554 597.656V579.352H366.85C366.445 579.352 366.125 579.16 365.89 578.776C365.655 578.392 365.538 577.955 365.538 577.464C365.538 577.016 365.645 576.6 365.858 576.216C366.071 575.811 366.402 575.608 366.85 575.608H380.386C380.855 575.608 381.186 575.811 381.378 576.216C381.591 576.6 381.698 577.016 381.698 577.464C381.698 577.955 381.581 578.392 381.346 578.776C381.133 579.16 380.813 579.352 380.386 579.352H375.714V597.656C375.714 598.104 375.49 598.445 375.042 598.68C374.615 598.893 374.146 599 373.634 599Z\" fill=\"#FF0082\"/> <path d=\"M256.5 555.5H415C425.77 555.5 434.5 564.23 434.5 575V616.5H276C265.23 616.5 256.5 607.77 256.5 597V555.5Z\" stroke=\"#F7CFE5\"/> </g> <rect x=\"1.5\" y=\"1.5\" width=\"688\" height=\"688\" rx=\"48.5\" stroke=\"#FFD208\" stroke-width=\"3\"/> </g> <defs> <filter id=\"filter0_d_838_977\" x=\"0\" y=\"0\" width=\"701\" height=\"701\" filterUnits=\"userSpaceOnUse\" color-interpolation-filters=\"sRGB\"> <feFlood flood-opacity=\"0\" result=\"BackgroundImageFix\"/> <feColorMatrix in=\"SourceAlpha\" type=\"matrix\" values=\"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0\" result=\"hardAlpha\"/> <feOffset dx=\"10\" dy=\"10\"/> <feComposite in2=\"hardAlpha\" operator=\"out\"/> <feColorMatrix type=\"matrix\" values=\"0 0 0 0 0.956863 0 0 0 0 0.490196 0 0 0 0 0.380392 0 0 0 1 0\"/> <feBlend mode=\"normal\" in2=\"BackgroundImageFix\" result=\"effect1_dropShadow_838_977\"/> <feBlend mode=\"normal\" in=\"SourceGraphic\" in2=\"effect1_dropShadow_838_977\" result=\"shape\"/> </filter> <filter id=\"filter1_d_838_977\" x=\"256\" y=\"555\" width=\"184\" height=\"67\" filterUnits=\"userSpaceOnUse\" color-interpolation-filters=\"sRGB\"> <feFlood flood-opacity=\"0\" result=\"BackgroundImageFix\"/> <feColorMatrix in=\"SourceAlpha\" type=\"matrix\" values=\"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0\" result=\"hardAlpha\"/> <feOffset dx=\"5\" dy=\"5\"/> <feComposite in2=\"hardAlpha\" operator=\"out\"/> <feColorMatrix type=\"matrix\" values=\"0 0 0 0 1 0 0 0 0 0 0 0 0 0 0.509804 0 0 0 1 0\"/> <feBlend mode=\"normal\" in2=\"BackgroundImageFix\" result=\"effect1_dropShadow_838_977\"/> <feBlend mode=\"normal\" in=\"SourceGraphic\" in2=\"effect1_dropShadow_838_977\" result=\"shape\"/> </filter> </defs> </svg>") // EJsS HtmlView.HtmlView Page: setting property 'Html' for element 'gameIntroduction'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"gameScreen", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'gameScreen'
      .setProperty("ClassName","d-none container flex-column justify-content-center") // EJsS HtmlView.HtmlView Page: setting property 'ClassName' for element 'gameScreen'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"stage1", _view.gameScreen) // EJsS HtmlView.HtmlView Page: declaration of element 'stage1'
      .setProperty("ClassName","d-block") // EJsS HtmlView.HtmlView Page: setting property 'ClassName' for element 'stage1'
      .setProperty("Html","<div class=\"container text-center\">    <div class=\"row religion-pictures\">       <div class=\"col-4\">          <img class=\"religion-images\" id=\"judaismPic\" src=\"cross_cultural/assets/religion/juda-pic.svg\" alt=\"Juda\" />                 <div class=\"d-flex justify-content-center flex-column align-items-center\">                      <input type=\"radio\" id=\"judaismIcon\" name=\"card\" value=\"judaism\" />                      <label for=\"judaismIcon\">xx</label>                 </div>       </div>       <div class=\"col-4\">          <img class=\"religion-images\" id=\"zoroastrianPic\" src=\"cross_cultural/assets/religion/zoro-pic.svg\" alt=\"Zoro\" />                 <div class=\"d-flex justify-content-center flex-column align-items-center\">                     <input type=\"radio\" id=\"zoroastrianIcon\" name=\"card\" value=\"zoroastrian\" />                     <label for=\"zoroastrianIcon\">xx</label>                 </div>       </div>       <div class=\"col-4\">          <img class=\"religion-images\" id=\"hinduismPic\" src=\"cross_cultural/assets/religion/hindu-pic.svg\" alt=\"Hindu\" />                 <div class=\"d-flex justify-content-center flex-column align-items-center\">                     <input type=\"radio\" id=\"hinduismIcon\" name=\"card\" value=\"hinduism\" />                     <label for=\"hinduismIcon\">xx</label>                 </div>       </div>    </div>    <div class=\"row\">       <canvas id=\"my-canvas-1\" width=\"720\" height=\"0\"></canvas>    </div>    <div class=\"row religion-labels\">       <div class=\"col-4 position-relative\">          <div class=\"d-flex justify-content-center flex-column-reverse align-items-center\">                     <input type=\"radio\" id=\"hinduismText\" name=\"match\" value=\"hinduism\" />           <label for=\"hinduismText\">xx</label>            </div>          <img class=\"religion-names\" id=\"hinduismName\" src=\"cross_cultural/assets/religion/hindu-name.svg\" alt=\"Hindu\" />            <img class=\"opacity-0 position-absolute bottom-0 start-75 speech-bubble\" id=\"hinduism-sb\" src=\"cross_cultural/assets/religion/speech_bubble.svg\" />       </div>       <div class=\"col-4 position-relative\">         <div class=\"d-flex justify-content-center flex-column-reverse align-items-center\">                     <input type=\"radio\" id=\"judaismText\" name=\"match\" value=\"judaism\" />           <label for=\"judaismText\">xx</label>         </div>         <img class=\"religion-names\" id=\"judaismName\" src=\"cross_cultural/assets/religion/juda-name.svg\" alt=\"Juda\" />         <img class=\"opacity-0 position-absolute bottom-0 start-75 speech-bubble\" id=\"judaism-sb\" src=\"cross_cultural/assets/religion/speech_bubble.svg\" />       </div>       <div class=\"col-4 position-relative\">         <div class=\"d-flex justify-content-center flex-column-reverse align-items-center\">                     <input type=\"radio\" id=\"zoroastrianText\" name=\"match\" value=\"zoroastrian\" />           <label for=\"zoroastrianText\">xx</label>         </div>         <img class=\"religion-names\" id=\"zoroastrianName\" src=\"cross_cultural/assets/religion/zoro-name.svg\" alt=\"Zoro\" />         <img class=\"opacity-0 position-absolute bottom-0 start-75 speech-bubble\" id=\"zoroastrian-sb\" src=\"cross_cultural/assets/religion/speech_bubble.svg\" />       </div>           </div> </div>") // EJsS HtmlView.HtmlView Page: setting property 'Html' for element 'stage1'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"stage2", _view.gameScreen) // EJsS HtmlView.HtmlView Page: declaration of element 'stage2'
      .setProperty("ClassName","d-none") // EJsS HtmlView.HtmlView Page: setting property 'ClassName' for element 'stage2'
      .setProperty("Html","<div class=\"container text-center\">    <div class=\"row religion-pictures\">       <div class=\"col-4\">          <img class=\"religion-images\" id=\"jainismPic\" src=\"cross_cultural/assets/religion/jainism-pic.svg\" alt=\"Jainism\" />          <div class=\"d-flex justify-content-center flex-column align-items-center\">                      <input type=\"radio\" id=\"jainismIcon\" name=\"card\" value=\"jainism\" />                  <label for=\"jainismIcon\">xx</label>              </div>       </div>       <div class=\"col-4\">          <img class=\"religion-images\" id=\"taoismPic\" src=\"cross_cultural/assets/religion/taoism-pic.svg\" alt=\"Taoism\" />               <div class=\"d-flex justify-content-center flex-column align-items-center\">                     <input type=\"radio\" id=\"taoismIcon\" name=\"card\" value=\"taoism\" />             <label for=\"taoismIcon\">xx</label>           </div>       </div>              <div class=\"col-4\">          <img class=\"religion-images\" id=\"buddhismPic\" src=\"cross_cultural/assets/religion/buddhism-pic.svg\" alt=\"Buddhism\" />             <div class=\"d-flex justify-content-center flex-column align-items-center\">                     <input type=\"radio\" id=\"buddhismIcon\" name=\"card\" value=\"buddhism\" />             <label for=\"buddhismIcon\">xx</label>                </div>       </div>    </div>            <div class=\"row\">       <canvas id=\"my-canvas-2\" width=\"720\" height=\"0\"></canvas>    </div>            <div class=\"row religion-labels\">       <div class=\"col-4 position-relative\">          <div class=\"d-flex justify-content-center flex-column-reverse align-items-center\">                     <input type=\"radio\" id=\"buddhismText\" name=\"match\" value=\"buddhism\" />           <label for=\"buddhismText\">xx</label>           </div>          <img class=\"religion-names\" id=\"buddhismName\" src=\"cross_cultural/assets/religion/buddhism-name.svg\" alt=\"Buddhism\" />              <img class=\"opacity-0 position-absolute bottom-0 start-75 speech-bubble\" id=\"buddhism-sb\" src=\"cross_cultural/assets/religion/speech_bubble.svg\" />               </div>              <div class=\"col-4 position-relative\">         <div class=\"d-flex justify-content-center flex-column-reverse align-items-center\">                     <input type=\"radio\" id=\"taoismText\" name=\"match\" value=\"taoism\" />           <label for=\"taoismText\">xx</label>         </div>         <img class=\"religion-names\" id=\"taoismName\" src=\"cross_cultural/assets/religion/taoism-name.svg\" alt=\"Taoism\" />         <img class=\"opacity-0 position-absolute bottom-0 start-75 speech-bubble\" id=\"taoism-sb\" src=\"cross_cultural/assets/religion/speech_bubble.svg\" />       </div>       <div class=\"col-4 position-relative\">         <div class=\"d-flex justify-content-center flex-column-reverse align-items-center\">                     <input type=\"radio\" id=\"jainismText\" name=\"match\" value=\"jainism\" />           <label for=\"jainismText\">xx</label>         </div>         <img class=\"religion-names\" id=\"jainismName\" src=\"cross_cultural/assets/religion/jainism-name.svg\" alt=\"Juda\" />         <img class=\"opacity-0 position-absolute bottom-0 start-75 speech-bubble\" id=\"jainism-sb\" src=\"cross_cultural/assets/religion/speech_bubble.svg\" />       </div>    </div> </div>") // EJsS HtmlView.HtmlView Page: setting property 'Html' for element 'stage2'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"stage3", _view.gameScreen) // EJsS HtmlView.HtmlView Page: declaration of element 'stage3'
      .setProperty("ClassName","d-none") // EJsS HtmlView.HtmlView Page: setting property 'ClassName' for element 'stage3'
      .setProperty("Html","<div class=\"container text-center\">    <div class=\"row religion-pictures\">       <div class=\"col-3\">          <img class=\"religion-images\" id=\"sikhismPic\" src=\"cross_cultural/assets/religion/sikhism-pic.svg\" alt=\"Sikhism\" />          <div class=\"d-flex justify-content-center flex-column align-items-center\">                      <input type=\"radio\" id=\"sikhismIcon\" name=\"card\" value=\"sikhism\" />                  <label for=\"sikhismIcon\">xx</label>              </div>       </div>       <div class=\"col-3\">          <img class=\"religion-images\" id=\"bahaiPic\" src=\"cross_cultural/assets/religion/baha-pic.svg\" alt=\"Bahai\" />               <div class=\"d-flex justify-content-center flex-column align-items-center\">                     <input type=\"radio\" id=\"bahaiIcon\" name=\"card\" value=\"bahai\" />             <label for=\"bahaiIcon\">xx</label>           </div>       </div>              <div class=\"col-3\">          <img class=\"religion-images\" id=\"islamPic\" src=\"cross_cultural/assets/religion/islam-pic.svg\" alt=\"Islam\" />             <div class=\"d-flex justify-content-center flex-column align-items-center\">                     <input type=\"radio\" id=\"islamIcon\" name=\"card\" value=\"islam\" />             <label for=\"islamIcon\">xx</label>                </div>       </div>                     <div class=\"col-3\">          <img class=\"religion-images\" id=\"christianityPic\" src=\"cross_cultural/assets/religion/christianity-pic.svg\" alt=\"Christianity\" />             <div class=\"d-flex justify-content-center flex-column align-items-center\">                     <input type=\"radio\" id=\"christianityIcon\" name=\"card\" value=\"christianity\" />             <label for=\"christianityIcon\">xx</label>                </div>       </div>    </div>            <div class=\"row\">       <canvas id=\"my-canvas-3\" width=\"720\" height=\"0\"></canvas>    </div>            <div class=\"row religion-labels\">       <div class=\"col-3 position-relative\">          <div class=\"d-flex justify-content-center flex-column-reverse align-items-center\">                     <input type=\"radio\" id=\"christianityText\" name=\"match\" value=\"christianity\" />           <label for=\"christianityText\">xx</label>           </div>          <img class=\"religion-names\" id=\"christianityName\" src=\"cross_cultural/assets/religion/christianity-name.svg\" alt=\"Christian\" />            <img class=\"opacity-0 position-absolute bottom-0 start-75 speech-bubble\" id=\"christianity-sb\" src=\"cross_cultural/assets/religion/speech_bubble.svg\" />       </div>              <div class=\"col-3 position-relative\">         <div class=\"d-flex justify-content-center flex-column-reverse align-items-center\">                     <input type=\"radio\" id=\"islamText\" name=\"match\" value=\"islam\" />           <label for=\"islamText\">xx</label>         </div>         <img class=\"religion-names\" id=\"islamName\" src=\"cross_cultural/assets/religion/islam-name.svg\" alt=\"Islam\" />         <img class=\"opacity-0 position-absolute bottom-0 start-75 speech-bubble\" id=\"islam-sb\" src=\"cross_cultural/assets/religion/speech_bubble.svg\" />       </div>       <div class=\"col-3 position-relative\">         <div class=\"d-flex justify-content-center flex-column-reverse align-items-center\">                     <input type=\"radio\" id=\"sikhismText\" name=\"match\" value=\"sikhism\" />           <label for=\"sikhismText\">xx</label>         </div>         <img class=\"religion-names\" id=\"sikhismName\" src=\"cross_cultural/assets/religion/sikhism-name.svg\" alt=\"Sikhism\" />         <img class=\"opacity-0 position-absolute bottom-0 start-75 speech-bubble\" id=\"sikhism-sb\" src=\"cross_cultural/assets/religion/speech_bubble.svg\" />       </div>              <div class=\"col-3 position-relative\">         <div class=\"d-flex justify-content-center flex-column-reverse align-items-center\">                     <input type=\"radio\" id=\"bahaiText\" name=\"match\" value=\"bahai\" />           <label for=\"bahaiText\">xx</label>         </div>         <img class=\"religion-names\" id=\"bahaiName\" src=\"cross_cultural/assets/religion/baha-name.svg\" alt=\"Bahai\" />         <img class=\"opacity-0 position-absolute bottom-0 start-75 speech-bubble\" id=\"bahai-sb\" src=\"cross_cultural/assets/religion/speech_bubble.svg\" />       </div>    </div> </div>") // EJsS HtmlView.HtmlView Page: setting property 'Html' for element 'stage3'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"bottomInfo", _view.gameScreen) // EJsS HtmlView.HtmlView Page: declaration of element 'bottomInfo'
      .setProperty("Display","flex") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'bottomInfo'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"_21CCName", _view.bottomInfo) // EJsS HtmlView.HtmlView Page: declaration of element '_21CCName'
      .setProperty("Html","<svg width=\"313\" height=\"60\" viewBox=\"0 0 313 60\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"> <g filter=\"url(#filter0_d_1_2)\"> <path d=\"M0 0H288C299.046 0 308 8.95431 308 20V55H20C8.95431 55 0 46.0457 0 35V0Z\" fill=\"white\"/> <path d=\"M19.3051 36.132C18.3958 36.132 17.5524 35.9707 16.7751 35.648C15.9978 35.3107 15.3744 34.7753 14.9051 34.042C14.4504 33.294 14.2231 32.304 14.2231 31.072V24.978C14.2231 23.746 14.4504 22.7633 14.9051 22.03C15.3744 21.282 15.9978 20.7467 16.7751 20.424C17.5524 20.0867 18.4031 19.918 19.3271 19.918C20.3538 19.918 21.2558 20.094 22.0331 20.446C22.8251 20.7833 23.4411 21.26 23.8811 21.876C24.3358 22.492 24.5631 23.2327 24.5631 24.098C24.5631 24.67 24.4458 25.0513 24.2111 25.242C23.9764 25.418 23.6171 25.506 23.1331 25.506C22.7371 25.506 22.3998 25.44 22.1211 25.308C21.8571 25.1613 21.7178 24.9267 21.7031 24.604C21.7031 24.428 21.6738 24.2227 21.6151 23.988C21.5711 23.7387 21.4758 23.4967 21.3291 23.262C21.1824 23.0273 20.9551 22.8293 20.6471 22.668C20.3538 22.5067 19.9431 22.426 19.4151 22.426C18.6671 22.426 18.0951 22.6387 17.6991 23.064C17.3031 23.4747 17.1051 24.1127 17.1051 24.978V31.072C17.1051 31.952 17.3031 32.5973 17.6991 33.008C18.1098 33.4187 18.6964 33.624 19.4591 33.624C19.9578 33.624 20.3538 33.5433 20.6471 33.382C20.9404 33.2207 21.1531 33.0227 21.2851 32.788C21.4318 32.5387 21.5271 32.282 21.5711 32.018C21.6298 31.754 21.6738 31.5047 21.7031 31.27C21.7324 30.918 21.8791 30.6833 22.1431 30.566C22.4071 30.434 22.7298 30.368 23.1111 30.368C23.6098 30.368 23.9764 30.4633 24.2111 30.654C24.4458 30.8447 24.5631 31.2187 24.5631 31.776C24.5631 32.656 24.3358 33.426 23.8811 34.086C23.4411 34.746 22.8251 35.252 22.0331 35.604C21.2411 35.956 20.3318 36.132 19.3051 36.132ZM35.3383 36.11C35.1476 36.11 34.957 36.0513 34.7663 35.934C34.5903 35.8167 34.451 35.648 34.3483 35.428L31.2243 29.356H29.3763V35.076C29.3763 35.384 29.2296 35.6187 28.9363 35.78C28.643 35.9267 28.313 36 27.9463 36C27.5943 36 27.2643 35.9267 26.9563 35.78C26.663 35.6187 26.5163 35.384 26.5163 35.076V20.82C26.5163 20.5707 26.597 20.358 26.7583 20.182C26.9343 20.006 27.1616 19.918 27.4403 19.918H31.7963C32.7643 19.918 33.637 20.0573 34.4143 20.336C35.2063 20.6147 35.837 21.0913 36.3063 21.766C36.7756 22.426 37.0103 23.3427 37.0103 24.516C37.0103 25.3667 36.8856 26.0927 36.6363 26.694C36.387 27.2807 36.0423 27.7573 35.6023 28.124C35.177 28.476 34.6856 28.74 34.1283 28.916L37.0323 34.262C37.0616 34.3207 37.0836 34.3867 37.0983 34.46C37.113 34.5187 37.1203 34.57 37.1203 34.614C37.1203 34.8487 37.0323 35.0833 36.8563 35.318C36.6803 35.5527 36.453 35.7433 36.1743 35.89C35.9103 36.0367 35.6316 36.11 35.3383 36.11ZM29.3763 27.112H31.7963C32.515 27.112 33.087 26.936 33.5123 26.584C33.9376 26.232 34.1503 25.6307 34.1503 24.78C34.1503 23.9 33.9376 23.2913 33.5123 22.954C33.087 22.602 32.515 22.426 31.7963 22.426H29.3763V27.112ZM44.0142 36.132C43.0462 36.132 42.1735 35.9707 41.3962 35.648C40.6189 35.3107 39.9955 34.7753 39.5262 34.042C39.0715 33.294 38.8442 32.304 38.8442 31.072V24.978C38.8442 23.746 39.0715 22.7633 39.5262 22.03C39.9955 21.282 40.6115 20.7467 41.3742 20.424C42.1515 20.0867 43.0315 19.918 44.0142 19.918C44.9822 19.918 45.8549 20.0867 46.6322 20.424C47.4242 20.7467 48.0475 21.282 48.5022 22.03C48.9569 22.7633 49.1842 23.746 49.1842 24.978V31.072C49.1842 32.304 48.9569 33.294 48.5022 34.042C48.0475 34.7753 47.4242 35.3107 46.6322 35.648C45.8549 35.9707 44.9822 36.132 44.0142 36.132ZM44.0142 33.624C44.7329 33.624 45.2975 33.4187 45.7082 33.008C46.1189 32.5973 46.3242 31.952 46.3242 31.072V24.978C46.3242 24.098 46.1189 23.4527 45.7082 23.042C45.2975 22.6313 44.7329 22.426 44.0142 22.426C43.2955 22.426 42.7309 22.6313 42.3202 23.042C41.9242 23.4527 41.7262 24.098 41.7262 24.978V31.072C41.7262 31.952 41.9242 32.5973 42.3202 33.008C42.7309 33.4187 43.2955 33.624 44.0142 33.624ZM55.943 36.198C54.9897 36.198 54.1243 36.0587 53.347 35.78C52.5843 35.5013 51.9757 35.1567 51.521 34.746C51.081 34.3207 50.861 33.8953 50.861 33.47C50.861 33.2647 50.9123 33.0447 51.015 32.81C51.1323 32.5607 51.2863 32.3553 51.477 32.194C51.6677 32.018 51.8803 31.93 52.115 31.93C52.3497 31.93 52.5697 32.018 52.775 32.194C52.9803 32.3553 53.215 32.5533 53.479 32.788C53.743 33.008 54.0657 33.206 54.447 33.382C54.8283 33.5433 55.2977 33.624 55.855 33.624C56.295 33.624 56.6983 33.558 57.065 33.426C57.4463 33.2793 57.747 33.0667 57.967 32.788C58.2017 32.5093 58.319 32.15 58.319 31.71C58.319 31.2407 58.1943 30.8447 57.945 30.522C57.6957 30.1993 57.3583 29.9207 56.933 29.686C56.5077 29.4513 56.0457 29.224 55.547 29.004C55.0483 28.784 54.5423 28.5493 54.029 28.3C53.5303 28.0507 53.0683 27.75 52.643 27.398C52.2323 27.046 51.895 26.6133 51.631 26.1C51.3817 25.5867 51.257 24.956 51.257 24.208C51.257 23.3867 51.411 22.6973 51.719 22.14C52.0417 21.5827 52.4597 21.1353 52.973 20.798C53.501 20.446 54.0803 20.1967 54.711 20.05C55.3417 19.8887 55.9723 19.808 56.603 19.808C56.9403 19.808 57.3363 19.8373 57.791 19.896C58.2603 19.94 58.7223 20.028 59.177 20.16C59.6463 20.292 60.0277 20.4753 60.321 20.71C60.629 20.93 60.783 21.2233 60.783 21.59C60.783 21.7513 60.739 21.9493 60.651 22.184C60.5777 22.4187 60.453 22.6313 60.277 22.822C60.1157 23.0127 59.903 23.108 59.639 23.108C59.4043 23.108 59.1697 23.042 58.935 22.91C58.715 22.7633 58.4217 22.624 58.055 22.492C57.703 22.3453 57.219 22.272 56.603 22.272C56.0897 22.272 55.6423 22.338 55.261 22.47C54.8797 22.602 54.5937 22.7927 54.403 23.042C54.2123 23.2767 54.117 23.5773 54.117 23.944C54.117 24.3253 54.2417 24.648 54.491 24.912C54.755 25.176 55.0923 25.4107 55.503 25.616C55.9283 25.8213 56.3903 26.0267 56.889 26.232C57.3877 26.4373 57.8863 26.6793 58.385 26.958C58.8983 27.222 59.3677 27.5447 59.793 27.926C60.2183 28.3073 60.5557 28.784 60.805 29.356C61.0543 29.9133 61.179 30.6027 61.179 31.424C61.179 32.4653 60.9517 33.3453 60.497 34.064C60.0423 34.768 59.419 35.3033 58.627 35.67C57.8497 36.022 56.955 36.198 55.943 36.198ZM67.4371 36.198C66.4838 36.198 65.6185 36.0587 64.8411 35.78C64.0785 35.5013 63.4698 35.1567 63.0151 34.746C62.5751 34.3207 62.3551 33.8953 62.3551 33.47C62.3551 33.2647 62.4065 33.0447 62.5091 32.81C62.6265 32.5607 62.7805 32.3553 62.9711 32.194C63.1618 32.018 63.3745 31.93 63.6091 31.93C63.8438 31.93 64.0638 32.018 64.2691 32.194C64.4745 32.3553 64.7091 32.5533 64.9731 32.788C65.2371 33.008 65.5598 33.206 65.9411 33.382C66.3225 33.5433 66.7918 33.624 67.3491 33.624C67.7891 33.624 68.1925 33.558 68.5591 33.426C68.9405 33.2793 69.2411 33.0667 69.4611 32.788C69.6958 32.5093 69.8131 32.15 69.8131 31.71C69.8131 31.2407 69.6885 30.8447 69.4391 30.522C69.1898 30.1993 68.8525 29.9207 68.4271 29.686C68.0018 29.4513 67.5398 29.224 67.0411 29.004C66.5425 28.784 66.0365 28.5493 65.5231 28.3C65.0245 28.0507 64.5625 27.75 64.1371 27.398C63.7265 27.046 63.3891 26.6133 63.1251 26.1C62.8758 25.5867 62.7511 24.956 62.7511 24.208C62.7511 23.3867 62.9051 22.6973 63.2131 22.14C63.5358 21.5827 63.9538 21.1353 64.4671 20.798C64.9951 20.446 65.5745 20.1967 66.2051 20.05C66.8358 19.8887 67.4665 19.808 68.0971 19.808C68.4345 19.808 68.8305 19.8373 69.2851 19.896C69.7545 19.94 70.2165 20.028 70.6711 20.16C71.1405 20.292 71.5218 20.4753 71.8151 20.71C72.1231 20.93 72.2771 21.2233 72.2771 21.59C72.2771 21.7513 72.2331 21.9493 72.1451 22.184C72.0718 22.4187 71.9471 22.6313 71.7711 22.822C71.6098 23.0127 71.3971 23.108 71.1331 23.108C70.8985 23.108 70.6638 23.042 70.4291 22.91C70.2091 22.7633 69.9158 22.624 69.5491 22.492C69.1971 22.3453 68.7131 22.272 68.0971 22.272C67.5838 22.272 67.1365 22.338 66.7551 22.47C66.3738 22.602 66.0878 22.7927 65.8971 23.042C65.7065 23.2767 65.6111 23.5773 65.6111 23.944C65.6111 24.3253 65.7358 24.648 65.9851 24.912C66.2491 25.176 66.5865 25.4107 66.9971 25.616C67.4225 25.8213 67.8845 26.0267 68.3831 26.232C68.8818 26.4373 69.3805 26.6793 69.8791 26.958C70.3925 27.222 70.8618 27.5447 71.2871 27.926C71.7125 28.3073 72.0498 28.784 72.2991 29.356C72.5485 29.9133 72.6731 30.6027 72.6731 31.424C72.6731 32.4653 72.4458 33.3453 71.9911 34.064C71.5365 34.768 70.9131 35.3033 70.1211 35.67C69.3438 36.022 68.4491 36.198 67.4371 36.198ZM74.9933 31.886C74.7293 31.886 74.5093 31.776 74.3333 31.556C74.172 31.336 74.0913 31.0573 74.0913 30.72C74.0913 30.3827 74.172 30.104 74.3333 29.884C74.5093 29.6493 74.7293 29.532 74.9933 29.532H80.7133C80.9333 29.532 81.1386 29.6493 81.3293 29.884C81.52 30.104 81.6153 30.3827 81.6153 30.72C81.6153 31.0573 81.52 31.336 81.3293 31.556C81.1386 31.776 80.9333 31.886 80.7133 31.886H74.9933ZM88.5922 36.132C87.6829 36.132 86.8395 35.9707 86.0622 35.648C85.2849 35.3107 84.6615 34.7753 84.1922 34.042C83.7375 33.294 83.5102 32.304 83.5102 31.072V24.978C83.5102 23.746 83.7375 22.7633 84.1922 22.03C84.6615 21.282 85.2849 20.7467 86.0622 20.424C86.8395 20.0867 87.6902 19.918 88.6142 19.918C89.6409 19.918 90.5429 20.094 91.3202 20.446C92.1122 20.7833 92.7282 21.26 93.1682 21.876C93.6229 22.492 93.8502 23.2327 93.8502 24.098C93.8502 24.67 93.7329 25.0513 93.4982 25.242C93.2635 25.418 92.9042 25.506 92.4202 25.506C92.0242 25.506 91.6869 25.44 91.4082 25.308C91.1442 25.1613 91.0049 24.9267 90.9902 24.604C90.9902 24.428 90.9609 24.2227 90.9022 23.988C90.8582 23.7387 90.7629 23.4967 90.6162 23.262C90.4695 23.0273 90.2422 22.8293 89.9342 22.668C89.6409 22.5067 89.2302 22.426 88.7022 22.426C87.9542 22.426 87.3822 22.6387 86.9862 23.064C86.5902 23.4747 86.3922 24.1127 86.3922 24.978V31.072C86.3922 31.952 86.5902 32.5973 86.9862 33.008C87.3969 33.4187 87.9835 33.624 88.7462 33.624C89.2449 33.624 89.6409 33.5433 89.9342 33.382C90.2275 33.2207 90.4402 33.0227 90.5722 32.788C90.7189 32.5387 90.8142 32.282 90.8582 32.018C90.9169 31.754 90.9609 31.5047 90.9902 31.27C91.0195 30.918 91.1662 30.6833 91.4302 30.566C91.6942 30.434 92.0169 30.368 92.3982 30.368C92.8969 30.368 93.2635 30.4633 93.4982 30.654C93.7329 30.8447 93.8502 31.2187 93.8502 31.776C93.8502 32.656 93.6229 33.426 93.1682 34.086C92.7282 34.746 92.1122 35.252 91.3202 35.604C90.5282 35.956 89.6189 36.132 88.5922 36.132ZM101.017 36.132C100.02 36.132 99.1254 35.9707 98.3334 35.648C97.5414 35.3107 96.9107 34.7753 96.4414 34.042C95.9721 33.294 95.7374 32.304 95.7374 31.072V20.82C95.7374 20.4973 95.8841 20.27 96.1774 20.138C96.4707 19.9913 96.8007 19.918 97.1674 19.918C97.5194 19.918 97.8421 19.9913 98.1354 20.138C98.4434 20.27 98.5974 20.4973 98.5974 20.82V31.072C98.5974 31.9373 98.8101 32.5827 99.2354 33.008C99.6607 33.4187 100.255 33.624 101.017 33.624C101.765 33.624 102.352 33.4187 102.777 33.008C103.217 32.5827 103.437 31.9373 103.437 31.072V20.82C103.437 20.4973 103.577 20.27 103.855 20.138C104.149 19.9913 104.486 19.918 104.867 19.918C105.219 19.918 105.542 19.9913 105.835 20.138C106.143 20.27 106.297 20.4973 106.297 20.82V31.072C106.297 32.304 106.063 33.294 105.593 34.042C105.124 34.7753 104.486 35.3107 103.679 35.648C102.887 35.9707 102 36.132 101.017 36.132ZM110.12 36C109.812 36 109.526 35.9267 109.262 35.78C108.998 35.6187 108.866 35.384 108.866 35.076V20.82C108.866 20.4973 109.013 20.27 109.306 20.138C109.614 19.9913 109.944 19.918 110.296 19.918C110.663 19.918 110.993 19.9913 111.286 20.138C111.579 20.27 111.726 20.4973 111.726 20.82V33.492H117.116C117.409 33.492 117.622 33.624 117.754 33.888C117.886 34.1373 117.952 34.4233 117.952 34.746C117.952 35.054 117.886 35.34 117.754 35.604C117.622 35.868 117.409 36 117.116 36H110.12ZM121.839 36C121.473 36 121.143 35.9267 120.849 35.78C120.556 35.6187 120.409 35.384 120.409 35.076V22.492H117.175C116.897 22.492 116.677 22.36 116.515 22.096C116.354 21.832 116.273 21.5313 116.273 21.194C116.273 20.886 116.347 20.6 116.493 20.336C116.64 20.0573 116.867 19.918 117.175 19.918H126.481C126.804 19.918 127.031 20.0573 127.163 20.336C127.31 20.6 127.383 20.886 127.383 21.194C127.383 21.5313 127.303 21.832 127.141 22.096C126.995 22.36 126.775 22.492 126.481 22.492H123.269V35.076C123.269 35.384 123.115 35.6187 122.807 35.78C122.514 35.9267 122.191 36 121.839 36ZM134.125 36.132C133.127 36.132 132.233 35.9707 131.441 35.648C130.649 35.3107 130.018 34.7753 129.549 34.042C129.079 33.294 128.845 32.304 128.845 31.072V20.82C128.845 20.4973 128.991 20.27 129.285 20.138C129.578 19.9913 129.908 19.918 130.275 19.918C130.627 19.918 130.949 19.9913 131.243 20.138C131.551 20.27 131.705 20.4973 131.705 20.82V31.072C131.705 31.9373 131.917 32.5827 132.343 33.008C132.768 33.4187 133.362 33.624 134.125 33.624C134.873 33.624 135.459 33.4187 135.885 33.008C136.325 32.5827 136.545 31.9373 136.545 31.072V20.82C136.545 20.4973 136.684 20.27 136.963 20.138C137.256 19.9913 137.593 19.918 137.975 19.918C138.327 19.918 138.649 19.9913 138.943 20.138C139.251 20.27 139.405 20.4973 139.405 20.82V31.072C139.405 32.304 139.17 33.294 138.701 34.042C138.231 34.7753 137.593 35.3107 136.787 35.648C135.995 35.9707 135.107 36.132 134.125 36.132ZM150.795 36.11C150.605 36.11 150.414 36.0513 150.223 35.934C150.047 35.8167 149.908 35.648 149.805 35.428L146.681 29.356H144.833V35.076C144.833 35.384 144.687 35.6187 144.393 35.78C144.1 35.9267 143.77 36 143.403 36C143.051 36 142.721 35.9267 142.413 35.78C142.12 35.6187 141.973 35.384 141.973 35.076V20.82C141.973 20.5707 142.054 20.358 142.215 20.182C142.391 20.006 142.619 19.918 142.897 19.918H147.253C148.221 19.918 149.094 20.0573 149.871 20.336C150.663 20.6147 151.294 21.0913 151.763 21.766C152.233 22.426 152.467 23.3427 152.467 24.516C152.467 25.3667 152.343 26.0927 152.093 26.694C151.844 27.2807 151.499 27.7573 151.059 28.124C150.634 28.476 150.143 28.74 149.585 28.916L152.489 34.262C152.519 34.3207 152.541 34.3867 152.555 34.46C152.57 34.5187 152.577 34.57 152.577 34.614C152.577 34.8487 152.489 35.0833 152.313 35.318C152.137 35.5527 151.91 35.7433 151.631 35.89C151.367 36.0367 151.089 36.11 150.795 36.11ZM144.833 27.112H147.253C147.972 27.112 148.544 26.936 148.969 26.584C149.395 26.232 149.607 25.6307 149.607 24.78C149.607 23.9 149.395 23.2913 148.969 22.954C148.544 22.602 147.972 22.426 147.253 22.426H144.833V27.112ZM155.159 36C154.895 36 154.624 35.9487 154.345 35.846C154.067 35.7433 153.832 35.604 153.641 35.428C153.451 35.252 153.355 35.0467 153.355 34.812C153.355 34.768 153.363 34.6947 153.377 34.592L157.623 20.754C157.726 20.4313 157.953 20.1893 158.305 20.028C158.672 19.8667 159.061 19.786 159.471 19.786C159.897 19.786 160.285 19.8667 160.637 20.028C160.989 20.1893 161.217 20.4313 161.319 20.754L165.565 34.592C165.595 34.6947 165.609 34.768 165.609 34.812C165.609 35.032 165.507 35.2373 165.301 35.428C165.111 35.604 164.876 35.7433 164.597 35.846C164.319 35.9487 164.047 36 163.783 36C163.549 36 163.343 35.9633 163.167 35.89C163.006 35.802 162.896 35.648 162.837 35.428L162.001 32.502H156.941L156.127 35.428C156.069 35.648 155.951 35.802 155.775 35.89C155.599 35.9633 155.394 36 155.159 36ZM157.557 30.258H161.385L159.471 23.504L157.557 30.258ZM168.364 36C168.056 36 167.77 35.9267 167.506 35.78C167.242 35.6187 167.11 35.384 167.11 35.076V20.82C167.11 20.4973 167.257 20.27 167.55 20.138C167.858 19.9913 168.188 19.918 168.54 19.918C168.907 19.918 169.237 19.9913 169.53 20.138C169.823 20.27 169.97 20.4973 169.97 20.82V33.492H175.36C175.653 33.492 175.866 33.624 175.998 33.888C176.13 34.1373 176.196 34.4233 176.196 34.746C176.196 35.054 176.13 35.34 175.998 35.604C175.866 35.868 175.653 36 175.36 36H168.364ZM182.831 36C182.567 36 182.296 35.9487 182.017 35.846C181.738 35.7433 181.504 35.604 181.313 35.428C181.122 35.252 181.027 35.0467 181.027 34.812C181.027 34.768 181.034 34.6947 181.049 34.592L185.295 20.754C185.398 20.4313 185.625 20.1893 185.977 20.028C186.344 19.8667 186.732 19.786 187.143 19.786C187.568 19.786 187.957 19.8667 188.309 20.028C188.661 20.1893 188.888 20.4313 188.991 20.754L193.237 34.592C193.266 34.6947 193.281 34.768 193.281 34.812C193.281 35.032 193.178 35.2373 192.973 35.428C192.782 35.604 192.548 35.7433 192.269 35.846C191.99 35.9487 191.719 36 191.455 36C191.22 36 191.015 35.9633 190.839 35.89C190.678 35.802 190.568 35.648 190.509 35.428L189.673 32.502H184.613L183.799 35.428C183.74 35.648 183.623 35.802 183.447 35.89C183.271 35.9633 183.066 36 182.831 36ZM185.229 30.258H189.057L187.143 23.504L185.229 30.258ZM199.049 36.132C198.638 36.132 198.249 36.0513 197.883 35.89C197.516 35.7287 197.281 35.4867 197.179 35.164L192.823 21.326C192.793 21.238 192.779 21.15 192.779 21.062C192.779 20.842 192.874 20.6513 193.065 20.49C193.255 20.314 193.49 20.1747 193.769 20.072C194.062 19.9693 194.341 19.918 194.605 19.918C194.825 19.918 195.023 19.962 195.199 20.05C195.389 20.138 195.507 20.2847 195.551 20.49L199.027 32.414L200.897 24.758C200.97 24.494 201.139 24.296 201.403 24.164C201.681 24.032 201.982 23.966 202.305 23.966C202.627 23.966 202.921 24.032 203.185 24.164C203.463 24.296 203.632 24.494 203.691 24.758L205.561 32.414L209.037 20.49C209.095 20.2847 209.213 20.138 209.389 20.05C209.565 19.962 209.763 19.918 209.983 19.918C210.261 19.918 210.54 19.9693 210.819 20.072C211.097 20.1747 211.332 20.314 211.523 20.49C211.713 20.6513 211.809 20.842 211.809 21.062C211.809 21.15 211.794 21.238 211.765 21.326L207.409 35.164C207.291 35.4867 207.057 35.7287 206.705 35.89C206.353 36.0513 205.964 36.132 205.539 36.132C205.128 36.132 204.739 36.0513 204.373 35.89C204.006 35.7287 203.786 35.4867 203.713 35.164L202.305 29.224L200.875 35.164C200.801 35.4867 200.581 35.7287 200.215 35.89C199.848 36.0513 199.459 36.132 199.049 36.132ZM213.124 36C212.86 36 212.589 35.9487 212.31 35.846C212.031 35.7433 211.797 35.604 211.606 35.428C211.415 35.252 211.32 35.0467 211.32 34.812C211.32 34.768 211.327 34.6947 211.342 34.592L215.588 20.754C215.691 20.4313 215.918 20.1893 216.27 20.028C216.637 19.8667 217.025 19.786 217.436 19.786C217.861 19.786 218.25 19.8667 218.602 20.028C218.954 20.1893 219.181 20.4313 219.284 20.754L223.53 34.592C223.559 34.6947 223.574 34.768 223.574 34.812C223.574 35.032 223.471 35.2373 223.266 35.428C223.075 35.604 222.841 35.7433 222.562 35.846C222.283 35.9487 222.012 36 221.748 36C221.513 36 221.308 35.9633 221.132 35.89C220.971 35.802 220.861 35.648 220.802 35.428L219.966 32.502H214.906L214.092 35.428C214.033 35.648 213.916 35.802 213.74 35.89C213.564 35.9633 213.359 36 213.124 36ZM215.522 30.258H219.35L217.436 23.504L215.522 30.258ZM233.897 36.11C233.706 36.11 233.516 36.0513 233.325 35.934C233.149 35.8167 233.01 35.648 232.907 35.428L229.783 29.356H227.935V35.076C227.935 35.384 227.788 35.6187 227.495 35.78C227.202 35.9267 226.872 36 226.505 36C226.153 36 225.823 35.9267 225.515 35.78C225.222 35.6187 225.075 35.384 225.075 35.076V20.82C225.075 20.5707 225.156 20.358 225.317 20.182C225.493 20.006 225.72 19.918 225.999 19.918H230.355C231.323 19.918 232.196 20.0573 232.973 20.336C233.765 20.6147 234.396 21.0913 234.865 21.766C235.334 22.426 235.569 23.3427 235.569 24.516C235.569 25.3667 235.444 26.0927 235.195 26.694C234.946 27.2807 234.601 27.7573 234.161 28.124C233.736 28.476 233.244 28.74 232.687 28.916L235.591 34.262C235.62 34.3207 235.642 34.3867 235.657 34.46C235.672 34.5187 235.679 34.57 235.679 34.614C235.679 34.8487 235.591 35.0833 235.415 35.318C235.239 35.5527 235.012 35.7433 234.733 35.89C234.469 36.0367 234.19 36.11 233.897 36.11ZM227.935 27.112H230.355C231.074 27.112 231.646 26.936 232.071 26.584C232.496 26.232 232.709 25.6307 232.709 24.78C232.709 23.9 232.496 23.2913 232.071 22.954C231.646 22.602 231.074 22.426 230.355 22.426H227.935V27.112ZM238.833 36C238.525 36 238.239 35.9267 237.975 35.78C237.711 35.6187 237.579 35.384 237.579 35.076V20.842C237.579 20.534 237.711 20.3067 237.975 20.16C238.239 19.9987 238.525 19.918 238.833 19.918H246.665C246.987 19.918 247.215 20.05 247.347 20.314C247.493 20.578 247.567 20.8567 247.567 21.15C247.567 21.502 247.486 21.8027 247.325 22.052C247.178 22.3013 246.958 22.426 246.665 22.426H240.439V26.826H243.783C244.076 26.826 244.296 26.9433 244.443 27.178C244.604 27.398 244.685 27.662 244.685 27.97C244.685 28.2193 244.611 28.4687 244.465 28.718C244.333 28.9527 244.105 29.07 243.783 29.07H240.439V33.492H246.665C246.958 33.492 247.178 33.6167 247.325 33.866C247.486 34.1153 247.567 34.416 247.567 34.768C247.567 35.0613 247.493 35.34 247.347 35.604C247.215 35.868 246.987 36 246.665 36H238.833ZM250.675 36C250.323 36 249.993 35.9267 249.685 35.78C249.391 35.6187 249.245 35.384 249.245 35.076V20.82C249.245 20.512 249.391 20.2847 249.685 20.138C249.993 19.9913 250.323 19.918 250.675 19.918C251.027 19.918 251.313 19.9547 251.533 20.028C251.767 20.1013 251.98 20.248 252.171 20.468C252.376 20.6733 252.589 20.996 252.809 21.436L257.055 29.642V20.82C257.055 20.4973 257.201 20.27 257.495 20.138C257.803 19.9913 258.133 19.918 258.485 19.918C258.851 19.918 259.181 19.9913 259.475 20.138C259.768 20.27 259.915 20.4973 259.915 20.82V35.076C259.915 35.384 259.768 35.6187 259.475 35.78C259.181 35.9267 258.851 36 258.485 36C258.147 36 257.832 35.934 257.539 35.802C257.26 35.67 257.033 35.4353 256.857 35.098L252.105 26.254V35.076C252.105 35.384 251.958 35.6187 251.665 35.78C251.371 35.9267 251.041 36 250.675 36ZM263.841 36C263.533 36 263.247 35.9267 262.983 35.78C262.719 35.6187 262.587 35.384 262.587 35.076V20.842C262.587 20.534 262.719 20.3067 262.983 20.16C263.247 19.9987 263.533 19.918 263.841 19.918H271.673C271.995 19.918 272.223 20.05 272.355 20.314C272.501 20.578 272.575 20.8567 272.575 21.15C272.575 21.502 272.494 21.8027 272.333 22.052C272.186 22.3013 271.966 22.426 271.673 22.426H265.447V26.826H268.791C269.084 26.826 269.304 26.9433 269.451 27.178C269.612 27.398 269.693 27.662 269.693 27.97C269.693 28.2193 269.619 28.4687 269.473 28.718C269.341 28.9527 269.113 29.07 268.791 29.07H265.447V33.492H271.673C271.966 33.492 272.186 33.6167 272.333 33.866C272.494 34.1153 272.575 34.416 272.575 34.768C272.575 35.0613 272.501 35.34 272.355 35.604C272.223 35.868 271.995 36 271.673 36H263.841ZM278.543 36.198C277.589 36.198 276.724 36.0587 275.947 35.78C275.184 35.5013 274.575 35.1567 274.121 34.746C273.681 34.3207 273.461 33.8953 273.461 33.47C273.461 33.2647 273.512 33.0447 273.615 32.81C273.732 32.5607 273.886 32.3553 274.077 32.194C274.267 32.018 274.48 31.93 274.715 31.93C274.949 31.93 275.169 32.018 275.375 32.194C275.58 32.3553 275.815 32.5533 276.079 32.788C276.343 33.008 276.665 33.206 277.047 33.382C277.428 33.5433 277.897 33.624 278.455 33.624C278.895 33.624 279.298 33.558 279.665 33.426C280.046 33.2793 280.347 33.0667 280.567 32.788C280.801 32.5093 280.919 32.15 280.919 31.71C280.919 31.2407 280.794 30.8447 280.545 30.522C280.295 30.1993 279.958 29.9207 279.533 29.686C279.107 29.4513 278.645 29.224 278.147 29.004C277.648 28.784 277.142 28.5493 276.629 28.3C276.13 28.0507 275.668 27.75 275.243 27.398C274.832 27.046 274.495 26.6133 274.231 26.1C273.981 25.5867 273.857 24.956 273.857 24.208C273.857 23.3867 274.011 22.6973 274.319 22.14C274.641 21.5827 275.059 21.1353 275.573 20.798C276.101 20.446 276.68 20.1967 277.311 20.05C277.941 19.8887 278.572 19.808 279.203 19.808C279.54 19.808 279.936 19.8373 280.391 19.896C280.86 19.94 281.322 20.028 281.777 20.16C282.246 20.292 282.627 20.4753 282.921 20.71C283.229 20.93 283.383 21.2233 283.383 21.59C283.383 21.7513 283.339 21.9493 283.251 22.184C283.177 22.4187 283.053 22.6313 282.877 22.822C282.715 23.0127 282.503 23.108 282.239 23.108C282.004 23.108 281.769 23.042 281.535 22.91C281.315 22.7633 281.021 22.624 280.655 22.492C280.303 22.3453 279.819 22.272 279.203 22.272C278.689 22.272 278.242 22.338 277.861 22.47C277.479 22.602 277.193 22.7927 277.003 23.042C276.812 23.2767 276.717 23.5773 276.717 23.944C276.717 24.3253 276.841 24.648 277.091 24.912C277.355 25.176 277.692 25.4107 278.103 25.616C278.528 25.8213 278.99 26.0267 279.489 26.232C279.987 26.4373 280.486 26.6793 280.985 26.958C281.498 27.222 281.967 27.5447 282.393 27.926C282.818 28.3073 283.155 28.784 283.405 29.356C283.654 29.9133 283.779 30.6027 283.779 31.424C283.779 32.4653 283.551 33.3453 283.097 34.064C282.642 34.768 282.019 35.3033 281.227 35.67C280.449 36.022 279.555 36.198 278.543 36.198ZM290.037 36.198C289.083 36.198 288.218 36.0587 287.441 35.78C286.678 35.5013 286.069 35.1567 285.615 34.746C285.175 34.3207 284.955 33.8953 284.955 33.47C284.955 33.2647 285.006 33.0447 285.109 32.81C285.226 32.5607 285.38 32.3553 285.571 32.194C285.761 32.018 285.974 31.93 286.209 31.93C286.443 31.93 286.663 32.018 286.869 32.194C287.074 32.3553 287.309 32.5533 287.573 32.788C287.837 33.008 288.159 33.206 288.541 33.382C288.922 33.5433 289.391 33.624 289.949 33.624C290.389 33.624 290.792 33.558 291.159 33.426C291.54 33.2793 291.841 33.0667 292.061 32.788C292.295 32.5093 292.413 32.15 292.413 31.71C292.413 31.2407 292.288 30.8447 292.039 30.522C291.789 30.1993 291.452 29.9207 291.027 29.686C290.601 29.4513 290.139 29.224 289.641 29.004C289.142 28.784 288.636 28.5493 288.123 28.3C287.624 28.0507 287.162 27.75 286.737 27.398C286.326 27.046 285.989 26.6133 285.725 26.1C285.475 25.5867 285.351 24.956 285.351 24.208C285.351 23.3867 285.505 22.6973 285.813 22.14C286.135 21.5827 286.553 21.1353 287.067 20.798C287.595 20.446 288.174 20.1967 288.805 20.05C289.435 19.8887 290.066 19.808 290.697 19.808C291.034 19.808 291.43 19.8373 291.885 19.896C292.354 19.94 292.816 20.028 293.271 20.16C293.74 20.292 294.121 20.4753 294.415 20.71C294.723 20.93 294.877 21.2233 294.877 21.59C294.877 21.7513 294.833 21.9493 294.745 22.184C294.671 22.4187 294.547 22.6313 294.371 22.822C294.209 23.0127 293.997 23.108 293.733 23.108C293.498 23.108 293.263 23.042 293.029 22.91C292.809 22.7633 292.515 22.624 292.149 22.492C291.797 22.3453 291.313 22.272 290.697 22.272C290.183 22.272 289.736 22.338 289.355 22.47C288.973 22.602 288.687 22.7927 288.497 23.042C288.306 23.2767 288.211 23.5773 288.211 23.944C288.211 24.3253 288.335 24.648 288.585 24.912C288.849 25.176 289.186 25.4107 289.597 25.616C290.022 25.8213 290.484 26.0267 290.983 26.232C291.481 26.4373 291.98 26.6793 292.479 26.958C292.992 27.222 293.461 27.5447 293.887 27.926C294.312 28.3073 294.649 28.784 294.899 29.356C295.148 29.9133 295.273 30.6027 295.273 31.424C295.273 32.4653 295.045 33.3453 294.591 34.064C294.136 34.768 293.513 35.3033 292.721 35.67C291.943 36.022 291.049 36.198 290.037 36.198Z\" fill=\"#FF0082\"/> <path d=\"M1.5 1.5H288C298.217 1.5 306.5 9.78273 306.5 20V53.5H20C9.78274 53.5 1.5 45.2173 1.5 35V1.5Z\" stroke=\"#F7CFE5\" stroke-width=\"3\"/> </g> <defs> <filter id=\"filter0_d_1_2\" x=\"0\" y=\"0\" width=\"313\" height=\"60\" filterUnits=\"userSpaceOnUse\" color-interpolation-filters=\"sRGB\"> <feFlood flood-opacity=\"0\" result=\"BackgroundImageFix\"/> <feColorMatrix in=\"SourceAlpha\" type=\"matrix\" values=\"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0\" result=\"hardAlpha\"/> <feOffset dx=\"5\" dy=\"5\"/> <feComposite in2=\"hardAlpha\" operator=\"out\"/> <feColorMatrix type=\"matrix\" values=\"0 0 0 0 0.956863 0 0 0 0 0.490196 0 0 0 0 0.380392 0 0 0 1 0\"/> <feBlend mode=\"normal\" in2=\"BackgroundImageFix\" result=\"effect1_dropShadow_1_2\"/> <feBlend mode=\"normal\" in=\"SourceGraphic\" in2=\"effect1_dropShadow_1_2\" result=\"shape\"/> </filter> </defs> </svg>") // EJsS HtmlView.HtmlView Page: setting property 'Html' for element '_21CCName'
      .setProperty("Display","none") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element '_21CCName'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"progressBarContainer", _view.bottomInfo) // EJsS HtmlView.HtmlView Page: declaration of element 'progressBarContainer'
      .setProperty("Html","<div id=\"progressBar\">     <div id=\"progressLevel\" class=\"emptybar\" style=\"width: 0; transition: .1s linear; margin-bottom: 40px\"></div>     <div class=\"divider\"></div>     <img src=\"cross_cultural/assets/religion/progress-checkmark.svg\" alt=\"progress checkmark\" />     <div class=\"divider\"></div>     <img src=\"cross_cultural/assets/religion/progress-checkmark.svg\" alt=\"progress checkmark\" />     <div class=\"divider\"></div>   </div>") // EJsS HtmlView.HtmlView Page: setting property 'Html' for element 'progressBarContainer'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"overlay", _view.gameScreen) // EJsS HtmlView.HtmlView Page: declaration of element 'overlay'
      .setProperty("Display","none") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'overlay'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"religionDescriptionModal", _view.gameScreen) // EJsS HtmlView.HtmlView Page: declaration of element 'religionDescriptionModal'
      .setProperty("ClassName","position-absolute top-50 start-50 translate-middle w-50 h-50 d-none custom-container") // EJsS HtmlView.HtmlView Page: setting property 'ClassName' for element 'religionDescriptionModal'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"rdTitle", _view.religionDescriptionModal) // EJsS HtmlView.HtmlView Page: declaration of element 'rdTitle'
      .setProperty("Html","Opps..") // EJsS HtmlView.HtmlView Page: setting property 'Html' for element 'rdTitle'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"rdBodyWrapper", _view.religionDescriptionModal) // EJsS HtmlView.HtmlView Page: declaration of element 'rdBodyWrapper'
      .setProperty("ClassName","d-flex align-items-center") // EJsS HtmlView.HtmlView Page: setting property 'ClassName' for element 'rdBodyWrapper'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"rdBody", _view.rdBodyWrapper) // EJsS HtmlView.HtmlView Page: declaration of element 'rdBody'
      .setProperty("Html","Lorem Ipsum..") // EJsS HtmlView.HtmlView Page: setting property 'Html' for element 'rdBody'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"rdBtn", _view.religionDescriptionModal) // EJsS HtmlView.HtmlView Page: declaration of element 'rdBtn'
      .setProperty("ClassName","justify-content-center custom-button") // EJsS HtmlView.HtmlView Page: setting property 'ClassName' for element 'rdBtn'
      .setProperty("Html","CONTINUE") // EJsS HtmlView.HtmlView Page: setting property 'Html' for element 'rdBtn'
      .setProperty("Display","flex") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'rdBtn'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"stageClearedModal", _view.gameScreen) // EJsS HtmlView.HtmlView Page: declaration of element 'stageClearedModal'
      .setProperty("ClassName","position-absolute top-50 start-50 translate-middle w-50 h-50 d-none custom-container") // EJsS HtmlView.HtmlView Page: setting property 'ClassName' for element 'stageClearedModal'
      .setProperty("Display","none") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'stageClearedModal'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"scTitle", _view.stageClearedModal) // EJsS HtmlView.HtmlView Page: declaration of element 'scTitle'
      .setProperty("Html","You are off to a great start!") // EJsS HtmlView.HtmlView Page: setting property 'Html' for element 'scTitle'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"scBody", _view.stageClearedModal) // EJsS HtmlView.HtmlView Page: declaration of element 'scBody'
      .setProperty("Html","Can you keep up with your streak to match the next 3 religions?") // EJsS HtmlView.HtmlView Page: setting property 'Html' for element 'scBody'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"scBtn", _view.stageClearedModal) // EJsS HtmlView.HtmlView Page: declaration of element 'scBtn'
      .setProperty("ClassName","custom-button") // EJsS HtmlView.HtmlView Page: setting property 'ClassName' for element 'scBtn'
      .setProperty("Html","CONTINUE") // EJsS HtmlView.HtmlView Page: setting property 'Html' for element 'scBtn'
      ;

    _view._addElement(EJSS_INTERFACE.audio,"backgroundMusic", _view.gameScreen) // EJsS HtmlView.HtmlView Page: declaration of element 'backgroundMusic'
      .setProperty("Loop",true) // EJsS HtmlView.HtmlView Page: setting property 'Loop' for element 'backgroundMusic'
      .setProperty("Volume",0.3) // EJsS HtmlView.HtmlView Page: setting property 'Volume' for element 'backgroundMusic'
      .setProperty("AudioUrl","./cross_cultural/assets/audio/Komiku_-_13_-_Good_Fellow.mp3") // EJsS HtmlView.HtmlView Page: setting property 'AudioUrl' for element 'backgroundMusic'
      ;

    _view._addElement(EJSS_INTERFACE.audio,"correctSound", _view.gameScreen) // EJsS HtmlView.HtmlView Page: declaration of element 'correctSound'
      .setProperty("AudioUrl","./cross_cultural/assets/audio/correct.mp3") // EJsS HtmlView.HtmlView Page: setting property 'AudioUrl' for element 'correctSound'
      ;

    _view._addElement(EJSS_INTERFACE.audio,"wrongSound", _view.gameScreen) // EJsS HtmlView.HtmlView Page: declaration of element 'wrongSound'
      .setProperty("AudioUrl","./cross_cultural/assets/audio/wrong.mp3") // EJsS HtmlView.HtmlView Page: setting property 'AudioUrl' for element 'wrongSound'
      ;

    _view._addElement(EJSS_INTERFACE.audio,"clapSound", _view.gameScreen) // EJsS HtmlView.HtmlView Page: declaration of element 'clapSound'
      .setProperty("AudioUrl","./cross_cultural/assets/audio/claps.mp3") // EJsS HtmlView.HtmlView Page: setting property 'AudioUrl' for element 'clapSound'
      ;

    _view._addElement(EJSS_INTERFACE.audio,"yeahSound", _view.gameScreen) // EJsS HtmlView.HtmlView Page: declaration of element 'yeahSound'
      .setProperty("AudioUrl","./cross_cultural/assets/audio/yeah.mp3") // EJsS HtmlView.HtmlView Page: setting property 'AudioUrl' for element 'yeahSound'
      ;

    _view._addElement(EJSS_INTERFACE.audio,"fanfareSound", _view.gameScreen) // EJsS HtmlView.HtmlView Page: declaration of element 'fanfareSound'
      .setProperty("AudioUrl","./cross_cultural/assets/audio/fanfare.mp3") // EJsS HtmlView.HtmlView Page: setting property 'AudioUrl' for element 'fanfareSound'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"gameEnd", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'gameEnd'
      .setProperty("Html","<svg width=\"701\" height=\"701\" viewBox=\"0 0 701 701\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\"> <g filter=\"url(#filter0_d_0_6)\"> <rect width=\"691\" height=\"691\" rx=\"50\" fill=\"#F9E6E0\"/> <rect x=\"1.5\" y=\"1.5\" width=\"688\" height=\"688\" rx=\"48.5\" stroke=\"#FFD208\" stroke-width=\"3\"/> <path d=\"M201.346 229.384C200.151 229.384 199.02 229.149 197.954 228.68C196.887 228.211 196.204 227.507 195.906 226.568L183.234 186.312C183.148 186.056 183.106 185.8 183.106 185.544C183.106 184.904 183.383 184.349 183.938 183.88C184.492 183.368 185.175 182.963 185.986 182.664C186.839 182.365 187.65 182.216 188.418 182.216C189.058 182.216 189.634 182.344 190.146 182.6C190.7 182.856 191.042 183.283 191.17 183.88L201.282 218.568L206.722 196.296C206.935 195.528 207.426 194.952 208.194 194.568C209.004 194.184 209.879 193.992 210.818 193.992C211.756 193.992 212.61 194.184 213.378 194.568C214.188 194.952 214.679 195.528 214.85 196.296L220.29 218.568L230.402 183.88C230.572 183.283 230.914 182.856 231.426 182.6C231.938 182.344 232.514 182.216 233.154 182.216C233.964 182.216 234.775 182.365 235.586 182.664C236.396 182.963 237.079 183.368 237.634 183.88C238.188 184.349 238.466 184.904 238.466 185.544C238.466 185.8 238.423 186.056 238.338 186.312L225.666 226.568C225.324 227.507 224.642 228.211 223.618 228.68C222.594 229.149 221.463 229.384 220.226 229.384C219.031 229.384 217.9 229.149 216.834 228.68C215.767 228.211 215.127 227.507 214.914 226.568L210.818 209.288L206.658 226.568C206.444 227.507 205.804 228.211 204.738 228.68C203.671 229.149 202.54 229.384 201.346 229.384ZM246.457 229C245.561 229 244.729 228.787 243.961 228.36C243.193 227.891 242.809 227.208 242.809 226.312V184.904C242.809 184.008 243.193 183.347 243.961 182.92C244.729 182.451 245.561 182.216 246.457 182.216H269.241C270.179 182.216 270.841 182.6 271.225 183.368C271.651 184.136 271.865 184.947 271.865 185.8C271.865 186.824 271.63 187.699 271.161 188.424C270.734 189.149 270.094 189.512 269.241 189.512H251.129V202.312H260.857C261.71 202.312 262.35 202.653 262.777 203.336C263.246 203.976 263.481 204.744 263.481 205.64C263.481 206.365 263.267 207.091 262.841 207.816C262.457 208.499 261.795 208.84 260.857 208.84H251.129V221.704H269.241C270.094 221.704 270.734 222.067 271.161 222.792C271.63 223.517 271.865 224.392 271.865 225.416C271.865 226.269 271.651 227.08 271.225 227.848C270.841 228.616 270.179 229 269.241 229H246.457ZM280.394 229C279.498 229 278.666 228.787 277.898 228.36C277.13 227.891 276.746 227.208 276.746 226.312V184.84C276.746 183.901 277.173 183.24 278.026 182.856C278.922 182.429 279.882 182.216 280.906 182.216C281.973 182.216 282.933 182.429 283.786 182.856C284.64 183.24 285.066 183.901 285.066 184.84V221.704H300.746C301.6 221.704 302.218 222.088 302.602 222.856C302.986 223.581 303.178 224.413 303.178 225.352C303.178 226.248 302.986 227.08 302.602 227.848C302.218 228.616 301.6 229 300.746 229H280.394ZM311.332 229C310.436 229 309.604 228.787 308.836 228.36C308.068 227.891 307.684 227.208 307.684 226.312V184.84C307.684 183.901 308.11 183.24 308.964 182.856C309.86 182.429 310.82 182.216 311.844 182.216C312.91 182.216 313.87 182.429 314.724 182.856C315.577 183.24 316.004 183.901 316.004 184.84V221.704H331.684C332.537 221.704 333.156 222.088 333.54 222.856C333.924 223.581 334.116 224.413 334.116 225.352C334.116 226.248 333.924 227.08 333.54 227.848C333.156 228.616 332.537 229 331.684 229H311.332ZM355.082 229C353.972 229 353.076 228.744 352.394 228.232C351.754 227.72 351.434 227.101 351.434 226.376V184.84C351.434 184.115 351.754 183.496 352.394 182.984C353.076 182.472 353.972 182.216 355.082 182.216H366.41C369.268 182.216 371.828 182.707 374.09 183.688C376.351 184.627 378.143 186.184 379.466 188.36C380.831 190.493 381.514 193.352 381.514 196.936V214.28C381.514 217.864 380.831 220.744 379.466 222.92C378.143 225.053 376.351 226.611 374.09 227.592C371.828 228.531 369.268 229 366.41 229H355.082ZM359.754 221.704H366.41C368.543 221.704 370.207 221.107 371.402 219.912C372.596 218.675 373.194 216.797 373.194 214.28V196.936C373.194 194.419 372.596 192.563 371.402 191.368C370.207 190.131 368.564 189.512 366.474 189.512H359.754V221.704ZM403.149 229.384C400.333 229.384 397.795 228.915 395.533 227.976C393.272 226.995 391.459 225.437 390.093 223.304C388.771 221.128 388.109 218.248 388.109 214.664V196.936C388.109 193.352 388.771 190.493 390.093 188.36C391.459 186.184 393.251 184.627 395.469 183.688C397.731 182.707 400.291 182.216 403.149 182.216C405.965 182.216 408.504 182.707 410.765 183.688C413.069 184.627 414.883 186.184 416.205 188.36C417.528 190.493 418.189 193.352 418.189 196.936V214.664C418.189 218.248 417.528 221.128 416.205 223.304C414.883 225.437 413.069 226.995 410.765 227.976C408.504 228.915 405.965 229.384 403.149 229.384ZM403.149 222.088C405.24 222.088 406.883 221.491 408.077 220.296C409.272 219.101 409.869 217.224 409.869 214.664V196.936C409.869 194.376 409.272 192.499 408.077 191.304C406.883 190.109 405.24 189.512 403.149 189.512C401.059 189.512 399.416 190.109 398.221 191.304C397.069 192.499 396.493 194.376 396.493 196.936V214.664C396.493 217.224 397.069 219.101 398.221 220.296C399.416 221.491 401.059 222.088 403.149 222.088ZM429.531 229C428.507 229 427.547 228.787 426.651 228.36C425.798 227.891 425.371 227.208 425.371 226.312V184.84C425.371 183.944 425.798 183.283 426.651 182.856C427.547 182.429 428.507 182.216 429.531 182.216C430.555 182.216 431.387 182.323 432.027 182.536C432.71 182.749 433.329 183.176 433.883 183.816C434.481 184.413 435.099 185.352 435.739 186.632L448.091 210.504V184.84C448.091 183.901 448.518 183.24 449.371 182.856C450.267 182.429 451.227 182.216 452.251 182.216C453.318 182.216 454.278 182.429 455.131 182.856C455.985 183.24 456.411 183.901 456.411 184.84V226.312C456.411 227.208 455.985 227.891 455.131 228.36C454.278 228.787 453.318 229 452.251 229C451.27 229 450.353 228.808 449.499 228.424C448.689 228.04 448.027 227.357 447.515 226.376L433.691 200.648V226.312C433.691 227.208 433.265 227.891 432.411 228.36C431.558 228.787 430.598 229 429.531 229ZM467.832 229C466.936 229 466.104 228.787 465.336 228.36C464.568 227.891 464.184 227.208 464.184 226.312V184.904C464.184 184.008 464.568 183.347 465.336 182.92C466.104 182.451 466.936 182.216 467.832 182.216H490.616C491.554 182.216 492.216 182.6 492.6 183.368C493.026 184.136 493.24 184.947 493.24 185.8C493.24 186.824 493.005 187.699 492.536 188.424C492.109 189.149 491.469 189.512 490.616 189.512H472.504V202.312H482.232C483.085 202.312 483.725 202.653 484.152 203.336C484.621 203.976 484.856 204.744 484.856 205.64C484.856 206.365 484.642 207.091 484.216 207.816C483.832 208.499 483.17 208.84 482.232 208.84H472.504V221.704H490.616C491.469 221.704 492.109 222.067 492.536 222.792C493.005 223.517 493.24 224.392 493.24 225.416C493.24 226.269 493.026 227.08 492.6 227.848C492.216 228.616 491.554 229 490.616 229H467.832ZM501.385 216.072C500.532 216.072 499.785 215.88 499.145 215.496C498.505 215.112 498.185 214.493 498.185 213.64C498.185 210.824 498.121 207.773 497.993 204.488C497.865 201.203 497.716 197.917 497.545 194.632C497.417 191.347 497.353 188.296 497.353 185.48C497.353 184.371 497.737 183.517 498.505 182.92C499.273 182.28 500.233 181.96 501.385 181.96C502.452 181.96 503.369 182.28 504.137 182.92C504.948 183.517 505.353 184.371 505.353 185.48C505.353 188.296 505.289 191.347 505.161 194.632C505.033 197.917 504.884 201.203 504.713 204.488C504.585 207.773 504.521 210.824 504.521 213.64C504.521 214.493 504.159 215.112 503.433 215.496C502.708 215.88 502.025 216.072 501.385 216.072ZM501.449 229.384C500.212 229.384 499.167 228.957 498.313 228.104C497.503 227.208 497.097 226.184 497.097 225.032C497.097 223.837 497.503 222.813 498.313 221.96C499.167 221.107 500.212 220.68 501.449 220.68C502.601 220.68 503.604 221.107 504.457 221.96C505.311 222.813 505.737 223.837 505.737 225.032C505.737 226.184 505.311 227.208 504.457 228.104C503.604 228.957 502.601 229.384 501.449 229.384Z\" fill=\"#FF0082\"/> <path d=\"M89.2792 300.216C88.7512 300.216 88.2472 300.108 87.7672 299.892C87.2872 299.676 86.9752 299.352 86.8312 298.92L79.7032 275.592C79.6792 275.472 79.6672 275.352 79.6672 275.232C79.6672 274.92 79.7872 274.656 80.0272 274.44C80.2672 274.2 80.5672 274.02 80.9272 273.9C81.3112 273.756 81.6832 273.684 82.0432 273.684C82.3552 273.684 82.6312 273.744 82.8712 273.864C83.1352 273.984 83.3032 274.188 83.3752 274.476L89.2432 294.996L92.5192 282.108C92.6152 281.724 92.8432 281.448 93.2032 281.28C93.5872 281.088 93.9832 280.992 94.3912 280.992C94.8472 280.992 95.2552 281.088 95.6152 281.28C95.9752 281.448 96.2032 281.724 96.2992 282.108L99.5752 294.996L105.443 274.476C105.539 274.188 105.707 273.984 105.947 273.864C106.187 273.744 106.463 273.684 106.775 273.684C107.135 273.684 107.495 273.756 107.855 273.9C108.215 274.02 108.515 274.2 108.755 274.44C109.019 274.656 109.151 274.92 109.151 275.232C109.151 275.352 109.127 275.472 109.079 275.592L101.987 298.92C101.843 299.352 101.531 299.676 101.051 299.892C100.595 300.108 100.091 300.216 99.5392 300.216C99.0112 300.216 98.5072 300.108 98.0272 299.892C97.5472 299.676 97.2592 299.352 97.1632 298.92L94.3912 288.048L91.6912 298.92C91.5712 299.352 91.2712 299.676 90.7912 299.892C90.3352 300.108 89.8312 300.216 89.2792 300.216ZM113.461 278.652C112.861 278.652 112.345 278.448 111.913 278.04C111.481 277.632 111.265 277.176 111.265 276.672C111.265 276.12 111.481 275.652 111.913 275.268C112.345 274.884 112.861 274.692 113.461 274.692C114.061 274.692 114.565 274.884 114.973 275.268C115.405 275.652 115.621 276.12 115.621 276.672C115.621 277.176 115.405 277.632 114.973 278.04C114.565 278.448 114.061 278.652 113.461 278.652ZM113.461 300C112.909 300 112.453 299.868 112.093 299.604C111.757 299.34 111.589 299.052 111.589 298.74V284.16C111.589 283.8 111.757 283.512 112.093 283.296C112.453 283.056 112.909 282.936 113.461 282.936C113.989 282.936 114.433 283.056 114.793 283.296C115.177 283.512 115.369 283.8 115.369 284.16V298.74C115.369 299.052 115.177 299.34 114.793 299.604C114.433 299.868 113.989 300 113.461 300ZM125.517 300C123.477 300 121.917 299.556 120.837 298.668C119.757 297.756 119.217 296.328 119.217 294.384V276.348C119.217 275.988 119.409 275.7 119.793 275.484C120.201 275.244 120.633 275.124 121.089 275.124C121.545 275.124 121.977 275.244 122.385 275.484C122.793 275.7 122.997 275.988 122.997 276.348V282.936H127.389C127.725 282.936 127.977 283.08 128.145 283.368C128.337 283.656 128.433 283.98 128.433 284.34C128.433 284.7 128.337 285.024 128.145 285.312C127.977 285.6 127.725 285.744 127.389 285.744H122.997V294.384C122.997 295.248 123.177 295.86 123.537 296.22C123.921 296.58 124.581 296.76 125.517 296.76H126.741C127.293 296.76 127.701 296.928 127.965 297.264C128.253 297.576 128.397 297.948 128.397 298.38C128.397 298.788 128.253 299.16 127.965 299.496C127.701 299.832 127.293 300 126.741 300H125.517ZM132.939 300C132.387 300 131.931 299.868 131.571 299.604C131.235 299.34 131.067 299.052 131.067 298.74V274.008C131.067 273.648 131.235 273.36 131.571 273.144C131.931 272.904 132.387 272.784 132.939 272.784C133.467 272.784 133.911 272.904 134.271 273.144C134.655 273.36 134.847 273.648 134.847 274.008V285.456C135.207 284.76 135.771 284.136 136.539 283.584C137.331 283.008 138.303 282.72 139.455 282.72C140.583 282.72 141.615 283.044 142.551 283.692C143.511 284.316 144.279 285.168 144.855 286.248C145.431 287.304 145.719 288.492 145.719 289.812V298.74C145.719 299.148 145.515 299.46 145.107 299.676C144.723 299.892 144.291 300 143.811 300C143.379 300 142.959 299.892 142.551 299.676C142.143 299.46 141.939 299.148 141.939 298.74V289.812C141.939 289.188 141.771 288.588 141.435 288.012C141.099 287.436 140.655 286.968 140.103 286.608C139.575 286.248 138.975 286.068 138.303 286.068C137.727 286.068 137.175 286.224 136.647 286.536C136.119 286.824 135.687 287.244 135.351 287.796C135.015 288.348 134.847 289.02 134.847 289.812V298.74C134.847 299.052 134.655 299.34 134.271 299.604C133.911 299.868 133.467 300 132.939 300ZM158.567 300C158.015 300 157.559 299.868 157.199 299.604C156.863 299.34 156.695 299.052 156.695 298.74V284.16C156.695 283.8 156.863 283.512 157.199 283.296C157.559 283.056 158.015 282.936 158.567 282.936C159.023 282.936 159.419 283.056 159.755 283.296C160.091 283.512 160.259 283.8 160.259 284.16V285.456C160.667 284.76 161.267 284.136 162.059 283.584C162.851 283.008 163.847 282.72 165.047 282.72C166.127 282.72 167.075 283.056 167.891 283.728C168.731 284.4 169.355 285.264 169.763 286.32C170.387 285.096 171.191 284.196 172.175 283.62C173.159 283.02 174.167 282.72 175.199 282.72C176.279 282.72 177.287 282.996 178.223 283.548C179.183 284.1 179.963 284.904 180.563 285.96C181.163 287.016 181.463 288.3 181.463 289.812V298.74C181.463 299.052 181.271 299.34 180.887 299.604C180.527 299.868 180.083 300 179.555 300C179.051 300 178.607 299.868 178.223 299.604C177.863 299.34 177.683 299.052 177.683 298.74V289.812C177.683 288.996 177.515 288.312 177.179 287.76C176.867 287.184 176.447 286.752 175.919 286.464C175.415 286.176 174.887 286.032 174.335 286.032C173.759 286.032 173.219 286.188 172.715 286.5C172.211 286.788 171.791 287.208 171.455 287.76C171.119 288.288 170.951 288.948 170.951 289.74V298.776C170.951 299.208 170.747 299.52 170.339 299.712C169.955 299.904 169.523 300 169.043 300C168.611 300 168.191 299.904 167.783 299.712C167.375 299.52 167.171 299.208 167.171 298.776V289.776C167.171 289.008 167.015 288.348 166.703 287.796C166.391 287.244 165.983 286.824 165.479 286.536C164.975 286.224 164.423 286.068 163.823 286.068C163.271 286.068 162.731 286.212 162.203 286.5C161.699 286.788 161.279 287.208 160.943 287.76C160.631 288.312 160.475 288.996 160.475 289.812V298.74C160.475 299.052 160.283 299.34 159.899 299.604C159.539 299.868 159.095 300 158.567 300ZM192.009 300.288C190.713 300.288 189.501 299.952 188.373 299.28C187.245 298.608 186.333 297.732 185.637 296.652C184.965 295.548 184.629 294.372 184.629 293.124V289.812C184.629 288.54 184.953 287.364 185.601 286.284C186.273 285.204 187.173 284.34 188.301 283.692C189.453 283.044 190.701 282.72 192.045 282.72C193.389 282.72 194.625 283.044 195.753 283.692C196.881 284.316 197.781 285.168 198.453 286.248C199.149 287.304 199.497 288.492 199.497 289.812V293.124C199.497 294.348 199.149 295.512 198.453 296.616C197.781 297.72 196.869 298.608 195.717 299.28C194.589 299.952 193.353 300.288 192.009 300.288ZM192.045 296.94C192.717 296.94 193.329 296.76 193.881 296.4C194.433 296.04 194.877 295.572 195.213 294.996C195.549 294.396 195.717 293.772 195.717 293.124V289.812C195.717 289.188 195.549 288.588 195.213 288.012C194.877 287.436 194.433 286.968 193.881 286.608C193.329 286.248 192.717 286.068 192.045 286.068C191.349 286.068 190.725 286.248 190.173 286.608C189.645 286.968 189.213 287.436 188.877 288.012C188.565 288.588 188.409 289.188 188.409 289.812V293.124C188.409 293.772 188.565 294.396 188.877 294.996C189.213 295.572 189.657 296.04 190.209 296.4C190.761 296.76 191.373 296.94 192.045 296.94ZM204.621 300C204.093 300 203.649 299.868 203.289 299.604C202.953 299.34 202.785 299.052 202.785 298.74V284.16C202.785 283.8 202.953 283.512 203.289 283.296C203.649 283.056 204.093 282.936 204.621 282.936C205.101 282.936 205.509 283.056 205.845 283.296C206.181 283.512 206.349 283.8 206.349 284.16V285.744C206.613 285.24 206.961 284.76 207.393 284.304C207.849 283.848 208.377 283.476 208.977 283.188C209.577 282.876 210.225 282.72 210.921 282.72H212.073C212.457 282.72 212.793 282.888 213.081 283.224C213.369 283.536 213.513 283.92 213.513 284.376C213.513 284.832 213.369 285.228 213.081 285.564C212.793 285.9 212.457 286.068 212.073 286.068H210.921C210.201 286.068 209.505 286.284 208.833 286.716C208.161 287.148 207.609 287.76 207.177 288.552C206.769 289.32 206.565 290.256 206.565 291.36V298.74C206.565 299.052 206.373 299.34 205.989 299.604C205.629 299.868 205.173 300 204.621 300ZM222.829 300.288C221.197 300.288 219.757 299.988 218.509 299.388C217.261 298.788 216.277 297.96 215.557 296.904C214.837 295.824 214.477 294.564 214.477 293.124V289.704C214.477 288.432 214.813 287.268 215.485 286.212C216.181 285.156 217.093 284.316 218.221 283.692C219.349 283.044 220.597 282.72 221.965 282.72C223.261 282.72 224.449 283.008 225.529 283.584C226.609 284.136 227.473 284.916 228.121 285.924C228.793 286.932 229.129 288.084 229.129 289.38C229.129 290.388 228.973 291.108 228.661 291.54C228.349 291.972 227.941 292.236 227.437 292.332C226.933 292.428 226.405 292.476 225.853 292.476H218.257V293.304C218.257 294.504 218.689 295.464 219.553 296.184C220.441 296.88 221.569 297.228 222.937 297.228C223.777 297.228 224.461 297.108 224.989 296.868C225.517 296.628 225.961 296.4 226.321 296.184C226.681 295.968 227.017 295.86 227.329 295.86C227.641 295.86 227.905 295.956 228.121 296.148C228.337 296.34 228.505 296.568 228.625 296.832C228.745 297.096 228.805 297.336 228.805 297.552C228.805 297.912 228.553 298.308 228.049 298.74C227.569 299.172 226.885 299.544 225.997 299.856C225.109 300.144 224.053 300.288 222.829 300.288ZM218.257 290.136H224.233C224.761 290.136 225.109 290.064 225.277 289.92C225.469 289.776 225.565 289.488 225.565 289.056C225.565 288.432 225.409 287.856 225.097 287.328C224.785 286.776 224.353 286.356 223.801 286.068C223.249 285.756 222.625 285.6 221.929 285.6C221.257 285.6 220.645 285.744 220.093 286.032C219.541 286.32 219.097 286.716 218.761 287.22C218.425 287.724 218.257 288.312 218.257 288.984V290.136ZM243.126 300.288C241.806 300.288 240.678 299.904 239.742 299.136C238.806 298.344 238.338 297.144 238.338 295.536C238.338 294.168 238.698 293.112 239.418 292.368C240.138 291.624 241.122 291.108 242.37 290.82C243.642 290.532 245.106 290.388 246.762 290.388H248.346V289.74C248.346 289.116 248.226 288.516 247.986 287.94C247.77 287.34 247.398 286.848 246.87 286.464C246.366 286.056 245.67 285.852 244.782 285.852C243.894 285.852 243.21 285.936 242.729 286.104C242.25 286.272 241.866 286.452 241.578 286.644C241.29 286.836 241.026 286.932 240.786 286.932C240.354 286.932 240.018 286.728 239.778 286.32C239.538 285.888 239.418 285.456 239.418 285.024C239.418 284.592 239.694 284.208 240.246 283.872C240.822 283.512 241.53 283.236 242.37 283.044C243.21 282.828 244.038 282.72 244.854 282.72C246.63 282.72 248.046 283.056 249.102 283.728C250.158 284.376 250.926 285.228 251.406 286.284C251.886 287.34 252.126 288.48 252.126 289.704V298.74C252.126 299.076 251.946 299.376 251.586 299.64C251.25 299.88 250.818 300 250.29 300C249.81 300 249.402 299.88 249.066 299.64C248.73 299.376 248.562 299.076 248.562 298.74V297.48C247.938 298.2 247.182 298.848 246.294 299.424C245.406 300 244.35 300.288 243.126 300.288ZM244.494 297.408C245.094 297.408 245.682 297.228 246.258 296.868C246.858 296.508 247.35 296.052 247.734 295.5C248.142 294.948 248.346 294.384 248.346 293.808V292.476H247.446C246.534 292.476 245.67 292.536 244.854 292.656C244.038 292.752 243.378 292.992 242.874 293.376C242.394 293.736 242.154 294.3 242.154 295.068C242.154 295.884 242.37 296.484 242.802 296.868C243.258 297.228 243.822 297.408 244.494 297.408ZM261.31 300.36C260.974 300.36 260.674 300.3 260.41 300.18C260.146 300.06 259.954 299.844 259.834 299.532L254.254 284.988C254.206 284.868 254.158 284.76 254.11 284.664C254.086 284.544 254.074 284.448 254.074 284.376C254.074 284.064 254.206 283.8 254.47 283.584C254.734 283.344 255.046 283.152 255.406 283.008C255.79 282.864 256.15 282.792 256.486 282.792C256.75 282.792 256.99 282.852 257.206 282.972C257.422 283.068 257.566 283.236 257.638 283.476L261.634 294.672L264.694 284.736C264.814 284.376 264.994 284.148 265.234 284.052C265.474 283.956 265.738 283.908 266.026 283.908C266.338 283.908 266.614 283.956 266.854 284.052C267.094 284.148 267.274 284.376 267.394 284.736L270.382 294.744L274.414 283.476C274.558 283.02 274.93 282.792 275.53 282.792C275.866 282.792 276.214 282.864 276.574 283.008C276.958 283.128 277.282 283.308 277.546 283.548C277.81 283.788 277.942 284.076 277.942 284.412C277.942 284.484 277.93 284.58 277.906 284.7C277.882 284.82 277.846 284.916 277.798 284.988L272.218 299.604C272.122 299.892 271.93 300.084 271.642 300.18C271.378 300.3 271.078 300.36 270.742 300.36C270.358 300.36 270.022 300.3 269.734 300.18C269.47 300.06 269.29 299.88 269.194 299.64L266.026 290.352L262.93 299.532C262.834 299.82 262.63 300.024 262.318 300.144C262.03 300.288 261.694 300.36 261.31 300.36ZM283.977 300.288C282.657 300.288 281.529 299.904 280.593 299.136C279.657 298.344 279.189 297.144 279.189 295.536C279.189 294.168 279.549 293.112 280.269 292.368C280.989 291.624 281.973 291.108 283.221 290.82C284.493 290.532 285.957 290.388 287.613 290.388H289.197V289.74C289.197 289.116 289.077 288.516 288.837 287.94C288.621 287.34 288.249 286.848 287.721 286.464C287.217 286.056 286.521 285.852 285.633 285.852C284.745 285.852 284.061 285.936 283.581 286.104C283.101 286.272 282.717 286.452 282.429 286.644C282.141 286.836 281.877 286.932 281.637 286.932C281.205 286.932 280.869 286.728 280.629 286.32C280.389 285.888 280.269 285.456 280.269 285.024C280.269 284.592 280.545 284.208 281.097 283.872C281.673 283.512 282.381 283.236 283.221 283.044C284.061 282.828 284.889 282.72 285.705 282.72C287.481 282.72 288.897 283.056 289.953 283.728C291.009 284.376 291.777 285.228 292.257 286.284C292.737 287.34 292.977 288.48 292.977 289.704V298.74C292.977 299.076 292.797 299.376 292.437 299.64C292.101 299.88 291.669 300 291.141 300C290.661 300 290.253 299.88 289.917 299.64C289.581 299.376 289.413 299.076 289.413 298.74V297.48C288.789 298.2 288.033 298.848 287.145 299.424C286.257 300 285.201 300.288 283.977 300.288ZM285.345 297.408C285.945 297.408 286.533 297.228 287.109 296.868C287.709 296.508 288.201 296.052 288.585 295.5C288.993 294.948 289.197 294.384 289.197 293.808V292.476H288.297C287.385 292.476 286.521 292.536 285.705 292.656C284.889 292.752 284.229 292.992 283.725 293.376C283.245 293.736 283.005 294.3 283.005 295.068C283.005 295.884 283.221 296.484 283.653 296.868C284.109 297.228 284.673 297.408 285.345 297.408ZM298.629 300C298.101 300 297.657 299.868 297.297 299.604C296.961 299.34 296.793 299.052 296.793 298.74V284.16C296.793 283.8 296.961 283.512 297.297 283.296C297.657 283.056 298.101 282.936 298.629 282.936C299.109 282.936 299.517 283.056 299.853 283.296C300.189 283.512 300.357 283.8 300.357 284.16V285.744C300.621 285.24 300.969 284.76 301.401 284.304C301.857 283.848 302.385 283.476 302.985 283.188C303.585 282.876 304.233 282.72 304.929 282.72H306.081C306.465 282.72 306.801 282.888 307.089 283.224C307.377 283.536 307.521 283.92 307.521 284.376C307.521 284.832 307.377 285.228 307.089 285.564C306.801 285.9 306.465 286.068 306.081 286.068H304.929C304.209 286.068 303.513 286.284 302.841 286.716C302.169 287.148 301.617 287.76 301.185 288.552C300.777 289.32 300.573 290.256 300.573 291.36V298.74C300.573 299.052 300.381 299.34 299.997 299.604C299.637 299.868 299.181 300 298.629 300ZM316.836 300.288C315.204 300.288 313.764 299.988 312.516 299.388C311.268 298.788 310.284 297.96 309.564 296.904C308.844 295.824 308.484 294.564 308.484 293.124V289.704C308.484 288.432 308.82 287.268 309.492 286.212C310.188 285.156 311.1 284.316 312.228 283.692C313.356 283.044 314.604 282.72 315.972 282.72C317.268 282.72 318.456 283.008 319.536 283.584C320.616 284.136 321.48 284.916 322.128 285.924C322.8 286.932 323.136 288.084 323.136 289.38C323.136 290.388 322.98 291.108 322.668 291.54C322.356 291.972 321.948 292.236 321.444 292.332C320.94 292.428 320.412 292.476 319.86 292.476H312.264V293.304C312.264 294.504 312.696 295.464 313.56 296.184C314.448 296.88 315.576 297.228 316.944 297.228C317.784 297.228 318.468 297.108 318.996 296.868C319.524 296.628 319.968 296.4 320.328 296.184C320.688 295.968 321.024 295.86 321.336 295.86C321.648 295.86 321.912 295.956 322.128 296.148C322.344 296.34 322.512 296.568 322.632 296.832C322.752 297.096 322.812 297.336 322.812 297.552C322.812 297.912 322.56 298.308 322.056 298.74C321.576 299.172 320.892 299.544 320.004 299.856C319.116 300.144 318.06 300.288 316.836 300.288ZM312.264 290.136H318.24C318.768 290.136 319.116 290.064 319.284 289.92C319.476 289.776 319.572 289.488 319.572 289.056C319.572 288.432 319.416 287.856 319.104 287.328C318.792 286.776 318.36 286.356 317.808 286.068C317.256 285.756 316.632 285.6 315.936 285.6C315.264 285.6 314.652 285.744 314.1 286.032C313.548 286.32 313.104 286.716 312.768 287.22C312.432 287.724 312.264 288.312 312.264 288.984V290.136ZM328.09 300C327.538 300 327.082 299.868 326.722 299.604C326.386 299.34 326.218 299.052 326.218 298.74V284.16C326.218 283.8 326.386 283.512 326.722 283.296C327.082 283.056 327.538 282.936 328.09 282.936C328.546 282.936 328.942 283.056 329.278 283.296C329.614 283.512 329.782 283.8 329.782 284.16V285.456C330.142 284.76 330.73 284.136 331.546 283.584C332.386 283.008 333.406 282.72 334.606 282.72C335.734 282.72 336.766 283.044 337.702 283.692C338.662 284.316 339.43 285.168 340.006 286.248C340.582 287.304 340.87 288.492 340.87 289.812V298.74C340.87 299.148 340.666 299.46 340.258 299.676C339.874 299.892 339.442 300 338.962 300C338.53 300 338.11 299.892 337.702 299.676C337.294 299.46 337.09 299.148 337.09 298.74V289.812C337.09 289.188 336.922 288.588 336.586 288.012C336.274 287.436 335.842 286.968 335.29 286.608C334.738 286.248 334.126 286.068 333.454 286.068C332.878 286.068 332.326 286.224 331.798 286.536C331.27 286.824 330.838 287.244 330.502 287.796C330.166 288.348 329.998 289.02 329.998 289.812V298.74C329.998 299.052 329.806 299.34 329.422 299.604C329.062 299.868 328.618 300 328.09 300ZM352.344 300.288C350.712 300.288 349.272 299.988 348.024 299.388C346.776 298.788 345.792 297.96 345.072 296.904C344.352 295.824 343.992 294.564 343.992 293.124V289.704C343.992 288.432 344.328 287.268 345 286.212C345.696 285.156 346.608 284.316 347.736 283.692C348.864 283.044 350.112 282.72 351.48 282.72C352.776 282.72 353.964 283.008 355.044 283.584C356.124 284.136 356.988 284.916 357.636 285.924C358.308 286.932 358.644 288.084 358.644 289.38C358.644 290.388 358.488 291.108 358.176 291.54C357.864 291.972 357.456 292.236 356.952 292.332C356.448 292.428 355.92 292.476 355.368 292.476H347.772V293.304C347.772 294.504 348.204 295.464 349.068 296.184C349.956 296.88 351.084 297.228 352.452 297.228C353.292 297.228 353.976 297.108 354.504 296.868C355.032 296.628 355.476 296.4 355.836 296.184C356.196 295.968 356.532 295.86 356.844 295.86C357.156 295.86 357.42 295.956 357.636 296.148C357.852 296.34 358.02 296.568 358.14 296.832C358.26 297.096 358.32 297.336 358.32 297.552C358.32 297.912 358.068 298.308 357.564 298.74C357.084 299.172 356.4 299.544 355.512 299.856C354.624 300.144 353.568 300.288 352.344 300.288ZM347.772 290.136H353.748C354.276 290.136 354.624 290.064 354.792 289.92C354.984 289.776 355.08 289.488 355.08 289.056C355.08 288.432 354.924 287.856 354.612 287.328C354.3 286.776 353.868 286.356 353.316 286.068C352.764 285.756 352.14 285.6 351.444 285.6C350.772 285.6 350.16 285.744 349.608 286.032C349.056 286.32 348.612 286.716 348.276 287.22C347.94 287.724 347.772 288.312 347.772 288.984V290.136ZM366.946 300.288C365.77 300.288 364.714 300.144 363.778 299.856C362.842 299.568 362.098 299.208 361.546 298.776C361.018 298.32 360.754 297.864 360.754 297.408C360.754 297.192 360.802 296.952 360.898 296.688C361.018 296.424 361.174 296.196 361.366 296.004C361.582 295.812 361.81 295.716 362.05 295.716C362.362 295.716 362.686 295.86 363.022 296.148C363.382 296.412 363.85 296.688 364.426 296.976C365.002 297.24 365.806 297.372 366.838 297.372C368.038 297.372 368.842 297.168 369.25 296.76C369.682 296.352 369.898 295.908 369.898 295.428C369.898 294.804 369.682 294.324 369.25 293.988C368.842 293.628 368.302 293.34 367.63 293.124C366.982 292.908 366.286 292.704 365.542 292.512C364.798 292.296 364.09 292.02 363.418 291.684C362.77 291.348 362.23 290.88 361.798 290.28C361.39 289.68 361.186 288.888 361.186 287.904C361.186 287.088 361.39 286.284 361.798 285.492C362.206 284.676 362.854 284.016 363.742 283.512C364.654 282.984 365.866 282.72 367.378 282.72C368.29 282.72 369.154 282.816 369.97 283.008C370.786 283.2 371.458 283.464 371.986 283.8C372.514 284.112 372.778 284.46 372.778 284.844C372.778 285.012 372.718 285.252 372.598 285.564C372.478 285.852 372.31 286.116 372.094 286.356C371.902 286.572 371.65 286.68 371.338 286.68C371.098 286.68 370.798 286.596 370.438 286.428C370.078 286.236 369.658 286.056 369.178 285.888C368.698 285.72 368.11 285.636 367.414 285.636C366.718 285.636 366.154 285.756 365.722 285.996C365.314 286.212 365.014 286.476 364.822 286.788C364.63 287.1 364.534 287.412 364.534 287.724C364.534 288.252 364.738 288.66 365.146 288.948C365.554 289.236 366.094 289.476 366.766 289.668C367.438 289.86 368.146 290.064 368.89 290.28C369.634 290.472 370.33 290.76 370.978 291.144C371.65 291.528 372.19 292.044 372.598 292.692C373.03 293.34 373.246 294.204 373.246 295.284C373.246 296.796 372.694 298.008 371.59 298.92C370.51 299.832 368.962 300.288 366.946 300.288ZM381.571 300.288C380.395 300.288 379.339 300.144 378.403 299.856C377.467 299.568 376.723 299.208 376.171 298.776C375.643 298.32 375.379 297.864 375.379 297.408C375.379 297.192 375.427 296.952 375.523 296.688C375.643 296.424 375.799 296.196 375.991 296.004C376.207 295.812 376.435 295.716 376.675 295.716C376.987 295.716 377.311 295.86 377.647 296.148C378.007 296.412 378.475 296.688 379.051 296.976C379.627 297.24 380.431 297.372 381.463 297.372C382.663 297.372 383.467 297.168 383.875 296.76C384.307 296.352 384.523 295.908 384.523 295.428C384.523 294.804 384.307 294.324 383.875 293.988C383.467 293.628 382.927 293.34 382.255 293.124C381.607 292.908 380.911 292.704 380.167 292.512C379.423 292.296 378.715 292.02 378.043 291.684C377.395 291.348 376.855 290.88 376.423 290.28C376.015 289.68 375.811 288.888 375.811 287.904C375.811 287.088 376.015 286.284 376.423 285.492C376.831 284.676 377.479 284.016 378.367 283.512C379.279 282.984 380.491 282.72 382.003 282.72C382.915 282.72 383.779 282.816 384.595 283.008C385.411 283.2 386.083 283.464 386.611 283.8C387.139 284.112 387.403 284.46 387.403 284.844C387.403 285.012 387.343 285.252 387.223 285.564C387.103 285.852 386.935 286.116 386.719 286.356C386.527 286.572 386.275 286.68 385.963 286.68C385.723 286.68 385.423 286.596 385.063 286.428C384.703 286.236 384.283 286.056 383.803 285.888C383.323 285.72 382.735 285.636 382.039 285.636C381.343 285.636 380.779 285.756 380.347 285.996C379.939 286.212 379.639 286.476 379.447 286.788C379.255 287.1 379.159 287.412 379.159 287.724C379.159 288.252 379.363 288.66 379.771 288.948C380.179 289.236 380.719 289.476 381.391 289.668C382.063 289.86 382.771 290.064 383.515 290.28C384.259 290.472 384.955 290.76 385.603 291.144C386.275 291.528 386.815 292.044 387.223 292.692C387.655 293.34 387.871 294.204 387.871 295.284C387.871 296.796 387.319 298.008 386.215 298.92C385.135 299.832 383.587 300.288 381.571 300.288ZM404.915 300.288C403.619 300.288 402.407 299.952 401.279 299.28C400.151 298.608 399.239 297.732 398.543 296.652C397.871 295.548 397.535 294.372 397.535 293.124V289.812C397.535 288.54 397.859 287.364 398.507 286.284C399.179 285.204 400.079 284.34 401.207 283.692C402.359 283.044 403.607 282.72 404.951 282.72C406.295 282.72 407.531 283.044 408.659 283.692C409.787 284.316 410.687 285.168 411.359 286.248C412.055 287.304 412.403 288.492 412.403 289.812V293.124C412.403 294.348 412.055 295.512 411.359 296.616C410.687 297.72 409.775 298.608 408.623 299.28C407.495 299.952 406.259 300.288 404.915 300.288ZM404.951 296.94C405.623 296.94 406.235 296.76 406.787 296.4C407.339 296.04 407.783 295.572 408.119 294.996C408.455 294.396 408.623 293.772 408.623 293.124V289.812C408.623 289.188 408.455 288.588 408.119 288.012C407.783 287.436 407.339 286.968 406.787 286.608C406.235 286.248 405.623 286.068 404.951 286.068C404.255 286.068 403.631 286.248 403.079 286.608C402.551 286.968 402.119 287.436 401.783 288.012C401.471 288.588 401.315 289.188 401.315 289.812V293.124C401.315 293.772 401.471 294.396 401.783 294.996C402.119 295.572 402.563 296.04 403.115 296.4C403.667 296.76 404.279 296.94 404.951 296.94ZM417.563 300C417.035 300 416.591 299.892 416.231 299.676C415.895 299.436 415.727 299.136 415.727 298.776V279.66C415.727 278.364 416.015 277.2 416.591 276.168C417.167 275.112 417.935 274.284 418.895 273.684C419.855 273.084 420.911 272.784 422.063 272.784H423.755C424.235 272.784 424.595 272.952 424.835 273.288C425.099 273.624 425.231 273.996 425.231 274.404C425.231 274.836 425.099 275.22 424.835 275.556C424.595 275.868 424.235 276.024 423.755 276.024H422.783C422.159 276.024 421.595 276.168 421.091 276.456C420.611 276.744 420.227 277.14 419.939 277.644C419.651 278.124 419.507 278.676 419.507 279.3V282.936H424.151C424.511 282.936 424.775 283.08 424.943 283.368C425.135 283.656 425.231 283.98 425.231 284.34C425.231 284.7 425.135 285.024 424.943 285.312C424.775 285.6 424.511 285.744 424.151 285.744H419.507V298.776C419.507 299.136 419.315 299.436 418.931 299.676C418.547 299.892 418.091 300 417.563 300ZM440.903 300C438.863 300 437.303 299.556 436.223 298.668C435.143 297.756 434.603 296.328 434.603 294.384V276.348C434.603 275.988 434.795 275.7 435.179 275.484C435.587 275.244 436.019 275.124 436.475 275.124C436.931 275.124 437.363 275.244 437.771 275.484C438.179 275.7 438.383 275.988 438.383 276.348V282.936H442.775C443.111 282.936 443.363 283.08 443.531 283.368C443.723 283.656 443.819 283.98 443.819 284.34C443.819 284.7 443.723 285.024 443.531 285.312C443.363 285.6 443.111 285.744 442.775 285.744H438.383V294.384C438.383 295.248 438.563 295.86 438.923 296.22C439.307 296.58 439.967 296.76 440.903 296.76H442.127C442.679 296.76 443.087 296.928 443.351 297.264C443.639 297.576 443.783 297.948 443.783 298.38C443.783 298.788 443.639 299.16 443.351 299.496C443.087 299.832 442.679 300 442.127 300H440.903ZM448.326 300C447.774 300 447.318 299.868 446.958 299.604C446.622 299.34 446.454 299.052 446.454 298.74V274.008C446.454 273.648 446.622 273.36 446.958 273.144C447.318 272.904 447.774 272.784 448.326 272.784C448.854 272.784 449.298 272.904 449.658 273.144C450.042 273.36 450.234 273.648 450.234 274.008V285.456C450.594 284.76 451.158 284.136 451.926 283.584C452.718 283.008 453.69 282.72 454.842 282.72C455.97 282.72 457.002 283.044 457.938 283.692C458.898 284.316 459.666 285.168 460.242 286.248C460.818 287.304 461.106 288.492 461.106 289.812V298.74C461.106 299.148 460.902 299.46 460.494 299.676C460.11 299.892 459.678 300 459.198 300C458.766 300 458.346 299.892 457.938 299.676C457.53 299.46 457.326 299.148 457.326 298.74V289.812C457.326 289.188 457.158 288.588 456.822 288.012C456.486 287.436 456.042 286.968 455.49 286.608C454.962 286.248 454.362 286.068 453.689 286.068C453.114 286.068 452.562 286.224 452.034 286.536C451.506 286.824 451.074 287.244 450.738 287.796C450.402 288.348 450.234 289.02 450.234 289.812V298.74C450.234 299.052 450.042 299.34 449.658 299.604C449.298 299.868 448.854 300 448.326 300ZM472.579 300.288C470.947 300.288 469.507 299.988 468.259 299.388C467.011 298.788 466.027 297.96 465.307 296.904C464.587 295.824 464.227 294.564 464.227 293.124V289.704C464.227 288.432 464.563 287.268 465.235 286.212C465.931 285.156 466.843 284.316 467.971 283.692C469.099 283.044 470.347 282.72 471.715 282.72C473.011 282.72 474.199 283.008 475.279 283.584C476.359 284.136 477.223 284.916 477.871 285.924C478.543 286.932 478.879 288.084 478.879 289.38C478.879 290.388 478.723 291.108 478.411 291.54C478.099 291.972 477.691 292.236 477.187 292.332C476.683 292.428 476.155 292.476 475.603 292.476H468.007V293.304C468.007 294.504 468.439 295.464 469.303 296.184C470.191 296.88 471.319 297.228 472.687 297.228C473.527 297.228 474.211 297.108 474.739 296.868C475.267 296.628 475.711 296.4 476.071 296.184C476.431 295.968 476.767 295.86 477.079 295.86C477.391 295.86 477.655 295.956 477.871 296.148C478.087 296.34 478.255 296.568 478.375 296.832C478.495 297.096 478.555 297.336 478.555 297.552C478.555 297.912 478.303 298.308 477.799 298.74C477.319 299.172 476.635 299.544 475.747 299.856C474.859 300.144 473.803 300.288 472.579 300.288ZM468.007 290.136H473.983C474.511 290.136 474.859 290.064 475.027 289.92C475.219 289.776 475.315 289.488 475.315 289.056C475.315 288.432 475.159 287.856 474.847 287.328C474.535 286.776 474.103 286.356 473.551 286.068C472.999 285.756 472.375 285.6 471.679 285.6C471.007 285.6 470.395 285.744 469.843 286.032C469.291 286.32 468.847 286.716 468.511 287.22C468.175 287.724 468.007 288.312 468.007 288.984V290.136ZM494.856 300.288C493.728 300.288 492.684 299.952 491.724 299.28C490.764 298.608 489.984 297.732 489.384 296.652C488.808 295.548 488.52 294.372 488.52 293.124V289.812C488.52 288.492 488.808 287.304 489.384 286.248C489.984 285.168 490.764 284.316 491.724 283.692C492.684 283.044 493.752 282.72 494.928 282.72C496.08 282.72 497.052 283.008 497.844 283.584C498.636 284.136 499.224 284.76 499.608 285.456V274.008C499.608 273.648 499.8 273.36 500.184 273.144C500.568 272.904 501.024 272.784 501.552 272.784C502.08 272.784 502.512 272.904 502.848 273.144C503.208 273.36 503.388 273.648 503.388 274.008V298.74C503.388 299.052 503.208 299.34 502.848 299.604C502.512 299.868 502.08 300 501.552 300C501.096 300 500.688 299.868 500.328 299.604C499.992 299.34 499.824 299.052 499.824 298.74V297.48C499.464 298.224 498.828 298.884 497.916 299.46C497.004 300.012 495.984 300.288 494.856 300.288ZM495.936 296.94C496.632 296.94 497.256 296.748 497.808 296.364C498.36 295.98 498.792 295.56 499.104 295.104C499.44 294.624 499.608 294.24 499.608 293.952V289.812C499.608 289.02 499.428 288.348 499.068 287.796C498.708 287.244 498.252 286.824 497.7 286.536C497.148 286.224 496.572 286.068 495.972 286.068C495.3 286.068 494.676 286.248 494.1 286.608C493.548 286.968 493.104 287.436 492.768 288.012C492.456 288.588 492.3 289.188 492.3 289.812V293.124C492.3 293.748 492.456 294.36 492.768 294.96C493.104 295.56 493.548 296.04 494.1 296.4C494.652 296.76 495.264 296.94 495.936 296.94ZM509.25 278.652C508.65 278.652 508.134 278.448 507.702 278.04C507.27 277.632 507.054 277.176 507.054 276.672C507.054 276.12 507.27 275.652 507.702 275.268C508.134 274.884 508.65 274.692 509.25 274.692C509.85 274.692 510.354 274.884 510.762 275.268C511.194 275.652 511.41 276.12 511.41 276.672C511.41 277.176 511.194 277.632 510.762 278.04C510.354 278.448 509.85 278.652 509.25 278.652ZM509.25 300C508.698 300 508.242 299.868 507.882 299.604C507.546 299.34 507.378 299.052 507.378 298.74V284.16C507.378 283.8 507.546 283.512 507.882 283.296C508.242 283.056 508.698 282.936 509.25 282.936C509.778 282.936 510.222 283.056 510.582 283.296C510.966 283.512 511.158 283.8 511.158 284.16V298.74C511.158 299.052 510.966 299.34 510.582 299.604C510.222 299.868 509.778 300 509.25 300ZM516.95 300C516.422 300 515.978 299.892 515.618 299.676C515.282 299.436 515.114 299.136 515.114 298.776V279.66C515.114 278.364 515.402 277.2 515.978 276.168C516.554 275.112 517.322 274.284 518.282 273.684C519.242 273.084 520.298 272.784 521.45 272.784H523.142C523.622 272.784 523.982 272.952 524.222 273.288C524.486 273.624 524.618 273.996 524.618 274.404C524.618 274.836 524.486 275.22 524.222 275.556C523.982 275.868 523.622 276.024 523.142 276.024H522.17C521.546 276.024 520.982 276.168 520.478 276.456C519.998 276.744 519.614 277.14 519.326 277.644C519.038 278.124 518.894 278.676 518.894 279.3V282.936H523.538C523.898 282.936 524.162 283.08 524.33 283.368C524.522 283.656 524.618 283.98 524.618 284.34C524.618 284.7 524.522 285.024 524.33 285.312C524.162 285.6 523.898 285.744 523.538 285.744H518.894V298.776C518.894 299.136 518.702 299.436 518.318 299.676C517.934 299.892 517.478 300 516.95 300ZM528.727 300C528.199 300 527.755 299.892 527.395 299.676C527.059 299.436 526.891 299.136 526.891 298.776V279.66C526.891 278.364 527.179 277.2 527.755 276.168C528.331 275.112 529.099 274.284 530.059 273.684C531.019 273.084 532.075 272.784 533.227 272.784H534.919C535.399 272.784 535.759 272.952 535.999 273.288C536.263 273.624 536.395 273.996 536.395 274.404C536.395 274.836 536.263 275.22 535.999 275.556C535.759 275.868 535.399 276.024 534.919 276.024H533.947C533.323 276.024 532.759 276.168 532.255 276.456C531.775 276.744 531.391 277.14 531.103 277.644C530.815 278.124 530.671 278.676 530.671 279.3V282.936H535.315C535.675 282.936 535.939 283.08 536.107 283.368C536.299 283.656 536.395 283.98 536.395 284.34C536.395 284.7 536.299 285.024 536.107 285.312C535.939 285.6 535.675 285.744 535.315 285.744H530.671V298.776C530.671 299.136 530.479 299.436 530.095 299.676C529.711 299.892 529.255 300 528.727 300ZM545.809 300.288C544.177 300.288 542.737 299.988 541.489 299.388C540.241 298.788 539.257 297.96 538.537 296.904C537.817 295.824 537.457 294.564 537.457 293.124V289.704C537.457 288.432 537.793 287.268 538.465 286.212C539.161 285.156 540.073 284.316 541.201 283.692C542.329 283.044 543.577 282.72 544.945 282.72C546.241 282.72 547.429 283.008 548.509 283.584C549.589 284.136 550.453 284.916 551.101 285.924C551.773 286.932 552.109 288.084 552.109 289.38C552.109 290.388 551.953 291.108 551.641 291.54C551.329 291.972 550.921 292.236 550.417 292.332C549.913 292.428 549.385 292.476 548.833 292.476H541.237V293.304C541.237 294.504 541.669 295.464 542.533 296.184C543.421 296.88 544.549 297.228 545.917 297.228C546.757 297.228 547.441 297.108 547.969 296.868C548.497 296.628 548.941 296.4 549.301 296.184C549.661 295.968 549.997 295.86 550.309 295.86C550.621 295.86 550.885 295.956 551.101 296.148C551.317 296.34 551.485 296.568 551.605 296.832C551.725 297.096 551.785 297.336 551.785 297.552C551.785 297.912 551.533 298.308 551.029 298.74C550.549 299.172 549.865 299.544 548.977 299.856C548.089 300.144 547.033 300.288 545.809 300.288ZM541.237 290.136H547.213C547.741 290.136 548.089 290.064 548.257 289.92C548.449 289.776 548.545 289.488 548.545 289.056C548.545 288.432 548.389 287.856 548.077 287.328C547.765 286.776 547.333 286.356 546.781 286.068C546.229 285.756 545.605 285.6 544.909 285.6C544.237 285.6 543.625 285.744 543.073 286.032C542.521 286.32 542.077 286.716 541.741 287.22C541.405 287.724 541.237 288.312 541.237 288.984V290.136ZM557.027 300C556.499 300 556.055 299.868 555.695 299.604C555.359 299.34 555.191 299.052 555.191 298.74V284.16C555.191 283.8 555.359 283.512 555.695 283.296C556.055 283.056 556.499 282.936 557.027 282.936C557.507 282.936 557.915 283.056 558.251 283.296C558.587 283.512 558.755 283.8 558.755 284.16V285.744C559.019 285.24 559.367 284.76 559.799 284.304C560.255 283.848 560.783 283.476 561.383 283.188C561.983 282.876 562.631 282.72 563.327 282.72H564.479C564.863 282.72 565.199 282.888 565.487 283.224C565.775 283.536 565.919 283.92 565.919 284.376C565.919 284.832 565.775 285.228 565.487 285.564C565.199 285.9 564.863 286.068 564.479 286.068H563.327C562.607 286.068 561.911 286.284 561.239 286.716C560.567 287.148 560.015 287.76 559.583 288.552C559.175 289.32 558.971 290.256 558.971 291.36V298.74C558.971 299.052 558.779 299.34 558.395 299.604C558.035 299.868 557.579 300 557.027 300ZM575.235 300.288C573.603 300.288 572.163 299.988 570.915 299.388C569.667 298.788 568.683 297.96 567.963 296.904C567.243 295.824 566.883 294.564 566.883 293.124V289.704C566.883 288.432 567.219 287.268 567.891 286.212C568.587 285.156 569.499 284.316 570.627 283.692C571.755 283.044 573.003 282.72 574.371 282.72C575.667 282.72 576.855 283.008 577.935 283.584C579.015 284.136 579.879 284.916 580.527 285.924C581.199 286.932 581.535 288.084 581.535 289.38C581.535 290.388 581.379 291.108 581.067 291.54C580.755 291.972 580.347 292.236 579.843 292.332C579.339 292.428 578.811 292.476 578.259 292.476H570.663V293.304C570.663 294.504 571.095 295.464 571.959 296.184C572.847 296.88 573.975 297.228 575.343 297.228C576.183 297.228 576.867 297.108 577.395 296.868C577.923 296.628 578.367 296.4 578.727 296.184C579.087 295.968 579.423 295.86 579.735 295.86C580.047 295.86 580.311 295.956 580.527 296.148C580.743 296.34 580.911 296.568 581.031 296.832C581.151 297.096 581.211 297.336 581.211 297.552C581.211 297.912 580.959 298.308 580.455 298.74C579.975 299.172 579.291 299.544 578.403 299.856C577.515 300.144 576.459 300.288 575.235 300.288ZM570.663 290.136H576.639C577.167 290.136 577.515 290.064 577.683 289.92C577.875 289.776 577.971 289.488 577.971 289.056C577.971 288.432 577.815 287.856 577.503 287.328C577.191 286.776 576.759 286.356 576.207 286.068C575.655 285.756 575.031 285.6 574.335 285.6C573.663 285.6 573.051 285.744 572.499 286.032C571.947 286.32 571.503 286.716 571.167 287.22C570.831 287.724 570.663 288.312 570.663 288.984V290.136ZM586.489 300C585.937 300 585.481 299.868 585.121 299.604C584.785 299.34 584.617 299.052 584.617 298.74V284.16C584.617 283.8 584.785 283.512 585.121 283.296C585.481 283.056 585.937 282.936 586.489 282.936C586.945 282.936 587.341 283.056 587.677 283.296C588.013 283.512 588.181 283.8 588.181 284.16V285.456C588.541 284.76 589.129 284.136 589.945 283.584C590.785 283.008 591.805 282.72 593.005 282.72C594.133 282.72 595.165 283.044 596.101 283.692C597.061 284.316 597.829 285.168 598.405 286.248C598.981 287.304 599.269 288.492 599.269 289.812V298.74C599.269 299.148 599.065 299.46 598.657 299.676C598.273 299.892 597.841 300 597.361 300C596.929 300 596.509 299.892 596.101 299.676C595.693 299.46 595.489 299.148 595.489 298.74V289.812C595.489 289.188 595.321 288.588 594.985 288.012C594.673 287.436 594.241 286.968 593.689 286.608C593.137 286.248 592.525 286.068 591.853 286.068C591.277 286.068 590.725 286.224 590.197 286.536C589.669 286.824 589.237 287.244 588.901 287.796C588.565 288.348 588.397 289.02 588.397 289.812V298.74C588.397 299.052 588.205 299.34 587.821 299.604C587.461 299.868 587.017 300 586.489 300ZM609.267 300C607.227 300 605.667 299.556 604.587 298.668C603.507 297.756 602.967 296.328 602.967 294.384V276.348C602.967 275.988 603.159 275.7 603.543 275.484C603.951 275.244 604.383 275.124 604.839 275.124C605.295 275.124 605.727 275.244 606.135 275.484C606.543 275.7 606.747 275.988 606.747 276.348V282.936H611.139C611.475 282.936 611.727 283.08 611.895 283.368C612.087 283.656 612.183 283.98 612.183 284.34C612.183 284.7 612.087 285.024 611.895 285.312C611.727 285.6 611.475 285.744 611.139 285.744H606.747V294.384C606.747 295.248 606.927 295.86 607.287 296.22C607.671 296.58 608.331 296.76 609.267 296.76H610.491C611.043 296.76 611.451 296.928 611.715 297.264C612.003 297.576 612.147 297.948 612.147 298.38C612.147 298.788 612.003 299.16 611.715 299.496C611.451 299.832 611.043 300 610.491 300H609.267ZM98.9058 346C98.3778 346 97.9338 345.868 97.5738 345.604C97.2378 345.34 97.0698 345.052 97.0698 344.74V330.16C97.0698 329.8 97.2378 329.512 97.5738 329.296C97.9338 329.056 98.3778 328.936 98.9058 328.936C99.3858 328.936 99.7938 329.056 100.13 329.296C100.466 329.512 100.634 329.8 100.634 330.16V331.744C100.898 331.24 101.246 330.76 101.678 330.304C102.134 329.848 102.662 329.476 103.262 329.188C103.862 328.876 104.51 328.72 105.206 328.72H106.358C106.742 328.72 107.078 328.888 107.366 329.224C107.654 329.536 107.798 329.92 107.798 330.376C107.798 330.832 107.654 331.228 107.366 331.564C107.078 331.9 106.742 332.068 106.358 332.068H105.206C104.486 332.068 103.79 332.284 103.118 332.716C102.446 333.148 101.894 333.76 101.462 334.552C101.054 335.32 100.85 336.256 100.85 337.36V344.74C100.85 345.052 100.658 345.34 100.274 345.604C99.9138 345.868 99.4578 346 98.9058 346ZM117.114 346.288C115.482 346.288 114.042 345.988 112.794 345.388C111.546 344.788 110.562 343.96 109.842 342.904C109.122 341.824 108.762 340.564 108.762 339.124V335.704C108.762 334.432 109.098 333.268 109.77 332.212C110.466 331.156 111.378 330.316 112.506 329.692C113.634 329.044 114.882 328.72 116.25 328.72C117.546 328.72 118.734 329.008 119.814 329.584C120.894 330.136 121.758 330.916 122.406 331.924C123.078 332.932 123.414 334.084 123.414 335.38C123.414 336.388 123.258 337.108 122.946 337.54C122.634 337.972 122.226 338.236 121.722 338.332C121.218 338.428 120.69 338.476 120.138 338.476H112.542V339.304C112.542 340.504 112.974 341.464 113.838 342.184C114.726 342.88 115.854 343.228 117.222 343.228C118.062 343.228 118.746 343.108 119.274 342.868C119.802 342.628 120.246 342.4 120.606 342.184C120.966 341.968 121.302 341.86 121.614 341.86C121.926 341.86 122.19 341.956 122.406 342.148C122.622 342.34 122.79 342.568 122.91 342.832C123.03 343.096 123.09 343.336 123.09 343.552C123.09 343.912 122.838 344.308 122.334 344.74C121.854 345.172 121.17 345.544 120.282 345.856C119.394 346.144 118.338 346.288 117.114 346.288ZM112.542 336.136H118.518C119.046 336.136 119.394 336.064 119.562 335.92C119.754 335.776 119.85 335.488 119.85 335.056C119.85 334.432 119.694 333.856 119.382 333.328C119.07 332.776 118.638 332.356 118.086 332.068C117.534 331.756 116.91 331.6 116.214 331.6C115.542 331.6 114.93 331.744 114.378 332.032C113.826 332.32 113.382 332.716 113.046 333.22C112.71 333.724 112.542 334.312 112.542 334.984V336.136ZM128.692 346C128.14 346 127.684 345.868 127.324 345.604C126.988 345.34 126.82 345.052 126.82 344.74V320.008C126.82 319.648 126.988 319.36 127.324 319.144C127.684 318.904 128.14 318.784 128.692 318.784C129.22 318.784 129.664 318.904 130.024 319.144C130.408 319.36 130.6 319.648 130.6 320.008V344.74C130.6 345.052 130.408 345.34 130.024 345.604C129.664 345.868 129.22 346 128.692 346ZM136.735 324.652C136.135 324.652 135.619 324.448 135.187 324.04C134.755 323.632 134.539 323.176 134.539 322.672C134.539 322.12 134.755 321.652 135.187 321.268C135.619 320.884 136.135 320.692 136.735 320.692C137.335 320.692 137.839 320.884 138.247 321.268C138.679 321.652 138.895 322.12 138.895 322.672C138.895 323.176 138.679 323.632 138.247 324.04C137.839 324.448 137.335 324.652 136.735 324.652ZM136.735 346C136.183 346 135.727 345.868 135.367 345.604C135.031 345.34 134.863 345.052 134.863 344.74V330.16C134.863 329.8 135.031 329.512 135.367 329.296C135.727 329.056 136.183 328.936 136.735 328.936C137.263 328.936 137.707 329.056 138.067 329.296C138.451 329.512 138.643 329.8 138.643 330.16V344.74C138.643 345.052 138.451 345.34 138.067 345.604C137.707 345.868 137.263 346 136.735 346ZM149.006 354.1C147.614 354.1 146.33 353.896 145.154 353.488C143.978 353.104 143.042 352.54 142.346 351.796C141.65 351.052 141.302 350.164 141.302 349.132C141.302 348.172 141.578 347.368 142.13 346.72C142.682 346.096 143.33 345.616 144.074 345.28C143.594 345.064 143.198 344.776 142.886 344.416C142.574 344.056 142.418 343.552 142.418 342.904C142.418 342.232 142.586 341.692 142.922 341.284C143.258 340.876 143.69 340.504 144.218 340.168C143.546 339.64 143.018 338.992 142.634 338.224C142.274 337.432 142.094 336.568 142.094 335.632V334.624C142.094 333.472 142.37 332.452 142.922 331.564C143.474 330.676 144.254 329.98 145.262 329.476C146.294 328.972 147.47 328.72 148.79 328.72C149.606 328.72 150.362 328.828 151.058 329.044C151.778 329.26 152.414 329.56 152.966 329.944C153.35 329.056 153.734 328.432 154.118 328.072C154.526 327.712 154.91 327.532 155.27 327.532C155.774 327.532 156.158 327.676 156.422 327.964C156.686 328.252 156.818 328.54 156.818 328.828C156.818 329.02 156.758 329.2 156.638 329.368C156.542 329.512 156.398 329.632 156.206 329.728C155.966 329.848 155.678 330.016 155.342 330.232C155.03 330.424 154.718 330.736 154.406 331.168C154.814 331.624 155.114 332.152 155.306 332.752C155.498 333.352 155.594 333.976 155.594 334.624V335.632C155.594 336.76 155.306 337.78 154.73 338.692C154.154 339.604 153.35 340.324 152.318 340.852C151.286 341.356 150.11 341.608 148.79 341.608C147.854 341.608 147.026 341.464 146.306 341.176C146.114 341.296 145.946 341.44 145.802 341.608C145.682 341.752 145.622 341.944 145.622 342.184C145.622 342.616 145.886 342.928 146.414 343.12C146.942 343.312 147.614 343.456 148.43 343.552C149.27 343.648 150.158 343.768 151.094 343.912C152.03 344.056 152.906 344.296 153.722 344.632C154.562 344.944 155.246 345.412 155.774 346.036C156.302 346.684 156.566 347.56 156.566 348.664C156.566 349.912 156.218 350.932 155.522 351.724C154.826 352.54 153.902 353.14 152.75 353.524C151.622 353.908 150.374 354.1 149.006 354.1ZM148.934 351.58C150.11 351.58 151.058 351.316 151.778 350.788C152.522 350.284 152.894 349.612 152.894 348.772C152.894 348.172 152.714 347.704 152.354 347.368C151.994 347.032 151.526 346.78 150.95 346.612C150.374 346.444 149.762 346.324 149.114 346.252C148.49 346.18 147.89 346.108 147.314 346.036C146.642 346.276 146.066 346.612 145.586 347.044C145.13 347.5 144.902 348.064 144.902 348.736C144.902 349.624 145.274 350.32 146.018 350.824C146.786 351.328 147.758 351.58 148.934 351.58ZM148.862 339.196C149.822 339.196 150.566 338.86 151.094 338.188C151.646 337.516 151.922 336.664 151.922 335.632V334.624C151.922 333.64 151.646 332.812 151.094 332.14C150.566 331.468 149.81 331.132 148.826 331.132C147.842 331.132 147.086 331.468 146.558 332.14C146.03 332.812 145.766 333.64 145.766 334.624V335.596C145.766 336.604 146.03 337.456 146.558 338.152C147.086 338.848 147.854 339.196 148.862 339.196ZM161.168 324.652C160.568 324.652 160.052 324.448 159.62 324.04C159.188 323.632 158.972 323.176 158.972 322.672C158.972 322.12 159.188 321.652 159.62 321.268C160.052 320.884 160.568 320.692 161.168 320.692C161.768 320.692 162.272 320.884 162.68 321.268C163.112 321.652 163.328 322.12 163.328 322.672C163.328 323.176 163.112 323.632 162.68 324.04C162.272 324.448 161.768 324.652 161.168 324.652ZM161.168 346C160.616 346 160.16 345.868 159.8 345.604C159.464 345.34 159.296 345.052 159.296 344.74V330.16C159.296 329.8 159.464 329.512 159.8 329.296C160.16 329.056 160.616 328.936 161.168 328.936C161.696 328.936 162.14 329.056 162.5 329.296C162.884 329.512 163.076 329.8 163.076 330.16V344.74C163.076 345.052 162.884 345.34 162.5 345.604C162.14 345.868 161.696 346 161.168 346ZM173.728 346.288C172.432 346.288 171.22 345.952 170.092 345.28C168.964 344.608 168.052 343.732 167.356 342.652C166.684 341.548 166.348 340.372 166.348 339.124V335.812C166.348 334.54 166.672 333.364 167.32 332.284C167.992 331.204 168.892 330.34 170.02 329.692C171.172 329.044 172.42 328.72 173.764 328.72C175.108 328.72 176.344 329.044 177.472 329.692C178.6 330.316 179.5 331.168 180.172 332.248C180.868 333.304 181.216 334.492 181.216 335.812V339.124C181.216 340.348 180.868 341.512 180.172 342.616C179.5 343.72 178.588 344.608 177.436 345.28C176.308 345.952 175.072 346.288 173.728 346.288ZM173.764 342.94C174.436 342.94 175.048 342.76 175.6 342.4C176.152 342.04 176.596 341.572 176.932 340.996C177.268 340.396 177.436 339.772 177.436 339.124V335.812C177.436 335.188 177.268 334.588 176.932 334.012C176.596 333.436 176.152 332.968 175.6 332.608C175.048 332.248 174.436 332.068 173.764 332.068C173.068 332.068 172.444 332.248 171.892 332.608C171.364 332.968 170.932 333.436 170.596 334.012C170.284 334.588 170.128 335.188 170.128 335.812V339.124C170.128 339.772 170.284 340.396 170.596 340.996C170.932 341.572 171.376 342.04 171.928 342.4C172.48 342.76 173.092 342.94 173.764 342.94ZM186.375 346C185.823 346 185.367 345.868 185.007 345.604C184.671 345.34 184.503 345.052 184.503 344.74V330.16C184.503 329.8 184.671 329.512 185.007 329.296C185.367 329.056 185.823 328.936 186.375 328.936C186.831 328.936 187.227 329.056 187.563 329.296C187.899 329.512 188.067 329.8 188.067 330.16V331.456C188.427 330.76 189.015 330.136 189.831 329.584C190.671 329.008 191.691 328.72 192.891 328.72C194.019 328.72 195.051 329.044 195.987 329.692C196.947 330.316 197.715 331.168 198.291 332.248C198.867 333.304 199.155 334.492 199.155 335.812V344.74C199.155 345.148 198.951 345.46 198.543 345.676C198.159 345.892 197.727 346 197.247 346C196.815 346 196.395 345.892 195.987 345.676C195.579 345.46 195.375 345.148 195.375 344.74V335.812C195.375 335.188 195.207 334.588 194.871 334.012C194.559 333.436 194.127 332.968 193.575 332.608C193.023 332.248 192.411 332.068 191.739 332.068C191.163 332.068 190.611 332.224 190.083 332.536C189.555 332.824 189.123 333.244 188.787 333.796C188.451 334.348 188.283 335.02 188.283 335.812V344.74C188.283 345.052 188.091 345.34 187.707 345.604C187.347 345.868 186.903 346 186.375 346ZM208.145 346.288C206.969 346.288 205.913 346.144 204.977 345.856C204.041 345.568 203.297 345.208 202.745 344.776C202.217 344.32 201.953 343.864 201.953 343.408C201.953 343.192 202.001 342.952 202.097 342.688C202.217 342.424 202.373 342.196 202.565 342.004C202.781 341.812 203.009 341.716 203.249 341.716C203.561 341.716 203.885 341.86 204.221 342.148C204.581 342.412 205.049 342.688 205.625 342.976C206.201 343.24 207.005 343.372 208.037 343.372C209.237 343.372 210.041 343.168 210.449 342.76C210.881 342.352 211.097 341.908 211.097 341.428C211.097 340.804 210.881 340.324 210.449 339.988C210.041 339.628 209.501 339.34 208.829 339.124C208.181 338.908 207.485 338.704 206.741 338.512C205.997 338.296 205.289 338.02 204.617 337.684C203.969 337.348 203.429 336.88 202.997 336.28C202.589 335.68 202.385 334.888 202.385 333.904C202.385 333.088 202.589 332.284 202.997 331.492C203.405 330.676 204.053 330.016 204.941 329.512C205.853 328.984 207.065 328.72 208.577 328.72C209.489 328.72 210.353 328.816 211.169 329.008C211.985 329.2 212.657 329.464 213.185 329.8C213.713 330.112 213.977 330.46 213.977 330.844C213.977 331.012 213.917 331.252 213.797 331.564C213.677 331.852 213.509 332.116 213.293 332.356C213.101 332.572 212.849 332.68 212.537 332.68C212.297 332.68 211.997 332.596 211.637 332.428C211.277 332.236 210.857 332.056 210.377 331.888C209.897 331.72 209.309 331.636 208.613 331.636C207.917 331.636 207.353 331.756 206.921 331.996C206.513 332.212 206.213 332.476 206.021 332.788C205.829 333.1 205.733 333.412 205.733 333.724C205.733 334.252 205.937 334.66 206.345 334.948C206.753 335.236 207.293 335.476 207.965 335.668C208.637 335.86 209.345 336.064 210.089 336.28C210.833 336.472 211.529 336.76 212.177 337.144C212.849 337.528 213.389 338.044 213.797 338.692C214.229 339.34 214.445 340.204 214.445 341.284C214.445 342.796 213.893 344.008 212.789 344.92C211.709 345.832 210.161 346.288 208.145 346.288ZM218.378 349.384C218.09 349.384 217.802 349.288 217.514 349.096C217.226 348.928 217.082 348.688 217.082 348.376C217.082 348.208 217.118 348.052 217.19 347.908L217.982 346C217.598 345.832 217.286 345.58 217.046 345.244C216.83 344.884 216.722 344.488 216.722 344.056C216.722 343.456 216.926 342.952 217.334 342.544C217.766 342.112 218.27 341.896 218.846 341.896C219.422 341.896 219.926 342.1 220.358 342.508C220.79 342.916 221.006 343.432 221.006 344.056C221.006 344.128 220.994 344.236 220.97 344.38C220.946 344.524 220.874 344.752 220.754 345.064C220.634 345.376 220.454 345.832 220.214 346.432C219.974 347.032 219.65 347.836 219.242 348.844C219.17 349.036 219.038 349.168 218.846 349.24C218.678 349.336 218.522 349.384 218.378 349.384ZM231.439 354.1C230.959 354.1 230.551 353.992 230.215 353.776C229.879 353.584 229.711 353.152 229.711 352.48C229.711 352.048 229.783 351.664 229.927 351.328C230.071 351.016 230.335 350.86 230.719 350.86C231.175 350.86 231.667 350.74 232.195 350.5C232.747 350.284 233.275 349.924 233.779 349.42C234.307 348.94 234.751 348.328 235.111 347.584C235.495 346.84 235.759 345.964 235.903 344.956L229.819 330.988C229.723 330.82 229.675 330.652 229.675 330.484C229.675 330.172 229.807 329.884 230.071 329.62C230.359 329.332 230.695 329.104 231.079 328.936C231.463 328.768 231.823 328.684 232.159 328.684C232.399 328.684 232.627 328.744 232.843 328.864C233.083 328.96 233.239 329.128 233.311 329.368L237.847 341.068L241.771 329.368C241.843 329.128 241.987 328.96 242.203 328.864C242.419 328.744 242.635 328.684 242.851 328.684C243.139 328.684 243.475 328.768 243.859 328.936C244.267 329.104 244.615 329.332 244.903 329.62C245.215 329.884 245.371 330.196 245.371 330.556C245.371 330.748 245.335 330.892 245.263 330.988L239.863 345.064C239.479 346.096 239.083 347.14 238.675 348.196C238.267 349.276 237.763 350.26 237.163 351.148C236.587 352.036 235.831 352.744 234.895 353.272C233.983 353.824 232.831 354.1 231.439 354.1ZM254.446 346.288C253.15 346.288 251.938 345.952 250.81 345.28C249.682 344.608 248.77 343.732 248.074 342.652C247.402 341.548 247.066 340.372 247.066 339.124V335.812C247.066 334.54 247.39 333.364 248.038 332.284C248.71 331.204 249.61 330.34 250.738 329.692C251.89 329.044 253.138 328.72 254.482 328.72C255.826 328.72 257.062 329.044 258.19 329.692C259.318 330.316 260.218 331.168 260.89 332.248C261.586 333.304 261.934 334.492 261.934 335.812V339.124C261.934 340.348 261.586 341.512 260.89 342.616C260.218 343.72 259.306 344.608 258.154 345.28C257.026 345.952 255.79 346.288 254.446 346.288ZM254.482 342.94C255.154 342.94 255.766 342.76 256.318 342.4C256.87 342.04 257.314 341.572 257.65 340.996C257.986 340.396 258.154 339.772 258.154 339.124V335.812C258.154 335.188 257.986 334.588 257.65 334.012C257.314 333.436 256.87 332.968 256.318 332.608C255.766 332.248 255.154 332.068 254.482 332.068C253.786 332.068 253.162 332.248 252.61 332.608C252.082 332.968 251.65 333.436 251.314 334.012C251.002 334.588 250.846 335.188 250.846 335.812V339.124C250.846 339.772 251.002 340.396 251.314 340.996C251.65 341.572 252.094 342.04 252.646 342.4C253.198 342.76 253.81 342.94 254.482 342.94ZM272.494 346.288C271.15 346.288 269.902 345.964 268.75 345.316C267.622 344.644 266.722 343.768 266.05 342.688C265.378 341.584 265.042 340.42 265.042 339.196V330.196C265.042 329.884 265.222 329.596 265.582 329.332C265.966 329.068 266.422 328.936 266.95 328.936C267.454 328.936 267.886 329.068 268.246 329.332C268.63 329.596 268.822 329.884 268.822 330.196V339.196C268.822 339.82 268.978 340.42 269.29 340.996C269.626 341.572 270.07 342.04 270.622 342.4C271.198 342.76 271.822 342.94 272.494 342.94C273.166 342.94 273.778 342.76 274.33 342.4C274.882 342.04 275.314 341.572 275.626 340.996C275.962 340.42 276.13 339.82 276.13 339.196V330.16C276.13 329.824 276.322 329.536 276.706 329.296C277.114 329.056 277.558 328.936 278.038 328.936C278.59 328.936 279.034 329.056 279.37 329.296C279.73 329.536 279.91 329.824 279.91 330.16V339.196C279.91 340.468 279.574 341.644 278.902 342.724C278.23 343.804 277.33 344.668 276.202 345.316C275.074 345.964 273.838 346.288 272.494 346.288ZM297.798 346.288C296.07 346.288 294.642 345.976 293.514 345.352C292.41 344.728 291.594 343.876 291.066 342.796C290.538 341.716 290.274 340.492 290.274 339.124V335.884C290.274 334.54 290.538 333.328 291.066 332.248C291.594 331.144 292.41 330.28 293.514 329.656C294.618 329.032 296.022 328.72 297.726 328.72C298.83 328.72 299.79 328.852 300.606 329.116C301.446 329.38 302.094 329.716 302.55 330.124C303.03 330.508 303.27 330.916 303.27 331.348C303.27 331.564 303.198 331.828 303.054 332.14C302.934 332.428 302.754 332.68 302.514 332.896C302.298 333.088 302.034 333.184 301.722 333.184C301.482 333.184 301.218 333.088 300.93 332.896C300.666 332.704 300.306 332.524 299.85 332.356C299.394 332.164 298.782 332.068 298.014 332.068C296.67 332.068 295.674 332.404 295.026 333.076C294.378 333.748 294.054 334.684 294.054 335.884V339.124C294.054 340.324 294.378 341.26 295.026 341.932C295.674 342.604 296.682 342.94 298.05 342.94C298.842 342.94 299.466 342.844 299.922 342.652C300.378 342.436 300.738 342.232 301.002 342.04C301.29 341.848 301.566 341.752 301.83 341.752C302.166 341.752 302.454 341.848 302.694 342.04C302.958 342.232 303.15 342.472 303.27 342.76C303.414 343.048 303.486 343.312 303.486 343.552C303.486 343.96 303.234 344.38 302.73 344.812C302.25 345.244 301.578 345.604 300.714 345.892C299.874 346.156 298.902 346.288 297.798 346.288ZM309.887 346.288C308.567 346.288 307.439 345.904 306.503 345.136C305.567 344.344 305.099 343.144 305.099 341.536C305.099 340.168 305.459 339.112 306.179 338.368C306.899 337.624 307.883 337.108 309.131 336.82C310.403 336.532 311.867 336.388 313.523 336.388H315.107V335.74C315.107 335.116 314.987 334.516 314.747 333.94C314.531 333.34 314.159 332.848 313.631 332.464C313.127 332.056 312.431 331.852 311.543 331.852C310.655 331.852 309.971 331.936 309.491 332.104C309.011 332.272 308.627 332.452 308.339 332.644C308.051 332.836 307.787 332.932 307.547 332.932C307.115 332.932 306.779 332.728 306.539 332.32C306.299 331.888 306.179 331.456 306.179 331.024C306.179 330.592 306.455 330.208 307.007 329.872C307.583 329.512 308.291 329.236 309.131 329.044C309.971 328.828 310.799 328.72 311.615 328.72C313.391 328.72 314.807 329.056 315.863 329.728C316.919 330.376 317.687 331.228 318.167 332.284C318.647 333.34 318.887 334.48 318.887 335.704V344.74C318.887 345.076 318.707 345.376 318.347 345.64C318.011 345.88 317.579 346 317.051 346C316.571 346 316.163 345.88 315.827 345.64C315.491 345.376 315.323 345.076 315.323 344.74V343.48C314.699 344.2 313.943 344.848 313.055 345.424C312.167 346 311.111 346.288 309.887 346.288ZM311.255 343.408C311.855 343.408 312.443 343.228 313.019 342.868C313.619 342.508 314.111 342.052 314.495 341.5C314.903 340.948 315.107 340.384 315.107 339.808V338.476H314.207C313.295 338.476 312.431 338.536 311.615 338.656C310.799 338.752 310.139 338.992 309.635 339.376C309.155 339.736 308.915 340.3 308.915 341.068C308.915 341.884 309.131 342.484 309.563 342.868C310.019 343.228 310.583 343.408 311.255 343.408ZM324.575 346C324.023 346 323.567 345.868 323.207 345.604C322.871 345.34 322.703 345.052 322.703 344.74V330.16C322.703 329.8 322.871 329.512 323.207 329.296C323.567 329.056 324.023 328.936 324.575 328.936C325.031 328.936 325.427 329.056 325.763 329.296C326.099 329.512 326.267 329.8 326.267 330.16V331.456C326.627 330.76 327.215 330.136 328.031 329.584C328.871 329.008 329.891 328.72 331.091 328.72C332.219 328.72 333.251 329.044 334.187 329.692C335.147 330.316 335.915 331.168 336.491 332.248C337.067 333.304 337.355 334.492 337.355 335.812V344.74C337.355 345.148 337.151 345.46 336.743 345.676C336.359 345.892 335.927 346 335.447 346C335.015 346 334.595 345.892 334.187 345.676C333.779 345.46 333.575 345.148 333.575 344.74V335.812C333.575 335.188 333.407 334.588 333.071 334.012C332.759 333.436 332.327 332.968 331.775 332.608C331.223 332.248 330.611 332.068 329.939 332.068C329.363 332.068 328.811 332.224 328.283 332.536C327.755 332.824 327.323 333.244 326.987 333.796C326.651 334.348 326.483 335.02 326.483 335.812V344.74C326.483 345.052 326.291 345.34 325.907 345.604C325.547 345.868 325.103 346 324.575 346ZM350.204 346C349.652 346 349.196 345.868 348.836 345.604C348.5 345.34 348.332 345.052 348.332 344.74V330.16C348.332 329.8 348.5 329.512 348.836 329.296C349.196 329.056 349.652 328.936 350.204 328.936C350.66 328.936 351.056 329.056 351.392 329.296C351.728 329.512 351.896 329.8 351.896 330.16V331.456C352.256 330.76 352.844 330.136 353.66 329.584C354.5 329.008 355.52 328.72 356.72 328.72C357.848 328.72 358.88 329.044 359.816 329.692C360.776 330.316 361.544 331.168 362.12 332.248C362.696 333.304 362.984 334.492 362.984 335.812V344.74C362.984 345.148 362.78 345.46 362.372 345.676C361.988 345.892 361.556 346 361.076 346C360.644 346 360.224 345.892 359.816 345.676C359.408 345.46 359.204 345.148 359.204 344.74V335.812C359.204 335.188 359.036 334.588 358.7 334.012C358.388 333.436 357.956 332.968 357.404 332.608C356.852 332.248 356.24 332.068 355.568 332.068C354.992 332.068 354.44 332.224 353.912 332.536C353.384 332.824 352.952 333.244 352.616 333.796C352.28 334.348 352.112 335.02 352.112 335.812V344.74C352.112 345.052 351.92 345.34 351.536 345.604C351.176 345.868 350.732 346 350.204 346ZM373.485 346.288C372.189 346.288 370.977 345.952 369.849 345.28C368.721 344.608 367.809 343.732 367.113 342.652C366.441 341.548 366.105 340.372 366.105 339.124V335.812C366.105 334.54 366.429 333.364 367.077 332.284C367.749 331.204 368.649 330.34 369.777 329.692C370.929 329.044 372.177 328.72 373.521 328.72C374.865 328.72 376.101 329.044 377.229 329.692C378.357 330.316 379.257 331.168 379.929 332.248C380.625 333.304 380.973 334.492 380.973 335.812V339.124C380.973 340.348 380.625 341.512 379.929 342.616C379.257 343.72 378.345 344.608 377.193 345.28C376.065 345.952 374.829 346.288 373.485 346.288ZM373.521 342.94C374.193 342.94 374.805 342.76 375.357 342.4C375.909 342.04 376.353 341.572 376.689 340.996C377.025 340.396 377.193 339.772 377.193 339.124V335.812C377.193 335.188 377.025 334.588 376.689 334.012C376.353 333.436 375.909 332.968 375.357 332.608C374.805 332.248 374.193 332.068 373.521 332.068C372.825 332.068 372.201 332.248 371.649 332.608C371.121 332.968 370.689 333.436 370.353 334.012C370.041 334.588 369.885 335.188 369.885 335.812V339.124C369.885 339.772 370.041 340.396 370.353 340.996C370.689 341.572 371.133 342.04 371.685 342.4C372.237 342.76 372.849 342.94 373.521 342.94ZM389.841 346.36C389.505 346.36 389.205 346.3 388.941 346.18C388.677 346.06 388.485 345.844 388.365 345.532L382.785 330.988C382.737 330.868 382.689 330.76 382.641 330.664C382.617 330.544 382.605 330.448 382.605 330.376C382.605 330.064 382.737 329.8 383.001 329.584C383.265 329.344 383.577 329.152 383.937 329.008C384.321 328.864 384.681 328.792 385.017 328.792C385.281 328.792 385.521 328.852 385.737 328.972C385.953 329.068 386.097 329.236 386.169 329.476L390.165 340.672L393.225 330.736C393.345 330.376 393.525 330.148 393.765 330.052C394.005 329.956 394.269 329.908 394.557 329.908C394.869 329.908 395.145 329.956 395.385 330.052C395.625 330.148 395.805 330.376 395.925 330.736L398.913 340.744L402.945 329.476C403.089 329.02 403.461 328.792 404.061 328.792C404.397 328.792 404.745 328.864 405.105 329.008C405.489 329.128 405.813 329.308 406.077 329.548C406.341 329.788 406.473 330.076 406.473 330.412C406.473 330.484 406.461 330.58 406.437 330.7C406.413 330.82 406.377 330.916 406.329 330.988L400.749 345.604C400.653 345.892 400.461 346.084 400.173 346.18C399.909 346.3 399.609 346.36 399.273 346.36C398.889 346.36 398.553 346.3 398.265 346.18C398.001 346.06 397.821 345.88 397.725 345.64L394.557 336.352L391.461 345.532C391.365 345.82 391.161 346.024 390.849 346.144C390.561 346.288 390.225 346.36 389.841 346.36ZM417.879 354.1C417.351 354.1 416.907 353.968 416.547 353.704C416.211 353.44 416.043 353.152 416.043 352.84V330.16C416.043 329.8 416.211 329.512 416.547 329.296C416.907 329.056 417.339 328.936 417.843 328.936C418.347 328.936 418.767 329.056 419.103 329.296C419.439 329.512 419.607 329.8 419.607 330.16V331.456C420.015 330.76 420.627 330.136 421.443 329.584C422.283 329.008 423.279 328.72 424.431 328.72C425.631 328.72 426.723 329.044 427.707 329.692C428.691 330.316 429.471 331.168 430.047 332.248C430.623 333.304 430.911 334.492 430.911 335.812V339.124C430.911 340.372 430.611 341.548 430.011 342.652C429.435 343.732 428.667 344.608 427.707 345.28C426.747 345.952 425.703 346.288 424.575 346.288C423.495 346.288 422.523 346.012 421.659 345.46C420.795 344.884 420.183 344.224 419.823 343.48V352.84C419.823 353.152 419.631 353.44 419.247 353.704C418.887 353.968 418.431 354.1 417.879 354.1ZM423.459 342.94C424.107 342.94 424.707 342.76 425.259 342.4C425.811 342.04 426.255 341.56 426.591 340.96C426.951 340.36 427.131 339.748 427.131 339.124V335.812C427.131 335.188 426.963 334.588 426.627 334.012C426.291 333.436 425.835 332.968 425.259 332.608C424.707 332.248 424.083 332.068 423.387 332.068C422.811 332.068 422.247 332.224 421.695 332.536C421.143 332.824 420.687 333.244 420.327 333.796C419.991 334.348 419.823 335.02 419.823 335.812V339.952C419.823 340.24 419.979 340.624 420.291 341.104C420.603 341.56 421.035 341.98 421.587 342.364C422.139 342.748 422.763 342.94 423.459 342.94ZM436.414 346C435.862 346 435.406 345.868 435.046 345.604C434.71 345.34 434.542 345.052 434.542 344.74V320.008C434.542 319.648 434.71 319.36 435.046 319.144C435.406 318.904 435.862 318.784 436.414 318.784C436.942 318.784 437.386 318.904 437.746 319.144C438.13 319.36 438.322 319.648 438.322 320.008V344.74C438.322 345.052 438.13 345.34 437.746 345.604C437.386 345.868 436.942 346 436.414 346ZM446.293 346.288C444.973 346.288 443.845 345.904 442.909 345.136C441.973 344.344 441.505 343.144 441.505 341.536C441.505 340.168 441.865 339.112 442.585 338.368C443.305 337.624 444.289 337.108 445.537 336.82C446.809 336.532 448.273 336.388 449.929 336.388H451.513V335.74C451.513 335.116 451.393 334.516 451.153 333.94C450.937 333.34 450.565 332.848 450.037 332.464C449.533 332.056 448.837 331.852 447.949 331.852C447.061 331.852 446.377 331.936 445.897 332.104C445.417 332.272 445.033 332.452 444.745 332.644C444.457 332.836 444.193 332.932 443.953 332.932C443.521 332.932 443.185 332.728 442.945 332.32C442.705 331.888 442.585 331.456 442.585 331.024C442.585 330.592 442.861 330.208 443.413 329.872C443.989 329.512 444.697 329.236 445.537 329.044C446.377 328.828 447.205 328.72 448.021 328.72C449.797 328.72 451.213 329.056 452.269 329.728C453.325 330.376 454.093 331.228 454.573 332.284C455.053 333.34 455.293 334.48 455.293 335.704V344.74C455.293 345.076 455.113 345.376 454.753 345.64C454.417 345.88 453.985 346 453.457 346C452.977 346 452.569 345.88 452.233 345.64C451.897 345.376 451.729 345.076 451.729 344.74V343.48C451.105 344.2 450.349 344.848 449.461 345.424C448.573 346 447.517 346.288 446.293 346.288ZM447.661 343.408C448.261 343.408 448.849 343.228 449.425 342.868C450.025 342.508 450.517 342.052 450.901 341.5C451.309 340.948 451.513 340.384 451.513 339.808V338.476H450.613C449.701 338.476 448.837 338.536 448.021 338.656C447.205 338.752 446.545 338.992 446.041 339.376C445.561 339.736 445.321 340.3 445.321 341.068C445.321 341.884 445.537 342.484 445.969 342.868C446.425 343.228 446.989 343.408 447.661 343.408ZM458.97 354.1C458.49 354.1 458.082 353.992 457.746 353.776C457.41 353.584 457.242 353.152 457.242 352.48C457.242 352.048 457.314 351.664 457.458 351.328C457.602 351.016 457.866 350.86 458.25 350.86C458.706 350.86 459.198 350.74 459.726 350.5C460.278 350.284 460.806 349.924 461.31 349.42C461.838 348.94 462.282 348.328 462.642 347.584C463.026 346.84 463.29 345.964 463.434 344.956L457.35 330.988C457.254 330.82 457.206 330.652 457.206 330.484C457.206 330.172 457.338 329.884 457.602 329.62C457.89 329.332 458.226 329.104 458.61 328.936C458.994 328.768 459.354 328.684 459.69 328.684C459.93 328.684 460.158 328.744 460.374 328.864C460.614 328.96 460.77 329.128 460.842 329.368L465.378 341.068L469.302 329.368C469.374 329.128 469.518 328.96 469.734 328.864C469.95 328.744 470.166 328.684 470.382 328.684C470.67 328.684 471.006 328.768 471.39 328.936C471.798 329.104 472.146 329.332 472.434 329.62C472.746 329.884 472.902 330.196 472.902 330.556C472.902 330.748 472.866 330.892 472.794 330.988L467.394 345.064C467.01 346.096 466.614 347.14 466.206 348.196C465.798 349.276 465.294 350.26 464.694 351.148C464.118 352.036 463.362 352.744 462.426 353.272C461.514 353.824 460.362 354.1 458.97 354.1ZM486.161 346.288C484.841 346.288 483.713 345.904 482.777 345.136C481.841 344.344 481.373 343.144 481.373 341.536C481.373 340.168 481.733 339.112 482.453 338.368C483.173 337.624 484.157 337.108 485.405 336.82C486.677 336.532 488.141 336.388 489.797 336.388H491.381V335.74C491.381 335.116 491.261 334.516 491.021 333.94C490.805 333.34 490.433 332.848 489.905 332.464C489.401 332.056 488.705 331.852 487.817 331.852C486.929 331.852 486.245 331.936 485.765 332.104C485.285 332.272 484.901 332.452 484.613 332.644C484.325 332.836 484.061 332.932 483.821 332.932C483.389 332.932 483.053 332.728 482.813 332.32C482.573 331.888 482.453 331.456 482.453 331.024C482.453 330.592 482.729 330.208 483.281 329.872C483.857 329.512 484.565 329.236 485.405 329.044C486.245 328.828 487.073 328.72 487.889 328.72C489.665 328.72 491.081 329.056 492.137 329.728C493.193 330.376 493.961 331.228 494.441 332.284C494.921 333.34 495.161 334.48 495.161 335.704V344.74C495.161 345.076 494.981 345.376 494.621 345.64C494.285 345.88 493.853 346 493.325 346C492.845 346 492.437 345.88 492.101 345.64C491.765 345.376 491.597 345.076 491.597 344.74V343.48C490.973 344.2 490.217 344.848 489.329 345.424C488.441 346 487.385 346.288 486.161 346.288ZM487.529 343.408C488.129 343.408 488.717 343.228 489.293 342.868C489.893 342.508 490.385 342.052 490.769 341.5C491.177 340.948 491.381 340.384 491.381 339.808V338.476H490.481C489.569 338.476 488.705 338.536 487.889 338.656C487.073 338.752 486.413 338.992 485.909 339.376C485.429 339.736 485.189 340.3 485.189 341.068C485.189 341.884 485.405 342.484 485.837 342.868C486.293 343.228 486.857 343.408 487.529 343.408ZM508.055 354.1C507.527 354.1 507.083 353.968 506.723 353.704C506.387 353.44 506.219 353.152 506.219 352.84V330.16C506.219 329.8 506.387 329.512 506.723 329.296C507.083 329.056 507.515 328.936 508.019 328.936C508.523 328.936 508.943 329.056 509.279 329.296C509.615 329.512 509.783 329.8 509.783 330.16V331.456C510.191 330.76 510.803 330.136 511.619 329.584C512.459 329.008 513.455 328.72 514.607 328.72C515.807 328.72 516.899 329.044 517.883 329.692C518.867 330.316 519.647 331.168 520.223 332.248C520.799 333.304 521.087 334.492 521.087 335.812V339.124C521.087 340.372 520.787 341.548 520.187 342.652C519.611 343.732 518.843 344.608 517.883 345.28C516.923 345.952 515.879 346.288 514.751 346.288C513.671 346.288 512.699 346.012 511.835 345.46C510.971 344.884 510.359 344.224 509.999 343.48V352.84C509.999 353.152 509.807 353.44 509.423 353.704C509.063 353.968 508.607 354.1 508.055 354.1ZM513.635 342.94C514.283 342.94 514.883 342.76 515.435 342.4C515.987 342.04 516.431 341.56 516.767 340.96C517.127 340.36 517.307 339.748 517.307 339.124V335.812C517.307 335.188 517.139 334.588 516.803 334.012C516.467 333.436 516.011 332.968 515.435 332.608C514.883 332.248 514.259 332.068 513.563 332.068C512.987 332.068 512.423 332.224 511.871 332.536C511.319 332.824 510.863 333.244 510.503 333.796C510.167 334.348 509.999 335.02 509.999 335.812V339.952C509.999 340.24 510.155 340.624 510.467 341.104C510.779 341.56 511.211 341.98 511.763 342.364C512.315 342.748 512.939 342.94 513.635 342.94ZM528.102 346.288C526.782 346.288 525.654 345.904 524.718 345.136C523.782 344.344 523.314 343.144 523.314 341.536C523.314 340.168 523.674 339.112 524.394 338.368C525.114 337.624 526.098 337.108 527.346 336.82C528.618 336.532 530.082 336.388 531.738 336.388H533.322V335.74C533.322 335.116 533.202 334.516 532.962 333.94C532.746 333.34 532.374 332.848 531.846 332.464C531.342 332.056 530.646 331.852 529.758 331.852C528.87 331.852 528.186 331.936 527.706 332.104C527.226 332.272 526.842 332.452 526.554 332.644C526.266 332.836 526.002 332.932 525.762 332.932C525.33 332.932 524.994 332.728 524.754 332.32C524.514 331.888 524.394 331.456 524.394 331.024C524.394 330.592 524.67 330.208 525.222 329.872C525.798 329.512 526.506 329.236 527.346 329.044C528.186 328.828 529.014 328.72 529.83 328.72C531.606 328.72 533.022 329.056 534.078 329.728C535.134 330.376 535.902 331.228 536.382 332.284C536.862 333.34 537.102 334.48 537.102 335.704V344.74C537.102 345.076 536.922 345.376 536.562 345.64C536.226 345.88 535.794 346 535.266 346C534.786 346 534.378 345.88 534.042 345.64C533.706 345.376 533.538 345.076 533.538 344.74V343.48C532.914 344.2 532.158 344.848 531.27 345.424C530.382 346 529.326 346.288 528.102 346.288ZM529.47 343.408C530.07 343.408 530.658 343.228 531.234 342.868C531.834 342.508 532.326 342.052 532.71 341.5C533.118 340.948 533.322 340.384 533.322 339.808V338.476H532.422C531.51 338.476 530.646 338.536 529.83 338.656C529.014 338.752 528.354 338.992 527.85 339.376C527.37 339.736 527.13 340.3 527.13 341.068C527.13 341.884 527.346 342.484 527.778 342.868C528.234 343.228 528.798 343.408 529.47 343.408ZM542.754 346C542.226 346 541.782 345.868 541.422 345.604C541.086 345.34 540.918 345.052 540.918 344.74V330.16C540.918 329.8 541.086 329.512 541.422 329.296C541.782 329.056 542.226 328.936 542.754 328.936C543.234 328.936 543.642 329.056 543.978 329.296C544.314 329.512 544.482 329.8 544.482 330.16V331.744C544.746 331.24 545.094 330.76 545.526 330.304C545.982 329.848 546.51 329.476 547.11 329.188C547.71 328.876 548.358 328.72 549.054 328.72H550.206C550.59 328.72 550.926 328.888 551.214 329.224C551.502 329.536 551.646 329.92 551.646 330.376C551.646 330.832 551.502 331.228 551.214 331.564C550.926 331.9 550.59 332.068 550.206 332.068H549.054C548.334 332.068 547.638 332.284 546.966 332.716C546.294 333.148 545.742 333.76 545.31 334.552C544.902 335.32 544.698 336.256 544.698 337.36V344.74C544.698 345.052 544.506 345.34 544.122 345.604C543.762 345.868 543.306 346 542.754 346ZM560.048 346C558.008 346 556.448 345.556 555.368 344.668C554.288 343.756 553.748 342.328 553.748 340.384V322.348C553.748 321.988 553.94 321.7 554.324 321.484C554.732 321.244 555.164 321.124 555.62 321.124C556.076 321.124 556.508 321.244 556.916 321.484C557.324 321.7 557.528 321.988 557.528 322.348V328.936H561.92C562.256 328.936 562.508 329.08 562.676 329.368C562.868 329.656 562.964 329.98 562.964 330.34C562.964 330.7 562.868 331.024 562.676 331.312C562.508 331.6 562.256 331.744 561.92 331.744H557.528V340.384C557.528 341.248 557.708 341.86 558.068 342.22C558.452 342.58 559.112 342.76 560.048 342.76H561.272C561.824 342.76 562.232 342.928 562.496 343.264C562.784 343.576 562.928 343.948 562.928 344.38C562.928 344.788 562.784 345.16 562.496 345.496C562.232 345.832 561.824 346 561.272 346H560.048ZM574.641 324.652C574.041 324.652 573.525 324.448 573.093 324.04C572.661 323.632 572.445 323.176 572.445 322.672C572.445 322.12 572.661 321.652 573.093 321.268C573.525 320.884 574.041 320.692 574.641 320.692C575.241 320.692 575.745 320.884 576.153 321.268C576.585 321.652 576.801 322.12 576.801 322.672C576.801 323.176 576.585 323.632 576.153 324.04C575.745 324.448 575.241 324.652 574.641 324.652ZM574.641 346C574.089 346 573.633 345.868 573.273 345.604C572.937 345.34 572.769 345.052 572.769 344.74V330.16C572.769 329.8 572.937 329.512 573.273 329.296C573.633 329.056 574.089 328.936 574.641 328.936C575.169 328.936 575.613 329.056 575.973 329.296C576.357 329.512 576.549 329.8 576.549 330.16V344.74C576.549 345.052 576.357 345.34 575.973 345.604C575.613 345.868 575.169 346 574.641 346ZM582.34 346C581.788 346 581.332 345.868 580.972 345.604C580.636 345.34 580.468 345.052 580.468 344.74V330.16C580.468 329.8 580.636 329.512 580.972 329.296C581.332 329.056 581.788 328.936 582.34 328.936C582.796 328.936 583.192 329.056 583.528 329.296C583.864 329.512 584.032 329.8 584.032 330.16V331.456C584.392 330.76 584.98 330.136 585.796 329.584C586.636 329.008 587.656 328.72 588.856 328.72C589.984 328.72 591.016 329.044 591.952 329.692C592.912 330.316 593.68 331.168 594.256 332.248C594.832 333.304 595.12 334.492 595.12 335.812V344.74C595.12 345.148 594.916 345.46 594.508 345.676C594.124 345.892 593.692 346 593.212 346C592.78 346 592.36 345.892 591.952 345.676C591.544 345.46 591.34 345.148 591.34 344.74V335.812C591.34 335.188 591.172 334.588 590.836 334.012C590.524 333.436 590.092 332.968 589.54 332.608C588.988 332.248 588.376 332.068 587.704 332.068C587.128 332.068 586.576 332.224 586.048 332.536C585.52 332.824 585.088 333.244 584.752 333.796C584.416 334.348 584.248 335.02 584.248 335.812V344.74C584.248 345.052 584.056 345.34 583.672 345.604C583.312 345.868 582.868 346 582.34 346ZM87.7903 400.1C87.3103 400.1 86.9023 399.992 86.5663 399.776C86.2303 399.584 86.0623 399.152 86.0623 398.48C86.0623 398.048 86.1343 397.664 86.2783 397.328C86.4223 397.016 86.6863 396.86 87.0703 396.86C87.5263 396.86 88.0183 396.74 88.5463 396.5C89.0983 396.284 89.6263 395.924 90.1303 395.42C90.6583 394.94 91.1023 394.328 91.4623 393.584C91.8463 392.84 92.1103 391.964 92.2543 390.956L86.1703 376.988C86.0743 376.82 86.0263 376.652 86.0263 376.484C86.0263 376.172 86.1583 375.884 86.4223 375.62C86.7103 375.332 87.0463 375.104 87.4303 374.936C87.8143 374.768 88.1743 374.684 88.5103 374.684C88.7503 374.684 88.9783 374.744 89.1943 374.864C89.4343 374.96 89.5903 375.128 89.6623 375.368L94.1983 387.068L98.1223 375.368C98.1943 375.128 98.3383 374.96 98.5543 374.864C98.7703 374.744 98.9863 374.684 99.2023 374.684C99.4903 374.684 99.8263 374.768 100.21 374.936C100.618 375.104 100.966 375.332 101.254 375.62C101.566 375.884 101.722 376.196 101.722 376.556C101.722 376.748 101.686 376.892 101.614 376.988L96.2143 391.064C95.8303 392.096 95.4343 393.14 95.0263 394.196C94.6183 395.276 94.1143 396.26 93.5143 397.148C92.9383 398.036 92.1823 398.744 91.2463 399.272C90.3343 399.824 89.1823 400.1 87.7903 400.1ZM110.798 392.288C109.502 392.288 108.29 391.952 107.162 391.28C106.034 390.608 105.122 389.732 104.426 388.652C103.754 387.548 103.418 386.372 103.418 385.124V381.812C103.418 380.54 103.742 379.364 104.39 378.284C105.062 377.204 105.962 376.34 107.09 375.692C108.242 375.044 109.49 374.72 110.834 374.72C112.178 374.72 113.414 375.044 114.542 375.692C115.67 376.316 116.57 377.168 117.242 378.248C117.938 379.304 118.286 380.492 118.286 381.812V385.124C118.286 386.348 117.938 387.512 117.242 388.616C116.57 389.72 115.658 390.608 114.506 391.28C113.378 391.952 112.142 392.288 110.798 392.288ZM110.834 388.94C111.506 388.94 112.118 388.76 112.67 388.4C113.222 388.04 113.666 387.572 114.002 386.996C114.338 386.396 114.506 385.772 114.506 385.124V381.812C114.506 381.188 114.338 380.588 114.002 380.012C113.666 379.436 113.222 378.968 112.67 378.608C112.118 378.248 111.506 378.068 110.834 378.068C110.138 378.068 109.514 378.248 108.962 378.608C108.434 378.968 108.002 379.436 107.666 380.012C107.354 380.588 107.198 381.188 107.198 381.812V385.124C107.198 385.772 107.354 386.396 107.666 386.996C108.002 387.572 108.446 388.04 108.998 388.4C109.55 388.76 110.162 388.94 110.834 388.94ZM128.846 392.288C127.502 392.288 126.254 391.964 125.102 391.316C123.974 390.644 123.074 389.768 122.402 388.688C121.73 387.584 121.394 386.42 121.394 385.196V376.196C121.394 375.884 121.574 375.596 121.934 375.332C122.318 375.068 122.774 374.936 123.302 374.936C123.806 374.936 124.238 375.068 124.598 375.332C124.982 375.596 125.174 375.884 125.174 376.196V385.196C125.174 385.82 125.33 386.42 125.642 386.996C125.978 387.572 126.422 388.04 126.974 388.4C127.55 388.76 128.174 388.94 128.846 388.94C129.518 388.94 130.13 388.76 130.682 388.4C131.234 388.04 131.666 387.572 131.978 386.996C132.314 386.42 132.482 385.82 132.482 385.196V376.16C132.482 375.824 132.674 375.536 133.058 375.296C133.466 375.056 133.91 374.936 134.39 374.936C134.942 374.936 135.386 375.056 135.722 375.296C136.082 375.536 136.262 375.824 136.262 376.16V385.196C136.262 386.468 135.926 387.644 135.254 388.724C134.582 389.804 133.682 390.668 132.554 391.316C131.426 391.964 130.19 392.288 128.846 392.288ZM141.867 392C141.339 392 140.895 391.868 140.535 391.604C140.199 391.34 140.031 391.052 140.031 390.74V376.16C140.031 375.8 140.199 375.512 140.535 375.296C140.895 375.056 141.339 374.936 141.867 374.936C142.347 374.936 142.755 375.056 143.091 375.296C143.427 375.512 143.595 375.8 143.595 376.16V377.744C143.859 377.24 144.207 376.76 144.639 376.304C145.095 375.848 145.623 375.476 146.223 375.188C146.823 374.876 147.471 374.72 148.167 374.72H149.319C149.703 374.72 150.039 374.888 150.327 375.224C150.615 375.536 150.759 375.92 150.759 376.376C150.759 376.832 150.615 377.228 150.327 377.564C150.039 377.9 149.703 378.068 149.319 378.068H148.167C147.447 378.068 146.751 378.284 146.079 378.716C145.407 379.148 144.855 379.76 144.423 380.552C144.015 381.32 143.811 382.256 143.811 383.36V390.74C143.811 391.052 143.619 391.34 143.235 391.604C142.875 391.868 142.419 392 141.867 392ZM167.052 392.288C165.324 392.288 163.896 391.976 162.768 391.352C161.664 390.728 160.848 389.876 160.32 388.796C159.792 387.716 159.528 386.492 159.528 385.124V381.884C159.528 380.54 159.792 379.328 160.32 378.248C160.848 377.144 161.664 376.28 162.768 375.656C163.872 375.032 165.276 374.72 166.98 374.72C168.084 374.72 169.044 374.852 169.86 375.116C170.7 375.38 171.348 375.716 171.804 376.124C172.284 376.508 172.524 376.916 172.524 377.348C172.524 377.564 172.452 377.828 172.308 378.14C172.188 378.428 172.008 378.68 171.768 378.896C171.552 379.088 171.288 379.184 170.976 379.184C170.736 379.184 170.472 379.088 170.184 378.896C169.92 378.704 169.56 378.524 169.104 378.356C168.648 378.164 168.036 378.068 167.268 378.068C165.924 378.068 164.928 378.404 164.28 379.076C163.632 379.748 163.308 380.684 163.308 381.884V385.124C163.308 386.324 163.632 387.26 164.28 387.932C164.928 388.604 165.936 388.94 167.304 388.94C168.096 388.94 168.72 388.844 169.176 388.652C169.632 388.436 169.992 388.232 170.256 388.04C170.544 387.848 170.82 387.752 171.084 387.752C171.42 387.752 171.708 387.848 171.948 388.04C172.212 388.232 172.404 388.472 172.524 388.76C172.668 389.048 172.74 389.312 172.74 389.552C172.74 389.96 172.488 390.38 171.984 390.812C171.504 391.244 170.832 391.604 169.968 391.892C169.128 392.156 168.156 392.288 167.052 392.288ZM181.989 392.288C180.693 392.288 179.481 391.952 178.353 391.28C177.225 390.608 176.313 389.732 175.617 388.652C174.945 387.548 174.609 386.372 174.609 385.124V381.812C174.609 380.54 174.933 379.364 175.581 378.284C176.253 377.204 177.153 376.34 178.281 375.692C179.433 375.044 180.681 374.72 182.025 374.72C183.369 374.72 184.605 375.044 185.733 375.692C186.861 376.316 187.761 377.168 188.433 378.248C189.129 379.304 189.477 380.492 189.477 381.812V385.124C189.477 386.348 189.129 387.512 188.433 388.616C187.761 389.72 186.849 390.608 185.697 391.28C184.569 391.952 183.333 392.288 181.989 392.288ZM182.025 388.94C182.697 388.94 183.309 388.76 183.861 388.4C184.413 388.04 184.857 387.572 185.193 386.996C185.529 386.396 185.697 385.772 185.697 385.124V381.812C185.697 381.188 185.529 380.588 185.193 380.012C184.857 379.436 184.413 378.968 183.861 378.608C183.309 378.248 182.697 378.068 182.025 378.068C181.329 378.068 180.705 378.248 180.153 378.608C179.625 378.968 179.193 379.436 178.857 380.012C178.545 380.588 178.389 381.188 178.389 381.812V385.124C178.389 385.772 178.545 386.396 178.857 386.996C179.193 387.572 179.637 388.04 180.189 388.4C180.741 388.76 181.353 388.94 182.025 388.94ZM194.637 392C194.085 392 193.629 391.868 193.269 391.604C192.933 391.34 192.765 391.052 192.765 390.74V376.16C192.765 375.8 192.933 375.512 193.269 375.296C193.629 375.056 194.085 374.936 194.637 374.936C195.093 374.936 195.489 375.056 195.825 375.296C196.161 375.512 196.329 375.8 196.329 376.16V377.456C196.737 376.76 197.337 376.136 198.129 375.584C198.921 375.008 199.917 374.72 201.117 374.72C202.197 374.72 203.145 375.056 203.961 375.728C204.801 376.4 205.425 377.264 205.833 378.32C206.457 377.096 207.261 376.196 208.245 375.62C209.229 375.02 210.237 374.72 211.269 374.72C212.349 374.72 213.357 374.996 214.293 375.548C215.253 376.1 216.033 376.904 216.633 377.96C217.233 379.016 217.533 380.3 217.533 381.812V390.74C217.533 391.052 217.341 391.34 216.957 391.604C216.597 391.868 216.153 392 215.625 392C215.121 392 214.677 391.868 214.293 391.604C213.933 391.34 213.753 391.052 213.753 390.74V381.812C213.753 380.996 213.585 380.312 213.249 379.76C212.937 379.184 212.517 378.752 211.989 378.464C211.485 378.176 210.957 378.032 210.405 378.032C209.829 378.032 209.289 378.188 208.785 378.5C208.281 378.788 207.861 379.208 207.525 379.76C207.189 380.288 207.021 380.948 207.021 381.74V390.776C207.021 391.208 206.817 391.52 206.409 391.712C206.025 391.904 205.593 392 205.113 392C204.681 392 204.261 391.904 203.853 391.712C203.445 391.52 203.241 391.208 203.241 390.776V381.776C203.241 381.008 203.085 380.348 202.773 379.796C202.461 379.244 202.053 378.824 201.549 378.536C201.045 378.224 200.493 378.068 199.893 378.068C199.341 378.068 198.801 378.212 198.273 378.5C197.769 378.788 197.349 379.208 197.013 379.76C196.701 380.312 196.545 380.996 196.545 381.812V390.74C196.545 391.052 196.353 391.34 195.969 391.604C195.609 391.868 195.165 392 194.637 392ZM223.219 392C222.667 392 222.211 391.868 221.851 391.604C221.515 391.34 221.347 391.052 221.347 390.74V376.16C221.347 375.8 221.515 375.512 221.851 375.296C222.211 375.056 222.667 374.936 223.219 374.936C223.675 374.936 224.071 375.056 224.407 375.296C224.743 375.512 224.911 375.8 224.911 376.16V377.456C225.319 376.76 225.919 376.136 226.711 375.584C227.503 375.008 228.499 374.72 229.699 374.72C230.779 374.72 231.727 375.056 232.543 375.728C233.383 376.4 234.007 377.264 234.415 378.32C235.039 377.096 235.843 376.196 236.827 375.62C237.811 375.02 238.819 374.72 239.851 374.72C240.931 374.72 241.939 374.996 242.875 375.548C243.835 376.1 244.615 376.904 245.215 377.96C245.815 379.016 246.115 380.3 246.115 381.812V390.74C246.115 391.052 245.923 391.34 245.539 391.604C245.179 391.868 244.735 392 244.207 392C243.703 392 243.259 391.868 242.875 391.604C242.515 391.34 242.335 391.052 242.335 390.74V381.812C242.335 380.996 242.167 380.312 241.831 379.76C241.519 379.184 241.099 378.752 240.571 378.464C240.067 378.176 239.539 378.032 238.987 378.032C238.411 378.032 237.871 378.188 237.367 378.5C236.863 378.788 236.443 379.208 236.107 379.76C235.771 380.288 235.603 380.948 235.603 381.74V390.776C235.603 391.208 235.399 391.52 234.991 391.712C234.607 391.904 234.175 392 233.695 392C233.263 392 232.843 391.904 232.435 391.712C232.027 391.52 231.823 391.208 231.823 390.776V381.776C231.823 381.008 231.667 380.348 231.355 379.796C231.043 379.244 230.635 378.824 230.131 378.536C229.627 378.224 229.075 378.068 228.475 378.068C227.923 378.068 227.383 378.212 226.855 378.5C226.351 378.788 225.931 379.208 225.595 379.76C225.283 380.312 225.127 380.996 225.127 381.812V390.74C225.127 391.052 224.935 391.34 224.551 391.604C224.191 391.868 223.747 392 223.219 392ZM257.201 392.288C255.857 392.288 254.609 391.964 253.457 391.316C252.329 390.644 251.429 389.768 250.757 388.688C250.085 387.584 249.749 386.42 249.749 385.196V376.196C249.749 375.884 249.929 375.596 250.289 375.332C250.673 375.068 251.129 374.936 251.657 374.936C252.161 374.936 252.593 375.068 252.953 375.332C253.337 375.596 253.529 375.884 253.529 376.196V385.196C253.529 385.82 253.685 386.42 253.997 386.996C254.333 387.572 254.777 388.04 255.329 388.4C255.905 388.76 256.529 388.94 257.201 388.94C257.873 388.94 258.485 388.76 259.037 388.4C259.589 388.04 260.021 387.572 260.333 386.996C260.669 386.42 260.837 385.82 260.837 385.196V376.16C260.837 375.824 261.029 375.536 261.413 375.296C261.821 375.056 262.265 374.936 262.745 374.936C263.297 374.936 263.741 375.056 264.077 375.296C264.437 375.536 264.617 375.824 264.617 376.16V385.196C264.617 386.468 264.281 387.644 263.609 388.724C262.937 389.804 262.037 390.668 260.909 391.316C259.781 391.964 258.545 392.288 257.201 392.288ZM270.258 392C269.706 392 269.25 391.868 268.89 391.604C268.554 391.34 268.386 391.052 268.386 390.74V376.16C268.386 375.8 268.554 375.512 268.89 375.296C269.25 375.056 269.706 374.936 270.258 374.936C270.714 374.936 271.11 375.056 271.446 375.296C271.782 375.512 271.95 375.8 271.95 376.16V377.456C272.31 376.76 272.898 376.136 273.714 375.584C274.554 375.008 275.574 374.72 276.774 374.72C277.902 374.72 278.934 375.044 279.87 375.692C280.83 376.316 281.598 377.168 282.174 378.248C282.75 379.304 283.038 380.492 283.038 381.812V390.74C283.038 391.148 282.834 391.46 282.426 391.676C282.042 391.892 281.61 392 281.13 392C280.698 392 280.278 391.892 279.87 391.676C279.462 391.46 279.258 391.148 279.258 390.74V381.812C279.258 381.188 279.09 380.588 278.754 380.012C278.442 379.436 278.01 378.968 277.458 378.608C276.906 378.248 276.294 378.068 275.622 378.068C275.046 378.068 274.494 378.224 273.966 378.536C273.438 378.824 273.006 379.244 272.67 379.796C272.334 380.348 272.166 381.02 272.166 381.812V390.74C272.166 391.052 271.974 391.34 271.59 391.604C271.23 391.868 270.786 392 270.258 392ZM288.68 370.652C288.08 370.652 287.564 370.448 287.132 370.04C286.7 369.632 286.484 369.176 286.484 368.672C286.484 368.12 286.7 367.652 287.132 367.268C287.564 366.884 288.08 366.692 288.68 366.692C289.28 366.692 289.784 366.884 290.192 367.268C290.624 367.652 290.84 368.12 290.84 368.672C290.84 369.176 290.624 369.632 290.192 370.04C289.784 370.448 289.28 370.652 288.68 370.652ZM288.68 392C288.128 392 287.672 391.868 287.312 391.604C286.976 391.34 286.808 391.052 286.808 390.74V376.16C286.808 375.8 286.976 375.512 287.312 375.296C287.672 375.056 288.128 374.936 288.68 374.936C289.208 374.936 289.652 375.056 290.012 375.296C290.396 375.512 290.588 375.8 290.588 376.16V390.74C290.588 391.052 290.396 391.34 290.012 391.604C289.652 391.868 289.208 392 288.68 392ZM300.735 392C298.695 392 297.135 391.556 296.055 390.668C294.975 389.756 294.435 388.328 294.435 386.384V368.348C294.435 367.988 294.627 367.7 295.011 367.484C295.419 367.244 295.851 367.124 296.307 367.124C296.763 367.124 297.195 367.244 297.603 367.484C298.011 367.7 298.215 367.988 298.215 368.348V374.936H302.607C302.943 374.936 303.195 375.08 303.363 375.368C303.555 375.656 303.651 375.98 303.651 376.34C303.651 376.7 303.555 377.024 303.363 377.312C303.195 377.6 302.943 377.744 302.607 377.744H298.215V386.384C298.215 387.248 298.395 387.86 298.755 388.22C299.139 388.58 299.799 388.76 300.735 388.76H301.959C302.511 388.76 302.919 388.928 303.183 389.264C303.471 389.576 303.615 389.948 303.615 390.38C303.615 390.788 303.471 391.16 303.183 391.496C302.919 391.832 302.511 392 301.959 392H300.735ZM306.322 400.1C305.842 400.1 305.434 399.992 305.098 399.776C304.762 399.584 304.594 399.152 304.594 398.48C304.594 398.048 304.666 397.664 304.81 397.328C304.954 397.016 305.218 396.86 305.602 396.86C306.058 396.86 306.55 396.74 307.078 396.5C307.63 396.284 308.158 395.924 308.662 395.42C309.19 394.94 309.634 394.328 309.994 393.584C310.378 392.84 310.642 391.964 310.786 390.956L304.702 376.988C304.606 376.82 304.558 376.652 304.558 376.484C304.558 376.172 304.69 375.884 304.954 375.62C305.242 375.332 305.578 375.104 305.962 374.936C306.346 374.768 306.706 374.684 307.042 374.684C307.282 374.684 307.51 374.744 307.726 374.864C307.966 374.96 308.122 375.128 308.194 375.368L312.73 387.068L316.654 375.368C316.726 375.128 316.87 374.96 317.086 374.864C317.302 374.744 317.518 374.684 317.734 374.684C318.022 374.684 318.358 374.768 318.742 374.936C319.15 375.104 319.498 375.332 319.786 375.62C320.098 375.884 320.254 376.196 320.254 376.556C320.254 376.748 320.218 376.892 320.146 376.988L314.746 391.064C314.362 392.096 313.966 393.14 313.558 394.196C313.15 395.276 312.646 396.26 312.046 397.148C311.47 398.036 310.714 398.744 309.778 399.272C308.866 399.824 307.714 400.1 306.322 400.1ZM331.676 370.652C331.076 370.652 330.56 370.448 330.128 370.04C329.696 369.632 329.48 369.176 329.48 368.672C329.48 368.12 329.696 367.652 330.128 367.268C330.56 366.884 331.076 366.692 331.676 366.692C332.276 366.692 332.78 366.884 333.188 367.268C333.62 367.652 333.836 368.12 333.836 368.672C333.836 369.176 333.62 369.632 333.188 370.04C332.78 370.448 332.276 370.652 331.676 370.652ZM331.676 392C331.124 392 330.668 391.868 330.308 391.604C329.972 391.34 329.804 391.052 329.804 390.74V376.16C329.804 375.8 329.972 375.512 330.308 375.296C330.668 375.056 331.124 374.936 331.676 374.936C332.204 374.936 332.648 375.056 333.008 375.296C333.392 375.512 333.584 375.8 333.584 376.16V390.74C333.584 391.052 333.392 391.34 333.008 391.604C332.648 391.868 332.204 392 331.676 392ZM339.375 392C338.823 392 338.367 391.868 338.007 391.604C337.671 391.34 337.503 391.052 337.503 390.74V376.16C337.503 375.8 337.671 375.512 338.007 375.296C338.367 375.056 338.823 374.936 339.375 374.936C339.831 374.936 340.227 375.056 340.563 375.296C340.899 375.512 341.067 375.8 341.067 376.16V377.456C341.427 376.76 342.015 376.136 342.831 375.584C343.671 375.008 344.691 374.72 345.891 374.72C347.019 374.72 348.051 375.044 348.987 375.692C349.947 376.316 350.715 377.168 351.291 378.248C351.867 379.304 352.155 380.492 352.155 381.812V390.74C352.155 391.148 351.951 391.46 351.543 391.676C351.159 391.892 350.727 392 350.247 392C349.815 392 349.395 391.892 348.987 391.676C348.579 391.46 348.375 391.148 348.375 390.74V381.812C348.375 381.188 348.207 380.588 347.871 380.012C347.559 379.436 347.127 378.968 346.575 378.608C346.023 378.248 345.411 378.068 344.739 378.068C344.163 378.068 343.611 378.224 343.083 378.536C342.555 378.824 342.123 379.244 341.787 379.796C341.451 380.348 341.283 381.02 341.283 381.812V390.74C341.283 391.052 341.091 391.34 340.707 391.604C340.347 391.868 339.903 392 339.375 392ZM368.712 392.36C368.376 392.36 368.076 392.3 367.812 392.18C367.548 392.06 367.356 391.844 367.236 391.532L361.656 376.988C361.608 376.868 361.56 376.76 361.512 376.664C361.488 376.544 361.476 376.448 361.476 376.376C361.476 376.064 361.608 375.8 361.872 375.584C362.136 375.344 362.448 375.152 362.808 375.008C363.192 374.864 363.552 374.792 363.888 374.792C364.152 374.792 364.392 374.852 364.608 374.972C364.824 375.068 364.968 375.236 365.04 375.476L369.036 386.672L372.096 376.736C372.216 376.376 372.396 376.148 372.636 376.052C372.876 375.956 373.14 375.908 373.428 375.908C373.74 375.908 374.016 375.956 374.256 376.052C374.496 376.148 374.676 376.376 374.796 376.736L377.784 386.744L381.816 375.476C381.96 375.02 382.332 374.792 382.932 374.792C383.268 374.792 383.616 374.864 383.976 375.008C384.36 375.128 384.684 375.308 384.948 375.548C385.212 375.788 385.344 376.076 385.344 376.412C385.344 376.484 385.332 376.58 385.308 376.7C385.284 376.82 385.248 376.916 385.2 376.988L379.62 391.604C379.524 391.892 379.332 392.084 379.044 392.18C378.78 392.3 378.48 392.36 378.144 392.36C377.76 392.36 377.424 392.3 377.136 392.18C376.872 392.06 376.692 391.88 376.596 391.64L373.428 382.352L370.332 391.532C370.236 391.82 370.032 392.024 369.72 392.144C369.432 392.288 369.096 392.36 368.712 392.36ZM394.333 392.288C393.037 392.288 391.825 391.952 390.697 391.28C389.569 390.608 388.657 389.732 387.961 388.652C387.289 387.548 386.953 386.372 386.953 385.124V381.812C386.953 380.54 387.277 379.364 387.925 378.284C388.597 377.204 389.497 376.34 390.625 375.692C391.777 375.044 393.025 374.72 394.369 374.72C395.713 374.72 396.949 375.044 398.077 375.692C399.205 376.316 400.105 377.168 400.777 378.248C401.473 379.304 401.821 380.492 401.821 381.812V385.124C401.821 386.348 401.473 387.512 400.777 388.616C400.105 389.72 399.193 390.608 398.041 391.28C396.913 391.952 395.677 392.288 394.333 392.288ZM394.369 388.94C395.041 388.94 395.653 388.76 396.205 388.4C396.757 388.04 397.201 387.572 397.537 386.996C397.873 386.396 398.041 385.772 398.041 385.124V381.812C398.041 381.188 397.873 380.588 397.537 380.012C397.201 379.436 396.757 378.968 396.205 378.608C395.653 378.248 395.041 378.068 394.369 378.068C393.673 378.068 393.049 378.248 392.497 378.608C391.969 378.968 391.537 379.436 391.201 380.012C390.889 380.588 390.733 381.188 390.733 381.812V385.124C390.733 385.772 390.889 386.396 391.201 386.996C391.537 387.572 391.981 388.04 392.533 388.4C393.085 388.76 393.697 388.94 394.369 388.94ZM406.945 392C406.417 392 405.973 391.868 405.613 391.604C405.277 391.34 405.109 391.052 405.109 390.74V376.16C405.109 375.8 405.277 375.512 405.613 375.296C405.973 375.056 406.417 374.936 406.945 374.936C407.425 374.936 407.833 375.056 408.169 375.296C408.505 375.512 408.673 375.8 408.673 376.16V377.744C408.937 377.24 409.285 376.76 409.717 376.304C410.173 375.848 410.701 375.476 411.301 375.188C411.901 374.876 412.549 374.72 413.245 374.72H414.397C414.781 374.72 415.117 374.888 415.405 375.224C415.693 375.536 415.837 375.92 415.837 376.376C415.837 376.832 415.693 377.228 415.405 377.564C415.117 377.9 414.781 378.068 414.397 378.068H413.245C412.525 378.068 411.829 378.284 411.157 378.716C410.485 379.148 409.933 379.76 409.501 380.552C409.093 381.32 408.889 382.256 408.889 383.36V390.74C408.889 391.052 408.697 391.34 408.313 391.604C407.953 391.868 407.497 392 406.945 392ZM419.883 392C419.355 392 418.911 391.868 418.551 391.604C418.215 391.34 418.047 391.052 418.047 390.74V366.008C418.047 365.648 418.215 365.36 418.551 365.144C418.911 364.904 419.355 364.784 419.883 364.784C420.435 364.784 420.891 364.904 421.251 365.144C421.635 365.36 421.827 365.648 421.827 366.008V382.028L429.351 375.116C429.567 374.9 429.831 374.792 430.143 374.792C430.431 374.792 430.707 374.888 430.971 375.08C431.259 375.248 431.499 375.476 431.691 375.764C431.883 376.028 431.979 376.304 431.979 376.592C431.979 376.736 431.955 376.88 431.907 377.024C431.859 377.144 431.775 377.264 431.655 377.384L427.011 381.524L432.663 389.66C432.807 389.9 432.879 390.116 432.879 390.308C432.879 390.62 432.759 390.92 432.519 391.208C432.303 391.496 432.027 391.736 431.691 391.928C431.379 392.12 431.067 392.216 430.755 392.216C430.323 392.216 429.987 392.036 429.747 391.676L424.455 383.864L421.827 386.24V390.74C421.827 391.052 421.635 391.34 421.251 391.604C420.891 391.868 420.435 392 419.883 392ZM437.11 370.652C436.51 370.652 435.994 370.448 435.562 370.04C435.13 369.632 434.914 369.176 434.914 368.672C434.914 368.12 435.13 367.652 435.562 367.268C435.994 366.884 436.51 366.692 437.11 366.692C437.71 366.692 438.214 366.884 438.622 367.268C439.054 367.652 439.27 368.12 439.27 368.672C439.27 369.176 439.054 369.632 438.622 370.04C438.214 370.448 437.71 370.652 437.11 370.652ZM437.11 392C436.558 392 436.102 391.868 435.742 391.604C435.406 391.34 435.238 391.052 435.238 390.74V376.16C435.238 375.8 435.406 375.512 435.742 375.296C436.102 375.056 436.558 374.936 437.11 374.936C437.638 374.936 438.082 375.056 438.442 375.296C438.826 375.512 439.018 375.8 439.018 376.16V390.74C439.018 391.052 438.826 391.34 438.442 391.604C438.082 391.868 437.638 392 437.11 392ZM444.809 392C444.257 392 443.801 391.868 443.441 391.604C443.105 391.34 442.937 391.052 442.937 390.74V376.16C442.937 375.8 443.105 375.512 443.441 375.296C443.801 375.056 444.257 374.936 444.809 374.936C445.265 374.936 445.661 375.056 445.997 375.296C446.333 375.512 446.501 375.8 446.501 376.16V377.456C446.861 376.76 447.449 376.136 448.265 375.584C449.105 375.008 450.125 374.72 451.325 374.72C452.453 374.72 453.485 375.044 454.421 375.692C455.381 376.316 456.149 377.168 456.725 378.248C457.301 379.304 457.589 380.492 457.589 381.812V390.74C457.589 391.148 457.385 391.46 456.977 391.676C456.593 391.892 456.161 392 455.681 392C455.249 392 454.829 391.892 454.421 391.676C454.013 391.46 453.809 391.148 453.809 390.74V381.812C453.809 381.188 453.641 380.588 453.305 380.012C452.993 379.436 452.561 378.968 452.009 378.608C451.457 378.248 450.845 378.068 450.173 378.068C449.597 378.068 449.045 378.224 448.517 378.536C447.989 378.824 447.557 379.244 447.221 379.796C446.885 380.348 446.717 381.02 446.717 381.812V390.74C446.717 391.052 446.525 391.34 446.141 391.604C445.781 391.868 445.337 392 444.809 392ZM467.803 400.1C466.411 400.1 465.127 399.896 463.951 399.488C462.775 399.104 461.839 398.54 461.143 397.796C460.447 397.052 460.099 396.164 460.099 395.132C460.099 394.172 460.375 393.368 460.927 392.72C461.479 392.096 462.127 391.616 462.871 391.28C462.391 391.064 461.995 390.776 461.683 390.416C461.371 390.056 461.215 389.552 461.215 388.904C461.215 388.232 461.383 387.692 461.719 387.284C462.055 386.876 462.487 386.504 463.015 386.168C462.343 385.64 461.815 384.992 461.431 384.224C461.071 383.432 460.891 382.568 460.891 381.632V380.624C460.891 379.472 461.167 378.452 461.719 377.564C462.271 376.676 463.051 375.98 464.059 375.476C465.091 374.972 466.267 374.72 467.587 374.72C468.403 374.72 469.159 374.828 469.855 375.044C470.575 375.26 471.211 375.56 471.763 375.944C472.147 375.056 472.531 374.432 472.915 374.072C473.323 373.712 473.707 373.532 474.067 373.532C474.571 373.532 474.955 373.676 475.219 373.964C475.483 374.252 475.615 374.54 475.615 374.828C475.615 375.02 475.555 375.2 475.435 375.368C475.339 375.512 475.195 375.632 475.003 375.728C474.763 375.848 474.475 376.016 474.139 376.232C473.827 376.424 473.515 376.736 473.203 377.168C473.611 377.624 473.911 378.152 474.103 378.752C474.295 379.352 474.391 379.976 474.391 380.624V381.632C474.391 382.76 474.103 383.78 473.527 384.692C472.951 385.604 472.147 386.324 471.115 386.852C470.083 387.356 468.907 387.608 467.587 387.608C466.651 387.608 465.823 387.464 465.103 387.176C464.911 387.296 464.743 387.44 464.599 387.608C464.479 387.752 464.419 387.944 464.419 388.184C464.419 388.616 464.683 388.928 465.211 389.12C465.739 389.312 466.411 389.456 467.227 389.552C468.067 389.648 468.955 389.768 469.891 389.912C470.827 390.056 471.703 390.296 472.519 390.632C473.359 390.944 474.043 391.412 474.571 392.036C475.099 392.684 475.363 393.56 475.363 394.664C475.363 395.912 475.015 396.932 474.319 397.724C473.623 398.54 472.699 399.14 471.547 399.524C470.419 399.908 469.171 400.1 467.803 400.1ZM467.731 397.58C468.907 397.58 469.855 397.316 470.575 396.788C471.319 396.284 471.691 395.612 471.691 394.772C471.691 394.172 471.511 393.704 471.151 393.368C470.791 393.032 470.323 392.78 469.747 392.612C469.171 392.444 468.559 392.324 467.911 392.252C467.287 392.18 466.687 392.108 466.111 392.036C465.439 392.276 464.863 392.612 464.383 393.044C463.927 393.5 463.699 394.064 463.699 394.736C463.699 395.624 464.071 396.32 464.815 396.824C465.583 397.328 466.555 397.58 467.731 397.58ZM467.659 385.196C468.619 385.196 469.363 384.86 469.891 384.188C470.443 383.516 470.719 382.664 470.719 381.632V380.624C470.719 379.64 470.443 378.812 469.891 378.14C469.363 377.468 468.607 377.132 467.623 377.132C466.639 377.132 465.883 377.468 465.355 378.14C464.827 378.812 464.563 379.64 464.563 380.624V381.596C464.563 382.604 464.827 383.456 465.355 384.152C465.883 384.848 466.651 385.196 467.659 385.196ZM491.528 392C489.488 392 487.928 391.556 486.848 390.668C485.768 389.756 485.228 388.328 485.228 386.384V368.348C485.228 367.988 485.42 367.7 485.804 367.484C486.212 367.244 486.644 367.124 487.1 367.124C487.556 367.124 487.988 367.244 488.396 367.484C488.804 367.7 489.008 367.988 489.008 368.348V374.936H493.4C493.736 374.936 493.988 375.08 494.156 375.368C494.348 375.656 494.444 375.98 494.444 376.34C494.444 376.7 494.348 377.024 494.156 377.312C493.988 377.6 493.736 377.744 493.4 377.744H489.008V386.384C489.008 387.248 489.188 387.86 489.548 388.22C489.932 388.58 490.592 388.76 491.528 388.76H492.752C493.304 388.76 493.712 388.928 493.976 389.264C494.264 389.576 494.408 389.948 494.408 390.38C494.408 390.788 494.264 391.16 493.976 391.496C493.712 391.832 493.304 392 492.752 392H491.528ZM503.528 392.288C502.232 392.288 501.02 391.952 499.892 391.28C498.764 390.608 497.852 389.732 497.156 388.652C496.484 387.548 496.148 386.372 496.148 385.124V381.812C496.148 380.54 496.472 379.364 497.12 378.284C497.792 377.204 498.692 376.34 499.82 375.692C500.972 375.044 502.22 374.72 503.564 374.72C504.908 374.72 506.144 375.044 507.272 375.692C508.4 376.316 509.3 377.168 509.972 378.248C510.668 379.304 511.016 380.492 511.016 381.812V385.124C511.016 386.348 510.668 387.512 509.972 388.616C509.3 389.72 508.388 390.608 507.236 391.28C506.108 391.952 504.872 392.288 503.528 392.288ZM503.564 388.94C504.236 388.94 504.848 388.76 505.4 388.4C505.952 388.04 506.396 387.572 506.732 386.996C507.068 386.396 507.236 385.772 507.236 385.124V381.812C507.236 381.188 507.068 380.588 506.732 380.012C506.396 379.436 505.952 378.968 505.4 378.608C504.848 378.248 504.236 378.068 503.564 378.068C502.868 378.068 502.244 378.248 501.692 378.608C501.164 378.968 500.732 379.436 500.396 380.012C500.084 380.588 499.928 381.188 499.928 381.812V385.124C499.928 385.772 500.084 386.396 500.396 386.996C500.732 387.572 501.176 388.04 501.728 388.4C502.28 388.76 502.892 388.94 503.564 388.94ZM520.748 400.1C519.356 400.1 518.072 399.896 516.896 399.488C515.72 399.104 514.784 398.54 514.088 397.796C513.392 397.052 513.044 396.164 513.044 395.132C513.044 394.172 513.32 393.368 513.872 392.72C514.424 392.096 515.072 391.616 515.816 391.28C515.336 391.064 514.94 390.776 514.628 390.416C514.316 390.056 514.16 389.552 514.16 388.904C514.16 388.232 514.328 387.692 514.664 387.284C515 386.876 515.432 386.504 515.96 386.168C515.288 385.64 514.76 384.992 514.376 384.224C514.016 383.432 513.836 382.568 513.836 381.632V380.624C513.836 379.472 514.112 378.452 514.664 377.564C515.216 376.676 515.996 375.98 517.004 375.476C518.036 374.972 519.212 374.72 520.532 374.72C521.348 374.72 522.104 374.828 522.8 375.044C523.52 375.26 524.156 375.56 524.708 375.944C525.092 375.056 525.476 374.432 525.86 374.072C526.268 373.712 526.652 373.532 527.012 373.532C527.516 373.532 527.9 373.676 528.164 373.964C528.428 374.252 528.56 374.54 528.56 374.828C528.56 375.02 528.5 375.2 528.38 375.368C528.284 375.512 528.14 375.632 527.948 375.728C527.708 375.848 527.42 376.016 527.084 376.232C526.772 376.424 526.46 376.736 526.148 377.168C526.556 377.624 526.856 378.152 527.048 378.752C527.24 379.352 527.336 379.976 527.336 380.624V381.632C527.336 382.76 527.048 383.78 526.472 384.692C525.896 385.604 525.092 386.324 524.06 386.852C523.028 387.356 521.852 387.608 520.532 387.608C519.596 387.608 518.768 387.464 518.048 387.176C517.856 387.296 517.688 387.44 517.544 387.608C517.424 387.752 517.364 387.944 517.364 388.184C517.364 388.616 517.628 388.928 518.156 389.12C518.684 389.312 519.356 389.456 520.172 389.552C521.012 389.648 521.9 389.768 522.836 389.912C523.772 390.056 524.648 390.296 525.464 390.632C526.304 390.944 526.988 391.412 527.516 392.036C528.044 392.684 528.308 393.56 528.308 394.664C528.308 395.912 527.96 396.932 527.264 397.724C526.568 398.54 525.644 399.14 524.492 399.524C523.364 399.908 522.116 400.1 520.748 400.1ZM520.676 397.58C521.852 397.58 522.8 397.316 523.52 396.788C524.264 396.284 524.636 395.612 524.636 394.772C524.636 394.172 524.456 393.704 524.096 393.368C523.736 393.032 523.268 392.78 522.692 392.612C522.116 392.444 521.504 392.324 520.856 392.252C520.232 392.18 519.632 392.108 519.056 392.036C518.384 392.276 517.808 392.612 517.328 393.044C516.872 393.5 516.644 394.064 516.644 394.736C516.644 395.624 517.016 396.32 517.76 396.824C518.528 397.328 519.5 397.58 520.676 397.58ZM520.604 385.196C521.564 385.196 522.308 384.86 522.836 384.188C523.388 383.516 523.664 382.664 523.664 381.632V380.624C523.664 379.64 523.388 378.812 522.836 378.14C522.308 377.468 521.552 377.132 520.568 377.132C519.584 377.132 518.828 377.468 518.3 378.14C517.772 378.812 517.508 379.64 517.508 380.624V381.596C517.508 382.604 517.772 383.456 518.3 384.152C518.828 384.848 519.596 385.196 520.604 385.196ZM538.672 392.288C537.04 392.288 535.6 391.988 534.352 391.388C533.104 390.788 532.12 389.96 531.4 388.904C530.68 387.824 530.32 386.564 530.32 385.124V381.704C530.32 380.432 530.656 379.268 531.328 378.212C532.024 377.156 532.936 376.316 534.064 375.692C535.192 375.044 536.44 374.72 537.808 374.72C539.104 374.72 540.292 375.008 541.372 375.584C542.452 376.136 543.316 376.916 543.964 377.924C544.636 378.932 544.972 380.084 544.972 381.38C544.972 382.388 544.816 383.108 544.504 383.54C544.192 383.972 543.784 384.236 543.28 384.332C542.776 384.428 542.248 384.476 541.696 384.476H534.1V385.304C534.1 386.504 534.532 387.464 535.396 388.184C536.284 388.88 537.412 389.228 538.78 389.228C539.62 389.228 540.304 389.108 540.832 388.868C541.36 388.628 541.804 388.4 542.164 388.184C542.524 387.968 542.86 387.86 543.172 387.86C543.484 387.86 543.748 387.956 543.964 388.148C544.18 388.34 544.348 388.568 544.468 388.832C544.588 389.096 544.648 389.336 544.648 389.552C544.648 389.912 544.396 390.308 543.892 390.74C543.412 391.172 542.728 391.544 541.84 391.856C540.952 392.144 539.896 392.288 538.672 392.288ZM534.1 382.136H540.076C540.604 382.136 540.952 382.064 541.12 381.92C541.312 381.776 541.408 381.488 541.408 381.056C541.408 380.432 541.252 379.856 540.94 379.328C540.628 378.776 540.196 378.356 539.644 378.068C539.092 377.756 538.468 377.6 537.772 377.6C537.1 377.6 536.488 377.744 535.936 378.032C535.384 378.32 534.94 378.716 534.604 379.22C534.268 379.724 534.1 380.312 534.1 380.984V382.136ZM554.282 392C552.242 392 550.682 391.556 549.602 390.668C548.522 389.756 547.982 388.328 547.982 386.384V368.348C547.982 367.988 548.174 367.7 548.558 367.484C548.966 367.244 549.398 367.124 549.854 367.124C550.31 367.124 550.742 367.244 551.15 367.484C551.558 367.7 551.762 367.988 551.762 368.348V374.936H556.154C556.49 374.936 556.742 375.08 556.91 375.368C557.102 375.656 557.198 375.98 557.198 376.34C557.198 376.7 557.102 377.024 556.91 377.312C556.742 377.6 556.49 377.744 556.154 377.744H551.762V386.384C551.762 387.248 551.942 387.86 552.302 388.22C552.686 388.58 553.346 388.76 554.282 388.76H555.506C556.058 388.76 556.466 388.928 556.73 389.264C557.018 389.576 557.162 389.948 557.162 390.38C557.162 390.788 557.018 391.16 556.73 391.496C556.466 391.832 556.058 392 555.506 392H554.282ZM561.704 392C561.152 392 560.696 391.868 560.336 391.604C560 391.34 559.832 391.052 559.832 390.74V366.008C559.832 365.648 560 365.36 560.336 365.144C560.696 364.904 561.152 364.784 561.704 364.784C562.232 364.784 562.676 364.904 563.036 365.144C563.42 365.36 563.612 365.648 563.612 366.008V377.456C563.972 376.76 564.536 376.136 565.304 375.584C566.096 375.008 567.068 374.72 568.22 374.72C569.348 374.72 570.38 375.044 571.316 375.692C572.276 376.316 573.044 377.168 573.62 378.248C574.196 379.304 574.484 380.492 574.484 381.812V390.74C574.484 391.148 574.28 391.46 573.872 391.676C573.488 391.892 573.056 392 572.576 392C572.144 392 571.724 391.892 571.316 391.676C570.908 391.46 570.704 391.148 570.704 390.74V381.812C570.704 381.188 570.536 380.588 570.2 380.012C569.864 379.436 569.42 378.968 568.868 378.608C568.34 378.248 567.74 378.068 567.068 378.068C566.492 378.068 565.94 378.224 565.412 378.536C564.884 378.824 564.452 379.244 564.116 379.796C563.78 380.348 563.612 381.02 563.612 381.812V390.74C563.612 391.052 563.42 391.34 563.036 391.604C562.676 391.868 562.232 392 561.704 392ZM585.957 392.288C584.325 392.288 582.885 391.988 581.637 391.388C580.389 390.788 579.405 389.96 578.685 388.904C577.965 387.824 577.605 386.564 577.605 385.124V381.704C577.605 380.432 577.941 379.268 578.613 378.212C579.309 377.156 580.221 376.316 581.349 375.692C582.477 375.044 583.725 374.72 585.093 374.72C586.389 374.72 587.577 375.008 588.657 375.584C589.737 376.136 590.601 376.916 591.249 377.924C591.921 378.932 592.257 380.084 592.257 381.38C592.257 382.388 592.101 383.108 591.789 383.54C591.477 383.972 591.069 384.236 590.565 384.332C590.061 384.428 589.533 384.476 588.981 384.476H581.385V385.304C581.385 386.504 581.817 387.464 582.681 388.184C583.569 388.88 584.697 389.228 586.065 389.228C586.905 389.228 587.589 389.108 588.117 388.868C588.645 388.628 589.089 388.4 589.449 388.184C589.809 387.968 590.145 387.86 590.457 387.86C590.769 387.86 591.033 387.956 591.249 388.148C591.465 388.34 591.633 388.568 591.753 388.832C591.873 389.096 591.933 389.336 591.933 389.552C591.933 389.912 591.681 390.308 591.177 390.74C590.697 391.172 590.013 391.544 589.125 391.856C588.237 392.144 587.181 392.288 585.957 392.288ZM581.385 382.136H587.361C587.889 382.136 588.237 382.064 588.405 381.92C588.597 381.776 588.693 381.488 588.693 381.056C588.693 380.432 588.537 379.856 588.225 379.328C587.913 378.776 587.481 378.356 586.929 378.068C586.377 377.756 585.753 377.6 585.057 377.6C584.385 377.6 583.773 377.744 583.221 378.032C582.669 378.32 582.225 378.716 581.889 379.22C581.553 379.724 581.385 380.312 581.385 380.984V382.136ZM597.175 392C596.647 392 596.203 391.868 595.843 391.604C595.507 391.34 595.339 391.052 595.339 390.74V376.16C595.339 375.8 595.507 375.512 595.843 375.296C596.203 375.056 596.647 374.936 597.175 374.936C597.655 374.936 598.063 375.056 598.399 375.296C598.735 375.512 598.903 375.8 598.903 376.16V377.744C599.167 377.24 599.515 376.76 599.947 376.304C600.403 375.848 600.931 375.476 601.531 375.188C602.131 374.876 602.779 374.72 603.475 374.72H604.627C605.011 374.72 605.347 374.888 605.635 375.224C605.923 375.536 606.067 375.92 606.067 376.376C606.067 376.832 605.923 377.228 605.635 377.564C605.347 377.9 605.011 378.068 604.627 378.068H603.475C602.755 378.068 602.059 378.284 601.387 378.716C600.715 379.148 600.163 379.76 599.731 380.552C599.323 381.32 599.119 382.256 599.119 383.36V390.74C599.119 391.052 598.927 391.34 598.543 391.604C598.183 391.868 597.727 392 597.175 392ZM71.976 438.36C71.64 438.36 71.34 438.3 71.076 438.18C70.812 438.06 70.62 437.844 70.5 437.532L64.92 422.988C64.872 422.868 64.824 422.76 64.776 422.664C64.752 422.544 64.74 422.448 64.74 422.376C64.74 422.064 64.872 421.8 65.136 421.584C65.4 421.344 65.712 421.152 66.072 421.008C66.456 420.864 66.816 420.792 67.152 420.792C67.416 420.792 67.656 420.852 67.872 420.972C68.088 421.068 68.232 421.236 68.304 421.476L72.3 432.672L75.36 422.736C75.48 422.376 75.66 422.148 75.9 422.052C76.14 421.956 76.404 421.908 76.692 421.908C77.004 421.908 77.28 421.956 77.52 422.052C77.76 422.148 77.94 422.376 78.06 422.736L81.048 432.744L85.08 421.476C85.224 421.02 85.596 420.792 86.196 420.792C86.532 420.792 86.88 420.864 87.24 421.008C87.624 421.128 87.948 421.308 88.212 421.548C88.476 421.788 88.608 422.076 88.608 422.412C88.608 422.484 88.596 422.58 88.572 422.7C88.548 422.82 88.512 422.916 88.464 422.988L82.884 437.604C82.788 437.892 82.596 438.084 82.308 438.18C82.044 438.3 81.744 438.36 81.408 438.36C81.024 438.36 80.688 438.3 80.4 438.18C80.136 438.06 79.956 437.88 79.86 437.64L76.692 428.352L73.596 437.532C73.5 437.82 73.296 438.024 72.984 438.144C72.696 438.288 72.36 438.36 71.976 438.36ZM92.8071 416.652C92.2071 416.652 91.6911 416.448 91.2591 416.04C90.8271 415.632 90.6111 415.176 90.6111 414.672C90.6111 414.12 90.8271 413.652 91.2591 413.268C91.6911 412.884 92.2071 412.692 92.8071 412.692C93.4071 412.692 93.9111 412.884 94.3191 413.268C94.7511 413.652 94.9671 414.12 94.9671 414.672C94.9671 415.176 94.7511 415.632 94.3191 416.04C93.9111 416.448 93.4071 416.652 92.8071 416.652ZM92.8071 438C92.2551 438 91.7991 437.868 91.4391 437.604C91.1031 437.34 90.9351 437.052 90.9351 436.74V422.16C90.9351 421.8 91.1031 421.512 91.4391 421.296C91.7991 421.056 92.2551 420.936 92.8071 420.936C93.3351 420.936 93.7791 421.056 94.1391 421.296C94.5231 421.512 94.7151 421.8 94.7151 422.16V436.74C94.7151 437.052 94.5231 437.34 94.1391 437.604C93.7791 437.868 93.3351 438 92.8071 438ZM104.862 438C102.822 438 101.262 437.556 100.182 436.668C99.1023 435.756 98.5623 434.328 98.5623 432.384V414.348C98.5623 413.988 98.7543 413.7 99.1383 413.484C99.5463 413.244 99.9783 413.124 100.434 413.124C100.89 413.124 101.322 413.244 101.73 413.484C102.138 413.7 102.342 413.988 102.342 414.348V420.936H106.734C107.07 420.936 107.322 421.08 107.49 421.368C107.682 421.656 107.778 421.98 107.778 422.34C107.778 422.7 107.682 423.024 107.49 423.312C107.322 423.6 107.07 423.744 106.734 423.744H102.342V432.384C102.342 433.248 102.522 433.86 102.882 434.22C103.266 434.58 103.926 434.76 104.862 434.76H106.086C106.638 434.76 107.046 434.928 107.31 435.264C107.598 435.576 107.742 435.948 107.742 436.38C107.742 436.788 107.598 437.16 107.31 437.496C107.046 437.832 106.638 438 106.086 438H104.862ZM112.284 438C111.732 438 111.276 437.868 110.916 437.604C110.58 437.34 110.412 437.052 110.412 436.74V412.008C110.412 411.648 110.58 411.36 110.916 411.144C111.276 410.904 111.732 410.784 112.284 410.784C112.812 410.784 113.256 410.904 113.616 411.144C114 411.36 114.192 411.648 114.192 412.008V423.456C114.552 422.76 115.116 422.136 115.884 421.584C116.676 421.008 117.648 420.72 118.8 420.72C119.928 420.72 120.96 421.044 121.896 421.692C122.856 422.316 123.624 423.168 124.2 424.248C124.776 425.304 125.064 426.492 125.064 427.812V436.74C125.064 437.148 124.86 437.46 124.452 437.676C124.068 437.892 123.636 438 123.156 438C122.724 438 122.304 437.892 121.896 437.676C121.488 437.46 121.284 437.148 121.284 436.74V427.812C121.284 427.188 121.116 426.588 120.78 426.012C120.444 425.436 120 424.968 119.448 424.608C118.92 424.248 118.32 424.068 117.648 424.068C117.072 424.068 116.52 424.224 115.992 424.536C115.464 424.824 115.032 425.244 114.696 425.796C114.36 426.348 114.192 427.02 114.192 427.812V436.74C114.192 437.052 114 437.34 113.616 437.604C113.256 437.868 112.812 438 112.284 438ZM137.913 446.1C137.385 446.1 136.941 445.968 136.581 445.704C136.245 445.44 136.077 445.152 136.077 444.84V422.16C136.077 421.8 136.245 421.512 136.581 421.296C136.941 421.056 137.373 420.936 137.877 420.936C138.381 420.936 138.801 421.056 139.137 421.296C139.473 421.512 139.641 421.8 139.641 422.16V423.456C140.049 422.76 140.661 422.136 141.477 421.584C142.317 421.008 143.313 420.72 144.465 420.72C145.665 420.72 146.757 421.044 147.741 421.692C148.725 422.316 149.505 423.168 150.081 424.248C150.657 425.304 150.945 426.492 150.945 427.812V431.124C150.945 432.372 150.645 433.548 150.045 434.652C149.469 435.732 148.701 436.608 147.741 437.28C146.781 437.952 145.737 438.288 144.609 438.288C143.529 438.288 142.557 438.012 141.693 437.46C140.829 436.884 140.217 436.224 139.857 435.48V444.84C139.857 445.152 139.665 445.44 139.281 445.704C138.921 445.968 138.465 446.1 137.913 446.1ZM143.493 434.94C144.141 434.94 144.741 434.76 145.293 434.4C145.845 434.04 146.289 433.56 146.625 432.96C146.985 432.36 147.165 431.748 147.165 431.124V427.812C147.165 427.188 146.997 426.588 146.661 426.012C146.325 425.436 145.869 424.968 145.293 424.608C144.741 424.248 144.117 424.068 143.421 424.068C142.845 424.068 142.281 424.224 141.729 424.536C141.177 424.824 140.721 425.244 140.361 425.796C140.025 426.348 139.857 427.02 139.857 427.812V431.952C139.857 432.24 140.013 432.624 140.325 433.104C140.637 433.56 141.069 433.98 141.621 434.364C142.173 434.748 142.797 434.94 143.493 434.94ZM161.955 438.288C160.323 438.288 158.883 437.988 157.635 437.388C156.387 436.788 155.403 435.96 154.683 434.904C153.963 433.824 153.603 432.564 153.603 431.124V427.704C153.603 426.432 153.939 425.268 154.611 424.212C155.307 423.156 156.219 422.316 157.347 421.692C158.475 421.044 159.723 420.72 161.091 420.72C162.387 420.72 163.575 421.008 164.655 421.584C165.735 422.136 166.599 422.916 167.247 423.924C167.919 424.932 168.255 426.084 168.255 427.38C168.255 428.388 168.099 429.108 167.787 429.54C167.475 429.972 167.067 430.236 166.563 430.332C166.059 430.428 165.531 430.476 164.979 430.476H157.383V431.304C157.383 432.504 157.815 433.464 158.679 434.184C159.567 434.88 160.695 435.228 162.063 435.228C162.903 435.228 163.587 435.108 164.115 434.868C164.643 434.628 165.087 434.4 165.447 434.184C165.807 433.968 166.143 433.86 166.455 433.86C166.767 433.86 167.031 433.956 167.247 434.148C167.463 434.34 167.631 434.568 167.751 434.832C167.871 435.096 167.931 435.336 167.931 435.552C167.931 435.912 167.679 436.308 167.175 436.74C166.695 437.172 166.011 437.544 165.123 437.856C164.235 438.144 163.179 438.288 161.955 438.288ZM157.383 428.136H163.359C163.887 428.136 164.235 428.064 164.403 427.92C164.595 427.776 164.691 427.488 164.691 427.056C164.691 426.432 164.535 425.856 164.223 425.328C163.911 424.776 163.479 424.356 162.927 424.068C162.375 423.756 161.751 423.6 161.055 423.6C160.383 423.6 159.771 423.744 159.219 424.032C158.667 424.32 158.223 424.716 157.887 425.22C157.551 425.724 157.383 426.312 157.383 426.984V428.136ZM178.069 438.288C176.773 438.288 175.561 437.952 174.433 437.28C173.305 436.608 172.393 435.732 171.697 434.652C171.025 433.548 170.689 432.372 170.689 431.124V427.812C170.689 426.54 171.013 425.364 171.661 424.284C172.333 423.204 173.233 422.34 174.361 421.692C175.513 421.044 176.761 420.72 178.105 420.72C179.449 420.72 180.685 421.044 181.813 421.692C182.941 422.316 183.841 423.168 184.513 424.248C185.209 425.304 185.557 426.492 185.557 427.812V431.124C185.557 432.348 185.209 433.512 184.513 434.616C183.841 435.72 182.929 436.608 181.777 437.28C180.649 437.952 179.413 438.288 178.069 438.288ZM178.105 434.94C178.777 434.94 179.389 434.76 179.941 434.4C180.493 434.04 180.937 433.572 181.273 432.996C181.609 432.396 181.777 431.772 181.777 431.124V427.812C181.777 427.188 181.609 426.588 181.273 426.012C180.937 425.436 180.493 424.968 179.941 424.608C179.389 424.248 178.777 424.068 178.105 424.068C177.409 424.068 176.785 424.248 176.233 424.608C175.705 424.968 175.273 425.436 174.937 426.012C174.625 426.588 174.469 427.188 174.469 427.812V431.124C174.469 431.772 174.625 432.396 174.937 432.996C175.273 433.572 175.717 434.04 176.269 434.4C176.821 434.76 177.433 434.94 178.105 434.94ZM190.717 446.1C190.189 446.1 189.745 445.968 189.385 445.704C189.049 445.44 188.881 445.152 188.881 444.84V422.16C188.881 421.8 189.049 421.512 189.385 421.296C189.745 421.056 190.177 420.936 190.681 420.936C191.185 420.936 191.605 421.056 191.941 421.296C192.277 421.512 192.445 421.8 192.445 422.16V423.456C192.853 422.76 193.465 422.136 194.281 421.584C195.121 421.008 196.117 420.72 197.269 420.72C198.469 420.72 199.561 421.044 200.545 421.692C201.529 422.316 202.309 423.168 202.885 424.248C203.461 425.304 203.749 426.492 203.749 427.812V431.124C203.749 432.372 203.449 433.548 202.849 434.652C202.273 435.732 201.505 436.608 200.545 437.28C199.585 437.952 198.541 438.288 197.413 438.288C196.333 438.288 195.361 438.012 194.497 437.46C193.633 436.884 193.021 436.224 192.661 435.48V444.84C192.661 445.152 192.469 445.44 192.085 445.704C191.725 445.968 191.269 446.1 190.717 446.1ZM196.297 434.94C196.945 434.94 197.545 434.76 198.097 434.4C198.649 434.04 199.093 433.56 199.429 432.96C199.789 432.36 199.969 431.748 199.969 431.124V427.812C199.969 427.188 199.801 426.588 199.465 426.012C199.129 425.436 198.673 424.968 198.097 424.608C197.545 424.248 196.921 424.068 196.225 424.068C195.649 424.068 195.085 424.224 194.533 424.536C193.981 424.824 193.525 425.244 193.165 425.796C192.829 426.348 192.661 427.02 192.661 427.812V431.952C192.661 432.24 192.817 432.624 193.129 433.104C193.441 433.56 193.873 433.98 194.425 434.364C194.977 434.748 195.601 434.94 196.297 434.94ZM209.252 438C208.7 438 208.244 437.868 207.884 437.604C207.548 437.34 207.38 437.052 207.38 436.74V412.008C207.38 411.648 207.548 411.36 207.884 411.144C208.244 410.904 208.7 410.784 209.252 410.784C209.78 410.784 210.224 410.904 210.584 411.144C210.968 411.36 211.16 411.648 211.16 412.008V436.74C211.16 437.052 210.968 437.34 210.584 437.604C210.224 437.868 209.78 438 209.252 438ZM223.127 438.288C221.495 438.288 220.055 437.988 218.807 437.388C217.559 436.788 216.575 435.96 215.855 434.904C215.135 433.824 214.775 432.564 214.775 431.124V427.704C214.775 426.432 215.111 425.268 215.783 424.212C216.479 423.156 217.391 422.316 218.519 421.692C219.647 421.044 220.895 420.72 222.263 420.72C223.559 420.72 224.747 421.008 225.827 421.584C226.907 422.136 227.771 422.916 228.419 423.924C229.091 424.932 229.427 426.084 229.427 427.38C229.427 428.388 229.271 429.108 228.959 429.54C228.647 429.972 228.239 430.236 227.735 430.332C227.231 430.428 226.703 430.476 226.151 430.476H218.555V431.304C218.555 432.504 218.987 433.464 219.851 434.184C220.739 434.88 221.867 435.228 223.235 435.228C224.075 435.228 224.759 435.108 225.287 434.868C225.815 434.628 226.259 434.4 226.619 434.184C226.979 433.968 227.315 433.86 227.627 433.86C227.939 433.86 228.203 433.956 228.419 434.148C228.635 434.34 228.803 434.568 228.923 434.832C229.043 435.096 229.103 435.336 229.103 435.552C229.103 435.912 228.851 436.308 228.347 436.74C227.867 437.172 227.183 437.544 226.295 437.856C225.407 438.144 224.351 438.288 223.127 438.288ZM218.555 428.136H224.531C225.059 428.136 225.407 428.064 225.575 427.92C225.767 427.776 225.863 427.488 225.863 427.056C225.863 426.432 225.707 425.856 225.395 425.328C225.083 424.776 224.651 424.356 224.099 424.068C223.547 423.756 222.923 423.6 222.227 423.6C221.555 423.6 220.943 423.744 220.391 424.032C219.839 424.32 219.395 424.716 219.059 425.22C218.723 425.724 218.555 426.312 218.555 426.984V428.136ZM245.296 438.36C244.96 438.36 244.66 438.3 244.396 438.18C244.132 438.06 243.94 437.844 243.82 437.532L238.24 422.988C238.192 422.868 238.144 422.76 238.096 422.664C238.072 422.544 238.06 422.448 238.06 422.376C238.06 422.064 238.192 421.8 238.456 421.584C238.72 421.344 239.032 421.152 239.392 421.008C239.776 420.864 240.136 420.792 240.472 420.792C240.736 420.792 240.976 420.852 241.192 420.972C241.408 421.068 241.552 421.236 241.624 421.476L245.62 432.672L248.68 422.736C248.8 422.376 248.98 422.148 249.22 422.052C249.46 421.956 249.724 421.908 250.012 421.908C250.324 421.908 250.6 421.956 250.84 422.052C251.08 422.148 251.26 422.376 251.38 422.736L254.368 432.744L258.4 421.476C258.544 421.02 258.916 420.792 259.516 420.792C259.852 420.792 260.2 420.864 260.56 421.008C260.944 421.128 261.268 421.308 261.532 421.548C261.796 421.788 261.928 422.076 261.928 422.412C261.928 422.484 261.916 422.58 261.892 422.7C261.868 422.82 261.832 422.916 261.784 422.988L256.204 437.604C256.108 437.892 255.916 438.084 255.628 438.18C255.364 438.3 255.064 438.36 254.728 438.36C254.344 438.36 254.008 438.3 253.72 438.18C253.456 438.06 253.276 437.88 253.18 437.64L250.012 428.352L246.916 437.532C246.82 437.82 246.616 438.024 246.304 438.144C246.016 438.288 245.68 438.36 245.296 438.36ZM266.163 438C265.611 438 265.155 437.868 264.795 437.604C264.459 437.34 264.291 437.052 264.291 436.74V412.008C264.291 411.648 264.459 411.36 264.795 411.144C265.155 410.904 265.611 410.784 266.163 410.784C266.691 410.784 267.135 410.904 267.495 411.144C267.879 411.36 268.071 411.648 268.071 412.008V423.456C268.431 422.76 268.995 422.136 269.763 421.584C270.555 421.008 271.527 420.72 272.679 420.72C273.807 420.72 274.839 421.044 275.775 421.692C276.735 422.316 277.503 423.168 278.079 424.248C278.655 425.304 278.943 426.492 278.943 427.812V436.74C278.943 437.148 278.739 437.46 278.331 437.676C277.947 437.892 277.515 438 277.035 438C276.603 438 276.183 437.892 275.775 437.676C275.367 437.46 275.163 437.148 275.163 436.74V427.812C275.163 427.188 274.995 426.588 274.659 426.012C274.323 425.436 273.879 424.968 273.327 424.608C272.799 424.248 272.199 424.068 271.527 424.068C270.951 424.068 270.399 424.224 269.871 424.536C269.343 424.824 268.911 425.244 268.575 425.796C268.239 426.348 268.071 427.02 268.071 427.812V436.74C268.071 437.052 267.879 437.34 267.495 437.604C267.135 437.868 266.691 438 266.163 438ZM289.444 438.288C288.148 438.288 286.936 437.952 285.808 437.28C284.68 436.608 283.768 435.732 283.072 434.652C282.4 433.548 282.064 432.372 282.064 431.124V427.812C282.064 426.54 282.388 425.364 283.036 424.284C283.708 423.204 284.608 422.34 285.736 421.692C286.888 421.044 288.136 420.72 289.48 420.72C290.824 420.72 292.06 421.044 293.188 421.692C294.316 422.316 295.216 423.168 295.888 424.248C296.584 425.304 296.932 426.492 296.932 427.812V431.124C296.932 432.348 296.584 433.512 295.888 434.616C295.216 435.72 294.304 436.608 293.152 437.28C292.024 437.952 290.788 438.288 289.444 438.288ZM289.48 434.94C290.152 434.94 290.764 434.76 291.316 434.4C291.868 434.04 292.312 433.572 292.648 432.996C292.984 432.396 293.152 431.772 293.152 431.124V427.812C293.152 427.188 292.984 426.588 292.648 426.012C292.312 425.436 291.868 424.968 291.316 424.608C290.764 424.248 290.152 424.068 289.48 424.068C288.784 424.068 288.16 424.248 287.608 424.608C287.08 424.968 286.648 425.436 286.312 426.012C286 426.588 285.844 427.188 285.844 427.812V431.124C285.844 431.772 286 432.396 286.312 432.996C286.648 433.572 287.092 434.04 287.644 434.4C288.196 434.76 288.808 434.94 289.48 434.94ZM311.135 438.288C309.815 438.288 308.687 437.904 307.751 437.136C306.815 436.344 306.347 435.144 306.347 433.536C306.347 432.168 306.707 431.112 307.427 430.368C308.147 429.624 309.131 429.108 310.379 428.82C311.651 428.532 313.115 428.388 314.771 428.388H316.355V427.74C316.355 427.116 316.235 426.516 315.995 425.94C315.779 425.34 315.407 424.848 314.879 424.464C314.375 424.056 313.679 423.852 312.791 423.852C311.903 423.852 311.219 423.936 310.739 424.104C310.259 424.272 309.875 424.452 309.587 424.644C309.299 424.836 309.035 424.932 308.795 424.932C308.363 424.932 308.027 424.728 307.787 424.32C307.547 423.888 307.427 423.456 307.427 423.024C307.427 422.592 307.703 422.208 308.255 421.872C308.831 421.512 309.539 421.236 310.379 421.044C311.219 420.828 312.047 420.72 312.863 420.72C314.639 420.72 316.055 421.056 317.111 421.728C318.167 422.376 318.935 423.228 319.415 424.284C319.895 425.34 320.135 426.48 320.135 427.704V436.74C320.135 437.076 319.955 437.376 319.595 437.64C319.259 437.88 318.827 438 318.299 438C317.819 438 317.411 437.88 317.075 437.64C316.739 437.376 316.571 437.076 316.571 436.74V435.48C315.947 436.2 315.191 436.848 314.303 437.424C313.415 438 312.359 438.288 311.135 438.288ZM312.503 435.408C313.103 435.408 313.691 435.228 314.267 434.868C314.867 434.508 315.359 434.052 315.743 433.5C316.151 432.948 316.355 432.384 316.355 431.808V430.476H315.455C314.543 430.476 313.679 430.536 312.863 430.656C312.047 430.752 311.387 430.992 310.883 431.376C310.403 431.736 310.163 432.3 310.163 433.068C310.163 433.884 310.379 434.484 310.811 434.868C311.267 435.228 311.831 435.408 312.503 435.408ZM325.787 438C325.259 438 324.815 437.868 324.455 437.604C324.119 437.34 323.951 437.052 323.951 436.74V422.16C323.951 421.8 324.119 421.512 324.455 421.296C324.815 421.056 325.259 420.936 325.787 420.936C326.267 420.936 326.675 421.056 327.011 421.296C327.347 421.512 327.515 421.8 327.515 422.16V423.744C327.779 423.24 328.127 422.76 328.559 422.304C329.015 421.848 329.543 421.476 330.143 421.188C330.743 420.876 331.391 420.72 332.087 420.72H333.239C333.623 420.72 333.959 420.888 334.247 421.224C334.535 421.536 334.679 421.92 334.679 422.376C334.679 422.832 334.535 423.228 334.247 423.564C333.959 423.9 333.623 424.068 333.239 424.068H332.087C331.367 424.068 330.671 424.284 329.999 424.716C329.327 425.148 328.775 425.76 328.343 426.552C327.935 427.32 327.731 428.256 327.731 429.36V436.74C327.731 437.052 327.539 437.34 327.155 437.604C326.795 437.868 326.339 438 325.787 438ZM343.995 438.288C342.363 438.288 340.923 437.988 339.675 437.388C338.427 436.788 337.443 435.96 336.723 434.904C336.003 433.824 335.643 432.564 335.643 431.124V427.704C335.643 426.432 335.979 425.268 336.651 424.212C337.347 423.156 338.259 422.316 339.387 421.692C340.515 421.044 341.763 420.72 343.131 420.72C344.427 420.72 345.615 421.008 346.695 421.584C347.775 422.136 348.639 422.916 349.287 423.924C349.959 424.932 350.295 426.084 350.295 427.38C350.295 428.388 350.139 429.108 349.827 429.54C349.515 429.972 349.107 430.236 348.603 430.332C348.099 430.428 347.571 430.476 347.019 430.476H339.423V431.304C339.423 432.504 339.855 433.464 340.719 434.184C341.607 434.88 342.735 435.228 344.103 435.228C344.943 435.228 345.627 435.108 346.155 434.868C346.683 434.628 347.127 434.4 347.487 434.184C347.847 433.968 348.183 433.86 348.495 433.86C348.807 433.86 349.071 433.956 349.287 434.148C349.503 434.34 349.671 434.568 349.791 434.832C349.911 435.096 349.971 435.336 349.971 435.552C349.971 435.912 349.719 436.308 349.215 436.74C348.735 437.172 348.051 437.544 347.163 437.856C346.275 438.144 345.219 438.288 343.995 438.288ZM339.423 428.136H345.399C345.927 428.136 346.275 428.064 346.443 427.92C346.635 427.776 346.731 427.488 346.731 427.056C346.731 426.432 346.575 425.856 346.263 425.328C345.951 424.776 345.519 424.356 344.967 424.068C344.415 423.756 343.791 423.6 343.095 423.6C342.423 423.6 341.811 423.744 341.259 424.032C340.707 424.32 340.263 424.716 339.927 425.22C339.591 425.724 339.423 426.312 339.423 426.984V428.136ZM366.272 438.288C365.144 438.288 364.1 437.952 363.14 437.28C362.18 436.608 361.4 435.732 360.8 434.652C360.224 433.548 359.936 432.372 359.936 431.124V427.812C359.936 426.492 360.224 425.304 360.8 424.248C361.4 423.168 362.18 422.316 363.14 421.692C364.1 421.044 365.168 420.72 366.344 420.72C367.496 420.72 368.468 421.008 369.26 421.584C370.052 422.136 370.64 422.76 371.024 423.456V412.008C371.024 411.648 371.216 411.36 371.6 411.144C371.984 410.904 372.44 410.784 372.968 410.784C373.496 410.784 373.928 410.904 374.264 411.144C374.624 411.36 374.804 411.648 374.804 412.008V436.74C374.804 437.052 374.624 437.34 374.264 437.604C373.928 437.868 373.496 438 372.968 438C372.512 438 372.104 437.868 371.744 437.604C371.408 437.34 371.24 437.052 371.24 436.74V435.48C370.88 436.224 370.244 436.884 369.332 437.46C368.42 438.012 367.4 438.288 366.272 438.288ZM367.352 434.94C368.048 434.94 368.672 434.748 369.224 434.364C369.776 433.98 370.208 433.56 370.52 433.104C370.856 432.624 371.024 432.24 371.024 431.952V427.812C371.024 427.02 370.844 426.348 370.484 425.796C370.124 425.244 369.668 424.824 369.116 424.536C368.564 424.224 367.988 424.068 367.388 424.068C366.716 424.068 366.092 424.248 365.516 424.608C364.964 424.968 364.52 425.436 364.184 426.012C363.872 426.588 363.716 427.188 363.716 427.812V431.124C363.716 431.748 363.872 432.36 364.184 432.96C364.52 433.56 364.964 434.04 365.516 434.4C366.068 434.76 366.68 434.94 367.352 434.94ZM380.666 416.652C380.066 416.652 379.55 416.448 379.118 416.04C378.686 415.632 378.47 415.176 378.47 414.672C378.47 414.12 378.686 413.652 379.118 413.268C379.55 412.884 380.066 412.692 380.666 412.692C381.266 412.692 381.77 412.884 382.178 413.268C382.61 413.652 382.826 414.12 382.826 414.672C382.826 415.176 382.61 415.632 382.178 416.04C381.77 416.448 381.266 416.652 380.666 416.652ZM380.666 438C380.114 438 379.658 437.868 379.298 437.604C378.962 437.34 378.794 437.052 378.794 436.74V422.16C378.794 421.8 378.962 421.512 379.298 421.296C379.658 421.056 380.114 420.936 380.666 420.936C381.194 420.936 381.638 421.056 381.998 421.296C382.382 421.512 382.574 421.8 382.574 422.16V436.74C382.574 437.052 382.382 437.34 381.998 437.604C381.638 437.868 381.194 438 380.666 438ZM388.366 438C387.838 438 387.394 437.892 387.034 437.676C386.698 437.436 386.53 437.136 386.53 436.776V417.66C386.53 416.364 386.818 415.2 387.394 414.168C387.97 413.112 388.738 412.284 389.698 411.684C390.658 411.084 391.714 410.784 392.866 410.784H394.558C395.038 410.784 395.398 410.952 395.638 411.288C395.902 411.624 396.034 411.996 396.034 412.404C396.034 412.836 395.902 413.22 395.638 413.556C395.398 413.868 395.038 414.024 394.558 414.024H393.586C392.962 414.024 392.398 414.168 391.894 414.456C391.414 414.744 391.03 415.14 390.742 415.644C390.454 416.124 390.31 416.676 390.31 417.3V420.936H394.954C395.314 420.936 395.578 421.08 395.746 421.368C395.938 421.656 396.034 421.98 396.034 422.34C396.034 422.7 395.938 423.024 395.746 423.312C395.578 423.6 395.314 423.744 394.954 423.744H390.31V436.776C390.31 437.136 390.118 437.436 389.734 437.676C389.35 437.892 388.894 438 388.366 438ZM400.143 438C399.615 438 399.171 437.892 398.811 437.676C398.475 437.436 398.307 437.136 398.307 436.776V417.66C398.307 416.364 398.595 415.2 399.171 414.168C399.747 413.112 400.515 412.284 401.475 411.684C402.435 411.084 403.491 410.784 404.643 410.784H406.335C406.815 410.784 407.175 410.952 407.415 411.288C407.679 411.624 407.811 411.996 407.811 412.404C407.811 412.836 407.679 413.22 407.415 413.556C407.175 413.868 406.815 414.024 406.335 414.024H405.363C404.739 414.024 404.175 414.168 403.671 414.456C403.191 414.744 402.807 415.14 402.519 415.644C402.231 416.124 402.087 416.676 402.087 417.3V420.936H406.731C407.091 420.936 407.355 421.08 407.523 421.368C407.715 421.656 407.811 421.98 407.811 422.34C407.811 422.7 407.715 423.024 407.523 423.312C407.355 423.6 407.091 423.744 406.731 423.744H402.087V436.776C402.087 437.136 401.895 437.436 401.511 437.676C401.127 437.892 400.671 438 400.143 438ZM417.225 438.288C415.593 438.288 414.153 437.988 412.905 437.388C411.657 436.788 410.673 435.96 409.953 434.904C409.233 433.824 408.873 432.564 408.873 431.124V427.704C408.873 426.432 409.209 425.268 409.881 424.212C410.577 423.156 411.489 422.316 412.617 421.692C413.745 421.044 414.993 420.72 416.361 420.72C417.657 420.72 418.845 421.008 419.925 421.584C421.005 422.136 421.869 422.916 422.517 423.924C423.189 424.932 423.525 426.084 423.525 427.38C423.525 428.388 423.369 429.108 423.057 429.54C422.745 429.972 422.337 430.236 421.833 430.332C421.329 430.428 420.801 430.476 420.249 430.476H412.653V431.304C412.653 432.504 413.085 433.464 413.949 434.184C414.837 434.88 415.965 435.228 417.333 435.228C418.173 435.228 418.857 435.108 419.385 434.868C419.913 434.628 420.357 434.4 420.717 434.184C421.077 433.968 421.413 433.86 421.725 433.86C422.037 433.86 422.301 433.956 422.517 434.148C422.733 434.34 422.901 434.568 423.021 434.832C423.141 435.096 423.201 435.336 423.201 435.552C423.201 435.912 422.949 436.308 422.445 436.74C421.965 437.172 421.281 437.544 420.393 437.856C419.505 438.144 418.449 438.288 417.225 438.288ZM412.653 428.136H418.629C419.157 428.136 419.505 428.064 419.673 427.92C419.865 427.776 419.961 427.488 419.961 427.056C419.961 426.432 419.805 425.856 419.493 425.328C419.181 424.776 418.749 424.356 418.197 424.068C417.645 423.756 417.021 423.6 416.325 423.6C415.653 423.6 415.041 423.744 414.489 424.032C413.937 424.32 413.493 424.716 413.157 425.22C412.821 425.724 412.653 426.312 412.653 426.984V428.136ZM428.443 438C427.915 438 427.471 437.868 427.111 437.604C426.775 437.34 426.607 437.052 426.607 436.74V422.16C426.607 421.8 426.775 421.512 427.111 421.296C427.471 421.056 427.915 420.936 428.443 420.936C428.923 420.936 429.331 421.056 429.667 421.296C430.003 421.512 430.171 421.8 430.171 422.16V423.744C430.435 423.24 430.783 422.76 431.215 422.304C431.671 421.848 432.199 421.476 432.799 421.188C433.399 420.876 434.047 420.72 434.743 420.72H435.895C436.279 420.72 436.615 420.888 436.903 421.224C437.191 421.536 437.335 421.92 437.335 422.376C437.335 422.832 437.191 423.228 436.903 423.564C436.615 423.9 436.279 424.068 435.895 424.068H434.743C434.023 424.068 433.327 424.284 432.655 424.716C431.983 425.148 431.431 425.76 430.999 426.552C430.591 427.32 430.387 428.256 430.387 429.36V436.74C430.387 437.052 430.195 437.34 429.811 437.604C429.451 437.868 428.995 438 428.443 438ZM446.651 438.288C445.019 438.288 443.579 437.988 442.331 437.388C441.083 436.788 440.099 435.96 439.379 434.904C438.659 433.824 438.299 432.564 438.299 431.124V427.704C438.299 426.432 438.635 425.268 439.307 424.212C440.003 423.156 440.915 422.316 442.043 421.692C443.171 421.044 444.419 420.72 445.787 420.72C447.083 420.72 448.271 421.008 449.351 421.584C450.431 422.136 451.295 422.916 451.943 423.924C452.615 424.932 452.951 426.084 452.951 427.38C452.951 428.388 452.795 429.108 452.483 429.54C452.171 429.972 451.763 430.236 451.259 430.332C450.755 430.428 450.227 430.476 449.675 430.476H442.079V431.304C442.079 432.504 442.511 433.464 443.375 434.184C444.263 434.88 445.391 435.228 446.759 435.228C447.599 435.228 448.283 435.108 448.811 434.868C449.339 434.628 449.783 434.4 450.143 434.184C450.503 433.968 450.839 433.86 451.151 433.86C451.463 433.86 451.727 433.956 451.943 434.148C452.159 434.34 452.327 434.568 452.447 434.832C452.567 435.096 452.627 435.336 452.627 435.552C452.627 435.912 452.375 436.308 451.871 436.74C451.391 437.172 450.707 437.544 449.819 437.856C448.931 438.144 447.875 438.288 446.651 438.288ZM442.079 428.136H448.055C448.583 428.136 448.931 428.064 449.099 427.92C449.291 427.776 449.387 427.488 449.387 427.056C449.387 426.432 449.231 425.856 448.919 425.328C448.607 424.776 448.175 424.356 447.623 424.068C447.071 423.756 446.447 423.6 445.751 423.6C445.079 423.6 444.467 423.744 443.915 424.032C443.363 424.32 442.919 424.716 442.583 425.22C442.247 425.724 442.079 426.312 442.079 426.984V428.136ZM457.905 438C457.353 438 456.897 437.868 456.537 437.604C456.201 437.34 456.033 437.052 456.033 436.74V422.16C456.033 421.8 456.201 421.512 456.537 421.296C456.897 421.056 457.353 420.936 457.905 420.936C458.361 420.936 458.757 421.056 459.093 421.296C459.429 421.512 459.597 421.8 459.597 422.16V423.456C459.957 422.76 460.545 422.136 461.361 421.584C462.201 421.008 463.221 420.72 464.421 420.72C465.549 420.72 466.581 421.044 467.517 421.692C468.477 422.316 469.245 423.168 469.821 424.248C470.397 425.304 470.685 426.492 470.685 427.812V436.74C470.685 437.148 470.481 437.46 470.073 437.676C469.689 437.892 469.257 438 468.777 438C468.345 438 467.925 437.892 467.517 437.676C467.109 437.46 466.905 437.148 466.905 436.74V427.812C466.905 427.188 466.737 426.588 466.401 426.012C466.089 425.436 465.657 424.968 465.105 424.608C464.553 424.248 463.941 424.068 463.269 424.068C462.693 424.068 462.141 424.224 461.613 424.536C461.085 424.824 460.653 425.244 460.317 425.796C459.981 426.348 459.813 427.02 459.813 427.812V436.74C459.813 437.052 459.621 437.34 459.237 437.604C458.877 437.868 458.433 438 457.905 438ZM480.683 438C478.643 438 477.083 437.556 476.003 436.668C474.923 435.756 474.383 434.328 474.383 432.384V414.348C474.383 413.988 474.575 413.7 474.959 413.484C475.367 413.244 475.799 413.124 476.255 413.124C476.711 413.124 477.143 413.244 477.551 413.484C477.959 413.7 478.163 413.988 478.163 414.348V420.936H482.555C482.891 420.936 483.143 421.08 483.311 421.368C483.503 421.656 483.599 421.98 483.599 422.34C483.599 422.7 483.503 423.024 483.311 423.312C483.143 423.6 482.891 423.744 482.555 423.744H478.163V432.384C478.163 433.248 478.343 433.86 478.703 434.22C479.087 434.58 479.747 434.76 480.683 434.76H481.907C482.459 434.76 482.867 434.928 483.131 435.264C483.419 435.576 483.563 435.948 483.563 436.38C483.563 436.788 483.419 437.16 483.131 437.496C482.867 437.832 482.459 438 481.907 438H480.683ZM495.276 438C494.748 438 494.304 437.892 493.944 437.676C493.608 437.436 493.44 437.136 493.44 436.776V417.66C493.44 416.364 493.728 415.2 494.304 414.168C494.88 413.112 495.648 412.284 496.608 411.684C497.568 411.084 498.624 410.784 499.776 410.784H501.468C501.948 410.784 502.308 410.952 502.548 411.288C502.812 411.624 502.944 411.996 502.944 412.404C502.944 412.836 502.812 413.22 502.548 413.556C502.308 413.868 501.948 414.024 501.468 414.024H500.496C499.872 414.024 499.308 414.168 498.804 414.456C498.324 414.744 497.94 415.14 497.652 415.644C497.364 416.124 497.22 416.676 497.22 417.3V420.936H501.864C502.224 420.936 502.488 421.08 502.656 421.368C502.848 421.656 502.944 421.98 502.944 422.34C502.944 422.7 502.848 423.024 502.656 423.312C502.488 423.6 502.224 423.744 501.864 423.744H497.22V436.776C497.22 437.136 497.028 437.436 496.644 437.676C496.26 437.892 495.804 438 495.276 438ZM507.017 438C506.489 438 506.045 437.868 505.685 437.604C505.349 437.34 505.181 437.052 505.181 436.74V422.16C505.181 421.8 505.349 421.512 505.685 421.296C506.045 421.056 506.489 420.936 507.017 420.936C507.497 420.936 507.905 421.056 508.241 421.296C508.577 421.512 508.745 421.8 508.745 422.16V423.744C509.009 423.24 509.357 422.76 509.789 422.304C510.245 421.848 510.773 421.476 511.373 421.188C511.973 420.876 512.621 420.72 513.317 420.72H514.469C514.853 420.72 515.189 420.888 515.477 421.224C515.765 421.536 515.909 421.92 515.909 422.376C515.909 422.832 515.765 423.228 515.477 423.564C515.189 423.9 514.853 424.068 514.469 424.068H513.317C512.597 424.068 511.901 424.284 511.229 424.716C510.557 425.148 510.005 425.76 509.573 426.552C509.165 427.32 508.961 428.256 508.961 429.36V436.74C508.961 437.052 508.769 437.34 508.385 437.604C508.025 437.868 507.569 438 507.017 438ZM524.253 438.288C522.957 438.288 521.745 437.952 520.617 437.28C519.489 436.608 518.577 435.732 517.881 434.652C517.209 433.548 516.873 432.372 516.873 431.124V427.812C516.873 426.54 517.197 425.364 517.845 424.284C518.517 423.204 519.417 422.34 520.545 421.692C521.697 421.044 522.945 420.72 524.289 420.72C525.633 420.72 526.869 421.044 527.997 421.692C529.125 422.316 530.025 423.168 530.697 424.248C531.393 425.304 531.741 426.492 531.741 427.812V431.124C531.741 432.348 531.393 433.512 530.697 434.616C530.025 435.72 529.113 436.608 527.961 437.28C526.833 437.952 525.597 438.288 524.253 438.288ZM524.289 434.94C524.961 434.94 525.573 434.76 526.125 434.4C526.677 434.04 527.121 433.572 527.457 432.996C527.793 432.396 527.961 431.772 527.961 431.124V427.812C527.961 427.188 527.793 426.588 527.457 426.012C527.121 425.436 526.677 424.968 526.125 424.608C525.573 424.248 524.961 424.068 524.289 424.068C523.593 424.068 522.969 424.248 522.417 424.608C521.889 424.968 521.457 425.436 521.121 426.012C520.809 426.588 520.653 427.188 520.653 427.812V431.124C520.653 431.772 520.809 432.396 521.121 432.996C521.457 433.572 521.901 434.04 522.453 434.4C523.005 434.76 523.617 434.94 524.289 434.94ZM536.901 438C536.349 438 535.893 437.868 535.533 437.604C535.197 437.34 535.029 437.052 535.029 436.74V422.16C535.029 421.8 535.197 421.512 535.533 421.296C535.893 421.056 536.349 420.936 536.901 420.936C537.357 420.936 537.753 421.056 538.089 421.296C538.425 421.512 538.593 421.8 538.593 422.16V423.456C539.001 422.76 539.601 422.136 540.393 421.584C541.185 421.008 542.181 420.72 543.381 420.72C544.461 420.72 545.409 421.056 546.225 421.728C547.065 422.4 547.689 423.264 548.097 424.32C548.721 423.096 549.525 422.196 550.509 421.62C551.493 421.02 552.501 420.72 553.533 420.72C554.613 420.72 555.621 420.996 556.557 421.548C557.517 422.1 558.297 422.904 558.897 423.96C559.497 425.016 559.797 426.3 559.797 427.812V436.74C559.797 437.052 559.605 437.34 559.221 437.604C558.861 437.868 558.417 438 557.889 438C557.385 438 556.941 437.868 556.557 437.604C556.197 437.34 556.017 437.052 556.017 436.74V427.812C556.017 426.996 555.849 426.312 555.513 425.76C555.201 425.184 554.781 424.752 554.253 424.464C553.749 424.176 553.221 424.032 552.669 424.032C552.093 424.032 551.553 424.188 551.049 424.5C550.545 424.788 550.125 425.208 549.789 425.76C549.453 426.288 549.285 426.948 549.285 427.74V436.776C549.285 437.208 549.081 437.52 548.673 437.712C548.289 437.904 547.857 438 547.377 438C546.945 438 546.525 437.904 546.117 437.712C545.709 437.52 545.505 437.208 545.505 436.776V427.776C545.505 427.008 545.349 426.348 545.037 425.796C544.725 425.244 544.317 424.824 543.813 424.536C543.309 424.224 542.757 424.068 542.157 424.068C541.605 424.068 541.065 424.212 540.537 424.5C540.033 424.788 539.613 425.208 539.277 425.76C538.965 426.312 538.809 426.996 538.809 427.812V436.74C538.809 437.052 538.617 437.34 538.233 437.604C537.873 437.868 537.429 438 536.901 438ZM570.89 446.1C570.41 446.1 570.002 445.992 569.666 445.776C569.33 445.584 569.162 445.152 569.162 444.48C569.162 444.048 569.234 443.664 569.378 443.328C569.522 443.016 569.786 442.86 570.17 442.86C570.626 442.86 571.118 442.74 571.646 442.5C572.198 442.284 572.726 441.924 573.23 441.42C573.758 440.94 574.202 440.328 574.562 439.584C574.946 438.84 575.21 437.964 575.354 436.956L569.27 422.988C569.174 422.82 569.126 422.652 569.126 422.484C569.126 422.172 569.258 421.884 569.522 421.62C569.81 421.332 570.146 421.104 570.53 420.936C570.914 420.768 571.274 420.684 571.61 420.684C571.85 420.684 572.078 420.744 572.294 420.864C572.534 420.96 572.69 421.128 572.762 421.368L577.298 433.068L581.222 421.368C581.294 421.128 581.438 420.96 581.654 420.864C581.87 420.744 582.086 420.684 582.302 420.684C582.59 420.684 582.926 420.768 583.31 420.936C583.718 421.104 584.066 421.332 584.354 421.62C584.666 421.884 584.822 422.196 584.822 422.556C584.822 422.748 584.786 422.892 584.714 422.988L579.314 437.064C578.93 438.096 578.534 439.14 578.126 440.196C577.718 441.276 577.214 442.26 576.614 443.148C576.038 444.036 575.282 444.744 574.346 445.272C573.434 445.824 572.282 446.1 570.89 446.1ZM593.898 438.288C592.602 438.288 591.39 437.952 590.262 437.28C589.134 436.608 588.222 435.732 587.526 434.652C586.854 433.548 586.518 432.372 586.518 431.124V427.812C586.518 426.54 586.842 425.364 587.49 424.284C588.162 423.204 589.062 422.34 590.19 421.692C591.342 421.044 592.59 420.72 593.934 420.72C595.278 420.72 596.514 421.044 597.642 421.692C598.77 422.316 599.67 423.168 600.342 424.248C601.038 425.304 601.386 426.492 601.386 427.812V431.124C601.386 432.348 601.038 433.512 600.342 434.616C599.67 435.72 598.758 436.608 597.606 437.28C596.478 437.952 595.242 438.288 593.898 438.288ZM593.934 434.94C594.606 434.94 595.218 434.76 595.77 434.4C596.322 434.04 596.766 433.572 597.102 432.996C597.438 432.396 597.606 431.772 597.606 431.124V427.812C597.606 427.188 597.438 426.588 597.102 426.012C596.766 425.436 596.322 424.968 595.77 424.608C595.218 424.248 594.606 424.068 593.934 424.068C593.238 424.068 592.614 424.248 592.062 424.608C591.534 424.968 591.102 425.436 590.766 426.012C590.454 426.588 590.298 427.188 590.298 427.812V431.124C590.298 431.772 590.454 432.396 590.766 432.996C591.102 433.572 591.546 434.04 592.098 434.4C592.65 434.76 593.262 434.94 593.934 434.94ZM611.945 438.288C610.601 438.288 609.353 437.964 608.201 437.316C607.073 436.644 606.173 435.768 605.501 434.688C604.829 433.584 604.493 432.42 604.493 431.196V422.196C604.493 421.884 604.673 421.596 605.033 421.332C605.417 421.068 605.873 420.936 606.401 420.936C606.905 420.936 607.337 421.068 607.697 421.332C608.081 421.596 608.273 421.884 608.273 422.196V431.196C608.273 431.82 608.429 432.42 608.741 432.996C609.077 433.572 609.521 434.04 610.073 434.4C610.649 434.76 611.273 434.94 611.945 434.94C612.617 434.94 613.229 434.76 613.781 434.4C614.333 434.04 614.765 433.572 615.077 432.996C615.413 432.42 615.581 431.82 615.581 431.196V422.16C615.581 421.824 615.773 421.536 616.157 421.296C616.565 421.056 617.009 420.936 617.489 420.936C618.041 420.936 618.485 421.056 618.821 421.296C619.181 421.536 619.361 421.824 619.361 422.16V431.196C619.361 432.468 619.025 433.644 618.353 434.724C617.681 435.804 616.781 436.668 615.653 437.316C614.525 437.964 613.289 438.288 611.945 438.288ZM624.322 438.216C623.698 438.216 623.182 438 622.774 437.568C622.366 437.136 622.162 436.632 622.162 436.056C622.162 435.456 622.366 434.952 622.774 434.544C623.182 434.112 623.698 433.896 624.322 433.896C624.898 433.896 625.39 434.112 625.798 434.544C626.23 434.952 626.446 435.456 626.446 436.056C626.446 436.632 626.23 437.136 625.798 437.568C625.39 438 624.898 438.216 624.322 438.216Z\" fill=\"#FF0082\"/> <mask id=\"mask0_0_6\" style=\"mask-type:luminance\" maskUnits=\"userSpaceOnUse\" x=\"485\" y=\"482\" width=\"195\" height=\"209\"> <path d=\"M562.395 610.189C562.433 610.22 562.453 610.26 562.495 610.288L562.511 610.3C563.061 610.762 563.678 611.161 564.35 611.513L644.72 664.499C645.268 666.469 647.23 672.019 652.149 672.939C654.325 673.35 656.756 673.026 659.111 672.713C662.358 672.283 665.725 671.837 668.222 673.335C671.366 675.226 674.919 684.163 676.418 689.354C676.627 690.079 677.289 690.551 678.008 690.551C678.161 690.551 678.315 690.53 678.468 690.486C679.345 690.233 679.853 689.315 679.6 688.437C679.167 686.936 675.214 673.675 669.926 670.499C666.437 668.402 662.313 668.947 658.675 669.432C656.483 669.723 654.411 669.997 652.761 669.686C649.719 669.115 648.153 664.814 647.795 663.16L641.894 625.041V625.04C641.894 625.038 641.894 625.038 641.892 625.037L632.963 567.363C632.956 567.321 632.929 567.288 632.92 567.247C632.717 566.166 632.347 565.153 631.776 564.234C626.398 555.551 606.572 558.417 586.646 570.757C586.3 570.972 585.975 571.194 585.633 571.41C585.118 568.542 584.41 565.694 583.409 563.319C582.201 560.455 580.35 557.712 578.395 554.809C574.525 549.073 570.141 542.571 568.16 532.05C566.183 521.522 569.195 512.179 571.396 505.358C572.568 501.723 573.494 498.85 573.456 496.58C573.348 490.115 570.064 485.382 569.923 485.183C569.529 484.625 568.834 484.369 568.17 484.529L559.306 486.736C558.775 486.868 558.344 487.254 558.153 487.765C557.963 488.277 558.037 488.849 558.352 489.297C558.38 489.336 561.188 493.383 561.28 498.842C561.309 500.563 560.415 503.335 559.378 506.546C557.069 513.705 553.906 523.51 556.042 534.866C558.146 546.06 562.934 553.161 566.781 558.866C568.727 561.749 570.406 564.24 571.489 566.809C573.035 570.477 573.847 575.55 574.277 579.867C561.995 590.635 556.66 601.715 560.7 608.236C561.158 608.977 561.738 609.617 562.395 610.189ZM594.356 607.773C595.518 609.868 596.123 612.074 596.123 614.495C596.123 618.676 594.358 622.539 591.266 625.289L572.983 613.237C578.959 613.186 586.415 611.297 594.356 607.773ZM629.975 650.811L610.935 638.256C613.047 635.149 616.541 633.266 620.371 633.266C626.671 633.266 631.795 638.39 631.795 644.687C631.795 646.87 631.138 648.987 629.975 650.811ZM632.756 652.645C634.274 650.283 635.105 647.52 635.105 644.688C635.105 636.566 628.494 629.957 620.369 629.957C615.412 629.957 610.895 632.406 608.173 636.437L594.119 627.171C597.517 623.841 599.434 619.337 599.434 614.496C599.434 611.618 598.74 608.899 597.391 606.376C600.175 605.012 603.001 603.471 605.83 601.718C618.18 594.072 627.248 584.841 631.083 576.861L634.309 597.695C631.612 598.519 629.337 600.366 627.81 603.052C626.09 606.078 625.449 609.909 626.007 613.839C626.563 617.753 628.312 621.257 630.933 623.705C633.231 625.85 635.996 626.994 638.851 627.019L643.962 660.031L632.756 652.645ZM638.331 623.675C636.498 623.522 634.714 622.707 633.191 621.284C631.122 619.353 629.734 616.542 629.286 613.372C628.83 610.165 629.327 607.079 630.688 604.687C631.438 603.368 632.741 601.798 634.824 601.014L638.331 623.675ZM569.528 557.019C565.66 551.282 561.276 544.779 559.296 534.259C557.317 523.731 560.331 514.387 562.529 507.564C563.703 503.931 564.629 501.058 564.591 498.789C564.524 494.777 563.235 491.432 562.231 489.422L567.789 488.04C568.622 489.548 570.079 492.732 570.144 496.637C570.174 498.359 569.279 501.132 568.243 504.342C565.933 511.5 562.773 521.307 564.907 532.662C567.012 543.856 571.8 550.956 575.648 556.66C577.593 559.545 579.272 562.036 580.355 564.605C583.008 570.896 583.511 581.337 583.607 584.966L578.033 586.354C577.892 582.016 577.272 572.008 574.542 565.525C573.335 562.662 571.487 559.92 569.528 557.019ZM574.607 584.037C574.755 586.633 574.764 588.413 574.764 588.462C574.764 588.972 574.998 589.453 575.401 589.766C575.694 589.997 576.055 590.117 576.42 590.117C576.553 590.117 576.687 590.1 576.818 590.069L585.685 587.863C586.424 587.679 586.941 587.015 586.941 586.256C586.941 585.903 586.922 580.81 586.181 575.001C586.912 574.52 587.639 574.039 588.392 573.573C607.963 561.453 625.172 559.863 628.961 565.977C632.75 572.092 623.659 586.782 604.087 598.902C587.369 609.255 572.409 611.903 566.029 608.652L564.524 607.661C564.13 607.308 563.783 606.927 563.516 606.498C560.652 601.872 565.185 592.878 574.607 584.037ZM553.247 587.446C553.441 588.048 553.962 588.488 554.589 588.58C554.667 588.591 554.747 588.596 554.826 588.596C555.368 588.596 555.885 588.33 556.195 587.872L561.29 580.377C561.612 579.901 561.668 579.294 561.433 578.769C561.248 578.352 556.762 568.527 547.412 565.318C543.55 563.99 538.846 563.759 533.865 563.514C527.211 563.186 520.332 562.847 515.443 559.803C509.129 555.87 509.361 547.46 509.534 541.322C509.582 539.621 509.623 538.152 509.517 536.953C508.996 530.969 504.949 527.686 504.779 527.551C504.484 527.316 504.124 527.189 503.747 527.189H491.387C490.659 527.189 490.016 527.67 489.804 528.368C489.594 529.067 489.868 529.823 490.475 530.227C490.515 530.255 494.634 533.041 496.178 538.277C496.585 539.656 496.69 541.81 496.812 544.301C497.164 551.517 497.694 562.421 506.921 569.55C514.693 575.558 524.809 575.639 532.937 575.706C537.596 575.742 541.621 575.776 544.086 576.864C550.712 579.789 553.222 587.37 553.247 587.446ZM532.963 572.394C524.934 572.329 515.834 572.255 508.944 566.93C500.926 560.735 500.461 551.145 500.119 544.141C499.987 541.435 499.875 539.1 499.354 537.341C498.491 534.409 496.994 532.13 495.598 530.5H503.096C503.946 531.357 505.906 533.694 506.217 537.24C506.307 538.248 506.268 539.629 506.223 541.226C506.04 547.777 505.764 557.675 513.693 562.61C519.311 566.109 526.628 566.47 533.701 566.818C538.44 567.051 542.916 567.271 546.335 568.444C552.879 570.692 556.791 577.063 558.002 579.317L555.147 583.52C553.625 580.564 550.604 576.12 545.424 573.83C542.331 572.468 537.99 572.435 532.963 572.394ZM508.261 582.219C507.727 582.465 507.364 582.978 507.309 583.565L506.483 592.204C506.423 592.823 506.717 593.425 507.245 593.759C507.514 593.931 507.822 594.015 508.13 594.015C508.422 594.015 508.716 593.938 508.976 593.782C512.873 591.466 517.023 591.135 521.658 592.765C522.116 592.928 522.627 592.877 523.055 592.627C523.476 592.377 523.765 591.951 523.843 591.466L525.289 582.442C525.426 581.584 524.878 580.767 524.032 580.569C518.669 579.313 513.36 579.864 508.261 582.219ZM520.873 589.07C517.08 588.093 513.459 588.266 510.059 589.583L510.511 584.847C514.173 583.328 517.948 582.878 521.765 583.495L520.873 589.07ZM533.557 515.736C533.745 515.736 533.935 515.703 534.115 515.638L540.4 513.391C541.06 513.154 541.498 512.529 541.498 511.832C541.49 503.643 539.504 497.624 535.425 493.433C535.087 493.084 534.611 492.917 534.129 492.934L525.542 493.508C524.924 493.55 524.381 493.934 524.133 494.502C523.885 495.069 523.975 495.727 524.367 496.207C529.01 501.897 531.476 507.782 531.905 514.192C531.939 514.709 532.216 515.181 532.65 515.466C532.925 515.643 533.239 515.736 533.557 515.736ZM528.827 496.605L533.56 496.29C536.489 499.622 538.004 504.342 538.17 510.671L534.989 511.81C534.268 506.506 532.203 501.411 528.827 496.605ZM591.02 559.868C591.296 560.468 591.892 560.832 592.525 560.832C592.683 560.832 592.844 560.809 593.005 560.761L602.575 557.862C603.067 557.712 603.461 557.343 603.645 556.862C603.825 556.381 603.773 555.844 603.504 555.405C603.437 555.299 596.907 544.596 596.298 532.249C595.935 524.892 598.005 517.159 599.834 510.337C601.149 505.417 602.286 501.171 602.276 497.888C602.245 490.162 598.78 483.202 598.631 482.909C598.348 482.353 597.778 482 597.153 482H588.008C587.433 482 586.9 482.3 586.598 482.788C586.296 483.276 586.271 483.887 586.527 484.401C586.562 484.466 589.793 490.978 589.818 497.903C589.829 500.742 588.745 504.794 587.488 509.485C585.598 516.542 583.458 524.54 583.847 532.413C584.491 545.529 590.753 559.288 591.02 559.868ZM590.687 510.338C592.003 505.419 593.141 501.171 593.129 497.89C593.109 492.805 591.6 488.05 590.532 485.311H596.089C596.97 487.345 598.944 492.496 598.963 497.901C598.972 500.741 597.889 504.791 596.633 509.481C594.743 516.539 592.603 524.538 592.99 532.412C593.495 542.632 597.646 551.552 599.638 555.293L593.458 557.165C591.901 553.439 587.658 542.465 587.155 532.249C586.791 524.893 588.86 517.161 590.687 510.338ZM619.099 507.856L625.348 509.729C625.504 509.776 625.662 509.799 625.823 509.799C626.166 509.799 626.505 509.693 626.79 509.488C627.207 509.188 627.46 508.712 627.478 508.199C627.625 503.647 629.686 499.7 633.784 496.137C634.2 495.777 634.409 495.23 634.34 494.684C634.272 494.138 633.936 493.659 633.443 493.411L626.014 489.662C625.348 489.323 624.527 489.477 624.027 490.043C620.212 494.363 618.159 499.802 617.92 506.209C617.891 506.962 618.375 507.639 619.099 507.856ZM625.699 493.211L629.853 495.306C626.779 498.5 624.937 502.075 624.358 505.975L621.304 505.06C621.679 500.459 623.155 496.485 625.699 493.211ZM631.702 540.31C631.541 539.888 631.214 539.55 630.799 539.377L623.935 536.495C623.12 536.156 622.176 536.512 621.797 537.314C619.538 542.101 618.77 547.687 619.515 553.917C619.596 554.584 620.073 555.139 620.721 555.318L627.125 557.07C627.269 557.108 627.417 557.128 627.562 557.128C627.953 557.128 628.338 556.989 628.643 556.727C629.061 556.367 629.27 555.823 629.206 555.277C628.53 549.64 629.641 545.866 631.653 541.609C631.847 541.201 631.865 540.729 631.702 540.31ZM625.722 553.251L622.689 552.421C622.285 547.887 622.781 543.782 624.171 540.181L627.95 541.768C626.45 545.27 625.537 548.775 625.722 553.251ZM536.706 543.809C537.556 544.205 538.421 544.404 539.253 544.404C540.104 544.404 540.916 544.196 541.632 543.782C543.048 542.965 543.954 541.416 544.118 539.533C544.263 537.843 543.814 535.996 542.858 534.336C541.9 532.678 540.525 531.367 538.987 530.648C537.271 529.843 535.479 529.854 534.06 530.672C532.645 531.489 531.739 533.039 531.575 534.923C531.429 536.615 531.878 538.462 532.835 540.12C533.793 541.778 535.168 543.089 536.706 543.809ZM535.716 533.54C535.944 533.409 536.193 533.36 536.438 533.36C536.88 533.36 537.309 533.521 537.581 533.649C538.498 534.076 539.375 534.931 539.988 535.993C540.6 537.056 540.904 538.241 540.816 539.251C540.778 539.714 540.614 540.549 539.974 540.919C539.34 541.287 538.533 541.012 538.109 540.813C537.191 540.384 536.315 539.53 535.703 538.468C535.091 537.405 534.787 536.221 534.876 535.211C534.915 534.742 535.078 533.908 535.716 533.54ZM634.314 521.448C635.386 521.448 636.495 521.093 637.518 520.406C638.927 519.457 640.082 517.951 640.771 516.163C642.301 512.202 641.129 508.185 638.102 507.019C635.07 505.848 631.507 508.036 629.978 511.999C628.449 515.958 629.623 519.973 632.648 521.14C633.178 521.346 633.741 521.448 634.314 521.448ZM633.064 513.19C633.846 511.165 635.333 510.022 636.427 510.022C636.599 510.022 636.759 510.05 636.906 510.107C637.998 510.528 638.585 512.629 637.681 514.971C637.681 514.971 637.681 514.971 637.681 514.972C637.239 516.115 636.506 517.095 635.666 517.661C635.279 517.919 634.528 518.316 633.839 518.053C632.749 517.631 632.161 515.53 633.064 513.19ZM606.363 541.995C606.814 543.83 607.948 545.222 609.474 545.812C610.006 546.017 610.569 546.12 611.142 546.12C612.213 546.12 613.322 545.766 614.346 545.077C615.754 544.128 616.91 542.622 617.599 540.835C619.129 536.874 617.957 532.858 614.93 531.691C613.408 531.106 611.63 531.37 610.06 532.428C608.652 533.377 607.496 534.883 606.807 536.67C606.115 538.455 605.958 540.347 606.363 541.995ZM609.893 537.859C610.335 536.717 611.069 535.737 611.908 535.17C612.207 534.971 612.719 534.689 613.251 534.689C613.414 534.689 613.575 534.715 613.736 534.777C614.828 535.199 615.415 537.299 614.511 539.642C614.511 539.642 614.511 539.642 614.511 539.643C614.069 540.785 613.335 541.765 612.496 542.331C612.108 542.589 611.357 542.987 610.668 542.724C609.98 542.458 609.69 541.657 609.579 541.204C609.337 540.224 609.451 539.002 609.893 537.859ZM603.088 590.068C603.62 590.068 604.148 589.974 604.657 589.778C606.212 589.18 607.332 587.702 607.726 585.724C608.07 583.989 607.855 581.978 607.118 580.063C605.469 575.78 601.81 573.336 598.778 574.5C595.75 575.664 594.67 579.933 596.319 584.216C597.689 587.778 600.454 590.068 603.088 590.068ZM599.967 577.589C600.091 577.541 600.226 577.518 600.367 577.518C601.491 577.518 603.139 578.941 604.027 581.253C604.535 582.571 604.699 583.966 604.478 585.078C604.308 585.919 603.943 586.508 603.469 586.689C602.359 587.118 600.409 585.63 599.409 583.029C598.406 580.423 598.877 578.008 599.967 577.589ZM576.404 603.795C577.818 604.721 579.384 605.17 580.845 605.17C582.784 605.17 584.543 604.378 585.539 602.859C586.422 601.512 586.579 599.765 585.97 598.071C585.412 596.518 584.266 595.112 582.743 594.114C581.221 593.118 579.493 592.633 577.824 592.741C576.027 592.861 574.491 593.704 573.608 595.051C571.861 597.721 573.116 601.643 576.404 603.795ZM576.379 596.865C576.802 596.218 577.605 596.073 578.045 596.045C578.125 596.039 578.205 596.036 578.283 596.036C579.147 596.036 580.096 596.339 580.929 596.885C581.842 597.481 582.544 598.321 582.855 599.191C583.005 599.607 583.191 600.399 582.769 601.044C582.045 602.146 579.92 602.139 578.221 601.025C576.519 599.911 575.658 597.968 576.379 596.865ZM585.027 510.121C584.577 508.286 583.443 506.894 581.916 506.305C580.39 505.715 578.615 505.985 577.046 507.039C575.638 507.988 574.482 509.495 573.793 511.282C573.103 513.07 572.945 514.962 573.351 516.61C573.802 518.445 574.936 519.837 576.462 520.426C576.994 520.632 577.557 520.734 578.129 520.734C579.201 520.734 580.31 520.381 581.333 519.692C582.743 518.743 583.899 517.238 584.588 515.45C585.277 513.662 585.435 511.771 585.027 510.121ZM581.499 514.256C581.057 515.4 580.324 516.38 579.484 516.946C579.096 517.204 578.345 517.603 577.657 517.338C576.968 517.073 576.677 516.273 576.567 515.819C576.325 514.837 576.44 513.618 576.882 512.474C577.324 511.332 578.057 510.351 578.897 509.786C579.195 509.587 579.705 509.306 580.239 509.306C580.401 509.306 580.564 509.332 580.724 509.393C581.413 509.658 581.702 510.46 581.814 510.913C582.055 511.894 581.939 513.114 581.499 514.256ZM609.474 498.917C610.006 499.123 610.567 499.225 611.142 499.225C612.212 499.225 613.322 498.872 614.346 498.182C615.754 497.233 616.91 495.727 617.599 493.939C618.289 492.154 618.446 490.262 618.041 488.613C617.591 486.777 616.456 485.385 614.93 484.796C613.404 484.206 611.627 484.477 610.06 485.53C608.652 486.479 607.496 487.987 606.807 489.773C606.116 491.561 605.959 493.453 606.365 495.101C606.816 496.936 607.948 498.329 609.474 498.917ZM609.893 490.965C610.335 489.823 611.069 488.841 611.908 488.275C612.207 488.076 612.716 487.796 613.251 487.796C613.414 487.796 613.575 487.822 613.736 487.883C614.425 488.147 614.715 488.948 614.825 489.403C615.068 490.384 614.952 491.603 614.511 492.747C614.511 492.747 614.511 492.747 614.511 492.748C614.069 493.891 613.335 494.871 612.496 495.437C612.108 495.698 611.355 496.096 610.668 495.831C609.98 495.566 609.69 494.765 609.579 494.312C609.337 493.33 609.451 492.109 609.893 490.965ZM496.319 513.458C495.793 515.007 496.134 516.768 497.254 518.293C498.258 519.66 499.814 520.753 501.628 521.37C502.695 521.732 503.756 521.903 504.762 521.903C507.547 521.903 509.892 520.583 510.658 518.328C511.184 516.779 510.844 515.017 509.725 513.493C508.719 512.127 507.165 511.034 505.349 510.416C501.333 509.05 497.363 510.386 496.319 513.458ZM507.056 515.455C507.332 515.832 507.761 516.565 507.522 517.264C507.149 518.371 505.073 519.047 502.692 518.235C501.532 517.841 500.522 517.148 499.923 516.334C499.646 515.956 499.218 515.222 499.456 514.524C499.715 513.756 500.796 513.197 502.228 513.197C502.859 513.197 503.558 513.304 504.285 513.552C505.446 513.946 506.454 514.641 507.056 515.455ZM494.271 570.434C490.255 569.069 486.286 570.405 485.241 573.478C484.716 575.027 485.058 576.789 486.177 578.311C487.181 579.678 488.737 580.77 490.551 581.388C491.617 581.75 492.679 581.921 493.685 581.921C496.47 581.921 498.815 580.602 499.583 578.345C500.108 576.796 499.767 575.036 498.648 573.51C497.639 572.144 496.086 571.051 494.271 570.434ZM496.446 577.28C496.068 578.389 493.993 579.06 491.614 578.252C490.454 577.857 489.443 577.164 488.844 576.35C488.567 575.974 488.138 575.239 488.377 574.541C488.637 573.772 489.718 573.214 491.15 573.214C491.781 573.214 492.48 573.321 493.207 573.569C494.367 573.962 495.377 574.657 495.976 575.471C496.254 575.848 496.682 576.585 496.446 577.28ZM539.705 589.689C537.894 589.073 535.998 588.993 534.361 589.467C532.544 589.991 531.201 591.183 530.675 592.732C530.148 594.281 530.489 596.042 531.608 597.565C532.614 598.933 534.168 600.025 535.983 600.643C537.016 600.993 538.075 601.169 539.099 601.169C539.872 601.169 540.624 601.066 541.327 600.863C543.146 600.338 544.489 599.148 545.015 597.599C545.541 596.049 545.198 594.288 544.082 592.764C543.074 591.398 541.522 590.306 539.705 589.689ZM541.879 596.536C541.642 597.233 540.856 597.554 540.407 597.683C539.437 597.968 538.215 597.901 537.049 597.506C535.889 597.112 534.879 596.419 534.28 595.605C534.004 595.228 533.575 594.493 533.813 593.795C534.05 593.097 534.837 592.775 535.286 592.646C535.684 592.53 536.127 592.474 536.588 592.474C537.251 592.474 537.956 592.592 538.642 592.825C539.802 593.219 540.814 593.913 541.412 594.727C541.689 595.102 542.115 595.837 541.879 596.536Z\" fill=\"white\"/> </mask> <g mask=\"url(#mask0_0_6)\"> <path d=\"M484.716 482V690.55H679.853V482H484.716Z\" fill=\"url(#paint0_linear_0_6)\"/> </g> <mask id=\"mask1_0_6\" style=\"mask-type:luminance\" maskUnits=\"userSpaceOnUse\" x=\"11\" y=\"13\" width=\"125\" height=\"133\"> <path d=\"M85.7909 64.2494C85.7665 64.2299 85.754 64.2042 85.7275 64.1861L85.7171 64.1784C85.3662 63.8839 84.9729 63.6298 84.544 63.405L33.2893 29.6141C32.9398 28.3581 31.6887 24.8187 28.5517 24.2318C27.1642 23.9694 25.6138 24.1761 24.1121 24.376C22.041 24.6503 19.8939 24.9343 18.3017 23.9791C16.2967 22.7733 14.0306 17.0736 13.0748 13.7633C12.9411 13.301 12.5192 13.0002 12.0604 13.0002C11.9629 13.0002 11.8648 13.0135 11.7673 13.0413C11.2083 13.2028 10.8839 13.7883 11.0454 14.3481C11.3217 15.3053 13.8426 23.7626 17.215 25.7878C19.44 27.1252 22.0702 26.7778 24.3899 26.468C25.7878 26.2828 27.1092 26.1081 28.1618 26.3065C30.1014 26.6706 31.1004 29.4136 31.3288 30.4683L35.0917 54.7778V54.7785C35.0917 54.7799 35.0917 54.7799 35.0931 54.7806L40.7872 91.5609C40.7921 91.588 40.8088 91.6089 40.8151 91.6354C40.9445 92.3246 41.1806 92.9707 41.5447 93.5569C44.9741 99.0943 57.6176 97.2661 70.3251 89.3964C70.5458 89.2593 70.7532 89.118 70.9711 88.9801C71.2997 90.809 71.7516 92.6254 72.39 94.1403C73.16 95.9664 74.3407 97.7159 75.5876 99.567C78.0555 103.226 80.8514 107.372 82.1143 114.081C83.3751 120.795 81.4543 126.754 80.0508 131.104C79.3031 133.422 78.7127 135.254 78.7371 136.702C78.806 140.825 80.9002 143.843 80.99 143.97C81.2413 144.326 81.6848 144.489 82.1081 144.387L87.7611 142.98C88.0994 142.896 88.3744 142.649 88.4963 142.323C88.6174 141.997 88.5701 141.632 88.3696 141.347C88.3515 141.322 86.5609 138.741 86.5024 135.259C86.4836 134.162 87.0538 132.394 87.7151 130.346C89.1876 125.781 91.2044 119.527 89.8427 112.286C88.5005 105.147 85.447 100.618 82.9936 96.98C81.753 95.1414 80.6823 93.5527 79.9916 91.9145C79.0058 89.5754 78.4879 86.3402 78.2136 83.5867C86.0464 76.7195 89.4487 69.6539 86.8721 65.4949C86.5797 65.0222 86.21 64.6142 85.7909 64.2494ZM65.4086 65.7901C64.6672 64.4541 64.2815 63.0471 64.2815 61.5037C64.2815 58.8373 65.4072 56.3735 67.3788 54.6198L79.0386 62.3057C75.2276 62.3384 70.4727 63.5428 65.4086 65.7901ZM42.6927 38.3436L54.8356 46.3504C53.4885 48.3318 51.26 49.5327 48.8177 49.5327C44.8 49.5327 41.5321 46.2648 41.5321 42.2492C41.5321 40.8568 41.9512 39.5069 42.6927 38.3436ZM40.9195 37.174C39.9511 38.6805 39.4213 40.4426 39.4213 42.2485C39.4213 47.4281 43.6374 51.6429 48.8191 51.6429C51.9805 51.6429 54.8606 50.0813 56.5969 47.5103L65.5597 53.4195C63.3924 55.5429 62.1699 58.4154 62.1699 61.503C62.1699 63.3381 62.6127 65.0723 63.4732 66.6812C61.6972 67.5508 59.8955 68.5338 58.091 69.6518C50.215 74.5279 44.4318 80.4149 41.986 85.504L39.9288 72.2173C41.6491 71.6917 43.0999 70.5137 44.0739 68.8011C45.1704 66.8713 45.5791 64.4283 45.2233 61.9221C44.869 59.4255 43.7537 57.1908 42.0821 55.6299C40.6166 54.2619 38.8532 53.5323 37.0327 53.5163L33.7731 32.4636L40.9195 37.174ZM37.3641 55.6487C38.533 55.7469 39.6705 56.2662 40.6417 57.1741C41.9617 58.4056 42.8465 60.1983 43.1327 62.2193C43.423 64.2647 43.1062 66.2329 42.2381 67.7582C41.7598 68.5992 40.9292 69.601 39.6009 70.1009L37.3641 55.6487ZM81.242 98.158C83.7086 101.816 86.5045 105.964 87.7674 112.673C89.0296 119.387 87.1074 125.345 85.7053 129.697C84.9569 132.014 84.3665 133.846 84.3909 135.293C84.4333 137.852 85.2555 139.985 85.8953 141.267L82.351 142.148C81.8198 141.187 80.8904 139.156 80.8493 136.666C80.8299 135.568 81.4007 133.799 82.0614 131.752C83.5345 127.187 85.55 120.932 84.189 113.691C82.8467 106.553 79.7932 102.025 77.3392 98.387C76.0986 96.547 75.0278 94.9583 74.3372 93.3201C72.6455 89.308 72.3245 82.6497 72.2633 80.3349L75.818 79.45C75.9078 82.2166 76.3032 88.5986 78.0444 92.7333C78.8144 94.5594 79.993 96.3075 81.242 98.158ZM78.0033 80.9273C77.9086 79.2718 77.9031 78.137 77.9031 78.1057C77.9031 77.7805 77.7534 77.4735 77.4965 77.2737C77.3099 77.1268 77.0795 77.0502 76.847 77.0502C76.762 77.0502 76.6764 77.0607 76.5929 77.0809L70.9384 78.4879C70.4671 78.6048 70.1371 79.0281 70.1371 79.5126C70.1371 79.7375 70.1496 82.9852 70.6217 86.6903C70.1559 86.9967 69.6922 87.3037 69.2119 87.601C56.7306 95.33 45.7559 96.3444 43.3394 92.445C40.923 88.545 46.7208 79.1771 59.2028 71.4473C69.8642 64.8454 79.4048 63.1564 83.4733 65.2297L84.4333 65.8618C84.6846 66.0867 84.906 66.3296 85.0759 66.6032C86.9027 69.5537 84.0114 75.2896 78.0033 80.9273ZM91.6249 78.7538C91.501 78.3695 91.1689 78.089 90.7693 78.0305C90.7192 78.0235 90.6684 78.02 90.6183 78.02C90.2722 78.02 89.943 78.1899 89.7452 78.4816L86.4954 83.2616C86.2901 83.5652 86.2545 83.9522 86.4042 84.2871C86.5226 84.5531 89.3832 90.8187 95.3461 92.8655C97.8092 93.7121 100.809 93.8597 103.986 94.0156C108.229 94.2252 112.616 94.441 115.734 96.3827C119.761 98.8904 119.612 104.254 119.502 108.168C119.472 109.253 119.445 110.19 119.513 110.955C119.846 114.771 122.426 116.865 122.535 116.951C122.723 117.101 122.953 117.181 123.193 117.181H131.075C131.539 117.181 131.95 116.875 132.085 116.429C132.219 115.984 132.044 115.501 131.657 115.244C131.631 115.226 129.005 113.45 128.02 110.11C127.761 109.231 127.693 107.857 127.616 106.269C127.391 101.667 127.053 94.7125 121.168 90.1664C116.212 86.3346 109.761 86.2831 104.578 86.2406C101.606 86.2176 99.0393 86.1961 97.4674 85.502C93.2415 83.6369 91.641 78.8018 91.6249 78.7538ZM104.561 88.3528C109.681 88.3939 115.485 88.4413 119.878 91.8373C124.992 95.7881 125.288 101.904 125.506 106.371C125.591 108.096 125.662 109.585 125.994 110.707C126.545 112.577 127.5 114.03 128.39 115.07H123.608C123.066 114.523 121.816 113.033 121.617 110.771C121.56 110.129 121.585 109.248 121.614 108.23C121.73 104.052 121.906 97.7396 116.85 94.5921C113.267 92.3608 108.601 92.1304 104.09 91.909C101.068 91.76 98.2137 91.6201 96.0332 90.8717C91.8596 89.4382 89.3651 85.3753 88.5923 83.9376L90.4136 81.2573C91.3841 83.1426 93.3104 85.9768 96.6138 87.4367C98.5868 88.3055 101.355 88.3264 104.561 88.3528ZM120.314 82.0872C120.655 81.9298 120.886 81.6026 120.921 81.2288L121.448 75.7191C121.487 75.3244 121.299 74.9408 120.962 74.7278C120.79 74.6178 120.594 74.5641 120.398 74.5641C120.211 74.5641 120.024 74.6136 119.858 74.7131C117.373 76.1898 114.727 76.4007 111.771 75.3613C111.478 75.2576 111.152 75.2903 110.879 75.4497C110.611 75.6091 110.427 75.8806 110.377 76.1898L109.455 81.9444C109.367 82.4916 109.717 83.0131 110.256 83.1391C113.677 83.9404 117.062 83.5888 120.314 82.0872ZM112.271 77.7179C114.69 78.341 116.999 78.2303 119.168 77.3907L118.879 80.4107C116.544 81.3798 114.136 81.6667 111.702 81.2733L112.271 77.7179ZM104.182 124.486C104.062 124.486 103.941 124.507 103.826 124.548L99.8177 125.981C99.3972 126.132 99.118 126.53 99.118 126.975C99.1229 132.197 100.389 136.036 102.991 138.709C103.206 138.932 103.51 139.038 103.817 139.027L109.293 138.661C109.688 138.634 110.034 138.389 110.192 138.027C110.35 137.665 110.293 137.246 110.043 136.94C107.082 133.311 105.509 129.558 105.235 125.47C105.214 125.14 105.037 124.839 104.761 124.658C104.585 124.545 104.385 124.486 104.182 124.486ZM107.199 136.686L104.18 136.887C102.312 134.762 101.346 131.752 101.24 127.715L103.269 126.989C103.729 130.372 105.045 133.621 107.199 136.686ZM67.5361 96.3409C67.36 95.958 66.9799 95.7262 66.5761 95.7262C66.4752 95.7262 66.3728 95.7408 66.2698 95.7714L60.167 97.6205C59.853 97.7159 59.6017 97.9512 59.4847 98.2582C59.3699 98.5645 59.4026 98.9071 59.5745 99.1869C59.617 99.2545 63.7816 106.081 64.1701 113.954C64.4012 118.646 63.0812 123.578 61.9151 127.928C61.0762 131.066 60.3515 133.774 60.3577 135.868C60.3772 140.795 62.5869 145.233 62.6823 145.42C62.8626 145.775 63.226 146 63.625 146H69.4569C69.8231 146 70.1636 145.809 70.3557 145.497C70.5485 145.186 70.5646 144.796 70.401 144.469C70.3787 144.427 68.3187 140.275 68.3026 135.858C68.2957 134.048 68.987 131.464 69.7883 128.472C70.9934 123.971 72.3586 118.871 72.1101 113.85C71.6993 105.485 67.706 96.7106 67.5361 96.3409ZM67.7485 127.928C66.9089 131.065 66.1834 133.774 66.1911 135.866C66.2036 139.109 67.1658 142.142 67.8473 143.888H64.303C63.7412 142.591 62.4825 139.306 62.4707 135.859C62.4644 134.049 63.155 131.466 63.9563 128.474C65.1614 123.973 66.5267 118.872 66.2795 113.851C65.9572 107.333 63.3103 101.644 62.0397 99.2586L65.9809 98.0647C66.9743 100.441 69.6797 107.44 70.0006 113.954C70.2332 118.645 68.9132 123.576 67.7485 127.928ZM49.6288 129.511L45.6438 128.316C45.5443 128.286 45.4433 128.272 45.341 128.272C45.1224 128.272 44.9059 128.339 44.7242 128.47C44.4582 128.661 44.2967 128.965 44.2856 129.292C44.1916 132.195 42.8772 134.712 40.2637 136.984C39.9984 137.214 39.8655 137.563 39.9093 137.911C39.9525 138.259 40.1669 138.565 40.4816 138.723L45.2191 141.113C45.6438 141.33 46.1674 141.232 46.4862 140.87C48.9194 138.116 50.2282 134.647 50.3807 130.561C50.3995 130.081 50.0904 129.649 49.6288 129.511ZM45.4196 138.85L42.7706 137.514C44.7311 135.477 45.9056 133.198 46.2753 130.71L48.2225 131.294C47.9837 134.228 47.0425 136.762 45.4196 138.85ZM41.5913 108.814C41.6943 109.083 41.9025 109.298 42.1677 109.409L46.5447 111.247C47.0647 111.463 47.6669 111.236 47.9085 110.724C49.3489 107.671 49.839 104.109 49.3635 100.136C49.312 99.7105 49.0078 99.3568 48.5943 99.2426L44.5104 98.1252C44.4185 98.1009 44.3245 98.0883 44.2319 98.0883C43.9827 98.0883 43.737 98.1768 43.5427 98.3438C43.2761 98.5736 43.1424 98.9203 43.1835 99.2691C43.6144 102.863 42.9057 105.27 41.6226 107.985C41.4994 108.246 41.4876 108.546 41.5913 108.814ZM45.405 100.561L47.3397 101.09C47.5973 103.982 47.2806 106.599 46.3943 108.896L43.9841 107.884C44.9407 105.65 45.5234 103.416 45.405 100.561ZM102.174 106.583C101.632 106.33 101.08 106.203 100.549 106.203C100.007 106.203 99.4891 106.335 99.0324 106.599C98.1294 107.121 97.5516 108.109 97.4472 109.309C97.3546 110.387 97.6407 111.565 98.2506 112.623C98.8611 113.681 99.7383 114.517 100.719 114.976C101.814 115.489 102.956 115.482 103.861 114.96C104.763 114.439 105.341 113.45 105.446 112.25C105.539 111.17 105.253 109.992 104.642 108.935C104.032 107.877 103.155 107.041 102.174 106.583ZM102.805 113.131C102.66 113.214 102.501 113.246 102.345 113.246C102.063 113.246 101.789 113.143 101.616 113.062C101.031 112.789 100.471 112.244 100.081 111.567C99.6903 110.889 99.4967 110.133 99.5524 109.489C99.5768 109.194 99.6812 108.661 100.09 108.425C100.494 108.191 101.009 108.366 101.279 108.493C101.864 108.766 102.423 109.311 102.813 109.988C103.204 110.666 103.397 111.422 103.341 112.066C103.316 112.364 103.212 112.896 102.805 113.131ZM39.926 120.843C39.2424 120.843 38.535 121.069 37.8827 121.507C36.9839 122.112 36.2474 123.073 35.8081 124.213C34.832 126.739 35.5797 129.301 37.5103 130.045C39.4436 130.791 41.7159 129.396 42.6913 126.869C43.6659 124.344 42.9175 121.783 40.9884 121.039C40.6501 120.908 40.2915 120.843 39.926 120.843ZM40.7232 126.109C40.224 127.401 39.2758 128.13 38.5782 128.13C38.4689 128.13 38.3666 128.111 38.2726 128.075C37.5764 127.807 37.2018 126.467 37.7783 124.973C37.7783 124.973 37.7783 124.973 37.7783 124.972C38.0602 124.243 38.5281 123.619 39.0634 123.258C39.3106 123.093 39.7896 122.84 40.2289 123.008C40.9237 123.277 41.2989 124.617 40.7232 126.109ZM57.7512 107.739C57.4637 106.569 56.7404 105.681 55.7671 105.305C55.428 105.174 55.0688 105.109 54.7033 105.109C54.0203 105.109 53.313 105.334 52.66 105.774C51.7619 106.379 51.0247 107.339 50.5854 108.479C49.61 111.005 50.357 113.566 52.2875 114.31C53.258 114.683 54.3921 114.515 55.3932 113.84C56.2913 113.235 57.0286 112.275 57.4679 111.135C57.9093 109.997 58.0095 108.79 57.7512 107.739ZM55.4997 110.377C55.2178 111.105 54.75 111.73 54.2146 112.091C54.0245 112.219 53.698 112.398 53.3583 112.398C53.2545 112.398 53.1515 112.382 53.0492 112.342C52.353 112.073 51.9784 110.734 52.5549 109.24C52.5549 109.24 52.5549 109.24 52.5549 109.239C52.8368 108.511 53.3047 107.886 53.84 107.525C54.0872 107.36 54.5662 107.107 55.0055 107.275C55.4447 107.444 55.6292 107.955 55.7002 108.244C55.8548 108.869 55.7817 109.648 55.4997 110.377ZM59.8398 77.0816C59.5007 77.0816 59.1638 77.1414 58.8394 77.2661C57.8473 77.6476 57.133 78.5902 56.8817 79.8517C56.6624 80.9579 56.7995 82.2403 57.2695 83.4621C58.3214 86.1933 60.655 87.752 62.5883 87.0099C64.5196 86.2671 65.2081 83.545 64.1568 80.8131C63.2831 78.5415 61.5197 77.0816 59.8398 77.0816ZM61.8302 85.0397C61.7508 85.0703 61.6652 85.0849 61.5747 85.0849C60.8583 85.0849 59.8071 84.1771 59.2411 82.7033C58.9166 81.8623 58.8122 80.9726 58.9535 80.2638C59.0614 79.7271 59.2947 79.3518 59.5968 79.2363C60.3048 78.9627 61.5482 79.9116 62.1859 81.5706C62.8257 83.2324 62.525 84.7724 61.8302 85.0397ZM76.8567 68.327C75.9551 67.7366 74.9568 67.4505 74.0246 67.4505C72.7882 67.4505 71.6666 67.9552 71.031 68.9243C70.4685 69.7834 70.3682 70.8973 70.7567 71.9778C71.1125 72.9678 71.8435 73.8645 72.8146 74.5008C73.7851 75.1364 74.8872 75.4455 75.9517 75.3766C77.0976 75.3 78.0771 74.7626 78.6403 73.9035C79.7542 72.2006 78.9536 69.6999 76.8567 68.327ZM76.8727 72.7464C76.6033 73.1592 76.0909 73.2518 75.8103 73.2699C75.7595 73.2734 75.7087 73.2755 75.6586 73.2755C75.1079 73.2755 74.5022 73.082 73.971 72.7339C73.389 72.3538 72.9413 71.8184 72.7429 71.2635C72.6476 70.9983 72.5285 70.4928 72.7979 70.0814C73.2595 69.3789 74.615 69.3831 75.6982 70.0939C76.7836 70.804 77.3329 72.0433 76.8727 72.7464ZM71.3575 128.066C71.645 129.236 72.3677 130.124 73.3417 130.5C74.3149 130.876 75.4469 130.704 76.4473 130.032C77.3454 129.427 78.0827 128.466 78.522 127.326C78.962 126.186 79.0629 124.979 78.8039 123.928C78.5164 122.758 77.7931 121.87 76.8198 121.494C76.4808 121.363 76.1215 121.298 75.7567 121.298C75.0731 121.298 74.3657 121.523 73.7134 121.963C72.8146 122.568 72.0774 123.528 71.6381 124.668C71.1981 125.808 71.0978 127.014 71.3575 128.066ZM73.6076 125.429C73.8896 124.699 74.3574 124.075 74.8928 123.714C75.1399 123.549 75.6189 123.295 76.0582 123.464C76.4975 123.633 76.6827 124.143 76.753 124.433C76.9075 125.059 76.8337 125.836 76.5525 126.566C76.2705 127.294 75.8027 127.919 75.2673 128.28C75.0773 128.407 74.7521 128.586 74.411 128.586C74.308 128.586 74.2042 128.57 74.1019 128.531C73.6626 128.361 73.4781 127.85 73.4071 127.561C73.2532 126.936 73.327 126.157 73.6076 125.429ZM55.7671 135.211C55.428 135.08 55.0702 135.015 54.7033 135.015C54.021 135.015 53.313 135.24 52.66 135.68C51.7619 136.285 51.0247 137.246 50.5854 138.386C50.1454 139.525 50.0451 140.731 50.3034 141.782C50.5909 142.953 51.3143 143.841 52.2875 144.217C53.2608 144.593 54.3942 144.42 55.3932 143.749C56.2913 143.144 57.0286 142.182 57.4679 141.043C57.9086 139.903 58.0088 138.696 57.7498 137.645C57.4623 136.475 56.7404 135.586 55.7671 135.211ZM55.4997 140.283C55.2178 141.011 54.75 141.637 54.2146 141.998C54.0245 142.125 53.6994 142.304 53.3583 142.304C53.2545 142.304 53.1515 142.287 53.0492 142.248C52.6099 142.08 52.4247 141.569 52.3544 141.279C52.1998 140.653 52.2736 139.876 52.5549 139.146C52.5549 139.146 52.5549 139.146 52.5549 139.145C52.8368 138.416 53.3047 137.792 53.84 137.431C54.0872 137.264 54.5676 137.011 55.0055 137.179C55.4447 137.348 55.6292 137.859 55.7002 138.148C55.8548 138.774 55.7817 139.553 55.4997 140.283ZM127.93 125.938C128.265 124.95 128.048 123.827 127.334 122.855C126.693 121.983 125.701 121.286 124.544 120.893C123.864 120.662 123.187 120.552 122.545 120.552C120.769 120.552 119.274 121.395 118.785 122.832C118.45 123.82 118.667 124.944 119.381 125.916C120.022 126.787 121.013 127.484 122.171 127.878C124.732 128.749 127.264 127.897 127.93 125.938ZM121.083 124.665C120.907 124.424 120.633 123.957 120.785 123.511C121.024 122.805 122.347 122.374 123.865 122.891C124.605 123.143 125.249 123.585 125.632 124.104C125.808 124.345 126.081 124.813 125.93 125.258C125.764 125.748 125.075 126.104 124.161 126.104C123.759 126.104 123.313 126.036 122.85 125.878C122.11 125.627 121.466 125.184 121.083 124.665ZM129.236 89.6025C131.797 90.4734 134.328 89.6213 134.995 87.6615C135.33 86.6736 135.112 85.55 134.398 84.5795C133.758 83.7072 132.765 83.011 131.608 82.617C130.928 82.3858 130.252 82.2772 129.61 82.2772C127.834 82.2772 126.338 83.1182 125.848 84.5572C125.513 85.5451 125.731 86.6681 126.445 87.6406C127.088 88.5123 128.079 89.2092 129.236 89.6025ZM127.849 85.2367C128.09 84.5294 129.413 84.1012 130.93 84.6171C131.67 84.8684 132.315 85.3105 132.697 85.8299C132.873 86.0694 133.147 86.5386 132.995 86.9834C132.829 87.4736 132.14 87.83 131.226 87.83C130.824 87.83 130.378 87.7618 129.915 87.6031C129.175 87.3524 128.531 86.9096 128.148 86.3903C127.972 86.1501 127.699 85.6802 127.849 85.2367ZM100.261 77.3231C101.416 77.7158 102.625 77.7666 103.669 77.4645C104.828 77.1303 105.684 76.3701 106.02 75.3822C106.356 74.3943 106.138 73.2713 105.425 72.3001C104.784 71.4278 103.792 70.7316 102.635 70.3376C101.976 70.1141 101.301 70.002 100.648 70.002C100.155 70.002 99.675 70.0675 99.2266 70.197C98.0668 70.5318 97.2105 71.2907 96.8749 72.2786C96.5393 73.2672 96.7579 74.3901 97.4701 75.362C98.1127 76.2329 99.1027 76.9298 100.261 77.3231ZM98.875 72.9566C99.0261 72.5118 99.5274 72.3071 99.8135 72.225C100.432 72.0433 101.211 72.0857 101.955 72.3377C102.695 72.5891 103.339 73.0311 103.721 73.5505C103.897 73.7907 104.17 74.2592 104.018 74.7048C103.867 75.1496 103.365 75.355 103.079 75.4372C102.825 75.511 102.543 75.5472 102.249 75.5472C101.826 75.5472 101.376 75.472 100.939 75.323C100.199 75.0717 99.5538 74.6296 99.1723 74.1102C98.9962 73.8707 98.724 73.4022 98.875 72.9566Z\" fill=\"white\"/> </mask> <g mask=\"url(#mask1_0_6)\"> <path d=\"M135.327 146V13.0002H10.8818V146H135.327Z\" fill=\"url(#paint1_linear_0_6)\"/> </g> </g> <defs> <filter id=\"filter0_d_0_6\" x=\"0\" y=\"0\" width=\"701\" height=\"701\" filterUnits=\"userSpaceOnUse\" color-interpolation-filters=\"sRGB\"> <feFlood flood-opacity=\"0\" result=\"BackgroundImageFix\"/> <feColorMatrix in=\"SourceAlpha\" type=\"matrix\" values=\"0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0\" result=\"hardAlpha\"/> <feOffset dx=\"10\" dy=\"10\"/> <feComposite in2=\"hardAlpha\" operator=\"out\"/> <feColorMatrix type=\"matrix\" values=\"0 0 0 0 0.956863 0 0 0 0 0.490196 0 0 0 0 0.380392 0 0 0 1 0\"/> <feBlend mode=\"normal\" in2=\"BackgroundImageFix\" result=\"effect1_dropShadow_0_6\"/> <feBlend mode=\"normal\" in=\"SourceGraphic\" in2=\"effect1_dropShadow_0_6\" result=\"shape\"/> </filter> <linearGradient id=\"paint0_linear_0_6\" x1=\"582.332\" y1=\"482\" x2=\"582.332\" y2=\"690.551\" gradientUnits=\"userSpaceOnUse\"> <stop stop-color=\"#F9C621\"/> <stop offset=\"0.00390625\" stop-color=\"#F9C522\"/> <stop offset=\"0.0078125\" stop-color=\"#F9C423\"/> <stop offset=\"0.0117188\" stop-color=\"#F9C423\"/> <stop offset=\"0.015625\" stop-color=\"#F9C324\"/> <stop offset=\"0.0195312\" stop-color=\"#F9C225\"/> <stop offset=\"0.0234375\" stop-color=\"#F9C126\"/> <stop offset=\"0.0273438\" stop-color=\"#F9C127\"/> <stop offset=\"0.03125\" stop-color=\"#F9C027\"/> <stop offset=\"0.0351562\" stop-color=\"#F9BF28\"/> <stop offset=\"0.0390625\" stop-color=\"#F9BE29\"/> <stop offset=\"0.0429688\" stop-color=\"#F9BD2A\"/> <stop offset=\"0.046875\" stop-color=\"#F9BD2B\"/> <stop offset=\"0.0507813\" stop-color=\"#F9BC2C\"/> <stop offset=\"0.0546875\" stop-color=\"#F9BB2C\"/> <stop offset=\"0.0585938\" stop-color=\"#F9BA2D\"/> <stop offset=\"0.0625\" stop-color=\"#F9BA2E\"/> <stop offset=\"0.0664062\" stop-color=\"#F9B92F\"/> <stop offset=\"0.0703125\" stop-color=\"#F9B830\"/> <stop offset=\"0.0742188\" stop-color=\"#F9B731\"/> <stop offset=\"0.078125\" stop-color=\"#F9B731\"/> <stop offset=\"0.0820312\" stop-color=\"#F9B632\"/> <stop offset=\"0.0859375\" stop-color=\"#F9B533\"/> <stop offset=\"0.0898438\" stop-color=\"#F9B434\"/> <stop offset=\"0.09375\" stop-color=\"#F9B435\"/> <stop offset=\"0.0976563\" stop-color=\"#F9B336\"/> <stop offset=\"0.101563\" stop-color=\"#F9B236\"/> <stop offset=\"0.105469\" stop-color=\"#FAB137\"/> <stop offset=\"0.109375\" stop-color=\"#FAB038\"/> <stop offset=\"0.113281\" stop-color=\"#FAB039\"/> <stop offset=\"0.117188\" stop-color=\"#FAAF3A\"/> <stop offset=\"0.121094\" stop-color=\"#FAAE3A\"/> <stop offset=\"0.125\" stop-color=\"#FAAD3B\"/> <stop offset=\"0.128906\" stop-color=\"#FAAD3C\"/> <stop offset=\"0.132812\" stop-color=\"#FAAC3D\"/> <stop offset=\"0.136719\" stop-color=\"#FAAB3E\"/> <stop offset=\"0.140625\" stop-color=\"#FAAA3F\"/> <stop offset=\"0.144531\" stop-color=\"#FAAA3F\"/> <stop offset=\"0.148438\" stop-color=\"#FAA940\"/> <stop offset=\"0.152344\" stop-color=\"#FAA841\"/> <stop offset=\"0.15625\" stop-color=\"#FAA742\"/> <stop offset=\"0.160156\" stop-color=\"#FAA743\"/> <stop offset=\"0.164062\" stop-color=\"#FAA644\"/> <stop offset=\"0.167969\" stop-color=\"#FAA544\"/> <stop offset=\"0.171875\" stop-color=\"#FAA445\"/> <stop offset=\"0.175781\" stop-color=\"#FAA346\"/> <stop offset=\"0.179688\" stop-color=\"#FAA347\"/> <stop offset=\"0.183594\" stop-color=\"#FAA248\"/> <stop offset=\"0.1875\" stop-color=\"#FAA148\"/> <stop offset=\"0.191406\" stop-color=\"#FAA049\"/> <stop offset=\"0.195313\" stop-color=\"#FAA04A\"/> <stop offset=\"0.199219\" stop-color=\"#FA9F4B\"/> <stop offset=\"0.203125\" stop-color=\"#FA9E4C\"/> <stop offset=\"0.207031\" stop-color=\"#FA9D4D\"/> <stop offset=\"0.210938\" stop-color=\"#FA9D4D\"/> <stop offset=\"0.214844\" stop-color=\"#FA9C4E\"/> <stop offset=\"0.21875\" stop-color=\"#FA9B4F\"/> <stop offset=\"0.222656\" stop-color=\"#FA9A50\"/> <stop offset=\"0.226563\" stop-color=\"#FA9A51\"/> <stop offset=\"0.230469\" stop-color=\"#FA9952\"/> <stop offset=\"0.234375\" stop-color=\"#FA9852\"/> <stop offset=\"0.238281\" stop-color=\"#FA9753\"/> <stop offset=\"0.242188\" stop-color=\"#FA9654\"/> <stop offset=\"0.246094\" stop-color=\"#FA9655\"/> <stop offset=\"0.25\" stop-color=\"#FA9556\"/> <stop offset=\"0.253906\" stop-color=\"#FA9457\"/> <stop offset=\"0.257812\" stop-color=\"#FA9357\"/> <stop offset=\"0.261719\" stop-color=\"#FA9358\"/> <stop offset=\"0.265625\" stop-color=\"#FB9259\"/> <stop offset=\"0.269531\" stop-color=\"#FB915A\"/> <stop offset=\"0.273438\" stop-color=\"#FB905B\"/> <stop offset=\"0.277344\" stop-color=\"#FB905B\"/> <stop offset=\"0.28125\" stop-color=\"#FB8F5C\"/> <stop offset=\"0.285156\" stop-color=\"#FB8E5D\"/> <stop offset=\"0.289062\" stop-color=\"#FB8D5E\"/> <stop offset=\"0.292969\" stop-color=\"#FB8C5F\"/> <stop offset=\"0.296875\" stop-color=\"#FB8C60\"/> <stop offset=\"0.300781\" stop-color=\"#FB8B60\"/> <stop offset=\"0.304688\" stop-color=\"#FB8A61\"/> <stop offset=\"0.308594\" stop-color=\"#FB8962\"/> <stop offset=\"0.3125\" stop-color=\"#FB8963\"/> <stop offset=\"0.316406\" stop-color=\"#FB8864\"/> <stop offset=\"0.320313\" stop-color=\"#FB8765\"/> <stop offset=\"0.324219\" stop-color=\"#FB8665\"/> <stop offset=\"0.328125\" stop-color=\"#FB8666\"/> <stop offset=\"0.332031\" stop-color=\"#FB8567\"/> <stop offset=\"0.335938\" stop-color=\"#FB8468\"/> <stop offset=\"0.339844\" stop-color=\"#FB8369\"/> <stop offset=\"0.34375\" stop-color=\"#FB8369\"/> <stop offset=\"0.347656\" stop-color=\"#FB826A\"/> <stop offset=\"0.351563\" stop-color=\"#FB816B\"/> <stop offset=\"0.355469\" stop-color=\"#FB806C\"/> <stop offset=\"0.359375\" stop-color=\"#FB806D\"/> <stop offset=\"0.363281\" stop-color=\"#FB7F6E\"/> <stop offset=\"0.367188\" stop-color=\"#FB7E6E\"/> <stop offset=\"0.371094\" stop-color=\"#FB7D6F\"/> <stop offset=\"0.375\" stop-color=\"#FB7C70\"/> <stop offset=\"0.378906\" stop-color=\"#FB7C71\"/> <stop offset=\"0.382813\" stop-color=\"#FB7B72\"/> <stop offset=\"0.386719\" stop-color=\"#FB7A73\"/> <stop offset=\"0.390625\" stop-color=\"#FB7973\"/> <stop offset=\"0.394531\" stop-color=\"#FB7974\"/> <stop offset=\"0.398438\" stop-color=\"#FB7875\"/> <stop offset=\"0.402344\" stop-color=\"#FB7776\"/> <stop offset=\"0.40625\" stop-color=\"#FB7677\"/> <stop offset=\"0.410156\" stop-color=\"#FB7677\"/> <stop offset=\"0.414062\" stop-color=\"#FB7578\"/> <stop offset=\"0.417969\" stop-color=\"#FB7479\"/> <stop offset=\"0.421875\" stop-color=\"#FB737A\"/> <stop offset=\"0.425781\" stop-color=\"#FB727B\"/> <stop offset=\"0.429688\" stop-color=\"#FC727C\"/> <stop offset=\"0.433594\" stop-color=\"#FC717C\"/> <stop offset=\"0.4375\" stop-color=\"#FC707D\"/> <stop offset=\"0.441406\" stop-color=\"#FC6F7E\"/> <stop offset=\"0.445312\" stop-color=\"#FC6F7F\"/> <stop offset=\"0.449219\" stop-color=\"#FC6E80\"/> <stop offset=\"0.453125\" stop-color=\"#FC6D81\"/> <stop offset=\"0.457031\" stop-color=\"#FC6C81\"/> <stop offset=\"0.460938\" stop-color=\"#FC6C82\"/> <stop offset=\"0.464844\" stop-color=\"#FC6B83\"/> <stop offset=\"0.46875\" stop-color=\"#FC6A84\"/> <stop offset=\"0.472656\" stop-color=\"#FC6985\"/> <stop offset=\"0.476563\" stop-color=\"#FC6986\"/> <stop offset=\"0.480469\" stop-color=\"#FC6886\"/> <stop offset=\"0.484375\" stop-color=\"#FC6787\"/> <stop offset=\"0.488281\" stop-color=\"#FC6688\"/> <stop offset=\"0.492188\" stop-color=\"#FC6589\"/> <stop offset=\"0.496094\" stop-color=\"#FC658A\"/> <stop offset=\"0.5\" stop-color=\"#FC648A\"/> <stop offset=\"0.503906\" stop-color=\"#FC638B\"/> <stop offset=\"0.507812\" stop-color=\"#FC628C\"/> <stop offset=\"0.511719\" stop-color=\"#FC628D\"/> <stop offset=\"0.515625\" stop-color=\"#FC618E\"/> <stop offset=\"0.519531\" stop-color=\"#FC608F\"/> <stop offset=\"0.523438\" stop-color=\"#FC5F8F\"/> <stop offset=\"0.527344\" stop-color=\"#FC5F90\"/> <stop offset=\"0.53125\" stop-color=\"#FC5E91\"/> <stop offset=\"0.535156\" stop-color=\"#FC5D92\"/> <stop offset=\"0.539062\" stop-color=\"#FC5C93\"/> <stop offset=\"0.542969\" stop-color=\"#FC5C94\"/> <stop offset=\"0.546875\" stop-color=\"#FC5B94\"/> <stop offset=\"0.550781\" stop-color=\"#FC5A95\"/> <stop offset=\"0.554687\" stop-color=\"#FC5996\"/> <stop offset=\"0.558594\" stop-color=\"#FC5897\"/> <stop offset=\"0.5625\" stop-color=\"#FC5898\"/> <stop offset=\"0.566406\" stop-color=\"#FC5798\"/> <stop offset=\"0.570312\" stop-color=\"#FC5699\"/> <stop offset=\"0.574219\" stop-color=\"#FC559A\"/> <stop offset=\"0.578125\" stop-color=\"#FC559B\"/> <stop offset=\"0.582031\" stop-color=\"#FC549C\"/> <stop offset=\"0.585937\" stop-color=\"#FC539D\"/> <stop offset=\"0.589844\" stop-color=\"#FC529D\"/> <stop offset=\"0.59375\" stop-color=\"#FD529E\"/> <stop offset=\"0.597656\" stop-color=\"#FD519F\"/> <stop offset=\"0.601562\" stop-color=\"#FD50A0\"/> <stop offset=\"0.605469\" stop-color=\"#FD4FA1\"/> <stop offset=\"0.609375\" stop-color=\"#FD4FA2\"/> <stop offset=\"0.613281\" stop-color=\"#FD4EA2\"/> <stop offset=\"0.617187\" stop-color=\"#FD4DA3\"/> <stop offset=\"0.621094\" stop-color=\"#FD4CA4\"/> <stop offset=\"0.625\" stop-color=\"#FD4BA5\"/> <stop offset=\"0.628906\" stop-color=\"#FD4BA6\"/> <stop offset=\"0.632812\" stop-color=\"#FD4AA7\"/> <stop offset=\"0.636719\" stop-color=\"#FD49A7\"/> <stop offset=\"0.640625\" stop-color=\"#FD48A8\"/> <stop offset=\"0.644531\" stop-color=\"#FD48A9\"/> <stop offset=\"0.648437\" stop-color=\"#FD47AA\"/> <stop offset=\"0.652344\" stop-color=\"#FD46AB\"/> <stop offset=\"0.65625\" stop-color=\"#FD45AB\"/> <stop offset=\"0.660156\" stop-color=\"#FD45AC\"/> <stop offset=\"0.664062\" stop-color=\"#FD44AD\"/> <stop offset=\"0.667969\" stop-color=\"#FD43AE\"/> <stop offset=\"0.671875\" stop-color=\"#FD42AF\"/> <stop offset=\"0.675781\" stop-color=\"#FD42B0\"/> <stop offset=\"0.679688\" stop-color=\"#FD41B0\"/> <stop offset=\"0.683594\" stop-color=\"#FD40B1\"/> <stop offset=\"0.6875\" stop-color=\"#FD3FB2\"/> <stop offset=\"0.691406\" stop-color=\"#FD3EB3\"/> <stop offset=\"0.695313\" stop-color=\"#FD3EB4\"/> <stop offset=\"0.699219\" stop-color=\"#FD3DB5\"/> <stop offset=\"0.703125\" stop-color=\"#FD3CB5\"/> <stop offset=\"0.707031\" stop-color=\"#FD3BB6\"/> <stop offset=\"0.710938\" stop-color=\"#FD3BB7\"/> <stop offset=\"0.714844\" stop-color=\"#FD3AB8\"/> <stop offset=\"0.71875\" stop-color=\"#FD39B9\"/> <stop offset=\"0.722656\" stop-color=\"#FD38B9\"/> <stop offset=\"0.726563\" stop-color=\"#FD38BA\"/> <stop offset=\"0.730469\" stop-color=\"#FD37BB\"/> <stop offset=\"0.734375\" stop-color=\"#FD36BC\"/> <stop offset=\"0.738281\" stop-color=\"#FD35BD\"/> <stop offset=\"0.742188\" stop-color=\"#FD35BE\"/> <stop offset=\"0.746094\" stop-color=\"#FD34BE\"/> <stop offset=\"0.75\" stop-color=\"#FD33BF\"/> <stop offset=\"0.753906\" stop-color=\"#FD32C0\"/> <stop offset=\"0.757813\" stop-color=\"#FE31C1\"/> <stop offset=\"0.761719\" stop-color=\"#FE31C2\"/> <stop offset=\"0.765625\" stop-color=\"#FE30C3\"/> <stop offset=\"0.769531\" stop-color=\"#FE2FC3\"/> <stop offset=\"0.773438\" stop-color=\"#FE2EC4\"/> <stop offset=\"0.777344\" stop-color=\"#FE2EC5\"/> <stop offset=\"0.78125\" stop-color=\"#FE2DC6\"/> <stop offset=\"0.785156\" stop-color=\"#FE2CC7\"/> <stop offset=\"0.789063\" stop-color=\"#FE2BC7\"/> <stop offset=\"0.792969\" stop-color=\"#FE2BC8\"/> <stop offset=\"0.796875\" stop-color=\"#FE2AC9\"/> <stop offset=\"0.800781\" stop-color=\"#FE29CA\"/> <stop offset=\"0.804688\" stop-color=\"#FE28CB\"/> <stop offset=\"0.808594\" stop-color=\"#FE28CC\"/> <stop offset=\"0.8125\" stop-color=\"#FE27CC\"/> <stop offset=\"0.816406\" stop-color=\"#FE26CD\"/> <stop offset=\"0.820313\" stop-color=\"#FE25CE\"/> <stop offset=\"0.824219\" stop-color=\"#FE24CF\"/> <stop offset=\"0.828125\" stop-color=\"#FE24D0\"/> <stop offset=\"0.832031\" stop-color=\"#FE23D1\"/> <stop offset=\"0.835938\" stop-color=\"#FE22D1\"/> <stop offset=\"0.839844\" stop-color=\"#FE21D2\"/> <stop offset=\"0.84375\" stop-color=\"#FE21D3\"/> <stop offset=\"0.847656\" stop-color=\"#FE20D4\"/> <stop offset=\"0.851563\" stop-color=\"#FE1FD5\"/> <stop offset=\"0.855469\" stop-color=\"#FE1ED6\"/> <stop offset=\"0.859375\" stop-color=\"#FE1ED6\"/> <stop offset=\"0.863281\" stop-color=\"#FE1DD7\"/> <stop offset=\"0.867188\" stop-color=\"#FE1CD8\"/> <stop offset=\"0.871094\" stop-color=\"#FE1BD9\"/> <stop offset=\"0.875\" stop-color=\"#FE1BDA\"/> <stop offset=\"0.878906\" stop-color=\"#FE1ADA\"/> <stop offset=\"0.882812\" stop-color=\"#FE19DB\"/> <stop offset=\"0.886719\" stop-color=\"#FE18DC\"/> <stop offset=\"0.890625\" stop-color=\"#FE17DD\"/> <stop offset=\"0.894531\" stop-color=\"#FE17DE\"/> <stop offset=\"0.898438\" stop-color=\"#FE16DF\"/> <stop offset=\"0.902344\" stop-color=\"#FE15DF\"/> <stop offset=\"0.90625\" stop-color=\"#FE14E0\"/> <stop offset=\"0.910156\" stop-color=\"#FE14E1\"/> <stop offset=\"0.914062\" stop-color=\"#FE13E2\"/> <stop offset=\"0.917969\" stop-color=\"#FE12E3\"/> <stop offset=\"0.921875\" stop-color=\"#FF11E4\"/> <stop offset=\"0.925781\" stop-color=\"#FF11E4\"/> <stop offset=\"0.929687\" stop-color=\"#FF10E5\"/> <stop offset=\"0.933594\" stop-color=\"#FF0FE6\"/> <stop offset=\"0.9375\" stop-color=\"#FF0EE7\"/> <stop offset=\"0.941406\" stop-color=\"#FF0EE8\"/> <stop offset=\"0.945312\" stop-color=\"#FF0DE8\"/> <stop offset=\"0.949219\" stop-color=\"#FF0CE9\"/> <stop offset=\"0.953125\" stop-color=\"#FF0BEA\"/> <stop offset=\"0.957031\" stop-color=\"#FF0AEB\"/> <stop offset=\"0.960937\" stop-color=\"#FF0AEC\"/> <stop offset=\"0.964844\" stop-color=\"#FF09ED\"/> <stop offset=\"0.96875\" stop-color=\"#FF08ED\"/> <stop offset=\"0.972656\" stop-color=\"#FF07EE\"/> <stop offset=\"0.976562\" stop-color=\"#FF07EF\"/> <stop offset=\"0.980469\" stop-color=\"#FF06F0\"/> <stop offset=\"0.984375\" stop-color=\"#FF05F1\"/> <stop offset=\"0.988281\" stop-color=\"#FF04F2\"/> <stop offset=\"0.992187\" stop-color=\"#FF04F2\"/> <stop offset=\"0.996094\" stop-color=\"#FF03F3\"/> <stop offset=\"1\" stop-color=\"#FF02F4\"/> </linearGradient> <linearGradient id=\"paint1_linear_0_6\" x1=\"73.0745\" y1=\"146\" x2=\"73.0745\" y2=\"13\" gradientUnits=\"userSpaceOnUse\"> <stop stop-color=\"#F9C621\"/> <stop offset=\"0.00390625\" stop-color=\"#F9C522\"/> <stop offset=\"0.0078125\" stop-color=\"#F9C423\"/> <stop offset=\"0.0117188\" stop-color=\"#F9C423\"/> <stop offset=\"0.015625\" stop-color=\"#F9C324\"/> <stop offset=\"0.0195312\" stop-color=\"#F9C225\"/> <stop offset=\"0.0234375\" stop-color=\"#F9C126\"/> <stop offset=\"0.0273438\" stop-color=\"#F9C127\"/> <stop offset=\"0.03125\" stop-color=\"#F9C027\"/> <stop offset=\"0.0351562\" stop-color=\"#F9BF28\"/> <stop offset=\"0.0390625\" stop-color=\"#F9BE29\"/> <stop offset=\"0.0429688\" stop-color=\"#F9BD2A\"/> <stop offset=\"0.046875\" stop-color=\"#F9BD2B\"/> <stop offset=\"0.0507813\" stop-color=\"#F9BC2C\"/> <stop offset=\"0.0546875\" stop-color=\"#F9BB2C\"/> <stop offset=\"0.0585938\" stop-color=\"#F9BA2D\"/> <stop offset=\"0.0625\" stop-color=\"#F9BA2E\"/> <stop offset=\"0.0664062\" stop-color=\"#F9B92F\"/> <stop offset=\"0.0703125\" stop-color=\"#F9B830\"/> <stop offset=\"0.0742188\" stop-color=\"#F9B731\"/> <stop offset=\"0.078125\" stop-color=\"#F9B731\"/> <stop offset=\"0.0820312\" stop-color=\"#F9B632\"/> <stop offset=\"0.0859375\" stop-color=\"#F9B533\"/> <stop offset=\"0.0898438\" stop-color=\"#F9B434\"/> <stop offset=\"0.09375\" stop-color=\"#F9B435\"/> <stop offset=\"0.0976563\" stop-color=\"#F9B336\"/> <stop offset=\"0.101563\" stop-color=\"#F9B236\"/> <stop offset=\"0.105469\" stop-color=\"#FAB137\"/> <stop offset=\"0.109375\" stop-color=\"#FAB038\"/> <stop offset=\"0.113281\" stop-color=\"#FAB039\"/> <stop offset=\"0.117188\" stop-color=\"#FAAF3A\"/> <stop offset=\"0.121094\" stop-color=\"#FAAE3A\"/> <stop offset=\"0.125\" stop-color=\"#FAAD3B\"/> <stop offset=\"0.128906\" stop-color=\"#FAAD3C\"/> <stop offset=\"0.132812\" stop-color=\"#FAAC3D\"/> <stop offset=\"0.136719\" stop-color=\"#FAAB3E\"/> <stop offset=\"0.140625\" stop-color=\"#FAAA3F\"/> <stop offset=\"0.144531\" stop-color=\"#FAAA3F\"/> <stop offset=\"0.148438\" stop-color=\"#FAA940\"/> <stop offset=\"0.152344\" stop-color=\"#FAA841\"/> <stop offset=\"0.15625\" stop-color=\"#FAA742\"/> <stop offset=\"0.160156\" stop-color=\"#FAA743\"/> <stop offset=\"0.164062\" stop-color=\"#FAA644\"/> <stop offset=\"0.167969\" stop-color=\"#FAA544\"/> <stop offset=\"0.171875\" stop-color=\"#FAA445\"/> <stop offset=\"0.175781\" stop-color=\"#FAA346\"/> <stop offset=\"0.179688\" stop-color=\"#FAA347\"/> <stop offset=\"0.183594\" stop-color=\"#FAA248\"/> <stop offset=\"0.1875\" stop-color=\"#FAA148\"/> <stop offset=\"0.191406\" stop-color=\"#FAA049\"/> <stop offset=\"0.195313\" stop-color=\"#FAA04A\"/> <stop offset=\"0.199219\" stop-color=\"#FA9F4B\"/> <stop offset=\"0.203125\" stop-color=\"#FA9E4C\"/> <stop offset=\"0.207031\" stop-color=\"#FA9D4D\"/> <stop offset=\"0.210938\" stop-color=\"#FA9D4D\"/> <stop offset=\"0.214844\" stop-color=\"#FA9C4E\"/> <stop offset=\"0.21875\" stop-color=\"#FA9B4F\"/> <stop offset=\"0.222656\" stop-color=\"#FA9A50\"/> <stop offset=\"0.226563\" stop-color=\"#FA9A51\"/> <stop offset=\"0.230469\" stop-color=\"#FA9952\"/> <stop offset=\"0.234375\" stop-color=\"#FA9852\"/> <stop offset=\"0.238281\" stop-color=\"#FA9753\"/> <stop offset=\"0.242188\" stop-color=\"#FA9654\"/> <stop offset=\"0.246094\" stop-color=\"#FA9655\"/> <stop offset=\"0.25\" stop-color=\"#FA9556\"/> <stop offset=\"0.253906\" stop-color=\"#FA9457\"/> <stop offset=\"0.257812\" stop-color=\"#FA9357\"/> <stop offset=\"0.261719\" stop-color=\"#FA9358\"/> <stop offset=\"0.265625\" stop-color=\"#FB9259\"/> <stop offset=\"0.269531\" stop-color=\"#FB915A\"/> <stop offset=\"0.273438\" stop-color=\"#FB905B\"/> <stop offset=\"0.277344\" stop-color=\"#FB905B\"/> <stop offset=\"0.28125\" stop-color=\"#FB8F5C\"/> <stop offset=\"0.285156\" stop-color=\"#FB8E5D\"/> <stop offset=\"0.289062\" stop-color=\"#FB8D5E\"/> <stop offset=\"0.292969\" stop-color=\"#FB8C5F\"/> <stop offset=\"0.296875\" stop-color=\"#FB8C60\"/> <stop offset=\"0.300781\" stop-color=\"#FB8B60\"/> <stop offset=\"0.304688\" stop-color=\"#FB8A61\"/> <stop offset=\"0.308594\" stop-color=\"#FB8962\"/> <stop offset=\"0.3125\" stop-color=\"#FB8963\"/> <stop offset=\"0.316406\" stop-color=\"#FB8864\"/> <stop offset=\"0.320313\" stop-color=\"#FB8765\"/> <stop offset=\"0.324219\" stop-color=\"#FB8665\"/> <stop offset=\"0.328125\" stop-color=\"#FB8666\"/> <stop offset=\"0.332031\" stop-color=\"#FB8567\"/> <stop offset=\"0.335938\" stop-color=\"#FB8468\"/> <stop offset=\"0.339844\" stop-color=\"#FB8369\"/> <stop offset=\"0.34375\" stop-color=\"#FB8369\"/> <stop offset=\"0.347656\" stop-color=\"#FB826A\"/> <stop offset=\"0.351563\" stop-color=\"#FB816B\"/> <stop offset=\"0.355469\" stop-color=\"#FB806C\"/> <stop offset=\"0.359375\" stop-color=\"#FB806D\"/> <stop offset=\"0.363281\" stop-color=\"#FB7F6E\"/> <stop offset=\"0.367188\" stop-color=\"#FB7E6E\"/> <stop offset=\"0.371094\" stop-color=\"#FB7D6F\"/> <stop offset=\"0.375\" stop-color=\"#FB7C70\"/> <stop offset=\"0.378906\" stop-color=\"#FB7C71\"/> <stop offset=\"0.382813\" stop-color=\"#FB7B72\"/> <stop offset=\"0.386719\" stop-color=\"#FB7A73\"/> <stop offset=\"0.390625\" stop-color=\"#FB7973\"/> <stop offset=\"0.394531\" stop-color=\"#FB7974\"/> <stop offset=\"0.398438\" stop-color=\"#FB7875\"/> <stop offset=\"0.402344\" stop-color=\"#FB7776\"/> <stop offset=\"0.40625\" stop-color=\"#FB7677\"/> <stop offset=\"0.410156\" stop-color=\"#FB7677\"/> <stop offset=\"0.414062\" stop-color=\"#FB7578\"/> <stop offset=\"0.417969\" stop-color=\"#FB7479\"/> <stop offset=\"0.421875\" stop-color=\"#FB737A\"/> <stop offset=\"0.425781\" stop-color=\"#FB727B\"/> <stop offset=\"0.429688\" stop-color=\"#FC727C\"/> <stop offset=\"0.433594\" stop-color=\"#FC717C\"/> <stop offset=\"0.4375\" stop-color=\"#FC707D\"/> <stop offset=\"0.441406\" stop-color=\"#FC6F7E\"/> <stop offset=\"0.445312\" stop-color=\"#FC6F7F\"/> <stop offset=\"0.449219\" stop-color=\"#FC6E80\"/> <stop offset=\"0.453125\" stop-color=\"#FC6D81\"/> <stop offset=\"0.457031\" stop-color=\"#FC6C81\"/> <stop offset=\"0.460938\" stop-color=\"#FC6C82\"/> <stop offset=\"0.464844\" stop-color=\"#FC6B83\"/> <stop offset=\"0.46875\" stop-color=\"#FC6A84\"/> <stop offset=\"0.472656\" stop-color=\"#FC6985\"/> <stop offset=\"0.476563\" stop-color=\"#FC6986\"/> <stop offset=\"0.480469\" stop-color=\"#FC6886\"/> <stop offset=\"0.484375\" stop-color=\"#FC6787\"/> <stop offset=\"0.488281\" stop-color=\"#FC6688\"/> <stop offset=\"0.492188\" stop-color=\"#FC6589\"/> <stop offset=\"0.496094\" stop-color=\"#FC658A\"/> <stop offset=\"0.5\" stop-color=\"#FC648A\"/> <stop offset=\"0.503906\" stop-color=\"#FC638B\"/> <stop offset=\"0.507812\" stop-color=\"#FC628C\"/> <stop offset=\"0.511719\" stop-color=\"#FC628D\"/> <stop offset=\"0.515625\" stop-color=\"#FC618E\"/> <stop offset=\"0.519531\" stop-color=\"#FC608F\"/> <stop offset=\"0.523438\" stop-color=\"#FC5F8F\"/> <stop offset=\"0.527344\" stop-color=\"#FC5F90\"/> <stop offset=\"0.53125\" stop-color=\"#FC5E91\"/> <stop offset=\"0.535156\" stop-color=\"#FC5D92\"/> <stop offset=\"0.539062\" stop-color=\"#FC5C93\"/> <stop offset=\"0.542969\" stop-color=\"#FC5C94\"/> <stop offset=\"0.546875\" stop-color=\"#FC5B94\"/> <stop offset=\"0.550781\" stop-color=\"#FC5A95\"/> <stop offset=\"0.554687\" stop-color=\"#FC5996\"/> <stop offset=\"0.558594\" stop-color=\"#FC5897\"/> <stop offset=\"0.5625\" stop-color=\"#FC5898\"/> <stop offset=\"0.566406\" stop-color=\"#FC5798\"/> <stop offset=\"0.570312\" stop-color=\"#FC5699\"/> <stop offset=\"0.574219\" stop-color=\"#FC559A\"/> <stop offset=\"0.578125\" stop-color=\"#FC559B\"/> <stop offset=\"0.582031\" stop-color=\"#FC549C\"/> <stop offset=\"0.585937\" stop-color=\"#FC539D\"/> <stop offset=\"0.589844\" stop-color=\"#FC529D\"/> <stop offset=\"0.59375\" stop-color=\"#FD529E\"/> <stop offset=\"0.597656\" stop-color=\"#FD519F\"/> <stop offset=\"0.601562\" stop-color=\"#FD50A0\"/> <stop offset=\"0.605469\" stop-color=\"#FD4FA1\"/> <stop offset=\"0.609375\" stop-color=\"#FD4FA2\"/> <stop offset=\"0.613281\" stop-color=\"#FD4EA2\"/> <stop offset=\"0.617187\" stop-color=\"#FD4DA3\"/> <stop offset=\"0.621094\" stop-color=\"#FD4CA4\"/> <stop offset=\"0.625\" stop-color=\"#FD4BA5\"/> <stop offset=\"0.628906\" stop-color=\"#FD4BA6\"/> <stop offset=\"0.632812\" stop-color=\"#FD4AA7\"/> <stop offset=\"0.636719\" stop-color=\"#FD49A7\"/> <stop offset=\"0.640625\" stop-color=\"#FD48A8\"/> <stop offset=\"0.644531\" stop-color=\"#FD48A9\"/> <stop offset=\"0.648437\" stop-color=\"#FD47AA\"/> <stop offset=\"0.652344\" stop-color=\"#FD46AB\"/> <stop offset=\"0.65625\" stop-color=\"#FD45AB\"/> <stop offset=\"0.660156\" stop-color=\"#FD45AC\"/> <stop offset=\"0.664062\" stop-color=\"#FD44AD\"/> <stop offset=\"0.667969\" stop-color=\"#FD43AE\"/> <stop offset=\"0.671875\" stop-color=\"#FD42AF\"/> <stop offset=\"0.675781\" stop-color=\"#FD42B0\"/> <stop offset=\"0.679688\" stop-color=\"#FD41B0\"/> <stop offset=\"0.683594\" stop-color=\"#FD40B1\"/> <stop offset=\"0.6875\" stop-color=\"#FD3FB2\"/> <stop offset=\"0.691406\" stop-color=\"#FD3EB3\"/> <stop offset=\"0.695313\" stop-color=\"#FD3EB4\"/> <stop offset=\"0.699219\" stop-color=\"#FD3DB5\"/> <stop offset=\"0.703125\" stop-color=\"#FD3CB5\"/> <stop offset=\"0.707031\" stop-color=\"#FD3BB6\"/> <stop offset=\"0.710938\" stop-color=\"#FD3BB7\"/> <stop offset=\"0.714844\" stop-color=\"#FD3AB8\"/> <stop offset=\"0.71875\" stop-color=\"#FD39B9\"/> <stop offset=\"0.722656\" stop-color=\"#FD38B9\"/> <stop offset=\"0.726563\" stop-color=\"#FD38BA\"/> <stop offset=\"0.730469\" stop-color=\"#FD37BB\"/> <stop offset=\"0.734375\" stop-color=\"#FD36BC\"/> <stop offset=\"0.738281\" stop-color=\"#FD35BD\"/> <stop offset=\"0.742188\" stop-color=\"#FD35BE\"/> <stop offset=\"0.746094\" stop-color=\"#FD34BE\"/> <stop offset=\"0.75\" stop-color=\"#FD33BF\"/> <stop offset=\"0.753906\" stop-color=\"#FD32C0\"/> <stop offset=\"0.757813\" stop-color=\"#FE31C1\"/> <stop offset=\"0.761719\" stop-color=\"#FE31C2\"/> <stop offset=\"0.765625\" stop-color=\"#FE30C3\"/> <stop offset=\"0.769531\" stop-color=\"#FE2FC3\"/> <stop offset=\"0.773438\" stop-color=\"#FE2EC4\"/> <stop offset=\"0.777344\" stop-color=\"#FE2EC5\"/> <stop offset=\"0.78125\" stop-color=\"#FE2DC6\"/> <stop offset=\"0.785156\" stop-color=\"#FE2CC7\"/> <stop offset=\"0.789063\" stop-color=\"#FE2BC7\"/> <stop offset=\"0.792969\" stop-color=\"#FE2BC8\"/> <stop offset=\"0.796875\" stop-color=\"#FE2AC9\"/> <stop offset=\"0.800781\" stop-color=\"#FE29CA\"/> <stop offset=\"0.804688\" stop-color=\"#FE28CB\"/> <stop offset=\"0.808594\" stop-color=\"#FE28CC\"/> <stop offset=\"0.8125\" stop-color=\"#FE27CC\"/> <stop offset=\"0.816406\" stop-color=\"#FE26CD\"/> <stop offset=\"0.820313\" stop-color=\"#FE25CE\"/> <stop offset=\"0.824219\" stop-color=\"#FE24CF\"/> <stop offset=\"0.828125\" stop-color=\"#FE24D0\"/> <stop offset=\"0.832031\" stop-color=\"#FE23D1\"/> <stop offset=\"0.835938\" stop-color=\"#FE22D1\"/> <stop offset=\"0.839844\" stop-color=\"#FE21D2\"/> <stop offset=\"0.84375\" stop-color=\"#FE21D3\"/> <stop offset=\"0.847656\" stop-color=\"#FE20D4\"/> <stop offset=\"0.851563\" stop-color=\"#FE1FD5\"/> <stop offset=\"0.855469\" stop-color=\"#FE1ED6\"/> <stop offset=\"0.859375\" stop-color=\"#FE1ED6\"/> <stop offset=\"0.863281\" stop-color=\"#FE1DD7\"/> <stop offset=\"0.867188\" stop-color=\"#FE1CD8\"/> <stop offset=\"0.871094\" stop-color=\"#FE1BD9\"/> <stop offset=\"0.875\" stop-color=\"#FE1BDA\"/> <stop offset=\"0.878906\" stop-color=\"#FE1ADA\"/> <stop offset=\"0.882812\" stop-color=\"#FE19DB\"/> <stop offset=\"0.886719\" stop-color=\"#FE18DC\"/> <stop offset=\"0.890625\" stop-color=\"#FE17DD\"/> <stop offset=\"0.894531\" stop-color=\"#FE17DE\"/> <stop offset=\"0.898438\" stop-color=\"#FE16DF\"/> <stop offset=\"0.902344\" stop-color=\"#FE15DF\"/> <stop offset=\"0.90625\" stop-color=\"#FE14E0\"/> <stop offset=\"0.910156\" stop-color=\"#FE14E1\"/> <stop offset=\"0.914062\" stop-color=\"#FE13E2\"/> <stop offset=\"0.917969\" stop-color=\"#FE12E3\"/> <stop offset=\"0.921875\" stop-color=\"#FF11E4\"/> <stop offset=\"0.925781\" stop-color=\"#FF11E4\"/> <stop offset=\"0.929687\" stop-color=\"#FF10E5\"/> <stop offset=\"0.933594\" stop-color=\"#FF0FE6\"/> <stop offset=\"0.9375\" stop-color=\"#FF0EE7\"/> <stop offset=\"0.941406\" stop-color=\"#FF0EE8\"/> <stop offset=\"0.945312\" stop-color=\"#FF0DE8\"/> <stop offset=\"0.949219\" stop-color=\"#FF0CE9\"/> <stop offset=\"0.953125\" stop-color=\"#FF0BEA\"/> <stop offset=\"0.957031\" stop-color=\"#FF0AEB\"/> <stop offset=\"0.960937\" stop-color=\"#FF0AEC\"/> <stop offset=\"0.964844\" stop-color=\"#FF09ED\"/> <stop offset=\"0.96875\" stop-color=\"#FF08ED\"/> <stop offset=\"0.972656\" stop-color=\"#FF07EE\"/> <stop offset=\"0.976562\" stop-color=\"#FF07EF\"/> <stop offset=\"0.980469\" stop-color=\"#FF06F0\"/> <stop offset=\"0.984375\" stop-color=\"#FF05F1\"/> <stop offset=\"0.988281\" stop-color=\"#FF04F2\"/> <stop offset=\"0.992187\" stop-color=\"#FF04F2\"/> <stop offset=\"0.996094\" stop-color=\"#FF03F3\"/> <stop offset=\"1\" stop-color=\"#FF02F4\"/> </linearGradient> </defs> </svg>") // EJsS HtmlView.HtmlView Page: setting property 'Html' for element 'gameEnd'
      .setProperty("Display","none") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'gameEnd'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"confetti", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'confetti'
      .setProperty("ClassName","d-none position-absolute top-0 start-0 vw-100 vh-100") // EJsS HtmlView.HtmlView Page: setting property 'ClassName' for element 'confetti'
      .setProperty("Html","<img src=\"cross_cultural/assets/effects/confetti.gif\" alt=\"confetti\" id=\"confetti-gif\" style=\"width: 100vw;\" />") // EJsS HtmlView.HtmlView Page: setting property 'Html' for element 'confetti'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"copyright", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'copyright'
      .setProperty("ClassName","position-absolute") // EJsS HtmlView.HtmlView Page: setting property 'ClassName' for element 'copyright'
      .setProperty("Html","Content and images © <span id=\"currentYear\"></span> Inter-Religious Organisation, Singapore") // EJsS HtmlView.HtmlView Page: setting property 'Html' for element 'copyright'
      ;

  };

  return _view;
}



      var _model;
      var _scorm;
      window.addEventListener('load',
        function () { 
          _model =  new cross_cultural("_topFrame","_ejs_library/",null);
          if (typeof _isApp !== "undefined" && _isApp) _model.setRunAlways(true);
          TextResizeDetector.TARGET_ELEMENT_ID = '_topFrame';
          TextResizeDetector.USER_INIT_FUNC = function () {
            var iBase = TextResizeDetector.addEventListener(function(e,args) {
              _model._fontResized(args[0].iBase,args[0].iSize,args[0].iDelta);
              },null);
            _model._fontResized(iBase);
          };
          _model.onload();
        }, false);
