import React from 'react';
import type { Scenario } from '../types';

interface ScenarioSelectorProps {
    scenarios: Scenario[];
    activeIndex: number;
    onSelect: (index: number) => void;
}

export const ScenarioSelector: React.FC<ScenarioSelectorProps> = ({ scenarios, activeIndex, onSelect }) => {
    return (
        <div className="flex justify-center items-center flex-wrap gap-2 bg-white/70 backdrop-blur-sm p-3 rounded-2xl shadow-md border border-slate-200">
            {scenarios.map((scenario, index) => (
                <button
                    key={scenario.title}
                    onClick={() => onSelect(index)}
                    className={`px-4 py-2 rounded-full text-sm font-semibold transition-all duration-300 ease-in-out
                        ${activeIndex === index
                            ? 'bg-sky-500 text-white shadow-lg'
                            : 'text-slate-600 hover:bg-sky-100'
                        }
                    `}
                >
                    {scenario.title}
                </button>
            ))}
        </div>
    );
};
