
import React from 'react';

const BookIcon = () => (
    <svg xmlns="http://www.w3.org/2000/svg" className="h-10 w-10 text-amber-500" viewBox="0 0 20 20" fill="currentColor">
        <path d="M9 4.804A7.968 7.968 0 005.5 4c-1.255 0-2.443.29-3.5.804v10A7.969 7.969 0 015.5 14c1.669 0 3.218.51 4.5 1.385A7.962 7.962 0 0114.5 14c1.255 0 2.443.29 3.5.804v-10A7.968 7.968 0 0014.5 4c-1.255 0-2.443.29-3.5.804V12a1 1 0 11-2 0V4.804z" />
    </svg>
);

export const Header: React.FC = () => (
    <div className="text-center mb-8">
        <div className="flex justify-center items-center gap-4">
            <BookIcon />
            <h1 className="text-4xl font-bold text-sky-700">好词好句练习</h1>
        </div>
        <p className="text-slate-500 mt-2 text-lg">选择一个情景，然后用更生动的词语来完成句子吧！</p>
    </div>
);
