
import React from 'react';

interface FeedbackBubbleProps {
  feedback: string;
  error: string;
  isLoading: boolean;
}

const LoadingSpinner = () => (
    <div className="flex items-center justify-center space-x-2">
        <div className="w-3 h-3 rounded-full bg-yellow-400 animate-bounce [animation-delay:-0.3s]"></div>
        <div className="w-3 h-3 rounded-full bg-yellow-400 animate-bounce [animation-delay:-0.15s]"></div>
        <div className="w-3 h-3 rounded-full bg-yellow-400 animate-bounce"></div>
        <span className="ml-2 text-slate-500">老师正在思考...</span>
    </div>
);

const TeacherIcon = () => (
    <div className="w-12 h-12 bg-amber-400 rounded-full flex items-center justify-center text-white text-2xl font-bold shadow-md shrink-0">
        师
    </div>
);

const FeedbackBubble: React.FC<FeedbackBubbleProps> = ({ feedback, error, isLoading }) => {
  if (!feedback && !error && !isLoading) {
    return <div className="min-h-[100px]"></div>; // Reserve space
  }

  return (
    <div className="flex items-start gap-4 p-4 transition-all duration-300">
      <TeacherIcon />
      <div className="relative mt-2 bg-white rounded-xl rounded-tl-none shadow-lg border border-slate-200 p-5 min-w-[200px] min-h-[80px] flex items-center">
        <div className="absolute -left-2 top-0 w-0 h-0 border-l-8 border-l-transparent border-t-8 border-t-white transform -translate-y-full"></div>
        {isLoading && <LoadingSpinner />}
        {!isLoading && error && <p className="text-red-600">{error}</p>}
        {!isLoading && feedback && <p className="text-slate-700 leading-relaxed">{feedback}</p>}
      </div>
    </div>
  );
};

export default FeedbackBubble;
