
import { GoogleGenAI } from "@google/genai";

if (!process.env.API_KEY) {
  throw new Error("API_KEY environment variable is not set");
}

const ai = new GoogleGenAI({ apiKey: process.env.API_KEY });

export const getFeedbackForIdiom = async (
  originalSentence: string,
  originalWord: string,
  selectedIdiom: string
): Promise<string> => {
  const model = 'gemini-2.5-flash';
  
  const systemInstruction = `你是一位耐心友善的新加坡小学五年级华文老师。你的任务是针对学生选择的“好词好句”给出简单、鼓励性的反馈。
- 语言要非常简单，适合11岁的孩子。
- 总是先表扬学生的尝试。
- 如果词语用对了，解释为什么用得好。
- 如果词语用错了，温和地解释为什么不合适，并鼓励他们再试一次。
- 回答必须使用简体中文。
- 回答要简短，大概2-3句话。`;

  const prompt = `
学生正在学习用“好词好句”来代替简单的词语。
原始句子是：“${originalSentence}”
他们尝试用“${selectedIdiom}”来代替“${originalWord}”。

请根据这个选择，给出你的反馈。
`;

  try {
    const response = await ai.models.generateContent({
      model: model,
      contents: prompt,
      config: {
        systemInstruction: systemInstruction,
        temperature: 0.5,
        topK: 32,
        topP: 1,
      }
    });
    return response.text;
  } catch (error) {
    console.error("Gemini API call failed:", error);
    throw new Error("Failed to get feedback from Gemini API.");
  }
};
