
import React from 'react';
import type { Scenario, Idiom } from '../types';

interface ScenarioViewProps {
  scenario: Scenario;
  selectedIdiom: Idiom | null;
  onIdiomSelect: (idiom: Idiom) => void;
  isLoading: boolean;
}

const ScenarioView: React.FC<ScenarioViewProps> = ({ scenario, selectedIdiom, onIdiomSelect, isLoading }) => {
  return (
    <div className="bg-white p-8 rounded-2xl shadow-lg border border-slate-200 transition-all duration-500">
      {/* Sentence Display */}
      <div className="text-center bg-amber-100 p-6 rounded-xl border-2 border-amber-200 min-h-[80px] flex items-center justify-center">
        <p className="text-2xl text-slate-700 leading-relaxed">
          {scenario.parts[0]}
          <span className={`inline-block mx-2 px-3 py-1 rounded-lg transition-all duration-300 font-semibold
            ${selectedIdiom ? 'bg-green-200 text-green-800' : 'bg-red-200 text-red-800'}`}>
            {selectedIdiom ? selectedIdiom.word : scenario.targetWord}
          </span>
          {scenario.parts[1]}
        </p>
      </div>

      {/* Idiom Choices */}
      <div className="mt-8">
        <h3 className="text-lg font-bold text-center text-slate-500 mb-4">选择一个合适的词语:</h3>
        <div className="grid grid-cols-2 md:grid-cols-4 gap-4">
          {scenario.idioms.map((idiom) => (
            <button
              key={idiom.word}
              onClick={() => onIdiomSelect(idiom)}
              disabled={isLoading}
              className={`p-4 rounded-xl text-center transition-all duration-200 ease-in-out transform 
                border-2 
                ${selectedIdiom?.word === idiom.word ? 'bg-sky-500 text-white border-sky-600 ring-4 ring-sky-200 scale-105' : 'bg-sky-100 hover:bg-sky-200 border-sky-200 text-sky-800 hover:scale-105'}
                disabled:opacity-50 disabled:cursor-not-allowed disabled:transform-none`}
            >
              <span className="font-bold text-xl">{idiom.word}</span>
              <span className="block text-sm opacity-70 mt-1">{idiom.pinyin}</span>
            </button>
          ))}
        </div>
      </div>
    </div>
  );
};

export default ScenarioView;
