function MatterFlowChart(_topFrame,_libraryPath,_codebasePath, _inputParameters) {
  var _model = EJSS_CORE.createAnimationLMS();
  var _view;
  var _isPlaying = false;
  var _isPaused = true;
  var _isMobile = (navigator===undefined) ? false : navigator.userAgent.match(/iPhone|iPad|iPod|Android|BlackBerry|Opera Mini|IEMobile/i);

var _stringProperties = {};
  var _tools = EJSS_CORE.Tools;
  function _play()  { _isPaused = false; _isPlaying = true;  _model.play();  }
  function _pause() { _isPaused = true;  _isPlaying = false; _model.pause(); }
  function _step()  { _pause();  _model.step(); }
  function _reset() { _model.reset();  _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); }
  _model._play  = _play;
  _model._pause = _pause;
  _model._step  = _step;
  _model._reset = _reset;
  function _update() { _model.update(); }
  function _initialize() { _model.initialize(); }
  function _setFPS(_fps) { _model.setFPS(_fps); }
  function _setDelay(_delay) { _model.setDelay(_delay); }
  function _setStepsPerDisplay(_spd) { _model.setStepsPerDisplay(_spd); }
  function _setUpdateView(_updateView) { _model.setUpdateView(_updateView); }
  function _setAutoplay(_auto) { _model.setAutoplay(_auto); }
  function _println(_message) { console.log(_message); }

  function _breakAfterThisPage() { _model.setShouldBreak(true); }

  function _resetSolvers() { if (_model.resetSolvers) _model.resetSolvers(); }

  function _saveText(name,type,content) { if (_model.saveText) _model.saveText(name,type,content); }

  function _saveState(name) { if (_model.saveState) _model.saveState(name); }

  function _saveImage(name,panelname) { if (_model.saveImage) _model.saveImage(name,panelname); }

  function _readState(url,type) { if (_model.readState) _model.readState(url,type); }

  function _readText(url,type,varname) { if (_model.readText) _model.readText(url,type,varname); }

  function _getStringProperty(propertyName) {
    var _value = _stringProperties[propertyName];
    if (_value===undefined) return propertyName;
    else return _value;
  }
  var __pagesEnabled = [];
  function _setPageEnabled(pageName,enabled) { __pagesEnabled[pageName] = enabled; }

  var questions; // EjsS Model.Variables.EditableVariable.questions
  var fontquestion; // EjsS Model.Variables.EditableVariable.fontquestion
  var numOfQuestions; // EjsS Model.Variables.EditableVariable.numOfQuestions
  var animals; // EjsS Model.Variables.EditableVariable.animals
  var numOfAnimals; // EjsS Model.Variables.EditableVariable.numOfAnimals
  var answers; // EjsS Model.Variables.EditableVariable.answers
  var title; // EjsS Model.Variables.EditableVariable.title
  var instructionstext; // EjsS Model.Variables.EditableVariable.instructionstext
  var completionText; // EjsS Model.Variables.EditableVariable.completionText
  var completionCount; // EjsS Model.Variables.EditableVariable.completionCount
  var automove; // EjsS Model.Variables.EditableVariable.automove
  var bottompanel; // EjsS Model.Variables.EditableVariable.bottompanel
  var first; // EjsS Model.Variables.EditableVariable.first
  var start; // EjsS Model.Variables.EditableVariable.start

  var btnCSS; // EjsS Model.Variables.CSS.btnCSS
  var btnmenushow; // EjsS Model.Variables.CSS.btnmenushow

  var yPos; // EjsS Model.Variables.Question Display.yPos
  var xPos; // EjsS Model.Variables.Question Display.xPos
  var minY; // EjsS Model.Variables.Question Display.minY
  var boxHeight; // EjsS Model.Variables.Question Display.boxHeight
  var boxWidth; // EjsS Model.Variables.Question Display.boxWidth
  var boxGap; // EjsS Model.Variables.Question Display.boxGap
  var inputAns; // EjsS Model.Variables.Question Display.inputAns

  var animalXPos; // EjsS Model.Variables.Animal Display.animalXPos
  var animalYPos; // EjsS Model.Variables.Animal Display.animalYPos
  var interact; // EjsS Model.Variables.Animal Display.interact
  var animalGap; // EjsS Model.Variables.Animal Display.animalGap
  var animalCompleted; // EjsS Model.Variables.Animal Display.animalCompleted
  var animalXOrig; // EjsS Model.Variables.Animal Display.animalXOrig
  var animalYOrig; // EjsS Model.Variables.Animal Display.animalYOrig

  var pending; // EjsS Model.Variables.Pending.pending
  var pendingAnimal; // EjsS Model.Variables.Pending.pendingAnimal
  var pendingIdx; // EjsS Model.Variables.Pending.pendingIdx
  var pendingYPos; // EjsS Model.Variables.Pending.pendingYPos
  var pendingXPos; // EjsS Model.Variables.Pending.pendingXPos

  var finalXPos; // EjsS Model.Variables.Final.finalXPos
  var finalYPos; // EjsS Model.Variables.Final.finalYPos

  var noArrowYPos; // EjsS Model.Variables.Arrows.noArrowYPos
  var yesArrowLength; // EjsS Model.Variables.Arrows.yesArrowLength

  var yesYPos; // EjsS Model.Variables.Yes No Text.yesYPos
  var yesXPos; // EjsS Model.Variables.Yes No Text.yesXPos
  var noYPos; // EjsS Model.Variables.Yes No Text.noYPos
  var noXPos; // EjsS Model.Variables.Yes No Text.noXPos

  var animate; // EjsS Model.Variables.Animate.animate
  var animateDuration; // EjsS Model.Variables.Animate.animateDuration
  var animateInit; // EjsS Model.Variables.Animate.animateInit
  var speedX; // EjsS Model.Variables.Animate.speedX
  var speedY; // EjsS Model.Variables.Animate.speedY
  var destX; // EjsS Model.Variables.Animate.destX
  var destY; // EjsS Model.Variables.Animate.destY
  var curDistX; // EjsS Model.Variables.Animate.curDistX
  var curDistY; // EjsS Model.Variables.Animate.curDistY
  var prevDistX; // EjsS Model.Variables.Animate.prevDistX

  var pi; // EjsS Model.Variables.lookang.pi
  var actualAns; // EjsS Model.Variables.lookang.actualAns
  var givenAns; // EjsS Model.Variables.lookang.givenAns
  var t; // EjsS Model.Variables.lookang.t
  var dt; // EjsS Model.Variables.lookang.dt
  var font; // EjsS Model.Variables.lookang.font
  var elementinteractedq; // EjsS Model.Variables.lookang.elementinteractedq
  var readQuestion; // EjsS Model.Variables.lookang.readQuestion
  var clicked; // EjsS Model.Variables.lookang.clicked

  _model.getOdes = function() { return []; };

  _model.removeEvents = function(){
  };

  function _serialize() { return _model.serialize(); }

  _model._userSerialize = function() {
    return {
      questions : questions,
      fontquestion : fontquestion,
      numOfQuestions : numOfQuestions,
      animals : animals,
      numOfAnimals : numOfAnimals,
      answers : answers,
      title : title,
      instructionstext : instructionstext,
      completionText : completionText,
      completionCount : completionCount,
      automove : automove,
      bottompanel : bottompanel,
      first : first,
      start : start,
      btnCSS : btnCSS,
      btnmenushow : btnmenushow,
      yPos : yPos,
      xPos : xPos,
      minY : minY,
      boxHeight : boxHeight,
      boxWidth : boxWidth,
      boxGap : boxGap,
      inputAns : inputAns,
      animalXPos : animalXPos,
      animalYPos : animalYPos,
      interact : interact,
      animalGap : animalGap,
      animalCompleted : animalCompleted,
      animalXOrig : animalXOrig,
      animalYOrig : animalYOrig,
      pending : pending,
      pendingAnimal : pendingAnimal,
      pendingIdx : pendingIdx,
      pendingYPos : pendingYPos,
      pendingXPos : pendingXPos,
      finalXPos : finalXPos,
      finalYPos : finalYPos,
      noArrowYPos : noArrowYPos,
      yesArrowLength : yesArrowLength,
      yesYPos : yesYPos,
      yesXPos : yesXPos,
      noYPos : noYPos,
      noXPos : noXPos,
      animate : animate,
      animateDuration : animateDuration,
      animateInit : animateInit,
      speedX : speedX,
      speedY : speedY,
      destX : destX,
      destY : destY,
      curDistX : curDistX,
      curDistY : curDistY,
      prevDistX : prevDistX,
      pi : pi,
      actualAns : actualAns,
      givenAns : givenAns,
      t : t,
      dt : dt,
      font : font,
      elementinteractedq : elementinteractedq,
      readQuestion : readQuestion,
      clicked : clicked
    };
  };

  _model._readParameters = function(json) {
    if(typeof json.questions != "undefined") questions = json.questions;
    if(typeof json.fontquestion != "undefined") fontquestion = json.fontquestion;
    if(typeof json.numOfQuestions != "undefined") numOfQuestions = json.numOfQuestions;
    if(typeof json.animals != "undefined") animals = json.animals;
    if(typeof json.numOfAnimals != "undefined") numOfAnimals = json.numOfAnimals;
    if(typeof json.answers != "undefined") answers = json.answers;
    if(typeof json.title != "undefined") title = json.title;
    if(typeof json.instructionstext != "undefined") instructionstext = json.instructionstext;
    if(typeof json.completionText != "undefined") completionText = json.completionText;
    if(typeof json.completionCount != "undefined") completionCount = json.completionCount;
    if(typeof json.automove != "undefined") automove = json.automove;
    if(typeof json.bottompanel != "undefined") bottompanel = json.bottompanel;
    if(typeof json.first != "undefined") first = json.first;
    if(typeof json.start != "undefined") start = json.start;
    if(typeof json.btnCSS != "undefined") btnCSS = json.btnCSS;
    if(typeof json.btnmenushow != "undefined") btnmenushow = json.btnmenushow;
    if(typeof json.yPos != "undefined") yPos = json.yPos;
    if(typeof json.xPos != "undefined") xPos = json.xPos;
    if(typeof json.minY != "undefined") minY = json.minY;
    if(typeof json.boxHeight != "undefined") boxHeight = json.boxHeight;
    if(typeof json.boxWidth != "undefined") boxWidth = json.boxWidth;
    if(typeof json.boxGap != "undefined") boxGap = json.boxGap;
    if(typeof json.inputAns != "undefined") inputAns = json.inputAns;
    if(typeof json.animalXPos != "undefined") animalXPos = json.animalXPos;
    if(typeof json.animalYPos != "undefined") animalYPos = json.animalYPos;
    if(typeof json.interact != "undefined") interact = json.interact;
    if(typeof json.animalGap != "undefined") animalGap = json.animalGap;
    if(typeof json.animalCompleted != "undefined") animalCompleted = json.animalCompleted;
    if(typeof json.animalXOrig != "undefined") animalXOrig = json.animalXOrig;
    if(typeof json.animalYOrig != "undefined") animalYOrig = json.animalYOrig;
    if(typeof json.pending != "undefined") pending = json.pending;
    if(typeof json.pendingAnimal != "undefined") pendingAnimal = json.pendingAnimal;
    if(typeof json.pendingIdx != "undefined") pendingIdx = json.pendingIdx;
    if(typeof json.pendingYPos != "undefined") pendingYPos = json.pendingYPos;
    if(typeof json.pendingXPos != "undefined") pendingXPos = json.pendingXPos;
    if(typeof json.finalXPos != "undefined") finalXPos = json.finalXPos;
    if(typeof json.finalYPos != "undefined") finalYPos = json.finalYPos;
    if(typeof json.noArrowYPos != "undefined") noArrowYPos = json.noArrowYPos;
    if(typeof json.yesArrowLength != "undefined") yesArrowLength = json.yesArrowLength;
    if(typeof json.yesYPos != "undefined") yesYPos = json.yesYPos;
    if(typeof json.yesXPos != "undefined") yesXPos = json.yesXPos;
    if(typeof json.noYPos != "undefined") noYPos = json.noYPos;
    if(typeof json.noXPos != "undefined") noXPos = json.noXPos;
    if(typeof json.animate != "undefined") animate = json.animate;
    if(typeof json.animateDuration != "undefined") animateDuration = json.animateDuration;
    if(typeof json.animateInit != "undefined") animateInit = json.animateInit;
    if(typeof json.speedX != "undefined") speedX = json.speedX;
    if(typeof json.speedY != "undefined") speedY = json.speedY;
    if(typeof json.destX != "undefined") destX = json.destX;
    if(typeof json.destY != "undefined") destY = json.destY;
    if(typeof json.curDistX != "undefined") curDistX = json.curDistX;
    if(typeof json.curDistY != "undefined") curDistY = json.curDistY;
    if(typeof json.prevDistX != "undefined") prevDistX = json.prevDistX;
    if(typeof json.pi != "undefined") pi = json.pi;
    if(typeof json.actualAns != "undefined") actualAns = json.actualAns;
    if(typeof json.givenAns != "undefined") givenAns = json.givenAns;
    if(typeof json.t != "undefined") t = json.t;
    if(typeof json.dt != "undefined") dt = json.dt;
    if(typeof json.font != "undefined") font = json.font;
    if(typeof json.elementinteractedq != "undefined") elementinteractedq = json.elementinteractedq;
    if(typeof json.readQuestion != "undefined") readQuestion = json.readQuestion;
    if(typeof json.clicked != "undefined") clicked = json.clicked;
  };

  function _unserialize(json) { return _model.unserialize(json); }

  _model.addToReset(function() {
    __pagesEnabled["Init Page"] = true;
    __pagesEnabled["undefinedCSS"] = true;
    __pagesEnabled["htmlBlink"] = true;
    __pagesEnabled["update"] = true;
    __pagesEnabled["Evol Page"] = true;
    __pagesEnabled["moodle"] = true;
  });

  _model.addToReset(function() {
    questions = [   "Does it have a\n fixed shape?",   "Does it have a\n fixed volume?" ]; // EjsS Model.Variables.EditableVariable.questions
    fontquestion = "normal normal 1.3vw "; // EjsS Model.Variables.EditableVariable.fontquestion
    numOfQuestions = questions.length; // EjsS Model.Variables.EditableVariable.numOfQuestions
    animals = [   "Solid",    "Liquid",   "Gas" ]; // EjsS Model.Variables.EditableVariable.animals
    numOfAnimals = animals.length; // EjsS Model.Variables.EditableVariable.numOfAnimals
    answers = [0, 1, 2]; // EjsS Model.Variables.EditableVariable.answers
    title = "Matter"; // EjsS Model.Variables.EditableVariable.title
    instructionstext = "Start by clicking on a/an " +title; // EjsS Model.Variables.EditableVariable.instructionstext
    completionText = "Good job, you have completed the flowchart!"; // EjsS Model.Variables.EditableVariable.completionText
    completionCount = 0; // EjsS Model.Variables.EditableVariable.completionCount
    automove = true; // EjsS Model.Variables.EditableVariable.automove
    bottompanel = "inline-block"; // EjsS Model.Variables.EditableVariable.bottompanel
    first = true; // EjsS Model.Variables.EditableVariable.first
  });

  _model.addToReset(function() {
  });

  _model.addToReset(function() {
    yPos = new Array(numOfQuestions); // EjsS Model.Variables.Question Display.yPos
    xPos = 0; // EjsS Model.Variables.Question Display.xPos
    minY = 0; // EjsS Model.Variables.Question Display.minY
    boxHeight = 8; // EjsS Model.Variables.Question Display.boxHeight
    boxWidth = boxHeight; // EjsS Model.Variables.Question Display.boxWidth
    boxGap = 10; // EjsS Model.Variables.Question Display.boxGap
    inputAns = ""; // EjsS Model.Variables.Question Display.inputAns
  });

  _model.addToReset(function() {
    animalXPos = new Array(numOfAnimals); // EjsS Model.Variables.Animal Display.animalXPos
    (function () {
      var _i0;
      for (_i0=0; _i0<numOfAnimals; _i0+=1) {  // EjsS Model.Variables.Animal Display.animalXPos
        animalXPos[_i0] = 0;  // EjsS Model.Variables.Animal Display.animalXPos
      }
    }());
    animalYPos = new Array(numOfAnimals); // EjsS Model.Variables.Animal Display.animalYPos
    (function () {
      var _i0;
      for (_i0=0; _i0<numOfAnimals; _i0+=1) {  // EjsS Model.Variables.Animal Display.animalYPos
        animalYPos[_i0] = boxHeight / 2 + 1;  // EjsS Model.Variables.Animal Display.animalYPos
      }
    }());
    animalGap = 10; // EjsS Model.Variables.Animal Display.animalGap
    animalCompleted = new Array(numOfAnimals); // EjsS Model.Variables.Animal Display.animalCompleted
    (function () {
      var _i0;
      for (_i0=0; _i0<numOfAnimals; _i0+=1) {  // EjsS Model.Variables.Animal Display.animalCompleted
        animalCompleted[_i0] = 0;  // EjsS Model.Variables.Animal Display.animalCompleted
      }
    }());
    animalXOrig = new Array(numOfAnimals); // EjsS Model.Variables.Animal Display.animalXOrig
    animalYOrig = new Array(numOfAnimals); // EjsS Model.Variables.Animal Display.animalYOrig
  });

  _model.addToReset(function() {
    pending = 0; // EjsS Model.Variables.Pending.pending
    pendingAnimal = 0; // EjsS Model.Variables.Pending.pendingAnimal
    pendingIdx = 0; // EjsS Model.Variables.Pending.pendingIdx
    pendingYPos = new Array(numOfQuestions); // EjsS Model.Variables.Pending.pendingYPos
    pendingXPos = -(boxWidth / 2) - 5; // EjsS Model.Variables.Pending.pendingXPos
  });

  _model.addToReset(function() {
    finalXPos = new Array(numOfQuestions); // EjsS Model.Variables.Final.finalXPos
    (function () {
      var _i0;
      for (_i0=0; _i0<numOfQuestions; _i0+=1) {  // EjsS Model.Variables.Final.finalXPos
        finalXPos[_i0] = 0;  // EjsS Model.Variables.Final.finalXPos
      }
    }());
    finalYPos = new Array(numOfQuestions); // EjsS Model.Variables.Final.finalYPos
    (function () {
      var _i0;
      for (_i0=0; _i0<numOfQuestions; _i0+=1) {  // EjsS Model.Variables.Final.finalYPos
        finalYPos[_i0] = 0;  // EjsS Model.Variables.Final.finalYPos
      }
    }());
  });

  _model.addToReset(function() {
    noArrowYPos = new Array(numOfQuestions); // EjsS Model.Variables.Arrows.noArrowYPos
    (function () {
      var _i0;
      for (_i0=0; _i0<numOfQuestions; _i0+=1) {  // EjsS Model.Variables.Arrows.noArrowYPos
        noArrowYPos[_i0] = 0;  // EjsS Model.Variables.Arrows.noArrowYPos
      }
    }());
    yesArrowLength = boxWidth; // EjsS Model.Variables.Arrows.yesArrowLength
  });

  _model.addToReset(function() {
    yesYPos = new Array(numOfQuestions); // EjsS Model.Variables.Yes No Text.yesYPos
    yesXPos = yesArrowLength / 2 + boxWidth / 2; // EjsS Model.Variables.Yes No Text.yesXPos
    noYPos = new Array(numOfQuestions); // EjsS Model.Variables.Yes No Text.noYPos
    noXPos = -0.5; // EjsS Model.Variables.Yes No Text.noXPos
  });

  _model.addToReset(function() {
    animate = false; // EjsS Model.Variables.Animate.animate
    animateDuration = 1; // EjsS Model.Variables.Animate.animateDuration
    animateInit = false; // EjsS Model.Variables.Animate.animateInit
  });

  _model.addToReset(function() {
    pi = Math.PI; // EjsS Model.Variables.lookang.pi
    t = 0; // EjsS Model.Variables.lookang.t
    dt = 0.05; // EjsS Model.Variables.lookang.dt
    font = "normal normal 2vw "; // EjsS Model.Variables.lookang.font
    elementinteractedq = -1; // EjsS Model.Variables.lookang.elementinteractedq
  });

  if (_inputParameters) {
    _inputParameters = _model.parseInputParameters(_inputParameters);
    if (_inputParameters) _model.addToReset(function() { _model._readParameters(_inputParameters); });
  }

  _model.addToReset(function() {
    _model.setAutoplay(true);
    _model.setPauseOnPageExit(true);
    _model.setFPS(20);
    _model.setStepsPerDisplay(1);
  });

  const _debugMode = false;  // > CustomCode.questionLib:1
  const questionStack = [];  // > CustomCode.questionLib:2
  const questionHistory = Object.create(null);  // > CustomCode.questionLib:3
  const _nullFunction = _debugMode ?   // > CustomCode.questionLib:4
    console.log  // > CustomCode.questionLib:5
    :  // > CustomCode.questionLib:6
    function(){};  // > CustomCode.questionLib:7
  // for assessment.json event - start  // > CustomCode.questionLib:8
  function startQuestion(questionName) {  // > CustomCode.questionLib:9
    _view._addInteraction(_nullFunction, {action:"questionStart", name:questionName}, {element:"questionLib", property:"value"});  // > CustomCode.questionLib:10
    questionStack.push(questionName);  // > CustomCode.questionLib:11
  }  // > CustomCode.questionLib:12
  // for assessment.json history  // > CustomCode.questionLib:13
  function _addQuestionHistory(questionName, history) {  // > CustomCode.questionLib:14
    if (!(questionName in questionHistory)) {  // > CustomCode.questionLib:15
      questionHistory[questionName] = [];  // > CustomCode.questionLib:16
    }  // > CustomCode.questionLib:17
    questionHistory[questionName].push(history);  // > CustomCode.questionLib:18
  }  // > CustomCode.questionLib:19
  function _getQuestionHistory(questionName) {  // > CustomCode.questionLib:20
    if (questionName in questionHistory) {  // > CustomCode.questionLib:21
      return questionHistory[questionName].join("\n");  // > CustomCode.questionLib:22
    } else {  // > CustomCode.questionLib:23
      return "";  // > CustomCode.questionLib:24
    }  // > CustomCode.questionLib:25
  }  // > CustomCode.questionLib:26
  function addQuestionHistory(history) {  // > CustomCode.questionLib:27
    if (questionStack.length > 0) {  // > CustomCode.questionLib:28
      const questionName = questionStack[questionStack.length - 1];  // > CustomCode.questionLib:29
      _addQuestionHistory(questionName, history);  // > CustomCode.questionLib:30
    }  // > CustomCode.questionLib:31
  }  // > CustomCode.questionLib:32
  // for assessment.json event - states  // > CustomCode.questionLib:33
  function onAnswer(answer, isCorrect=false, history=answer) {  // > CustomCode.questionLib:34
    if (questionStack.length > 0) {  // > CustomCode.questionLib:35
      const explainer = {};  // > CustomCode.questionLib:36
      //explainer[true] = " (correct)";  // > CustomCode.questionLib:37
      explainer[true] = " ✅"; // added unicode  // > CustomCode.questionLib:38
      //explainer[false] = " (incorrect)";  // > CustomCode.questionLib:39
      explainer[false] = " ❌"; // added unicode  // > CustomCode.questionLib:40
      const questionName = questionStack[questionStack.length - 1];  // > CustomCode.questionLib:41
      _addQuestionHistory(questionName, history + explainer[isCorrect]);  // > CustomCode.questionLib:42
      const outputHistory = _getQuestionHistory(questionName);  // > CustomCode.questionLib:43
      _view._addInteraction(_nullFunction, {name:questionName, answer:answer, isCorrect:isCorrect, action:"questionAnswer"}, {property: "answer", element:"questionLib"});  // > CustomCode.questionLib:44
      _view._addInteraction(_nullFunction, outputHistory, {property: "history", element: "questionLib"});  // > CustomCode.questionLib:45
    }  // > CustomCode.questionLib:46
  }  // > CustomCode.questionLib:47
  // for assessment.json event - end  // > CustomCode.questionLib:48
  function endQuestion() {  // > CustomCode.questionLib:49
    if (questionStack.length > 0) {  // > CustomCode.questionLib:50
      const questionName = questionStack.pop();  // > CustomCode.questionLib:51
      _view._addInteraction(_nullFunction, {action:"questionEnd", name:questionName}, {element: "questionLib", property: "value"});  // > CustomCode.questionLib:52
    }  // > CustomCode.questionLib:53
  }  // > CustomCode.questionLib:54
  // for assessment.json marks  // > CustomCode.questionLib:55
  function awardQuestionMarks(marks=1) {  // > CustomCode.questionLib:56
    if (questionStack.length > 0) {  // > CustomCode.questionLib:57
      const questionName = questionStack[questionStack.length - 1];  // > CustomCode.questionLib:58
      _view._addInteraction(_nullFunction, marks, {element:"questionLib", property:"awardMarkFor"+questionName});  // > CustomCode.questionLib:59
    }  // > CustomCode.questionLib:60
  }  // > CustomCode.questionLib:61

  function EditableFunction () {  // > CustomCode.EditableFunction:1
    console.log(questions)  // > CustomCode.EditableFunction:2
  }  // > CustomCode.EditableFunction:3

  function checkAnswer(inputAns) {  // > CustomCode.checkAnswer:1
    // while the animation is playing, do not allow answering of question  // > CustomCode.checkAnswer:2
    if(animate || !pending)  // > CustomCode.checkAnswer:3
    return;  // > CustomCode.checkAnswer:4
    // answering checking  // > CustomCode.checkAnswer:5
    // (1 represents a yes, -1 represents a no)  // > CustomCode.checkAnswer:6
    //var givenAns = inputAns == "yes" ? 1 : -1;  // > CustomCode.checkAnswer:7
    //var actualAns = answers[pendingAnimal] == pendingIdx ? 1 : -1;  // > CustomCode.checkAnswer:8
    inputAns = inputAns.trim().toLowerCase();  // > CustomCode.checkAnswer:9
    let givenAns = inputAns == "yes" ? 1 : -1;  // > CustomCode.checkAnswer:10
    //givenAns =  -1;  // > CustomCode.checkAnswer:11
    let actualAns = answers[pendingAnimal] == pendingIdx ? 1 : -1;  // > CustomCode.checkAnswer:12
    onAnswer(inputAns, givenAns == actualAns);  // > CustomCode.checkAnswer:13
    // if the answer is wrong  // > CustomCode.checkAnswer:14
    if(givenAns != actualAns) {  // > CustomCode.checkAnswer:15
      _tools.showOkDialog("Wrong answer...try again!");  // > CustomCode.checkAnswer:16
    }  // > CustomCode.checkAnswer:17
    // if the answer is correct  // > CustomCode.checkAnswer:18
    else {  // > CustomCode.checkAnswer:19
      // check if the value is "no" and not last question yet  // > CustomCode.checkAnswer:20
      if(actualAns == -1 && pendingIdx + 1 < numOfQuestions) {  // > CustomCode.checkAnswer:21
        pendingIdx++;  // > CustomCode.checkAnswer:22
        // setting animation  // > CustomCode.checkAnswer:23
        destX = pendingXPos;  // > CustomCode.checkAnswer:24
        destY = pendingYPos[pendingIdx];  // > CustomCode.checkAnswer:25
        animate = true;  // > CustomCode.checkAnswer:26
        addQuestionHistory(questions[pendingIdx]); //moodle  // > CustomCode.checkAnswer:27
      }  // > CustomCode.checkAnswer:28
      // value is "yes", or last question  // > CustomCode.checkAnswer:29
      else {  // > CustomCode.checkAnswer:30
        completionCount++;  // > CustomCode.checkAnswer:31
        //   score = score+1; // lookang attempt to add score  // > CustomCode.checkAnswer:32
        animalCompleted[pendingAnimal] = 1;  // > CustomCode.checkAnswer:33
  for (var i=0; i<numOfAnimals /* Iterations */ ; i++) {  // > CustomCode.checkAnswer:34
    var detectClearanceHeight = 1  // > CustomCode.checkAnswer:35
    if (animalYPos[i]>=detectClearanceHeight){  // > CustomCode.checkAnswer:36
      enableBlinking("animalSet["+i+"]")  // > CustomCode.checkAnswer:37
      }  // > CustomCode.checkAnswer:38
  }  // > CustomCode.checkAnswer:39
        // adjusting for last question  // > CustomCode.checkAnswer:40
        if(actualAns == -1) {  // > CustomCode.checkAnswer:41
          pendingIdx += 1;  // > CustomCode.checkAnswer:42
        }  // > CustomCode.checkAnswer:43
        // setting animation  // > CustomCode.checkAnswer:44
        destX = finalXPos[pendingIdx];  // > CustomCode.checkAnswer:45
        destY = finalYPos[pendingIdx];  // > CustomCode.checkAnswer:46
        animate = true;  // > CustomCode.checkAnswer:47
        // change the finalXPos for future animals  // > CustomCode.checkAnswer:48
        finalXPos[pendingIdx] += animalGap;  // > CustomCode.checkAnswer:49
        // reset  // > CustomCode.checkAnswer:50
        pending = 0;  // > CustomCode.checkAnswer:51
        pendingIdx = 0;  // > CustomCode.checkAnswer:52
        awardQuestionMarks(); //moodle  // > CustomCode.checkAnswer:53
        endQuestion(); //moodle  // > CustomCode.checkAnswer:54
      }  // > CustomCode.checkAnswer:55
    }  // > CustomCode.checkAnswer:56
  }  // > CustomCode.checkAnswer:57

  // copy this custom function  // > CustomCode.Speech:1
  // in iOS need to add speech to the play button as On iOS the API works but must be triggered by a user action callback, like a response to a tap event, to provide a better experience to users and avoid unexpected sounds out of your phone  // > CustomCode.Speech:2
  function speech (option) {  // > CustomCode.Speech:3
  try { // allow code to run in Student Learning Space   // > CustomCode.Speech:4
  var isCordova = (!!this.parent.cordova || !!window.cordova);  // > CustomCode.Speech:5
  if(isCordova) { // check it is running in Android or iOS  // > CustomCode.Speech:6
         // parent.TTS.speak({text:option,locale:'zh-CN'});  // > CustomCode.Speech:7
    parent.TTS.speak({text:option,locale:'us-EN'});  // > CustomCode.Speech:8
    // parent.TTS.speak({text:option,locale:'en-US'});  // > CustomCode.Speech:9
    // parent.TTS.speak({text:option,locale:'id-ID'});  // > CustomCode.Speech:10
  }   // > CustomCode.Speech:11
  }   // > CustomCode.Speech:12
  catch(e) {  // > CustomCode.Speech:13
    var isCordova = false;  // > CustomCode.Speech:14
    }  // > CustomCode.Speech:15
      // > CustomCode.Speech:16
     var msg = new SpeechSynthesisUtterance(option);  // > CustomCode.Speech:17
    //https://stackoverflow.com/questions/43983845/speechsynthesis-api-for-chinese-firefox  // > CustomCode.Speech:18
    // Set the text.  // > CustomCode.Speech:19
    //msg.text = option;   // > CustomCode.Speech:20
    //https://forums.developer.apple.com/message/323564#323564  // > CustomCode.Speech:21
    // comment out the next 2 lines for english  // > CustomCode.Speech:22
  //msg.voice = speechSynthesis.getVoices().filter(function(voice) { return voice.name == 'Ting-Ting'; })[0];  // > CustomCode.Speech:23
  //msg.lang = 'zh-CH'; // need for android?  // > CustomCode.Speech:24
  //msg.lang = 'id-ID'; // need for android?  // > CustomCode.Speech:25
  msg.lang = 'us-EN'; // need for android?  // > CustomCode.Speech:26
  //https://flaviocopes.com/speech-synthesis-api/  // > CustomCode.Speech:27
  //debug  // > CustomCode.Speech:28
  //console.log(`Voices #: ${speechSynthesis.getVoices().length}`)  // > CustomCode.Speech:29
  //speechSynthesis.getVoices().forEach(voice => {  // > CustomCode.Speech:30
  // console.log(voice.name, voice.lang)  // > CustomCode.Speech:31
  //})  // > CustomCode.Speech:32
  //debug  // > CustomCode.Speech:33
  // Queue this utterance.  // > CustomCode.Speech:34
  window.speechSynthesis.speak(msg);  // > CustomCode.Speech:35
     // > CustomCode.Speech:36
  }  // > CustomCode.Speech:37

  //custom  // > CustomCode.cssBlinkingHTML:1
  function enableBlinking (elementId) {  // > CustomCode.cssBlinkingHTML:2
    var element = document.getElementById(elementId);  // > CustomCode.cssBlinkingHTML:3
    element.setAttribute("class", "blinking");  // > CustomCode.cssBlinkingHTML:4
  }  // > CustomCode.cssBlinkingHTML:5
  function disableBlinking (elementId) {  // > CustomCode.cssBlinkingHTML:6
    var element = document.getElementById(elementId);  // > CustomCode.cssBlinkingHTML:7
    element.removeAttribute("class");  // > CustomCode.cssBlinkingHTML:8
  }  // > CustomCode.cssBlinkingHTML:9

  _model.addToInitialization(function() {
    if (!__pagesEnabled["Init Page"]) return;
    // starting message  // > Initialization.Init Page:1
    //_tools.showOkDialog("Start by clicking on an animal!");  // > Initialization.Init Page:2
    _tools.showOkDialog(instructionstext);  // > Initialization.Init Page:3
    // filling in the questions  // > Initialization.Init Page:4
    // need to move to EditableVariables  // > Initialization.Init Page:5
    /*  // > Initialization.Init Page:6
    questions = [  // > Initialization.Init Page:7
      "Does it have \n feathers on its body?",  // > Initialization.Init Page:8
      "Does it have \n three pairs of legs?",  // > Initialization.Init Page:9
      "Does it live \n on land?"  // > Initialization.Init Page:10
    ];  // > Initialization.Init Page:11
    numOfQuestions = questions.length;  // > Initialization.Init Page:12
    */  // > Initialization.Init Page:13
    /*  // > Initialization.Init Page:14
    // filling in the animals  // > Initialization.Init Page:15
    // need to move to EditableVariables  // > Initialization.Init Page:16
    animals = [  // > Initialization.Init Page:17
      "Tiger 🐯",   // > Initialization.Init Page:18
      "Rabbit 🐰",  // > Initialization.Init Page:19
      "Butterfly 🦋",  // > Initialization.Init Page:20
      "Pigeon 🐦",  // > Initialization.Init Page:21
      "Guppy 🐟"  // > Initialization.Init Page:22
    ];  // > Initialization.Init Page:23
    numOfAnimals = animals.length;  // > Initialization.Init Page:24
    */  // > Initialization.Init Page:25
    // filling in the answers (numbers correspond to the index of the question that is "yes" on)  // > Initialization.Init Page:26
    //  how the number control Y and N   // > Initialization.Init Page:27
    // 2 is NNY Tiger and rabbit  // > Initialization.Init Page:28
    // 1 is NY butterfly  // > Initialization.Init Page:29
    // 0 is pigeon  // > Initialization.Init Page:30
    // 3 is NNN guppy  // > Initialization.Init Page:31
    // need to move to EditableVariables  // > Initialization.Init Page:32
    //answers = [2, 2, 1, 0, -1];  // > Initialization.Init Page:33
    // filling in the y position of the flowchart questions  // > Initialization.Init Page:34
    minY = 0;  // > Initialization.Init Page:35
    for(var i = 0; i < numOfQuestions; i++){  // > Initialization.Init Page:36
       yPos[i] = minY;  // > Initialization.Init Page:37
       // y position of the pending (intermediate) steps  // > Initialization.Init Page:38
       pendingYPos[i] = yPos[i];  // > Initialization.Init Page:39
       // y position of the 'no' arrows  // > Initialization.Init Page:40
       noArrowYPos[i] = minY - boxHeight / 2;  // > Initialization.Init Page:41
       // y position of the 'no' text  // > Initialization.Init Page:42
       noYPos[i] = noArrowYPos[i] - (boxGap - boxHeight) / 2;  // > Initialization.Init Page:43
       // y position of the 'yes' text  // > Initialization.Init Page:44
       yesYPos[i] = yPos[i] + 1;   // > Initialization.Init Page:45
         // > Initialization.Init Page:46
       minY -= boxGap; // clever code to decrease by boxGap after each iteration of the loop  // > Initialization.Init Page:47
    }  // > Initialization.Init Page:48
    // x position of the final texts   // > Initialization.Init Page:49
    for(var i = 0; i < numOfQuestions; i++){  // > Initialization.Init Page:50
      finalYPos[i] = yPos[i];  // > Initialization.Init Page:51
      finalXPos[i] =  yesArrowLength + boxWidth; // end positions of the animals  // > Initialization.Init Page:52
    }  // > Initialization.Init Page:53
    // adjusting the most bottom final text  // > Initialization.Init Page:54
    // why need this? lookang  // > Initialization.Init Page:55
    //numOfQuestions is the Does it have feathers etc kind of questions =3  // > Initialization.Init Page:56
    // Need to sepcially adjust for the most bottom text i.e. in the example, it would be where the guppy ends up  // > Initialization.Init Page:57
    finalXPos[numOfQuestions] = 0;  // > Initialization.Init Page:58
    finalYPos[numOfQuestions] = minY;  // > Initialization.Init Page:59
    // initialising the x position of the animals text  // > Initialization.Init Page:60
    var curX = 0;  // > Initialization.Init Page:61
    if(numOfAnimals % 2){  // > Initialization.Init Page:62
      curX = (-animalGap) * Math.floor(numOfAnimals / 2);   // > Initialization.Init Page:63
    }  // > Initialization.Init Page:64
    else{  // > Initialization.Init Page:65
      curX = (-animalGap) * (numOfAnimals / 2 - 1) - animalGap / 2;  // > Initialization.Init Page:66
    }  // > Initialization.Init Page:67
    for(var i = 0; i < numOfAnimals; i++){  // > Initialization.Init Page:68
      animalXPos[i] = curX;  // > Initialization.Init Page:69
      curX += animalGap;  // > Initialization.Init Page:70
    }  // > Initialization.Init Page:71
  });

  _model.addToInitialization(function() {
    if (!__pagesEnabled["undefinedCSS"]) return;
    //go to Initialization add  // > Initialization.undefinedCSS:1
    if (btnCSS==undefined){  // > Initialization.undefinedCSS:2
      btnCSS={"animation": "blink 1s step-start infinite"};  // > Initialization.undefinedCSS:3
      btnmenushow=true;  // > Initialization.undefinedCSS:4
      }  // > Initialization.undefinedCSS:5
  });

  _model.addToInitialization(function() {
    if (!__pagesEnabled["htmlBlink"]) return;
    //add anywhere needed  // > Initialization.htmlBlink:1
    window.setTimeout(() => {  // > Initialization.htmlBlink:2
      enableBlinking("animalSet[0]"); // text1 is the name of the element to blink  // > Initialization.htmlBlink:3
    }, 1000);  // > Initialization.htmlBlink:4
    window.setTimeout(() => {  // > Initialization.htmlBlink:5
      enableBlinking("animalSet[1]"); // text1 is the name of the element to blink  // > Initialization.htmlBlink:6
    }, 1000);  // > Initialization.htmlBlink:7
    window.setTimeout(() => {  // > Initialization.htmlBlink:8
      enableBlinking("animalSet[2]"); // text1 is the name of the element to blink  // > Initialization.htmlBlink:9
    }, 1000);  // > Initialization.htmlBlink:10
  });

  _model.addToInitialization(function() {
    if (!__pagesEnabled["update"]) return;
    /*  // > Initialization.update:1
    if (!clicked){  // > Initialization.update:2
      _tools.showOkDialog("Loading....click 'OK' to continue",  // > Initialization.update:3
        function(){   // > Initialization.update:4
        clicked=true;    // > Initialization.update:5
        //_update()  // > Initialization.update:6
        _reset(); // to force update view  // > Initialization.update:7
        //clicked=true;  // > Initialization.update:8
        });  // > Initialization.update:9
        }  // > Initialization.update:10
    */  // > Initialization.update:11
    // new way to make Moodle slow down to reset afrer 500 ms then run the code _reset  // > Initialization.update:12
    // 500 is decided after testing on moodle, as an acceptable delay  // > Initialization.update:13
    if (!clicked){  // > Initialization.update:14
      window.setTimeout(_reset,500)  // > Initialization.update:15
      clicked=true;  // > Initialization.update:16
    }  // > Initialization.update:17
  });

  _model.addToEvolution(function() {
    if (!__pagesEnabled["Evol Page"]) return;
    if(!animate) // animate is move  // > Evolution.Evol Page:1
      return;  // > Evolution.Evol Page:2
    // calculating the distance  // > Evolution.Evol Page:3
    curDistX = destX - animalXPos[pendingAnimal];  // > Evolution.Evol Page:4
    curDistY = destY - animalYPos[pendingAnimal];  // > Evolution.Evol Page:5
    // terminate condition  // > Evolution.Evol Page:6
    if(animateInit && (Math.abs(prevDistX) < Math.abs(curDistX) || Math.abs(prevDistY) < Math.abs(curDistY))){  // > Evolution.Evol Page:7
      animalXPos[pendingAnimal] = destX;  // > Evolution.Evol Page:8
      animalYPos[pendingAnimal] = destY;  // > Evolution.Evol Page:9
      animalXOrig[pendingAnimal] = destX;  // > Evolution.Evol Page:10
      animalYOrig[pendingAnimal] = destY;  // > Evolution.Evol Page:11
        // > Evolution.Evol Page:12
      animate = false;  // > Evolution.Evol Page:13
      animateInit = false;  // > Evolution.Evol Page:14
        // > Evolution.Evol Page:15
      // completion message  // > Evolution.Evol Page:16
      // need to && stronger condition for checking say all animals in finalPos? lookang  // > Evolution.Evol Page:17
       // > Evolution.Evol Page:18
      if(completionCount == numOfAnimals){  // > Evolution.Evol Page:19
        _tools.showOkDialog(completionText);   // > Evolution.Evol Page:20
      }  // > Evolution.Evol Page:21
      return;  // > Evolution.Evol Page:22
    }  // > Evolution.Evol Page:23
        // > Evolution.Evol Page:24
    // calculating the speed of the animation  // > Evolution.Evol Page:25
    if(!animateInit){  // > Evolution.Evol Page:26
      speedX = curDistX / animateDuration;  // > Evolution.Evol Page:27
      speedY = curDistY / animateDuration;  // > Evolution.Evol Page:28
      console.log(speedX, speedY, destX, destY);  // > Evolution.Evol Page:29
      animateInit = true;  // > Evolution.Evol Page:30
    }  // > Evolution.Evol Page:31
    animalXPos[pendingAnimal] += speedX * dt;  // > Evolution.Evol Page:32
    animalYPos[pendingAnimal] += speedY * dt;  // > Evolution.Evol Page:33
    prevDistX = curDistX;  // > Evolution.Evol Page:34
    prevDistY = curDistY;  // > Evolution.Evol Page:35
  });

  _model.addToFixedRelations(function() { _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); });

  _model.addToFixedRelations(function() {
    if (!__pagesEnabled["moodle"]) return;
    if (typeof _model.isRegisterStarted != 'undefined'){  // > FixedRelations.moodle:1
      start = _model.isRegisterStarted();  // > FixedRelations.moodle:2
      if (first && start) {  // > FixedRelations.moodle:3
      first=false; // turn off first so the code runs only once  // > FixedRelations.moodle:4
      }  // > FixedRelations.moodle:5
    }  // > FixedRelations.moodle:6
    //console.log(btnCSS)  // > FixedRelations.moodle:7
  });

  _model.addToFixedRelations(function() { _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); });

    _model._fontResized = function(iBase,iSize,iDelta) {
      _view._fontResized(iBase,iSize,iDelta);
  }; // end of _fontResized

  function _getViews() {
    var _viewsInfo = [];
    var _counter = 0;
    _viewsInfo[_counter++] = { name : "HtmlView Page", width : null, height : null };
    return _viewsInfo;
  } // end of _getViews

  function _selectView(_viewNumber) {
    _view = null;
    _view = new MatterFlowChart_View(_topFrame,_viewNumber,_libraryPath,_codebasePath);
    var _view_super_reset = _view._reset;
    _view._reset = function() {
      _view_super_reset();
      switch(_viewNumber) {
        case -10 : break; // make Lint happy
        default :
        case 0:
          _view.topPanel.linkProperty("Font",  function() { return font; }, function(_v) { font = _v; } ); // HtmlView Page linking property 'Font' for element 'topPanel'
          _view.titleText.linkProperty("Text",  function() { return title+" Flowchart"; } ); // HtmlView Page linking property 'Text' for element 'titleText'
          _view.titleText.linkProperty("Font",  function() { return font; }, function(_v) { font = _v; } ); // HtmlView Page linking property 'Font' for element 'titleText'
          _view.readQuestion.linkProperty("Checked",  function() { return readQuestion; }, function(_v) { readQuestion = _v; } ); // HtmlView Page linking property 'Checked' for element 'readQuestion'
          _view.checkBoxauto.linkProperty("Checked",  function() { return automove; }, function(_v) { automove = _v; } ); // HtmlView Page linking property 'Checked' for element 'checkBoxauto'
          _view.playPauseButton.setAction("OffClick", function(_data,_info) {
  //textspeech="paused";
  isPaused=true;
  _pause();

}); // HtmlView Page setting action 'OffClick' for element 'playPauseButton'
          _view.playPauseButton.linkProperty("State",  function() { return _isPaused; } ); // HtmlView Page linking property 'State' for element 'playPauseButton'
          _view.playPauseButton.setAction("OnClick", function(_data,_info) {
  _play();
  isPaused=false;
  //textspeech="playing";
  //speech("playing");

}); // HtmlView Page setting action 'OnClick' for element 'playPauseButton'
          _view.playPauseButton.linkProperty("Font",  function() { return font; }, function(_v) { font = _v; } ); // HtmlView Page linking property 'Font' for element 'playPauseButton'
          _view.resetButton.setAction("OnClick", function(_data,_info) {
  _reset();
  btnCSS={"animation": "blink 0s step-start infinite"};

}); // HtmlView Page setting action 'OnClick' for element 'resetButton'
          _view.resetButton.linkProperty("Font",  function() { return font; }, function(_v) { font = _v; } ); // HtmlView Page linking property 'Font' for element 'resetButton'
          _view.inputPanel.linkProperty("Visibility",  function() { return (pending && !animate) ?true : false; } ); // HtmlView Page linking property 'Visibility' for element 'inputPanel'
          _view.inputPanel.linkProperty("Font",  function() { return font; }, function(_v) { font = _v; } ); // HtmlView Page linking property 'Font' for element 'inputPanel'
          _view.questionText.linkProperty("Text",  function() { return "" + questions[pendingIdx] + " (Click on Yes / No): "; } ); // HtmlView Page linking property 'Text' for element 'questionText'
          _view.questionText.linkProperty("Font",  function() { return font; }, function(_v) { font = _v; } ); // HtmlView Page linking property 'Font' for element 'questionText'
          _view.buttonYes.linkProperty("CSS",  function() { return btnCSS; }, function(_v) { btnCSS = _v; } ); // HtmlView Page linking property 'CSS' for element 'buttonYes'
          _view.buttonYes.setAction("OnClick", function(_data,_info) {
  checkAnswer("yes");

}); // HtmlView Page setting action 'OnClick' for element 'buttonYes'
          _view.buttonNo.linkProperty("CSS",  function() { return btnCSS; }, function(_v) { btnCSS = _v; } ); // HtmlView Page linking property 'CSS' for element 'buttonNo'
          _view.buttonNo.setAction("OnClick", function(_data,_info) {
  checkAnswer("no");

}); // HtmlView Page setting action 'OnClick' for element 'buttonNo'
          _view.plottingPanel.linkProperty("MaximumY",  function() { return boxHeight / 2 + 3; } ); // HtmlView Page linking property 'MaximumY' for element 'plottingPanel'
          _view.plottingPanel.linkProperty("TRMessage",  function() { return title+" Flowchart."+"\nscore="+completionCount+"/"+numOfAnimals; } ); // HtmlView Page linking property 'TRMessage' for element 'plottingPanel'
          _view.plottingPanel.linkProperty("MinimumY",  function() { return minY - 1; } ); // HtmlView Page linking property 'MinimumY' for element 'plottingPanel'
          _view.plottingPanel.linkProperty("TLMessage",  function() { return "Click on the "+title+" to start the FlowChart"; } ); // HtmlView Page linking property 'TLMessage' for element 'plottingPanel'
          _view.plottingPanel.linkProperty("BRMessage",  function() { return (typeof _model.isRegisterStarted == 'undefined')?"":first?"Moodle click me to continue="+start:""; } ); // HtmlView Page linking property 'BRMessage' for element 'plottingPanel'
          _view.noArrows.linkProperty("NumberOfElements",  function() { return numOfQuestions; }, function(_v) { numOfQuestions = _v; } ); // HtmlView Page linking property 'NumberOfElements' for element 'noArrows'
          _view.noArrows.linkProperty("Y",  function() { return noArrowYPos; }, function(_v) { noArrowYPos = _v; } ); // HtmlView Page linking property 'Y' for element 'noArrows'
          _view.noArrows.linkProperty("SizeY",  function() { return -(boxGap - boxHeight); } ); // HtmlView Page linking property 'SizeY' for element 'noArrows'
          _view.noText.linkProperty("NumberOfElements",  function() { return numOfQuestions; }, function(_v) { numOfQuestions = _v; } ); // HtmlView Page linking property 'NumberOfElements' for element 'noText'
          _view.noText.linkProperty("X",  function() { return noXPos; }, function(_v) { noXPos = _v; } ); // HtmlView Page linking property 'X' for element 'noText'
          _view.noText.linkProperty("Y",  function() { return noYPos; }, function(_v) { noYPos = _v; } ); // HtmlView Page linking property 'Y' for element 'noText'
          _view.noText.setAction("OnPress", function(_data,_info) {
  checkAnswer("no");

}); // HtmlView Page setting action 'OnPress' for element 'noText'
          _view.noText.linkProperty("Font",  function() { return font; }, function(_v) { font = _v; } ); // HtmlView Page linking property 'Font' for element 'noText'
          _view.yesArrows.linkProperty("NumberOfElements",  function() { return numOfQuestions; }, function(_v) { numOfQuestions = _v; } ); // HtmlView Page linking property 'NumberOfElements' for element 'yesArrows'
          _view.yesArrows.linkProperty("SizeX",  function() { return yesArrowLength; }, function(_v) { yesArrowLength = _v; } ); // HtmlView Page linking property 'SizeX' for element 'yesArrows'
          _view.yesArrows.linkProperty("X",  function() { return (boxWidth / 2); } ); // HtmlView Page linking property 'X' for element 'yesArrows'
          _view.yesArrows.linkProperty("Y",  function() { return yPos; }, function(_v) { yPos = _v; } ); // HtmlView Page linking property 'Y' for element 'yesArrows'
          _view.yesText.linkProperty("NumberOfElements",  function() { return numOfQuestions; }, function(_v) { numOfQuestions = _v; } ); // HtmlView Page linking property 'NumberOfElements' for element 'yesText'
          _view.yesText.linkProperty("X",  function() { return yesXPos; }, function(_v) { yesXPos = _v; } ); // HtmlView Page linking property 'X' for element 'yesText'
          _view.yesText.linkProperty("Y",  function() { return yesYPos; }, function(_v) { yesYPos = _v; } ); // HtmlView Page linking property 'Y' for element 'yesText'
          _view.yesText.setAction("OnPress", function(_data,_info) {
  checkAnswer("yes");

}); // HtmlView Page setting action 'OnPress' for element 'yesText'
          _view.yesText.linkProperty("Font",  function() { return font; }, function(_v) { font = _v; } ); // HtmlView Page linking property 'Font' for element 'yesText'
          _view.questionBox2.linkProperty("NumberOfElements",  function() { return numOfQuestions; }, function(_v) { numOfQuestions = _v; } ); // HtmlView Page linking property 'NumberOfElements' for element 'questionBox2'
          _view.questionBox2.linkProperty("SizeX",  function() { return boxHeight / Math.sqrt(2); } ); // HtmlView Page linking property 'SizeX' for element 'questionBox2'
          _view.questionBox2.linkProperty("Rotate",  function() { return pi/4; } ); // HtmlView Page linking property 'Rotate' for element 'questionBox2'
          _view.questionBox2.linkProperty("X",  function() { return xPos; }, function(_v) { xPos = _v; } ); // HtmlView Page linking property 'X' for element 'questionBox2'
          _view.questionBox2.linkProperty("Y",  function() { return yPos; }, function(_v) { yPos = _v; } ); // HtmlView Page linking property 'Y' for element 'questionBox2'
          _view.questionBox2.linkProperty("SizeY",  function() { return boxHeight / Math.sqrt(2); } ); // HtmlView Page linking property 'SizeY' for element 'questionBox2'
          _view.questionSet.linkProperty("NumberOfElements",  function() { return numOfQuestions; }, function(_v) { numOfQuestions = _v; } ); // HtmlView Page linking property 'NumberOfElements' for element 'questionSet'
          _view.questionSet.setAction("OnEnter", function(_data,_info) {
  if (readQuestion==true){
  speech(questions[elementinteractedq])
  }
  else{
    //do ntg
    }

}); // HtmlView Page setting action 'OnEnter' for element 'questionSet'
          _view.questionSet.linkProperty("Y",  function() { return yPos; }, function(_v) { yPos = _v; } ); // HtmlView Page linking property 'Y' for element 'questionSet'
          _view.questionSet.linkProperty("Text",  function() { return questions; }, function(_v) { questions = _v; } ); // HtmlView Page linking property 'Text' for element 'questionSet'
          _view.questionSet.linkProperty("Font",  function() { return fontquestion; }, function(_v) { fontquestion = _v; } ); // HtmlView Page linking property 'Font' for element 'questionSet'
          _view.questionSet.linkProperty("ElementInteracted",  function() { return elementinteractedq; }, function(_v) { elementinteractedq = _v; } ); // HtmlView Page linking property 'ElementInteracted' for element 'questionSet'
          _view.finalPos.linkProperty("NumberOfElements",  function() { return numOfQuestions + 1; } ); // HtmlView Page linking property 'NumberOfElements' for element 'finalPos'
          _view.finalPos.linkProperty("X",  function() { return finalXPos; }, function(_v) { finalXPos = _v; } ); // HtmlView Page linking property 'X' for element 'finalPos'
          _view.finalPos.linkProperty("Y",  function() { return finalYPos; }, function(_v) { finalYPos = _v; } ); // HtmlView Page linking property 'Y' for element 'finalPos'
          _view.PendingPos.linkProperty("NumberOfElements",  function() { return numOfAnimals; }, function(_v) { numOfAnimals = _v; } ); // HtmlView Page linking property 'NumberOfElements' for element 'PendingPos'
          _view.PendingPos.linkProperty("X",  function() { return pendingXPos; }, function(_v) { pendingXPos = _v; } ); // HtmlView Page linking property 'X' for element 'PendingPos'
          _view.PendingPos.linkProperty("Y",  function() { return pendingYPos; }, function(_v) { pendingYPos = _v; } ); // HtmlView Page linking property 'Y' for element 'PendingPos'
          _view.animalSet.linkProperty("NumberOfElements",  function() { return numOfAnimals; }, function(_v) { numOfAnimals = _v; } ); // HtmlView Page linking property 'NumberOfElements' for element 'animalSet'
          _view.animalSet.setAction("OnRelease", function(_data,_info) {
  if(animate)
    return;
  if(pending || animalCompleted[interact]){
    // snap to position if animal is completed, or is in intermediate step
    animalXPos[interact] = animalXOrig[interact];
    animalYPos[interact] = animalYOrig[interact];
    return;
  }
    
  var threshold = 3;
  var diffX = Math.pow(animalXOrig[interact] - animalXPos[interact], 2);
  var diffY = Math.pow(animalYOrig[interact] - animalYPos[interact], 2);
  var sqdist = diffX + diffY;
  //console.log(dist)
  // the difference is small, indicates click event
  if(sqdist <= threshold * threshold) {
    pending = 1;
    // initialise the pendingIdx and pendingAnimal
    pendingIdx = 0;
    pendingAnimal = interact;
    // starting the animation, and setting the destination
    destX = pendingXPos;
    destY = pendingYPos[pendingIdx];
    animate = true;
    
    const questionName = "Q" + (interact + 1) //moodle
    startQuestion(questionName); //moodle
    addQuestionHistory(questions[0]); //moodle question[0] = Does it have a fixed shape?
    
  } else { 
    // if not, check if animal is close to any of the final positions
    var setX = animalXOrig[interact];
    var setY = animalYOrig[interact];
    
    for(var i = 0; i < numOfQuestions + 1; i++){ 
      diffX = Math.pow(finalXPos[i] - animalXPos[interact], 2);
      diffY = Math.pow(finalYPos[i] - animalYPos[interact], 2);
      sqdist = Math.sqrt(diffX + diffY);  
      // console.log(dist);
      // if the distance is small enough, check answer
      if(sqdist <= threshold * threshold) {
        actualAns = answers[interact];
        // if the position is actually correct
        if(actualAns == i){
          startQuestion("Q" + (interact + 1)); //moodle
          onAnswer(animals[i], true);
          awardQuestionMarks(); //moodle
          endQuestion();  //moodle
          
          setX = finalXPos[i];
          setY = finalYPos[i];
          // shift the final position to prepare for new animal
          finalXPos[i] += animalGap;
          
          animalCompleted[interact] = 1;
          completionCount++;
          
          if(completionCount == numOfAnimals){
            _tools.showOkDialog(completionText); 
          }
          break;
        }
        else{
          //_addQuestionHistory("Q" + (interact + 1), animals[i] + " (incorrect)"); //moodle
          _addQuestionHistory("Q" + (interact + 1), animals[i] + " ❌"); //moodle
          _tools.showOkDialog("Wrong answer...try again!");  
        }
      }
    }
    console.log(setX, setY);
    animalXPos[interact] = setX;
    animalYPos[interact] = setY;
  }

}); // HtmlView Page setting action 'OnRelease' for element 'animalSet'
          _view.animalSet.linkProperty("X",  function() { return animalXPos; }, function(_v) { animalXPos = _v; } ); // HtmlView Page linking property 'X' for element 'animalSet'
          _view.animalSet.linkProperty("Y",  function() { return animalYPos; }, function(_v) { animalYPos = _v; } ); // HtmlView Page linking property 'Y' for element 'animalSet'
          _view.animalSet.linkProperty("Text",  function() { return animals; }, function(_v) { animals = _v; } ); // HtmlView Page linking property 'Text' for element 'animalSet'
          _view.animalSet.setAction("OnPress", function(_data,_info) {
  if(animate)
    return;
  animalXOrig[interact]=animalXPos[interact] // store value to put back if need
  animalYOrig[interact]=animalYPos[interact] 
   // disableBlinking("animalSet["+interact+"]");
    disableBlinking("animalSet[0]");
      disableBlinking("animalSet[1]");
        disableBlinking("animalSet[2]");

}); // HtmlView Page setting action 'OnPress' for element 'animalSet'
          _view.animalSet.linkProperty("Font",  function() { return font; }, function(_v) { font = _v; } ); // HtmlView Page linking property 'Font' for element 'animalSet'
          _view.animalSet.linkProperty("EnabledPosition",  function() { return pending || animate ? "ENABLED_NO_MOVE" : "ENABLED_ANY"; } ); // HtmlView Page linking property 'EnabledPosition' for element 'animalSet'
          _view.animalSet.linkProperty("ElementInteracted",  function() { return interact; }, function(_v) { interact = _v; } ); // HtmlView Page linking property 'ElementInteracted' for element 'animalSet'
          _view.instructionDetails.linkProperty("Text",  function() { return "<p> To get started, try clicking on the "+title+"! After which, "+title+" the series of questions to bring the "+title+" to the right place in the flowchart. The yes/no answers can be inputted either through clicking the buttons on top, or clicking the 'Yes'/'No' text in the flowchart. </p> <p> However, if you already know the answer, you can drag and drop the "+title+" immediately from its original position, to its final position in the flowchart!  </p> <p> Have fun completing the flowchart! </p>"; } ); // HtmlView Page linking property 'Text' for element 'instructionDetails'
          break;
      } // end of switch
    }; // end of new reset

    _model.setView(_view);
    _model.reset();
    _view._enableEPub();
  } // end of _selectView

  _model.setAutoplay(true);
  _model.setFPS(20);
  _model.setStepsPerDisplay(1);
  _selectView(_model._autoSelectView(_getViews())); // this includes _model.reset()
  return _model;
}
function MatterFlowChart_View (_topFrame,_viewNumber,_libraryPath,_codebasePath) {
  var _view;
  switch(_viewNumber) {
    case -10 : break; // make Lint happy
    default :
    case 0: _view = MatterFlowChart_View_0 (_topFrame); break;
  } // end of switch

  if (_codebasePath) _view._setResourcePath(_codebasePath);

  if (_libraryPath) _view._setLibraryPath(_libraryPath);

  _view._addDescriptionPage('Desc Page','./MatterFlowChart_Intro_1.html');

  return _view;
} // end of main function

function MatterFlowChart_View_0 (_topFrame) {
  var _view = EJSS_CORE.createView(_topFrame);

  _view._reset = function() {
    _view._clearAll();
    _view._addElement(EJSS_INTERFACE.panel,"topPanel", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'topPanel'
      .setProperty("Width","100%") // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'topPanel'
      .setProperty("Display","inline-flex") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'topPanel'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"titleText", _view.topPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'titleText'
      ;

    _view._addElement(EJSS_INTERFACE.checkBox,"readQuestion", _view.topPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'readQuestion'
      .setProperty("Text","Read Question") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'readQuestion'
      ;

    _view._addElement(EJSS_INTERFACE.checkBox,"checkBoxauto", _view.topPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'checkBoxauto'
      .setProperty("Text","Automove") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'checkBoxauto'
      .setProperty("Display","none") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'checkBoxauto'
      ;

    _view._addElement(EJSS_INTERFACE.twoStateButton,"playPauseButton", _view.topPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'playPauseButton'
      .setProperty("Width","20vw") // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'playPauseButton'
      .setProperty("TextOn","▶ Play") // EJsS HtmlView.HtmlView Page: setting property 'TextOn' for element 'playPauseButton'
      .setProperty("Tooltip","Play/Pause") // EJsS HtmlView.HtmlView Page: setting property 'Tooltip' for element 'playPauseButton'
      .setProperty("TextOff","❚❚ Pause") // EJsS HtmlView.HtmlView Page: setting property 'TextOff' for element 'playPauseButton'
      ;

    _view._addElement(EJSS_INTERFACE.button,"resetButton", _view.topPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'resetButton'
      .setProperty("Width","20vw") // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'resetButton'
      .setProperty("Text","↻ Reset") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'resetButton'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"inputPanel", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'inputPanel'
      .setProperty("Background","Blue") // EJsS HtmlView.HtmlView Page: setting property 'Background' for element 'inputPanel'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"questionText", _view.inputPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'questionText'
      .setProperty("Foreground","White") // EJsS HtmlView.HtmlView Page: setting property 'Foreground' for element 'questionText'
      ;

    _view._addElement(EJSS_INTERFACE.button,"buttonYes", _view.inputPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'buttonYes'
      .setProperty("Width","20vw") // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'buttonYes'
      .setProperty("Foreground","Green") // EJsS HtmlView.HtmlView Page: setting property 'Foreground' for element 'buttonYes'
      .setProperty("Text","Yes") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'buttonYes'
      ;

    _view._addElement(EJSS_INTERFACE.button,"buttonNo", _view.inputPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'buttonNo'
      .setProperty("Width","20vw") // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'buttonNo'
      .setProperty("Foreground","Red") // EJsS HtmlView.HtmlView Page: setting property 'Foreground' for element 'buttonNo'
      .setProperty("Text","No") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'buttonNo'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"mainPanel", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'mainPanel'
      ;

    _view._addElement(EJSS_DRAWING2D.plottingPanel,"plottingPanel", _view.mainPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'plottingPanel'
      .setProperty("Height","80vh") // EJsS HtmlView.HtmlView Page: setting property 'Height' for element 'plottingPanel'
      .setProperty("Width","100%") // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'plottingPanel'
      .setProperty("Gutters",[0,0,0,0]) // EJsS HtmlView.HtmlView Page: setting property 'Gutters' for element 'plottingPanel'
      .setProperty("YScalePrecision",0) // EJsS HtmlView.HtmlView Page: setting property 'YScalePrecision' for element 'plottingPanel'
      .setProperty("XFixedTick",0) // EJsS HtmlView.HtmlView Page: setting property 'XFixedTick' for element 'plottingPanel'
      .setProperty("Enabled",true) // EJsS HtmlView.HtmlView Page: setting property 'Enabled' for element 'plottingPanel'
      .setProperty("SquareAspect",true) // EJsS HtmlView.HtmlView Page: setting property 'SquareAspect' for element 'plottingPanel'
      .setProperty("YFixedTick",0) // EJsS HtmlView.HtmlView Page: setting property 'YFixedTick' for element 'plottingPanel'
      .setProperty("YAutoTicks",false) // EJsS HtmlView.HtmlView Page: setting property 'YAutoTicks' for element 'plottingPanel'
      .setProperty("XTickStep",30) // EJsS HtmlView.HtmlView Page: setting property 'XTickStep' for element 'plottingPanel'
      .setProperty("YTickStep",10) // EJsS HtmlView.HtmlView Page: setting property 'YTickStep' for element 'plottingPanel'
      .setProperty("AutoScaleY",false) // EJsS HtmlView.HtmlView Page: setting property 'AutoScaleY' for element 'plottingPanel'
      .setProperty("AutoScaleX",false) // EJsS HtmlView.HtmlView Page: setting property 'AutoScaleX' for element 'plottingPanel'
      .setProperty("XAutoTicks",false) // EJsS HtmlView.HtmlView Page: setting property 'XAutoTicks' for element 'plottingPanel'
      .setProperty("XScalePrecision",0) // EJsS HtmlView.HtmlView Page: setting property 'XScalePrecision' for element 'plottingPanel'
      ;

    _view._addElement(EJSS_DRAWING2D.arrowSet,"noArrows", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'noArrows'
      .setProperty("SizeX",0) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'noArrows'
      .setProperty("X",0) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'noArrows'
      .setProperty("LineColor","Red") // EJsS HtmlView.HtmlView Page: setting property 'LineColor' for element 'noArrows'
      .setProperty("LineWidth",2) // EJsS HtmlView.HtmlView Page: setting property 'LineWidth' for element 'noArrows'
      .setProperty("Offset","SOUTH_WEST") // EJsS HtmlView.HtmlView Page: setting property 'Offset' for element 'noArrows'
      ;

    _view._addElement(EJSS_DRAWING2D.textSet,"noText", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'noText'
      .setProperty("FillColor","Red") // EJsS HtmlView.HtmlView Page: setting property 'FillColor' for element 'noText'
      .setProperty("Sensitivity",50) // EJsS HtmlView.HtmlView Page: setting property 'Sensitivity' for element 'noText'
      .setProperty("RelativePosition","EAST") // EJsS HtmlView.HtmlView Page: setting property 'RelativePosition' for element 'noText'
      .setProperty("Text","No") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'noText'
      .setProperty("EnabledPosition","ENABLED_NO_MOVE") // EJsS HtmlView.HtmlView Page: setting property 'EnabledPosition' for element 'noText'
      ;

    _view._addElement(EJSS_DRAWING2D.arrowSet,"yesArrows", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'yesArrows'
      .setProperty("LineColor","Green") // EJsS HtmlView.HtmlView Page: setting property 'LineColor' for element 'yesArrows'
      .setProperty("SizeY",0) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'yesArrows'
      .setProperty("LineWidth",2) // EJsS HtmlView.HtmlView Page: setting property 'LineWidth' for element 'yesArrows'
      .setProperty("Offset","SOUTH_WEST") // EJsS HtmlView.HtmlView Page: setting property 'Offset' for element 'yesArrows'
      ;

    _view._addElement(EJSS_DRAWING2D.textSet,"yesText", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'yesText'
      .setProperty("FillColor","Green") // EJsS HtmlView.HtmlView Page: setting property 'FillColor' for element 'yesText'
      .setProperty("Sensitivity",50) // EJsS HtmlView.HtmlView Page: setting property 'Sensitivity' for element 'yesText'
      .setProperty("RelativePosition","CENTERED") // EJsS HtmlView.HtmlView Page: setting property 'RelativePosition' for element 'yesText'
      .setProperty("Text","Yes") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'yesText'
      .setProperty("EnabledPosition","ENABLED_NO_MOVE") // EJsS HtmlView.HtmlView Page: setting property 'EnabledPosition' for element 'yesText'
      ;

    _view._addElement(EJSS_DRAWING2D.shapeSet,"questionBox2", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'questionBox2'
      .setProperty("FillColor","rgba(255,255,255,1)") // EJsS HtmlView.HtmlView Page: setting property 'FillColor' for element 'questionBox2'
      .setProperty("ShapeType","RECTANGLE") // EJsS HtmlView.HtmlView Page: setting property 'ShapeType' for element 'questionBox2'
      .setProperty("LineColor","black") // EJsS HtmlView.HtmlView Page: setting property 'LineColor' for element 'questionBox2'
      .setProperty("LineWidth",2) // EJsS HtmlView.HtmlView Page: setting property 'LineWidth' for element 'questionBox2'
      ;

    _view._addElement(EJSS_DRAWING2D.textSet,"questionSet", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'questionSet'
      .setProperty("FillColor","Blue") // EJsS HtmlView.HtmlView Page: setting property 'FillColor' for element 'questionSet'
      .setProperty("RelativePosition","CENTERED") // EJsS HtmlView.HtmlView Page: setting property 'RelativePosition' for element 'questionSet'
      .setProperty("X",0) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'questionSet'
      .setProperty("EnabledPosition","ENABLED_NO_MOVE") // EJsS HtmlView.HtmlView Page: setting property 'EnabledPosition' for element 'questionSet'
      ;

    _view._addElement(EJSS_DRAWING2D.shapeSet,"finalPos", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'finalPos'
      .setProperty("FillColor","Orange") // EJsS HtmlView.HtmlView Page: setting property 'FillColor' for element 'finalPos'
      .setProperty("SizeX",10) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'finalPos'
      .setProperty("ShapeType","ELLIPSE") // EJsS HtmlView.HtmlView Page: setting property 'ShapeType' for element 'finalPos'
      .setProperty("SizeY",10) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'finalPos'
      .setProperty("PixelSize",true) // EJsS HtmlView.HtmlView Page: setting property 'PixelSize' for element 'finalPos'
      .setProperty("DrawLines",false) // EJsS HtmlView.HtmlView Page: setting property 'DrawLines' for element 'finalPos'
      ;

    _view._addElement(EJSS_DRAWING2D.shapeSet,"PendingPos", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'PendingPos'
      .setProperty("SizeX",5) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'PendingPos'
      .setProperty("ShapeType","ELLIPSE") // EJsS HtmlView.HtmlView Page: setting property 'ShapeType' for element 'PendingPos'
      .setProperty("Visibility",false) // EJsS HtmlView.HtmlView Page: setting property 'Visibility' for element 'PendingPos'
      .setProperty("SizeY",5) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'PendingPos'
      .setProperty("PixelSize",true) // EJsS HtmlView.HtmlView Page: setting property 'PixelSize' for element 'PendingPos'
      .setProperty("DrawFill",false) // EJsS HtmlView.HtmlView Page: setting property 'DrawFill' for element 'PendingPos'
      ;

    _view._addElement(EJSS_DRAWING2D.textSet,"animalSet", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'animalSet'
      .setProperty("Sensitivity",50) // EJsS HtmlView.HtmlView Page: setting property 'Sensitivity' for element 'animalSet'
      .setProperty("RelativePosition","CENTERED") // EJsS HtmlView.HtmlView Page: setting property 'RelativePosition' for element 'animalSet'
      .setProperty("FontWeight","bold") // EJsS HtmlView.HtmlView Page: setting property 'FontWeight' for element 'animalSet'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"bottomPanel", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'bottomPanel'
      .setProperty("Display","bottompanel") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'bottomPanel'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"instructionTitle", _view.bottomPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'instructionTitle'
      .setProperty("TextAlign","left") // EJsS HtmlView.HtmlView Page: setting property 'TextAlign' for element 'instructionTitle'
      .setProperty("Text","<h1>Instructions</h1>") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'instructionTitle'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"instructionDetails", _view.bottomPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'instructionDetails'
      .setProperty("Width","100%") // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'instructionDetails'
      .setProperty("TextAlign","center") // EJsS HtmlView.HtmlView Page: setting property 'TextAlign' for element 'instructionDetails'
      ;

  };

  return _view;
}



      var _model;
      var _scorm;
      window.addEventListener('load',
        function () { 
          _model =  new MatterFlowChart("_topFrame","_ejs_library/",null);
          if (typeof _isApp !== "undefined" && _isApp) _model.setRunAlways(true);
          TextResizeDetector.TARGET_ELEMENT_ID = '_topFrame';
          TextResizeDetector.USER_INIT_FUNC = function () {
            var iBase = TextResizeDetector.addEventListener(function(e,args) {
              _model._fontResized(args[0].iBase,args[0].iSize,args[0].iDelta);
              },null);
            _model._fontResized(iBase);
          };
          _model.onload();
        }, false);
