var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./Geiger_reader/1280.png"]="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAUAAAAC0CAYAAADl5PURAAAABGdBTUEAALGPC/xhBQAAACBjSFJNAAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAAACXBIWXMAAAsTAAALEwEAmpwYAAABWWlUWHRYTUw6Y29tLmFkb2JlLnhtcAAAAAAAPHg6eG1wbWV0YSB4bWxuczp4PSJhZG9iZTpuczptZXRhLyIgeDp4bXB0az0iWE1QIENvcmUgNS40LjAiPgogICA8cmRmOlJERiB4bWxuczpyZGY9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkvMDIvMjItcmRmLXN5bnRheC1ucyMiPgogICAgICA8cmRmOkRlc2NyaXB0aW9uIHJkZjphYm91dD0iIgogICAgICAgICAgICB4bWxuczp0aWZmPSJodHRwOi8vbnMuYWRvYmUuY29tL3RpZmYvMS4wLyI+CiAgICAgICAgIDx0aWZmOk9yaWVudGF0aW9uPjE8L3RpZmY6T3JpZW50YXRpb24+CiAgICAgIDwvcmRmOkRlc2NyaXB0aW9uPgogICA8L3JkZjpSREY+CjwveDp4bXBtZXRhPgpMwidZAABAAElEQVR4Aey9CXAlWXaed94DCigUUKh939fel+me7pnpnh5Ss3IWDmWTImk6TMty0A6HFQyJYoTDEXYoKNEWHUGTFs0wQ2EtoZAt0yLH4nAfUsOZ6WHP3t3T+95dXfteqAWFQgF4z/93Ms/DfYl8Dw8oVK95qx4y8957zj335D1/nrvkzVpTwarwvtHAO/V2I1e9Xvf7kMlYm+eeLLzZ1mpzeVJWWfw8hVfJ72INXL9+3c6fP28DAwPW/y6uRyX6AjVw4cIFazQabvAYfZy3seF5WAIUbXmW+AJZ+E1NTdnaNautr39ZDyXMBbMeiOZkqcBvjkre8xFqbfbaq6/Zho0bKgB8z9/tvILXJidtZmbGRletsqZAcGamYYODAzY9PaVzvKAsY39/v+fDGyM/4WaCBOVMSraGgHflyAo7euaKHRkfMWtMZwIV/iLmVMNsx+iMbVllpmq0ZC9kNQPL6zXjiX/t2jX3MNs8YDFrNprSw6CtXbt2DnkV8d7VQP+yfm8PlQf43r3H7TUTwCwbGLTJ8Yv2pS/9ga1YucpG16yzH3nkYVu+fMDzNpsNO3PmrK0aXWnf/s537cGHHrahZXW7Nnm9ndcSXeGBLl++3H7v937PTpw8Zb/8D37RTh+5bhOXztjetdft+jQIJXAWiAnK9KObXLPx69N29sSELZsaFoBnHi0iIb9yWz1Hc8Cur6/PLoxdsJHhES8rvN4m6AiNAHB6eroCQNfG++dPPAgrAHz/3HP35K5NjFt9YKX9+Bc+b//qX/1L++AH77Nnnvy+HT97yR758AP2r//Zb9sjP/YTdvzw6/bH58dsx/bt9oF777Im3mC4iUugMxrgsmXL7OTJk/aVr3zFTpw6Zz/1H33BhpZvk/enrvDKmk2rgzLQ32eT8uAALrxFAHBQoDx+tWkrVqyQBwjkqTsv8GNMB754fAAm4gKAeL8D8nYHlw+6Dqanph1U8Wzxcm+mh7sEqqpY3EQNZKPON7GAivU7SAMCh/7+ATt57A370z/5Extetd5ef/kFO3lhwm7bu8O+8c3H7LZ77rfNmzfajEDi7rvutFeff8pOn78kun4Hl6WqDaADqAFav/Ebv2G/+2//ja1etdoAp0azZv2K//63HrO//u7jVutbZsuHVtCfdQ9PmOfp504es//u7/2i/W+/88/syvi4/dEf/KEdOX7KhoaGvHtPGRm4yRPUuOLVy2P227/9O3ZVHmSfgBRgBCCr8P7VQAWA76N7DxhMT123Ldv32k/+rb9lG0cH7E//8mu2a/ce2759mwBpSt3kARvSmNjAihHbs3evbd28QR5V5jEtparw1PDo8NZ+6Zd+yX725/4zu3hxTEDV5x7dwLIBO33ssH3hs5+2X/21X7enn33Bxyr7+xi76bN+geKMxi//9e/+O/v/vvGYA9mXfufX7QN332H/5t/SpT7j+frIL+AckLd58cKY3Xn3vTY6Muz5X3nxJZua1kOhAsGlvLXvKl4VAL6rbteNCctEw6A8qetXL9jv//7v2/h0n/03v/B37LXnHrf/5/e+bPc98BHbsHaVvfDiy7Zpyxa7PnnNhkdX2+CAvD/criUMgDGzvps3b7bPfOYz9plPf8J2CXAnJ6cESFlXd2h42Ev8rf/11zRW+ZB99dFvuyeH9yZMMwayCQe2bnIw3XnbPX79i//tf2WP/NQv2NETp+VhakZZZUEzfvWqPfzwRwTw/Ta0Yljjm8scgOsCwKWtnYtR/XkXaKAaA3wX3KSlEnHq+qSNCtD+05//eQ38z/jsJ0D0+R//CZvOZ4W3b9nokwJ9dHnVRb33/gd9ImL6JoyVhQf4xS9+Ud5n06bUJcUzrPVpIkOgdO3quFf9H/+TX7cvfuGztnP7Vkb7BH4CSKUgH+HPXnrdu7pvPv19s8132P/9T/+RPfLQh2105bB3s/sEqADc1m1b7fEf/MA+9KEH7MKZwzZ2bdJu17KbqevXxLcK70cNVAD4PrnrzLZOTEzY5cuX3Fui2nQ/HXAEggDhtWsTfuS8qWUjb1WgPCYtJq5e11KYUcl51QFxz61327e+94Tdc+dtSmdyY8q9uRpjgc0ZG1m11n7rN3/DVm3c7GOU//U/+g377fvusy0b18u7vO4gD8gyzsdM78Yt2+02Af2Lzz8n73HQHnzgAXmGZtNe/ltV26qcd5IGajIAQg8y9ZKnBzZlWW4i67Li3o9xDjIAW762z3XQMnzdAO4B12+RK5Q1uSis6YDXr/G/V041fKnOHdv6NQvMWJ/GCfEMXTy6snW7fHXSxi5d1fjkeslbl8gZODJ+2ZiZFvhpzDKvGzxPnz5tw1oGM7RiSPQaY1QaP9ZA4nmyDnHturJ1gBkwZ8p5P7aapagzOuTu8Xv7Aw/PKT1IH3/icVu/fn22EDoaS3fxorF2z7Wo1JvIelHyvIeJau+QAf8cn3JNq8ubj0aPrKjba6cHrXnSbHK6rq55zZb1D8njkwnpx1jelWv9tmZAXp0cwusaR8wATddXWTzN+OAyz4vNzcxoAkTLfjTV4efXr2s5D7aoNgddo0F3e7nOcwFK733VQEvV0nMk+nvn6DDWgCK+d4FPn7mgbseUGmHNro5fUPvo01KCET15r2pWcIWequO2atW4V+HqhNmIFuqr3XmjLS4Pi4ZNe6JJaajJA42XvBp3Fr9sBb/W5dqUhnnqF2iMWb7q79ukAe6P7kdzdXbfkIIhNvAywIl7xD2Ma+4pcQFOcsDkVWXX0JMvH6bzc9LgB83EBOC2Qdd0Zxs+O71sYLmv+VulZTCXxvo0c3ve1oxcV7e9pnV8aqyi5c2P1Spn5ZC6zJNqyoBZUpaGLh0YI35GPfl6v3zE5rRmmVl7iPc3K+PgoMYep/r0bigeYSZfyDwzs07yAaYalxRR2lMKpyHi0vQ4jzzIV8yXphXT4zrypLSkRSA+yiIuzZ+ep2lBG8ci7/Q6PSd/lBfnwaOsrJR2Rl55vX5WDyIzjcDIE8/aAPNquhXepjjh/nLfot3FfYh2xH3TvJyWQAlHdJ8DeyJ/SstDDv7QRpvF21+16qDu6eySLrFp2JFjEzYxtVGnE/bCc8ft0OE3befuPTZ27oSNrNxh23acsU999G/a177GE9dszQazH/2Y2aWLaowyGAogIKCGXlzA08dU2Umz/Xuz+LFzZk88aVqnZXb/B8xOHDE7pbyfUfqqB0QjeslbhbdJA2ondv4f6J79otm3v2q2XK+ZbdF9vu0usxXL84ap+zykiVkaIfcaMAM0aGRaOWN/+eeaaNhvdod+eGcMIw6KlhvLyyTr1pmNXzETzmkB9D47fOoJxQ1r8mPCXtVExo49t2h87kVbOTpsu3bdb9t3/YpNXvk/7NXXGK80+xufEvDJeGjYAJ1W57gBIYvmM4wXWp7+oWaFb1e5etAyvvfcM2Y/fNpsrZq35nfs24+ZffJzopUc23eZfetRs/s+ZHbxtM6/Z/bhD0vGy2Y794hH3yHJskUGqcK9JNr6jOqtihcCIMA4I0fSAwAiG9fQsp6yLJDGeGWASZpnPlrKpcwyWtZaQt9pHSe0ZTLBC5kWSwtfwoBu9tjYCbWPu+2Hjwsz5PCIrf3oxwViuj+89n3iqNqY2tsw7Uw0tCXmv5av0L1WXo1QuNP1za8pUfkvCkvu/qDu3+asXWnZp13RPdOwrlYsmOnFH3tebeZD96tdXBVvtVnEGRsT34njtmrlFjGipAx3JCStpV8IvFJrwvbZLbffaxPjl2z4tjv1GtF127t71F5+0WzT7rvsgbsv2/mzprcHzA4fa+pNgZrGVzIgfOWFpp09L2HXqEA1sEnd6+HhmmnyzdZvMtNLBxrXadp999fs+f6mbdBsn9q//E09mWVopqdDFd4GDcijt+cEZGqA+3bW7PI9estiXc1Wq1k891RT3pHMX40Vl/6WgzU7+qbG3NR+btf5oBrpZt3bcwKQ559v2p47hEYKr75s9rhoH/5ozU4cbtqJM2b33FOzQ68ssxWrX9Fs9D16PW1Qb3702bK+YTtw6+3y1JbZgYMHZRRDtny4Xz2QdfaU+Hz+x++06YkrduoUAKZ3hjEWNfptantj4nvibNPOqU3u2mkCUBmB3iLRWm5bv05lqs2dOdW022UMWwXoJ080/S2TV043bbXynT2n8cepmp06qXJ+rGavvlqTl1C3YyfetDsOLhc4UB9ZVh46ASDJAUJlQER6N9puafPRUi6/sgCA8QNcy0I32gDNxdCGPPQqV44ut5OHD9rEzIR97nMD9uwzM3ZRbepZtY9+tblNG2t2Qc7UKd0brcyyPTtq9szTTdt/QPfneNNGN9cczK7q7Z+NSrt2Wff7jNrSy027pIfs3XfW7KXnhCFqi9u3ZLR9On/2mZq9rDx33lW3l5+t2d7bj9q+3fQ4MvBDH/444pqnKt2LzVt3uAu6Wq4druXISrKd0eC5MHNaMGtH7ezJpj33WtP+4y/U7ff/rxnbe2tNa6oEak827EOf0piKHpivCaVvUQV2qpHOyBvAeJ58vOHgx9P0+ecb9sX/RO+ZymiG5IU6+Mk7rMJbr4GmAAwzVy9RQWNp1+U1aOztshraq6807cMP121MILJZ9/Ivfr9ha/cI+NRymnqAbd4kSt2+b3xNDUT/X325Zvt36GazrEZ5nn+iaUcELrerjfzZv2/a3/jMajuwT17Zs2okevDRxniZbcXwqBqmPMxN27VwWU90PbmRqqa4ZlP8mn32re807aEflQGcadqffrVpP/OzNTt+VJ6ryv3wQzV79kk9kHdn7a6/T4SiP6+8Eypjq4zs6R80bdcBwZnkbvbJa1rWZ/fdV5OHobwqE2PFO1kz2rSXXte44y3woPysqxnnHlnyJ94zDuNPswQQpXHpOenxul8az3kvtKmMKX03vuSLMstAm7RugfSyugZfOZEKAhzlazTOSrfn1StYYS+9eM0uXWnq7R71CoQbr7+mB5MeSF/8ibq8Qd3br+iBdVvNjr2JfGY/ck8G3rV6wy7Juzuqe7pFbfGVN5q2e5cATw/vET2j3tCD+c2TNfubn63pLaKmfed7TTsoDHrumX7bsKlfeHTdrqrcIYFuBAfAuEDeqansptMQpHpvfJpUszvlcj4qpl/+Dw2BZM3u/kDN/ugbDfvAJ+taYa/ug7y/fQ/WbURP3qba9lYJdFIeXVMV2itheT6t0nGD0Pya+O1QBQfU6i7JE5QesDt3bzmtwlusAXSv0JTHBxiNCNSWr9bkgzzDXXcLnHRPa4O6h7p+8Iu635fULgARtZ5jepJvW2v2hZ/ps+f0MOvHmxSPQXmQ/avlbW2u25rdZhdE8/mfq8vD0uP0efUY9GC9pnaThQwIoZvWmxk4K0xODAyN2V23mP3xl5+WJ6YehNrg808IJEX7uc+qzT1m2t1GMqorhAO0WT0brXW2J9UN3rlT15KbrtG+vVkpYm27lEfVNHVwPGhSWMtp1D1W2p/8mdnHP5V5syvVi2ngEbRZSEbT7W8ZkHTL/05IW6zM3ejSNIYvtqpncUZO0aPf1DicdHv/A3V75UX1NOSFb90qz03pT+theVzt6dPClDcFbjv0oM0eypmW1q6v2QMP1mzf63owq1dxy36lq62sWyOwVG90m3Bpq/Dl639Ju6vZR5T3mDzI229nYowJL/FxUJ7VupbBzDSffu6cTWpAul/MMvjLM2hwuqaO+sTRZ+zAkbutf3CXjV84bKMykBlV6qrc1mF1M6Yn9JOXp/kS38UI5KfLNK2+ux5setJm/Hiy42kSyKOHujVUkfX/vZ4TasQmPlV4GzTAE/GUxv++qHv6UwI+XXKb+PlTPL9nfi81xsLEFfeRMRe8e026aiY1v6eKZycr7v81gczweuVRN+WahkRG1AWduDiq8bkxO3z1Czb2wd+z1Rr4mdZ2XASMBo8FT2xysqGn+jf0hGfygplcjQlJTsYQNVqjQfCGTVzL4qFFNu+mq5Hzelu9Ptvtow40foDV+Svj888dtZ1719nKYW2oIKAjbXJSwD0waU89c9puuWWHDOtBG1wOoiOfmCh0GjOLNLqLZV1GyqWbWzbethS0eGIp6MCTgJfGr1O5vI3DphRlAXkJnby8brpIaa9cOSset2pi9Zw8wGHpdNK1ybgc943iz8mre0zDG2v00HrkIbZIk6eu9kXwe5upv3UfiWd8UJsBabIsn3vQkXvNPITepPSQ8aF+fTauxjM1dUIL5DfZd7/3bduwYeM8zzcJB8L26ym69u/AQt0D/fT89wpk59E0vLzF/dFT2cGPAqrw1mtADcbUDV75h/ww9psT4Cxny8OF3RqU/vc6VSSAhweHQTDm5oDVnNJY3Ac0+L3aB8AhwhBWyvsjsAphNQ2wJJAPwOswLOYrEz76sYwfZaUBGT72SJG2kCklqM570gBYim4BtWm1Nx6Y6XzQug01++zn9fAFqxTKwI/49H7BQ6uh/F4H4Dmg5uAXfHj4pHTER+ju4Md9VyE0XvuAjupi+JOWazUyP/dEIhSChvOIjziu03OBq2F8mp1RfzjLT3rkq46Zvm62HqRyxu9sq34gVJSn07ZzrgmkE+JeZldz/6p9MPbr+UVDW+GBWlNXyG7XudxIPK/xyxfVPTpjO3ftt9OaEly2fFje3kp5THIdFRoagBYseiOmgWeNWbvGNPocPCMujng8LK2h/xpx8InzpjZ9aMpthU8rLudbq6EIKsZgOWXOVhJDKguZgWX5OuWBriwtpS3j3YmuU95u8Z3K6hSfll3MwzW/Yoh82TFL5R4zdvfXX9cM7njD9uzUZJm6rxvUI0i9QMCPBxtH4nmAof4Xn2naBTWFjzyQtQHykJZ57RlYcrtZoQJwxj2dlW32Hs7GZWfdATBy0zg4V/ejpt+Shxz1l5xvxbB3DahBOVDxMLqZgXutSREtB8iwVcZx6uRRO39pTB7dRjt65FW7qoZ866332sX+MYHgOgEdrW9241PEo9tKq8zSiJkNGQBinNkSkBTEyMUO2CB+MT5Lg29mRH6S/MGoo2uXRDsQwIs0jp2AIdLLaOlOztd9TunSc2gDeNJ4zmd1UUzJrqM+5brgYVAeQhdFupBjlm+/urMztmFL3e6Val8/oaVVt2hi4qmGqRdq13SvCQcUNz7WtKNqG0xMMcyxW+OCE+NN++53GrZfKwi43yeZJPmLhk/MTWtW+FnNPdx7X90uaTZfy5ntYz+iWXyNK7aD4Fyg9kL1pzcAjNwYCb8qVBpYrAaS9hPP5QGtcm4IPKbVN1qm1bADtX51e0dtzZrretIvEzDMzsKmxS523AsencbEwqA7jXuR3o2W9E5jgN1okakbAM5H+07URVan0PV6gbHWvGmEefJaw17X6oI7HpTXxvCaJiwef7zpM/+sPR2Tk3W/Jt8I3/9u08Y1HshM8cOa1KhpWcBKDcsefdPslUNac3qL8ghId+v46U9o5YJAEaDUbWgFdJd1RY56WitBJwsDQD2tHQCDeVZW/ihXWnWN7is9dGsHACDDHehJDZOxoc1bd9va9Vt9L8Lh2z6oCQ/eCJGL+C4LZZ7fO70KyBxe29LLSkPAm9abPtMv+MSENujxxc/bd2tSTECmNxV9EmO/AGxSYHhBE2drNc772huavd+jbu8j2Yz+Ma33JNSFWCxj4c2gj9wvIDxm9pDynNUk3p/+uSZQfiTLRwchYMrpVA7jwrPGmeVbGADSeBdGkZVS/a00EBrgIaoGTOv0BiobqalVD63o9wY6qMWDPLAzMEmbcDB4Zx8zb+OdLWNRupsnc3b/BgeH9XbGf/A3xLZu1uiHgOj2exjSUGMY5V6b7QEM9TBkyczgIICpRdBn5ckpy6p12e/sWflfWjZ37318DkGz7WK/UZN3vIihXc1szz78PL5rwxs1s7WEP69cjo9f1SQaT1+QMMuwMDij8SZdmNkiqrNKAz1qgBanp7dPjuQkgF2M5QXwJe23R8ZVtneaBgJYB/W60KZNn2gTj0mOdBY4TUwnQNJ4zgGzVcIvJkE4ZyUAxwC8brRDQwDruDqqIshDOwCq1cXOvy688sGc7E4C+FUAGLqrjovRAO0nusAl9NGYvb0lDbUk6zsyKgPwd6RoHYVC5gCrjplKEnqvawtBnAv32GfBSruTPPo0S6/lAuU79NBll6uosUTGAwkBfplXx6wKjWz2EZq1KWb1r+qX0UBHaANAEvu0wj+CLwOQ18cAK86fkebvRkaO6lhpYIEaoA0xEzzbzDT4nw1a0zY5Z3kDBsm3P7KQZO6xuMUYNKyhKxpJj0U6badyO8WnvHvJk+bv9bwbX9I6pRPfTRed6ObKxf2bvYdiqzK5t44qc7KTloHfLM1sJgCMXzvPSJ/lO0tLeYQszQcCswj9bQEgFWWroFPHj/l3YC+OndW3UtfbmSsXbau2VNBEjA3V1EGPNtliUZ1UGliABmg/AKDafvbA1VsA+rrbm8eOarOED+krdU9YTe/Tbd6qt454j83Wqns8dyEryzs6GW8s/ehkoKTzKwuzyzdmDSjN14mWskjrVCZ17UQL/5Cn0wzyfLTddNFNLtLKlucg083URacyo1z0tRhddJIZXqFjyoiQA2DmAvNNhse+8Qe2Ydtt+nBMn7344lO2ZfceO3fqiOabRdLkPaQgrY6VBhahAdoPrU74Es/xC7xMru7MmFbLntE+atN66Xj9xm16pY0dm1nLN7ccDIRfWQiwKTMg8kd6GVgFzzim/ImLXxpf5NmJbyfaoO+UHvEcy0Kkd0tbLG3IVuQdZZbxjbTF0AZNyiMtO+LLyk1pizTckzKalgfoBFod/6GHP2uTUwwWTupVpPXGspo9O/bbENPQBzU/PXUzVkKn4lbn72kN0Ouh1dHN1QGTXrN6rfZp4/3Qhq3bsFNbJI1omcOQ1gGu9W4wM4FFf4zG3G09HuDXaS3ffLSkd6LFkDqlqSruAXYCXtK70ULXCTy70Ya8ZbTw5CHSqdwb0UU3mUhDnk66mE+Pi9VFN5nQQcPfECJXFnIAzJoX/e6tO/YKKbMpaTZHaKi7MvXiszZ9Ue2W3QvLew7BrzpWGuiuAQAwHwPECFj6sEZrANdu2Ortbs3qdb68YVwfSOLLdR5okMpbDBhvmdGTj7ROYbFpN5tvt/p0qst88fCcr76dyu1GN58uuqXfiEy91jdtF1E/r0+hWbR7gEqM7bBgMEUDFGo6A148Z4+1qgs83z2o0rtpAADMPcDIxhgfgTbHeVMTIcSkjdgzLNGfm8UX8W4m7yWq/hw2i5V5Prr50ucIcpMiusnRDoASIM3cOufhy+LVGL+5SYJWbN8HGqAt0eoKDl2rreUqKCS/DxRTVfHt0MAcAOwoBGu3AMCqC9xRRVVCDxoo8QABPw1VyftTE9MyGc4znzD72wPXBWXxrtCCKHrPfDN59y7FwnJ6D69kiGE+LvPVdb70+fgvVXq3+lUAuFRarvj0poEEAH2YTq4e3/KdmLim15tGtPTlil534nW4fp8AcaYdjLPoNaYC3EjaYg2XMjuV2yk+ZO5GG3kWe+xWdrdySeumi258kbVTercyg64T7Xw6KKOLuDimPBYOgDfnoZzKVJ2/lzUQXWCAUAjIK01HD79hR08c1TueH7Oxs4ft+Nkxu+XWe/Sho9O2ZfOoPMNsoXSqll62gOpkvN1oYx1ZN9pUjvQ81raVzXzCL3inNHF+s7fD6lYf0srAIVuC1HkSBZk7hV500UmmXmg7lYtMzPam9aEc4lzewthK7wDIzB25KwDspPsqvhcNJAAYTYmPm/Ot1qv68htbBe/bd7u2zR/UB7lGFc8rT7MLjMNYo1HT0NM4rvnF0o9IQ7Q4j7Qy2qgCBhP5I45r4otLNCJfHFPaiONISNO4TtPhyy/ykh514bwbLWll9Qn6TrQ3oouQt6zcqFdabsRF/dI06pemB+/IS3rUhfNutKQVZQp+M+yjn4SFASBP7WoWOFFfdbpgDdCGGEfWUTjl436bNm3TVklDNqi9AGuj6/UZxdX6rsOUtsVi1wTyze7uQcPO4jKg4zqNizQafJoW8RzDGNK44EFaGGLEkY/ANYBBnjREvrTMiEuP0HIdccEzjil9yr+TTMEneMYx+MWxjG/QksYv8qbHTuVGnvloQ54oKz2+XbooOnC9ASBtLjxAal+FSgOL1UDiAQoKtPmGXrEcXmU79Xk31gQyDkiYlMc0+/THe8qAzxN7+DNL20PmJMti6WDRjbZbWhRPngCJiFuKY7eySetUbje6G5GrF76dZLqRcstoewNAKMmJ9xf9FuKqUGlgoRoAx2hDiRPF2j9mgDF+zvvYHGGhfN8h+W8GgN3sqr0bZV4qnbQDoDdOngg5e45xjgcYAPhubZ1LpbWKz41rIACwpC1Fk7vxQioOlQa6a6ANAMPtZEiAX2NGa7IEfA09mTMPsKS1dudfpVYaaNdANKEAQKFd+lnMPm23ps17W8/dduLqqtLA0mpgFgDl9rEIdeLqVW1Lfd0uXzrvH6a5eG3SNqh/0nQPkNHrKlQauAENJADIA5cHbXwWc5c+i3n+9Am9CtdvwyNrfMLhBkrqSEq58bDvmGmRCfDtFLqlqf/fieymxy9WF93q0y1tQRUKfd6AfrrVLwdA3TQVwG7Q3//Wn1ujf4Vt3brJXnvlKVunD9ZcPfaa3aV990fq+mJJFSoN3IgGws5zL4+dXuKzmGvWbrRnn/62ja7fZbt3D9rY2Hmb2c5+gBDNAgtjVqzpioadGls2jph9DhMx0zSuSe+0Hi9Ng65ICz20ZfFBy7FIG3Gxvq1I77RaAN5YscJnZNN00pgx5UdI07gm/e3UBTIUg9dHeuLYTRfQdaqPzzBDryUtyuTLBW5EF/Dz+x7tLxe65QGqLJvRZwlHVq6y6Zo+XTd53Ub1NZJJNbTd6zfaMDn79D6cGmwVKg3ckAZohGpH0Rb9s5gy8GvXxm109Xr1ROr6MM4KW6cNed9Nn8VEJ+nSkFRHGDoGPGcLL4xb8X3f/4G++/iQ1QSCxQAtxjuHNskYa9+SKD8N8OxEC+9lfIm8JCAvAd5lobQ+eUbS+KGPYuioiyRjS4/ntVfkoHCHLx8p3IguqMe03jpKQw6AeH+qqBaf3vehT2jsr2kT1yZU7oBda9Zs4PiLAkcNAy7TzWlfR5jyqs4rDcyvAWwKZwabkoGw9IXPYrIl1sDgoD5qvUZrofsVLw8s8frmZ/zOyIGBLijkIGNvvmm1B/WhXEIOitnF+/Rv6PGJx/V9zH1me/ZkerlRdRRuT8sD5HFMF3jaH0g1rcda4UC4YkjbYgkd5RSq0Raob1SYiv79pwEAkF94gLQ3jfmtyD+L2aedyH1cUPsBZhnfXSoKr2lBUsv7rTHzw68K7RrQW0L+rcz22CW7mgVAsfTVVzROhWzIQeuzNBPswbvAOssvs8jqb6WBRWgAOw9bV3viwZt+FtPf/V0E23cdSXh6+hRFkw0g8nG+nusR9D0TvAsz6o0gdUdvmuBtAFhWinvogB5dFnJXXeAyNVVxC9EAHQnaVFuHIovEprUOOk9qy7CQEt62vAvuAiOpKt3ktT8BIWrpOUT3uWeC8owxJlee+jbHMv5Hg7hJYV4AbJUbHmArojqpNLAIDRSBD8DjzQ9AT+e8BQLsZQPoMfi+cANYVFc0L3dRIJbTdiq3ND4A7Jo8HHV/F1zLQ4dMXxzXZsXsVtw5lJadZyetUzrxi9VFZ2myeztfeksm9Q54MPQaWnQlBJ5WUPL8AEhrJAQAFhhkidXfSgML1IAmQpjkYIKx9VnMez9kL73wuA2v2qQPIq1/V30Wk9rHC/5lmgBIYka2le6Irw0gtO62MbLSmiwdyRiBEkm2Am3QvfqqNUe1XZgmj+g+10pmXCmzm4dHeizPaRWYn/iyEZ13ApU59UkYkNaJrlQXCS3lNlUXZoJrK4ZcFw5D1EX5upVbJjPlMQMMnTNIypofAMnMvXAA1ElyYxI+1WmlgYVpQE0JO6Y5tT6LeXHMZqau26lTx7XqQcuxtASLRksDJm8EDCuLyyI5jxBp0GFAaRp50vSgiWOkcZ3yj/SId0NKI3UOLfEcUz5ptuDZkgm5ZZg16rdcXWC9hOA1wVBRTMK3jTanq1+67PmbuY5QUot3Tsv1fLoI3l5g/ietQ1k62YJ3Ssf5onSRM4lyvUz0MKLNMQAv1QM9cQx5OKYhpSU+TUcHXPs8h9LIS+gNAMlJbyR6JFxXodLAYjRAu6Pd6uenOmafxbym64YN6Q2QQTW05UPDtnqNlsRof8D37Gcxw4CntKh7xbAWWWCgCpoQCQDkEiDHs5mzHu/cWe3StMwnUPrhlRs1NBGgxfjn0OYZAIVOawQDUDrRwqITLWnQU35ZIK0bX+hcF9RLD8I6dZNe6rou1UVSSCe+xE81NKmiEA/XhQOgS5WUVp1WGlikBjAC1gGmn8VcNbrW7X98/H3wWcwAresa4xpabk11hXs2L2j54SXp6N4NIFEIxPPrFCKde1EM3ejI2y19vrR508W/RuPgp24+dSwD+DKZ4Z3WJ66jTLzAdevWqZcx3KMHiG68C4xUxSKr60oDi9CA7NaD2hML7wk0Wpmr2vzsRIgnLPGf1Dh6Zt2jAS6Id4DOjJTBRAZgNl8IOcbH5RqqSwYtfIhfZFiQzEkZ3ehI65aesCk/pU7oA29YDwYHQs4XEVI5OMcj3r9/vx/bOQJurkhOstBSa3SBZ5MiS3WsNLAwDdCGCsupaO+E1hhNdvnO+RsC3gyJqDvGPTaWce+lLI0X2urVPD1uhkTvDJ5gEQ8GbcjS08NhAVLHmGAbAFIeSxIA3uweMBOj/jLPZXLy6+EhtQA5qqzvVw0k48k8lWln4QDR9rIHb+vxuzAtzeMNRVeoJ6bwQqAjR8w2bDDt09+VbEG8gxOVh+88ckd2PyLTKnUNQ2ltiQu7iC7iwqgQt/v9mS993vLgj154G2Sesrrx6la/NgBEp+PjV/xFdDZGYODx+lSfvtWgwUdy0miVpwqVBm5IA7ShpE03GrOfxYQvg9x1zXwwAZKFBTY6ZlY1cN4ppF2iYh7SSg332982+/jHrbZ+fZGkdQ1tJ96d4lvEMvTakJZ89BoAPrxGjHae0K3s+WQu1UVeXje+ZOmU3q1Mp4OWE+rIfdQEUa+hrMyIi2PKKwfADMkZeXnztacEejM2fnXcNqzbaFeEvmunLtgtekit7JPbPb++U/7VeaWBuRqgDTm2ZesA+SzmkeNH7L4HPm6nj7xgl642bNfuvXbWP4u5qvThD0i2PdnxEDQjWjt+3JpqszM7drjxlPkozACWBQwk+JLuxp/zrV8Ys+bEhGYRtZyCgfkC8EALX47MNpYBx5xyg7e6szMrV/o4F2sCWQOXBnghF7xZ8uL1VLeQdX9cT6ML0gt0UQe6e3Ge8uV8jkx5hlJdFIi70faiizIdhR6ZBa6zAJpX4VZIn4wDMuOtelIf1wX6S4LT6t7XeQAW7g/8yuRt8wBZY7NieNROH35TWxGttaNH37CNO/db37SWJ7BLT10Np/3eJMVXp5UGetQAAKh2FO33un8BbrldGjttb77+nMZ9Ntm+/lu1BGylwKS/1eBT7hgPQNNq6DIKzKGmrmpDQFXftcuXTDRlCK08OQMMyJdZJEYCP/KFUZIecS6o1unVVF6f4lmu4n32nF/kC54ci4E8xLct0QiZtQzGjVZvhDglnp3SJJCzCQBzmRTjsWzflJ+HTMhXDG20eR3TPAvWRU7cVp/Qh4696gI9tOlCfFNa6sqSF2VSb0EPHPShODCK4LrQefHe1qU7bxeeK/sTskIT+ojkNgBEsQODI3bPPR/R2yfjtnPnLXZJT5qNo9qh41UlLtNTqnExaKtjpYHFaYCGpnaNffOm06bN+izm4JAN6Sn7wYc+b1PypGjng3rDgZB+FtMjPC4DtpYBqHE7MHDUXpYACR5RKz0IdXTjUloaIl9qWBHnM5Bak8iRMtzTSsAz8kHLeVwX+Ud6K578XOhPTYbrtJGYyNcmU8SjIGTIvc5OdYVnlFsmF2n80hD52spN6kvelK/LgYcmPtSD0K1MaAGiKMcJ9CeuqYvfP8rkXeBkDLCjTLk+aqdOWU35a7t3Z09Y8Qi+0HYAQBVE0LjL9p17vPHVauscdNeo/GtvnrOGJKpry/zsjmXZq7+VBhalAVo3AKh/TT3c47OYTGjyfKe3cUXrAGnTWeAkb6MRVTwGIGAsGk9rkRbzzXONt9AKwRPjZiYyQCDiWxmzkzbaBaS5lwNw8EvLL/DwyyibI/kF9vOFllzBO+ohQtL4BUikvFp0aWTxPPfM7NFHzW65xYyhh3lCL3xbd5yHoB48DkbwjToUyyAesDtxwuz8ebMEACNrWbkZXLdyALbtDWCGZfgKNXLiYWeXRFWh0sDCNUDzStuRcI11gFmPD5DL1gHOA3dzyw2jBhSYOSREXHa1+L+AKpsOPPGk2caNs/xLOJYBSUm29ijkpasXcrentl9FndDjqlWqY3ty16ugLWRalMwFHnbkqGlxXRbbCaSKNPNdBx/00kH2Fos8vaa8voCahPlolAVYawvtykjAkEbLL4lqI6wuKg30qgEeoh0epPmDvFdOs/miscMAj23RjGZZts4uXxYACvguaviHBcgY5FLy1xgg3cc2T6dVeIcT8rN9Pt7RfAFZCRob9fy8X7sU8sMDOdjNhneZ59mVJhOih78hLw8e6seW/RE3D7njFzL1GOYAYCkdTxly8svGXkuzVZGVBnrSAO2Th2ke0s9i9i+jY6z2HokcA9zSuLJzjCTtMpVMCpSRzRvHrLFenbIPaDkGi5UZD1zKwKtwGC0znpTVS2C8AJr5NgslT4DHsePaeULdwwceWBoADDn1QSd9TEjdxx5lD7r5jg7uag0ce90Si4dfAHEP7aY3AERQctJoabxVqDSwWA2AbHlvgjEZ7HP80kU7c+6M7dRnMU8cPWSDQ6OaENE2TyDhqZMCnLW9dQ8BDwyAD+jQp+4AgJTLr9XbCYAoGgzxxGF8eH0Cvr4n1Q3es6dj7cvGmTpmjgQMnHKY2XWjV0KUHXniGPHIhCfHeFfIH3k4Rj55rCytcdDW0jbPn+bzrIkuCmndLlt19Vf55AFOC8Dz0EqLiMUcQy+0A7zBXgINinHRqL9o2u51gUdvAIgAeaNtfzQXuFWXlQZ60QAPUf2ijfpnMS+et7UbtmvLo2l75eVn7JZb77MxAWPzucdt5uOftKaWZfni5hykWNPVatgwouHLSHzLJBl9A6NXHOvkWkCXy8aaOoLHQ6txw9iLL9Lg7WvuBHx18fW1f+pyMsvZEL1vX5/LEnK01urBsxDIE7xbSZQhGfvEb1py9vUvE27n2zYB5gn/oG3JpEmZ5uo1VlPXcxr5xNRnp4M5fJD9tdd8m62pD3/Y19UxPkbtXZcqO/imOkrrAzvXhWRN8xA/g4ysvZQ3WgOMxZsOIrxncr1DWwylulCmKJd7Wxffvun8E6SDeh0OL5k8qutMzjPyZwnSpe4NH9SiYfm6QR6AnCsDS2Oirp4//9M7AJKTX9UFTvVXnS9GA/nDlOcqIfssZtOuTVzSMNU1G1g+rOVYQ7YOA9fXCfvYEgswUAMPUIDO13vlIMG1e3xsDgoQyrj7MYAOXqBv44QhQa/F0yaApesURu5r1HJD8zEoxtvEU66pl9uJL/RO6wLN/gljLd0+SkDVL4Ova8lHPYAvqWsbbciE8gY0NiZ5HERVz5DdSxUAeWB8TgGVS6k+RMDzx+skWeGNTG20pCtEXFl9ABaGG/rRH94oQw+AFoTwywGQpSfF0FafYiLX4g0VayN1E7PfeOYB+rdTcpnbSJEHWRiLXKN3pCkXHSaBehRBsD1HknnOKTXjN7c+c7JWEZUGOmrAH8dKpR2pwdJ7an0WUwa6YvkK2z6wXGtf9eSWR8HSrJ67PxSKIbZeoSMiCWEkSZSf/uAH+ibvw7NjR8V06AJI6Qp34iO6AI0ii67XAXaMXTFR0UtABurpcqHU8tAUKDW/+U2rywP0jRNKxtIWLHPU/6SGJ3g/GrAFXJc6APKhGzz6HkJTDxB6Ad5mVPf5Qm8A6IKIFQDYWdfzlVWlVxrI2g+tTm2JZkV7Sj+LOTw84vHX2biSSYEAnl50hyFiMDz9wwNK6fAQygKzu0xuMNERxk2+OGcNYM6vKQDx7u9C5CorM+IoA1AlwHNcr5v2FFQXPqOJkZfZZF5XAND+z39u9vM/L93ovNPDoacy80yhl8f1zV7W/rEcB8+104RM5GcHm699zexzn+u9NGj9ocYTU4F6EVcMcW+RI37kibKL+fPr3gEQ8KsAsIMaq+gFaYB2lLdn6OgSxWcxG3o1BI+Etz/8Kc6EhrrBPQU8Rn5lBoAH8dJLZnfdNdeANmqNHyBYDAApNGfO6OPce7NU+JQZYJG212t4BT/3WEqMu4wXX0oDMDsBQtCIXeO3/mn2Xu3lS5o4kT4pLwAj8i3kmNPWmPk9eSqbdOLBwxKhbkFDE65L7g+6nS8wqwxf9NJLfvHzMVKGMkKn85QxBwBpjLNB59n/2e2w0uTZjNVZpYHeNED7odUVHqYxLuS2qeQmzhpgw9gbM687dyoiCWk7dSIRBADyfh3naWAsjLcVAMAAjQCBlRrAhyYNwfPb38m2nYqlFcSnZac0Om+3n0Ji2SW88HQJeIK9epbkAxQAlS7y+Cclt2zRqzVaqoIuCegVryoPofu47vnI2shLAtXXXjc7sN+M9ZLdArJSNvemWM+oQ9wT+ACUEWJoIPJFfHpUGh5vbQHd8XYAVBvq79cf2gINsCElK0dTwjpeFxptWnZ1XmmgJw3QtmhH/PKQrgPsU/sjqV5Tm7sgo921O+taYQx4AxFSQ4lzuqmAgq7neAC+bEQeC3zIHzTwwyCZUFDA+0RET8fY2I6dcnMPhAmHObzJr5B5rhiOArSU8cQTZtu2WY03ScqMl7iZzNCdMgw94zL3b8gNgPALjzTigyKuBarOFw+Xrmo8JPJ8bTIHbZJWCug5b59J5sGCflgbiadMiLKzq9m/PkTBrPHcmfkijctMfnhRzwBDrsv0SCnE4y1yTPPnElDXYshblAgIWof06ovP2sjoOj0wxrTMaNTGrkzYxuVXbFIPjKF+NRTJVIVKAzekAVqdcIoFCgxJXTx7xo6fPGEHb7nbjh56RbOay2zNlu36LKa8i53rrDk+4csf3BBo3GrIvi2Sjt6oicNIMCx5NgyE+8v2CInBY6A68ppUUwbb0MwpS1kc1IhXfh8rIztGp8AMpI/38VlG7TCTW4jeiZfg5KFMfnlAjnjBn3OWa1CezzCrG98QAJLOrxWUz+VCXvGCri5v0LmSj3QFQKhFS5mSDRAmn8ue1tcpnMjzsYVXQ1tt9QkAG4A5gMUPbzCXp02mnD7qQ5eSfUFna9rKILjIJ6rEnyU37EbjMuV84UENHES5P9RR+ynCM5bJuA6pz+uvZ0udtMu1p4uuT8trnJaHDvcOXjlv4j0tFwddMfvf0Dije4Cqo8vMfVZa2UYIkOYAmHNRxoGBPvvOd/7Sbr/zPnvume/Ylu0H7czFN6y5X3n61CDdFczzV4dKAwvVAK1StsAPW6Y5ndG+f1evXbHLGkMalCd24vQZW7Vpq+8K09C1z2Sq4TsBDVpP+fr3vmfNO+/UWjgteSAOI9KR7a8aOgdm4B1G4lAyvEJgejUDQPgRBB6eL+9KYmCISCrgUdekjGkGNUACWfwc4YOH8gZgUA5rBR08H3vMam8csuau3c6vBWLK40GywsPL1xG5a1oK45LBm3SFMPY4ooeaDB05AWrfIoo4ZIoALd6hFko3t2615pe/bM2/+3dbwOc5KTP/BVkcKZmHBMtOGuLlM/KRyJGytOSEejbV9XXPWOUhIx4efB0ABV6teyBd27JsezMvN68/967+4ovW1IQK95Ny0UmMSiArPL3++dFlQ44I4uX3n4cBY4A6Rh1TPUb2OLYBIDf/6tVJ27P3DpvUzd++Y5+NTzZs39ZdWp4gkpoGUE3dkipUGlisBmiVOQBiZIz1jchDGrukbwLPXLM3Dr1kGzcf0PK2AVst8GFBrK/9wljwvjgSTp928PBrPDwCBoYB6hqvhWJa3WYAjllQkTOk0x+8MGS6TfnHhRy8ROa0lLVurdntt1tdtkH5M6Jl/z2XhWMaouxnnzU7dMjs//13Zj/+BXWj5YEpH7znrAMUP8pnzWIdL0o8nSsy5QHDZ/1a23o85CWPjB15fM1jEMRRINlQnpo8v9qFC5ncoSvy5OdzZMrpXRcC8D7WST78UAZ6oX/0Bv199/nDx0nQP+nE6+h1ye9JK529D6XLmuRyHcOHwBBFIJ7o0UGNNYB40fADzMWTB5DrgrgXXjDfgAE9EKTDpjzbPgAw7k0uS5bcpyaSDTd4fv0RF0LWqGrqj+w9cJf0ukwZZ1yp05Kveek5fRcEOSRMLq+TVX8qDSxGA7Q6tXA8BIa/Nmzebes37vRmeN8Dn/DWOKn4BssqMCiMBAOh28a54ryro4e0t9w8zgEQg8FYADxCpDHRwGQHUf4n4+NeHFvR825tmuZX+hPGFdfwFhhlAU6Z7XCN9+nlat2d/fN/afZLf9/skUd8AqJVZkY4+xf5MFzodV6LZTAh92zO9jPAgfIwdOVtkyRokVNgQPfUfvIn/Y0QY+dpdEmALv9xLyLO+WpygweFvfC82Tm9bgcApgFPTBMrtQMHstiYyIk8pDu9QIoJF5bLCFPgzfCA64OHCoGy6Zbns8guE9HUDR4E6hRH4hjT/KM/Nvv7fy+L528AMOUlQOd6pVwvL+eTU+UAmF1RRr+/joNe5VqLoK61RnIqhcbKw8+n53Lq6lBpYKEaoP3Qpvm12rQMP39is/zFn/7wpcHyahMNGuNgoD03VNpqLTFksvsiYo0xET+ny8aauXzcKzd1J3HDwqDwqIoBIwojjTRApZW3jZMba41Z0X37MrD9zKezMo8dC+ryIwBFQA6AjZDXM7so+QsNecpkTLPjARHSbbwKdWqBX5Yz+/utb4tGi5x375nd4y+VCR48DDzoZviaxLweeaxrh3uU5uNhEw8Q7nnIIqAurTtl8vMt6YOxruXd2nqt24RXPKQAYcqCb5Qhklb9yKcebavh6SzXTsYYgQNos5j8LwncF355o81TqkOlgYVpgPZDq8vtvCsxDd+BS0Zz7txsVhlNkyUYudfWAgsaPQYm78AXK89SZEYEGARoRhoAgreIARYD8WGguWHgTciVyHI6CmMcSQhj/y/+drZZAfQBQimABEnw4AgAAmzQ5A+EyNZ2JG/wTHdgCV6RmfICXKkfIILs5CsLQS/P2n7zN83+p18VkEg/6JUf8kUgb+ta5SAvr6EFj8iHvgOgiMMD5RoPTrs328GDWU7GctN8xHJvQlbutQ9TZNldR5s2Zw+91r2TTHGebhQbMjFLzUMwuQ9tAJiznj2k9zYabQfdzRJVZ5UGumiA9oMdyV7aAm1NaQ4waqB+xCDwAGnUYWw0XnmD3gwnBVCEMJIANzzGAnA58EHEC/ZOlP/ByOjGQhN8Ih2jT4zFozH0Yj4SciPzl/B5o+SeezK56dp1AzPKiO46dQR8ANEw5JAlPVJW0CAfb7HABw85lY24CHRBeTi8+eYceaKLGFl9zSALpgMsqAO84h6QUfptSkaV3qq7y4Te83zZPRIAhg6JZ4t7wiWtGfzOd2YBkLiQN+pAHeOc4RBAMIAfb497FnqAnkAc5eVLi6D378KQ9ru/a/bTP519T5nuuEJ3ACQHtaCWNFpyt7UeXVeh0sBCNED7yR+mjFxF85phzFndvxpvOMiG6Lb4R3G4Zq1MeFaUpW5mDY8hjCkABgPSuX8cKIwpjA9DoXspD4jm3AoYGGODudFSroMvGUgLg8v5MHjfCsGbCJ3D1z3PzfJMWPdHgK8AxMtM82epGVBLVsr1PJTXEwAC3AqaVTW2gcebYp8/QpTj3WMNLxAH+BGQJ9IpM/9liflf6H75l632yqvWPLA/8yIDiCIjedJ7QjwPoCSfl8sNjlfkuCdKrwGoJOINEgBN+OX3rKULrkNW7jW845qWA0jnNM5H8vjaxLhnRCb1q6/TEhzVv3V/lUxTnD8gLDmluwoA51dXlaOLBjAI2lGfTmZq7ugcPXTEXtenMe/74I/YyUMadO9bYau3bLWzx47alql7hFkyGnlGkBJY7tDgFTlADePBCARMsQ7N46/KkyJgWOoG+hIRDEN52XrK88hbcGPEsDBeGdCMDMaXwiivgxkGk/BhHaCPL0KTGB8mMq28vnUWPIJGeWr5erniDKSDkepQRyb9WKvma+4CWJBdAYNt7WICAIimNpmtc/OxU83wNlRHLxOdkAd9iE9DXpMvk1G8r9VD5vCCFUe5rUCdoGMiRiBe/x/+R2v+yq/YjIYbmLjwLmp4eOJNnDSZ6Vh196UnikMm+PKw6Gfpkc6RjaU7PFBYp8k6QB5wvm0ZDwi201qmOiieuqJP3w4rl89npMWb5TbcI0DS5bl8xZpbEEL8xce30lJaXQW6PtAhehXtjLbsb6qcWnSllWEWAHURizEzdslfl0bXFQAmSqlOF6UBWqVaXa1vUI1/0l58/nV9fvWIrVy1Wm9SXdZepiM2dvmqbGHARrQlVp8MRp2tWXATOY2/IfDy78YihBo4AYPzBc1cx/hgpNGVBjRlJIBMna7S8RNWO37MTOvk/C0GxbuHIF7e1EWLMbsh5Xx8jz3OlTfK9bL1B741dc3qehXLacgDoMhToRvmAJfzgcZ5cJCHG+BXV7eziWyEKFNAAQiyDMZnmgU+NXU/KaOmcT3qHNcOqk6sNI68U52XHTLVtHFp1AkQomwPOifUpgRuy7T3oV4brGsJj4MWdYl8nCuwbtEpidfPQUpp6Aye5OKe+Po8zgFPAZA/YIjXhGsdMFK5Ne5NvjM2IAdfJmB9JhlaHgoCswb6QWbFeRddPYRMauWBTp4uS6fq8vajjuikztCCBKLdSACoPeQAmK3IH9B25ABmrofIM5uT3FFae2p1VWmgNw3QftwDFFhpx5dXXn7K+gdWqTe0RgDSsIGRtbZhud5YUBsdxPgwFG3h6R+7iRIAADy03FNoGb08DIzAu625kXoaDZpZZCZO5Om5ccGLJR5f/kOzf/I/66X+kzKQDKQwMDdevA/KIS98FXAS8Ng85HHZhbLoBCNn/VqLBjngBx2GWKBxvurGAupOL/lqL71s9sH7XR5kQh6XSefOl/LjXGBlmmWu7dkzW2YIhDwCEeercjOZpHzkIY/iygDQ6ywgaX7+c5pp1ay6xhgdvKBRuR5Ey4Jj10rUiXuVp7cAUGWx/jKj0l+8cd0LIKimt2x8yAPQkW7co0Z/ObD6PZb+PeihgtzuIVN3ABEww+PMcrgHz5tAXnZSR0+Gr0Rp5c1pnDtLXi6ePWtnTh+2bbtusxEJFl6i54PKG62ONOAqVBpYrAZoP2pLdRn92VOntXflBlu5dqvtP3CwNW6NPY1fV7cJr40LWm4YAuXS+Bk/YvCfH5uZEmRcbqDkDaPEIOkOqyvm6TKYlhHLuO2Tn8hmR/FOZDTevDFaAnkxTELEAT7ER1wAgujxXNxAgibL5RMbvgYtZCrSCjg8Sn9qbFzwrW/pTADYKSBDgDCyfO3r1voiW5FGZea1yVKQIeqimBRcPZ76sGxH+/w1PvUpp+ljBj7KS/nncrfownMlD+Vwn9BFTOgwnovnSjwPpJhkoQ7q/pr+O434IjPeY0v/zDCngXFEdvE5cXw2Fr7w5F4ypEGgrnGPSmap1VKEqhL2xNFX7dCbL9maDTttdFgA6IQZLo+aAwAAQABJREFUD4dNoJK20KbNPL06VBroVQO0H1qdvL01AqALFw5pM5TrWc+DsT7ZSENjgzpka704coGXEIEGDsgx0aDxLwdAT3eqzGgSI/euFQYMc/b2S8MXv5hdhZGkaUFDXCtdPMrAAIMnGwYfwOAx+R/vdmV50mg/D3CHL6DM4mLqmPN0IyZjGDM6ZGKIoGUktXvvnTX4LHb2b+SLGCZNWnXJInOtZeWFnmOPP2QD2AAXQsjA8htkTANpoXfqEvoDrMiLXvgBfss1KQMwksfTVA6gBRjyICNEWZyTJx48XHPOQy2AFpoAW/QT9SBvhOKDSfEqVQOW16+pXVy3VWvWq13pXUcYgHTZfylMl+hbuSsAlA6qsHgN0LbUjhq1cdnAqN4022AXNejuRqg/rTbPCWAVxhpPdEqm0TO2tVIGoHeCfeExBjF+xeXCq8HIWoZNLLOg8IrlEcRhmPwwxNR7IY3QEia79L8YEfHFoPFE72IjW9HQAJESEmcRAJDy40NH1DdmbuEZYEI+wJQ4gsqa+dmfsTrdYK6pYyofM98RzzH1qriOOuL1ARpsO8YMe8oH2dN1ddCRtwiALE2hrvA6fNjswQcz3ZIX+UM33KvQN8BKWcIdX9xMXq4J3JsIyJmCMMCOnjmGHGz5xUORtaPBI+ihTXWYx9MUNQaz3N/H7B/s02uLK522r19MVCbtbEb3ooke+XW6kVFQdaw00E0DtB/a7bIhu3rlomYLG+q1rPR2zEfF2A6LnlLzujI6kOiCxkzjjYCRYSN0g7W0wY2Yxs9uJwSlM3hOFg/R8OEXhoFBATDhrWGcYUhBx7HoQbEcI3iQHgDy6DfMPv/5TE7i0gDAFuMiHTCIciMPX8HD+JGPPfae11jlhz5k9sOnsu9dsA09Rk4QTROjP3o084qiPqQhp+uQiyQAMsWg4QjTR6hs164MxEiPerIjTkuZOWFMMqV8eLhQdd6G4YFA3QAeJjioG9foWT9mZV23cW8A6nhIBc8UDKlX6Icj25c5mCf3jbLgAU90ngbKg65QD7WkLPTJNb6iJ8/xY4fU/d8i/bMzx4B26G7aqlFmeJSvAsBQV3VcrAYwEHCob5mdPX1SL3ictHUbttnZM2e1I/16u3ThnNIG9IkJGQ2GQ4vlKYzH4A1Y1wBGGOdq7XFHwGtiIbACmyfE7KFH4L1gTABnAAQ8cmP0PGUeAmWEB+WZ9AeaMETiQg6ASuc+vhV540j+kD3i4lgGRpTBuCX10di8fe/7GQAeesPs+2ey7e3TbiK8ucbwAyiQi+tU1igz9awUxy2pAV7Igl4AC0LQwotZ1DQuvQeRj66jA6P0wBE+yEN3Gd78eDARx/2s53Hw50e9yct58OScEPef80gD3PGUqWeAHnqgflEHsuvny6BI8wuYZMEBkHd+123YaufPHtaY4iE1zCMC8TF1T9ZpMmSZjY2ctNv288DVU1b6KaJoMKuOlQbm1QANUEHfgJMDMKAH9pDa3BGtzZuRrQzY8aOva3nFcvVkdtiFa1dtG0s29P6wr/FTF6spD6yuBs4nGWFVF3Cxx58vV+Hpr8BWScw0+vozGUmdmVIZTcyk+no8GYhvKaW8AKZ7JOI1jecAbxkpM5pMbDgdcTKghtbQ1dQlcjPAyDBQldGnGegZ/XzxtuzJl5Qp3ZfNyEgb+s0AwAAHAXlUhs8o68jaRL4IV1cenxmFRtnqeFN659XXt63QA6F+3tfOYdAug2hYf+iLjVkrKaDw9XiSlWVCDfHDvgEI94pF5+soxZt8sb4QPXq8eLCvHrr1z17CG2BSepQHH+QW7GR4gm6IU9e8tYei6tTgdTceYpqoauoh5HwpX3LxoGDtX5M3MkTns/foU58/CF34sh/J7vdZdLyhggzIVdcDh3r5GktdA4TcL9Yfct/r+f33eksX/crLWkn07g9U56rnm/iJsG6Xx85qTzY1AN3c3Xtuce/v7PkztnrVNnWLV2QPY15kzwEZuipUGli8BpZp7mKNwOq8nb/AVlgN9TYue5eYXudyfR1utcai+FYuBtB6e4ACWcgrg1M2Ga1MgkbNUx9DVWALKGZdW9tHYcTMDnKU4QF4/eTHIAAlAjPOeJrkURy8PXANyOX5puUR9slQPZ00fiyhkQdLeSzd6FP5fQkNFfA1gkrzz0jCGJkJkhPvxte+Kd1rgKxK9zJYHLxjh/VL7rr0ZVoA7WAd6cilevcN6bU0ykzLBSCUxs/LJY06i6fzFi1SoIEawwkCfwdkeBIXvJFHgJLJI++NoLoC7p4zz+865B6QxuYLgBzloSNwgzTpxr02hivgi4etGX9Pg48Ecl0oL2siWxMiAKnuGfrxZTLiycPCVG/niR6jXajMGrRerh5i0ACKqj+LqL0Q/SW4/GxJPqUn7bCeMKvWbdG60J0C4gnbd/Aege60APCwUJXcEqKpWbcqVBpYrAZyu+epD7jR7mpa5rJmzQbbsH6TrRAY9A8MyS4EJgBSBBozjZzAIKE3ZJ0zPgWYcB2GGIbmmfVHjd/TyCOj9IC3Ac8IjO25qUSEjvIqWiHKAyiZhCBEHN3fj33M5XDQSPl6Pv3JZha5ag/yGqPr3pYQdQUg5Cl5lw4Pl9lZ6hBlBxFAw8MgDfAoysI1M8FJABKcHzyhATwiLo6htywlyw+YRTrHGC7AI+chhP64J8gW94jy4cU9csDTveP+wCsdK0UO6MlHgC7uB2m5t+/xwduHTJQ3eJNPdfL6MQzS0hkxWUOUdH125fJ5G1w+YiMr19r27Qf0auSgPL4R1wUbSExqHNDzQ5PR6aQKlQYWoYFoP4CbgGRqctzuuOch27Vzh9FTXbV2vePblStJ46eYdAyIrtXevVnhzB5iGBhPAoD+NgUGgDHw4v0GTZYQMEYCadBEIL5lIHkkIFkMGDnlYMQYHnJBu1kTEYyTYchhtMEP0MRw4joM9it/kXFn4iHiiOE8ysZThac8sNaYWgBLRp39BUSYRUoDoBE6ibI5BpBEHDTQA8bs/YdOi6G4fAj9FUOUBS+qO6b7hKeH/ATSKVMPjBm8e/RE/YIX18we82YOYJ7OPMd9gw/80TVB5TgP0tEbAT68zke+KJuM6MP1nGXzrPwZv3zWrqjyoyMr7Oy5U7n+1fdWA23TKfzzMqCrQqWBBWug1X60fEON6zrjOfIAs2E6vfOqHXhpt/7cDiChEAyFsR4S2dEkDILFrYADRh0GXTQsBvjp4hEwbowg+GWxmRHCPw3ww2jSwDXAyZfqmKAghJxFnlnqrBGGgUY8dWHmFWBI0yg3ZCEPa+YC5AFGzqP+wYtjeIABKPAo5oM3ZTG2yI7KAARgjuwsws6XEqVsXQeh25CTJS9xHpkDANEHXiTl46lxTd5cFnaRaW7blsVRPwKys/yGdZ0elD/1VAO8SINX0NEDQB944fQMCMjKPQo9ZJG6lzyI2oMk0wTIxt02qGUvkzN9tm3rTpc7XtmJejvwqVwPHKtfpYPFtIFoQjNaB7hi1FaPrrIT+iBSutoka3NiHl0qaAZzbw1DPXhL5nkRTxeFOLqYAUQwACjCQDGEAIKr+VZapIXBwoc84XVxTSC9CIDw5nc2fzsCOj6d6QCr8aYUiDMuWT2ySmUxnGPALOXAO20zVGVx7xjlKgBQMmzf/JUuHjPD5G95Nlk2lynWOOJFvfiSPuZ0dC5vdJRPTJh2eyGwOYHpXWwHKx4mgEqE0JMPESgy9EFZaZ3Iz3XIxg47E/LCKI+4VLcPPZQt+A4Qg5ZhBbxplvQgD7xSD51r7rPnlW6iPQC08GYVAMuD4p6zTCjlzzX6Jl2sIiiWuJrt3ndQC9C1qjxSikfuR/WrdLBEbaCvb6W9/MIP7ZnnntSk28F87WpNdh0tUEafvv4U6+9owBgoBkEgDwYAWCag4EstshyZ0QbYyWDqZ85kKTGO5FfiJy/EuQZv+IXBRxx5WaqBMcITXl/6knf1aprJZrC9JVtWil/7MoyUBx4P5eN95XJHzb0ukVfAXdO4X50uKGUiDwARYB9lcB3GTzf2X/wLdSXl0Wn8sPUeL3mhJy8PBO2PV9Nrbtm4peKQHQDM11P6pAo0yALNV7/qX8gjykGtKAPlM6ur+8GmDc3DRzKwhS/3CL0p+MYH8MQbj3He0DMPMtXP9RX1gYiyQie0wWgb0PHQ4UEoT7lVV/RKmUnwmeZCF1ZcCeqCTDV1L+DcIUQSx+pX6eBG2oCa0PT0OTt4x/322R/7aXtcXyE8P6ZtjWam7PU3XvfmNSMPQ/O13tgEFdnWS9pXzncSkfGyzMTjdWyyzEIN3q9lbBz59CV5Gxijxos8Dj7K36dvdjTVBcRII74hD4G1a34tOi9ZgBPlsOSCNC9fSzWa8nD8i2gaOmrqw0DMXDbkzXkeZOMXNMiEfMSFfPKOmMluambXyyJe6Zyzy4rzozzx9+UbR49Y89VXRaOZW4FUQwAa8vhR5VM3P2cLKr3R4dtVyatqCFA8DXkoQ/RNydr85CetwXIS0gWwTqsZeS8fOcgvuVw+aP7qa9YUCJIvq0euv7SeGtZgWdK09N+4qPsicGfpkH8HRGmuA5UH76YeWmja65zfC+6B30vKFbB5WcFfHqHLSBn5/fb6qDy4sEilpXN5iHEODWOGXBdDDoB62koApok7BteCUqtjpYMlaAPy9RxwrsrAt23dbhfOnlDTamgM/JA3sempa3ZFRhfr/bwxYzSPPjoLaIAGwIMxYGhqnp4PI8d4NLDo1wIUP5Iur6Px0kvWAERywHCjClAlDoPjp0F4z0M5XEd+DA4j9p/S9Cqa78enrioA1ZIDGsoErATEzgNexEGrbnNz//6Mb16mfCX/DCW+qNMAwvI0m/LqWL4DYLCmEINvK4e0kE91ad5xuzX1edG2PFE2Y3Bf/5o17tRnRSkP2aClHEAKXZCXOMk5IxBt/tVfaTnOdmsI7IlvaszCAQf6qGee34GXB9DDD2drBQEm6kt66DGvb/OK7oNwJx5GrAtsalmRlwEN/JGFPNxn4vSLvQh9nSP3Xg+0Fn9oAFfKyOsBLQ8Br7DSI8wdFYyU9Fhs8GladV5pYCEaiLaEgauBDsgY+QJhtnFnzfbtOaBzejMjtm7ZOl8q4+zVyH2Qm4F7Ddazrs0/BUk3ksFtGjcPcBkxD3M8NX8ZTuDXWgMII60bmzn0pq/V8zGnkF10dJmcVuc+Q4k/QDw8IrCGTkblcYxZMZmwZXPWnZWMrHvj85YuC902AuNPftTnOIOXyvKBz/vvz9LE09cK5vmE/FnZjNcxFqaxS98ogWvqShkElQl4sPbQu43ExdsU6u4vUxog4WsikQcdUTZdTXWR8Qb9s5ixK7ai2baLMKtHXVBXf01O94HA95oV5wDCvSFE3VRuP/Lo9T2vOTpEZvKRR3LAuy/qEGnwOLDf6m+8YX3btmkIRHv7EQc9cqudQDcjeuYoPA25XJe6YsssIZxLzz2CjskqdujWwwYdZZ1wmGbB5Y+LeY+qgyMoDaMKlQYWowHakEKzcV1GMqiXHHbY6jVb1bBpzk3bsnWHD/dcl1E08sF4SGo0bpY+7N1rtnu3suIDKR6DYiPN1JhkJE2AkaAnf9sOMBpkb3zm09YnI2vbQgpw8K6UaFjYzDZbWgrWChgpRgiYcaQ8eSJh0C4P7yMDUKQTggZ5AOkjR7LJEmY7MdqY5aQu/JTPKakYcvMkUAyXzRG9L80aQIyaNI6EKIO8GD2Bc4EFinRa8hDSvPukRy1Wbj73nDwrAT9p6CyWC+naPaaM0uynfioDkmeeyepNnebUU7pBJ+gGfQYIhcw5UHpdKY97x9gu45tcEwSe6JAHWGsMmDTKYvcXJkvimvzwYDyVCQ48cJ3DyfWInvT9aNqCv3VC3igHWgVJ2WOAay5jptX8OuKrY6afSg/d9UBz83akxso6QBwhdad4sqcLn7lumwXEUBjs/sAHtAHCugxA4IWhsYEoXlIaAFT3dGQcTJAQMEgmBT74QbOvfz0zeE/Qn5SepRiHDimvwAz+hDB2jJlzAE2A6TwDfGVwPlubUczSYHiA3YsvZh90Jx1Z0jKDhqMv51AZyJ+vd2ucPZPlANww7Cgz5CKV/ARk5Jeuo8tSsr94f/zEwzea5QECT2ay2XSBEHzjKI/MwYa6yGsESFoeZ0aR1ZF6oZegIy0HvtYx0uDFOWVHHPm5BkiLgbjwbqkfgSP6AtjiXhEPmNNeBKa8LufnpC8UAEWahTjhWP0qHSxBG8Dfod23eRrR3jjytI9ARho03gIhNRi6QbwmlsbjEQAANPrwBoOGWc5/+A8zgw6DwEgxXALlsK4MQ0yNijSMVuOWej0qAxyMEiOENzyijOALDWBFPOCFl0iAR6dAGYA2vB0MlRGvEbnhg3cX5QSP4M81dccTDdrIE0c86zyN94/b+OUzwJG1dUR2AnVFLwG2WWz2l3qSL0AqTaO+lEUI3SAzYIpXHSDJg4v7xn0GTNP8nLtOkvzE8ZB49TXOZnmzdpIdbpCXhyd5ijpTdnGaDbTpVh7JBtBx7S4r9ee3BA2/4vE+12O0I6mB4N5edpq3t9lmlkeTK/uWLO2SEEbE+YH9MiA18jRgUBrQ126rmYGTljVma2Lk7CINj2jw5A8jxJDpcmO0kZ7yvqhxP15PAyhjGQdAKSBmke+coLSagK+PrhpgTYBvep7FZn8BQGQgRDf84MGsewjAPPaYLLfNdDN+oRPAiXdkI0/EZxwz3gCDgo/3sQo95A6gi7zFY741PUDHTHVb4JqypEe6x0CFB+IBugBAIl33iicOXYTuAUM8b+5d6DbjkslI3ciPjiJwzQMpDYD8E4+bXm3LPUqBaVFe5c+0kBPCZ0rKYFcOZt/4IA0Pm35tXeQPDKZ9qlBp4EY00HqAYiDZDtAseelTl9LfPFKDGxzMdmLpp5up4K0Or4b1bdoYIIvEe8zbIxtvBmDkcb62DWPBuNNmq3TvurkBJgnQ69OStT17fPzJPagicCALhsf4YBggIJiHmpaW1NbkhokcQU/ek3rDatXobLeRld8hM3yRK5fdDRUgArzDi7v77gwA2Z7+9Km54Om6yusDcLMZgWa8icnWv+kkAABvUrPPHoijDuH5hQzQ6bzlnUc83hT1EmDV8vujjBkv/ubg21YfwC0BVk+DB14uDwHAMXgIc+p6WPj9Y8yPEGnQBAAm/IyJpBxAuT++FpDxUjx/ZKSOAtbZdYCz8uYASKtUvbQG5/Drz9lluYt8o3WZhKFXsGH9mE1sYwxSF1lWz1/9qTSwYA3QfvynV+DUOBt60j/95KP6Fs2dtmrlkD3z1PfstrsekuE29FbUOduyaVRLINSA1cD73jxkMw8/5EWyjRNsHDQAkty7oGkzS+gGSh7i9UD3Zpt7G3M+T5kbdN8TT2ZLPjTG6Fs3qfE7XRgdvGV4GFhT68zw6posZUEO/VhTR7k4uG6oHHXtgKtXzGY2bNTXQPNBeminNZapwLZU8VlMB1hd8xlQ77apOwm/Rj5hQt76bbdlu5pILurvO5xIgOyRoqMApYmHq9lyXzpC/ZSvBWaAAz+FpnRbB1Tl0aY6cr7oD1ryATjUBR3mQwt+B4hXvtA3YAbQ+GcxFe9bWgmUmLVteYWSm09usA7SoQh9Ug68hTl+T/WaYWP37lmZdI8BRZa/QFvP9eJ6VjwAi54pl6VRzuPjH/ehg9qpk75zjKTM2h7HPOQAmF25kGIyqX3YhtUIjh15zTZtPmCTExe9K22NfIwkqKtjpYGFagB70q9WG7br2nT3hUMvCp+W2cSVC/oWzaAad0O2tEw9kCkdtaRERsLMXk0eSu2jj/hnDymSRk579YZOhM4jeDsmDeDCwxB4uKGRR0BAOr9WwPgUah99OAMrDFOvnNVk6J6S0+H5sKSEL63hvbDlEl8hIw/8m4CU0pxzyp/upbyymupWx9jJL8+ORcIEAANQ9WUweDs5MOAR84U5AiI6X9I1vtcqQ9eUzZsvris/F+Dn5bueROw6yesJP/fIlGca3eCBMTlEPHTw1A9Q4ue0pBEkm3uMikduXzucl5WlaSJohZb0UAdASSTulVG29BBlsATK82gdIODC1lrhJfoO1089bbU9e1r5Kbqm3aoa2g7M+YlRSweeqAjkhq/k8YcOmyoQkEPACJ1/0zmL9b8tAESwGa3Ev6YZoX3777TLF8/ZnXd92C6MXdPmDPtswEtTP7upp1wVKg0sVgNYP6ExqR7agN1y2/32+msv6LvAa+2C9p8cXbXBex5qzbJzlqEAWLmn8IF7s0avWBq5N3Q1+rIAAACA/vnEyIOh6jxo59CpK1XTshBAzfeTO3N61gDhARjoiBfEt3x9MgBAzBk5IKrb1TLMKBcAlEfXAGToZr/ySmaUMe6W18UBARo8Gjwe+EoW+PmGo1wzUyvvztOiPop2Xagr6/Ea//J9+MivPIAYgNZ6WBCfywYg13mPljFNAgCXB3i2aCOebiWTIAJ01yN8kIPgICY/S3GuJ8V7Cnl4AAQPHSnFwRPvUQ87ly3nw0JsvNlaTF4FnerFRqi+6aviUh14+fqDx+m6oExAlyM/7SDE94JZRJ2GHAApDuIBu/e+j7hHu2nTZqfftEUTMpef9bj+msSOBpxyqc4rDfSqAdqPftn4nzbqVKM8cOvdPuFbq220HWqrskn1srSKX0MyWYAoadB5bLcDb03QLfNxNAbEew10PQGEA/s13ri9nAqDZCwMwwrjVM66XtVrjaWF8cEBL5GJEwz66DGz//IXzH77f88AI8kXYON8ReOBOhAoi8BY3cc/np3H3+CBx0uI2ezsykEsP51zwPMS1GTgFHzK6CINvQIiAFfIFFwBQPSR6MSTADaNj8YwBfXk54H6xX3Oy/DDm4fNPlWYUKJs8pIh9BJl58cW3zSe/JKptW4xSRPH2UC+eB+Y+qk0VRLQQ0UKZND/7IKIKlQaWKAGaD/x41Tn09NqZ0mj6uuTQTrb3Oj9nCyF64gvO2IsGCJoimH2EsjPxIM8U/e08LYQsFguO5bAk/TwUsSfD3375AllBQ308CUvsjygNYjPPq1dXTQRQSjjD2CQF0+rKDuGz5sNhLQM6kte+LEMpdeg/DV2bek1wJ9JFt/IoHA/kDuGHVJ+yEVXHtpiYNjAv7iWJPAWDDQ8BKCJehLnaxilm3hAJGRzToM2QJv7UJChDQC9OlGYc1NM1BHZQ/44zimxiqg00IMG0raUZ4/uWekTvAeWbVmi4ePN0c3s4C200XCBgTDzGF1TQCjvlnlebAPPQO+4ugHu35/R5Ixm7rknexWO6zY70rUvNha4btO41K/9L9nyjLJ8xBGYmaVsf70ri2r9jfq1InSCkfNzwM+9xjS90znr5TSp0nNAl0xK4QGjrzRQZyaCioF8LCcBwIqBMcAWsGSJjI029bGrgJ4WCfqg7txX3hiZL8Q9YEY8HkAFmjYALKS1X5Y02vYM1VWlgR40UGhHtOd+7UWJ3RLw/ogj2w0FGj9dNb6utrYHbjmo1PWesL4G1rlo8oXXF+Nmee5mPrNaSkwFNanhoPa3//O56xBTImQnP2DLhEsxhGFHfC67AwN17sU7Ch68+sa7zISIy67a/0Yay5GoB/LFwyHSAEeArjDO5nyZaCkCJiVoUqPFJ0pErx/5SFzNHgF4lgXxcGCWe74Qcm3bluXEcw2Zc9qFASBEPbSlnHd1qDQwVwO0H/9lDYme0UltiDqyar1m8Kbt8pXLeud/oz/9o/3OZdJDDA0dg2RcrtDou1Lv3TPrXXQSIAAnjsFQgOWebGrokQcvBDngSRc64oO2eCQfIJPyKuZJr+ENQAAOLFMhUMZ8QXnwusMDny+7r6sDSADnon7cC9UNTfUd9SQOmgghG/HcpzQA4CxgJkQZwQceR45ojPZAlt7L36AtybswAIzGW8Koiqo00JMGwiZZVK//F86ftjdff8Y2bj1omzdusqd/+Nf24EOf862szp07a1s3r9awjzIKNVMjZS1fJ8NliYWnAR4sNwkwyY22jBaxWDoxw7vGOvbBn7ikUvCMz0gm0S05SGPbJv80ZmRAFnX92CHG1ycSn7xiF3Xwz14KDJgZZQZbsOAB2Rsa9/LZS9IkQ+ghzr0+lEvXUbx16msHma32baVEQ4j8fpH/ifoEzzRfpEGX0jJLzlgfn69srXekUOWry+Nm4wfS/Ets0Eou1j/6faEAyRW8ayzKFmiLU7bGUHV3XSgPs+KtQFnSYVP5m089ZdMCW9Z4+nIXys5D6b2VDOzuE2VGXo69ASD6S38ph+q80sBCNEA7Uluu15ZrWGzCLp0/roa+zNcEXtVg/JDG366rWzQyvFKvv66Vw6H1bWrAqYFGcf4ZyqTxRzyGxvq3PmZDMSLG9HQdngnGzBZQZTx9oa8Y8RZUWYDGt48qS1Qc6b71VKSrLEJT44N9Ag7nWjYWpjy+rAQ5CXSzkV80TYE43xTuVi4G7i/9ow91IR06RBN75HWi7aqLXLdt9UE2HiSSjzWRrc9tEk/QAm/WXfoyJOm+RcvaxXxslRl61yP5GUcVALq8eIJ5mW26IF/okUcSS2rIS1yenywRiu0iwJv4IgiW3+XglB4rAEy1UZ0vVgN5O2rMTGh8f4Xdese9durkaRsc0hZImv07eNsDmiBdLdvXd3ADDBZaFoYBLV4DY08FI8H4+JWGTvGlmedGzuEb/PiWB8CxkFBYztKVlHLwLJkgyMGia/4kcY7MSVrbaQAOM70CIH+1LMqKNCZ7dI52nW/Un1f5YsyUuIiPV/CCvq3A5CLPX9PseZNPkC4gdKtfBYALUGSVdQk0AAB6oDuXbYe1TmN+YUcrZRtxHjkXdcRg8DiYlSybSFgU0xsgolIActqtK2MXQMBynMvypgIoyvJGXNAwQQDdzQ6UF+OMxbLo0rKMqBjw9MoCvAi91FPZePVw5tZbM0+6Rxrn3+FPBYAdFFNF3yQN0N7zH6v9aMPT+hRmtGXsgZngGw4w9G/D0t9WBytA4oYZ3wCDqGQvLFjwqzGueQEz5UXXGrqFlJPSz3ceOsTL3JC/ORJxQctMOEtkiqGYL9IXKisPETxpusBLENoBUG2myULDYkga7ZyR4WLe6rrSwHwaiPbUyqeBcsDQO04l7a+Vb4EneEQL6UYukH1ZdsabliwAJBov89ALUACAiwCHGCPrWW66rfqcaZtcIR9vqYQcEUfG9DyjXNxf+CwVL0nQBoDcu359lpBlPqx1bDY0s6SHJwPKHmI7rCW8x4vTQkX1rtUAbcfbj9oZ/7zN6Z1Tf7AzOUHXmNrhHaqxe4hjftnDwSkAj2i7PdCQhTIXC2LQzsrcXmCn+DRXWx66yoDZfF3mlAHeEcpjlpaA/nTdxjdLaf0lrVM68W26CF3qY0rugVFexAXHKDuuS46dykuz9pInzd/LeRnPWQCU3tD1yaOH9aGaITt/7rRm4dbY2QtXbMu6a/m90A3xxtlLcVWeSgMlGqD9+E87hujpqglDe+6ZJ23d5t22cf0aO3L4Ddu0ZY+Gy2Y0pq8BdbKDju4d+qX/wTDbjHM2SWCqWWA1Zn/ZPt4DTozVZ4l1nRoEvLgmjRD8i3kiPinO8wYtx5Qm8kHny0B0TEOUG+m+DAYedPHowis4neSKsov8PZ6MTE6wk7I2kaAU37YrL5cJpSiLrBEWrAvk12QG/PkaX+xoE/yiDPh200XUJeg4Bi1H6MsmwVwXSidPWejEF17QFkMLAHkao/yxc8flBi63S2NnNTt32Nas22zHj75q17fIs12mF7rLyy3yra4rDZRrgPajX80GNMR13V59+WVNXF60q5cv2JmpcfuLr37Jfu7nfklpk1pRcVkPXtb7zWUVjbkIBlz7XnMyzoYWy7qh4EnBhKMCtEGfcoaWeGg4LzMyllEUy4RH0HLsRAvv4jKMlJZzr6qM1XecUd39c5AqM2SeIxMy5/Wr8xYGs97iAh/W4WHyHWmTNJ22hahPqS5yIJmvPt10MZ8eEWZOXfO4TvUJmaHlvBigK4YWAJKA0rZs32dX9Am+Wk37AuoJPDlVs71bd9kIGzM0eP9OM1NVqDSwWA3QyNzKAZiGjYyu0QbLY9poFGOt293ago29AIf4LOa6DeqVaE2Z8pe0Z6VpS6SSBOIwntZnF0tk7bQurkXbpevZiZZioC/zXEKETrQub1ofPEABmHtuImbT09aaumAWR3X1+5Re4zU1JkGiG8pSFRk9PDrSikcnmW6mLuDdTSZkJk8xoCfAczG01JOF0mloASCFsQnDiPZjW7l6g7bo2qaxzGU2xcNz4jnfop/PGGaNN2VRnVcaWIAGcgBsfRZz46itWr05Aw4tV9m4eas8Fta6yoPDmD1ANNcY8sTSQ8t7KEHPVloJZbe0kuxtUd1ou6UFE/J4LTF8fr5RgFKpQy+BSRMBh9ChLXe3sknzcjuATRujwkU3vmTtlB5lFti1LiO9DABbmTqclJVJHLzK0vLZjXZu6Jt92qa1E6+vIFCL9BtDQo/3op1jdVVpoKiBzANk2Cr7LGY2ETI1lbWxzB691RUJF3ZdYtiLMaxeC71h3iEvy0k++nBWbMTNJwTGCvjhPS4gLFbm+ejmS1+AiDeUtZscLQ+wWAJY53oPwIsjGdPzImF1XWmgmwZoO/lPnTZvY/GEhswb6xLgXjcR3hVp+iSFf/84U0pvImO0b/Gyn94Ee+fm6giAc0ROGu6ctCqi0kCvGkjbEUCn67IntGfDoG9CKOsKLVUxS8Y76t6L9xd5WaD8Z18xe+ihBVUnfQAthLBbXbulLaSMpcjbrX4LA8C5kyhLIV/F4/2kgRYAqgusf9h3fBaTc2Y0m9qFvK6FqHyZ0EMHECgDzlDljaR1M975+HZK7xSfytuWp0OdI3/bUXndaWaA/5uPtm08Cs82vm2E2cOnUzrxN0sXncpEPNK6pReq0HZZRhu84pgSLAwAb84DOZWnOn+va6AFgNruSLNyDX2I6+knHrUde++2wb4Ze1rbxT/8yKe1Qci4Pot5QXt1ajuswttJNORYTsJ5aqRcxzIJVJmmcZ3Scp2GYlqRlryUWxYPLTOMHJmhLMsTSz+KaUHLzKfP+oZHp/JIi/pwXkbrumAGmY0/f/Uf+zpIZWyjRfaOtCQWAmWFjkkq0hKXpnMdIerDsZsuyF/kG7SL1UW6HVbKG35l8s4PgP5oQdK8enHML6tDpYEFaYD2o56EfxZTIPfCG7Ofxaxry6SZ6as2dnHMhvTdXZYtBCDIltoChpL+0kTioYv0NI3zSC/GR1ocyVcMgBG8y0JaZpEWYwx5imnwStOK6bM6KPeM/LOa8GfHmU98wpe+iKGLCK9UrqLcabllacRFnmL6O1IXqm/Iy5GA7kMHKSiSNj8AOge4JD/iqlBpYDEaiAcon8Xs12cxb73f3hAIDg2Pyluo2Y6dB/VZjmG1t7peONCHhNS5q+ud3rwtt0qkQUejbkUmJ9Hok6jWadC2Igoni6WFDqODf1mYjy/eUhhtSg/dfLSuC4iUVwKk5PPSdltT10u5bYXlF9B10wXZOukJebw+xZsumvl00Y0WnoB2GnoDQCgqAEz1Vp0vVgN5O8oMRON8Wmu6/+BdWQdDaWvXa7t4hfFx7RK8FOsAFygnci02dKPtlhblZTqZ63VGek/HDqDRiZYyO5Xbi8yd+HaLjzI75Yn0sodBJ5qI7yZzWVoFgKG56vjWaCAepHlpvObLelM8vQiZx8f1bFykvdOPizHat7tO70aZl0pn7b5y0t4cLdVY5zwQF/+AXCqZKz7vdg0UQJDqYIRhiCVOzLu9xpX871ANtHmAgB3bYNEfYTymoe2w9CqmXi7PgZCGS4hjdlX9rTTQuwai7eRHDvFZTNpfbIcV2Xpn/M7IWdbNemdIVklRpoFZAFSLY+x0Qh+m6dMrNZcvj9kKbatz5eq0rdJ3W7U3QgZ879aWWVb7Ku6t10CrHWUNKT6LOTy6zgZ1cfbMOe1ApM9i4gYmPZK3XtDFlRhe7OKoK6q3WgMtAKQ5AoCvv/SkHsMD8gSbdvHCOVuxcr2N2TG77aA+rt6vnWAqAHyr79F7q7wAQNBN/y9o38lDrz1t23bdqe2bxu273/+2ffpzP6cvw13VnpTnbNsW1gGChLMND5DptN6LNGb6whOLYygxpY24OJIWa8WgK9KSj/Sy+KCNpSFpHtK4TnlHmRxDJmYp+RVp4Rmzl2laSkt8lBO8uZ5PFyFT0MQR2kiDd7Fc8s2nC3iU1QdeKe8okyM03NtOuuiFljzwSWWGX5SZltcCwKyB1Wzz1p125uwpdXtZ7wSTmo2uHLZhtsNiR+jZdpjyqc4rDfSmgRwA/bOY1/VZzLPZZzEnr+nhqqUxK0dHtAh6wrfDYkPePn0ys66HMQ26GDotGwnA6LTNE4ZBWhnPiOu0NIT0TnyRj/Qy2jDGbrRh9MV6QovxdqN9O3SBnMu6bLzQTRfz6bGbLuajLeoC/YUsRRBsASAZpGNbuWqjja7epC7wRVuxb1ib0k7byr7D+ggxtWV91oXi/amuKw30roEcAP2zmMv1Wczb9VnMU/os5vJhAUfdVq3ZaqtWjt7YZzHnkYa2zu9mhG58u6XdDFl65blYubrRkdYtvVfZliJfNzlaAEhBAkp90S77nsC69RvkPuv7x8K8yXNKyBvuQj3AZnNEitAHnk37Hr0bB3VQTBWWTgPRjtQWip/FpP0N6YPbHMlWhUoDN1sDbQDIQ5HGR/BPFaoZTk9rYJC49Oc55v/TNA1m92uL/Zm14qutxE1b6mffgJ+fuMrx3tRA0o4yLyH9LCbjP9rJWSsQbo5/9t5UaVWrxWugDQDTx667jULDVk8habjzF6fmq2njWu24nT37o7Z65de1waowdOb/b+/MYuQ4zjv+zd73cknukisuubwvkaapW9QZS45lKIkgO3AC+CGIX5LHBMhDgCBPeQnyFPgpRgIDCfIUI05gI47hIDEs65ZFipQpUhIp3uRyySW59+zO7kx+/+qpmZ5mz7Vc0lqxi5yt7qrvqq+qvv7q6K4eGrY+qa+9Nkm4LzUQ246YZKdleKPnH8IrUT9+rm8lye7nyFaSzMsla+2WSA1XwcfB3e1/yc/lBjCAC/aDn/7A+p/5H/ur7x7j1aZNGMQJ8nSuSBLuaw24NhSs0umyqZkzK3SGL6GZY1m1G0GhOHfjTWOQXsvfIm4t0EWYpeKJgnDL4ZdLL3IOlzeceufXlXjfqcxLka6SPJ5eLTAettY4jmZ9BtAbP8VlfrlcO1toLtn4xA771l+8bLu3NtnffX+/nTj9J7R00LKry+KWo5mkl9f3ytVN8VjMk8cP283xCcvMTdkHR95i7ykf9iSEj8WUl6Kf39bh78Np4Tx/7eMonE8vF4fhPa8obFx6FCZ6H6Xr88PpSvO/cHqla+WF88vRjYPzsOXiMN0wfpyMYRrh6zANnx5OK3fteXgcH5eDV7r/eVjFCj52N/k/pUPgcE70Omzwonmh+5RxLunieuvp+NT+9s+O2V/+/eP25Jev2vDga0z28JTTENgb0hBecnmfaCDfjsLHYs6lJ238xoj1btpqszMz1trSblNsxJ+ammJnQoaGK8+qVD9+O0PcU903fA9Tihl0BOXF4ZbD8TTK4SlffONoKk+dshKu8nzHFXw41IIr+Djed6ILjxuWJXytfP3igtLj5BFstfJ4voKLhmq4vv7CvD2dOFlrN4BOckkfFSl6r02oU8ZHfe3Pv/2EvfTUX9vQwJu2pu9/LZdZi1JuQKN2xzNKPblf4RrIG0A9Ct2xmN0ci8n3/1I0mHHOot60Zbe1sRFhfr6DIzHWBvsAaUsR++eUUG5fnO9AcfvxvPbK4Wr/mTrMUnDV6fQTjbigvHJ8PZ7iaJA8lXAFH9375mnciS7uBFfy+jJ5WcKxdFROxx5PcTRU00UlXOlem6zDoTYD6Butj8MUYq5TNsOCR6e1NC3YgT1/g0eIzcv0o5BrXNTGMoZskvRF0ED+AVo4FrOfYzH7dCymjEbOVtExdFKcQuFzWPIEKnSGALr0r3/ql6YGd0vNi6MVTrsTusLVL67Th3ks5bqaXOX4VsKTHEvNF14lXJ+/FF3E0VWaaMXl1W6NvPHLN+DKFcG7w5aGYYvl0kMw56B1G0uMX2Wl3R+5hXaU3wc4r1cw82d/OK8weCUzePbf7gEsh5KW0rFq5Xs3adcqQ71wS5W5Gl61/HrlXCp8JTmqGsCCvfMXimtql7jAbH5OpUbycscPC5ZaqARvBWsgbwTVQuTY5Tjzo1IjXcElTUT/nGugsgGkdboG6lxWShI2gp/zgiXifU41kDd+YeluM37AODDa3d0IcUOh5eJzN2kvl4xROn6IGE2vdl+trNXyq9FfrvxK5Ss1gPLsaHMyem7FhA8iZNm70sQuZue/JR9DWK46uX/pOMumdsYQmH9qa4VjMUnO6hPRzAPe98di1tlCbnuI5PGVXi5PIJXylVfJiFWi62nnxSiJKvH0eNVolxAM3cTR9rR8HAIvPRRJhW3gNaSJG1ft+EdH7YENG23s1rQN9c7aTJdZVxMTNlr1lqFMQqKBpWigYAD1yaPisZhDHIvZwdtCb73zuj33lVdYBZ4NHYsZPJTD7OK2O/h8PbzdA9wnROJKuD4vguJu1T8q5WuFUZ0sbnXT48Z1QhEPfwIqyrsarpcpjvbd0oVkFN84nuE8yR4NvjzRdH9/J7oQruiH5dK96sTryfNRXOoBkiDbpjMacuy/OnP+MxtYv4nGeM2aNU/tPgmjmF8SEg0sRQNqOzxEC8dinj7J5yebbG5mnG2iCzYxcc1mZqesrbnFbRnx21LkKYaDGrj/hdN1rXThhTtBGMbnh9P8tcfxsU9XrDQZlHJ5nmdcvsevllctPyyPvxaO//k0H/v0anTj8n2ajz1NHys9Lk9pXk9x+cIvhxvOWy5cz0tx1CDfZgB1BnV7R7et37DNOtrbbIp9zQOrNhkPZwwfHwVMjJ80kYSlasC3H38s5p7gWMy29i5r5P3xgwefto62dtrZyjsW0xtAxXFBna9cntLL7eUTXjVczzuOrzp+Nb5xeEqrhW8crpenHF/hlMuTHjx+lHY1XVTCFc3oyKDEADoLydNZjXHb9t0Bbzy/uasfupFvQzIHGK2P5L5eDcgA8lND1t6/Jj6ouX0Xx2JqaoWwdmDQxcmxmE4Ny/JHui4XvEFR34+GSniCrZYfpefvPU9/H419fpxMUdjofSWZ4vJKDKD37gQYbJimVeaCPVrJmSBRVSf3S9JA3gB6XPXNhQVZv2IHTI7F9Nq5N/FSDI0kWyrevSlVbVxKDWABR2N7buTx+XbpG275h0kBO7lINFBWA2Xake9MevjGOCNlySUZiQbuRAPxkxWVKCYGsJJ2krxyGoi2m/y9Ih2L6YweD1sdi+mGyOXofM7T44ZZn3OR72vxyniAEZ2olfqfsvKNNwKV3CYaqKwB34ZczB8ZPGZYRkauWFcPHz7g8KOb4+Om4xg08FhpnqC8WO/JVlbE5yd3pcm73JqrzQCKa7jxLrcUCb37RwO+HeXnVtyxmJ8dswc2PmgtDQt2+Mgb9uihl1kRbrQxjsV8IHQsZrizxu338krUSp/3xIIhtcxpMVTC9XvFPH4Riy7A8NznR9Mlm98XF7e6WQ23lr1vYZ7h60rlCesijOOvK+H6sq50XUj+mvcBesVEY01WF4xgNDO5TzRQqwby7SiVanObnSeuXaZxNtsce/8aO9osPasDtFLWxolxq1b1urxUSh9P1WeqAibyDHNsk9EpcsHRrcV0XWH/3HYHDa2FE/UkhRsMu7UvLMDVX8GlWO1TWhOuqe/4Hj+gpc6UH7LnUYN0Gdlgj6DyFTztQF4x0nGcpbNOAW64PKX5opPV3rQ8bilNX7ZAF+4BAaigvcxRXYiegs/XsbdeF0GOZAnyo7oo4hQgK+gi2IzsdVHAkHB5Q+L16Pn5mA0yrr6LdV70rP3+wnKfFRP16HYi1aN0E2cEa/YAk1VgqTYJy6IBddLsrLW0lB6LqZfjnvvKN6y3t9dmZ+dosOwHJPivxYQ7YFNTi+vExU4TlqzUQIVzdJ1KBbjBdWlu8FmuIM17nJ5HwL+I6zG9XKLLFrZC8Ok+Qd88jAYP09DQQjmjucG9YDyuh/cyBRAtRUTBFu+4KerC45Zkp1qdHkvT8nfg5k8qIKFI1dNpZrN6NPg8Dje4ja5gfb7KU7wOqPh7s6IuimkepihHkFL9r6/HOMiaDaAULsPt4jhKSVqigRo04DquOrreBWbzn779t2btQKFdqcHLa0mlmmx8/Ij1dC/Y/BydGNuRYVP+PPCrOVVhdDTLftUG6+bY1uvXtXmfbkN/lLPU1KiharDpWEZFW7q8YRL9hQyeGl6a5h/n9AFz+LWCq84+n8FLa8ZjwEtc4DuWkq8DHovQkOyNjVnw8bjoOaKtfB+nUlnO005xuHvKmslP48zqS1+irTO3HS6nLPJdThdcWUnXpxDn59DFYsq6OgOvVDLrzHHpYpFCqUzyXOeRV/BtvJMwz5upoiWvaHGxwXSiLS9w2RzpyhdPddpgCAgS8o+MmK1Cf7zj4OTWFiQZfenH923hifcCupibz3FUboMrT7A1LqDLN2zxd7M20A9dgnQgPOlQ+gzKKq9Lb4V43QV1IVva2KC6b3ByKl+6FqXxSdVvli+D8y0pdNXZkQHmUevqQmgVYJlDvirKU5XnN4tkJ2gE7mS35ZehPPMk5wunAXUyGYdLdMAm9QT+uyNYiRUCI6NO02g9vf+JN/hd+973zF79fbPjx8xmMAzDG8G/SEdeY9ZPv/jwQ7MHNpk98WhgMNQ5u7ohRseamqFDATdNx5JxzNLRulcRYyTmoMXo2i5cNnvkIJ1vnLeeOM/r1k0MBPi3+H7vKJ+x3NkLHMaFN/bs1gQ8gZnmZAecVFu7VkKbvf8rygE/pi1dp37hBbNrV6GNnNgte+jLZjf4GHp/v9kEfJzRQ4YeaB//NffQHlwHDwzPHEZMcGMY9lac4E5+Y+CK19HD5D0APGz5YLbNTrtiWjfv6l9H3k766ScnzfZRntVcK0inMrb/9zNgMXRXkOvppwOdcAa9MzwT6Ef1opse0lSOVejp03fMDj6O3qe479PDBX1TDxcwpN3o5CpwT6H3CfI528qOUBfPPktZSZd8afQvwyxDPXrJ7IfI8Kd/TDneM7uIHl56zuwf/tHsD79tdv5js5On0dXDwFInVyjPk0+hg9aPEIyKvgtBRS4bqE/jYWjTFPoIymjXE4n7uoLg8427LrwE+IupAdpDA+1omo77RKFt6ILe40IwB6eUpoZV9iEdvq1nv127Mm1rN5ht6k/ZP/1Lzn7nFTrIebMfv42B2iGPQsgpO3s6Zz/5b7OvvoSHxNlKH3xgtm0PHYoOOwdPeW7rBjF2GLI2PDOatnEEif30J2Y3MQI7NtM5j+bs8adTrr2PjZr927tmjx+is9Mpz17M2d49KWcAtU32EHBpOvJUOmfPq+PTaX/+WiDL7EzOLlwIDOD4DTr8pZzt2J2yM5/BZwvyXwmMQ3oeo4NxSWNEpBepQo7HNWitxSiiLvv4VM6+9lKQIZ3cBPbhA8hK+Rh522YeCiMYtu3oYg224uw5s/17UxwzkLPWNhnllK1em7MRaG7ahLG8mrK33spZL7CalhQv9W0ZXulkCu+VmQgWpszeQ8enkXkY2s8/hYcKoIxqBrn1oDl5wuwYhk+e+TQG7603kPfjnO2G/9CGlA1Sb4vAvvtezgYf0AMgZcdOZG0LusDXtnXINTOFTqH76jdT9s/fz9pTzzbY7p0dHKb2oT3+WEUzJWVXDH4OMA6oImVNUragjQx7s36JAVzd1GOLuaGATjWjphZMyDXwxQg9AmUFlVYNzyHpTwQ3SKr8N89TrYfzw4hUlYQ6eN4prnsei28tPAPp8nqRzMHQy+HWoascQy/HTnqumy8rplLREnBzuE+8ZYr8eaaVeOfLk8o220LLDWsfb7ZDGA11umZch2C4Jk8hGDLJY5iko5y/hPcxmbULlxaN3TF2bSxljzycszEM2gjGae0as710tBPHoPUwRovOPjiYs89OBcO8Tjyj02fNDuynZjCI3X0YoI9y1rU2Zfu3mv3Xj3IYhsDTG6JpTwKzmfTT4PdjfLZtSSFHzk7hnVzFwGzbRec+jtHF+OzepoPcMazgdGIs5I39+3/k7BvfChQxNZkzpjmtrxOv7BPkgv4ljOiufaRhkC5eztkkhnFoG7Ii53uvmT3zImVApf/6g5z90XdSdvl8zmQg11H299/P2vbtwENnGvl+9Q6GBdgNLs/s5VcYfmPMZcwyGEiFX2F0tu1K2WaMnjGM3r8vZW+8Hhg+GbiRi2brKe+jj6bsFvK2I/qHv07Zb32d+HDOZjPAoOt+HhryetXANL3Qj84unQm80QnKoOnAGeQcRrbTlFW6m0YvGza6FmLn4HMT+umbZm8jt4bYR47iiT6GbBuZsuDgK4wLXi9l6AaOtnHjVtZaqM9iowZG/+XOlgnKi+b7ex+HUWlmtwdZTDXEqyPnjJMKLb1+wX5IBVnTsaCz3o5SPoUngtEIJHjdYam46mwo32h4dYcsGHP8JLPo1BMYThmNoG5c6UZ4wqcB18VXuMHCKWOFe4yr+qEhu1+tuhIcneXh1tP2nXSjmx87c+q0rR7YZKnFWTtz9rTt3P0lN8/W1DNqL/8u3sXR4zY0TMc6gWdDZzuIMfs1HseBgxgVOv8beBxbMAzYAjfnJq9Ew94MetFwbgPeleYKc8iqeULRevMwXs4YQ6ynaZogDk3gvfHbtoWh2DkIEQbo5F20+1b0OoiHtWOn2RnyXngJb+6M2S9+yfWLVDf8ZvCQTnyEYYPv5Qt4YTgMPfyG4TlxK5D12nW8sgcDY5GjvkV3/Xo8LfBHMVovYnQuQJ+pQPvmqwhAW5Q3J69wkTaZWcAQYljGoSPc/V9iqHqVoTfwr/weHtZb8EPGDPDdyKHwwlchozaN3pl2syNHgnJoOC9jvBV4ySx6PcC0t1AejM6Pf4RuHiMd+bdhoKki20KsoGF7L7p5aJ/Za68DAw4L9raOsmjI+yD1cvki8Oj5NA+Ooc1mG/l9CyN6DB0dJH8KnZy5JGp0U8qv4XYW3Deh99tfQw/o99OzeNiH0O1M2k0NZPmABiJigFUgCnBbR9EDSZ/D0gILSvH5IDXgzC0uzJOn9GJI5XKLuWPHx2xusd+5wmKgHxsI7OTJo7i5GWtZ1WqN67NMdDZBQLm1BckwxaxmBxMUcda3EhVNzM5OTltrZ1vduLK26alp5nE6nKteiU84TzIuMKs9n56zzp5uN7kczq90LdxFZnIzzKq3dXUyTFAl1RaEm2FGO8skUisTPvXgaqvAHFtHUsQttERNiNcahDPHGbyqp5b2+vgKVzpuYtJKHzSouV3QfhqZbBq/esOGW3daAxPLpz45Zlt3PWKZySt2GZdkaHgfXkC3zaVP80WihcJEOixdkLzyGBXrpwbr59TcPDV5LBKjxwBOE/ya+wsewvIwF+zchTHbumUdScFwToTVrzQPtoDXo6Gy8F1/4I/uZZA0We+uxbMgR6OdPTPCXsZe62C8OTevfYjAwdfL7OhLLuhIFqWLnzsORUwIoue7V5F2ACtPU8Zbiy4eTl6U0j2vLJ27MZWxT0/dsI3D6+nD+i5iAC/6WhjxizbiL1y3+AGMPHEFeePnzoxaz5oeW93ThtFVv0dWYCWr8H0ZZEv8Ao9kEJxiVYnqR/Di75uk5Baul0G8tZCjcghe9+EgeM0PLyysAY/26b+YAZDy4kJYfz4/kI0De1kd2rebOnnq6YkAAAh8SURBVOLDkzKibmgcawDBkAd49tQJm6BzbRnebj3MCquAtQbpU0LOs4okWlodqieokUzNTNMROoN2WysyfLQSlp5LW2cXNZ6v2JrRJXO+ksuJHKdk0ZfMaWq0Q4/RGoPEk27UKDK0yI52PhKab0Q1krCZadwDKqdDk7Q1Bs83nQ4+TKrO5ctVjUTQoOSZpPEc2lyjrhkX4irv6PUxJv4XMZ7tGDpOEWSZd4HJtMtXLtuuPY/gebUHnUeC6pePVCe69XXjrxWLrpcjj+LgPAwghaDOpk7n8woxF2q3/t4j6F4hzL8AQ6LmIAv0uHdwAHiYaBxQK+br3sMUrvPMfLqPfb5HyIMVZNNChYxOGF44vl0pXSGMF6QEOB7fG09PR3FBx0ImSN/5ywK/MLzL449ipTv4PIKuS+gJIBQcHeHy8/WqbE8rBFq4LJcnGpn5Rdu7Y9Ha8Xa1su5GugXM0IXzZmgcw8wez0zetBMn3mXlabtt2jiMNS7/FVhPwgmOmDlmPt89/LodeOgZXOtmKkBTnpWDUwqtKT07YcdPvm0bt36Z1bEBDEQNfKVQDMH03Ji9f/gNe+jRF627o4PC5ufIKrAWX815To1fsyOMr5469BW0TisKhaBCilsGtFNeaaqdFsYUJ0++Y2OTaXviied4YvLIpLT6tLt7clED0qt76oRpQqAJvoc/+JktNHYzv/UkegrkdfxCsNFL5UvmK9c/tsvXbtmTTzyL9xLoqRKu8pxseAivvf1DWzO4yw7sPVCbjsHUcGKOGfvDR39uawd32M5tu533q/JVCtKxNt0eOfKmNbA0uHP7g9bOpF2mo0sqJKxh0n+LK5NfGZaH5huNp+5jYfjrQpy/8PdhGF37IGMlcT1cIc5f+HsPH7731z4WTJSe0mLpKyMUwjRir0n06T4WeiPtXPS1SdptDs7TFMwiY+gw73yWMza6DtMJX/s8Xxbv8HiYQuwvRCt8LQIEn+TjIDVIL4HPAxTSIgiFW1xN/aOjeVIFHoWE0EUBryRNqVS6oyFPLqAlxz42uI6KZDqvQcPRRVwUkdCUZiBMLJpLdKLKKDS3Wl/vGgwhbrRKGRl/x1Ng/xYZOdypufQiy/s94EvRjOvjEQqp6ixaPWtubLFWai89M2OrujrwzNQgqmEzNIPx1UtnbYQ9FprobSYh6JgBCz2tMmzEmmS2uxEe3T18xBMcPSm1ktbD+6zXr3/KQ2Pa+pj5VkOa56nTwkqS6GWYxGl2w8WCyK5VSD9Zxl3ZbNoNg9W4VT3VJJZw4ssuLduxfZ/Tm6+fSrjKkzo03E+xJ25xVnMj4ldb3Tods5Q7z/B5kuVUtnphSqvjqtFJh2tWDzDBPUYds6cuP4Tz9RM8JCSfpFTwcXC3XH8L5JeJ4HLTqybW1OQEw/FFhnPd7IFkakoen+oQdblnbzUCFfLvdVkqiBLJutO2IHz1LP2CUNYAqgGqA+sl9YF1G62PPQiBgmsTwuFTKRs3bmUiVXNEnmVtsZ5qg8xWNzHhItSauAKkyhPu0PAe62PHp+Yuip2pPG/BqOFs3f2IDWzY4TpqqcyBFLlsBo/4HSZtB62LHbIzDNN7Vq2FD8NQpBwYWM92hHM2yuS0/N221g4M+ay14unMM7Ye3rwDuFCJYKJNuTv2PG5pDKQ8ulK+1WXuXTNIJ+hx8tdSVlEUj6amNtv7pUPW3MYsNPe1NnzhNjLJtnvvY5R9wD0AauEr+mpT/euGRCDwzPN1Vr6USU5YA27YxpTS2OgZ9uJdYU/kTjZHawqhwXpZdZlmxWRo0/bA4QgjJtexGohdBIlC+klPzSHUG+RGu6dTHYiqZO0g1zyN9xDqQHcT4vLM3O79ehDzsJJZXl00SK7m5pSdO/8Jntq8XbxwHsO2BiN4k20OH9gzz79q6/pW2WV2fM5ytoUMxcxsljcJ2tmg2svwvNk2M1xsYaZdeeEgnt5AhNNruS4nby24mtBX/cSVtxq+axd14jodtqTsOk+IVnb5duLhB++6YgmTUFUDzgDSBidvjrJJe9RmWGIeZzGqjbnYkZEzNsNz+KWv/wGr3u3uYVPrQ60q4xUOID3IAdm7I8scICNaGrzTpcqlTNf8FEc6pvL1SowA3FM+Jl8wsQEc37gd/Vig2xNTjJOEp2Gjht+uEmvlCyNt1GQqzMlbD18viXjHDvMRRB7M6r71Tnl9qzfgRbUi6yLzWbt5w4BXuhZm2YvWwXaKZzDe86wIzrP61mkL7Ccau3WLVTMWOaL0C3q6dzr2ZV1klU2h7roFZ0ntwtUPdcQTQDxd3Yq/hEhCdQ2gMC22teC19/ezcsXILMVyq6aYtm/fw9sp87w5ohVT1WmiVylULdzpotDIisbEDYEXMDRa3lcoZgX3wV+12vB9PdcFrvUgASu8pfLN87xLMre1sbkMFuLiPDkuOtl8Ji8qm+2wDW19jPB455NdsO3af4YcLS2dbI8ZCDxahxlVR17maHJN979B3Dp17PWVwfA25dud5mhjVVJT2e9PoAa2hXSwgh4ObcwH8hqya2Ph9OSafkk7lY1z7S/ouU4tGEC9UE7PnRrFm9EqZaKu6hoIKSlve+R1Nuoxw9Cd9RqeF3kYRYJROlGQnkeqzugLCKGPFDTa6t407W2R90dZgOFNlsQC1lvVoTboUUmSZ92q+Z8klGjAdc1mtl019vme6fKZA/QmT40wCYkG7pUG1EnViWM68r0SIeFzH2pAW7jmmDbQNFvWvU+SV0Ly1LgPW8NvrMgye4FPfD97w78x9d+XjIM25xpeofxuDrDgBBaSk4tEA3dfA4nvd/d1nHCIaEBj4VBwBrCWPVwhnOQy0UCigUQDK1cDBVeQvbAqxQxvTMyzXSMxhCu3ThPJEw0kGqiuAX1kI7zl6/8BcLHMQ/5H0gsAAAAASUVORK5CYII=";
