/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.util.ArrayList;
import java.util.List;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.tools.DatasetCurveFitter;
import org.opensourcephysics.tools.FitFunctionPanel;
import org.opensourcephysics.tools.FunctionEditor;
import org.opensourcephysics.tools.ParamEditor;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.UserFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserFunctionEditor
extends FunctionEditor {
    private UserFunction[] mainFunctions = new UserFunction[0];
    private String[] defaultVariableNames = new String[]{"x"};
    protected boolean parametersValid = true;

    public UserFunction[] getMainFunctions() {
        return this.mainFunctions;
    }

    public void setMainFunctions(UserFunction[] userFunctionArray) {
        UserFunction userFunction;
        UserFunction[] userFunctionArray2;
        UserFunction[] userFunctionArray3 = userFunctionArray2 = this.getMainFunctions();
        int n = userFunctionArray2.length;
        int n2 = 0;
        while (n2 < n) {
            userFunction = userFunctionArray3[n2];
            this.objects.remove(userFunction);
            ++n2;
        }
        userFunctionArray3 = userFunctionArray;
        n = userFunctionArray.length;
        n2 = 0;
        while (n2 < n) {
            userFunction = userFunctionArray3[n2];
            this.addObject(userFunction, false);
            ++n2;
        }
        this.mainFunctions = userFunctionArray;
        this.setDefaultVariables(userFunctionArray[0].getIndependentVariables());
    }

    public UserFunction[] getSupportFunctions() {
        ArrayList arrayList = new ArrayList();
        for (Object e : this.objects) {
            if (this.isMainFunction(e)) continue;
            arrayList.add(e);
        }
        return arrayList.toArray(new UserFunction[0]);
    }

    @Override
    public String getName(Object object) {
        return object == null ? null : ((UserFunction)object).getName();
    }

    @Override
    public String getExpression(Object object) {
        return object == null ? null : ((UserFunction)object).getInputString();
    }

    @Override
    public boolean isNameEditable(Object object) {
        return ((UserFunction)object).isNameEditable();
    }

    @Override
    public boolean isExpressionEditable(Object object) {
        return true;
    }

    @Override
    public void evaluateAll() {
        super.evaluateAll();
        ParamEditor paramEditor = this.getParamEditor();
        if (!this.parametersValid && paramEditor != null) {
            paramEditor.evaluateAll();
        }
        int n = 0;
        while (n < this.evaluate.size()) {
            UserFunction userFunction = (UserFunction)this.evaluate.get(n);
            if (!this.parametersValid && paramEditor != null) {
                userFunction.setParameters(paramEditor.getNames(), paramEditor.getValues());
            }
            userFunction.setExpression(userFunction.getInputString(), userFunction.getIndependentVariables());
            ++n;
        }
        this.parametersValid = true;
    }

    @Override
    public Object addObject(Object object, int n, boolean bl, boolean bl2) {
        if ((object = super.addObject(object, n, bl, bl2)) != null) {
            this.firePropertyChange("function", null, object);
        }
        return object;
    }

    @Override
    public Object removeObject(Object object, boolean bl) {
        if ((object = super.removeObject(object, bl)) != null) {
            this.firePropertyChange("function", object, null);
        }
        return object;
    }

    @Override
    public String getTooltip(Object object) {
        return object == null ? null : ((UserFunction)object).getDescription();
    }

    @Override
    protected boolean isImportant(Object object) {
        int n = 0;
        while (n < this.mainFunctions.length) {
            if (this.mainFunctions[n] == object) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    protected void setReferences(Object object, List<Object> list) {
        UserFunction userFunction = (UserFunction)object;
        UserFunction[] userFunctionArray = list.toArray(new UserFunction[0]);
        userFunction.setReferences(userFunctionArray);
    }

    protected void setDefaultVariables(String[] stringArray) {
        this.defaultVariableNames = stringArray;
    }

    @Override
    protected boolean isDisallowedName(Object object, String string) {
        Object object2;
        boolean bl = super.isDisallowedName(object, string);
        if (object != null) {
            object2 = ((UserFunction)object).getIndependentVariable();
            boolean bl2 = bl = bl || ((String)object2).equals(string);
        }
        if (bl) {
            return true;
        }
        if (this.functionPanel instanceof FitFunctionPanel) {
            object2 = (FitFunctionPanel)this.functionPanel;
            if (((FitFunctionPanel)object2).functionTool != null && ((FitFunctionPanel)object2).functionTool != null) {
                String string2 = ((FitFunctionPanel)object2).functionTool.getUniqueName(string);
                bl = !string.equals(string2);
                for (DatasetCurveFitter datasetCurveFitter : ((FitFunctionPanel)object2).functionTool.curveFitters) {
                    if (bl) {
                        return true;
                    }
                    bl = datasetCurveFitter.allFitsMap.keySet().contains(string);
                }
            }
        }
        return bl;
    }

    @Override
    protected String getVariablesString() {
        int n;
        Object object;
        StringBuffer stringBuffer = new StringBuffer(" ");
        int n2 = stringBuffer.length();
        boolean bl = true;
        UserFunction userFunction = (UserFunction)this.getSelectedObject();
        if (userFunction != null) {
            object = userFunction.getIndependentVariables();
            n = 0;
            while (n < ((String[])object).length) {
                if (!bl) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append((String)object[n]);
                bl = false;
                ++n;
            }
        }
        object = new ArrayList();
        object.add(this.getName(this.getSelectedObject()));
        n = 0;
        while (n < this.mainFunctions.length) {
            object.add(this.getName(this.mainFunctions[n]));
            ++n;
        }
        n = 0;
        while (n < this.names.length) {
            if (!object.contains(this.names[n])) {
                if (!bl) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.names[n]);
                bl = false;
            }
            ++n;
        }
        String[] stringArray = this.paramEditor.getNames();
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (!bl) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray[n3]);
            bl = false;
            ++n3;
        }
        if (stringBuffer.length() == n2) {
            return ToolsRes.getString("FunctionPanel.Instructions.Help");
        }
        return String.valueOf(ToolsRes.getString("FunctionPanel.Instructions.ValueCell")) + ":" + stringBuffer.toString();
    }

    @Override
    protected boolean isInvalidExpression(Object object) {
        UserFunction userFunction = (UserFunction)object;
        return !userFunction.getExpression().equals(userFunction.getInputString());
    }

    @Override
    protected Object createObject(String string, String string2, Object object) {
        UserFunction userFunction = (UserFunction)object;
        if (userFunction != null && userFunction.getName().equals(string) && userFunction.getInputString().equals(string2)) {
            return userFunction;
        }
        if (userFunction == null) {
            userFunction = new UserFunction(string);
            userFunction.setParameters(this.paramEditor.getNames(), this.paramEditor.getValues());
            userFunction.setExpression(string2, this.defaultVariableNames);
        } else if (!userFunction.getName().equals(string)) {
            userFunction.setNameEditable(true);
            userFunction.setName(string);
        } else {
            userFunction.setParameters(this.paramEditor.getNames(), this.paramEditor.getValues());
            userFunction.setExpression(string2, userFunction.getIndependentVariables());
        }
        return userFunction;
    }

    private boolean isMainFunction(Object object) {
        int n = 0;
        while (n < this.mainFunctions.length) {
            if (object == this.mainFunctions[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            UserFunctionEditor userFunctionEditor = (UserFunctionEditor)object;
            UserFunction[] userFunctionArray = userFunctionEditor.getMainFunctions();
            xMLControl.setValue("main_functions", userFunctionArray);
            userFunctionArray = userFunctionEditor.getSupportFunctions();
            if (userFunctionArray.length > 0) {
                xMLControl.setValue("support_functions", userFunctionArray);
            }
        }

        public Object createObject(XMLControl xMLControl) {
            return new UserFunctionEditor();
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            UserFunctionEditor userFunctionEditor = (UserFunctionEditor)object;
            UserFunction[] userFunctionArray = (UserFunction[])xMLControl.getObject("main_functions");
            userFunctionEditor.setMainFunctions(userFunctionArray);
            int n = userFunctionArray.length;
            userFunctionArray = (UserFunction[])xMLControl.getObject("support_functions");
            if (userFunctionArray != null) {
                int n2 = 0;
                while (n2 < userFunctionArray.length) {
                    userFunctionEditor.addObject(userFunctionArray[n2], n + n2, false, false);
                    ++n2;
                }
            }
            return object;
        }
    }
}

