/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.simple3d;

import java.awt.Graphics2D;
import org.opensourcephysics.drawing3d.DrawingPanel3D;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.ElementPolygon;
import org.opensourcephysics.drawing3d.simple3d.Object3D;
import org.opensourcephysics.drawing3d.simple3d.SimpleElement;

public class SimpleElementPolygon
extends SimpleElement {
    private ElementPolygon polygon;
    private int[] aPoints = null;
    private int[] bPoints = null;
    private double[][] transformedCoordinates = new double[0][0];
    private double[] center = new double[3];
    private double[] pixel = new double[3];
    private Object3D[] closedObject = new Object3D[]{new Object3D(this, -1)};

    public SimpleElementPolygon(ElementPolygon elementPolygon) {
        super(elementPolygon);
        this.polygon = elementPolygon;
    }

    public void processChanges(int n, int n2) {
        if ((n2 & 0x136) != 0) {
            this.transformPoints();
            this.projectPoints();
        } else if ((n2 & 0x40) != 0) {
            this.projectPoints();
        }
    }

    public Object3D[] getObjects3D() {
        if (this.polygon.isClosed() && this.style.isDrawingFill()) {
            return this.closedObject;
        }
        return this.objects;
    }

    public void draw(Graphics2D graphics2D, int n) {
        DrawingPanel3D drawingPanel3D = this.element.getPanel();
        if (n < 0) {
            if (this.style.isDrawingFill()) {
                graphics2D.setPaint(drawingPanel3D.projectPaint(this.style.getFillColor(), this.closedObject[0].getDistance()));
                graphics2D.fillPolygon(this.aPoints, this.bPoints, this.aPoints.length);
            }
            if (this.style.isDrawingLines()) {
                graphics2D.setStroke(this.style.getLineStroke());
                graphics2D.setColor(drawingPanel3D.projectColor(this.style.getLineColor(), this.closedObject[0].getDistance()));
                int n2 = this.aPoints.length - 1;
                int n3 = 0;
                while (n3 < n2) {
                    graphics2D.drawLine(this.aPoints[n3], this.bPoints[n3], this.aPoints[n3 + 1], this.bPoints[n3 + 1]);
                    ++n3;
                }
                graphics2D.drawLine(this.aPoints[n2], this.bPoints[n2], this.aPoints[0], this.bPoints[0]);
            }
            return;
        }
        graphics2D.setStroke(this.style.getLineStroke());
        graphics2D.setColor(drawingPanel3D.projectColor(this.style.getLineColor(), this.objects[n].getDistance()));
        int n4 = this.aPoints.length - 1;
        if (n < n4) {
            graphics2D.drawLine(this.aPoints[n], this.bPoints[n], this.aPoints[n + 1], this.bPoints[n + 1]);
        } else {
            graphics2D.drawLine(this.aPoints[n4], this.bPoints[n4], this.aPoints[0], this.bPoints[0]);
        }
    }

    public void drawQuickly(Graphics2D graphics2D) {
        graphics2D.setStroke(this.style.getLineStroke());
        graphics2D.setColor(this.style.getLineColor());
        graphics2D.drawPolyline(this.aPoints, this.bPoints, this.aPoints.length);
        if (this.polygon.isClosed()) {
            int n = this.aPoints.length - 1;
            graphics2D.drawLine(this.aPoints[n], this.bPoints[n], this.aPoints[0], this.bPoints[0]);
        }
    }

    private void transformPoints() {
        int n;
        double[][] dArray = this.polygon.getDataArray();
        int n2 = dArray.length;
        if (this.transformedCoordinates.length != n2) {
            this.transformedCoordinates = new double[n2][3];
            this.aPoints = new int[n2];
            this.bPoints = new int[n2];
            this.objects = new Object3D[n2];
            n = 0;
            while (n < n2) {
                this.objects[n] = new Object3D(this, n);
                ++n;
            }
        }
        System.arraycopy(Element.STD_ORIGIN, 0, this.center, 0, 3);
        n = 0;
        while (n < n2) {
            System.arraycopy(dArray[n], 0, this.transformedCoordinates[n], 0, 3);
            this.element.sizeAndToSpaceFrame(this.transformedCoordinates[n]);
            int n3 = 0;
            while (n3 < 3) {
                int n4 = n3;
                this.center[n4] = this.center[n4] + this.transformedCoordinates[n][n3];
                ++n3;
            }
            ++n;
        }
        n = 0;
        while (n < 3) {
            int n5 = n++;
            this.center[n5] = this.center[n5] / (double)n2;
        }
    }

    private void projectPoints() {
        DrawingPanel3D drawingPanel3D = this.element.getPanel();
        int n = this.transformedCoordinates.length;
        int n2 = 0;
        while (n2 < n) {
            System.arraycopy(this.transformedCoordinates[n2], 0, this.pixel, 0, 3);
            drawingPanel3D.projectPosition(this.pixel);
            this.aPoints[n2] = (int)this.pixel[0];
            this.bPoints[n2] = (int)this.pixel[1];
            this.objects[n2].setDistance(this.pixel[2] * this.style.getDepthFactor());
            ++n2;
        }
        if (this.polygon.isClosed()) {
            if (this.style.isDrawingFill()) {
                System.arraycopy(this.center, 0, this.pixel, 0, 3);
                drawingPanel3D.projectPosition(this.pixel);
                this.closedObject[0].setDistance(this.pixel[2] * this.style.getDepthFactor());
            } else {
                this.closedObject[0].setDistance(Double.NaN);
            }
        } else {
            this.objects[n - 1].setDistance(Double.NaN);
        }
    }
}

