/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.java3d;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.geometry.Stripifier;
import com.sun.j3d.utils.geometry.Triangulator;
import java.awt.Color;
import java.awt.Paint;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.TexCoord2f;
import org.opensourcephysics.drawing3d.ElementPolygon;
import org.opensourcephysics.drawing3d.java3d.Java3dElement;

public class Java3dElementPolygon
extends Java3dElement {
    private GeometryArray tsa1 = null;
    private Shape3D shape1 = null;
    private TexCoord2f[] texCoord = null;
    private Point3d[] coords = null;
    private BranchGroup bg = null;

    public Java3dElementPolygon(ElementPolygon elementPolygon) {
        super(elementPolygon);
        this.getAppearance().getPolygonAttributes().setCullFace(0);
        this.shape1 = new Shape3D();
        this.shape1.setAppearance(this.getAppearance());
    }

    public void processChanges(int n, int n2) {
        super.processChanges(n, n2);
        if ((n & 8) != 0 || (n & 2) != 0) {
            this.computePolygon();
        }
    }

    public void styleChanged(int n) {
        if (n == 3) {
            if (!this.element.getStyle().isDrawingFill()) {
                this.getAppearance().getPolygonAttributes().setCullFace(0);
                this.getAppearance().getPolygonAttributes().setPolygonMode(1);
            } else {
                this.getAppearance().getPolygonAttributes().setCullFace(1);
                this.getAppearance().getPolygonAttributes().setPolygonMode(2);
                Paint paint = this.element.getStyle().getFillColor();
                if (paint instanceof Color) {
                    this.getAppearance().getMaterial().setDiffuseColor(new Color3f((Color)paint));
                }
                this.getAppearance().getMaterial().setSpecularColor(new Color3f(Color.white));
            }
            this.computePolygon();
        } else {
            super.styleChanged(n);
        }
    }

    private void computePolygon() {
        int n = ((ElementPolygon)this.element).getData().length;
        if (n <= 1) {
            return;
        }
        if (this.element.getStyle().isDrawingFill()) {
            this.coords = new Point3d[n + 1];
            this.texCoord = new TexCoord2f[n + 1];
            int n2 = 0;
            while (n2 < n) {
                this.coords[n2] = new Point3d(((ElementPolygon)this.element).getData()[n2][0], ((ElementPolygon)this.element).getData()[n2][1], ((ElementPolygon)this.element).getData()[n2][2]);
                this.texCoord[n2] = n2 == 0 || n2 % 3 == 0 ? new TexCoord2f(0.0f, 0.0f) : (n2 % 2 == 0 ? new TexCoord2f(1.0f, 0.0f) : new TexCoord2f(0.5f, 0.5f));
                ++n2;
            }
            this.coords[n] = new Point3d(((ElementPolygon)this.element).getData()[0][0], ((ElementPolygon)this.element).getData()[0][1], ((ElementPolygon)this.element).getData()[0][2]);
            this.texCoord[n] = new TexCoord2f(0.0f, 0.0f);
        } else {
            this.coords = new Point3d[n * 2 + 1];
            this.texCoord = new TexCoord2f[n * 2 + 1];
            int n3 = 0;
            while (n3 < n) {
                this.coords[n3] = new Point3d(((ElementPolygon)this.element).getData()[n3][0], ((ElementPolygon)this.element).getData()[n3][1], ((ElementPolygon)this.element).getData()[n3][2]);
                this.coords[n * 2 - n3] = new Point3d(((ElementPolygon)this.element).getData()[n3][0], ((ElementPolygon)this.element).getData()[n3][1], ((ElementPolygon)this.element).getData()[n3][2]);
                if (n3 == 0 || n3 % 3 == 0) {
                    this.texCoord[n3] = new TexCoord2f(0.0f, 0.0f);
                    this.texCoord[n * 2 - n3] = new TexCoord2f(0.0f, 0.0f);
                } else if (n3 % 2 == 0) {
                    this.texCoord[n3] = new TexCoord2f(1.0f, 0.0f);
                    this.texCoord[n * 2 - n3] = new TexCoord2f(1.0f, 0.0f);
                } else {
                    this.texCoord[n3] = new TexCoord2f(0.5f, 0.5f);
                    this.texCoord[n * 2 - n3] = new TexCoord2f(0.5f, 0.5f);
                }
                ++n3;
            }
            this.coords[n] = new Point3d(((ElementPolygon)this.element).getData()[0][0], ((ElementPolygon)this.element).getData()[0][1], ((ElementPolygon)this.element).getData()[0][2]);
            this.texCoord[n] = new TexCoord2f(0.0f, 0.0f);
        }
        this.addShape();
    }

    private void addShape() {
        if (this.coords == null) {
            return;
        }
        int n = ((ElementPolygon)this.element).getData().length;
        if (((ElementPolygon)this.element).isClosed() && n > 2) {
            int n2 = 0;
            n2 = this.element.getStyle().isDrawingFill() ? n + 1 : n * 2 + 1;
            GeometryInfo geometryInfo = new GeometryInfo(5);
            geometryInfo.setTextureCoordinateParams(1, 2);
            geometryInfo.setTextureCoordinates(0, this.texCoord);
            geometryInfo.setCoordinates(this.coords);
            geometryInfo.setStripCounts(new int[]{n2});
            geometryInfo.recomputeIndices();
            Triangulator triangulator = new Triangulator();
            triangulator.triangulate(geometryInfo);
            geometryInfo.recomputeIndices();
            Stripifier stripifier = new Stripifier();
            stripifier.stripify(geometryInfo);
            geometryInfo.recomputeIndices();
            NormalGenerator normalGenerator = new NormalGenerator();
            normalGenerator.setCreaseAngle((double)((float)Math.toRadians(30.0)));
            normalGenerator.generateNormals(geometryInfo);
            geometryInfo.recomputeIndices();
            this.tsa1 = geometryInfo.getGeometryArray();
        } else {
            LineStripArray lineStripArray = new LineStripArray(((ElementPolygon)this.element).getDataArray().length, 37, new int[]{((ElementPolygon)this.element).getData().length});
            int n3 = 0;
            while (n3 < ((ElementPolygon)this.element).getData().length) {
                lineStripArray.setCoordinate(n3, this.coords[n3]);
                lineStripArray.setTextureCoordinate(0, n3, this.texCoord[n3]);
                ++n3;
            }
            this.tsa1 = lineStripArray;
        }
        this.shape1 = new Shape3D((Geometry)this.tsa1, this.getAppearance());
        this.bg = new BranchGroup();
        this.bg.setCapability(17);
        this.bg.addChild((Node)this.shape1);
        this.addNode((Node)this.bg);
    }

    public boolean isPrimitive() {
        return true;
    }
}

