/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.java3d;

import java.util.ArrayList;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.Group;
import org.opensourcephysics.drawing3d.java3d.Java3dDrawingPanel3D;
import org.opensourcephysics.drawing3d.java3d.Java3dStyle;
import org.opensourcephysics.drawing3d.utils.ImplementingObject;
import org.opensourcephysics.drawing3d.utils.TransformationWrapper;
import org.opensourcephysics.numerics.Matrix3DTransformation;
import org.opensourcephysics.numerics.Quaternion;
import org.opensourcephysics.numerics.Transformation;

public abstract class Java3dElement
implements ImplementingObject {
    public static final int AFFECTS_TRANSFORM = 279;
    protected Element element;
    protected boolean primitive;
    private Java3dStyle java3dStyle;
    private BranchGroup branchGroup;
    private BranchGroup last_branchGroup;
    private TransformGroup transformGroup;
    private Transform3D transform1;
    private Transform3D transform2;
    private Vector3d positionVector = new Vector3d();
    private Vector3d sizeVector = new Vector3d();
    private Quat4d quatBuffer1 = new Quat4d(0.0, 0.0, 0.0, 1.0);
    private Vector3d finalTranslation = new Vector3d();
    private ArrayList<Quat4d> listQuat = new ArrayList();
    private ArrayList<Vector3d> listDirect = new ArrayList();

    protected Java3dElement(Element element) {
        this.element = element;
        this.java3dStyle = new Java3dStyle(this.element.getStyle());
        this.branchGroup = new BranchGroup();
        this.branchGroup.setCapability(14);
        this.branchGroup.setCapability(13);
        this.branchGroup.setCapability(17);
        this.transform1 = new Transform3D();
        this.transform2 = new Transform3D();
        this.transform2.mul(this.transform1);
        this.transformGroup = new TransformGroup(this.transform2);
        this.transformGroup.setCapability(17);
        this.transformGroup.setCapability(18);
        this.transformGroup.setCapability(14);
        this.transformGroup.setCapability(13);
        this.element.addChange(279);
    }

    public void addToScene() {
        Group group = this.element.getGroup();
        if (group != null) {
            ImplementingObject implementingObject = group.getImplementingObject();
            if (implementingObject != null) {
                ((Java3dElement)group.getImplementingObject()).getTransformGroup().addChild((Node)this.branchGroup);
            }
        } else {
            ((Java3dDrawingPanel3D)this.element.getPanel().getImplementingPanel()).getTransformGroup().addChild((Node)this.branchGroup);
        }
    }

    public void removeFromScene() {
        Group group = this.element.getGroup();
        if (group != null) {
            Java3dElement java3dElement = (Java3dElement)group.getImplementingObject();
            if (java3dElement != null) {
                java3dElement.getTransformGroup().removeChild((Node)this.branchGroup);
            }
        } else {
            Java3dDrawingPanel3D java3dDrawingPanel3D = (Java3dDrawingPanel3D)this.element.getPanel().getImplementingPanel();
            if (java3dDrawingPanel3D != null) {
                java3dDrawingPanel3D.getTransformGroup().removeChild((Node)this.branchGroup);
            }
        }
    }

    public synchronized void processChanges(int n, int n2) {
        double[] dArray;
        if ((n & 2) != 0) {
            dArray = this.element.getScaledPosition();
            this.positionVector.x = dArray[0];
            this.positionVector.y = dArray[1];
            this.positionVector.z = dArray[2];
        }
        if ((n & 4) != 0) {
            dArray = this.element.getScaledSize();
            this.sizeVector.x = dArray[0];
            this.sizeVector.y = dArray[1];
            this.sizeVector.z = dArray[2];
        }
        if ((n & 0x100) != 0) {
            this.modifyTransform();
        }
        if ((n & 0x117) != 0) {
            this.transform1.set(this.quatBuffer1);
            this.transform2.setIdentity();
            this.finalTranslation.set(new double[]{0.0, 0.0, 0.0});
            int n3 = this.listQuat.size() - 1;
            while (n3 >= 0) {
                Transform3D transform3D = new Transform3D();
                transform3D.set(this.listQuat.get(n3));
                this.finalTranslation.add((Tuple3d)this.listDirect.get(n3));
                this.transform2.mul(transform3D);
                --n3;
            }
            this.transform2.mul(this.transform1);
            this.finalTranslation.add((Tuple3d)this.positionVector);
            this.transform2.setTranslation(this.finalTranslation);
            this.transform2.setScale(this.sizeVector);
            this.transformGroup.setTransform(this.transform2);
        }
        if ((n & 1) != 0) {
            this.makeVisible(this.element.isVisible());
        }
        if ((n & 0x10) != 0 || (n & 8) != 0) {
            this.element.styleChanged(10);
        }
    }

    public void styleChanged(int n) {
        switch (n) {
            case 5: {
                this.element.addChange(2);
                break;
            }
            case 9: {
                this.element.addChange(16);
            }
        }
        this.java3dStyle.applyStyleChange(n);
    }

    protected void makeVisible(boolean bl) {
        if (this.element instanceof Group) {
            for (Element element : ((Group)this.element).getElements()) {
                ((Java3dElement)element.getImplementingObject()).getAppearance().getRenderingAttributes().setVisible(bl);
            }
        } else if (this.element.getGroup() == null || this.element.getGroup().isVisible()) {
            this.getAppearance().getRenderingAttributes().setVisible(bl);
        }
    }

    public abstract boolean isPrimitive();

    protected final void addNode(Node node) {
        if (node == null) {
            this.branchGroup.addChild((Node)this.transformGroup);
            return;
        }
        if (this.last_branchGroup != null) {
            this.last_branchGroup.detach();
            this.last_branchGroup.removeAllChildren();
            this.transformGroup.removeAllChildren();
        }
        this.transformGroup.addChild(node);
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.setCapability(17);
        branchGroup.setCapability(13);
        branchGroup.setCapability(14);
        branchGroup.addChild((Node)this.transformGroup);
        this.branchGroup.addChild((Node)branchGroup);
        this.last_branchGroup = branchGroup;
    }

    protected final BranchGroup getBranchGroup() {
        return this.branchGroup;
    }

    protected final TransformGroup getTransformGroup() {
        return this.transformGroup;
    }

    protected final Vector3d getPositionVector() {
        return this.positionVector;
    }

    protected final Vector3d getSizeVector() {
        return this.sizeVector;
    }

    protected final Appearance getAppearance() {
        return this.java3dStyle.getAppearance();
    }

    private void modifyTransform() {
        this.quatBuffer1 = this.changeTransform(this.element.getTransformation());
        this.listQuat.clear();
        this.listDirect.clear();
        for (TransformationWrapper transformationWrapper : this.element.getSecondaryTransformations()) {
            if (!transformationWrapper.isEnabled()) continue;
            this.listQuat.add(this.changeTransform(transformationWrapper.getTransformation()));
            this.listDirect.add(this.getDirectMovement(transformationWrapper.getTransformation()));
        }
    }

    private Vector3d getDirectMovement(Transformation transformation) {
        Vector3d vector3d = new Vector3d();
        if (transformation == null) {
            vector3d.set(new double[]{0.0, 0.0, 0.0});
        } else if (transformation instanceof Quaternion) {
            double[] dArray = ((Quaternion)transformation).getOrigin();
            if (dArray[0] != 0.0 || dArray[1] != 0.0 || dArray[2] != 0.0) {
                vector3d.set(transformation.direct(new double[]{0.0, 0.0, 0.0}));
            }
        } else {
            double[] dArray = ((Matrix3DTransformation)transformation).getOrigin();
            if (dArray[0] != 0.0 || dArray[1] != 0.0 || dArray[2] != 0.0) {
                vector3d.set(transformation.direct(new double[]{0.0, 0.0, 0.0}));
            }
        }
        return vector3d;
    }

    private Quat4d changeTransform(Transformation transformation) {
        Quat4d quat4d = new Quat4d();
        double[] dArray = new double[16];
        double[] dArray2 = new double[3];
        Transform3D transform3D = new Transform3D();
        if (transformation == null) {
            quat4d.set(0.0, 0.0, 0.0, 1.0);
        } else if (transformation instanceof Quaternion) {
            double[] dArray3 = ((Quaternion)transformation).getCoordinates();
            System.arraycopy(dArray3, 1, dArray2, 0, 3);
            this.element.getPanel().getCamera().map(dArray2);
            quat4d.set(dArray2[0], dArray2[1], dArray2[2], dArray3[0]);
        } else if (transformation instanceof Matrix3DTransformation) {
            ((Matrix3DTransformation)transformation).getTransposedFlatMatrix(dArray);
            transform3D.set(dArray);
            transform3D.get(quat4d);
            dArray2[0] = quat4d.x;
            dArray2[1] = quat4d.y;
            dArray2[2] = quat4d.z;
            this.element.getPanel().getCamera().map(dArray2);
            quat4d.set(dArray2[0], dArray2[1], dArray2[2], quat4d.w);
        } else {
            System.err.println("Java3dElement Warning! Ignored transformation of an unknown type : " + transformation);
        }
        return quat4d;
    }
}

