/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing3d;

import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.drawing3d.ControlElement3D;
import org.colos.ejs.library.control.drawing3d.ControlGroup3D;
import org.colos.ejs.library.control.value.BooleanValue;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.ObjectValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.Set;
import org.opensourcephysics.drawing3d.interaction.InteractionEvent;
import org.opensourcephysics.drawing3d.interaction.InteractionTarget;
import org.opensourcephysics.drawing3d.utils.Resolution;
import org.opensourcephysics.numerics.Matrix3DTransformation;
import org.opensourcephysics.numerics.Transformation;
import org.opensourcephysics.tools.ToolForData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ControlSet3D
extends ControlElement3D {
    protected static final int SET3D_ADDED = 2;
    protected static final int NUM_ELEMENTS = 0;
    protected static final int ELEMENT_SELECTED = 1;
    protected Set set;
    protected Element[] elements;
    protected int numElements = 0;
    protected ObjectValue[] allposValues;
    protected ObjectValue[] allsizesValues;
    protected IntegerValue selectedValue = new IntegerValue(-1);
    protected double[] theXs;
    protected double[] theYs;
    protected double[] theZs;
    protected double[] theSizeXs;
    protected double[] theSizeYs;
    protected double[] theSizeZs;
    protected double[][] allThePos;
    protected double[][] allTheSizes;
    protected double lineWidth = 1.0;
    protected boolean numberOfElements_isSet = false;
    protected double defaultElementX;
    protected double defaultElementY;
    protected double defaultElementZ;
    protected double defaultElementSizeX;
    protected double defaultElementSizeY;
    protected double defaultElementSizeZ;
    protected Color defElementLines;
    protected Paint defElementFill;
    private static List<String> infoList = null;
    int selectedElement = -1;

    public ControlSet3D() {
        this.checkNumberOfElements(1, true);
        this.defaultElementX = this.elements[0].getX();
        this.defaultElementY = this.elements[0].getY();
        this.defaultElementSizeX = this.elements[0].getSizeX();
        this.defaultElementSizeY = this.elements[0].getSizeY();
        this.defElementLines = this.elements[0].getStyle().getLineColor();
        this.defElementFill = this.elements[0].getStyle().getFillColor();
    }

    @Override
    public String getObjectClassname() {
        return "org.opensourcephysics.drawing3d.Set";
    }

    @Override
    protected Element createElement() {
        this.set = new Set();
        return this.set;
    }

    protected abstract Element createAnElement();

    protected abstract int getPropertiesAddedToSet();

    @Override
    protected final int getPropertiesDisplacement() {
        return this.getPropertiesAddedToSet() + 2;
    }

    protected void copyAnElement(Element element, Element element2) {
        element.getStyle().copyTo(element2.getStyle());
        element2.setDataObject(element.getDataObject());
        if (element.getPanel() != null) {
            element2.setPanel(element.getPanel());
        }
        element2.setName(element.getName());
        element2.setXYZ(element.getX(), element.getY(), element.getZ());
        element2.setSizeXYZ(element.getSizeX(), element.getSizeY(), element.getSizeZ());
        element2.setTransformation(element.getTransformation());
        element2.addSecondaryTransformations(element.getSecondaryTransformations());
        element2.setVisible(element.isVisible());
        element2.getInteractionTarget(0).setEnabled(element.getInteractionTarget(0).getEnabled());
        element2.getInteractionTarget(0).setAffectsGroup(element.getInteractionTarget(0).getAffectsGroup());
        element2.getInteractionTarget(1).setEnabled(element.getInteractionTarget(1).getEnabled());
        element2.getInteractionTarget(1).setAffectsGroup(element.getInteractionTarget(1).getAffectsGroup());
    }

    protected final void checkNumberOfElements(int n, boolean bl) {
        if (this.numElements == n && !bl) {
            return;
        }
        if (n < 1) {
            return;
        }
        this.setNumberOfElements(n);
        EjsControl ejsControl = this.getGroup();
        if (ejsControl != null && !ejsControl.isReportingChange()) {
            ejsControl.propagateValues();
        }
    }

    protected void setNumberOfElements(int n) {
        Element[] elementArray = this.elements;
        this.elements = new Element[n];
        int n2 = 0;
        while (n2 < n) {
            this.elements[n2] = this.createAnElement();
            Element element = null;
            if (n2 < this.numElements) {
                element = elementArray[n2];
            } else if (elementArray != null) {
                element = elementArray[0];
            }
            if (element != null) {
                this.copyAnElement(element, this.elements[n2]);
            }
            ++n2;
        }
        this.set.removeAllElements();
        n2 = 0;
        while (n2 < n) {
            this.set.addElement(this.elements[n2]);
            this.elements[n2].setName(String.valueOf(this.set.getName()) + "[" + n2 + "]");
            ++n2;
        }
        this.theXs = new double[n];
        this.theYs = new double[n];
        this.theZs = new double[n];
        this.theSizeXs = new double[n];
        this.theSizeYs = new double[n];
        this.theSizeZs = new double[n];
        n2 = 0;
        while (n2 < n) {
            this.theXs[n2] = this.elements[n2].getX();
            this.theYs[n2] = this.elements[n2].getY();
            this.theZs[n2] = this.elements[n2].getZ();
            this.theSizeXs[n2] = this.elements[n2].getSizeX();
            this.theSizeYs[n2] = this.elements[n2].getSizeY();
            this.theSizeZs[n2] = this.elements[n2].getSizeZ();
            this.elements[n2].addInteractionListener(this);
            ++n2;
        }
        this.allposValues = new ObjectValue[3];
        this.allsizesValues = new ObjectValue[3];
        this.allposValues[0] = new ObjectValue(this.theXs);
        this.allposValues[1] = new ObjectValue(this.theYs);
        this.allposValues[2] = new ObjectValue(this.theZs);
        this.allsizesValues[0] = new ObjectValue(this.theSizeXs);
        this.allsizesValues[1] = new ObjectValue(this.theSizeYs);
        this.allsizesValues[2] = new ObjectValue(this.theSizeZs);
        this.numElements = n;
        elementArray = null;
    }

    public Element elementAt(int n) {
        return this.elements[n];
    }

    @Override
    public void reset() {
        this.set.clear();
    }

    @Override
    public void initialize() {
        this.set.initialize();
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        int n = 0;
        while (n < this.numElements) {
            this.elements[n].setName(String.valueOf(string) + "[" + n + "]");
            ++n;
        }
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("numberOfElements");
            infoList.add("elementSelected");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("numberOfElements")) {
            return "int PREVIOUS";
        }
        if (string.equals("elementSelected")) {
            return "int";
        }
        if (string.equals("x")) {
            return "int|double|double[]";
        }
        if (string.equals("y")) {
            return "int|double|double[]";
        }
        if (string.equals("z")) {
            return "int|double|double[]";
        }
        if (string.equals("sizeX")) {
            return "int|double|double[]";
        }
        if (string.equals("sizeY")) {
            return "int|double|double[]";
        }
        if (string.equals("sizeZ")) {
            return "int|double|double[]";
        }
        if (string.equals("transformation")) {
            return "3DTransformation|double[]|String|Object|Object[]";
        }
        if (string.equals("visible")) {
            return "boolean|boolean[]";
        }
        if (string.equals("lineColor")) {
            return "int|int[]|Color|Object|Object[]";
        }
        if (string.equals("lineWidth")) {
            return "int|double|double[]";
        }
        if (string.equals("fillColor")) {
            return "int|int[]|Color|Object|Object[]";
        }
        if (string.equals("resolution")) {
            return "3DResolution|String|Object|Object[]";
        }
        if (string.equals("drawingFill")) {
            return "boolean|boolean[]";
        }
        if (string.equals("drawingLines")) {
            return "boolean|boolean[]";
        }
        if (string.equals("enabledPosition")) {
            return "Interaction3D|int|int[]|boolean|boolean[]";
        }
        if (string.equals("movesGroup")) {
            return "boolean|boolean[]";
        }
        if (string.equals("enabledSize")) {
            return "Interaction3D|int|int[]|boolean|boolean[]";
        }
        if (string.equals("resizesGroup")) {
            return "boolean|boolean[]";
        }
        if (string.equals("sensitivity")) {
            return "int|int[]";
        }
        if (string.equals("position")) {
            return "double[][]";
        }
        if (string.equals("size")) {
            return "double[][]";
        }
        if (string.equals("menuName")) {
            return "String TRANSLATABLE";
        }
        if (string.equals("elementposition")) {
            return "ArrowPosition|int|int[]";
        }
        if (string.equals("depthFactor")) {
            return "double|double[]";
        }
        if (string.equals("measured")) {
            return "boolean|boolean[]";
        }
        if (string.equals("extraColor")) {
            return "int|int[]|Color|Object|Object[]";
        }
        if (string.equals("numberOfElements")) {
            return "int PREVIOUS";
        }
        if (string.equals("elementSelected")) {
            return "int";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public String getPropertyCommonName(String string) {
        if (string.equals("size")) {
            return "sizeArray";
        }
        return super.getPropertyCommonName(string);
    }

    @Override
    public ControlElement setProperty(String string, String string2) {
        string = string.trim();
        if (string2 != null) {
            boolean bl;
            boolean bl2 = bl = string2.startsWith("%_model.") && string2.endsWith("()%");
            if (string.equals("x")) {
                this.set.setXLabel(bl ? "x" : string2);
            } else if (string.equals("y")) {
                this.set.setYLabel(bl ? "y" : string2);
            } else if (string.equals("z")) {
                this.set.setYLabel(bl ? "z" : string2);
            }
        }
        return super.setProperty(string, string2);
    }

    @Override
    public void addMenuEntries() {
        if (this.getMenuNameEntry() == null || !ToolForData.getTool().isFullTool()) {
            return;
        }
        this.getSimulation().addElementMenuEntries(this.getMenuNameEntry(), ControlSet3D.getDataInformationMenuEntries(this.getTopWindow(), this.set));
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (value.getInteger() != this.numElements) {
                    this.checkNumberOfElements(value.getInteger(), true);
                }
                this.numberOfElements_isSet = true;
                break;
            }
            case 1: {
                this.selectedValue.value = value.getInteger();
            }
        }
        switch (n -= 2) {
            case 2: {
                this.allThePos = null;
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(dArray.length, false);
                    }
                    int n2 = 0;
                    int n3 = Math.min(this.theXs.length, dArray.length);
                    while (n2 < n3) {
                        this.theXs[n2] = dArray[n2];
                        this.elements[n2].setX(this.theXs[n2]);
                        ++n2;
                    }
                } else {
                    double d = value.getDouble();
                    int n4 = 0;
                    int n5 = this.theXs.length;
                    while (n4 < n5) {
                        this.theXs[n4] = d;
                        this.elements[n4].setX(this.theXs[n4]);
                        ++n4;
                    }
                }
                break;
            }
            case 3: {
                this.allThePos = null;
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(dArray.length, false);
                    }
                    int n6 = 0;
                    int n7 = Math.min(this.theYs.length, dArray.length);
                    while (n6 < n7) {
                        this.theYs[n6] = dArray[n6];
                        this.elements[n6].setY(this.theYs[n6]);
                        ++n6;
                    }
                } else {
                    double d = value.getDouble();
                    int n8 = 0;
                    int n9 = this.theYs.length;
                    while (n8 < n9) {
                        this.theYs[n8] = d;
                        this.elements[n8].setY(this.theYs[n8]);
                        ++n8;
                    }
                }
                break;
            }
            case 4: {
                this.allThePos = null;
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(dArray.length, false);
                    }
                    int n10 = 0;
                    int n11 = Math.min(this.theZs.length, dArray.length);
                    while (n10 < n11) {
                        this.theZs[n10] = dArray[n10];
                        this.elements[n10].setZ(this.theZs[n10]);
                        ++n10;
                    }
                } else {
                    double d = value.getDouble();
                    int n12 = 0;
                    int n13 = this.theZs.length;
                    while (n12 < n13) {
                        this.theZs[n12] = d;
                        this.elements[n12].setZ(this.theZs[n12]);
                        ++n12;
                    }
                }
                break;
            }
            case 26: {
                if (!(value.getObject() instanceof double[][])) break;
                this.allThePos = (double[][])value.getObject();
                if (!this.numberOfElements_isSet) {
                    this.checkNumberOfElements(this.allThePos.length, false);
                }
                int n14 = 0;
                int n15 = Math.min(this.numElements, this.allThePos.length);
                while (n14 < n15) {
                    double[] dArray = this.allThePos[n14];
                    this.theXs[n14] = dArray[0];
                    this.theYs[n14] = dArray[1];
                    this.theZs[n14] = dArray[2];
                    this.elements[n14].setXYZ(this.theXs[n14], this.theYs[n14], this.theZs[n14]);
                    ++n14;
                }
                break;
            }
            case 5: {
                this.allTheSizes = null;
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(dArray.length, false);
                    }
                    int n16 = 0;
                    int n17 = Math.min(this.theSizeXs.length, dArray.length);
                    while (n16 < n17) {
                        this.theSizeXs[n16] = dArray[n16];
                        this.elements[n16].setSizeX(this.theSizeXs[n16]);
                        ++n16;
                    }
                } else {
                    double d = value.getDouble();
                    int n18 = 0;
                    int n19 = this.theSizeXs.length;
                    while (n18 < n19) {
                        this.theSizeXs[n18] = d;
                        this.elements[n18].setSizeX(this.theSizeXs[n18]);
                        ++n18;
                    }
                }
                break;
            }
            case 6: {
                this.allTheSizes = null;
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(dArray.length, false);
                    }
                    int n20 = 0;
                    int n21 = Math.min(this.theSizeYs.length, dArray.length);
                    while (n20 < n21) {
                        this.theSizeYs[n20] = dArray[n20];
                        this.elements[n20].setSizeY(this.theSizeYs[n20]);
                        ++n20;
                    }
                } else {
                    double d = value.getDouble();
                    int n22 = 0;
                    int n23 = this.theSizeYs.length;
                    while (n22 < n23) {
                        this.theSizeYs[n22] = d;
                        this.elements[n22].setSizeY(this.theSizeYs[n22]);
                        ++n22;
                    }
                }
                break;
            }
            case 7: {
                this.allTheSizes = null;
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(dArray.length, false);
                    }
                    int n24 = 0;
                    int n25 = Math.min(this.theSizeZs.length, dArray.length);
                    while (n24 < n25) {
                        this.theSizeZs[n24] = dArray[n24];
                        this.elements[n24].setSizeZ(this.theSizeZs[n24]);
                        ++n24;
                    }
                } else {
                    double d = value.getDouble();
                    int n26 = 0;
                    int n27 = this.theSizeZs.length;
                    while (n26 < n27) {
                        this.theSizeZs[n26] = d;
                        this.elements[n26].setSizeZ(this.theSizeZs[n26]);
                        ++n26;
                    }
                }
                break;
            }
            case 27: {
                if (!(value.getObject() instanceof double[][])) break;
                this.allTheSizes = (double[][])value.getObject();
                if (!this.numberOfElements_isSet) {
                    this.checkNumberOfElements(this.allTheSizes.length, false);
                }
                int n28 = 0;
                int n29 = Math.min(this.numElements, this.allTheSizes.length);
                while (n28 < n29) {
                    double[] dArray = this.allTheSizes[n28];
                    this.theSizeXs[n28] = dArray[0];
                    this.theSizeYs[n28] = dArray[1];
                    this.theSizeZs[n28] = dArray[2];
                    this.elements[n28].setSizeXYZ(this.theSizeXs[n28], this.theSizeYs[n28], this.theSizeZs[n28]);
                    ++n28;
                }
                break;
            }
            case 8: {
                if (value.getObject() instanceof Transformation) {
                    Transformation transformation = (Transformation)value.getObject();
                    int n30 = 0;
                    while (n30 < this.numElements) {
                        this.elements[n30].setTransformation(transformation);
                        ++n30;
                    }
                } else if (value.getObject() instanceof Object[]) {
                    Object[] objectArray = (Object[])value.getObject();
                    int n31 = 0;
                    int n32 = Math.min(this.numElements, objectArray.length);
                    while (n31 < n32) {
                        this.elements[n31].setTransformation((Transformation)objectArray[n31]);
                        ++n31;
                    }
                } else {
                    if (!(value.getObject() instanceof double[])) break;
                    double[] dArray = (double[])value.getObject();
                    if (dArray.length == 6) {
                        double[] dArray2 = new double[]{dArray[0], dArray[1], dArray[2]};
                        double[] dArray3 = new double[]{dArray[3], dArray[4], dArray[5]};
                        Matrix3DTransformation matrix3DTransformation = Matrix3DTransformation.createAlignmentTransformation(dArray2, dArray3);
                        int n33 = 0;
                        while (n33 < this.numElements) {
                            this.elements[n33].setTransformation(matrix3DTransformation);
                            ++n33;
                        }
                    } else {
                        if (dArray.length != 4) break;
                        double[] dArray4 = new double[]{dArray[1], dArray[2], dArray[3]};
                        Matrix3DTransformation matrix3DTransformation = Matrix3DTransformation.rotation(dArray[0], dArray4);
                        int n34 = 0;
                        while (n34 < this.numElements) {
                            this.elements[n34].setTransformation(matrix3DTransformation);
                            ++n34;
                        }
                    }
                }
                break;
            }
            case 9: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n35 = 0;
                    int n36 = Math.min(this.numElements, blArray.length);
                    while (n35 < n36) {
                        this.elements[n35].setVisible(blArray[n35]);
                        ++n35;
                    }
                } else {
                    boolean bl = value.getBoolean();
                    int n37 = 0;
                    int n38 = this.numElements;
                    while (n37 < n38) {
                        this.elements[n37].setVisible(bl);
                        ++n37;
                    }
                }
                break;
            }
            case 10: {
                if (value instanceof IntegerValue) {
                    Color color = DisplayColors.getLineColor(value.getInteger());
                    int n39 = 0;
                    while (n39 < this.numElements) {
                        this.elements[n39].getStyle().setLineColor(color);
                        ++n39;
                    }
                } else if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n40 = 0;
                    int n41 = Math.min(this.numElements, nArray.length);
                    while (n40 < n41) {
                        this.elements[n40].getStyle().setLineColor(DisplayColors.getLineColor(nArray[n40]));
                        ++n40;
                    }
                } else if (value.getObject() instanceof Object[]) {
                    Object[] objectArray = (Object[])value.getObject();
                    int n42 = 0;
                    int n43 = Math.min(this.numElements, objectArray.length);
                    while (n42 < n43) {
                        this.elements[n42].getStyle().setLineColor((Color)objectArray[n42]);
                        ++n42;
                    }
                } else {
                    if (!(value.getObject() instanceof Color)) break;
                    Color color = (Color)value.getObject();
                    int n44 = 0;
                    while (n44 < this.numElements) {
                        this.elements[n44].getStyle().setLineColor(color);
                        ++n44;
                    }
                }
                break;
            }
            case 11: {
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    int n45 = 0;
                    int n46 = Math.min(this.numElements, dArray.length);
                    while (n45 < n46) {
                        this.elements[n45].getStyle().setLineWidth((float)dArray[n45]);
                        ++n45;
                    }
                } else {
                    float f = (float)value.getDouble();
                    int n47 = 0;
                    int n48 = this.numElements;
                    while (n47 < n48) {
                        this.elements[n47].getStyle().setLineWidth(f);
                        ++n47;
                    }
                }
                break;
            }
            case 12: {
                if (value instanceof IntegerValue) {
                    Color color = DisplayColors.getLineColor(value.getInteger());
                    int n49 = 0;
                    while (n49 < this.numElements) {
                        this.elements[n49].getStyle().setFillColor(color);
                        ++n49;
                    }
                } else if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n50 = 0;
                    int n51 = Math.min(this.numElements, nArray.length);
                    while (n50 < n51) {
                        this.elements[n50].getStyle().setFillColor(DisplayColors.getLineColor(nArray[n50]));
                        ++n50;
                    }
                } else if (value.getObject() instanceof Object[]) {
                    Object[] objectArray = (Object[])value.getObject();
                    int n52 = 0;
                    int n53 = Math.min(this.numElements, objectArray.length);
                    while (n52 < n53) {
                        this.elements[n52].getStyle().setFillColor((Color)objectArray[n52]);
                        ++n52;
                    }
                } else {
                    if (!(value.getObject() instanceof Color)) break;
                    Color color = (Color)value.getObject();
                    int n54 = 0;
                    while (n54 < this.numElements) {
                        this.elements[n54].getStyle().setFillColor(color);
                        ++n54;
                    }
                }
                break;
            }
            case 13: {
                if (value.getObject() instanceof Resolution) {
                    Resolution resolution = (Resolution)value.getObject();
                    int n55 = 0;
                    while (n55 < this.numElements) {
                        this.elements[n55].getStyle().setResolution(resolution);
                        ++n55;
                    }
                } else if (value.getObject() instanceof Object[]) {
                    Object[] objectArray = (Object[])value.getObject();
                    int n56 = 0;
                    int n57 = Math.min(this.numElements, objectArray.length);
                    while (n56 < n57) {
                        this.elements[n56].getStyle().setResolution((Resolution)objectArray[n56]);
                        ++n56;
                    }
                } else {
                    Resolution resolution = ControlSet3D.decodeResolution(value.toString());
                    if (resolution == null) break;
                    int n58 = 0;
                    while (n58 < this.numElements) {
                        this.elements[n58].getStyle().setResolution(resolution);
                        ++n58;
                    }
                }
                break;
            }
            case 14: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n59 = 0;
                    int n60 = Math.min(this.numElements, blArray.length);
                    while (n59 < n60) {
                        this.elements[n59].getStyle().setDrawingFill(blArray[n59]);
                        ++n59;
                    }
                } else {
                    boolean bl = value.getBoolean();
                    int n61 = 0;
                    int n62 = this.numElements;
                    while (n61 < n62) {
                        this.elements[n61].getStyle().setDrawingFill(bl);
                        ++n61;
                    }
                }
                break;
            }
            case 15: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n63 = 0;
                    int n64 = Math.min(this.numElements, blArray.length);
                    while (n63 < n64) {
                        this.elements[n63].getStyle().setDrawingLines(blArray[n63]);
                        ++n63;
                    }
                } else {
                    boolean bl = value.getBoolean();
                    int n65 = 0;
                    int n66 = this.numElements;
                    while (n65 < n66) {
                        this.elements[n65].getStyle().setDrawingLines(bl);
                        ++n65;
                    }
                }
                break;
            }
            case 16: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n67 = 0;
                    int n68 = Math.min(this.numElements, blArray.length);
                    while (n67 < n68) {
                        this.elements[n67].getInteractionTarget(0).setEnabled(blArray[n67]);
                        ++n67;
                    }
                } else if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n69 = 0;
                    int n70 = Math.min(this.numElements, nArray.length);
                    while (n69 < n70) {
                        this.elements[n69].getInteractionTarget(0).setEnabled(nArray[n69]);
                        ++n69;
                    }
                } else if (value instanceof BooleanValue) {
                    boolean bl = value.getBoolean();
                    int n71 = 0;
                    while (n71 < this.numElements) {
                        this.elements[n71].getInteractionTarget(0).setEnabled(bl);
                        ++n71;
                    }
                } else {
                    int n72 = value.getInteger();
                    int n73 = 0;
                    while (n73 < this.numElements) {
                        this.elements[n73].getInteractionTarget(0).setEnabled(n72);
                        ++n73;
                    }
                }
                break;
            }
            case 17: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n74 = 0;
                    int n75 = Math.min(this.numElements, blArray.length);
                    while (n74 < n75) {
                        this.elements[n74].getInteractionTarget(0).setAffectsGroup(blArray[n74]);
                        ++n74;
                    }
                } else {
                    boolean bl = value.getBoolean();
                    int n76 = 0;
                    int n77 = this.numElements;
                    while (n76 < n77) {
                        this.elements[n76].getInteractionTarget(0).setAffectsGroup(bl);
                        ++n76;
                    }
                }
                break;
            }
            case 18: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n78 = 0;
                    int n79 = Math.min(this.numElements, blArray.length);
                    while (n78 < n79) {
                        this.elements[n78].getInteractionTarget(1).setEnabled(blArray[n78]);
                        ++n78;
                    }
                } else if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n80 = 0;
                    int n81 = Math.min(this.numElements, nArray.length);
                    while (n80 < n81) {
                        this.elements[n80].getInteractionTarget(1).setEnabled(nArray[n80]);
                        ++n80;
                    }
                } else if (value instanceof BooleanValue) {
                    boolean bl = value.getBoolean();
                    int n82 = 0;
                    while (n82 < this.numElements) {
                        this.elements[n82].getInteractionTarget(1).setEnabled(bl);
                        ++n82;
                    }
                } else {
                    int n83 = value.getInteger();
                    int n84 = 0;
                    while (n84 < this.numElements) {
                        this.elements[n84].getInteractionTarget(1).setEnabled(n83);
                        ++n84;
                    }
                }
                break;
            }
            case 19: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n85 = 0;
                    int n86 = Math.min(this.numElements, blArray.length);
                    while (n85 < n86) {
                        this.elements[n85].getInteractionTarget(1).setAffectsGroup(blArray[n85]);
                        ++n85;
                    }
                } else {
                    boolean bl = value.getBoolean();
                    int n87 = 0;
                    int n88 = this.numElements;
                    while (n87 < n88) {
                        this.elements[n87].getInteractionTarget(1).setAffectsGroup(bl);
                        ++n87;
                    }
                }
                break;
            }
            case 20: {
                if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n89 = 0;
                    int n90 = Math.min(this.numElements, nArray.length);
                    while (n89 < n90) {
                        this.elements[n89].getStyle().setSensitivity(nArray[n89]);
                        ++n89;
                    }
                } else {
                    int n91 = value.getInteger();
                    int n92 = 0;
                    int n93 = this.numElements;
                    while (n92 < n93) {
                        this.elements[n92].getStyle().setSensitivity(n91);
                        ++n92;
                    }
                }
                break;
            }
            case 29: {
                if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n94 = 0;
                    int n95 = Math.min(this.numElements, nArray.length);
                    while (n94 < n95) {
                        if (this.elements[n94].getStyle().getRelativePosition() != nArray[n94]) {
                            this.elements[n94].getStyle().setRelativePosition(nArray[n94]);
                        }
                        ++n94;
                    }
                } else {
                    int n96 = value.getInteger();
                    int n97 = 0;
                    int n98 = this.numElements;
                    while (n97 < n98) {
                        if (this.elements[n97].getStyle().getRelativePosition() != n96) {
                            this.elements[n97].getStyle().setRelativePosition(n96);
                        }
                        ++n97;
                    }
                }
                break;
            }
            case 30: {
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    int n99 = 0;
                    int n100 = Math.min(this.numElements, dArray.length);
                    while (n99 < n100) {
                        this.elements[n99].getStyle().setDepthFactor(dArray[n99]);
                        ++n99;
                    }
                } else {
                    double d = value.getDouble();
                    int n101 = 0;
                    int n102 = this.numElements;
                    while (n101 < n102) {
                        this.elements[n101].getStyle().setDepthFactor(d);
                        ++n101;
                    }
                }
                break;
            }
            case 31: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n103 = 0;
                    int n104 = Math.min(this.numElements, blArray.length);
                    while (n103 < n104) {
                        this.elements[n103].setCanBeMeasured(blArray[n103]);
                        ++n103;
                    }
                } else {
                    boolean bl = value.getBoolean();
                    int n105 = 0;
                    int n106 = this.numElements;
                    while (n105 < n106) {
                        this.elements[n105].setCanBeMeasured(bl);
                        ++n105;
                    }
                }
                break;
            }
            case 32: {
                if (value instanceof IntegerValue) {
                    Color color = DisplayColors.getLineColor(value.getInteger());
                    int n107 = 0;
                    while (n107 < this.numElements) {
                        this.elements[n107].getStyle().setExtraColor(color);
                        ++n107;
                    }
                } else if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n108 = 0;
                    int n109 = Math.min(this.numElements, nArray.length);
                    while (n108 < n109) {
                        this.elements[n108].getStyle().setExtraColor(DisplayColors.getLineColor(nArray[n108]));
                        ++n108;
                    }
                } else if (value.getObject() instanceof Object[]) {
                    Object[] objectArray = (Object[])value.getObject();
                    int n110 = 0;
                    int n111 = Math.min(this.numElements, objectArray.length);
                    while (n110 < n111) {
                        this.elements[n110].getStyle().setExtraColor((Color)objectArray[n110]);
                        ++n110;
                    }
                } else {
                    if (!(value.getObject() instanceof Color)) break;
                    Color color = (Color)value.getObject();
                    int n112 = 0;
                    while (n112 < this.numElements) {
                        this.elements[n112].getStyle().setExtraColor(color);
                        ++n112;
                    }
                }
                break;
            }
            default: {
                super.setValue(n, value);
            }
        }
        if (this.isUnderEjs) {
            this.updatePanel();
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.setNumberOfElements(1);
                this.numberOfElements_isSet = false;
                break;
            }
            case 1: {
                this.selectedValue.value = -1;
                break;
            }
            default: {
                super.setDefaultValue(n - 2);
            }
        }
        switch (n -= 2) {
            case 2: {
                int n2 = 0;
                int n3 = this.theXs.length;
                while (n2 < n3) {
                    this.theXs[n2] = this.defaultX;
                    this.elements[n2].setX(this.theXs[n2]);
                    ++n2;
                }
                break;
            }
            case 3: {
                int n4 = 0;
                int n5 = this.theYs.length;
                while (n4 < n5) {
                    this.theYs[n4] = this.defaultY;
                    this.elements[n4].setY(this.theYs[n4]);
                    ++n4;
                }
                break;
            }
            case 4: {
                int n6 = 0;
                int n7 = this.theZs.length;
                while (n6 < n7) {
                    this.theZs[n6] = this.defaultZ;
                    this.elements[n6].setZ(this.theZs[n6]);
                    ++n6;
                }
                break;
            }
            case 26: {
                this.allThePos = null;
                break;
            }
            case 5: {
                int n8 = 0;
                int n9 = this.theSizeXs.length;
                while (n8 < n9) {
                    this.theSizeXs[n8] = this.defaultSizeX;
                    this.elements[n8].setSizeX(this.theSizeXs[n8]);
                    ++n8;
                }
                break;
            }
            case 6: {
                int n10 = 0;
                int n11 = this.theSizeYs.length;
                while (n10 < n11) {
                    this.theSizeYs[n10] = this.defaultSizeY;
                    this.elements[n10].setSizeY(this.theSizeYs[n10]);
                    ++n10;
                }
                break;
            }
            case 7: {
                int n12 = 0;
                int n13 = this.theSizeZs.length;
                while (n12 < n13) {
                    this.theSizeZs[n12] = this.defaultSizeZ;
                    this.elements[n12].setSizeZ(this.theSizeZs[n12]);
                    ++n12;
                }
                break;
            }
            case 27: {
                this.allTheSizes = null;
                break;
            }
            case 8: {
                int n14 = 0;
                while (n14 < this.numElements) {
                    this.elements[n14].setTransformation(null);
                    ++n14;
                }
                break;
            }
            case 9: {
                int n15 = 0;
                while (n15 < this.numElements) {
                    this.elements[n15].setVisible(true);
                    ++n15;
                }
                break;
            }
            case 10: {
                int n16 = 0;
                while (n16 < this.numElements) {
                    this.elements[n16].getStyle().setLineColor(this.defLines);
                    ++n16;
                }
                break;
            }
            case 11: {
                int n17 = 0;
                while (n17 < this.numElements) {
                    this.elements[n17].getStyle().setLineWidth(1.0f);
                    ++n17;
                }
                break;
            }
            case 12: {
                int n18 = 0;
                while (n18 < this.numElements) {
                    this.elements[n18].getStyle().setFillColor(this.defFill);
                    ++n18;
                }
                break;
            }
            case 13: {
                int n19 = 0;
                while (n19 < this.numElements) {
                    this.elements[n19].getStyle().setResolution(this.defaultRes);
                    ++n19;
                }
                break;
            }
            case 14: {
                int n20 = 0;
                while (n20 < this.numElements) {
                    this.elements[n20].getStyle().setDrawingFill(true);
                    ++n20;
                }
                break;
            }
            case 15: {
                int n21 = 0;
                while (n21 < this.numElements) {
                    this.elements[n21].getStyle().setDrawingLines(true);
                    ++n21;
                }
                break;
            }
            case 16: {
                int n22 = 0;
                while (n22 < this.numElements) {
                    this.elements[n22].getInteractionTarget(0).setEnabled(false);
                    ++n22;
                }
                break;
            }
            case 17: {
                int n23 = 0;
                while (n23 < this.numElements) {
                    this.elements[n23].getInteractionTarget(0).setAffectsGroup(false);
                    ++n23;
                }
                break;
            }
            case 18: {
                int n24 = 0;
                while (n24 < this.numElements) {
                    this.elements[n24].getInteractionTarget(1).setEnabled(false);
                    ++n24;
                }
                break;
            }
            case 19: {
                int n25 = 0;
                while (n25 < this.numElements) {
                    this.elements[n25].getInteractionTarget(1).setAffectsGroup(false);
                    ++n25;
                }
                break;
            }
            case 20: {
                int n26 = 0;
                while (n26 < this.numElements) {
                    this.elements[n26].getStyle().setSensitivity(5);
                    ++n26;
                }
                break;
            }
            case 29: {
                int n27 = 0;
                while (n27 < this.numElements) {
                    this.elements[n27].getStyle().setRelativePosition(5);
                    ++n27;
                }
                break;
            }
            case 30: {
                int n28 = 0;
                int n29 = this.numElements;
                while (n28 < n29) {
                    this.elements[n28].getStyle().setDepthFactor(1.0);
                    ++n28;
                }
                break;
            }
            case 31: {
                int n30 = 0;
                int n31 = this.numElements;
                while (n30 < n31) {
                    this.elements[n30].setCanBeMeasured(true);
                    ++n30;
                }
                break;
            }
            case 32: {
                int n32 = 0;
                while (n32 < this.numElements) {
                    this.elements[n32].getStyle().setExtraColor(this.defExtraColor);
                    ++n32;
                }
                break;
            }
        }
        if (this.isUnderEjs) {
            this.updatePanel();
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "1";
            }
            case 1: {
                return "-1";
            }
        }
        switch (n -= 2) {
            case 2: {
                return Double.toString(this.defaultElementX);
            }
            case 3: {
                return Double.toString(this.defaultElementY);
            }
            case 4: {
                return Double.toString(this.defaultElementZ);
            }
            case 5: {
                return Double.toString(this.defaultElementSizeX);
            }
            case 6: {
                return Double.toString(this.defaultElementSizeY);
            }
            case 7: {
                return Double.toString(this.defaultElementSizeZ);
            }
            case 10: {
                return this.defElementLines.toString();
            }
            case 12: {
                return this.defElementFill.toString();
            }
        }
        return super.getDefaultValueString(n);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return this.selectedValue;
            }
        }
        switch (n -= 2) {
            case 2: {
                return this.allposValues[0];
            }
            case 3: {
                return this.allposValues[1];
            }
            case 4: {
                return this.allposValues[2];
            }
            case 26: {
                return new ObjectValue(this.allThePos);
            }
            case 27: {
                return new ObjectValue(this.allTheSizes);
            }
            case 5: {
                return this.allsizesValues[0];
            }
            case 6: {
                return this.allsizesValues[1];
            }
            case 7: {
                return this.allsizesValues[2];
            }
        }
        return super.getValue(n);
    }

    protected void propagatePosition(ControlElement3D controlElement3D, int n) {
        this.theXs[n] = this.elements[n].getX();
        this.theYs[n] = this.elements[n].getY();
        this.theZs[n] = this.elements[n].getZ();
        if (this.allThePos != null) {
            this.allThePos[n][0] = this.theXs[n];
            this.allThePos[n][1] = this.theYs[n];
            this.allThePos[n][2] = this.theZs[n];
            ObjectValue objectValue = new ObjectValue(this.allThePos);
            this.variableChanged(this.getFullPositionSpot(), objectValue);
            if (this != controlElement3D) {
                controlElement3D.variableChanged(controlElement3D.getFullPositionSpot(), objectValue);
            }
            if (this.isUnderEjs) {
                this.setFieldListValue(this.getFullPositionSpot(), objectValue);
            }
        } else {
            this.variablesChanged(this.getPosSpot(), this.allposValues);
            if (this != controlElement3D) {
                controlElement3D.variablesChanged(controlElement3D.getPosSpot(), this.allposValues);
            }
            if (this.isUnderEjs) {
                this.setFieldListValues(this.getPosSpot(), this.allposValues);
            }
        }
    }

    protected void propagateSize(ControlElement3D controlElement3D, int n) {
        this.theSizeXs[n] = this.elements[n].getSizeX();
        this.theSizeYs[n] = this.elements[n].getSizeY();
        this.theSizeZs[n] = this.elements[n].getSizeZ();
        if (this.allTheSizes != null) {
            this.allTheSizes[n][0] = this.theSizeXs[n];
            this.allTheSizes[n][1] = this.theSizeYs[n];
            this.allTheSizes[n][2] = this.theSizeZs[n];
            ObjectValue objectValue = new ObjectValue(this.allTheSizes);
            if (this != controlElement3D) {
                controlElement3D.variableChanged(controlElement3D.getFullSizeSpot(), objectValue);
            }
            if (this.isUnderEjs) {
                this.setFieldListValue(this.getFullSizeSpot(), objectValue);
            }
        } else {
            this.variablesChanged(this.getSizeSpot(), this.allsizesValues);
            if (this != controlElement3D) {
                controlElement3D.variablesChanged(controlElement3D.getSizeSpot(), this.allsizesValues);
            }
            if (this.isUnderEjs) {
                this.setFieldListValues(this.getSizeSpot(), this.allsizesValues);
            }
        }
    }

    private void reportMouseMotion(Object object, int n) {
        InteractionTarget interactionTarget = (InteractionTarget)object;
        ControlGroup3D controlGroup3D = this.getControlGroup();
        if (interactionTarget == this.elements[n].getInteractionTarget(0)) {
            if (interactionTarget.getAffectsGroup() && controlGroup3D != null) {
                controlGroup3D.propagatePosition(this);
            } else {
                this.propagatePosition(this, n);
            }
        } else if (interactionTarget == this.elements[n].getInteractionTarget(1)) {
            if (interactionTarget.getAffectsGroup() && controlGroup3D != null) {
                controlGroup3D.propagateSize(this);
            } else {
                this.propagateSize(this, n);
            }
        }
    }

    protected int getElementInteracted(InteractionEvent interactionEvent) {
        Element element = (Element)interactionEvent.getSource();
        int n = 0;
        while (n < this.numElements) {
            if (this.elements[n] == element) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public void interactionPerformed(InteractionEvent interactionEvent) {
        switch (interactionEvent.getID()) {
            case 2003: {
                this.selectedValue.value = this.getElementInteracted(interactionEvent);
                this.variableChanged(1 + this.getPropertiesDisplacement(), this.selectedValue);
                this.invokeActions(31);
                break;
            }
            case 2004: {
                this.invokeActions(32);
                this.variableChanged(1 + this.getPropertiesDisplacement(), this.selectedValue);
                break;
            }
            case 2000: {
                this.selectedElement = this.selectedValue.value = this.getElementInteracted(interactionEvent);
                this.variableChanged(1 + this.getPropertiesDisplacement(), this.selectedValue);
                this.reportMouseMotion(interactionEvent.getInfo(), this.selectedValue.value);
                this.invokeActions(10);
                break;
            }
            case 2001: {
                this.reportMouseMotion(interactionEvent.getInfo(), this.selectedElement);
                break;
            }
            case 2002: {
                this.invokeActions(0);
                this.variableChanged(1 + this.getPropertiesDisplacement(), this.selectedValue);
            }
        }
    }
}

