/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d;

import java.awt.Color;
import org.opensourcephysics.display3d.core.Element;
import org.opensourcephysics.display3d.core.Group;
import org.opensourcephysics.display3d.core.Style;
import org.opensourcephysics.display3d.factory.OSP3DFactory;

public class VectorField {
    public static final int ARROW = 0;
    public static final int SEGMENT = 1;
    public static final int SOUTH_WEST = 0;
    public static final int CENTERED = 1;
    public static final int NORTH_EAST = 2;
    protected double minimumX = -1.0;
    protected double maximumX = 1.0;
    protected double minimumY = -1.0;
    protected double maximumY = 1.0;
    protected double minimumZ = -1.0;
    protected double maximumZ = 1.0;
    protected double vectorSizeX = 1.0;
    protected double vectorSizeY = 1.0;
    protected double vectorSizeZ = 1.0;
    protected double vectorAlpha = Double.NaN;
    protected double vectorBeta = Double.NaN;
    protected double vectorMagnitude = Double.NaN;
    protected double[][][] vectorSizeXData;
    protected double[][][] vectorSizeYData;
    protected double[][][] vectorSizeZData;
    protected double[][][] vectorAlphaData;
    protected double[][][] vectorBetaData;
    protected double[][][] vectorMagnitudeData;
    protected boolean autoscaleMagnitude = false;
    protected double constantLength = Double.NaN;
    protected int offset = 1;
    protected int arrowType = 0;
    protected int levels = -1;
    protected int invisibleLevel = -1;
    protected Color maxColor = Color.RED;
    protected Color minColor = Color.BLUE;
    private Group group = OSP3DFactory.Group();
    private boolean positionChanged = true;
    private boolean sizeChanged = true;
    private boolean magChanged = true;
    protected double magConstant = 0.0;
    protected double minMagnitude = 0.0;
    protected double maxMagnitude = 1.0;
    protected Color[] colors;
    protected double[][][] vectorLength;
    protected int nX = -1;
    protected int nY = -1;
    protected int nZ = -1;
    protected int tmp_nX = -1;
    protected int tmp_nY = -1;
    protected int tmp_nZ = -1;

    public VectorField() {
        this.setNumberOfLevels(16);
    }

    public Group getGroup() {
        return this.group;
    }

    public void setMinimumX(double d) {
        if (d != this.minimumX) {
            this.minimumX = d;
            this.positionChanged = true;
        }
    }

    public void setMaximumX(double d) {
        if (d != this.maximumX) {
            this.maximumX = d;
            this.positionChanged = true;
        }
    }

    public void setMinimumY(double d) {
        if (d != this.minimumY) {
            this.minimumY = d;
            this.positionChanged = true;
        }
    }

    public void setMaximumY(double d) {
        if (d != this.maximumY) {
            this.maximumY = d;
            this.positionChanged = true;
        }
    }

    public void setMinimumZ(double d) {
        if (d != this.minimumZ) {
            this.minimumZ = d;
            this.positionChanged = true;
        }
    }

    public void setMaximumZ(double d) {
        if (d != this.maximumZ) {
            this.maximumZ = d;
            this.positionChanged = true;
        }
    }

    public void setVectorSizeXData(double[][][] dArray) {
        this.vectorSizeXData = dArray;
        this.sizeChanged = true;
        this.checkArrays();
    }

    public void setVectorSizeX(double d) {
        if (this.vectorSizeX != d) {
            this.vectorSizeX = d;
            this.sizeChanged = true;
        }
    }

    public void setVectorSizeYData(double[][][] dArray) {
        this.vectorSizeYData = dArray;
        this.sizeChanged = true;
        this.checkArrays();
    }

    public void setVectorSizeY(double d) {
        if (this.vectorSizeY != d) {
            this.vectorSizeY = d;
            this.sizeChanged = true;
        }
    }

    public void setVectorSizeZData(double[][][] dArray) {
        this.vectorSizeZData = dArray;
        this.sizeChanged = true;
        this.checkArrays();
    }

    public void setVectorSizeZ(double d) {
        if (this.vectorSizeZ != d) {
            this.vectorSizeZ = d;
            this.sizeChanged = true;
        }
    }

    public void setVectorAlphaData(double[][][] dArray) {
        this.vectorAlphaData = dArray;
        this.sizeChanged = true;
        this.checkArrays();
    }

    public void setVectorAlpha(double d) {
        if (this.vectorAlpha != d) {
            this.vectorAlpha = d;
            this.sizeChanged = true;
        }
    }

    public void setVectorBetaData(double[][][] dArray) {
        this.vectorBetaData = dArray;
        this.sizeChanged = true;
        this.checkArrays();
    }

    public void setVectorBeta(double d) {
        if (this.vectorBeta != d) {
            this.vectorBeta = d;
            this.sizeChanged = true;
        }
    }

    public void setConstantLength(double d) {
        if (this.constantLength != d) {
            this.constantLength = d;
            this.sizeChanged = true;
        }
    }

    public void setAutoscaleMagnitude(boolean bl) {
        if (this.autoscaleMagnitude != bl) {
            this.autoscaleMagnitude = bl;
            this.magChanged = true;
        }
    }

    public void setMagnitudeExtrema(double d, double d2) {
        if (this.autoscaleMagnitude) {
            this.autoscaleMagnitude = false;
            this.magChanged = true;
        }
        if (this.minMagnitude == d && this.maxMagnitude == d2) {
            return;
        }
        this.minMagnitude = d;
        this.maxMagnitude = d2;
        if (this.maxMagnitude == this.minMagnitude) {
            this.maxMagnitude = this.minMagnitude + 1.0;
        }
        this.magConstant = (double)this.levels / (this.maxMagnitude - this.minMagnitude);
        this.magChanged = true;
    }

    public double getMagnitudeMinimum() {
        return this.minMagnitude;
    }

    public double getMagnitudeMaximum() {
        return this.maxMagnitude;
    }

    public void setMagnitudeData(double[][][] dArray) {
        this.vectorMagnitudeData = dArray;
        this.magChanged = true;
        this.checkArrays();
    }

    public void setMagnitude(double d) {
        if (this.vectorMagnitude != d) {
            this.vectorMagnitude = d;
            this.magChanged = true;
        }
    }

    public void setNumberOfLevels(int n) {
        if (n == this.levels) {
            return;
        }
        this.magChanged = true;
        if (n <= 0) {
            this.levels = 0;
            return;
        }
        this.levels = n;
        this.colors = new Color[this.levels];
        this.initColors();
        this.magConstant = (double)this.levels / (this.maxMagnitude - this.minMagnitude);
    }

    public void setMinColor(Color color) {
        if (color.equals(this.minColor)) {
            return;
        }
        this.minColor = color;
        this.initColors();
        this.magChanged = true;
    }

    public void setMaxColor(Color color) {
        if (color.equals(this.maxColor)) {
            return;
        }
        this.maxColor = color;
        this.initColors();
        this.magChanged = true;
    }

    public void setInvisibleLevel(int n) {
        if (this.invisibleLevel != n) {
            this.invisibleLevel = n;
            this.magChanged = true;
        }
    }

    public void setArrowType(int n) {
        if (this.arrowType != n) {
            this.arrowType = n;
            this.setNumberOfElements(this.nX * this.nY * this.nZ);
        }
    }

    public void setOffset(int n) {
        if (this.offset != n) {
            this.offset = n;
            this.positionChanged = true;
        }
    }

    public double indexToX(int n) {
        if (n < 0 || n >= this.nX) {
            return Double.NaN;
        }
        if (this.nX == 1) {
            return (this.minimumX + this.maximumX) / 2.0;
        }
        return this.minimumX + (double)n * (this.maximumX - this.minimumX) / (double)(this.nX - 1);
    }

    public double indexToY(int n) {
        if (n < 0 || n >= this.nY) {
            return Double.NaN;
        }
        if (this.nY == 1) {
            return (this.minimumY + this.maximumY) / 2.0;
        }
        return this.minimumY + (double)n * (this.maximumY - this.minimumY) / (double)(this.nY - 1);
    }

    public double indexToZ(int n) {
        if (n < 0 || n >= this.nZ) {
            return Double.NaN;
        }
        if (this.nZ == 1) {
            return (this.minimumZ + this.maximumZ) / 2.0;
        }
        return this.minimumZ + (double)n * (this.maximumZ - this.minimumZ) / (double)(this.nZ - 1);
    }

    private void checkArraySize(double[][][] dArray) {
        if (dArray != null) {
            this.tmp_nX = Math.min(this.tmp_nX, dArray.length);
            this.tmp_nY = Math.min(this.tmp_nY, dArray[0].length);
            this.tmp_nZ = Math.min(this.tmp_nZ, dArray[0][0].length);
        }
    }

    private boolean checkArrays() {
        this.tmp_nZ = Integer.MAX_VALUE;
        this.tmp_nY = Integer.MAX_VALUE;
        this.tmp_nX = Integer.MAX_VALUE;
        this.checkArraySize(this.vectorSizeXData);
        this.checkArraySize(this.vectorSizeYData);
        this.checkArraySize(this.vectorSizeZData);
        this.checkArraySize(this.vectorAlphaData);
        this.checkArraySize(this.vectorBetaData);
        this.checkArraySize(this.vectorMagnitudeData);
        if (this.tmp_nX == Integer.MAX_VALUE) {
            this.tmp_nX = 0;
            this.nX = 0;
        }
        if (this.tmp_nY == Integer.MAX_VALUE) {
            this.tmp_nY = 0;
            this.nY = 0;
        }
        if (this.tmp_nZ == Integer.MAX_VALUE) {
            this.tmp_nZ = 0;
            this.nZ = 0;
        }
        if (this.tmp_nX <= 0 || this.tmp_nY <= 0 || this.tmp_nZ <= 0) {
            return false;
        }
        this.nX = this.tmp_nX;
        this.nY = this.tmp_nY;
        this.nZ = this.tmp_nZ;
        if (this.vectorLength == null || this.vectorLength.length != this.nX || this.vectorLength[0].length != this.nY || this.vectorLength[0][0].length != this.nZ) {
            this.vectorLength = new double[this.nX][this.nY][this.nZ];
        }
        if (this.nX * this.nY * this.nZ != this.group.getElements().size()) {
            this.setNumberOfElements(this.nX * this.nY * this.nZ);
        }
        return true;
    }

    private boolean isAngleSet() {
        if (this.vectorAlphaData == null && Double.isNaN(this.vectorAlpha)) {
            return false;
        }
        return this.vectorBetaData != null || !Double.isNaN(this.vectorBeta);
    }

    private boolean isMagnitudeSet() {
        return this.vectorMagnitudeData != null || !Double.isNaN(this.vectorMagnitude);
    }

    private void setNumberOfElements(int n) {
        Style style = null;
        if (this.group.getElements().size() > 0) {
            style = this.group.getElement(0).getStyle();
        }
        this.group.removeAllElements();
        int n2 = 0;
        while (n2 < n) {
            Element element;
            switch (this.arrowType) {
                default: {
                    element = OSP3DFactory.ElementArrow();
                    break;
                }
                case 1: {
                    element = OSP3DFactory.ElementSegment();
                }
            }
            if (style != null) {
                style.copyTo(element.getStyle());
            }
            this.group.addElement(element);
            ++n2;
        }
        this.magChanged = true;
        this.sizeChanged = true;
        this.positionChanged = true;
    }

    public boolean prepareField() {
        double d;
        int n;
        if (!this.group.isVisible()) {
            return false;
        }
        if (this.nX <= 0 || this.nY <= 0 || this.nZ <= 0) {
            return false;
        }
        if (this.sizeChanged) {
            int n2;
            if (this.vectorSizeXData != null || this.vectorSizeYData != null || this.vectorSizeZData != null || !this.isAngleSet()) {
                if (Double.isNaN(this.constantLength)) {
                    double d2 = this.vectorSizeX;
                    double d3 = this.vectorSizeY;
                    double d4 = this.vectorSizeZ;
                    int n3 = 0;
                    n2 = 0;
                    while (n3 < this.nX) {
                        int n4 = 0;
                        while (n4 < this.nY) {
                            n = 0;
                            while (n < this.nZ) {
                                if (this.vectorSizeXData != null) {
                                    d2 = this.vectorSizeXData[n3][n4][n];
                                }
                                if (this.vectorSizeYData != null) {
                                    d3 = this.vectorSizeYData[n3][n4][n];
                                }
                                if (this.vectorSizeZData != null) {
                                    d4 = this.vectorSizeZData[n3][n4][n];
                                }
                                this.vectorLength[n3][n4][n] = Math.sqrt(d2 * d2 + d3 * d3 + d4 * d4);
                                this.group.getElement(n2).setSizeXYZ(d2, d3, d4);
                                ++n;
                                ++n2;
                            }
                            ++n4;
                        }
                        ++n3;
                    }
                } else {
                    int n5 = 0;
                    int n6 = 0;
                    while (n5 < this.nX) {
                        int n7 = 0;
                        while (n7 < this.nY) {
                            int n8 = 0;
                            while (n8 < this.nZ) {
                                double d5 = this.vectorSizeX;
                                double d6 = this.vectorSizeY;
                                double d7 = this.vectorSizeZ;
                                if (this.vectorSizeXData != null) {
                                    d5 = this.vectorSizeXData[n5][n7][n8];
                                }
                                if (this.vectorSizeYData != null) {
                                    d6 = this.vectorSizeYData[n5][n7][n8];
                                }
                                if (this.vectorSizeZData != null) {
                                    d7 = this.vectorSizeZData[n5][n7][n8];
                                }
                                if ((d = (this.vectorLength[n5][n7][n8] = Math.sqrt(d5 * d5 + d6 * d6 + d7 * d7))) == 0.0) {
                                    d7 = 0.0;
                                    d6 = 0.0;
                                    d5 = 0.0;
                                } else {
                                    d = this.constantLength / d;
                                    d5 *= d;
                                    d6 *= d;
                                    d7 *= d;
                                }
                                this.group.getElement(n6).setSizeXYZ(d5, d6, d7);
                                ++n8;
                                ++n6;
                            }
                            ++n7;
                        }
                        ++n5;
                    }
                }
            } else {
                double d8 = this.vectorAlpha;
                double d9 = this.vectorBeta;
                int n9 = 0;
                int n10 = 0;
                while (n9 < this.nX) {
                    int n11 = 0;
                    while (n11 < this.nY) {
                        n2 = 0;
                        while (n2 < this.nZ) {
                            if (this.vectorAlphaData != null) {
                                d8 = this.vectorAlphaData[n9][n11][n2];
                            }
                            if (this.vectorBetaData != null) {
                                d9 = this.vectorBetaData[n9][n11][n2];
                            }
                            this.vectorLength[n9][n11][n2] = this.constantLength;
                            this.group.getElement(n10).setSizeXYZ(this.constantLength * Math.cos(d8) * Math.cos(d9), this.constantLength * Math.sin(d8) * Math.cos(d9), this.constantLength * Math.sin(d9));
                            ++n2;
                            ++n10;
                        }
                        ++n11;
                    }
                    ++n9;
                }
            }
            if (!this.isMagnitudeSet()) {
                this.magChanged = true;
            }
        }
        if (this.positionChanged) {
            double d10 = this.nX > 1 ? (this.maximumX - this.minimumX) / (double)(this.nX - 1) : 0.0;
            double d11 = this.nY > 1 ? (this.maximumY - this.minimumY) / (double)(this.nY - 1) : 0.0;
            double d12 = this.nZ > 1 ? (this.maximumZ - this.minimumZ) / (double)(this.nZ - 1) : 0.0;
            double d13 = this.nX > 1 ? this.minimumX : (this.minimumX + this.maximumX) / 2.0;
            switch (this.offset) {
                default: {
                    int n12 = 0;
                    n = 0;
                    while (n12 < this.nX) {
                        d = this.nY > 1 ? this.minimumY : (this.minimumY + this.maximumY) / 2.0;
                        int n13 = 0;
                        while (n13 < this.nY) {
                            double d14 = this.nZ > 1 ? this.minimumZ : (this.minimumZ + this.maximumZ) / 2.0;
                            int n14 = 0;
                            while (n14 < this.nZ) {
                                this.group.getElement(n).setXYZ(d13, d, d14);
                                ++n14;
                                ++n;
                                d14 += d12;
                            }
                            ++n13;
                            d += d11;
                        }
                        ++n12;
                        d13 += d10;
                    }
                    break;
                }
                case 1: {
                    int n15 = 0;
                    n = 0;
                    while (n15 < this.nX) {
                        d = this.nY > 1 ? this.minimumY : (this.minimumY + this.maximumY) / 2.0;
                        int n16 = 0;
                        while (n16 < this.nY) {
                            double d15 = this.nZ > 1 ? this.minimumZ : (this.minimumZ + this.maximumZ) / 2.0;
                            int n17 = 0;
                            while (n17 < this.nZ) {
                                Element element = this.group.getElement(n);
                                element.setXYZ(d13 - element.getSizeX() / 2.0, d - element.getSizeY() / 2.0, d15 - element.getSizeZ() / 2.0);
                                ++n17;
                                ++n;
                                d15 += d12;
                            }
                            ++n16;
                            d += d11;
                        }
                        ++n15;
                        d13 += d10;
                    }
                    break;
                }
                case 0: {
                    int n18 = 0;
                    n = 0;
                    while (n18 < this.nX) {
                        d = this.nY > 1 ? this.minimumY : (this.minimumY + this.maximumY) / 2.0;
                        int n19 = 0;
                        while (n19 < this.nY) {
                            double d16 = this.nZ > 1 ? this.minimumZ : (this.minimumZ + this.maximumZ) / 2.0;
                            int n20 = 0;
                            while (n20 < this.nZ) {
                                Element element = this.group.getElement(n);
                                element.setXYZ(d13 - element.getSizeX(), d - element.getSizeY(), d16 - element.getSizeZ());
                                ++n20;
                                ++n;
                                d16 += d12;
                            }
                            ++n19;
                            d += d11;
                        }
                        ++n18;
                        d13 += d10;
                    }
                    break block0;
                }
            }
        }
        if (this.magChanged) {
            this.processMagnitude();
        }
        this.magChanged = false;
        this.sizeChanged = false;
        this.positionChanged = false;
        return true;
    }

    private void processMagnitude() {
        Object object;
        if (this.levels > 0) {
            double[][][] dArray = object = this.isMagnitudeSet() ? this.vectorMagnitudeData : this.vectorLength;
            if (object != null) {
                if (this.autoscaleMagnitude) {
                    this.computeMagnitudeExtrema((double[][][])object);
                }
                int n = 0;
                int n2 = 0;
                while (n < this.nX) {
                    int n3 = 0;
                    while (n3 < this.nY) {
                        int n4 = 0;
                        while (n4 < this.nZ) {
                            Element element = this.group.getElement(n2);
                            Color color = this.magToColor(object[n][n3][n4]);
                            if (color == null) {
                                element.setVisible(false);
                            } else {
                                element.setVisible(true);
                                element.getStyle().setLineColor(color);
                                element.getStyle().setFillColor(color);
                            }
                            ++n4;
                            ++n2;
                        }
                        ++n3;
                    }
                    ++n;
                }
                return;
            }
        }
        object = Double.isNaN(this.vectorMagnitude) ? this.minColor : this.magToColor(this.vectorMagnitude);
        int n = 0;
        int n5 = 0;
        while (n < this.nX) {
            int n6 = 0;
            while (n6 < this.nY) {
                int n7 = 0;
                while (n7 < this.nZ) {
                    Element element = this.group.getElement(n5);
                    element.setVisible(true);
                    element.getStyle().setLineColor((Color)object);
                    element.getStyle().setFillColor((Color)object);
                    ++n7;
                    ++n5;
                }
                ++n6;
            }
            ++n;
        }
    }

    private void computeMagnitudeExtrema(double[][][] dArray) {
        if (dArray == null) {
            return;
        }
        this.minMagnitude = Double.POSITIVE_INFINITY;
        this.maxMagnitude = Double.NEGATIVE_INFINITY;
        int n = 0;
        while (n < dArray.length) {
            double[][] dArray2 = dArray[n];
            int n2 = 0;
            while (n2 < dArray2.length) {
                double[] dArray3 = dArray2[n2];
                int n3 = 0;
                while (n3 < dArray3.length) {
                    this.minMagnitude = Math.min(this.minMagnitude, dArray3[n3]);
                    this.maxMagnitude = Math.max(this.minMagnitude, dArray3[n3]);
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        this.magConstant = (double)this.levels / (this.maxMagnitude - this.minMagnitude);
    }

    private void initColors() {
        int n = this.minColor.getRed();
        int n2 = this.minColor.getGreen();
        int n3 = this.minColor.getBlue();
        int n4 = this.minColor.getAlpha();
        int n5 = this.maxColor.getRed();
        int n6 = this.maxColor.getGreen();
        int n7 = this.maxColor.getBlue();
        int n8 = this.maxColor.getAlpha();
        int n9 = 0;
        while (n9 < this.levels) {
            int n10 = (int)((float)n + (float)((n5 - n) * n9) * 1.0f / (float)(this.levels - 1));
            int n11 = (int)((float)n2 + (float)((n6 - n2) * n9) * 1.0f / (float)(this.levels - 1));
            int n12 = (int)((float)n3 + (float)((n7 - n3) * n9) * 1.0f / (float)(this.levels - 1));
            int n13 = (int)((float)n4 + (float)((n8 - n4) * n9) * 1.0f / (float)(this.levels - 1));
            this.colors[n9] = new Color(n10, n11, n12, n13);
            ++n9;
        }
    }

    private Color magToColor(double d) {
        if (this.colors == null || this.levels == 0) {
            return this.minColor;
        }
        int n = (int)(this.magConstant * (d - this.minMagnitude));
        if (this.invisibleLevel >= 0 && n <= this.invisibleLevel) {
            return null;
        }
        if (n <= 0) {
            return this.colors[0];
        }
        if (n >= this.levels) {
            return this.colors[this.levels - 1];
        }
        return this.colors[n];
    }
}

