/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.simple3d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.display3d.core.ElementTrail;
import org.opensourcephysics.display3d.simple3d.Element;
import org.opensourcephysics.display3d.simple3d.Object3D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementTrail
extends Element
implements org.opensourcephysics.display3d.core.ElementTrail {
    private boolean connected = true;
    private int maximum = 0;
    private String[] inputLabels = new String[]{"x", "y", "z"};
    private TrailPoint[] points = null;
    protected ArrayList<TrailPoint> list = new ArrayList();
    private TrailPoint ghostPoint = new TrailPoint(Double.NaN, Double.NaN, Double.NaN, true);
    protected int datasetID = this.hashCode();

    @Override
    public void addPoint(double d, double d2, double d3) {
        this.addPoint(d, d2, d3, this.connected);
    }

    @Override
    public void addPoint(double[] dArray) {
        this.addPoint(dArray[0], dArray[1], dArray[2], this.connected);
    }

    @Override
    public void moveToPoint(double d, double d2, double d3) {
        this.addPoint(d, d2, d3, false);
    }

    @Override
    public void setMaximumPoints(int n) {
        this.maximum = n;
    }

    @Override
    public int getMaximumPoints() {
        return this.maximum;
    }

    @Override
    public void setConnected(boolean bl) {
        this.connected = bl;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void clear() {
        ArrayList<TrailPoint> arrayList = this.list;
        synchronized (arrayList) {
            this.list.clear();
        }
        this.points = new TrailPoint[0];
        this.ghostPoint.xp = Double.NaN;
    }

    @Override
    public void setXLabel(String string) {
        this.inputLabels[0] = string;
    }

    @Override
    public void setYLabel(String string) {
        this.inputLabels[1] = string;
    }

    @Override
    public void setZLabel(String string) {
        this.inputLabels[2] = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPoint(double d, double d2, double d3, boolean bl) {
        ArrayList<TrailPoint> arrayList = this.list;
        synchronized (arrayList) {
            if (this.maximum > 0 && this.list.size() >= this.maximum) {
                this.list.remove(0);
            }
            TrailPoint trailPoint = new TrailPoint(d, d2, d3, bl);
            this.list.add(trailPoint);
            if (this.getDrawingPanel3D() != null) {
                trailPoint.transformAndProject();
            }
        }
    }

    public int getNumberOfPoints() {
        return this.list.size();
    }

    @Override
    public void setGhostPoint(double[] dArray, boolean bl) {
        if (dArray == null) {
            this.ghostPoint.xp = Double.NaN;
        } else {
            this.ghostPoint.xp = dArray[0];
            this.ghostPoint.yp = dArray[1];
            this.ghostPoint.zp = dArray[2];
            this.ghostPoint.connected = bl;
            if (this.getDrawingPanel3D() != null) {
                this.ghostPoint.transformAndProject();
            }
        }
    }

    private void preparePoints() {
        boolean bl = !Double.isNaN(this.ghostPoint.xp);
        int n = bl ? this.list.size() + 1 : this.list.size();
        this.points = new TrailPoint[n];
        int n2 = 0;
        Iterator<TrailPoint> iterator = this.list.iterator();
        while (iterator.hasNext()) {
            TrailPoint trailPoint;
            this.points[n2] = trailPoint = iterator.next();
            trailPoint.setIndex(n2);
            ++n2;
        }
        if (bl) {
            this.points[n2] = this.ghostPoint;
            this.ghostPoint.setIndex(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object3D[] getObjects3D() {
        ArrayList<TrailPoint> arrayList = this.list;
        synchronized (arrayList) {
            block7: {
                if (this.isReallyVisible() && this.list.size() > 0) break block7;
                return null;
            }
            this.preparePoints();
        }
        if (this.hasChanged()) {
            this.transformAndProjectPoints();
        } else if (this.needsToProject()) {
            this.projectPoints();
        }
        return this.points;
    }

    @Override
    void draw(Graphics2D graphics2D, int n) {
        TrailPoint trailPoint = this.points[n];
        Color color = this.getDrawingPanel3D().projectColor(this.getRealStyle().getLineColor(), trailPoint.getDistance());
        graphics2D.setStroke(this.getRealStyle().getLineStroke());
        graphics2D.setColor(color);
        if (n == 0 || !trailPoint.connected) {
            graphics2D.drawLine((int)trailPoint.pixel[0], (int)trailPoint.pixel[1], (int)trailPoint.pixel[0], (int)trailPoint.pixel[1]);
        } else {
            TrailPoint trailPoint2 = this.points[n - 1];
            graphics2D.drawLine((int)trailPoint.pixel[0], (int)trailPoint.pixel[1], (int)trailPoint2.pixel[0], (int)trailPoint2.pixel[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void drawQuickly(Graphics2D graphics2D) {
        Object object = this.list;
        synchronized (object) {
            if (!this.isReallyVisible() || this.list.size() <= 0) {
                return;
            }
            this.preparePoints();
        }
        if (this.hasChanged()) {
            this.transformAndProjectPoints();
        } else if (this.needsToProject()) {
            this.projectPoints();
        }
        graphics2D.setStroke(this.getRealStyle().getLineStroke());
        graphics2D.setColor(this.getRealStyle().getLineColor());
        object = this.points[0];
        int n = (int)((TrailPoint)object).pixel[0];
        int n2 = (int)((TrailPoint)object).pixel[1];
        graphics2D.drawLine(n, n2, n, n2);
        int n3 = 1;
        int n4 = this.points.length;
        while (n3 < n4) {
            object = this.points[n3];
            if (((TrailPoint)object).connected) {
                graphics2D.drawLine((int)((TrailPoint)object).pixel[0], (int)((TrailPoint)object).pixel[1], n, n2);
            } else {
                graphics2D.drawLine((int)((TrailPoint)object).pixel[0], (int)((TrailPoint)object).pixel[1], (int)((TrailPoint)object).pixel[0], (int)((TrailPoint)object).pixel[1]);
            }
            n = (int)((TrailPoint)object).pixel[0];
            n2 = (int)((TrailPoint)object).pixel[1];
            ++n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getExtrema(double[] dArray, double[] dArray2) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        double d5 = Double.POSITIVE_INFINITY;
        double d6 = Double.NEGATIVE_INFINITY;
        double[] dArray3 = new double[3];
        ArrayList<TrailPoint> arrayList = this.list;
        synchronized (arrayList) {
            if (!this.isReallyVisible() || this.list.size() <= 0) {
                return;
            }
            this.preparePoints();
        }
        int n = 0;
        int n2 = this.points.length;
        while (n < n2) {
            dArray3[0] = this.points[n].xp;
            dArray3[1] = this.points[n].yp;
            dArray3[2] = this.points[n].zp;
            this.sizeAndToSpaceFrame(dArray3);
            d = Math.min(d, dArray3[0]);
            d2 = Math.max(d2, dArray3[0]);
            d3 = Math.min(d3, dArray3[1]);
            d4 = Math.max(d4, dArray3[1]);
            d5 = Math.min(d5, dArray3[2]);
            d6 = Math.max(d6, dArray3[2]);
            ++n;
        }
        dArray[0] = d;
        dArray2[0] = d2;
        dArray[1] = d3;
        dArray2[1] = d4;
        dArray[2] = d5;
        dArray2[2] = d6;
    }

    synchronized void transformAndProjectPoints() {
        int n = 0;
        int n2 = this.points.length;
        while (n < n2) {
            this.points[n].transformAndProject();
            ++n;
        }
        this.setNeedToProject(false);
        this.setElementChanged(false);
    }

    synchronized void projectPoints() {
        int n = 0;
        int n2 = this.points.length;
        while (n < n2) {
            this.points[n].transformAndProject();
            ++n;
        }
        this.setNeedToProject(false);
    }

    @Override
    public void setID(int n) {
        this.datasetID = n;
    }

    @Override
    public int getID() {
        return this.datasetID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[][] getData2D() {
        Object object = this.list;
        synchronized (object) {
            this.preparePoints();
        }
        object = new double[3][this.points.length];
        int n = 0;
        int n2 = this.points.length;
        while (n < n2) {
            object[0][n] = this.points[n].xp;
            object[1][n] = this.points[n].yp;
            object[2][n] = this.points[n].zp;
            ++n;
        }
        return object;
    }

    @Override
    public double[][][] getData3D() {
        return null;
    }

    @Override
    public String[] getColumnNames() {
        return this.inputLabels;
    }

    @Override
    public Color[] getLineColors() {
        return new Color[]{DisplayColors.getLineColor(0), DisplayColors.getLineColor(1), DisplayColors.getLineColor(2)};
    }

    @Override
    public Color[] getFillColors() {
        return new Color[]{this.getStyle().getFillColor(), this.getStyle().getFillColor(), this.getStyle().getFillColor()};
    }

    @Override
    public List<Data> getDataList() {
        return null;
    }

    @Override
    public ArrayList<Dataset> getDatasets() {
        return null;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends ElementTrail.Loader {
        private Loader() {
        }

        public Object createObject(XMLControl xMLControl) {
            return new ElementTrail();
        }
    }

    private class TrailPoint
    extends Object3D {
        boolean connected;
        private double xp;
        private double yp;
        private double zp;
        private double[] coordinates;
        double[] pixel;

        TrailPoint(double d, double d2, double d3, boolean bl) {
            super(ElementTrail.this, -1);
            this.coordinates = new double[3];
            this.pixel = new double[3];
            switch (ElementTrail.this.getAxesMode()) {
                case 0: {
                    this.xp = d;
                    this.yp = d2;
                    this.zp = d3;
                    break;
                }
                case 2: {
                    this.xp = d;
                    this.zp = d2;
                    this.yp = d3;
                    break;
                }
                case 1: {
                    this.yp = d;
                    this.xp = d2;
                    this.zp = d3;
                    break;
                }
                case 3: {
                    this.zp = d;
                    this.xp = d2;
                    this.yp = d3;
                    break;
                }
                case 5: {
                    this.yp = d;
                    this.zp = d2;
                    this.xp = d3;
                    break;
                }
                case 4: {
                    this.zp = d;
                    this.yp = d2;
                    this.xp = d3;
                    break;
                }
                default: {
                    this.xp = d;
                    this.yp = d2;
                    this.zp = d3;
                }
            }
            this.connected = bl;
        }

        void transformAndProject() {
            this.coordinates[0] = this.xp;
            this.coordinates[1] = this.yp;
            this.coordinates[2] = this.zp;
            ElementTrail.this.sizeAndToSpaceFrame(this.coordinates);
            ElementTrail.this.getDrawingPanel3D().project(this.coordinates, this.pixel);
            super.setDistance(this.pixel[2] * ElementTrail.this.getStyle().getDepthFactor());
        }

        void project() {
            ElementTrail.this.getDrawingPanel3D().project(this.coordinates, this.pixel);
            super.setDistance(this.pixel[2] * ElementTrail.this.getStyle().getDepthFactor());
        }
    }
}

