/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.java3d;

import com.sun.j3d.utils.geometry.Cylinder;
import java.awt.Color;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import org.opensourcephysics.display3d.core.Resolution;
import org.opensourcephysics.display3d.java3d.Element;

public class ElementCylinder
extends Element
implements org.opensourcephysics.display3d.core.ElementCylinder {
    private boolean isClosedTop;
    private boolean isClosedBottom;
    private Cylinder cylinder;
    private TransformGroup tg;
    private BranchGroup bg;

    public ElementCylinder() {
        Transform3D transform3D = new Transform3D();
        transform3D.rotX(1.5707963267948966);
        Transform3D transform3D2 = new Transform3D();
        transform3D2.rotY(-1.5707963267948966);
        transform3D.mul(transform3D2);
        this.tg = new TransformGroup();
        this.tg.setCapability(14);
        this.tg.setCapability(13);
        this.tg.setTransform(transform3D);
        this.getStyle().setFillColor(Color.blue);
        this.getStyle().setResolution(new Resolution(20, 20, 0));
        this.getStyle().setDrawingLines(false);
        this.setNode((Node)this.tg);
        this.isClosedBottom = true;
        this.isClosedTop = true;
    }

    public void processChanges(int n) {
        super.processChanges(n);
        if ((n & 8) != 0) {
            int n2;
            int n3;
            if (this.cylinder != null) {
                this.tg.removeChild((Node)this.bg);
            }
            if (this.getStyle().getResolution().getType() == 1) {
                n3 = (int)Math.floor(Math.min(this.getSizeX(), this.getSizeZ()) / this.getStyle().getResolution().getMaxLength());
                n2 = (int)Math.floor(this.getSizeY() / this.getStyle().getResolution().getMaxLength());
            } else {
                n3 = this.getStyle().getResolution().getN2();
                n2 = this.getStyle().getResolution().getN3();
            }
            n3 = Math.max(3, n3);
            n2 = Math.max(1, n2);
            this.cylinder = new Cylinder(0.5f, 1.0f, 33, n3, n2, this.getAppearance());
            this.bg = new BranchGroup();
            this.bg.setCapability(17);
            this.bg.addChild((Node)this.cylinder);
            this.tg.addChild((Node)this.bg);
        }
    }

    public void setMinimumAngle(int n) {
    }

    public int getMinimumAngle() {
        return 0;
    }

    public void setMaximumAngle(int n) {
    }

    public int getMaximumAngle() {
        return 0;
    }

    public void setClosedBottom(boolean bl) {
        this.isClosedBottom = bl;
    }

    public boolean isClosedBottom() {
        return this.isClosedBottom;
    }

    public void setClosedTop(boolean bl) {
        this.isClosedTop = bl;
    }

    public boolean isClosedTop() {
        return this.isClosedTop;
    }

    public void setClosedLeft(boolean bl) {
    }

    public boolean isClosedLeft() {
        return true;
    }

    public void setClosedRight(boolean bl) {
    }

    public boolean isClosedRight() {
        return true;
    }
}

