/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.display3d;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.display3d.ControlElement3D;
import org.colos.ejs.library.control.display3d.ControlGroup3D;
import org.colos.ejs.library.control.display3d.ControlParentOfElement3D;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.ObjectValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display3d.core.Element;
import org.opensourcephysics.display3d.core.Resolution;
import org.opensourcephysics.display3d.core.Set;
import org.opensourcephysics.display3d.core.interaction.InteractionEvent;
import org.opensourcephysics.display3d.core.interaction.InteractionTarget;
import org.opensourcephysics.display3d.factory.OSP3DFactory;
import org.opensourcephysics.drawing3d.WrapsElement;
import org.opensourcephysics.numerics.Matrix3DTransformation;
import org.opensourcephysics.numerics.Transformation;
import org.opensourcephysics.tools.ToolForData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ControlSet3D
extends ControlElement3D {
    protected static final int NUM_ELEMENTS = 30;
    protected static final int ELEMENT_SELECTED = 31;
    protected Set set;
    protected Element[] elements;
    protected int numElements = 0;
    protected ObjectValue[] allposValues;
    protected ObjectValue[] allsizesValues;
    protected IntegerValue selectedValue = new IntegerValue(-1);
    protected double[] theXs;
    protected double[] theYs;
    protected double[] theZs;
    protected double[] theSizeXs;
    protected double[] theSizeYs;
    protected double[] theSizeZs;
    protected double[][] allThePos;
    protected double[][] allTheSizes;
    protected double scalex = 1.0;
    protected double scaley = 1.0;
    protected double scalez = 1.0;
    protected double lineWidth = 1.0;
    protected Font font;
    protected Font defaultFont;
    protected boolean numberOfElements_isSet = false;
    private static List<String> infoList = null;
    int selectedElement = -1;

    public ControlSet3D() {
        this.setNumberOfElements(1);
    }

    @Override
    public String getObjectClassname() {
        return "org.opensourcephysics.display3d.core.Group";
    }

    @Override
    protected Element createElement() {
        this.set = OSP3DFactory.Set();
        return this.set;
    }

    protected abstract Element createAnElement();

    protected void copyAnElement(Element element, Element element2) {
        element.getStyle().copyTo(element2.getStyle());
        element2.setXYZ(element.getX(), element.getY(), element.getZ());
        element2.setSizeXYZ(element.getSizeX(), element.getSizeY(), element.getSizeZ());
        element2.setTransformation(element.getTransformation());
        element2.setVisible(element.isVisible());
        element2.getInteractionTarget(0).setEnabled(element.getInteractionTarget(0).isEnabled());
        element2.getInteractionTarget(0).setAffectsGroup(element.getInteractionTarget(0).getAffectsGroup());
        element2.getInteractionTarget(1).setEnabled(element.getInteractionTarget(1).isEnabled());
        element2.getInteractionTarget(1).setAffectsGroup(element.getInteractionTarget(1).getAffectsGroup());
    }

    protected void checkNumberOfElements(int n, boolean bl) {
        if (this.numElements >= n && !bl) {
            return;
        }
        this.setNumberOfElements(n);
    }

    public synchronized void setNumberOfElements(int n) {
        Element element;
        if (n == this.numElements || n < 1) {
            return;
        }
        Element[] elementArray = this.elements;
        this.elements = new Element[n];
        int n2 = 0;
        while (n2 < n) {
            this.elements[n2] = this.createAnElement();
            element = null;
            if (n2 < this.numElements) {
                element = elementArray[n2];
            } else if (elementArray != null) {
                element = elementArray[0];
            }
            if (element != null) {
                this.copyAnElement(element, this.elements[n2]);
            }
            ++n2;
        }
        this.set.removeAllElements();
        n2 = 0;
        while (n2 < n) {
            element = this.elements[n2] instanceof WrapsElement ? ((WrapsElement)((Object)this.elements[n2])).getElementWrapped() : this.elements[n2];
            this.set.addElement(element);
            ++n2;
        }
        this.theXs = new double[n];
        this.theYs = new double[n];
        this.theZs = new double[n];
        this.theSizeXs = new double[n];
        this.theSizeYs = new double[n];
        this.theSizeZs = new double[n];
        n2 = 0;
        while (n2 < n) {
            this.theXs[n2] = this.elements[n2].getX();
            this.theYs[n2] = this.elements[n2].getY();
            this.theZs[n2] = this.elements[n2].getZ();
            this.theSizeXs[n2] = this.elements[n2].getSizeX();
            this.theSizeYs[n2] = this.elements[n2].getSizeY();
            this.theSizeZs[n2] = this.elements[n2].getSizeZ();
            this.elements[n2].addInteractionListener(this);
            ++n2;
        }
        this.allposValues = new ObjectValue[3];
        this.allsizesValues = new ObjectValue[3];
        this.allposValues[0] = new ObjectValue(this.theXs);
        this.allposValues[1] = new ObjectValue(this.theYs);
        this.allposValues[2] = new ObjectValue(this.theZs);
        this.allsizesValues[0] = new ObjectValue(this.theSizeXs);
        this.allsizesValues[1] = new ObjectValue(this.theSizeYs);
        this.allsizesValues[2] = new ObjectValue(this.theSizeZs);
        this.numElements = n;
        elementArray = null;
    }

    public Element elementAt(int n) {
        return this.elements[n];
    }

    @Override
    public void addMenuEntries() {
        if (this.getMenuNameEntry() == null || !ToolForData.getTool().isFullTool()) {
            return;
        }
        this.getSimulation().addElementMenuEntries(this.getMenuNameEntry(), ControlSet3D.getDataInformationMenuEntries(null, this.set));
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("name");
            infoList.add("parent");
            infoList.add("x");
            infoList.add("y");
            infoList.add("z");
            infoList.add("sizeX");
            infoList.add("sizeY");
            infoList.add("sizeZ");
            infoList.add("transformation");
            infoList.add("visible");
            infoList.add("lineColor");
            infoList.add("lineWidth");
            infoList.add("fillColor");
            infoList.add("resolution");
            infoList.add("drawingFill");
            infoList.add("drawingLines");
            infoList.add("enabledPosition");
            infoList.add("movesGroup");
            infoList.add("enabledSize");
            infoList.add("resizesGroup");
            infoList.add("pressAction");
            infoList.add("dragAction");
            infoList.add("releaseAction");
            infoList.add("enteredAction");
            infoList.add("exitedAction");
            infoList.add("position");
            infoList.add("size");
            infoList.add("menuName");
            infoList.add("elementposition");
            infoList.add("depthFactor");
            infoList.add("numberOfElements");
            infoList.add("elementSelected");
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("name")) {
            return "String CONSTANT";
        }
        if (string.equals("parent")) {
            return "ControlElement CONSTANT";
        }
        if (string.equals("x")) {
            return "int|double|double[]";
        }
        if (string.equals("y")) {
            return "int|double|double[]";
        }
        if (string.equals("z")) {
            return "int|double|double[]";
        }
        if (string.equals("sizeX")) {
            return "int|double|double[]";
        }
        if (string.equals("sizeY")) {
            return "int|double|double[]";
        }
        if (string.equals("sizeZ")) {
            return "int|double|double[]";
        }
        if (string.equals("transformation")) {
            return "3DTransformation|double[]|String|Object";
        }
        if (string.equals("visible")) {
            return "boolean|boolean[]";
        }
        if (string.equals("lineColor")) {
            return "Color|Object|Object[]";
        }
        if (string.equals("lineWidth")) {
            return "int|double|double[]";
        }
        if (string.equals("fillColor")) {
            return "Color|Object|Object[]";
        }
        if (string.equals("resolution")) {
            return "3DResolution|String|Object|Object[]";
        }
        if (string.equals("drawingFill")) {
            return "boolean|boolean[]";
        }
        if (string.equals("drawingLines")) {
            return "boolean|boolean[]";
        }
        if (string.equals("enabledPosition")) {
            return "boolean|boolean[]";
        }
        if (string.equals("movesGroup")) {
            return "boolean|boolean[]";
        }
        if (string.equals("enabledSize")) {
            return "boolean|boolean[]";
        }
        if (string.equals("resizesGroup")) {
            return "boolean|boolean[]";
        }
        if (string.equals("pressAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("dragAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("releaseAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("enteredAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("exitedAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("position")) {
            return "double[][]";
        }
        if (string.equals("size")) {
            return "double[][]";
        }
        if (string.equals("menuName")) {
            return "String TRANSLATABLE";
        }
        if (string.equals("elementposition")) {
            return "ArrowPosition|int";
        }
        if (string.equals("depthFactor")) {
            return "double";
        }
        if (string.equals("numberOfElements")) {
            return "int PREVIOUS";
        }
        if (string.equals("elementSelected")) {
            return "int";
        }
        return null;
    }

    @Override
    public String getPropertyCommonName(String string) {
        if (string.equals("size")) {
            return "sizeArray";
        }
        return super.getPropertyCommonName(string);
    }

    @Override
    public ControlElement setProperty(String string, String string2) {
        string = string.trim();
        if (string2 != null) {
            boolean bl;
            boolean bl2 = bl = string2.startsWith("%_model.") && string2.endsWith("()%");
            if (string.equals("x")) {
                this.set.setXLabel(bl ? "x" : string2);
            } else if (string.equals("y")) {
                this.set.setYLabel(bl ? "y" : string2);
            } else if (string.equals("z")) {
                this.set.setYLabel(bl ? "z" : string2);
            }
        }
        return super.setProperty(string, string2);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 30: {
                this.setNumberOfElements(value.getInteger());
                this.numberOfElements_isSet = true;
                break;
            }
            case 31: {
                this.selectedValue.value = value.getInteger();
                break;
            }
            case 0: {
                this.getElement().setName(value.getString());
                super.setValue(0, value);
                break;
            }
            case 1: {
                ControlElement controlElement = this.myGroup.getElement(this.getProperty("parent"));
                if (controlElement != null) {
                    this.setParent(null);
                }
                if ((controlElement = this.myGroup.getElement(value.toString())) == null) {
                    System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Parent <" + value + "> not found for " + this.toString());
                    break;
                }
                if (controlElement instanceof ControlParentOfElement3D) {
                    this.setParent((ControlParentOfElement3D)((Object)controlElement));
                    break;
                }
                System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Parent <" + value + "> is not a ControlElements3DParent");
                break;
            }
            case 25: {
                if (!(value.getObject() instanceof double[][])) break;
                this.allThePos = (double[][])value.getObject();
                if (!this.numberOfElements_isSet) {
                    this.checkNumberOfElements(this.allThePos.length, false);
                }
                int n2 = 0;
                int n3 = Math.min(this.theXs.length, this.allThePos.length);
                while (n2 < n3) {
                    this.theXs[n2] = this.allThePos[n2][0];
                    this.elements[n2].setX(this.theXs[n2]);
                    ++n2;
                }
                if (this.allThePos[0].length > 1) {
                    n2 = 0;
                    n3 = Math.min(this.theYs.length, this.allThePos.length);
                    while (n2 < n3) {
                        this.theYs[n2] = this.allThePos[n2][1];
                        this.elements[n2].setY(this.theYs[n2]);
                        ++n2;
                    }
                }
                if (this.allThePos[0].length <= 2) break;
                n2 = 0;
                n3 = Math.min(this.theZs.length, this.allThePos.length);
                while (n2 < n3) {
                    this.theZs[n2] = this.allThePos[n2][2];
                    this.elements[n2].setZ(this.theZs[n2]);
                    ++n2;
                }
                break;
            }
            case 2: {
                this.allThePos = null;
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(dArray.length, false);
                    }
                    int n4 = 0;
                    int n5 = Math.min(this.theXs.length, dArray.length);
                    while (n4 < n5) {
                        this.theXs[n4] = dArray[n4];
                        this.elements[n4].setX(this.theXs[n4]);
                        ++n4;
                    }
                } else {
                    double d = value.getDouble();
                    int n6 = 0;
                    int n7 = this.theXs.length;
                    while (n6 < n7) {
                        this.theXs[n6] = d;
                        this.elements[n6].setX(this.theXs[n6]);
                        ++n6;
                    }
                }
                break;
            }
            case 3: {
                this.allThePos = null;
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(dArray.length, false);
                    }
                    int n8 = 0;
                    int n9 = Math.min(this.theYs.length, dArray.length);
                    while (n8 < n9) {
                        this.theYs[n8] = dArray[n8];
                        this.elements[n8].setY(this.theYs[n8]);
                        ++n8;
                    }
                } else {
                    double d = value.getDouble();
                    int n10 = 0;
                    int n11 = this.theYs.length;
                    while (n10 < n11) {
                        this.theYs[n10] = d;
                        this.elements[n10].setY(this.theYs[n10]);
                        ++n10;
                    }
                }
                break;
            }
            case 4: {
                this.allThePos = null;
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(dArray.length, false);
                    }
                    int n12 = 0;
                    int n13 = Math.min(this.theZs.length, dArray.length);
                    while (n12 < n13) {
                        this.theZs[n12] = dArray[n12];
                        this.elements[n12].setZ(this.theZs[n12]);
                        ++n12;
                    }
                } else {
                    double d = value.getDouble();
                    int n14 = 0;
                    int n15 = this.theZs.length;
                    while (n14 < n15) {
                        this.theZs[n14] = d;
                        this.elements[n14].setZ(this.theZs[n14]);
                        ++n14;
                    }
                }
                break;
            }
            case 26: {
                if (!(value.getObject() instanceof double[][])) break;
                this.allTheSizes = (double[][])value.getObject();
                if (!this.numberOfElements_isSet) {
                    this.checkNumberOfElements(this.allTheSizes.length, false);
                }
                int n16 = 0;
                int n17 = Math.min(this.theSizeXs.length, this.allTheSizes.length);
                while (n16 < n17) {
                    this.theSizeXs[n16] = this.allTheSizes[n16][0];
                    this.elements[n16].setSizeX(this.theSizeXs[n16]);
                    ++n16;
                }
                n16 = 0;
                n17 = Math.min(this.theSizeYs.length, this.allTheSizes.length);
                while (n16 < n17) {
                    this.theSizeYs[n16] = this.allTheSizes[n16][1];
                    this.elements[n16].setSizeY(this.theSizeYs[n16]);
                    ++n16;
                }
                n16 = 0;
                n17 = Math.min(this.theSizeZs.length, this.allTheSizes.length);
                while (n16 < n17) {
                    this.theSizeZs[n16] = this.allTheSizes[n16][2];
                    this.elements[n16].setSizeZ(this.theSizeZs[n16]);
                    ++n16;
                }
                break;
            }
            case 5: {
                this.allTheSizes = null;
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(dArray.length, false);
                    }
                    int n18 = 0;
                    int n19 = Math.min(this.theSizeXs.length, dArray.length);
                    while (n18 < n19) {
                        this.theSizeXs[n18] = dArray[n18];
                        this.elements[n18].setSizeX(this.theSizeXs[n18]);
                        ++n18;
                    }
                } else {
                    double d = value.getDouble();
                    int n20 = 0;
                    int n21 = this.theSizeXs.length;
                    while (n20 < n21) {
                        this.theSizeXs[n20] = d;
                        this.elements[n20].setSizeX(this.theSizeXs[n20]);
                        ++n20;
                    }
                }
                break;
            }
            case 6: {
                this.allTheSizes = null;
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(dArray.length, false);
                    }
                    int n22 = 0;
                    int n23 = Math.min(this.theSizeYs.length, dArray.length);
                    while (n22 < n23) {
                        this.theSizeYs[n22] = dArray[n22];
                        this.elements[n22].setSizeY(this.theSizeYs[n22]);
                        ++n22;
                    }
                } else {
                    double d = value.getDouble();
                    int n24 = 0;
                    int n25 = this.theSizeYs.length;
                    while (n24 < n25) {
                        this.theSizeYs[n24] = d;
                        this.elements[n24].setSizeY(this.theSizeYs[n24]);
                        ++n24;
                    }
                }
                break;
            }
            case 7: {
                this.allTheSizes = null;
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(dArray.length, false);
                    }
                    int n26 = 0;
                    int n27 = Math.min(this.theSizeZs.length, dArray.length);
                    while (n26 < n27) {
                        this.theSizeZs[n26] = dArray[n26];
                        this.elements[n26].setSizeZ(this.theSizeZs[n26]);
                        ++n26;
                    }
                } else {
                    double d = value.getDouble();
                    int n28 = 0;
                    int n29 = this.theSizeZs.length;
                    while (n28 < n29) {
                        this.theSizeZs[n28] = d;
                        this.elements[n28].setSizeZ(this.theSizeZs[n28]);
                        ++n28;
                    }
                }
                break;
            }
            case 8: {
                if (value.getObject() instanceof Transformation) {
                    Transformation transformation = (Transformation)value.getObject();
                    int n30 = 0;
                    while (n30 < this.numElements) {
                        this.elements[n30].setTransformation(transformation);
                        ++n30;
                    }
                } else if (value.getObject() instanceof Object[]) {
                    Object[] objectArray = (Object[])value.getObject();
                    int n31 = 0;
                    int n32 = Math.min(this.numElements, objectArray.length);
                    while (n31 < n32) {
                        this.elements[n31].setTransformation((Transformation)objectArray[n31]);
                        ++n31;
                    }
                } else {
                    if (!(value.getObject() instanceof double[])) break;
                    double[] dArray = (double[])value.getObject();
                    if (dArray.length == 6) {
                        double[] dArray2 = new double[]{dArray[0], dArray[1], dArray[2]};
                        double[] dArray3 = new double[]{dArray[3], dArray[4], dArray[5]};
                        Matrix3DTransformation matrix3DTransformation = Matrix3DTransformation.createAlignmentTransformation(dArray2, dArray3);
                        int n33 = 0;
                        while (n33 < this.numElements) {
                            this.elements[n33].setTransformation(matrix3DTransformation);
                            ++n33;
                        }
                    } else {
                        if (dArray.length != 4) break;
                        double[] dArray4 = new double[]{dArray[1], dArray[2], dArray[3]};
                        Matrix3DTransformation matrix3DTransformation = Matrix3DTransformation.rotation(dArray[0], dArray4);
                        int n34 = 0;
                        while (n34 < this.numElements) {
                            this.elements[n34].setTransformation(matrix3DTransformation);
                            ++n34;
                        }
                    }
                }
                break;
            }
            case 9: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n35 = 0;
                    int n36 = Math.min(this.numElements, blArray.length);
                    while (n35 < n36) {
                        this.elements[n35].setVisible(blArray[n35]);
                        ++n35;
                    }
                } else {
                    boolean bl = value.getBoolean();
                    int n37 = 0;
                    int n38 = this.numElements;
                    while (n37 < n38) {
                        this.elements[n37].setVisible(bl);
                        ++n37;
                    }
                }
                break;
            }
            case 10: {
                if (value.getObject() instanceof Object[]) {
                    Object[] objectArray = (Object[])value.getObject();
                    int n39 = 0;
                    int n40 = Math.min(this.numElements, objectArray.length);
                    while (n39 < n40) {
                        this.elements[n39].getStyle().setLineColor((Color)objectArray[n39]);
                        ++n39;
                    }
                } else {
                    if (!(value.getObject() instanceof Color)) break;
                    Color color = (Color)value.getObject();
                    int n41 = 0;
                    int n42 = this.numElements;
                    while (n41 < n42) {
                        this.elements[n41].getStyle().setLineColor(color);
                        ++n41;
                    }
                }
                break;
            }
            case 11: {
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    int n43 = 0;
                    int n44 = Math.min(this.numElements, dArray.length);
                    while (n43 < n44) {
                        this.elements[n43].getStyle().setLineWidth((float)dArray[n43]);
                        ++n43;
                    }
                } else {
                    float f = (float)value.getDouble();
                    int n45 = 0;
                    int n46 = this.numElements;
                    while (n45 < n46) {
                        this.elements[n45].getStyle().setLineWidth(f);
                        ++n45;
                    }
                }
                break;
            }
            case 12: {
                if (value.getObject() instanceof Object[]) {
                    Object[] objectArray = (Object[])value.getObject();
                    int n47 = 0;
                    int n48 = Math.min(this.numElements, objectArray.length);
                    while (n47 < n48) {
                        this.elements[n47].getStyle().setFillColor((Color)objectArray[n47]);
                        ++n47;
                    }
                } else {
                    if (!(value.getObject() instanceof Color)) break;
                    Color color = (Color)value.getObject();
                    int n49 = 0;
                    int n50 = this.numElements;
                    while (n49 < n50) {
                        this.elements[n49].getStyle().setFillColor(color);
                        ++n49;
                    }
                }
                break;
            }
            case 13: {
                if (value.getObject() instanceof Resolution) {
                    Resolution resolution = (Resolution)value.getObject();
                    int n51 = 0;
                    while (n51 < this.numElements) {
                        this.elements[n51].getStyle().setResolution(resolution);
                        ++n51;
                    }
                } else if (value.getObject() instanceof Object[]) {
                    Object[] objectArray = (Object[])value.getObject();
                    int n52 = 0;
                    int n53 = Math.min(this.numElements, objectArray.length);
                    while (n52 < n53) {
                        this.elements[n52].getStyle().setResolution((Resolution)objectArray[n52]);
                        ++n52;
                    }
                } else {
                    Resolution resolution = ControlSet3D.decodeResolution(value.toString());
                    if (resolution == null) break;
                    int n54 = 0;
                    while (n54 < this.numElements) {
                        this.elements[n54].getStyle().setResolution(resolution);
                        ++n54;
                    }
                }
                break;
            }
            case 14: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n55 = 0;
                    int n56 = Math.min(this.numElements, blArray.length);
                    while (n55 < n56) {
                        this.elements[n55].getStyle().setDrawingFill(blArray[n55]);
                        ++n55;
                    }
                } else {
                    boolean bl = value.getBoolean();
                    int n57 = 0;
                    int n58 = this.numElements;
                    while (n57 < n58) {
                        this.elements[n57].getStyle().setDrawingFill(bl);
                        ++n57;
                    }
                }
                break;
            }
            case 15: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n59 = 0;
                    int n60 = Math.min(this.numElements, blArray.length);
                    while (n59 < n60) {
                        this.elements[n59].getStyle().setDrawingLines(blArray[n59]);
                        ++n59;
                    }
                } else {
                    boolean bl = value.getBoolean();
                    int n61 = 0;
                    int n62 = this.numElements;
                    while (n61 < n62) {
                        this.elements[n61].getStyle().setDrawingLines(bl);
                        ++n61;
                    }
                }
                break;
            }
            case 16: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n63 = 0;
                    int n64 = Math.min(this.numElements, blArray.length);
                    while (n63 < n64) {
                        this.elements[n63].getInteractionTarget(0).setEnabled(blArray[n63]);
                        ++n63;
                    }
                } else {
                    boolean bl = value.getBoolean();
                    int n65 = 0;
                    int n66 = this.numElements;
                    while (n65 < n66) {
                        this.elements[n65].getInteractionTarget(0).setEnabled(bl);
                        ++n65;
                    }
                }
                break;
            }
            case 17: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n67 = 0;
                    int n68 = Math.min(this.numElements, blArray.length);
                    while (n67 < n68) {
                        this.elements[n67].getInteractionTarget(0).setAffectsGroup(blArray[n67]);
                        ++n67;
                    }
                } else {
                    boolean bl = value.getBoolean();
                    int n69 = 0;
                    int n70 = this.numElements;
                    while (n69 < n70) {
                        this.elements[n69].getInteractionTarget(0).setAffectsGroup(bl);
                        ++n69;
                    }
                }
                break;
            }
            case 18: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n71 = 0;
                    int n72 = Math.min(this.numElements, blArray.length);
                    while (n71 < n72) {
                        this.elements[n71].getInteractionTarget(1).setEnabled(blArray[n71]);
                        ++n71;
                    }
                } else {
                    boolean bl = value.getBoolean();
                    int n73 = 0;
                    int n74 = this.numElements;
                    while (n73 < n74) {
                        this.elements[n73].getInteractionTarget(1).setEnabled(bl);
                        ++n73;
                    }
                }
                break;
            }
            case 19: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n75 = 0;
                    int n76 = Math.min(this.numElements, blArray.length);
                    while (n75 < n76) {
                        this.elements[n75].getInteractionTarget(1).setAffectsGroup(blArray[n75]);
                        ++n75;
                    }
                } else {
                    boolean bl = value.getBoolean();
                    int n77 = 0;
                    int n78 = this.numElements;
                    while (n77 < n78) {
                        this.elements[n77].getInteractionTarget(1).setAffectsGroup(bl);
                        ++n77;
                    }
                }
                break;
            }
            case 20: {
                this.removeAction(10, this.getProperty("pressAction"));
                this.addAction(10, value.getString());
                break;
            }
            case 21: {
                this.removeAction(1, this.getProperty("dragAction"));
                this.addAction(1, value.getString());
                break;
            }
            case 22: {
                this.removeAction(0, this.getProperty("releaseAction"));
                this.addAction(0, value.getString());
                break;
            }
            case 23: {
                this.removeAction(31, this.getProperty("enteredAction"));
                this.addAction(31, value.getString());
                break;
            }
            case 24: {
                this.removeAction(32, this.getProperty("exitedAction"));
                this.addAction(32, value.getString());
                break;
            }
            case 27: {
                this.menuNameEntry = value.getString();
                break;
            }
            case 28: {
                if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n79 = 0;
                    int n80 = Math.min(this.numElements, nArray.length);
                    while (n79 < n80) {
                        if (this.elements[n79].getStyle().getRelativePosition() != nArray[n79]) {
                            this.elements[n79].getStyle().setRelativePosition(nArray[n79]);
                        }
                        ++n79;
                    }
                } else {
                    int n81 = value.getInteger();
                    int n82 = 0;
                    int n83 = this.numElements;
                    while (n82 < n83) {
                        if (this.elements[n82].getStyle().getRelativePosition() != n81) {
                            this.elements[n82].getStyle().setRelativePosition(n81);
                        }
                        ++n82;
                    }
                }
                break;
            }
            case 29: {
                double d = value.getDouble();
                int n84 = 0;
                int n85 = this.numElements;
                while (n84 < n85) {
                    if (this.elements[n84].getStyle().getDepthFactor() != d) {
                        this.elements[n84].getStyle().setDepthFactor(d);
                    }
                    ++n84;
                }
                break;
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 30: {
                this.setNumberOfElements(1);
                this.numberOfElements_isSet = false;
                break;
            }
            case 31: {
                this.selectedValue.value = -1;
                break;
            }
            case 0: {
                super.setDefaultValue(0);
                this.getElement().setName("");
                break;
            }
            case 1: {
                ControlElement controlElement = this.myGroup.getElement(this.getProperty("parent"));
                if (controlElement == null) break;
                this.setParent(null);
                break;
            }
            case 25: {
                this.allThePos = null;
                break;
            }
            case 2: {
                int n2 = 0;
                int n3 = this.theXs.length;
                while (n2 < n3) {
                    this.theXs[n2] = this.defaultX;
                    this.elements[n2].setX(this.theXs[n2]);
                    ++n2;
                }
                break;
            }
            case 3: {
                int n4 = 0;
                int n5 = this.theYs.length;
                while (n4 < n5) {
                    this.theYs[n4] = this.defaultY;
                    this.elements[n4].setY(this.theYs[n4]);
                    ++n4;
                }
                break;
            }
            case 4: {
                int n6 = 0;
                int n7 = this.theZs.length;
                while (n6 < n7) {
                    this.theZs[n6] = this.defaultZ;
                    this.elements[n6].setZ(this.theZs[n6]);
                    ++n6;
                }
                break;
            }
            case 26: {
                this.allTheSizes = null;
                break;
            }
            case 5: {
                int n8 = 0;
                int n9 = this.theSizeXs.length;
                while (n8 < n9) {
                    this.theSizeXs[n8] = this.defaultSizeX;
                    this.elements[n8].setSizeX(this.theSizeXs[n8]);
                    ++n8;
                }
                break;
            }
            case 6: {
                int n10 = 0;
                int n11 = this.theSizeYs.length;
                while (n10 < n11) {
                    this.theSizeYs[n10] = this.defaultSizeY;
                    this.elements[n10].setSizeY(this.theSizeYs[n10]);
                    ++n10;
                }
                break;
            }
            case 7: {
                int n12 = 0;
                int n13 = this.theSizeZs.length;
                while (n12 < n13) {
                    this.theSizeZs[n12] = this.defaultSizeZ;
                    this.elements[n12].setSizeZ(this.theSizeZs[n12]);
                    ++n12;
                }
                break;
            }
            case 8: {
                Matrix3DTransformation matrix3DTransformation = Matrix3DTransformation.rotationZ(0.0);
                int n14 = 0;
                while (n14 < this.numElements) {
                    this.elements[n14].setTransformation(matrix3DTransformation);
                    ++n14;
                }
                break;
            }
            case 9: {
                int n15 = 0;
                while (n15 < this.numElements) {
                    this.elements[n15].setVisible(true);
                    ++n15;
                }
                break;
            }
            case 10: {
                int n16 = 0;
                while (n16 < this.numElements) {
                    this.elements[n16].getStyle().setLineColor(this.defLines);
                    ++n16;
                }
                break;
            }
            case 11: {
                int n17 = 0;
                while (n17 < this.numElements) {
                    this.elements[n17].getStyle().setLineWidth(1.0f);
                    ++n17;
                }
                break;
            }
            case 12: {
                int n18 = 0;
                while (n18 < this.numElements) {
                    this.elements[n18].getStyle().setFillColor(this.defFill);
                    ++n18;
                }
                break;
            }
            case 13: {
                int n19 = 0;
                while (n19 < this.numElements) {
                    this.elements[n19].getStyle().setResolution(this.defaultRes);
                    ++n19;
                }
                break;
            }
            case 14: {
                int n20 = 0;
                while (n20 < this.numElements) {
                    this.elements[n20].getStyle().setDrawingFill(true);
                    ++n20;
                }
                break;
            }
            case 15: {
                int n21 = 0;
                while (n21 < this.numElements) {
                    this.elements[n21].getStyle().setDrawingLines(true);
                    ++n21;
                }
                break;
            }
            case 16: {
                int n22 = 0;
                while (n22 < this.numElements) {
                    this.elements[n22].getInteractionTarget(0).setEnabled(false);
                    ++n22;
                }
                break;
            }
            case 17: {
                int n23 = 0;
                while (n23 < this.numElements) {
                    this.elements[n23].getInteractionTarget(0).setAffectsGroup(false);
                    ++n23;
                }
                break;
            }
            case 18: {
                int n24 = 0;
                while (n24 < this.numElements) {
                    this.elements[n24].getInteractionTarget(1).setEnabled(false);
                    ++n24;
                }
                break;
            }
            case 19: {
                int n25 = 0;
                while (n25 < this.numElements) {
                    this.elements[n25].getInteractionTarget(1).setAffectsGroup(false);
                    ++n25;
                }
                break;
            }
            case 20: {
                this.removeAction(10, this.getProperty("pressAction"));
                break;
            }
            case 21: {
                this.removeAction(1, this.getProperty("dragAction"));
                break;
            }
            case 22: {
                this.removeAction(0, this.getProperty("releaseAction"));
                break;
            }
            case 23: {
                this.removeAction(31, this.getProperty("enteredAction"));
                break;
            }
            case 24: {
                this.removeAction(32, this.getProperty("exitedAction"));
                break;
            }
            case 27: {
                this.menuNameEntry = null;
                break;
            }
            case 28: {
                int n26 = 0;
                while (n26 < this.numElements) {
                    this.elements[n26].getStyle().setRelativePosition(5);
                    ++n26;
                }
                break;
            }
            case 29: {
                int n27 = 0;
                int n28 = this.numElements;
                while (n27 < n28) {
                    this.elements[n27].getStyle().setDepthFactor(1.0);
                    ++n27;
                }
                break;
            }
        }
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 25: {
                return new ObjectValue(this.allThePos);
            }
            case 2: {
                return this.allposValues[0];
            }
            case 3: {
                return this.allposValues[1];
            }
            case 4: {
                return this.allposValues[2];
            }
            case 26: {
                return new ObjectValue(this.allTheSizes);
            }
            case 5: {
                return this.allsizesValues[0];
            }
            case 6: {
                return this.allsizesValues[1];
            }
            case 7: {
                return this.allsizesValues[2];
            }
            case 31: {
                return this.selectedValue;
            }
        }
        return null;
    }

    protected void propagatePosition(ControlElement3D controlElement3D, int n) {
        this.theXs[n] = this.elements[n].getX();
        this.theYs[n] = this.elements[n].getY();
        this.theZs[n] = this.elements[n].getZ();
        if (this.allThePos != null) {
            this.allThePos[n][0] = this.theXs[n];
            this.allThePos[n][1] = this.theYs[n];
            this.allThePos[n][2] = this.theZs[n];
            ObjectValue objectValue = new ObjectValue(this.allThePos);
            this.variableChanged(this.getFullPositionSpot(), objectValue);
            if (this != controlElement3D) {
                controlElement3D.variableChanged(controlElement3D.getFullPositionSpot(), objectValue);
            }
            if (this.isUnderEjs) {
                this.setFieldListValue(this.getFullPositionSpot(), objectValue);
            }
        } else {
            this.variablesChanged(this.getPosSpot(), this.allposValues);
            if (this != controlElement3D) {
                controlElement3D.variablesChanged(controlElement3D.getPosSpot(), this.allposValues);
            }
            if (this.isUnderEjs) {
                this.setFieldListValues(this.getPosSpot(), this.allposValues);
            }
        }
    }

    protected void propagateSize(ControlElement3D controlElement3D, int n) {
        this.theSizeXs[n] = this.elements[n].getSizeX();
        this.theSizeYs[n] = this.elements[n].getSizeY();
        this.theSizeZs[n] = this.elements[n].getSizeZ();
        if (this.allTheSizes != null) {
            this.allTheSizes[n][0] = this.theSizeXs[n];
            this.allTheSizes[n][1] = this.theSizeYs[n];
            this.allTheSizes[n][2] = this.theSizeZs[n];
            ObjectValue objectValue = new ObjectValue(this.allTheSizes);
            if (this != controlElement3D) {
                controlElement3D.variableChanged(controlElement3D.getFullSizeSpot(), objectValue);
            }
            if (this.isUnderEjs) {
                this.setFieldListValue(this.getFullSizeSpot(), objectValue);
            }
        } else {
            this.variablesChanged(this.getSizeSpot(), this.allsizesValues);
            if (this != controlElement3D) {
                controlElement3D.variablesChanged(controlElement3D.getSizeSpot(), this.allsizesValues);
            }
            if (this.isUnderEjs) {
                this.setFieldListValues(this.getSizeSpot(), this.allsizesValues);
            }
        }
    }

    private void reportMouseMotion(Object object, int n) {
        InteractionTarget interactionTarget = (InteractionTarget)object;
        ControlGroup3D controlGroup3D = this.getControlGroup();
        if (interactionTarget == this.elements[n].getInteractionTarget(0)) {
            if (interactionTarget.getAffectsGroup() && controlGroup3D != null) {
                controlGroup3D.propagatePosition(this);
            } else {
                this.propagatePosition(this, n);
            }
        } else if (interactionTarget == this.elements[n].getInteractionTarget(1)) {
            if (interactionTarget.getAffectsGroup() && controlGroup3D != null) {
                controlGroup3D.propagateSize(this);
            } else {
                this.propagateSize(this, n);
            }
        }
    }

    protected int getElementInteracted(InteractionEvent interactionEvent) {
        Element element = (Element)interactionEvent.getSource();
        int n = 0;
        while (n < this.numElements) {
            if (this.elements[n] == element) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public void interactionPerformed(InteractionEvent interactionEvent) {
        switch (interactionEvent.getID()) {
            case 2003: {
                this.selectedValue.value = this.getElementInteracted(interactionEvent);
                this.variableChanged(31 + this.getPropertiesDisplacement(), this.selectedValue);
                this.invokeActions(31);
                break;
            }
            case 2004: {
                this.invokeActions(32);
                this.selectedValue.value = -1;
                this.variableChanged(31 + this.getPropertiesDisplacement(), this.selectedValue);
                break;
            }
            case 2000: {
                this.selectedElement = this.selectedValue.value = this.getElementInteracted(interactionEvent);
                this.variableChanged(31 + this.getPropertiesDisplacement(), this.selectedValue);
                this.reportMouseMotion(interactionEvent.getInfo(), this.selectedValue.value);
                this.invokeActions(10);
                break;
            }
            case 2001: {
                this.reportMouseMotion(interactionEvent.getInfo(), this.selectedElement);
                break;
            }
            case 2002: {
                this.invokeActions(0);
                this.selectedValue.value = -1;
                this.variableChanged(31 + this.getPropertiesDisplacement(), this.selectedValue);
            }
        }
    }
}

