/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.display3d;

import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.display3d.ControlSet3D;
import org.colos.ejs.library.control.swing.NeedsPreUpdate;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.GeneralParser;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.ParserAndVariables;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display3d.core.Element;
import org.opensourcephysics.display3d.core.ElementPolygon;
import org.opensourcephysics.display3d.factory.OSP3DFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlAnalyticCurve3D
extends ControlSet3D
implements NeedsPreUpdate {
    private static final int CURVE_PROPERTIES_ADDED = 12;
    protected String variable = "t";
    protected int numPoints = 200;
    protected double min = -1.0;
    protected double max = 1.0;
    protected String functionX = null;
    protected String functionY = null;
    protected String functionZ = null;
    protected boolean useJavaSyntax = false;
    protected String parameterName = null;
    protected double[] parameterValues = null;
    protected double[][][] data = new double[1][0][0];
    protected boolean changedXfunction;
    protected boolean changedYfunction;
    protected boolean changedZfunction;
    protected boolean updateIndexes;
    protected GeneralParser parserX;
    protected GeneralParser parserY;
    protected GeneralParser parserZ;
    protected String[] varsX = new String[0];
    protected String[] varsY = new String[0];
    protected String[] varsZ = new String[0];
    protected int indexX = -1;
    protected int indexY = -1;
    protected int indexZ = -1;
    protected int indexParameterX;
    protected int indexParameterY;
    protected int indexParameterZ;
    private static List<String> infoList = null;

    @Override
    protected int getPropertiesDisplacement() {
        return 12;
    }

    @Override
    protected Element createAnElement() {
        ElementPolygon elementPolygon = OSP3DFactory.ElementPolygon();
        elementPolygon.setClosed(false);
        return elementPolygon;
    }

    @Override
    protected void copyAnElement(Element element, Element element2) {
        super.copyAnElement(element, element2);
        ((ElementPolygon)element2).setClosed(((ElementPolygon)element).isClosed());
        ((ElementPolygon)element2).setData(((ElementPolygon)element).getData());
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("variable");
            infoList.add("min");
            infoList.add("max");
            infoList.add("points");
            infoList.add("functionx");
            infoList.add("functiony");
            infoList.add("functionz");
            infoList.add("javaSyntax");
            infoList.add("parameterName");
            infoList.add("parameterValues");
            infoList.add("onErrorAction");
            infoList.add("onSuccessAction");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("variable")) {
            return "String";
        }
        if (string.equals("min")) {
            return "int|double";
        }
        if (string.equals("max")) {
            return "int|double";
        }
        if (string.equals("points")) {
            return "int";
        }
        if (string.equals("functionx")) {
            return "String";
        }
        if (string.equals("functiony")) {
            return "String";
        }
        if (string.equals("functionz")) {
            return "String";
        }
        if (string.equals("javaSyntax")) {
            return "boolean";
        }
        if (string.equals("parameterName")) {
            return "String";
        }
        if (string.equals("parameterValues")) {
            return "double[]";
        }
        if (string.equals("onErrorAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("onSuccessAction")) {
            return "Action CONSTANT";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (value.getString().equals(this.variable)) break;
                this.variable = value.getString();
                this.updateIndexes = true;
                break;
            }
            case 1: {
                this.min = value.getDouble();
                break;
            }
            case 2: {
                this.max = value.getDouble();
                break;
            }
            case 3: {
                this.numPoints = value.getInteger();
                break;
            }
            case 4: {
                if (value.getString().equals(this.functionX)) break;
                this.functionX = value.getString();
                this.changedXfunction = true;
                break;
            }
            case 5: {
                if (value.getString().equals(this.functionY)) break;
                this.functionY = value.getString();
                this.changedYfunction = true;
                break;
            }
            case 6: {
                if (value.getString().equals(this.functionZ)) break;
                this.functionZ = value.getString();
                this.changedZfunction = true;
                break;
            }
            case 7: {
                if (value.getBoolean() == this.useJavaSyntax) break;
                this.useJavaSyntax = value.getBoolean();
                this.updateIndexes = true;
                this.changedZfunction = true;
                this.changedYfunction = true;
                this.changedXfunction = true;
                break;
            }
            case 8: {
                if (value.getString().equals(this.parameterName)) break;
                this.parameterName = value.getString();
                this.updateIndexes = true;
                this.changedZfunction = true;
                this.changedYfunction = true;
                this.changedXfunction = true;
                break;
            }
            case 9: {
                if (value.getObject() instanceof double[]) {
                    this.parameterValues = (double[])value.getObject();
                    break;
                }
                this.parameterValues = null;
                break;
            }
            case 10: {
                this.removeAction(1001, this.getProperty("onErrorAction"));
                this.addAction(1001, value.getString());
                break;
            }
            case 11: {
                this.removeAction(1002, this.getProperty("onSuccessAction"));
                this.addAction(1002, value.getString());
                break;
            }
            default: {
                super.setValue(n - 12, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.variable = "t";
                this.updateIndexes = true;
                break;
            }
            case 1: {
                this.min = -1.0;
                break;
            }
            case 2: {
                this.max = 1.0;
                break;
            }
            case 3: {
                this.numPoints = 200;
                break;
            }
            case 4: {
                this.functionX = null;
                this.varsX = new String[0];
                this.changedXfunction = true;
                break;
            }
            case 5: {
                this.functionY = null;
                this.varsY = new String[0];
                this.changedYfunction = true;
                break;
            }
            case 6: {
                this.functionZ = null;
                this.varsZ = new String[0];
                this.changedZfunction = true;
                break;
            }
            case 7: {
                this.useJavaSyntax = true;
                this.updateIndexes = true;
                this.changedZfunction = true;
                this.changedYfunction = true;
                this.changedXfunction = true;
                break;
            }
            case 8: {
                this.parameterName = null;
                this.updateIndexes = true;
                this.changedZfunction = true;
                this.changedYfunction = true;
                this.changedXfunction = true;
                break;
            }
            case 9: {
                this.parameterValues = null;
                break;
            }
            case 10: {
                this.removeAction(1001, this.getProperty("onErrorAction"));
                break;
            }
            case 11: {
                this.removeAction(1002, this.getProperty("onSuccessAction"));
                break;
            }
            default: {
                super.setDefaultValue(n - 12);
            }
        }
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return null;
            }
        }
        return super.getValue(n - 12);
    }

    private boolean isVariableDefined(String string) {
        if (this.variable.equals(string)) {
            return true;
        }
        if (this.parameterName != null && string.equals(this.parameterName)) {
            return true;
        }
        Value value = this.myGroup.getValue(string);
        if (value instanceof IntegerValue) {
            return true;
        }
        return value instanceof DoubleValue;
    }

    @Override
    public void preupdate() {
        int n;
        int n2;
        ParserAndVariables parserAndVariables;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.changedXfunction && this.functionX != null) {
            parserAndVariables = new ParserAndVariables(this.useJavaSyntax, this.functionX);
            this.varsX = parserAndVariables.getVariables();
            this.parserX = parserAndVariables.getParser();
            n2 = 0;
            n = this.varsX.length;
            while (n2 < n) {
                if (!this.isVariableDefined(this.varsX[n2])) {
                    bl2 = true;
                    break;
                }
                this.parserX.defineVariable(n2, this.varsX[n2]);
                ++n2;
            }
            if (!bl2) {
                this.parserX.define(this.functionX);
                this.parserX.parse();
                if (this.parserX.hasError()) {
                    bl2 = true;
                } else {
                    bl = true;
                }
            }
            this.changedXfunction = false;
            this.updateIndexes = true;
        }
        if (this.changedYfunction && this.functionY != null) {
            parserAndVariables = new ParserAndVariables(this.useJavaSyntax, this.functionY);
            this.varsY = parserAndVariables.getVariables();
            this.parserY = parserAndVariables.getParser();
            n2 = 0;
            n = this.varsY.length;
            while (n2 < n) {
                if (!this.isVariableDefined(this.varsY[n2])) {
                    bl3 = true;
                    break;
                }
                this.parserY.defineVariable(n2, this.varsY[n2]);
                ++n2;
            }
            if (!bl3) {
                this.parserY.define(this.functionY);
                this.parserY.parse();
                if (this.parserY.hasError()) {
                    bl3 = true;
                } else {
                    bl = true;
                }
            }
            this.changedYfunction = false;
            this.updateIndexes = true;
        }
        if (this.changedZfunction && this.functionZ != null) {
            parserAndVariables = new ParserAndVariables(this.useJavaSyntax, this.functionZ);
            this.varsZ = parserAndVariables.getVariables();
            this.parserZ = parserAndVariables.getParser();
            n2 = 0;
            n = this.varsZ.length;
            while (n2 < n) {
                if (!this.isVariableDefined(this.varsZ[n2])) {
                    bl4 = true;
                    break;
                }
                this.parserZ.defineVariable(n2, this.varsZ[n2]);
                ++n2;
            }
            if (!bl4) {
                this.parserZ.define(this.functionZ);
                this.parserZ.parse();
                if (this.parserZ.hasError()) {
                    bl4 = true;
                } else {
                    bl = true;
                }
            }
            this.changedZfunction = false;
            this.updateIndexes = true;
        }
        if (bl2 || bl3 || bl4) {
            this.invokeActions(1001);
        } else if (bl) {
            this.invokeActions(1002);
        }
        if (this.isUnderEjs) {
            this.myEjsPropertyEditor.displayErrorOnProperty("functionx", bl2);
            this.myEjsPropertyEditor.displayErrorOnProperty("functiony", bl3);
            this.myEjsPropertyEditor.displayErrorOnProperty("functionz", bl4);
        }
        if (this.updateIndexes) {
            this.indexX = ControlAnalyticCurve3D.indexOf(this.variable, this.varsX);
            this.indexY = ControlAnalyticCurve3D.indexOf(this.variable, this.varsY);
            this.indexZ = ControlAnalyticCurve3D.indexOf(this.variable, this.varsZ);
            if (this.parameterName != null) {
                this.indexParameterX = ControlAnalyticCurve3D.indexOf(this.parameterName, this.varsX);
                this.indexParameterY = ControlAnalyticCurve3D.indexOf(this.parameterName, this.varsY);
                this.indexParameterZ = ControlAnalyticCurve3D.indexOf(this.parameterName, this.varsZ);
            }
            this.updateIndexes = false;
        }
        if (this.parameterName != null && this.parameterValues != null) {
            if (this.numElements != this.parameterValues.length) {
                this.data = new double[this.parameterValues.length][this.numPoints][3];
                super.setNumberOfElements(this.parameterValues.length);
            }
        } else if (this.numElements != 1) {
            super.setNumberOfElements(1);
            this.data = new double[1][this.numPoints][3];
        }
        if (this.numPoints != this.data[0].length) {
            this.data = new double[this.data.length][this.numPoints][3];
        }
        double d = this.min;
        double d2 = this.max;
        int n3 = 0;
        int n4 = this.varsX.length;
        while (n3 < n4) {
            if (n3 != this.indexX) {
                this.parserX.setVariable(n3, this.myGroup.getDouble(this.varsX[n3]));
            }
            ++n3;
        }
        n3 = 0;
        n4 = this.varsY.length;
        while (n3 < n4) {
            if (n3 != this.indexY) {
                this.parserY.setVariable(n3, this.myGroup.getDouble(this.varsY[n3]));
            }
            ++n3;
        }
        n3 = 0;
        n4 = this.varsZ.length;
        while (n3 < n4) {
            if (n3 != this.indexZ) {
                this.parserZ.setVariable(n3, this.myGroup.getDouble(this.varsZ[n3]));
            }
            ++n3;
        }
        if (this.parameterName != null && this.parameterValues != null) {
            n3 = 0;
            n4 = this.parameterValues.length;
            while (n3 < n4) {
                if (this.functionX != null && this.indexParameterX >= 0) {
                    this.parserX.setVariable(this.indexParameterX, this.parameterValues[n3]);
                }
                if (this.functionY != null && this.indexParameterY >= 0) {
                    this.parserY.setVariable(this.indexParameterY, this.parameterValues[n3]);
                }
                if (this.functionZ != null && this.indexParameterZ >= 0) {
                    this.parserZ.setVariable(this.indexParameterZ, this.parameterValues[n3]);
                }
                int n5 = 0;
                int n6 = this.numPoints - 1;
                while (n5 <= n6) {
                    double d3 = ((double)(n6 - n5) * d + (double)n5 * d2) / (double)n6;
                    if (this.functionX == null || bl2) {
                        this.data[n3][n5][0] = 0.0;
                    } else {
                        if (this.indexX >= 0) {
                            this.parserX.setVariable(this.indexX, d3);
                        }
                        this.data[n3][n5][0] = this.parserX.evaluate();
                    }
                    if (this.functionY == null || bl3) {
                        this.data[n3][n5][1] = 0.0;
                    } else {
                        if (this.indexY >= 0) {
                            this.parserY.setVariable(this.indexY, d3);
                        }
                        this.data[n3][n5][1] = this.parserY.evaluate();
                    }
                    if (this.functionZ == null || bl4) {
                        this.data[n3][n5][2] = 0.0;
                    } else {
                        if (this.indexZ >= 0) {
                            this.parserZ.setVariable(this.indexZ, d3);
                        }
                        this.data[n3][n5][2] = this.parserZ.evaluate();
                    }
                    ++n5;
                }
                ((ElementPolygon)this.elements[n3]).setData(this.data[n3]);
                ++n3;
            }
        } else {
            n3 = 0;
            n4 = this.numPoints - 1;
            while (n3 <= n4) {
                double d4 = ((double)(n4 - n3) * d + (double)n3 * d2) / (double)n4;
                if (this.functionX == null || bl2) {
                    this.data[0][n3][0] = 0.0;
                } else {
                    if (this.indexX >= 0) {
                        this.parserX.setVariable(this.indexX, d4);
                    }
                    this.data[0][n3][0] = this.parserX.evaluate();
                }
                if (this.functionY == null || bl3) {
                    this.data[0][n3][1] = 0.0;
                } else {
                    if (this.indexY >= 0) {
                        this.parserY.setVariable(this.indexY, d4);
                    }
                    this.data[0][n3][1] = this.parserY.evaluate();
                }
                if (this.functionZ == null || bl4) {
                    this.data[0][n3][2] = 0.0;
                } else {
                    if (this.indexZ >= 0) {
                        this.parserZ.setVariable(this.indexZ, d4);
                    }
                    this.data[0][n3][2] = this.parserZ.evaluate();
                }
                ++n3;
            }
            ((ElementPolygon)this.elements[0]).setData(this.data[0]);
        }
    }
}

