/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.java3d;

import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BadTransformException;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Geometry;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.J3DGraphics2D;
import javax.media.j3d.Light;
import javax.media.j3d.Node;
import javax.media.j3d.QuadArray;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Screen3D;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.opensourcephysics.display.Renderable;
import org.opensourcephysics.display.TextPanel;
import org.opensourcephysics.display3d.simple3d.utils.EllipsoidUtils;
import org.opensourcephysics.drawing3d.DrawingPanel3D;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.ElementText;
import org.opensourcephysics.drawing3d.java3d.Java3dElementText;
import org.opensourcephysics.drawing3d.java3d.OffScreenCanvas3D;
import org.opensourcephysics.drawing3d.utils.Camera;
import org.opensourcephysics.drawing3d.utils.ImplementingPanel;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.VideoTool;

public class Java3dDrawingPanel3D
implements ImplementingPanel {
    public Canvas3D canvas;
    private DrawingPanel3D panel3D;
    private static double RBACK = 5.0;
    private static final int BACKGROUND = 3;
    private SimpleUniverse universe;
    private TransformGroup rootTG;
    private TransformGroup scaleTG;
    private TransformGroup backTG;
    private BranchGroup branchGroup;
    private Appearance appBack;
    private BoundingSphere bounds;
    private OffScreenCanvas3D offScreenCanvas;
    protected Java3DTextPanel trMessageBox = new Java3DTextPanel(2);
    protected Java3DTextPanel tlMessageBox = new Java3DTextPanel(3);
    protected Java3DTextPanel brMessageBox = new Java3DTextPanel(1);
    protected Java3DTextPanel blMessageBox = new Java3DTextPanel(0);
    private static RenderingHints optionsImage = new RenderingHints(null);

    static {
        optionsImage.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        optionsImage.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        optionsImage.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        optionsImage.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        optionsImage.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        optionsImage.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        optionsImage.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        optionsImage.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    public Java3dDrawingPanel3D(DrawingPanel3D drawingPanel3D) {
        this.panel3D = drawingPanel3D;
        GraphicsConfiguration graphicsConfiguration = Java3dDrawingPanel3D.getPreferredConfiguration();
        this.canvas = new RenderCanvas(graphicsConfiguration);
        this.canvas.setSize(new Dimension(300, 300));
        this.canvas.setDoubleBufferEnable(true);
        this.canvas.setBackground(this.panel3D.getVisualizationHints().getBackgroundColor());
        this.offScreenCanvas = new OffScreenCanvas3D(graphicsConfiguration, true);
        this.branchGroup = new BranchGroup();
        this.branchGroup.setCapability(14);
        this.branchGroup.setCapability(12);
        this.branchGroup.setCapability(13);
        this.bounds = new BoundingSphere();
        this.bounds.setRadius(Double.MAX_VALUE);
        AmbientLight ambientLight = new AmbientLight();
        ambientLight.setCapability(14);
        ambientLight.setCapability(15);
        ambientLight.setCapability(12);
        ambientLight.setCapability(13);
        ambientLight.setInfluencingBounds((Bounds)this.bounds);
        ambientLight.setColor(new Color3f(Color.white));
        this.branchGroup.addChild((Node)ambientLight);
        DirectionalLight directionalLight = new DirectionalLight();
        directionalLight.setCapability(14);
        directionalLight.setCapability(15);
        directionalLight.setCapability(18);
        directionalLight.setCapability(19);
        directionalLight.setCapability(12);
        directionalLight.setCapability(13);
        directionalLight.setInfluencingBounds((Bounds)this.bounds);
        directionalLight.setColor(new Color3f(Color.white));
        directionalLight.setDirection(new Vector3f(0.0f, 0.0f, -1.0f));
        this.branchGroup.addChild((Node)directionalLight);
        this.rootTG = new TransformGroup();
        this.rootTG.setCapability(12);
        this.rootTG.setCapability(13);
        this.rootTG.setCapability(14);
        this.rootTG.setCapability(18);
        this.rootTG.setCapability(17);
        this.rootTG.setCapability(17);
        this.rootTG.setBounds((Bounds)this.bounds);
        this.branchGroup.addChild((Node)this.rootTG);
        Color3f color3f = new Color3f(this.panel3D.getVisualizationHints().getBackgroundColor());
        Background background = new Background(color3f);
        background.setCapability(17);
        background.setCapability(15);
        background.setCapability(21);
        background.setApplicationBounds((Bounds)new BoundingSphere());
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.setCapability(17);
        branchGroup.setCapability(12);
        branchGroup.setCapability(13);
        branchGroup.addChild((Node)background);
        this.branchGroup.addChild((Node)branchGroup);
        this.backTG = new TransformGroup();
        this.backTG.setCapability(12);
        this.backTG.setCapability(13);
        this.backTG.setCapability(17);
        this.backTG.setCapability(18);
        this.backTG.setCapability(14);
        Transform3D transform3D = new Transform3D();
        transform3D.setScale(RBACK * this.panel3D.getMaximum3DSize());
        this.backTG.setTransform(transform3D);
        this.rootTG.addChild((Node)this.backTG);
        this.scaleTG = new TransformGroup();
        this.scaleTG.setCapability(14);
        this.scaleTG.setCapability(18);
        this.scaleTG.setCapability(17);
        this.scaleTG.setBounds((Bounds)this.bounds);
        this.rootTG.addChild((Node)this.scaleTG);
        this.universe = new SimpleUniverse(this.canvas);
        this.universe.getViewer().getView().setLocalEyeLightingEnable(true);
        this.universe.getViewer().getView().setCompatibilityModeEnable(false);
        this.universe.getViewer().getView().setBackClipDistance(200.0);
        this.universe.addBranchGraph(this.branchGroup);
        Screen3D screen3D = this.canvas.getScreen3D();
        Screen3D screen3D2 = this.offScreenCanvas.getScreen3D();
        screen3D2.setSize(screen3D.getSize());
        screen3D2.setPhysicalScreenWidth(screen3D.getPhysicalScreenWidth());
        screen3D2.setPhysicalScreenHeight(screen3D.getPhysicalScreenHeight());
        this.universe.getViewer().getView().addCanvas3D((Canvas3D)this.offScreenCanvas);
    }

    protected TransformGroup getTransformGroup() {
        return this.rootTG;
    }

    private static final GraphicsConfiguration getPreferredConfiguration() {
        GraphicsConfigTemplate3D graphicsConfigTemplate3D = new GraphicsConfigTemplate3D();
        String string = (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return System.getProperty("j3d.stereo");
            }
        });
        if (string != null) {
            if (string.equals("REQUIRED")) {
                graphicsConfigTemplate3D.setStereo(1);
            } else if (string.equals("PREFERRED")) {
                graphicsConfigTemplate3D.setStereo(2);
            }
        }
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)graphicsConfigTemplate3D);
    }

    public double getScreenRatio() {
        return this.panel3D.isSquareAspect() ? (float)this.canvas.getWidth() / (float)this.canvas.getHeight() : 1.0f;
    }

    public Component getComponent() {
        return this.canvas;
    }

    public void forceRefresh() {
        this.update();
    }

    public synchronized void update() {
        for (Element element : this.panel3D.getElements()) {
            element.processChanges(0);
        }
        for (Element element : this.panel3D.getDecoration().getElementList()) {
            element.processChanges(0);
        }
        this.cameraChanged(0);
    }

    public void setFastRedraw(boolean bl) {
    }

    public void cameraChanged(int n) {
        Camera camera = this.panel3D.getCamera();
        block1 : switch (n) {
            case 5: {
                double d = 1.0;
                double d2 = 0.0;
                int n2 = 0;
                if (this.getComponent().getWidth() >= this.getComponent().getHeight()) {
                    d2 = this.getComponent().getWidth() - this.getComponent().getHeight();
                    n2 = (int)(d2 / 10.0);
                    d = n2 < 10 ? 0.7 + 0.05 * (double)n2 : (-6.0E-5 * Math.pow(n2, 3.0) + 0.0083 * Math.pow(n2, 2.0) - 0.4011 * (double)n2 + 8.59) * d2 / (double)this.getComponent().getWidth();
                }
                if (this.getComponent().getWidth() < this.getComponent().getHeight()) {
                    d2 = this.getComponent().getHeight() - this.getComponent().getWidth();
                    n2 = (int)(d2 / 10.0);
                    if (n2 < 10) {
                        d = 0.65 + 0.045 * (double)n2;
                    }
                    d = 3.0E-8 * Math.pow(d2, 3.0) - 2.0E-5 * Math.pow(d2, 2.0) + 0.0078 * d2 + 0.686;
                }
                double d3 = 1.37 * ((double)this.getComponent().getWidth() * d / (double)this.getComponent().getHeight());
                double d4 = 2.0 * Math.atan(d3 * this.panel3D.getDiagonal() / (2.0 * camera.getDistanceToScreen()));
                this.universe.getViewer().getView().setFieldOfView(d4);
                break;
            }
            case 7: {
                this.panel3D.getDecoration().reset();
                for (Element element : this.panel3D.getElements()) {
                    element.getImplementingObject().processChanges(279, 279);
                }
                break;
            }
            case 0: {
                double d = 1.0;
                double d2 = 0.0;
                int n2 = 0;
                if (this.getComponent().getWidth() >= this.getComponent().getHeight()) {
                    d2 = this.getComponent().getWidth() - this.getComponent().getHeight();
                    n2 = (int)(d2 / 10.0);
                    d = n2 < 10 ? 0.7 + 0.05 * (double)n2 : (-6.0E-5 * Math.pow(n2, 3.0) + 0.0083 * Math.pow(n2, 2.0) - 0.4011 * (double)n2 + 8.59) * d2 / (double)this.getComponent().getWidth();
                }
                if (this.getComponent().getWidth() < this.getComponent().getHeight()) {
                    d2 = this.getComponent().getHeight() - this.getComponent().getWidth();
                    n2 = (int)(d2 / 10.0);
                    if (n2 < 10) {
                        d = 0.65 + 0.045 * (double)n2;
                    }
                    d = 3.0E-8 * Math.pow(d2, 3.0) - 2.0E-5 * Math.pow(d2, 2.0) + 0.0078 * d2 + 0.686;
                }
                double d3 = 1.37 * ((double)this.getComponent().getWidth() * d / (double)this.getComponent().getHeight());
                double d4 = 2.0 * Math.atan(d3 * this.panel3D.getDiagonal() / (2.0 * camera.getDistanceToScreen()));
                this.universe.getViewer().getView().setFieldOfView(d4);
            }
            case 1: {
                switch (this.panel3D.getCamera().getProjectionMode()) {
                    case 0: {
                        this.universe.getViewer().getView().setProjectionPolicy(0);
                        break block1;
                    }
                    case 1: {
                        this.universe.getViewer().getView().setProjectionPolicy(0);
                        break block1;
                    }
                    case 2: {
                        this.universe.getViewer().getView().setProjectionPolicy(0);
                        break block1;
                    }
                    case 4: 
                    case 11: {
                        this.universe.getViewer().getView().setProjectionPolicy(1);
                        break block1;
                    }
                }
            }
        }
        for (ElementText elementText : this.panel3D.getTextElements()) {
            ((Java3dElementText)elementText.getImplementingObject()).updateText(camera.getDistanceToScreen());
        }
        Transform3D transform3D = new Transform3D();
        Iterator<Element> iterator = this.getPerspectivePosition(camera);
        try {
            if (camera.getProjectionMode() == 0) {
                transform3D.lookAt(new Point3d(((Vector3d)iterator).x, ((Vector3d)iterator).y, ((Vector3d)iterator).z), new Point3d(camera.getFocusX(), camera.getFocusY(), camera.getFocusZ()), new Vector3d(0.0, 1.0, 0.0));
            } else {
                transform3D.lookAt(new Point3d(((Vector3d)iterator).x, ((Vector3d)iterator).y, ((Vector3d)iterator).z), new Point3d(camera.getFocusX(), camera.getFocusY(), camera.getFocusZ()), new Vector3d(0.0, 0.0, 1.0));
            }
            this.rootTG.setTransform(transform3D);
        }
        catch (BadTransformException badTransformException) {}
    }

    private Vector3d getPerspectivePosition(Camera camera) {
        if (camera.is3dMode()) {
            return new Vector3d(camera.getX(), camera.getY(), camera.getZ());
        }
        Vector3d vector3d = new Vector3d(camera.map(this.panel3D.getCenter()));
        switch (camera.getProjectionMode()) {
            case 0: {
                vector3d.z += camera.getDistanceToFocus();
                break;
            }
            case 1: {
                vector3d.y -= camera.getDistanceToFocus();
                break;
            }
            case 2: {
                vector3d.x += camera.getDistanceToFocus();
            }
        }
        return vector3d;
    }

    public void setMessage(String string) {
        this.brMessageBox.setText(string);
    }

    public void setMessage(String string, int n) {
        switch (n) {
            case 0: {
                this.blMessageBox.setText(string);
                break;
            }
            default: {
                this.brMessageBox.setText(string);
                break;
            }
            case 2: {
                this.trMessageBox.setText(string);
                break;
            }
            case 3: {
                this.tlMessageBox.setText(string);
            }
        }
    }

    public BufferedImage render() {
        for (Element object2 : this.panel3D.getElements()) {
            object2.processChanges(0);
        }
        for (Element element : this.panel3D.getDecoration().getElementList()) {
            element.processChanges(0);
        }
        this.cameraChanged(0);
        VideoTool videoTool = this.panel3D.getVideoTool();
        Object object3 = null;
        if (videoTool != null && videoTool.isRecording() && (object3 = this.render(null)) != null) {
            videoTool.addFrame((BufferedImage)object3);
        }
        return object3;
    }

    public BufferedImage render(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            return this.offScreenCanvas.doRender(null, this.canvas.getWidth(), this.canvas.getHeight());
        }
        return this.offScreenCanvas.doRender(bufferedImage, bufferedImage.getWidth(null), bufferedImage.getHeight(null));
    }

    public void hintChanged(int n) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void visualizationChanged(int n) {
        switch (n) {
            case 7: {
                this.setImage(this.panel3D.getVisualizationHints().getBackgroundImage(), this.panel3D.getVisualizationHints().getBackgroundTile());
                break;
            }
            case 8: {
                this.setBackgroundMoveable(this.panel3D.getVisualizationHints().getBackgroundMoveable());
                break;
            }
            case 10: {
                this.setImage(this.panel3D.getVisualizationHints().getBackgroundImage(), this.panel3D.getVisualizationHints().getBackgroundTile());
                break;
            }
            case 12: {
                this.setLightEnabled(this.panel3D.getVisualizationHints().getDefaultIllumination());
                break;
            }
            case 9: {
                this.setScaleBackground(this.panel3D.getVisualizationHints().getScaleBackground());
            }
        }
    }

    private void setImage(String string, Dimension dimension) {
        if (string == null) {
            this.branchGroup.removeChild(3);
            if (this.backTG.numChildren() > 0) {
                this.backTG.removeChild(0);
            }
            this.setBackgroundMoveable(false);
            Color3f color3f = new Color3f(this.panel3D.getVisualizationHints().getBackgroundColor());
            Background background = new Background(color3f);
            background.setCapability(17);
            background.setCapability(15);
            background.setCapability(21);
            background.setApplicationBounds((Bounds)new BoundingSphere());
            BranchGroup branchGroup = new BranchGroup();
            branchGroup.setCapability(17);
            branchGroup.addChild((Node)background);
            this.branchGroup.addChild((Node)branchGroup);
            this.canvas.setBackground(this.panel3D.getVisualizationHints().getBackgroundColor());
            return;
        }
        int n = 0;
        int n2 = 0;
        BufferedImage bufferedImage = ResourceLoader.getBufferedImage(string);
        n = dimension == null ? this.canvas.getWidth() : dimension.width;
        n2 = dimension == null ? this.canvas.getHeight() : dimension.height;
        AffineTransformOp affineTransformOp = new AffineTransformOp(AffineTransform.getScaleInstance((double)n / (double)bufferedImage.getWidth(), (double)n2 / (double)bufferedImage.getHeight()), optionsImage);
        ImageComponent2D imageComponent2D = new ImageComponent2D(2, affineTransformOp.filter(bufferedImage, null));
        BranchGroup branchGroup = (BranchGroup)this.branchGroup.getChild(3);
        Background background = (Background)branchGroup.getChild(0);
        if (dimension != null) {
            background.setImageScaleMode(4);
            if (this.backTG.numChildren() > 0) {
                this.backTG.removeChild(0);
            }
            if (this.backTG.numChildren() <= 0) {
                this.backTG.addChild((Node)this.getShapeBackground(dimension));
            }
        } else {
            background.setImageScaleMode(3);
            if (this.backTG.numChildren() > 0) {
                this.backTG.removeChild(0);
            }
            if (this.backTG.numChildren() <= 0) {
                this.backTG.addChild((Node)this.getShapeBackground(null));
            }
        }
        URL uRL = ResourceLoader.getResource(string).getURL();
        TextureLoader textureLoader = new TextureLoader(uRL, new String("RGBA"), 6, null);
        this.appBack.setTexture(textureLoader.getTexture());
        background.setImage(imageComponent2D);
        this.setBackgroundMoveable(this.panel3D.getVisualizationHints().getBackgroundMoveable());
    }

    private void setBackgroundMoveable(boolean bl) {
        if (this.appBack != null) {
            this.appBack.getRenderingAttributes().setVisible(bl);
        }
    }

    private void setScaleBackground(double d) {
        Transform3D transform3D = new Transform3D();
        transform3D.setScale(RBACK * d);
        this.backTG.setTransform(transform3D);
    }

    private BranchGroup getShapeBackground(Dimension dimension) {
        Shape3D shape3D = null;
        Sphere sphere = null;
        float f = 0.5f;
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.setCapability(17);
        branchGroup.setCapability(14);
        TransformGroup transformGroup = new TransformGroup();
        transformGroup.setCapability(12);
        transformGroup.setCapability(14);
        transformGroup.setCapability(17);
        Transform3D transform3D = new Transform3D();
        this.appBack = new Appearance();
        this.appBack.setCapability(3);
        this.appBack.setCapability(12);
        RenderingAttributes renderingAttributes = new RenderingAttributes();
        renderingAttributes.setCapability(6);
        this.appBack.setRenderingAttributes(renderingAttributes);
        this.appBack.getRenderingAttributes().setVisible(this.panel3D.getVisualizationHints().getBackgroundMoveable());
        if (dimension != null) {
            shape3D = this.createTileBackground(dimension.width, dimension.height);
            shape3D.setAppearance(this.appBack);
            transform3D.setScale(new Vector3d(1.0, 1.0, 1.0));
            transformGroup.setTransform(transform3D);
            transformGroup.addChild((Node)shape3D);
            branchGroup.addChild((Node)transformGroup);
        } else {
            sphere = new Sphere(f, 102, 45);
            transform3D.rotX(-1.5707963267948966);
            sphere.setAppearance(this.appBack);
            transformGroup.setTransform(transform3D);
            transformGroup.addChild((Node)sphere);
            branchGroup.addChild((Node)transformGroup);
        }
        return branchGroup;
    }

    private Shape3D createTileBackground(int n, int n2) {
        double[][][] dArray = null;
        int n3 = 0;
        if (n >= 100 || n2 >= 100) {
            n3 = 10;
        } else {
            float f = -0.18f * (float)(n + n2) / 2.0f + 30.0f;
            n3 = (int)f;
        }
        dArray = EllipsoidUtils.createStandardEllipsoid(n3, n3, n3, 0.0, 360.0, -90.0, 90.0, true, true, true, true);
        int n4 = dArray.length;
        int n5 = dArray[0].length;
        Point3d[] point3dArray = new Point3d[n4 * n5];
        TexCoord2f[] texCoord2fArray = new TexCoord2f[n4 * n5];
        TexCoord2f[] texCoord2fArray2 = new TexCoord2f[]{new TexCoord2f(0.0f, 0.0f), new TexCoord2f(1.0f, 0.0f), new TexCoord2f(1.0f, 1.0f), new TexCoord2f(0.0f, 1.0f)};
        QuadArray quadArray = new QuadArray(n4 * n5, 33);
        int n6 = 0;
        while (n6 < n4) {
            int n7 = 0;
            while (n7 < n5) {
                texCoord2fArray[n6 * n5 + n7] = new TexCoord2f(texCoord2fArray2[n7]);
                if (n7 == 0) {
                    point3dArray[n6 * n5 + n7 + 3] = new Point3d(dArray[n6][n7][0], dArray[n6][n7][1], dArray[n6][n7][2]);
                } else if (n7 == 1) {
                    point3dArray[n6 * n5 + n7 + 1] = new Point3d(dArray[n6][n7][0], dArray[n6][n7][1], dArray[n6][n7][2]);
                } else if (n7 == 2) {
                    point3dArray[n6 * n5 + n7 - 1] = new Point3d(dArray[n6][n7][0], dArray[n6][n7][1], dArray[n6][n7][2]);
                } else {
                    point3dArray[n6 * n5 + n7 - 3] = new Point3d(dArray[n6][n7][0], dArray[n6][n7][1], dArray[n6][n7][2]);
                }
                ++n7;
            }
            ++n6;
        }
        quadArray.setCoordinates(0, point3dArray);
        quadArray.setTextureCoordinates(0, 0, texCoord2fArray);
        Shape3D shape3D = new Shape3D((Geometry)quadArray, this.appBack);
        return shape3D;
    }

    public void setLightEnabled(boolean bl) {
        int n = 0;
        while (n < 2) {
            Light light = (Light)this.branchGroup.getChild(n);
            light.setEnable(bl);
            ++n;
        }
    }

    private class Java3DTextPanel
    extends TextPanel {
        private BufferedImage image;
        private int location;

        public Java3DTextPanel(int n) {
            this.location = n;
            int n2 = 200;
            int n3 = 50;
            this.image = new BufferedImage(n2, n3, 2);
        }

        public void render(J3DGraphics2D j3DGraphics2D) {
            switch (this.location) {
                case 3: {
                    j3DGraphics2D.drawAndFlushImage(this.image, 0, 0, null);
                    break;
                }
                case 2: {
                    j3DGraphics2D.drawAndFlushImage(this.image, Java3dDrawingPanel3D.this.canvas.getWidth() - this.getWidth(), 0, null);
                    break;
                }
                case 1: {
                    j3DGraphics2D.drawAndFlushImage(this.image, Java3dDrawingPanel3D.this.canvas.getWidth() - this.getWidth(), Java3dDrawingPanel3D.this.canvas.getHeight() - this.getHeight(), null);
                    break;
                }
                default: {
                    j3DGraphics2D.drawAndFlushImage(this.image, 0, Java3dDrawingPanel3D.this.canvas.getHeight() - this.getHeight(), null);
                }
            }
        }

        public void setText(String string) {
            super.setText(string);
            int n = this.getWidth();
            int n2 = this.getHeight();
            if (n == 0 || n2 == 0) {
                return;
            }
            if (this.image.getWidth() != n || this.image.getHeight() != n2) {
                this.image = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            }
            this.paint(this.image.getGraphics());
        }
    }

    private class RenderCanvas
    extends Canvas3D
    implements Renderable {
        RenderCanvas(GraphicsConfiguration graphicsConfiguration) {
            super(graphicsConfiguration);
        }

        public void postRender() {
            J3DGraphics2D j3DGraphics2D = Java3dDrawingPanel3D.this.canvas.getGraphics2D();
            Java3dDrawingPanel3D.this.tlMessageBox.render(j3DGraphics2D);
            Java3dDrawingPanel3D.this.trMessageBox.render(j3DGraphics2D);
            Java3dDrawingPanel3D.this.brMessageBox.render(j3DGraphics2D);
            Java3dDrawingPanel3D.this.blMessageBox.render(j3DGraphics2D);
        }

        public BufferedImage render() {
            return Java3dDrawingPanel3D.this.render();
        }

        public BufferedImage render(BufferedImage bufferedImage) {
            return Java3dDrawingPanel3D.this.render(bufferedImage);
        }
    }
}

