/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import javax.swing.JPanel;

public class Knob
extends JPanel {
    private static Dimension DEFAULT_SIZE = new Dimension(20, 20);
    private RectangularShape outerCircle = new Ellipse2D.Float(0.0f, 0.0f, 1.0f, 1.0f);
    private RectangularShape bigCircle = new Ellipse2D.Float(0.0f, 0.0f, 1.0f, 1.0f);
    private RectangularShape smallCircle = new Ellipse2D.Float(0.0f, 0.0f, 1.0f, 1.0f);
    private Paint outerPaint;
    private Paint bigPaint;
    private double lastAngle;
    private double angle = 0.0;
    private double minAngle = -2.356194490192345;
    private double maxAngle = 2.356194490192345;
    private double minValue = -1.0;
    private double maxValue = 1.0;
    private double currentValue = Double.NaN;
    private ActionListener listener = null;
    private ActionEvent event = new ActionEvent(this, 1001, "");

    public Knob() {
        this.setForeground(Color.LIGHT_GRAY);
        this.setPreferredSize(DEFAULT_SIZE);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Knob.this.lastAngle = Math.atan2(e.getY() - Knob.this.getHeight() / 2, e.getX() - Knob.this.getWidth() / 2);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (!Knob.this.isEnabled()) {
                    return;
                }
                double newAngle = Knob.translateToSameInterval(Knob.this.lastAngle, Math.atan2(e.getY() - Knob.this.getHeight() / 2, e.getX() - Knob.this.getWidth() / 2));
                Knob knob = Knob.this;
                knob.angle = knob.angle + (newAngle - Knob.this.lastAngle);
                Knob.this.currentValue = Knob.this.getValue();
                Knob.this.lastAngle = newAngle;
                Knob.this.applyAngle();
                if (Knob.this.listener != null) {
                    Knob.this.listener.actionPerformed(Knob.this.event);
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Knob.this.repaint();
            }
        });
    }

    public void addActionListener(ActionListener _listener) {
        this.listener = _listener;
    }

    public void setMaxAngle(double _angle) {
        if (this.maxAngle != _angle) {
            this.maxAngle = _angle;
            this.applyAngle();
        }
    }

    public void setMinAngle(double _angle) {
        if (this.minAngle != _angle) {
            this.minAngle = _angle;
            this.applyAngle();
        }
    }

    public double getValue() {
        return this.minValue + (this.angle - this.minAngle) * (this.maxValue - this.minValue) / (this.maxAngle - this.minAngle);
    }

    public void setValue(double _value) {
        if (_value == this.currentValue) {
            return;
        }
        this.currentValue = _value;
        this.applyValue();
    }

    public void setMaxValue(double _value) {
        if (this.maxValue != _value) {
            this.maxValue = _value;
            this.applyValue();
        }
    }

    public void setMinValue(double _value) {
        if (this.minValue != _value) {
            this.minValue = _value;
            this.applyValue();
        }
    }

    private void applyValue() {
        if (this.currentValue < this.minValue) {
            this.currentValue = this.minValue;
        } else if (this.currentValue > this.maxValue) {
            this.currentValue = this.maxValue;
        }
        this.angle = this.minAngle + (this.currentValue - this.minValue) * (this.maxAngle - this.minAngle) / (this.maxValue - this.minValue);
        this.applyAngle();
    }

    private void applyAngle() {
        if (this.angle < this.minAngle) {
            this.angle = this.minAngle;
        } else if (this.angle > this.maxAngle) {
            this.angle = this.maxAngle;
        }
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics _g) {
        super.paintComponent(_g);
        this.preparePaint();
        Graphics2D g2 = (Graphics2D)_g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setPaint(this.outerPaint);
        g2.fill(this.outerCircle);
        g2.setPaint(this.bigPaint);
        g2.fill(this.bigCircle);
        int width = this.getWidth();
        int height = this.getHeight();
        int size = Math.min(width, height);
        int centerX = width / 2;
        int centerY = height / 2;
        float tmpSize = (float)size * 0.25f;
        double radius = (float)size * 0.25f;
        double displayAngle = this.angle - 1.5707963267948966;
        float x1 = (float)((double)centerX + radius * Math.cos(displayAngle) - (double)(tmpSize / 2.0f));
        float y1 = (float)((double)centerY + radius * Math.sin(displayAngle) - (double)(tmpSize / 2.0f));
        this.smallCircle.setFrame(x1, y1, tmpSize, tmpSize);
        Color color = this.getForeground();
        g2.setPaint(new GradientPaint(x1, y1, color, x1 + tmpSize, y1 + tmpSize, color.brighter()));
        g2.fill(this.smallCircle);
    }

    private void preparePaint() {
        int height;
        int width = this.getWidth();
        int size = Math.min(width, height = this.getHeight());
        if (size <= 0) {
            return;
        }
        int centerX = width / 2;
        int centerY = height / 2;
        Color color = this.getForeground();
        Color brighterColor = color.brighter();
        Color darkerColor = color.darker();
        float tmpSize = size;
        float x1 = (float)centerX - tmpSize / 2.0f;
        float y1 = (float)centerY - tmpSize / 2.0f;
        this.outerCircle.setFrame(x1, y1, tmpSize, tmpSize);
        this.outerPaint = new GradientPaint(x1, y1, brighterColor.brighter(), x1 + tmpSize, y1 + tmpSize, darkerColor.darker());
        this.bigPaint = new GradientPaint(x1, y1, color, x1 + tmpSize, y1 + tmpSize, darkerColor);
        tmpSize = (float)size * 0.9f;
        x1 = (float)centerX - tmpSize / 2.0f;
        y1 = (float)centerY - tmpSize / 2.0f;
        this.bigCircle.setFrame(x1, y1, tmpSize, tmpSize);
    }

    private static double translateToSameInterval(double _reference, double _angle) {
        double twoPi = Math.PI * 2;
        if (_angle > _reference) {
            double top = _reference + Math.PI;
            while (_angle > top) {
                _angle -= twoPi;
            }
            return _angle;
        }
        double bottom = _reference - Math.PI;
        while (_angle < bottom) {
            _angle += twoPi;
        }
        return _angle;
    }
}

