/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.gif;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import org.opensourcephysics.media.core.ScratchVideoRecorder;
import org.opensourcephysics.media.gif.AnimatedGifEncoder;
import org.opensourcephysics.media.gif.GifVideoType;

public class GifVideoRecorder
extends ScratchVideoRecorder {
    private AnimatedGifEncoder encoder = new AnimatedGifEncoder();

    public GifVideoRecorder() {
        super(new GifVideoType());
    }

    @Override
    public void setFrameDuration(double d) {
        super.setFrameDuration(d);
        this.encoder.setDelay((int)this.frameDuration);
    }

    public AnimatedGifEncoder getGifEncoder() {
        return this.encoder;
    }

    @Override
    protected void saveScratch() {
        this.encoder.finish();
    }

    @Override
    protected boolean startRecording() {
        if (this.dim == null && this.frameImage != null) {
            this.dim = new Dimension(this.frameImage.getWidth(null), this.frameImage.getHeight(null));
        }
        if (this.dim != null) {
            this.encoder.setSize(this.dim.width, this.dim.height);
        }
        this.encoder.setRepeat(0);
        return this.encoder.start(this.scratchFile.getAbsolutePath());
    }

    @Override
    protected boolean append(Image image) {
        BufferedImage bufferedImage;
        if (image instanceof BufferedImage) {
            bufferedImage = (BufferedImage)image;
        } else {
            if (this.dim == null) {
                return false;
            }
            bufferedImage = new BufferedImage(this.dim.width, this.dim.height, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawImage(image, 0, 0, null);
        }
        this.encoder.addFrame(bufferedImage);
        return true;
    }
}

