/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.utils;

import org.colos.ejs.library.Model;
import org.colos.ejs.library.control.ControlElement;

public class ModelElementsUtilities {
    private static String removeEnclosingString(String _value, String _removeString) {
        int length = _removeString.length();
        if (_value.startsWith(_removeString)) {
            _value = _value.substring(length);
        }
        if (_value.endsWith(_removeString)) {
            _value = _value.substring(0, _value.length() - length);
        }
        return _value;
    }

    public static boolean isLinkedToVariable(String _value) {
        return _value.startsWith("%");
    }

    public static String getPureValue(String _value) {
        if (_value.startsWith("%")) {
            return ModelElementsUtilities.removeEnclosingString(_value, "%");
        }
        return ModelElementsUtilities.removeEnclosingString(_value, "\"");
    }

    public static String getQuotedValue(String _value) {
        if (_value.startsWith("%")) {
            return "\"" + _value + "\"";
        }
        return "\"" + ModelElementsUtilities.removeEnclosingString(_value, "\"") + "\"";
    }

    public static String getValue(Model _model, String _value) {
        if (_value == null) {
            return null;
        }
        if (_value.startsWith("%")) {
            return _model._getVariable(ModelElementsUtilities.removeEnclosingString(_value, "%"));
        }
        return ModelElementsUtilities.removeEnclosingString(_value, "\"");
    }

    public static int getIntegerValue(Model _model, String _value) {
        try {
            if (_value.startsWith("%")) {
                return Integer.parseInt(_model._getVariable(ModelElementsUtilities.removeEnclosingString(_value, "%")));
            }
            return Integer.parseInt(ModelElementsUtilities.removeEnclosingString(_value, "\""));
        }
        catch (Exception exc) {
            return 0;
        }
    }

    public static Object getViewElement(Model _model, String _value) {
        String elementName = ModelElementsUtilities.getValue(_model, _value);
        ControlElement ctrlEl = _model.getView().getElement(elementName);
        if (ctrlEl != null) {
            return ctrlEl.getObject();
        }
        return null;
    }
}

