/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.swing.Knob;

public class ControlKnob
extends ControlSwingElement
implements ActionListener {
    protected static final int KNOB_ADDED = 8;
    private static final int VARIABLE = 0;
    protected Knob knob;
    private DoubleValue internalValue;
    private static List<String> infoList = null;

    @Override
    protected Component createVisual() {
        this.knob = new Knob();
        this.internalValue = new DoubleValue(this.knob.getValue());
        this.knob.addMouseListener(new MyMouseListener());
        this.knob.addActionListener(this);
        return this.knob;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("variable");
            infoList.add("minimum");
            infoList.add("maximum");
            infoList.add("minimumAngle");
            infoList.add("maximumAngle");
            infoList.add("pressAction");
            infoList.add("dragAction");
            infoList.add("releaseAction");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("variable")) {
            return "int|double";
        }
        if (_property.equals("minimum")) {
            return "int|double";
        }
        if (_property.equals("maximum")) {
            return "int|double";
        }
        if (_property.equals("minimumAngle")) {
            return "int|double";
        }
        if (_property.equals("maximumAngle")) {
            return "int|double";
        }
        if (_property.equals("pressAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("dragAction")) {
            return "Action CONSTANT";
        }
        if (_property.equals("releaseAction")) {
            return "Action CONSTANT";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                this.internalValue.value = _value.getDouble();
                this.knob.setValue(this.internalValue.value);
                break;
            }
            case 1: {
                this.knob.setMinValue(_value.getDouble());
                break;
            }
            case 2: {
                this.knob.setMaxValue(_value.getDouble());
                break;
            }
            case 3: {
                if (_value instanceof IntegerValue) {
                    this.knob.setMinAngle((double)_value.getInteger() * (Math.PI / 180));
                    break;
                }
                this.knob.setMinAngle(_value.getDouble());
                break;
            }
            case 4: {
                if (_value instanceof IntegerValue) {
                    this.knob.setMaxAngle((double)_value.getInteger() * (Math.PI / 180));
                    break;
                }
                this.knob.setMaxAngle(_value.getDouble());
                break;
            }
            case 5: {
                this.removeAction(10, this.getProperty("pressAction"));
                this.addAction(10, _value.getString());
                break;
            }
            case 6: {
                this.removeAction(1, this.getProperty("dragAction"));
                this.addAction(1, _value.getString());
                break;
            }
            case 7: {
                this.removeAction(0, this.getProperty("releaseAction"));
                this.addAction(0, _value.getString());
                break;
            }
            default: {
                super.setValue(_index - 8, _value);
            }
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                break;
            }
            case 1: {
                this.knob.setMinValue(-1.0);
                break;
            }
            case 2: {
                this.knob.setMaxValue(1.0);
                break;
            }
            case 3: {
                this.knob.setMinAngle(-1.2566370614359172);
                break;
            }
            case 4: {
                this.knob.setMaxAngle(1.2566370614359172);
                break;
            }
            case 5: {
                this.removeAction(10, this.getProperty("pressAction"));
                break;
            }
            case 6: {
                this.removeAction(1, this.getProperty("dragAction"));
                break;
            }
            case 7: {
                this.removeAction(0, this.getProperty("releaseAction"));
                break;
            }
            default: {
                super.setDefaultValue(_index - 8);
            }
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return "<none>";
            }
            case 1: {
                return "-1";
            }
            case 2: {
                return "1";
            }
            case 3: {
                return "-PI*0.4";
            }
            case 4: {
                return "PI*0.4";
            }
            case 5: 
            case 6: 
            case 7: {
                return "<no_action>";
            }
        }
        return super.getDefaultValueString(_index - 8);
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: {
                return this.internalValue;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return null;
            }
        }
        return super.getValue(_index - 8);
    }

    @Override
    public void actionPerformed(ActionEvent _evt) {
        this.internalValue.value = this.knob.getValue();
        this.variableChanged(0, this.internalValue);
        if (this.isUnderEjs) {
            this.setFieldListValue(0, this.internalValue);
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (ControlKnob.this.knob.isEnabled()) {
                ControlKnob.this.invokeActions(10);
            }
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (ControlKnob.this.knob.isEnabled()) {
                ControlKnob.this.invokeActions(0);
            }
        }
    }
}

