/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.Tool;

public class DataRefreshTool
implements Tool {
    private static Map<Data, DataRefreshTool> tools = new HashMap<Data, DataRefreshTool>();
    private Data data;
    protected HashSet<Data> moreData = new HashSet();
    private HashMap<Integer, Dataset> ids = new HashMap();

    public static DataRefreshTool getTool(Data data) {
        DataRefreshTool dataRefreshTool = tools.get(data);
        if (dataRefreshTool == null) {
            dataRefreshTool = new DataRefreshTool(data);
            tools.put(data, dataRefreshTool);
        }
        return dataRefreshTool;
    }

    private DataRefreshTool(Data data) {
        this.data = data;
    }

    @Override
    public void send(Job job, Tool tool) throws RemoteException {
        XMLControlElement xMLControlElement = new XMLControlElement(job.getXML());
        if (xMLControlElement.failedToRead() || tool == null || !Data.class.isAssignableFrom(xMLControlElement.getObjectClass())) {
            return;
        }
        Data data = (Data)xMLControlElement.loadObject(null, true, true);
        if (data.getID() == this.data.getID()) {
            xMLControlElement = new XMLControlElement(this.data);
            job.setXML(xMLControlElement.toXML());
            tool.send(job, this);
            return;
        }
        for (Data data2 : DataTool.getSelfContainedData(this.data)) {
            if (data.getID() != data2.getID()) continue;
            xMLControlElement = new XMLControlElement(data2);
            job.setXML(xMLControlElement.toXML());
            tool.send(job, this);
            return;
        }
        ArrayList<Dataset> arrayList = DataTool.getDatasets(this.data);
        for (Dataset dataset : arrayList) {
            if (data.getID() != dataset.getID()) continue;
            xMLControlElement = new XMLControlElement(dataset);
            job.setXML(xMLControlElement.toXML());
            tool.send(job, this);
            return;
        }
        DatasetManager datasetManager = new DatasetManager();
        datasetManager.setName(data.getName());
        this.ids.clear();
        ArrayList<Dataset> arrayList2 = DataTool.getDatasets(data);
        this.findDatasets(arrayList2, arrayList, datasetManager, false);
        if (!this.moreData.isEmpty()) {
            for (Data data3 : this.moreData) {
                ArrayList<Dataset> arrayList3 = DataTool.getDatasets(data3);
                this.findDatasets(arrayList2, arrayList3, datasetManager, true);
            }
            this.padDatasets(datasetManager);
        }
        if (!datasetManager.getDatasets().isEmpty()) {
            xMLControlElement = new XMLControlElement(datasetManager);
            job.setXML(xMLControlElement.toXML());
            tool.send(job, this);
        }
    }

    public void addData(Data data) {
        if (data == this.data) {
            return;
        }
        this.moreData.add(data);
    }

    public void removeData(Data data) {
        this.moreData.remove(data);
    }

    private void padDatasets(DatasetManager datasetManager) {
        TreeSet<Double> treeSet = new TreeSet<Double>();
        for (Dataset doubleArray2 : datasetManager.getDatasets()) {
            double[] dArray = doubleArray2.getXPoints();
            int n = dArray.length;
            int n2 = 0;
            while (n2 < n) {
                double n3 = dArray[n2];
                treeSet.add(n3);
                ++n2;
            }
        }
        Double[] doubleArray = treeSet.toArray(new Double[treeSet.size()]);
        Object object = new double[treeSet.size()];
        int dataset = 0;
        while (dataset < ((Object)object).length) {
            object[dataset] = doubleArray[dataset];
            ++dataset;
        }
        for (Dataset dataset2 : datasetManager.getDatasets()) {
            this.padDataset(dataset2, (double[])object);
        }
    }

    private void findDatasets(ArrayList<Dataset> arrayList, ArrayList<Dataset> arrayList2, DatasetManager datasetManager, boolean bl) {
        for (Dataset dataset : arrayList) {
            Dataset dataset2;
            if (dataset == null || (dataset2 = this.getMatch(dataset.getID(), arrayList2)) == null) continue;
            Dataset dataset3 = this.ids.get(dataset2.getID());
            if (dataset3 == null) {
                dataset3 = DataTool.copyDataset(dataset2, null, true);
                if (bl) {
                    dataset3.setXYColumnNames(dataset2.getXColumnName(), dataset.getYColumnName());
                }
                dataset3.setXColumnVisible(dataset3.getXColumnName().equals(dataset.getYColumnName()));
                dataset3.setYColumnVisible(dataset3.getYColumnName().equals(dataset.getYColumnName()));
                this.ids.put(dataset2.getID(), dataset3);
            } else {
                if (dataset3.getXColumnName().equals(dataset.getYColumnName())) {
                    dataset3.setXColumnVisible(true);
                }
                if (dataset3.getYColumnName().equals(dataset.getYColumnName())) {
                    dataset3.setYColumnVisible(true);
                }
            }
            datasetManager.addDataset(dataset3);
        }
    }

    private Dataset getMatch(int n, ArrayList<Dataset> arrayList) {
        for (Dataset dataset : arrayList) {
            if (dataset == null || n != dataset.getID()) continue;
            return dataset;
        }
        return null;
    }

    private void padDataset(Dataset dataset, double[] dArray) {
        double[] dArray2 = dataset.getXPoints();
        double[] dArray3 = dataset.getYPoints();
        HashMap<Double, Double> hashMap = new HashMap<Double, Double>();
        int n = 0;
        while (n < dArray2.length) {
            hashMap.put(dArray2[n], dArray3[n]);
            ++n;
        }
        double[] dArray4 = new double[dArray.length];
        int n2 = 0;
        while (n2 < dArray.length) {
            double d = dArray[n2];
            dArray4[n2] = hashMap.keySet().contains(d) ? (Double)hashMap.get(d) : Double.NaN;
            ++n2;
        }
        dataset.clear();
        dataset.append(dArray, dArray4);
    }
}

