/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.ode_interpolation;

import org.opensourcephysics.numerics.ode_interpolation.IntervalData;

public class HermiteIntervalData
extends IntervalData {
    protected int mTimeIndex;
    protected double mDeltaTime;
    protected double[] mLeftState;
    protected double[] mLeftRate;
    protected double[] mRightState;
    protected double[] mRightRate;

    public HermiteIntervalData(double[] aState, double[] aRate, double[] bState, double[] bRate) {
        super(aState[aState.length - 1], bState[bState.length - 1]);
        int dimension = aState.length;
        this.mLeftState = new double[dimension];
        this.mRightState = new double[dimension];
        this.mLeftRate = new double[dimension];
        this.mRightRate = new double[dimension];
        System.arraycopy(aState, 0, this.mLeftState, 0, dimension);
        System.arraycopy(bState, 0, this.mRightState, 0, dimension);
        System.arraycopy(aRate, 0, this.mLeftRate, 0, dimension);
        System.arraycopy(bRate, 0, this.mRightRate, 0, dimension);
        this.mTimeIndex = dimension - 1;
        this.mDeltaTime = bState[this.mTimeIndex] - aState[this.mTimeIndex];
    }

    @Override
    public double interpolate(double time, int index) {
        double theta = (time - this.getLeft()) / this.mDeltaTime;
        double minus1 = theta - 1.0;
        double prod1 = theta * minus1;
        double prod2 = prod1 * (1.0 - 2.0 * theta);
        double coefX0 = -minus1 - prod2;
        double coefX1 = theta + prod2;
        double coefF0 = prod1 * minus1 * this.mDeltaTime;
        double coefF1 = prod1 * theta * this.mDeltaTime;
        return coefX0 * this.mLeftState[index] + coefX1 * this.mRightState[index] + coefF0 * this.mLeftRate[index] + coefF1 * this.mRightRate[index];
    }

    @Override
    public double[] interpolate(double time, double[] state, int beginIndex, int length) {
        this.hermite((time - this.getLeft()) / this.mDeltaTime, state, beginIndex, length);
        return state;
    }

    protected final void hermite(double theta, double[] state, int beginIndex, int length) {
        double minus1 = theta - 1.0;
        double prod1 = theta * minus1;
        double prod2 = prod1 * (1.0 - 2.0 * theta);
        double coefX0 = -minus1 - prod2;
        double coefX1 = theta + prod2;
        double coefF0 = prod1 * minus1 * this.mDeltaTime;
        double coefF1 = prod1 * theta * this.mDeltaTime;
        int index = beginIndex;
        int i = 0;
        while (i < length) {
            state[i] = coefX0 * this.mLeftState[index] + coefX1 * this.mRightState[index] + coefF0 * this.mLeftRate[index] + coefF1 * this.mRightRate[index];
            ++index;
            ++i;
        }
    }
}

