/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.ode_interpolation;

import org.opensourcephysics.numerics.ode_interpolation.IntervalData;

public class EulerIntervalData
extends IntervalData {
    private double[] mLeftState;
    private double[] mLeftRate;

    public EulerIntervalData(double[] aState, double[] aRate, double right) {
        super(aState[aState.length - 1], right);
        int dimension = aState.length;
        this.mLeftState = new double[dimension];
        this.mLeftRate = new double[dimension];
        System.arraycopy(aState, 0, this.mLeftState, 0, dimension);
        System.arraycopy(aRate, 0, this.mLeftRate, 0, dimension);
    }

    @Override
    public double interpolate(double time, int index) {
        double step = time - this.getLeft();
        return this.mLeftState[index] + step * this.mLeftRate[index];
    }

    @Override
    public double[] interpolate(double time, double[] state, int beginIndex, int length) {
        double step = time - this.getLeft();
        int index = beginIndex;
        int i = 0;
        while (i < length) {
            state[i] = this.mLeftState[index] + step * this.mLeftRate[index];
            ++index;
            ++i;
        }
        return state;
    }
}

