/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.ode_interpolation;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ode_interpolation.HermiteIntervalData;

public class BootstrapIntervalData
extends HermiteIntervalData {
    private static final double ALPHA = 0.25;
    private static final double bt1_den = 0.1875;
    private static final double bt1_cf1 = 0.3125;
    private static final double bt1_cf0 = -0.1875;
    private static final double bt1_cys = -1.125;
    protected ODE mODE;
    private double[] state_bt1 = null;
    private double[] rate_bt1;
    private double[] bt1_c2;
    private double[] bt1_c3;
    private double[] bt1_c4;

    public BootstrapIntervalData(double[] aState, double[] aRate, double[] bState, double[] bRate, ODE ode) {
        super(aState, aRate, bState, bRate);
        this.mODE = ode;
        this.prepareFirstBootstrap();
    }

    @Override
    public double interpolate(double time, int index) {
        double step = (time - this.getLeft()) / this.mDeltaTime;
        return this.mLeftState[index] + step * (this.mDeltaTime * this.mLeftRate[index] + step * (this.bt1_c2[index] + step * (this.bt1_c3[index] + step * this.bt1_c4[index])));
    }

    @Override
    public double[] interpolate(double time, double[] state, int beginIndex, int length) {
        this.bootstrap1((time - this.getLeft()) / this.mDeltaTime, state, beginIndex, length);
        return state;
    }

    protected void bootstrap1(double step, double[] state, int beginIndex, int length) {
        int index = beginIndex;
        int i = 0;
        while (i < length) {
            state[i] = this.mLeftState[index] + step * (this.mDeltaTime * this.mLeftRate[index] + step * (this.bt1_c2[index] + step * (this.bt1_c3[index] + step * this.bt1_c4[index])));
            ++index;
            ++i;
        }
    }

    private void prepareFirstBootstrap() {
        int dimension = this.mTimeIndex + 1;
        if (this.state_bt1 == null) {
            this.state_bt1 = new double[dimension];
            this.rate_bt1 = new double[dimension];
            this.bt1_c2 = new double[dimension];
            this.bt1_c3 = new double[dimension];
            this.bt1_c4 = new double[dimension];
        }
        super.hermite(0.25, this.state_bt1, 0, this.mTimeIndex);
        this.state_bt1[this.mTimeIndex] = this.getLeft() + 0.25 * this.mDeltaTime;
        this.mODE.getRate(this.state_bt1, this.rate_bt1);
        int i = 0;
        while (i < dimension) {
            double dif = this.mRightState[i] - this.mLeftState[i];
            double f0 = this.mDeltaTime * this.mLeftRate[i];
            double f1 = this.mDeltaTime * this.mRightRate[i];
            double c4 = (this.mDeltaTime * this.rate_bt1[i] + 0.3125 * f1 + -0.1875 * f0 + -1.125 * dif) / 0.1875;
            double c3 = f1 + f0 - 2.0 * dif - 2.0 * c4;
            this.bt1_c4[i] = c4;
            this.bt1_c3[i] = c3;
            this.bt1_c2[i] = dif - f0 - c3 - c4;
            ++i;
        }
    }
}

