/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.utils;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.opensourcephysics.drawing3d.DrawingPanel3D;

public class VisualizationHints {
    public static final int HINT_DECORATION_TYPE = 0;
    public static final int HINT_REMOVE_HIDDEN_LINES = 1;
    public static final int HINT_ALLOW_QUICK_REDRAW = 2;
    public static final int HINT_USE_COLOR_DEPTH = 3;
    public static final int HINT_CURSOR_TYPE = 4;
    public static final int HINT_SHOW_COORDINATES = 5;
    public static final int HINT_AXES_LABELS = 6;
    public static final int HINT_BACKGROUND_IMAGE = 7;
    public static final int HINT_BACKGROUND_MOVEABLE = 8;
    public static final int HINT_BACKGROUND_SCALE = 9;
    public static final int HINT_COLORS = 10;
    public static final int HINT_FONT = 11;
    public static final int HINT_DEFAULT_ILLUMINATION = 12;
    public static final int HINT_ANY = -1;
    public static final int DECORATION_NONE = 0;
    public static final int DECORATION_AXES = 1;
    public static final int DECORATION_CUBE = 2;
    public static final int DECORATION_CENTERED_AXES = 3;
    public static final int CURSOR_NONE = 0;
    public static final int CURSOR_XYZ = 1;
    public static final int CURSOR_CUBE = 2;
    public static final int CURSOR_CROSSHAIR = 3;
    private boolean removeHiddenLines = true;
    private boolean allowQuickRedraw = true;
    private boolean useColorDepth = true;
    private int cursorType = 1;
    private int showCoordinates = 0;
    private int decorationType = 2;
    private String formatX = "x = 0.00;x = -0.00";
    private String formatY = "y = 0.00;y = -0.00";
    private String formatZ = "z = 0.00;z = -0.00";
    private String[] axesLabels = new String[]{"X", "Y", "Z"};
    private String backgroundImageFilename = null;
    private Image backgroundImage = null;
    private Dimension backgroundTile = null;
    private boolean backgroundMoveable = true;
    private double scaleBackground = 0.0;
    private Color backgroundColor = new Color(239, 239, 255);
    private Color foregroundColor = Color.BLACK;
    private Font font = new Font("Dialog", 0, 12);
    private boolean ilumination = true;
    private NumberFormat theFormatX = new DecimalFormat(this.formatX);
    private NumberFormat theFormatY = new DecimalFormat(this.formatY);
    private NumberFormat theFormatZ = new DecimalFormat(this.formatZ);
    private DrawingPanel3D panel;

    public VisualizationHints(DrawingPanel3D _panel) {
        this.panel = _panel;
    }

    public void setBackgroundColor(Color _color) {
        if (_color == null || _color.equals(this.backgroundColor)) {
            return;
        }
        this.backgroundColor = _color;
        this.panel.hintChanged(10);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setForegroundColor(Color _color) {
        if (_color == null || _color.equals(this.foregroundColor)) {
            return;
        }
        this.foregroundColor = _color;
        this.panel.hintChanged(10);
    }

    public Color getForegroundColor() {
        return this.foregroundColor;
    }

    public void setFont(Font _font) {
        if (_font == null || _font.equals(this.font)) {
            return;
        }
        this.font = _font;
        this.panel.hintChanged(11);
    }

    public Font getFont() {
        return this.font;
    }

    public void setCursorType(int _type) {
        this.cursorType = _type;
        this.panel.hintChanged(4);
    }

    public final int getCursorType() {
        return this.cursorType;
    }

    public void setDecorationType(int _value) {
        this.decorationType = _value;
        this.panel.hintChanged(0);
    }

    public final int getDecorationType() {
        return this.decorationType;
    }

    public final void setAxesLabels(String[] labels) {
        this.axesLabels = labels;
        this.panel.hintChanged(6);
    }

    public final String[] getAxesLabels() {
        return this.axesLabels;
    }

    public void setRemoveHiddenLines(boolean _value) {
        this.removeHiddenLines = _value;
        this.panel.hintChanged(1);
    }

    public final boolean isRemoveHiddenLines() {
        return this.removeHiddenLines;
    }

    public void setAllowQuickRedraw(boolean _value) {
        this.allowQuickRedraw = _value;
        this.panel.hintChanged(2);
    }

    public final boolean isAllowQuickRedraw() {
        return this.allowQuickRedraw;
    }

    public void setUseColorDepth(boolean _value) {
        this.useColorDepth = _value;
        this.panel.hintChanged(3);
    }

    public final boolean isUseColorDepth() {
        return this.useColorDepth;
    }

    public void setShowCoordinates(int location) {
        this.showCoordinates = location;
        this.panel.hintChanged(5);
    }

    public int getShowCoordinates() {
        return this.showCoordinates;
    }

    public void setXFormat(String format) {
        this.formatX = format;
        if (this.formatX != null) {
            this.theFormatX = new DecimalFormat(this.formatX);
        }
    }

    public String getXFormat() {
        return this.formatX;
    }

    public void setYFormat(String format) {
        this.formatY = format;
        if (this.formatY != null) {
            this.theFormatY = new DecimalFormat(this.formatY);
        }
    }

    public String getYFormat() {
        return this.formatY;
    }

    public void setZFormat(String format) {
        this.formatZ = format;
        if (this.formatZ != null) {
            this.theFormatZ = new DecimalFormat(this.formatZ);
        }
    }

    public String getZFormat() {
        return this.formatZ;
    }

    public void setBackgroundImage(String _imageFile) {
        this.backgroundImageFilename = _imageFile;
        this.backgroundImage = null;
        this.panel.hintChanged(7);
    }

    public final String getBackgroundImageFilename() {
        return this.backgroundImageFilename;
    }

    public void setBackgroundImage(Image _image) {
        this.backgroundImageFilename = null;
        this.backgroundImage = _image;
        this.panel.hintChanged(7);
    }

    public final Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundSize(Dimension _tile) {
        if (_tile != null && this.backgroundTile.height == _tile.height && this.backgroundTile.width == _tile.width) {
            return;
        }
        this.backgroundTile = _tile;
        this.panel.hintChanged(7);
    }

    public final Dimension getBackgroundTile() {
        return this.backgroundTile;
    }

    public void setBackgroundMoveable(boolean _state) {
        if (this.backgroundMoveable == _state) {
            return;
        }
        this.backgroundMoveable = _state;
        this.panel.hintChanged(8);
    }

    public final boolean getBackgroundMoveable() {
        if (this.backgroundImage != null) {
            return false;
        }
        return this.backgroundMoveable;
    }

    public void setScaleBackground(double _factor) {
        if (this.scaleBackground == _factor) {
            return;
        }
        this.scaleBackground = _factor;
        this.panel.hintChanged(9);
    }

    public final double getScaleBackground() {
        return this.scaleBackground;
    }

    public void setDefaultIllumination(boolean _state) {
        if (this.ilumination == _state) {
            return;
        }
        this.ilumination = _state;
        this.panel.hintChanged(12);
    }

    public final boolean getDefaultIllumination() {
        return this.ilumination;
    }

    public void displayPosition(int projectionMode, double[] point) {
        if (this.showCoordinates < 0) {
            return;
        }
        if (point == null) {
            this.panel.getImplementingPanel().setMessage(null, this.showCoordinates);
            return;
        }
        String text = "";
        switch (projectionMode) {
            case 0: {
                if (this.formatX != null) {
                    text = this.theFormatX.format(point[0]);
                }
                if (this.formatY == null) break;
                text = String.valueOf(text) + ", " + this.theFormatY.format(point[1]);
                break;
            }
            case 1: {
                if (this.formatX != null) {
                    text = this.theFormatX.format(point[0]);
                }
                if (this.formatZ == null) break;
                text = String.valueOf(text) + ", " + this.theFormatZ.format(point[2]);
                break;
            }
            case 2: {
                if (this.formatY != null) {
                    text = this.theFormatY.format(point[1]);
                }
                if (this.formatZ == null) break;
                text = String.valueOf(text) + ", " + this.theFormatZ.format(point[2]);
                break;
            }
            default: {
                if (this.formatX != null) {
                    text = this.theFormatX.format(point[0]);
                }
                if (this.formatY != null) {
                    text = String.valueOf(text) + ", " + this.theFormatY.format(point[1]);
                }
                if (this.formatZ == null) break;
                text = String.valueOf(text) + ", " + this.theFormatZ.format(point[2]);
            }
        }
        if (text.startsWith(", ")) {
            text = text.substring(2);
        }
        this.panel.getImplementingPanel().setMessage(text, this.showCoordinates);
    }

    public void copyFrom(VisualizationHints hints) {
        this.decorationType = hints.getDecorationType();
        this.cursorType = hints.getCursorType();
        this.axesLabels = hints.getAxesLabels();
        this.removeHiddenLines = hints.isRemoveHiddenLines();
        this.allowQuickRedraw = hints.isAllowQuickRedraw();
        this.useColorDepth = hints.isUseColorDepth();
        this.showCoordinates = hints.getShowCoordinates();
        this.formatX = hints.getXFormat();
        if (this.formatX != null) {
            this.theFormatX = new DecimalFormat(this.formatX);
        }
        this.formatZ = hints.getYFormat();
        if (this.formatY != null) {
            this.theFormatY = new DecimalFormat(this.formatY);
        }
        this.formatZ = hints.getZFormat();
        if (this.formatZ != null) {
            this.theFormatZ = new DecimalFormat(this.formatZ);
        }
        this.backgroundImageFilename = hints.getBackgroundImageFilename();
        this.backgroundImage = hints.getBackgroundImage();
        this.panel.hintChanged(-1);
    }
}

