/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.simple3d;

import org.opensourcephysics.drawing3d.ElementPlane;
import org.opensourcephysics.drawing3d.simple3d.SimpleAbstractTile;
import org.opensourcephysics.drawing3d.utils.Resolution;

public class SimpleElementPlane
extends SimpleAbstractTile {
    public static final int RECOMPUTE_PLANE = 28;

    public SimpleElementPlane(ElementPlane _element) {
        super(_element);
    }

    @Override
    public void processChanges(int _change, int _cummulativeChange) {
        if ((_cummulativeChange & 0x1C) != 0) {
            this.computeVertex();
            this.computeCoordinates();
            this.projectPoints();
        } else if ((_cummulativeChange & 0x136) != 0) {
            this.computeCoordinates();
            this.projectPoints();
        } else if ((_cummulativeChange & 0x40) != 0) {
            this.projectPoints();
        }
    }

    @Override
    protected double[][][] computeTile() {
        ElementPlane plane = (ElementPlane)this.element;
        int nx = 1;
        int ny = 1;
        Resolution res = this.style.getResolution();
        if (res != null) {
            switch (res.getType()) {
                case 0: {
                    nx = Math.max(res.getN1(), 1);
                    ny = Math.max(res.getN2(), 1);
                    break;
                }
                case 1: {
                    nx = Math.max((int)Math.round(0.49 + Math.abs(plane.getFirstSize()) / res.getMaxLength()), 1);
                    ny = Math.max((int)Math.round(0.49 + Math.abs(plane.getSecondSize()) / res.getMaxLength()), 1);
                }
            }
        }
        return ElementPlane.createPlane(plane, nx, ny);
    }
}

