/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.dialogs.DialogsRes;

public class AutoScaleInspector
extends JDialog {
    protected DrawingPanel plotPanel;
    protected JPanel dataPanel;
    protected JCheckBox xAutoscaleCheckBox;
    protected JCheckBox yAutoscaleCheckBox;
    protected JButton okButton;

    public AutoScaleInspector(DrawingPanel drawingPanel) {
        super((Frame)null, true);
        this.plotPanel = drawingPanel;
        this.setTitle(DialogsRes.AUTOSCALE_AUTOSCALE);
        this.setResizable(false);
        this.createGUI();
        this.pack();
    }

    private void createGUI() {
        this.xAutoscaleCheckBox = new JCheckBox(String.valueOf(DialogsRes.AUTOSCALE_AUTO) + " x");
        this.xAutoscaleCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AutoScaleInspector.this.plotPanel.setAutoscaleX(AutoScaleInspector.this.xAutoscaleCheckBox.isSelected());
                AutoScaleInspector.this.plotPanel.scale();
                AutoScaleInspector.this.updateDisplay();
                AutoScaleInspector.this.plotPanel.repaint();
            }
        });
        this.yAutoscaleCheckBox = new JCheckBox(String.valueOf(DialogsRes.AUTOSCALE_AUTO) + " y");
        this.yAutoscaleCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AutoScaleInspector.this.plotPanel.setAutoscaleY(AutoScaleInspector.this.yAutoscaleCheckBox.isSelected());
                AutoScaleInspector.this.plotPanel.scale();
                AutoScaleInspector.this.updateDisplay();
                AutoScaleInspector.this.plotPanel.repaint();
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        this.setContentPane(jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel2, "South");
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
        jPanel3.setBorder(BorderFactory.createTitledBorder(DialogsRes.AUTOSCALE_ZOOM_WARNING));
        this.dataPanel = new JPanel(new GridLayout(1, 1));
        this.dataPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel2.add((Component)this.dataPanel, "Center");
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        jPanel3.add(this.xAutoscaleCheckBox);
        jPanel3.add(box);
        box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        jPanel3.add(box);
        box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        jPanel3.add(this.yAutoscaleCheckBox);
        this.dataPanel.add(jPanel3);
        this.xAutoscaleCheckBox.setAlignmentX(1.0f);
        this.yAutoscaleCheckBox.setAlignmentX(1.0f);
        this.okButton = new JButton(DialogsRes.AUTOSCALE_OK);
        this.okButton.setForeground(new Color(0, 0, 102));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AutoScaleInspector.this.setVisible(false);
            }
        });
        JPanel jPanel4 = new JPanel();
        jPanel2.add((Component)jPanel4, "South");
        jPanel4.add(this.okButton);
    }

    public void updateDisplay() {
        this.xAutoscaleCheckBox.setSelected(this.plotPanel.isAutoscaleX());
        this.yAutoscaleCheckBox.setSelected(this.plotPanel.isAutoscaleY());
    }
}

