/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing3d.utils;

import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.drawing3d.ControlElement3D;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.drawing3d.Element;
import org.opensourcephysics.drawing3d.utils.TransformationWrapper;
import org.opensourcephysics.numerics.Transformation;

public abstract class ControlTransformation3D
extends ControlElement
implements TransformationWrapper {
    public static final int TR3D_NAME = 0;
    public static final int TR3D_PARENT = 1;
    public static final int TR3D_ENABLED = 2;
    protected boolean enabled = true;
    protected Transformation transformation = this.createTransformation();
    protected ControlElement3D myParent = null;
    private static List<String> infoList = null;

    protected ControlTransformation3D() {
    }

    protected abstract Transformation createTransformation();

    @Override
    public Object getObject() {
        return this.transformation;
    }

    @Override
    public String getObjectClassname() {
        return "org.opensourcephysics.numerics.Transformation";
    }

    public final void setParent(ControlElement3D _dp) {
        if (this.myParent != null) {
            this.myParent.getElement().removeSecondaryTransformation(this);
            this.setAffectedElement(null);
        }
        if (_dp != null) {
            this.myParent = _dp;
            String indexInParent = this.getProperty("_ejs_indexInParent_");
            int index = -1;
            if (indexInParent != null) {
                index = Integer.parseInt(indexInParent);
            }
            this.setProperty("_ejs_indexInParent_", null);
            if (index >= 0) {
                this.myParent.getElement().addSecondaryTransformation(this, index);
            } else {
                this.myParent.getElement().addSecondaryTransformation(this);
            }
            this.setAffectedElement(this.myParent.getElement());
            this.myParent.updatePanel();
        }
    }

    protected void setAffectedElement(Element element) {
    }

    public final ControlElement3D getParent() {
        return this.myParent;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("name");
            infoList.add("parent");
            infoList.add("enabled");
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("name")) {
            return "String CONSTANT";
        }
        if (_property.equals("parent")) {
            return "ControlElement CONSTANT";
        }
        if (_property.equals("enabled")) {
            return "boolean";
        }
        return null;
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                super.setValue(0, _value);
                break;
            }
            case 1: {
                ControlElement parent = this.myGroup.getElement(this.getProperty("parent"));
                if (parent != null) {
                    this.setParent(null);
                }
                if ((parent = this.myGroup.getElement(_value.toString())) == null) {
                    System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Parent <" + _value + "> not found for " + this.toString());
                    break;
                }
                if (parent instanceof ControlElement3D) {
                    this.setParent((ControlElement3D)parent);
                    break;
                }
                System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Parent <" + _value + "> is not a ControlElements3DParent");
                break;
            }
            case 2: {
                this.enabled = _value.getBoolean();
                if (this.myParent == null) break;
                this.myParent.getElement().addChange(256);
                break;
            }
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                super.setDefaultValue(0);
                break;
            }
            case 1: {
                if (this.myGroup.getElement(this.getProperty("parent")) == null) break;
                this.setParent(null);
                break;
            }
            case 2: {
                this.enabled = true;
                if (this.myParent == null) break;
                this.myParent.getElement().addChange(256);
                break;
            }
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: 
            case 1: {
                return "<none>";
            }
            case 2: {
                return "true";
            }
        }
        return "<none>";
    }

    @Override
    public Value getValue(int _index) {
        return null;
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public final void setEnabled(boolean _enabled) {
        this.enabled = _enabled;
    }

    @Override
    public final Transformation getTransformation() {
        return this.transformation;
    }

    @Override
    public abstract Object clone();
}

